/*
 * Copyright (C) 2016 The Qt Company Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import QtQuick 2.6
import QtQuick.Layouts 1.1
import QtQuick.Controls 2.0
import AGL.Demo.Controls 1.0
import '..'

SettingPage {
    id: root
    icon: '/datetime/images/HMI_Settings_TimeIcon.svg'
    title: 'Date & Time'

    ColumnLayout {
        anchors.fill: parent
        anchors.margins: 100
        Label { text: 'Date'}
        DateEdit {}
        Image {
            source: '../images/HMI_Settings_DividingLine.svg'
        }
        Label { text: 'Time'}
        TimeEdit {}
        RowLayout {
            anchors.right: parent.right
            Button {
                text: 'OK'
                highlighted: true
                onClicked: root.done()
            }
        }
        Item {
            Layout.fillHeight: true
        }
    }
}
