# Concepts

A user application requests to open an audio role, which is bound to a stream,
which is bound to a zone. This allows the application to only care about the
audio role.

For example, a navigation application can request the **navigation** role, which
is bound to the **navigation** stream defined by the HAL. This stream is bound
to the **driver** zone, which is the closest speaker to the driver.

## Roles

The high level API allows applications to open roles such as **emergency**,
**navigation** or **multimedia**. A role is bound to a stream, which is
basically a device URI. When a role is opened, then the policy engine is
notified and executes an interrupt on every other opened role with a lower
priority. An interrupt is a policy engine function that can change the volume,
mute or unmute, change the stream's state.

This behaviour allows the policy engine to take actions like lowering the radio
volume when an application wants to play something on the emergency role.

## Streams

A stream is basically a device URI that you can open to write audio data. For
example, it can be "hw:2,0,1", which means that you have to use this as an alsa
device URI.

## Zones

Multiple speakers are spread around inside a vehicule, they are named depending
on their position, like **front-center**, **front-left**, **front-right**,
**rear-left**, **rear-right**, etc...

Zones are an abstraction of positional audio. A zone is made of one or more
speakers and describes logical audio areas like **driver**, **front**, **rear**,
etc.
