# High Level API

The High Level API provides an abstraction of audio roles.

## Configuration

Here is a sample configuration.

```json
{
    "$schema": "http://iot.bzh/download/public/schema/json/ctl-schema.json",
    "metadata": {
        "uid": "4a-policy",
        "version": "0.1",
        "api": "4a-policy",
        "require": [],
        "info": "Basic Audio Policy Control for Audio-4a - Sample 1",
        "author": "Loïc Collignon <loic.collignon@iot.bzh>",
        "date": "2018-05-25"
    },
    "onload": [],
    "controls": [],
    "events": [],
    "roles":[
        {
            "uid": "radio",
            "description": "Radio (tuner)",
            "priority": 0,
            "stream": "radio_stream"
        },
        {
            "uid": "multimedia",
            "description": "Multimedia content (e.g. media player, etc.)",
            "priority": 0,
            "stream": "multimedia"
        },
        {
            "uid": "emergency",
            "description": "Safety-relevant or critical alerts/alarms",
            "priority": 100,
            "stream": "emergency",
            "interrupts":[
                {
                    "type": "ramp",
                    "args": { "uid": "ramp-slow", "volume": 30}
                }
            ]
        },
        {
            "uid": "navigation",
            "name": "navigation",
            "description": "Navigation instructions (GPS, directions, etc.)",
            "priority": 25,
            "stream": "navigation",
            "interrupts":[
                {
                    "type": "ramp",
                    "args": { "uid": "ramp-slow", "volume": 30}
                }
            ]
        }
    ]
}
```

Each defined roles should have a stream associated. This stream will be
provided by HALs. If no HAL provides the stream, then the audio role will have
no device URI. If multiple HALs provide the same stream, a race condition
occurs, the first HAL found will be used, the next will be ignored.

A higher value means a higher priority. In this sample, the **emergency** role
has a higher priority than the **navigation**.

>**NOTE:** In this sample there is only one stream per role and it's named
>after the corresponding role, but none of this is mandatory.

## Policy engine

Policy engine is provided as a controller plugin for the high level API.
Currently, the sample policy engine only support the **ramp** interruption.
