/*
 * Copyright (C) 2012-2017 ARM Limited or its affiliates.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __DX_ENV_H__
#define __DX_ENV_H__

// --------------------------------------
// BLOCK: FPGA_ENV_REGS
// --------------------------------------
#define DX_ENV_PKA_DEBUG_MODE_REG_OFFSET 	0x024UL 
#define DX_ENV_PKA_DEBUG_MODE_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_PKA_DEBUG_MODE_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_SCAN_MODE_REG_OFFSET 	0x030UL 
#define DX_ENV_SCAN_MODE_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_SCAN_MODE_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_CC_ALLOW_SCAN_REG_OFFSET 	0x034UL 
#define DX_ENV_CC_ALLOW_SCAN_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_ALLOW_SCAN_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_CC_HOST_INT_REG_OFFSET 	0x0A0UL 
#define DX_ENV_CC_HOST_INT_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_HOST_INT_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_CC_PUB_HOST_INT_REG_OFFSET 	0x0A4UL 
#define DX_ENV_CC_PUB_HOST_INT_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_PUB_HOST_INT_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_CC_RST_N_REG_OFFSET 	0x0A8UL 
#define DX_ENV_CC_RST_N_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_RST_N_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_RST_OVERRIDE_REG_OFFSET 	0x0ACUL 
#define DX_ENV_RST_OVERRIDE_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_RST_OVERRIDE_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_CC_POR_N_ADDR_REG_OFFSET 	0x0E0UL 
#define DX_ENV_CC_POR_N_ADDR_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_POR_N_ADDR_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_CC_COLD_RST_REG_OFFSET 	0x0FCUL 
#define DX_ENV_CC_COLD_RST_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_COLD_RST_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_DUMMY_ADDR_REG_OFFSET 	0x108UL 
#define DX_ENV_DUMMY_ADDR_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_DUMMY_ADDR_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_COUNTER_CLR_REG_OFFSET 	0x118UL 
#define DX_ENV_COUNTER_CLR_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_COUNTER_CLR_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_COUNTER_RD_REG_OFFSET 	0x11CUL 
#define DX_ENV_COUNTER_RD_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_COUNTER_RD_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_RNG_DEBUG_ENABLE_REG_OFFSET 	0x430UL 
#define DX_ENV_RNG_DEBUG_ENABLE_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_RNG_DEBUG_ENABLE_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_CC_LCS_REG_OFFSET 	0x43CUL 
#define DX_ENV_CC_LCS_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_LCS_VALUE_BIT_SIZE 	0x8UL
#define DX_ENV_CC_IS_CM_DM_SECURE_RMA_REG_OFFSET 	0x440UL 
#define DX_ENV_CC_IS_CM_DM_SECURE_RMA_IS_CM_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_IS_CM_DM_SECURE_RMA_IS_CM_BIT_SIZE 	0x1UL
#define DX_ENV_CC_IS_CM_DM_SECURE_RMA_IS_DM_BIT_SHIFT 	0x1UL
#define DX_ENV_CC_IS_CM_DM_SECURE_RMA_IS_DM_BIT_SIZE 	0x1UL
#define DX_ENV_CC_IS_CM_DM_SECURE_RMA_IS_SECURE_BIT_SHIFT 	0x2UL
#define DX_ENV_CC_IS_CM_DM_SECURE_RMA_IS_SECURE_BIT_SIZE 	0x1UL
#define DX_ENV_CC_IS_CM_DM_SECURE_RMA_IS_RMA_BIT_SHIFT 	0x3UL
#define DX_ENV_CC_IS_CM_DM_SECURE_RMA_IS_RMA_BIT_SIZE 	0x1UL
#define DX_ENV_DCU_EN_REG_OFFSET 	0x444UL 
#define DX_ENV_DCU_EN_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_DCU_EN_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_CC_LCS_IS_VALID_REG_OFFSET 	0x448UL 
#define DX_ENV_CC_LCS_IS_VALID_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_LCS_IS_VALID_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_POWER_DOWN_REG_OFFSET 	0x478UL 
#define DX_ENV_POWER_DOWN_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_POWER_DOWN_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_DCU_H_EN_REG_OFFSET 	0x484UL 
#define DX_ENV_DCU_H_EN_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_DCU_H_EN_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_VERSION_REG_OFFSET 	0x488UL 
#define DX_ENV_VERSION_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_VERSION_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_ROSC_WRITE_REG_OFFSET 	0x48CUL 
#define DX_ENV_ROSC_WRITE_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_ROSC_WRITE_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_ROSC_ADDR_REG_OFFSET 	0x490UL 
#define DX_ENV_ROSC_ADDR_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_ROSC_ADDR_VALUE_BIT_SIZE 	0x8UL
#define DX_ENV_RESET_SESSION_KEY_REG_OFFSET 	0x494UL 
#define DX_ENV_RESET_SESSION_KEY_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_RESET_SESSION_KEY_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_SESSION_KEY_0_REG_OFFSET 	0x4A0UL 
#define DX_ENV_SESSION_KEY_0_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_SESSION_KEY_0_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_SESSION_KEY_1_REG_OFFSET 	0x4A4UL 
#define DX_ENV_SESSION_KEY_1_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_SESSION_KEY_1_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_SESSION_KEY_2_REG_OFFSET 	0x4A8UL 
#define DX_ENV_SESSION_KEY_2_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_SESSION_KEY_2_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_SESSION_KEY_3_REG_OFFSET 	0x4ACUL 
#define DX_ENV_SESSION_KEY_3_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_SESSION_KEY_3_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_SESSION_KEY_VALID_REG_OFFSET 	0x4B0UL 
#define DX_ENV_SESSION_KEY_VALID_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_SESSION_KEY_VALID_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_SPIDEN_REG_OFFSET 	0x4D0UL 
#define DX_ENV_SPIDEN_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_SPIDEN_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_AXIM_USER_PARAMS_REG_OFFSET 	0x600UL 
#define DX_ENV_AXIM_USER_PARAMS_ARUSER_BIT_SHIFT 	0x0UL
#define DX_ENV_AXIM_USER_PARAMS_ARUSER_BIT_SIZE 	0x5UL
#define DX_ENV_AXIM_USER_PARAMS_AWUSER_BIT_SHIFT 	0x5UL
#define DX_ENV_AXIM_USER_PARAMS_AWUSER_BIT_SIZE 	0x5UL
#define DX_ENV_SECURITY_MODE_OVERRIDE_REG_OFFSET 	0x604UL 
#define DX_ENV_SECURITY_MODE_OVERRIDE_AWPROT_NS_BIT_BIT_SHIFT 	0x0UL
#define DX_ENV_SECURITY_MODE_OVERRIDE_AWPROT_NS_BIT_BIT_SIZE 	0x1UL
#define DX_ENV_SECURITY_MODE_OVERRIDE_AWPROT_NS_OVERRIDE_BIT_SHIFT 	0x1UL
#define DX_ENV_SECURITY_MODE_OVERRIDE_AWPROT_NS_OVERRIDE_BIT_SIZE 	0x1UL
#define DX_ENV_SECURITY_MODE_OVERRIDE_ARPROT_NS_BIT_BIT_SHIFT 	0x2UL
#define DX_ENV_SECURITY_MODE_OVERRIDE_ARPROT_NS_BIT_BIT_SIZE 	0x1UL
#define DX_ENV_SECURITY_MODE_OVERRIDE_ARPROT_NS_OVERRIDE_BIT_SHIFT 	0x3UL
#define DX_ENV_SECURITY_MODE_OVERRIDE_ARPROT_NS_OVERRIDE_BIT_SIZE 	0x1UL
#define DX_ENV_AO_CC_KPLT_0_REG_OFFSET 	0x620UL 
#define DX_ENV_AO_CC_KPLT_0_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_AO_CC_KPLT_0_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_AO_CC_KPLT_1_REG_OFFSET 	0x624UL 
#define DX_ENV_AO_CC_KPLT_1_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_AO_CC_KPLT_1_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_AO_CC_KPLT_2_REG_OFFSET 	0x628UL 
#define DX_ENV_AO_CC_KPLT_2_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_AO_CC_KPLT_2_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_AO_CC_KPLT_3_REG_OFFSET 	0x62CUL 
#define DX_ENV_AO_CC_KPLT_3_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_AO_CC_KPLT_3_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_AO_CC_KCST_0_REG_OFFSET 	0x630UL 
#define DX_ENV_AO_CC_KCST_0_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_AO_CC_KCST_0_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_AO_CC_KCST_1_REG_OFFSET 	0x634UL 
#define DX_ENV_AO_CC_KCST_1_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_AO_CC_KCST_1_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_AO_CC_KCST_2_REG_OFFSET 	0x638UL 
#define DX_ENV_AO_CC_KCST_2_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_AO_CC_KCST_2_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_AO_CC_KCST_3_REG_OFFSET 	0x63CUL 
#define DX_ENV_AO_CC_KCST_3_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_AO_CC_KCST_3_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_APB_FIPS_ADDR_REG_OFFSET 	0x650UL 
#define DX_ENV_APB_FIPS_ADDR_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APB_FIPS_ADDR_VALUE_BIT_SIZE 	0xCUL
#define DX_ENV_APB_FIPS_VAL_REG_OFFSET 	0x654UL 
#define DX_ENV_APB_FIPS_VAL_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APB_FIPS_VAL_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_APB_FIPS_MASK_REG_OFFSET 	0x658UL 
#define DX_ENV_APB_FIPS_MASK_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APB_FIPS_MASK_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_APB_FIPS_CNT_REG_OFFSET 	0x65CUL 
#define DX_ENV_APB_FIPS_CNT_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APB_FIPS_CNT_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_APB_FIPS_NEW_ADDR_REG_OFFSET 	0x660UL 
#define DX_ENV_APB_FIPS_NEW_ADDR_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APB_FIPS_NEW_ADDR_VALUE_BIT_SIZE 	0xCUL
#define DX_ENV_APB_FIPS_NEW_VAL_REG_OFFSET 	0x664UL 
#define DX_ENV_APB_FIPS_NEW_VAL_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APB_FIPS_NEW_VAL_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_APBP_FIPS_ADDR_REG_OFFSET 	0x670UL 
#define DX_ENV_APBP_FIPS_ADDR_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APBP_FIPS_ADDR_VALUE_BIT_SIZE 	0xCUL
#define DX_ENV_APBP_FIPS_VAL_REG_OFFSET 	0x674UL 
#define DX_ENV_APBP_FIPS_VAL_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APBP_FIPS_VAL_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_APBP_FIPS_MASK_REG_OFFSET 	0x678UL 
#define DX_ENV_APBP_FIPS_MASK_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APBP_FIPS_MASK_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_APBP_FIPS_CNT_REG_OFFSET 	0x67CUL 
#define DX_ENV_APBP_FIPS_CNT_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APBP_FIPS_CNT_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_APBP_FIPS_NEW_ADDR_REG_OFFSET 	0x680UL 
#define DX_ENV_APBP_FIPS_NEW_ADDR_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APBP_FIPS_NEW_ADDR_VALUE_BIT_SIZE 	0xCUL
#define DX_ENV_APBP_FIPS_NEW_VAL_REG_OFFSET 	0x684UL 
#define DX_ENV_APBP_FIPS_NEW_VAL_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_APBP_FIPS_NEW_VAL_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_CC_POWERDOWN_EN_REG_OFFSET 	0x690UL 
#define DX_ENV_CC_POWERDOWN_EN_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_POWERDOWN_EN_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_CC_POWERDOWN_RST_EN_REG_OFFSET 	0x694UL 
#define DX_ENV_CC_POWERDOWN_RST_EN_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_CC_POWERDOWN_RST_EN_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_POWERDOWN_RST_CNTR_REG_OFFSET 	0x698UL 
#define DX_ENV_POWERDOWN_RST_CNTR_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_POWERDOWN_RST_CNTR_VALUE_BIT_SIZE 	0x20UL
#define DX_ENV_POWERDOWN_EN_DEBUG_REG_OFFSET 	0x69CUL 
#define DX_ENV_POWERDOWN_EN_DEBUG_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_POWERDOWN_EN_DEBUG_VALUE_BIT_SIZE 	0x1UL
// --------------------------------------
// BLOCK: ENV_CC_MEMORIES
// --------------------------------------
#define DX_ENV_FUSE_READY_REG_OFFSET 	0x000UL 
#define DX_ENV_FUSE_READY_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_FUSE_READY_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_PERF_RAM_MASTER_REG_OFFSET 	0x0ECUL 
#define DX_ENV_PERF_RAM_MASTER_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_PERF_RAM_MASTER_VALUE_BIT_SIZE 	0x1UL
#define DX_ENV_PERF_RAM_ADDR_HIGH4_REG_OFFSET 	0x0F0UL 
#define DX_ENV_PERF_RAM_ADDR_HIGH4_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_PERF_RAM_ADDR_HIGH4_VALUE_BIT_SIZE 	0x2UL
#define DX_ENV_FUSES_RAM_REG_OFFSET 	0x3ECUL 
#define DX_ENV_FUSES_RAM_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_FUSES_RAM_VALUE_BIT_SIZE 	0x20UL
// --------------------------------------
// BLOCK: ENV_PERF_RAM_BASE
// --------------------------------------
#define DX_ENV_PERF_RAM_BASE_REG_OFFSET 	0x000UL 
#define DX_ENV_PERF_RAM_BASE_VALUE_BIT_SHIFT 	0x0UL
#define DX_ENV_PERF_RAM_BASE_VALUE_BIT_SIZE 	0x20UL

#endif /*__DX_ENV_H__*/
