; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s

; Check constant FP to signed integer conversions that overflow the integer type.

define i32 @constant_v2f64_to_i32() {
; CHECK-LABEL: constant_v2f64_to_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvtsd2si {{.*}}(%rip), %eax
; CHECK-NEXT:    retq
  %r = call i32 @llvm.x86.sse2.cvtsd2si(<2 x double> <double 5.0e+09, double undef>)
  ret i32 %r
}

define i32 @constant_v2f64_to_i32_round_to_zero() {
; CHECK-LABEL: constant_v2f64_to_i32_round_to_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvttsd2si {{.*}}(%rip), %eax
; CHECK-NEXT:    retq
  %r = call i32 @llvm.x86.sse2.cvttsd2si(<2 x double> <double 5.0e+09, double undef>)
  ret i32 %r
}

define i64 @constant_v2f64_to_i64() {
; CHECK-LABEL: constant_v2f64_to_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvtsd2si {{.*}}(%rip), %rax
; CHECK-NEXT:    retq
  %r = call i64 @llvm.x86.sse2.cvtsd2si64(<2 x double> <double 5.0e+19, double undef>)
  ret i64 %r
}

define i64 @constant_v2f64_to_i64_round_to_zero() {
; CHECK-LABEL: constant_v2f64_to_i64_round_to_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvttsd2si {{.*}}(%rip), %rax
; CHECK-NEXT:    retq
  %r = call i64 @llvm.x86.sse2.cvttsd2si64(<2 x double> <double 5.0e+19, double undef>)
  ret i64 %r
}

define <4 x i32> @constant_v2f64_to_v4i32() {
; CHECK-LABEL: constant_v2f64_to_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvtpd2dq {{.*}}(%rip), %xmm0
; CHECK-NEXT:    retq
  %r = call <4 x i32> @llvm.x86.sse2.cvtpd2dq(<2 x double> <double 5.0e+09, double 5.0e+09>)
  ret <4 x i32> %r
}

define <4 x i32> @constant_v2f64_to_v4i32_round_to_zero() {
; CHECK-LABEL: constant_v2f64_to_v4i32_round_to_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvttpd2dq {{.*}}(%rip), %xmm0
; CHECK-NEXT:    retq
  %r = call <4 x i32> @llvm.x86.sse2.cvttpd2dq(<2 x double> <double 5.0e+09, double 5.0e+09>)
  ret <4 x i32> %r
}

define i32 @constant_v4f32_to_i32() {
; CHECK-LABEL: constant_v4f32_to_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvtss2si {{.*}}(%rip), %eax
; CHECK-NEXT:    retq
  %r = call i32 @llvm.x86.sse.cvtss2si(<4 x float> <float 5.0e+09, float undef, float undef, float undef>)
  ret i32 %r
}

define i32 @constant_v4f32_to_i32_round_to_zero() {
; CHECK-LABEL: constant_v4f32_to_i32_round_to_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvttss2si {{.*}}(%rip), %eax
; CHECK-NEXT:    retq
  %r = call i32 @llvm.x86.sse.cvttss2si(<4 x float> <float 5.0e+09, float undef, float undef, float undef>)
  ret i32 %r
}

; 9223372036854775808.0 = 0x8000000000000000

define i64 @constant_v4f32_to_i64() {
; CHECK-LABEL: constant_v4f32_to_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvtss2si {{.*}}(%rip), %rax
; CHECK-NEXT:    retq
  %r = call i64 @llvm.x86.sse.cvtss2si64(<4 x float> <float 9223372036854775808.0, float undef, float undef, float undef>)
  ret i64 %r
}

define i64 @constant_v4f32_to_i64_round_to_zero() {
; CHECK-LABEL: constant_v4f32_to_i64_round_to_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvttss2si {{.*}}(%rip), %rax
; CHECK-NEXT:    retq
  %r = call i64 @llvm.x86.sse.cvttss2si64(<4 x float> <float 9223372036854775808.0, float undef, float undef, float undef>)
  ret i64 %r
}

define <4 x i32> @constant_v4f32_to_v4i32() {
; CHECK-LABEL: constant_v4f32_to_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvtps2dq {{.*}}(%rip), %xmm0
; CHECK-NEXT:    retq
  %r = call <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float> <float 5.0e+09, float 5.0e+09, float 5.0e+09, float 5.0e+09>)
  ret <4 x i32> %r
}

define <4 x i32> @constant_v4f32_to_v4i32_round_to_zero() {
; CHECK-LABEL: constant_v4f32_to_v4i32_round_to_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cvttps2dq {{.*}}(%rip), %xmm0
; CHECK-NEXT:    retq
  %r = call <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float> <float 5.0e+09, float 5.0e+09, float 5.0e+09, float 5.0e+09>)
  ret <4 x i32> %r
}

declare i32 @llvm.x86.sse2.cvtsd2si(<2 x double>)
declare i32 @llvm.x86.sse2.cvttsd2si(<2 x double>)

declare i64 @llvm.x86.sse2.cvtsd2si64(<2 x double>)
declare i64 @llvm.x86.sse2.cvttsd2si64(<2 x double>)

declare <4 x i32> @llvm.x86.sse2.cvtpd2dq(<2 x double>)
declare <4 x i32> @llvm.x86.sse2.cvttpd2dq(<2 x double>)

declare i32 @llvm.x86.sse.cvtss2si(<4 x float>)
declare i32 @llvm.x86.sse.cvttss2si(<4 x float>)

declare i64 @llvm.x86.sse.cvtss2si64(<4 x float>)
declare i64 @llvm.x86.sse.cvttss2si64(<4 x float>)

declare <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float>)
declare <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float>)

