/*
 * ROHM BD9574MWF-M driver
 *
 * Copyright (C) 2019 Renesas Electronics Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether expressed or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License version 2 for more details.
 *
 */

#ifndef __LINUX_MFD_BD9574MWF_H
#define __LINUX_MFD_BD9574MWF_H

/* List of registers for BD9574MWF */
#define BD9574MWF_VENDOR_CODE			0x00
#define BD9574MWF_VENDOR_CODE_VAL		0xdb
#define BD9574MWF_PRODUCT_CODE			0x01
#define BD9574MWF_PRODUCT_CODE_VAL		0x74
#define BD9574MWF_PRODUCT_REVISION		0x02

#define BD9574MWF_I2C_FUSA_MODE			0x10
#define BD9574MWF_I2C_MD2_E1_BIT_1		0x11
#define BD9574MWF_I2C_MD2_E1_BIT_2		0x12

#define BD9574MWF_BKUP_MODE_CNT			0x20
#define BD9574MWF_BKUP_MODE_STATUS		0x21
#define BD9574MWF_BKUP_RECOVERY_CNT		0x22
#define BD9574MWF_BKUP_CTRL_TIM_CNT		0x23
#define BD9574MWF_WAITBKUP_WDT_CNT		0x24
#define BD9574MWF_BKUP_HOLD_TIM_CNT1		0x26
#define BD9574MWF_QLLM_CNT			0x27
#define BD9574MWF_BKUP_HOLD_TIM_CNT2		0x28

#define BD9574MWF_DCDC_FREQ			0x48

#define BD9574MWF_VDCORE_VINIT			0x50
#define BD9574MWF_VD09_VINIT			0x51
#define BD9574MWF_VDCORE_SETVMAX		0x52
#define BD9574MWF_VDCORE_SETVID			0x54
#define BD9574MWF_VDCORE_MONIVDAC		0x55
#define BD9574MWF_VDCORE_PGD_CNT		0x56

#define BD9574MWF_GPIO_DIR			0x60
#define BD9574MWF_GPIO_OUT			0x61
#define BD9574MWF_GPIO_IN			0x62
#define BD9574MWF_GPIO_DEB			0x63
#define BD9574MWF_GPIO_INT_SET			0x64
#define BD9574MWF_GPIO_INT			0x65
#define BD9574MWF_GPIO_INTMASK			0x66
#define BD9574MWF_GPIO_MUX			0x67

#define BD9574MWF_REG_KEEP(n)			(0x70 + (n))

#define BD9574MWF_PMIC_INTERNAL_STATUS		0x80
#define BD9574MWF_PROT_ERROR_STATUS0		0x81
#define BD9574MWF_PROT_ERROR_STATUS1		0x82
#define BD9574MWF_PROT_ERROR_STATUS2		0x83
#define BD9574MWF_PROT_ERROR_STATUS3		0x84
#define BD9574MWF_PROT_ERROR_STATUS4		0x85
#define BD9574MWF_PROT_ERROR_STATUS5		0x86
#define BD9574MWF_SYS_ERROR_STATUS		0x87

#define BD9574MWF_INT_INTREQ			0x90
#define BD9574MWF_INT_INTREQ_MD1_INT		BIT(0)
#define BD9574MWF_INT_INTREQ_MD2_E1_INT		BIT(1)
#define BD9574MWF_INT_INTREQ_MD2_E2_INT		BIT(2)
#define BD9574MWF_INT_INTREQ_PROT_ERR_INT	BIT(3)
#define BD9574MWF_INT_INTREQ_GP_INT		BIT(4)
#define BD9574MWF_INT_INTREQ_BKUP_HOLD_OF_INT	BIT(5)
#define BD9574MWF_INT_INTREQ_WDT_OF_INT		BIT(6)
#define BD9574MWF_INT_INTREQ_BKUP_TRG_INT	BIT(7)
#define BD9574MWF_INT_INTMASK			0x91

#define BD9574MWF_SSCG_CNT			0xA0
#define BD9574MWF_POFFB_MRB			0xA1
#define BD9574MWF_SMRB_WR_PROT			0xA2
#define BD9574MWF_SMRB_ASSERT			0xA3
#define BD9574MWF_SMRB_STATUS			0xA4

#define BD9574MWF_PART_NUMBER			"BD9574MWF"

/* Define the BD9574MWF IRQ numbers */
enum bd9574mwf_irqs {
	BD9574MWF_IRQ_MD1,
	BD9574MWF_IRQ_MD2_E1,
	BD9574MWF_IRQ_MD2_E2,
	BD9574MWF_IRQ_PROT_ERR,
	BD9574MWF_IRQ_GP,
	BD9574MWF_IRQ_BKUP_HOLD_OF,
	BD9574MWF_IRQ_WDT_OF,
	BD9574MWF_IRQ_BKUP_TRG,
};

#endif /* __LINUX_MFD_BD9574MWF_H */
