# Controller

* Object: Generic Controller to handle Policy,Small Business Logic, Glue in between components, ...
* Status: Release Candidate
* Author: Fulup Ar Foll fulup@iot.bzh
* Date  : May-2018
* Require : af-binder version >= FF (handle only bindings v3)

## Features

* Create a controller application from a JSON config file
* Each control (eg: navigation, multimedia, ...) is a suite of actions. When all actions succeed
 control is granted, if one fails control access is denied.
* Actions can either be:
  * Invocation of an other binding API, either internal or external (eg: a policy service, Alsa UCM, ...)
  * C routines from a user provided plugin (eg: policy routine, proprietary code, ...)
  * Lua script function. Lua provides access to every AGL appfw functionality and can be extended by
   plugins written in C.

## Installation

* Controller can easily be included as a separate library in any AGL service or application binder.
* Dependencies: the only dependencies are [AGL application framework](https://gerrit.automotivelinux.org/gerrit/p/src/app-framework-binder.git)
 and [libafb-helpers](https://gerrit.automotivelinux.org/gerrit/p/src/libafb-helpers.git).
* Controller relies on Lua-5.3, when not needed Lua might be removed at compilation time.

The controller library is integrated by default in the AGL SDK since the Guppy
version (>=7) and is also available as a package for the AGL supported linux
distributions.

You could find the SDK build from Yocto which embed the afb-helpers library
here:

* For [releases](https://download.automotivelinux.org/AGL/release/) >= Guppy, in
 the latest machine's deploy directory. (e.g for Guppy in
 `latest/<yourmachine>/deploy/sdk` directory)
* For the [master](https://download.automotivelinux.org/AGL/snapshots/master/)
 development branch, in the latest machine's deploy directory. (e.g in
 `latest/<yourmachine>/deploy/sdk` directory)

To install the native package please refer to [this chapter](../1-verify-build-host.html)
in the AGL documentation to install the AGL repository for your distribution.

Then use your package manager to install the library.

### OpenSuse

```bash
sudo zypper ref
sudo zypper install agl-libappcontroller-devel
```

### Fedora

```bash
sudo dnf ref
sudo dnf install agl-libappcontroller-devel
```

### Ubuntu/Debian

```bash
sudo apt-get update
sudo apt-get install agl-libappcontroller-dev
```

## Monitoring

* The default test HTML page expect the monitoring HTML page to be accessible under /monitoring with
 the --monitoring option.
* The monitoring HTML pages are installed with the app framework binder in a subdirectory called
 monitoring.
* You can add other HTML pages with the alias options e.g:
 afb-daemon --port=1234 --monitoring --alias=/path1/to/htmlpages:/path2/to/htmlpages --ldpaths=. --workdir=. --roothttp=../htdocs
* The monitoring is accessible at http://localhost:1234/monitoring.
