/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.40 from the
 * contents of APItest.xs. Do not edit this file, edit APItest.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "APItest.xs"
#define PERL_IN_XS_APITEST

/* We want to be able to test things that aren't API yet. */
#define PERL_EXT

/* Do *not* define PERL_NO_GET_CONTEXT.  This is the one place where we get
   to test implicit Perl_get_context().  */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

typedef FILE NativeFile;

#include "fakesdio.h"   /* Causes us to use PerlIO below */

typedef SV *SVREF;
typedef PTR_TBL_t *XS__APItest__PtrTable;
typedef PerlIO * InputStream;
typedef PerlIO * OutputStream;

#define croak_fail() croak("fail at " __FILE__ " line %d", __LINE__)
#define croak_fail_nep(h, w) croak("fail %p!=%p at " __FILE__ " line %d", (h), (w), __LINE__)
#define croak_fail_nei(h, w) croak("fail %d!=%d at " __FILE__ " line %d", (int)(h), (int)(w), __LINE__)

#ifdef EBCDIC

void
cat_utf8a2n(SV* sv, const char * const ascii_utf8, STRLEN len)
{
    /* Converts variant UTF-8 text pointed to by 'ascii_utf8' of length 'len',
     * to UTF-EBCDIC, appending that text to the text already in 'sv'.
     * Currently doesn't work on invariants, as that is unneeded here, and we
     * could get double translations if we did.
     *
     * It has the algorithm for strict UTF-8 hard-coded in to find the code
     * point it represents, then calls uvchr_to_utf8() to convert to
     * UTF-EBCDIC).
     *
     * Note that this uses code points, not characters.  Thus if the input is
     * the UTF-8 for the code point 0xFF, the output will be the UTF-EBCDIC for
     * 0xFF, even though that code point represents different characters on
     * ASCII vs EBCDIC platforms. */

    dTHX;
    char * p = (char *) ascii_utf8;
    const char * const e = p + len;

    while (p < e) {
        UV code_point;
        U8 native_utf8[UTF8_MAXBYTES + 1];
        U8 * char_end;
        U8 start = (U8) *p;

        /* Start bytes are the same in both UTF-8 and I8, therefore we can
         * treat this ASCII UTF-8 byte as an I8 byte.  But PL_utf8skip[] is
         * indexed by NATIVE_UTF8 bytes, so transform to that */
        STRLEN char_bytes_len = PL_utf8skip[I8_TO_NATIVE_UTF8(start)];

        if (start < 0xc2) {
            croak("fail: Expecting start byte, instead got 0x%X at %s line %d",
                                                  (U8) *p, __FILE__, __LINE__);
        }
        code_point = (start & (((char_bytes_len) >= 7)
                                ? 0x00
                                : (0x1F >> ((char_bytes_len)-2))));
        p++;
        while (p < e && ((( (U8) *p) & 0xC0) == 0x80)) {

            code_point = (code_point << 6) | (( (U8) *p) & 0x3F);
            p++;
        }

        char_end = uvchr_to_utf8(native_utf8, code_point);
	sv_catpvn(sv, (char *) native_utf8, char_end - native_utf8);
    }
}

#endif

/* for my_cxt tests */

#define MY_CXT_KEY "XS::APItest::_guts" XS_VERSION

typedef struct {
    int i;
    SV *sv;
    GV *cscgv;
    AV *cscav;
    AV *bhkav;
    bool bhk_record;
    peep_t orig_peep;
    peep_t orig_rpeep;
    int peep_recording;
    AV *peep_recorder;
    AV *rpeep_recorder;
    AV *xop_record;
} my_cxt_t;

START_MY_CXT

int
S_myset_set(pTHX_ SV* sv, MAGIC* mg)
{
    SV *isv = (SV*)mg->mg_ptr;

    PERL_UNUSED_ARG(sv);
    SvIVX(isv)++;
    return 0;
}

MGVTBL vtbl_foo, vtbl_bar;
MGVTBL vtbl_myset = { 0, S_myset_set, 0, 0, 0, 0, 0, 0 };


/* indirect functions to test the [pa]MY_CXT macros */

int
my_cxt_getint_p(pMY_CXT)
{
    return MY_CXT.i;
}

void
my_cxt_setint_p(pMY_CXT_ int i)
{
    MY_CXT.i = i;
}

SV*
my_cxt_getsv_interp_context(void)
{
    dTHX;
    dMY_CXT_INTERP(my_perl);
    return MY_CXT.sv;
}

SV*
my_cxt_getsv_interp(void)
{
    dMY_CXT;
    return MY_CXT.sv;
}

void
my_cxt_setsv_p(SV* sv _pMY_CXT)
{
    MY_CXT.sv = sv;
}


/* from exception.c */
int apitest_exception(int);

/* from core_or_not.inc */
bool sv_setsv_cow_hashkey_core(void);
bool sv_setsv_cow_hashkey_notcore(void);

/* A routine to test hv_delayfree_ent
   (which itself is tested by testing on hv_free_ent  */

typedef void (freeent_function)(pTHX_ HV *, HE *);

void
test_freeent(freeent_function *f) {
    dSP;
    HV *test_hash = newHV();
    HE *victim;
    SV *test_scalar;
    U32 results[4];
    int i;

#ifdef PURIFY
    victim = (HE*)safemalloc(sizeof(HE));
#else
    /* Storing then deleting something should ensure that a hash entry is
       available.  */
    (void) hv_stores(test_hash, "", &PL_sv_yes);
    (void) hv_deletes(test_hash, "", 0);

    /* We need to "inline" new_he here as it's static, and the functions we
       test expect to be able to call del_HE on the HE  */
    if (!PL_body_roots[HE_SVSLOT])
	croak("PL_he_root is 0");
    victim = (HE*) PL_body_roots[HE_SVSLOT];
    PL_body_roots[HE_SVSLOT] = HeNEXT(victim);
#endif

    victim->hent_hek = Perl_share_hek(aTHX_ "", 0, 0);

    test_scalar = newSV(0);
    SvREFCNT_inc(test_scalar);
    HeVAL(victim) = test_scalar;

    /* Need this little game else we free the temps on the return stack.  */
    results[0] = SvREFCNT(test_scalar);
    SAVETMPS;
    results[1] = SvREFCNT(test_scalar);
    f(aTHX_ test_hash, victim);
    results[2] = SvREFCNT(test_scalar);
    FREETMPS;
    results[3] = SvREFCNT(test_scalar);

    i = 0;
    do {
	mXPUSHu(results[i]);
    } while (++i < (int)(sizeof(results)/sizeof(results[0])));

    /* Goodbye to our extra reference.  */
    SvREFCNT_dec(test_scalar);
}

/* Not that it matters much, but it's handy for the flipped character to just
 * be the opposite case (at least for ASCII-range and most Latin1 as well). */
#define FLIP_BIT ('A' ^ 'a')

static I32
bitflip_key(pTHX_ IV action, SV *field) {
    MAGIC *mg = mg_find(field, PERL_MAGIC_uvar);
    SV *keysv;
    PERL_UNUSED_ARG(action);
    if (mg && (keysv = mg->mg_obj)) {
	STRLEN len;
	const char *p = SvPV(keysv, len);

	if (len) {
            /* Allow for the flipped val to be longer than the original.  This
             * is just for testing, so can afford to have some slop */
            const STRLEN newlen = len * 2;

	    SV *newkey = newSV(newlen);
	    const char * const new_p_orig = SvPVX(newkey);
	    char *new_p = (char *) new_p_orig;

	    if (SvUTF8(keysv)) {
		const char *const end = p + len;
		while (p < end) {
		    STRLEN curlen;
		    UV chr = utf8_to_uvchr_buf((U8 *)p, (U8 *) end, &curlen);

                    /* Make sure don't exceed bounds */
                    assert(new_p - new_p_orig + curlen < newlen);

		    new_p = (char *)uvchr_to_utf8((U8 *)new_p, chr ^ FLIP_BIT);
		    p += curlen;
		}
		SvUTF8_on(newkey);
	    } else {
		while (len--)
		    *new_p++ = *p++ ^ FLIP_BIT;
	    }
	    *new_p = '\0';
	    SvCUR_set(newkey, new_p - new_p_orig);
	    SvPOK_on(newkey);

	    mg->mg_obj = newkey;
	}
    }
    return 0;
}

static I32
rot13_key(pTHX_ IV action, SV *field) {
    MAGIC *mg = mg_find(field, PERL_MAGIC_uvar);
    SV *keysv;
    PERL_UNUSED_ARG(action);
    if (mg && (keysv = mg->mg_obj)) {
	STRLEN len;
	const char *p = SvPV(keysv, len);

	if (len) {
	    SV *newkey = newSV(len);
	    char *new_p = SvPVX(newkey);

	    /* There's a deliberate fencepost error here to loop len + 1 times
	       to copy the trailing \0  */
	    do {
		char new_c = *p++;
		/* Try doing this cleanly and clearly in EBCDIC another way: */
		switch (new_c) {
		case 'A': new_c = 'N'; break;
		case 'B': new_c = 'O'; break;
		case 'C': new_c = 'P'; break;
		case 'D': new_c = 'Q'; break;
		case 'E': new_c = 'R'; break;
		case 'F': new_c = 'S'; break;
		case 'G': new_c = 'T'; break;
		case 'H': new_c = 'U'; break;
		case 'I': new_c = 'V'; break;
		case 'J': new_c = 'W'; break;
		case 'K': new_c = 'X'; break;
		case 'L': new_c = 'Y'; break;
		case 'M': new_c = 'Z'; break;
		case 'N': new_c = 'A'; break;
		case 'O': new_c = 'B'; break;
		case 'P': new_c = 'C'; break;
		case 'Q': new_c = 'D'; break;
		case 'R': new_c = 'E'; break;
		case 'S': new_c = 'F'; break;
		case 'T': new_c = 'G'; break;
		case 'U': new_c = 'H'; break;
		case 'V': new_c = 'I'; break;
		case 'W': new_c = 'J'; break;
		case 'X': new_c = 'K'; break;
		case 'Y': new_c = 'L'; break;
		case 'Z': new_c = 'M'; break;
		case 'a': new_c = 'n'; break;
		case 'b': new_c = 'o'; break;
		case 'c': new_c = 'p'; break;
		case 'd': new_c = 'q'; break;
		case 'e': new_c = 'r'; break;
		case 'f': new_c = 's'; break;
		case 'g': new_c = 't'; break;
		case 'h': new_c = 'u'; break;
		case 'i': new_c = 'v'; break;
		case 'j': new_c = 'w'; break;
		case 'k': new_c = 'x'; break;
		case 'l': new_c = 'y'; break;
		case 'm': new_c = 'z'; break;
		case 'n': new_c = 'a'; break;
		case 'o': new_c = 'b'; break;
		case 'p': new_c = 'c'; break;
		case 'q': new_c = 'd'; break;
		case 'r': new_c = 'e'; break;
		case 's': new_c = 'f'; break;
		case 't': new_c = 'g'; break;
		case 'u': new_c = 'h'; break;
		case 'v': new_c = 'i'; break;
		case 'w': new_c = 'j'; break;
		case 'x': new_c = 'k'; break;
		case 'y': new_c = 'l'; break;
		case 'z': new_c = 'm'; break;
		}
		*new_p++ = new_c;
	    } while (len--);
	    SvCUR_set(newkey, SvCUR(keysv));
	    SvPOK_on(newkey);
	    if (SvUTF8(keysv))
		SvUTF8_on(newkey);

	    mg->mg_obj = newkey;
	}
    }
    return 0;
}

STATIC I32
rmagical_a_dummy(pTHX_ IV idx, SV *sv) {
    PERL_UNUSED_ARG(idx);
    PERL_UNUSED_ARG(sv);
    return 0;
}

/* We could do "= { 0 };" but some versions of gcc do warn
 * (with -Wextra) about missing initializer, this is probably gcc
 * being a bit too paranoid.  But since this is file-static, we can
 * just have it without initializer, since it should get
 * zero-initialized. */
STATIC MGVTBL rmagical_b;

STATIC void
blockhook_csc_start(pTHX_ int full)
{
    dMY_CXT;
    AV *const cur = GvAV(MY_CXT.cscgv);

    PERL_UNUSED_ARG(full);
    SAVEGENERICSV(GvAV(MY_CXT.cscgv));

    if (cur) {
        I32 i;
        AV *const new_av = newAV();

        for (i = 0; i <= av_tindex(cur); i++) {
            av_store(new_av, i, newSVsv(*av_fetch(cur, i, 0)));
        }

        GvAV(MY_CXT.cscgv) = new_av;
    }
}

STATIC void
blockhook_csc_pre_end(pTHX_ OP **o)
{
    dMY_CXT;

    PERL_UNUSED_ARG(o);
    /* if we hit the end of a scope we missed the start of, we need to
     * unconditionally clear @CSC */
    if (GvAV(MY_CXT.cscgv) == MY_CXT.cscav && MY_CXT.cscav) {
        av_clear(MY_CXT.cscav);
    }

}

STATIC void
blockhook_test_start(pTHX_ int full)
{
    dMY_CXT;
    AV *av;
    
    if (MY_CXT.bhk_record) {
        av = newAV();
        av_push(av, newSVpvs("start"));
        av_push(av, newSViv(full));
        av_push(MY_CXT.bhkav, newRV_noinc(MUTABLE_SV(av)));
    }
}

STATIC void
blockhook_test_pre_end(pTHX_ OP **o)
{
    dMY_CXT;

    PERL_UNUSED_ARG(o);
    if (MY_CXT.bhk_record)
        av_push(MY_CXT.bhkav, newSVpvs("pre_end"));
}

STATIC void
blockhook_test_post_end(pTHX_ OP **o)
{
    dMY_CXT;

    PERL_UNUSED_ARG(o);
    if (MY_CXT.bhk_record)
        av_push(MY_CXT.bhkav, newSVpvs("post_end"));
}

STATIC void
blockhook_test_eval(pTHX_ OP *const o)
{
    dMY_CXT;
    AV *av;

    if (MY_CXT.bhk_record) {
        av = newAV();
        av_push(av, newSVpvs("eval"));
        av_push(av, newSVpv(OP_NAME(o), 0));
        av_push(MY_CXT.bhkav, newRV_noinc(MUTABLE_SV(av)));
    }
}

STATIC BHK bhk_csc, bhk_test;

STATIC void
my_peep (pTHX_ OP *o)
{
    dMY_CXT;

    if (!o)
	return;

    MY_CXT.orig_peep(aTHX_ o);

    if (!MY_CXT.peep_recording)
	return;

    for (; o; o = o->op_next) {
	if (o->op_type == OP_CONST && cSVOPx_sv(o) && SvPOK(cSVOPx_sv(o))) {
	    av_push(MY_CXT.peep_recorder, newSVsv(cSVOPx_sv(o)));
	}
    }
}

STATIC void
my_rpeep (pTHX_ OP *o)
{
    dMY_CXT;

    if (!o)
	return;

    MY_CXT.orig_rpeep(aTHX_ o);

    if (!MY_CXT.peep_recording)
	return;

    for (; o; o = o->op_next) {
	if (o->op_type == OP_CONST && cSVOPx_sv(o) && SvPOK(cSVOPx_sv(o))) {
	    av_push(MY_CXT.rpeep_recorder, newSVsv(cSVOPx_sv(o)));
	}
    }
}

STATIC OP *
THX_ck_entersub_args_lists(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    PERL_UNUSED_ARG(namegv);
    PERL_UNUSED_ARG(ckobj);
    return ck_entersub_args_list(entersubop);
}

STATIC OP *
THX_ck_entersub_args_scalars(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *aop = cUNOPx(entersubop)->op_first;
    PERL_UNUSED_ARG(namegv);
    PERL_UNUSED_ARG(ckobj);
    if (!OpHAS_SIBLING(aop))
	aop = cUNOPx(aop)->op_first;
    for (aop = OpSIBLING(aop); OpHAS_SIBLING(aop); aop = OpSIBLING(aop)) {
	op_contextualize(aop, G_SCALAR);
    }
    return entersubop;
}

STATIC OP *
THX_ck_entersub_multi_sum(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *sumop = NULL;
    OP *parent = entersubop;
    OP *pushop = cUNOPx(entersubop)->op_first;
    PERL_UNUSED_ARG(namegv);
    PERL_UNUSED_ARG(ckobj);
    if (!OpHAS_SIBLING(pushop)) {
        parent = pushop;
	pushop = cUNOPx(pushop)->op_first;
    }
    while (1) {
	OP *aop = OpSIBLING(pushop);
	if (!OpHAS_SIBLING(aop))
	    break;
        /* cut out first arg */
        op_sibling_splice(parent, pushop, 1, NULL);
	op_contextualize(aop, G_SCALAR);
	if (sumop) {
	    sumop = newBINOP(OP_ADD, 0, sumop, aop);
	} else {
	    sumop = aop;
	}
    }
    if (!sumop)
	sumop = newSVOP(OP_CONST, 0, newSViv(0));
    op_free(entersubop);
    return sumop;
}

STATIC void test_op_list_describe_part(SV *res, OP *o);
STATIC void
test_op_list_describe_part(SV *res, OP *o)
{
    sv_catpv(res, PL_op_name[o->op_type]);
    switch (o->op_type) {
	case OP_CONST: {
	    sv_catpvf(res, "(%d)", (int)SvIV(cSVOPx(o)->op_sv));
	} break;
    }
    if (o->op_flags & OPf_KIDS) {
	OP *k;
	sv_catpvs(res, "[");
	for (k = cUNOPx(o)->op_first; k; k = OpSIBLING(k))
	    test_op_list_describe_part(res, k);
	sv_catpvs(res, "]");
    } else {
	sv_catpvs(res, ".");
    }
}

STATIC char *
test_op_list_describe(OP *o)
{
    SV *res = sv_2mortal(newSVpvs(""));
    if (o)
	test_op_list_describe_part(res, o);
    return SvPVX(res);
}

/* the real new*OP functions have a tendency to call fold_constants, and
 * other such unhelpful things, so we need our own versions for testing */

#define mkUNOP(t, f) THX_mkUNOP(aTHX_ (t), (f))
static OP *
THX_mkUNOP(pTHX_ U32 type, OP *first)
{
    UNOP *unop;
    NewOp(1103, unop, 1, UNOP);
    unop->op_type   = (OPCODE)type;
    op_sibling_splice((OP*)unop, NULL, 0, first);
    return (OP *)unop;
}

#define mkBINOP(t, f, l) THX_mkBINOP(aTHX_ (t), (f), (l))
static OP *
THX_mkBINOP(pTHX_ U32 type, OP *first, OP *last)
{
    BINOP *binop;
    NewOp(1103, binop, 1, BINOP);
    binop->op_type      = (OPCODE)type;
    op_sibling_splice((OP*)binop, NULL, 0, last);
    op_sibling_splice((OP*)binop, NULL, 0, first);
    return (OP *)binop;
}

#define mkLISTOP(t, f, s, l) THX_mkLISTOP(aTHX_ (t), (f), (s), (l))
static OP *
THX_mkLISTOP(pTHX_ U32 type, OP *first, OP *sib, OP *last)
{
    LISTOP *listop;
    NewOp(1103, listop, 1, LISTOP);
    listop->op_type     = (OPCODE)type;
    op_sibling_splice((OP*)listop, NULL, 0, last);
    op_sibling_splice((OP*)listop, NULL, 0, sib);
    op_sibling_splice((OP*)listop, NULL, 0, first);
    return (OP *)listop;
}

static char *
test_op_linklist_describe(OP *start)
{
    SV *rv = sv_2mortal(newSVpvs(""));
    OP *o;
    o = start = LINKLIST(start);
    do {
        sv_catpvs(rv, ".");
        sv_catpv(rv, OP_NAME(o));
        if (o->op_type == OP_CONST)
            sv_catsv(rv, cSVOPo->op_sv);
        o = o->op_next;
    } while (o && o != start);
    return SvPVX(rv);
}

/** establish_cleanup operator, ripped off from Scope::Cleanup **/

STATIC void
THX_run_cleanup(pTHX_ void *cleanup_code_ref)
{
    dSP;
    PUSHSTACK;
    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    call_sv((SV*)cleanup_code_ref, G_VOID|G_DISCARD);
    FREETMPS;
    LEAVE;
    POPSTACK;
}

STATIC OP *
THX_pp_establish_cleanup(pTHX)
{
    dSP;
    SV *cleanup_code_ref;
    cleanup_code_ref = newSVsv(POPs);
    SAVEFREESV(cleanup_code_ref);
    SAVEDESTRUCTOR_X(THX_run_cleanup, cleanup_code_ref);
    if(GIMME_V != G_VOID) PUSHs(&PL_sv_undef);
    RETURN;
}

STATIC OP *
THX_ck_entersub_establish_cleanup(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *parent, *pushop, *argop, *estop;
    ck_entersub_args_proto(entersubop, namegv, ckobj);
    parent = entersubop;
    pushop = cUNOPx(entersubop)->op_first;
    if(!OpHAS_SIBLING(pushop)) {
        parent = pushop;
        pushop = cUNOPx(pushop)->op_first;
    }
    /* extract out first arg, then delete the rest of the tree */
    argop = OpSIBLING(pushop);
    op_sibling_splice(parent, pushop, 1, NULL);
    op_free(entersubop);

    estop = mkUNOP(OP_RAND, argop);
    estop->op_ppaddr = THX_pp_establish_cleanup;
    PL_hints |= HINT_BLOCK_SCOPE;
    return estop;
}

STATIC OP *
THX_ck_entersub_postinc(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *parent, *pushop, *argop;
    ck_entersub_args_proto(entersubop, namegv, ckobj);
    parent = entersubop;
    pushop = cUNOPx(entersubop)->op_first;
    if(!OpHAS_SIBLING(pushop)) {
        parent = pushop;
        pushop = cUNOPx(pushop)->op_first;
    }
    argop = OpSIBLING(pushop);
    op_sibling_splice(parent, pushop, 1, NULL);
    op_free(entersubop);
    return newUNOP(OP_POSTINC, 0,
	op_lvalue(op_contextualize(argop, G_SCALAR), OP_POSTINC));
}

STATIC OP *
THX_ck_entersub_pad_scalar(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *pushop, *argop;
    PADOFFSET padoff = NOT_IN_PAD;
    SV *a0, *a1;
    ck_entersub_args_proto(entersubop, namegv, ckobj);
    pushop = cUNOPx(entersubop)->op_first;
    if(!OpHAS_SIBLING(pushop))
        pushop = cUNOPx(pushop)->op_first;
    argop = OpSIBLING(pushop);
    if(argop->op_type != OP_CONST || OpSIBLING(argop)->op_type != OP_CONST)
	croak("bad argument expression type for pad_scalar()");
    a0 = cSVOPx_sv(argop);
    a1 = cSVOPx_sv(OpSIBLING(argop));
    switch(SvIV(a0)) {
	case 1: {
	    SV *namesv = sv_2mortal(newSVpvs("$"));
	    sv_catsv(namesv, a1);
	    padoff = pad_findmy_sv(namesv, 0);
	} break;
	case 2: {
	    char *namepv;
	    STRLEN namelen;
	    SV *namesv = sv_2mortal(newSVpvs("$"));
	    sv_catsv(namesv, a1);
	    namepv = SvPV(namesv, namelen);
	    padoff = pad_findmy_pvn(namepv, namelen, SvUTF8(namesv));
	} break;
	case 3: {
	    char *namepv;
	    SV *namesv = sv_2mortal(newSVpvs("$"));
	    sv_catsv(namesv, a1);
	    namepv = SvPV_nolen(namesv);
	    padoff = pad_findmy_pv(namepv, SvUTF8(namesv));
	} break;
	case 4: {
	    padoff = pad_findmy_pvs("$foo", 0);
	} break;
	default: croak("bad type value for pad_scalar()");
    }
    op_free(entersubop);
    if(padoff == NOT_IN_PAD) {
	return newSVOP(OP_CONST, 0, newSVpvs("NOT_IN_PAD"));
    } else if(PAD_COMPNAME_FLAGS_isOUR(padoff)) {
	return newSVOP(OP_CONST, 0, newSVpvs("NOT_MY"));
    } else {
	OP *padop = newOP(OP_PADSV, 0);
	padop->op_targ = padoff;
	return padop;
    }
}

/** RPN keyword parser **/

#define sv_is_glob(sv) (SvTYPE(sv) == SVt_PVGV)
#define sv_is_regexp(sv) (SvTYPE(sv) == SVt_REGEXP)
#define sv_is_string(sv) \
    (!sv_is_glob(sv) && !sv_is_regexp(sv) && \
     (SvFLAGS(sv) & (SVf_IOK|SVf_NOK|SVf_POK|SVp_IOK|SVp_NOK|SVp_POK)))

static SV *hintkey_rpn_sv, *hintkey_calcrpn_sv, *hintkey_stufftest_sv;
static SV *hintkey_swaptwostmts_sv, *hintkey_looprest_sv;
static SV *hintkey_scopelessblock_sv;
static SV *hintkey_stmtasexpr_sv, *hintkey_stmtsasexpr_sv;
static SV *hintkey_loopblock_sv, *hintkey_blockasexpr_sv;
static SV *hintkey_swaplabel_sv, *hintkey_labelconst_sv;
static SV *hintkey_arrayfullexpr_sv, *hintkey_arraylistexpr_sv;
static SV *hintkey_arraytermexpr_sv, *hintkey_arrayarithexpr_sv;
static SV *hintkey_arrayexprflags_sv;
static SV *hintkey_DEFSV_sv;
static SV *hintkey_with_vars_sv;
static SV *hintkey_join_with_space_sv;
static int (*next_keyword_plugin)(pTHX_ char *, STRLEN, OP **);

/* low-level parser helpers */

#define PL_bufptr (PL_parser->bufptr)
#define PL_bufend (PL_parser->bufend)

/* RPN parser */

#define parse_var() THX_parse_var(aTHX)
static OP *THX_parse_var(pTHX)
{
    char *s = PL_bufptr;
    char *start = s;
    PADOFFSET varpos;
    OP *padop;
    if(*s != '$') croak("RPN syntax error");
    while(1) {
	char c = *++s;
	if(!isALNUM(c)) break;
    }
    if(s-start < 2) croak("RPN syntax error");
    lex_read_to(s);
    varpos = pad_findmy_pvn(start, s-start, 0);
    if(varpos == NOT_IN_PAD || PAD_COMPNAME_FLAGS_isOUR(varpos))
	croak("RPN only supports \"my\" variables");
    padop = newOP(OP_PADSV, 0);
    padop->op_targ = varpos;
    return padop;
}

#define push_rpn_item(o) \
    op_sibling_splice(parent, NULL, 0, o);
#define pop_rpn_item() ( \
    (tmpop = op_sibling_splice(parent, NULL, 1, NULL)) \
        ? tmpop : (croak("RPN stack underflow"), (OP*)NULL))

#define parse_rpn_expr() THX_parse_rpn_expr(aTHX)
static OP *THX_parse_rpn_expr(pTHX)
{
    OP *tmpop;
    /* fake parent for splice to mess with */
    OP *parent = mkBINOP(OP_NULL, NULL, NULL);

    while(1) {
	I32 c;
	lex_read_space(0);
	c = lex_peek_unichar(0);
	switch(c) {
	    case /*(*/')': case /*{*/'}': {
		OP *result = pop_rpn_item();
		if(cLISTOPx(parent)->op_first)
                    croak("RPN expression must return a single value");
                op_free(parent);
		return result;
	    } break;
	    case '0': case '1': case '2': case '3': case '4':
	    case '5': case '6': case '7': case '8': case '9': {
		UV val = 0;
		do {
		    lex_read_unichar(0);
		    val = 10*val + (c - '0');
		    c = lex_peek_unichar(0);
		} while(c >= '0' && c <= '9');
		push_rpn_item(newSVOP(OP_CONST, 0, newSVuv(val)));
	    } break;
	    case '$': {
		push_rpn_item(parse_var());
	    } break;
	    case '+': {
		OP *b = pop_rpn_item();
		OP *a = pop_rpn_item();
		lex_read_unichar(0);
		push_rpn_item(newBINOP(OP_I_ADD, 0, a, b));
	    } break;
	    case '-': {
		OP *b = pop_rpn_item();
		OP *a = pop_rpn_item();
		lex_read_unichar(0);
		push_rpn_item(newBINOP(OP_I_SUBTRACT, 0, a, b));
	    } break;
	    case '*': {
		OP *b = pop_rpn_item();
		OP *a = pop_rpn_item();
		lex_read_unichar(0);
		push_rpn_item(newBINOP(OP_I_MULTIPLY, 0, a, b));
	    } break;
	    case '/': {
		OP *b = pop_rpn_item();
		OP *a = pop_rpn_item();
		lex_read_unichar(0);
		push_rpn_item(newBINOP(OP_I_DIVIDE, 0, a, b));
	    } break;
	    case '%': {
		OP *b = pop_rpn_item();
		OP *a = pop_rpn_item();
		lex_read_unichar(0);
		push_rpn_item(newBINOP(OP_I_MODULO, 0, a, b));
	    } break;
	    default: {
		croak("RPN syntax error");
	    } break;
	}
    }
}

#define parse_keyword_rpn() THX_parse_keyword_rpn(aTHX)
static OP *THX_parse_keyword_rpn(pTHX)
{
    OP *op;
    lex_read_space(0);
    if(lex_peek_unichar(0) != '('/*)*/)
	croak("RPN expression must be parenthesised");
    lex_read_unichar(0);
    op = parse_rpn_expr();
    if(lex_peek_unichar(0) != /*(*/')')
	croak("RPN expression must be parenthesised");
    lex_read_unichar(0);
    return op;
}

#define parse_keyword_calcrpn() THX_parse_keyword_calcrpn(aTHX)
static OP *THX_parse_keyword_calcrpn(pTHX)
{
    OP *varop, *exprop;
    lex_read_space(0);
    varop = parse_var();
    lex_read_space(0);
    if(lex_peek_unichar(0) != '{'/*}*/)
	croak("RPN expression must be braced");
    lex_read_unichar(0);
    exprop = parse_rpn_expr();
    if(lex_peek_unichar(0) != /*{*/'}')
	croak("RPN expression must be braced");
    lex_read_unichar(0);
    return newASSIGNOP(OPf_STACKED, varop, 0, exprop);
}

#define parse_keyword_stufftest() THX_parse_keyword_stufftest(aTHX)
static OP *THX_parse_keyword_stufftest(pTHX)
{
    I32 c;
    bool do_stuff;
    lex_read_space(0);
    do_stuff = lex_peek_unichar(0) == '+';
    if(do_stuff) {
	lex_read_unichar(0);
	lex_read_space(0);
    }
    c = lex_peek_unichar(0);
    if(c == ';') {
	lex_read_unichar(0);
    } else if(c != /*{*/'}') {
	croak("syntax error");
    }
    if(do_stuff) lex_stuff_pvs(" ", 0);
    return newOP(OP_NULL, 0);
}

#define parse_keyword_swaptwostmts() THX_parse_keyword_swaptwostmts(aTHX)
static OP *THX_parse_keyword_swaptwostmts(pTHX)
{
    OP *a, *b;
    a = parse_fullstmt(0);
    b = parse_fullstmt(0);
    if(a && b)
	PL_hints |= HINT_BLOCK_SCOPE;
    return op_append_list(OP_LINESEQ, b, a);
}

#define parse_keyword_looprest() THX_parse_keyword_looprest(aTHX)
static OP *THX_parse_keyword_looprest(pTHX)
{
    return newWHILEOP(0, 1, NULL, newSVOP(OP_CONST, 0, &PL_sv_yes),
			parse_stmtseq(0), NULL, 1);
}

#define parse_keyword_scopelessblock() THX_parse_keyword_scopelessblock(aTHX)
static OP *THX_parse_keyword_scopelessblock(pTHX)
{
    I32 c;
    OP *body;
    lex_read_space(0);
    if(lex_peek_unichar(0) != '{'/*}*/) croak("syntax error");
    lex_read_unichar(0);
    body = parse_stmtseq(0);
    c = lex_peek_unichar(0);
    if(c != /*{*/'}' && c != /*[*/']' && c != /*(*/')') croak("syntax error");
    lex_read_unichar(0);
    return body;
}

#define parse_keyword_stmtasexpr() THX_parse_keyword_stmtasexpr(aTHX)
static OP *THX_parse_keyword_stmtasexpr(pTHX)
{
    OP *o = parse_barestmt(0);
    if (!o) o = newOP(OP_STUB, 0);
    if (PL_hints & HINT_BLOCK_SCOPE) o->op_flags |= OPf_PARENS;
    return op_scope(o);
}

#define parse_keyword_stmtsasexpr() THX_parse_keyword_stmtsasexpr(aTHX)
static OP *THX_parse_keyword_stmtsasexpr(pTHX)
{
    OP *o;
    lex_read_space(0);
    if(lex_peek_unichar(0) != '{'/*}*/) croak("syntax error");
    lex_read_unichar(0);
    o = parse_stmtseq(0);
    lex_read_space(0);
    if(lex_peek_unichar(0) != /*{*/'}') croak("syntax error");
    lex_read_unichar(0);
    if (!o) o = newOP(OP_STUB, 0);
    if (PL_hints & HINT_BLOCK_SCOPE) o->op_flags |= OPf_PARENS;
    return op_scope(o);
}

#define parse_keyword_loopblock() THX_parse_keyword_loopblock(aTHX)
static OP *THX_parse_keyword_loopblock(pTHX)
{
    return newWHILEOP(0, 1, NULL, newSVOP(OP_CONST, 0, &PL_sv_yes),
			parse_block(0), NULL, 1);
}

#define parse_keyword_blockasexpr() THX_parse_keyword_blockasexpr(aTHX)
static OP *THX_parse_keyword_blockasexpr(pTHX)
{
    OP *o = parse_block(0);
    if (!o) o = newOP(OP_STUB, 0);
    if (PL_hints & HINT_BLOCK_SCOPE) o->op_flags |= OPf_PARENS;
    return op_scope(o);
}

#define parse_keyword_swaplabel() THX_parse_keyword_swaplabel(aTHX)
static OP *THX_parse_keyword_swaplabel(pTHX)
{
    OP *sop = parse_barestmt(0);
    SV *label = parse_label(PARSE_OPTIONAL);
    if (label) sv_2mortal(label);
    return newSTATEOP(label ? SvUTF8(label) : 0,
                      label ? savepv(SvPVX(label)) : NULL,
                      sop);
}

#define parse_keyword_labelconst() THX_parse_keyword_labelconst(aTHX)
static OP *THX_parse_keyword_labelconst(pTHX)
{
    return newSVOP(OP_CONST, 0, parse_label(0));
}

#define parse_keyword_arrayfullexpr() THX_parse_keyword_arrayfullexpr(aTHX)
static OP *THX_parse_keyword_arrayfullexpr(pTHX)
{
    return newANONLIST(parse_fullexpr(0));
}

#define parse_keyword_arraylistexpr() THX_parse_keyword_arraylistexpr(aTHX)
static OP *THX_parse_keyword_arraylistexpr(pTHX)
{
    return newANONLIST(parse_listexpr(0));
}

#define parse_keyword_arraytermexpr() THX_parse_keyword_arraytermexpr(aTHX)
static OP *THX_parse_keyword_arraytermexpr(pTHX)
{
    return newANONLIST(parse_termexpr(0));
}

#define parse_keyword_arrayarithexpr() THX_parse_keyword_arrayarithexpr(aTHX)
static OP *THX_parse_keyword_arrayarithexpr(pTHX)
{
    return newANONLIST(parse_arithexpr(0));
}

#define parse_keyword_arrayexprflags() THX_parse_keyword_arrayexprflags(aTHX)
static OP *THX_parse_keyword_arrayexprflags(pTHX)
{
    U32 flags = 0;
    I32 c;
    OP *o;
    lex_read_space(0);
    c = lex_peek_unichar(0);
    if (c != '!' && c != '?') croak("syntax error");
    lex_read_unichar(0);
    if (c == '?') flags |= PARSE_OPTIONAL;
    o = parse_listexpr(flags);
    return o ? newANONLIST(o) : newANONHASH(newOP(OP_STUB, 0));
}

#define parse_keyword_DEFSV() THX_parse_keyword_DEFSV(aTHX)
static OP *THX_parse_keyword_DEFSV(pTHX)
{
    return newDEFSVOP();
}

#define sv_cat_c(a,b) THX_sv_cat_c(aTHX_ a, b)
static void THX_sv_cat_c(pTHX_ SV *sv, U32 c) {
    char ds[UTF8_MAXBYTES + 1], *d;
    d = (char *)uvchr_to_utf8((U8 *)ds, c);
    if (d - ds > 1) {
        sv_utf8_upgrade(sv);
    }
    sv_catpvn(sv, ds, d - ds);
}

#define parse_keyword_with_vars() THX_parse_keyword_with_vars(aTHX)
static OP *THX_parse_keyword_with_vars(pTHX)
{
    I32 c;
    IV count;
    int save_ix;
    OP *vardeclseq, *body;

    save_ix = block_start(TRUE);
    vardeclseq = NULL;

    count = 0;

    lex_read_space(0);
    c = lex_peek_unichar(0);
    while (c != '{') {
        SV *varname;
        PADOFFSET padoff;

        if (c == -1) {
            croak("unexpected EOF; expecting '{'");
        }

        if (!isIDFIRST_uni(c)) {
            croak("unexpected '%c'; expecting an identifier", (int)c);
        }

        varname = newSVpvs("$");
        if (lex_bufutf8()) {
            SvUTF8_on(varname);
        }

        sv_cat_c(varname, c);
        lex_read_unichar(0);

        while (c = lex_peek_unichar(0), c != -1 && isIDCONT_uni(c)) {
            sv_cat_c(varname, c);
            lex_read_unichar(0);
        }

        padoff = pad_add_name_sv(varname, padadd_NO_DUP_CHECK, NULL, NULL);

        {
            OP *my_var = newOP(OP_PADSV, OPf_MOD | (OPpLVAL_INTRO << 8));
            my_var->op_targ = padoff;

            vardeclseq = op_append_list(
                OP_LINESEQ,
                vardeclseq,
                newSTATEOP(
                    0, NULL,
                    newASSIGNOP(
                        OPf_STACKED,
                        my_var, 0,
                        newSVOP(
                            OP_CONST, 0,
                            newSViv(++count)
                        )
                    )
                )
            );
        }

        lex_read_space(0);
        c = lex_peek_unichar(0);
    }

    intro_my();

    body = parse_block(0);

    return block_end(save_ix, op_append_list(OP_LINESEQ, vardeclseq, body));
}

#define parse_join_with_space() THX_parse_join_with_space(aTHX)
static OP *THX_parse_join_with_space(pTHX)
{
    OP *delim, *args;

    args = parse_listexpr(0);
    delim = newSVOP(OP_CONST, 0, newSVpvs(" "));
    return op_convert_list(OP_JOIN, 0, op_prepend_elem(OP_LIST, delim, args));
}

/* plugin glue */

#define keyword_active(hintkey_sv) THX_keyword_active(aTHX_ hintkey_sv)
static int THX_keyword_active(pTHX_ SV *hintkey_sv)
{
    HE *he;
    if(!GvHV(PL_hintgv)) return 0;
    he = hv_fetch_ent(GvHV(PL_hintgv), hintkey_sv, 0,
		SvSHARED_HASH(hintkey_sv));
    return he && SvTRUE(HeVAL(he));
}

static int my_keyword_plugin(pTHX_
    char *keyword_ptr, STRLEN keyword_len, OP **op_ptr)
{
    if (memEQs(keyword_ptr, keyword_len, "rpn") &&
		    keyword_active(hintkey_rpn_sv)) {
	*op_ptr = parse_keyword_rpn();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "calcrpn") &&
		    keyword_active(hintkey_calcrpn_sv)) {
	*op_ptr = parse_keyword_calcrpn();
	return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "stufftest") &&
		    keyword_active(hintkey_stufftest_sv)) {
	*op_ptr = parse_keyword_stufftest();
	return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "swaptwostmts") &&
		    keyword_active(hintkey_swaptwostmts_sv)) {
	*op_ptr = parse_keyword_swaptwostmts();
	return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "looprest") &&
		    keyword_active(hintkey_looprest_sv)) {
	*op_ptr = parse_keyword_looprest();
	return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "scopelessblock") &&
		    keyword_active(hintkey_scopelessblock_sv)) {
	*op_ptr = parse_keyword_scopelessblock();
	return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "stmtasexpr") &&
		    keyword_active(hintkey_stmtasexpr_sv)) {
	*op_ptr = parse_keyword_stmtasexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "stmtsasexpr") &&
		    keyword_active(hintkey_stmtsasexpr_sv)) {
	*op_ptr = parse_keyword_stmtsasexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "loopblock") &&
		    keyword_active(hintkey_loopblock_sv)) {
	*op_ptr = parse_keyword_loopblock();
	return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "blockasexpr") &&
		    keyword_active(hintkey_blockasexpr_sv)) {
	*op_ptr = parse_keyword_blockasexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "swaplabel") &&
		    keyword_active(hintkey_swaplabel_sv)) {
	*op_ptr = parse_keyword_swaplabel();
	return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "labelconst") &&
		    keyword_active(hintkey_labelconst_sv)) {
	*op_ptr = parse_keyword_labelconst();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "arrayfullexpr") &&
		    keyword_active(hintkey_arrayfullexpr_sv)) {
	*op_ptr = parse_keyword_arrayfullexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "arraylistexpr") &&
		    keyword_active(hintkey_arraylistexpr_sv)) {
	*op_ptr = parse_keyword_arraylistexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "arraytermexpr") &&
		    keyword_active(hintkey_arraytermexpr_sv)) {
	*op_ptr = parse_keyword_arraytermexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "arrayarithexpr") &&
		    keyword_active(hintkey_arrayarithexpr_sv)) {
	*op_ptr = parse_keyword_arrayarithexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "arrayexprflags") &&
		    keyword_active(hintkey_arrayexprflags_sv)) {
	*op_ptr = parse_keyword_arrayexprflags();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "DEFSV") &&
		    keyword_active(hintkey_DEFSV_sv)) {
	*op_ptr = parse_keyword_DEFSV();
	return KEYWORD_PLUGIN_EXPR;
    } else if (memEQs(keyword_ptr, keyword_len, "with_vars") &&
		    keyword_active(hintkey_with_vars_sv)) {
	*op_ptr = parse_keyword_with_vars();
	return KEYWORD_PLUGIN_STMT;
    } else if (memEQs(keyword_ptr, keyword_len, "join_with_space") &&
		    keyword_active(hintkey_join_with_space_sv)) {
	*op_ptr = parse_join_with_space();
	return KEYWORD_PLUGIN_EXPR;
    } else {
        assert(next_keyword_plugin != my_keyword_plugin);
	return next_keyword_plugin(aTHX_ keyword_ptr, keyword_len, op_ptr);
    }
}

static XOP my_xop;

static OP *
pp_xop(pTHX)
{
    return PL_op->op_next;
}

static void
peep_xop(pTHX_ OP *o, OP *oldop)
{
    dMY_CXT;
    av_push(MY_CXT.xop_record, newSVpvf("peep:%" UVxf, PTR2UV(o)));
    av_push(MY_CXT.xop_record, newSVpvf("oldop:%" UVxf, PTR2UV(oldop)));
}

static I32
filter_call(pTHX_ int idx, SV *buf_sv, int maxlen)
{
    char *p;
    char *end;
    int n = FILTER_READ(idx + 1, buf_sv, maxlen);

    if (n<=0) return n;

    p = SvPV_force_nolen(buf_sv);
    end = p + SvCUR(buf_sv);
    while (p < end) {
	if (*p == 'o') *p = 'e';
	p++;
    }
    return SvCUR(buf_sv);
}

static AV *
myget_linear_isa(pTHX_ HV *stash, U32 level) {
    GV **gvp = (GV **)hv_fetchs(stash, "ISA", 0);
    PERL_UNUSED_ARG(level);
    return gvp && *gvp && GvAV(*gvp)
	 ? GvAV(*gvp)
	 : (AV *)sv_2mortal((SV *)newAV());
}


XS_EXTERNAL(XS_XS__APItest__XSUB_XS_VERSION_undef);
XS_EXTERNAL(XS_XS__APItest__XSUB_XS_VERSION_empty);
XS_EXTERNAL(XS_XS__APItest__XSUB_XS_APIVERSION_invalid);

static struct mro_alg mymro;

static Perl_check_t addissub_nxck_add;

static OP *
addissub_myck_add(pTHX_ OP *op)
{
    SV **flag_svp = hv_fetchs(GvHV(PL_hintgv), "XS::APItest/addissub", 0);
    OP *aop, *bop;
    U8 flags;
    if (!(flag_svp && SvTRUE(*flag_svp) && (op->op_flags & OPf_KIDS) &&
	    (aop = cBINOPx(op)->op_first) && (bop = OpSIBLING(aop)) &&
	    !OpHAS_SIBLING(bop)))
	return addissub_nxck_add(aTHX_ op);
    flags = op->op_flags;
    op_sibling_splice(op, NULL, 1, NULL); /* excise aop */
    op_sibling_splice(op, NULL, 1, NULL); /* excise bop */
    op_free(op); /* free the empty husk */
    flags &= ~OPf_KIDS;
    return newBINOP(OP_SUBTRACT, flags, aop, bop);
}

static Perl_check_t old_ck_rv2cv;

static OP *
my_ck_rv2cv(pTHX_ OP *o)
{
    SV *ref;
    SV **flag_svp = hv_fetchs(GvHV(PL_hintgv), "XS::APItest/addunder", 0);
    OP *aop;

    if (flag_svp && SvTRUE(*flag_svp) && (o->op_flags & OPf_KIDS)
     && (aop = cUNOPx(o)->op_first) && aop->op_type == OP_CONST
     && aop->op_private & (OPpCONST_ENTERED|OPpCONST_BARE)
     && (ref = cSVOPx(aop)->op_sv) && SvPOK(ref) && SvCUR(ref)
     && *(SvEND(ref)-1) == 'o')
    {
	SvGROW(ref, SvCUR(ref)+2);
	*SvEND(ref) = '_';
	SvCUR(ref)++;
	*SvEND(ref) = '\0';
    }
    return old_ck_rv2cv(aTHX_ o);
}

#include "const-c.inc"

#line 1360 "APItest.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 1504 "APItest.c"

/* INCLUDE:  Including 'const-xs.inc' from 'APItest.xs' */


XS_EUPXS(XS_XS__APItest_constant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_constant)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
#line 244 "./const-xs.inc"
#ifndef SYMBIAN
	/* It's not obvious how to calculate this at C pre-processor time.
	   However, any compiler optimiser worth its salt should be able to
	   remove the dead code, and hopefully the now-obviously-unused static
	   function too.  */
	HV *constant_missing = (C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? get_missing_hash(aTHX) : NULL;
	if ((C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? hv_exists_ent(constant_missing, sv, 0) : 0) {
	    sv = newSVpvf("Your vendor has not defined XS::APItest macro %" SVf
			  ", used", sv);
	} else
#endif
	{
	    sv = newSVpvf("%" SVf " is not a valid XS::APItest macro",
			  sv);
	}
	PUSHs(sv_2mortal(sv));
#line 1539 "APItest.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'APItest.xs' from 'const-xs.inc' */


/* INCLUDE:  Including 'numeric.xs' from 'APItest.xs' */


XS_EUPXS(XS_XS__APItest__numeric_grok_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_grok_number)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "number");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	number = ST(0)
;
#line 7 "./numeric.xs"
	STRLEN len;
	const char *pv = SvPV(number, len);
	UV value;
	int result;
#line 1568 "APItest.c"
#line 12 "./numeric.xs"
	EXTEND(SP,2);
	result = grok_number(pv, len, &value);
	PUSHs(sv_2mortal(newSViv(result)));
	if (result & IS_NUMBER_IN_UV)
	    PUSHs(sv_2mortal(newSVuv(value)));
#line 1575 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__numeric_grok_number_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_grok_number_flags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "number, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	number = ST(0)
;
	U32	flags = (unsigned long)SvUV(ST(1))
;
#line 23 "./numeric.xs"
	STRLEN len;
	const char *pv = SvPV(number, len);
	UV value;
	int result;
#line 1600 "APItest.c"
#line 28 "./numeric.xs"
	EXTEND(SP,2);
	result = grok_number_flags(pv, len, &value, flags);
	PUSHs(sv_2mortal(newSViv(result)));
	if (result & IS_NUMBER_IN_UV)
	    PUSHs(sv_2mortal(newSVuv(value)));
#line 1607 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__numeric_grok_atoUV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_grok_atoUV)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "number, endsv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	number = ST(0)
;
	SV *	endsv = ST(1)
;
#line 39 "./numeric.xs"
	STRLEN len;
	const char *pv = SvPV(number, len);
	UV value = 0xdeadbeef;
	bool result;
	const char* endptr = pv + len;
#line 1633 "APItest.c"
#line 45 "./numeric.xs"
	EXTEND(SP,2);
	if (endsv == &PL_sv_undef) {
          result = grok_atoUV(pv, &value, NULL);
        } else {
          result = grok_atoUV(pv, &value, &endptr);
        }
	PUSHs(result ? &PL_sv_yes : &PL_sv_no);
	PUSHs(sv_2mortal(newSVuv(value)));
	if (endsv == &PL_sv_undef) {
          PUSHs(sv_2mortal(newSVpvn(NULL, 0)));
	} else {
	  if (endptr) {
	    PUSHs(sv_2mortal(newSViv(endptr - pv)));
	  } else {
	    PUSHs(sv_2mortal(newSViv(0)));
	  }
	}
#line 1652 "APItest.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'APItest.xs' from 'numeric.xs' */


XS_EUPXS(XS_XS__APItest__numeric_assertx); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_assertx)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	int	x = (int)SvIV(ST(0))
;
#line 1359 "APItest.xs"
        /* this only needs to compile and checks that assert() can be
           used this way syntactically */
	(void)(assert(x), 1);
	(void)(x);
#line 1676 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__utf8_bytes_cmp_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_bytes_cmp_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "bytes, utf8");
    {
	SV *	bytes = ST(0)
;
	SV *	utf8 = ST(1)
;
#line 1371 "APItest.xs"
	const U8 *b;
	STRLEN blen;
	const U8 *u;
	STRLEN ulen;
#line 1698 "APItest.c"
	int	RETVAL;
	dXSTARG;
#line 1376 "APItest.xs"
	b = (const U8 *)SvPVbyte(bytes, blen);
	u = (const U8 *)SvPVbyte(utf8, ulen);
	RETVAL = bytes_cmp_utf8(b, blen, u, ulen);
#line 1705 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_utf8_to_bytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_utf8_to_bytes)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "bytes, len");
    {
	U8 *	bytes = (U8 *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 1387 "APItest.xs"
        char * ret;
#line 1725 "APItest.c"
	AV *	RETVAL;
#line 1389 "APItest.xs"
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret = (char *) utf8_to_bytes(bytes, &len);
        av_push(RETVAL, newSVpv(ret, 0));

        /* utf8_to_bytes uses (STRLEN)-1 to signal errors, and we want to
         * return that as -1 to perl, so cast to SSize_t in case
         * sizeof(IV) > sizeof(STRLEN) */
        av_push(RETVAL, newSViv((SSize_t)len));
        av_push(RETVAL, newSVpv((const char *) bytes, 0));

#line 1740 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_utf8n_to_uvchr_msgs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_utf8n_to_uvchr_msgs)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 1410 "APItest.xs"
        STRLEN retlen;
        UV ret;
        U32 errors;
        AV *msgs = NULL;

#line 1771 "APItest.c"
	AV *	RETVAL;
#line 1416 "APItest.xs"
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret = utf8n_to_uvchr_msgs((U8*)  s,
                                         len,
                                         &retlen,
                                         flags,
                                         &errors,
                                         &msgs);

        /* Returns the return value in [0]; <retlen> in [1], <errors> in [2] */
        av_push(RETVAL, newSVuv(ret));
        if (retlen == (STRLEN) -1) {
            av_push(RETVAL, newSViv(-1));
        }
        else {
            av_push(RETVAL, newSVuv(retlen));
        }
        av_push(RETVAL, newSVuv(errors));

        /* And any messages in [3] */
        if (msgs) {
            av_push(RETVAL, newRV_noinc((SV*)msgs));
        }

#line 1799 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_utf8n_to_uvchr_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_utf8n_to_uvchr_error)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 1451 "APItest.xs"
        STRLEN retlen;
        UV ret;
        U32 errors;

#line 1829 "APItest.c"
	AV *	RETVAL;
#line 1456 "APItest.xs"
        /* Now that utf8n_to_uvchr() is a trivial wrapper for
         * utf8n_to_uvchr_error(), call the latter with the inputs.  It always
         * asks for the actual length to be returned and errors to be returned
         *
         * Length to assume <s> is; not checked, so could have buffer overflow
         */
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret = utf8n_to_uvchr_error((U8*) s,
                                         len,
                                         &retlen,
                                         flags,
                                         &errors);

        /* Returns the return value in [0]; <retlen> in [1], <errors> in [2] */
        av_push(RETVAL, newSVuv(ret));
        if (retlen == (STRLEN) -1) {
            av_push(RETVAL, newSViv(-1));
        }
        else {
            av_push(RETVAL, newSVuv(retlen));
        }
        av_push(RETVAL, newSVuv(errors));

#line 1857 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_valid_utf8_to_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_valid_utf8_to_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	SV *	s = ST(0)
;
#line 1489 "APItest.xs"
        STRLEN retlen;
        UV ret;

#line 1882 "APItest.c"
	AV *	RETVAL;
#line 1493 "APItest.xs"
        /* Call utf8n_to_uvchr() with the inputs.  It always asks for the
         * actual length to be returned
         *
         * Length to assume <s> is; not checked, so could have buffer overflow
         */
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret = valid_utf8_to_uvchr((U8*) SvPV_nolen(s), &retlen);

        /* Returns the return value in [0]; <retlen> in [1] */
        av_push(RETVAL, newSVuv(ret));
        av_push(RETVAL, newSVuv(retlen));

#line 1899 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_uvchr_to_utf8_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_uvchr_to_utf8_flags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "uv, flags");
    {
	SV *	uv = ST(0)
;
	SV *	flags = ST(1)
;
#line 1516 "APItest.xs"
        U8 dest[UTF8_MAXBYTES + 1];
        U8 *ret;

#line 1926 "APItest.c"
	SV *	RETVAL;
#line 1520 "APItest.xs"
        /* Call uvchr_to_utf8_flags() with the inputs.  */
        ret = uvchr_to_utf8_flags(dest, SvUV(uv), SvUV(flags));
        if (! ret) {
            XSRETURN_UNDEF;
        }
        RETVAL = newSVpvn((char *) dest, ret - dest);

#line 1936 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_uvchr_to_utf8_flags_msgs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_uvchr_to_utf8_flags_msgs)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "uv, flags");
    {
	SV *	uv = ST(0)
;
	SV *	flags = ST(1)
;
#line 1536 "APItest.xs"
        U8 dest[UTF8_MAXBYTES + 1];
        U8 *ret;

#line 1959 "APItest.c"
	AV *	RETVAL;
#line 1540 "APItest.xs"
        HV *msgs = NULL;
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret = uvchr_to_utf8_flags_msgs(dest, SvUV(uv), SvUV(flags), &msgs);

        if (ret) {
            av_push(RETVAL, newSVpvn((char *) dest, ret - dest));
        }
        else {
            av_push(RETVAL,  &PL_sv_undef);
        }

        if (msgs) {
            av_push(RETVAL, newRV_noinc((SV*)msgs));
        }

#line 1979 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Overload_amagic_deref_call); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Overload_amagic_deref_call)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, what");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
	int	what = (int)SvIV(ST(1))
;
#line 1567 "APItest.xs"
	/* The reference is owned by something else.  */
	PUSHs(amagic_deref_call(sv, what));
#line 2007 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Overload_tryAMAGICunDEREF_var); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Overload_tryAMAGICunDEREF_var)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, what");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
	int	what = (int)SvIV(ST(1))
;
#line 1578 "APItest.xs"
	{
	    SV **sp = &sv;
	    switch(what) {
	    case to_av_amg:
		tryAMAGICunDEREF(to_av);
		break;
	    case to_cv_amg:
		tryAMAGICunDEREF(to_cv);
		break;
	    case to_gv_amg:
		tryAMAGICunDEREF(to_gv);
		break;
	    case to_hv_amg:
		tryAMAGICunDEREF(to_hv);
		break;
	    case to_sv_amg:
		tryAMAGICunDEREF(to_sv);
		break;
	    default:
		croak("Invalid value %d passed to tryAMAGICunDEREF_var", what);
	    }
	}
	/* The reference is owned by something else.  */
	PUSHs(sv);
#line 2052 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_XS_VERSION_defined); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_XS_VERSION_defined)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1613 "APItest.xs"
        XS_VERSION_BOOTCHECK;
        XSRETURN_EMPTY;
#line 2071 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_XS_APIVERSION_valid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_XS_APIVERSION_valid)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1619 "APItest.xs"
        XS_APIVERSION_BOOTCHECK;
        XSRETURN_EMPTY;
#line 2090 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "len");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	int	len = (int)SvIV(ST(0))
;
#line 1625 "APItest.xs"
        int i = 0;
        EXTEND( SP, len );
        for ( ; i < len; i++ ) {
            ST(i) = sv_2mortal( newSViv(i) );
        }
        XSRETURN( len );
#line 2115 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_iv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_iv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1635 "APItest.xs"
        XSRETURN_IV(I32_MIN + 1);
#line 2133 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_uv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_uv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1640 "APItest.xs"
        XSRETURN_UV( (U32)((1U<<31) + 1) );
#line 2151 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_nv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_nv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1645 "APItest.xs"
        XSRETURN_NV(0.25);
#line 2169 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_pv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1650 "APItest.xs"
        XSRETURN_PV("returned");
#line 2187 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_pvn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_pvn)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1655 "APItest.xs"
        XSRETURN_PVN("returned too much",8);
#line 2205 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_no); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_no)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1660 "APItest.xs"
        XSRETURN_NO;
#line 2223 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_yes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_yes)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1665 "APItest.xs"
        XSRETURN_YES;
#line 2241 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_undef); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_undef)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1670 "APItest.xs"
        XSRETURN_UNDEF;
#line 2259 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_empty); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_xsreturn_empty)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1675 "APItest.xs"
        XSRETURN_EMPTY;
#line 2277 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Hash_rot13_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_rot13_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hash");
    {
	HV *	hash;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::rot13_hash",
				"hash");
		}
	} STMT_END
;
#line 1683 "APItest.xs"
	{
	    struct ufuncs uf;
	    uf.uf_val = rot13_key;
	    uf.uf_set = 0;
	    uf.uf_index = 0;

	    sv_magic((SV*)hash, NULL, PERL_MAGIC_uvar, (char*)&uf, sizeof(uf));
	}
#line 2315 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Hash_bitflip_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_bitflip_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hash");
    {
	HV *	hash;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::bitflip_hash",
				"hash");
		}
	} STMT_END
;
#line 1696 "APItest.xs"
	{
	    struct ufuncs uf;
	    uf.uf_val = bitflip_key;
	    uf.uf_set = 0;
	    uf.uf_index = 0;

	    sv_magic((SV*)hash, NULL, PERL_MAGIC_uvar, (char*)&uf, sizeof(uf));
	}
#line 2352 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#define UTF8KLEN(sv, len)   (SvUTF8(sv) ? -(I32)len : (I32)len)

XS_EUPXS(XS_XS__APItest__Hash_exists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_exists)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1710 "APItest.xs"
	STRLEN len;
	const char *key;
#line 2369 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	bool	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::exists",
				"hash");
		}
	} STMT_END
;
#line 1716 "APItest.xs"
	key = SvPV(key_sv, len);
	RETVAL = hv_exists(hash, key, UTF8KLEN(key_sv, len));
#line 2391 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_exists_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_exists_ent)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1724 "APItest.xs"
#line 2406 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	bool	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::exists_ent",
				"hash");
		}
	} STMT_END
;
#line 1728 "APItest.xs"
	RETVAL = hv_exists_ent(hash, key_sv, 0);
#line 2427 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_delete); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_delete)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "hash, key_sv, flags = 0");
    {
#line 1735 "APItest.xs"
	STRLEN len;
	const char *key;
#line 2444 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	I32	flags;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::delete",
				"hash");
		}
	} STMT_END
;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (I32)SvIV(ST(2))
;
	}
#line 1742 "APItest.xs"
	key = SvPV(key_sv, len);
	/* It's already mortal, so need to increase reference count.  */
	RETVAL
	    = SvREFCNT_inc(hv_delete(hash, key, UTF8KLEN(key_sv, len), flags));
#line 2476 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_delete_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_delete_ent)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "hash, key_sv, flags = 0");
    {
	HV *	hash;
	SV *	key_sv = ST(1)
;
	I32	flags;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::delete_ent",
				"hash");
		}
	} STMT_END
;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (I32)SvIV(ST(2))
;
	}
#line 1756 "APItest.xs"
	/* It's already mortal, so need to increase reference count.  */
	RETVAL = SvREFCNT_inc(hv_delete_ent(hash, key_sv, flags, 0));
#line 2520 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_store_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_store_ent)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "hash, key, value");
    {
#line 1764 "APItest.xs"
	SV *copy;
	HE *result;
#line 2538 "APItest.c"
	HV *	hash;
	SV *	key = ST(1)
;
	SV *	value = ST(2)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::store_ent",
				"hash");
		}
	} STMT_END
;
#line 1771 "APItest.xs"
	copy = newSV(0);
	result = hv_store_ent(hash, key, copy, 0);
	SvSetMagicSV(copy, value);
	if (!result) {
	    SvREFCNT_dec(copy);
	    XSRETURN_EMPTY;
	}
	/* It's about to become mortal, so need to increase reference count.
	 */
	RETVAL = SvREFCNT_inc(HeVAL(result));
#line 2570 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_store); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_store)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "hash, key_sv, value");
    {
#line 1787 "APItest.xs"
	STRLEN len;
	const char *key;
	SV *copy;
	SV **result;
#line 2590 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	SV *	value = ST(2)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::store",
				"hash");
		}
	} STMT_END
;
#line 1796 "APItest.xs"
	key = SvPV(key_sv, len);
	copy = newSV(0);
	result = hv_store(hash, key, UTF8KLEN(key_sv, len), copy, 0);
	SvSetMagicSV(copy, value);
	if (!result) {
	    SvREFCNT_dec(copy);
	    XSRETURN_EMPTY;
	}
	/* It's about to become mortal, so need to increase reference count.
	 */
	RETVAL = SvREFCNT_inc(*result);
#line 2623 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_fetch_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_fetch_ent)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1813 "APItest.xs"
	HE *result;
#line 2640 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::fetch_ent",
				"hash");
		}
	} STMT_END
;
#line 1818 "APItest.xs"
	result = hv_fetch_ent(hash, key_sv, 0, 0);
	if (!result) {
	    XSRETURN_EMPTY;
	}
	/* Force mg_get  */
	RETVAL = newSVsv(HeVAL(result));
#line 2666 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_fetch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_fetch)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1830 "APItest.xs"
	STRLEN len;
	const char *key;
	SV **result;
#line 2685 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::fetch",
				"hash");
		}
	} STMT_END
;
#line 1837 "APItest.xs"
	key = SvPV(key_sv, len);
	result = hv_fetch(hash, key, UTF8KLEN(key_sv, len), 0);
	if (!result) {
	    XSRETURN_EMPTY;
	}
	/* Force mg_get  */
	RETVAL = newSVsv(*result);
#line 2712 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#if defined (hv_common)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_XS__APItest__Hash_common); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_common)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "params");
    {
	HV *	params;
#line 1854 "APItest.xs"
	HE *result;
	HV *hv = NULL;
	SV *keysv = NULL;
	const char *key = NULL;
	STRLEN klen = 0;
	int flags = 0;
	int action = 0;
	SV *val = NULL;
	U32 hash = 0;
	SV **svp;
#line 2742 "APItest.c"
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    params = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::common",
				"params");
		}
	} STMT_END
;
#line 1865 "APItest.xs"
	if ((svp = hv_fetchs(params, "hv", 0))) {
	    SV *const rv = *svp;
	    if (!SvROK(rv))
		croak("common passed a non-reference for parameter hv");
	    hv = (HV *)SvRV(rv);
	}
	if ((svp = hv_fetchs(params, "keysv", 0)))
	    keysv = *svp;
	if ((svp = hv_fetchs(params, "keypv", 0))) {
	    key = SvPV_const(*svp, klen);
	    if (SvUTF8(*svp))
		flags = HVhek_UTF8;
	}
	if ((svp = hv_fetchs(params, "action", 0)))
	    action = SvIV(*svp);
	if ((svp = hv_fetchs(params, "val", 0)))
	    val = newSVsv(*svp);
	if ((svp = hv_fetchs(params, "hash", 0)))
	    hash = SvUV(*svp);

	if (hv_fetchs(params, "hash_pv", 0)) {
            assert(key);
	    PERL_HASH(hash, key, klen);
	}
	if (hv_fetchs(params, "hash_sv", 0)) {
            assert(keysv);
            {
              STRLEN len;
              const char *const p = SvPV(keysv, len);
              PERL_HASH(hash, p, len);
            }
	}

	result = (HE *)hv_common(hv, keysv, key, klen, flags, action, val, hash);
	if (!result) {
	    XSRETURN_EMPTY;
	}
	/* Force mg_get  */
	RETVAL = newSVsv(HeVAL(result));
#line 2798 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_XS__APItest__Hash_test_hv_free_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_hv_free_ent)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1912 "APItest.xs"
	test_freeent(&Perl_hv_free_ent);
	XSRETURN(4);
#line 2819 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Hash_test_hv_delayfree_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_hv_delayfree_ent)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1918 "APItest.xs"
	test_freeent(&Perl_hv_delayfree_ent);
	XSRETURN(4);
#line 2838 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Hash_test_share_unshare_pvn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_share_unshare_pvn)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "input");
    {
#line 1924 "APItest.xs"
	STRLEN len;
	U32 hash;
	char *pvx;
	char *p;
#line 2857 "APItest.c"
	SV *	input = ST(0)
;
	SV *	RETVAL;
#line 1931 "APItest.xs"
	pvx = SvPV(input, len);
	PERL_HASH(hash, pvx, len);
	p = sharepvn(pvx, len, hash);
	RETVAL = newSVpvn(p, len);
	unsharepvn(p, len, hash);
#line 2867 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#if PERL_VERSION >= 9
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_exists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_exists)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "key, level=0");
    {
	SV *	key = ST(0)
;
	IV	level;
	bool	RETVAL;

	if (items < 2)
	    level = 0;
	else {
	    level = (IV)SvIV(ST(1))
;
	}
#line 1946 "APItest.xs"
	if (level) {
	    croak("level must be zero, not %" IVdf, level);
	}
	RETVAL = (cop_hints_fetch_sv(PL_curcop, key, 0, 0) != &PL_sv_placeholder);
#line 2901 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_fetch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_fetch)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "key, level=0");
    {
	SV *	key = ST(0)
;
	IV	level;
	SV *	RETVAL;

	if (items < 2)
	    level = 0;
	else {
	    level = (IV)SvIV(ST(1))
;
	}
#line 1958 "APItest.xs"
	if (level) {
	    croak("level must be zero, not %" IVdf, level);
	}
	RETVAL = cop_hints_fetch_sv(PL_curcop, key, 0, 0);
	SvREFCNT_inc(RETVAL);
#line 2932 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_XS__APItest__Hash_test_force_keys); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_force_keys)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1971 "APItest.xs"
        HE *he;
	SSize_t count = 0;
#line 2953 "APItest.c"
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::test_force_keys",
				"hv");
		}
	} STMT_END
;
#line 1974 "APItest.xs"
        hv_iterinit(hv);
        he = hv_iternext(hv);
        while (he) {
	    SV *sv = HeSVKEY_force(he);
	    ++count;
	    EXTEND(SP, count);
	    PUSHs(sv_mortalcopy(sv));
            he = hv_iternext(hv);
        }
#line 2979 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__TempLv_make_temp_mg_lv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__TempLv_make_temp_mg_lv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	sv = ST(0)
;
#line 2003 "APItest.xs"
	SV * const lv = newSV_type(SVt_PVLV);
	STRLEN len;
#line 3000 "APItest.c"
#line 2006 "APItest.xs"
        SvPV(sv, len);

	sv_magic(lv, NULL, PERL_MAGIC_substr, NULL, 0);
	LvTYPE(lv) = 'x';
	LvTARG(lv) = SvREFCNT_inc_simple(sv);
	LvTARGOFF(lv) = len == 0 ? 0 : 1;
	LvTARGLEN(lv) = len < 2 ? 0 : len-2;

	EXTEND(SP, 1);
	ST(0) = sv_2mortal(lv);
	XSRETURN(1);
#line 3013 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__PtrTable_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "classname");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	classname = (const char *)SvPV_nolen(ST(0))
;
#line 2025 "APItest.xs"
    PUSHs(sv_setref_pv(sv_newmortal(), classname, (void*)ptr_table_new()));
#line 3033 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__PtrTable_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "table");
    {
	XS__APItest__PtrTable	table;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"XS::APItest::PtrTable::DESTROY",
			"table")
;
#line 2031 "APItest.xs"
    ptr_table_free(table);
#line 3060 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__PtrTable_store); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_store)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "table, from, to");
    {
	XS__APItest__PtrTable	table;
	SVREF	from;
	SVREF	to;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"XS::APItest::PtrTable::store",
			"table", "XS::APItest::PtrTable")
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(1);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    from = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::PtrTable::store",
				"from");
		}
	} STMT_END
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(2);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    to = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::PtrTable::store",
				"to");
		}
	} STMT_END
;
#line 2039 "APItest.xs"
   ptr_table_store(table, from, to);
#line 3116 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__PtrTable_fetch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_fetch)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "table, from");
    {
	XS__APItest__PtrTable	table;
	SVREF	from;
	UV	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"XS::APItest::PtrTable::fetch",
			"table", "XS::APItest::PtrTable")
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(1);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    from = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::PtrTable::fetch",
				"from");
		}
	} STMT_END
;
#line 2046 "APItest.xs"
   RETVAL = PTR2UV(ptr_table_fetch(table, from));
#line 3159 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__PtrTable_split); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_split)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "table");
    {
	XS__APItest__PtrTable	table;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"XS::APItest::PtrTable::split",
			"table", "XS::APItest::PtrTable")
;

	ptr_table_split(table);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__PtrTable_clear); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_clear)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "table");
    {
	XS__APItest__PtrTable	table;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"XS::APItest::PtrTable::clear",
			"table", "XS::APItest::PtrTable")
;

	ptr_table_clear(table);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOAD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOAD)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 2063 "APItest.xs"
	RETVAL = newSVpvn_flags(SvPVX(cv), SvCUR(cv), SvUTF8(cv));
#line 3226 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOADp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOADp)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	RETVAL;
#line 2071 "APItest.xs"
        PERL_UNUSED_ARG(items);
	RETVAL = newSVpvn_flags(SvPVX(cv), SvCUR(cv), SvUTF8(cv));
#line 3245 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_custom_ops); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_custom_ops)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 2092 "APItest.xs"
        RETVAL = PL_custom_ops;
#line 3263 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_custom_op_names); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_custom_op_names)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 2099 "APItest.xs"
        PL_custom_op_names = newHV();
        RETVAL = PL_custom_op_names;
#line 3286 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_custom_op_descs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_custom_op_descs)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 2107 "APItest.xs"
        PL_custom_op_descs = newHV();
        RETVAL = PL_custom_op_descs;
#line 3309 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_register); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_register)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2115 "APItest.xs"
        XopENTRY_set(&my_xop, xop_name, "my_xop");
        XopENTRY_set(&my_xop, xop_desc, "XOP for testing");
        XopENTRY_set(&my_xop, xop_class, OA_UNOP);
        XopENTRY_set(&my_xop, xop_peep, peep_xop);
        Perl_custom_op_register(aTHX_ pp_xop, &my_xop);
#line 3334 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_xop_clear); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_clear)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2124 "APItest.xs"
        XopDISABLE(&my_xop, xop_name);
        XopDISABLE(&my_xop, xop_desc);
        XopDISABLE(&my_xop, xop_class);
        XopDISABLE(&my_xop, xop_peep);
#line 3352 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_xop_my_xop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_my_xop)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 2132 "APItest.xs"
        RETVAL = PTR2IV(&my_xop);
#line 3369 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_ppaddr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_ppaddr)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 2139 "APItest.xs"
        RETVAL = PTR2IV(pp_xop);
#line 3387 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_OA_UNOP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_OA_UNOP)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 2146 "APItest.xs"
        RETVAL = OA_UNOP;
#line 3405 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_build_optree); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_build_optree)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	AV *	RETVAL;
#line 2153 "APItest.xs"
        dMY_CXT;
        UNOP *unop;
        OP *kid;

        MY_CXT.xop_record = newAV();

        kid = newSVOP(OP_CONST, 0, newSViv(42));

        unop = (UNOP*)mkUNOP(OP_CUSTOM, kid);
        unop->op_ppaddr     = pp_xop;
        unop->op_private    = 0;
        unop->op_next       = NULL;
        kid->op_next        = (OP*)unop;

        av_push(MY_CXT.xop_record, newSVpvf("unop:%" UVxf, PTR2UV(unop)));
        av_push(MY_CXT.xop_record, newSVpvf("kid:%" UVxf, PTR2UV(kid)));

        av_push(MY_CXT.xop_record, newSVpvf("NAME:%s", OP_NAME((OP*)unop)));
        av_push(MY_CXT.xop_record, newSVpvf("DESC:%s", OP_DESC((OP*)unop)));
        av_push(MY_CXT.xop_record, newSVpvf("CLASS:%d", (int)OP_CLASS((OP*)unop)));

        PL_rpeepp(aTHX_ kid);

        FreeOp(kid);
        FreeOp(unop);

        RETVAL = MY_CXT.xop_record;
        MY_CXT.xop_record = NULL;
#line 3449 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_from_custom_op); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_from_custom_op)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 2187 "APItest.xs"
/* author note: this test doesn't imply Perl_custom_op_xop is or isn't public
   API or that Perl_custom_op_xop is known to be used outside the core */
        UNOP *unop;
        XOP *xop;

        unop = (UNOP*)mkUNOP(OP_CUSTOM, NULL);
        unop->op_ppaddr     = pp_xop;
        unop->op_private    = 0;
        unop->op_next       = NULL;

        xop = Perl_custom_op_xop(aTHX_ (OP *)unop);
        FreeOp(unop);
        RETVAL = PTR2IV(xop);
#line 3484 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_CLONE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_CLONE)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 2239 "APItest.xs"
    MY_CXT_CLONE;
    PERL_UNUSED_VAR(items);
    MY_CXT.sv = newSVpv("initial_clone",0);
    MY_CXT.cscgv = gv_fetchpvs("XS::APItest::COMPILE_SCOPE_CONTAINER",
        GV_ADDMULTI, SVt_PVAV);
    MY_CXT.cscav = NULL;
    MY_CXT.bhkav = get_av("XS::APItest::bhkav", GV_ADDMULTI);
    MY_CXT.bhk_record = 0;
    MY_CXT.peep_recorder = newAV();
    MY_CXT.rpeep_recorder = newAV();
#line 3509 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_double)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	double	val = (double)SvNV(ST(0))
;
#line 2254 "APItest.xs"
        printf("%5.3f\n",val);
#line 3526 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_have_long_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_have_long_double)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2259 "APItest.xs"
#ifdef HAS_LONG_DOUBLE
        RETVAL = 1;
#else
        RETVAL = 0;
#endif
#line 3547 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_print_long_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_long_double)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2270 "APItest.xs"
#ifdef HAS_LONG_DOUBLE
#   if defined(PERL_PRIfldbl) && (LONG_DOUBLESIZE > DOUBLESIZE)
        long double val = 7.0;
        printf("%5.3" PERL_PRIfldbl "\n",val);
#   else
        double val = 7.0;
        printf("%5.3f\n",val);
#   endif
#endif
#line 3571 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_int); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_int)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	int	val = (int)SvIV(ST(0))
;
#line 2284 "APItest.xs"
        printf("%d\n",val);
#line 3588 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_long); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_long)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	long	val = (long)SvIV(ST(0))
;
#line 2290 "APItest.xs"
        printf("%ld\n",val);
#line 3605 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_float); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_float)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	float	val = (float)SvNV(ST(0))
;
#line 2296 "APItest.xs"
        printf("%5.3f\n",val);
#line 3622 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_flush); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_flush)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2301 "APItest.xs"
	fflush(stdout);
#line 3637 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_mpushp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushp)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2306 "APItest.xs"
	EXTEND(SP, 3);
	mPUSHp("one", 3);
	mPUSHp("two", 3);
	mPUSHp("three", 5);
	XSRETURN(3);
#line 3658 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mpushn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushn)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2315 "APItest.xs"
	EXTEND(SP, 3);
	mPUSHn(0.5);
	mPUSHn(-0.25);
	mPUSHn(0.125);
	XSRETURN(3);
#line 3680 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mpushi); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushi)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2324 "APItest.xs"
	EXTEND(SP, 3);
	mPUSHi(-1);
	mPUSHi(2);
	mPUSHi(-3);
	XSRETURN(3);
#line 3702 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mpushu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushu)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2333 "APItest.xs"
	EXTEND(SP, 3);
	mPUSHu(1);
	mPUSHu(2);
	mPUSHu(3);
	XSRETURN(3);
#line 3724 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushp)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2342 "APItest.xs"
	mXPUSHp("one", 3);
	mXPUSHp("two", 3);
	mXPUSHp("three", 5);
	XSRETURN(3);
#line 3745 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushn)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2350 "APItest.xs"
	mXPUSHn(0.5);
	mXPUSHn(-0.25);
	mXPUSHn(0.125);
	XSRETURN(3);
#line 3766 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushi); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushi)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2358 "APItest.xs"
	mXPUSHi(-1);
	mXPUSHi(2);
	mXPUSHi(-3);
	XSRETURN(3);
#line 3787 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushu)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2366 "APItest.xs"
	mXPUSHu(1);
	mXPUSHu(2);
	mXPUSHu(3);
	XSRETURN(3);
#line 3808 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_test_EXTEND); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_EXTEND)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "max_offset, nsv, use_ss");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	IV	max_offset = (IV)SvIV(ST(0))
;
	SV *	nsv = ST(1)
;
	bool	use_ss = (bool)SvTRUE(ST(2))
;
#line 2389 "APItest.xs"
    SV **sp = PL_stack_max + max_offset;
#line 3832 "APItest.c"
#line 2391 "APItest.xs"
    if (use_ss) {
        SSize_t n = (SSize_t)SvIV(nsv);
        EXTEND(sp, n);
        *(sp + n) = NULL;
    }
    else {
        IV n = SvIV(nsv);
        EXTEND(sp, n);
        *(sp + n) = NULL;
    }
    *PL_stack_max = NULL;
#line 3845 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_sv_C); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_sv_C)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2407 "APItest.xs"
    CV * i_sub;
    GV * i_gv;
    I32 retcnt;
    SV * errsv;
    char * errstr;
    STRLEN errlen;
    SV * miscsv = sv_newmortal();
    HV * hv = (HV*)sv_2mortal((SV*)newHV());
#line 3868 "APItest.c"
#line 2416 "APItest.xs"
    i_sub = get_cv("i", 0);
    PUSHMARK(SP);
    /* PUTBACK not needed since this sub was called with 0 args, and is calling
      0 args, so global SP doesn't need to be moved before a call_* */
    retcnt = call_sv((SV*)i_sub, 0); /* try a CV* */
    SPAGAIN;
    SP -= retcnt; /* dont care about return count, wipe everything off */
    sv_setpvs(miscsv, "i");
    PUSHMARK(SP);
    retcnt = call_sv(miscsv, 0); /* try a PV */
    SPAGAIN;
    SP -= retcnt;
    /* no add and SVt_NULL are intentional, sub i should be defined already */
    i_gv = gv_fetchpvn_flags("i", sizeof("i")-1, 0, SVt_NULL);
    PUSHMARK(SP);
    retcnt = call_sv((SV*)i_gv, 0); /* try a GV* */
    SPAGAIN;
    SP -= retcnt;
    /* the tests below are not declaring this being public API behavior,
       only current internal behavior, these tests can be changed in the
       future if necessery */
    PUSHMARK(SP);
    retcnt = call_sv(&PL_sv_yes, G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV(errsv, errlen);
    if(memBEGINs(errstr, errlen, "Undefined subroutine &main::1 called at")) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
    PUSHMARK(SP);
    retcnt = call_sv(&PL_sv_no, G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV(errsv, errlen);
    if(memBEGINs(errstr, errlen, "Undefined subroutine &main:: called at")) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
    PUSHMARK(SP);
    retcnt = call_sv(&PL_sv_undef,  G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV(errsv, errlen);
    if(memBEGINs(errstr, errlen, "Can't use an undefined value as a subroutine reference at")) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
    PUSHMARK(SP);
    retcnt = call_sv((SV*)hv,  G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV(errsv, errlen);
    if(memBEGINs(errstr, errlen, "Not a CODE reference at")) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
#line 3939 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_call_sv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_sv)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "sv, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	sv = ST(0)
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2491 "APItest.xs"
	I32 i;
#line 3960 "APItest.c"
#line 2493 "APItest.xs"
	for (i=0; i<items-2; i++)
	    ST(i) = ST(i+2); /* pop first two args */
	PUSHMARK(SP);
	SP += items - 2;
	PUTBACK;
	i = call_sv(sv, flags);
	SPAGAIN;
	EXTEND(SP, 1);
	PUSHs(sv_2mortal(newSViv(i)));
#line 3971 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_pv)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "subname, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char*	subname = (char *)SvPV_nolen(ST(0))
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2508 "APItest.xs"
	I32 i;
#line 3993 "APItest.c"
#line 2510 "APItest.xs"
	for (i=0; i<items-2; i++)
	    ST(i) = ST(i+2); /* pop first two args */
	PUSHMARK(SP);
	SP += items - 2;
	PUTBACK;
	i = call_pv(subname, flags);
	SPAGAIN;
	EXTEND(SP, 1);
	PUSHs(sv_2mortal(newSViv(i)));
#line 4004 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_argv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_argv)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "subname, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char*	subname = (char *)SvPV_nolen(ST(0))
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2525 "APItest.xs"
	I32 i;
	char *tmpary[4];
#line 4027 "APItest.c"
#line 2528 "APItest.xs"
	for (i=0; i<items-2; i++)
	    tmpary[i] = SvPV_nolen(ST(i+2)); /* ignore first two args */
	tmpary[i] = NULL;
	PUTBACK;
	i = call_argv(subname, flags, tmpary);
	SPAGAIN;
	EXTEND(SP, 1);
	PUSHs(sv_2mortal(newSViv(i)));
#line 4037 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_method)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "methname, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char*	methname = (char *)SvPV_nolen(ST(0))
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2542 "APItest.xs"
	I32 i;
#line 4059 "APItest.c"
#line 2544 "APItest.xs"
	for (i=0; i<items-2; i++)
	    ST(i) = ST(i+2); /* pop first two args */
	PUSHMARK(SP);
	SP += items - 2;
	PUTBACK;
	i = call_method(methname, flags);
	SPAGAIN;
	EXTEND(SP, 1);
	PUSHs(sv_2mortal(newSViv(i)));
#line 4070 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_newCONSTSUB); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_newCONSTSUB)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 4)
       croak_xs_usage(cv,  "stash, name, flags, sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	name = ST(1)
;
	I32	flags = (I32)SvIV(ST(2))
;
	SV*	sv = ST(3)
;
#line 2563 "APItest.xs"
	CV* mycv = NULL;
	STRLEN len;
	const char *pv = SvPV(name, len);
#line 4098 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				GvNAME(CvGV(cv)),
				"stash");
		}
	} STMT_END
;
#line 2567 "APItest.xs"
        switch (ix) {
           case 0:
               mycv = newCONSTSUB(stash, pv, SvOK(sv) ? SvREFCNT_inc(sv) : NULL);
               break;
           case 1:
               mycv = newCONSTSUB_flags(
                 stash, pv, len, flags | SvUTF8(name), SvOK(sv) ? SvREFCNT_inc(sv) : NULL
               );
               break;
        }
        EXTEND(SP, 2);
        assert(mycv);
        PUSHs( CvCONST(mycv) ? &PL_sv_yes : &PL_sv_no );
        PUSHs((SV*)CvGV(mycv));
#line 4128 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_init_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_init_type)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "namesv, multi, flags, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	namesv = ST(0)
;
	int	multi = (int)SvIV(ST(1))
;
	I32	flags = (I32)SvIV(ST(2))
;
	int	type = (int)SvIV(ST(3))
;
#line 2589 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(namesv, len);
        GV *gv = *(GV**)hv_fetch(PL_defstash, name, len, TRUE);
#line 4156 "APItest.c"
#line 2593 "APItest.xs"
        if (SvTYPE(gv) == SVt_PVGV)
            Perl_croak(aTHX_ "GV is already a PVGV");
        if (multi) flags |= GV_ADDMULTI;
        switch (type) {
           case 0:
	       gv_init(gv, PL_defstash, name, len, multi);
               break;
           case 1:
               gv_init_sv(gv, PL_defstash, namesv, flags);
               break;
           case 2:
               gv_init_pv(gv, PL_defstash, name, flags | SvUTF8(namesv));
               break;
           case 3:
               gv_init_pvn(gv, PL_defstash, name, len, flags | SvUTF8(namesv));
               break;
        }
	XPUSHs( gv ? (SV*)gv : &PL_sv_undef);
#line 4176 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_fetchmeth_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_fetchmeth_type)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "stash, methname, type, level, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	level = (I32)SvIV(ST(3))
;
	I32	flags = (I32)SvIV(ST(4))
;
#line 2620 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(methname, len);
	GV* gv = NULL;
#line 4205 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_fetchmeth_type",
				"stash");
		}
	} STMT_END
;
#line 2624 "APItest.xs"
        switch (type) {
           case 0:
	       gv = gv_fetchmeth(stash, name, len, level);
               break;
           case 1:
               gv = gv_fetchmeth_sv(stash, methname, level, flags);
               break;
           case 2:
               gv = gv_fetchmeth_pv(stash, name, level, flags | SvUTF8(methname));
               break;
           case 3:
               gv = gv_fetchmeth_pvn(stash, name, len, level, flags | SvUTF8(methname));
               break;
        }
	XPUSHs( gv ? MUTABLE_SV(gv) : &PL_sv_undef );
#line 4236 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_fetchmeth_autoload_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_fetchmeth_autoload_type)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "stash, methname, type, level, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	level = (I32)SvIV(ST(3))
;
	I32	flags = (I32)SvIV(ST(4))
;
#line 2648 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(methname, len);
	GV* gv = NULL;
#line 4265 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_fetchmeth_autoload_type",
				"stash");
		}
	} STMT_END
;
#line 2652 "APItest.xs"
        switch (type) {
           case 0:
	       gv = gv_fetchmeth_autoload(stash, name, len, level);
               break;
           case 1:
               gv = gv_fetchmeth_sv_autoload(stash, methname, level, flags);
               break;
           case 2:
               gv = gv_fetchmeth_pv_autoload(stash, name, level, flags | SvUTF8(methname));
               break;
           case 3:
               gv = gv_fetchmeth_pvn_autoload(stash, name, len, level, flags | SvUTF8(methname));
               break;
        }
	XPUSHs( gv ? MUTABLE_SV(gv) : &PL_sv_undef );
#line 4296 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_fetchmethod_flags_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_fetchmethod_flags_type)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "stash, methname, type, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	flags = (I32)SvIV(ST(3))
;
#line 2675 "APItest.xs"
	GV* gv = NULL;
#line 4321 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_fetchmethod_flags_type",
				"stash");
		}
	} STMT_END
;
#line 2677 "APItest.xs"
        switch (type) {
           case 0:
	       gv = gv_fetchmethod_flags(stash, SvPVX_const(methname), flags);
               break;
           case 1:
               gv = gv_fetchmethod_sv_flags(stash, methname, flags);
               break;
           case 2:
               gv = gv_fetchmethod_pv_flags(stash, SvPV_nolen(methname), flags | SvUTF8(methname));
               break;
           case 3: {
               STRLEN len;
               const char * const name = SvPV_const(methname, len);
               gv = gv_fetchmethod_pvn_flags(stash, name, len, flags | SvUTF8(methname));
               break;
            }
           case 4:
               gv = gv_fetchmethod_pvn_flags(stash, SvPV_nolen(methname),
                                             flags, SvUTF8(methname));
        }
	XPUSHs( gv ? (SV*)gv : &PL_sv_undef);
#line 4358 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_autoload_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_autoload_type)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "stash, methname, type, method");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	method = (I32)SvIV(ST(3))
;
#line 2706 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(methname, len);
	GV* gv = NULL;
	I32 flags = method ? GV_AUTOLOAD_ISMETHOD : 0;
#line 4386 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_autoload_type",
				"stash");
		}
	} STMT_END
;
#line 2711 "APItest.xs"
        switch (type) {
           case 0:
	       gv = gv_autoload4(stash, name, len, method);
               break;
           case 1:
               gv = gv_autoload_sv(stash, methname, flags);
               break;
           case 2:
               gv = gv_autoload_pv(stash, name, flags | SvUTF8(methname));
               break;
           case 3:
               gv = gv_autoload_pvn(stash, name, len, flags | SvUTF8(methname));
               break;
        }
	XPUSHs( gv ? (SV*)gv : &PL_sv_undef);
#line 4417 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_const_sv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_const_sv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
#line 2730 "APItest.xs"
        GV *gv;
#line 4433 "APItest.c"
	SV *	RETVAL;
	SV *	name = ST(0)
;
#line 2732 "APItest.xs"
        if (SvPOK(name)) {
	    HV *stash = gv_stashpv("main",0);
	    HE *he = hv_fetch_ent(stash, name, 0, 0);
	    gv = (GV *)HeVAL(he);
        }
	else {
	    gv = (GV *)name;
        }
        RETVAL = gv_const_sv(gv);
        if (!RETVAL)
            XSRETURN_EMPTY;
	RETVAL = newSVsv(RETVAL);
#line 4450 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_whichsig_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_whichsig_type)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "namesv, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	namesv = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 2752 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(namesv, len);
        I32 i = 0;
#line 4475 "APItest.c"
#line 2756 "APItest.xs"
        switch (type) {
           case 0:
              i = whichsig(name);
               break;
           case 1:
               i = whichsig_sv(namesv);
               break;
           case 2:
               i = whichsig_pv(name);
               break;
           case 3:
               i = whichsig_pvn(name, len);
               break;
        }
        XPUSHs(sv_2mortal(newSViv(i)));
#line 4492 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_eval_sv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_eval_sv)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	sv = ST(0)
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2777 "APItest.xs"
    	I32 i;
#line 4514 "APItest.c"
#line 2779 "APItest.xs"
	PUTBACK;
	i = eval_sv(sv, flags);
	SPAGAIN;
	EXTEND(SP, 1);
	PUSHs(sv_2mortal(newSViv(i)));
#line 4521 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_eval_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_eval_pv)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, croak_on_error");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char*	p = (const char *)SvPV_nolen(ST(0))
;
	I32	croak_on_error = (I32)SvIV(ST(1))
;
#line 2790 "APItest.xs"
	PUTBACK;
	EXTEND(SP, 1);
	PUSHs(eval_pv(p, croak_on_error));
#line 4545 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_require_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_require_pv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char*	pv = (const char *)SvPV_nolen(ST(0))
;
#line 2798 "APItest.xs"
	PUTBACK;
	require_pv(pv);
#line 4566 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_apitest_exception); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_apitest_exception)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "throw_e");
    {
	int	throw_e = (int)SvIV(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = apitest_exception(throw_e);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_mycroak); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mycroak)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV*	sv = ST(0)
;
#line 2811 "APItest.xs"
    if (SvOK(sv)) {
        Perl_croak(aTHX_ "%s", SvPV_nolen(sv));
    }
    else {
	Perl_croak(aTHX_ NULL);
    }
#line 4608 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_strtab); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_strtab)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 2821 "APItest.xs"
   RETVAL = newRV_inc((SV*)PL_strtab);
#line 4624 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_my_cxt_getint); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_getint)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2828 "APItest.xs"
	dMY_CXT;
	RETVAL = my_cxt_getint_p(aMY_CXT);
#line 4644 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_my_cxt_setint); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_setint)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "i");
    {
	int	i = (int)SvIV(ST(0))
;
#line 2837 "APItest.xs"
	dMY_CXT;
	my_cxt_setint_p(aMY_CXT_ i);
#line 4663 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_my_cxt_getsv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_getsv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "how");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	bool	how = (bool)SvTRUE(ST(0))
;
#line 2844 "APItest.xs"
	EXTEND(SP, 1);
	ST(0) = how ? my_cxt_getsv_interp_context() : my_cxt_getsv_interp();
	XSRETURN(1);
#line 4684 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_my_cxt_setsv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_setsv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 2852 "APItest.xs"
	dMY_CXT;
	SvREFCNT_dec(MY_CXT.sv);
	my_cxt_setsv_p(sv _aMY_CXT);
	SvREFCNT_inc(sv);
#line 4705 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_core); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_core)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;

	RETVAL = sv_setsv_cow_hashkey_core();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_notcore); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_notcore)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;

	RETVAL = sv_setsv_cow_hashkey_notcore();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_set_deref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_set_deref)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "sv, sv2, which");
    {
	SV *	sv = ST(0)
;
	SV *	sv2 = ST(1)
;
	int	which = (int)SvIV(ST(2))
;
#line 2866 "APItest.xs"
    {
	STRLEN len;
	const char *pv = SvPV(sv2,len);
	if (!SvROK(sv)) croak("Not a ref");
	sv = SvRV(sv);
	switch (which) {
	    case 0: sv_setsv(sv,sv2); break;
	    case 1: sv_setpv(sv,pv); break;
	    case 2: sv_setpvn(sv,pv,len); break;
	}
    }
#line 4768 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_rmagical_cast); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_rmagical_cast)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
	SV *	type = ST(1)
;
#line 2883 "APItest.xs"
	struct ufuncs uf;
#line 4789 "APItest.c"
#line 2885 "APItest.xs"
	if (!SvOK(sv) || !SvROK(sv) || !SvOK(type)) { XSRETURN_UNDEF; }
	sv = SvRV(sv);
	if (SvTYPE(sv) != SVt_PVHV) { XSRETURN_UNDEF; }
	uf.uf_val = rmagical_a_dummy;
	uf.uf_set = NULL;
	uf.uf_index = 0;
	if (SvTRUE(type)) { /* b */
	    sv_magicext(sv, NULL, PERL_MAGIC_ext, &rmagical_b, NULL, 0);
	} else { /* a */
	    sv_magic(sv, NULL, PERL_MAGIC_uvar, (char *) &uf, sizeof(uf));
	}
	XSRETURN_YES;
#line 4803 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_rmagical_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_rmagical_flags)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
#line 2902 "APItest.xs"
	if (!SvOK(sv) || !SvROK(sv)) { XSRETURN_UNDEF; }
	sv = SvRV(sv);
        EXTEND(SP, 3); 
	mXPUSHu(SvFLAGS(sv) & SVs_GMG);
	mXPUSHu(SvFLAGS(sv) & SVs_SMG);
	mXPUSHu(SvFLAGS(sv) & SVs_RMG);
        XSRETURN(3);
#line 4829 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_my_caller); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_caller)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "level");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	I32	level = (I32)SvIV(ST(0))
;
#line 2914 "APItest.xs"
        const PERL_CONTEXT *cx, *dbcx;
        const char *pv;
        const GV *gv;
        HV *hv;
#line 4852 "APItest.c"
#line 2919 "APItest.xs"
        cx = caller_cx(level, &dbcx);
        EXTEND(SP, 8);

        pv = CopSTASHPV(cx->blk_oldcop);
        ST(0) = pv ? sv_2mortal(newSVpv(pv, 0)) : &PL_sv_undef;
        gv = CvGV(cx->blk_sub.cv);
        ST(1) = isGV(gv) ? sv_2mortal(newSVpv(GvNAME(gv), 0)) : &PL_sv_undef;

        pv = CopSTASHPV(dbcx->blk_oldcop);
        ST(2) = pv ? sv_2mortal(newSVpv(pv, 0)) : &PL_sv_undef;
        gv = CvGV(dbcx->blk_sub.cv);
        ST(3) = isGV(gv) ? sv_2mortal(newSVpv(GvNAME(gv), 0)) : &PL_sv_undef;

        ST(4) = cop_hints_fetch_pvs(cx->blk_oldcop, "foo", 0);
        ST(5) = cop_hints_fetch_pvn(cx->blk_oldcop, "foo", 3, 0, 0);
        ST(6) = cop_hints_fetch_sv(cx->blk_oldcop, 
                sv_2mortal(newSVpvs("foo")), 0, 0);

        hv = cop_hints_2hv(cx->blk_oldcop, 0);
        ST(7) = hv ? sv_2mortal(newRV_noinc((SV *)hv)) : &PL_sv_undef;

        XSRETURN(8);
#line 4876 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_DPeek); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_DPeek)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
#line 2947 "APItest.xs"
    ST (0) = newSVpv (Perl_sv_peek (aTHX_ sv), 0);
    XSRETURN (1);
#line 4897 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_BEGIN); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_BEGIN)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2953 "APItest.xs"
	sv_inc(get_sv("XS::APItest::BEGIN_called", GV_ADD|GV_ADDMULTI));
#line 4913 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_CHECK); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_CHECK)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2958 "APItest.xs"
	sv_inc(get_sv("XS::APItest::CHECK_called", GV_ADD|GV_ADDMULTI));
#line 4928 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_UNITCHECK); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_UNITCHECK)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2963 "APItest.xs"
	sv_inc(get_sv("XS::APItest::UNITCHECK_called", GV_ADD|GV_ADDMULTI));
#line 4943 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_INIT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_INIT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2968 "APItest.xs"
	sv_inc(get_sv("XS::APItest::INIT_called", GV_ADD|GV_ADDMULTI));
#line 4958 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_END); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_END)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2973 "APItest.xs"
	sv_inc(get_sv("XS::APItest::END_called", GV_ADD|GV_ADDMULTI));
#line 4973 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_utf16_to_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_utf16_to_utf8)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "sv, ...");
    {
	SV*	sv = ST(0)
;
#line 2981 "APItest.xs"
        STRLEN len;
	U8 *source;
	SV *dest;
	I32 got; /* Gah, badly thought out APIs */
#line 4994 "APItest.c"
#line 2986 "APItest.xs"
	if (ix) (void)SvPV_force_nolen(sv);
	source = (U8 *)SvPVbyte(sv, len);
	/* Optionally only convert part of the buffer.  */ 	
	if (items > 1) {
	    len = SvUV(ST(1));
 	}
	/* Mortalise this right now, as we'll be testing croak()s  */
	dest = sv_2mortal(newSV(len * 2 + 1));
	if (ix) {
	    utf16_to_utf8_reversed(source, (U8 *)SvPVX(dest), len, &got);
	} else {
	    utf16_to_utf8(source, (U8 *)SvPVX(dest), len, &got);
	}
	SvCUR_set(dest, got);
	SvPVX(dest)[got] = '\0';
	SvPOK_on(dest);
 	ST(0) = dest;
	XSRETURN(1);
#line 5014 "APItest.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_my_exit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_exit)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "exitcode");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	int	exitcode = (int)SvIV(ST(0))
;
#line 3008 "APItest.xs"
        my_exit(exitcode);
#line 5033 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_first_byte); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_first_byte)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
	U8	RETVAL;
	dXSTARG;
#line 3014 "APItest.xs"
    char *s;
    STRLEN len;
	s = SvPVbyte(sv, len);
	RETVAL = s[0];
#line 5056 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_count)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	I32	RETVAL;
	dXSTARG;
#line 3024 "APItest.xs"
	    RETVAL = PL_sv_count;
#line 5074 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_bhk_record); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_bhk_record)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "on");
    {
	bool	on = (bool)SvTRUE(ST(0))
;
#line 3031 "APItest.xs"
        dMY_CXT;
        MY_CXT.bhk_record = on;
        if (on)
            av_clear(MY_CXT.bhkav);
#line 5095 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_magic_chain); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_magic_chain)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3039 "APItest.xs"
	SV *sv;
	MAGIC *callmg, *uvarmg;
#line 5111 "APItest.c"
#line 3042 "APItest.xs"
	sv = sv_2mortal(newSV(0));
	if (SvTYPE(sv) >= SVt_PVMG) croak_fail();
	if (SvMAGICAL(sv)) croak_fail();
	sv_magic(sv, &PL_sv_yes, PERL_MAGIC_checkcall, (char*)&callmg, 0);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_uvar)) croak_fail();
	callmg = mg_find(sv, PERL_MAGIC_checkcall);
	if (!callmg) croak_fail();
	if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
	    croak_fail();
	sv_magic(sv, &PL_sv_no, PERL_MAGIC_uvar, (char*)&uvarmg, 0);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
	uvarmg = mg_find(sv, PERL_MAGIC_uvar);
	if (!uvarmg) croak_fail();
	if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
	    croak_fail();
	if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
	    croak_fail();
	mg_free_type(sv, PERL_MAGIC_vec);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
	if (mg_find(sv, PERL_MAGIC_uvar) != uvarmg) croak_fail();
	if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
	    croak_fail();
	if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
	    croak_fail();
	mg_free_type(sv, PERL_MAGIC_uvar);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
	if (mg_find(sv, PERL_MAGIC_uvar)) croak_fail();
	if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
	    croak_fail();
	sv_magic(sv, &PL_sv_no, PERL_MAGIC_uvar, (char*)&uvarmg, 0);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
	uvarmg = mg_find(sv, PERL_MAGIC_uvar);
	if (!uvarmg) croak_fail();
	if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
	    croak_fail();
	if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
	    croak_fail();
	mg_free_type(sv, PERL_MAGIC_checkcall);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_uvar) != uvarmg) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall)) croak_fail();
	if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
	    croak_fail();
	mg_free_type(sv, PERL_MAGIC_uvar);
	if (SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_uvar)) croak_fail();
#line 5171 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_op_contextualize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_op_contextualize)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3104 "APItest.xs"
	OP *o;
#line 5186 "APItest.c"
#line 3106 "APItest.xs"
	o = newSVOP(OP_CONST, 0, newSViv(0));
	o->op_flags &= ~OPf_WANT;
	o = op_contextualize(o, G_SCALAR);
	if (o->op_type != OP_CONST ||
		(o->op_flags & OPf_WANT) != OPf_WANT_SCALAR)
	    croak_fail();
	op_free(o);
	o = newSVOP(OP_CONST, 0, newSViv(0));
	o->op_flags &= ~OPf_WANT;
	o = op_contextualize(o, G_ARRAY);
	if (o->op_type != OP_CONST ||
		(o->op_flags & OPf_WANT) != OPf_WANT_LIST)
	    croak_fail();
	op_free(o);
	o = newSVOP(OP_CONST, 0, newSViv(0));
	o->op_flags &= ~OPf_WANT;
	o = op_contextualize(o, G_VOID);
	if (o->op_type != OP_NULL) croak_fail();
	op_free(o);
#line 5207 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_rv2cv_op_cv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_rv2cv_op_cv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3130 "APItest.xs"
	GV *troc_gv;
	CV *troc_cv;
	OP *o;
#line 5224 "APItest.c"
#line 3134 "APItest.xs"
	troc_gv = gv_fetchpv("XS::APItest::test_rv2cv_op_cv", 0, SVt_PVGV);
	troc_cv = get_cv("XS::APItest::test_rv2cv_op_cv", 0);
	o = newCVREF(0, newGVOP(OP_GV, 0, troc_gv));
	if (rv2cv_op_cv(o, 0) != troc_cv) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV) != (CV*)troc_gv)
	    croak_fail();
	o->op_private |= OPpENTERSUB_AMPER;
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	o->op_private &= ~OPpENTERSUB_AMPER;
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_MARK_EARLY) != troc_cv) croak_fail();
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	op_free(o);
	o = newSVOP(OP_CONST, 0, newSVpv("XS::APItest::test_rv2cv_op_cv", 0));
	o->op_private = OPpCONST_BARE;
	o = newCVREF(0, o);
	if (rv2cv_op_cv(o, 0) != troc_cv) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV) != (CV*)troc_gv)
	    croak_fail();
	o->op_private |= OPpENTERSUB_AMPER;
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	op_free(o);
	o = newCVREF(0, newSVOP(OP_CONST, 0, newRV_inc((SV*)troc_cv)));
	if (rv2cv_op_cv(o, 0) != troc_cv) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV) != (CV*)troc_gv)
	    croak_fail();
	o->op_private |= OPpENTERSUB_AMPER;
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	o->op_private &= ~OPpENTERSUB_AMPER;
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_MARK_EARLY) != troc_cv) croak_fail();
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	op_free(o);
	o = newCVREF(0, newUNOP(OP_RAND, 0, newSVOP(OP_CONST, 0, newSViv(0))));
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	o->op_private |= OPpENTERSUB_AMPER;
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	o->op_private &= ~OPpENTERSUB_AMPER;
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_MARK_EARLY)) croak_fail();
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	op_free(o);
	o = newUNOP(OP_RAND, 0, newSVOP(OP_CONST, 0, newSViv(0)));
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	op_free(o);
#line 5277 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_cv_getset_call_checker); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_cv_getset_call_checker)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3189 "APItest.xs"
	CV *troc_cv, *tsh_cv;
	Perl_call_checker ckfun;
	SV *ckobj;
	U32 ckflags;
#line 5295 "APItest.c"
#line 3194 "APItest.xs"
#define check_cc(cv, xckfun, xckobj, xckflags) \
    do { \
	cv_get_call_checker((cv), &ckfun, &ckobj); \
	if (ckfun != (xckfun)) croak_fail_nep(FPTR2DPTR(void *, ckfun), xckfun); \
	if (ckobj != (xckobj)) croak_fail_nep(FPTR2DPTR(void *, ckobj), xckobj); \
	cv_get_call_checker_flags((cv), CALL_CHECKER_REQUIRE_GV, &ckfun, &ckobj, &ckflags); \
	if (ckfun != (xckfun)) croak_fail_nep(FPTR2DPTR(void *, ckfun), xckfun); \
	if (ckobj != (xckobj)) croak_fail_nep(FPTR2DPTR(void *, ckobj), xckobj); \
	if (ckflags != CALL_CHECKER_REQUIRE_GV) croak_fail_nei(ckflags, CALL_CHECKER_REQUIRE_GV); \
	cv_get_call_checker_flags((cv), 0, &ckfun, &ckobj, &ckflags); \
	if (ckfun != (xckfun)) croak_fail_nep(FPTR2DPTR(void *, ckfun), xckfun); \
	if (ckobj != (xckobj)) croak_fail_nep(FPTR2DPTR(void *, ckobj), xckobj); \
	if (ckflags != (xckflags)) croak_fail_nei(ckflags, (xckflags)); \
    } while(0)
	troc_cv = get_cv("XS::APItest::test_rv2cv_op_cv", 0);
	tsh_cv = get_cv("XS::APItest::test_savehints", 0);
	check_cc(troc_cv, Perl_ck_entersub_args_proto_or_list, (SV*)troc_cv, 0);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv, 0);
	cv_set_call_checker(tsh_cv, Perl_ck_entersub_args_proto_or_list,
				    &PL_sv_yes);
	check_cc(troc_cv, Perl_ck_entersub_args_proto_or_list, (SV*)troc_cv, 0);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
	cv_set_call_checker(troc_cv, THX_ck_entersub_args_scalars, &PL_sv_no);
	check_cc(troc_cv, THX_ck_entersub_args_scalars, &PL_sv_no, CALL_CHECKER_REQUIRE_GV);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
	cv_set_call_checker(tsh_cv, Perl_ck_entersub_args_proto_or_list,
				    (SV*)tsh_cv);
	check_cc(troc_cv, THX_ck_entersub_args_scalars, &PL_sv_no, CALL_CHECKER_REQUIRE_GV);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv, 0);
	cv_set_call_checker(troc_cv, Perl_ck_entersub_args_proto_or_list,
				    (SV*)troc_cv);
	check_cc(troc_cv, Perl_ck_entersub_args_proto_or_list, (SV*)troc_cv, 0);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv, 0);
	if (SvMAGICAL((SV*)troc_cv) || SvMAGIC((SV*)troc_cv)) croak_fail();
	if (SvMAGICAL((SV*)tsh_cv) || SvMAGIC((SV*)tsh_cv)) croak_fail();
	cv_set_call_checker_flags(tsh_cv, Perl_ck_entersub_args_proto_or_list,
				    &PL_sv_yes, 0);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes, 0);
	cv_set_call_checker_flags(tsh_cv, Perl_ck_entersub_args_proto_or_list,
				    &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
	cv_set_call_checker_flags(tsh_cv, Perl_ck_entersub_args_proto_or_list,
				    (SV*)tsh_cv, 0);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv, 0);
	if (SvMAGICAL((SV*)tsh_cv) || SvMAGIC((SV*)tsh_cv)) croak_fail();
	cv_set_call_checker_flags(tsh_cv, Perl_ck_entersub_args_proto_or_list,
				    &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes, CALL_CHECKER_REQUIRE_GV);
	cv_set_call_checker_flags(tsh_cv, Perl_ck_entersub_args_proto_or_list,
				    (SV*)tsh_cv, CALL_CHECKER_REQUIRE_GV);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv, 0);
	if (SvMAGICAL((SV*)tsh_cv) || SvMAGIC((SV*)tsh_cv)) croak_fail();
#undef check_cc
#line 5350 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_lists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_lists)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_lists",
				"cv");
		}
	} STMT_END
;
#line 3251 "APItest.xs"
	cv_set_call_checker(cv, THX_ck_entersub_args_lists, &PL_sv_undef);
#line 5380 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_scalars); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_scalars)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_scalars",
				"cv");
		}
	} STMT_END
;
#line 3256 "APItest.xs"
	cv_set_call_checker(cv, THX_ck_entersub_args_scalars, &PL_sv_undef);
#line 5410 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cv, proto");
    {
	CV *	cv;
	SV *	proto = ST(1)
;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_proto",
				"cv");
		}
	} STMT_END
;
#line 3261 "APItest.xs"
	if (SvROK(proto))
	    proto = SvRV(proto);
	cv_set_call_checker(cv, Perl_ck_entersub_args_proto, proto);
#line 5444 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto_or_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto_or_list)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cv, proto");
    {
	CV *	cv;
	SV *	proto = ST(1)
;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_proto_or_list",
				"cv");
		}
	} STMT_END
;
#line 3268 "APItest.xs"
	if (SvROK(proto))
	    proto = SvRV(proto);
	cv_set_call_checker(cv, Perl_ck_entersub_args_proto_or_list, proto);
#line 5478 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_multi_sum); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_multi_sum)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_multi_sum",
				"cv");
		}
	} STMT_END
;
#line 3275 "APItest.xs"
	cv_set_call_checker(cv, THX_ck_entersub_multi_sum, &PL_sv_undef);
#line 5508 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_cophh); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_cophh)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3280 "APItest.xs"
	COPHH *a, *b;
#ifdef EBCDIC
        SV* key_sv;
        char * key_name;
        STRLEN key_len;
#endif
#line 5528 "APItest.c"
#line 3287 "APItest.xs"
#define check_ph(EXPR) \
    	    do { if((EXPR) != &PL_sv_placeholder) croak("fail"); } while(0)
#define check_iv(EXPR, EXPECT) \
    	    do { if(SvIV(EXPR) != (EXPECT)) croak("fail"); } while(0)
#define msvpvs(STR) sv_2mortal(newSVpvs(STR))
#define msviv(VALUE) sv_2mortal(newSViv(VALUE))
	a = cophh_new_empty();
	check_ph(cophh_fetch_pvn(a, "foo_1", 5, 0, 0));
	check_ph(cophh_fetch_pvs(a, "foo_1", 0));
	check_ph(cophh_fetch_pv(a, "foo_1", 0, 0));
	check_ph(cophh_fetch_sv(a, msvpvs("foo_1"), 0, 0));
	a = cophh_store_pvn(a, "foo_1abc", 5, 0, msviv(111), 0);
	a = cophh_store_pvs(a, "foo_2", msviv(222), 0);
	a = cophh_store_pv(a, "foo_3", 0, msviv(333), 0);
	a = cophh_store_sv(a, msvpvs("foo_4"), 0, msviv(444), 0);
	check_iv(cophh_fetch_pvn(a, "foo_1xyz", 5, 0, 0), 111);
	check_iv(cophh_fetch_pvs(a, "foo_1", 0), 111);
	check_iv(cophh_fetch_pv(a, "foo_1", 0, 0), 111);
	check_iv(cophh_fetch_sv(a, msvpvs("foo_1"), 0, 0), 111);
	check_iv(cophh_fetch_pvs(a, "foo_2", 0), 222);
	check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
	check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
	check_ph(cophh_fetch_pvs(a, "foo_5", 0));
	b = cophh_copy(a);
	b = cophh_store_pvs(b, "foo_1", msviv(1111), 0);
	check_iv(cophh_fetch_pvs(a, "foo_1", 0), 111);
	check_iv(cophh_fetch_pvs(a, "foo_2", 0), 222);
	check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
	check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
	check_ph(cophh_fetch_pvs(a, "foo_5", 0));
	check_iv(cophh_fetch_pvs(b, "foo_1", 0), 1111);
	check_iv(cophh_fetch_pvs(b, "foo_2", 0), 222);
	check_iv(cophh_fetch_pvs(b, "foo_3", 0), 333);
	check_iv(cophh_fetch_pvs(b, "foo_4", 0), 444);
	check_ph(cophh_fetch_pvs(b, "foo_5", 0));
	a = cophh_delete_pvn(a, "foo_1abc", 5, 0, 0);
	a = cophh_delete_pvs(a, "foo_2", 0);
	b = cophh_delete_pv(b, "foo_3", 0, 0);
	b = cophh_delete_sv(b, msvpvs("foo_4"), 0, 0);
	check_ph(cophh_fetch_pvs(a, "foo_1", 0));
	check_ph(cophh_fetch_pvs(a, "foo_2", 0));
	check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
	check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
	check_ph(cophh_fetch_pvs(a, "foo_5", 0));
	check_iv(cophh_fetch_pvs(b, "foo_1", 0), 1111);
	check_iv(cophh_fetch_pvs(b, "foo_2", 0), 222);
	check_ph(cophh_fetch_pvs(b, "foo_3", 0));
	check_ph(cophh_fetch_pvs(b, "foo_4", 0));
	check_ph(cophh_fetch_pvs(b, "foo_5", 0));
	b = cophh_delete_pvs(b, "foo_3", 0);
	b = cophh_delete_pvs(b, "foo_5", 0);
	check_iv(cophh_fetch_pvs(b, "foo_1", 0), 1111);
	check_iv(cophh_fetch_pvs(b, "foo_2", 0), 222);
	check_ph(cophh_fetch_pvs(b, "foo_3", 0));
	check_ph(cophh_fetch_pvs(b, "foo_4", 0));
	check_ph(cophh_fetch_pvs(b, "foo_5", 0));
	cophh_free(b);
	check_ph(cophh_fetch_pvs(a, "foo_1", 0));
	check_ph(cophh_fetch_pvs(a, "foo_2", 0));
	check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
	check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
	check_ph(cophh_fetch_pvs(a, "foo_5", 0));
        a = cophh_store_pvs(a, "foo_1", msviv(11111), COPHH_KEY_UTF8);
	a = cophh_store_pvs(a, "foo_\xaa", msviv(123), 0);
#ifndef EBCDIC
	a = cophh_store_pvs(a, "foo_\xc2\xbb", msviv(456), COPHH_KEY_UTF8);
#else
        /* On EBCDIC, we need to translate the UTF-8 in the ASCII test to the
         * equivalent UTF-EBCDIC for the code page.  This is done at runtime
         * (with the helper function in this file).  Therefore we can't use
         * cophhh_store_pvs(), as we don't have literal string */
        key_sv = sv_2mortal(newSVpvs("foo_"));
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc2\xbb"));
	key_name = SvPV(key_sv, key_len);
	a = cophh_store_pvn(a, key_name, key_len, 0, msviv(456), COPHH_KEY_UTF8);
#endif
#ifndef EBCDIC
	a = cophh_store_pvs(a, "foo_\xc3\x8c", msviv(789), COPHH_KEY_UTF8);
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc3\x8c"));
	key_name = SvPV(key_sv, key_len);
	a = cophh_store_pvn(a, key_name, key_len, 0, msviv(789), COPHH_KEY_UTF8);
#endif
#ifndef EBCDIC
	a = cophh_store_pvs(a, "foo_\xd9\xa6", msviv(666), COPHH_KEY_UTF8);
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xd9\xa6"));
	key_name = SvPV(key_sv, key_len);
	a = cophh_store_pvn(a, key_name, key_len, 0, msviv(666), COPHH_KEY_UTF8);
#endif
	check_iv(cophh_fetch_pvs(a, "foo_1", 0), 11111);
	check_iv(cophh_fetch_pvs(a, "foo_1", COPHH_KEY_UTF8), 11111);
	check_iv(cophh_fetch_pvs(a, "foo_\xaa", 0), 123);
#ifndef EBCDIC
	check_iv(cophh_fetch_pvs(a, "foo_\xc2\xaa", COPHH_KEY_UTF8), 123);
	check_ph(cophh_fetch_pvs(a, "foo_\xc2\xaa", 0));
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc2\xaa"));
	key_name = SvPV(key_sv, key_len);
	check_iv(cophh_fetch_pvn(a, key_name, key_len, 0, COPHH_KEY_UTF8), 123);
	check_ph(cophh_fetch_pvn(a, key_name, key_len, 0, 0));
#endif
	check_iv(cophh_fetch_pvs(a, "foo_\xbb", 0), 456);
#ifndef EBCDIC
	check_iv(cophh_fetch_pvs(a, "foo_\xc2\xbb", COPHH_KEY_UTF8), 456);
	check_ph(cophh_fetch_pvs(a, "foo_\xc2\xbb", 0));
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc2\xbb"));
	key_name = SvPV(key_sv, key_len);
	check_iv(cophh_fetch_pvn(a, key_name, key_len, 0, COPHH_KEY_UTF8), 456);
	check_ph(cophh_fetch_pvn(a, key_name, key_len, 0, 0));
#endif
	check_iv(cophh_fetch_pvs(a, "foo_\xcc", 0), 789);
#ifndef EBCDIC
	check_iv(cophh_fetch_pvs(a, "foo_\xc3\x8c", COPHH_KEY_UTF8), 789);
	check_ph(cophh_fetch_pvs(a, "foo_\xc2\x8c", 0));
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc3\x8c"));
	key_name = SvPV(key_sv, key_len);
	check_iv(cophh_fetch_pvn(a, key_name, key_len, 0, COPHH_KEY_UTF8), 789);
	check_ph(cophh_fetch_pvn(a, key_name, key_len, 0, 0));
#endif
#ifndef EBCDIC
	check_iv(cophh_fetch_pvs(a, "foo_\xd9\xa6", COPHH_KEY_UTF8), 666);
	check_ph(cophh_fetch_pvs(a, "foo_\xd9\xa6", 0));
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xd9\xa6"));
	key_name = SvPV(key_sv, key_len);
	check_iv(cophh_fetch_pvn(a, key_name, key_len, 0, COPHH_KEY_UTF8), 666);
	check_ph(cophh_fetch_pvn(a, key_name, key_len, 0, 0));
#endif
	ENTER;
	SAVEFREECOPHH(a);
	LEAVE;
#undef check_ph
#undef check_iv
#undef msvpvs
#undef msviv
#line 5674 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_coplabel); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_coplabel)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3435 "APItest.xs"
        COP *cop;
        const char *label;
        STRLEN len;
        U32 utf8;
#line 5692 "APItest.c"
#line 3440 "APItest.xs"
        cop = &PL_compiling;
        Perl_cop_store_label(aTHX_ cop, "foo", 3, 0);
        label = Perl_cop_fetch_label(aTHX_ cop, &len, &utf8);
        if (strNE(label,"foo")) croak("fail # cop_fetch_label label");
        if (len != 3) croak("fail # cop_fetch_label len");
        if (utf8) croak("fail # cop_fetch_label utf8");
        /* SMALL GERMAN UMLAUT A */
        Perl_cop_store_label(aTHX_ cop, "fo\xc3\xa4", 4, SVf_UTF8);
        label = Perl_cop_fetch_label(aTHX_ cop, &len, &utf8);
        if (strNE(label,"fo\xc3\xa4")) croak("fail # cop_fetch_label label");
        if (len != 4) croak("fail # cop_fetch_label len");
        if (!utf8) croak("fail # cop_fetch_label utf8");
#line 5706 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_example_cophh_2hv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_example_cophh_2hv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3457 "APItest.xs"
	COPHH *a;
#ifdef EBCDIC
        SV* key_sv;
        char * key_name;
        STRLEN key_len;
#endif
#line 5726 "APItest.c"
	HV *	RETVAL;
#line 3464 "APItest.xs"
#define msviv(VALUE) sv_2mortal(newSViv(VALUE))
	a = cophh_new_empty();
	a = cophh_store_pvs(a, "foo_0", msviv(999), 0);
	a = cophh_store_pvs(a, "foo_1", msviv(111), 0);
	a = cophh_store_pvs(a, "foo_\xaa", msviv(123), 0);
#ifndef EBCDIC
	a = cophh_store_pvs(a, "foo_\xc2\xbb", msviv(456), COPHH_KEY_UTF8);
#else
        key_sv = sv_2mortal(newSVpvs("foo_"));
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc2\xbb"));
	key_name = SvPV(key_sv, key_len);
	a = cophh_store_pvn(a, key_name, key_len, 0, msviv(456), COPHH_KEY_UTF8);
#endif
#ifndef EBCDIC
	a = cophh_store_pvs(a, "foo_\xc3\x8c", msviv(789), COPHH_KEY_UTF8);
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xc3\x8c"));
	key_name = SvPV(key_sv, key_len);
	a = cophh_store_pvn(a, key_name, key_len, 0, msviv(789), COPHH_KEY_UTF8);
#endif
#ifndef EBCDIC
	a = cophh_store_pvs(a, "foo_\xd9\xa6", msviv(666), COPHH_KEY_UTF8);
#else
        sv_setpvs(key_sv, "foo_");
        cat_utf8a2n(key_sv, STR_WITH_LEN("\xd9\xa6"));
	key_name = SvPV(key_sv, key_len);
	a = cophh_store_pvn(a, key_name, key_len, 0, msviv(666), COPHH_KEY_UTF8);
#endif
	a = cophh_delete_pvs(a, "foo_0", 0);
	a = cophh_delete_pvs(a, "foo_2", 0);
	RETVAL = cophh_2hv(a, 0);
	cophh_free(a);
#undef msviv
#line 5763 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_savehints); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_savehints)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3504 "APItest.xs"
	SV **svp, *sv;
#line 5784 "APItest.c"
#line 3506 "APItest.xs"
#define store_hint(KEY, VALUE) \
		sv_setiv_mg(*hv_fetchs(GvHV(PL_hintgv), KEY, 1), (VALUE))
#define hint_ok(KEY, EXPECT) \
		((svp = hv_fetchs(GvHV(PL_hintgv), KEY, 0)) && \
		    (sv = *svp) && SvIV(sv) == (EXPECT) && \
		    (sv = cop_hints_fetch_pvs(&PL_compiling, KEY, 0)) && \
		    SvIV(sv) == (EXPECT))
#define check_hint(KEY, EXPECT) \
		do { if (!hint_ok(KEY, EXPECT)) croak_fail(); } while(0)
	PL_hints |= HINT_LOCALIZE_HH;
	ENTER;
	SAVEHINTS();
	PL_hints &= HINT_INTEGER;
	store_hint("t0", 123);
	store_hint("t1", 456);
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 456);
	ENTER;
	SAVEHINTS();
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 456);
	PL_hints |= HINT_INTEGER;
	store_hint("t0", 321);
	if (!(PL_hints & HINT_INTEGER)) croak_fail();
	check_hint("t0", 321); check_hint("t1", 456);
	LEAVE;
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 456);
	ENTER;
	SAVEHINTS();
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 456);
	store_hint("t1", 654);
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 654);
	LEAVE;
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 456);
	LEAVE;
#undef store_hint
#undef hint_ok
#undef check_hint
#line 5828 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_copyhints); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_copyhints)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3552 "APItest.xs"
	HV *a, *b;
#line 5843 "APItest.c"
#line 3554 "APItest.xs"
	PL_hints |= HINT_LOCALIZE_HH;
	ENTER;
	SAVEHINTS();
	sv_setiv_mg(*hv_fetchs(GvHV(PL_hintgv), "t0", 1), 123);
	if (SvIV(cop_hints_fetch_pvs(&PL_compiling, "t0", 0)) != 123)
	    croak_fail();
	a = newHVhv(GvHV(PL_hintgv));
	sv_2mortal((SV*)a);
	sv_setiv_mg(*hv_fetchs(a, "t0", 1), 456);
	if (SvIV(cop_hints_fetch_pvs(&PL_compiling, "t0", 0)) != 123)
	    croak_fail();
	b = hv_copy_hints_hv(a);
	sv_2mortal((SV*)b);
	sv_setiv_mg(*hv_fetchs(b, "t0", 1), 789);
	if (SvIV(cop_hints_fetch_pvs(&PL_compiling, "t0", 0)) != 789)
	    croak_fail();
	LEAVE;
#line 5862 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_op_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_op_list)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3575 "APItest.xs"
	OP *a;
#line 5877 "APItest.c"
#line 3577 "APItest.xs"
#define iv_op(iv) newSVOP(OP_CONST, 0, newSViv(iv))
#define check_op(o, expect) \
    do { \
	if (strNE(test_op_list_describe(o), (expect))) \
	    croak("fail %s %s", test_op_list_describe(o), (expect)); \
    } while(0)
	a = op_append_elem(OP_LIST, NULL, NULL);
	check_op(a, "");
	a = op_append_elem(OP_LIST, iv_op(1), a);
	check_op(a, "const(1).");
	a = op_append_elem(OP_LIST, NULL, a);
	check_op(a, "const(1).");
	a = op_append_elem(OP_LIST, a, iv_op(2));
	check_op(a, "list[pushmark.const(1).const(2).]");
	a = op_append_elem(OP_LIST, a, iv_op(3));
	check_op(a, "list[pushmark.const(1).const(2).const(3).]");
	a = op_append_elem(OP_LIST, a, NULL);
	check_op(a, "list[pushmark.const(1).const(2).const(3).]");
	a = op_append_elem(OP_LIST, NULL, a);
	check_op(a, "list[pushmark.const(1).const(2).const(3).]");
	a = op_append_elem(OP_LIST, iv_op(4), a);
	check_op(a, "list[pushmark.const(4)."
		"list[pushmark.const(1).const(2).const(3).]]");
	a = op_append_elem(OP_LIST, a, iv_op(5));
	check_op(a, "list[pushmark.const(4)."
		"list[pushmark.const(1).const(2).const(3).]const(5).]");
	a = op_append_elem(OP_LIST, a, 
		op_append_elem(OP_LIST, iv_op(7), iv_op(6)));
	check_op(a, "list[pushmark.const(4)."
		"list[pushmark.const(1).const(2).const(3).]const(5)."
		"list[pushmark.const(7).const(6).]]");
	op_free(a);
	a = op_append_elem(OP_LINESEQ, iv_op(1), iv_op(2));
	check_op(a, "lineseq[const(1).const(2).]");
	a = op_append_elem(OP_LINESEQ, a, iv_op(3));
	check_op(a, "lineseq[const(1).const(2).const(3).]");
	op_free(a);
	a = op_append_elem(OP_LINESEQ,
		op_append_elem(OP_LIST, iv_op(1), iv_op(2)),
		iv_op(3));
	check_op(a, "lineseq[list[pushmark.const(1).const(2).]const(3).]");
	op_free(a);
	a = op_prepend_elem(OP_LIST, NULL, NULL);
	check_op(a, "");
	a = op_prepend_elem(OP_LIST, a, iv_op(1));
	check_op(a, "const(1).");
	a = op_prepend_elem(OP_LIST, a, NULL);
	check_op(a, "const(1).");
	a = op_prepend_elem(OP_LIST, iv_op(2), a);
	check_op(a, "list[pushmark.const(2).const(1).]");
	a = op_prepend_elem(OP_LIST, iv_op(3), a);
	check_op(a, "list[pushmark.const(3).const(2).const(1).]");
	a = op_prepend_elem(OP_LIST, NULL, a);
	check_op(a, "list[pushmark.const(3).const(2).const(1).]");
	a = op_prepend_elem(OP_LIST, a, NULL);
	check_op(a, "list[pushmark.const(3).const(2).const(1).]");
	a = op_prepend_elem(OP_LIST, a, iv_op(4));
	check_op(a, "list[pushmark."
		"list[pushmark.const(3).const(2).const(1).]const(4).]");
	a = op_prepend_elem(OP_LIST, iv_op(5), a);
	check_op(a, "list[pushmark.const(5)."
		"list[pushmark.const(3).const(2).const(1).]const(4).]");
	a = op_prepend_elem(OP_LIST,
		op_prepend_elem(OP_LIST, iv_op(6), iv_op(7)), a);
	check_op(a, "list[pushmark.list[pushmark.const(6).const(7).]const(5)."
		"list[pushmark.const(3).const(2).const(1).]const(4).]");
	op_free(a);
	a = op_prepend_elem(OP_LINESEQ, iv_op(2), iv_op(1));
	check_op(a, "lineseq[const(2).const(1).]");
	a = op_prepend_elem(OP_LINESEQ, iv_op(3), a);
	check_op(a, "lineseq[const(3).const(2).const(1).]");
	op_free(a);
	a = op_prepend_elem(OP_LINESEQ, iv_op(3),
		op_prepend_elem(OP_LIST, iv_op(2), iv_op(1)));
	check_op(a, "lineseq[const(3).list[pushmark.const(2).const(1).]]");
	op_free(a);
	a = op_append_list(OP_LINESEQ, NULL, NULL);
	check_op(a, "");
	a = op_append_list(OP_LINESEQ, iv_op(1), a);
	check_op(a, "const(1).");
	a = op_append_list(OP_LINESEQ, NULL, a);
	check_op(a, "const(1).");
	a = op_append_list(OP_LINESEQ, a, iv_op(2));
	check_op(a, "lineseq[const(1).const(2).]");
	a = op_append_list(OP_LINESEQ, a, iv_op(3));
	check_op(a, "lineseq[const(1).const(2).const(3).]");
	a = op_append_list(OP_LINESEQ, iv_op(4), a);
	check_op(a, "lineseq[const(4).const(1).const(2).const(3).]");
	a = op_append_list(OP_LINESEQ, a, NULL);
	check_op(a, "lineseq[const(4).const(1).const(2).const(3).]");
	a = op_append_list(OP_LINESEQ, NULL, a);
	check_op(a, "lineseq[const(4).const(1).const(2).const(3).]");
	a = op_append_list(OP_LINESEQ, a,
		op_append_list(OP_LINESEQ, iv_op(5), iv_op(6)));
	check_op(a, "lineseq[const(4).const(1).const(2).const(3)."
		"const(5).const(6).]");
	op_free(a);
	a = op_append_list(OP_LINESEQ,
		op_append_list(OP_LINESEQ, iv_op(1), iv_op(2)),
		op_append_list(OP_LIST, iv_op(3), iv_op(4)));
	check_op(a, "lineseq[const(1).const(2)."
		"list[pushmark.const(3).const(4).]]");
	op_free(a);
	a = op_append_list(OP_LINESEQ,
		op_append_list(OP_LIST, iv_op(1), iv_op(2)),
		op_append_list(OP_LINESEQ, iv_op(3), iv_op(4)));
	check_op(a, "lineseq[list[pushmark.const(1).const(2).]"
		"const(3).const(4).]");
	op_free(a);
#undef check_op
#line 5989 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_op_linklist); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_op_linklist)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3691 "APItest.xs"
        OP *o;
#line 6004 "APItest.c"
#line 3693 "APItest.xs"
#define check_ll(o, expect) \
    STMT_START { \
	if (strNE(test_op_linklist_describe(o), (expect))) \
	    croak("fail %s %s", test_op_linklist_describe(o), (expect)); \
    } STMT_END
        o = iv_op(1);
        check_ll(o, ".const1");
        op_free(o);

        o = mkUNOP(OP_NOT, iv_op(1));
        check_ll(o, ".const1.not");
        op_free(o);

        o = mkUNOP(OP_NOT, mkUNOP(OP_NEGATE, iv_op(1)));
        check_ll(o, ".const1.negate.not");
        op_free(o);

        o = mkBINOP(OP_ADD, iv_op(1), iv_op(2));
        check_ll(o, ".const1.const2.add");
        op_free(o);

        o = mkBINOP(OP_ADD, mkUNOP(OP_NOT, iv_op(1)), iv_op(2));
        check_ll(o, ".const1.not.const2.add");
        op_free(o);

        o = mkUNOP(OP_NOT, mkBINOP(OP_ADD, iv_op(1), iv_op(2)));
        check_ll(o, ".const1.const2.add.not");
        op_free(o);

        o = mkLISTOP(OP_LINESEQ, iv_op(1), iv_op(2), iv_op(3));
        check_ll(o, ".const1.const2.const3.lineseq");
        op_free(o);

        o = mkLISTOP(OP_LINESEQ,
                mkBINOP(OP_ADD, iv_op(1), iv_op(2)),
                mkUNOP(OP_NOT, iv_op(3)),
                mkLISTOP(OP_SUBSTR, iv_op(4), iv_op(5), iv_op(6)));
        check_ll(o, ".const1.const2.add.const3.not"
                    ".const4.const5.const6.substr.lineseq");
        op_free(o);

        o = mkBINOP(OP_ADD, iv_op(1), iv_op(2));
        LINKLIST(o);
        o = mkBINOP(OP_SUBTRACT, o, iv_op(3));
        check_ll(o, ".const1.const2.add.const3.subtract");
        op_free(o);
#undef check_ll
#undef iv_op
#line 6054 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_peep_enable); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_peep_enable)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3745 "APItest.xs"
	dMY_CXT;
#line 6069 "APItest.c"
#line 3747 "APItest.xs"
	av_clear(MY_CXT.peep_recorder);
	av_clear(MY_CXT.rpeep_recorder);
	MY_CXT.peep_recording = 1;
#line 6074 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_peep_disable); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_peep_disable)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3754 "APItest.xs"
	dMY_CXT;
#line 6089 "APItest.c"
#line 3756 "APItest.xs"
	MY_CXT.peep_recording = 0;
#line 6092 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_peep_record); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_peep_record)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3761 "APItest.xs"
	dMY_CXT;
#line 6107 "APItest.c"
	SV *	RETVAL;
#line 3763 "APItest.xs"
	RETVAL = newRV_inc((SV *)MY_CXT.peep_recorder);
#line 6111 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_rpeep_record); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_rpeep_record)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3770 "APItest.xs"
	dMY_CXT;
#line 6128 "APItest.c"
	SV *	RETVAL;
#line 3772 "APItest.xs"
	RETVAL = newRV_inc((SV *)MY_CXT.rpeep_recorder);
#line 6132 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_multicall_each); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_multicall_each)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "block, ...");
    {
	SV *	block = ST(0)
;
#line 3787 "APItest.xs"
{
    dMULTICALL;
    int index;
    GV *gv;
    HV *stash;
    I32 gimme = G_SCALAR;
    SV **args = &PL_stack_base[ax];
    CV *cv;

    if(items <= 1) {
	XSRETURN_UNDEF;
    }
    cv = sv_2cv(block, &stash, &gv, 0);
    if (cv == Nullcv) {
       croak("multicall_each: not a subroutine reference");
    }
    PUSH_MULTICALL(cv);
    SAVESPTR(GvSV(PL_defgv));

    for(index = 1 ; index < items ; index++) {
	GvSV(PL_defgv) = args[index];
	MULTICALL;
    }
    POP_MULTICALL;
    XSRETURN_UNDEF;
}
#line 6176 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_multicall_return); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_multicall_return)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "block, context");
    {
	SV *	block = ST(0)
;
	I32	context = (I32)SvIV(ST(1))
;
#line 3827 "APItest.xs"
{
    dSP;
    dMULTICALL;
    GV *gv;
    HV *stash;
    I32 gimme = context;
    CV *cv;
    AV *av;
    SV **p;
    SSize_t i, size;

    cv = sv_2cv(block, &stash, &gv, 0);
    if (cv == Nullcv) {
       croak("multicall_return not a subroutine reference");
    }
    PUSH_MULTICALL(cv);

    MULTICALL;

    /* copy returned values into an array so they're not freed during
     * POP_MULTICALL */

    av = newAV();
    SPAGAIN;

    switch (context) {
    case G_VOID:
        break;

    case G_SCALAR:
        av_push(av, SvREFCNT_inc(TOPs));
        break;

    case G_ARRAY:
        for (p = PL_stack_base + 1; p <= SP; p++)
            av_push(av, SvREFCNT_inc(*p));
        break;
    }

    POP_MULTICALL;

    size = AvFILLp(av) + 1;
    EXTEND(SP, size);
    for (i = 0; i < size; i++)
        ST(i) = *av_fetch(av, i, FALSE);
    sv_2mortal((SV*)av);
    XSRETURN(size);
}
#line 6242 "APItest.c"
    }
    XSRETURN(1);
}

#ifdef USE_ITHREADS
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_XS__APItest_clone_with_stack); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_clone_with_stack)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3882 "APItest.xs"
{
    PerlInterpreter *interp = aTHX; /* The original interpreter */
    PerlInterpreter *interp_dup;    /* The duplicate interpreter */
    int oldscope = 1; /* We are responsible for all scopes */

    interp_dup = perl_clone(interp, CLONEf_COPY_STACKS | CLONEf_CLONE_HOST );

    /* destroy old perl */
    PERL_SET_CONTEXT(interp);

    POPSTACK_TO(PL_mainstack);
    if (cxstack_ix >= 0) {
        dounwind(-1);
        cx_popblock(cxstack);
    }
    LEAVE_SCOPE(0);
    PL_scopestack_ix = oldscope;
    FREETMPS;

    perl_destruct(interp);
    perl_free(interp);

    /* switch to new perl */
    PERL_SET_CONTEXT(interp_dup);

    /* continue after 'clone_with_stack' */
    if (interp_dup->Iop)
	interp_dup->Iop = interp_dup->Iop->op_next;

    /* run with new perl */
    Perl_runops_standard(interp_dup);

    /* We may have additional unclosed scopes if fork() was called
     * from within a BEGIN block.  See perlfork.pod for more details.
     * We cannot clean up these other scopes because they belong to a
     * different interpreter, but we also cannot leave PL_scopestack_ix
     * dangling because that can trigger an assertion in perl_destruct().
     */
    if (PL_scopestack_ix > oldscope) {
        PL_scopestack[oldscope-1] = PL_scopestack[PL_scopestack_ix-1];
        PL_scopestack_ix = oldscope;
    }

    perl_destruct(interp_dup);
    perl_free(interp_dup);

    /* call the real 'exit' not PerlProc_exit */
#undef exit
    exit(0);
}
#line 6309 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#endif /* USE_ITHREDS */

XS_EUPXS(XS_XS__APItest_take_svref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_svref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SVREF	sv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    sv = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::take_svref",
				"sv");
		}
	} STMT_END
;
#line 3938 "APItest.xs"
    RETVAL = newRV_inc(sv);
#line 6341 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_take_avref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_avref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "av");
    {
	SV *	RETVAL;
	AV*	av;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    av = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				"XS::APItest::take_avref",
				"av");
		}
	} STMT_END
;
#line 3945 "APItest.xs"
    RETVAL = newRV_inc((SV*)av);
#line 6374 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_take_hvref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_hvref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	SV *	RETVAL;
	HV*	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::take_hvref",
				"hv");
		}
	} STMT_END
;
#line 3952 "APItest.xs"
    RETVAL = newRV_inc((SV*)hv);
#line 6407 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_take_cvref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_cvref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	SV *	RETVAL;
	CV*	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::take_cvref",
				"cv");
		}
	} STMT_END
;
#line 3960 "APItest.xs"
    RETVAL = newRV_inc((SV*)cv);
#line 6440 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_establish_cleanup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_establish_cleanup)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 4008 "APItest.xs"
    PERL_UNUSED_VAR(items);
    croak("establish_cleanup called as a function");
#line 6458 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_postinc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_postinc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 4021 "APItest.xs"
    PERL_UNUSED_VAR(items);
    croak("postinc called as a function");
#line 6474 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_filter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_filter)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4027 "APItest.xs"
    filter_add(filter_call, NULL);
#line 6489 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_lv_temp_object); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_lv_temp_object)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 4038 "APItest.xs"
    RETVAL =
	  sv_bless(
	    newRV_noinc(newSV(0)),
	    gv_stashpvs("XS::APItest::TempObj",GV_ADD)
	  );             /* Package defined in test script */
#line 6509 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_fill_hash_with_nulls); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_fill_hash_with_nulls)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
#line 4049 "APItest.xs"
    UV i = 0;
#line 6526 "APItest.c"
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::fill_hash_with_nulls",
				"hv");
		}
	} STMT_END
;
#line 4051 "APItest.xs"
    for(; i < 1000; ++i) {
	HE *entry = hv_fetch_ent(hv, sv_2mortal(newSVuv(i)), 1, 0);
	SvREFCNT_dec(HeVAL(entry));
	HeVAL(entry) = NULL;
    }
#line 6548 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_newHVhv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_newHVhv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	HV *	RETVAL;
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::newHVhv",
				"hv");
		}
	} STMT_END
;
#line 4060 "APItest.xs"
    RETVAL = newHVhv(hv);
#line 6579 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvIsCOW); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvIsCOW)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	U32	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 4067 "APItest.xs"
    RETVAL = SvIsCOW(sv);
#line 6604 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_pad_scalar); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_pad_scalar)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 4075 "APItest.xs"
    PERL_UNUSED_VAR(items);
    croak("pad_scalar called as a function");
#line 6621 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_fetch_pad_names); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_fetch_pad_names)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV*	cv;
#line 4088 "APItest.xs"
  I32 i;
  PADNAMELIST *pad_namelist;
  AV *retav = newAV();
#line 6639 "APItest.c"
	SV *	RETVAL;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::fetch_pad_names",
				"cv");
		}
	} STMT_END
;
#line 4092 "APItest.xs"
  pad_namelist = PadlistNAMES(CvPADLIST(cv));

  for ( i = PadnamelistMAX(pad_namelist); i >= 0; i-- ) {
    PADNAME* name = PadnamelistARRAY(pad_namelist)[i];

    if (PadnameLEN(name)) {
        av_push(retav, newSVpadname(name));
    }
  }
  RETVAL = newRV_noinc((SV*)retav);
#line 6666 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_underscore_length); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_underscore_length)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4109 "APItest.xs"
    SV *u;
    U8 *pv;
    STRLEN bytelen;
#line 6685 "APItest.c"
	STRLEN	RETVAL;
	dXSTARG;
#line 4113 "APItest.xs"
    u = find_rundefsv();
    pv = (U8*)SvPV(u, bytelen);
    RETVAL = SvUTF8(u) ? utf8_length(pv, pv+bytelen) : bytelen;
#line 6692 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_stringify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_stringify)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 4122 "APItest.xs"
    (void)SvPV_nolen(sv);
#line 6710 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_HvENAME); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_HvENAME)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	SV *	RETVAL;
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::HvENAME",
				"hv");
		}
	} STMT_END
;
#line 4127 "APItest.xs"
    RETVAL = hv && HvENAME(hv)
	      ? newSVpvn_flags(
		  HvENAME(hv),HvENAMELEN(hv),
		  (HvENAMEUTF8(hv) ? SVf_UTF8 : 0)
		)
	      : NULL;
#line 6746 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xs_cmp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xs_cmp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "a, b");
    {
	int	RETVAL;
	dXSTARG;
	int	a = (int)SvIV(ST(0))
;
	int	b = (int)SvIV(ST(1))
;
#line 4139 "APItest.xs"
    /* Odd sorting (odd numbers first), to make sure we are actually
       being called */
    RETVAL = a % 2 != b % 2
	       ? a % 2 ? -1 : 1
	       : a < b ? -1 : a == b ? 0 : 1;
#line 6773 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xs_cmp_undef); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xs_cmp_undef)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "a, b");
    {
	SV *	RETVAL;
	SV *	a = ST(0)
;
	SV *	b = ST(1)
;
#line 4150 "APItest.xs"
    PERL_UNUSED_ARG(a);
    PERL_UNUSED_ARG(b);
    RETVAL = &PL_sv_undef;
#line 6796 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvPVbyte); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvPVbyte)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	char *	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 4159 "APItest.xs"
    RETVAL = SvPVbyte_nolen(sv);
#line 6817 "APItest.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvPVutf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvPVutf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	char *	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 4166 "APItest.xs"
    RETVAL = SvPVutf8_nolen(sv);
#line 6837 "APItest.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_setup_addissub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_setup_addissub)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4173 "APItest.xs"
    wrap_op_checker(OP_ADD, addissub_myck_add, &addissub_nxck_add);
#line 6853 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_setup_rv2cv_addunderbar); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_setup_rv2cv_addunderbar)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4178 "APItest.xs"
    wrap_op_checker(OP_RV2CV, my_ck_rv2cv, &old_ck_rv2cv);
#line 6868 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#ifdef USE_ITHREADS
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_XS__APItest_test_alloccopstash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_alloccopstash)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 4185 "APItest.xs"
    RETVAL = PL_stashpad[alloccopstash(PL_defstash)] == PL_defstash;
#line 6887 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_XS__APItest_test_newFOROP_without_slab); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_newFOROP_without_slab)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 4194 "APItest.xs"
    {
	const I32 floor = start_subparse(0,0);
	OP *o;
	/* The slab allocator does not like CvROOT being set. */
	CvROOT(PL_compcv) = (OP *)1;
	o = newFOROP(0, 0, newOP(OP_PUSHMARK, 0), 0, 0);
	if (cLOOPx(cUNOPo->op_first)->op_last->op_sibparent
		!= cUNOPo->op_first)
	{
	    Perl_warn(aTHX_ "Op parent pointer is stale");
	    RETVAL = FALSE;
	}
	else
	    /* If we do not crash before returning, the test passes. */
	    RETVAL = TRUE;
	op_free(o);
	CvROOT(PL_compcv) = NULL;
	SvREFCNT_dec(PL_compcv);
	LEAVE_SCOPE(floor);
    }
#line 6924 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_callregexec); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_callregexec)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "prog, stringarg, strend, minend, sv, nosave");
    {
	I32	RETVAL;
	dXSTARG;
	SV *	prog = ST(0)
;
	STRLEN	stringarg = (STRLEN)SvUV(ST(1))
;
	STRLEN	strend = (STRLEN)SvUV(ST(2))
;
	I32	minend = (I32)SvIV(ST(3))
;
	SV *	sv = ST(4)
;
	U32	nosave = (unsigned long)SvUV(ST(5))
;
#line 4223 "APItest.xs"
    {
	STRLEN len;
	char *strbeg;
	if (SvROK(prog))
	    prog = SvRV(prog);
	strbeg = SvPV_force(sv, len);
	RETVAL = CALLREGEXEC((REGEXP *)prog,
			    strbeg + stringarg,
			    strbeg + strend,
			    strbeg,
			    minend,
			    sv,
			    NULL, /* data */
			    nosave);
    }
#line 6968 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_lexical_import); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_lexical_import)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "name, cv");
    {
	SV *	name = ST(0)
;
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(1);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::lexical_import",
				"cv");
		}
	} STMT_END
;
#line 4244 "APItest.xs"
    {
	PADLIST *pl;
	PADOFFSET off;
	if (!PL_compcv)
	    Perl_croak(aTHX_
		      "lexical_import can only be called at compile time");
	pl = CvPADLIST(PL_compcv);
	ENTER;
	SAVESPTR(PL_comppad_name); PL_comppad_name = PadlistNAMES(pl);
	SAVESPTR(PL_comppad);	   PL_comppad	   = PadlistARRAY(pl)[1];
	SAVESPTR(PL_curpad);	   PL_curpad	   = PadARRAY(PL_comppad);
	off = pad_add_name_sv(sv_2mortal(newSVpvf("&%" SVf,name)),
			      padadd_STATE, 0, 0);
	SvREFCNT_dec(PL_curpad[off]);
	PL_curpad[off] = SvREFCNT_inc(cv);
	intro_my();
	LEAVE;
    }
#line 7018 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_sv_mortalcopy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_mortalcopy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 4266 "APItest.xs"
	RETVAL = SvREFCNT_inc(sv_mortalcopy(sv));
#line 7036 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_newRV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_newRV)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;

	RETVAL = newRV(sv);
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_alias_av); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_alias_av)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "av, ix, sv");
    {
	AV *	av;
	IV	ix = (IV)SvIV(ST(1))
;
	SV *	sv = ST(2)
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    av = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				"XS::APItest::alias_av",
				"av");
		}
	} STMT_END
;
#line 4276 "APItest.xs"
	av_store(av, ix, SvREFCNT_inc(sv));
#line 7091 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_name)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "ref, ...");
    {
	SV *	RETVAL;
	SVREF	ref;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    ref = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::cv_name",
				"ref");
		}
	} STMT_END
;
#line 4281 "APItest.xs"
	RETVAL = SvREFCNT_inc(cv_name((CV *)ref,
				      items>1 && ST(1) != &PL_sv_undef
					? ST(1)
					: NULL,
				      items>2 ? SvUV(ST(2)) : 0));
#line 7126 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_catpvn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_catpvn)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, sv2");
    {
	SV *	sv = ST(0)
;
	SV *	sv2 = ST(1)
;
#line 4292 "APItest.xs"
    {
	STRLEN len;
	const char *s = SvPV(sv2,len);
	sv_catpvn_flags(sv,s,len, SvUTF8(sv2) ? SV_CATUTF8 : SV_CATBYTES);
    }
#line 7151 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_newOP_CUSTOM); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_newOP_CUSTOM)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 4301 "APItest.xs"
    {
	OP *o = newLISTOP(OP_CUSTOM, 0, NULL, NULL);
	op_free(o);
	o = newOP(OP_CUSTOM, 0);
	op_free(o);
	o = newUNOP(OP_CUSTOM, 0, NULL);
	op_free(o);
	o = newUNOP_AUX(OP_CUSTOM, 0, NULL, NULL);
	op_free(o);
	o = newMETHOP(OP_CUSTOM, 0, newOP(OP_NULL,0));
	op_free(o);
	o = newMETHOP_named(OP_CUSTOM, 0, newSV(0));
	op_free(o);
	o = newBINOP(OP_CUSTOM, 0, NULL, NULL);
	op_free(o);
	o = newPMOP(OP_CUSTOM, 0);
	op_free(o);
	o = newSVOP(OP_CUSTOM, 0, newSV(0));
	op_free(o);
#ifdef USE_ITHREADS
	ENTER;
	lex_start(NULL, NULL, 0);
	{
	    I32 ix = start_subparse(FALSE,0);
	    o = newPADOP(OP_CUSTOM, 0, newSV(0));
	    op_free(o);
	    LEAVE_SCOPE(ix);
	}
	LEAVE;
#endif
	o = newPVOP(OP_CUSTOM, 0, NULL);
	op_free(o);
	o = newLOGOP(OP_CUSTOM, 0, newOP(OP_NULL,0), newOP(OP_NULL,0));
	op_free(o);
	o = newLOOPEX(OP_CUSTOM, newOP(OP_NULL,0));
	op_free(o);
	RETVAL = TRUE;
    }
#line 7204 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_sv_catpvf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_sv_catpvf)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "fmtsv");
    {
#line 4345 "APItest.xs"
        SV *sv;
        char *fmt;
#line 7221 "APItest.c"
	SV *	fmtsv = ST(0)
;
#line 4348 "APItest.xs"
        fmt = SvPV_nolen(fmtsv);
        sv = sv_2mortal(newSVpvn("", 0));
        sv_catpvf(sv, fmt, 5, 6, 7, 8);
#line 7228 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_load_module); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_load_module)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "flags, name, ...");
    {
	U32	flags = (unsigned long)SvUV(ST(0))
;
	SV *	name = ST(1)
;
#line 4357 "APItest.xs"
    if (items == 2) {
	Perl_load_module(aTHX_ flags, SvREFCNT_inc(name), NULL);
    } else if (items == 3) {
	Perl_load_module(aTHX_ flags, SvREFCNT_inc(name), SvREFCNT_inc(ST(2)));
    } else
        Perl_croak(aTHX_ "load_module can't yet support %" IVdf " items",
                          (IV)items);
#line 7253 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_string_without_null); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_string_without_null)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 4368 "APItest.xs"
    {
        STRLEN len;
        const char *s = SvPV(sv, len);
        RETVAL = newSVpvn_flags(s, len, SvUTF8(sv));
        *SvEND(RETVAL) = 0xff;
    }
#line 7276 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_get_cv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_get_cv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	CV *	RETVAL;
	SV *	sv = ST(0)
;
#line 4380 "APItest.xs"
    {
        STRLEN len;
        const char *s = SvPV(sv, len);
        RETVAL = get_cvn_flags(s, len, 0);
    }
#line 7300 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_get_cv_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_get_cv_flags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, flags");
    {
	CV *	RETVAL;
	SV *	sv = ST(0)
;
	UV	flags = (UV)SvUV(ST(1))
;
#line 4391 "APItest.xs"
    {
        STRLEN len;
        const char *s = SvPV(sv, len);
        RETVAL = get_cvn_flags(s, len, flags);
    }
#line 7330 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_unshift_and_set_defav); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_unshift_and_set_defav)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "sv, ...");
    {
	SV *	sv = ST(0)
;
#line 4402 "APItest.xs"
	av_unshift(GvAVn(PL_defgv), 1);
	av_store(GvAV(PL_defgv), 0, newSVuv(42));
	sv_setuv(sv, 43);
#line 7355 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_PerlIO_stderr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_PerlIO_stderr)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	PerlIO *	RETVAL;

	RETVAL = PerlIO_stderr();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		gv_init_pvn(gv, gv_stashpvs("XS::APItest",1),"__ANONIO__",10,0);
		if ( do_open(gv, "+<&", 3, FALSE, 0, 0, RETVAL) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_PerlIO_stdout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_PerlIO_stdout)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	OutputStream	RETVAL;

	RETVAL = PerlIO_stdout();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		gv_init_pvn(gv, gv_stashpvs("XS::APItest",1),"__ANONIO__",10,0);
		if ( do_open(gv, "+>&", 3, FALSE, 0, 0, RETVAL) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_PerlIO_stdin); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_PerlIO_stdin)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	InputStream	RETVAL;

	RETVAL = PerlIO_stdin();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		gv_init_pvn(gv, gv_stashpvs("XS::APItest",1),"__ANONIO__",10,0);
		if ( do_open(gv, "<&", 2, FALSE, 0, 0, RETVAL) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#undef FILE
#define FILE NativeFile

XS_EUPXS(XS_XS__APItest_PerlIO_exportFILE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_PerlIO_exportFILE)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "f, mode");
    {
	FILE *	RETVAL;
	PerlIO *	f = IoIFP(sv_2io(ST(0)))
;
	const char *	mode = (const char *)SvPV_nolen(ST(1))
;

	RETVAL = PerlIO_exportFILE(f, mode);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		PerlIO *fp = PerlIO_importFILE(RETVAL,0);
		gv_init_pvn(gv, gv_stashpvs("XS::APItest",1),"__ANONIO__",10,0);
		if ( fp && do_open(gv, "+<&", 3, FALSE, 0, 0, fp) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__AUTOLOADtest_AUTOLOAD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__AUTOLOADtest_AUTOLOAD)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	int	RETVAL;
	dXSTARG;
#line 4426 "APItest.xs"
    SV* comms;
    SV* class_and_method;
#line 7496 "APItest.c"
#line 4429 "APItest.xs"
    PERL_UNUSED_ARG(items);
    class_and_method = GvSV(CvGV(cv));
    comms = get_sv("main::the_method", 1);
    if (class_and_method == NULL) {
      RETVAL = 1;
    } else if (!SvOK(class_and_method)) {
      RETVAL = 2;
    } else if (!SvPOK(class_and_method)) {
      RETVAL = 3;
    } else {
      sv_setsv(comms, class_and_method);
      RETVAL = 0;
    }
#line 7511 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_sv_magic_foo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_magic_foo)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "sv, thingy");
    {
	SV *	sv = ST(0)
;
	SV *	thingy = ST(1)
;
#line 4454 "APItest.xs"
    sv_magicext(SvRV(sv), NULL, PERL_MAGIC_ext, ix ? &vtbl_bar : &vtbl_foo, (const char *)thingy, 0);
#line 7532 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_mg_find_foo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_mg_find_foo)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 4461 "APItest.xs"
    MAGIC *mg = mg_findext(SvRV(sv), PERL_MAGIC_ext, ix ? &vtbl_bar : &vtbl_foo);
    RETVAL = mg ? SvREFCNT_inc((SV *)mg->mg_ptr) : &PL_sv_undef;
#line 7552 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_sv_unmagic_foo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_unmagic_foo)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 4471 "APItest.xs"
    sv_unmagicext(SvRV(sv), PERL_MAGIC_ext, ix ? &vtbl_bar : &vtbl_foo);
#line 7572 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_sv_magic); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_magic)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, thingy");
    {
	SV *	sv = ST(0)
;
	SV *	thingy = ST(1)
;
#line 4476 "APItest.xs"
    sv_magic(SvRV(sv), NULL, PERL_MAGIC_ext, (const char *)thingy, 0);
#line 7591 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_test_get_vtbl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_get_vtbl)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 4481 "APItest.xs"
	MGVTBL *have;
	MGVTBL *want;
#line 7607 "APItest.c"
	UV	RETVAL;
	dXSTARG;
#line 4484 "APItest.xs"
#define test_get_this_vtable(name) \
	want = (MGVTBL*)CAT2(&PL_vtbl_, name); \
	have = get_vtbl(CAT2(want_vtbl_, name)); \
	if (have != want) \
	    croak("fail %p!=%p for get_vtbl(want_vtbl_" STRINGIFY(name) ") at " __FILE__ " line %d", have, want, __LINE__)

	test_get_this_vtable(sv);
	test_get_this_vtable(env);
	test_get_this_vtable(envelem);
	test_get_this_vtable(sigelem);
	test_get_this_vtable(pack);
	test_get_this_vtable(packelem);
	test_get_this_vtable(dbline);
	test_get_this_vtable(isa);
	test_get_this_vtable(isaelem);
	test_get_this_vtable(arylen);
	test_get_this_vtable(mglob);
	test_get_this_vtable(nkeys);
	test_get_this_vtable(taint);
	test_get_this_vtable(substr);
	test_get_this_vtable(vec);
	test_get_this_vtable(pos);
	test_get_this_vtable(bm);
	test_get_this_vtable(fm);
	test_get_this_vtable(uvar);
	test_get_this_vtable(defelem);
	test_get_this_vtable(regexp);
	test_get_this_vtable(regdata);
	test_get_this_vtable(regdatum);
#ifdef USE_LOCALE_COLLATE
	test_get_this_vtable(collxfrm);
#endif
	test_get_this_vtable(backref);
	test_get_this_vtable(utf8);

	RETVAL = PTR2UV(get_vtbl(-1));
#line 7647 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_sv_magic_myset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_magic_myset)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "rsv, thingy");
    {
	SV *	rsv = ST(0)
;
	SV *	thingy = ST(1)
;
#line 4530 "APItest.xs"
    sv_magicext(SvRV(rsv), NULL, PERL_MAGIC_ext, &vtbl_myset,
        (const char *)thingy, 0);
#line 7668 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4538 "APItest.xs"
        RETVAL = isBLANK_uni(ord);
#line 7686 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4545 "APItest.xs"
        RETVAL = isBLANK_uvchr(ord);
#line 7705 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4552 "APItest.xs"
        RETVAL = isBLANK_LC_uvchr(ord);
#line 7724 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4559 "APItest.xs"
        RETVAL = isBLANK(ord);
#line 7743 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4566 "APItest.xs"
        RETVAL = isBLANK_A(ord);
#line 7762 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4573 "APItest.xs"
        RETVAL = isBLANK_L1(ord);
#line 7781 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4580 "APItest.xs"
        RETVAL = isBLANK_LC(ord);
#line 7800 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4587 "APItest.xs"
	const U8 * e;
#line 7816 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4590 "APItest.xs"
        /* In this function and those that follow, the boolean 'type'
         * indicates if to pass a malformed UTF-8 string to the tested macro
         * (malformed by making it too short) */
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isBLANK_utf8_safe(p, e);
        }
        else {
            RETVAL = isBLANK_utf8(p);
        }
#line 7833 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4606 "APItest.xs"
	const U8 * e;
#line 7849 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4608 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isBLANK_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isBLANK_LC_utf8(p);
        }
#line 7863 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isVERTWS_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isVERTWS_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4621 "APItest.xs"
        RETVAL = isVERTWS_uni(ord);
#line 7882 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isVERTWS_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isVERTWS_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4628 "APItest.xs"
        RETVAL = isVERTWS_uvchr(ord);
#line 7901 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isVERTWS_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isVERTWS_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4635 "APItest.xs"
	const U8 * e;
#line 7917 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4637 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isVERTWS_utf8_safe(p, e);
        }
        else {
            RETVAL = isVERTWS_utf8(p);
        }
#line 7931 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4650 "APItest.xs"
        RETVAL = isUPPER_uni(ord);
#line 7950 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4657 "APItest.xs"
        RETVAL = isUPPER_uvchr(ord);
#line 7969 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4664 "APItest.xs"
        RETVAL = isUPPER_LC_uvchr(ord);
#line 7988 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4671 "APItest.xs"
        RETVAL = isUPPER(ord);
#line 8007 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4678 "APItest.xs"
        RETVAL = isUPPER_A(ord);
#line 8026 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4685 "APItest.xs"
        RETVAL = isUPPER_L1(ord);
#line 8045 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4692 "APItest.xs"
        RETVAL = isUPPER_LC(ord);
#line 8064 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4699 "APItest.xs"
	const U8 * e;
#line 8080 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4701 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isUPPER_utf8_safe(p, e);
        }
        else {
            RETVAL = isUPPER_utf8(p);
        }
#line 8094 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4714 "APItest.xs"
	const U8 * e;
#line 8110 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4716 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isUPPER_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isUPPER_LC_utf8(p);
        }
#line 8124 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4729 "APItest.xs"
        RETVAL = isLOWER_uni(ord);
#line 8143 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4736 "APItest.xs"
        RETVAL = isLOWER_uvchr(ord);
#line 8162 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4743 "APItest.xs"
        RETVAL = isLOWER_LC_uvchr(ord);
#line 8181 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4750 "APItest.xs"
        RETVAL = isLOWER(ord);
#line 8200 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4757 "APItest.xs"
        RETVAL = isLOWER_A(ord);
#line 8219 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4764 "APItest.xs"
        RETVAL = isLOWER_L1(ord);
#line 8238 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4771 "APItest.xs"
        RETVAL = isLOWER_LC(ord);
#line 8257 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4778 "APItest.xs"
	const U8 * e;
#line 8273 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4780 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isLOWER_utf8_safe(p, e);
        }
        else {
            RETVAL = isLOWER_utf8(p);
        }
#line 8287 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4793 "APItest.xs"
	const U8 * e;
#line 8303 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4795 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isLOWER_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isLOWER_LC_utf8(p);
        }
#line 8317 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4808 "APItest.xs"
        RETVAL = isALPHA_uni(ord);
#line 8336 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4815 "APItest.xs"
        RETVAL = isALPHA_uvchr(ord);
#line 8355 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4822 "APItest.xs"
        RETVAL = isALPHA_LC_uvchr(ord);
#line 8374 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4829 "APItest.xs"
        RETVAL = isALPHA(ord);
#line 8393 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4836 "APItest.xs"
        RETVAL = isALPHA_A(ord);
#line 8412 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4843 "APItest.xs"
        RETVAL = isALPHA_L1(ord);
#line 8431 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4850 "APItest.xs"
        RETVAL = isALPHA_LC(ord);
#line 8450 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4857 "APItest.xs"
	const U8 * e;
#line 8466 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4859 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isALPHA_utf8_safe(p, e);
        }
        else {
            RETVAL = isALPHA_utf8(p);
        }
#line 8480 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4872 "APItest.xs"
	const U8 * e;
#line 8496 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4874 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isALPHA_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isALPHA_LC_utf8(p);
        }
#line 8510 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4887 "APItest.xs"
        RETVAL = isWORDCHAR_uni(ord);
#line 8529 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4894 "APItest.xs"
        RETVAL = isWORDCHAR_uvchr(ord);
#line 8548 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4901 "APItest.xs"
        RETVAL = isWORDCHAR_LC_uvchr(ord);
#line 8567 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4908 "APItest.xs"
        RETVAL = isWORDCHAR(ord);
#line 8586 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4915 "APItest.xs"
        RETVAL = isWORDCHAR_A(ord);
#line 8605 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4922 "APItest.xs"
        RETVAL = isWORDCHAR_L1(ord);
#line 8624 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4929 "APItest.xs"
        RETVAL = isWORDCHAR_LC(ord);
#line 8643 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4936 "APItest.xs"
	const U8 * e;
#line 8659 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4938 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isWORDCHAR_utf8_safe(p, e);
        }
        else {
            RETVAL = isWORDCHAR_utf8(p);
        }
#line 8673 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 4951 "APItest.xs"
	const U8 * e;
#line 8689 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 4953 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isWORDCHAR_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isWORDCHAR_LC_utf8(p);
        }
#line 8703 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4966 "APItest.xs"
        RETVAL = isALPHANUMERIC_uni(ord);
#line 8722 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4973 "APItest.xs"
        RETVAL = isALPHANUMERIC_uvchr(ord);
#line 8741 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4980 "APItest.xs"
        RETVAL = isALPHANUMERIC_LC_uvchr(ord);
#line 8760 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4987 "APItest.xs"
        RETVAL = isALPHANUMERIC(ord);
#line 8779 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4994 "APItest.xs"
        RETVAL = isALPHANUMERIC_A(ord);
#line 8798 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5001 "APItest.xs"
        RETVAL = isALPHANUMERIC_L1(ord);
#line 8817 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5008 "APItest.xs"
        RETVAL = isALPHANUMERIC_LC(ord);
#line 8836 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5015 "APItest.xs"
	const U8 * e;
#line 8852 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5017 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isALPHANUMERIC_utf8_safe(p, e);
        }
        else {
            RETVAL = isALPHANUMERIC_utf8(p);
        }
#line 8866 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5030 "APItest.xs"
	const U8 * e;
#line 8882 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5032 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isALPHANUMERIC_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isALPHANUMERIC_LC_utf8(p);
        }
#line 8896 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5045 "APItest.xs"
        RETVAL = isALNUM(ord);
#line 8915 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5052 "APItest.xs"
        RETVAL = isALNUM_uni(ord);
#line 8934 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5059 "APItest.xs"
        RETVAL = isALNUM_LC_uvchr(ord);
#line 8953 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5066 "APItest.xs"
        RETVAL = isALNUM_LC(ord);
#line 8972 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5073 "APItest.xs"
	const U8 * e;
#line 8988 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5075 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isWORDCHAR_utf8_safe(p, e);
        }
        else {
            RETVAL = isWORDCHAR_utf8(p);
        }
#line 9002 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5088 "APItest.xs"
	const U8 * e;
#line 9018 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5090 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isWORDCHAR_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isWORDCHAR_LC_utf8(p);
        }
#line 9032 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5103 "APItest.xs"
        RETVAL = isDIGIT_uni(ord);
#line 9051 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5110 "APItest.xs"
        RETVAL = isDIGIT_uvchr(ord);
#line 9070 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5117 "APItest.xs"
        RETVAL = isDIGIT_LC_uvchr(ord);
#line 9089 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5124 "APItest.xs"
	const U8 * e;
#line 9105 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5126 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isDIGIT_utf8_safe(p, e);
        }
        else {
            RETVAL = isDIGIT_utf8(p);
        }
#line 9119 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5139 "APItest.xs"
	const U8 * e;
#line 9135 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5141 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isDIGIT_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isDIGIT_LC_utf8(p);
        }
#line 9149 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5154 "APItest.xs"
        RETVAL = isDIGIT(ord);
#line 9168 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5161 "APItest.xs"
        RETVAL = isDIGIT_A(ord);
#line 9187 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5168 "APItest.xs"
        RETVAL = isDIGIT_L1(ord);
#line 9206 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5175 "APItest.xs"
        RETVAL = isDIGIT_LC(ord);
#line 9225 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isOCTAL); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isOCTAL)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5182 "APItest.xs"
        RETVAL = isOCTAL(ord);
#line 9244 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isOCTAL_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isOCTAL_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5189 "APItest.xs"
        RETVAL = isOCTAL_A(ord);
#line 9263 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isOCTAL_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isOCTAL_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5196 "APItest.xs"
        RETVAL = isOCTAL_L1(ord);
#line 9282 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5203 "APItest.xs"
        RETVAL = isIDFIRST_uni(ord);
#line 9301 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5210 "APItest.xs"
        RETVAL = isIDFIRST_uvchr(ord);
#line 9320 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5217 "APItest.xs"
        RETVAL = isIDFIRST_LC_uvchr(ord);
#line 9339 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5224 "APItest.xs"
        RETVAL = isIDFIRST(ord);
#line 9358 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5231 "APItest.xs"
        RETVAL = isIDFIRST_A(ord);
#line 9377 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5238 "APItest.xs"
        RETVAL = isIDFIRST_L1(ord);
#line 9396 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5245 "APItest.xs"
        RETVAL = isIDFIRST_LC(ord);
#line 9415 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5252 "APItest.xs"
	const U8 * e;
#line 9431 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5254 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isIDFIRST_utf8_safe(p, e);
        }
        else {
            RETVAL = isIDFIRST_utf8(p);
        }
#line 9445 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5267 "APItest.xs"
	const U8 * e;
#line 9461 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5269 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isIDFIRST_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isIDFIRST_LC_utf8(p);
        }
#line 9475 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5282 "APItest.xs"
        RETVAL = isIDCONT_uni(ord);
#line 9494 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5289 "APItest.xs"
        RETVAL = isIDCONT_uvchr(ord);
#line 9513 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5296 "APItest.xs"
        RETVAL = isIDCONT_LC_uvchr(ord);
#line 9532 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5303 "APItest.xs"
        RETVAL = isIDCONT(ord);
#line 9551 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5310 "APItest.xs"
        RETVAL = isIDCONT_A(ord);
#line 9570 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5317 "APItest.xs"
        RETVAL = isIDCONT_L1(ord);
#line 9589 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5324 "APItest.xs"
        RETVAL = isIDCONT_LC(ord);
#line 9608 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5331 "APItest.xs"
	const U8 * e;
#line 9624 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5333 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isIDCONT_utf8_safe(p, e);
        }
        else {
            RETVAL = isIDCONT_utf8(p);
        }
#line 9638 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5346 "APItest.xs"
	const U8 * e;
#line 9654 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5348 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isIDCONT_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isIDCONT_LC_utf8(p);
        }
#line 9668 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5361 "APItest.xs"
        RETVAL = isSPACE_uni(ord);
#line 9687 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5368 "APItest.xs"
        RETVAL = isSPACE_uvchr(ord);
#line 9706 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5375 "APItest.xs"
        RETVAL = isSPACE_LC_uvchr(ord);
#line 9725 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5382 "APItest.xs"
        RETVAL = isSPACE(ord);
#line 9744 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5389 "APItest.xs"
        RETVAL = isSPACE_A(ord);
#line 9763 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5396 "APItest.xs"
        RETVAL = isSPACE_L1(ord);
#line 9782 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5403 "APItest.xs"
        RETVAL = isSPACE_LC(ord);
#line 9801 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5410 "APItest.xs"
	const U8 * e;
#line 9817 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5412 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isSPACE_utf8_safe(p, e);
        }
        else {
            RETVAL = isSPACE_utf8(p);
        }
#line 9831 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5425 "APItest.xs"
	const U8 * e;
#line 9847 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5427 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isSPACE_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isSPACE_LC_utf8(p);
        }
#line 9861 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5440 "APItest.xs"
        RETVAL = isASCII_uni(ord);
#line 9880 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5447 "APItest.xs"
        RETVAL = isASCII_uvchr(ord);
#line 9899 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5454 "APItest.xs"
        RETVAL = isASCII_LC_uvchr(ord);
#line 9918 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5461 "APItest.xs"
        RETVAL = isASCII(ord);
#line 9937 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5468 "APItest.xs"
        RETVAL = isASCII_A(ord);
#line 9956 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5475 "APItest.xs"
        RETVAL = isASCII_L1(ord);
#line 9975 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5482 "APItest.xs"
        RETVAL = isASCII_LC(ord);
#line 9994 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5489 "APItest.xs"
	const U8 * e;
#line 10010 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5491 "APItest.xs"
#ifndef DEBUGGING
        PERL_UNUSED_VAR(e);
#endif
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isASCII_utf8_safe(p, e);
        }
        else {
            RETVAL = isASCII_utf8(p);
        }
#line 10027 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5507 "APItest.xs"
	const U8 * e;
#line 10043 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5509 "APItest.xs"
#ifndef DEBUGGING
        PERL_UNUSED_VAR(e);
#endif
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isASCII_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isASCII_LC_utf8(p);
        }
#line 10060 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5525 "APItest.xs"
        RETVAL = isCNTRL_uni(ord);
#line 10079 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5532 "APItest.xs"
        RETVAL = isCNTRL_uvchr(ord);
#line 10098 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5539 "APItest.xs"
        RETVAL = isCNTRL_LC_uvchr(ord);
#line 10117 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5546 "APItest.xs"
        RETVAL = isCNTRL(ord);
#line 10136 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5553 "APItest.xs"
        RETVAL = isCNTRL_A(ord);
#line 10155 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5560 "APItest.xs"
        RETVAL = isCNTRL_L1(ord);
#line 10174 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5567 "APItest.xs"
        RETVAL = isCNTRL_LC(ord);
#line 10193 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5574 "APItest.xs"
	const U8 * e;
#line 10209 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5576 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isCNTRL_utf8_safe(p, e);
        }
        else {
            RETVAL = isCNTRL_utf8(p);
        }
#line 10223 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5589 "APItest.xs"
	const U8 * e;
#line 10239 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5591 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isCNTRL_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isCNTRL_LC_utf8(p);
        }
#line 10253 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5604 "APItest.xs"
        RETVAL = isPRINT_uni(ord);
#line 10272 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5611 "APItest.xs"
        RETVAL = isPRINT_uvchr(ord);
#line 10291 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5618 "APItest.xs"
        RETVAL = isPRINT_LC_uvchr(ord);
#line 10310 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5625 "APItest.xs"
        RETVAL = isPRINT(ord);
#line 10329 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5632 "APItest.xs"
        RETVAL = isPRINT_A(ord);
#line 10348 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5639 "APItest.xs"
        RETVAL = isPRINT_L1(ord);
#line 10367 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5646 "APItest.xs"
        RETVAL = isPRINT_LC(ord);
#line 10386 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5653 "APItest.xs"
	const U8 * e;
#line 10402 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5655 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPRINT_utf8_safe(p, e);
        }
        else {
            RETVAL = isPRINT_utf8(p);
        }
#line 10416 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5668 "APItest.xs"
	const U8 * e;
#line 10432 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5670 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPRINT_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isPRINT_LC_utf8(p);
        }
#line 10446 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5683 "APItest.xs"
        RETVAL = isGRAPH_uni(ord);
#line 10465 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5690 "APItest.xs"
        RETVAL = isGRAPH_uvchr(ord);
#line 10484 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5697 "APItest.xs"
        RETVAL = isGRAPH_LC_uvchr(ord);
#line 10503 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5704 "APItest.xs"
        RETVAL = isGRAPH(ord);
#line 10522 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5711 "APItest.xs"
        RETVAL = isGRAPH_A(ord);
#line 10541 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5718 "APItest.xs"
        RETVAL = isGRAPH_L1(ord);
#line 10560 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5725 "APItest.xs"
        RETVAL = isGRAPH_LC(ord);
#line 10579 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5732 "APItest.xs"
	const U8 * e;
#line 10595 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5734 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isGRAPH_utf8_safe(p, e);
        }
        else {
            RETVAL = isGRAPH_utf8(p);
        }
#line 10609 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5747 "APItest.xs"
	const U8 * e;
#line 10625 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5749 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isGRAPH_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isGRAPH_LC_utf8(p);
        }
#line 10639 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5762 "APItest.xs"
        RETVAL = isPUNCT_uni(ord);
#line 10658 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5769 "APItest.xs"
        RETVAL = isPUNCT_uvchr(ord);
#line 10677 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5776 "APItest.xs"
        RETVAL = isPUNCT_LC_uvchr(ord);
#line 10696 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5783 "APItest.xs"
        RETVAL = isPUNCT(ord);
#line 10715 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5790 "APItest.xs"
        RETVAL = isPUNCT_A(ord);
#line 10734 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5797 "APItest.xs"
        RETVAL = isPUNCT_L1(ord);
#line 10753 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5804 "APItest.xs"
        RETVAL = isPUNCT_LC(ord);
#line 10772 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5811 "APItest.xs"
	const U8 * e;
#line 10788 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5813 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPUNCT_utf8_safe(p, e);
        }
        else {
            RETVAL = isPUNCT_utf8(p);
        }
#line 10802 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5826 "APItest.xs"
	const U8 * e;
#line 10818 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5828 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPUNCT_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isPUNCT_LC_utf8(p);
        }
#line 10832 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5841 "APItest.xs"
        RETVAL = isXDIGIT_uni(ord);
#line 10851 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5848 "APItest.xs"
        RETVAL = isXDIGIT_uvchr(ord);
#line 10870 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5855 "APItest.xs"
        RETVAL = isXDIGIT_LC_uvchr(ord);
#line 10889 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5862 "APItest.xs"
        RETVAL = isXDIGIT(ord);
#line 10908 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5869 "APItest.xs"
        RETVAL = isXDIGIT_A(ord);
#line 10927 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5876 "APItest.xs"
        RETVAL = isXDIGIT_L1(ord);
#line 10946 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5883 "APItest.xs"
        RETVAL = isXDIGIT_LC(ord);
#line 10965 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5890 "APItest.xs"
	const U8 * e;
#line 10981 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5892 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isXDIGIT_utf8_safe(p, e);
        }
        else {
            RETVAL = isXDIGIT_utf8(p);
        }
#line 10995 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5905 "APItest.xs"
	const U8 * e;
#line 11011 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5907 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isXDIGIT_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isXDIGIT_LC_utf8(p);
        }
#line 11025 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5920 "APItest.xs"
        RETVAL = isPSXSPC_uni(ord);
#line 11044 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5927 "APItest.xs"
        RETVAL = isPSXSPC_uvchr(ord);
#line 11063 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5934 "APItest.xs"
        RETVAL = isPSXSPC_LC_uvchr(ord);
#line 11082 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5941 "APItest.xs"
        RETVAL = isPSXSPC(ord);
#line 11101 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5948 "APItest.xs"
        RETVAL = isPSXSPC_A(ord);
#line 11120 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5955 "APItest.xs"
        RETVAL = isPSXSPC_L1(ord);
#line 11139 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5962 "APItest.xs"
        RETVAL = isPSXSPC_LC(ord);
#line 11158 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5969 "APItest.xs"
	const U8 * e;
#line 11174 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5971 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPSXSPC_utf8_safe(p, e);
        }
        else {
            RETVAL = isPSXSPC_utf8(p);
        }
#line 11188 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 5984 "APItest.xs"
	const U8 * e;
#line 11204 "APItest.c"
	bool	RETVAL;
	U8 *	p = (U8 *)SvPV_nolen(ST(0))
;
	int	type = (int)SvIV(ST(1))
;
#line 5986 "APItest.xs"
        if (type >= 0) {
            e = p + UTF8SKIP(p) - type;
            RETVAL = isPSXSPC_LC_utf8_safe(p, e);
        }
        else {
            RETVAL = isPSXSPC_LC_utf8(p);
        }
#line 11218 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isQUOTEMETA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isQUOTEMETA)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5999 "APItest.xs"
        RETVAL = _isQUOTEMETA(ord);
#line 11237 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_OFFUNISKIP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_OFFUNISKIP)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6006 "APItest.xs"
        RETVAL = OFFUNISKIP(ord);
#line 11257 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_OFFUNI_IS_INVARIANT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_OFFUNI_IS_INVARIANT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6013 "APItest.xs"
        RETVAL = OFFUNI_IS_INVARIANT(ord);
#line 11276 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_UVCHR_IS_INVARIANT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_UVCHR_IS_INVARIANT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6020 "APItest.xs"
        RETVAL = UVCHR_IS_INVARIANT(ord);
#line 11295 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_INVARIANT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_INVARIANT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6027 "APItest.xs"
        RETVAL = UTF8_IS_INVARIANT(ch);
#line 11314 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_UVCHR_SKIP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_UVCHR_SKIP)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6034 "APItest.xs"
        RETVAL = UVCHR_SKIP(ord);
#line 11334 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_SKIP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_SKIP)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	UV	RETVAL;
	dXSTARG;
	char *	ch = (char *)SvPV_nolen(ST(0))
;
#line 6041 "APItest.xs"
        RETVAL = UTF8_SKIP(ch);
#line 11354 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_START); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_START)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6048 "APItest.xs"
        RETVAL = UTF8_IS_START(ch);
#line 11373 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_CONTINUATION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_CONTINUATION)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6055 "APItest.xs"
        RETVAL = UTF8_IS_CONTINUATION(ch);
#line 11392 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_CONTINUED); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_CONTINUED)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6062 "APItest.xs"
        RETVAL = UTF8_IS_CONTINUED(ch);
#line 11411 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_DOWNGRADEABLE_START); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_DOWNGRADEABLE_START)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6069 "APItest.xs"
        RETVAL = UTF8_IS_DOWNGRADEABLE_START(ch);
#line 11430 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_ABOVE_LATIN1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_UTF8_IS_ABOVE_LATIN1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6076 "APItest.xs"
        RETVAL = UTF8_IS_ABOVE_LATIN1(ch);
#line 11449 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUTF8_POSSIBLY_PROBLEMATIC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUTF8_POSSIBLY_PROBLEMATIC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ch");
    {
	bool	RETVAL;
	char	ch = (char)*SvPV_nolen(ST(0))
;
#line 6083 "APItest.xs"
        RETVAL = isUTF8_POSSIBLY_PROBLEMATIC(ch);
#line 11468 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUTF8_CHAR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUTF8_CHAR)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	STRLEN	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6090 "APItest.xs"
        RETVAL = isUTF8_CHAR((U8 *) s, (U8 *) s + len);
#line 11490 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUTF8_CHAR_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUTF8_CHAR_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	STRLEN	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6097 "APItest.xs"
        RETVAL = isUTF8_CHAR_flags((U8 *) s, (U8 *) s + len, flags);
#line 11514 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSTRICT_UTF8_CHAR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSTRICT_UTF8_CHAR)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	STRLEN	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6104 "APItest.xs"
        RETVAL = isSTRICT_UTF8_CHAR((U8 *) s, (U8 *) s + len);
#line 11536 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isC9_STRICT_UTF8_CHAR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isC9_STRICT_UTF8_CHAR)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	STRLEN	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6111 "APItest.xs"
        RETVAL = isC9_STRICT_UTF8_CHAR((U8 *) s, (U8 *) s + len);
#line 11558 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_valid_partial_char_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_valid_partial_char_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6118 "APItest.xs"
        /* RETVAL should be bool (here and in tests below), but making it IV
         * allows us to test it returning 0 or 1 */
        RETVAL = is_utf8_valid_partial_char_flags((U8 *) s, (U8 *) s + len, flags);
#line 11584 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6127 "APItest.xs"
        RETVAL = is_utf8_string((U8 *) s, len);
#line 11606 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#define WORDSIZE            sizeof(PERL_UINTMAX_T)

XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_invariant_string_loc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_invariant_string_loc)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, offset, len");
    {
#line 6136 "APItest.xs"
        AV *av;
        const U8 * ep = NULL;
        PERL_UINTMAX_T* copy;
#line 11625 "APItest.c"
	AV *	RETVAL;
	U8 *	s = (U8 *)SvPV_nolen(ST(0))
;
	STRLEN	offset = (STRLEN)SvUV(ST(1))
;
	STRLEN	len = (STRLEN)SvUV(ST(2))
;
#line 6140 "APItest.xs"
        /* 'offset' is number of bytes past a word boundary the testing of 's'
         * is to start at.  Allocate space that does start at the word
         * boundary, and copy 's' to the correct offset past it.  Then call the
         * tested function with that position */
        Newx(copy, 1 + ((len + WORDSIZE - 1) / WORDSIZE), PERL_UINTMAX_T);
        Copy(s, (U8 *) copy + offset, len, U8);
        av = newAV();
        av_push(av, newSViv(is_utf8_invariant_string_loc((U8 *) copy + offset, len, &ep)));
        av_push(av, newSViv(ep - ((U8 *) copy + offset)));
        RETVAL = av;
        Safefree(copy);
#line 11645 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_variant_under_utf8_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_variant_under_utf8_count)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, offset, len");
    {
#line 6157 "APItest.xs"
        PERL_UINTMAX_T * copy;
#line 11666 "APItest.c"
	STRLEN	RETVAL;
	dXSTARG;
	U8 *	s = (U8 *)SvPV_nolen(ST(0))
;
	STRLEN	offset = (STRLEN)SvUV(ST(1))
;
	STRLEN	len = (STRLEN)SvUV(ST(2))
;
#line 6159 "APItest.xs"
        Newx(copy, 1 + ((len + WORDSIZE - 1) / WORDSIZE), PERL_UINTMAX_T);
        Copy(s, (U8 *) copy + offset, len, U8);
        RETVAL = variant_under_utf8_count((U8 *) copy + offset, (U8 *) copy + offset + len);
        Safefree(copy);
#line 11680 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_utf8_length); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_utf8_length)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, offset, len");
    {
	STRLEN	RETVAL;
	dXSTARG;
	U8 *	s = (U8 *)SvPV_nolen(ST(0))
;
	STRLEN	offset = (STRLEN)SvUV(ST(1))
;
	STRLEN	len = (STRLEN)SvUV(ST(2))
;
#line 6169 "APItest.xs"
    RETVAL = utf8_length(s + offset, s + len);
#line 11704 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string_loc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string_loc)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6176 "APItest.xs"
        AV *av;
        const U8 * ep;
#line 11721 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6179 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_string_loc((U8 *) s, len, &ep)));
        av_push(av, newSViv(ep - (U8 *) s));
        RETVAL = av;
#line 11732 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string_loclen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string_loclen)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6189 "APItest.xs"
        AV *av;
        STRLEN ret_len;
        const U8 * ep;
#line 11755 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6193 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_string_loclen((U8 *) s, len, &ep, &ret_len)));
        av_push(av, newSViv(ep - (U8 *) s));
        av_push(av, newSVuv(ret_len));
        RETVAL = av;
#line 11767 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6204 "APItest.xs"
        RETVAL = is_utf8_string_flags((U8 *) s, len, flags);
#line 11796 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string_loc_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string_loc_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
#line 6211 "APItest.xs"
        AV *av;
        const U8 * ep;
#line 11813 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6214 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_string_loc_flags((U8 *) s, len, &ep, flags)));
        av_push(av, newSViv(ep - (U8 *) s));
        RETVAL = av;
#line 11826 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string_loclen_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_string_loclen_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
#line 6224 "APItest.xs"
        AV *av;
        STRLEN ret_len;
        const U8 * ep;
#line 11849 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6228 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_string_loclen_flags((U8 *) s, len, &ep, &ret_len, flags)));
        av_push(av, newSViv(ep - (U8 *) s));
        av_push(av, newSVuv(ret_len));
        RETVAL = av;
#line 11863 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_strict_utf8_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_strict_utf8_string)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6239 "APItest.xs"
        RETVAL = is_strict_utf8_string((U8 *) s, len);
#line 11890 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_strict_utf8_string_loc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_strict_utf8_string_loc)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6246 "APItest.xs"
        AV *av;
        const U8 * ep;
#line 11907 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6249 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_strict_utf8_string_loc((U8 *) s, len, &ep)));
        av_push(av, newSViv(ep - (U8 *) s));
        RETVAL = av;
#line 11918 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_strict_utf8_string_loclen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_strict_utf8_string_loclen)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6259 "APItest.xs"
        AV *av;
        STRLEN ret_len;
        const U8 * ep;
#line 11941 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6263 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_strict_utf8_string_loclen((U8 *) s, len, &ep, &ret_len)));
        av_push(av, newSViv(ep - (U8 *) s));
        av_push(av, newSVuv(ret_len));
        RETVAL = av;
#line 11953 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_c9strict_utf8_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_c9strict_utf8_string)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6274 "APItest.xs"
        RETVAL = is_c9strict_utf8_string((U8 *) s, len);
#line 11980 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_c9strict_utf8_string_loc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_c9strict_utf8_string_loc)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6281 "APItest.xs"
        AV *av;
        const U8 * ep;
#line 11997 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6284 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_c9strict_utf8_string_loc((U8 *) s, len, &ep)));
        av_push(av, newSViv(ep - (U8 *) s));
        RETVAL = av;
#line 12008 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_c9strict_utf8_string_loclen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_c9strict_utf8_string_loclen)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "s, len");
    {
#line 6294 "APItest.xs"
        AV *av;
        STRLEN ret_len;
        const U8 * ep;
#line 12031 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
#line 6298 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_c9strict_utf8_string_loclen((U8 *) s, len, &ep, &ret_len)));
        av_push(av, newSViv(ep - (U8 *) s));
        av_push(av, newSVuv(ret_len));
        RETVAL = av;
#line 12043 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_fixed_width_buf_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_fixed_width_buf_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	IV	RETVAL;
	dXSTARG;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6309 "APItest.xs"
        RETVAL = is_utf8_fixed_width_buf_flags((U8 *) s, len, flags);
#line 12072 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_fixed_width_buf_loc_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_fixed_width_buf_loc_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
#line 6316 "APItest.xs"
        AV *av;
        const U8 * ep;
#line 12089 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6319 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_fixed_width_buf_loc_flags((U8 *) s, len, &ep, flags)));
        av_push(av, newSViv(ep - (U8 *) s));
        RETVAL = av;
#line 12102 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_fixed_width_buf_loclen_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_is_utf8_fixed_width_buf_loclen_flags)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
#line 6329 "APItest.xs"
        AV *av;
        STRLEN ret_len;
        const U8 * ep;
#line 12125 "APItest.c"
	AV *	RETVAL;
	char *	s = (char *)SvPV_nolen(ST(0))
;
	STRLEN	len = (STRLEN)SvUV(ST(1))
;
	U32	flags = (unsigned long)SvUV(ST(2))
;
#line 6333 "APItest.xs"
        av = newAV();
        av_push(av, newSViv(is_utf8_fixed_width_buf_loclen_flags((U8 *) s, len, &ep, &ret_len, flags)));
        av_push(av, newSViv(ep - (U8 *) s));
        av_push(av, newSVuv(ret_len));
        RETVAL = av;
#line 12139 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_utf8_hop_safe); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_utf8_hop_safe)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s_sv, s_off, off");
    {
#line 6344 "APItest.xs"
        STRLEN len;
        U8 *p;
        U8 *r;
#line 12162 "APItest.c"
	IV	RETVAL;
	dXSTARG;
	SV *	s_sv = ST(0)
;
	STRLEN	s_off = (STRLEN)SvUV(ST(1))
;
	IV	off = (IV)SvIV(ST(2))
;
#line 6348 "APItest.xs"
        p = (U8 *)SvPV(s_sv, len);
        r = utf8_hop_safe(p + s_off, off, p, p + len);
        RETVAL = r - p;
#line 12175 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6357 "APItest.xs"
        RETVAL = toLOWER(ord);
#line 12195 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6364 "APItest.xs"
        RETVAL = toLOWER_L1(ord);
#line 12215 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6371 "APItest.xs"
        RETVAL = toLOWER_LC(ord);
#line 12235 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6378 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12254 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6383 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toLOWER_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12268 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6398 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12292 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6403 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toLOWER_uvchr(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12306 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6418 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
	const U8 * e;
        UV resultant_cp = UV_MAX;   /* Initialized because of dumb compilers */
#line 12333 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 6426 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        if (type >= 0) {
            e = input + UTF8SKIP(input) - type;
            resultant_cp = toLOWER_utf8_safe(input, e, s, &len);
        }
        else if (type == -1) {
            resultant_cp = toLOWER_utf8(input, s, &len);
        }
#ifndef NO_MATHOMS
        else {
            resultant_cp = Perl_to_utf8_lower(aTHX_ input, s, &len);
        }
#endif
        av_push(av, newSVuv(resultant_cp));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12362 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6454 "APItest.xs"
        RETVAL = toFOLD(ord);
#line 12387 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6461 "APItest.xs"
        RETVAL = toFOLD_LC(ord);
#line 12407 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6468 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12426 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6473 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toFOLD_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12440 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6488 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12464 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6493 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toFOLD_uvchr(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12478 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6508 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
	const U8 * e;
        UV resultant_cp = UV_MAX;
#line 12505 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 6516 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        if (type >= 0) {
            e = input + UTF8SKIP(input) - type;
            resultant_cp = toFOLD_utf8_safe(input, e, s, &len);
        }
        else if (type == -1) {
            resultant_cp = toFOLD_utf8(input, s, &len);
        }
#ifndef NO_MATHOMS
        else {
            resultant_cp = Perl_to_utf8_fold(aTHX_ input, s, &len);
        }
#endif
        av_push(av, newSVuv(resultant_cp));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12534 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6544 "APItest.xs"
        RETVAL = toUPPER(ord);
#line 12559 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6551 "APItest.xs"
        RETVAL = toUPPER_LC(ord);
#line 12579 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6558 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12598 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6563 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toUPPER_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12612 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6578 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12636 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6583 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toUPPER_uvchr(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12650 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6598 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
	const U8 * e;
        UV resultant_cp = UV_MAX;
#line 12677 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 6606 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        if (type >= 0) {
            e = input + UTF8SKIP(input) - type;
            resultant_cp = toUPPER_utf8_safe(input, e, s, &len);
        }
        else if (type == -1) {
            resultant_cp = toUPPER_utf8(input, s, &len);
        }
#ifndef NO_MATHOMS
        else {
            resultant_cp = Perl_to_utf8_upper(aTHX_ input, s, &len);
        }
#endif
        av_push(av, newSVuv(resultant_cp));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12706 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6634 "APItest.xs"
        RETVAL = toTITLE(ord);
#line 12731 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6641 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12750 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6646 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toTITLE_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12764 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 6661 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 12788 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 6666 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toTITLE_uvchr(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12802 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, type");
    {
#line 6681 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
	const U8 * e;
        UV resultant_cp = UV_MAX;
#line 12829 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 6689 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        if (type >= 0) {
            e = input + UTF8SKIP(input) - type;
            resultant_cp = toTITLE_utf8_safe(input, e, s, &len);
        }
        else if (type == -1) {
            resultant_cp = toTITLE_utf8(input, s, &len);
        }
#ifndef NO_MATHOMS
        else {
            resultant_cp = Perl_to_utf8_title(aTHX_ input, s, &len);
        }
#endif
        av_push(av, newSVuv(resultant_cp));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 12858 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_Gconvert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_Gconvert)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "number, num_digits");
    {
#line 6717 "APItest.xs"
        char buffer[100];
        int len;
#line 12880 "APItest.c"
	SV *	RETVAL;
	SV *	number = ST(0)
;
	SV *	num_digits = ST(1)
;
#line 6720 "APItest.xs"
        len = (int) SvIV(num_digits);
        if (len > 99) croak("Too long a number for test_Gconvert");
        if (len < 0) croak("Too short a number for test_Gconvert");
        PERL_UNUSED_RESULT(Gconvert(SvNV(number), len,
                 0,    /* No trailing zeroes */
                 buffer));
        RETVAL = newSVpv(buffer, 0);
#line 12894 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_Perl_langinfo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_Perl_langinfo)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "item");
    {
	SV *	RETVAL;
	SV *	item = ST(0)
;
#line 6733 "APItest.xs"
        RETVAL = newSVpv(Perl_langinfo(SvIV(item)), 0);
#line 12914 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Backrefs_apitest_weaken); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_apitest_weaken)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 6743 "APItest.xs"
        sv_rvweaken(sv);
#line 12933 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Backrefs_has_backrefs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_has_backrefs)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 6748 "APItest.xs"
        if (SvROK(sv) && sv_get_backrefs(SvRV(sv)))
            RETVAL = &PL_sv_yes;
        else
            RETVAL = &PL_sv_no;
#line 12954 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#ifdef WIN32
#ifdef PERL_IMPLICIT_SYS
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_XS__APItest__Backrefs_PerlDir_mapA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_PerlDir_mapA)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "path");
    {
	const char *	RETVAL;
	dXSTARG;
	const char *	path = (const char *)SvPV_nolen(ST(0))
;

	RETVAL = PerlDir_mapA(path);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Backrefs_PerlDir_mapW); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_PerlDir_mapW)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "wpath");
    {
	const WCHAR *	RETVAL;
	dXSTARG;
	const WCHAR *        wpath = (const WCHAR *)SvPV_nolen(ST(0))
;

	RETVAL = PerlDir_mapW(wpath);
	XSprePUSH; PUSHp((const char *)(RETVAL), sizeof(WCHAR) * (1+wcslen(RETVAL)));
    }
    XSRETURN(1);
}

#endif
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_XS__APItest__Backrefs_Comctl32Version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_Comctl32Version)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 6769 "APItest.xs"
        HMODULE dll;
        VS_FIXEDFILEINFO *info;
        UINT len;
        HRSRC hrsc;
        HGLOBAL ver;
        void * vercopy;
#line 13023 "APItest.c"
#line 6776 "APItest.xs"
        dll = GetModuleHandle("comctl32.dll"); /* must already be in proc */
        if(!dll)
            croak("Comctl32Version: comctl32.dll not in process???");
        hrsc = FindResource(dll,    MAKEINTRESOURCE(VS_VERSION_INFO),
                                    MAKEINTRESOURCE((Size_t)VS_FILE_INFO));
        if(!hrsc)
            croak("Comctl32Version: comctl32.dll no version???");
        ver = LoadResource(dll, hrsc);
        len = SizeofResource(dll, hrsc);
        vercopy = (void *)sv_grow(sv_newmortal(),len);
        memcpy(vercopy, ver, len);
        if (VerQueryValue(vercopy, "\\", (void**)&info, &len)) {
            int dwValueMS1 = (info->dwFileVersionMS>>16);
            int dwValueMS2 = (info->dwFileVersionMS&0xffff);
            int dwValueLS1 = (info->dwFileVersionLS>>16);
            int dwValueLS2 = (info->dwFileVersionLS&0xffff);
            EXTEND(SP, 4);
            mPUSHi(dwValueMS1);
            mPUSHi(dwValueMS2);
            mPUSHi(dwValueLS1);
            mPUSHi(dwValueLS2);
        }
#line 13047 "APItest.c"
	PUTBACK;
	return;
    }
}

#endif
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_XS__APItest); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_XS__APItest)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("XS::APItest::constant", XS_XS__APItest_constant);
        newXS_deffile("XS::APItest::numeric::grok_number", XS_XS__APItest__numeric_grok_number);
        newXS_deffile("XS::APItest::numeric::grok_number_flags", XS_XS__APItest__numeric_grok_number_flags);
        newXS_deffile("XS::APItest::numeric::grok_atoUV", XS_XS__APItest__numeric_grok_atoUV);
        newXS_deffile("XS::APItest::numeric::assertx", XS_XS__APItest__numeric_assertx);
        newXS_deffile("XS::APItest::utf8::bytes_cmp_utf8", XS_XS__APItest__utf8_bytes_cmp_utf8);
        newXS_deffile("XS::APItest::utf8::test_utf8_to_bytes", XS_XS__APItest__utf8_test_utf8_to_bytes);
        newXS_deffile("XS::APItest::utf8::test_utf8n_to_uvchr_msgs", XS_XS__APItest__utf8_test_utf8n_to_uvchr_msgs);
        newXS_deffile("XS::APItest::utf8::test_utf8n_to_uvchr_error", XS_XS__APItest__utf8_test_utf8n_to_uvchr_error);
        newXS_deffile("XS::APItest::utf8::test_valid_utf8_to_uvchr", XS_XS__APItest__utf8_test_valid_utf8_to_uvchr);
        newXS_deffile("XS::APItest::utf8::test_uvchr_to_utf8_flags", XS_XS__APItest__utf8_test_uvchr_to_utf8_flags);
        newXS_deffile("XS::APItest::utf8::test_uvchr_to_utf8_flags_msgs", XS_XS__APItest__utf8_test_uvchr_to_utf8_flags_msgs);
        newXS_deffile("XS::APItest::Overload::amagic_deref_call", XS_XS__APItest__Overload_amagic_deref_call);
        newXS_deffile("XS::APItest::Overload::tryAMAGICunDEREF_var", XS_XS__APItest__Overload_tryAMAGICunDEREF_var);
        newXS_deffile("XS::APItest::XSUB::XS_VERSION_defined", XS_XS__APItest__XSUB_XS_VERSION_defined);
        newXS_deffile("XS::APItest::XSUB::XS_APIVERSION_valid", XS_XS__APItest__XSUB_XS_APIVERSION_valid);
        newXS_deffile("XS::APItest::XSUB::xsreturn", XS_XS__APItest__XSUB_xsreturn);
        newXS_deffile("XS::APItest::XSUB::xsreturn_iv", XS_XS__APItest__XSUB_xsreturn_iv);
        newXS_deffile("XS::APItest::XSUB::xsreturn_uv", XS_XS__APItest__XSUB_xsreturn_uv);
        newXS_deffile("XS::APItest::XSUB::xsreturn_nv", XS_XS__APItest__XSUB_xsreturn_nv);
        newXS_deffile("XS::APItest::XSUB::xsreturn_pv", XS_XS__APItest__XSUB_xsreturn_pv);
        newXS_deffile("XS::APItest::XSUB::xsreturn_pvn", XS_XS__APItest__XSUB_xsreturn_pvn);
        newXS_deffile("XS::APItest::XSUB::xsreturn_no", XS_XS__APItest__XSUB_xsreturn_no);
        newXS_deffile("XS::APItest::XSUB::xsreturn_yes", XS_XS__APItest__XSUB_xsreturn_yes);
        newXS_deffile("XS::APItest::XSUB::xsreturn_undef", XS_XS__APItest__XSUB_xsreturn_undef);
        newXS_deffile("XS::APItest::XSUB::xsreturn_empty", XS_XS__APItest__XSUB_xsreturn_empty);
        newXS_deffile("XS::APItest::Hash::rot13_hash", XS_XS__APItest__Hash_rot13_hash);
        newXS_deffile("XS::APItest::Hash::bitflip_hash", XS_XS__APItest__Hash_bitflip_hash);
        newXS_deffile("XS::APItest::Hash::exists", XS_XS__APItest__Hash_exists);
        newXS_deffile("XS::APItest::Hash::exists_ent", XS_XS__APItest__Hash_exists_ent);
        newXS_deffile("XS::APItest::Hash::delete", XS_XS__APItest__Hash_delete);
        newXS_deffile("XS::APItest::Hash::delete_ent", XS_XS__APItest__Hash_delete_ent);
        newXS_deffile("XS::APItest::Hash::store_ent", XS_XS__APItest__Hash_store_ent);
        newXS_deffile("XS::APItest::Hash::store", XS_XS__APItest__Hash_store);
        newXS_deffile("XS::APItest::Hash::fetch_ent", XS_XS__APItest__Hash_fetch_ent);
        newXS_deffile("XS::APItest::Hash::fetch", XS_XS__APItest__Hash_fetch);
#if XSubPPtmpAAAA
        newXS_deffile("XS::APItest::Hash::common", XS_XS__APItest__Hash_common);
#endif
        newXS_deffile("XS::APItest::Hash::test_hv_free_ent", XS_XS__APItest__Hash_test_hv_free_ent);
        newXS_deffile("XS::APItest::Hash::test_hv_delayfree_ent", XS_XS__APItest__Hash_test_hv_delayfree_ent);
        newXS_deffile("XS::APItest::Hash::test_share_unshare_pvn", XS_XS__APItest__Hash_test_share_unshare_pvn);
#if XSubPPtmpAAAB
        newXS_deffile("XS::APItest::Hash::refcounted_he_exists", XS_XS__APItest__Hash_refcounted_he_exists);
        newXS_deffile("XS::APItest::Hash::refcounted_he_fetch", XS_XS__APItest__Hash_refcounted_he_fetch);
#endif
        newXS_deffile("XS::APItest::Hash::test_force_keys", XS_XS__APItest__Hash_test_force_keys);
        newXS_deffile("XS::APItest::TempLv::make_temp_mg_lv", XS_XS__APItest__TempLv_make_temp_mg_lv);
        newXS_deffile("XS::APItest::PtrTable::new", XS_XS__APItest__PtrTable_new);
        newXS_deffile("XS::APItest::PtrTable::DESTROY", XS_XS__APItest__PtrTable_DESTROY);
        newXS_deffile("XS::APItest::PtrTable::store", XS_XS__APItest__PtrTable_store);
        newXS_deffile("XS::APItest::PtrTable::fetch", XS_XS__APItest__PtrTable_fetch);
        newXS_deffile("XS::APItest::PtrTable::split", XS_XS__APItest__PtrTable_split);
        newXS_deffile("XS::APItest::PtrTable::clear", XS_XS__APItest__PtrTable_clear);
        newXS_deffile("XS::APItest::AutoLoader::AUTOLOAD", XS_XS__APItest__AutoLoader_AUTOLOAD);
        (void)newXSproto_portable("XS::APItest::AutoLoader::AUTOLOADp", XS_XS__APItest__AutoLoader_AUTOLOADp, file, "*$");
        newXS_deffile("XS::APItest::xop_custom_ops", XS_XS__APItest_xop_custom_ops);
        newXS_deffile("XS::APItest::xop_custom_op_names", XS_XS__APItest_xop_custom_op_names);
        newXS_deffile("XS::APItest::xop_custom_op_descs", XS_XS__APItest_xop_custom_op_descs);
        newXS_deffile("XS::APItest::xop_register", XS_XS__APItest_xop_register);
        newXS_deffile("XS::APItest::xop_clear", XS_XS__APItest_xop_clear);
        newXS_deffile("XS::APItest::xop_my_xop", XS_XS__APItest_xop_my_xop);
        newXS_deffile("XS::APItest::xop_ppaddr", XS_XS__APItest_xop_ppaddr);
        newXS_deffile("XS::APItest::xop_OA_UNOP", XS_XS__APItest_xop_OA_UNOP);
        newXS_deffile("XS::APItest::xop_build_optree", XS_XS__APItest_xop_build_optree);
        newXS_deffile("XS::APItest::xop_from_custom_op", XS_XS__APItest_xop_from_custom_op);
        newXS_deffile("XS::APItest::CLONE", XS_XS__APItest_CLONE);
        newXS_deffile("XS::APItest::print_double", XS_XS__APItest_print_double);
        newXS_deffile("XS::APItest::have_long_double", XS_XS__APItest_have_long_double);
        newXS_deffile("XS::APItest::print_long_double", XS_XS__APItest_print_long_double);
        newXS_deffile("XS::APItest::print_int", XS_XS__APItest_print_int);
        newXS_deffile("XS::APItest::print_long", XS_XS__APItest_print_long);
        newXS_deffile("XS::APItest::print_float", XS_XS__APItest_print_float);
        newXS_deffile("XS::APItest::print_flush", XS_XS__APItest_print_flush);
        newXS_deffile("XS::APItest::mpushp", XS_XS__APItest_mpushp);
        newXS_deffile("XS::APItest::mpushn", XS_XS__APItest_mpushn);
        newXS_deffile("XS::APItest::mpushi", XS_XS__APItest_mpushi);
        newXS_deffile("XS::APItest::mpushu", XS_XS__APItest_mpushu);
        newXS_deffile("XS::APItest::mxpushp", XS_XS__APItest_mxpushp);
        newXS_deffile("XS::APItest::mxpushn", XS_XS__APItest_mxpushn);
        newXS_deffile("XS::APItest::mxpushi", XS_XS__APItest_mxpushi);
        newXS_deffile("XS::APItest::mxpushu", XS_XS__APItest_mxpushu);
        newXS_deffile("XS::APItest::test_EXTEND", XS_XS__APItest_test_EXTEND);
        newXS_deffile("XS::APItest::call_sv_C", XS_XS__APItest_call_sv_C);
        newXS_deffile("XS::APItest::call_sv", XS_XS__APItest_call_sv);
        newXS_deffile("XS::APItest::call_pv", XS_XS__APItest_call_pv);
        newXS_deffile("XS::APItest::call_argv", XS_XS__APItest_call_argv);
        newXS_deffile("XS::APItest::call_method", XS_XS__APItest_call_method);
        cv = newXS_deffile("XS::APItest::newCONSTSUB", XS_XS__APItest_newCONSTSUB);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::newCONSTSUB_flags", XS_XS__APItest_newCONSTSUB);
        XSANY.any_i32 = 1;
        newXS_deffile("XS::APItest::gv_init_type", XS_XS__APItest_gv_init_type);
        newXS_deffile("XS::APItest::gv_fetchmeth_type", XS_XS__APItest_gv_fetchmeth_type);
        newXS_deffile("XS::APItest::gv_fetchmeth_autoload_type", XS_XS__APItest_gv_fetchmeth_autoload_type);
        newXS_deffile("XS::APItest::gv_fetchmethod_flags_type", XS_XS__APItest_gv_fetchmethod_flags_type);
        newXS_deffile("XS::APItest::gv_autoload_type", XS_XS__APItest_gv_autoload_type);
        newXS_deffile("XS::APItest::gv_const_sv", XS_XS__APItest_gv_const_sv);
        newXS_deffile("XS::APItest::whichsig_type", XS_XS__APItest_whichsig_type);
        newXS_deffile("XS::APItest::eval_sv", XS_XS__APItest_eval_sv);
        newXS_deffile("XS::APItest::eval_pv", XS_XS__APItest_eval_pv);
        newXS_deffile("XS::APItest::require_pv", XS_XS__APItest_require_pv);
        newXS_deffile("XS::APItest::apitest_exception", XS_XS__APItest_apitest_exception);
        newXS_deffile("XS::APItest::mycroak", XS_XS__APItest_mycroak);
        newXS_deffile("XS::APItest::strtab", XS_XS__APItest_strtab);
        newXS_deffile("XS::APItest::my_cxt_getint", XS_XS__APItest_my_cxt_getint);
        newXS_deffile("XS::APItest::my_cxt_setint", XS_XS__APItest_my_cxt_setint);
        newXS_deffile("XS::APItest::my_cxt_getsv", XS_XS__APItest_my_cxt_getsv);
        newXS_deffile("XS::APItest::my_cxt_setsv", XS_XS__APItest_my_cxt_setsv);
        newXS_deffile("XS::APItest::sv_setsv_cow_hashkey_core", XS_XS__APItest_sv_setsv_cow_hashkey_core);
        newXS_deffile("XS::APItest::sv_setsv_cow_hashkey_notcore", XS_XS__APItest_sv_setsv_cow_hashkey_notcore);
        newXS_deffile("XS::APItest::sv_set_deref", XS_XS__APItest_sv_set_deref);
        newXS_deffile("XS::APItest::rmagical_cast", XS_XS__APItest_rmagical_cast);
        newXS_deffile("XS::APItest::rmagical_flags", XS_XS__APItest_rmagical_flags);
        newXS_deffile("XS::APItest::my_caller", XS_XS__APItest_my_caller);
        newXS_deffile("XS::APItest::DPeek", XS_XS__APItest_DPeek);
        newXS_deffile("XS::APItest::BEGIN", XS_XS__APItest_BEGIN);
        newXS_deffile("XS::APItest::CHECK", XS_XS__APItest_CHECK);
        newXS_deffile("XS::APItest::UNITCHECK", XS_XS__APItest_UNITCHECK);
        newXS_deffile("XS::APItest::INIT", XS_XS__APItest_INIT);
        newXS_deffile("XS::APItest::END", XS_XS__APItest_END);
        cv = newXS_deffile("XS::APItest::utf16_to_utf8", XS_XS__APItest_utf16_to_utf8);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::utf16_to_utf8_reversed", XS_XS__APItest_utf16_to_utf8);
        XSANY.any_i32 = 1;
        newXS_deffile("XS::APItest::my_exit", XS_XS__APItest_my_exit);
        newXS_deffile("XS::APItest::first_byte", XS_XS__APItest_first_byte);
        newXS_deffile("XS::APItest::sv_count", XS_XS__APItest_sv_count);
        newXS_deffile("XS::APItest::bhk_record", XS_XS__APItest_bhk_record);
        newXS_deffile("XS::APItest::test_magic_chain", XS_XS__APItest_test_magic_chain);
        newXS_deffile("XS::APItest::test_op_contextualize", XS_XS__APItest_test_op_contextualize);
        (void)newXSproto_portable("XS::APItest::test_rv2cv_op_cv", XS_XS__APItest_test_rv2cv_op_cv, file, "");
        newXS_deffile("XS::APItest::test_cv_getset_call_checker", XS_XS__APItest_test_cv_getset_call_checker);
        newXS_deffile("XS::APItest::cv_set_call_checker_lists", XS_XS__APItest_cv_set_call_checker_lists);
        newXS_deffile("XS::APItest::cv_set_call_checker_scalars", XS_XS__APItest_cv_set_call_checker_scalars);
        newXS_deffile("XS::APItest::cv_set_call_checker_proto", XS_XS__APItest_cv_set_call_checker_proto);
        newXS_deffile("XS::APItest::cv_set_call_checker_proto_or_list", XS_XS__APItest_cv_set_call_checker_proto_or_list);
        newXS_deffile("XS::APItest::cv_set_call_checker_multi_sum", XS_XS__APItest_cv_set_call_checker_multi_sum);
        newXS_deffile("XS::APItest::test_cophh", XS_XS__APItest_test_cophh);
        newXS_deffile("XS::APItest::test_coplabel", XS_XS__APItest_test_coplabel);
        newXS_deffile("XS::APItest::example_cophh_2hv", XS_XS__APItest_example_cophh_2hv);
        newXS_deffile("XS::APItest::test_savehints", XS_XS__APItest_test_savehints);
        newXS_deffile("XS::APItest::test_copyhints", XS_XS__APItest_test_copyhints);
        newXS_deffile("XS::APItest::test_op_list", XS_XS__APItest_test_op_list);
        newXS_deffile("XS::APItest::test_op_linklist", XS_XS__APItest_test_op_linklist);
        newXS_deffile("XS::APItest::peep_enable", XS_XS__APItest_peep_enable);
        newXS_deffile("XS::APItest::peep_disable", XS_XS__APItest_peep_disable);
        newXS_deffile("XS::APItest::peep_record", XS_XS__APItest_peep_record);
        newXS_deffile("XS::APItest::rpeep_record", XS_XS__APItest_rpeep_record);
        (void)newXSproto_portable("XS::APItest::multicall_each", XS_XS__APItest_multicall_each, file, "&@");
        (void)newXSproto_portable("XS::APItest::multicall_return", XS_XS__APItest_multicall_return, file, "&$");
#if XSubPPtmpAAAC
        newXS_deffile("XS::APItest::clone_with_stack", XS_XS__APItest_clone_with_stack);
#endif
        newXS_deffile("XS::APItest::take_svref", XS_XS__APItest_take_svref);
        newXS_deffile("XS::APItest::take_avref", XS_XS__APItest_take_avref);
        newXS_deffile("XS::APItest::take_hvref", XS_XS__APItest_take_hvref);
        newXS_deffile("XS::APItest::take_cvref", XS_XS__APItest_take_cvref);
        (void)newXSproto_portable("XS::APItest::establish_cleanup", XS_XS__APItest_establish_cleanup, file, "$");
        (void)newXSproto_portable("XS::APItest::postinc", XS_XS__APItest_postinc, file, "$");
        newXS_deffile("XS::APItest::filter", XS_XS__APItest_filter);
        newXS_deffile("XS::APItest::lv_temp_object", XS_XS__APItest_lv_temp_object);
        newXS_deffile("XS::APItest::fill_hash_with_nulls", XS_XS__APItest_fill_hash_with_nulls);
        newXS_deffile("XS::APItest::newHVhv", XS_XS__APItest_newHVhv);
        newXS_deffile("XS::APItest::SvIsCOW", XS_XS__APItest_SvIsCOW);
        (void)newXSproto_portable("XS::APItest::pad_scalar", XS_XS__APItest_pad_scalar, file, "$$");
        newXS_deffile("XS::APItest::fetch_pad_names", XS_XS__APItest_fetch_pad_names);
        (void)newXSproto_portable("XS::APItest::underscore_length", XS_XS__APItest_underscore_length, file, "");
        newXS_deffile("XS::APItest::stringify", XS_XS__APItest_stringify);
        newXS_deffile("XS::APItest::HvENAME", XS_XS__APItest_HvENAME);
        newXS_deffile("XS::APItest::xs_cmp", XS_XS__APItest_xs_cmp);
        newXS_deffile("XS::APItest::xs_cmp_undef", XS_XS__APItest_xs_cmp_undef);
        newXS_deffile("XS::APItest::SvPVbyte", XS_XS__APItest_SvPVbyte);
        newXS_deffile("XS::APItest::SvPVutf8", XS_XS__APItest_SvPVutf8);
        newXS_deffile("XS::APItest::setup_addissub", XS_XS__APItest_setup_addissub);
        newXS_deffile("XS::APItest::setup_rv2cv_addunderbar", XS_XS__APItest_setup_rv2cv_addunderbar);
#if XSubPPtmpAAAD
        newXS_deffile("XS::APItest::test_alloccopstash", XS_XS__APItest_test_alloccopstash);
#endif
        newXS_deffile("XS::APItest::test_newFOROP_without_slab", XS_XS__APItest_test_newFOROP_without_slab);
        newXS_deffile("XS::APItest::callregexec", XS_XS__APItest_callregexec);
        newXS_deffile("XS::APItest::lexical_import", XS_XS__APItest_lexical_import);
        newXS_deffile("XS::APItest::sv_mortalcopy", XS_XS__APItest_sv_mortalcopy);
        newXS_deffile("XS::APItest::newRV", XS_XS__APItest_newRV);
        newXS_deffile("XS::APItest::alias_av", XS_XS__APItest_alias_av);
        newXS_deffile("XS::APItest::cv_name", XS_XS__APItest_cv_name);
        newXS_deffile("XS::APItest::sv_catpvn", XS_XS__APItest_sv_catpvn);
        newXS_deffile("XS::APItest::test_newOP_CUSTOM", XS_XS__APItest_test_newOP_CUSTOM);
        newXS_deffile("XS::APItest::test_sv_catpvf", XS_XS__APItest_test_sv_catpvf);
        newXS_deffile("XS::APItest::load_module", XS_XS__APItest_load_module);
        newXS_deffile("XS::APItest::string_without_null", XS_XS__APItest_string_without_null);
        newXS_deffile("XS::APItest::get_cv", XS_XS__APItest_get_cv);
        newXS_deffile("XS::APItest::get_cv_flags", XS_XS__APItest_get_cv_flags);
        newXS_deffile("XS::APItest::unshift_and_set_defav", XS_XS__APItest_unshift_and_set_defav);
        newXS_deffile("XS::APItest::PerlIO_stderr", XS_XS__APItest_PerlIO_stderr);
        newXS_deffile("XS::APItest::PerlIO_stdout", XS_XS__APItest_PerlIO_stdout);
        newXS_deffile("XS::APItest::PerlIO_stdin", XS_XS__APItest_PerlIO_stdin);
        newXS_deffile("XS::APItest::PerlIO_exportFILE", XS_XS__APItest_PerlIO_exportFILE);
        newXS_deffile("XS::APItest::AUTOLOADtest::AUTOLOAD", XS_XS__APItest__AUTOLOADtest_AUTOLOAD);
        cv = newXS_deffile("XS::APItest::Magic::sv_magic_bar", XS_XS__APItest__Magic_sv_magic_foo);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::Magic::sv_magic_foo", XS_XS__APItest__Magic_sv_magic_foo);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::Magic::mg_find_bar", XS_XS__APItest__Magic_mg_find_foo);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::Magic::mg_find_foo", XS_XS__APItest__Magic_mg_find_foo);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::Magic::sv_unmagic_bar", XS_XS__APItest__Magic_sv_unmagic_foo);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::Magic::sv_unmagic_foo", XS_XS__APItest__Magic_sv_unmagic_foo);
        XSANY.any_i32 = 0;
        newXS_deffile("XS::APItest::Magic::sv_magic", XS_XS__APItest__Magic_sv_magic);
        newXS_deffile("XS::APItest::Magic::test_get_vtbl", XS_XS__APItest__Magic_test_get_vtbl);
        newXS_deffile("XS::APItest::Magic::sv_magic_myset", XS_XS__APItest__Magic_sv_magic_myset);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_uni", XS_XS__APItest__Magic_test_isBLANK_uni);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_uvchr", XS_XS__APItest__Magic_test_isBLANK_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_LC_uvchr", XS_XS__APItest__Magic_test_isBLANK_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isBLANK", XS_XS__APItest__Magic_test_isBLANK);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_A", XS_XS__APItest__Magic_test_isBLANK_A);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_L1", XS_XS__APItest__Magic_test_isBLANK_L1);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_LC", XS_XS__APItest__Magic_test_isBLANK_LC);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_utf8", XS_XS__APItest__Magic_test_isBLANK_utf8);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_LC_utf8", XS_XS__APItest__Magic_test_isBLANK_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isVERTWS_uni", XS_XS__APItest__Magic_test_isVERTWS_uni);
        newXS_deffile("XS::APItest::Magic::test_isVERTWS_uvchr", XS_XS__APItest__Magic_test_isVERTWS_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isVERTWS_utf8", XS_XS__APItest__Magic_test_isVERTWS_utf8);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_uni", XS_XS__APItest__Magic_test_isUPPER_uni);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_uvchr", XS_XS__APItest__Magic_test_isUPPER_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_LC_uvchr", XS_XS__APItest__Magic_test_isUPPER_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isUPPER", XS_XS__APItest__Magic_test_isUPPER);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_A", XS_XS__APItest__Magic_test_isUPPER_A);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_L1", XS_XS__APItest__Magic_test_isUPPER_L1);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_LC", XS_XS__APItest__Magic_test_isUPPER_LC);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_utf8", XS_XS__APItest__Magic_test_isUPPER_utf8);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_LC_utf8", XS_XS__APItest__Magic_test_isUPPER_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_uni", XS_XS__APItest__Magic_test_isLOWER_uni);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_uvchr", XS_XS__APItest__Magic_test_isLOWER_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_LC_uvchr", XS_XS__APItest__Magic_test_isLOWER_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isLOWER", XS_XS__APItest__Magic_test_isLOWER);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_A", XS_XS__APItest__Magic_test_isLOWER_A);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_L1", XS_XS__APItest__Magic_test_isLOWER_L1);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_LC", XS_XS__APItest__Magic_test_isLOWER_LC);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_utf8", XS_XS__APItest__Magic_test_isLOWER_utf8);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_LC_utf8", XS_XS__APItest__Magic_test_isLOWER_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_uni", XS_XS__APItest__Magic_test_isALPHA_uni);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_uvchr", XS_XS__APItest__Magic_test_isALPHA_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_LC_uvchr", XS_XS__APItest__Magic_test_isALPHA_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isALPHA", XS_XS__APItest__Magic_test_isALPHA);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_A", XS_XS__APItest__Magic_test_isALPHA_A);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_L1", XS_XS__APItest__Magic_test_isALPHA_L1);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_LC", XS_XS__APItest__Magic_test_isALPHA_LC);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_utf8", XS_XS__APItest__Magic_test_isALPHA_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_LC_utf8", XS_XS__APItest__Magic_test_isALPHA_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_uni", XS_XS__APItest__Magic_test_isWORDCHAR_uni);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_uvchr", XS_XS__APItest__Magic_test_isWORDCHAR_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_LC_uvchr", XS_XS__APItest__Magic_test_isWORDCHAR_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR", XS_XS__APItest__Magic_test_isWORDCHAR);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_A", XS_XS__APItest__Magic_test_isWORDCHAR_A);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_L1", XS_XS__APItest__Magic_test_isWORDCHAR_L1);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_LC", XS_XS__APItest__Magic_test_isWORDCHAR_LC);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_utf8", XS_XS__APItest__Magic_test_isWORDCHAR_utf8);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_LC_utf8", XS_XS__APItest__Magic_test_isWORDCHAR_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_uni", XS_XS__APItest__Magic_test_isALPHANUMERIC_uni);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_uvchr", XS_XS__APItest__Magic_test_isALPHANUMERIC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_LC_uvchr", XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC", XS_XS__APItest__Magic_test_isALPHANUMERIC);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_A", XS_XS__APItest__Magic_test_isALPHANUMERIC_A);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_L1", XS_XS__APItest__Magic_test_isALPHANUMERIC_L1);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_LC", XS_XS__APItest__Magic_test_isALPHANUMERIC_LC);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_utf8", XS_XS__APItest__Magic_test_isALPHANUMERIC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_LC_utf8", XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALNUM", XS_XS__APItest__Magic_test_isALNUM);
        newXS_deffile("XS::APItest::Magic::test_isALNUM_uni", XS_XS__APItest__Magic_test_isALNUM_uni);
        newXS_deffile("XS::APItest::Magic::test_isALNUM_LC_uvchr", XS_XS__APItest__Magic_test_isALNUM_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isALNUM_LC", XS_XS__APItest__Magic_test_isALNUM_LC);
        newXS_deffile("XS::APItest::Magic::test_isALNUM_utf8", XS_XS__APItest__Magic_test_isALNUM_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALNUM_LC_utf8", XS_XS__APItest__Magic_test_isALNUM_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_uni", XS_XS__APItest__Magic_test_isDIGIT_uni);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_uvchr", XS_XS__APItest__Magic_test_isDIGIT_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_LC_uvchr", XS_XS__APItest__Magic_test_isDIGIT_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_utf8", XS_XS__APItest__Magic_test_isDIGIT_utf8);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_LC_utf8", XS_XS__APItest__Magic_test_isDIGIT_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT", XS_XS__APItest__Magic_test_isDIGIT);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_A", XS_XS__APItest__Magic_test_isDIGIT_A);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_L1", XS_XS__APItest__Magic_test_isDIGIT_L1);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_LC", XS_XS__APItest__Magic_test_isDIGIT_LC);
        newXS_deffile("XS::APItest::Magic::test_isOCTAL", XS_XS__APItest__Magic_test_isOCTAL);
        newXS_deffile("XS::APItest::Magic::test_isOCTAL_A", XS_XS__APItest__Magic_test_isOCTAL_A);
        newXS_deffile("XS::APItest::Magic::test_isOCTAL_L1", XS_XS__APItest__Magic_test_isOCTAL_L1);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_uni", XS_XS__APItest__Magic_test_isIDFIRST_uni);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_uvchr", XS_XS__APItest__Magic_test_isIDFIRST_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_LC_uvchr", XS_XS__APItest__Magic_test_isIDFIRST_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST", XS_XS__APItest__Magic_test_isIDFIRST);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_A", XS_XS__APItest__Magic_test_isIDFIRST_A);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_L1", XS_XS__APItest__Magic_test_isIDFIRST_L1);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_LC", XS_XS__APItest__Magic_test_isIDFIRST_LC);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_utf8", XS_XS__APItest__Magic_test_isIDFIRST_utf8);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_LC_utf8", XS_XS__APItest__Magic_test_isIDFIRST_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_uni", XS_XS__APItest__Magic_test_isIDCONT_uni);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_uvchr", XS_XS__APItest__Magic_test_isIDCONT_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_LC_uvchr", XS_XS__APItest__Magic_test_isIDCONT_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT", XS_XS__APItest__Magic_test_isIDCONT);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_A", XS_XS__APItest__Magic_test_isIDCONT_A);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_L1", XS_XS__APItest__Magic_test_isIDCONT_L1);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_LC", XS_XS__APItest__Magic_test_isIDCONT_LC);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_utf8", XS_XS__APItest__Magic_test_isIDCONT_utf8);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_LC_utf8", XS_XS__APItest__Magic_test_isIDCONT_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_uni", XS_XS__APItest__Magic_test_isSPACE_uni);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_uvchr", XS_XS__APItest__Magic_test_isSPACE_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_LC_uvchr", XS_XS__APItest__Magic_test_isSPACE_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isSPACE", XS_XS__APItest__Magic_test_isSPACE);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_A", XS_XS__APItest__Magic_test_isSPACE_A);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_L1", XS_XS__APItest__Magic_test_isSPACE_L1);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_LC", XS_XS__APItest__Magic_test_isSPACE_LC);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_utf8", XS_XS__APItest__Magic_test_isSPACE_utf8);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_LC_utf8", XS_XS__APItest__Magic_test_isSPACE_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isASCII_uni", XS_XS__APItest__Magic_test_isASCII_uni);
        newXS_deffile("XS::APItest::Magic::test_isASCII_uvchr", XS_XS__APItest__Magic_test_isASCII_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isASCII_LC_uvchr", XS_XS__APItest__Magic_test_isASCII_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isASCII", XS_XS__APItest__Magic_test_isASCII);
        newXS_deffile("XS::APItest::Magic::test_isASCII_A", XS_XS__APItest__Magic_test_isASCII_A);
        newXS_deffile("XS::APItest::Magic::test_isASCII_L1", XS_XS__APItest__Magic_test_isASCII_L1);
        newXS_deffile("XS::APItest::Magic::test_isASCII_LC", XS_XS__APItest__Magic_test_isASCII_LC);
        newXS_deffile("XS::APItest::Magic::test_isASCII_utf8", XS_XS__APItest__Magic_test_isASCII_utf8);
        newXS_deffile("XS::APItest::Magic::test_isASCII_LC_utf8", XS_XS__APItest__Magic_test_isASCII_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_uni", XS_XS__APItest__Magic_test_isCNTRL_uni);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_uvchr", XS_XS__APItest__Magic_test_isCNTRL_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_LC_uvchr", XS_XS__APItest__Magic_test_isCNTRL_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL", XS_XS__APItest__Magic_test_isCNTRL);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_A", XS_XS__APItest__Magic_test_isCNTRL_A);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_L1", XS_XS__APItest__Magic_test_isCNTRL_L1);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_LC", XS_XS__APItest__Magic_test_isCNTRL_LC);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_utf8", XS_XS__APItest__Magic_test_isCNTRL_utf8);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_LC_utf8", XS_XS__APItest__Magic_test_isCNTRL_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_uni", XS_XS__APItest__Magic_test_isPRINT_uni);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_uvchr", XS_XS__APItest__Magic_test_isPRINT_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_LC_uvchr", XS_XS__APItest__Magic_test_isPRINT_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isPRINT", XS_XS__APItest__Magic_test_isPRINT);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_A", XS_XS__APItest__Magic_test_isPRINT_A);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_L1", XS_XS__APItest__Magic_test_isPRINT_L1);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_LC", XS_XS__APItest__Magic_test_isPRINT_LC);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_utf8", XS_XS__APItest__Magic_test_isPRINT_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_LC_utf8", XS_XS__APItest__Magic_test_isPRINT_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_uni", XS_XS__APItest__Magic_test_isGRAPH_uni);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_uvchr", XS_XS__APItest__Magic_test_isGRAPH_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_LC_uvchr", XS_XS__APItest__Magic_test_isGRAPH_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH", XS_XS__APItest__Magic_test_isGRAPH);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_A", XS_XS__APItest__Magic_test_isGRAPH_A);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_L1", XS_XS__APItest__Magic_test_isGRAPH_L1);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_LC", XS_XS__APItest__Magic_test_isGRAPH_LC);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_utf8", XS_XS__APItest__Magic_test_isGRAPH_utf8);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_LC_utf8", XS_XS__APItest__Magic_test_isGRAPH_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_uni", XS_XS__APItest__Magic_test_isPUNCT_uni);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_uvchr", XS_XS__APItest__Magic_test_isPUNCT_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_LC_uvchr", XS_XS__APItest__Magic_test_isPUNCT_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT", XS_XS__APItest__Magic_test_isPUNCT);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_A", XS_XS__APItest__Magic_test_isPUNCT_A);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_L1", XS_XS__APItest__Magic_test_isPUNCT_L1);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_LC", XS_XS__APItest__Magic_test_isPUNCT_LC);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_utf8", XS_XS__APItest__Magic_test_isPUNCT_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_LC_utf8", XS_XS__APItest__Magic_test_isPUNCT_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_uni", XS_XS__APItest__Magic_test_isXDIGIT_uni);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_uvchr", XS_XS__APItest__Magic_test_isXDIGIT_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_LC_uvchr", XS_XS__APItest__Magic_test_isXDIGIT_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT", XS_XS__APItest__Magic_test_isXDIGIT);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_A", XS_XS__APItest__Magic_test_isXDIGIT_A);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_L1", XS_XS__APItest__Magic_test_isXDIGIT_L1);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_LC", XS_XS__APItest__Magic_test_isXDIGIT_LC);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_utf8", XS_XS__APItest__Magic_test_isXDIGIT_utf8);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_LC_utf8", XS_XS__APItest__Magic_test_isXDIGIT_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_uni", XS_XS__APItest__Magic_test_isPSXSPC_uni);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_uvchr", XS_XS__APItest__Magic_test_isPSXSPC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_LC_uvchr", XS_XS__APItest__Magic_test_isPSXSPC_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC", XS_XS__APItest__Magic_test_isPSXSPC);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_A", XS_XS__APItest__Magic_test_isPSXSPC_A);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_L1", XS_XS__APItest__Magic_test_isPSXSPC_L1);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_LC", XS_XS__APItest__Magic_test_isPSXSPC_LC);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_utf8", XS_XS__APItest__Magic_test_isPSXSPC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_LC_utf8", XS_XS__APItest__Magic_test_isPSXSPC_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isQUOTEMETA", XS_XS__APItest__Magic_test_isQUOTEMETA);
        newXS_deffile("XS::APItest::Magic::test_OFFUNISKIP", XS_XS__APItest__Magic_test_OFFUNISKIP);
        newXS_deffile("XS::APItest::Magic::test_OFFUNI_IS_INVARIANT", XS_XS__APItest__Magic_test_OFFUNI_IS_INVARIANT);
        newXS_deffile("XS::APItest::Magic::test_UVCHR_IS_INVARIANT", XS_XS__APItest__Magic_test_UVCHR_IS_INVARIANT);
        newXS_deffile("XS::APItest::Magic::test_UTF8_IS_INVARIANT", XS_XS__APItest__Magic_test_UTF8_IS_INVARIANT);
        newXS_deffile("XS::APItest::Magic::test_UVCHR_SKIP", XS_XS__APItest__Magic_test_UVCHR_SKIP);
        newXS_deffile("XS::APItest::Magic::test_UTF8_SKIP", XS_XS__APItest__Magic_test_UTF8_SKIP);
        newXS_deffile("XS::APItest::Magic::test_UTF8_IS_START", XS_XS__APItest__Magic_test_UTF8_IS_START);
        newXS_deffile("XS::APItest::Magic::test_UTF8_IS_CONTINUATION", XS_XS__APItest__Magic_test_UTF8_IS_CONTINUATION);
        newXS_deffile("XS::APItest::Magic::test_UTF8_IS_CONTINUED", XS_XS__APItest__Magic_test_UTF8_IS_CONTINUED);
        newXS_deffile("XS::APItest::Magic::test_UTF8_IS_DOWNGRADEABLE_START", XS_XS__APItest__Magic_test_UTF8_IS_DOWNGRADEABLE_START);
        newXS_deffile("XS::APItest::Magic::test_UTF8_IS_ABOVE_LATIN1", XS_XS__APItest__Magic_test_UTF8_IS_ABOVE_LATIN1);
        newXS_deffile("XS::APItest::Magic::test_isUTF8_POSSIBLY_PROBLEMATIC", XS_XS__APItest__Magic_test_isUTF8_POSSIBLY_PROBLEMATIC);
        newXS_deffile("XS::APItest::Magic::test_isUTF8_CHAR", XS_XS__APItest__Magic_test_isUTF8_CHAR);
        newXS_deffile("XS::APItest::Magic::test_isUTF8_CHAR_flags", XS_XS__APItest__Magic_test_isUTF8_CHAR_flags);
        newXS_deffile("XS::APItest::Magic::test_isSTRICT_UTF8_CHAR", XS_XS__APItest__Magic_test_isSTRICT_UTF8_CHAR);
        newXS_deffile("XS::APItest::Magic::test_isC9_STRICT_UTF8_CHAR", XS_XS__APItest__Magic_test_isC9_STRICT_UTF8_CHAR);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_valid_partial_char_flags", XS_XS__APItest__Magic_test_is_utf8_valid_partial_char_flags);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_string", XS_XS__APItest__Magic_test_is_utf8_string);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_invariant_string_loc", XS_XS__APItest__Magic_test_is_utf8_invariant_string_loc);
        newXS_deffile("XS::APItest::Magic::test_variant_under_utf8_count", XS_XS__APItest__Magic_test_variant_under_utf8_count);
        newXS_deffile("XS::APItest::Magic::test_utf8_length", XS_XS__APItest__Magic_test_utf8_length);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_string_loc", XS_XS__APItest__Magic_test_is_utf8_string_loc);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_string_loclen", XS_XS__APItest__Magic_test_is_utf8_string_loclen);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_string_flags", XS_XS__APItest__Magic_test_is_utf8_string_flags);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_string_loc_flags", XS_XS__APItest__Magic_test_is_utf8_string_loc_flags);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_string_loclen_flags", XS_XS__APItest__Magic_test_is_utf8_string_loclen_flags);
        newXS_deffile("XS::APItest::Magic::test_is_strict_utf8_string", XS_XS__APItest__Magic_test_is_strict_utf8_string);
        newXS_deffile("XS::APItest::Magic::test_is_strict_utf8_string_loc", XS_XS__APItest__Magic_test_is_strict_utf8_string_loc);
        newXS_deffile("XS::APItest::Magic::test_is_strict_utf8_string_loclen", XS_XS__APItest__Magic_test_is_strict_utf8_string_loclen);
        newXS_deffile("XS::APItest::Magic::test_is_c9strict_utf8_string", XS_XS__APItest__Magic_test_is_c9strict_utf8_string);
        newXS_deffile("XS::APItest::Magic::test_is_c9strict_utf8_string_loc", XS_XS__APItest__Magic_test_is_c9strict_utf8_string_loc);
        newXS_deffile("XS::APItest::Magic::test_is_c9strict_utf8_string_loclen", XS_XS__APItest__Magic_test_is_c9strict_utf8_string_loclen);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_fixed_width_buf_flags", XS_XS__APItest__Magic_test_is_utf8_fixed_width_buf_flags);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_fixed_width_buf_loc_flags", XS_XS__APItest__Magic_test_is_utf8_fixed_width_buf_loc_flags);
        newXS_deffile("XS::APItest::Magic::test_is_utf8_fixed_width_buf_loclen_flags", XS_XS__APItest__Magic_test_is_utf8_fixed_width_buf_loclen_flags);
        newXS_deffile("XS::APItest::Magic::test_utf8_hop_safe", XS_XS__APItest__Magic_test_utf8_hop_safe);
        newXS_deffile("XS::APItest::Magic::test_toLOWER", XS_XS__APItest__Magic_test_toLOWER);
        newXS_deffile("XS::APItest::Magic::test_toLOWER_L1", XS_XS__APItest__Magic_test_toLOWER_L1);
        newXS_deffile("XS::APItest::Magic::test_toLOWER_LC", XS_XS__APItest__Magic_test_toLOWER_LC);
        newXS_deffile("XS::APItest::Magic::test_toLOWER_uni", XS_XS__APItest__Magic_test_toLOWER_uni);
        newXS_deffile("XS::APItest::Magic::test_toLOWER_uvchr", XS_XS__APItest__Magic_test_toLOWER_uvchr);
        newXS_deffile("XS::APItest::Magic::test_toLOWER_utf8", XS_XS__APItest__Magic_test_toLOWER_utf8);
        newXS_deffile("XS::APItest::Magic::test_toFOLD", XS_XS__APItest__Magic_test_toFOLD);
        newXS_deffile("XS::APItest::Magic::test_toFOLD_LC", XS_XS__APItest__Magic_test_toFOLD_LC);
        newXS_deffile("XS::APItest::Magic::test_toFOLD_uni", XS_XS__APItest__Magic_test_toFOLD_uni);
        newXS_deffile("XS::APItest::Magic::test_toFOLD_uvchr", XS_XS__APItest__Magic_test_toFOLD_uvchr);
        newXS_deffile("XS::APItest::Magic::test_toFOLD_utf8", XS_XS__APItest__Magic_test_toFOLD_utf8);
        newXS_deffile("XS::APItest::Magic::test_toUPPER", XS_XS__APItest__Magic_test_toUPPER);
        newXS_deffile("XS::APItest::Magic::test_toUPPER_LC", XS_XS__APItest__Magic_test_toUPPER_LC);
        newXS_deffile("XS::APItest::Magic::test_toUPPER_uni", XS_XS__APItest__Magic_test_toUPPER_uni);
        newXS_deffile("XS::APItest::Magic::test_toUPPER_uvchr", XS_XS__APItest__Magic_test_toUPPER_uvchr);
        newXS_deffile("XS::APItest::Magic::test_toUPPER_utf8", XS_XS__APItest__Magic_test_toUPPER_utf8);
        newXS_deffile("XS::APItest::Magic::test_toTITLE", XS_XS__APItest__Magic_test_toTITLE);
        newXS_deffile("XS::APItest::Magic::test_toTITLE_uni", XS_XS__APItest__Magic_test_toTITLE_uni);
        newXS_deffile("XS::APItest::Magic::test_toTITLE_uvchr", XS_XS__APItest__Magic_test_toTITLE_uvchr);
        newXS_deffile("XS::APItest::Magic::test_toTITLE_utf8", XS_XS__APItest__Magic_test_toTITLE_utf8);
        newXS_deffile("XS::APItest::Magic::test_Gconvert", XS_XS__APItest__Magic_test_Gconvert);
        newXS_deffile("XS::APItest::Magic::test_Perl_langinfo", XS_XS__APItest__Magic_test_Perl_langinfo);
        (void)newXSproto_portable("XS::APItest::Backrefs::apitest_weaken", XS_XS__APItest__Backrefs_apitest_weaken, file, "$");
        newXS_deffile("XS::APItest::Backrefs::has_backrefs", XS_XS__APItest__Backrefs_has_backrefs);
#if XSubPPtmpAAAE
        newXS_deffile("XS::APItest::Backrefs::PerlDir_mapA", XS_XS__APItest__Backrefs_PerlDir_mapA);
        newXS_deffile("XS::APItest::Backrefs::PerlDir_mapW", XS_XS__APItest__Backrefs_PerlDir_mapW);
#endif
#if XSubPPtmpAAAF
        newXS_deffile("XS::APItest::Backrefs::Comctl32Version", XS_XS__APItest__Backrefs_Comctl32Version);
#endif

    /* Initialisation Section */

#line 2 "./const-xs.inc"
  {
#if defined(dTHX) && !defined(PERL_NO_GET_CONTEXT)
    dTHX;
#endif
    HV *symbol_table = get_hv("XS::APItest::", GV_ADD);

    static const struct iv_s values_for_iv[] =
      {
#ifdef HV_DELETE
        { "HV_DELETE", 9, HV_DELETE },
#endif
#ifdef HV_DISABLE_UVAR_XKEY
        { "HV_DISABLE_UVAR_XKEY", 20, HV_DISABLE_UVAR_XKEY },
#endif
#ifdef HV_FETCH_ISSTORE
        { "HV_FETCH_ISSTORE", 16, HV_FETCH_ISSTORE },
#endif
#ifdef HV_FETCH_ISEXISTS
        { "HV_FETCH_ISEXISTS", 17, HV_FETCH_ISEXISTS },
#endif
#ifdef HV_FETCH_LVALUE
        { "HV_FETCH_LVALUE", 15, HV_FETCH_LVALUE },
#endif
#ifdef HV_FETCH_JUST_SV
        { "HV_FETCH_JUST_SV", 16, HV_FETCH_JUST_SV },
#endif
#ifdef G_SCALAR
        { "G_SCALAR", 8, G_SCALAR },
#endif
#ifdef G_ARRAY
        { "G_ARRAY", 7, G_ARRAY },
#endif
#ifdef G_VOID
        { "G_VOID", 6, G_VOID },
#endif
#ifdef G_DISCARD
        { "G_DISCARD", 9, G_DISCARD },
#endif
#ifdef G_EVAL
        { "G_EVAL", 6, G_EVAL },
#endif
#ifdef G_NOARGS
        { "G_NOARGS", 8, G_NOARGS },
#endif
#ifdef G_KEEPERR
        { "G_KEEPERR", 9, G_KEEPERR },
#endif
#ifdef G_NODEBUG
        { "G_NODEBUG", 9, G_NODEBUG },
#endif
#ifdef G_METHOD
        { "G_METHOD", 8, G_METHOD },
#endif
#ifdef G_FAKINGEVAL
        { "G_FAKINGEVAL", 12, G_FAKINGEVAL },
#endif
#ifdef GV_NOADD_NOINIT
        { "GV_NOADD_NOINIT", 15, GV_NOADD_NOINIT },
#endif
#ifdef IS_NUMBER_IN_UV
        { "IS_NUMBER_IN_UV", 15, IS_NUMBER_IN_UV },
#endif
#ifdef IS_NUMBER_GREATER_THAN_UV_MAX
        { "IS_NUMBER_GREATER_THAN_UV_MAX", 29, IS_NUMBER_GREATER_THAN_UV_MAX },
#endif
#ifdef IS_NUMBER_NOT_INT
        { "IS_NUMBER_NOT_INT", 17, IS_NUMBER_NOT_INT },
#endif
#ifdef IS_NUMBER_NEG
        { "IS_NUMBER_NEG", 13, IS_NUMBER_NEG },
#endif
#ifdef IS_NUMBER_INFINITY
        { "IS_NUMBER_INFINITY", 18, IS_NUMBER_INFINITY },
#endif
#ifdef IS_NUMBER_NAN
        { "IS_NUMBER_NAN", 13, IS_NUMBER_NAN },
#endif
#ifdef IS_NUMBER_TRAILING
        { "IS_NUMBER_TRAILING", 18, IS_NUMBER_TRAILING },
#endif
#ifdef PERL_SCAN_TRAILING
        { "PERL_SCAN_TRAILING", 18, PERL_SCAN_TRAILING },
#endif
#ifdef PERL_LOADMOD_DENY
        { "PERL_LOADMOD_DENY", 17, PERL_LOADMOD_DENY },
#endif
#ifdef PERL_LOADMOD_NOIMPORT
        { "PERL_LOADMOD_NOIMPORT", 21, PERL_LOADMOD_NOIMPORT },
#endif
#ifdef PERL_LOADMOD_IMPORT_OPS
        { "PERL_LOADMOD_IMPORT_OPS", 23, PERL_LOADMOD_IMPORT_OPS },
#endif
#ifdef G_WANT
        { "G_WANT", 6, G_WANT },
#endif
        { "fallback_amg", 12, fallback_amg },
        { "to_sv_amg", 9, to_sv_amg },
        { "to_av_amg", 9, to_av_amg },
        { "to_hv_amg", 9, to_hv_amg },
        { "to_gv_amg", 9, to_gv_amg },
        { "to_cv_amg", 9, to_cv_amg },
        { "inc_amg", 7, inc_amg },
        { "dec_amg", 7, dec_amg },
        { "bool__amg", 9, bool__amg },
        { "numer_amg", 9, numer_amg },
        { "string_amg", 10, string_amg },
        { "not_amg", 7, not_amg },
        { "copy_amg", 8, copy_amg },
        { "abs_amg", 7, abs_amg },
        { "neg_amg", 7, neg_amg },
        { "iter_amg", 8, iter_amg },
        { "int_amg", 7, int_amg },
        { "lt_amg", 6, lt_amg },
        { "le_amg", 6, le_amg },
        { "gt_amg", 6, gt_amg },
        { "ge_amg", 6, ge_amg },
        { "eq_amg", 6, eq_amg },
        { "ne_amg", 6, ne_amg },
        { "slt_amg", 7, slt_amg },
        { "sle_amg", 7, sle_amg },
        { "sgt_amg", 7, sgt_amg },
        { "sge_amg", 7, sge_amg },
        { "seq_amg", 7, seq_amg },
        { "sne_amg", 7, sne_amg },
        { "nomethod_amg", 12, nomethod_amg },
        { "add_amg", 7, add_amg },
        { "add_ass_amg", 11, add_ass_amg },
        { "subtr_amg", 9, subtr_amg },
        { "subtr_ass_amg", 13, subtr_ass_amg },
        { "mult_amg", 8, mult_amg },
        { "mult_ass_amg", 12, mult_ass_amg },
        { "div_amg", 7, div_amg },
        { "div_ass_amg", 11, div_ass_amg },
        { "modulo_amg", 10, modulo_amg },
        { "modulo_ass_amg", 14, modulo_ass_amg },
        { "pow_amg", 7, pow_amg },
        { "pow_ass_amg", 11, pow_ass_amg },
        { "lshift_amg", 10, lshift_amg },
        { "lshift_ass_amg", 14, lshift_ass_amg },
        { "rshift_amg", 10, rshift_amg },
        { "rshift_ass_amg", 14, rshift_ass_amg },
        { "band_amg", 8, band_amg },
        { "band_ass_amg", 12, band_ass_amg },
        { "sband_amg", 9, sband_amg },
        { "sband_ass_amg", 13, sband_ass_amg },
        { "bor_amg", 7, bor_amg },
        { "bor_ass_amg", 11, bor_ass_amg },
        { "sbor_amg", 8, sbor_amg },
        { "sbor_ass_amg", 12, sbor_ass_amg },
        { "bxor_amg", 8, bxor_amg },
        { "bxor_ass_amg", 12, bxor_ass_amg },
        { "sbxor_amg", 9, sbxor_amg },
        { "sbxor_ass_amg", 13, sbxor_ass_amg },
        { "ncmp_amg", 8, ncmp_amg },
        { "scmp_amg", 8, scmp_amg },
        { "compl_amg", 9, compl_amg },
        { "scompl_amg", 10, scompl_amg },
        { "atan2_amg", 9, atan2_amg },
        { "cos_amg", 7, cos_amg },
        { "sin_amg", 7, sin_amg },
        { "exp_amg", 7, exp_amg },
        { "log_amg", 7, log_amg },
        { "sqrt_amg", 8, sqrt_amg },
        { "repeat_amg", 10, repeat_amg },
        { "repeat_ass_amg", 14, repeat_ass_amg },
        { "concat_amg", 10, concat_amg },
        { "concat_ass_amg", 14, concat_ass_amg },
        { "smart_amg", 9, smart_amg },
        { "ftest_amg", 9, ftest_amg },
        { "regexp_amg", 10, regexp_amg },
#ifndef G_WANT
        /* This is the default value: */
        { "G_WANT", 6, G_ARRAY|G_VOID },
#endif
        { NULL, 0, 0 } };
	const struct iv_s *value_for_iv = values_for_iv;
        while (value_for_iv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_iv->name,
				value_for_iv->namelen, newSViv(value_for_iv->value));
            ++value_for_iv;
	}
	if (C_ARRAY_LENGTH(values_for_notfound) > 1) {
#ifndef SYMBIAN
	    HV *const constant_missing = get_missing_hash(aTHX);
#endif
	    const struct notfound_s *value_for_notfound = values_for_notfound;
	    do {

		/* Need to add prototypes, else parsing will vary by platform.  */
		HE *he = (HE*) hv_common_key_len(symbol_table,
						 value_for_notfound->name,
						 value_for_notfound->namelen,
						 HV_FETCH_LVALUE, NULL, 0);
		SV *sv;
#ifndef SYMBIAN
		HEK *hek;
#endif
		if (!he) {
		    croak("Couldn't add key '%s' to %%XS::APItest::",
			  value_for_notfound->name);
		}
		sv = HeVAL(he);
		if (!SvOK(sv) && SvTYPE(sv) != SVt_PVGV) {
		    /* Nothing was here before, so mark a prototype of ""  */
		    sv_setpvn(sv, "", 0);
		} else if (SvPOK(sv) && SvCUR(sv) == 0) {
		    /* There is already a prototype of "" - do nothing  */
		} else {
		    /* Someone has been here before us - have to make a real
		       typeglob.  */
		    /* It turns out to be incredibly hard to deal with all the
		       corner cases of sub foo (); and reporting errors correctly,
		       so lets cheat a bit.  Start with a constant subroutine  */
		    CV *cv = newCONSTSUB(symbol_table,
					 value_for_notfound->name,
					 &PL_sv_yes);
		    /* and then turn it into a non constant declaration only.  */
		    SvREFCNT_dec(CvXSUBANY(cv).any_ptr);
		    CvCONST_off(cv);
		    CvXSUB(cv) = NULL;
		    CvXSUBANY(cv).any_ptr = NULL;
		}
#ifndef SYMBIAN
		hek = HeKEY_hek(he);
		if (!hv_common(constant_missing, NULL, HEK_KEY(hek),
 			       HEK_LEN(hek), HEK_FLAGS(hek), HV_FETCH_ISSTORE,
			       &PL_sv_yes, HEK_HASH(hek)))
		    croak("Couldn't add key '%s' to missing_hash",
			  value_for_notfound->name);
#endif
	    } while ((++value_for_notfound)->name);
	}
    /* As we've been creating subroutines, we better invalidate any cached
       methods  */
    mro_method_changed_in(symbol_table);
  }

#line 1606 "APItest.xs"
    newXS("XS::APItest::XSUB::XS_VERSION_undef", XS_XS__APItest__XSUB_XS_VERSION_undef, __FILE__);
    newXS("XS::APItest::XSUB::XS_VERSION_empty", XS_XS__APItest__XSUB_XS_VERSION_empty, __FILE__);
    newXS("XS::APItest::XSUB::XS_APIVERSION_invalid", XS_XS__APItest__XSUB_XS_APIVERSION_invalid, __FILE__);

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#line 2082 "APItest.xs"
    mymro.resolve = myget_linear_isa;
    mymro.name    = "justisa";
    mymro.length  = 7;
    mymro.kflags  = 0;
    mymro.hash    = 0;
    Perl_mro_register(aTHX_ &mymro);

#line 2204 "APItest.xs"
{
    MY_CXT_INIT;

    MY_CXT.i  = 99;
    MY_CXT.sv = newSVpv("initial",0);

    MY_CXT.bhkav = get_av("XS::APItest::bhkav", GV_ADDMULTI);
    MY_CXT.bhk_record = 0;

    BhkENTRY_set(&bhk_test, bhk_start, blockhook_test_start);
    BhkENTRY_set(&bhk_test, bhk_pre_end, blockhook_test_pre_end);
    BhkENTRY_set(&bhk_test, bhk_post_end, blockhook_test_post_end);
    BhkENTRY_set(&bhk_test, bhk_eval, blockhook_test_eval);
    Perl_blockhook_register(aTHX_ &bhk_test);

    MY_CXT.cscgv = gv_fetchpvs("XS::APItest::COMPILE_SCOPE_CONTAINER",
        GV_ADDMULTI, SVt_PVAV);
    MY_CXT.cscav = GvAV(MY_CXT.cscgv);

    BhkENTRY_set(&bhk_csc, bhk_start, blockhook_csc_start);
    BhkENTRY_set(&bhk_csc, bhk_pre_end, blockhook_csc_pre_end);
    Perl_blockhook_register(aTHX_ &bhk_csc);

    MY_CXT.peep_recorder = newAV();
    MY_CXT.rpeep_recorder = newAV();

    MY_CXT.orig_peep = PL_peepp;
    MY_CXT.orig_rpeep = PL_rpeepp;
    PL_peepp = my_peep;
    PL_rpeepp = my_rpeep;
}

#if XSubPPtmpAAAC
#endif
#line 3966 "APItest.xs"
	{
	HV* stash;
	SV** meth = NULL;
	CV* cv;
	stash = gv_stashpv("XS::APItest::TempLv", 0);
	if (stash)
	    meth = hv_fetchs(stash, "make_temp_mg_lv", 0);
	if (!meth)
	    croak("lost method 'make_temp_mg_lv'");
	cv = GvCV(*meth);
	CvLVALUE_on(cv);
	}

#line 3980 "APItest.xs"
{
    hintkey_rpn_sv = newSVpvs_share("XS::APItest/rpn");
    hintkey_calcrpn_sv = newSVpvs_share("XS::APItest/calcrpn");
    hintkey_stufftest_sv = newSVpvs_share("XS::APItest/stufftest");
    hintkey_swaptwostmts_sv = newSVpvs_share("XS::APItest/swaptwostmts");
    hintkey_looprest_sv = newSVpvs_share("XS::APItest/looprest");
    hintkey_scopelessblock_sv = newSVpvs_share("XS::APItest/scopelessblock");
    hintkey_stmtasexpr_sv = newSVpvs_share("XS::APItest/stmtasexpr");
    hintkey_stmtsasexpr_sv = newSVpvs_share("XS::APItest/stmtsasexpr");
    hintkey_loopblock_sv = newSVpvs_share("XS::APItest/loopblock");
    hintkey_blockasexpr_sv = newSVpvs_share("XS::APItest/blockasexpr");
    hintkey_swaplabel_sv = newSVpvs_share("XS::APItest/swaplabel");
    hintkey_labelconst_sv = newSVpvs_share("XS::APItest/labelconst");
    hintkey_arrayfullexpr_sv = newSVpvs_share("XS::APItest/arrayfullexpr");
    hintkey_arraylistexpr_sv = newSVpvs_share("XS::APItest/arraylistexpr");
    hintkey_arraytermexpr_sv = newSVpvs_share("XS::APItest/arraytermexpr");
    hintkey_arrayarithexpr_sv = newSVpvs_share("XS::APItest/arrayarithexpr");
    hintkey_arrayexprflags_sv = newSVpvs_share("XS::APItest/arrayexprflags");
    hintkey_DEFSV_sv = newSVpvs_share("XS::APItest/DEFSV");
    hintkey_with_vars_sv = newSVpvs_share("XS::APItest/with_vars");
    hintkey_join_with_space_sv = newSVpvs_share("XS::APItest/join_with_space");
    wrap_keyword_plugin(my_keyword_plugin, &next_keyword_plugin);
}

#line 4012 "APItest.xs"
{
    CV *estcv = get_cv("XS::APItest::establish_cleanup", 0);
    cv_set_call_checker(estcv, THX_ck_entersub_establish_cleanup, (SV*)estcv);
}

#line 4030 "APItest.xs"
{
    CV *asscv = get_cv("XS::APItest::postinc", 0);
    cv_set_call_checker(asscv, THX_ck_entersub_postinc, (SV*)asscv);
}

#line 4079 "APItest.xs"
{
    CV *pscv = get_cv("XS::APItest::pad_scalar", 0);
    cv_set_call_checker(pscv, THX_ck_entersub_pad_scalar, (SV*)pscv);
}

#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#line 13885 "APItest.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

