/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.40 from the
 * contents of Typemap.xs. Do not edit this file, edit Typemap.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Typemap.xs"
/*
   XS code to test the typemap entries

   Copyright (C) 2001 Tim Jenness.
   All Rights Reserved

*/

#define PERL_NO_GET_CONTEXT

#include "EXTERN.h"   /* std perl include */
#include "perl.h"     /* std perl include */
#include "XSUB.h"     /* XSUB include */

/* Prototypes for external functions */
FILE * xsfopen( const char * );
int xsfclose( FILE * );
int xsfprintf( FILE *, const char *);

/* Type definitions required for the XS typemaps */
typedef SV * SVREF; /* T_SVREF */
typedef int SysRet; /* T_SYSRET */
typedef int Int;    /* T_INT */
typedef int intRef; /* T_PTRREF */
typedef int intObj; /* T_PTROBJ */
typedef int intRefIv; /* T_REF_IV_PTR */
typedef int intArray; /* T_ARRAY */
typedef int intTINT; /* T_INT */
typedef int intTLONG; /* T_LONG */
typedef short shortOPQ;   /* T_OPAQUE */
typedef int intOpq;   /* T_OPAQUEPTR */
typedef unsigned intUnsigned; /* T_U_INT */
typedef PerlIO * inputfh; /* T_IN */
typedef PerlIO * outputfh; /* T_OUT */

/* A structure to test T_OPAQUEPTR and T_PACKED */
struct t_opaqueptr {
  int a;
  int b;
  double c;
};

typedef struct t_opaqueptr astruct;
typedef struct t_opaqueptr anotherstruct;

/* Some static memory for the tests */
static I32 xst_anint;
static intRef xst_anintref;
static intObj xst_anintobj;
static intRefIv xst_anintrefiv;
static intOpq xst_anintopq;

/* A different type to refer to for testing the different
 * AV*, HV*, etc typemaps */
typedef AV AV_FIXED;
typedef HV HV_FIXED;
typedef CV CV_FIXED;
typedef SVREF SVREF_FIXED;

/* Helper functions */

/* T_ARRAY - allocate some memory */
intArray * intArrayPtr( int nelem ) {
    intArray * array;
    Newx(array, nelem, intArray);
    return array;
}

/* test T_PACKED */
STATIC void
XS_pack_anotherstructPtr(SV *out, anotherstruct *in)
{
    dTHX;
    HV *hash = newHV();
    if (NULL == hv_stores(hash, "a", newSViv(in->a)))
      croak("Failed to store data in hash");
    if (NULL == hv_stores(hash, "b", newSViv(in->b)))
      croak("Failed to store data in hash");
    if (NULL == hv_stores(hash, "c", newSVnv(in->c)))
      croak("Failed to store data in hash");
    sv_setsv(out, sv_2mortal(newRV_noinc((SV*)hash)));
}

STATIC anotherstruct *
XS_unpack_anotherstructPtr(SV *in)
{
    dTHX; /* rats, this is expensive */
    /* this is similar to T_HVREF since we chose to use a hash */
    HV *inhash;
    SV **elem;
    anotherstruct *out;
    SV *const tmp = in;
    SvGETMAGIC(tmp);
    if (SvROK(tmp) && SvTYPE(SvRV(tmp)) == SVt_PVHV)
       inhash = (HV*)SvRV(tmp);
    else
        Perl_croak(aTHX_ "Argument is not a HASH reference");

    /* FIXME dunno if supposed to use perl mallocs here */
    Newxz(out, 1, anotherstruct);

    elem = hv_fetchs(inhash, "a", 0);
    if (elem == NULL)
      Perl_croak(aTHX_ "Shouldn't happen: hv_fetchs returns NULL");
    out->a = SvIV(*elem);

    elem = hv_fetchs(inhash, "b", 0);
    if (elem == NULL)
      Perl_croak(aTHX_ "Shouldn't happen: hv_fetchs returns NULL");
    out->b = SvIV(*elem);

    elem = hv_fetchs(inhash, "c", 0);
    if (elem == NULL)
      Perl_croak(aTHX_ "Shouldn't happen: hv_fetchs returns NULL");
    out->c = SvNV(*elem);

    return out;
}

/* test T_PACKEDARRAY */
STATIC void
XS_pack_anotherstructPtrPtr(SV *out, anotherstruct **in, UV cnt)
{
    dTHX;
    UV i;
    AV *ary = newAV();
    for (i = 0; i < cnt; ++i) {
        HV *hash = newHV();
        if (NULL == hv_stores(hash, "a", newSViv(in[i]->a)))
          croak("Failed to store data in hash");
        if (NULL == hv_stores(hash, "b", newSViv(in[i]->b)))
          croak("Failed to store data in hash");
        if (NULL == hv_stores(hash, "c", newSVnv(in[i]->c)))
          croak("Failed to store data in hash");
        av_push(ary, newRV_noinc((SV*)hash));
    }
    sv_setsv(out, sv_2mortal(newRV_noinc((SV*)ary)));
}

STATIC anotherstruct **
XS_unpack_anotherstructPtrPtr(SV *in)
{
    dTHX; /* rats, this is expensive */
    /* this is similar to T_HVREF since we chose to use a hash */
    HV *inhash;
    AV *inary;
    SV **elem;
    anotherstruct **out;
    UV nitems, i;
    SV *tmp;

    /* safely deref the input array ref */
    tmp = in;
    SvGETMAGIC(tmp);
    if (SvROK(tmp) && SvTYPE(SvRV(tmp)) == SVt_PVAV)
        inary = (AV*)SvRV(tmp);
    else
        Perl_croak(aTHX_ "Argument is not an ARRAY reference");

    nitems = av_tindex(inary) + 1;

    /* FIXME dunno if supposed to use perl mallocs here */
    /* N+1 elements so we know the last one is NULL */
    Newxz(out, nitems+1, anotherstruct*);

    /* WARNING: in real code, we'd have to Safefree() on exception, but
     *          since we're testing perl, if we croak() here, stuff is
     *          rotten anyway! */
    for (i = 0; i < nitems; ++i) {
        Newxz(out[i], 1, anotherstruct);
        elem = av_fetch(inary, i, 0);
        if (elem == NULL)
            Perl_croak(aTHX_ "Shouldn't happen: av_fetch returns NULL");
        tmp = *elem;
        SvGETMAGIC(tmp);
        if (SvROK(tmp) && SvTYPE(SvRV(tmp)) == SVt_PVHV)
            inhash = (HV*)SvRV(tmp);
        else
            Perl_croak(aTHX_ "Array element %" UVuf
                             " is not a HASH reference", i);

        elem = hv_fetchs(inhash, "a", 0);
        if (elem == NULL)
            Perl_croak(aTHX_ "Shouldn't happen: hv_fetchs returns NULL");
        out[i]->a = SvIV(*elem);

        elem = hv_fetchs(inhash, "b", 0);
        if (elem == NULL)
            Perl_croak(aTHX_ "Shouldn't happen: hv_fetchs returns NULL");
        out[i]->b = SvIV(*elem);

        elem = hv_fetchs(inhash, "c", 0);
        if (elem == NULL)
            Perl_croak(aTHX_ "Shouldn't happen: hv_fetchs returns NULL");
        out[i]->c = SvNV(*elem);
    }

    return out;
}

/* no special meaning as far as typemaps are concerned,
 * just for convenience */
void
XS_release_anotherstructPtrPtr(anotherstruct **in)
{
    unsigned int i;
    for (i = 0; in[i] != NULL; i++)
        Safefree(in[i]);
    Safefree(in);
}


#line 223 "Typemap.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 367 "Typemap.c"

XS_EUPXS(XS_XS__Typemap_T_SV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_SV)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
	SV *	RETVAL;
#line 259 "Typemap.xs"
  /* create a new sv for return that is a copy of the input
     do not simply copy the pointer since the SV will be marked
     mortal by the INPUT typemap when it is pushed back onto the stack */
  RETVAL = sv_mortalcopy( sv );
  /* increment the refcount since the default INPUT typemap mortalizes
     by default and we don't want to decrement the ref count twice
     by mistake */
  SvREFCNT_inc(RETVAL);
#line 388 "Typemap.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_SVREF); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_SVREF)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "svref");
    {
	SVREF	svref;
	SVREF	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    svref = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::Typemap::T_SVREF",
				"svref");
		}
	} STMT_END
;
#line 277 "Typemap.xs"
  RETVAL = svref;
#line 421 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_SVREF_REFCOUNT_FIXED); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_SVREF_REFCOUNT_FIXED)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "svref");
    {
	SVREF_FIXED	svref;
	SVREF_FIXED	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    svref = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::Typemap::T_SVREF_REFCOUNT_FIXED",
				"svref");
		}
	} STMT_END
;
#line 288 "Typemap.xs"
  SvREFCNT_inc(svref);
  RETVAL = svref;
#line 459 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV_noinc((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_AVREF); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_AVREF)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "av");
    {
	AV *	av;
	AV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    av = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				"XS::Typemap::T_AVREF",
				"av");
		}
	} STMT_END
;
#line 300 "Typemap.xs"
  RETVAL = av;
#line 496 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_AVREF_REFCOUNT_FIXED); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_AVREF_REFCOUNT_FIXED)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "av");
    {
	AV_FIXED *	av;
	AV_FIXED *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    av = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				"XS::Typemap::T_AVREF_REFCOUNT_FIXED",
				"av");
		}
	} STMT_END
;
#line 311 "Typemap.xs"
  SvREFCNT_inc(av);
  RETVAL = av;
#line 534 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV_noinc((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_HVREF); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_HVREF)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	HV *	hv;
	HV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::Typemap::T_HVREF",
				"hv");
		}
	} STMT_END
;
#line 323 "Typemap.xs"
  RETVAL = hv;
#line 571 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_HVREF_REFCOUNT_FIXED); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_HVREF_REFCOUNT_FIXED)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	HV_FIXED *	hv;
	HV_FIXED *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::Typemap::T_HVREF_REFCOUNT_FIXED",
				"hv");
		}
	} STMT_END
;
#line 334 "Typemap.xs"
  SvREFCNT_inc(hv);
  RETVAL = hv;
#line 609 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV_noinc((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_CVREF); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_CVREF)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV *	cv;
	CV *	RETVAL;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::Typemap::T_CVREF",
				"cv");
		}
	} STMT_END
;
#line 346 "Typemap.xs"
  RETVAL = cv;
#line 646 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_CVREF_REFCOUNT_FIXED); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_CVREF_REFCOUNT_FIXED)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV_FIXED *	cv;
	CV_FIXED *	RETVAL;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::Typemap::T_CVREF_REFCOUNT_FIXED",
				"cv");
		}
	} STMT_END
;
#line 357 "Typemap.xs"
  SvREFCNT_inc(cv);
  RETVAL = cv;
#line 684 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV_noinc((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_SYSRET_pass); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_SYSRET_pass)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SysRet	RETVAL;
#line 370 "Typemap.xs"
  RETVAL = 0;
#line 706 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_SYSRET_fail); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_SYSRET_fail)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SysRet	RETVAL;
#line 379 "Typemap.xs"
  RETVAL = -1;
#line 733 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_UV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_UV)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "uv");
    {
	unsigned int	uv = (unsigned int)SvUV(ST(0))
;
	unsigned int	RETVAL;
	dXSTARG;
#line 389 "Typemap.xs"
  RETVAL = uv;
#line 763 "Typemap.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_IV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_IV)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "iv");
    {
	long	iv = (long)SvIV(ST(0))
;
	long	RETVAL;
	dXSTARG;
#line 400 "Typemap.xs"
  RETVAL = iv;
#line 783 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_INT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_INT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "i");
    {
	intTINT	i = (int)SvIV(ST(0))
;
	intTINT	RETVAL;
	dXSTARG;
#line 411 "Typemap.xs"
  RETVAL = i;
#line 803 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_ENUM); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_ENUM)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	svtype	RETVAL;
	dXSTARG;
#line 425 "Typemap.xs"
  RETVAL = SVt_PVHV;
#line 821 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_BOOL); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_BOOL)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	bool	in = (bool)SvTRUE(ST(0))
;
	bool	RETVAL;
#line 436 "Typemap.xs"
  RETVAL = in;
#line 840 "Typemap.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_BOOL_2); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_BOOL_2)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	bool	in = (bool)SvTRUE(ST(0))
;
	bool	RETVAL;
#line 444 "Typemap.xs"
    PERL_UNUSED_VAR(RETVAL);
#line 859 "Typemap.c"
	sv_setsv(ST(0), boolSV(in));
	SvSETMAGIC(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_BOOL_OUT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_BOOL_OUT)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "out, in");
    {
	bool	out = (bool)SvTRUE(ST(0))
;
	bool	in = (bool)SvTRUE(ST(1))
;
#line 453 "Typemap.xs"
 out = in;
#line 880 "Typemap.c"
	sv_setsv(ST(0), boolSV(out));
	SvSETMAGIC(ST(0));
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__Typemap_T_U_INT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_U_INT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "uint");
    {
	intUnsigned	uint = (unsigned int)SvUV(ST(0))
;
	intUnsigned	RETVAL;
	dXSTARG;
#line 463 "Typemap.xs"
  RETVAL = uint;
#line 901 "Typemap.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_SHORT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_SHORT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	short	s = (short)SvIV(ST(0))
;
	short	RETVAL;
	dXSTARG;
#line 474 "Typemap.xs"
  RETVAL = s;
#line 921 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_U_SHORT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_U_SHORT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	U16	in = (unsigned short)SvUV(ST(0))
;
	U16	RETVAL;
	dXSTARG;
#line 485 "Typemap.xs"
  RETVAL = in;
#line 941 "Typemap.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_LONG); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_LONG)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	intTLONG	in = (long)SvIV(ST(0))
;
	intTLONG	RETVAL;
	dXSTARG;
#line 496 "Typemap.xs"
  RETVAL = in;
#line 961 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_U_LONG); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_U_LONG)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	U32	in = (unsigned long)SvUV(ST(0))
;
	U32	RETVAL;
	dXSTARG;
#line 506 "Typemap.xs"
  RETVAL = in;
#line 981 "Typemap.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_CHAR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_CHAR)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	char	in = (char)*SvPV_nolen(ST(0))
;
	char	RETVAL;
	dXSTARG;
#line 517 "Typemap.xs"
  RETVAL = in;
#line 1001 "Typemap.c"
	XSprePUSH; PUSHp((char *)&RETVAL, 1);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_U_CHAR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_U_CHAR)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	unsigned char	in = (unsigned char)SvUV(ST(0))
;
	unsigned char	RETVAL;
	dXSTARG;
#line 528 "Typemap.xs"
  RETVAL = in;
#line 1021 "Typemap.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_FLOAT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_FLOAT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	float	in = (float)SvNV(ST(0))
;
	float	RETVAL;
	dXSTARG;
#line 539 "Typemap.xs"
  RETVAL = in;
#line 1041 "Typemap.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_NV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_NV)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	NV	in = (NV)SvNV(ST(0))
;
	NV	RETVAL;
	dXSTARG;
#line 550 "Typemap.xs"
  RETVAL = in;
#line 1061 "Typemap.c"
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_DOUBLE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_DOUBLE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	double	in = (double)SvNV(ST(0))
;
	double	RETVAL;
	dXSTARG;
#line 561 "Typemap.xs"
  RETVAL = in;
#line 1081 "Typemap.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_PV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PV)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	char *	in = (char *)SvPV_nolen(ST(0))
;
	char *	RETVAL;
	dXSTARG;
#line 572 "Typemap.xs"
  RETVAL = in;
#line 1101 "Typemap.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_PV_null); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PV_null)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	char *	RETVAL;
	dXSTARG;
#line 579 "Typemap.xs"
  RETVAL = NULL;
#line 1119 "Typemap.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_PTR_OUT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PTR_OUT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	int	in = (int)SvIV(ST(0))
;
	void *	RETVAL;
	dXSTARG;
#line 593 "Typemap.xs"
  xst_anint = in;
  RETVAL = &xst_anint;
#line 1140 "Typemap.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_PTR_IN); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PTR_IN)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ptr");
    {
	void *	ptr = INT2PTR(void *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;
#line 604 "Typemap.xs"
  RETVAL = *(int *)ptr;
#line 1160 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_PTRREF_OUT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PTRREF_OUT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	intRef	in = (intRef)SvIV(ST(0))
;
	intRef *	RETVAL;
#line 619 "Typemap.xs"
  xst_anintref = in;
  RETVAL = &xst_anintref;
#line 1180 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, Nullch, (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_PTRREF_IN); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PTRREF_IN)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ptr");
    {
	intRef *	ptr;
	intRef	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ptr = INT2PTR(intRef *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"XS::Typemap::T_PTRREF_IN",
			"ptr")
;
#line 630 "Typemap.xs"
  RETVAL = *ptr;
#line 1214 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_PTROBJ_OUT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PTROBJ_OUT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	intObj	in = (intObj)SvIV(ST(0))
;
	intObj *	RETVAL;
#line 645 "Typemap.xs"
  xst_anintobj = in;
  RETVAL = &xst_anintobj;
#line 1234 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "intObjPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_intObjPtr_T_PTROBJ_IN); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_intObjPtr_T_PTROBJ_IN)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ptr");
    {
	intObj *	ptr;
	intObj	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "intObjPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ptr = INT2PTR(intObj *,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"intObjPtr::T_PTROBJ_IN",
			"ptr", "intObjPtr")
;
#line 658 "Typemap.xs"
  RETVAL = *ptr;
#line 1268 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_REF_IV_PTR_OUT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_REF_IV_PTR_OUT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	intRefIv	in = (intRefIv)SvIV(ST(0))
;
	intRefIv *	RETVAL;
#line 679 "Typemap.xs"
  xst_anintrefiv = in;
  RETVAL = &xst_anintrefiv;
#line 1288 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "intRefIvPtr", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_intRefIvPtr_T_REF_IV_PTR_IN); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_intRefIvPtr_T_REF_IV_PTR_IN)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ptr");
    {
	intRefIv *	ptr;
	intRefIv	RETVAL;
	dXSTARG;

	if (sv_isa(ST(0), "intRefIvPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    ptr = INT2PTR(intRefIv *, tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"intRefIvPtr::T_REF_IV_PTR_IN",
			"ptr", "intRefIvPtr")
;
#line 692 "Typemap.xs"
  RETVAL = *ptr;
#line 1322 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_OPAQUEPTR_IN); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_OPAQUEPTR_IN)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	intOpq	val = (intOpq)SvIV(ST(0))
;
	intOpq *	RETVAL;
	dXSTARG;
#line 717 "Typemap.xs"
  xst_anintopq = val;
  RETVAL = &xst_anintopq;
#line 1343 "Typemap.c"
	XSprePUSH; PUSHp((char *)RETVAL, sizeof(*RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_OPAQUEPTR_OUT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_OPAQUEPTR_OUT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ptr");
    {
	intOpq *	ptr = (intOpq *)SvPV_nolen(ST(0))
;
	intOpq	RETVAL;
	dXSTARG;
#line 726 "Typemap.xs"
  RETVAL = *ptr;
#line 1363 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_OPAQUEPTR_OUT_short); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_OPAQUEPTR_OUT_short)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ptr");
    {
	shortOPQ *	ptr = (shortOPQ *)SvPV_nolen(ST(0))
;
	short	RETVAL;
	dXSTARG;
#line 734 "Typemap.xs"
  RETVAL = *ptr;
#line 1383 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_OPAQUEPTR_IN_struct); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_OPAQUEPTR_IN_struct)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "a, b, c");
    {
	int	a = (int)SvIV(ST(0))
;
	int	b = (int)SvIV(ST(1))
;
	double	c = (double)SvNV(ST(2))
;
#line 745 "Typemap.xs"
  struct t_opaqueptr test;
#line 1405 "Typemap.c"
	astruct *	RETVAL;
	dXSTARG;
#line 747 "Typemap.xs"
  test.a = a;
  test.b = b;
  test.c = c;
  RETVAL = &test;
#line 1413 "Typemap.c"
	XSprePUSH; PUSHp((char *)RETVAL, sizeof(*RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_OPAQUEPTR_OUT_struct); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_OPAQUEPTR_OUT_struct)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "test");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	astruct *	test = (astruct *)SvPV_nolen(ST(0))
;
#line 758 "Typemap.xs"
  XPUSHs(sv_2mortal(newSViv(test->a)));
  XPUSHs(sv_2mortal(newSViv(test->b)));
  XPUSHs(sv_2mortal(newSVnv(test->c)));
#line 1435 "Typemap.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__Typemap_T_OPAQUE_IN); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_OPAQUE_IN)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	int	val = (int)SvIV(ST(0))
;
	shortOPQ	RETVAL;
	dXSTARG;
#line 769 "Typemap.xs"
  RETVAL = (shortOPQ)val;
#line 1455 "Typemap.c"
	XSprePUSH; PUSHp((char *)&RETVAL, sizeof(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_OPAQUE_OUT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_OPAQUE_OUT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	shortOPQ	val = *(shortOPQ *)SvPV_nolen(ST(0))
;
	IV	RETVAL;
	dXSTARG;
#line 777 "Typemap.xs"
  RETVAL = (IV)val;
#line 1475 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_OPAQUE_array); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_OPAQUE_array)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "a, b, c");
    {
	int	a = (int)SvIV(ST(0))
;
	int	b = (int)SvIV(ST(1))
;
	int	c = (int)SvIV(ST(2))
;
#line 787 "Typemap.xs"
  int array[3];
#line 1497 "Typemap.c"
	int *	RETVAL;
#line 789 "Typemap.xs"
  array[0] = a;
  array[1] = b;
  array[2] = c;
  RETVAL = array;
#line 1504 "Typemap.c"
	ST(0) = sv_newmortal();
	sv_setpvn(ST(0), (char *)RETVAL, 3 * sizeof(int));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_PACKED_in); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PACKED_in)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	anotherstruct *	in = XS_unpack_anotherstructPtr(ST(0))
;
#line 803 "Typemap.xs"
  mXPUSHi(in->a);
  mXPUSHi(in->b);
  mXPUSHn(in->c);
  Safefree(in);
  XSRETURN(3);
#line 1529 "Typemap.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__Typemap_T_PACKED_out); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PACKED_out)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "a, b, c");
    {
	int	a = (int)SvIV(ST(0))
;
	int	b = (int)SvIV(ST(1))
;
	double	c = (double)SvNV(ST(2))
;
	anotherstruct *	RETVAL;
#line 815 "Typemap.xs"
  Newxz(RETVAL, 1, anotherstruct);
  RETVAL->a = a;
  RETVAL->b = b;
  RETVAL->c = c;
#line 1555 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    XS_pack_anotherstructPtr(RETVALSV, RETVAL);
	    ST(0) = RETVALSV;
	}
#line 821 "Typemap.xs"
  Safefree(RETVAL);
#line 1564 "Typemap.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_PACKEDARRAY_in); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PACKEDARRAY_in)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	anotherstruct **	in = XS_unpack_anotherstructPtrPtr(ST(0))
;
#line 829 "Typemap.xs"
  unsigned int i = 0;
#line 1583 "Typemap.c"
#line 831 "Typemap.xs"
  while (in[i] != NULL) {
    mXPUSHi(in[i]->a);
    mXPUSHi(in[i]->b);
    mXPUSHn(in[i]->c);
    ++i;
  }
  XS_release_anotherstructPtrPtr(in);
  XSRETURN(3*i);
#line 1593 "Typemap.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__Typemap_T_PACKEDARRAY_out); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_PACKEDARRAY_out)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
#line 843 "Typemap.xs"
  unsigned int i, nstructs, count_anotherstructPtrPtr;
#line 1609 "Typemap.c"
	anotherstruct **	RETVAL;
#line 845 "Typemap.xs"
  if ((items % 3) != 0)
    croak("Need nitems divisible by 3");
  nstructs = (unsigned int)(items / 3);
  count_anotherstructPtrPtr = nstructs;
  Newxz(RETVAL, nstructs+1, anotherstruct *);
  for (i = 0; i < nstructs; ++i) {
    Newxz(RETVAL[i], 1, anotherstruct);
    RETVAL[i]->a = SvIV(ST(3*i));
    RETVAL[i]->b = SvIV(ST(3*i+1));
    RETVAL[i]->c = SvNV(ST(3*i+2));
  }
#line 1623 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    XS_pack_anotherstructPtrPtr(RETVALSV, RETVAL, count_anotherstructPtrPtr);
	    ST(0) = RETVALSV;
	}
#line 858 "Typemap.xs"
  XS_release_anotherstructPtrPtr(RETVAL);
#line 1632 "Typemap.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_ARRAY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_ARRAY)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "dummy, array, ...");
    {
	int	dummy = 0;
	intArray *	array;
#line 888 "Typemap.xs"
  U32 size_RETVAL;
#line 1649 "Typemap.c"
	intArray *	RETVAL;

	U32 ix_array = 1;
	array = intArrayPtr(items -= 1);
	while (items--) {
	    	array[ix_array - 1] = (int)SvIV(ST(ix_array))
;
	    ix_array++;
	}
        /* this is the number of elements in the array */
        ix_array -= 1
;
#line 890 "Typemap.xs"
  dummy += 0; /* Fix -Wall */
  size_RETVAL = ix_array;
  RETVAL = array;
#line 1666 "Typemap.c"
        {
	    U32 ix_RETVAL;
            SSize_t extend_size =
                /* The weird way this is written is because g++ is dumb
                 * enough to warn "comparison is always false" on something
                 * like:
                 *
                 * sizeof(a) > sizeof(b) && a > B_t_MAX
                 *
                 * (where the LH condition is false)
                 */
                (size_RETVAL > (sizeof(size_RETVAL) > sizeof(SSize_t)
                              ? SSize_t_MAX : size_RETVAL))
                ? -1 : (SSize_t)size_RETVAL;
	    EXTEND(SP, extend_size);
	    for (ix_RETVAL = 0; ix_RETVAL < size_RETVAL; ix_RETVAL++) {
		ST(ix_RETVAL) = sv_newmortal();
		sv_setiv(ST(ix_RETVAL), (IV)RETVAL[ix_RETVAL]);
	    }
        }
#line 896 "Typemap.xs"
  Safefree(array);
  XSRETURN(size_RETVAL);
#line 1690 "Typemap.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_STDIO_open); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_STDIO_open)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "file");
    {
	const char *	file = (const char *)SvPV_nolen(ST(0))
;
	FILE *	RETVAL;
#line 906 "Typemap.xs"
  RETVAL = xsfopen( file );
#line 1708 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		PerlIO *fp = PerlIO_importFILE(RETVAL,0);
		gv_init_pvn(gv, gv_stashpvs("XS::Typemap",1),"__ANONIO__",10,0);
		if ( fp && do_open(gv, "+<&", 3, FALSE, 0, 0, fp) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_STDIO_open_ret_in_arg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_STDIO_open_ret_in_arg)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "file, io");
    {
	const char *	file = (const char *)SvPV_nolen(ST(0))
;
	FILE *	io;
#line 915 "Typemap.xs"
  io = xsfopen( file );
#line 1741 "Typemap.c"
	{
	    GV *gv = (GV *)sv_newmortal();
	    PerlIO *fp = PerlIO_importFILE(io,0);
	    gv_init_pvn(gv, gv_stashpvs("XS::Typemap",1),"__ANONIO__",10,0);
	    if ( fp && do_open(gv, "+<&", 3, FALSE, 0, 0, fp) ) {
		SV *rv = newRV_inc((SV*)gv);
		rv = sv_bless(rv, GvSTASH(gv));
		sv_setsv(ST(1), rv);
		SvREFCNT_dec_NN(rv);
	    }
	    else
		sv_setsv(ST(1), &PL_sv_undef);

	}
	SvSETMAGIC(ST(1));
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__Typemap_T_STDIO_close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_STDIO_close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "f");
    {
	PerlIO *	f = IoIFP(sv_2io(ST(0)))
;
#line 923 "Typemap.xs"
  FILE * stream;
#line 1773 "Typemap.c"
	SysRet	RETVAL;
#line 925 "Typemap.xs"
  /* Get the FILE* */
  stream = PerlIO_findFILE( f );  
  /* Release the FILE* from the PerlIO system so that we do
     not close the file twice */
  PerlIO_releaseFILE(f,stream);
  /* Must release the file before closing it */
  RETVAL = xsfclose( stream );
#line 1783 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if (RETVAL != -1) {
		if (RETVAL == 0)
		    sv_setpvn(RETVALSV, "0 but true", 10);
		else
		    sv_setiv(RETVALSV, (IV)RETVAL);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_STDIO_print); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_STDIO_print)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "stream, string");
    {
	FILE *	stream = PerlIO_findFILE(IoIFP(sv_2io(ST(0))))
;
	const char *	string = (const char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;
#line 940 "Typemap.xs"
  RETVAL = xsfprintf( stream, string );
#line 1815 "Typemap.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_INOUT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_INOUT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	PerlIO *	in = IoIFP(sv_2io(ST(0)))
;
	PerlIO *	RETVAL;
#line 951 "Typemap.xs"
  RETVAL = in; /* silly test but better than nothing */
#line 1834 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		gv_init_pvn(gv, gv_stashpvs("XS::Typemap",1),"__ANONIO__",10,0);
		if ( do_open(gv, "+<&", 3, FALSE, 0, 0, RETVAL) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_IN); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_IN)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	inputfh	in = IoIFP(sv_2io(ST(0)))
;
	inputfh	RETVAL;
#line 961 "Typemap.xs"
  RETVAL = in; /* silly test but better than nothing */
#line 1866 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		gv_init_pvn(gv, gv_stashpvs("XS::Typemap",1),"__ANONIO__",10,0);
		if ( do_open(gv, "<&", 2, FALSE, 0, 0, RETVAL) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__Typemap_T_OUT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__Typemap_T_OUT)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "in");
    {
	outputfh	in = IoOFP(sv_2io(ST(0)))
;
	outputfh	RETVAL;
#line 971 "Typemap.xs"
  RETVAL = in; /* silly test but better than nothing */
#line 1898 "Typemap.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		gv_init_pvn(gv, gv_stashpvs("XS::Typemap",1),"__ANONIO__",10,0);
		if ( do_open(gv, "+>&", 3, FALSE, 0, 0, RETVAL) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_XS__Typemap); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_XS__Typemap)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("XS::Typemap::T_SV", XS_XS__Typemap_T_SV);
        newXS_deffile("XS::Typemap::T_SVREF", XS_XS__Typemap_T_SVREF);
        newXS_deffile("XS::Typemap::T_SVREF_REFCOUNT_FIXED", XS_XS__Typemap_T_SVREF_REFCOUNT_FIXED);
        newXS_deffile("XS::Typemap::T_AVREF", XS_XS__Typemap_T_AVREF);
        newXS_deffile("XS::Typemap::T_AVREF_REFCOUNT_FIXED", XS_XS__Typemap_T_AVREF_REFCOUNT_FIXED);
        newXS_deffile("XS::Typemap::T_HVREF", XS_XS__Typemap_T_HVREF);
        newXS_deffile("XS::Typemap::T_HVREF_REFCOUNT_FIXED", XS_XS__Typemap_T_HVREF_REFCOUNT_FIXED);
        newXS_deffile("XS::Typemap::T_CVREF", XS_XS__Typemap_T_CVREF);
        newXS_deffile("XS::Typemap::T_CVREF_REFCOUNT_FIXED", XS_XS__Typemap_T_CVREF_REFCOUNT_FIXED);
        newXS_deffile("XS::Typemap::T_SYSRET_pass", XS_XS__Typemap_T_SYSRET_pass);
        newXS_deffile("XS::Typemap::T_SYSRET_fail", XS_XS__Typemap_T_SYSRET_fail);
        newXS_deffile("XS::Typemap::T_UV", XS_XS__Typemap_T_UV);
        newXS_deffile("XS::Typemap::T_IV", XS_XS__Typemap_T_IV);
        newXS_deffile("XS::Typemap::T_INT", XS_XS__Typemap_T_INT);
        newXS_deffile("XS::Typemap::T_ENUM", XS_XS__Typemap_T_ENUM);
        newXS_deffile("XS::Typemap::T_BOOL", XS_XS__Typemap_T_BOOL);
        newXS_deffile("XS::Typemap::T_BOOL_2", XS_XS__Typemap_T_BOOL_2);
        newXS_deffile("XS::Typemap::T_BOOL_OUT", XS_XS__Typemap_T_BOOL_OUT);
        newXS_deffile("XS::Typemap::T_U_INT", XS_XS__Typemap_T_U_INT);
        newXS_deffile("XS::Typemap::T_SHORT", XS_XS__Typemap_T_SHORT);
        newXS_deffile("XS::Typemap::T_U_SHORT", XS_XS__Typemap_T_U_SHORT);
        newXS_deffile("XS::Typemap::T_LONG", XS_XS__Typemap_T_LONG);
        newXS_deffile("XS::Typemap::T_U_LONG", XS_XS__Typemap_T_U_LONG);
        newXS_deffile("XS::Typemap::T_CHAR", XS_XS__Typemap_T_CHAR);
        newXS_deffile("XS::Typemap::T_U_CHAR", XS_XS__Typemap_T_U_CHAR);
        newXS_deffile("XS::Typemap::T_FLOAT", XS_XS__Typemap_T_FLOAT);
        newXS_deffile("XS::Typemap::T_NV", XS_XS__Typemap_T_NV);
        newXS_deffile("XS::Typemap::T_DOUBLE", XS_XS__Typemap_T_DOUBLE);
        newXS_deffile("XS::Typemap::T_PV", XS_XS__Typemap_T_PV);
        newXS_deffile("XS::Typemap::T_PV_null", XS_XS__Typemap_T_PV_null);
        newXS_deffile("XS::Typemap::T_PTR_OUT", XS_XS__Typemap_T_PTR_OUT);
        newXS_deffile("XS::Typemap::T_PTR_IN", XS_XS__Typemap_T_PTR_IN);
        newXS_deffile("XS::Typemap::T_PTRREF_OUT", XS_XS__Typemap_T_PTRREF_OUT);
        newXS_deffile("XS::Typemap::T_PTRREF_IN", XS_XS__Typemap_T_PTRREF_IN);
        newXS_deffile("XS::Typemap::T_PTROBJ_OUT", XS_XS__Typemap_T_PTROBJ_OUT);
        newXS_deffile("intObjPtr::T_PTROBJ_IN", XS_intObjPtr_T_PTROBJ_IN);
        newXS_deffile("XS::Typemap::T_REF_IV_PTR_OUT", XS_XS__Typemap_T_REF_IV_PTR_OUT);
        newXS_deffile("intRefIvPtr::T_REF_IV_PTR_IN", XS_intRefIvPtr_T_REF_IV_PTR_IN);
        newXS_deffile("XS::Typemap::T_OPAQUEPTR_IN", XS_XS__Typemap_T_OPAQUEPTR_IN);
        newXS_deffile("XS::Typemap::T_OPAQUEPTR_OUT", XS_XS__Typemap_T_OPAQUEPTR_OUT);
        newXS_deffile("XS::Typemap::T_OPAQUEPTR_OUT_short", XS_XS__Typemap_T_OPAQUEPTR_OUT_short);
        newXS_deffile("XS::Typemap::T_OPAQUEPTR_IN_struct", XS_XS__Typemap_T_OPAQUEPTR_IN_struct);
        newXS_deffile("XS::Typemap::T_OPAQUEPTR_OUT_struct", XS_XS__Typemap_T_OPAQUEPTR_OUT_struct);
        newXS_deffile("XS::Typemap::T_OPAQUE_IN", XS_XS__Typemap_T_OPAQUE_IN);
        newXS_deffile("XS::Typemap::T_OPAQUE_OUT", XS_XS__Typemap_T_OPAQUE_OUT);
        newXS_deffile("XS::Typemap::T_OPAQUE_array", XS_XS__Typemap_T_OPAQUE_array);
        newXS_deffile("XS::Typemap::T_PACKED_in", XS_XS__Typemap_T_PACKED_in);
        newXS_deffile("XS::Typemap::T_PACKED_out", XS_XS__Typemap_T_PACKED_out);
        newXS_deffile("XS::Typemap::T_PACKEDARRAY_in", XS_XS__Typemap_T_PACKEDARRAY_in);
        newXS_deffile("XS::Typemap::T_PACKEDARRAY_out", XS_XS__Typemap_T_PACKEDARRAY_out);
        newXS_deffile("XS::Typemap::T_ARRAY", XS_XS__Typemap_T_ARRAY);
        newXS_deffile("XS::Typemap::T_STDIO_open", XS_XS__Typemap_T_STDIO_open);
        newXS_deffile("XS::Typemap::T_STDIO_open_ret_in_arg", XS_XS__Typemap_T_STDIO_open_ret_in_arg);
        newXS_deffile("XS::Typemap::T_STDIO_close", XS_XS__Typemap_T_STDIO_close);
        newXS_deffile("XS::Typemap::T_STDIO_print", XS_XS__Typemap_T_STDIO_print);
        newXS_deffile("XS::Typemap::T_INOUT", XS_XS__Typemap_T_INOUT);
        newXS_deffile("XS::Typemap::T_IN", XS_XS__Typemap_T_IN);
        newXS_deffile("XS::Typemap::T_OUT", XS_XS__Typemap_T_OUT);
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

