# Config Sample

Here after a simple configuration sample.

```json
{
    "$schema": "http://iot.bzh/download/public/schema/json/ctl-schema.json",
    "metadata": {
        "uid": "sample-audio-control",
        "api": "audio-control",
        "info": "Provide Default Audio Policy for Multimedia, Navigation and Emergency",
        "version": "1.0",
        "require": ["intel-hda", "jabra-usb", "scarlett-usb"]
    },
    "plugins": {
        "uid" : "MyPlug",
        "spath":"./plugins/pluginname:../conf.d/project/lua.d",
        "libs": ["ctl-audio-plugin-sample.ctlso", "softmixer-simple.lua"],
        "lua": ["Lua2cHelloWorld1", "Lua2cHelloWorld2"]
    },
    "onload": [{
        "uid": "onload-sample-cb",
        "info": "Call control sharelib install entrypoint",
        "action": "lua://MyPlug#SamplePolicyInit",
        "args": {
            "arg1": "first_arg",
            "nextarg": "second arg value"
            }
        }, {
        "uid": "onload-sample-api",
        "info": "Assert AlsaCore Presence",
        "action": "api://alsacore#ping",
        "args": {
            "test": "onload-sample-api"
            }
        }
    ],
    "controls":[{
            "uid": "multimedia",
            "privileges": "urn:AGL:permission:audio:public:mutimedia",
            "action": "lua://MyPlug#Audio_Set_Multimedia"
        }, {
            "uid": "navigation",
            "privileges": "urn:AGL:permission:audio:public:navigation",
            "action": "lua://MyPlug#Audio_Set_Navigation"
        }, {
            "uid": "emergency",
            "privileges": "urn:AGL:permission:audio:public:emergency",
            "action": "lua://MyPlug#Audio_Set_Emergency"
        }, {
            "uid": "multimedia-control-cb",
            "info": "Call Sharelib Sample Callback",
            "action": "plugin://MyPlug#sampleControlNavigation",
            "args": {
                "arg1": "snoopy",
                "arg2": "toto"
            }
        }, {
            "uid": "navigation-control-ucm",
            "action": "api://alsacore#ping",
            "args": {
                "test": "navigation"
            }
         }, {
            "uid": "navigation-control-lua",
            "info": "Call Lua Script to set Navigation",
            "action": "lua://MyPlug#Audio_Set_Navigation"
        }
    ],
    "events":[{
            "uid": "speed-action-1",
            "action": "plugin://MyPlug#Blink-when-over-130",
            "args": {
                "speed": 130,
                "blink-speed": 1000
            }
        }, {
            "uid": "Adjust-Volume",
            "action": "lua://MyPlug#Adjust_Volume_To_Speed"
        }, {
            "uid": "Display-Rear-Camera",
            "action": "plugin://MyPlug#Display-Rear-Camera"
        }, {
            "uid": "Prevent-Phone-Call",
            "action": "api://phone#status",
            "args": {
                "call-accepted": "false"
            }
        }, {
            "uid": "Authorize-Video",
            "action": "api://video#status",
            "args": {
                "tv-accepted": "true"
            }
        }
    ]
}
```