/* Generated by re2c */

#include <stddef.h> /* size_t */
#include <stdio.h>
#include <stdlib.h> /* malloc, free */
#include <string.h> /* memcpy */

static void *read_file
    ( const char *fname
    , size_t unit
    , size_t padding
    , size_t *pfsize
    )
{
    void *buffer = NULL;
    size_t fsize = 0;

    /* open file */
    FILE *f = fopen(fname, "rb");
    if(f == NULL) {
        goto error;
    }

    /* get file size */
    fseek(f, 0, SEEK_END);
    fsize = (size_t) ftell(f) / unit;
    fseek(f, 0, SEEK_SET);

    /* allocate memory for file and padding */
    buffer = malloc(unit * (fsize + padding));
    if (buffer == NULL) {
        goto error;
    }

    /* read the whole file in memory */
    if (fread(buffer, unit, fsize, f) != fsize) {
        goto error;
    }

    fclose(f);
    *pfsize = fsize;
    return buffer;

error:
    fprintf(stderr, "error: cannot read file '%s'\n", fname);
    free(buffer);
    if (f != NULL) {
        fclose(f);
    }
    return NULL;
}

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line626
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line626: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line626: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line626(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line626: not enough keys\n");
    return 1;
}

int lex_line626()
{
    const size_t padding = 6; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("input_custom_mjson.--skeleton--input(custom).c.line626.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("input_custom_mjson.--skeleton--input(custom).c.line626.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;
        unsigned int yyaccept = 0;

        if (YYLESSTHAN (6)) YYFILL(6);
        yych = YYPEEK ();
        switch (yych) {
        case 0x00:    goto yy2;
        case '\t':
        case '\n':
        case '\r':
        case ' ':    goto yy6;
        case '"':    goto yy9;
        case '+':
        case '-':    goto yy10;
        case ',':    goto yy11;
        case '.':    goto yy13;
        case '/':    goto yy14;
        case '0':    goto yy15;
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy17;
        case ':':    goto yy19;
        case '=':    goto yy21;
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy23;
        case '[':    goto yy26;
        case ']':    goto yy28;
        case 'f':    goto yy30;
        case 'n':    goto yy31;
        case 't':    goto yy32;
        case '{':    goto yy33;
        case '}':    goto yy35;
        default:    goto yy4;
        }
yy2:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 20);
        continue;
yy4:
        YYSKIP ();
yy5:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 22);
        continue;
yy6:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case '\t':
        case '\n':
        case '\r':
        case ' ':    goto yy6;
        default:    goto yy8;
        }
yy8:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 0);
        continue;
yy9:
        yyaccept = 0;
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych <= 0x00) goto yy5;
        goto yy38;
yy10:
        yyaccept = 0;
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        switch (yych) {
        case '.':    goto yy43;
        case '0':    goto yy44;
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy45;
        default:    goto yy5;
        }
yy11:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 9);
        continue;
yy13:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy47;
        default:    goto yy5;
        }
yy14:
        yyaccept = 0;
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        switch (yych) {
        case '*':    goto yy50;
        case '/':    goto yy52;
        default:    goto yy5;
        }
yy15:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '.':
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'y':
        case 'z':    goto yy55;
        case 'X':
        case 'x':    goto yy63;
        default:    goto yy16;
        }
yy16:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 12);
        continue;
yy17:
        YYSKIP ();
        if (YYLESSTHAN (3)) YYFILL(3);
        yych = YYPEEK ();
        switch (yych) {
        case '.':    goto yy47;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy17;
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy60;
        case 'E':
        case 'e':    goto yy62;
        default:    goto yy16;
        }
yy19:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 7);
        continue;
yy21:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 8);
        continue;
yy23:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy24:
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy23;
        default:    goto yy25;
        }
yy25:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 17);
        continue;
yy26:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 5);
        continue;
yy28:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 6);
        continue;
yy30:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case 'a':    goto yy64;
        default:    goto yy24;
        }
yy31:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case 'u':    goto yy65;
        default:    goto yy24;
        }
yy32:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case 'r':    goto yy66;
        default:    goto yy24;
        }
yy33:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 3);
        continue;
yy35:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 4);
        continue;
yy37:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy38:
        switch (yych) {
        case 0x00:    goto yy39;
        case '"':    goto yy40;
        case '\\':    goto yy42;
        default:    goto yy37;
        }
yy39:
        YYRESTORE ();
        switch (yyaccept) {
        case 0:     goto yy5;
        case 1:     goto yy16;
        case 2:     goto yy49;
        case 3:     goto yy59;
        default:    goto yy93;
        }
yy40:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 18);
        continue;
yy42:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case '"':
        case '/':
        case '\\':
        case 'b':
        case 'f':
        case 'n':
        case 'r':
        case 't':    goto yy67;
        case 'u':    goto yy69;
        default:    goto yy39;
        }
yy43:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy47;
        default:    goto yy39;
        }
yy44:
        yyaccept = 1;
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        switch (yych) {
        case '.':    goto yy47;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy70;
        case 'E':
        case 'e':    goto yy72;
        default:    goto yy16;
        }
yy45:
        yyaccept = 1;
        YYSKIP ();
        YYBACKUP ();
        if (YYLESSTHAN (3)) YYFILL(3);
        yych = YYPEEK ();
        switch (yych) {
        case '.':    goto yy47;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy45;
        case 'E':
        case 'e':    goto yy72;
        default:    goto yy16;
        }
yy47:
        yyaccept = 2;
        YYSKIP ();
        YYBACKUP ();
        if (YYLESSTHAN (3)) YYFILL(3);
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy47;
        case 'E':
        case 'e':    goto yy72;
        default:    goto yy49;
        }
yy49:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 13);
        continue;
yy50:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case 0x00:    goto yy39;
        case '*':    goto yy73;
        default:    goto yy50;
        }
yy52:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case 0x00:    goto yy39;
        case '\n':    goto yy74;
        default:    goto yy52;
        }
yy54:
        YYSKIP ();
        if (YYLESSTHAN (3)) YYFILL(3);
        yych = YYPEEK ();
yy55:
        switch (yych) {
        case '.':    goto yy47;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':    goto yy54;
        case '8':
        case '9':    goto yy57;
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy60;
        case 'E':
        case 'e':    goto yy62;
        default:    goto yy56;
        }
yy56:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 10);
        continue;
yy57:
        YYSKIP ();
        if (YYLESSTHAN (3)) YYFILL(3);
        yych = YYPEEK ();
        switch (yych) {
        case '.':    goto yy47;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy57;
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy60;
        case 'E':
        case 'e':    goto yy62;
        default:    goto yy59;
        }
yy59:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 21);
        continue;
yy60:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy61:
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy60;
        default:    goto yy59;
        }
yy62:
        yyaccept = 3;
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        switch (yych) {
        case '+':
        case '-':    goto yy76;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy77;
        default:    goto yy61;
        }
yy63:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy80;
        default:    goto yy59;
        }
yy64:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case 'l':    goto yy82;
        default:    goto yy24;
        }
yy65:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case 'l':    goto yy83;
        default:    goto yy24;
        }
yy66:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case 'u':    goto yy84;
        default:    goto yy24;
        }
yy67:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case 0x00:    goto yy39;
        case '"':    goto yy85;
        case '\\':    goto yy42;
        default:    goto yy67;
        }
yy69:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':    goto yy87;
        default:    goto yy39;
        }
yy70:
        YYSKIP ();
        if (YYLESSTHAN (3)) YYFILL(3);
        yych = YYPEEK ();
        switch (yych) {
        case '.':    goto yy47;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy70;
        case 'E':
        case 'e':    goto yy72;
        default:    goto yy39;
        }
yy72:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '+':
        case '-':    goto yy76;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy88;
        default:    goto yy39;
        }
yy73:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case 0x00:    goto yy39;
        case '*':    goto yy90;
        case '/':    goto yy92;
        default:    goto yy50;
        }
yy74:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 1);
        continue;
yy76:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy88;
        default:    goto yy39;
        }
yy77:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy77;
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy60;
        default:    goto yy49;
        }
yy79:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy80:
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':    goto yy79;
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy60;
        default:    goto yy81;
        }
yy81:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 11);
        continue;
yy82:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case 's':    goto yy94;
        default:    goto yy24;
        }
yy83:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case 'l':    goto yy95;
        default:    goto yy24;
        }
yy84:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case 'e':    goto yy97;
        default:    goto yy24;
        }
yy85:
        YYSKIP ();
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 19);
        continue;
yy87:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':    goto yy99;
        default:    goto yy39;
        }
yy88:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':    goto yy88;
        default:    goto yy49;
        }
yy90:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case 0x00:    goto yy39;
        case '*':    goto yy90;
        case '/':    goto yy100;
        default:    goto yy50;
        }
yy92:
        YYSKIP ();
yy93:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 2);
        continue;
yy94:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case 'e':    goto yy101;
        default:    goto yy24;
        }
yy95:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy23;
        default:    goto yy96;
        }
yy96:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 16);
        continue;
yy97:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy23;
        default:    goto yy98;
        }
yy98:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 14);
        continue;
yy99:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':    goto yy103;
        default:    goto yy39;
        }
yy100:
        yyaccept = 4;
        YYSKIP ();
        YYBACKUP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case 0x00:    goto yy93;
        case '*':    goto yy73;
        default:    goto yy50;
        }
yy101:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':    goto yy23;
        default:    goto yy102;
        }
yy102:
        status = check_key_count_line626(keys_count, i, 3)
             || action_line626(&i, keys, input, token, &cursor, 15);
        continue;
yy103:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':    goto yy67;
        default:    goto yy39;
        }

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line626: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line626: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line813
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line813: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line813: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line813(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line813: not enough keys\n");
    return 1;
}

int lex_line813()
{
    const size_t padding = 6; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("input_custom_mjson.--skeleton--input(custom).c.line813.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("input_custom_mjson.--skeleton--input(custom).c.line813.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;

        if (YYLESSTHAN (6)) YYFILL(6);
        yych = YYPEEK ();
        switch (yych) {
        case 0x00:    goto yy106;
        case '"':    goto yy111;
        case '\\':    goto yy113;
        default:    goto yy108;
        }
yy106:
        YYSKIP ();
yy107:
        status = check_key_count_line813(keys_count, i, 3)
             || action_line813(&i, keys, input, token, &cursor, 4);
        continue;
yy108:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        switch (yych) {
        case 0x00:
        case '"':
        case '\\':    goto yy110;
        default:    goto yy108;
        }
yy110:
        status = check_key_count_line813(keys_count, i, 3)
             || action_line813(&i, keys, input, token, &cursor, 0);
        continue;
yy111:
        YYSKIP ();
        status = check_key_count_line813(keys_count, i, 3)
             || action_line813(&i, keys, input, token, &cursor, 3);
        continue;
yy113:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        switch (yych) {
        case '"':
        case '/':
        case '\\':
        case 'b':
        case 'f':
        case 'n':
        case 'r':
        case 't':    goto yy114;
        case 'u':    goto yy116;
        default:    goto yy107;
        }
yy114:
        YYSKIP ();
        status = check_key_count_line813(keys_count, i, 3)
             || action_line813(&i, keys, input, token, &cursor, 1);
        continue;
yy116:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':    goto yy118;
        default:    goto yy117;
        }
yy117:
        YYRESTORE ();
        goto yy107;
yy118:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':    goto yy119;
        default:    goto yy117;
        }
yy119:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':    goto yy120;
        default:    goto yy117;
        }
yy120:
        YYSKIP ();
        yych = YYPEEK ();
        switch (yych) {
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':    goto yy121;
        default:    goto yy117;
        }
yy121:
        YYSKIP ();
        status = check_key_count_line813(keys_count, i, 3)
             || action_line813(&i, keys, input, token, &cursor, 2);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line813: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line813: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

int main()
{
    if(lex_line626() != 0) {
        return 1;
    }
    if(lex_line813() != 0) {
        return 1;
    }
    return 0;
}
 !#$%&'()*;<>?@\^`|~		 



  		



  		



  		



  		



  		



  		



  		

!

"  #		$

%

&  '		(

)

*  +		,

-

.  /		0

1

2  3		4

5

6  7		8

9

:  ;		<

=

>  ?		@

A

B  C		D

E

F  G		H

I

J  K		L

M

N  O		P

Q

R  S		T

U

V  W		X

Y

Z  [		\

]

^  _		`

a

b  c		d

e

f  g		h

i

j  k		l

m

n  o		p

q

r  s		t

u

v  w		x

y

z  {		|

}

~  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  	 

 	

 	

 	

 	

 	

 	

 	
!
" #	$
%
& '	(
)
* +	,
-
. /	0
1
2 3	4
5
6 7	8
9
: ;	<
=
> ?	@
A
B C	D
E
F G	H
I
J K	L
M
N O	P
Q
R S	T
U
V W	X
Y
Z [	\
]
^ _	`
a
b c	d
e
f g	h
i
j k	l
m
n o	p
q
r s	t
u
v w	x
y
z {	|
}
~ 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 """""""""""""""""		""

""""""

""""""""""""""""""""""""""""""""""""""  ""!!""##""$$""%%""&&""''""((""))""**""++"",,""--""..""//""00""11""22""33""44""55""66""77""88""99""::"";;""<<""=="">>""??""@@""AA""BB""CC""DD""EE""FF""GG""HH""II""JJ""KK""LL""MM""NN""OO""PP""QQ""RR""SS""TT""UU""VV""WW""XX""YY""ZZ""[[""]]""^^""__""``""aa""bb""cc""dd""ee""ff""gg""hh""ii""jj""kk""ll""mm""nn""oo""pp""qq""rr""ss""tt""uu""vv""ww""xx""yy""zz""{{""||""}}""~~""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""		\"\"""

\/\/""\\\\""\b\b""

\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""  \t\t""!!\"\"""##\/\/""$$\\\\""%%\b\b""&&\f\f""''\n\n""((\r\r""))\t\t""**\"\"""++\/\/"",,\\\\""--\b\b""..\f\f""//\n\n""00\r\r""11\t\t""22\"\"""33\/\/""44\\\\""55\b\b""66\f\f""77\n\n""88\r\r""99\t\t""::\"\""";;\/\/""<<\\\\""==\b\b"">>\f\f""??\n\n""@@\r\r""AA\t\t""BB\"\"""CC\/\/""DD\\\\""EE\b\b""FF\f\f""GG\n\n""HH\r\r""II\t\t""JJ\"\"""KK\/\/""LL\\\\""MM\b\b""NN\f\f""OO\n\n""PP\r\r""QQ\t\t""RR\"\"""SS\/\/""TT\\\\""UU\b\b""VV\f\f""WW\n\n""XX\r\r""YY\t\t""ZZ\"\"""[[\/\/""]]\\\\""^^\b\b""__\f\f""``\n\n""aa\r\r""bb\t\t""cc\"\"""dd\/\/""ee\\\\""ff\b\b""gg\f\f""hh\n\n""ii\r\r""jj\t\t""kk\"\"""ll\/\/""mm\\\\""nn\b\b""oo\f\f""pp\n\n""qq\r\r""rr\t\t""ss\"\"""tt\/\/""uu\\\\""vv\b\b""ww\f\f""xx\n\n""yy\r\r""zz\t\t""{{\"\"""||\/\/""}}\\\\""~~\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\n\n""\r\r""\t\t""\"\"""\/\/""\\\\""\b\b""\f\f""\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "		\"\" "

\/\/ "\\\\ "\b\b "

\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "  \t\t "!!\"\" "##\/\/ "$$\\\\ "%%\b\b "&&\f\f "''\n\n "((\r\r "))\t\t "**\"\" "++\/\/ ",,\\\\ "--\b\b "..\f\f "//\n\n "00\r\r "11\t\t "22\"\" "33\/\/ "44\\\\ "55\b\b "66\f\f "77\n\n "88\r\r "99\t\t "::\"\" ";;\/\/ "<<\\\\ "==\b\b ">>\f\f "??\n\n "@@\r\r "AA\t\t "BB\"\" "CC\/\/ "DD\\\\ "EE\b\b "FF\f\f "GG\n\n "HH\r\r "II\t\t "JJ\"\" "KK\/\/ "LL\\\\ "MM\b\b "NN\f\f "OO\n\n "PP\r\r "QQ\t\t "RR\"\" "SS\/\/ "TT\\\\ "UU\b\b "VV\f\f "WW\n\n "XX\r\r "YY\t\t "ZZ\"\" "[[\/\/ "]]\\\\ "^^\b\b "__\f\f "``\n\n "aa\r\r "bb\t\t "cc\"\" "dd\/\/ "ee\\\\ "ff\b\b "gg\f\f "hh\n\n "ii\r\r "jj\t\t "kk\"\" "ll\/\/ "mm\\\\ "nn\b\b "oo\f\f "pp\n\n "qq\r\r "rr\t\t "ss\"\" "tt\/\/ "uu\\\\ "vv\b\b "ww\f\f "xx\n\n "yy\r\r "zz\t\t "{{\"\" "||\/\/ "}}\\\\ "~~\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\n\n "\r\r "\t\t "\"\" "\/\/ "\\\\ "\b\b "\f\f "\"\u0000""\/\u1111""\\\u2222""\b\u3333""\f\u4444""\n\u5555""\r\u6666""\t\u7777""		\"\u8888""

\/\u9999""\\\uAAAA""\b\uBBBB""

\f\uCCCC""\n\uDDDD""\r\uEEEE""\t\uFFFF""\"\uaaaa""\/\ubbbb""\\\ucccc""\b\udddd""\f\ueeee""\n\uffff""\r\u0000""\t\u1111""\"\u2222""\/\u3333""\\\u4444""\b\u5555""\f\u6666""\n\u7777""\r\u8888""  \t\u9999""!!\"\uAAAA""##\/\uBBBB""$$\\\uCCCC""%%\b\uDDDD""&&\f\uEEEE""''\n\uFFFF""((\r\uaaaa""))\t\ubbbb""**\"\ucccc""++\/\udddd"",,\\\ueeee""--\b\uffff""..\f\u0000""//\n\u1111""00\r\u2222""11\t\u3333""22\"\u4444""33\/\u5555""44\\\u6666""55\b\u7777""66\f\u8888""77\n\u9999""88\r\uAAAA""99\t\uBBBB""::\"\uCCCC"";;\/\uDDDD""<<\\\uEEEE""==\b\uFFFF"">>\f\uaaaa""??\n\ubbbb""@@\r\ucccc""AA\t\udddd""BB\"\ueeee""CC\/\uffff""DD\\\u0000""EE\b\u1111""FF\f\u2222""GG\n\u3333""HH\r\u4444""II\t\u5555""JJ\"\u6666""KK\/\u7777""LL\\\u8888""MM\b\u9999""NN\f\uAAAA""OO\n\uBBBB""PP\r\uCCCC""QQ\t\uDDDD""RR\"\uEEEE""SS\/\uFFFF""TT\\\uaaaa""UU\b\ubbbb""VV\f\ucccc""WW\n\udddd""XX\r\ueeee""YY\t\uffff""ZZ\"\u0000""[[\/\u1111""]]\\\u2222""^^\b\u3333""__\f\u4444""``\n\u5555""aa\r\u6666""bb\t\u7777""cc\"\u8888""dd\/\u9999""ee\\\uAAAA""ff\b\uBBBB""gg\f\uCCCC""hh\n\uDDDD""ii\r\uEEEE""jj\t\uFFFF""kk\"\uaaaa""ll\/\ubbbb""mm\\\ucccc""nn\b\udddd""oo\f\ueeee""pp\n\uffff""qq\r\u0000""rr\t\u1111""ss\"\u2222""tt\/\u3333""uu\\\u4444""vv\b\u5555""ww\f\u6666""xx\n\u7777""yy\r\u8888""zz\t\u9999""{{\"\uAAAA""||\/\uBBBB""}}\\\uCCCC""~~\b\uDDDD""\f\uEEEE""\n\uFFFF""\r\uaaaa""\t\ubbbb""\"\ucccc""\/\udddd""\\\ueeee""\b\uffff""\f\u0000""\n\u1111""\r\u2222""\t\u3333""\"\u4444""\/\u5555""\\\u6666""\b\u7777""\f\u8888""\n\u9999""\r\uAAAA""\t\uBBBB""\"\uCCCC""\/\uDDDD""\\\uEEEE""\b\uFFFF""\f\uaaaa""\n\ubbbb""\r\ucccc""\t\udddd""\"\ueeee""\/\uffff""\\\u0000""\b\u1111""\f\u2222""\n\u3333""\r\u4444""\t\u5555""\"\u6666""\/\u7777""\\\u8888""\b\u9999""\f\uAAAA""\n\uBBBB""\r\uCCCC""\t\uDDDD""\"\uEEEE""\/\uFFFF""\\\uaaaa""\b\ubbbb""\f\ucccc""\n\udddd""\r\ueeee""\t\uffff""\"\u0000""\/\u1111""\\\u2222""\b\u3333""\f\u4444""\n\u5555""\r\u6666""\t\u7777""\"\u8888""\/\u9999""\\\uAAAA""\b\uBBBB""\f\uCCCC""\n\uDDDD""\r\uEEEE""\t\uFFFF""\"\uaaaa""\/\ubbbb""\\\ucccc""\b\udddd""\f\ueeee""\n\uffff""\r\u0000""\t\u1111""\"\u2222""\/\u3333""\\\u4444""\b\u5555""\f\u6666""\n\u7777""\r\u8888""\t\u9999""\"\uAAAA""\/\uBBBB""\\\uCCCC""\b\uDDDD""\f\uEEEE""\n\uFFFF""\r\uaaaa""\t\ubbbb""\"\ucccc""\/\udddd""\\\ueeee""\b\uffff""\f\u0000""\n\u1111""\r\u2222""\t\u3333""\"\u4444""\/\u5555""\\\u6666""\b\u7777""\f\u8888""\n\u9999""\r\uAAAA""\t\uBBBB""\"\uCCCC""\/\uDDDD""\\\uEEEE""\b\uFFFF""\f\uaaaa""\n\ubbbb""\r\ucccc""\t\udddd""\"\ueeee""\/\uffff""\\\u0000""\b\u1111""\f\u2222""\n\u3333""\r\u4444""\t\u5555""\"\u6666""\/\u7777""\\\u8888""\b\u9999""\f\uAAAA""\"\u000 "\/\u111"\\\u222"\b\u333"\f\u444"\n\u555"\r\u666"\t\u777"		\"\u888"

\/\u999	"\\\uAAA
"\b\uBBB"

\f\uCCC"\n\uDDD
"\r\uEEE"\t\uFFF"\"\uaaa"\/\ubbb"\\\uccc"\b\uddd"\f\ueee"\n\ufff"\r\u000"\t\u111"\"\u222"\/\u333"\\\u444"\b\u555"\f\u666"\n\u777"\r\u888"  \t\u999"!!\"\uAAA "##\/\uBBB!"$$\\\uCCC""%%\b\uDDD#"&&\f\uEEE$"''\n\uFFF%"((\r\uaaa&"))\t\ubbb'"**\"\uccc("++\/\uddd)",,\\\ueee*"--\b\ufff+"..\f\u000,"//\n\u111-"00\r\u222."11\t\u333/"22\"\u444:"33\/\u555;"44\\\u666<"55\b\u777="66\f\u888>"77\n\u999?"88\r\uAAA@"99\t\uBBBG"::\"\uCCCH";;\/\uDDDI"<<\\\uEEEJ"==\b\uFFFK">>\f\uaaaL"??\n\ubbbM"@@\r\ucccN"AA\t\udddO"BB\"\ueeeP"CC\/\ufffQ"DD\\\u000R"EE\b\u111S"FF\f\u222T"GG\n\u333U"HH\r\u444V"II\t\u555W"JJ\"\u666X"KK\/\u777Y"LL\\\u888Z"MM\b\u999["NN\f\uAAA\"OO\n\uBBB]"PP\r\uCCC^"QQ\t\uDDD_"RR\"\uEEE`"SS\/\uFFFg"TT\\\uaaah"UU\b\ubbbi"VV\f\ucccj"WW\n\udddk"XX\r\ueeel"YY\t\ufffm"ZZ\"\u000n"[[\/\u111o"]]\\\u222p"^^\b\u333q"__\f\u444r"``\n\u555s"aa\r\u666t"bb\t\u777u"cc\"\u888v"dd\/\u999w"ee\\\uAAAx"ff\b\uBBBy"gg\f\uCCCz"hh\n\uDDD{"ii\r\uEEE|"jj\t\uFFF}"kk\"\uaaa~"ll\/\ubbb"mm\\\uccc"nn\b\uddd"oo\f\ueee"pp\n\ufff"qq\r\u000"rr\t\u111"ss\"\u222"tt\/\u333"uu\\\u444"vv\b\u555"ww\f\u666"xx\n\u777"yy\r\u888"zz\t\u999"{{\"\uAAA"||\/\uBBB"}}\\\uCCC"~~\b\uDDD"\f\uEEE"\n\uFFF"\r\uaaa"\t\ubbb"\"\uccc"\/\uddd"\\\ueee"\b\ufff"\f\u000"\n\u111"\r\u222"\t\u333"\"\u444"\/\u555"\\\u666"\b\u777"\f\u888"\n\u999"\r\uAAA"\t\uBBB"\"\uCCC"\/\uDDD"\\\uEEE"\b\uFFF"\f\uaaa"\n\ubbb"\r\uccc"\t\uddd"\"\ueee"\/\ufff"\\\u000"\b\u111"\f\u222"\n\u333"\r\u444"\t\u555"\"\u666"\/\u777"\\\u888"\b\u999"\f\uAAA"\n\uBBB"\r\uCCC"\t\uDDD"\"\uEEE"\/\uFFF"\\\uaaa"\b\ubbb"\f\uccc"\n\uddd"\r\ueee"\t\ufff"\"\u000"\/\u111"\\\u222"\b\u333"\f\u444"\n\u555"\r\u666"\t\u777"\"\u888"\/\u999"\\\uAAA"\b\uBBB"\f\uCCC"\n\uDDD"\r\uEEE"\t\uFFF"\"\uaaa"\/\ubbb"\\\uccc"\b\uddd"\f\ueee"\n\ufff"\r\u000"\t\u111"\"\u222"\/\u333"\\\u444"\b\u555"\f\u666"\n\u777"\r\u888"\t\u999"\"\uAAA"\/\uBBB"\\\uCCC"\b\uDDD"\f\uEEE"\n\uFFF"\r\uaaa"\t\ubbb"\"\uccc"\/\uddd"\\\ueee"\b\ufff"\f\u000"\n\u111"\r\u222"\t\u333"\"\u444"\/\u555"\\\u666"\b\u777"\f\u888"\n\u999"\r\uAAA"\t\uBBB"\"\uCCC"\/\uDDD"\\\uEEE "\b\uFFF"\f\uaaa"\n\ubbb"\r\uccc"\t\uddd"\"\ueee"\/\ufff"\\\u000"\b\u111	"\f\u222
"\n\u333"\r\u444"\t\u555
"\"\u666"\/\u777"\\\u888"\b\u999"\f\uAAA"\"\u00 "\/\u11"\\\u22"\b\u33"\f\u44"\n\u55"\r\u66"\t\u77"		\"\u88"

\/\u99	"\\\uAA
"\b\uBB"

\f\uCC"\n\uDD
"\r\uEE"\t\uFF"\"\uaa"\/\ubb"\\\ucc"\b\udd"\f\uee"\n\uff"\r\u00"\t\u11"\"\u22"\/\u33"\\\u44"\b\u55"\f\u66"\n\u77"\r\u88"  \t\u99"!!\"\uAA "##\/\uBB!"$$\\\uCC""%%\b\uDD#"&&\f\uEE$"''\n\uFF%"((\r\uaa&"))\t\ubb'"**\"\ucc("++\/\udd)",,\\\uee*"--\b\uff+"..\f\u00,"//\n\u11-"00\r\u22."11\t\u33/"22\"\u44:"33\/\u55;"44\\\u66<"55\b\u77="66\f\u88>"77\n\u99?"88\r\uAA@"99\t\uBBG"::\"\uCCH";;\/\uDDI"<<\\\uEEJ"==\b\uFFK">>\f\uaaL"??\n\ubbM"@@\r\uccN"AA\t\uddO"BB\"\ueeP"CC\/\uffQ"DD\\\u00R"EE\b\u11S"FF\f\u22T"GG\n\u33U"HH\r\u44V"II\t\u55W"JJ\"\u66X"KK\/\u77Y"LL\\\u88Z"MM\b\u99["NN\f\uAA\"OO\n\uBB]"PP\r\uCC^"QQ\t\uDD_"RR\"\uEE`"SS\/\uFFg"TT\\\uaah"UU\b\ubbi"VV\f\uccj"WW\n\uddk"XX\r\ueel"YY\t\uffm"ZZ\"\u00n"[[\/\u11o"]]\\\u22p"^^\b\u33q"__\f\u44r"``\n\u55s"aa\r\u66t"bb\t\u77u"cc\"\u88v"dd\/\u99w"ee\\\uAAx"ff\b\uBBy"gg\f\uCCz"hh\n\uDD{"ii\r\uEE|"jj\t\uFF}"kk\"\uaa~"ll\/\ubb"mm\\\ucc"nn\b\udd"oo\f\uee"pp\n\uff"qq\r\u00"rr\t\u11"ss\"\u22"tt\/\u33"uu\\\u44"vv\b\u55"ww\f\u66"xx\n\u77"yy\r\u88"zz\t\u99"{{\"\uAA"||\/\uBB"}}\\\uCC"~~\b\uDD"\f\uEE"\n\uFF"\r\uaa"\t\ubb"\"\ucc"\/\udd"\\\uee"\b\uff"\f\u00"\n\u11"\r\u22"\t\u33"\"\u44"\/\u55"\\\u66"\b\u77"\f\u88"\n\u99"\r\uAA"\t\uBB"\"\uCC"\/\uDD"\\\uEE"\b\uFF"\f\uaa"\n\ubb"\r\ucc"\t\udd"\"\uee"\/\uff"\\\u00"\b\u11"\f\u22"\n\u33"\r\u44"\t\u55"\"\u66"\/\u77"\\\u88"\b\u99"\f\uAA"\n\uBB"\r\uCC"\t\uDD"\"\uEE"\/\uFF"\\\uaa"\b\ubb"\f\ucc"\n\udd"\r\uee"\t\uff"\"\u00"\/\u11"\\\u22"\b\u33"\f\u44"\n\u55"\r\u66"\t\u77"\"\u88"\/\u99"\\\uAA"\b\uBB"\f\uCC"\n\uDD"\r\uEE"\t\uFF"\"\uaa"\/\ubb"\\\ucc"\b\udd"\f\uee"\n\uff"\r\u00"\t\u11"\"\u22"\/\u33"\\\u44"\b\u55"\f\u66"\n\u77"\r\u88"\t\u99"\"\uAA"\/\uBB"\\\uCC"\b\uDD"\f\uEE"\n\uFF"\r\uaa"\t\ubb"\"\ucc"\/\udd"\\\uee"\b\uff"\f\u00"\n\u11"\r\u22"\t\u33"\"\u44"\/\u55"\\\u66"\b\u77"\f\u88"\n\u99"\r\uAA"\t\uBB"\"\uCC"\/\uDD"\\\uEE "\b\uFF"\f\uaa"\n\ubb"\r\ucc"\t\udd"\"\uee"\/\uff"\\\u00"\b\u11	"\f\u22
"\n\u33"\r\u44"\t\u55
"\"\u66"\/\u77"\\\u88"\b\u99"\f\uAA"\"\u0 "\/\u1"\\\u2"\b\u3"\f\u4"\n\u5"\r\u6"\t\u7"		\"\u8"

\/\u9	"\\\uA
"\b\uB"

\f\uC"\n\uD
"\r\uE"\t\uF"\"\ua"\/\ub"\\\uc"\b\ud"\f\ue"\n\uf"\r\u0"\t\u1"\"\u2"\/\u3"\\\u4"\b\u5"\f\u6"\n\u7"\r\u8"  \t\u9"!!\"\uA "##\/\uB!"$$\\\uC""%%\b\uD#"&&\f\uE$"''\n\uF%"((\r\ua&"))\t\ub'"**\"\uc("++\/\ud)",,\\\ue*"--\b\uf+"..\f\u0,"//\n\u1-"00\r\u2."11\t\u3/"22\"\u4:"33\/\u5;"44\\\u6<"55\b\u7="66\f\u8>"77\n\u9?"88\r\uA@"99\t\uBG"::\"\uCH";;\/\uDI"<<\\\uEJ"==\b\uFK">>\f\uaL"??\n\ubM"@@\r\ucN"AA\t\udO"BB\"\ueP"CC\/\ufQ"DD\\\u0R"EE\b\u1S"FF\f\u2T"GG\n\u3U"HH\r\u4V"II\t\u5W"JJ\"\u6X"KK\/\u7Y"LL\\\u8Z"MM\b\u9["NN\f\uA\"OO\n\uB]"PP\r\uC^"QQ\t\uD_"RR\"\uE`"SS\/\uFg"TT\\\uah"UU\b\ubi"VV\f\ucj"WW\n\udk"XX\r\uel"YY\t\ufm"ZZ\"\u0n"[[\/\u1o"]]\\\u2p"^^\b\u3q"__\f\u4r"``\n\u5s"aa\r\u6t"bb\t\u7u"cc\"\u8v"dd\/\u9w"ee\\\uAx"ff\b\uBy"gg\f\uCz"hh\n\uD{"ii\r\uE|"jj\t\uF}"kk\"\ua~"ll\/\ub"mm\\\uc"nn\b\ud"oo\f\ue"pp\n\uf"qq\r\u0"rr\t\u1"ss\"\u2"tt\/\u3"uu\\\u4"vv\b\u5"ww\f\u6"xx\n\u7"yy\r\u8"zz\t\u9"{{\"\uA"||\/\uB"}}\\\uC"~~\b\uD"\f\uE"\n\uF"\r\ua"\t\ub"\"\uc"\/\ud"\\\ue"\b\uf"\f\u0"\n\u1"\r\u2"\t\u3"\"\u4"\/\u5"\\\u6"\b\u7"\f\u8"\n\u9"\r\uA"\t\uB"\"\uC"\/\uD"\\\uE"\b\uF"\f\ua"\n\ub"\r\uc"\t\ud"\"\ue"\/\uf"\\\u0"\b\u1"\f\u2"\n\u3"\r\u4"\t\u5"\"\u6"\/\u7"\\\u8"\b\u9"\f\uA"\n\uB"\r\uC"\t\uD"\"\uE"\/\uF"\\\ua"\b\ub"\f\uc"\n\ud"\r\ue"\t\uf"\"\u0"\/\u1"\\\u2"\b\u3"\f\u4"\n\u5"\r\u6"\t\u7"\"\u8"\/\u9"\\\uA"\b\uB"\f\uC"\n\uD"\r\uE"\t\uF"\"\ua"\/\ub"\\\uc"\b\ud"\f\ue"\n\uf"\r\u0"\t\u1"\"\u2"\/\u3"\\\u4"\b\u5"\f\u6"\n\u7"\r\u8"\t\u9"\"\uA"\/\uB"\\\uC"\b\uD"\f\uE"\n\uF"\r\ua"\t\ub"\"\uc"\/\ud"\\\ue"\b\uf"\f\u0"\n\u1"\r\u2"\t\u3"\"\u4"\/\u5"\\\u6"\b\u7"\f\u8"\n\u9"\r\uA"\t\uB"\"\uC"\/\uD"\\\uE "\b\uF"\f\ua"\n\ub"\r\uc"\t\ud"\"\ue"\/\uf"\\\u0"\b\u1	"\f\u2
"\n\u3"\r\u4"\t\u5
"\"\u6"\/\u7"\\\u8"\b\u9"\f\uA"\"\u "\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"		\"\u"

\/\u	"\\\u
"\b\u"

\f\u"\n\u
"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"  \t\u"!!\"\u "##\/\u!"$$\\\u""%%\b\u#"&&\f\u$"''\n\u%"((\r\u&"))\t\u'"**\"\u("++\/\u)",,\\\u*"--\b\u+"..\f\u,"//\n\u-"00\r\u."11\t\u/"22\"\u:"33\/\u;"44\\\u<"55\b\u="66\f\u>"77\n\u?"88\r\u@"99\t\uG"::\"\uH";;\/\uI"<<\\\uJ"==\b\uK">>\f\uL"??\n\uM"@@\r\uN"AA\t\uO"BB\"\uP"CC\/\uQ"DD\\\uR"EE\b\uS"FF\f\uT"GG\n\uU"HH\r\uV"II\t\uW"JJ\"\uX"KK\/\uY"LL\\\uZ"MM\b\u["NN\f\u\"OO\n\u]"PP\r\u^"QQ\t\u_"RR\"\u`"SS\/\ug"TT\\\uh"UU\b\ui"VV\f\uj"WW\n\uk"XX\r\ul"YY\t\um"ZZ\"\un"[[\/\uo"]]\\\up"^^\b\uq"__\f\ur"``\n\us"aa\r\ut"bb\t\uu"cc\"\uv"dd\/\uw"ee\\\ux"ff\b\uy"gg\f\uz"hh\n\u{"ii\r\u|"jj\t\u}"kk\"\u~"ll\/\u"mm\\\u"nn\b\u"oo\f\u"pp\n\u"qq\r\u"rr\t\u"ss\"\u"tt\/\u"uu\\\u"vv\b\u"ww\f\u"xx\n\u"yy\r\u"zz\t\u"{{\"\u"||\/\u"}}\\\u"~~\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u "\b\u"\f\u"\n\u"\r\u"\t\u"\"\u"\/\u"\\\u"\b\u	"\f\u
"\n\u"\r\u"\t\u
"\"\u"\/\u"\\\u"\b\u"\f\u"\"\ "\/\"\\\"\b\"\f\"\n\"\r\"\t\"		\"\"

\/\	"\\\
"\b\"

\f\"\n\
"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"  \t\"!!\"\ "##\/\!"$$\\\#"%%\b\$"&&\f\%"''\n\&"((\r\'"))\t\("**\"\)"++\/\*",,\\\+"--\b\,"..\f\-"//\n\."00\r\0"11\t\1"22\"\2"33\/\3"44\\\4"55\b\5"66\f\6"77\n\7"88\r\8"99\t\9"::\"\:";;\/\;"<<\\\<"==\b\=">>\f\>"??\n\?"@@\r\@"AA\t\A"BB\"\B"CC\/\C"DD\\\D"EE\b\E"FF\f\F"GG\n\G"HH\r\H"II\t\I"JJ\"\J"KK\/\K"LL\\\L"MM\b\M"NN\f\N"OO\n\O"PP\r\P"QQ\t\Q"RR\"\R"SS\/\S"TT\\\T"UU\b\U"VV\f\V"WW\n\W"XX\r\X"YY\t\Y"ZZ\"\Z"[[\/\["]]\\\]"^^\b\^"__\f\_"``\n\`"aa\r\a"bb\t\c"cc\"\d"dd\/\e"ee\\\g"ff\b\h"gg\f\i"hh\n\j"ii\r\k"jj\t\l"kk\"\m"ll\/\o"mm\\\p"nn\b\q"oo\f\s"pp\n\v"qq\r\w"rr\t\x"ss\"\y"tt\/\z"uu\\\{"vv\b\|"ww\f\}"xx\n\~"yy\r\"zz\t\"{{\"\"||\/\"}}\\\"~~\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\"\"\"\/\"\\\"\b\"\f\"\n\"\r\"\t\ "\"\"\/\"\\\"\b\"\f\"\"""\/""\\""\b""\f""\n""\r""\t""		\"	""

\/
""\\""\b""

\f
""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""  \t ""!!\"!""##\/#""$$\\$""%%\b%""&&\f&""''\n'""((\r(""))\t)""**\"*""++\/+"",,\\,""--\b-""..\f.""//\n/""00\r0""11\t1""22\"2""33\/3""44\\4""55\b5""66\f6""77\n7""88\r8""99\t9""::\":"";;\/;""<<\\<""==\b="">>\f>""??\n?""@@\r@""AA\tA""BB\"B""CC\/C""DD\\D""EE\bE""FF\fF""GG\nG""HH\rH""II\tI""JJ\"J""KK\/K""LL\\L""MM\bM""NN\fN""OO\nO""PP\rP""QQ\tQ""RR\"R""SS\/S""TT\\T""UU\bU""VV\fV""WW\nW""XX\rX""YY\tY""ZZ\"Z""[[\/[""]]\\]""^^\b^""__\f_""``\n`""aa\ra""bb\tb""cc\"c""dd\/d""ee\\e""ff\bf""gg\fg""hh\nh""ii\ri""jj\tj""kk\"k""ll\/l""mm\\m""nn\bn""oo\fo""pp\np""qq\rq""rr\tr""ss\"s""tt\/t""uu\\u""vv\bv""ww\fw""xx\nx""yy\ry""zz\tz""{{\"{""||\/|""}}\\}""~~\b~""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\"""\/""\\""\b""\f""\n""\r""\t""		\"""

\/""\\""\b""

\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""  \t""!!\"""##\/""$$\\""%%\b""&&\f""''\n""((\r""))\t""**\"""++\/"",,\\""--\b""..\f""//\n""00\r""11\t""22\"""33\/""44\\""55\b""66\f""77\n""88\r""99\t""::\""";;\/""<<\\""==\b"">>\f""??\n""@@\r""AA\t""BB\"""CC\/""DD\\""EE\b""FF\f""GG\n""HH\r""II\t""JJ\"""KK\/""LL\\""MM\b""NN\f""OO\n""PP\r""QQ\t""RR\"""SS\/""TT\\""UU\b""VV\f""WW\n""XX\r""YY\t""ZZ\"""[[\/""]]\\""^^\b""__\f""``\n""aa\r""bb\t""cc\"""dd\/""ee\\""ff\b""gg\f""hh\n""ii\r""jj\t""kk\"""ll\/""mm\\""nn\b""oo\f""pp\n""qq\r""rr\t""ss\"""tt\/""uu\\""vv\b""ww\f""xx\n""yy\r""zz\t""{{\"""||\/""}}\\""~~\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\" "\/ "\\ "\b "\f "\n "\r "\t "		\" "

\/ "\\ "\b "

\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "  \t "!!\" "##\/ "$$\\ "%%\b "&&\f "''\n "((\r "))\t "**\" "++\/ ",,\\ "--\b "..\f "//\n "00\r "11\t "22\" "33\/ "44\\ "55\b "66\f "77\n "88\r "99\t "::\" ";;\/ "<<\\ "==\b ">>\f "??\n "@@\r "AA\t "BB\" "CC\/ "DD\\ "EE\b "FF\f "GG\n "HH\r "II\t "JJ\" "KK\/ "LL\\ "MM\b "NN\f "OO\n "PP\r "QQ\t "RR\" "SS\/ "TT\\ "UU\b "VV\f "WW\n "XX\r "YY\t "ZZ\" "[[\/ "]]\\ "^^\b "__\f "``\n "aa\r "bb\t "cc\" "dd\/ "ee\\ "ff\b "gg\f "hh\n "ii\r "jj\t "kk\" "ll\/ "mm\\ "nn\b "oo\f "pp\n "qq\r "rr\t "ss\" "tt\/ "uu\\ "vv\b "ww\f "xx\n "yy\r "zz\t "{{\" "||\/ "}}\\ "~~\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\n "\r "\t "\" "\/ "\\ "\b "\f "\u0000""\u1111""\u2222""\u3333""\u4444""\u5555""\u6666""\u7777""		\u8888""

\u9999""\uAAAA""\uBBBB""

\uCCCC""\uDDDD""\uEEEE""\uFFFF""\uaaaa""\ubbbb""\ucccc""\udddd""\ueeee""\uffff""\u0000""\u1111""\u2222""\u3333""\u4444""\u5555""\u6666""\u7777""\u8888""  \u9999""!!\uAAAA""##\uBBBB""$$\uCCCC""%%\uDDDD""&&\uEEEE""''\uFFFF""((\uaaaa""))\ubbbb""**\ucccc""++\udddd"",,\ueeee""--\uffff""..\u0000""//\u1111""00\u2222""11\u3333""22\u4444""33\u5555""44\u6666""55\u7777""66\u8888""77\u9999""88\uAAAA""99\uBBBB""::\uCCCC"";;\uDDDD""<<\uEEEE""==\uFFFF"">>\uaaaa""??\ubbbb""@@\ucccc""AA\udddd""BB\ueeee""CC\uffff""DD\u0000""EE\u1111""FF\u2222""GG\u3333""HH\u4444""II\u5555""JJ\u6666""KK\u7777""LL\u8888""MM\u9999""NN\uAAAA""OO\uBBBB""PP\uCCCC""QQ\uDDDD""RR\uEEEE""SS\uFFFF""TT\uaaaa""UU\ubbbb""VV\ucccc""WW\udddd""XX\ueeee""YY\uffff""ZZ\u0000""[[\u1111""]]\u2222""^^\u3333""__\u4444""``\u5555""aa\u6666""bb\u7777""cc\u8888""dd\u9999""ee\uAAAA""ff\uBBBB""gg\uCCCC""hh\uDDDD""ii\uEEEE""jj\uFFFF""kk\uaaaa""ll\ubbbb""mm\ucccc""nn\udddd""oo\ueeee""pp\uffff""qq\u0000""rr\u1111""ss\u2222""tt\u3333""uu\u4444""vv\u5555""ww\u6666""xx\u7777""yy\u8888""zz\u9999""{{\uAAAA""||\uBBBB""}}\uCCCC""~~\uDDDD""\uEEEE""\uFFFF""\uaaaa""\ubbbb""\ucccc""\udddd""\ueeee""\uffff""\u0000""\u1111""\u2222""\u3333""\u4444""\u5555""\u6666""\u7777""\u8888""\u9999""\uAAAA""\uBBBB""\uCCCC""\uDDDD""\uEEEE""\uFFFF""\uaaaa""\ubbbb""\ucccc""\udddd""\ueeee""\uffff""\u0000""\u1111""\u2222""\u3333""\u4444""\u5555""\u6666""\u7777""\u8888""\u9999""\uAAAA""\uBBBB""\uCCCC""\uDDDD""\uEEEE""\uFFFF""\uaaaa""\ubbbb""\ucccc""\udddd""\ueeee""\uffff""\u0000""\u1111""\u2222""\u3333""\u4444""\u5555""\u6666""\u7777""\u8888""\u9999""\uAAAA""\uBBBB""\uCCCC""\uDDDD""\uEEEE""\uFFFF""\uaaaa""\ubbbb""\ucccc""\udddd""\ueeee""\uffff""\u0000""\u1111""\u2222""\u3333""\u4444""\u5555""\u6666""\u7777""\u8888""\u9999""\uAAAA""\uBBBB""\uCCCC""\uDDDD""\uEEEE""\uFFFF""\uaaaa""\ubbbb""\ucccc""\udddd""\ueeee""\uffff""\u0000""\u1111""\u2222""\u3333""\u4444""\u5555""\u6666""\u7777""\u8888""\u9999""\uAAAA""\uBBBB""\uCCCC""\uDDDD""\uEEEE""\uFFFF""\uaaaa""\ubbbb""\ucccc""\udddd""\ueeee""\uffff""\u0000""\u1111""\u2222""\u3333""\u4444""\u5555""\u6666""\u7777""\u8888""\u9999""\uAAAA""\ "\"\"\"\"\"\"\"		\"

\	"\
"\"

\"\
"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"  \"!!\ "##\!"$$\#"%%\$"&&\%"''\&"((\'"))\("**\)"++\*",,\+"--\,"..\-"//\."00\0"11\1"22\2"33\3"44\4"55\5"66\6"77\7"88\8"99\9"::\:";;\;"<<\<"==\=">>\>"??\?"@@\@"AA\A"BB\B"CC\C"DD\D"EE\E"FF\F"GG\G"HH\H"II\I"JJ\J"KK\K"LL\L"MM\M"NN\N"OO\O"PP\P"QQ\Q"RR\R"SS\S"TT\T"UU\U"VV\V"WW\W"XX\X"YY\Y"ZZ\Z"[[\["]]\]"^^\^"__\_"``\`"aa\a"bb\c"cc\d"dd\e"ee\g"ff\h"gg\i"hh\j"ii\k"jj\l"kk\m"ll\o"mm\p"nn\q"oo\s"pp\v"qq\w"rr\x"ss\y"tt\z"uu\{"vv\|"ww\}"xx\~"yy\"zz\"{{\"||\"}}\"~~\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\ "\"\"\"\"\" " " " " " " " "		 "

 " " "

 " " " " " " " " " " " " " " " " " " "   "!! "## "$$ "%% "&& "'' "(( ")) "** "++ ",, "-- ".. "// "00 "11 "22 "33 "44 "55 "66 "77 "88 "99 ":: ";; "<< "== ">> "?? "@@ "AA "BB "CC "DD "EE "FF "GG "HH "II "JJ "KK "LL "MM "NN "OO "PP "QQ "RR "SS "TT "UU "VV "WW "XX "YY "ZZ "[[ "]] "^^ "__ "`` "aa "bb "cc "dd "ee "ff "gg "hh "ii "jj "kk "ll "mm "nn "oo "pp "qq "rr "ss "tt "uu "vv "ww "xx "yy "zz "{{ "|| "}} "~~ " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " """""""""""""""""	""
""""""
"""""""""""""""""""""""""""""""""""""" ""!""#""$""%""&""'""("")""*""+"",""-"".""/""0""1""2""3""4""5""6""7""8""9"":"";""<""="">""?""@""A""B""C""D""E""F""G""H""I""J""K""L""M""N""O""P""Q""R""S""T""U""V""W""X""Y""Z""[""]""^""_""`""a""b""c""d""e""f""g""h""i""j""k""l""m""n""o""p""q""r""s""t""u""v""w""x""y""z""{""|""}""~""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""\"""\/""\\""\b""\f""\n""\r""\t""	\"""
\/""\\""\b""
\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r"" \t""!\"""#\/""$\\""%\b""&\f""'\n""(\r"")\t""*\"""+\/"",\\""-\b"".\f""/\n""0\r""1\t""2\"""3\/""4\\""5\b""6\f""7\n""8\r""9\t"":\""";\/""<\\""=\b"">\f""?\n""@\r""A\t""B\"""C\/""D\\""E\b""F\f""G\n""H\r""I\t""J\"""K\/""L\\""M\b""N\f""O\n""P\r""Q\t""R\"""S\/""T\\""U\b""V\f""W\n""X\r""Y\t""Z\"""[\/""]\\""^\b""_\f""`\n""a\r""b\t""c\"""d\/""e\\""f\b""g\f""h\n""i\r""j\t""k\"""l\/""m\\""n\b""o\f""p\n""q\r""r\t""s\"""t\/""u\\""v\b""w\f""x\n""y\r""z\t""{\"""|\/""}\\""~\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f""\n""\r""\t""\"""\/""\\""\b""\f"" " " " " " " " "	 "
 " " "
 " " " " " " " " " " " " " " " " " " "  "! "# "$ "% "& "' "( ") "* "+ ", "- ". "/ "0 "1 "2 "3 "4 "5 "6 "7 "8 "9 ": "; "< "= "> "? "@ "A "B "C "D "E "F "G "H "I "J "K "L "M "N "O "P "Q "R "S "T "U "V "W "X "Y "Z "[ "] "^ "_ "` "a "b "c "d "e "f "g "h "i "j "k "l "m "n "o "p "q "r "s "t "u "v "w "x "y "z "{ "| "} "~ " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " " """\"""\/""\\""\b""\f""\n""\r""\t"" +.00E+00 -.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99	+.00E+00
-.11e-11+.22E+22-.33e-33
+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22 -.33e-33!+.44E+44"-.55e-55#+.66E+66$-.77e-77%+.88E+88&-.99e-99'+.00E+00(-.11e-11)+.22E+22*-.33e-33++.44E+44,-.55e-55-+.66E+66.-.77e-77/+.88E+88:-.99e-99;+.00E+00<-.11e-11=+.22E+22>-.33e-33?+.44E+44@-.55e-55A+.66E+66B-.77e-77C+.88E+88D-.99e-99E+.00E+00F-.11e-11G+.22E+22H-.33e-33I+.44E+44J-.55e-55K+.66E+66L-.77e-77M+.88E+88N-.99e-99O+.00E+00P-.11e-11Q+.22E+22R-.33e-33S+.44E+44T-.55e-55U+.66E+66V-.77e-77W+.88E+88X-.99e-99Y+.00E+00Z-.11e-11[+.22E+22\-.33e-33]+.44E+44^-.55e-55_+.66E+66`-.77e-77a+.88E+88b-.99e-99c+.00E+00d-.11e-11e+.22E+22f-.33e-33g+.44E+44h-.55e-55i+.66E+66j-.77e-77k+.88E+88l-.99e-99m+.00E+00n-.11e-11o+.22E+22p-.33e-33q+.44E+44r-.55e-55s+.66E+66t-.77e-77u+.88E+88v-.99e-99w+.00E+00x-.11e-11y+.22E+22z-.33e-33{+.44E+44|-.55e-55}+.66E+66~-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.66E+66-.77e-77+.88E+88-.99e-99+.00E+00-.11e-11+.22E+22-.33e-33+.44E+44-.55e-55+.00E+0 -.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9	+.00E+0
-.11e-1+.22E+2-.33e-3
+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2 -.33e-3!+.44E+4"-.55e-5#+.66E+6$-.77e-7%+.88E+8&-.99e-9'+.00E+0(-.11e-1)+.22E+2*-.33e-3++.44E+4,-.55e-5-+.66E+6.-.77e-7/+.88E+8:-.99e-9;+.00E+0<-.11e-1=+.22E+2>-.33e-3?+.44E+4@-.55e-5A+.66E+6B-.77e-7C+.88E+8D-.99e-9E+.00E+0F-.11e-1G+.22E+2H-.33e-3I+.44E+4J-.55e-5K+.66E+6L-.77e-7M+.88E+8N-.99e-9O+.00E+0P-.11e-1Q+.22E+2R-.33e-3S+.44E+4T-.55e-5U+.66E+6V-.77e-7W+.88E+8X-.99e-9Y+.00E+0Z-.11e-1[+.22E+2\-.33e-3]+.44E+4^-.55e-5_+.66E+6`-.77e-7a+.88E+8b-.99e-9c+.00E+0d-.11e-1e+.22E+2f-.33e-3g+.44E+4h-.55e-5i+.66E+6j-.77e-7k+.88E+8l-.99e-9m+.00E+0n-.11e-1o+.22E+2p-.33e-3q+.44E+4r-.55e-5s+.66E+6t-.77e-7u+.88E+8v-.99e-9w+.00E+0x-.11e-1y+.22E+2z-.33e-3{+.44E+4|-.55e-5}+.66E+6~-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.66E+6-.77e-7+.88E+8-.99e-9+.00E+0-.11e-1+.22E+2-.33e-3+.44E+4-.55e-5+.00E+ -.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-	+.00E+
-.11e-+.22E+-.33e-
+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+ -.33e-!+.44E+"-.55e-#+.66E+$-.77e-%+.88E+&-.99e-'+.00E+(-.11e-)+.22E+*-.33e-++.44E+,-.55e--+.66E+.-.77e-/+.88E+:-.99e-;+.00E+<-.11e-=+.22E+>-.33e-?+.44E+@-.55e-A+.66E+B-.77e-C+.88E+D-.99e-E+.00E+F-.11e-G+.22E+H-.33e-I+.44E+J-.55e-K+.66E+L-.77e-M+.88E+N-.99e-O+.00E+P-.11e-Q+.22E+R-.33e-S+.44E+T-.55e-U+.66E+V-.77e-W+.88E+X-.99e-Y+.00E+Z-.11e-[+.22E+\-.33e-]+.44E+^-.55e-_+.66E+`-.77e-a+.88E+b-.99e-c+.00E+d-.11e-e+.22E+f-.33e-g+.44E+h-.55e-i+.66E+j-.77e-k+.88E+l-.99e-m+.00E+n-.11e-o+.22E+p-.33e-q+.44E+r-.55e-s+.66E+t-.77e-u+.88E+v-.99e-w+.00E+x-.11e-y+.22E+z-.33e-{+.44E+|-.55e-}+.66E+~-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.66E+-.77e-+.88E+-.99e-+.00E+-.11e-+.22E+-.33e-+.44E+-.55e-+.00E0 -.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9	+.00E0
-.11e1+.22E2-.33e3
+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2 -.33e3!+.44E4"-.55e5#+.66E6$-.77e7%+.88E8&-.99e9'+.00E0(-.11e1)+.22E2*-.33e3++.44E4,-.55e5-+.66E6.-.77e7/+.88E8:-.99e9;+.00E0<-.11e1=+.22E2>-.33e3?+.44E4@-.55e5A+.66E6B-.77e7C+.88E8D-.99e9E+.00E0F-.11e1G+.22E2H-.33e3I+.44E4J-.55e5K+.66E6L-.77e7M+.88E8N-.99e9O+.00E0P-.11e1Q+.22E2R-.33e3S+.44E4T-.55e5U+.66E6V-.77e7W+.88E8X-.99e9Y+.00E0Z-.11e1[+.22E2\-.33e3]+.44E4^-.55e5_+.66E6`-.77e7a+.88E8b-.99e9c+.00E0d-.11e1e+.22E2f-.33e3g+.44E4h-.55e5i+.66E6j-.77e7k+.88E8l-.99e9m+.00E0n-.11e1o+.22E2p-.33e3q+.44E4r-.55e5s+.66E6t-.77e7u+.88E8v-.99e9w+.00E0x-.11e1y+.22E2z-.33e3{+.44E4|-.55e5}+.66E6~-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.66E6-.77e7+.88E8-.99e9+.00E0-.11e1+.22E2-.33e3+.44E4-.55e5+.00E -.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e	+.00E
-.11e+.22E-.33e
+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E -.33e!+.44E"-.55e#+.66E$-.77e%+.88E&-.99e'+.00E(-.11e)+.22E*-.33e,+.44E.-.55e/+.66E:-.77e;+.88E<-.99e=+.00E>-.11e?+.22E@-.33eA+.44EB-.55eC+.66ED-.77eE+.88EF-.99eG+.00EH-.11eI+.22EJ-.33eK+.44EL-.55eM+.66EN-.77eO+.88EP-.99eQ+.00ER-.11eS+.22ET-.33eU+.44EV-.55eW+.66EX-.77eY+.88EZ-.99e[+.00E\-.11e]+.22E^-.33e_+.44E`-.55ea+.66Eb-.77ec+.88Ed-.99ee+.00Ef-.11eg+.22Eh-.33ei+.44Ej-.55ek+.66El-.77em+.88En-.99eo+.00Ep-.11eq+.22Er-.33es+.44Et-.55eu+.66Ev-.77ew+.88Ex-.99ey+.00Ez-.11e{+.22E|-.33e}+.44E~-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.44E-.55e+.66E-.77e+.88E-.99e+.00E-.11e+.22E-.33e+.00 -.11+.22-.33+.44-.55+.66-.77+.88-.99	+.00
-.11+.22-.33
+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22 -.33!+.44"-.55#+.66$-.77%+.88&-.99'+.00(-.11)+.22*-.33++.44,-.55-+.66.-.77/+.88:-.99;+.00<-.11=+.22>-.33?+.44@-.55A+.66B-.77C+.88D-.99F+.00G-.11H+.22I-.33J+.44K-.55L+.66M-.77N+.88O-.99P+.00Q-.11R+.22S-.33T+.44U-.55V+.66W-.77X+.88Y-.99Z+.00[-.11\+.22]-.33^+.44_-.55`+.66a-.77b+.88c-.99d+.00f-.11g+.22h-.33i+.44j-.55k+.66l-.77m+.88n-.99o+.00p-.11q+.22r-.33s+.44t-.55u+.66v-.77w+.88x-.99y+.00z-.11{+.22|-.33}+.44~-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.44-.55+.66-.77+.88-.99+.00-.11+.22-.33+.0E+0 -.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9	+.0E+0
-.1e-1+.2E+2-.3e-3
+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2 -.3e-3!+.4E+4"-.5e-5#+.6E+6$-.7e-7%+.8E+8&-.9e-9'+.0E+0(-.1e-1)+.2E+2*-.3e-3++.4E+4,-.5e-5-+.6E+6.-.7e-7/+.8E+8:-.9e-9;+.0E+0<-.1e-1=+.2E+2>-.3e-3?+.4E+4@-.5e-5A+.6E+6B-.7e-7C+.8E+8D-.9e-9E+.0E+0F-.1e-1G+.2E+2H-.3e-3I+.4E+4J-.5e-5K+.6E+6L-.7e-7M+.8E+8N-.9e-9O+.0E+0P-.1e-1Q+.2E+2R-.3e-3S+.4E+4T-.5e-5U+.6E+6V-.7e-7W+.8E+8X-.9e-9Y+.0E+0Z-.1e-1[+.2E+2\-.3e-3]+.4E+4^-.5e-5_+.6E+6`-.7e-7a+.8E+8b-.9e-9c+.0E+0d-.1e-1e+.2E+2f-.3e-3g+.4E+4h-.5e-5i+.6E+6j-.7e-7k+.8E+8l-.9e-9m+.0E+0n-.1e-1o+.2E+2p-.3e-3q+.4E+4r-.5e-5s+.6E+6t-.7e-7u+.8E+8v-.9e-9w+.0E+0x-.1e-1y+.2E+2z-.3e-3{+.4E+4|-.5e-5}+.6E+6~-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.6E+6-.7e-7+.8E+8-.9e-9+.0E+0-.1e-1+.2E+2-.3e-3+.4E+4-.5e-5+.0 -.1+.2-.3+.4-.5+.6-.7+.8-.9	+.0
-.1+.2-.3
+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2 -.3!+.4"-.5#+.6$-.7%+.8&-.9'+.0(-.1)+.2*-.3++.4,-.5-+.6.-.7/+.8:-.9;+.0<-.1=+.2>-.3?+.4@-.5A+.6B-.7C+.8D-.9F+.0G-.1H+.2I-.3J+.4K-.5L+.6M-.7N+.8O-.9P+.0Q-.1R+.2S-.3T+.4U-.5V+.6W-.7X+.8Y-.9Z+.0[-.1\+.2]-.3^+.4_-.5`+.6a-.7b+.8c-.9d+.0f-.1g+.2h-.3i+.4j-.5k+.6l-.7m+.8n-.9o+.0p-.1q+.2r-.3s+.4t-.5u+.6v-.7w+.8x-.9y+.0z-.1{+.2|-.3}+.4~-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+.4-.5+.6-.7+.8-.9+.0-.1+.2-.3+. -.+.-.+.-.+.-.+.-.	+.
-.+.-.
+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+. -.!+."-.#+.$-.%+.&-.'+.(-.)+.*-.++.,-.-+..-./+.:-.;+.<-.=+.>-.?+.@-.A+.B-.C+.D-.E+.F-.G+.H-.I+.J-.K+.L-.M+.N-.O+.P-.Q+.R-.S+.T-.U+.V-.W+.X-.Y+.Z-.[+.\-.]+.^-._+.`-.a+.b-.c+.d-.e+.f-.g+.h-.i+.j-.k+.l-.m+.n-.o+.p-.q+.r-.s+.t-.u+.v-.w+.x-.y+.z-.{+.|-.}+.~-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+.-.+0.00E+00 -0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99	+0.00E+00
-0.11e-11+0.22E+22-0.33e-33
+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22 -0.33e-33!+0.44E+44"-0.55e-55#+0.66E+66$-0.77e-77%+0.88E+88&-0.99e-99'+0.00E+00(-0.11e-11)+0.22E+22*-0.33e-33++0.44E+44,-0.55e-55-+0.66E+66.-0.77e-77/+0.88E+88:-0.99e-99;+0.00E+00<-0.11e-11=+0.22E+22>-0.33e-33?+0.44E+44@-0.55e-55A+0.66E+66B-0.77e-77C+0.88E+88D-0.99e-99E+0.00E+00F-0.11e-11G+0.22E+22H-0.33e-33I+0.44E+44J-0.55e-55K+0.66E+66L-0.77e-77M+0.88E+88N-0.99e-99O+0.00E+00P-0.11e-11Q+0.22E+22R-0.33e-33S+0.44E+44T-0.55e-55U+0.66E+66V-0.77e-77W+0.88E+88X-0.99e-99Y+0.00E+00Z-0.11e-11[+0.22E+22\-0.33e-33]+0.44E+44^-0.55e-55_+0.66E+66`-0.77e-77a+0.88E+88b-0.99e-99c+0.00E+00d-0.11e-11e+0.22E+22f-0.33e-33g+0.44E+44h-0.55e-55i+0.66E+66j-0.77e-77k+0.88E+88l-0.99e-99m+0.00E+00n-0.11e-11o+0.22E+22p-0.33e-33q+0.44E+44r-0.55e-55s+0.66E+66t-0.77e-77u+0.88E+88v-0.99e-99w+0.00E+00x-0.11e-11y+0.22E+22z-0.33e-33{+0.44E+44|-0.55e-55}+0.66E+66~-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.66E+66-0.77e-77+0.88E+88-0.99e-99+0.00E+00-0.11e-11+0.22E+22-0.33e-33+0.44E+44-0.55e-55+0.00E+0 -0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9	+0.00E+0
-0.11e-1+0.22E+2-0.33e-3
+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2 -0.33e-3!+0.44E+4"-0.55e-5#+0.66E+6$-0.77e-7%+0.88E+8&-0.99e-9'+0.00E+0(-0.11e-1)+0.22E+2*-0.33e-3++0.44E+4,-0.55e-5-+0.66E+6.-0.77e-7/+0.88E+8:-0.99e-9;+0.00E+0<-0.11e-1=+0.22E+2>-0.33e-3?+0.44E+4@-0.55e-5A+0.66E+6B-0.77e-7C+0.88E+8D-0.99e-9E+0.00E+0F-0.11e-1G+0.22E+2H-0.33e-3I+0.44E+4J-0.55e-5K+0.66E+6L-0.77e-7M+0.88E+8N-0.99e-9O+0.00E+0P-0.11e-1Q+0.22E+2R-0.33e-3S+0.44E+4T-0.55e-5U+0.66E+6V-0.77e-7W+0.88E+8X-0.99e-9Y+0.00E+0Z-0.11e-1[+0.22E+2\-0.33e-3]+0.44E+4^-0.55e-5_+0.66E+6`-0.77e-7a+0.88E+8b-0.99e-9c+0.00E+0d-0.11e-1e+0.22E+2f-0.33e-3g+0.44E+4h-0.55e-5i+0.66E+6j-0.77e-7k+0.88E+8l-0.99e-9m+0.00E+0n-0.11e-1o+0.22E+2p-0.33e-3q+0.44E+4r-0.55e-5s+0.66E+6t-0.77e-7u+0.88E+8v-0.99e-9w+0.00E+0x-0.11e-1y+0.22E+2z-0.33e-3{+0.44E+4|-0.55e-5}+0.66E+6~-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.66E+6-0.77e-7+0.88E+8-0.99e-9+0.00E+0-0.11e-1+0.22E+2-0.33e-3+0.44E+4-0.55e-5+0.00E+ -0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-	+0.00E+
-0.11e-+0.22E+-0.33e-
+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+ -0.33e-!+0.44E+"-0.55e-#+0.66E+$-0.77e-%+0.88E+&-0.99e-'+0.00E+(-0.11e-)+0.22E+*-0.33e-++0.44E+,-0.55e--+0.66E+.-0.77e-/+0.88E+:-0.99e-;+0.00E+<-0.11e-=+0.22E+>-0.33e-?+0.44E+@-0.55e-A+0.66E+B-0.77e-C+0.88E+D-0.99e-E+0.00E+F-0.11e-G+0.22E+H-0.33e-I+0.44E+J-0.55e-K+0.66E+L-0.77e-M+0.88E+N-0.99e-O+0.00E+P-0.11e-Q+0.22E+R-0.33e-S+0.44E+T-0.55e-U+0.66E+V-0.77e-W+0.88E+X-0.99e-Y+0.00E+Z-0.11e-[+0.22E+\-0.33e-]+0.44E+^-0.55e-_+0.66E+`-0.77e-a+0.88E+b-0.99e-c+0.00E+d-0.11e-e+0.22E+f-0.33e-g+0.44E+h-0.55e-i+0.66E+j-0.77e-k+0.88E+l-0.99e-m+0.00E+n-0.11e-o+0.22E+p-0.33e-q+0.44E+r-0.55e-s+0.66E+t-0.77e-u+0.88E+v-0.99e-w+0.00E+x-0.11e-y+0.22E+z-0.33e-{+0.44E+|-0.55e-}+0.66E+~-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.66E+-0.77e-+0.88E+-0.99e-+0.00E+-0.11e-+0.22E+-0.33e-+0.44E+-0.55e-+0.00E0 -0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9	+0.00E0
-0.11e1+0.22E2-0.33e3
+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2 -0.33e3!+0.44E4"-0.55e5#+0.66E6$-0.77e7%+0.88E8&-0.99e9'+0.00E0(-0.11e1)+0.22E2*-0.33e3++0.44E4,-0.55e5-+0.66E6.-0.77e7/+0.88E8:-0.99e9;+0.00E0<-0.11e1=+0.22E2>-0.33e3?+0.44E4@-0.55e5A+0.66E6B-0.77e7C+0.88E8D-0.99e9E+0.00E0F-0.11e1G+0.22E2H-0.33e3I+0.44E4J-0.55e5K+0.66E6L-0.77e7M+0.88E8N-0.99e9O+0.00E0P-0.11e1Q+0.22E2R-0.33e3S+0.44E4T-0.55e5U+0.66E6V-0.77e7W+0.88E8X-0.99e9Y+0.00E0Z-0.11e1[+0.22E2\-0.33e3]+0.44E4^-0.55e5_+0.66E6`-0.77e7a+0.88E8b-0.99e9c+0.00E0d-0.11e1e+0.22E2f-0.33e3g+0.44E4h-0.55e5i+0.66E6j-0.77e7k+0.88E8l-0.99e9m+0.00E0n-0.11e1o+0.22E2p-0.33e3q+0.44E4r-0.55e5s+0.66E6t-0.77e7u+0.88E8v-0.99e9w+0.00E0x-0.11e1y+0.22E2z-0.33e3{+0.44E4|-0.55e5}+0.66E6~-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.66E6-0.77e7+0.88E8-0.99e9+0.00E0-0.11e1+0.22E2-0.33e3+0.44E4-0.55e5+0.00E -0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e	+0.00E
-0.11e+0.22E-0.33e
+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E -0.33e!+0.44E"-0.55e#+0.66E$-0.77e%+0.88E&-0.99e'+0.00E(-0.11e)+0.22E*-0.33e,+0.44E.-0.55e/+0.66E:-0.77e;+0.88E<-0.99e=+0.00E>-0.11e?+0.22E@-0.33eA+0.44EB-0.55eC+0.66ED-0.77eE+0.88EF-0.99eG+0.00EH-0.11eI+0.22EJ-0.33eK+0.44EL-0.55eM+0.66EN-0.77eO+0.88EP-0.99eQ+0.00ER-0.11eS+0.22ET-0.33eU+0.44EV-0.55eW+0.66EX-0.77eY+0.88EZ-0.99e[+0.00E\-0.11e]+0.22E^-0.33e_+0.44E`-0.55ea+0.66Eb-0.77ec+0.88Ed-0.99ee+0.00Ef-0.11eg+0.22Eh-0.33ei+0.44Ej-0.55ek+0.66El-0.77em+0.88En-0.99eo+0.00Ep-0.11eq+0.22Er-0.33es+0.44Et-0.55eu+0.66Ev-0.77ew+0.88Ex-0.99ey+0.00Ez-0.11e{+0.22E|-0.33e}+0.44E~-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.44E-0.55e+0.66E-0.77e+0.88E-0.99e+0.00E-0.11e+0.22E-0.33e+0.00 -0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99	+0.00
-0.11+0.22-0.33
+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22 -0.33!+0.44"-0.55#+0.66$-0.77%+0.88&-0.99'+0.00(-0.11)+0.22*-0.33++0.44,-0.55-+0.66.-0.77/+0.88:-0.99;+0.00<-0.11=+0.22>-0.33?+0.44@-0.55A+0.66B-0.77C+0.88D-0.99F+0.00G-0.11H+0.22I-0.33J+0.44K-0.55L+0.66M-0.77N+0.88O-0.99P+0.00Q-0.11R+0.22S-0.33T+0.44U-0.55V+0.66W-0.77X+0.88Y-0.99Z+0.00[-0.11\+0.22]-0.33^+0.44_-0.55`+0.66a-0.77b+0.88c-0.99d+0.00f-0.11g+0.22h-0.33i+0.44j-0.55k+0.66l-0.77m+0.88n-0.99o+0.00p-0.11q+0.22r-0.33s+0.44t-0.55u+0.66v-0.77w+0.88x-0.99y+0.00z-0.11{+0.22|-0.33}+0.44~-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.44-0.55+0.66-0.77+0.88-0.99+0.00-0.11+0.22-0.33+0.0E+0 -0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9	+0.0E+0
-0.1e-1+0.2E+2-0.3e-3
+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2 -0.3e-3!+0.4E+4"-0.5e-5#+0.6E+6$-0.7e-7%+0.8E+8&-0.9e-9'+0.0E+0(-0.1e-1)+0.2E+2*-0.3e-3++0.4E+4,-0.5e-5-+0.6E+6.-0.7e-7/+0.8E+8:-0.9e-9;+0.0E+0<-0.1e-1=+0.2E+2>-0.3e-3?+0.4E+4@-0.5e-5A+0.6E+6B-0.7e-7C+0.8E+8D-0.9e-9E+0.0E+0F-0.1e-1G+0.2E+2H-0.3e-3I+0.4E+4J-0.5e-5K+0.6E+6L-0.7e-7M+0.8E+8N-0.9e-9O+0.0E+0P-0.1e-1Q+0.2E+2R-0.3e-3S+0.4E+4T-0.5e-5U+0.6E+6V-0.7e-7W+0.8E+8X-0.9e-9Y+0.0E+0Z-0.1e-1[+0.2E+2\-0.3e-3]+0.4E+4^-0.5e-5_+0.6E+6`-0.7e-7a+0.8E+8b-0.9e-9c+0.0E+0d-0.1e-1e+0.2E+2f-0.3e-3g+0.4E+4h-0.5e-5i+0.6E+6j-0.7e-7k+0.8E+8l-0.9e-9m+0.0E+0n-0.1e-1o+0.2E+2p-0.3e-3q+0.4E+4r-0.5e-5s+0.6E+6t-0.7e-7u+0.8E+8v-0.9e-9w+0.0E+0x-0.1e-1y+0.2E+2z-0.3e-3{+0.4E+4|-0.5e-5}+0.6E+6~-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.6E+6-0.7e-7+0.8E+8-0.9e-9+0.0E+0-0.1e-1+0.2E+2-0.3e-3+0.4E+4-0.5e-5+0.0 -0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9	+0.0
-0.1+0.2-0.3
+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2 -0.3!+0.4"-0.5#+0.6$-0.7%+0.8&-0.9'+0.0(-0.1)+0.2*-0.3++0.4,-0.5-+0.6.-0.7/+0.8:-0.9;+0.0<-0.1=+0.2>-0.3?+0.4@-0.5A+0.6B-0.7C+0.8D-0.9F+0.0G-0.1H+0.2I-0.3J+0.4K-0.5L+0.6M-0.7N+0.8O-0.9P+0.0Q-0.1R+0.2S-0.3T+0.4U-0.5V+0.6W-0.7X+0.8Y-0.9Z+0.0[-0.1\+0.2]-0.3^+0.4_-0.5`+0.6a-0.7b+0.8c-0.9d+0.0f-0.1g+0.2h-0.3i+0.4j-0.5k+0.6l-0.7m+0.8n-0.9o+0.0p-0.1q+0.2r-0.3s+0.4t-0.5u+0.6v-0.7w+0.8x-0.9y+0.0z-0.1{+0.2|-0.3}+0.4~-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.4-0.5+0.6-0.7+0.8-0.9+0.0-0.1+0.2-0.3+0.E+00 -0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99	+0.E+00
-0.e-11+0.E+22-0.e-33
+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22 -0.e-33!+0.E+44"-0.e-55#+0.E+66$-0.e-77%+0.E+88&-0.e-99'+0.E+00(-0.e-11)+0.E+22*-0.e-33++0.E+44,-0.e-55-+0.E+66.-0.e-77/+0.E+88:-0.e-99;+0.E+00<-0.e-11=+0.E+22>-0.e-33?+0.E+44@-0.e-55A+0.E+66B-0.e-77C+0.E+88D-0.e-99E+0.E+00F-0.e-11G+0.E+22H-0.e-33I+0.E+44J-0.e-55K+0.E+66L-0.e-77M+0.E+88N-0.e-99O+0.E+00P-0.e-11Q+0.E+22R-0.e-33S+0.E+44T-0.e-55U+0.E+66V-0.e-77W+0.E+88X-0.e-99Y+0.E+00Z-0.e-11[+0.E+22\-0.e-33]+0.E+44^-0.e-55_+0.E+66`-0.e-77a+0.E+88b-0.e-99c+0.E+00d-0.e-11e+0.E+22f-0.e-33g+0.E+44h-0.e-55i+0.E+66j-0.e-77k+0.E+88l-0.e-99m+0.E+00n-0.e-11o+0.E+22p-0.e-33q+0.E+44r-0.e-55s+0.E+66t-0.e-77u+0.E+88v-0.e-99w+0.E+00x-0.e-11y+0.E+22z-0.e-33{+0.E+44|-0.e-55}+0.E+66~-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+66-0.e-77+0.E+88-0.e-99+0.E+00-0.e-11+0.E+22-0.e-33+0.E+44-0.e-55+0.E+0 -0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9	+0.E+0
-0.e-1+0.E+2-0.e-3
+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2 -0.e-3!+0.E+4"-0.e-5#+0.E+6$-0.e-7%+0.E+8&-0.e-9'+0.E+0(-0.e-1)+0.E+2*-0.e-3++0.E+4,-0.e-5-+0.E+6.-0.e-7/+0.E+8:-0.e-9;+0.E+0<-0.e-1=+0.E+2>-0.e-3?+0.E+4@-0.e-5A+0.E+6B-0.e-7C+0.E+8D-0.e-9E+0.E+0F-0.e-1G+0.E+2H-0.e-3I+0.E+4J-0.e-5K+0.E+6L-0.e-7M+0.E+8N-0.e-9O+0.E+0P-0.e-1Q+0.E+2R-0.e-3S+0.E+4T-0.e-5U+0.E+6V-0.e-7W+0.E+8X-0.e-9Y+0.E+0Z-0.e-1[+0.E+2\-0.e-3]+0.E+4^-0.e-5_+0.E+6`-0.e-7a+0.E+8b-0.e-9c+0.E+0d-0.e-1e+0.E+2f-0.e-3g+0.E+4h-0.e-5i+0.E+6j-0.e-7k+0.E+8l-0.e-9m+0.E+0n-0.e-1o+0.E+2p-0.e-3q+0.E+4r-0.e-5s+0.E+6t-0.e-7u+0.E+8v-0.e-9w+0.E+0x-0.e-1y+0.E+2z-0.e-3{+0.E+4|-0.e-5}+0.E+6~-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+6-0.e-7+0.E+8-0.e-9+0.E+0-0.e-1+0.E+2-0.e-3+0.E+4-0.e-5+0.E+ -0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-	+0.E+
-0.e-+0.E+-0.e-
+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+ -0.e-!+0.E+"-0.e-#+0.E+$-0.e-%+0.E+&-0.e-'+0.E+(-0.e-)+0.E+*-0.e-++0.E+,-0.e--+0.E+.-0.e-/+0.E+:-0.e-;+0.E+<-0.e-=+0.E+>-0.e-?+0.E+@-0.e-A+0.E+B-0.e-C+0.E+D-0.e-E+0.E+F-0.e-G+0.E+H-0.e-I+0.E+J-0.e-K+0.E+L-0.e-M+0.E+N-0.e-O+0.E+P-0.e-Q+0.E+R-0.e-S+0.E+T-0.e-U+0.E+V-0.e-W+0.E+X-0.e-Y+0.E+Z-0.e-[+0.E+\-0.e-]+0.E+^-0.e-_+0.E+`-0.e-a+0.E+b-0.e-c+0.E+d-0.e-e+0.E+f-0.e-g+0.E+h-0.e-i+0.E+j-0.e-k+0.E+l-0.e-m+0.E+n-0.e-o+0.E+p-0.e-q+0.E+r-0.e-s+0.E+t-0.e-u+0.E+v-0.e-w+0.E+x-0.e-y+0.E+z-0.e-{+0.E+|-0.e-}+0.E+~-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E+-0.e-+0.E0 -0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9	+0.E0
-0.e1+0.E2-0.e3
+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2 -0.e3!+0.E4"-0.e5#+0.E6$-0.e7%+0.E8&-0.e9'+0.E0(-0.e1)+0.E2*-0.e3++0.E4,-0.e5-+0.E6.-0.e7/+0.E8:-0.e9;+0.E0<-0.e1=+0.E2>-0.e3?+0.E4@-0.e5A+0.E6B-0.e7C+0.E8D-0.e9E+0.E0F-0.e1G+0.E2H-0.e3I+0.E4J-0.e5K+0.E6L-0.e7M+0.E8N-0.e9O+0.E0P-0.e1Q+0.E2R-0.e3S+0.E4T-0.e5U+0.E6V-0.e7W+0.E8X-0.e9Y+0.E0Z-0.e1[+0.E2\-0.e3]+0.E4^-0.e5_+0.E6`-0.e7a+0.E8b-0.e9c+0.E0d-0.e1e+0.E2f-0.e3g+0.E4h-0.e5i+0.E6j-0.e7k+0.E8l-0.e9m+0.E0n-0.e1o+0.E2p-0.e3q+0.E4r-0.e5s+0.E6t-0.e7u+0.E8v-0.e9w+0.E0x-0.e1y+0.E2z-0.e3{+0.E4|-0.e5}+0.E6~-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E6-0.e7+0.E8-0.e9+0.E0-0.e1+0.E2-0.e3+0.E4-0.e5+0.E -0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e	+0.E
-0.e+0.E-0.e
+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E -0.e!+0.E"-0.e#+0.E$-0.e%+0.E&-0.e'+0.E(-0.e)+0.E*-0.e,+0.E.-0.e/+0.E:-0.e;+0.E<-0.e=+0.E>-0.e?+0.E@-0.eA+0.EB-0.eC+0.ED-0.eE+0.EF-0.eG+0.EH-0.eI+0.EJ-0.eK+0.EL-0.eM+0.EN-0.eO+0.EP-0.eQ+0.ER-0.eS+0.ET-0.eU+0.EV-0.eW+0.EX-0.eY+0.EZ-0.e[+0.E\-0.e]+0.E^-0.e_+0.E`-0.ea+0.Eb-0.ec+0.Ed-0.ee+0.Ef-0.eg+0.Eh-0.ei+0.Ej-0.ek+0.El-0.em+0.En-0.eo+0.Ep-0.eq+0.Er-0.es+0.Et-0.eu+0.Ev-0.ew+0.Ex-0.ey+0.Ez-0.e{+0.E|-0.e}+0.E~-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0.E-0.e+0. -0.+0.-0.+0.-0.+0.-0.+0.-0.	+0.
-0.+0.-0.
+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0. -0.!+0."-0.#+0.$-0.%+0.&-0.'+0.(-0.)+0.*-0.++0.,-0.-+0..-0./+0.:-0.;+0.<-0.=+0.>-0.?+0.@-0.A+0.B-0.C+0.D-0.F+0.G-0.H+0.I-0.J+0.K-0.L+0.M-0.N+0.O-0.P+0.Q-0.R+0.S-0.T+0.U-0.V+0.W-0.X+0.Y-0.Z+0.[-0.\+0.]-0.^+0._-0.`+0.a-0.b+0.c-0.d+0.f-0.g+0.h-0.i+0.j-0.k+0.l-0.m+0.n-0.o+0.p-0.q+0.r-0.s+0.t-0.u+0.v-0.w+0.x-0.y+0.z-0.{+0.|-0.}+0.~-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+0.-0.+00.0E+0 -01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9	+00.0E+0
-01.1e-1+02.2E+2-03.3e-3
+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2 -03.3e-3!+04.4E+4"-05.5e-5#+06.6E+6$-07.7e-7%+08.8E+8&-09.9e-9'+00.0E+0(-01.1e-1)+02.2E+2*-03.3e-3++04.4E+4,-05.5e-5-+06.6E+6.-07.7e-7/+08.8E+8:-09.9e-9;+00.0E+0<-01.1e-1=+02.2E+2>-03.3e-3?+04.4E+4@-05.5e-5A+06.6E+6B-07.7e-7C+08.8E+8D-09.9e-9E+00.0E+0F-01.1e-1G+02.2E+2H-03.3e-3I+04.4E+4J-05.5e-5K+06.6E+6L-07.7e-7M+08.8E+8N-09.9e-9O+00.0E+0P-01.1e-1Q+02.2E+2R-03.3e-3S+04.4E+4T-05.5e-5U+06.6E+6V-07.7e-7W+08.8E+8X-09.9e-9Y+00.0E+0Z-01.1e-1[+02.2E+2\-03.3e-3]+04.4E+4^-05.5e-5_+06.6E+6`-07.7e-7a+08.8E+8b-09.9e-9c+00.0E+0d-01.1e-1e+02.2E+2f-03.3e-3g+04.4E+4h-05.5e-5i+06.6E+6j-07.7e-7k+08.8E+8l-09.9e-9m+00.0E+0n-01.1e-1o+02.2E+2p-03.3e-3q+04.4E+4r-05.5e-5s+06.6E+6t-07.7e-7u+08.8E+8v-09.9e-9w+00.0E+0x-01.1e-1y+02.2E+2z-03.3e-3{+04.4E+4|-05.5e-5}+06.6E+6~-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+06.6E+6-07.7e-7+08.8E+8-09.9e-9+00.0E+0-01.1e-1+02.2E+2-03.3e-3+04.4E+4-05.5e-5+000.0E+0 -011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9	+000.0E+0
-011.1e-1+022.2E+2-033.3e-3
+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2 -033.3e-3!+044.4E+4"-055.5e-5#+066.6E+6$-077.7e-7%+088.8E+8&-099.9e-9'+000.0E+0(-011.1e-1)+022.2E+2*-033.3e-3++044.4E+4,-055.5e-5-+066.6E+6.-077.7e-7/+088.8E+8:-099.9e-9;+000.0E+0<-011.1e-1=+022.2E+2>-033.3e-3?+044.4E+4@-055.5e-5A+066.6E+6B-077.7e-7C+088.8E+8D-099.9e-9E+000.0E+0F-011.1e-1G+022.2E+2H-033.3e-3I+044.4E+4J-055.5e-5K+066.6E+6L-077.7e-7M+088.8E+8N-099.9e-9O+000.0E+0P-011.1e-1Q+022.2E+2R-033.3e-3S+044.4E+4T-055.5e-5U+066.6E+6V-077.7e-7W+088.8E+8X-099.9e-9Y+000.0E+0Z-011.1e-1[+022.2E+2\-033.3e-3]+044.4E+4^-055.5e-5_+066.6E+6`-077.7e-7a+088.8E+8b-099.9e-9c+000.0E+0d-011.1e-1e+022.2E+2f-033.3e-3g+044.4E+4h-055.5e-5i+066.6E+6j-077.7e-7k+088.8E+8l-099.9e-9m+000.0E+0n-011.1e-1o+022.2E+2p-033.3e-3q+044.4E+4r-055.5e-5s+066.6E+6t-077.7e-7u+088.8E+8v-099.9e-9w+000.0E+0x-011.1e-1y+022.2E+2z-033.3e-3{+044.4E+4|-055.5e-5}+066.6E+6~-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+066.6E+6-077.7e-7+088.8E+8-099.9e-9+000.0E+0-011.1e-1+022.2E+2-033.3e-3+044.4E+4-055.5e-5+00E+00 -01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99	+00E+00
-01e-11+02E+22-03e-33
+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22 -03e-33!+04E+44"-05e-55#+06E+66$-07e-77%+08E+88&-09e-99'+00E+00(-01e-11)+02E+22*-03e-33++04E+44,-05e-55-+06E+66.-07e-77/+08E+88:-09e-99;+00E+00<-01e-11=+02E+22>-03e-33?+04E+44@-05e-55A+06E+66B-07e-77C+08E+88D-09e-99E+00E+00F-01e-11G+02E+22H-03e-33I+04E+44J-05e-55K+06E+66L-07e-77M+08E+88N-09e-99O+00E+00P-01e-11Q+02E+22R-03e-33S+04E+44T-05e-55U+06E+66V-07e-77W+08E+88X-09e-99Y+00E+00Z-01e-11[+02E+22\-03e-33]+04E+44^-05e-55_+06E+66`-07e-77a+08E+88b-09e-99c+00E+00d-01e-11e+02E+22f-03e-33g+04E+44h-05e-55i+06E+66j-07e-77k+08E+88l-09e-99m+00E+00n-01e-11o+02E+22p-03e-33q+04E+44r-05e-55s+06E+66t-07e-77u+08E+88v-09e-99w+00E+00x-01e-11y+02E+22z-03e-33{+04E+44|-05e-55}+06E+66~-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+06E+66-07e-77+08E+88-09e-99+00E+00-01e-11+02E+22-03e-33+04E+44-05e-55+00E+0 -01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9	+00E+0
-01e-1+02E+2-03e-3
+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2 -03e-3!+04E+4"-05e-5#+06E+6$-07e-7%+08E+8&-09e-9'+00E+0(-01e-1)+02E+2*-03e-3++04E+4,-05e-5-+06E+6.-07e-7/+08E+8:-09e-9;+00E+0<-01e-1=+02E+2>-03e-3?+04E+4@-05e-5A+06E+6B-07e-7C+08E+8D-09e-9E+00E+0F-01e-1G+02E+2H-03e-3I+04E+4J-05e-5K+06E+6L-07e-7M+08E+8N-09e-9O+00E+0P-01e-1Q+02E+2R-03e-3S+04E+4T-05e-5U+06E+6V-07e-7W+08E+8X-09e-9Y+00E+0Z-01e-1[+02E+2\-03e-3]+04E+4^-05e-5_+06E+6`-07e-7a+08E+8b-09e-9c+00E+0d-01e-1e+02E+2f-03e-3g+04E+4h-05e-5i+06E+6j-07e-7k+08E+8l-09e-9m+00E+0n-01e-1o+02E+2p-03e-3q+04E+4r-05e-5s+06E+6t-07e-7u+08E+8v-09e-9w+00E+0x-01e-1y+02E+2z-03e-3{+04E+4|-05e-5}+06E+6~-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+06E+6-07e-7+08E+8-09e-9+00E+0-01e-1+02E+2-03e-3+04E+4-05e-5+00E+ -01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-	+00E+
-01e-+02E+-03e-
+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+ -03e-!+04E+"-05e-#+06E+$-07e-%+08E+&-09e-'+00E+(-01e-)+02E+*-03e-++04E+,-05e--+06E+.-07e-/+08E+:-09e-;+00E+<-01e-=+02E+>-03e-?+04E+@-05e-A+06E+B-07e-C+08E+D-09e-E+00E+F-01e-G+02E+H-03e-I+04E+J-05e-K+06E+L-07e-M+08E+N-09e-O+00E+P-01e-Q+02E+R-03e-S+04E+T-05e-U+06E+V-07e-W+08E+X-09e-Y+00E+Z-01e-[+02E+\-03e-]+04E+^-05e-_+06E+`-07e-a+08E+b-09e-c+00E+d-01e-e+02E+f-03e-g+04E+h-05e-i+06E+j-07e-k+08E+l-09e-m+00E+n-01e-o+02E+p-03e-q+04E+r-05e-s+06E+t-07e-u+08E+v-09e-w+00E+x-01e-y+02E+z-03e-{+04E+|-05e-}+06E+~-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+06E+-07e-+08E+-09e-+00E+-01e-+02E+-03e-+04E+-05e-+00E0 -01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9	+00E0
-01e1+02E2-03e3
+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2 -03e3!+04E4"-05e5#+06E6$-07e7%+08E8&-09e9'+00E0(-01e1)+02E2*-03e3++04E4,-05e5-+06E6.-07e7/+08E8:-09e9;+00E0<-01e1=+02E2>-03e3?+04E4@-05e5A+06E6B-07e7C+08E8D-09e9E+00E0F-01e1G+02E2H-03e3I+04E4J-05e5K+06E6L-07e7M+08E8N-09e9O+00E0P-01e1Q+02E2R-03e3S+04E4T-05e5U+06E6V-07e7W+08E8X-09e9Y+00E0Z-01e1[+02E2\-03e3]+04E4^-05e5_+06E6`-07e7a+08E8b-09e9c+00E0d-01e1e+02E2f-03e3g+04E4h-05e5i+06E6j-07e7k+08E8l-09e9m+00E0n-01e1o+02E2p-03e3q+04E4r-05e5s+06E6t-07e7u+08E8v-09e9w+00E0x-01e1y+02E2z-03e3{+04E4|-05e5}+06E6~-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+06E6-07e7+08E8-09e9+00E0-01e1+02E2-03e3+04E4-05e5+00E -01e+02E-03e+04E-05e+06E-07e+08E-09e	+00E
-01e+02E-03e
+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E -03e!+04E"-05e#+06E$-07e%+08E&-09e'+00E(-01e)+02E*-03e,+04E.-05e/+06E:-07e;+08E<-09e=+00E>-01e?+02E@-03eA+04EB-05eC+06ED-07eE+08EF-09eG+00EH-01eI+02EJ-03eK+04EL-05eM+06EN-07eO+08EP-09eQ+00ER-01eS+02ET-03eU+04EV-05eW+06EX-07eY+08EZ-09e[+00E\-01e]+02E^-03e_+04E`-05ea+06Eb-07ec+08Ed-09ee+00Ef-01eg+02Eh-03ei+04Ej-05ek+06El-07em+08En-09eo+00Ep-01eq+02Er-03es+04Et-05eu+06Ev-07ew+08Ex-09ey+00Ez-01e{+02E|-03e}+04E~-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+04E-05e+06E-07e+08E-09e+00E-01e+02E-03e+00 -01+02-03+04-05+06-07+08-09	+00
-01+02-03
+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02 -03!+04"-05#+06$-07%+08&-09'+00(-01)+02*-03++04,-05-+06/-07:+08;-09<+00=-01>+02?-03@+04A-05B+06C-07D+08F-09G+00H-01I+02J-03K+04L-05M+06N-07O+08P-09Q+00R-01S+02T-03U+04V-05W+06X-07Y+08Z-09[+00\-01]+02^-03_+04`-05a+06b-07c+08d-09f+00g-01h+02i-03j+04k-05l+06m-07n+08o-09p+00q-01r+02s-03t+04u-05v+06w-07x+08y-09z+00{-01|+02}-03~+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02-03+04-05+06-07+08-09+00-01+02+0E+0 -0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9	+0E+0
-0e-1+0E+2-0e-3
+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2 -0e-3!+0E+4"-0e-5#+0E+6$-0e-7%+0E+8&-0e-9'+0E+0(-0e-1)+0E+2*-0e-3++0E+4,-0e-5-+0E+6.-0e-7/+0E+8:-0e-9;+0E+0<-0e-1=+0E+2>-0e-3?+0E+4@-0e-5A+0E+6B-0e-7C+0E+8D-0e-9E+0E+0F-0e-1G+0E+2H-0e-3I+0E+4J-0e-5K+0E+6L-0e-7M+0E+8N-0e-9O+0E+0P-0e-1Q+0E+2R-0e-3S+0E+4T-0e-5U+0E+6V-0e-7W+0E+8X-0e-9Y+0E+0Z-0e-1[+0E+2\-0e-3]+0E+4^-0e-5_+0E+6`-0e-7a+0E+8b-0e-9c+0E+0d-0e-1e+0E+2f-0e-3g+0E+4h-0e-5i+0E+6j-0e-7k+0E+8l-0e-9m+0E+0n-0e-1o+0E+2p-0e-3q+0E+4r-0e-5s+0E+6t-0e-7u+0E+8v-0e-9w+0E+0x-0e-1y+0E+2z-0e-3{+0E+4|-0e-5}+0E+6~-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0E+6-0e-7+0E+8-0e-9+0E+0-0e-1+0E+2-0e-3+0E+4-0e-5+0 -0+0-0+0-0+0-0+0-0	+0
-0+0-0
+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0 -0!+0"-0#+0$-0%+0&-0'+0(-0)+0*-0++0,-0-+0/-0:+0;-0<+0=-0>+0?-0@+0A-0B+0C-0D+0F-0G+0H-0I+0J-0K+0L-0M+0N-0O+0P-0Q+0R-0S+0T-0U+0V-0W+0X-0Y+0Z-0[+0\-0]+0^-0_+0`-0a+0b-0c+0d-0f+0g-0h+0i-0j+0k-0l+0m-0n+0o-0p+0q-0r+0s-0t+0u-0v+0w-0x+0y-0z+0{-0|+0}-0~+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0-0+0+10.0E+0 -21.1e-1+32.2E+2-43.3e-3+54.4E+4-65.5e-5+76.6E+6-87.7e-7+98.8E+8-19.9e-9	+20.0E+0
-31.1e-1+42.2E+2-53.3e-3
+64.4E+4-75.5e-5+86.6E+6-97.7e-7+18.8E+8-29.9e-9+30.0E+0-41.1e-1+52.2E+2-63.3e-3+74.4E+4-85.5e-5+96.6E+6-17.7e-7+28.8E+8-39.9e-9+40.0E+0-51.1e-1+62.2E+2 -73.3e-3!+84.4E+4"-95.5e-5#+16.6E+6$-27.7e-7%+38.8E+8&-49.9e-9'+50.0E+0(-61.1e-1)+72.2E+2*-83.3e-3++94.4E+4,-15.5e-5-+26.6E+6.-37.7e-7/+48.8E+8:-59.9e-9;+60.0E+0<-71.1e-1=+82.2E+2>-93.3e-3?+14.4E+4@-25.5e-5A+36.6E+6B-47.7e-7C+58.8E+8D-69.9e-9E+70.0E+0F-81.1e-1G+92.2E+2H-13.3e-3I+24.4E+4J-35.5e-5K+46.6E+6L-57.7e-7M+68.8E+8N-79.9e-9O+80.0E+0P-91.1e-1Q+12.2E+2R-23.3e-3S+34.4E+4T-45.5e-5U+56.6E+6V-67.7e-7W+78.8E+8X-89.9e-9Y+90.0E+0Z-11.1e-1[+22.2E+2\-33.3e-3]+44.4E+4^-55.5e-5_+66.6E+6`-77.7e-7a+88.8E+8b-99.9e-9c+10.0E+0d-21.1e-1e+32.2E+2f-43.3e-3g+54.4E+4h-65.5e-5i+76.6E+6j-87.7e-7k+98.8E+8l-19.9e-9m+20.0E+0n-31.1e-1o+42.2E+2p-53.3e-3q+64.4E+4r-75.5e-5s+86.6E+6t-97.7e-7u+18.8E+8v-29.9e-9w+30.0E+0x-41.1e-1y+52.2E+2z-63.3e-3{+74.4E+4|-85.5e-5}+96.6E+6~-17.7e-7+28.8E+8-39.9e-9+40.0E+0-51.1e-1+62.2E+2-73.3e-3+84.4E+4-95.5e-5+16.6E+6-27.7e-7+38.8E+8-49.9e-9+50.0E+0-61.1e-1+72.2E+2-83.3e-3+94.4E+4-15.5e-5+26.6E+6-37.7e-7+48.8E+8-59.9e-9+60.0E+0-71.1e-1+82.2E+2-93.3e-3+14.4E+4-25.5e-5+36.6E+6-47.7e-7+58.8E+8-69.9e-9+70.0E+0-81.1e-1+92.2E+2-13.3e-3+24.4E+4-35.5e-5+46.6E+6-57.7e-7+68.8E+8-79.9e-9+80.0E+0-91.1e-1+12.2E+2-23.3e-3+34.4E+4-45.5e-5+56.6E+6-67.7e-7+78.8E+8-89.9e-9+90.0E+0-11.1e-1+22.2E+2-33.3e-3+44.4E+4-55.5e-5+66.6E+6-77.7e-7+88.8E+8-99.9e-9+10.0E+0-21.1e-1+32.2E+2-43.3e-3+54.4E+4-65.5e-5+76.6E+6-87.7e-7+98.8E+8-19.9e-9+20.0E+0-31.1e-1+42.2E+2-53.3e-3+64.4E+4-75.5e-5+86.6E+6-97.7e-7+18.8E+8-29.9e-9+30.0E+0-41.1e-1+52.2E+2-63.3e-3+74.4E+4-85.5e-5+96.6E+6-17.7e-7+28.8E+8-39.9e-9+40.0E+0-51.1e-1+62.2E+2-73.3e-3+84.4E+4-95.5e-5+16.6E+6-27.7e-7+38.8E+8-49.9e-9+50.0E+0-61.1e-1+72.2E+2-83.3e-3+94.4E+4-15.5e-5+26.6E+6-37.7e-7+48.8E+8-59.9e-9+60.0E+0-71.1e-1+82.2E+2-93.3e-3+14.4E+4-25.5e-5+36.6E+6-47.7e-7+58.8E+8-69.9e-9+70.0E+0-81.1e-1+92.2E+2-13.3e-3+24.4E+4-35.5e-5+10E+0 -21e-1+32E+2-43e-3+54E+4-65e-5+76E+6-87e-7+98E+8-19e-9	+20E+0
-31e-1+42E+2-53e-3
+64E+4-75e-5+86E+6-97e-7+18E+8-29e-9+30E+0-41e-1+52E+2-63e-3+74E+4-85e-5+96E+6-17e-7+28E+8-39e-9+40E+0-51e-1+62E+2 -73e-3!+84E+4"-95e-5#+16E+6$-27e-7%+38E+8&-49e-9'+50E+0(-61e-1)+72E+2*-83e-3++94E+4,-15e-5-+26E+6.-37e-7/+48E+8:-59e-9;+60E+0<-71e-1=+82E+2>-93e-3?+14E+4@-25e-5A+36E+6B-47e-7C+58E+8D-69e-9E+70E+0F-81e-1G+92E+2H-13e-3I+24E+4J-35e-5K+46E+6L-57e-7M+68E+8N-79e-9O+80E+0P-91e-1Q+12E+2R-23e-3S+34E+4T-45e-5U+56E+6V-67e-7W+78E+8X-89e-9Y+90E+0Z-11e-1[+22E+2\-33e-3]+44E+4^-55e-5_+66E+6`-77e-7a+88E+8b-99e-9c+10E+0d-21e-1e+32E+2f-43e-3g+54E+4h-65e-5i+76E+6j-87e-7k+98E+8l-19e-9m+20E+0n-31e-1o+42E+2p-53e-3q+64E+4r-75e-5s+86E+6t-97e-7u+18E+8v-29e-9w+30E+0x-41e-1y+52E+2z-63e-3{+74E+4|-85e-5}+96E+6~-17e-7+28E+8-39e-9+40E+0-51e-1+62E+2-73e-3+84E+4-95e-5+16E+6-27e-7+38E+8-49e-9+50E+0-61e-1+72E+2-83e-3+94E+4-15e-5+26E+6-37e-7+48E+8-59e-9+60E+0-71e-1+82E+2-93e-3+14E+4-25e-5+36E+6-47e-7+58E+8-69e-9+70E+0-81e-1+92E+2-13e-3+24E+4-35e-5+46E+6-57e-7+68E+8-79e-9+80E+0-91e-1+12E+2-23e-3+34E+4-45e-5+56E+6-67e-7+78E+8-89e-9+90E+0-11e-1+22E+2-33e-3+44E+4-55e-5+66E+6-77e-7+88E+8-99e-9+10E+0-21e-1+32E+2-43e-3+54E+4-65e-5+76E+6-87e-7+98E+8-19e-9+20E+0-31e-1+42E+2-53e-3+64E+4-75e-5+86E+6-97e-7+18E+8-29e-9+30E+0-41e-1+52E+2-63e-3+74E+4-85e-5+96E+6-17e-7+28E+8-39e-9+40E+0-51e-1+62E+2-73e-3+84E+4-95e-5+16E+6-27e-7+38E+8-49e-9+50E+0-61e-1+72E+2-83e-3+94E+4-15e-5+26E+6-37e-7+48E+8-59e-9+60E+0-71e-1+82E+2-93e-3+14E+4-25e-5+36E+6-47e-7+58E+8-69e-9+70E+0-81e-1+92E+2-13e-3+24E+4-35e-5+10 -21+32-43+54-65+76-87+98-19	+20
-31+42-53
+64-75+86-97+18-29+30-41+52-63+74-85+96-17+28-39+40-51+62 -73!+84"-95#+16$-27%+38&-49'+50(-61)+72*-83++94,-15-+26/-37:+48;-59<+60=-71>+82?-93@+14A-25B+36C-47D+58F-69G+70H-81I+92J-13K+24L-35M+46N-57O+68P-79Q+80R-91S+12T-23U+34V-45W+56X-67Y+78Z-89[+90\-11]+22^-33_+44`-55a+66b-77c+88d-99f+10g-21h+32i-43j+54k-65l+76m-87n+98o-19p+20q-31r+42s-53t+64u-75v+86w-97x+18y-29z+30{-41|+52}-63~+74-85+96-17+28-39+40-51+62-73+84-95+16-27+38-49+50-61+72-83+94-15+26-37+48-59+60-71+82-93+14-25+36-47+58-69+70-81+92-13+24-35+46-57+68-79+80-91+12-23+34-45+56-67+78-89+90-11+22-33+44-55+66-77+88-99+10-21+32-43+54-65+76-87+98-19+20-31+42-53+64-75+86-97+18-29+30-41+52-63+74-85+96-17+28-39+40-51+62-73+84-95+16-27+38-49+50-61+72-83+94-15+26-37+48-59+60-71+82-93+14-25+36-47+58-69+70-81+92+1.0E+0 -2.1e-1+3.2E+2-4.3e-3+5.4E+4-6.5e-5+7.6E+6-8.7e-7+9.8E+8-1.9e-9	+2.0E+0
-3.1e-1+4.2E+2-5.3e-3
+6.4E+4-7.5e-5+8.6E+6-9.7e-7+1.8E+8-2.9e-9+3.0E+0-4.1e-1+5.2E+2-6.3e-3+7.4E+4-8.5e-5+9.6E+6-1.7e-7+2.8E+8-3.9e-9+4.0E+0-5.1e-1+6.2E+2 -7.3e-3!+8.4E+4"-9.5e-5#+1.6E+6$-2.7e-7%+3.8E+8&-4.9e-9'+5.0E+0(-6.1e-1)+7.2E+2*-8.3e-3++9.4E+4,-1.5e-5-+2.6E+6.-3.7e-7/+4.8E+8:-5.9e-9;+6.0E+0<-7.1e-1=+8.2E+2>-9.3e-3?+1.4E+4@-2.5e-5A+3.6E+6B-4.7e-7C+5.8E+8D-6.9e-9E+7.0E+0F-8.1e-1G+9.2E+2H-1.3e-3I+2.4E+4J-3.5e-5K+4.6E+6L-5.7e-7M+6.8E+8N-7.9e-9O+8.0E+0P-9.1e-1Q+1.2E+2R-2.3e-3S+3.4E+4T-4.5e-5U+5.6E+6V-6.7e-7W+7.8E+8X-8.9e-9Y+9.0E+0Z-1.1e-1[+2.2E+2\-3.3e-3]+4.4E+4^-5.5e-5_+6.6E+6`-7.7e-7a+8.8E+8b-9.9e-9c+1.0E+0d-2.1e-1e+3.2E+2f-4.3e-3g+5.4E+4h-6.5e-5i+7.6E+6j-8.7e-7k+9.8E+8l-1.9e-9m+2.0E+0n-3.1e-1o+4.2E+2p-5.3e-3q+6.4E+4r-7.5e-5s+8.6E+6t-9.7e-7u+1.8E+8v-2.9e-9w+3.0E+0x-4.1e-1y+5.2E+2z-6.3e-3{+7.4E+4|-8.5e-5}+9.6E+6~-1.7e-7+2.8E+8-3.9e-9+4.0E+0-5.1e-1+6.2E+2-7.3e-3+8.4E+4-9.5e-5+1.6E+6-2.7e-7+3.8E+8-4.9e-9+5.0E+0-6.1e-1+7.2E+2-8.3e-3+9.4E+4-1.5e-5+2.6E+6-3.7e-7+4.8E+8-5.9e-9+6.0E+0-7.1e-1+8.2E+2-9.3e-3+1.4E+4-2.5e-5+3.6E+6-4.7e-7+5.8E+8-6.9e-9+7.0E+0-8.1e-1+9.2E+2-1.3e-3+2.4E+4-3.5e-5+4.6E+6-5.7e-7+6.8E+8-7.9e-9+8.0E+0-9.1e-1+1.2E+2-2.3e-3+3.4E+4-4.5e-5+5.6E+6-6.7e-7+7.8E+8-8.9e-9+9.0E+0-1.1e-1+2.2E+2-3.3e-3+4.4E+4-5.5e-5+6.6E+6-7.7e-7+8.8E+8-9.9e-9+1.0E+0-2.1e-1+3.2E+2-4.3e-3+5.4E+4-6.5e-5+7.6E+6-8.7e-7+9.8E+8-1.9e-9+2.0E+0-3.1e-1+4.2E+2-5.3e-3+6.4E+4-7.5e-5+8.6E+6-9.7e-7+1.8E+8-2.9e-9+3.0E+0-4.1e-1+5.2E+2-6.3e-3+7.4E+4-8.5e-5+9.6E+6-1.7e-7+2.8E+8-3.9e-9+4.0E+0-5.1e-1+6.2E+2-7.3e-3+8.4E+4-9.5e-5+1.6E+6-2.7e-7+3.8E+8-4.9e-9+5.0E+0-6.1e-1+7.2E+2-8.3e-3+9.4E+4-1.5e-5+2.6E+6-3.7e-7+4.8E+8-5.9e-9+6.0E+0-7.1e-1+8.2E+2-9.3e-3+1.4E+4-2.5e-5+3.6E+6-4.7e-7+5.8E+8-6.9e-9+7.0E+0-8.1e-1+9.2E+2-1.3e-3+2.4E+4-3.5e-5+1E+0 -2e-1+3E+2-4e-3+5E+4-6e-5+7E+6-8e-7+9E+8-1e-9	+2E+0
-3e-1+4E+2-5e-3
+6E+4-7e-5+8E+6-9e-7+1E+8-2e-9+3E+0-4e-1+5E+2-6e-3+7E+4-8e-5+9E+6-1e-7+2E+8-3e-9+4E+0-5e-1+6E+2 -7e-3!+8E+4"-9e-5#+1E+6$-2e-7%+3E+8&-4e-9'+5E+0(-6e-1)+7E+2*-8e-3++9E+4,-1e-5-+2E+6.-3e-7/+4E+8:-5e-9;+6E+0<-7e-1=+8E+2>-9e-3?+1E+4@-2e-5A+3E+6B-4e-7C+5E+8D-6e-9E+7E+0F-8e-1G+9E+2H-1e-3I+2E+4J-3e-5K+4E+6L-5e-7M+6E+8N-7e-9O+8E+0P-9e-1Q+1E+2R-2e-3S+3E+4T-4e-5U+5E+6V-6e-7W+7E+8X-8e-9Y+9E+0Z-1e-1[+2E+2\-3e-3]+4E+4^-5e-5_+6E+6`-7e-7a+8E+8b-9e-9c+1E+0d-2e-1e+3E+2f-4e-3g+5E+4h-6e-5i+7E+6j-8e-7k+9E+8l-1e-9m+2E+0n-3e-1o+4E+2p-5e-3q+6E+4r-7e-5s+8E+6t-9e-7u+1E+8v-2e-9w+3E+0x-4e-1y+5E+2z-6e-3{+7E+4|-8e-5}+9E+6~-1e-7+2E+8-3e-9+4E+0-5e-1+6E+2-7e-3+8E+4-9e-5+1E+6-2e-7+3E+8-4e-9+5E+0-6e-1+7E+2-8e-3+9E+4-1e-5+2E+6-3e-7+4E+8-5e-9+6E+0-7e-1+8E+2-9e-3+1E+4-2e-5+3E+6-4e-7+5E+8-6e-9+7E+0-8e-1+9E+2-1e-3+2E+4-3e-5+4E+6-5e-7+6E+8-7e-9+8E+0-9e-1+1E+2-2e-3+3E+4-4e-5+5E+6-6e-7+7E+8-8e-9+9E+0-1e-1+2E+2-3e-3+4E+4-5e-5+6E+6-7e-7+8E+8-9e-9+1E+0-2e-1+3E+2-4e-3+5E+4-6e-5+7E+6-8e-7+9E+8-1e-9+2E+0-3e-1+4E+2-5e-3+6E+4-7e-5+8E+6-9e-7+1E+8-2e-9+3E+0-4e-1+5E+2-6e-3+7E+4-8e-5+9E+6-1e-7+2E+8-3e-9+4E+0-5e-1+6E+2-7e-3+8E+4-9e-5+1E+6-2e-7+3E+8-4e-9+5E+0-6e-1+7E+2-8e-3+9E+4-1e-5+2E+6-3e-7+4E+8-5e-9+6E+0-7e-1+8E+2-9e-3+1E+4-2e-5+3E+6-4e-7+5E+8-6e-9+7E+0-8e-1+9E+2-1e-3+2E+4-3e-5+1 -2+3-4+5-6+7-8+9-1	+2
-3+4-5
+6-7+8-9+1-2+3-4+5-6+7-8+9-1+2-3+4-5+6 -7!+8"-9#+1$-2%+3&-4'+5(-6)+7*-8++9,-1-+2/-3:+4;-5<+6=-7>+8?-9@+1A-2B+3C-4D+5F-6G+7H-8I+9J-1K+2L-3M+4N-5O+6P-7Q+8R-9S+1T-2U+3V-4W+5X-6Y+7Z-8[+9\-1]+2^-3_+4`-5a+6b-7c+8d-9f+1g-2h+3i-4j+5k-6l+7m-8n+9o-1p+2q-3r+4s-5t+6u-7v+8w-9x+1y-2z+3{-4|+5}-6~+7-8+9-1+2-3+4-5+6-7+8-9+1-2+3-4+5-6+7-8+9-1+2-3+4-5+6-7+8-9+1-2+3-4+5-6+7-8+9-1+2-3+4-5+6-7+8-9+1-2+3-4+5-6+7-8+9-1+2-3+4-5+6-7+8-9+1-2+3-4+5-6+7-8+9-1+2-3+4-5+6-7+8-9+1-2+3-4+5-6+7-8+9-1+2-3+4-5+6-7+8-9+1-2+3-4+5-6+7-8+9-1+2-3+4-5+6-7+8-9+1-2+3-4+5-6+7-8+9+ -+-+-+-+-	+
-+-
+-+-+-+-+-+-+-+-+-+ -!+"-#+$-%+&-'+(-)+*-++,--+/-:+;-<+=->+?-@+A-B+C-D+E-F+G-H+I-J+K-L+M-N+O-P+Q-R+S-T+U-V+W-X+Y-Z+[-\+]-^+_-`+a-b+c-d+e-f+g-h+i-j+k-l+m-n+o-p+q-r+s-t+u-v+w-x+y-z+{-|+}-~+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+,.0E+0 .1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9	.0E+0
.1e-1.2E+2.3e-3
.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2 .3e-3!.4E+4".5e-5#.6E+6$.7e-7%.8E+8&.9e-9'.0E+0(.1e-1).2E+2*.3e-3+.4E+4,.5e-5-.6E+6..7e-7/.8E+8:.9e-9;.0E+0<.1e-1=.2E+2>.3e-3?.4E+4@.5e-5A.6E+6B.7e-7C.8E+8D.9e-9E.0E+0F.1e-1G.2E+2H.3e-3I.4E+4J.5e-5K.6E+6L.7e-7M.8E+8N.9e-9O.0E+0P.1e-1Q.2E+2R.3e-3S.4E+4T.5e-5U.6E+6V.7e-7W.8E+8X.9e-9Y.0E+0Z.1e-1[.2E+2\.3e-3].4E+4^.5e-5_.6E+6`.7e-7a.8E+8b.9e-9c.0E+0d.1e-1e.2E+2f.3e-3g.4E+4h.5e-5i.6E+6j.7e-7k.8E+8l.9e-9m.0E+0n.1e-1o.2E+2p.3e-3q.4E+4r.5e-5s.6E+6t.7e-7u.8E+8v.9e-9w.0E+0x.1e-1y.2E+2z.3e-3{.4E+4|.5e-5}.6E+6~.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5.6E+6.7e-7.8E+8.9e-9.0E+0.1e-1.2E+2.3e-3.4E+4.5e-5. .........	.
...
................... .!.".#.$.%.&.'.(.).*.+.,.-.../.:.;.<.=.>.?.@.A.B.C.D.E.F.G.H.I.J.K.L.M.N.O.P.Q.R.S.T.U.V.W.X.Y.Z.[.\.].^._.`.a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.{.|.}.~................................................................................................................................./***//***//***//***//***//***//***//***//*	*		*//*
*

*//***//***//*
*

*//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//* *  *//*!*!!*//*"*""*//*#*##*//*$*$$*//*%*%%*//*&*&&*//*'*''*//*(*((*//*)*))*//*+*++*//*,*,,*//*-*--*//*.*..*//*/*0/*//*0*10*//*1*21*//*2*32*//*3*43*//*4*54*//*5*65*//*6*76*//*7*87*//*8*98*//*9*:9*//*:*;:*//*;*<;*//*<*=<*//*=*>=*//*>*?>*//*?*@?*//*@*A@*//*A*BA*//*B*CB*//*C*DC*//*D*ED*//*E*FE*//*F*GF*//*G*HG*//*H*IH*//*I*JI*//*J*KJ*//*K*LK*//*L*ML*//*M*NM*//*N*ON*//*O*PO*//*P*QP*//*Q*RQ*//*R*SR*//*S*TS*//*T*UT*//*U*VU*//*V*WV*//*W*XW*//*X*YX*//*Y*ZY*//*Z*[Z*//*[*\[*//*\*]\*//*]*^]*//*^*_^*//*_*`_*//*`*a`*//*a*ba*//*b*cb*//*c*dc*//*d*ed*//*e*fe*//*f*gf*//*g*hg*//*h*ih*//*i*ji*//*j*kj*//*k*lk*//*l*ml*//*m*nm*//*n*on*//*o*po*//*p*qp*//*q*rq*//*r*sr*//*s*ts*//*t*ut*//*u*vu*//*v*wv*//*w*xw*//*x*yx*//*y*zy*//*z*{z*//*{*|{*//*|*}|*//*}*~}*//*~*~*//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//*	*		**/*//*
*

**/*//****/*//****/*//*
*

**/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//* *  **/*//*!*!!**/*//*"*""**/*//*#*##**/*//*$*$$**/*//*%*%%**/*//*&*&&**/*//*'*''**/*//*(*((**/*//*)*))**/*//*+*++**/*//*,*,,**/*//*-*--**/*//*.*..**/*//*/*0/**/*//*0*10**/*//*1*21**/*//*2*32**/*//*3*43**/*//*4*54**/*//*5*65**/*//*6*76**/*//*7*87**/*//*8*98**/*//*9*:9**/*//*:*;:**/*//*;*<;**/*//*<*=<**/*//*=*>=**/*//*>*?>**/*//*?*@?**/*//*@*A@**/*//*A*BA**/*//*B*CB**/*//*C*DC**/*//*D*ED**/*//*E*FE**/*//*F*GF**/*//*G*HG**/*//*H*IH**/*//*I*JI**/*//*J*KJ**/*//*K*LK**/*//*L*ML**/*//*M*NM**/*//*N*ON**/*//*O*PO**/*//*P*QP**/*//*Q*RQ**/*//*R*SR**/*//*S*TS**/*//*T*UT**/*//*U*VU**/*//*V*WV**/*//*W*XW**/*//*X*YX**/*//*Y*ZY**/*//*Z*[Z**/*//*[*\[**/*//*\*]\**/*//*]*^]**/*//*^*_^**/*//*_*`_**/*//*`*a`**/*//*a*ba**/*//*b*cb**/*//*c*dc**/*//*d*ed**/*//*e*fe**/*//*f*gf**/*//*g*hg**/*//*h*ih**/*//*i*ji**/*//*j*kj**/*//*k*lk**/*//*l*ml**/*//*m*nm**/*//*n*on**/*//*o*po**/*//*p*qp**/*//*q*rq**/*//*r*sr**/*//*s*ts**/*//*t*ut**/*//*u*vu**/*//*v*wv**/*//*w*xw**/*//*x*yx**/*//*y*zy**/*//*z*{z**/*//*{*|{**/*//*|*}|**/*//*}*~}**/*//*~*~**/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/*//****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /*	*		**/ /*
*

**/ /****/ /****/ /*
*

**/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /* *  **/ /*!*!!**/ /*"*""**/ /*#*##**/ /*$*$$**/ /*%*%%**/ /*&*&&**/ /*'*''**/ /*(*((**/ /*)*))**/ /*+*++**/ /*,*,,**/ /*-*--**/ /*.*..**/ /*/*0/**/ /*0*10**/ /*1*21**/ /*2*32**/ /*3*43**/ /*4*54**/ /*5*65**/ /*6*76**/ /*7*87**/ /*8*98**/ /*9*:9**/ /*:*;:**/ /*;*<;**/ /*<*=<**/ /*=*>=**/ /*>*?>**/ /*?*@?**/ /*@*A@**/ /*A*BA**/ /*B*CB**/ /*C*DC**/ /*D*ED**/ /*E*FE**/ /*F*GF**/ /*G*HG**/ /*H*IH**/ /*I*JI**/ /*J*KJ**/ /*K*LK**/ /*L*ML**/ /*M*NM**/ /*N*ON**/ /*O*PO**/ /*P*QP**/ /*Q*RQ**/ /*R*SR**/ /*S*TS**/ /*T*UT**/ /*U*VU**/ /*V*WV**/ /*W*XW**/ /*X*YX**/ /*Y*ZY**/ /*Z*[Z**/ /*[*\[**/ /*\*]\**/ /*]*^]**/ /*^*_^**/ /*_*`_**/ /*`*a`**/ /*a*ba**/ /*b*cb**/ /*c*dc**/ /*d*ed**/ /*e*fe**/ /*f*gf**/ /*g*hg**/ /*h*ih**/ /*i*ji**/ /*j*kj**/ /*k*lk**/ /*l*ml**/ /*m*nm**/ /*n*on**/ /*o*po**/ /*p*qp**/ /*q*rq**/ /*r*sr**/ /*s*ts**/ /*t*ut**/ /*u*vu**/ /*v*wv**/ /*w*xw**/ /*x*yx**/ /*y*zy**/ /*z*{z**/ /*{*|{**/ /*|*}|**/ /*}*~}**/ /*~*~**/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /****/ /*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*	*		***/*//*
*

***/*//*****/*//*****/*//*
*

***/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//* *  ***/*//*!*!!***/*//*"*""***/*//*#*##***/*//*$*$$***/*//*%*%%***/*//*&*&&***/*//*'*''***/*//*(*((***/*//*)*))***/*//*+*++***/*//*,*,,***/*//*-*--***/*//*.*..***/*//*/*0/***/*//*0*10***/*//*1*21***/*//*2*32***/*//*3*43***/*//*4*54***/*//*5*65***/*//*6*76***/*//*7*87***/*//*8*98***/*//*9*:9***/*//*:*;:***/*//*;*<;***/*//*<*=<***/*//*=*>=***/*//*>*?>***/*//*?*@?***/*//*@*A@***/*//*A*BA***/*//*B*CB***/*//*C*DC***/*//*D*ED***/*//*E*FE***/*//*F*GF***/*//*G*HG***/*//*H*IH***/*//*I*JI***/*//*J*KJ***/*//*K*LK***/*//*L*ML***/*//*M*NM***/*//*N*ON***/*//*O*PO***/*//*P*QP***/*//*Q*RQ***/*//*R*SR***/*//*S*TS***/*//*T*UT***/*//*U*VU***/*//*V*WV***/*//*W*XW***/*//*X*YX***/*//*Y*ZY***/*//*Z*[Z***/*//*[*\[***/*//*\*]\***/*//*]*^]***/*//*^*_^***/*//*_*`_***/*//*`*a`***/*//*a*ba***/*//*b*cb***/*//*c*dc***/*//*d*ed***/*//*e*fe***/*//*f*gf***/*//*g*hg***/*//*h*ih***/*//*i*ji***/*//*j*kj***/*//*k*lk***/*//*l*ml***/*//*m*nm***/*//*n*on***/*//*o*po***/*//*p*qp***/*//*q*rq***/*//*r*sr***/*//*s*ts***/*//*t*ut***/*//*u*vu***/*//*v*wv***/*//*w*xw***/*//*x*yx***/*//*y*zy***/*//*z*{z***/*//*{*|{***/*//*|*}|***/*//*}*~}***/*//*~*~***/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//*****/*//**** /**** /**** /**** /**** /**** /**** /**** /*	*		** /*
*

** /**** /**** /*
*

** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /* *  ** /*!*!!** /*"*""** /*#*##** /*$*$$** /*%*%%** /*&*&&** /*'*''** /*(*((** /*)*))** /*+*++** /*,*,,** /*-*--** /*.*..** /*/*0/** /*0*10** /*1*21** /*2*32** /*3*43** /*4*54** /*5*65** /*6*76** /*7*87** /*8*98** /*9*:9** /*:*;:** /*;*<;** /*<*=<** /*=*>=** /*>*?>** /*?*@?** /*@*A@** /*A*BA** /*B*CB** /*C*DC** /*D*ED** /*E*FE** /*F*GF** /*G*HG** /*H*IH** /*I*JI** /*J*KJ** /*K*LK** /*L*ML** /*M*NM** /*N*ON** /*O*PO** /*P*QP** /*Q*RQ** /*R*SR** /*S*TS** /*T*UT** /*U*VU** /*V*WV** /*W*XW** /*X*YX** /*Y*ZY** /*Z*[Z** /*[*\[** /*\*]\** /*]*^]** /*^*_^** /*_*`_** /*`*a`** /*a*ba** /*b*cb** /*c*dc** /*d*ed** /*e*fe** /*f*gf** /*g*hg** /*h*ih** /*i*ji** /*j*kj** /*k*lk** /*l*ml** /*m*nm** /*n*on** /*o*po** /*p*qp** /*q*rq** /*r*sr** /*s*ts** /*t*ut** /*u*vu** /*v*wv** /*w*xw** /*x*yx** /*y*zy** /*z*{z** /*{*|{** /*|*}|** /*}*~}** /*~*~** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /**** /*** /*** /*** /*** /*** /*** /*** /*** /*	*		* /*
*

* /*** /*** /*
*

* /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /* *  * /*!*!!* /*"*""* /*#*##* /*$*$$* /*%*%%* /*&*&&* /*'*''* /*(*((* /*)*))* /*+*++* /*,*,,* /*-*--* /*.*..* /*/*0/* /*0*10* /*1*21* /*2*32* /*3*43* /*4*54* /*5*65* /*6*76* /*7*87* /*8*98* /*9*:9* /*:*;:* /*;*<;* /*<*=<* /*=*>=* /*>*?>* /*?*@?* /*@*A@* /*A*BA* /*B*CB* /*C*DC* /*D*ED* /*E*FE* /*F*GF* /*G*HG* /*H*IH* /*I*JI* /*J*KJ* /*K*LK* /*L*ML* /*M*NM* /*N*ON* /*O*PO* /*P*QP* /*Q*RQ* /*R*SR* /*S*TS* /*T*UT* /*U*VU* /*V*WV* /*W*XW* /*X*YX* /*Y*ZY* /*Z*[Z* /*[*\[* /*\*]\* /*]*^]* /*^*_^* /*_*`_* /*`*a`* /*a*ba* /*b*cb* /*c*dc* /*d*ed* /*e*fe* /*f*gf* /*g*hg* /*h*ih* /*i*ji* /*j*kj* /*k*lk* /*l*ml* /*m*nm* /*n*on* /*o*po* /*p*qp* /*q*rq* /*r*sr* /*s*ts* /*t*ut* /*u*vu* /*v*wv* /*w*xw* /*x*yx* /*y*zy* /*z*{z* /*{*|{* /*|*}|* /*}*~}* /*~*~* /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /** /** /** /** /** /** /** /** /*	*		 /*
*

 /** /** /*
*

 /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /* *   /*!*!! /*"*"" /*#*## /*$*$$ /*%*%% /*&*&& /*'*'' /*(*(( /*)*)) /*+*++ /*,*,, /*-*-- /*.*.. /*/*0/ /*0*10 /*1*21 /*2*32 /*3*43 /*4*54 /*5*65 /*6*76 /*7*87 /*8*98 /*9*:9 /*:*;: /*;*<; /*<*=< /*=*>= /*>*?> /*?*@? /*@*A@ /*A*BA /*B*CB /*C*DC /*D*ED /*E*FE /*F*GF /*G*HG /*H*IH /*I*JI /*J*KJ /*K*LK /*L*ML /*M*NM /*N*ON /*O*PO /*P*QP /*Q*RQ /*R*SR /*S*TS /*T*UT /*U*VU /*V*WV /*W*XW /*X*YX /*Y*ZY /*Z*[Z /*[*\[ /*\*]\ /*]*^] /*^*_^ /*_*`_ /*`*a` /*a*ba /*b*cb /*c*dc /*d*ed /*e*fe /*f*gf /*g*hg /*h*ih /*i*ji /*j*kj /*k*lk /*l*ml /*m*nm /*n*on /*o*po /*p*qp /*q*rq /*r*sr /*s*ts /*t*ut /*u*vu /*v*wv /*w*xw /*x*yx /*y*zy /*z*{z /*{*|{ /*|*}| /*}*~} /*~*~ /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /***//***//***//***//***//***//***//***//*	*	*//*
*
*//***//***//*
*
*//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//* * *//*!*!*//*"*"*//*#*#*//*$*$*//*%*%*//*&*&*//*'*'*//*(*(*//*)*)*//*+*+*//*,*,*//*-*-*//*.*.*//*/*0*//*0*1*//*1*2*//*2*3*//*3*4*//*4*5*//*5*6*//*6*7*//*7*8*//*8*9*//*9*:*//*:*;*//*;*<*//*<*=*//*=*>*//*>*?*//*?*@*//*@*A*//*A*B*//*B*C*//*C*D*//*D*E*//*E*F*//*F*G*//*G*H*//*H*I*//*I*J*//*J*K*//*K*L*//*L*M*//*M*N*//*N*O*//*O*P*//*P*Q*//*Q*R*//*R*S*//*S*T*//*T*U*//*U*V*//*V*W*//*W*X*//*X*Y*//*Y*Z*//*Z*[*//*[*\*//*\*]*//*]*^*//*^*_*//*_*`*//*`*a*//*a*b*//*b*c*//*c*d*//*d*e*//*e*f*//*f*g*//*g*h*//*h*i*//*i*j*//*j*k*//*k*l*//*l*m*//*m*n*//*n*o*//*o*p*//*p*q*//*q*r*//*r*s*//*s*t*//*t*u*//*u*v*//*v*w*//*w*x*//*x*y*//*y*z*//*z*{*//*{*|*//*|*}*//*}*~*//*~**//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//** /** /** /** /** /** /** /** /*	*	 /*
*
 /** /** /*
*
 /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /* *  /*!*! /*"*" /*#*# /*$*$ /*%*% /*&*& /*'*' /*(*( /*)*) /*+*+ /*,*, /*-*- /*.*. /*/*0 /*0*1 /*1*2 /*2*3 /*3*4 /*4*5 /*5*6 /*6*7 /*7*8 /*8*9 /*9*: /*:*; /*;*< /*<*= /*=*> /*>*? /*?*@ /*@*A /*A*B /*B*C /*C*D /*D*E /*E*F /*F*G /*G*H /*H*I /*I*J /*J*K /*K*L /*L*M /*M*N /*N*O /*O*P /*P*Q /*Q*R /*R*S /*S*T /*T*U /*U*V /*V*W /*W*X /*X*Y /*Y*Z /*Z*[ /*[*\ /*\*] /*]*^ /*^*_ /*_*` /*`*a /*a*b /*b*c /*c*d /*d*e /*e*f /*f*g /*g*h /*h*i /*i*j /*j*k /*k*l /*l*m /*m*n /*n*o /*o*p /*p*q /*q*r /*r*s /*s*t /*t*u /*u*v /*v*w /*w*x /*x*y /*y*z /*z*{ /*{*| /*|*} /*}*~ /*~* /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /****//****//****//****//****//****//****//****//*	**	*//*
**
*//****//****//*
**
*//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//* ** *//*!**!*//*"**"*//*#**#*//*$**$*//*%**%*//*&**&*//*'**'*//*(**(*//*)**)*//*+**+*//*,**,*//*-**-*//*.**.*//*/**0*//*0**1*//*1**2*//*2**3*//*3**4*//*4**5*//*5**6*//*6**7*//*7**8*//*8**9*//*9**:*//*:**;*//*;**<*//*<**=*//*=**>*//*>**?*//*?**@*//*@**A*//*A**B*//*B**C*//*C**D*//*D**E*//*E**F*//*F**G*//*G**H*//*H**I*//*I**J*//*J**K*//*K**L*//*L**M*//*M**N*//*N**O*//*O**P*//*P**Q*//*Q**R*//*R**S*//*S**T*//*T**U*//*U**V*//*V**W*//*W**X*//*X**Y*//*Y**Z*//*Z**[*//*[**\*//*\**]*//*]**^*//*^**_*//*_**`*//*`**a*//*a**b*//*b**c*//*c**d*//*d**e*//*e**f*//*f**g*//*g**h*//*h**i*//*i**j*//*j**k*//*k**l*//*l**m*//*m**n*//*n**o*//*o**p*//*p**q*//*q**r*//*r**s*//*s**t*//*t**u*//*u**v*//*v**w*//*w**x*//*x**y*//*y**z*//*z**{*//*{**|*//*|**}*//*}**~*//*~***//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//****//*****//*****//*****//*****//*****//*****//*****//*****//*	***	*//*
***
*//*****//*****//*
***
*//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//* *** *//*!***!*//*"***"*//*#***#*//*$***$*//*%***%*//*&***&*//*'***'*//*(***(*//*)***)*//*+***+*//*,***,*//*-***-*//*.***.*//*/***0*//*0***1*//*1***2*//*2***3*//*3***4*//*4***5*//*5***6*//*6***7*//*7***8*//*8***9*//*9***:*//*:***;*//*;***<*//*<***=*//*=***>*//*>***?*//*?***@*//*@***A*//*A***B*//*B***C*//*C***D*//*D***E*//*E***F*//*F***G*//*G***H*//*H***I*//*I***J*//*J***K*//*K***L*//*L***M*//*M***N*//*N***O*//*O***P*//*P***Q*//*Q***R*//*R***S*//*S***T*//*T***U*//*U***V*//*V***W*//*W***X*//*X***Y*//*Y***Z*//*Z***[*//*[***\*//*\***]*//*]***^*//*^***_*//*_***`*//*`***a*//*a***b*//*b***c*//*c***d*//*d***e*//*e***f*//*f***g*//*g***h*//*h***i*//*i***j*//*j***k*//*k***l*//*l***m*//*m***n*//*n***o*//*o***p*//*p***q*//*q***r*//*r***s*//*s***t*//*t***u*//*u***v*//*v***w*//*w***x*//*x***y*//*y***z*//*z***{*//*{***|*//*|***}*//*}***~*//*~****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//*****//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//*	**/*//*
**/*//***/*//***/*//*
**/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//* **/*//*!**/*//*"**/*//*#**/*//*$**/*//*%**/*//*&**/*//*'**/*//*(**/*//*)**/*//*+**/*//*,**/*//*-**/*//*.**/*//*/**/*//*0**/*//*1**/*//*2**/*//*3**/*//*4**/*//*5**/*//*6**/*//*7**/*//*8**/*//*9**/*//*:**/*//*;**/*//*<**/*//*=**/*//*>**/*//*?**/*//*@**/*//*A**/*//*B**/*//*C**/*//*D**/*//*E**/*//*F**/*//*G**/*//*H**/*//*I**/*//*J**/*//*K**/*//*L**/*//*M**/*//*N**/*//*O**/*//*P**/*//*Q**/*//*R**/*//*S**/*//*T**/*//*U**/*//*V**/*//*W**/*//*X**/*//*Y**/*//*Z**/*//*[**/*//*\**/*//*]**/*//*^**/*//*_**/*//*`**/*//*a**/*//*b**/*//*c**/*//*d**/*//*e**/*//*f**/*//*g**/*//*h**/*//*i**/*//*j**/*//*k**/*//*l**/*//*m**/*//*n**/*//*o**/*//*p**/*//*q**/*//*r**/*//*s**/*//*t**/*//*u**/*//*v**/*//*w**/*//*x**/*//*y**/*//*z**/*//*{**/*//*|**/*//*}**/*//*~**/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//***/*//*** /*** /*** /*** /*** /*** /*** /*** /*	** /*
** /*** /*** /*
** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /* ** /*!** /*"** /*#** /*$** /*%** /*&** /*'** /*(** /*)** /*+** /*,** /*-** /*.** /*/** /*0** /*1** /*2** /*3** /*4** /*5** /*6** /*7** /*8** /*9** /*:** /*;** /*<** /*=** /*>** /*?** /*@** /*A** /*B** /*C** /*D** /*E** /*F** /*G** /*H** /*I** /*J** /*K** /*L** /*M** /*N** /*O** /*P** /*Q** /*R** /*S** /*T** /*U** /*V** /*W** /*X** /*Y** /*Z** /*[** /*\** /*]** /*^** /*_** /*`** /*a** /*b** /*c** /*d** /*e** /*f** /*g** /*h** /*i** /*j** /*k** /*l** /*m** /*n** /*o** /*p** /*q** /*r** /*s** /*t** /*u** /*v** /*w** /*x** /*y** /*z** /*{** /*|** /*}** /*~** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /*** /**//**//**//**//**//**//**//**//*	*//*
*//**//**//*
*//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//* *//*!*//*"*//*#*//*$*//*%*//*&*//*'*//*(*//*)*//*+*//*,*//*-*//*.*//*/*//*0*//*1*//*2*//*3*//*4*//*5*//*6*//*7*//*8*//*9*//*:*//*;*//*<*//*=*//*>*//*?*//*@*//*A*//*B*//*C*//*D*//*E*//*F*//*G*//*H*//*I*//*J*//*K*//*L*//*M*//*N*//*O*//*P*//*Q*//*R*//*S*//*T*//*U*//*V*//*W*//*X*//*Y*//*Z*//*[*//*\*//*]*//*^*//*_*//*`*//*a*//*b*//*c*//*d*//*e*//*f*//*g*//*h*//*i*//*j*//*k*//*l*//*m*//*n*//*o*//*p*//*q*//*r*//*s*//*t*//*u*//*v*//*w*//*x*//*y*//*z*//*{*//*|*//*}*//*~*//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//**//** /** /** /** /** /** /** /** /*	* /*
* /** /** /*
* /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /* * /*!* /*"* /*#* /*$* /*%* /*&* /*'* /*(* /*)* /*+* /*,* /*-* /*.* /*/* /*0* /*1* /*2* /*3* /*4* /*5* /*6* /*7* /*8* /*9* /*:* /*;* /*<* /*=* /*>* /*?* /*@* /*A* /*B* /*C* /*D* /*E* /*F* /*G* /*H* /*I* /*J* /*K* /*L* /*M* /*N* /*O* /*P* /*Q* /*R* /*S* /*T* /*U* /*V* /*W* /*X* /*Y* /*Z* /*[* /*\* /*]* /*^* /*_* /*`* /*a* /*b* /*c* /*d* /*e* /*f* /*g* /*h* /*i* /*j* /*k* /*l* /*m* /*n* /*o* /*p* /*q* /*r* /*s* /*t* /*u* /*v* /*w* /*x* /*y* /*z* /*{* /*|* /*}* /*~* /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /** /* /* /* /* /* /* /* /* /*	 /*
 /* /* /*
 /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /*  /*! /*" /*# /*$ /*% /*& /*' /*( /*) /*+ /*, /*- /*. /*/ /*0 /*1 /*2 /*3 /*4 /*5 /*6 /*7 /*8 /*9 /*: /*; /*< /*= /*> /*? /*@ /*A /*B /*C /*D /*E /*F /*G /*H /*I /*J /*K /*L /*M /*N /*O /*P /*Q /*R /*S /*T /*U /*V /*W /*X /*Y /*Z /*[ /*\ /*] /*^ /*_ /*` /*a /*b /*c /*d /*e /*f /*g /*h /*i /*j /*k /*l /*m /*n /*o /*p /*q /*r /*s /*t /*u /*v /*w /*x /*y /*z /*{ /*| /*} /*~ /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /* /***//***//***//***//***//***//***//***//**	*//**
*//***//***//**
*//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//** *//**!*//**"*//**#*//**$*//**%*//**&*//**'*//**(*//**)*//**+*//**,*//**-*//**.*//**0*//**1*//**2*//**3*//**4*//**5*//**6*//**7*//**8*//**9*//**:*//**;*//**<*//**=*//**>*//**?*//**@*//**A*//**B*//**C*//**D*//**E*//**F*//**G*//**H*//**I*//**J*//**K*//**L*//**M*//**N*//**O*//**P*//**Q*//**R*//**S*//**T*//**U*//**V*//**W*//**X*//**Y*//**Z*//**[*//**\*//**]*//**^*//**_*//**`*//**a*//**b*//**c*//**d*//**e*//**f*//**g*//**h*//**i*//**j*//**k*//**l*//**m*//**n*//**o*//**p*//**q*//**r*//**s*//**t*//**u*//**v*//**w*//**x*//**y*//**z*//**{*//**|*//**}*//**~*//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//***//* //
//
//
//
//
//
//
//
//	
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
// 
//!
//"
//#
//$
//%
//&
//'
//(
//)
//*
//+
//,
//-
//.
///
//0
//1
//2
//3
//4
//5
//6
//7
//8
//9
//:
//;
//<
//=
//>
//?
//@
//A
//B
//C
//D
//E
//F
//G
//H
//I
//J
//K
//L
//M
//N
//O
//P
//Q
//R
//S
//T
//U
//V
//W
//X
//Y
//Z
//[
//\
//]
//^
//_
//`
//a
//b
//c
//d
//e
//f
//g
//h
//i
//j
//k
//l
//m
//n
//o
//p
//q
//r
//s
//t
//u
//v
//w
//x
//y
//z
//{
//|
//}
//~
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
// // // // // // // // //	 // // //
 // // // // // // // // // // // // // // // // // // //  //! //" //# //$ //% //& //' //( //) //* //+ //, //- //. /// //0 //1 //2 //3 //4 //5 //6 //7 //8 //9 //: //; //< //= //> //? //@ //A //B //C //D //E //F //G //H //I //J //K //L //M //N //O //P //Q //R //S //T //U //V //W //X //Y //Z //[ //\ //] //^ //_ //` //a //b //c //d //e //f //g //h //i //j //k //l //m //n //o //p //q //r //s //t //u //v //w //x //y //z //{ //| //} //~ // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // // //
// / /////////	/
///
/////////////////// /!/"/#/$/%/&/'/(/)/+/,/-/./0/1/2/3/4/5/6/7/8/9/:/;/</=/>/?/@/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/[/\/]/^/_/`/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/{/|/}/~/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////0.0E+0 0.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-9	0.0E+0
0.1e-10.2E+20.3e-3
0.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+2 0.3e-3!0.4E+4"0.5e-5#0.6E+6$0.7e-7%0.8E+8&0.9e-9'0.0E+0(0.1e-1)0.2E+2*0.3e-3+0.4E+4,0.5e-5-0.6E+6.0.7e-7/0.8E+8:0.9e-9;0.0E+0<0.1e-1=0.2E+2>0.3e-3?0.4E+4@0.5e-5A0.6E+6B0.7e-7C0.8E+8D0.9e-9E0.0E+0F0.1e-1G0.2E+2H0.3e-3I0.4E+4J0.5e-5K0.6E+6L0.7e-7M0.8E+8N0.9e-9O0.0E+0P0.1e-1Q0.2E+2R0.3e-3S0.4E+4T0.5e-5U0.6E+6V0.7e-7W0.8E+8X0.9e-9Y0.0E+0Z0.1e-1[0.2E+2\0.3e-3]0.4E+4^0.5e-5_0.6E+6`0.7e-7a0.8E+8b0.9e-9c0.0E+0d0.1e-1e0.2E+2f0.3e-3g0.4E+4h0.5e-5i0.6E+6j0.7e-7k0.8E+8l0.9e-9m0.0E+0n0.1e-1o0.2E+2p0.3e-3q0.4E+4r0.5e-5s0.6E+6t0.7e-7u0.8E+8v0.9e-9w0.0E+0x0.1e-1y0.2E+2z0.3e-3{0.4E+4|0.5e-5}0.6E+6~0.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-50.6E+60.7e-70.8E+80.9e-90.0E+00.1e-10.2E+20.3e-30.4E+40.5e-500.0E+0 01.1e-102.2E+203.3e-304.4E+405.5e-506.6E+607.7e-700.8E+801.9e-9	02.0E+0
03.1e-104.2E+205.3e-3
06.4E+407.5e-500.6E+601.7e-702.8E+803.9e-904.0E+005.1e-106.2E+207.3e-300.4E+401.5e-502.6E+603.7e-704.8E+805.9e-906.0E+007.1e-100.2E+2 01.3e-3!02.4E+4"03.5e-5#04.6E+6$05.7e-7%06.8E+8&07.9e-9'00.0E+0(01.1e-1)02.2E+2*03.3e-3+04.4E+4,05.5e-5-06.6E+6.07.7e-7/00.8E+8:01.9e-9;02.0E+0<03.1e-1=04.2E+2>05.3e-3?06.4E+4@07.5e-5A00.6E+6B01.7e-7C02.8E+8D03.9e-9E04.0E+0F05.1e-1G06.2E+2H07.3e-3I00.4E+4J01.5e-5K02.6E+6L03.7e-7M04.8E+8N05.9e-9O06.0E+0P07.1e-1Q00.2E+2R01.3e-3S02.4E+4T03.5e-5U04.6E+6V05.7e-7W06.8E+8X07.9e-9Y00.0E+0Z01.1e-1[02.2E+2\03.3e-3]04.4E+4^05.5e-5_06.6E+6`07.7e-7a00.8E+8b01.9e-9c02.0E+0d03.1e-1e04.2E+2f05.3e-3g06.4E+4h07.5e-5i00.6E+6j01.7e-7k02.8E+8l03.9e-9m04.0E+0n05.1e-1o06.2E+2p07.3e-3q00.4E+4r01.5e-5s02.6E+6t03.7e-7u04.8E+8v05.9e-9w06.0E+0x07.1e-1y00.2E+2z01.3e-3{02.4E+4|03.5e-5}04.6E+6~05.7e-706.8E+807.9e-900.0E+001.1e-102.2E+203.3e-304.4E+405.5e-506.6E+607.7e-700.8E+801.9e-902.0E+003.1e-104.2E+205.3e-306.4E+407.5e-500.6E+601.7e-702.8E+803.9e-904.0E+005.1e-106.2E+207.3e-300.4E+401.5e-502.6E+603.7e-704.8E+805.9e-906.0E+007.1e-100.2E+201.3e-302.4E+403.5e-504.6E+605.7e-706.8E+807.9e-900.0E+001.1e-102.2E+203.3e-304.4E+405.5e-506.6E+607.7e-700.8E+801.9e-902.0E+003.1e-104.2E+205.3e-306.4E+407.5e-500.6E+601.7e-702.8E+803.9e-904.0E+005.1e-106.2E+207.3e-300.4E+401.5e-502.6E+603.7e-704.8E+805.9e-906.0E+007.1e-100.2E+201.3e-302.4E+403.5e-504.6E+605.7e-706.8E+807.9e-900.0E+001.1e-102.2E+203.3e-304.4E+405.5e-506.6E+607.7e-700.8E+801.9e-902.0E+003.1e-104.2E+205.3e-306.4E+407.5e-500.6E+601.7e-702.8E+803.9e-904.0E+005.1e-106.2E+207.3e-300.4E+401.5e-502.6E+603.7e-704.8E+805.9e-906.0E+007.1e-100.2E+201.3e-302.4E+403.5e-504.6E+605.7e-706.8E+807.9e-900.0E+001.1e-102.2E+203.3e-304.4E+405.5e-5000.0E+0 011.1e-1022.2E+2033.3e-3044.4E+4055.5e-5066.6E+6077.7e-7000.8E+8011.9e-9	022.0E+0
033.1e-1044.2E+2055.3e-3
066.4E+4077.5e-5000.6E+6011.7e-7022.8E+8033.9e-9044.0E+0055.1e-1066.2E+2077.3e-3000.4E+4011.5e-5022.6E+6033.7e-7044.8E+8055.9e-9066.0E+0077.1e-1000.2E+2 011.3e-3!022.4E+4"033.5e-5#044.6E+6$055.7e-7%066.8E+8&077.9e-9'000.0E+0(011.1e-1)022.2E+2*033.3e-3+044.4E+4,055.5e-5-066.6E+6.077.7e-7/000.8E+8:011.9e-9;022.0E+0<033.1e-1=044.2E+2>055.3e-3?066.4E+4@077.5e-5A000.6E+6B011.7e-7C022.8E+8D033.9e-9E044.0E+0F055.1e-1G066.2E+2H077.3e-3I000.4E+4J011.5e-5K022.6E+6L033.7e-7M044.8E+8N055.9e-9O066.0E+0P077.1e-1Q000.2E+2R011.3e-3S022.4E+4T033.5e-5U044.6E+6V055.7e-7W066.8E+8X077.9e-9Y000.0E+0Z011.1e-1[022.2E+2\033.3e-3]044.4E+4^055.5e-5_066.6E+6`077.7e-7a000.8E+8b011.9e-9c022.0E+0d033.1e-1e044.2E+2f055.3e-3g066.4E+4h077.5e-5i000.6E+6j011.7e-7k022.8E+8l033.9e-9m044.0E+0n055.1e-1o066.2E+2p077.3e-3q000.4E+4r011.5e-5s022.6E+6t033.7e-7u044.8E+8v055.9e-9w066.0E+0x077.1e-1y000.2E+2z011.3e-3{022.4E+4|033.5e-5}044.6E+6~055.7e-7066.8E+8077.9e-9000.0E+0011.1e-1022.2E+2033.3e-3044.4E+4055.5e-5066.6E+6077.7e-7000.8E+8011.9e-9022.0E+0033.1e-1044.2E+2055.3e-3066.4E+4077.5e-5000.6E+6011.7e-7022.8E+8033.9e-9044.0E+0055.1e-1066.2E+2077.3e-3000.4E+4011.5e-5022.6E+6033.7e-7044.8E+8055.9e-9066.0E+0077.1e-1000.2E+2011.3e-3022.4E+4033.5e-5044.6E+6055.7e-7066.8E+8077.9e-9000.0E+0011.1e-1022.2E+2033.3e-3044.4E+4055.5e-5066.6E+6077.7e-7000.8E+8011.9e-9022.0E+0033.1e-1044.2E+2055.3e-3066.4E+4077.5e-5000.6E+6011.7e-7022.8E+8033.9e-9044.0E+0055.1e-1066.2E+2077.3e-3000.4E+4011.5e-5022.6E+6033.7e-7044.8E+8055.9e-9066.0E+0077.1e-1000.2E+2011.3e-3022.4E+4033.5e-5044.6E+6055.7e-7066.8E+8077.9e-9000.0E+0011.1e-1022.2E+2033.3e-3044.4E+4055.5e-5066.6E+6077.7e-7000.8E+8011.9e-9022.0E+0033.1e-1044.2E+2055.3e-3066.4E+4077.5e-5000.6E+6011.7e-7022.8E+8033.9e-9044.0E+0055.1e-1066.2E+2077.3e-3000.4E+4011.5e-5022.6E+6033.7e-7044.8E+8055.9e-9066.0E+0077.1e-1000.2E+2011.3e-3022.4E+4033.5e-5044.6E+6055.7e-7066.8E+8077.9e-9000.0E+0011.1e-1022.2E+2033.3e-3044.4E+4055.5e-5008.0E+0 019.1e-1028.2E+2039.3e-3048.4E+4059.5e-5068.6E+6079.7e-7008.8E+8019.9e-9	028.0E+0
039.1e-1048.2E+2059.3e-3
068.4E+4079.5e-5008.6E+6019.7e-7028.8E+8039.9e-9048.0E+0059.1e-1068.2E+2079.3e-3008.4E+4019.5e-5028.6E+6039.7e-7048.8E+8059.9e-9068.0E+0079.1e-1008.2E+2 019.3e-3!028.4E+4"039.5e-5#048.6E+6$059.7e-7%068.8E+8&079.9e-9'008.0E+0(019.1e-1)028.2E+2*039.3e-3+048.4E+4,059.5e-5-068.6E+6.079.7e-7/008.8E+8:019.9e-9;028.0E+0<039.1e-1=048.2E+2>059.3e-3?068.4E+4@079.5e-5A008.6E+6B019.7e-7C028.8E+8D039.9e-9E048.0E+0F059.1e-1G068.2E+2H079.3e-3I008.4E+4J019.5e-5K028.6E+6L039.7e-7M048.8E+8N059.9e-9O068.0E+0P079.1e-1Q008.2E+2R019.3e-3S028.4E+4T039.5e-5U048.6E+6V059.7e-7W068.8E+8X079.9e-9Y008.0E+0Z019.1e-1[028.2E+2\039.3e-3]048.4E+4^059.5e-5_068.6E+6`079.7e-7a008.8E+8b019.9e-9c028.0E+0d039.1e-1e048.2E+2f059.3e-3g068.4E+4h079.5e-5i008.6E+6j019.7e-7k028.8E+8l039.9e-9m048.0E+0n059.1e-1o068.2E+2p079.3e-3q008.4E+4r019.5e-5s028.6E+6t039.7e-7u048.8E+8v059.9e-9w068.0E+0x079.1e-1y008.2E+2z019.3e-3{028.4E+4|039.5e-5}048.6E+6~059.7e-7068.8E+8079.9e-9008.0E+0019.1e-1028.2E+2039.3e-3048.4E+4059.5e-5068.6E+6079.7e-7008.8E+8019.9e-9028.0E+0039.1e-1048.2E+2059.3e-3068.4E+4079.5e-5008.6E+6019.7e-7028.8E+8039.9e-9048.0E+0059.1e-1068.2E+2079.3e-3008.4E+4019.5e-5028.6E+6039.7e-7048.8E+8059.9e-9068.0E+0079.1e-1008.2E+2019.3e-3028.4E+4039.5e-5048.6E+6059.7e-7068.8E+8079.9e-9008.0E+0019.1e-1028.2E+2039.3e-3048.4E+4059.5e-5068.6E+6079.7e-7008.8E+8019.9e-9028.0E+0039.1e-1048.2E+2059.3e-3068.4E+4079.5e-5008.6E+6019.7e-7028.8E+8039.9e-9048.0E+0059.1e-1068.2E+2079.3e-3008.4E+4019.5e-5028.6E+6039.7e-7048.8E+8059.9e-9068.0E+0079.1e-1008.2E+2019.3e-3028.4E+4039.5e-5048.6E+6059.7e-7068.8E+8079.9e-9008.0E+0019.1e-1028.2E+2039.3e-3048.4E+4059.5e-5068.6E+6079.7e-7008.8E+8019.9e-9028.0E+0039.1e-1048.2E+2059.3e-3068.4E+4079.5e-5008.6E+6019.7e-7028.8E+8039.9e-9048.0E+0059.1e-1068.2E+2079.3e-3008.4E+4019.5e-5028.6E+6039.7e-7048.8E+8059.9e-9068.0E+0079.1e-1008.2E+2019.3e-3028.4E+4039.5e-5048.6E+6059.7e-7068.8E+8079.9e-9008.0E+0019.1e-1028.2E+2039.3e-3048.4E+4059.5e-50080.0E+0 0191.1e-10282.2E+20393.3e-30484.4E+40595.5e-50686.6E+60797.7e-70088.8E+80199.9e-9	0280.0E+0
0391.1e-10482.2E+20593.3e-3
0684.4E+40795.5e-50086.6E+60197.7e-70288.8E+80399.9e-90480.0E+00591.1e-10682.2E+20793.3e-30084.4E+40195.5e-50286.6E+60397.7e-70488.8E+80599.9e-90680.0E+00791.1e-10082.2E+2 0193.3e-3!0284.4E+4"0395.5e-5#0486.6E+6$0597.7e-7%0688.8E+8&0799.9e-9'0080.0E+0(0191.1e-1)0282.2E+2*0393.3e-3+0484.4E+4,0595.5e-5-0686.6E+6.0797.7e-7/0088.8E+8:0199.9e-9;0280.0E+0<0391.1e-1=0482.2E+2>0593.3e-3?0684.4E+4@0795.5e-5A0086.6E+6B0197.7e-7C0288.8E+8D0399.9e-9E0480.0E+0F0591.1e-1G0682.2E+2H0793.3e-3I0084.4E+4J0195.5e-5K0286.6E+6L0397.7e-7M0488.8E+8N0599.9e-9O0680.0E+0P0791.1e-1Q0082.2E+2R0193.3e-3S0284.4E+4T0395.5e-5U0486.6E+6V0597.7e-7W0688.8E+8X0799.9e-9Y0080.0E+0Z0191.1e-1[0282.2E+2\0393.3e-3]0484.4E+4^0595.5e-5_0686.6E+6`0797.7e-7a0088.8E+8b0199.9e-9c0280.0E+0d0391.1e-1e0482.2E+2f0593.3e-3g0684.4E+4h0795.5e-5i0086.6E+6j0197.7e-7k0288.8E+8l0399.9e-9m0480.0E+0n0591.1e-1o0682.2E+2p0793.3e-3q0084.4E+4r0195.5e-5s0286.6E+6t0397.7e-7u0488.8E+8v0599.9e-9w0680.0E+0x0791.1e-1y0082.2E+2z0193.3e-3{0284.4E+4|0395.5e-5}0486.6E+6~0597.7e-70688.8E+80799.9e-90080.0E+00191.1e-10282.2E+20393.3e-30484.4E+40595.5e-50686.6E+60797.7e-70088.8E+80199.9e-90280.0E+00391.1e-10482.2E+20593.3e-30684.4E+40795.5e-50086.6E+60197.7e-70288.8E+80399.9e-90480.0E+00591.1e-10682.2E+20793.3e-30084.4E+40195.5e-50286.6E+60397.7e-70488.8E+80599.9e-90680.0E+00791.1e-10082.2E+20193.3e-30284.4E+40395.5e-50486.6E+60597.7e-70688.8E+80799.9e-90080.0E+00191.1e-10282.2E+20393.3e-30484.4E+40595.5e-50686.6E+60797.7e-70088.8E+80199.9e-90280.0E+00391.1e-10482.2E+20593.3e-30684.4E+40795.5e-50086.6E+60197.7e-70288.8E+80399.9e-90480.0E+00591.1e-10682.2E+20793.3e-30084.4E+40195.5e-50286.6E+60397.7e-70488.8E+80599.9e-90680.0E+00791.1e-10082.2E+20193.3e-30284.4E+40395.5e-50486.6E+60597.7e-70688.8E+80799.9e-90080.0E+00191.1e-10282.2E+20393.3e-30484.4E+40595.5e-50686.6E+60797.7e-70088.8E+80199.9e-90280.0E+00391.1e-10482.2E+20593.3e-30684.4E+40795.5e-50086.6E+60197.7e-70288.8E+80399.9e-90480.0E+00591.1e-10682.2E+20793.3e-30084.4E+40195.5e-50286.6E+60397.7e-70488.8E+80599.9e-90680.0E+00791.1e-10082.2E+20193.3e-30284.4E+40395.5e-50486.6E+60597.7e-70688.8E+80799.9e-90080.0E+00191.1e-10282.2E+20393.3e-30484.4E+40595.5e-5008A0 019B1028C2039D3048F4059G5068H6079I7008J8019K9	028LA
039MB048NC059OD
068PE079QF008RG019SH028TI039UJ048VK059WL068XM079YN008ZO019_P028aQ039bR048cS059dT068fU079gV008hW 019iX!028jY"039kZ#048l_$059ma%068nb&079oc'008pd(019qe)028rf*039sg+048th,059ui-068vj.079wk/008xl:019ym;028zn<039Ao=048Bp>059Cq?068Dr@079Fs[008Gt\019Hu]028Iv^039Jw`048Kx{059Ly|068Mz}079N0~008O1019P2028Q3039R4048S5059T6068U7079V8008W9019XA028YB039ZC048_D059aE068bF079cG008dH019fI028gJ039hK048iL059jM068kN079lO008mP019nQ028oR039pS048qT059rU068sV079tW008uX019vY028wZ039x_048ya059zb068Ac079Bd008Ce019Df028Fg039Gh048Hi059Ij068Jk079Kl008Lm019Mn028No039Op048Pq059Qr068Rs079St008Tu019Uv028Vw039Wx048Xy059Yz068Z0079_1008a2019b3028c4039d5048f6059g7068h8079i9008jA019kB028lC039mD048nE059oF068pG079qH008rI019sJ028tK039uL048vM059wN068xO079yP008zQ019AR028BS039CT048DU059FV068GW079HX008IY019JZ028K_039La048Mb059Nc068Od079Pe008Qf019Rg028Sh039Ti048Uj059Vk068Wl079Xm008Yn019Zo028_p039aq048br059cs068dt079fu008gv019hw028ix039jy048kz059l0068m1079n2008o3008A 019B028C039D048F059G068H079I008J019K	028L
039M048N059O
068P079Q008R019S028T039U048V059W068X079Y008Z019_028a039b048c059d068f079g008h 019i!028j"039k#048l$059m%068n&079o'008p(019q)028r*039s+048t,059u-068v.079w/008x:019y;028z<039A=048B>059C?068D@079F[008G\019H]028I^039J`048K{059L|068M}079N~008O019P028Q039R048S059T068U079V008W019X028Y039Z048_059a068b079c008d019f028g039h048i059j068k079l008m019n028o039p048q059r068s079t008u019v028w039x048y059z068A079B008C019D028F039G048H059I068J079K008L019M028N039O048P059Q068R079S008T019U028V039W048X059Y068Z079_008a019b028c039d048f059g068h079i008j019k028l039m048n059o068p079q008r019s028t039u048v059w068x079y008z019A028B039C048D059F068G079H008I019J028K039L048M059N068O079P008Q019R028S039T048U059V068W079X008Y019Z028_039a048b059c068d079f008g019h028i039j048k059l068m079n008o008EA 019eB028EC039eD048EE059eF068EG079eH008EI019eJ	028EK
039eL048EM059eN
068EO079eP008EQ019eR028ES039eT048EU059eV068EW079eX008EY019eZ028E_039ea048Eb059ec068Ed079ee008Ef 019eg!028Eh"039ei#048Ej$059ek%068El&079em'008En(019eo)028Ep*039eq+048Er,059es-068Et.079eu/008Ev:019ew;028Ex<039ey=048Ez>059eA?068EB@079eC[008ED\019eE]028EF^039eG`048EH{059eI|068EJ}079eK~008EL019eM028EN039eO048EP059eQ068ER079eS008ET019eU028EV039eW048EX059eY068EZ079e_008Ea019eb028Ec039ed048Ee059ef068Eg079eh008Ei019ej028Ek039el048Em059en068Eo079ep008Eq019er028Es039et048Eu059ev068Ew079ex008Ey019ez028EA039eB048EC059eD068EE079eF008EG019eH028EI039eJ048EK059eL068EM079eN008EO019eP028EQ039eR048ES059eT068EU079eV008EW019eX028EY039eZ048E_059ea068Eb079ec008Ed019ee028Ef039eg048Eh059ei068Ej079ek008El019em028En039eo048Ep059eq068Er079es008Et019eu028Ev039ew048Ex059ey068Ez079eA008EB019eC028ED039eE048EF059eG068EH079eI008EJ019eK028EL039eM048EN059eO068EP079eQ008ER019eS028ET039eU048EV059eW068EX079eY008EZ019e_028Ea039eb048Ec059ed068Ee079ef008Eg008E+0 019e-1028E+2039e-3048E+4059e-5068E+6079e-7008E+8019e-9	028E+0
039e-1048E+2059e-3
068E+4079e-5008E+6019e-7028E+8039e-9048E+0059e-1068E+2079e-3008E+4019e-5028E+6039e-7048E+8059e-9068E+0079e-1008E+2 019e-3!028E+4"039e-5#048E+6$059e-7%068E+8&079e-9'008E+0(019e-1)028E+2*039e-3+048E+4,059e-5-068E+6.079e-7/008E+8:019e-9;028E+0<039e-1=048E+2>059e-3?068E+4@079e-5A008E+6B019e-7C028E+8D039e-9E048E+0F059e-1G068E+2H079e-3I008E+4J019e-5K028E+6L039e-7M048E+8N059e-9O068E+0P079e-1Q008E+2R019e-3S028E+4T039e-5U048E+6V059e-7W068E+8X079e-9Y008E+0Z019e-1[028E+2\039e-3]048E+4^059e-5_068E+6`079e-7a008E+8b019e-9c028E+0d039e-1e048E+2f059e-3g068E+4h079e-5i008E+6j019e-7k028E+8l039e-9m048E+0n059e-1o068E+2p079e-3q008E+4r019e-5s028E+6t039e-7u048E+8v059e-9w068E+0x079e-1y008E+2z019e-3{028E+4|039e-5}048E+6~059e-7068E+8079e-9008E+0019e-1028E+2039e-3048E+4059e-5068E+6079e-7008E+8019e-9028E+0039e-1048E+2059e-3068E+4079e-5008E+6019e-7028E+8039e-9048E+0059e-1068E+2079e-3008E+4019e-5028E+6039e-7048E+8059e-9068E+0079e-1008E+2019e-3028E+4039e-5048E+6059e-7068E+8079e-9008E+0019e-1028E+2039e-3048E+4059e-5068E+6079e-7008E+8019e-9028E+0039e-1048E+2059e-3068E+4079e-5008E+6019e-7028E+8039e-9048E+0059e-1068E+2079e-3008E+4019e-5028E+6039e-7048E+8059e-9068E+0079e-1008E+2019e-3028E+4039e-5048E+6059e-7068E+8079e-9008E+0019e-1028E+2039e-3048E+4059e-5068E+6079e-7008E+8019e-9028E+0039e-1048E+2059e-3068E+4079e-5008E+6019e-7028E+8039e-9048E+0059e-1068E+2079e-3008E+4019e-5028E+6039e-7048E+8059e-9068E+0079e-1008E+2019e-3028E+4039e-5048E+6059e-7068E+8079e-9008E+0019e-1028E+2039e-3048E+4059e-5008E0A 019e1B028E2C039e3D048E4E059e5F068E6G079e7H008E8I019e9J	028E0K
039e1L048E2M059e3N
068E4O079e5P008E6Q019e7R028E8S039e9T048E0U059e1V068E2W079e3X008E4Y019e5Z028E6_039e7a048E8b059e9c068E0d079e1e008E2f 019e3g!028E4h"039e5i#048E6j$059e7k%068E8l&079e9m'008E0n(019e1o)028E2p*039e3q+048E4r,059e5s-068E6t.079e7u/008E8v:019e9w;028E0x<039e1y=048E2z>059e3A?068E4B@079e5C[008E6D\019e7E]028E8F^039e9G`048E0H{059e1I|068E2J}079e3K~008E4L019e5M028E6N039e7O048E8P059e9Q068E0R079e1S008E2T019e3U028E4V039e5W048E6X059e7Y068E8Z079e9_008E0a019e1b028E2c039e3d048E4e059e5f068E6g079e7h008E8i019e9j028E0k039e1l048E2m059e3n068E4o079e5p008E6q019e7r028E8s039e9t048E0u059e1v068E2w079e3x008E4y019e5z028E6A039e7B048E8C059e9D068E0E079e1F008E2G019e3H028E4I039e5J048E6K059e7L068E8M079e9N008E0O019e1P028E2Q039e3R048E4S059e5T068E6U079e7V008E8W019e9X028E0Y039e1Z048E2_059e3a068E4b079e5c008E6d019e7e028E8f039e9g048E0h059e1i068E2j079e3k008E4l019e5m028E6n039e7o048E8p059e9q068E0r079e1s008E2t019e3u028E4v039e5w048E6x059e7y068E8z079e9A008E0B019e1C028E2D039e3E048E4F059e5G068E6H079e7I008E8J019e9K028E0L039e1M048E2N059e3O068E4P079e5Q008E6R019e7S028E8T039e9U048E0V059e1W068E2X079e3Y008E4Z019e5_028E6a039e7b048E8c059e9d068E0e079e1f008E2g008E00A 019e11B028E22C039e33D048E44E059e55F068E66G079e77H008E88I019e99J	028E00K
039e11L048E22M059e33N
068E44O079e55P008E66Q019e77R028E88S039e99T048E00U059e11V068E22W079e33X008E44Y019e55Z028E66_039e77a048E88b059e99c068E00d079e11e008E22f 019e33g!028E44h"039e55i#048E66j$059e77k%068E88l&079e99m'008E00n(019e11o)028E22p*039e33q+048E44r,059e55s-068E66t.079e77u/008E88v:019e99w;028E00x<039e11y=048E22z>059e33A?068E44B@079e55C[008E66D\019e77E]028E88F^039e99G`048E00H{059e11I|068E22J}079e33K~008E44L019e55M028E66N039e77O048E88P059e99Q068E00R079e11S008E22T019e33U028E44V039e55W048E66X059e77Y068E88Z079e99_008E00a019e11b028E22c039e33d048E44e059e55f068E66g079e77h008E88i019e99j028E00k039e11l048E22m059e33n068E44o079e55p008E66q019e77r028E88s039e99t048E00u059e11v068E22w079e33x008E44y019e55z028E66A039e77B048E88C059e99D068E00E079e11F008E22G019e33H028E44I039e55J048E66K059e77L068E88M079e99N008E00O019e11P028E22Q039e33R048E44S059e55T068E66U079e77V008E88W019e99X028E00Y039e11Z048E22_059e33a068E44b079e55c008E66d019e77e028E88f039e99g048E00h059e11i068E22j079e33k008E44l019e55m028E66n039e77o048E88p059e99q068E00r079e11s008E22t019e33u028E44v039e55w048E66x059e77y068E88z079e99A008E00B019e11C028E22D039e33E048E44F059e55G068E66H079e77I008E88J019e99K028E00L039e11M048E22N059e33O068E44P079e55Q008E66R019e77S028E88T039e99U048E00V059e11W068E22X079e33Y008E44Z019e55_028E66a039e77b048E88c059e99d068E00e079e11f008E22g008E0 019e1028E2039e3048E4059e5068E6079e7008E8019e9	028E0
039e1048E2059e3
068E4079e5008E6019e7028E8039e9048E0059e1068E2079e3008E4019e5028E6039e7048E8059e9068E0079e1008E2 019e3!028E4"039e5#048E6$059e7%068E8&079e9'008E0(019e1)028E2*039e3+048E4,059e5-068E6.079e7/008E8:019e9;028E0<039e1=048E2>059e3?068E4@079e5[008E6\019e7]028E8^039e9`048E0{059e1|068E2}079e3~008E4019e5028E6039e7048E8059e9068E0079e1008E2019e3028E4039e5048E6059e7068E8079e9008E0019e1028E2039e3048E4059e5068E6079e7008E8019e9028E0039e1048E2059e3068E4079e5008E6019e7028E8039e9048E0059e1068E2079e3008E4019e5028E6039e7048E8059e9068E0079e1008E2019e3028E4039e5048E6059e7068E8079e9008E0019e1028E2039e3048E4059e5068E6079e7008E8019e9028E0039e1048E2059e3068E4079e5008E6019e7028E8039e9048E0059e1068E2079e3008E4019e5028E6039e7048E8059e9068E0079e1008E2019e3028E4039e5048E6059e7068E8079e9008E0019e1028E2039e3048E4059e5068E6079e7008E8019e9028E0039e1048E2059e3068E4079e5008E6019e7028E8039e9048E0059e1068E2079e3008E4019e5028E6039e7048E8059e9068E0079e1008E2008E 019e028E039e048E059e068E079e008E019e	028E
039e048E059e
068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E 019e!028E"039e#048E$059e%068E&079e'008E(019e)028E*039e,048E.059e/068E:079e;008E<019e=028E>039e?048E@059e[068E\079e]008E^019e`028E{039e|048E}059e~068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E079e008E019e028E039e048E059e068E008 019028039048059068079008019	028
039048059
068079008019028039048059068079008019028039048059068079008 019!028"039#048$059%068&079'008(019)028*039+048,059-068/079:008;019<028=039>048?059@068[079\008]019^028`039{048|059}068~07900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900801902803904805906807900A 01B02C03D04F05G06H07I00J01K	02L
03M04N05O
06P07Q00R01S02T03U04V05W06X07Y00Z01_02a03b04c05d06f07g00h 01i!02j"03k#04l$05m%06n&07o'00p(01q)02r*03s+04t,05u-06v.07w/00x:01y;02z<03A=04B>05C?06D@07F[00G\01H]02I^03J`04K{05L|06M}07N~00O01P02Q03R04S05T06U07V00W01X02Y03Z04_05a06b07c00d01f02g03h04i05j06k07l00m01n02o03p04q05r06s07t00u01v02w03x04y05z06A07B00C01D02F03G04H05I06J07K00L01M02N03O04P05Q06R07S00T01U02V03W04X05Y06Z07_00a01b02c03d04f05g06h07i00j01k02l03m04n05o06p07q00r01s02t03u04v05w06x07y00z01A02B03C04D05F06G07H00I01J02K03L04M05N06O07P00Q01R02S03T04U05V06W07X00Y01Z02_03a04b05c06d07f00g01h02i03j04k05l06m07n00o00EA 01eB02EC03eD04EE05eF06EG07eH00EI01eJ	02EK
03eL04EM05eN
06EO07eP00EQ01eR02ES03eT04EU05eV06EW07eX00EY01eZ02E_03ea04Eb05ec06Ed07ee00Ef 01eg!02Eh"03ei#04Ej$05ek%06El&07em'00En(01eo)02Ep*03eq+04Er,05es-06Et.07eu/00Ev:01ew;02Ex<03ey=04Ez>05eA?06EB@07eC[00ED\01eE]02EF^03eG`04EH{05eI|06EJ}07eK~00EL01eM02EN03eO04EP05eQ06ER07eS00ET01eU02EV03eW04EX05eY06EZ07e_00Ea01eb02Ec03ed04Ee05ef06Eg07eh00Ei01ej02Ek03el04Em05en06Eo07ep00Eq01er02Es03et04Eu05ev06Ew07ex00Ey01ez02EA03eB04EC05eD06EE07eF00EG01eH02EI03eJ04EK05eL06EM07eN00EO01eP02EQ03eR04ES05eT06EU07eV00EW01eX02EY03eZ04E_05ea06Eb07ec00Ed01ee02Ef03eg04Eh05ei06Ej07ek00El01em02En03eo04Ep05eq06Er07es00Et01eu02Ev03ew04Ex05ey06Ez07eA00EB01eC02ED03eE04EF05eG06EH07eI00EJ01eK02EL03eM04EN05eO06EP07eQ00ER01eS02ET03eU04EV05eW06EX07eY00EZ01e_02Ea03eb04Ec05ed06Ee07ef00Eg00 010203040506070001	02
030405
06070001020304050607000102030405060700 01!02"03#04$05%06&07'00(01)02*03+04,05-06/07:00;01<02=03>04?05@06[07\00]01^02`03{04|05}06~07000102030405060700010203040506070001020304050607000102030405060700010203040506070001020304050607000102030405060700010203040506070001020304050607000102030405060700010203040506070001020304050607000102030405060700010203040506070001020304050607000102030405060708.0E+0 09.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-9	08.0E+0
09.1e-108.2E+209.3e-3
08.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+2 09.3e-3!08.4E+4"09.5e-5#08.6E+6$09.7e-7%08.8E+8&09.9e-9'08.0E+0(09.1e-1)08.2E+2*09.3e-3+08.4E+4,09.5e-5-08.6E+6.09.7e-7/08.8E+8:09.9e-9;08.0E+0<09.1e-1=08.2E+2>09.3e-3?08.4E+4@09.5e-5A08.6E+6B09.7e-7C08.8E+8D09.9e-9E08.0E+0F09.1e-1G08.2E+2H09.3e-3I08.4E+4J09.5e-5K08.6E+6L09.7e-7M08.8E+8N09.9e-9O08.0E+0P09.1e-1Q08.2E+2R09.3e-3S08.4E+4T09.5e-5U08.6E+6V09.7e-7W08.8E+8X09.9e-9Y08.0E+0Z09.1e-1[08.2E+2\09.3e-3]08.4E+4^09.5e-5_08.6E+6`09.7e-7a08.8E+8b09.9e-9c08.0E+0d09.1e-1e08.2E+2f09.3e-3g08.4E+4h09.5e-5i08.6E+6j09.7e-7k08.8E+8l09.9e-9m08.0E+0n09.1e-1o08.2E+2p09.3e-3q08.4E+4r09.5e-5s08.6E+6t09.7e-7u08.8E+8v09.9e-9w08.0E+0x09.1e-1y08.2E+2z09.3e-3{08.4E+4|09.5e-5}08.6E+6~09.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-508.6E+609.7e-708.8E+809.9e-908.0E+009.1e-108.2E+209.3e-308.4E+409.5e-50A 0B0C0D0F0G0H0I0J0K	0L
0M0N0O
0P0Q0R0S0T0U0V0W0Y0Z0_0a0b0c0d0f0g0h0i 0j!0k"0l#0m$0n%0o&0p'0q(0r)0s*0t+0u,0v-0w.0y/0z:0A;0B<0C=0D>0F?0G@0H[0I\0J]0K^0L`0M{0N|0O}0P~0Q0R0S0T0U0V0W0Y0Z0_0a0b0c0d0f0g0h0i0j0k0l0m0n0o0p0q0r0s0t0u0v0w0y0z0A0B0C0D0F0G0H0I0J0K0L0M0N0O0P0Q0R0S0T0U0V0W0Y0Z0_0a0b0c0d0f0g0h0i0j0k0l0m0n0o0p0q0r0s0t0u0v0w0y0z0A0B0C0D0F0G0H0I0J0K0L0M0N0O0P0Q0R0S0T0U0V0W0Y0Z0_0a0b0c0d0f0g0h0i0j0k0l0m0n0o0p0q0r0s0t0u0v0EA 0eB0EC0eD0EE0eF0EG0eH0EI0eJ	0EK
0eL0EM0eN
0EO0eP0EQ0eR0ES0eT0EU0eV0EW0eX0EY0eZ0E_0ea0Eb0ec0Ed0ee0Ef 0eg!0Eh"0ei#0Ej$0ek%0El&0em'0En(0eo)0Ep*0eq+0Er,0es-0Et.0eu/0Ev:0ew;0Ex<0ey=0Ez>0eA?0EB@0eC[0ED\0eE]0EF^0eG`0EH{0eI|0EJ}0eK~0EL0eM0EN0eO0EP0eQ0ER0eS0ET0eU0EV0eW0EX0eY0EZ0e_0Ea0eb0Ec0ed0Ee0ef0Eg0eh0Ei0ej0Ek0el0Em0en0Eo0ep0Eq0er0Es0et0Eu0ev0Ew0ex0Ey0ez0EA0eB0EC0eD0EE0eF0EG0eH0EI0eJ0EK0eL0EM0eN0EO0eP0EQ0eR0ES0eT0EU0eV0EW0eX0EY0eZ0E_0ea0Eb0ec0Ed0ee0Ef0eg0Eh0ei0Ej0ek0El0em0En0eo0Ep0eq0Er0es0Et0eu0Ev0ew0Ex0ey0Ez0eA0EB0eC0ED0eE0EF0eG0EH0eI0EJ0eK0EL0eM0EN0eO0EP0eQ0ER0eS0ET0eU0EV0eW0EX0eY0EZ0e_0Ea0eb0Ec0ed0Ee0ef0Eg0XG 0xH0XI0xJ0XK0xL0XM0xN0XO0xP	0XQ
0xR0XS0xT
0XU0xV0XW0xX0XY0xZ0X_0xg0Xh0xi0Xj0xk0Xl0xm0Xn0xo0Xp0xq0Xr 0xs!0Xt"0xu#0Xv$0xw%0Xx&0xy'0Xz(0xG)0XH*0xI+0XJ,0xK-0XL.0xM/0XN:0xO;0XP<0xQ=0XR>0xS?0XT@0xU[0XV\0xW]0XX^0xY`0XZ{0x_|0Xg}0xh~0Xi0xj0Xk0xl0Xm0xn0Xo0xp0Xq0xr0Xs0xt0Xu0xv0Xw0xx0Xy0xz0XG0xH0XI0xJ0XK0xL0XM0xN0XO0xP0XQ0xR0XS0xT0XU0xV0XW0xX0XY0xZ0X_0xg0Xh0xi0Xj0xk0Xl0xm0Xn0xo0Xp0xq0Xr0xs0Xt0xu0Xv0xw0Xx0xy0Xz0xG0XH0xI0XJ0xK0XL0xM0XN0xO0XP0xQ0XR0xS0XT0xU0XV0xW0XX0xY0XZ0x_0Xg0xh0Xi0xj0Xk0xl0Xm0xn0Xo0xp0Xq0xr0Xs0xt0Xu0xv0Xw0xx0Xy0xz0XG0xH0XI0xJ0XK0xL0XM0xN0XO0xP0XQ0xR0XS0xT0XU0xV0XW0xX0XY0xZ0X_0xg0Xh0xi0Xj0xk0Xl0xm0Xn0X0G 0x1H0X2I0x3J0X4K0x5L0X6M0x7N0X8O0x9P	0XAQ
0xBR0XCS0xDT
0XEU0xFV0XaW0xbX0XcY0xdZ0Xe_0xfg0X0h0x1i0X2j0x3k0X4l0x5m0X6n0x7o0X8p0x9q0XAr 0xBs!0XCt"0xDu#0XEv$0xFw%0Xax&0xby'0Xcz(0xdG)0XeH*0xfI+0X0J,0x1K-0X2L.0x3M/0X4N:0x5O;0X6P<0x7Q=0X8R>0x9S?0XAT@0xBU[0XCV\0xDW]0XEX^0xFY`0XaZ{0xb_|0Xcg}0xdh~0Xei0xfj0X0k0x1l0X2m0x3n0X4o0x5p0X6q0x7r0X8s0x9t0XAu0xBv0XCw0xDx0XEy0xFz0XaG0xbH0XcI0xdJ0XeK0xfL0X0M0x1N0X2O0x3P0X4Q0x5R0X6S0x7T0X8U0x9V0XAW0xBX0XCY0xDZ0XE_0xFg0Xah0xbi0Xcj0xdk0Xel0xfm0X0n0x1o0X2p0x3q0X4r0x5s0X6t0x7u0X8v0x9w0XAx0xBy0XCz0xDG0XEH0xFI0XaJ0xbK0XcL0xdM0XeN0xfO0X0P0x1Q0X2R0x3S0X4T0x5U0X6V0x7W0X8X0x9Y0XAZ0xB_0XCg0xDh0XEi0xFj0Xak0xbl0Xcm0xdn0Xeo0xfp0X0q0x1r0X2s0x3t0X4u0x5v0X6w0x7x0X8y0x9z0XAG0xBH0XCI0xDJ0XEK0xFL0XaM0xbN0XcO0xdP0XeQ0xfR0X0S0x1T0X2U0x3V0X4W0x5X0X6Y0x7Z0X8_0x9g0XAh0xBi0XCj0xDk0XEl0xFm0Xan0X00G 0x11H0X22I0x33J0X44K0x55L0X66M0x77N0X88O0x99P	0XAAQ
0xBBR0XCCS0xDDT
0XEEU0xFFV0XaaW0xbbX0XccY0xddZ0Xee_0xffg0X00h0x11i0X22j0x33k0X44l0x55m0X66n0x77o0X88p0x99q0XAAr 0xBBs!0XCCt"0xDDu#0XEEv$0xFFw%0Xaax&0xbby'0Xccz(0xddG)0XeeH*0xffI+0X00J,0x11K-0X22L.0x33M/0X44N:0x55O;0X66P<0x77Q=0X88R>0x99S?0XAAT@0xBBU[0XCCV\0xDDW]0XEEX^0xFFY`0XaaZ{0xbb_|0Xccg}0xddh~0Xeei0xffj0X00k0x11l0X22m0x33n0X44o0x55p0X66q0x77r0X88s0x99t0XAAu0xBBv0XCCw0xDDx0XEEy0xFFz0XaaG0xbbH0XccI0xddJ0XeeK0xffL0X00M0x11N0X22O0x33P0X44Q0x55R0X66S0x77T0X88U0x99V0XAAW0xBBX0XCCY0xDDZ0XEE_0xFFg0Xaah0xbbi0Xccj0xddk0Xeel0xffm0X00n0x11o0X22p0x33q0X44r0x55s0X66t0x77u0X88v0x99w0XAAx0xBBy0XCCz0xDDG0XEEH0xFFI0XaaJ0xbbK0XccL0xddM0XeeN0xffO0X00P0x11Q0X22R0x33S0X44T0x55U0X66V0x77W0X88X0x99Y0XAAZ0xBB_0XCCg0xDDh0XEEi0xFFj0Xaak0xbbl0Xccm0xddn0Xeeo0xffp0X00q0x11r0X22s0x33t0X44u0x55v0X66w0x77x0X88y0x99z0XAAG0xBBH0XCCI0xDDJ0XEEK0xFFL0XaaM0xbbN0XccO0xddP0XeeQ0xffR0X00S0x11T0X22U0x33V0X44W0x55X0X66Y0x77Z0X88_0x99g0XAAh0xBBi0XCCj0xDDk0XEEl0xFFm0Xaan0X0 0x10X20x30X40x50X60x70X80x9	0XA
0xB0XC0xD
0XE0xF0Xa0xb0Xc0xd0Xe0xf0X00x10X20x30X40x50X60x70X80x90XA 0xB!0XC"0xD#0XE$0xF%0Xa&0xb'0Xc(0xd)0Xe*0xf+0X0,0x1-0X2.0x3/0X4:0x5;0X6<0x7=0X8>0x9?0XA@0xB[0XC\0xD]0XE^0xF`0Xa{0xb|0Xc}0xd~0Xe0xf0X00x10X20x30X40x50X60x70X80x90XA0xB0XC0xD0XE0xF0Xa0xb0Xc0xd0Xe0xf0X00x10X20x30X40x50X60x70X80x90XA0xB0XC0xD0XE0xF0Xa0xb0Xc0xd0Xe0xf0X00x10X20x30X40x50X60x70X80x90XA0xB0XC0xD0XE0xF0Xa0xb0Xc0xd0Xe0xf0X00x10X20x30X40x50X60x70X80x90XA0xB0XC0xD0XE0xF0Xa0xb0Xc0xd0Xe0xf0X00x10X20x30X40x50X60x70X80x90XA0xB0XC0xD0XE0xF0Xa0xb0Xc0xd0Xe0xf0X00x10X20x30X40x50X60x70X80x90XA0xB0XC0xD0XE0xF0Xa0X 0x0X0x0X0x0X0x0X0x	0X
0x0X0x
0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X 0x!0X"0x#0X$0x%0X&0x'0X(0x)0X*0x+0X,0x-0X.0x/0X:0x;0X<0x=0X>0x?0X@0x[0X\0x]0X^0x`0X{0x|0X}0x~0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0x0X0 000000000	0
000
0000000000000000000 0!0"0#0$0%0&0'0(0)0*0+0,0-0/0:0;0<0=0>0?0@0[0\0]0^0`0{0|0}0~00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010.0E+0 21.1e-132.2E+243.3e-354.4E+465.5e-576.6E+687.7e-798.8E+819.9e-9	20.0E+0
31.1e-142.2E+253.3e-3
64.4E+475.5e-586.6E+697.7e-718.8E+829.9e-930.0E+041.1e-152.2E+263.3e-374.4E+485.5e-596.6E+617.7e-728.8E+839.9e-940.0E+051.1e-162.2E+2 73.3e-3!84.4E+4"95.5e-5#16.6E+6$27.7e-7%38.8E+8&49.9e-9'50.0E+0(61.1e-1)72.2E+2*83.3e-3+94.4E+4,15.5e-5-26.6E+6.37.7e-7/48.8E+8:59.9e-9;60.0E+0<71.1e-1=82.2E+2>93.3e-3?14.4E+4@25.5e-5A36.6E+6B47.7e-7C58.8E+8D69.9e-9E70.0E+0F81.1e-1G92.2E+2H13.3e-3I24.4E+4J35.5e-5K46.6E+6L57.7e-7M68.8E+8N79.9e-9O80.0E+0P91.1e-1Q12.2E+2R23.3e-3S34.4E+4T45.5e-5U56.6E+6V67.7e-7W78.8E+8X89.9e-9Y90.0E+0Z11.1e-1[22.2E+2\33.3e-3]44.4E+4^55.5e-5_66.6E+6`77.7e-7a88.8E+8b99.9e-9c10.0E+0d21.1e-1e32.2E+2f43.3e-3g54.4E+4h65.5e-5i76.6E+6j87.7e-7k98.8E+8l19.9e-9m20.0E+0n31.1e-1o42.2E+2p53.3e-3q64.4E+4r75.5e-5s86.6E+6t97.7e-7u18.8E+8v29.9e-9w30.0E+0x41.1e-1y52.2E+2z63.3e-3{74.4E+4|85.5e-5}96.6E+6~17.7e-728.8E+839.9e-940.0E+051.1e-162.2E+273.3e-384.4E+495.5e-516.6E+627.7e-738.8E+849.9e-950.0E+061.1e-172.2E+283.3e-394.4E+415.5e-526.6E+637.7e-748.8E+859.9e-960.0E+071.1e-182.2E+293.3e-314.4E+425.5e-536.6E+647.7e-758.8E+869.9e-970.0E+081.1e-192.2E+213.3e-324.4E+435.5e-546.6E+657.7e-768.8E+879.9e-980.0E+091.1e-112.2E+223.3e-334.4E+445.5e-556.6E+667.7e-778.8E+889.9e-990.0E+011.1e-122.2E+233.3e-344.4E+455.5e-566.6E+677.7e-788.8E+899.9e-910.0E+021.1e-132.2E+243.3e-354.4E+465.5e-576.6E+687.7e-798.8E+819.9e-920.0E+031.1e-142.2E+253.3e-364.4E+475.5e-586.6E+697.7e-718.8E+829.9e-930.0E+041.1e-152.2E+263.3e-374.4E+485.5e-596.6E+617.7e-728.8E+839.9e-940.0E+051.1e-162.2E+273.3e-384.4E+495.5e-516.6E+627.7e-738.8E+849.9e-950.0E+061.1e-172.2E+283.3e-394.4E+415.5e-526.6E+637.7e-748.8E+859.9e-960.0E+071.1e-182.2E+293.3e-314.4E+425.5e-536.6E+647.7e-758.8E+869.9e-970.0E+081.1e-192.2E+213.3e-324.4E+435.5e-510A 21B32C43D54F65G76H87I98J19K	20L
31M42N53O
64P75Q86R97S18T29U30V41W52X63Y74Z85_96a17b28c39d40f51g62h 73i!84j"95k#16l$27m%38n&49o'50p(61q)72r*83s+94t,15u-26v.37w/48x:59y;60z<71A=82B>93C?14D@25F[36G\47H]58I^69J`70K{81L|92M}13N~24O35P46Q57R68S79T80U91V12W23X34Y45Z56_67a78b89c90d11f22g33h44i55j66k77l88m99n10o21p32q43r54s65t76u87v98w19x20y31z42A53B64C75D86F97G18H29I30J41K52L63M74N85O96P17Q28R39S40T51U62V73W84X95Y16Z27_38a49b50c61d72f83g94h15i26j37k48l59m60n71o82p93q14r25s36t47u58v69w70x81y92z13A24B35C46D57F68G79H80I91J12K23L34M45N56O67P78Q89R90S11T22U33V44W55X66Y77Z88_99a10b21c32d43f54g65h76i87j98k19l20m31n42o10EA 21eB32EC43eD54EE65eF76EG87eH98EI19eJ	20EK
31eL42EM53eN
64EO75eP86EQ97eR18ES29eT30EU41eV52EW63eX74EY85eZ96E_17ea28Eb39ec40Ed51ee62Ef 73eg!84Eh"95ei#16Ej$27ek%38El&49em'50En(61eo)72Ep*83eq+94Er,15es-26Et.37eu/48Ev:59ew;60Ex<71ey=82Ez>93eA?14EB@25eC[36ED\47eE]58EF^69eG`70EH{81eI|92EJ}13eK~24EL35eM46EN57eO68EP79eQ80ER91eS12ET23eU34EV45eW56EX67eY78EZ89e_90Ea11eb22Ec33ed44Ee55ef66Eg77eh88Ei99ej10Ek21el32Em43en54Eo65ep76Eq87er98Es19et20Eu31ev42Ew53ex64Ey75ez86EA97eB18EC29eD30EE41eF52EG63eH74EI85eJ96EK17eL28EM39eN40EO51eP62EQ73eR84ES95eT16EU27eV38EW49eX50EY61eZ72E_83ea94Eb15ec26Ed37ee48Ef59eg60Eh71ei82Ej93ek14El25em36En47eo58Ep69eq70Er81es92Et13eu24Ev35ew46Ex57ey68Ez79eA80EB91eC12ED23eE34EF45eG56EH67eI78EJ89eK90EL11eM22EN33eO44EP55eQ66ER77eS88ET99eU10EV21eW32EX43eY54EZ65e_76Ea87eb98Ec19ed20Ee31ef42Eg10 213243546576879819	20
314253
64758697182930415263748596172839405162 73!84"95#16$27%38&49'50(61)72*83+94,15-26/37:48;59<60=71>82?93@14[25\36]47^58`69{70|81}92~1324354657687980911223344556677889901122334455667788991021324354657687981920314253647586971829304152637485961728394051627384951627384950617283941526374859607182931425364758697081921324354657687980911223344556677889901122334455667788991021324354657687981920311.0E+0 2.1e-13.2E+24.3e-35.4E+46.5e-57.6E+68.7e-79.8E+81.9e-9	2.0E+0
3.1e-14.2E+25.3e-3
6.4E+47.5e-58.6E+69.7e-71.8E+82.9e-93.0E+04.1e-15.2E+26.3e-37.4E+48.5e-59.6E+61.7e-72.8E+83.9e-94.0E+05.1e-16.2E+2 7.3e-3!8.4E+4"9.5e-5#1.6E+6$2.7e-7%3.8E+8&4.9e-9'5.0E+0(6.1e-1)7.2E+2*8.3e-3+9.4E+4,1.5e-5-2.6E+6.3.7e-7/4.8E+8:5.9e-9;6.0E+0<7.1e-1=8.2E+2>9.3e-3?1.4E+4@2.5e-5A3.6E+6B4.7e-7C5.8E+8D6.9e-9E7.0E+0F8.1e-1G9.2E+2H1.3e-3I2.4E+4J3.5e-5K4.6E+6L5.7e-7M6.8E+8N7.9e-9O8.0E+0P9.1e-1Q1.2E+2R2.3e-3S3.4E+4T4.5e-5U5.6E+6V6.7e-7W7.8E+8X8.9e-9Y9.0E+0Z1.1e-1[2.2E+2\3.3e-3]4.4E+4^5.5e-5_6.6E+6`7.7e-7a8.8E+8b9.9e-9c1.0E+0d2.1e-1e3.2E+2f4.3e-3g5.4E+4h6.5e-5i7.6E+6j8.7e-7k9.8E+8l1.9e-9m2.0E+0n3.1e-1o4.2E+2p5.3e-3q6.4E+4r7.5e-5s8.6E+6t9.7e-7u1.8E+8v2.9e-9w3.0E+0x4.1e-1y5.2E+2z6.3e-3{7.4E+4|8.5e-5}9.6E+6~1.7e-72.8E+83.9e-94.0E+05.1e-16.2E+27.3e-38.4E+49.5e-51.6E+62.7e-73.8E+84.9e-95.0E+06.1e-17.2E+28.3e-39.4E+41.5e-52.6E+63.7e-74.8E+85.9e-96.0E+07.1e-18.2E+29.3e-31.4E+42.5e-53.6E+64.7e-75.8E+86.9e-97.0E+08.1e-19.2E+21.3e-32.4E+43.5e-54.6E+65.7e-76.8E+87.9e-98.0E+09.1e-11.2E+22.3e-33.4E+44.5e-55.6E+66.7e-77.8E+88.9e-99.0E+01.1e-12.2E+23.3e-34.4E+45.5e-56.6E+67.7e-78.8E+89.9e-91.0E+02.1e-13.2E+24.3e-35.4E+46.5e-57.6E+68.7e-79.8E+81.9e-92.0E+03.1e-14.2E+25.3e-36.4E+47.5e-58.6E+69.7e-71.8E+82.9e-93.0E+04.1e-15.2E+26.3e-37.4E+48.5e-59.6E+61.7e-72.8E+83.9e-94.0E+05.1e-16.2E+27.3e-38.4E+49.5e-51.6E+62.7e-73.8E+84.9e-95.0E+06.1e-17.2E+28.3e-39.4E+41.5e-52.6E+63.7e-74.8E+85.9e-96.0E+07.1e-18.2E+29.3e-31.4E+42.5e-53.6E+64.7e-75.8E+86.9e-97.0E+08.1e-19.2E+21.3e-32.4E+43.5e-51A 2B3C4D5F6G7H8I9J1K	2L
3M4N5O
6P7Q8R9S1T2U3V4W5X6Y7Z8_9a1b2c3d4f5g6h 7i!8j"9k#1l$2m%3n&4o'5p(6q)7r*8s+9t,1u-2v.3w/4x:5y;6z<7A=8B>9C?1D@2F[3G\4H]5I^6J`7K{8L|9M}1N~2O3P4Q5R6S7T8U9V1W2X3Y4Z5_6a7b8c9d1f2g3h4i5j6k7l8m9n1o2p3q4r5s6t7u8v9w1x2y3z4A5B6C7D8F9G1H2I3J4K5L6M7N8O9P1Q2R3S4T5U6V7W8X9Y1Z2_3a4b5c6d7f8g9h1i2j3k4l5m6n7o8p9q1r2s3t4u5v6w7x8y9z1A2B3C4D5F6G7H8I9J1K2L3M4N5O6P7Q8R9S1T2U3V4W5X6Y7Z8_9a1b2c3d4f5g6h7i8j9k1l2m3n4o1EA 2eB3EC4eD5EE6eF7EG8eH9EI1eJ	2EK
3eL4EM5eN
6EO7eP8EQ9eR1ES2eT3EU4eV5EW6eX7EY8eZ9E_1ea2Eb3ec4Ed5ee6Ef 7eg!8Eh"9ei#1Ej$2ek%3El&4em'5En(6eo)7Ep*8eq+9Er,1es-2Et.3eu/4Ev:5ew;6Ex<7ey=8Ez>9eA?1EB@2eC[3ED\4eE]5EF^6eG`7EH{8eI|9EJ}1eK~2EL3eM4EN5eO6EP7eQ8ER9eS1ET2eU3EV4eW5EX6eY7EZ8e_9Ea1eb2Ec3ed4Ee5ef6Eg7eh8Ei9ej1Ek2el3Em4en5Eo6ep7Eq8er9Es1et2Eu3ev4Ew5ex6Ey7ez8EA9eB1EC2eD3EE4eF5EG6eH7EI8eJ9EK1eL2EM3eN4EO5eP6EQ7eR8ES9eT1EU2eV3EW4eX5EY6eZ7E_8ea9Eb1ec2Ed3ee4Ef5eg6Eh7ei8Ej9ek1El2em3En4eo5Ep6eq7Er8es9Et1eu2Ev3ew4Ex5ey6Ez7eA8EB9eC1ED2eE3EF4eG5EH6eI7EJ8eK9EL1eM2EN3eO4EP5eQ6ER7eS8ET9eU1EV2eW3EX4eY5EZ6e_7Ea8eb9Ec1ed2Ee3ef4Eg1 234567891	2
345
6789123456789123456 7!8"9#1$2%3&4'5(6)7*8+9,1-2/3:4;5<6=7>8?9@1[2\3]4^5`6{7|8}9~123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789123456789123:=A0 B1C2D3E4F5G6H7I8J9	KA
LBMCND
OEPFQGRHSITJUKVLWMXNYOZP_QaRbScTdUeVgW hX!iY"jZ#k_$la%mb&oc'pd(qe)rf*sg+uh,vi-wj.xk/yl:zm;An<Bo=Cp>Dq?Er@Fs[Gt\Hu]Iv^Jw`Kx{Ly|Mz}N0~O1P2Q3R4S5T6U7V8W9XAYBZC_DaEbFcGdHeIgJhKiLjMkNlOmPoQpRqSrTsUuVvWwXxYyZz_AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz_0a1b2c3d4e5g6h7i8j9kAlBmCoDpEqFrGsHuIvJwKxLyMzNAOBPCQDRESFTGUHVIWJXKYLZM_NaObPcQdReSfTgUhViWjXkYlZm_naobpcqdresgthuivjwkxlymzo0p1q2r3A BCDEFGHIJ	K
LMN
OPQRSTUVWXYZ_abcdeg h!i"j#k$l%m&o'p(q)r*s+u,v-w.x/y:z;A<B=C>D?E@F[G\H]I^J`K{L|M}N~OPQRSTUVWXYZ_abcdeghijklmopqrsuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdeghijklmopqrsuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdeghijklmopqr[]f0 f1f2f3f4f5f6f7f8f9	fA
fBfCfD
fEfFfGfHfIfJfKfLfMfNfOfPfQfRfSfTfUfVfW fX!fY"fZ#f_$fb%fc&fd'fe(ff)fg*fh+fi,fj-fk.fl/fm:fn;fo<fp=fq>fr?fs@ft[fu\fv]fw^fx`fy{fz|f0}f1~f2f3f4f5f6f7f8f9fAfBfCfDfEfFfGfHfIfJfKfLfMfNfOfPfQfRfSfTfUfVfWfXfYfZf_fbfcfdfefffgfhfifjfkflfmfnfofpfqfrfsftfufvfwfxfyfzf0f1f2f3f4f5f6f7f8f9fAfBfCfDfEfFfGfHfIfJfKfLfMfNfOfPfQfRfSfTfUfVfWfXfYfZf_fbfcfdfefffgfhfifjfkflfmfnfofpfqfrfsftfufvfwfxfyfzf0f1f2f3f4f5f6fa0 fa1fa2fa3fa4fa5fa6fa7fa8fa9	faA
faBfaCfaD
faEfaFfaGfaHfaIfaJfaKfaLfaMfaNfaOfaPfaQfaRfaSfaTfaUfaVfaW faX!faY"faZ#fa_$faa%fab&fac'fad(fae)faf*fag+fah,fai-faj.fak/fam:fan;fao<fap=faq>far?fas@fat[fau\fav]faw^fax`fay{faz|fa0}fa1~fa2fa3fa4fa5fa6fa7fa8fa9faAfaBfaCfaDfaEfaFfaGfaHfaIfaJfaKfaLfaMfaNfaOfaPfaQfaRfaSfaTfaUfaVfaWfaXfaYfaZfa_faafabfacfadfaefaffagfahfaifajfakfamfanfaofapfaqfarfasfatfaufavfawfaxfayfazfa0fa1fa2fa3fa4fa5fa6fa7fa8fa9faAfaBfaCfaDfaEfaFfaGfaHfaIfaJfaKfaLfaMfaNfaOfaPfaQfaRfaSfaTfaUfaVfaWfaXfaYfaZfa_faafabfacfadfaefaffagfahfaifajfakfamfanfaofapfaqfarfasfatfaufavfawfaxfayfazfa0fa1fa2fa3fa4fa5fa6fal0 fal1fal2fal3fal4fal5fal6fal7fal8fal9	falA
falBfalCfalD
falEfalFfalGfalHfalIfalJfalKfalLfalMfalNfalOfalPfalQfalRfalSfalTfalUfalVfalW falX!falY"falZ#fal_$fala%falb&falc'fald(fale)falf*falg+falh,fali-falj.falk/fall:falm;faln<falo=falp>falq?falr@falt[falu\falv]falw^falx`faly{falz|fal0}fal1~fal2fal3fal4fal5fal6fal7fal8fal9falAfalBfalCfalDfalEfalFfalGfalHfalIfalJfalKfalLfalMfalNfalOfalPfalQfalRfalSfalTfalUfalVfalWfalXfalYfalZfal_falafalbfalcfaldfalefalffalgfalhfalifaljfalkfallfalmfalnfalofalpfalqfalrfaltfalufalvfalwfalxfalyfalzfal0fal1fal2fal3fal4fal5fal6fal7fal8fal9falAfalBfalCfalDfalEfalFfalGfalHfalIfalJfalKfalLfalMfalNfalOfalPfalQfalRfalSfalTfalUfalVfalWfalXfalYfalZfal_falafalbfalcfaldfalefalffalgfalhfalifaljfalkfallfalmfalnfalofalpfalqfalrfaltfalufalvfalwfalxfalyfalzfal0fal1fal2fal3fal4fal5fal6fals0 fals1fals2fals3fals4fals5fals6fals7fals8fals9	falsA
falsBfalsCfalsD
falsEfalsFfalsGfalsHfalsIfalsJfalsKfalsLfalsMfalsNfalsOfalsPfalsQfalsRfalsSfalsTfalsUfalsVfalsW falsX!falsY"falsZ#fals_$falsa%falsb&falsc'falsd(falsf)falsg*falsh+falsi,falsj-falsk.falsl/falsm:falsn;falso<falsp=falsq>falsr?falss@falst[falsu\falsv]falsw^falsx`falsy{falsz|fals0}fals1~fals2fals3fals4fals5fals6fals7fals8fals9falsAfalsBfalsCfalsDfalsEfalsFfalsGfalsHfalsIfalsJfalsKfalsLfalsMfalsNfalsOfalsPfalsQfalsRfalsSfalsTfalsUfalsVfalsWfalsXfalsYfalsZfals_falsafalsbfalscfalsdfalsffalsgfalshfalsifalsjfalskfalslfalsmfalsnfalsofalspfalsqfalsrfalssfalstfalsufalsvfalswfalsxfalsyfalszfals0fals1fals2fals3fals4fals5fals6fals7fals8fals9falsAfalsBfalsCfalsDfalsEfalsFfalsGfalsHfalsIfalsJfalsKfalsLfalsMfalsNfalsOfalsPfalsQfalsRfalsSfalsTfalsUfalsVfalsWfalsXfalsYfalsZfals_falsafalsbfalscfalsdfalsffalsgfalshfalsifalsjfalskfalslfalsmfalsnfalsofalspfalsqfalsrfalssfalstfalsufalsvfalswfalsxfalsyfalszfals0fals1fals2fals3fals4fals5fals6false0 false1false2false3false4false5false6false7false8false9	falseA
falseBfalseCfalseD
falseEfalseFfalseGfalseHfalseIfalseJfalseKfalseLfalseMfalseNfalseOfalsePfalseQfalseRfalseSfalseTfalseUfalseVfalseW falseX!falseY"falseZ#false_$falsea%falseb&falsec'falsed(falsee)falsef*falseg+falseh,falsei-falsej.falsek/falsel:falsem;falsen<falseo=falsep>falseq?falser@falses[falset\falseu]falsev^falsew`falsex{falsey|falsez}false0~false1false2false3false4false5false6false7false8false9falseAfalseBfalseCfalseDfalseEfalseFfalseGfalseHfalseIfalseJfalseKfalseLfalseMfalseNfalseOfalsePfalseQfalseRfalseSfalseTfalseUfalseVfalseWfalseXfalseYfalseZfalse_falseafalsebfalsecfalsedfalseefalseffalsegfalsehfalseifalsejfalsekfalselfalsemfalsenfalseofalsepfalseqfalserfalsesfalsetfalseufalsevfalsewfalsexfalseyfalsezfalse0false1false2false3false4false5false6false7false8false9falseAfalseBfalseCfalseDfalseEfalseFfalseGfalseHfalseIfalseJfalseKfalseLfalseMfalseNfalseOfalsePfalseQfalseRfalseSfalseTfalseUfalseVfalseWfalseXfalseYfalseZfalse_falseafalsebfalsecfalsedfalseefalseffalsegfalsehfalseifalsejfalsekfalselfalsemfalsenfalseofalsepfalseqfalserfalsesfalsetfalseufalsevfalsewfalsexfalseyfalsezfalse0false1false2false3false falsefalsefalsefalsefalsefalsefalsefalsefalse	false
falsefalsefalse
falsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalse false!false"false#false$false%false&false'false(false)false*false+false,false-false.false/false:false;false<false=false>false?false@false[false\false]false^false`false{false|false}false~falsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefalsefals falsfalsfalsfalsfalsfalsfalsfalsfals	fals
falsfalsfals
falsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfals fals!fals"fals#fals$fals%fals&fals'fals(fals)fals*fals+fals,fals-fals.fals/fals:fals;fals<fals=fals>fals?fals@fals[fals\fals]fals^fals`fals{fals|fals}fals~falsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfalsfal falfalfalfalfalfalfalfalfal	fal
falfalfal
falfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfal fal!fal"fal#fal$fal%fal&fal'fal(fal)fal*fal+fal,fal-fal.fal/fal:fal;fal<fal=fal>fal?fal@fal[fal\fal]fal^fal`fal{fal|fal}fal~falfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfalfa fafafafafafafafafa	fa
fafafa
fafafafafafafafafafafafafafafafafafafa fa!fa"fa#fa$fa%fa&fa'fa(fa)fa*fa+fa,fa-fa.fa/fa:fa;fa<fa=fa>fa?fa@fa[fa\fa]fa^fa`fa{fa|fa}fa~fafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafafaf fffffffff	f
fff
fffffffffffffffffff f!f"f#f$f%f&f'f(f)f*f+f,f-f.f/f:f;f<f=f>f?f@f[f\f]f^f`f{f|f}f~fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffn0 n1n2n3n4n5n6n7n8n9	nA
nBnCnD
nEnFnGnHnInJnKnLnMnNnOnPnQnRnSnTnUnVnW nX!nY"nZ#n_$na%nb&nc'nd(ne)nf*ng+nh,ni-nj.nk/nl:nm;nn<no=np>nq?nr@ns[nt\nv]nw^nx`ny{nz|n0}n1~n2n3n4n5n6n7n8n9nAnBnCnDnEnFnGnHnInJnKnLnMnNnOnPnQnRnSnTnUnVnWnXnYnZn_nanbncndnenfngnhninjnknlnmnnnonpnqnrnsntnvnwnxnynzn0n1n2n3n4n5n6n7n8n9nAnBnCnDnEnFnGnHnInJnKnLnMnNnOnPnQnRnSnTnUnVnWnXnYnZn_nanbncndnenfngnhninjnknlnmnnnonpnqnrnsntnvnwnxnynzn0n1n2n3n4n5n6nu0 nu1nu2nu3nu4nu5nu6nu7nu8nu9	nuA
nuBnuCnuD
nuEnuFnuGnuHnuInuJnuKnuLnuMnuNnuOnuPnuQnuRnuSnuTnuUnuVnuW nuX!nuY"nuZ#nu_$nua%nub&nuc'nud(nue)nuf*nug+nuh,nui-nuj.nuk/num:nun;nuo<nup=nuq>nur?nus@nut[nuu\nuv]nuw^nux`nuy{nuz|nu0}nu1~nu2nu3nu4nu5nu6nu7nu8nu9nuAnuBnuCnuDnuEnuFnuGnuHnuInuJnuKnuLnuMnuNnuOnuPnuQnuRnuSnuTnuUnuVnuWnuXnuYnuZnu_nuanubnucnudnuenufnugnuhnuinujnuknumnunnuonupnuqnurnusnutnuunuvnuwnuxnuynuznu0nu1nu2nu3nu4nu5nu6nu7nu8nu9nuAnuBnuCnuDnuEnuFnuGnuHnuInuJnuKnuLnuMnuNnuOnuPnuQnuRnuSnuTnuUnuVnuWnuXnuYnuZnu_nuanubnucnudnuenufnugnuhnuinujnuknumnunnuonupnuqnurnusnutnuunuvnuwnuxnuynuznu0nu1nu2nu3nu4nu5nu6nul0 nul1nul2nul3nul4nul5nul6nul7nul8nul9	nulA
nulBnulCnulD
nulEnulFnulGnulHnulInulJnulKnulLnulMnulNnulOnulPnulQnulRnulSnulTnulUnulVnulW nulX!nulY"nulZ#nul_$nula%nulb&nulc'nuld(nule)nulf*nulg+nulh,nuli-nulj.nulk/nulm:nuln;nulo<nulp=nulq>nulr?nuls@nult[nulu\nulv]nulw^nulx`nuly{nulz|nul0}nul1~nul2nul3nul4nul5nul6nul7nul8nul9nulAnulBnulCnulDnulEnulFnulGnulHnulInulJnulKnulLnulMnulNnulOnulPnulQnulRnulSnulTnulUnulVnulWnulXnulYnulZnul_nulanulbnulcnuldnulenulfnulgnulhnulinuljnulknulmnulnnulonulpnulqnulrnulsnultnulunulvnulwnulxnulynulznul0nul1nul2nul3nul4nul5nul6nul7nul8nul9nulAnulBnulCnulDnulEnulFnulGnulHnulInulJnulKnulLnulMnulNnulOnulPnulQnulRnulSnulTnulUnulVnulWnulXnulYnulZnul_nulanulbnulcnuldnulenulfnulgnulhnulinuljnulknulmnulnnulonulpnulqnulrnulsnultnulunulvnulwnulxnulynulznul0nul1nul2nul3nul4nul5nul6null0 null1null2null3null4null5null6null7null8null9	nullA
nullBnullCnullD
nullEnullFnullGnullHnullInullJnullKnullLnullMnullNnullOnullPnullQnullRnullSnullTnullUnullVnullW nullX!nullY"nullZ#null_$nulla%nullb&nullc'nulld(nulle)nullf*nullg+nullh,nulli-nullj.nullk/nulll:nullm;nulln<nullo=nullp>nullq?nullr@nulls[nullt\nullu]nullv^nullw`nullx{nully|nullz}null0~null1null2null3null4null5null6null7null8null9nullAnullBnullCnullDnullEnullFnullGnullHnullInullJnullKnullLnullMnullNnullOnullPnullQnullRnullSnullTnullUnullVnullWnullXnullYnullZnull_nullanullbnullcnulldnullenullfnullgnullhnullinulljnullknulllnullmnullnnullonullpnullqnullrnullsnulltnullunullvnullwnullxnullynullznull0null1null2null3null4null5null6null7null8null9nullAnullBnullCnullDnullEnullFnullGnullHnullInullJnullKnullLnullMnullNnullOnullPnullQnullRnullSnullTnullUnullVnullWnullXnullYnullZnull_nullanullbnullcnulldnullenullfnullgnullhnullinulljnullknulllnullmnullnnullonullpnullqnullrnullsnulltnullunullvnullwnullxnullynullznull0null1null2null3null nullnullnullnullnullnullnullnullnull	null
nullnullnull
nullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnull null!null"null#null$null%null&null'null(null)null*null+null,null-null.null/null:null;null<null=null>null?null@null[null\null]null^null`null{null|null}null~nullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnullnul nulnulnulnulnulnulnulnulnul	nul
nulnulnul
nulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnul nul!nul"nul#nul$nul%nul&nul'nul(nul)nul*nul+nul,nul-nul.nul/nul:nul;nul<nul=nul>nul?nul@nul[nul\nul]nul^nul`nul{nul|nul}nul~nulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnulnu nununununununununu	nu
nununu
nununununununununununununununununununu nu!nu"nu#nu$nu%nu&nu'nu(nu)nu*nu+nu,nu-nu.nu/nu:nu;nu<nu=nu>nu?nu@nu[nu\nu]nu^nu`nu{nu|nu}nu~nununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununununun nnnnnnnnn	n
nnn
nnnnnnnnnnnnnnnnnnn n!n"n#n$n%n&n'n(n)n*n+n,n-n.n/n:n;n<n=n>n?n@n[n\n]n^n`n{n|n}n~nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnt0 t1t2t3t4t5t6t7t8t9	tA
tBtCtD
tEtFtGtHtItJtKtLtMtNtOtPtQtRtStTtUtVtW tX!tY"tZ#t_$ta%tb&tc'td(te)tf*tg+th,ti-tj.tk/tl:tm;tn<to=tp>tq?ts@tt[tu\tv]tw^tx`ty{tz|t0}t1~t2t3t4t5t6t7t8t9tAtBtCtDtEtFtGtHtItJtKtLtMtNtOtPtQtRtStTtUtVtWtXtYtZt_tatbtctdtetftgthtitjtktltmtntotptqtstttutvtwtxtytzt0t1t2t3t4t5t6t7t8t9tAtBtCtDtEtFtGtHtItJtKtLtMtNtOtPtQtRtStTtUtVtWtXtYtZt_tatbtctdtetftgthtitjtktltmtntotptqtstttutvtwtxtytzt0t1t2t3t4t5t6tr0 tr1tr2tr3tr4tr5tr6tr7tr8tr9	trA
trBtrCtrD
trEtrFtrGtrHtrItrJtrKtrLtrMtrNtrOtrPtrQtrRtrStrTtrUtrVtrW trX!trY"trZ#tr_$tra%trb&trc'trd(tre)trf*trg+trh,tri-trj.trk/trl:trm;trn<tro=trp>trq?trr@trs[trt\trv]trw^trx`try{trz|tr0}tr1~tr2tr3tr4tr5tr6tr7tr8tr9trAtrBtrCtrDtrEtrFtrGtrHtrItrJtrKtrLtrMtrNtrOtrPtrQtrRtrStrTtrUtrVtrWtrXtrYtrZtr_tratrbtrctrdtretrftrgtrhtritrjtrktrltrmtrntrotrptrqtrrtrstrttrvtrwtrxtrytrztr0tr1tr2tr3tr4tr5tr6tr7tr8tr9trAtrBtrCtrDtrEtrFtrGtrHtrItrJtrKtrLtrMtrNtrOtrPtrQtrRtrStrTtrUtrVtrWtrXtrYtrZtr_tratrbtrctrdtretrftrgtrhtritrjtrktrltrmtrntrotrptrqtrrtrstrttrvtrwtrxtrytrztr0tr1tr2tr3tr4tr5tr6tru0 tru1tru2tru3tru4tru5tru6tru7tru8tru9	truA
truBtruCtruD
truEtruFtruGtruHtruItruJtruKtruLtruMtruNtruOtruPtruQtruRtruStruTtruUtruVtruW truX!truY"truZ#tru_$trua%trub&truc'trud(truf)trug*truh+trui,truj-truk.trul/trum:trun;truo<trup=truq>trur?trus@trut[truu\truv]truw^trux`truy{truz|tru0}tru1~tru2tru3tru4tru5tru6tru7tru8tru9truAtruBtruCtruDtruEtruFtruGtruHtruItruJtruKtruLtruMtruNtruOtruPtruQtruRtruStruTtruUtruVtruWtruXtruYtruZtru_truatrubtructrudtruftrugtruhtruitrujtruktrultrumtruntruotruptruqtrurtrustruttruutruvtruwtruxtruytruztru0tru1tru2tru3tru4tru5tru6tru7tru8tru9truAtruBtruCtruDtruEtruFtruGtruHtruItruJtruKtruLtruMtruNtruOtruPtruQtruRtruStruTtruUtruVtruWtruXtruYtruZtru_truatrubtructrudtruftrugtruhtruitrujtruktrultrumtruntruotruptruqtrurtrustruttruutruvtruwtruxtruytruztru0tru1tru2tru3tru4tru5tru6true0 true1true2true3true4true5true6true7true8true9	trueA
trueBtrueCtrueD
trueEtrueFtrueGtrueHtrueItrueJtrueKtrueLtrueMtrueNtrueOtruePtrueQtrueRtrueStrueTtrueUtrueVtrueW trueX!trueY"trueZ#true_$truea%trueb&truec'trued(truee)truef*trueg+trueh,truei-truej.truek/truel:truem;truen<trueo=truep>trueq?truer@trues[truet\trueu]truev^truew`truex{truey|truez}true0~true1true2true3true4true5true6true7true8true9trueAtrueBtrueCtrueDtrueEtrueFtrueGtrueHtrueItrueJtrueKtrueLtrueMtrueNtrueOtruePtrueQtrueRtrueStrueTtrueUtrueVtrueWtrueXtrueYtrueZtrue_trueatruebtruectruedtrueetrueftruegtruehtrueitruejtruektrueltruemtruentrueotrueptrueqtruertruestruettrueutruevtruewtruextrueytrueztrue0true1true2true3true4true5true6true7true8true9trueAtrueBtrueCtrueDtrueEtrueFtrueGtrueHtrueItrueJtrueKtrueLtrueMtrueNtrueOtruePtrueQtrueRtrueStrueTtrueUtrueVtrueWtrueXtrueYtrueZtrue_trueatruebtruectruedtrueetrueftruegtruehtrueitruejtruektrueltruemtruentrueotrueptrueqtruertruestruettrueutruevtruewtruextrueytrueztrue0true1true2true3true truetruetruetruetruetruetruetruetrue	true
truetruetrue
truetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetrue true!true"true#true$true%true&true'true(true)true*true+true,true-true.true/true:true;true<true=true>true?true@true[true\true]true^true`true{true|true}true~truetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetruetru trutrutrutrutrutrutrutrutru	tru
trutrutru
trutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutru tru!tru"tru#tru$tru%tru&tru'tru(tru)tru*tru+tru,tru-tru.tru/tru:tru;tru<tru=tru>tru?tru@tru[tru\tru]tru^tru`tru{tru|tru}tru~trutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutrutr trtrtrtrtrtrtrtrtr	tr
trtrtr
trtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtr tr!tr"tr#tr$tr%tr&tr'tr(tr)tr*tr+tr,tr-tr.tr/tr:tr;tr<tr=tr>tr?tr@tr[tr\tr]tr^tr`tr{tr|tr}tr~trtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrtrt ttttttttt	t
ttt
ttttttttttttttttttt t!t"t#t$t%t&t't(t)t*t+t,t-t.t/t:t;t<t=t>t?t@t[t\t]t^t`t{t|t}t~ttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttttt{}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        




























































































































































































































































																																																																																																																																																																																																																																																													

























































































































































































































































































































































































































































































































	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	





















































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	






























































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
























































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	


































































































































































































































































































































































































































































































































































































































































































































































	






















































































































































































































































	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																											











































































































































































































































































































































































































































































































	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

























































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































  "\ "\ "		\

 "\

 "\ "\ "\ "\ "\ "\   "!!\## $$"%%\&& ''"((\)) **"++\,, --"..\// 00"11\22 33"44\55 66"77\88 99"::\;; <<"==\>> ??"@@\AA BB"CC\DD EE"FF\GG HH"II\JJ KK"LL\MM NN"OO\PP QQ"RR\SS TT"UU\VV WW"XX\YY ZZ"[[\]] ^^"__\`` aa"bb\cc dd"ee\ff gg"hh\ii jj"kk\ll mm"nn\oo pp"qq\rr ss"tt\uu vv"ww\xx yy"zz\{{ ||"}}\~~ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\  "\ "\ "	\
 "\
 "\ "\ "\ "\ "\ "\  "!\# $"%\& '"(\) *"+\, -".\/ 0"1\2 3"4\5 6"7\8 9":\; <"=\> ?"@\A B"C\D E"F\G H"I\J K"L\M N"O\P Q"R\S T"U\V W"X\Y Z"[\] ^"_\` a"b\c d"e\f g"h\i j"k\l m"n\o p"q\r s"t\u v"w\x y"z\{ |"}\~ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\ "\"\/\\\b\f\n\r\t\u0000\u1111\u2222\u3333\u4444\u5555\u6666\u7777\u8888\u9999\uAAAA\uBBBB\uCCCC\uDDDD\uEEEE\uFFFF\uaaaa\ubbbb\ucccc\udddd\ueeee\uffff\u000 \u111\u222\u333\u444\u555\u666\u777\u888\u999	\uAAA
\uBBB\uCCC\uDDD
\uEEE\uFFF\uaaa\ubbb\uccc\uddd\ueee\ufff\u000\u111\u222\u333\u444\u555\u666\u777\u888\u999\uAAA \uBBB!\uCCC"\uDDD#\uEEE$\uFFF%\uaaa&\ubbb'\uccc(\uddd)\ueee*\ufff+\u000,\u111-\u222.\u333/\u444:\u555;\u666<\u777=\u888>\u999?\uAAA@\uBBBG\uCCCH\uDDDI\uEEEJ\uFFFK\uaaaL\ubbbM\ucccN\udddO\ueeeP\ufffQ\u000R\u111S\u222T\u333U\u444V\u555W\u666X\u777Y\u888Z\u999[\uAAA\\uBBB]\uCCC^\uDDD_\uEEE`\uFFFg\uaaah\ubbbi\ucccj\udddk\ueeel\ufffm\u000n\u111o\u222p\u333q\u444r\u555s\u666t\u777u\u888v\u999w\uAAAx\uBBBy\uCCCz\uDDD{\uEEE|\uFFF}\uaaa~\ubbb\uccc\uddd\ueee\ufff\u000\u111\u222\u333\u444\u555\u666\u777\u888\u999\uAAA\uBBB\uCCC\uDDD\uEEE\uFFF\uaaa\ubbb\uccc\uddd\ueee\ufff\u000\u111\u222\u333\u444\u555\u666\u777\u888\u999\uAAA\uBBB\uCCC\uDDD\uEEE\uFFF\uaaa\ubbb\uccc\uddd\ueee\ufff\u000\u111\u222\u333\u444\u555\u666\u777\u888\u999\uAAA\uBBB\uCCC\uDDD\uEEE\uFFF\uaaa\ubbb\uccc\uddd\ueee\ufff\u000\u111\u222\u333\u444\u555\u666\u777\u888\u999\uAAA\uBBB\uCCC\uDDD\uEEE\uFFF\uaaa\ubbb\uccc\uddd\ueee\ufff\u000\u111\u222\u333\u444\u555\u666\u777\u888\u999\uAAA\uBBB\uCCC\uDDD\uEEE\uFFF\uaaa\ubbb\uccc\uddd\ueee\ufff\u000\u111\u222\u333\u444\u555\u666\u777\u888\u999\uAAA\uBBB\uCCC\uDDD\u00 \u11\u22\u33\u44\u55\u66\u77\u88\u99	\uAA
\uBB\uCC\uDD
\uEE\uFF\uaa\ubb\ucc\udd\uee\uff\u00\u11\u22\u33\u44\u55\u66\u77\u88\u99\uAA \uBB!\uCC"\uDD#\uEE$\uFF%\uaa&\ubb'\ucc(\udd)\uee*\uff+\u00,\u11-\u22.\u33/\u44:\u55;\u66<\u77=\u88>\u99?\uAA@\uBBG\uCCH\uDDI\uEEJ\uFFK\uaaL\ubbM\uccN\uddO\ueeP\uffQ\u00R\u11S\u22T\u33U\u44V\u55W\u66X\u77Y\u88Z\u99[\uAA\\uBB]\uCC^\uDD_\uEE`\uFFg\uaah\ubbi\uccj\uddk\ueel\uffm\u00n\u11o\u22p\u33q\u44r\u55s\u66t\u77u\u88v\u99w\uAAx\uBBy\uCCz\uDD{\uEE|\uFF}\uaa~\ubb\ucc\udd\uee\uff\u00\u11\u22\u33\u44\u55\u66\u77\u88\u99\uAA\uBB\uCC\uDD\uEE\uFF\uaa\ubb\ucc\udd\uee\uff\u00\u11\u22\u33\u44\u55\u66\u77\u88\u99\uAA\uBB\uCC\uDD\uEE\uFF\uaa\ubb\ucc\udd\uee\uff\u00\u11\u22\u33\u44\u55\u66\u77\u88\u99\uAA\uBB\uCC\uDD\uEE\uFF\uaa\ubb\ucc\udd\uee\uff\u00\u11\u22\u33\u44\u55\u66\u77\u88\u99\uAA\uBB\uCC\uDD\uEE\uFF\uaa\ubb\ucc\udd\uee\uff\u00\u11\u22\u33\u44\u55\u66\u77\u88\u99\uAA\uBB\uCC\uDD\uEE\uFF\uaa\ubb\ucc\udd\uee\uff\u00\u11\u22\u33\u44\u55\u66\u77\u88\u99\uAA\uBB\uCC\uDD\u0 \u1\u2\u3\u4\u5\u6\u7\u8\u9	\uA
\uB\uC\uD
\uE\uF\ua\ub\uc\ud\ue\uf\u0\u1\u2\u3\u4\u5\u6\u7\u8\u9\uA \uB!\uC"\uD#\uE$\uF%\ua&\ub'\uc(\ud)\ue*\uf+\u0,\u1-\u2.\u3/\u4:\u5;\u6<\u7=\u8>\u9?\uA@\uBG\uCH\uDI\uEJ\uFK\uaL\ubM\ucN\udO\ueP\ufQ\u0R\u1S\u2T\u3U\u4V\u5W\u6X\u7Y\u8Z\u9[\uA\\uB]\uC^\uD_\uE`\uFg\uah\ubi\ucj\udk\uel\ufm\u0n\u1o\u2p\u3q\u4r\u5s\u6t\u7u\u8v\u9w\uAx\uBy\uCz\uD{\uE|\uF}\ua~\ub\uc\ud\ue\uf\u0\u1\u2\u3\u4\u5\u6\u7\u8\u9\uA\uB\uC\uD\uE\uF\ua\ub\uc\ud\ue\uf\u0\u1\u2\u3\u4\u5\u6\u7\u8\u9\uA\uB\uC\uD\uE\uF\ua\ub\uc\ud\ue\uf\u0\u1\u2\u3\u4\u5\u6\u7\u8\u9\uA\uB\uC\uD\uE\uF\ua\ub\uc\ud\ue\uf\u0\u1\u2\u3\u4\u5\u6\u7\u8\u9\uA\uB\uC\uD\uE\uF\ua\ub\uc\ud\ue\uf\u0\u1\u2\u3\u4\u5\u6\u7\u8\u9\uA\uB\uC\uD\uE\uF\ua\ub\uc\ud\ue\uf\u0\u1\u2\u3\u4\u5\u6\u7\u8\u9\uA\uB\uC\uD\u \u\u\u\u\u\u\u\u\u	\u
\u\u\u
\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u \u!\u"\u#\u$\u%\u&\u'\u(\u)\u*\u+\u,\u-\u.\u/\u:\u;\u<\u=\u>\u?\u@\uG\uH\uI\uJ\uK\uL\uM\uN\uO\uP\uQ\uR\uS\uT\uU\uV\uW\uX\uY\uZ\u[\u\\u]\u^\u_\u`\ug\uh\ui\uj\uk\ul\um\un\uo\up\uq\ur\us\ut\uu\uv\uw\ux\uy\uz\u{\u|\u}\u~\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\u\ \\\\\\\\\	\
\\\
\\\\\\\\\\\\\\\\\\\ \!\#\$\%\&\'\(\)\*\+\,\-\.\0\1\2\3\4\5\6\7\8\9\:\;\<\=\>\?\@\A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z\[\]\^\_\`\a\c\d\e\g\h\i\j\k\l\m\o\p\q\s\v\w\x\y\z\{\|\}\~\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          re2c: warning: line 490: column 26: escape has no effect: '\/' [-Wuseless-escape]
re2c: warning: line 490: column 50: escape has no effect: '\/' [-Wuseless-escape]
re2c: warning: line 490: column 77: escape has no effect: '\/' [-Wuseless-escape]
