/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef p256ecdh_vectors_h__
#define p256ecdh_vectors_h__

#include "testvectors_base/test-structs.h"

const EcdhTestVectorStr kP256EcdhWycheproofVectors[] = {

    // Comment: normal case
    // tcID: 1
    {1,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x06, 0x12, 0x46, 0x5c, 0x89, 0xa0, 0x23, 0xab, 0x17, 0x85, 0x5b, 0x0a,
      0x6b, 0xce, 0xbf, 0xd3, 0xfe, 0xbb, 0x53, 0xae, 0xf8, 0x41, 0x38, 0x64,
      0x7b, 0x53, 0x52, 0xe0, 0x2c, 0x10, 0xc3, 0x46, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb5, 0x9c, 0xc7, 0x67, 0x1d, 0xd6, 0xa6, 0xb8, 0x36, 0xe2,
      0xcd, 0x93, 0x96, 0xef, 0x56, 0x18, 0xb2, 0xff, 0x3e, 0x81, 0x92, 0xdd,
      0x7c, 0x9d, 0x36, 0xc2, 0x7c, 0xb5, 0x6f, 0xf9, 0x16, 0x61, 0x48, 0x26,
      0xd9, 0xdb, 0xd5, 0xae, 0x64, 0xcd, 0xd8, 0x57, 0x50, 0x68, 0xbb, 0xc9,
      0xe6, 0x3f, 0x23, 0x1e, 0xa5, 0x7e, 0xd0, 0x32, 0x48, 0x84, 0x4c, 0x09,
      0x33, 0x1b, 0x95, 0x39, 0x20, 0x53},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x62, 0xd5, 0xbd, 0x33, 0x72, 0xaf, 0x75, 0xfe, 0x85,
      0xa0, 0x40, 0x71, 0x5d, 0x0f, 0x50, 0x24, 0x28, 0xe0, 0x70, 0x46, 0x86,
      0x8b, 0x0b, 0xfd, 0xfa, 0x61, 0xd7, 0x31, 0xaf, 0xe4, 0x4f, 0x26, 0xac,
      0x33, 0x3a, 0x93, 0xa9, 0xe7, 0x0a, 0x81, 0xcd, 0x5a, 0x95, 0xb5, 0xbf,
      0x8d, 0x13, 0x99, 0x0e, 0xb7, 0x41, 0xc8, 0xc3, 0x88, 0x72, 0xb4, 0xa0,
      0x7d, 0x27, 0x5a, 0x01, 0x4e, 0x30, 0xcf},
     {0x53, 0x02, 0x0d, 0x90, 0x8b, 0x02, 0x19, 0x32, 0x8b, 0x65, 0x8b,
      0x52, 0x5f, 0x26, 0x78, 0x0e, 0x3a, 0xe1, 0x2b, 0xcd, 0x95, 0x2b,
      0xb2, 0x5a, 0x93, 0xbc, 0x08, 0x95, 0xe1, 0x71, 0x42, 0x85},
     false,
     true},

    // Comment: compressed public key
    // tcID: 2
    {2,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x06, 0x12, 0x46, 0x5c, 0x89, 0xa0, 0x23, 0xab, 0x17, 0x85, 0x5b, 0x0a,
      0x6b, 0xce, 0xbf, 0xd3, 0xfe, 0xbb, 0x53, 0xae, 0xf8, 0x41, 0x38, 0x64,
      0x7b, 0x53, 0x52, 0xe0, 0x2c, 0x10, 0xc3, 0x46, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb5, 0x9c, 0xc7, 0x67, 0x1d, 0xd6, 0xa6, 0xb8, 0x36, 0xe2,
      0xcd, 0x93, 0x96, 0xef, 0x56, 0x18, 0xb2, 0xff, 0x3e, 0x81, 0x92, 0xdd,
      0x7c, 0x9d, 0x36, 0xc2, 0x7c, 0xb5, 0x6f, 0xf9, 0x16, 0x61, 0x48, 0x26,
      0xd9, 0xdb, 0xd5, 0xae, 0x64, 0xcd, 0xd8, 0x57, 0x50, 0x68, 0xbb, 0xc9,
      0xe6, 0x3f, 0x23, 0x1e, 0xa5, 0x7e, 0xd0, 0x32, 0x48, 0x84, 0x4c, 0x09,
      0x33, 0x1b, 0x95, 0x39, 0x20, 0x53},
     {0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x22, 0x00, 0x03, 0x62, 0xd5, 0xbd, 0x33, 0x72, 0xaf, 0x75, 0xfe, 0x85,
      0xa0, 0x40, 0x71, 0x5d, 0x0f, 0x50, 0x24, 0x28, 0xe0, 0x70, 0x46, 0x86,
      0x8b, 0x0b, 0xfd, 0xfa, 0x61, 0xd7, 0x31, 0xaf, 0xe4, 0x4f, 0x26},
     {0x53, 0x02, 0x0d, 0x90, 0x8b, 0x02, 0x19, 0x32, 0x8b, 0x65, 0x8b,
      0x52, 0x5f, 0x26, 0x78, 0x0e, 0x3a, 0xe1, 0x2b, 0xcd, 0x95, 0x2b,
      0xb2, 0x5a, 0x93, 0xbc, 0x08, 0x95, 0xe1, 0x71, 0x42, 0x85},
     false,
     false},

    // Comment: edge case for shared secret
    // tcID: 3
    {3,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x58, 0xfd, 0x41, 0x68, 0xa8, 0x77, 0x95, 0x60, 0x3e,
      0x2b, 0x04, 0x39, 0x02, 0x85, 0xbd, 0xca, 0x6e, 0x57, 0xde, 0x60, 0x27,
      0xfe, 0x21, 0x1d, 0xd9, 0xd2, 0x5e, 0x22, 0x12, 0xd2, 0x9e, 0x62, 0x08,
      0x0d, 0x36, 0xbd, 0x22, 0x4d, 0x74, 0x05, 0x50, 0x92, 0x95, 0xee, 0xd0,
      0x2a, 0x17, 0x15, 0x0e, 0x03, 0xb3, 0x14, 0xf9, 0x6d, 0xa3, 0x74, 0x45,
      0xb0, 0xd1, 0xd2, 0x93, 0x77, 0xd1, 0x2c},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 4
    {4,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0f, 0x6d, 0x20, 0xc0, 0x42, 0x61, 0xec, 0xc3, 0xe9,
      0x28, 0x46, 0xac, 0xad, 0x48, 0xdc, 0x8e, 0xc5, 0xee, 0x35, 0xae, 0x08,
      0x83, 0xf0, 0xd2, 0xea, 0x71, 0x21, 0x69, 0x06, 0xee, 0x1c, 0x47, 0xc0,
      0x42, 0x68, 0x9a, 0x99, 0x6d, 0xd1, 0x28, 0x30, 0xae, 0x45, 0x93, 0x82,
      0xe9, 0x4a, 0xac, 0x56, 0xb7, 0x17, 0xaf, 0x2e, 0x20, 0x80, 0x21, 0x5f,
      0x9e, 0x41, 0x94, 0x9b, 0x1f, 0x52, 0xbe},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 5
    {5,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0xc7, 0xde, 0xfe, 0xb1, 0xa1, 0x62, 0x36, 0x73,
      0x8e, 0x9a, 0x11, 0x23, 0xba, 0x62, 0x1b, 0xc8, 0xe9, 0xa3, 0xf2, 0x48,
      0x5b, 0x3f, 0x8f, 0xfd, 0xe7, 0xf9, 0xce, 0x98, 0xf5, 0xa8, 0xa1, 0xcb,
      0x33, 0x8c, 0x39, 0x12, 0xb1, 0x79, 0x2f, 0x60, 0xc2, 0xb0, 0x6e, 0xc5,
      0x23, 0x1e, 0x2d, 0x84, 0xb0, 0xe5, 0x96, 0xe9, 0xb7, 0x6d, 0x41, 0x9c,
      0xe1, 0x05, 0xec, 0xe3, 0x79, 0x1d, 0xbc},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 6
    {6,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xe9, 0xb9, 0x8f, 0xb2, 0xc0, 0xac, 0x04, 0x5f, 0x8c,
      0x76, 0x12, 0x5f, 0xfd, 0x99, 0xeb, 0x8a, 0x51, 0x57, 0xbe, 0x1d, 0x7d,
      0xb3, 0xe8, 0x5d, 0x65, 0x5e, 0xc1, 0xd8, 0x21, 0x02, 0x88, 0xcf, 0x21,
      0x8d, 0xf2, 0x4f, 0xd2, 0xc2, 0x74, 0x6b, 0xe5, 0x9d, 0xf4, 0x12, 0x62,
      0xef, 0x3a, 0x97, 0xd9, 0x86, 0x74, 0x4b, 0x28, 0x36, 0x74, 0x8a, 0x74,
      0x86, 0x23, 0x0a, 0x31, 0x9f, 0xfe, 0xc0},
     {0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 7
    {7,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xe9, 0x48, 0x4e, 0x58, 0xf3, 0x33, 0x1b, 0x66, 0xff,
      0xed, 0x6d, 0x90, 0xcb, 0x1c, 0x78, 0x06, 0x5f, 0xa2, 0x8c, 0xfb, 0xa5,
      0xc7, 0xdd, 0x43, 0x52, 0x01, 0x3d, 0x32, 0x52, 0xee, 0x42, 0x77, 0xbd,
      0x75, 0x03, 0xb0, 0x45, 0xa3, 0x8b, 0x4b, 0x24, 0x7b, 0x32, 0xc5, 0x95,
      0x93, 0x58, 0x0f, 0x39, 0xe6, 0xab, 0xfa, 0x37, 0x6c, 0x3d, 0xca, 0x20,
      0xcf, 0x7f, 0x9c, 0xfb, 0x65, 0x9e, 0x13},
     {0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3f, 0xff,
      0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 8
    {8,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x76, 0x7d, 0x7f, 0xbb, 0x84, 0xaa, 0x6a, 0x4d, 0xb1,
      0x07, 0x93, 0x72, 0x64, 0x4e, 0x42, 0xec, 0xb2, 0xfe, 0xc2, 0x00, 0xc1,
      0x78, 0x82, 0x23, 0x92, 0xcb, 0x8b, 0x95, 0x0f, 0xfd, 0xd0, 0xc9, 0x1c,
      0x86, 0x85, 0x3c, 0xaf, 0xd0, 0x9b, 0x52, 0xba, 0x2f, 0x28, 0x7f, 0x0e,
      0xba, 0xa2, 0x64, 0x15, 0xa3, 0xcf, 0xab, 0xaf, 0x92, 0xc6, 0xa6, 0x17,
      0xa1, 0x99, 0x88, 0x56, 0x3d, 0x9d, 0xea},
     {0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff,
      0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
      0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x01, 0x00, 0x01},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 9
    {9,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xc7, 0x4d, 0x54, 0x6f, 0x2f, 0xcc, 0x6d, 0xd3, 0x92,
      0xf8, 0x5e, 0x5b, 0xe1, 0x67, 0xe3, 0x58, 0xde, 0x90, 0x87, 0x56, 0xb0,
      0xc0, 0xbb, 0x01, 0xcb, 0x69, 0xd8, 0x64, 0xca, 0x08, 0x3e, 0x1c, 0x93,
      0xf9, 0x59, 0xee, 0xce, 0x6e, 0x10, 0xee, 0x11, 0xbd, 0x39, 0x34, 0x20,
      0x7d, 0x65, 0xae, 0x28, 0xaf, 0x68, 0xb0, 0x92, 0x58, 0x5a, 0x15, 0x09,
      0x26, 0x0e, 0xce, 0xb3, 0x9b, 0x92, 0xef},
     {0x08, 0x5e, 0xc5, 0xa4, 0xaf, 0x40, 0x17, 0x6b, 0x63, 0x18, 0x90,
      0x69, 0xae, 0xff, 0xcb, 0x22, 0x9c, 0x96, 0xd3, 0xe0, 0x46, 0xe0,
      0x28, 0x3e, 0xd2, 0xf9, 0xda, 0xc2, 0x1b, 0x15, 0xad, 0x3c},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 10
    {10,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x34, 0xfc, 0x9f, 0x1e, 0x7a, 0x09, 0x4c, 0xd2, 0x95,
      0x98, 0xd1, 0x84, 0x1f, 0xa9, 0x61, 0x3d, 0xbe, 0x82, 0x31, 0x3d, 0x63,
      0x3a, 0x51, 0xd6, 0x3f, 0xb6, 0xef, 0xf0, 0x74, 0xcc, 0x9b, 0x9a, 0x4e,
      0xcf, 0xd9, 0xf2, 0x58, 0xc5, 0xc4, 0xd4, 0x21, 0x0b, 0x49, 0x75, 0x12,
      0x13, 0xa2, 0x4c, 0x59, 0x69, 0x82, 0xbd, 0x1d, 0x54, 0xe0, 0x44, 0x54,
      0x43, 0xf2, 0x1e, 0xf1, 0x54, 0x92, 0xa5},
     {0x19, 0x0c, 0x25, 0xf8, 0x8a, 0xd9, 0xae, 0x3a, 0x09, 0x8e, 0x6c,
      0xff, 0xe6, 0xfd, 0x0b, 0x1b, 0xea, 0x42, 0x11, 0x4e, 0xb0, 0xce,
      0xdd, 0x58, 0x68, 0xa4, 0x5c, 0x5f, 0xe2, 0x77, 0xdf, 0xf3},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 11
    {11,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd5, 0xc9, 0x6e, 0xfd, 0x19, 0x07, 0xfd, 0x48, 0xde,
      0x2a, 0xd7, 0x15, 0xac, 0xf8, 0x2e, 0xae, 0x5c, 0x66, 0x90, 0xfe, 0x3e,
      0xfe, 0x16, 0xa7, 0x8d, 0x61, 0xc6, 0x8d, 0x3b, 0xfd, 0x10, 0xdf, 0x03,
      0xea, 0xc8, 0x16, 0xb9, 0xe7, 0xb7, 0x76, 0x19, 0x2a, 0x3f, 0x50, 0x75,
      0x88, 0x7c, 0x0e, 0x22, 0x56, 0x17, 0x50, 0x58, 0x33, 0xca, 0x99, 0x7c,
      0xda, 0x32, 0xfd, 0x0f, 0x67, 0x3c, 0x5e},
     {0x50, 0x74, 0x42, 0x00, 0x73, 0x22, 0xaa, 0x89, 0x53, 0x40, 0xcb,
      0xa4, 0xab, 0xc2, 0xd7, 0x30, 0xbf, 0xd0, 0xb1, 0x6c, 0x2c, 0x79,
      0xa4, 0x68, 0x15, 0xf8, 0x78, 0x0d, 0x2c, 0x55, 0xa2, 0xdd},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 12
    {12,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf4, 0x75, 0xf5, 0x03, 0xa7, 0x70, 0xdf, 0x72, 0xc4,
      0x5a, 0xed, 0xfe, 0x42, 0xc0, 0x08, 0xf5, 0x9a, 0xa5, 0x7e, 0x72, 0xb2,
      0x32, 0xf2, 0x66, 0x00, 0xbd, 0xd0, 0x35, 0x39, 0x57, 0xcb, 0x20, 0xbd,
      0xb8, 0xf6, 0x40, 0x5b, 0x49, 0x18, 0x05, 0x0a, 0x35, 0x49, 0xf4, 0x4c,
      0x07, 0xa8, 0xeb, 0xa8, 0x20, 0xcd, 0xce, 0x4e, 0xce, 0x69, 0x98, 0x88,
      0xc6, 0x38, 0xdf, 0x66, 0xf5, 0x4f, 0x7c},
     {0x5f, 0x17, 0x7b, 0xfe, 0x19, 0xba, 0xaa, 0xee, 0x59, 0x7e, 0x68,
      0xb6, 0xa8, 0x7a, 0x51, 0x9e, 0x80, 0x5e, 0x9d, 0x28, 0xa7, 0x0c,
      0xb7, 0x2f, 0xd4, 0x0f, 0x0f, 0xe5, 0xa7, 0x54, 0xba, 0x45},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 13
    {13,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf3, 0xcb, 0x67, 0x54, 0xb7, 0xe2, 0xa8, 0x6d, 0x06,
      0x4d, 0xfb, 0x9f, 0x90, 0x31, 0x85, 0xaa, 0xa4, 0xc9, 0x2b, 0x48, 0x1c,
      0x2c, 0x1a, 0x1f, 0xf2, 0x76, 0x30, 0x3b, 0xbc, 0x41, 0x83, 0xe4, 0x9c,
      0x31, 0x85, 0x99, 0xb0, 0x98, 0x4c, 0x35, 0x63, 0xdf, 0x33, 0x93, 0x11,
      0xfe, 0x14, 0x3a, 0x7d, 0x92, 0x1e, 0xe7, 0x5b, 0x75, 0x5a, 0x52, 0xc6,
      0xf8, 0x04, 0xf8, 0x97, 0xb8, 0x09, 0xf7},
     {0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x07, 0xff, 0xf0, 0x00,
      0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00,
      0x07, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 14
    {14,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xcc, 0xe1, 0x3f, 0xbd, 0xc9, 0x6a, 0x94, 0x6d, 0xfb,
      0x8c, 0x6d, 0x9e, 0xd7, 0x62, 0xdb, 0xd1, 0x73, 0x16, 0x30, 0x45, 0x56,
      0x89, 0xf5, 0x7a, 0x43, 0x7f, 0xee, 0x12, 0x4d, 0xd5, 0x4c, 0xec, 0xae,
      0xf7, 0x80, 0x26, 0xc6, 0x53, 0x03, 0x0c, 0xf2, 0xf3, 0x14, 0xa6, 0x70,
      0x64, 0x23, 0x6b, 0x0a, 0x35, 0x4d, 0xef, 0xeb, 0xc5, 0xe9, 0x0c, 0x94,
      0x12, 0x4e, 0x9b, 0xf5, 0xc4, 0xfc, 0x24},
     {0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 15
    {15,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x76, 0x33, 0xdf, 0xd0, 0xad, 0x06, 0x76, 0x50, 0x97,
      0xbc, 0x11, 0xbd, 0x50, 0x22, 0xb2, 0x00, 0xdf, 0x31, 0xf2, 0x8c, 0x4f,
      0xf0, 0x62, 0x54, 0x21, 0x22, 0x1a, 0xc7, 0xee, 0xb6, 0xe6, 0xf4, 0xcb,
      0x9c, 0x67, 0x69, 0x36, 0x09, 0xdd, 0xd6, 0xf9, 0x23, 0x43, 0xa5, 0xa1,
      0xc6, 0x35, 0x40, 0x82, 0x40, 0xf4, 0xf8, 0xe2, 0x71, 0x20, 0xc1, 0x25,
      0x54, 0xc7, 0xff, 0x8c, 0x76, 0xe2, 0xfe},
     {0x80, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x07, 0xff,
      0xff, 0xfe, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00,
      0x1f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 16
    {16,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xa3, 0x86, 0xac, 0xe5, 0x73, 0xf8, 0x75, 0x58, 0xa6,
      0x8e, 0xad, 0x2a, 0x20, 0x08, 0x8e, 0x3f, 0xe9, 0x28, 0xbd, 0xae, 0x9e,
      0x10, 0x94, 0x46, 0xf9, 0x3a, 0x07, 0x8c, 0x15, 0x74, 0x1f, 0x04, 0x21,
      0x26, 0x1e, 0x6d, 0xb2, 0xbf, 0x12, 0x10, 0x6e, 0x4c, 0x6b, 0xf8, 0x5b,
      0x95, 0x81, 0xb4, 0xc0, 0x30, 0x2a, 0x52, 0x62, 0x22, 0xf9, 0x0a, 0xbc,
      0x5a, 0x54, 0x92, 0x06, 0xb1, 0x10, 0x11},
     {0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00,
      0x00, 0x07, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x1f, 0xff,
      0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 17
    {17,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8e, 0x7b, 0x50, 0xf7, 0xd8, 0xc4, 0x4d, 0x5d, 0x34,
      0x96, 0xc4, 0x31, 0x41, 0xa5, 0x02, 0xf4, 0xa4, 0x3f, 0x15, 0x3d, 0x03,
      0xad, 0x43, 0xed, 0xa8, 0xe3, 0x95, 0x97, 0xf1, 0xd4, 0x77, 0xb8, 0x64,
      0x7f, 0x3d, 0xa6, 0x79, 0x69, 0xb7, 0xf9, 0x89, 0xff, 0x4a, 0xdd, 0xc3,
      0x93, 0x51, 0x5a, 0xf4, 0x0c, 0x82, 0x08, 0x5c, 0xe1, 0xf2, 0xee, 0x19,
      0x54, 0x12, 0xc6, 0xf5, 0x83, 0x77, 0x4f},
     {0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00,
      0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff,
      0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: edge case for shared secret
    // tcID: 18
    {18,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xc8, 0x27, 0xfb, 0x93, 0x0f, 0xd5, 0x1d, 0x92, 0x60,
      0x86, 0x19, 0x1b, 0x50, 0x2a, 0xf8, 0x3a, 0xbb, 0x5f, 0x71, 0x7d, 0xeb,
      0xc8, 0xde, 0x29, 0x89, 0x7a, 0x39, 0x34, 0xb2, 0x57, 0x1c, 0xa0, 0x59,
      0x90, 0xc0, 0x59, 0x7b, 0x0b, 0x7a, 0x2e, 0x42, 0xfe, 0xbd, 0x56, 0xb1,
      0x32, 0x35, 0xd1, 0xd4, 0x08, 0xd7, 0x6e, 0xd2, 0xc9, 0x3b, 0x3f, 0xac,
      0xf5, 0x14, 0xd9, 0x02, 0xf6, 0x91, 0x0a},
     {0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 19
    {19,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3c, 0xbc, 0x1b, 0x31, 0xb4, 0x3f, 0x17, 0xdc, 0x20,
      0x0d, 0xd7, 0x0c, 0x29, 0x44, 0xc0, 0x4c, 0x6c, 0xb1, 0xb0, 0x82, 0x82,
      0x0c, 0x23, 0x4a, 0x30, 0x0b, 0x05, 0xb7, 0x76, 0x38, 0x44, 0xc7, 0x4f,
      0xde, 0x0a, 0x4e, 0xf9, 0x38, 0x87, 0x46, 0x97, 0x93, 0x27, 0x0e, 0xb2,
      0xff, 0x14, 0x82, 0x87, 0xda, 0x92, 0x65, 0xb0, 0x33, 0x4f, 0x9e, 0x26,
      0x09, 0xaa, 0xc1, 0x6e, 0x8a, 0xd5, 0x03},
     {0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xee, 0xcf, 0x22, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 20
    {20,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x28, 0x30, 0xd9, 0x64, 0x89, 0xae, 0x24, 0xb7, 0x9c,
      0xad, 0x42, 0x50, 0x56, 0xe8, 0x27, 0x46, 0xf9, 0xe3, 0xf4, 0x19, 0xab,
      0x9a, 0xa2, 0x1c, 0xa1, 0xfb, 0xb1, 0x1c, 0x73, 0x25, 0xe7, 0xd3, 0x18,
      0xab, 0xe6, 0x6f, 0x57, 0x5e, 0xe8, 0xa2, 0xf1, 0xc4, 0xa8, 0x0e, 0x35,
      0x26, 0x0a, 0xe8, 0x2a, 0xd7, 0xd6, 0xf6, 0x61, 0xd1, 0x5f, 0x06, 0x96,
      0x79, 0x30, 0xa5, 0x85, 0x09, 0x7e, 0xf7},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x11, 0x11, 0x24, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 21
    {21,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x45, 0x0b, 0x6b, 0x6e, 0x20, 0x97, 0x17, 0x8e, 0x9d,
      0x28, 0x50, 0x10, 0x95, 0x18, 0xd2, 0x8e, 0xb3, 0xb6, 0xde, 0xd2, 0x92,
      0x2a, 0x54, 0x52, 0x00, 0x3b, 0xc2, 0xe4, 0xa4, 0xec, 0x77, 0x5c, 0x89,
      0x4e, 0x90, 0xf0, 0xdf, 0x1b, 0x0e, 0x6c, 0xad, 0xb0, 0x3b, 0x9d, 0xe2,
      0x4f, 0x6a, 0x22, 0xd1, 0xbd, 0x0a, 0x4a, 0x58, 0xcd, 0x64, 0x5c, 0x27,
      0x3c, 0xae, 0x1c, 0x61, 0x9b, 0xfd, 0x61},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0xea, 0x77, 0xd4, 0x49, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 22
    {22,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3c, 0xbc, 0x1b, 0x31, 0xb4, 0x3f, 0x17, 0xdc, 0x20,
      0x0d, 0xd7, 0x0c, 0x29, 0x44, 0xc0, 0x4c, 0x6c, 0xb1, 0xb0, 0x82, 0x82,
      0x0c, 0x23, 0x4a, 0x30, 0x0b, 0x05, 0xb7, 0x76, 0x38, 0x44, 0xc7, 0xb0,
      0x21, 0xf5, 0xb0, 0x06, 0xc7, 0x78, 0xba, 0x68, 0x6c, 0xd8, 0xf1, 0x4d,
      0x00, 0xeb, 0x7d, 0x78, 0x25, 0x6d, 0x9b, 0x4f, 0xcc, 0xb0, 0x61, 0xd9,
      0xf6, 0x55, 0x3e, 0x91, 0x75, 0x2a, 0xfc},
     {0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xee, 0xcf, 0x22, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 23
    {23,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x28, 0x30, 0xd9, 0x64, 0x89, 0xae, 0x24, 0xb7, 0x9c,
      0xad, 0x42, 0x50, 0x56, 0xe8, 0x27, 0x46, 0xf9, 0xe3, 0xf4, 0x19, 0xab,
      0x9a, 0xa2, 0x1c, 0xa1, 0xfb, 0xb1, 0x1c, 0x73, 0x25, 0xe7, 0xd3, 0xe7,
      0x54, 0x19, 0x8f, 0xa8, 0xa1, 0x17, 0x5e, 0x0e, 0x3b, 0x57, 0xf1, 0xca,
      0xd9, 0xf5, 0x17, 0xd5, 0x28, 0x29, 0x0a, 0x9e, 0x2e, 0xa0, 0xf9, 0x69,
      0x86, 0xcf, 0x5a, 0x7a, 0xf6, 0x81, 0x08},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x11, 0x11, 0x24, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 24
    {24,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x45, 0x0b, 0x6b, 0x6e, 0x20, 0x97, 0x17, 0x8e, 0x9d,
      0x28, 0x50, 0x10, 0x95, 0x18, 0xd2, 0x8e, 0xb3, 0xb6, 0xde, 0xd2, 0x92,
      0x2a, 0x54, 0x52, 0x00, 0x3b, 0xc2, 0xe4, 0xa4, 0xec, 0x77, 0x5c, 0x76,
      0xb1, 0x6f, 0x0e, 0x20, 0xe4, 0xf1, 0x94, 0x52, 0x4f, 0xc4, 0x62, 0x1d,
      0xb0, 0x95, 0xdd, 0x2e, 0x42, 0xf5, 0xb6, 0xa7, 0x32, 0x9b, 0xa3, 0xd8,
      0xc3, 0x51, 0xe3, 0x9e, 0x64, 0x02, 0x9e},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0xea, 0x77, 0xd4, 0x49, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: y-coordinate of the public key has many trailing 1's
    // tcID: 25
    {25,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x9a, 0x0f, 0x0e, 0x3d, 0xd3, 0x14, 0x17, 0xbb, 0xd9,
      0xe2, 0x98, 0xbc, 0x06, 0x8a, 0xb6, 0xd5, 0xc3, 0x67, 0x33, 0xaf, 0x26,
      0xed, 0x67, 0x67, 0x6f, 0x41, 0x0c, 0x80, 0x4b, 0x8b, 0x2c, 0xa1, 0xb0,
      0x2c, 0x82, 0xf3, 0xa6, 0x1a, 0x37, 0x6d, 0xb7, 0x95, 0x62, 0x6e, 0x94,
      0x00, 0x55, 0x71, 0x12, 0x27, 0x3a, 0x36, 0xcd, 0xdb, 0x08, 0xca, 0xaa,
      0x43, 0x95, 0x39, 0x65, 0x45, 0x47, 0x30},
     {0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xca, 0x08, 0x90, 0x11, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: y-coordinate of the public key has many trailing 1's
    // tcID: 26
    {26,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8e, 0x5d, 0x22, 0xd5, 0xe5, 0x3e, 0xc7, 0x97, 0xc5,
      0x5e, 0xcd, 0x68, 0xa0, 0x8a, 0x7c, 0x33, 0x61, 0xcd, 0x99, 0xca, 0x7f,
      0xad, 0x1a, 0x68, 0xea, 0x80, 0x2a, 0x6a, 0x4c, 0xb5, 0x8a, 0x91, 0x8e,
      0xa7, 0xa0, 0x70, 0x23, 0xef, 0x67, 0x67, 0x70, 0x24, 0xbd, 0x38, 0x41,
      0xe1, 0x87, 0xc6, 0x4b, 0x30, 0xa3, 0x0a, 0x37, 0x50, 0xeb, 0x2e, 0xe8,
      0x73, 0xfb, 0xe5, 0x8f, 0xa1, 0x35, 0x7b},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x1f, 0x6b, 0xd1, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: y-coordinate of the public key has many trailing 1's
    // tcID: 27
    {27,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x3a, 0xa3, 0x49, 0xb9, 0x34, 0xab, 0x2c, 0x83,
      0x9c, 0xf5, 0x4b, 0x8a, 0x73, 0x7d, 0xf2, 0x30, 0x4e, 0xf9, 0xb2, 0x0f,
      0xa4, 0x94, 0xe3, 0x1a, 0xd6, 0x2b, 0x31, 0x5d, 0xd6, 0xa5, 0x3c, 0x11,
      0x81, 0x82, 0xb8, 0x5e, 0xf4, 0x66, 0xeb, 0x9a, 0x8e, 0x87, 0xf9, 0x66,
      0x1f, 0x7d, 0x01, 0x79, 0x84, 0xc1, 0x5e, 0xa8, 0x20, 0x43, 0xf5, 0x36,
      0xd1, 0xee, 0x6a, 0x6d, 0x95, 0xb5, 0x09},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x09, 0x9f, 0x55, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: y-coordinate of the public key has many trailing 0's
    // tcID: 28
    {28,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x9a, 0x0f, 0x0e, 0x3d, 0xd3, 0x14, 0x17, 0xbb, 0xd9,
      0xe2, 0x98, 0xbc, 0x06, 0x8a, 0xb6, 0xd5, 0xc3, 0x67, 0x33, 0xaf, 0x26,
      0xed, 0x67, 0x67, 0x6f, 0x41, 0x0c, 0x80, 0x4b, 0x8b, 0x2c, 0xa1, 0x4f,
      0xd3, 0x7d, 0x0b, 0x59, 0xe5, 0xc8, 0x93, 0x48, 0x6a, 0x9d, 0x91, 0x6b,
      0xff, 0xaa, 0x8e, 0xed, 0xd8, 0xc5, 0xca, 0x32, 0x24, 0xf7, 0x35, 0x55,
      0xbc, 0x6a, 0xc6, 0x9a, 0xba, 0xb8, 0xcf},
     {0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xca, 0x08, 0x90, 0x11, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: y-coordinate of the public key has many trailing 0's
    // tcID: 29
    {29,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8e, 0x5d, 0x22, 0xd5, 0xe5, 0x3e, 0xc7, 0x97, 0xc5,
      0x5e, 0xcd, 0x68, 0xa0, 0x8a, 0x7c, 0x33, 0x61, 0xcd, 0x99, 0xca, 0x7f,
      0xad, 0x1a, 0x68, 0xea, 0x80, 0x2a, 0x6a, 0x4c, 0xb5, 0x8a, 0x91, 0x71,
      0x58, 0x5f, 0x8e, 0xdc, 0x10, 0x98, 0x99, 0x8f, 0xdb, 0x42, 0xc7, 0xbe,
      0x1e, 0x78, 0x39, 0xb4, 0xcf, 0x5c, 0xf6, 0xc8, 0xaf, 0x14, 0xd1, 0x17,
      0x8c, 0x04, 0x1a, 0x70, 0x5e, 0xca, 0x84},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x1f, 0x6b, 0xd1, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     false,
     true},

    // Comment: y-coordinate of the public key has many trailing 0's
    // tcID: 30
    {30,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x0a, 0x0d, 0x62, 0x2a, 0x47, 0xe4, 0x8f, 0x6b, 0xc1, 0x03, 0x8a, 0xce,
      0x43, 0x8c, 0x6f, 0x52, 0x8a, 0xa0, 0x0a, 0xd2, 0xbd, 0x1d, 0xa5, 0xf1,
      0x3e, 0xe4, 0x6b, 0xf5, 0xf6, 0x33, 0xd7, 0x1a, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x74, 0x61, 0x8c, 0xba, 0xaf, 0x69, 0xff, 0x59, 0x0f, 0x5f,
      0xb5, 0x85, 0x51, 0xce, 0x4a, 0x94, 0x8b, 0x5c, 0x72, 0x51, 0xd4, 0x0e,
      0x59, 0x5a, 0x18, 0xb1, 0xba, 0x6b, 0xbe, 0xe6, 0xad, 0xa5, 0xbf, 0xf4,
      0x03, 0xa8, 0xe9, 0x9d, 0x53, 0xa7, 0x0d, 0x3c, 0xe4, 0x61, 0x0b, 0xfd,
      0x05, 0xd4, 0xba, 0x3a, 0x88, 0x55, 0xb6, 0xa0, 0xd3, 0x63, 0xc8, 0x1f,
      0x7d, 0x07, 0x8c, 0xde, 0xcd, 0x92},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x3a, 0xa3, 0x49, 0xb9, 0x34, 0xab, 0x2c, 0x83,
      0x9c, 0xf5, 0x4b, 0x8a, 0x73, 0x7d, 0xf2, 0x30, 0x4e, 0xf9, 0xb2, 0x0f,
      0xa4, 0x94, 0xe3, 0x1a, 0xd6, 0x2b, 0x31, 0x5d, 0xd6, 0xa5, 0x3c, 0xee,
      0x7e, 0x7d, 0x46, 0xa1, 0x0b, 0x99, 0x15, 0x65, 0x71, 0x78, 0x06, 0x99,
      0xe0, 0x82, 0xfe, 0x86, 0x7b, 0x3e, 0xa2, 0x57, 0xdf, 0xbc, 0x0a, 0xc9,
      0x2e, 0x11, 0x95, 0x92, 0x6a, 0x4a, 0xf6},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x09, 0x9f, 0x55, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 31
    {31,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66,
      0x48, 0x5c, 0x78, 0x0e, 0x2f, 0x83, 0xd7, 0x24, 0x33, 0xbd, 0x5d, 0x84,
      0xa0, 0x6b, 0xb6, 0x54, 0x1c, 0x2a, 0xf3, 0x1d, 0xae, 0x87, 0x17, 0x28,
      0xbf, 0x85, 0x6a, 0x17, 0x4f, 0x93, 0xf4},
     {0xcf, 0xe4, 0x07, 0x7c, 0x87, 0x30, 0xb1, 0xc9, 0x38, 0x45, 0x81,
      0xd3, 0x6b, 0xff, 0x55, 0x42, 0xbc, 0x41, 0x7c, 0x9e, 0xff, 0x5c,
      0x2a, 0xfc, 0xb9, 0x8c, 0xc8, 0x82, 0x9b, 0x2c, 0xe8, 0x48},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 32
    {32,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4f,
      0x2b, 0x92, 0xb4, 0xc5, 0x96, 0xa5, 0xa4, 0x7f, 0x8b, 0x04, 0x1d, 0x2d,
      0xea, 0x60, 0x43, 0x02, 0x1a, 0xc7, 0x7b, 0x9a, 0x80, 0xb1, 0x34, 0x3a,
      0xc9, 0xd7, 0x78, 0xf4, 0xf8, 0xf7, 0x33},
     {0x49, 0xae, 0x50, 0xfe, 0x09, 0x6a, 0x6c, 0xd2, 0x66, 0x98, 0xb7,
      0x83, 0x56, 0xb2, 0xc8, 0xad, 0xf1, 0xf6, 0xa3, 0x49, 0x0f, 0x14,
      0xe3, 0x64, 0x62, 0x9f, 0x7a, 0x06, 0x39, 0x44, 0x25, 0x09},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 33
    {33,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x38,
      0x12, 0x0b, 0xe6, 0xab, 0x31, 0xed, 0xfa, 0x34, 0x76, 0x8c, 0x43, 0x87,
      0xd2, 0xf8, 0x4f, 0xb4, 0xb0, 0xbe, 0x8a, 0x9a, 0x98, 0x58, 0x64, 0xa1,
      0x57, 0x5f, 0x44, 0x36, 0xbb, 0x37, 0xb0},
     {0x5a, 0x13, 0x34, 0x57, 0x2b, 0x2a, 0x71, 0x1e, 0xad, 0x8b, 0x46,
      0x53, 0xeb, 0x31, 0x0c, 0xd8, 0xd9, 0xfd, 0x11, 0x43, 0x99, 0x37,
      0x9a, 0x8f, 0x6b, 0x87, 0x2e, 0x3b, 0x8f, 0xdd, 0xa2, 0xd9},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 34
    {34,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x46,
      0x2c, 0x04, 0x66, 0xe4, 0x18, 0x02, 0x23, 0x8d, 0x6c, 0x92, 0x5e, 0xcb,
      0xef, 0xc7, 0x47, 0xcf, 0xe5, 0x05, 0xea, 0x19, 0x6a, 0xf9, 0xa2, 0xd1,
      0x1b, 0x62, 0x85, 0x0f, 0xce, 0x94, 0x6e},
     {0xc7, 0x37, 0x55, 0x13, 0x3b, 0x6b, 0x9b, 0x4b, 0x2a, 0x00, 0x63,
      0x1c, 0xbc, 0x79, 0x40, 0xec, 0xbe, 0x6e, 0xc0, 0x8f, 0x20, 0x44,
      0x80, 0x71, 0x42, 0x2e, 0x33, 0x62, 0xf2, 0x55, 0x68, 0x88},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 35
    {35,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0x15,
      0x82, 0xfa, 0x32, 0xe2, 0xd4, 0xa8, 0x9d, 0xfc, 0xfb, 0x3d, 0x0b, 0x14,
      0x9f, 0x66, 0x7d, 0xba, 0x33, 0x29, 0x49, 0x0f, 0x4d, 0x64, 0xee, 0x2a,
      0xd5, 0x86, 0xc0, 0xc9, 0xe8, 0xc5, 0x08},
     {0x06, 0xfa, 0x10, 0x59, 0x93, 0x5e, 0x47, 0xa9, 0xfd, 0x66, 0x7e,
      0x13, 0xf4, 0x69, 0x61, 0x4e, 0xb2, 0x57, 0xcc, 0x9a, 0x7e, 0x3f,
      0xc5, 0x99, 0xbf, 0xb9, 0x27, 0x80, 0xd5, 0x9b, 0x14, 0x6d},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 36
    {36,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
      0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
      0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x01, 0x00, 0x01, 0x68,
      0x4c, 0x8a, 0x95, 0x86, 0xed, 0x6f, 0x9c, 0xbe, 0x44, 0x70, 0x58, 0xa7,
      0xda, 0x21, 0x08, 0xba, 0xb1, 0xe5, 0xe0, 0xa6, 0x0d, 0x1f, 0x73, 0xe4,
      0xe2, 0xe7, 0x13, 0xf0, 0xa3, 0xdf, 0xe0},
     {0xf2, 0x37, 0xdf, 0x4c, 0x10, 0xbd, 0x3e, 0x35, 0x79, 0x71, 0xbb,
      0x2b, 0x16, 0xb2, 0x93, 0x56, 0x6b, 0x7e, 0x35, 0x5b, 0xdc, 0x81,
      0x41, 0xd6, 0xc9, 0x2c, 0xab, 0xc6, 0x82, 0x98, 0x3c, 0x45},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 37
    {37,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x08, 0x5e, 0xc5, 0xa4, 0xaf, 0x40, 0x17, 0x6b, 0x63,
      0x18, 0x90, 0x69, 0xae, 0xff, 0xcb, 0x22, 0x9c, 0x96, 0xd3, 0xe0, 0x46,
      0xe0, 0x28, 0x3e, 0xd2, 0xf9, 0xda, 0xc2, 0x1b, 0x15, 0xad, 0x3c, 0x78,
      0x59, 0xf9, 0x7c, 0xb6, 0xe2, 0x03, 0xf4, 0x6b, 0xf3, 0x43, 0x8f, 0x61,
      0x28, 0x23, 0x25, 0xe9, 0x4e, 0x68, 0x1b, 0x60, 0xb5, 0x66, 0x97, 0x88,
      0xae, 0xb0, 0x65, 0x5b, 0xf1, 0x9d, 0x38},
     {0xd8, 0x74, 0xb5, 0x56, 0x78, 0xd0, 0xa0, 0x4d, 0x21, 0x6c, 0x31,
      0xb0, 0x2f, 0x3a, 0xd1, 0xf3, 0x0c, 0x92, 0xca, 0xaf, 0x16, 0x8f,
      0x34, 0xe3, 0xa7, 0x43, 0x35, 0x6d, 0x92, 0x76, 0xe9, 0x93},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 38
    {38,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x19, 0x0c, 0x25, 0xf8, 0x8a, 0xd9, 0xae, 0x3a, 0x09,
      0x8e, 0x6c, 0xff, 0xe6, 0xfd, 0x0b, 0x1b, 0xea, 0x42, 0x11, 0x4e, 0xb0,
      0xce, 0xdd, 0x58, 0x68, 0xa4, 0x5c, 0x5f, 0xe2, 0x77, 0xdf, 0xf3, 0x21,
      0xb8, 0x34, 0x2e, 0xf0, 0x77, 0xbc, 0x67, 0x24, 0x11, 0x24, 0x03, 0xea,
      0xee, 0x5a, 0x15, 0xb4, 0xc3, 0x1a, 0x71, 0x58, 0x9f, 0x02, 0xde, 0xd0,
      0x9c, 0xd9, 0x9c, 0xc5, 0xdb, 0x9c, 0x83},
     {0x11, 0xa8, 0x58, 0x20, 0x57, 0x46, 0x3f, 0xc7, 0x6f, 0xda, 0x3a,
      0xb8, 0x08, 0x7e, 0xb0, 0xa4, 0x20, 0xb0, 0xd6, 0x01, 0xbb, 0x31,
      0x34, 0x16, 0x5a, 0x36, 0x96, 0x46, 0x93, 0x1e, 0x52, 0xa6},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 39
    {39,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x50, 0x74, 0x42, 0x00, 0x73, 0x22, 0xaa, 0x89, 0x53,
      0x40, 0xcb, 0xa4, 0xab, 0xc2, 0xd7, 0x30, 0xbf, 0xd0, 0xb1, 0x6c, 0x2c,
      0x79, 0xa4, 0x68, 0x15, 0xf8, 0x78, 0x0d, 0x2c, 0x55, 0xa2, 0xdd, 0x46,
      0x19, 0xd6, 0x9f, 0x99, 0x40, 0xf5, 0x16, 0x63, 0xaa, 0x12, 0x38, 0x1b,
      0xc7, 0xcf, 0x67, 0x8b, 0xd1, 0xa7, 0x2a, 0x49, 0xfb, 0xc1, 0x1b, 0x0b,
      0x69, 0xcb, 0x22, 0xd1, 0xaf, 0x9f, 0x2d},
     {0x4e, 0x17, 0x3a, 0x80, 0x90, 0x7f, 0x36, 0x1f, 0xe5, 0xa5, 0xd3,
      0x35, 0xba, 0x76, 0x85, 0xd5, 0xeb, 0xa9, 0x3e, 0x9d, 0xfc, 0x8d,
      0x8f, 0xcd, 0xb1, 0xdc, 0xd2, 0xd2, 0xbd, 0xe2, 0x75, 0x07},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 40
    {40,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5f, 0x17, 0x7b, 0xfe, 0x19, 0xba, 0xaa, 0xee, 0x59,
      0x7e, 0x68, 0xb6, 0xa8, 0x7a, 0x51, 0x9e, 0x80, 0x5e, 0x9d, 0x28, 0xa7,
      0x0c, 0xb7, 0x2f, 0xd4, 0x0f, 0x0f, 0xe5, 0xa7, 0x54, 0xba, 0x45, 0x62,
      0xca, 0x11, 0x03, 0xf7, 0x0a, 0x20, 0x06, 0xcd, 0x1f, 0x67, 0xf5, 0xf6,
      0xa3, 0x58, 0x0b, 0x29, 0xdc, 0x44, 0x6a, 0xbc, 0x90, 0xe0, 0xe9, 0x10,
      0xc1, 0xe0, 0x5a, 0x9a, 0xa7, 0x88, 0xcd},
     {0x73, 0x22, 0x04, 0x71, 0xec, 0x8b, 0xad, 0x99, 0xa2, 0x97, 0xdb,
      0x48, 0x8a, 0x34, 0xa2, 0x59, 0xf9, 0xbc, 0x89, 0x1f, 0xfa, 0xf0,
      0x99, 0x22, 0xe6, 0xb5, 0x00, 0x1f, 0x5d, 0xf6, 0x70, 0x18},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 41
    {41,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x07, 0xff,
      0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x00, 0x01, 0xff, 0xfc,
      0x00, 0x07, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x2e,
      0x22, 0x13, 0xca, 0xf0, 0x30, 0x33, 0xe0, 0xfd, 0x0f, 0x79, 0x51, 0x15,
      0x4f, 0x6e, 0x6c, 0x3a, 0x92, 0x44, 0xa7, 0x2f, 0xac, 0xa6, 0x5e, 0x9c,
      0xe9, 0xee, 0xb5, 0xc8, 0xe1, 0xce, 0xa9},
     {0x55, 0xd0, 0xa2, 0x03, 0xe2, 0x2f, 0xfb, 0x52, 0x3c, 0x8d, 0x27,
      0x05, 0x06, 0x0c, 0xee, 0x9d, 0x28, 0x30, 0x8b, 0x51, 0xf1, 0x84,
      0xbe, 0xef, 0xc5, 0x18, 0xcf, 0xf6, 0x90, 0xba, 0xd3, 0x46},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 42
    {42,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x2b,
      0xe8, 0x78, 0x9d, 0xb8, 0x1b, 0xb4, 0x87, 0x0a, 0x9e, 0x60, 0xc5, 0xc1,
      0x8c, 0x80, 0xc8, 0x3d, 0xe4, 0x64, 0x27, 0x72, 0x81, 0xf1, 0xaf, 0x1e,
      0x64, 0x08, 0x43, 0xa1, 0xa3, 0x14, 0x8e},
     {0x25, 0x18, 0xd8, 0x46, 0xe5, 0x77, 0xd9, 0x5e, 0x9e, 0x7b, 0xc7,
      0x66, 0xcd, 0xe7, 0x99, 0x7c, 0xb8, 0x87, 0xfb, 0x26, 0x6d, 0x3a,
      0x6c, 0xb5, 0x98, 0xa8, 0x39, 0xfd, 0x54, 0xaa, 0x2f, 0x4f},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 43
    {43,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x80, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00,
      0x07, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xc0, 0x00,
      0x00, 0x1f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x72,
      0x25, 0x40, 0xf8, 0xa4, 0x71, 0xc3, 0x79, 0x08, 0x3c, 0x60, 0x0b, 0x58,
      0xfd, 0xe4, 0xd9, 0x5c, 0x7d, 0xca, 0xd5, 0x09, 0x5f, 0x42, 0x19, 0xfc,
      0x5e, 0x9b, 0xdd, 0xe3, 0xc5, 0xcd, 0x39},
     {0xbd, 0xb4, 0x9f, 0x4b, 0xdf, 0x42, 0xac, 0x64, 0x50, 0x4e, 0x9c,
      0xe6, 0x77, 0xb3, 0xec, 0x5c, 0x0a, 0x03, 0x82, 0x8c, 0x5b, 0x3e,
      0xfa, 0xd7, 0x26, 0x00, 0x56, 0x92, 0xd3, 0x5c, 0x0f, 0x26},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 44
    {44,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xfc,
      0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x1f,
      0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0x5d,
      0xf8, 0x0f, 0xc6, 0xca, 0xe2, 0x6b, 0x6c, 0x19, 0x52, 0xfb, 0xd0, 0x0e,
      0xd1, 0x74, 0xee, 0x12, 0x09, 0xd0, 0x69, 0x33, 0x5f, 0x5b, 0x48, 0x58,
      0x8e, 0x29, 0xe8, 0x0b, 0x91, 0x91, 0xad},
     {0xf5, 0x03, 0xac, 0x65, 0x63, 0x7e, 0x0f, 0x17, 0xcb, 0x44, 0x08,
      0x96, 0x1c, 0xb8, 0x82, 0xc8, 0x75, 0xe4, 0xc6, 0xef, 0x7a, 0x54,
      0x8d, 0x2d, 0x52, 0xd8, 0xc2, 0xf6, 0x81, 0x83, 0x8c, 0x55},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 45
    {45,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff,
      0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x03,
      0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0x2c,
      0x63, 0x65, 0x0e, 0x6a, 0x5d, 0x33, 0x2e, 0x29, 0x87, 0xdd, 0x09, 0xa7,
      0x90, 0x08, 0xe8, 0xfa, 0xab, 0xbd, 0x37, 0xe4, 0x9c, 0xb0, 0x16, 0xbf,
      0xb9, 0x2c, 0x8c, 0xd0, 0xf5, 0xda, 0x77},
     {0xe3, 0xc1, 0x8e, 0x7d, 0x73, 0x77, 0xdc, 0x54, 0x0b, 0xc4, 0x5c,
      0x08, 0xd3, 0x89, 0xbd, 0xbe, 0x25, 0x5f, 0xa8, 0x0c, 0xa8, 0xfa,
      0xf1, 0xef, 0x6b, 0x94, 0xd5, 0x20, 0x49, 0x98, 0x7d, 0x21},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 46
    {46,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7a,
      0x11, 0x6c, 0x96, 0x4a, 0x4c, 0xd6, 0x06, 0x68, 0xbf, 0x89, 0xcf, 0xfe,
      0x15, 0x77, 0x14, 0xa3, 0xce, 0x21, 0xb9, 0x3b, 0x3c, 0xa6, 0x07, 0xc8,
      0xa5, 0xb9, 0x3a, 0xc5, 0x4f, 0xfc, 0x0a},
     {0x51, 0x6d, 0x6d, 0x32, 0x9b, 0x09, 0x5a, 0x7c, 0x7e, 0x93, 0xb4,
      0x02, 0x3d, 0x4d, 0x05, 0x02, 0x0c, 0x14, 0x45, 0xef, 0x1d, 0xdc,
      0xb3, 0x34, 0x7b, 0x3a, 0x27, 0xd7, 0xd7, 0xf5, 0x72, 0x65},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 47
    {47,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xee, 0xcf, 0x22, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x01, 0xc7, 0xc3, 0x06, 0x43, 0xab, 0xed, 0x0a, 0xf0, 0xa4,
      0x9f, 0xe3, 0x52, 0xcb, 0x48, 0x3f, 0xf9, 0xb9, 0x7d, 0xcc, 0xdf, 0x42,
      0x7c, 0x65, 0x8e, 0x87, 0x93, 0x24, 0x0d},
     {0x6f, 0xd2, 0x66, 0x61, 0x85, 0x1a, 0x8d, 0xe3, 0xc6, 0xd0, 0x6f,
      0x83, 0x4e, 0xf3, 0xac, 0xb8, 0xf2, 0xa5, 0xf9, 0xc1, 0x36, 0xa9,
      0x85, 0xff, 0xe1, 0x0d, 0x5e, 0xeb, 0x51, 0xed, 0xcf, 0xa3},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 48
    {48,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xee, 0xcf, 0x22, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfd, 0x38, 0x3c, 0xf9, 0xbd, 0x54, 0x12, 0xf5, 0x0f, 0x5b,
      0x60, 0x1c, 0xad, 0x34, 0xb7, 0xc0, 0x07, 0x46, 0x82, 0x33, 0x20, 0xbd,
      0x83, 0x9a, 0x71, 0x78, 0x6c, 0xdb, 0xf2},
     {0x6f, 0xd2, 0x66, 0x61, 0x85, 0x1a, 0x8d, 0xe3, 0xc6, 0xd0, 0x6f,
      0x83, 0x4e, 0xf3, 0xac, 0xb8, 0xf2, 0xa5, 0xf9, 0xc1, 0x36, 0xa9,
      0x85, 0xff, 0xe1, 0x0d, 0x5e, 0xeb, 0x51, 0xed, 0xcf, 0xa3},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 49
    {49,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xca, 0x08, 0x90, 0x11, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x26,
      0x7b, 0xfd, 0xf8, 0xa6, 0x11, 0x48, 0xde, 0xcd, 0x80, 0x28, 0x37, 0x32,
      0xdd, 0x4c, 0x10, 0x95, 0xe4, 0xbb, 0x40, 0xb9, 0x65, 0x84, 0x08, 0x20,
      0x8d, 0xc1, 0x14, 0x7f, 0xff, 0xff, 0xff},
     {0x44, 0x23, 0x6c, 0x8b, 0x95, 0x05, 0xa1, 0x9d, 0x48, 0x77, 0x4a,
      0x39, 0x03, 0xc0, 0x29, 0x27, 0x59, 0xb0, 0xf8, 0x26, 0xe6, 0xac,
      0x09, 0x2f, 0xf8, 0x98, 0xd8, 0x7e, 0x53, 0xd3, 0x53, 0xfc},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 50
    {50,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xca, 0x08, 0x90, 0x11, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd9,
      0x84, 0x02, 0x06, 0x59, 0xee, 0xb7, 0x22, 0x32, 0x7f, 0xd7, 0xc8, 0xcd,
      0x22, 0xb3, 0xef, 0x6a, 0x1b, 0x44, 0xc0, 0x46, 0x9a, 0x7b, 0xf7, 0xdf,
      0x72, 0x3e, 0xeb, 0x80, 0x00, 0x00, 0x00},
     {0x44, 0x23, 0x6c, 0x8b, 0x95, 0x05, 0xa1, 0x9d, 0x48, 0x77, 0x4a,
      0x39, 0x03, 0xc0, 0x29, 0x27, 0x59, 0xb0, 0xf8, 0x26, 0xe6, 0xac,
      0x09, 0x2f, 0xf8, 0x98, 0xd8, 0x7e, 0x53, 0xd3, 0x53, 0xfc},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 51
    {51,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x11, 0x11, 0x24, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x0d, 0x12, 0xd3, 0x81, 0xb0, 0x76, 0x0b, 0x1c, 0x50, 0xbe,
      0x8a, 0xcf, 0x85, 0x93, 0x85, 0x05, 0x2c, 0x7f, 0x53, 0xcd, 0xe6, 0x7c,
      0xe1, 0x37, 0x59, 0xde, 0x31, 0x23, 0xa0},
     {0xf1, 0xf0, 0xe4, 0x3b, 0x37, 0x4f, 0xeb, 0x7e, 0x7f, 0x96, 0xd4,
      0xff, 0xe7, 0x51, 0x9f, 0xa8, 0xbb, 0x6c, 0x3c, 0xfd, 0x25, 0xf6,
      0xf8, 0x7d, 0xab, 0x26, 0x23, 0xd2, 0xa2, 0xd3, 0x38, 0x51},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 52
    {52,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x11, 0x11, 0x24, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xf1, 0xed, 0x2c, 0x7e, 0x50, 0x89, 0xf4, 0xe3, 0xaf, 0x41,
      0x75, 0x30, 0x7a, 0x6c, 0x7a, 0xfa, 0xd4, 0x80, 0xac, 0x32, 0x19, 0x83,
      0x1e, 0xc8, 0xa6, 0x21, 0xce, 0xdc, 0x5f},
     {0xf1, 0xf0, 0xe4, 0x3b, 0x37, 0x4f, 0xeb, 0x7e, 0x7f, 0x96, 0xd4,
      0xff, 0xe7, 0x51, 0x9f, 0xa8, 0xbb, 0x6c, 0x3c, 0xfd, 0x25, 0xf6,
      0xf8, 0x7d, 0xab, 0x26, 0x23, 0xd2, 0xa2, 0xd3, 0x38, 0x51},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 53
    {53,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x1f, 0x6b, 0xd1, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
      0x96, 0xed, 0xd6, 0x87, 0x1c, 0x32, 0x0c, 0xb8, 0xa9, 0xf4, 0x53, 0x17,
      0x51, 0x10, 0x5c, 0x97, 0xb4, 0xc2, 0x57, 0x81, 0x1b, 0xbc, 0x32, 0x96,
      0x3e, 0xaf, 0x39, 0xff, 0xff, 0xff, 0xff},
     {0x3e, 0xbb, 0xac, 0xe1, 0x09, 0x8a, 0x81, 0x94, 0x9d, 0x56, 0x05,
      0xdd, 0x94, 0xa7, 0xaa, 0x88, 0xdc, 0x39, 0x6c, 0x2c, 0x23, 0xe0,
      0x1a, 0x9c, 0x8c, 0xca, 0x5b, 0xb0, 0x7b, 0xfb, 0xb6, 0xa1},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 54
    {54,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x1f, 0x6b, 0xd1, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf,
      0x69, 0x12, 0x28, 0x78, 0xe3, 0xcd, 0xf4, 0x47, 0x56, 0x0b, 0xac, 0xe8,
      0xae, 0xef, 0xa3, 0x68, 0x4b, 0x3d, 0xa9, 0x7e, 0xe4, 0x43, 0xcd, 0x69,
      0xc1, 0x50, 0xc6, 0x00, 0x00, 0x00, 0x00},
     {0x3e, 0xbb, 0xac, 0xe1, 0x09, 0x8a, 0x81, 0x94, 0x9d, 0x56, 0x05,
      0xdd, 0x94, 0xa7, 0xaa, 0x88, 0xdc, 0x39, 0x6c, 0x2c, 0x23, 0xe0,
      0x1a, 0x9c, 0x8c, 0xca, 0x5b, 0xb0, 0x7b, 0xfb, 0xb6, 0xa1},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 55
    {55,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x01, 0xea, 0x77, 0xd4, 0x49, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0x7a, 0xfb, 0xc0, 0xb3, 0x25, 0xe8, 0x20, 0x64, 0x6d,
      0xec, 0x62, 0x2f, 0xb5, 0x58, 0xa5, 0x1c, 0x34, 0x2a, 0xa2, 0x57, 0xf4,
      0xb6, 0xa8, 0xec, 0x5d, 0xdf, 0x14, 0x4f},
     {0x1b, 0x08, 0x52, 0x13, 0xa9, 0xc8, 0x9d, 0x35, 0x3e, 0x11, 0x11,
      0xaf, 0x07, 0x8c, 0x38, 0xc5, 0x02, 0xb7, 0xb4, 0x77, 0x1e, 0xfb,
      0xa5, 0x1f, 0x58, 0x9b, 0x5b, 0xe2, 0x43, 0x41, 0x7b, 0xdc},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 56
    {56,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x01, 0xea, 0x77, 0xd4, 0x49, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xfe, 0x85, 0x04, 0x3f, 0x4d, 0xda, 0x17, 0xdf, 0x9b, 0x92,
      0x13, 0x9d, 0xd0, 0x4a, 0xa7, 0x5a, 0xe4, 0xcb, 0xd5, 0x5d, 0xa8, 0x0b,
      0x49, 0x57, 0x13, 0xa2, 0x20, 0xeb, 0xb0},
     {0x1b, 0x08, 0x52, 0x13, 0xa9, 0xc8, 0x9d, 0x35, 0x3e, 0x11, 0x11,
      0xaf, 0x07, 0x8c, 0x38, 0xc5, 0x02, 0xb7, 0xb4, 0x77, 0x1e, 0xfb,
      0xa5, 0x1f, 0x58, 0x9b, 0x5b, 0xe2, 0x43, 0x41, 0x7b, 0xdc},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 57
    {57,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x02, 0x09, 0x9f, 0x55, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x15,
      0x2c, 0x1a, 0x22, 0xd8, 0x23, 0xa2, 0x78, 0x55, 0xed, 0x03, 0xf8, 0xe2,
      0xab, 0x50, 0x38, 0xbb, 0x1d, 0xf4, 0xd8, 0x7e, 0x43, 0x86, 0x5f, 0x2d,
      0xaf, 0x69, 0x48, 0xff, 0xff, 0xff, 0xff},
     {0x67, 0xcb, 0x63, 0x56, 0x6c, 0x7c, 0xeb, 0x12, 0xfd, 0xd8, 0x5c,
      0xe9, 0xd2, 0xf7, 0x7c, 0x35, 0x92, 0x42, 0xbb, 0xaa, 0x0e, 0xa1,
      0xbf, 0x3c, 0xf5, 0x10, 0xa4, 0xa2, 0x65, 0x91, 0xd1, 0xf1},
     false,
     true},

    // Comment: edge cases for ephemeral key
    // tcID: 58
    {58,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x55, 0xd5, 0x5f, 0x11, 0xbb, 0x8d, 0xa1, 0xea, 0x31, 0x8b, 0xca, 0x72,
      0x66, 0xf0, 0x37, 0x66, 0x62, 0x44, 0x1e, 0xa8, 0x72, 0x70, 0xaa, 0x20,
      0x77, 0xf1, 0xb7, 0x70, 0xc4, 0x85, 0x4a, 0x48, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x4b, 0x16, 0x63, 0xee, 0x1d, 0x93, 0x30, 0xb7, 0x2b, 0x20,
      0xbe, 0xb2, 0x83, 0x98, 0x50, 0x99, 0xef, 0xf7, 0xb4, 0x07, 0xa5, 0xe9,
      0x77, 0xa4, 0x5a, 0x82, 0x5d, 0xe2, 0x9d, 0xee, 0x96, 0xe9, 0xe9, 0xd0,
      0x74, 0xae, 0x4a, 0x80, 0x0e, 0x5c, 0x76, 0x7e, 0x99, 0xeb, 0x88, 0xcd,
      0x1d, 0x57, 0xb0, 0x57, 0x8a, 0x62, 0x0e, 0xd2, 0xbe, 0xb5, 0x57, 0xa8,
      0x4f, 0x3f, 0x76, 0x20, 0x1a, 0x75},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x02, 0x09, 0x9f, 0x55, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,
      0xd3, 0xe5, 0xdc, 0x27, 0xdc, 0x5d, 0x88, 0xaa, 0x12, 0xfc, 0x07, 0x1d,
      0x54, 0xaf, 0xc7, 0x44, 0xe2, 0x0b, 0x28, 0x81, 0xbc, 0x79, 0xa0, 0xd2,
      0x50, 0x96, 0xb7, 0x00, 0x00, 0x00, 0x00},
     {0x67, 0xcb, 0x63, 0x56, 0x6c, 0x7c, 0xeb, 0x12, 0xfd, 0xd8, 0x5c,
      0xe9, 0xd2, 0xf7, 0x7c, 0x35, 0x92, 0x42, 0xbb, 0xaa, 0x0e, 0xa1,
      0xbf, 0x3c, 0xf5, 0x10, 0xa4, 0xa2, 0x65, 0x91, 0xd1, 0xf1},
     false,
     true},

    // Comment: point with coordinate x = 0
    // tcID: 59
    {59,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66,
      0x48, 0x5c, 0x78, 0x0e, 0x2f, 0x83, 0xd7, 0x24, 0x33, 0xbd, 0x5d, 0x84,
      0xa0, 0x6b, 0xb6, 0x54, 0x1c, 0x2a, 0xf3, 0x1d, 0xae, 0x87, 0x17, 0x28,
      0xbf, 0x85, 0x6a, 0x17, 0x4f, 0x93, 0xf4},
     {0xd1, 0x1c, 0x64, 0x0b, 0x43, 0x82, 0xe6, 0x0e, 0xc8, 0xd2, 0x54,
      0xee, 0x76, 0xf0, 0x9b, 0x8f, 0xac, 0x57, 0x65, 0x1a, 0xb7, 0x3b,
      0x6d, 0xd3, 0xfd, 0xc9, 0x35, 0xa6, 0x15, 0x64, 0xa3, 0xe9},
     false,
     true},

    // Comment: point with coordinate x = 0
    // tcID: 60
    {60,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x10, 0x01, 0x21, 0xf1, 0xa0, 0x94, 0x43, 0x85, 0x1c,
      0x9a, 0xa2, 0xab, 0x6e, 0xe6, 0x44, 0x0e, 0x2a, 0xc5, 0xe1, 0xbe, 0x64,
      0x82, 0x74, 0xbd, 0x5d, 0x26, 0xc1, 0x2f, 0xb3, 0xba, 0x3f, 0x7f, 0x03,
      0x2a, 0x1c, 0x21, 0x9f, 0xa1, 0x45, 0x7c, 0xb2, 0x05, 0x88, 0x29, 0x7e,
      0x05, 0x13, 0xcf, 0xd4, 0x90, 0x1f, 0x9a, 0x95, 0x41, 0x4f, 0x7e, 0x91,
      0x4f, 0x91, 0x79, 0xf3, 0x85, 0x67, 0xa6},
     {0x90, 0xe7, 0x12, 0xe2, 0xaf, 0xd1, 0x41, 0x71, 0xc1, 0x94, 0x67,
      0xa2, 0xbf, 0xe7, 0xab, 0xf1, 0xc4, 0x77, 0xd1, 0xf4, 0x0f, 0x66,
      0x75, 0xf0, 0x0e, 0x62, 0x2f, 0xd5, 0x60, 0x4f, 0xa1, 0x6a},
     false,
     true},

    // Comment: point with coordinate x = 0
    // tcID: 61
    {61,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xca, 0xd0, 0x2a, 0xb5, 0x37, 0xc8, 0x08, 0x31, 0xcc,
      0xdd, 0x39, 0x51, 0x29, 0xfc, 0x4b, 0xfe, 0x4a, 0x89, 0xae, 0x0c, 0x86,
      0x6f, 0x66, 0x19, 0xa3, 0xe1, 0x41, 0x46, 0xd3, 0x69, 0x16, 0x94, 0x68,
      0x9d, 0x47, 0x70, 0x65, 0xb4, 0x0f, 0x14, 0x0e, 0xd8, 0x7b, 0x37, 0xad,
      0x04, 0x1e, 0x28, 0x22, 0x9b, 0x0f, 0x79, 0xa6, 0xb3, 0xc9, 0x92, 0x68,
      0x99, 0x54, 0xc9, 0x7f, 0x73, 0x36, 0xd0},
     {0x15, 0x95, 0x83, 0x10, 0x3d, 0x83, 0xf6, 0x35, 0x38, 0xbd, 0x4e,
      0x20, 0x36, 0x07, 0xd7, 0x34, 0x89, 0x90, 0xbb, 0x7f, 0x84, 0x7f,
      0xfb, 0xc9, 0xe5, 0xe5, 0x09, 0xc7, 0xe3, 0x4d, 0x39, 0x2c},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 62
    {62,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xab, 0xd1, 0x2e, 0xed, 0x4d, 0x65, 0x4b, 0xaa, 0x7d,
      0x96, 0x86, 0x33, 0x77, 0x0f, 0x4a, 0x58, 0x2f, 0x17, 0x3d, 0x66, 0x33,
      0x90, 0x60, 0x00, 0xed, 0x8a, 0xcf, 0x62, 0x33, 0xc6, 0x36, 0x5f, 0x09,
      0x12, 0xf3, 0x0b, 0xb9, 0x8e, 0x7c, 0xb5, 0x25, 0x89, 0x0d, 0x5e, 0xa1,
      0xe2, 0x17, 0x14, 0x9d, 0x52, 0xa6, 0xc5, 0x9f, 0x78, 0x02, 0xa9, 0xf3,
      0x07, 0xe8, 0x0d, 0x2a, 0x9f, 0xee, 0x3a},
     {0x54, 0x6a, 0x2d, 0xfa, 0xdb, 0x1d, 0x60, 0x14, 0x0b, 0xec, 0xac,
      0x2d, 0xc2, 0xe6, 0x2d, 0x20, 0xc7, 0x89, 0x03, 0x77, 0x55, 0xad,
      0x5a, 0x49, 0xe3, 0x7e, 0x48, 0xf2, 0xca, 0x1b, 0x76, 0x80},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 63
    {63,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xa5, 0x62, 0xc1, 0xad, 0x9a, 0x72, 0x21, 0x7d, 0xf0,
      0x01, 0x47, 0xc7, 0xd2, 0xce, 0xaf, 0xc6, 0x5a, 0x16, 0x20, 0xa1, 0x46,
      0x9c, 0x94, 0x7e, 0x14, 0xfe, 0x43, 0x00, 0x3a, 0xc5, 0x37, 0x1b, 0x7a,
      0xd1, 0xd3, 0x3c, 0x01, 0xf0, 0xeb, 0x92, 0xb7, 0x79, 0xed, 0x6e, 0x46,
      0x0d, 0x03, 0x34, 0x44, 0x70, 0x75, 0xa3, 0xcf, 0x66, 0xb2, 0xff, 0xbd,
      0xae, 0x31, 0xb4, 0x38, 0xdf, 0x6d, 0x7b},
     {0xe5, 0x85, 0x9c, 0x78, 0x11, 0xc5, 0xc3, 0xac, 0xa6, 0xc2, 0x36,
      0xab, 0x49, 0x9c, 0xca, 0xd1, 0x03, 0x01, 0xc7, 0xc5, 0xee, 0x91,
      0x3c, 0xe9, 0x1b, 0xb6, 0x64, 0x28, 0xcd, 0xe1, 0x1e, 0x4d},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 64
    {64,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8c, 0xdb, 0xeb, 0xe9, 0xd0, 0x7d, 0x2e, 0xbc, 0x4e,
      0x41, 0xb1, 0xd7, 0x2a, 0x9b, 0xac, 0x29, 0x74, 0xcf, 0xc4, 0xcf, 0x73,
      0x8d, 0x8b, 0x6d, 0xe7, 0x1a, 0x40, 0xed, 0xe9, 0x92, 0x0d, 0x88, 0xdc,
      0x24, 0x39, 0xee, 0x00, 0x03, 0xfb, 0xde, 0x7b, 0x0a, 0x3a, 0xe4, 0x17,
      0x10, 0xc6, 0x4b, 0x17, 0xb0, 0x8a, 0x88, 0x41, 0xe9, 0x7a, 0x39, 0x0e,
      0x48, 0x2c, 0x97, 0x68, 0xfe, 0x01, 0xea},
     {0x65, 0x75, 0x4a, 0xb4, 0x59, 0xa1, 0x04, 0x71, 0xaf, 0x00, 0x94,
      0x3f, 0x41, 0x4f, 0x28, 0xde, 0x1b, 0xc3, 0x79, 0x68, 0xb0, 0x97,
      0xad, 0x28, 0x45, 0xfe, 0x11, 0x14, 0x20, 0x85, 0x50, 0x08},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 65
    {65,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf0, 0xcd, 0x7c, 0xd8, 0x33, 0x46, 0x78, 0x30, 0x8c,
      0xfe, 0xb7, 0x85, 0xa6, 0x8a, 0x15, 0x04, 0xa9, 0x14, 0x18, 0xd4, 0x44,
      0x1c, 0x4d, 0x4c, 0x74, 0x0c, 0x57, 0x48, 0x8b, 0x9a, 0xaf, 0xb0, 0x79,
      0xd8, 0xa8, 0xd2, 0x99, 0x73, 0xeb, 0x50, 0x22, 0x67, 0xec, 0xcf, 0x6e,
      0xda, 0x32, 0x66, 0x26, 0xfc, 0x6e, 0x02, 0x5d, 0x53, 0x2b, 0x85, 0xe9,
      0xf7, 0x11, 0xf8, 0xce, 0x69, 0x71, 0xbb},
     {0x86, 0x31, 0xfe, 0xde, 0xe6, 0xce, 0xb3, 0x38, 0x6a, 0xc4, 0x2e,
      0xdf, 0x32, 0x2c, 0x18, 0x88, 0x24, 0x89, 0x3d, 0x26, 0x7d, 0x61,
      0x08, 0xf0, 0xcf, 0x5d, 0xe6, 0x96, 0x4b, 0x88, 0x33, 0x1b},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 66
    {66,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8a, 0xd0, 0xaf, 0x23, 0xb9, 0x0e, 0x03, 0x41, 0xb4,
      0xe2, 0xa5, 0xa9, 0x63, 0xc8, 0x52, 0x2f, 0xe0, 0x11, 0xac, 0xe1, 0x9b,
      0x1b, 0x86, 0x10, 0xcb, 0xe7, 0x92, 0x7a, 0x17, 0xa7, 0x24, 0x97, 0x36,
      0xb8, 0x7a, 0xb9, 0x90, 0x72, 0x89, 0xa2, 0x3a, 0x0f, 0xb2, 0x0c, 0xa4,
      0xbe, 0x42, 0xd4, 0x21, 0xfe, 0x38, 0xd3, 0x5a, 0xf0, 0x9d, 0x79, 0xcb,
      0xe6, 0xe6, 0xa4, 0xe9, 0x5a, 0x1a, 0x8b},
     {0x68, 0xc5, 0x85, 0x99, 0xc1, 0x23, 0xbe, 0x6d, 0x37, 0xd3, 0x43,
      0xbd, 0x41, 0xb1, 0x1c, 0xec, 0xc5, 0xf8, 0x4b, 0x26, 0x35, 0x66,
      0x11, 0x63, 0x65, 0x6f, 0x76, 0xd7, 0xfb, 0x04, 0xb4, 0x26},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 67
    {67,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x59, 0xc9, 0xcc, 0x2d, 0x72, 0x97, 0xdd, 0xb0, 0xbe,
      0x63, 0x04, 0xc9, 0x4c, 0xeb, 0xf4, 0x2d, 0x81, 0x3e, 0x97, 0x0c, 0x50,
      0xf4, 0x52, 0x87, 0x75, 0x3b, 0x8e, 0x9c, 0xb0, 0xc6, 0xdb, 0x45, 0xf5,
      0x71, 0xd9, 0x86, 0x99, 0x08, 0x97, 0x85, 0x1f, 0xc8, 0xe1, 0xdb, 0x67,
      0xc9, 0x97, 0x59, 0xe8, 0x97, 0x9c, 0x3d, 0x9d, 0xdf, 0xd0, 0x2f, 0x63,
      0x3c, 0xf1, 0xea, 0x5b, 0x6c, 0x48, 0xab},
     {0xb5, 0x8d, 0x00, 0x52, 0x5c, 0x4c, 0x4b, 0x4f, 0x46, 0x56, 0x28,
      0x52, 0xc1, 0x5c, 0xe2, 0xe4, 0x8d, 0xbe, 0x23, 0xa3, 0xbe, 0x37,
      0x54, 0x1e, 0x04, 0x84, 0x46, 0xef, 0xf5, 0x15, 0x2e, 0xc6},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 68
    {68,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xe9, 0x70, 0x80, 0xda, 0x72, 0x63, 0xa2, 0x9c, 0x30,
      0x72, 0xa6, 0x51, 0x78, 0xb7, 0xb3, 0x15, 0x87, 0xa5, 0xdf, 0xfc, 0x19,
      0x75, 0x4c, 0x56, 0x1e, 0x32, 0xfc, 0x53, 0x19, 0x92, 0x34, 0xf0, 0x4e,
      0x0b, 0x9b, 0x70, 0xc9, 0x7b, 0x60, 0xe9, 0x40, 0xd5, 0x62, 0x9f, 0x22,
      0x66, 0xd1, 0xa8, 0xe2, 0x42, 0xde, 0xb7, 0x1e, 0xb7, 0xf0, 0xb2, 0xb2,
      0xda, 0x2e, 0x30, 0x44, 0x73, 0x8a, 0xb0},
     {0x4b, 0xaa, 0x01, 0xc2, 0x11, 0xaf, 0x8f, 0x94, 0xac, 0xa8, 0x95,
      0x48, 0x90, 0x2a, 0x71, 0xf7, 0xb5, 0x3f, 0x78, 0x14, 0xbb, 0xce,
      0xb3, 0xd4, 0xbe, 0xf3, 0x1b, 0x37, 0x6e, 0x34, 0xb4, 0x76},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 69
    {69,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x44, 0xf6, 0x00, 0xda, 0x71, 0x60, 0xb9, 0x75, 0xa0,
      0x23, 0x2c, 0xb6, 0xa4, 0xa9, 0xe7, 0x28, 0x03, 0xfd, 0x77, 0xca, 0xac,
      0x84, 0x35, 0x20, 0x39, 0xce, 0x9f, 0x4a, 0x67, 0xa1, 0xda, 0x77, 0x62,
      0x60, 0x45, 0x59, 0x93, 0x81, 0xe5, 0x99, 0xeb, 0x9c, 0xd0, 0x3f, 0x28,
      0x2e, 0x26, 0x7b, 0x8c, 0xfd, 0x3b, 0xa9, 0x8d, 0xab, 0xbb, 0x0f, 0x29,
      0xab, 0x1c, 0x09, 0x44, 0x27, 0x0f, 0x3f},
     {0xe1, 0x9f, 0xe9, 0xd1, 0x29, 0x4c, 0xca, 0x94, 0xa6, 0x38, 0x88,
      0x25, 0x24, 0x9e, 0x6b, 0x37, 0x93, 0x1a, 0x23, 0x1e, 0xb9, 0x17,
      0xcf, 0xec, 0xb2, 0x92, 0x79, 0x2d, 0x0c, 0x18, 0xf1, 0xb8},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 70
    {70,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x71, 0xe3, 0xe9, 0xbe, 0x0e, 0x0e, 0xe4, 0x44, 0x9a,
      0x19, 0xd2, 0xef, 0x79, 0x19, 0x26, 0x68, 0x14, 0xa0, 0xfa, 0xfd, 0x04,
      0xfb, 0x67, 0x7e, 0xdc, 0x32, 0x65, 0x6e, 0x6a, 0x46, 0xe4, 0xd2, 0xbc,
      0x5f, 0x40, 0x4c, 0x5b, 0x54, 0xf0, 0x3e, 0x29, 0x4b, 0xe2, 0x2e, 0x88,
      0x20, 0xa7, 0x1b, 0x4d, 0x4a, 0xc0, 0x4a, 0x70, 0x8e, 0x13, 0xcd, 0x71,
      0xfd, 0xb0, 0x04, 0x1e, 0x7e, 0x96, 0x98},
     {0xdd, 0xc1, 0xf4, 0x66, 0x3b, 0x92, 0x8a, 0xdd, 0x06, 0xb1, 0xe5,
      0x7c, 0x48, 0xdb, 0x98, 0xea, 0x08, 0xc4, 0xd3, 0x3c, 0x3c, 0x21,
      0x06, 0x37, 0x14, 0x07, 0xf3, 0x84, 0x8a, 0x9d, 0x53, 0xf7},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 71
    {71,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x27, 0xb6, 0x93, 0x61, 0x01, 0x54, 0xd5, 0xb7, 0xf0,
      0x80, 0x94, 0xe4, 0x6f, 0xf2, 0xa2, 0xac, 0x1c, 0x01, 0xd3, 0xcd, 0x82,
      0x6e, 0x32, 0x08, 0xe5, 0x25, 0x44, 0x36, 0xed, 0x27, 0x99, 0x60, 0xf2,
      0x36, 0x4e, 0x3a, 0x60, 0x4f, 0x3b, 0x59, 0x2e, 0x19, 0x26, 0x2a, 0x1b,
      0x22, 0xb1, 0xa1, 0x48, 0xe3, 0x8c, 0xd8, 0x2c, 0x9e, 0x54, 0xf1, 0x08,
      0xef, 0x8f, 0x83, 0x36, 0x83, 0xf8, 0xb4},
     {0x91, 0xdf, 0xa9, 0x5e, 0xd1, 0xea, 0xcb, 0xea, 0x41, 0x91, 0x56,
      0x47, 0x1a, 0x8d, 0xdb, 0xb6, 0xcb, 0x93, 0xdd, 0x45, 0x64, 0x33,
      0xe1, 0x86, 0x33, 0xd2, 0x68, 0x17, 0x61, 0x1b, 0x9c, 0x64},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 72
    {72,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xc3, 0x2a, 0x52, 0xaf, 0x6d, 0xac, 0x36, 0x9b, 0x6a,
      0x49, 0x9a, 0x49, 0xd3, 0xe3, 0x8e, 0x7c, 0x95, 0x34, 0xbb, 0x91, 0x39,
      0xf5, 0x7d, 0x49, 0x84, 0xb1, 0xd3, 0xc0, 0x4a, 0xb8, 0x22, 0x06, 0x53,
      0xcd, 0xc2, 0xda, 0xef, 0xac, 0x83, 0xcf, 0x43, 0xc0, 0xd6, 0x46, 0x04,
      0xe5, 0xf9, 0xd8, 0x5b, 0x55, 0xdd, 0xe6, 0x2b, 0x69, 0x2c, 0xd3, 0x6a,
      0xf9, 0x9e, 0xbf, 0xf4, 0x14, 0x0c, 0x39},
     {0x9f, 0x91, 0xa9, 0x63, 0x3d, 0xaa, 0x4c, 0x56, 0x46, 0x5e, 0x9f,
      0xbe, 0xf4, 0x43, 0x1e, 0x13, 0x04, 0x1f, 0x68, 0x91, 0x0f, 0xb5,
      0xba, 0x89, 0xf8, 0xda, 0x93, 0x81, 0xd6, 0x8a, 0x0d, 0xfe},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 73
    {73,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x6f, 0x4e, 0x2f, 0x72, 0xf3, 0x2a, 0xe6, 0x6f, 0x1f,
      0x46, 0x10, 0x96, 0x60, 0x04, 0xc4, 0x36, 0xaa, 0x0d, 0x90, 0xb7, 0xdf,
      0x07, 0xce, 0x9c, 0x4a, 0xca, 0x52, 0xb0, 0x2d, 0x46, 0xb4, 0xd0, 0xc6,
      0xa3, 0xec, 0x76, 0xbf, 0x32, 0x1b, 0x7f, 0xe5, 0x20, 0x3c, 0xf3, 0xd6,
      0x6e, 0x2d, 0x52, 0xe3, 0xee, 0x04, 0x95, 0xec, 0x76, 0x6d, 0x57, 0x9a,
      0x45, 0x11, 0x17, 0x5e, 0x01, 0xbc, 0x4d},
     {0x01, 0x4a, 0xe8, 0x14, 0x42, 0xf8, 0xcb, 0x6d, 0xf5, 0x8f, 0xf4,
      0x1e, 0x6d, 0xb2, 0x03, 0xdb, 0x40, 0xea, 0x95, 0x1b, 0x91, 0xbe,
      0xbf, 0x86, 0xd4, 0x2c, 0xda, 0x7b, 0xe3, 0x3f, 0xea, 0x64},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 74
    {74,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x2e, 0x06, 0x59, 0x75, 0xdf, 0x64, 0x2f, 0xcf, 0xda,
      0xfe, 0x2f, 0xa5, 0xaf, 0xfc, 0x18, 0xb2, 0xc6, 0x83, 0x71, 0x79, 0x6f,
      0x9d, 0x96, 0x3d, 0x89, 0xc4, 0xf5, 0xac, 0x5c, 0xce, 0xa2, 0x8b, 0x99,
      0x0f, 0x31, 0x52, 0x2f, 0xbb, 0x26, 0x5c, 0x3f, 0x4d, 0x5c, 0x4b, 0xb8,
      0x2e, 0xbf, 0x5d, 0xdf, 0xf5, 0xa8, 0xea, 0x58, 0x8d, 0xb4, 0xd2, 0x82,
      0xac, 0xdc, 0xa7, 0xa6, 0xcc, 0xf4, 0x28},
     {0x78, 0xe8, 0x1e, 0x85, 0x73, 0xc3, 0xae, 0x60, 0x89, 0xdf, 0x7d,
      0xb1, 0xfb, 0x29, 0xd7, 0xbe, 0x12, 0xdc, 0x11, 0xf1, 0x5b, 0xb2,
      0x5b, 0xff, 0x2a, 0xf8, 0x02, 0xe1, 0x5d, 0xdc, 0x13, 0x6e},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 75
    {75,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xe1, 0x33, 0x1e, 0xee, 0x03, 0xc5, 0x0c, 0xc2, 0xb9,
      0x09, 0x44, 0xdd, 0xfc, 0x0d, 0x3a, 0x7d, 0xd8, 0x18, 0x5e, 0x6c, 0x21,
      0xc7, 0x5f, 0xa9, 0x2a, 0x0c, 0x14, 0xb0, 0xf1, 0x94, 0x9a, 0xc9, 0x15,
      0x4d, 0x78, 0x3f, 0x45, 0x47, 0xdc, 0xf5, 0x50, 0x8b, 0xbd, 0x86, 0xc3,
      0xdd, 0x8c, 0x3b, 0x17, 0xb6, 0x19, 0x89, 0xf9, 0x3d, 0xb5, 0x49, 0x0e,
      0xc0, 0x2a, 0x46, 0xa1, 0x00, 0x5c, 0x2c},
     {0xed, 0x67, 0x19, 0x5a, 0x27, 0x2c, 0x63, 0xc5, 0x02, 0x05, 0xab,
      0xf2, 0x74, 0x39, 0x29, 0x11, 0x34, 0xff, 0xa1, 0xe8, 0xec, 0x59,
      0x7f, 0x3b, 0x30, 0x27, 0x16, 0xd9, 0x36, 0x32, 0xe9, 0x8d},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 76
    {76,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xe0, 0xc5, 0x6d, 0x48, 0x6e, 0x9c, 0x01, 0x16, 0x3e,
      0xd6, 0xc3, 0xff, 0x25, 0xde, 0x3c, 0xdf, 0x57, 0x44, 0xdb, 0xf9, 0xe0,
      0xe0, 0x0b, 0xdc, 0xf1, 0x99, 0x65, 0xdf, 0x4b, 0xa1, 0xf3, 0x11, 0xbd,
      0x5e, 0x44, 0x43, 0x06, 0x65, 0x82, 0x3d, 0x8c, 0x0b, 0x34, 0xeb, 0xec,
      0x0a, 0x6a, 0xab, 0x5e, 0xa9, 0x6c, 0xf2, 0x39, 0xde, 0x21, 0x4f, 0xd0,
      0x11, 0xe6, 0xf9, 0xec, 0x50, 0x1d, 0xd4},
     {0x50, 0x77, 0x43, 0x47, 0x84, 0x88, 0x28, 0xee, 0xb6, 0x23, 0x0f,
      0x49, 0x7c, 0xd1, 0x81, 0xf8, 0xc5, 0x7f, 0xbd, 0x18, 0xff, 0xbf,
      0x83, 0x28, 0xcd, 0x00, 0x83, 0x21, 0xa1, 0xc3, 0x7c, 0x43},
     false,
     true},

    // Comment: point with coordinate x = 0 in left to right addition chain
    // tcID: 77
    {77,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xe4, 0x61, 0xc5, 0xb5, 0xe6, 0x3d, 0x75, 0xb4, 0xc8, 0xc1, 0x23, 0xbf,
      0x8b, 0x9c, 0xd4, 0x5e, 0x71, 0x2a, 0xf0, 0x8f, 0x7e, 0x2e, 0x49, 0x4a,
      0x8f, 0x25, 0x5a, 0xc9, 0xd8, 0x0e, 0x05, 0x8b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0xc8, 0x32, 0xa3, 0x24, 0xe8, 0x0a, 0xd0, 0x28, 0xf7,
      0x2f, 0xf9, 0xbd, 0x8f, 0x5f, 0x0d, 0x1a, 0xad, 0x5c, 0x12, 0x1d, 0xc4,
      0xcb, 0xeb, 0x77, 0xde, 0x40, 0xd8, 0xa7, 0x0f, 0x4a, 0x85, 0x92, 0x78,
      0x72, 0x1b, 0x23, 0x84, 0x99, 0xbf, 0xb0, 0xc9, 0x78, 0x5d, 0x6f, 0x2d,
      0xca, 0x2b, 0xc9, 0xf6, 0x36, 0x51, 0xa4, 0x58, 0xb5, 0x55, 0x10, 0xa2,
      0x27, 0x54, 0xbe, 0x3d, 0xe2, 0x03},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x88, 0x5e, 0xad, 0x6c, 0x07, 0x4f, 0x8d, 0x75, 0x1a,
      0x76, 0x7e, 0x91, 0x8c, 0x4e, 0x89, 0x21, 0x0a, 0x58, 0x7c, 0x4b, 0x19,
      0xd4, 0x22, 0x44, 0xae, 0x07, 0x02, 0x7e, 0x36, 0x18, 0x31, 0x05, 0x3e,
      0x80, 0x77, 0x2b, 0xe5, 0x7f, 0xbd, 0x74, 0x49, 0x55, 0xa2, 0xe8, 0x52,
      0x30, 0x63, 0xcc, 0x61, 0x36, 0xf2, 0xbb, 0x37, 0xbe, 0xfb, 0xef, 0x7a,
      0x68, 0x1d, 0x3b, 0xbb, 0xc5, 0x77, 0x88},
     {0x91, 0x3d, 0xa7, 0x10, 0x44, 0xb8, 0x02, 0x1a, 0x86, 0xc8, 0xfc,
      0xaf, 0x4f, 0x63, 0x4d, 0x0d, 0x62, 0x5f, 0xf9, 0x1e, 0xe1, 0xc8,
      0x47, 0x4d, 0x54, 0x8b, 0xd1, 0x08, 0x88, 0x96, 0x4f, 0xb1},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 78
    {78,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x41, 0xe9, 0xd4, 0xcf, 0xa8, 0xef, 0xe8, 0x0b, 0x89,
      0x5a, 0x8c, 0xbc, 0xce, 0x25, 0x68, 0xe2, 0x51, 0xdb, 0x7e, 0xcd, 0xfd,
      0x20, 0xa7, 0xad, 0x71, 0x0d, 0x4a, 0x4b, 0xf2, 0xad, 0xdc, 0x6b, 0x5e,
      0xc3, 0x6a, 0x83, 0x39, 0x16, 0x8a, 0x03, 0xf1, 0x5b, 0x8c, 0x80, 0xf2,
      0xa2, 0xa8, 0x28, 0xf1, 0x51, 0xd3, 0x87, 0x91, 0x58, 0x48, 0x53, 0xba,
      0x2f, 0xf4, 0x4a, 0x2a, 0x04, 0x60, 0xa1},
     {0xb4, 0x8e, 0x11, 0x9d, 0x29, 0xee, 0xf7, 0xdb, 0xb7, 0x6b, 0x64,
      0x21, 0x8e, 0x72, 0x8d, 0xdb, 0xf6, 0xec, 0x60, 0x05, 0x05, 0xec,
      0x7c, 0xed, 0x6a, 0xb6, 0xfb, 0x87, 0x63, 0x30, 0x8d, 0xa5},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 79
    {79,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x77, 0x6a, 0xef, 0x1a, 0xcb, 0x82, 0xb6, 0x28, 0xe1,
      0x32, 0xcc, 0x29, 0x44, 0x09, 0x88, 0xf0, 0xa1, 0x5d, 0x4c, 0xc2, 0xb4,
      0xf3, 0x28, 0xae, 0xcb, 0x06, 0x3c, 0x9b, 0x86, 0xe5, 0x01, 0x8e, 0x6e,
      0x44, 0xdf, 0xc6, 0x04, 0x44, 0xfa, 0xa9, 0xc4, 0xe3, 0x6b, 0xc2, 0x17,
      0x45, 0x1f, 0x7a, 0xc2, 0x95, 0x6c, 0xb3, 0xb2, 0xe9, 0xbb, 0xd6, 0x55,
      0xeb, 0xa2, 0x97, 0x16, 0x3d, 0x1f, 0x34},
     {0x28, 0xa8, 0x8b, 0x6b, 0x25, 0x8f, 0x23, 0x30, 0x20, 0xba, 0x6f,
      0xa9, 0xc0, 0x0d, 0x1d, 0x72, 0x83, 0x1f, 0x45, 0x15, 0xb8, 0x69,
      0x66, 0xa9, 0x78, 0x2f, 0x52, 0x13, 0x15, 0xe1, 0x8a, 0xa7},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 80
    {80,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x9e, 0xc0, 0x6b, 0x0b, 0x08, 0x66, 0x2c, 0x0e, 0x1d,
      0xd9, 0x11, 0x16, 0x96, 0xa6, 0x3a, 0x16, 0x01, 0xcc, 0x83, 0xce, 0xe2,
      0x06, 0x95, 0x77, 0x8a, 0xdf, 0x84, 0xd4, 0x30, 0x64, 0xfc, 0x90, 0x15,
      0x60, 0x01, 0xf0, 0x84, 0xcd, 0x3c, 0x1d, 0xf1, 0xa0, 0x87, 0xf6, 0x26,
      0x53, 0x3b, 0x65, 0x72, 0x58, 0x48, 0x89, 0xbd, 0x3d, 0x5c, 0x2c, 0x99,
      0xf0, 0xe3, 0x11, 0xe2, 0x2b, 0x41, 0xe6},
     {0xc4, 0xff, 0x86, 0x5f, 0xf3, 0xdc, 0x49, 0x53, 0xea, 0x78, 0xd9,
      0x2a, 0x02, 0xf3, 0x34, 0x5a, 0x53, 0xbd, 0xb6, 0x05, 0x0c, 0xfd,
      0x8f, 0x41, 0xba, 0xa4, 0x39, 0x5e, 0xcb, 0x6a, 0xca, 0xb8},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 81
    {81,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xfa, 0x51, 0xd1, 0x28, 0xad, 0xc2, 0x00, 0x0f, 0x09,
      0xff, 0x12, 0xc6, 0xfd, 0x8e, 0x25, 0xaa, 0x08, 0x55, 0x6d, 0x70, 0x8b,
      0xf6, 0xb0, 0xff, 0xff, 0x9e, 0x8e, 0xaa, 0xd4, 0x78, 0x3f, 0x0d, 0xe2,
      0x2b, 0xf5, 0x29, 0xe5, 0x16, 0xe1, 0xf6, 0x4b, 0x8e, 0x0d, 0x09, 0xf9,
      0x8f, 0xad, 0x4e, 0x50, 0x16, 0x95, 0xa9, 0x30, 0xa1, 0xb2, 0x20, 0x76,
      0x65, 0x9d, 0xa7, 0x07, 0xe3, 0xcc, 0xd0},
     {0xde, 0x10, 0x69, 0xf0, 0x51, 0x63, 0x7e, 0x10, 0x16, 0x65, 0x59,
      0xce, 0xf4, 0x46, 0x88, 0xaf, 0xc8, 0x09, 0x34, 0x18, 0x55, 0x26,
      0x12, 0x15, 0xc4, 0xf3, 0x81, 0xd9, 0xd7, 0xda, 0x76, 0xca},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 82
    {82,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x61, 0x4d, 0xcf, 0xbe, 0xa4, 0x78, 0x9a, 0x3f, 0x3e,
      0xb4, 0xa8, 0xe2, 0xf1, 0x11, 0xc8, 0x87, 0xf0, 0x24, 0x8d, 0x93, 0x16,
      0xb9, 0x9d, 0x08, 0x64, 0xc9, 0x27, 0xa0, 0x45, 0xd6, 0x94, 0x17, 0x53,
      0xa0, 0x73, 0xbe, 0xfe, 0x08, 0x49, 0x1a, 0x80, 0x50, 0xa4, 0xd9, 0x6d,
      0x08, 0xba, 0x47, 0x90, 0xae, 0x18, 0xdb, 0x3e, 0xf7, 0xf0, 0xea, 0xcc,
      0xf5, 0x9c, 0xe1, 0x09, 0x5a, 0xfc, 0x54},
     {0x42, 0x07, 0xbf, 0x41, 0x59, 0xfa, 0xa0, 0xe5, 0x0e, 0xd2, 0x38,
      0xb9, 0xc0, 0xff, 0x46, 0x19, 0x4a, 0x53, 0x9a, 0x1b, 0xa0, 0x3a,
      0x5a, 0x4c, 0x8d, 0x68, 0xf3, 0x69, 0xae, 0xcd, 0x31, 0xa5},
     false,
     true},

    // Comment: point with coordinate x = 0 in precomputation or right to left
    // addition chain
    // tcID: 83
    {83,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xef, 0xe7, 0x75, 0x4e, 0xd4, 0xc0, 0xb3, 0xc1, 0xdd,
      0x30, 0x1b, 0xc1, 0xed, 0x69, 0x80, 0x0a, 0xa2, 0xff, 0x5d, 0x51, 0xfb,
      0x85, 0x93, 0x77, 0x15, 0xe6, 0x0d, 0x2e, 0x7b, 0xca, 0xda, 0x8e, 0xb1,
      0x58, 0x1a, 0xb7, 0x5f, 0xb3, 0xc7, 0x97, 0xef, 0x94, 0xa9, 0xdb, 0xa3,
      0xd8, 0x25, 0x68, 0xc8, 0x46, 0x17, 0xea, 0xf3, 0xfa, 0x04, 0xf2, 0x79,
      0xfb, 0xfd, 0x89, 0x8f, 0x70, 0x46, 0x04},
     {0xb5, 0xa0, 0xec, 0x92, 0xae, 0xcc, 0x30, 0x10, 0xd2, 0x7d, 0x22,
      0x63, 0xd3, 0xda, 0x66, 0xe3, 0xd2, 0xf3, 0x39, 0x5d, 0x23, 0x94,
      0x70, 0x24, 0xa3, 0xf4, 0x74, 0x44, 0x54, 0x62, 0x20, 0x27},
     false,
     true},

    // Comment: point with coordinate x = 0 in right to left addition chain
    // tcID: 84
    {84,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd8, 0xe1, 0x3f, 0xbd, 0x01, 0x7f, 0x1f, 0x9a, 0x26,
      0xbe, 0x35, 0xc6, 0x11, 0xd7, 0xb2, 0x29, 0x9f, 0x5d, 0x10, 0xde, 0x3c,
      0x8a, 0x26, 0x36, 0x22, 0x73, 0xff, 0xfb, 0x85, 0x23, 0x8f, 0x3e, 0xd1,
      0x42, 0x6b, 0x74, 0x8c, 0x1f, 0x87, 0xe3, 0xaf, 0xa2, 0xc1, 0xe7, 0xa0,
      0x22, 0x43, 0x10, 0xc9, 0x80, 0x65, 0x5e, 0x07, 0x39, 0x95, 0x90, 0xd1,
      0x49, 0x4d, 0x6d, 0x6b, 0xea, 0x03, 0x96},
     {0xd2, 0xa5, 0xbc, 0x66, 0x49, 0x8c, 0x60, 0x36, 0xae, 0xcd, 0xfa,
      0xad, 0x04, 0x1c, 0xef, 0x73, 0x2a, 0x89, 0x3d, 0xe1, 0x90, 0xa0,
      0xa5, 0xb4, 0x2f, 0xf7, 0x1e, 0x13, 0xf0, 0x92, 0x80, 0xe7},
     false,
     true},

    // Comment: point with coordinate x = 0 in right to left addition chain
    // tcID: 85
    {85,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5a, 0x10, 0x27, 0x66, 0x6a, 0x0e, 0x37, 0x24, 0x81,
      0xfe, 0xc0, 0xb3, 0x90, 0x1e, 0x05, 0x8d, 0x60, 0x10, 0x7c, 0x07, 0xb1,
      0x11, 0x55, 0x50, 0xce, 0xb0, 0x57, 0x89, 0xb5, 0x5a, 0x6d, 0x35, 0x06,
      0x3d, 0x4c, 0x8e, 0xe6, 0x6e, 0xd4, 0x5f, 0xf3, 0xe1, 0xdf, 0xdc, 0xfd,
      0x73, 0xed, 0x96, 0xa9, 0xe8, 0x31, 0x93, 0x88, 0x4a, 0xdb, 0xca, 0xa5,
      0x74, 0xb2, 0xdd, 0x11, 0x8a, 0x69, 0x2b},
     {0x1f, 0x81, 0x23, 0x13, 0xdd, 0xcf, 0x36, 0xbc, 0x38, 0x07, 0x1d,
      0x0e, 0x51, 0xa7, 0x41, 0x00, 0xd6, 0x30, 0xc8, 0xe2, 0x0c, 0xc4,
      0x14, 0x32, 0x6e, 0xef, 0xa4, 0x2e, 0xcb, 0x1b, 0x5f, 0x8e},
     false,
     true},

    // Comment: point with coordinate x = 0 in right to left addition chain
    // tcID: 86
    {86,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x79, 0x37, 0xb9, 0xc4, 0x09, 0x86, 0xdd, 0x75, 0x5a,
      0x06, 0x56, 0x20, 0x30, 0x89, 0x78, 0x25, 0x83, 0xda, 0x7d, 0x81, 0x13,
      0xa4, 0x41, 0x90, 0x76, 0x2a, 0xb4, 0x74, 0xa2, 0x0b, 0xcf, 0x60, 0xef,
      0xcb, 0xc1, 0x52, 0x5a, 0xed, 0x5b, 0x4a, 0xd8, 0xe6, 0x87, 0xcb, 0x02,
      0xc2, 0xef, 0x88, 0x87, 0x09, 0x5c, 0xad, 0xca, 0x56, 0xc7, 0x65, 0xb4,
      0x1b, 0x4a, 0x95, 0x44, 0xff, 0x2f, 0xe8},
     {0xf2, 0x84, 0x08, 0x9b, 0xdd, 0xd5, 0xe2, 0xe1, 0xbe, 0x3f, 0x82,
      0x64, 0x0e, 0xfa, 0x06, 0x58, 0x46, 0x8f, 0xa1, 0xf1, 0x0b, 0x28,
      0x19, 0x63, 0xa3, 0xca, 0x19, 0x0c, 0x39, 0x82, 0xfd, 0xa6},
     false,
     true},

    // Comment: point with coordinate x = 0 in right to left addition chain
    // tcID: 87
    {87,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x93, 0x68, 0x06, 0x6a, 0x07, 0x48, 0x86, 0x7a, 0x7b,
      0x87, 0x02, 0x44, 0xf5, 0xc9, 0xf8, 0x2e, 0xa8, 0xbd, 0x51, 0x55, 0x29,
      0x59, 0xdd, 0x55, 0x0b, 0xb7, 0x39, 0x44, 0x97, 0x15, 0x9a, 0x5d, 0x40,
      0x76, 0x4a, 0xdd, 0x1a, 0xe2, 0x4c, 0x8e, 0x3f, 0x43, 0x2e, 0xe0, 0x11,
      0xbe, 0x97, 0xd3, 0x13, 0x07, 0x18, 0xfe, 0x0a, 0x6a, 0x90, 0xed, 0x8b,
      0x10, 0x11, 0xb2, 0x03, 0x4d, 0x09, 0xa0},
     {0x45, 0x29, 0xf4, 0xb6, 0x31, 0xc9, 0x98, 0x4a, 0xb2, 0x16, 0xa6,
      0x80, 0x12, 0x81, 0xfc, 0x4f, 0xd8, 0x73, 0x1a, 0x58, 0xb6, 0x5c,
      0xa8, 0xd0, 0x7b, 0xff, 0x07, 0x81, 0x11, 0x16, 0x37, 0x1f},
     false,
     true},

    // Comment: point with coordinate x = 0 in right to left addition chain
    // tcID: 88
    {88,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x98, 0x1d, 0x74, 0x49, 0xbd, 0xf0, 0x01, 0x3f, 0x5e,
      0xed, 0xdb, 0xb7, 0xe4, 0x2c, 0x44, 0x2f, 0x7c, 0xcd, 0xd9, 0x42, 0x7b,
      0xd2, 0x6d, 0x7b, 0x38, 0x87, 0x55, 0xaa, 0x5e, 0x26, 0xf4, 0x6a, 0x12,
      0x92, 0xb8, 0x8f, 0xa6, 0xbf, 0x5d, 0xff, 0xca, 0x05, 0x4d, 0xd4, 0x2e,
      0xd3, 0x59, 0x42, 0x77, 0xb5, 0x93, 0xdc, 0xc4, 0x02, 0xd8, 0x03, 0x40,
      0xfb, 0x78, 0x16, 0xe4, 0xdc, 0xab, 0x37},
     {0x64, 0xbb, 0xc9, 0xfd, 0xd7, 0x36, 0x43, 0xeb, 0x29, 0x54, 0xf4,
      0xab, 0x64, 0x03, 0x81, 0xb9, 0x38, 0xc5, 0xe6, 0x01, 0x84, 0x6a,
      0x0c, 0x6b, 0x69, 0x54, 0x96, 0x6e, 0x0d, 0xc7, 0x3e, 0x6f},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 89
    {89,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x09, 0xe7, 0x8d, 0x4e, 0xf6, 0x0d, 0x05, 0xf7, 0x50,
      0xf6, 0x63, 0x62, 0x09, 0x09, 0x2b, 0xc4, 0x3c, 0xbd, 0xd6, 0xb4, 0x7e,
      0x11, 0xa9, 0xde, 0x20, 0xa9, 0xfe, 0xb2, 0xa5, 0x0b, 0xb9, 0x6c, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {0x28, 0xf6, 0x77, 0x57, 0xac, 0xc2, 0x8b, 0x16, 0x84, 0xba, 0x76,
      0xff, 0xd5, 0x34, 0xae, 0xd4, 0x2d, 0x45, 0xb8, 0xb3, 0xf1, 0x0b,
      0x82, 0xa5, 0x69, 0x94, 0x16, 0xef, 0xf7, 0x19, 0x9a, 0x74},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 90
    {90,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x53, 0x84, 0xd6, 0xc0, 0xde, 0xf7, 0x89, 0x60, 0xdb,
      0x96, 0x7b, 0x80, 0x96, 0xd3, 0x54, 0x77, 0xc5, 0xa5, 0xce, 0x30, 0xef,
      0x0c, 0x6d, 0x88, 0x79, 0xa5, 0x56, 0x8c, 0xa8, 0x7e, 0x97, 0x94, 0x01,
      0xee, 0x56, 0xc4, 0x58, 0x17, 0x22, 0x61, 0x0b, 0x43, 0xf3, 0xcb, 0xfc,
      0xf3, 0x86, 0x2c, 0x08, 0x2a, 0x6e, 0x36, 0xba, 0xa3, 0x6f, 0xd6, 0xf7,
      0x84, 0x03, 0xc0, 0xe3, 0x99, 0xfa, 0xa5},
     {0x9e, 0xe6, 0x53, 0xcd, 0xa4, 0x6d, 0xb6, 0x76, 0x12, 0x76, 0x0c,
      0xe3, 0x5b, 0xac, 0x84, 0x50, 0xbb, 0xf4, 0x8d, 0xbf, 0x74, 0x45,
      0x1e, 0xd9, 0x3a, 0xbb, 0x6d, 0xb4, 0x08, 0xa9, 0xfe, 0x10},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 91
    {91,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x4e, 0xca, 0x76, 0x41, 0xa4, 0xaf, 0xd5, 0xea, 0xb0,
      0xb2, 0x14, 0x65, 0x7f, 0xf3, 0xbd, 0xcb, 0xfc, 0x66, 0xf1, 0x55, 0x1a,
      0x53, 0xbb, 0x59, 0x49, 0x3b, 0xc3, 0x8e, 0xd7, 0x8f, 0xf3, 0x96, 0x14,
      0xa0, 0xca, 0xdf, 0xf1, 0x4c, 0x14, 0x73, 0x6e, 0xdb, 0xdc, 0xda, 0xb5,
      0x10, 0xcb, 0xa0, 0x7a, 0x89, 0x24, 0xff, 0xd0, 0x49, 0x0e, 0xe5, 0x14,
      0xae, 0xdf, 0xaa, 0xdb, 0x64, 0x8b, 0x01},
     {0x97, 0x36, 0xad, 0x6b, 0x2a, 0x2e, 0xf1, 0x7e, 0xc3, 0xf8, 0xc8,
      0xdc, 0x2e, 0x35, 0x71, 0x5f, 0xb1, 0xc0, 0x6f, 0x28, 0xd8, 0x2e,
      0x4e, 0x26, 0x87, 0x6f, 0x02, 0x14, 0x58, 0x81, 0x65, 0xf1},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 92
    {92,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8d, 0x01, 0x77, 0xeb, 0xab, 0x9c, 0x6e, 0x9e, 0x10,
      0xdb, 0x6d, 0xd0, 0x95, 0xdb, 0xac, 0x0d, 0x63, 0x75, 0xe8, 0xa9, 0x7b,
      0x70, 0xf6, 0x11, 0x87, 0x5d, 0x87, 0x7f, 0x00, 0x69, 0xd2, 0xc7, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {0x74, 0x8f, 0xa4, 0xf5, 0xa3, 0x99, 0x32, 0x03, 0x82, 0xdc, 0x92,
      0x00, 0x26, 0x93, 0x86, 0x94, 0xc4, 0x1a, 0x26, 0xfe, 0x2a, 0xaa,
      0x31, 0x8c, 0x5e, 0x71, 0x01, 0x98, 0xdd, 0x71, 0xc7, 0x93},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 93
    {93,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5f, 0xdb, 0x7f, 0x0c, 0xff, 0xb8, 0xb5, 0xb1, 0x14,
      0x2d, 0x24, 0x69, 0x8a, 0x4b, 0xda, 0x76, 0xbf, 0x98, 0x27, 0xd6, 0x3b,
      0x1a, 0x6b, 0xd8, 0x5a, 0x4e, 0x2f, 0x9b, 0x59, 0xc5, 0x10, 0xcf, 0xbc,
      0xb3, 0x5b, 0xa9, 0xc9, 0x87, 0x10, 0x8b, 0x6d, 0x43, 0x37, 0xad, 0x53,
      0x93, 0xf9, 0xf9, 0x10, 0xec, 0x92, 0x41, 0x0c, 0x23, 0x08, 0x69, 0xd6,
      0x65, 0x28, 0xed, 0x88, 0xc1, 0xb9, 0x8a},
     {0x7f, 0x97, 0xdb, 0x83, 0xb4, 0xd8, 0x6f, 0x04, 0xfe, 0x28, 0x60,
      0x41, 0xee, 0x21, 0xe8, 0x0e, 0xc3, 0xd5, 0x9f, 0x3c, 0xe8, 0x2c,
      0xde, 0xea, 0xf3, 0x62, 0x01, 0x6f, 0xc8, 0x7a, 0x3e, 0x02},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 94
    {94,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x53, 0x0b, 0x22, 0x93, 0xe6, 0x0c, 0x6b, 0x6f, 0x14,
      0xc7, 0x5c, 0x90, 0xb1, 0xef, 0x8b, 0x9f, 0x9f, 0xa6, 0xb2, 0x15, 0x1b,
      0x8d, 0x98, 0x55, 0x79, 0x2e, 0xb2, 0xb3, 0xdc, 0x69, 0xf0, 0x7a, 0x0d,
      0xb4, 0x24, 0x40, 0xe7, 0x3f, 0xd7, 0xd6, 0xdf, 0x04, 0xae, 0xd5, 0x02,
      0x2f, 0xbe, 0x21, 0xce, 0xae, 0xc3, 0x3c, 0x5f, 0xba, 0xde, 0x1b, 0xd6,
      0xad, 0x32, 0x1e, 0xf2, 0xe1, 0x0d, 0x0b},
     {0x21, 0x79, 0x4c, 0xf2, 0x4f, 0x56, 0x27, 0x3f, 0xa4, 0x46, 0x3c,
      0xc7, 0xae, 0x42, 0x32, 0xfa, 0x34, 0xdb, 0xe0, 0xf1, 0x8b, 0x73,
      0x61, 0x3b, 0x8a, 0xe9, 0xcb, 0xfb, 0x9c, 0x36, 0xab, 0xf0},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 95
    {95,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x69, 0x16, 0xfa, 0xc4, 0x5e, 0x56, 0x8b, 0x6b, 0x9e,
      0x2e, 0x2e, 0xcd, 0x61, 0x1b, 0x28, 0x2e, 0x5f, 0xcc, 0x40, 0xa3, 0x06,
      0x7d, 0x60, 0x10, 0x57, 0xf8, 0x79, 0xce, 0x5a, 0x8a, 0x73, 0xcc, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {0x91, 0x51, 0x06, 0xd0, 0x78, 0x16, 0xe8, 0x79, 0xe7, 0x64, 0x3f,
      0x00, 0xab, 0xf6, 0xd7, 0x9f, 0xb8, 0xf1, 0xcb, 0x78, 0xbf, 0x64,
      0xa6, 0xa3, 0x82, 0x7f, 0x91, 0xa7, 0xb0, 0xef, 0x0f, 0x41},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 96
    {96,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xed, 0x95, 0x68, 0xc8, 0x5b, 0xc5, 0x2a, 0x6b, 0x45,
      0x73, 0x36, 0x18, 0xc3, 0x60, 0x21, 0x07, 0xc1, 0xfd, 0xac, 0xf2, 0x3b,
      0x1a, 0x38, 0xe4, 0x86, 0xaf, 0x95, 0x97, 0x8a, 0x21, 0x4e, 0x2e, 0xfa,
      0x0d, 0x71, 0xd5, 0xe7, 0x37, 0x89, 0x1c, 0x42, 0x76, 0xe2, 0x47, 0x58,
      0x1e, 0xe6, 0x13, 0x90, 0x11, 0xca, 0x14, 0x60, 0xdb, 0x9b, 0x1e, 0x20,
      0xb3, 0x64, 0xd9, 0x27, 0x56, 0x83, 0xe2},
     {0x2f, 0xcc, 0xe5, 0x52, 0x31, 0x08, 0x19, 0xdd, 0x77, 0x5a, 0xb7,
      0xba, 0x9f, 0xf0, 0xf9, 0x6a, 0x1f, 0xca, 0xdd, 0x25, 0xa0, 0xc7,
      0x09, 0x70, 0x3c, 0xef, 0x04, 0xbb, 0x6e, 0x1a, 0x7b, 0xd7},
     false,
     true},

    // Comment: point with coordinate y = 1
    // tcID: 97
    {97,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x9f, 0xf7, 0x73, 0x1c, 0x00, 0xf2, 0xaa, 0x88, 0xb3,
      0xfc, 0x17, 0x4a, 0xba, 0x90, 0x7a, 0xd1, 0x75, 0x95, 0xe6, 0x02, 0xe7,
      0x68, 0xa5, 0xf1, 0xe9, 0x46, 0x2a, 0x6d, 0x4b, 0x89, 0xb2, 0xd2, 0x3f,
      0x17, 0x8a, 0x70, 0xb9, 0xbb, 0x3e, 0xdc, 0xe2, 0x89, 0x11, 0x83, 0x38,
      0xa3, 0x3d, 0xf3, 0x0c, 0x43, 0x2c, 0x34, 0x7f, 0x12, 0xa3, 0xde, 0x0a,
      0x2b, 0x03, 0xb3, 0x53, 0x87, 0x8d, 0x96},
     {0x75, 0x7d, 0x92, 0x6a, 0x26, 0x93, 0xbc, 0x8a, 0x3d, 0x2d, 0x8c,
      0x05, 0x54, 0xa1, 0x35, 0x79, 0xef, 0x9e, 0x55, 0x91, 0x86, 0x57,
      0x89, 0x11, 0xf3, 0x7e, 0xdc, 0x88, 0xb2, 0xf5, 0xe6, 0x1a},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 98
    {98,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x82, 0x70, 0xf8, 0x17, 0x9d, 0x57, 0x43, 0x6b, 0x34,
      0xdf, 0xc0, 0xbd, 0xf7, 0xd4, 0x17, 0xa5, 0xc8, 0x95, 0x11, 0x6b, 0x90,
      0xcb, 0x51, 0xae, 0xc7, 0x18, 0x61, 0x4f, 0x86, 0x4a, 0x63, 0x5d, 0x17,
      0x48, 0x04, 0xe0, 0xc0, 0xe0, 0x6e, 0x3d, 0x68, 0xd3, 0x14, 0x9e, 0x0b,
      0x95, 0x66, 0x21, 0xc6, 0xaa, 0x2b, 0xde, 0x83, 0xf4, 0xd1, 0x7d, 0x03,
      0xd2, 0x8e, 0xf8, 0xaa, 0x38, 0x9f, 0xff},
     {0x3d, 0xb2, 0x9e, 0xc6, 0xf9, 0x78, 0xd2, 0x26, 0x9e, 0x92, 0xe9,
      0xc7, 0xeb, 0x5c, 0x8b, 0x5a, 0x8e, 0x56, 0xc2, 0x22, 0x8a, 0x4f,
      0xb9, 0xe4, 0x83, 0xfe, 0xca, 0x50, 0xaa, 0x3e, 0x45, 0x1f},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 99
    {99,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xc6, 0x17, 0x50, 0xe9, 0x8a, 0xba, 0xf2, 0x02, 0x25,
      0xa8, 0x81, 0xdb, 0xfd, 0x35, 0x10, 0x53, 0x2c, 0xfc, 0x3d, 0xf9, 0x71,
      0xbb, 0xbc, 0xa4, 0xa2, 0xbd, 0x52, 0xf9, 0x1a, 0xcc, 0x9c, 0x59, 0xd0,
      0xfe, 0x79, 0x34, 0x20, 0x97, 0xf8, 0x8a, 0xe7, 0x8f, 0xc7, 0x9a, 0x80,
      0x32, 0x24, 0x5f, 0xdd, 0x2c, 0x30, 0xcc, 0x64, 0xac, 0xea, 0xaa, 0x9f,
      0xd5, 0x7b, 0x08, 0x25, 0x69, 0x25, 0x31},
     {0x72, 0xc5, 0x7c, 0x2e, 0x10, 0xd7, 0x73, 0x18, 0xb3, 0xa7, 0x96,
      0x09, 0x7b, 0xbf, 0x76, 0x8c, 0x63, 0x66, 0x14, 0x2d, 0x80, 0xf9,
      0x8c, 0x90, 0xa9, 0x37, 0x80, 0xa8, 0x41, 0x07, 0x5f, 0x32},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 100
    {100,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x9c, 0x5d, 0x3b, 0xb5, 0x46, 0x50, 0xd9, 0x55, 0x0e,
      0x1e, 0xe2, 0xef, 0xa3, 0xea, 0x43, 0xc1, 0x4a, 0xb9, 0x9d, 0x18, 0xbb,
      0x04, 0x9f, 0x37, 0xb4, 0x2a, 0x6d, 0xac, 0x48, 0x23, 0x2f, 0x0b, 0xd3,
      0xa2, 0x76, 0x0d, 0x83, 0xd3, 0x3a, 0xfe, 0x4c, 0xe6, 0xf1, 0xd1, 0x24,
      0x54, 0x89, 0xc5, 0x09, 0xbd, 0x26, 0xb0, 0x25, 0x1f, 0x30, 0x8f, 0x8c,
      0x99, 0x6e, 0x80, 0xf7, 0xa3, 0xf8, 0xeb},
     {0xa9, 0x6b, 0x07, 0x94, 0x4e, 0x9e, 0xb2, 0xb2, 0x2a, 0x9a, 0x36,
      0x57, 0x5e, 0xff, 0x1f, 0x4f, 0x63, 0x63, 0xb4, 0xaa, 0x3a, 0x53,
      0xb1, 0x00, 0xb8, 0x51, 0x8a, 0x67, 0xba, 0x54, 0x05, 0xdd},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 101
    {101,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf1, 0x72, 0x4e, 0xfd, 0x48, 0x1a, 0xd4, 0x5a, 0x55,
      0x79, 0x5f, 0x06, 0x12, 0x6b, 0x1f, 0x5e, 0xd2, 0x8e, 0x7d, 0x9b, 0xb4,
      0xfe, 0xe9, 0x10, 0xaf, 0x2a, 0xd8, 0xc1, 0x37, 0x3b, 0x18, 0xff, 0x77,
      0xed, 0xbc, 0x34, 0xda, 0x6c, 0x78, 0x7e, 0xc7, 0x34, 0x30, 0x34, 0x7f,
      0x4d, 0xa8, 0x68, 0x10, 0x03, 0x2d, 0x88, 0xf7, 0x47, 0x5f, 0x6c, 0x42,
      0xf1, 0x59, 0x14, 0x07, 0x9d, 0x17, 0x9e},
     {0x85, 0x58, 0x83, 0x31, 0x6b, 0x6d, 0x09, 0x7a, 0xe5, 0xea, 0xb6,
      0xc6, 0x7e, 0x84, 0x11, 0xa1, 0x39, 0x73, 0x49, 0xa0, 0x9b, 0x9d,
      0x7d, 0x8f, 0x09, 0x6b, 0x2b, 0xa1, 0xbd, 0x03, 0xea, 0x31},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 102
    {102,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xfc, 0x36, 0x80, 0xaf, 0x52, 0xfa, 0x89, 0xff, 0xcd,
      0x19, 0x3e, 0xcc, 0x0b, 0x07, 0x14, 0x46, 0x6f, 0xe5, 0xdb, 0x27, 0x7e,
      0xe5, 0x87, 0x28, 0x46, 0xc5, 0x20, 0xbf, 0x4e, 0x37, 0x21, 0xd9, 0x27,
      0x26, 0x0a, 0x0e, 0x22, 0x5a, 0x3d, 0x37, 0x7e, 0x67, 0x23, 0xec, 0xb6,
      0xbe, 0xf8, 0xd4, 0x49, 0x3c, 0x2d, 0xa7, 0x8a, 0x22, 0xa3, 0x07, 0xfc,
      0xca, 0x8f, 0x88, 0xf4, 0x52, 0x72, 0x08},
     {0x5a, 0x75, 0xbb, 0x7a, 0x0c, 0x96, 0xb8, 0x34, 0x0d, 0x08, 0x42,
      0xbc, 0xcc, 0xf1, 0x19, 0x74, 0xe1, 0xa5, 0xa2, 0xc8, 0xf4, 0xbc,
      0x22, 0xb3, 0x33, 0x43, 0x3c, 0xce, 0x64, 0x6b, 0x6a, 0x8a},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 103
    {103,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x10, 0x6b, 0x6f, 0x81, 0xe3, 0x48, 0x2d, 0xb1, 0x8d,
      0x74, 0x02, 0x92, 0x91, 0x82, 0x1a, 0xe4, 0x48, 0xc3, 0x88, 0x44, 0xef,
      0x78, 0x3b, 0xf1, 0xd6, 0x99, 0x9a, 0x40, 0x44, 0x01, 0xf6, 0x3f, 0x6a,
      0x57, 0x53, 0xf0, 0xed, 0xc6, 0x8a, 0x62, 0xcf, 0xd6, 0xa0, 0xb1, 0x81,
      0xbb, 0x25, 0x99, 0xe1, 0xf3, 0xba, 0xc5, 0xfa, 0x88, 0x24, 0xaf, 0x16,
      0x0d, 0xe7, 0x9e, 0xd8, 0x67, 0xc3, 0x50},
     {0xd9, 0x64, 0x12, 0xe3, 0x1c, 0xf4, 0xd2, 0x61, 0x95, 0x92, 0x0c,
      0xac, 0x95, 0x2f, 0xb7, 0x9e, 0xa2, 0x5f, 0x6c, 0x50, 0xab, 0xc7,
      0x9b, 0x5e, 0xd0, 0xef, 0x80, 0x26, 0xa6, 0xe8, 0x33, 0x19},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 104
    {104,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x09, 0x3c, 0xb5, 0x19, 0x3a, 0x4f, 0x94, 0xcd, 0x18,
      0xed, 0xaa, 0x20, 0xa9, 0x73, 0xb8, 0x7f, 0xf7, 0x9b, 0x0c, 0x03, 0x68,
      0x4c, 0x79, 0x48, 0x7e, 0xcf, 0xee, 0x34, 0x7e, 0x53, 0x54, 0xeb, 0x04,
      0xfc, 0xb5, 0x75, 0x25, 0x39, 0x17, 0x07, 0x77, 0x93, 0x2b, 0xe1, 0x5c,
      0xd8, 0x4c, 0x97, 0xf0, 0x38, 0x15, 0xff, 0xee, 0x8b, 0x60, 0xb6, 0x47,
      0xc1, 0x78, 0xee, 0xbb, 0x8e, 0x14, 0xd4},
     {0x2b, 0x0e, 0xed, 0x9b, 0xad, 0xc9, 0x2a, 0x10, 0x68, 0x19, 0x6d,
      0xfe, 0xc1, 0x24, 0xfe, 0x8f, 0x9d, 0x3f, 0x45, 0x1e, 0x29, 0x4d,
      0x32, 0x2e, 0xb8, 0x81, 0xcc, 0xe0, 0x2f, 0x28, 0x60, 0x26},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 105
    {105,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd6, 0xc3, 0x8f, 0x44, 0x8b, 0x96, 0x4e, 0x27, 0xb5,
      0xb4, 0x50, 0xcc, 0x38, 0xd3, 0xcf, 0x41, 0xef, 0x9d, 0xf8, 0x3d, 0x8a,
      0x95, 0x97, 0x71, 0xeb, 0x9c, 0x21, 0x85, 0x5c, 0xb3, 0x64, 0x45, 0xdf,
      0x63, 0x8a, 0xef, 0x46, 0xa2, 0xae, 0xb1, 0x31, 0x99, 0x28, 0x1e, 0x1a,
      0x26, 0xd1, 0x2f, 0xe6, 0x1b, 0x02, 0x9e, 0xc7, 0xf6, 0x8b, 0x90, 0xfa,
      0xa8, 0x9f, 0x88, 0xc7, 0xa9, 0x59, 0x42},
     {0xed, 0x0b, 0x1d, 0x8d, 0xfd, 0x27, 0xa6, 0x1f, 0xce, 0x91, 0xdc,
      0x64, 0x05, 0xbf, 0xc5, 0x3b, 0x6d, 0x48, 0xa8, 0xc1, 0x3b, 0xa5,
      0x41, 0xc9, 0x6e, 0xf3, 0xdc, 0xf3, 0x1d, 0x7c, 0xdb, 0x88},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 106
    {106,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8a, 0x74, 0x8d, 0x61, 0xf5, 0x9c, 0x3b, 0x6a, 0x29,
      0xb7, 0x33, 0xb0, 0xd5, 0x54, 0xb2, 0x49, 0x2e, 0x7f, 0x76, 0xfa, 0xd7,
      0xca, 0xe1, 0xc1, 0x7f, 0x2a, 0xc3, 0xde, 0x9e, 0x4a, 0x65, 0xd2, 0xee,
      0xdb, 0xe6, 0xc2, 0x6b, 0x6f, 0xd2, 0x2b, 0xfc, 0x03, 0xc1, 0x68, 0x75,
      0x55, 0xd2, 0xf0, 0xa3, 0x8e, 0x02, 0xad, 0xee, 0x55, 0x70, 0x68, 0x61,
      0x71, 0xab, 0xfe, 0xc6, 0x68, 0x19, 0x17},
     {0xa7, 0x96, 0xdd, 0x14, 0x4f, 0x21, 0xba, 0x33, 0x18, 0xf9, 0xe1,
      0x08, 0x28, 0xec, 0xef, 0xc9, 0xc0, 0xf6, 0xef, 0x2c, 0x42, 0x7a,
      0xe3, 0x13, 0x51, 0xc1, 0x6c, 0x2f, 0xbf, 0xa3, 0xcf, 0xa6},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 107
    {107,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf1, 0x05, 0x26, 0x99, 0xd8, 0x7e, 0x56, 0x77, 0xc7,
      0x5e, 0x26, 0xb2, 0xab, 0xe7, 0x19, 0x31, 0x06, 0x48, 0xd8, 0x20, 0xa9,
      0x6e, 0x5b, 0x38, 0x1f, 0xff, 0x58, 0xb3, 0x92, 0x40, 0x15, 0x81, 0xb1,
      0xbb, 0x16, 0xae, 0x8b, 0x68, 0xcb, 0xb7, 0x6a, 0x32, 0x56, 0x87, 0x0b,
      0xad, 0x1e, 0xe5, 0xa3, 0x0f, 0xf9, 0xfd, 0x66, 0x2f, 0xd4, 0xf8, 0xd1,
      0xfe, 0x5b, 0x5f, 0x1f, 0x98, 0xff, 0x46},
     {0x1f, 0x3a, 0x96, 0x15, 0xb0, 0x74, 0x50, 0x46, 0xa9, 0x72, 0xba,
      0xd5, 0xd5, 0x97, 0x94, 0xa0, 0xb6, 0x0b, 0x03, 0x2b, 0x4a, 0xc9,
      0x4f, 0xe8, 0x5f, 0x77, 0xdf, 0xb3, 0x80, 0xd1, 0xf3, 0x2b},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 108
    {108,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x12, 0x19, 0xaf, 0x52, 0x30, 0x06, 0x4e, 0xe9, 0x77,
      0x86, 0x67, 0x22, 0x5f, 0x0e, 0x00, 0x9c, 0xdb, 0x96, 0x13, 0x30, 0xe3,
      0x86, 0xed, 0xb3, 0x4e, 0x4f, 0xa9, 0xfd, 0xdd, 0x0e, 0x5b, 0xe7, 0xe2,
      0xa1, 0x25, 0x54, 0x22, 0x7f, 0x61, 0x3a, 0xaa, 0xa7, 0x89, 0x38, 0xdd,
      0xbb, 0xc9, 0x9b, 0x92, 0x3f, 0x9d, 0x18, 0x1b, 0x81, 0x92, 0xdc, 0x4b,
      0x81, 0x65, 0x77, 0xe8, 0xf3, 0xb7, 0xe9},
     {0xca, 0xf9, 0x14, 0x1d, 0x1f, 0xca, 0x4d, 0x0f, 0x10, 0x68, 0x3b,
      0x5e, 0x86, 0xd2, 0xb4, 0x1a, 0xf5, 0x60, 0x2f, 0x01, 0x79, 0x91,
      0xfe, 0x73, 0x48, 0xd4, 0x4e, 0x8d, 0x70, 0x14, 0x11, 0x5c},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 109
    {109,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x60, 0xde, 0xf1, 0x30, 0xf1, 0x90, 0xe6, 0xdc, 0x44,
      0xf5, 0xeb, 0x8a, 0x59, 0xe1, 0x2e, 0x7e, 0xfb, 0x27, 0xdb, 0x96, 0x8c,
      0x7f, 0xa6, 0xcc, 0x6d, 0x31, 0x78, 0x5f, 0x06, 0x6b, 0x41, 0xb1, 0xf1,
      0xbb, 0x55, 0x6a, 0xc4, 0xcd, 0x77, 0x03, 0x3e, 0x7a, 0xa6, 0xc5, 0xba,
      0x16, 0xf4, 0x7e, 0xba, 0xfb, 0x14, 0x97, 0x5a, 0x7f, 0xd7, 0x2d, 0xd9,
      0xb7, 0xfe, 0x23, 0x11, 0x6b, 0xca, 0x55},
     {0x65, 0x39, 0xec, 0x1c, 0x98, 0xfa, 0x75, 0x19, 0x7b, 0xa0, 0x7c,
      0x67, 0x8b, 0x26, 0x30, 0x0b, 0x3d, 0xa1, 0xfe, 0x40, 0x7d, 0xd4,
      0xc6, 0x8b, 0x89, 0x45, 0x7e, 0xd6, 0x69, 0x08, 0x2e, 0x06},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 110
    {110,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf2, 0x3f, 0x09, 0xbd, 0xb7, 0xd1, 0x72, 0x89, 0xeb,
      0x00, 0x59, 0x75, 0xa7, 0x57, 0xa3, 0x93, 0x25, 0xb4, 0xdf, 0x9b, 0x29,
      0xe5, 0x5b, 0xa2, 0xca, 0x67, 0x9b, 0x5e, 0xc0, 0x97, 0x3a, 0xe9, 0x18,
      0xc8, 0x81, 0xf3, 0xc7, 0xb6, 0xc1, 0x2b, 0xed, 0x1e, 0xc5, 0x4b, 0x83,
      0x7d, 0x08, 0xc5, 0x90, 0x8e, 0x89, 0xbd, 0xce, 0xdd, 0x84, 0xb9, 0x17,
      0x77, 0x20, 0x37, 0x8f, 0x78, 0x96, 0x00},
     {0x0b, 0x66, 0x19, 0x82, 0x7c, 0xfa, 0x94, 0x8d, 0x63, 0xf0, 0x21,
      0xe9, 0xed, 0xdb, 0x92, 0xf8, 0x84, 0xfb, 0x5c, 0xe8, 0xa4, 0x04,
      0xbf, 0xe0, 0x59, 0xe9, 0x93, 0xfc, 0x23, 0x44, 0x7a, 0x69},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 111
    {111,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5d, 0xbe, 0xc0, 0x98, 0xc1, 0xb7, 0xde, 0x3e, 0x3e,
      0x2e, 0x73, 0xd0, 0xb6, 0x2c, 0xd4, 0x9c, 0x87, 0x7e, 0x1a, 0x01, 0x30,
      0xa1, 0xb3, 0x9e, 0xb2, 0xfd, 0x4d, 0xbd, 0x44, 0x26, 0xaa, 0x4c, 0xcb,
      0xee, 0xe2, 0x17, 0x59, 0x1a, 0x8d, 0x76, 0xcc, 0x8d, 0xea, 0xf1, 0x4d,
      0xde, 0x52, 0xe3, 0xf4, 0x01, 0xe5, 0x3b, 0x30, 0xcb, 0xb9, 0xc1, 0x80,
      0x79, 0x10, 0xd8, 0x27, 0xd0, 0x04, 0x1d},
     {0x2a, 0x53, 0xa5, 0x61, 0xac, 0xf5, 0xca, 0xec, 0x6e, 0xb0, 0xd8,
      0xaa, 0x40, 0x72, 0x79, 0x42, 0x88, 0x1a, 0x75, 0xd1, 0x36, 0x89,
      0x9d, 0xfb, 0xff, 0x91, 0x52, 0x82, 0x36, 0x92, 0x6c, 0x39},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 112
    {112,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x1e, 0x70, 0x73, 0x0d, 0xc4, 0xf3, 0x9c, 0x89, 0x70,
      0x18, 0x2e, 0x1a, 0x29, 0xcc, 0x83, 0x6b, 0x9e, 0x9d, 0x6c, 0xbd, 0x6f,
      0xca, 0xa8, 0xc0, 0xdc, 0x10, 0x62, 0xfe, 0xd9, 0xa8, 0x49, 0x69, 0x3e,
      0x7b, 0x91, 0x51, 0xf9, 0xc8, 0xa3, 0x34, 0x53, 0x66, 0xf8, 0x22, 0x1c,
      0x8f, 0xb7, 0x00, 0xe8, 0xc3, 0xa9, 0xaa, 0x7f, 0x0c, 0xc4, 0x6a, 0x48,
      0x86, 0x4e, 0x16, 0x05, 0x59, 0x20, 0x94},
     {0x9b, 0x37, 0x77, 0x16, 0xff, 0x1d, 0x05, 0x6d, 0xac, 0x8e, 0x39,
      0x22, 0x49, 0xea, 0xec, 0x74, 0x0d, 0x2f, 0x5a, 0xa6, 0x23, 0x03,
      0xf4, 0xba, 0xf6, 0xbb, 0x1b, 0x03, 0xb2, 0xa2, 0x76, 0xc5},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 113
    {113,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf4, 0x28, 0xc9, 0xae, 0x3e, 0x23, 0xea, 0xf9, 0xc2,
      0xa5, 0xb9, 0xa7, 0xe4, 0x1e, 0xfd, 0x1c, 0xff, 0xbf, 0x35, 0xf8, 0x81,
      0xbf, 0xc3, 0x56, 0x94, 0xd9, 0xc0, 0x5d, 0x1e, 0x31, 0x2b, 0x10, 0xef,
      0x6d, 0xa9, 0x02, 0x3c, 0xfd, 0x2d, 0xd0, 0xcb, 0x7b, 0x9e, 0x2a, 0x77,
      0xd6, 0x44, 0xaf, 0xfe, 0x62, 0xa6, 0x3f, 0xb0, 0xf2, 0x9d, 0x45, 0x29,
      0x1c, 0x68, 0x61, 0xaa, 0x06, 0x3c, 0x5c},
     {0x0c, 0x0c, 0x68, 0x67, 0x66, 0x97, 0x43, 0x08, 0x25, 0x47, 0xaa,
      0x94, 0x45, 0x1f, 0xeb, 0x36, 0x2f, 0xa2, 0x9f, 0xba, 0xf2, 0x28,
      0xdf, 0xb3, 0xea, 0xf3, 0x75, 0xf1, 0xa5, 0xec, 0x2f, 0xb3},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 114
    {114,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xb9, 0xa1, 0x6d, 0x9a, 0x5b, 0x85, 0xa7, 0x14, 0xe2,
      0xbb, 0x2a, 0xa2, 0x2b, 0x08, 0x6a, 0x17, 0x40, 0x4c, 0x7a, 0x3f, 0xf6,
      0x24, 0x52, 0x73, 0x23, 0x47, 0x41, 0x9c, 0x99, 0xe9, 0x0b, 0xda, 0xd5,
      0x78, 0xb4, 0x62, 0xf5, 0x23, 0x99, 0x43, 0x04, 0xb6, 0xaf, 0xcf, 0x69,
      0x44, 0xa9, 0xcc, 0x5d, 0x0a, 0xd1, 0xaf, 0xad, 0x95, 0x64, 0x75, 0xc8,
      0xf2, 0x95, 0x3c, 0x06, 0xb0, 0x6b, 0x97},
     {0xd1, 0x1f, 0x9e, 0x32, 0x58, 0x7f, 0xd3, 0xb6, 0xf4, 0xa2, 0x35,
      0x48, 0x12, 0x61, 0x8b, 0x4b, 0x3b, 0x4a, 0x75, 0x39, 0xb8, 0xa2,
      0x23, 0xb3, 0x88, 0xbb, 0x74, 0x37, 0xf8, 0xd1, 0x38, 0xa5},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 115
    {115,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8f, 0x65, 0x9a, 0x16, 0x3a, 0x58, 0xe9, 0xf9, 0x00,
      0xc1, 0xe9, 0xb3, 0x4f, 0xb1, 0xcd, 0x61, 0xff, 0xc9, 0x89, 0x02, 0x67,
      0xbe, 0x34, 0x17, 0xc8, 0xaf, 0xe7, 0x9d, 0x57, 0x21, 0x4d, 0xa0, 0x5c,
      0xd5, 0xcb, 0x68, 0xa2, 0xb9, 0x3d, 0xa0, 0xdb, 0xe5, 0x6c, 0x1c, 0xfc,
      0x0d, 0xce, 0x8b, 0x6c, 0x32, 0x60, 0xe0, 0xc4, 0x83, 0x79, 0xc6, 0xd2,
      0x09, 0x1f, 0x16, 0xb3, 0x92, 0x21, 0xc0},
     {0x4b, 0xab, 0xf6, 0x36, 0x8e, 0x03, 0x59, 0xb7, 0x86, 0x14, 0x06,
      0x02, 0x41, 0xec, 0xe4, 0x6f, 0xac, 0xca, 0x3f, 0x52, 0xf5, 0xbb,
      0xc4, 0x7a, 0xc0, 0xb4, 0x6a, 0x07, 0x5b, 0x5d, 0xd3, 0xa0},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 116
    {116,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd2, 0x57, 0xf1, 0x33, 0xf0, 0x0a, 0x07, 0x9f, 0x4e,
      0x67, 0x78, 0xea, 0x4a, 0x9b, 0xf4, 0x2b, 0x9f, 0x23, 0x12, 0x90, 0x43,
      0x1b, 0x5b, 0x93, 0xd7, 0xe8, 0xb0, 0xe3, 0x5b, 0x48, 0x01, 0x06, 0x50,
      0xd6, 0xc6, 0xb4, 0x65, 0x74, 0xd1, 0xef, 0xce, 0x03, 0x51, 0x0b, 0x8d,
      0xb4, 0xa0, 0x98, 0x1c, 0xe1, 0x38, 0xc5, 0xbd, 0x8f, 0xe0, 0xe5, 0x4c,
      0x98, 0x8c, 0x40, 0xc5, 0xfc, 0x92, 0x00},
     {0x96, 0x27, 0xcc, 0x5c, 0x8d, 0x8b, 0x72, 0x27, 0x8b, 0xe8, 0x9c,
      0x32, 0xb5, 0x22, 0x10, 0x17, 0x3e, 0x6f, 0x4b, 0x8e, 0x2f, 0x48,
      0xe4, 0x60, 0xc6, 0x42, 0x9f, 0x46, 0xf9, 0xf4, 0x69, 0xae},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 117
    {117,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5e, 0xf2, 0xac, 0x57, 0xc4, 0xe9, 0x3c, 0xf7, 0x8d,
      0x8f, 0x86, 0xc3, 0x5d, 0x41, 0x3b, 0x98, 0xdc, 0x19, 0x02, 0xdd, 0x24,
      0x5a, 0xff, 0xde, 0x5c, 0x16, 0x03, 0x4a, 0xfc, 0x7e, 0xa4, 0x55, 0x47,
      0xb3, 0xe9, 0xf7, 0x7f, 0xbc, 0x50, 0x75, 0xba, 0xd0, 0x3c, 0x41, 0x80,
      0x94, 0xf1, 0xae, 0xc1, 0xd0, 0x3e, 0xde, 0xaf, 0xa1, 0x67, 0xfa, 0x6a,
      0xf8, 0x35, 0x26, 0x55, 0x2f, 0x70, 0x34},
     {0xd2, 0xb1, 0x78, 0xbc, 0x9b, 0xb1, 0x6b, 0x5a, 0x91, 0xa1, 0x00,
      0xbb, 0x72, 0xe1, 0x5a, 0x96, 0x39, 0xe0, 0x50, 0xc0, 0x34, 0x34,
      0x60, 0x61, 0x41, 0x3e, 0xc2, 0x0c, 0x4f, 0xcc, 0x9b, 0xbc},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 118
    {118,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xa7, 0xb5, 0x13, 0xf9, 0x62, 0x66, 0x41, 0x4f, 0xa6,
      0xff, 0x43, 0x9a, 0x35, 0xd8, 0xf0, 0x9a, 0xb6, 0x15, 0xdb, 0x0b, 0xb6,
      0xa3, 0xb1, 0xa1, 0x20, 0xc2, 0x17, 0x68, 0x3f, 0x72, 0x4b, 0x23, 0x42,
      0x00, 0x7a, 0x2c, 0x9f, 0xea, 0xbc, 0xd6, 0x24, 0x9a, 0x0d, 0x17, 0xac,
      0xec, 0xd9, 0x95, 0xe2, 0xa2, 0x17, 0xfb, 0x5f, 0x07, 0xbe, 0xc9, 0x69,
      0x38, 0x01, 0x6e, 0x29, 0x7e, 0xfa, 0x52},
     {0x6c, 0xdc, 0xa0, 0xa7, 0x31, 0xaf, 0xf1, 0xcc, 0xfb, 0x19, 0x04,
      0xa7, 0x69, 0xce, 0xf7, 0x9e, 0xba, 0x96, 0x5f, 0xba, 0xb1, 0xcc,
      0x64, 0xd2, 0x04, 0x9d, 0x0d, 0xf4, 0x5d, 0xcc, 0xd2, 0x76},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 119
    {119,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x77, 0x43, 0xab, 0x72, 0x48, 0xda, 0xe5, 0xf1, 0xa5,
      0x9a, 0xc6, 0xb0, 0xa1, 0x36, 0xe9, 0xf1, 0xe5, 0x1a, 0xff, 0x8b, 0xd4,
      0x57, 0x95, 0xac, 0xe5, 0xf8, 0x18, 0x7a, 0x13, 0xed, 0xf9, 0xad, 0xbd,
      0x96, 0x42, 0x07, 0x83, 0x78, 0xba, 0xb5, 0xc6, 0xd4, 0x84, 0xf9, 0xe1,
      0xce, 0x39, 0x67, 0x5b, 0x72, 0x17, 0x0b, 0xf3, 0x9a, 0xbc, 0x9b, 0xe7,
      0x94, 0x2f, 0xc0, 0x1f, 0xc4, 0x35, 0xd7},
     {0xbd, 0x15, 0xe9, 0x7a, 0x7f, 0x49, 0xaa, 0x33, 0xe5, 0x7b, 0x54,
      0x14, 0x0a, 0x75, 0xff, 0xfc, 0xe7, 0x1b, 0x78, 0x8c, 0xe0, 0xfa,
      0xa3, 0x34, 0xcf, 0x8b, 0x45, 0x62, 0x3d, 0xcc, 0x81, 0x8a},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 120
    {120,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0e, 0x3a, 0xa9, 0x71, 0xba, 0xcd, 0xac, 0xe3, 0x50,
      0xdc, 0x09, 0x57, 0xfa, 0x5b, 0xde, 0x09, 0x46, 0x32, 0x4e, 0xb1, 0x39,
      0x93, 0x9d, 0x7f, 0xc1, 0x99, 0x7c, 0x70, 0x1e, 0xff, 0xd0, 0x4a, 0x4e,
      0x6c, 0x36, 0x25, 0xd9, 0x56, 0x41, 0x68, 0xd3, 0xa7, 0x52, 0x96, 0x12,
      0x21, 0xa1, 0xde, 0x8c, 0xf5, 0xf3, 0xd6, 0x03, 0x75, 0x2a, 0x8c, 0x2e,
      0x62, 0x77, 0xac, 0x3a, 0x91, 0x8c, 0x25},
     {0xc8, 0xb5, 0xe8, 0xe7, 0x48, 0x88, 0x57, 0xa2, 0xdd, 0xe6, 0x2c,
      0x5f, 0xc2, 0x1e, 0x45, 0x25, 0xeb, 0xab, 0xa0, 0xe0, 0x6b, 0x5b,
      0xe8, 0x3e, 0xc6, 0xe7, 0xdd, 0x77, 0x1e, 0x15, 0xa0, 0x1a},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 121
    {121,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0f, 0x56, 0x3e, 0x21, 0xbf, 0x9b, 0x24, 0x01, 0x5a,
      0x7c, 0xdb, 0xb6, 0xf0, 0x00, 0xa6, 0x92, 0x78, 0x4a, 0xc2, 0xe4, 0xbc,
      0x27, 0x15, 0xc7, 0x6f, 0x68, 0x42, 0x64, 0xa8, 0x99, 0xc8, 0x24, 0x0c,
      0xab, 0x0d, 0x76, 0xe6, 0xb0, 0x1c, 0xab, 0xe4, 0xf3, 0x27, 0x42, 0x9d,
      0x11, 0xbe, 0x11, 0x5e, 0xd6, 0xdc, 0x0c, 0xa7, 0x4f, 0x02, 0xc1, 0xb9,
      0x87, 0xa0, 0x82, 0xf5, 0xaf, 0x43, 0xa8},
     {0x1c, 0x63, 0xa4, 0x57, 0x50, 0x9b, 0x14, 0x82, 0x72, 0x68, 0x7e,
      0x6e, 0x44, 0x2b, 0xde, 0x51, 0x98, 0x2d, 0x41, 0xb0, 0x08, 0x0d,
      0x8c, 0x0c, 0x5e, 0xb7, 0x14, 0x25, 0x7a, 0xf9, 0x71, 0xe7},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 122
    {122,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5d, 0xa4, 0x9f, 0x10, 0x24, 0x9e, 0x4d, 0xf3, 0xdb,
      0xb4, 0xe3, 0x1e, 0xce, 0x0b, 0x0e, 0xe9, 0xaa, 0x07, 0x3f, 0x25, 0x88,
      0x19, 0x5a, 0xaa, 0xe6, 0x3e, 0x74, 0xf6, 0x56, 0x7a, 0x77, 0x48, 0x10,
      0xb5, 0xdd, 0x61, 0xb6, 0xbf, 0x21, 0x9e, 0x9e, 0xab, 0x30, 0xef, 0x09,
      0xc1, 0x3f, 0xc1, 0x84, 0xb3, 0xd0, 0x9f, 0xf7, 0xa4, 0xe1, 0x92, 0xbc,
      0xa8, 0xf5, 0x11, 0x1c, 0x41, 0x63, 0xc7},
     {0x73, 0xa1, 0xac, 0x9e, 0xce, 0x35, 0x4a, 0x93, 0x0d, 0xfd, 0x9c,
      0x77, 0x57, 0x7b, 0x4f, 0x50, 0xac, 0xc0, 0xa7, 0x89, 0x64, 0xea,
      0x0d, 0x77, 0x75, 0x63, 0x1d, 0x64, 0xc7, 0x09, 0xc4, 0xa2},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 123
    {123,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x6f, 0x72, 0xe6, 0xe5, 0xc6, 0x30, 0x06, 0x79, 0xd3,
      0xf1, 0x4f, 0x0f, 0x6e, 0x59, 0x06, 0x65, 0x64, 0x35, 0x76, 0xae, 0x8b,
      0xbc, 0xb7, 0xc0, 0x5b, 0x2f, 0x4a, 0x83, 0xe7, 0x5e, 0x6a, 0xc3, 0xe7,
      0x12, 0xcb, 0x05, 0x6f, 0xf0, 0x34, 0xda, 0x34, 0x05, 0x43, 0xc5, 0xda,
      0x69, 0x97, 0xe6, 0x5a, 0x3a, 0xb4, 0xcd, 0x39, 0xe9, 0x97, 0x89, 0x2b,
      0xb9, 0x2e, 0xe2, 0xc2, 0x2b, 0x81, 0x67},
     {0xfc, 0xaa, 0x40, 0x63, 0x29, 0xbb, 0x74, 0xf9, 0x95, 0x86, 0x2c,
      0xea, 0x7c, 0xec, 0xc7, 0x42, 0x5c, 0x6b, 0xd4, 0x14, 0x8e, 0xf1,
      0xa9, 0xf4, 0x6b, 0x5d, 0x42, 0xda, 0x59, 0x94, 0x55, 0x6a},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 124
    {124,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x6b, 0x54, 0x4d, 0xf9, 0x16, 0x8e, 0x77, 0x87, 0xdb,
      0x28, 0x2e, 0x2a, 0xe0, 0x1d, 0xd7, 0x23, 0x06, 0xd9, 0xc9, 0xbc, 0x80,
      0xf5, 0xab, 0x38, 0xce, 0x59, 0x47, 0x66, 0xc3, 0xd9, 0x29, 0xe9, 0x67,
      0x49, 0x3f, 0xf6, 0x01, 0xca, 0x60, 0x86, 0x2b, 0x47, 0xd3, 0xa0, 0x78,
      0x5c, 0x91, 0x7e, 0x44, 0x58, 0x40, 0x44, 0xe3, 0x60, 0x23, 0xa5, 0x44,
      0x24, 0x01, 0x5e, 0x58, 0xbe, 0x50, 0x40},
     {0xe4, 0x9f, 0xf1, 0x1d, 0x46, 0xb6, 0xc4, 0xb5, 0xdd, 0xe5, 0x28,
      0xb0, 0x41, 0x32, 0xd1, 0x5c, 0x04, 0x0e, 0x79, 0xf9, 0xb7, 0x15,
      0x1f, 0xbc, 0x65, 0x00, 0x30, 0x98, 0x80, 0x28, 0xcb, 0x87},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 125
    {125,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x1c, 0x31, 0x38, 0x5b, 0x9d, 0xb9, 0xb3, 0x74, 0xe9,
      0x24, 0x99, 0x93, 0x9a, 0xb0, 0xfd, 0x7e, 0x7e, 0xda, 0x46, 0x45, 0x61,
      0xeb, 0xa8, 0x9f, 0xcd, 0x7b, 0x47, 0x69, 0x81, 0x4a, 0x86, 0x38, 0xa4,
      0x76, 0x4c, 0xf8, 0xce, 0x97, 0xb5, 0xd1, 0x43, 0xbb, 0x8e, 0xeb, 0x9e,
      0x1b, 0x27, 0x28, 0x7f, 0x2b, 0x73, 0x94, 0x2e, 0xcd, 0xbc, 0x63, 0x59,
      0xaa, 0xfb, 0x1e, 0xe7, 0xa1, 0x52, 0xc2},
     {0xfc, 0x8f, 0x64, 0xea, 0xc1, 0xc7, 0xe6, 0x88, 0xc5, 0x2c, 0x46,
      0x71, 0x85, 0xde, 0x21, 0x91, 0x4e, 0x8b, 0x25, 0x30, 0x56, 0xd9,
      0xe4, 0xbe, 0x01, 0x0e, 0xd0, 0x12, 0x8f, 0x92, 0xa8, 0x89},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 126
    {126,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xaa, 0xbc, 0xf8, 0xb1, 0x44, 0x3d, 0x6c, 0xbb, 0x1d,
      0xe1, 0x29, 0xa0, 0xff, 0xe0, 0x9f, 0x60, 0xb2, 0x3f, 0xd9, 0xd0, 0xa4,
      0x4b, 0x6b, 0xdf, 0x25, 0xbe, 0xd7, 0x37, 0x3f, 0xdb, 0xfd, 0x1d, 0xb7,
      0x16, 0xbd, 0xe7, 0xfe, 0x9f, 0x2f, 0x46, 0xde, 0x0b, 0x68, 0x8e, 0x30,
      0x25, 0xe0, 0x29, 0xcf, 0xf1, 0x52, 0x44, 0x42, 0x9a, 0xd4, 0xf8, 0x34,
      0x84, 0xf5, 0xde, 0xa4, 0xaf, 0x85, 0x83},
     {0x6b, 0x56, 0xd8, 0xa0, 0x1a, 0x88, 0x43, 0x19, 0xab, 0x5f, 0xb9,
      0xd8, 0x90, 0xca, 0xcf, 0xc7, 0xaa, 0xbd, 0x81, 0xad, 0x93, 0x8c,
      0xb5, 0xea, 0xae, 0x20, 0x7c, 0x8c, 0x1a, 0xa0, 0x6e, 0xfb},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 127
    {127,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xe7, 0xcd, 0x58, 0x0b, 0xd9, 0x57, 0x91, 0x5d, 0x52,
      0x70, 0x56, 0x83, 0x2e, 0x37, 0x79, 0x3a, 0xb3, 0xb0, 0x82, 0xdd, 0xfa,
      0xd9, 0x37, 0x24, 0x12, 0xe1, 0x90, 0x8e, 0x5c, 0x16, 0xbb, 0xb6, 0x20,
      0x86, 0x01, 0xa9, 0x70, 0xd5, 0x84, 0x4b, 0x78, 0x0d, 0x92, 0x46, 0xe9,
      0x58, 0x3e, 0xb3, 0x59, 0x18, 0xc4, 0x2e, 0xd6, 0x95, 0xc0, 0x7d, 0x52,
      0x24, 0x40, 0x37, 0xf0, 0xe3, 0x1d, 0xb5},
     {0x2f, 0x64, 0xb5, 0xc8, 0x04, 0x6d, 0x41, 0xa4, 0xe1, 0xd6, 0x31,
      0xff, 0x23, 0x84, 0x6b, 0xff, 0x95, 0x6a, 0x49, 0x25, 0xa4, 0x7f,
      0x85, 0x34, 0x49, 0x0a, 0x20, 0xb4, 0xb1, 0x91, 0x8b, 0x9c},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 128
    {128,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x2a, 0x52, 0xdb, 0x1f, 0xe2, 0x46, 0xb7, 0x1c, 0x79,
      0xc0, 0xd0, 0xac, 0x49, 0xa7, 0xd3, 0x8d, 0xe6, 0x7b, 0x20, 0x29, 0x95,
      0xef, 0xbb, 0xd2, 0xa9, 0xcc, 0x52, 0x5f, 0x6f, 0x36, 0x01, 0x03, 0x68,
      0xf4, 0x94, 0xbe, 0x27, 0xe0, 0x59, 0x3e, 0x2d, 0x61, 0x2f, 0x1f, 0xa1,
      0x0a, 0x92, 0x11, 0x43, 0x7e, 0x6a, 0xa1, 0x6e, 0x65, 0xd9, 0x77, 0x35,
      0x01, 0x40, 0x72, 0xf0, 0xdc, 0xec, 0x94},
     {0x63, 0xac, 0x31, 0xe7, 0x18, 0xb9, 0xa7, 0x80, 0xa8, 0x5f, 0x06,
      0x70, 0xe1, 0xd3, 0x68, 0x5b, 0xbe, 0x30, 0x6e, 0x5f, 0x06, 0xfe,
      0xe2, 0x82, 0xa8, 0x78, 0x47, 0x00, 0xb5, 0x03, 0xc1, 0x24},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 129
    {129,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x1c, 0x50, 0xdc, 0x49, 0xfe, 0xf7, 0x08, 0xc4, 0xcd,
      0xd6, 0x2e, 0x76, 0x6f, 0x9b, 0x60, 0xf7, 0x84, 0xd5, 0x1a, 0xfe, 0xe1,
      0x7a, 0x8f, 0xe9, 0xf3, 0x70, 0x1b, 0x2f, 0xae, 0x55, 0xb7, 0xa5, 0xd1,
      0x0f, 0x0d, 0x96, 0x39, 0xd8, 0x3d, 0xce, 0x8f, 0x26, 0xa8, 0x69, 0x70,
      0x5a, 0x6d, 0x6d, 0x38, 0xe6, 0xd3, 0x28, 0xf5, 0x68, 0x55, 0x81, 0x14,
      0x2a, 0xec, 0x0d, 0xcd, 0x1f, 0x90, 0xe7},
     {0x55, 0x5c, 0x19, 0x17, 0xb7, 0x70, 0xce, 0xbe, 0x6a, 0x98, 0x33,
      0x7a, 0x00, 0x8a, 0xe3, 0xd8, 0xd0, 0x4f, 0x57, 0x15, 0x65, 0x32,
      0x7c, 0x93, 0xde, 0xbf, 0x61, 0xef, 0x90, 0xdd, 0xdd, 0xd8},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 130
    {130,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x6d, 0x0a, 0xa1, 0xbc, 0x1c, 0xee, 0x6d, 0x07, 0xd0,
      0x45, 0x00, 0x2c, 0x13, 0x29, 0x0d, 0x0c, 0xa2, 0x5c, 0xa3, 0xc8, 0x78,
      0x33, 0x43, 0xa5, 0x25, 0xfa, 0xc7, 0x04, 0x72, 0xb9, 0x2c, 0x62, 0xd6,
      0xfb, 0xa7, 0x11, 0x74, 0x44, 0x8b, 0x47, 0x2c, 0xf1, 0x72, 0xb0, 0xca,
      0x9e, 0x37, 0x7f, 0x1a, 0x26, 0x03, 0xba, 0x7a, 0xe1, 0x27, 0x6d, 0x15,
      0x3b, 0x20, 0xc6, 0x3e, 0x7d, 0x24, 0xbf},
     {0x3a, 0x65, 0xa9, 0x20, 0x0f, 0x8f, 0x96, 0x63, 0x59, 0x12, 0xfa,
      0xa5, 0xe7, 0x85, 0x9f, 0xa3, 0x03, 0xa7, 0x6a, 0x1c, 0x2a, 0x41,
      0xea, 0x97, 0xef, 0x61, 0xaa, 0x39, 0x28, 0x77, 0x00, 0xa9},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 131
    {131,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf0, 0x7e, 0x3d, 0x8b, 0xe2, 0xba, 0x54, 0xc6, 0x08,
      0x41, 0x41, 0xe1, 0xfd, 0x2b, 0x29, 0xcf, 0xd0, 0x0d, 0x4e, 0x6d, 0xd6,
      0xff, 0xb1, 0x15, 0xed, 0x83, 0x9b, 0x10, 0xbd, 0x8a, 0x42, 0x2f, 0x42,
      0x99, 0x2c, 0xb9, 0xa5, 0x24, 0x38, 0x97, 0xd5, 0x54, 0x08, 0xe9, 0xbb,
      0x55, 0x60, 0x43, 0x31, 0x8d, 0x87, 0x34, 0x9a, 0xf3, 0x5d, 0xcc, 0x09,
      0x75, 0xed, 0x80, 0x5c, 0x8f, 0xa2, 0xc9},
     {0xbb, 0x7b, 0xb5, 0x2d, 0xa5, 0x70, 0xba, 0x58, 0xe0, 0x5f, 0xd3,
      0x22, 0xf8, 0x2d, 0x55, 0x6c, 0x2d, 0x65, 0xb3, 0x65, 0xdb, 0x30,
      0x81, 0x58, 0x79, 0xf6, 0x7f, 0x23, 0x3b, 0x08, 0x9b, 0x51},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 132
    {132,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x43, 0xa9, 0xb9, 0x02, 0x74, 0xdb, 0xd5, 0xf3, 0x6d,
      0xd2, 0x90, 0x46, 0xfc, 0x83, 0x90, 0x00, 0x8d, 0xde, 0x74, 0x51, 0x3c,
      0xe4, 0xc3, 0xe8, 0x89, 0x2b, 0x23, 0x6e, 0xff, 0xf8, 0x0c, 0x9d, 0xc7,
      0x15, 0x47, 0x15, 0x2a, 0x58, 0x97, 0xdb, 0xe1, 0x69, 0x57, 0xbd, 0x15,
      0xd1, 0xa8, 0x7d, 0x77, 0x04, 0x96, 0xf8, 0x14, 0xfe, 0x29, 0x21, 0xc8,
      0xf3, 0x3d, 0xf0, 0x43, 0x93, 0xc7, 0xf8},
     {0xe8, 0xca, 0xe9, 0x94, 0x42, 0x33, 0xb8, 0x67, 0xee, 0xdf, 0x59,
      0x02, 0xfc, 0x49, 0xec, 0xd0, 0x7e, 0x4c, 0x81, 0xc4, 0x62, 0x79,
      0x53, 0x1e, 0x89, 0x52, 0x0b, 0x74, 0xba, 0x53, 0x70, 0xb5},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 133
    {133,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xe9, 0xaf, 0x8e, 0x8c, 0x19, 0xda, 0x9d, 0x5c, 0x2f,
      0x3b, 0x3c, 0x03, 0xb8, 0xe9, 0x27, 0xc3, 0xcb, 0xe2, 0xd7, 0x17, 0xf9,
      0x8f, 0x50, 0x09, 0x72, 0xe5, 0x6d, 0x82, 0xeb, 0x07, 0xc2, 0xb1, 0x4e,
      0x83, 0xfc, 0xaa, 0xca, 0xdc, 0x26, 0xf8, 0xbb, 0x5e, 0x7b, 0x94, 0x74,
      0x1f, 0xe5, 0x4f, 0x31, 0x27, 0x5e, 0xbd, 0x6e, 0x1c, 0x96, 0x9d, 0x7e,
      0xc2, 0xfe, 0xce, 0xad, 0x8a, 0x0d, 0xae},
     {0xe7, 0x2a, 0xd0, 0xcd, 0xb2, 0x5f, 0x43, 0x07, 0xd1, 0xd8, 0x34,
      0xa5, 0xf7, 0x92, 0xe9, 0xaf, 0x64, 0xfd, 0x1b, 0x69, 0xa4, 0x70,
      0x41, 0xec, 0x8f, 0xa4, 0x6d, 0x52, 0x6f, 0x41, 0x9e, 0x4d},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 134
    {134,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x33, 0xd9, 0x58, 0x2b, 0x56, 0x7a, 0xad, 0xbe, 0x59,
      0x60, 0x6f, 0xa6, 0xff, 0xc1, 0x18, 0x48, 0xe4, 0x94, 0x7b, 0x51, 0x79,
      0x59, 0x73, 0x17, 0x77, 0x63, 0x17, 0xb2, 0xb4, 0xff, 0x65, 0xd0, 0xb4,
      0xd8, 0x56, 0x8d, 0xc8, 0x43, 0x31, 0x9c, 0xc0, 0x4f, 0x4b, 0xf1, 0x10,
      0x49, 0x6d, 0xee, 0x7c, 0x92, 0x29, 0xfc, 0x68, 0xcb, 0x09, 0x58, 0xf3,
      0xcb, 0xd3, 0x7e, 0xcc, 0xa6, 0x99, 0x0f},
     {0x00, 0x01, 0x97, 0xfb, 0xc2, 0x60, 0xa8, 0x4d, 0xbc, 0xbf, 0x88,
      0x13, 0x6a, 0xea, 0xa7, 0x9b, 0x03, 0xbb, 0x89, 0x49, 0xae, 0xfd,
      0x24, 0x16, 0xbe, 0xf6, 0x39, 0x29, 0xef, 0x78, 0x9b, 0xf3},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 135
    {135,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xe2, 0x1c, 0x02, 0x82, 0xad, 0xb1, 0xb2, 0x05, 0x5f,
      0xda, 0x74, 0x46, 0x44, 0xc6, 0x86, 0x12, 0xcf, 0xb0, 0xc6, 0x8a, 0x70,
      0xb9, 0x81, 0x2d, 0x00, 0x7f, 0x21, 0xa7, 0x8f, 0x1a, 0xdc, 0x48, 0x49,
      0xf3, 0xe7, 0x64, 0x4b, 0xc6, 0x63, 0x3e, 0x27, 0x73, 0xa2, 0xf3, 0xcc,
      0x52, 0x14, 0xfa, 0x72, 0x08, 0xe3, 0x0a, 0xfb, 0x3d, 0xe9, 0x92, 0xf0,
      0x77, 0xee, 0x32, 0x15, 0x69, 0xdc, 0x48},
     {0xcd, 0xb1, 0x8b, 0xf6, 0x26, 0x70, 0xa8, 0x53, 0x48, 0x8c, 0xa5,
      0x10, 0xd8, 0xf5, 0x5b, 0xab, 0x29, 0x18, 0x99, 0x14, 0x24, 0x92,
      0x5b, 0xd9, 0xb7, 0x4a, 0x82, 0x1d, 0x2c, 0x6e, 0x7e, 0x3c},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 136
    {136,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xaf, 0x27, 0xde, 0x0d, 0xa6, 0x55, 0x6e, 0x4e, 0x64,
      0x58, 0x8c, 0x96, 0x94, 0xaf, 0xee, 0x9a, 0x84, 0xe1, 0xcb, 0xd0, 0xc3,
      0x88, 0x97, 0x2d, 0xf3, 0xa9, 0x97, 0xf7, 0x60, 0xbb, 0xcd, 0x90, 0x3c,
      0x5a, 0x02, 0xe1, 0x61, 0x55, 0x1f, 0x33, 0x3d, 0x77, 0x05, 0x59, 0xab,
      0x1a, 0xf4, 0x9b, 0xf8, 0xb6, 0x82, 0x74, 0x89, 0x65, 0x90, 0x93, 0x9c,
      0xe9, 0x56, 0xd9, 0x91, 0x3b, 0x67, 0x6f},
     {0x16, 0x73, 0x03, 0x50, 0x5d, 0x22, 0xcf, 0x9e, 0xf7, 0x8c, 0x5b,
      0x96, 0x87, 0xa5, 0x41, 0x8f, 0xa9, 0xfb, 0x28, 0x4f, 0x2b, 0x0f,
      0xf6, 0x83, 0x16, 0x28, 0x8e, 0xcd, 0x7f, 0x2e, 0x2e, 0x09},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 137
    {137,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0d, 0xa4, 0x1b, 0x82, 0x55, 0x0b, 0x35, 0x8f, 0xf4,
      0x74, 0x91, 0x5d, 0x83, 0x10, 0x4d, 0x41, 0xa8, 0x3a, 0x12, 0xef, 0x70,
      0x58, 0x9b, 0x9d, 0x39, 0x2f, 0x0f, 0x30, 0xdc, 0x32, 0x42, 0x9e, 0xdc,
      0x76, 0x16, 0x3c, 0x8f, 0xe0, 0x7a, 0x3f, 0x70, 0x9c, 0xbd, 0x92, 0xda,
      0x0b, 0xbf, 0xc5, 0x04, 0x5f, 0x3d, 0xb8, 0x2a, 0xa5, 0x34, 0x4c, 0xf1,
      0xfd, 0x5b, 0x27, 0xfc, 0xd2, 0xf7, 0xa6},
     {0x85, 0x60, 0x0f, 0xf2, 0x3c, 0x3c, 0xde, 0x26, 0x00, 0x9f, 0xea,
      0x9b, 0x65, 0x39, 0x66, 0x4b, 0xf0, 0x45, 0x05, 0x68, 0x83, 0x72,
      0x8a, 0xb0, 0xd4, 0x49, 0x8e, 0xa0, 0xa8, 0xf4, 0xa4, 0x53},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 138
    {138,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x19, 0xc8, 0x44, 0xb8, 0xc7, 0x20, 0x90, 0x26, 0xa0,
      0x99, 0x6a, 0x78, 0x29, 0x83, 0xe1, 0xbd, 0x0f, 0x0d, 0xe9, 0x25, 0x5b,
      0x86, 0x73, 0x9b, 0xe9, 0xbe, 0xf0, 0x8e, 0xa5, 0x47, 0x5c, 0xc6, 0x69,
      0xa7, 0x79, 0xdd, 0xf5, 0x77, 0x47, 0xcf, 0x7d, 0x9a, 0x22, 0xf0, 0x0e,
      0xd8, 0xef, 0xc6, 0xe8, 0x18, 0xaf, 0x58, 0x27, 0xb7, 0x50, 0xd6, 0x65,
      0xfe, 0xe6, 0xd6, 0xd5, 0x8a, 0x22, 0xe8},
     {0xa3, 0x25, 0x0a, 0x2b, 0xfb, 0x14, 0x5c, 0xe8, 0x6e, 0x70, 0x6a,
      0xc3, 0xab, 0x2b, 0xf5, 0x03, 0xa6, 0x64, 0x86, 0xac, 0x0b, 0x2f,
      0x75, 0x22, 0x60, 0x1c, 0x12, 0x4b, 0x0e, 0x0f, 0x9c, 0x5b},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 139
    {139,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xbd, 0x07, 0xbd, 0x43, 0x26, 0xcd, 0xca, 0xbf, 0x42,
      0x90, 0x5e, 0xfa, 0x45, 0x59, 0xa3, 0x0e, 0x68, 0xcb, 0x21, 0x5d, 0x40,
      0xc9, 0xaf, 0xb6, 0x0c, 0xe0, 0x2d, 0x4f, 0xda, 0x61, 0x75, 0x79, 0xb9,
      0x27, 0xb5, 0xcb, 0xa0, 0x2d, 0x24, 0xfb, 0x9a, 0xaf, 0xe1, 0xd4, 0x29,
      0x35, 0x1e, 0x48, 0xba, 0xe9, 0xdd, 0x92, 0xd7, 0xbc, 0x7b, 0xe1, 0x5e,
      0x5b, 0x8a, 0x30, 0xa8, 0x6b, 0xe1, 0x3d},
     {0x2d, 0x70, 0xcc, 0x8c, 0x8a, 0xf0, 0x13, 0x66, 0x05, 0x1c, 0xc8,
      0x35, 0x9c, 0x2f, 0xc8, 0xf2, 0x58, 0x75, 0x7e, 0x26, 0x01, 0xfd,
      0x8f, 0x3e, 0x08, 0x42, 0x2a, 0x7b, 0x23, 0xbf, 0xef, 0xf5},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 140
    {140,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x89, 0xde, 0xe2, 0x7a, 0x60, 0xd0, 0x71, 0xda,
      0xbb, 0xaf, 0x58, 0xf3, 0xe5, 0x66, 0x14, 0xda, 0xd3, 0xb7, 0xf9, 0xa8,
      0x03, 0x07, 0x69, 0xfd, 0x04, 0x63, 0xb3, 0xe6, 0xe0, 0xf0, 0x3a, 0x14,
      0x7b, 0x4d, 0x6e, 0x7e, 0x7f, 0xd9, 0x39, 0xb9, 0xb5, 0x4d, 0xab, 0x45,
      0x8f, 0xd5, 0x56, 0xad, 0x8f, 0xda, 0xf4, 0xda, 0x6c, 0x39, 0x09, 0x58,
      0x8c, 0x4e, 0x05, 0x0c, 0xa7, 0x4a, 0x67},
     {0xcb, 0xe0, 0xc5, 0x71, 0xd1, 0x08, 0x0e, 0xa3, 0x4e, 0xe2, 0x0a,
      0xd1, 0xbf, 0xd2, 0x1e, 0xa5, 0xec, 0xc4, 0x42, 0xea, 0xd7, 0x33,
      0xfb, 0x4e, 0xee, 0x3c, 0x0d, 0x7b, 0x0c, 0xce, 0x99, 0x35},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 141
    {141,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x42, 0xed, 0xe1, 0x06, 0xcf, 0x85, 0xae, 0xf4, 0x6d,
      0xf7, 0xe5, 0xdb, 0xa8, 0xa8, 0xb0, 0x04, 0x59, 0x31, 0x7d, 0x9e, 0x76,
      0x6a, 0x7b, 0x77, 0xc2, 0x99, 0xaa, 0x0e, 0x17, 0xde, 0xa1, 0x42, 0xb6,
      0xe9, 0xa8, 0x6f, 0x4f, 0xc3, 0xe9, 0x45, 0xd4, 0x32, 0x3b, 0xa8, 0xe4,
      0x59, 0xf6, 0xb7, 0xb1, 0x4c, 0x56, 0x3a, 0x69, 0x8c, 0x75, 0x7a, 0x2d,
      0x5f, 0x7b, 0x0b, 0xc3, 0x01, 0xed, 0xe2},
     {0x33, 0x32, 0x0f, 0xc7, 0x91, 0x7f, 0xe4, 0xe1, 0x92, 0x80, 0xbf,
      0xbf, 0xe1, 0x6f, 0x22, 0x3c, 0x03, 0x7f, 0x7c, 0x2d, 0xc3, 0x0c,
      0x0f, 0xda, 0x98, 0x31, 0x07, 0x40, 0xf5, 0x7f, 0xe2, 0x89},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 142
    {142,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x97, 0x4b, 0x43, 0x16, 0xc5, 0xe7, 0xd1, 0x34, 0x8b,
      0x28, 0xdb, 0xc4, 0xfd, 0x61, 0xd8, 0xd3, 0x47, 0x0d, 0xe7, 0x44, 0xc3,
      0x0f, 0x5b, 0xe2, 0x37, 0xf8, 0x5f, 0x29, 0x96, 0x9d, 0xea, 0x77, 0xb5,
      0xf0, 0x0b, 0x58, 0xb8, 0x3c, 0xfc, 0x7b, 0xc5, 0x16, 0x55, 0x46, 0x5b,
      0x4a, 0x28, 0xab, 0xe1, 0xed, 0x3d, 0xbe, 0xc2, 0x0c, 0x6b, 0x46, 0x43,
      0xae, 0xc8, 0x5b, 0x95, 0xa5, 0xbe, 0xc6},
     {0x35, 0xc7, 0x26, 0xea, 0xd6, 0x6c, 0x39, 0x41, 0x4f, 0xe0, 0xc2,
      0x46, 0x04, 0xdf, 0x78, 0x38, 0xe5, 0x72, 0x5d, 0x2f, 0xc1, 0xbd,
      0x08, 0x53, 0x26, 0x1e, 0x1d, 0xe3, 0x33, 0x8e, 0xcb, 0x4f},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 143
    {143,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x59, 0x87, 0x3d, 0x75, 0x23, 0x93, 0x6a, 0x12, 0x1b,
      0x62, 0x9e, 0x98, 0x70, 0xf9, 0x30, 0x41, 0x9f, 0x25, 0x3a, 0x57, 0x67,
      0xb9, 0xd0, 0xdc, 0x49, 0x71, 0x6f, 0x2c, 0x50, 0xe1, 0x7b, 0xd0, 0x16,
      0x3b, 0x71, 0xf2, 0xbf, 0x43, 0x18, 0xfb, 0xde, 0x1c, 0xea, 0xa5, 0x85,
      0x45, 0x00, 0x80, 0xee, 0xc2, 0x84, 0x74, 0xcd, 0x18, 0xbf, 0x7c, 0x21,
      0xd2, 0xd1, 0xbf, 0xde, 0x4f, 0xf6, 0x77},
     {0x66, 0xea, 0x42, 0xfe, 0x6f, 0xd8, 0x74, 0x1b, 0x37, 0x59, 0x9b,
      0xbd, 0xad, 0xa3, 0xec, 0x0e, 0x6b, 0x08, 0xc0, 0xb5, 0x2e, 0xa6,
      0x7c, 0x29, 0xa3, 0x31, 0x72, 0xf7, 0x27, 0x42, 0x58, 0x3c},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 144
    {144,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xbd, 0x85, 0xa7, 0x9f, 0x81, 0xc4, 0xf9, 0x61, 0x3e,
      0x64, 0xfa, 0x34, 0x78, 0x86, 0x43, 0x78, 0x56, 0xc7, 0x35, 0x8d, 0x1b,
      0x69, 0xcf, 0x1e, 0x92, 0x3d, 0x77, 0x42, 0xd8, 0x2f, 0x9b, 0x67, 0x67,
      0xd2, 0x69, 0x18, 0xea, 0xa8, 0xac, 0xb1, 0x13, 0xa1, 0xda, 0xad, 0xae,
      0xdc, 0x70, 0x97, 0x42, 0x45, 0x73, 0x03, 0xeb, 0xc2, 0x3c, 0xdd, 0xa5,
      0x57, 0x26, 0x13, 0xdc, 0x82, 0x77, 0x03},
     {0x2f, 0x8a, 0x50, 0x2e, 0x4f, 0x44, 0x01, 0x33, 0xe8, 0x4f, 0xb6,
      0x25, 0x29, 0x2c, 0xbe, 0xab, 0xe2, 0xcb, 0x79, 0xda, 0x73, 0x98,
      0x7c, 0x76, 0xd4, 0xfe, 0xd8, 0x64, 0xd1, 0xb1, 0xb7, 0x62},
     false,
     true},

    // Comment: point with coordinate y = 1 in left to right addition chain
    // tcID: 145
    {145,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x3e, 0x6a, 0x4e, 0xff, 0xc4, 0x7c, 0x2f, 0x59, 0x26,
      0xbb, 0x6b, 0x4a, 0xcf, 0x2e, 0xac, 0x48, 0xb9, 0x52, 0x4c, 0x47, 0xd5,
      0x11, 0xf8, 0x16, 0x97, 0x67, 0x96, 0x77, 0x86, 0x00, 0xd6, 0xc5, 0xbf,
      0xce, 0x59, 0x32, 0x42, 0xa5, 0x98, 0x5a, 0x97, 0x75, 0x90, 0xf8, 0xd7,
      0x48, 0x5d, 0xf3, 0xf9, 0x53, 0x35, 0x29, 0x57, 0xf3, 0xc1, 0x7c, 0x13,
      0xe9, 0x45, 0x83, 0xd9, 0xc0, 0xe7, 0xb9},
     {0x06, 0x43, 0x68, 0x17, 0xd8, 0x92, 0x8b, 0x77, 0xb7, 0x3d, 0x16,
      0xc5, 0xc3, 0xb3, 0x5e, 0x24, 0x3a, 0xd3, 0xef, 0x2a, 0xb5, 0x9a,
      0xd0, 0x47, 0x14, 0x2c, 0x67, 0xa6, 0xd0, 0x92, 0x3c, 0x84},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 146
    {146,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x9a, 0x44, 0x87, 0xfc, 0xfc, 0xe8, 0x39, 0x66, 0x88,
      0xe7, 0x44, 0x9e, 0x09, 0x5f, 0xe8, 0x03, 0xca, 0xa2, 0x53, 0xd4, 0xbd,
      0x7c, 0x66, 0xdb, 0xc6, 0x26, 0x1c, 0xc9, 0xd9, 0xf8, 0x83, 0xa5, 0x0e,
      0x52, 0x51, 0xba, 0xe2, 0x9c, 0x5a, 0x5c, 0xdf, 0xa3, 0x1b, 0xc6, 0x11,
      0x05, 0x67, 0x1a, 0x88, 0xa0, 0x18, 0x46, 0x73, 0x98, 0x15, 0x8d, 0x35,
      0xb8, 0x88, 0x29, 0x23, 0x7c, 0x0b, 0xff},
     {0x7e, 0x83, 0xfd, 0x2c, 0x3d, 0x71, 0x3b, 0xc8, 0x5d, 0x6d, 0x85,
      0xd9, 0x07, 0x8b, 0x3a, 0x08, 0x42, 0x82, 0x4d, 0x41, 0x0e, 0x8a,
      0xbd, 0xe0, 0x4d, 0xa0, 0xfd, 0x71, 0xc7, 0xd9, 0x47, 0x05},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 147
    {147,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xfe, 0xd6, 0xce, 0x12, 0x72, 0x90, 0xc1, 0x29, 0x1c,
      0xa5, 0xce, 0x64, 0xac, 0xb4, 0xe0, 0xf2, 0xf8, 0x90, 0x56, 0x54, 0xd1,
      0xd2, 0x5b, 0xa5, 0x7c, 0x1f, 0x74, 0xab, 0x52, 0xf2, 0x1f, 0x42, 0x96,
      0x3d, 0x31, 0x67, 0x1c, 0x06, 0xb8, 0x02, 0x16, 0x99, 0x29, 0x52, 0x5c,
      0x4a, 0x1f, 0xde, 0xff, 0x5b, 0x1e, 0xaf, 0xab, 0x91, 0x9d, 0xc2, 0xdf,
      0x6c, 0x52, 0xbe, 0x84, 0xdf, 0xae, 0xf3},
     {0x0e, 0x3d, 0xfd, 0xab, 0x60, 0x6e, 0xbd, 0xc6, 0x42, 0x82, 0x82,
      0xac, 0xd4, 0x43, 0xf1, 0x89, 0xc9, 0x9b, 0x3b, 0x48, 0x3a, 0xa1,
      0x01, 0xfd, 0x8d, 0x6b, 0xed, 0x38, 0xae, 0xc5, 0x9e, 0x02},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 148
    {148,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xf7, 0xce, 0xe5, 0xb5, 0x5f, 0x18, 0x69, 0xf1, 0x37,
      0xdd, 0x70, 0x7c, 0x8f, 0x8f, 0xb8, 0x96, 0x5a, 0x2b, 0xe5, 0x84, 0x0c,
      0x31, 0x49, 0xfb, 0x75, 0x96, 0x95, 0xa4, 0x66, 0x1b, 0x9c, 0x0d, 0x23,
      0xc7, 0x8c, 0x4e, 0x96, 0x47, 0xb0, 0xd6, 0xcb, 0x2f, 0x26, 0x02, 0xbe,
      0x73, 0xff, 0x25, 0xcf, 0x3d, 0x09, 0xc9, 0x6d, 0x89, 0x2b, 0x57, 0x45,
      0xfe, 0x5e, 0xca, 0x81, 0x4a, 0xec, 0x91},
     {0xf4, 0x89, 0xf2, 0xbd, 0x93, 0xf7, 0x6b, 0x8e, 0x41, 0xfc, 0x6b,
      0x9f, 0x21, 0x1b, 0xc5, 0x99, 0xd4, 0x9d, 0xb1, 0xf1, 0x7a, 0x38,
      0xe9, 0x5b, 0xab, 0x1d, 0x31, 0xb2, 0xa2, 0xb5, 0x58, 0x29},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 149
    {149,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x2b, 0xaa, 0xae, 0xc3, 0xb3, 0xe8, 0xd5, 0x4a, 0x4e,
      0x18, 0xf0, 0x96, 0x0b, 0x94, 0x7d, 0xa2, 0x53, 0x5e, 0x3c, 0xfc, 0xca,
      0x2c, 0xfa, 0x8b, 0x71, 0x13, 0xaa, 0xd8, 0xe3, 0xb6, 0x62, 0x6f, 0x72,
      0xf7, 0x1e, 0x7c, 0x9e, 0x96, 0x04, 0x2c, 0x1d, 0x39, 0xcc, 0x8f, 0x11,
      0x39, 0xd5, 0x14, 0x7c, 0x6f, 0x4f, 0xe6, 0x2e, 0x23, 0xcf, 0x6d, 0xf3,
      0x64, 0xb5, 0xf4, 0xd8, 0x99, 0xf8, 0x42},
     {0xcc, 0x57, 0x38, 0xb4, 0x9d, 0x30, 0xd5, 0xd0, 0x2c, 0xf7, 0xe0,
      0xc5, 0x4a, 0x3d, 0xe0, 0x9b, 0x5b, 0x6f, 0x3c, 0x4d, 0xea, 0x91,
      0xdd, 0x06, 0x79, 0x07, 0x2a, 0x35, 0x62, 0x44, 0x4c, 0x37},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 150
    {150,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xa5, 0x1a, 0xb1, 0x23, 0x8b, 0xc1, 0xbe, 0xd2, 0x52,
      0x47, 0xe7, 0xd1, 0x79, 0xc8, 0x3a, 0x61, 0xae, 0x2d, 0x4a, 0x9f, 0xe2,
      0x28, 0x8c, 0x36, 0x3a, 0xe0, 0xeb, 0x7a, 0x77, 0xde, 0x43, 0x2a, 0x3c,
      0x6d, 0x35, 0xd8, 0x2b, 0xa8, 0x01, 0x7e, 0x6c, 0xa9, 0x04, 0x1c, 0xc7,
      0x85, 0xa3, 0x07, 0x03, 0xf7, 0xbc, 0x44, 0x27, 0x50, 0x6e, 0x62, 0x4a,
      0xc5, 0x97, 0x9d, 0x71, 0x54, 0x21, 0xdd},
     {0x89, 0xa1, 0x11, 0x77, 0xd6, 0x90, 0x7a, 0x81, 0xd4, 0x74, 0x67,
      0x09, 0x3b, 0xf6, 0xa3, 0xcc, 0x8b, 0xa5, 0x5d, 0xee, 0x05, 0x23,
      0x9b, 0x16, 0x0a, 0x31, 0xa3, 0x00, 0x0f, 0x5d, 0x80, 0x7b},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 151
    {151,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8b, 0x5a, 0xe8, 0xa0, 0xe5, 0x5f, 0x30, 0xf5, 0x09,
      0x06, 0x13, 0x15, 0xab, 0xae, 0x79, 0xac, 0x48, 0x0f, 0x88, 0xb4, 0x46,
      0x55, 0xf7, 0x26, 0x9a, 0x38, 0x5c, 0x81, 0x52, 0x68, 0x84, 0xbe, 0x26,
      0x29, 0x74, 0xa3, 0x1a, 0x0e, 0x23, 0x22, 0x12, 0x6c, 0x2d, 0x77, 0xb2,
      0x6b, 0x10, 0x8a, 0xbd, 0x81, 0xf8, 0xb9, 0x52, 0xc4, 0x58, 0xcc, 0xc9,
      0x5d, 0x46, 0xfb, 0x49, 0x24, 0xc7, 0xc0},
     {0x2c, 0xb0, 0x3c, 0x30, 0xb2, 0x00, 0x37, 0xa5, 0xcf, 0x4d, 0x5b,
      0x33, 0x57, 0x4f, 0x3a, 0xba, 0xc8, 0x95, 0xbf, 0xab, 0x37, 0x86,
      0x7e, 0xb2, 0xeb, 0xed, 0x26, 0x0e, 0x09, 0x29, 0x05, 0x8d},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 152
    {152,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x5f, 0x60, 0xc7, 0x7e, 0x47, 0x4d, 0xd6, 0x6c, 0x81,
      0x35, 0xee, 0x3d, 0xaf, 0xc7, 0x5b, 0xa6, 0x44, 0x64, 0x98, 0x24, 0xc7,
      0x27, 0x37, 0x54, 0x20, 0x91, 0xad, 0x46, 0x9a, 0xdb, 0xb6, 0x85, 0x31,
      0x2c, 0x09, 0xc6, 0x9b, 0x62, 0x9d, 0x04, 0x36, 0xbf, 0x3b, 0xd6, 0xc6,
      0x08, 0x3f, 0xf2, 0xa8, 0x7b, 0xe4, 0x84, 0xa7, 0x3e, 0xf3, 0xa5, 0xd2,
      0xc3, 0xe0, 0x6b, 0x5d, 0x9b, 0x21, 0xb3},
     {0xe5, 0x4d, 0x48, 0x7d, 0x0c, 0x4b, 0x12, 0xfe, 0x52, 0x2a, 0xf3,
      0xe6, 0x63, 0xce, 0x31, 0x6e, 0x63, 0x2b, 0xa9, 0xd6, 0x3a, 0x1f,
      0x02, 0xa3, 0x6f, 0xc5, 0xa8, 0x2b, 0xf8, 0x27, 0x31, 0xa4},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 153
    {153,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xe0, 0x6e, 0xaa, 0x73, 0xf6, 0xfe, 0xae, 0x45, 0x41,
      0x7d, 0x85, 0x9b, 0xba, 0xd4, 0xbc, 0x40, 0x4b, 0x28, 0x85, 0xbc, 0xd2,
      0x13, 0xeb, 0xac, 0xe5, 0x94, 0xe1, 0x6f, 0x49, 0x70, 0xe0, 0xc4, 0x11,
      0xed, 0x33, 0x23, 0xa3, 0xd7, 0xaf, 0xc7, 0x07, 0x62, 0x39, 0x88, 0x43,
      0x07, 0xf9, 0x18, 0x49, 0xed, 0x5f, 0x5e, 0x36, 0xb6, 0x17, 0x1d, 0x30,
      0x9c, 0x81, 0x34, 0x4c, 0x53, 0xe0, 0x6d},
     {0xcc, 0xea, 0x96, 0x9d, 0x40, 0xfa, 0x42, 0x93, 0x3f, 0x4f, 0xbd,
      0xc4, 0xca, 0xbe, 0x21, 0x85, 0xf8, 0xa4, 0x52, 0x99, 0x62, 0x54,
      0xc1, 0xf4, 0xe0, 0xdd, 0xe5, 0xe1, 0x4f, 0xee, 0xea, 0x8d},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 154
    {154,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0f, 0x1c, 0x1b, 0x89, 0xe9, 0xfc, 0x6f, 0xc0, 0xfa,
      0xef, 0xc9, 0x10, 0x9f, 0xc4, 0xa1, 0x24, 0x7d, 0x9f, 0x54, 0xc7, 0x49,
      0x7b, 0x6c, 0xc9, 0x75, 0xe6, 0xa5, 0x45, 0x5b, 0xef, 0x41, 0x08, 0x36,
      0xcb, 0x38, 0x18, 0x54, 0x8a, 0xc9, 0xb4, 0x1e, 0x2b, 0x83, 0x36, 0xc3,
      0xeb, 0x8d, 0x97, 0x07, 0x5a, 0xe4, 0x7e, 0x18, 0x27, 0xfa, 0x1f, 0xf9,
      0x3d, 0x43, 0x41, 0xd4, 0x3c, 0x0c, 0x1d},
     {0xea, 0xae, 0x0e, 0x18, 0x8c, 0x94, 0x27, 0xbf, 0x3c, 0x8b, 0x3d,
      0xed, 0x77, 0x21, 0x22, 0x20, 0x4c, 0x32, 0x8d, 0x59, 0x41, 0xe3,
      0x89, 0xd8, 0x08, 0xe2, 0x72, 0x46, 0x38, 0xf9, 0xaf, 0xf8},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 155
    {155,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x57, 0x70, 0x69, 0xe8, 0x28, 0x4a, 0x95, 0xf5, 0x1d,
      0xca, 0xb9, 0x19, 0xb0, 0x53, 0x66, 0x57, 0x05, 0x89, 0x71, 0xda, 0xb7,
      0x62, 0x17, 0xf8, 0xd3, 0xae, 0x72, 0x2a, 0x64, 0x09, 0x2e, 0x26, 0xe5,
      0x1f, 0x68, 0xa7, 0x22, 0xcc, 0x03, 0x97, 0xf4, 0x80, 0x14, 0x01, 0x77,
      0x1e, 0x9a, 0x3d, 0x19, 0x88, 0xd4, 0xaf, 0x76, 0xf1, 0x4f, 0x9e, 0x2f,
      0x9c, 0x36, 0xe0, 0x77, 0x3e, 0x29, 0xc2},
     {0xfe, 0xa0, 0xcc, 0xe1, 0x35, 0x8f, 0x1f, 0xf4, 0x0f, 0xfe, 0xaa,
      0xff, 0xbf, 0x91, 0xb2, 0xe8, 0xd4, 0x26, 0xd4, 0xe3, 0x1e, 0x96,
      0x27, 0x73, 0x1a, 0xce, 0x3a, 0x12, 0x2e, 0xab, 0x6b, 0x0d},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 156
    {156,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x24, 0x06, 0xa2, 0x75, 0x90, 0x50, 0xb9, 0x25, 0xdd,
      0x4f, 0x81, 0x4c, 0x50, 0x33, 0xe3, 0x55, 0x54, 0x8f, 0x42, 0xbb, 0xf1,
      0xaf, 0xb7, 0x91, 0xc1, 0x10, 0xf0, 0x03, 0x1f, 0x29, 0xf6, 0x80, 0x99,
      0xd5, 0xf4, 0xb0, 0x05, 0xde, 0x39, 0x27, 0xf1, 0x65, 0xab, 0xef, 0xf1,
      0x96, 0xa2, 0x8c, 0x72, 0x17, 0xfa, 0xb1, 0xbe, 0x2b, 0x52, 0x09, 0xc3,
      0x24, 0xe7, 0xd6, 0x2d, 0x2d, 0xd6, 0x87},
     {0x83, 0x76, 0x21, 0xea, 0x48, 0x27, 0xbb, 0xa0, 0x37, 0x6a, 0xaa,
      0x8a, 0xa6, 0x6c, 0xfe, 0x14, 0x4a, 0x2f, 0xf1, 0xe3, 0x59, 0xdc,
      0x61, 0x9a, 0x06, 0x44, 0x1d, 0x3e, 0x05, 0x5f, 0x97, 0x71},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 157
    {157,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xcc, 0xaa, 0xc6, 0x1f, 0x35, 0xa2, 0x78, 0x61, 0x18,
      0x36, 0x21, 0x64, 0x2b, 0xc5, 0x73, 0xaf, 0x91, 0x33, 0x56, 0xfb, 0x47,
      0xcf, 0x58, 0x2f, 0x0b, 0x52, 0x99, 0x09, 0x9d, 0x6f, 0x6c, 0x69, 0x91,
      0xf7, 0x27, 0x2b, 0x83, 0xb7, 0x38, 0xa7, 0xa5, 0xd3, 0x04, 0x47, 0xc8,
      0x7f, 0x12, 0x6a, 0x7d, 0x98, 0xec, 0x72, 0xfa, 0x26, 0x09, 0xd0, 0x93,
      0x9d, 0x18, 0xdb, 0x7e, 0xa7, 0xeb, 0x3a},
     {0x63, 0x97, 0x4c, 0xe6, 0x15, 0x37, 0x62, 0xe5, 0xb3, 0x64, 0x52,
      0x3c, 0xea, 0xd9, 0x3e, 0x8c, 0xe8, 0xbc, 0xc7, 0x7d, 0xda, 0x56,
      0x36, 0x5d, 0x67, 0x61, 0x36, 0x16, 0x9f, 0xc4, 0xe3, 0x9b},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 158
    {158,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x01, 0x41, 0x59, 0x17, 0x27, 0x2f, 0x19, 0x84, 0xe7,
      0x21, 0x7a, 0x36, 0xfb, 0x31, 0x1f, 0xd2, 0x90, 0x4d, 0x41, 0xa6, 0xb1,
      0x39, 0x73, 0xf9, 0x2a, 0xae, 0x3b, 0x90, 0xe8, 0x5e, 0x4d, 0x56, 0xd9,
      0x7c, 0x82, 0x2e, 0xb7, 0xb2, 0x1a, 0x84, 0xd0, 0xd1, 0xbe, 0x48, 0x67,
      0x40, 0x4a, 0x80, 0xc3, 0x48, 0x67, 0xf4, 0x31, 0x39, 0xda, 0xdc, 0xc3,
      0x61, 0x9e, 0x10, 0xb2, 0x22, 0x56, 0x2b},
     {0x0a, 0x04, 0x88, 0x14, 0x4b, 0xc3, 0x6d, 0x69, 0x0b, 0x62, 0x14,
      0x8a, 0xc3, 0x07, 0x60, 0x47, 0xd4, 0x6d, 0x48, 0xf7, 0xad, 0xbb,
      0x0f, 0x34, 0xfe, 0xe9, 0xa6, 0x36, 0x29, 0x5f, 0xe7, 0x37},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 159
    {159,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xb2, 0x57, 0x5d, 0x10, 0x0c, 0x6f, 0xa0, 0x56, 0xbc,
      0xd1, 0x37, 0xab, 0x11, 0x1b, 0x53, 0x15, 0xa8, 0x90, 0x8c, 0x29, 0x24,
      0x3b, 0x84, 0xf3, 0xdc, 0x99, 0x6d, 0x0e, 0x45, 0x76, 0x4b, 0x91, 0x66,
      0xca, 0xbe, 0xb4, 0x18, 0x85, 0x58, 0x8e, 0xc0, 0x8b, 0x47, 0x25, 0x7d,
      0xf5, 0x8b, 0xd5, 0x8f, 0x7d, 0xcd, 0x9e, 0x01, 0x2e, 0x26, 0x69, 0xfa,
      0x2f, 0x52, 0xe2, 0x57, 0x67, 0xfc, 0x4c},
     {0x12, 0x32, 0x16, 0x55, 0x38, 0xa4, 0x42, 0x68, 0xaa, 0x7c, 0x19,
      0x9c, 0x54, 0xd6, 0xd2, 0x07, 0xc4, 0xef, 0x3f, 0x5a, 0xa7, 0x90,
      0xc1, 0x0c, 0x92, 0x6a, 0x20, 0x75, 0x2c, 0xa6, 0x45, 0xce},
     false,
     true},

    // Comment: point with coordinate y = 1 in precomputation or right to left
    // addition chain
    // tcID: 160
    {160,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xc1, 0x73, 0x55, 0xed, 0x30, 0xcc, 0xd6, 0x42, 0x7f,
      0x96, 0x85, 0x70, 0x90, 0x21, 0xb2, 0x5c, 0x11, 0xed, 0x17, 0x6e, 0x96,
      0x10, 0xc4, 0x79, 0xbc, 0xc4, 0xcc, 0x75, 0x52, 0xa7, 0x38, 0xe6, 0x1f,
      0x75, 0x11, 0x47, 0x61, 0xdb, 0xa0, 0xec, 0x60, 0xcd, 0x26, 0x4b, 0xba,
      0xb7, 0x63, 0xc5, 0xd5, 0xab, 0xcc, 0x75, 0xcd, 0x8f, 0xb5, 0x65, 0x1d,
      0x06, 0x45, 0x17, 0x99, 0x88, 0xcc, 0x6d},
     {0xdc, 0xab, 0x5e, 0x87, 0x4e, 0x4f, 0xb7, 0x6b, 0xc4, 0x31, 0x25,
      0x28, 0xe9, 0xd7, 0x6d, 0xfa, 0xe5, 0x61, 0x45, 0x92, 0x25, 0x33,
      0x08, 0x97, 0x34, 0x11, 0x0b, 0xf5, 0x65, 0x3f, 0x4d, 0x77},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 161
    {161,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x34, 0x15, 0x92, 0x39, 0x0c, 0xcc, 0xe4, 0x85, 0xde,
      0x88, 0x80, 0xf3, 0xd7, 0x27, 0xf6, 0x64, 0xc3, 0x81, 0x91, 0x4a, 0x1b,
      0xec, 0xec, 0x38, 0x3b, 0x35, 0x58, 0x67, 0x51, 0xfc, 0x81, 0xc2, 0xad,
      0xd7, 0x18, 0x52, 0xb8, 0x70, 0x16, 0xe1, 0x01, 0x9c, 0xae, 0x7a, 0x90,
      0x80, 0xe7, 0x5c, 0xe0, 0xb0, 0xb8, 0xaa, 0xc1, 0x75, 0xd6, 0x92, 0xd5,
      0xe7, 0xb4, 0xda, 0xd0, 0x88, 0xf5, 0xcc},
     {0x4c, 0xe2, 0x70, 0x1b, 0x2b, 0xe6, 0x3a, 0x00, 0x83, 0xa4, 0xc5,
      0x3f, 0x7a, 0x0b, 0xf0, 0x4c, 0xf8, 0x71, 0x65, 0x4f, 0x5e, 0xdb,
      0x6f, 0x62, 0x5e, 0x3e, 0xa5, 0xe7, 0xd0, 0xbd, 0xcc, 0x90},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 162
    {162,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xfa, 0x76, 0x4b, 0x6b, 0x76, 0xa8, 0x6c, 0x3b, 0x76,
      0x21, 0x20, 0x82, 0x5d, 0x35, 0x3a, 0x24, 0x76, 0x62, 0x08, 0xc1, 0xf5,
      0xcc, 0x0f, 0xe3, 0xfe, 0x79, 0x98, 0x02, 0x6a, 0x2e, 0xc5, 0xc4, 0x3b,
      0xb2, 0xf9, 0x48, 0xfd, 0x94, 0xcd, 0xaa, 0x58, 0x69, 0xb1, 0xe0, 0xe7,
      0x3a, 0x4d, 0x97, 0x03, 0x5c, 0xc4, 0x93, 0x57, 0xfb, 0x7b, 0x74, 0xd7,
      0xed, 0x0a, 0x2c, 0x5b, 0x8d, 0x54, 0xeb},
     {0x7a, 0xbe, 0xf9, 0x76, 0x5c, 0xca, 0x72, 0x13, 0x20, 0xfb, 0xf8,
      0xed, 0xcb, 0xef, 0x6d, 0x2b, 0xa2, 0x5d, 0x17, 0xb7, 0x0f, 0xfa,
      0x17, 0x76, 0x02, 0x9b, 0xc3, 0x8f, 0xe6, 0x77, 0xa1, 0x2c},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 163
    {163,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xa7, 0x1f, 0xbb, 0x61, 0x71, 0x99, 0xbd, 0x58, 0x5b,
      0x4b, 0x66, 0x21, 0x2c, 0xa3, 0x3c, 0xa9, 0xe0, 0x93, 0x70, 0xe6, 0xbf,
      0x15, 0xc8, 0xea, 0x0a, 0xce, 0xfd, 0x9c, 0x8e, 0x94, 0x5d, 0x06, 0x84,
      0x0f, 0x05, 0x88, 0x63, 0x07, 0x8e, 0x74, 0x3e, 0x22, 0x0f, 0xf9, 0x9f,
      0x23, 0xbb, 0xc1, 0xda, 0xa3, 0x68, 0x35, 0xd4, 0xb1, 0x26, 0x9f, 0x0a,
      0x75, 0x36, 0xe6, 0x3f, 0x06, 0xd8, 0x53},
     {0x5f, 0x61, 0x40, 0x4d, 0xbb, 0xbc, 0x28, 0x67, 0xdf, 0xf9, 0x5c,
      0x1f, 0x37, 0xed, 0x44, 0xf4, 0xcb, 0x8f, 0xab, 0xcd, 0x22, 0x3b,
      0x03, 0x73, 0x9d, 0x88, 0x83, 0x08, 0xd1, 0x3b, 0xc4, 0x12},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 164
    {164,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x13, 0xc8, 0x29, 0x2d, 0x85, 0x4d, 0x39, 0x45, 0x1c,
      0x0c, 0x63, 0xa8, 0x02, 0xb8, 0xc0, 0x3e, 0x4f, 0xcb, 0x87, 0x5e, 0xf0,
      0x12, 0x39, 0x89, 0x62, 0x95, 0xba, 0x1c, 0x0f, 0x38, 0x69, 0x75, 0xf8,
      0x2d, 0xf1, 0x97, 0x08, 0x6f, 0xd8, 0x60, 0x32, 0xcb, 0x36, 0xb6, 0x9a,
      0x27, 0x87, 0x6d, 0xd7, 0x5a, 0x8e, 0x96, 0x79, 0xf3, 0x6f, 0xfc, 0x22,
      0x10, 0xed, 0xb1, 0x28, 0xd4, 0xbe, 0x13},
     {0x8d, 0x67, 0x3a, 0x57, 0x7e, 0x35, 0xbf, 0x9d, 0x5d, 0x00, 0x67,
      0x6c, 0x08, 0xb2, 0xc7, 0x39, 0x61, 0x7c, 0x46, 0xa0, 0x52, 0x18,
      0x84, 0x03, 0xaa, 0x06, 0xdc, 0x71, 0x4a, 0xf6, 0xac, 0xc1},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 165
    {165,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x0c, 0xd9, 0xdf, 0x41, 0x5a, 0xcc, 0x0c, 0x32, 0xfd,
      0x4e, 0x3d, 0x69, 0x24, 0xce, 0x53, 0x07, 0x5b, 0x04, 0x52, 0xbf, 0x91,
      0x9a, 0x2a, 0xb2, 0xeb, 0xe2, 0x65, 0x97, 0x57, 0x0f, 0x1e, 0xcd, 0x59,
      0x85, 0xd8, 0xd2, 0xc5, 0xdf, 0x78, 0xfc, 0x10, 0x0f, 0x87, 0xef, 0xb6,
      0xdf, 0xa9, 0x54, 0x37, 0x57, 0xbd, 0xff, 0xec, 0xf0, 0x83, 0xdf, 0xcd,
      0x1e, 0xcb, 0x38, 0xde, 0x6c, 0x23, 0xf8},
     {0xa7, 0x83, 0x5f, 0xfe, 0xe0, 0xf2, 0xa6, 0x9d, 0xfc, 0xf7, 0x0d,
      0x4e, 0x79, 0x8d, 0xbe, 0x3e, 0xd3, 0x2b, 0xa0, 0x3c, 0xfd, 0xda,
      0xe5, 0xdd, 0xd1, 0x1d, 0x8c, 0x0a, 0xc3, 0xd7, 0x4f, 0x9b},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 166
    {166,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd2, 0xdb, 0xea, 0x40, 0x46, 0xb2, 0x3f, 0xd2, 0xb2,
      0x33, 0xd1, 0xce, 0x31, 0xdc, 0xed, 0xdb, 0x89, 0xb2, 0x5f, 0x26, 0xc0,
      0x62, 0x7a, 0x9d, 0x2d, 0xb3, 0xc5, 0x60, 0x5c, 0x9c, 0xc9, 0x95, 0x35,
      0xbd, 0xc8, 0xde, 0x74, 0x51, 0xc1, 0xe2, 0x7e, 0x97, 0xaa, 0x91, 0x40,
      0x2c, 0xce, 0x38, 0x82, 0xc7, 0x12, 0x69, 0xd9, 0xcb, 0xdc, 0xb5, 0xd7,
      0xac, 0x0c, 0xeb, 0x91, 0x1b, 0x9b, 0x6d},
     {0xe9, 0x8e, 0xa2, 0x22, 0x09, 0xcd, 0x39, 0x7e, 0xdb, 0x6c, 0x31,
      0x96, 0x48, 0xc1, 0xeb, 0x24, 0xbc, 0x4d, 0x39, 0x59, 0x8a, 0xb1,
      0x19, 0x95, 0x57, 0x19, 0x26, 0x68, 0x4c, 0xe2, 0xce, 0xca},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 167
    {167,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x88, 0x8f, 0xb0, 0x44, 0xfb, 0x2b, 0x6c, 0xaa, 0x60,
      0x36, 0x6b, 0xfa, 0x66, 0x2a, 0xdb, 0xa4, 0x79, 0xb8, 0x36, 0x5a, 0x65,
      0x55, 0xa2, 0x98, 0x87, 0xd5, 0x80, 0xf5, 0x87, 0x08, 0x6b, 0xa8, 0x48,
      0x2f, 0x4e, 0xc2, 0x40, 0x82, 0xa4, 0x8d, 0x64, 0x02, 0xaf, 0xa1, 0x62,
      0x21, 0x43, 0xf2, 0x6e, 0x61, 0xd9, 0x1b, 0x7e, 0x30, 0xd6, 0xa4, 0xb2,
      0x23, 0x63, 0x0e, 0xe1, 0x0f, 0x70, 0xfb},
     {0x91, 0xb6, 0x57, 0x33, 0x86, 0x0b, 0x1b, 0xdb, 0x95, 0x41, 0xd9,
      0xf5, 0x58, 0x95, 0xa3, 0xdb, 0xb3, 0xf1, 0x3c, 0x19, 0x92, 0x51,
      0xd3, 0x30, 0x06, 0xb6, 0xdc, 0xf9, 0x0a, 0xc3, 0x49, 0xed},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 168
    {168,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x2e, 0x2b, 0xec, 0x13, 0x42, 0x49, 0x37, 0x9d, 0x57,
      0x70, 0x03, 0x01, 0xf3, 0xa5, 0x8e, 0x4b, 0x39, 0x5a, 0x4d, 0x28, 0x37,
      0x0d, 0x2a, 0x06, 0xe6, 0x5e, 0x7a, 0xc8, 0x9e, 0xd7, 0x6a, 0xc6, 0x97,
      0xdc, 0x96, 0x0b, 0xd7, 0x95, 0xcd, 0xf4, 0xfb, 0xcf, 0xdd, 0x75, 0x14,
      0x90, 0x57, 0xb8, 0xe0, 0x22, 0x33, 0x1c, 0x7b, 0x54, 0x61, 0xf3, 0x83,
      0xac, 0x58, 0x9d, 0x76, 0x4d, 0xf3, 0x33},
     {0x1f, 0xdf, 0x7c, 0x5c, 0x48, 0x04, 0x7a, 0x11, 0x3e, 0x5e, 0x5d,
      0x1b, 0x7e, 0xd5, 0x93, 0x33, 0x7e, 0x76, 0x92, 0x31, 0xcc, 0xa5,
      0xc7, 0x11, 0x01, 0x60, 0xe0, 0xc1, 0xb9, 0x7f, 0x42, 0x56},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 169
    {169,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xc7, 0x8c, 0xda, 0x7e, 0x3b, 0x9e, 0x17, 0x72, 0xeb,
      0xed, 0x30, 0xb2, 0xb5, 0x1d, 0xcf, 0x15, 0x5a, 0x69, 0xa0, 0xfc, 0x50,
      0x45, 0x57, 0x83, 0x6e, 0x25, 0x14, 0x7c, 0xfb, 0x81, 0x27, 0xd2, 0xf8,
      0x28, 0x9c, 0xf3, 0x8b, 0x03, 0x3d, 0x37, 0x63, 0xc8, 0xf9, 0xf6, 0xc0,
      0x91, 0x78, 0x7a, 0x31, 0x42, 0xfb, 0x83, 0xdf, 0xf5, 0x71, 0x95, 0x90,
      0x28, 0x2c, 0x6f, 0x85, 0x2e, 0x01, 0x05},
     {0xba, 0x0a, 0xbc, 0x3e, 0x71, 0x72, 0x6c, 0xb5, 0x13, 0x30, 0x48,
      0x91, 0x76, 0x35, 0x7b, 0x81, 0xb8, 0x07, 0x4d, 0x76, 0x90, 0xe4,
      0xe8, 0x2e, 0x9a, 0x3c, 0x00, 0x15, 0x1e, 0x1f, 0xa3, 0x18},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 170
    {170,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x1e, 0x3d, 0xf4, 0xdd, 0x7f, 0xb7, 0x71, 0x8c, 0xb0,
      0xaa, 0x0d, 0xd7, 0x2f, 0x8a, 0x25, 0xc8, 0x3c, 0x4e, 0x80, 0x4e, 0x7c,
      0xbd, 0x48, 0xc5, 0xe9, 0x65, 0x65, 0x1f, 0x9e, 0x23, 0xbf, 0x4e, 0xf0,
      0xff, 0x40, 0xdd, 0x97, 0x96, 0xe4, 0xa9, 0xa5, 0xed, 0xdd, 0x2c, 0x4c,
      0xa4, 0xeb, 0xd1, 0x09, 0x90, 0xd8, 0xfb, 0x89, 0x18, 0xd1, 0x2d, 0x53,
      0xc7, 0x60, 0x01, 0xaf, 0xa9, 0xde, 0x7f},
     {0x16, 0xe6, 0x32, 0xf9, 0x75, 0x2d, 0x36, 0x60, 0x2c, 0x95, 0xec,
      0x27, 0x4b, 0x32, 0xad, 0x59, 0x4f, 0x39, 0xf6, 0xac, 0x3b, 0xd4,
      0xb0, 0xb2, 0x0f, 0x86, 0x37, 0x39, 0x21, 0x42, 0xce, 0xf4},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 171
    {171,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xe5, 0xc5, 0xdc, 0x3f, 0xd8, 0x8d, 0x85, 0x66, 0x8b,
      0x3b, 0x70, 0x9f, 0xd6, 0xb4, 0x23, 0x2f, 0x1f, 0x80, 0x94, 0x9c, 0xbc,
      0xcb, 0x55, 0x88, 0x36, 0x3e, 0x6c, 0x21, 0x7a, 0x2b, 0x3e, 0xd8, 0x8d,
      0xbd, 0x0d, 0x6e, 0x3c, 0xc9, 0x7f, 0x30, 0x81, 0xd1, 0x66, 0x02, 0xaa,
      0x3d, 0x1b, 0x65, 0x5e, 0xe0, 0x79, 0x1c, 0x87, 0xfc, 0xb5, 0xab, 0xe6,
      0x21, 0x7d, 0x8c, 0x85, 0x13, 0x80, 0x7e},
     {0x9e, 0xed, 0x4b, 0x96, 0x56, 0x9f, 0x60, 0x4a, 0x4d, 0x3f, 0x5a,
      0xf9, 0x74, 0x99, 0x80, 0x71, 0x11, 0xfc, 0x98, 0x88, 0xc4, 0x58,
      0xec, 0xe2, 0xe3, 0x00, 0x0e, 0x24, 0x5c, 0x2c, 0x02, 0xb0},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 172
    {172,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x02, 0x1c, 0x41, 0xec, 0xee, 0xc2, 0x4e, 0x0f, 0xba,
      0x89, 0x4a, 0xd7, 0x41, 0x5a, 0x95, 0x98, 0xcb, 0xcd, 0x14, 0xfa, 0x6c,
      0xa4, 0x6e, 0x25, 0x57, 0x52, 0x68, 0xa1, 0xd8, 0xe5, 0xbb, 0xc6, 0x3f,
      0x84, 0x6c, 0x6a, 0x18, 0x5f, 0xa3, 0xf2, 0x3b, 0xb9, 0x2c, 0x14, 0xe7,
      0xe2, 0xcb, 0xa8, 0xc7, 0x40, 0x47, 0xc0, 0x9a, 0xf7, 0x66, 0xf5, 0x5e,
      0xf0, 0xc9, 0x07, 0xc8, 0x0d, 0x94, 0x51},
     {0x21, 0xac, 0x32, 0x01, 0x38, 0x38, 0x81, 0x26, 0x21, 0xdb, 0xb5,
      0x84, 0x96, 0x5b, 0xde, 0xd6, 0xfc, 0x85, 0x1d, 0x3a, 0x02, 0x98,
      0x10, 0x67, 0x9b, 0xc5, 0x7b, 0x23, 0x81, 0xbb, 0x7a, 0x7d},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 173
    {173,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x8e, 0x24, 0x19, 0x2c, 0xd3, 0x33, 0x35, 0xa1, 0x14,
      0xf5, 0x07, 0x02, 0x66, 0xc0, 0x14, 0xcb, 0x0d, 0x8c, 0x70, 0x4d, 0x16,
      0xd6, 0x04, 0x2e, 0x89, 0xc1, 0x75, 0x97, 0xbc, 0xd4, 0xe7, 0x7e, 0xbd,
      0xb4, 0xc5, 0x17, 0x17, 0x04, 0xc2, 0xc0, 0x92, 0x75, 0xc2, 0x2a, 0x31,
      0x0e, 0x0c, 0x4f, 0xe0, 0x92, 0xe4, 0x08, 0x48, 0x56, 0xda, 0x99, 0xb9,
      0x4a, 0xbb, 0xfa, 0x9f, 0x46, 0x9f, 0x48},
     {0xfc, 0x59, 0x78, 0xda, 0x01, 0xca, 0x83, 0xe1, 0x27, 0xdd, 0xdf,
      0x98, 0x9a, 0x03, 0x58, 0x87, 0x1b, 0x3c, 0x4c, 0xe0, 0x75, 0x5b,
      0xfb, 0x02, 0x06, 0x33, 0xdb, 0x46, 0x7e, 0x21, 0xa5, 0x3c},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 174
    {174,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0xc9, 0x0a, 0xe4, 0x7a, 0x93, 0xd0, 0x9a, 0x23,
      0x52, 0xb6, 0xf3, 0x67, 0x7e, 0x79, 0x75, 0xea, 0x62, 0xaa, 0xde, 0xdb,
      0x56, 0xc1, 0x18, 0xeb, 0x8b, 0x9f, 0x77, 0x1e, 0x2d, 0xd9, 0xf5, 0xf2,
      0x60, 0x1f, 0xb9, 0xcc, 0xa2, 0x30, 0x4e, 0x59, 0x44, 0x23, 0xcf, 0x48,
      0x06, 0x4d, 0xbe, 0xd1, 0x7a, 0xe4, 0x04, 0x52, 0xf1, 0x8b, 0xe6, 0xae,
      0x01, 0x83, 0x21, 0x91, 0x1e, 0x8c, 0xb3},
     {0x9f, 0x41, 0x73, 0x41, 0x26, 0x1a, 0xa4, 0x5d, 0x39, 0x6b, 0x0c,
      0xcf, 0x2a, 0x3d, 0xee, 0x7a, 0x46, 0x6c, 0xa4, 0x7e, 0x3c, 0xe8,
      0x6e, 0xcd, 0x20, 0x71, 0xd9, 0xc4, 0xdb, 0x08, 0x82, 0x0e},
     false,
     true},

    // Comment: point with coordinate y = 1 in right to left addition chain
    // tcID: 175
    {175,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x9c, 0x46, 0x1d, 0x8b, 0x39, 0x16, 0x35, 0x37, 0xff, 0x8f, 0x5e,
      0xf5, 0xb9, 0x77, 0xe4, 0xcd, 0xb9, 0x80, 0xe7, 0x0e, 0x38, 0xa7, 0xee,
      0x0b, 0x37, 0xcc, 0x87, 0x67, 0x29, 0xe9, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x04, 0x68, 0xae, 0x77, 0x06, 0x22, 0x1e, 0x59, 0x90, 0xf7,
      0x48, 0x4d, 0x34, 0xfb, 0xec, 0x5a, 0x99, 0x05, 0x01, 0x79, 0xa6, 0xc1,
      0x18, 0x17, 0xbb, 0xed, 0x4a, 0xed, 0x96, 0x29, 0x98, 0xff, 0xb5, 0x22,
      0x8d, 0x89, 0xa1, 0xb4, 0x48, 0xf1, 0x23, 0x32, 0x37, 0x6c, 0x8c, 0x7f,
      0x08, 0x07, 0x63, 0x53, 0x2a, 0x05, 0x5e, 0x07, 0xf1, 0x4a, 0x5d, 0xe0,
      0xdc, 0x30, 0x10, 0x45, 0x79, 0xe1},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xd2, 0xf2, 0x11, 0xcf, 0xab, 0x84, 0xe0, 0x1c, 0x8e,
      0x55, 0x44, 0x03, 0x62, 0x34, 0xde, 0xbe, 0x35, 0xae, 0x10, 0x3b, 0xb8,
      0x78, 0xd7, 0xab, 0xce, 0xa6, 0x82, 0x5f, 0x75, 0x3e, 0x03, 0xa3, 0x85,
      0xf7, 0xf1, 0x87, 0x0e, 0x64, 0xf1, 0x26, 0x2a, 0xf6, 0x7a, 0x25, 0xef,
      0x98, 0x80, 0x41, 0x9f, 0x45, 0x60, 0x8e, 0x7f, 0x9d, 0xa6, 0xde, 0xe8,
      0x3f, 0x5f, 0x46, 0xce, 0xb5, 0x3d, 0xcb},
     {0xf4, 0x19, 0xfe, 0xbb, 0x32, 0xc2, 0x54, 0x61, 0x1a, 0xdf, 0x56,
      0x9c, 0x2d, 0x58, 0x3b, 0x17, 0x54, 0x2b, 0x15, 0x38, 0xca, 0xa0,
      0x00, 0x19, 0x67, 0xf0, 0xa4, 0xbc, 0x34, 0xb8, 0xb7, 0x89},
     false,
     true},

    // Comment: edge case private key
    // tcID: 176
    {176,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x5e, 0xcb, 0xe4, 0xd1, 0xa6, 0x33, 0x0a, 0x44, 0xc8, 0xf7,
      0xef, 0x95, 0x1d, 0x4b, 0xf1, 0x65, 0xe6, 0xc6, 0xb7, 0x21, 0xef, 0xad,
      0xa9, 0x85, 0xfb, 0x41, 0x66, 0x1b, 0xc6, 0xe7, 0xfd, 0x6c, 0x87, 0x34,
      0x64, 0x0c, 0x49, 0x98, 0xff, 0x7e, 0x37, 0x4b, 0x06, 0xce, 0x1a, 0x64,
      0xa2, 0xec, 0xd8, 0x2a, 0xb0, 0x36, 0x38, 0x4f, 0xb8, 0x3d, 0x9a, 0x79,
      0xb1, 0x27, 0xa2, 0x7d, 0x50, 0x32},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0x85, 0xa0, 0xb5, 0x85, 0x19, 0xb2, 0x8e, 0x70, 0xa6, 0x94, 0xec,
      0x51, 0x98, 0xf7, 0x2c, 0x4b, 0xfd, 0xab, 0xaa, 0x30, 0xa7, 0x0f,
      0x71, 0x43, 0xb5, 0xb1, 0xcd, 0x75, 0x36, 0xf7, 0x16, 0xca},
     false,
     true},

    // Comment: edge case private key
    // tcID: 177
    {177,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x69, 0xc0, 0xe7, 0x67, 0xf9, 0xbe, 0xaa, 0xbf, 0xdb, 0xcd,
      0xf3, 0x04, 0xa0, 0xec, 0x68, 0xb5, 0xf6, 0xd6, 0x71, 0x03, 0xcf, 0x37,
      0x58, 0x9f, 0xd8, 0x46, 0xda, 0x1a, 0x1d, 0xd4, 0x47, 0xb3, 0xc5, 0x17,
      0x41, 0x6e, 0x45, 0x01, 0x44, 0x63, 0xfc, 0x9c, 0xf1, 0xc4, 0x04, 0x7d,
      0x02, 0xac, 0xe4, 0x5d, 0xa4, 0x73, 0x91, 0x6a, 0xa5, 0x1d, 0x7b, 0x2d,
      0xc3, 0xd0, 0x80, 0x33, 0x45, 0x2b},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0xa3, 0x29, 0xa7, 0xd8, 0x04, 0x24, 0xea, 0x2d, 0x6c, 0x90, 0x43,
      0x93, 0x80, 0x8e, 0x51, 0x0d, 0xfb, 0xb2, 0x81, 0x55, 0x09, 0x2f,
      0x1b, 0xac, 0x28, 0x4d, 0xce, 0xda, 0x1f, 0x13, 0xaf, 0xe5},
     false,
     true},

    // Comment: edge case private key
    // tcID: 178
    {178,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9b, 0xbf, 0x06, 0xda, 0xd9, 0xab, 0x59, 0x05, 0xe0, 0x54,
      0x71, 0xce, 0x16, 0xd5, 0x22, 0x2c, 0x89, 0xc2, 0xca, 0xa3, 0x9f, 0x26,
      0x26, 0x7a, 0xc0, 0x74, 0x71, 0x29, 0x88, 0x5f, 0xbd, 0x44, 0x1b, 0xcc,
      0x7f, 0xa8, 0x4d, 0xe1, 0x20, 0xa3, 0x67, 0x55, 0xda, 0xf3, 0x0a, 0x6f,
      0x47, 0xe8, 0xc0, 0xd4, 0xbd, 0xdc, 0x15, 0x03, 0x6e, 0xd2, 0xa3, 0x44,
      0x7d, 0xfa, 0x7a, 0x1d, 0x3e, 0x88},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0xbd, 0x26, 0xd0, 0x29, 0x3e, 0x88, 0x51, 0xc5, 0x1e, 0xbe, 0x0d,
      0x42, 0x63, 0x45, 0x68, 0x3a, 0xe9, 0x40, 0x26, 0xac, 0xa5, 0x45,
      0x28, 0x2a, 0x47, 0x59, 0xfa, 0xa8, 0x5f, 0xde, 0x66, 0x87},
     false,
     true},

    // Comment: edge case private key
    // tcID: 179
    {179,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xc1, 0xd1, 0x72, 0x69, 0xe4, 0x6e, 0x38, 0x7a, 0xcb, 0xe2,
      0x99, 0xec, 0x2c, 0xc9, 0xcc, 0x2d, 0xad, 0xa3, 0xf0, 0x5e, 0x4c, 0xf4,
      0x12, 0xf2, 0xad, 0x94, 0x6b, 0x70, 0x0a, 0xa2, 0x61, 0x3a, 0xed, 0xb7,
      0x74, 0x4f, 0x37, 0x0c, 0x13, 0xa4, 0xf4, 0x99, 0x57, 0xd5, 0x4f, 0xf7,
      0x98, 0x11, 0x9d, 0x11, 0x1f, 0x69, 0x12, 0x9c, 0x24, 0xdb, 0x5f, 0x5f,
      0xb8, 0x41, 0x62, 0x90, 0x9d, 0xbb},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0xea, 0x93, 0x50, 0xb2, 0x49, 0x0a, 0x20, 0x10, 0xc7, 0xab, 0xf4,
      0x3f, 0xb1, 0xa3, 0x8b, 0xe7, 0x29, 0xa2, 0xde, 0x37, 0x5e, 0xa7,
      0xa6, 0xac, 0x34, 0xff, 0x58, 0xcc, 0x87, 0xe5, 0x1b, 0x6c},
     false,
     true},

    // Comment: edge case private key
    // tcID: 180
    {180,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x77, 0xb2, 0x0a, 0x91, 0x2e, 0x6b, 0x23, 0x13, 0x50, 0x66,
      0xe9, 0x11, 0x89, 0x15, 0x24, 0xbc, 0x4e, 0xfe, 0x35, 0x60, 0xe3, 0xe9,
      0x23, 0x50, 0xb5, 0x2d, 0xec, 0x8f, 0x37, 0x5f, 0x2b, 0x54, 0xa3, 0xdc,
      0x29, 0x18, 0x25, 0xce, 0xa3, 0xf7, 0xf7, 0xb1, 0x0b, 0xfc, 0xdd, 0x03,
      0x8a, 0x72, 0xdf, 0x62, 0x3d, 0xa1, 0xe8, 0x50, 0xe0, 0xf1, 0xca, 0xa8,
      0x01, 0xfc, 0xd6, 0xcc, 0x67, 0xff},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0x34, 0xee, 0xd3, 0xf6, 0x67, 0x3d, 0x34, 0x0b, 0x6f, 0x71, 0x69,
      0x13, 0xf6, 0xdf, 0xa3, 0x6b, 0x5a, 0xc8, 0x5f, 0xa6, 0x67, 0x79,
      0x1e, 0x2d, 0x6a, 0x21, 0x7b, 0x0c, 0x0b, 0x7b, 0xa8, 0x07},
     false,
     true},

    // Comment: edge case private key
    // tcID: 181
    {181,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x83,
      0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x0f, 0xa8, 0x22, 0xbc, 0x28, 0x11, 0xaa, 0xa5, 0x84, 0x92,
      0x59, 0x2e, 0x32, 0x6e, 0x25, 0xde, 0x29, 0x49, 0x3b, 0xaa, 0xad, 0x65,
      0x1f, 0x7e, 0x90, 0xe7, 0x5c, 0xb4, 0x8e, 0x14, 0xdb, 0x63, 0x40, 0x0b,
      0xb5, 0x16, 0x0a, 0x24, 0x57, 0xf3, 0x90, 0xb5, 0x2b, 0x43, 0x4c, 0x20,
      0xe7, 0x74, 0xcb, 0x4e, 0x59, 0xb0, 0xaf, 0x01, 0x7d, 0x0a, 0x1b, 0xee,
      0xdb, 0xab, 0xa0, 0xb9, 0xd1, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0x13, 0x54, 0xce, 0x66, 0x92, 0xc9, 0xdf, 0x7b, 0x6f, 0xc3, 0x11,
      0x9d, 0x47, 0xc5, 0x63, 0x38, 0xaf, 0xbe, 0xdc, 0xcb, 0x62, 0xfa,
      0xa5, 0x46, 0xc0, 0xfe, 0x6e, 0xd4, 0x95, 0x9e, 0x41, 0xc3},
     false,
     true},

    // Comment: edge case private key
    // tcID: 182
    {182,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
      0xf3, 0xa9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x54, 0xcc, 0xc9, 0x41, 0x50, 0x26, 0xd7, 0x3f, 0x20, 0xa8,
      0x45, 0xb7, 0x2a, 0x58, 0xe5, 0xb1, 0x8b, 0xd2, 0x7f, 0x19, 0x85, 0x42,
      0xa0, 0xbe, 0xee, 0xa6, 0xbc, 0x92, 0x07, 0x1e, 0x5c, 0x83, 0xe3, 0xbc,
      0xc0, 0xb9, 0x4b, 0xae, 0xba, 0xce, 0xc5, 0x70, 0x78, 0xea, 0x25, 0x2d,
      0x40, 0xdd, 0x6d, 0x61, 0xf4, 0x34, 0xa2, 0x71, 0x1b, 0x69, 0x30, 0x2f,
      0x71, 0x08, 0xeb, 0xf6, 0xe9, 0x5e},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0xfe, 0x74, 0x96, 0xc3, 0x0d, 0x53, 0x49, 0x95, 0xf0, 0xbf, 0x42,
      0x8b, 0x54, 0x71, 0xc2, 0x15, 0x85, 0xaa, 0xaf, 0xc8, 0x17, 0x33,
      0x91, 0x6f, 0x01, 0x65, 0x59, 0x7a, 0x55, 0xd1, 0x2c, 0xb4},
     false,
     true},

    // Comment: edge case private key
    // tcID: 183
    {183,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
      0xf3, 0xb1, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xc9, 0x0e, 0x30, 0x08, 0x39, 0xdd, 0x58, 0x95, 0x1e, 0x80,
      0x95, 0x70, 0x63, 0x15, 0x44, 0x03, 0xcb, 0x4e, 0x66, 0x44, 0xc7, 0x74,
      0x36, 0x48, 0x13, 0xd0, 0x0c, 0x24, 0x8f, 0xa8, 0xee, 0x41, 0x9d, 0x0a,
      0xfb, 0xe7, 0x92, 0xe6, 0x18, 0xc4, 0x63, 0xf8, 0xef, 0x39, 0xac, 0x7b,
      0xfc, 0x9d, 0xaf, 0xba, 0xac, 0xb9, 0xe8, 0x53, 0x32, 0x91, 0xb8, 0x59,
      0xc9, 0x98, 0x3c, 0x28, 0x3e, 0x51},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0x34, 0x8b, 0xf8, 0x04, 0x2e, 0x4e, 0xdf, 0x1d, 0x03, 0xc8, 0xb3,
      0x6a, 0xb8, 0x15, 0x15, 0x6e, 0x77, 0xc2, 0x01, 0xb7, 0x64, 0xed,
      0x45, 0x62, 0xcf, 0xe2, 0xee, 0x90, 0x63, 0x8f, 0xfe, 0xf5},
     false,
     true},

    // Comment: edge case private key
    // tcID: 184
    {184,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
      0xf3, 0xb9, 0xca, 0xc1, 0xfc, 0x63, 0x25, 0x51, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x7f, 0xe3, 0x6b, 0x40, 0xaf, 0x22, 0xaf, 0x89, 0x21, 0x65,
      0x6b, 0x32, 0x26, 0x2c, 0x71, 0xda, 0x1a, 0xb9, 0x19, 0x36, 0x5c, 0x65,
      0xdf, 0xb6, 0x3a, 0x5a, 0x9e, 0x22, 0x18, 0x5a, 0x59, 0x43, 0x19, 0x68,
      0x2b, 0xa6, 0xda, 0x49, 0xc9, 0xdc, 0x60, 0xf6, 0x0b, 0xfb, 0xf8, 0x23,
      0x59, 0x0e, 0x8b, 0x4c, 0x2a, 0x7a, 0x84, 0x75, 0x0d, 0xed, 0x2a, 0xf2,
      0xea, 0xd3, 0x96, 0x63, 0x5e, 0xfe},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0x6e, 0x4e, 0xc5, 0x47, 0x9a, 0x7c, 0x20, 0xa5, 0x37, 0x50, 0x17,
      0x00, 0x48, 0x4f, 0x6f, 0x43, 0x3a, 0x8a, 0x8f, 0xe5, 0x3c, 0x28,
      0x8f, 0x7a, 0x25, 0xc8, 0xe8, 0xc9, 0x2d, 0x39, 0xe8, 0xdc},
     false,
     true},

    // Comment: edge case private key
    // tcID: 185
    {185,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
      0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x24, 0xf3, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x80, 0xd1, 0x99, 0x7e, 0xbd, 0xbe, 0x8e, 0x54, 0xe0, 0x55,
      0x96, 0x19, 0x6c, 0x7a, 0x95, 0xec, 0x3a, 0x53, 0xe2, 0x67, 0xba, 0x2a,
      0x24, 0x71, 0x99, 0x60, 0xaa, 0x57, 0x7e, 0x61, 0x50, 0xe4, 0x0c, 0x69,
      0x6b, 0x01, 0x47, 0xdb, 0x06, 0x59, 0x5b, 0x27, 0x28, 0x4a, 0x0c, 0x16,
      0x52, 0x4c, 0x01, 0x11, 0xe9, 0x8d, 0x4a, 0x46, 0x58, 0xa5, 0xab, 0xb9,
      0x38, 0xe7, 0x7d, 0x57, 0x82, 0xed},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0xf7, 0x40, 0x7d, 0x61, 0xfd, 0xf5, 0x81, 0xbe, 0x4f, 0x56, 0x46,
      0x21, 0xd5, 0x90, 0xca, 0x9b, 0x7b, 0xa3, 0x7f, 0x31, 0x39, 0x61,
      0x50, 0xf9, 0x92, 0x2f, 0x15, 0x01, 0xda, 0x8c, 0x83, 0xef},
     false,
     true},

    // Comment: edge case private key
    // tcID: 186
    {186,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
      0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x33, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x40, 0x9f, 0x8d, 0xa2, 0x1a, 0xea, 0x23, 0x6a, 0x5f, 0x5a,
      0x19, 0x04, 0xd0, 0x31, 0x0c, 0x1c, 0x61, 0x92, 0xa6, 0x7d, 0x0d, 0xa0,
      0x89, 0x36, 0x31, 0x98, 0x69, 0xa8, 0xad, 0x08, 0x38, 0xa3, 0x8f, 0x23,
      0x08, 0x4d, 0x30, 0xff, 0x71, 0xa9, 0xf1, 0xd9, 0x18, 0xd4, 0x2c, 0x42,
      0xbf, 0x08, 0xc1, 0x66, 0x5f, 0x14, 0xe9, 0xd5, 0x98, 0x6c, 0x1e, 0x9c,
      0x2d, 0x38, 0xd5, 0xe1, 0x70, 0xa5},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0x82, 0x23, 0x6f, 0xd2, 0x72, 0x20, 0x86, 0x93, 0xe0, 0x57, 0x45,
      0x55, 0xca, 0x46, 0x5c, 0x6c, 0xc5, 0x12, 0x16, 0x34, 0x86, 0x08,
      0x4f, 0xa5, 0x7f, 0x5e, 0x1b, 0xd2, 0xe2, 0xcc, 0xc0, 0xb3},
     false,
     true},

    // Comment: edge case private key
    // tcID: 187
    {187,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
      0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x43, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x54, 0xe7, 0x7a, 0x00, 0x1c, 0x38, 0x62, 0xb9, 0x7a, 0x76,
      0x64, 0x7f, 0x43, 0x36, 0xdf, 0x3c, 0xf1, 0x26, 0xac, 0xbe, 0x7a, 0x06,
      0x9c, 0x5e, 0x57, 0x09, 0x27, 0x73, 0x24, 0xd2, 0x92, 0x0b, 0x0a, 0x66,
      0x0e, 0x43, 0xd6, 0x0b, 0xce, 0x8b, 0xbd, 0xed, 0xe0, 0x73, 0xfa, 0x5d,
      0x18, 0x3c, 0x8e, 0x8e, 0x15, 0x89, 0x8c, 0xaf, 0x6f, 0xf7, 0xe4, 0x58,
      0x37, 0xd0, 0x9f, 0x2f, 0x4c, 0x8a},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0x06, 0x53, 0x71, 0x49, 0x66, 0x4d, 0xba, 0x1a, 0x99, 0x24, 0x65,
      0x4c, 0xb7, 0xf7, 0x87, 0xed, 0x22, 0x48, 0x51, 0xb0, 0xdf, 0x25,
      0xef, 0x53, 0xfc, 0xf5, 0x4f, 0x8f, 0x26, 0xcd, 0x5f, 0x3f},
     false,
     true},

    // Comment: edge case private key
    // tcID: 188
    {188,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
      0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4b, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb0, 0x1a, 0x17, 0x2a, 0x76, 0xa4, 0x60, 0x2c, 0x92, 0xd3,
      0x24, 0x2c, 0xb8, 0x97, 0xdd, 0xe3, 0x02, 0x4c, 0x74, 0x0d, 0xeb, 0xb2,
      0x15, 0xb4, 0xc6, 0xb0, 0xaa, 0xe9, 0x3c, 0x22, 0x91, 0xa9, 0x17, 0xa3,
      0xef, 0x8a, 0xcd, 0xc8, 0x25, 0x2b, 0x90, 0x13, 0xf1, 0xd2, 0x04, 0x58,
      0xfc, 0x86, 0xe3, 0xff, 0x08, 0x90, 0xe3, 0x81, 0xe9, 0x42, 0x02, 0x83,
      0xb7, 0xac, 0x70, 0x38, 0x80, 0x1d},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0xf2, 0xb3, 0x85, 0x39, 0xbc, 0xe9, 0x95, 0xd4, 0x43, 0xc7, 0xbf,
      0xee, 0xef, 0xad, 0xc9, 0xe4, 0x2c, 0xc2, 0xc8, 0x9c, 0x60, 0xbf,
      0x4e, 0x86, 0xea, 0xc9, 0x5d, 0x51, 0x98, 0x7b, 0xd1, 0x12},
     false,
     true},

    // Comment: edge case private key
    // tcID: 189
    {189,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
      0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4e, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x5e, 0xcb, 0xe4, 0xd1, 0xa6, 0x33, 0x0a, 0x44, 0xc8, 0xf7,
      0xef, 0x95, 0x1d, 0x4b, 0xf1, 0x65, 0xe6, 0xc6, 0xb7, 0x21, 0xef, 0xad,
      0xa9, 0x85, 0xfb, 0x41, 0x66, 0x1b, 0xc6, 0xe7, 0xfd, 0x6c, 0x78, 0xcb,
      0x9b, 0xf2, 0xb6, 0x67, 0x00, 0x82, 0xc8, 0xb4, 0xf9, 0x31, 0xe5, 0x9b,
      0x5d, 0x13, 0x27, 0xd5, 0x4f, 0xca, 0xc7, 0xb0, 0x47, 0xc2, 0x65, 0x86,
      0x4e, 0xd8, 0x5d, 0x82, 0xaf, 0xcd},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0x85, 0xa0, 0xb5, 0x85, 0x19, 0xb2, 0x8e, 0x70, 0xa6, 0x94, 0xec,
      0x51, 0x98, 0xf7, 0x2c, 0x4b, 0xfd, 0xab, 0xaa, 0x30, 0xa7, 0x0f,
      0x71, 0x43, 0xb5, 0xb1, 0xcd, 0x75, 0x36, 0xf7, 0x16, 0xca},
     false,
     true},

    // Comment: edge case private key
    // tcID: 190
    {190,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84,
      0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4f, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e, 0x8a, 0x52,
      0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2, 0x77, 0xf2,
      0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78, 0xf8, 0x88,
      0xaa, 0xee, 0x24, 0x71, 0x2f, 0xc0, 0xd6, 0xc2, 0x65, 0x39, 0x60, 0x8b,
      0xcf, 0x24, 0x45, 0x82, 0x52, 0x1a, 0xc3, 0x16, 0x7d, 0xd6, 0x61, 0xfb,
      0x48, 0x62, 0xdd, 0x87, 0x8c, 0x2e},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x31, 0x02, 0x8f, 0x33, 0x77, 0xfc, 0x8f, 0x2b, 0x19,
      0x67, 0xed, 0xaa, 0xb9, 0x02, 0x13, 0xac, 0xad, 0x0d, 0xa9, 0xf5, 0x08,
      0x97, 0xf0, 0x8f, 0x57, 0x53, 0x7f, 0x78, 0xf1, 0x16, 0x74, 0x47, 0x43,
      0xa1, 0x93, 0x01, 0x89, 0x36, 0x3b, 0xbd, 0xe2, 0xac, 0x4c, 0xbd, 0x16,
      0x49, 0xcd, 0xc6, 0xf4, 0x51, 0xad, 0xd7, 0x1d, 0xd2, 0xf1, 0x6a, 0x8a,
      0x86, 0x7f, 0x2b, 0x17, 0xca, 0xa1, 0x6b},
     {0x02, 0x7b, 0x01, 0x3a, 0x6f, 0x16, 0x6d, 0xb6, 0x55, 0xd6, 0x9d,
      0x64, 0x3c, 0x12, 0x7e, 0xf8, 0xac, 0xe1, 0x75, 0x31, 0x1e, 0x66,
      0x7d, 0xff, 0x25, 0x20, 0xf5, 0xb5, 0xc7, 0x5b, 0x76, 0x59},
     false,
     true},

    // Comment: CVE-2017-8932
    // tcID: 191
    {191,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x2a, 0x26, 0x5f, 0x8b, 0xcb, 0xdc, 0xaf, 0x94, 0xd5, 0x85, 0x19, 0x14,
      0x1e, 0x57, 0x81, 0x24, 0xcb, 0x40, 0xd6, 0x4a, 0x50, 0x1f, 0xba, 0x9c,
      0x11, 0x84, 0x7b, 0x28, 0x96, 0x5b, 0xc7, 0x37, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x1c, 0x00, 0x7c, 0xee, 0xcf, 0x21, 0x56, 0x08, 0x67, 0x7a,
      0x28, 0x7f, 0x8e, 0x70, 0xba, 0x6e, 0xd5, 0xc0, 0x46, 0x58, 0x44, 0xbd,
      0x88, 0xc9, 0xe3, 0x51, 0x71, 0x31, 0x2f, 0x34, 0x68, 0xa6, 0x0e, 0x0b,
      0xb1, 0x9e, 0x53, 0x3e, 0xb4, 0xc1, 0x16, 0x2b, 0xda, 0xaf, 0xcb, 0x05,
      0x34, 0x83, 0xb1, 0xc0, 0x75, 0x9f, 0x8c, 0xe0, 0x36, 0x0f, 0xc3, 0xc8,
      0x8c, 0xd0, 0x7d, 0x50, 0xea, 0xb9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x02, 0x38, 0x19, 0x81, 0x3a, 0xc9, 0x69, 0x84, 0x70,
      0x59, 0x02, 0x8e, 0xa8, 0x8a, 0x1f, 0x30, 0xdf, 0xbc, 0xde, 0x03, 0xfc,
      0x79, 0x1d, 0x3a, 0x25, 0x2c, 0x6b, 0x41, 0x21, 0x18, 0x82, 0xea, 0xf9,
      0x3e, 0x4a, 0xe4, 0x33, 0xcc, 0x12, 0xcf, 0x2a, 0x43, 0xfc, 0x0e, 0xf2,
      0x64, 0x00, 0xc0, 0xe1, 0x25, 0x50, 0x82, 0x24, 0xcd, 0xb6, 0x49, 0x38,
      0x0f, 0x25, 0x47, 0x91, 0x48, 0xa4, 0xad},
     {0x4d, 0x4d, 0xe8, 0x0f, 0x15, 0x34, 0x85, 0x0d, 0x26, 0x10, 0x75,
      0x99, 0x7e, 0x30, 0x49, 0x32, 0x1a, 0x08, 0x64, 0x08, 0x2d, 0x24,
      0xa9, 0x17, 0x86, 0x33, 0x66, 0xc0, 0x72, 0x4f, 0x5a, 0xe3},
     false,
     true},

    // Comment: CVE-2017-8932
    // tcID: 192
    {192,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x31, 0x3f, 0x72, 0xff, 0x9f, 0xe8, 0x11, 0xbf, 0x57, 0x31, 0x76, 0x23,
      0x1b, 0x28, 0x6a, 0x3b, 0xdb, 0x6f, 0x1b, 0x14, 0xe0, 0x5c, 0x40, 0x14,
      0x65, 0x90, 0x72, 0x7a, 0x71, 0xc3, 0xbc, 0xcd, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x5a, 0x06, 0x2b, 0x0b, 0x18, 0x92, 0x13, 0x17, 0xaf, 0xfb,
      0xb3, 0xd4, 0x2c, 0x3d, 0xbf, 0xca, 0xb2, 0x96, 0xcb, 0xf2, 0x30, 0x41,
      0xa6, 0x00, 0x82, 0x04, 0xc3, 0xb8, 0x31, 0xc6, 0xdf, 0x6e, 0x60, 0x66,
      0x75, 0x9d, 0xb0, 0x02, 0xbe, 0x5a, 0x2f, 0x2e, 0x9a, 0xe4, 0x80, 0xda,
      0x24, 0x8b, 0x0b, 0x2a, 0x99, 0x30, 0x2d, 0x59, 0x2d, 0xe5, 0x52, 0x93,
      0xd1, 0x63, 0x41, 0x24, 0x63, 0xd6},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xcc, 0x11, 0x88, 0x7b, 0x2d, 0x66, 0xcb, 0xae, 0x8f,
      0x4d, 0x30, 0x66, 0x27, 0x19, 0x25, 0x22, 0x93, 0x21, 0x46, 0xb4, 0x2f,
      0x01, 0xd3, 0xc6, 0xf9, 0x2b, 0xd5, 0xc8, 0xba, 0x73, 0x9b, 0x06, 0xa2,
      0xf0, 0x8a, 0x02, 0x9c, 0xd0, 0x6b, 0x46, 0x18, 0x30, 0x85, 0xba, 0xe9,
      0x24, 0x8b, 0x0e, 0xd1, 0x5b, 0x70, 0x28, 0x0c, 0x7e, 0xf1, 0x3a, 0x45,
      0x7f, 0x5a, 0xf3, 0x82, 0x42, 0x60, 0x31},
     {0x83, 0x1c, 0x3f, 0x6b, 0x5f, 0x76, 0x2d, 0x2f, 0x46, 0x19, 0x01,
      0x57, 0x7a, 0xf4, 0x13, 0x54, 0xac, 0x5f, 0x22, 0x8c, 0x25, 0x91,
      0xf8, 0x4f, 0x8a, 0x6e, 0x51, 0xe2, 0xe3, 0xf1, 0x79, 0x91},
     false,
     true},

    // Comment: point is not on curve
    // tcID: 193
    {193,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 194
    {194,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 195
    {195,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 196
    {196,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 197
    {197,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 198
    {198,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 199
    {199,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 200
    {200,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 201
    {201,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 202
    {202,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 203
    {203,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 204
    {204,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 205
    {205,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 206
    {206,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 207
    {207,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe},
     {},
     false,
     false},

    // Comment: point is not on curve
    // tcID: 208
    {208,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
     {},
     false,
     false},

    // Comment:
    // tcID: 209
    {209,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x7e, 0x4a, 0xa5, 0x4f, 0x71, 0x4b, 0xf0, 0x1d, 0xf8, 0x5c, 0x50, 0x26,
      0x9b, 0xea, 0x3a, 0x86, 0x72, 0x1f, 0x84, 0xaf, 0xe7, 0x4f, 0x7b, 0x41,
      0xea, 0x58, 0xab, 0xcf, 0x34, 0x74, 0xe8, 0x8d, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x47, 0xf6, 0x7d, 0xe3, 0x5e, 0x5c, 0xb4, 0x32, 0xb0, 0x57,
      0xe8, 0xa0, 0xd0, 0xff, 0x62, 0x2e, 0xb6, 0x98, 0xb3, 0x4b, 0xc9, 0xff,
      0xe5, 0x23, 0x51, 0x19, 0x36, 0x63, 0xcc, 0x6e, 0x72, 0x74, 0x14, 0x0f,
      0x81, 0x5e, 0xf6, 0x1f, 0xf6, 0xed, 0x06, 0xdf, 0x0a, 0x15, 0x03, 0x66,
      0xea, 0xbc, 0xfb, 0x18, 0xed, 0xa1, 0xce, 0xe3, 0xd4, 0xb3, 0x0f, 0x2d,
      0x15, 0xd4, 0xa4, 0xfa, 0xe5, 0x17},
     {0x30, 0x18, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x01, 0x00},
     {},
     false,
     false},

    // Comment: public point not on curve
    // tcID: 210
    {210,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18, 0x9c, 0x3d, 0x52, 0x3f,
      0xf9, 0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6, 0x96, 0x8d, 0x8d, 0xc7,
      0xdd, 0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e, 0xa6, 0x0c, 0xdc, 0xfa,
      0xfb, 0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29, 0xee, 0x59, 0x25, 0x6f,
      0x53, 0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1, 0xbb, 0x0a, 0x95, 0xb2,
      0x56, 0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4c},
     {},
     false,
     false},

    // Comment: public point = (0,0)
    // tcID: 211
    {211,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {},
     false,
     false},

    // Comment: order =
    // -115792089210356248762697446949407573529996955224135760342422259061068512044369
    // tcID: 212
    {212,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x33, 0x30, 0x81, 0xec, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xe0, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x6b, 0x17, 0xd1,
      0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40,
      0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39,
      0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f,
      0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33,
      0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51,
      0xf5, 0x02, 0x21, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x19, 0x05, 0x52,
      0x58, 0xe8, 0x61, 0x7b, 0x0c, 0x46, 0x35, 0x3d, 0x03, 0x9c, 0xda, 0xaf,
      0x02, 0x01, 0x01, 0x03, 0x42, 0x00, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18,
      0x9c, 0x3d, 0x52, 0x3f, 0xf9, 0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6,
      0x96, 0x8d, 0x8d, 0xc7, 0xdd, 0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e,
      0xa6, 0x0c, 0xdc, 0xfa, 0xfb, 0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29,
      0xee, 0x59, 0x25, 0x6f, 0x53, 0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1,
      0xbb, 0x0a, 0x95, 0xb2, 0x56, 0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: order = 0
    // tcID: 213
    {213,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x13, 0x30, 0x81, 0xcc, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xc0, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x6b, 0x17, 0xd1,
      0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40,
      0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39,
      0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f,
      0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33,
      0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51,
      0xf5, 0x02, 0x01, 0x00, 0x02, 0x01, 0x01, 0x03, 0x42, 0x00, 0x04, 0x15,
      0x10, 0x26, 0x4c, 0x18, 0x9c, 0x3d, 0x52, 0x3f, 0xf9, 0x91, 0x6a, 0xbd,
      0x70, 0x69, 0xef, 0xa6, 0x96, 0x8d, 0x8d, 0xc7, 0xdd, 0xb6, 0x45, 0x7d,
      0x78, 0x69, 0xb5, 0x3e, 0xa6, 0x0c, 0xdc, 0xfa, 0xfb, 0x7e, 0xd4, 0x78,
      0x6d, 0xa1, 0x5d, 0x29, 0xee, 0x59, 0x25, 0x6f, 0x53, 0x6d, 0xa3, 0x57,
      0x5a, 0x48, 0x88, 0xc1, 0xbb, 0x0a, 0x95, 0xb2, 0x56, 0xf4, 0xa7, 0xe9,
      0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: order = 1
    // tcID: 214
    {214,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x13, 0x30, 0x81, 0xcc, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xc0, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x6b, 0x17, 0xd1,
      0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40,
      0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39,
      0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f,
      0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33,
      0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51,
      0xf5, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01, 0x03, 0x42, 0x00, 0x04, 0x15,
      0x10, 0x26, 0x4c, 0x18, 0x9c, 0x3d, 0x52, 0x3f, 0xf9, 0x91, 0x6a, 0xbd,
      0x70, 0x69, 0xef, 0xa6, 0x96, 0x8d, 0x8d, 0xc7, 0xdd, 0xb6, 0x45, 0x7d,
      0x78, 0x69, 0xb5, 0x3e, 0xa6, 0x0c, 0xdc, 0xfa, 0xfb, 0x7e, 0xd4, 0x78,
      0x6d, 0xa1, 0x5d, 0x29, 0xee, 0x59, 0x25, 0x6f, 0x53, 0x6d, 0xa3, 0x57,
      0x5a, 0x48, 0x88, 0xc1, 0xbb, 0x0a, 0x95, 0xb2, 0x56, 0xf4, 0xa7, 0xe9,
      0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: order =
    // 26959946660873538060741835960514744168612397095220107664918121663170
    // tcID: 215
    {215,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x2f, 0x30, 0x81, 0xe8, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xdc, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x6b, 0x17, 0xd1,
      0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40,
      0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39,
      0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f,
      0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33,
      0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51,
      0xf5, 0x02, 0x1d, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0x02, 0x01, 0x01, 0x03,
      0x42, 0x00, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18, 0x9c, 0x3d, 0x52, 0x3f,
      0xf9, 0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6, 0x96, 0x8d, 0x8d, 0xc7,
      0xdd, 0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e, 0xa6, 0x0c, 0xdc, 0xfa,
      0xfb, 0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29, 0xee, 0x59, 0x25, 0x6f,
      0x53, 0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1, 0xbb, 0x0a, 0x95, 0xb2,
      0x56, 0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: generator = (0,0)
    // tcID: 216
    {216,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x33, 0x30, 0x81, 0xec, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xe0, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51,
      0x02, 0x01, 0x01, 0x03, 0x42, 0x00, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18,
      0x9c, 0x3d, 0x52, 0x3f, 0xf9, 0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6,
      0x96, 0x8d, 0x8d, 0xc7, 0xdd, 0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e,
      0xa6, 0x0c, 0xdc, 0xfa, 0xfb, 0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29,
      0xee, 0x59, 0x25, 0x6f, 0x53, 0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1,
      0xbb, 0x0a, 0x95, 0xb2, 0x56, 0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: generator not on curve
    // tcID: 217
    {217,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x33, 0x30, 0x81, 0xec, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xe0, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x6b, 0x17, 0xd1,
      0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40,
      0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39,
      0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f,
      0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33,
      0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51,
      0xf7, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51,
      0x02, 0x01, 0x01, 0x03, 0x42, 0x00, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18,
      0x9c, 0x3d, 0x52, 0x3f, 0xf9, 0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6,
      0x96, 0x8d, 0x8d, 0xc7, 0xdd, 0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e,
      0xa6, 0x0c, 0xdc, 0xfa, 0xfb, 0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29,
      0xee, 0x59, 0x25, 0x6f, 0x53, 0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1,
      0xbb, 0x0a, 0x95, 0xb2, 0x56, 0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: cofactor = -1
    // tcID: 218
    {218,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x33, 0x30, 0x81, 0xec, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xe0, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x6b, 0x17, 0xd1,
      0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40,
      0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39,
      0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f,
      0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33,
      0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51,
      0xf5, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51,
      0x02, 0x01, 0xff, 0x03, 0x42, 0x00, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18,
      0x9c, 0x3d, 0x52, 0x3f, 0xf9, 0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6,
      0x96, 0x8d, 0x8d, 0xc7, 0xdd, 0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e,
      0xa6, 0x0c, 0xdc, 0xfa, 0xfb, 0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29,
      0xee, 0x59, 0x25, 0x6f, 0x53, 0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1,
      0xbb, 0x0a, 0x95, 0xb2, 0x56, 0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: cofactor = 0
    // tcID: 219
    {219,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x33, 0x30, 0x81, 0xec, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xe0, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x6b, 0x17, 0xd1,
      0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40,
      0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39,
      0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f,
      0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33,
      0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51,
      0xf5, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51,
      0x02, 0x01, 0x00, 0x03, 0x42, 0x00, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18,
      0x9c, 0x3d, 0x52, 0x3f, 0xf9, 0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6,
      0x96, 0x8d, 0x8d, 0xc7, 0xdd, 0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e,
      0xa6, 0x0c, 0xdc, 0xfa, 0xfb, 0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29,
      0xee, 0x59, 0x25, 0x6f, 0x53, 0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1,
      0xbb, 0x0a, 0x95, 0xb2, 0x56, 0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: cofactor = 2
    // tcID: 220
    {220,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x33, 0x30, 0x81, 0xec, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xe0, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x6b, 0x17, 0xd1,
      0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40,
      0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39,
      0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f,
      0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33,
      0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51,
      0xf5, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51,
      0x02, 0x01, 0x02, 0x03, 0x42, 0x00, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18,
      0x9c, 0x3d, 0x52, 0x3f, 0xf9, 0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6,
      0x96, 0x8d, 0x8d, 0xc7, 0xdd, 0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e,
      0xa6, 0x0c, 0xdc, 0xfa, 0xfb, 0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29,
      0xee, 0x59, 0x25, 0x6f, 0x53, 0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1,
      0xbb, 0x0a, 0x95, 0xb2, 0x56, 0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: cofactor =
    // 115792089210356248762697446949407573529996955224135760342422259061068512044369
    // tcID: 221
    {221,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x55, 0x30, 0x82, 0x01, 0x0d, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x30, 0x82, 0x01, 0x00, 0x02, 0x01, 0x01,
      0x30, 0x2c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02,
      0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44,
      0x04, 0x20, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20,
      0x5a, 0xc6, 0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55,
      0x76, 0x98, 0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6,
      0x3b, 0xce, 0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x6b,
      0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63,
      0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4,
      0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f, 0xe3, 0x42, 0xe2, 0xfe,
      0x1a, 0x7f, 0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b,
      0xce, 0x33, 0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37,
      0xbf, 0x51, 0xf5, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
      0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6,
      0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63,
      0x25, 0x51, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa,
      0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25,
      0x51, 0x03, 0x42, 0x00, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18, 0x9c, 0x3d,
      0x52, 0x3f, 0xf9, 0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6, 0x96, 0x8d,
      0x8d, 0xc7, 0xdd, 0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e, 0xa6, 0x0c,
      0xdc, 0xfa, 0xfb, 0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29, 0xee, 0x59,
      0x25, 0x6f, 0x53, 0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1, 0xbb, 0x0a,
      0x95, 0xb2, 0x56, 0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: cofactor = None
    // tcID: 222
    {222,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x30, 0x30, 0x81, 0xe9, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xdd, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x6b, 0x17, 0xd1,
      0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40,
      0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39,
      0x45, 0xd8, 0x98, 0xc2, 0x96, 0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f,
      0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33,
      0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51,
      0xf5, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51,
      0x03, 0x42, 0x00, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18, 0x9c, 0x3d, 0x52,
      0x3f, 0xf9, 0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6, 0x96, 0x8d, 0x8d,
      0xc7, 0xdd, 0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e, 0xa6, 0x0c, 0xdc,
      0xfa, 0xfb, 0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29, 0xee, 0x59, 0x25,
      0x6f, 0x53, 0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1, 0xbb, 0x0a, 0x95,
      0xb2, 0x56, 0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: modified prime
    // tcID: 223
    {223,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x33, 0x30, 0x81, 0xec, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xe0, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xfd, 0x09, 0x10, 0x59, 0xa6, 0x89, 0x36, 0x35, 0xf9, 0x00, 0xe9, 0x44,
      0x9d, 0x63, 0xf5, 0x72, 0xb2, 0xae, 0xbc, 0x4c, 0xff, 0x7b, 0x4e, 0x5e,
      0x33, 0xf1, 0xb2, 0x00, 0xe8, 0xbb, 0xc1, 0x45, 0x30, 0x44, 0x04, 0x20,
      0x02, 0xf6, 0xef, 0xa5, 0x59, 0x76, 0xc9, 0xcb, 0x06, 0xff, 0x16, 0xbb,
      0x62, 0x9c, 0x0a, 0x8d, 0x4d, 0x51, 0x43, 0xb4, 0x00, 0x84, 0xb1, 0xa1,
      0xcc, 0x0e, 0x4d, 0xff, 0x17, 0x44, 0x3e, 0xb7, 0x04, 0x20, 0x5a, 0xc6,
      0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb, 0xbd, 0x55, 0x76, 0x98,
      0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0, 0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce,
      0x3c, 0x3e, 0x27, 0xd2, 0x60, 0x4b, 0x04, 0x41, 0x04, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x59, 0x7f, 0xa9, 0x4b,
      0x1f, 0xd9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x02, 0x1b, 0x8c, 0x7d, 0xd7, 0x7f, 0x9a, 0x95,
      0x62, 0x79, 0x22, 0xec, 0xee, 0xfe, 0xa7, 0x3f, 0x02, 0x8f, 0x1e, 0xc9,
      0x5b, 0xa9, 0xb8, 0xfa, 0x95, 0xa3, 0xad, 0x24, 0xbd, 0xf9, 0xff, 0xf4,
      0x14, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51,
      0x02, 0x01, 0x01, 0x03, 0x42, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x59, 0x7f, 0xa9, 0x4b, 0x1f, 0xd9,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x02, 0x1b, 0x8c, 0x7d, 0xd7, 0x7f, 0x9a, 0x95, 0x62, 0x79,
      0x22, 0xec, 0xee, 0xfe, 0xa7, 0x3f, 0x02, 0x8f, 0x1e, 0xc9, 0x5b, 0xa9,
      0xb8, 0xfa, 0x95, 0xa3, 0xad, 0x24, 0xbd, 0xf9, 0xff, 0xf4, 0x14},
     {0xce, 0xa0, 0xfb, 0xd8, 0xf2, 0x0a, 0xbc, 0x8c, 0xf8, 0x12, 0x7c,
      0x13, 0x2e, 0x29, 0x75, 0x6d, 0x25, 0xff, 0x15, 0x30, 0xa8, 0x8b,
      0xf5, 0xc9, 0xe2, 0x2d, 0xc1, 0xc1, 0x37, 0xc3, 0x6b, 0xe9},
     false,
     false},

    // Comment: using secp224r1
    // tcID: 224
    {224,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x4e, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x21, 0x03, 0x3a, 0x00, 0x04,
      0x07, 0x4f, 0x56, 0xdc, 0x2e, 0xa6, 0x48, 0xef, 0x89, 0xc3, 0xb7, 0x2e,
      0x23, 0xbb, 0xd2, 0xda, 0x36, 0xf6, 0x02, 0x43, 0xe4, 0xd2, 0x06, 0x7b,
      0x70, 0x60, 0x4a, 0xf1, 0xc2, 0x16, 0x5c, 0xec, 0x2f, 0x86, 0x60, 0x3d,
      0x60, 0xc8, 0xa6, 0x11, 0xd5, 0xb8, 0x4b, 0xa3, 0xd9, 0x1d, 0xfe, 0x1a,
      0x48, 0x08, 0x25, 0xbc, 0xc4, 0xaf, 0x3b, 0xcf},
     {},
     false,
     false},

    // Comment: using secp256k1
    // tcID: 225
    {225,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x56, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x0a, 0x03, 0x42,
      0x00, 0x04, 0xa1, 0x26, 0x3e, 0x75, 0xb8, 0x7a, 0xe0, 0x93, 0x70,
      0x60, 0xff, 0x14, 0x72, 0xf3, 0x30, 0xee, 0x55, 0xcd, 0xf8, 0xf4,
      0x32, 0x9d, 0x62, 0x84, 0xa9, 0xeb, 0xfb, 0xcc, 0x85, 0x6c, 0x11,
      0x68, 0x42, 0x25, 0xe7, 0x2c, 0xbe, 0xbf, 0xf4, 0x1e, 0x54, 0xfb,
      0x6f, 0x00, 0xe1, 0x1a, 0xfe, 0x53, 0xa1, 0x79, 0x37, 0xbe, 0xdb,
      0xf2, 0xdf, 0x78, 0x7f, 0x8e, 0xf9, 0x58, 0x4f, 0x77, 0x58, 0x38},
     {},
     false,
     false},

    // Comment: a = 0
    // tcID: 226
    {226,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x14, 0x30, 0x81, 0xcd, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xc1, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x25, 0x04, 0x01,
      0x00, 0x04, 0x20, 0x1b, 0x95, 0xc2, 0xf4, 0x60, 0x65, 0xdb, 0xf0, 0xf3,
      0xff, 0x09, 0x15, 0x3e, 0x47, 0x48, 0xed, 0x71, 0x59, 0x5e, 0x07, 0x74,
      0xba, 0x8e, 0x25, 0xc3, 0x64, 0xff, 0x1e, 0x6b, 0xe0, 0x39, 0xb7, 0x04,
      0x41, 0x04, 0x15, 0x10, 0x26, 0x4c, 0x18, 0x9c, 0x3d, 0x52, 0x3f, 0xf9,
      0x91, 0x6a, 0xbd, 0x70, 0x69, 0xef, 0xa6, 0x96, 0x8d, 0x8d, 0xc7, 0xdd,
      0xb6, 0x45, 0x7d, 0x78, 0x69, 0xb5, 0x3e, 0xa6, 0x0c, 0xdc, 0xfa, 0xfb,
      0x7e, 0xd4, 0x78, 0x6d, 0xa1, 0x5d, 0x29, 0xee, 0x59, 0x25, 0x6f, 0x53,
      0x6d, 0xa3, 0x57, 0x5a, 0x48, 0x88, 0xc1, 0xbb, 0x0a, 0x95, 0xb2, 0x56,
      0xf4, 0xa7, 0xe9, 0xfd, 0x76, 0x4a, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff,
      0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca,
      0xc2, 0xfc, 0x63, 0x25, 0x51, 0x02, 0x01, 0x01, 0x03, 0x42, 0x00, 0x04,
      0x15, 0x10, 0x26, 0x4c, 0x18, 0x9c, 0x3d, 0x52, 0x3f, 0xf9, 0x91, 0x6a,
      0xbd, 0x70, 0x69, 0xef, 0xa6, 0x96, 0x8d, 0x8d, 0xc7, 0xdd, 0xb6, 0x45,
      0x7d, 0x78, 0x69, 0xb5, 0x3e, 0xa6, 0x0c, 0xdc, 0xfa, 0xfb, 0x7e, 0xd4,
      0x78, 0x6d, 0xa1, 0x5d, 0x29, 0xee, 0x59, 0x25, 0x6f, 0x53, 0x6d, 0xa3,
      0x57, 0x5a, 0x48, 0x88, 0xc1, 0xbb, 0x0a, 0x95, 0xb2, 0x56, 0xf4, 0xa7,
      0xe9, 0xfd, 0x76, 0x4a},
     {0xd0, 0x03, 0xf5, 0xcc, 0x83, 0x85, 0x25, 0x84, 0x06, 0x1f, 0x7a,
      0x8a, 0x28, 0xbc, 0xb5, 0x67, 0x1e, 0xcb, 0xda, 0x09, 0x6e, 0x16,
      0xe7, 0xac, 0xcf, 0xa8, 0xf8, 0xd3, 0x11, 0xa3, 0xdb, 0x7a},
     false,
     false},

    // Comment: public key of order 3
    // tcID: 227
    {227,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x4f, 0x34, 0x14, 0xd1, 0x58, 0x9b, 0x49, 0xf7, 0x17, 0x2d, 0x43, 0x9c,
      0xbb, 0xe7, 0x8e, 0x5b, 0x53, 0x50, 0xdc, 0x85, 0xde, 0xa4, 0x0c, 0xd2,
      0xd6, 0x27, 0x47, 0x40, 0xc6, 0xe0, 0x23, 0x9c, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x41, 0xde, 0xe3, 0x0a, 0x22, 0x44, 0xd9, 0x20, 0x1c, 0xa6,
      0x4d, 0x6f, 0xd2, 0xdd, 0x12, 0x6b, 0x70, 0x95, 0x36, 0x9e, 0x67, 0x3a,
      0xec, 0xaa, 0xa5, 0xe0, 0x42, 0x30, 0x85, 0x28, 0x9d, 0x5d, 0x4d, 0x17,
      0x35, 0xb9, 0x28, 0x41, 0xe7, 0x7d, 0x3c, 0x8b, 0x20, 0x64, 0xde, 0xd2,
      0xc3, 0xd6, 0x5d, 0x86, 0x92, 0xf0, 0xa0, 0x54, 0x52, 0x65, 0xdf, 0x6d,
      0xa2, 0xe5, 0x2b, 0x94, 0xa1, 0xc9},
     {0x30, 0x82, 0x01, 0x33, 0x30, 0x81, 0xec, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x30, 0x81, 0xe0, 0x02, 0x01, 0x01, 0x30, 0x2c,
      0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x01, 0x01, 0x02, 0x21, 0x00,
      0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x44, 0x04, 0x20,
      0x7b, 0x5c, 0x92, 0xa0, 0xca, 0xc0, 0xf3, 0x06, 0x73, 0x47, 0x3f, 0x26,
      0x0f, 0x89, 0x92, 0x6a, 0x14, 0xda, 0x90, 0x5b, 0xc7, 0xe5, 0xe0, 0x7d,
      0xf1, 0xe8, 0xdf, 0x69, 0x05, 0x9d, 0x98, 0x57, 0x04, 0x20, 0xcb, 0x2e,
      0xaa, 0x56, 0x43, 0x57, 0x23, 0x72, 0xd5, 0xcb, 0xa1, 0xe6, 0x9f, 0x68,
      0x7d, 0x28, 0x7f, 0xd6, 0x2f, 0x55, 0x18, 0x32, 0x2a, 0xf2, 0x61, 0x4c,
      0xe5, 0x12, 0xdd, 0x68, 0x0a, 0x76, 0x04, 0x41, 0x04, 0x84, 0x35, 0x87,
      0xc1, 0xbe, 0xa1, 0x97, 0xa1, 0xbe, 0x63, 0xc6, 0x7c, 0x9f, 0x16, 0x41,
      0xc7, 0x0f, 0x7d, 0x3c, 0xba, 0x49, 0x14, 0x7e, 0x9f, 0xc0, 0xc9, 0xbb,
      0x24, 0x6e, 0x14, 0x98, 0x18, 0x60, 0x49, 0x24, 0x3e, 0x8e, 0x92, 0x74,
      0x3d, 0xf2, 0xf9, 0x99, 0x4d, 0x60, 0xf9, 0x0a, 0xb2, 0x16, 0x35, 0xe0,
      0x01, 0x83, 0xe6, 0x9b, 0x31, 0x7f, 0x00, 0xad, 0x22, 0x6d, 0xa8, 0xf5,
      0x46, 0x02, 0x21, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
      0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51,
      0x02, 0x01, 0x01, 0x03, 0x42, 0x00, 0x04, 0x84, 0x35, 0x87, 0xc1, 0xbe,
      0xa1, 0x97, 0xa1, 0xbe, 0x63, 0xc6, 0x7c, 0x9f, 0x16, 0x41, 0xc7, 0x0f,
      0x7d, 0x3c, 0xba, 0x49, 0x14, 0x7e, 0x9f, 0xc0, 0xc9, 0xbb, 0x24, 0x6e,
      0x14, 0x98, 0x18, 0x9f, 0xb6, 0xdb, 0xc0, 0x71, 0x6d, 0x8b, 0xc3, 0x0d,
      0x06, 0x66, 0xb2, 0x9f, 0x06, 0xf5, 0x4d, 0xe9, 0xca, 0x1f, 0xff, 0x7c,
      0x19, 0x64, 0xce, 0x80, 0xff, 0x52, 0xdd, 0x92, 0x57, 0x0a, 0xb9},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: secp224r1
    // tcID: 228
    {228,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x4e, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x21, 0x03, 0x3a, 0x00, 0x04,
      0x2a, 0xf2, 0x70, 0xd2, 0xa6, 0x03, 0x0e, 0x3d, 0xd3, 0x8c, 0xc4, 0x6e,
      0x7d, 0x71, 0x9f, 0x17, 0x6c, 0x2c, 0xa4, 0xeb, 0x04, 0xd7, 0xe8, 0xb8,
      0x42, 0x90, 0xc8, 0xed, 0xbc, 0xae, 0xd9, 0x64, 0xeb, 0xe2, 0x26, 0xb2,
      0xd7, 0xce, 0x17, 0x25, 0x16, 0x22, 0x80, 0x4c, 0x0d, 0x3b, 0x7a, 0xdc,
      0xe0, 0x20, 0xa3, 0xcd, 0xc9, 0x7c, 0xac, 0x6c},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: secp384r1
    // tcID: 229
    {229,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x1f, 0x17, 0x90, 0x1e, 0x73, 0x1b, 0x06, 0xf3, 0x49, 0xb6, 0xe9, 0xd7,
      0xd1, 0x7d, 0x45, 0xe8, 0xa2, 0xb4, 0x61, 0x15, 0xa4, 0x74, 0x85, 0xbe,
      0x16, 0x19, 0x79, 0x32, 0xdb, 0x87, 0xb3, 0x94, 0x05, 0xb5, 0xc9, 0x41,
      0xb3, 0x6f, 0xd6, 0x1b, 0x9e, 0xf7, 0xdd, 0x20, 0x87, 0x8e, 0x12, 0x9e,
      0x55, 0xa2, 0x27, 0x70, 0x99, 0xc6, 0x01, 0xdc, 0xdb, 0x37, 0x47, 0xf8,
      0x0a, 0xd6, 0xe1, 0x66, 0x11, 0x63, 0x78, 0xe1, 0xeb, 0xce, 0x2c, 0x95,
      0x74, 0x4a, 0x09, 0x86, 0x12, 0x8c, 0xfe, 0xea, 0xac, 0x7f, 0x90, 0xb7,
      0x17, 0x87, 0xd9, 0xa1, 0xcf, 0xe4, 0x17, 0xcd, 0x4c, 0x8f, 0x6a, 0xf5},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: secp521r1
    // tcID: 230
    {230,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x81, 0x9b, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x23, 0x03, 0x81, 0x86,
      0x00, 0x04, 0x00, 0xed, 0x76, 0xe5, 0x88, 0x84, 0x28, 0xfa, 0xd4, 0x09,
      0xff, 0x20, 0x3a, 0xb2, 0x98, 0xb0, 0xf2, 0x48, 0x27, 0xc0, 0x91, 0x93,
      0x9a, 0xe0, 0xf9, 0xb1, 0x24, 0x5d, 0x86, 0x5a, 0xc5, 0xfb, 0xcd, 0x27,
      0x49, 0xf9, 0xae, 0x6c, 0x90, 0xfa, 0x8e, 0x29, 0x41, 0x4d, 0x1b, 0xc7,
      0xdc, 0x7b, 0x3c, 0x4a, 0xca, 0x90, 0x4c, 0xd8, 0x24, 0x48, 0x44, 0x21,
      0xcc, 0x66, 0xfe, 0x6a, 0xf4, 0x3b, 0xdf, 0xd2, 0x00, 0xc1, 0xf7, 0x90,
      0xa0, 0xb3, 0xae, 0x99, 0x49, 0x37, 0xf9, 0x1b, 0x6b, 0xdb, 0x97, 0x78,
      0xb0, 0x8c, 0x83, 0xec, 0xad, 0xb8, 0xcb, 0xa2, 0x2a, 0x78, 0xc3, 0x7b,
      0xf5, 0x65, 0xda, 0xc1, 0x64, 0xf1, 0x8e, 0x71, 0x9b, 0xe0, 0xef, 0x89,
      0x0e, 0xe5, 0xcb, 0xf2, 0x0e, 0x17, 0xfc, 0xfc, 0x9a, 0x55, 0x85, 0xe5,
      0x41, 0x64, 0x70, 0xb9, 0x86, 0x2f, 0x82, 0xfb, 0x76, 0x93, 0x39, 0x99,
      0x4f, 0x4e},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: secp256k1
    // tcID: 231
    {231,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x56, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x0a, 0x03, 0x42,
      0x00, 0x04, 0x80, 0x28, 0xd1, 0x60, 0x82, 0xb0, 0x76, 0x96, 0xd4,
      0xaa, 0x4a, 0xab, 0x9d, 0x6b, 0x1f, 0x14, 0x63, 0x43, 0x5a, 0xc0,
      0x97, 0x90, 0x06, 0x31, 0x10, 0x8f, 0x98, 0x88, 0xe1, 0x3d, 0xa6,
      0x7c, 0x48, 0x41, 0xfd, 0x8d, 0xd3, 0xce, 0xd6, 0xe7, 0xad, 0x8c,
      0x6f, 0xc6, 0x56, 0x62, 0x1c, 0x2f, 0x93, 0xd3, 0xdb, 0x0e, 0xb2,
      0x9d, 0x48, 0xd1, 0x42, 0x31, 0x54, 0x51, 0x98, 0x65, 0xdb, 0xc1},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: secp224k1
    // tcID: 232
    {232,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x4e, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x20, 0x03, 0x3a, 0x00, 0x04,
      0xdc, 0x79, 0xfc, 0x28, 0xda, 0x09, 0x6a, 0xc1, 0x9f, 0x3c, 0xf0, 0xbc,
      0x70, 0xb8, 0xe5, 0x25, 0x29, 0xa8, 0x38, 0x61, 0xac, 0x66, 0xb1, 0xd4,
      0x4b, 0x9f, 0x2e, 0x9c, 0x68, 0x85, 0x6b, 0xab, 0xaa, 0x94, 0xf5, 0xfa,
      0x67, 0xa1, 0xed, 0xfc, 0xe5, 0xbd, 0x17, 0x68, 0xf9, 0xb9, 0xa1, 0x62,
      0x14, 0x83, 0xd2, 0x14, 0x43, 0x6a, 0xab, 0x02},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP224r1
    // tcID: 233
    {233,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x52, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x05,
      0x03, 0x3a, 0x00, 0x04, 0xa6, 0xba, 0xe3, 0xd1, 0x55, 0xc1, 0xf9, 0xca,
      0x26, 0x39, 0x28, 0xc9, 0x86, 0xed, 0xe6, 0x9a, 0xce, 0xfd, 0x0d, 0xd9,
      0xb3, 0xa1, 0x9d, 0x2b, 0x9f, 0x4b, 0x0a, 0x3a, 0x66, 0xbe, 0xa5, 0xd1,
      0x67, 0x31, 0x8d, 0xcc, 0x02, 0x89, 0x45, 0xfc, 0x1b, 0x40, 0xc6, 0x0c,
      0xe7, 0x16, 0xba, 0x2d, 0x41, 0x4a, 0x74, 0x3c, 0x6b, 0x85, 0x6a, 0x6f},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP256r1
    // tcID: 234
    {234,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x5d, 0x3d, 0xdb, 0xbb, 0x9b, 0xc0, 0x71, 0xd8,
      0xb5, 0x98, 0x55, 0xc7, 0x4b, 0xdf, 0x35, 0x41, 0xae, 0x4c, 0xb6, 0xc1,
      0xa2, 0x4e, 0xc4, 0x39, 0x03, 0x4d, 0xf7, 0xab, 0xde, 0x16, 0xa3, 0x46,
      0x52, 0x3e, 0xdf, 0x6a, 0x67, 0x89, 0x6b, 0x30, 0x4c, 0xb2, 0xcd, 0x2a,
      0x08, 0x3e, 0xec, 0x2b, 0x16, 0x93, 0x5b, 0xbc, 0x91, 0x0e, 0x85, 0xec,
      0x6e, 0xae, 0x38, 0xb5, 0x02, 0x30, 0xbf, 0x70},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP320r1
    // tcID: 235
    {235,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x6a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x09,
      0x03, 0x52, 0x00, 0x04, 0xa4, 0x3c, 0x6e, 0xf2, 0x50, 0x07, 0x23, 0xd5,
      0x4c, 0x1f, 0xc8, 0x8f, 0x88, 0x44, 0xd8, 0x34, 0x45, 0xca, 0x5a, 0x0f,
      0x58, 0x5c, 0x10, 0xb8, 0xeb, 0x3f, 0x02, 0x2d, 0x47, 0xd0, 0xe8, 0x48,
      0x62, 0xb7, 0xf5, 0xcb, 0xf9, 0x7d, 0x35, 0x2d, 0x43, 0x48, 0xca, 0x73,
      0x0f, 0x60, 0x0f, 0x22, 0x58, 0xd1, 0xd1, 0x92, 0xda, 0x22, 0x3f, 0x6b,
      0xa8, 0x3a, 0x7c, 0xc0, 0xd6, 0xda, 0x59, 0x8d, 0x55, 0xc2, 0xb7, 0x78,
      0x24, 0xd3, 0x26, 0xc8, 0xdf, 0x00, 0x0b, 0x8f, 0xff, 0x15, 0x6d, 0x2c},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP384r1
    // tcID: 236
    {236,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x0b,
      0x03, 0x62, 0x00, 0x04, 0x23, 0x91, 0xc0, 0x62, 0x83, 0x3d, 0x1e, 0x6d,
      0x89, 0xec, 0x25, 0x6c, 0xf4, 0xa3, 0x98, 0x95, 0x34, 0xc1, 0xea, 0xd5,
      0xe1, 0xe1, 0x4f, 0xfa, 0xe9, 0x33, 0xa5, 0x3f, 0x96, 0x28, 0x57, 0xe4,
      0x71, 0x30, 0x87, 0xe1, 0xb3, 0xd6, 0x5a, 0xc7, 0x96, 0x34, 0xc7, 0x15,
      0x77, 0xaf, 0x24, 0x69, 0x8b, 0x5c, 0xe9, 0x59, 0x18, 0x38, 0x35, 0x55,
      0x1f, 0x7b, 0x08, 0xae, 0xf7, 0x85, 0x33, 0x78, 0xc2, 0x99, 0x93, 0x0b,
      0x36, 0x08, 0x13, 0xfd, 0x58, 0xd5, 0xe4, 0xda, 0x8b, 0x37, 0xd5, 0xa7,
      0x47, 0x3e, 0x89, 0x1e, 0xe1, 0x1c, 0xb0, 0x28, 0x81, 0xbd, 0x84, 0x8b,
      0x36, 0x4f, 0xb7, 0xd5},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP512r1
    // tcID: 237
    {237,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x81, 0x9b, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01,
      0x0d, 0x03, 0x81, 0x82, 0x00, 0x04, 0x84, 0xbe, 0xae, 0x85, 0x09, 0x66,
      0x40, 0x95, 0x3c, 0x1f, 0xd6, 0xeb, 0xbc, 0x32, 0x69, 0x72, 0x63, 0xd5,
      0x3f, 0x89, 0x94, 0x3c, 0xba, 0xf1, 0x44, 0x32, 0x06, 0x1a, 0xea, 0x8c,
      0x03, 0x18, 0xac, 0xbd, 0x93, 0x89, 0xab, 0x1d, 0x2e, 0x90, 0x4f, 0xa0,
      0xe0, 0x81, 0xd0, 0x8c, 0xfa, 0xbb, 0x61, 0x4e, 0xd9, 0xbc, 0xa6, 0x18,
      0x21, 0x11, 0x42, 0xd9, 0x46, 0x23, 0xc1, 0x4b, 0x47, 0x6a, 0x25, 0xe4,
      0x7a, 0xbf, 0x98, 0xfd, 0x3b, 0x1d, 0xa1, 0x41, 0x7d, 0xfc, 0x2e, 0x2c,
      0xfc, 0x84, 0x24, 0xb1, 0x6e, 0xa1, 0x4d, 0xd4, 0x5e, 0x14, 0x22, 0xbe,
      0x7d, 0x4e, 0x0a, 0x5c, 0xc7, 0xf4, 0xd4, 0xab, 0x5f, 0x19, 0x8c, 0xdb,
      0xaa, 0xa3, 0xf6, 0x42, 0xec, 0x63, 0x61, 0x84, 0x2c, 0xbe, 0x86, 0x93,
      0x82, 0xee, 0x78, 0xcd, 0x59, 0x6f, 0xf5, 0xe7, 0x40, 0xd9, 0xec, 0x2c,
      0x3a, 0xd6},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP224t1
    // tcID: 238
    {238,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x52, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x06,
      0x03, 0x3a, 0x00, 0x04, 0x2b, 0x0a, 0x1a, 0x85, 0x8f, 0xfc, 0x44, 0xe7,
      0x75, 0x29, 0x40, 0x73, 0x1d, 0x37, 0x8f, 0x96, 0x57, 0x08, 0x37, 0xe2,
      0x79, 0xea, 0x39, 0x48, 0xfe, 0x00, 0xcf, 0xf8, 0xb5, 0xf8, 0x9a, 0xdb,
      0x4e, 0x2f, 0xe6, 0xf8, 0x78, 0x1b, 0xa6, 0x42, 0x63, 0x64, 0xf4, 0x59,
      0x0b, 0x34, 0xdd, 0x79, 0xfc, 0x80, 0x62, 0x9d, 0xe4, 0xa8, 0x60, 0x84},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP256t1
    // tcID: 239
    {239,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x08,
      0x03, 0x42, 0x00, 0x04, 0x30, 0x37, 0xc0, 0x1b, 0x4a, 0x5a, 0xc5, 0x37,
      0x42, 0xe3, 0xf5, 0x52, 0x8d, 0xff, 0xb0, 0xf0, 0x10, 0xab, 0x6e, 0xbe,
      0xb0, 0x8d, 0x79, 0x2b, 0x32, 0xe1, 0x9e, 0x90, 0x06, 0xca, 0x33, 0x1a,
      0x02, 0x4b, 0x67, 0x69, 0x8d, 0x7c, 0xf4, 0xb5, 0x75, 0xcc, 0xd9, 0x38,
      0x94, 0x41, 0xd5, 0xc6, 0x40, 0xb7, 0x7c, 0x63, 0x77, 0x1c, 0xef, 0x1b,
      0xd8, 0x56, 0x75, 0x36, 0x1c, 0x66, 0x02, 0xa4},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP320t1
    // tcID: 240
    {240,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x6a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x0a,
      0x03, 0x52, 0x00, 0x04, 0x0f, 0x0f, 0xd9, 0x72, 0xa4, 0x95, 0xa1, 0x40,
      0x12, 0x4a, 0x40, 0x19, 0x29, 0x1a, 0x20, 0xf5, 0xb3, 0x9f, 0xb7, 0x55,
      0xc1, 0x26, 0xbf, 0x26, 0x86, 0x43, 0xbb, 0x30, 0x91, 0xec, 0xa4, 0x4f,
      0x2a, 0x3c, 0xda, 0x1d, 0xea, 0xd6, 0xab, 0x1f, 0x4f, 0xe0, 0x8a, 0x4b,
      0x38, 0x72, 0x42, 0x3f, 0x71, 0xe5, 0xbf, 0x96, 0xb1, 0xc2, 0x0b, 0xc0,
      0xca, 0x73, 0xb7, 0xe2, 0xc1, 0x34, 0xcc, 0x14, 0xa5, 0xf7, 0x7b, 0xc8,
      0x38, 0xeb, 0xcf, 0x01, 0x08, 0x4d, 0xa3, 0xbf, 0x15, 0x66, 0x35, 0x36},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP384t1
    // tcID: 241
    {241,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x7a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x0c,
      0x03, 0x62, 0x00, 0x04, 0x03, 0xb6, 0x5f, 0xaf, 0x5a, 0x6b, 0xf7, 0x4b,
      0xd5, 0xc1, 0x66, 0x27, 0x8a, 0x4b, 0x56, 0x6c, 0x6c, 0x70, 0x5a, 0xc6,
      0x36, 0x3e, 0x61, 0xf3, 0xb0, 0x69, 0x9e, 0x11, 0x6d, 0x3c, 0x5b, 0x19,
      0xe8, 0xb7, 0x02, 0x1b, 0x75, 0xb0, 0x05, 0xf7, 0x8a, 0x8c, 0xea, 0x8d,
      0xe3, 0x4c, 0x49, 0x39, 0x7f, 0x9b, 0x3b, 0x2b, 0xfc, 0x87, 0x06, 0xeb,
      0x81, 0x63, 0xc8, 0x02, 0x37, 0x1e, 0xff, 0x7d, 0xfc, 0x82, 0x5c, 0x40,
      0xaa, 0x84, 0xdd, 0x9d, 0x1c, 0x4b, 0x34, 0x61, 0x5e, 0xe5, 0xae, 0x28,
      0xc6, 0xc0, 0x5d, 0x58, 0xd2, 0xa8, 0xcc, 0xc3, 0x78, 0x63, 0x82, 0xb7,
      0x12, 0xd3, 0xbc, 0xda},
     {},
     false,
     false},

    // Comment: Public key uses wrong curve: brainpoolP512t1
    // tcID: 242
    {242,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xb4, 0x4f, 0x96, 0x70, 0xfe, 0xdb, 0xa8, 0x87, 0xad, 0x8e, 0x80, 0x62,
      0x26, 0x06, 0x3e, 0x77, 0x60, 0x4b, 0x27, 0xc3, 0x62, 0x83, 0x63, 0x26,
      0xe9, 0x3e, 0xcb, 0x7f, 0xcc, 0x6d, 0xc2, 0x97, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x9f, 0x57, 0xb8, 0xfc, 0x70, 0x69, 0xce, 0x46, 0xca, 0x9a,
      0x56, 0xe6, 0x3d, 0x88, 0xe9, 0x9d, 0x4e, 0xcb, 0x58, 0x45, 0xf8, 0x1e,
      0x71, 0xcf, 0x6b, 0xc8, 0x6a, 0xcc, 0x85, 0x8b, 0xd2, 0x90, 0x88, 0x69,
      0xfc, 0x9e, 0xe5, 0x61, 0x7d, 0xbb, 0x64, 0x68, 0xaf, 0x36, 0x38, 0x1f,
      0x0c, 0x40, 0x96, 0x8d, 0x74, 0x79, 0x4e, 0x18, 0x3a, 0x66, 0x9b, 0x01,
      0x92, 0xeb, 0xd9, 0xd7, 0x56, 0x11},
     {0x30, 0x81, 0x9b, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x09, 0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01,
      0x0e, 0x03, 0x81, 0x82, 0x00, 0x04, 0x75, 0x04, 0xd6, 0x60, 0x94, 0x3a,
      0x69, 0xab, 0x04, 0x33, 0x78, 0xe4, 0x4c, 0x03, 0x48, 0x96, 0x53, 0x4a,
      0x34, 0x6e, 0x0e, 0x95, 0xf3, 0x5f, 0xca, 0xad, 0x35, 0x03, 0xb4, 0x90,
      0x85, 0x6b, 0xfb, 0x20, 0xa7, 0x53, 0xec, 0xab, 0xc6, 0xd7, 0xbf, 0xee,
      0xc2, 0x8d, 0x05, 0x7f, 0x91, 0x99, 0x23, 0xb7, 0xd3, 0xc0, 0x86, 0x95,
      0x3e, 0xb1, 0x6c, 0x5b, 0xd2, 0x87, 0xb5, 0x97, 0x88, 0xdb, 0x72, 0xdb,
      0xb7, 0xc2, 0x73, 0x85, 0x42, 0x94, 0xc9, 0x27, 0xea, 0x7e, 0xca, 0x20,
      0x5a, 0xae, 0x2f, 0x08, 0x30, 0xe5, 0xfa, 0xad, 0xda, 0xd8, 0x31, 0x62,
      0x31, 0xbf, 0xc3, 0x57, 0x2c, 0x85, 0xc3, 0x3c, 0xb7, 0x05, 0x4e, 0x04,
      0xc8, 0x93, 0x6e, 0x3c, 0xe0, 0x59, 0xc9, 0x07, 0xe5, 0x9f, 0x40, 0x59,
      0x34, 0x44, 0xe5, 0x90, 0xb3, 0x18, 0x20, 0xbc, 0x1f, 0x51, 0x4e, 0xd0,
      0xec, 0x8a},
     {},
     false,
     false},

    // Comment: invalid public key
    // tcID: 243
    {243,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x6f, 0x95, 0x3f, 0xaf, 0xf3, 0x59, 0x9e, 0x6c, 0x76, 0x2d, 0x7f, 0x4c,
      0xab, 0xfe, 0xed, 0x09, 0x2d, 0xe2, 0xad, 0xd1, 0xdf, 0x1b, 0xc5, 0x74,
      0x8c, 0x6c, 0xbb, 0x72, 0x5c, 0xf3, 0x54, 0x58, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x68, 0xfd, 0x2d, 0x68, 0xf9, 0x77, 0xeb, 0x95, 0x35, 0x72,
      0x86, 0x08, 0xe8, 0x56, 0x65, 0x1e, 0x71, 0x80, 0xa8, 0xf0, 0x24, 0x01,
      0x9d, 0x5d, 0x40, 0x5d, 0x6e, 0xb5, 0xf3, 0xb9, 0x48, 0xa1, 0xb9, 0x25,
      0x37, 0x7f, 0x5b, 0x1f, 0x1b, 0x4b, 0xf0, 0xa1, 0x7b, 0x55, 0xf7, 0xca,
      0xb2, 0xb8, 0xde, 0x23, 0x90, 0xc4, 0xb5, 0x52, 0x66, 0xcc, 0x05, 0x01,
      0x0b, 0xeb, 0x9c, 0x4a, 0xf5, 0x76},
     {0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x22, 0x00, 0x02, 0xfd, 0x4b, 0xf6, 0x17, 0x63, 0xb4, 0x65, 0x81, 0xfd,
      0x91, 0x74, 0xd6, 0x23, 0x51, 0x6c, 0xf3, 0xc8, 0x1e, 0xdd, 0x40, 0xe2,
      0x9f, 0xfa, 0x27, 0x77, 0xfb, 0x6c, 0xb0, 0xae, 0x3c, 0xe5, 0x35},
     {},
     false,
     false},

    // Comment: public key is a low order point on twist
    // tcID: 244
    {244,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xd2, 0x7e, 0xdf, 0x0f, 0xf5, 0xb6, 0xb6, 0xb4, 0x65, 0x75, 0x3e, 0x71,
      0x58, 0x37, 0x03, 0x32, 0xc1, 0x53, 0xb4, 0x68, 0xa1, 0xbe, 0x08, 0x7a,
      0xd0, 0xf4, 0x90, 0xbd, 0xb9, 0x9e, 0x5f, 0x02, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x16, 0x14, 0x41, 0xc1, 0xee, 0x85, 0xe0, 0xcd, 0xb9, 0xff,
      0xc3, 0xeb, 0xf2, 0x9f, 0xde, 0x51, 0x88, 0x98, 0xfd, 0x27, 0x09, 0xb3,
      0x6e, 0x31, 0xe2, 0xe0, 0x34, 0xf1, 0xf8, 0x03, 0xb9, 0x0d, 0xde, 0x24,
      0xaf, 0xa2, 0x8e, 0xc6, 0x95, 0xdc, 0xc1, 0xb8, 0xef, 0x92, 0x1c, 0xbe,
      0xbb, 0x24, 0xb7, 0x0b, 0xd7, 0xd3, 0x50, 0xca, 0xf2, 0xa3, 0xec, 0xc8,
      0x09, 0xb1, 0x6b, 0x19, 0xe9, 0x31},
     {0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x22, 0x00, 0x03, 0xef, 0xdd, 0xe3, 0xb3, 0x28, 0x72, 0xa9, 0xef, 0xfc,
      0xf3, 0xb9, 0x4c, 0xbf, 0x73, 0xaa, 0x7b, 0x39, 0xf9, 0x68, 0x3e, 0xce,
      0x91, 0x21, 0xb9, 0x85, 0x21, 0x67, 0xf4, 0xe3, 0xda, 0x60, 0x9b},
     {},
     false,
     false},

    // Comment: public key is a low order point on twist
    // tcID: 245
    {245,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xd2, 0x7e, 0xdf, 0x0f, 0xf5, 0xb6, 0xb6, 0xb4, 0x65, 0x75, 0x3e, 0x71,
      0x58, 0x37, 0x03, 0x32, 0xc1, 0x53, 0xb4, 0x68, 0xa1, 0xbe, 0x08, 0x7a,
      0xd0, 0xf4, 0x90, 0xbd, 0xb9, 0x9e, 0x5f, 0x03, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xec, 0x8f, 0x0b, 0x18, 0x56, 0xf5, 0x11, 0x13, 0x98, 0x84,
      0x69, 0xd1, 0x4e, 0x9f, 0x8c, 0x09, 0x79, 0x5b, 0x83, 0x81, 0x20, 0x24,
      0x78, 0x5c, 0x92, 0xfa, 0xf6, 0xd9, 0xc3, 0x5a, 0xcd, 0x5b, 0x9f, 0xda,
      0x6e, 0xd8, 0x42, 0xaf, 0x7d, 0x1f, 0x28, 0xcb, 0x37, 0xc6, 0x15, 0x5b,
      0xf1, 0x22, 0x68, 0xa4, 0x59, 0xb3, 0x8b, 0xdf, 0x01, 0xc1, 0xb5, 0xe2,
      0x00, 0xb3, 0x02, 0x48, 0xe6, 0x36},
     {0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x22, 0x00, 0x02, 0xef, 0xdd, 0xe3, 0xb3, 0x28, 0x72, 0xa9, 0xef, 0xfc,
      0xf3, 0xb9, 0x4c, 0xbf, 0x73, 0xaa, 0x7b, 0x39, 0xf9, 0x68, 0x3e, 0xce,
      0x91, 0x21, 0xb9, 0x85, 0x21, 0x67, 0xf4, 0xe3, 0xda, 0x60, 0x9b},
     {},
     false,
     false},

    // Comment: public key is a low order point on twist
    // tcID: 246
    {246,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x95, 0xea, 0xd8, 0x45, 0x40, 0xc2, 0xd0, 0x27, 0xaa, 0x31, 0x30, 0xff,
      0x1b, 0x47, 0x88, 0x8c, 0xc1, 0xed, 0x67, 0xe8, 0xdd, 0xa4, 0x61, 0x56,
      0xe7, 0x1c, 0xe0, 0x99, 0x17, 0x91, 0xe8, 0x35, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x60, 0x3e, 0x20, 0x98, 0x96, 0xe1, 0x65, 0x7d, 0x46, 0x88,
      0x0d, 0x82, 0xba, 0x3d, 0x1d, 0xe9, 0x27, 0x99, 0x65, 0x56, 0x22, 0xbc,
      0x3d, 0x71, 0x64, 0xab, 0x1f, 0x99, 0x56, 0xf9, 0x24, 0x94, 0x03, 0x8d,
      0xe2, 0x74, 0x98, 0x9a, 0xa8, 0x84, 0x82, 0xed, 0x27, 0x4e, 0x99, 0x96,
      0x91, 0x03, 0xd2, 0x6f, 0xd5, 0xb4, 0x87, 0xb2, 0x7f, 0xbc, 0xb2, 0xe4,
      0x64, 0x2d, 0xdc, 0x10, 0xa9, 0x59},
     {0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x22, 0x00, 0x02, 0xc4, 0x95, 0x24, 0xb2, 0xad, 0xfd, 0x8f, 0x5f, 0x97,
      0x2e, 0xf5, 0x54, 0x65, 0x28, 0x36, 0xe2, 0xef, 0xb2, 0xd3, 0x06, 0xc6,
      0xd3, 0xb0, 0x68, 0x92, 0x34, 0xce, 0xc9, 0x3a, 0xe7, 0x3d, 0xb5},
     {},
     false,
     false},

    // Comment: public key is a low order point on twist
    // tcID: 247
    {247,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xa8, 0x68, 0x1e, 0xf6, 0x7f, 0xb1, 0xf1, 0x89, 0x64, 0x7d, 0x95, 0xe8,
      0xdb, 0x00, 0xc5, 0x2c, 0xee, 0xf6, 0xd4, 0x1a, 0x85, 0xba, 0x0a, 0x5b,
      0xd7, 0x4c, 0x44, 0xe8, 0xe6, 0x2c, 0x8a, 0xa4, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0x8a, 0x91, 0x25, 0x78, 0x03, 0x05, 0xca, 0x10, 0x5e, 0x02,
      0xd0, 0xc8, 0x14, 0x32, 0x9a, 0x05, 0xbb, 0x6f, 0x16, 0x8f, 0xc1, 0x92,
      0xf5, 0x0d, 0xde, 0xfd, 0x8a, 0xa0, 0x7e, 0x46, 0xd0, 0x5e, 0x1d, 0x00,
      0xbc, 0x1a, 0x57, 0xf9, 0x7a, 0xcf, 0xc4, 0xab, 0x1a, 0x98, 0xb7, 0x72,
      0xaf, 0xef, 0x59, 0xa6, 0x03, 0x20, 0x61, 0x9c, 0x8e, 0xdf, 0x7e, 0x13,
      0x13, 0x0e, 0x44, 0x07, 0x81, 0xeb},
     {0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x22, 0x00, 0x03, 0x18, 0xf9, 0xba, 0xe7, 0x74, 0x7c, 0xd8, 0x44, 0xe9,
      0x85, 0x25, 0xb7, 0xcc, 0xd0, 0xda, 0xf6, 0xe1, 0xd2, 0x0a, 0x81, 0x8b,
      0x21, 0x75, 0xa9, 0xa9, 0x1e, 0x4e, 0xae, 0x53, 0x43, 0xbc, 0x98},
     {},
     false,
     false},

    // Comment: public key is a low order point on twist
    // tcID: 248
    {248,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xa8, 0x68, 0x1e, 0xf6, 0x7f, 0xb1, 0xf1, 0x89, 0x64, 0x7d, 0x95, 0xe8,
      0xdb, 0x00, 0xc5, 0x2c, 0xee, 0xf6, 0xd4, 0x1a, 0x85, 0xba, 0x0a, 0x5b,
      0xd7, 0x4c, 0x44, 0xe8, 0xe6, 0x2c, 0x8a, 0xa5, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xaa, 0x47, 0xa5, 0x0b, 0x5a, 0x46, 0xad, 0x44, 0x90, 0xd2,
      0x72, 0x8f, 0x99, 0xcc, 0x17, 0x1b, 0x3b, 0x51, 0x4c, 0xd1, 0xfa, 0xa5,
      0xb3, 0xda, 0x3e, 0x0a, 0x7e, 0xd1, 0x29, 0xc7, 0xc0, 0xbc, 0x8a, 0x8d,
      0x7c, 0x45, 0xdf, 0xc9, 0x1f, 0x23, 0x1a, 0x43, 0x1a, 0x70, 0x88, 0xbb,
      0xc9, 0xb1, 0x17, 0x69, 0xe6, 0xa4, 0xa7, 0x73, 0xc8, 0x5e, 0x34, 0x6d,
      0x00, 0x66, 0x48, 0x33, 0x5f, 0x5f},
     {0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x22, 0x00, 0x02, 0x18, 0xf9, 0xba, 0xe7, 0x74, 0x7c, 0xd8, 0x44, 0xe9,
      0x85, 0x25, 0xb7, 0xcc, 0xd0, 0xda, 0xf6, 0xe1, 0xd2, 0x0a, 0x81, 0x8b,
      0x21, 0x75, 0xa9, 0xa9, 0x1e, 0x4e, 0xae, 0x53, 0x43, 0xbc, 0x98},
     {},
     false,
     false},

    // Comment: public key is a low order point on twist
    // tcID: 249
    {249,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0x95, 0xea, 0xd8, 0x45, 0x40, 0xc2, 0xd0, 0x27, 0xaa, 0x31, 0x30, 0xff,
      0x1b, 0x47, 0x88, 0x8c, 0xc1, 0xed, 0x67, 0xe8, 0xdd, 0xa4, 0x61, 0x56,
      0xe7, 0x1c, 0xe0, 0x99, 0x17, 0x91, 0xe8, 0x34, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xc6, 0x58, 0x1a, 0x84, 0x3f, 0xac, 0xc6, 0x4a, 0xe3, 0xf9,
      0xd4, 0x71, 0xc4, 0x4b, 0xd2, 0x2b, 0xfe, 0x25, 0x62, 0x8d, 0xa8, 0x1f,
      0x5f, 0x9c, 0xd6, 0x7b, 0x18, 0x4f, 0x3d, 0x22, 0xff, 0x16, 0x10, 0xae,
      0xb4, 0x49, 0x6c, 0x58, 0xa6, 0xad, 0xc6, 0xba, 0xe4, 0x6a, 0x7b, 0x09,
      0xaa, 0x41, 0xac, 0xb7, 0xc0, 0xb8, 0x6d, 0x97, 0x02, 0x3d, 0x22, 0xba,
      0x23, 0xc6, 0x5b, 0x71, 0x8c, 0xd6},
     {0x30, 0x39, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x22, 0x00, 0x03, 0xc4, 0x95, 0x24, 0xb2, 0xad, 0xfd, 0x8f, 0x5f, 0x97,
      0x2e, 0xf5, 0x54, 0x65, 0x28, 0x36, 0xe2, 0xef, 0xb2, 0xd3, 0x06, 0xc6,
      0xd3, 0xb0, 0x68, 0x92, 0x34, 0xce, 0xc9, 0x3a, 0xe7, 0x3d, 0xb5},
     {},
     false,
     false},

    // Comment: long form encoding of length of sequence
    // tcID: 250
    {250,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x81, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: long form encoding of length of sequence
    // tcID: 251
    {251,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x81, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of sequence contains leading 0
    // tcID: 252
    {252,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x82, 0x00, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of sequence contains leading 0
    // tcID: 253
    {253,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x82, 0x00, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong length of sequence
    // tcID: 254
    {254,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong length of sequence
    // tcID: 255
    {255,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong length of sequence
    // tcID: 256
    {256,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong length of sequence
    // tcID: 257
    {257,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: uint32 overflow in length of sequence
    // tcID: 258
    {258,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x85, 0x01, 0x00, 0x00, 0x00, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: uint32 overflow in length of sequence
    // tcID: 259
    {259,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x85, 0x01, 0x00, 0x00, 0x00, 0x13, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: uint64 overflow in length of sequence
    // tcID: 260
    {260,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x30,
      0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08,
      0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97,
      0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b,
      0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49,
      0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24,
      0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71,
      0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: uint64 overflow in length of sequence
    // tcID: 261
    {261,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x62, 0x30, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08,
      0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97,
      0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b,
      0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49,
      0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24,
      0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71,
      0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of sequence = 2**31 - 1
    // tcID: 262
    {262,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of sequence = 2**31 - 1
    // tcID: 263
    {263,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of sequence = 2**32 - 1
    // tcID: 264
    {264,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x84, 0xff, 0xff, 0xff, 0xff, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of sequence = 2**32 - 1
    // tcID: 265
    {265,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x84, 0xff, 0xff, 0xff, 0xff, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of sequence = 2**40 - 1
    // tcID: 266
    {266,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x13, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of sequence = 2**40 - 1
    // tcID: 267
    {267,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of sequence = 2**64 - 1
    // tcID: 268
    {268,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
      0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
      0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of sequence = 2**64 - 1
    // tcID: 269
    {269,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
      0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: incorrect length of sequence
    // tcID: 270
    {270,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0xff, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: incorrect length of sequence
    // tcID: 271
    {271,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0xff, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length without termination
    // tcID: 272
    {272,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x80, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length without termination
    // tcID: 273
    {273,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length without termination
    // tcID: 274
    {274,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x80, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length without termination
    // tcID: 275
    {275,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x80, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length without termination
    // tcID: 276
    {276,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x80, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: removing sequence
    // tcID: 277
    {277,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: removing sequence
    // tcID: 278
    {278,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x44, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71,
      0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e,
      0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63,
      0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8,
      0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: lonely sequence tag
    // tcID: 279
    {279,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: lonely sequence tag
    // tcID: 280
    {280,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x45, 0x30, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending 0's to sequence
    // tcID: 281
    {281,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x00, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending 0's to sequence
    // tcID: 282
    {282,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x00,
      0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: prepending 0's to sequence
    // tcID: 283
    {283,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x00, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: prepending 0's to sequence
    // tcID: 284
    {284,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x00, 0x00, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending unused 0's to sequence
    // tcID: 285
    {285,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x00, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending unused 0's to sequence
    // tcID: 286
    {286,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x00,
      0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending null value to sequence
    // tcID: 287
    {287,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x05, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending null value to sequence
    // tcID: 288
    {288,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x05,
      0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 289
    {289,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x49, 0x81, 0x77, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 290
    {290,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x25, 0x00, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 291
    {291,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93,
      0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9,
      0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71,
      0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24,
      0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29,
      0x71, 0x60, 0xad, 0xd6, 0x6b, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 292
    {292,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x18, 0x49, 0x81, 0x77, 0x30, 0x13, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 293
    {293,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x17, 0x25, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 294
    {294,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x15, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 295
    {295,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x18, 0x26, 0x0c, 0x49, 0x81, 0x77, 0x06, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 296
    {296,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x17, 0x26, 0x0b, 0x25, 0x00, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 297
    {297,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x1b, 0x26, 0x09, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef, 0x06,
      0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 298
    {298,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x18, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x26, 0x0d, 0x49, 0x81, 0x77, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 299
    {299,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x17, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x26, 0x0c, 0x25, 0x00, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 300
    {300,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x1b, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x26, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 301
    {301,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x23,
      0x47, 0x49, 0x81, 0x77, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 302
    {302,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x23,
      0x46, 0x25, 0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including garbage
    // tcID: 303
    {303,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x23, 0x44, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93,
      0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9,
      0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71,
      0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24,
      0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29,
      0x71, 0x60, 0xad, 0xd6, 0x6b, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 304
    {304,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x30, 0x59, 0x30,
      0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
      0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 305
    {305,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5f, 0xaa, 0x02, 0xaa, 0xbb, 0x30, 0x59, 0x30, 0x13, 0x06,
      0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43,
      0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 306
    {306,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x1b, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x30,
      0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
      0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 307
    {307,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5f, 0x30, 0x19, 0xaa, 0x02, 0xaa, 0xbb, 0x30, 0x13, 0x06,
      0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43,
      0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 308
    {308,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x1b, 0x26, 0x0f, 0xaa, 0x00, 0xbb, 0x00, 0xcd,
      0x00, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
      0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 309
    {309,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5f, 0x30, 0x19, 0x26, 0x0d, 0xaa, 0x02, 0xaa, 0xbb, 0x06,
      0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43,
      0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 310
    {310,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x1b, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x26, 0x10, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x06,
      0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 311
    {311,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5f, 0x30, 0x19, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x26, 0x0e, 0xaa, 0x02, 0xaa, 0xbb, 0x06, 0x08, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43,
      0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 312
    {312,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x23, 0x4a, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: including undefined tags
    // tcID: 313
    {313,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5f, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x23, 0x48, 0xaa, 0x02, 0xaa, 0xbb, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43,
      0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated length of sequence
    // tcID: 314
    {314,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x81},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated length of sequence
    // tcID: 315
    {315,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x46, 0x30, 0x81, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: Replacing sequence with NULL
    // tcID: 316
    {316,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x05, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: Replacing sequence with NULL
    // tcID: 317
    {317,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x46, 0x05, 0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 318
    {318,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x2e, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 319
    {319,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x2f, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 320
    {320,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x31, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 321
    {321,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x32, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 322
    {322,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0xff, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 323
    {323,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x2e, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 324
    {324,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x2f, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 325
    {325,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x31, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 326
    {326,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x32, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of sequence
    // tcID: 327
    {327,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0xff, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: dropping value of sequence
    // tcID: 328
    {328,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: dropping value of sequence
    // tcID: 329
    {329,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x46, 0x30, 0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated sequence
    // tcID: 330
    {330,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated sequence
    // tcID: 331
    {331,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01,
      0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf,
      0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0,
      0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f,
      0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6,
      0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated sequence
    // tcID: 332
    {332,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf,
      0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0,
      0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f,
      0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6,
      0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated sequence
    // tcID: 333
    {333,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x30, 0x12, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01,
      0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf,
      0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0,
      0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f,
      0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6,
      0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length
    // tcID: 334
    {334,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x80, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x00, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length
    // tcID: 335
    {335,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x00,
      0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length with truncated delimiter
    // tcID: 336
    {336,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x80, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length with truncated delimiter
    // tcID: 337
    {337,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x00,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length with additional element
    // tcID: 338
    {338,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x80, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x05, 0x00, 0x00, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length with additional element
    // tcID: 339
    {339,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x05,
      0x00, 0x00, 0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length with truncated element
    // tcID: 340
    {340,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x80, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71,
      0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3,
      0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1,
      0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60,
      0xad, 0xd6, 0x6b, 0x06, 0x08, 0x11, 0x22, 0x00, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length with truncated element
    // tcID: 341
    {341,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5f, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x06, 0x08, 0x11, 0x22, 0x00, 0x00, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43,
      0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length with garbage
    // tcID: 342
    {342,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x80, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71,
      0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3,
      0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1,
      0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60,
      0xad, 0xd6, 0x6b, 0x00, 0x00, 0xfe, 0x02, 0xbe, 0xef},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length with garbage
    // tcID: 343
    {343,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5f, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x00, 0x00, 0xfe, 0x02, 0xbe, 0xef, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43,
      0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length with nonempty EOC
    // tcID: 344
    {344,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x80, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x00, 0x02, 0xbe, 0xef},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: indefinite length with nonempty EOC
    // tcID: 345
    {345,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x80, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x00,
      0x02, 0xbe, 0xef, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: prepend empty sequence
    // tcID: 346
    {346,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: prepend empty sequence
    // tcID: 347
    {347,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x30, 0x00, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: append empty sequence
    // tcID: 348
    {348,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x30, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: append empty sequence
    // tcID: 349
    {349,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x30,
      0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: append garbage with high tag number
    // tcID: 350
    {350,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5c, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0xbf, 0x7f, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: append garbage with high tag number
    // tcID: 351
    {351,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5c, 0x30, 0x16, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0xbf,
      0x7f, 0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71,
      0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e,
      0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63,
      0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8,
      0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: sequence of sequence
    // tcID: 352
    {352,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: sequence of sequence
    // tcID: 353
    {353,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated sequence: removed last 1 elements
    // tcID: 354
    {354,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x15, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated sequence: removed last 1 elements
    // tcID: 355
    {355,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x4f, 0x30, 0x09, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: repeating element in sequence
    // tcID: 356
    {356,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x81, 0x9d, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97,
      0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b,
      0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49,
      0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24,
      0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71,
      0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: repeating element in sequence
    // tcID: 357
    {357,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x63, 0x30, 0x1d, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x06,
      0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00,
      0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43,
      0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59,
      0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf,
      0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93,
      0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29,
      0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: long form encoding of length of oid
    // tcID: 358
    {358,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x81, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: long form encoding of length of oid
    // tcID: 359
    {359,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x81, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of oid contains leading 0
    // tcID: 360
    {360,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x82, 0x00, 0x07, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of oid contains leading 0
    // tcID: 361
    {361,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x82, 0x00, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong length of oid
    // tcID: 362
    {362,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong length of oid
    // tcID: 363
    {363,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x06, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong length of oid
    // tcID: 364
    {364,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong length of oid
    // tcID: 365
    {365,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: uint32 overflow in length of oid
    // tcID: 366
    {366,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x18, 0x06, 0x85, 0x01, 0x00, 0x00, 0x00, 0x07, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: uint32 overflow in length of oid
    // tcID: 367
    {367,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x18, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x85, 0x01, 0x00, 0x00, 0x00, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: uint64 overflow in length of oid
    // tcID: 368
    {368,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x62, 0x30, 0x1c, 0x06, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08,
      0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97,
      0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b,
      0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49,
      0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24,
      0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71,
      0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: uint64 overflow in length of oid
    // tcID: 369
    {369,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x62, 0x30, 0x1c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
      0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97,
      0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b,
      0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49,
      0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24,
      0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71,
      0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of oid = 2**31 - 1
    // tcID: 370
    {370,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x17, 0x06, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of oid = 2**31 - 1
    // tcID: 371
    {371,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x17, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of oid = 2**32 - 1
    // tcID: 372
    {372,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x17, 0x06, 0x84, 0xff, 0xff, 0xff, 0xff, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of oid = 2**32 - 1
    // tcID: 373
    {373,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x17, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x84, 0xff, 0xff, 0xff, 0xff, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of oid = 2**40 - 1
    // tcID: 374
    {374,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x18, 0x06, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2a,
      0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of oid = 2**40 - 1
    // tcID: 375
    {375,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x18, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of oid = 2**64 - 1
    // tcID: 376
    {376,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x1b, 0x06, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
      0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of oid = 2**64 - 1
    // tcID: 377
    {377,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x1b, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: incorrect length of oid
    // tcID: 378
    {378,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0xff, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: incorrect length of oid
    // tcID: 379
    {379,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0xff, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: removing oid
    // tcID: 380
    {380,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x50, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03,
      0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71,
      0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e,
      0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63,
      0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8,
      0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: lonely oid tag
    // tcID: 381
    {381,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x51, 0x30, 0x0b, 0x06, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: lonely oid tag
    // tcID: 382
    {382,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x50, 0x30, 0x0a, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71,
      0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e,
      0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63,
      0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8,
      0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending 0's to oid
    // tcID: 383
    {383,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x09, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x00, 0x00, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending 0's to oid
    // tcID: 384
    {384,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x0a, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x00,
      0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: prepending 0's to oid
    // tcID: 385
    {385,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x09, 0x00, 0x00, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: prepending 0's to oid
    // tcID: 386
    {386,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x0a, 0x00, 0x00, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: appending unused 0's to oid
    // tcID: 387
    {387,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x00, 0x00, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending null value to oid
    // tcID: 388
    {388,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x09, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x05, 0x00, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending null value to oid
    // tcID: 389
    {389,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x0a, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x05,
      0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: truncated length of oid
    // tcID: 390
    {390,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x52, 0x30, 0x0c, 0x06, 0x81, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated length of oid
    // tcID: 391
    {391,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x51, 0x30, 0x0b, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x81, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: Replacing oid with NULL
    // tcID: 392
    {392,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x52, 0x30, 0x0c, 0x05, 0x00, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: Replacing oid with NULL
    // tcID: 393
    {393,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x51, 0x30, 0x0b, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x05, 0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 394
    {394,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x04, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 395
    {395,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x05, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 396
    {396,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x07, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 397
    {397,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x08, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 398
    {398,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0xff, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 399
    {399,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x04, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 400
    {400,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x05, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 401
    {401,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x07, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 402
    {402,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x08, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of oid
    // tcID: 403
    {403,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0xff, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: dropping value of oid
    // tcID: 404
    {404,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x52, 0x30, 0x0c, 0x06, 0x00, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce,
      0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: dropping value of oid
    // tcID: 405
    {405,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x51, 0x30, 0x0b, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x00, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: modify first byte of oid
    // tcID: 406
    {406,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x28, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: modify first byte of oid
    // tcID: 407
    {407,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x28, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: modify last byte of oid
    // tcID: 408
    {408,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x81, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: modify last byte of oid
    // tcID: 409
    {409,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x87, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: truncated oid
    // tcID: 410
    {410,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x30, 0x12, 0x06, 0x06, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf,
      0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0,
      0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f,
      0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6,
      0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated oid
    // tcID: 411
    {411,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x30, 0x12, 0x06, 0x06, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01,
      0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf,
      0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0,
      0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f,
      0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6,
      0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated oid
    // tcID: 412
    {412,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf,
      0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0,
      0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f,
      0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6,
      0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: truncated oid
    // tcID: 413
    {413,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x30, 0x12, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x07, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf,
      0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0,
      0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f,
      0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6,
      0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: wrong oid
    // tcID: 414
    {414,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x57, 0x30, 0x11, 0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1a, 0x06,
      0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00,
      0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43,
      0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59,
      0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf,
      0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93,
      0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29,
      0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong oid
    // tcID: 415
    {415,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x15, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03,
      0x04, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong oid
    // tcID: 416
    {416,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x56, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1a, 0x03, 0x42,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: wrong oid
    // tcID: 417
    {417,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x01,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: longer oid
    // tcID: 418
    {418,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: longer oid
    // tcID: 419
    {419,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x01,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: oid with modified node
    // tcID: 420
    {420,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x11, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: oid with modified node
    // tcID: 421
    {421,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x17, 0x06, 0x0b, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x88, 0x80, 0x80, 0x80, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: oid with modified node
    // tcID: 422
    {422,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x17, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: oid with modified node
    // tcID: 423
    {423,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x17, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x0c, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x88, 0x80,
      0x80, 0x80, 0x07, 0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: large integer in oid
    // tcID: 424
    {424,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x62, 0x30, 0x1c, 0x06, 0x10, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x01, 0x06, 0x08,
      0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97,
      0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b,
      0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49,
      0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24,
      0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71,
      0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: large integer in oid
    // tcID: 425
    {425,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x62, 0x30, 0x1c, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x11, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x82, 0x80,
      0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x07, 0x03, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97,
      0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b,
      0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49,
      0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24,
      0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71,
      0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: oid with invalid node
    // tcID: 426
    {426,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0xe0, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: oid with invalid node
    // tcID: 427
    {427,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x08, 0x2a, 0x80, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: oid with invalid node
    // tcID: 428
    {428,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0xe0,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: oid with invalid node
    // tcID: 429
    {429,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x14, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x09, 0x2a, 0x80, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07,
      0x03, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: long form encoding of length of bit string
    // tcID: 430
    {430,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5a, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x81, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83,
      0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0,
      0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79,
      0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51,
      0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of bit string contains leading 0
    // tcID: 431
    {431,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x82, 0x00, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong length of bit string
    // tcID: 432
    {432,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x43, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: wrong length of bit string
    // tcID: 433
    {433,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x41, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: uint32 overflow in length of bit string
    // tcID: 434
    {434,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x85, 0x01, 0x00, 0x00, 0x00, 0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: uint64 overflow in length of bit string
    // tcID: 435
    {435,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x62, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x04,
      0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97,
      0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b,
      0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49,
      0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24,
      0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71,
      0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of bit string = 2**31 - 1
    // tcID: 436
    {436,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x84, 0x7f, 0xff, 0xff, 0xff, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of bit string = 2**32 - 1
    // tcID: 437
    {437,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x84, 0xff, 0xff, 0xff, 0xff, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a,
      0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4,
      0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b,
      0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d,
      0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of bit string = 2**40 - 1
    // tcID: 438
    {438,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5e, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a,
      0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75,
      0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20,
      0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81,
      0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00,
      0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: length of bit string = 2**64 - 1
    // tcID: 439
    {439,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x61, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01,
      0x07, 0x03, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8,
      0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3,
      0xc7, 0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54,
      0xc8, 0x1b, 0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: incorrect length of bit string
    // tcID: 440
    {440,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0xff, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: lonely bit string tag
    // tcID: 441
    {441,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x16, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending 0's to bit string
    // tcID: 442
    {442,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x44, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x00, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: prepending 0's to bit string
    // tcID: 443
    {443,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x44, 0x00, 0x00, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7,
      0x83, 0xe1, 0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c,
      0xb8, 0x80, 0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63,
      0xb0, 0x63, 0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7,
      0x79, 0x9f, 0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b,
      0x51, 0x0f, 0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: appending null value to bit string
    // tcID: 444
    {444,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5b, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x44, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x05, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated length of bit string
    // tcID: 445
    {445,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x17, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x81},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: Replacing bit string with NULL
    // tcID: 446
    {446,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x17, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x03, 0x01, 0x07, 0x05, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of bit string
    // tcID: 447
    {447,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x01,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of bit string
    // tcID: 448
    {448,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x02,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of bit string
    // tcID: 449
    {449,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x04,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of bit string
    // tcID: 450
    {450,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x05,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: changing tag value of bit string
    // tcID: 451
    {451,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0xff,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: dropping value of bit string
    // tcID: 452
    {452,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x17, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x00},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: modify first byte of bit string
    // tcID: 453
    {453,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x02, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: modify last byte of bit string
    // tcID: 454
    {454,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0xeb},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated bit string
    // tcID: 455
    {455,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x41, 0x00, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: truncated bit string
    // tcID: 456
    {456,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x58, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x41, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1, 0xcf,
      0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80, 0x53,
      0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63, 0xd0,
      0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f, 0x9f,
      0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f, 0xf6,
      0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: declaring bits as unused in bit string
    // tcID: 457
    {457,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x01, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     true},

    // Comment: unused bits in bit string
    // tcID: 458
    {458,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x5d, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x46, 0x20, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b, 0x01, 0x02, 0x03, 0x04},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: unused bits in empty bit-string
    // tcID: 459
    {459,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x18, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48,
      0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x01, 0x03},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false},

    // Comment: 128 unused bits
    // tcID: 460
    {460,
     {0x30, 0x81, 0x87, 0x02, 0x01, 0x00, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
      0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d,
      0x03, 0x01, 0x07, 0x04, 0x6d, 0x30, 0x6b, 0x02, 0x01, 0x01, 0x04, 0x20,
      0xc9, 0x55, 0x1f, 0xfe, 0x53, 0xce, 0x60, 0xd7, 0x3c, 0xbf, 0x8a, 0xf5,
      0x53, 0xd0, 0xcb, 0x5f, 0x76, 0x32, 0xec, 0xe4, 0x99, 0x59, 0x01, 0x82,
      0xc2, 0x8c, 0xb6, 0xdb, 0x2e, 0x39, 0x78, 0xd2, 0xa1, 0x44, 0x03, 0x42,
      0x00, 0x04, 0xb2, 0xd5, 0x8b, 0x21, 0x55, 0x3a, 0x6d, 0xc1, 0x45, 0xbd,
      0xa6, 0x6a, 0x8a, 0x83, 0xaa, 0x01, 0xa9, 0x20, 0x97, 0xbf, 0x55, 0x43,
      0x19, 0xa3, 0x74, 0x8e, 0xc4, 0x9b, 0x37, 0xc3, 0x16, 0x35, 0xc5, 0x6f,
      0xc6, 0x52, 0x6a, 0xb0, 0xe1, 0x61, 0xba, 0x03, 0x43, 0x8a, 0xa4, 0xb7,
      0x57, 0x9c, 0xdd, 0xa9, 0x93, 0x25, 0xa1, 0x5a, 0x77, 0xf0, 0x63, 0x88,
      0x2e, 0xc6, 0x39, 0xa8, 0xec, 0x18},
     {0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03,
      0x42, 0x80, 0x04, 0x29, 0x98, 0x70, 0x5a, 0x9a, 0x71, 0xc7, 0x83, 0xe1,
      0xcf, 0x43, 0x97, 0xdb, 0xed, 0x93, 0x75, 0xa4, 0x4e, 0x4c, 0xb8, 0x80,
      0x53, 0x59, 0x4b, 0x0e, 0xa9, 0x82, 0x20, 0x3b, 0x63, 0x63, 0xb0, 0x63,
      0xd0, 0xaf, 0x49, 0x71, 0xd1, 0xc3, 0x81, 0x3d, 0xb3, 0xc7, 0x79, 0x9f,
      0x9f, 0x93, 0x24, 0xcb, 0xe1, 0xb9, 0x00, 0x54, 0xc8, 0x1b, 0x51, 0x0f,
      0xf6, 0x29, 0x71, 0x60, 0xad, 0xd6, 0x6b},
     {0xf0, 0xb6, 0xd8, 0x51, 0xdc, 0xd8, 0xe9, 0xa8, 0xc4, 0x74, 0xd6,
      0x95, 0x13, 0x79, 0x62, 0xf0, 0x82, 0xc4, 0xf2, 0xa1, 0xa2, 0xee,
      0xfb, 0x18, 0x2d, 0xf5, 0x8d, 0x88, 0xa7, 0x28, 0x29, 0xe4},
     true,
     false}};

#endif  // p256ecdh_vectors_h__
