/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.Context;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.CommentImpl;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.ElementWithAttributes;
import com.icl.saxon.tree.NodeFactory;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import com.icl.saxon.tree.ProcInstImpl;
import com.icl.saxon.tree.TextImpl;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class TreeBuilder
extends Builder {
    private static AttributeCollection emptyAttributeCollection = new AttributeCollection((NamePool)null);
    private ParentNodeImpl currentNode;
    private NodeFactory nodeFactory;
    private int[] size = new int[100];
    private int depth = 0;
    private Vector arrays = new Vector();
    private boolean previousText;
    private StringBuffer charBuffer;
    private int nextNodeNumber = 1;

    public TreeBuilder() {
        this.nodeFactory = new DefaultNodeFactory();
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public void startDocument() throws TransformerException {
        DocumentImpl documentImpl;
        this.failed = false;
        this.started = true;
        if (this.currentDocument == null) {
            documentImpl = new DocumentImpl();
            this.currentDocument = documentImpl;
        } else {
            if (!(this.currentDocument instanceof DocumentImpl)) {
                throw new TransformerException("Root node supplied is of wrong type");
            }
            documentImpl = (DocumentImpl)this.currentDocument;
            if (documentImpl.getFirstChild() != null) {
                throw new TransformerException("Supplied document is not empty");
            }
        }
        if (this.locator == null || this.locator.getSystemId() == null) {
            this.locator = this;
        }
        documentImpl.setSystemId(this.locator.getSystemId());
        documentImpl.setNamePool(this.namePool);
        documentImpl.setNodeFactory(this.nodeFactory);
        this.currentNode = documentImpl;
        this.depth = 0;
        this.size[this.depth] = 0;
        documentImpl.sequence = 0;
        this.charBuffer = new StringBuffer(this.estimatedLength);
        documentImpl.setCharacterBuffer(this.charBuffer);
        if (this.lineNumbering) {
            documentImpl.setLineNumbering();
        }
    }

    public void endDocument() throws TransformerException {
        if (this.currentNode == null) {
            return;
        }
        this.currentNode.compact(this.size[this.depth]);
        this.currentNode = null;
        this.arrays = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        int n3 = attributes.getLength();
        AttributeCollection attributeCollection = n3 == 0 ? emptyAttributeCollection : new AttributeCollection(this.namePool, attributes);
        ElementImpl elementImpl = this.nodeFactory.makeElementNode(this.currentNode, n, attributeCollection, nArray, n2, this.locator, this.nextNodeNumber++);
        while (this.depth >= this.arrays.size()) {
            this.arrays.addElement(new NodeImpl[20]);
        }
        elementImpl.useChildrenArray((NodeImpl[])this.arrays.elementAt(this.depth));
        int n4 = this.depth;
        int n5 = this.size[n4];
        this.size[n4] = n5 + 1;
        this.currentNode.addChild(elementImpl, n5);
        if (this.depth >= this.size.length - 1) {
            int[] nArray2 = new int[this.size.length * 2];
            System.arraycopy(this.size, 0, nArray2, 0, this.size.length);
            this.size = nArray2;
        }
        this.size[++this.depth] = 0;
        n2 = 0;
        if (this.currentNode instanceof DocumentInfo) {
            ((DocumentImpl)this.currentNode).setDocumentElement(elementImpl);
        }
        this.currentNode = elementImpl;
    }

    public void endElement(int n) throws TransformerException {
        this.currentNode.compact(this.size[this.depth]);
        if (this.previewManager != null && this.previewManager.isPreviewElement(this.currentNode.getFingerprint())) {
            Context context = this.controller.makeContext(this.currentNode);
            this.controller.applyTemplates(context, new SingletonNodeSet(this.currentNode), this.controller.getRuleManager().getMode(this.previewManager.getPreviewMode()), null);
            this.currentNode.dropChildren();
        }
        --this.depth;
        this.currentNode = (ParentNodeImpl)this.currentNode.getParentNode();
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        if (n2 > 0) {
            int n3 = this.charBuffer.length();
            TextImpl textImpl = new TextImpl(this.currentNode, new String(cArray, n, n2));
            int n4 = this.depth;
            int n5 = this.size[n4];
            this.size[n4] = n5 + 1;
            this.currentNode.addChild(textImpl, n5);
            this.previousText = true;
        }
    }

    public void processingInstruction(String string, String string2) {
        if (!this.discardComments) {
            int n = this.namePool.allocate("", "", string);
            ProcInstImpl procInstImpl = new ProcInstImpl(n, string2);
            int n2 = this.depth;
            int n3 = this.size[n2];
            this.size[n2] = n3 + 1;
            this.currentNode.addChild(procInstImpl, n3);
            if (this.locator != null) {
                procInstImpl.setLocation(this.locator.getSystemId(), this.locator.getLineNumber());
            }
        }
    }

    public void comment(char[] cArray, int n, int n2) throws TransformerException {
        if (!this.discardComments) {
            CommentImpl commentImpl = new CommentImpl(new String(cArray, n, n2));
            int n3 = this.depth;
            int n4 = this.size[n3];
            this.size[n3] = n4 + 1;
            this.currentNode.addChild(commentImpl, n4);
        }
    }

    public void graftElement(ElementImpl elementImpl) throws TransformerException {
        int n = this.depth;
        int n2 = this.size[n];
        this.size[n] = n2 + 1;
        this.currentNode.addChild(elementImpl, n2);
    }

    public void setUnparsedEntity(String string, String string2) {
        ((DocumentImpl)this.currentDocument).setUnparsedEntity(string, string2);
    }

    private class DefaultNodeFactory
    implements NodeFactory {
        private DefaultNodeFactory() {
        }

        public ElementImpl makeElementNode(NodeInfo nodeInfo, int n, AttributeCollection attributeCollection, int[] nArray, int n2, Locator locator, int n3) {
            if (attributeCollection.getLength() == 0 && n2 == 0) {
                ElementImpl elementImpl = new ElementImpl();
                String string = null;
                int n4 = -1;
                if (locator != null) {
                    string = locator.getSystemId();
                    n4 = locator.getLineNumber();
                }
                elementImpl.initialise(n, attributeCollection, nodeInfo, string, n4, n3);
                return elementImpl;
            }
            ElementWithAttributes elementWithAttributes = new ElementWithAttributes();
            String string = null;
            int n5 = -1;
            if (locator != null) {
                string = locator.getSystemId();
                n5 = locator.getLineNumber();
            }
            elementWithAttributes.setNamespaceDeclarations(nArray, n2);
            elementWithAttributes.initialise(n, attributeCollection, nodeInfo, string, n5, n3);
            return elementWithAttributes;
        }
    }
}

