Xen device tree
===============

Introduction
------------

xen-devicetree recipe can be used to modify an existing Device Tree Blob,
produced by Linux kernel or another recipe, to include in it entries required
to start Xen and a Dom0 Linux on top of it.

The recipe will do the following processing:
- generate a xen.dtsi file with entries required for xen based on parameters
- turn DTBs in ${XEN_DEVICETREE_DTBS} back to dts
- include in xen.dtsi and all other dtsi from
  ${XEN_DEVICETREE_DTSI_MERGE} (check Bitbake parameters for more information
  on this).
- use dtc to create a new DTB file

The recipe will generate new files in deploy/images and name them with the
extension "-xen.dtb".
For example **machine.dtb** will generate **machine-xen.dtb**.

Entries added to the DTBs
-------------------------

When a DTB is processed by the recipe, the following block is added:
```
    chosen {
        xen,dom0-bootargs = "VAL";
        xen,xen-bootargs = "VAL";

        modules {
            #size-cells = <0x00000001>;
            #address-cells = <0x00000001>;

            module@0 {
                reg = <VAL VAL>;
                compatible = "multiboot,module";
            };
        };
    };
```
Each occurence of **VAL** is replaced by the content of the variables listed in
this documentation.

Bitbake parameters
------------------

Several parameters are available to configure the xen-devicetree during Yocto
project compilation (those can be set in your project local.conf, for exmple).

The following parameters are available:

- XEN_DEVICETREE_DEPEND: This variable can be used to indicate which recipe
  task is generating the DTBs that xen-devicetree will modify. This makes sure
  the xen devicetrees are properly regenerated if the source DTBs are changed.
  This variable is set by default to "virtual/kernel:do_deploy" to use DTBs
  generated during the compilation of the Linux kernel. This must be changed
  if the machine your are using is not using a DTB listed in KERNEL_DEVICETREE.

- XEN_DEVICETREE_DTBS: This should be set to the list of DTBs you want to be
  modified by xen-devicetree. Those must be files that xen-devicetree can find
  in the ${DEPLOY_DIR_IMAGE} directory using only the basename of the entries.
  For example "mydir/board.dtb" will make the recipe look for
  ${DEPLOY_DIR_IMAGE}/board.dtb.
  This variable is set by default to "${KERNEL_DEVICETREE}" to process the DTBs
  generated by the Linux kernel.

- XEN_DEVICETREE_DOM0_MEM: Memory size to allocate to Dom0.
  This variable is only used if XEN_DEVICETREE_XEN_BOOTARGS has a value
  containing "dom0_mem=${XEN_DEVICETREE_DOM0_MEM}" as the memory assigned to
  dom0 is defined using Xen boot arguments.
  This variable is set by default to "1024M".

- XEN_DEVICETREE_DOM0_BOOTARGS: Boot arguments to pass to Dom0 Linux when
  booting it.
  This variable is set by default to "console=hvc0 earlycon=xen".

- XEN_DEVICETREE_XEN_BOOTARGS: this variable should be set with the boot
  arguments to be passed to Xen on boot.
  This variable is set by default to
  "noreboot dom0_mem=${XEN_DEVICETREE_DOM0_MEM}".

- XEN_DEVICETREE_DOM0_ADDR: This is the address from which the Linux kernel to
  be used for Dom0 will be copied. When using u-boot, this is the address at
  which you will load the kernel Image before starting Xen.
  This variable is set by default to "0x80080000".

- XEN_DEVICETREE_DOM0_SIZE: This is the size of the kernel loaded at
  ${XEN_DEVICETREE_DOM0_ADDR}. Xen will copy this amount of data inside the
  guest before starting it so the size must be at least equal to the kernel
  size but can be bigger. You must be careful not to have a value too big as it
  could slow down boot or copy other parts with it (like the DTB).
  You might need to increase this if you use a kernel with a bundled initramfs.
  This variable is set by default to "0x01000000".

- XEN_DEVICETREE_DTSI_MERGE: This variable contains the list of dtsi files that
  must be included inside the generated DTB file. By default the only one
  include is the "xen.dtsi" generated by the recipe.
  If your board or project needs to include more fixes or entries in the DTB,
  this variable can be appended from a bbappend file to include other dtsi. The
  files must be inside the recipe workspace during Yocto compilation.
  You can check xen-devicetree.bbappend for an example.

