/*
 * Copyright 2019-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *     http://aws.amazon.com/apache2.0/
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

#ifndef AACE_ENGINE_CAR_CONTROL_ASSETS_DEFAULT_H
#define AACE_ENGINE_CAR_CONTROL_ASSETS_DEFAULT_H

#include <string>

static const std::string ASSETS_DEFAULT = R"({
  "version": 1,
  "assets": [
    {
      "assetId": "Alexa.Automotive.DeviceName.360Camera",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA",
            "en-IN",
            "en-GB"
          ],
          "defaultValue": "three hundred sixty degree camera",
          "synonyms": [
            "three hundred sixty camera",
            "three sixty degree camera",
            "three sixty camera",
            "three hundred and sixty degree camera",
            "three hundred and sixty camera"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "cámara trescientos sesenta grados",
          "synonyms": [
            "cámara de trescientos sesenta grados",
            "cámara tres sesenta",
            "cámara trescientos sesenta"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "caméra à trois cent soixante",
          "synonyms": [
            "caméra à trois cent soixante degrés",
            "caméra trois cent soixante",
            "caméra trois cent soixante degrés"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "caméra à trois cent soixante",
          "synonyms": [
            "caméra à trois cent soixante degrés",
            "caméra trois cent soixante",
            "caméra trois cent soixante degrés"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "cámara trescientos sesenta grados",
          "synonyms": [
            "cámara de trescientos sesenta grados",
            "cámara tres sesenta",
            "cámara trescientos sesenta"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Dreihundertsechzig-Grad-Kamera",
          "synonyms": [
            "Rundumsicht-Kamera"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "fotocamera a trecentosessanta gradi",
          "synonyms": [
            "macchina fotografica a trecentosessanta gradi",
            "fotocamera trecentosessanta gradi"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.AVMCamera",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "AVM camera",
          "synonyms": [
            "a. v. m. camera"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "camara de 360 grados",
          "synonyms": [
            "camara de visión periférica",
            "camara AVM",
            "monitor de visión periférica",
            "camara a. v. m."
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "système de vision 3D",
          "synonyms": [
            "système AVM",
            "système a. v. m.",
            "système de vision à 360",
            "système de vision 360 degrés",
            "moniteur de vision 3D",
            "système de caméra 3D",
            "système de camera à 360",
            "système de camera à 360 degrés"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "AVM camera",
          "synonyms": [
            "a. v. m. camera"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "AVM camera",
          "synonyms": [
            "a. v. m. camera"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "système de vision 3D",
          "synonyms": [
            "système AVM",
            "système a. v. m.",
            "système de vision à 360",
            "système de vision 360 degrés",
            "moniteur de vision 3D"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "camara de 360 grados",
          "synonyms": [
            "camara de visión periférica",
            "camara AVM",
            "camara a. v. m.",
            "monitor de visión periférica"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "360 Grad Kamera",
          "synonyms": [
            "AVM Kamera",
            "3D Kamera",
            "3D Monitor",
            "a. v. m. Kamera"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sistema AVM",
          "synonyms": [
            "sistema di visione a 360 gradi",
            "sistema di telecamera a 360 gradi",
            "sistema con videocamera a 360 gradi",
            "sistema a. v. m."
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.AirConditioner",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "air conditioner",
          "synonyms": [
            "air conditioning",
            "air con",
            "aircon",
            "ac",
            "a c"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "aire acondicionado",
          "synonyms": [
            "climatización",
            "aire",
            "ac",
            "a c"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "air climatisé",
          "synonyms": [
            "climatiseur",
            "climatiseurs",
            "climatisation",
            "ac",
            "air conditionné",
            "conditionneur d'air"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "air conditioner",
          "synonyms": [
            "air conditioning",
            "air con",
            "aircon",
            "ac",
            "a c"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "air conditioner",
          "synonyms": [
            "air conditioning",
            "air con",
            "aircon",
            "ac",
            "a c"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "climatiseur",
          "synonyms": [
            "climatiseurs",
            "climatisation",
            "air conditionné",
            "ac",
            "A.C."
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "aire acondicionado",
          "synonyms": [
            "climatización"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Klimaanlage",
          "synonyms": [
            "Klima",
            "A.C."
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "aria condizionata",
          "synonyms": [
            "condizionatore",
            "condizionatore d' aria"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.AmbientLight",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "ambient light",
          "synonyms": [
            "ambient lighting",
            "mood light",
            "mood lighting"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "luz ambiental",
          "synonyms": [
            "iluminación ambiental",
            "luz de ambiente",
            "iluminación de ambiente"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "lumière ambiante",
          "synonyms": [
            "lumières ambiantes",
            "éclairage ambiant",
            "éclairages ambiants",
            "lumière d'ambiance",
            "lumières d'ambiance",
            "éclairage d'ambiance",
            "éclairages d'ambiance",
            "lampe d'ambiance",
            "lampes d'ambiance"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "ambient light",
          "synonyms": [
            "ambient lighting",
            "mood light",
            "mood lighting"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "ambient light",
          "synonyms": [
            "ambient lighting",
            "mood light",
            "mood lighting"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "lumière ambiante",
          "synonyms": [
            "lumière ambiantes",
            "éclairage ambiant",
            "éclairages ambiants",
            "lumière d'ambiance",
            "lumières d'ambiance",
            "éclairage d'ambiance",
            "éclairages d'ambiance",
            "lampe d'ambiance",
            "lampes d'ambiance"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "luz ambiental",
          "synonyms": [
            "iluminación ambiental",
            "luz de ambiente",
            "iluminación de ambiente"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Umgebungslicht",
          "synonyms": [
            "Umgebungsbeleuchtung",
            "Stimmungslicht",
            "Stimmungsbeleuchtung"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "illuminazione ambientale",
          "synonyms": [
            "illuminazione d'ambiente",
            "luce ambient",
            "ambient lighting",
            "mood lighting",
            "illuminazione di atmosfera",
            "luce ambientale"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Armrest",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "armrest",
          "synonyms": [
            "arm rest"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "descansabrazos",
          "synonyms": [
            "apoyabrazos",
            "reposabrazos"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "appuie-bras",
          "synonyms": [
            "accoudoir",
            "accoudoirs"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "armrest",
          "synonyms": [
            "arm rest"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "armrest",
          "synonyms": [
            "arm rest"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "accoudoir",
          "synonyms": [
            "accoudoirs"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "reposabrazos",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Armlehne",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "bracciolo",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.CabinLight",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "cabin light",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "luz de la cabina",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "plafonnier",
          "synonyms": [
            "plafonniers",
            "lumière du plafond",
            "lumières du plafond",
            "lampe du plafond",
            "lampes du plafond",
            "lumière intérieure",
            "lampe intérieure",
            "lampes intérieures",
            "lumières intérieures",
            "lumière de l'habitacle",
            "lumières de l'habitacle",
            "lampe de l'habitacle",
            "lampes de l'habitacle"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "cabin light",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "cabin light",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "plafonnier",
          "synonyms": [
            "plafonniers",
            "lumière du plafond",
            "lumières du plafond",
            "lampe du plafond",
            "lampes du plafond",
            "lumière intérieure",
            "lampe intérieure",
            "lampes intérieures",
            "lumières intérieures",
            "lumière de l'habitacle",
            "lumières de l'habitacle",
            "lampe de l'habitacle",
            "lampes de l'habitacle"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "luz del habitáculo",
          "synonyms": [
            "luz de habitáculo"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Innenraumbeleuchtung",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "luce abitacolo",
          "synonyms": [
            "luce dell'abitacolo"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Car",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "car",
          "synonyms": [
            "automobile"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "carro",
          "synonyms": [
            "coche",
            "auto",
            "automóvil",
            "vehículo"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "voiture",
          "synonyms": [
            "auto",
            "automobile",
            "char"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "car",
          "synonyms": [
            "automobile"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "car",
          "synonyms": [
            "automobile"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "voiture",
          "synonyms": [
            "automobile"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "coche",
          "synonyms": [
            "automóvil",
            "Vehículo"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Auto",
          "synonyms": [
            "Fahrzeug"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "auto",
          "synonyms": [
            "automobile",
            "macchina"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.ChargeDoor",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "charge door",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "tapa del cargador",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "trappe de la prise de recharge",
          "synonyms": [
            "trappe de rechargement"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "charge door",
          "synonyms": [
            "charging door"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "charge door",
          "synonyms": [
            "charging door"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "trappe de la prise de recharge",
          "synonyms": [
            "trappe de rechargement"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "tapa del cargador",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Strom-Tankdeckel",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "porta di ricarica",
          "synonyms": [
            "sportello della porta di ricarica"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.ClimateControl",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "climate control",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "climatización",
          "synonyms": [
            "control de temperatura"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "contrôle de la température",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "climate control",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "climate control",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "contrôle de la température",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "climatización",
          "synonyms": [
            "Sistema de climatización",
            "climatizador"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Klimatisierung",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "controllo clima",
          "synonyms": [
            "climatizzatore"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Cooler",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "cooler",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "enfriador",
          "synonyms": [
            "sistema de enfriación"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "système de refroidissement",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "cooler",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "cooler",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "système de refroidissement",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "refrigerador",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Kühlung",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "aria fredda",
          "synonyms": [
            "raffreddamento"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.CupHolder",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "cup holder",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "portavasos",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "porte-gobelet",
          "synonyms": [
            "porte gobelet",
            "portes-gobelets",
            "portes gobelets"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "cup holder",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "cup holder",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "porte-gobelet",
          "synonyms": [
            "porte gobelet",
            "portes-gobelets",
            "portes gobelets"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "Posavasos",
          "synonyms": [
            "portavasos"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Getränkehalter",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "portabicchieri",
          "synonyms": [
            "portabicchiere"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Display",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "display",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "pantalla",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran d'affichage",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "display",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "display",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran d'affichage",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "pantalla",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Bildschirmanzeige",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "monitor",
          "synonyms": [
            "schermo",
            "schermata"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.DisplayScreen",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "display",
          "synonyms": [
            "screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "pantalla",
          "synonyms": [
            "pantalla de visualización"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran d'affichage",
          "synonyms": [
            "écrans d'affichage"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "display",
          "synonyms": [
            "screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "display",
          "synonyms": [
            "screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran d'affichage",
          "synonyms": [
            "écrans d'affichage"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "pantalla",
          "synonyms": [
            "pantalla de visualización"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Bildschirmanzeige",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "monitor",
          "synonyms": [
            "schermo",
            "schermo di visualizzazione",
            "schermata"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.DomeLight",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "dome light",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "luz del techo",
          "synonyms": [
            "luz interior"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "plafonnier",
          "synonyms": [
            "plafonniers",
            "lumière du plafond",
            "lumières du plafond",
            "lampe du plafond",
            "lampes du plafond",
            "lumière intérieure",
            "lampe intérieure",
            "lampes intérieures",
            "lumières intérieures",
            "lumière de l'habitacle",
            "lumières de l'habitacle",
            "lampe de l'habitacle",
            "lampes de l'habitacle"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "dome light",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "dome light",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "plafonnier",
          "synonyms": [
            "plafonniers",
            "lumière du plafond",
            "lumières du plafond",
            "lampe du plafond",
            "lampes du plafond",
            "lumière intérieure",
            "lampe intérieure",
            "lampes intérieures",
            "lumières intérieures",
            "lumière de l'habitacle",
            "lumières de l'habitacle",
            "lampe de l'habitacle",
            "lampes de l'habitacle"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "luz del techo",
          "synonyms": [
            "luz de habitáculo"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Innenleuchten",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "luce di cortesia",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.DriverSeat",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "driver seat",
          "synonyms": [
            "driver side seat",
            "seat"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "asiento del conductor",
          "synonyms": [
            "asiento del lado del conductor",
            "asiento"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "siège conducteur",
          "synonyms": [
            "siège côté conducteur",
            "siège du conducteur",
            "siège"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "driver seat",
          "synonyms": [
            "driver side seat"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "driver seat",
          "synonyms": [
            "driver side seat"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "siège conducteur",
          "synonyms": [
            "siège côté conducteur",
            "siège du conducteur",
            "siège"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "asiento del conductor",
          "synonyms": [
            "asiento del lado del conductor",
            "asiento"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Fahrersitz",
          "synonyms": [
            "Autositz"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sedile del guidatore",
          "synonyms": [
            "sedile"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Fan",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "fan",
          "synonyms": [
            "air",
            "blower",
            "air flow",
            "airflow"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "ventilador",
          "synonyms": [
            "soplador",
            "flujo de aire",
            "ventilación"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "fan",
          "synonyms": [
            "ventilateur",
            "air",
            "ventilation",
            "débit d'air",
            "flux d' air"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "fan",
          "synonyms": [
            "air",
            "blower",
            "air flow",
            "airflow"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "fan",
          "synonyms": [
            "air",
            "blower",
            "air flow",
            "airflow"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "ventilateur",
          "synonyms": [
            "ventilateurs",
            "air",
            "ventilation",
            "flux d'air",
            "grille de ventilation",
            "grilles de ventilation"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "ventilador",
          "synonyms": [
            "ventilación",
            "flujo de aire"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Lüfter",
          "synonyms": [
            "Luft",
            "Gebläse",
            "Luftstrom"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "ventola",
          "synonyms": [
            "ventilatore",
            "aria",
            "flusso d'aria",
            "areazione"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.FogLight",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "fog light",
          "synonyms": [
            "fog lights"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "faros antiniebla",
          "synonyms": [
            "luces antiniebla",
            "neblineros"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "feux de brouillard",
          "synonyms": [
            "phares antibrouillard",
            "feux antibrouillard"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "fog light",
          "synonyms": [
            "fog lights"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "fog light",
          "synonyms": [
            "fog lights"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "feux de brouillard",
          "synonyms": [
            "phares antibrouillard",
            "feux antibrouillard"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "luces antiniebla",
          "synonyms": [
            "faros antiniebla"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Nebelscheinwerfer",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "fendinebbia",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.GasDoor",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "gas door",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "tapa de la gasolina",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "porte du réservoir",
          "synonyms": [
            "trappe à carburant",
            "trappe à essence"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "fuel door",
          "synonyms": [
            "gas door",
            "petrol door",
            "diesel door",
            "fuel tank door",
            "petrol tank door",
            "diesel tank door"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "fuel door",
          "synonyms": [
            "gas door"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "porte du réservoir",
          "synonyms": [
            "trappe à carburant",
            "trappe à essence"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "tapa del depósito",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Tankdeckel",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sportello del serbatoio",
          "synonyms": [
            "sportellino del serbatoio"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.HUD",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "heads up display",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "pantalla HUD",
          "synonyms": [
            "HUD",
            "heads up display"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "affichage tête haute",
          "synonyms": [
            "HUD",
            "affichage frontal"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "heads up display",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "heads up display",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "affichage tête haute",
          "synonyms": [
            "HUD",
            "affichage frontal"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "pantalla HUD",
          "synonyms": [
            "HUD",
            "heads up display"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Frontscheibenanzeige",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "heads up display",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.HazardLights",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "hazard lights",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "luces de emergencia",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "phares d'urgence",
          "synonyms": [
            "lumière d'urgence"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "hazard lights",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "hazard lights",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "feux de détresse",
          "synonyms": [
            "warnings"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "luces de emergencia",
          "synonyms": [
            "luz de emergencia"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Warnblinkleuchten",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "luci di emergenza",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Headlight",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "headlights",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "faros",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "phares",
          "synonyms": [
            "lumières"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "headlights",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "headlights",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "Phares",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "faros",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Scheinwerfer",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "fari",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Heater",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "heater",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "calefactor",
          "synonyms": [
            "calefacción",
            "calentador"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "chauffage",
          "synonyms": [
            "chauffé"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "heater",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "heater",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "chauffage",
          "synonyms": [
            "chauffé"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "radiador",
          "synonyms": [
            "calefactor",
            "calefacción",
            "calentador"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Heizung",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "riscaldamento",
          "synonyms": [
            "riscaldabile",
            "riscaldabili",
            "riscaldati"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.HighBeam",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "high beams",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "luces altas",
          "synonyms": [
            "luces intensas"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "phares à haute intensité",
          "synonyms": [
            "lumières à haute intensité"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "high beams",
          "synonyms": [
            "beams",
            "full beams"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "high beams",
          "synonyms": [
            "beams",
            "full beams"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "feux de route",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "luz de carretera",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Fernlicht",
          "synonyms": [
            "Fahrzeug-Fernlicht"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "abbaglianti",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Hood",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "hood",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "cofre",
          "synonyms": [
            "capó",
            "tapa del motor"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "capot",
          "synonyms": [
            "hood"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "hood",
          "synonyms": [
            "bonnet"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "hood",
          "synonyms": [
            "bonnet"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "capot",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "capó",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Motorhaube",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "cofano",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.InfoScreen",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "infotainment screen",
          "synonyms": [
            "infotainment",
            "ivi",
            "i. v. i."
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "pantalla de infotainment",
          "synonyms": [
            "pantalla de información y entretenimiento",
            "ivi",
            "i. v. i."
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "interfaces d'info-divertissement",
          "synonyms": [
            "info-divertissement",
            "info et divertissement",
            "système d'info-divertissement",
            "écrans d'info-divertissement",
            "écrans d'information et divertissement",
            "système d'information et divertissements"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "infotainment screen",
          "synonyms": [
            "infotainment",
            "ivi",
            "i. v. i."
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "infotainment screen",
          "synonyms": [
            "infotainment",
            "ivi",
            "i. v. i."
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "interfaces d'info-divertissement",
          "synonyms": [
            "info-divertissement",
            "info et divertissement",
            "système d'info-divertissement",
            "écrans d'info-divertissement",
            "écrans d'information et divertissement",
            "système d'information et divertissements"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "pantalla de infotainment",
          "synonyms": [
            "pantalla de infoentretenimiento"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Infotainment-Bildschirm",
          "synonyms": [
            "Infotainment",
            "ivi",
            "i. v. i."
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "schermo dell' infotainment",
          "synonyms": [
            "infotainment"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.LeftSeat",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "left seat",
          "synonyms": [
            "left side seat"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "asiento izquierdo",
          "synonyms": [
            "asiento de la izquierda",
            "asiento del lado izquierdo"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "siège gauche",
          "synonyms": [
            "siège de gauche",
            "siège côté gauche"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "left seat",
          "synonyms": [
            "left side seat"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "left seat",
          "synonyms": [
            "left side seat"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "siège de gauche",
          "synonyms": [
            "siège côté gauche",
            "siège gauche"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "asiento izquierdo",
          "synonyms": [
            "asiento de la izquierda",
            "asiento del lado izquierdo"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "linker Sitz",
          "synonyms": [
            "linksseitiger Sitz"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sedile sinistro",
          "synonyms": [
            "sedile di sinistra",
            "sedile lato sinistro"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Light",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "light",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "luz",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "lampe",
          "synonyms": [
            "lampes",
            "lumière",
            "lumières"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "light",
          "synonyms": [
            "lights"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "light",
          "synonyms": [
            "lights"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "lampe",
          "synonyms": [
            "lampes",
            "lumière",
            "lumières"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "luz",
          "synonyms": [
            "luces"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Licht",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "luce",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Moonroof",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "moonroof",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "techo corredizo",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "toit ouvrant",
          "synonyms": [
            "toit panoramique",
            "toit vitré",
            "fenêtre de toit"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "moonroof",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "moonroof",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "toit ouvrant",
          "synonyms": [
            "toit panoramique",
            "toit vitré",
            "fenêtre de toit"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "techo corredizo",
          "synonyms": [
            "techo panorámico"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Schiebedach",
          "synonyms": [
            "Glasschiebedach"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "cappotta",
          "synonyms": [
            "capote",
            "tettuccio apribile",
            "tettino apribile"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.ParkingLights",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "parking lights",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "luces de estacionamiento",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "feux de stationnement",
          "synonyms": [
            "phares de stationnement",
            "lampes de stationnement"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "parking lights",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "parking lights",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "feux de stationnement",
          "synonyms": [
            "phares de stationnement",
            "lampes de stationnement"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "luces de estacionamiento",
          "synonyms": [
            "luces de aparcamiento"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Standlicht",
          "synonyms": [
            "Standlichter"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "luci di stazionamento",
          "synonyms": [
            "luci di sosta",
            "fari di stazionamento",
            "fari di sosta"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.PassengerSeat",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "passenger seat",
          "synonyms": [
            "passenger side seat"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "asiento del pasajero",
          "synonyms": [
            "asiento del lado del pasajero",
            "asiento del copiloto",
            "asiento del lado del copiloto"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "siège du passager",
          "synonyms": [
            "siège passager"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "passenger seat",
          "synonyms": [
            "passenger side seat"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "passenger seat",
          "synonyms": [
            "passenger side seat"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "siège passager",
          "synonyms": [
            "siège côté passager",
            "siège du passager"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "asiento del pasajero",
          "synonyms": [
            "asiento del lado del pasajero",
            "asiento del copiloto",
            "asiento del lado del copiloto"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Beifahrersitz",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sedile del passeggero",
          "synonyms": [
            "sedile dal lato del passeggero",
            "sedile del lato del passeggero"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.ReadingLight",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "reading light",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "luz de lectura",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "lampe de lecture",
          "synonyms": [
            "lampes de lecture",
            "liseuse",
            "liseuses",
            "lumière de lecture"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "reading light",
          "synonyms": [
            "reading lamp"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "reading light",
          "synonyms": [
            "reading lamp"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "lampe de lecture",
          "synonyms": [
            "lampes de lecture",
            "liseuse",
            "liseuses"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "luz de lectura",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Leselampe",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "luce lettura",
          "synonyms": [
            "luce da lettura",
            "luce di lettura"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.RightSeat",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "right seat",
          "synonyms": [
            "right side seat"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "asiento derecho",
          "synonyms": [
            "asiento de la derecha",
            "asiento del lado derecho"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "siège droit",
          "synonyms": [
            "siège de droite",
            "siège côté droit"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "right seat",
          "synonyms": [
            "right side seat"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "right seat",
          "synonyms": [
            "right side seat"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "siège de droite",
          "synonyms": [
            "siège côté droit",
            "siège droit"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "asiento derecho",
          "synonyms": [
            "asiento de la derecha",
            "asiento del lado derecho"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "rechter Sitz",
          "synonyms": [
            "rechtsseitiger Sitz"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sedile destro",
          "synonyms": [
            "sedile di destra",
            "sedile lato destro"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Seat",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "seat",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "asiento",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "siège",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "seat",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "seat",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "siège",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "asiento",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Sitz",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sedile",
          "synonyms": [
            "sedili"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.SeatHeater",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "seat heater",
          "synonyms": [
            "seat heating"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "calentador de asiento",
          "synonyms": [
            "calefaccóin de asiento"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "siège chauffant",
          "synonyms": [
            "sièges chauffants",
            "siège chauffé",
            "sièges chauffés",
            "chauffage du siège"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "seat heater",
          "synonyms": [
            "seat heating"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "seat heater",
          "synonyms": [
            "seat heating"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "siège chauffant",
          "synonyms": [
            "sièges chauffants",
            "siège chauffé",
            "sièges chauffés",
            "chauffage du siège"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "calentador de asiento",
          "synonyms": [
            "calefaccóin de asiento",
            "Calefacción de los asientos",
            "calefacción del asiento"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Sitzheizung",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "riscaldamento sedile",
          "synonyms": [
            "sedile riscaldabile",
            "riscaldamento del sedile"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.SteeringWheel",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "steering wheel",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "volante",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "volant",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "steering wheel",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "steering wheel",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "volant",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "volante",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Lenkrad",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "volante",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Sunroof",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "sunroof",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "techo corredizo",
          "synonyms": [
            "sunroof",
            "quemacocos",
            "techo solar"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "toit ouvrant",
          "synonyms": [
            "toit panoramique",
            "toit vitré",
            "fenêtre de toit"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "sunroof",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "sunroof",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "toit ouvrant",
          "synonyms": [
            "toit panoramique",
            "toit vitré",
            "fenêtre de toit"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "techo corredizo",
          "synonyms": [
            "sunroof",
            "quemacocos",
            "techo solar"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Schiebedach",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "tetto apribile",
          "synonyms": [
            "tettuccio apribile",
            "tettuccio"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Sunshade",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "sun shade",
          "synonyms": [
            "sunshade"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "parasol",
          "synonyms": [
            "protector de sol"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "pare-soleil",
          "synonyms": [
            "pares-soleil"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "sun shade",
          "synonyms": [
            "shade",
            "sunshade"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "sun shade",
          "synonyms": [
            "shade",
            "sunshade"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "pare-soleil",
          "synonyms": [
            "pares-soleil"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "parasol",
          "synonyms": [
            "visor del techo solar"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Sonnenblende",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "parasole",
          "synonyms": [
            "visiera"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Tailgate",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "tailgate",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "puerta trasera",
          "synonyms": [
            "puerta de caja",
            "puerta de la cajuela",
            "puerta de cajuela"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "hayon",
          "synonyms": [
            "tailgate"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "tailgate",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "tailgate",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "hayon",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "puerta del maletero",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Heckklappe",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "portellone",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Trunk",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "trunk",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "cajuela",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "valise",
          "synonyms": [
            "coffre"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "boot",
          "synonyms": [
            "trunk",
            "dickie"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "boot",
          "synonyms": [
            "trunk"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "coffre",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "maletero",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Kofferraum",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "bagagliaio",
          "synonyms": [
            "baule"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.TrunkLight",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "trunk light",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "luz del maletero",
          "synonyms": [
            "luz de la cajuela"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "lumière du coffre",
          "synonyms": [
            "lumières du coffre",
            "lampe de la valise",
            "lampes de la valise",
            "lumière de la valise",
            "lumières de la valise"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "trunk light",
          "synonyms": [
            "boot light",
            "dickey light"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "trunk light",
          "synonyms": [
            "boot light"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "lumière du coffre",
          "synonyms": [
            "lumières du coffre",
            "lampe du coffre",
            "lampes du coffre"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "luz del maletero",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Kofferraumbeleuchtung",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "luce bagagliaio",
          "synonyms": [
            "luce del bagagliaio",
            "luce baule",
            "luce del baule"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Vent",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "vent",
          "synonyms": [
            "vents",
            "air vent",
            "air vents",
            "air outlet",
            "ait outlets"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "rejilla",
          "synonyms": [
            "rejillas",
            "rejilla del aire",
            "rejillas del aire",
            "salida del aire",
            "salidas del aire",
            "rejilla de aire",
            "salida de aire"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "bouche d’air",
          "synonyms": [
            "bouches d’air",
            "bouche d’aération",
            "bouches d’aération",
            "sortie d’air",
            "sorties d’air"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "vent",
          "synonyms": [
            "vents",
            "air vent",
            "air vents",
            "air outlet",
            "ait outlets"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "vent",
          "synonyms": [
            "vents",
            "air vent",
            "air vents",
            "air outlet",
            "ait outlets"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "aération",
          "synonyms": [
            "aérations",
            "grille d'aération",
            "grilles d'aération",
            "sortie d'air",
            "sorties d'air"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "rejilla",
          "synonyms": [
            "rejillas",
            "rejilla del aire",
            "rejillas del aire",
            "salida del aire",
            "salidas del aire"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Lüftung",
          "synonyms": [
            "Lüftungsschlitze",
            "Belüftung",
            "Belüftungsschlitze",
            "Luftauslass",
            "Luftauslässe"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "bocchetta di areazione",
          "synonyms": [
            "bocchette di areazione",
            "bocchetta di ventilazione",
            "bocchette di ventilazione",
            "bocchetta dell'aria",
            "bocchette dell'aria",
            "bocchetta",
            "bocchette"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Window",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "window",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "ventana",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "fenêtre",
          "synonyms": [
            "fenêtres",
            "vitre",
            "vitres"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "window",
          "synonyms": [
            "windows",
            "car window",
            "car windows"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "window",
          "synonyms": [
            "windows",
            "car window",
            "car windows"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "fenêtre",
          "synonyms": [
            "fenêtres",
            "vitre",
            "vitres"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "ventanilla",
          "synonyms": [
            "ventanillas",
            "ventana",
            "ventanas"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Fenster",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "finestrino",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.Windshield",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "windshield",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "parabrisas",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "pare-brise",
          "synonyms": [
            "windshield"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "windshield",
          "synonyms": [
            "windscreen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "windshield",
          "synonyms": [
            "windscreen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "pare-brise",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "parabrisas",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Windschutzscheibe",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "parabrezza",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.DeviceName.WindshieldWipers",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "wipers",
          "synonyms": [
            "windshield wipers",
            "windscreen wipers"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "limpiaparabrisas",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "essuie-glaces",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "wipers",
          "synonyms": [
            "windshield wipers",
            "windscreen wipers"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "wipers",
          "synonyms": [
            "windshield wipers",
            "windscreen wipers"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "essuie-glaces",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "limpiaparabrisas",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Scheibenwischer",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "tergicristalli",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.All",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "everywhere",
          "synonyms": [
            "all"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "en todas partes",
          "synonyms": [
            "todo"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "partout",
          "synonyms": [
            "tous"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "everywhere",
          "synonyms": [
            "all"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "everywhere",
          "synonyms": [
            "all"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "partout",
          "synonyms": [
            "tous"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "en todas partes",
          "synonyms": [
            "todo"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "überall",
          "synonyms": [
            "alle"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "ovunque",
          "synonyms": [
            "dovunque",
            "tutte",
            "tutti"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.Driver",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "driver",
          "synonyms": [
            "front driver",
            "driver side"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "conductor",
          "synonyms": [
            "conductor delantero",
            "lado del conductor"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "conducteur",
          "synonyms": [
            "conducteur avant",
            "côté conducteur",
            "côté du conducteur"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "driver",
          "synonyms": [
            "front driver",
            "driver side"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "driver",
          "synonyms": [
            "front driver",
            "driver side"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "conducteur",
          "synonyms": [
            "conducteur avant",
            "côté conducteur",
            "côté du conducteur"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "conductor",
          "synonyms": [
            "piloto",
            "lado del conductor"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Fahrer",
          "synonyms": [
            "Fahrersitz",
            "Fahrerseite"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "guidatore",
          "synonyms": [
            "guidatore anteriore",
            "guidatore davanti",
            "lato del guidatore",
            "lato dell’autista"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.DriverRow",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "driver row",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "fila del conductor",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "rangée conducteur",
          "synonyms": [
            "côté conducteur"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "driver row",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "driver row",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "rangée conducteur",
          "synonyms": [
            "côté conducteur"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "fila del conductor",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Vordere Sitzreihe",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "fila del guidatore",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.FirstRow",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "first row",
          "synonyms": [
            "1st row"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "primera fila",
          "synonyms": [
            "1.° fila",
            "1.ª fila"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "première rangée",
          "synonyms": [
            "1re rangée"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "first row",
          "synonyms": [
            "1st row"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "first row",
          "synonyms": [
            "1st row"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "première rangée",
          "synonyms": [
            "1ère rangée"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "primera fila",
          "synonyms": [
            "1.ª fila"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Erste Sitzreihe",
          "synonyms": [
            "1. Sitzreihe"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "prima fila",
          "synonyms": [
            "1a fila"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.FourthRow",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "fourth row",
          "synonyms": [
            "4th row"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "cuarta fila",
          "synonyms": [
            "4.° fila",
            "4.ª fila"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "quatrième rangée",
          "synonyms": [
            "4e rangée"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "fourth row",
          "synonyms": [
            "4th row"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "fourth row",
          "synonyms": [
            "4th row"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "quatrième rangée",
          "synonyms": [
            "4ème rangée"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "cuarta fila",
          "synonyms": [
            "4.ª fila"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Vierte Sitzreihe",
          "synonyms": [
            "4. Sitzreihe"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "quarta fila",
          "synonyms": [
            "4a fila"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.Front",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "front",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "frente",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "avant",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "front",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "front",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "avant",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "frontal",
          "synonyms": [
            "zona frontal",
            "zona delantera",
            "parte delantera"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Vorderseite",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "davanti",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.FrontLeft",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "front left",
          "synonyms": [
            "left front"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "frontal izquierda",
          "synonyms": [
            "delantera izquierda",
            "izquierda frontal",
            "izquierda delantera"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "avant-gauche",
          "synonyms": [
            "avant gauche"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "front left",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "front left",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "avant-gauche",
          "synonyms": [
            "avant gauche"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "frontal izquierda",
          "synonyms": [
            "delantera izquierda",
            "izquierda frontal"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "vorne links",
          "synonyms": [
            "links vorne"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "anteriore sinistro",
          "synonyms": [
            "parte anteriore sinistra",
            "sinistra frontale",
            "parte sinistra frontale"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.FrontRight",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "front right",
          "synonyms": [
            "right front"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "frontal derecha",
          "synonyms": [
            "delantera derecha",
            "derecha frontal",
            "derecha delantera"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "avant-droit",
          "synonyms": [
            "avant-droite",
            "avant droit",
            "avant droite"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "front right",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "front right",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "avant-droit",
          "synonyms": [
            "avant-droite",
            "avant droit",
            "avant droite"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "frontal derecha",
          "synonyms": [
            "delantera derecha",
            "derecha frontal"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "vorne rechts",
          "synonyms": [
            "rechts vorne"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "anteriore destro",
          "synonyms": [
            "parte anteriore destra",
            "destra frontale",
            "parte destra frontale"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.Left",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "left",
          "synonyms": [
            "left side"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "izquierda",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "gauche",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "left",
          "synonyms": [
            "left side"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "left",
          "synonyms": [
            "left side"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "gauche",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "izquierda",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "links",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "destra",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.Passenger",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "passenger",
          "synonyms": [
            "front passenger",
            "passenger side"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "pasajero",
          "synonyms": [
            "pasajero delantero",
            "lado del pasajero",
            "lado del copiloto"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "passager",
          "synonyms": [
            "passager avant",
            "côté passager",
            "côté du passager"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "passenger",
          "synonyms": [
            "front passenger",
            "passenger side"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "passenger",
          "synonyms": [
            "front passenger",
            "passenger side"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "passager",
          "synonyms": [
            "passager avant",
            "côté passager",
            "côté du passager"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "pasajero",
          "synonyms": [
            "pasajero delantero",
            "copiloto",
            "lado del pasajero",
            "lado del copiloto"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Beifahrer",
          "synonyms": [
            "Beifahrersitz",
            "Beifahrerseite"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "passeggero",
          "synonyms": [
            "passeggero anteriore",
            "passeggero davanti",
            "lato del passeggero"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.PassengerRow",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "passenger row",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "fila del pasajero",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "rangée passager",
          "synonyms": [
            "côté passager"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "passenger row",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "passenger row",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "rangée passager",
          "synonyms": [
            "côté passager"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "fila del pasajero",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Rücksitzbank",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "fila del passeggero",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.Rear",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "rear",
          "synonyms": [
            "back"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "parte posterior",
          "synonyms": [
            "atrás"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "arrière",
          "synonyms": [
            "derrière"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "rear",
          "synonyms": [
            "back"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "rear",
          "synonyms": [
            "back"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "arrière",
          "synonyms": [
            "derrière"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "parte posterior",
          "synonyms": [
            "zona posterior",
            "parte trasera",
            "atrás"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Fond",
          "synonyms": [
            "Rückseite"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "dietro",
          "synonyms": [
            "posteriore"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.RearDriver",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "rear driver",
          "synonyms": [
            "back driver"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "conductor trasero",
          "synonyms": [
            "conductor posterior"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "conducteur arrière",
          "synonyms": [
            "chauffeur arrière"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "rear driver",
          "synonyms": [
            "back driver"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "rear driver",
          "synonyms": [
            "back driver"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "conducteur arrière",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "conductor trasero",
          "synonyms": [
            "conductor posterior"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "hinterer Fahrer",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "guidatore posteriore",
          "synonyms": [
            "guidatore dietro"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.RearLeft",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "rear left",
          "synonyms": [
            "left rear"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "trasera izquierda",
          "synonyms": [
            "posterior izquierda",
            "izquierda trasera",
            "izquierda posterior"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "arrière gauche",
          "synonyms": [
            "arrière-gauche"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "rear left",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "rear left",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "arrière gauche",
          "synonyms": [
            "arrière-gauche"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "trasera izquierda",
          "synonyms": [
            "posterior izquierda",
            "izquierda posterior",
            "izquierda trasera"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "hinten links",
          "synonyms": [
            "links hinten"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "posteriore sinistro",
          "synonyms": [
            "parte posteriore sinistra",
            "sinistra posteriore",
            "parte sinistra posteriore"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.RearPassenger",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "rear passenger",
          "synonyms": [
            "back passenger"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "pasajero trasero",
          "synonyms": [
            "pasajero posterior"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "passager arrière",
          "synonyms": [
            "passager à l'arrière"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "rear passenger",
          "synonyms": [
            "back passenger"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "rear passenger",
          "synonyms": [
            "back passenger"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "passager arrière",
          "synonyms": [
            "passager à l'arrière"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "pasajero trasero",
          "synonyms": [
            "pasajero posterior"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Mitfahrer",
          "synonyms": [
            "Fahrgast auf dem Rücksitz"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "passeggero posteriore",
          "synonyms": [
            "passeggero dietro"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.RearRight",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "rear right",
          "synonyms": [
            "right rear"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "trasera derecha",
          "synonyms": [
            "posterior derecha",
            "derecha trasera",
            "derecha posterior"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "arrière-droit",
          "synonyms": [
            "arrière-droite",
            "arrière droite",
            "arrière droit"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "rear right",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "rear right",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "arrière-droit",
          "synonyms": [
            "arrière-droite",
            "arrière droite",
            "arrière droit"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "trasera derecha",
          "synonyms": [
            "posterior derecha",
            "derecha posterior",
            "derecha trasera"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "hinten rechts",
          "synonyms": [
            "rechts hinten"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "posteriore destro",
          "synonyms": [
            "parte posteriore destra",
            "destra posteriore",
            "parte destra posteriore"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.Right",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "right",
          "synonyms": [
            "right side"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "derecha",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "droite",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "right",
          "synonyms": [
            "right side"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "right",
          "synonyms": [
            "right side"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "droite",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "derecha",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "rechts",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "diritto",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.SecondRow",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "second row",
          "synonyms": [
            "2nd row"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "segunda fila",
          "synonyms": [
            "2.° fila",
            "2.ª fila"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "deuxième rangée",
          "synonyms": [
            "2ème rangée",
            "2nde rangée"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "second row",
          "synonyms": [
            "2nd row"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "second row",
          "synonyms": [
            "2nd row"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "deuxième rangée",
          "synonyms": [
            "2ème rangée",
            "2nde rangée"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "segunda fila",
          "synonyms": [
            "2.ª fila"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Zweite Sitzreihe",
          "synonyms": [
            "2. Sitzreihe"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "seconda fila",
          "synonyms": [
            "2a fila"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Location.ThirdRow",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "third row",
          "synonyms": [
            "3rd row"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "tercera fila",
          "synonyms": [
            "3.° fila",
            "3.ª fila"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "troisième rangée",
          "synonyms": [
            "3e rangée"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "third row",
          "synonyms": [
            "3rd row"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "third row",
          "synonyms": [
            "3rd row"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "troisième rangée",
          "synonyms": [
            "3ème rangée"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "tercera fila",
          "synonyms": [
            "3.ª fila"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Dritte Sitzreihe",
          "synonyms": [
            "3. Sitzreihe"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "terza fila",
          "synonyms": [
            "3a fila"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.AirRecirculation",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "air recirculation",
          "synonyms": [
            "recirculation"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "recirculación de aire",
          "synonyms": [
            "recirculación"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "recyclage de l'air",
          "synonyms": [
            "recyclage",
            "recyclage d'air",
            "recirculation d’air",
            "recirculation"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "air recirculation",
          "synonyms": [
            "recirculation"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "air recirculation",
          "synonyms": [
            "recirculation"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "recyclage de l'air",
          "synonyms": [
            "recyclage",
            "recyclage d'air",
            "recirculation d’air",
            "recirculation"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "recirculación de aire",
          "synonyms": [
            "recirculación"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Umluftbetrieb",
          "synonyms": [
            "Umluft"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "ricircolo dell'aria",
          "synonyms": [
            "ricircolo"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Auto",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "auto",
          "synonyms": [
            "auto mode",
            "automatic",
            "automatic mode"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "auto",
          "synonyms": [
            "modo auto",
            "automático",
            "modo automático"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "auto",
          "synonyms": [
            "mode auto",
            "automatique",
            "mode automatique"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "auto",
          "synonyms": [
            "auto mode",
            "automatic",
            "automatic mode"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "auto",
          "synonyms": [
            "auto mode",
            "automatic",
            "automatic mode"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "auto",
          "synonyms": [
            "mode auto",
            "automatique",
            "mode automatique"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "auto",
          "synonyms": [
            "modo auto",
            "automático",
            "modo automático"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Automatik",
          "synonyms": [
            "Automatikbetrieb",
            "automatisch"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "automatico",
          "synonyms": [
            "automatica",
            "modalità automatica"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.AutoBrakeHold",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "auto hold",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "retención automática",
          "synonyms": [
            "freno automático en parada",
            "paro automático",
            "auto hold"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "auto hold",
          "synonyms": [
            "maintien automatique",
            "maintien auto",
            "arrêt auto",
            "arrêt automatique"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "auto hold",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "auto hold",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "auto hold",
          "synonyms": [
            "maintien automatique",
            "maintien auto",
            "arrêt auto",
            "arrêt automatique"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "retención automática",
          "synonyms": [
            "freno automático en parada"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Automatikbremse",
          "synonyms": [
            "Bremsautomatik"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "auto hold",
          "synonyms": [
            "freno di stazionamento assistito",
            "freno di stazionamento automatico",
            "freno di stazionamento elettrico"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.BluetoothPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "bluetooth page",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú del bluetooth",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "menu bluetooth",
          "synonyms": [
            "bluetooth"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "bluetooth page",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "bluetooth page",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "menu bluetooth",
          "synonyms": [
            "bluetooth"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú del Bluetooth",
          "synonyms": [
            "menú de conexiones Bluetooth"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Bluetooth-Seite",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "pagina del bluetooth",
          "synonyms": [
            "menu del bluetooth"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.BodyVents",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "body vents",
          "synonyms": [
            "body vent",
            "face vents",
            "face vent",
            "body",
            "face",
            "center",
            "top",
            "front",
            "front vent",
            "front vents"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "rejillas para el cuerpo",
          "synonyms": [
            "rejillas de cuerpo",
            "rejillas para la cara",
            "rejilla de la cara",
            "cuerpo",
            "cara",
            "rejilla hacia el cuerpo",
            "rejillas hacia el cuerpo",
            "rejillas hacia la cara",
            "rejilla hacia la cara",
            "frente",
            "frontal",
            "delantera",
            "ventilación frontal",
            "ventilación delantera"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "grille d'aération",
          "synonyms": [
            "grilles d'aération",
            "grille d'aération corps",
            "grilles d'aération corps",
            "grille d'aération visage",
            "grilles d'aération visage",
            "corps",
            "grilles d'aération visage-corps",
            "bouches d’air du corps",
            "bouche d’air du corps",
            "bouches d’air du visage",
            "bouche d’air du visage",
            "visage",
            "avant",
            "au milieu",
            "de face",
            "vers l'avant",
            "milieu",
            "face",
            "grille au milieu",
            "grille de face",
            "grille avant",
            "grilles au milieu",
            "grilles de face",
            "grilles avant",
            "bouche au milieu",
            "bouche de face",
            "bouche avant",
            "bouches au milieu",
            "bouches de face",
            "bouches avant",
            "grille de ventilation avant",
            "grille de ventilation au milieu",
            "grille de ventilation de face",
            "grilles de ventilation avant",
            "grilles de ventilation de face",
            "grilles de ventilation au milieu",
            "bouche de ventilation avant",
            "bouche de ventilation de face",
            "bouche de ventilation au milieu",
            "bouches de ventilation de face",
            "bouches de ventilation avant",
            "bouches de ventilation au milieu"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "body vents",
          "synonyms": [
            "body vent",
            "face vents",
            "face vent",
            "body",
            "face",
            "center",
            "top",
            "front",
            "front vent",
            "front vents"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "body vents",
          "synonyms": [
            "body vent",
            "face vents",
            "face vent",
            "body",
            "face",
            "center",
            "top",
            "front",
            "front vent",
            "front vents"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "grille d'aération",
          "synonyms": [
            "grilles d'aération",
            "grille d'aération corps",
            "grilles d'aération corps",
            "grille d'aération visage",
            "grilles d'aération visage",
            "corps",
            "grilles d'aération visage-corps",
            "bouches d’air du corps",
            "bouche d’air du corps",
            "bouches d’air du visage",
            "bouche d’air du visage",
            "visage",
            "avant",
            "au milieu",
            "de face",
            "vers l'avant",
            "milieu",
            "face",
            "grille au milieu",
            "grille de face",
            "grille avant",
            "grilles au milieu",
            "grilles de face",
            "grilles avant",
            "bouche au milieu",
            "bouche de face",
            "bouche avant",
            "bouches au milieu",
            "bouches de face",
            "bouches avant",
            "grille de ventilation avant",
            "grille de ventilation au milieu",
            "grille de ventilation de face",
            "grilles de ventilation avant",
            "grilles de ventilation de face",
            "grilles de ventilation au milieu",
            "bouche de ventilation avant",
            "bouche de ventilation de face",
            "bouche de ventilation au milieu",
            "bouches de ventilation de face",
            "bouches de ventilation avant",
            "bouches de ventilation au milieu"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "rejilla hacia el cuerpo",
          "synonyms": [
            "rejillas hacia el cuerpo",
            "rejillas hacia la cara",
            "rejilla hacia la cara",
            "cuerpo",
            "cara",
            "frontal",
            "delantera",
            "ventilación frontal",
            "ventilación delantera"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Lüftungsauslässe für den Körper",
          "synonyms": [
            "Lüftungsauslass für den Körper",
            "Lüftungsauslässe für das Gesicht",
            "Lüftungsauslass für das Gesicht",
            "Körper",
            "Gesicht",
            "Vorderseite",
            "Frontgebläse",
            "Frontlüftung",
            "vordere Lüftung",
            "vorderes Gebläse",
            "vordere Lüftungsschlitze"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "bocchetta corpo",
          "synonyms": [
            "bocchette corpo",
            "bocchetta del cruscotto",
            "bocchette del cruscotto",
            "corpo",
            "faccia",
            "cruscotto",
            "davanti",
            "ventilazione frontale",
            "ventilazione laterale",
            "frontale",
            "laterale"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Brightness",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "brightness",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "brillo",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "luminosité",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "brightness",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "brightness",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "luminosité",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "brillo",
          "synonyms": [
            "luminosidad"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Helligkeit",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "luminosità",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.ChildDoorLock",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "child door lock",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "bloqueo de puerta para niños",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "verrouillage de sécurité pour enfants",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "child door lock",
          "synonyms": [
            "child door locks",
            "child lock",
            "child locks"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "child door lock",
          "synonyms": [
            "child door locks",
            "child lock",
            "child locks"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "sécurité enfant",
          "synonyms": [
            "vérouillage enfant"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "bloqueo de puerta para niños",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Kindersicherung in der Autotür",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "blocco porta bambini",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.ClimateSync",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "climate sync",
          "synonyms": [
            "sync",
            "climate control sync"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "sincronización del clima",
          "synonyms": [
            "sincronización",
            "sincronización del control del clima",
            "sincronización del climatizador",
            "sincronización del control de temperatura"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "synchronisation de la température",
          "synonyms": [
            "syncho de la température",
            "température syncronisée",
            "synchronisation du contrôle de la température",
            "synchro du contrôle de la température"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "climate sync",
          "synonyms": [
            "sync",
            "climate control sync"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "climate sync",
          "synonyms": [
            "sync",
            "climate control sync"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "synchronisation de la température",
          "synonyms": [
            "syncho de la température",
            "température syncronisée",
            "synchronisation du contrôle de la température",
            "synchro du contrôle de la température"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "sincronización del climatizador",
          "synonyms": [
            "sincronización",
            "sincronización del control de temperatura"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Klimaregelung",
          "synonyms": [
            "Regelung",
            "Temperaturregelung"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sincronizzazione clima",
          "synonyms": [
            "sincronizzare",
            "sincronizzazione climatizzatore"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Color",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "color",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "color",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "couleur",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "colour",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "colour",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "couleur",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "color",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Farbe",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "colore",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Cooling",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "cooling",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "refrigeración",
          "synonyms": [
            "enfriamiento"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "réfrigération",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "cooling",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "cooling",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "réfrigération",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "refrigeración",
          "synonyms": [
            "enfriamiento"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Kühlung",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "raffreddamento",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.CruiseControl",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "cruise control",
          "synonyms": [
            "cruise control speed"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "cruise control",
          "synonyms": [
            "piloto automático",
            "velocidad del cruise control",
            "velocidad del piloto automático"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "cruise control",
          "synonyms": [
            "pilote automatique",
            "vitesse du pilote automatiquerégulateur de vitesse",
            "limiteur de vitesse",
            "vitesse du régulateur de vitesse",
            "vitesse du limitateur de vitesse",
            "vitesse du pilote automatique"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "cruise control",
          "synonyms": [
            "cruise control speed"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "cruise control",
          "synonyms": [
            "cruise control speed"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "régulateur de vitesse",
          "synonyms": [
            "pilote automatique",
            "limiteur de vitesse",
            "vitesse du régulateur de vitesse",
            "vitesse du limitateur de vitesse",
            "vitesse du pilote automatique"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "control de velocidad",
          "synonyms": [
            "autocrucero",
            "regulador de velocidad",
            "velocidad de crucero",
            "velocidad crucero",
            "control de velocidad de crucero"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Geschwindigkeitsregler",
          "synonyms": [
            "Tempomat-Geschwindigkeit"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "cruise control",
          "synonyms": [
            "velocità del cruise control"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Defog",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "defogger",
          "synonyms": [
            "defog"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "descongelador",
          "synonyms": [
            "descongelar",
            "desempañador",
            "desempañar"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "dégivrage",
          "synonyms": [
            "dégivrer",
            "dégivreur"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "demist",
          "synonyms": [
            "demister"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "demist",
          "synonyms": [
            "demister"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "désembuage",
          "synonyms": [
            "désembuer",
            "désembueur"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "desempañador",
          "synonyms": [
            "desempañar"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Scheibenheizung",
          "synonyms": [
            "Scheiben beheizen"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sbrinatore",
          "synonyms": [
            "sbrina"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Defrost",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "defroster",
          "synonyms": [
            "defrost",
            "defogger",
            "defog"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "descongelador",
          "synonyms": [
            "descongelar",
            "desconelador",
            "desempañador",
            "desempañar"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "dégivrage",
          "synonyms": [
            "dégivrer",
            "dégivreur"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "defroster",
          "synonyms": [
            "defrost",
            "demist",
            "demister"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "defroster",
          "synonyms": [
            "defrost",
            "demist",
            "demister"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "dégivrage",
          "synonyms": [
            "dégivrer",
            "dégivreur",
            "désembuage",
            "désembuer",
            "désembueur"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "descongelador",
          "synonyms": [
            "descongelar",
            "desempañador",
            "desempañar"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Enteisungsanlage",
          "synonyms": [
            "enteisen",
            "Scheibenheizung",
            "Scheiben beheizen"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sbrinatore",
          "synonyms": [
            "sbrina"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Direction",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "direction",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "dirección",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "direction",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "direction",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "direction",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "direction",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "dirección",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Richtung",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "direzione",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.DriveMode",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "drive mode",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "modo al volante",
          "synonyms": [
            "modo de conducción"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "mode de conduite",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "drive mode",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "drive mode",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "mode conduite",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "modo al volante",
          "synonyms": [
            "modo conducción"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Fahrmodus",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "modalità di guida",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Economy",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "economy",
          "synonyms": [
            "economy mode",
            "eco",
            "eco mode"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "economía",
          "synonyms": [
            "modo económico",
            "eco",
            "modo eco",
            "económico",
            "modo ahorro de energía"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "économie",
          "synonyms": [
            "mode économie",
            "écono",
            "mode économie d'énergie"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "economy",
          "synonyms": [
            "economy mode",
            "eco",
            "eco mode"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "economy",
          "synonyms": [
            "economy mode",
            "eco",
            "eco mode"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "économie",
          "synonyms": [
            "mode économie",
            "éco",
            "mode éco"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "eco",
          "synonyms": [
            "modo eco",
            "modo ahorro de energía"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Eco",
          "synonyms": [
            "Sparbetrieb",
            "Eco-Modus"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "modalità eco",
          "synonyms": [
            "modalità risparmio",
            "eco"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.FanSpeed",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "fan speed",
          "synonyms": [
            "airflow speed",
            "wind speed",
            "air speed",
            "air velocity"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "velocidad del ventilador",
          "synonyms": [
            "velocidad del flujo del aire",
            "velocidad del viento",
            "velocidad del aire",
            "fuerza del aire"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "vitesse du ventilateur",
          "synonyms": [
            "vitesse du flux d'air",
            "vitesse du vent",
            "vitesse de l'air",
            "vélocité de l'air"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "fan speed",
          "synonyms": [
            "airflow speed",
            "wind speed",
            "air speed",
            "air velocity"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "fan speed",
          "synonyms": [
            "airflow speed",
            "wind speed",
            "air speed",
            "air velocity"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "vitesse du ventilateur",
          "synonyms": [
            "vitesse de la ventilation",
            "vitesse du vent",
            "vitesse de l'air",
            "vélocité de l'air"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "velocidad del ventilador",
          "synonyms": [
            "velocidad del flujo del aire",
            "velocidad del viento",
            "velocidad del aire",
            "fuerza del aire"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Lüftergeschwindigkeit",
          "synonyms": [
            "Luftstromgeschwindigkeit",
            "Windstärke",
            "Luftgeschwindigkeit"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "velocità della ventola",
          "synonyms": [
            "potenza dell'aria",
            "velocità flusso dell'aria",
            "velocità flusso d'aria",
            "potenza del flusso d'aria",
            "potenza del flusso dell'aria"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.FloorVents",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "floor vents",
          "synonyms": [
            "floor vent",
            "downfacing vents",
            "downfacing vent",
            "feet vents",
            "feet vent",
            "floor",
            "feet",
            "bottom",
            "legs",
            "leg"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "rejillas para el piso",
          "synonyms": [
            "rejilla del piso",
            "rejillas inferiores",
            "rejilla inferior",
            "rejilla para los pies",
            "rejilla de los pies",
            "piso",
            "pies",
            "rejillas hacia el suelo",
            "rejilla hacia el suelo",
            "rejillas hacia abajo",
            "rejilla hacia abajo",
            "rejillas hacia los pies",
            "rejilla hacia los pies",
            "suelo"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "bouches d’air au plancher",
          "synonyms": [
            "bouche d’air au plancher",
            "bouche d’air vers le bas",
            "bouches d’air vers le bas",
            "bouches d’air des pieds",
            "bouche d’air des pieds",
            "plancher",
            "pieds"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "floor vents",
          "synonyms": [
            "floor vent",
            "downfacing vents",
            "downfacing vent",
            "feet vents",
            "feet vent",
            "floor",
            "feet",
            "bottom",
            "legs",
            "leg"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "floor vents",
          "synonyms": [
            "floor vent",
            "downfacing vents",
            "downfacing vent",
            "feet vents",
            "feet vent",
            "floor",
            "feet",
            "bottom",
            "legs",
            "leg"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "grilles d'aération plancher",
          "synonyms": [
            "grille d'aération plancher",
            "grille d'aération vers le bas",
            "grilles d'aération vers le bas",
            "grilles d'aérations pieds",
            "grille d'aération pieds",
            "bouches d’air du le sol",
            "bouche d’air du",
            "bouche d’air vers le bas",
            "bouches d’air vers le bas",
            "bouches d’air des pieds",
            "bouche d’air des pieds",
            "sol",
            "pieds"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "rejillas hacia el suelo",
          "synonyms": [
            "rejilla hacia el suelo",
            "rejillas hacia abajo",
            "rejilla hacia abajo",
            "rejillas hacia los pies",
            "rejilla hacia los pies",
            "suelo",
            "pies"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Bodenlüftungen",
          "synonyms": [
            "Bodenlüftung",
            "nach unten gerichtete Lüftungsschlitze",
            "nach unten gerichteter Lüftungsschlitz",
            "Lüftungsschlitze für die Füße",
            "Lüftungsschlitz für die Füße",
            "Boden",
            "Füße"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "bocchetta piedi",
          "synonyms": [
            "bocchette piedi",
            "bocchetta del pavimento",
            "bocchette del pavimento",
            "piedi",
            "pavimento"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Heat",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "heat",
          "synonyms": [
            "heating"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "calor",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "chaleur",
          "synonyms": [
            "chauffant"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "heat",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "heat",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "chaleur",
          "synonyms": [
            "chauffant"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "calor",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Hitze",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "calore",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Height",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "height",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "altura",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "hauteur",
          "synonyms": [
            "hauteurs"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "height",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "height",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "hauteur",
          "synonyms": [
            "hauteurs"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "altura",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Höhe",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "altezza",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.HillAssist",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "hill keeping assist",
          "synonyms": [
            "hill hold assist",
            "hill start assist",
            "hill assist control",
            "hill assist system",
            "hill descent control",
            "hill descent system",
            "hill hold control",
            "hill hold system",
            "hill keep assist"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "asistente de arranque en pendiente",
          "synonyms": [
            "ayuda de arranque en pendiente",
            "control de asistencia en pendientes",
            "sistema de asistencia en pendientes",
            "control de descenso en pendientes",
            "sistema de descenso en pendientes",
            "control de retención en pendientes",
            "sistema de retención en pendientes",
            "asistencia de retención en pendientes",
            "asistente de arranque en subida",
            "ayuda de arranque en subida",
            "asistente de arranque en cuesta",
            "ayuda de arranque en cuesta"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "aide au stationnement en côte",
          "synonyms": [
            "aide au stationnement en pente",
            "aide au démarrage en côte",
            "aide au démarrage en pente",
            "assistance au stationnement en côte",
            "assistance au stationnement en pente",
            "assistance au démarrage en côte",
            "assistance au démarrage en pente",
            "assistant de stationnement en côte",
            "assistant de stationnement en pente",
            "assitant de démarrage en côte",
            "assistant de démarrage en pente",
            "dispositif de démarrage en côte",
            "dispositif de démarrage en pente"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "hill keeping assist",
          "synonyms": [
            "hill hold assist",
            "hill start assist",
            "hill assist control",
            "hill assist system",
            "hill descent control",
            "hill descent system",
            "hill hold control",
            "hill hold system",
            "hill keep assist"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "hill keeping assist",
          "synonyms": [
            "hill hold assist",
            "hill start assist",
            "hill assist control",
            "hill assist system",
            "hill descent control",
            "hill descent system",
            "hill hold control",
            "hill hold system",
            "hill keep assist"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "aide au stationnement en côte",
          "synonyms": [
            "aide au stationnement en pente",
            "aide au démarrage en côte",
            "aide au démarrage en pente",
            "assistance au stationnement en côte",
            "assistance au stationnement en pente",
            "assistance au démarrage en côte",
            "assistance au démarrage en pente",
            "assistant de stationnement en côte",
            "assistant de stationnement en pente",
            "assitant de démarrage en côte",
            "assistant de démarrage en pente",
            "dispositif de démarrage en côte",
            "dispositif de démarrage en pente"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "asistente de arranque en pendiente",
          "synonyms": [
            "ayuda de arranque en pendiente",
            "asistencia de arranque en pendiente",
            "control de asistencia en pendientes",
            "sistema de asistencia en pendientes",
            "control de descenso en pendientes",
            "sistema de descenso en pendientes",
            "control de retención en pendientes",
            "sistema de retención en pendientes",
            "asistencia de retención en pendientes"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Berganfahrassistent",
          "synonyms": [
            "Berganfahrhilfe",
            "Berganfahrassistent System",
            "Berganfahrassistent Abstiegskontrolle",
            "Berganfahrassistent Abstiegssystem",
            "Berganfahrassistent Halt Kontrolle",
            "Berganfahrassistent Halt System"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "hill hold assist",
          "synonyms": [
            "hill assist",
            "partenza in salita assistita",
            "assistenza partenza in salita",
            "controllo di assistenza in salita",
            "sistema di assistenza in salita",
            "controllo di assistenza in discesa",
            "sistema di assistenza in discesa",
            "controllo della tenuta in salita",
            "sistema della tenuta in salita",
            "assistenza di tenuta in salita"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.InfoPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "information page",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de información",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "menu des informations",
          "synonyms": [
            "menu infos"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "information page",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "information page",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "menu des informations",
          "synonyms": [
            "menu infos",
            "informations",
            "infos"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de información",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Informationsseite",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "pagina delle informazioni",
          "synonyms": [
            "menu delle informazioni"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Intensity",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "intensity",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "intensidad",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "intensité",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "intensity",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "intensity",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "intensité",
          "synonyms": [
            "force"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "intensidad",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Stärke",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "intensità",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.LaneAssist",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "lane keeping assist",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "asistencia de mantenimiento de carril",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "assistance au maintien de la trajectoire",
          "synonyms": [
            "système d’avertissement de franchissement de ligne"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "lane keeping assist",
          "synonyms": [
            "lane keeping assistance",
            "lane assist",
            "lane assistance"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "lane keeping assist",
          "synonyms": [
            "lane keeping assistance",
            "lane assist",
            "lane assistance"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "assistance au maintien de la trajectoire",
          "synonyms": [
            "système d’avertissement de franchissement de ligne"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "asistencia de mantenimiento de carril",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Spurhalteassistent",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "assistenza nel mantenimento della corsia",
          "synonyms": [
            "assistenza mantenimento corsia",
            "lane assist",
            "lane keeping assist"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Manual",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "manual",
          "synonyms": [
            "manual mode"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "manual",
          "synonyms": [
            "modo manual"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "manuel",
          "synonyms": [
            "mode manuel"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "manual",
          "synonyms": [
            "manual mode"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "manual",
          "synonyms": [
            "manual mode"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "manuel",
          "synonyms": [
            "mode manuel"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "manual",
          "synonyms": [
            "modo manual"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "manuell",
          "synonyms": [
            "Manueller Betrieb"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "manuale",
          "synonyms": [
            "modalità manuale"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.MaxAirConditioning",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "max air conditioning",
          "synonyms": [
            "max air conditioner",
            "max air con",
            "max aircon",
            "max ac",
            "max a c",
            "maximum air conditioning",
            "maximum air conditioner",
            "maximum air con",
            "maximum aircon",
            "maximum ac",
            "maximum a c"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "Potencia máxima del aire acondicionado",
          "synonyms": [
            "Potencia máxima del aire",
            "Aire acondicionado al máximo",
            "Aire al máximo"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "air conditionné au maximum",
          "synonyms": [
            "air conditionné au max",
            "max air conditionné",
            "maximum air conditionné",
            "air au max",
            "un max d'air",
            "air climatisé au max",
            "air climatisé au maximum",
            "air climatisé max",
            "air clim max",
            "air clim au maximum",
            "air clim maximum",
            "un max d'air conditionné",
            "climatisation au max",
            "climatisation au maximum",
            "clim au max",
            "clim au maximum",
            "climatiseur au max",
            "climatideur au maximum",
            "a. c. au max",
            "a. c. au maximum",
            "max de climatisation",
            "maximum de climatisation",
            "climatisation au niveau maximum",
            "climatisation au niveau max",
            "clim au niveau max",
            "clim au niveau maximum",
            "air conditionné au niveau max",
            "air conditionné au niveau maximum"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "max air conditioning",
          "synonyms": [
            "max air conditioner",
            "max air con",
            "max aircon",
            "max ac",
            "max a c",
            "maximum air conditioning",
            "maximum air conditioner",
            "maximum air con",
            "maximum aircon",
            "maximum ac",
            "maximum a c"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "max air conditioning",
          "synonyms": [
            "max air conditioner",
            "max air con",
            "max aircon",
            "max ac",
            "max a c",
            "maximum air conditioning",
            "maximum air conditioner",
            "maximum air con",
            "maximum aircon",
            "maximum ac",
            "maximum a c"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "air conditionné au maximum",
          "synonyms": [
            "air conditionné au max",
            "max air conditionné",
            "maximum air conditionné",
            "air au max",
            "un max d'air",
            "un max d'air conditionné",
            "climatisation au max",
            "climatisation au maximum",
            "clim au max",
            "clim au maximum",
            "climatiseur au max",
            "climatideur au maximum",
            "a. c. au max",
            "a. c. au maximum",
            "max de climatisation",
            "maximum de climatisation",
            "climatisation au niveau maximum",
            "climatisation au niveau max",
            "clim au niveau max",
            "clim au niveau maximum",
            "air conditionné au niveau max",
            "air conditionné au niveau maximum"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "Potencia máxima del aire acondicionado",
          "synonyms": [
            "Potencia máxima del aire",
            "Aire acondicionado al máximo",
            "Aire al máximo"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Klimaanlage auf volle Kraft",
          "synonyms": [
            "Klimaanlage auf volle Stärke",
            "Klimaanlage auf höchste Stufe",
            "Klimaanlage auf Maximum",
            "Klimaanlage volle Kraft",
            "Klimaanlage volle Stärke",
            "Klimaanlage höchste Stufe",
            "Klimaanlage Maximum",
            "volle Kraft Klimaanlage",
            "volle Stärke Klimaanlage",
            "höchste Stufe Klimaanlage",
            "Maximum Klimaanlage",
            "AC auf volle Kraft",
            "AC auf volle Stärke",
            "AC auf höchste Stufe",
            "AC auf Maximum",
            "AC volle Kraft",
            "AC volle Stärke",
            "AC höchste Stufe",
            "AC Maximum",
            "volle Kraft AC",
            "volle Stärke AC",
            "höchste Stufe AC",
            "Maximum AC"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "aria condizionata al massimo",
          "synonyms": [
            "condizionatore dell'aria al massimo"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.MixVents",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "mix vents",
          "synonyms": [
            "mix vent",
            "mix",
            "mixed",
            "mixed vent",
            "mixed vents"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "rejillas mixtas",
          "synonyms": [
            "rejilla mixta",
            "mixta",
            "combinada",
            "rejilla combinada",
            "rejillas combinadas"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "bouches d’air mixtes",
          "synonyms": [
            "bouche d’air mixte",
            "mixte",
            "bouche d’air combinée",
            "bouches d’air combinées"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "mix vents",
          "synonyms": [
            "mix vent",
            "mix",
            "mixed",
            "mixed vent",
            "mixed vents"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "mix vents",
          "synonyms": [
            "mix vent",
            "mix",
            "mixed",
            "mixed vent",
            "mixed vents"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "grilles d'aération mixtes",
          "synonyms": [
            "grille d'aération mixte",
            "mixte",
            "combinée",
            "grille d'aération combinée",
            "grilles d'aération combinées",
            "bouches d’air mixtes",
            "bouche d’air mixte",
            "bouche d’air combinée",
            "bouches d’air combinées"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "rejillas mixtas",
          "synonyms": [
            "rejilla mixta",
            "mixta",
            "combinada",
            "rejilla combinada",
            "rejillas combinadas"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "gemischte Lüftungsauslässe￼gemischter Lüftungsauslass￼",
          "synonyms": [
            "mischen￼",
            "gemischt",
            "￼gemischtes Gebläse"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "bocchette miste",
          "synonyms": [
            "bocchette misto",
            "bocchette misti",
            "miste",
            "misto",
            "misti"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Mode",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "mode",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "modo",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "mode",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "mode",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "mode",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "mode",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "modo",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Modus",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "modalità",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.NavigationPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "navigation page",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de navegación",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "menu navigation",
          "synonyms": [
            "navigation"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "navigation page",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "navigation page",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "menu navigation",
          "synonyms": [
            "navigation"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de navegación",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Navigations-Seite",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "pagina della navigazione",
          "synonyms": [
            "menu della navigazione"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Openness",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "openness",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "apertura",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "degré d'ouverture",
          "synonyms": [
            "ouverture"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "openness",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "openness",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "degré d'ouverture",
          "synonyms": [
            "ouverture"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "apertura",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Öffnung",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "apertura",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.ParkingBrake",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "parking brake",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "freno de mano",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "frein à main",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "parking brake",
          "synonyms": [
            "hand brake",
            "emergency brake"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "parking brake",
          "synonyms": [
            "hand brake",
            "emergency brake"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "frein à main",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "freno de mano",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Feststellbremse",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "freno di parcheggio",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Position",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "position",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "posición",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "position",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "position",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "position",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "position",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "posición",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Position",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "posizione",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.PreCollisionBrake",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "pre collision braking",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "frenado de emergencia",
          "synonyms": [
            "freno de emergencia"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "freinage préventif",
          "synonyms": [
            "freins anti-collision"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "pre collision braking",
          "synonyms": [
            "automatic braking"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "pre collision braking",
          "synonyms": [
            "automatic braking"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "freinage préventif",
          "synonyms": [
            "freins anti-collision"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "frenado de emergencia",
          "synonyms": [
            "freno de emergencia",
            "freno de estacionamiento"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Notbremsassistent",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "frenata pre collisione",
          "synonyms": [
            "pre collision braking"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.RadioPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "radio page",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "manú de la radio",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "menu radio",
          "synonyms": [
            "radio"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "radio page",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "radio page",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "menu radio",
          "synonyms": [
            "radio"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de la radio",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Radio-Seite",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "pagina della radio",
          "synonyms": [
            "menu della radio"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.SatelliteRadioPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "satellite radio page",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de radio por satélite",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "menu de la radio satellite",
          "synonyms": [
            "menu radio satellite",
            "radio satellite"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "satellite radio page",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "satellite radio page",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "menu de la radio satellite",
          "synonyms": [
            "menu radio satellite",
            "radio satellite"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de radio por satélite",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Satellitenradio-Seite",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "pagina della radio satellitare",
          "synonyms": [
            "menu della radio satellitare"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.ServicePage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "service page",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de mantenimiento",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "menu des services",
          "synonyms": [
            "menu services"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "service page",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "service page",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "menu des services",
          "synonyms": [
            "menu services"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de mantenimiento",
          "synonyms": [
            "menú de servicios"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Service-Seite",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "pagina della manutenzione",
          "synonyms": [
            "menu della manutenzione"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.SettingsPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "settings page",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de configuración",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "menu paramètres",
          "synonyms": [
            "paramètres",
            "paramètres de configuration"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "settings page",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "settings page",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "menu paramètres",
          "synonyms": [
            "paramètres",
            "paramètres de configuration"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de configuración",
          "synonyms": [
            "menú de ajustes"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Einstellungen",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "pagina delle impostazioni",
          "synonyms": [
            "menu delle impostazioni"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Speed",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "speed",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "velocidad",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "vitesse",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "speed",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "speed",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "vitesse",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "velocidad",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Geschwindigkeit",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "velocità",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.StoredPosition",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "position",
          "synonyms": [
            "stored position"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "posición",
          "synonyms": [
            "posición guardada"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "position",
          "synonyms": [
            "position de stockage",
            "position mémorisée"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "position",
          "synonyms": [
            "stored position"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "position",
          "synonyms": [
            "stored position"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "position",
          "synonyms": [
            "position mémorisée"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "posición",
          "synonyms": [
            "posición guardada"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Position",
          "synonyms": [
            "festgelegte Position"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "posizione",
          "synonyms": [
            "posizione salvata"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.SwayWarning",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "sway warning",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "alerta por cambio involuntario de carril",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "avertissement de changement de trajectoire",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "sway warning",
          "synonyms": [
            "vehicle sway warning"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "sway warning",
          "synonyms": [
            "vehicle sway warning"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "avertissement de changement de trajectoire",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "alerta por cambio involuntario de carril",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Traktionskontrolle",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "avviso di superamento corsia",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.Temperature",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "temperature",
          "synonyms": [
            "temp"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "temperatura",
          "synonyms": [
            "temp"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "température",
          "synonyms": [
            "temp"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "temperature",
          "synonyms": [
            "temp"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "temperature",
          "synonyms": [
            "temp"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "température",
          "synonyms": [
            "temp."
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "temperatura",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Temperatur",
          "synonyms": [
            "Temp."
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "temperatura",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.TowingMode",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "towing mode",
          "synonyms": [
            "towing control"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "modo remolque",
          "synonyms": [
            "control de remolque",
            "modo de remolque"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "mode remorquage",
          "synonyms": [
            "assistance au remorquage",
            "aide au remorquage",
            "assistant de remorquage",
            "fonction de remorquage"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "towing mode",
          "synonyms": [
            "tow mode",
            "towing control",
            "tow control"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "towing mode",
          "synonyms": [
            "tow mode",
            "towing control",
            "tow control"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "mode remorquage",
          "synonyms": [
            "assistance au remorquage",
            "assistant de remorquage",
            "fonction de remorquage"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "modo de remolque",
          "synonyms": [
            "control de remolque"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Abschleppmodus",
          "synonyms": [
            "Abschleppmenü",
            "Abschlepp Menü"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "modalità rimorchio",
          "synonyms": [
            "modalità traino",
            "funzione di traino",
            "funzione di rimorchio",
            "controllo del rimorchio",
            "controllo del traino"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.TractionControl",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "traction control",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "control de tracción",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "contrôle de la traction",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "traction control",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "traction control",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "contrôle de la traction",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "control de tracción",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Antriebssteuerung",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "controllo di trazione",
          "synonyms": [
            "traction control"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.WindowLock",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "window locks",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "bloqueo de ventanas",
          "synonyms": [
            "bloqueo de ventanillas"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "verrouillage des fenêtres",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "window locks",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "window locks",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "verrouillage des fenêtres",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "bloqueo de elevalunas",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Fensterverriegelungen",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "blocco finestrini",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Setting.WindshieldVents",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "windshield vents",
          "synonyms": [
            "windshield vent",
            "windshield"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "rejillas del parabrisas",
          "synonyms": [
            "rejillas para el parabrisas",
            "parabrisas",
            "rejillas hacia el parabrisas",
            "rejilla hacia el parabrisas"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "bouches d’air du pare-brise",
          "synonyms": [
            "bouche d’air du pare-brise",
            "pare-brise"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "windshield vents",
          "synonyms": [
            "windshield vent",
            "windscreen vent",
            "windscreen vents"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "windshield vents",
          "synonyms": [
            "windshield vent",
            "windscreen vent",
            "windscreen vents"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "grilles d'aération du pare-brise",
          "synonyms": [
            "grille d'aération du pare-brise",
            "bouches d’air du pare-brise",
            "bouche d’air du pare-brise",
            "pare-brise"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "rejillas hacia el parabrisas",
          "synonyms": [
            "rejilla hacia el parabrisas",
            "parabrisas"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Windschutzscheiben-Gebläse",
          "synonyms": [
            "Windschutzscheibe"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "bocchetta del parabrezza",
          "synonyms": [
            "bocchette del parabrezza",
            "parabrezza"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.4WDAuto",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "four auto",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "transmisión cuatro por cuatro automática",
          "synonyms": [
            "transmisión 4x4 automática",
            "transmisión automática 4x4"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "traction intégrale automatique",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "four auto",
          "synonyms": [
            "four wheel drive"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "four auto",
          "synonyms": [
            "four wheel drive"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "transmission 4 x 4 automatique",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "transmisión 4x4 automática",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Auto",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "trazione integrale automatica",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.4WDHigh",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "four high",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "transmisión 4H",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "traction intégrale à prise constante",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "four high",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "four high",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "transmission 4H",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "transmisión 4H",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "4HI",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "trazione integrale marce normali",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.4WDLow",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "four low",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "transmisión 4L",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "traction intégrale à prise temporaire",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "four low",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "four low",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "transmission 4L",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "transmisión 4L",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "4LO",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "trazione integrale marce ridotte",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.AlertsPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "alerts page",
          "synonyms": [
            "alerts screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de alertas",
          "synonyms": [
            "página de alertas",
            "pantalla de alertas"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran des alertes",
          "synonyms": [
            "écrans alertes",
            "page des alertes",
            "page alerte",
            "interface des alertes",
            "interface alertes",
            "alertes"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "alerts page",
          "synonyms": [
            "alerts screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "alerts page",
          "synonyms": [
            "alerts screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran des alertes",
          "synonyms": [
            "écrans alertes",
            "page des alertes",
            "page alerte",
            "interface des alertes",
            "interface alertes",
            "alertes"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de alertas",
          "synonyms": [
            "página de alertas",
            "pantalla de alertas"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Warnungen Anzeige",
          "synonyms": [
            "Warnungen Bildschirm",
            "Warnungsanzeige",
            "Warnungsbildschirm",
            "Warnhinweise"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "schermata degli avvisi",
          "synonyms": [
            "schermo degli avvisi",
            "pagina degli avvisi",
            "menù degli avvisi",
            "avvisi"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Blue",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "blue",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "azul",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "bleu",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "blue",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "blue",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "bleu",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "azul",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Blau",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "blu",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.BluetoothPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "bluetooth screen",
          "synonyms": [
            "bluetooth page"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de bluetooth",
          "synonyms": [
            "página de bluetooth",
            "pantalla de bluetooth"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran bluetooth",
          "synonyms": [
            "page bluetooth",
            "écran d'accueil bluetooth",
            "interface bluetooth",
            "bluetooth"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "bluetooth screen",
          "synonyms": [
            "bluetooth page"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "bluetooth screen",
          "synonyms": [
            "bluetooth page"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran bluetooth",
          "synonyms": [
            "page bluetooth",
            "écran d'accueil bluetooth"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de bluetooth",
          "synonyms": [
            "página de bluetooth",
            "pantalla de bluetooth"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Bluetooth Bildschrim",
          "synonyms": [
            "Bluetooth Anzeige"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "schermo bluetooth",
          "synonyms": [
            "pagina di bluetooth",
            "interfaccia bluetooth"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Closed",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "closed",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "cerrado",
          "synonyms": [
            "cerrada",
            "cerrados",
            "cerradas"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "fermé",
          "synonyms": [
            "fermés",
            "fermée",
            "fermées"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "closed",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "closed",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "fermé",
          "synonyms": [
            "fermés",
            "fermée",
            "fermées"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "cerrado",
          "synonyms": [
            "cerrada",
            "cerrados",
            "cerradas"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "geschlossen",
          "synonyms": [
            "geschlossenes",
            "geschlossene",
            "geschlossener",
            "geschlossenen",
            "geschlossenem"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "chiuso",
          "synonyms": [
            "chiusa",
            "chiusi",
            "chiuse"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Comfort",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "comfort",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "confort",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "confort",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "comfort",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "comfort",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "confort",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "confort",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Komfort",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "confort",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.ContactsPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "contacts page",
          "synonyms": [
            "contacts screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de contactos",
          "synonyms": [
            "página de contactos",
            "pantalla de contactos"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran des contacts",
          "synonyms": [
            "écran contacts",
            "page des contacts",
            "page contact",
            "interface des contacts",
            "interface contacts",
            "contacts"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "contacts page",
          "synonyms": [
            "contacts screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "contacts page",
          "synonyms": [
            "contacts screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran des contacts",
          "synonyms": [
            "écran contacts",
            "page des contacts",
            "page contact",
            "interface des contacts",
            "interface contacts",
            "contacts"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de contactos",
          "synonyms": [
            "página de contactos",
            "pantalla de contactos"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Kontakte Menü",
          "synonyms": [
            "Kontakte Anzeige",
            "Kontakte Bildschirm"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù dei contatti",
          "synonyms": [
            "pagina dei contatti",
            "schermata dei contatti",
            "schermo dei contatti"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.ControlsPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "controls page",
          "synonyms": [
            "controls screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de controles",
          "synonyms": [
            "página de controles",
            "pantalla de controles"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran des contrôles",
          "synonyms": [
            "page des contrôles",
            "interfaces de contrôles",
            "contrôles"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "controls page",
          "synonyms": [
            "controls screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "controls page",
          "synonyms": [
            "controls screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran des contrôles",
          "synonyms": [
            "page des contrôles",
            "interfaces de contrôles",
            "contrôles"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de controles",
          "synonyms": [
            "página de controles",
            "pantalla de controles"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Bedienungselementen Anzeige",
          "synonyms": [
            "Bedienungsanzeige"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù di controllo",
          "synonyms": [
            "pagina di controllo",
            "menù dei comandi",
            "pagina dei comandi"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.DriverView",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "driver side view",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "vista del lado del conductor",
          "synonyms": [
            "visión lateral del conductor"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "vue du côté conducteur",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "driver side view",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "driver side view",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "vue côté conducteur",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "vista del lado del conductor",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Fahrersicht",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "vista lato guidatore",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.DynamicCoordinatorPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "dynamics coordinator",
          "synonyms": [
            "dynamics coordinator page",
            "dynamics coordinator screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de coordinador de dinámicas",
          "synonyms": [
            "página de coordinador de dinámicas",
            "pantalla de coordinador de dinámicas"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "menu coordinateur dynamique",
          "synonyms": [
            "page coordinatrice dynamique",
            "écran coordinateur dynamique"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "dynamics coordinator",
          "synonyms": [
            "dynamics coordinator page",
            "dynamics coordinator screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "dynamics coordinator",
          "synonyms": [
            "dynamics coordinator page",
            "dynamics coordinator screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "menu coordinateur dynamique",
          "synonyms": [
            "page coordinatrice dynamique",
            "écran coordinateur dynamique"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de coordinador de dinámicas",
          "synonyms": [
            "página de coordinador de dinámicas",
            "pantalla de coordinador de dinámicas"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Dynamik Koordinator Menü",
          "synonyms": [
            "Dynamik Koordinator Seite",
            "Dynamik Koordinator Anzeige",
            "Dynamik Koordinator Menüanzeige",
            "Dynamik Koordinator Bildschrimanzeige"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù controllo dinamico",
          "synonyms": [
            "menù dinamica integrata",
            "schermata del controllo dinamico",
            "schermata dinamica integrata",
            "pagina del controllo dinamico",
            "pagina della dinamica integrata"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.FrontView",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "front view",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "vista frontal",
          "synonyms": [
            "visión de frente",
            "visión frontal"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "vue frontale",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "front view",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "front view",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "vue de face",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "vista frontal",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Frontalansicht",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "vista frontale",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Full",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "full",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "completo",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "totalement",
          "synonyms": [
            "complètement",
            "en entier"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "full",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "full",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "totalement",
          "synonyms": [
            "complètement",
            "en entier"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "completo",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "voll",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "totalmente",
          "synonyms": [
            "completamente",
            "interamente"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.GPSPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "g. p. s. page",
          "synonyms": [
            "g. p. s. screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de g. p. s.",
          "synonyms": [
            "página de g. p. s.",
            "pantalla de g. p. s."
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran g. p. s.",
          "synonyms": [
            "page du g. p. s.",
            "interface g. p. s.",
            "g. p. s."
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "g. p. s. page",
          "synonyms": [
            "g. p. s. screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "g. p. s. page",
          "synonyms": [
            "g. p. s. screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran g. p. s.",
          "synonyms": [
            "page du g. p. s.",
            "interface g. p. s.",
            "g. p. s."
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de g. p. s.",
          "synonyms": [
            "página de g. p. s.",
            "pantalla de g. p. s."
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "g. p. s. Bildschirm",
          "synonyms": [
            "g. p. s. Anzeige"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "schermata g. p. s.",
          "synonyms": [
            "schermo g. p. s.",
            "pagina g. p. s.",
            "interfaccia g. p. s."
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Green",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "green",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "verde",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "vert",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "green",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "green",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "vert",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "verde",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Grün",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "verde",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Half",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "half",
          "synonyms": [
            "halfway"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "mitad",
          "synonyms": [
            "semiabierto"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "à moitié",
          "synonyms": [
            "à demi",
            "au milieu"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "half",
          "synonyms": [
            "halfway"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "half",
          "synonyms": [
            "halfway"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "à moitié",
          "synonyms": [
            "à demi",
            "au milieu"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "mitad",
          "synonyms": [
            "semiabierto"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "halb",
          "synonyms": [
            "halbwegs"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "a metà",
          "synonyms": [
            "semiaperto"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.High",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "high",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "alto",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "élevé",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "high",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "high",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "élevé",
          "synonyms": [
            "fort"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "alto",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "hoch",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "alto",
          "synonyms": [
            "alta"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.HomePage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "home screen",
          "synonyms": [
            "main screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de inicio",
          "synonyms": [
            "menú de principal",
            "página de inicio",
            "página de principal",
            "pantalla de inicio",
            "pantalla principal"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran d'accueil",
          "synonyms": [
            "page d'accueil",
            "écran principal",
            "page principale",
            "interface principale"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "home screen",
          "synonyms": [
            "main screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "home screen",
          "synonyms": [
            "main screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran d'accueil",
          "synonyms": [
            "page d'accueil",
            "écran principal",
            "page principale"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de inicio",
          "synonyms": [
            "menú de principal",
            "página de inicio",
            "página de principal",
            "pantalla de inicio",
            "pantalla principal"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Hauptbildschrim",
          "synonyms": [
            "Hauptanzeige"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù principale",
          "synonyms": [
            "pagina principale",
            "pagina d'inizio",
            "interfaccia iniziale"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Indigo",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "indigo",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "índigo",
          "synonyms": [
            "azul añil"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "indigo",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "indigo",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "indigo",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "indigo",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "añil",
          "synonyms": [
            "azul añil"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Indigoblau",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "indaco",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.InformationPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "information screen",
          "synonyms": [
            "information page"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de información",
          "synonyms": [
            "página de información",
            "pantalla de información"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran d'information",
          "synonyms": [
            "page d'information",
            "information"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "information screen",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "information screen",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran d'information",
          "synonyms": [
            "page d'information",
            "information"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de información",
          "synonyms": [
            "página de información",
            "pantalla de información"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Informationanzeige",
          "synonyms": [
            "Information Anzeige",
            "Informationsbildschirm"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù informazioni",
          "synonyms": [
            "informazioni",
            "pagina delle informazioni"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.InsideAir",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "inside air",
          "synonyms": [
            "inside car",
            "inside",
            "inside car only"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "aire interior",
          "synonyms": [
            "aire de adentro",
            "dentro",
            "adentro",
            "interior",
            "interno"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "air intérieur",
          "synonyms": [
            "intérieur",
            "à l'intérieur",
            "dedans",
            "dans"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "inside air",
          "synonyms": [
            "inside car",
            "inside",
            "inside car only"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "inside air",
          "synonyms": [
            "inside car",
            "inside",
            "inside car only"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "air intérieur",
          "synonyms": [
            "intérieur",
            "à l'intérieur",
            "dedans",
            "dans"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "aire interior",
          "synonyms": [
            "dentro",
            "interior",
            "interno"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Innenluft",
          "synonyms": [
            "innen"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "aria interna",
          "synonyms": [
            "dentro",
            "interno"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Intermittent",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "intermittent",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "intermitente",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "intermittent",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "intermittent",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "intermittent",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "intermittent",
          "synonyms": [
            "intermittente",
            "intermittents",
            "intermittentes"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "intermitente",
          "synonyms": [
            "intermitentes",
            "luz intermitente izquierda",
            "luz intermitente derecha",
            "Indicador de dirección",
            "indicadores de dirección"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "blinkend",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "intermittente",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Low",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "low",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "bajo",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "bas",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "low",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "low",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "bas",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "bajo",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "niedrig",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "basso",
          "synonyms": [
            "bassa"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Maximum",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "maximum",
          "synonyms": [
            "max",
            "highest"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "máximo",
          "synonyms": [
            "máx",
            "lo más alto",
            "al máximo"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "maximum",
          "synonyms": [
            "max",
            "le plus élevé"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "maximum",
          "synonyms": [
            "max",
            "highest"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "maximum",
          "synonyms": [
            "max",
            "highest"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "maximum",
          "synonyms": [
            "max.",
            "le plus élevé"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "máximo",
          "synonyms": [
            "máx",
            "al máximo",
            "lo más alto"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Maximum",
          "synonyms": [
            "max.",
            "am höchsten"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "massimo",
          "synonyms": [
            "massima",
            "al massimo"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Medium",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "medium",
          "synonyms": [
            "mid",
            "middle"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "medio",
          "synonyms": [
            "med",
            "media",
            "intermedio",
            "mitad"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "moyen",
          "synonyms": [
            "milieu",
            "intermédiaire"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "medium",
          "synonyms": [
            "mid",
            "middle"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "medium",
          "synonyms": [
            "mid",
            "middle"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "moyen",
          "synonyms": [
            "milieu",
            "intermédiaire"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "medio",
          "synonyms": [
            "media",
            "intermedio",
            "mitad"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "mittel",
          "synonyms": [
            "Mitte"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "media",
          "synonyms": [
            "a metà",
            "medio"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Minimum",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "minimum",
          "synonyms": [
            "min",
            "lowest"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "mínimo",
          "synonyms": [
            "mín",
            "más bajo",
            "lo más bajo posible"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "minimum",
          "synonyms": [
            "min",
            "le plus bas"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "minimum",
          "synonyms": [
            "min",
            "lowest"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "minimum",
          "synonyms": [
            "min",
            "lowest"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "minimum",
          "synonyms": [
            "min.",
            "le plus bas",
            "le moins fort"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "mínimo",
          "synonyms": [
            "mín",
            "más bajo",
            "lo más bajo posible"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Minimum",
          "synonyms": [
            "mind.",
            "am niedrigsten"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "minimo",
          "synonyms": [
            "minima",
            "più bassa",
            "più basso"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.MultimediaPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "multimedia page",
          "synonyms": [
            "multimedia screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de multimedia",
          "synonyms": [
            "página de multimedia",
            "pantalla de multimedia"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "page multipedia",
          "synonyms": [
            "écran multimedia",
            "interface multimedia",
            "multimedia"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "multimedia page",
          "synonyms": [
            "multimedia screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "multimedia page",
          "synonyms": [
            "multimedia screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "page multipedia",
          "synonyms": [
            "écran multimedia",
            "interface multimedia",
            "multimedia"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de multimedia",
          "synonyms": [
            "página de multimedia",
            "pantalla de multimedia"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Multimedia Anzeige",
          "synonyms": [
            "Multimedia Bildschrim"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "pagina multimediale",
          "synonyms": [
            "interfaccia multimediale",
            "schermata multimediale",
            "schermo multimediale"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.MusicPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "music page",
          "synonyms": [
            "music screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de musica",
          "synonyms": [
            "página de musica",
            "pantalla de musica"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "page de la musique",
          "synonyms": [
            "page musique",
            "écran de la musique",
            "écran musique",
            "interface musique",
            "interface de la musique",
            "musique"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "music page",
          "synonyms": [
            "music screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "music page",
          "synonyms": [
            "music screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "page de la musique",
          "synonyms": [
            "page musique",
            "écran de la musique",
            "écran musique",
            "interface musique",
            "interface de la musique",
            "musique"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de música",
          "synonyms": [
            "página de música",
            "pantalla de música"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Musik Anzeige",
          "synonyms": [
            "Musik Bildschirm"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "pagina della musica",
          "synonyms": [
            "schermo della musica",
            "schermata della musica"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.NavigationPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "navigation screen",
          "synonyms": [
            "navigation page"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de navegación",
          "synonyms": [
            "página de navegación",
            "pantalla de navegación"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran de navigation",
          "synonyms": [
            "page de navigation",
            "interface navigation",
            "navigation"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "navigation screen",
          "synonyms": [
            "navigation page"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "navigation screen",
          "synonyms": [
            "navigation page"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran de navigation",
          "synonyms": [
            "page de navigation",
            "interface navigation",
            "navigation"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de navegación",
          "synonyms": [
            "página de navegación",
            "pantalla de navegación"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Navigationsbildschirm",
          "synonyms": [
            "Navigationsanzeige",
            "Navigation Anzeige"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù di navigazione",
          "synonyms": [
            "pagina di navigazione",
            "schermata di navigazione"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Normal",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "normal",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "normal",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "normal",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "normal",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "normal",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "normal",
          "synonyms": [
            "normale",
            "normales",
            "normaux"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "normal",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "normal",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "normale",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.NotificationsPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "notifications page",
          "synonyms": [
            "notifications screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de notificaciones",
          "synonyms": [
            "página de notificaciones",
            "pantalla de notificaciones"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran des notifications",
          "synonyms": [
            "écran notifications",
            "page des notifications",
            "page notifications",
            "interface des notifications",
            "interface notifications",
            "notifications"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "notifications page",
          "synonyms": [
            "notifications screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "notifications page",
          "synonyms": [
            "notifications screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran des notifications",
          "synonyms": [
            "écran notifications",
            "page des notifications",
            "page notifications",
            "interface des notifications",
            "interface notifications",
            "notifications"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de notificaciones",
          "synonyms": [
            "página de notificaciones",
            "pantalla de notificaciones"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Benachrichtigungsmenü",
          "synonyms": [
            "Benachrichtigungsbildschirm"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù notifiche",
          "synonyms": [
            "menù delle notifiche",
            "pagina delle notifiche",
            "schermata delle notifiche",
            "schermo delle notifiche",
            "notifiche"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Open",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "open",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "abierto",
          "synonyms": [
            "abierta",
            "abiertos",
            "abiertas"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "ouverte",
          "synonyms": [
            "ouvert",
            "ouvertes",
            "ouverts"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "open",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "open",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "ouverte",
          "synonyms": [
            "ouvert",
            "ouvertes",
            "ouverts"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "abierto",
          "synonyms": [
            "abierta",
            "abiertos",
            "abiertas"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "offen",
          "synonyms": [
            "offenes",
            "offene",
            "offener",
            "offenen",
            "offenem",
            "geöffnet",
            "geöffnetes",
            "geöffnete",
            "geöffneter",
            "geöffneten",
            "geöffnetem"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "aperto",
          "synonyms": [
            "aperta",
            "aperti",
            "aperte"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Optimal",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "optimal",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "óptimo",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "optimal",
          "synonyms": [
            "optimum"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "optimal",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "optimal",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "optimal",
          "synonyms": [
            "optimum"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "óptimo",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Optimal",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "ottimo",
          "synonyms": [
            "ottimale"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Orange",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "orange",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "naranja",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "orange",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "orange",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "orange",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "orange",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "naranja",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Orange",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "arancione",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.OutsideAir",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "outside air",
          "synonyms": [
            "fresh air",
            "outside car",
            "outside",
            "fresh"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "aire exterior",
          "synonyms": [
            "aire del exterior",
            "aire de afuera",
            "aire fresco",
            "exterior",
            "externo",
            "fuera",
            "fresco"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "air extérieur",
          "synonyms": [
            "air frais",
            "fraîche air",
            "extérieur",
            "à l'extérieur",
            "de l'extérieur",
            "frais"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "outside air",
          "synonyms": [
            "fresh air",
            "outside car",
            "outside",
            "fresh"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "outside air",
          "synonyms": [
            "fresh air",
            "outside car",
            "outside",
            "fresh"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "air extérieur",
          "synonyms": [
            "air frais",
            "fraîche air",
            "extérieur",
            "à l'extérieur",
            "de l'extérieur",
            "frais"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "aire exterior",
          "synonyms": [
            "aire fresco",
            "exterior",
            "fresco"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Außenluft",
          "synonyms": [
            "frische Luft",
            "außen",
            "frisch"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "aria esterna",
          "synonyms": [
            "aria fresca",
            "fuori",
            "esterno"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.PassengerView",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "passenger side view",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "vista del lado del copiloto",
          "synonyms": [
            "visión lateral del copiloto"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "vue du côté passager",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "passenger side view",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "passenger side view",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "vue côté passager",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "vista del lado del copiloto",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Beifahrersicht",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "vista lato passeggero",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.PerformancePage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "performance page",
          "synonyms": [
            "performance screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de rendimiento",
          "synonyms": [
            "página de rendimiento",
            "pantalla de rendimiento"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran de performance",
          "synonyms": [
            "page de performance",
            "interface performance",
            "performance"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "performance page",
          "synonyms": [
            "performance screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "performance page",
          "synonyms": [
            "performance screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran de performance",
          "synonyms": [
            "page de performance"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de rendimiento",
          "synonyms": [
            "página de rendimiento",
            "pantalla de rendimiento"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Leistungsanzeige",
          "synonyms": [
            "Performance Anzeige",
            "Performance Bildschirmanzeige"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù delle prestazioni",
          "synonyms": [
            "pagina delle prestazioni"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.PositionOne",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "position 1",
          "synonyms": [
            "position one",
            "stored position 1",
            "stored position one"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "posición 1",
          "synonyms": [
            "posición uno",
            "posición guardada 1",
            "posición guardada uno"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "position 1",
          "synonyms": [
            "position une",
            "position un",
            "position numéro 1",
            "position numéro un",
            "position numéro une",
            "position de stockage 1",
            "position de stockage une",
            "position de stockage un",
            "position de stockage numéro 1",
            "position de stockage numéro un",
            "position de stockage numéro une",
            "position mémorisée 1",
            "position mémorisée une",
            "position mémorisée un",
            "position mémorisée numéro 1",
            "position mémorisée numéro un",
            "position mémorisée numéro une"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "position 1",
          "synonyms": [
            "position one",
            "stored position 1",
            "stored position one"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "position 1",
          "synonyms": [
            "position one",
            "stored position 1",
            "stored position one"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "position 1",
          "synonyms": [
            "position une",
            "position un",
            "position numéro 1",
            "position numéro un",
            "position numéro une",
            "position mémorisée 1",
            "position mémorisée une",
            "position mémorisée un",
            "position mémorisée numéro 1",
            "position mémorisée numéro un",
            "position mémorisée numéro une"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "posición 1",
          "synonyms": [
            "posición uno",
            "posición guardada 1",
            "posición guardada uno"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Position 1",
          "synonyms": [
            "Position Eins",
            "festgelegte Position 1",
            "festgelegte Position Eins"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "posizione 1",
          "synonyms": [
            "posizione uno",
            "posizione salvata 1",
            "posizione salvata uno"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.PositionThree",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "position 3",
          "synonyms": [
            "position three",
            "stored position 3",
            "stored position three"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "posición 3",
          "synonyms": [
            "posición tres",
            "posición guardada 3",
            "posición guardada tres"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "position 3",
          "synonyms": [
            "position trois",
            "position numéro 3",
            "position numéro trois",
            "position de stockage 3",
            "position de stockage trois",
            "position de stockage numéro 3",
            "position de stockage numéro trois",
            "position mémorisée 3",
            "position mémorisée trois",
            "position mémorisée numéro 3",
            "position mémorisée numéro trois"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "position 3",
          "synonyms": [
            "position three",
            "stored position 3",
            "stored position three"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "position 3",
          "synonyms": [
            "position three",
            "stored position 3",
            "stored position three"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "position 3",
          "synonyms": [
            "position trois",
            "position numéro 3",
            "position numéro trois",
            "position mémorisée 3",
            "position mémorisée trois",
            "position mémorisée numéro 3",
            "position mémorisée numéro trois"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "posición 3",
          "synonyms": [
            "posición tres",
            "posición guardada 3",
            "posición guardada tres"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Position 3",
          "synonyms": [
            "Position Drei",
            "festgelegte Position 3",
            "festgelegte Position Drei"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "posizione 3",
          "synonyms": [
            "posizione tre",
            "posizione salvata 3",
            "posizione salvata tre"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.PositionTwo",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "position 2",
          "synonyms": [
            "position two",
            "stored position 2",
            "stored position two"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "posición 2",
          "synonyms": [
            "posición dos",
            "posición guardada 2",
            "posición guardada dos"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "position 2",
          "synonyms": [
            "position deux",
            "position numéro 2",
            "position numéro deux",
            "position de stockage 2",
            "position de stockage deux",
            "position de stockage numéro 2",
            "position de stockage numéro deux",
            "position mémorisée 2",
            "position mémorisée deux",
            "position mémorisée numéro 2",
            "position mémorisée numéro deux"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "position 2",
          "synonyms": [
            "position two",
            "stored position 2",
            "stored position two"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "position 2",
          "synonyms": [
            "position two",
            "stored position 2",
            "stored position two"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "position 2",
          "synonyms": [
            "position deux",
            "position numéro 2",
            "position numéro deux",
            "position mémorisée 2",
            "position mémorisée deux",
            "position mémorisée numéro 2",
            "position mémorisée numéro deux"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "posición 2",
          "synonyms": [
            "posición dos",
            "posición guardada 2",
            "posición guardada dos"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Position 2",
          "synonyms": [
            "Position Zwei",
            "festgelegte Position 2",
            "festgelegte Position Zwei"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "posizione 2",
          "synonyms": [
            "posizione due",
            "posizione salvata 2",
            "posizione salvata due"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.RadioPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "radio screen",
          "synonyms": [
            "radio page"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de radio",
          "synonyms": [
            "página de radio",
            "pantalla de radio"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran des radios",
          "synonyms": [
            "page des radios",
            "écran d'accueil des radios",
            "interface radio",
            "interface des radios",
            "radios"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "radio screen",
          "synonyms": [
            "radio page"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "radio screen",
          "synonyms": [
            "radio page"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran des radios",
          "synonyms": [
            "page des radios",
            "écran d'accueil des radios",
            "radios"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de radio",
          "synonyms": [
            "página de radio",
            "pantalla de radio"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Radio Anzeige",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù della radio",
          "synonyms": [
            "schermo della radio",
            "interfaccia della radio"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.RearView",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "rear view",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "vista trasera",
          "synonyms": [
            "visión trasera",
            "visión posterior",
            "vista posterior"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "vue arrière",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "rear view",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "rear view",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "vue arrière",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "vista trasera",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Heckansicht",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "vista poteriore",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Red",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "red",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "rojo",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "rouge",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "red",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "red",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "rouge",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "rojo",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Rot",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "rosso",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.SatelliteRadioPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "satellite radio screen",
          "synonyms": [
            "satellite radio page"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de radio satelita",
          "synonyms": [
            "página de radio satelita",
            "pantalla de radio satelital"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran des radios satellites",
          "synonyms": [
            "page radio satellites",
            "écran d'accueil radio satellite",
            "page des radios satellites",
            "interface des radios satellites",
            "radios satellite"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "satellite radio screen",
          "synonyms": [
            "satellite radio page"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "satellite radio screen",
          "synonyms": [
            "satellite radio page"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran des radios satellites",
          "synonyms": [
            "page radio satellites",
            "écran d'accueil radio satellite",
            "page des radios satellites",
            "interface des radios satellites",
            "radios satellite"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de radio satelita",
          "synonyms": [
            "página de radio satelita",
            "pantalla de radio satelital",
            "pantalla de radio satélite"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Satellitenradioanzeige",
          "synonyms": [
            "Satelliten Radio Anzeige",
            "Satelittenradiobildschirm",
            "Satelitten Radio Bildschirm"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù radio satellitare",
          "synonyms": [
            "pagina radio satellitare",
            "schermata radio satellitare",
            "interfaccia radio satellitare"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.ServicePage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "service screen",
          "synonyms": [
            "service page"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de servicios",
          "synonyms": [
            "página de servicios",
            "pantalla de servicios"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran d'accueil des service",
          "synonyms": [
            "écran des services",
            "page des services",
            "interface des services",
            "services"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "service screen",
          "synonyms": [
            "service page"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "service screen",
          "synonyms": [
            "service page"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran d'accueil des service",
          "synonyms": [
            "écran des services",
            "page des services",
            "interface des services",
            "services"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de servicios",
          "synonyms": [
            "página de servicios",
            "pantalla de servicios"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Service Bildschrim",
          "synonyms": [
            "Service Anzeige"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù della manutenzione",
          "synonyms": [
            "schermata della manutenzione",
            "schermo della manutenzione",
            "pagina della manutenzione"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.SettingsPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "settings screen",
          "synonyms": [
            "settings page"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de configuración",
          "synonyms": [
            "menú de ajustes",
            "página de configuración",
            "página de ajustes",
            "pantalla de configuración",
            "pantalla de ajustes"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran des paramètres",
          "synonyms": [
            "page de paramètres",
            "écran des paramétrages",
            "page des paramètrages",
            "interface des paramètres",
            "interface paramétrages",
            "paramètres",
            "paramétrages"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "settings screen",
          "synonyms": [
            "settings page"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "settings screen",
          "synonyms": [
            "settings page"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran des paramètres",
          "synonyms": [
            "page de paramètres",
            "écran des paramétrages",
            "page dees paramètrages"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de configuración",
          "synonyms": [
            "menú de ajustes",
            "página de configuración",
            "página de ajustes",
            "pantalla de configuración",
            "pantalla de ajustes"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Einstellungsbildschrim",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "pagina delle impostazioni",
          "synonyms": [
            "menù di configurazione",
            "menù delle configurazioni",
            "pagina delle configurazioni",
            "menù di impostazione"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Sport",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "sport",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "sport",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "sport",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "sport",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "sport",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "sport",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "sport",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Sport",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sport",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.SportPlus",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "sport plus",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "sport plus",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "sport plus",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "sport plus",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "sport plus",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "sport plus",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "sport plus",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Sport Plus",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "sport plus",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.TelephonePage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "telephone page",
          "synonyms": [
            "telephone screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de teléfono",
          "synonyms": [
            "página de teléfono",
            "pantalla de teléfono"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran téléphone",
          "synonyms": [
            "écran du téléphone",
            "page du téléphone",
            "page téléphone",
            "interface téléphone",
            "interface du téléphone",
            "téléphone"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "telephone page",
          "synonyms": [
            "telephone screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "telephone page",
          "synonyms": [
            "telephone screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran téléphone",
          "synonyms": [
            "écran du téléphone",
            "page du téléphone",
            "page téléphone",
            "interface téléphone",
            "interface du téléphone",
            "téléphone"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de teléfono",
          "synonyms": [
            "página de teléfono",
            "pantalla de teléfono"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Telefon Anzeige",
          "synonyms": [
            "Telefon Bildschrim",
            "Telefonanzeige",
            "Telefonbildschirm"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "menù del telefono",
          "synonyms": [
            "pagina del telefono",
            "schermata del telefono",
            "schermo del telefono"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.VehicleStatusPage",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "vehicle status page",
          "synonyms": [
            "vehicle status screen"
          ]
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "menú de estado del vehículo",
          "synonyms": [
            "página de estado del vehículo",
            "pantalla de estado del vehículo"
          ]
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "écran du statut du véhicule",
          "synonyms": [
            "écran statut véhicule",
            "page du statut du véhicule",
            "page statut véhicule",
            "interface statut du véhicule",
            "interface du statut du véhicule",
            "statut véhicule"
          ]
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "vehicle status page",
          "synonyms": [
            "vehicle status screen"
          ]
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "vehicle status page",
          "synonyms": [
            "vehicle status screen"
          ]
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "écran du statut du véhicule",
          "synonyms": [
            "écran statut véhicule",
            "page du statut du véhicule",
            "page statut véhicule",
            "interface statut du véhicule",
            "interface du statut du véhicule",
            "statut véhicule"
          ]
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "menú de estado del vehículo",
          "synonyms": [
            "página de estado del vehículo",
            "pantalla de estado del vehículo"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Fahrzeugzustand Anzeige",
          "synonyms": [
            "Fahrzeugszustandsanzeige",
            "Anzeige des Fahrzeugzustandes",
            "Fahrzeugzustand Bildschirm",
            "Fahrzeugszustandsbildschirm",
            "Bildirsch des Fahrzeugzustandes"
          ]
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "schermata di stato del veicolo",
          "synonyms": [
            "pagina di stato del veicolo",
            "interfaccia di stato del veicolo"
          ]
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Violet",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "violet",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "morado",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "mauve",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "violet",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "violet",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "violet",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "morado",
          "synonyms": [
            "violeta"
          ]
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Violett",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "viola",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.White",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "white",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "blanco",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "blanc",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "white",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "white",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "blanc",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "blanco",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Weiß",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "bianco",
          "synonyms": []
        }
      ]
    },
    {
      "assetId": "Alexa.Automotive.Value.Yellow",
      "values": [
        {
          "locales": [
            "en-US",
            "en-CA"
          ],
          "defaultValue": "yellow",
          "synonyms": []
        },
        {
          "locales": [
            "es-MX",
            "es-US"
          ],
          "defaultValue": "amarillo",
          "synonyms": []
        },
        {
          "locales": [
            "fr-CA"
          ],
          "defaultValue": "jaune",
          "synonyms": []
        },
        {
          "locales": [
            "en-IN"
          ],
          "defaultValue": "yellow",
          "synonyms": []
        },
        {
          "locales": [
            "en-GB"
          ],
          "defaultValue": "yellow",
          "synonyms": []
        },
        {
          "locales": [
            "fr-FR"
          ],
          "defaultValue": "jaune",
          "synonyms": []
        },
        {
          "locales": [
            "es-ES"
          ],
          "defaultValue": "amarillo",
          "synonyms": []
        },
        {
          "locales": [
            "de-DE"
          ],
          "defaultValue": "Gelb",
          "synonyms": []
        },
        {
          "locales": [
            "it-IT"
          ],
          "defaultValue": "giallo",
          "synonyms": []
        }
      ]
    }
  ]
})";

#endif  // AACE_ENGINE_CAR_CONTROL_ASSETS_DEFAULT_H