# This file contains a list of CVE's where resolution has proven to be impractical
# or there is no reasonable action the Yocto Project can take to resolve the issue.
# It contains all the information we are aware of about an issue and analysis about
# why we believe it can't be fixed/handled. Additional information is welcome through
# patches to the file.
#
# Include this file in your local.conf or distro.conf to exclude these CVE's
# from the cve-check results or add to the bitbake command with:
#     -R conf/distro/include/cve-extra-exclusions.inc
#
# The file is not included by default since users should review this data to ensure
# it matches their expectations and usage of the project.
#
# We may also include "in-flight" information about current/ongoing CVE work with
# the aim of sharing that work and ensuring we don't duplicate it.
#


# strace https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2000-0006
# CVE is more than 20 years old with no resolution evident
# broken links in CVE database references make resolution impractical
CVE_CHECK_WHITELIST += "CVE-2000-0006"

# epiphany https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2005-0238
# The issue here is spoofing of domain names using characters from other character sets.
# There has been much discussion amongst the epiphany and webkit developers and
# whilst there are improvements about how domains are handled and displayed to the user
# there is unlikely ever to be a single fix to webkit or epiphany which addresses this
# problem. Whitelisted as there isn't any mitigation or fix or way to progress this further
# we can seem to take.
CVE_CHECK_WHITELIST += "CVE-2005-0238"

# glibc https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2010-4756
# Issue is memory exhaustion via glob() calls, e.g. from within an ftp server
# Best discussion in https://bugzilla.redhat.com/show_bug.cgi?id=681681
# Upstream don't see it as a security issue, ftp servers shouldn't be passing
# this to libc glob. Exclude as upstream have no plans to add BSD's GLOB_LIMIT or similar
CVE_CHECK_WHITELIST += "CVE-2010-4756"

# go https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2020-29509
# go https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2020-29511
# The encoding/xml package in go can potentially be used for security exploits if not used correctly
# CVE applies to a netapp product as well as flagging a general issue. We don't ship anything
# exposing this interface in an exploitable way
CVE_CHECK_WHITELIST += "CVE-2020-29509 CVE-2020-29511"



#### CPE update pending ####

# groff:groff-native https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2000-0803
# Appears it was fixed in https://git.savannah.gnu.org/cgit/groff.git/commit/?id=07f95f1674217275ed4612f1dcaa95a88435c6a7
# so from 1.17 onwards. Reported to the database for update by RP 2021/5/9. Update accepted 2021/5/10.
#CVE_CHECK_WHITELIST += "CVE-2000-0803"



#### Upstream still working on ####

# qemu:qemu-native:qemu-system-native https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2021-20255
# There was a proposed patch https://lists.gnu.org/archive/html/qemu-devel/2021-02/msg06098.html
# however qemu maintainers are sure the patch is incorrect and should not be applied.

# flex:flex-native https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2019-6293
# Upstream bug, still open: https://github.com/westes/flex/issues/414
# Causes memory exhaustion so potential DoS but no buffer overflow, low priority

# wget https://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2021-31879
# https://mail.gnu.org/archive/html/bug-wget/2021-02/msg00002.html
# No response upstream as of 2021/5/12



