#ifndef FONTFORGE_MACBINARY_H
#define FONTFORGE_MACBINARY_H

#include "splinefont.h"

extern char **NamesReadMacBinary(char *filename);
extern int LoadKerningDataFromMacFOND(SplineFont *sf, char *filename, EncMap *map);
extern int WriteMacBitmaps(char *filename, SplineFont *sf, int32 *sizes, int is_dfont, EncMap *enc);
extern int WriteMacFamily(char *filename, struct sflist *sfs, enum fontformat format, enum bitmapformat bf, int flags, int layer);
extern int WriteMacPSFont(char *filename, SplineFont *sf, enum fontformat format, int flags, EncMap *enc, int layer);
extern int WriteMacTTFFont(char *filename, SplineFont *sf, enum fontformat format, int32 *bsizes, enum bitmapformat bf, int flags, EncMap *enc, int layer);
extern long mactime(void);
extern SplineChar *SFFindExistingCharMac(SplineFont *sf, EncMap *map, int unienc);
extern SplineFont *SFReadMacBinary(char *filename, int flags, enum openflags openflags);
extern uint16 _MacStyleCode(const char *styles, SplineFont *sf, uint16 *psstylecode);
extern void SfListFree(struct sflist *sfs);

#endif /* FONTFORGE_MACBINARY_H */
