/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 *  Copyright (C) NEC Electronics Corporation 2005-2006
 *
 *  This file based on include/asm-mips/ddb5xxx/ddb5xxx.h
 *	    Copyright 2001 MontaVista Software Inc.
 */

#ifndef MARKEINS_H
#define MARKEINS_H

#define NUM_EMMA2RH_IRQ_SW	32
#define NUM_EMMA2RH_IRQ_GPIO	32

#define EMMA2RH_SW_CASCADE	(EMMA2RH_IRQ_INT(7) - EMMA2RH_IRQ_INT(0))
#define EMMA2RH_GPIO_CASCADE	(EMMA2RH_IRQ_INT(46) - EMMA2RH_IRQ_INT(0))

#define EMMA2RH_SW_IRQ_BASE	(EMMA2RH_IRQ_BASE + NUM_EMMA2RH_IRQ)
#define EMMA2RH_GPIO_IRQ_BASE	(EMMA2RH_SW_IRQ_BASE + NUM_EMMA2RH_IRQ_SW)

#define EMMA2RH_SW_IRQ_INT(n)	(EMMA2RH_SW_IRQ_BASE + (n))

#define MARKEINS_PCI_IRQ_INTA	EMMA2RH_GPIO_IRQ_BASE+15
#define MARKEINS_PCI_IRQ_INTB	EMMA2RH_GPIO_IRQ_BASE+16
#define MARKEINS_PCI_IRQ_INTC	EMMA2RH_GPIO_IRQ_BASE+17
#define MARKEINS_PCI_IRQ_INTD	EMMA2RH_GPIO_IRQ_BASE+18

#endif /* CONFIG_MARKEINS */
