#include <stdio.h>

unsigned long long data[32] = {
   0x0000000000000000ull, 0x0000000000000000ull,
   0xffffffffffffffffull, 0xffffffffffffffffull,
   0x0000000080000000ull, 0x8000000000000000ull,
   0x8000800080008000ull, 0x7fff7fff7fff7fffull,
   0x8080808080808080ull, 0x8080808080808080ull,
   0x7070707070707070ull, 0x7070707070707070ull,
   0x7f7f7f7f7f7f7f7full, 0x7f7f7f7f7f7f7f7full,
   0x0706050403020100ull, 0x0f0e0d0c0b0a0908ull,
   0x77665544332211ffull, 0xeeddccbbaa998877ull,
   0x0000000000000001ull, 0x00000000000001ffull,
   0x0000000000000001ull, 0x00000000000000ffull,
   0xffffffffffffffffull, 0x0000000000000000ull,
   0x0000000100000001ull, 0x0000000100000001ull,
   0x1234567890abcdefull, 0xfedbca9876543210ull,
   0x0403020114131211ull, 0x2423222134333231ull,
   0x8483828194939291ull, 0xa4a3a2a1b4b3b2b1ull,
};

unsigned long long out[2];

#define TEST_3R(instruction, offset1, offset2, WD, WS, WT)             \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset1"($t0)\n\t"                               \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset1"($t0)\n\t"                               \
      "ld.d $"#WT", "#offset2"($t0)\n\t"                               \
      instruction" $"#WD", $"#WS", $"#WT"\n\t"                         \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", $"#WT" "#WD":"                  \
          " %016llx%016llx  "#WS": %016llx%016llx  "#WT": "            \
          "%016llx%016llx\n", out[1], out[0], data[offset1 / 8 + 1],   \
          data[offset1 / 8], data[offset2 / 8 + 1], data[offset2 / 8]);\
}

#define TEST_BIT(instruction, offset, WD, WS, n)                       \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset"($t0)\n\t"                                \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset"($t0)\n\t"                                \
      instruction" $"#WD", $"#WS", "#n"\n\t"                           \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", "#n" "#WD":"                    \
          " %016llx%016llx  "#WS": %016llx%016llx\n",                  \
          out[1], out[0], data[offset / 8 + 1], data[offset / 8]);     \
}

#define TEST_I5(instruction, offset, WD, WS, imm)                      \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset"($t0)\n\t"                                \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset"($t0)\n\t"                                \
      instruction" $"#WD", $"#WS", "#imm"\n\t"                         \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", "#imm" "#WD":"                  \
          " %016llx%016llx  "#WS": %016llx%016llx\n",                  \
          out[1], out[0], data[offset / 8 + 1], data[offset / 8]);     \
}

int main(int argc, char **argv) {
#if defined(__mips_msa)
   TEST_3R("add_a.b",   0, 144, w0,  w0,  w8);
   TEST_3R("add_a.b",   8, 144, w1,  w0,  w27);
   TEST_3R("add_a.b",  16,  64, w2,  w11, w19);
   TEST_3R("add_a.b",  24,  88, w3,  w10, w9);
   TEST_3R("add_a.b",  32,  24, w4,  w19, w16);
   TEST_3R("add_a.b",  40, 216, w5,  w6,  w29);
   TEST_3R("add_a.b",  48, 104, w6,  w9,  w11);
   TEST_3R("add_a.b",  56, 112, w7,  w7,  w7);
   TEST_3R("add_a.b",  64, 192, w8,  w6,  w1);
   TEST_3R("add_a.b",  72,  80, w9,  w8,  w9);
   TEST_3R("add_a.b",  80, 216, w10, w18, w22);
   TEST_3R("add_a.b",  88,  56, w11, w9,  w22);
   TEST_3R("add_a.b",  96, 232, w12, w14, w1);
   TEST_3R("add_a.b", 104,  32, w13, w4,  w11);
   TEST_3R("add_a.b", 112, 168, w14, w2,  w2);
   TEST_3R("add_a.b", 120,  48, w15, w5,  w14);
   TEST_3R("add_a.b", 128,   8, w16, w2,  w6);
   TEST_3R("add_a.b", 136,  64, w17, w11, w13);
   TEST_3R("add_a.b", 144, 104, w18, w21, w0);
   TEST_3R("add_a.b", 152, 224, w19, w22, w21);
   TEST_3R("add_a.b", 160,  64, w20, w30, w10);
   TEST_3R("add_a.b", 168, 176, w21, w20, w7);
   TEST_3R("add_a.b", 176,  56, w22, w10, w31);
   TEST_3R("add_a.b", 184, 160, w23, w11, w19);
   TEST_3R("add_a.b", 192,  96, w24, w0,  w21);
   TEST_3R("add_a.b", 200, 152, w25, w5,  w3);
   TEST_3R("add_a.b", 208,  32, w26, w7,  w10);
   TEST_3R("add_a.b", 216, 216, w27, w18, w23);
   TEST_3R("add_a.b", 224,  80, w28, w8,  w23);
   TEST_3R("add_a.b", 232,  72, w29, w30, w13);
   TEST_3R("add_a.b", 240,  16, w30, w29, w23);
   TEST_3R("add_a.b", 232, 200, w31, w17, w28);
   TEST_3R("add_a.h",   0,  72, w0,  w0,  w7);
   TEST_3R("add_a.h",   8,  88, w1,  w18, w30);
   TEST_3R("add_a.h",  16, 104, w2,  w7,  w18);
   TEST_3R("add_a.h",  24, 208, w3,  w11, w21);
   TEST_3R("add_a.h",  32, 184, w4,  w13, w8);
   TEST_3R("add_a.h",  40,   8, w5,  w16, w3);
   TEST_3R("add_a.h",  48,  80, w6,  w14, w16);
   TEST_3R("add_a.h",  56, 200, w7,  w7,  w7);
   TEST_3R("add_a.h",  64, 112, w8,  w3,  w29);
   TEST_3R("add_a.h",  72, 216, w9,  w20, w9);
   TEST_3R("add_a.h",  80,  96, w10, w5,  w19);
   TEST_3R("add_a.h",  88, 136, w11, w15, w6);
   TEST_3R("add_a.h",  96, 160, w12, w24, w13);
   TEST_3R("add_a.h", 104,  88, w13, w7,  w24);
   TEST_3R("add_a.h", 112, 232, w14, w28, w28);
   TEST_3R("add_a.h", 120,  56, w15, w9,  w4);
   TEST_3R("add_a.h", 128, 152, w16, w15, w20);
   TEST_3R("add_a.h", 136,  56, w17, w8,  w3);
   TEST_3R("add_a.h", 144,  96, w18, w27, w14);
   TEST_3R("add_a.h", 152, 216, w19, w30, w11);
   TEST_3R("add_a.h", 160, 176, w20, w18, w4);
   TEST_3R("add_a.h", 168, 216, w21, w5,  w17);
   TEST_3R("add_a.h", 176,  72, w22, w3,  w9);
   TEST_3R("add_a.h", 184,  96, w23, w20, w16);
   TEST_3R("add_a.h", 192,  88, w24, w16, w13);
   TEST_3R("add_a.h", 200, 152, w25, w26, w17);
   TEST_3R("add_a.h", 208, 176, w26, w9,  w6);
   TEST_3R("add_a.h", 216,   0, w27, w17, w9);
   TEST_3R("add_a.h", 224, 104, w28, w12, w23);
   TEST_3R("add_a.h", 232, 192, w29, w10, w3);
   TEST_3R("add_a.h", 240,   0, w30, w28, w7);
   TEST_3R("add_a.h",  56, 200, w31, w2,  w12);
   TEST_3R("add_a.w",   0, 144, w0,  w0,  w16);
   TEST_3R("add_a.w",   8,  64, w1,  w6,  w4);
   TEST_3R("add_a.w",  16,  72, w2,  w24, w21);
   TEST_3R("add_a.w",  24,  64, w3,  w23, w15);
   TEST_3R("add_a.w",  32,  80, w4,  w15, w24);
   TEST_3R("add_a.w",  40,  40, w5,  w9,  w15);
   TEST_3R("add_a.w",  48,  16, w6,  w22, w7);
   TEST_3R("add_a.w",  56, 224, w7,  w7,  w7);
   TEST_3R("add_a.w",  64, 104, w8,  w10, w21);
   TEST_3R("add_a.w",  72,  88, w9,  w17, w9);
   TEST_3R("add_a.w",  80, 160, w10, w31, w30);
   TEST_3R("add_a.w",  88,  64, w11, w12, w14);
   TEST_3R("add_a.w",  96, 136, w12, w19, w18);
   TEST_3R("add_a.w", 104,  80, w13, w11, w7);
   TEST_3R("add_a.w", 112, 160, w14, w2,  w2);
   TEST_3R("add_a.w", 120, 104, w15, w23, w17);
   TEST_3R("add_a.w", 128,  56, w16, w30, w22);
   TEST_3R("add_a.w", 136, 184, w17, w13, w30);
   TEST_3R("add_a.w", 144,  40, w18, w20, w31);
   TEST_3R("add_a.w", 152, 152, w19, w30, w20);
   TEST_3R("add_a.w", 160, 216, w20, w16, w1);
   TEST_3R("add_a.w", 168,  88, w21, w14, w23);
   TEST_3R("add_a.w", 176,   8, w22, w27, w10);
   TEST_3R("add_a.w", 184, 144, w23, w3,  w21);
   TEST_3R("add_a.w", 192,  72, w24, w26, w23);
   TEST_3R("add_a.w", 200,  56, w25, w18, w8);
   TEST_3R("add_a.w", 208, 112, w26, w16, w31);
   TEST_3R("add_a.w", 216, 176, w27, w29, w1);
   TEST_3R("add_a.w", 224, 112, w28, w15, w16);
   TEST_3R("add_a.w", 232,  16, w29, w27, w0);
   TEST_3R("add_a.w", 240, 208, w30, w5,  w14);
   TEST_3R("add_a.w", 160, 112, w31, w28, w10);
   TEST_3R("add_a.d",   0,  16, w0,  w0,  w25);
   TEST_3R("add_a.d",   8,  16, w1,  w27, w15);
   TEST_3R("add_a.d",  16,  32, w2,  w18, w27);
   TEST_3R("add_a.d",  24, 144, w3,  w27, w22);
   TEST_3R("add_a.d",  32,  96, w4,  w26, w9);
   TEST_3R("add_a.d",  40,  32, w5,  w23, w10);
   TEST_3R("add_a.d",  48, 112, w6,  w20, w26);
   TEST_3R("add_a.d",  56, 112, w7,  w7,  w7);
   TEST_3R("add_a.d",  64, 128, w8,  w21, w3);
   TEST_3R("add_a.d",  72,  32, w9,  w26, w9);
   TEST_3R("add_a.d",  80,  24, w10, w30, w23);
   TEST_3R("add_a.d",  88, 144, w11, w1,  w29);
   TEST_3R("add_a.d",  96, 176, w12, w8,  w25);
   TEST_3R("add_a.d", 104,  48, w13, w9,  w11);
   TEST_3R("add_a.d", 112,  96, w14, w28, w28);
   TEST_3R("add_a.d", 120,   0, w15, w22, w31);
   TEST_3R("add_a.d", 128, 200, w16, w0,  w31);
   TEST_3R("add_a.d", 136, 200, w17, w10, w18);
   TEST_3R("add_a.d", 144,  80, w18, w4,  w21);
   TEST_3R("add_a.d", 152,  88, w19, w25, w24);
   TEST_3R("add_a.d", 160, 168, w20, w10, w6);
   TEST_3R("add_a.d", 168,  88, w21, w7,  w8);
   TEST_3R("add_a.d", 176, 128, w22, w28, w16);
   TEST_3R("add_a.d", 184, 184, w23, w1,  w25);
   TEST_3R("add_a.d", 192,  48, w24, w1,  w21);
   TEST_3R("add_a.d", 200, 160, w25, w23, w20);
   TEST_3R("add_a.d", 208, 120, w26, w23, w19);
   TEST_3R("add_a.d", 216,  88, w27, w2,  w5);
   TEST_3R("add_a.d", 224,  40, w28, w6,  w26);
   TEST_3R("add_a.d", 232,   0, w29, w0,  w19);
   TEST_3R("add_a.d", 240, 176, w30, w20, w29);
   TEST_3R("add_a.d",   8, 224, w31, w4,  w7);
   TEST_3R("adds_a.b",   0,  40, w0,  w3,  w29);
   TEST_3R("adds_a.b",   8, 200, w1,  w26, w17);
   TEST_3R("adds_a.b",  16, 192, w2,  w2,  w18);
   TEST_3R("adds_a.b",  24,  72, w3,  w9,  w20);
   TEST_3R("adds_a.b",  32, 128, w4,  w1,  w26);
   TEST_3R("adds_a.b",  40,   8, w5,  w10, w26);
   TEST_3R("adds_a.b",  48,  96, w6,  w27, w14);
   TEST_3R("adds_a.b",  56,  56, w7,  w19, w13);
   TEST_3R("adds_a.b",  64,  80, w8,  w18, w8);
   TEST_3R("adds_a.b",  72,  40, w9,  w9,  w9);
   TEST_3R("adds_a.b",  80,  88, w10, w2,  w30);
   TEST_3R("adds_a.b",  88, 144, w11, w10, w20);
   TEST_3R("adds_a.b",  96, 168, w12, w8,  w29);
   TEST_3R("adds_a.b", 104,  40, w13, w25, w27);
   TEST_3R("adds_a.b", 112, 224, w14, w30, w4);
   TEST_3R("adds_a.b", 120,  40, w15, w9,  w6);
   TEST_3R("adds_a.b", 128, 128, w16, w14, w21);
   TEST_3R("adds_a.b", 136, 104, w17, w12, w4);
   TEST_3R("adds_a.b", 144, 160, w18, w31, w17);
   TEST_3R("adds_a.b", 152,  80, w19, w17, w6);
   TEST_3R("adds_a.b", 160, 168, w20, w19, w4);
   TEST_3R("adds_a.b", 168,  72, w21, w30, w24);
   TEST_3R("adds_a.b", 176, 128, w22, w6,  w6);
   TEST_3R("adds_a.b", 184,  32, w23, w8,  w31);
   TEST_3R("adds_a.b", 192, 128, w24, w20, w30);
   TEST_3R("adds_a.b", 200, 152, w25, w21, w7);
   TEST_3R("adds_a.b", 208, 136, w26, w16, w21);
   TEST_3R("adds_a.b", 216,  56, w27, w5,  w24);
   TEST_3R("adds_a.b", 224, 136, w28, w22, w23);
   TEST_3R("adds_a.b", 232,  64, w29, w12, w8);
   TEST_3R("adds_a.b", 240,  24, w30, w28, w6);
   TEST_3R("adds_a.b", 160, 208, w31, w26, w30);
   TEST_3R("adds_a.h",   0,  88, w0,  w20, w31);
   TEST_3R("adds_a.h",   8,  72, w1,  w5,  w20);
   TEST_3R("adds_a.h",  16, 152, w2,  w2,  w27);
   TEST_3R("adds_a.h",  24, 200, w3,  w4,  w22);
   TEST_3R("adds_a.h",  32, 216, w4,  w25, w2);
   TEST_3R("adds_a.h",  40, 152, w5,  w20, w26);
   TEST_3R("adds_a.h",  48,  48, w6,  w11, w17);
   TEST_3R("adds_a.h",  56, 224, w7,  w23, w26);
   TEST_3R("adds_a.h",  64, 176, w8,  w19, w8);
   TEST_3R("adds_a.h",  72, 232, w9,  w9,  w9);
   TEST_3R("adds_a.h",  80, 200, w10, w29, w16);
   TEST_3R("adds_a.h",  88, 168, w11, w21, w16);
   TEST_3R("adds_a.h",  96,  64, w12, w20, w15);
   TEST_3R("adds_a.h", 104, 112, w13, w8,  w30);
   TEST_3R("adds_a.h", 112, 184, w14, w17, w20);
   TEST_3R("adds_a.h", 120,  40, w15, w11, w23);
   TEST_3R("adds_a.h", 128, 192, w16, w31, w17);
   TEST_3R("adds_a.h", 136,   0, w17, w10, w3);
   TEST_3R("adds_a.h", 144, 104, w18, w1,  w29);
   TEST_3R("adds_a.h", 152, 160, w19, w21, w3);
   TEST_3R("adds_a.h", 160,  16, w20, w3,  w12);
   TEST_3R("adds_a.h", 168,  88, w21, w19, w9);
   TEST_3R("adds_a.h", 176,  40, w22, w2,  w2);
   TEST_3R("adds_a.h", 184, 120, w23, w4,  w15);
   TEST_3R("adds_a.h", 192,   8, w24, w22, w1);
   TEST_3R("adds_a.h", 200, 208, w25, w0,  w12);
   TEST_3R("adds_a.h", 208,  64, w26, w9,  w11);
   TEST_3R("adds_a.h", 216, 200, w27, w26, w22);
   TEST_3R("adds_a.h", 224, 208, w28, w14, w23);
   TEST_3R("adds_a.h", 232, 168, w29, w7,  w12);
   TEST_3R("adds_a.h", 240, 120, w30, w10, w31);
   TEST_3R("adds_a.h",  72, 112, w31, w22, w6);
   TEST_3R("adds_a.w",   0, 120, w0,  w2,  w19);
   TEST_3R("adds_a.w",   8, 112, w1,  w7,  w2);
   TEST_3R("adds_a.w",  16,  48, w2,  w2,  w29);
   TEST_3R("adds_a.w",  24,  56, w3,  w21, w29);
   TEST_3R("adds_a.w",  32,   8, w4,  w11, w7);
   TEST_3R("adds_a.w",  40,   0, w5,  w19, w1);
   TEST_3R("adds_a.w",  48, 152, w6,  w29, w16);
   TEST_3R("adds_a.w",  56,  96, w7,  w5,  w23);
   TEST_3R("adds_a.w",  64, 112, w8,  w31, w8);
   TEST_3R("adds_a.w",  72, 208, w9,  w9,  w9);
   TEST_3R("adds_a.w",  80,  88, w10, w29, w23);
   TEST_3R("adds_a.w",  88,  56, w11, w13, w22);
   TEST_3R("adds_a.w",  96, 192, w12, w0,  w2);
   TEST_3R("adds_a.w", 104, 128, w13, w3,  w25);
   TEST_3R("adds_a.w", 112,  80, w14, w6,  w30);
   TEST_3R("adds_a.w", 120, 208, w15, w26, w5);
   TEST_3R("adds_a.w", 128,  80, w16, w13, w7);
   TEST_3R("adds_a.w", 136, 232, w17, w10, w23);
   TEST_3R("adds_a.w", 144,  88, w18, w15, w14);
   TEST_3R("adds_a.w", 152,  96, w19, w15, w12);
   TEST_3R("adds_a.w", 160, 136, w20, w14, w25);
   TEST_3R("adds_a.w", 168, 168, w21, w11, w26);
   TEST_3R("adds_a.w", 176,  72, w22, w15, w15);
   TEST_3R("adds_a.w", 184,  96, w23, w24, w16);
   TEST_3R("adds_a.w", 192,  56, w24, w6,  w14);
   TEST_3R("adds_a.w", 200,  24, w25, w0,  w20);
   TEST_3R("adds_a.w", 208, 216, w26, w13, w27);
   TEST_3R("adds_a.w", 216, 208, w27, w24, w18);
   TEST_3R("adds_a.w", 224, 176, w28, w7,  w0);
   TEST_3R("adds_a.w", 232, 232, w29, w22, w15);
   TEST_3R("adds_a.w", 240, 136, w30, w2,  w21);
   TEST_3R("adds_a.w", 192, 208, w31, w28, w17);
   TEST_3R("adds_a.d",   0,  32, w0,  w16, w18);
   TEST_3R("adds_a.d",   8,   0, w1,  w8,  w2);
   TEST_3R("adds_a.d",  16,   0, w2,  w2,  w15);
   TEST_3R("adds_a.d",  24, 160, w3,  w16, w15);
   TEST_3R("adds_a.d",  32, 184, w4,  w26, w29);
   TEST_3R("adds_a.d",  40, 192, w5,  w7,  w21);
   TEST_3R("adds_a.d",  48, 224, w6,  w30, w28);
   TEST_3R("adds_a.d",  56, 160, w7,  w20, w19);
   TEST_3R("adds_a.d",  64,   0, w8,  w30, w8);
   TEST_3R("adds_a.d",  72, 192, w9,  w9,  w9);
   TEST_3R("adds_a.d",  80, 128, w10, w22, w17);
   TEST_3R("adds_a.d",  88,   0, w11, w25, w7);
   TEST_3R("adds_a.d",  96, 192, w12, w11, w26);
   TEST_3R("adds_a.d", 104,  88, w13, w17, w15);
   TEST_3R("adds_a.d", 112, 128, w14, w1,  w30);
   TEST_3R("adds_a.d", 120,  16, w15, w27, w2);
   TEST_3R("adds_a.d", 128,   8, w16, w19, w0);
   TEST_3R("adds_a.d", 136,  32, w17, w5,  w21);
   TEST_3R("adds_a.d", 144,  32, w18, w5,  w19);
   TEST_3R("adds_a.d", 152, 112, w19, w27, w10);
   TEST_3R("adds_a.d", 160,  24, w20, w2,  w3);
   TEST_3R("adds_a.d", 168,  88, w21, w25, w15);
   TEST_3R("adds_a.d", 176,  88, w22, w25, w25);
   TEST_3R("adds_a.d", 184,  56, w23, w26, w8);
   TEST_3R("adds_a.d", 192,  56, w24, w27, w7);
   TEST_3R("adds_a.d", 200, 120, w25, w22, w2);
   TEST_3R("adds_a.d", 208, 144, w26, w25, w19);
   TEST_3R("adds_a.d", 216,  16, w27, w25, w0);
   TEST_3R("adds_a.d", 224,  56, w28, w14, w0);
   TEST_3R("adds_a.d", 232, 168, w29, w2,  w21);
   TEST_3R("adds_a.d", 240, 168, w30, w12, w28);
   TEST_3R("adds_a.d",  40,  48, w31, w15, w11);
   TEST_3R("adds_s.b",   0, 184, w0,  w21, w9);
   TEST_3R("adds_s.b",   8,  72, w1,  w18, w31);
   TEST_3R("adds_s.b",  16, 192, w2,  w17, w24);
   TEST_3R("adds_s.b",  24,  80, w3,  w4,  w18);
   TEST_3R("adds_s.b",  32,   0, w4,  w27, w0);
   TEST_3R("adds_s.b",  40,  64, w5,  w24, w2);
   TEST_3R("adds_s.b",  48,   0, w6,  w16, w14);
   TEST_3R("adds_s.b",  56,  88, w7,  w10, w30);
   TEST_3R("adds_s.b",  64, 144, w8,  w30, w28);
   TEST_3R("adds_s.b",  72, 112, w9,  w11, w23);
   TEST_3R("adds_s.b",  80, 232, w10, w0,  w13);
   TEST_3R("adds_s.b",  88, 232, w11, w29, w31);
   TEST_3R("adds_s.b",  96,   0, w12, w28, w17);
   TEST_3R("adds_s.b", 104, 176, w13, w13, w14);
   TEST_3R("adds_s.b", 112, 128, w14, w4,  w4);
   TEST_3R("adds_s.b", 120,   0, w15, w16, w4);
   TEST_3R("adds_s.b", 128, 184, w16, w9,  w7);
   TEST_3R("adds_s.b", 136, 184, w17, w25, w21);
   TEST_3R("adds_s.b", 144, 152, w18, w4,  w19);
   TEST_3R("adds_s.b", 152,  56, w19, w2,  w16);
   TEST_3R("adds_s.b", 160, 136, w20, w20, w20);
   TEST_3R("adds_s.b", 168, 216, w21, w7,  w0);
   TEST_3R("adds_s.b", 176, 232, w22, w20, w26);
   TEST_3R("adds_s.b", 184,  48, w23, w20, w6);
   TEST_3R("adds_s.b", 192, 232, w24, w6,  w20);
   TEST_3R("adds_s.b", 200, 216, w25, w10, w20);
   TEST_3R("adds_s.b", 208, 176, w26, w14, w6);
   TEST_3R("adds_s.b", 216,  64, w27, w21, w27);
   TEST_3R("adds_s.b", 224,   8, w28, w13, w11);
   TEST_3R("adds_s.b", 232, 168, w29, w17, w30);
   TEST_3R("adds_s.b", 240, 104, w30, w19, w14);
   TEST_3R("adds_s.b", 104, 152, w31, w0,  w22);
   TEST_3R("adds_s.h",   0, 104, w0,  w10, w20);
   TEST_3R("adds_s.h",   8, 168, w1,  w30, w8);
   TEST_3R("adds_s.h",  16,  48, w2,  w3,  w14);
   TEST_3R("adds_s.h",  24,  48, w3,  w29, w24);
   TEST_3R("adds_s.h",  32,  40, w4,  w8,  w7);
   TEST_3R("adds_s.h",  40, 104, w5,  w27, w28);
   TEST_3R("adds_s.h",  48, 120, w6,  w8,  w7);
   TEST_3R("adds_s.h",  56, 160, w7,  w25, w6);
   TEST_3R("adds_s.h",  64,  24, w8,  w12, w20);
   TEST_3R("adds_s.h",  72,  56, w9,  w12, w10);
   TEST_3R("adds_s.h",  80, 120, w10, w26, w21);
   TEST_3R("adds_s.h",  88,  96, w11, w18, w19);
   TEST_3R("adds_s.h",  96, 224, w12, w16, w23);
   TEST_3R("adds_s.h", 104, 176, w13, w13, w3);
   TEST_3R("adds_s.h", 112,  56, w14, w13, w13);
   TEST_3R("adds_s.h", 120, 104, w15, w28, w20);
   TEST_3R("adds_s.h", 128,  80, w16, w24, w7);
   TEST_3R("adds_s.h", 136,   8, w17, w24, w18);
   TEST_3R("adds_s.h", 144,  48, w18, w30, w8);
   TEST_3R("adds_s.h", 152, 112, w19, w18, w23);
   TEST_3R("adds_s.h", 160,  88, w20, w20, w20);
   TEST_3R("adds_s.h", 168,  96, w21, w0,  w13);
   TEST_3R("adds_s.h", 176, 208, w22, w29, w31);
   TEST_3R("adds_s.h", 184, 120, w23, w3,  w15);
   TEST_3R("adds_s.h", 192, 112, w24, w19, w17);
   TEST_3R("adds_s.h", 200, 200, w25, w30, w13);
   TEST_3R("adds_s.h", 208,  24, w26, w23, w5);
   TEST_3R("adds_s.h", 216, 176, w27, w30, w27);
   TEST_3R("adds_s.h", 224,  64, w28, w1,  w16);
   TEST_3R("adds_s.h", 232, 112, w29, w31, w24);
   TEST_3R("adds_s.h", 240, 104, w30, w18, w15);
   TEST_3R("adds_s.h", 200, 224, w31, w15, w6);
   TEST_3R("adds_s.w",   0,  32, w0,  w5,  w6);
   TEST_3R("adds_s.w",   8, 200, w1,  w21, w3);
   TEST_3R("adds_s.w",  16, 184, w2,  w8,  w20);
   TEST_3R("adds_s.w",  24,  16, w3,  w6,  w1);
   TEST_3R("adds_s.w",  32,  48, w4,  w29, w7);
   TEST_3R("adds_s.w",  40,   0, w5,  w27, w13);
   TEST_3R("adds_s.w",  48, 224, w6,  w11, w13);
   TEST_3R("adds_s.w",  56,  16, w7,  w4,  w19);
   TEST_3R("adds_s.w",  64,  32, w8,  w19, w13);
   TEST_3R("adds_s.w",  72,  16, w9,  w3,  w19);
   TEST_3R("adds_s.w",  80,  88, w10, w16, w25);
   TEST_3R("adds_s.w",  88, 152, w11, w0,  w14);
   TEST_3R("adds_s.w",  96, 160, w12, w9,  w22);
   TEST_3R("adds_s.w", 104, 216, w13, w13, w22);
   TEST_3R("adds_s.w", 112, 104, w14, w18, w18);
   TEST_3R("adds_s.w", 120, 160, w15, w25, w13);
   TEST_3R("adds_s.w", 128, 232, w16, w6,  w30);
   TEST_3R("adds_s.w", 136,  64, w17, w19, w15);
   TEST_3R("adds_s.w", 144, 144, w18, w6,  w23);
   TEST_3R("adds_s.w", 152, 208, w19, w4,  w26);
   TEST_3R("adds_s.w", 160, 176, w20, w20, w20);
   TEST_3R("adds_s.w", 168, 144, w21, w10, w0);
   TEST_3R("adds_s.w", 176,  56, w22, w10, w14);
   TEST_3R("adds_s.w", 184,  88, w23, w19, w4);
   TEST_3R("adds_s.w", 192, 128, w24, w10, w0);
   TEST_3R("adds_s.w", 200,  64, w25, w7,  w9);
   TEST_3R("adds_s.w", 208, 208, w26, w13, w15);
   TEST_3R("adds_s.w", 216, 176, w27, w12, w27);
   TEST_3R("adds_s.w", 224, 136, w28, w2,  w16);
   TEST_3R("adds_s.w", 232, 152, w29, w20, w7);
   TEST_3R("adds_s.w", 240, 128, w30, w25, w1);
   TEST_3R("adds_s.w", 112, 112, w31, w16, w11);
   TEST_3R("adds_s.d",   0,  40, w0,  w21, w17);
   TEST_3R("adds_s.d",   8, 136, w1,  w9,  w21);
   TEST_3R("adds_s.d",  16,  24, w2,  w19, w21);
   TEST_3R("adds_s.d",  24,  32, w3,  w26, w14);
   TEST_3R("adds_s.d",  32, 208, w4,  w14, w27);
   TEST_3R("adds_s.d",  40,  16, w5,  w0,  w7);
   TEST_3R("adds_s.d",  48,  24, w6,  w2,  w23);
   TEST_3R("adds_s.d",  56, 184, w7,  w23, w30);
   TEST_3R("adds_s.d",  64,  72, w8,  w16, w31);
   TEST_3R("adds_s.d",  72,  64, w9,  w0,  w10);
   TEST_3R("adds_s.d",  80,  16, w10, w2,  w0);
   TEST_3R("adds_s.d",  88,  96, w11, w17, w9);
   TEST_3R("adds_s.d",  96,  56, w12, w30, w28);
   TEST_3R("adds_s.d", 104,   0, w13, w13, w27);
   TEST_3R("adds_s.d", 112, 176, w14, w10, w10);
   TEST_3R("adds_s.d", 120,  16, w15, w4,  w5);
   TEST_3R("adds_s.d", 128, 152, w16, w4,  w13);
   TEST_3R("adds_s.d", 136, 184, w17, w7,  w4);
   TEST_3R("adds_s.d", 144, 136, w18, w30, w3);
   TEST_3R("adds_s.d", 152,  80, w19, w14, w2);
   TEST_3R("adds_s.d", 160,  24, w20, w20, w20);
   TEST_3R("adds_s.d", 168,  80, w21, w13, w8);
   TEST_3R("adds_s.d", 176, 176, w22, w13, w26);
   TEST_3R("adds_s.d", 184,  40, w23, w22, w2);
   TEST_3R("adds_s.d", 192, 184, w24, w18, w30);
   TEST_3R("adds_s.d", 200, 120, w25, w8,  w9);
   TEST_3R("adds_s.d", 208,  16, w26, w12, w14);
   TEST_3R("adds_s.d", 216,  72, w27, w16, w27);
   TEST_3R("adds_s.d", 224,  64, w28, w30, w23);
   TEST_3R("adds_s.d", 232, 224, w29, w11, w21);
   TEST_3R("adds_s.d", 240, 112, w30, w19, w3);
   TEST_3R("adds_s.d",  16,  32, w31, w25, w18);
   TEST_3R("adds_u.b",   0, 160, w0,  w21, w30);
   TEST_3R("adds_u.b",   8, 216, w1,  w7,  w28);
   TEST_3R("adds_u.b",  16,  24, w2,  w2,  w2);
   TEST_3R("adds_u.b",  24, 200, w3,  w5,  w25);
   TEST_3R("adds_u.b",  32, 232, w4,  w20, w20);
   TEST_3R("adds_u.b",  40, 168, w5,  w12, w15);
   TEST_3R("adds_u.b",  48,  48, w6,  w3,  w15);
   TEST_3R("adds_u.b",  56,  64, w7,  w25, w18);
   TEST_3R("adds_u.b",  64,  48, w8,  w28, w24);
   TEST_3R("adds_u.b",  72, 176, w9,  w14, w10);
   TEST_3R("adds_u.b",  80, 128, w10, w17, w30);
   TEST_3R("adds_u.b",  88,  56, w11, w31, w28);
   TEST_3R("adds_u.b",  96,  32, w12, w7,  w25);
   TEST_3R("adds_u.b", 104,  16, w13, w22, w30);
   TEST_3R("adds_u.b", 112, 184, w14, w18, w27);
   TEST_3R("adds_u.b", 120,  80, w15, w2,  w4);
   TEST_3R("adds_u.b", 128,  72, w16, w17, w25);
   TEST_3R("adds_u.b", 136,  32, w17, w4,  w0);
   TEST_3R("adds_u.b", 144, 224, w18, w28, w1);
   TEST_3R("adds_u.b", 152,   0, w19, w6,  w4);
   TEST_3R("adds_u.b", 160, 136, w20, w16, w2);
   TEST_3R("adds_u.b", 168, 192, w21, w16, w31);
   TEST_3R("adds_u.b", 176, 104, w22, w23, w24);
   TEST_3R("adds_u.b", 184, 120, w23, w13, w22);
   TEST_3R("adds_u.b", 192,   0, w24, w31, w9);
   TEST_3R("adds_u.b", 200,  56, w25, w29, w11);
   TEST_3R("adds_u.b", 208, 160, w26, w31, w28);
   TEST_3R("adds_u.b", 216, 208, w27, w25, w0);
   TEST_3R("adds_u.b", 224,  40, w28, w16, w28);
   TEST_3R("adds_u.b", 232, 224, w29, w5,  w22);
   TEST_3R("adds_u.b", 240,  48, w30, w9,  w12);
   TEST_3R("adds_u.b", 192,  40, w31, w31, w11);
   TEST_3R("adds_u.h",   0, 168, w0,  w10, w28);
   TEST_3R("adds_u.h",   8, 120, w1,  w2,  w22);
   TEST_3R("adds_u.h",  16,  24, w2,  w2,  w2);
   TEST_3R("adds_u.h",  24,  16, w3,  w1,  w7);
   TEST_3R("adds_u.h",  32,  80, w4,  w6,  w6);
   TEST_3R("adds_u.h",  40, 112, w5,  w13, w16);
   TEST_3R("adds_u.h",  48, 216, w6,  w9,  w19);
   TEST_3R("adds_u.h",  56, 120, w7,  w10, w23);
   TEST_3R("adds_u.h",  64,  16, w8,  w6,  w28);
   TEST_3R("adds_u.h",  72,  56, w9,  w5,  w16);
   TEST_3R("adds_u.h",  80,  16, w10, w16, w8);
   TEST_3R("adds_u.h",  88,  56, w11, w27, w4);
   TEST_3R("adds_u.h",  96, 176, w12, w29, w27);
   TEST_3R("adds_u.h", 104,  56, w13, w22, w28);
   TEST_3R("adds_u.h", 112, 136, w14, w24, w2);
   TEST_3R("adds_u.h", 120,  16, w15, w5,  w19);
   TEST_3R("adds_u.h", 128,   0, w16, w15, w6);
   TEST_3R("adds_u.h", 136, 232, w17, w25, w29);
   TEST_3R("adds_u.h", 144, 128, w18, w31, w25);
   TEST_3R("adds_u.h", 152,  32, w19, w9,  w30);
   TEST_3R("adds_u.h", 160, 216, w20, w6,  w15);
   TEST_3R("adds_u.h", 168,  16, w21, w6,  w10);
   TEST_3R("adds_u.h", 176,  24, w22, w1,  w7);
   TEST_3R("adds_u.h", 184, 112, w23, w4,  w30);
   TEST_3R("adds_u.h", 192, 168, w24, w15, w22);
   TEST_3R("adds_u.h", 200,   8, w25, w30, w28);
   TEST_3R("adds_u.h", 208,  32, w26, w18, w11);
   TEST_3R("adds_u.h", 216, 208, w27, w3,  w4);
   TEST_3R("adds_u.h", 224, 112, w28, w2,  w28);
   TEST_3R("adds_u.h", 232,  72, w29, w10, w5);
   TEST_3R("adds_u.h", 240, 208, w30, w9,  w24);
   TEST_3R("adds_u.h", 120,   0, w31, w31, w24);
   TEST_3R("adds_u.w",   0, 200, w0,  w2,  w21);
   TEST_3R("adds_u.w",   8, 216, w1,  w9,  w16);
   TEST_3R("adds_u.w",  16,  96, w2,  w2,  w2);
   TEST_3R("adds_u.w",  24,  24, w3,  w8,  w14);
   TEST_3R("adds_u.w",  32, 152, w4,  w2,  w2);
   TEST_3R("adds_u.w",  40,  24, w5,  w26, w15);
   TEST_3R("adds_u.w",  48, 128, w6,  w5,  w2);
   TEST_3R("adds_u.w",  56, 112, w7,  w9,  w19);
   TEST_3R("adds_u.w",  64, 104, w8,  w12, w30);
   TEST_3R("adds_u.w",  72,   0, w9,  w25, w7);
   TEST_3R("adds_u.w",  80, 112, w10, w11, w31);
   TEST_3R("adds_u.w",  88,   8, w11, w4,  w1);
   TEST_3R("adds_u.w",  96, 168, w12, w31, w10);
   TEST_3R("adds_u.w", 104, 192, w13, w30, w18);
   TEST_3R("adds_u.w", 112, 144, w14, w12, w16);
   TEST_3R("adds_u.w", 120, 224, w15, w24, w10);
   TEST_3R("adds_u.w", 128, 208, w16, w23, w15);
   TEST_3R("adds_u.w", 136,   8, w17, w24, w10);
   TEST_3R("adds_u.w", 144, 224, w18, w4,  w8);
   TEST_3R("adds_u.w", 152, 224, w19, w29, w15);
   TEST_3R("adds_u.w", 160, 104, w20, w9,  w14);
   TEST_3R("adds_u.w", 168, 112, w21, w13, w15);
   TEST_3R("adds_u.w", 176, 160, w22, w12, w25);
   TEST_3R("adds_u.w", 184, 224, w23, w10, w11);
   TEST_3R("adds_u.w", 192,   8, w24, w22, w27);
   TEST_3R("adds_u.w", 200, 104, w25, w15, w5);
   TEST_3R("adds_u.w", 208, 192, w26, w6,  w20);
   TEST_3R("adds_u.w", 216, 232, w27, w30, w12);
   TEST_3R("adds_u.w", 224, 112, w28, w26, w28);
   TEST_3R("adds_u.w", 232,  24, w29, w5,  w31);
   TEST_3R("adds_u.w", 240,  16, w30, w20, w4);
   TEST_3R("adds_u.w", 208, 168, w31, w31, w2);
   TEST_3R("adds_u.d",   0, 208, w0,  w17, w5);
   TEST_3R("adds_u.d",   8, 216, w1,  w10, w5);
   TEST_3R("adds_u.d",  16, 112, w2,  w2,  w2);
   TEST_3R("adds_u.d",  24, 144, w3,  w9,  w18);
   TEST_3R("adds_u.d",  32, 128, w4,  w17, w17);
   TEST_3R("adds_u.d",  40,  80, w5,  w23, w14);
   TEST_3R("adds_u.d",  48, 176, w6,  w11, w1);
   TEST_3R("adds_u.d",  56,  48, w7,  w24, w30);
   TEST_3R("adds_u.d",  64,   8, w8,  w9,  w3);
   TEST_3R("adds_u.d",  72,  24, w9,  w23, w4);
   TEST_3R("adds_u.d",  80,   0, w10, w25, w3);
   TEST_3R("adds_u.d",  88,  80, w11, w10, w8);
   TEST_3R("adds_u.d",  96, 176, w12, w20, w14);
   TEST_3R("adds_u.d", 104, 112, w13, w10, w23);
   TEST_3R("adds_u.d", 112, 112, w14, w28, w8);
   TEST_3R("adds_u.d", 120, 200, w15, w19, w22);
   TEST_3R("adds_u.d", 128,  16, w16, w30, w23);
   TEST_3R("adds_u.d", 136,  64, w17, w22, w21);
   TEST_3R("adds_u.d", 144, 192, w18, w31, w24);
   TEST_3R("adds_u.d", 152,  32, w19, w23, w15);
   TEST_3R("adds_u.d", 160, 168, w20, w6,  w8);
   TEST_3R("adds_u.d", 168,  96, w21, w26, w18);
   TEST_3R("adds_u.d", 176, 224, w22, w31, w7);
   TEST_3R("adds_u.d", 184,  56, w23, w1,  w17);
   TEST_3R("adds_u.d", 192, 176, w24, w21, w13);
   TEST_3R("adds_u.d", 200, 112, w25, w10, w0);
   TEST_3R("adds_u.d", 208,  56, w26, w7,  w31);
   TEST_3R("adds_u.d", 216, 112, w27, w10, w21);
   TEST_3R("adds_u.d", 224,  48, w28, w14, w28);
   TEST_3R("adds_u.d", 232, 136, w29, w28, w17);
   TEST_3R("adds_u.d", 240,  16, w30, w12, w24);
   TEST_3R("adds_u.d", 120,  64, w31, w31, w20);
   TEST_3R("addv.b",   0, 168, w0,  w22, w12);
   TEST_3R("addv.b",   8,   8, w1,  w14, w13);
   TEST_3R("addv.b",  16,   0, w2,  w12, w13);
   TEST_3R("addv.b",  24, 176, w3,  w19, w12);
   TEST_3R("addv.b",  32,  56, w4,  w30, w2);
   TEST_3R("addv.b",  40, 208, w5,  w12, w23);
   TEST_3R("addv.b",  48,  64, w6,  w29, w3);
   TEST_3R("addv.b",  56, 224, w7,  w7,  w7);
   TEST_3R("addv.b",  64, 208, w8,  w21, w23);
   TEST_3R("addv.b",  72, 152, w9,  w28, w13);
   TEST_3R("addv.b",  80, 184, w10, w3,  w25);
   TEST_3R("addv.b",  88, 184, w11, w18, w11);
   TEST_3R("addv.b",  96,   0, w12, w23, w1);
   TEST_3R("addv.b", 104,   8, w13, w4,  w7);
   TEST_3R("addv.b", 112, 120, w14, w17, w17);
   TEST_3R("addv.b", 120, 176, w15, w24, w19);
   TEST_3R("addv.b", 128,  24, w16, w4,  w10);
   TEST_3R("addv.b", 136,  88, w17, w1,  w13);
   TEST_3R("addv.b", 144, 216, w18, w22, w2);
   TEST_3R("addv.b", 152, 232, w19, w13, w3);
   TEST_3R("addv.b", 160, 112, w20, w26, w15);
   TEST_3R("addv.b", 168, 200, w21, w21, w30);
   TEST_3R("addv.b", 176,  80, w22, w16, w3);
   TEST_3R("addv.b", 184,  40, w23, w17, w9);
   TEST_3R("addv.b", 192,  80, w24, w3,  w29);
   TEST_3R("addv.b", 200, 128, w25, w27, w16);
   TEST_3R("addv.b", 208,  48, w26, w31, w16);
   TEST_3R("addv.b", 216,  80, w27, w7,  w26);
   TEST_3R("addv.b", 224,  48, w28, w9,  w26);
   TEST_3R("addv.b", 232,  88, w29, w12, w22);
   TEST_3R("addv.b", 240, 232, w30, w27, w28);
   TEST_3R("addv.b",  64,  72, w31, w4,  w13);
   TEST_3R("addv.h",   0, 224, w0,  w20, w29);
   TEST_3R("addv.h",   8, 144, w1,  w0,  w21);
   TEST_3R("addv.h",  16, 152, w2,  w29, w9);
   TEST_3R("addv.h",  24, 136, w3,  w13, w16);
   TEST_3R("addv.h",  32,  56, w4,  w7,  w1);
   TEST_3R("addv.h",  40,  16, w5,  w14, w27);
   TEST_3R("addv.h",  48,  72, w6,  w23, w21);
   TEST_3R("addv.h",  56,  48, w7,  w7,  w7);
   TEST_3R("addv.h",  64, 216, w8,  w11, w31);
   TEST_3R("addv.h",  72,   0, w9,  w5,  w3);
   TEST_3R("addv.h",  80,  72, w10, w17, w9);
   TEST_3R("addv.h",  88, 136, w11, w26, w11);
   TEST_3R("addv.h",  96, 208, w12, w4,  w14);
   TEST_3R("addv.h", 104,  40, w13, w30, w21);
   TEST_3R("addv.h", 112,  72, w14, w13, w13);
   TEST_3R("addv.h", 120,  40, w15, w31, w28);
   TEST_3R("addv.h", 128, 208, w16, w26, w2);
   TEST_3R("addv.h", 136, 128, w17, w16, w12);
   TEST_3R("addv.h", 144, 144, w18, w27, w21);
   TEST_3R("addv.h", 152,  88, w19, w3,  w26);
   TEST_3R("addv.h", 160,  96, w20, w24, w11);
   TEST_3R("addv.h", 168, 104, w21, w21, w2);
   TEST_3R("addv.h", 176,  88, w22, w12, w31);
   TEST_3R("addv.h", 184, 136, w23, w19, w12);
   TEST_3R("addv.h", 192,  80, w24, w8,  w10);
   TEST_3R("addv.h", 200,  80, w25, w5,  w9);
   TEST_3R("addv.h", 208, 224, w26, w16, w4);
   TEST_3R("addv.h", 216,  80, w27, w18, w20);
   TEST_3R("addv.h", 224, 208, w28, w24, w15);
   TEST_3R("addv.h", 232, 208, w29, w19, w0);
   TEST_3R("addv.h", 240,  64, w30, w11, w12);
   TEST_3R("addv.h", 152, 144, w31, w13, w6);
   TEST_3R("addv.w",   0, 184, w0,  w5,  w31);
   TEST_3R("addv.w",   8, 192, w1,  w18, w24);
   TEST_3R("addv.w",  16,  24, w2,  w28, w30);
   TEST_3R("addv.w",  24,  24, w3,  w6,  w0);
   TEST_3R("addv.w",  32, 104, w4,  w10, w5);
   TEST_3R("addv.w",  40, 208, w5,  w30, w23);
   TEST_3R("addv.w",  48,  96, w6,  w13, w29);
   TEST_3R("addv.w",  56,  32, w7,  w7,  w7);
   TEST_3R("addv.w",  64,  72, w8,  w30, w24);
   TEST_3R("addv.w",  72,  40, w9,  w10, w16);
   TEST_3R("addv.w",  80, 192, w10, w16, w20);
   TEST_3R("addv.w",  88,  32, w11, w22, w11);
   TEST_3R("addv.w",  96,  40, w12, w0,  w8);
   TEST_3R("addv.w", 104, 136, w13, w21, w4);
   TEST_3R("addv.w", 112, 104, w14, w16, w16);
   TEST_3R("addv.w", 120,  80, w15, w9,  w26);
   TEST_3R("addv.w", 128,   0, w16, w15, w23);
   TEST_3R("addv.w", 136, 176, w17, w6,  w13);
   TEST_3R("addv.w", 144, 208, w18, w3,  w0);
   TEST_3R("addv.w", 152,  40, w19, w1,  w24);
   TEST_3R("addv.w", 160, 192, w20, w11, w8);
   TEST_3R("addv.w", 168,  40, w21, w21, w28);
   TEST_3R("addv.w", 176,  72, w22, w25, w18);
   TEST_3R("addv.w", 184, 120, w23, w25, w26);
   TEST_3R("addv.w", 192, 128, w24, w14, w30);
   TEST_3R("addv.w", 200, 200, w25, w30, w9);
   TEST_3R("addv.w", 208, 184, w26, w25, w29);
   TEST_3R("addv.w", 216, 104, w27, w16, w2);
   TEST_3R("addv.w", 224, 168, w28, w16, w5);
   TEST_3R("addv.w", 232,  48, w29, w16, w7);
   TEST_3R("addv.w", 240,  56, w30, w29, w18);
   TEST_3R("addv.w",  72, 104, w31, w3,  w14);
   TEST_3R("addv.d",   0, 104, w0,  w10, w21);
   TEST_3R("addv.d",   8,  72, w1,  w5,  w3);
   TEST_3R("addv.d",  16,  24, w2,  w8,  w21);
   TEST_3R("addv.d",  24,  40, w3,  w31, w17);
   TEST_3R("addv.d",  32, 152, w4,  w15, w19);
   TEST_3R("addv.d",  40, 192, w5,  w31, w25);
   TEST_3R("addv.d",  48, 120, w6,  w16, w0);
   TEST_3R("addv.d",  56, 216, w7,  w7,  w7);
   TEST_3R("addv.d",  64,  32, w8,  w18, w27);
   TEST_3R("addv.d",  72, 216, w9,  w1,  w22);
   TEST_3R("addv.d",  80,  96, w10, w1,  w0);
   TEST_3R("addv.d",  88, 160, w11, w28, w11);
   TEST_3R("addv.d",  96, 104, w12, w4,  w21);
   TEST_3R("addv.d", 104, 128, w13, w6,  w23);
   TEST_3R("addv.d", 112, 160, w14, w1,  w1);
   TEST_3R("addv.d", 120,  16, w15, w21, w13);
   TEST_3R("addv.d", 128, 208, w16, w8,  w22);
   TEST_3R("addv.d", 136, 208, w17, w1,  w28);
   TEST_3R("addv.d", 144, 192, w18, w1,  w25);
   TEST_3R("addv.d", 152,  16, w19, w20, w18);
   TEST_3R("addv.d", 160, 160, w20, w10, w30);
   TEST_3R("addv.d", 168,  40, w21, w21, w10);
   TEST_3R("addv.d", 176, 144, w22, w18, w16);
   TEST_3R("addv.d", 184, 136, w23, w7,  w30);
   TEST_3R("addv.d", 192,  24, w24, w30, w1);
   TEST_3R("addv.d", 200, 200, w25, w21, w22);
   TEST_3R("addv.d", 208, 152, w26, w27, w31);
   TEST_3R("addv.d", 216, 224, w27, w0,  w11);
   TEST_3R("addv.d", 224, 184, w28, w2,  w4);
   TEST_3R("addv.d", 232, 152, w29, w22, w24);
   TEST_3R("addv.d", 240, 104, w30, w11, w2);
   TEST_3R("addv.d",  48, 152, w31, w1,  w13);
   TEST_3R("asub_s.b",   0,  96, w0,  w26, w28);
   TEST_3R("asub_s.b",   8,  56, w1,  w15, w19);
   TEST_3R("asub_s.b",  16, 216, w2,  w10, w18);
   TEST_3R("asub_s.b",  24, 160, w3,  w10, w18);
   TEST_3R("asub_s.b",  32, 152, w4,  w0,  w20);
   TEST_3R("asub_s.b",  40,   0, w5,  w25, w10);
   TEST_3R("asub_s.b",  48, 112, w6,  w4,  w21);
   TEST_3R("asub_s.b",  56,   0, w7,  w13, w23);
   TEST_3R("asub_s.b",  64,  64, w8,  w22, w11);
   TEST_3R("asub_s.b",  72,  40, w9,  w3,  w6);
   TEST_3R("asub_s.b",  80, 184, w10, w27, w0);
   TEST_3R("asub_s.b",  88, 216, w11, w30, w15);
   TEST_3R("asub_s.b",  96,  24, w12, w27, w25);
   TEST_3R("asub_s.b", 104, 208, w13, w13, w6);
   TEST_3R("asub_s.b", 112,  64, w14, w15, w29);
   TEST_3R("asub_s.b", 120, 104, w15, w4,  w25);
   TEST_3R("asub_s.b", 128, 176, w16, w14, w13);
   TEST_3R("asub_s.b", 136, 104, w17, w4,  w3);
   TEST_3R("asub_s.b", 144,  64, w18, w27, w7);
   TEST_3R("asub_s.b", 152,  88, w19, w6,  w7);
   TEST_3R("asub_s.b", 160, 176, w20, w12, w3);
   TEST_3R("asub_s.b", 168, 128, w21, w13, w27);
   TEST_3R("asub_s.b", 176, 136, w22, w28, w6);
   TEST_3R("asub_s.b", 184,  96, w23, w22, w22);
   TEST_3R("asub_s.b", 192, 224, w24, w4,  w26);
   TEST_3R("asub_s.b", 200, 160, w25, w1,  w30);
   TEST_3R("asub_s.b", 208,  16, w26, w28, w5);
   TEST_3R("asub_s.b", 216,  56, w27, w29, w27);
   TEST_3R("asub_s.b", 224, 208, w28, w11, w12);
   TEST_3R("asub_s.b", 232, 128, w29, w29, w29);
   TEST_3R("asub_s.b", 240,   8, w30, w18, w10);
   TEST_3R("asub_s.b", 104,  40, w31, w27, w22);
   TEST_3R("asub_s.h",   0,   0, w0,  w3,  w23);
   TEST_3R("asub_s.h",   8,   8, w1,  w0,  w29);
   TEST_3R("asub_s.h",  16, 128, w2,  w22, w0);
   TEST_3R("asub_s.h",  24,  32, w3,  w16, w19);
   TEST_3R("asub_s.h",  32, 232, w4,  w14, w9);
   TEST_3R("asub_s.h",  40, 128, w5,  w10, w14);
   TEST_3R("asub_s.h",  48,  80, w6,  w8,  w23);
   TEST_3R("asub_s.h",  56, 208, w7,  w20, w27);
   TEST_3R("asub_s.h",  64,  88, w8,  w6,  w5);
   TEST_3R("asub_s.h",  72,   8, w9,  w1,  w28);
   TEST_3R("asub_s.h",  80,  16, w10, w0,  w31);
   TEST_3R("asub_s.h",  88,  88, w11, w2,  w31);
   TEST_3R("asub_s.h",  96, 136, w12, w1,  w21);
   TEST_3R("asub_s.h", 104,  80, w13, w13, w4);
   TEST_3R("asub_s.h", 112, 176, w14, w2,  w8);
   TEST_3R("asub_s.h", 120, 232, w15, w11, w7);
   TEST_3R("asub_s.h", 128, 208, w16, w26, w14);
   TEST_3R("asub_s.h", 136, 184, w17, w31, w27);
   TEST_3R("asub_s.h", 144,  96, w18, w3,  w1);
   TEST_3R("asub_s.h", 152,  24, w19, w0,  w3);
   TEST_3R("asub_s.h", 160, 200, w20, w25, w3);
   TEST_3R("asub_s.h", 168, 232, w21, w10, w5);
   TEST_3R("asub_s.h", 176,  96, w22, w25, w6);
   TEST_3R("asub_s.h", 184, 120, w23, w8,  w8);
   TEST_3R("asub_s.h", 192,  16, w24, w8,  w10);
   TEST_3R("asub_s.h", 200, 136, w25, w28, w21);
   TEST_3R("asub_s.h", 208, 152, w26, w27, w15);
   TEST_3R("asub_s.h", 216, 160, w27, w1,  w27);
   TEST_3R("asub_s.h", 224, 184, w28, w8,  w14);
   TEST_3R("asub_s.h", 232, 152, w29, w29, w29);
   TEST_3R("asub_s.h", 240,  32, w30, w0,  w11);
   TEST_3R("asub_s.h",  56, 112, w31, w15, w4);
   TEST_3R("asub_s.w",   0,  56, w0,  w15, w10);
   TEST_3R("asub_s.w",   8, 152, w1,  w8,  w16);
   TEST_3R("asub_s.w",  16, 208, w2,  w16, w27);
   TEST_3R("asub_s.w",  24,  80, w3,  w26, w14);
   TEST_3R("asub_s.w",  32,  56, w4,  w15, w8);
   TEST_3R("asub_s.w",  40,   8, w5,  w31, w17);
   TEST_3R("asub_s.w",  48, 152, w6,  w0,  w25);
   TEST_3R("asub_s.w",  56,  72, w7,  w14, w4);
   TEST_3R("asub_s.w",  64, 216, w8,  w14, w15);
   TEST_3R("asub_s.w",  72,  88, w9,  w29, w19);
   TEST_3R("asub_s.w",  80,   8, w10, w26, w2);
   TEST_3R("asub_s.w",  88,  72, w11, w5,  w10);
   TEST_3R("asub_s.w",  96, 128, w12, w18, w26);
   TEST_3R("asub_s.w", 104,  64, w13, w13, w8);
   TEST_3R("asub_s.w", 112,   0, w14, w18, w27);
   TEST_3R("asub_s.w", 120, 192, w15, w27, w8);
   TEST_3R("asub_s.w", 128,  64, w16, w12, w23);
   TEST_3R("asub_s.w", 136, 160, w17, w5,  w3);
   TEST_3R("asub_s.w", 144, 200, w18, w9,  w12);
   TEST_3R("asub_s.w", 152, 104, w19, w24, w23);
   TEST_3R("asub_s.w", 160,  64, w20, w11, w6);
   TEST_3R("asub_s.w", 168,  88, w21, w14, w31);
   TEST_3R("asub_s.w", 176,  24, w22, w24, w8);
   TEST_3R("asub_s.w", 184, 168, w23, w19, w19);
   TEST_3R("asub_s.w", 192, 136, w24, w23, w7);
   TEST_3R("asub_s.w", 200,  72, w25, w18, w11);
   TEST_3R("asub_s.w", 208,  16, w26, w27, w14);
   TEST_3R("asub_s.w", 216, 160, w27, w18, w27);
   TEST_3R("asub_s.w", 224,  80, w28, w11, w21);
   TEST_3R("asub_s.w", 232, 224, w29, w29, w29);
   TEST_3R("asub_s.w", 240, 200, w30, w2,  w12);
   TEST_3R("asub_s.w", 136,  64, w31, w24, w22);
   TEST_3R("asub_s.d",   0,  64, w0,  w19, w30);
   TEST_3R("asub_s.d",   8, 112, w1,  w2,  w17);
   TEST_3R("asub_s.d",  16,  24, w2,  w25, w19);
   TEST_3R("asub_s.d",  24,  64, w3,  w4,  w13);
   TEST_3R("asub_s.d",  32,  40, w4,  w19, w20);
   TEST_3R("asub_s.d",  40,  88, w5,  w4,  w31);
   TEST_3R("asub_s.d",  48,  48, w6,  w7,  w20);
   TEST_3R("asub_s.d",  56,   8, w7,  w9,  w0);
   TEST_3R("asub_s.d",  64,  40, w8,  w24, w9);
   TEST_3R("asub_s.d",  72, 112, w9,  w30, w7);
   TEST_3R("asub_s.d",  80, 192, w10, w29, w13);
   TEST_3R("asub_s.d",  88, 200, w11, w14, w1);
   TEST_3R("asub_s.d",  96, 232, w12, w7,  w20);
   TEST_3R("asub_s.d", 104, 224, w13, w13, w12);
   TEST_3R("asub_s.d", 112,  80, w14, w0,  w31);
   TEST_3R("asub_s.d", 120, 144, w15, w25, w3);
   TEST_3R("asub_s.d", 128, 184, w16, w8,  w10);
   TEST_3R("asub_s.d", 136,  24, w17, w25, w19);
   TEST_3R("asub_s.d", 144,   0, w18, w3,  w27);
   TEST_3R("asub_s.d", 152, 160, w19, w12, w26);
   TEST_3R("asub_s.d", 160, 104, w20, w19, w11);
   TEST_3R("asub_s.d", 168,  40, w21, w1,  w31);
   TEST_3R("asub_s.d", 176, 112, w22, w2,  w12);
   TEST_3R("asub_s.d", 184,   0, w23, w22, w22);
   TEST_3R("asub_s.d", 192, 176, w24, w31, w23);
   TEST_3R("asub_s.d", 200, 152, w25, w30, w13);
   TEST_3R("asub_s.d", 208, 120, w26, w2,  w7);
   TEST_3R("asub_s.d", 216, 224, w27, w11, w27);
   TEST_3R("asub_s.d", 224,  96, w28, w0,  w20);
   TEST_3R("asub_s.d", 232,  72, w29, w29, w29);
   TEST_3R("asub_s.d", 240,  64, w30, w22, w16);
   TEST_3R("asub_s.d", 112,  48, w31, w23, w4);
   TEST_3R("asub_u.b",   0,   8, w0,  w0,  w20);
   TEST_3R("asub_u.b",   8,  32, w1,  w17, w19);
   TEST_3R("asub_u.b",  16, 144, w2,  w22, w18);
   TEST_3R("asub_u.b",  24,  48, w3,  w20, w27);
   TEST_3R("asub_u.b",  32,  48, w4,  w14, w28);
   TEST_3R("asub_u.b",  40, 208, w5,  w5,  w5);
   TEST_3R("asub_u.b",  48, 184, w6,  w0,  w28);
   TEST_3R("asub_u.b",  56,  64, w7,  w16, w7);
   TEST_3R("asub_u.b",  64, 224, w8,  w16, w20);
   TEST_3R("asub_u.b",  72,  80, w9,  w5,  w25);
   TEST_3R("asub_u.b",  80, 184, w10, w5,  w0);
   TEST_3R("asub_u.b",  88, 168, w11, w25, w29);
   TEST_3R("asub_u.b",  96,   0, w12, w13, w13);
   TEST_3R("asub_u.b", 104, 144, w13, w5,  w31);
   TEST_3R("asub_u.b", 112,  48, w14, w26, w19);
   TEST_3R("asub_u.b", 120, 160, w15, w21, w19);
   TEST_3R("asub_u.b", 128, 136, w16, w17, w20);
   TEST_3R("asub_u.b", 136, 176, w17, w16, w2);
   TEST_3R("asub_u.b", 144,  64, w18, w1,  w22);
   TEST_3R("asub_u.b", 152, 144, w19, w23, w16);
   TEST_3R("asub_u.b", 160, 208, w20, w29, w16);
   TEST_3R("asub_u.b", 168,  16, w21, w22, w14);
   TEST_3R("asub_u.b", 176, 232, w22, w3,  w0);
   TEST_3R("asub_u.b", 184, 160, w23, w2,  w19);
   TEST_3R("asub_u.b", 192, 136, w24, w21, w10);
   TEST_3R("asub_u.b", 200,  24, w25, w9,  w16);
   TEST_3R("asub_u.b", 208,  40, w26, w29, w24);
   TEST_3R("asub_u.b", 216,  88, w27, w13, w26);
   TEST_3R("asub_u.b", 224, 208, w28, w14, w13);
   TEST_3R("asub_u.b", 232,  96, w29, w2,  w4);
   TEST_3R("asub_u.b", 240, 176, w30, w9,  w1);
   TEST_3R("asub_u.b",  16, 224, w31, w14, w24);
   TEST_3R("asub_u.h",   0, 144, w0,  w0,  w27);
   TEST_3R("asub_u.h",   8, 208, w1,  w28, w30);
   TEST_3R("asub_u.h",  16, 208, w2,  w16, w19);
   TEST_3R("asub_u.h",  24, 128, w3,  w26, w28);
   TEST_3R("asub_u.h",  32,  56, w4,  w21, w25);
   TEST_3R("asub_u.h",  40,   0, w5,  w5,  w5);
   TEST_3R("asub_u.h",  48, 224, w6,  w20, w16);
   TEST_3R("asub_u.h",  56,  64, w7,  w1,  w7);
   TEST_3R("asub_u.h",  64,  40, w8,  w23, w6);
   TEST_3R("asub_u.h",  72,  88, w9,  w0,  w7);
   TEST_3R("asub_u.h",  80, 192, w10, w14, w31);
   TEST_3R("asub_u.h",  88,  96, w11, w17, w27);
   TEST_3R("asub_u.h",  96, 184, w12, w13, w13);
   TEST_3R("asub_u.h", 104,  88, w13, w29, w30);
   TEST_3R("asub_u.h", 112,  72, w14, w15, w24);
   TEST_3R("asub_u.h", 120,  16, w15, w16, w13);
   TEST_3R("asub_u.h", 128, 184, w16, w10, w14);
   TEST_3R("asub_u.h", 136, 168, w17, w31, w30);
   TEST_3R("asub_u.h", 144,  32, w18, w0,  w19);
   TEST_3R("asub_u.h", 152,  48, w19, w6,  w29);
   TEST_3R("asub_u.h", 160, 176, w20, w14, w13);
   TEST_3R("asub_u.h", 168, 192, w21, w13, w16);
   TEST_3R("asub_u.h", 176, 224, w22, w8,  w6);
   TEST_3R("asub_u.h", 184, 176, w23, w1,  w4);
   TEST_3R("asub_u.h", 192,  56, w24, w14, w19);
   TEST_3R("asub_u.h", 200,  16, w25, w23, w3);
   TEST_3R("asub_u.h", 208, 224, w26, w25, w14);
   TEST_3R("asub_u.h", 216, 160, w27, w2,  w13);
   TEST_3R("asub_u.h", 224,  32, w28, w0,  w13);
   TEST_3R("asub_u.h", 232,  64, w29, w22, w20);
   TEST_3R("asub_u.h", 240,  64, w30, w12, w2);
   TEST_3R("asub_u.h",  64,  16, w31, w16, w15);
   TEST_3R("asub_u.w",   0, 176, w0,  w0,  w24);
   TEST_3R("asub_u.w",   8,  56, w1,  w9,  w25);
   TEST_3R("asub_u.w",  16,  72, w2,  w10, w7);
   TEST_3R("asub_u.w",  24,  56, w3,  w30, w2);
   TEST_3R("asub_u.w",  32,  40, w4,  w24, w16);
   TEST_3R("asub_u.w",  40,  24, w5,  w5,  w5);
   TEST_3R("asub_u.w",  48, 120, w6,  w29, w16);
   TEST_3R("asub_u.w",  56, 224, w7,  w10, w7);
   TEST_3R("asub_u.w",  64, 168, w8,  w17, w30);
   TEST_3R("asub_u.w",  72, 232, w9,  w29, w0);
   TEST_3R("asub_u.w",  80, 120, w10, w13, w16);
   TEST_3R("asub_u.w",  88,  64, w11, w19, w8);
   TEST_3R("asub_u.w",  96, 160, w12, w28, w28);
   TEST_3R("asub_u.w", 104, 184, w13, w0,  w6);
   TEST_3R("asub_u.w", 112, 176, w14, w30, w9);
   TEST_3R("asub_u.w", 120, 152, w15, w0,  w18);
   TEST_3R("asub_u.w", 128, 224, w16, w26, w13);
   TEST_3R("asub_u.w", 136, 208, w17, w21, w24);
   TEST_3R("asub_u.w", 144,  16, w18, w6,  w22);
   TEST_3R("asub_u.w", 152, 120, w19, w3,  w23);
   TEST_3R("asub_u.w", 160,   8, w20, w16, w7);
   TEST_3R("asub_u.w", 168,  80, w21, w4,  w15);
   TEST_3R("asub_u.w", 176,  80, w22, w0,  w16);
   TEST_3R("asub_u.w", 184,  40, w23, w7,  w25);
   TEST_3R("asub_u.w", 192,   8, w24, w16, w1);
   TEST_3R("asub_u.w", 200,  24, w25, w3,  w0);
   TEST_3R("asub_u.w", 208,  64, w26, w19, w29);
   TEST_3R("asub_u.w", 216,  40, w27, w15, w21);
   TEST_3R("asub_u.w", 224, 168, w28, w21, w11);
   TEST_3R("asub_u.w", 232,  56, w29, w24, w2);
   TEST_3R("asub_u.w", 240, 120, w30, w9,  w7);
   TEST_3R("asub_u.w", 104, 104, w31, w24, w7);
   TEST_3R("asub_u.d",   0, 112, w0,  w0,  w7);
   TEST_3R("asub_u.d",   8, 176, w1,  w2,  w6);
   TEST_3R("asub_u.d",  16, 232, w2,  w3,  w5);
   TEST_3R("asub_u.d",  24,  72, w3,  w4,  w20);
   TEST_3R("asub_u.d",  32, 136, w4,  w30, w17);
   TEST_3R("asub_u.d",  40, 104, w5,  w5,  w5);
   TEST_3R("asub_u.d",  48,  96, w6,  w25, w3);
   TEST_3R("asub_u.d",  56, 232, w7,  w23, w7);
   TEST_3R("asub_u.d",  64, 176, w8,  w20, w19);
   TEST_3R("asub_u.d",  72, 176, w9,  w30, w26);
   TEST_3R("asub_u.d",  80, 152, w10, w22, w2);
   TEST_3R("asub_u.d",  88,  32, w11, w31, w9);
   TEST_3R("asub_u.d",  96, 136, w12, w2,  w2);
   TEST_3R("asub_u.d", 104, 176, w13, w25, w5);
   TEST_3R("asub_u.d", 112, 120, w14, w1,  w9);
   TEST_3R("asub_u.d", 120, 200, w15, w28, w8);
   TEST_3R("asub_u.d", 128, 224, w16, w10, w22);
   TEST_3R("asub_u.d", 136, 192, w17, w4,  w25);
   TEST_3R("asub_u.d", 144,  64, w18, w27, w21);
   TEST_3R("asub_u.d", 152, 144, w19, w14, w26);
   TEST_3R("asub_u.d", 160,  56, w20, w8,  w12);
   TEST_3R("asub_u.d", 168, 184, w21, w10, w12);
   TEST_3R("asub_u.d", 176,  24, w22, w20, w0);
   TEST_3R("asub_u.d", 184,  96, w23, w3,  w25);
   TEST_3R("asub_u.d", 192,  96, w24, w26, w12);
   TEST_3R("asub_u.d", 200,  56, w25, w22, w20);
   TEST_3R("asub_u.d", 208, 152, w26, w0,  w10);
   TEST_3R("asub_u.d", 216, 136, w27, w4,  w15);
   TEST_3R("asub_u.d", 224,  40, w28, w25, w23);
   TEST_3R("asub_u.d", 232, 176, w29, w20, w28);
   TEST_3R("asub_u.d", 240, 208, w30, w0,  w24);
   TEST_3R("asub_u.d", 120, 112, w31, w12, w20);
   TEST_3R("ave_s.b",   0, 144, w0,  w16, w31);
   TEST_3R("ave_s.b",   8, 128, w1,  w17, w21);
   TEST_3R("ave_s.b",  16, 128, w2,  w12, w22);
   TEST_3R("ave_s.b",  24, 128, w3,  w9,  w26);
   TEST_3R("ave_s.b",  32, 120, w4,  w24, w26);
   TEST_3R("ave_s.b",  40,  48, w5,  w15, w5);
   TEST_3R("ave_s.b",  48, 232, w6,  w17, w12);
   TEST_3R("ave_s.b",  56,  72, w7,  w18, w4);
   TEST_3R("ave_s.b",  64, 192, w8,  w30, w24);
   TEST_3R("ave_s.b",  72, 104, w9,  w11, w10);
   TEST_3R("ave_s.b",  80, 120, w10, w16, w30);
   TEST_3R("ave_s.b",  88, 232, w11, w16, w31);
   TEST_3R("ave_s.b",  96,  40, w12, w5,  w21);
   TEST_3R("ave_s.b", 104,   0, w13, w27, w21);
   TEST_3R("ave_s.b", 112, 184, w14, w22, w25);
   TEST_3R("ave_s.b", 120,  56, w15, w16, w22);
   TEST_3R("ave_s.b", 128, 112, w16, w23, w8);
   TEST_3R("ave_s.b", 136, 160, w17, w17, w17);
   TEST_3R("ave_s.b", 144,   0, w18, w26, w25);
   TEST_3R("ave_s.b", 152,  64, w19, w24, w18);
   TEST_3R("ave_s.b", 160, 184, w20, w3,  w3);
   TEST_3R("ave_s.b", 168, 120, w21, w16, w20);
   TEST_3R("ave_s.b", 176, 200, w22, w10, w4);
   TEST_3R("ave_s.b", 184,  40, w23, w22, w9);
   TEST_3R("ave_s.b", 192,  16, w24, w24, w14);
   TEST_3R("ave_s.b", 200,   8, w25, w4,  w15);
   TEST_3R("ave_s.b", 208, 136, w26, w29, w8);
   TEST_3R("ave_s.b", 216,  64, w27, w19, w17);
   TEST_3R("ave_s.b", 224, 224, w28, w27, w6);
   TEST_3R("ave_s.b", 232, 232, w29, w21, w0);
   TEST_3R("ave_s.b", 240,  64, w30, w14, w18);
   TEST_3R("ave_s.b", 128, 112, w31, w17, w14);
   TEST_3R("ave_s.h",   0, 200, w0,  w8,  w10);
   TEST_3R("ave_s.h",   8,  96, w1,  w2,  w0);
   TEST_3R("ave_s.h",  16, 232, w2,  w17, w14);
   TEST_3R("ave_s.h",  24,   0, w3,  w21, w29);
   TEST_3R("ave_s.h",  32,   8, w4,  w18, w6);
   TEST_3R("ave_s.h",  40,  64, w5,  w6,  w5);
   TEST_3R("ave_s.h",  48,   8, w6,  w0,  w1);
   TEST_3R("ave_s.h",  56,   8, w7,  w24, w23);
   TEST_3R("ave_s.h",  64, 208, w8,  w2,  w5);
   TEST_3R("ave_s.h",  72, 104, w9,  w18, w22);
   TEST_3R("ave_s.h",  80, 112, w10, w18, w28);
   TEST_3R("ave_s.h",  88, 216, w11, w29, w5);
   TEST_3R("ave_s.h",  96, 104, w12, w29, w24);
   TEST_3R("ave_s.h", 104,  16, w13, w12, w16);
   TEST_3R("ave_s.h", 112, 144, w14, w9,  w3);
   TEST_3R("ave_s.h", 120,  96, w15, w1,  w8);
   TEST_3R("ave_s.h", 128, 224, w16, w2,  w10);
   TEST_3R("ave_s.h", 136, 216, w17, w17, w17);
   TEST_3R("ave_s.h", 144, 152, w18, w1,  w3);
   TEST_3R("ave_s.h", 152, 184, w19, w6,  w15);
   TEST_3R("ave_s.h", 160, 144, w20, w17, w17);
   TEST_3R("ave_s.h", 168, 168, w21, w24, w23);
   TEST_3R("ave_s.h", 176, 168, w22, w30, w0);
   TEST_3R("ave_s.h", 184,  88, w23, w22, w27);
   TEST_3R("ave_s.h", 192,  24, w24, w24, w7);
   TEST_3R("ave_s.h", 200, 168, w25, w17, w10);
   TEST_3R("ave_s.h", 208, 160, w26, w1,  w12);
   TEST_3R("ave_s.h", 216, 144, w27, w8,  w14);
   TEST_3R("ave_s.h", 224,  80, w28, w13, w8);
   TEST_3R("ave_s.h", 232, 144, w29, w16, w4);
   TEST_3R("ave_s.h", 240, 208, w30, w3,  w19);
   TEST_3R("ave_s.h",  40, 168, w31, w20, w21);
   TEST_3R("ave_s.w",   0, 184, w0,  w19, w26);
   TEST_3R("ave_s.w",   8,  80, w1,  w15, w16);
   TEST_3R("ave_s.w",  16, 168, w2,  w23, w18);
   TEST_3R("ave_s.w",  24, 184, w3,  w2,  w31);
   TEST_3R("ave_s.w",  32, 176, w4,  w14, w21);
   TEST_3R("ave_s.w",  40, 208, w5,  w28, w5);
   TEST_3R("ave_s.w",  48,  48, w6,  w31, w4);
   TEST_3R("ave_s.w",  56,  72, w7,  w15, w8);
   TEST_3R("ave_s.w",  64,  48, w8,  w18, w28);
   TEST_3R("ave_s.w",  72,  88, w9,  w6,  w17);
   TEST_3R("ave_s.w",  80,  64, w10, w17, w4);
   TEST_3R("ave_s.w",  88,  16, w11, w29, w20);
   TEST_3R("ave_s.w",  96,  24, w12, w4,  w11);
   TEST_3R("ave_s.w", 104, 128, w13, w22, w20);
   TEST_3R("ave_s.w", 112, 152, w14, w22, w30);
   TEST_3R("ave_s.w", 120, 120, w15, w11, w16);
   TEST_3R("ave_s.w", 128,   8, w16, w1,  w15);
   TEST_3R("ave_s.w", 136, 192, w17, w17, w17);
   TEST_3R("ave_s.w", 144,  32, w18, w30, w23);
   TEST_3R("ave_s.w", 152, 128, w19, w16, w22);
   TEST_3R("ave_s.w", 160, 176, w20, w4,  w4);
   TEST_3R("ave_s.w", 168, 120, w21, w8,  w9);
   TEST_3R("ave_s.w", 176, 144, w22, w5,  w29);
   TEST_3R("ave_s.w", 184,  48, w23, w10, w8);
   TEST_3R("ave_s.w", 192, 232, w24, w24, w0);
   TEST_3R("ave_s.w", 200, 216, w25, w17, w22);
   TEST_3R("ave_s.w", 208, 136, w26, w0,  w2);
   TEST_3R("ave_s.w", 216,  88, w27, w11, w3);
   TEST_3R("ave_s.w", 224, 152, w28, w26, w18);
   TEST_3R("ave_s.w", 232,   0, w29, w10, w5);
   TEST_3R("ave_s.w", 240,  56, w30, w1,  w10);
   TEST_3R("ave_s.w",  40, 176, w31, w9,  w19);
   TEST_3R("ave_s.d",   0, 200, w0,  w16, w20);
   TEST_3R("ave_s.d",   8, 184, w1,  w24, w4);
   TEST_3R("ave_s.d",  16,  24, w2,  w21, w22);
   TEST_3R("ave_s.d",  24,  48, w3,  w17, w22);
   TEST_3R("ave_s.d",  32,  96, w4,  w29, w2);
   TEST_3R("ave_s.d",  40,  72, w5,  w24, w5);
   TEST_3R("ave_s.d",  48, 120, w6,  w15, w18);
   TEST_3R("ave_s.d",  56,  64, w7,  w30, w29);
   TEST_3R("ave_s.d",  64, 168, w8,  w4,  w30);
   TEST_3R("ave_s.d",  72, 176, w9,  w28, w7);
   TEST_3R("ave_s.d",  80,  16, w10, w31, w21);
   TEST_3R("ave_s.d",  88,  40, w11, w19, w14);
   TEST_3R("ave_s.d",  96, 184, w12, w23, w7);
   TEST_3R("ave_s.d", 104,  16, w13, w22, w0);
   TEST_3R("ave_s.d", 112, 224, w14, w8,  w29);
   TEST_3R("ave_s.d", 120,  64, w15, w28, w21);
   TEST_3R("ave_s.d", 128,  64, w16, w11, w8);
   TEST_3R("ave_s.d", 136,   8, w17, w17, w17);
   TEST_3R("ave_s.d", 144,  32, w18, w5,  w14);
   TEST_3R("ave_s.d", 152, 168, w19, w3,  w10);
   TEST_3R("ave_s.d", 160,  88, w20, w9,  w9);
   TEST_3R("ave_s.d", 168, 152, w21, w28, w13);
   TEST_3R("ave_s.d", 176,  16, w22, w20, w29);
   TEST_3R("ave_s.d", 184, 144, w23, w11, w29);
   TEST_3R("ave_s.d", 192, 136, w24, w24, w19);
   TEST_3R("ave_s.d", 200, 208, w25, w11, w15);
   TEST_3R("ave_s.d", 208,  56, w26, w14, w27);
   TEST_3R("ave_s.d", 216, 152, w27, w31, w5);
   TEST_3R("ave_s.d", 224, 192, w28, w4,  w19);
   TEST_3R("ave_s.d", 232,  72, w29, w7,  w10);
   TEST_3R("ave_s.d", 240, 192, w30, w7,  w9);
   TEST_3R("ave_s.d",   0, 104, w31, w3,  w23);
   TEST_3R("ave_u.b",   0, 136, w0,  w25, w30);
   TEST_3R("ave_u.b",   8, 216, w1,  w20, w10);
   TEST_3R("ave_u.b",  16, 160, w2,  w4,  w24);
   TEST_3R("ave_u.b",  24, 232, w3,  w28, w23);
   TEST_3R("ave_u.b",  32, 200, w4,  w25, w27);
   TEST_3R("ave_u.b",  40,  40, w5,  w25, w2);
   TEST_3R("ave_u.b",  48, 208, w6,  w3,  w29);
   TEST_3R("ave_u.b",  56,  80, w7,  w12, w13);
   TEST_3R("ave_u.b",  64, 200, w8,  w3,  w11);
   TEST_3R("ave_u.b",  72,  96, w9,  w15, w7);
   TEST_3R("ave_u.b",  80,  16, w10, w5,  w1);
   TEST_3R("ave_u.b",  88, 136, w11, w11, w11);
   TEST_3R("ave_u.b",  96, 120, w12, w21, w13);
   TEST_3R("ave_u.b", 104, 152, w13, w25, w5);
   TEST_3R("ave_u.b", 112,  16, w14, w21, w28);
   TEST_3R("ave_u.b", 120, 224, w15, w14, w23);
   TEST_3R("ave_u.b", 128, 136, w16, w7,  w25);
   TEST_3R("ave_u.b", 136, 104, w17, w10, w22);
   TEST_3R("ave_u.b", 144,  56, w18, w22, w3);
   TEST_3R("ave_u.b", 152,  24, w19, w26, w14);
   TEST_3R("ave_u.b", 160, 232, w20, w9,  w22);
   TEST_3R("ave_u.b", 168,  16, w21, w14, w23);
   TEST_3R("ave_u.b", 176,  72, w22, w29, w29);
   TEST_3R("ave_u.b", 184, 208, w23, w15, w5);
   TEST_3R("ave_u.b", 192,  40, w24, w20, w1);
   TEST_3R("ave_u.b", 200, 176, w25, w16, w25);
   TEST_3R("ave_u.b", 208, 160, w26, w8,  w7);
   TEST_3R("ave_u.b", 216,  64, w27, w15, w0);
   TEST_3R("ave_u.b", 224, 224, w28, w28, w25);
   TEST_3R("ave_u.b", 232, 104, w29, w15, w25);
   TEST_3R("ave_u.b", 240, 128, w30, w9,  w7);
   TEST_3R("ave_u.b",  32,   0, w31, w18, w29);
   TEST_3R("ave_u.h",   0,  40, w0,  w20, w7);
   TEST_3R("ave_u.h",   8, 160, w1,  w0,  w22);
   TEST_3R("ave_u.h",  16,  80, w2,  w5,  w10);
   TEST_3R("ave_u.h",  24, 136, w3,  w31, w26);
   TEST_3R("ave_u.h",  32, 176, w4,  w7,  w1);
   TEST_3R("ave_u.h",  40, 112, w5,  w22, w1);
   TEST_3R("ave_u.h",  48, 160, w6,  w15, w23);
   TEST_3R("ave_u.h",  56,  24, w7,  w31, w16);
   TEST_3R("ave_u.h",  64,  40, w8,  w24, w5);
   TEST_3R("ave_u.h",  72, 184, w9,  w21, w10);
   TEST_3R("ave_u.h",  80,  40, w10, w18, w26);
   TEST_3R("ave_u.h",  88, 168, w11, w11, w11);
   TEST_3R("ave_u.h",  96,  96, w12, w30, w16);
   TEST_3R("ave_u.h", 104, 200, w13, w4,  w15);
   TEST_3R("ave_u.h", 112, 184, w14, w0,  w23);
   TEST_3R("ave_u.h", 120, 128, w15, w19, w13);
   TEST_3R("ave_u.h", 128, 168, w16, w9,  w29);
   TEST_3R("ave_u.h", 136,  24, w17, w27, w28);
   TEST_3R("ave_u.h", 144,  16, w18, w26, w4);
   TEST_3R("ave_u.h", 152,  72, w19, w31, w6);
   TEST_3R("ave_u.h", 160,   8, w20, w27, w16);
   TEST_3R("ave_u.h", 168, 176, w21, w22, w26);
   TEST_3R("ave_u.h", 176,  40, w22, w20, w20);
   TEST_3R("ave_u.h", 184, 112, w23, w24, w26);
   TEST_3R("ave_u.h", 192,  24, w24, w17, w19);
   TEST_3R("ave_u.h", 200, 176, w25, w30, w25);
   TEST_3R("ave_u.h", 208, 104, w26, w21, w27);
   TEST_3R("ave_u.h", 216,   0, w27, w16, w23);
   TEST_3R("ave_u.h", 224,  56, w28, w28, w10);
   TEST_3R("ave_u.h", 232,  56, w29, w21, w9);
   TEST_3R("ave_u.h", 240, 128, w30, w27, w19);
   TEST_3R("ave_u.h",  80, 184, w31, w11, w14);
   TEST_3R("ave_u.w",   0, 128, w0,  w18, w1);
   TEST_3R("ave_u.w",   8, 104, w1,  w9,  w26);
   TEST_3R("ave_u.w",  16, 184, w2,  w14, w18);
   TEST_3R("ave_u.w",  24,  40, w3,  w1,  w30);
   TEST_3R("ave_u.w",  32,  48, w4,  w5,  w19);
   TEST_3R("ave_u.w",  40, 136, w5,  w17, w4);
   TEST_3R("ave_u.w",  48, 200, w6,  w22, w14);
   TEST_3R("ave_u.w",  56,  16, w7,  w11, w24);
   TEST_3R("ave_u.w",  64,  24, w8,  w6,  w11);
   TEST_3R("ave_u.w",  72, 216, w9,  w17, w25);
   TEST_3R("ave_u.w",  80, 120, w10, w22, w12);
   TEST_3R("ave_u.w",  88, 208, w11, w11, w11);
   TEST_3R("ave_u.w",  96,  80, w12, w21, w3);
   TEST_3R("ave_u.w", 104, 136, w13, w3,  w22);
   TEST_3R("ave_u.w", 112, 176, w14, w5,  w20);
   TEST_3R("ave_u.w", 120, 104, w15, w10, w8);
   TEST_3R("ave_u.w", 128,   0, w16, w28, w12);
   TEST_3R("ave_u.w", 136,  72, w17, w18, w26);
   TEST_3R("ave_u.w", 144,  64, w18, w29, w19);
   TEST_3R("ave_u.w", 152,  64, w19, w29, w14);
   TEST_3R("ave_u.w", 160, 152, w20, w23, w22);
   TEST_3R("ave_u.w", 168,   0, w21, w3,  w31);
   TEST_3R("ave_u.w", 176, 176, w22, w24, w24);
   TEST_3R("ave_u.w", 184, 104, w23, w1,  w28);
   TEST_3R("ave_u.w", 192, 104, w24, w13, w1);
   TEST_3R("ave_u.w", 200,  40, w25, w18, w25);
   TEST_3R("ave_u.w", 208,  80, w26, w21, w12);
   TEST_3R("ave_u.w", 216,  24, w27, w1,  w18);
   TEST_3R("ave_u.w", 224,  80, w28, w28, w1);
   TEST_3R("ave_u.w", 232, 152, w29, w14, w20);
   TEST_3R("ave_u.w", 240,  88, w30, w12, w2);
   TEST_3R("ave_u.w",  16, 120, w31, w3,  w24);
   TEST_3R("ave_u.d",   0, 120, w0,  w24, w9);
   TEST_3R("ave_u.d",   8,  72, w1,  w27, w10);
   TEST_3R("ave_u.d",  16,  56, w2,  w20, w23);
   TEST_3R("ave_u.d",  24, 208, w3,  w1,  w9);
   TEST_3R("ave_u.d",  32,  56, w4,  w23, w21);
   TEST_3R("ave_u.d",  40, 200, w5,  w24, w8);
   TEST_3R("ave_u.d",  48,  40, w6,  w20, w9);
   TEST_3R("ave_u.d",  56,  72, w7,  w3,  w30);
   TEST_3R("ave_u.d",  64, 160, w8,  w15, w0);
   TEST_3R("ave_u.d",  72, 152, w9,  w18, w25);
   TEST_3R("ave_u.d",  80,  32, w10, w24, w17);
   TEST_3R("ave_u.d",  88,  80, w11, w11, w11);
   TEST_3R("ave_u.d",  96, 152, w12, w17, w0);
   TEST_3R("ave_u.d", 104, 224, w13, w12, w1);
   TEST_3R("ave_u.d", 112,  80, w14, w19, w24);
   TEST_3R("ave_u.d", 120,  72, w15, w2,  w17);
   TEST_3R("ave_u.d", 128,  56, w16, w10, w5);
   TEST_3R("ave_u.d", 136,  80, w17, w8,  w23);
   TEST_3R("ave_u.d", 144,  24, w18, w23, w6);
   TEST_3R("ave_u.d", 152, 224, w19, w16, w3);
   TEST_3R("ave_u.d", 160,  72, w20, w1,  w10);
   TEST_3R("ave_u.d", 168, 104, w21, w13, w27);
   TEST_3R("ave_u.d", 176,  64, w22, w13, w13);
   TEST_3R("ave_u.d", 184,  48, w23, w21, w15);
   TEST_3R("ave_u.d", 192,   8, w24, w9,  w7);
   TEST_3R("ave_u.d", 200, 216, w25, w11, w25);
   TEST_3R("ave_u.d", 208, 200, w26, w12, w21);
   TEST_3R("ave_u.d", 216,  64, w27, w5,  w29);
   TEST_3R("ave_u.d", 224,  24, w28, w28, w30);
   TEST_3R("ave_u.d", 232, 160, w29, w20, w4);
   TEST_3R("ave_u.d", 240, 152, w30, w4,  w7);
   TEST_3R("ave_u.d", 208,  96, w31, w6,  w17);
   TEST_3R("aver_s.b",   0, 144, w0,  w31, w16);
   TEST_3R("aver_s.b",   8,  32, w1,  w8,  w1);
   TEST_3R("aver_s.b",  16, 232, w2,  w19, w16);
   TEST_3R("aver_s.b",  24,  16, w3,  w8,  w14);
   TEST_3R("aver_s.b",  32,  16, w4,  w6,  w20);
   TEST_3R("aver_s.b",  40, 208, w5,  w4,  w18);
   TEST_3R("aver_s.b",  48, 232, w6,  w8,  w26);
   TEST_3R("aver_s.b",  56,  40, w7,  w15, w3);
   TEST_3R("aver_s.b",  64,  16, w8,  w1,  w4);
   TEST_3R("aver_s.b",  72,  32, w9,  w13, w14);
   TEST_3R("aver_s.b",  80,  88, w10, w10, w29);
   TEST_3R("aver_s.b",  88,   0, w11, w20, w3);
   TEST_3R("aver_s.b",  96, 136, w12, w12, w12);
   TEST_3R("aver_s.b", 104,  24, w13, w5,  w9);
   TEST_3R("aver_s.b", 112, 120, w14, w20, w18);
   TEST_3R("aver_s.b", 120,  40, w15, w9,  w24);
   TEST_3R("aver_s.b", 128,  88, w16, w26, w26);
   TEST_3R("aver_s.b", 136, 160, w17, w16, w31);
   TEST_3R("aver_s.b", 144, 176, w18, w10, w8);
   TEST_3R("aver_s.b", 152, 192, w19, w13, w24);
   TEST_3R("aver_s.b", 160,   0, w20, w17, w27);
   TEST_3R("aver_s.b", 168, 144, w21, w31, w13);
   TEST_3R("aver_s.b", 176, 152, w22, w2,  w3);
   TEST_3R("aver_s.b", 184, 184, w23, w8,  w12);
   TEST_3R("aver_s.b", 192,  64, w24, w28, w30);
   TEST_3R("aver_s.b", 200, 112, w25, w5,  w22);
   TEST_3R("aver_s.b", 208, 224, w26, w31, w18);
   TEST_3R("aver_s.b", 216,  88, w27, w30, w22);
   TEST_3R("aver_s.b", 224, 104, w28, w7,  w10);
   TEST_3R("aver_s.b", 232, 104, w29, w31, w30);
   TEST_3R("aver_s.b", 240, 184, w30, w26, w0);
   TEST_3R("aver_s.b",  24, 120, w31, w25, w0);
   TEST_3R("aver_s.h",   0, 184, w0,  w2,  w11);
   TEST_3R("aver_s.h",   8,  32, w1,  w10, w1);
   TEST_3R("aver_s.h",  16, 208, w2,  w4,  w7);
   TEST_3R("aver_s.h",  24,  72, w3,  w8,  w12);
   TEST_3R("aver_s.h",  32,  24, w4,  w9,  w12);
   TEST_3R("aver_s.h",  40,  16, w5,  w27, w10);
   TEST_3R("aver_s.h",  48,  72, w6,  w24, w17);
   TEST_3R("aver_s.h",  56,  72, w7,  w2,  w16);
   TEST_3R("aver_s.h",  64,  72, w8,  w29, w10);
   TEST_3R("aver_s.h",  72, 232, w9,  w24, w3);
   TEST_3R("aver_s.h",  80, 104, w10, w10, w0);
   TEST_3R("aver_s.h",  88, 152, w11, w1,  w26);
   TEST_3R("aver_s.h",  96, 128, w12, w12, w12);
   TEST_3R("aver_s.h", 104, 216, w13, w30, w18);
   TEST_3R("aver_s.h", 112,  48, w14, w6,  w31);
   TEST_3R("aver_s.h", 120, 192, w15, w16, w11);
   TEST_3R("aver_s.h", 128,  16, w16, w11, w11);
   TEST_3R("aver_s.h", 136,  96, w17, w26, w3);
   TEST_3R("aver_s.h", 144, 112, w18, w25, w5);
   TEST_3R("aver_s.h", 152, 208, w19, w23, w3);
   TEST_3R("aver_s.h", 160, 160, w20, w22, w27);
   TEST_3R("aver_s.h", 168,  32, w21, w20, w28);
   TEST_3R("aver_s.h", 176,  72, w22, w21, w7);
   TEST_3R("aver_s.h", 184, 120, w23, w1,  w10);
   TEST_3R("aver_s.h", 192, 112, w24, w19, w3);
   TEST_3R("aver_s.h", 200,  32, w25, w18, w9);
   TEST_3R("aver_s.h", 208, 104, w26, w29, w13);
   TEST_3R("aver_s.h", 216, 176, w27, w19, w7);
   TEST_3R("aver_s.h", 224, 120, w28, w26, w1);
   TEST_3R("aver_s.h", 232,  24, w29, w17, w24);
   TEST_3R("aver_s.h", 240,  80, w30, w19, w14);
   TEST_3R("aver_s.h",   8, 176, w31, w25, w3);
   TEST_3R("aver_s.w",   0,  88, w0,  w24, w26);
   TEST_3R("aver_s.w",   8, 176, w1,  w25, w1);
   TEST_3R("aver_s.w",  16,  88, w2,  w10, w13);
   TEST_3R("aver_s.w",  24, 176, w3,  w30, w31);
   TEST_3R("aver_s.w",  32, 200, w4,  w2,  w29);
   TEST_3R("aver_s.w",  40, 208, w5,  w18, w16);
   TEST_3R("aver_s.w",  48, 144, w6,  w5,  w10);
   TEST_3R("aver_s.w",  56, 208, w7,  w29, w27);
   TEST_3R("aver_s.w",  64, 216, w8,  w25, w15);
   TEST_3R("aver_s.w",  72,  64, w9,  w16, w8);
   TEST_3R("aver_s.w",  80, 128, w10, w10, w3);
   TEST_3R("aver_s.w",  88, 224, w11, w10, w29);
   TEST_3R("aver_s.w",  96, 192, w12, w12, w12);
   TEST_3R("aver_s.w", 104,  16, w13, w2,  w29);
   TEST_3R("aver_s.w", 112, 176, w14, w11, w28);
   TEST_3R("aver_s.w", 120,  72, w15, w28, w30);
   TEST_3R("aver_s.w", 128,   0, w16, w27, w27);
   TEST_3R("aver_s.w", 136, 144, w17, w29, w2);
   TEST_3R("aver_s.w", 144, 176, w18, w7,  w9);
   TEST_3R("aver_s.w", 152, 232, w19, w2,  w9);
   TEST_3R("aver_s.w", 160,   8, w20, w17, w24);
   TEST_3R("aver_s.w", 168,  72, w21, w25, w9);
   TEST_3R("aver_s.w", 176,  24, w22, w15, w19);
   TEST_3R("aver_s.w", 184, 128, w23, w2,  w31);
   TEST_3R("aver_s.w", 192, 152, w24, w7,  w10);
   TEST_3R("aver_s.w", 200,  56, w25, w23, w6);
   TEST_3R("aver_s.w", 208, 168, w26, w4,  w2);
   TEST_3R("aver_s.w", 216,  80, w27, w1,  w4);
   TEST_3R("aver_s.w", 224,  16, w28, w8,  w13);
   TEST_3R("aver_s.w", 232, 120, w29, w11, w23);
   TEST_3R("aver_s.w", 240, 136, w30, w28, w15);
   TEST_3R("aver_s.w",   0, 216, w31, w22, w24);
   TEST_3R("aver_s.d",   0, 184, w0,  w12, w23);
   TEST_3R("aver_s.d",   8,  16, w1,  w3,  w1);
   TEST_3R("aver_s.d",  16,  16, w2,  w8,  w10);
   TEST_3R("aver_s.d",  24, 144, w3,  w4,  w2);
   TEST_3R("aver_s.d",  32,  24, w4,  w30, w6);
   TEST_3R("aver_s.d",  40,  88, w5,  w9,  w8);
   TEST_3R("aver_s.d",  48, 152, w6,  w10, w16);
   TEST_3R("aver_s.d",  56, 160, w7,  w29, w27);
   TEST_3R("aver_s.d",  64,  96, w8,  w29, w24);
   TEST_3R("aver_s.d",  72, 152, w9,  w24, w14);
   TEST_3R("aver_s.d",  80,   0, w10, w10, w19);
   TEST_3R("aver_s.d",  88,  56, w11, w4,  w10);
   TEST_3R("aver_s.d",  96, 176, w12, w12, w12);
   TEST_3R("aver_s.d", 104,   0, w13, w0,  w3);
   TEST_3R("aver_s.d", 112, 144, w14, w0,  w7);
   TEST_3R("aver_s.d", 120, 120, w15, w6,  w26);
   TEST_3R("aver_s.d", 128, 192, w16, w15, w15);
   TEST_3R("aver_s.d", 136,  16, w17, w27, w25);
   TEST_3R("aver_s.d", 144, 232, w18, w21, w23);
   TEST_3R("aver_s.d", 152, 176, w19, w6,  w20);
   TEST_3R("aver_s.d", 160, 176, w20, w6,  w12);
   TEST_3R("aver_s.d", 168,  64, w21, w31, w8);
   TEST_3R("aver_s.d", 176,   8, w22, w9,  w3);
   TEST_3R("aver_s.d", 184,   8, w23, w9,  w7);
   TEST_3R("aver_s.d", 192,  32, w24, w9,  w14);
   TEST_3R("aver_s.d", 200,   8, w25, w16, w20);
   TEST_3R("aver_s.d", 208,  72, w26, w31, w4);
   TEST_3R("aver_s.d", 216,  96, w27, w26, w29);
   TEST_3R("aver_s.d", 224, 200, w28, w16, w20);
   TEST_3R("aver_s.d", 232, 144, w29, w22, w8);
   TEST_3R("aver_s.d", 240, 200, w30, w29, w21);
   TEST_3R("aver_s.d",  40, 128, w31, w28, w20);
   TEST_3R("aver_u.b",   0, 176, w0,  w29, w7);
   TEST_3R("aver_u.b",   8,  96, w1,  w11, w24);
   TEST_3R("aver_u.b",  16, 144, w2,  w0,  w4);
   TEST_3R("aver_u.b",  24,  40, w3,  w4,  w18);
   TEST_3R("aver_u.b",  32, 168, w4,  w1,  w19);
   TEST_3R("aver_u.b",  40,  96, w5,  w22, w2);
   TEST_3R("aver_u.b",  48, 152, w6,  w30, w24);
   TEST_3R("aver_u.b",  56, 208, w7,  w19, w19);
   TEST_3R("aver_u.b",  64, 168, w8,  w26, w21);
   TEST_3R("aver_u.b",  72,  96, w9,  w6,  w11);
   TEST_3R("aver_u.b",  80, 216, w10, w13, w10);
   TEST_3R("aver_u.b",  88, 224, w11, w30, w20);
   TEST_3R("aver_u.b",  96, 200, w12, w31, w20);
   TEST_3R("aver_u.b", 104,   8, w13, w31, w24);
   TEST_3R("aver_u.b", 112, 152, w14, w26, w25);
   TEST_3R("aver_u.b", 120, 200, w15, w4,  w5);
   TEST_3R("aver_u.b", 128, 192, w16, w8,  w3);
   TEST_3R("aver_u.b", 136,  88, w17, w11, w29);
   TEST_3R("aver_u.b", 144, 120, w18, w0,  w23);
   TEST_3R("aver_u.b", 152,  56, w19, w12, w27);
   TEST_3R("aver_u.b", 160, 120, w20, w6,  w27);
   TEST_3R("aver_u.b", 168,  72, w21, w10, w27);
   TEST_3R("aver_u.b", 176, 104, w22, w22, w18);
   TEST_3R("aver_u.b", 184, 112, w23, w20, w12);
   TEST_3R("aver_u.b", 192, 184, w24, w14, w25);
   TEST_3R("aver_u.b", 200, 216, w25, w29, w9);
   TEST_3R("aver_u.b", 208, 176, w26, w11, w17);
   TEST_3R("aver_u.b", 216,   8, w27, w13, w28);
   TEST_3R("aver_u.b", 224, 184, w28, w22, w6);
   TEST_3R("aver_u.b", 232, 104, w29, w17, w3);
   TEST_3R("aver_u.b", 240, 136, w30, w30, w30);
   TEST_3R("aver_u.b",   8,   0, w31, w30, w5);
   TEST_3R("aver_u.h",   0, 224, w0,  w2,  w21);
   TEST_3R("aver_u.h",   8, 112, w1,  w22, w8);
   TEST_3R("aver_u.h",  16, 144, w2,  w27, w1);
   TEST_3R("aver_u.h",  24,   8, w3,  w4,  w0);
   TEST_3R("aver_u.h",  32,  72, w4,  w21, w2);
   TEST_3R("aver_u.h",  40,  96, w5,  w17, w1);
   TEST_3R("aver_u.h",  48,   0, w6,  w13, w24);
   TEST_3R("aver_u.h",  56, 120, w7,  w22, w22);
   TEST_3R("aver_u.h",  64, 128, w8,  w26, w19);
   TEST_3R("aver_u.h",  72,  96, w9,  w24, w4);
   TEST_3R("aver_u.h",  80, 200, w10, w26, w10);
   TEST_3R("aver_u.h",  88, 104, w11, w6,  w17);
   TEST_3R("aver_u.h",  96,   0, w12, w14, w21);
   TEST_3R("aver_u.h", 104, 136, w13, w16, w23);
   TEST_3R("aver_u.h", 112,  56, w14, w16, w5);
   TEST_3R("aver_u.h", 120, 232, w15, w18, w31);
   TEST_3R("aver_u.h", 128,  56, w16, w19, w13);
   TEST_3R("aver_u.h", 136, 176, w17, w7,  w3);
   TEST_3R("aver_u.h", 144, 176, w18, w1,  w22);
   TEST_3R("aver_u.h", 152,  72, w19, w26, w14);
   TEST_3R("aver_u.h", 160, 144, w20, w12, w9);
   TEST_3R("aver_u.h", 168,   8, w21, w18, w26);
   TEST_3R("aver_u.h", 176, 152, w22, w22, w0);
   TEST_3R("aver_u.h", 184,  32, w23, w3,  w16);
   TEST_3R("aver_u.h", 192, 168, w24, w29, w0);
   TEST_3R("aver_u.h", 200,   8, w25, w11, w18);
   TEST_3R("aver_u.h", 208,  56, w26, w11, w6);
   TEST_3R("aver_u.h", 216, 224, w27, w24, w17);
   TEST_3R("aver_u.h", 224,   0, w28, w27, w6);
   TEST_3R("aver_u.h", 232,  24, w29, w17, w31);
   TEST_3R("aver_u.h", 240, 128, w30, w30, w30);
   TEST_3R("aver_u.h", 104, 152, w31, w11, w8);
   TEST_3R("aver_u.w",   0,  88, w0,  w2,  w25);
   TEST_3R("aver_u.w",   8,  56, w1,  w18, w28);
   TEST_3R("aver_u.w",  16, 176, w2,  w25, w14);
   TEST_3R("aver_u.w",  24,  64, w3,  w5,  w1);
   TEST_3R("aver_u.w",  32, 232, w4,  w16, w7);
   TEST_3R("aver_u.w",  40, 224, w5,  w8,  w24);
   TEST_3R("aver_u.w",  48, 224, w6,  w3,  w31);
   TEST_3R("aver_u.w",  56, 232, w7,  w20, w20);
   TEST_3R("aver_u.w",  64,   0, w8,  w20, w19);
   TEST_3R("aver_u.w",  72, 152, w9,  w31, w28);
   TEST_3R("aver_u.w",  80, 184, w10, w28, w10);
   TEST_3R("aver_u.w",  88, 160, w11, w23, w25);
   TEST_3R("aver_u.w",  96,  56, w12, w20, w7);
   TEST_3R("aver_u.w", 104, 224, w13, w22, w14);
   TEST_3R("aver_u.w", 112, 208, w14, w23, w31);
   TEST_3R("aver_u.w", 120, 200, w15, w30, w11);
   TEST_3R("aver_u.w", 128, 232, w16, w22, w27);
   TEST_3R("aver_u.w", 136, 224, w17, w21, w16);
   TEST_3R("aver_u.w", 144, 224, w18, w17, w4);
   TEST_3R("aver_u.w", 152,   0, w19, w5,  w3);
   TEST_3R("aver_u.w", 160,  56, w20, w3,  w31);
   TEST_3R("aver_u.w", 168, 224, w21, w27, w25);
   TEST_3R("aver_u.w", 176, 192, w22, w22, w15);
   TEST_3R("aver_u.w", 184,  32, w23, w9,  w28);
   TEST_3R("aver_u.w", 192, 192, w24, w15, w13);
   TEST_3R("aver_u.w", 200,   0, w25, w17, w11);
   TEST_3R("aver_u.w", 208, 152, w26, w28, w2);
   TEST_3R("aver_u.w", 216,  40, w27, w9,  w23);
   TEST_3R("aver_u.w", 224, 144, w28, w11, w9);
   TEST_3R("aver_u.w", 232, 160, w29, w0,  w14);
   TEST_3R("aver_u.w", 240, 112, w30, w30, w30);
   TEST_3R("aver_u.w", 120, 176, w31, w17, w22);
   TEST_3R("aver_u.d",   0, 168, w0,  w15, w27);
   TEST_3R("aver_u.d",   8, 208, w1,  w10, w24);
   TEST_3R("aver_u.d",  16,  40, w2,  w7,  w19);
   TEST_3R("aver_u.d",  24, 152, w3,  w24, w31);
   TEST_3R("aver_u.d",  32,  72, w4,  w20, w1);
   TEST_3R("aver_u.d",  40, 232, w5,  w30, w24);
   TEST_3R("aver_u.d",  48, 136, w6,  w9,  w1);
   TEST_3R("aver_u.d",  56, 216, w7,  w9,  w9);
   TEST_3R("aver_u.d",  64, 176, w8,  w17, w26);
   TEST_3R("aver_u.d",  72, 168, w9,  w7,  w26);
   TEST_3R("aver_u.d",  80, 152, w10, w22, w10);
   TEST_3R("aver_u.d",  88, 208, w11, w9,  w6);
   TEST_3R("aver_u.d",  96, 104, w12, w1,  w7);
   TEST_3R("aver_u.d", 104, 112, w13, w31, w0);
   TEST_3R("aver_u.d", 112,  32, w14, w30, w27);
   TEST_3R("aver_u.d", 120, 224, w15, w31, w21);
   TEST_3R("aver_u.d", 128,  72, w16, w24, w29);
   TEST_3R("aver_u.d", 136, 160, w17, w25, w24);
   TEST_3R("aver_u.d", 144, 168, w18, w9,  w31);
   TEST_3R("aver_u.d", 152,  96, w19, w17, w25);
   TEST_3R("aver_u.d", 160,  72, w20, w7,  w0);
   TEST_3R("aver_u.d", 168, 104, w21, w25, w1);
   TEST_3R("aver_u.d", 176, 120, w22, w22, w0);
   TEST_3R("aver_u.d", 184, 104, w23, w25, w0);
   TEST_3R("aver_u.d", 192,   8, w24, w23, w28);
   TEST_3R("aver_u.d", 200,   0, w25, w23, w17);
   TEST_3R("aver_u.d", 208,  72, w26, w15, w14);
   TEST_3R("aver_u.d", 216, 112, w27, w8,  w6);
   TEST_3R("aver_u.d", 224, 112, w28, w17, w15);
   TEST_3R("aver_u.d", 232, 232, w29, w27, w0);
   TEST_3R("aver_u.d", 240,  80, w30, w30, w30);
   TEST_3R("aver_u.d",   0,  48, w31, w8,  w0);
   TEST_3R("div_s.b",   0,  64, w0,  w10, w3);
   TEST_3R("div_s.b",   8,  80, w1,  w17, w8);
   TEST_3R("div_s.b",  16,  64, w2,  w28, w24);
   TEST_3R("div_s.b",  24, 224, w3,  w21, w9);
   TEST_3R("div_s.b",  32,  80, w4,  w22, w26);
   TEST_3R("div_s.b",  40, 240, w5,  w15, w14);
   TEST_3R("div_s.b",  48, 128, w6,  w26, w13);
   TEST_3R("div_s.b",  56, 208, w7,  w13, w18);
   TEST_3R("div_s.b",  64,  80, w8,  w16, w18);
   TEST_3R("div_s.b",  72,  64, w9,  w10, w11);
   TEST_3R("div_s.b",  80,  80, w10, w21, w14);
   TEST_3R("div_s.b",  88,  80, w11, w22, w31);
   TEST_3R("div_s.b",  96,  96, w12, w0,  w27);
   TEST_3R("div_s.b", 104,  80, w13, w13, w13);
   TEST_3R("div_s.b", 112,  16, w14, w16, w12);
   TEST_3R("div_s.b", 120, 224, w15, w6,  w26);
   TEST_3R("div_s.b", 128,  16, w16, w20, w1);
   TEST_3R("div_s.b", 136, 224, w17, w1,  w22);
   TEST_3R("div_s.b", 144, 224, w18, w20, w27);
   TEST_3R("div_s.b", 152,  16, w19, w6,  w14);
   TEST_3R("div_s.b", 160, 208, w20, w17, w23);
   TEST_3R("div_s.b", 168, 128, w21, w31, w26);
   TEST_3R("div_s.b", 176, 128, w22, w31, w4);
   TEST_3R("div_s.b", 184, 240, w23, w26, w26);
   TEST_3R("div_s.b", 192,  96, w24, w14, w24);
   TEST_3R("div_s.b", 200,  64, w25, w20, w30);
   TEST_3R("div_s.b", 208, 240, w26, w26, w24);
   TEST_3R("div_s.b", 216,  16, w27, w15, w26);
   TEST_3R("div_s.b", 224, 128, w28, w16, w22);
   TEST_3R("div_s.b", 232,  96, w29, w11, w4);
   TEST_3R("div_s.b", 240, 128, w30, w25, w28);
   TEST_3R("div_s.b",   8, 128, w31, w17, w10);
   TEST_3R("div_s.h",   0, 240, w0,  w14, w27);
   TEST_3R("div_s.h",   8, 240, w1,  w18, w21);
   TEST_3R("div_s.h",  16,  96, w2,  w1,  w0);
   TEST_3R("div_s.h",  24, 208, w3,  w31, w18);
   TEST_3R("div_s.h",  32, 128, w4,  w24, w25);
   TEST_3R("div_s.h",  40, 208, w5,  w18, w17);
   TEST_3R("div_s.h",  48,  64, w6,  w2,  w7);
   TEST_3R("div_s.h",  56, 128, w7,  w13, w11);
   TEST_3R("div_s.h",  64,  16, w8,  w7,  w17);
   TEST_3R("div_s.h",  72,  96, w9,  w18, w13);
   TEST_3R("div_s.h",  80,  80, w10, w0,  w8);
   TEST_3R("div_s.h",  88,  64, w11, w18, w29);
   TEST_3R("div_s.h",  96, 128, w12, w19, w30);
   TEST_3R("div_s.h", 104,  96, w13, w13, w13);
   TEST_3R("div_s.h", 112,  96, w14, w16, w26);
   TEST_3R("div_s.h", 120, 208, w15, w9,  w14);
   TEST_3R("div_s.h", 128, 240, w16, w27, w19);
   TEST_3R("div_s.h", 136, 128, w17, w2,  w29);
   TEST_3R("div_s.h", 144,  96, w18, w14, w17);
   TEST_3R("div_s.h", 152,  96, w19, w22, w2);
   TEST_3R("div_s.h", 160, 224, w20, w8,  w15);
   TEST_3R("div_s.h", 168,  64, w21, w8,  w23);
   TEST_3R("div_s.h", 176,  80, w22, w26, w21);
   TEST_3R("div_s.h", 184,  96, w23, w14, w14);
   TEST_3R("div_s.h", 192,  64, w24, w31, w24);
   TEST_3R("div_s.h", 200, 128, w25, w3,  w12);
   TEST_3R("div_s.h", 208,  64, w26, w26, w7);
   TEST_3R("div_s.h", 216,  80, w27, w7,  w8);
   TEST_3R("div_s.h", 224,  16, w28, w24, w20);
   TEST_3R("div_s.h", 232, 224, w29, w9,  w8);
   TEST_3R("div_s.h", 240, 224, w30, w12, w19);
   TEST_3R("div_s.h",  64, 224, w31, w27, w2);
   TEST_3R("div_s.w",   0,  16, w0,  w3,  w24);
   TEST_3R("div_s.w",   8,  96, w1,  w13, w6);
   TEST_3R("div_s.w",  16, 224, w2,  w12, w7);
   TEST_3R("div_s.w",  24,  80, w3,  w5,  w19);
   TEST_3R("div_s.w",  32,  80, w4,  w13, w28);
   TEST_3R("div_s.w",  40, 128, w5,  w8,  w4);
   TEST_3R("div_s.w",  48, 128, w6,  w0,  w25);
   TEST_3R("div_s.w",  56,  80, w7,  w9,  w1);
   TEST_3R("div_s.w",  64,  16, w8,  w21, w20);
   TEST_3R("div_s.w",  72, 224, w9,  w17, w22);
   TEST_3R("div_s.w",  80, 224, w10, w4,  w25);
   TEST_3R("div_s.w",  88, 208, w11, w12, w7);
   TEST_3R("div_s.w",  96, 128, w12, w7,  w19);
   TEST_3R("div_s.w", 104, 208, w13, w13, w13);
   TEST_3R("div_s.w", 112, 240, w14, w25, w16);
   TEST_3R("div_s.w", 120,  64, w15, w6,  w12);
   TEST_3R("div_s.w", 128, 208, w16, w14, w17);
   TEST_3R("div_s.w", 136,  64, w17, w14, w10);
   TEST_3R("div_s.w", 144,  96, w18, w23, w11);
   TEST_3R("div_s.w", 152,  96, w19, w13, w31);
   TEST_3R("div_s.w", 160,  64, w20, w30, w22);
   TEST_3R("div_s.w", 168,  16, w21, w2,  w15);
   TEST_3R("div_s.w", 176, 208, w22, w14, w5);
   TEST_3R("div_s.w", 184,  64, w23, w10, w10);
   TEST_3R("div_s.w", 192,  96, w24, w26, w24);
   TEST_3R("div_s.w", 200,  64, w25, w17, w9);
   TEST_3R("div_s.w", 208,  96, w26, w26, w30);
   TEST_3R("div_s.w", 216,  16, w27, w23, w15);
   TEST_3R("div_s.w", 224,  80, w28, w5,  w25);
   TEST_3R("div_s.w", 232, 208, w29, w28, w4);
   TEST_3R("div_s.w", 240,  64, w30, w9,  w3);
   TEST_3R("div_s.w", 152,  80, w31, w7,  w25);
   TEST_3R("div_s.d",   0, 240, w0,  w9,  w10);
   TEST_3R("div_s.d",   8, 128, w1,  w31, w15);
   TEST_3R("div_s.d",  16, 224, w2,  w9,  w17);
   TEST_3R("div_s.d",  24,  16, w3,  w12, w2);
   TEST_3R("div_s.d",  32,  96, w4,  w21, w0);
   TEST_3R("div_s.d",  40,  96, w5,  w12, w15);
   TEST_3R("div_s.d",  48, 208, w6,  w17, w8);
   TEST_3R("div_s.d",  56,  96, w7,  w14, w12);
   TEST_3R("div_s.d",  64, 128, w8,  w23, w16);
   TEST_3R("div_s.d",  72,  16, w9,  w31, w30);
   TEST_3R("div_s.d",  80,  16, w10, w18, w9);
   TEST_3R("div_s.d",  88, 128, w11, w18, w24);
   TEST_3R("div_s.d",  96,  96, w12, w27, w9);
   TEST_3R("div_s.d", 104,  16, w13, w13, w13);
   TEST_3R("div_s.d", 112, 208, w14, w12, w3);
   TEST_3R("div_s.d", 120,  80, w15, w12, w30);
   TEST_3R("div_s.d", 128,  96, w16, w28, w1);
   TEST_3R("div_s.d", 136,  64, w17, w4,  w31);
   TEST_3R("div_s.d", 144,  64, w18, w17, w10);
   TEST_3R("div_s.d", 152,  16, w19, w1,  w14);
   TEST_3R("div_s.d", 160,  16, w20, w10, w12);
   TEST_3R("div_s.d", 168, 240, w21, w29, w8);
   TEST_3R("div_s.d", 176,  80, w22, w14, w21);
   TEST_3R("div_s.d", 184,  80, w23, w8,  w8);
   TEST_3R("div_s.d", 192,  96, w24, w3,  w24);
   TEST_3R("div_s.d", 200,  80, w25, w16, w9);
   TEST_3R("div_s.d", 208,  80, w26, w26, w12);
   TEST_3R("div_s.d", 216,  64, w27, w21, w16);
   TEST_3R("div_s.d", 224,  96, w28, w31, w1);
   TEST_3R("div_s.d", 232,  64, w29, w0,  w2);
   TEST_3R("div_s.d", 240, 224, w30, w0,  w13);
   TEST_3R("div_s.d", 208,  96, w31, w8,  w10);
   TEST_3R("div_u.b",   0, 224, w0,  w9,  w14);
   TEST_3R("div_u.b",   8, 224, w1,  w12, w25);
   TEST_3R("div_u.b",  16,  16, w2,  w28, w0);
   TEST_3R("div_u.b",  24, 208, w3,  w12, w12);
   TEST_3R("div_u.b",  32, 128, w4,  w25, w22);
   TEST_3R("div_u.b",  40, 128, w5,  w26, w9);
   TEST_3R("div_u.b",  48,  96, w6,  w29, w6);
   TEST_3R("div_u.b",  56,  64, w7,  w20, w10);
   TEST_3R("div_u.b",  64, 128, w8,  w29, w20);
   TEST_3R("div_u.b",  72, 224, w9,  w14, w13);
   TEST_3R("div_u.b",  80, 240, w10, w20, w16);
   TEST_3R("div_u.b",  88,  96, w11, w2,  w6);
   TEST_3R("div_u.b",  96, 208, w12, w27, w0);
   TEST_3R("div_u.b", 104,  64, w13, w12, w8);
   TEST_3R("div_u.b", 112, 240, w14, w2,  w1);
   TEST_3R("div_u.b", 120,  64, w15, w22, w28);
   TEST_3R("div_u.b", 128, 128, w16, w11, w25);
   TEST_3R("div_u.b", 136,  96, w17, w17, w31);
   TEST_3R("div_u.b", 144, 240, w18, w13, w28);
   TEST_3R("div_u.b", 152, 128, w19, w9,  w10);
   TEST_3R("div_u.b", 160, 128, w20, w23, w30);
   TEST_3R("div_u.b", 168,  96, w21, w14, w0);
   TEST_3R("div_u.b", 176, 240, w22, w18, w27);
   TEST_3R("div_u.b", 184, 128, w23, w18, w24);
   TEST_3R("div_u.b", 192, 224, w24, w26, w2);
   TEST_3R("div_u.b", 200, 128, w25, w25, w25);
   TEST_3R("div_u.b", 208,  16, w26, w1,  w12);
   TEST_3R("div_u.b", 216,  64, w27, w10, w23);
   TEST_3R("div_u.b", 224, 128, w28, w30, w23);
   TEST_3R("div_u.b", 232,  96, w29, w11, w19);
   TEST_3R("div_u.b", 240, 128, w30, w21, w15);
   TEST_3R("div_u.b",   8,  96, w31, w28, w3);
   TEST_3R("div_u.h",   0,  16, w0,  w30, w13);
   TEST_3R("div_u.h",   8,  64, w1,  w6,  w31);
   TEST_3R("div_u.h",  16,  96, w2,  w26, w25);
   TEST_3R("div_u.h",  24, 208, w3,  w16, w16);
   TEST_3R("div_u.h",  32, 208, w4,  w20, w28);
   TEST_3R("div_u.h",  40, 224, w5,  w31, w20);
   TEST_3R("div_u.h",  48,  96, w6,  w29, w6);
   TEST_3R("div_u.h",  56, 224, w7,  w18, w9);
   TEST_3R("div_u.h",  64, 128, w8,  w29, w30);
   TEST_3R("div_u.h",  72,  64, w9,  w12, w10);
   TEST_3R("div_u.h",  80, 224, w10, w16, w5);
   TEST_3R("div_u.h",  88, 224, w11, w14, w18);
   TEST_3R("div_u.h",  96, 240, w12, w20, w17);
   TEST_3R("div_u.h", 104,  80, w13, w14, w11);
   TEST_3R("div_u.h", 112, 240, w14, w30, w0);
   TEST_3R("div_u.h", 120, 224, w15, w27, w14);
   TEST_3R("div_u.h", 128,  96, w16, w15, w12);
   TEST_3R("div_u.h", 136, 240, w17, w17, w26);
   TEST_3R("div_u.h", 144, 128, w18, w12, w24);
   TEST_3R("div_u.h", 152,  64, w19, w10, w21);
   TEST_3R("div_u.h", 160,  64, w20, w21, w14);
   TEST_3R("div_u.h", 168, 240, w21, w26, w4);
   TEST_3R("div_u.h", 176, 128, w22, w13, w18);
   TEST_3R("div_u.h", 184,  80, w23, w30, w18);
   TEST_3R("div_u.h", 192,  64, w24, w9,  w4);
   TEST_3R("div_u.h", 200,  80, w25, w25, w25);
   TEST_3R("div_u.h", 208,  16, w26, w11, w4);
   TEST_3R("div_u.h", 216, 128, w27, w17, w19);
   TEST_3R("div_u.h", 224,  96, w28, w21, w13);
   TEST_3R("div_u.h", 232,  16, w29, w1,  w5);
   TEST_3R("div_u.h", 240,  64, w30, w12, w26);
   TEST_3R("div_u.h",   8,  80, w31, w1,  w8);
   TEST_3R("div_u.w",   0,  16, w0,  w12, w9);
   TEST_3R("div_u.w",   8, 240, w1,  w31, w5);
   TEST_3R("div_u.w",  16,  16, w2,  w17, w16);
   TEST_3R("div_u.w",  24,  64, w3,  w21, w21);
   TEST_3R("div_u.w",  32, 208, w4,  w26, w1);
   TEST_3R("div_u.w",  40, 240, w5,  w18, w16);
   TEST_3R("div_u.w",  48, 208, w6,  w7,  w6);
   TEST_3R("div_u.w",  56,  80, w7,  w26, w9);
   TEST_3R("div_u.w",  64, 208, w8,  w26, w21);
   TEST_3R("div_u.w",  72, 208, w9,  w3,  w22);
   TEST_3R("div_u.w",  80,  80, w10, w5,  w17);
   TEST_3R("div_u.w",  88,  64, w11, w15, w26);
   TEST_3R("div_u.w",  96,  80, w12, w20, w1);
   TEST_3R("div_u.w", 104, 240, w13, w4,  w17);
   TEST_3R("div_u.w", 112,  16, w14, w29, w12);
   TEST_3R("div_u.w", 120,  96, w15, w26, w30);
   TEST_3R("div_u.w", 128,  80, w16, w10, w21);
   TEST_3R("div_u.w", 136,  16, w17, w17, w7);
   TEST_3R("div_u.w", 144,  80, w18, w27, w10);
   TEST_3R("div_u.w", 152, 224, w19, w16, w7);
   TEST_3R("div_u.w", 160,  96, w20, w6,  w12);
   TEST_3R("div_u.w", 168,  80, w21, w24, w30);
   TEST_3R("div_u.w", 176, 240, w22, w18, w15);
   TEST_3R("div_u.w", 184,  96, w23, w19, w17);
   TEST_3R("div_u.w", 192,  64, w24, w4,  w9);
   TEST_3R("div_u.w", 200,  16, w25, w25, w25);
   TEST_3R("div_u.w", 208, 240, w26, w1,  w19);
   TEST_3R("div_u.w", 216, 128, w27, w12, w30);
   TEST_3R("div_u.w", 224, 128, w28, w31, w5);
   TEST_3R("div_u.w", 232, 240, w29, w26, w15);
   TEST_3R("div_u.w", 240, 208, w30, w11, w22);
   TEST_3R("div_u.w",  88,  16, w31, w17, w3);
   TEST_3R("div_u.d",   0,  96, w0,  w1,  w3);
   TEST_3R("div_u.d",   8, 224, w1,  w17, w26);
   TEST_3R("div_u.d",  16,  96, w2,  w21, w19);
   TEST_3R("div_u.d",  24,  96, w3,  w14, w14);
   TEST_3R("div_u.d",  32,  80, w4,  w13, w2);
   TEST_3R("div_u.d",  40, 240, w5,  w25, w0);
   TEST_3R("div_u.d",  48, 208, w6,  w24, w6);
   TEST_3R("div_u.d",  56, 208, w7,  w11, w19);
   TEST_3R("div_u.d",  64,  96, w8,  w10, w30);
   TEST_3R("div_u.d",  72, 224, w9,  w23, w15);
   TEST_3R("div_u.d",  80,  16, w10, w24, w25);
   TEST_3R("div_u.d",  88,  64, w11, w27, w20);
   TEST_3R("div_u.d",  96,  96, w12, w21, w3);
   TEST_3R("div_u.d", 104, 240, w13, w10, w22);
   TEST_3R("div_u.d", 112,  96, w14, w25, w28);
   TEST_3R("div_u.d", 120,  96, w15, w12, w21);
   TEST_3R("div_u.d", 128,  16, w16, w3,  w14);
   TEST_3R("div_u.d", 136,  64, w17, w17, w14);
   TEST_3R("div_u.d", 144, 240, w18, w21, w25);
   TEST_3R("div_u.d", 152, 224, w19, w1,  w16);
   TEST_3R("div_u.d", 160, 240, w20, w15, w8);
   TEST_3R("div_u.d", 168, 128, w21, w31, w3);
   TEST_3R("div_u.d", 176, 240, w22, w0,  w24);
   TEST_3R("div_u.d", 184, 208, w23, w4,  w3);
   TEST_3R("div_u.d", 192, 224, w24, w19, w28);
   TEST_3R("div_u.d", 200, 240, w25, w25, w25);
   TEST_3R("div_u.d", 208,  80, w26, w23, w4);
   TEST_3R("div_u.d", 216,  80, w27, w29, w18);
   TEST_3R("div_u.d", 224,  16, w28, w12, w19);
   TEST_3R("div_u.d", 232,  64, w29, w5,  w18);
   TEST_3R("div_u.d", 240,  16, w30, w21, w1);
   TEST_3R("div_u.d", 128,  16, w31, w30, w8);
   TEST_3R("dotp_s.h",   0,  40, w0,  w10, w30);
   TEST_3R("dotp_s.h",   8, 224, w1,  w20, w9);
   TEST_3R("dotp_s.h",  16, 168, w2,  w9,  w12);
   TEST_3R("dotp_s.h",  24, 144, w3,  w21, w31);
   TEST_3R("dotp_s.h",  32, 136, w4,  w30, w5);
   TEST_3R("dotp_s.h",  40,   0, w5,  w22, w4);
   TEST_3R("dotp_s.h",  48, 112, w6,  w29, w17);
   TEST_3R("dotp_s.h",  56,  72, w7,  w16, w22);
   TEST_3R("dotp_s.h",  64,  48, w8,  w23, w8);
   TEST_3R("dotp_s.h",  72,  16, w9,  w19, w26);
   TEST_3R("dotp_s.h",  80, 168, w10, w30, w25);
   TEST_3R("dotp_s.h",  88, 160, w11, w18, w2);
   TEST_3R("dotp_s.h",  96, 104, w12, w27, w28);
   TEST_3R("dotp_s.h", 104,   8, w13, w1,  w27);
   TEST_3R("dotp_s.h", 112,  24, w14, w31, w1);
   TEST_3R("dotp_s.h", 120,  24, w15, w21, w5);
   TEST_3R("dotp_s.h", 128, 136, w16, w18, w22);
   TEST_3R("dotp_s.h", 136, 192, w17, w3,  w29);
   TEST_3R("dotp_s.h", 144,   8, w18, w27, w20);
   TEST_3R("dotp_s.h", 152, 144, w19, w15, w14);
   TEST_3R("dotp_s.h", 160,  80, w20, w13, w7);
   TEST_3R("dotp_s.h", 168, 168, w21, w31, w31);
   TEST_3R("dotp_s.h", 176,   0, w22, w22, w22);
   TEST_3R("dotp_s.h", 184,  72, w23, w27, w22);
   TEST_3R("dotp_s.h", 192, 136, w24, w3,  w23);
   TEST_3R("dotp_s.h", 200, 216, w25, w1,  w23);
   TEST_3R("dotp_s.h", 208,  32, w26, w27, w12);
   TEST_3R("dotp_s.h", 216,  48, w27, w22, w31);
   TEST_3R("dotp_s.h", 224,  16, w28, w6,  w2);
   TEST_3R("dotp_s.h", 232, 232, w29, w12, w7);
   TEST_3R("dotp_s.h", 240, 136, w30, w12, w21);
   TEST_3R("dotp_s.h",  88, 200, w31, w31, w25);
   TEST_3R("dotp_s.w",   0,  96, w0,  w25, w7);
   TEST_3R("dotp_s.w",   8,  40, w1,  w20, w29);
   TEST_3R("dotp_s.w",  16,  56, w2,  w23, w20);
   TEST_3R("dotp_s.w",  24, 144, w3,  w25, w11);
   TEST_3R("dotp_s.w",  32, 176, w4,  w20, w24);
   TEST_3R("dotp_s.w",  40, 232, w5,  w11, w23);
   TEST_3R("dotp_s.w",  48, 120, w6,  w17, w25);
   TEST_3R("dotp_s.w",  56,   0, w7,  w29, w22);
   TEST_3R("dotp_s.w",  64, 144, w8,  w21, w8);
   TEST_3R("dotp_s.w",  72,  16, w9,  w16, w28);
   TEST_3R("dotp_s.w",  80,  24, w10, w29, w21);
   TEST_3R("dotp_s.w",  88, 200, w11, w13, w9);
   TEST_3R("dotp_s.w",  96,  88, w12, w28, w1);
   TEST_3R("dotp_s.w", 104, 136, w13, w4,  w26);
   TEST_3R("dotp_s.w", 112, 184, w14, w8,  w2);
   TEST_3R("dotp_s.w", 120, 104, w15, w25, w5);
   TEST_3R("dotp_s.w", 128,  48, w16, w18, w17);
   TEST_3R("dotp_s.w", 136, 104, w17, w8,  w5);
   TEST_3R("dotp_s.w", 144,  56, w18, w11, w14);
   TEST_3R("dotp_s.w", 152, 104, w19, w8,  w20);
   TEST_3R("dotp_s.w", 160, 224, w20, w29, w1);
   TEST_3R("dotp_s.w", 168, 120, w21, w7,  w7);
   TEST_3R("dotp_s.w", 176, 160, w22, w22, w22);
   TEST_3R("dotp_s.w", 184,  24, w23, w8,  w9);
   TEST_3R("dotp_s.w", 192,  32, w24, w2,  w19);
   TEST_3R("dotp_s.w", 200, 216, w25, w16, w21);
   TEST_3R("dotp_s.w", 208,  32, w26, w10, w14);
   TEST_3R("dotp_s.w", 216, 208, w27, w20, w0);
   TEST_3R("dotp_s.w", 224,  40, w28, w9,  w7);
   TEST_3R("dotp_s.w", 232,  96, w29, w20, w21);
   TEST_3R("dotp_s.w", 240,  72, w30, w28, w9);
   TEST_3R("dotp_s.w",  64, 200, w31, w31, w26);
   TEST_3R("dotp_s.d",   0, 104, w0,  w1,  w21);
   TEST_3R("dotp_s.d",   8, 128, w1,  w9,  w30);
   TEST_3R("dotp_s.d",  16,  32, w2,  w11, w18);
   TEST_3R("dotp_s.d",  24,   8, w3,  w27, w7);
   TEST_3R("dotp_s.d",  32, 152, w4,  w5,  w22);
   TEST_3R("dotp_s.d",  40,   0, w5,  w26, w22);
   TEST_3R("dotp_s.d",  48,  16, w6,  w22, w31);
   TEST_3R("dotp_s.d",  56,  40, w7,  w14, w20);
   TEST_3R("dotp_s.d",  64, 192, w8,  w19, w8);
   TEST_3R("dotp_s.d",  72, 120, w9,  w21, w2);
   TEST_3R("dotp_s.d",  80, 152, w10, w31, w9);
   TEST_3R("dotp_s.d",  88, 112, w11, w20, w3);
   TEST_3R("dotp_s.d",  96,  24, w12, w18, w21);
   TEST_3R("dotp_s.d", 104,  72, w13, w4,  w7);
   TEST_3R("dotp_s.d", 112,  16, w14, w12, w4);
   TEST_3R("dotp_s.d", 120, 200, w15, w2,  w18);
   TEST_3R("dotp_s.d", 128, 192, w16, w24, w2);
   TEST_3R("dotp_s.d", 136, 216, w17, w24, w25);
   TEST_3R("dotp_s.d", 144,  96, w18, w12, w5);
   TEST_3R("dotp_s.d", 152, 176, w19, w28, w26);
   TEST_3R("dotp_s.d", 160,  72, w20, w7,  w25);
   TEST_3R("dotp_s.d", 168, 136, w21, w18, w18);
   TEST_3R("dotp_s.d", 176, 192, w22, w22, w22);
   TEST_3R("dotp_s.d", 184, 192, w23, w7,  w0);
   TEST_3R("dotp_s.d", 192, 232, w24, w6,  w4);
   TEST_3R("dotp_s.d", 200, 160, w25, w1,  w16);
   TEST_3R("dotp_s.d", 208,   0, w26, w2,  w18);
   TEST_3R("dotp_s.d", 216, 192, w27, w28, w11);
   TEST_3R("dotp_s.d", 224, 176, w28, w13, w3);
   TEST_3R("dotp_s.d", 232, 192, w29, w12, w15);
   TEST_3R("dotp_s.d", 240, 192, w30, w11, w16);
   TEST_3R("dotp_s.d", 144,  72, w31, w31, w18);
   TEST_3R("dotp_u.h",   0, 176, w0,  w10, w4);
   TEST_3R("dotp_u.h",   8,  56, w1,  w29, w26);
   TEST_3R("dotp_u.h",  16,  32, w2,  w22, w6);
   TEST_3R("dotp_u.h",  24, 112, w3,  w19, w4);
   TEST_3R("dotp_u.h",  32, 208, w4,  w31, w5);
   TEST_3R("dotp_u.h",  40, 176, w5,  w5,  w5);
   TEST_3R("dotp_u.h",  48,  32, w6,  w11, w3);
   TEST_3R("dotp_u.h",  56, 136, w7,  w12, w29);
   TEST_3R("dotp_u.h",  64,  88, w8,  w15, w3);
   TEST_3R("dotp_u.h",  72, 216, w9,  w6,  w4);
   TEST_3R("dotp_u.h",  80,   0, w10, w23, w1);
   TEST_3R("dotp_u.h",  88, 176, w11, w1,  w5);
   TEST_3R("dotp_u.h",  96,  24, w12, w30, w30);
   TEST_3R("dotp_u.h", 104, 192, w13, w0,  w20);
   TEST_3R("dotp_u.h", 112,   8, w14, w3,  w7);
   TEST_3R("dotp_u.h", 120,  64, w15, w19, w6);
   TEST_3R("dotp_u.h", 128,  56, w16, w11, w27);
   TEST_3R("dotp_u.h", 136, 152, w17, w12, w7);
   TEST_3R("dotp_u.h", 144,  96, w18, w6,  w18);
   TEST_3R("dotp_u.h", 152,  56, w19, w14, w16);
   TEST_3R("dotp_u.h", 160,  32, w20, w18, w30);
   TEST_3R("dotp_u.h", 168, 192, w21, w19, w16);
   TEST_3R("dotp_u.h", 176, 224, w22, w25, w2);
   TEST_3R("dotp_u.h", 184,  32, w23, w23, w24);
   TEST_3R("dotp_u.h", 192,  48, w24, w6,  w30);
   TEST_3R("dotp_u.h", 200,  56, w25, w14, w9);
   TEST_3R("dotp_u.h", 208, 144, w26, w20, w25);
   TEST_3R("dotp_u.h", 216, 208, w27, w0,  w20);
   TEST_3R("dotp_u.h", 224, 232, w28, w12, w27);
   TEST_3R("dotp_u.h", 232, 200, w29, w19, w17);
   TEST_3R("dotp_u.h", 240,  88, w30, w3,  w14);
   TEST_3R("dotp_u.h", 112, 128, w31, w1,  w17);
   TEST_3R("dotp_u.w",   0, 216, w0,  w10, w19);
   TEST_3R("dotp_u.w",   8,  88, w1,  w2,  w22);
   TEST_3R("dotp_u.w",  16, 120, w2,  w1,  w28);
   TEST_3R("dotp_u.w",  24, 112, w3,  w10, w22);
   TEST_3R("dotp_u.w",  32, 112, w4,  w3,  w26);
   TEST_3R("dotp_u.w",  40,   0, w5,  w5,  w5);
   TEST_3R("dotp_u.w",  48, 112, w6,  w13, w30);
   TEST_3R("dotp_u.w",  56,  64, w7,  w10, w17);
   TEST_3R("dotp_u.w",  64,  80, w8,  w22, w20);
   TEST_3R("dotp_u.w",  72,   0, w9,  w19, w21);
   TEST_3R("dotp_u.w",  80, 232, w10, w4,  w6);
   TEST_3R("dotp_u.w",  88, 208, w11, w14, w25);
   TEST_3R("dotp_u.w",  96, 160, w12, w17, w17);
   TEST_3R("dotp_u.w", 104, 168, w13, w0,  w18);
   TEST_3R("dotp_u.w", 112,   0, w14, w29, w28);
   TEST_3R("dotp_u.w", 120,  32, w15, w31, w29);
   TEST_3R("dotp_u.w", 128,  56, w16, w22, w10);
   TEST_3R("dotp_u.w", 136, 184, w17, w8,  w20);
   TEST_3R("dotp_u.w", 144, 136, w18, w11, w18);
   TEST_3R("dotp_u.w", 152,   8, w19, w3,  w29);
   TEST_3R("dotp_u.w", 160, 144, w20, w24, w16);
   TEST_3R("dotp_u.w", 168, 160, w21, w30, w25);
   TEST_3R("dotp_u.w", 176,  32, w22, w24, w10);
   TEST_3R("dotp_u.w", 184, 216, w23, w23, w8);
   TEST_3R("dotp_u.w", 192, 128, w24, w20, w8);
   TEST_3R("dotp_u.w", 200, 128, w25, w23, w15);
   TEST_3R("dotp_u.w", 208,  56, w26, w24, w5);
   TEST_3R("dotp_u.w", 216,  48, w27, w22, w13);
   TEST_3R("dotp_u.w", 224, 184, w28, w6,  w24);
   TEST_3R("dotp_u.w", 232,  72, w29, w9,  w21);
   TEST_3R("dotp_u.w", 240, 216, w30, w2,  w5);
   TEST_3R("dotp_u.w", 120,   8, w31, w0,  w30);
   TEST_3R("dotp_u.d",   0,  96, w0,  w9,  w16);
   TEST_3R("dotp_u.d",   8, 112, w1,  w20, w4);
   TEST_3R("dotp_u.d",  16, 136, w2,  w28, w20);
   TEST_3R("dotp_u.d",  24,  72, w3,  w20, w0);
   TEST_3R("dotp_u.d",  32, 128, w4,  w8,  w30);
   TEST_3R("dotp_u.d",  40, 160, w5,  w5,  w5);
   TEST_3R("dotp_u.d",  48, 136, w6,  w16, w8);
   TEST_3R("dotp_u.d",  56,  64, w7,  w13, w18);
   TEST_3R("dotp_u.d",  64,   0, w8,  w20, w9);
   TEST_3R("dotp_u.d",  72,  16, w9,  w20, w7);
   TEST_3R("dotp_u.d",  80,  48, w10, w13, w16);
   TEST_3R("dotp_u.d",  88,  40, w11, w13, w4);
   TEST_3R("dotp_u.d",  96,  32, w12, w2,  w2);
   TEST_3R("dotp_u.d", 104,   0, w13, w30, w14);
   TEST_3R("dotp_u.d", 112,  40, w14, w1,  w10);
   TEST_3R("dotp_u.d", 120, 168, w15, w3,  w31);
   TEST_3R("dotp_u.d", 128,   8, w16, w12, w13);
   TEST_3R("dotp_u.d", 136, 192, w17, w30, w19);
   TEST_3R("dotp_u.d", 144,  40, w18, w26, w18);
   TEST_3R("dotp_u.d", 152, 168, w19, w6,  w1);
   TEST_3R("dotp_u.d", 160, 224, w20, w19, w18);
   TEST_3R("dotp_u.d", 168, 136, w21, w1,  w22);
   TEST_3R("dotp_u.d", 176, 168, w22, w3,  w23);
   TEST_3R("dotp_u.d", 184, 168, w23, w23, w18);
   TEST_3R("dotp_u.d", 192, 120, w24, w27, w0);
   TEST_3R("dotp_u.d", 200,  80, w25, w5,  w13);
   TEST_3R("dotp_u.d", 208,  40, w26, w5,  w10);
   TEST_3R("dotp_u.d", 216, 216, w27, w18, w20);
   TEST_3R("dotp_u.d", 224,  40, w28, w3,  w7);
   TEST_3R("dotp_u.d", 232,  40, w29, w0,  w19);
   TEST_3R("dotp_u.d", 240, 160, w30, w14, w7);
   TEST_3R("dotp_u.d", 152, 176, w31, w0,  w8);
   TEST_3R("dpadd_s.h",   0,  80, w0,  w4,  w23);
   TEST_3R("dpadd_s.h",   8, 232, w1,  w25, w21);
   TEST_3R("dpadd_s.h",  16,  80, w2,  w7,  w12);
   TEST_3R("dpadd_s.h",  24, 112, w3,  w29, w4);
   TEST_3R("dpadd_s.h",  32, 160, w4,  w14, w16);
   TEST_3R("dpadd_s.h",  40,   0, w5,  w9,  w0);
   TEST_3R("dpadd_s.h",  48,  32, w6,  w29, w20);
   TEST_3R("dpadd_s.h",  56, 128, w7,  w11, w12);
   TEST_3R("dpadd_s.h",  64,  24, w8,  w26, w4);
   TEST_3R("dpadd_s.h",  72,  40, w9,  w17, w16);
   TEST_3R("dpadd_s.h",  80, 128, w10, w1,  w21);
   TEST_3R("dpadd_s.h",  88, 144, w11, w11, w11);
   TEST_3R("dpadd_s.h",  96, 144, w12, w14, w9);
   TEST_3R("dpadd_s.h", 104,  96, w13, w22, w21);
   TEST_3R("dpadd_s.h", 112,  88, w14, w19, w25);
   TEST_3R("dpadd_s.h", 120,  16, w15, w1,  w9);
   TEST_3R("dpadd_s.h", 128,  24, w16, w10, w9);
   TEST_3R("dpadd_s.h", 136, 168, w17, w8,  w29);
   TEST_3R("dpadd_s.h", 144, 176, w18, w19, w9);
   TEST_3R("dpadd_s.h", 152, 216, w19, w14, w16);
   TEST_3R("dpadd_s.h", 160, 160, w20, w30, w12);
   TEST_3R("dpadd_s.h", 168,  64, w21, w19, w0);
   TEST_3R("dpadd_s.h", 176, 136, w22, w2,  w22);
   TEST_3R("dpadd_s.h", 184,  24, w23, w25, w24);
   TEST_3R("dpadd_s.h", 192, 128, w24, w0,  w11);
   TEST_3R("dpadd_s.h", 200,  80, w25, w30, w13);
   TEST_3R("dpadd_s.h", 208,  40, w26, w19, w23);
   TEST_3R("dpadd_s.h", 216,   8, w27, w16, w31);
   TEST_3R("dpadd_s.h", 224, 208, w28, w30, w19);
   TEST_3R("dpadd_s.h", 232,  96, w29, w15, w15);
   TEST_3R("dpadd_s.h", 240, 192, w30, w31, w0);
   TEST_3R("dpadd_s.h", 112,  40, w31, w31, w30);
   TEST_3R("dpadd_s.w",   0, 176, w0,  w17, w12);
   TEST_3R("dpadd_s.w",   8,  24, w1,  w19, w21);
   TEST_3R("dpadd_s.w",  16, 200, w2,  w11, w19);
   TEST_3R("dpadd_s.w",  24, 120, w3,  w23, w11);
   TEST_3R("dpadd_s.w",  32, 168, w4,  w12, w0);
   TEST_3R("dpadd_s.w",  40, 104, w5,  w22, w16);
   TEST_3R("dpadd_s.w",  48, 216, w6,  w30, w14);
   TEST_3R("dpadd_s.w",  56, 184, w7,  w16, w30);
   TEST_3R("dpadd_s.w",  64, 136, w8,  w15, w30);
   TEST_3R("dpadd_s.w",  72,   8, w9,  w13, w10);
   TEST_3R("dpadd_s.w",  80,  64, w10, w31, w23);
   TEST_3R("dpadd_s.w",  88,   0, w11, w11, w11);
   TEST_3R("dpadd_s.w",  96,  32, w12, w19, w30);
   TEST_3R("dpadd_s.w", 104, 136, w13, w1,  w21);
   TEST_3R("dpadd_s.w", 112, 120, w14, w25, w23);
   TEST_3R("dpadd_s.w", 120, 136, w15, w20, w13);
   TEST_3R("dpadd_s.w", 128, 168, w16, w15, w12);
   TEST_3R("dpadd_s.w", 136,  24, w17, w29, w28);
   TEST_3R("dpadd_s.w", 144, 152, w18, w12, w11);
   TEST_3R("dpadd_s.w", 152, 208, w19, w27, w25);
   TEST_3R("dpadd_s.w", 160,  72, w20, w10, w24);
   TEST_3R("dpadd_s.w", 168,   0, w21, w15, w10);
   TEST_3R("dpadd_s.w", 176,  88, w22, w2,  w22);
   TEST_3R("dpadd_s.w", 184,  48, w23, w3,  w29);
   TEST_3R("dpadd_s.w", 192, 120, w24, w17, w22);
   TEST_3R("dpadd_s.w", 200, 160, w25, w31, w11);
   TEST_3R("dpadd_s.w", 208, 120, w26, w30, w18);
   TEST_3R("dpadd_s.w", 216,  16, w27, w24, w14);
   TEST_3R("dpadd_s.w", 224, 168, w28, w4,  w26);
   TEST_3R("dpadd_s.w", 232,  16, w29, w0,  w0);
   TEST_3R("dpadd_s.w", 240, 184, w30, w18, w10);
   TEST_3R("dpadd_s.w", 224, 168, w31, w31, w29);
   TEST_3R("dpadd_s.d",   0,  72, w0,  w20, w27);
   TEST_3R("dpadd_s.d",   8,  72, w1,  w11, w31);
   TEST_3R("dpadd_s.d",  16, 128, w2,  w13, w16);
   TEST_3R("dpadd_s.d",  24,  24, w3,  w6,  w16);
   TEST_3R("dpadd_s.d",  32,   0, w4,  w12, w14);
   TEST_3R("dpadd_s.d",  40,  24, w5,  w31, w25);
   TEST_3R("dpadd_s.d",  48, 176, w6,  w13, w15);
   TEST_3R("dpadd_s.d",  56, 104, w7,  w14, w20);
   TEST_3R("dpadd_s.d",  64, 160, w8,  w0,  w30);
   TEST_3R("dpadd_s.d",  72, 152, w9,  w29, w24);
   TEST_3R("dpadd_s.d",  80, 104, w10, w17, w19);
   TEST_3R("dpadd_s.d",  88, 184, w11, w11, w11);
   TEST_3R("dpadd_s.d",  96, 120, w12, w18, w20);
   TEST_3R("dpadd_s.d", 104,  40, w13, w3,  w6);
   TEST_3R("dpadd_s.d", 112, 136, w14, w19, w3);
   TEST_3R("dpadd_s.d", 120, 184, w15, w1,  w27);
   TEST_3R("dpadd_s.d", 128,  24, w16, w26, w10);
   TEST_3R("dpadd_s.d", 136, 112, w17, w9,  w30);
   TEST_3R("dpadd_s.d", 144,   0, w18, w23, w10);
   TEST_3R("dpadd_s.d", 152,  96, w19, w17, w16);
   TEST_3R("dpadd_s.d", 160, 160, w20, w9,  w11);
   TEST_3R("dpadd_s.d", 168, 112, w21, w28, w4);
   TEST_3R("dpadd_s.d", 176, 184, w22, w15, w22);
   TEST_3R("dpadd_s.d", 184, 232, w23, w12, w18);
   TEST_3R("dpadd_s.d", 192,  80, w24, w28, w5);
   TEST_3R("dpadd_s.d", 200, 152, w25, w24, w6);
   TEST_3R("dpadd_s.d", 208,  24, w26, w19, w0);
   TEST_3R("dpadd_s.d", 216, 232, w27, w9,  w6);
   TEST_3R("dpadd_s.d", 224, 192, w28, w0,  w25);
   TEST_3R("dpadd_s.d", 232, 168, w29, w23, w23);
   TEST_3R("dpadd_s.d", 240, 112, w30, w6,  w12);
   TEST_3R("dpadd_s.d",  24,  64, w31, w31, w17);
   TEST_3R("dpadd_u.h",   0,  32, w0,  w1,  w29);
   TEST_3R("dpadd_u.h",   8,   8, w1,  w30, w11);
   TEST_3R("dpadd_u.h",  16, 208, w2,  w4,  w26);
   TEST_3R("dpadd_u.h",  24,   8, w3,  w28, w5);
   TEST_3R("dpadd_u.h",  32, 136, w4,  w12, w17);
   TEST_3R("dpadd_u.h",  40, 112, w5,  w4,  w1);
   TEST_3R("dpadd_u.h",  48, 216, w6,  w11, w19);
   TEST_3R("dpadd_u.h",  56, 232, w7,  w12, w14);
   TEST_3R("dpadd_u.h",  64,  96, w8,  w6,  w14);
   TEST_3R("dpadd_u.h",  72,   0, w9,  w11, w4);
   TEST_3R("dpadd_u.h",  80, 176, w10, w27, w5);
   TEST_3R("dpadd_u.h",  88, 216, w11, w3,  w14);
   TEST_3R("dpadd_u.h",  96, 192, w12, w7,  w9);
   TEST_3R("dpadd_u.h", 104,  56, w13, w4,  w4);
   TEST_3R("dpadd_u.h", 112, 120, w14, w0,  w16);
   TEST_3R("dpadd_u.h", 120,  80, w15, w28, w21);
   TEST_3R("dpadd_u.h", 128, 144, w16, w18, w0);
   TEST_3R("dpadd_u.h", 136, 128, w17, w13, w12);
   TEST_3R("dpadd_u.h", 144, 208, w18, w6,  w19);
   TEST_3R("dpadd_u.h", 152,  16, w19, w24, w30);
   TEST_3R("dpadd_u.h", 160, 152, w20, w30, w26);
   TEST_3R("dpadd_u.h", 168, 208, w21, w21, w21);
   TEST_3R("dpadd_u.h", 176, 136, w22, w22, w29);
   TEST_3R("dpadd_u.h", 184,  48, w23, w16, w26);
   TEST_3R("dpadd_u.h", 192, 216, w24, w25, w13);
   TEST_3R("dpadd_u.h", 200,  40, w25, w7,  w13);
   TEST_3R("dpadd_u.h", 208, 136, w26, w7,  w9);
   TEST_3R("dpadd_u.h", 216,   8, w27, w8,  w28);
   TEST_3R("dpadd_u.h", 224,  40, w28, w9,  w27);
   TEST_3R("dpadd_u.h", 232, 120, w29, w15, w14);
   TEST_3R("dpadd_u.h", 240, 104, w30, w7,  w30);
   TEST_3R("dpadd_u.h", 168,  16, w31, w2,  w6);
   TEST_3R("dpadd_u.w",   0,  72, w0,  w7,  w3);
   TEST_3R("dpadd_u.w",   8, 232, w1,  w23, w30);
   TEST_3R("dpadd_u.w",  16,  88, w2,  w16, w11);
   TEST_3R("dpadd_u.w",  24,   0, w3,  w24, w25);
   TEST_3R("dpadd_u.w",  32, 144, w4,  w31, w2);
   TEST_3R("dpadd_u.w",  40,  24, w5,  w7,  w30);
   TEST_3R("dpadd_u.w",  48,   8, w6,  w3,  w7);
   TEST_3R("dpadd_u.w",  56,  16, w7,  w1,  w22);
   TEST_3R("dpadd_u.w",  64, 128, w8,  w15, w30);
   TEST_3R("dpadd_u.w",  72, 152, w9,  w17, w4);
   TEST_3R("dpadd_u.w",  80,  56, w10, w14, w11);
   TEST_3R("dpadd_u.w",  88, 184, w11, w8,  w3);
   TEST_3R("dpadd_u.w",  96,   0, w12, w7,  w19);
   TEST_3R("dpadd_u.w", 104, 184, w13, w15, w15);
   TEST_3R("dpadd_u.w", 112, 120, w14, w0,  w16);
   TEST_3R("dpadd_u.w", 120,  64, w15, w3,  w0);
   TEST_3R("dpadd_u.w", 128,  48, w16, w1,  w31);
   TEST_3R("dpadd_u.w", 136, 192, w17, w9,  w24);
   TEST_3R("dpadd_u.w", 144, 224, w18, w31, w0);
   TEST_3R("dpadd_u.w", 152,  32, w19, w29, w20);
   TEST_3R("dpadd_u.w", 160,  16, w20, w1,  w14);
   TEST_3R("dpadd_u.w", 168,  56, w21, w21, w21);
   TEST_3R("dpadd_u.w", 176,  72, w22, w22, w12);
   TEST_3R("dpadd_u.w", 184,   0, w23, w16, w8);
   TEST_3R("dpadd_u.w", 192, 128, w24, w3,  w16);
   TEST_3R("dpadd_u.w", 200, 144, w25, w15, w16);
   TEST_3R("dpadd_u.w", 208, 176, w26, w25, w19);
   TEST_3R("dpadd_u.w", 216, 112, w27, w11, w21);
   TEST_3R("dpadd_u.w", 224, 184, w28, w31, w30);
   TEST_3R("dpadd_u.w", 232,  24, w29, w21, w10);
   TEST_3R("dpadd_u.w", 240, 120, w30, w27, w30);
   TEST_3R("dpadd_u.w", 192,   8, w31, w15, w28);
   TEST_3R("dpadd_u.d",   0,  24, w0,  w9,  w25);
   TEST_3R("dpadd_u.d",   8, 144, w1,  w25, w2);
   TEST_3R("dpadd_u.d",  16,  32, w2,  w29, w18);
   TEST_3R("dpadd_u.d",  24, 176, w3,  w12, w2);
   TEST_3R("dpadd_u.d",  32, 232, w4,  w5,  w22);
   TEST_3R("dpadd_u.d",  40, 104, w5,  w16, w11);
   TEST_3R("dpadd_u.d",  48, 160, w6,  w16, w9);
   TEST_3R("dpadd_u.d",  56, 192, w7,  w5,  w6);
   TEST_3R("dpadd_u.d",  64,  72, w8,  w30, w1);
   TEST_3R("dpadd_u.d",  72,  88, w9,  w14, w30);
   TEST_3R("dpadd_u.d",  80, 160, w10, w1,  w7);
   TEST_3R("dpadd_u.d",  88, 224, w11, w1,  w8);
   TEST_3R("dpadd_u.d",  96,  24, w12, w30, w26);
   TEST_3R("dpadd_u.d", 104,  24, w13, w10, w10);
   TEST_3R("dpadd_u.d", 112, 184, w14, w15, w18);
   TEST_3R("dpadd_u.d", 120, 160, w15, w0,  w29);
   TEST_3R("dpadd_u.d", 128,  16, w16, w6,  w11);
   TEST_3R("dpadd_u.d", 136,  64, w17, w13, w12);
   TEST_3R("dpadd_u.d", 144,  48, w18, w14, w12);
   TEST_3R("dpadd_u.d", 152, 224, w19, w12, w24);
   TEST_3R("dpadd_u.d", 160, 208, w20, w30, w4);
   TEST_3R("dpadd_u.d", 168, 112, w21, w21, w21);
   TEST_3R("dpadd_u.d", 176,  16, w22, w22, w23);
   TEST_3R("dpadd_u.d", 184, 168, w23, w0,  w31);
   TEST_3R("dpadd_u.d", 192, 168, w24, w29, w14);
   TEST_3R("dpadd_u.d", 200,  72, w25, w15, w23);
   TEST_3R("dpadd_u.d", 208, 184, w26, w13, w12);
   TEST_3R("dpadd_u.d", 216, 208, w27, w19, w24);
   TEST_3R("dpadd_u.d", 224,  32, w28, w0,  w4);
   TEST_3R("dpadd_u.d", 232, 192, w29, w15, w16);
   TEST_3R("dpadd_u.d", 240, 168, w30, w27, w30);
   TEST_3R("dpadd_u.d", 232,  32, w31, w9,  w15);
   TEST_3R("dpsub_s.h",   0,  72, w0,  w22, w27);
   TEST_3R("dpsub_s.h",   8,  48, w1,  w11, w20);
   TEST_3R("dpsub_s.h",  16, 168, w2,  w6,  w30);
   TEST_3R("dpsub_s.h",  24,  24, w3,  w15, w4);
   TEST_3R("dpsub_s.h",  32, 176, w4,  w4,  w4);
   TEST_3R("dpsub_s.h",  40,  24, w5,  w1,  w5);
   TEST_3R("dpsub_s.h",  48,  32, w6,  w25, w0);
   TEST_3R("dpsub_s.h",  56,  64, w7,  w30, w8);
   TEST_3R("dpsub_s.h",  64,  72, w8,  w21, w14);
   TEST_3R("dpsub_s.h",  72, 128, w9,  w28, w13);
   TEST_3R("dpsub_s.h",  80,  72, w10, w23, w25);
   TEST_3R("dpsub_s.h",  88,  56, w11, w18, w1);
   TEST_3R("dpsub_s.h",  96,   8, w12, w7,  w20);
   TEST_3R("dpsub_s.h", 104,  56, w13, w9,  w19);
   TEST_3R("dpsub_s.h", 112, 112, w14, w14, w25);
   TEST_3R("dpsub_s.h", 120, 136, w15, w25, w16);
   TEST_3R("dpsub_s.h", 128,  56, w16, w23, w9);
   TEST_3R("dpsub_s.h", 136, 176, w17, w24, w7);
   TEST_3R("dpsub_s.h", 144, 232, w18, w10, w28);
   TEST_3R("dpsub_s.h", 152,  40, w19, w25, w28);
   TEST_3R("dpsub_s.h", 160, 128, w20, w16, w19);
   TEST_3R("dpsub_s.h", 168, 160, w21, w30, w6);
   TEST_3R("dpsub_s.h", 176,   0, w22, w23, w13);
   TEST_3R("dpsub_s.h", 184,  48, w23, w22, w22);
   TEST_3R("dpsub_s.h", 192,  40, w24, w25, w17);
   TEST_3R("dpsub_s.h", 200, 216, w25, w17, w11);
   TEST_3R("dpsub_s.h", 208, 152, w26, w10, w2);
   TEST_3R("dpsub_s.h", 216, 176, w27, w3,  w26);
   TEST_3R("dpsub_s.h", 224, 224, w28, w5,  w13);
   TEST_3R("dpsub_s.h", 232, 160, w29, w24, w6);
   TEST_3R("dpsub_s.h", 240, 176, w30, w16, w22);
   TEST_3R("dpsub_s.h", 192, 168, w31, w1,  w20);
   TEST_3R("dpsub_s.w",   0,  72, w0,  w11, w23);
   TEST_3R("dpsub_s.w",   8,   0, w1,  w14, w19);
   TEST_3R("dpsub_s.w",  16,  88, w2,  w29, w4);
   TEST_3R("dpsub_s.w",  24, 176, w3,  w29, w14);
   TEST_3R("dpsub_s.w",  32, 112, w4,  w4,  w4);
   TEST_3R("dpsub_s.w",  40,  40, w5,  w17, w5);
   TEST_3R("dpsub_s.w",  48,  32, w6,  w22, w0);
   TEST_3R("dpsub_s.w",  56,  72, w7,  w11, w24);
   TEST_3R("dpsub_s.w",  64,  64, w8,  w28, w0);
   TEST_3R("dpsub_s.w",  72, 200, w9,  w20, w11);
   TEST_3R("dpsub_s.w",  80,  32, w10, w0,  w2);
   TEST_3R("dpsub_s.w",  88, 104, w11, w1,  w16);
   TEST_3R("dpsub_s.w",  96,  40, w12, w20, w14);
   TEST_3R("dpsub_s.w", 104, 104, w13, w18, w11);
   TEST_3R("dpsub_s.w", 112,  32, w14, w14, w19);
   TEST_3R("dpsub_s.w", 120, 192, w15, w12, w14);
   TEST_3R("dpsub_s.w", 128, 232, w16, w2,  w14);
   TEST_3R("dpsub_s.w", 136,  64, w17, w13, w6);
   TEST_3R("dpsub_s.w", 144, 112, w18, w9,  w14);
   TEST_3R("dpsub_s.w", 152, 136, w19, w10, w23);
   TEST_3R("dpsub_s.w", 160,  88, w20, w21, w19);
   TEST_3R("dpsub_s.w", 168,  24, w21, w23, w8);
   TEST_3R("dpsub_s.w", 176, 200, w22, w8,  w17);
   TEST_3R("dpsub_s.w", 184, 216, w23, w22, w22);
   TEST_3R("dpsub_s.w", 192, 200, w24, w17, w1);
   TEST_3R("dpsub_s.w", 200,  48, w25, w4,  w18);
   TEST_3R("dpsub_s.w", 208,   0, w26, w18, w25);
   TEST_3R("dpsub_s.w", 216, 160, w27, w0,  w4);
   TEST_3R("dpsub_s.w", 224,  72, w28, w6,  w25);
   TEST_3R("dpsub_s.w", 232,  48, w29, w20, w13);
   TEST_3R("dpsub_s.w", 240, 136, w30, w11, w22);
   TEST_3R("dpsub_s.w", 168,  32, w31, w30, w20);
   TEST_3R("dpsub_s.d",   0, 136, w0,  w28, w24);
   TEST_3R("dpsub_s.d",   8,   8, w1,  w18, w21);
   TEST_3R("dpsub_s.d",  16,  88, w2,  w19, w13);
   TEST_3R("dpsub_s.d",  24,  64, w3,  w5,  w17);
   TEST_3R("dpsub_s.d",  32, 168, w4,  w4,  w4);
   TEST_3R("dpsub_s.d",  40,  16, w5,  w24, w5);
   TEST_3R("dpsub_s.d",  48, 168, w6,  w3,  w12);
   TEST_3R("dpsub_s.d",  56,   8, w7,  w28, w9);
   TEST_3R("dpsub_s.d",  64, 184, w8,  w9,  w17);
   TEST_3R("dpsub_s.d",  72, 144, w9,  w0,  w13);
   TEST_3R("dpsub_s.d",  80, 184, w10, w31, w1);
   TEST_3R("dpsub_s.d",  88,  32, w11, w9,  w29);
   TEST_3R("dpsub_s.d",  96, 104, w12, w18, w15);
   TEST_3R("dpsub_s.d", 104, 136, w13, w2,  w25);
   TEST_3R("dpsub_s.d", 112,  88, w14, w14, w7);
   TEST_3R("dpsub_s.d", 120,  48, w15, w29, w6);
   TEST_3R("dpsub_s.d", 128, 152, w16, w15, w9);
   TEST_3R("dpsub_s.d", 136, 232, w17, w8,  w5);
   TEST_3R("dpsub_s.d", 144, 232, w18, w21, w14);
   TEST_3R("dpsub_s.d", 152,   0, w19, w13, w14);
   TEST_3R("dpsub_s.d", 160, 136, w20, w4,  w14);
   TEST_3R("dpsub_s.d", 168, 160, w21, w2,  w23);
   TEST_3R("dpsub_s.d", 176,  80, w22, w24, w10);
   TEST_3R("dpsub_s.d", 184,  16, w23, w4,  w4);
   TEST_3R("dpsub_s.d", 192, 160, w24, w7,  w29);
   TEST_3R("dpsub_s.d", 200,   0, w25, w15, w7);
   TEST_3R("dpsub_s.d", 208, 208, w26, w21, w10);
   TEST_3R("dpsub_s.d", 216, 216, w27, w30, w24);
   TEST_3R("dpsub_s.d", 224, 120, w28, w3,  w16);
   TEST_3R("dpsub_s.d", 232, 200, w29, w17, w25);
   TEST_3R("dpsub_s.d", 240,  56, w30, w0,  w16);
   TEST_3R("dpsub_s.d",  64, 112, w31, w14, w8);
   TEST_3R("dpsub_u.h",   0, 104, w0,  w31, w15);
   TEST_3R("dpsub_u.h",   8, 168, w1,  w23, w17);
   TEST_3R("dpsub_u.h",  16,  32, w2,  w11, w11);
   TEST_3R("dpsub_u.h",  24,  40, w3,  w24, w25);
   TEST_3R("dpsub_u.h",  32, 192, w4,  w14, w26);
   TEST_3R("dpsub_u.h",  40, 192, w5,  w13, w14);
   TEST_3R("dpsub_u.h",  48, 192, w6,  w13, w23);
   TEST_3R("dpsub_u.h",  56, 128, w7,  w8,  w2);
   TEST_3R("dpsub_u.h",  64, 160, w8,  w24, w3);
   TEST_3R("dpsub_u.h",  72, 120, w9,  w16, w31);
   TEST_3R("dpsub_u.h",  80, 184, w10, w2,  w30);
   TEST_3R("dpsub_u.h",  88, 152, w11, w28, w21);
   TEST_3R("dpsub_u.h",  96,   8, w12, w13, w1);
   TEST_3R("dpsub_u.h", 104, 112, w13, w17, w26);
   TEST_3R("dpsub_u.h", 112, 232, w14, w9,  w8);
   TEST_3R("dpsub_u.h", 120,  64, w15, w12, w15);
   TEST_3R("dpsub_u.h", 128, 192, w16, w26, w30);
   TEST_3R("dpsub_u.h", 136, 224, w17, w5,  w11);
   TEST_3R("dpsub_u.h", 144, 160, w18, w12, w3);
   TEST_3R("dpsub_u.h", 152, 176, w19, w3,  w22);
   TEST_3R("dpsub_u.h", 160,  64, w20, w22, w14);
   TEST_3R("dpsub_u.h", 168,  16, w21, w10, w28);
   TEST_3R("dpsub_u.h", 176, 112, w22, w11, w21);
   TEST_3R("dpsub_u.h", 184,   8, w23, w5,  w7);
   TEST_3R("dpsub_u.h", 192,  96, w24, w14, w19);
   TEST_3R("dpsub_u.h", 200, 128, w25, w3,  w14);
   TEST_3R("dpsub_u.h", 208,   8, w26, w26, w6);
   TEST_3R("dpsub_u.h", 216, 112, w27, w11, w18);
   TEST_3R("dpsub_u.h", 224,  40, w28, w23, w21);
   TEST_3R("dpsub_u.h", 232, 168, w29, w29, w29);
   TEST_3R("dpsub_u.h", 240, 216, w30, w9,  w0);
   TEST_3R("dpsub_u.h", 184,   0, w31, w20, w11);
   TEST_3R("dpsub_u.w",   0, 216, w0,  w7,  w17);
   TEST_3R("dpsub_u.w",   8, 104, w1,  w29, w3);
   TEST_3R("dpsub_u.w",  16,   8, w2,  w4,  w4);
   TEST_3R("dpsub_u.w",  24, 224, w3,  w29, w24);
   TEST_3R("dpsub_u.w",  32, 120, w4,  w1,  w6);
   TEST_3R("dpsub_u.w",  40, 152, w5,  w7,  w21);
   TEST_3R("dpsub_u.w",  48, 168, w6,  w24, w13);
   TEST_3R("dpsub_u.w",  56,  24, w7,  w2,  w8);
   TEST_3R("dpsub_u.w",  64, 192, w8,  w2,  w4);
   TEST_3R("dpsub_u.w",  72, 200, w9,  w23, w15);
   TEST_3R("dpsub_u.w",  80,  88, w10, w21, w23);
   TEST_3R("dpsub_u.w",  88,  88, w11, w31, w20);
   TEST_3R("dpsub_u.w",  96, 216, w12, w15, w24);
   TEST_3R("dpsub_u.w", 104, 208, w13, w12, w16);
   TEST_3R("dpsub_u.w", 112,  88, w14, w13, w22);
   TEST_3R("dpsub_u.w", 120, 168, w15, w21, w15);
   TEST_3R("dpsub_u.w", 128, 176, w16, w0,  w14);
   TEST_3R("dpsub_u.w", 136, 112, w17, w13, w29);
   TEST_3R("dpsub_u.w", 144, 168, w18, w21, w25);
   TEST_3R("dpsub_u.w", 152, 168, w19, w12, w16);
   TEST_3R("dpsub_u.w", 160,  48, w20, w21, w6);
   TEST_3R("dpsub_u.w", 168,  64, w21, w15, w5);
   TEST_3R("dpsub_u.w", 176, 136, w22, w12, w20);
   TEST_3R("dpsub_u.w", 184, 152, w23, w7,  w1);
   TEST_3R("dpsub_u.w", 192, 176, w24, w7,  w14);
   TEST_3R("dpsub_u.w", 200, 104, w25, w17, w3);
   TEST_3R("dpsub_u.w", 208, 224, w26, w26, w17);
   TEST_3R("dpsub_u.w", 216, 232, w27, w4,  w30);
   TEST_3R("dpsub_u.w", 224, 160, w28, w27, w19);
   TEST_3R("dpsub_u.w", 232,  32, w29, w29, w29);
   TEST_3R("dpsub_u.w", 240,  96, w30, w13, w17);
   TEST_3R("dpsub_u.w", 224,  72, w31, w22, w6);
   TEST_3R("dpsub_u.d",   0,  56, w0,  w21, w16);
   TEST_3R("dpsub_u.d",   8,  24, w1,  w5,  w22);
   TEST_3R("dpsub_u.d",  16, 224, w2,  w6,  w6);
   TEST_3R("dpsub_u.d",  24,  32, w3,  w15, w20);
   TEST_3R("dpsub_u.d",  32,  16, w4,  w1,  w24);
   TEST_3R("dpsub_u.d",  40, 184, w5,  w18, w10);
   TEST_3R("dpsub_u.d",  48,  96, w6,  w17, w25);
   TEST_3R("dpsub_u.d",  56, 136, w7,  w4,  w30);
   TEST_3R("dpsub_u.d",  64, 104, w8,  w17, w16);
   TEST_3R("dpsub_u.d",  72, 184, w9,  w7,  w22);
   TEST_3R("dpsub_u.d",  80, 216, w10, w29, w12);
   TEST_3R("dpsub_u.d",  88,  88, w11, w7,  w13);
   TEST_3R("dpsub_u.d",  96,  16, w12, w30, w22);
   TEST_3R("dpsub_u.d", 104,   8, w13, w17, w5);
   TEST_3R("dpsub_u.d", 112,   0, w14, w24, w6);
   TEST_3R("dpsub_u.d", 120, 216, w15, w25, w15);
   TEST_3R("dpsub_u.d", 128, 192, w16, w9,  w10);
   TEST_3R("dpsub_u.d", 136, 208, w17, w31, w14);
   TEST_3R("dpsub_u.d", 144, 144, w18, w9,  w0);
   TEST_3R("dpsub_u.d", 152,  72, w19, w24, w7);
   TEST_3R("dpsub_u.d", 160,  32, w20, w18, w5);
   TEST_3R("dpsub_u.d", 168,  32, w21, w28, w12);
   TEST_3R("dpsub_u.d", 176,  56, w22, w12, w10);
   TEST_3R("dpsub_u.d", 184,  40, w23, w1,  w28);
   TEST_3R("dpsub_u.d", 192,  32, w24, w11, w20);
   TEST_3R("dpsub_u.d", 200,   8, w25, w13, w3);
   TEST_3R("dpsub_u.d", 208, 200, w26, w26, w25);
   TEST_3R("dpsub_u.d", 216,  24, w27, w9,  w31);
   TEST_3R("dpsub_u.d", 224,  96, w28, w23, w3);
   TEST_3R("dpsub_u.d", 232, 160, w29, w29, w29);
   TEST_3R("dpsub_u.d", 240, 184, w30, w23, w13);
   TEST_3R("dpsub_u.d",  24, 120, w31, w1,  w4);
   TEST_3R("hadd_s.h",   0,  16, w0,  w3,  w17);
   TEST_3R("hadd_s.h",   8,  24, w1,  w24, w23);
   TEST_3R("hadd_s.h",  16, 176, w2,  w25, w15);
   TEST_3R("hadd_s.h",  24, 224, w3,  w1,  w22);
   TEST_3R("hadd_s.h",  32, 192, w4,  w11, w20);
   TEST_3R("hadd_s.h",  40,  56, w5,  w19, w10);
   TEST_3R("hadd_s.h",  48, 112, w6,  w19, w1);
   TEST_3R("hadd_s.h",  56, 120, w7,  w8,  w7);
   TEST_3R("hadd_s.h",  64, 192, w8,  w18, w0);
   TEST_3R("hadd_s.h",  72,  48, w9,  w31, w14);
   TEST_3R("hadd_s.h",  80, 176, w10, w2,  w31);
   TEST_3R("hadd_s.h",  88, 208, w11, w27, w22);
   TEST_3R("hadd_s.h",  96,  24, w12, w20, w6);
   TEST_3R("hadd_s.h", 104,   8, w13, w22, w28);
   TEST_3R("hadd_s.h", 112,  72, w14, w1,  w16);
   TEST_3R("hadd_s.h", 120, 216, w15, w20, w21);
   TEST_3R("hadd_s.h", 128,  80, w16, w16, w16);
   TEST_3R("hadd_s.h", 136, 200, w17, w9,  w27);
   TEST_3R("hadd_s.h", 144,  56, w18, w17, w23);
   TEST_3R("hadd_s.h", 152,   8, w19, w26, w23);
   TEST_3R("hadd_s.h", 160, 168, w20, w25, w6);
   TEST_3R("hadd_s.h", 168, 112, w21, w28, w5);
   TEST_3R("hadd_s.h", 176, 200, w22, w23, w28);
   TEST_3R("hadd_s.h", 184, 224, w23, w11, w2);
   TEST_3R("hadd_s.h", 192, 112, w24, w1,  w30);
   TEST_3R("hadd_s.h", 200, 192, w25, w2,  w15);
   TEST_3R("hadd_s.h", 208,  40, w26, w23, w4);
   TEST_3R("hadd_s.h", 216, 224, w27, w13, w13);
   TEST_3R("hadd_s.h", 224, 168, w28, w28, w20);
   TEST_3R("hadd_s.h", 232, 144, w29, w31, w25);
   TEST_3R("hadd_s.h", 240, 104, w30, w26, w18);
   TEST_3R("hadd_s.h", 168,  64, w31, w6,  w14);
   TEST_3R("hadd_s.w",   0, 128, w0,  w5,  w28);
   TEST_3R("hadd_s.w",   8, 112, w1,  w17, w30);
   TEST_3R("hadd_s.w",  16, 232, w2,  w18, w29);
   TEST_3R("hadd_s.w",  24,  56, w3,  w21, w12);
   TEST_3R("hadd_s.w",  32,  96, w4,  w12, w16);
   TEST_3R("hadd_s.w",  40, 200, w5,  w7,  w30);
   TEST_3R("hadd_s.w",  48, 128, w6,  w27, w29);
   TEST_3R("hadd_s.w",  56, 144, w7,  w26, w7);
   TEST_3R("hadd_s.w",  64, 168, w8,  w27, w20);
   TEST_3R("hadd_s.w",  72, 144, w9,  w22, w27);
   TEST_3R("hadd_s.w",  80, 168, w10, w23, w21);
   TEST_3R("hadd_s.w",  88,  56, w11, w19, w9);
   TEST_3R("hadd_s.w",  96, 176, w12, w18, w16);
   TEST_3R("hadd_s.w", 104, 160, w13, w15, w24);
   TEST_3R("hadd_s.w", 112, 176, w14, w27, w16);
   TEST_3R("hadd_s.w", 120,  40, w15, w11, w19);
   TEST_3R("hadd_s.w", 128, 184, w16, w16, w16);
   TEST_3R("hadd_s.w", 136,  64, w17, w28, w3);
   TEST_3R("hadd_s.w", 144,  88, w18, w3,  w29);
   TEST_3R("hadd_s.w", 152, 128, w19, w30, w17);
   TEST_3R("hadd_s.w", 160,  40, w20, w21, w12);
   TEST_3R("hadd_s.w", 168,  88, w21, w12, w1);
   TEST_3R("hadd_s.w", 176,  16, w22, w31, w10);
   TEST_3R("hadd_s.w", 184, 192, w23, w17, w26);
   TEST_3R("hadd_s.w", 192, 120, w24, w0,  w18);
   TEST_3R("hadd_s.w", 200, 168, w25, w27, w3);
   TEST_3R("hadd_s.w", 208,  80, w26, w7,  w22);
   TEST_3R("hadd_s.w", 216, 224, w27, w16, w16);
   TEST_3R("hadd_s.w", 224, 160, w28, w28, w7);
   TEST_3R("hadd_s.w", 232, 128, w29, w22, w4);
   TEST_3R("hadd_s.w", 240,  24, w30, w20, w21);
   TEST_3R("hadd_s.w", 176, 176, w31, w9,  w2);
   TEST_3R("hadd_s.d",   0,   0, w0,  w3,  w13);
   TEST_3R("hadd_s.d",   8, 192, w1,  w14, w19);
   TEST_3R("hadd_s.d",  16, 224, w2,  w8,  w25);
   TEST_3R("hadd_s.d",  24,  32, w3,  w27, w20);
   TEST_3R("hadd_s.d",  32, 184, w4,  w30, w16);
   TEST_3R("hadd_s.d",  40, 144, w5,  w20, w26);
   TEST_3R("hadd_s.d",  48, 136, w6,  w27, w17);
   TEST_3R("hadd_s.d",  56, 208, w7,  w31, w7);
   TEST_3R("hadd_s.d",  64, 232, w8,  w18, w20);
   TEST_3R("hadd_s.d",  72, 176, w9,  w27, w22);
   TEST_3R("hadd_s.d",  80,  72, w10, w17, w26);
   TEST_3R("hadd_s.d",  88, 112, w11, w6,  w8);
   TEST_3R("hadd_s.d",  96, 192, w12, w16, w10);
   TEST_3R("hadd_s.d", 104,  96, w13, w11, w30);
   TEST_3R("hadd_s.d", 112, 200, w14, w9,  w31);
   TEST_3R("hadd_s.d", 120, 224, w15, w2,  w25);
   TEST_3R("hadd_s.d", 128, 152, w16, w16, w16);
   TEST_3R("hadd_s.d", 136,   8, w17, w10, w3);
   TEST_3R("hadd_s.d", 144,  64, w18, w15, w21);
   TEST_3R("hadd_s.d", 152,   0, w19, w12, w16);
   TEST_3R("hadd_s.d", 160, 224, w20, w29, w1);
   TEST_3R("hadd_s.d", 168,  88, w21, w28, w7);
   TEST_3R("hadd_s.d", 176,  72, w22, w13, w20);
   TEST_3R("hadd_s.d", 184, 160, w23, w24, w7);
   TEST_3R("hadd_s.d", 192, 200, w24, w22, w29);
   TEST_3R("hadd_s.d", 200,  40, w25, w5,  w29);
   TEST_3R("hadd_s.d", 208,  32, w26, w7,  w22);
   TEST_3R("hadd_s.d", 216,  64, w27, w5,  w5);
   TEST_3R("hadd_s.d", 224, 224, w28, w28, w21);
   TEST_3R("hadd_s.d", 232,  48, w29, w16, w10);
   TEST_3R("hadd_s.d", 240, 168, w30, w28, w27);
   TEST_3R("hadd_s.d",   0,  24, w31, w25, w28);
   TEST_3R("hadd_u.h",   0, 192, w0,  w25, w17);
   TEST_3R("hadd_u.h",   8, 184, w1,  w16, w31);
   TEST_3R("hadd_u.h",  16,  96, w2,  w26, w10);
   TEST_3R("hadd_u.h",  24, 192, w3,  w21, w3);
   TEST_3R("hadd_u.h",  32,  64, w4,  w4,  w4);
   TEST_3R("hadd_u.h",  40,  40, w5,  w5,  w3);
   TEST_3R("hadd_u.h",  48,  64, w6,  w25, w9);
   TEST_3R("hadd_u.h",  56, 168, w7,  w6,  w30);
   TEST_3R("hadd_u.h",  64,   0, w8,  w24, w19);
   TEST_3R("hadd_u.h",  72, 184, w9,  w27, w20);
   TEST_3R("hadd_u.h",  80,   8, w10, w28, w20);
   TEST_3R("hadd_u.h",  88,  32, w11, w2,  w22);
   TEST_3R("hadd_u.h",  96,  80, w12, w19, w6);
   TEST_3R("hadd_u.h", 104,  72, w13, w17, w1);
   TEST_3R("hadd_u.h", 112,  24, w14, w3,  w22);
   TEST_3R("hadd_u.h", 120, 184, w15, w7,  w25);
   TEST_3R("hadd_u.h", 128,   8, w16, w0,  w2);
   TEST_3R("hadd_u.h", 136,  48, w17, w6,  w0);
   TEST_3R("hadd_u.h", 144,  48, w18, w30, w19);
   TEST_3R("hadd_u.h", 152, 112, w19, w25, w7);
   TEST_3R("hadd_u.h", 160,   0, w20, w21, w27);
   TEST_3R("hadd_u.h", 168,  72, w21, w23, w29);
   TEST_3R("hadd_u.h", 176, 200, w22, w10, w17);
   TEST_3R("hadd_u.h", 184, 168, w23, w28, w2);
   TEST_3R("hadd_u.h", 192, 224, w24, w5,  w5);
   TEST_3R("hadd_u.h", 200, 184, w25, w23, w12);
   TEST_3R("hadd_u.h", 208, 128, w26, w15, w12);
   TEST_3R("hadd_u.h", 216, 144, w27, w26, w18);
   TEST_3R("hadd_u.h", 224,  80, w28, w12, w17);
   TEST_3R("hadd_u.h", 232, 232, w29, w18, w10);
   TEST_3R("hadd_u.h", 240, 192, w30, w23, w0);
   TEST_3R("hadd_u.h", 208, 112, w31, w25, w23);
   TEST_3R("hadd_u.w",   0, 168, w0,  w2,  w21);
   TEST_3R("hadd_u.w",   8, 216, w1,  w30, w23);
   TEST_3R("hadd_u.w",  16,  80, w2,  w23, w28);
   TEST_3R("hadd_u.w",  24,  72, w3,  w14, w3);
   TEST_3R("hadd_u.w",  32, 144, w4,  w4,  w4);
   TEST_3R("hadd_u.w",  40,  80, w5,  w5,  w29);
   TEST_3R("hadd_u.w",  48,  88, w6,  w3,  w23);
   TEST_3R("hadd_u.w",  56,   8, w7,  w20, w4);
   TEST_3R("hadd_u.w",  64,   0, w8,  w23, w22);
   TEST_3R("hadd_u.w",  72, 160, w9,  w2,  w13);
   TEST_3R("hadd_u.w",  80, 200, w10, w9,  w6);
   TEST_3R("hadd_u.w",  88,  40, w11, w13, w23);
   TEST_3R("hadd_u.w",  96, 232, w12, w2,  w6);
   TEST_3R("hadd_u.w", 104, 144, w13, w25, w21);
   TEST_3R("hadd_u.w", 112,  32, w14, w21, w26);
   TEST_3R("hadd_u.w", 120,  72, w15, w30, w13);
   TEST_3R("hadd_u.w", 128,  56, w16, w20, w21);
   TEST_3R("hadd_u.w", 136, 176, w17, w4,  w25);
   TEST_3R("hadd_u.w", 144, 184, w18, w28, w15);
   TEST_3R("hadd_u.w", 152, 216, w19, w30, w28);
   TEST_3R("hadd_u.w", 160, 176, w20, w7,  w2);
   TEST_3R("hadd_u.w", 168,  96, w21, w20, w25);
   TEST_3R("hadd_u.w", 176, 168, w22, w0,  w15);
   TEST_3R("hadd_u.w", 184, 112, w23, w21, w2);
   TEST_3R("hadd_u.w", 192, 144, w24, w15, w15);
   TEST_3R("hadd_u.w", 200, 224, w25, w3,  w28);
   TEST_3R("hadd_u.w", 208,  32, w26, w23, w13);
   TEST_3R("hadd_u.w", 216,  40, w27, w19, w17);
   TEST_3R("hadd_u.w", 224,  24, w28, w8,  w13);
   TEST_3R("hadd_u.w", 232, 120, w29, w1,  w12);
   TEST_3R("hadd_u.w", 240,  88, w30, w29, w19);
   TEST_3R("hadd_u.w",  40, 128, w31, w20, w8);
   TEST_3R("hadd_u.d",   0,   0, w0,  w30, w23);
   TEST_3R("hadd_u.d",   8, 120, w1,  w14, w13);
   TEST_3R("hadd_u.d",  16,  24, w2,  w19, w28);
   TEST_3R("hadd_u.d",  24, 152, w3,  w22, w3);
   TEST_3R("hadd_u.d",  32, 120, w4,  w4,  w4);
   TEST_3R("hadd_u.d",  40, 208, w5,  w5,  w14);
   TEST_3R("hadd_u.d",  48, 192, w6,  w18, w1);
   TEST_3R("hadd_u.d",  56,   0, w7,  w2,  w10);
   TEST_3R("hadd_u.d",  64, 208, w8,  w1,  w11);
   TEST_3R("hadd_u.d",  72,  48, w9,  w28, w8);
   TEST_3R("hadd_u.d",  80, 200, w10, w26, w28);
   TEST_3R("hadd_u.d",  88,  56, w11, w18, w4);
   TEST_3R("hadd_u.d",  96,  88, w12, w9,  w27);
   TEST_3R("hadd_u.d", 104, 104, w13, w22, w21);
   TEST_3R("hadd_u.d", 112,   0, w14, w19, w17);
   TEST_3R("hadd_u.d", 120, 224, w15, w12, w13);
   TEST_3R("hadd_u.d", 128, 224, w16, w18, w0);
   TEST_3R("hadd_u.d", 136, 184, w17, w9,  w2);
   TEST_3R("hadd_u.d", 144,  32, w18, w14, w3);
   TEST_3R("hadd_u.d", 152,  80, w19, w31, w15);
   TEST_3R("hadd_u.d", 160, 160, w20, w26, w11);
   TEST_3R("hadd_u.d", 168, 216, w21, w12, w15);
   TEST_3R("hadd_u.d", 176, 176, w22, w21, w10);
   TEST_3R("hadd_u.d", 184,  48, w23, w12, w31);
   TEST_3R("hadd_u.d", 192,  48, w24, w31, w31);
   TEST_3R("hadd_u.d", 200,   8, w25, w3,  w11);
   TEST_3R("hadd_u.d", 208,   8, w26, w19, w29);
   TEST_3R("hadd_u.d", 216,  96, w27, w5,  w6);
   TEST_3R("hadd_u.d", 224,  48, w28, w1,  w21);
   TEST_3R("hadd_u.d", 232,   0, w29, w8,  w20);
   TEST_3R("hadd_u.d", 240, 152, w30, w23, w24);
   TEST_3R("hadd_u.d",   0,  40, w31, w2,  w9);
   TEST_3R("hsub_s.h",   0, 224, w0,  w26, w10);
   TEST_3R("hsub_s.h",   8,  32, w1,  w6,  w16);
   TEST_3R("hsub_s.h",  16, 144, w2,  w10, w14);
   TEST_3R("hsub_s.h",  24,   8, w3,  w22, w12);
   TEST_3R("hsub_s.h",  32,  32, w4,  w4,  w4);
   TEST_3R("hsub_s.h",  40,  88, w5,  w19, w29);
   TEST_3R("hsub_s.h",  48,  32, w6,  w14, w3);
   TEST_3R("hsub_s.h",  56, 136, w7,  w9,  w18);
   TEST_3R("hsub_s.h",  64, 224, w8,  w16, w3);
   TEST_3R("hsub_s.h",  72,   8, w9,  w20, w2);
   TEST_3R("hsub_s.h",  80, 224, w10, w6,  w22);
   TEST_3R("hsub_s.h",  88,  80, w11, w0,  w4);
   TEST_3R("hsub_s.h",  96,  80, w12, w16, w5);
   TEST_3R("hsub_s.h", 104,  24, w13, w30, w7);
   TEST_3R("hsub_s.h", 112, 200, w14, w22, w9);
   TEST_3R("hsub_s.h", 120, 184, w15, w19, w3);
   TEST_3R("hsub_s.h", 128,  32, w16, w22, w4);
   TEST_3R("hsub_s.h", 136, 104, w17, w8,  w6);
   TEST_3R("hsub_s.h", 144, 216, w18, w21, w26);
   TEST_3R("hsub_s.h", 152,  96, w19, w0,  w4);
   TEST_3R("hsub_s.h", 160, 176, w20, w0,  w4);
   TEST_3R("hsub_s.h", 168, 200, w21, w7,  w12);
   TEST_3R("hsub_s.h", 176, 152, w22, w19, w25);
   TEST_3R("hsub_s.h", 184, 152, w23, w30, w15);
   TEST_3R("hsub_s.h", 192, 104, w24, w29, w2);
   TEST_3R("hsub_s.h", 200, 232, w25, w9,  w9);
   TEST_3R("hsub_s.h", 208, 144, w26, w16, w31);
   TEST_3R("hsub_s.h", 216,   8, w27, w1,  w5);
   TEST_3R("hsub_s.h", 224, 120, w28, w23, w28);
   TEST_3R("hsub_s.h", 232,  72, w29, w26, w23);
   TEST_3R("hsub_s.h", 240,   0, w30, w30, w26);
   TEST_3R("hsub_s.h",  96, 112, w31, w2,  w1);
   TEST_3R("hsub_s.w",   0, 112, w0,  w14, w11);
   TEST_3R("hsub_s.w",   8,  96, w1,  w31, w9);
   TEST_3R("hsub_s.w",  16, 200, w2,  w8,  w6);
   TEST_3R("hsub_s.w",  24,  64, w3,  w20, w16);
   TEST_3R("hsub_s.w",  32,  96, w4,  w4,  w4);
   TEST_3R("hsub_s.w",  40, 192, w5,  w15, w18);
   TEST_3R("hsub_s.w",  48, 152, w6,  w21, w30);
   TEST_3R("hsub_s.w",  56, 224, w7,  w20, w24);
   TEST_3R("hsub_s.w",  64, 152, w8,  w20, w22);
   TEST_3R("hsub_s.w",  72, 144, w9,  w20, w25);
   TEST_3R("hsub_s.w",  80,  56, w10, w27, w16);
   TEST_3R("hsub_s.w",  88,  72, w11, w27, w5);
   TEST_3R("hsub_s.w",  96, 208, w12, w5,  w28);
   TEST_3R("hsub_s.w", 104, 208, w13, w11, w22);
   TEST_3R("hsub_s.w", 112, 184, w14, w27, w8);
   TEST_3R("hsub_s.w", 120,  16, w15, w11, w26);
   TEST_3R("hsub_s.w", 128, 168, w16, w0,  w25);
   TEST_3R("hsub_s.w", 136,  24, w17, w20, w8);
   TEST_3R("hsub_s.w", 144, 176, w18, w31, w28);
   TEST_3R("hsub_s.w", 152,  64, w19, w15, w24);
   TEST_3R("hsub_s.w", 160, 200, w20, w13, w19);
   TEST_3R("hsub_s.w", 168,  32, w21, w19, w14);
   TEST_3R("hsub_s.w", 176, 168, w22, w15, w17);
   TEST_3R("hsub_s.w", 184, 104, w23, w5,  w8);
   TEST_3R("hsub_s.w", 192, 176, w24, w13, w3);
   TEST_3R("hsub_s.w", 200, 208, w25, w8,  w8);
   TEST_3R("hsub_s.w", 208,  16, w26, w4,  w1);
   TEST_3R("hsub_s.w", 216, 160, w27, w24, w18);
   TEST_3R("hsub_s.w", 224, 136, w28, w1,  w28);
   TEST_3R("hsub_s.w", 232, 192, w29, w17, w27);
   TEST_3R("hsub_s.w", 240,   8, w30, w30, w21);
   TEST_3R("hsub_s.w", 144,  88, w31, w14, w9);
   TEST_3R("hsub_s.d",   0,   0, w0,  w23, w12);
   TEST_3R("hsub_s.d",   8, 128, w1,  w9,  w22);
   TEST_3R("hsub_s.d",  16, 208, w2,  w4,  w21);
   TEST_3R("hsub_s.d",  24, 168, w3,  w12, w25);
   TEST_3R("hsub_s.d",  32,  40, w4,  w4,  w4);
   TEST_3R("hsub_s.d",  40, 152, w5,  w26, w3);
   TEST_3R("hsub_s.d",  48, 168, w6,  w12, w4);
   TEST_3R("hsub_s.d",  56, 224, w7,  w29, w1);
   TEST_3R("hsub_s.d",  64, 112, w8,  w30, w23);
   TEST_3R("hsub_s.d",  72, 200, w9,  w13, w0);
   TEST_3R("hsub_s.d",  80, 200, w10, w14, w23);
   TEST_3R("hsub_s.d",  88, 128, w11, w31, w0);
   TEST_3R("hsub_s.d",  96, 160, w12, w22, w18);
   TEST_3R("hsub_s.d", 104,   8, w13, w26, w7);
   TEST_3R("hsub_s.d", 112, 176, w14, w6,  w0);
   TEST_3R("hsub_s.d", 120,  40, w15, w19, w26);
   TEST_3R("hsub_s.d", 128,  72, w16, w18, w6);
   TEST_3R("hsub_s.d", 136,  72, w17, w12, w3);
   TEST_3R("hsub_s.d", 144,  32, w18, w2,  w5);
   TEST_3R("hsub_s.d", 152, 112, w19, w15, w5);
   TEST_3R("hsub_s.d", 160, 184, w20, w29, w28);
   TEST_3R("hsub_s.d", 168, 144, w21, w29, w27);
   TEST_3R("hsub_s.d", 176,  72, w22, w15, w16);
   TEST_3R("hsub_s.d", 184, 128, w23, w22, w11);
   TEST_3R("hsub_s.d", 192,  96, w24, w22, w16);
   TEST_3R("hsub_s.d", 200, 216, w25, w16, w16);
   TEST_3R("hsub_s.d", 208,  48, w26, w24, w22);
   TEST_3R("hsub_s.d", 216, 128, w27, w5,  w25);
   TEST_3R("hsub_s.d", 224, 136, w28, w7,  w28);
   TEST_3R("hsub_s.d", 232,  72, w29, w24, w11);
   TEST_3R("hsub_s.d", 240,  88, w30, w30, w29);
   TEST_3R("hsub_s.d",  80,  32, w31, w8,  w26);
   TEST_3R("hsub_u.h",   0, 144, w0,  w29, w27);
   TEST_3R("hsub_u.h",   8, 112, w1,  w18, w8);
   TEST_3R("hsub_u.h",  16, 176, w2,  w31, w1);
   TEST_3R("hsub_u.h",  24, 136, w3,  w26, w30);
   TEST_3R("hsub_u.h",  32,  64, w4,  w31, w17);
   TEST_3R("hsub_u.h",  40, 216, w5,  w15, w6);
   TEST_3R("hsub_u.h",  48, 176, w6,  w26, w26);
   TEST_3R("hsub_u.h",  56, 216, w7,  w18, w25);
   TEST_3R("hsub_u.h",  64, 144, w8,  w17, w29);
   TEST_3R("hsub_u.h",  72, 192, w9,  w30, w8);
   TEST_3R("hsub_u.h",  80, 160, w10, w23, w29);
   TEST_3R("hsub_u.h",  88, 160, w11, w18, w13);
   TEST_3R("hsub_u.h",  96, 144, w12, w27, w5);
   TEST_3R("hsub_u.h", 104,  56, w13, w28, w7);
   TEST_3R("hsub_u.h", 112,  56, w14, w27, w18);
   TEST_3R("hsub_u.h", 120,  88, w15, w12, w19);
   TEST_3R("hsub_u.h", 128,  80, w16, w18, w0);
   TEST_3R("hsub_u.h", 136,  96, w17, w17, w7);
   TEST_3R("hsub_u.h", 144,  64, w18, w16, w4);
   TEST_3R("hsub_u.h", 152, 224, w19, w13, w8);
   TEST_3R("hsub_u.h", 160, 104, w20, w21, w13);
   TEST_3R("hsub_u.h", 168, 168, w21, w18, w15);
   TEST_3R("hsub_u.h", 176, 176, w22, w0,  w4);
   TEST_3R("hsub_u.h", 184, 160, w23, w23, w23);
   TEST_3R("hsub_u.h", 192,  24, w24, w3,  w24);
   TEST_3R("hsub_u.h", 200,  24, w25, w6,  w30);
   TEST_3R("hsub_u.h", 208, 208, w26, w20, w10);
   TEST_3R("hsub_u.h", 216,   0, w27, w17, w28);
   TEST_3R("hsub_u.h", 224,  96, w28, w8,  w3);
   TEST_3R("hsub_u.h", 232, 168, w29, w24, w8);
   TEST_3R("hsub_u.h", 240,  24, w30, w5,  w16);
   TEST_3R("hsub_u.h", 232, 128, w31, w26, w30);
   TEST_3R("hsub_u.w",   0, 104, w0,  w13, w17);
   TEST_3R("hsub_u.w",   8, 144, w1,  w17, w24);
   TEST_3R("hsub_u.w",  16, 168, w2,  w9,  w27);
   TEST_3R("hsub_u.w",  24,  72, w3,  w16, w26);
   TEST_3R("hsub_u.w",  32,   0, w4,  w13, w21);
   TEST_3R("hsub_u.w",  40, 192, w5,  w31, w29);
   TEST_3R("hsub_u.w",  48,  96, w6,  w4,  w4);
   TEST_3R("hsub_u.w",  56, 168, w7,  w12, w13);
   TEST_3R("hsub_u.w",  64, 112, w8,  w29, w24);
   TEST_3R("hsub_u.w",  72, 112, w9,  w27, w29);
   TEST_3R("hsub_u.w",  80,  88, w10, w8,  w14);
   TEST_3R("hsub_u.w",  88, 232, w11, w26, w6);
   TEST_3R("hsub_u.w",  96,  40, w12, w3,  w2);
   TEST_3R("hsub_u.w", 104, 224, w13, w19, w28);
   TEST_3R("hsub_u.w", 112, 144, w14, w23, w0);
   TEST_3R("hsub_u.w", 120,  64, w15, w12, w1);
   TEST_3R("hsub_u.w", 128, 192, w16, w9,  w6);
   TEST_3R("hsub_u.w", 136,  16, w17, w17, w30);
   TEST_3R("hsub_u.w", 144, 168, w18, w20, w24);
   TEST_3R("hsub_u.w", 152,  72, w19, w13, w12);
   TEST_3R("hsub_u.w", 160, 224, w20, w10, w13);
   TEST_3R("hsub_u.w", 168,  88, w21, w25, w26);
   TEST_3R("hsub_u.w", 176,   0, w22, w31, w24);
   TEST_3R("hsub_u.w", 184, 144, w23, w23, w23);
   TEST_3R("hsub_u.w", 192, 208, w24, w20, w24);
   TEST_3R("hsub_u.w", 200, 104, w25, w29, w12);
   TEST_3R("hsub_u.w", 208, 216, w26, w30, w16);
   TEST_3R("hsub_u.w", 216, 208, w27, w31, w20);
   TEST_3R("hsub_u.w", 224, 176, w28, w5,  w27);
   TEST_3R("hsub_u.w", 232,  72, w29, w24, w16);
   TEST_3R("hsub_u.w", 240, 192, w30, w7,  w29);
   TEST_3R("hsub_u.w", 208,  64, w31, w18, w7);
   TEST_3R("hsub_u.d",   0, 112, w0,  w28, w18);
   TEST_3R("hsub_u.d",   8,  16, w1,  w20, w2);
   TEST_3R("hsub_u.d",  16, 216, w2,  w9,  w6);
   TEST_3R("hsub_u.d",  24, 200, w3,  w21, w2);
   TEST_3R("hsub_u.d",  32, 200, w4,  w5,  w10);
   TEST_3R("hsub_u.d",  40,  64, w5,  w25, w27);
   TEST_3R("hsub_u.d",  48, 120, w6,  w21, w21);
   TEST_3R("hsub_u.d",  56, 192, w7,  w26, w5);
   TEST_3R("hsub_u.d",  64,  24, w8,  w1,  w2);
   TEST_3R("hsub_u.d",  72, 168, w9,  w19, w11);
   TEST_3R("hsub_u.d",  80, 152, w10, w7,  w27);
   TEST_3R("hsub_u.d",  88, 136, w11, w4,  w19);
   TEST_3R("hsub_u.d",  96,  96, w12, w25, w21);
   TEST_3R("hsub_u.d", 104,  24, w13, w31, w4);
   TEST_3R("hsub_u.d", 112, 200, w14, w27, w6);
   TEST_3R("hsub_u.d", 120,  48, w15, w6,  w0);
   TEST_3R("hsub_u.d", 128,  16, w16, w26, w1);
   TEST_3R("hsub_u.d", 136, 192, w17, w17, w3);
   TEST_3R("hsub_u.d", 144, 232, w18, w30, w14);
   TEST_3R("hsub_u.d", 152, 104, w19, w8,  w21);
   TEST_3R("hsub_u.d", 160, 128, w20, w18, w17);
   TEST_3R("hsub_u.d", 168,  40, w21, w29, w24);
   TEST_3R("hsub_u.d", 176,   8, w22, w15, w14);
   TEST_3R("hsub_u.d", 184, 216, w23, w23, w23);
   TEST_3R("hsub_u.d", 192, 192, w24, w13, w24);
   TEST_3R("hsub_u.d", 200, 200, w25, w6,  w8);
   TEST_3R("hsub_u.d", 208, 120, w26, w20, w15);
   TEST_3R("hsub_u.d", 216,   8, w27, w6,  w9);
   TEST_3R("hsub_u.d", 224,  80, w28, w27, w13);
   TEST_3R("hsub_u.d", 232,  72, w29, w25, w27);
   TEST_3R("hsub_u.d", 240,  48, w30, w1,  w17);
   TEST_3R("hsub_u.d",  32, 184, w31, w19, w2);
   TEST_3R("maddv.b",   0, 144, w0,  w1,  w8);
   TEST_3R("maddv.b",   8,  24, w1,  w14, w27);
   TEST_3R("maddv.b",  16,  88, w2,  w23, w21);
   TEST_3R("maddv.b",  24,  96, w3,  w6,  w14);
   TEST_3R("maddv.b",  32,   0, w4,  w15, w9);
   TEST_3R("maddv.b",  40,  72, w5,  w28, w25);
   TEST_3R("maddv.b",  48, 144, w6,  w24, w24);
   TEST_3R("maddv.b",  56, 200, w7,  w10, w9);
   TEST_3R("maddv.b",  64,  16, w8,  w29, w11);
   TEST_3R("maddv.b",  72, 152, w9,  w14, w2);
   TEST_3R("maddv.b",  80, 168, w10, w6,  w9);
   TEST_3R("maddv.b",  88, 120, w11, w14, w29);
   TEST_3R("maddv.b",  96, 128, w12, w10, w24);
   TEST_3R("maddv.b", 104, 176, w13, w31, w7);
   TEST_3R("maddv.b", 112, 112, w14, w13, w29);
   TEST_3R("maddv.b", 120,  16, w15, w23, w13);
   TEST_3R("maddv.b", 128, 144, w16, w23, w10);
   TEST_3R("maddv.b", 136, 224, w17, w1,  w19);
   TEST_3R("maddv.b", 144,   8, w18, w31, w30);
   TEST_3R("maddv.b", 152,  48, w19, w19, w13);
   TEST_3R("maddv.b", 160, 120, w20, w21, w19);
   TEST_3R("maddv.b", 168,  96, w21, w16, w2);
   TEST_3R("maddv.b", 176,  96, w22, w25, w12);
   TEST_3R("maddv.b", 184, 216, w23, w23, w23);
   TEST_3R("maddv.b", 192,  64, w24, w11, w24);
   TEST_3R("maddv.b", 200,  16, w25, w0,  w24);
   TEST_3R("maddv.b", 208, 208, w26, w22, w15);
   TEST_3R("maddv.b", 216, 104, w27, w9,  w0);
   TEST_3R("maddv.b", 224,  88, w28, w19, w7);
   TEST_3R("maddv.b", 232,  56, w29, w7,  w27);
   TEST_3R("maddv.b", 240,  32, w30, w5,  w22);
   TEST_3R("maddv.b",   0, 216, w31, w6,  w11);
   TEST_3R("maddv.h",   0, 216, w0,  w27, w12);
   TEST_3R("maddv.h",   8,  72, w1,  w21, w24);
   TEST_3R("maddv.h",  16,   8, w2,  w15, w3);
   TEST_3R("maddv.h",  24,  32, w3,  w15, w27);
   TEST_3R("maddv.h",  32, 112, w4,  w6,  w11);
   TEST_3R("maddv.h",  40,  88, w5,  w15, w11);
   TEST_3R("maddv.h",  48, 208, w6,  w2,  w2);
   TEST_3R("maddv.h",  56, 112, w7,  w9,  w14);
   TEST_3R("maddv.h",  64,  24, w8,  w15, w4);
   TEST_3R("maddv.h",  72, 112, w9,  w21, w16);
   TEST_3R("maddv.h",  80,  56, w10, w6,  w11);
   TEST_3R("maddv.h",  88,  48, w11, w30, w0);
   TEST_3R("maddv.h",  96,  40, w12, w22, w15);
   TEST_3R("maddv.h", 104, 192, w13, w21, w31);
   TEST_3R("maddv.h", 112,  80, w14, w25, w5);
   TEST_3R("maddv.h", 120, 200, w15, w20, w12);
   TEST_3R("maddv.h", 128, 136, w16, w22, w30);
   TEST_3R("maddv.h", 136,   8, w17, w0,  w12);
   TEST_3R("maddv.h", 144, 144, w18, w15, w17);
   TEST_3R("maddv.h", 152, 128, w19, w19, w4);
   TEST_3R("maddv.h", 160,  88, w20, w8,  w10);
   TEST_3R("maddv.h", 168, 136, w21, w7,  w8);
   TEST_3R("maddv.h", 176,   8, w22, w31, w30);
   TEST_3R("maddv.h", 184,  56, w23, w23, w23);
   TEST_3R("maddv.h", 192, 216, w24, w20, w24);
   TEST_3R("maddv.h", 200, 192, w25, w15, w13);
   TEST_3R("maddv.h", 208,  96, w26, w16, w29);
   TEST_3R("maddv.h", 216,  56, w27, w28, w11);
   TEST_3R("maddv.h", 224, 232, w28, w27, w3);
   TEST_3R("maddv.h", 232, 216, w29, w7,  w14);
   TEST_3R("maddv.h", 240, 104, w30, w24, w3);
   TEST_3R("maddv.h", 144, 168, w31, w25, w11);
   TEST_3R("maddv.w",   0,  48, w0,  w18, w17);
   TEST_3R("maddv.w",   8,  56, w1,  w17, w16);
   TEST_3R("maddv.w",  16, 152, w2,  w11, w4);
   TEST_3R("maddv.w",  24, 216, w3,  w26, w17);
   TEST_3R("maddv.w",  32,  80, w4,  w11, w14);
   TEST_3R("maddv.w",  40,   8, w5,  w7,  w26);
   TEST_3R("maddv.w",  48, 120, w6,  w2,  w2);
   TEST_3R("maddv.w",  56,  88, w7,  w22, w10);
   TEST_3R("maddv.w",  64, 200, w8,  w16, w2);
   TEST_3R("maddv.w",  72,  88, w9,  w14, w28);
   TEST_3R("maddv.w",  80,  56, w10, w23, w2);
   TEST_3R("maddv.w",  88,  24, w11, w9,  w21);
   TEST_3R("maddv.w",  96, 168, w12, w25, w4);
   TEST_3R("maddv.w", 104,  80, w13, w29, w15);
   TEST_3R("maddv.w", 112, 184, w14, w27, w29);
   TEST_3R("maddv.w", 120, 192, w15, w22, w23);
   TEST_3R("maddv.w", 128,  72, w16, w24, w20);
   TEST_3R("maddv.w", 136, 168, w17, w2,  w0);
   TEST_3R("maddv.w", 144,   8, w18, w5,  w15);
   TEST_3R("maddv.w", 152, 168, w19, w19, w1);
   TEST_3R("maddv.w", 160,  96, w20, w18, w3);
   TEST_3R("maddv.w", 168, 128, w21, w27, w24);
   TEST_3R("maddv.w", 176,  56, w22, w20, w28);
   TEST_3R("maddv.w", 184,  16, w23, w23, w23);
   TEST_3R("maddv.w", 192,  16, w24, w12, w24);
   TEST_3R("maddv.w", 200, 200, w25, w31, w7);
   TEST_3R("maddv.w", 208, 176, w26, w28, w2);
   TEST_3R("maddv.w", 216, 200, w27, w19, w8);
   TEST_3R("maddv.w", 224,  80, w28, w8,  w4);
   TEST_3R("maddv.w", 232, 208, w29, w8,  w16);
   TEST_3R("maddv.w", 240, 176, w30, w24, w10);
   TEST_3R("maddv.w", 144,   8, w31, w1,  w28);
   TEST_3R("maddv.d",   0,  40, w0,  w23, w1);
   TEST_3R("maddv.d",   8, 216, w1,  w11, w29);
   TEST_3R("maddv.d",  16, 232, w2,  w28, w9);
   TEST_3R("maddv.d",  24, 200, w3,  w28, w16);
   TEST_3R("maddv.d",  32,   8, w4,  w24, w18);
   TEST_3R("maddv.d",  40, 216, w5,  w12, w26);
   TEST_3R("maddv.d",  48, 152, w6,  w20, w20);
   TEST_3R("maddv.d",  56,   8, w7,  w26, w28);
   TEST_3R("maddv.d",  64, 104, w8,  w31, w20);
   TEST_3R("maddv.d",  72, 208, w9,  w5,  w22);
   TEST_3R("maddv.d",  80,  88, w10, w14, w13);
   TEST_3R("maddv.d",  88, 216, w11, w15, w25);
   TEST_3R("maddv.d",  96, 224, w12, w13, w1);
   TEST_3R("maddv.d", 104, 128, w13, w22, w10);
   TEST_3R("maddv.d", 112,  24, w14, w7,  w2);
   TEST_3R("maddv.d", 120, 160, w15, w25, w31);
   TEST_3R("maddv.d", 128, 232, w16, w20, w26);
   TEST_3R("maddv.d", 136, 208, w17, w18, w20);
   TEST_3R("maddv.d", 144, 200, w18, w1,  w20);
   TEST_3R("maddv.d", 152, 152, w19, w19, w26);
   TEST_3R("maddv.d", 160, 120, w20, w16, w15);
   TEST_3R("maddv.d", 168, 192, w21, w30, w28);
   TEST_3R("maddv.d", 176,   0, w22, w23, w21);
   TEST_3R("maddv.d", 184, 104, w23, w23, w23);
   TEST_3R("maddv.d", 192, 216, w24, w10, w24);
   TEST_3R("maddv.d", 200,  80, w25, w3,  w27);
   TEST_3R("maddv.d", 208,  88, w26, w5,  w4);
   TEST_3R("maddv.d", 216,  88, w27, w5,  w26);
   TEST_3R("maddv.d", 224,  16, w28, w31, w3);
   TEST_3R("maddv.d", 232,  64, w29, w19, w9);
   TEST_3R("maddv.d", 240, 216, w30, w7,  w4);
   TEST_3R("maddv.d",  88, 104, w31, w1,  w20);
   TEST_3R("max_a.b",   0,  80, w0,  w5,  w0);
   TEST_3R("max_a.b",   8, 112, w1,  w8,  w0);
   TEST_3R("max_a.b",  16, 192, w2,  w3,  w10);
   TEST_3R("max_a.b",  24, 192, w3,  w29, w15);
   TEST_3R("max_a.b",  32,  48, w4,  w13, w14);
   TEST_3R("max_a.b",  40, 120, w5,  w15, w2);
   TEST_3R("max_a.b",  48,  32, w6,  w18, w9);
   TEST_3R("max_a.b",  56,  48, w7,  w15, w10);
   TEST_3R("max_a.b",  64, 120, w8,  w27, w19);
   TEST_3R("max_a.b",  72, 128, w9,  w9,  w4);
   TEST_3R("max_a.b",  80, 184, w10, w3,  w2);
   TEST_3R("max_a.b",  88,  88, w11, w5,  w10);
   TEST_3R("max_a.b",  96, 200, w12, w10, w13);
   TEST_3R("max_a.b", 104,  40, w13, w20, w21);
   TEST_3R("max_a.b", 112, 208, w14, w4,  w22);
   TEST_3R("max_a.b", 120, 160, w15, w18, w27);
   TEST_3R("max_a.b", 128, 176, w16, w20, w10);
   TEST_3R("max_a.b", 136, 176, w17, w30, w28);
   TEST_3R("max_a.b", 144,  24, w18, w18, w18);
   TEST_3R("max_a.b", 152, 104, w19, w3,  w17);
   TEST_3R("max_a.b", 160,   0, w20, w29, w21);
   TEST_3R("max_a.b", 168,  56, w21, w0,  w24);
   TEST_3R("max_a.b", 176, 144, w22, w5,  w2);
   TEST_3R("max_a.b", 184, 216, w23, w15, w16);
   TEST_3R("max_a.b", 192,  16, w24, w3,  w5);
   TEST_3R("max_a.b", 200, 232, w25, w7,  w27);
   TEST_3R("max_a.b", 208, 232, w26, w23, w15);
   TEST_3R("max_a.b", 216,  24, w27, w1,  w22);
   TEST_3R("max_a.b", 224, 160, w28, w29, w11);
   TEST_3R("max_a.b", 232,  32, w29, w1,  w28);
   TEST_3R("max_a.b", 240, 144, w30, w18, w18);
   TEST_3R("max_a.b", 128,  72, w31, w30, w10);
   TEST_3R("max_a.h",   0, 216, w0,  w12, w0);
   TEST_3R("max_a.h",   8,  72, w1,  w18, w28);
   TEST_3R("max_a.h",  16, 200, w2,  w21, w1);
   TEST_3R("max_a.h",  24, 224, w3,  w29, w25);
   TEST_3R("max_a.h",  32,  96, w4,  w20, w9);
   TEST_3R("max_a.h",  40,   0, w5,  w21, w31);
   TEST_3R("max_a.h",  48, 160, w6,  w18, w10);
   TEST_3R("max_a.h",  56,  80, w7,  w19, w24);
   TEST_3R("max_a.h",  64, 192, w8,  w25, w15);
   TEST_3R("max_a.h",  72, 144, w9,  w9,  w3);
   TEST_3R("max_a.h",  80,   8, w10, w15, w4);
   TEST_3R("max_a.h",  88, 120, w11, w24, w26);
   TEST_3R("max_a.h",  96,  56, w12, w22, w23);
   TEST_3R("max_a.h", 104,  40, w13, w16, w14);
   TEST_3R("max_a.h", 112, 176, w14, w25, w19);
   TEST_3R("max_a.h", 120, 112, w15, w24, w5);
   TEST_3R("max_a.h", 128,  40, w16, w2,  w12);
   TEST_3R("max_a.h", 136, 120, w17, w9,  w4);
   TEST_3R("max_a.h", 144,  64, w18, w18, w18);
   TEST_3R("max_a.h", 152, 128, w19, w29, w26);
   TEST_3R("max_a.h", 160, 160, w20, w0,  w13);
   TEST_3R("max_a.h", 168, 176, w21, w15, w17);
   TEST_3R("max_a.h", 176, 168, w22, w7,  w11);
   TEST_3R("max_a.h", 184, 232, w23, w30, w2);
   TEST_3R("max_a.h", 192, 144, w24, w14, w16);
   TEST_3R("max_a.h", 200, 200, w25, w7,  w4);
   TEST_3R("max_a.h", 208,  80, w26, w31, w9);
   TEST_3R("max_a.h", 216, 120, w27, w1,  w22);
   TEST_3R("max_a.h", 224,   0, w28, w11, w26);
   TEST_3R("max_a.h", 232, 144, w29, w13, w24);
   TEST_3R("max_a.h", 240,  72, w30, w19, w19);
   TEST_3R("max_a.h", 136,  40, w31, w29, w8);
   TEST_3R("max_a.w",   0,  88, w0,  w9,  w0);
   TEST_3R("max_a.w",   8, 200, w1,  w26, w23);
   TEST_3R("max_a.w",  16, 200, w2,  w28, w16);
   TEST_3R("max_a.w",  24,  80, w3,  w13, w8);
   TEST_3R("max_a.w",  32,  32, w4,  w17, w19);
   TEST_3R("max_a.w",  40,  32, w5,  w26, w4);
   TEST_3R("max_a.w",  48, 136, w6,  w16, w14);
   TEST_3R("max_a.w",  56, 184, w7,  w11, w4);
   TEST_3R("max_a.w",  64,   8, w8,  w3,  w20);
   TEST_3R("max_a.w",  72,   0, w9,  w9,  w27);
   TEST_3R("max_a.w",  80,   8, w10, w22, w3);
   TEST_3R("max_a.w",  88,  56, w11, w31, w19);
   TEST_3R("max_a.w",  96,  96, w12, w23, w0);
   TEST_3R("max_a.w", 104,  96, w13, w7,  w28);
   TEST_3R("max_a.w", 112,  96, w14, w15, w30);
   TEST_3R("max_a.w", 120,  40, w15, w2,  w0);
   TEST_3R("max_a.w", 128, 152, w16, w6,  w3);
   TEST_3R("max_a.w", 136,  56, w17, w21, w10);
   TEST_3R("max_a.w", 144, 168, w18, w18, w18);
   TEST_3R("max_a.w", 152, 104, w19, w13, w27);
   TEST_3R("max_a.w", 160,  40, w20, w30, w17);
   TEST_3R("max_a.w", 168,  72, w21, w29, w17);
   TEST_3R("max_a.w", 176, 184, w22, w23, w8);
   TEST_3R("max_a.w", 184,  24, w23, w13, w15);
   TEST_3R("max_a.w", 192,  56, w24, w16, w31);
   TEST_3R("max_a.w", 200, 120, w25, w4,  w1);
   TEST_3R("max_a.w", 208,  88, w26, w18, w8);
   TEST_3R("max_a.w", 216,  72, w27, w17, w29);
   TEST_3R("max_a.w", 224,   8, w28, w27, w22);
   TEST_3R("max_a.w", 232,  64, w29, w8,  w3);
   TEST_3R("max_a.w", 240,   0, w30, w17, w17);
   TEST_3R("max_a.w", 200, 216, w31, w7,  w29);
   TEST_3R("max_a.d",   0, 128, w0,  w28, w0);
   TEST_3R("max_a.d",   8, 144, w1,  w0,  w27);
   TEST_3R("max_a.d",  16,  16, w2,  w15, w23);
   TEST_3R("max_a.d",  24,  96, w3,  w14, w17);
   TEST_3R("max_a.d",  32, 104, w4,  w16, w11);
   TEST_3R("max_a.d",  40,  24, w5,  w24, w8);
   TEST_3R("max_a.d",  48, 176, w6,  w21, w22);
   TEST_3R("max_a.d",  56, 168, w7,  w11, w16);
   TEST_3R("max_a.d",  64,  24, w8,  w14, w6);
   TEST_3R("max_a.d",  72,  88, w9,  w9,  w15);
   TEST_3R("max_a.d",  80,  48, w10, w12, w13);
   TEST_3R("max_a.d",  88, 208, w11, w8,  w3);
   TEST_3R("max_a.d",  96, 160, w12, w4,  w5);
   TEST_3R("max_a.d", 104, 208, w13, w27, w24);
   TEST_3R("max_a.d", 112, 192, w14, w12, w19);
   TEST_3R("max_a.d", 120,  24, w15, w23, w11);
   TEST_3R("max_a.d", 128,  48, w16, w18, w0);
   TEST_3R("max_a.d", 136,  80, w17, w8,  w11);
   TEST_3R("max_a.d", 144, 192, w18, w18, w18);
   TEST_3R("max_a.d", 152, 224, w19, w25, w11);
   TEST_3R("max_a.d", 160,  32, w20, w8,  w24);
   TEST_3R("max_a.d", 168, 184, w21, w29, w11);
   TEST_3R("max_a.d", 176, 136, w22, w2,  w15);
   TEST_3R("max_a.d", 184,  40, w23, w10, w22);
   TEST_3R("max_a.d", 192,   8, w24, w22, w4);
   TEST_3R("max_a.d", 200,  72, w25, w13, w28);
   TEST_3R("max_a.d", 208, 232, w26, w12, w14);
   TEST_3R("max_a.d", 216, 176, w27, w1,  w22);
   TEST_3R("max_a.d", 224,  32, w28, w6,  w18);
   TEST_3R("max_a.d", 232, 176, w29, w4,  w10);
   TEST_3R("max_a.d", 240, 200, w30, w25, w25);
   TEST_3R("max_a.d",  88, 232, w31, w0,  w18);
   TEST_3R("max_s.b",   0,  56, w0,  w27, w15);
   TEST_3R("max_s.b",   8, 136, w1,  w1,  w8);
   TEST_3R("max_s.b",  16, 184, w2,  w6,  w0);
   TEST_3R("max_s.b",  24, 152, w3,  w20, w24);
   TEST_3R("max_s.b",  32, 200, w4,  w10, w27);
   TEST_3R("max_s.b",  40, 192, w5,  w7,  w23);
   TEST_3R("max_s.b",  48, 104, w6,  w25, w25);
   TEST_3R("max_s.b",  56,  16, w7,  w12, w14);
   TEST_3R("max_s.b",  64,   0, w8,  w20, w14);
   TEST_3R("max_s.b",  72,   0, w9,  w30, w29);
   TEST_3R("max_s.b",  80, 232, w10, w0,  w22);
   TEST_3R("max_s.b",  88,  48, w11, w27, w5);
   TEST_3R("max_s.b",  96, 104, w12, w4,  w1);
   TEST_3R("max_s.b", 104, 112, w13, w4,  w9);
   TEST_3R("max_s.b", 112, 216, w14, w29, w18);
   TEST_3R("max_s.b", 120,   0, w15, w24, w2);
   TEST_3R("max_s.b", 128,  16, w16, w16, w16);
   TEST_3R("max_s.b", 136, 232, w17, w3,  w13);
   TEST_3R("max_s.b", 144,  16, w18, w15, w28);
   TEST_3R("max_s.b", 152,  16, w19, w3,  w10);
   TEST_3R("max_s.b", 160, 136, w20, w2,  w8);
   TEST_3R("max_s.b", 168,   8, w21, w2,  w30);
   TEST_3R("max_s.b", 176, 176, w22, w29, w4);
   TEST_3R("max_s.b", 184,  48, w23, w1,  w5);
   TEST_3R("max_s.b", 192, 160, w24, w6,  w15);
   TEST_3R("max_s.b", 200, 128, w25, w3,  w25);
   TEST_3R("max_s.b", 208, 192, w26, w0,  w27);
   TEST_3R("max_s.b", 216,  80, w27, w20, w11);
   TEST_3R("max_s.b", 224, 176, w28, w2,  w23);
   TEST_3R("max_s.b", 232,  72, w29, w30, w23);
   TEST_3R("max_s.b", 240, 104, w30, w8,  w31);
   TEST_3R("max_s.b", 136, 232, w31, w16, w29);
   TEST_3R("max_s.h",   0,  96, w0,  w25, w27);
   TEST_3R("max_s.h",   8, 168, w1,  w1,  w28);
   TEST_3R("max_s.h",  16, 160, w2,  w24, w13);
   TEST_3R("max_s.h",  24, 112, w3,  w7,  w0);
   TEST_3R("max_s.h",  32,  16, w4,  w9,  w1);
   TEST_3R("max_s.h",  40, 168, w5,  w12, w21);
   TEST_3R("max_s.h",  48, 176, w6,  w19, w19);
   TEST_3R("max_s.h",  56,  32, w7,  w4,  w10);
   TEST_3R("max_s.h",  64, 136, w8,  w27, w4);
   TEST_3R("max_s.h",  72, 200, w9,  w26, w0);
   TEST_3R("max_s.h",  80, 104, w10, w24, w30);
   TEST_3R("max_s.h",  88,  80, w11, w17, w25);
   TEST_3R("max_s.h",  96,  24, w12, w13, w22);
   TEST_3R("max_s.h", 104, 112, w13, w26, w25);
   TEST_3R("max_s.h", 112,  88, w14, w26, w31);
   TEST_3R("max_s.h", 120, 128, w15, w27, w1);
   TEST_3R("max_s.h", 128, 208, w16, w16, w16);
   TEST_3R("max_s.h", 136,  24, w17, w14, w25);
   TEST_3R("max_s.h", 144, 104, w18, w3,  w30);
   TEST_3R("max_s.h", 152, 184, w19, w7,  w28);
   TEST_3R("max_s.h", 160, 224, w20, w7,  w10);
   TEST_3R("max_s.h", 168, 112, w21, w5,  w8);
   TEST_3R("max_s.h", 176,  24, w22, w31, w24);
   TEST_3R("max_s.h", 184,   8, w23, w21, w1);
   TEST_3R("max_s.h", 192,  96, w24, w15, w18);
   TEST_3R("max_s.h", 200, 184, w25, w14, w25);
   TEST_3R("max_s.h", 208, 192, w26, w14, w15);
   TEST_3R("max_s.h", 216,  88, w27, w31, w29);
   TEST_3R("max_s.h", 224, 168, w28, w7,  w15);
   TEST_3R("max_s.h", 232,  32, w29, w5,  w22);
   TEST_3R("max_s.h", 240,  56, w30, w5,  w29);
   TEST_3R("max_s.h", 128, 192, w31, w5,  w3);
   TEST_3R("max_s.w",   0, 160, w0,  w2,  w12);
   TEST_3R("max_s.w",   8, 152, w1,  w1,  w23);
   TEST_3R("max_s.w",  16,  16, w2,  w12, w6);
   TEST_3R("max_s.w",  24,  72, w3,  w30, w21);
   TEST_3R("max_s.w",  32,  88, w4,  w12, w29);
   TEST_3R("max_s.w",  40, 128, w5,  w2,  w8);
   TEST_3R("max_s.w",  48,  32, w6,  w17, w17);
   TEST_3R("max_s.w",  56,  56, w7,  w24, w14);
   TEST_3R("max_s.w",  64, 168, w8,  w26, w19);
   TEST_3R("max_s.w",  72,   8, w9,  w6,  w24);
   TEST_3R("max_s.w",  80, 136, w10, w26, w14);
   TEST_3R("max_s.w",  88, 224, w11, w6,  w2);
   TEST_3R("max_s.w",  96, 216, w12, w20, w14);
   TEST_3R("max_s.w", 104, 160, w13, w20, w2);
   TEST_3R("max_s.w", 112,  56, w14, w25, w6);
   TEST_3R("max_s.w", 120, 160, w15, w5,  w8);
   TEST_3R("max_s.w", 128, 168, w16, w16, w16);
   TEST_3R("max_s.w", 136,  16, w17, w26, w27);
   TEST_3R("max_s.w", 144,  40, w18, w8,  w10);
   TEST_3R("max_s.w", 152,  48, w19, w18, w16);
   TEST_3R("max_s.w", 160,  64, w20, w31, w10);
   TEST_3R("max_s.w", 168,   0, w21, w14, w17);
   TEST_3R("max_s.w", 176,  96, w22, w20, w5);
   TEST_3R("max_s.w", 184,  96, w23, w1,  w26);
   TEST_3R("max_s.w", 192, 168, w24, w3,  w26);
   TEST_3R("max_s.w", 200,  32, w25, w10, w25);
   TEST_3R("max_s.w", 208,  72, w26, w31, w18);
   TEST_3R("max_s.w", 216,  16, w27, w23, w12);
   TEST_3R("max_s.w", 224,  24, w28, w8,  w21);
   TEST_3R("max_s.w", 232,  80, w29, w18, w17);
   TEST_3R("max_s.w", 240, 144, w30, w3,  w5);
   TEST_3R("max_s.w", 104, 104, w31, w13, w8);
   TEST_3R("max_s.d",   0,  80, w0,  w14, w19);
   TEST_3R("max_s.d",   8, 224, w1,  w1,  w2);
   TEST_3R("max_s.d",  16,  88, w2,  w30, w3);
   TEST_3R("max_s.d",  24, 192, w3,  w24, w29);
   TEST_3R("max_s.d",  32,  64, w4,  w15, w29);
   TEST_3R("max_s.d",  40, 160, w5,  w11, w20);
   TEST_3R("max_s.d",  48,  72, w6,  w2,  w2);
   TEST_3R("max_s.d",  56, 232, w7,  w22, w2);
   TEST_3R("max_s.d",  64, 128, w8,  w7,  w19);
   TEST_3R("max_s.d",  72, 216, w9,  w12, w4);
   TEST_3R("max_s.d",  80, 200, w10, w21, w2);
   TEST_3R("max_s.d",  88,  48, w11, w3,  w21);
   TEST_3R("max_s.d",  96, 192, w12, w5,  w10);
   TEST_3R("max_s.d", 104, 200, w13, w8,  w2);
   TEST_3R("max_s.d", 112, 112, w14, w5,  w4);
   TEST_3R("max_s.d", 120, 112, w15, w2,  w24);
   TEST_3R("max_s.d", 128, 176, w16, w16, w16);
   TEST_3R("max_s.d", 136, 128, w17, w25, w20);
   TEST_3R("max_s.d", 144, 128, w18, w15, w22);
   TEST_3R("max_s.d", 152, 128, w19, w22, w10);
   TEST_3R("max_s.d", 160, 224, w20, w3,  w14);
   TEST_3R("max_s.d", 168, 192, w21, w24, w16);
   TEST_3R("max_s.d", 176,   0, w22, w27, w6);
   TEST_3R("max_s.d", 184,  64, w23, w0,  w16);
   TEST_3R("max_s.d", 192,  24, w24, w8,  w18);
   TEST_3R("max_s.d", 200,  64, w25, w13, w25);
   TEST_3R("max_s.d", 208, 216, w26, w19, w16);
   TEST_3R("max_s.d", 216, 168, w27, w5,  w7);
   TEST_3R("max_s.d", 224, 160, w28, w25, w26);
   TEST_3R("max_s.d", 232, 104, w29, w16, w14);
   TEST_3R("max_s.d", 240, 176, w30, w17, w8);
   TEST_3R("max_s.d",  16, 128, w31, w9,  w24);
   TEST_3R("max_u.b",   0,   0, w0,  w31, w12);
   TEST_3R("max_u.b",   8, 176, w1,  w11, w25);
   TEST_3R("max_u.b",  16, 160, w2,  w30, w9);
   TEST_3R("max_u.b",  24, 232, w3,  w16, w13);
   TEST_3R("max_u.b",  32, 128, w4,  w11, w4);
   TEST_3R("max_u.b",  40, 176, w5,  w13, w8);
   TEST_3R("max_u.b",  48,  96, w6,  w7,  w25);
   TEST_3R("max_u.b",  56,  72, w7,  w15, w31);
   TEST_3R("max_u.b",  64, 208, w8,  w7,  w22);
   TEST_3R("max_u.b",  72, 160, w9,  w6,  w2);
   TEST_3R("max_u.b",  80,   0, w10, w20, w1);
   TEST_3R("max_u.b",  88, 184, w11, w11, w21);
   TEST_3R("max_u.b",  96,  56, w12, w26, w11);
   TEST_3R("max_u.b", 104,  40, w13, w3,  w16);
   TEST_3R("max_u.b", 112, 232, w14, w20, w20);
   TEST_3R("max_u.b", 120,   0, w15, w12, w31);
   TEST_3R("max_u.b", 128,  48, w16, w25, w7);
   TEST_3R("max_u.b", 136,  72, w17, w0,  w24);
   TEST_3R("max_u.b", 144,  64, w18, w31, w4);
   TEST_3R("max_u.b", 152, 232, w19, w22, w21);
   TEST_3R("max_u.b", 160, 176, w20, w24, w9);
   TEST_3R("max_u.b", 168, 224, w21, w25, w10);
   TEST_3R("max_u.b", 176,  96, w22, w6,  w4);
   TEST_3R("max_u.b", 184, 128, w23, w18, w7);
   TEST_3R("max_u.b", 192, 120, w24, w1,  w27);
   TEST_3R("max_u.b", 200,   0, w25, w13, w26);
   TEST_3R("max_u.b", 208,  48, w26, w6,  w1);
   TEST_3R("max_u.b", 216,  72, w27, w6,  w2);
   TEST_3R("max_u.b", 224,  48, w28, w21, w1);
   TEST_3R("max_u.b", 232,  96, w29, w11, w23);
   TEST_3R("max_u.b", 240,  56, w30, w30, w30);
   TEST_3R("max_u.b",  24, 232, w31, w15, w17);
   TEST_3R("max_u.h",   0, 200, w0,  w27, w31);
   TEST_3R("max_u.h",   8, 208, w1,  w31, w16);
   TEST_3R("max_u.h",  16, 128, w2,  w6,  w18);
   TEST_3R("max_u.h",  24, 200, w3,  w2,  w18);
   TEST_3R("max_u.h",  32, 192, w4,  w28, w4);
   TEST_3R("max_u.h",  40, 120, w5,  w21, w30);
   TEST_3R("max_u.h",  48, 192, w6,  w27, w0);
   TEST_3R("max_u.h",  56, 120, w7,  w16, w1);
   TEST_3R("max_u.h",  64, 224, w8,  w28, w25);
   TEST_3R("max_u.h",  72,  64, w9,  w4,  w8);
   TEST_3R("max_u.h",  80, 120, w10, w29, w17);
   TEST_3R("max_u.h",  88, 176, w11, w11, w28);
   TEST_3R("max_u.h",  96, 176, w12, w28, w2);
   TEST_3R("max_u.h", 104, 224, w13, w31, w5);
   TEST_3R("max_u.h", 112, 224, w14, w17, w17);
   TEST_3R("max_u.h", 120, 120, w15, w1,  w4);
   TEST_3R("max_u.h", 128, 160, w16, w31, w14);
   TEST_3R("max_u.h", 136, 208, w17, w31, w5);
   TEST_3R("max_u.h", 144,  80, w18, w1,  w15);
   TEST_3R("max_u.h", 152, 112, w19, w26, w1);
   TEST_3R("max_u.h", 160, 144, w20, w2,  w3);
   TEST_3R("max_u.h", 168, 136, w21, w20, w1);
   TEST_3R("max_u.h", 176, 200, w22, w21, w29);
   TEST_3R("max_u.h", 184,  56, w23, w0,  w26);
   TEST_3R("max_u.h", 192,  48, w24, w5,  w11);
   TEST_3R("max_u.h", 200,  40, w25, w7,  w16);
   TEST_3R("max_u.h", 208, 208, w26, w6,  w30);
   TEST_3R("max_u.h", 216,  48, w27, w6,  w3);
   TEST_3R("max_u.h", 224,   8, w28, w7,  w19);
   TEST_3R("max_u.h", 232, 120, w29, w1,  w20);
   TEST_3R("max_u.h", 240, 176, w30, w30, w30);
   TEST_3R("max_u.h",  40,  16, w31, w23, w17);
   TEST_3R("max_u.w",   0, 120, w0,  w12, w22);
   TEST_3R("max_u.w",   8,  96, w1,  w4,  w22);
   TEST_3R("max_u.w",  16, 176, w2,  w0,  w28);
   TEST_3R("max_u.w",  24, 216, w3,  w17, w18);
   TEST_3R("max_u.w",  32,   0, w4,  w9,  w4);
   TEST_3R("max_u.w",  40, 176, w5,  w13, w15);
   TEST_3R("max_u.w",  48, 112, w6,  w3,  w22);
   TEST_3R("max_u.w",  56,  40, w7,  w12, w23);
   TEST_3R("max_u.w",  64, 144, w8,  w10, w27);
   TEST_3R("max_u.w",  72, 184, w9,  w28, w18);
   TEST_3R("max_u.w",  80,   0, w10, w28, w31);
   TEST_3R("max_u.w",  88,  48, w11, w11, w24);
   TEST_3R("max_u.w",  96, 176, w12, w23, w15);
   TEST_3R("max_u.w", 104, 112, w13, w19, w17);
   TEST_3R("max_u.w", 112,  48, w14, w22, w22);
   TEST_3R("max_u.w", 120,  48, w15, w1,  w31);
   TEST_3R("max_u.w", 128,  96, w16, w14, w15);
   TEST_3R("max_u.w", 136, 216, w17, w18, w5);
   TEST_3R("max_u.w", 144,  16, w18, w30, w29);
   TEST_3R("max_u.w", 152, 168, w19, w8,  w24);
   TEST_3R("max_u.w", 160, 224, w20, w4,  w10);
   TEST_3R("max_u.w", 168,  96, w21, w1,  w9);
   TEST_3R("max_u.w", 176, 104, w22, w25, w12);
   TEST_3R("max_u.w", 184,  72, w23, w8,  w16);
   TEST_3R("max_u.w", 192, 176, w24, w25, w5);
   TEST_3R("max_u.w", 200, 176, w25, w28, w6);
   TEST_3R("max_u.w", 208, 192, w26, w15, w21);
   TEST_3R("max_u.w", 216, 136, w27, w22, w7);
   TEST_3R("max_u.w", 224, 160, w28, w3,  w5);
   TEST_3R("max_u.w", 232, 104, w29, w10, w13);
   TEST_3R("max_u.w", 240,   0, w30, w30, w30);
   TEST_3R("max_u.w", 128, 104, w31, w18, w24);
   TEST_3R("max_u.d",   0,  88, w0,  w1,  w12);
   TEST_3R("max_u.d",   8,  96, w1,  w14, w8);
   TEST_3R("max_u.d",  16, 216, w2,  w30, w22);
   TEST_3R("max_u.d",  24,  56, w3,  w27, w11);
   TEST_3R("max_u.d",  32,   8, w4,  w31, w4);
   TEST_3R("max_u.d",  40, 208, w5,  w30, w18);
   TEST_3R("max_u.d",  48, 144, w6,  w5,  w10);
   TEST_3R("max_u.d",  56, 216, w7,  w10, w0);
   TEST_3R("max_u.d",  64,  96, w8,  w24, w13);
   TEST_3R("max_u.d",  72,  72, w9,  w10, w5);
   TEST_3R("max_u.d",  80, 144, w10, w29, w7);
   TEST_3R("max_u.d",  88,  48, w11, w11, w9);
   TEST_3R("max_u.d",  96, 208, w12, w30, w19);
   TEST_3R("max_u.d", 104,  88, w13, w22, w16);
   TEST_3R("max_u.d", 112, 152, w14, w31, w31);
   TEST_3R("max_u.d", 120, 112, w15, w18, w30);
   TEST_3R("max_u.d", 128,  80, w16, w3,  w11);
   TEST_3R("max_u.d", 136,  64, w17, w14, w11);
   TEST_3R("max_u.d", 144,  32, w18, w6,  w25);
   TEST_3R("max_u.d", 152, 112, w19, w16, w30);
   TEST_3R("max_u.d", 160, 128, w20, w13, w5);
   TEST_3R("max_u.d", 168, 208, w21, w22, w26);
   TEST_3R("max_u.d", 176,  56, w22, w21, w13);
   TEST_3R("max_u.d", 184, 216, w23, w2,  w3);
   TEST_3R("max_u.d", 192, 136, w24, w26, w3);
   TEST_3R("max_u.d", 200,   8, w25, w12, w1);
   TEST_3R("max_u.d", 208,  80, w26, w15, w4);
   TEST_3R("max_u.d", 216, 160, w27, w6,  w18);
   TEST_3R("max_u.d", 224, 104, w28, w26, w24);
   TEST_3R("max_u.d", 232,   8, w29, w17, w8);
   TEST_3R("max_u.d", 240, 144, w30, w30, w30);
   TEST_3R("max_u.d", 152, 152, w31, w21, w30);
   TEST_3R("min_a.b",   0, 216, w0,  w8,  w3);
   TEST_3R("min_a.b",   8, 184, w1,  w3,  w1);
   TEST_3R("min_a.b",  16, 216, w2,  w13, w12);
   TEST_3R("min_a.b",  24, 184, w3,  w14, w23);
   TEST_3R("min_a.b",  32, 232, w4,  w18, w13);
   TEST_3R("min_a.b",  40, 104, w5,  w14, w25);
   TEST_3R("min_a.b",  48,  24, w6,  w9,  w9);
   TEST_3R("min_a.b",  56,  40, w7,  w6,  w2);
   TEST_3R("min_a.b",  64,  64, w8,  w27, w0);
   TEST_3R("min_a.b",  72,  64, w9,  w7,  w25);
   TEST_3R("min_a.b",  80, 120, w10, w8,  w0);
   TEST_3R("min_a.b",  88,   8, w11, w10, w14);
   TEST_3R("min_a.b",  96,  96, w12, w23, w26);
   TEST_3R("min_a.b", 104,  40, w13, w5,  w17);
   TEST_3R("min_a.b", 112, 152, w14, w23, w30);
   TEST_3R("min_a.b", 120, 144, w15, w28, w13);
   TEST_3R("min_a.b", 128,  40, w16, w26, w22);
   TEST_3R("min_a.b", 136,  88, w17, w0,  w24);
   TEST_3R("min_a.b", 144,  24, w18, w27, w24);
   TEST_3R("min_a.b", 152,  96, w19, w3,  w18);
   TEST_3R("min_a.b", 160,  88, w20, w11, w18);
   TEST_3R("min_a.b", 168, 232, w21, w23, w28);
   TEST_3R("min_a.b", 176, 176, w22, w31, w19);
   TEST_3R("min_a.b", 184, 160, w23, w17, w24);
   TEST_3R("min_a.b", 192, 160, w24, w28, w15);
   TEST_3R("min_a.b", 200, 208, w25, w25, w25);
   TEST_3R("min_a.b", 208, 232, w26, w12, w1);
   TEST_3R("min_a.b", 216,  40, w27, w6,  w23);
   TEST_3R("min_a.b", 224,   0, w28, w6,  w15);
   TEST_3R("min_a.b", 232,  32, w29, w1,  w8);
   TEST_3R("min_a.b", 240,  24, w30, w30, w4);
   TEST_3R("min_a.b", 200,  24, w31, w1,  w16);
   TEST_3R("min_a.h",   0, 192, w0,  w7,  w8);
   TEST_3R("min_a.h",   8, 232, w1,  w6,  w1);
   TEST_3R("min_a.h",  16, 176, w2,  w12, w24);
   TEST_3R("min_a.h",  24, 112, w3,  w2,  w20);
   TEST_3R("min_a.h",  32,  88, w4,  w22, w27);
   TEST_3R("min_a.h",  40,  56, w5,  w24, w20);
   TEST_3R("min_a.h",  48, 136, w6,  w29, w29);
   TEST_3R("min_a.h",  56, 128, w7,  w31, w28);
   TEST_3R("min_a.h",  64, 160, w8,  w15, w0);
   TEST_3R("min_a.h",  72, 184, w9,  w17, w16);
   TEST_3R("min_a.h",  80, 160, w10, w14, w23);
   TEST_3R("min_a.h",  88,  32, w11, w22, w30);
   TEST_3R("min_a.h",  96,  80, w12, w2,  w22);
   TEST_3R("min_a.h", 104,  64, w13, w4,  w10);
   TEST_3R("min_a.h", 112, 160, w14, w26, w5);
   TEST_3R("min_a.h", 120,  24, w15, w18, w10);
   TEST_3R("min_a.h", 128, 160, w16, w2,  w7);
   TEST_3R("min_a.h", 136, 168, w17, w1,  w6);
   TEST_3R("min_a.h", 144,   8, w18, w8,  w22);
   TEST_3R("min_a.h", 152,  32, w19, w9,  w7);
   TEST_3R("min_a.h", 160,  16, w20, w22, w21);
   TEST_3R("min_a.h", 168, 136, w21, w11, w5);
   TEST_3R("min_a.h", 176, 216, w22, w13, w27);
   TEST_3R("min_a.h", 184,  48, w23, w17, w6);
   TEST_3R("min_a.h", 192,  80, w24, w12, w11);
   TEST_3R("min_a.h", 200,  40, w25, w25, w25);
   TEST_3R("min_a.h", 208, 208, w26, w22, w0);
   TEST_3R("min_a.h", 216,  32, w27, w29, w3);
   TEST_3R("min_a.h", 224, 120, w28, w4,  w2);
   TEST_3R("min_a.h", 232,   0, w29, w26, w1);
   TEST_3R("min_a.h", 240, 112, w30, w30, w1);
   TEST_3R("min_a.h",  48, 136, w31, w8,  w22);
   TEST_3R("min_a.w",   0,  56, w0,  w2,  w30);
   TEST_3R("min_a.w",   8,   8, w1,  w15, w1);
   TEST_3R("min_a.w",  16, 224, w2,  w12, w1);
   TEST_3R("min_a.w",  24,  24, w3,  w16, w13);
   TEST_3R("min_a.w",  32,  80, w4,  w7,  w11);
   TEST_3R("min_a.w",  40, 216, w5,  w7,  w12);
   TEST_3R("min_a.w",  48, 184, w6,  w10, w10);
   TEST_3R("min_a.w",  56,  64, w7,  w3,  w12);
   TEST_3R("min_a.w",  64,  72, w8,  w29, w14);
   TEST_3R("min_a.w",  72, 128, w9,  w30, w31);
   TEST_3R("min_a.w",  80,  48, w10, w20, w24);
   TEST_3R("min_a.w",  88, 224, w11, w22, w23);
   TEST_3R("min_a.w",  96, 144, w12, w6,  w17);
   TEST_3R("min_a.w", 104,  96, w13, w7,  w17);
   TEST_3R("min_a.w", 112, 136, w14, w20, w28);
   TEST_3R("min_a.w", 120, 152, w15, w31, w30);
   TEST_3R("min_a.w", 128, 200, w16, w11, w29);
   TEST_3R("min_a.w", 136,  64, w17, w25, w0);
   TEST_3R("min_a.w", 144,  16, w18, w16, w29);
   TEST_3R("min_a.w", 152,  80, w19, w25, w27);
   TEST_3R("min_a.w", 160, 152, w20, w11, w15);
   TEST_3R("min_a.w", 168, 160, w21, w17, w6);
   TEST_3R("min_a.w", 176,  48, w22, w5,  w12);
   TEST_3R("min_a.w", 184,  32, w23, w5,  w19);
   TEST_3R("min_a.w", 192, 160, w24, w22, w7);
   TEST_3R("min_a.w", 200,  24, w25, w25, w25);
   TEST_3R("min_a.w", 208,  56, w26, w6,  w16);
   TEST_3R("min_a.w", 216,  16, w27, w18, w13);
   TEST_3R("min_a.w", 224, 200, w28, w11, w13);
   TEST_3R("min_a.w", 232, 224, w29, w27, w10);
   TEST_3R("min_a.w", 240, 192, w30, w30, w20);
   TEST_3R("min_a.w",  96,  96, w31, w22, w0);
   TEST_3R("min_a.d",   0,  16, w0,  w17, w26);
   TEST_3R("min_a.d",   8,  32, w1,  w22, w1);
   TEST_3R("min_a.d",  16,  56, w2,  w11, w27);
   TEST_3R("min_a.d",  24,  96, w3,  w0,  w17);
   TEST_3R("min_a.d",  32,  96, w4,  w18, w31);
   TEST_3R("min_a.d",  40, 232, w5,  w2,  w13);
   TEST_3R("min_a.d",  48, 112, w6,  w15, w15);
   TEST_3R("min_a.d",  56,  80, w7,  w4,  w28);
   TEST_3R("min_a.d",  64, 176, w8,  w31, w6);
   TEST_3R("min_a.d",  72, 120, w9,  w19, w11);
   TEST_3R("min_a.d",  80, 216, w10, w19, w0);
   TEST_3R("min_a.d",  88,   0, w11, w4,  w26);
   TEST_3R("min_a.d",  96, 192, w12, w26, w1);
   TEST_3R("min_a.d", 104,  48, w13, w22, w26);
   TEST_3R("min_a.d", 112, 176, w14, w7,  w27);
   TEST_3R("min_a.d", 120, 192, w15, w7,  w2);
   TEST_3R("min_a.d", 128, 144, w16, w20, w27);
   TEST_3R("min_a.d", 136, 160, w17, w24, w31);
   TEST_3R("min_a.d", 144, 152, w18, w11, w30);
   TEST_3R("min_a.d", 152,  96, w19, w16, w17);
   TEST_3R("min_a.d", 160,  16, w20, w11, w5);
   TEST_3R("min_a.d", 168, 184, w21, w26, w9);
   TEST_3R("min_a.d", 176, 152, w22, w15, w4);
   TEST_3R("min_a.d", 184, 184, w23, w15, w26);
   TEST_3R("min_a.d", 192,  48, w24, w15, w1);
   TEST_3R("min_a.d", 200, 112, w25, w25, w25);
   TEST_3R("min_a.d", 208, 184, w26, w8,  w6);
   TEST_3R("min_a.d", 216,  88, w27, w28, w1);
   TEST_3R("min_a.d", 224, 120, w28, w21, w0);
   TEST_3R("min_a.d", 232,  32, w29, w0,  w30);
   TEST_3R("min_a.d", 240, 112, w30, w30, w16);
   TEST_3R("min_a.d",  24,  80, w31, w26, w27);
   TEST_3R("min_s.b",   0,  48, w0,  w2,  w10);
   TEST_3R("min_s.b",   8, 224, w1,  w28, w20);
   TEST_3R("min_s.b",  16, 208, w2,  w30, w24);
   TEST_3R("min_s.b",  24,  24, w3,  w6,  w31);
   TEST_3R("min_s.b",  32, 112, w4,  w3,  w3);
   TEST_3R("min_s.b",  40, 112, w5,  w26, w24);
   TEST_3R("min_s.b",  48,  88, w6,  w25, w24);
   TEST_3R("min_s.b",  56, 200, w7,  w31, w8);
   TEST_3R("min_s.b",  64,  48, w8,  w25, w3);
   TEST_3R("min_s.b",  72,  32, w9,  w7,  w25);
   TEST_3R("min_s.b",  80, 176, w10, w2,  w29);
   TEST_3R("min_s.b",  88, 160, w11, w13, w17);
   TEST_3R("min_s.b",  96, 144, w12, w1,  w20);
   TEST_3R("min_s.b", 104, 152, w13, w25, w6);
   TEST_3R("min_s.b", 112, 136, w14, w23, w9);
   TEST_3R("min_s.b", 120,   8, w15, w17, w1);
   TEST_3R("min_s.b", 128, 104, w16, w10, w25);
   TEST_3R("min_s.b", 136, 184, w17, w10, w1);
   TEST_3R("min_s.b", 144, 104, w18, w3,  w5);
   TEST_3R("min_s.b", 152, 144, w19, w10, w30);
   TEST_3R("min_s.b", 160, 192, w20, w13, w27);
   TEST_3R("min_s.b", 168, 136, w21, w21, w21);
   TEST_3R("min_s.b", 176,  24, w22, w12, w24);
   TEST_3R("min_s.b", 184, 160, w23, w0,  w24);
   TEST_3R("min_s.b", 192, 184, w24, w26, w30);
   TEST_3R("min_s.b", 200,  80, w25, w17, w8);
   TEST_3R("min_s.b", 208,  96, w26, w2,  w9);
   TEST_3R("min_s.b", 216,  80, w27, w13, w27);
   TEST_3R("min_s.b", 224, 224, w28, w25, w23);
   TEST_3R("min_s.b", 232, 200, w29, w2,  w26);
   TEST_3R("min_s.b", 240,  64, w30, w30, w16);
   TEST_3R("min_s.b", 224,  16, w31, w7,  w0);
   TEST_3R("min_s.h",   0, 232, w0,  w22, w12);
   TEST_3R("min_s.h",   8, 144, w1,  w14, w7);
   TEST_3R("min_s.h",  16,   8, w2,  w6,  w27);
   TEST_3R("min_s.h",  24, 232, w3,  w5,  w8);
   TEST_3R("min_s.h",  32, 232, w4,  w13, w13);
   TEST_3R("min_s.h",  40, 200, w5,  w29, w22);
   TEST_3R("min_s.h",  48, 152, w6,  w10, w25);
   TEST_3R("min_s.h",  56,  40, w7,  w1,  w30);
   TEST_3R("min_s.h",  64, 152, w8,  w28, w7);
   TEST_3R("min_s.h",  72, 168, w9,  w1,  w15);
   TEST_3R("min_s.h",  80,  16, w10, w19, w18);
   TEST_3R("min_s.h",  88, 224, w11, w31, w1);
   TEST_3R("min_s.h",  96, 176, w12, w6,  w17);
   TEST_3R("min_s.h", 104, 120, w13, w1,  w27);
   TEST_3R("min_s.h", 112, 232, w14, w10, w22);
   TEST_3R("min_s.h", 120, 168, w15, w24, w20);
   TEST_3R("min_s.h", 128,  72, w16, w7,  w30);
   TEST_3R("min_s.h", 136, 192, w17, w15, w0);
   TEST_3R("min_s.h", 144,  40, w18, w25, w28);
   TEST_3R("min_s.h", 152, 104, w19, w20, w29);
   TEST_3R("min_s.h", 160,  24, w20, w15, w16);
   TEST_3R("min_s.h", 168, 208, w21, w21, w21);
   TEST_3R("min_s.h", 176,  64, w22, w15, w16);
   TEST_3R("min_s.h", 184,   0, w23, w21, w2);
   TEST_3R("min_s.h", 192,   0, w24, w22, w29);
   TEST_3R("min_s.h", 200, 104, w25, w0,  w20);
   TEST_3R("min_s.h", 208,  40, w26, w25, w8);
   TEST_3R("min_s.h", 216, 128, w27, w0,  w27);
   TEST_3R("min_s.h", 224, 128, w28, w2,  w15);
   TEST_3R("min_s.h", 232, 208, w29, w9,  w8);
   TEST_3R("min_s.h", 240, 168, w30, w30, w23);
   TEST_3R("min_s.h",   0,  88, w31, w20, w11);
   TEST_3R("min_s.w",   0, 192, w0,  w12, w30);
   TEST_3R("min_s.w",   8,  80, w1,  w12, w19);
   TEST_3R("min_s.w",  16, 160, w2,  w19, w10);
   TEST_3R("min_s.w",  24, 176, w3,  w6,  w10);
   TEST_3R("min_s.w",  32, 224, w4,  w17, w17);
   TEST_3R("min_s.w",  40, 192, w5,  w15, w11);
   TEST_3R("min_s.w",  48, 112, w6,  w21, w13);
   TEST_3R("min_s.w",  56,  24, w7,  w28, w22);
   TEST_3R("min_s.w",  64,  64, w8,  w30, w13);
   TEST_3R("min_s.w",  72,  64, w9,  w30, w1);
   TEST_3R("min_s.w",  80, 136, w10, w13, w4);
   TEST_3R("min_s.w",  88, 152, w11, w12, w24);
   TEST_3R("min_s.w",  96,  40, w12, w31, w13);
   TEST_3R("min_s.w", 104, 176, w13, w9,  w0);
   TEST_3R("min_s.w", 112, 176, w14, w20, w7);
   TEST_3R("min_s.w", 120,  96, w15, w23, w22);
   TEST_3R("min_s.w", 128, 232, w16, w27, w12);
   TEST_3R("min_s.w", 136, 208, w17, w13, w8);
   TEST_3R("min_s.w", 144, 160, w18, w8,  w6);
   TEST_3R("min_s.w", 152,  80, w19, w0,  w4);
   TEST_3R("min_s.w", 160, 120, w20, w3,  w18);
   TEST_3R("min_s.w", 168, 160, w21, w21, w21);
   TEST_3R("min_s.w", 176, 184, w22, w30, w0);
   TEST_3R("min_s.w", 184, 104, w23, w29, w14);
   TEST_3R("min_s.w", 192,  48, w24, w7,  w14);
   TEST_3R("min_s.w", 200,  96, w25, w27, w22);
   TEST_3R("min_s.w", 208,  72, w26, w18, w12);
   TEST_3R("min_s.w", 216,   8, w27, w13, w27);
   TEST_3R("min_s.w", 224,  48, w28, w7,  w27);
   TEST_3R("min_s.w", 232,  64, w29, w28, w3);
   TEST_3R("min_s.w", 240, 136, w30, w30, w3);
   TEST_3R("min_s.w",  24, 232, w31, w2,  w6);
   TEST_3R("min_s.d",   0, 120, w0,  w24, w27);
   TEST_3R("min_s.d",   8, 168, w1,  w6,  w25);
   TEST_3R("min_s.d",  16, 208, w2,  w0,  w8);
   TEST_3R("min_s.d",  24,  72, w3,  w27, w30);
   TEST_3R("min_s.d",  32, 120, w4,  w13, w13);
   TEST_3R("min_s.d",  40, 128, w5,  w20, w27);
   TEST_3R("min_s.d",  48, 176, w6,  w27, w22);
   TEST_3R("min_s.d",  56, 120, w7,  w23, w25);
   TEST_3R("min_s.d",  64, 128, w8,  w21, w29);
   TEST_3R("min_s.d",  72,   0, w9,  w24, w3);
   TEST_3R("min_s.d",  80, 152, w10, w3,  w28);
   TEST_3R("min_s.d",  88, 152, w11, w14, w2);
   TEST_3R("min_s.d",  96, 120, w12, w8,  w4);
   TEST_3R("min_s.d", 104, 128, w13, w16, w24);
   TEST_3R("min_s.d", 112, 120, w14, w4,  w16);
   TEST_3R("min_s.d", 120,   8, w15, w24, w11);
   TEST_3R("min_s.d", 128,  56, w16, w19, w1);
   TEST_3R("min_s.d", 136, 184, w17, w10, w27);
   TEST_3R("min_s.d", 144,  72, w18, w31, w24);
   TEST_3R("min_s.d", 152,  80, w19, w23, w27);
   TEST_3R("min_s.d", 160, 112, w20, w26, w23);
   TEST_3R("min_s.d", 168,  56, w21, w21, w21);
   TEST_3R("min_s.d", 176,  80, w22, w25, w10);
   TEST_3R("min_s.d", 184, 176, w23, w30, w18);
   TEST_3R("min_s.d", 192, 168, w24, w22, w21);
   TEST_3R("min_s.d", 200, 160, w25, w26, w5);
   TEST_3R("min_s.d", 208, 176, w26, w18, w17);
   TEST_3R("min_s.d", 216,  32, w27, w5,  w27);
   TEST_3R("min_s.d", 224, 136, w28, w2,  w15);
   TEST_3R("min_s.d", 232, 128, w29, w11, w15);
   TEST_3R("min_s.d", 240, 208, w30, w30, w11);
   TEST_3R("min_s.d",  24,  48, w31, w1,  w30);
   TEST_3R("min_u.b",   0,   0, w0,  w0,  w0);
   TEST_3R("min_u.b",   8, 144, w1,  w28, w6);
   TEST_3R("min_u.b",  16,  16, w2,  w11, w1);
   TEST_3R("min_u.b",  24,  32, w3,  w18, w19);
   TEST_3R("min_u.b",  32, 184, w4,  w21, w25);
   TEST_3R("min_u.b",  40,  80, w5,  w23, w8);
   TEST_3R("min_u.b",  48,  88, w6,  w3,  w23);
   TEST_3R("min_u.b",  56, 184, w7,  w14, w30);
   TEST_3R("min_u.b",  64, 208, w8,  w12, w31);
   TEST_3R("min_u.b",  72, 208, w9,  w12, w24);
   TEST_3R("min_u.b",  80,  72, w10, w10, w4);
   TEST_3R("min_u.b",  88,   8, w11, w18, w0);
   TEST_3R("min_u.b",  96,  16, w12, w3,  w11);
   TEST_3R("min_u.b", 104, 208, w13, w25, w29);
   TEST_3R("min_u.b", 112, 184, w14, w1,  w19);
   TEST_3R("min_u.b", 120, 144, w15, w27, w10);
   TEST_3R("min_u.b", 128, 104, w16, w2,  w13);
   TEST_3R("min_u.b", 136,  40, w17, w15, w27);
   TEST_3R("min_u.b", 144,  16, w18, w29, w18);
   TEST_3R("min_u.b", 152,  16, w19, w25, w4);
   TEST_3R("min_u.b", 160, 232, w20, w2,  w28);
   TEST_3R("min_u.b", 168, 200, w21, w6,  w5);
   TEST_3R("min_u.b", 176, 184, w22, w6,  w20);
   TEST_3R("min_u.b", 184, 200, w23, w17, w4);
   TEST_3R("min_u.b", 192, 120, w24, w15, w7);
   TEST_3R("min_u.b", 200,  96, w25, w2,  w4);
   TEST_3R("min_u.b", 208, 160, w26, w12, w9);
   TEST_3R("min_u.b", 216, 160, w27, w26, w26);
   TEST_3R("min_u.b", 224,  80, w28, w6,  w21);
   TEST_3R("min_u.b", 232, 144, w29, w3,  w25);
   TEST_3R("min_u.b", 240, 176, w30, w16, w28);
   TEST_3R("min_u.b",  64, 152, w31, w26, w2);
   TEST_3R("min_u.h",   0, 184, w0,  w0,  w0);
   TEST_3R("min_u.h",   8, 120, w1,  w29, w20);
   TEST_3R("min_u.h",  16, 216, w2,  w1,  w12);
   TEST_3R("min_u.h",  24, 232, w3,  w8,  w5);
   TEST_3R("min_u.h",  32,  72, w4,  w12, w25);
   TEST_3R("min_u.h",  40,  48, w5,  w21, w15);
   TEST_3R("min_u.h",  48,   0, w6,  w27, w21);
   TEST_3R("min_u.h",  56, 224, w7,  w27, w25);
   TEST_3R("min_u.h",  64,  96, w8,  w20, w0);
   TEST_3R("min_u.h",  72, 200, w9,  w16, w4);
   TEST_3R("min_u.h",  80, 232, w10, w10, w19);
   TEST_3R("min_u.h",  88, 120, w11, w4,  w28);
   TEST_3R("min_u.h",  96, 120, w12, w24, w22);
   TEST_3R("min_u.h", 104, 208, w13, w4,  w0);
   TEST_3R("min_u.h", 112,  80, w14, w9,  w11);
   TEST_3R("min_u.h", 120, 112, w15, w2,  w3);
   TEST_3R("min_u.h", 128,  80, w16, w18, w21);
   TEST_3R("min_u.h", 136, 120, w17, w7,  w29);
   TEST_3R("min_u.h", 144, 128, w18, w0,  w18);
   TEST_3R("min_u.h", 152,  96, w19, w0,  w1);
   TEST_3R("min_u.h", 160,  64, w20, w17, w5);
   TEST_3R("min_u.h", 168,  88, w21, w4,  w19);
   TEST_3R("min_u.h", 176, 128, w22, w0,  w29);
   TEST_3R("min_u.h", 184, 128, w23, w22, w9);
   TEST_3R("min_u.h", 192, 224, w24, w22, w29);
   TEST_3R("min_u.h", 200, 128, w25, w2,  w29);
   TEST_3R("min_u.h", 208,  16, w26, w5,  w19);
   TEST_3R("min_u.h", 216, 200, w27, w4,  w4);
   TEST_3R("min_u.h", 224, 152, w28, w24, w16);
   TEST_3R("min_u.h", 232, 136, w29, w25, w17);
   TEST_3R("min_u.h", 240, 208, w30, w16, w2);
   TEST_3R("min_u.h", 168,  32, w31, w21, w6);
   TEST_3R("min_u.w",   0, 224, w0,  w0,  w0);
   TEST_3R("min_u.w",   8, 184, w1,  w4,  w2);
   TEST_3R("min_u.w",  16, 176, w2,  w13, w9);
   TEST_3R("min_u.w",  24,  64, w3,  w10, w25);
   TEST_3R("min_u.w",  32, 168, w4,  w7,  w12);
   TEST_3R("min_u.w",  40,  48, w5,  w27, w17);
   TEST_3R("min_u.w",  48, 200, w6,  w31, w30);
   TEST_3R("min_u.w",  56, 112, w7,  w16, w11);
   TEST_3R("min_u.w",  64,  16, w8,  w1,  w25);
   TEST_3R("min_u.w",  72, 216, w9,  w3,  w12);
   TEST_3R("min_u.w",  80, 224, w10, w10, w9);
   TEST_3R("min_u.w",  88, 192, w11, w12, w15);
   TEST_3R("min_u.w",  96, 224, w12, w14, w11);
   TEST_3R("min_u.w", 104,  40, w13, w23, w30);
   TEST_3R("min_u.w", 112,  80, w14, w16, w19);
   TEST_3R("min_u.w", 120, 224, w15, w29, w14);
   TEST_3R("min_u.w", 128,  64, w16, w14, w3);
   TEST_3R("min_u.w", 136,   0, w17, w12, w0);
   TEST_3R("min_u.w", 144, 144, w18, w24, w18);
   TEST_3R("min_u.w", 152, 112, w19, w16, w15);
   TEST_3R("min_u.w", 160,  56, w20, w29, w27);
   TEST_3R("min_u.w", 168, 104, w21, w16, w7);
   TEST_3R("min_u.w", 176, 224, w22, w7,  w21);
   TEST_3R("min_u.w", 184, 160, w23, w11, w12);
   TEST_3R("min_u.w", 192,  40, w24, w25, w29);
   TEST_3R("min_u.w", 200, 192, w25, w14, w26);
   TEST_3R("min_u.w", 208, 168, w26, w31, w8);
   TEST_3R("min_u.w", 216, 160, w27, w15, w15);
   TEST_3R("min_u.w", 224, 160, w28, w15, w12);
   TEST_3R("min_u.w", 232,  96, w29, w16, w3);
   TEST_3R("min_u.w", 240,   8, w30, w26, w1);
   TEST_3R("min_u.w", 168,   0, w31, w6,  w29);
   TEST_3R("min_u.d",   0, 128, w0,  w0,  w0);
   TEST_3R("min_u.d",   8, 168, w1,  w28, w8);
   TEST_3R("min_u.d",  16,  80, w2,  w21, w5);
   TEST_3R("min_u.d",  24,  64, w3,  w31, w11);
   TEST_3R("min_u.d",  32, 208, w4,  w7,  w22);
   TEST_3R("min_u.d",  40,  64, w5,  w28, w18);
   TEST_3R("min_u.d",  48,  80, w6,  w9,  w16);
   TEST_3R("min_u.d",  56,  48, w7,  w9,  w4);
   TEST_3R("min_u.d",  64, 136, w8,  w5,  w10);
   TEST_3R("min_u.d",  72,  72, w9,  w2,  w27);
   TEST_3R("min_u.d",  80,  16, w10, w10, w7);
   TEST_3R("min_u.d",  88, 176, w11, w17, w12);
   TEST_3R("min_u.d",  96,  16, w12, w21, w15);
   TEST_3R("min_u.d", 104, 216, w13, w1,  w18);
   TEST_3R("min_u.d", 112, 216, w14, w23, w3);
   TEST_3R("min_u.d", 120, 144, w15, w10, w4);
   TEST_3R("min_u.d", 128,  24, w16, w20, w8);
   TEST_3R("min_u.d", 136,  48, w17, w25, w8);
   TEST_3R("min_u.d", 144,  80, w18, w30, w18);
   TEST_3R("min_u.d", 152, 120, w19, w16, w1);
   TEST_3R("min_u.d", 160,  16, w20, w25, w8);
   TEST_3R("min_u.d", 168,  32, w21, w11, w25);
   TEST_3R("min_u.d", 176, 144, w22, w1,  w15);
   TEST_3R("min_u.d", 184,  48, w23, w16, w18);
   TEST_3R("min_u.d", 192,  24, w24, w7,  w21);
   TEST_3R("min_u.d", 200, 224, w25, w17, w16);
   TEST_3R("min_u.d", 208,   8, w26, w14, w24);
   TEST_3R("min_u.d", 216,  64, w27, w7,  w7);
   TEST_3R("min_u.d", 224,  16, w28, w30, w5);
   TEST_3R("min_u.d", 232, 144, w29, w14, w6);
   TEST_3R("min_u.d", 240, 160, w30, w7,  w14);
   TEST_3R("min_u.d",  48,  64, w31, w18, w8);
   TEST_3R("mod_s.b",   0, 128, w0,  w0,  w0);
   TEST_3R("mod_s.b",   8, 224, w1,  w11, w17);
   TEST_3R("mod_s.b",  16,  64, w2,  w4,  w12);
   TEST_3R("mod_s.b",  24, 224, w3,  w13, w20);
   TEST_3R("mod_s.b",  32,  16, w4,  w16, w31);
   TEST_3R("mod_s.b",  40,  16, w5,  w30, w31);
   TEST_3R("mod_s.b",  48, 240, w6,  w14, w7);
   TEST_3R("mod_s.b",  56, 208, w7,  w11, w19);
   TEST_3R("mod_s.b",  64, 208, w8,  w12, w16);
   TEST_3R("mod_s.b",  72,  16, w9,  w18, w17);
   TEST_3R("mod_s.b",  80, 128, w10, w2,  w1);
   TEST_3R("mod_s.b",  88,  96, w11, w11, w13);
   TEST_3R("mod_s.b",  96, 240, w12, w27, w18);
   TEST_3R("mod_s.b", 104, 128, w13, w28, w31);
   TEST_3R("mod_s.b", 112,  96, w14, w26, w15);
   TEST_3R("mod_s.b", 120, 208, w15, w18, w15);
   TEST_3R("mod_s.b", 128,  80, w16, w19, w19);
   TEST_3R("mod_s.b", 136,  80, w17, w28, w26);
   TEST_3R("mod_s.b", 144, 208, w18, w3,  w6);
   TEST_3R("mod_s.b", 152, 224, w19, w0,  w18);
   TEST_3R("mod_s.b", 160, 240, w20, w14, w5);
   TEST_3R("mod_s.b", 168,  16, w21, w6,  w7);
   TEST_3R("mod_s.b", 176,  96, w22, w27, w20);
   TEST_3R("mod_s.b", 184,  96, w23, w22, w6);
   TEST_3R("mod_s.b", 192, 240, w24, w18, w5);
   TEST_3R("mod_s.b", 200,  80, w25, w12, w21);
   TEST_3R("mod_s.b", 208, 208, w26, w31, w2);
   TEST_3R("mod_s.b", 216,  16, w27, w17, w30);
   TEST_3R("mod_s.b", 224, 224, w28, w11, w2);
   TEST_3R("mod_s.b", 232,  16, w29, w25, w2);
   TEST_3R("mod_s.b", 240, 208, w30, w23, w16);
   TEST_3R("mod_s.b", 208, 128, w31, w6,  w23);
   TEST_3R("mod_s.h",   0,  80, w0,  w0,  w0);
   TEST_3R("mod_s.h",   8,  16, w1,  w17, w26);
   TEST_3R("mod_s.h",  16,  80, w2,  w23, w29);
   TEST_3R("mod_s.h",  24, 224, w3,  w29, w20);
   TEST_3R("mod_s.h",  32, 208, w4,  w18, w30);
   TEST_3R("mod_s.h",  40, 240, w5,  w20, w28);
   TEST_3R("mod_s.h",  48,  80, w6,  w19, w20);
   TEST_3R("mod_s.h",  56,  96, w7,  w21, w18);
   TEST_3R("mod_s.h",  64,  80, w8,  w23, w2);
   TEST_3R("mod_s.h",  72,  16, w9,  w8,  w24);
   TEST_3R("mod_s.h",  80, 240, w10, w31, w20);
   TEST_3R("mod_s.h",  88, 208, w11, w11, w17);
   TEST_3R("mod_s.h",  96, 208, w12, w9,  w25);
   TEST_3R("mod_s.h", 104,  80, w13, w6,  w19);
   TEST_3R("mod_s.h", 112, 128, w14, w26, w25);
   TEST_3R("mod_s.h", 120, 240, w15, w24, w15);
   TEST_3R("mod_s.h", 128, 128, w16, w0,  w0);
   TEST_3R("mod_s.h", 136,  16, w17, w22, w19);
   TEST_3R("mod_s.h", 144,  80, w18, w24, w8);
   TEST_3R("mod_s.h", 152, 208, w19, w20, w0);
   TEST_3R("mod_s.h", 160, 208, w20, w6,  w8);
   TEST_3R("mod_s.h", 168,  64, w21, w31, w7);
   TEST_3R("mod_s.h", 176, 240, w22, w14, w24);
   TEST_3R("mod_s.h", 184, 208, w23, w17, w12);
   TEST_3R("mod_s.h", 192, 240, w24, w4,  w6);
   TEST_3R("mod_s.h", 200, 240, w25, w29, w18);
   TEST_3R("mod_s.h", 208, 128, w26, w28, w18);
   TEST_3R("mod_s.h", 216, 128, w27, w18, w6);
   TEST_3R("mod_s.h", 224, 240, w28, w11, w14);
   TEST_3R("mod_s.h", 232, 128, w29, w31, w14);
   TEST_3R("mod_s.h", 240,  64, w30, w5,  w22);
   TEST_3R("mod_s.h",  80,  80, w31, w4,  w29);
   TEST_3R("mod_s.w",   0, 208, w0,  w0,  w0);
   TEST_3R("mod_s.w",   8, 224, w1,  w17, w9);
   TEST_3R("mod_s.w",  16,  80, w2,  w29, w6);
   TEST_3R("mod_s.w",  24, 208, w3,  w29, w8);
   TEST_3R("mod_s.w",  32,  64, w4,  w13, w8);
   TEST_3R("mod_s.w",  40, 208, w5,  w23, w14);
   TEST_3R("mod_s.w",  48, 128, w6,  w2,  w28);
   TEST_3R("mod_s.w",  56,  16, w7,  w1,  w11);
   TEST_3R("mod_s.w",  64,  64, w8,  w6,  w1);
   TEST_3R("mod_s.w",  72, 128, w9,  w11, w31);
   TEST_3R("mod_s.w",  80, 208, w10, w29, w20);
   TEST_3R("mod_s.w",  88,  96, w11, w11, w7);
   TEST_3R("mod_s.w",  96, 208, w12, w19, w13);
   TEST_3R("mod_s.w", 104, 208, w13, w22, w11);
   TEST_3R("mod_s.w", 112,  80, w14, w12, w24);
   TEST_3R("mod_s.w", 120,  64, w15, w20, w15);
   TEST_3R("mod_s.w", 128,  80, w16, w9,  w9);
   TEST_3R("mod_s.w", 136, 224, w17, w6,  w11);
   TEST_3R("mod_s.w", 144,  64, w18, w11, w12);
   TEST_3R("mod_s.w", 152, 208, w19, w18, w11);
   TEST_3R("mod_s.w", 160,  64, w20, w29, w10);
   TEST_3R("mod_s.w", 168, 224, w21, w27, w30);
   TEST_3R("mod_s.w", 176,  64, w22, w2,  w25);
   TEST_3R("mod_s.w", 184,  16, w23, w15, w31);
   TEST_3R("mod_s.w", 192, 128, w24, w26, w12);
   TEST_3R("mod_s.w", 200,  16, w25, w18, w30);
   TEST_3R("mod_s.w", 208,  80, w26, w27, w7);
   TEST_3R("mod_s.w", 216,  16, w27, w2,  w18);
   TEST_3R("mod_s.w", 224,  80, w28, w13, w30);
   TEST_3R("mod_s.w", 232, 208, w29, w0,  w17);
   TEST_3R("mod_s.w", 240, 240, w30, w21, w14);
   TEST_3R("mod_s.w", 168, 208, w31, w14, w9);
   TEST_3R("mod_s.d",   0,  96, w0,  w0,  w0);
   TEST_3R("mod_s.d",   8,  96, w1,  w15, w30);
   TEST_3R("mod_s.d",  16, 208, w2,  w14, w22);
   TEST_3R("mod_s.d",  24,  64, w3,  w26, w8);
   TEST_3R("mod_s.d",  32,  16, w4,  w18, w3);
   TEST_3R("mod_s.d",  40, 208, w5,  w12, w19);
   TEST_3R("mod_s.d",  48, 240, w6,  w18, w17);
   TEST_3R("mod_s.d",  56, 128, w7,  w19, w2);
   TEST_3R("mod_s.d",  64, 240, w8,  w17, w11);
   TEST_3R("mod_s.d",  72, 128, w9,  w26, w0);
   TEST_3R("mod_s.d",  80,  80, w10, w6,  w15);
   TEST_3R("mod_s.d",  88, 208, w11, w11, w1);
   TEST_3R("mod_s.d",  96,  16, w12, w9,  w22);
   TEST_3R("mod_s.d", 104,  64, w13, w3,  w30);
   TEST_3R("mod_s.d", 112,  64, w14, w22, w2);
   TEST_3R("mod_s.d", 120, 240, w15, w2,  w15);
   TEST_3R("mod_s.d", 128, 240, w16, w4,  w4);
   TEST_3R("mod_s.d", 136, 224, w17, w26, w22);
   TEST_3R("mod_s.d", 144,  80, w18, w13, w24);
   TEST_3R("mod_s.d", 152, 208, w19, w21, w9);
   TEST_3R("mod_s.d", 160, 224, w20, w12, w4);
   TEST_3R("mod_s.d", 168, 208, w21, w0,  w10);
   TEST_3R("mod_s.d", 176,  96, w22, w19, w11);
   TEST_3R("mod_s.d", 184,  96, w23, w28, w1);
   TEST_3R("mod_s.d", 192, 128, w24, w31, w0);
   TEST_3R("mod_s.d", 200, 208, w25, w21, w2);
   TEST_3R("mod_s.d", 208,  80, w26, w24, w9);
   TEST_3R("mod_s.d", 216,  16, w27, w31, w3);
   TEST_3R("mod_s.d", 224,  16, w28, w14, w16);
   TEST_3R("mod_s.d", 232,  80, w29, w16, w6);
   TEST_3R("mod_s.d", 240, 128, w30, w18, w22);
   TEST_3R("mod_s.d", 112,  64, w31, w19, w0);
   TEST_3R("mod_u.b",   0, 128, w0,  w23, w1);
   TEST_3R("mod_u.b",   8, 224, w1,  w27, w23);
   TEST_3R("mod_u.b",  16, 240, w2,  w17, w2);
   TEST_3R("mod_u.b",  24, 224, w3,  w24, w11);
   TEST_3R("mod_u.b",  32,  96, w4,  w4,  w27);
   TEST_3R("mod_u.b",  40,  96, w5,  w28, w12);
   TEST_3R("mod_u.b",  48, 208, w6,  w13, w18);
   TEST_3R("mod_u.b",  56,  96, w7,  w11, w4);
   TEST_3R("mod_u.b",  64,  16, w8,  w23, w11);
   TEST_3R("mod_u.b",  72, 208, w9,  w29, w22);
   TEST_3R("mod_u.b",  80, 128, w10, w31, w3);
   TEST_3R("mod_u.b",  88,  64, w11, w11, w11);
   TEST_3R("mod_u.b",  96,  16, w12, w15, w15);
   TEST_3R("mod_u.b", 104,  64, w13, w24, w30);
   TEST_3R("mod_u.b", 112, 128, w14, w7,  w22);
   TEST_3R("mod_u.b", 120, 240, w15, w21, w17);
   TEST_3R("mod_u.b", 128,  80, w16, w18, w29);
   TEST_3R("mod_u.b", 136,  16, w17, w31, w15);
   TEST_3R("mod_u.b", 144,  96, w18, w10, w20);
   TEST_3R("mod_u.b", 152, 240, w19, w1,  w11);
   TEST_3R("mod_u.b", 160, 208, w20, w1,  w9);
   TEST_3R("mod_u.b", 168,  16, w21, w6,  w8);
   TEST_3R("mod_u.b", 176,  16, w22, w3,  w9);
   TEST_3R("mod_u.b", 184, 224, w23, w27, w1);
   TEST_3R("mod_u.b", 192, 128, w24, w4,  w8);
   TEST_3R("mod_u.b", 200, 208, w25, w24, w30);
   TEST_3R("mod_u.b", 208,  96, w26, w7,  w16);
   TEST_3R("mod_u.b", 216,  80, w27, w25, w15);
   TEST_3R("mod_u.b", 224, 224, w28, w1,  w25);
   TEST_3R("mod_u.b", 232,  80, w29, w21, w26);
   TEST_3R("mod_u.b", 240,  96, w30, w20, w27);
   TEST_3R("mod_u.b",  32,  96, w31, w9,  w2);
   TEST_3R("mod_u.h",   0,  80, w0,  w5,  w21);
   TEST_3R("mod_u.h",   8,  16, w1,  w0,  w22);
   TEST_3R("mod_u.h",  16, 240, w2,  w4,  w2);
   TEST_3R("mod_u.h",  24, 208, w3,  w12, w28);
   TEST_3R("mod_u.h",  32,  96, w4,  w4,  w25);
   TEST_3R("mod_u.h",  40, 128, w5,  w13, w4);
   TEST_3R("mod_u.h",  48, 224, w6,  w28, w31);
   TEST_3R("mod_u.h",  56,  96, w7,  w21, w13);
   TEST_3R("mod_u.h",  64, 240, w8,  w15, w7);
   TEST_3R("mod_u.h",  72, 128, w9,  w10, w16);
   TEST_3R("mod_u.h",  80,  64, w10, w22, w18);
   TEST_3R("mod_u.h",  88,  96, w11, w11, w11);
   TEST_3R("mod_u.h",  96,  64, w12, w28, w28);
   TEST_3R("mod_u.h", 104, 208, w13, w1,  w12);
   TEST_3R("mod_u.h", 112,  64, w14, w0,  w24);
   TEST_3R("mod_u.h", 120, 128, w15, w29, w18);
   TEST_3R("mod_u.h", 128,  64, w16, w10, w22);
   TEST_3R("mod_u.h", 136, 240, w17, w6,  w21);
   TEST_3R("mod_u.h", 144,  80, w18, w27, w3);
   TEST_3R("mod_u.h", 152, 208, w19, w10, w9);
   TEST_3R("mod_u.h", 160,  64, w20, w21, w25);
   TEST_3R("mod_u.h", 168,  96, w21, w11, w12);
   TEST_3R("mod_u.h", 176, 240, w22, w8,  w4);
   TEST_3R("mod_u.h", 184,  16, w23, w21, w26);
   TEST_3R("mod_u.h", 192, 208, w24, w13, w11);
   TEST_3R("mod_u.h", 200,  16, w25, w31, w0);
   TEST_3R("mod_u.h", 208, 224, w26, w22, w17);
   TEST_3R("mod_u.h", 216,  80, w27, w11, w0);
   TEST_3R("mod_u.h", 224, 128, w28, w14, w2);
   TEST_3R("mod_u.h", 232,  64, w29, w25, w11);
   TEST_3R("mod_u.h", 240,  96, w30, w14, w4);
   TEST_3R("mod_u.h", 232, 224, w31, w25, w16);
   TEST_3R("mod_u.w",   0, 224, w0,  w25, w26);
   TEST_3R("mod_u.w",   8, 224, w1,  w14, w20);
   TEST_3R("mod_u.w",  16,  16, w2,  w27, w2);
   TEST_3R("mod_u.w",  24,  16, w3,  w20, w27);
   TEST_3R("mod_u.w",  32,  64, w4,  w4,  w20);
   TEST_3R("mod_u.w",  40, 128, w5,  w17, w26);
   TEST_3R("mod_u.w",  48,  96, w6,  w17, w28);
   TEST_3R("mod_u.w",  56, 128, w7,  w19, w9);
   TEST_3R("mod_u.w",  64,  80, w8,  w30, w10);
   TEST_3R("mod_u.w",  72,  96, w9,  w2,  w13);
   TEST_3R("mod_u.w",  80,  80, w10, w19, w3);
   TEST_3R("mod_u.w",  88, 128, w11, w11, w11);
   TEST_3R("mod_u.w",  96,  16, w12, w30, w30);
   TEST_3R("mod_u.w", 104, 240, w13, w26, w18);
   TEST_3R("mod_u.w", 112,  96, w14, w21, w18);
   TEST_3R("mod_u.w", 120, 240, w15, w16, w18);
   TEST_3R("mod_u.w", 128,  64, w16, w1,  w3);
   TEST_3R("mod_u.w", 136, 224, w17, w30, w20);
   TEST_3R("mod_u.w", 144, 240, w18, w9,  w7);
   TEST_3R("mod_u.w", 152,  64, w19, w13, w5);
   TEST_3R("mod_u.w", 160, 240, w20, w31, w8);
   TEST_3R("mod_u.w", 168,  80, w21, w10, w27);
   TEST_3R("mod_u.w", 176,  16, w22, w4,  w7);
   TEST_3R("mod_u.w", 184,  96, w23, w4,  w1);
   TEST_3R("mod_u.w", 192, 208, w24, w3,  w22);
   TEST_3R("mod_u.w", 200,  16, w25, w22, w7);
   TEST_3R("mod_u.w", 208,  96, w26, w29, w8);
   TEST_3R("mod_u.w", 216,  16, w27, w31, w6);
   TEST_3R("mod_u.w", 224, 240, w28, w29, w15);
   TEST_3R("mod_u.w", 232, 208, w29, w4,  w28);
   TEST_3R("mod_u.w", 240, 208, w30, w21, w27);
   TEST_3R("mod_u.w",  96,  16, w31, w20, w5);
   TEST_3R("mod_u.d",   0, 240, w0,  w9,  w7);
   TEST_3R("mod_u.d",   8,  80, w1,  w14, w8);
   TEST_3R("mod_u.d",  16, 224, w2,  w17, w2);
   TEST_3R("mod_u.d",  24, 208, w3,  w16, w8);
   TEST_3R("mod_u.d",  32, 208, w4,  w4,  w8);
   TEST_3R("mod_u.d",  40, 128, w5,  w14, w3);
   TEST_3R("mod_u.d",  48,  64, w6,  w20, w19);
   TEST_3R("mod_u.d",  56, 208, w7,  w4,  w11);
   TEST_3R("mod_u.d",  64, 128, w8,  w0,  w27);
   TEST_3R("mod_u.d",  72,  64, w9,  w13, w15);
   TEST_3R("mod_u.d",  80,  96, w10, w13, w6);
   TEST_3R("mod_u.d",  88, 128, w11, w11, w11);
   TEST_3R("mod_u.d",  96,  64, w12, w30, w30);
   TEST_3R("mod_u.d", 104,  80, w13, w28, w8);
   TEST_3R("mod_u.d", 112,  80, w14, w26, w24);
   TEST_3R("mod_u.d", 120, 224, w15, w0,  w24);
   TEST_3R("mod_u.d", 128,  80, w16, w4,  w28);
   TEST_3R("mod_u.d", 136, 224, w17, w23, w30);
   TEST_3R("mod_u.d", 144, 240, w18, w2,  w3);
   TEST_3R("mod_u.d", 152,  96, w19, w10, w30);
   TEST_3R("mod_u.d", 160, 128, w20, w23, w14);
   TEST_3R("mod_u.d", 168, 240, w21, w4,  w20);
   TEST_3R("mod_u.d", 176,  16, w22, w24, w18);
   TEST_3R("mod_u.d", 184,  96, w23, w20, w27);
   TEST_3R("mod_u.d", 192, 208, w24, w15, w19);
   TEST_3R("mod_u.d", 200, 208, w25, w15, w20);
   TEST_3R("mod_u.d", 208,  80, w26, w29, w24);
   TEST_3R("mod_u.d", 216,  16, w27, w31, w15);
   TEST_3R("mod_u.d", 224,  96, w28, w6,  w18);
   TEST_3R("mod_u.d", 232,  80, w29, w13, w28);
   TEST_3R("mod_u.d", 240,  16, w30, w16, w20);
   TEST_3R("mod_u.d",  32, 128, w31, w20, w24);
   TEST_3R("msubv.b",   0, 208, w0,  w13, w0);
   TEST_3R("msubv.b",   8, 152, w1,  w14, w4);
   TEST_3R("msubv.b",  16, 160, w2,  w24, w11);
   TEST_3R("msubv.b",  24, 120, w3,  w27, w11);
   TEST_3R("msubv.b",  32, 216, w4,  w0,  w13);
   TEST_3R("msubv.b",  40,  80, w5,  w18, w17);
   TEST_3R("msubv.b",  48,  56, w6,  w2,  w11);
   TEST_3R("msubv.b",  56, 128, w7,  w14, w19);
   TEST_3R("msubv.b",  64,  64, w8,  w18, w20);
   TEST_3R("msubv.b",  72, 144, w9,  w3,  w6);
   TEST_3R("msubv.b",  80, 160, w10, w13, w13);
   TEST_3R("msubv.b",  88, 112, w11, w10, w27);
   TEST_3R("msubv.b",  96, 128, w12, w7,  w19);
   TEST_3R("msubv.b", 104,  72, w13, w11, w15);
   TEST_3R("msubv.b", 112, 120, w14, w23, w15);
   TEST_3R("msubv.b", 120, 104, w15, w4,  w1);
   TEST_3R("msubv.b", 128,   0, w16, w16, w5);
   TEST_3R("msubv.b", 136,  96, w17, w23, w20);
   TEST_3R("msubv.b", 144,  32, w18, w18, w18);
   TEST_3R("msubv.b", 152, 232, w19, w7,  w20);
   TEST_3R("msubv.b", 160, 200, w20, w27, w8);
   TEST_3R("msubv.b", 168, 136, w21, w1,  w29);
   TEST_3R("msubv.b", 176, 128, w22, w20, w8);
   TEST_3R("msubv.b", 184, 112, w23, w12, w15);
   TEST_3R("msubv.b", 192,  48, w24, w15, w27);
   TEST_3R("msubv.b", 200, 208, w25, w29, w18);
   TEST_3R("msubv.b", 208,  80, w26, w24, w22);
   TEST_3R("msubv.b", 216, 200, w27, w4,  w26);
   TEST_3R("msubv.b", 224,   0, w28, w15, w12);
   TEST_3R("msubv.b", 232, 232, w29, w23, w0);
   TEST_3R("msubv.b", 240, 192, w30, w18, w8);
   TEST_3R("msubv.b", 152, 200, w31, w20, w6);
   TEST_3R("msubv.h",   0,  96, w0,  w14, w0);
   TEST_3R("msubv.h",   8, 216, w1,  w20, w29);
   TEST_3R("msubv.h",  16,  24, w2,  w3,  w24);
   TEST_3R("msubv.h",  24, 112, w3,  w0,  w10);
   TEST_3R("msubv.h",  32, 200, w4,  w24, w0);
   TEST_3R("msubv.h",  40, 160, w5,  w29, w28);
   TEST_3R("msubv.h",  48,  96, w6,  w25, w11);
   TEST_3R("msubv.h",  56, 128, w7,  w27, w2);
   TEST_3R("msubv.h",  64, 232, w8,  w21, w26);
   TEST_3R("msubv.h",  72, 176, w9,  w0,  w10);
   TEST_3R("msubv.h",  80,  56, w10, w14, w14);
   TEST_3R("msubv.h",  88, 144, w11, w6,  w12);
   TEST_3R("msubv.h",  96,  48, w12, w9,  w4);
   TEST_3R("msubv.h", 104, 168, w13, w10, w15);
   TEST_3R("msubv.h", 112,   0, w14, w2,  w15);
   TEST_3R("msubv.h", 120,  40, w15, w31, w11);
   TEST_3R("msubv.h", 128,  16, w16, w16, w24);
   TEST_3R("msubv.h", 136, 232, w17, w28, w19);
   TEST_3R("msubv.h", 144, 136, w18, w18, w18);
   TEST_3R("msubv.h", 152, 104, w19, w9,  w14);
   TEST_3R("msubv.h", 160,  24, w20, w23, w9);
   TEST_3R("msubv.h", 168, 200, w21, w9,  w23);
   TEST_3R("msubv.h", 176, 216, w22, w15, w3);
   TEST_3R("msubv.h", 184, 144, w23, w24, w8);
   TEST_3R("msubv.h", 192, 184, w24, w2,  w23);
   TEST_3R("msubv.h", 200, 192, w25, w5,  w6);
   TEST_3R("msubv.h", 208, 232, w26, w4,  w18);
   TEST_3R("msubv.h", 216, 112, w27, w29, w9);
   TEST_3R("msubv.h", 224,  16, w28, w16, w2);
   TEST_3R("msubv.h", 232, 232, w29, w25, w17);
   TEST_3R("msubv.h", 240,  96, w30, w14, w8);
   TEST_3R("msubv.h", 144,  72, w31, w12, w17);
   TEST_3R("msubv.w",   0,   0, w0,  w16, w0);
   TEST_3R("msubv.w",   8, 152, w1,  w25, w24);
   TEST_3R("msubv.w",  16,  96, w2,  w27, w15);
   TEST_3R("msubv.w",  24, 160, w3,  w0,  w22);
   TEST_3R("msubv.w",  32,  32, w4,  w5,  w8);
   TEST_3R("msubv.w",  40, 144, w5,  w2,  w17);
   TEST_3R("msubv.w",  48,  40, w6,  w18, w19);
   TEST_3R("msubv.w",  56,  32, w7,  w12, w4);
   TEST_3R("msubv.w",  64,   8, w8,  w26, w13);
   TEST_3R("msubv.w",  72, 200, w9,  w6,  w30);
   TEST_3R("msubv.w",  80,  40, w10, w29, w29);
   TEST_3R("msubv.w",  88,  56, w11, w9,  w4);
   TEST_3R("msubv.w",  96,  80, w12, w2,  w30);
   TEST_3R("msubv.w", 104,  96, w13, w17, w4);
   TEST_3R("msubv.w", 112,   8, w14, w7,  w26);
   TEST_3R("msubv.w", 120, 224, w15, w10, w27);
   TEST_3R("msubv.w", 128, 112, w16, w16, w13);
   TEST_3R("msubv.w", 136,  40, w17, w26, w25);
   TEST_3R("msubv.w", 144, 128, w18, w18, w18);
   TEST_3R("msubv.w", 152,  72, w19, w5,  w28);
   TEST_3R("msubv.w", 160, 144, w20, w4,  w21);
   TEST_3R("msubv.w", 168, 232, w21, w3,  w31);
   TEST_3R("msubv.w", 176, 216, w22, w27, w1);
   TEST_3R("msubv.w", 184,  56, w23, w14, w18);
   TEST_3R("msubv.w", 192, 176, w24, w2,  w26);
   TEST_3R("msubv.w", 200, 208, w25, w27, w9);
   TEST_3R("msubv.w", 208, 144, w26, w22, w10);
   TEST_3R("msubv.w", 216, 120, w27, w4,  w30);
   TEST_3R("msubv.w", 224, 120, w28, w29, w22);
   TEST_3R("msubv.w", 232,  24, w29, w17, w28);
   TEST_3R("msubv.w", 240, 232, w30, w11, w0);
   TEST_3R("msubv.w",   8, 184, w31, w2,  w3);
   TEST_3R("msubv.d",   0,  88, w0,  w30, w0);
   TEST_3R("msubv.d",   8, 192, w1,  w23, w12);
   TEST_3R("msubv.d",  16, 136, w2,  w21, w15);
   TEST_3R("msubv.d",  24, 208, w3,  w12, w10);
   TEST_3R("msubv.d",  32,   8, w4,  w14, w1);
   TEST_3R("msubv.d",  40,  88, w5,  w31, w12);
   TEST_3R("msubv.d",  48, 224, w6,  w2,  w7);
   TEST_3R("msubv.d",  56,  88, w7,  w30, w31);
   TEST_3R("msubv.d",  64,   0, w8,  w30, w13);
   TEST_3R("msubv.d",  72,   8, w9,  w1,  w26);
   TEST_3R("msubv.d",  80,  24, w10, w31, w31);
   TEST_3R("msubv.d",  88,  88, w11, w22, w12);
   TEST_3R("msubv.d",  96, 224, w12, w11, w27);
   TEST_3R("msubv.d", 104,  64, w13, w24, w5);
   TEST_3R("msubv.d", 112, 176, w14, w6,  w21);
   TEST_3R("msubv.d", 120,  32, w15, w11, w1);
   TEST_3R("msubv.d", 128,  16, w16, w16, w14);
   TEST_3R("msubv.d", 136, 112, w17, w23, w1);
   TEST_3R("msubv.d", 144, 112, w18, w18, w18);
   TEST_3R("msubv.d", 152,  96, w19, w0,  w1);
   TEST_3R("msubv.d", 160,  24, w20, w1,  w2);
   TEST_3R("msubv.d", 168, 160, w21, w0,  w2);
   TEST_3R("msubv.d", 176, 112, w22, w14, w16);
   TEST_3R("msubv.d", 184,   8, w23, w9,  w20);
   TEST_3R("msubv.d", 192,  96, w24, w14, w27);
   TEST_3R("msubv.d", 200,  32, w25, w21, w17);
   TEST_3R("msubv.d", 208,  64, w26, w0,  w18);
   TEST_3R("msubv.d", 216, 184, w27, w14, w22);
   TEST_3R("msubv.d", 224, 176, w28, w16, w25);
   TEST_3R("msubv.d", 232, 152, w29, w16, w26);
   TEST_3R("msubv.d", 240, 184, w30, w17, w28);
   TEST_3R("msubv.d",  16, 216, w31, w17, w30);
   TEST_3R("mulv.b",   0,  16, w0,  w0,  w20);
   TEST_3R("mulv.b",   8, 112, w1,  w4,  w15);
   TEST_3R("mulv.b",  16,  24, w2,  w25, w0);
   TEST_3R("mulv.b",  24, 200, w3,  w25, w19);
   TEST_3R("mulv.b",  32, 152, w4,  w8,  w9);
   TEST_3R("mulv.b",  40,  96, w5,  w24, w2);
   TEST_3R("mulv.b",  48,   8, w6,  w8,  w28);
   TEST_3R("mulv.b",  56, 120, w7,  w25, w2);
   TEST_3R("mulv.b",  64, 144, w8,  w23, w17);
   TEST_3R("mulv.b",  72, 144, w9,  w4,  w9);
   TEST_3R("mulv.b",  80, 112, w10, w27, w25);
   TEST_3R("mulv.b",  88,  32, w11, w30, w29);
   TEST_3R("mulv.b",  96,  32, w12, w12, w12);
   TEST_3R("mulv.b", 104,  56, w13, w22, w21);
   TEST_3R("mulv.b", 112,  24, w14, w16, w8);
   TEST_3R("mulv.b", 120,  48, w15, w24, w18);
   TEST_3R("mulv.b", 128, 152, w16, w20, w7);
   TEST_3R("mulv.b", 136,  80, w17, w1,  w10);
   TEST_3R("mulv.b", 144, 112, w18, w27, w1);
   TEST_3R("mulv.b", 152,  16, w19, w12, w5);
   TEST_3R("mulv.b", 160, 136, w20, w7,  w31);
   TEST_3R("mulv.b", 168, 184, w21, w6,  w6);
   TEST_3R("mulv.b", 176, 208, w22, w1,  w8);
   TEST_3R("mulv.b", 184,  80, w23, w22, w19);
   TEST_3R("mulv.b", 192,   8, w24, w31, w29);
   TEST_3R("mulv.b", 200,  88, w25, w17, w19);
   TEST_3R("mulv.b", 208, 112, w26, w5,  w27);
   TEST_3R("mulv.b", 216, 192, w27, w22, w28);
   TEST_3R("mulv.b", 224, 176, w28, w0,  w15);
   TEST_3R("mulv.b", 232, 160, w29, w21, w27);
   TEST_3R("mulv.b", 240, 160, w30, w27, w3);
   TEST_3R("mulv.b", 152, 224, w31, w7,  w9);
   TEST_3R("mulv.h",   0, 192, w0,  w0,  w17);
   TEST_3R("mulv.h",   8, 152, w1,  w31, w4);
   TEST_3R("mulv.h",  16, 160, w2,  w30, w1);
   TEST_3R("mulv.h",  24,   8, w3,  w15, w20);
   TEST_3R("mulv.h",  32,   0, w4,  w20, w15);
   TEST_3R("mulv.h",  40, 192, w5,  w11, w12);
   TEST_3R("mulv.h",  48,  96, w6,  w11, w12);
   TEST_3R("mulv.h",  56, 224, w7,  w13, w1);
   TEST_3R("mulv.h",  64, 224, w8,  w21, w28);
   TEST_3R("mulv.h",  72, 160, w9,  w27, w9);
   TEST_3R("mulv.h",  80, 184, w10, w12, w30);
   TEST_3R("mulv.h",  88, 216, w11, w29, w20);
   TEST_3R("mulv.h",  96,  16, w12, w12, w12);
   TEST_3R("mulv.h", 104,  32, w13, w9,  w2);
   TEST_3R("mulv.h", 112,  48, w14, w24, w23);
   TEST_3R("mulv.h", 120, 160, w15, w13, w6);
   TEST_3R("mulv.h", 128, 120, w16, w24, w18);
   TEST_3R("mulv.h", 136,  88, w17, w3,  w30);
   TEST_3R("mulv.h", 144,  72, w18, w17, w31);
   TEST_3R("mulv.h", 152, 176, w19, w6,  w28);
   TEST_3R("mulv.h", 160, 200, w20, w1,  w0);
   TEST_3R("mulv.h", 168,  40, w21, w0,  w0);
   TEST_3R("mulv.h", 176, 136, w22, w11, w20);
   TEST_3R("mulv.h", 184,  80, w23, w13, w2);
   TEST_3R("mulv.h", 192, 216, w24, w15, w3);
   TEST_3R("mulv.h", 200, 112, w25, w6,  w4);
   TEST_3R("mulv.h", 208, 184, w26, w13, w6);
   TEST_3R("mulv.h", 216, 168, w27, w31, w2);
   TEST_3R("mulv.h", 224, 136, w28, w19, w29);
   TEST_3R("mulv.h", 232,  56, w29, w25, w28);
   TEST_3R("mulv.h", 240, 200, w30, w25, w10);
   TEST_3R("mulv.h", 136, 184, w31, w6,  w21);
   TEST_3R("mulv.w",   0,  48, w0,  w0,  w2);
   TEST_3R("mulv.w",   8, 176, w1,  w31, w18);
   TEST_3R("mulv.w",  16, 232, w2,  w25, w24);
   TEST_3R("mulv.w",  24, 200, w3,  w0,  w5);
   TEST_3R("mulv.w",  32, 168, w4,  w31, w5);
   TEST_3R("mulv.w",  40, 232, w5,  w2,  w3);
   TEST_3R("mulv.w",  48,   0, w6,  w21, w0);
   TEST_3R("mulv.w",  56, 192, w7,  w15, w26);
   TEST_3R("mulv.w",  64, 216, w8,  w10, w19);
   TEST_3R("mulv.w",  72,   8, w9,  w5,  w9);
   TEST_3R("mulv.w",  80,  16, w10, w17, w20);
   TEST_3R("mulv.w",  88, 112, w11, w19, w6);
   TEST_3R("mulv.w",  96,   0, w12, w12, w12);
   TEST_3R("mulv.w", 104, 184, w13, w27, w16);
   TEST_3R("mulv.w", 112, 128, w14, w20, w17);
   TEST_3R("mulv.w", 120, 200, w15, w19, w16);
   TEST_3R("mulv.w", 128, 184, w16, w18, w11);
   TEST_3R("mulv.w", 136, 192, w17, w8,  w12);
   TEST_3R("mulv.w", 144,  16, w18, w23, w6);
   TEST_3R("mulv.w", 152, 104, w19, w1,  w25);
   TEST_3R("mulv.w", 160, 208, w20, w6,  w19);
   TEST_3R("mulv.w", 168,  72, w21, w26, w26);
   TEST_3R("mulv.w", 176, 192, w22, w20, w0);
   TEST_3R("mulv.w", 184, 144, w23, w25, w27);
   TEST_3R("mulv.w", 192,  48, w24, w23, w15);
   TEST_3R("mulv.w", 200, 208, w25, w27, w3);
   TEST_3R("mulv.w", 208,  48, w26, w3,  w21);
   TEST_3R("mulv.w", 216, 216, w27, w15, w2);
   TEST_3R("mulv.w", 224, 144, w28, w27, w4);
   TEST_3R("mulv.w", 232, 144, w29, w1,  w24);
   TEST_3R("mulv.w", 240, 168, w30, w26, w8);
   TEST_3R("mulv.w", 152, 160, w31, w13, w8);
   TEST_3R("mulv.d",   0,  48, w0,  w0,  w28);
   TEST_3R("mulv.d",   8,  32, w1,  w25, w22);
   TEST_3R("mulv.d",  16, 192, w2,  w11, w13);
   TEST_3R("mulv.d",  24, 144, w3,  w14, w8);
   TEST_3R("mulv.d",  32, 184, w4,  w2,  w12);
   TEST_3R("mulv.d",  40,  40, w5,  w8,  w27);
   TEST_3R("mulv.d",  48, 184, w6,  w22, w16);
   TEST_3R("mulv.d",  56, 208, w7,  w23, w9);
   TEST_3R("mulv.d",  64,  24, w8,  w17, w13);
   TEST_3R("mulv.d",  72,  48, w9,  w25, w9);
   TEST_3R("mulv.d",  80, 104, w10, w23, w22);
   TEST_3R("mulv.d",  88, 136, w11, w16, w12);
   TEST_3R("mulv.d",  96, 168, w12, w12, w12);
   TEST_3R("mulv.d", 104, 216, w13, w25, w15);
   TEST_3R("mulv.d", 112, 104, w14, w2,  w4);
   TEST_3R("mulv.d", 120,  40, w15, w14, w20);
   TEST_3R("mulv.d", 128, 216, w16, w26, w10);
   TEST_3R("mulv.d", 136,  16, w17, w10, w5);
   TEST_3R("mulv.d", 144, 208, w18, w19, w6);
   TEST_3R("mulv.d", 152,  40, w19, w4,  w6);
   TEST_3R("mulv.d", 160,  96, w20, w7,  w29);
   TEST_3R("mulv.d", 168, 216, w21, w1,  w1);
   TEST_3R("mulv.d", 176,  24, w22, w0,  w30);
   TEST_3R("mulv.d", 184, 112, w23, w25, w13);
   TEST_3R("mulv.d", 192, 224, w24, w27, w17);
   TEST_3R("mulv.d", 200,  32, w25, w9,  w31);
   TEST_3R("mulv.d", 208,   0, w26, w18, w25);
   TEST_3R("mulv.d", 216,  16, w27, w17, w4);
   TEST_3R("mulv.d", 224,   8, w28, w7,  w23);
   TEST_3R("mulv.d", 232,   8, w29, w15, w28);
   TEST_3R("mulv.d", 240,  64, w30, w21, w26);
   TEST_3R("mulv.d",  96, 104, w31, w19, w14);
   TEST_3R("subs_s.b",   0,  64, w0,  w20, w31);
   TEST_3R("subs_s.b",   8, 120, w1,  w5,  w0);
   TEST_3R("subs_s.b",  16,  88, w2,  w5,  w22);
   TEST_3R("subs_s.b",  24, 160, w3,  w30, w22);
   TEST_3R("subs_s.b",  32, 136, w4,  w2,  w27);
   TEST_3R("subs_s.b",  40,  64, w5,  w26, w7);
   TEST_3R("subs_s.b",  48, 160, w6,  w6,  w22);
   TEST_3R("subs_s.b",  56, 224, w7,  w28, w28);
   TEST_3R("subs_s.b",  64,  24, w8,  w13, w15);
   TEST_3R("subs_s.b",  72, 104, w9,  w21, w16);
   TEST_3R("subs_s.b",  80, 144, w10, w28, w27);
   TEST_3R("subs_s.b",  88,  72, w11, w16, w11);
   TEST_3R("subs_s.b",  96, 168, w12, w22, w21);
   TEST_3R("subs_s.b", 104, 176, w13, w3,  w26);
   TEST_3R("subs_s.b", 112,  64, w14, w14, w14);
   TEST_3R("subs_s.b", 120, 224, w15, w25, w7);
   TEST_3R("subs_s.b", 128, 232, w16, w27, w3);
   TEST_3R("subs_s.b", 136, 176, w17, w21, w10);
   TEST_3R("subs_s.b", 144,  56, w18, w11, w17);
   TEST_3R("subs_s.b", 152, 168, w19, w27, w31);
   TEST_3R("subs_s.b", 160, 208, w20, w25, w14);
   TEST_3R("subs_s.b", 168, 232, w21, w16, w9);
   TEST_3R("subs_s.b", 176, 200, w22, w0,  w4);
   TEST_3R("subs_s.b", 184, 176, w23, w22, w0);
   TEST_3R("subs_s.b", 192, 112, w24, w16, w17);
   TEST_3R("subs_s.b", 200, 192, w25, w9,  w7);
   TEST_3R("subs_s.b", 208,  24, w26, w28, w17);
   TEST_3R("subs_s.b", 216, 112, w27, w6,  w3);
   TEST_3R("subs_s.b", 224,  80, w28, w24, w17);
   TEST_3R("subs_s.b", 232, 184, w29, w23, w14);
   TEST_3R("subs_s.b", 240,  32, w30, w11, w28);
   TEST_3R("subs_s.b",  88,  24, w31, w28, w6);
   TEST_3R("subs_s.h",   0,  80, w0,  w10, w9);
   TEST_3R("subs_s.h",   8,  48, w1,  w10, w27);
   TEST_3R("subs_s.h",  16,  56, w2,  w28, w16);
   TEST_3R("subs_s.h",  24, 128, w3,  w21, w23);
   TEST_3R("subs_s.h",  32, 152, w4,  w17, w8);
   TEST_3R("subs_s.h",  40,  32, w5,  w23, w11);
   TEST_3R("subs_s.h",  48, 184, w6,  w6,  w15);
   TEST_3R("subs_s.h",  56, 192, w7,  w19, w19);
   TEST_3R("subs_s.h",  64, 192, w8,  w11, w14);
   TEST_3R("subs_s.h",  72,  24, w9,  w7,  w15);
   TEST_3R("subs_s.h",  80, 120, w10, w13, w8);
   TEST_3R("subs_s.h",  88,  80, w11, w24, w11);
   TEST_3R("subs_s.h",  96, 232, w12, w29, w2);
   TEST_3R("subs_s.h", 104,  24, w13, w0,  w30);
   TEST_3R("subs_s.h", 112, 168, w14, w14, w14);
   TEST_3R("subs_s.h", 120,  56, w15, w19, w20);
   TEST_3R("subs_s.h", 128,  88, w16, w4,  w28);
   TEST_3R("subs_s.h", 136, 120, w17, w28, w8);
   TEST_3R("subs_s.h", 144, 216, w18, w11, w4);
   TEST_3R("subs_s.h", 152, 136, w19, w18, w15);
   TEST_3R("subs_s.h", 160, 216, w20, w4,  w23);
   TEST_3R("subs_s.h", 168,  64, w21, w18, w4);
   TEST_3R("subs_s.h", 176, 120, w22, w28, w7);
   TEST_3R("subs_s.h", 184, 120, w23, w31, w20);
   TEST_3R("subs_s.h", 192,  48, w24, w29, w17);
   TEST_3R("subs_s.h", 200, 224, w25, w17, w5);
   TEST_3R("subs_s.h", 208,  72, w26, w21, w1);
   TEST_3R("subs_s.h", 216,  72, w27, w17, w9);
   TEST_3R("subs_s.h", 224,  56, w28, w29, w14);
   TEST_3R("subs_s.h", 232, 128, w29, w15, w23);
   TEST_3R("subs_s.h", 240, 176, w30, w20, w4);
   TEST_3R("subs_s.h",  96, 224, w31, w25, w26);
   TEST_3R("subs_s.w",   0, 224, w0,  w1,  w27);
   TEST_3R("subs_s.w",   8, 128, w1,  w21, w20);
   TEST_3R("subs_s.w",  16, 160, w2,  w6,  w26);
   TEST_3R("subs_s.w",  24,   8, w3,  w11, w30);
   TEST_3R("subs_s.w",  32, 224, w4,  w12, w10);
   TEST_3R("subs_s.w",  40, 128, w5,  w22, w7);
   TEST_3R("subs_s.w",  48, 192, w6,  w6,  w16);
   TEST_3R("subs_s.w",  56, 160, w7,  w1,  w1);
   TEST_3R("subs_s.w",  64, 216, w8,  w9,  w22);
   TEST_3R("subs_s.w",  72, 208, w9,  w14, w15);
   TEST_3R("subs_s.w",  80, 112, w10, w15, w4);
   TEST_3R("subs_s.w",  88, 232, w11, w10, w11);
   TEST_3R("subs_s.w",  96, 232, w12, w28, w31);
   TEST_3R("subs_s.w", 104, 152, w13, w2,  w25);
   TEST_3R("subs_s.w", 112, 200, w14, w14, w14);
   TEST_3R("subs_s.w", 120, 232, w15, w24, w6);
   TEST_3R("subs_s.w", 128, 136, w16, w4,  w15);
   TEST_3R("subs_s.w", 136, 232, w17, w23, w19);
   TEST_3R("subs_s.w", 144, 160, w18, w13, w21);
   TEST_3R("subs_s.w", 152,   8, w19, w22, w11);
   TEST_3R("subs_s.w", 160,  96, w20, w4,  w26);
   TEST_3R("subs_s.w", 168,  88, w21, w20, w30);
   TEST_3R("subs_s.w", 176, 128, w22, w30, w23);
   TEST_3R("subs_s.w", 184, 152, w23, w29, w2);
   TEST_3R("subs_s.w", 192, 224, w24, w23, w16);
   TEST_3R("subs_s.w", 200,  96, w25, w15, w23);
   TEST_3R("subs_s.w", 208, 184, w26, w19, w7);
   TEST_3R("subs_s.w", 216, 176, w27, w14, w31);
   TEST_3R("subs_s.w", 224, 216, w28, w25, w12);
   TEST_3R("subs_s.w", 232, 112, w29, w12, w3);
   TEST_3R("subs_s.w", 240,  40, w30, w10, w7);
   TEST_3R("subs_s.w", 168,  88, w31, w15, w27);
   TEST_3R("subs_s.d",   0,  64, w0,  w26, w3);
   TEST_3R("subs_s.d",   8,  88, w1,  w23, w5);
   TEST_3R("subs_s.d",  16,  80, w2,  w14, w22);
   TEST_3R("subs_s.d",  24, 176, w3,  w29, w13);
   TEST_3R("subs_s.d",  32,   0, w4,  w17, w20);
   TEST_3R("subs_s.d",  40, 176, w5,  w31, w19);
   TEST_3R("subs_s.d",  48, 208, w6,  w6,  w25);
   TEST_3R("subs_s.d",  56,  32, w7,  w12, w12);
   TEST_3R("subs_s.d",  64,   8, w8,  w3,  w31);
   TEST_3R("subs_s.d",  72,  88, w9,  w10, w12);
   TEST_3R("subs_s.d",  80,  24, w10, w6,  w24);
   TEST_3R("subs_s.d",  88, 168, w11, w0,  w11);
   TEST_3R("subs_s.d",  96,  80, w12, w27, w23);
   TEST_3R("subs_s.d", 104,   8, w13, w6,  w22);
   TEST_3R("subs_s.d", 112, 144, w14, w14, w14);
   TEST_3R("subs_s.d", 120, 208, w15, w3,  w26);
   TEST_3R("subs_s.d", 128, 224, w16, w24, w12);
   TEST_3R("subs_s.d", 136,  40, w17, w11, w16);
   TEST_3R("subs_s.d", 144, 192, w18, w11, w29);
   TEST_3R("subs_s.d", 152, 208, w19, w14, w28);
   TEST_3R("subs_s.d", 160, 176, w20, w25, w9);
   TEST_3R("subs_s.d", 168, 200, w21, w31, w1);
   TEST_3R("subs_s.d", 176,  32, w22, w31, w28);
   TEST_3R("subs_s.d", 184, 200, w23, w22, w28);
   TEST_3R("subs_s.d", 192, 208, w24, w28, w19);
   TEST_3R("subs_s.d", 200, 136, w25, w0,  w22);
   TEST_3R("subs_s.d", 208, 200, w26, w20, w14);
   TEST_3R("subs_s.d", 216,  72, w27, w8,  w26);
   TEST_3R("subs_s.d", 224, 208, w28, w21, w5);
   TEST_3R("subs_s.d", 232, 144, w29, w7,  w20);
   TEST_3R("subs_s.d", 240,  24, w30, w9,  w13);
   TEST_3R("subs_s.d", 160,  56, w31, w9,  w12);
   TEST_3R("subs_u.b",   0, 232, w0,  w22, w16);
   TEST_3R("subs_u.b",   8,   0, w1,  w9,  w9);
   TEST_3R("subs_u.b",  16, 144, w2,  w30, w31);
   TEST_3R("subs_u.b",  24, 216, w3,  w18, w14);
   TEST_3R("subs_u.b",  32, 160, w4,  w27, w8);
   TEST_3R("subs_u.b",  40, 136, w5,  w16, w13);
   TEST_3R("subs_u.b",  48, 152, w6,  w24, w1);
   TEST_3R("subs_u.b",  56,  56, w7,  w1,  w14);
   TEST_3R("subs_u.b",  64, 232, w8,  w10, w26);
   TEST_3R("subs_u.b",  72, 128, w9,  w12, w5);
   TEST_3R("subs_u.b",  80, 184, w10, w2,  w7);
   TEST_3R("subs_u.b",  88,   0, w11, w11, w11);
   TEST_3R("subs_u.b",  96,   0, w12, w5,  w17);
   TEST_3R("subs_u.b", 104,  16, w13, w3,  w17);
   TEST_3R("subs_u.b", 112,   0, w14, w21, w31);
   TEST_3R("subs_u.b", 120, 160, w15, w16, w7);
   TEST_3R("subs_u.b", 128, 176, w16, w1,  w20);
   TEST_3R("subs_u.b", 136,  96, w17, w25, w22);
   TEST_3R("subs_u.b", 144,  24, w18, w26, w4);
   TEST_3R("subs_u.b", 152,  16, w19, w4,  w31);
   TEST_3R("subs_u.b", 160, 144, w20, w16, w4);
   TEST_3R("subs_u.b", 168, 208, w21, w18, w11);
   TEST_3R("subs_u.b", 176,  64, w22, w4,  w22);
   TEST_3R("subs_u.b", 184, 112, w23, w17, w10);
   TEST_3R("subs_u.b", 192, 120, w24, w2,  w1);
   TEST_3R("subs_u.b", 200,  64, w25, w25, w1);
   TEST_3R("subs_u.b", 208, 232, w26, w25, w8);
   TEST_3R("subs_u.b", 216,  40, w27, w26, w29);
   TEST_3R("subs_u.b", 224, 216, w28, w19, w27);
   TEST_3R("subs_u.b", 232, 192, w29, w23, w7);
   TEST_3R("subs_u.b", 240,  48, w30, w22, w12);
   TEST_3R("subs_u.b",  80,  96, w31, w27, w3);
   TEST_3R("subs_u.h",   0, 144, w0,  w3,  w24);
   TEST_3R("subs_u.h",   8, 192, w1,  w21, w21);
   TEST_3R("subs_u.h",  16,  16, w2,  w10, w23);
   TEST_3R("subs_u.h",  24,  80, w3,  w19, w25);
   TEST_3R("subs_u.h",  32, 192, w4,  w13, w1);
   TEST_3R("subs_u.h",  40, 232, w5,  w7,  w30);
   TEST_3R("subs_u.h",  48,   0, w6,  w27, w17);
   TEST_3R("subs_u.h",  56,  40, w7,  w8,  w9);
   TEST_3R("subs_u.h",  64, 104, w8,  w26, w31);
   TEST_3R("subs_u.h",  72,  72, w9,  w27, w26);
   TEST_3R("subs_u.h",  80, 120, w10, w15, w1);
   TEST_3R("subs_u.h",  88,  32, w11, w11, w11);
   TEST_3R("subs_u.h",  96, 232, w12, w24, w4);
   TEST_3R("subs_u.h", 104, 120, w13, w2,  w28);
   TEST_3R("subs_u.h", 112,  80, w14, w22, w21);
   TEST_3R("subs_u.h", 120,  32, w15, w3,  w22);
   TEST_3R("subs_u.h", 128, 136, w16, w10, w21);
   TEST_3R("subs_u.h", 136, 144, w17, w5,  w6);
   TEST_3R("subs_u.h", 144, 192, w18, w14, w15);
   TEST_3R("subs_u.h", 152,  56, w19, w8,  w15);
   TEST_3R("subs_u.h", 160,   0, w20, w3,  w9);
   TEST_3R("subs_u.h", 168,   0, w21, w18, w10);
   TEST_3R("subs_u.h", 176, 192, w22, w25, w22);
   TEST_3R("subs_u.h", 184,  16, w23, w9,  w3);
   TEST_3R("subs_u.h", 192, 216, w24, w5,  w16);
   TEST_3R("subs_u.h", 200,  32, w25, w25, w26);
   TEST_3R("subs_u.h", 208,  72, w26, w30, w17);
   TEST_3R("subs_u.h", 216, 216, w27, w8,  w6);
   TEST_3R("subs_u.h", 224, 232, w28, w14, w12);
   TEST_3R("subs_u.h", 232,  96, w29, w28, w30);
   TEST_3R("subs_u.h", 240,   0, w30, w11, w7);
   TEST_3R("subs_u.h", 104, 168, w31, w20, w29);
   TEST_3R("subs_u.w",   0, 176, w0,  w2,  w19);
   TEST_3R("subs_u.w",   8, 192, w1,  w11, w11);
   TEST_3R("subs_u.w",  16, 144, w2,  w6,  w17);
   TEST_3R("subs_u.w",  24, 184, w3,  w1,  w11);
   TEST_3R("subs_u.w",  32, 128, w4,  w31, w28);
   TEST_3R("subs_u.w",  40, 216, w5,  w8,  w2);
   TEST_3R("subs_u.w",  48, 216, w6,  w22, w15);
   TEST_3R("subs_u.w",  56,  40, w7,  w18, w11);
   TEST_3R("subs_u.w",  64,  72, w8,  w22, w0);
   TEST_3R("subs_u.w",  72,   0, w9,  w10, w29);
   TEST_3R("subs_u.w",  80,   8, w10, w9,  w31);
   TEST_3R("subs_u.w",  88, 120, w11, w11, w11);
   TEST_3R("subs_u.w",  96, 192, w12, w11, w1);
   TEST_3R("subs_u.w", 104,   0, w13, w28, w8);
   TEST_3R("subs_u.w", 112,  16, w14, w7,  w4);
   TEST_3R("subs_u.w", 120, 104, w15, w4,  w10);
   TEST_3R("subs_u.w", 128, 192, w16, w6,  w8);
   TEST_3R("subs_u.w", 136,  32, w17, w21, w3);
   TEST_3R("subs_u.w", 144, 104, w18, w0,  w28);
   TEST_3R("subs_u.w", 152,  48, w19, w22, w28);
   TEST_3R("subs_u.w", 160, 168, w20, w1,  w26);
   TEST_3R("subs_u.w", 168, 184, w21, w10, w25);
   TEST_3R("subs_u.w", 176, 144, w22, w21, w22);
   TEST_3R("subs_u.w", 184, 112, w23, w26, w7);
   TEST_3R("subs_u.w", 192, 152, w24, w2,  w26);
   TEST_3R("subs_u.w", 200, 168, w25, w25, w7);
   TEST_3R("subs_u.w", 208, 144, w26, w12, w17);
   TEST_3R("subs_u.w", 216,  96, w27, w18, w25);
   TEST_3R("subs_u.w", 224, 120, w28, w8,  w26);
   TEST_3R("subs_u.w", 232,  56, w29, w24, w18);
   TEST_3R("subs_u.w", 240,  80, w30, w20, w8);
   TEST_3R("subs_u.w", 136,  40, w31, w14, w22);
   TEST_3R("subs_u.d",   0, 168, w0,  w14, w12);
   TEST_3R("subs_u.d",   8,  24, w1,  w7,  w7);
   TEST_3R("subs_u.d",  16, 176, w2,  w11, w1);
   TEST_3R("subs_u.d",  24, 208, w3,  w18, w13);
   TEST_3R("subs_u.d",  32,  80, w4,  w3,  w20);
   TEST_3R("subs_u.d",  40,   8, w5,  w28, w12);
   TEST_3R("subs_u.d",  48, 144, w6,  w24, w4);
   TEST_3R("subs_u.d",  56,  16, w7,  w24, w3);
   TEST_3R("subs_u.d",  64, 128, w8,  w1,  w3);
   TEST_3R("subs_u.d",  72, 136, w9,  w23, w13);
   TEST_3R("subs_u.d",  80, 176, w10, w5,  w13);
   TEST_3R("subs_u.d",  88,  72, w11, w11, w11);
   TEST_3R("subs_u.d",  96,  64, w12, w20, w25);
   TEST_3R("subs_u.d", 104, 192, w13, w9,  w11);
   TEST_3R("subs_u.d", 112,  56, w14, w10, w23);
   TEST_3R("subs_u.d", 120,  72, w15, w10, w3);
   TEST_3R("subs_u.d", 128,  72, w16, w2,  w9);
   TEST_3R("subs_u.d", 136, 144, w17, w18, w2);
   TEST_3R("subs_u.d", 144,  48, w18, w22, w3);
   TEST_3R("subs_u.d", 152, 112, w19, w9,  w26);
   TEST_3R("subs_u.d", 160,  56, w20, w4,  w31);
   TEST_3R("subs_u.d", 168,  48, w21, w12, w13);
   TEST_3R("subs_u.d", 176,  64, w22, w0,  w22);
   TEST_3R("subs_u.d", 184,   0, w23, w8,  w10);
   TEST_3R("subs_u.d", 192, 232, w24, w11, w20);
   TEST_3R("subs_u.d", 200, 144, w25, w25, w3);
   TEST_3R("subs_u.d", 208,  88, w26, w9,  w6);
   TEST_3R("subs_u.d", 216, 168, w27, w11, w16);
   TEST_3R("subs_u.d", 224,  72, w28, w29, w18);
   TEST_3R("subs_u.d", 232, 232, w29, w20, w21);
   TEST_3R("subs_u.d", 240, 104, w30, w29, w15);
   TEST_3R("subs_u.d", 168,  40, w31, w2,  w14);
   TEST_3R("subsus_u.b",   0, 144, w0,  w24, w20);
   TEST_3R("subsus_u.b",   8,  64, w1,  w13, w19);
   TEST_3R("subsus_u.b",  16, 232, w2,  w31, w31);
   TEST_3R("subsus_u.b",  24,   8, w3,  w13, w11);
   TEST_3R("subsus_u.b",  32,  32, w4,  w29, w21);
   TEST_3R("subsus_u.b",  40, 104, w5,  w15, w31);
   TEST_3R("subsus_u.b",  48, 208, w6,  w4,  w12);
   TEST_3R("subsus_u.b",  56,  24, w7,  w19, w11);
   TEST_3R("subsus_u.b",  64,  40, w8,  w2,  w7);
   TEST_3R("subsus_u.b",  72,  48, w9,  w24, w22);
   TEST_3R("subsus_u.b",  80, 160, w10, w16, w14);
   TEST_3R("subsus_u.b",  88, 152, w11, w20, w27);
   TEST_3R("subsus_u.b",  96,  72, w12, w27, w5);
   TEST_3R("subsus_u.b", 104, 176, w13, w6,  w27);
   TEST_3R("subsus_u.b", 112,  24, w14, w22, w14);
   TEST_3R("subsus_u.b", 120, 176, w15, w13, w26);
   TEST_3R("subsus_u.b", 128, 152, w16, w16, w5);
   TEST_3R("subsus_u.b", 136, 144, w17, w18, w30);
   TEST_3R("subsus_u.b", 144, 184, w18, w26, w6);
   TEST_3R("subsus_u.b", 152, 104, w19, w18, w28);
   TEST_3R("subsus_u.b", 160,  32, w20, w2,  w10);
   TEST_3R("subsus_u.b", 168, 184, w21, w23, w6);
   TEST_3R("subsus_u.b", 176, 208, w22, w18, w1);
   TEST_3R("subsus_u.b", 184, 232, w23, w27, w7);
   TEST_3R("subsus_u.b", 192, 176, w24, w2,  w3);
   TEST_3R("subsus_u.b", 200,  88, w25, w24, w29);
   TEST_3R("subsus_u.b", 208,  96, w26, w18, w4);
   TEST_3R("subsus_u.b", 216, 128, w27, w0,  w22);
   TEST_3R("subsus_u.b", 224,  16, w28, w28, w28);
   TEST_3R("subsus_u.b", 232, 200, w29, w16, w8);
   TEST_3R("subsus_u.b", 240, 184, w30, w2,  w4);
   TEST_3R("subsus_u.b",  40, 224, w31, w5,  w14);
   TEST_3R("subsus_u.h",   0, 120, w0,  w20, w27);
   TEST_3R("subsus_u.h",   8, 152, w1,  w21, w11);
   TEST_3R("subsus_u.h",  16, 120, w2,  w29, w29);
   TEST_3R("subsus_u.h",  24, 168, w3,  w12, w0);
   TEST_3R("subsus_u.h",  32, 208, w4,  w29, w24);
   TEST_3R("subsus_u.h",  40,  80, w5,  w2,  w27);
   TEST_3R("subsus_u.h",  48,  96, w6,  w24, w29);
   TEST_3R("subsus_u.h",  56, 176, w7,  w9,  w5);
   TEST_3R("subsus_u.h",  64,   0, w8,  w11, w9);
   TEST_3R("subsus_u.h",  72, 224, w9,  w16, w24);
   TEST_3R("subsus_u.h",  80, 120, w10, w12, w30);
   TEST_3R("subsus_u.h",  88, 144, w11, w2,  w9);
   TEST_3R("subsus_u.h",  96,  48, w12, w31, w17);
   TEST_3R("subsus_u.h", 104,  64, w13, w31, w11);
   TEST_3R("subsus_u.h", 112,  80, w14, w28, w14);
   TEST_3R("subsus_u.h", 120,  72, w15, w11, w30);
   TEST_3R("subsus_u.h", 128, 208, w16, w16, w2);
   TEST_3R("subsus_u.h", 136,   0, w17, w28, w10);
   TEST_3R("subsus_u.h", 144,   8, w18, w1,  w16);
   TEST_3R("subsus_u.h", 152, 200, w19, w11, w3);
   TEST_3R("subsus_u.h", 160, 200, w20, w3,  w6);
   TEST_3R("subsus_u.h", 168,  80, w21, w15, w4);
   TEST_3R("subsus_u.h", 176, 104, w22, w17, w13);
   TEST_3R("subsus_u.h", 184, 152, w23, w16, w30);
   TEST_3R("subsus_u.h", 192,  88, w24, w15, w9);
   TEST_3R("subsus_u.h", 200, 104, w25, w12, w26);
   TEST_3R("subsus_u.h", 208, 192, w26, w11, w28);
   TEST_3R("subsus_u.h", 216,  64, w27, w7,  w6);
   TEST_3R("subsus_u.h", 224, 200, w28, w28, w28);
   TEST_3R("subsus_u.h", 232, 176, w29, w22, w13);
   TEST_3R("subsus_u.h", 240, 128, w30, w25, w9);
   TEST_3R("subsus_u.h",  64,   0, w31, w17, w6);
   TEST_3R("subsus_u.w",   0, 168, w0,  w23, w16);
   TEST_3R("subsus_u.w",   8, 192, w1,  w8,  w15);
   TEST_3R("subsus_u.w",  16, 168, w2,  w23, w23);
   TEST_3R("subsus_u.w",  24, 216, w3,  w5,  w31);
   TEST_3R("subsus_u.w",  32,  40, w4,  w16, w28);
   TEST_3R("subsus_u.w",  40, 112, w5,  w23, w2);
   TEST_3R("subsus_u.w",  48,  56, w6,  w31, w25);
   TEST_3R("subsus_u.w",  56, 208, w7,  w19, w18);
   TEST_3R("subsus_u.w",  64,  88, w8,  w9,  w18);
   TEST_3R("subsus_u.w",  72,  24, w9,  w15, w21);
   TEST_3R("subsus_u.w",  80, 200, w10, w7,  w6);
   TEST_3R("subsus_u.w",  88, 160, w11, w15, w21);
   TEST_3R("subsus_u.w",  96,  80, w12, w6,  w13);
   TEST_3R("subsus_u.w", 104, 144, w13, w10, w18);
   TEST_3R("subsus_u.w", 112, 144, w14, w24, w14);
   TEST_3R("subsus_u.w", 120,   8, w15, w3,  w7);
   TEST_3R("subsus_u.w", 128, 120, w16, w16, w5);
   TEST_3R("subsus_u.w", 136, 176, w17, w25, w30);
   TEST_3R("subsus_u.w", 144, 152, w18, w12, w17);
   TEST_3R("subsus_u.w", 152, 112, w19, w21, w3);
   TEST_3R("subsus_u.w", 160,  16, w20, w5,  w24);
   TEST_3R("subsus_u.w", 168, 216, w21, w12, w30);
   TEST_3R("subsus_u.w", 176,  16, w22, w27, w19);
   TEST_3R("subsus_u.w", 184,  72, w23, w1,  w24);
   TEST_3R("subsus_u.w", 192,  32, w24, w19, w31);
   TEST_3R("subsus_u.w", 200,  40, w25, w22, w2);
   TEST_3R("subsus_u.w", 208, 160, w26, w15, w7);
   TEST_3R("subsus_u.w", 216, 216, w27, w8,  w6);
   TEST_3R("subsus_u.w", 224,  32, w28, w28, w28);
   TEST_3R("subsus_u.w", 232, 168, w29, w23, w10);
   TEST_3R("subsus_u.w", 240, 160, w30, w13, w15);
   TEST_3R("subsus_u.w", 232, 224, w31, w17, w27);
   TEST_3R("subsus_u.d",   0, 128, w0,  w22, w4);
   TEST_3R("subsus_u.d",   8, 232, w1,  w23, w5);
   TEST_3R("subsus_u.d",  16,   8, w2,  w3,  w3);
   TEST_3R("subsus_u.d",  24, 104, w3,  w7,  w6);
   TEST_3R("subsus_u.d",  32, 216, w4,  w9,  w17);
   TEST_3R("subsus_u.d",  40, 160, w5,  w16, w21);
   TEST_3R("subsus_u.d",  48,  72, w6,  w22, w15);
   TEST_3R("subsus_u.d",  56, 208, w7,  w13, w6);
   TEST_3R("subsus_u.d",  64,  80, w8,  w7,  w20);
   TEST_3R("subsus_u.d",  72, 168, w9,  w26, w5);
   TEST_3R("subsus_u.d",  80, 112, w10, w11, w4);
   TEST_3R("subsus_u.d",  88,   8, w11, w15, w20);
   TEST_3R("subsus_u.d",  96, 224, w12, w21, w28);
   TEST_3R("subsus_u.d", 104, 224, w13, w14, w3);
   TEST_3R("subsus_u.d", 112, 152, w14, w29, w14);
   TEST_3R("subsus_u.d", 120, 184, w15, w24, w27);
   TEST_3R("subsus_u.d", 128, 112, w16, w16, w13);
   TEST_3R("subsus_u.d", 136,  56, w17, w19, w28);
   TEST_3R("subsus_u.d", 144, 144, w18, w1,  w2);
   TEST_3R("subsus_u.d", 152, 232, w19, w8,  w22);
   TEST_3R("subsus_u.d", 160, 160, w20, w2,  w27);
   TEST_3R("subsus_u.d", 168, 152, w21, w13, w0);
   TEST_3R("subsus_u.d", 176, 168, w22, w29, w20);
   TEST_3R("subsus_u.d", 184, 152, w23, w18, w17);
   TEST_3R("subsus_u.d", 192,  16, w24, w0,  w20);
   TEST_3R("subsus_u.d", 200,  40, w25, w29, w1);
   TEST_3R("subsus_u.d", 208, 128, w26, w24, w30);
   TEST_3R("subsus_u.d", 216, 176, w27, w17, w25);
   TEST_3R("subsus_u.d", 224,   0, w28, w28, w28);
   TEST_3R("subsus_u.d", 232,   8, w29, w28, w27);
   TEST_3R("subsus_u.d", 240, 208, w30, w20, w29);
   TEST_3R("subsus_u.d", 184, 112, w31, w28, w11);
   TEST_3R("subsuu_s.b",   0, 192, w0,  w29, w26);
   TEST_3R("subsuu_s.b",   8, 176, w1,  w13, w23);
   TEST_3R("subsuu_s.b",  16, 104, w2,  w22, w15);
   TEST_3R("subsuu_s.b",  24,   0, w3,  w11, w10);
   TEST_3R("subsuu_s.b",  32, 176, w4,  w29, w3);
   TEST_3R("subsuu_s.b",  40,  40, w5,  w17, w0);
   TEST_3R("subsuu_s.b",  48,   8, w6,  w27, w20);
   TEST_3R("subsuu_s.b",  56, 224, w7,  w1,  w16);
   TEST_3R("subsuu_s.b",  64,  80, w8,  w8,  w8);
   TEST_3R("subsuu_s.b",  72, 176, w9,  w25, w14);
   TEST_3R("subsuu_s.b",  80, 168, w10, w12, w8);
   TEST_3R("subsuu_s.b",  88,  16, w11, w9,  w9);
   TEST_3R("subsuu_s.b",  96,  56, w12, w13, w23);
   TEST_3R("subsuu_s.b", 104, 152, w13, w14, w9);
   TEST_3R("subsuu_s.b", 112,  24, w14, w24, w19);
   TEST_3R("subsuu_s.b", 120,  80, w15, w21, w23);
   TEST_3R("subsuu_s.b", 128, 232, w16, w6,  w23);
   TEST_3R("subsuu_s.b", 136,   8, w17, w2,  w11);
   TEST_3R("subsuu_s.b", 144, 112, w18, w3,  w28);
   TEST_3R("subsuu_s.b", 152,  48, w19, w11, w19);
   TEST_3R("subsuu_s.b", 160, 160, w20, w15, w13);
   TEST_3R("subsuu_s.b", 168,  40, w21, w24, w26);
   TEST_3R("subsuu_s.b", 176, 208, w22, w26, w8);
   TEST_3R("subsuu_s.b", 184, 184, w23, w20, w22);
   TEST_3R("subsuu_s.b", 192, 136, w24, w29, w4);
   TEST_3R("subsuu_s.b", 200,  72, w25, w16, w2);
   TEST_3R("subsuu_s.b", 208,  16, w26, w26, w7);
   TEST_3R("subsuu_s.b", 216,  16, w27, w4,  w30);
   TEST_3R("subsuu_s.b", 224, 136, w28, w6,  w10);
   TEST_3R("subsuu_s.b", 232,   8, w29, w9,  w6);
   TEST_3R("subsuu_s.b", 240, 136, w30, w20, w27);
   TEST_3R("subsuu_s.b",  56, 208, w31, w1,  w29);
   TEST_3R("subsuu_s.h",   0,  16, w0,  w9,  w31);
   TEST_3R("subsuu_s.h",   8, 136, w1,  w11, w19);
   TEST_3R("subsuu_s.h",  16, 168, w2,  w27, w16);
   TEST_3R("subsuu_s.h",  24,  48, w3,  w1,  w0);
   TEST_3R("subsuu_s.h",  32, 176, w4,  w8,  w3);
   TEST_3R("subsuu_s.h",  40,  32, w5,  w7,  w10);
   TEST_3R("subsuu_s.h",  48, 176, w6,  w2,  w20);
   TEST_3R("subsuu_s.h",  56,  32, w7,  w31, w8);
   TEST_3R("subsuu_s.h",  64, 184, w8,  w8,  w8);
   TEST_3R("subsuu_s.h",  72, 160, w9,  w10, w16);
   TEST_3R("subsuu_s.h",  80, 224, w10, w6,  w25);
   TEST_3R("subsuu_s.h",  88, 192, w11, w10, w10);
   TEST_3R("subsuu_s.h",  96,  80, w12, w4,  w31);
   TEST_3R("subsuu_s.h", 104,  80, w13, w3,  w2);
   TEST_3R("subsuu_s.h", 112, 128, w14, w3,  w30);
   TEST_3R("subsuu_s.h", 120, 152, w15, w7,  w5);
   TEST_3R("subsuu_s.h", 128,  72, w16, w18, w22);
   TEST_3R("subsuu_s.h", 136, 120, w17, w6,  w13);
   TEST_3R("subsuu_s.h", 144,  72, w18, w14, w0);
   TEST_3R("subsuu_s.h", 152, 192, w19, w24, w19);
   TEST_3R("subsuu_s.h", 160, 136, w20, w12, w30);
   TEST_3R("subsuu_s.h", 168,  88, w21, w29, w8);
   TEST_3R("subsuu_s.h", 176, 232, w22, w1,  w13);
   TEST_3R("subsuu_s.h", 184, 232, w23, w22, w16);
   TEST_3R("subsuu_s.h", 192,  48, w24, w12, w19);
   TEST_3R("subsuu_s.h", 200, 152, w25, w11, w26);
   TEST_3R("subsuu_s.h", 208,  64, w26, w26, w16);
   TEST_3R("subsuu_s.h", 216, 144, w27, w12, w7);
   TEST_3R("subsuu_s.h", 224, 144, w28, w18, w20);
   TEST_3R("subsuu_s.h", 232,  88, w29, w0,  w20);
   TEST_3R("subsuu_s.h", 240, 200, w30, w25, w4);
   TEST_3R("subsuu_s.h",  80, 160, w31, w23, w13);
   TEST_3R("subsuu_s.w",   0,  88, w0,  w27, w8);
   TEST_3R("subsuu_s.w",   8, 120, w1,  w8,  w31);
   TEST_3R("subsuu_s.w",  16, 160, w2,  w23, w11);
   TEST_3R("subsuu_s.w",  24,  72, w3,  w10, w22);
   TEST_3R("subsuu_s.w",  32,  16, w4,  w7,  w18);
   TEST_3R("subsuu_s.w",  40,  64, w5,  w14, w7);
   TEST_3R("subsuu_s.w",  48, 176, w6,  w2,  w11);
   TEST_3R("subsuu_s.w",  56, 216, w7,  w23, w9);
   TEST_3R("subsuu_s.w",  64, 152, w8,  w8,  w8);
   TEST_3R("subsuu_s.w",  72,  80, w9,  w19, w26);
   TEST_3R("subsuu_s.w",  80, 176, w10, w4,  w2);
   TEST_3R("subsuu_s.w",  88,   0, w11, w12, w12);
   TEST_3R("subsuu_s.w",  96,  72, w12, w29, w3);
   TEST_3R("subsuu_s.w", 104, 208, w13, w3,  w24);
   TEST_3R("subsuu_s.w", 112, 152, w14, w10, w1);
   TEST_3R("subsuu_s.w", 120,  72, w15, w18, w3);
   TEST_3R("subsuu_s.w", 128,  16, w16, w29, w6);
   TEST_3R("subsuu_s.w", 136,  40, w17, w6,  w1);
   TEST_3R("subsuu_s.w", 144, 176, w18, w25, w20);
   TEST_3R("subsuu_s.w", 152, 136, w19, w7,  w19);
   TEST_3R("subsuu_s.w", 160, 160, w20, w21, w7);
   TEST_3R("subsuu_s.w", 168,   8, w21, w23, w4);
   TEST_3R("subsuu_s.w", 176,  80, w22, w4,  w18);
   TEST_3R("subsuu_s.w", 184, 168, w23, w7,  w10);
   TEST_3R("subsuu_s.w", 192, 152, w24, w18, w21);
   TEST_3R("subsuu_s.w", 200,  72, w25, w10, w7);
   TEST_3R("subsuu_s.w", 208,   0, w26, w26, w5);
   TEST_3R("subsuu_s.w", 216, 216, w27, w20, w23);
   TEST_3R("subsuu_s.w", 224, 192, w28, w21, w5);
   TEST_3R("subsuu_s.w", 232, 208, w29, w10, w27);
   TEST_3R("subsuu_s.w", 240,   8, w30, w17, w22);
   TEST_3R("subsuu_s.w",  56,  32, w31, w25, w28);
   TEST_3R("subsuu_s.d",   0, 200, w0,  w6,  w15);
   TEST_3R("subsuu_s.d",   8, 128, w1,  w14, w26);
   TEST_3R("subsuu_s.d",  16, 160, w2,  w0,  w15);
   TEST_3R("subsuu_s.d",  24, 104, w3,  w10, w22);
   TEST_3R("subsuu_s.d",  32,  32, w4,  w16, w26);
   TEST_3R("subsuu_s.d",  40, 152, w5,  w7,  w4);
   TEST_3R("subsuu_s.d",  48,  96, w6,  w12, w7);
   TEST_3R("subsuu_s.d",  56,  64, w7,  w8,  w29);
   TEST_3R("subsuu_s.d",  64,  56, w8,  w8,  w8);
   TEST_3R("subsuu_s.d",  72, 168, w9,  w8,  w29);
   TEST_3R("subsuu_s.d",  80,  48, w10, w11, w27);
   TEST_3R("subsuu_s.d",  88,  72, w11, w17, w17);
   TEST_3R("subsuu_s.d",  96, 128, w12, w31, w4);
   TEST_3R("subsuu_s.d", 104,  48, w13, w31, w19);
   TEST_3R("subsuu_s.d", 112,  32, w14, w10, w9);
   TEST_3R("subsuu_s.d", 120,  72, w15, w26, w3);
   TEST_3R("subsuu_s.d", 128, 224, w16, w1,  w7);
   TEST_3R("subsuu_s.d", 136,  80, w17, w14, w6);
   TEST_3R("subsuu_s.d", 144, 144, w18, w11, w20);
   TEST_3R("subsuu_s.d", 152, 184, w19, w8,  w19);
   TEST_3R("subsuu_s.d", 160, 104, w20, w31, w3);
   TEST_3R("subsuu_s.d", 168, 232, w21, w16, w14);
   TEST_3R("subsuu_s.d", 176,   0, w22, w16, w18);
   TEST_3R("subsuu_s.d", 184, 168, w23, w15, w6);
   TEST_3R("subsuu_s.d", 192, 208, w24, w25, w15);
   TEST_3R("subsuu_s.d", 200, 144, w25, w19, w13);
   TEST_3R("subsuu_s.d", 208, 112, w26, w26, w1);
   TEST_3R("subsuu_s.d", 216,  72, w27, w9,  w7);
   TEST_3R("subsuu_s.d", 224,  88, w28, w20, w18);
   TEST_3R("subsuu_s.d", 232, 152, w29, w8,  w27);
   TEST_3R("subsuu_s.d", 240,   8, w30, w7,  w11);
   TEST_3R("subsuu_s.d", 104, 168, w31, w12, w25);
   TEST_3R("subv.b",   0, 152, w0,  w17, w20);
   TEST_3R("subv.b",   8,  72, w1,  w4,  w7);
   TEST_3R("subv.b",  16, 152, w2,  w25, w11);
   TEST_3R("subv.b",  24, 224, w3,  w11, w19);
   TEST_3R("subv.b",  32,  80, w4,  w31, w5);
   TEST_3R("subv.b",  40, 208, w5,  w8,  w5);
   TEST_3R("subv.b",  48,  40, w6,  w30, w15);
   TEST_3R("subv.b",  56,  16, w7,  w9,  w11);
   TEST_3R("subv.b",  64,  32, w8,  w15, w10);
   TEST_3R("subv.b",  72, 216, w9,  w7,  w15);
   TEST_3R("subv.b",  80,   0, w10, w24, w4);
   TEST_3R("subv.b",  88, 208, w11, w28, w18);
   TEST_3R("subv.b",  96,   0, w12, w13, w29);
   TEST_3R("subv.b", 104, 232, w13, w24, w16);
   TEST_3R("subv.b", 112,  88, w14, w14, w14);
   TEST_3R("subv.b", 120, 160, w15, w22, w10);
   TEST_3R("subv.b", 128, 200, w16, w22, w8);
   TEST_3R("subv.b", 136,  80, w17, w21, w23);
   TEST_3R("subv.b", 144,  88, w18, w20, w6);
   TEST_3R("subv.b", 152,  72, w19, w4,  w13);
   TEST_3R("subv.b", 160, 184, w20, w15, w5);
   TEST_3R("subv.b", 168, 216, w21, w22, w2);
   TEST_3R("subv.b", 176, 168, w22, w8,  w24);
   TEST_3R("subv.b", 184, 200, w23, w23, w6);
   TEST_3R("subv.b", 192,  64, w24, w16, w22);
   TEST_3R("subv.b", 200,   8, w25, w8,  w12);
   TEST_3R("subv.b", 208,  32, w26, w8,  w8);
   TEST_3R("subv.b", 216, 216, w27, w5,  w24);
   TEST_3R("subv.b", 224,  56, w28, w23, w15);
   TEST_3R("subv.b", 232,  16, w29, w11, w21);
   TEST_3R("subv.b", 240, 208, w30, w15, w3);
   TEST_3R("subv.b",  32, 152, w31, w30, w8);
   TEST_3R("subv.h",   0, 200, w0,  w10, w9);
   TEST_3R("subv.h",   8, 232, w1,  w2,  w3);
   TEST_3R("subv.h",  16, 168, w2,  w18, w26);
   TEST_3R("subv.h",  24, 184, w3,  w26, w6);
   TEST_3R("subv.h",  32,  16, w4,  w3,  w9);
   TEST_3R("subv.h",  40, 160, w5,  w27, w5);
   TEST_3R("subv.h",  48, 216, w6,  w25, w10);
   TEST_3R("subv.h",  56,   0, w7,  w4,  w31);
   TEST_3R("subv.h",  64, 208, w8,  w19, w2);
   TEST_3R("subv.h",  72, 232, w9,  w18, w11);
   TEST_3R("subv.h",  80, 136, w10, w7,  w21);
   TEST_3R("subv.h",  88, 184, w11, w4,  w24);
   TEST_3R("subv.h",  96,  24, w12, w8,  w5);
   TEST_3R("subv.h", 104,  96, w13, w2,  w4);
   TEST_3R("subv.h", 112, 136, w14, w14, w14);
   TEST_3R("subv.h", 120, 208, w15, w1,  w26);
   TEST_3R("subv.h", 128, 128, w16, w3,  w21);
   TEST_3R("subv.h", 136, 216, w17, w28, w31);
   TEST_3R("subv.h", 144,  96, w18, w0,  w30);
   TEST_3R("subv.h", 152,  16, w19, w1,  w16);
   TEST_3R("subv.h", 160,  72, w20, w12, w16);
   TEST_3R("subv.h", 168,  96, w21, w1,  w25);
   TEST_3R("subv.h", 176, 168, w22, w25, w3);
   TEST_3R("subv.h", 184,  32, w23, w23, w30);
   TEST_3R("subv.h", 192,   0, w24, w27, w3);
   TEST_3R("subv.h", 200,  80, w25, w3,  w4);
   TEST_3R("subv.h", 208,   0, w26, w21, w21);
   TEST_3R("subv.h", 216, 160, w27, w6,  w9);
   TEST_3R("subv.h", 224,  80, w28, w5,  w25);
   TEST_3R("subv.h", 232, 192, w29, w3,  w9);
   TEST_3R("subv.h", 240, 216, w30, w4,  w25);
   TEST_3R("subv.h", 112, 168, w31, w16, w9);
   TEST_3R("subv.w",   0, 184, w0,  w2,  w25);
   TEST_3R("subv.w",   8,   8, w1,  w6,  w18);
   TEST_3R("subv.w",  16, 120, w2,  w6,  w13);
   TEST_3R("subv.w",  24,   0, w3,  w29, w17);
   TEST_3R("subv.w",  32,   8, w4,  w14, w6);
   TEST_3R("subv.w",  40, 144, w5,  w20, w5);
   TEST_3R("subv.w",  48,   8, w6,  w27, w25);
   TEST_3R("subv.w",  56, 208, w7,  w30, w28);
   TEST_3R("subv.w",  64, 104, w8,  w20, w1);
   TEST_3R("subv.w",  72,  48, w9,  w16, w17);
   TEST_3R("subv.w",  80, 176, w10, w25, w3);
   TEST_3R("subv.w",  88,  72, w11, w18, w15);
   TEST_3R("subv.w",  96, 112, w12, w5,  w25);
   TEST_3R("subv.w", 104, 160, w13, w18, w6);
   TEST_3R("subv.w", 112, 144, w14, w14, w14);
   TEST_3R("subv.w", 120,  40, w15, w23, w14);
   TEST_3R("subv.w", 128,  56, w16, w15, w2);
   TEST_3R("subv.w", 136,  64, w17, w10, w27);
   TEST_3R("subv.w", 144, 144, w18, w8,  w24);
   TEST_3R("subv.w", 152, 128, w19, w28, w25);
   TEST_3R("subv.w", 160,  48, w20, w13, w10);
   TEST_3R("subv.w", 168, 232, w21, w6,  w14);
   TEST_3R("subv.w", 176, 184, w22, w24, w29);
   TEST_3R("subv.w", 184, 208, w23, w23, w29);
   TEST_3R("subv.w", 192,  88, w24, w14, w16);
   TEST_3R("subv.w", 200, 208, w25, w14, w19);
   TEST_3R("subv.w", 208, 152, w26, w29, w29);
   TEST_3R("subv.w", 216,  80, w27, w2,  w31);
   TEST_3R("subv.w", 224,  24, w28, w12, w27);
   TEST_3R("subv.w", 232, 168, w29, w20, w19);
   TEST_3R("subv.w", 240, 176, w30, w16, w12);
   TEST_3R("subv.w",  16, 224, w31, w29, w22);
   TEST_3R("subv.d",   0, 152, w0,  w4,  w18);
   TEST_3R("subv.d",   8, 160, w1,  w29, w25);
   TEST_3R("subv.d",  16,  16, w2,  w11, w9);
   TEST_3R("subv.d",  24,  96, w3,  w25, w29);
   TEST_3R("subv.d",  32,  72, w4,  w22, w26);
   TEST_3R("subv.d",  40,  64, w5,  w22, w5);
   TEST_3R("subv.d",  48,  88, w6,  w20, w17);
   TEST_3R("subv.d",  56, 136, w7,  w8,  w4);
   TEST_3R("subv.d",  64,  72, w8,  w25, w16);
   TEST_3R("subv.d",  72,  64, w9,  w22, w6);
   TEST_3R("subv.d",  80, 160, w10, w26, w11);
   TEST_3R("subv.d",  88,  80, w11, w22, w12);
   TEST_3R("subv.d",  96,  56, w12, w15, w4);
   TEST_3R("subv.d", 104, 128, w13, w25, w23);
   TEST_3R("subv.d", 112,  80, w14, w14, w14);
   TEST_3R("subv.d", 120,  64, w15, w30, w28);
   TEST_3R("subv.d", 128,   0, w16, w6,  w18);
   TEST_3R("subv.d", 136,  88, w17, w27, w3);
   TEST_3R("subv.d", 144, 104, w18, w3,  w7);
   TEST_3R("subv.d", 152, 176, w19, w28, w23);
   TEST_3R("subv.d", 160, 120, w20, w19, w29);
   TEST_3R("subv.d", 168, 152, w21, w13, w8);
   TEST_3R("subv.d", 176, 232, w22, w3,  w21);
   TEST_3R("subv.d", 184,  88, w23, w23, w18);
   TEST_3R("subv.d", 192, 176, w24, w25, w11);
   TEST_3R("subv.d", 200, 120, w25, w31, w1);
   TEST_3R("subv.d", 208,  16, w26, w27, w27);
   TEST_3R("subv.d", 216,  16, w27, w21, w13);
   TEST_3R("subv.d", 224, 112, w28, w16, w3);
   TEST_3R("subv.d", 232,  48, w29, w23, w14);
   TEST_3R("subv.d", 240, 144, w30, w14, w5);
   TEST_3R("subv.d", 208,  80, w31, w11, w14);
   TEST_BIT("sat_s.b",   0, w0,  w7,  6);
   TEST_BIT("sat_s.b",   8, w1,  w8,  7);
   TEST_BIT("sat_s.b",  16, w2,  w5,  0);
   TEST_BIT("sat_s.b",  24, w3,  w27, 1);
   TEST_BIT("sat_s.b",  32, w4,  w20, 2);
   TEST_BIT("sat_s.b",  40, w5,  w10, 3);
   TEST_BIT("sat_s.b",  48, w6,  w20, 4);
   TEST_BIT("sat_s.b",  56, w7,  w4,  5);
   TEST_BIT("sat_s.b",  64, w8,  w14, 6);
   TEST_BIT("sat_s.b",  72, w9,  w10, 7);
   TEST_BIT("sat_s.b",  80, w10, w28, 0);
   TEST_BIT("sat_s.b",  88, w11, w31, 1);
   TEST_BIT("sat_s.b",  96, w12, w12, 2);
   TEST_BIT("sat_s.b", 104, w13, w20, 3);
   TEST_BIT("sat_s.b", 112, w14, w7,  4);
   TEST_BIT("sat_s.b", 120, w15, w0,  5);
   TEST_BIT("sat_s.b", 128, w16, w14, 6);
   TEST_BIT("sat_s.b", 136, w17, w31, 7);
   TEST_BIT("sat_s.b", 144, w18, w18, 0);
   TEST_BIT("sat_s.b", 152, w19, w28, 1);
   TEST_BIT("sat_s.b", 160, w20, w27, 2);
   TEST_BIT("sat_s.b", 168, w21, w7,  3);
   TEST_BIT("sat_s.b", 176, w22, w5,  4);
   TEST_BIT("sat_s.b", 184, w23, w30, 5);
   TEST_BIT("sat_s.b", 192, w24, w30, 6);
   TEST_BIT("sat_s.b", 200, w25, w15, 7);
   TEST_BIT("sat_s.b", 208, w26, w27, 0);
   TEST_BIT("sat_s.b", 216, w27, w0,  1);
   TEST_BIT("sat_s.b", 224, w28, w10, 2);
   TEST_BIT("sat_s.b", 232, w29, w6,  3);
   TEST_BIT("sat_s.b", 240, w30, w23, 4);
   TEST_BIT("sat_s.b", 224, w31, w1,  5);
   TEST_BIT("sat_s.h",   0, w0,  w20, 14);
   TEST_BIT("sat_s.h",   8, w1,  w7,  15);
   TEST_BIT("sat_s.h",  16, w2,  w13, 0);
   TEST_BIT("sat_s.h",  24, w3,  w9,  1);
   TEST_BIT("sat_s.h",  32, w4,  w7,  2);
   TEST_BIT("sat_s.h",  40, w5,  w20, 3);
   TEST_BIT("sat_s.h",  48, w6,  w3,  4);
   TEST_BIT("sat_s.h",  56, w7,  w19, 5);
   TEST_BIT("sat_s.h",  64, w8,  w20, 6);
   TEST_BIT("sat_s.h",  72, w9,  w25, 7);
   TEST_BIT("sat_s.h",  80, w10, w7,  8);
   TEST_BIT("sat_s.h",  88, w11, w15, 9);
   TEST_BIT("sat_s.h",  96, w12, w12, 10);
   TEST_BIT("sat_s.h", 104, w13, w5,  11);
   TEST_BIT("sat_s.h", 112, w14, w31, 12);
   TEST_BIT("sat_s.h", 120, w15, w4,  13);
   TEST_BIT("sat_s.h", 128, w16, w19, 14);
   TEST_BIT("sat_s.h", 136, w17, w21, 15);
   TEST_BIT("sat_s.h", 144, w18, w18, 0);
   TEST_BIT("sat_s.h", 152, w19, w2,  1);
   TEST_BIT("sat_s.h", 160, w20, w8,  2);
   TEST_BIT("sat_s.h", 168, w21, w16, 3);
   TEST_BIT("sat_s.h", 176, w22, w21, 4);
   TEST_BIT("sat_s.h", 184, w23, w12, 5);
   TEST_BIT("sat_s.h", 192, w24, w27, 6);
   TEST_BIT("sat_s.h", 200, w25, w9,  7);
   TEST_BIT("sat_s.h", 208, w26, w5,  8);
   TEST_BIT("sat_s.h", 216, w27, w21, 9);
   TEST_BIT("sat_s.h", 224, w28, w23, 10);
   TEST_BIT("sat_s.h", 232, w29, w10, 11);
   TEST_BIT("sat_s.h", 240, w30, w19, 12);
   TEST_BIT("sat_s.h", 112, w31, w9,  13);
   TEST_BIT("sat_s.w",   0, w0,  w31, 14);
   TEST_BIT("sat_s.w",   8, w1,  w19, 15);
   TEST_BIT("sat_s.w",  16, w2,  w27, 16);
   TEST_BIT("sat_s.w",  24, w3,  w25, 17);
   TEST_BIT("sat_s.w",  32, w4,  w31, 18);
   TEST_BIT("sat_s.w",  40, w5,  w19, 19);
   TEST_BIT("sat_s.w",  48, w6,  w3,  20);
   TEST_BIT("sat_s.w",  56, w7,  w23, 21);
   TEST_BIT("sat_s.w",  64, w8,  w29, 22);
   TEST_BIT("sat_s.w",  72, w9,  w20, 23);
   TEST_BIT("sat_s.w",  80, w10, w1,  24);
   TEST_BIT("sat_s.w",  88, w11, w6,  25);
   TEST_BIT("sat_s.w",  96, w12, w12, 26);
   TEST_BIT("sat_s.w", 104, w13, w25, 27);
   TEST_BIT("sat_s.w", 112, w14, w26, 28);
   TEST_BIT("sat_s.w", 120, w15, w20, 29);
   TEST_BIT("sat_s.w", 128, w16, w25, 30);
   TEST_BIT("sat_s.w", 136, w17, w7,  31);
   TEST_BIT("sat_s.w", 144, w18, w18, 0);
   TEST_BIT("sat_s.w", 152, w19, w2,  1);
   TEST_BIT("sat_s.w", 160, w20, w4,  2);
   TEST_BIT("sat_s.w", 168, w21, w13, 3);
   TEST_BIT("sat_s.w", 176, w22, w19, 4);
   TEST_BIT("sat_s.w", 184, w23, w28, 5);
   TEST_BIT("sat_s.w", 192, w24, w16, 6);
   TEST_BIT("sat_s.w", 200, w25, w3,  7);
   TEST_BIT("sat_s.w", 208, w26, w16, 8);
   TEST_BIT("sat_s.w", 216, w27, w0,  9);
   TEST_BIT("sat_s.w", 224, w28, w2,  10);
   TEST_BIT("sat_s.w", 232, w29, w28, 11);
   TEST_BIT("sat_s.w", 240, w30, w0,  12);
   TEST_BIT("sat_s.w",  16, w31, w12, 13);
   TEST_BIT("sat_s.d",   0, w0,  w5,  14);
   TEST_BIT("sat_s.d",   8, w1,  w24, 15);
   TEST_BIT("sat_s.d",  16, w2,  w12, 16);
   TEST_BIT("sat_s.d",  24, w3,  w17, 17);
   TEST_BIT("sat_s.d",  32, w4,  w8,  18);
   TEST_BIT("sat_s.d",  40, w5,  w3,  19);
   TEST_BIT("sat_s.d",  48, w6,  w30, 20);
   TEST_BIT("sat_s.d",  56, w7,  w25, 21);
   TEST_BIT("sat_s.d",  64, w8,  w28, 22);
   TEST_BIT("sat_s.d",  72, w9,  w2,  23);
   TEST_BIT("sat_s.d",  80, w10, w7,  24);
   TEST_BIT("sat_s.d",  88, w11, w21, 25);
   TEST_BIT("sat_s.d",  96, w12, w12, 26);
   TEST_BIT("sat_s.d", 104, w13, w16, 27);
   TEST_BIT("sat_s.d", 112, w14, w15, 28);
   TEST_BIT("sat_s.d", 120, w15, w20, 29);
   TEST_BIT("sat_s.d", 128, w16, w15, 30);
   TEST_BIT("sat_s.d", 136, w17, w26, 31);
   TEST_BIT("sat_s.d", 144, w18, w18, 32);
   TEST_BIT("sat_s.d", 152, w19, w29, 33);
   TEST_BIT("sat_s.d", 160, w20, w11, 34);
   TEST_BIT("sat_s.d", 168, w21, w13, 35);
   TEST_BIT("sat_s.d", 176, w22, w12, 36);
   TEST_BIT("sat_s.d", 184, w23, w3,  37);
   TEST_BIT("sat_s.d", 192, w24, w9,  38);
   TEST_BIT("sat_s.d", 200, w25, w28, 39);
   TEST_BIT("sat_s.d", 208, w26, w4,  40);
   TEST_BIT("sat_s.d", 216, w27, w25, 41);
   TEST_BIT("sat_s.d", 224, w28, w19, 42);
   TEST_BIT("sat_s.d", 232, w29, w26, 43);
   TEST_BIT("sat_s.d", 240, w30, w23, 44);
   TEST_BIT("sat_s.d", 120, w31, w16, 45);
   TEST_BIT("sat_u.b",   0, w0,  w22, 6);
   TEST_BIT("sat_u.b",   8, w1,  w19, 7);
   TEST_BIT("sat_u.b",  16, w2,  w23, 0);
   TEST_BIT("sat_u.b",  24, w3,  w20, 1);
   TEST_BIT("sat_u.b",  32, w4,  w13, 2);
   TEST_BIT("sat_u.b",  40, w5,  w5,  3);
   TEST_BIT("sat_u.b",  48, w6,  w30, 4);
   TEST_BIT("sat_u.b",  56, w7,  w19, 5);
   TEST_BIT("sat_u.b",  64, w8,  w29, 6);
   TEST_BIT("sat_u.b",  72, w9,  w9,  7);
   TEST_BIT("sat_u.b",  80, w10, w16, 0);
   TEST_BIT("sat_u.b",  88, w11, w26, 1);
   TEST_BIT("sat_u.b",  96, w12, w18, 2);
   TEST_BIT("sat_u.b", 104, w13, w4,  3);
   TEST_BIT("sat_u.b", 112, w14, w28, 4);
   TEST_BIT("sat_u.b", 120, w15, w3,  5);
   TEST_BIT("sat_u.b", 128, w16, w23, 6);
   TEST_BIT("sat_u.b", 136, w17, w12, 7);
   TEST_BIT("sat_u.b", 144, w18, w13, 0);
   TEST_BIT("sat_u.b", 152, w19, w30, 1);
   TEST_BIT("sat_u.b", 160, w20, w3,  2);
   TEST_BIT("sat_u.b", 168, w21, w6,  3);
   TEST_BIT("sat_u.b", 176, w22, w3,  4);
   TEST_BIT("sat_u.b", 184, w23, w3,  5);
   TEST_BIT("sat_u.b", 192, w24, w1,  6);
   TEST_BIT("sat_u.b", 200, w25, w17, 7);
   TEST_BIT("sat_u.b", 208, w26, w19, 0);
   TEST_BIT("sat_u.b", 216, w27, w29, 1);
   TEST_BIT("sat_u.b", 224, w28, w8,  2);
   TEST_BIT("sat_u.b", 232, w29, w19, 3);
   TEST_BIT("sat_u.b", 240, w30, w31, 4);
   TEST_BIT("sat_u.b", 192, w31, w18, 5);
   TEST_BIT("sat_u.h",   0, w0,  w4,  14);
   TEST_BIT("sat_u.h",   8, w1,  w4,  15);
   TEST_BIT("sat_u.h",  16, w2,  w20, 0);
   TEST_BIT("sat_u.h",  24, w3,  w17, 1);
   TEST_BIT("sat_u.h",  32, w4,  w23, 2);
   TEST_BIT("sat_u.h",  40, w5,  w5,  3);
   TEST_BIT("sat_u.h",  48, w6,  w30, 4);
   TEST_BIT("sat_u.h",  56, w7,  w26, 5);
   TEST_BIT("sat_u.h",  64, w8,  w31, 6);
   TEST_BIT("sat_u.h",  72, w9,  w9,  7);
   TEST_BIT("sat_u.h",  80, w10, w16, 8);
   TEST_BIT("sat_u.h",  88, w11, w26, 9);
   TEST_BIT("sat_u.h",  96, w12, w18, 10);
   TEST_BIT("sat_u.h", 104, w13, w29, 11);
   TEST_BIT("sat_u.h", 112, w14, w24, 12);
   TEST_BIT("sat_u.h", 120, w15, w28, 13);
   TEST_BIT("sat_u.h", 128, w16, w14, 14);
   TEST_BIT("sat_u.h", 136, w17, w11, 15);
   TEST_BIT("sat_u.h", 144, w18, w5,  0);
   TEST_BIT("sat_u.h", 152, w19, w18, 1);
   TEST_BIT("sat_u.h", 160, w20, w27, 2);
   TEST_BIT("sat_u.h", 168, w21, w3,  3);
   TEST_BIT("sat_u.h", 176, w22, w10, 4);
   TEST_BIT("sat_u.h", 184, w23, w30, 5);
   TEST_BIT("sat_u.h", 192, w24, w6,  6);
   TEST_BIT("sat_u.h", 200, w25, w27, 7);
   TEST_BIT("sat_u.h", 208, w26, w13, 8);
   TEST_BIT("sat_u.h", 216, w27, w10, 9);
   TEST_BIT("sat_u.h", 224, w28, w19, 10);
   TEST_BIT("sat_u.h", 232, w29, w7,  11);
   TEST_BIT("sat_u.h", 240, w30, w13, 12);
   TEST_BIT("sat_u.h", 120, w31, w17, 13);
   TEST_BIT("sat_u.w",   0, w0,  w19, 14);
   TEST_BIT("sat_u.w",   8, w1,  w2,  15);
   TEST_BIT("sat_u.w",  16, w2,  w29, 16);
   TEST_BIT("sat_u.w",  24, w3,  w5,  17);
   TEST_BIT("sat_u.w",  32, w4,  w27, 18);
   TEST_BIT("sat_u.w",  40, w5,  w5,  19);
   TEST_BIT("sat_u.w",  48, w6,  w12, 20);
   TEST_BIT("sat_u.w",  56, w7,  w4,  21);
   TEST_BIT("sat_u.w",  64, w8,  w16, 22);
   TEST_BIT("sat_u.w",  72, w9,  w9,  23);
   TEST_BIT("sat_u.w",  80, w10, w15, 24);
   TEST_BIT("sat_u.w",  88, w11, w16, 25);
   TEST_BIT("sat_u.w",  96, w12, w21, 26);
   TEST_BIT("sat_u.w", 104, w13, w18, 27);
   TEST_BIT("sat_u.w", 112, w14, w18, 28);
   TEST_BIT("sat_u.w", 120, w15, w5,  29);
   TEST_BIT("sat_u.w", 128, w16, w19, 30);
   TEST_BIT("sat_u.w", 136, w17, w27, 31);
   TEST_BIT("sat_u.w", 144, w18, w31, 0);
   TEST_BIT("sat_u.w", 152, w19, w11, 1);
   TEST_BIT("sat_u.w", 160, w20, w18, 2);
   TEST_BIT("sat_u.w", 168, w21, w10, 3);
   TEST_BIT("sat_u.w", 176, w22, w18, 4);
   TEST_BIT("sat_u.w", 184, w23, w7,  5);
   TEST_BIT("sat_u.w", 192, w24, w30, 6);
   TEST_BIT("sat_u.w", 200, w25, w26, 7);
   TEST_BIT("sat_u.w", 208, w26, w20, 8);
   TEST_BIT("sat_u.w", 216, w27, w25, 9);
   TEST_BIT("sat_u.w", 224, w28, w8,  10);
   TEST_BIT("sat_u.w", 232, w29, w8,  11);
   TEST_BIT("sat_u.w", 240, w30, w19, 12);
   TEST_BIT("sat_u.w", 200, w31, w10, 13);
   TEST_BIT("sat_u.d",   0, w0,  w4,  46);
   TEST_BIT("sat_u.d",   8, w1,  w14, 47);
   TEST_BIT("sat_u.d",  16, w2,  w5,  48);
   TEST_BIT("sat_u.d",  24, w3,  w31, 49);
   TEST_BIT("sat_u.d",  32, w4,  w14, 50);
   TEST_BIT("sat_u.d",  40, w5,  w5,  51);
   TEST_BIT("sat_u.d",  48, w6,  w0,  52);
   TEST_BIT("sat_u.d",  56, w7,  w12, 53);
   TEST_BIT("sat_u.d",  64, w8,  w15, 54);
   TEST_BIT("sat_u.d",  72, w9,  w9,  55);
   TEST_BIT("sat_u.d",  80, w10, w24, 56);
   TEST_BIT("sat_u.d",  88, w11, w18, 57);
   TEST_BIT("sat_u.d",  96, w12, w2,  58);
   TEST_BIT("sat_u.d", 104, w13, w7,  59);
   TEST_BIT("sat_u.d", 112, w14, w16, 60);
   TEST_BIT("sat_u.d", 120, w15, w25, 61);
   TEST_BIT("sat_u.d", 128, w16, w7,  62);
   TEST_BIT("sat_u.d", 136, w17, w13, 63);
   TEST_BIT("sat_u.d", 144, w18, w7,  0);
   TEST_BIT("sat_u.d", 152, w19, w22, 1);
   TEST_BIT("sat_u.d", 160, w20, w27, 2);
   TEST_BIT("sat_u.d", 168, w21, w30, 3);
   TEST_BIT("sat_u.d", 176, w22, w19, 4);
   TEST_BIT("sat_u.d", 184, w23, w11, 5);
   TEST_BIT("sat_u.d", 192, w24, w15, 6);
   TEST_BIT("sat_u.d", 200, w25, w22, 7);
   TEST_BIT("sat_u.d", 208, w26, w15, 8);
   TEST_BIT("sat_u.d", 216, w27, w5,  9);
   TEST_BIT("sat_u.d", 224, w28, w5,  10);
   TEST_BIT("sat_u.d", 232, w29, w0,  11);
   TEST_BIT("sat_u.d", 240, w30, w15, 12);
   TEST_BIT("sat_u.d",   0, w31, w20, 13);
   TEST_I5("addvi.b",   0, w0,  w8,  20);
   TEST_I5("addvi.b",   8, w1,  w14, 7);
   TEST_I5("addvi.b",  16, w2,  w23, 22);
   TEST_I5("addvi.b",  24, w3,  w4,  13);
   TEST_I5("addvi.b",  32, w4,  w28, 8);
   TEST_I5("addvi.b",  40, w5,  w15, 22);
   TEST_I5("addvi.b",  48, w6,  w29, 23);
   TEST_I5("addvi.b",  56, w7,  w11, 11);
   TEST_I5("addvi.b",  64, w8,  w17, 8);
   TEST_I5("addvi.b",  72, w9,  w13, 25);
   TEST_I5("addvi.b",  80, w10, w31, 2);
   TEST_I5("addvi.b",  88, w11, w24, 16);
   TEST_I5("addvi.b",  96, w12, w25, 7);
   TEST_I5("addvi.b", 104, w13, w8,  11);
   TEST_I5("addvi.b", 112, w14, w22, 7);
   TEST_I5("addvi.b", 120, w15, w6,  22);
   TEST_I5("addvi.b", 128, w16, w16, 31);
   TEST_I5("addvi.b", 136, w17, w17, 19);
   TEST_I5("addvi.b", 144, w18, w7,  27);
   TEST_I5("addvi.b", 152, w19, w30, 13);
   TEST_I5("addvi.b", 160, w20, w13, 26);
   TEST_I5("addvi.b", 168, w21, w12, 25);
   TEST_I5("addvi.b", 176, w22, w18, 17);
   TEST_I5("addvi.b", 184, w23, w13, 10);
   TEST_I5("addvi.b", 192, w24, w16, 18);
   TEST_I5("addvi.b", 200, w25, w8,  8);
   TEST_I5("addvi.b", 208, w26, w14, 14);
   TEST_I5("addvi.b", 216, w27, w28, 13);
   TEST_I5("addvi.b", 224, w28, w0,  20);
   TEST_I5("addvi.b", 232, w29, w28, 6);
   TEST_I5("addvi.b", 240, w30, w9,  0);
   TEST_I5("addvi.b",  24, w31, w3,  20);
   TEST_I5("addvi.h",   0, w0,  w19, 13);
   TEST_I5("addvi.h",   8, w1,  w15, 17);
   TEST_I5("addvi.h",  16, w2,  w27, 25);
   TEST_I5("addvi.h",  24, w3,  w19, 19);
   TEST_I5("addvi.h",  32, w4,  w1,  9);
   TEST_I5("addvi.h",  40, w5,  w15, 18);
   TEST_I5("addvi.h",  48, w6,  w3,  26);
   TEST_I5("addvi.h",  56, w7,  w10, 9);
   TEST_I5("addvi.h",  64, w8,  w15, 12);
   TEST_I5("addvi.h",  72, w9,  w16, 8);
   TEST_I5("addvi.h",  80, w10, w4,  21);
   TEST_I5("addvi.h",  88, w11, w5,  13);
   TEST_I5("addvi.h",  96, w12, w22, 24);
   TEST_I5("addvi.h", 104, w13, w15, 11);
   TEST_I5("addvi.h", 112, w14, w23, 12);
   TEST_I5("addvi.h", 120, w15, w26, 27);
   TEST_I5("addvi.h", 128, w16, w16, 30);
   TEST_I5("addvi.h", 136, w17, w17, 31);
   TEST_I5("addvi.h", 144, w18, w30, 15);
   TEST_I5("addvi.h", 152, w19, w9,  30);
   TEST_I5("addvi.h", 160, w20, w19, 18);
   TEST_I5("addvi.h", 168, w21, w27, 26);
   TEST_I5("addvi.h", 176, w22, w17, 17);
   TEST_I5("addvi.h", 184, w23, w30, 3);
   TEST_I5("addvi.h", 192, w24, w22, 9);
   TEST_I5("addvi.h", 200, w25, w1,  2);
   TEST_I5("addvi.h", 208, w26, w14, 4);
   TEST_I5("addvi.h", 216, w27, w9,  25);
   TEST_I5("addvi.h", 224, w28, w8,  8);
   TEST_I5("addvi.h", 232, w29, w17, 6);
   TEST_I5("addvi.h", 240, w30, w5,  21);
   TEST_I5("addvi.h",  32, w31, w23, 8);
   TEST_I5("addvi.w",   0, w0,  w19, 18);
   TEST_I5("addvi.w",   8, w1,  w14, 8);
   TEST_I5("addvi.w",  16, w2,  w12, 10);
   TEST_I5("addvi.w",  24, w3,  w0,  24);
   TEST_I5("addvi.w",  32, w4,  w15, 1);
   TEST_I5("addvi.w",  40, w5,  w29, 10);
   TEST_I5("addvi.w",  48, w6,  w9,  27);
   TEST_I5("addvi.w",  56, w7,  w28, 29);
   TEST_I5("addvi.w",  64, w8,  w0,  19);
   TEST_I5("addvi.w",  72, w9,  w23, 27);
   TEST_I5("addvi.w",  80, w10, w8,  28);
   TEST_I5("addvi.w",  88, w11, w10, 20);
   TEST_I5("addvi.w",  96, w12, w22, 30);
   TEST_I5("addvi.w", 104, w13, w23, 22);
   TEST_I5("addvi.w", 112, w14, w6,  3);
   TEST_I5("addvi.w", 120, w15, w21, 12);
   TEST_I5("addvi.w", 128, w16, w16, 12);
   TEST_I5("addvi.w", 136, w17, w17, 9);
   TEST_I5("addvi.w", 144, w18, w10, 29);
   TEST_I5("addvi.w", 152, w19, w12, 21);
   TEST_I5("addvi.w", 160, w20, w18, 29);
   TEST_I5("addvi.w", 168, w21, w12, 8);
   TEST_I5("addvi.w", 176, w22, w23, 24);
   TEST_I5("addvi.w", 184, w23, w11, 23);
   TEST_I5("addvi.w", 192, w24, w9,  7);
   TEST_I5("addvi.w", 200, w25, w31, 14);
   TEST_I5("addvi.w", 208, w26, w23, 3);
   TEST_I5("addvi.w", 216, w27, w24, 16);
   TEST_I5("addvi.w", 224, w28, w21, 26);
   TEST_I5("addvi.w", 232, w29, w19, 23);
   TEST_I5("addvi.w", 240, w30, w8,  15);
   TEST_I5("addvi.w", 184, w31, w5,  4);
   TEST_I5("addvi.d",   0, w0,  w14, 5);
   TEST_I5("addvi.d",   8, w1,  w26, 28);
   TEST_I5("addvi.d",  16, w2,  w3,  4);
   TEST_I5("addvi.d",  24, w3,  w24, 26);
   TEST_I5("addvi.d",  32, w4,  w14, 18);
   TEST_I5("addvi.d",  40, w5,  w17, 29);
   TEST_I5("addvi.d",  48, w6,  w31, 22);
   TEST_I5("addvi.d",  56, w7,  w22, 3);
   TEST_I5("addvi.d",  64, w8,  w1,  8);
   TEST_I5("addvi.d",  72, w9,  w24, 22);
   TEST_I5("addvi.d",  80, w10, w6,  27);
   TEST_I5("addvi.d",  88, w11, w0,  24);
   TEST_I5("addvi.d",  96, w12, w4,  28);
   TEST_I5("addvi.d", 104, w13, w7,  14);
   TEST_I5("addvi.d", 112, w14, w1,  3);
   TEST_I5("addvi.d", 120, w15, w19, 9);
   TEST_I5("addvi.d", 128, w16, w16, 27);
   TEST_I5("addvi.d", 136, w17, w17, 8);
   TEST_I5("addvi.d", 144, w18, w22, 22);
   TEST_I5("addvi.d", 152, w19, w31, 23);
   TEST_I5("addvi.d", 160, w20, w5,  15);
   TEST_I5("addvi.d", 168, w21, w15, 21);
   TEST_I5("addvi.d", 176, w22, w28, 22);
   TEST_I5("addvi.d", 184, w23, w1,  26);
   TEST_I5("addvi.d", 192, w24, w12, 1);
   TEST_I5("addvi.d", 200, w25, w14, 2);
   TEST_I5("addvi.d", 208, w26, w31, 21);
   TEST_I5("addvi.d", 216, w27, w2,  2);
   TEST_I5("addvi.d", 224, w28, w10, 24);
   TEST_I5("addvi.d", 232, w29, w9,  15);
   TEST_I5("addvi.d", 240, w30, w14, 30);
   TEST_I5("addvi.d", 152, w31, w29, 19);
   TEST_I5("maxi_s.b",   0, w0,  w7,  -12);
   TEST_I5("maxi_s.b",   8, w1,  w21, -10);
   TEST_I5("maxi_s.b",  16, w2,  w21, 12);
   TEST_I5("maxi_s.b",  24, w3,  w23, 2);
   TEST_I5("maxi_s.b",  32, w4,  w13, 12);
   TEST_I5("maxi_s.b",  40, w5,  w20, -10);
   TEST_I5("maxi_s.b",  48, w6,  w21, 4);
   TEST_I5("maxi_s.b",  56, w7,  w24, 2);
   TEST_I5("maxi_s.b",  64, w8,  w19, -5);
   TEST_I5("maxi_s.b",  72, w9,  w9,  -14);
   TEST_I5("maxi_s.b",  80, w10, w27, 12);
   TEST_I5("maxi_s.b",  88, w11, w30, 13);
   TEST_I5("maxi_s.b",  96, w12, w3,  -7);
   TEST_I5("maxi_s.b", 104, w13, w24, -11);
   TEST_I5("maxi_s.b", 112, w14, w15, 2);
   TEST_I5("maxi_s.b", 120, w15, w8,  -9);
   TEST_I5("maxi_s.b", 128, w16, w25, 9);
   TEST_I5("maxi_s.b", 136, w17, w13, 7);
   TEST_I5("maxi_s.b", 144, w18, w31, -8);
   TEST_I5("maxi_s.b", 152, w19, w11, -13);
   TEST_I5("maxi_s.b", 160, w20, w17, -14);
   TEST_I5("maxi_s.b", 168, w21, w31, -11);
   TEST_I5("maxi_s.b", 176, w22, w2,  -2);
   TEST_I5("maxi_s.b", 184, w23, w26, 4);
   TEST_I5("maxi_s.b", 192, w24, w9,  -10);
   TEST_I5("maxi_s.b", 200, w25, w17, -3);
   TEST_I5("maxi_s.b", 208, w26, w10, 15);
   TEST_I5("maxi_s.b", 216, w27, w27, -13);
   TEST_I5("maxi_s.b", 224, w28, w13, 10);
   TEST_I5("maxi_s.b", 232, w29, w12, -14);
   TEST_I5("maxi_s.b", 240, w30, w23, -10);
   TEST_I5("maxi_s.b", 104, w31, w9,  -8);
   TEST_I5("maxi_s.h",   0, w0,  w28, -6);
   TEST_I5("maxi_s.h",   8, w1,  w21, -12);
   TEST_I5("maxi_s.h",  16, w2,  w18, -3);
   TEST_I5("maxi_s.h",  24, w3,  w5,  6);
   TEST_I5("maxi_s.h",  32, w4,  w30, -13);
   TEST_I5("maxi_s.h",  40, w5,  w8,  -3);
   TEST_I5("maxi_s.h",  48, w6,  w11, -4);
   TEST_I5("maxi_s.h",  56, w7,  w5,  -9);
   TEST_I5("maxi_s.h",  64, w8,  w28, -3);
   TEST_I5("maxi_s.h",  72, w9,  w9,  -11);
   TEST_I5("maxi_s.h",  80, w10, w30, -3);
   TEST_I5("maxi_s.h",  88, w11, w27, 7);
   TEST_I5("maxi_s.h",  96, w12, w16, 11);
   TEST_I5("maxi_s.h", 104, w13, w2,  -9);
   TEST_I5("maxi_s.h", 112, w14, w3,  3);
   TEST_I5("maxi_s.h", 120, w15, w7,  15);
   TEST_I5("maxi_s.h", 128, w16, w20, 7);
   TEST_I5("maxi_s.h", 136, w17, w1,  12);
   TEST_I5("maxi_s.h", 144, w18, w21, 9);
   TEST_I5("maxi_s.h", 152, w19, w27, 9);
   TEST_I5("maxi_s.h", 160, w20, w9,  4);
   TEST_I5("maxi_s.h", 168, w21, w11, -12);
   TEST_I5("maxi_s.h", 176, w22, w9,  -10);
   TEST_I5("maxi_s.h", 184, w23, w7,  10);
   TEST_I5("maxi_s.h", 192, w24, w14, -15);
   TEST_I5("maxi_s.h", 200, w25, w28, 6);
   TEST_I5("maxi_s.h", 208, w26, w22, 8);
   TEST_I5("maxi_s.h", 216, w27, w27, 4);
   TEST_I5("maxi_s.h", 224, w28, w20, 10);
   TEST_I5("maxi_s.h", 232, w29, w13, -2);
   TEST_I5("maxi_s.h", 240, w30, w12, 7);
   TEST_I5("maxi_s.h", 168, w31, w24, -14);
   TEST_I5("maxi_s.w",   0, w0,  w25, 10);
   TEST_I5("maxi_s.w",   8, w1,  w0,  -14);
   TEST_I5("maxi_s.w",  16, w2,  w14, 0);
   TEST_I5("maxi_s.w",  24, w3,  w15, 15);
   TEST_I5("maxi_s.w",  32, w4,  w12, 5);
   TEST_I5("maxi_s.w",  40, w5,  w2,  -4);
   TEST_I5("maxi_s.w",  48, w6,  w23, 8);
   TEST_I5("maxi_s.w",  56, w7,  w17, 15);
   TEST_I5("maxi_s.w",  64, w8,  w31, 15);
   TEST_I5("maxi_s.w",  72, w9,  w9,  6);
   TEST_I5("maxi_s.w",  80, w10, w14, 9);
   TEST_I5("maxi_s.w",  88, w11, w9,  -11);
   TEST_I5("maxi_s.w",  96, w12, w4,  -8);
   TEST_I5("maxi_s.w", 104, w13, w6,  -11);
   TEST_I5("maxi_s.w", 112, w14, w22, -12);
   TEST_I5("maxi_s.w", 120, w15, w2,  9);
   TEST_I5("maxi_s.w", 128, w16, w5,  -11);
   TEST_I5("maxi_s.w", 136, w17, w28, 13);
   TEST_I5("maxi_s.w", 144, w18, w13, 12);
   TEST_I5("maxi_s.w", 152, w19, w13, 12);
   TEST_I5("maxi_s.w", 160, w20, w3,  0);
   TEST_I5("maxi_s.w", 168, w21, w28, 14);
   TEST_I5("maxi_s.w", 176, w22, w1,  -4);
   TEST_I5("maxi_s.w", 184, w23, w9,  -8);
   TEST_I5("maxi_s.w", 192, w24, w15, 4);
   TEST_I5("maxi_s.w", 200, w25, w19, -1);
   TEST_I5("maxi_s.w", 208, w26, w13, 15);
   TEST_I5("maxi_s.w", 216, w27, w27, 2);
   TEST_I5("maxi_s.w", 224, w28, w27, 0);
   TEST_I5("maxi_s.w", 232, w29, w8,  5);
   TEST_I5("maxi_s.w", 240, w30, w29, 9);
   TEST_I5("maxi_s.w", 160, w31, w11, 5);
   TEST_I5("maxi_s.d",   0, w0,  w23, -12);
   TEST_I5("maxi_s.d",   8, w1,  w0,  -4);
   TEST_I5("maxi_s.d",  16, w2,  w15, -16);
   TEST_I5("maxi_s.d",  24, w3,  w17, 0);
   TEST_I5("maxi_s.d",  32, w4,  w16, -14);
   TEST_I5("maxi_s.d",  40, w5,  w11, 2);
   TEST_I5("maxi_s.d",  48, w6,  w19, -7);
   TEST_I5("maxi_s.d",  56, w7,  w16, 11);
   TEST_I5("maxi_s.d",  64, w8,  w0,  13);
   TEST_I5("maxi_s.d",  72, w9,  w9,  8);
   TEST_I5("maxi_s.d",  80, w10, w14, 12);
   TEST_I5("maxi_s.d",  88, w11, w15, -8);
   TEST_I5("maxi_s.d",  96, w12, w30, -7);
   TEST_I5("maxi_s.d", 104, w13, w1,  9);
   TEST_I5("maxi_s.d", 112, w14, w17, 12);
   TEST_I5("maxi_s.d", 120, w15, w20, 2);
   TEST_I5("maxi_s.d", 128, w16, w6,  -11);
   TEST_I5("maxi_s.d", 136, w17, w5,  5);
   TEST_I5("maxi_s.d", 144, w18, w13, 0);
   TEST_I5("maxi_s.d", 152, w19, w13, -3);
   TEST_I5("maxi_s.d", 160, w20, w5,  -7);
   TEST_I5("maxi_s.d", 168, w21, w1,  -12);
   TEST_I5("maxi_s.d", 176, w22, w10, 6);
   TEST_I5("maxi_s.d", 184, w23, w19, 9);
   TEST_I5("maxi_s.d", 192, w24, w12, -4);
   TEST_I5("maxi_s.d", 200, w25, w8,  -6);
   TEST_I5("maxi_s.d", 208, w26, w29, 11);
   TEST_I5("maxi_s.d", 216, w27, w27, -13);
   TEST_I5("maxi_s.d", 224, w28, w22, 0);
   TEST_I5("maxi_s.d", 232, w29, w18, 13);
   TEST_I5("maxi_s.d", 240, w30, w6,  -13);
   TEST_I5("maxi_s.d",   8, w31, w9,  -12);
   TEST_I5("maxi_u.b",   0, w0,  w28, 13);
   TEST_I5("maxi_u.b",   8, w1,  w31, 25);
   TEST_I5("maxi_u.b",  16, w2,  w21, 3);
   TEST_I5("maxi_u.b",  24, w3,  w15, 31);
   TEST_I5("maxi_u.b",  32, w4,  w14, 21);
   TEST_I5("maxi_u.b",  40, w5,  w2,  7);
   TEST_I5("maxi_u.b",  48, w6,  w4,  24);
   TEST_I5("maxi_u.b",  56, w7,  w23, 11);
   TEST_I5("maxi_u.b",  64, w8,  w17, 28);
   TEST_I5("maxi_u.b",  72, w9,  w5,  24);
   TEST_I5("maxi_u.b",  80, w10, w10, 9);
   TEST_I5("maxi_u.b",  88, w11, w23, 30);
   TEST_I5("maxi_u.b",  96, w12, w13, 14);
   TEST_I5("maxi_u.b", 104, w13, w0,  28);
   TEST_I5("maxi_u.b", 112, w14, w14, 23);
   TEST_I5("maxi_u.b", 120, w15, w4,  29);
   TEST_I5("maxi_u.b", 128, w16, w11, 1);
   TEST_I5("maxi_u.b", 136, w17, w25, 8);
   TEST_I5("maxi_u.b", 144, w18, w16, 2);
   TEST_I5("maxi_u.b", 152, w19, w1,  30);
   TEST_I5("maxi_u.b", 160, w20, w6,  9);
   TEST_I5("maxi_u.b", 168, w21, w22, 18);
   TEST_I5("maxi_u.b", 176, w22, w13, 17);
   TEST_I5("maxi_u.b", 184, w23, w26, 31);
   TEST_I5("maxi_u.b", 192, w24, w26, 27);
   TEST_I5("maxi_u.b", 200, w25, w17, 26);
   TEST_I5("maxi_u.b", 208, w26, w15, 0);
   TEST_I5("maxi_u.b", 216, w27, w16, 29);
   TEST_I5("maxi_u.b", 224, w28, w25, 13);
   TEST_I5("maxi_u.b", 232, w29, w13, 14);
   TEST_I5("maxi_u.b", 240, w30, w27, 4);
   TEST_I5("maxi_u.b", 192, w31, w20, 23);
   TEST_I5("maxi_u.h",   0, w0,  w20, 27);
   TEST_I5("maxi_u.h",   8, w1,  w10, 7);
   TEST_I5("maxi_u.h",  16, w2,  w22, 2);
   TEST_I5("maxi_u.h",  24, w3,  w7,  29);
   TEST_I5("maxi_u.h",  32, w4,  w22, 29);
   TEST_I5("maxi_u.h",  40, w5,  w7,  26);
   TEST_I5("maxi_u.h",  48, w6,  w0,  8);
   TEST_I5("maxi_u.h",  56, w7,  w13, 22);
   TEST_I5("maxi_u.h",  64, w8,  w24, 12);
   TEST_I5("maxi_u.h",  72, w9,  w13, 3);
   TEST_I5("maxi_u.h",  80, w10, w10, 14);
   TEST_I5("maxi_u.h",  88, w11, w10, 18);
   TEST_I5("maxi_u.h",  96, w12, w0,  21);
   TEST_I5("maxi_u.h", 104, w13, w7,  18);
   TEST_I5("maxi_u.h", 112, w14, w14, 30);
   TEST_I5("maxi_u.h", 120, w15, w14, 9);
   TEST_I5("maxi_u.h", 128, w16, w9,  2);
   TEST_I5("maxi_u.h", 136, w17, w18, 8);
   TEST_I5("maxi_u.h", 144, w18, w26, 19);
   TEST_I5("maxi_u.h", 152, w19, w6,  13);
   TEST_I5("maxi_u.h", 160, w20, w10, 16);
   TEST_I5("maxi_u.h", 168, w21, w28, 21);
   TEST_I5("maxi_u.h", 176, w22, w8,  29);
   TEST_I5("maxi_u.h", 184, w23, w29, 30);
   TEST_I5("maxi_u.h", 192, w24, w15, 12);
   TEST_I5("maxi_u.h", 200, w25, w30, 21);
   TEST_I5("maxi_u.h", 208, w26, w7,  24);
   TEST_I5("maxi_u.h", 216, w27, w25, 20);
   TEST_I5("maxi_u.h", 224, w28, w1,  9);
   TEST_I5("maxi_u.h", 232, w29, w20, 11);
   TEST_I5("maxi_u.h", 240, w30, w2,  28);
   TEST_I5("maxi_u.h", 128, w31, w30, 22);
   TEST_I5("maxi_u.w",   0, w0,  w4,  16);
   TEST_I5("maxi_u.w",   8, w1,  w19, 15);
   TEST_I5("maxi_u.w",  16, w2,  w16, 27);
   TEST_I5("maxi_u.w",  24, w3,  w14, 17);
   TEST_I5("maxi_u.w",  32, w4,  w21, 9);
   TEST_I5("maxi_u.w",  40, w5,  w14, 29);
   TEST_I5("maxi_u.w",  48, w6,  w15, 7);
   TEST_I5("maxi_u.w",  56, w7,  w4,  18);
   TEST_I5("maxi_u.w",  64, w8,  w6,  14);
   TEST_I5("maxi_u.w",  72, w9,  w4,  5);
   TEST_I5("maxi_u.w",  80, w10, w10, 23);
   TEST_I5("maxi_u.w",  88, w11, w22, 24);
   TEST_I5("maxi_u.w",  96, w12, w9,  8);
   TEST_I5("maxi_u.w", 104, w13, w28, 22);
   TEST_I5("maxi_u.w", 112, w14, w14, 20);
   TEST_I5("maxi_u.w", 120, w15, w3,  22);
   TEST_I5("maxi_u.w", 128, w16, w12, 20);
   TEST_I5("maxi_u.w", 136, w17, w9,  16);
   TEST_I5("maxi_u.w", 144, w18, w13, 3);
   TEST_I5("maxi_u.w", 152, w19, w15, 23);
   TEST_I5("maxi_u.w", 160, w20, w2,  22);
   TEST_I5("maxi_u.w", 168, w21, w14, 12);
   TEST_I5("maxi_u.w", 176, w22, w17, 12);
   TEST_I5("maxi_u.w", 184, w23, w25, 30);
   TEST_I5("maxi_u.w", 192, w24, w15, 1);
   TEST_I5("maxi_u.w", 200, w25, w27, 21);
   TEST_I5("maxi_u.w", 208, w26, w15, 30);
   TEST_I5("maxi_u.w", 216, w27, w23, 12);
   TEST_I5("maxi_u.w", 224, w28, w16, 31);
   TEST_I5("maxi_u.w", 232, w29, w31, 23);
   TEST_I5("maxi_u.w", 240, w30, w2,  5);
   TEST_I5("maxi_u.w", 104, w31, w27, 20);
   TEST_I5("maxi_u.d",   0, w0,  w6,  11);
   TEST_I5("maxi_u.d",   8, w1,  w8,  17);
   TEST_I5("maxi_u.d",  16, w2,  w7,  6);
   TEST_I5("maxi_u.d",  24, w3,  w22, 4);
   TEST_I5("maxi_u.d",  32, w4,  w14, 16);
   TEST_I5("maxi_u.d",  40, w5,  w30, 29);
   TEST_I5("maxi_u.d",  48, w6,  w26, 31);
   TEST_I5("maxi_u.d",  56, w7,  w13, 27);
   TEST_I5("maxi_u.d",  64, w8,  w12, 16);
   TEST_I5("maxi_u.d",  72, w9,  w14, 22);
   TEST_I5("maxi_u.d",  80, w10, w10, 18);
   TEST_I5("maxi_u.d",  88, w11, w30, 25);
   TEST_I5("maxi_u.d",  96, w12, w20, 15);
   TEST_I5("maxi_u.d", 104, w13, w0,  20);
   TEST_I5("maxi_u.d", 112, w14, w14, 16);
   TEST_I5("maxi_u.d", 120, w15, w27, 0);
   TEST_I5("maxi_u.d", 128, w16, w25, 7);
   TEST_I5("maxi_u.d", 136, w17, w24, 20);
   TEST_I5("maxi_u.d", 144, w18, w19, 28);
   TEST_I5("maxi_u.d", 152, w19, w27, 12);
   TEST_I5("maxi_u.d", 160, w20, w10, 13);
   TEST_I5("maxi_u.d", 168, w21, w2,  31);
   TEST_I5("maxi_u.d", 176, w22, w1,  24);
   TEST_I5("maxi_u.d", 184, w23, w21, 8);
   TEST_I5("maxi_u.d", 192, w24, w21, 5);
   TEST_I5("maxi_u.d", 200, w25, w10, 1);
   TEST_I5("maxi_u.d", 208, w26, w29, 26);
   TEST_I5("maxi_u.d", 216, w27, w10, 18);
   TEST_I5("maxi_u.d", 224, w28, w5,  6);
   TEST_I5("maxi_u.d", 232, w29, w11, 1);
   TEST_I5("maxi_u.d", 240, w30, w18, 11);
   TEST_I5("maxi_u.d",  72, w31, w0,  26);
   TEST_I5("mini_s.b",   0, w0,  w2,  -11);
   TEST_I5("mini_s.b",   8, w1,  w12, -10);
   TEST_I5("mini_s.b",  16, w2,  w9,  -16);
   TEST_I5("mini_s.b",  24, w3,  w19, 3);
   TEST_I5("mini_s.b",  32, w4,  w24, 9);
   TEST_I5("mini_s.b",  40, w5,  w4,  10);
   TEST_I5("mini_s.b",  48, w6,  w22, -10);
   TEST_I5("mini_s.b",  56, w7,  w22, -16);
   TEST_I5("mini_s.b",  64, w8,  w22, 14);
   TEST_I5("mini_s.b",  72, w9,  w14, 11);
   TEST_I5("mini_s.b",  80, w10, w14, 8);
   TEST_I5("mini_s.b",  88, w11, w19, -11);
   TEST_I5("mini_s.b",  96, w12, w26, -1);
   TEST_I5("mini_s.b", 104, w13, w3,  -14);
   TEST_I5("mini_s.b", 112, w14, w24, 11);
   TEST_I5("mini_s.b", 120, w15, w26, 15);
   TEST_I5("mini_s.b", 128, w16, w3,  5);
   TEST_I5("mini_s.b", 136, w17, w1,  -4);
   TEST_I5("mini_s.b", 144, w18, w21, -14);
   TEST_I5("mini_s.b", 152, w19, w0,  0);
   TEST_I5("mini_s.b", 160, w20, w24, 14);
   TEST_I5("mini_s.b", 168, w21, w18, 1);
   TEST_I5("mini_s.b", 176, w22, w24, -5);
   TEST_I5("mini_s.b", 184, w23, w7,  -10);
   TEST_I5("mini_s.b", 192, w24, w24, 10);
   TEST_I5("mini_s.b", 200, w25, w19, 4);
   TEST_I5("mini_s.b", 208, w26, w4,  11);
   TEST_I5("mini_s.b", 216, w27, w25, -14);
   TEST_I5("mini_s.b", 224, w28, w5,  -7);
   TEST_I5("mini_s.b", 232, w29, w7,  -2);
   TEST_I5("mini_s.b", 240, w30, w30, -2);
   TEST_I5("mini_s.b", 192, w31, w23, -2);
   TEST_I5("mini_s.h",   0, w0,  w25, -9);
   TEST_I5("mini_s.h",   8, w1,  w17, 2);
   TEST_I5("mini_s.h",  16, w2,  w25, 8);
   TEST_I5("mini_s.h",  24, w3,  w1,  -8);
   TEST_I5("mini_s.h",  32, w4,  w21, -4);
   TEST_I5("mini_s.h",  40, w5,  w13, -11);
   TEST_I5("mini_s.h",  48, w6,  w5,  -5);
   TEST_I5("mini_s.h",  56, w7,  w19, 2);
   TEST_I5("mini_s.h",  64, w8,  w1,  -6);
   TEST_I5("mini_s.h",  72, w9,  w7,  15);
   TEST_I5("mini_s.h",  80, w10, w0,  -10);
   TEST_I5("mini_s.h",  88, w11, w18, 9);
   TEST_I5("mini_s.h",  96, w12, w11, 13);
   TEST_I5("mini_s.h", 104, w13, w17, 15);
   TEST_I5("mini_s.h", 112, w14, w29, 4);
   TEST_I5("mini_s.h", 120, w15, w3,  -15);
   TEST_I5("mini_s.h", 128, w16, w4,  -9);
   TEST_I5("mini_s.h", 136, w17, w7,  10);
   TEST_I5("mini_s.h", 144, w18, w19, 11);
   TEST_I5("mini_s.h", 152, w19, w13, -14);
   TEST_I5("mini_s.h", 160, w20, w22, -13);
   TEST_I5("mini_s.h", 168, w21, w6,  -2);
   TEST_I5("mini_s.h", 176, w22, w0,  15);
   TEST_I5("mini_s.h", 184, w23, w14, 13);
   TEST_I5("mini_s.h", 192, w24, w24, -3);
   TEST_I5("mini_s.h", 200, w25, w0,  -2);
   TEST_I5("mini_s.h", 208, w26, w5,  5);
   TEST_I5("mini_s.h", 216, w27, w12, -1);
   TEST_I5("mini_s.h", 224, w28, w0,  -6);
   TEST_I5("mini_s.h", 232, w29, w13, 4);
   TEST_I5("mini_s.h", 240, w30, w30, -3);
   TEST_I5("mini_s.h", 104, w31, w3,  0);
   TEST_I5("mini_s.w",   0, w0,  w23, -11);
   TEST_I5("mini_s.w",   8, w1,  w5,  -11);
   TEST_I5("mini_s.w",  16, w2,  w19, -14);
   TEST_I5("mini_s.w",  24, w3,  w23, -14);
   TEST_I5("mini_s.w",  32, w4,  w29, -9);
   TEST_I5("mini_s.w",  40, w5,  w10, 4);
   TEST_I5("mini_s.w",  48, w6,  w10, 4);
   TEST_I5("mini_s.w",  56, w7,  w15, -15);
   TEST_I5("mini_s.w",  64, w8,  w3,  -11);
   TEST_I5("mini_s.w",  72, w9,  w6,  -2);
   TEST_I5("mini_s.w",  80, w10, w29, 4);
   TEST_I5("mini_s.w",  88, w11, w3,  3);
   TEST_I5("mini_s.w",  96, w12, w8,  12);
   TEST_I5("mini_s.w", 104, w13, w10, -1);
   TEST_I5("mini_s.w", 112, w14, w12, -14);
   TEST_I5("mini_s.w", 120, w15, w20, -6);
   TEST_I5("mini_s.w", 128, w16, w8,  -14);
   TEST_I5("mini_s.w", 136, w17, w28, -11);
   TEST_I5("mini_s.w", 144, w18, w29, 4);
   TEST_I5("mini_s.w", 152, w19, w2,  4);
   TEST_I5("mini_s.w", 160, w20, w17, 8);
   TEST_I5("mini_s.w", 168, w21, w5,  -14);
   TEST_I5("mini_s.w", 176, w22, w24, 14);
   TEST_I5("mini_s.w", 184, w23, w2,  2);
   TEST_I5("mini_s.w", 192, w24, w24, 13);
   TEST_I5("mini_s.w", 200, w25, w2,  1);
   TEST_I5("mini_s.w", 208, w26, w29, 9);
   TEST_I5("mini_s.w", 216, w27, w3,  5);
   TEST_I5("mini_s.w", 224, w28, w24, 3);
   TEST_I5("mini_s.w", 232, w29, w16, 10);
   TEST_I5("mini_s.w", 240, w30, w30, 5);
   TEST_I5("mini_s.w", 104, w31, w15, -10);
   TEST_I5("mini_s.d",   0, w0,  w6,  -6);
   TEST_I5("mini_s.d",   8, w1,  w8,  1);
   TEST_I5("mini_s.d",  16, w2,  w7,  -14);
   TEST_I5("mini_s.d",  24, w3,  w25, 15);
   TEST_I5("mini_s.d",  32, w4,  w27, 1);
   TEST_I5("mini_s.d",  40, w5,  w25, -6);
   TEST_I5("mini_s.d",  48, w6,  w28, -16);
   TEST_I5("mini_s.d",  56, w7,  w20, 3);
   TEST_I5("mini_s.d",  64, w8,  w4,  -8);
   TEST_I5("mini_s.d",  72, w9,  w19, -1);
   TEST_I5("mini_s.d",  80, w10, w30, 10);
   TEST_I5("mini_s.d",  88, w11, w8,  14);
   TEST_I5("mini_s.d",  96, w12, w25, -3);
   TEST_I5("mini_s.d", 104, w13, w4,  -10);
   TEST_I5("mini_s.d", 112, w14, w27, -10);
   TEST_I5("mini_s.d", 120, w15, w12, -1);
   TEST_I5("mini_s.d", 128, w16, w22, 6);
   TEST_I5("mini_s.d", 136, w17, w10, -7);
   TEST_I5("mini_s.d", 144, w18, w15, 2);
   TEST_I5("mini_s.d", 152, w19, w2,  -15);
   TEST_I5("mini_s.d", 160, w20, w1,  11);
   TEST_I5("mini_s.d", 168, w21, w9,  9);
   TEST_I5("mini_s.d", 176, w22, w3,  13);
   TEST_I5("mini_s.d", 184, w23, w30, 9);
   TEST_I5("mini_s.d", 192, w24, w24, 15);
   TEST_I5("mini_s.d", 200, w25, w5,  -1);
   TEST_I5("mini_s.d", 208, w26, w28, -8);
   TEST_I5("mini_s.d", 216, w27, w18, 12);
   TEST_I5("mini_s.d", 224, w28, w10, -2);
   TEST_I5("mini_s.d", 232, w29, w13, -7);
   TEST_I5("mini_s.d", 240, w30, w30, -1);
   TEST_I5("mini_s.d",  24, w31, w14, 7);
   TEST_I5("mini_u.b",   0, w0,  w17, 18);
   TEST_I5("mini_u.b",   8, w1,  w17, 26);
   TEST_I5("mini_u.b",  16, w2,  w24, 9);
   TEST_I5("mini_u.b",  24, w3,  w20, 17);
   TEST_I5("mini_u.b",  32, w4,  w6,  1);
   TEST_I5("mini_u.b",  40, w5,  w2,  15);
   TEST_I5("mini_u.b",  48, w6,  w11, 29);
   TEST_I5("mini_u.b",  56, w7,  w25, 21);
   TEST_I5("mini_u.b",  64, w8,  w19, 15);
   TEST_I5("mini_u.b",  72, w9,  w6,  8);
   TEST_I5("mini_u.b",  80, w10, w23, 8);
   TEST_I5("mini_u.b",  88, w11, w4,  19);
   TEST_I5("mini_u.b",  96, w12, w13, 16);
   TEST_I5("mini_u.b", 104, w13, w30, 31);
   TEST_I5("mini_u.b", 112, w14, w16, 1);
   TEST_I5("mini_u.b", 120, w15, w0,  12);
   TEST_I5("mini_u.b", 128, w16, w0,  5);
   TEST_I5("mini_u.b", 136, w17, w10, 25);
   TEST_I5("mini_u.b", 144, w18, w18, 28);
   TEST_I5("mini_u.b", 152, w19, w31, 4);
   TEST_I5("mini_u.b", 160, w20, w22, 31);
   TEST_I5("mini_u.b", 168, w21, w30, 17);
   TEST_I5("mini_u.b", 176, w22, w2,  1);
   TEST_I5("mini_u.b", 184, w23, w0,  9);
   TEST_I5("mini_u.b", 192, w24, w31, 20);
   TEST_I5("mini_u.b", 200, w25, w0,  23);
   TEST_I5("mini_u.b", 208, w26, w26, 14);
   TEST_I5("mini_u.b", 216, w27, w12, 5);
   TEST_I5("mini_u.b", 224, w28, w18, 18);
   TEST_I5("mini_u.b", 232, w29, w11, 14);
   TEST_I5("mini_u.b", 240, w30, w10, 18);
   TEST_I5("mini_u.b",  88, w31, w0,  18);
   TEST_I5("mini_u.h",   0, w0,  w8,  15);
   TEST_I5("mini_u.h",   8, w1,  w10, 30);
   TEST_I5("mini_u.h",  16, w2,  w17, 5);
   TEST_I5("mini_u.h",  24, w3,  w26, 28);
   TEST_I5("mini_u.h",  32, w4,  w14, 19);
   TEST_I5("mini_u.h",  40, w5,  w28, 11);
   TEST_I5("mini_u.h",  48, w6,  w2,  12);
   TEST_I5("mini_u.h",  56, w7,  w20, 2);
   TEST_I5("mini_u.h",  64, w8,  w30, 20);
   TEST_I5("mini_u.h",  72, w9,  w30, 6);
   TEST_I5("mini_u.h",  80, w10, w28, 11);
   TEST_I5("mini_u.h",  88, w11, w12, 29);
   TEST_I5("mini_u.h",  96, w12, w23, 23);
   TEST_I5("mini_u.h", 104, w13, w1,  6);
   TEST_I5("mini_u.h", 112, w14, w12, 2);
   TEST_I5("mini_u.h", 120, w15, w4,  4);
   TEST_I5("mini_u.h", 128, w16, w13, 24);
   TEST_I5("mini_u.h", 136, w17, w2,  26);
   TEST_I5("mini_u.h", 144, w18, w18, 2);
   TEST_I5("mini_u.h", 152, w19, w15, 27);
   TEST_I5("mini_u.h", 160, w20, w21, 29);
   TEST_I5("mini_u.h", 168, w21, w0,  9);
   TEST_I5("mini_u.h", 176, w22, w9,  0);
   TEST_I5("mini_u.h", 184, w23, w28, 1);
   TEST_I5("mini_u.h", 192, w24, w2,  31);
   TEST_I5("mini_u.h", 200, w25, w4,  18);
   TEST_I5("mini_u.h", 208, w26, w26, 7);
   TEST_I5("mini_u.h", 216, w27, w9,  28);
   TEST_I5("mini_u.h", 224, w28, w1,  28);
   TEST_I5("mini_u.h", 232, w29, w2,  11);
   TEST_I5("mini_u.h", 240, w30, w1,  0);
   TEST_I5("mini_u.h",  32, w31, w28, 1);
   TEST_I5("mini_u.w",   0, w0,  w27, 8);
   TEST_I5("mini_u.w",   8, w1,  w27, 2);
   TEST_I5("mini_u.w",  16, w2,  w4,  3);
   TEST_I5("mini_u.w",  24, w3,  w6,  2);
   TEST_I5("mini_u.w",  32, w4,  w11, 10);
   TEST_I5("mini_u.w",  40, w5,  w20, 6);
   TEST_I5("mini_u.w",  48, w6,  w21, 30);
   TEST_I5("mini_u.w",  56, w7,  w17, 23);
   TEST_I5("mini_u.w",  64, w8,  w28, 12);
   TEST_I5("mini_u.w",  72, w9,  w29, 30);
   TEST_I5("mini_u.w",  80, w10, w1,  8);
   TEST_I5("mini_u.w",  88, w11, w9,  10);
   TEST_I5("mini_u.w",  96, w12, w14, 14);
   TEST_I5("mini_u.w", 104, w13, w20, 16);
   TEST_I5("mini_u.w", 112, w14, w31, 26);
   TEST_I5("mini_u.w", 120, w15, w19, 1);
   TEST_I5("mini_u.w", 128, w16, w9,  31);
   TEST_I5("mini_u.w", 136, w17, w26, 23);
   TEST_I5("mini_u.w", 144, w18, w18, 3);
   TEST_I5("mini_u.w", 152, w19, w20, 1);
   TEST_I5("mini_u.w", 160, w20, w18, 27);
   TEST_I5("mini_u.w", 168, w21, w26, 15);
   TEST_I5("mini_u.w", 176, w22, w5,  0);
   TEST_I5("mini_u.w", 184, w23, w19, 28);
   TEST_I5("mini_u.w", 192, w24, w3,  20);
   TEST_I5("mini_u.w", 200, w25, w30, 14);
   TEST_I5("mini_u.w", 208, w26, w26, 8);
   TEST_I5("mini_u.w", 216, w27, w31, 25);
   TEST_I5("mini_u.w", 224, w28, w30, 10);
   TEST_I5("mini_u.w", 232, w29, w20, 28);
   TEST_I5("mini_u.w", 240, w30, w23, 10);
   TEST_I5("mini_u.w",   0, w31, w25, 26);
   TEST_I5("mini_u.d",   0, w0,  w9,  3);
   TEST_I5("mini_u.d",   8, w1,  w14, 26);
   TEST_I5("mini_u.d",  16, w2,  w4,  21);
   TEST_I5("mini_u.d",  24, w3,  w0,  16);
   TEST_I5("mini_u.d",  32, w4,  w20, 31);
   TEST_I5("mini_u.d",  40, w5,  w28, 22);
   TEST_I5("mini_u.d",  48, w6,  w21, 8);
   TEST_I5("mini_u.d",  56, w7,  w0,  17);
   TEST_I5("mini_u.d",  64, w8,  w28, 14);
   TEST_I5("mini_u.d",  72, w9,  w6,  29);
   TEST_I5("mini_u.d",  80, w10, w0,  7);
   TEST_I5("mini_u.d",  88, w11, w19, 21);
   TEST_I5("mini_u.d",  96, w12, w13, 23);
   TEST_I5("mini_u.d", 104, w13, w3,  28);
   TEST_I5("mini_u.d", 112, w14, w19, 31);
   TEST_I5("mini_u.d", 120, w15, w18, 1);
   TEST_I5("mini_u.d", 128, w16, w9,  1);
   TEST_I5("mini_u.d", 136, w17, w6,  3);
   TEST_I5("mini_u.d", 144, w18, w18, 1);
   TEST_I5("mini_u.d", 152, w19, w17, 6);
   TEST_I5("mini_u.d", 160, w20, w15, 31);
   TEST_I5("mini_u.d", 168, w21, w22, 28);
   TEST_I5("mini_u.d", 176, w22, w11, 28);
   TEST_I5("mini_u.d", 184, w23, w2,  29);
   TEST_I5("mini_u.d", 192, w24, w30, 17);
   TEST_I5("mini_u.d", 200, w25, w29, 19);
   TEST_I5("mini_u.d", 208, w26, w26, 2);
   TEST_I5("mini_u.d", 216, w27, w30, 8);
   TEST_I5("mini_u.d", 224, w28, w31, 14);
   TEST_I5("mini_u.d", 232, w29, w21, 16);
   TEST_I5("mini_u.d", 240, w30, w22, 24);
   TEST_I5("mini_u.d", 152, w31, w29, 1);
   TEST_I5("subvi.b",   0, w0,  w21, 19);
   TEST_I5("subvi.b",   8, w1,  w21, 17);
   TEST_I5("subvi.b",  16, w2,  w8,  15);
   TEST_I5("subvi.b",  24, w3,  w4,  15);
   TEST_I5("subvi.b",  32, w4,  w18, 4);
   TEST_I5("subvi.b",  40, w5,  w2,  26);
   TEST_I5("subvi.b",  48, w6,  w4,  21);
   TEST_I5("subvi.b",  56, w7,  w5,  28);
   TEST_I5("subvi.b",  64, w8,  w3,  12);
   TEST_I5("subvi.b",  72, w9,  w15, 1);
   TEST_I5("subvi.b",  80, w10, w4,  19);
   TEST_I5("subvi.b",  88, w11, w23, 23);
   TEST_I5("subvi.b",  96, w12, w8,  28);
   TEST_I5("subvi.b", 104, w13, w24, 10);
   TEST_I5("subvi.b", 112, w14, w7,  5);
   TEST_I5("subvi.b", 120, w15, w11, 17);
   TEST_I5("subvi.b", 128, w16, w5,  21);
   TEST_I5("subvi.b", 136, w17, w29, 17);
   TEST_I5("subvi.b", 144, w18, w14, 30);
   TEST_I5("subvi.b", 152, w19, w29, 31);
   TEST_I5("subvi.b", 160, w20, w1,  18);
   TEST_I5("subvi.b", 168, w21, w24, 9);
   TEST_I5("subvi.b", 176, w22, w1,  6);
   TEST_I5("subvi.b", 184, w23, w25, 16);
   TEST_I5("subvi.b", 192, w24, w24, 22);
   TEST_I5("subvi.b", 200, w25, w21, 14);
   TEST_I5("subvi.b", 208, w26, w6,  10);
   TEST_I5("subvi.b", 216, w27, w13, 30);
   TEST_I5("subvi.b", 224, w28, w9,  28);
   TEST_I5("subvi.b", 232, w29, w6,  7);
   TEST_I5("subvi.b", 240, w30, w30, 7);
   TEST_I5("subvi.b", 112, w31, w13, 7);
   TEST_I5("subvi.h",   0, w0,  w1,  29);
   TEST_I5("subvi.h",   8, w1,  w26, 13);
   TEST_I5("subvi.h",  16, w2,  w26, 2);
   TEST_I5("subvi.h",  24, w3,  w5,  9);
   TEST_I5("subvi.h",  32, w4,  w21, 4);
   TEST_I5("subvi.h",  40, w5,  w3,  26);
   TEST_I5("subvi.h",  48, w6,  w1,  14);
   TEST_I5("subvi.h",  56, w7,  w29, 12);
   TEST_I5("subvi.h",  64, w8,  w24, 9);
   TEST_I5("subvi.h",  72, w9,  w19, 9);
   TEST_I5("subvi.h",  80, w10, w27, 10);
   TEST_I5("subvi.h",  88, w11, w1,  4);
   TEST_I5("subvi.h",  96, w12, w8,  30);
   TEST_I5("subvi.h", 104, w13, w6,  3);
   TEST_I5("subvi.h", 112, w14, w18, 8);
   TEST_I5("subvi.h", 120, w15, w23, 26);
   TEST_I5("subvi.h", 128, w16, w17, 21);
   TEST_I5("subvi.h", 136, w17, w0,  22);
   TEST_I5("subvi.h", 144, w18, w12, 19);
   TEST_I5("subvi.h", 152, w19, w31, 8);
   TEST_I5("subvi.h", 160, w20, w26, 18);
   TEST_I5("subvi.h", 168, w21, w27, 22);
   TEST_I5("subvi.h", 176, w22, w4,  20);
   TEST_I5("subvi.h", 184, w23, w10, 23);
   TEST_I5("subvi.h", 192, w24, w24, 19);
   TEST_I5("subvi.h", 200, w25, w16, 10);
   TEST_I5("subvi.h", 208, w26, w11, 27);
   TEST_I5("subvi.h", 216, w27, w8,  27);
   TEST_I5("subvi.h", 224, w28, w3,  7);
   TEST_I5("subvi.h", 232, w29, w22, 7);
   TEST_I5("subvi.h", 240, w30, w30, 15);
   TEST_I5("subvi.h",   0, w31, w19, 5);
   TEST_I5("subvi.w",   0, w0,  w29, 28);
   TEST_I5("subvi.w",   8, w1,  w12, 11);
   TEST_I5("subvi.w",  16, w2,  w12, 8);
   TEST_I5("subvi.w",  24, w3,  w31, 14);
   TEST_I5("subvi.w",  32, w4,  w9,  13);
   TEST_I5("subvi.w",  40, w5,  w12, 0);
   TEST_I5("subvi.w",  48, w6,  w15, 8);
   TEST_I5("subvi.w",  56, w7,  w5,  15);
   TEST_I5("subvi.w",  64, w8,  w20, 10);
   TEST_I5("subvi.w",  72, w9,  w16, 16);
   TEST_I5("subvi.w",  80, w10, w13, 12);
   TEST_I5("subvi.w",  88, w11, w14, 28);
   TEST_I5("subvi.w",  96, w12, w26, 4);
   TEST_I5("subvi.w", 104, w13, w2,  28);
   TEST_I5("subvi.w", 112, w14, w16, 0);
   TEST_I5("subvi.w", 120, w15, w30, 12);
   TEST_I5("subvi.w", 128, w16, w0,  27);
   TEST_I5("subvi.w", 136, w17, w13, 0);
   TEST_I5("subvi.w", 144, w18, w4,  12);
   TEST_I5("subvi.w", 152, w19, w20, 28);
   TEST_I5("subvi.w", 160, w20, w13, 10);
   TEST_I5("subvi.w", 168, w21, w27, 24);
   TEST_I5("subvi.w", 176, w22, w21, 18);
   TEST_I5("subvi.w", 184, w23, w27, 21);
   TEST_I5("subvi.w", 192, w24, w24, 8);
   TEST_I5("subvi.w", 200, w25, w5,  8);
   TEST_I5("subvi.w", 208, w26, w3,  20);
   TEST_I5("subvi.w", 216, w27, w3,  15);
   TEST_I5("subvi.w", 224, w28, w16, 15);
   TEST_I5("subvi.w", 232, w29, w21, 3);
   TEST_I5("subvi.w", 240, w30, w30, 4);
   TEST_I5("subvi.w", 136, w31, w0,  3);
   TEST_I5("subvi.d",   0, w0,  w11, 2);
   TEST_I5("subvi.d",   8, w1,  w0,  21);
   TEST_I5("subvi.d",  16, w2,  w28, 10);
   TEST_I5("subvi.d",  24, w3,  w29, 15);
   TEST_I5("subvi.d",  32, w4,  w14, 19);
   TEST_I5("subvi.d",  40, w5,  w20, 22);
   TEST_I5("subvi.d",  48, w6,  w14, 7);
   TEST_I5("subvi.d",  56, w7,  w6,  9);
   TEST_I5("subvi.d",  64, w8,  w9,  0);
   TEST_I5("subvi.d",  72, w9,  w26, 19);
   TEST_I5("subvi.d",  80, w10, w5,  22);
   TEST_I5("subvi.d",  88, w11, w6,  8);
   TEST_I5("subvi.d",  96, w12, w21, 18);
   TEST_I5("subvi.d", 104, w13, w4,  4);
   TEST_I5("subvi.d", 112, w14, w23, 11);
   TEST_I5("subvi.d", 120, w15, w14, 2);
   TEST_I5("subvi.d", 128, w16, w21, 8);
   TEST_I5("subvi.d", 136, w17, w0,  11);
   TEST_I5("subvi.d", 144, w18, w20, 29);
   TEST_I5("subvi.d", 152, w19, w17, 19);
   TEST_I5("subvi.d", 160, w20, w23, 30);
   TEST_I5("subvi.d", 168, w21, w25, 19);
   TEST_I5("subvi.d", 176, w22, w24, 23);
   TEST_I5("subvi.d", 184, w23, w6,  15);
   TEST_I5("subvi.d", 192, w24, w24, 21);
   TEST_I5("subvi.d", 200, w25, w29, 18);
   TEST_I5("subvi.d", 208, w26, w15, 3);
   TEST_I5("subvi.d", 216, w27, w15, 20);
   TEST_I5("subvi.d", 224, w28, w25, 22);
   TEST_I5("subvi.d", 232, w29, w13, 4);
   TEST_I5("subvi.d", 240, w30, w30, 24);
   TEST_I5("subvi.d", 184, w31, w7,  12);
#else
   printf("This test requires MSA extension.\n");
#endif
   return 0;
}
