.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XCreateImage __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XInitImage, XCreateImage, XGetPixel, XPutPixel, XSubImage, XAddPixel, XDestroyImage \- image utilities
.SH SYNTAX
.HP
Status XInitImage\^(\^XImage *\fIimage\fP\^);
.HP
XImage *XCreateImage\^(\^Display *\fIdisplay\fP\^, Visual *\fIvisual\fP\^,
unsigned int \fIdepth\fP\^, int \fIformat\fP\^, int \fIoffset\fP\^, char
*\fIdata\fP\^, unsigned int \fIwidth\fP\^, unsigned int \fIheight\fP\^, int
\fIbitmap_pad\fP\^, int \fIbytes_per_line\fP\^);
.HP
unsigned long XGetPixel\^(\^XImage *\fIximage\fP\^, int \fIx\fP\^, int
\fIy\fP\^);
.HP
int XPutPixel\^(\^XImage *\fIximage\fP\^, int \fIx\fP\^, int \fIy\fP\^,
unsigned long \fIpixel\fP\^);
.HP
XImage *XSubImage\^(\^XImage *\fIximage\fP\^, int \fIx\fP\^, int \fIy\fP\^,
unsigned int \fIsubimage_width\fP\^, unsigned int \fIsubimage_height\fP\^);
.HP
int XAddPixel\^(\^XImage *\fIximage\fP\^, long \fIvalue\fP\^);
.HP
int XDestroyImage\^(\^XImage *\^\fIximage\fP\^);
.SH ARGUMENTS
.IP \fIbitmap_pad\fP 1i
Specifies the quantum of a scanline (8, 16, or 32).
In other words, the start of one scanline is separated in client memory from
the start of the next scanline by an integer multiple of this many bits.
.IP \fIbytes_per_line\fP 1i
Specifies the number of bytes in the client image between
the start of one scanline and the start of the next.
.IP \fIdata\fP 1i
Specifies the image data.
.IP \fIdepth\fP 1i
Specifies the depth of the image.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIformat\fP 1i
Specifies the format for the image.
You can pass
.BR XYBitmap ,
.BR XYPixmap ,
or
.BR ZPixmap .
.IP \fIheight\fP 1i
Specifies the height of the image, in pixels.
.IP \fIoffset\fP 1i
Specifies the number of pixels to ignore at the beginning of the scanline.
.IP \fIpixel\fP 1i
Specifies the new pixel value.
.IP \fIsubimage_height\fP 1i
Specifies the height of the new subimage, in pixels.
.IP \fIsubimage_width\fP 1i
Specifies the width of the new subimage, in pixels.
.IP \fIvalue\fP 1i
Specifies the constant value that is to be added.
.IP \fIvisual\fP 1i
Specifies the
.B Visual
structure.
.IP \fIwidth\fP 1i
Specifies the width of the image, in pixels.
.IP \fIximage\fP 1i
Specifies the image.
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates.
.SH DESCRIPTION
The
.B XInitImage
function initializes the internal image manipulation routines of an
image structure, based on the values of the various structure members.
All fields other than the manipulation routines must already be initialized.
If the bytes_per_line member is zero,
.B XInitImage
will assume the image data is contiguous in memory and set the
bytes_per_line member to an appropriate value based on the other
members; otherwise, the value of bytes_per_line is not changed.
All of the manipulation routines are initialized to functions
that other Xlib image manipulation functions need to operate on the
type of image specified by the rest of the structure.
.LP
This function must be called for any image constructed by the client
before passing it to any other Xlib function.
Image structures created or returned by Xlib do not need to be
initialized in this fashion.
.LP
This function returns a nonzero status if initialization of the
structure is successful.
It returns zero if it detected some error
or inconsistency in the structure, in which case the image is not changed.
.LP
The
.B XCreateImage
function allocates the memory needed for an
.B XImage
structure for the
specified display but does not allocate space for the image itself.
Rather, it initializes the structure byte-order, bit-order, and bitmap-unit
values from the display and returns a pointer to the
.B XImage
structure.
The red, green, and blue mask values are defined for Z format images only
and are derived from the
.B Visual
structure passed in.
Other values also are passed in.
The offset permits the rapid displaying of the image without requiring each
scanline to be shifted into position.
If you pass a zero value in bytes_per_line,
Xlib assumes that the scanlines are contiguous
in memory and calculates the value of bytes_per_line itself.
.LP
Note that when the image is created using
.BR XCreateImage ,
.BR XGetImage ,
or
.BR XSubImage ,
the destroy procedure that the
.B XDestroyImage
function calls frees both the image structure
and the data pointed to by the image structure.
.LP
The basic functions used to get a pixel, set a pixel, create a subimage,
and add a constant value to an image are defined in the image object.
The functions in this section are really macro invocations of the functions
in the image object and are defined in
.hN X11/Xutil.h .
.LP
The
.B XGetPixel
function returns the specified pixel from the named image.
The pixel value is returned in normalized format (that is,
the least significant byte of the long is the least significant byte
of the pixel).
The image must contain the x and y coordinates.
.LP
The
.B XPutPixel
function overwrites the pixel in the named image with the specified pixel value.
The input pixel value must be in normalized format
(that is, the least significant byte of the long is the least significant
byte of the pixel).
The image must contain the x and y coordinates.
.LP
The
.B XSubImage
function creates a new image that is a subsection of an existing one.
It allocates the memory necessary for the new
.B XImage
structure
and returns a pointer to the new image.
The data is copied from the source image,
and the image must contain the rectangle defined by x, y, subimage_width,
and subimage_height.
.LP
The
.B XAddPixel
function adds a constant value to every pixel in an image.
It is useful when you have a base pixel value from allocating
color resources and need to manipulate the image to that form.
.LP
The
.B XDestroyImage
function deallocates the memory associated with the
.B XImage
structure.
.SH "SEE ALSO"
XPutImage(__libmansuffix__)
.br
\fI\*(xL\fP
