/*
 * OmniVision ov10635 sensor camera setup 1280x800@30/UYVY/BT601/8bit
 *
 * Copyright (C) 2015-2020 Cogent Embedded, Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

//#define OV10635_DISPLAY_PATTERN

#define OV10635_SENSOR_WIDTH		1312
#define OV10635_SENSOR_HEIGHT		814

#define OV10635_MAX_WIDTH		1280
#define OV10635_MAX_HEIGHT		800

#define OV10635_PCLK_96MHZ
//#define OV10635_PCLK_88MHZ

#if defined(OV10635_PCLK_96MHZ)
/* VTS=PCLK/FPS/HTS/2 (=96MHz/30/1750/2) */
 #define OV10635_HTS			1750
 #define OV10635_VTS			914 /* fps=30 */
#elif defined(OV10635_PCLK_88MHZ)
/* VTS=PCLK/FPS/HTS/2 (=88MHz/1572/30/2) */
 #define OV10635_HTS			1572
 #define OV10635_VTS			933 /* fps=29.9998 */
#else
 #error PCLK not defined
#endif

struct ov10635_reg {
	u16	reg;
	u8	val;
};

static const struct ov10635_reg ov10635_regs[] = {
//{0x0103, 0x01},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x300C, 0x61},
{0x301B, 0xFF},
{0x301C, 0xFF},
{0x301A, 0xFF},
{0x3011, 0x42},
{0x6900, 0x0C},
{0x6901, 0x19},
{0x3503, 0x10},
{0x3025, 0x03},
#if defined(OV10635_PCLK_96MHZ)
{0x3003, 0x20},
{0x3004, 0x21},
#elif defined(OV10635_PCLK_88MHZ)
{0x3003, 0x16},
{0x3004, 0x30},
#endif
{0x3005, 0x40},
{0x3006, 0x91},
{0x3600, 0x74},
{0x3601, 0x2B},
{0x3612, 0x00},
{0x3611, 0x67},
{0x3633, 0xCA},
{0x3602, 0xAF},
{0x3603, 0x04},
{0x3630, 0x28},
{0x3631, 0x16},
{0x3714, 0x10},
{0x371D, 0x01},
{0x4300, 0x3A},
{0x3007, 0x01},
{0x3024, 0x03},
{0x3020, 0x0A},
{0x3702, 0x0D},
{0x3703, 0x20},
{0x3704, 0x15},
{0x3709, 0xA8},
{0x370C, 0xC7},
{0x370D, 0x80},
{0x3712, 0x00},
{0x3713, 0x20},
{0x3715, 0x04},
{0x381D, 0x40},
{0x381C, 0x00},
{0x3822, 0x50},
{0x3824, 0x10},
{0x3815, 0x8C},
{0x3804, 0x05},
{0x3805, 0x1F},
{0x3800, 0x00},
{0x3801, 0x00},
{0x3806, 0x03},
{0x3807, 0x28},
{0x3802, 0x00},
{0x3803, 0x07},
{0x3808, 0x05},
{0x3809, 0x00},
{0x380A, 0x03},
{0x380B, 0x20},
{0x380C, OV10635_HTS >> 8},
{0x380D, OV10635_HTS & 0xff},
{0x380E, OV10635_VTS >> 8},
{0x380F, OV10635_VTS & 0xff},
{0x3813, 0x02},
{0x3811, 0x08},
{0x381F, 0x0C},
{0x3819, 0x04},
{0x3804, 0x01},
{0x3805, 0x00},
{0x3828, 0x03},
{0x3829, 0x10},
{0x382A, 0x10},
{0x3621, 0x63},
{0x5005, 0x08},
{0x56D5, 0x00},
{0x56D6, 0x80},
{0x56D7, 0x00},
{0x56D8, 0x00},
{0x56D9, 0x00},
{0x56DA, 0x80},
{0x56DB, 0x00},
{0x56DC, 0x00},
{0x56E8, 0x00},
{0x56E9, 0x7F},
{0x56EA, 0x00},
{0x56EB, 0x7F},
{0x5100, 0x00},
{0x5101, 0x80},
{0x5102, 0x00},
{0x5103, 0x80},
{0x5104, 0x00},
{0x5105, 0x80},
{0x5106, 0x00},
{0x5107, 0x80},
{0x5108, 0x00},
{0x5109, 0x00},
{0x510A, 0x00},
{0x510B, 0x00},
{0x510C, 0x00},
{0x510D, 0x00},
{0x510E, 0x00},
{0x510F, 0x00},
{0x5110, 0x00},
{0x5111, 0x80},
{0x5112, 0x00},
{0x5113, 0x80},
{0x5114, 0x00},
{0x5115, 0x80},
{0x5116, 0x00},
{0x5117, 0x80},
{0x5118, 0x00},
{0x5119, 0x00},
{0x511A, 0x00},
{0x511B, 0x00},
{0x511C, 0x00},
{0x511D, 0x00},
{0x511E, 0x00},
{0x511F, 0x00},
{0x56D0, 0x00},
{0x5006, 0x04},
{0x5608, 0x05},
{0x52D7, 0x06},
{0x528D, 0x08},
{0x5293, 0x12},
{0x52D3, 0x12},
{0x5288, 0x06},
{0x5289, 0x20},
{0x52C8, 0x06},
{0x52C9, 0x20},
{0x52CD, 0x04},
{0x5381, 0x00},
{0x5382, 0xFF},
{0x5589, 0x76},
{0x558A, 0x47},
{0x558B, 0xEF},
{0x558C, 0xC9},
{0x558D, 0x49},
{0x558E, 0x30},
{0x558F, 0x67},
{0x5590, 0x3F},
{0x5591, 0xF0},
{0x5592, 0x10},
{0x55A2, 0x6D},
{0x55A3, 0x55},
{0x55A4, 0xC3},
{0x55A5, 0xB5},
{0x55A6, 0x43},
{0x55A7, 0x38},
{0x55A8, 0x5F},
{0x55A9, 0x4B},
{0x55AA, 0xF0},
{0x55AB, 0x10},
{0x5581, 0x52},
{0x5300, 0x01},
{0x5301, 0x00},
{0x5302, 0x00},
{0x5303, 0x0E},
{0x5304, 0x00},
{0x5305, 0x0E},
{0x5306, 0x00},
{0x5307, 0x36},
{0x5308, 0x00},
{0x5309, 0xD9},
{0x530A, 0x00},
{0x530B, 0x0F},
{0x530C, 0x00},
{0x530D, 0x2C},
{0x530E, 0x00},
{0x530F, 0x59},
{0x5310, 0x00},
{0x5311, 0x7B},
{0x5312, 0x00},
{0x5313, 0x22},
{0x5314, 0x00},
{0x5315, 0xD5},
{0x5316, 0x00},
{0x5317, 0x13},
{0x5318, 0x00},
{0x5319, 0x18},
{0x531A, 0x00},
{0x531B, 0x26},
{0x531C, 0x00},
{0x531D, 0xDC},
{0x531E, 0x00},
{0x531F, 0x02},
{0x5320, 0x00},
{0x5321, 0x24},
{0x5322, 0x00},
{0x5323, 0x56},
{0x5324, 0x00},
{0x5325, 0x85},
{0x5326, 0x00},
{0x5327, 0x20},
{0x5609, 0x01},
{0x560A, 0x40},
{0x560B, 0x01},
{0x560C, 0x40},
{0x560D, 0x00},
{0x560E, 0xFA},
{0x560F, 0x00},
{0x5610, 0xFA},
{0x5611, 0x02},
{0x5612, 0x80},
{0x5613, 0x02},
{0x5614, 0x80},
{0x5615, 0x01},
{0x5616, 0x2C},
{0x5617, 0x01},
{0x5618, 0x2C},
{0x563B, 0x01},
{0x563C, 0x01},
{0x563D, 0x01},
{0x563E, 0x01},
{0x563F, 0x03},
{0x5640, 0x03},
{0x5641, 0x03},
{0x5642, 0x05},
{0x5643, 0x09},
{0x5644, 0x05},
{0x5645, 0x05},
{0x5646, 0x05},
{0x5647, 0x05},
{0x5651, 0x00},
{0x5652, 0x80},
{0x521A, 0x01},
{0x521B, 0x03},
{0x521C, 0x06},
{0x521D, 0x0A},
{0x521E, 0x0E},
{0x521F, 0x12},
{0x5220, 0x16},
{0x5223, 0x02},
{0x5225, 0x04},
{0x5227, 0x08},
{0x5229, 0x0C},
{0x522B, 0x12},
{0x522D, 0x18},
{0x522F, 0x1E},
{0x5241, 0x04},
{0x5242, 0x01},
{0x5243, 0x03},
{0x5244, 0x06},
{0x5245, 0x0A},
{0x5246, 0x0E},
{0x5247, 0x12},
{0x5248, 0x16},
{0x524A, 0x03},
{0x524C, 0x04},
{0x524E, 0x08},
{0x5250, 0x0C},
{0x5252, 0x12},
{0x5254, 0x18},
{0x5256, 0x1E},
{0x4606, (2*OV10635_HTS) >> 8}, /* fifo_line_length = 2*hts */
{0x4607, (2*OV10635_HTS) & 0xff},
{0x460a, (2*(OV10635_HTS-OV10635_MAX_WIDTH)) >> 8}, /* fifo_hsync_start = 2*(hts - xres) */
{0x460b, (2*(OV10635_HTS-OV10635_MAX_WIDTH)) & 0xff },
{0x460C, 0x00},
{0x4620, 0x0E},
#if 0
{0x4700, 0x02}, // BT656: mode is acceptable but artefact lines on left/bottom due to BT656 SAV/EAV are parsed as image data
#else
{0x4700, 0x04}, // BT601: 0x08 is also accaptable as HS/VS mode
#endif
{0x4701, 0x00},
{0x4702, 0x01},
{0x4004, 0x04},
{0x4005, 0x18},
{0x4001, 0x06},
{0x4050, 0x22},
{0x4051, 0x24},
{0x4052, 0x02},
{0x4057, 0x9C},
{0x405A, 0x00},
{0x4202, 0x02},
{0x3023, 0x10},
{0x0100, 0x01},
{0x0100, 0x01},
{0x0100, 0x01},
{0x0100, 0x01},
{0x0100, 0x01},
{0x0100, 0x01},
{0x6F10, 0x07},
{0x6F11, 0x82},
{0x6F12, 0x04},
{0x6F13, 0x00},
{0xD000, 0x19},
{0xD001, 0xA0},
{0xD002, 0x00},
{0xD003, 0x01},
{0xD004, 0xA9},
{0xD005, 0xAD},
{0xD006, 0x10},
{0xD007, 0x40},
{0xD008, 0x44},
{0xD009, 0x00},
{0xD00A, 0x68},
{0xD00B, 0x00},
{0xD00C, 0x15},
{0xD00D, 0x00},
{0xD00E, 0x00},
{0xD00F, 0x00},
{0xD040, 0x9C},
{0xD041, 0x21},
{0xD042, 0xFF},
{0xD043, 0xF8},
{0xD044, 0xD4},
{0xD045, 0x01},
{0xD046, 0x48},
{0xD047, 0x00},
{0xD048, 0xD4},
{0xD049, 0x01},
{0xD04A, 0x50},
{0xD04B, 0x04},
{0xD04C, 0x18},
{0xD04D, 0x60},
{0xD04E, 0x00},
{0xD04F, 0x01},
{0xD050, 0xA8},
{0xD051, 0x63},
{0xD052, 0x02},
{0xD053, 0xA4},
{0xD054, 0x85},
{0xD055, 0x43},
{0xD056, 0x00},
{0xD057, 0x00},
{0xD058, 0x18},
{0xD059, 0x60},
{0xD05A, 0x00},
{0xD05B, 0x01},
{0xD05C, 0xA8},
{0xD05D, 0x63},
{0xD05E, 0x03},
{0xD05F, 0xF0},
{0xD060, 0x98},
{0xD061, 0xA3},
{0xD062, 0x00},
{0xD063, 0x00},
{0xD064, 0x8C},
{0xD065, 0x6A},
{0xD066, 0x00},
{0xD067, 0x6E},
{0xD068, 0xE5},
{0xD069, 0x85},
{0xD06A, 0x18},
{0xD06B, 0x00},
{0xD06C, 0x10},
{0xD06D, 0x00},
{0xD06E, 0x00},
{0xD06F, 0x10},
{0xD070, 0x9C},
{0xD071, 0x80},
{0xD072, 0x00},
{0xD073, 0x03},
{0xD074, 0x18},
{0xD075, 0x60},
{0xD076, 0x00},
{0xD077, 0x01},
{0xD078, 0xA8},
{0xD079, 0x63},
{0xD07A, 0x07},
{0xD07B, 0x80},
{0xD07C, 0x07},
{0xD07D, 0xFF},
{0xD07E, 0xF9},
{0xD07F, 0x03},
{0xD080, 0x8C},
{0xD081, 0x63},
{0xD082, 0x00},
{0xD083, 0x00},
{0xD084, 0xA5},
{0xD085, 0x6B},
{0xD086, 0x00},
{0xD087, 0xFF},
{0xD088, 0x18},
{0xD089, 0x80},
{0xD08A, 0x00},
{0xD08B, 0x01},
{0xD08C, 0xA8},
{0xD08D, 0x84},
{0xD08E, 0x01},
{0xD08F, 0x04},
{0xD090, 0xE1},
{0xD091, 0x6B},
{0xD092, 0x58},
{0xD093, 0x00},
{0xD094, 0x94},
{0xD095, 0x6A},
{0xD096, 0x00},
{0xD097, 0x70},
{0xD098, 0xE1},
{0xD099, 0x6B},
{0xD09A, 0x20},
{0xD09B, 0x00},
{0xD09C, 0x95},
{0xD09D, 0x6B},
{0xD09E, 0x00},
{0xD09F, 0x00},
{0xD0A0, 0xE4},
{0xD0A1, 0x8B},
{0xD0A2, 0x18},
{0xD0A3, 0x00},
{0xD0A4, 0x0C},
{0xD0A5, 0x00},
{0xD0A6, 0x00},
{0xD0A7, 0x23},
{0xD0A8, 0x15},
{0xD0A9, 0x00},
{0xD0AA, 0x00},
{0xD0AB, 0x00},
{0xD0AC, 0x18},
{0xD0AD, 0x60},
{0xD0AE, 0x80},
{0xD0AF, 0x06},
{0xD0B0, 0xA8},
{0xD0B1, 0x83},
{0xD0B2, 0x40},
{0xD0B3, 0x08},
{0xD0B4, 0xA8},
{0xD0B5, 0xE3},
{0xD0B6, 0x38},
{0xD0B7, 0x2A},
{0xD0B8, 0xA8},
{0xD0B9, 0xC3},
{0xD0BA, 0x40},
{0xD0BB, 0x09},
{0xD0BC, 0xA8},
{0xD0BD, 0xA3},
{0xD0BE, 0x38},
{0xD0BF, 0x29},
{0xD0C0, 0x8C},
{0xD0C1, 0x65},
{0xD0C2, 0x00},
{0xD0C3, 0x00},
{0xD0C4, 0xD8},
{0xD0C5, 0x04},
{0xD0C6, 0x18},
{0xD0C7, 0x00},
{0xD0C8, 0x8C},
{0xD0C9, 0x67},
{0xD0CA, 0x00},
{0xD0CB, 0x00},
{0xD0CC, 0xD8},
{0xD0CD, 0x06},
{0xD0CE, 0x18},
{0xD0CF, 0x00},
{0xD0D0, 0x18},
{0xD0D1, 0x60},
{0xD0D2, 0x80},
{0xD0D3, 0x06},
{0xD0D4, 0xA8},
{0xD0D5, 0xE3},
{0xD0D6, 0x67},
{0xD0D7, 0x02},
{0xD0D8, 0xA9},
{0xD0D9, 0x03},
{0xD0DA, 0x67},
{0xD0DB, 0x03},
{0xD0DC, 0xA8},
{0xD0DD, 0xC3},
{0xD0DE, 0x3D},
{0xD0DF, 0x05},
{0xD0E0, 0x8C},
{0xD0E1, 0x66},
{0xD0E2, 0x00},
{0xD0E3, 0x00},
{0xD0E4, 0xB8},
{0xD0E5, 0x63},
{0xD0E6, 0x00},
{0xD0E7, 0x18},
{0xD0E8, 0xB8},
{0xD0E9, 0x63},
{0xD0EA, 0x00},
{0xD0EB, 0x98},
{0xD0EC, 0xBC},
{0xD0ED, 0x03},
{0xD0EE, 0x00},
{0xD0EF, 0x00},
{0xD0F0, 0x10},
{0xD0F1, 0x00},
{0xD0F2, 0x00},
{0xD0F3, 0x16},
{0xD0F4, 0xB8},
{0xD0F5, 0x83},
{0xD0F6, 0x00},
{0xD0F7, 0x19},
{0xD0F8, 0x8C},
{0xD0F9, 0x67},
{0xD0FA, 0x00},
{0xD0FB, 0x00},
{0xD0FC, 0xB8},
{0xD0FD, 0xA4},
{0xD0FE, 0x00},
{0xD0FF, 0x98},
{0xD100, 0xB8},
{0xD101, 0x83},
{0xD102, 0x00},
{0xD103, 0x08},
{0xD104, 0x8C},
{0xD105, 0x68},
{0xD106, 0x00},
{0xD107, 0x00},
{0xD108, 0xE0},
{0xD109, 0x63},
{0xD10A, 0x20},
{0xD10B, 0x04},
{0xD10C, 0xE0},
{0xD10D, 0x65},
{0xD10E, 0x18},
{0xD10F, 0x00},
{0xD110, 0xA4},
{0xD111, 0x83},
{0xD112, 0xFF},
{0xD113, 0xFF},
{0xD114, 0xB8},
{0xD115, 0x64},
{0xD116, 0x00},
{0xD117, 0x48},
{0xD118, 0xD8},
{0xD119, 0x07},
{0xD11A, 0x18},
{0xD11B, 0x00},
{0xD11C, 0xD8},
{0xD11D, 0x08},
{0xD11E, 0x20},
{0xD11F, 0x00},
{0xD120, 0x9C},
{0xD121, 0x60},
{0xD122, 0x00},
{0xD123, 0x00},
{0xD124, 0xD8},
{0xD125, 0x06},
{0xD126, 0x18},
{0xD127, 0x00},
{0xD128, 0x00},
{0xD129, 0x00},
{0xD12A, 0x00},
{0xD12B, 0x08},
{0xD12C, 0x15},
{0xD12D, 0x00},
{0xD12E, 0x00},
{0xD12F, 0x00},
{0xD130, 0x8C},
{0xD131, 0x6A},
{0xD132, 0x00},
{0xD133, 0x76},
{0xD134, 0xBC},
{0xD135, 0x23},
{0xD136, 0x00},
{0xD137, 0x00},
{0xD138, 0x13},
{0xD139, 0xFF},
{0xD13A, 0xFF},
{0xD13B, 0xE6},
{0xD13C, 0x18},
{0xD13D, 0x60},
{0xD13E, 0x80},
{0xD13F, 0x06},
{0xD140, 0x03},
{0xD141, 0xFF},
{0xD142, 0xFF},
{0xD143, 0xDD},
{0xD144, 0xA8},
{0xD145, 0x83},
{0xD146, 0x40},
{0xD147, 0x08},
{0xD148, 0x85},
{0xD149, 0x21},
{0xD14A, 0x00},
{0xD14B, 0x00},
{0xD14C, 0x85},
{0xD14D, 0x41},
{0xD14E, 0x00},
{0xD14F, 0x04},
{0xD150, 0x44},
{0xD151, 0x00},
{0xD152, 0x48},
{0xD153, 0x00},
{0xD154, 0x9C},
{0xD155, 0x21},
{0xD156, 0x00},
{0xD157, 0x08},
{0x6F0E, 0x03},
{0x6F0F, 0x00},
{0x460E, 0x08},
{0x460F, 0x01},
{0x4610, 0x00},
{0x4611, 0x01},
{0x4612, 0x00},
{0x4613, 0x01},
{0x4605, 0x08}, // 8bit
//{0x4709, 0x10}, // swap data bits order [9:0] -> [0:9]
{0x4608, 0x00},
{0x4609, 0x08},
{0x6804, 0x00},
{0x6805, 0x06},
{0x6806, 0x00},
{0x5120, 0x00},
{0x3510, 0x00},
{0x3504, 0x00},
{0x6800, 0x00},
{0x6F0D, 0x01},
{0x4708, 0x01}, // PCLK rising edge, VSYNC active low
{0x5000, 0xFF},
{0x5001, 0xBF},
{0x5002, 0x7E},
#ifdef OV10635_DISPLAY_PATTERN
{0x503d, 0x80},
#else
{0x503D, 0x00},
#endif
{0xC450, 0x01}, /* AA mode */
{0xC452, 0x04},
{0xC453, 0x00},
{0xC454, 0x00},
{0xC455, 0x01},
{0xC456, 0x01},
{0xC457, 0x00},
{0xC458, 0x00},
{0xC459, 0x00},
{0xC45B, 0x00},
{0xC45C, 0x01},
{0xC45D, 0x00},
{0xC45E, 0x00},
{0xC45F, 0x00},
{0xC460, 0x00},
{0xC461, 0x01},
{0xC462, 0x01},
{0xC464, 0x03},
{0xC465, 0x00},
{0xC466, 0x8A},
{0xC467, 0x00},
{0xC468, 0x86},
{0xC469, 0x00},
{0xC46A, 0x30},
{0xC46B, 0x50},
{0xC46C, 0x30},
{0xC46D, 0x28},
{0xC46E, 0x60},
{0xC46F, 0x40},
{0xC47C, 0x01},
{0xC47D, 0x38},
{0xC47E, 0x00},
{0xC47F, 0x00},
{0xC480, 0x00},
{0xC481, 0xFF},
{0xC482, 0x00},
{0xC483, 0x40},
{0xC484, 0x00},
{0xC485, 0x18},
{0xC486, 0x00},
{0xC487, 0x18},
{0xC488, (OV10635_VTS-8)*16 >> 8},
{0xC489, (OV10635_VTS-8)*16 & 0xff},
{0xC48A, (OV10635_VTS-8)*16 >> 8},
{0xC48B, (OV10635_VTS-8)*16 & 0xff},
{0xC48C, 0x00},
{0xC48D, 0x04},
{0xC48E, 0x00},
{0xC48F, 0x04},
{0xC490, 0x03},
{0xC492, 0x20},
{0xC493, 0x08},
{0xC498, 0x02},
{0xC499, 0x00},
{0xC49A, 0x02},
{0xC49B, 0x00},
{0xC49C, 0x02},
{0xC49D, 0x00},
{0xC49E, 0x02},
{0xC49F, 0x60},
{0xC4A0, 0x03},
{0xC4A1, 0x00},
{0xC4A2, 0x04},
{0xC4A3, 0x00},
{0xC4A4, 0x00},
{0xC4A5, 0x10},
{0xC4A6, 0x00},
{0xC4A7, 0x40},
{0xC4A8, 0x00},
{0xC4A9, 0x80},
{0xC4AA, 0x0D},
{0xC4AB, 0x00},
{0xC4AC, 0x0F},
{0xC4AD, 0xC0},
{0xC4B4, 0x01},
{0xC4B5, 0x01},
{0xC4B6, 0x00},
{0xC4B7, 0x01},
{0xC4B8, 0x00},
{0xC4B9, 0x01},
{0xC4BA, 0x01},
{0xC4BB, 0x00},
{0xC4BC, 0x01},
{0xC4BD, 0x60},
{0xC4BE, 0x02},
{0xC4BF, 0x33},
{0xC4C8, 0x03},
{0xC4C9, 0xD0},
{0xC4CA, 0x0E},
{0xC4CB, 0x00},
{0xC4CC, 0x0E},
{0xC4CD, 0x51},
{0xC4CE, 0x0E},
{0xC4CF, 0x51},
{0xC4D0, 0x04},
{0xC4D1, 0x80},
{0xC4E0, 0x04},
{0xC4E1, 0x02},
{0xC4E2, 0x01},
{0xC4E4, 0x10},
{0xC4E5, 0x20},
{0xC4E6, 0x30},
{0xC4E7, 0x40},
{0xC4E8, 0x50},
{0xC4E9, 0x60},
{0xC4EA, 0x70},
{0xC4EB, 0x80},
{0xC4EC, 0x90},
{0xC4ED, 0xA0},
{0xC4EE, 0xB0},
{0xC4EF, 0xC0},
{0xC4F0, 0xD0},
{0xC4F1, 0xE0},
{0xC4F2, 0xF0},
{0xC4F3, 0x80},
{0xC4F4, 0x00},
{0xC4F5, 0x20},
{0xC4F6, 0x02},
{0xC4F7, 0x00},
{0xC4F8, 0x00},
{0xC4F9, 0x00},
{0xC4FA, 0x00},
{0xC4FB, 0x01},
{0xC4FC, 0x01},
{0xC4FD, 0x00},
{0xC4FE, 0x04},
{0xC4FF, 0x02},
{0xC500, 0x48},
{0xC501, 0x74},
{0xC502, 0x58},
{0xC503, 0x80},
{0xC504, 0x05},
{0xC505, 0x80},
{0xC506, 0x03},
{0xC507, 0x80},
{0xC508, 0x01},
{0xC509, 0xC0},
{0xC50A, 0x01},
{0xC50B, 0xA0},
{0xC50C, 0x01},
{0xC50D, 0x2C},
{0xC50E, 0x01},
{0xC50F, 0x0A},
{0xC510, 0x00},
{0xC511, 0x00},
{0xC512, 0xE5},
{0xC513, 0x14},
{0xC514, 0x04},
{0xC515, 0x00},
{0xC518, OV10635_VTS >> 8},
{0xC519, OV10635_VTS & 0xff},
{0xC51A, OV10635_HTS >> 8},
{0xC51B, OV10635_HTS & 0xff},
{0xC2E0, 0x00},
{0xC2E1, 0x51},
{0xC2E2, 0x00},
{0xC2E3, 0xD6},
{0xC2E4, 0x01},
{0xC2E5, 0x5E},
{0xC2E9, 0x01},
{0xC2EA, 0x7A},
{0xC2EB, 0x90},
{0xC2ED, 0x00},
{0xC2EE, 0x7A},
{0xC2EF, 0x64},
{0xC308, 0x00},
{0xC309, 0x00},
{0xC30A, 0x00},
{0xC30C, 0x00},
{0xC30D, 0x01},
{0xC30E, 0x00},
{0xC30F, 0x00},
{0xC310, 0x01},
{0xC311, 0x60},
{0xC312, 0xFF},
{0xC313, 0x08},
{0xC314, 0x01},
{0xC315, 0x00}, /* min saturation gain */
{0xC316, 0xFF}, /* max saturation gain */
{0xC317, 0x0B},
{0xC318, 0x00},
{0xC319, 0x0C},
{0xC31A, 0x00},
{0xC31B, 0xE0},
{0xC31C, 0x00},
{0xC31D, 0x14},
{0xC31E, 0x00},
{0xC31F, 0xC5},
{0xC320, 0xFF},
{0xC321, 0x4B},
{0xC322, 0xFF},
{0xC323, 0xF0},
{0xC324, 0xFF},
{0xC325, 0xE8},
{0xC326, 0x00},
{0xC327, 0x46},
{0xC328, 0xFF},
{0xC329, 0xD2},
{0xC32A, 0xFF},
{0xC32B, 0xE4},
{0xC32C, 0xFF},
{0xC32D, 0xBB},
{0xC32E, 0x00},
{0xC32F, 0x61},
{0xC330, 0xFF},
{0xC331, 0xF9},
{0xC332, 0x00},
{0xC333, 0xD9},
{0xC334, 0x00},
{0xC335, 0x2E},
{0xC336, 0x00},
{0xC337, 0xB1},
{0xC338, 0xFF},
{0xC339, 0x64},
{0xC33A, 0xFF},
{0xC33B, 0xEB},
{0xC33C, 0xFF},
{0xC33D, 0xE8},
{0xC33E, 0x00},
{0xC33F, 0x48},
{0xC340, 0xFF},
{0xC341, 0xD0},
{0xC342, 0xFF},
{0xC343, 0xED},
{0xC344, 0xFF},
{0xC345, 0xAD},
{0xC346, 0x00},
{0xC347, 0x66},
{0xC348, 0x01},
{0xC349, 0x00},
{0x6700, 0x04},
{0x6701, 0x7B},
{0x6702, 0xFD},
{0x6703, 0xF9},
{0x6704, 0x3D},
{0x6705, 0x71},
{0x6706, 0x78},
{0x6708, 0x05},
{0x6F06, 0x6F},
{0x6F07, 0x00},
{0x6F0A, 0x6F},
{0x6F0B, 0x00},
{0x6F00, 0x03},
{0xC34C, 0x01},
{0xC34D, 0x00},
{0xC34E, 0x46},
{0xC34F, 0x55},
{0xC350, 0x00},
{0xC351, 0x40},
{0xC352, 0x00},
{0xC353, 0xFF},
{0xC354, 0x04},
{0xC355, 0x08},
{0xC356, 0x01},
{0xC357, 0xEF},
{0xC358, 0x30},
{0xC359, 0x01},
{0xC35A, 0x64},
{0xC35B, 0x46},
{0xC35C, 0x00},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0x3042, 0xF0},
{0xC261, 0x01},
{0x301B, 0xF0},
{0x301C, 0xF0},
{0x301A, 0xF0},
{0x6F00, 0xC3},
{0xC46A, 0x30},
{0xC46D, 0x20},
{0xC464, 0x84},
{0xC465, 0x00},
{0x6F00, 0x03},
{0x6F00, 0x43},
{0x381C, 0x00},
{0x381D, 0x40},
{0xC454, 0x01},
{0x6F00, 0xC3},
{0xC454, 0x00},
{0xC4B1, 0x02},
{0xC4B2, 0x01},
{0xC4B3, 0x03},
{0x6F00, 0x03},
{0x6F00, 0x43},
/* enable FSIN (FRAMESYNC input) functionality */
{0x3832, (0x0d+2*0x20+0x15+38) >> 8},
{0x3833, (0x0d+2*0x20+0x15+38) & 0xff},
{0x3834, OV10635_VTS >> 8},
{0x3835, OV10635_VTS & 0xff},
{0x302E, 0x01},
};

static const struct ov10635_reg ov10635_regs_30fps[] = {
/* disable clocks */
{0x301b, 0xff},
{0x301c, 0xff},
{0x301a, 0xff},
/* clk = 24Mhz/2*32/2(1+1)=96Mhz, 30fps */
{0x3003, 0x20},
{0x3004, 0x21},
/* enable clocks */
{0x301b, 0xf0},
{0x301c, 0xf0},
{0x301a, 0xf0},
};

static const struct ov10635_reg ov10635_regs_15fps[] = {
/* disable clocks */
{0x301b, 0xff},
{0x301c, 0xff},
{0x301a, 0xff},
/* clk = 24Mhz/2*32/2(1+3)=48Mhz, 15fps */
{0x3003, 0x20},
{0x3004, 0x23},
/* enable clocks */
{0x301b, 0xf0},
{0x301c, 0xf0},
{0x301a, 0xf0},
};

static const struct ov10635_reg ov10635_regs_10fps[] = {
/* disable clocks */
{0x301b, 0xff},
{0x301c, 0xff},
{0x301a, 0xff},
/* clk = 24Mhz/2*32/2(1+5)=32Mhz, 10fps */
{0x3003, 0x20},
{0x3004, 0x25},
/* enable clocks */
{0x301b, 0xf0},
{0x301c, 0xf0},
{0x301a, 0xf0},
};

static const struct ov10635_reg ov10635_regs_5fps[] = {
/* disable clocks */
{0x301b, 0xff},
{0x301c, 0xff},
{0x301a, 0xff},
/* clk = 24Mhz/4*32/2(1+5)=96Mhz, 5fps */
{0x3003, 0x20},
{0x3004, 0x45},
/* enable clocks */
{0x301b, 0xf0},
{0x301c, 0xf0},
{0x301a, 0xf0},
};

static const struct ov10635_reg ov10635_regs_contrast[5][18] = {
{
	{0x6f00, 0xc3},
	{0xc4e4, 0x20},
	{0xc4e5, 0x40},
	{0xc4e6, 0x60},
	{0xc4e7, 0x80},
	{0xc4e8, 0xa0},
	{0xc4e9, 0xb4},
	{0xc4ea, 0xc0},
	{0xc4eb, 0xcb},
	{0xc4ec, 0xd5},
	{0xc4ed, 0xde},
	{0xc4ee, 0xe6},
	{0xc4ef, 0xed},
	{0xc4f0, 0xf3},
	{0xc4f1, 0xf8},
	{0xc4f2, 0xfc},
	{0x6f00, 0x03},
	{0x6f00, 0x43},
}, {
	{0x6f00, 0xc3},
	{0xc4e4, 0x18},
	{0xc4e5, 0x30},
	{0xc4e6, 0x48},
	{0xc4e7, 0x60},
	{0xc4e8, 0x78},
	{0xc4e9, 0x90},
	{0xc4ea, 0xa4},
	{0xc4eb, 0xb4},
	{0xc4ec, 0xc2},
	{0xc4ed, 0xcf},
	{0xc4ee, 0xdb},
	{0xc4ef, 0xe5},
	{0xc4f0, 0xee},
	{0xc4f1, 0xf6},
	{0xc4f2, 0xfc},
	{0x6f00, 0x03},
	{0x6f00, 0x43},
}, {
	{0x6f00, 0xc3},
	{0xc4e4, 0x10},
	{0xc4e5, 0x20},
	{0xc4e6, 0x30},
	{0xc4e7, 0x40},
	{0xc4e8, 0x50},
	{0xc4e9, 0x60},
	{0xc4ea, 0x70},
	{0xc4eb, 0x80},
	{0xc4ec, 0x90},
	{0xc4ed, 0xa0},
	{0xc4ee, 0xb0},
	{0xc4ef, 0xc0},
	{0xc4f0, 0xd0},
	{0xc4f1, 0xe0},
	{0xc4f2, 0xf0},
	{0x6f00, 0x03},
	{0x6f00, 0x43},
}, {
	{0x6f00, 0xc3},
	{0xc4e4, 0x0c},
	{0xc4e5, 0x18},
	{0xc4e6, 0x24},
	{0xc4e7, 0x30},
	{0xc4e8, 0x3c},
	{0xc4e9, 0x48},
	{0xc4ea, 0x54},
	{0xc4eb, 0x62},
	{0xc4ec, 0x72},
	{0xc4ed, 0x84},
	{0xc4ee, 0x94},
	{0xc4ef, 0xa6},
	{0xc4f0, 0xb9},
	{0xc4f1, 0xcd},
	{0xc4f2, 0xe2},
	{0x6f00, 0x03},
	{0x6f00, 0x43},
}, {
	{0x6f00, 0xc3},
	{0xc4e4, 0x06},
	{0xc4e5, 0x0d},
	{0xc4e6, 0x15},
	{0xc4e7, 0x1e},
	{0xc4e8, 0x28},
	{0xc4e9, 0x32},
	{0xc4ea, 0x3c},
	{0xc4eb, 0x48},
	{0xc4ec, 0x56},
	{0xc4ed, 0x66},
	{0xc4ee, 0x78},
	{0xc4ef, 0x8c},
	{0xc4f0, 0xa2},
	{0xc4f1, 0xba},
	{0xc4f2, 0xd4},
	{0x6f00, 0x03},
	{0x6f00, 0x43},
}
};
