Match using Linux Socket Filter. Expects a path to an eBPF object or a cBPF
program in decimal format.
.TP
\fB\-\-object\-pinned\fP \fIpath\fP
Pass a path to a pinned eBPF object.
.PP
Applications load eBPF programs into the kernel with the bpf() system call and
BPF_PROG_LOAD command and can pin them in a virtual filesystem with BPF_OBJ_PIN.
To use a pinned object in iptables, mount the bpf filesystem using
.IP
mount \-t bpf bpf ${BPF_MOUNT}
.PP
then insert the filter in iptables by path:
.IP
iptables \-A OUTPUT \-m bpf \-\-object\-pinned ${BPF_MOUNT}/{PINNED_PATH} \-j ACCEPT
.TP
\fB\-\-bytecode\fP \fIcode\fP
Pass the BPF byte code format as generated by the \fBnfbpf_compile\fP utility.
.PP
The code format is similar to the output of the tcpdump -ddd command: one line
that stores the number of instructions, followed by one line for each
instruction. Instruction lines follow the pattern 'u16 u8 u8 u32' in decimal
notation. Fields encode the operation, jump offset if true, jump offset if
false and generic multiuse field 'K'. Comments are not supported.
.PP
For example, to read only packets matching 'ip proto 6', insert the following,
without the comments or trailing whitespace:
.IP
4               # number of instructions
.br
48 0 0 9        # load byte  ip->proto
.br
21 0 1 6        # jump equal IPPROTO_TCP
.br
6 0 0 1         # return     pass (non-zero)
.br
6 0 0 0         # return     fail (zero)
.PP
You can pass this filter to the bpf match with the following command:
.IP
iptables \-A OUTPUT \-m bpf \-\-bytecode '4,48 0 0 9,21 0 1 6,6 0 0 1,6 0 0 0' \-j ACCEPT
.PP
Or instead, you can invoke the nfbpf_compile utility.
.IP
iptables \-A OUTPUT \-m bpf \-\-bytecode "`nfbpf_compile RAW 'ip proto 6'`" \-j ACCEPT
.PP
Or use tcpdump -ddd. In that case, generate BPF targeting a device with the
same data link type as the xtables match. Iptables passes packets from the
network layer up, without mac layer. Select a device with data link type RAW,
such as a tun device:
.IP
ip tuntap add tun0 mode tun
.br
ip link set tun0 up
.br
tcpdump -ddd -i tun0 ip proto 6
.PP
See tcpdump -L -i $dev for a list of known data link types for a given device.
.PP
You may want to learn more about BPF from FreeBSD's bpf(4) manpage.
