// Copyright 2014 the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


Debug = debug.Debug;

function dummy(x) {
  return x + 100;
}

function create_closure() {
  var f = function(arg) {
    if (arg) { %DeoptimizeFunction(f); }
    var a = Array(10);
    for (var i = 0; i < a.length; i++) {
      a[i] = i;
    }
  }
  return f;
}

var c = create_closure();
c();

// c CallIC state now has custom Array handler installed.

// Turn on the debugger.
Debug.setListener(function () {});

var d = create_closure();
%PrepareFunctionForOptimization(d);
%OptimizeFunctionOnNextCall(d);
// Thanks to the debugger, we recreate the full code too. We deopt and run
// it, stomping on the unexpected AllocationSite in the type vector slot.
d(true);

// CallIC in c misinterprets type vector slot contents as an AllocationSite,
// corrupting the heap.
c();

// CallIC MISS - crash due to corruption.
dummy();
