/* $Id:  $ */
/** @file
 * Autogenerate symbol mangling header for openssl.
 */

/*
 * Copyright (C) 2011-2019 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 *
 * The contents of this file may alternatively be used under the terms
 * of the Common Development and Distribution License Version 1.0
 * (CDDL) only, as it comes in the "COPYING.CDDL" file of the
 * VirtualBox OSE distribution, in which case the provisions of the
 * CDDL are applicable instead of those of the GPL.
 *
 * You may elect to license modified versions of this file under the
 * terms and conditions of either the GPL or the CDDL or both.
 */

#ifndef ___openssl_mangling_h___
#define ___openssl_mangling_h___
# ifdef VBOX_IN_EXTPACK
#  define OPENSSL_MANGLER(a_Name) OracleExtPack_ ## a_Name
#  define OPENSSL_MANGLER_ASM(a_Name) _OracleExtPack_ ## a_Name
# else
#  define OPENSSL_MANGLER(a_Name) VBox_ ## a_Name
#  define OPENSSL_MANGLER_ASM(a_Name) _VBox_ ## a_Name
# endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef a2d_ASN1_OBJECT
#  define a2d_ASN1_OBJECT OPENSSL_MANGLER(a2d_ASN1_OBJECT)
# endif
#else
# ifndef _a2d_ASN1_OBJECT
#  define _a2d_ASN1_OBJECT OPENSSL_MANGLER_ASM(a2d_ASN1_OBJECT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef a2i_ASN1_ENUMERATED
#  define a2i_ASN1_ENUMERATED OPENSSL_MANGLER(a2i_ASN1_ENUMERATED)
# endif
#else
# ifndef _a2i_ASN1_ENUMERATED
#  define _a2i_ASN1_ENUMERATED OPENSSL_MANGLER_ASM(a2i_ASN1_ENUMERATED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef a2i_ASN1_INTEGER
#  define a2i_ASN1_INTEGER OPENSSL_MANGLER(a2i_ASN1_INTEGER)
# endif
#else
# ifndef _a2i_ASN1_INTEGER
#  define _a2i_ASN1_INTEGER OPENSSL_MANGLER_ASM(a2i_ASN1_INTEGER)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef a2i_ASN1_STRING
#  define a2i_ASN1_STRING OPENSSL_MANGLER(a2i_ASN1_STRING)
# endif
#else
# ifndef _a2i_ASN1_STRING
#  define _a2i_ASN1_STRING OPENSSL_MANGLER_ASM(a2i_ASN1_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef a2i_GENERAL_NAME
#  define a2i_GENERAL_NAME OPENSSL_MANGLER(a2i_GENERAL_NAME)
# endif
#else
# ifndef _a2i_GENERAL_NAME
#  define _a2i_GENERAL_NAME OPENSSL_MANGLER_ASM(a2i_GENERAL_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef a2i_ipadd
#  define a2i_ipadd OPENSSL_MANGLER(a2i_ipadd)
# endif
#else
# ifndef _a2i_ipadd
#  define _a2i_ipadd OPENSSL_MANGLER_ASM(a2i_ipadd)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef a2i_IPADDRESS
#  define a2i_IPADDRESS OPENSSL_MANGLER(a2i_IPADDRESS)
# endif
#else
# ifndef _a2i_IPADDRESS
#  define _a2i_IPADDRESS OPENSSL_MANGLER_ASM(a2i_IPADDRESS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef a2i_IPADDRESS_NC
#  define a2i_IPADDRESS_NC OPENSSL_MANGLER(a2i_IPADDRESS_NC)
# endif
#else
# ifndef _a2i_IPADDRESS_NC
#  define _a2i_IPADDRESS_NC OPENSSL_MANGLER_ASM(a2i_IPADDRESS_NC)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ACCESS_DESCRIPTION_free
#  define ACCESS_DESCRIPTION_free OPENSSL_MANGLER(ACCESS_DESCRIPTION_free)
# endif
#else
# ifndef _ACCESS_DESCRIPTION_free
#  define _ACCESS_DESCRIPTION_free OPENSSL_MANGLER_ASM(ACCESS_DESCRIPTION_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ACCESS_DESCRIPTION_it
#  define ACCESS_DESCRIPTION_it OPENSSL_MANGLER(ACCESS_DESCRIPTION_it)
# endif
#else
# ifndef _ACCESS_DESCRIPTION_it
#  define _ACCESS_DESCRIPTION_it OPENSSL_MANGLER_ASM(ACCESS_DESCRIPTION_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ACCESS_DESCRIPTION_new
#  define ACCESS_DESCRIPTION_new OPENSSL_MANGLER(ACCESS_DESCRIPTION_new)
# endif
#else
# ifndef _ACCESS_DESCRIPTION_new
#  define _ACCESS_DESCRIPTION_new OPENSSL_MANGLER_ASM(ACCESS_DESCRIPTION_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSIONS_free
#  define ADMISSIONS_free OPENSSL_MANGLER(ADMISSIONS_free)
# endif
#else
# ifndef _ADMISSIONS_free
#  define _ADMISSIONS_free OPENSSL_MANGLER_ASM(ADMISSIONS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSIONS_get0_admissionAuthority
#  define ADMISSIONS_get0_admissionAuthority OPENSSL_MANGLER(ADMISSIONS_get0_admissionAuthority)
# endif
#else
# ifndef _ADMISSIONS_get0_admissionAuthority
#  define _ADMISSIONS_get0_admissionAuthority OPENSSL_MANGLER_ASM(ADMISSIONS_get0_admissionAuthority)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSIONS_get0_namingAuthority
#  define ADMISSIONS_get0_namingAuthority OPENSSL_MANGLER(ADMISSIONS_get0_namingAuthority)
# endif
#else
# ifndef _ADMISSIONS_get0_namingAuthority
#  define _ADMISSIONS_get0_namingAuthority OPENSSL_MANGLER_ASM(ADMISSIONS_get0_namingAuthority)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSIONS_get0_professionInfos
#  define ADMISSIONS_get0_professionInfos OPENSSL_MANGLER(ADMISSIONS_get0_professionInfos)
# endif
#else
# ifndef _ADMISSIONS_get0_professionInfos
#  define _ADMISSIONS_get0_professionInfos OPENSSL_MANGLER_ASM(ADMISSIONS_get0_professionInfos)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSIONS_it
#  define ADMISSIONS_it OPENSSL_MANGLER(ADMISSIONS_it)
# endif
#else
# ifndef _ADMISSIONS_it
#  define _ADMISSIONS_it OPENSSL_MANGLER_ASM(ADMISSIONS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSIONS_new
#  define ADMISSIONS_new OPENSSL_MANGLER(ADMISSIONS_new)
# endif
#else
# ifndef _ADMISSIONS_new
#  define _ADMISSIONS_new OPENSSL_MANGLER_ASM(ADMISSIONS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSIONS_set0_admissionAuthority
#  define ADMISSIONS_set0_admissionAuthority OPENSSL_MANGLER(ADMISSIONS_set0_admissionAuthority)
# endif
#else
# ifndef _ADMISSIONS_set0_admissionAuthority
#  define _ADMISSIONS_set0_admissionAuthority OPENSSL_MANGLER_ASM(ADMISSIONS_set0_admissionAuthority)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSIONS_set0_namingAuthority
#  define ADMISSIONS_set0_namingAuthority OPENSSL_MANGLER(ADMISSIONS_set0_namingAuthority)
# endif
#else
# ifndef _ADMISSIONS_set0_namingAuthority
#  define _ADMISSIONS_set0_namingAuthority OPENSSL_MANGLER_ASM(ADMISSIONS_set0_namingAuthority)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSIONS_set0_professionInfos
#  define ADMISSIONS_set0_professionInfos OPENSSL_MANGLER(ADMISSIONS_set0_professionInfos)
# endif
#else
# ifndef _ADMISSIONS_set0_professionInfos
#  define _ADMISSIONS_set0_professionInfos OPENSSL_MANGLER_ASM(ADMISSIONS_set0_professionInfos)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSION_SYNTAX_free
#  define ADMISSION_SYNTAX_free OPENSSL_MANGLER(ADMISSION_SYNTAX_free)
# endif
#else
# ifndef _ADMISSION_SYNTAX_free
#  define _ADMISSION_SYNTAX_free OPENSSL_MANGLER_ASM(ADMISSION_SYNTAX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSION_SYNTAX_get0_admissionAuthority
#  define ADMISSION_SYNTAX_get0_admissionAuthority OPENSSL_MANGLER(ADMISSION_SYNTAX_get0_admissionAuthority)
# endif
#else
# ifndef _ADMISSION_SYNTAX_get0_admissionAuthority
#  define _ADMISSION_SYNTAX_get0_admissionAuthority OPENSSL_MANGLER_ASM(ADMISSION_SYNTAX_get0_admissionAuthority)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSION_SYNTAX_get0_contentsOfAdmissions
#  define ADMISSION_SYNTAX_get0_contentsOfAdmissions OPENSSL_MANGLER(ADMISSION_SYNTAX_get0_contentsOfAdmissions)
# endif
#else
# ifndef _ADMISSION_SYNTAX_get0_contentsOfAdmissions
#  define _ADMISSION_SYNTAX_get0_contentsOfAdmissions OPENSSL_MANGLER_ASM(ADMISSION_SYNTAX_get0_contentsOfAdmissions)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSION_SYNTAX_it
#  define ADMISSION_SYNTAX_it OPENSSL_MANGLER(ADMISSION_SYNTAX_it)
# endif
#else
# ifndef _ADMISSION_SYNTAX_it
#  define _ADMISSION_SYNTAX_it OPENSSL_MANGLER_ASM(ADMISSION_SYNTAX_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSION_SYNTAX_new
#  define ADMISSION_SYNTAX_new OPENSSL_MANGLER(ADMISSION_SYNTAX_new)
# endif
#else
# ifndef _ADMISSION_SYNTAX_new
#  define _ADMISSION_SYNTAX_new OPENSSL_MANGLER_ASM(ADMISSION_SYNTAX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSION_SYNTAX_set0_admissionAuthority
#  define ADMISSION_SYNTAX_set0_admissionAuthority OPENSSL_MANGLER(ADMISSION_SYNTAX_set0_admissionAuthority)
# endif
#else
# ifndef _ADMISSION_SYNTAX_set0_admissionAuthority
#  define _ADMISSION_SYNTAX_set0_admissionAuthority OPENSSL_MANGLER_ASM(ADMISSION_SYNTAX_set0_admissionAuthority)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ADMISSION_SYNTAX_set0_contentsOfAdmissions
#  define ADMISSION_SYNTAX_set0_contentsOfAdmissions OPENSSL_MANGLER(ADMISSION_SYNTAX_set0_contentsOfAdmissions)
# endif
#else
# ifndef _ADMISSION_SYNTAX_set0_contentsOfAdmissions
#  define _ADMISSION_SYNTAX_set0_contentsOfAdmissions OPENSSL_MANGLER_ASM(ADMISSION_SYNTAX_set0_contentsOfAdmissions)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_bi_ige_encrypt
#  define AES_bi_ige_encrypt OPENSSL_MANGLER(AES_bi_ige_encrypt)
# endif
#else
# ifndef _AES_bi_ige_encrypt
#  define _AES_bi_ige_encrypt OPENSSL_MANGLER_ASM(AES_bi_ige_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_cbc_encrypt
#  define AES_cbc_encrypt OPENSSL_MANGLER(AES_cbc_encrypt)
# endif
#else
# ifndef _AES_cbc_encrypt
#  define _AES_cbc_encrypt OPENSSL_MANGLER_ASM(AES_cbc_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_cfb128_encrypt
#  define AES_cfb128_encrypt OPENSSL_MANGLER(AES_cfb128_encrypt)
# endif
#else
# ifndef _AES_cfb128_encrypt
#  define _AES_cfb128_encrypt OPENSSL_MANGLER_ASM(AES_cfb128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_cfb1_encrypt
#  define AES_cfb1_encrypt OPENSSL_MANGLER(AES_cfb1_encrypt)
# endif
#else
# ifndef _AES_cfb1_encrypt
#  define _AES_cfb1_encrypt OPENSSL_MANGLER_ASM(AES_cfb1_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_cfb8_encrypt
#  define AES_cfb8_encrypt OPENSSL_MANGLER(AES_cfb8_encrypt)
# endif
#else
# ifndef _AES_cfb8_encrypt
#  define _AES_cfb8_encrypt OPENSSL_MANGLER_ASM(AES_cfb8_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_decrypt
#  define AES_decrypt OPENSSL_MANGLER(AES_decrypt)
# endif
#else
# ifndef _AES_decrypt
#  define _AES_decrypt OPENSSL_MANGLER_ASM(AES_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_ecb_encrypt
#  define AES_ecb_encrypt OPENSSL_MANGLER(AES_ecb_encrypt)
# endif
#else
# ifndef _AES_ecb_encrypt
#  define _AES_ecb_encrypt OPENSSL_MANGLER_ASM(AES_ecb_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_encrypt
#  define AES_encrypt OPENSSL_MANGLER(AES_encrypt)
# endif
#else
# ifndef _AES_encrypt
#  define _AES_encrypt OPENSSL_MANGLER_ASM(AES_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_ige_encrypt
#  define AES_ige_encrypt OPENSSL_MANGLER(AES_ige_encrypt)
# endif
#else
# ifndef _AES_ige_encrypt
#  define _AES_ige_encrypt OPENSSL_MANGLER_ASM(AES_ige_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_cbc_encrypt
#  define aesni_cbc_encrypt OPENSSL_MANGLER(aesni_cbc_encrypt)
# endif
#else
# ifndef _aesni_cbc_encrypt
#  define _aesni_cbc_encrypt OPENSSL_MANGLER_ASM(aesni_cbc_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_cbc_sha1_enc
#  define aesni_cbc_sha1_enc OPENSSL_MANGLER(aesni_cbc_sha1_enc)
# endif
#else
# ifndef _aesni_cbc_sha1_enc
#  define _aesni_cbc_sha1_enc OPENSSL_MANGLER_ASM(aesni_cbc_sha1_enc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_cbc_sha256_enc
#  define aesni_cbc_sha256_enc OPENSSL_MANGLER(aesni_cbc_sha256_enc)
# endif
#else
# ifndef _aesni_cbc_sha256_enc
#  define _aesni_cbc_sha256_enc OPENSSL_MANGLER_ASM(aesni_cbc_sha256_enc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_ccm64_decrypt_blocks
#  define aesni_ccm64_decrypt_blocks OPENSSL_MANGLER(aesni_ccm64_decrypt_blocks)
# endif
#else
# ifndef _aesni_ccm64_decrypt_blocks
#  define _aesni_ccm64_decrypt_blocks OPENSSL_MANGLER_ASM(aesni_ccm64_decrypt_blocks)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_ccm64_encrypt_blocks
#  define aesni_ccm64_encrypt_blocks OPENSSL_MANGLER(aesni_ccm64_encrypt_blocks)
# endif
#else
# ifndef _aesni_ccm64_encrypt_blocks
#  define _aesni_ccm64_encrypt_blocks OPENSSL_MANGLER_ASM(aesni_ccm64_encrypt_blocks)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_ctr32_encrypt_blocks
#  define aesni_ctr32_encrypt_blocks OPENSSL_MANGLER(aesni_ctr32_encrypt_blocks)
# endif
#else
# ifndef _aesni_ctr32_encrypt_blocks
#  define _aesni_ctr32_encrypt_blocks OPENSSL_MANGLER_ASM(aesni_ctr32_encrypt_blocks)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_decrypt
#  define aesni_decrypt OPENSSL_MANGLER(aesni_decrypt)
# endif
#else
# ifndef _aesni_decrypt
#  define _aesni_decrypt OPENSSL_MANGLER_ASM(aesni_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_ecb_encrypt
#  define aesni_ecb_encrypt OPENSSL_MANGLER(aesni_ecb_encrypt)
# endif
#else
# ifndef _aesni_ecb_encrypt
#  define _aesni_ecb_encrypt OPENSSL_MANGLER_ASM(aesni_ecb_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_encrypt
#  define aesni_encrypt OPENSSL_MANGLER(aesni_encrypt)
# endif
#else
# ifndef _aesni_encrypt
#  define _aesni_encrypt OPENSSL_MANGLER_ASM(aesni_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_gcm_decrypt
#  define aesni_gcm_decrypt OPENSSL_MANGLER(aesni_gcm_decrypt)
# endif
#else
# ifndef _aesni_gcm_decrypt
#  define _aesni_gcm_decrypt OPENSSL_MANGLER_ASM(aesni_gcm_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_gcm_encrypt
#  define aesni_gcm_encrypt OPENSSL_MANGLER(aesni_gcm_encrypt)
# endif
#else
# ifndef _aesni_gcm_encrypt
#  define _aesni_gcm_encrypt OPENSSL_MANGLER_ASM(aesni_gcm_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_multi_cbc_decrypt
#  define aesni_multi_cbc_decrypt OPENSSL_MANGLER(aesni_multi_cbc_decrypt)
# endif
#else
# ifndef _aesni_multi_cbc_decrypt
#  define _aesni_multi_cbc_decrypt OPENSSL_MANGLER_ASM(aesni_multi_cbc_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_multi_cbc_encrypt
#  define aesni_multi_cbc_encrypt OPENSSL_MANGLER(aesni_multi_cbc_encrypt)
# endif
#else
# ifndef _aesni_multi_cbc_encrypt
#  define _aesni_multi_cbc_encrypt OPENSSL_MANGLER_ASM(aesni_multi_cbc_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_ocb_decrypt
#  define aesni_ocb_decrypt OPENSSL_MANGLER(aesni_ocb_decrypt)
# endif
#else
# ifndef _aesni_ocb_decrypt
#  define _aesni_ocb_decrypt OPENSSL_MANGLER_ASM(aesni_ocb_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_ocb_encrypt
#  define aesni_ocb_encrypt OPENSSL_MANGLER(aesni_ocb_encrypt)
# endif
#else
# ifndef _aesni_ocb_encrypt
#  define _aesni_ocb_encrypt OPENSSL_MANGLER_ASM(aesni_ocb_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_set_decrypt_key
#  define aesni_set_decrypt_key OPENSSL_MANGLER(aesni_set_decrypt_key)
# endif
#else
# ifndef _aesni_set_decrypt_key
#  define _aesni_set_decrypt_key OPENSSL_MANGLER_ASM(aesni_set_decrypt_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_set_encrypt_key
#  define aesni_set_encrypt_key OPENSSL_MANGLER(aesni_set_encrypt_key)
# endif
#else
# ifndef _aesni_set_encrypt_key
#  define _aesni_set_encrypt_key OPENSSL_MANGLER_ASM(aesni_set_encrypt_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_xts_decrypt
#  define aesni_xts_decrypt OPENSSL_MANGLER(aesni_xts_decrypt)
# endif
#else
# ifndef _aesni_xts_decrypt
#  define _aesni_xts_decrypt OPENSSL_MANGLER_ASM(aesni_xts_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aesni_xts_encrypt
#  define aesni_xts_encrypt OPENSSL_MANGLER(aesni_xts_encrypt)
# endif
#else
# ifndef _aesni_xts_encrypt
#  define _aesni_xts_encrypt OPENSSL_MANGLER_ASM(aesni_xts_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_ofb128_encrypt
#  define AES_ofb128_encrypt OPENSSL_MANGLER(AES_ofb128_encrypt)
# endif
#else
# ifndef _AES_ofb128_encrypt
#  define _AES_ofb128_encrypt OPENSSL_MANGLER_ASM(AES_ofb128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_options
#  define AES_options OPENSSL_MANGLER(AES_options)
# endif
#else
# ifndef _AES_options
#  define _AES_options OPENSSL_MANGLER_ASM(AES_options)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_set_decrypt_key
#  define AES_set_decrypt_key OPENSSL_MANGLER(AES_set_decrypt_key)
# endif
#else
# ifndef _AES_set_decrypt_key
#  define _AES_set_decrypt_key OPENSSL_MANGLER_ASM(AES_set_decrypt_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_set_encrypt_key
#  define AES_set_encrypt_key OPENSSL_MANGLER(AES_set_encrypt_key)
# endif
#else
# ifndef _AES_set_encrypt_key
#  define _AES_set_encrypt_key OPENSSL_MANGLER_ASM(AES_set_encrypt_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_unwrap_key
#  define AES_unwrap_key OPENSSL_MANGLER(AES_unwrap_key)
# endif
#else
# ifndef _AES_unwrap_key
#  define _AES_unwrap_key OPENSSL_MANGLER_ASM(AES_unwrap_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AES_wrap_key
#  define AES_wrap_key OPENSSL_MANGLER(AES_wrap_key)
# endif
#else
# ifndef _AES_wrap_key
#  define _AES_wrap_key OPENSSL_MANGLER_ASM(AES_wrap_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aria_encrypt
#  define aria_encrypt OPENSSL_MANGLER(aria_encrypt)
# endif
#else
# ifndef _aria_encrypt
#  define _aria_encrypt OPENSSL_MANGLER_ASM(aria_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aria_set_decrypt_key
#  define aria_set_decrypt_key OPENSSL_MANGLER(aria_set_decrypt_key)
# endif
#else
# ifndef _aria_set_decrypt_key
#  define _aria_set_decrypt_key OPENSSL_MANGLER_ASM(aria_set_decrypt_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef aria_set_encrypt_key
#  define aria_set_encrypt_key OPENSSL_MANGLER(aria_set_encrypt_key)
# endif
#else
# ifndef _aria_set_encrypt_key
#  define _aria_set_encrypt_key OPENSSL_MANGLER_ASM(aria_set_encrypt_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASIdentifierChoice_free
#  define ASIdentifierChoice_free OPENSSL_MANGLER(ASIdentifierChoice_free)
# endif
#else
# ifndef _ASIdentifierChoice_free
#  define _ASIdentifierChoice_free OPENSSL_MANGLER_ASM(ASIdentifierChoice_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASIdentifierChoice_it
#  define ASIdentifierChoice_it OPENSSL_MANGLER(ASIdentifierChoice_it)
# endif
#else
# ifndef _ASIdentifierChoice_it
#  define _ASIdentifierChoice_it OPENSSL_MANGLER_ASM(ASIdentifierChoice_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASIdentifierChoice_new
#  define ASIdentifierChoice_new OPENSSL_MANGLER(ASIdentifierChoice_new)
# endif
#else
# ifndef _ASIdentifierChoice_new
#  define _ASIdentifierChoice_new OPENSSL_MANGLER_ASM(ASIdentifierChoice_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASIdentifiers_free
#  define ASIdentifiers_free OPENSSL_MANGLER(ASIdentifiers_free)
# endif
#else
# ifndef _ASIdentifiers_free
#  define _ASIdentifiers_free OPENSSL_MANGLER_ASM(ASIdentifiers_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASIdentifiers_it
#  define ASIdentifiers_it OPENSSL_MANGLER(ASIdentifiers_it)
# endif
#else
# ifndef _ASIdentifiers_it
#  define _ASIdentifiers_it OPENSSL_MANGLER_ASM(ASIdentifiers_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASIdentifiers_new
#  define ASIdentifiers_new OPENSSL_MANGLER(ASIdentifiers_new)
# endif
#else
# ifndef _ASIdentifiers_new
#  define _ASIdentifiers_new OPENSSL_MANGLER_ASM(ASIdentifiers_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASIdOrRange_free
#  define ASIdOrRange_free OPENSSL_MANGLER(ASIdOrRange_free)
# endif
#else
# ifndef _ASIdOrRange_free
#  define _ASIdOrRange_free OPENSSL_MANGLER_ASM(ASIdOrRange_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASIdOrRange_it
#  define ASIdOrRange_it OPENSSL_MANGLER(ASIdOrRange_it)
# endif
#else
# ifndef _ASIdOrRange_it
#  define _ASIdOrRange_it OPENSSL_MANGLER_ASM(ASIdOrRange_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASIdOrRange_new
#  define ASIdOrRange_new OPENSSL_MANGLER(ASIdOrRange_new)
# endif
#else
# ifndef _ASIdOrRange_new
#  define _ASIdOrRange_new OPENSSL_MANGLER_ASM(ASIdOrRange_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asm_AES_cbc_encrypt
#  define asm_AES_cbc_encrypt OPENSSL_MANGLER(asm_AES_cbc_encrypt)
# endif
#else
# ifndef _asm_AES_cbc_encrypt
#  define _asm_AES_cbc_encrypt OPENSSL_MANGLER_ASM(asm_AES_cbc_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asm_AES_decrypt
#  define asm_AES_decrypt OPENSSL_MANGLER(asm_AES_decrypt)
# endif
#else
# ifndef _asm_AES_decrypt
#  define _asm_AES_decrypt OPENSSL_MANGLER_ASM(asm_AES_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asm_AES_encrypt
#  define asm_AES_encrypt OPENSSL_MANGLER(asm_AES_encrypt)
# endif
#else
# ifndef _asm_AES_encrypt
#  define _asm_AES_encrypt OPENSSL_MANGLER_ASM(asm_AES_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_add_oid_module
#  define ASN1_add_oid_module OPENSSL_MANGLER(ASN1_add_oid_module)
# endif
#else
# ifndef _ASN1_add_oid_module
#  define _ASN1_add_oid_module OPENSSL_MANGLER_ASM(ASN1_add_oid_module)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_add_stable_module
#  define ASN1_add_stable_module OPENSSL_MANGLER(ASN1_add_stable_module)
# endif
#else
# ifndef _ASN1_add_stable_module
#  define _ASN1_add_stable_module OPENSSL_MANGLER_ASM(ASN1_add_stable_module)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ANY_it
#  define ASN1_ANY_it OPENSSL_MANGLER(ASN1_ANY_it)
# endif
#else
# ifndef _ASN1_ANY_it
#  define _ASN1_ANY_it OPENSSL_MANGLER_ASM(ASN1_ANY_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BIT_STRING_check
#  define ASN1_BIT_STRING_check OPENSSL_MANGLER(ASN1_BIT_STRING_check)
# endif
#else
# ifndef _ASN1_BIT_STRING_check
#  define _ASN1_BIT_STRING_check OPENSSL_MANGLER_ASM(ASN1_BIT_STRING_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BIT_STRING_free
#  define ASN1_BIT_STRING_free OPENSSL_MANGLER(ASN1_BIT_STRING_free)
# endif
#else
# ifndef _ASN1_BIT_STRING_free
#  define _ASN1_BIT_STRING_free OPENSSL_MANGLER_ASM(ASN1_BIT_STRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BIT_STRING_get_bit
#  define ASN1_BIT_STRING_get_bit OPENSSL_MANGLER(ASN1_BIT_STRING_get_bit)
# endif
#else
# ifndef _ASN1_BIT_STRING_get_bit
#  define _ASN1_BIT_STRING_get_bit OPENSSL_MANGLER_ASM(ASN1_BIT_STRING_get_bit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BIT_STRING_it
#  define ASN1_BIT_STRING_it OPENSSL_MANGLER(ASN1_BIT_STRING_it)
# endif
#else
# ifndef _ASN1_BIT_STRING_it
#  define _ASN1_BIT_STRING_it OPENSSL_MANGLER_ASM(ASN1_BIT_STRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BIT_STRING_name_print
#  define ASN1_BIT_STRING_name_print OPENSSL_MANGLER(ASN1_BIT_STRING_name_print)
# endif
#else
# ifndef _ASN1_BIT_STRING_name_print
#  define _ASN1_BIT_STRING_name_print OPENSSL_MANGLER_ASM(ASN1_BIT_STRING_name_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BIT_STRING_new
#  define ASN1_BIT_STRING_new OPENSSL_MANGLER(ASN1_BIT_STRING_new)
# endif
#else
# ifndef _ASN1_BIT_STRING_new
#  define _ASN1_BIT_STRING_new OPENSSL_MANGLER_ASM(ASN1_BIT_STRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BIT_STRING_num_asc
#  define ASN1_BIT_STRING_num_asc OPENSSL_MANGLER(ASN1_BIT_STRING_num_asc)
# endif
#else
# ifndef _ASN1_BIT_STRING_num_asc
#  define _ASN1_BIT_STRING_num_asc OPENSSL_MANGLER_ASM(ASN1_BIT_STRING_num_asc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BIT_STRING_set
#  define ASN1_BIT_STRING_set OPENSSL_MANGLER(ASN1_BIT_STRING_set)
# endif
#else
# ifndef _ASN1_BIT_STRING_set
#  define _ASN1_BIT_STRING_set OPENSSL_MANGLER_ASM(ASN1_BIT_STRING_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BIT_STRING_set_asc
#  define ASN1_BIT_STRING_set_asc OPENSSL_MANGLER(ASN1_BIT_STRING_set_asc)
# endif
#else
# ifndef _ASN1_BIT_STRING_set_asc
#  define _ASN1_BIT_STRING_set_asc OPENSSL_MANGLER_ASM(ASN1_BIT_STRING_set_asc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BIT_STRING_set_bit
#  define ASN1_BIT_STRING_set_bit OPENSSL_MANGLER(ASN1_BIT_STRING_set_bit)
# endif
#else
# ifndef _ASN1_BIT_STRING_set_bit
#  define _ASN1_BIT_STRING_set_bit OPENSSL_MANGLER_ASM(ASN1_BIT_STRING_set_bit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BMPSTRING_free
#  define ASN1_BMPSTRING_free OPENSSL_MANGLER(ASN1_BMPSTRING_free)
# endif
#else
# ifndef _ASN1_BMPSTRING_free
#  define _ASN1_BMPSTRING_free OPENSSL_MANGLER_ASM(ASN1_BMPSTRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BMPSTRING_it
#  define ASN1_BMPSTRING_it OPENSSL_MANGLER(ASN1_BMPSTRING_it)
# endif
#else
# ifndef _ASN1_BMPSTRING_it
#  define _ASN1_BMPSTRING_it OPENSSL_MANGLER_ASM(ASN1_BMPSTRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BMPSTRING_new
#  define ASN1_BMPSTRING_new OPENSSL_MANGLER(ASN1_BMPSTRING_new)
# endif
#else
# ifndef _ASN1_BMPSTRING_new
#  define _ASN1_BMPSTRING_new OPENSSL_MANGLER_ASM(ASN1_BMPSTRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_bn_print
#  define ASN1_bn_print OPENSSL_MANGLER(ASN1_bn_print)
# endif
#else
# ifndef _ASN1_bn_print
#  define _ASN1_bn_print OPENSSL_MANGLER_ASM(ASN1_bn_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_BOOLEAN_it
#  define ASN1_BOOLEAN_it OPENSSL_MANGLER(ASN1_BOOLEAN_it)
# endif
#else
# ifndef _ASN1_BOOLEAN_it
#  define _ASN1_BOOLEAN_it OPENSSL_MANGLER_ASM(ASN1_BOOLEAN_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_buf_print
#  define ASN1_buf_print OPENSSL_MANGLER(ASN1_buf_print)
# endif
#else
# ifndef _ASN1_buf_print
#  define _ASN1_buf_print OPENSSL_MANGLER_ASM(ASN1_buf_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_check_infinite_end
#  define ASN1_check_infinite_end OPENSSL_MANGLER(ASN1_check_infinite_end)
# endif
#else
# ifndef _ASN1_check_infinite_end
#  define _ASN1_check_infinite_end OPENSSL_MANGLER_ASM(ASN1_check_infinite_end)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_const_check_infinite_end
#  define ASN1_const_check_infinite_end OPENSSL_MANGLER(ASN1_const_check_infinite_end)
# endif
#else
# ifndef _ASN1_const_check_infinite_end
#  define _ASN1_const_check_infinite_end OPENSSL_MANGLER_ASM(ASN1_const_check_infinite_end)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_d2i_bio
#  define ASN1_d2i_bio OPENSSL_MANGLER(ASN1_d2i_bio)
# endif
#else
# ifndef _ASN1_d2i_bio
#  define _ASN1_d2i_bio OPENSSL_MANGLER_ASM(ASN1_d2i_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_d2i_fp
#  define ASN1_d2i_fp OPENSSL_MANGLER(ASN1_d2i_fp)
# endif
#else
# ifndef _ASN1_d2i_fp
#  define _ASN1_d2i_fp OPENSSL_MANGLER_ASM(ASN1_d2i_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_d2i_read_bio
#  define asn1_d2i_read_bio OPENSSL_MANGLER(asn1_d2i_read_bio)
# endif
#else
# ifndef _asn1_d2i_read_bio
#  define _asn1_d2i_read_bio OPENSSL_MANGLER_ASM(asn1_d2i_read_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_digest
#  define ASN1_digest OPENSSL_MANGLER(ASN1_digest)
# endif
#else
# ifndef _ASN1_digest
#  define _ASN1_digest OPENSSL_MANGLER_ASM(ASN1_digest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_do_adb
#  define asn1_do_adb OPENSSL_MANGLER(asn1_do_adb)
# endif
#else
# ifndef _asn1_do_adb
#  define _asn1_do_adb OPENSSL_MANGLER_ASM(asn1_do_adb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_do_lock
#  define asn1_do_lock OPENSSL_MANGLER(asn1_do_lock)
# endif
#else
# ifndef _asn1_do_lock
#  define _asn1_do_lock OPENSSL_MANGLER_ASM(asn1_do_lock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_dup
#  define ASN1_dup OPENSSL_MANGLER(ASN1_dup)
# endif
#else
# ifndef _ASN1_dup
#  define _ASN1_dup OPENSSL_MANGLER_ASM(ASN1_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_enc_free
#  define asn1_enc_free OPENSSL_MANGLER(asn1_enc_free)
# endif
#else
# ifndef _asn1_enc_free
#  define _asn1_enc_free OPENSSL_MANGLER_ASM(asn1_enc_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_enc_init
#  define asn1_enc_init OPENSSL_MANGLER(asn1_enc_init)
# endif
#else
# ifndef _asn1_enc_init
#  define _asn1_enc_init OPENSSL_MANGLER_ASM(asn1_enc_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_enc_restore
#  define asn1_enc_restore OPENSSL_MANGLER(asn1_enc_restore)
# endif
#else
# ifndef _asn1_enc_restore
#  define _asn1_enc_restore OPENSSL_MANGLER_ASM(asn1_enc_restore)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_enc_save
#  define asn1_enc_save OPENSSL_MANGLER(asn1_enc_save)
# endif
#else
# ifndef _asn1_enc_save
#  define _asn1_enc_save OPENSSL_MANGLER_ASM(asn1_enc_save)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ENUMERATED_free
#  define ASN1_ENUMERATED_free OPENSSL_MANGLER(ASN1_ENUMERATED_free)
# endif
#else
# ifndef _ASN1_ENUMERATED_free
#  define _ASN1_ENUMERATED_free OPENSSL_MANGLER_ASM(ASN1_ENUMERATED_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ENUMERATED_get
#  define ASN1_ENUMERATED_get OPENSSL_MANGLER(ASN1_ENUMERATED_get)
# endif
#else
# ifndef _ASN1_ENUMERATED_get
#  define _ASN1_ENUMERATED_get OPENSSL_MANGLER_ASM(ASN1_ENUMERATED_get)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ENUMERATED_get_int64
#  define ASN1_ENUMERATED_get_int64 OPENSSL_MANGLER(ASN1_ENUMERATED_get_int64)
# endif
#else
# ifndef _ASN1_ENUMERATED_get_int64
#  define _ASN1_ENUMERATED_get_int64 OPENSSL_MANGLER_ASM(ASN1_ENUMERATED_get_int64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ENUMERATED_it
#  define ASN1_ENUMERATED_it OPENSSL_MANGLER(ASN1_ENUMERATED_it)
# endif
#else
# ifndef _ASN1_ENUMERATED_it
#  define _ASN1_ENUMERATED_it OPENSSL_MANGLER_ASM(ASN1_ENUMERATED_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ENUMERATED_new
#  define ASN1_ENUMERATED_new OPENSSL_MANGLER(ASN1_ENUMERATED_new)
# endif
#else
# ifndef _ASN1_ENUMERATED_new
#  define _ASN1_ENUMERATED_new OPENSSL_MANGLER_ASM(ASN1_ENUMERATED_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ENUMERATED_set
#  define ASN1_ENUMERATED_set OPENSSL_MANGLER(ASN1_ENUMERATED_set)
# endif
#else
# ifndef _ASN1_ENUMERATED_set
#  define _ASN1_ENUMERATED_set OPENSSL_MANGLER_ASM(ASN1_ENUMERATED_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ENUMERATED_set_int64
#  define ASN1_ENUMERATED_set_int64 OPENSSL_MANGLER(ASN1_ENUMERATED_set_int64)
# endif
#else
# ifndef _ASN1_ENUMERATED_set_int64
#  define _ASN1_ENUMERATED_set_int64 OPENSSL_MANGLER_ASM(ASN1_ENUMERATED_set_int64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ENUMERATED_to_BN
#  define ASN1_ENUMERATED_to_BN OPENSSL_MANGLER(ASN1_ENUMERATED_to_BN)
# endif
#else
# ifndef _ASN1_ENUMERATED_to_BN
#  define _ASN1_ENUMERATED_to_BN OPENSSL_MANGLER_ASM(ASN1_ENUMERATED_to_BN)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_FBOOLEAN_it
#  define ASN1_FBOOLEAN_it OPENSSL_MANGLER(ASN1_FBOOLEAN_it)
# endif
#else
# ifndef _ASN1_FBOOLEAN_it
#  define _ASN1_FBOOLEAN_it OPENSSL_MANGLER_ASM(ASN1_FBOOLEAN_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALIZEDTIME_adj
#  define ASN1_GENERALIZEDTIME_adj OPENSSL_MANGLER(ASN1_GENERALIZEDTIME_adj)
# endif
#else
# ifndef _ASN1_GENERALIZEDTIME_adj
#  define _ASN1_GENERALIZEDTIME_adj OPENSSL_MANGLER_ASM(ASN1_GENERALIZEDTIME_adj)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALIZEDTIME_check
#  define ASN1_GENERALIZEDTIME_check OPENSSL_MANGLER(ASN1_GENERALIZEDTIME_check)
# endif
#else
# ifndef _ASN1_GENERALIZEDTIME_check
#  define _ASN1_GENERALIZEDTIME_check OPENSSL_MANGLER_ASM(ASN1_GENERALIZEDTIME_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALIZEDTIME_free
#  define ASN1_GENERALIZEDTIME_free OPENSSL_MANGLER(ASN1_GENERALIZEDTIME_free)
# endif
#else
# ifndef _ASN1_GENERALIZEDTIME_free
#  define _ASN1_GENERALIZEDTIME_free OPENSSL_MANGLER_ASM(ASN1_GENERALIZEDTIME_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALIZEDTIME_it
#  define ASN1_GENERALIZEDTIME_it OPENSSL_MANGLER(ASN1_GENERALIZEDTIME_it)
# endif
#else
# ifndef _ASN1_GENERALIZEDTIME_it
#  define _ASN1_GENERALIZEDTIME_it OPENSSL_MANGLER_ASM(ASN1_GENERALIZEDTIME_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALIZEDTIME_new
#  define ASN1_GENERALIZEDTIME_new OPENSSL_MANGLER(ASN1_GENERALIZEDTIME_new)
# endif
#else
# ifndef _ASN1_GENERALIZEDTIME_new
#  define _ASN1_GENERALIZEDTIME_new OPENSSL_MANGLER_ASM(ASN1_GENERALIZEDTIME_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALIZEDTIME_print
#  define ASN1_GENERALIZEDTIME_print OPENSSL_MANGLER(ASN1_GENERALIZEDTIME_print)
# endif
#else
# ifndef _ASN1_GENERALIZEDTIME_print
#  define _ASN1_GENERALIZEDTIME_print OPENSSL_MANGLER_ASM(ASN1_GENERALIZEDTIME_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALIZEDTIME_set
#  define ASN1_GENERALIZEDTIME_set OPENSSL_MANGLER(ASN1_GENERALIZEDTIME_set)
# endif
#else
# ifndef _ASN1_GENERALIZEDTIME_set
#  define _ASN1_GENERALIZEDTIME_set OPENSSL_MANGLER_ASM(ASN1_GENERALIZEDTIME_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALIZEDTIME_set_string
#  define ASN1_GENERALIZEDTIME_set_string OPENSSL_MANGLER(ASN1_GENERALIZEDTIME_set_string)
# endif
#else
# ifndef _ASN1_GENERALIZEDTIME_set_string
#  define _ASN1_GENERALIZEDTIME_set_string OPENSSL_MANGLER_ASM(ASN1_GENERALIZEDTIME_set_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_generalizedtime_to_tm
#  define asn1_generalizedtime_to_tm OPENSSL_MANGLER(asn1_generalizedtime_to_tm)
# endif
#else
# ifndef _asn1_generalizedtime_to_tm
#  define _asn1_generalizedtime_to_tm OPENSSL_MANGLER_ASM(asn1_generalizedtime_to_tm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALSTRING_free
#  define ASN1_GENERALSTRING_free OPENSSL_MANGLER(ASN1_GENERALSTRING_free)
# endif
#else
# ifndef _ASN1_GENERALSTRING_free
#  define _ASN1_GENERALSTRING_free OPENSSL_MANGLER_ASM(ASN1_GENERALSTRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALSTRING_it
#  define ASN1_GENERALSTRING_it OPENSSL_MANGLER(ASN1_GENERALSTRING_it)
# endif
#else
# ifndef _ASN1_GENERALSTRING_it
#  define _ASN1_GENERALSTRING_it OPENSSL_MANGLER_ASM(ASN1_GENERALSTRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_GENERALSTRING_new
#  define ASN1_GENERALSTRING_new OPENSSL_MANGLER(ASN1_GENERALSTRING_new)
# endif
#else
# ifndef _ASN1_GENERALSTRING_new
#  define _ASN1_GENERALSTRING_new OPENSSL_MANGLER_ASM(ASN1_GENERALSTRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_generate_nconf
#  define ASN1_generate_nconf OPENSSL_MANGLER(ASN1_generate_nconf)
# endif
#else
# ifndef _ASN1_generate_nconf
#  define _ASN1_generate_nconf OPENSSL_MANGLER_ASM(ASN1_generate_nconf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_generate_v3
#  define ASN1_generate_v3 OPENSSL_MANGLER(ASN1_generate_v3)
# endif
#else
# ifndef _ASN1_generate_v3
#  define _ASN1_generate_v3 OPENSSL_MANGLER_ASM(ASN1_generate_v3)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_get_choice_selector
#  define asn1_get_choice_selector OPENSSL_MANGLER(asn1_get_choice_selector)
# endif
#else
# ifndef _asn1_get_choice_selector
#  define _asn1_get_choice_selector OPENSSL_MANGLER_ASM(asn1_get_choice_selector)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_get_field_ptr
#  define asn1_get_field_ptr OPENSSL_MANGLER(asn1_get_field_ptr)
# endif
#else
# ifndef _asn1_get_field_ptr
#  define _asn1_get_field_ptr OPENSSL_MANGLER_ASM(asn1_get_field_ptr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_get_object
#  define ASN1_get_object OPENSSL_MANGLER(ASN1_get_object)
# endif
#else
# ifndef _ASN1_get_object
#  define _ASN1_get_object OPENSSL_MANGLER_ASM(ASN1_get_object)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_i2d_bio
#  define ASN1_i2d_bio OPENSSL_MANGLER(ASN1_i2d_bio)
# endif
#else
# ifndef _ASN1_i2d_bio
#  define _ASN1_i2d_bio OPENSSL_MANGLER_ASM(ASN1_i2d_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_i2d_fp
#  define ASN1_i2d_fp OPENSSL_MANGLER(ASN1_i2d_fp)
# endif
#else
# ifndef _ASN1_i2d_fp
#  define _ASN1_i2d_fp OPENSSL_MANGLER_ASM(ASN1_i2d_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_IA5STRING_free
#  define ASN1_IA5STRING_free OPENSSL_MANGLER(ASN1_IA5STRING_free)
# endif
#else
# ifndef _ASN1_IA5STRING_free
#  define _ASN1_IA5STRING_free OPENSSL_MANGLER_ASM(ASN1_IA5STRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_IA5STRING_it
#  define ASN1_IA5STRING_it OPENSSL_MANGLER(ASN1_IA5STRING_it)
# endif
#else
# ifndef _ASN1_IA5STRING_it
#  define _ASN1_IA5STRING_it OPENSSL_MANGLER_ASM(ASN1_IA5STRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_IA5STRING_new
#  define ASN1_IA5STRING_new OPENSSL_MANGLER(ASN1_IA5STRING_new)
# endif
#else
# ifndef _ASN1_IA5STRING_new
#  define _ASN1_IA5STRING_new OPENSSL_MANGLER_ASM(ASN1_IA5STRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_cmp
#  define ASN1_INTEGER_cmp OPENSSL_MANGLER(ASN1_INTEGER_cmp)
# endif
#else
# ifndef _ASN1_INTEGER_cmp
#  define _ASN1_INTEGER_cmp OPENSSL_MANGLER_ASM(ASN1_INTEGER_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_dup
#  define ASN1_INTEGER_dup OPENSSL_MANGLER(ASN1_INTEGER_dup)
# endif
#else
# ifndef _ASN1_INTEGER_dup
#  define _ASN1_INTEGER_dup OPENSSL_MANGLER_ASM(ASN1_INTEGER_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_free
#  define ASN1_INTEGER_free OPENSSL_MANGLER(ASN1_INTEGER_free)
# endif
#else
# ifndef _ASN1_INTEGER_free
#  define _ASN1_INTEGER_free OPENSSL_MANGLER_ASM(ASN1_INTEGER_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_get
#  define ASN1_INTEGER_get OPENSSL_MANGLER(ASN1_INTEGER_get)
# endif
#else
# ifndef _ASN1_INTEGER_get
#  define _ASN1_INTEGER_get OPENSSL_MANGLER_ASM(ASN1_INTEGER_get)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_get_int64
#  define ASN1_INTEGER_get_int64 OPENSSL_MANGLER(ASN1_INTEGER_get_int64)
# endif
#else
# ifndef _ASN1_INTEGER_get_int64
#  define _ASN1_INTEGER_get_int64 OPENSSL_MANGLER_ASM(ASN1_INTEGER_get_int64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_get_uint64
#  define ASN1_INTEGER_get_uint64 OPENSSL_MANGLER(ASN1_INTEGER_get_uint64)
# endif
#else
# ifndef _ASN1_INTEGER_get_uint64
#  define _ASN1_INTEGER_get_uint64 OPENSSL_MANGLER_ASM(ASN1_INTEGER_get_uint64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_it
#  define ASN1_INTEGER_it OPENSSL_MANGLER(ASN1_INTEGER_it)
# endif
#else
# ifndef _ASN1_INTEGER_it
#  define _ASN1_INTEGER_it OPENSSL_MANGLER_ASM(ASN1_INTEGER_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_new
#  define ASN1_INTEGER_new OPENSSL_MANGLER(ASN1_INTEGER_new)
# endif
#else
# ifndef _ASN1_INTEGER_new
#  define _ASN1_INTEGER_new OPENSSL_MANGLER_ASM(ASN1_INTEGER_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_set
#  define ASN1_INTEGER_set OPENSSL_MANGLER(ASN1_INTEGER_set)
# endif
#else
# ifndef _ASN1_INTEGER_set
#  define _ASN1_INTEGER_set OPENSSL_MANGLER_ASM(ASN1_INTEGER_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_set_int64
#  define ASN1_INTEGER_set_int64 OPENSSL_MANGLER(ASN1_INTEGER_set_int64)
# endif
#else
# ifndef _ASN1_INTEGER_set_int64
#  define _ASN1_INTEGER_set_int64 OPENSSL_MANGLER_ASM(ASN1_INTEGER_set_int64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_set_uint64
#  define ASN1_INTEGER_set_uint64 OPENSSL_MANGLER(ASN1_INTEGER_set_uint64)
# endif
#else
# ifndef _ASN1_INTEGER_set_uint64
#  define _ASN1_INTEGER_set_uint64 OPENSSL_MANGLER_ASM(ASN1_INTEGER_set_uint64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_INTEGER_to_BN
#  define ASN1_INTEGER_to_BN OPENSSL_MANGLER(ASN1_INTEGER_to_BN)
# endif
#else
# ifndef _ASN1_INTEGER_to_BN
#  define _ASN1_INTEGER_to_BN OPENSSL_MANGLER_ASM(ASN1_INTEGER_to_BN)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_d2i
#  define ASN1_item_d2i OPENSSL_MANGLER(ASN1_item_d2i)
# endif
#else
# ifndef _ASN1_item_d2i
#  define _ASN1_item_d2i OPENSSL_MANGLER_ASM(ASN1_item_d2i)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_d2i_bio
#  define ASN1_item_d2i_bio OPENSSL_MANGLER(ASN1_item_d2i_bio)
# endif
#else
# ifndef _ASN1_item_d2i_bio
#  define _ASN1_item_d2i_bio OPENSSL_MANGLER_ASM(ASN1_item_d2i_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_d2i_fp
#  define ASN1_item_d2i_fp OPENSSL_MANGLER(ASN1_item_d2i_fp)
# endif
#else
# ifndef _ASN1_item_d2i_fp
#  define _ASN1_item_d2i_fp OPENSSL_MANGLER_ASM(ASN1_item_d2i_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_digest
#  define ASN1_item_digest OPENSSL_MANGLER(ASN1_item_digest)
# endif
#else
# ifndef _ASN1_item_digest
#  define _ASN1_item_digest OPENSSL_MANGLER_ASM(ASN1_item_digest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_dup
#  define ASN1_item_dup OPENSSL_MANGLER(ASN1_item_dup)
# endif
#else
# ifndef _ASN1_item_dup
#  define _ASN1_item_dup OPENSSL_MANGLER_ASM(ASN1_item_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_item_embed_free
#  define asn1_item_embed_free OPENSSL_MANGLER(asn1_item_embed_free)
# endif
#else
# ifndef _asn1_item_embed_free
#  define _asn1_item_embed_free OPENSSL_MANGLER_ASM(asn1_item_embed_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_ex_d2i
#  define ASN1_item_ex_d2i OPENSSL_MANGLER(ASN1_item_ex_d2i)
# endif
#else
# ifndef _ASN1_item_ex_d2i
#  define _ASN1_item_ex_d2i OPENSSL_MANGLER_ASM(ASN1_item_ex_d2i)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_ex_free
#  define ASN1_item_ex_free OPENSSL_MANGLER(ASN1_item_ex_free)
# endif
#else
# ifndef _ASN1_item_ex_free
#  define _ASN1_item_ex_free OPENSSL_MANGLER_ASM(ASN1_item_ex_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_ex_i2d
#  define ASN1_item_ex_i2d OPENSSL_MANGLER(ASN1_item_ex_i2d)
# endif
#else
# ifndef _ASN1_item_ex_i2d
#  define _ASN1_item_ex_i2d OPENSSL_MANGLER_ASM(ASN1_item_ex_i2d)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_ex_new
#  define ASN1_item_ex_new OPENSSL_MANGLER(ASN1_item_ex_new)
# endif
#else
# ifndef _ASN1_item_ex_new
#  define _ASN1_item_ex_new OPENSSL_MANGLER_ASM(ASN1_item_ex_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_free
#  define ASN1_item_free OPENSSL_MANGLER(ASN1_item_free)
# endif
#else
# ifndef _ASN1_item_free
#  define _ASN1_item_free OPENSSL_MANGLER_ASM(ASN1_item_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ITEM_get
#  define ASN1_ITEM_get OPENSSL_MANGLER(ASN1_ITEM_get)
# endif
#else
# ifndef _ASN1_ITEM_get
#  define _ASN1_ITEM_get OPENSSL_MANGLER_ASM(ASN1_ITEM_get)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_i2d
#  define ASN1_item_i2d OPENSSL_MANGLER(ASN1_item_i2d)
# endif
#else
# ifndef _ASN1_item_i2d
#  define _ASN1_item_i2d OPENSSL_MANGLER_ASM(ASN1_item_i2d)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_i2d_bio
#  define ASN1_item_i2d_bio OPENSSL_MANGLER(ASN1_item_i2d_bio)
# endif
#else
# ifndef _ASN1_item_i2d_bio
#  define _ASN1_item_i2d_bio OPENSSL_MANGLER_ASM(ASN1_item_i2d_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_i2d_fp
#  define ASN1_item_i2d_fp OPENSSL_MANGLER(ASN1_item_i2d_fp)
# endif
#else
# ifndef _ASN1_item_i2d_fp
#  define _ASN1_item_i2d_fp OPENSSL_MANGLER_ASM(ASN1_item_i2d_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_ITEM_lookup
#  define ASN1_ITEM_lookup OPENSSL_MANGLER(ASN1_ITEM_lookup)
# endif
#else
# ifndef _ASN1_ITEM_lookup
#  define _ASN1_ITEM_lookup OPENSSL_MANGLER_ASM(ASN1_ITEM_lookup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_ndef_i2d
#  define ASN1_item_ndef_i2d OPENSSL_MANGLER(ASN1_item_ndef_i2d)
# endif
#else
# ifndef _ASN1_item_ndef_i2d
#  define _ASN1_item_ndef_i2d OPENSSL_MANGLER_ASM(ASN1_item_ndef_i2d)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_new
#  define ASN1_item_new OPENSSL_MANGLER(ASN1_item_new)
# endif
#else
# ifndef _ASN1_item_new
#  define _ASN1_item_new OPENSSL_MANGLER_ASM(ASN1_item_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_pack
#  define ASN1_item_pack OPENSSL_MANGLER(ASN1_item_pack)
# endif
#else
# ifndef _ASN1_item_pack
#  define _ASN1_item_pack OPENSSL_MANGLER_ASM(ASN1_item_pack)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_print
#  define ASN1_item_print OPENSSL_MANGLER(ASN1_item_print)
# endif
#else
# ifndef _ASN1_item_print
#  define _ASN1_item_print OPENSSL_MANGLER_ASM(ASN1_item_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_sign
#  define ASN1_item_sign OPENSSL_MANGLER(ASN1_item_sign)
# endif
#else
# ifndef _ASN1_item_sign
#  define _ASN1_item_sign OPENSSL_MANGLER_ASM(ASN1_item_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_sign_ctx
#  define ASN1_item_sign_ctx OPENSSL_MANGLER(ASN1_item_sign_ctx)
# endif
#else
# ifndef _ASN1_item_sign_ctx
#  define _ASN1_item_sign_ctx OPENSSL_MANGLER_ASM(ASN1_item_sign_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_unpack
#  define ASN1_item_unpack OPENSSL_MANGLER(ASN1_item_unpack)
# endif
#else
# ifndef _ASN1_item_unpack
#  define _ASN1_item_unpack OPENSSL_MANGLER_ASM(ASN1_item_unpack)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_item_verify
#  define ASN1_item_verify OPENSSL_MANGLER(ASN1_item_verify)
# endif
#else
# ifndef _ASN1_item_verify
#  define _ASN1_item_verify OPENSSL_MANGLER_ASM(ASN1_item_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_mbstring_copy
#  define ASN1_mbstring_copy OPENSSL_MANGLER(ASN1_mbstring_copy)
# endif
#else
# ifndef _ASN1_mbstring_copy
#  define _ASN1_mbstring_copy OPENSSL_MANGLER_ASM(ASN1_mbstring_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_mbstring_ncopy
#  define ASN1_mbstring_ncopy OPENSSL_MANGLER(ASN1_mbstring_ncopy)
# endif
#else
# ifndef _ASN1_mbstring_ncopy
#  define _ASN1_mbstring_ncopy OPENSSL_MANGLER_ASM(ASN1_mbstring_ncopy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_NULL_free
#  define ASN1_NULL_free OPENSSL_MANGLER(ASN1_NULL_free)
# endif
#else
# ifndef _ASN1_NULL_free
#  define _ASN1_NULL_free OPENSSL_MANGLER_ASM(ASN1_NULL_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_NULL_it
#  define ASN1_NULL_it OPENSSL_MANGLER(ASN1_NULL_it)
# endif
#else
# ifndef _ASN1_NULL_it
#  define _ASN1_NULL_it OPENSSL_MANGLER_ASM(ASN1_NULL_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_NULL_new
#  define ASN1_NULL_new OPENSSL_MANGLER(ASN1_NULL_new)
# endif
#else
# ifndef _ASN1_NULL_new
#  define _ASN1_NULL_new OPENSSL_MANGLER_ASM(ASN1_NULL_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OBJECT_create
#  define ASN1_OBJECT_create OPENSSL_MANGLER(ASN1_OBJECT_create)
# endif
#else
# ifndef _ASN1_OBJECT_create
#  define _ASN1_OBJECT_create OPENSSL_MANGLER_ASM(ASN1_OBJECT_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OBJECT_free
#  define ASN1_OBJECT_free OPENSSL_MANGLER(ASN1_OBJECT_free)
# endif
#else
# ifndef _ASN1_OBJECT_free
#  define _ASN1_OBJECT_free OPENSSL_MANGLER_ASM(ASN1_OBJECT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OBJECT_it
#  define ASN1_OBJECT_it OPENSSL_MANGLER(ASN1_OBJECT_it)
# endif
#else
# ifndef _ASN1_OBJECT_it
#  define _ASN1_OBJECT_it OPENSSL_MANGLER_ASM(ASN1_OBJECT_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OBJECT_new
#  define ASN1_OBJECT_new OPENSSL_MANGLER(ASN1_OBJECT_new)
# endif
#else
# ifndef _ASN1_OBJECT_new
#  define _ASN1_OBJECT_new OPENSSL_MANGLER_ASM(ASN1_OBJECT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_object_size
#  define ASN1_object_size OPENSSL_MANGLER(ASN1_object_size)
# endif
#else
# ifndef _ASN1_object_size
#  define _ASN1_object_size OPENSSL_MANGLER_ASM(ASN1_object_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OCTET_STRING_cmp
#  define ASN1_OCTET_STRING_cmp OPENSSL_MANGLER(ASN1_OCTET_STRING_cmp)
# endif
#else
# ifndef _ASN1_OCTET_STRING_cmp
#  define _ASN1_OCTET_STRING_cmp OPENSSL_MANGLER_ASM(ASN1_OCTET_STRING_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OCTET_STRING_dup
#  define ASN1_OCTET_STRING_dup OPENSSL_MANGLER(ASN1_OCTET_STRING_dup)
# endif
#else
# ifndef _ASN1_OCTET_STRING_dup
#  define _ASN1_OCTET_STRING_dup OPENSSL_MANGLER_ASM(ASN1_OCTET_STRING_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OCTET_STRING_free
#  define ASN1_OCTET_STRING_free OPENSSL_MANGLER(ASN1_OCTET_STRING_free)
# endif
#else
# ifndef _ASN1_OCTET_STRING_free
#  define _ASN1_OCTET_STRING_free OPENSSL_MANGLER_ASM(ASN1_OCTET_STRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OCTET_STRING_it
#  define ASN1_OCTET_STRING_it OPENSSL_MANGLER(ASN1_OCTET_STRING_it)
# endif
#else
# ifndef _ASN1_OCTET_STRING_it
#  define _ASN1_OCTET_STRING_it OPENSSL_MANGLER_ASM(ASN1_OCTET_STRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OCTET_STRING_NDEF_it
#  define ASN1_OCTET_STRING_NDEF_it OPENSSL_MANGLER(ASN1_OCTET_STRING_NDEF_it)
# endif
#else
# ifndef _ASN1_OCTET_STRING_NDEF_it
#  define _ASN1_OCTET_STRING_NDEF_it OPENSSL_MANGLER_ASM(ASN1_OCTET_STRING_NDEF_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OCTET_STRING_new
#  define ASN1_OCTET_STRING_new OPENSSL_MANGLER(ASN1_OCTET_STRING_new)
# endif
#else
# ifndef _ASN1_OCTET_STRING_new
#  define _ASN1_OCTET_STRING_new OPENSSL_MANGLER_ASM(ASN1_OCTET_STRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_OCTET_STRING_set
#  define ASN1_OCTET_STRING_set OPENSSL_MANGLER(ASN1_OCTET_STRING_set)
# endif
#else
# ifndef _ASN1_OCTET_STRING_set
#  define _ASN1_OCTET_STRING_set OPENSSL_MANGLER_ASM(ASN1_OCTET_STRING_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_parse
#  define ASN1_parse OPENSSL_MANGLER(ASN1_parse)
# endif
#else
# ifndef _ASN1_parse
#  define _ASN1_parse OPENSSL_MANGLER_ASM(ASN1_parse)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_parse_dump
#  define ASN1_parse_dump OPENSSL_MANGLER(ASN1_parse_dump)
# endif
#else
# ifndef _ASN1_parse_dump
#  define _ASN1_parse_dump OPENSSL_MANGLER_ASM(ASN1_parse_dump)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_free
#  define ASN1_PCTX_free OPENSSL_MANGLER(ASN1_PCTX_free)
# endif
#else
# ifndef _ASN1_PCTX_free
#  define _ASN1_PCTX_free OPENSSL_MANGLER_ASM(ASN1_PCTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_get_cert_flags
#  define ASN1_PCTX_get_cert_flags OPENSSL_MANGLER(ASN1_PCTX_get_cert_flags)
# endif
#else
# ifndef _ASN1_PCTX_get_cert_flags
#  define _ASN1_PCTX_get_cert_flags OPENSSL_MANGLER_ASM(ASN1_PCTX_get_cert_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_get_flags
#  define ASN1_PCTX_get_flags OPENSSL_MANGLER(ASN1_PCTX_get_flags)
# endif
#else
# ifndef _ASN1_PCTX_get_flags
#  define _ASN1_PCTX_get_flags OPENSSL_MANGLER_ASM(ASN1_PCTX_get_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_get_nm_flags
#  define ASN1_PCTX_get_nm_flags OPENSSL_MANGLER(ASN1_PCTX_get_nm_flags)
# endif
#else
# ifndef _ASN1_PCTX_get_nm_flags
#  define _ASN1_PCTX_get_nm_flags OPENSSL_MANGLER_ASM(ASN1_PCTX_get_nm_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_get_oid_flags
#  define ASN1_PCTX_get_oid_flags OPENSSL_MANGLER(ASN1_PCTX_get_oid_flags)
# endif
#else
# ifndef _ASN1_PCTX_get_oid_flags
#  define _ASN1_PCTX_get_oid_flags OPENSSL_MANGLER_ASM(ASN1_PCTX_get_oid_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_get_str_flags
#  define ASN1_PCTX_get_str_flags OPENSSL_MANGLER(ASN1_PCTX_get_str_flags)
# endif
#else
# ifndef _ASN1_PCTX_get_str_flags
#  define _ASN1_PCTX_get_str_flags OPENSSL_MANGLER_ASM(ASN1_PCTX_get_str_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_new
#  define ASN1_PCTX_new OPENSSL_MANGLER(ASN1_PCTX_new)
# endif
#else
# ifndef _ASN1_PCTX_new
#  define _ASN1_PCTX_new OPENSSL_MANGLER_ASM(ASN1_PCTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_set_cert_flags
#  define ASN1_PCTX_set_cert_flags OPENSSL_MANGLER(ASN1_PCTX_set_cert_flags)
# endif
#else
# ifndef _ASN1_PCTX_set_cert_flags
#  define _ASN1_PCTX_set_cert_flags OPENSSL_MANGLER_ASM(ASN1_PCTX_set_cert_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_set_flags
#  define ASN1_PCTX_set_flags OPENSSL_MANGLER(ASN1_PCTX_set_flags)
# endif
#else
# ifndef _ASN1_PCTX_set_flags
#  define _ASN1_PCTX_set_flags OPENSSL_MANGLER_ASM(ASN1_PCTX_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_set_nm_flags
#  define ASN1_PCTX_set_nm_flags OPENSSL_MANGLER(ASN1_PCTX_set_nm_flags)
# endif
#else
# ifndef _ASN1_PCTX_set_nm_flags
#  define _ASN1_PCTX_set_nm_flags OPENSSL_MANGLER_ASM(ASN1_PCTX_set_nm_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_set_oid_flags
#  define ASN1_PCTX_set_oid_flags OPENSSL_MANGLER(ASN1_PCTX_set_oid_flags)
# endif
#else
# ifndef _ASN1_PCTX_set_oid_flags
#  define _ASN1_PCTX_set_oid_flags OPENSSL_MANGLER_ASM(ASN1_PCTX_set_oid_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PCTX_set_str_flags
#  define ASN1_PCTX_set_str_flags OPENSSL_MANGLER(ASN1_PCTX_set_str_flags)
# endif
#else
# ifndef _ASN1_PCTX_set_str_flags
#  define _ASN1_PCTX_set_str_flags OPENSSL_MANGLER_ASM(ASN1_PCTX_set_str_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_primitive_free
#  define asn1_primitive_free OPENSSL_MANGLER(asn1_primitive_free)
# endif
#else
# ifndef _asn1_primitive_free
#  define _asn1_primitive_free OPENSSL_MANGLER_ASM(asn1_primitive_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PRINTABLE_free
#  define ASN1_PRINTABLE_free OPENSSL_MANGLER(ASN1_PRINTABLE_free)
# endif
#else
# ifndef _ASN1_PRINTABLE_free
#  define _ASN1_PRINTABLE_free OPENSSL_MANGLER_ASM(ASN1_PRINTABLE_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PRINTABLE_it
#  define ASN1_PRINTABLE_it OPENSSL_MANGLER(ASN1_PRINTABLE_it)
# endif
#else
# ifndef _ASN1_PRINTABLE_it
#  define _ASN1_PRINTABLE_it OPENSSL_MANGLER_ASM(ASN1_PRINTABLE_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PRINTABLE_new
#  define ASN1_PRINTABLE_new OPENSSL_MANGLER(ASN1_PRINTABLE_new)
# endif
#else
# ifndef _ASN1_PRINTABLE_new
#  define _ASN1_PRINTABLE_new OPENSSL_MANGLER_ASM(ASN1_PRINTABLE_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PRINTABLESTRING_free
#  define ASN1_PRINTABLESTRING_free OPENSSL_MANGLER(ASN1_PRINTABLESTRING_free)
# endif
#else
# ifndef _ASN1_PRINTABLESTRING_free
#  define _ASN1_PRINTABLESTRING_free OPENSSL_MANGLER_ASM(ASN1_PRINTABLESTRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PRINTABLESTRING_it
#  define ASN1_PRINTABLESTRING_it OPENSSL_MANGLER(ASN1_PRINTABLESTRING_it)
# endif
#else
# ifndef _ASN1_PRINTABLESTRING_it
#  define _ASN1_PRINTABLESTRING_it OPENSSL_MANGLER_ASM(ASN1_PRINTABLESTRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PRINTABLESTRING_new
#  define ASN1_PRINTABLESTRING_new OPENSSL_MANGLER(ASN1_PRINTABLESTRING_new)
# endif
#else
# ifndef _ASN1_PRINTABLESTRING_new
#  define _ASN1_PRINTABLESTRING_new OPENSSL_MANGLER_ASM(ASN1_PRINTABLESTRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_PRINTABLE_type
#  define ASN1_PRINTABLE_type OPENSSL_MANGLER(ASN1_PRINTABLE_type)
# endif
#else
# ifndef _ASN1_PRINTABLE_type
#  define _ASN1_PRINTABLE_type OPENSSL_MANGLER_ASM(ASN1_PRINTABLE_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_put_eoc
#  define ASN1_put_eoc OPENSSL_MANGLER(ASN1_put_eoc)
# endif
#else
# ifndef _ASN1_put_eoc
#  define _ASN1_put_eoc OPENSSL_MANGLER_ASM(ASN1_put_eoc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_put_object
#  define ASN1_put_object OPENSSL_MANGLER(ASN1_put_object)
# endif
#else
# ifndef _ASN1_put_object
#  define _ASN1_put_object OPENSSL_MANGLER_ASM(ASN1_put_object)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_SCTX_free
#  define ASN1_SCTX_free OPENSSL_MANGLER(ASN1_SCTX_free)
# endif
#else
# ifndef _ASN1_SCTX_free
#  define _ASN1_SCTX_free OPENSSL_MANGLER_ASM(ASN1_SCTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_SCTX_get_app_data
#  define ASN1_SCTX_get_app_data OPENSSL_MANGLER(ASN1_SCTX_get_app_data)
# endif
#else
# ifndef _ASN1_SCTX_get_app_data
#  define _ASN1_SCTX_get_app_data OPENSSL_MANGLER_ASM(ASN1_SCTX_get_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_SCTX_get_flags
#  define ASN1_SCTX_get_flags OPENSSL_MANGLER(ASN1_SCTX_get_flags)
# endif
#else
# ifndef _ASN1_SCTX_get_flags
#  define _ASN1_SCTX_get_flags OPENSSL_MANGLER_ASM(ASN1_SCTX_get_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_SCTX_get_item
#  define ASN1_SCTX_get_item OPENSSL_MANGLER(ASN1_SCTX_get_item)
# endif
#else
# ifndef _ASN1_SCTX_get_item
#  define _ASN1_SCTX_get_item OPENSSL_MANGLER_ASM(ASN1_SCTX_get_item)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_SCTX_get_template
#  define ASN1_SCTX_get_template OPENSSL_MANGLER(ASN1_SCTX_get_template)
# endif
#else
# ifndef _ASN1_SCTX_get_template
#  define _ASN1_SCTX_get_template OPENSSL_MANGLER_ASM(ASN1_SCTX_get_template)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_SCTX_new
#  define ASN1_SCTX_new OPENSSL_MANGLER(ASN1_SCTX_new)
# endif
#else
# ifndef _ASN1_SCTX_new
#  define _ASN1_SCTX_new OPENSSL_MANGLER_ASM(ASN1_SCTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_SCTX_set_app_data
#  define ASN1_SCTX_set_app_data OPENSSL_MANGLER(ASN1_SCTX_set_app_data)
# endif
#else
# ifndef _ASN1_SCTX_set_app_data
#  define _ASN1_SCTX_set_app_data OPENSSL_MANGLER_ASM(ASN1_SCTX_set_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_SEQUENCE_ANY_it
#  define ASN1_SEQUENCE_ANY_it OPENSSL_MANGLER(ASN1_SEQUENCE_ANY_it)
# endif
#else
# ifndef _ASN1_SEQUENCE_ANY_it
#  define _ASN1_SEQUENCE_ANY_it OPENSSL_MANGLER_ASM(ASN1_SEQUENCE_ANY_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_SEQUENCE_it
#  define ASN1_SEQUENCE_it OPENSSL_MANGLER(ASN1_SEQUENCE_it)
# endif
#else
# ifndef _ASN1_SEQUENCE_it
#  define _ASN1_SEQUENCE_it OPENSSL_MANGLER_ASM(ASN1_SEQUENCE_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_SET_ANY_it
#  define ASN1_SET_ANY_it OPENSSL_MANGLER(ASN1_SET_ANY_it)
# endif
#else
# ifndef _ASN1_SET_ANY_it
#  define _ASN1_SET_ANY_it OPENSSL_MANGLER_ASM(ASN1_SET_ANY_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_set_choice_selector
#  define asn1_set_choice_selector OPENSSL_MANGLER(asn1_set_choice_selector)
# endif
#else
# ifndef _asn1_set_choice_selector
#  define _asn1_set_choice_selector OPENSSL_MANGLER_ASM(asn1_set_choice_selector)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_sign
#  define ASN1_sign OPENSSL_MANGLER(ASN1_sign)
# endif
#else
# ifndef _ASN1_sign
#  define _ASN1_sign OPENSSL_MANGLER_ASM(ASN1_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_str2mask
#  define ASN1_str2mask OPENSSL_MANGLER(ASN1_str2mask)
# endif
#else
# ifndef _ASN1_str2mask
#  define _ASN1_str2mask OPENSSL_MANGLER_ASM(ASN1_str2mask)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_clear_free
#  define ASN1_STRING_clear_free OPENSSL_MANGLER(ASN1_STRING_clear_free)
# endif
#else
# ifndef _ASN1_STRING_clear_free
#  define _ASN1_STRING_clear_free OPENSSL_MANGLER_ASM(ASN1_STRING_clear_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_cmp
#  define ASN1_STRING_cmp OPENSSL_MANGLER(ASN1_STRING_cmp)
# endif
#else
# ifndef _ASN1_STRING_cmp
#  define _ASN1_STRING_cmp OPENSSL_MANGLER_ASM(ASN1_STRING_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_copy
#  define ASN1_STRING_copy OPENSSL_MANGLER(ASN1_STRING_copy)
# endif
#else
# ifndef _ASN1_STRING_copy
#  define _ASN1_STRING_copy OPENSSL_MANGLER_ASM(ASN1_STRING_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_data
#  define ASN1_STRING_data OPENSSL_MANGLER(ASN1_STRING_data)
# endif
#else
# ifndef _ASN1_STRING_data
#  define _ASN1_STRING_data OPENSSL_MANGLER_ASM(ASN1_STRING_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_dup
#  define ASN1_STRING_dup OPENSSL_MANGLER(ASN1_STRING_dup)
# endif
#else
# ifndef _ASN1_STRING_dup
#  define _ASN1_STRING_dup OPENSSL_MANGLER_ASM(ASN1_STRING_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_string_embed_free
#  define asn1_string_embed_free OPENSSL_MANGLER(asn1_string_embed_free)
# endif
#else
# ifndef _asn1_string_embed_free
#  define _asn1_string_embed_free OPENSSL_MANGLER_ASM(asn1_string_embed_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_free
#  define ASN1_STRING_free OPENSSL_MANGLER(ASN1_STRING_free)
# endif
#else
# ifndef _ASN1_STRING_free
#  define _ASN1_STRING_free OPENSSL_MANGLER_ASM(ASN1_STRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_get0_data
#  define ASN1_STRING_get0_data OPENSSL_MANGLER(ASN1_STRING_get0_data)
# endif
#else
# ifndef _ASN1_STRING_get0_data
#  define _ASN1_STRING_get0_data OPENSSL_MANGLER_ASM(ASN1_STRING_get0_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_get_default_mask
#  define ASN1_STRING_get_default_mask OPENSSL_MANGLER(ASN1_STRING_get_default_mask)
# endif
#else
# ifndef _ASN1_STRING_get_default_mask
#  define _ASN1_STRING_get_default_mask OPENSSL_MANGLER_ASM(ASN1_STRING_get_default_mask)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_length
#  define ASN1_STRING_length OPENSSL_MANGLER(ASN1_STRING_length)
# endif
#else
# ifndef _ASN1_STRING_length
#  define _ASN1_STRING_length OPENSSL_MANGLER_ASM(ASN1_STRING_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_length_set
#  define ASN1_STRING_length_set OPENSSL_MANGLER(ASN1_STRING_length_set)
# endif
#else
# ifndef _ASN1_STRING_length_set
#  define _ASN1_STRING_length_set OPENSSL_MANGLER_ASM(ASN1_STRING_length_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_new
#  define ASN1_STRING_new OPENSSL_MANGLER(ASN1_STRING_new)
# endif
#else
# ifndef _ASN1_STRING_new
#  define _ASN1_STRING_new OPENSSL_MANGLER_ASM(ASN1_STRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_print
#  define ASN1_STRING_print OPENSSL_MANGLER(ASN1_STRING_print)
# endif
#else
# ifndef _ASN1_STRING_print
#  define _ASN1_STRING_print OPENSSL_MANGLER_ASM(ASN1_STRING_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_print_ex
#  define ASN1_STRING_print_ex OPENSSL_MANGLER(ASN1_STRING_print_ex)
# endif
#else
# ifndef _ASN1_STRING_print_ex
#  define _ASN1_STRING_print_ex OPENSSL_MANGLER_ASM(ASN1_STRING_print_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_print_ex_fp
#  define ASN1_STRING_print_ex_fp OPENSSL_MANGLER(ASN1_STRING_print_ex_fp)
# endif
#else
# ifndef _ASN1_STRING_print_ex_fp
#  define _ASN1_STRING_print_ex_fp OPENSSL_MANGLER_ASM(ASN1_STRING_print_ex_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_set
#  define ASN1_STRING_set OPENSSL_MANGLER(ASN1_STRING_set)
# endif
#else
# ifndef _ASN1_STRING_set
#  define _ASN1_STRING_set OPENSSL_MANGLER_ASM(ASN1_STRING_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_set0
#  define ASN1_STRING_set0 OPENSSL_MANGLER(ASN1_STRING_set0)
# endif
#else
# ifndef _ASN1_STRING_set0
#  define _ASN1_STRING_set0 OPENSSL_MANGLER_ASM(ASN1_STRING_set0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_set_by_NID
#  define ASN1_STRING_set_by_NID OPENSSL_MANGLER(ASN1_STRING_set_by_NID)
# endif
#else
# ifndef _ASN1_STRING_set_by_NID
#  define _ASN1_STRING_set_by_NID OPENSSL_MANGLER_ASM(ASN1_STRING_set_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_set_default_mask
#  define ASN1_STRING_set_default_mask OPENSSL_MANGLER(ASN1_STRING_set_default_mask)
# endif
#else
# ifndef _ASN1_STRING_set_default_mask
#  define _ASN1_STRING_set_default_mask OPENSSL_MANGLER_ASM(ASN1_STRING_set_default_mask)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_set_default_mask_asc
#  define ASN1_STRING_set_default_mask_asc OPENSSL_MANGLER(ASN1_STRING_set_default_mask_asc)
# endif
#else
# ifndef _ASN1_STRING_set_default_mask_asc
#  define _ASN1_STRING_set_default_mask_asc OPENSSL_MANGLER_ASM(ASN1_STRING_set_default_mask_asc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_TABLE_add
#  define ASN1_STRING_TABLE_add OPENSSL_MANGLER(ASN1_STRING_TABLE_add)
# endif
#else
# ifndef _ASN1_STRING_TABLE_add
#  define _ASN1_STRING_TABLE_add OPENSSL_MANGLER_ASM(ASN1_STRING_TABLE_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_TABLE_cleanup
#  define ASN1_STRING_TABLE_cleanup OPENSSL_MANGLER(ASN1_STRING_TABLE_cleanup)
# endif
#else
# ifndef _ASN1_STRING_TABLE_cleanup
#  define _ASN1_STRING_TABLE_cleanup OPENSSL_MANGLER_ASM(ASN1_STRING_TABLE_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_TABLE_get
#  define ASN1_STRING_TABLE_get OPENSSL_MANGLER(ASN1_STRING_TABLE_get)
# endif
#else
# ifndef _ASN1_STRING_TABLE_get
#  define _ASN1_STRING_TABLE_get OPENSSL_MANGLER_ASM(ASN1_STRING_TABLE_get)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_to_UTF8
#  define ASN1_STRING_to_UTF8 OPENSSL_MANGLER(ASN1_STRING_to_UTF8)
# endif
#else
# ifndef _ASN1_STRING_to_UTF8
#  define _ASN1_STRING_to_UTF8 OPENSSL_MANGLER_ASM(ASN1_STRING_to_UTF8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_type
#  define ASN1_STRING_type OPENSSL_MANGLER(ASN1_STRING_type)
# endif
#else
# ifndef _ASN1_STRING_type
#  define _ASN1_STRING_type OPENSSL_MANGLER_ASM(ASN1_STRING_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_STRING_type_new
#  define ASN1_STRING_type_new OPENSSL_MANGLER(ASN1_STRING_type_new)
# endif
#else
# ifndef _ASN1_STRING_type_new
#  define _ASN1_STRING_type_new OPENSSL_MANGLER_ASM(ASN1_STRING_type_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_T61STRING_free
#  define ASN1_T61STRING_free OPENSSL_MANGLER(ASN1_T61STRING_free)
# endif
#else
# ifndef _ASN1_T61STRING_free
#  define _ASN1_T61STRING_free OPENSSL_MANGLER_ASM(ASN1_T61STRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_T61STRING_it
#  define ASN1_T61STRING_it OPENSSL_MANGLER(ASN1_T61STRING_it)
# endif
#else
# ifndef _ASN1_T61STRING_it
#  define _ASN1_T61STRING_it OPENSSL_MANGLER_ASM(ASN1_T61STRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_T61STRING_new
#  define ASN1_T61STRING_new OPENSSL_MANGLER(ASN1_T61STRING_new)
# endif
#else
# ifndef _ASN1_T61STRING_new
#  define _ASN1_T61STRING_new OPENSSL_MANGLER_ASM(ASN1_T61STRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_tag2bit
#  define ASN1_tag2bit OPENSSL_MANGLER(ASN1_tag2bit)
# endif
#else
# ifndef _ASN1_tag2bit
#  define _ASN1_tag2bit OPENSSL_MANGLER_ASM(ASN1_tag2bit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_tag2str
#  define ASN1_tag2str OPENSSL_MANGLER(ASN1_tag2str)
# endif
#else
# ifndef _ASN1_tag2str
#  define _ASN1_tag2str OPENSSL_MANGLER_ASM(ASN1_tag2str)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TBOOLEAN_it
#  define ASN1_TBOOLEAN_it OPENSSL_MANGLER(ASN1_TBOOLEAN_it)
# endif
#else
# ifndef _ASN1_TBOOLEAN_it
#  define _ASN1_TBOOLEAN_it OPENSSL_MANGLER_ASM(ASN1_TBOOLEAN_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_template_free
#  define asn1_template_free OPENSSL_MANGLER(asn1_template_free)
# endif
#else
# ifndef _asn1_template_free
#  define _asn1_template_free OPENSSL_MANGLER_ASM(asn1_template_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_adj
#  define ASN1_TIME_adj OPENSSL_MANGLER(ASN1_TIME_adj)
# endif
#else
# ifndef _ASN1_TIME_adj
#  define _ASN1_TIME_adj OPENSSL_MANGLER_ASM(ASN1_TIME_adj)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_check
#  define ASN1_TIME_check OPENSSL_MANGLER(ASN1_TIME_check)
# endif
#else
# ifndef _ASN1_TIME_check
#  define _ASN1_TIME_check OPENSSL_MANGLER_ASM(ASN1_TIME_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_cmp_time_t
#  define ASN1_TIME_cmp_time_t OPENSSL_MANGLER(ASN1_TIME_cmp_time_t)
# endif
#else
# ifndef _ASN1_TIME_cmp_time_t
#  define _ASN1_TIME_cmp_time_t OPENSSL_MANGLER_ASM(ASN1_TIME_cmp_time_t)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_compare
#  define ASN1_TIME_compare OPENSSL_MANGLER(ASN1_TIME_compare)
# endif
#else
# ifndef _ASN1_TIME_compare
#  define _ASN1_TIME_compare OPENSSL_MANGLER_ASM(ASN1_TIME_compare)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_diff
#  define ASN1_TIME_diff OPENSSL_MANGLER(ASN1_TIME_diff)
# endif
#else
# ifndef _ASN1_TIME_diff
#  define _ASN1_TIME_diff OPENSSL_MANGLER_ASM(ASN1_TIME_diff)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_free
#  define ASN1_TIME_free OPENSSL_MANGLER(ASN1_TIME_free)
# endif
#else
# ifndef _ASN1_TIME_free
#  define _ASN1_TIME_free OPENSSL_MANGLER_ASM(ASN1_TIME_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_time_from_tm
#  define asn1_time_from_tm OPENSSL_MANGLER(asn1_time_from_tm)
# endif
#else
# ifndef _asn1_time_from_tm
#  define _asn1_time_from_tm OPENSSL_MANGLER_ASM(asn1_time_from_tm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_it
#  define ASN1_TIME_it OPENSSL_MANGLER(ASN1_TIME_it)
# endif
#else
# ifndef _ASN1_TIME_it
#  define _ASN1_TIME_it OPENSSL_MANGLER_ASM(ASN1_TIME_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_new
#  define ASN1_TIME_new OPENSSL_MANGLER(ASN1_TIME_new)
# endif
#else
# ifndef _ASN1_TIME_new
#  define _ASN1_TIME_new OPENSSL_MANGLER_ASM(ASN1_TIME_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_normalize
#  define ASN1_TIME_normalize OPENSSL_MANGLER(ASN1_TIME_normalize)
# endif
#else
# ifndef _ASN1_TIME_normalize
#  define _ASN1_TIME_normalize OPENSSL_MANGLER_ASM(ASN1_TIME_normalize)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_print
#  define ASN1_TIME_print OPENSSL_MANGLER(ASN1_TIME_print)
# endif
#else
# ifndef _ASN1_TIME_print
#  define _ASN1_TIME_print OPENSSL_MANGLER_ASM(ASN1_TIME_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_set
#  define ASN1_TIME_set OPENSSL_MANGLER(ASN1_TIME_set)
# endif
#else
# ifndef _ASN1_TIME_set
#  define _ASN1_TIME_set OPENSSL_MANGLER_ASM(ASN1_TIME_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_set_string
#  define ASN1_TIME_set_string OPENSSL_MANGLER(ASN1_TIME_set_string)
# endif
#else
# ifndef _ASN1_TIME_set_string
#  define _ASN1_TIME_set_string OPENSSL_MANGLER_ASM(ASN1_TIME_set_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_set_string_X509
#  define ASN1_TIME_set_string_X509 OPENSSL_MANGLER(ASN1_TIME_set_string_X509)
# endif
#else
# ifndef _ASN1_TIME_set_string_X509
#  define _ASN1_TIME_set_string_X509 OPENSSL_MANGLER_ASM(ASN1_TIME_set_string_X509)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_to_generalizedtime
#  define ASN1_TIME_to_generalizedtime OPENSSL_MANGLER(ASN1_TIME_to_generalizedtime)
# endif
#else
# ifndef _ASN1_TIME_to_generalizedtime
#  define _ASN1_TIME_to_generalizedtime OPENSSL_MANGLER_ASM(ASN1_TIME_to_generalizedtime)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_time_to_tm
#  define asn1_time_to_tm OPENSSL_MANGLER(asn1_time_to_tm)
# endif
#else
# ifndef _asn1_time_to_tm
#  define _asn1_time_to_tm OPENSSL_MANGLER_ASM(asn1_time_to_tm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TIME_to_tm
#  define ASN1_TIME_to_tm OPENSSL_MANGLER(ASN1_TIME_to_tm)
# endif
#else
# ifndef _ASN1_TIME_to_tm
#  define _ASN1_TIME_to_tm OPENSSL_MANGLER_ASM(ASN1_TIME_to_tm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_cmp
#  define ASN1_TYPE_cmp OPENSSL_MANGLER(ASN1_TYPE_cmp)
# endif
#else
# ifndef _ASN1_TYPE_cmp
#  define _ASN1_TYPE_cmp OPENSSL_MANGLER_ASM(ASN1_TYPE_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_free
#  define ASN1_TYPE_free OPENSSL_MANGLER(ASN1_TYPE_free)
# endif
#else
# ifndef _ASN1_TYPE_free
#  define _ASN1_TYPE_free OPENSSL_MANGLER_ASM(ASN1_TYPE_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_get
#  define ASN1_TYPE_get OPENSSL_MANGLER(ASN1_TYPE_get)
# endif
#else
# ifndef _ASN1_TYPE_get
#  define _ASN1_TYPE_get OPENSSL_MANGLER_ASM(ASN1_TYPE_get)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_get_int_octetstring
#  define ASN1_TYPE_get_int_octetstring OPENSSL_MANGLER(ASN1_TYPE_get_int_octetstring)
# endif
#else
# ifndef _ASN1_TYPE_get_int_octetstring
#  define _ASN1_TYPE_get_int_octetstring OPENSSL_MANGLER_ASM(ASN1_TYPE_get_int_octetstring)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_get_octetstring
#  define ASN1_TYPE_get_octetstring OPENSSL_MANGLER(ASN1_TYPE_get_octetstring)
# endif
#else
# ifndef _ASN1_TYPE_get_octetstring
#  define _ASN1_TYPE_get_octetstring OPENSSL_MANGLER_ASM(ASN1_TYPE_get_octetstring)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_new
#  define ASN1_TYPE_new OPENSSL_MANGLER(ASN1_TYPE_new)
# endif
#else
# ifndef _ASN1_TYPE_new
#  define _ASN1_TYPE_new OPENSSL_MANGLER_ASM(ASN1_TYPE_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_pack_sequence
#  define ASN1_TYPE_pack_sequence OPENSSL_MANGLER(ASN1_TYPE_pack_sequence)
# endif
#else
# ifndef _ASN1_TYPE_pack_sequence
#  define _ASN1_TYPE_pack_sequence OPENSSL_MANGLER_ASM(ASN1_TYPE_pack_sequence)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_set
#  define ASN1_TYPE_set OPENSSL_MANGLER(ASN1_TYPE_set)
# endif
#else
# ifndef _ASN1_TYPE_set
#  define _ASN1_TYPE_set OPENSSL_MANGLER_ASM(ASN1_TYPE_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_set1
#  define ASN1_TYPE_set1 OPENSSL_MANGLER(ASN1_TYPE_set1)
# endif
#else
# ifndef _ASN1_TYPE_set1
#  define _ASN1_TYPE_set1 OPENSSL_MANGLER_ASM(ASN1_TYPE_set1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_set_int_octetstring
#  define ASN1_TYPE_set_int_octetstring OPENSSL_MANGLER(ASN1_TYPE_set_int_octetstring)
# endif
#else
# ifndef _ASN1_TYPE_set_int_octetstring
#  define _ASN1_TYPE_set_int_octetstring OPENSSL_MANGLER_ASM(ASN1_TYPE_set_int_octetstring)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_set_octetstring
#  define ASN1_TYPE_set_octetstring OPENSSL_MANGLER(ASN1_TYPE_set_octetstring)
# endif
#else
# ifndef _ASN1_TYPE_set_octetstring
#  define _ASN1_TYPE_set_octetstring OPENSSL_MANGLER_ASM(ASN1_TYPE_set_octetstring)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_TYPE_unpack_sequence
#  define ASN1_TYPE_unpack_sequence OPENSSL_MANGLER(ASN1_TYPE_unpack_sequence)
# endif
#else
# ifndef _ASN1_TYPE_unpack_sequence
#  define _ASN1_TYPE_unpack_sequence OPENSSL_MANGLER_ASM(ASN1_TYPE_unpack_sequence)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UNIVERSALSTRING_free
#  define ASN1_UNIVERSALSTRING_free OPENSSL_MANGLER(ASN1_UNIVERSALSTRING_free)
# endif
#else
# ifndef _ASN1_UNIVERSALSTRING_free
#  define _ASN1_UNIVERSALSTRING_free OPENSSL_MANGLER_ASM(ASN1_UNIVERSALSTRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UNIVERSALSTRING_it
#  define ASN1_UNIVERSALSTRING_it OPENSSL_MANGLER(ASN1_UNIVERSALSTRING_it)
# endif
#else
# ifndef _ASN1_UNIVERSALSTRING_it
#  define _ASN1_UNIVERSALSTRING_it OPENSSL_MANGLER_ASM(ASN1_UNIVERSALSTRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UNIVERSALSTRING_new
#  define ASN1_UNIVERSALSTRING_new OPENSSL_MANGLER(ASN1_UNIVERSALSTRING_new)
# endif
#else
# ifndef _ASN1_UNIVERSALSTRING_new
#  define _ASN1_UNIVERSALSTRING_new OPENSSL_MANGLER_ASM(ASN1_UNIVERSALSTRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UNIVERSALSTRING_to_string
#  define ASN1_UNIVERSALSTRING_to_string OPENSSL_MANGLER(ASN1_UNIVERSALSTRING_to_string)
# endif
#else
# ifndef _ASN1_UNIVERSALSTRING_to_string
#  define _ASN1_UNIVERSALSTRING_to_string OPENSSL_MANGLER_ASM(ASN1_UNIVERSALSTRING_to_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTCTIME_adj
#  define ASN1_UTCTIME_adj OPENSSL_MANGLER(ASN1_UTCTIME_adj)
# endif
#else
# ifndef _ASN1_UTCTIME_adj
#  define _ASN1_UTCTIME_adj OPENSSL_MANGLER_ASM(ASN1_UTCTIME_adj)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTCTIME_check
#  define ASN1_UTCTIME_check OPENSSL_MANGLER(ASN1_UTCTIME_check)
# endif
#else
# ifndef _ASN1_UTCTIME_check
#  define _ASN1_UTCTIME_check OPENSSL_MANGLER_ASM(ASN1_UTCTIME_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTCTIME_cmp_time_t
#  define ASN1_UTCTIME_cmp_time_t OPENSSL_MANGLER(ASN1_UTCTIME_cmp_time_t)
# endif
#else
# ifndef _ASN1_UTCTIME_cmp_time_t
#  define _ASN1_UTCTIME_cmp_time_t OPENSSL_MANGLER_ASM(ASN1_UTCTIME_cmp_time_t)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTCTIME_free
#  define ASN1_UTCTIME_free OPENSSL_MANGLER(ASN1_UTCTIME_free)
# endif
#else
# ifndef _ASN1_UTCTIME_free
#  define _ASN1_UTCTIME_free OPENSSL_MANGLER_ASM(ASN1_UTCTIME_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTCTIME_it
#  define ASN1_UTCTIME_it OPENSSL_MANGLER(ASN1_UTCTIME_it)
# endif
#else
# ifndef _ASN1_UTCTIME_it
#  define _ASN1_UTCTIME_it OPENSSL_MANGLER_ASM(ASN1_UTCTIME_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTCTIME_new
#  define ASN1_UTCTIME_new OPENSSL_MANGLER(ASN1_UTCTIME_new)
# endif
#else
# ifndef _ASN1_UTCTIME_new
#  define _ASN1_UTCTIME_new OPENSSL_MANGLER_ASM(ASN1_UTCTIME_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTCTIME_print
#  define ASN1_UTCTIME_print OPENSSL_MANGLER(ASN1_UTCTIME_print)
# endif
#else
# ifndef _ASN1_UTCTIME_print
#  define _ASN1_UTCTIME_print OPENSSL_MANGLER_ASM(ASN1_UTCTIME_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTCTIME_set
#  define ASN1_UTCTIME_set OPENSSL_MANGLER(ASN1_UTCTIME_set)
# endif
#else
# ifndef _ASN1_UTCTIME_set
#  define _ASN1_UTCTIME_set OPENSSL_MANGLER_ASM(ASN1_UTCTIME_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTCTIME_set_string
#  define ASN1_UTCTIME_set_string OPENSSL_MANGLER(ASN1_UTCTIME_set_string)
# endif
#else
# ifndef _ASN1_UTCTIME_set_string
#  define _ASN1_UTCTIME_set_string OPENSSL_MANGLER_ASM(ASN1_UTCTIME_set_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef asn1_utctime_to_tm
#  define asn1_utctime_to_tm OPENSSL_MANGLER(asn1_utctime_to_tm)
# endif
#else
# ifndef _asn1_utctime_to_tm
#  define _asn1_utctime_to_tm OPENSSL_MANGLER_ASM(asn1_utctime_to_tm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTF8STRING_free
#  define ASN1_UTF8STRING_free OPENSSL_MANGLER(ASN1_UTF8STRING_free)
# endif
#else
# ifndef _ASN1_UTF8STRING_free
#  define _ASN1_UTF8STRING_free OPENSSL_MANGLER_ASM(ASN1_UTF8STRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTF8STRING_it
#  define ASN1_UTF8STRING_it OPENSSL_MANGLER(ASN1_UTF8STRING_it)
# endif
#else
# ifndef _ASN1_UTF8STRING_it
#  define _ASN1_UTF8STRING_it OPENSSL_MANGLER_ASM(ASN1_UTF8STRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_UTF8STRING_new
#  define ASN1_UTF8STRING_new OPENSSL_MANGLER(ASN1_UTF8STRING_new)
# endif
#else
# ifndef _ASN1_UTF8STRING_new
#  define _ASN1_UTF8STRING_new OPENSSL_MANGLER_ASM(ASN1_UTF8STRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_verify
#  define ASN1_verify OPENSSL_MANGLER(ASN1_verify)
# endif
#else
# ifndef _ASN1_verify
#  define _ASN1_verify OPENSSL_MANGLER_ASM(ASN1_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_VISIBLESTRING_free
#  define ASN1_VISIBLESTRING_free OPENSSL_MANGLER(ASN1_VISIBLESTRING_free)
# endif
#else
# ifndef _ASN1_VISIBLESTRING_free
#  define _ASN1_VISIBLESTRING_free OPENSSL_MANGLER_ASM(ASN1_VISIBLESTRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_VISIBLESTRING_it
#  define ASN1_VISIBLESTRING_it OPENSSL_MANGLER(ASN1_VISIBLESTRING_it)
# endif
#else
# ifndef _ASN1_VISIBLESTRING_it
#  define _ASN1_VISIBLESTRING_it OPENSSL_MANGLER_ASM(ASN1_VISIBLESTRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASN1_VISIBLESTRING_new
#  define ASN1_VISIBLESTRING_new OPENSSL_MANGLER(ASN1_VISIBLESTRING_new)
# endif
#else
# ifndef _ASN1_VISIBLESTRING_new
#  define _ASN1_VISIBLESTRING_new OPENSSL_MANGLER_ASM(ASN1_VISIBLESTRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASRange_free
#  define ASRange_free OPENSSL_MANGLER(ASRange_free)
# endif
#else
# ifndef _ASRange_free
#  define _ASRange_free OPENSSL_MANGLER_ASM(ASRange_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASRange_it
#  define ASRange_it OPENSSL_MANGLER(ASRange_it)
# endif
#else
# ifndef _ASRange_it
#  define _ASRange_it OPENSSL_MANGLER_ASM(ASRange_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASRange_new
#  define ASRange_new OPENSSL_MANGLER(ASRange_new)
# endif
#else
# ifndef _ASRange_new
#  define _ASRange_new OPENSSL_MANGLER_ASM(ASRange_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_block_pause
#  define ASYNC_block_pause OPENSSL_MANGLER(ASYNC_block_pause)
# endif
#else
# ifndef _ASYNC_block_pause
#  define _ASYNC_block_pause OPENSSL_MANGLER_ASM(ASYNC_block_pause)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_cleanup_thread
#  define ASYNC_cleanup_thread OPENSSL_MANGLER(ASYNC_cleanup_thread)
# endif
#else
# ifndef _ASYNC_cleanup_thread
#  define _ASYNC_cleanup_thread OPENSSL_MANGLER_ASM(ASYNC_cleanup_thread)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef async_deinit
#  define async_deinit OPENSSL_MANGLER(async_deinit)
# endif
#else
# ifndef _async_deinit
#  define _async_deinit OPENSSL_MANGLER_ASM(async_deinit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef async_delete_thread_state
#  define async_delete_thread_state OPENSSL_MANGLER(async_delete_thread_state)
# endif
#else
# ifndef _async_delete_thread_state
#  define _async_delete_thread_state OPENSSL_MANGLER_ASM(async_delete_thread_state)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef async_fibre_free
#  define async_fibre_free OPENSSL_MANGLER(async_fibre_free)
# endif
#else
# ifndef _async_fibre_free
#  define _async_fibre_free OPENSSL_MANGLER_ASM(async_fibre_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef async_fibre_makecontext
#  define async_fibre_makecontext OPENSSL_MANGLER(async_fibre_makecontext)
# endif
#else
# ifndef _async_fibre_makecontext
#  define _async_fibre_makecontext OPENSSL_MANGLER_ASM(async_fibre_makecontext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef async_get_ctx
#  define async_get_ctx OPENSSL_MANGLER(async_get_ctx)
# endif
#else
# ifndef _async_get_ctx
#  define _async_get_ctx OPENSSL_MANGLER_ASM(async_get_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_get_current_job
#  define ASYNC_get_current_job OPENSSL_MANGLER(ASYNC_get_current_job)
# endif
#else
# ifndef _ASYNC_get_current_job
#  define _ASYNC_get_current_job OPENSSL_MANGLER_ASM(ASYNC_get_current_job)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_get_wait_ctx
#  define ASYNC_get_wait_ctx OPENSSL_MANGLER(ASYNC_get_wait_ctx)
# endif
#else
# ifndef _ASYNC_get_wait_ctx
#  define _ASYNC_get_wait_ctx OPENSSL_MANGLER_ASM(ASYNC_get_wait_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef async_init
#  define async_init OPENSSL_MANGLER(async_init)
# endif
#else
# ifndef _async_init
#  define _async_init OPENSSL_MANGLER_ASM(async_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_init_thread
#  define ASYNC_init_thread OPENSSL_MANGLER(ASYNC_init_thread)
# endif
#else
# ifndef _ASYNC_init_thread
#  define _ASYNC_init_thread OPENSSL_MANGLER_ASM(ASYNC_init_thread)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_is_capable
#  define ASYNC_is_capable OPENSSL_MANGLER(ASYNC_is_capable)
# endif
#else
# ifndef _ASYNC_is_capable
#  define _ASYNC_is_capable OPENSSL_MANGLER_ASM(ASYNC_is_capable)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef async_local_cleanup
#  define async_local_cleanup OPENSSL_MANGLER(async_local_cleanup)
# endif
#else
# ifndef _async_local_cleanup
#  define _async_local_cleanup OPENSSL_MANGLER_ASM(async_local_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_pause_job
#  define ASYNC_pause_job OPENSSL_MANGLER(ASYNC_pause_job)
# endif
#else
# ifndef _ASYNC_pause_job
#  define _ASYNC_pause_job OPENSSL_MANGLER_ASM(ASYNC_pause_job)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef async_start_func
#  define async_start_func OPENSSL_MANGLER(async_start_func)
# endif
#else
# ifndef _async_start_func
#  define _async_start_func OPENSSL_MANGLER_ASM(async_start_func)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_start_job
#  define ASYNC_start_job OPENSSL_MANGLER(ASYNC_start_job)
# endif
#else
# ifndef _ASYNC_start_job
#  define _ASYNC_start_job OPENSSL_MANGLER_ASM(ASYNC_start_job)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_unblock_pause
#  define ASYNC_unblock_pause OPENSSL_MANGLER(ASYNC_unblock_pause)
# endif
#else
# ifndef _ASYNC_unblock_pause
#  define _ASYNC_unblock_pause OPENSSL_MANGLER_ASM(ASYNC_unblock_pause)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_WAIT_CTX_clear_fd
#  define ASYNC_WAIT_CTX_clear_fd OPENSSL_MANGLER(ASYNC_WAIT_CTX_clear_fd)
# endif
#else
# ifndef _ASYNC_WAIT_CTX_clear_fd
#  define _ASYNC_WAIT_CTX_clear_fd OPENSSL_MANGLER_ASM(ASYNC_WAIT_CTX_clear_fd)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_WAIT_CTX_free
#  define ASYNC_WAIT_CTX_free OPENSSL_MANGLER(ASYNC_WAIT_CTX_free)
# endif
#else
# ifndef _ASYNC_WAIT_CTX_free
#  define _ASYNC_WAIT_CTX_free OPENSSL_MANGLER_ASM(ASYNC_WAIT_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_WAIT_CTX_get_all_fds
#  define ASYNC_WAIT_CTX_get_all_fds OPENSSL_MANGLER(ASYNC_WAIT_CTX_get_all_fds)
# endif
#else
# ifndef _ASYNC_WAIT_CTX_get_all_fds
#  define _ASYNC_WAIT_CTX_get_all_fds OPENSSL_MANGLER_ASM(ASYNC_WAIT_CTX_get_all_fds)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_WAIT_CTX_get_changed_fds
#  define ASYNC_WAIT_CTX_get_changed_fds OPENSSL_MANGLER(ASYNC_WAIT_CTX_get_changed_fds)
# endif
#else
# ifndef _ASYNC_WAIT_CTX_get_changed_fds
#  define _ASYNC_WAIT_CTX_get_changed_fds OPENSSL_MANGLER_ASM(ASYNC_WAIT_CTX_get_changed_fds)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_WAIT_CTX_get_fd
#  define ASYNC_WAIT_CTX_get_fd OPENSSL_MANGLER(ASYNC_WAIT_CTX_get_fd)
# endif
#else
# ifndef _ASYNC_WAIT_CTX_get_fd
#  define _ASYNC_WAIT_CTX_get_fd OPENSSL_MANGLER_ASM(ASYNC_WAIT_CTX_get_fd)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_WAIT_CTX_new
#  define ASYNC_WAIT_CTX_new OPENSSL_MANGLER(ASYNC_WAIT_CTX_new)
# endif
#else
# ifndef _ASYNC_WAIT_CTX_new
#  define _ASYNC_WAIT_CTX_new OPENSSL_MANGLER_ASM(ASYNC_WAIT_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef async_wait_ctx_reset_counts
#  define async_wait_ctx_reset_counts OPENSSL_MANGLER(async_wait_ctx_reset_counts)
# endif
#else
# ifndef _async_wait_ctx_reset_counts
#  define _async_wait_ctx_reset_counts OPENSSL_MANGLER_ASM(async_wait_ctx_reset_counts)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ASYNC_WAIT_CTX_set_wait_fd
#  define ASYNC_WAIT_CTX_set_wait_fd OPENSSL_MANGLER(ASYNC_WAIT_CTX_set_wait_fd)
# endif
#else
# ifndef _ASYNC_WAIT_CTX_set_wait_fd
#  define _ASYNC_WAIT_CTX_set_wait_fd OPENSSL_MANGLER_ASM(ASYNC_WAIT_CTX_set_wait_fd)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AUTHORITY_INFO_ACCESS_free
#  define AUTHORITY_INFO_ACCESS_free OPENSSL_MANGLER(AUTHORITY_INFO_ACCESS_free)
# endif
#else
# ifndef _AUTHORITY_INFO_ACCESS_free
#  define _AUTHORITY_INFO_ACCESS_free OPENSSL_MANGLER_ASM(AUTHORITY_INFO_ACCESS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AUTHORITY_INFO_ACCESS_it
#  define AUTHORITY_INFO_ACCESS_it OPENSSL_MANGLER(AUTHORITY_INFO_ACCESS_it)
# endif
#else
# ifndef _AUTHORITY_INFO_ACCESS_it
#  define _AUTHORITY_INFO_ACCESS_it OPENSSL_MANGLER_ASM(AUTHORITY_INFO_ACCESS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AUTHORITY_INFO_ACCESS_new
#  define AUTHORITY_INFO_ACCESS_new OPENSSL_MANGLER(AUTHORITY_INFO_ACCESS_new)
# endif
#else
# ifndef _AUTHORITY_INFO_ACCESS_new
#  define _AUTHORITY_INFO_ACCESS_new OPENSSL_MANGLER_ASM(AUTHORITY_INFO_ACCESS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AUTHORITY_KEYID_free
#  define AUTHORITY_KEYID_free OPENSSL_MANGLER(AUTHORITY_KEYID_free)
# endif
#else
# ifndef _AUTHORITY_KEYID_free
#  define _AUTHORITY_KEYID_free OPENSSL_MANGLER_ASM(AUTHORITY_KEYID_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AUTHORITY_KEYID_it
#  define AUTHORITY_KEYID_it OPENSSL_MANGLER(AUTHORITY_KEYID_it)
# endif
#else
# ifndef _AUTHORITY_KEYID_it
#  define _AUTHORITY_KEYID_it OPENSSL_MANGLER_ASM(AUTHORITY_KEYID_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef AUTHORITY_KEYID_new
#  define AUTHORITY_KEYID_new OPENSSL_MANGLER(AUTHORITY_KEYID_new)
# endif
#else
# ifndef _AUTHORITY_KEYID_new
#  define _AUTHORITY_KEYID_new OPENSSL_MANGLER_ASM(AUTHORITY_KEYID_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef b2i_PrivateKey
#  define b2i_PrivateKey OPENSSL_MANGLER(b2i_PrivateKey)
# endif
#else
# ifndef _b2i_PrivateKey
#  define _b2i_PrivateKey OPENSSL_MANGLER_ASM(b2i_PrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef b2i_PrivateKey_bio
#  define b2i_PrivateKey_bio OPENSSL_MANGLER(b2i_PrivateKey_bio)
# endif
#else
# ifndef _b2i_PrivateKey_bio
#  define _b2i_PrivateKey_bio OPENSSL_MANGLER_ASM(b2i_PrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef b2i_PublicKey
#  define b2i_PublicKey OPENSSL_MANGLER(b2i_PublicKey)
# endif
#else
# ifndef _b2i_PublicKey
#  define _b2i_PublicKey OPENSSL_MANGLER_ASM(b2i_PublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef b2i_PublicKey_bio
#  define b2i_PublicKey_bio OPENSSL_MANGLER(b2i_PublicKey_bio)
# endif
#else
# ifndef _b2i_PublicKey_bio
#  define _b2i_PublicKey_bio OPENSSL_MANGLER_ASM(b2i_PublicKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef b2i_PVK_bio
#  define b2i_PVK_bio OPENSSL_MANGLER(b2i_PVK_bio)
# endif
#else
# ifndef _b2i_PVK_bio
#  define _b2i_PVK_bio OPENSSL_MANGLER_ASM(b2i_PVK_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BASIC_CONSTRAINTS_free
#  define BASIC_CONSTRAINTS_free OPENSSL_MANGLER(BASIC_CONSTRAINTS_free)
# endif
#else
# ifndef _BASIC_CONSTRAINTS_free
#  define _BASIC_CONSTRAINTS_free OPENSSL_MANGLER_ASM(BASIC_CONSTRAINTS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BASIC_CONSTRAINTS_it
#  define BASIC_CONSTRAINTS_it OPENSSL_MANGLER(BASIC_CONSTRAINTS_it)
# endif
#else
# ifndef _BASIC_CONSTRAINTS_it
#  define _BASIC_CONSTRAINTS_it OPENSSL_MANGLER_ASM(BASIC_CONSTRAINTS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BASIC_CONSTRAINTS_new
#  define BASIC_CONSTRAINTS_new OPENSSL_MANGLER(BASIC_CONSTRAINTS_new)
# endif
#else
# ifndef _BASIC_CONSTRAINTS_new
#  define _BASIC_CONSTRAINTS_new OPENSSL_MANGLER_ASM(BASIC_CONSTRAINTS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BF_cbc_encrypt
#  define BF_cbc_encrypt OPENSSL_MANGLER(BF_cbc_encrypt)
# endif
#else
# ifndef _BF_cbc_encrypt
#  define _BF_cbc_encrypt OPENSSL_MANGLER_ASM(BF_cbc_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BF_cfb64_encrypt
#  define BF_cfb64_encrypt OPENSSL_MANGLER(BF_cfb64_encrypt)
# endif
#else
# ifndef _BF_cfb64_encrypt
#  define _BF_cfb64_encrypt OPENSSL_MANGLER_ASM(BF_cfb64_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BF_decrypt
#  define BF_decrypt OPENSSL_MANGLER(BF_decrypt)
# endif
#else
# ifndef _BF_decrypt
#  define _BF_decrypt OPENSSL_MANGLER_ASM(BF_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BF_ecb_encrypt
#  define BF_ecb_encrypt OPENSSL_MANGLER(BF_ecb_encrypt)
# endif
#else
# ifndef _BF_ecb_encrypt
#  define _BF_ecb_encrypt OPENSSL_MANGLER_ASM(BF_ecb_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BF_encrypt
#  define BF_encrypt OPENSSL_MANGLER(BF_encrypt)
# endif
#else
# ifndef _BF_encrypt
#  define _BF_encrypt OPENSSL_MANGLER_ASM(BF_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BF_ofb64_encrypt
#  define BF_ofb64_encrypt OPENSSL_MANGLER(BF_ofb64_encrypt)
# endif
#else
# ifndef _BF_ofb64_encrypt
#  define _BF_ofb64_encrypt OPENSSL_MANGLER_ASM(BF_ofb64_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BF_options
#  define BF_options OPENSSL_MANGLER(BF_options)
# endif
#else
# ifndef _BF_options
#  define _BF_options OPENSSL_MANGLER_ASM(BF_options)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BF_set_key
#  define BF_set_key OPENSSL_MANGLER(BF_set_key)
# endif
#else
# ifndef _BF_set_key
#  define _BF_set_key OPENSSL_MANGLER_ASM(BF_set_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_const_2
#  define _bignum_const_2 OPENSSL_MANGLER(_bignum_const_2)
# endif
#else
# ifndef __bignum_const_2
#  define __bignum_const_2 OPENSSL_MANGLER_ASM(_bignum_const_2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_dh1024_160_g
#  define _bignum_dh1024_160_g OPENSSL_MANGLER(_bignum_dh1024_160_g)
# endif
#else
# ifndef __bignum_dh1024_160_g
#  define __bignum_dh1024_160_g OPENSSL_MANGLER_ASM(_bignum_dh1024_160_g)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_dh1024_160_p
#  define _bignum_dh1024_160_p OPENSSL_MANGLER(_bignum_dh1024_160_p)
# endif
#else
# ifndef __bignum_dh1024_160_p
#  define __bignum_dh1024_160_p OPENSSL_MANGLER_ASM(_bignum_dh1024_160_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_dh1024_160_q
#  define _bignum_dh1024_160_q OPENSSL_MANGLER(_bignum_dh1024_160_q)
# endif
#else
# ifndef __bignum_dh1024_160_q
#  define __bignum_dh1024_160_q OPENSSL_MANGLER_ASM(_bignum_dh1024_160_q)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_dh2048_224_g
#  define _bignum_dh2048_224_g OPENSSL_MANGLER(_bignum_dh2048_224_g)
# endif
#else
# ifndef __bignum_dh2048_224_g
#  define __bignum_dh2048_224_g OPENSSL_MANGLER_ASM(_bignum_dh2048_224_g)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_dh2048_224_p
#  define _bignum_dh2048_224_p OPENSSL_MANGLER(_bignum_dh2048_224_p)
# endif
#else
# ifndef __bignum_dh2048_224_p
#  define __bignum_dh2048_224_p OPENSSL_MANGLER_ASM(_bignum_dh2048_224_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_dh2048_224_q
#  define _bignum_dh2048_224_q OPENSSL_MANGLER(_bignum_dh2048_224_q)
# endif
#else
# ifndef __bignum_dh2048_224_q
#  define __bignum_dh2048_224_q OPENSSL_MANGLER_ASM(_bignum_dh2048_224_q)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_dh2048_256_g
#  define _bignum_dh2048_256_g OPENSSL_MANGLER(_bignum_dh2048_256_g)
# endif
#else
# ifndef __bignum_dh2048_256_g
#  define __bignum_dh2048_256_g OPENSSL_MANGLER_ASM(_bignum_dh2048_256_g)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_dh2048_256_p
#  define _bignum_dh2048_256_p OPENSSL_MANGLER(_bignum_dh2048_256_p)
# endif
#else
# ifndef __bignum_dh2048_256_p
#  define __bignum_dh2048_256_p OPENSSL_MANGLER_ASM(_bignum_dh2048_256_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_dh2048_256_q
#  define _bignum_dh2048_256_q OPENSSL_MANGLER(_bignum_dh2048_256_q)
# endif
#else
# ifndef __bignum_dh2048_256_q
#  define __bignum_dh2048_256_q OPENSSL_MANGLER_ASM(_bignum_dh2048_256_q)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_ffdhe2048_p
#  define _bignum_ffdhe2048_p OPENSSL_MANGLER(_bignum_ffdhe2048_p)
# endif
#else
# ifndef __bignum_ffdhe2048_p
#  define __bignum_ffdhe2048_p OPENSSL_MANGLER_ASM(_bignum_ffdhe2048_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_ffdhe3072_p
#  define _bignum_ffdhe3072_p OPENSSL_MANGLER(_bignum_ffdhe3072_p)
# endif
#else
# ifndef __bignum_ffdhe3072_p
#  define __bignum_ffdhe3072_p OPENSSL_MANGLER_ASM(_bignum_ffdhe3072_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_ffdhe4096_p
#  define _bignum_ffdhe4096_p OPENSSL_MANGLER(_bignum_ffdhe4096_p)
# endif
#else
# ifndef __bignum_ffdhe4096_p
#  define __bignum_ffdhe4096_p OPENSSL_MANGLER_ASM(_bignum_ffdhe4096_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_ffdhe6144_p
#  define _bignum_ffdhe6144_p OPENSSL_MANGLER(_bignum_ffdhe6144_p)
# endif
#else
# ifndef __bignum_ffdhe6144_p
#  define __bignum_ffdhe6144_p OPENSSL_MANGLER_ASM(_bignum_ffdhe6144_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _bignum_ffdhe8192_p
#  define _bignum_ffdhe8192_p OPENSSL_MANGLER(_bignum_ffdhe8192_p)
# endif
#else
# ifndef __bignum_ffdhe8192_p
#  define __bignum_ffdhe8192_p OPENSSL_MANGLER_ASM(_bignum_ffdhe8192_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIGNUM_it
#  define BIGNUM_it OPENSSL_MANGLER(BIGNUM_it)
# endif
#else
# ifndef _BIGNUM_it
#  define _BIGNUM_it OPENSSL_MANGLER_ASM(BIGNUM_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_accept
#  define BIO_accept OPENSSL_MANGLER(BIO_accept)
# endif
#else
# ifndef _BIO_accept
#  define _BIO_accept OPENSSL_MANGLER_ASM(BIO_accept)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_accept_ex
#  define BIO_accept_ex OPENSSL_MANGLER(BIO_accept_ex)
# endif
#else
# ifndef _BIO_accept_ex
#  define _BIO_accept_ex OPENSSL_MANGLER_ASM(BIO_accept_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_clear
#  define BIO_ADDR_clear OPENSSL_MANGLER(BIO_ADDR_clear)
# endif
#else
# ifndef _BIO_ADDR_clear
#  define _BIO_ADDR_clear OPENSSL_MANGLER_ASM(BIO_ADDR_clear)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_family
#  define BIO_ADDR_family OPENSSL_MANGLER(BIO_ADDR_family)
# endif
#else
# ifndef _BIO_ADDR_family
#  define _BIO_ADDR_family OPENSSL_MANGLER_ASM(BIO_ADDR_family)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_free
#  define BIO_ADDR_free OPENSSL_MANGLER(BIO_ADDR_free)
# endif
#else
# ifndef _BIO_ADDR_free
#  define _BIO_ADDR_free OPENSSL_MANGLER_ASM(BIO_ADDR_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_hostname_string
#  define BIO_ADDR_hostname_string OPENSSL_MANGLER(BIO_ADDR_hostname_string)
# endif
#else
# ifndef _BIO_ADDR_hostname_string
#  define _BIO_ADDR_hostname_string OPENSSL_MANGLER_ASM(BIO_ADDR_hostname_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDRINFO_address
#  define BIO_ADDRINFO_address OPENSSL_MANGLER(BIO_ADDRINFO_address)
# endif
#else
# ifndef _BIO_ADDRINFO_address
#  define _BIO_ADDRINFO_address OPENSSL_MANGLER_ASM(BIO_ADDRINFO_address)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDRINFO_family
#  define BIO_ADDRINFO_family OPENSSL_MANGLER(BIO_ADDRINFO_family)
# endif
#else
# ifndef _BIO_ADDRINFO_family
#  define _BIO_ADDRINFO_family OPENSSL_MANGLER_ASM(BIO_ADDRINFO_family)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDRINFO_free
#  define BIO_ADDRINFO_free OPENSSL_MANGLER(BIO_ADDRINFO_free)
# endif
#else
# ifndef _BIO_ADDRINFO_free
#  define _BIO_ADDRINFO_free OPENSSL_MANGLER_ASM(BIO_ADDRINFO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDRINFO_next
#  define BIO_ADDRINFO_next OPENSSL_MANGLER(BIO_ADDRINFO_next)
# endif
#else
# ifndef _BIO_ADDRINFO_next
#  define _BIO_ADDRINFO_next OPENSSL_MANGLER_ASM(BIO_ADDRINFO_next)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDRINFO_protocol
#  define BIO_ADDRINFO_protocol OPENSSL_MANGLER(BIO_ADDRINFO_protocol)
# endif
#else
# ifndef _BIO_ADDRINFO_protocol
#  define _BIO_ADDRINFO_protocol OPENSSL_MANGLER_ASM(BIO_ADDRINFO_protocol)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDRINFO_sockaddr
#  define BIO_ADDRINFO_sockaddr OPENSSL_MANGLER(BIO_ADDRINFO_sockaddr)
# endif
#else
# ifndef _BIO_ADDRINFO_sockaddr
#  define _BIO_ADDRINFO_sockaddr OPENSSL_MANGLER_ASM(BIO_ADDRINFO_sockaddr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDRINFO_sockaddr_size
#  define BIO_ADDRINFO_sockaddr_size OPENSSL_MANGLER(BIO_ADDRINFO_sockaddr_size)
# endif
#else
# ifndef _BIO_ADDRINFO_sockaddr_size
#  define _BIO_ADDRINFO_sockaddr_size OPENSSL_MANGLER_ASM(BIO_ADDRINFO_sockaddr_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDRINFO_socktype
#  define BIO_ADDRINFO_socktype OPENSSL_MANGLER(BIO_ADDRINFO_socktype)
# endif
#else
# ifndef _BIO_ADDRINFO_socktype
#  define _BIO_ADDRINFO_socktype OPENSSL_MANGLER_ASM(BIO_ADDRINFO_socktype)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_make
#  define BIO_ADDR_make OPENSSL_MANGLER(BIO_ADDR_make)
# endif
#else
# ifndef _BIO_ADDR_make
#  define _BIO_ADDR_make OPENSSL_MANGLER_ASM(BIO_ADDR_make)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_new
#  define BIO_ADDR_new OPENSSL_MANGLER(BIO_ADDR_new)
# endif
#else
# ifndef _BIO_ADDR_new
#  define _BIO_ADDR_new OPENSSL_MANGLER_ASM(BIO_ADDR_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_path_string
#  define BIO_ADDR_path_string OPENSSL_MANGLER(BIO_ADDR_path_string)
# endif
#else
# ifndef _BIO_ADDR_path_string
#  define _BIO_ADDR_path_string OPENSSL_MANGLER_ASM(BIO_ADDR_path_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_rawaddress
#  define BIO_ADDR_rawaddress OPENSSL_MANGLER(BIO_ADDR_rawaddress)
# endif
#else
# ifndef _BIO_ADDR_rawaddress
#  define _BIO_ADDR_rawaddress OPENSSL_MANGLER_ASM(BIO_ADDR_rawaddress)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_rawmake
#  define BIO_ADDR_rawmake OPENSSL_MANGLER(BIO_ADDR_rawmake)
# endif
#else
# ifndef _BIO_ADDR_rawmake
#  define _BIO_ADDR_rawmake OPENSSL_MANGLER_ASM(BIO_ADDR_rawmake)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_rawport
#  define BIO_ADDR_rawport OPENSSL_MANGLER(BIO_ADDR_rawport)
# endif
#else
# ifndef _BIO_ADDR_rawport
#  define _BIO_ADDR_rawport OPENSSL_MANGLER_ASM(BIO_ADDR_rawport)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_service_string
#  define BIO_ADDR_service_string OPENSSL_MANGLER(BIO_ADDR_service_string)
# endif
#else
# ifndef _BIO_ADDR_service_string
#  define _BIO_ADDR_service_string OPENSSL_MANGLER_ASM(BIO_ADDR_service_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_sockaddr
#  define BIO_ADDR_sockaddr OPENSSL_MANGLER(BIO_ADDR_sockaddr)
# endif
#else
# ifndef _BIO_ADDR_sockaddr
#  define _BIO_ADDR_sockaddr OPENSSL_MANGLER_ASM(BIO_ADDR_sockaddr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_sockaddr_noconst
#  define BIO_ADDR_sockaddr_noconst OPENSSL_MANGLER(BIO_ADDR_sockaddr_noconst)
# endif
#else
# ifndef _BIO_ADDR_sockaddr_noconst
#  define _BIO_ADDR_sockaddr_noconst OPENSSL_MANGLER_ASM(BIO_ADDR_sockaddr_noconst)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ADDR_sockaddr_size
#  define BIO_ADDR_sockaddr_size OPENSSL_MANGLER(BIO_ADDR_sockaddr_size)
# endif
#else
# ifndef _BIO_ADDR_sockaddr_size
#  define _BIO_ADDR_sockaddr_size OPENSSL_MANGLER_ASM(BIO_ADDR_sockaddr_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_asn1_get_prefix
#  define BIO_asn1_get_prefix OPENSSL_MANGLER(BIO_asn1_get_prefix)
# endif
#else
# ifndef _BIO_asn1_get_prefix
#  define _BIO_asn1_get_prefix OPENSSL_MANGLER_ASM(BIO_asn1_get_prefix)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_asn1_get_suffix
#  define BIO_asn1_get_suffix OPENSSL_MANGLER(BIO_asn1_get_suffix)
# endif
#else
# ifndef _BIO_asn1_get_suffix
#  define _BIO_asn1_get_suffix OPENSSL_MANGLER_ASM(BIO_asn1_get_suffix)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_asn1_set_prefix
#  define BIO_asn1_set_prefix OPENSSL_MANGLER(BIO_asn1_set_prefix)
# endif
#else
# ifndef _BIO_asn1_set_prefix
#  define _BIO_asn1_set_prefix OPENSSL_MANGLER_ASM(BIO_asn1_set_prefix)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_asn1_set_suffix
#  define BIO_asn1_set_suffix OPENSSL_MANGLER(BIO_asn1_set_suffix)
# endif
#else
# ifndef _BIO_asn1_set_suffix
#  define _BIO_asn1_set_suffix OPENSSL_MANGLER_ASM(BIO_asn1_set_suffix)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_bind
#  define BIO_bind OPENSSL_MANGLER(BIO_bind)
# endif
#else
# ifndef _BIO_bind
#  define _BIO_bind OPENSSL_MANGLER_ASM(BIO_bind)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_callback_ctrl
#  define BIO_callback_ctrl OPENSSL_MANGLER(BIO_callback_ctrl)
# endif
#else
# ifndef _BIO_callback_ctrl
#  define _BIO_callback_ctrl OPENSSL_MANGLER_ASM(BIO_callback_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bio_cleanup
#  define bio_cleanup OPENSSL_MANGLER(bio_cleanup)
# endif
#else
# ifndef _bio_cleanup
#  define _bio_cleanup OPENSSL_MANGLER_ASM(bio_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_clear_flags
#  define BIO_clear_flags OPENSSL_MANGLER(BIO_clear_flags)
# endif
#else
# ifndef _BIO_clear_flags
#  define _BIO_clear_flags OPENSSL_MANGLER_ASM(BIO_clear_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_closesocket
#  define BIO_closesocket OPENSSL_MANGLER(BIO_closesocket)
# endif
#else
# ifndef _BIO_closesocket
#  define _BIO_closesocket OPENSSL_MANGLER_ASM(BIO_closesocket)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_connect
#  define BIO_connect OPENSSL_MANGLER(BIO_connect)
# endif
#else
# ifndef _BIO_connect
#  define _BIO_connect OPENSSL_MANGLER_ASM(BIO_connect)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_CONNECT_free
#  define BIO_CONNECT_free OPENSSL_MANGLER(BIO_CONNECT_free)
# endif
#else
# ifndef _BIO_CONNECT_free
#  define _BIO_CONNECT_free OPENSSL_MANGLER_ASM(BIO_CONNECT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_CONNECT_new
#  define BIO_CONNECT_new OPENSSL_MANGLER(BIO_CONNECT_new)
# endif
#else
# ifndef _BIO_CONNECT_new
#  define _BIO_CONNECT_new OPENSSL_MANGLER_ASM(BIO_CONNECT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_copy_next_retry
#  define BIO_copy_next_retry OPENSSL_MANGLER(BIO_copy_next_retry)
# endif
#else
# ifndef _BIO_copy_next_retry
#  define _BIO_copy_next_retry OPENSSL_MANGLER_ASM(BIO_copy_next_retry)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ctrl
#  define BIO_ctrl OPENSSL_MANGLER(BIO_ctrl)
# endif
#else
# ifndef _BIO_ctrl
#  define _BIO_ctrl OPENSSL_MANGLER_ASM(BIO_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ctrl_get_read_request
#  define BIO_ctrl_get_read_request OPENSSL_MANGLER(BIO_ctrl_get_read_request)
# endif
#else
# ifndef _BIO_ctrl_get_read_request
#  define _BIO_ctrl_get_read_request OPENSSL_MANGLER_ASM(BIO_ctrl_get_read_request)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ctrl_get_write_guarantee
#  define BIO_ctrl_get_write_guarantee OPENSSL_MANGLER(BIO_ctrl_get_write_guarantee)
# endif
#else
# ifndef _BIO_ctrl_get_write_guarantee
#  define _BIO_ctrl_get_write_guarantee OPENSSL_MANGLER_ASM(BIO_ctrl_get_write_guarantee)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ctrl_pending
#  define BIO_ctrl_pending OPENSSL_MANGLER(BIO_ctrl_pending)
# endif
#else
# ifndef _BIO_ctrl_pending
#  define _BIO_ctrl_pending OPENSSL_MANGLER_ASM(BIO_ctrl_pending)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ctrl_reset_read_request
#  define BIO_ctrl_reset_read_request OPENSSL_MANGLER(BIO_ctrl_reset_read_request)
# endif
#else
# ifndef _BIO_ctrl_reset_read_request
#  define _BIO_ctrl_reset_read_request OPENSSL_MANGLER_ASM(BIO_ctrl_reset_read_request)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ctrl_wpending
#  define BIO_ctrl_wpending OPENSSL_MANGLER(BIO_ctrl_wpending)
# endif
#else
# ifndef _BIO_ctrl_wpending
#  define _BIO_ctrl_wpending OPENSSL_MANGLER_ASM(BIO_ctrl_wpending)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_debug_callback
#  define BIO_debug_callback OPENSSL_MANGLER(BIO_debug_callback)
# endif
#else
# ifndef _BIO_debug_callback
#  define _BIO_debug_callback OPENSSL_MANGLER_ASM(BIO_debug_callback)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_dgram_non_fatal_error
#  define BIO_dgram_non_fatal_error OPENSSL_MANGLER(BIO_dgram_non_fatal_error)
# endif
#else
# ifndef _BIO_dgram_non_fatal_error
#  define _BIO_dgram_non_fatal_error OPENSSL_MANGLER_ASM(BIO_dgram_non_fatal_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_dump
#  define BIO_dump OPENSSL_MANGLER(BIO_dump)
# endif
#else
# ifndef _BIO_dump
#  define _BIO_dump OPENSSL_MANGLER_ASM(BIO_dump)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_dump_cb
#  define BIO_dump_cb OPENSSL_MANGLER(BIO_dump_cb)
# endif
#else
# ifndef _BIO_dump_cb
#  define _BIO_dump_cb OPENSSL_MANGLER_ASM(BIO_dump_cb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_dump_fp
#  define BIO_dump_fp OPENSSL_MANGLER(BIO_dump_fp)
# endif
#else
# ifndef _BIO_dump_fp
#  define _BIO_dump_fp OPENSSL_MANGLER_ASM(BIO_dump_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_dump_indent
#  define BIO_dump_indent OPENSSL_MANGLER(BIO_dump_indent)
# endif
#else
# ifndef _BIO_dump_indent
#  define _BIO_dump_indent OPENSSL_MANGLER_ASM(BIO_dump_indent)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_dump_indent_cb
#  define BIO_dump_indent_cb OPENSSL_MANGLER(BIO_dump_indent_cb)
# endif
#else
# ifndef _BIO_dump_indent_cb
#  define _BIO_dump_indent_cb OPENSSL_MANGLER_ASM(BIO_dump_indent_cb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_dump_indent_fp
#  define BIO_dump_indent_fp OPENSSL_MANGLER(BIO_dump_indent_fp)
# endif
#else
# ifndef _BIO_dump_indent_fp
#  define _BIO_dump_indent_fp OPENSSL_MANGLER_ASM(BIO_dump_indent_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_dup_chain
#  define BIO_dup_chain OPENSSL_MANGLER(BIO_dup_chain)
# endif
#else
# ifndef _BIO_dup_chain
#  define _BIO_dup_chain OPENSSL_MANGLER_ASM(BIO_dup_chain)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_f_asn1
#  define BIO_f_asn1 OPENSSL_MANGLER(BIO_f_asn1)
# endif
#else
# ifndef _BIO_f_asn1
#  define _BIO_f_asn1 OPENSSL_MANGLER_ASM(BIO_f_asn1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_f_base64
#  define BIO_f_base64 OPENSSL_MANGLER(BIO_f_base64)
# endif
#else
# ifndef _BIO_f_base64
#  define _BIO_f_base64 OPENSSL_MANGLER_ASM(BIO_f_base64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_f_buffer
#  define BIO_f_buffer OPENSSL_MANGLER(BIO_f_buffer)
# endif
#else
# ifndef _BIO_f_buffer
#  define _BIO_f_buffer OPENSSL_MANGLER_ASM(BIO_f_buffer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_f_cipher
#  define BIO_f_cipher OPENSSL_MANGLER(BIO_f_cipher)
# endif
#else
# ifndef _BIO_f_cipher
#  define _BIO_f_cipher OPENSSL_MANGLER_ASM(BIO_f_cipher)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_fd_non_fatal_error
#  define BIO_fd_non_fatal_error OPENSSL_MANGLER(BIO_fd_non_fatal_error)
# endif
#else
# ifndef _BIO_fd_non_fatal_error
#  define _BIO_fd_non_fatal_error OPENSSL_MANGLER_ASM(BIO_fd_non_fatal_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_fd_should_retry
#  define BIO_fd_should_retry OPENSSL_MANGLER(BIO_fd_should_retry)
# endif
#else
# ifndef _BIO_fd_should_retry
#  define _BIO_fd_should_retry OPENSSL_MANGLER_ASM(BIO_fd_should_retry)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_find_type
#  define BIO_find_type OPENSSL_MANGLER(BIO_find_type)
# endif
#else
# ifndef _BIO_find_type
#  define _BIO_find_type OPENSSL_MANGLER_ASM(BIO_find_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_f_linebuffer
#  define BIO_f_linebuffer OPENSSL_MANGLER(BIO_f_linebuffer)
# endif
#else
# ifndef _BIO_f_linebuffer
#  define _BIO_f_linebuffer OPENSSL_MANGLER_ASM(BIO_f_linebuffer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_f_md
#  define BIO_f_md OPENSSL_MANGLER(BIO_f_md)
# endif
#else
# ifndef _BIO_f_md
#  define _BIO_f_md OPENSSL_MANGLER_ASM(BIO_f_md)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_f_nbio_test
#  define BIO_f_nbio_test OPENSSL_MANGLER(BIO_f_nbio_test)
# endif
#else
# ifndef _BIO_f_nbio_test
#  define _BIO_f_nbio_test OPENSSL_MANGLER_ASM(BIO_f_nbio_test)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_f_null
#  define BIO_f_null OPENSSL_MANGLER(BIO_f_null)
# endif
#else
# ifndef _BIO_f_null
#  define _BIO_f_null OPENSSL_MANGLER_ASM(BIO_f_null)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_free
#  define BIO_free OPENSSL_MANGLER(BIO_free)
# endif
#else
# ifndef _BIO_free
#  define _BIO_free OPENSSL_MANGLER_ASM(BIO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_free_all
#  define BIO_free_all OPENSSL_MANGLER(BIO_free_all)
# endif
#else
# ifndef _BIO_free_all
#  define _BIO_free_all OPENSSL_MANGLER_ASM(BIO_free_all)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bio_free_ex_data
#  define bio_free_ex_data OPENSSL_MANGLER(bio_free_ex_data)
# endif
#else
# ifndef _bio_free_ex_data
#  define _bio_free_ex_data OPENSSL_MANGLER_ASM(bio_free_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_f_reliable
#  define BIO_f_reliable OPENSSL_MANGLER(BIO_f_reliable)
# endif
#else
# ifndef _BIO_f_reliable
#  define _BIO_f_reliable OPENSSL_MANGLER_ASM(BIO_f_reliable)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_f_ssl
#  define BIO_f_ssl OPENSSL_MANGLER(BIO_f_ssl)
# endif
#else
# ifndef _BIO_f_ssl
#  define _BIO_f_ssl OPENSSL_MANGLER_ASM(BIO_f_ssl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_accept_socket
#  define BIO_get_accept_socket OPENSSL_MANGLER(BIO_get_accept_socket)
# endif
#else
# ifndef _BIO_get_accept_socket
#  define _BIO_get_accept_socket OPENSSL_MANGLER_ASM(BIO_get_accept_socket)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_callback
#  define BIO_get_callback OPENSSL_MANGLER(BIO_get_callback)
# endif
#else
# ifndef _BIO_get_callback
#  define _BIO_get_callback OPENSSL_MANGLER_ASM(BIO_get_callback)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_callback_arg
#  define BIO_get_callback_arg OPENSSL_MANGLER(BIO_get_callback_arg)
# endif
#else
# ifndef _BIO_get_callback_arg
#  define _BIO_get_callback_arg OPENSSL_MANGLER_ASM(BIO_get_callback_arg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_callback_ex
#  define BIO_get_callback_ex OPENSSL_MANGLER(BIO_get_callback_ex)
# endif
#else
# ifndef _BIO_get_callback_ex
#  define _BIO_get_callback_ex OPENSSL_MANGLER_ASM(BIO_get_callback_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_data
#  define BIO_get_data OPENSSL_MANGLER(BIO_get_data)
# endif
#else
# ifndef _BIO_get_data
#  define _BIO_get_data OPENSSL_MANGLER_ASM(BIO_get_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_ex_data
#  define BIO_get_ex_data OPENSSL_MANGLER(BIO_get_ex_data)
# endif
#else
# ifndef _BIO_get_ex_data
#  define _BIO_get_ex_data OPENSSL_MANGLER_ASM(BIO_get_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_gethostbyname
#  define BIO_gethostbyname OPENSSL_MANGLER(BIO_gethostbyname)
# endif
#else
# ifndef _BIO_gethostbyname
#  define _BIO_gethostbyname OPENSSL_MANGLER_ASM(BIO_gethostbyname)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_host_ip
#  define BIO_get_host_ip OPENSSL_MANGLER(BIO_get_host_ip)
# endif
#else
# ifndef _BIO_get_host_ip
#  define _BIO_get_host_ip OPENSSL_MANGLER_ASM(BIO_get_host_ip)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_init
#  define BIO_get_init OPENSSL_MANGLER(BIO_get_init)
# endif
#else
# ifndef _BIO_get_init
#  define _BIO_get_init OPENSSL_MANGLER_ASM(BIO_get_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_new_index
#  define BIO_get_new_index OPENSSL_MANGLER(BIO_get_new_index)
# endif
#else
# ifndef _BIO_get_new_index
#  define _BIO_get_new_index OPENSSL_MANGLER_ASM(BIO_get_new_index)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_port
#  define BIO_get_port OPENSSL_MANGLER(BIO_get_port)
# endif
#else
# ifndef _BIO_get_port
#  define _BIO_get_port OPENSSL_MANGLER_ASM(BIO_get_port)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_retry_BIO
#  define BIO_get_retry_BIO OPENSSL_MANGLER(BIO_get_retry_BIO)
# endif
#else
# ifndef _BIO_get_retry_BIO
#  define _BIO_get_retry_BIO OPENSSL_MANGLER_ASM(BIO_get_retry_BIO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_retry_reason
#  define BIO_get_retry_reason OPENSSL_MANGLER(BIO_get_retry_reason)
# endif
#else
# ifndef _BIO_get_retry_reason
#  define _BIO_get_retry_reason OPENSSL_MANGLER_ASM(BIO_get_retry_reason)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_gets
#  define BIO_gets OPENSSL_MANGLER(BIO_gets)
# endif
#else
# ifndef _BIO_gets
#  define _BIO_gets OPENSSL_MANGLER_ASM(BIO_gets)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_get_shutdown
#  define BIO_get_shutdown OPENSSL_MANGLER(BIO_get_shutdown)
# endif
#else
# ifndef _BIO_get_shutdown
#  define _BIO_get_shutdown OPENSSL_MANGLER_ASM(BIO_get_shutdown)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_hex_string
#  define BIO_hex_string OPENSSL_MANGLER(BIO_hex_string)
# endif
#else
# ifndef _BIO_hex_string
#  define _BIO_hex_string OPENSSL_MANGLER_ASM(BIO_hex_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_indent
#  define BIO_indent OPENSSL_MANGLER(BIO_indent)
# endif
#else
# ifndef _BIO_indent
#  define _BIO_indent OPENSSL_MANGLER_ASM(BIO_indent)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_int_ctrl
#  define BIO_int_ctrl OPENSSL_MANGLER(BIO_int_ctrl)
# endif
#else
# ifndef _BIO_int_ctrl
#  define _BIO_int_ctrl OPENSSL_MANGLER_ASM(BIO_int_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_listen
#  define BIO_listen OPENSSL_MANGLER(BIO_listen)
# endif
#else
# ifndef _BIO_listen
#  define _BIO_listen OPENSSL_MANGLER_ASM(BIO_listen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_lookup
#  define BIO_lookup OPENSSL_MANGLER(BIO_lookup)
# endif
#else
# ifndef _BIO_lookup
#  define _BIO_lookup OPENSSL_MANGLER_ASM(BIO_lookup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_lookup_ex
#  define BIO_lookup_ex OPENSSL_MANGLER(BIO_lookup_ex)
# endif
#else
# ifndef _BIO_lookup_ex
#  define _BIO_lookup_ex OPENSSL_MANGLER_ASM(BIO_lookup_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bio_lookup_lock
#  define bio_lookup_lock OPENSSL_MANGLER(bio_lookup_lock)
# endif
#else
# ifndef _bio_lookup_lock
#  define _bio_lookup_lock OPENSSL_MANGLER_ASM(bio_lookup_lock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_free
#  define BIO_meth_free OPENSSL_MANGLER(BIO_meth_free)
# endif
#else
# ifndef _BIO_meth_free
#  define _BIO_meth_free OPENSSL_MANGLER_ASM(BIO_meth_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_get_callback_ctrl
#  define BIO_meth_get_callback_ctrl OPENSSL_MANGLER(BIO_meth_get_callback_ctrl)
# endif
#else
# ifndef _BIO_meth_get_callback_ctrl
#  define _BIO_meth_get_callback_ctrl OPENSSL_MANGLER_ASM(BIO_meth_get_callback_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_get_create
#  define BIO_meth_get_create OPENSSL_MANGLER(BIO_meth_get_create)
# endif
#else
# ifndef _BIO_meth_get_create
#  define _BIO_meth_get_create OPENSSL_MANGLER_ASM(BIO_meth_get_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_get_ctrl
#  define BIO_meth_get_ctrl OPENSSL_MANGLER(BIO_meth_get_ctrl)
# endif
#else
# ifndef _BIO_meth_get_ctrl
#  define _BIO_meth_get_ctrl OPENSSL_MANGLER_ASM(BIO_meth_get_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_get_destroy
#  define BIO_meth_get_destroy OPENSSL_MANGLER(BIO_meth_get_destroy)
# endif
#else
# ifndef _BIO_meth_get_destroy
#  define _BIO_meth_get_destroy OPENSSL_MANGLER_ASM(BIO_meth_get_destroy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_get_gets
#  define BIO_meth_get_gets OPENSSL_MANGLER(BIO_meth_get_gets)
# endif
#else
# ifndef _BIO_meth_get_gets
#  define _BIO_meth_get_gets OPENSSL_MANGLER_ASM(BIO_meth_get_gets)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_get_puts
#  define BIO_meth_get_puts OPENSSL_MANGLER(BIO_meth_get_puts)
# endif
#else
# ifndef _BIO_meth_get_puts
#  define _BIO_meth_get_puts OPENSSL_MANGLER_ASM(BIO_meth_get_puts)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_get_read
#  define BIO_meth_get_read OPENSSL_MANGLER(BIO_meth_get_read)
# endif
#else
# ifndef _BIO_meth_get_read
#  define _BIO_meth_get_read OPENSSL_MANGLER_ASM(BIO_meth_get_read)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_get_read_ex
#  define BIO_meth_get_read_ex OPENSSL_MANGLER(BIO_meth_get_read_ex)
# endif
#else
# ifndef _BIO_meth_get_read_ex
#  define _BIO_meth_get_read_ex OPENSSL_MANGLER_ASM(BIO_meth_get_read_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_get_write
#  define BIO_meth_get_write OPENSSL_MANGLER(BIO_meth_get_write)
# endif
#else
# ifndef _BIO_meth_get_write
#  define _BIO_meth_get_write OPENSSL_MANGLER_ASM(BIO_meth_get_write)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_get_write_ex
#  define BIO_meth_get_write_ex OPENSSL_MANGLER(BIO_meth_get_write_ex)
# endif
#else
# ifndef _BIO_meth_get_write_ex
#  define _BIO_meth_get_write_ex OPENSSL_MANGLER_ASM(BIO_meth_get_write_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_new
#  define BIO_meth_new OPENSSL_MANGLER(BIO_meth_new)
# endif
#else
# ifndef _BIO_meth_new
#  define _BIO_meth_new OPENSSL_MANGLER_ASM(BIO_meth_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_method_name
#  define BIO_method_name OPENSSL_MANGLER(BIO_method_name)
# endif
#else
# ifndef _BIO_method_name
#  define _BIO_method_name OPENSSL_MANGLER_ASM(BIO_method_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_method_type
#  define BIO_method_type OPENSSL_MANGLER(BIO_method_type)
# endif
#else
# ifndef _BIO_method_type
#  define _BIO_method_type OPENSSL_MANGLER_ASM(BIO_method_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_set_callback_ctrl
#  define BIO_meth_set_callback_ctrl OPENSSL_MANGLER(BIO_meth_set_callback_ctrl)
# endif
#else
# ifndef _BIO_meth_set_callback_ctrl
#  define _BIO_meth_set_callback_ctrl OPENSSL_MANGLER_ASM(BIO_meth_set_callback_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_set_create
#  define BIO_meth_set_create OPENSSL_MANGLER(BIO_meth_set_create)
# endif
#else
# ifndef _BIO_meth_set_create
#  define _BIO_meth_set_create OPENSSL_MANGLER_ASM(BIO_meth_set_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_set_ctrl
#  define BIO_meth_set_ctrl OPENSSL_MANGLER(BIO_meth_set_ctrl)
# endif
#else
# ifndef _BIO_meth_set_ctrl
#  define _BIO_meth_set_ctrl OPENSSL_MANGLER_ASM(BIO_meth_set_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_set_destroy
#  define BIO_meth_set_destroy OPENSSL_MANGLER(BIO_meth_set_destroy)
# endif
#else
# ifndef _BIO_meth_set_destroy
#  define _BIO_meth_set_destroy OPENSSL_MANGLER_ASM(BIO_meth_set_destroy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_set_gets
#  define BIO_meth_set_gets OPENSSL_MANGLER(BIO_meth_set_gets)
# endif
#else
# ifndef _BIO_meth_set_gets
#  define _BIO_meth_set_gets OPENSSL_MANGLER_ASM(BIO_meth_set_gets)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_set_puts
#  define BIO_meth_set_puts OPENSSL_MANGLER(BIO_meth_set_puts)
# endif
#else
# ifndef _BIO_meth_set_puts
#  define _BIO_meth_set_puts OPENSSL_MANGLER_ASM(BIO_meth_set_puts)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_set_read
#  define BIO_meth_set_read OPENSSL_MANGLER(BIO_meth_set_read)
# endif
#else
# ifndef _BIO_meth_set_read
#  define _BIO_meth_set_read OPENSSL_MANGLER_ASM(BIO_meth_set_read)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_set_read_ex
#  define BIO_meth_set_read_ex OPENSSL_MANGLER(BIO_meth_set_read_ex)
# endif
#else
# ifndef _BIO_meth_set_read_ex
#  define _BIO_meth_set_read_ex OPENSSL_MANGLER_ASM(BIO_meth_set_read_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_set_write
#  define BIO_meth_set_write OPENSSL_MANGLER(BIO_meth_set_write)
# endif
#else
# ifndef _BIO_meth_set_write
#  define _BIO_meth_set_write OPENSSL_MANGLER_ASM(BIO_meth_set_write)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_meth_set_write_ex
#  define BIO_meth_set_write_ex OPENSSL_MANGLER(BIO_meth_set_write_ex)
# endif
#else
# ifndef _BIO_meth_set_write_ex
#  define _BIO_meth_set_write_ex OPENSSL_MANGLER_ASM(BIO_meth_set_write_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new
#  define BIO_new OPENSSL_MANGLER(BIO_new)
# endif
#else
# ifndef _BIO_new
#  define _BIO_new OPENSSL_MANGLER_ASM(BIO_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_accept
#  define BIO_new_accept OPENSSL_MANGLER(BIO_new_accept)
# endif
#else
# ifndef _BIO_new_accept
#  define _BIO_new_accept OPENSSL_MANGLER_ASM(BIO_new_accept)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_bio_pair
#  define BIO_new_bio_pair OPENSSL_MANGLER(BIO_new_bio_pair)
# endif
#else
# ifndef _BIO_new_bio_pair
#  define _BIO_new_bio_pair OPENSSL_MANGLER_ASM(BIO_new_bio_pair)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_buffer_ssl_connect
#  define BIO_new_buffer_ssl_connect OPENSSL_MANGLER(BIO_new_buffer_ssl_connect)
# endif
#else
# ifndef _BIO_new_buffer_ssl_connect
#  define _BIO_new_buffer_ssl_connect OPENSSL_MANGLER_ASM(BIO_new_buffer_ssl_connect)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_CMS
#  define BIO_new_CMS OPENSSL_MANGLER(BIO_new_CMS)
# endif
#else
# ifndef _BIO_new_CMS
#  define _BIO_new_CMS OPENSSL_MANGLER_ASM(BIO_new_CMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_connect
#  define BIO_new_connect OPENSSL_MANGLER(BIO_new_connect)
# endif
#else
# ifndef _BIO_new_connect
#  define _BIO_new_connect OPENSSL_MANGLER_ASM(BIO_new_connect)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_dgram
#  define BIO_new_dgram OPENSSL_MANGLER(BIO_new_dgram)
# endif
#else
# ifndef _BIO_new_dgram
#  define _BIO_new_dgram OPENSSL_MANGLER_ASM(BIO_new_dgram)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_fd
#  define BIO_new_fd OPENSSL_MANGLER(BIO_new_fd)
# endif
#else
# ifndef _BIO_new_fd
#  define _BIO_new_fd OPENSSL_MANGLER_ASM(BIO_new_fd)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_file
#  define BIO_new_file OPENSSL_MANGLER(BIO_new_file)
# endif
#else
# ifndef _BIO_new_file
#  define _BIO_new_file OPENSSL_MANGLER_ASM(BIO_new_file)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_fp
#  define BIO_new_fp OPENSSL_MANGLER(BIO_new_fp)
# endif
#else
# ifndef _BIO_new_fp
#  define _BIO_new_fp OPENSSL_MANGLER_ASM(BIO_new_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_mem_buf
#  define BIO_new_mem_buf OPENSSL_MANGLER(BIO_new_mem_buf)
# endif
#else
# ifndef _BIO_new_mem_buf
#  define _BIO_new_mem_buf OPENSSL_MANGLER_ASM(BIO_new_mem_buf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_NDEF
#  define BIO_new_NDEF OPENSSL_MANGLER(BIO_new_NDEF)
# endif
#else
# ifndef _BIO_new_NDEF
#  define _BIO_new_NDEF OPENSSL_MANGLER_ASM(BIO_new_NDEF)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_PKCS7
#  define BIO_new_PKCS7 OPENSSL_MANGLER(BIO_new_PKCS7)
# endif
#else
# ifndef _BIO_new_PKCS7
#  define _BIO_new_PKCS7 OPENSSL_MANGLER_ASM(BIO_new_PKCS7)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_socket
#  define BIO_new_socket OPENSSL_MANGLER(BIO_new_socket)
# endif
#else
# ifndef _BIO_new_socket
#  define _BIO_new_socket OPENSSL_MANGLER_ASM(BIO_new_socket)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_ssl
#  define BIO_new_ssl OPENSSL_MANGLER(BIO_new_ssl)
# endif
#else
# ifndef _BIO_new_ssl
#  define _BIO_new_ssl OPENSSL_MANGLER_ASM(BIO_new_ssl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_new_ssl_connect
#  define BIO_new_ssl_connect OPENSSL_MANGLER(BIO_new_ssl_connect)
# endif
#else
# ifndef _BIO_new_ssl_connect
#  define _BIO_new_ssl_connect OPENSSL_MANGLER_ASM(BIO_new_ssl_connect)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_next
#  define BIO_next OPENSSL_MANGLER(BIO_next)
# endif
#else
# ifndef _BIO_next
#  define _BIO_next OPENSSL_MANGLER_ASM(BIO_next)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_nread
#  define BIO_nread OPENSSL_MANGLER(BIO_nread)
# endif
#else
# ifndef _BIO_nread
#  define _BIO_nread OPENSSL_MANGLER_ASM(BIO_nread)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_nread0
#  define BIO_nread0 OPENSSL_MANGLER(BIO_nread0)
# endif
#else
# ifndef _BIO_nread0
#  define _BIO_nread0 OPENSSL_MANGLER_ASM(BIO_nread0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_number_read
#  define BIO_number_read OPENSSL_MANGLER(BIO_number_read)
# endif
#else
# ifndef _BIO_number_read
#  define _BIO_number_read OPENSSL_MANGLER_ASM(BIO_number_read)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_number_written
#  define BIO_number_written OPENSSL_MANGLER(BIO_number_written)
# endif
#else
# ifndef _BIO_number_written
#  define _BIO_number_written OPENSSL_MANGLER_ASM(BIO_number_written)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_nwrite
#  define BIO_nwrite OPENSSL_MANGLER(BIO_nwrite)
# endif
#else
# ifndef _BIO_nwrite
#  define _BIO_nwrite OPENSSL_MANGLER_ASM(BIO_nwrite)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_nwrite0
#  define BIO_nwrite0 OPENSSL_MANGLER(BIO_nwrite0)
# endif
#else
# ifndef _BIO_nwrite0
#  define _BIO_nwrite0 OPENSSL_MANGLER_ASM(BIO_nwrite0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_parse_hostserv
#  define BIO_parse_hostserv OPENSSL_MANGLER(BIO_parse_hostserv)
# endif
#else
# ifndef _BIO_parse_hostserv
#  define _BIO_parse_hostserv OPENSSL_MANGLER_ASM(BIO_parse_hostserv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_pop
#  define BIO_pop OPENSSL_MANGLER(BIO_pop)
# endif
#else
# ifndef _BIO_pop
#  define _BIO_pop OPENSSL_MANGLER_ASM(BIO_pop)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_printf
#  define BIO_printf OPENSSL_MANGLER(BIO_printf)
# endif
#else
# ifndef _BIO_printf
#  define _BIO_printf OPENSSL_MANGLER_ASM(BIO_printf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ptr_ctrl
#  define BIO_ptr_ctrl OPENSSL_MANGLER(BIO_ptr_ctrl)
# endif
#else
# ifndef _BIO_ptr_ctrl
#  define _BIO_ptr_ctrl OPENSSL_MANGLER_ASM(BIO_ptr_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_push
#  define BIO_push OPENSSL_MANGLER(BIO_push)
# endif
#else
# ifndef _BIO_push
#  define _BIO_push OPENSSL_MANGLER_ASM(BIO_push)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_puts
#  define BIO_puts OPENSSL_MANGLER(BIO_puts)
# endif
#else
# ifndef _BIO_puts
#  define _BIO_puts OPENSSL_MANGLER_ASM(BIO_puts)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_read
#  define BIO_read OPENSSL_MANGLER(BIO_read)
# endif
#else
# ifndef _BIO_read
#  define _BIO_read OPENSSL_MANGLER_ASM(BIO_read)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_read_ex
#  define BIO_read_ex OPENSSL_MANGLER(BIO_read_ex)
# endif
#else
# ifndef _BIO_read_ex
#  define _BIO_read_ex OPENSSL_MANGLER_ASM(BIO_read_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_accept
#  define BIO_s_accept OPENSSL_MANGLER(BIO_s_accept)
# endif
#else
# ifndef _BIO_s_accept
#  define _BIO_s_accept OPENSSL_MANGLER_ASM(BIO_s_accept)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_bio
#  define BIO_s_bio OPENSSL_MANGLER(BIO_s_bio)
# endif
#else
# ifndef _BIO_s_bio
#  define _BIO_s_bio OPENSSL_MANGLER_ASM(BIO_s_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_connect
#  define BIO_s_connect OPENSSL_MANGLER(BIO_s_connect)
# endif
#else
# ifndef _BIO_s_connect
#  define _BIO_s_connect OPENSSL_MANGLER_ASM(BIO_s_connect)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_datagram
#  define BIO_s_datagram OPENSSL_MANGLER(BIO_s_datagram)
# endif
#else
# ifndef _BIO_s_datagram
#  define _BIO_s_datagram OPENSSL_MANGLER_ASM(BIO_s_datagram)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_callback
#  define BIO_set_callback OPENSSL_MANGLER(BIO_set_callback)
# endif
#else
# ifndef _BIO_set_callback
#  define _BIO_set_callback OPENSSL_MANGLER_ASM(BIO_set_callback)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_callback_arg
#  define BIO_set_callback_arg OPENSSL_MANGLER(BIO_set_callback_arg)
# endif
#else
# ifndef _BIO_set_callback_arg
#  define _BIO_set_callback_arg OPENSSL_MANGLER_ASM(BIO_set_callback_arg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_callback_ex
#  define BIO_set_callback_ex OPENSSL_MANGLER(BIO_set_callback_ex)
# endif
#else
# ifndef _BIO_set_callback_ex
#  define _BIO_set_callback_ex OPENSSL_MANGLER_ASM(BIO_set_callback_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_cipher
#  define BIO_set_cipher OPENSSL_MANGLER(BIO_set_cipher)
# endif
#else
# ifndef _BIO_set_cipher
#  define _BIO_set_cipher OPENSSL_MANGLER_ASM(BIO_set_cipher)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_data
#  define BIO_set_data OPENSSL_MANGLER(BIO_set_data)
# endif
#else
# ifndef _BIO_set_data
#  define _BIO_set_data OPENSSL_MANGLER_ASM(BIO_set_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_ex_data
#  define BIO_set_ex_data OPENSSL_MANGLER(BIO_set_ex_data)
# endif
#else
# ifndef _BIO_set_ex_data
#  define _BIO_set_ex_data OPENSSL_MANGLER_ASM(BIO_set_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_flags
#  define BIO_set_flags OPENSSL_MANGLER(BIO_set_flags)
# endif
#else
# ifndef _BIO_set_flags
#  define _BIO_set_flags OPENSSL_MANGLER_ASM(BIO_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_init
#  define BIO_set_init OPENSSL_MANGLER(BIO_set_init)
# endif
#else
# ifndef _BIO_set_init
#  define _BIO_set_init OPENSSL_MANGLER_ASM(BIO_set_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_next
#  define BIO_set_next OPENSSL_MANGLER(BIO_set_next)
# endif
#else
# ifndef _BIO_set_next
#  define _BIO_set_next OPENSSL_MANGLER_ASM(BIO_set_next)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_retry_reason
#  define BIO_set_retry_reason OPENSSL_MANGLER(BIO_set_retry_reason)
# endif
#else
# ifndef _BIO_set_retry_reason
#  define _BIO_set_retry_reason OPENSSL_MANGLER_ASM(BIO_set_retry_reason)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_shutdown
#  define BIO_set_shutdown OPENSSL_MANGLER(BIO_set_shutdown)
# endif
#else
# ifndef _BIO_set_shutdown
#  define _BIO_set_shutdown OPENSSL_MANGLER_ASM(BIO_set_shutdown)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_set_tcp_ndelay
#  define BIO_set_tcp_ndelay OPENSSL_MANGLER(BIO_set_tcp_ndelay)
# endif
#else
# ifndef _BIO_set_tcp_ndelay
#  define _BIO_set_tcp_ndelay OPENSSL_MANGLER_ASM(BIO_set_tcp_ndelay)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_fd
#  define BIO_s_fd OPENSSL_MANGLER(BIO_s_fd)
# endif
#else
# ifndef _BIO_s_fd
#  define _BIO_s_fd OPENSSL_MANGLER_ASM(BIO_s_fd)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_file
#  define BIO_s_file OPENSSL_MANGLER(BIO_s_file)
# endif
#else
# ifndef _BIO_s_file
#  define _BIO_s_file OPENSSL_MANGLER_ASM(BIO_s_file)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_log
#  define BIO_s_log OPENSSL_MANGLER(BIO_s_log)
# endif
#else
# ifndef _BIO_s_log
#  define _BIO_s_log OPENSSL_MANGLER_ASM(BIO_s_log)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_mem
#  define BIO_s_mem OPENSSL_MANGLER(BIO_s_mem)
# endif
#else
# ifndef _BIO_s_mem
#  define _BIO_s_mem OPENSSL_MANGLER_ASM(BIO_s_mem)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_snprintf
#  define BIO_snprintf OPENSSL_MANGLER(BIO_snprintf)
# endif
#else
# ifndef _BIO_snprintf
#  define _BIO_snprintf OPENSSL_MANGLER_ASM(BIO_snprintf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_null
#  define BIO_s_null OPENSSL_MANGLER(BIO_s_null)
# endif
#else
# ifndef _BIO_s_null
#  define _BIO_s_null OPENSSL_MANGLER_ASM(BIO_s_null)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bio_sock_cleanup_int
#  define bio_sock_cleanup_int OPENSSL_MANGLER(bio_sock_cleanup_int)
# endif
#else
# ifndef _bio_sock_cleanup_int
#  define _bio_sock_cleanup_int OPENSSL_MANGLER_ASM(bio_sock_cleanup_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_sock_error
#  define BIO_sock_error OPENSSL_MANGLER(BIO_sock_error)
# endif
#else
# ifndef _BIO_sock_error
#  define _BIO_sock_error OPENSSL_MANGLER_ASM(BIO_sock_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_socket
#  define BIO_socket OPENSSL_MANGLER(BIO_socket)
# endif
#else
# ifndef _BIO_socket
#  define _BIO_socket OPENSSL_MANGLER_ASM(BIO_socket)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_socket_ioctl
#  define BIO_socket_ioctl OPENSSL_MANGLER(BIO_socket_ioctl)
# endif
#else
# ifndef _BIO_socket_ioctl
#  define _BIO_socket_ioctl OPENSSL_MANGLER_ASM(BIO_socket_ioctl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_socket_nbio
#  define BIO_socket_nbio OPENSSL_MANGLER(BIO_socket_nbio)
# endif
#else
# ifndef _BIO_socket_nbio
#  define _BIO_socket_nbio OPENSSL_MANGLER_ASM(BIO_socket_nbio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_sock_info
#  define BIO_sock_info OPENSSL_MANGLER(BIO_sock_info)
# endif
#else
# ifndef _BIO_sock_info
#  define _BIO_sock_info OPENSSL_MANGLER_ASM(BIO_sock_info)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_sock_init
#  define BIO_sock_init OPENSSL_MANGLER(BIO_sock_init)
# endif
#else
# ifndef _BIO_sock_init
#  define _BIO_sock_init OPENSSL_MANGLER_ASM(BIO_sock_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_sock_non_fatal_error
#  define BIO_sock_non_fatal_error OPENSSL_MANGLER(BIO_sock_non_fatal_error)
# endif
#else
# ifndef _BIO_sock_non_fatal_error
#  define _BIO_sock_non_fatal_error OPENSSL_MANGLER_ASM(BIO_sock_non_fatal_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_sock_should_retry
#  define BIO_sock_should_retry OPENSSL_MANGLER(BIO_sock_should_retry)
# endif
#else
# ifndef _BIO_sock_should_retry
#  define _BIO_sock_should_retry OPENSSL_MANGLER_ASM(BIO_sock_should_retry)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_secmem
#  define BIO_s_secmem OPENSSL_MANGLER(BIO_s_secmem)
# endif
#else
# ifndef _BIO_s_secmem
#  define _BIO_s_secmem OPENSSL_MANGLER_ASM(BIO_s_secmem)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ssl_copy_session_id
#  define BIO_ssl_copy_session_id OPENSSL_MANGLER(BIO_ssl_copy_session_id)
# endif
#else
# ifndef _BIO_ssl_copy_session_id
#  define _BIO_ssl_copy_session_id OPENSSL_MANGLER_ASM(BIO_ssl_copy_session_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_ssl_shutdown
#  define BIO_ssl_shutdown OPENSSL_MANGLER(BIO_ssl_shutdown)
# endif
#else
# ifndef _BIO_ssl_shutdown
#  define _BIO_ssl_shutdown OPENSSL_MANGLER_ASM(BIO_ssl_shutdown)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_s_socket
#  define BIO_s_socket OPENSSL_MANGLER(BIO_s_socket)
# endif
#else
# ifndef _BIO_s_socket
#  define _BIO_s_socket OPENSSL_MANGLER_ASM(BIO_s_socket)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_test_flags
#  define BIO_test_flags OPENSSL_MANGLER(BIO_test_flags)
# endif
#else
# ifndef _BIO_test_flags
#  define _BIO_test_flags OPENSSL_MANGLER_ASM(BIO_test_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bio_type_lock
#  define bio_type_lock OPENSSL_MANGLER(bio_type_lock)
# endif
#else
# ifndef _bio_type_lock
#  define _bio_type_lock OPENSSL_MANGLER_ASM(bio_type_lock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_up_ref
#  define BIO_up_ref OPENSSL_MANGLER(BIO_up_ref)
# endif
#else
# ifndef _BIO_up_ref
#  define _BIO_up_ref OPENSSL_MANGLER_ASM(BIO_up_ref)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_vfree
#  define BIO_vfree OPENSSL_MANGLER(BIO_vfree)
# endif
#else
# ifndef _BIO_vfree
#  define _BIO_vfree OPENSSL_MANGLER_ASM(BIO_vfree)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_vprintf
#  define BIO_vprintf OPENSSL_MANGLER(BIO_vprintf)
# endif
#else
# ifndef _BIO_vprintf
#  define _BIO_vprintf OPENSSL_MANGLER_ASM(BIO_vprintf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_vsnprintf
#  define BIO_vsnprintf OPENSSL_MANGLER(BIO_vsnprintf)
# endif
#else
# ifndef _BIO_vsnprintf
#  define _BIO_vsnprintf OPENSSL_MANGLER_ASM(BIO_vsnprintf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_write
#  define BIO_write OPENSSL_MANGLER(BIO_write)
# endif
#else
# ifndef _BIO_write
#  define _BIO_write OPENSSL_MANGLER_ASM(BIO_write)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BIO_write_ex
#  define BIO_write_ex OPENSSL_MANGLER(BIO_write_ex)
# endif
#else
# ifndef _BIO_write_ex
#  define _BIO_write_ex OPENSSL_MANGLER_ASM(BIO_write_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BLAKE2b_Final
#  define BLAKE2b_Final OPENSSL_MANGLER(BLAKE2b_Final)
# endif
#else
# ifndef _BLAKE2b_Final
#  define _BLAKE2b_Final OPENSSL_MANGLER_ASM(BLAKE2b_Final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BLAKE2b_Init
#  define BLAKE2b_Init OPENSSL_MANGLER(BLAKE2b_Init)
# endif
#else
# ifndef _BLAKE2b_Init
#  define _BLAKE2b_Init OPENSSL_MANGLER_ASM(BLAKE2b_Init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BLAKE2b_Update
#  define BLAKE2b_Update OPENSSL_MANGLER(BLAKE2b_Update)
# endif
#else
# ifndef _BLAKE2b_Update
#  define _BLAKE2b_Update OPENSSL_MANGLER_ASM(BLAKE2b_Update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BLAKE2s_Final
#  define BLAKE2s_Final OPENSSL_MANGLER(BLAKE2s_Final)
# endif
#else
# ifndef _BLAKE2s_Final
#  define _BLAKE2s_Final OPENSSL_MANGLER_ASM(BLAKE2s_Final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BLAKE2s_Init
#  define BLAKE2s_Init OPENSSL_MANGLER(BLAKE2s_Init)
# endif
#else
# ifndef _BLAKE2s_Init
#  define _BLAKE2s_Init OPENSSL_MANGLER_ASM(BLAKE2s_Init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BLAKE2s_Update
#  define BLAKE2s_Update OPENSSL_MANGLER(BLAKE2s_Update)
# endif
#else
# ifndef _BLAKE2s_Update
#  define _BLAKE2s_Update OPENSSL_MANGLER_ASM(BLAKE2s_Update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_abs_is_word
#  define BN_abs_is_word OPENSSL_MANGLER(BN_abs_is_word)
# endif
#else
# ifndef _BN_abs_is_word
#  define _BN_abs_is_word OPENSSL_MANGLER_ASM(BN_abs_is_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_add
#  define BN_add OPENSSL_MANGLER(BN_add)
# endif
#else
# ifndef _BN_add
#  define _BN_add OPENSSL_MANGLER_ASM(BN_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_add_word
#  define BN_add_word OPENSSL_MANGLER(BN_add_word)
# endif
#else
# ifndef _BN_add_word
#  define _BN_add_word OPENSSL_MANGLER_ASM(BN_add_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_add_words
#  define bn_add_words OPENSSL_MANGLER(bn_add_words)
# endif
#else
# ifndef _bn_add_words
#  define _bn_add_words OPENSSL_MANGLER_ASM(bn_add_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_asc2bn
#  define BN_asc2bn OPENSSL_MANGLER(BN_asc2bn)
# endif
#else
# ifndef _BN_asc2bn
#  define _BN_asc2bn OPENSSL_MANGLER_ASM(BN_asc2bn)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_bin2bn
#  define BN_bin2bn OPENSSL_MANGLER(BN_bin2bn)
# endif
#else
# ifndef _BN_bin2bn
#  define _BN_bin2bn OPENSSL_MANGLER_ASM(BN_bin2bn)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_convert
#  define BN_BLINDING_convert OPENSSL_MANGLER(BN_BLINDING_convert)
# endif
#else
# ifndef _BN_BLINDING_convert
#  define _BN_BLINDING_convert OPENSSL_MANGLER_ASM(BN_BLINDING_convert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_convert_ex
#  define BN_BLINDING_convert_ex OPENSSL_MANGLER(BN_BLINDING_convert_ex)
# endif
#else
# ifndef _BN_BLINDING_convert_ex
#  define _BN_BLINDING_convert_ex OPENSSL_MANGLER_ASM(BN_BLINDING_convert_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_create_param
#  define BN_BLINDING_create_param OPENSSL_MANGLER(BN_BLINDING_create_param)
# endif
#else
# ifndef _BN_BLINDING_create_param
#  define _BN_BLINDING_create_param OPENSSL_MANGLER_ASM(BN_BLINDING_create_param)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_free
#  define BN_BLINDING_free OPENSSL_MANGLER(BN_BLINDING_free)
# endif
#else
# ifndef _BN_BLINDING_free
#  define _BN_BLINDING_free OPENSSL_MANGLER_ASM(BN_BLINDING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_get_flags
#  define BN_BLINDING_get_flags OPENSSL_MANGLER(BN_BLINDING_get_flags)
# endif
#else
# ifndef _BN_BLINDING_get_flags
#  define _BN_BLINDING_get_flags OPENSSL_MANGLER_ASM(BN_BLINDING_get_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_invert
#  define BN_BLINDING_invert OPENSSL_MANGLER(BN_BLINDING_invert)
# endif
#else
# ifndef _BN_BLINDING_invert
#  define _BN_BLINDING_invert OPENSSL_MANGLER_ASM(BN_BLINDING_invert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_invert_ex
#  define BN_BLINDING_invert_ex OPENSSL_MANGLER(BN_BLINDING_invert_ex)
# endif
#else
# ifndef _BN_BLINDING_invert_ex
#  define _BN_BLINDING_invert_ex OPENSSL_MANGLER_ASM(BN_BLINDING_invert_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_is_current_thread
#  define BN_BLINDING_is_current_thread OPENSSL_MANGLER(BN_BLINDING_is_current_thread)
# endif
#else
# ifndef _BN_BLINDING_is_current_thread
#  define _BN_BLINDING_is_current_thread OPENSSL_MANGLER_ASM(BN_BLINDING_is_current_thread)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_lock
#  define BN_BLINDING_lock OPENSSL_MANGLER(BN_BLINDING_lock)
# endif
#else
# ifndef _BN_BLINDING_lock
#  define _BN_BLINDING_lock OPENSSL_MANGLER_ASM(BN_BLINDING_lock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_new
#  define BN_BLINDING_new OPENSSL_MANGLER(BN_BLINDING_new)
# endif
#else
# ifndef _BN_BLINDING_new
#  define _BN_BLINDING_new OPENSSL_MANGLER_ASM(BN_BLINDING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_set_current_thread
#  define BN_BLINDING_set_current_thread OPENSSL_MANGLER(BN_BLINDING_set_current_thread)
# endif
#else
# ifndef _BN_BLINDING_set_current_thread
#  define _BN_BLINDING_set_current_thread OPENSSL_MANGLER_ASM(BN_BLINDING_set_current_thread)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_set_flags
#  define BN_BLINDING_set_flags OPENSSL_MANGLER(BN_BLINDING_set_flags)
# endif
#else
# ifndef _BN_BLINDING_set_flags
#  define _BN_BLINDING_set_flags OPENSSL_MANGLER_ASM(BN_BLINDING_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_unlock
#  define BN_BLINDING_unlock OPENSSL_MANGLER(BN_BLINDING_unlock)
# endif
#else
# ifndef _BN_BLINDING_unlock
#  define _BN_BLINDING_unlock OPENSSL_MANGLER_ASM(BN_BLINDING_unlock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_BLINDING_update
#  define BN_BLINDING_update OPENSSL_MANGLER(BN_BLINDING_update)
# endif
#else
# ifndef _BN_BLINDING_update
#  define _BN_BLINDING_update OPENSSL_MANGLER_ASM(BN_BLINDING_update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_bn2bin
#  define BN_bn2bin OPENSSL_MANGLER(BN_bn2bin)
# endif
#else
# ifndef _BN_bn2bin
#  define _BN_bn2bin OPENSSL_MANGLER_ASM(BN_bn2bin)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_bn2binpad
#  define BN_bn2binpad OPENSSL_MANGLER(BN_bn2binpad)
# endif
#else
# ifndef _BN_bn2binpad
#  define _BN_bn2binpad OPENSSL_MANGLER_ASM(BN_bn2binpad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_bn2dec
#  define BN_bn2dec OPENSSL_MANGLER(BN_bn2dec)
# endif
#else
# ifndef _BN_bn2dec
#  define _BN_bn2dec OPENSSL_MANGLER_ASM(BN_bn2dec)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_bn2hex
#  define BN_bn2hex OPENSSL_MANGLER(BN_bn2hex)
# endif
#else
# ifndef _BN_bn2hex
#  define _BN_bn2hex OPENSSL_MANGLER_ASM(BN_bn2hex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_bn2lebinpad
#  define BN_bn2lebinpad OPENSSL_MANGLER(BN_bn2lebinpad)
# endif
#else
# ifndef _BN_bn2lebinpad
#  define _BN_bn2lebinpad OPENSSL_MANGLER_ASM(BN_bn2lebinpad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_bn2mpi
#  define BN_bn2mpi OPENSSL_MANGLER(BN_bn2mpi)
# endif
#else
# ifndef _BN_bn2mpi
#  define _BN_bn2mpi OPENSSL_MANGLER_ASM(BN_bn2mpi)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_bntest_rand
#  define BN_bntest_rand OPENSSL_MANGLER(BN_bntest_rand)
# endif
#else
# ifndef _BN_bntest_rand
#  define _BN_bntest_rand OPENSSL_MANGLER_ASM(BN_bntest_rand)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_clear
#  define BN_clear OPENSSL_MANGLER(BN_clear)
# endif
#else
# ifndef _BN_clear
#  define _BN_clear OPENSSL_MANGLER_ASM(BN_clear)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_clear_bit
#  define BN_clear_bit OPENSSL_MANGLER(BN_clear_bit)
# endif
#else
# ifndef _BN_clear_bit
#  define _BN_clear_bit OPENSSL_MANGLER_ASM(BN_clear_bit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_clear_free
#  define BN_clear_free OPENSSL_MANGLER(BN_clear_free)
# endif
#else
# ifndef _BN_clear_free
#  define _BN_clear_free OPENSSL_MANGLER_ASM(BN_clear_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_cmp
#  define BN_cmp OPENSSL_MANGLER(BN_cmp)
# endif
#else
# ifndef _BN_cmp
#  define _BN_cmp OPENSSL_MANGLER_ASM(BN_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_cmp_part_words
#  define bn_cmp_part_words OPENSSL_MANGLER(bn_cmp_part_words)
# endif
#else
# ifndef _bn_cmp_part_words
#  define _bn_cmp_part_words OPENSSL_MANGLER_ASM(bn_cmp_part_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_cmp_words
#  define bn_cmp_words OPENSSL_MANGLER(bn_cmp_words)
# endif
#else
# ifndef _bn_cmp_words
#  define _bn_cmp_words OPENSSL_MANGLER_ASM(bn_cmp_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_compute_wNAF
#  define bn_compute_wNAF OPENSSL_MANGLER(bn_compute_wNAF)
# endif
#else
# ifndef _bn_compute_wNAF
#  define _bn_compute_wNAF OPENSSL_MANGLER_ASM(bn_compute_wNAF)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_consttime_swap
#  define BN_consttime_swap OPENSSL_MANGLER(BN_consttime_swap)
# endif
#else
# ifndef _BN_consttime_swap
#  define _BN_consttime_swap OPENSSL_MANGLER_ASM(BN_consttime_swap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_copy
#  define BN_copy OPENSSL_MANGLER(BN_copy)
# endif
#else
# ifndef _BN_copy
#  define _BN_copy OPENSSL_MANGLER_ASM(BN_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_copy_words
#  define bn_copy_words OPENSSL_MANGLER(bn_copy_words)
# endif
#else
# ifndef _bn_copy_words
#  define _bn_copy_words OPENSSL_MANGLER_ASM(bn_copy_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_correct_top
#  define bn_correct_top OPENSSL_MANGLER(bn_correct_top)
# endif
#else
# ifndef _bn_correct_top
#  define _bn_correct_top OPENSSL_MANGLER_ASM(bn_correct_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_CTX_end
#  define BN_CTX_end OPENSSL_MANGLER(BN_CTX_end)
# endif
#else
# ifndef _BN_CTX_end
#  define _BN_CTX_end OPENSSL_MANGLER_ASM(BN_CTX_end)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_CTX_free
#  define BN_CTX_free OPENSSL_MANGLER(BN_CTX_free)
# endif
#else
# ifndef _BN_CTX_free
#  define _BN_CTX_free OPENSSL_MANGLER_ASM(BN_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_CTX_get
#  define BN_CTX_get OPENSSL_MANGLER(BN_CTX_get)
# endif
#else
# ifndef _BN_CTX_get
#  define _BN_CTX_get OPENSSL_MANGLER_ASM(BN_CTX_get)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_CTX_new
#  define BN_CTX_new OPENSSL_MANGLER(BN_CTX_new)
# endif
#else
# ifndef _BN_CTX_new
#  define _BN_CTX_new OPENSSL_MANGLER_ASM(BN_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_CTX_secure_new
#  define BN_CTX_secure_new OPENSSL_MANGLER(BN_CTX_secure_new)
# endif
#else
# ifndef _BN_CTX_secure_new
#  define _BN_CTX_secure_new OPENSSL_MANGLER_ASM(BN_CTX_secure_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_CTX_start
#  define BN_CTX_start OPENSSL_MANGLER(BN_CTX_start)
# endif
#else
# ifndef _BN_CTX_start
#  define _BN_CTX_start OPENSSL_MANGLER_ASM(BN_CTX_start)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_dec2bn
#  define BN_dec2bn OPENSSL_MANGLER(BN_dec2bn)
# endif
#else
# ifndef _BN_dec2bn
#  define _BN_dec2bn OPENSSL_MANGLER_ASM(BN_dec2bn)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_div
#  define BN_div OPENSSL_MANGLER(BN_div)
# endif
#else
# ifndef _BN_div
#  define _BN_div OPENSSL_MANGLER_ASM(BN_div)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_div_fixed_top
#  define bn_div_fixed_top OPENSSL_MANGLER(bn_div_fixed_top)
# endif
#else
# ifndef _bn_div_fixed_top
#  define _bn_div_fixed_top OPENSSL_MANGLER_ASM(bn_div_fixed_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_div_recp
#  define BN_div_recp OPENSSL_MANGLER(BN_div_recp)
# endif
#else
# ifndef _BN_div_recp
#  define _BN_div_recp OPENSSL_MANGLER_ASM(BN_div_recp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_div_word
#  define BN_div_word OPENSSL_MANGLER(BN_div_word)
# endif
#else
# ifndef _BN_div_word
#  define _BN_div_word OPENSSL_MANGLER_ASM(BN_div_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_div_words
#  define bn_div_words OPENSSL_MANGLER(bn_div_words)
# endif
#else
# ifndef _bn_div_words
#  define _bn_div_words OPENSSL_MANGLER_ASM(bn_div_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_dup
#  define BN_dup OPENSSL_MANGLER(BN_dup)
# endif
#else
# ifndef _BN_dup
#  define _BN_dup OPENSSL_MANGLER_ASM(BN_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_exp
#  define BN_exp OPENSSL_MANGLER(BN_exp)
# endif
#else
# ifndef _BN_exp
#  define _BN_exp OPENSSL_MANGLER_ASM(BN_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_expand2
#  define bn_expand2 OPENSSL_MANGLER(bn_expand2)
# endif
#else
# ifndef _bn_expand2
#  define _bn_expand2 OPENSSL_MANGLER_ASM(bn_expand2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_free
#  define BN_free OPENSSL_MANGLER(BN_free)
# endif
#else
# ifndef _BN_free
#  define _BN_free OPENSSL_MANGLER_ASM(BN_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_from_mont_fixed_top
#  define bn_from_mont_fixed_top OPENSSL_MANGLER(bn_from_mont_fixed_top)
# endif
#else
# ifndef _bn_from_mont_fixed_top
#  define _bn_from_mont_fixed_top OPENSSL_MANGLER_ASM(bn_from_mont_fixed_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_from_montgomery
#  define bn_from_montgomery OPENSSL_MANGLER(bn_from_montgomery)
# endif
#else
# ifndef _bn_from_montgomery
#  define _bn_from_montgomery OPENSSL_MANGLER_ASM(bn_from_montgomery)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_from_montgomery
#  define BN_from_montgomery OPENSSL_MANGLER(BN_from_montgomery)
# endif
#else
# ifndef _BN_from_montgomery
#  define _BN_from_montgomery OPENSSL_MANGLER_ASM(BN_from_montgomery)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_gather5
#  define bn_gather5 OPENSSL_MANGLER(bn_gather5)
# endif
#else
# ifndef _bn_gather5
#  define _bn_gather5 OPENSSL_MANGLER_ASM(bn_gather5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_gcd
#  define BN_gcd OPENSSL_MANGLER(BN_gcd)
# endif
#else
# ifndef _BN_gcd
#  define _BN_gcd OPENSSL_MANGLER_ASM(BN_gcd)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GENCB_call
#  define BN_GENCB_call OPENSSL_MANGLER(BN_GENCB_call)
# endif
#else
# ifndef _BN_GENCB_call
#  define _BN_GENCB_call OPENSSL_MANGLER_ASM(BN_GENCB_call)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GENCB_free
#  define BN_GENCB_free OPENSSL_MANGLER(BN_GENCB_free)
# endif
#else
# ifndef _BN_GENCB_free
#  define _BN_GENCB_free OPENSSL_MANGLER_ASM(BN_GENCB_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GENCB_get_arg
#  define BN_GENCB_get_arg OPENSSL_MANGLER(BN_GENCB_get_arg)
# endif
#else
# ifndef _BN_GENCB_get_arg
#  define _BN_GENCB_get_arg OPENSSL_MANGLER_ASM(BN_GENCB_get_arg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GENCB_new
#  define BN_GENCB_new OPENSSL_MANGLER(BN_GENCB_new)
# endif
#else
# ifndef _BN_GENCB_new
#  define _BN_GENCB_new OPENSSL_MANGLER_ASM(BN_GENCB_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GENCB_set
#  define BN_GENCB_set OPENSSL_MANGLER(BN_GENCB_set)
# endif
#else
# ifndef _BN_GENCB_set
#  define _BN_GENCB_set OPENSSL_MANGLER_ASM(BN_GENCB_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GENCB_set_old
#  define BN_GENCB_set_old OPENSSL_MANGLER(BN_GENCB_set_old)
# endif
#else
# ifndef _BN_GENCB_set_old
#  define _BN_GENCB_set_old OPENSSL_MANGLER_ASM(BN_GENCB_set_old)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_generate_dsa_nonce
#  define BN_generate_dsa_nonce OPENSSL_MANGLER(BN_generate_dsa_nonce)
# endif
#else
# ifndef _BN_generate_dsa_nonce
#  define _BN_generate_dsa_nonce OPENSSL_MANGLER_ASM(BN_generate_dsa_nonce)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_generate_prime
#  define BN_generate_prime OPENSSL_MANGLER(BN_generate_prime)
# endif
#else
# ifndef _BN_generate_prime
#  define _BN_generate_prime OPENSSL_MANGLER_ASM(BN_generate_prime)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_generate_prime_ex
#  define BN_generate_prime_ex OPENSSL_MANGLER(BN_generate_prime_ex)
# endif
#else
# ifndef _BN_generate_prime_ex
#  define _BN_generate_prime_ex OPENSSL_MANGLER_ASM(BN_generate_prime_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_generator_19
#  define bn_generator_19 OPENSSL_MANGLER(bn_generator_19)
# endif
#else
# ifndef _bn_generator_19
#  define _bn_generator_19 OPENSSL_MANGLER_ASM(bn_generator_19)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_generator_2
#  define bn_generator_2 OPENSSL_MANGLER(bn_generator_2)
# endif
#else
# ifndef _bn_generator_2
#  define _bn_generator_2 OPENSSL_MANGLER_ASM(bn_generator_2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_generator_5
#  define bn_generator_5 OPENSSL_MANGLER(bn_generator_5)
# endif
#else
# ifndef _bn_generator_5
#  define _bn_generator_5 OPENSSL_MANGLER_ASM(bn_generator_5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get0_nist_prime_192
#  define BN_get0_nist_prime_192 OPENSSL_MANGLER(BN_get0_nist_prime_192)
# endif
#else
# ifndef _BN_get0_nist_prime_192
#  define _BN_get0_nist_prime_192 OPENSSL_MANGLER_ASM(BN_get0_nist_prime_192)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get0_nist_prime_224
#  define BN_get0_nist_prime_224 OPENSSL_MANGLER(BN_get0_nist_prime_224)
# endif
#else
# ifndef _BN_get0_nist_prime_224
#  define _BN_get0_nist_prime_224 OPENSSL_MANGLER_ASM(BN_get0_nist_prime_224)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get0_nist_prime_256
#  define BN_get0_nist_prime_256 OPENSSL_MANGLER(BN_get0_nist_prime_256)
# endif
#else
# ifndef _BN_get0_nist_prime_256
#  define _BN_get0_nist_prime_256 OPENSSL_MANGLER_ASM(BN_get0_nist_prime_256)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get0_nist_prime_384
#  define BN_get0_nist_prime_384 OPENSSL_MANGLER(BN_get0_nist_prime_384)
# endif
#else
# ifndef _BN_get0_nist_prime_384
#  define _BN_get0_nist_prime_384 OPENSSL_MANGLER_ASM(BN_get0_nist_prime_384)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get0_nist_prime_521
#  define BN_get0_nist_prime_521 OPENSSL_MANGLER(BN_get0_nist_prime_521)
# endif
#else
# ifndef _BN_get0_nist_prime_521
#  define _BN_get0_nist_prime_521 OPENSSL_MANGLER_ASM(BN_get0_nist_prime_521)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_get_bits5
#  define bn_get_bits5 OPENSSL_MANGLER(bn_get_bits5)
# endif
#else
# ifndef _bn_get_bits5
#  define _bn_get_bits5 OPENSSL_MANGLER_ASM(bn_get_bits5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_get_dmax
#  define bn_get_dmax OPENSSL_MANGLER(bn_get_dmax)
# endif
#else
# ifndef _bn_get_dmax
#  define _bn_get_dmax OPENSSL_MANGLER_ASM(bn_get_dmax)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_flags
#  define BN_get_flags OPENSSL_MANGLER(BN_get_flags)
# endif
#else
# ifndef _BN_get_flags
#  define _BN_get_flags OPENSSL_MANGLER_ASM(BN_get_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_params
#  define BN_get_params OPENSSL_MANGLER(BN_get_params)
# endif
#else
# ifndef _BN_get_params
#  define _BN_get_params OPENSSL_MANGLER_ASM(BN_get_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_rfc2409_prime_1024
#  define BN_get_rfc2409_prime_1024 OPENSSL_MANGLER(BN_get_rfc2409_prime_1024)
# endif
#else
# ifndef _BN_get_rfc2409_prime_1024
#  define _BN_get_rfc2409_prime_1024 OPENSSL_MANGLER_ASM(BN_get_rfc2409_prime_1024)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_rfc2409_prime_768
#  define BN_get_rfc2409_prime_768 OPENSSL_MANGLER(BN_get_rfc2409_prime_768)
# endif
#else
# ifndef _BN_get_rfc2409_prime_768
#  define _BN_get_rfc2409_prime_768 OPENSSL_MANGLER_ASM(BN_get_rfc2409_prime_768)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_rfc3526_prime_1536
#  define BN_get_rfc3526_prime_1536 OPENSSL_MANGLER(BN_get_rfc3526_prime_1536)
# endif
#else
# ifndef _BN_get_rfc3526_prime_1536
#  define _BN_get_rfc3526_prime_1536 OPENSSL_MANGLER_ASM(BN_get_rfc3526_prime_1536)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_rfc3526_prime_2048
#  define BN_get_rfc3526_prime_2048 OPENSSL_MANGLER(BN_get_rfc3526_prime_2048)
# endif
#else
# ifndef _BN_get_rfc3526_prime_2048
#  define _BN_get_rfc3526_prime_2048 OPENSSL_MANGLER_ASM(BN_get_rfc3526_prime_2048)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_rfc3526_prime_3072
#  define BN_get_rfc3526_prime_3072 OPENSSL_MANGLER(BN_get_rfc3526_prime_3072)
# endif
#else
# ifndef _BN_get_rfc3526_prime_3072
#  define _BN_get_rfc3526_prime_3072 OPENSSL_MANGLER_ASM(BN_get_rfc3526_prime_3072)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_rfc3526_prime_4096
#  define BN_get_rfc3526_prime_4096 OPENSSL_MANGLER(BN_get_rfc3526_prime_4096)
# endif
#else
# ifndef _BN_get_rfc3526_prime_4096
#  define _BN_get_rfc3526_prime_4096 OPENSSL_MANGLER_ASM(BN_get_rfc3526_prime_4096)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_rfc3526_prime_6144
#  define BN_get_rfc3526_prime_6144 OPENSSL_MANGLER(BN_get_rfc3526_prime_6144)
# endif
#else
# ifndef _BN_get_rfc3526_prime_6144
#  define _BN_get_rfc3526_prime_6144 OPENSSL_MANGLER_ASM(BN_get_rfc3526_prime_6144)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_rfc3526_prime_8192
#  define BN_get_rfc3526_prime_8192 OPENSSL_MANGLER(BN_get_rfc3526_prime_8192)
# endif
#else
# ifndef _BN_get_rfc3526_prime_8192
#  define _BN_get_rfc3526_prime_8192 OPENSSL_MANGLER_ASM(BN_get_rfc3526_prime_8192)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_get_top
#  define bn_get_top OPENSSL_MANGLER(bn_get_top)
# endif
#else
# ifndef _bn_get_top
#  define _bn_get_top OPENSSL_MANGLER_ASM(bn_get_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_get_word
#  define BN_get_word OPENSSL_MANGLER(BN_get_word)
# endif
#else
# ifndef _BN_get_word
#  define _BN_get_word OPENSSL_MANGLER_ASM(BN_get_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_get_words
#  define bn_get_words OPENSSL_MANGLER(bn_get_words)
# endif
#else
# ifndef _bn_get_words
#  define _bn_get_words OPENSSL_MANGLER_ASM(bn_get_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_add
#  define BN_GF2m_add OPENSSL_MANGLER(BN_GF2m_add)
# endif
#else
# ifndef _BN_GF2m_add
#  define _BN_GF2m_add OPENSSL_MANGLER_ASM(BN_GF2m_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_arr2poly
#  define BN_GF2m_arr2poly OPENSSL_MANGLER(BN_GF2m_arr2poly)
# endif
#else
# ifndef _BN_GF2m_arr2poly
#  define _BN_GF2m_arr2poly OPENSSL_MANGLER_ASM(BN_GF2m_arr2poly)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod
#  define BN_GF2m_mod OPENSSL_MANGLER(BN_GF2m_mod)
# endif
#else
# ifndef _BN_GF2m_mod
#  define _BN_GF2m_mod OPENSSL_MANGLER_ASM(BN_GF2m_mod)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_arr
#  define BN_GF2m_mod_arr OPENSSL_MANGLER(BN_GF2m_mod_arr)
# endif
#else
# ifndef _BN_GF2m_mod_arr
#  define _BN_GF2m_mod_arr OPENSSL_MANGLER_ASM(BN_GF2m_mod_arr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_div
#  define BN_GF2m_mod_div OPENSSL_MANGLER(BN_GF2m_mod_div)
# endif
#else
# ifndef _BN_GF2m_mod_div
#  define _BN_GF2m_mod_div OPENSSL_MANGLER_ASM(BN_GF2m_mod_div)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_div_arr
#  define BN_GF2m_mod_div_arr OPENSSL_MANGLER(BN_GF2m_mod_div_arr)
# endif
#else
# ifndef _BN_GF2m_mod_div_arr
#  define _BN_GF2m_mod_div_arr OPENSSL_MANGLER_ASM(BN_GF2m_mod_div_arr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_exp
#  define BN_GF2m_mod_exp OPENSSL_MANGLER(BN_GF2m_mod_exp)
# endif
#else
# ifndef _BN_GF2m_mod_exp
#  define _BN_GF2m_mod_exp OPENSSL_MANGLER_ASM(BN_GF2m_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_exp_arr
#  define BN_GF2m_mod_exp_arr OPENSSL_MANGLER(BN_GF2m_mod_exp_arr)
# endif
#else
# ifndef _BN_GF2m_mod_exp_arr
#  define _BN_GF2m_mod_exp_arr OPENSSL_MANGLER_ASM(BN_GF2m_mod_exp_arr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_inv
#  define BN_GF2m_mod_inv OPENSSL_MANGLER(BN_GF2m_mod_inv)
# endif
#else
# ifndef _BN_GF2m_mod_inv
#  define _BN_GF2m_mod_inv OPENSSL_MANGLER_ASM(BN_GF2m_mod_inv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_inv_arr
#  define BN_GF2m_mod_inv_arr OPENSSL_MANGLER(BN_GF2m_mod_inv_arr)
# endif
#else
# ifndef _BN_GF2m_mod_inv_arr
#  define _BN_GF2m_mod_inv_arr OPENSSL_MANGLER_ASM(BN_GF2m_mod_inv_arr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_mul
#  define BN_GF2m_mod_mul OPENSSL_MANGLER(BN_GF2m_mod_mul)
# endif
#else
# ifndef _BN_GF2m_mod_mul
#  define _BN_GF2m_mod_mul OPENSSL_MANGLER_ASM(BN_GF2m_mod_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_mul_arr
#  define BN_GF2m_mod_mul_arr OPENSSL_MANGLER(BN_GF2m_mod_mul_arr)
# endif
#else
# ifndef _BN_GF2m_mod_mul_arr
#  define _BN_GF2m_mod_mul_arr OPENSSL_MANGLER_ASM(BN_GF2m_mod_mul_arr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_solve_quad
#  define BN_GF2m_mod_solve_quad OPENSSL_MANGLER(BN_GF2m_mod_solve_quad)
# endif
#else
# ifndef _BN_GF2m_mod_solve_quad
#  define _BN_GF2m_mod_solve_quad OPENSSL_MANGLER_ASM(BN_GF2m_mod_solve_quad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_solve_quad_arr
#  define BN_GF2m_mod_solve_quad_arr OPENSSL_MANGLER(BN_GF2m_mod_solve_quad_arr)
# endif
#else
# ifndef _BN_GF2m_mod_solve_quad_arr
#  define _BN_GF2m_mod_solve_quad_arr OPENSSL_MANGLER_ASM(BN_GF2m_mod_solve_quad_arr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_sqr
#  define BN_GF2m_mod_sqr OPENSSL_MANGLER(BN_GF2m_mod_sqr)
# endif
#else
# ifndef _BN_GF2m_mod_sqr
#  define _BN_GF2m_mod_sqr OPENSSL_MANGLER_ASM(BN_GF2m_mod_sqr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_sqr_arr
#  define BN_GF2m_mod_sqr_arr OPENSSL_MANGLER(BN_GF2m_mod_sqr_arr)
# endif
#else
# ifndef _BN_GF2m_mod_sqr_arr
#  define _BN_GF2m_mod_sqr_arr OPENSSL_MANGLER_ASM(BN_GF2m_mod_sqr_arr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_sqrt
#  define BN_GF2m_mod_sqrt OPENSSL_MANGLER(BN_GF2m_mod_sqrt)
# endif
#else
# ifndef _BN_GF2m_mod_sqrt
#  define _BN_GF2m_mod_sqrt OPENSSL_MANGLER_ASM(BN_GF2m_mod_sqrt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_mod_sqrt_arr
#  define BN_GF2m_mod_sqrt_arr OPENSSL_MANGLER(BN_GF2m_mod_sqrt_arr)
# endif
#else
# ifndef _BN_GF2m_mod_sqrt_arr
#  define _BN_GF2m_mod_sqrt_arr OPENSSL_MANGLER_ASM(BN_GF2m_mod_sqrt_arr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_GF2m_mul_2x2
#  define bn_GF2m_mul_2x2 OPENSSL_MANGLER(bn_GF2m_mul_2x2)
# endif
#else
# ifndef _bn_GF2m_mul_2x2
#  define _bn_GF2m_mul_2x2 OPENSSL_MANGLER_ASM(bn_GF2m_mul_2x2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_GF2m_poly2arr
#  define BN_GF2m_poly2arr OPENSSL_MANGLER(BN_GF2m_poly2arr)
# endif
#else
# ifndef _BN_GF2m_poly2arr
#  define _BN_GF2m_poly2arr OPENSSL_MANGLER_ASM(BN_GF2m_poly2arr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_group_1024
#  define bn_group_1024 OPENSSL_MANGLER(bn_group_1024)
# endif
#else
# ifndef _bn_group_1024
#  define _bn_group_1024 OPENSSL_MANGLER_ASM(bn_group_1024)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_group_1536
#  define bn_group_1536 OPENSSL_MANGLER(bn_group_1536)
# endif
#else
# ifndef _bn_group_1536
#  define _bn_group_1536 OPENSSL_MANGLER_ASM(bn_group_1536)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_group_2048
#  define bn_group_2048 OPENSSL_MANGLER(bn_group_2048)
# endif
#else
# ifndef _bn_group_2048
#  define _bn_group_2048 OPENSSL_MANGLER_ASM(bn_group_2048)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_group_3072
#  define bn_group_3072 OPENSSL_MANGLER(bn_group_3072)
# endif
#else
# ifndef _bn_group_3072
#  define _bn_group_3072 OPENSSL_MANGLER_ASM(bn_group_3072)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_group_4096
#  define bn_group_4096 OPENSSL_MANGLER(bn_group_4096)
# endif
#else
# ifndef _bn_group_4096
#  define _bn_group_4096 OPENSSL_MANGLER_ASM(bn_group_4096)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_group_6144
#  define bn_group_6144 OPENSSL_MANGLER(bn_group_6144)
# endif
#else
# ifndef _bn_group_6144
#  define _bn_group_6144 OPENSSL_MANGLER_ASM(bn_group_6144)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_group_8192
#  define bn_group_8192 OPENSSL_MANGLER(bn_group_8192)
# endif
#else
# ifndef _bn_group_8192
#  define _bn_group_8192 OPENSSL_MANGLER_ASM(bn_group_8192)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_hex2bn
#  define BN_hex2bn OPENSSL_MANGLER(BN_hex2bn)
# endif
#else
# ifndef _BN_hex2bn
#  define _BN_hex2bn OPENSSL_MANGLER_ASM(BN_hex2bn)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_init
#  define bn_init OPENSSL_MANGLER(bn_init)
# endif
#else
# ifndef _bn_init
#  define _bn_init OPENSSL_MANGLER_ASM(bn_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_is_bit_set
#  define BN_is_bit_set OPENSSL_MANGLER(BN_is_bit_set)
# endif
#else
# ifndef _BN_is_bit_set
#  define _BN_is_bit_set OPENSSL_MANGLER_ASM(BN_is_bit_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_is_negative
#  define BN_is_negative OPENSSL_MANGLER(BN_is_negative)
# endif
#else
# ifndef _BN_is_negative
#  define _BN_is_negative OPENSSL_MANGLER_ASM(BN_is_negative)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_is_odd
#  define BN_is_odd OPENSSL_MANGLER(BN_is_odd)
# endif
#else
# ifndef _BN_is_odd
#  define _BN_is_odd OPENSSL_MANGLER_ASM(BN_is_odd)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_is_one
#  define BN_is_one OPENSSL_MANGLER(BN_is_one)
# endif
#else
# ifndef _BN_is_one
#  define _BN_is_one OPENSSL_MANGLER_ASM(BN_is_one)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_is_prime
#  define BN_is_prime OPENSSL_MANGLER(BN_is_prime)
# endif
#else
# ifndef _BN_is_prime
#  define _BN_is_prime OPENSSL_MANGLER_ASM(BN_is_prime)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_is_prime_ex
#  define BN_is_prime_ex OPENSSL_MANGLER(BN_is_prime_ex)
# endif
#else
# ifndef _BN_is_prime_ex
#  define _BN_is_prime_ex OPENSSL_MANGLER_ASM(BN_is_prime_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_is_prime_fasttest
#  define BN_is_prime_fasttest OPENSSL_MANGLER(BN_is_prime_fasttest)
# endif
#else
# ifndef _BN_is_prime_fasttest
#  define _BN_is_prime_fasttest OPENSSL_MANGLER_ASM(BN_is_prime_fasttest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_is_prime_fasttest_ex
#  define BN_is_prime_fasttest_ex OPENSSL_MANGLER(BN_is_prime_fasttest_ex)
# endif
#else
# ifndef _BN_is_prime_fasttest_ex
#  define _BN_is_prime_fasttest_ex OPENSSL_MANGLER_ASM(BN_is_prime_fasttest_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_is_word
#  define BN_is_word OPENSSL_MANGLER(BN_is_word)
# endif
#else
# ifndef _BN_is_word
#  define _BN_is_word OPENSSL_MANGLER_ASM(BN_is_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_is_zero
#  define BN_is_zero OPENSSL_MANGLER(BN_is_zero)
# endif
#else
# ifndef _BN_is_zero
#  define _BN_is_zero OPENSSL_MANGLER_ASM(BN_is_zero)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_kronecker
#  define BN_kronecker OPENSSL_MANGLER(BN_kronecker)
# endif
#else
# ifndef _BN_kronecker
#  define _BN_kronecker OPENSSL_MANGLER_ASM(BN_kronecker)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_lebin2bn
#  define BN_lebin2bn OPENSSL_MANGLER(BN_lebin2bn)
# endif
#else
# ifndef _BN_lebin2bn
#  define _BN_lebin2bn OPENSSL_MANGLER_ASM(BN_lebin2bn)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_lshift
#  define BN_lshift OPENSSL_MANGLER(BN_lshift)
# endif
#else
# ifndef _BN_lshift
#  define _BN_lshift OPENSSL_MANGLER_ASM(BN_lshift)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_lshift1
#  define BN_lshift1 OPENSSL_MANGLER(BN_lshift1)
# endif
#else
# ifndef _BN_lshift1
#  define _BN_lshift1 OPENSSL_MANGLER_ASM(BN_lshift1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_lshift_fixed_top
#  define bn_lshift_fixed_top OPENSSL_MANGLER(bn_lshift_fixed_top)
# endif
#else
# ifndef _bn_lshift_fixed_top
#  define _bn_lshift_fixed_top OPENSSL_MANGLER_ASM(bn_lshift_fixed_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mask_bits
#  define BN_mask_bits OPENSSL_MANGLER(BN_mask_bits)
# endif
#else
# ifndef _BN_mask_bits
#  define _BN_mask_bits OPENSSL_MANGLER_ASM(BN_mask_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_add
#  define BN_mod_add OPENSSL_MANGLER(BN_mod_add)
# endif
#else
# ifndef _BN_mod_add
#  define _BN_mod_add OPENSSL_MANGLER_ASM(BN_mod_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mod_add_fixed_top
#  define bn_mod_add_fixed_top OPENSSL_MANGLER(bn_mod_add_fixed_top)
# endif
#else
# ifndef _bn_mod_add_fixed_top
#  define _bn_mod_add_fixed_top OPENSSL_MANGLER_ASM(bn_mod_add_fixed_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_add_quick
#  define BN_mod_add_quick OPENSSL_MANGLER(BN_mod_add_quick)
# endif
#else
# ifndef _BN_mod_add_quick
#  define _BN_mod_add_quick OPENSSL_MANGLER_ASM(BN_mod_add_quick)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_exp
#  define BN_mod_exp OPENSSL_MANGLER(BN_mod_exp)
# endif
#else
# ifndef _BN_mod_exp
#  define _BN_mod_exp OPENSSL_MANGLER_ASM(BN_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_exp2_mont
#  define BN_mod_exp2_mont OPENSSL_MANGLER(BN_mod_exp2_mont)
# endif
#else
# ifndef _BN_mod_exp2_mont
#  define _BN_mod_exp2_mont OPENSSL_MANGLER_ASM(BN_mod_exp2_mont)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_exp_mont
#  define BN_mod_exp_mont OPENSSL_MANGLER(BN_mod_exp_mont)
# endif
#else
# ifndef _BN_mod_exp_mont
#  define _BN_mod_exp_mont OPENSSL_MANGLER_ASM(BN_mod_exp_mont)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_exp_mont_consttime
#  define BN_mod_exp_mont_consttime OPENSSL_MANGLER(BN_mod_exp_mont_consttime)
# endif
#else
# ifndef _BN_mod_exp_mont_consttime
#  define _BN_mod_exp_mont_consttime OPENSSL_MANGLER_ASM(BN_mod_exp_mont_consttime)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_exp_mont_word
#  define BN_mod_exp_mont_word OPENSSL_MANGLER(BN_mod_exp_mont_word)
# endif
#else
# ifndef _BN_mod_exp_mont_word
#  define _BN_mod_exp_mont_word OPENSSL_MANGLER_ASM(BN_mod_exp_mont_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_exp_recp
#  define BN_mod_exp_recp OPENSSL_MANGLER(BN_mod_exp_recp)
# endif
#else
# ifndef _BN_mod_exp_recp
#  define _BN_mod_exp_recp OPENSSL_MANGLER_ASM(BN_mod_exp_recp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_exp_simple
#  define BN_mod_exp_simple OPENSSL_MANGLER(BN_mod_exp_simple)
# endif
#else
# ifndef _BN_mod_exp_simple
#  define _BN_mod_exp_simple OPENSSL_MANGLER_ASM(BN_mod_exp_simple)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_inverse
#  define BN_mod_inverse OPENSSL_MANGLER(BN_mod_inverse)
# endif
#else
# ifndef _BN_mod_inverse
#  define _BN_mod_inverse OPENSSL_MANGLER_ASM(BN_mod_inverse)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_lshift
#  define BN_mod_lshift OPENSSL_MANGLER(BN_mod_lshift)
# endif
#else
# ifndef _BN_mod_lshift
#  define _BN_mod_lshift OPENSSL_MANGLER_ASM(BN_mod_lshift)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_lshift1
#  define BN_mod_lshift1 OPENSSL_MANGLER(BN_mod_lshift1)
# endif
#else
# ifndef _BN_mod_lshift1
#  define _BN_mod_lshift1 OPENSSL_MANGLER_ASM(BN_mod_lshift1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_lshift1_quick
#  define BN_mod_lshift1_quick OPENSSL_MANGLER(BN_mod_lshift1_quick)
# endif
#else
# ifndef _BN_mod_lshift1_quick
#  define _BN_mod_lshift1_quick OPENSSL_MANGLER_ASM(BN_mod_lshift1_quick)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_lshift_quick
#  define BN_mod_lshift_quick OPENSSL_MANGLER(BN_mod_lshift_quick)
# endif
#else
# ifndef _BN_mod_lshift_quick
#  define _BN_mod_lshift_quick OPENSSL_MANGLER_ASM(BN_mod_lshift_quick)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_mul
#  define BN_mod_mul OPENSSL_MANGLER(BN_mod_mul)
# endif
#else
# ifndef _BN_mod_mul
#  define _BN_mod_mul OPENSSL_MANGLER_ASM(BN_mod_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_mul_montgomery
#  define BN_mod_mul_montgomery OPENSSL_MANGLER(BN_mod_mul_montgomery)
# endif
#else
# ifndef _BN_mod_mul_montgomery
#  define _BN_mod_mul_montgomery OPENSSL_MANGLER_ASM(BN_mod_mul_montgomery)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_mul_reciprocal
#  define BN_mod_mul_reciprocal OPENSSL_MANGLER(BN_mod_mul_reciprocal)
# endif
#else
# ifndef _BN_mod_mul_reciprocal
#  define _BN_mod_mul_reciprocal OPENSSL_MANGLER_ASM(BN_mod_mul_reciprocal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_sqr
#  define BN_mod_sqr OPENSSL_MANGLER(BN_mod_sqr)
# endif
#else
# ifndef _BN_mod_sqr
#  define _BN_mod_sqr OPENSSL_MANGLER_ASM(BN_mod_sqr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_sqrt
#  define BN_mod_sqrt OPENSSL_MANGLER(BN_mod_sqrt)
# endif
#else
# ifndef _BN_mod_sqrt
#  define _BN_mod_sqrt OPENSSL_MANGLER_ASM(BN_mod_sqrt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_sub
#  define BN_mod_sub OPENSSL_MANGLER(BN_mod_sub)
# endif
#else
# ifndef _BN_mod_sub
#  define _BN_mod_sub OPENSSL_MANGLER_ASM(BN_mod_sub)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mod_sub_fixed_top
#  define bn_mod_sub_fixed_top OPENSSL_MANGLER(bn_mod_sub_fixed_top)
# endif
#else
# ifndef _bn_mod_sub_fixed_top
#  define _bn_mod_sub_fixed_top OPENSSL_MANGLER_ASM(bn_mod_sub_fixed_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_sub_quick
#  define BN_mod_sub_quick OPENSSL_MANGLER(BN_mod_sub_quick)
# endif
#else
# ifndef _BN_mod_sub_quick
#  define _BN_mod_sub_quick OPENSSL_MANGLER_ASM(BN_mod_sub_quick)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mod_word
#  define BN_mod_word OPENSSL_MANGLER(BN_mod_word)
# endif
#else
# ifndef _BN_mod_word
#  define _BN_mod_word OPENSSL_MANGLER_ASM(BN_mod_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_MONT_CTX_copy
#  define BN_MONT_CTX_copy OPENSSL_MANGLER(BN_MONT_CTX_copy)
# endif
#else
# ifndef _BN_MONT_CTX_copy
#  define _BN_MONT_CTX_copy OPENSSL_MANGLER_ASM(BN_MONT_CTX_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_MONT_CTX_free
#  define BN_MONT_CTX_free OPENSSL_MANGLER(BN_MONT_CTX_free)
# endif
#else
# ifndef _BN_MONT_CTX_free
#  define _BN_MONT_CTX_free OPENSSL_MANGLER_ASM(BN_MONT_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_MONT_CTX_init
#  define BN_MONT_CTX_init OPENSSL_MANGLER(BN_MONT_CTX_init)
# endif
#else
# ifndef _BN_MONT_CTX_init
#  define _BN_MONT_CTX_init OPENSSL_MANGLER_ASM(BN_MONT_CTX_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_MONT_CTX_new
#  define BN_MONT_CTX_new OPENSSL_MANGLER(BN_MONT_CTX_new)
# endif
#else
# ifndef _BN_MONT_CTX_new
#  define _BN_MONT_CTX_new OPENSSL_MANGLER_ASM(BN_MONT_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_MONT_CTX_set
#  define BN_MONT_CTX_set OPENSSL_MANGLER(BN_MONT_CTX_set)
# endif
#else
# ifndef _BN_MONT_CTX_set
#  define _BN_MONT_CTX_set OPENSSL_MANGLER_ASM(BN_MONT_CTX_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_MONT_CTX_set_locked
#  define BN_MONT_CTX_set_locked OPENSSL_MANGLER(BN_MONT_CTX_set_locked)
# endif
#else
# ifndef _BN_MONT_CTX_set_locked
#  define _BN_MONT_CTX_set_locked OPENSSL_MANGLER_ASM(BN_MONT_CTX_set_locked)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mpi2bn
#  define BN_mpi2bn OPENSSL_MANGLER(BN_mpi2bn)
# endif
#else
# ifndef _BN_mpi2bn
#  define _BN_mpi2bn OPENSSL_MANGLER_ASM(BN_mpi2bn)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mul
#  define BN_mul OPENSSL_MANGLER(BN_mul)
# endif
#else
# ifndef _BN_mul
#  define _BN_mul OPENSSL_MANGLER_ASM(BN_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_add_words
#  define bn_mul_add_words OPENSSL_MANGLER(bn_mul_add_words)
# endif
#else
# ifndef _bn_mul_add_words
#  define _bn_mul_add_words OPENSSL_MANGLER_ASM(bn_mul_add_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_comba4
#  define bn_mul_comba4 OPENSSL_MANGLER(bn_mul_comba4)
# endif
#else
# ifndef _bn_mul_comba4
#  define _bn_mul_comba4 OPENSSL_MANGLER_ASM(bn_mul_comba4)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_comba8
#  define bn_mul_comba8 OPENSSL_MANGLER(bn_mul_comba8)
# endif
#else
# ifndef _bn_mul_comba8
#  define _bn_mul_comba8 OPENSSL_MANGLER_ASM(bn_mul_comba8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_fixed_top
#  define bn_mul_fixed_top OPENSSL_MANGLER(bn_mul_fixed_top)
# endif
#else
# ifndef _bn_mul_fixed_top
#  define _bn_mul_fixed_top OPENSSL_MANGLER_ASM(bn_mul_fixed_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_low_normal
#  define bn_mul_low_normal OPENSSL_MANGLER(bn_mul_low_normal)
# endif
#else
# ifndef _bn_mul_low_normal
#  define _bn_mul_low_normal OPENSSL_MANGLER_ASM(bn_mul_low_normal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_low_recursive
#  define bn_mul_low_recursive OPENSSL_MANGLER(bn_mul_low_recursive)
# endif
#else
# ifndef _bn_mul_low_recursive
#  define _bn_mul_low_recursive OPENSSL_MANGLER_ASM(bn_mul_low_recursive)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_mont
#  define bn_mul_mont OPENSSL_MANGLER(bn_mul_mont)
# endif
#else
# ifndef _bn_mul_mont
#  define _bn_mul_mont OPENSSL_MANGLER_ASM(bn_mul_mont)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_mont_fixed_top
#  define bn_mul_mont_fixed_top OPENSSL_MANGLER(bn_mul_mont_fixed_top)
# endif
#else
# ifndef _bn_mul_mont_fixed_top
#  define _bn_mul_mont_fixed_top OPENSSL_MANGLER_ASM(bn_mul_mont_fixed_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_mont_gather5
#  define bn_mul_mont_gather5 OPENSSL_MANGLER(bn_mul_mont_gather5)
# endif
#else
# ifndef _bn_mul_mont_gather5
#  define _bn_mul_mont_gather5 OPENSSL_MANGLER_ASM(bn_mul_mont_gather5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_normal
#  define bn_mul_normal OPENSSL_MANGLER(bn_mul_normal)
# endif
#else
# ifndef _bn_mul_normal
#  define _bn_mul_normal OPENSSL_MANGLER_ASM(bn_mul_normal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_part_recursive
#  define bn_mul_part_recursive OPENSSL_MANGLER(bn_mul_part_recursive)
# endif
#else
# ifndef _bn_mul_part_recursive
#  define _bn_mul_part_recursive OPENSSL_MANGLER_ASM(bn_mul_part_recursive)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_recursive
#  define bn_mul_recursive OPENSSL_MANGLER(bn_mul_recursive)
# endif
#else
# ifndef _bn_mul_recursive
#  define _bn_mul_recursive OPENSSL_MANGLER_ASM(bn_mul_recursive)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_mul_word
#  define BN_mul_word OPENSSL_MANGLER(BN_mul_word)
# endif
#else
# ifndef _BN_mul_word
#  define _BN_mul_word OPENSSL_MANGLER_ASM(BN_mul_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_mul_words
#  define bn_mul_words OPENSSL_MANGLER(bn_mul_words)
# endif
#else
# ifndef _bn_mul_words
#  define _bn_mul_words OPENSSL_MANGLER_ASM(bn_mul_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_new
#  define BN_new OPENSSL_MANGLER(BN_new)
# endif
#else
# ifndef _BN_new
#  define _BN_new OPENSSL_MANGLER_ASM(BN_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_nist_mod_192
#  define BN_nist_mod_192 OPENSSL_MANGLER(BN_nist_mod_192)
# endif
#else
# ifndef _BN_nist_mod_192
#  define _BN_nist_mod_192 OPENSSL_MANGLER_ASM(BN_nist_mod_192)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_nist_mod_224
#  define BN_nist_mod_224 OPENSSL_MANGLER(BN_nist_mod_224)
# endif
#else
# ifndef _BN_nist_mod_224
#  define _BN_nist_mod_224 OPENSSL_MANGLER_ASM(BN_nist_mod_224)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_nist_mod_256
#  define BN_nist_mod_256 OPENSSL_MANGLER(BN_nist_mod_256)
# endif
#else
# ifndef _BN_nist_mod_256
#  define _BN_nist_mod_256 OPENSSL_MANGLER_ASM(BN_nist_mod_256)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_nist_mod_384
#  define BN_nist_mod_384 OPENSSL_MANGLER(BN_nist_mod_384)
# endif
#else
# ifndef _BN_nist_mod_384
#  define _BN_nist_mod_384 OPENSSL_MANGLER_ASM(BN_nist_mod_384)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_nist_mod_521
#  define BN_nist_mod_521 OPENSSL_MANGLER(BN_nist_mod_521)
# endif
#else
# ifndef _BN_nist_mod_521
#  define _BN_nist_mod_521 OPENSSL_MANGLER_ASM(BN_nist_mod_521)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_nist_mod_func
#  define BN_nist_mod_func OPENSSL_MANGLER(BN_nist_mod_func)
# endif
#else
# ifndef _BN_nist_mod_func
#  define _BN_nist_mod_func OPENSSL_MANGLER_ASM(BN_nist_mod_func)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_nnmod
#  define BN_nnmod OPENSSL_MANGLER(BN_nnmod)
# endif
#else
# ifndef _BN_nnmod
#  define _BN_nnmod OPENSSL_MANGLER_ASM(BN_nnmod)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_num_bits
#  define BN_num_bits OPENSSL_MANGLER(BN_num_bits)
# endif
#else
# ifndef _BN_num_bits
#  define _BN_num_bits OPENSSL_MANGLER_ASM(BN_num_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_num_bits_word
#  define BN_num_bits_word OPENSSL_MANGLER(BN_num_bits_word)
# endif
#else
# ifndef _BN_num_bits_word
#  define _BN_num_bits_word OPENSSL_MANGLER_ASM(BN_num_bits_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_options
#  define BN_options OPENSSL_MANGLER(BN_options)
# endif
#else
# ifndef _BN_options
#  define _BN_options OPENSSL_MANGLER_ASM(BN_options)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_power5
#  define bn_power5 OPENSSL_MANGLER(bn_power5)
# endif
#else
# ifndef _bn_power5
#  define _bn_power5 OPENSSL_MANGLER_ASM(bn_power5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_print
#  define BN_print OPENSSL_MANGLER(BN_print)
# endif
#else
# ifndef _BN_print
#  define _BN_print OPENSSL_MANGLER_ASM(BN_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_print_fp
#  define BN_print_fp OPENSSL_MANGLER(BN_print_fp)
# endif
#else
# ifndef _BN_print_fp
#  define _BN_print_fp OPENSSL_MANGLER_ASM(BN_print_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_priv_rand
#  define BN_priv_rand OPENSSL_MANGLER(BN_priv_rand)
# endif
#else
# ifndef _BN_priv_rand
#  define _BN_priv_rand OPENSSL_MANGLER_ASM(BN_priv_rand)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_priv_rand_range
#  define BN_priv_rand_range OPENSSL_MANGLER(BN_priv_rand_range)
# endif
#else
# ifndef _BN_priv_rand_range
#  define _BN_priv_rand_range OPENSSL_MANGLER_ASM(BN_priv_rand_range)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_probable_prime_dh
#  define bn_probable_prime_dh OPENSSL_MANGLER(bn_probable_prime_dh)
# endif
#else
# ifndef _bn_probable_prime_dh
#  define _bn_probable_prime_dh OPENSSL_MANGLER_ASM(bn_probable_prime_dh)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_pseudo_rand
#  define BN_pseudo_rand OPENSSL_MANGLER(BN_pseudo_rand)
# endif
#else
# ifndef _BN_pseudo_rand
#  define _BN_pseudo_rand OPENSSL_MANGLER_ASM(BN_pseudo_rand)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_pseudo_rand_range
#  define BN_pseudo_rand_range OPENSSL_MANGLER(BN_pseudo_rand_range)
# endif
#else
# ifndef _BN_pseudo_rand_range
#  define _BN_pseudo_rand_range OPENSSL_MANGLER_ASM(BN_pseudo_rand_range)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_rand
#  define BN_rand OPENSSL_MANGLER(BN_rand)
# endif
#else
# ifndef _BN_rand
#  define _BN_rand OPENSSL_MANGLER_ASM(BN_rand)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_rand_range
#  define BN_rand_range OPENSSL_MANGLER(BN_rand_range)
# endif
#else
# ifndef _BN_rand_range
#  define _BN_rand_range OPENSSL_MANGLER_ASM(BN_rand_range)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_reciprocal
#  define BN_reciprocal OPENSSL_MANGLER(BN_reciprocal)
# endif
#else
# ifndef _BN_reciprocal
#  define _BN_reciprocal OPENSSL_MANGLER_ASM(BN_reciprocal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_RECP_CTX_free
#  define BN_RECP_CTX_free OPENSSL_MANGLER(BN_RECP_CTX_free)
# endif
#else
# ifndef _BN_RECP_CTX_free
#  define _BN_RECP_CTX_free OPENSSL_MANGLER_ASM(BN_RECP_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_RECP_CTX_init
#  define BN_RECP_CTX_init OPENSSL_MANGLER(BN_RECP_CTX_init)
# endif
#else
# ifndef _BN_RECP_CTX_init
#  define _BN_RECP_CTX_init OPENSSL_MANGLER_ASM(BN_RECP_CTX_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_RECP_CTX_new
#  define BN_RECP_CTX_new OPENSSL_MANGLER(BN_RECP_CTX_new)
# endif
#else
# ifndef _BN_RECP_CTX_new
#  define _BN_RECP_CTX_new OPENSSL_MANGLER_ASM(BN_RECP_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_RECP_CTX_set
#  define BN_RECP_CTX_set OPENSSL_MANGLER(BN_RECP_CTX_set)
# endif
#else
# ifndef _BN_RECP_CTX_set
#  define _BN_RECP_CTX_set OPENSSL_MANGLER_ASM(BN_RECP_CTX_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_rshift
#  define BN_rshift OPENSSL_MANGLER(BN_rshift)
# endif
#else
# ifndef _BN_rshift
#  define _BN_rshift OPENSSL_MANGLER_ASM(BN_rshift)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_rshift1
#  define BN_rshift1 OPENSSL_MANGLER(BN_rshift1)
# endif
#else
# ifndef _BN_rshift1
#  define _BN_rshift1 OPENSSL_MANGLER_ASM(BN_rshift1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_rshift_fixed_top
#  define bn_rshift_fixed_top OPENSSL_MANGLER(bn_rshift_fixed_top)
# endif
#else
# ifndef _bn_rshift_fixed_top
#  define _bn_rshift_fixed_top OPENSSL_MANGLER_ASM(bn_rshift_fixed_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_scatter5
#  define bn_scatter5 OPENSSL_MANGLER(bn_scatter5)
# endif
#else
# ifndef _bn_scatter5
#  define _bn_scatter5 OPENSSL_MANGLER_ASM(bn_scatter5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_secure_new
#  define BN_secure_new OPENSSL_MANGLER(BN_secure_new)
# endif
#else
# ifndef _BN_secure_new
#  define _BN_secure_new OPENSSL_MANGLER_ASM(BN_secure_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_security_bits
#  define BN_security_bits OPENSSL_MANGLER(BN_security_bits)
# endif
#else
# ifndef _BN_security_bits
#  define _BN_security_bits OPENSSL_MANGLER_ASM(BN_security_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_set_all_zero
#  define bn_set_all_zero OPENSSL_MANGLER(bn_set_all_zero)
# endif
#else
# ifndef _bn_set_all_zero
#  define _bn_set_all_zero OPENSSL_MANGLER_ASM(bn_set_all_zero)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_set_bit
#  define BN_set_bit OPENSSL_MANGLER(BN_set_bit)
# endif
#else
# ifndef _BN_set_bit
#  define _BN_set_bit OPENSSL_MANGLER_ASM(BN_set_bit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_set_flags
#  define BN_set_flags OPENSSL_MANGLER(BN_set_flags)
# endif
#else
# ifndef _BN_set_flags
#  define _BN_set_flags OPENSSL_MANGLER_ASM(BN_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_set_negative
#  define BN_set_negative OPENSSL_MANGLER(BN_set_negative)
# endif
#else
# ifndef _BN_set_negative
#  define _BN_set_negative OPENSSL_MANGLER_ASM(BN_set_negative)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_set_params
#  define BN_set_params OPENSSL_MANGLER(BN_set_params)
# endif
#else
# ifndef _BN_set_params
#  define _BN_set_params OPENSSL_MANGLER_ASM(BN_set_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_set_static_words
#  define bn_set_static_words OPENSSL_MANGLER(bn_set_static_words)
# endif
#else
# ifndef _bn_set_static_words
#  define _bn_set_static_words OPENSSL_MANGLER_ASM(bn_set_static_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_set_word
#  define BN_set_word OPENSSL_MANGLER(BN_set_word)
# endif
#else
# ifndef _BN_set_word
#  define _BN_set_word OPENSSL_MANGLER_ASM(BN_set_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_set_words
#  define bn_set_words OPENSSL_MANGLER(bn_set_words)
# endif
#else
# ifndef _bn_set_words
#  define _bn_set_words OPENSSL_MANGLER_ASM(bn_set_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_sqr
#  define BN_sqr OPENSSL_MANGLER(BN_sqr)
# endif
#else
# ifndef _BN_sqr
#  define _BN_sqr OPENSSL_MANGLER_ASM(BN_sqr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_sqr8x_internal
#  define bn_sqr8x_internal OPENSSL_MANGLER(bn_sqr8x_internal)
# endif
#else
# ifndef _bn_sqr8x_internal
#  define _bn_sqr8x_internal OPENSSL_MANGLER_ASM(bn_sqr8x_internal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_sqr_comba4
#  define bn_sqr_comba4 OPENSSL_MANGLER(bn_sqr_comba4)
# endif
#else
# ifndef _bn_sqr_comba4
#  define _bn_sqr_comba4 OPENSSL_MANGLER_ASM(bn_sqr_comba4)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_sqr_comba8
#  define bn_sqr_comba8 OPENSSL_MANGLER(bn_sqr_comba8)
# endif
#else
# ifndef _bn_sqr_comba8
#  define _bn_sqr_comba8 OPENSSL_MANGLER_ASM(bn_sqr_comba8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_sqr_fixed_top
#  define bn_sqr_fixed_top OPENSSL_MANGLER(bn_sqr_fixed_top)
# endif
#else
# ifndef _bn_sqr_fixed_top
#  define _bn_sqr_fixed_top OPENSSL_MANGLER_ASM(bn_sqr_fixed_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_sqr_normal
#  define bn_sqr_normal OPENSSL_MANGLER(bn_sqr_normal)
# endif
#else
# ifndef _bn_sqr_normal
#  define _bn_sqr_normal OPENSSL_MANGLER_ASM(bn_sqr_normal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_sqr_recursive
#  define bn_sqr_recursive OPENSSL_MANGLER(bn_sqr_recursive)
# endif
#else
# ifndef _bn_sqr_recursive
#  define _bn_sqr_recursive OPENSSL_MANGLER_ASM(bn_sqr_recursive)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_sqr_words
#  define bn_sqr_words OPENSSL_MANGLER(bn_sqr_words)
# endif
#else
# ifndef _bn_sqr_words
#  define _bn_sqr_words OPENSSL_MANGLER_ASM(bn_sqr_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_sub
#  define BN_sub OPENSSL_MANGLER(BN_sub)
# endif
#else
# ifndef _BN_sub
#  define _BN_sub OPENSSL_MANGLER_ASM(BN_sub)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_sub_part_words
#  define bn_sub_part_words OPENSSL_MANGLER(bn_sub_part_words)
# endif
#else
# ifndef _bn_sub_part_words
#  define _bn_sub_part_words OPENSSL_MANGLER_ASM(bn_sub_part_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_sub_word
#  define BN_sub_word OPENSSL_MANGLER(BN_sub_word)
# endif
#else
# ifndef _BN_sub_word
#  define _BN_sub_word OPENSSL_MANGLER_ASM(BN_sub_word)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_sub_words
#  define bn_sub_words OPENSSL_MANGLER(bn_sub_words)
# endif
#else
# ifndef _bn_sub_words
#  define _bn_sub_words OPENSSL_MANGLER_ASM(bn_sub_words)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_swap
#  define BN_swap OPENSSL_MANGLER(BN_swap)
# endif
#else
# ifndef _BN_swap
#  define _BN_swap OPENSSL_MANGLER_ASM(BN_swap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_to_ASN1_ENUMERATED
#  define BN_to_ASN1_ENUMERATED OPENSSL_MANGLER(BN_to_ASN1_ENUMERATED)
# endif
#else
# ifndef _BN_to_ASN1_ENUMERATED
#  define _BN_to_ASN1_ENUMERATED OPENSSL_MANGLER_ASM(BN_to_ASN1_ENUMERATED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_to_ASN1_INTEGER
#  define BN_to_ASN1_INTEGER OPENSSL_MANGLER(BN_to_ASN1_INTEGER)
# endif
#else
# ifndef _BN_to_ASN1_INTEGER
#  define _BN_to_ASN1_INTEGER OPENSSL_MANGLER_ASM(BN_to_ASN1_INTEGER)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_to_mont_fixed_top
#  define bn_to_mont_fixed_top OPENSSL_MANGLER(bn_to_mont_fixed_top)
# endif
#else
# ifndef _bn_to_mont_fixed_top
#  define _bn_to_mont_fixed_top OPENSSL_MANGLER_ASM(bn_to_mont_fixed_top)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_to_montgomery
#  define BN_to_montgomery OPENSSL_MANGLER(BN_to_montgomery)
# endif
#else
# ifndef _BN_to_montgomery
#  define _BN_to_montgomery OPENSSL_MANGLER_ASM(BN_to_montgomery)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_uadd
#  define BN_uadd OPENSSL_MANGLER(BN_uadd)
# endif
#else
# ifndef _BN_uadd
#  define _BN_uadd OPENSSL_MANGLER_ASM(BN_uadd)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_ucmp
#  define BN_ucmp OPENSSL_MANGLER(BN_ucmp)
# endif
#else
# ifndef _BN_ucmp
#  define _BN_ucmp OPENSSL_MANGLER_ASM(BN_ucmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_usub
#  define BN_usub OPENSSL_MANGLER(BN_usub)
# endif
#else
# ifndef _BN_usub
#  define _BN_usub OPENSSL_MANGLER_ASM(BN_usub)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_value_one
#  define BN_value_one OPENSSL_MANGLER(BN_value_one)
# endif
#else
# ifndef _BN_value_one
#  define _BN_value_one OPENSSL_MANGLER_ASM(BN_value_one)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bn_wexpand
#  define bn_wexpand OPENSSL_MANGLER(bn_wexpand)
# endif
#else
# ifndef _bn_wexpand
#  define _bn_wexpand OPENSSL_MANGLER_ASM(bn_wexpand)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_with_flags
#  define BN_with_flags OPENSSL_MANGLER(BN_with_flags)
# endif
#else
# ifndef _BN_with_flags
#  define _BN_with_flags OPENSSL_MANGLER_ASM(BN_with_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_X931_derive_prime_ex
#  define BN_X931_derive_prime_ex OPENSSL_MANGLER(BN_X931_derive_prime_ex)
# endif
#else
# ifndef _BN_X931_derive_prime_ex
#  define _BN_X931_derive_prime_ex OPENSSL_MANGLER_ASM(BN_X931_derive_prime_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_X931_generate_prime_ex
#  define BN_X931_generate_prime_ex OPENSSL_MANGLER(BN_X931_generate_prime_ex)
# endif
#else
# ifndef _BN_X931_generate_prime_ex
#  define _BN_X931_generate_prime_ex OPENSSL_MANGLER_ASM(BN_X931_generate_prime_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_X931_generate_Xpq
#  define BN_X931_generate_Xpq OPENSSL_MANGLER(BN_X931_generate_Xpq)
# endif
#else
# ifndef _BN_X931_generate_Xpq
#  define _BN_X931_generate_Xpq OPENSSL_MANGLER_ASM(BN_X931_generate_Xpq)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BN_zero_ex
#  define BN_zero_ex OPENSSL_MANGLER(BN_zero_ex)
# endif
#else
# ifndef _BN_zero_ex
#  define _BN_zero_ex OPENSSL_MANGLER_ASM(BN_zero_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bread_conv
#  define bread_conv OPENSSL_MANGLER(bread_conv)
# endif
#else
# ifndef _bread_conv
#  define _bread_conv OPENSSL_MANGLER_ASM(bread_conv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bsaes_cbc_encrypt
#  define bsaes_cbc_encrypt OPENSSL_MANGLER(bsaes_cbc_encrypt)
# endif
#else
# ifndef _bsaes_cbc_encrypt
#  define _bsaes_cbc_encrypt OPENSSL_MANGLER_ASM(bsaes_cbc_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bsaes_ctr32_encrypt_blocks
#  define bsaes_ctr32_encrypt_blocks OPENSSL_MANGLER(bsaes_ctr32_encrypt_blocks)
# endif
#else
# ifndef _bsaes_ctr32_encrypt_blocks
#  define _bsaes_ctr32_encrypt_blocks OPENSSL_MANGLER_ASM(bsaes_ctr32_encrypt_blocks)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bsaes_xts_decrypt
#  define bsaes_xts_decrypt OPENSSL_MANGLER(bsaes_xts_decrypt)
# endif
#else
# ifndef _bsaes_xts_decrypt
#  define _bsaes_xts_decrypt OPENSSL_MANGLER_ASM(bsaes_xts_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bsaes_xts_encrypt
#  define bsaes_xts_encrypt OPENSSL_MANGLER(bsaes_xts_encrypt)
# endif
#else
# ifndef _bsaes_xts_encrypt
#  define _bsaes_xts_encrypt OPENSSL_MANGLER_ASM(bsaes_xts_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BUF_MEM_free
#  define BUF_MEM_free OPENSSL_MANGLER(BUF_MEM_free)
# endif
#else
# ifndef _BUF_MEM_free
#  define _BUF_MEM_free OPENSSL_MANGLER_ASM(BUF_MEM_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BUF_MEM_grow
#  define BUF_MEM_grow OPENSSL_MANGLER(BUF_MEM_grow)
# endif
#else
# ifndef _BUF_MEM_grow
#  define _BUF_MEM_grow OPENSSL_MANGLER_ASM(BUF_MEM_grow)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BUF_MEM_grow_clean
#  define BUF_MEM_grow_clean OPENSSL_MANGLER(BUF_MEM_grow_clean)
# endif
#else
# ifndef _BUF_MEM_grow_clean
#  define _BUF_MEM_grow_clean OPENSSL_MANGLER_ASM(BUF_MEM_grow_clean)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BUF_MEM_new
#  define BUF_MEM_new OPENSSL_MANGLER(BUF_MEM_new)
# endif
#else
# ifndef _BUF_MEM_new
#  define _BUF_MEM_new OPENSSL_MANGLER_ASM(BUF_MEM_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BUF_MEM_new_ex
#  define BUF_MEM_new_ex OPENSSL_MANGLER(BUF_MEM_new_ex)
# endif
#else
# ifndef _BUF_MEM_new_ex
#  define _BUF_MEM_new_ex OPENSSL_MANGLER_ASM(BUF_MEM_new_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef BUF_reverse
#  define BUF_reverse OPENSSL_MANGLER(BUF_reverse)
# endif
#else
# ifndef _BUF_reverse
#  define _BUF_reverse OPENSSL_MANGLER_ASM(BUF_reverse)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bwrite_conv
#  define bwrite_conv OPENSSL_MANGLER(bwrite_conv)
# endif
#else
# ifndef _bwrite_conv
#  define _bwrite_conv OPENSSL_MANGLER_ASM(bwrite_conv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef bytes_to_cipher_list
#  define bytes_to_cipher_list OPENSSL_MANGLER(bytes_to_cipher_list)
# endif
#else
# ifndef _bytes_to_cipher_list
#  define _bytes_to_cipher_list OPENSSL_MANGLER_ASM(bytes_to_cipher_list)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef c2i_ASN1_BIT_STRING
#  define c2i_ASN1_BIT_STRING OPENSSL_MANGLER(c2i_ASN1_BIT_STRING)
# endif
#else
# ifndef _c2i_ASN1_BIT_STRING
#  define _c2i_ASN1_BIT_STRING OPENSSL_MANGLER_ASM(c2i_ASN1_BIT_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef c2i_ASN1_INTEGER
#  define c2i_ASN1_INTEGER OPENSSL_MANGLER(c2i_ASN1_INTEGER)
# endif
#else
# ifndef _c2i_ASN1_INTEGER
#  define _c2i_ASN1_INTEGER OPENSSL_MANGLER_ASM(c2i_ASN1_INTEGER)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef c2i_ASN1_OBJECT
#  define c2i_ASN1_OBJECT OPENSSL_MANGLER(c2i_ASN1_OBJECT)
# endif
#else
# ifndef _c2i_ASN1_OBJECT
#  define _c2i_ASN1_OBJECT OPENSSL_MANGLER_ASM(c2i_ASN1_OBJECT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef c2i_uint64_int
#  define c2i_uint64_int OPENSSL_MANGLER(c2i_uint64_int)
# endif
#else
# ifndef _c2i_uint64_int
#  define _c2i_uint64_int OPENSSL_MANGLER_ASM(c2i_uint64_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef c448_ed448_convert_private_key_to_x448
#  define c448_ed448_convert_private_key_to_x448 OPENSSL_MANGLER(c448_ed448_convert_private_key_to_x448)
# endif
#else
# ifndef _c448_ed448_convert_private_key_to_x448
#  define _c448_ed448_convert_private_key_to_x448 OPENSSL_MANGLER_ASM(c448_ed448_convert_private_key_to_x448)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef c448_ed448_derive_public_key
#  define c448_ed448_derive_public_key OPENSSL_MANGLER(c448_ed448_derive_public_key)
# endif
#else
# ifndef _c448_ed448_derive_public_key
#  define _c448_ed448_derive_public_key OPENSSL_MANGLER_ASM(c448_ed448_derive_public_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef c448_ed448_sign
#  define c448_ed448_sign OPENSSL_MANGLER(c448_ed448_sign)
# endif
#else
# ifndef _c448_ed448_sign
#  define _c448_ed448_sign OPENSSL_MANGLER_ASM(c448_ed448_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef c448_ed448_sign_prehash
#  define c448_ed448_sign_prehash OPENSSL_MANGLER(c448_ed448_sign_prehash)
# endif
#else
# ifndef _c448_ed448_sign_prehash
#  define _c448_ed448_sign_prehash OPENSSL_MANGLER_ASM(c448_ed448_sign_prehash)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef c448_ed448_verify
#  define c448_ed448_verify OPENSSL_MANGLER(c448_ed448_verify)
# endif
#else
# ifndef _c448_ed448_verify
#  define _c448_ed448_verify OPENSSL_MANGLER_ASM(c448_ed448_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef c448_ed448_verify_prehash
#  define c448_ed448_verify_prehash OPENSSL_MANGLER(c448_ed448_verify_prehash)
# endif
#else
# ifndef _c448_ed448_verify_prehash
#  define _c448_ed448_verify_prehash OPENSSL_MANGLER_ASM(c448_ed448_verify_prehash)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CBIGNUM_it
#  define CBIGNUM_it OPENSSL_MANGLER(CBIGNUM_it)
# endif
#else
# ifndef _CBIGNUM_it
#  define _CBIGNUM_it OPENSSL_MANGLER_ASM(CBIGNUM_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CERTIFICATEPOLICIES_free
#  define CERTIFICATEPOLICIES_free OPENSSL_MANGLER(CERTIFICATEPOLICIES_free)
# endif
#else
# ifndef _CERTIFICATEPOLICIES_free
#  define _CERTIFICATEPOLICIES_free OPENSSL_MANGLER_ASM(CERTIFICATEPOLICIES_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CERTIFICATEPOLICIES_it
#  define CERTIFICATEPOLICIES_it OPENSSL_MANGLER(CERTIFICATEPOLICIES_it)
# endif
#else
# ifndef _CERTIFICATEPOLICIES_it
#  define _CERTIFICATEPOLICIES_it OPENSSL_MANGLER_ASM(CERTIFICATEPOLICIES_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CERTIFICATEPOLICIES_new
#  define CERTIFICATEPOLICIES_new OPENSSL_MANGLER(CERTIFICATEPOLICIES_new)
# endif
#else
# ifndef _CERTIFICATEPOLICIES_new
#  define _CERTIFICATEPOLICIES_new OPENSSL_MANGLER_ASM(CERTIFICATEPOLICIES_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ChaCha20_ctr32
#  define ChaCha20_ctr32 OPENSSL_MANGLER(ChaCha20_ctr32)
# endif
#else
# ifndef _ChaCha20_ctr32
#  define _ChaCha20_ctr32 OPENSSL_MANGLER_ASM(ChaCha20_ctr32)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef check_in_list
#  define check_in_list OPENSSL_MANGLER(check_in_list)
# endif
#else
# ifndef _check_in_list
#  define _check_in_list OPENSSL_MANGLER_ASM(check_in_list)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cmac_asn1_meth
#  define cmac_asn1_meth OPENSSL_MANGLER(cmac_asn1_meth)
# endif
#else
# ifndef _cmac_asn1_meth
#  define _cmac_asn1_meth OPENSSL_MANGLER_ASM(cmac_asn1_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMAC_CTX_cleanup
#  define CMAC_CTX_cleanup OPENSSL_MANGLER(CMAC_CTX_cleanup)
# endif
#else
# ifndef _CMAC_CTX_cleanup
#  define _CMAC_CTX_cleanup OPENSSL_MANGLER_ASM(CMAC_CTX_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMAC_CTX_copy
#  define CMAC_CTX_copy OPENSSL_MANGLER(CMAC_CTX_copy)
# endif
#else
# ifndef _CMAC_CTX_copy
#  define _CMAC_CTX_copy OPENSSL_MANGLER_ASM(CMAC_CTX_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMAC_CTX_free
#  define CMAC_CTX_free OPENSSL_MANGLER(CMAC_CTX_free)
# endif
#else
# ifndef _CMAC_CTX_free
#  define _CMAC_CTX_free OPENSSL_MANGLER_ASM(CMAC_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMAC_CTX_get0_cipher_ctx
#  define CMAC_CTX_get0_cipher_ctx OPENSSL_MANGLER(CMAC_CTX_get0_cipher_ctx)
# endif
#else
# ifndef _CMAC_CTX_get0_cipher_ctx
#  define _CMAC_CTX_get0_cipher_ctx OPENSSL_MANGLER_ASM(CMAC_CTX_get0_cipher_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMAC_CTX_new
#  define CMAC_CTX_new OPENSSL_MANGLER(CMAC_CTX_new)
# endif
#else
# ifndef _CMAC_CTX_new
#  define _CMAC_CTX_new OPENSSL_MANGLER_ASM(CMAC_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMAC_Final
#  define CMAC_Final OPENSSL_MANGLER(CMAC_Final)
# endif
#else
# ifndef _CMAC_Final
#  define _CMAC_Final OPENSSL_MANGLER_ASM(CMAC_Final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMAC_Init
#  define CMAC_Init OPENSSL_MANGLER(CMAC_Init)
# endif
#else
# ifndef _CMAC_Init
#  define _CMAC_Init OPENSSL_MANGLER_ASM(CMAC_Init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cmac_pkey_meth
#  define cmac_pkey_meth OPENSSL_MANGLER(cmac_pkey_meth)
# endif
#else
# ifndef _cmac_pkey_meth
#  define _cmac_pkey_meth OPENSSL_MANGLER_ASM(cmac_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMAC_resume
#  define CMAC_resume OPENSSL_MANGLER(CMAC_resume)
# endif
#else
# ifndef _CMAC_resume
#  define _CMAC_resume OPENSSL_MANGLER_ASM(CMAC_resume)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMAC_Update
#  define CMAC_Update OPENSSL_MANGLER(CMAC_Update)
# endif
#else
# ifndef _CMAC_Update
#  define _CMAC_Update OPENSSL_MANGLER_ASM(CMAC_Update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add0_cert
#  define CMS_add0_cert OPENSSL_MANGLER(CMS_add0_cert)
# endif
#else
# ifndef _CMS_add0_cert
#  define _CMS_add0_cert OPENSSL_MANGLER_ASM(CMS_add0_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add0_CertificateChoices
#  define CMS_add0_CertificateChoices OPENSSL_MANGLER(CMS_add0_CertificateChoices)
# endif
#else
# ifndef _CMS_add0_CertificateChoices
#  define _CMS_add0_CertificateChoices OPENSSL_MANGLER_ASM(CMS_add0_CertificateChoices)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add0_crl
#  define CMS_add0_crl OPENSSL_MANGLER(CMS_add0_crl)
# endif
#else
# ifndef _CMS_add0_crl
#  define _CMS_add0_crl OPENSSL_MANGLER_ASM(CMS_add0_crl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add0_recipient_key
#  define CMS_add0_recipient_key OPENSSL_MANGLER(CMS_add0_recipient_key)
# endif
#else
# ifndef _CMS_add0_recipient_key
#  define _CMS_add0_recipient_key OPENSSL_MANGLER_ASM(CMS_add0_recipient_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add0_recipient_password
#  define CMS_add0_recipient_password OPENSSL_MANGLER(CMS_add0_recipient_password)
# endif
#else
# ifndef _CMS_add0_recipient_password
#  define _CMS_add0_recipient_password OPENSSL_MANGLER_ASM(CMS_add0_recipient_password)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add0_RevocationInfoChoice
#  define CMS_add0_RevocationInfoChoice OPENSSL_MANGLER(CMS_add0_RevocationInfoChoice)
# endif
#else
# ifndef _CMS_add0_RevocationInfoChoice
#  define _CMS_add0_RevocationInfoChoice OPENSSL_MANGLER_ASM(CMS_add0_RevocationInfoChoice)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add1_cert
#  define CMS_add1_cert OPENSSL_MANGLER(CMS_add1_cert)
# endif
#else
# ifndef _CMS_add1_cert
#  define _CMS_add1_cert OPENSSL_MANGLER_ASM(CMS_add1_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add1_crl
#  define CMS_add1_crl OPENSSL_MANGLER(CMS_add1_crl)
# endif
#else
# ifndef _CMS_add1_crl
#  define _CMS_add1_crl OPENSSL_MANGLER_ASM(CMS_add1_crl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add1_ReceiptRequest
#  define CMS_add1_ReceiptRequest OPENSSL_MANGLER(CMS_add1_ReceiptRequest)
# endif
#else
# ifndef _CMS_add1_ReceiptRequest
#  define _CMS_add1_ReceiptRequest OPENSSL_MANGLER_ASM(CMS_add1_ReceiptRequest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add1_recipient_cert
#  define CMS_add1_recipient_cert OPENSSL_MANGLER(CMS_add1_recipient_cert)
# endif
#else
# ifndef _CMS_add1_recipient_cert
#  define _CMS_add1_recipient_cert OPENSSL_MANGLER_ASM(CMS_add1_recipient_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add1_signer
#  define CMS_add1_signer OPENSSL_MANGLER(CMS_add1_signer)
# endif
#else
# ifndef _CMS_add1_signer
#  define _CMS_add1_signer OPENSSL_MANGLER_ASM(CMS_add1_signer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add_simple_smimecap
#  define CMS_add_simple_smimecap OPENSSL_MANGLER(CMS_add_simple_smimecap)
# endif
#else
# ifndef _CMS_add_simple_smimecap
#  define _CMS_add_simple_smimecap OPENSSL_MANGLER_ASM(CMS_add_simple_smimecap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add_smimecap
#  define CMS_add_smimecap OPENSSL_MANGLER(CMS_add_smimecap)
# endif
#else
# ifndef _CMS_add_smimecap
#  define _CMS_add_smimecap OPENSSL_MANGLER_ASM(CMS_add_smimecap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_add_standard_smimecap
#  define CMS_add_standard_smimecap OPENSSL_MANGLER(CMS_add_standard_smimecap)
# endif
#else
# ifndef _CMS_add_standard_smimecap
#  define _CMS_add_standard_smimecap OPENSSL_MANGLER_ASM(CMS_add_standard_smimecap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_Attributes_Sign_it
#  define CMS_Attributes_Sign_it OPENSSL_MANGLER(CMS_Attributes_Sign_it)
# endif
#else
# ifndef _CMS_Attributes_Sign_it
#  define _CMS_Attributes_Sign_it OPENSSL_MANGLER_ASM(CMS_Attributes_Sign_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_Attributes_Verify_it
#  define CMS_Attributes_Verify_it OPENSSL_MANGLER(CMS_Attributes_Verify_it)
# endif
#else
# ifndef _CMS_Attributes_Verify_it
#  define _CMS_Attributes_Verify_it OPENSSL_MANGLER_ASM(CMS_Attributes_Verify_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_CertificateChoices_it
#  define CMS_CertificateChoices_it OPENSSL_MANGLER(CMS_CertificateChoices_it)
# endif
#else
# ifndef _CMS_CertificateChoices_it
#  define _CMS_CertificateChoices_it OPENSSL_MANGLER_ASM(CMS_CertificateChoices_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_compress
#  define CMS_compress OPENSSL_MANGLER(CMS_compress)
# endif
#else
# ifndef _CMS_compress
#  define _CMS_compress OPENSSL_MANGLER_ASM(CMS_compress)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_CompressedData_it
#  define CMS_CompressedData_it OPENSSL_MANGLER(CMS_CompressedData_it)
# endif
#else
# ifndef _CMS_CompressedData_it
#  define _CMS_CompressedData_it OPENSSL_MANGLER_ASM(CMS_CompressedData_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_content_bio
#  define cms_content_bio OPENSSL_MANGLER(cms_content_bio)
# endif
#else
# ifndef _cms_content_bio
#  define _cms_content_bio OPENSSL_MANGLER_ASM(cms_content_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_ContentInfo_free
#  define CMS_ContentInfo_free OPENSSL_MANGLER(CMS_ContentInfo_free)
# endif
#else
# ifndef _CMS_ContentInfo_free
#  define _CMS_ContentInfo_free OPENSSL_MANGLER_ASM(CMS_ContentInfo_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_ContentInfo_it
#  define CMS_ContentInfo_it OPENSSL_MANGLER(CMS_ContentInfo_it)
# endif
#else
# ifndef _CMS_ContentInfo_it
#  define _CMS_ContentInfo_it OPENSSL_MANGLER_ASM(CMS_ContentInfo_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_ContentInfo_new
#  define CMS_ContentInfo_new OPENSSL_MANGLER(CMS_ContentInfo_new)
# endif
#else
# ifndef _CMS_ContentInfo_new
#  define _CMS_ContentInfo_new OPENSSL_MANGLER_ASM(CMS_ContentInfo_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_ContentInfo_print_ctx
#  define CMS_ContentInfo_print_ctx OPENSSL_MANGLER(CMS_ContentInfo_print_ctx)
# endif
#else
# ifndef _CMS_ContentInfo_print_ctx
#  define _CMS_ContentInfo_print_ctx OPENSSL_MANGLER_ASM(CMS_ContentInfo_print_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_data
#  define CMS_data OPENSSL_MANGLER(CMS_data)
# endif
#else
# ifndef _CMS_data
#  define _CMS_data OPENSSL_MANGLER_ASM(CMS_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_Data_create
#  define cms_Data_create OPENSSL_MANGLER(cms_Data_create)
# endif
#else
# ifndef _cms_Data_create
#  define _cms_Data_create OPENSSL_MANGLER_ASM(cms_Data_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_data_create
#  define CMS_data_create OPENSSL_MANGLER(CMS_data_create)
# endif
#else
# ifndef _CMS_data_create
#  define _CMS_data_create OPENSSL_MANGLER_ASM(CMS_data_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_dataFinal
#  define CMS_dataFinal OPENSSL_MANGLER(CMS_dataFinal)
# endif
#else
# ifndef _CMS_dataFinal
#  define _CMS_dataFinal OPENSSL_MANGLER_ASM(CMS_dataFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_dataInit
#  define CMS_dataInit OPENSSL_MANGLER(CMS_dataInit)
# endif
#else
# ifndef _CMS_dataInit
#  define _CMS_dataInit OPENSSL_MANGLER_ASM(CMS_dataInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_decrypt
#  define CMS_decrypt OPENSSL_MANGLER(CMS_decrypt)
# endif
#else
# ifndef _CMS_decrypt
#  define _CMS_decrypt OPENSSL_MANGLER_ASM(CMS_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_decrypt_set1_key
#  define CMS_decrypt_set1_key OPENSSL_MANGLER(CMS_decrypt_set1_key)
# endif
#else
# ifndef _CMS_decrypt_set1_key
#  define _CMS_decrypt_set1_key OPENSSL_MANGLER_ASM(CMS_decrypt_set1_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_decrypt_set1_password
#  define CMS_decrypt_set1_password OPENSSL_MANGLER(CMS_decrypt_set1_password)
# endif
#else
# ifndef _CMS_decrypt_set1_password
#  define _CMS_decrypt_set1_password OPENSSL_MANGLER_ASM(CMS_decrypt_set1_password)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_decrypt_set1_pkey
#  define CMS_decrypt_set1_pkey OPENSSL_MANGLER(CMS_decrypt_set1_pkey)
# endif
#else
# ifndef _CMS_decrypt_set1_pkey
#  define _CMS_decrypt_set1_pkey OPENSSL_MANGLER_ASM(CMS_decrypt_set1_pkey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_DigestAlgorithm_find_ctx
#  define cms_DigestAlgorithm_find_ctx OPENSSL_MANGLER(cms_DigestAlgorithm_find_ctx)
# endif
#else
# ifndef _cms_DigestAlgorithm_find_ctx
#  define _cms_DigestAlgorithm_find_ctx OPENSSL_MANGLER_ASM(cms_DigestAlgorithm_find_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_DigestAlgorithm_init_bio
#  define cms_DigestAlgorithm_init_bio OPENSSL_MANGLER(cms_DigestAlgorithm_init_bio)
# endif
#else
# ifndef _cms_DigestAlgorithm_init_bio
#  define _cms_DigestAlgorithm_init_bio OPENSSL_MANGLER_ASM(cms_DigestAlgorithm_init_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_digest_create
#  define CMS_digest_create OPENSSL_MANGLER(CMS_digest_create)
# endif
#else
# ifndef _CMS_digest_create
#  define _CMS_digest_create OPENSSL_MANGLER_ASM(CMS_digest_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_DigestedData_create
#  define cms_DigestedData_create OPENSSL_MANGLER(cms_DigestedData_create)
# endif
#else
# ifndef _cms_DigestedData_create
#  define _cms_DigestedData_create OPENSSL_MANGLER_ASM(cms_DigestedData_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_DigestedData_do_final
#  define cms_DigestedData_do_final OPENSSL_MANGLER(cms_DigestedData_do_final)
# endif
#else
# ifndef _cms_DigestedData_do_final
#  define _cms_DigestedData_do_final OPENSSL_MANGLER_ASM(cms_DigestedData_do_final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_DigestedData_init_bio
#  define cms_DigestedData_init_bio OPENSSL_MANGLER(cms_DigestedData_init_bio)
# endif
#else
# ifndef _cms_DigestedData_init_bio
#  define _cms_DigestedData_init_bio OPENSSL_MANGLER_ASM(cms_DigestedData_init_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_DigestedData_it
#  define CMS_DigestedData_it OPENSSL_MANGLER(CMS_DigestedData_it)
# endif
#else
# ifndef _CMS_DigestedData_it
#  define _CMS_DigestedData_it OPENSSL_MANGLER_ASM(CMS_DigestedData_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_digest_verify
#  define CMS_digest_verify OPENSSL_MANGLER(CMS_digest_verify)
# endif
#else
# ifndef _CMS_digest_verify
#  define _CMS_digest_verify OPENSSL_MANGLER_ASM(CMS_digest_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_encode_Receipt
#  define cms_encode_Receipt OPENSSL_MANGLER(cms_encode_Receipt)
# endif
#else
# ifndef _cms_encode_Receipt
#  define _cms_encode_Receipt OPENSSL_MANGLER_ASM(cms_encode_Receipt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_encrypt
#  define CMS_encrypt OPENSSL_MANGLER(CMS_encrypt)
# endif
#else
# ifndef _CMS_encrypt
#  define _CMS_encrypt OPENSSL_MANGLER_ASM(CMS_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_EncryptedContent_init
#  define cms_EncryptedContent_init OPENSSL_MANGLER(cms_EncryptedContent_init)
# endif
#else
# ifndef _cms_EncryptedContent_init
#  define _cms_EncryptedContent_init OPENSSL_MANGLER_ASM(cms_EncryptedContent_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_EncryptedContent_init_bio
#  define cms_EncryptedContent_init_bio OPENSSL_MANGLER(cms_EncryptedContent_init_bio)
# endif
#else
# ifndef _cms_EncryptedContent_init_bio
#  define _cms_EncryptedContent_init_bio OPENSSL_MANGLER_ASM(cms_EncryptedContent_init_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_EncryptedData_decrypt
#  define CMS_EncryptedData_decrypt OPENSSL_MANGLER(CMS_EncryptedData_decrypt)
# endif
#else
# ifndef _CMS_EncryptedData_decrypt
#  define _CMS_EncryptedData_decrypt OPENSSL_MANGLER_ASM(CMS_EncryptedData_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_EncryptedData_encrypt
#  define CMS_EncryptedData_encrypt OPENSSL_MANGLER(CMS_EncryptedData_encrypt)
# endif
#else
# ifndef _CMS_EncryptedData_encrypt
#  define _CMS_EncryptedData_encrypt OPENSSL_MANGLER_ASM(CMS_EncryptedData_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_EncryptedData_init_bio
#  define cms_EncryptedData_init_bio OPENSSL_MANGLER(cms_EncryptedData_init_bio)
# endif
#else
# ifndef _cms_EncryptedData_init_bio
#  define _cms_EncryptedData_init_bio OPENSSL_MANGLER_ASM(cms_EncryptedData_init_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_EncryptedData_it
#  define CMS_EncryptedData_it OPENSSL_MANGLER(CMS_EncryptedData_it)
# endif
#else
# ifndef _CMS_EncryptedData_it
#  define _CMS_EncryptedData_it OPENSSL_MANGLER_ASM(CMS_EncryptedData_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_EncryptedData_set1_key
#  define CMS_EncryptedData_set1_key OPENSSL_MANGLER(CMS_EncryptedData_set1_key)
# endif
#else
# ifndef _CMS_EncryptedData_set1_key
#  define _CMS_EncryptedData_set1_key OPENSSL_MANGLER_ASM(CMS_EncryptedData_set1_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_env_asn1_ctrl
#  define cms_env_asn1_ctrl OPENSSL_MANGLER(cms_env_asn1_ctrl)
# endif
#else
# ifndef _cms_env_asn1_ctrl
#  define _cms_env_asn1_ctrl OPENSSL_MANGLER_ASM(cms_env_asn1_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_EnvelopedData_create
#  define CMS_EnvelopedData_create OPENSSL_MANGLER(CMS_EnvelopedData_create)
# endif
#else
# ifndef _CMS_EnvelopedData_create
#  define _CMS_EnvelopedData_create OPENSSL_MANGLER_ASM(CMS_EnvelopedData_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_EnvelopedData_init_bio
#  define cms_EnvelopedData_init_bio OPENSSL_MANGLER(cms_EnvelopedData_init_bio)
# endif
#else
# ifndef _cms_EnvelopedData_init_bio
#  define _cms_EnvelopedData_init_bio OPENSSL_MANGLER_ASM(cms_EnvelopedData_init_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_EnvelopedData_it
#  define CMS_EnvelopedData_it OPENSSL_MANGLER(CMS_EnvelopedData_it)
# endif
#else
# ifndef _CMS_EnvelopedData_it
#  define _CMS_EnvelopedData_it OPENSSL_MANGLER_ASM(CMS_EnvelopedData_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_final
#  define CMS_final OPENSSL_MANGLER(CMS_final)
# endif
#else
# ifndef _CMS_final
#  define _CMS_final OPENSSL_MANGLER_ASM(CMS_final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_get0_content
#  define CMS_get0_content OPENSSL_MANGLER(CMS_get0_content)
# endif
#else
# ifndef _CMS_get0_content
#  define _CMS_get0_content OPENSSL_MANGLER_ASM(CMS_get0_content)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_get0_eContentType
#  define CMS_get0_eContentType OPENSSL_MANGLER(CMS_get0_eContentType)
# endif
#else
# ifndef _CMS_get0_eContentType
#  define _CMS_get0_eContentType OPENSSL_MANGLER_ASM(CMS_get0_eContentType)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_get0_enveloped
#  define cms_get0_enveloped OPENSSL_MANGLER(cms_get0_enveloped)
# endif
#else
# ifndef _cms_get0_enveloped
#  define _cms_get0_enveloped OPENSSL_MANGLER_ASM(cms_get0_enveloped)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_get0_RecipientInfos
#  define CMS_get0_RecipientInfos OPENSSL_MANGLER(CMS_get0_RecipientInfos)
# endif
#else
# ifndef _CMS_get0_RecipientInfos
#  define _CMS_get0_RecipientInfos OPENSSL_MANGLER_ASM(CMS_get0_RecipientInfos)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_get0_SignerInfos
#  define CMS_get0_SignerInfos OPENSSL_MANGLER(CMS_get0_SignerInfos)
# endif
#else
# ifndef _CMS_get0_SignerInfos
#  define _CMS_get0_SignerInfos OPENSSL_MANGLER_ASM(CMS_get0_SignerInfos)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_get0_signers
#  define CMS_get0_signers OPENSSL_MANGLER(CMS_get0_signers)
# endif
#else
# ifndef _CMS_get0_signers
#  define _CMS_get0_signers OPENSSL_MANGLER_ASM(CMS_get0_signers)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_get0_type
#  define CMS_get0_type OPENSSL_MANGLER(CMS_get0_type)
# endif
#else
# ifndef _CMS_get0_type
#  define _CMS_get0_type OPENSSL_MANGLER_ASM(CMS_get0_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_get1_certs
#  define CMS_get1_certs OPENSSL_MANGLER(CMS_get1_certs)
# endif
#else
# ifndef _CMS_get1_certs
#  define _CMS_get1_certs OPENSSL_MANGLER_ASM(CMS_get1_certs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_get1_crls
#  define CMS_get1_crls OPENSSL_MANGLER(CMS_get1_crls)
# endif
#else
# ifndef _CMS_get1_crls
#  define _CMS_get1_crls OPENSSL_MANGLER_ASM(CMS_get1_crls)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_get1_ReceiptRequest
#  define CMS_get1_ReceiptRequest OPENSSL_MANGLER(CMS_get1_ReceiptRequest)
# endif
#else
# ifndef _CMS_get1_ReceiptRequest
#  define _CMS_get1_ReceiptRequest OPENSSL_MANGLER_ASM(CMS_get1_ReceiptRequest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_ias_cert_cmp
#  define cms_ias_cert_cmp OPENSSL_MANGLER(cms_ias_cert_cmp)
# endif
#else
# ifndef _cms_ias_cert_cmp
#  define _cms_ias_cert_cmp OPENSSL_MANGLER_ASM(cms_ias_cert_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_is_detached
#  define CMS_is_detached OPENSSL_MANGLER(CMS_is_detached)
# endif
#else
# ifndef _CMS_is_detached
#  define _CMS_is_detached OPENSSL_MANGLER_ASM(CMS_is_detached)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_IssuerAndSerialNumber_it
#  define CMS_IssuerAndSerialNumber_it OPENSSL_MANGLER(CMS_IssuerAndSerialNumber_it)
# endif
#else
# ifndef _CMS_IssuerAndSerialNumber_it
#  define _CMS_IssuerAndSerialNumber_it OPENSSL_MANGLER_ASM(CMS_IssuerAndSerialNumber_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_KEKRecipientInfo_it
#  define CMS_KEKRecipientInfo_it OPENSSL_MANGLER(CMS_KEKRecipientInfo_it)
# endif
#else
# ifndef _CMS_KEKRecipientInfo_it
#  define _CMS_KEKRecipientInfo_it OPENSSL_MANGLER_ASM(CMS_KEKRecipientInfo_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_KeyAgreeRecipientInfo_it
#  define CMS_KeyAgreeRecipientInfo_it OPENSSL_MANGLER(CMS_KeyAgreeRecipientInfo_it)
# endif
#else
# ifndef _CMS_KeyAgreeRecipientInfo_it
#  define _CMS_KeyAgreeRecipientInfo_it OPENSSL_MANGLER_ASM(CMS_KeyAgreeRecipientInfo_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_keyid_cert_cmp
#  define cms_keyid_cert_cmp OPENSSL_MANGLER(cms_keyid_cert_cmp)
# endif
#else
# ifndef _cms_keyid_cert_cmp
#  define _cms_keyid_cert_cmp OPENSSL_MANGLER_ASM(cms_keyid_cert_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_KeyTransRecipientInfo_it
#  define CMS_KeyTransRecipientInfo_it OPENSSL_MANGLER(CMS_KeyTransRecipientInfo_it)
# endif
#else
# ifndef _CMS_KeyTransRecipientInfo_it
#  define _CMS_KeyTransRecipientInfo_it OPENSSL_MANGLER_ASM(CMS_KeyTransRecipientInfo_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_msgSigDigest_add1
#  define cms_msgSigDigest_add1 OPENSSL_MANGLER(cms_msgSigDigest_add1)
# endif
#else
# ifndef _cms_msgSigDigest_add1
#  define _cms_msgSigDigest_add1 OPENSSL_MANGLER_ASM(cms_msgSigDigest_add1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_OriginatorPublicKey_it
#  define CMS_OriginatorPublicKey_it OPENSSL_MANGLER(CMS_OriginatorPublicKey_it)
# endif
#else
# ifndef _CMS_OriginatorPublicKey_it
#  define _CMS_OriginatorPublicKey_it OPENSSL_MANGLER_ASM(CMS_OriginatorPublicKey_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_OtherKeyAttribute_it
#  define CMS_OtherKeyAttribute_it OPENSSL_MANGLER(CMS_OtherKeyAttribute_it)
# endif
#else
# ifndef _CMS_OtherKeyAttribute_it
#  define _CMS_OtherKeyAttribute_it OPENSSL_MANGLER_ASM(CMS_OtherKeyAttribute_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_PasswordRecipientInfo_it
#  define CMS_PasswordRecipientInfo_it OPENSSL_MANGLER(CMS_PasswordRecipientInfo_it)
# endif
#else
# ifndef _CMS_PasswordRecipientInfo_it
#  define _CMS_PasswordRecipientInfo_it OPENSSL_MANGLER_ASM(CMS_PasswordRecipientInfo_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_pkey_get_ri_type
#  define cms_pkey_get_ri_type OPENSSL_MANGLER(cms_pkey_get_ri_type)
# endif
#else
# ifndef _cms_pkey_get_ri_type
#  define _cms_pkey_get_ri_type OPENSSL_MANGLER_ASM(cms_pkey_get_ri_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_Receipt_it
#  define CMS_Receipt_it OPENSSL_MANGLER(CMS_Receipt_it)
# endif
#else
# ifndef _CMS_Receipt_it
#  define _CMS_Receipt_it OPENSSL_MANGLER_ASM(CMS_Receipt_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_ReceiptRequest_create0
#  define CMS_ReceiptRequest_create0 OPENSSL_MANGLER(CMS_ReceiptRequest_create0)
# endif
#else
# ifndef _CMS_ReceiptRequest_create0
#  define _CMS_ReceiptRequest_create0 OPENSSL_MANGLER_ASM(CMS_ReceiptRequest_create0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_ReceiptRequest_free
#  define CMS_ReceiptRequest_free OPENSSL_MANGLER(CMS_ReceiptRequest_free)
# endif
#else
# ifndef _CMS_ReceiptRequest_free
#  define _CMS_ReceiptRequest_free OPENSSL_MANGLER_ASM(CMS_ReceiptRequest_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_ReceiptRequest_get0_values
#  define CMS_ReceiptRequest_get0_values OPENSSL_MANGLER(CMS_ReceiptRequest_get0_values)
# endif
#else
# ifndef _CMS_ReceiptRequest_get0_values
#  define _CMS_ReceiptRequest_get0_values OPENSSL_MANGLER_ASM(CMS_ReceiptRequest_get0_values)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_ReceiptRequest_it
#  define CMS_ReceiptRequest_it OPENSSL_MANGLER(CMS_ReceiptRequest_it)
# endif
#else
# ifndef _CMS_ReceiptRequest_it
#  define _CMS_ReceiptRequest_it OPENSSL_MANGLER_ASM(CMS_ReceiptRequest_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_ReceiptRequest_new
#  define CMS_ReceiptRequest_new OPENSSL_MANGLER(CMS_ReceiptRequest_new)
# endif
#else
# ifndef _CMS_ReceiptRequest_new
#  define _CMS_ReceiptRequest_new OPENSSL_MANGLER_ASM(CMS_ReceiptRequest_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_Receipt_verify
#  define cms_Receipt_verify OPENSSL_MANGLER(cms_Receipt_verify)
# endif
#else
# ifndef _cms_Receipt_verify
#  define _cms_Receipt_verify OPENSSL_MANGLER_ASM(cms_Receipt_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientEncryptedKey_cert_cmp
#  define CMS_RecipientEncryptedKey_cert_cmp OPENSSL_MANGLER(CMS_RecipientEncryptedKey_cert_cmp)
# endif
#else
# ifndef _CMS_RecipientEncryptedKey_cert_cmp
#  define _CMS_RecipientEncryptedKey_cert_cmp OPENSSL_MANGLER_ASM(CMS_RecipientEncryptedKey_cert_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientEncryptedKey_get0_id
#  define CMS_RecipientEncryptedKey_get0_id OPENSSL_MANGLER(CMS_RecipientEncryptedKey_get0_id)
# endif
#else
# ifndef _CMS_RecipientEncryptedKey_get0_id
#  define _CMS_RecipientEncryptedKey_get0_id OPENSSL_MANGLER_ASM(CMS_RecipientEncryptedKey_get0_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientEncryptedKey_it
#  define CMS_RecipientEncryptedKey_it OPENSSL_MANGLER(CMS_RecipientEncryptedKey_it)
# endif
#else
# ifndef _CMS_RecipientEncryptedKey_it
#  define _CMS_RecipientEncryptedKey_it OPENSSL_MANGLER_ASM(CMS_RecipientEncryptedKey_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_decrypt
#  define CMS_RecipientInfo_decrypt OPENSSL_MANGLER(CMS_RecipientInfo_decrypt)
# endif
#else
# ifndef _CMS_RecipientInfo_decrypt
#  define _CMS_RecipientInfo_decrypt OPENSSL_MANGLER_ASM(CMS_RecipientInfo_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_encrypt
#  define CMS_RecipientInfo_encrypt OPENSSL_MANGLER(CMS_RecipientInfo_encrypt)
# endif
#else
# ifndef _CMS_RecipientInfo_encrypt
#  define _CMS_RecipientInfo_encrypt OPENSSL_MANGLER_ASM(CMS_RecipientInfo_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_get0_pkey_ctx
#  define CMS_RecipientInfo_get0_pkey_ctx OPENSSL_MANGLER(CMS_RecipientInfo_get0_pkey_ctx)
# endif
#else
# ifndef _CMS_RecipientInfo_get0_pkey_ctx
#  define _CMS_RecipientInfo_get0_pkey_ctx OPENSSL_MANGLER_ASM(CMS_RecipientInfo_get0_pkey_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_it
#  define CMS_RecipientInfo_it OPENSSL_MANGLER(CMS_RecipientInfo_it)
# endif
#else
# ifndef _CMS_RecipientInfo_it
#  define _CMS_RecipientInfo_it OPENSSL_MANGLER_ASM(CMS_RecipientInfo_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_kari_decrypt
#  define CMS_RecipientInfo_kari_decrypt OPENSSL_MANGLER(CMS_RecipientInfo_kari_decrypt)
# endif
#else
# ifndef _CMS_RecipientInfo_kari_decrypt
#  define _CMS_RecipientInfo_kari_decrypt OPENSSL_MANGLER_ASM(CMS_RecipientInfo_kari_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_RecipientInfo_kari_encrypt
#  define cms_RecipientInfo_kari_encrypt OPENSSL_MANGLER(cms_RecipientInfo_kari_encrypt)
# endif
#else
# ifndef _cms_RecipientInfo_kari_encrypt
#  define _cms_RecipientInfo_kari_encrypt OPENSSL_MANGLER_ASM(cms_RecipientInfo_kari_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_kari_get0_alg
#  define CMS_RecipientInfo_kari_get0_alg OPENSSL_MANGLER(CMS_RecipientInfo_kari_get0_alg)
# endif
#else
# ifndef _CMS_RecipientInfo_kari_get0_alg
#  define _CMS_RecipientInfo_kari_get0_alg OPENSSL_MANGLER_ASM(CMS_RecipientInfo_kari_get0_alg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_kari_get0_ctx
#  define CMS_RecipientInfo_kari_get0_ctx OPENSSL_MANGLER(CMS_RecipientInfo_kari_get0_ctx)
# endif
#else
# ifndef _CMS_RecipientInfo_kari_get0_ctx
#  define _CMS_RecipientInfo_kari_get0_ctx OPENSSL_MANGLER_ASM(CMS_RecipientInfo_kari_get0_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_kari_get0_orig_id
#  define CMS_RecipientInfo_kari_get0_orig_id OPENSSL_MANGLER(CMS_RecipientInfo_kari_get0_orig_id)
# endif
#else
# ifndef _CMS_RecipientInfo_kari_get0_orig_id
#  define _CMS_RecipientInfo_kari_get0_orig_id OPENSSL_MANGLER_ASM(CMS_RecipientInfo_kari_get0_orig_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_kari_get0_reks
#  define CMS_RecipientInfo_kari_get0_reks OPENSSL_MANGLER(CMS_RecipientInfo_kari_get0_reks)
# endif
#else
# ifndef _CMS_RecipientInfo_kari_get0_reks
#  define _CMS_RecipientInfo_kari_get0_reks OPENSSL_MANGLER_ASM(CMS_RecipientInfo_kari_get0_reks)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_RecipientInfo_kari_init
#  define cms_RecipientInfo_kari_init OPENSSL_MANGLER(cms_RecipientInfo_kari_init)
# endif
#else
# ifndef _cms_RecipientInfo_kari_init
#  define _cms_RecipientInfo_kari_init OPENSSL_MANGLER_ASM(cms_RecipientInfo_kari_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_kari_orig_id_cmp
#  define CMS_RecipientInfo_kari_orig_id_cmp OPENSSL_MANGLER(CMS_RecipientInfo_kari_orig_id_cmp)
# endif
#else
# ifndef _CMS_RecipientInfo_kari_orig_id_cmp
#  define _CMS_RecipientInfo_kari_orig_id_cmp OPENSSL_MANGLER_ASM(CMS_RecipientInfo_kari_orig_id_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_kari_set0_pkey
#  define CMS_RecipientInfo_kari_set0_pkey OPENSSL_MANGLER(CMS_RecipientInfo_kari_set0_pkey)
# endif
#else
# ifndef _CMS_RecipientInfo_kari_set0_pkey
#  define _CMS_RecipientInfo_kari_set0_pkey OPENSSL_MANGLER_ASM(CMS_RecipientInfo_kari_set0_pkey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_kekri_get0_id
#  define CMS_RecipientInfo_kekri_get0_id OPENSSL_MANGLER(CMS_RecipientInfo_kekri_get0_id)
# endif
#else
# ifndef _CMS_RecipientInfo_kekri_get0_id
#  define _CMS_RecipientInfo_kekri_get0_id OPENSSL_MANGLER_ASM(CMS_RecipientInfo_kekri_get0_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_kekri_id_cmp
#  define CMS_RecipientInfo_kekri_id_cmp OPENSSL_MANGLER(CMS_RecipientInfo_kekri_id_cmp)
# endif
#else
# ifndef _CMS_RecipientInfo_kekri_id_cmp
#  define _CMS_RecipientInfo_kekri_id_cmp OPENSSL_MANGLER_ASM(CMS_RecipientInfo_kekri_id_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_ktri_cert_cmp
#  define CMS_RecipientInfo_ktri_cert_cmp OPENSSL_MANGLER(CMS_RecipientInfo_ktri_cert_cmp)
# endif
#else
# ifndef _CMS_RecipientInfo_ktri_cert_cmp
#  define _CMS_RecipientInfo_ktri_cert_cmp OPENSSL_MANGLER_ASM(CMS_RecipientInfo_ktri_cert_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_ktri_get0_algs
#  define CMS_RecipientInfo_ktri_get0_algs OPENSSL_MANGLER(CMS_RecipientInfo_ktri_get0_algs)
# endif
#else
# ifndef _CMS_RecipientInfo_ktri_get0_algs
#  define _CMS_RecipientInfo_ktri_get0_algs OPENSSL_MANGLER_ASM(CMS_RecipientInfo_ktri_get0_algs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_ktri_get0_signer_id
#  define CMS_RecipientInfo_ktri_get0_signer_id OPENSSL_MANGLER(CMS_RecipientInfo_ktri_get0_signer_id)
# endif
#else
# ifndef _CMS_RecipientInfo_ktri_get0_signer_id
#  define _CMS_RecipientInfo_ktri_get0_signer_id OPENSSL_MANGLER_ASM(CMS_RecipientInfo_ktri_get0_signer_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_RecipientInfo_pwri_crypt
#  define cms_RecipientInfo_pwri_crypt OPENSSL_MANGLER(cms_RecipientInfo_pwri_crypt)
# endif
#else
# ifndef _cms_RecipientInfo_pwri_crypt
#  define _cms_RecipientInfo_pwri_crypt OPENSSL_MANGLER_ASM(cms_RecipientInfo_pwri_crypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_set0_key
#  define CMS_RecipientInfo_set0_key OPENSSL_MANGLER(CMS_RecipientInfo_set0_key)
# endif
#else
# ifndef _CMS_RecipientInfo_set0_key
#  define _CMS_RecipientInfo_set0_key OPENSSL_MANGLER_ASM(CMS_RecipientInfo_set0_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_set0_password
#  define CMS_RecipientInfo_set0_password OPENSSL_MANGLER(CMS_RecipientInfo_set0_password)
# endif
#else
# ifndef _CMS_RecipientInfo_set0_password
#  define _CMS_RecipientInfo_set0_password OPENSSL_MANGLER_ASM(CMS_RecipientInfo_set0_password)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_set0_pkey
#  define CMS_RecipientInfo_set0_pkey OPENSSL_MANGLER(CMS_RecipientInfo_set0_pkey)
# endif
#else
# ifndef _CMS_RecipientInfo_set0_pkey
#  define _CMS_RecipientInfo_set0_pkey OPENSSL_MANGLER_ASM(CMS_RecipientInfo_set0_pkey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientInfo_type
#  define CMS_RecipientInfo_type OPENSSL_MANGLER(CMS_RecipientInfo_type)
# endif
#else
# ifndef _CMS_RecipientInfo_type
#  define _CMS_RecipientInfo_type OPENSSL_MANGLER_ASM(CMS_RecipientInfo_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RecipientKeyIdentifier_it
#  define CMS_RecipientKeyIdentifier_it OPENSSL_MANGLER(CMS_RecipientKeyIdentifier_it)
# endif
#else
# ifndef _CMS_RecipientKeyIdentifier_it
#  define _CMS_RecipientKeyIdentifier_it OPENSSL_MANGLER_ASM(CMS_RecipientKeyIdentifier_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_RevocationInfoChoice_it
#  define CMS_RevocationInfoChoice_it OPENSSL_MANGLER(CMS_RevocationInfoChoice_it)
# endif
#else
# ifndef _CMS_RevocationInfoChoice_it
#  define _CMS_RevocationInfoChoice_it OPENSSL_MANGLER_ASM(CMS_RevocationInfoChoice_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_set1_eContentType
#  define CMS_set1_eContentType OPENSSL_MANGLER(CMS_set1_eContentType)
# endif
#else
# ifndef _CMS_set1_eContentType
#  define _CMS_set1_eContentType OPENSSL_MANGLER_ASM(CMS_set1_eContentType)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_set1_ias
#  define cms_set1_ias OPENSSL_MANGLER(cms_set1_ias)
# endif
#else
# ifndef _cms_set1_ias
#  define _cms_set1_ias OPENSSL_MANGLER_ASM(cms_set1_ias)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_set1_keyid
#  define cms_set1_keyid OPENSSL_MANGLER(cms_set1_keyid)
# endif
#else
# ifndef _cms_set1_keyid
#  define _cms_set1_keyid OPENSSL_MANGLER_ASM(cms_set1_keyid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_set1_SignerIdentifier
#  define cms_set1_SignerIdentifier OPENSSL_MANGLER(cms_set1_SignerIdentifier)
# endif
#else
# ifndef _cms_set1_SignerIdentifier
#  define _cms_set1_SignerIdentifier OPENSSL_MANGLER_ASM(cms_set1_SignerIdentifier)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_set1_signers_certs
#  define CMS_set1_signers_certs OPENSSL_MANGLER(CMS_set1_signers_certs)
# endif
#else
# ifndef _CMS_set1_signers_certs
#  define _CMS_set1_signers_certs OPENSSL_MANGLER_ASM(CMS_set1_signers_certs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_set_detached
#  define CMS_set_detached OPENSSL_MANGLER(CMS_set_detached)
# endif
#else
# ifndef _CMS_set_detached
#  define _CMS_set_detached OPENSSL_MANGLER_ASM(CMS_set_detached)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SharedInfo_encode
#  define CMS_SharedInfo_encode OPENSSL_MANGLER(CMS_SharedInfo_encode)
# endif
#else
# ifndef _CMS_SharedInfo_encode
#  define _CMS_SharedInfo_encode OPENSSL_MANGLER_ASM(CMS_SharedInfo_encode)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_sign
#  define CMS_sign OPENSSL_MANGLER(CMS_sign)
# endif
#else
# ifndef _CMS_sign
#  define _CMS_sign OPENSSL_MANGLER_ASM(CMS_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_signed_add1_attr
#  define CMS_signed_add1_attr OPENSSL_MANGLER(CMS_signed_add1_attr)
# endif
#else
# ifndef _CMS_signed_add1_attr
#  define _CMS_signed_add1_attr OPENSSL_MANGLER_ASM(CMS_signed_add1_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_signed_add1_attr_by_NID
#  define CMS_signed_add1_attr_by_NID OPENSSL_MANGLER(CMS_signed_add1_attr_by_NID)
# endif
#else
# ifndef _CMS_signed_add1_attr_by_NID
#  define _CMS_signed_add1_attr_by_NID OPENSSL_MANGLER_ASM(CMS_signed_add1_attr_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_signed_add1_attr_by_OBJ
#  define CMS_signed_add1_attr_by_OBJ OPENSSL_MANGLER(CMS_signed_add1_attr_by_OBJ)
# endif
#else
# ifndef _CMS_signed_add1_attr_by_OBJ
#  define _CMS_signed_add1_attr_by_OBJ OPENSSL_MANGLER_ASM(CMS_signed_add1_attr_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_signed_add1_attr_by_txt
#  define CMS_signed_add1_attr_by_txt OPENSSL_MANGLER(CMS_signed_add1_attr_by_txt)
# endif
#else
# ifndef _CMS_signed_add1_attr_by_txt
#  define _CMS_signed_add1_attr_by_txt OPENSSL_MANGLER_ASM(CMS_signed_add1_attr_by_txt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_SignedData_final
#  define cms_SignedData_final OPENSSL_MANGLER(cms_SignedData_final)
# endif
#else
# ifndef _cms_SignedData_final
#  define _cms_SignedData_final OPENSSL_MANGLER_ASM(cms_SignedData_final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignedData_init
#  define CMS_SignedData_init OPENSSL_MANGLER(CMS_SignedData_init)
# endif
#else
# ifndef _CMS_SignedData_init
#  define _CMS_SignedData_init OPENSSL_MANGLER_ASM(CMS_SignedData_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_SignedData_init_bio
#  define cms_SignedData_init_bio OPENSSL_MANGLER(cms_SignedData_init_bio)
# endif
#else
# ifndef _cms_SignedData_init_bio
#  define _cms_SignedData_init_bio OPENSSL_MANGLER_ASM(cms_SignedData_init_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignedData_it
#  define CMS_SignedData_it OPENSSL_MANGLER(CMS_SignedData_it)
# endif
#else
# ifndef _CMS_SignedData_it
#  define _CMS_SignedData_it OPENSSL_MANGLER_ASM(CMS_SignedData_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_signed_delete_attr
#  define CMS_signed_delete_attr OPENSSL_MANGLER(CMS_signed_delete_attr)
# endif
#else
# ifndef _CMS_signed_delete_attr
#  define _CMS_signed_delete_attr OPENSSL_MANGLER_ASM(CMS_signed_delete_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_signed_get0_data_by_OBJ
#  define CMS_signed_get0_data_by_OBJ OPENSSL_MANGLER(CMS_signed_get0_data_by_OBJ)
# endif
#else
# ifndef _CMS_signed_get0_data_by_OBJ
#  define _CMS_signed_get0_data_by_OBJ OPENSSL_MANGLER_ASM(CMS_signed_get0_data_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_signed_get_attr
#  define CMS_signed_get_attr OPENSSL_MANGLER(CMS_signed_get_attr)
# endif
#else
# ifndef _CMS_signed_get_attr
#  define _CMS_signed_get_attr OPENSSL_MANGLER_ASM(CMS_signed_get_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_signed_get_attr_by_NID
#  define CMS_signed_get_attr_by_NID OPENSSL_MANGLER(CMS_signed_get_attr_by_NID)
# endif
#else
# ifndef _CMS_signed_get_attr_by_NID
#  define _CMS_signed_get_attr_by_NID OPENSSL_MANGLER_ASM(CMS_signed_get_attr_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_signed_get_attr_by_OBJ
#  define CMS_signed_get_attr_by_OBJ OPENSSL_MANGLER(CMS_signed_get_attr_by_OBJ)
# endif
#else
# ifndef _CMS_signed_get_attr_by_OBJ
#  define _CMS_signed_get_attr_by_OBJ OPENSSL_MANGLER_ASM(CMS_signed_get_attr_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_signed_get_attr_count
#  define CMS_signed_get_attr_count OPENSSL_MANGLER(CMS_signed_get_attr_count)
# endif
#else
# ifndef _CMS_signed_get_attr_count
#  define _CMS_signed_get_attr_count OPENSSL_MANGLER_ASM(CMS_signed_get_attr_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_SignerIdentifier_cert_cmp
#  define cms_SignerIdentifier_cert_cmp OPENSSL_MANGLER(cms_SignerIdentifier_cert_cmp)
# endif
#else
# ifndef _cms_SignerIdentifier_cert_cmp
#  define _cms_SignerIdentifier_cert_cmp OPENSSL_MANGLER_ASM(cms_SignerIdentifier_cert_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef cms_SignerIdentifier_get0_signer_id
#  define cms_SignerIdentifier_get0_signer_id OPENSSL_MANGLER(cms_SignerIdentifier_get0_signer_id)
# endif
#else
# ifndef _cms_SignerIdentifier_get0_signer_id
#  define _cms_SignerIdentifier_get0_signer_id OPENSSL_MANGLER_ASM(cms_SignerIdentifier_get0_signer_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_cert_cmp
#  define CMS_SignerInfo_cert_cmp OPENSSL_MANGLER(CMS_SignerInfo_cert_cmp)
# endif
#else
# ifndef _CMS_SignerInfo_cert_cmp
#  define _CMS_SignerInfo_cert_cmp OPENSSL_MANGLER_ASM(CMS_SignerInfo_cert_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_get0_algs
#  define CMS_SignerInfo_get0_algs OPENSSL_MANGLER(CMS_SignerInfo_get0_algs)
# endif
#else
# ifndef _CMS_SignerInfo_get0_algs
#  define _CMS_SignerInfo_get0_algs OPENSSL_MANGLER_ASM(CMS_SignerInfo_get0_algs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_get0_md_ctx
#  define CMS_SignerInfo_get0_md_ctx OPENSSL_MANGLER(CMS_SignerInfo_get0_md_ctx)
# endif
#else
# ifndef _CMS_SignerInfo_get0_md_ctx
#  define _CMS_SignerInfo_get0_md_ctx OPENSSL_MANGLER_ASM(CMS_SignerInfo_get0_md_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_get0_pkey_ctx
#  define CMS_SignerInfo_get0_pkey_ctx OPENSSL_MANGLER(CMS_SignerInfo_get0_pkey_ctx)
# endif
#else
# ifndef _CMS_SignerInfo_get0_pkey_ctx
#  define _CMS_SignerInfo_get0_pkey_ctx OPENSSL_MANGLER_ASM(CMS_SignerInfo_get0_pkey_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_get0_signature
#  define CMS_SignerInfo_get0_signature OPENSSL_MANGLER(CMS_SignerInfo_get0_signature)
# endif
#else
# ifndef _CMS_SignerInfo_get0_signature
#  define _CMS_SignerInfo_get0_signature OPENSSL_MANGLER_ASM(CMS_SignerInfo_get0_signature)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_get0_signer_id
#  define CMS_SignerInfo_get0_signer_id OPENSSL_MANGLER(CMS_SignerInfo_get0_signer_id)
# endif
#else
# ifndef _CMS_SignerInfo_get0_signer_id
#  define _CMS_SignerInfo_get0_signer_id OPENSSL_MANGLER_ASM(CMS_SignerInfo_get0_signer_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_it
#  define CMS_SignerInfo_it OPENSSL_MANGLER(CMS_SignerInfo_it)
# endif
#else
# ifndef _CMS_SignerInfo_it
#  define _CMS_SignerInfo_it OPENSSL_MANGLER_ASM(CMS_SignerInfo_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_set1_signer_cert
#  define CMS_SignerInfo_set1_signer_cert OPENSSL_MANGLER(CMS_SignerInfo_set1_signer_cert)
# endif
#else
# ifndef _CMS_SignerInfo_set1_signer_cert
#  define _CMS_SignerInfo_set1_signer_cert OPENSSL_MANGLER_ASM(CMS_SignerInfo_set1_signer_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_sign
#  define CMS_SignerInfo_sign OPENSSL_MANGLER(CMS_SignerInfo_sign)
# endif
#else
# ifndef _CMS_SignerInfo_sign
#  define _CMS_SignerInfo_sign OPENSSL_MANGLER_ASM(CMS_SignerInfo_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_verify
#  define CMS_SignerInfo_verify OPENSSL_MANGLER(CMS_SignerInfo_verify)
# endif
#else
# ifndef _CMS_SignerInfo_verify
#  define _CMS_SignerInfo_verify OPENSSL_MANGLER_ASM(CMS_SignerInfo_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_SignerInfo_verify_content
#  define CMS_SignerInfo_verify_content OPENSSL_MANGLER(CMS_SignerInfo_verify_content)
# endif
#else
# ifndef _CMS_SignerInfo_verify_content
#  define _CMS_SignerInfo_verify_content OPENSSL_MANGLER_ASM(CMS_SignerInfo_verify_content)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_sign_receipt
#  define CMS_sign_receipt OPENSSL_MANGLER(CMS_sign_receipt)
# endif
#else
# ifndef _CMS_sign_receipt
#  define _CMS_sign_receipt OPENSSL_MANGLER_ASM(CMS_sign_receipt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_stream
#  define CMS_stream OPENSSL_MANGLER(CMS_stream)
# endif
#else
# ifndef _CMS_stream
#  define _CMS_stream OPENSSL_MANGLER_ASM(CMS_stream)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_uncompress
#  define CMS_uncompress OPENSSL_MANGLER(CMS_uncompress)
# endif
#else
# ifndef _CMS_uncompress
#  define _CMS_uncompress OPENSSL_MANGLER_ASM(CMS_uncompress)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_unsigned_add1_attr
#  define CMS_unsigned_add1_attr OPENSSL_MANGLER(CMS_unsigned_add1_attr)
# endif
#else
# ifndef _CMS_unsigned_add1_attr
#  define _CMS_unsigned_add1_attr OPENSSL_MANGLER_ASM(CMS_unsigned_add1_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_unsigned_add1_attr_by_NID
#  define CMS_unsigned_add1_attr_by_NID OPENSSL_MANGLER(CMS_unsigned_add1_attr_by_NID)
# endif
#else
# ifndef _CMS_unsigned_add1_attr_by_NID
#  define _CMS_unsigned_add1_attr_by_NID OPENSSL_MANGLER_ASM(CMS_unsigned_add1_attr_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_unsigned_add1_attr_by_OBJ
#  define CMS_unsigned_add1_attr_by_OBJ OPENSSL_MANGLER(CMS_unsigned_add1_attr_by_OBJ)
# endif
#else
# ifndef _CMS_unsigned_add1_attr_by_OBJ
#  define _CMS_unsigned_add1_attr_by_OBJ OPENSSL_MANGLER_ASM(CMS_unsigned_add1_attr_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_unsigned_add1_attr_by_txt
#  define CMS_unsigned_add1_attr_by_txt OPENSSL_MANGLER(CMS_unsigned_add1_attr_by_txt)
# endif
#else
# ifndef _CMS_unsigned_add1_attr_by_txt
#  define _CMS_unsigned_add1_attr_by_txt OPENSSL_MANGLER_ASM(CMS_unsigned_add1_attr_by_txt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_unsigned_delete_attr
#  define CMS_unsigned_delete_attr OPENSSL_MANGLER(CMS_unsigned_delete_attr)
# endif
#else
# ifndef _CMS_unsigned_delete_attr
#  define _CMS_unsigned_delete_attr OPENSSL_MANGLER_ASM(CMS_unsigned_delete_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_unsigned_get0_data_by_OBJ
#  define CMS_unsigned_get0_data_by_OBJ OPENSSL_MANGLER(CMS_unsigned_get0_data_by_OBJ)
# endif
#else
# ifndef _CMS_unsigned_get0_data_by_OBJ
#  define _CMS_unsigned_get0_data_by_OBJ OPENSSL_MANGLER_ASM(CMS_unsigned_get0_data_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_unsigned_get_attr
#  define CMS_unsigned_get_attr OPENSSL_MANGLER(CMS_unsigned_get_attr)
# endif
#else
# ifndef _CMS_unsigned_get_attr
#  define _CMS_unsigned_get_attr OPENSSL_MANGLER_ASM(CMS_unsigned_get_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_unsigned_get_attr_by_NID
#  define CMS_unsigned_get_attr_by_NID OPENSSL_MANGLER(CMS_unsigned_get_attr_by_NID)
# endif
#else
# ifndef _CMS_unsigned_get_attr_by_NID
#  define _CMS_unsigned_get_attr_by_NID OPENSSL_MANGLER_ASM(CMS_unsigned_get_attr_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_unsigned_get_attr_by_OBJ
#  define CMS_unsigned_get_attr_by_OBJ OPENSSL_MANGLER(CMS_unsigned_get_attr_by_OBJ)
# endif
#else
# ifndef _CMS_unsigned_get_attr_by_OBJ
#  define _CMS_unsigned_get_attr_by_OBJ OPENSSL_MANGLER_ASM(CMS_unsigned_get_attr_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_unsigned_get_attr_count
#  define CMS_unsigned_get_attr_count OPENSSL_MANGLER(CMS_unsigned_get_attr_count)
# endif
#else
# ifndef _CMS_unsigned_get_attr_count
#  define _CMS_unsigned_get_attr_count OPENSSL_MANGLER_ASM(CMS_unsigned_get_attr_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_verify
#  define CMS_verify OPENSSL_MANGLER(CMS_verify)
# endif
#else
# ifndef _CMS_verify
#  define _CMS_verify OPENSSL_MANGLER_ASM(CMS_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CMS_verify_receipt
#  define CMS_verify_receipt OPENSSL_MANGLER(CMS_verify_receipt)
# endif
#else
# ifndef _CMS_verify_receipt
#  define _CMS_verify_receipt OPENSSL_MANGLER_ASM(CMS_verify_receipt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef conf_add_ssl_module
#  define conf_add_ssl_module OPENSSL_MANGLER(conf_add_ssl_module)
# endif
#else
# ifndef _conf_add_ssl_module
#  define _conf_add_ssl_module OPENSSL_MANGLER_ASM(conf_add_ssl_module)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _CONF_add_string
#  define _CONF_add_string OPENSSL_MANGLER(_CONF_add_string)
# endif
#else
# ifndef __CONF_add_string
#  define __CONF_add_string OPENSSL_MANGLER_ASM(_CONF_add_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_dump_bio
#  define CONF_dump_bio OPENSSL_MANGLER(CONF_dump_bio)
# endif
#else
# ifndef _CONF_dump_bio
#  define _CONF_dump_bio OPENSSL_MANGLER_ASM(CONF_dump_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_dump_fp
#  define CONF_dump_fp OPENSSL_MANGLER(CONF_dump_fp)
# endif
#else
# ifndef _CONF_dump_fp
#  define _CONF_dump_fp OPENSSL_MANGLER_ASM(CONF_dump_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_free
#  define CONF_free OPENSSL_MANGLER(CONF_free)
# endif
#else
# ifndef _CONF_free
#  define _CONF_free OPENSSL_MANGLER_ASM(CONF_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _CONF_free_data
#  define _CONF_free_data OPENSSL_MANGLER(_CONF_free_data)
# endif
#else
# ifndef __CONF_free_data
#  define __CONF_free_data OPENSSL_MANGLER_ASM(_CONF_free_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_get1_default_config_file
#  define CONF_get1_default_config_file OPENSSL_MANGLER(CONF_get1_default_config_file)
# endif
#else
# ifndef _CONF_get1_default_config_file
#  define _CONF_get1_default_config_file OPENSSL_MANGLER_ASM(CONF_get1_default_config_file)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_get_number
#  define CONF_get_number OPENSSL_MANGLER(CONF_get_number)
# endif
#else
# ifndef _CONF_get_number
#  define _CONF_get_number OPENSSL_MANGLER_ASM(CONF_get_number)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _CONF_get_section
#  define _CONF_get_section OPENSSL_MANGLER(_CONF_get_section)
# endif
#else
# ifndef __CONF_get_section
#  define __CONF_get_section OPENSSL_MANGLER_ASM(_CONF_get_section)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_get_section
#  define CONF_get_section OPENSSL_MANGLER(CONF_get_section)
# endif
#else
# ifndef _CONF_get_section
#  define _CONF_get_section OPENSSL_MANGLER_ASM(CONF_get_section)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _CONF_get_section_values
#  define _CONF_get_section_values OPENSSL_MANGLER(_CONF_get_section_values)
# endif
#else
# ifndef __CONF_get_section_values
#  define __CONF_get_section_values OPENSSL_MANGLER_ASM(_CONF_get_section_values)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _CONF_get_string
#  define _CONF_get_string OPENSSL_MANGLER(_CONF_get_string)
# endif
#else
# ifndef __CONF_get_string
#  define __CONF_get_string OPENSSL_MANGLER_ASM(_CONF_get_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_get_string
#  define CONF_get_string OPENSSL_MANGLER(CONF_get_string)
# endif
#else
# ifndef _CONF_get_string
#  define _CONF_get_string OPENSSL_MANGLER_ASM(CONF_get_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_imodule_get_flags
#  define CONF_imodule_get_flags OPENSSL_MANGLER(CONF_imodule_get_flags)
# endif
#else
# ifndef _CONF_imodule_get_flags
#  define _CONF_imodule_get_flags OPENSSL_MANGLER_ASM(CONF_imodule_get_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_imodule_get_module
#  define CONF_imodule_get_module OPENSSL_MANGLER(CONF_imodule_get_module)
# endif
#else
# ifndef _CONF_imodule_get_module
#  define _CONF_imodule_get_module OPENSSL_MANGLER_ASM(CONF_imodule_get_module)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_imodule_get_name
#  define CONF_imodule_get_name OPENSSL_MANGLER(CONF_imodule_get_name)
# endif
#else
# ifndef _CONF_imodule_get_name
#  define _CONF_imodule_get_name OPENSSL_MANGLER_ASM(CONF_imodule_get_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_imodule_get_usr_data
#  define CONF_imodule_get_usr_data OPENSSL_MANGLER(CONF_imodule_get_usr_data)
# endif
#else
# ifndef _CONF_imodule_get_usr_data
#  define _CONF_imodule_get_usr_data OPENSSL_MANGLER_ASM(CONF_imodule_get_usr_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_imodule_get_value
#  define CONF_imodule_get_value OPENSSL_MANGLER(CONF_imodule_get_value)
# endif
#else
# ifndef _CONF_imodule_get_value
#  define _CONF_imodule_get_value OPENSSL_MANGLER_ASM(CONF_imodule_get_value)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_imodule_set_flags
#  define CONF_imodule_set_flags OPENSSL_MANGLER(CONF_imodule_set_flags)
# endif
#else
# ifndef _CONF_imodule_set_flags
#  define _CONF_imodule_set_flags OPENSSL_MANGLER_ASM(CONF_imodule_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_imodule_set_usr_data
#  define CONF_imodule_set_usr_data OPENSSL_MANGLER(CONF_imodule_set_usr_data)
# endif
#else
# ifndef _CONF_imodule_set_usr_data
#  define _CONF_imodule_set_usr_data OPENSSL_MANGLER_ASM(CONF_imodule_set_usr_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_load
#  define CONF_load OPENSSL_MANGLER(CONF_load)
# endif
#else
# ifndef _CONF_load
#  define _CONF_load OPENSSL_MANGLER_ASM(CONF_load)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_load_bio
#  define CONF_load_bio OPENSSL_MANGLER(CONF_load_bio)
# endif
#else
# ifndef _CONF_load_bio
#  define _CONF_load_bio OPENSSL_MANGLER_ASM(CONF_load_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_load_fp
#  define CONF_load_fp OPENSSL_MANGLER(CONF_load_fp)
# endif
#else
# ifndef _CONF_load_fp
#  define _CONF_load_fp OPENSSL_MANGLER_ASM(CONF_load_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_module_add
#  define CONF_module_add OPENSSL_MANGLER(CONF_module_add)
# endif
#else
# ifndef _CONF_module_add
#  define _CONF_module_add OPENSSL_MANGLER_ASM(CONF_module_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_module_get_usr_data
#  define CONF_module_get_usr_data OPENSSL_MANGLER(CONF_module_get_usr_data)
# endif
#else
# ifndef _CONF_module_get_usr_data
#  define _CONF_module_get_usr_data OPENSSL_MANGLER_ASM(CONF_module_get_usr_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_module_set_usr_data
#  define CONF_module_set_usr_data OPENSSL_MANGLER(CONF_module_set_usr_data)
# endif
#else
# ifndef _CONF_module_set_usr_data
#  define _CONF_module_set_usr_data OPENSSL_MANGLER_ASM(CONF_module_set_usr_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_modules_finish
#  define CONF_modules_finish OPENSSL_MANGLER(CONF_modules_finish)
# endif
#else
# ifndef _CONF_modules_finish
#  define _CONF_modules_finish OPENSSL_MANGLER_ASM(CONF_modules_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef conf_modules_free_int
#  define conf_modules_free_int OPENSSL_MANGLER(conf_modules_free_int)
# endif
#else
# ifndef _conf_modules_free_int
#  define _conf_modules_free_int OPENSSL_MANGLER_ASM(conf_modules_free_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_modules_load
#  define CONF_modules_load OPENSSL_MANGLER(CONF_modules_load)
# endif
#else
# ifndef _CONF_modules_load
#  define _CONF_modules_load OPENSSL_MANGLER_ASM(CONF_modules_load)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_modules_load_file
#  define CONF_modules_load_file OPENSSL_MANGLER(CONF_modules_load_file)
# endif
#else
# ifndef _CONF_modules_load_file
#  define _CONF_modules_load_file OPENSSL_MANGLER_ASM(CONF_modules_load_file)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_modules_unload
#  define CONF_modules_unload OPENSSL_MANGLER(CONF_modules_unload)
# endif
#else
# ifndef _CONF_modules_unload
#  define _CONF_modules_unload OPENSSL_MANGLER_ASM(CONF_modules_unload)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _CONF_new_data
#  define _CONF_new_data OPENSSL_MANGLER(_CONF_new_data)
# endif
#else
# ifndef __CONF_new_data
#  define __CONF_new_data OPENSSL_MANGLER_ASM(_CONF_new_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef _CONF_new_section
#  define _CONF_new_section OPENSSL_MANGLER(_CONF_new_section)
# endif
#else
# ifndef __CONF_new_section
#  define __CONF_new_section OPENSSL_MANGLER_ASM(_CONF_new_section)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_parse_list
#  define CONF_parse_list OPENSSL_MANGLER(CONF_parse_list)
# endif
#else
# ifndef _CONF_parse_list
#  define _CONF_parse_list OPENSSL_MANGLER_ASM(CONF_parse_list)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_set_default_method
#  define CONF_set_default_method OPENSSL_MANGLER(CONF_set_default_method)
# endif
#else
# ifndef _CONF_set_default_method
#  define _CONF_set_default_method OPENSSL_MANGLER_ASM(CONF_set_default_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CONF_set_nconf
#  define CONF_set_nconf OPENSSL_MANGLER(CONF_set_nconf)
# endif
#else
# ifndef _CONF_set_nconf
#  define _CONF_set_nconf OPENSSL_MANGLER_ASM(CONF_set_nconf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef conf_ssl_get
#  define conf_ssl_get OPENSSL_MANGLER(conf_ssl_get)
# endif
#else
# ifndef _conf_ssl_get
#  define _conf_ssl_get OPENSSL_MANGLER_ASM(conf_ssl_get)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef conf_ssl_get_cmd
#  define conf_ssl_get_cmd OPENSSL_MANGLER(conf_ssl_get_cmd)
# endif
#else
# ifndef _conf_ssl_get_cmd
#  define _conf_ssl_get_cmd OPENSSL_MANGLER_ASM(conf_ssl_get_cmd)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef conf_ssl_name_find
#  define conf_ssl_name_find OPENSSL_MANGLER(conf_ssl_name_find)
# endif
#else
# ifndef _conf_ssl_name_find
#  define _conf_ssl_name_find OPENSSL_MANGLER_ASM(conf_ssl_name_find)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef construct_ca_names
#  define construct_ca_names OPENSSL_MANGLER(construct_ca_names)
# endif
#else
# ifndef _construct_ca_names
#  define _construct_ca_names OPENSSL_MANGLER_ASM(construct_ca_names)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef construct_key_exchange_tbs
#  define construct_key_exchange_tbs OPENSSL_MANGLER(construct_key_exchange_tbs)
# endif
#else
# ifndef _construct_key_exchange_tbs
#  define _construct_key_exchange_tbs OPENSSL_MANGLER_ASM(construct_key_exchange_tbs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef create_synthetic_message_hash
#  define create_synthetic_message_hash OPENSSL_MANGLER(create_synthetic_message_hash)
# endif
#else
# ifndef _create_synthetic_message_hash
#  define _create_synthetic_message_hash OPENSSL_MANGLER_ASM(create_synthetic_message_hash)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRL_DIST_POINTS_free
#  define CRL_DIST_POINTS_free OPENSSL_MANGLER(CRL_DIST_POINTS_free)
# endif
#else
# ifndef _CRL_DIST_POINTS_free
#  define _CRL_DIST_POINTS_free OPENSSL_MANGLER_ASM(CRL_DIST_POINTS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRL_DIST_POINTS_it
#  define CRL_DIST_POINTS_it OPENSSL_MANGLER(CRL_DIST_POINTS_it)
# endif
#else
# ifndef _CRL_DIST_POINTS_it
#  define _CRL_DIST_POINTS_it OPENSSL_MANGLER_ASM(CRL_DIST_POINTS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRL_DIST_POINTS_new
#  define CRL_DIST_POINTS_new OPENSSL_MANGLER(CRL_DIST_POINTS_new)
# endif
#else
# ifndef _CRL_DIST_POINTS_new
#  define _CRL_DIST_POINTS_new OPENSSL_MANGLER_ASM(CRL_DIST_POINTS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_128_unwrap
#  define CRYPTO_128_unwrap OPENSSL_MANGLER(CRYPTO_128_unwrap)
# endif
#else
# ifndef _CRYPTO_128_unwrap
#  define _CRYPTO_128_unwrap OPENSSL_MANGLER_ASM(CRYPTO_128_unwrap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_128_unwrap_pad
#  define CRYPTO_128_unwrap_pad OPENSSL_MANGLER(CRYPTO_128_unwrap_pad)
# endif
#else
# ifndef _CRYPTO_128_unwrap_pad
#  define _CRYPTO_128_unwrap_pad OPENSSL_MANGLER_ASM(CRYPTO_128_unwrap_pad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_128_wrap
#  define CRYPTO_128_wrap OPENSSL_MANGLER(CRYPTO_128_wrap)
# endif
#else
# ifndef _CRYPTO_128_wrap
#  define _CRYPTO_128_wrap OPENSSL_MANGLER_ASM(CRYPTO_128_wrap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_128_wrap_pad
#  define CRYPTO_128_wrap_pad OPENSSL_MANGLER(CRYPTO_128_wrap_pad)
# endif
#else
# ifndef _CRYPTO_128_wrap_pad
#  define _CRYPTO_128_wrap_pad OPENSSL_MANGLER_ASM(CRYPTO_128_wrap_pad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_atomic_add
#  define CRYPTO_atomic_add OPENSSL_MANGLER(CRYPTO_atomic_add)
# endif
#else
# ifndef _CRYPTO_atomic_add
#  define _CRYPTO_atomic_add OPENSSL_MANGLER_ASM(CRYPTO_atomic_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_cbc128_decrypt
#  define CRYPTO_cbc128_decrypt OPENSSL_MANGLER(CRYPTO_cbc128_decrypt)
# endif
#else
# ifndef _CRYPTO_cbc128_decrypt
#  define _CRYPTO_cbc128_decrypt OPENSSL_MANGLER_ASM(CRYPTO_cbc128_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_cbc128_encrypt
#  define CRYPTO_cbc128_encrypt OPENSSL_MANGLER(CRYPTO_cbc128_encrypt)
# endif
#else
# ifndef _CRYPTO_cbc128_encrypt
#  define _CRYPTO_cbc128_encrypt OPENSSL_MANGLER_ASM(CRYPTO_cbc128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ccm128_aad
#  define CRYPTO_ccm128_aad OPENSSL_MANGLER(CRYPTO_ccm128_aad)
# endif
#else
# ifndef _CRYPTO_ccm128_aad
#  define _CRYPTO_ccm128_aad OPENSSL_MANGLER_ASM(CRYPTO_ccm128_aad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ccm128_decrypt
#  define CRYPTO_ccm128_decrypt OPENSSL_MANGLER(CRYPTO_ccm128_decrypt)
# endif
#else
# ifndef _CRYPTO_ccm128_decrypt
#  define _CRYPTO_ccm128_decrypt OPENSSL_MANGLER_ASM(CRYPTO_ccm128_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ccm128_decrypt_ccm64
#  define CRYPTO_ccm128_decrypt_ccm64 OPENSSL_MANGLER(CRYPTO_ccm128_decrypt_ccm64)
# endif
#else
# ifndef _CRYPTO_ccm128_decrypt_ccm64
#  define _CRYPTO_ccm128_decrypt_ccm64 OPENSSL_MANGLER_ASM(CRYPTO_ccm128_decrypt_ccm64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ccm128_encrypt
#  define CRYPTO_ccm128_encrypt OPENSSL_MANGLER(CRYPTO_ccm128_encrypt)
# endif
#else
# ifndef _CRYPTO_ccm128_encrypt
#  define _CRYPTO_ccm128_encrypt OPENSSL_MANGLER_ASM(CRYPTO_ccm128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ccm128_encrypt_ccm64
#  define CRYPTO_ccm128_encrypt_ccm64 OPENSSL_MANGLER(CRYPTO_ccm128_encrypt_ccm64)
# endif
#else
# ifndef _CRYPTO_ccm128_encrypt_ccm64
#  define _CRYPTO_ccm128_encrypt_ccm64 OPENSSL_MANGLER_ASM(CRYPTO_ccm128_encrypt_ccm64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ccm128_init
#  define CRYPTO_ccm128_init OPENSSL_MANGLER(CRYPTO_ccm128_init)
# endif
#else
# ifndef _CRYPTO_ccm128_init
#  define _CRYPTO_ccm128_init OPENSSL_MANGLER_ASM(CRYPTO_ccm128_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ccm128_setiv
#  define CRYPTO_ccm128_setiv OPENSSL_MANGLER(CRYPTO_ccm128_setiv)
# endif
#else
# ifndef _CRYPTO_ccm128_setiv
#  define _CRYPTO_ccm128_setiv OPENSSL_MANGLER_ASM(CRYPTO_ccm128_setiv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ccm128_tag
#  define CRYPTO_ccm128_tag OPENSSL_MANGLER(CRYPTO_ccm128_tag)
# endif
#else
# ifndef _CRYPTO_ccm128_tag
#  define _CRYPTO_ccm128_tag OPENSSL_MANGLER_ASM(CRYPTO_ccm128_tag)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_cfb128_1_encrypt
#  define CRYPTO_cfb128_1_encrypt OPENSSL_MANGLER(CRYPTO_cfb128_1_encrypt)
# endif
#else
# ifndef _CRYPTO_cfb128_1_encrypt
#  define _CRYPTO_cfb128_1_encrypt OPENSSL_MANGLER_ASM(CRYPTO_cfb128_1_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_cfb128_8_encrypt
#  define CRYPTO_cfb128_8_encrypt OPENSSL_MANGLER(CRYPTO_cfb128_8_encrypt)
# endif
#else
# ifndef _CRYPTO_cfb128_8_encrypt
#  define _CRYPTO_cfb128_8_encrypt OPENSSL_MANGLER_ASM(CRYPTO_cfb128_8_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_cfb128_encrypt
#  define CRYPTO_cfb128_encrypt OPENSSL_MANGLER(CRYPTO_cfb128_encrypt)
# endif
#else
# ifndef _CRYPTO_cfb128_encrypt
#  define _CRYPTO_cfb128_encrypt OPENSSL_MANGLER_ASM(CRYPTO_cfb128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef crypto_cleanup_all_ex_data_int
#  define crypto_cleanup_all_ex_data_int OPENSSL_MANGLER(crypto_cleanup_all_ex_data_int)
# endif
#else
# ifndef _crypto_cleanup_all_ex_data_int
#  define _crypto_cleanup_all_ex_data_int OPENSSL_MANGLER_ASM(crypto_cleanup_all_ex_data_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_clear_free
#  define CRYPTO_clear_free OPENSSL_MANGLER(CRYPTO_clear_free)
# endif
#else
# ifndef _CRYPTO_clear_free
#  define _CRYPTO_clear_free OPENSSL_MANGLER_ASM(CRYPTO_clear_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_clear_realloc
#  define CRYPTO_clear_realloc OPENSSL_MANGLER(CRYPTO_clear_realloc)
# endif
#else
# ifndef _CRYPTO_clear_realloc
#  define _CRYPTO_clear_realloc OPENSSL_MANGLER_ASM(CRYPTO_clear_realloc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ctr128_encrypt
#  define CRYPTO_ctr128_encrypt OPENSSL_MANGLER(CRYPTO_ctr128_encrypt)
# endif
#else
# ifndef _CRYPTO_ctr128_encrypt
#  define _CRYPTO_ctr128_encrypt OPENSSL_MANGLER_ASM(CRYPTO_ctr128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ctr128_encrypt_ctr32
#  define CRYPTO_ctr128_encrypt_ctr32 OPENSSL_MANGLER(CRYPTO_ctr128_encrypt_ctr32)
# endif
#else
# ifndef _CRYPTO_ctr128_encrypt_ctr32
#  define _CRYPTO_ctr128_encrypt_ctr32 OPENSSL_MANGLER_ASM(CRYPTO_ctr128_encrypt_ctr32)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_cts128_decrypt
#  define CRYPTO_cts128_decrypt OPENSSL_MANGLER(CRYPTO_cts128_decrypt)
# endif
#else
# ifndef _CRYPTO_cts128_decrypt
#  define _CRYPTO_cts128_decrypt OPENSSL_MANGLER_ASM(CRYPTO_cts128_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_cts128_decrypt_block
#  define CRYPTO_cts128_decrypt_block OPENSSL_MANGLER(CRYPTO_cts128_decrypt_block)
# endif
#else
# ifndef _CRYPTO_cts128_decrypt_block
#  define _CRYPTO_cts128_decrypt_block OPENSSL_MANGLER_ASM(CRYPTO_cts128_decrypt_block)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_cts128_encrypt
#  define CRYPTO_cts128_encrypt OPENSSL_MANGLER(CRYPTO_cts128_encrypt)
# endif
#else
# ifndef _CRYPTO_cts128_encrypt
#  define _CRYPTO_cts128_encrypt OPENSSL_MANGLER_ASM(CRYPTO_cts128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_cts128_encrypt_block
#  define CRYPTO_cts128_encrypt_block OPENSSL_MANGLER(CRYPTO_cts128_encrypt_block)
# endif
#else
# ifndef _CRYPTO_cts128_encrypt_block
#  define _CRYPTO_cts128_encrypt_block OPENSSL_MANGLER_ASM(CRYPTO_cts128_encrypt_block)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_dup_ex_data
#  define CRYPTO_dup_ex_data OPENSSL_MANGLER(CRYPTO_dup_ex_data)
# endif
#else
# ifndef _CRYPTO_dup_ex_data
#  define _CRYPTO_dup_ex_data OPENSSL_MANGLER_ASM(CRYPTO_dup_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_free
#  define CRYPTO_free OPENSSL_MANGLER(CRYPTO_free)
# endif
#else
# ifndef _CRYPTO_free
#  define _CRYPTO_free OPENSSL_MANGLER_ASM(CRYPTO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_free_ex_data
#  define CRYPTO_free_ex_data OPENSSL_MANGLER(CRYPTO_free_ex_data)
# endif
#else
# ifndef _CRYPTO_free_ex_data
#  define _CRYPTO_free_ex_data OPENSSL_MANGLER_ASM(CRYPTO_free_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_free_ex_index
#  define CRYPTO_free_ex_index OPENSSL_MANGLER(CRYPTO_free_ex_index)
# endif
#else
# ifndef _CRYPTO_free_ex_index
#  define _CRYPTO_free_ex_index OPENSSL_MANGLER_ASM(CRYPTO_free_ex_index)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_aad
#  define CRYPTO_gcm128_aad OPENSSL_MANGLER(CRYPTO_gcm128_aad)
# endif
#else
# ifndef _CRYPTO_gcm128_aad
#  define _CRYPTO_gcm128_aad OPENSSL_MANGLER_ASM(CRYPTO_gcm128_aad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_decrypt
#  define CRYPTO_gcm128_decrypt OPENSSL_MANGLER(CRYPTO_gcm128_decrypt)
# endif
#else
# ifndef _CRYPTO_gcm128_decrypt
#  define _CRYPTO_gcm128_decrypt OPENSSL_MANGLER_ASM(CRYPTO_gcm128_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_decrypt_ctr32
#  define CRYPTO_gcm128_decrypt_ctr32 OPENSSL_MANGLER(CRYPTO_gcm128_decrypt_ctr32)
# endif
#else
# ifndef _CRYPTO_gcm128_decrypt_ctr32
#  define _CRYPTO_gcm128_decrypt_ctr32 OPENSSL_MANGLER_ASM(CRYPTO_gcm128_decrypt_ctr32)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_encrypt
#  define CRYPTO_gcm128_encrypt OPENSSL_MANGLER(CRYPTO_gcm128_encrypt)
# endif
#else
# ifndef _CRYPTO_gcm128_encrypt
#  define _CRYPTO_gcm128_encrypt OPENSSL_MANGLER_ASM(CRYPTO_gcm128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_encrypt_ctr32
#  define CRYPTO_gcm128_encrypt_ctr32 OPENSSL_MANGLER(CRYPTO_gcm128_encrypt_ctr32)
# endif
#else
# ifndef _CRYPTO_gcm128_encrypt_ctr32
#  define _CRYPTO_gcm128_encrypt_ctr32 OPENSSL_MANGLER_ASM(CRYPTO_gcm128_encrypt_ctr32)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_finish
#  define CRYPTO_gcm128_finish OPENSSL_MANGLER(CRYPTO_gcm128_finish)
# endif
#else
# ifndef _CRYPTO_gcm128_finish
#  define _CRYPTO_gcm128_finish OPENSSL_MANGLER_ASM(CRYPTO_gcm128_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_init
#  define CRYPTO_gcm128_init OPENSSL_MANGLER(CRYPTO_gcm128_init)
# endif
#else
# ifndef _CRYPTO_gcm128_init
#  define _CRYPTO_gcm128_init OPENSSL_MANGLER_ASM(CRYPTO_gcm128_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_new
#  define CRYPTO_gcm128_new OPENSSL_MANGLER(CRYPTO_gcm128_new)
# endif
#else
# ifndef _CRYPTO_gcm128_new
#  define _CRYPTO_gcm128_new OPENSSL_MANGLER_ASM(CRYPTO_gcm128_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_release
#  define CRYPTO_gcm128_release OPENSSL_MANGLER(CRYPTO_gcm128_release)
# endif
#else
# ifndef _CRYPTO_gcm128_release
#  define _CRYPTO_gcm128_release OPENSSL_MANGLER_ASM(CRYPTO_gcm128_release)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_setiv
#  define CRYPTO_gcm128_setiv OPENSSL_MANGLER(CRYPTO_gcm128_setiv)
# endif
#else
# ifndef _CRYPTO_gcm128_setiv
#  define _CRYPTO_gcm128_setiv OPENSSL_MANGLER_ASM(CRYPTO_gcm128_setiv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_gcm128_tag
#  define CRYPTO_gcm128_tag OPENSSL_MANGLER(CRYPTO_gcm128_tag)
# endif
#else
# ifndef _CRYPTO_gcm128_tag
#  define _CRYPTO_gcm128_tag OPENSSL_MANGLER_ASM(CRYPTO_gcm128_tag)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_get_ex_data
#  define CRYPTO_get_ex_data OPENSSL_MANGLER(CRYPTO_get_ex_data)
# endif
#else
# ifndef _CRYPTO_get_ex_data
#  define _CRYPTO_get_ex_data OPENSSL_MANGLER_ASM(CRYPTO_get_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_get_ex_new_index
#  define CRYPTO_get_ex_new_index OPENSSL_MANGLER(CRYPTO_get_ex_new_index)
# endif
#else
# ifndef _CRYPTO_get_ex_new_index
#  define _CRYPTO_get_ex_new_index OPENSSL_MANGLER_ASM(CRYPTO_get_ex_new_index)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_get_mem_functions
#  define CRYPTO_get_mem_functions OPENSSL_MANGLER(CRYPTO_get_mem_functions)
# endif
#else
# ifndef _CRYPTO_get_mem_functions
#  define _CRYPTO_get_mem_functions OPENSSL_MANGLER_ASM(CRYPTO_get_mem_functions)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_malloc
#  define CRYPTO_malloc OPENSSL_MANGLER(CRYPTO_malloc)
# endif
#else
# ifndef _CRYPTO_malloc
#  define _CRYPTO_malloc OPENSSL_MANGLER_ASM(CRYPTO_malloc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_memcmp
#  define CRYPTO_memcmp OPENSSL_MANGLER(CRYPTO_memcmp)
# endif
#else
# ifndef _CRYPTO_memcmp
#  define _CRYPTO_memcmp OPENSSL_MANGLER_ASM(CRYPTO_memcmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_mem_ctrl
#  define CRYPTO_mem_ctrl OPENSSL_MANGLER(CRYPTO_mem_ctrl)
# endif
#else
# ifndef _CRYPTO_mem_ctrl
#  define _CRYPTO_mem_ctrl OPENSSL_MANGLER_ASM(CRYPTO_mem_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_memdup
#  define CRYPTO_memdup OPENSSL_MANGLER(CRYPTO_memdup)
# endif
#else
# ifndef _CRYPTO_memdup
#  define _CRYPTO_memdup OPENSSL_MANGLER_ASM(CRYPTO_memdup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_new_ex_data
#  define CRYPTO_new_ex_data OPENSSL_MANGLER(CRYPTO_new_ex_data)
# endif
#else
# ifndef _CRYPTO_new_ex_data
#  define _CRYPTO_new_ex_data OPENSSL_MANGLER_ASM(CRYPTO_new_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_nistcts128_decrypt
#  define CRYPTO_nistcts128_decrypt OPENSSL_MANGLER(CRYPTO_nistcts128_decrypt)
# endif
#else
# ifndef _CRYPTO_nistcts128_decrypt
#  define _CRYPTO_nistcts128_decrypt OPENSSL_MANGLER_ASM(CRYPTO_nistcts128_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_nistcts128_decrypt_block
#  define CRYPTO_nistcts128_decrypt_block OPENSSL_MANGLER(CRYPTO_nistcts128_decrypt_block)
# endif
#else
# ifndef _CRYPTO_nistcts128_decrypt_block
#  define _CRYPTO_nistcts128_decrypt_block OPENSSL_MANGLER_ASM(CRYPTO_nistcts128_decrypt_block)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_nistcts128_encrypt
#  define CRYPTO_nistcts128_encrypt OPENSSL_MANGLER(CRYPTO_nistcts128_encrypt)
# endif
#else
# ifndef _CRYPTO_nistcts128_encrypt
#  define _CRYPTO_nistcts128_encrypt OPENSSL_MANGLER_ASM(CRYPTO_nistcts128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_nistcts128_encrypt_block
#  define CRYPTO_nistcts128_encrypt_block OPENSSL_MANGLER(CRYPTO_nistcts128_encrypt_block)
# endif
#else
# ifndef _CRYPTO_nistcts128_encrypt_block
#  define _CRYPTO_nistcts128_encrypt_block OPENSSL_MANGLER_ASM(CRYPTO_nistcts128_encrypt_block)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ocb128_aad
#  define CRYPTO_ocb128_aad OPENSSL_MANGLER(CRYPTO_ocb128_aad)
# endif
#else
# ifndef _CRYPTO_ocb128_aad
#  define _CRYPTO_ocb128_aad OPENSSL_MANGLER_ASM(CRYPTO_ocb128_aad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ocb128_cleanup
#  define CRYPTO_ocb128_cleanup OPENSSL_MANGLER(CRYPTO_ocb128_cleanup)
# endif
#else
# ifndef _CRYPTO_ocb128_cleanup
#  define _CRYPTO_ocb128_cleanup OPENSSL_MANGLER_ASM(CRYPTO_ocb128_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ocb128_copy_ctx
#  define CRYPTO_ocb128_copy_ctx OPENSSL_MANGLER(CRYPTO_ocb128_copy_ctx)
# endif
#else
# ifndef _CRYPTO_ocb128_copy_ctx
#  define _CRYPTO_ocb128_copy_ctx OPENSSL_MANGLER_ASM(CRYPTO_ocb128_copy_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ocb128_decrypt
#  define CRYPTO_ocb128_decrypt OPENSSL_MANGLER(CRYPTO_ocb128_decrypt)
# endif
#else
# ifndef _CRYPTO_ocb128_decrypt
#  define _CRYPTO_ocb128_decrypt OPENSSL_MANGLER_ASM(CRYPTO_ocb128_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ocb128_encrypt
#  define CRYPTO_ocb128_encrypt OPENSSL_MANGLER(CRYPTO_ocb128_encrypt)
# endif
#else
# ifndef _CRYPTO_ocb128_encrypt
#  define _CRYPTO_ocb128_encrypt OPENSSL_MANGLER_ASM(CRYPTO_ocb128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ocb128_finish
#  define CRYPTO_ocb128_finish OPENSSL_MANGLER(CRYPTO_ocb128_finish)
# endif
#else
# ifndef _CRYPTO_ocb128_finish
#  define _CRYPTO_ocb128_finish OPENSSL_MANGLER_ASM(CRYPTO_ocb128_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ocb128_init
#  define CRYPTO_ocb128_init OPENSSL_MANGLER(CRYPTO_ocb128_init)
# endif
#else
# ifndef _CRYPTO_ocb128_init
#  define _CRYPTO_ocb128_init OPENSSL_MANGLER_ASM(CRYPTO_ocb128_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ocb128_new
#  define CRYPTO_ocb128_new OPENSSL_MANGLER(CRYPTO_ocb128_new)
# endif
#else
# ifndef _CRYPTO_ocb128_new
#  define _CRYPTO_ocb128_new OPENSSL_MANGLER_ASM(CRYPTO_ocb128_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ocb128_setiv
#  define CRYPTO_ocb128_setiv OPENSSL_MANGLER(CRYPTO_ocb128_setiv)
# endif
#else
# ifndef _CRYPTO_ocb128_setiv
#  define _CRYPTO_ocb128_setiv OPENSSL_MANGLER_ASM(CRYPTO_ocb128_setiv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ocb128_tag
#  define CRYPTO_ocb128_tag OPENSSL_MANGLER(CRYPTO_ocb128_tag)
# endif
#else
# ifndef _CRYPTO_ocb128_tag
#  define _CRYPTO_ocb128_tag OPENSSL_MANGLER_ASM(CRYPTO_ocb128_tag)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_ofb128_encrypt
#  define CRYPTO_ofb128_encrypt OPENSSL_MANGLER(CRYPTO_ofb128_encrypt)
# endif
#else
# ifndef _CRYPTO_ofb128_encrypt
#  define _CRYPTO_ofb128_encrypt OPENSSL_MANGLER_ASM(CRYPTO_ofb128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_realloc
#  define CRYPTO_realloc OPENSSL_MANGLER(CRYPTO_realloc)
# endif
#else
# ifndef _CRYPTO_realloc
#  define _CRYPTO_realloc OPENSSL_MANGLER_ASM(CRYPTO_realloc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_secure_actual_size
#  define CRYPTO_secure_actual_size OPENSSL_MANGLER(CRYPTO_secure_actual_size)
# endif
#else
# ifndef _CRYPTO_secure_actual_size
#  define _CRYPTO_secure_actual_size OPENSSL_MANGLER_ASM(CRYPTO_secure_actual_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_secure_allocated
#  define CRYPTO_secure_allocated OPENSSL_MANGLER(CRYPTO_secure_allocated)
# endif
#else
# ifndef _CRYPTO_secure_allocated
#  define _CRYPTO_secure_allocated OPENSSL_MANGLER_ASM(CRYPTO_secure_allocated)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_secure_clear_free
#  define CRYPTO_secure_clear_free OPENSSL_MANGLER(CRYPTO_secure_clear_free)
# endif
#else
# ifndef _CRYPTO_secure_clear_free
#  define _CRYPTO_secure_clear_free OPENSSL_MANGLER_ASM(CRYPTO_secure_clear_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_secure_free
#  define CRYPTO_secure_free OPENSSL_MANGLER(CRYPTO_secure_free)
# endif
#else
# ifndef _CRYPTO_secure_free
#  define _CRYPTO_secure_free OPENSSL_MANGLER_ASM(CRYPTO_secure_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_secure_malloc
#  define CRYPTO_secure_malloc OPENSSL_MANGLER(CRYPTO_secure_malloc)
# endif
#else
# ifndef _CRYPTO_secure_malloc
#  define _CRYPTO_secure_malloc OPENSSL_MANGLER_ASM(CRYPTO_secure_malloc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_secure_malloc_done
#  define CRYPTO_secure_malloc_done OPENSSL_MANGLER(CRYPTO_secure_malloc_done)
# endif
#else
# ifndef _CRYPTO_secure_malloc_done
#  define _CRYPTO_secure_malloc_done OPENSSL_MANGLER_ASM(CRYPTO_secure_malloc_done)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_secure_malloc_init
#  define CRYPTO_secure_malloc_init OPENSSL_MANGLER(CRYPTO_secure_malloc_init)
# endif
#else
# ifndef _CRYPTO_secure_malloc_init
#  define _CRYPTO_secure_malloc_init OPENSSL_MANGLER_ASM(CRYPTO_secure_malloc_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_secure_malloc_initialized
#  define CRYPTO_secure_malloc_initialized OPENSSL_MANGLER(CRYPTO_secure_malloc_initialized)
# endif
#else
# ifndef _CRYPTO_secure_malloc_initialized
#  define _CRYPTO_secure_malloc_initialized OPENSSL_MANGLER_ASM(CRYPTO_secure_malloc_initialized)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_secure_used
#  define CRYPTO_secure_used OPENSSL_MANGLER(CRYPTO_secure_used)
# endif
#else
# ifndef _CRYPTO_secure_used
#  define _CRYPTO_secure_used OPENSSL_MANGLER_ASM(CRYPTO_secure_used)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_secure_zalloc
#  define CRYPTO_secure_zalloc OPENSSL_MANGLER(CRYPTO_secure_zalloc)
# endif
#else
# ifndef _CRYPTO_secure_zalloc
#  define _CRYPTO_secure_zalloc OPENSSL_MANGLER_ASM(CRYPTO_secure_zalloc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_set_ex_data
#  define CRYPTO_set_ex_data OPENSSL_MANGLER(CRYPTO_set_ex_data)
# endif
#else
# ifndef _CRYPTO_set_ex_data
#  define _CRYPTO_set_ex_data OPENSSL_MANGLER_ASM(CRYPTO_set_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_set_mem_debug
#  define CRYPTO_set_mem_debug OPENSSL_MANGLER(CRYPTO_set_mem_debug)
# endif
#else
# ifndef _CRYPTO_set_mem_debug
#  define _CRYPTO_set_mem_debug OPENSSL_MANGLER_ASM(CRYPTO_set_mem_debug)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_set_mem_functions
#  define CRYPTO_set_mem_functions OPENSSL_MANGLER(CRYPTO_set_mem_functions)
# endif
#else
# ifndef _CRYPTO_set_mem_functions
#  define _CRYPTO_set_mem_functions OPENSSL_MANGLER_ASM(CRYPTO_set_mem_functions)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_strdup
#  define CRYPTO_strdup OPENSSL_MANGLER(CRYPTO_strdup)
# endif
#else
# ifndef _CRYPTO_strdup
#  define _CRYPTO_strdup OPENSSL_MANGLER_ASM(CRYPTO_strdup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_strndup
#  define CRYPTO_strndup OPENSSL_MANGLER(CRYPTO_strndup)
# endif
#else
# ifndef _CRYPTO_strndup
#  define _CRYPTO_strndup OPENSSL_MANGLER_ASM(CRYPTO_strndup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_cleanup_local
#  define CRYPTO_THREAD_cleanup_local OPENSSL_MANGLER(CRYPTO_THREAD_cleanup_local)
# endif
#else
# ifndef _CRYPTO_THREAD_cleanup_local
#  define _CRYPTO_THREAD_cleanup_local OPENSSL_MANGLER_ASM(CRYPTO_THREAD_cleanup_local)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_compare_id
#  define CRYPTO_THREAD_compare_id OPENSSL_MANGLER(CRYPTO_THREAD_compare_id)
# endif
#else
# ifndef _CRYPTO_THREAD_compare_id
#  define _CRYPTO_THREAD_compare_id OPENSSL_MANGLER_ASM(CRYPTO_THREAD_compare_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_get_current_id
#  define CRYPTO_THREAD_get_current_id OPENSSL_MANGLER(CRYPTO_THREAD_get_current_id)
# endif
#else
# ifndef _CRYPTO_THREAD_get_current_id
#  define _CRYPTO_THREAD_get_current_id OPENSSL_MANGLER_ASM(CRYPTO_THREAD_get_current_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_get_local
#  define CRYPTO_THREAD_get_local OPENSSL_MANGLER(CRYPTO_THREAD_get_local)
# endif
#else
# ifndef _CRYPTO_THREAD_get_local
#  define _CRYPTO_THREAD_get_local OPENSSL_MANGLER_ASM(CRYPTO_THREAD_get_local)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_init_local
#  define CRYPTO_THREAD_init_local OPENSSL_MANGLER(CRYPTO_THREAD_init_local)
# endif
#else
# ifndef _CRYPTO_THREAD_init_local
#  define _CRYPTO_THREAD_init_local OPENSSL_MANGLER_ASM(CRYPTO_THREAD_init_local)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_lock_free
#  define CRYPTO_THREAD_lock_free OPENSSL_MANGLER(CRYPTO_THREAD_lock_free)
# endif
#else
# ifndef _CRYPTO_THREAD_lock_free
#  define _CRYPTO_THREAD_lock_free OPENSSL_MANGLER_ASM(CRYPTO_THREAD_lock_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_lock_new
#  define CRYPTO_THREAD_lock_new OPENSSL_MANGLER(CRYPTO_THREAD_lock_new)
# endif
#else
# ifndef _CRYPTO_THREAD_lock_new
#  define _CRYPTO_THREAD_lock_new OPENSSL_MANGLER_ASM(CRYPTO_THREAD_lock_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_read_lock
#  define CRYPTO_THREAD_read_lock OPENSSL_MANGLER(CRYPTO_THREAD_read_lock)
# endif
#else
# ifndef _CRYPTO_THREAD_read_lock
#  define _CRYPTO_THREAD_read_lock OPENSSL_MANGLER_ASM(CRYPTO_THREAD_read_lock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_set_local
#  define CRYPTO_THREAD_set_local OPENSSL_MANGLER(CRYPTO_THREAD_set_local)
# endif
#else
# ifndef _CRYPTO_THREAD_set_local
#  define _CRYPTO_THREAD_set_local OPENSSL_MANGLER_ASM(CRYPTO_THREAD_set_local)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_unlock
#  define CRYPTO_THREAD_unlock OPENSSL_MANGLER(CRYPTO_THREAD_unlock)
# endif
#else
# ifndef _CRYPTO_THREAD_unlock
#  define _CRYPTO_THREAD_unlock OPENSSL_MANGLER_ASM(CRYPTO_THREAD_unlock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_THREAD_write_lock
#  define CRYPTO_THREAD_write_lock OPENSSL_MANGLER(CRYPTO_THREAD_write_lock)
# endif
#else
# ifndef _CRYPTO_THREAD_write_lock
#  define _CRYPTO_THREAD_write_lock OPENSSL_MANGLER_ASM(CRYPTO_THREAD_write_lock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_xts128_encrypt
#  define CRYPTO_xts128_encrypt OPENSSL_MANGLER(CRYPTO_xts128_encrypt)
# endif
#else
# ifndef _CRYPTO_xts128_encrypt
#  define _CRYPTO_xts128_encrypt OPENSSL_MANGLER_ASM(CRYPTO_xts128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CRYPTO_zalloc
#  define CRYPTO_zalloc OPENSSL_MANGLER(CRYPTO_zalloc)
# endif
#else
# ifndef _CRYPTO_zalloc
#  define _CRYPTO_zalloc OPENSSL_MANGLER_ASM(CRYPTO_zalloc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_free
#  define CTLOG_free OPENSSL_MANGLER(CTLOG_free)
# endif
#else
# ifndef _CTLOG_free
#  define _CTLOG_free OPENSSL_MANGLER_ASM(CTLOG_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_get0_log_id
#  define CTLOG_get0_log_id OPENSSL_MANGLER(CTLOG_get0_log_id)
# endif
#else
# ifndef _CTLOG_get0_log_id
#  define _CTLOG_get0_log_id OPENSSL_MANGLER_ASM(CTLOG_get0_log_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_get0_name
#  define CTLOG_get0_name OPENSSL_MANGLER(CTLOG_get0_name)
# endif
#else
# ifndef _CTLOG_get0_name
#  define _CTLOG_get0_name OPENSSL_MANGLER_ASM(CTLOG_get0_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_get0_public_key
#  define CTLOG_get0_public_key OPENSSL_MANGLER(CTLOG_get0_public_key)
# endif
#else
# ifndef _CTLOG_get0_public_key
#  define _CTLOG_get0_public_key OPENSSL_MANGLER_ASM(CTLOG_get0_public_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_new
#  define CTLOG_new OPENSSL_MANGLER(CTLOG_new)
# endif
#else
# ifndef _CTLOG_new
#  define _CTLOG_new OPENSSL_MANGLER_ASM(CTLOG_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_new_from_base64
#  define CTLOG_new_from_base64 OPENSSL_MANGLER(CTLOG_new_from_base64)
# endif
#else
# ifndef _CTLOG_new_from_base64
#  define _CTLOG_new_from_base64 OPENSSL_MANGLER_ASM(CTLOG_new_from_base64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_STORE_free
#  define CTLOG_STORE_free OPENSSL_MANGLER(CTLOG_STORE_free)
# endif
#else
# ifndef _CTLOG_STORE_free
#  define _CTLOG_STORE_free OPENSSL_MANGLER_ASM(CTLOG_STORE_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_STORE_get0_log_by_id
#  define CTLOG_STORE_get0_log_by_id OPENSSL_MANGLER(CTLOG_STORE_get0_log_by_id)
# endif
#else
# ifndef _CTLOG_STORE_get0_log_by_id
#  define _CTLOG_STORE_get0_log_by_id OPENSSL_MANGLER_ASM(CTLOG_STORE_get0_log_by_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_STORE_load_default_file
#  define CTLOG_STORE_load_default_file OPENSSL_MANGLER(CTLOG_STORE_load_default_file)
# endif
#else
# ifndef _CTLOG_STORE_load_default_file
#  define _CTLOG_STORE_load_default_file OPENSSL_MANGLER_ASM(CTLOG_STORE_load_default_file)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_STORE_load_file
#  define CTLOG_STORE_load_file OPENSSL_MANGLER(CTLOG_STORE_load_file)
# endif
#else
# ifndef _CTLOG_STORE_load_file
#  define _CTLOG_STORE_load_file OPENSSL_MANGLER_ASM(CTLOG_STORE_load_file)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CTLOG_STORE_new
#  define CTLOG_STORE_new OPENSSL_MANGLER(CTLOG_STORE_new)
# endif
#else
# ifndef _CTLOG_STORE_new
#  define _CTLOG_STORE_new OPENSSL_MANGLER_ASM(CTLOG_STORE_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CT_POLICY_EVAL_CTX_free
#  define CT_POLICY_EVAL_CTX_free OPENSSL_MANGLER(CT_POLICY_EVAL_CTX_free)
# endif
#else
# ifndef _CT_POLICY_EVAL_CTX_free
#  define _CT_POLICY_EVAL_CTX_free OPENSSL_MANGLER_ASM(CT_POLICY_EVAL_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CT_POLICY_EVAL_CTX_get0_cert
#  define CT_POLICY_EVAL_CTX_get0_cert OPENSSL_MANGLER(CT_POLICY_EVAL_CTX_get0_cert)
# endif
#else
# ifndef _CT_POLICY_EVAL_CTX_get0_cert
#  define _CT_POLICY_EVAL_CTX_get0_cert OPENSSL_MANGLER_ASM(CT_POLICY_EVAL_CTX_get0_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CT_POLICY_EVAL_CTX_get0_issuer
#  define CT_POLICY_EVAL_CTX_get0_issuer OPENSSL_MANGLER(CT_POLICY_EVAL_CTX_get0_issuer)
# endif
#else
# ifndef _CT_POLICY_EVAL_CTX_get0_issuer
#  define _CT_POLICY_EVAL_CTX_get0_issuer OPENSSL_MANGLER_ASM(CT_POLICY_EVAL_CTX_get0_issuer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CT_POLICY_EVAL_CTX_get0_log_store
#  define CT_POLICY_EVAL_CTX_get0_log_store OPENSSL_MANGLER(CT_POLICY_EVAL_CTX_get0_log_store)
# endif
#else
# ifndef _CT_POLICY_EVAL_CTX_get0_log_store
#  define _CT_POLICY_EVAL_CTX_get0_log_store OPENSSL_MANGLER_ASM(CT_POLICY_EVAL_CTX_get0_log_store)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CT_POLICY_EVAL_CTX_get_time
#  define CT_POLICY_EVAL_CTX_get_time OPENSSL_MANGLER(CT_POLICY_EVAL_CTX_get_time)
# endif
#else
# ifndef _CT_POLICY_EVAL_CTX_get_time
#  define _CT_POLICY_EVAL_CTX_get_time OPENSSL_MANGLER_ASM(CT_POLICY_EVAL_CTX_get_time)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CT_POLICY_EVAL_CTX_new
#  define CT_POLICY_EVAL_CTX_new OPENSSL_MANGLER(CT_POLICY_EVAL_CTX_new)
# endif
#else
# ifndef _CT_POLICY_EVAL_CTX_new
#  define _CT_POLICY_EVAL_CTX_new OPENSSL_MANGLER_ASM(CT_POLICY_EVAL_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CT_POLICY_EVAL_CTX_set1_cert
#  define CT_POLICY_EVAL_CTX_set1_cert OPENSSL_MANGLER(CT_POLICY_EVAL_CTX_set1_cert)
# endif
#else
# ifndef _CT_POLICY_EVAL_CTX_set1_cert
#  define _CT_POLICY_EVAL_CTX_set1_cert OPENSSL_MANGLER_ASM(CT_POLICY_EVAL_CTX_set1_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CT_POLICY_EVAL_CTX_set1_issuer
#  define CT_POLICY_EVAL_CTX_set1_issuer OPENSSL_MANGLER(CT_POLICY_EVAL_CTX_set1_issuer)
# endif
#else
# ifndef _CT_POLICY_EVAL_CTX_set1_issuer
#  define _CT_POLICY_EVAL_CTX_set1_issuer OPENSSL_MANGLER_ASM(CT_POLICY_EVAL_CTX_set1_issuer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CT_POLICY_EVAL_CTX_set_shared_CTLOG_STORE
#  define CT_POLICY_EVAL_CTX_set_shared_CTLOG_STORE OPENSSL_MANGLER(CT_POLICY_EVAL_CTX_set_shared_CTLOG_STORE)
# endif
#else
# ifndef _CT_POLICY_EVAL_CTX_set_shared_CTLOG_STORE
#  define _CT_POLICY_EVAL_CTX_set_shared_CTLOG_STORE OPENSSL_MANGLER_ASM(CT_POLICY_EVAL_CTX_set_shared_CTLOG_STORE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef CT_POLICY_EVAL_CTX_set_time
#  define CT_POLICY_EVAL_CTX_set_time OPENSSL_MANGLER(CT_POLICY_EVAL_CTX_set_time)
# endif
#else
# ifndef _CT_POLICY_EVAL_CTX_set_time
#  define _CT_POLICY_EVAL_CTX_set_time OPENSSL_MANGLER_ASM(CT_POLICY_EVAL_CTX_set_time)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_base_double_scalarmul_non_secret
#  define curve448_base_double_scalarmul_non_secret OPENSSL_MANGLER(curve448_base_double_scalarmul_non_secret)
# endif
#else
# ifndef _curve448_base_double_scalarmul_non_secret
#  define _curve448_base_double_scalarmul_non_secret OPENSSL_MANGLER_ASM(curve448_base_double_scalarmul_non_secret)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_point_decode_like_eddsa_and_mul_by_ratio
#  define curve448_point_decode_like_eddsa_and_mul_by_ratio OPENSSL_MANGLER(curve448_point_decode_like_eddsa_and_mul_by_ratio)
# endif
#else
# ifndef _curve448_point_decode_like_eddsa_and_mul_by_ratio
#  define _curve448_point_decode_like_eddsa_and_mul_by_ratio OPENSSL_MANGLER_ASM(curve448_point_decode_like_eddsa_and_mul_by_ratio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_point_destroy
#  define curve448_point_destroy OPENSSL_MANGLER(curve448_point_destroy)
# endif
#else
# ifndef _curve448_point_destroy
#  define _curve448_point_destroy OPENSSL_MANGLER_ASM(curve448_point_destroy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_point_double
#  define curve448_point_double OPENSSL_MANGLER(curve448_point_double)
# endif
#else
# ifndef _curve448_point_double
#  define _curve448_point_double OPENSSL_MANGLER_ASM(curve448_point_double)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_point_eq
#  define curve448_point_eq OPENSSL_MANGLER(curve448_point_eq)
# endif
#else
# ifndef _curve448_point_eq
#  define _curve448_point_eq OPENSSL_MANGLER_ASM(curve448_point_eq)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_point_mul_by_ratio_and_encode_like_eddsa
#  define curve448_point_mul_by_ratio_and_encode_like_eddsa OPENSSL_MANGLER(curve448_point_mul_by_ratio_and_encode_like_eddsa)
# endif
#else
# ifndef _curve448_point_mul_by_ratio_and_encode_like_eddsa
#  define _curve448_point_mul_by_ratio_and_encode_like_eddsa OPENSSL_MANGLER_ASM(curve448_point_mul_by_ratio_and_encode_like_eddsa)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_point_mul_by_ratio_and_encode_like_x448
#  define curve448_point_mul_by_ratio_and_encode_like_x448 OPENSSL_MANGLER(curve448_point_mul_by_ratio_and_encode_like_x448)
# endif
#else
# ifndef _curve448_point_mul_by_ratio_and_encode_like_x448
#  define _curve448_point_mul_by_ratio_and_encode_like_x448 OPENSSL_MANGLER_ASM(curve448_point_mul_by_ratio_and_encode_like_x448)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_point_valid
#  define curve448_point_valid OPENSSL_MANGLER(curve448_point_valid)
# endif
#else
# ifndef _curve448_point_valid
#  define _curve448_point_valid OPENSSL_MANGLER_ASM(curve448_point_valid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_precomputed_base
#  define curve448_precomputed_base OPENSSL_MANGLER(curve448_precomputed_base)
# endif
#else
# ifndef _curve448_precomputed_base
#  define _curve448_precomputed_base OPENSSL_MANGLER_ASM(curve448_precomputed_base)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_precomputed_scalarmul
#  define curve448_precomputed_scalarmul OPENSSL_MANGLER(curve448_precomputed_scalarmul)
# endif
#else
# ifndef _curve448_precomputed_scalarmul
#  define _curve448_precomputed_scalarmul OPENSSL_MANGLER_ASM(curve448_precomputed_scalarmul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_scalar_add
#  define curve448_scalar_add OPENSSL_MANGLER(curve448_scalar_add)
# endif
#else
# ifndef _curve448_scalar_add
#  define _curve448_scalar_add OPENSSL_MANGLER_ASM(curve448_scalar_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_scalar_decode
#  define curve448_scalar_decode OPENSSL_MANGLER(curve448_scalar_decode)
# endif
#else
# ifndef _curve448_scalar_decode
#  define _curve448_scalar_decode OPENSSL_MANGLER_ASM(curve448_scalar_decode)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_scalar_decode_long
#  define curve448_scalar_decode_long OPENSSL_MANGLER(curve448_scalar_decode_long)
# endif
#else
# ifndef _curve448_scalar_decode_long
#  define _curve448_scalar_decode_long OPENSSL_MANGLER_ASM(curve448_scalar_decode_long)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_scalar_destroy
#  define curve448_scalar_destroy OPENSSL_MANGLER(curve448_scalar_destroy)
# endif
#else
# ifndef _curve448_scalar_destroy
#  define _curve448_scalar_destroy OPENSSL_MANGLER_ASM(curve448_scalar_destroy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_scalar_encode
#  define curve448_scalar_encode OPENSSL_MANGLER(curve448_scalar_encode)
# endif
#else
# ifndef _curve448_scalar_encode
#  define _curve448_scalar_encode OPENSSL_MANGLER_ASM(curve448_scalar_encode)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_scalar_halve
#  define curve448_scalar_halve OPENSSL_MANGLER(curve448_scalar_halve)
# endif
#else
# ifndef _curve448_scalar_halve
#  define _curve448_scalar_halve OPENSSL_MANGLER_ASM(curve448_scalar_halve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_scalar_mul
#  define curve448_scalar_mul OPENSSL_MANGLER(curve448_scalar_mul)
# endif
#else
# ifndef _curve448_scalar_mul
#  define _curve448_scalar_mul OPENSSL_MANGLER_ASM(curve448_scalar_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_scalar_sub
#  define curve448_scalar_sub OPENSSL_MANGLER(curve448_scalar_sub)
# endif
#else
# ifndef _curve448_scalar_sub
#  define _curve448_scalar_sub OPENSSL_MANGLER_ASM(curve448_scalar_sub)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef curve448_wnaf_base
#  define curve448_wnaf_base OPENSSL_MANGLER(curve448_wnaf_base)
# endif
#else
# ifndef _curve448_wnaf_base
#  define _curve448_wnaf_base OPENSSL_MANGLER_ASM(curve448_wnaf_base)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef custom_ext_add
#  define custom_ext_add OPENSSL_MANGLER(custom_ext_add)
# endif
#else
# ifndef _custom_ext_add
#  define _custom_ext_add OPENSSL_MANGLER_ASM(custom_ext_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef custom_ext_find
#  define custom_ext_find OPENSSL_MANGLER(custom_ext_find)
# endif
#else
# ifndef _custom_ext_find
#  define _custom_ext_find OPENSSL_MANGLER_ASM(custom_ext_find)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef custom_ext_init
#  define custom_ext_init OPENSSL_MANGLER(custom_ext_init)
# endif
#else
# ifndef _custom_ext_init
#  define _custom_ext_init OPENSSL_MANGLER_ASM(custom_ext_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef custom_ext_parse
#  define custom_ext_parse OPENSSL_MANGLER(custom_ext_parse)
# endif
#else
# ifndef _custom_ext_parse
#  define _custom_ext_parse OPENSSL_MANGLER_ASM(custom_ext_parse)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef custom_exts_copy
#  define custom_exts_copy OPENSSL_MANGLER(custom_exts_copy)
# endif
#else
# ifndef _custom_exts_copy
#  define _custom_exts_copy OPENSSL_MANGLER_ASM(custom_exts_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef custom_exts_copy_flags
#  define custom_exts_copy_flags OPENSSL_MANGLER(custom_exts_copy_flags)
# endif
#else
# ifndef _custom_exts_copy_flags
#  define _custom_exts_copy_flags OPENSSL_MANGLER_ASM(custom_exts_copy_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef custom_exts_free
#  define custom_exts_free OPENSSL_MANGLER(custom_exts_free)
# endif
#else
# ifndef _custom_exts_free
#  define _custom_exts_free OPENSSL_MANGLER_ASM(custom_exts_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ACCESS_DESCRIPTION
#  define d2i_ACCESS_DESCRIPTION OPENSSL_MANGLER(d2i_ACCESS_DESCRIPTION)
# endif
#else
# ifndef _d2i_ACCESS_DESCRIPTION
#  define _d2i_ACCESS_DESCRIPTION OPENSSL_MANGLER_ASM(d2i_ACCESS_DESCRIPTION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ADMISSIONS
#  define d2i_ADMISSIONS OPENSSL_MANGLER(d2i_ADMISSIONS)
# endif
#else
# ifndef _d2i_ADMISSIONS
#  define _d2i_ADMISSIONS OPENSSL_MANGLER_ASM(d2i_ADMISSIONS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ADMISSION_SYNTAX
#  define d2i_ADMISSION_SYNTAX OPENSSL_MANGLER(d2i_ADMISSION_SYNTAX)
# endif
#else
# ifndef _d2i_ADMISSION_SYNTAX
#  define _d2i_ADMISSION_SYNTAX OPENSSL_MANGLER_ASM(d2i_ADMISSION_SYNTAX)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASIdentifierChoice
#  define d2i_ASIdentifierChoice OPENSSL_MANGLER(d2i_ASIdentifierChoice)
# endif
#else
# ifndef _d2i_ASIdentifierChoice
#  define _d2i_ASIdentifierChoice OPENSSL_MANGLER_ASM(d2i_ASIdentifierChoice)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASIdentifiers
#  define d2i_ASIdentifiers OPENSSL_MANGLER(d2i_ASIdentifiers)
# endif
#else
# ifndef _d2i_ASIdentifiers
#  define _d2i_ASIdentifiers OPENSSL_MANGLER_ASM(d2i_ASIdentifiers)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASIdOrRange
#  define d2i_ASIdOrRange OPENSSL_MANGLER(d2i_ASIdOrRange)
# endif
#else
# ifndef _d2i_ASIdOrRange
#  define _d2i_ASIdOrRange OPENSSL_MANGLER_ASM(d2i_ASIdOrRange)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_BIT_STRING
#  define d2i_ASN1_BIT_STRING OPENSSL_MANGLER(d2i_ASN1_BIT_STRING)
# endif
#else
# ifndef _d2i_ASN1_BIT_STRING
#  define _d2i_ASN1_BIT_STRING OPENSSL_MANGLER_ASM(d2i_ASN1_BIT_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_BMPSTRING
#  define d2i_ASN1_BMPSTRING OPENSSL_MANGLER(d2i_ASN1_BMPSTRING)
# endif
#else
# ifndef _d2i_ASN1_BMPSTRING
#  define _d2i_ASN1_BMPSTRING OPENSSL_MANGLER_ASM(d2i_ASN1_BMPSTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_ENUMERATED
#  define d2i_ASN1_ENUMERATED OPENSSL_MANGLER(d2i_ASN1_ENUMERATED)
# endif
#else
# ifndef _d2i_ASN1_ENUMERATED
#  define _d2i_ASN1_ENUMERATED OPENSSL_MANGLER_ASM(d2i_ASN1_ENUMERATED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_GENERALIZEDTIME
#  define d2i_ASN1_GENERALIZEDTIME OPENSSL_MANGLER(d2i_ASN1_GENERALIZEDTIME)
# endif
#else
# ifndef _d2i_ASN1_GENERALIZEDTIME
#  define _d2i_ASN1_GENERALIZEDTIME OPENSSL_MANGLER_ASM(d2i_ASN1_GENERALIZEDTIME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_GENERALSTRING
#  define d2i_ASN1_GENERALSTRING OPENSSL_MANGLER(d2i_ASN1_GENERALSTRING)
# endif
#else
# ifndef _d2i_ASN1_GENERALSTRING
#  define _d2i_ASN1_GENERALSTRING OPENSSL_MANGLER_ASM(d2i_ASN1_GENERALSTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_IA5STRING
#  define d2i_ASN1_IA5STRING OPENSSL_MANGLER(d2i_ASN1_IA5STRING)
# endif
#else
# ifndef _d2i_ASN1_IA5STRING
#  define _d2i_ASN1_IA5STRING OPENSSL_MANGLER_ASM(d2i_ASN1_IA5STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_INTEGER
#  define d2i_ASN1_INTEGER OPENSSL_MANGLER(d2i_ASN1_INTEGER)
# endif
#else
# ifndef _d2i_ASN1_INTEGER
#  define _d2i_ASN1_INTEGER OPENSSL_MANGLER_ASM(d2i_ASN1_INTEGER)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_NULL
#  define d2i_ASN1_NULL OPENSSL_MANGLER(d2i_ASN1_NULL)
# endif
#else
# ifndef _d2i_ASN1_NULL
#  define _d2i_ASN1_NULL OPENSSL_MANGLER_ASM(d2i_ASN1_NULL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_OBJECT
#  define d2i_ASN1_OBJECT OPENSSL_MANGLER(d2i_ASN1_OBJECT)
# endif
#else
# ifndef _d2i_ASN1_OBJECT
#  define _d2i_ASN1_OBJECT OPENSSL_MANGLER_ASM(d2i_ASN1_OBJECT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_OCTET_STRING
#  define d2i_ASN1_OCTET_STRING OPENSSL_MANGLER(d2i_ASN1_OCTET_STRING)
# endif
#else
# ifndef _d2i_ASN1_OCTET_STRING
#  define _d2i_ASN1_OCTET_STRING OPENSSL_MANGLER_ASM(d2i_ASN1_OCTET_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_PRINTABLE
#  define d2i_ASN1_PRINTABLE OPENSSL_MANGLER(d2i_ASN1_PRINTABLE)
# endif
#else
# ifndef _d2i_ASN1_PRINTABLE
#  define _d2i_ASN1_PRINTABLE OPENSSL_MANGLER_ASM(d2i_ASN1_PRINTABLE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_PRINTABLESTRING
#  define d2i_ASN1_PRINTABLESTRING OPENSSL_MANGLER(d2i_ASN1_PRINTABLESTRING)
# endif
#else
# ifndef _d2i_ASN1_PRINTABLESTRING
#  define _d2i_ASN1_PRINTABLESTRING OPENSSL_MANGLER_ASM(d2i_ASN1_PRINTABLESTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_SEQUENCE_ANY
#  define d2i_ASN1_SEQUENCE_ANY OPENSSL_MANGLER(d2i_ASN1_SEQUENCE_ANY)
# endif
#else
# ifndef _d2i_ASN1_SEQUENCE_ANY
#  define _d2i_ASN1_SEQUENCE_ANY OPENSSL_MANGLER_ASM(d2i_ASN1_SEQUENCE_ANY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_SET_ANY
#  define d2i_ASN1_SET_ANY OPENSSL_MANGLER(d2i_ASN1_SET_ANY)
# endif
#else
# ifndef _d2i_ASN1_SET_ANY
#  define _d2i_ASN1_SET_ANY OPENSSL_MANGLER_ASM(d2i_ASN1_SET_ANY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_T61STRING
#  define d2i_ASN1_T61STRING OPENSSL_MANGLER(d2i_ASN1_T61STRING)
# endif
#else
# ifndef _d2i_ASN1_T61STRING
#  define _d2i_ASN1_T61STRING OPENSSL_MANGLER_ASM(d2i_ASN1_T61STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_TIME
#  define d2i_ASN1_TIME OPENSSL_MANGLER(d2i_ASN1_TIME)
# endif
#else
# ifndef _d2i_ASN1_TIME
#  define _d2i_ASN1_TIME OPENSSL_MANGLER_ASM(d2i_ASN1_TIME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_TYPE
#  define d2i_ASN1_TYPE OPENSSL_MANGLER(d2i_ASN1_TYPE)
# endif
#else
# ifndef _d2i_ASN1_TYPE
#  define _d2i_ASN1_TYPE OPENSSL_MANGLER_ASM(d2i_ASN1_TYPE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_UINTEGER
#  define d2i_ASN1_UINTEGER OPENSSL_MANGLER(d2i_ASN1_UINTEGER)
# endif
#else
# ifndef _d2i_ASN1_UINTEGER
#  define _d2i_ASN1_UINTEGER OPENSSL_MANGLER_ASM(d2i_ASN1_UINTEGER)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_UNIVERSALSTRING
#  define d2i_ASN1_UNIVERSALSTRING OPENSSL_MANGLER(d2i_ASN1_UNIVERSALSTRING)
# endif
#else
# ifndef _d2i_ASN1_UNIVERSALSTRING
#  define _d2i_ASN1_UNIVERSALSTRING OPENSSL_MANGLER_ASM(d2i_ASN1_UNIVERSALSTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_UTCTIME
#  define d2i_ASN1_UTCTIME OPENSSL_MANGLER(d2i_ASN1_UTCTIME)
# endif
#else
# ifndef _d2i_ASN1_UTCTIME
#  define _d2i_ASN1_UTCTIME OPENSSL_MANGLER_ASM(d2i_ASN1_UTCTIME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_UTF8STRING
#  define d2i_ASN1_UTF8STRING OPENSSL_MANGLER(d2i_ASN1_UTF8STRING)
# endif
#else
# ifndef _d2i_ASN1_UTF8STRING
#  define _d2i_ASN1_UTF8STRING OPENSSL_MANGLER_ASM(d2i_ASN1_UTF8STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASN1_VISIBLESTRING
#  define d2i_ASN1_VISIBLESTRING OPENSSL_MANGLER(d2i_ASN1_VISIBLESTRING)
# endif
#else
# ifndef _d2i_ASN1_VISIBLESTRING
#  define _d2i_ASN1_VISIBLESTRING OPENSSL_MANGLER_ASM(d2i_ASN1_VISIBLESTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ASRange
#  define d2i_ASRange OPENSSL_MANGLER(d2i_ASRange)
# endif
#else
# ifndef _d2i_ASRange
#  define _d2i_ASRange OPENSSL_MANGLER_ASM(d2i_ASRange)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_AUTHORITY_INFO_ACCESS
#  define d2i_AUTHORITY_INFO_ACCESS OPENSSL_MANGLER(d2i_AUTHORITY_INFO_ACCESS)
# endif
#else
# ifndef _d2i_AUTHORITY_INFO_ACCESS
#  define _d2i_AUTHORITY_INFO_ACCESS OPENSSL_MANGLER_ASM(d2i_AUTHORITY_INFO_ACCESS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_AUTHORITY_KEYID
#  define d2i_AUTHORITY_KEYID OPENSSL_MANGLER(d2i_AUTHORITY_KEYID)
# endif
#else
# ifndef _d2i_AUTHORITY_KEYID
#  define _d2i_AUTHORITY_KEYID OPENSSL_MANGLER_ASM(d2i_AUTHORITY_KEYID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_AutoPrivateKey
#  define d2i_AutoPrivateKey OPENSSL_MANGLER(d2i_AutoPrivateKey)
# endif
#else
# ifndef _d2i_AutoPrivateKey
#  define _d2i_AutoPrivateKey OPENSSL_MANGLER_ASM(d2i_AutoPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_BASIC_CONSTRAINTS
#  define d2i_BASIC_CONSTRAINTS OPENSSL_MANGLER(d2i_BASIC_CONSTRAINTS)
# endif
#else
# ifndef _d2i_BASIC_CONSTRAINTS
#  define _d2i_BASIC_CONSTRAINTS OPENSSL_MANGLER_ASM(d2i_BASIC_CONSTRAINTS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_CERTIFICATEPOLICIES
#  define d2i_CERTIFICATEPOLICIES OPENSSL_MANGLER(d2i_CERTIFICATEPOLICIES)
# endif
#else
# ifndef _d2i_CERTIFICATEPOLICIES
#  define _d2i_CERTIFICATEPOLICIES OPENSSL_MANGLER_ASM(d2i_CERTIFICATEPOLICIES)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_CMS_bio
#  define d2i_CMS_bio OPENSSL_MANGLER(d2i_CMS_bio)
# endif
#else
# ifndef _d2i_CMS_bio
#  define _d2i_CMS_bio OPENSSL_MANGLER_ASM(d2i_CMS_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_CMS_ContentInfo
#  define d2i_CMS_ContentInfo OPENSSL_MANGLER(d2i_CMS_ContentInfo)
# endif
#else
# ifndef _d2i_CMS_ContentInfo
#  define _d2i_CMS_ContentInfo OPENSSL_MANGLER_ASM(d2i_CMS_ContentInfo)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_CMS_ReceiptRequest
#  define d2i_CMS_ReceiptRequest OPENSSL_MANGLER(d2i_CMS_ReceiptRequest)
# endif
#else
# ifndef _d2i_CMS_ReceiptRequest
#  define _d2i_CMS_ReceiptRequest OPENSSL_MANGLER_ASM(d2i_CMS_ReceiptRequest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_CRL_DIST_POINTS
#  define d2i_CRL_DIST_POINTS OPENSSL_MANGLER(d2i_CRL_DIST_POINTS)
# endif
#else
# ifndef _d2i_CRL_DIST_POINTS
#  define _d2i_CRL_DIST_POINTS OPENSSL_MANGLER_ASM(d2i_CRL_DIST_POINTS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DHparams
#  define d2i_DHparams OPENSSL_MANGLER(d2i_DHparams)
# endif
#else
# ifndef _d2i_DHparams
#  define _d2i_DHparams OPENSSL_MANGLER_ASM(d2i_DHparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DHxparams
#  define d2i_DHxparams OPENSSL_MANGLER(d2i_DHxparams)
# endif
#else
# ifndef _d2i_DHxparams
#  define _d2i_DHxparams OPENSSL_MANGLER_ASM(d2i_DHxparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DIRECTORYSTRING
#  define d2i_DIRECTORYSTRING OPENSSL_MANGLER(d2i_DIRECTORYSTRING)
# endif
#else
# ifndef _d2i_DIRECTORYSTRING
#  define _d2i_DIRECTORYSTRING OPENSSL_MANGLER_ASM(d2i_DIRECTORYSTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DISPLAYTEXT
#  define d2i_DISPLAYTEXT OPENSSL_MANGLER(d2i_DISPLAYTEXT)
# endif
#else
# ifndef _d2i_DISPLAYTEXT
#  define _d2i_DISPLAYTEXT OPENSSL_MANGLER_ASM(d2i_DISPLAYTEXT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DIST_POINT
#  define d2i_DIST_POINT OPENSSL_MANGLER(d2i_DIST_POINT)
# endif
#else
# ifndef _d2i_DIST_POINT
#  define _d2i_DIST_POINT OPENSSL_MANGLER_ASM(d2i_DIST_POINT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DIST_POINT_NAME
#  define d2i_DIST_POINT_NAME OPENSSL_MANGLER(d2i_DIST_POINT_NAME)
# endif
#else
# ifndef _d2i_DIST_POINT_NAME
#  define _d2i_DIST_POINT_NAME OPENSSL_MANGLER_ASM(d2i_DIST_POINT_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DSAparams
#  define d2i_DSAparams OPENSSL_MANGLER(d2i_DSAparams)
# endif
#else
# ifndef _d2i_DSAparams
#  define _d2i_DSAparams OPENSSL_MANGLER_ASM(d2i_DSAparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DSAPrivateKey
#  define d2i_DSAPrivateKey OPENSSL_MANGLER(d2i_DSAPrivateKey)
# endif
#else
# ifndef _d2i_DSAPrivateKey
#  define _d2i_DSAPrivateKey OPENSSL_MANGLER_ASM(d2i_DSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DSAPrivateKey_bio
#  define d2i_DSAPrivateKey_bio OPENSSL_MANGLER(d2i_DSAPrivateKey_bio)
# endif
#else
# ifndef _d2i_DSAPrivateKey_bio
#  define _d2i_DSAPrivateKey_bio OPENSSL_MANGLER_ASM(d2i_DSAPrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DSAPrivateKey_fp
#  define d2i_DSAPrivateKey_fp OPENSSL_MANGLER(d2i_DSAPrivateKey_fp)
# endif
#else
# ifndef _d2i_DSAPrivateKey_fp
#  define _d2i_DSAPrivateKey_fp OPENSSL_MANGLER_ASM(d2i_DSAPrivateKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DSA_PUBKEY
#  define d2i_DSA_PUBKEY OPENSSL_MANGLER(d2i_DSA_PUBKEY)
# endif
#else
# ifndef _d2i_DSA_PUBKEY
#  define _d2i_DSA_PUBKEY OPENSSL_MANGLER_ASM(d2i_DSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DSA_PUBKEY_bio
#  define d2i_DSA_PUBKEY_bio OPENSSL_MANGLER(d2i_DSA_PUBKEY_bio)
# endif
#else
# ifndef _d2i_DSA_PUBKEY_bio
#  define _d2i_DSA_PUBKEY_bio OPENSSL_MANGLER_ASM(d2i_DSA_PUBKEY_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DSA_PUBKEY_fp
#  define d2i_DSA_PUBKEY_fp OPENSSL_MANGLER(d2i_DSA_PUBKEY_fp)
# endif
#else
# ifndef _d2i_DSA_PUBKEY_fp
#  define _d2i_DSA_PUBKEY_fp OPENSSL_MANGLER_ASM(d2i_DSA_PUBKEY_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DSAPublicKey
#  define d2i_DSAPublicKey OPENSSL_MANGLER(d2i_DSAPublicKey)
# endif
#else
# ifndef _d2i_DSAPublicKey
#  define _d2i_DSAPublicKey OPENSSL_MANGLER_ASM(d2i_DSAPublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_DSA_SIG
#  define d2i_DSA_SIG OPENSSL_MANGLER(d2i_DSA_SIG)
# endif
#else
# ifndef _d2i_DSA_SIG
#  define _d2i_DSA_SIG OPENSSL_MANGLER_ASM(d2i_DSA_SIG)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ECDSA_SIG
#  define d2i_ECDSA_SIG OPENSSL_MANGLER(d2i_ECDSA_SIG)
# endif
#else
# ifndef _d2i_ECDSA_SIG
#  define _d2i_ECDSA_SIG OPENSSL_MANGLER_ASM(d2i_ECDSA_SIG)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ECParameters
#  define d2i_ECParameters OPENSSL_MANGLER(d2i_ECParameters)
# endif
#else
# ifndef _d2i_ECParameters
#  define _d2i_ECParameters OPENSSL_MANGLER_ASM(d2i_ECParameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ECPKParameters
#  define d2i_ECPKParameters OPENSSL_MANGLER(d2i_ECPKParameters)
# endif
#else
# ifndef _d2i_ECPKParameters
#  define _d2i_ECPKParameters OPENSSL_MANGLER_ASM(d2i_ECPKParameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ECPKPARAMETERS
#  define d2i_ECPKPARAMETERS OPENSSL_MANGLER(d2i_ECPKPARAMETERS)
# endif
#else
# ifndef _d2i_ECPKPARAMETERS
#  define _d2i_ECPKPARAMETERS OPENSSL_MANGLER_ASM(d2i_ECPKPARAMETERS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ECPrivateKey
#  define d2i_ECPrivateKey OPENSSL_MANGLER(d2i_ECPrivateKey)
# endif
#else
# ifndef _d2i_ECPrivateKey
#  define _d2i_ECPrivateKey OPENSSL_MANGLER_ASM(d2i_ECPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_EC_PRIVATEKEY
#  define d2i_EC_PRIVATEKEY OPENSSL_MANGLER(d2i_EC_PRIVATEKEY)
# endif
#else
# ifndef _d2i_EC_PRIVATEKEY
#  define _d2i_EC_PRIVATEKEY OPENSSL_MANGLER_ASM(d2i_EC_PRIVATEKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ECPrivateKey_bio
#  define d2i_ECPrivateKey_bio OPENSSL_MANGLER(d2i_ECPrivateKey_bio)
# endif
#else
# ifndef _d2i_ECPrivateKey_bio
#  define _d2i_ECPrivateKey_bio OPENSSL_MANGLER_ASM(d2i_ECPrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ECPrivateKey_fp
#  define d2i_ECPrivateKey_fp OPENSSL_MANGLER(d2i_ECPrivateKey_fp)
# endif
#else
# ifndef _d2i_ECPrivateKey_fp
#  define _d2i_ECPrivateKey_fp OPENSSL_MANGLER_ASM(d2i_ECPrivateKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_EC_PUBKEY
#  define d2i_EC_PUBKEY OPENSSL_MANGLER(d2i_EC_PUBKEY)
# endif
#else
# ifndef _d2i_EC_PUBKEY
#  define _d2i_EC_PUBKEY OPENSSL_MANGLER_ASM(d2i_EC_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_EC_PUBKEY_bio
#  define d2i_EC_PUBKEY_bio OPENSSL_MANGLER(d2i_EC_PUBKEY_bio)
# endif
#else
# ifndef _d2i_EC_PUBKEY_bio
#  define _d2i_EC_PUBKEY_bio OPENSSL_MANGLER_ASM(d2i_EC_PUBKEY_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_EC_PUBKEY_fp
#  define d2i_EC_PUBKEY_fp OPENSSL_MANGLER(d2i_EC_PUBKEY_fp)
# endif
#else
# ifndef _d2i_EC_PUBKEY_fp
#  define _d2i_EC_PUBKEY_fp OPENSSL_MANGLER_ASM(d2i_EC_PUBKEY_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_EDIPARTYNAME
#  define d2i_EDIPARTYNAME OPENSSL_MANGLER(d2i_EDIPARTYNAME)
# endif
#else
# ifndef _d2i_EDIPARTYNAME
#  define _d2i_EDIPARTYNAME OPENSSL_MANGLER_ASM(d2i_EDIPARTYNAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ESS_CERT_ID
#  define d2i_ESS_CERT_ID OPENSSL_MANGLER(d2i_ESS_CERT_ID)
# endif
#else
# ifndef _d2i_ESS_CERT_ID
#  define _d2i_ESS_CERT_ID OPENSSL_MANGLER_ASM(d2i_ESS_CERT_ID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ESS_CERT_ID_V2
#  define d2i_ESS_CERT_ID_V2 OPENSSL_MANGLER(d2i_ESS_CERT_ID_V2)
# endif
#else
# ifndef _d2i_ESS_CERT_ID_V2
#  define _d2i_ESS_CERT_ID_V2 OPENSSL_MANGLER_ASM(d2i_ESS_CERT_ID_V2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ESS_ISSUER_SERIAL
#  define d2i_ESS_ISSUER_SERIAL OPENSSL_MANGLER(d2i_ESS_ISSUER_SERIAL)
# endif
#else
# ifndef _d2i_ESS_ISSUER_SERIAL
#  define _d2i_ESS_ISSUER_SERIAL OPENSSL_MANGLER_ASM(d2i_ESS_ISSUER_SERIAL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ESS_SIGNING_CERT
#  define d2i_ESS_SIGNING_CERT OPENSSL_MANGLER(d2i_ESS_SIGNING_CERT)
# endif
#else
# ifndef _d2i_ESS_SIGNING_CERT
#  define _d2i_ESS_SIGNING_CERT OPENSSL_MANGLER_ASM(d2i_ESS_SIGNING_CERT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ESS_SIGNING_CERT_V2
#  define d2i_ESS_SIGNING_CERT_V2 OPENSSL_MANGLER(d2i_ESS_SIGNING_CERT_V2)
# endif
#else
# ifndef _d2i_ESS_SIGNING_CERT_V2
#  define _d2i_ESS_SIGNING_CERT_V2 OPENSSL_MANGLER_ASM(d2i_ESS_SIGNING_CERT_V2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_EXTENDED_KEY_USAGE
#  define d2i_EXTENDED_KEY_USAGE OPENSSL_MANGLER(d2i_EXTENDED_KEY_USAGE)
# endif
#else
# ifndef _d2i_EXTENDED_KEY_USAGE
#  define _d2i_EXTENDED_KEY_USAGE OPENSSL_MANGLER_ASM(d2i_EXTENDED_KEY_USAGE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_GENERAL_NAME
#  define d2i_GENERAL_NAME OPENSSL_MANGLER(d2i_GENERAL_NAME)
# endif
#else
# ifndef _d2i_GENERAL_NAME
#  define _d2i_GENERAL_NAME OPENSSL_MANGLER_ASM(d2i_GENERAL_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_GENERAL_NAMES
#  define d2i_GENERAL_NAMES OPENSSL_MANGLER(d2i_GENERAL_NAMES)
# endif
#else
# ifndef _d2i_GENERAL_NAMES
#  define _d2i_GENERAL_NAMES OPENSSL_MANGLER_ASM(d2i_GENERAL_NAMES)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_int_dhx
#  define d2i_int_dhx OPENSSL_MANGLER(d2i_int_dhx)
# endif
#else
# ifndef _d2i_int_dhx
#  define _d2i_int_dhx OPENSSL_MANGLER_ASM(d2i_int_dhx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_IPAddressChoice
#  define d2i_IPAddressChoice OPENSSL_MANGLER(d2i_IPAddressChoice)
# endif
#else
# ifndef _d2i_IPAddressChoice
#  define _d2i_IPAddressChoice OPENSSL_MANGLER_ASM(d2i_IPAddressChoice)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_IPAddressFamily
#  define d2i_IPAddressFamily OPENSSL_MANGLER(d2i_IPAddressFamily)
# endif
#else
# ifndef _d2i_IPAddressFamily
#  define _d2i_IPAddressFamily OPENSSL_MANGLER_ASM(d2i_IPAddressFamily)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_IPAddressOrRange
#  define d2i_IPAddressOrRange OPENSSL_MANGLER(d2i_IPAddressOrRange)
# endif
#else
# ifndef _d2i_IPAddressOrRange
#  define _d2i_IPAddressOrRange OPENSSL_MANGLER_ASM(d2i_IPAddressOrRange)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_IPAddressRange
#  define d2i_IPAddressRange OPENSSL_MANGLER(d2i_IPAddressRange)
# endif
#else
# ifndef _d2i_IPAddressRange
#  define _d2i_IPAddressRange OPENSSL_MANGLER_ASM(d2i_IPAddressRange)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_ISSUING_DIST_POINT
#  define d2i_ISSUING_DIST_POINT OPENSSL_MANGLER(d2i_ISSUING_DIST_POINT)
# endif
#else
# ifndef _d2i_ISSUING_DIST_POINT
#  define _d2i_ISSUING_DIST_POINT OPENSSL_MANGLER_ASM(d2i_ISSUING_DIST_POINT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_NAMING_AUTHORITY
#  define d2i_NAMING_AUTHORITY OPENSSL_MANGLER(d2i_NAMING_AUTHORITY)
# endif
#else
# ifndef _d2i_NAMING_AUTHORITY
#  define _d2i_NAMING_AUTHORITY OPENSSL_MANGLER_ASM(d2i_NAMING_AUTHORITY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_NETSCAPE_CERT_SEQUENCE
#  define d2i_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER(d2i_NETSCAPE_CERT_SEQUENCE)
# endif
#else
# ifndef _d2i_NETSCAPE_CERT_SEQUENCE
#  define _d2i_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER_ASM(d2i_NETSCAPE_CERT_SEQUENCE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_NETSCAPE_ENCRYPTED_PKEY
#  define d2i_NETSCAPE_ENCRYPTED_PKEY OPENSSL_MANGLER(d2i_NETSCAPE_ENCRYPTED_PKEY)
# endif
#else
# ifndef _d2i_NETSCAPE_ENCRYPTED_PKEY
#  define _d2i_NETSCAPE_ENCRYPTED_PKEY OPENSSL_MANGLER_ASM(d2i_NETSCAPE_ENCRYPTED_PKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_NETSCAPE_PKEY
#  define d2i_NETSCAPE_PKEY OPENSSL_MANGLER(d2i_NETSCAPE_PKEY)
# endif
#else
# ifndef _d2i_NETSCAPE_PKEY
#  define _d2i_NETSCAPE_PKEY OPENSSL_MANGLER_ASM(d2i_NETSCAPE_PKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_NETSCAPE_SPKAC
#  define d2i_NETSCAPE_SPKAC OPENSSL_MANGLER(d2i_NETSCAPE_SPKAC)
# endif
#else
# ifndef _d2i_NETSCAPE_SPKAC
#  define _d2i_NETSCAPE_SPKAC OPENSSL_MANGLER_ASM(d2i_NETSCAPE_SPKAC)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_NETSCAPE_SPKI
#  define d2i_NETSCAPE_SPKI OPENSSL_MANGLER(d2i_NETSCAPE_SPKI)
# endif
#else
# ifndef _d2i_NETSCAPE_SPKI
#  define _d2i_NETSCAPE_SPKI OPENSSL_MANGLER_ASM(d2i_NETSCAPE_SPKI)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_NOTICEREF
#  define d2i_NOTICEREF OPENSSL_MANGLER(d2i_NOTICEREF)
# endif
#else
# ifndef _d2i_NOTICEREF
#  define _d2i_NOTICEREF OPENSSL_MANGLER_ASM(d2i_NOTICEREF)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_BASICRESP
#  define d2i_OCSP_BASICRESP OPENSSL_MANGLER(d2i_OCSP_BASICRESP)
# endif
#else
# ifndef _d2i_OCSP_BASICRESP
#  define _d2i_OCSP_BASICRESP OPENSSL_MANGLER_ASM(d2i_OCSP_BASICRESP)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_CERTID
#  define d2i_OCSP_CERTID OPENSSL_MANGLER(d2i_OCSP_CERTID)
# endif
#else
# ifndef _d2i_OCSP_CERTID
#  define _d2i_OCSP_CERTID OPENSSL_MANGLER_ASM(d2i_OCSP_CERTID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_CERTSTATUS
#  define d2i_OCSP_CERTSTATUS OPENSSL_MANGLER(d2i_OCSP_CERTSTATUS)
# endif
#else
# ifndef _d2i_OCSP_CERTSTATUS
#  define _d2i_OCSP_CERTSTATUS OPENSSL_MANGLER_ASM(d2i_OCSP_CERTSTATUS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_CRLID
#  define d2i_OCSP_CRLID OPENSSL_MANGLER(d2i_OCSP_CRLID)
# endif
#else
# ifndef _d2i_OCSP_CRLID
#  define _d2i_OCSP_CRLID OPENSSL_MANGLER_ASM(d2i_OCSP_CRLID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_ONEREQ
#  define d2i_OCSP_ONEREQ OPENSSL_MANGLER(d2i_OCSP_ONEREQ)
# endif
#else
# ifndef _d2i_OCSP_ONEREQ
#  define _d2i_OCSP_ONEREQ OPENSSL_MANGLER_ASM(d2i_OCSP_ONEREQ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_REQINFO
#  define d2i_OCSP_REQINFO OPENSSL_MANGLER(d2i_OCSP_REQINFO)
# endif
#else
# ifndef _d2i_OCSP_REQINFO
#  define _d2i_OCSP_REQINFO OPENSSL_MANGLER_ASM(d2i_OCSP_REQINFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_REQUEST
#  define d2i_OCSP_REQUEST OPENSSL_MANGLER(d2i_OCSP_REQUEST)
# endif
#else
# ifndef _d2i_OCSP_REQUEST
#  define _d2i_OCSP_REQUEST OPENSSL_MANGLER_ASM(d2i_OCSP_REQUEST)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_RESPBYTES
#  define d2i_OCSP_RESPBYTES OPENSSL_MANGLER(d2i_OCSP_RESPBYTES)
# endif
#else
# ifndef _d2i_OCSP_RESPBYTES
#  define _d2i_OCSP_RESPBYTES OPENSSL_MANGLER_ASM(d2i_OCSP_RESPBYTES)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_RESPDATA
#  define d2i_OCSP_RESPDATA OPENSSL_MANGLER(d2i_OCSP_RESPDATA)
# endif
#else
# ifndef _d2i_OCSP_RESPDATA
#  define _d2i_OCSP_RESPDATA OPENSSL_MANGLER_ASM(d2i_OCSP_RESPDATA)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_RESPID
#  define d2i_OCSP_RESPID OPENSSL_MANGLER(d2i_OCSP_RESPID)
# endif
#else
# ifndef _d2i_OCSP_RESPID
#  define _d2i_OCSP_RESPID OPENSSL_MANGLER_ASM(d2i_OCSP_RESPID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_RESPONSE
#  define d2i_OCSP_RESPONSE OPENSSL_MANGLER(d2i_OCSP_RESPONSE)
# endif
#else
# ifndef _d2i_OCSP_RESPONSE
#  define _d2i_OCSP_RESPONSE OPENSSL_MANGLER_ASM(d2i_OCSP_RESPONSE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_REVOKEDINFO
#  define d2i_OCSP_REVOKEDINFO OPENSSL_MANGLER(d2i_OCSP_REVOKEDINFO)
# endif
#else
# ifndef _d2i_OCSP_REVOKEDINFO
#  define _d2i_OCSP_REVOKEDINFO OPENSSL_MANGLER_ASM(d2i_OCSP_REVOKEDINFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_SERVICELOC
#  define d2i_OCSP_SERVICELOC OPENSSL_MANGLER(d2i_OCSP_SERVICELOC)
# endif
#else
# ifndef _d2i_OCSP_SERVICELOC
#  define _d2i_OCSP_SERVICELOC OPENSSL_MANGLER_ASM(d2i_OCSP_SERVICELOC)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_SIGNATURE
#  define d2i_OCSP_SIGNATURE OPENSSL_MANGLER(d2i_OCSP_SIGNATURE)
# endif
#else
# ifndef _d2i_OCSP_SIGNATURE
#  define _d2i_OCSP_SIGNATURE OPENSSL_MANGLER_ASM(d2i_OCSP_SIGNATURE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OCSP_SINGLERESP
#  define d2i_OCSP_SINGLERESP OPENSSL_MANGLER(d2i_OCSP_SINGLERESP)
# endif
#else
# ifndef _d2i_OCSP_SINGLERESP
#  define _d2i_OCSP_SINGLERESP OPENSSL_MANGLER_ASM(d2i_OCSP_SINGLERESP)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_OTHERNAME
#  define d2i_OTHERNAME OPENSSL_MANGLER(d2i_OTHERNAME)
# endif
#else
# ifndef _d2i_OTHERNAME
#  define _d2i_OTHERNAME OPENSSL_MANGLER_ASM(d2i_OTHERNAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PBE2PARAM
#  define d2i_PBE2PARAM OPENSSL_MANGLER(d2i_PBE2PARAM)
# endif
#else
# ifndef _d2i_PBE2PARAM
#  define _d2i_PBE2PARAM OPENSSL_MANGLER_ASM(d2i_PBE2PARAM)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PBEPARAM
#  define d2i_PBEPARAM OPENSSL_MANGLER(d2i_PBEPARAM)
# endif
#else
# ifndef _d2i_PBEPARAM
#  define _d2i_PBEPARAM OPENSSL_MANGLER_ASM(d2i_PBEPARAM)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PBKDF2PARAM
#  define d2i_PBKDF2PARAM OPENSSL_MANGLER(d2i_PBKDF2PARAM)
# endif
#else
# ifndef _d2i_PBKDF2PARAM
#  define _d2i_PBKDF2PARAM OPENSSL_MANGLER_ASM(d2i_PBKDF2PARAM)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS12
#  define d2i_PKCS12 OPENSSL_MANGLER(d2i_PKCS12)
# endif
#else
# ifndef _d2i_PKCS12
#  define _d2i_PKCS12 OPENSSL_MANGLER_ASM(d2i_PKCS12)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS12_BAGS
#  define d2i_PKCS12_BAGS OPENSSL_MANGLER(d2i_PKCS12_BAGS)
# endif
#else
# ifndef _d2i_PKCS12_BAGS
#  define _d2i_PKCS12_BAGS OPENSSL_MANGLER_ASM(d2i_PKCS12_BAGS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS12_bio
#  define d2i_PKCS12_bio OPENSSL_MANGLER(d2i_PKCS12_bio)
# endif
#else
# ifndef _d2i_PKCS12_bio
#  define _d2i_PKCS12_bio OPENSSL_MANGLER_ASM(d2i_PKCS12_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS12_fp
#  define d2i_PKCS12_fp OPENSSL_MANGLER(d2i_PKCS12_fp)
# endif
#else
# ifndef _d2i_PKCS12_fp
#  define _d2i_PKCS12_fp OPENSSL_MANGLER_ASM(d2i_PKCS12_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS12_MAC_DATA
#  define d2i_PKCS12_MAC_DATA OPENSSL_MANGLER(d2i_PKCS12_MAC_DATA)
# endif
#else
# ifndef _d2i_PKCS12_MAC_DATA
#  define _d2i_PKCS12_MAC_DATA OPENSSL_MANGLER_ASM(d2i_PKCS12_MAC_DATA)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS12_SAFEBAG
#  define d2i_PKCS12_SAFEBAG OPENSSL_MANGLER(d2i_PKCS12_SAFEBAG)
# endif
#else
# ifndef _d2i_PKCS12_SAFEBAG
#  define _d2i_PKCS12_SAFEBAG OPENSSL_MANGLER_ASM(d2i_PKCS12_SAFEBAG)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7
#  define d2i_PKCS7 OPENSSL_MANGLER(d2i_PKCS7)
# endif
#else
# ifndef _d2i_PKCS7
#  define _d2i_PKCS7 OPENSSL_MANGLER_ASM(d2i_PKCS7)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_bio
#  define d2i_PKCS7_bio OPENSSL_MANGLER(d2i_PKCS7_bio)
# endif
#else
# ifndef _d2i_PKCS7_bio
#  define _d2i_PKCS7_bio OPENSSL_MANGLER_ASM(d2i_PKCS7_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_DIGEST
#  define d2i_PKCS7_DIGEST OPENSSL_MANGLER(d2i_PKCS7_DIGEST)
# endif
#else
# ifndef _d2i_PKCS7_DIGEST
#  define _d2i_PKCS7_DIGEST OPENSSL_MANGLER_ASM(d2i_PKCS7_DIGEST)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_ENC_CONTENT
#  define d2i_PKCS7_ENC_CONTENT OPENSSL_MANGLER(d2i_PKCS7_ENC_CONTENT)
# endif
#else
# ifndef _d2i_PKCS7_ENC_CONTENT
#  define _d2i_PKCS7_ENC_CONTENT OPENSSL_MANGLER_ASM(d2i_PKCS7_ENC_CONTENT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_ENCRYPT
#  define d2i_PKCS7_ENCRYPT OPENSSL_MANGLER(d2i_PKCS7_ENCRYPT)
# endif
#else
# ifndef _d2i_PKCS7_ENCRYPT
#  define _d2i_PKCS7_ENCRYPT OPENSSL_MANGLER_ASM(d2i_PKCS7_ENCRYPT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_ENVELOPE
#  define d2i_PKCS7_ENVELOPE OPENSSL_MANGLER(d2i_PKCS7_ENVELOPE)
# endif
#else
# ifndef _d2i_PKCS7_ENVELOPE
#  define _d2i_PKCS7_ENVELOPE OPENSSL_MANGLER_ASM(d2i_PKCS7_ENVELOPE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_fp
#  define d2i_PKCS7_fp OPENSSL_MANGLER(d2i_PKCS7_fp)
# endif
#else
# ifndef _d2i_PKCS7_fp
#  define _d2i_PKCS7_fp OPENSSL_MANGLER_ASM(d2i_PKCS7_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_ISSUER_AND_SERIAL
#  define d2i_PKCS7_ISSUER_AND_SERIAL OPENSSL_MANGLER(d2i_PKCS7_ISSUER_AND_SERIAL)
# endif
#else
# ifndef _d2i_PKCS7_ISSUER_AND_SERIAL
#  define _d2i_PKCS7_ISSUER_AND_SERIAL OPENSSL_MANGLER_ASM(d2i_PKCS7_ISSUER_AND_SERIAL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_RECIP_INFO
#  define d2i_PKCS7_RECIP_INFO OPENSSL_MANGLER(d2i_PKCS7_RECIP_INFO)
# endif
#else
# ifndef _d2i_PKCS7_RECIP_INFO
#  define _d2i_PKCS7_RECIP_INFO OPENSSL_MANGLER_ASM(d2i_PKCS7_RECIP_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_SIGNED
#  define d2i_PKCS7_SIGNED OPENSSL_MANGLER(d2i_PKCS7_SIGNED)
# endif
#else
# ifndef _d2i_PKCS7_SIGNED
#  define _d2i_PKCS7_SIGNED OPENSSL_MANGLER_ASM(d2i_PKCS7_SIGNED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_SIGN_ENVELOPE
#  define d2i_PKCS7_SIGN_ENVELOPE OPENSSL_MANGLER(d2i_PKCS7_SIGN_ENVELOPE)
# endif
#else
# ifndef _d2i_PKCS7_SIGN_ENVELOPE
#  define _d2i_PKCS7_SIGN_ENVELOPE OPENSSL_MANGLER_ASM(d2i_PKCS7_SIGN_ENVELOPE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS7_SIGNER_INFO
#  define d2i_PKCS7_SIGNER_INFO OPENSSL_MANGLER(d2i_PKCS7_SIGNER_INFO)
# endif
#else
# ifndef _d2i_PKCS7_SIGNER_INFO
#  define _d2i_PKCS7_SIGNER_INFO OPENSSL_MANGLER_ASM(d2i_PKCS7_SIGNER_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS8_bio
#  define d2i_PKCS8_bio OPENSSL_MANGLER(d2i_PKCS8_bio)
# endif
#else
# ifndef _d2i_PKCS8_bio
#  define _d2i_PKCS8_bio OPENSSL_MANGLER_ASM(d2i_PKCS8_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS8_fp
#  define d2i_PKCS8_fp OPENSSL_MANGLER(d2i_PKCS8_fp)
# endif
#else
# ifndef _d2i_PKCS8_fp
#  define _d2i_PKCS8_fp OPENSSL_MANGLER_ASM(d2i_PKCS8_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS8PrivateKey_bio
#  define d2i_PKCS8PrivateKey_bio OPENSSL_MANGLER(d2i_PKCS8PrivateKey_bio)
# endif
#else
# ifndef _d2i_PKCS8PrivateKey_bio
#  define _d2i_PKCS8PrivateKey_bio OPENSSL_MANGLER_ASM(d2i_PKCS8PrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS8PrivateKey_fp
#  define d2i_PKCS8PrivateKey_fp OPENSSL_MANGLER(d2i_PKCS8PrivateKey_fp)
# endif
#else
# ifndef _d2i_PKCS8PrivateKey_fp
#  define _d2i_PKCS8PrivateKey_fp OPENSSL_MANGLER_ASM(d2i_PKCS8PrivateKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS8_PRIV_KEY_INFO
#  define d2i_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER(d2i_PKCS8_PRIV_KEY_INFO)
# endif
#else
# ifndef _d2i_PKCS8_PRIV_KEY_INFO
#  define _d2i_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER_ASM(d2i_PKCS8_PRIV_KEY_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS8_PRIV_KEY_INFO_bio
#  define d2i_PKCS8_PRIV_KEY_INFO_bio OPENSSL_MANGLER(d2i_PKCS8_PRIV_KEY_INFO_bio)
# endif
#else
# ifndef _d2i_PKCS8_PRIV_KEY_INFO_bio
#  define _d2i_PKCS8_PRIV_KEY_INFO_bio OPENSSL_MANGLER_ASM(d2i_PKCS8_PRIV_KEY_INFO_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKCS8_PRIV_KEY_INFO_fp
#  define d2i_PKCS8_PRIV_KEY_INFO_fp OPENSSL_MANGLER(d2i_PKCS8_PRIV_KEY_INFO_fp)
# endif
#else
# ifndef _d2i_PKCS8_PRIV_KEY_INFO_fp
#  define _d2i_PKCS8_PRIV_KEY_INFO_fp OPENSSL_MANGLER_ASM(d2i_PKCS8_PRIV_KEY_INFO_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PKEY_USAGE_PERIOD
#  define d2i_PKEY_USAGE_PERIOD OPENSSL_MANGLER(d2i_PKEY_USAGE_PERIOD)
# endif
#else
# ifndef _d2i_PKEY_USAGE_PERIOD
#  define _d2i_PKEY_USAGE_PERIOD OPENSSL_MANGLER_ASM(d2i_PKEY_USAGE_PERIOD)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_POLICYINFO
#  define d2i_POLICYINFO OPENSSL_MANGLER(d2i_POLICYINFO)
# endif
#else
# ifndef _d2i_POLICYINFO
#  define _d2i_POLICYINFO OPENSSL_MANGLER_ASM(d2i_POLICYINFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_POLICYQUALINFO
#  define d2i_POLICYQUALINFO OPENSSL_MANGLER(d2i_POLICYQUALINFO)
# endif
#else
# ifndef _d2i_POLICYQUALINFO
#  define _d2i_POLICYQUALINFO OPENSSL_MANGLER_ASM(d2i_POLICYQUALINFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PrivateKey
#  define d2i_PrivateKey OPENSSL_MANGLER(d2i_PrivateKey)
# endif
#else
# ifndef _d2i_PrivateKey
#  define _d2i_PrivateKey OPENSSL_MANGLER_ASM(d2i_PrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PrivateKey_bio
#  define d2i_PrivateKey_bio OPENSSL_MANGLER(d2i_PrivateKey_bio)
# endif
#else
# ifndef _d2i_PrivateKey_bio
#  define _d2i_PrivateKey_bio OPENSSL_MANGLER_ASM(d2i_PrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PrivateKey_fp
#  define d2i_PrivateKey_fp OPENSSL_MANGLER(d2i_PrivateKey_fp)
# endif
#else
# ifndef _d2i_PrivateKey_fp
#  define _d2i_PrivateKey_fp OPENSSL_MANGLER_ASM(d2i_PrivateKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PROFESSION_INFO
#  define d2i_PROFESSION_INFO OPENSSL_MANGLER(d2i_PROFESSION_INFO)
# endif
#else
# ifndef _d2i_PROFESSION_INFO
#  define _d2i_PROFESSION_INFO OPENSSL_MANGLER_ASM(d2i_PROFESSION_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PROXY_CERT_INFO_EXTENSION
#  define d2i_PROXY_CERT_INFO_EXTENSION OPENSSL_MANGLER(d2i_PROXY_CERT_INFO_EXTENSION)
# endif
#else
# ifndef _d2i_PROXY_CERT_INFO_EXTENSION
#  define _d2i_PROXY_CERT_INFO_EXTENSION OPENSSL_MANGLER_ASM(d2i_PROXY_CERT_INFO_EXTENSION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PROXY_POLICY
#  define d2i_PROXY_POLICY OPENSSL_MANGLER(d2i_PROXY_POLICY)
# endif
#else
# ifndef _d2i_PROXY_POLICY
#  define _d2i_PROXY_POLICY OPENSSL_MANGLER_ASM(d2i_PROXY_POLICY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PUBKEY
#  define d2i_PUBKEY OPENSSL_MANGLER(d2i_PUBKEY)
# endif
#else
# ifndef _d2i_PUBKEY
#  define _d2i_PUBKEY OPENSSL_MANGLER_ASM(d2i_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PUBKEY_bio
#  define d2i_PUBKEY_bio OPENSSL_MANGLER(d2i_PUBKEY_bio)
# endif
#else
# ifndef _d2i_PUBKEY_bio
#  define _d2i_PUBKEY_bio OPENSSL_MANGLER_ASM(d2i_PUBKEY_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PUBKEY_fp
#  define d2i_PUBKEY_fp OPENSSL_MANGLER(d2i_PUBKEY_fp)
# endif
#else
# ifndef _d2i_PUBKEY_fp
#  define _d2i_PUBKEY_fp OPENSSL_MANGLER_ASM(d2i_PUBKEY_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_PublicKey
#  define d2i_PublicKey OPENSSL_MANGLER(d2i_PublicKey)
# endif
#else
# ifndef _d2i_PublicKey
#  define _d2i_PublicKey OPENSSL_MANGLER_ASM(d2i_PublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSA_OAEP_PARAMS
#  define d2i_RSA_OAEP_PARAMS OPENSSL_MANGLER(d2i_RSA_OAEP_PARAMS)
# endif
#else
# ifndef _d2i_RSA_OAEP_PARAMS
#  define _d2i_RSA_OAEP_PARAMS OPENSSL_MANGLER_ASM(d2i_RSA_OAEP_PARAMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSAPrivateKey
#  define d2i_RSAPrivateKey OPENSSL_MANGLER(d2i_RSAPrivateKey)
# endif
#else
# ifndef _d2i_RSAPrivateKey
#  define _d2i_RSAPrivateKey OPENSSL_MANGLER_ASM(d2i_RSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSAPrivateKey_bio
#  define d2i_RSAPrivateKey_bio OPENSSL_MANGLER(d2i_RSAPrivateKey_bio)
# endif
#else
# ifndef _d2i_RSAPrivateKey_bio
#  define _d2i_RSAPrivateKey_bio OPENSSL_MANGLER_ASM(d2i_RSAPrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSAPrivateKey_fp
#  define d2i_RSAPrivateKey_fp OPENSSL_MANGLER(d2i_RSAPrivateKey_fp)
# endif
#else
# ifndef _d2i_RSAPrivateKey_fp
#  define _d2i_RSAPrivateKey_fp OPENSSL_MANGLER_ASM(d2i_RSAPrivateKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSA_PSS_PARAMS
#  define d2i_RSA_PSS_PARAMS OPENSSL_MANGLER(d2i_RSA_PSS_PARAMS)
# endif
#else
# ifndef _d2i_RSA_PSS_PARAMS
#  define _d2i_RSA_PSS_PARAMS OPENSSL_MANGLER_ASM(d2i_RSA_PSS_PARAMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSA_PUBKEY
#  define d2i_RSA_PUBKEY OPENSSL_MANGLER(d2i_RSA_PUBKEY)
# endif
#else
# ifndef _d2i_RSA_PUBKEY
#  define _d2i_RSA_PUBKEY OPENSSL_MANGLER_ASM(d2i_RSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSA_PUBKEY_bio
#  define d2i_RSA_PUBKEY_bio OPENSSL_MANGLER(d2i_RSA_PUBKEY_bio)
# endif
#else
# ifndef _d2i_RSA_PUBKEY_bio
#  define _d2i_RSA_PUBKEY_bio OPENSSL_MANGLER_ASM(d2i_RSA_PUBKEY_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSA_PUBKEY_fp
#  define d2i_RSA_PUBKEY_fp OPENSSL_MANGLER(d2i_RSA_PUBKEY_fp)
# endif
#else
# ifndef _d2i_RSA_PUBKEY_fp
#  define _d2i_RSA_PUBKEY_fp OPENSSL_MANGLER_ASM(d2i_RSA_PUBKEY_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSAPublicKey
#  define d2i_RSAPublicKey OPENSSL_MANGLER(d2i_RSAPublicKey)
# endif
#else
# ifndef _d2i_RSAPublicKey
#  define _d2i_RSAPublicKey OPENSSL_MANGLER_ASM(d2i_RSAPublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSAPublicKey_bio
#  define d2i_RSAPublicKey_bio OPENSSL_MANGLER(d2i_RSAPublicKey_bio)
# endif
#else
# ifndef _d2i_RSAPublicKey_bio
#  define _d2i_RSAPublicKey_bio OPENSSL_MANGLER_ASM(d2i_RSAPublicKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_RSAPublicKey_fp
#  define d2i_RSAPublicKey_fp OPENSSL_MANGLER(d2i_RSAPublicKey_fp)
# endif
#else
# ifndef _d2i_RSAPublicKey_fp
#  define _d2i_RSAPublicKey_fp OPENSSL_MANGLER_ASM(d2i_RSAPublicKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_SCRYPT_PARAMS
#  define d2i_SCRYPT_PARAMS OPENSSL_MANGLER(d2i_SCRYPT_PARAMS)
# endif
#else
# ifndef _d2i_SCRYPT_PARAMS
#  define _d2i_SCRYPT_PARAMS OPENSSL_MANGLER_ASM(d2i_SCRYPT_PARAMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_SCT_LIST
#  define d2i_SCT_LIST OPENSSL_MANGLER(d2i_SCT_LIST)
# endif
#else
# ifndef _d2i_SCT_LIST
#  define _d2i_SCT_LIST OPENSSL_MANGLER_ASM(d2i_SCT_LIST)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_SM2_Ciphertext
#  define d2i_SM2_Ciphertext OPENSSL_MANGLER(d2i_SM2_Ciphertext)
# endif
#else
# ifndef _d2i_SM2_Ciphertext
#  define _d2i_SM2_Ciphertext OPENSSL_MANGLER_ASM(d2i_SM2_Ciphertext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_SSL_SESSION
#  define d2i_SSL_SESSION OPENSSL_MANGLER(d2i_SSL_SESSION)
# endif
#else
# ifndef _d2i_SSL_SESSION
#  define _d2i_SSL_SESSION OPENSSL_MANGLER_ASM(d2i_SSL_SESSION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_SXNET
#  define d2i_SXNET OPENSSL_MANGLER(d2i_SXNET)
# endif
#else
# ifndef _d2i_SXNET
#  define _d2i_SXNET OPENSSL_MANGLER_ASM(d2i_SXNET)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_SXNETID
#  define d2i_SXNETID OPENSSL_MANGLER(d2i_SXNETID)
# endif
#else
# ifndef _d2i_SXNETID
#  define _d2i_SXNETID OPENSSL_MANGLER_ASM(d2i_SXNETID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_ACCURACY
#  define d2i_TS_ACCURACY OPENSSL_MANGLER(d2i_TS_ACCURACY)
# endif
#else
# ifndef _d2i_TS_ACCURACY
#  define _d2i_TS_ACCURACY OPENSSL_MANGLER_ASM(d2i_TS_ACCURACY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_MSG_IMPRINT
#  define d2i_TS_MSG_IMPRINT OPENSSL_MANGLER(d2i_TS_MSG_IMPRINT)
# endif
#else
# ifndef _d2i_TS_MSG_IMPRINT
#  define _d2i_TS_MSG_IMPRINT OPENSSL_MANGLER_ASM(d2i_TS_MSG_IMPRINT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_MSG_IMPRINT_bio
#  define d2i_TS_MSG_IMPRINT_bio OPENSSL_MANGLER(d2i_TS_MSG_IMPRINT_bio)
# endif
#else
# ifndef _d2i_TS_MSG_IMPRINT_bio
#  define _d2i_TS_MSG_IMPRINT_bio OPENSSL_MANGLER_ASM(d2i_TS_MSG_IMPRINT_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_MSG_IMPRINT_fp
#  define d2i_TS_MSG_IMPRINT_fp OPENSSL_MANGLER(d2i_TS_MSG_IMPRINT_fp)
# endif
#else
# ifndef _d2i_TS_MSG_IMPRINT_fp
#  define _d2i_TS_MSG_IMPRINT_fp OPENSSL_MANGLER_ASM(d2i_TS_MSG_IMPRINT_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_REQ
#  define d2i_TS_REQ OPENSSL_MANGLER(d2i_TS_REQ)
# endif
#else
# ifndef _d2i_TS_REQ
#  define _d2i_TS_REQ OPENSSL_MANGLER_ASM(d2i_TS_REQ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_REQ_bio
#  define d2i_TS_REQ_bio OPENSSL_MANGLER(d2i_TS_REQ_bio)
# endif
#else
# ifndef _d2i_TS_REQ_bio
#  define _d2i_TS_REQ_bio OPENSSL_MANGLER_ASM(d2i_TS_REQ_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_REQ_fp
#  define d2i_TS_REQ_fp OPENSSL_MANGLER(d2i_TS_REQ_fp)
# endif
#else
# ifndef _d2i_TS_REQ_fp
#  define _d2i_TS_REQ_fp OPENSSL_MANGLER_ASM(d2i_TS_REQ_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_RESP
#  define d2i_TS_RESP OPENSSL_MANGLER(d2i_TS_RESP)
# endif
#else
# ifndef _d2i_TS_RESP
#  define _d2i_TS_RESP OPENSSL_MANGLER_ASM(d2i_TS_RESP)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_RESP_bio
#  define d2i_TS_RESP_bio OPENSSL_MANGLER(d2i_TS_RESP_bio)
# endif
#else
# ifndef _d2i_TS_RESP_bio
#  define _d2i_TS_RESP_bio OPENSSL_MANGLER_ASM(d2i_TS_RESP_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_RESP_fp
#  define d2i_TS_RESP_fp OPENSSL_MANGLER(d2i_TS_RESP_fp)
# endif
#else
# ifndef _d2i_TS_RESP_fp
#  define _d2i_TS_RESP_fp OPENSSL_MANGLER_ASM(d2i_TS_RESP_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_STATUS_INFO
#  define d2i_TS_STATUS_INFO OPENSSL_MANGLER(d2i_TS_STATUS_INFO)
# endif
#else
# ifndef _d2i_TS_STATUS_INFO
#  define _d2i_TS_STATUS_INFO OPENSSL_MANGLER_ASM(d2i_TS_STATUS_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_TST_INFO
#  define d2i_TS_TST_INFO OPENSSL_MANGLER(d2i_TS_TST_INFO)
# endif
#else
# ifndef _d2i_TS_TST_INFO
#  define _d2i_TS_TST_INFO OPENSSL_MANGLER_ASM(d2i_TS_TST_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_TST_INFO_bio
#  define d2i_TS_TST_INFO_bio OPENSSL_MANGLER(d2i_TS_TST_INFO_bio)
# endif
#else
# ifndef _d2i_TS_TST_INFO_bio
#  define _d2i_TS_TST_INFO_bio OPENSSL_MANGLER_ASM(d2i_TS_TST_INFO_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_TS_TST_INFO_fp
#  define d2i_TS_TST_INFO_fp OPENSSL_MANGLER(d2i_TS_TST_INFO_fp)
# endif
#else
# ifndef _d2i_TS_TST_INFO_fp
#  define _d2i_TS_TST_INFO_fp OPENSSL_MANGLER_ASM(d2i_TS_TST_INFO_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_USERNOTICE
#  define d2i_USERNOTICE OPENSSL_MANGLER(d2i_USERNOTICE)
# endif
#else
# ifndef _d2i_USERNOTICE
#  define _d2i_USERNOTICE OPENSSL_MANGLER_ASM(d2i_USERNOTICE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509
#  define d2i_X509 OPENSSL_MANGLER(d2i_X509)
# endif
#else
# ifndef _d2i_X509
#  define _d2i_X509 OPENSSL_MANGLER_ASM(d2i_X509)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_ALGOR
#  define d2i_X509_ALGOR OPENSSL_MANGLER(d2i_X509_ALGOR)
# endif
#else
# ifndef _d2i_X509_ALGOR
#  define _d2i_X509_ALGOR OPENSSL_MANGLER_ASM(d2i_X509_ALGOR)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_ALGORS
#  define d2i_X509_ALGORS OPENSSL_MANGLER(d2i_X509_ALGORS)
# endif
#else
# ifndef _d2i_X509_ALGORS
#  define _d2i_X509_ALGORS OPENSSL_MANGLER_ASM(d2i_X509_ALGORS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_ATTRIBUTE
#  define d2i_X509_ATTRIBUTE OPENSSL_MANGLER(d2i_X509_ATTRIBUTE)
# endif
#else
# ifndef _d2i_X509_ATTRIBUTE
#  define _d2i_X509_ATTRIBUTE OPENSSL_MANGLER_ASM(d2i_X509_ATTRIBUTE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_AUX
#  define d2i_X509_AUX OPENSSL_MANGLER(d2i_X509_AUX)
# endif
#else
# ifndef _d2i_X509_AUX
#  define _d2i_X509_AUX OPENSSL_MANGLER_ASM(d2i_X509_AUX)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_bio
#  define d2i_X509_bio OPENSSL_MANGLER(d2i_X509_bio)
# endif
#else
# ifndef _d2i_X509_bio
#  define _d2i_X509_bio OPENSSL_MANGLER_ASM(d2i_X509_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_CERT_AUX
#  define d2i_X509_CERT_AUX OPENSSL_MANGLER(d2i_X509_CERT_AUX)
# endif
#else
# ifndef _d2i_X509_CERT_AUX
#  define _d2i_X509_CERT_AUX OPENSSL_MANGLER_ASM(d2i_X509_CERT_AUX)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_CINF
#  define d2i_X509_CINF OPENSSL_MANGLER(d2i_X509_CINF)
# endif
#else
# ifndef _d2i_X509_CINF
#  define _d2i_X509_CINF OPENSSL_MANGLER_ASM(d2i_X509_CINF)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_CRL
#  define d2i_X509_CRL OPENSSL_MANGLER(d2i_X509_CRL)
# endif
#else
# ifndef _d2i_X509_CRL
#  define _d2i_X509_CRL OPENSSL_MANGLER_ASM(d2i_X509_CRL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_CRL_bio
#  define d2i_X509_CRL_bio OPENSSL_MANGLER(d2i_X509_CRL_bio)
# endif
#else
# ifndef _d2i_X509_CRL_bio
#  define _d2i_X509_CRL_bio OPENSSL_MANGLER_ASM(d2i_X509_CRL_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_CRL_fp
#  define d2i_X509_CRL_fp OPENSSL_MANGLER(d2i_X509_CRL_fp)
# endif
#else
# ifndef _d2i_X509_CRL_fp
#  define _d2i_X509_CRL_fp OPENSSL_MANGLER_ASM(d2i_X509_CRL_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_CRL_INFO
#  define d2i_X509_CRL_INFO OPENSSL_MANGLER(d2i_X509_CRL_INFO)
# endif
#else
# ifndef _d2i_X509_CRL_INFO
#  define _d2i_X509_CRL_INFO OPENSSL_MANGLER_ASM(d2i_X509_CRL_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_EXTENSION
#  define d2i_X509_EXTENSION OPENSSL_MANGLER(d2i_X509_EXTENSION)
# endif
#else
# ifndef _d2i_X509_EXTENSION
#  define _d2i_X509_EXTENSION OPENSSL_MANGLER_ASM(d2i_X509_EXTENSION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_EXTENSIONS
#  define d2i_X509_EXTENSIONS OPENSSL_MANGLER(d2i_X509_EXTENSIONS)
# endif
#else
# ifndef _d2i_X509_EXTENSIONS
#  define _d2i_X509_EXTENSIONS OPENSSL_MANGLER_ASM(d2i_X509_EXTENSIONS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_fp
#  define d2i_X509_fp OPENSSL_MANGLER(d2i_X509_fp)
# endif
#else
# ifndef _d2i_X509_fp
#  define _d2i_X509_fp OPENSSL_MANGLER_ASM(d2i_X509_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_NAME
#  define d2i_X509_NAME OPENSSL_MANGLER(d2i_X509_NAME)
# endif
#else
# ifndef _d2i_X509_NAME
#  define _d2i_X509_NAME OPENSSL_MANGLER_ASM(d2i_X509_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_NAME_ENTRY
#  define d2i_X509_NAME_ENTRY OPENSSL_MANGLER(d2i_X509_NAME_ENTRY)
# endif
#else
# ifndef _d2i_X509_NAME_ENTRY
#  define _d2i_X509_NAME_ENTRY OPENSSL_MANGLER_ASM(d2i_X509_NAME_ENTRY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_PUBKEY
#  define d2i_X509_PUBKEY OPENSSL_MANGLER(d2i_X509_PUBKEY)
# endif
#else
# ifndef _d2i_X509_PUBKEY
#  define _d2i_X509_PUBKEY OPENSSL_MANGLER_ASM(d2i_X509_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_REQ
#  define d2i_X509_REQ OPENSSL_MANGLER(d2i_X509_REQ)
# endif
#else
# ifndef _d2i_X509_REQ
#  define _d2i_X509_REQ OPENSSL_MANGLER_ASM(d2i_X509_REQ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_REQ_bio
#  define d2i_X509_REQ_bio OPENSSL_MANGLER(d2i_X509_REQ_bio)
# endif
#else
# ifndef _d2i_X509_REQ_bio
#  define _d2i_X509_REQ_bio OPENSSL_MANGLER_ASM(d2i_X509_REQ_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_REQ_fp
#  define d2i_X509_REQ_fp OPENSSL_MANGLER(d2i_X509_REQ_fp)
# endif
#else
# ifndef _d2i_X509_REQ_fp
#  define _d2i_X509_REQ_fp OPENSSL_MANGLER_ASM(d2i_X509_REQ_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_REQ_INFO
#  define d2i_X509_REQ_INFO OPENSSL_MANGLER(d2i_X509_REQ_INFO)
# endif
#else
# ifndef _d2i_X509_REQ_INFO
#  define _d2i_X509_REQ_INFO OPENSSL_MANGLER_ASM(d2i_X509_REQ_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_REVOKED
#  define d2i_X509_REVOKED OPENSSL_MANGLER(d2i_X509_REVOKED)
# endif
#else
# ifndef _d2i_X509_REVOKED
#  define _d2i_X509_REVOKED OPENSSL_MANGLER_ASM(d2i_X509_REVOKED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_SIG
#  define d2i_X509_SIG OPENSSL_MANGLER(d2i_X509_SIG)
# endif
#else
# ifndef _d2i_X509_SIG
#  define _d2i_X509_SIG OPENSSL_MANGLER_ASM(d2i_X509_SIG)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef d2i_X509_VAL
#  define d2i_X509_VAL OPENSSL_MANGLER(d2i_X509_VAL)
# endif
#else
# ifndef _d2i_X509_VAL
#  define _d2i_X509_VAL OPENSSL_MANGLER_ASM(d2i_X509_VAL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dh_asn1_meth
#  define dh_asn1_meth OPENSSL_MANGLER(dh_asn1_meth)
# endif
#else
# ifndef _dh_asn1_meth
#  define _dh_asn1_meth OPENSSL_MANGLER_ASM(dh_asn1_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_bits
#  define DH_bits OPENSSL_MANGLER(DH_bits)
# endif
#else
# ifndef _DH_bits
#  define _DH_bits OPENSSL_MANGLER_ASM(DH_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_check
#  define DH_check OPENSSL_MANGLER(DH_check)
# endif
#else
# ifndef _DH_check
#  define _DH_check OPENSSL_MANGLER_ASM(DH_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_check_ex
#  define DH_check_ex OPENSSL_MANGLER(DH_check_ex)
# endif
#else
# ifndef _DH_check_ex
#  define _DH_check_ex OPENSSL_MANGLER_ASM(DH_check_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_check_params
#  define DH_check_params OPENSSL_MANGLER(DH_check_params)
# endif
#else
# ifndef _DH_check_params
#  define _DH_check_params OPENSSL_MANGLER_ASM(DH_check_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_check_params_ex
#  define DH_check_params_ex OPENSSL_MANGLER(DH_check_params_ex)
# endif
#else
# ifndef _DH_check_params_ex
#  define _DH_check_params_ex OPENSSL_MANGLER_ASM(DH_check_params_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_check_pub_key
#  define DH_check_pub_key OPENSSL_MANGLER(DH_check_pub_key)
# endif
#else
# ifndef _DH_check_pub_key
#  define _DH_check_pub_key OPENSSL_MANGLER_ASM(DH_check_pub_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_check_pub_key_ex
#  define DH_check_pub_key_ex OPENSSL_MANGLER(DH_check_pub_key_ex)
# endif
#else
# ifndef _DH_check_pub_key_ex
#  define _DH_check_pub_key_ex OPENSSL_MANGLER_ASM(DH_check_pub_key_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_clear_flags
#  define DH_clear_flags OPENSSL_MANGLER(DH_clear_flags)
# endif
#else
# ifndef _DH_clear_flags
#  define _DH_clear_flags OPENSSL_MANGLER_ASM(DH_clear_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_compute_key
#  define DH_compute_key OPENSSL_MANGLER(DH_compute_key)
# endif
#else
# ifndef _DH_compute_key
#  define _DH_compute_key OPENSSL_MANGLER_ASM(DH_compute_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_compute_key_padded
#  define DH_compute_key_padded OPENSSL_MANGLER(DH_compute_key_padded)
# endif
#else
# ifndef _DH_compute_key_padded
#  define _DH_compute_key_padded OPENSSL_MANGLER_ASM(DH_compute_key_padded)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_free
#  define DH_free OPENSSL_MANGLER(DH_free)
# endif
#else
# ifndef _DH_free
#  define _DH_free OPENSSL_MANGLER_ASM(DH_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_generate_key
#  define DH_generate_key OPENSSL_MANGLER(DH_generate_key)
# endif
#else
# ifndef _DH_generate_key
#  define _DH_generate_key OPENSSL_MANGLER_ASM(DH_generate_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_generate_parameters
#  define DH_generate_parameters OPENSSL_MANGLER(DH_generate_parameters)
# endif
#else
# ifndef _DH_generate_parameters
#  define _DH_generate_parameters OPENSSL_MANGLER_ASM(DH_generate_parameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_generate_parameters_ex
#  define DH_generate_parameters_ex OPENSSL_MANGLER(DH_generate_parameters_ex)
# endif
#else
# ifndef _DH_generate_parameters_ex
#  define _DH_generate_parameters_ex OPENSSL_MANGLER_ASM(DH_generate_parameters_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get0_engine
#  define DH_get0_engine OPENSSL_MANGLER(DH_get0_engine)
# endif
#else
# ifndef _DH_get0_engine
#  define _DH_get0_engine OPENSSL_MANGLER_ASM(DH_get0_engine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get0_g
#  define DH_get0_g OPENSSL_MANGLER(DH_get0_g)
# endif
#else
# ifndef _DH_get0_g
#  define _DH_get0_g OPENSSL_MANGLER_ASM(DH_get0_g)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get0_key
#  define DH_get0_key OPENSSL_MANGLER(DH_get0_key)
# endif
#else
# ifndef _DH_get0_key
#  define _DH_get0_key OPENSSL_MANGLER_ASM(DH_get0_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get0_p
#  define DH_get0_p OPENSSL_MANGLER(DH_get0_p)
# endif
#else
# ifndef _DH_get0_p
#  define _DH_get0_p OPENSSL_MANGLER_ASM(DH_get0_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get0_pqg
#  define DH_get0_pqg OPENSSL_MANGLER(DH_get0_pqg)
# endif
#else
# ifndef _DH_get0_pqg
#  define _DH_get0_pqg OPENSSL_MANGLER_ASM(DH_get0_pqg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get0_priv_key
#  define DH_get0_priv_key OPENSSL_MANGLER(DH_get0_priv_key)
# endif
#else
# ifndef _DH_get0_priv_key
#  define _DH_get0_priv_key OPENSSL_MANGLER_ASM(DH_get0_priv_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get0_pub_key
#  define DH_get0_pub_key OPENSSL_MANGLER(DH_get0_pub_key)
# endif
#else
# ifndef _DH_get0_pub_key
#  define _DH_get0_pub_key OPENSSL_MANGLER_ASM(DH_get0_pub_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get0_q
#  define DH_get0_q OPENSSL_MANGLER(DH_get0_q)
# endif
#else
# ifndef _DH_get0_q
#  define _DH_get0_q OPENSSL_MANGLER_ASM(DH_get0_q)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get_1024_160
#  define DH_get_1024_160 OPENSSL_MANGLER(DH_get_1024_160)
# endif
#else
# ifndef _DH_get_1024_160
#  define _DH_get_1024_160 OPENSSL_MANGLER_ASM(DH_get_1024_160)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get_2048_224
#  define DH_get_2048_224 OPENSSL_MANGLER(DH_get_2048_224)
# endif
#else
# ifndef _DH_get_2048_224
#  define _DH_get_2048_224 OPENSSL_MANGLER_ASM(DH_get_2048_224)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get_2048_256
#  define DH_get_2048_256 OPENSSL_MANGLER(DH_get_2048_256)
# endif
#else
# ifndef _DH_get_2048_256
#  define _DH_get_2048_256 OPENSSL_MANGLER_ASM(DH_get_2048_256)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get_default_method
#  define DH_get_default_method OPENSSL_MANGLER(DH_get_default_method)
# endif
#else
# ifndef _DH_get_default_method
#  define _DH_get_default_method OPENSSL_MANGLER_ASM(DH_get_default_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get_ex_data
#  define DH_get_ex_data OPENSSL_MANGLER(DH_get_ex_data)
# endif
#else
# ifndef _DH_get_ex_data
#  define _DH_get_ex_data OPENSSL_MANGLER_ASM(DH_get_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get_length
#  define DH_get_length OPENSSL_MANGLER(DH_get_length)
# endif
#else
# ifndef _DH_get_length
#  define _DH_get_length OPENSSL_MANGLER_ASM(DH_get_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_get_nid
#  define DH_get_nid OPENSSL_MANGLER(DH_get_nid)
# endif
#else
# ifndef _DH_get_nid
#  define _DH_get_nid OPENSSL_MANGLER_ASM(DH_get_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_KDF_X9_42
#  define DH_KDF_X9_42 OPENSSL_MANGLER(DH_KDF_X9_42)
# endif
#else
# ifndef _DH_KDF_X9_42
#  define _DH_KDF_X9_42 OPENSSL_MANGLER_ASM(DH_KDF_X9_42)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_dup
#  define DH_meth_dup OPENSSL_MANGLER(DH_meth_dup)
# endif
#else
# ifndef _DH_meth_dup
#  define _DH_meth_dup OPENSSL_MANGLER_ASM(DH_meth_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_free
#  define DH_meth_free OPENSSL_MANGLER(DH_meth_free)
# endif
#else
# ifndef _DH_meth_free
#  define _DH_meth_free OPENSSL_MANGLER_ASM(DH_meth_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_get0_app_data
#  define DH_meth_get0_app_data OPENSSL_MANGLER(DH_meth_get0_app_data)
# endif
#else
# ifndef _DH_meth_get0_app_data
#  define _DH_meth_get0_app_data OPENSSL_MANGLER_ASM(DH_meth_get0_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_get0_name
#  define DH_meth_get0_name OPENSSL_MANGLER(DH_meth_get0_name)
# endif
#else
# ifndef _DH_meth_get0_name
#  define _DH_meth_get0_name OPENSSL_MANGLER_ASM(DH_meth_get0_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_get_bn_mod_exp
#  define DH_meth_get_bn_mod_exp OPENSSL_MANGLER(DH_meth_get_bn_mod_exp)
# endif
#else
# ifndef _DH_meth_get_bn_mod_exp
#  define _DH_meth_get_bn_mod_exp OPENSSL_MANGLER_ASM(DH_meth_get_bn_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_get_compute_key
#  define DH_meth_get_compute_key OPENSSL_MANGLER(DH_meth_get_compute_key)
# endif
#else
# ifndef _DH_meth_get_compute_key
#  define _DH_meth_get_compute_key OPENSSL_MANGLER_ASM(DH_meth_get_compute_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_get_finish
#  define DH_meth_get_finish OPENSSL_MANGLER(DH_meth_get_finish)
# endif
#else
# ifndef _DH_meth_get_finish
#  define _DH_meth_get_finish OPENSSL_MANGLER_ASM(DH_meth_get_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_get_flags
#  define DH_meth_get_flags OPENSSL_MANGLER(DH_meth_get_flags)
# endif
#else
# ifndef _DH_meth_get_flags
#  define _DH_meth_get_flags OPENSSL_MANGLER_ASM(DH_meth_get_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_get_generate_key
#  define DH_meth_get_generate_key OPENSSL_MANGLER(DH_meth_get_generate_key)
# endif
#else
# ifndef _DH_meth_get_generate_key
#  define _DH_meth_get_generate_key OPENSSL_MANGLER_ASM(DH_meth_get_generate_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_get_generate_params
#  define DH_meth_get_generate_params OPENSSL_MANGLER(DH_meth_get_generate_params)
# endif
#else
# ifndef _DH_meth_get_generate_params
#  define _DH_meth_get_generate_params OPENSSL_MANGLER_ASM(DH_meth_get_generate_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_get_init
#  define DH_meth_get_init OPENSSL_MANGLER(DH_meth_get_init)
# endif
#else
# ifndef _DH_meth_get_init
#  define _DH_meth_get_init OPENSSL_MANGLER_ASM(DH_meth_get_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_new
#  define DH_meth_new OPENSSL_MANGLER(DH_meth_new)
# endif
#else
# ifndef _DH_meth_new
#  define _DH_meth_new OPENSSL_MANGLER_ASM(DH_meth_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_set0_app_data
#  define DH_meth_set0_app_data OPENSSL_MANGLER(DH_meth_set0_app_data)
# endif
#else
# ifndef _DH_meth_set0_app_data
#  define _DH_meth_set0_app_data OPENSSL_MANGLER_ASM(DH_meth_set0_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_set1_name
#  define DH_meth_set1_name OPENSSL_MANGLER(DH_meth_set1_name)
# endif
#else
# ifndef _DH_meth_set1_name
#  define _DH_meth_set1_name OPENSSL_MANGLER_ASM(DH_meth_set1_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_set_bn_mod_exp
#  define DH_meth_set_bn_mod_exp OPENSSL_MANGLER(DH_meth_set_bn_mod_exp)
# endif
#else
# ifndef _DH_meth_set_bn_mod_exp
#  define _DH_meth_set_bn_mod_exp OPENSSL_MANGLER_ASM(DH_meth_set_bn_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_set_compute_key
#  define DH_meth_set_compute_key OPENSSL_MANGLER(DH_meth_set_compute_key)
# endif
#else
# ifndef _DH_meth_set_compute_key
#  define _DH_meth_set_compute_key OPENSSL_MANGLER_ASM(DH_meth_set_compute_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_set_finish
#  define DH_meth_set_finish OPENSSL_MANGLER(DH_meth_set_finish)
# endif
#else
# ifndef _DH_meth_set_finish
#  define _DH_meth_set_finish OPENSSL_MANGLER_ASM(DH_meth_set_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_set_flags
#  define DH_meth_set_flags OPENSSL_MANGLER(DH_meth_set_flags)
# endif
#else
# ifndef _DH_meth_set_flags
#  define _DH_meth_set_flags OPENSSL_MANGLER_ASM(DH_meth_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_set_generate_key
#  define DH_meth_set_generate_key OPENSSL_MANGLER(DH_meth_set_generate_key)
# endif
#else
# ifndef _DH_meth_set_generate_key
#  define _DH_meth_set_generate_key OPENSSL_MANGLER_ASM(DH_meth_set_generate_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_set_generate_params
#  define DH_meth_set_generate_params OPENSSL_MANGLER(DH_meth_set_generate_params)
# endif
#else
# ifndef _DH_meth_set_generate_params
#  define _DH_meth_set_generate_params OPENSSL_MANGLER_ASM(DH_meth_set_generate_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_meth_set_init
#  define DH_meth_set_init OPENSSL_MANGLER(DH_meth_set_init)
# endif
#else
# ifndef _DH_meth_set_init
#  define _DH_meth_set_init OPENSSL_MANGLER_ASM(DH_meth_set_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_new
#  define DH_new OPENSSL_MANGLER(DH_new)
# endif
#else
# ifndef _DH_new
#  define _DH_new OPENSSL_MANGLER_ASM(DH_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_new_by_nid
#  define DH_new_by_nid OPENSSL_MANGLER(DH_new_by_nid)
# endif
#else
# ifndef _DH_new_by_nid
#  define _DH_new_by_nid OPENSSL_MANGLER_ASM(DH_new_by_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_new_method
#  define DH_new_method OPENSSL_MANGLER(DH_new_method)
# endif
#else
# ifndef _DH_new_method
#  define _DH_new_method OPENSSL_MANGLER_ASM(DH_new_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_OpenSSL
#  define DH_OpenSSL OPENSSL_MANGLER(DH_OpenSSL)
# endif
#else
# ifndef _DH_OpenSSL
#  define _DH_OpenSSL OPENSSL_MANGLER_ASM(DH_OpenSSL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DHparams_dup
#  define DHparams_dup OPENSSL_MANGLER(DHparams_dup)
# endif
#else
# ifndef _DHparams_dup
#  define _DHparams_dup OPENSSL_MANGLER_ASM(DHparams_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DHparams_it
#  define DHparams_it OPENSSL_MANGLER(DHparams_it)
# endif
#else
# ifndef _DHparams_it
#  define _DHparams_it OPENSSL_MANGLER_ASM(DHparams_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DHparams_print
#  define DHparams_print OPENSSL_MANGLER(DHparams_print)
# endif
#else
# ifndef _DHparams_print
#  define _DHparams_print OPENSSL_MANGLER_ASM(DHparams_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DHparams_print_fp
#  define DHparams_print_fp OPENSSL_MANGLER(DHparams_print_fp)
# endif
#else
# ifndef _DHparams_print_fp
#  define _DHparams_print_fp OPENSSL_MANGLER_ASM(DHparams_print_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dh_pkey_meth
#  define dh_pkey_meth OPENSSL_MANGLER(dh_pkey_meth)
# endif
#else
# ifndef _dh_pkey_meth
#  define _dh_pkey_meth OPENSSL_MANGLER_ASM(dh_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_security_bits
#  define DH_security_bits OPENSSL_MANGLER(DH_security_bits)
# endif
#else
# ifndef _DH_security_bits
#  define _DH_security_bits OPENSSL_MANGLER_ASM(DH_security_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_set0_key
#  define DH_set0_key OPENSSL_MANGLER(DH_set0_key)
# endif
#else
# ifndef _DH_set0_key
#  define _DH_set0_key OPENSSL_MANGLER_ASM(DH_set0_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_set0_pqg
#  define DH_set0_pqg OPENSSL_MANGLER(DH_set0_pqg)
# endif
#else
# ifndef _DH_set0_pqg
#  define _DH_set0_pqg OPENSSL_MANGLER_ASM(DH_set0_pqg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_set_default_method
#  define DH_set_default_method OPENSSL_MANGLER(DH_set_default_method)
# endif
#else
# ifndef _DH_set_default_method
#  define _DH_set_default_method OPENSSL_MANGLER_ASM(DH_set_default_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_set_ex_data
#  define DH_set_ex_data OPENSSL_MANGLER(DH_set_ex_data)
# endif
#else
# ifndef _DH_set_ex_data
#  define _DH_set_ex_data OPENSSL_MANGLER_ASM(DH_set_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_set_flags
#  define DH_set_flags OPENSSL_MANGLER(DH_set_flags)
# endif
#else
# ifndef _DH_set_flags
#  define _DH_set_flags OPENSSL_MANGLER_ASM(DH_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_set_length
#  define DH_set_length OPENSSL_MANGLER(DH_set_length)
# endif
#else
# ifndef _DH_set_length
#  define _DH_set_length OPENSSL_MANGLER_ASM(DH_set_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_set_method
#  define DH_set_method OPENSSL_MANGLER(DH_set_method)
# endif
#else
# ifndef _DH_set_method
#  define _DH_set_method OPENSSL_MANGLER_ASM(DH_set_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_size
#  define DH_size OPENSSL_MANGLER(DH_size)
# endif
#else
# ifndef _DH_size
#  define _DH_size OPENSSL_MANGLER_ASM(DH_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_test_flags
#  define DH_test_flags OPENSSL_MANGLER(DH_test_flags)
# endif
#else
# ifndef _DH_test_flags
#  define _DH_test_flags OPENSSL_MANGLER_ASM(DH_test_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DH_up_ref
#  define DH_up_ref OPENSSL_MANGLER(DH_up_ref)
# endif
#else
# ifndef _DH_up_ref
#  define _DH_up_ref OPENSSL_MANGLER_ASM(DH_up_ref)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dhx_asn1_meth
#  define dhx_asn1_meth OPENSSL_MANGLER(dhx_asn1_meth)
# endif
#else
# ifndef _dhx_asn1_meth
#  define _dhx_asn1_meth OPENSSL_MANGLER_ASM(dhx_asn1_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dhx_pkey_meth
#  define dhx_pkey_meth OPENSSL_MANGLER(dhx_pkey_meth)
# endif
#else
# ifndef _dhx_pkey_meth
#  define _dhx_pkey_meth OPENSSL_MANGLER_ASM(dhx_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DIRECTORYSTRING_free
#  define DIRECTORYSTRING_free OPENSSL_MANGLER(DIRECTORYSTRING_free)
# endif
#else
# ifndef _DIRECTORYSTRING_free
#  define _DIRECTORYSTRING_free OPENSSL_MANGLER_ASM(DIRECTORYSTRING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DIRECTORYSTRING_it
#  define DIRECTORYSTRING_it OPENSSL_MANGLER(DIRECTORYSTRING_it)
# endif
#else
# ifndef _DIRECTORYSTRING_it
#  define _DIRECTORYSTRING_it OPENSSL_MANGLER_ASM(DIRECTORYSTRING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DIRECTORYSTRING_new
#  define DIRECTORYSTRING_new OPENSSL_MANGLER(DIRECTORYSTRING_new)
# endif
#else
# ifndef _DIRECTORYSTRING_new
#  define _DIRECTORYSTRING_new OPENSSL_MANGLER_ASM(DIRECTORYSTRING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DISPLAYTEXT_free
#  define DISPLAYTEXT_free OPENSSL_MANGLER(DISPLAYTEXT_free)
# endif
#else
# ifndef _DISPLAYTEXT_free
#  define _DISPLAYTEXT_free OPENSSL_MANGLER_ASM(DISPLAYTEXT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DISPLAYTEXT_it
#  define DISPLAYTEXT_it OPENSSL_MANGLER(DISPLAYTEXT_it)
# endif
#else
# ifndef _DISPLAYTEXT_it
#  define _DISPLAYTEXT_it OPENSSL_MANGLER_ASM(DISPLAYTEXT_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DISPLAYTEXT_new
#  define DISPLAYTEXT_new OPENSSL_MANGLER(DISPLAYTEXT_new)
# endif
#else
# ifndef _DISPLAYTEXT_new
#  define _DISPLAYTEXT_new OPENSSL_MANGLER_ASM(DISPLAYTEXT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DIST_POINT_free
#  define DIST_POINT_free OPENSSL_MANGLER(DIST_POINT_free)
# endif
#else
# ifndef _DIST_POINT_free
#  define _DIST_POINT_free OPENSSL_MANGLER_ASM(DIST_POINT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DIST_POINT_it
#  define DIST_POINT_it OPENSSL_MANGLER(DIST_POINT_it)
# endif
#else
# ifndef _DIST_POINT_it
#  define _DIST_POINT_it OPENSSL_MANGLER_ASM(DIST_POINT_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DIST_POINT_NAME_free
#  define DIST_POINT_NAME_free OPENSSL_MANGLER(DIST_POINT_NAME_free)
# endif
#else
# ifndef _DIST_POINT_NAME_free
#  define _DIST_POINT_NAME_free OPENSSL_MANGLER_ASM(DIST_POINT_NAME_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DIST_POINT_NAME_it
#  define DIST_POINT_NAME_it OPENSSL_MANGLER(DIST_POINT_NAME_it)
# endif
#else
# ifndef _DIST_POINT_NAME_it
#  define _DIST_POINT_NAME_it OPENSSL_MANGLER_ASM(DIST_POINT_NAME_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DIST_POINT_NAME_new
#  define DIST_POINT_NAME_new OPENSSL_MANGLER(DIST_POINT_NAME_new)
# endif
#else
# ifndef _DIST_POINT_NAME_new
#  define _DIST_POINT_NAME_new OPENSSL_MANGLER_ASM(DIST_POINT_NAME_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DIST_POINT_new
#  define DIST_POINT_new OPENSSL_MANGLER(DIST_POINT_new)
# endif
#else
# ifndef _DIST_POINT_new
#  define _DIST_POINT_new OPENSSL_MANGLER_ASM(DIST_POINT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DIST_POINT_set_dpname
#  define DIST_POINT_set_dpname OPENSSL_MANGLER(DIST_POINT_set_dpname)
# endif
#else
# ifndef _DIST_POINT_set_dpname
#  define _DIST_POINT_set_dpname OPENSSL_MANGLER_ASM(DIST_POINT_set_dpname)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef do_dtls1_write
#  define do_dtls1_write OPENSSL_MANGLER(do_dtls1_write)
# endif
#else
# ifndef _do_dtls1_write
#  define _do_dtls1_write OPENSSL_MANGLER_ASM(do_dtls1_write)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef do_ssl3_write
#  define do_ssl3_write OPENSSL_MANGLER(do_ssl3_write)
# endif
#else
# ifndef _do_ssl3_write
#  define _do_ssl3_write OPENSSL_MANGLER_ASM(do_ssl3_write)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef drbg_ctr_init
#  define drbg_ctr_init OPENSSL_MANGLER(drbg_ctr_init)
# endif
#else
# ifndef _drbg_ctr_init
#  define _drbg_ctr_init OPENSSL_MANGLER_ASM(drbg_ctr_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef drbg_delete_thread_state
#  define drbg_delete_thread_state OPENSSL_MANGLER(drbg_delete_thread_state)
# endif
#else
# ifndef _drbg_delete_thread_state
#  define _drbg_delete_thread_state OPENSSL_MANGLER_ASM(drbg_delete_thread_state)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dsa_asn1_meths
#  define dsa_asn1_meths OPENSSL_MANGLER(dsa_asn1_meths)
# endif
#else
# ifndef _dsa_asn1_meths
#  define _dsa_asn1_meths OPENSSL_MANGLER_ASM(dsa_asn1_meths)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_bits
#  define DSA_bits OPENSSL_MANGLER(DSA_bits)
# endif
#else
# ifndef _DSA_bits
#  define _DSA_bits OPENSSL_MANGLER_ASM(DSA_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dsa_builtin_paramgen
#  define dsa_builtin_paramgen OPENSSL_MANGLER(dsa_builtin_paramgen)
# endif
#else
# ifndef _dsa_builtin_paramgen
#  define _dsa_builtin_paramgen OPENSSL_MANGLER_ASM(dsa_builtin_paramgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dsa_builtin_paramgen2
#  define dsa_builtin_paramgen2 OPENSSL_MANGLER(dsa_builtin_paramgen2)
# endif
#else
# ifndef _dsa_builtin_paramgen2
#  define _dsa_builtin_paramgen2 OPENSSL_MANGLER_ASM(dsa_builtin_paramgen2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_clear_flags
#  define DSA_clear_flags OPENSSL_MANGLER(DSA_clear_flags)
# endif
#else
# ifndef _DSA_clear_flags
#  define _DSA_clear_flags OPENSSL_MANGLER_ASM(DSA_clear_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_do_sign
#  define DSA_do_sign OPENSSL_MANGLER(DSA_do_sign)
# endif
#else
# ifndef _DSA_do_sign
#  define _DSA_do_sign OPENSSL_MANGLER_ASM(DSA_do_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_do_verify
#  define DSA_do_verify OPENSSL_MANGLER(DSA_do_verify)
# endif
#else
# ifndef _DSA_do_verify
#  define _DSA_do_verify OPENSSL_MANGLER_ASM(DSA_do_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_dup_DH
#  define DSA_dup_DH OPENSSL_MANGLER(DSA_dup_DH)
# endif
#else
# ifndef _DSA_dup_DH
#  define _DSA_dup_DH OPENSSL_MANGLER_ASM(DSA_dup_DH)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_free
#  define DSA_free OPENSSL_MANGLER(DSA_free)
# endif
#else
# ifndef _DSA_free
#  define _DSA_free OPENSSL_MANGLER_ASM(DSA_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_generate_key
#  define DSA_generate_key OPENSSL_MANGLER(DSA_generate_key)
# endif
#else
# ifndef _DSA_generate_key
#  define _DSA_generate_key OPENSSL_MANGLER_ASM(DSA_generate_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_generate_parameters
#  define DSA_generate_parameters OPENSSL_MANGLER(DSA_generate_parameters)
# endif
#else
# ifndef _DSA_generate_parameters
#  define _DSA_generate_parameters OPENSSL_MANGLER_ASM(DSA_generate_parameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_generate_parameters_ex
#  define DSA_generate_parameters_ex OPENSSL_MANGLER(DSA_generate_parameters_ex)
# endif
#else
# ifndef _DSA_generate_parameters_ex
#  define _DSA_generate_parameters_ex OPENSSL_MANGLER_ASM(DSA_generate_parameters_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get0_engine
#  define DSA_get0_engine OPENSSL_MANGLER(DSA_get0_engine)
# endif
#else
# ifndef _DSA_get0_engine
#  define _DSA_get0_engine OPENSSL_MANGLER_ASM(DSA_get0_engine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get0_g
#  define DSA_get0_g OPENSSL_MANGLER(DSA_get0_g)
# endif
#else
# ifndef _DSA_get0_g
#  define _DSA_get0_g OPENSSL_MANGLER_ASM(DSA_get0_g)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get0_key
#  define DSA_get0_key OPENSSL_MANGLER(DSA_get0_key)
# endif
#else
# ifndef _DSA_get0_key
#  define _DSA_get0_key OPENSSL_MANGLER_ASM(DSA_get0_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get0_p
#  define DSA_get0_p OPENSSL_MANGLER(DSA_get0_p)
# endif
#else
# ifndef _DSA_get0_p
#  define _DSA_get0_p OPENSSL_MANGLER_ASM(DSA_get0_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get0_pqg
#  define DSA_get0_pqg OPENSSL_MANGLER(DSA_get0_pqg)
# endif
#else
# ifndef _DSA_get0_pqg
#  define _DSA_get0_pqg OPENSSL_MANGLER_ASM(DSA_get0_pqg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get0_priv_key
#  define DSA_get0_priv_key OPENSSL_MANGLER(DSA_get0_priv_key)
# endif
#else
# ifndef _DSA_get0_priv_key
#  define _DSA_get0_priv_key OPENSSL_MANGLER_ASM(DSA_get0_priv_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get0_pub_key
#  define DSA_get0_pub_key OPENSSL_MANGLER(DSA_get0_pub_key)
# endif
#else
# ifndef _DSA_get0_pub_key
#  define _DSA_get0_pub_key OPENSSL_MANGLER_ASM(DSA_get0_pub_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get0_q
#  define DSA_get0_q OPENSSL_MANGLER(DSA_get0_q)
# endif
#else
# ifndef _DSA_get0_q
#  define _DSA_get0_q OPENSSL_MANGLER_ASM(DSA_get0_q)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get_default_method
#  define DSA_get_default_method OPENSSL_MANGLER(DSA_get_default_method)
# endif
#else
# ifndef _DSA_get_default_method
#  define _DSA_get_default_method OPENSSL_MANGLER_ASM(DSA_get_default_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get_ex_data
#  define DSA_get_ex_data OPENSSL_MANGLER(DSA_get_ex_data)
# endif
#else
# ifndef _DSA_get_ex_data
#  define _DSA_get_ex_data OPENSSL_MANGLER_ASM(DSA_get_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_get_method
#  define DSA_get_method OPENSSL_MANGLER(DSA_get_method)
# endif
#else
# ifndef _DSA_get_method
#  define _DSA_get_method OPENSSL_MANGLER_ASM(DSA_get_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_dup
#  define DSA_meth_dup OPENSSL_MANGLER(DSA_meth_dup)
# endif
#else
# ifndef _DSA_meth_dup
#  define _DSA_meth_dup OPENSSL_MANGLER_ASM(DSA_meth_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_free
#  define DSA_meth_free OPENSSL_MANGLER(DSA_meth_free)
# endif
#else
# ifndef _DSA_meth_free
#  define _DSA_meth_free OPENSSL_MANGLER_ASM(DSA_meth_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get0_app_data
#  define DSA_meth_get0_app_data OPENSSL_MANGLER(DSA_meth_get0_app_data)
# endif
#else
# ifndef _DSA_meth_get0_app_data
#  define _DSA_meth_get0_app_data OPENSSL_MANGLER_ASM(DSA_meth_get0_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get0_name
#  define DSA_meth_get0_name OPENSSL_MANGLER(DSA_meth_get0_name)
# endif
#else
# ifndef _DSA_meth_get0_name
#  define _DSA_meth_get0_name OPENSSL_MANGLER_ASM(DSA_meth_get0_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get_bn_mod_exp
#  define DSA_meth_get_bn_mod_exp OPENSSL_MANGLER(DSA_meth_get_bn_mod_exp)
# endif
#else
# ifndef _DSA_meth_get_bn_mod_exp
#  define _DSA_meth_get_bn_mod_exp OPENSSL_MANGLER_ASM(DSA_meth_get_bn_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get_finish
#  define DSA_meth_get_finish OPENSSL_MANGLER(DSA_meth_get_finish)
# endif
#else
# ifndef _DSA_meth_get_finish
#  define _DSA_meth_get_finish OPENSSL_MANGLER_ASM(DSA_meth_get_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get_flags
#  define DSA_meth_get_flags OPENSSL_MANGLER(DSA_meth_get_flags)
# endif
#else
# ifndef _DSA_meth_get_flags
#  define _DSA_meth_get_flags OPENSSL_MANGLER_ASM(DSA_meth_get_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get_init
#  define DSA_meth_get_init OPENSSL_MANGLER(DSA_meth_get_init)
# endif
#else
# ifndef _DSA_meth_get_init
#  define _DSA_meth_get_init OPENSSL_MANGLER_ASM(DSA_meth_get_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get_keygen
#  define DSA_meth_get_keygen OPENSSL_MANGLER(DSA_meth_get_keygen)
# endif
#else
# ifndef _DSA_meth_get_keygen
#  define _DSA_meth_get_keygen OPENSSL_MANGLER_ASM(DSA_meth_get_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get_mod_exp
#  define DSA_meth_get_mod_exp OPENSSL_MANGLER(DSA_meth_get_mod_exp)
# endif
#else
# ifndef _DSA_meth_get_mod_exp
#  define _DSA_meth_get_mod_exp OPENSSL_MANGLER_ASM(DSA_meth_get_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get_paramgen
#  define DSA_meth_get_paramgen OPENSSL_MANGLER(DSA_meth_get_paramgen)
# endif
#else
# ifndef _DSA_meth_get_paramgen
#  define _DSA_meth_get_paramgen OPENSSL_MANGLER_ASM(DSA_meth_get_paramgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get_sign
#  define DSA_meth_get_sign OPENSSL_MANGLER(DSA_meth_get_sign)
# endif
#else
# ifndef _DSA_meth_get_sign
#  define _DSA_meth_get_sign OPENSSL_MANGLER_ASM(DSA_meth_get_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get_sign_setup
#  define DSA_meth_get_sign_setup OPENSSL_MANGLER(DSA_meth_get_sign_setup)
# endif
#else
# ifndef _DSA_meth_get_sign_setup
#  define _DSA_meth_get_sign_setup OPENSSL_MANGLER_ASM(DSA_meth_get_sign_setup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_get_verify
#  define DSA_meth_get_verify OPENSSL_MANGLER(DSA_meth_get_verify)
# endif
#else
# ifndef _DSA_meth_get_verify
#  define _DSA_meth_get_verify OPENSSL_MANGLER_ASM(DSA_meth_get_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_new
#  define DSA_meth_new OPENSSL_MANGLER(DSA_meth_new)
# endif
#else
# ifndef _DSA_meth_new
#  define _DSA_meth_new OPENSSL_MANGLER_ASM(DSA_meth_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set0_app_data
#  define DSA_meth_set0_app_data OPENSSL_MANGLER(DSA_meth_set0_app_data)
# endif
#else
# ifndef _DSA_meth_set0_app_data
#  define _DSA_meth_set0_app_data OPENSSL_MANGLER_ASM(DSA_meth_set0_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set1_name
#  define DSA_meth_set1_name OPENSSL_MANGLER(DSA_meth_set1_name)
# endif
#else
# ifndef _DSA_meth_set1_name
#  define _DSA_meth_set1_name OPENSSL_MANGLER_ASM(DSA_meth_set1_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set_bn_mod_exp
#  define DSA_meth_set_bn_mod_exp OPENSSL_MANGLER(DSA_meth_set_bn_mod_exp)
# endif
#else
# ifndef _DSA_meth_set_bn_mod_exp
#  define _DSA_meth_set_bn_mod_exp OPENSSL_MANGLER_ASM(DSA_meth_set_bn_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set_finish
#  define DSA_meth_set_finish OPENSSL_MANGLER(DSA_meth_set_finish)
# endif
#else
# ifndef _DSA_meth_set_finish
#  define _DSA_meth_set_finish OPENSSL_MANGLER_ASM(DSA_meth_set_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set_flags
#  define DSA_meth_set_flags OPENSSL_MANGLER(DSA_meth_set_flags)
# endif
#else
# ifndef _DSA_meth_set_flags
#  define _DSA_meth_set_flags OPENSSL_MANGLER_ASM(DSA_meth_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set_init
#  define DSA_meth_set_init OPENSSL_MANGLER(DSA_meth_set_init)
# endif
#else
# ifndef _DSA_meth_set_init
#  define _DSA_meth_set_init OPENSSL_MANGLER_ASM(DSA_meth_set_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set_keygen
#  define DSA_meth_set_keygen OPENSSL_MANGLER(DSA_meth_set_keygen)
# endif
#else
# ifndef _DSA_meth_set_keygen
#  define _DSA_meth_set_keygen OPENSSL_MANGLER_ASM(DSA_meth_set_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set_mod_exp
#  define DSA_meth_set_mod_exp OPENSSL_MANGLER(DSA_meth_set_mod_exp)
# endif
#else
# ifndef _DSA_meth_set_mod_exp
#  define _DSA_meth_set_mod_exp OPENSSL_MANGLER_ASM(DSA_meth_set_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set_paramgen
#  define DSA_meth_set_paramgen OPENSSL_MANGLER(DSA_meth_set_paramgen)
# endif
#else
# ifndef _DSA_meth_set_paramgen
#  define _DSA_meth_set_paramgen OPENSSL_MANGLER_ASM(DSA_meth_set_paramgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set_sign
#  define DSA_meth_set_sign OPENSSL_MANGLER(DSA_meth_set_sign)
# endif
#else
# ifndef _DSA_meth_set_sign
#  define _DSA_meth_set_sign OPENSSL_MANGLER_ASM(DSA_meth_set_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set_sign_setup
#  define DSA_meth_set_sign_setup OPENSSL_MANGLER(DSA_meth_set_sign_setup)
# endif
#else
# ifndef _DSA_meth_set_sign_setup
#  define _DSA_meth_set_sign_setup OPENSSL_MANGLER_ASM(DSA_meth_set_sign_setup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_meth_set_verify
#  define DSA_meth_set_verify OPENSSL_MANGLER(DSA_meth_set_verify)
# endif
#else
# ifndef _DSA_meth_set_verify
#  define _DSA_meth_set_verify OPENSSL_MANGLER_ASM(DSA_meth_set_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_new
#  define DSA_new OPENSSL_MANGLER(DSA_new)
# endif
#else
# ifndef _DSA_new
#  define _DSA_new OPENSSL_MANGLER_ASM(DSA_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_new_method
#  define DSA_new_method OPENSSL_MANGLER(DSA_new_method)
# endif
#else
# ifndef _DSA_new_method
#  define _DSA_new_method OPENSSL_MANGLER_ASM(DSA_new_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_OpenSSL
#  define DSA_OpenSSL OPENSSL_MANGLER(DSA_OpenSSL)
# endif
#else
# ifndef _DSA_OpenSSL
#  define _DSA_OpenSSL OPENSSL_MANGLER_ASM(DSA_OpenSSL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSAparams_dup
#  define DSAparams_dup OPENSSL_MANGLER(DSAparams_dup)
# endif
#else
# ifndef _DSAparams_dup
#  define _DSAparams_dup OPENSSL_MANGLER_ASM(DSAparams_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSAparams_print
#  define DSAparams_print OPENSSL_MANGLER(DSAparams_print)
# endif
#else
# ifndef _DSAparams_print
#  define _DSAparams_print OPENSSL_MANGLER_ASM(DSAparams_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSAparams_print_fp
#  define DSAparams_print_fp OPENSSL_MANGLER(DSAparams_print_fp)
# endif
#else
# ifndef _DSAparams_print_fp
#  define _DSAparams_print_fp OPENSSL_MANGLER_ASM(DSAparams_print_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dsa_pkey_meth
#  define dsa_pkey_meth OPENSSL_MANGLER(dsa_pkey_meth)
# endif
#else
# ifndef _dsa_pkey_meth
#  define _dsa_pkey_meth OPENSSL_MANGLER_ASM(dsa_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_print
#  define DSA_print OPENSSL_MANGLER(DSA_print)
# endif
#else
# ifndef _DSA_print
#  define _DSA_print OPENSSL_MANGLER_ASM(DSA_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_print_fp
#  define DSA_print_fp OPENSSL_MANGLER(DSA_print_fp)
# endif
#else
# ifndef _DSA_print_fp
#  define _DSA_print_fp OPENSSL_MANGLER_ASM(DSA_print_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_security_bits
#  define DSA_security_bits OPENSSL_MANGLER(DSA_security_bits)
# endif
#else
# ifndef _DSA_security_bits
#  define _DSA_security_bits OPENSSL_MANGLER_ASM(DSA_security_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_set0_key
#  define DSA_set0_key OPENSSL_MANGLER(DSA_set0_key)
# endif
#else
# ifndef _DSA_set0_key
#  define _DSA_set0_key OPENSSL_MANGLER_ASM(DSA_set0_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_set0_pqg
#  define DSA_set0_pqg OPENSSL_MANGLER(DSA_set0_pqg)
# endif
#else
# ifndef _DSA_set0_pqg
#  define _DSA_set0_pqg OPENSSL_MANGLER_ASM(DSA_set0_pqg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_set_default_method
#  define DSA_set_default_method OPENSSL_MANGLER(DSA_set_default_method)
# endif
#else
# ifndef _DSA_set_default_method
#  define _DSA_set_default_method OPENSSL_MANGLER_ASM(DSA_set_default_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_set_ex_data
#  define DSA_set_ex_data OPENSSL_MANGLER(DSA_set_ex_data)
# endif
#else
# ifndef _DSA_set_ex_data
#  define _DSA_set_ex_data OPENSSL_MANGLER_ASM(DSA_set_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_set_flags
#  define DSA_set_flags OPENSSL_MANGLER(DSA_set_flags)
# endif
#else
# ifndef _DSA_set_flags
#  define _DSA_set_flags OPENSSL_MANGLER_ASM(DSA_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_set_method
#  define DSA_set_method OPENSSL_MANGLER(DSA_set_method)
# endif
#else
# ifndef _DSA_set_method
#  define _DSA_set_method OPENSSL_MANGLER_ASM(DSA_set_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_SIG_free
#  define DSA_SIG_free OPENSSL_MANGLER(DSA_SIG_free)
# endif
#else
# ifndef _DSA_SIG_free
#  define _DSA_SIG_free OPENSSL_MANGLER_ASM(DSA_SIG_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_SIG_get0
#  define DSA_SIG_get0 OPENSSL_MANGLER(DSA_SIG_get0)
# endif
#else
# ifndef _DSA_SIG_get0
#  define _DSA_SIG_get0 OPENSSL_MANGLER_ASM(DSA_SIG_get0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_sign
#  define DSA_sign OPENSSL_MANGLER(DSA_sign)
# endif
#else
# ifndef _DSA_sign
#  define _DSA_sign OPENSSL_MANGLER_ASM(DSA_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_SIG_new
#  define DSA_SIG_new OPENSSL_MANGLER(DSA_SIG_new)
# endif
#else
# ifndef _DSA_SIG_new
#  define _DSA_SIG_new OPENSSL_MANGLER_ASM(DSA_SIG_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_sign_setup
#  define DSA_sign_setup OPENSSL_MANGLER(DSA_sign_setup)
# endif
#else
# ifndef _DSA_sign_setup
#  define _DSA_sign_setup OPENSSL_MANGLER_ASM(DSA_sign_setup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_SIG_set0
#  define DSA_SIG_set0 OPENSSL_MANGLER(DSA_SIG_set0)
# endif
#else
# ifndef _DSA_SIG_set0
#  define _DSA_SIG_set0 OPENSSL_MANGLER_ASM(DSA_SIG_set0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_size
#  define DSA_size OPENSSL_MANGLER(DSA_size)
# endif
#else
# ifndef _DSA_size
#  define _DSA_size OPENSSL_MANGLER_ASM(DSA_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_test_flags
#  define DSA_test_flags OPENSSL_MANGLER(DSA_test_flags)
# endif
#else
# ifndef _DSA_test_flags
#  define _DSA_test_flags OPENSSL_MANGLER_ASM(DSA_test_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_up_ref
#  define DSA_up_ref OPENSSL_MANGLER(DSA_up_ref)
# endif
#else
# ifndef _DSA_up_ref
#  define _DSA_up_ref OPENSSL_MANGLER_ASM(DSA_up_ref)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSA_verify
#  define DSA_verify OPENSSL_MANGLER(DSA_verify)
# endif
#else
# ifndef _DSA_verify
#  define _DSA_verify OPENSSL_MANGLER_ASM(DSA_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_bind_func
#  define DSO_bind_func OPENSSL_MANGLER(DSO_bind_func)
# endif
#else
# ifndef _DSO_bind_func
#  define _DSO_bind_func OPENSSL_MANGLER_ASM(DSO_bind_func)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_convert_filename
#  define DSO_convert_filename OPENSSL_MANGLER(DSO_convert_filename)
# endif
#else
# ifndef _DSO_convert_filename
#  define _DSO_convert_filename OPENSSL_MANGLER_ASM(DSO_convert_filename)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_ctrl
#  define DSO_ctrl OPENSSL_MANGLER(DSO_ctrl)
# endif
#else
# ifndef _DSO_ctrl
#  define _DSO_ctrl OPENSSL_MANGLER_ASM(DSO_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_dsobyaddr
#  define DSO_dsobyaddr OPENSSL_MANGLER(DSO_dsobyaddr)
# endif
#else
# ifndef _DSO_dsobyaddr
#  define _DSO_dsobyaddr OPENSSL_MANGLER_ASM(DSO_dsobyaddr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_flags
#  define DSO_flags OPENSSL_MANGLER(DSO_flags)
# endif
#else
# ifndef _DSO_flags
#  define _DSO_flags OPENSSL_MANGLER_ASM(DSO_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_free
#  define DSO_free OPENSSL_MANGLER(DSO_free)
# endif
#else
# ifndef _DSO_free
#  define _DSO_free OPENSSL_MANGLER_ASM(DSO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_get_filename
#  define DSO_get_filename OPENSSL_MANGLER(DSO_get_filename)
# endif
#else
# ifndef _DSO_get_filename
#  define _DSO_get_filename OPENSSL_MANGLER_ASM(DSO_get_filename)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_global_lookup
#  define DSO_global_lookup OPENSSL_MANGLER(DSO_global_lookup)
# endif
#else
# ifndef _DSO_global_lookup
#  define _DSO_global_lookup OPENSSL_MANGLER_ASM(DSO_global_lookup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_load
#  define DSO_load OPENSSL_MANGLER(DSO_load)
# endif
#else
# ifndef _DSO_load
#  define _DSO_load OPENSSL_MANGLER_ASM(DSO_load)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_merge
#  define DSO_merge OPENSSL_MANGLER(DSO_merge)
# endif
#else
# ifndef _DSO_merge
#  define _DSO_merge OPENSSL_MANGLER_ASM(DSO_merge)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_METHOD_openssl
#  define DSO_METHOD_openssl OPENSSL_MANGLER(DSO_METHOD_openssl)
# endif
#else
# ifndef _DSO_METHOD_openssl
#  define _DSO_METHOD_openssl OPENSSL_MANGLER_ASM(DSO_METHOD_openssl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_new
#  define DSO_new OPENSSL_MANGLER(DSO_new)
# endif
#else
# ifndef _DSO_new
#  define _DSO_new OPENSSL_MANGLER_ASM(DSO_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_pathbyaddr
#  define DSO_pathbyaddr OPENSSL_MANGLER(DSO_pathbyaddr)
# endif
#else
# ifndef _DSO_pathbyaddr
#  define _DSO_pathbyaddr OPENSSL_MANGLER_ASM(DSO_pathbyaddr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_set_filename
#  define DSO_set_filename OPENSSL_MANGLER(DSO_set_filename)
# endif
#else
# ifndef _DSO_set_filename
#  define _DSO_set_filename OPENSSL_MANGLER_ASM(DSO_set_filename)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DSO_up_ref
#  define DSO_up_ref OPENSSL_MANGLER(DSO_up_ref)
# endif
#else
# ifndef _DSO_up_ref
#  define _DSO_up_ref OPENSSL_MANGLER_ASM(DSO_up_ref)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_buffer_message
#  define dtls1_buffer_message OPENSSL_MANGLER(dtls1_buffer_message)
# endif
#else
# ifndef _dtls1_buffer_message
#  define _dtls1_buffer_message OPENSSL_MANGLER_ASM(dtls1_buffer_message)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_buffer_record
#  define dtls1_buffer_record OPENSSL_MANGLER(dtls1_buffer_record)
# endif
#else
# ifndef _dtls1_buffer_record
#  define _dtls1_buffer_record OPENSSL_MANGLER_ASM(dtls1_buffer_record)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_check_timeout_num
#  define dtls1_check_timeout_num OPENSSL_MANGLER(dtls1_check_timeout_num)
# endif
#else
# ifndef _dtls1_check_timeout_num
#  define _dtls1_check_timeout_num OPENSSL_MANGLER_ASM(dtls1_check_timeout_num)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_clear
#  define dtls1_clear OPENSSL_MANGLER(dtls1_clear)
# endif
#else
# ifndef _dtls1_clear
#  define _dtls1_clear OPENSSL_MANGLER_ASM(dtls1_clear)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_clear_received_buffer
#  define dtls1_clear_received_buffer OPENSSL_MANGLER(dtls1_clear_received_buffer)
# endif
#else
# ifndef _dtls1_clear_received_buffer
#  define _dtls1_clear_received_buffer OPENSSL_MANGLER_ASM(dtls1_clear_received_buffer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_clear_sent_buffer
#  define dtls1_clear_sent_buffer OPENSSL_MANGLER(dtls1_clear_sent_buffer)
# endif
#else
# ifndef _dtls1_clear_sent_buffer
#  define _dtls1_clear_sent_buffer OPENSSL_MANGLER_ASM(dtls1_clear_sent_buffer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_close_construct_packet
#  define dtls1_close_construct_packet OPENSSL_MANGLER(dtls1_close_construct_packet)
# endif
#else
# ifndef _dtls1_close_construct_packet
#  define _dtls1_close_construct_packet OPENSSL_MANGLER_ASM(dtls1_close_construct_packet)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_ctrl
#  define dtls1_ctrl OPENSSL_MANGLER(dtls1_ctrl)
# endif
#else
# ifndef _dtls1_ctrl
#  define _dtls1_ctrl OPENSSL_MANGLER_ASM(dtls1_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_default_timeout
#  define dtls1_default_timeout OPENSSL_MANGLER(dtls1_default_timeout)
# endif
#else
# ifndef _dtls1_default_timeout
#  define _dtls1_default_timeout OPENSSL_MANGLER_ASM(dtls1_default_timeout)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_dispatch_alert
#  define dtls1_dispatch_alert OPENSSL_MANGLER(dtls1_dispatch_alert)
# endif
#else
# ifndef _dtls1_dispatch_alert
#  define _dtls1_dispatch_alert OPENSSL_MANGLER_ASM(dtls1_dispatch_alert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_double_timeout
#  define dtls1_double_timeout OPENSSL_MANGLER(dtls1_double_timeout)
# endif
#else
# ifndef _dtls1_double_timeout
#  define _dtls1_double_timeout OPENSSL_MANGLER_ASM(dtls1_double_timeout)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_do_write
#  define dtls1_do_write OPENSSL_MANGLER(dtls1_do_write)
# endif
#else
# ifndef _dtls1_do_write
#  define _dtls1_do_write OPENSSL_MANGLER_ASM(dtls1_do_write)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_free
#  define dtls1_free OPENSSL_MANGLER(dtls1_free)
# endif
#else
# ifndef _dtls1_free
#  define _dtls1_free OPENSSL_MANGLER_ASM(dtls1_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_get_bitmap
#  define dtls1_get_bitmap OPENSSL_MANGLER(dtls1_get_bitmap)
# endif
#else
# ifndef _dtls1_get_bitmap
#  define _dtls1_get_bitmap OPENSSL_MANGLER_ASM(dtls1_get_bitmap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_get_message_header
#  define dtls1_get_message_header OPENSSL_MANGLER(dtls1_get_message_header)
# endif
#else
# ifndef _dtls1_get_message_header
#  define _dtls1_get_message_header OPENSSL_MANGLER_ASM(dtls1_get_message_header)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_get_queue_priority
#  define dtls1_get_queue_priority OPENSSL_MANGLER(dtls1_get_queue_priority)
# endif
#else
# ifndef _dtls1_get_queue_priority
#  define _dtls1_get_queue_priority OPENSSL_MANGLER_ASM(dtls1_get_queue_priority)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_get_record
#  define dtls1_get_record OPENSSL_MANGLER(dtls1_get_record)
# endif
#else
# ifndef _dtls1_get_record
#  define _dtls1_get_record OPENSSL_MANGLER_ASM(dtls1_get_record)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_get_timeout
#  define dtls1_get_timeout OPENSSL_MANGLER(dtls1_get_timeout)
# endif
#else
# ifndef _dtls1_get_timeout
#  define _dtls1_get_timeout OPENSSL_MANGLER_ASM(dtls1_get_timeout)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_handle_timeout
#  define dtls1_handle_timeout OPENSSL_MANGLER(dtls1_handle_timeout)
# endif
#else
# ifndef _dtls1_handle_timeout
#  define _dtls1_handle_timeout OPENSSL_MANGLER_ASM(dtls1_handle_timeout)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_hm_fragment_free
#  define dtls1_hm_fragment_free OPENSSL_MANGLER(dtls1_hm_fragment_free)
# endif
#else
# ifndef _dtls1_hm_fragment_free
#  define _dtls1_hm_fragment_free OPENSSL_MANGLER_ASM(dtls1_hm_fragment_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_is_timer_expired
#  define dtls1_is_timer_expired OPENSSL_MANGLER(dtls1_is_timer_expired)
# endif
#else
# ifndef _dtls1_is_timer_expired
#  define _dtls1_is_timer_expired OPENSSL_MANGLER_ASM(dtls1_is_timer_expired)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_min_mtu
#  define dtls1_min_mtu OPENSSL_MANGLER(dtls1_min_mtu)
# endif
#else
# ifndef _dtls1_min_mtu
#  define _dtls1_min_mtu OPENSSL_MANGLER_ASM(dtls1_min_mtu)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_new
#  define dtls1_new OPENSSL_MANGLER(dtls1_new)
# endif
#else
# ifndef _dtls1_new
#  define _dtls1_new OPENSSL_MANGLER_ASM(dtls1_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_process_buffered_records
#  define dtls1_process_buffered_records OPENSSL_MANGLER(dtls1_process_buffered_records)
# endif
#else
# ifndef _dtls1_process_buffered_records
#  define _dtls1_process_buffered_records OPENSSL_MANGLER_ASM(dtls1_process_buffered_records)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_process_record
#  define dtls1_process_record OPENSSL_MANGLER(dtls1_process_record)
# endif
#else
# ifndef _dtls1_process_record
#  define _dtls1_process_record OPENSSL_MANGLER_ASM(dtls1_process_record)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_query_mtu
#  define dtls1_query_mtu OPENSSL_MANGLER(dtls1_query_mtu)
# endif
#else
# ifndef _dtls1_query_mtu
#  define _dtls1_query_mtu OPENSSL_MANGLER_ASM(dtls1_query_mtu)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_read_bytes
#  define dtls1_read_bytes OPENSSL_MANGLER(dtls1_read_bytes)
# endif
#else
# ifndef _dtls1_read_bytes
#  define _dtls1_read_bytes OPENSSL_MANGLER_ASM(dtls1_read_bytes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_read_failed
#  define dtls1_read_failed OPENSSL_MANGLER(dtls1_read_failed)
# endif
#else
# ifndef _dtls1_read_failed
#  define _dtls1_read_failed OPENSSL_MANGLER_ASM(dtls1_read_failed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_record_bitmap_update
#  define dtls1_record_bitmap_update OPENSSL_MANGLER(dtls1_record_bitmap_update)
# endif
#else
# ifndef _dtls1_record_bitmap_update
#  define _dtls1_record_bitmap_update OPENSSL_MANGLER_ASM(dtls1_record_bitmap_update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_record_replay_check
#  define dtls1_record_replay_check OPENSSL_MANGLER(dtls1_record_replay_check)
# endif
#else
# ifndef _dtls1_record_replay_check
#  define _dtls1_record_replay_check OPENSSL_MANGLER_ASM(dtls1_record_replay_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_reset_seq_numbers
#  define dtls1_reset_seq_numbers OPENSSL_MANGLER(dtls1_reset_seq_numbers)
# endif
#else
# ifndef _dtls1_reset_seq_numbers
#  define _dtls1_reset_seq_numbers OPENSSL_MANGLER_ASM(dtls1_reset_seq_numbers)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_retransmit_buffered_messages
#  define dtls1_retransmit_buffered_messages OPENSSL_MANGLER(dtls1_retransmit_buffered_messages)
# endif
#else
# ifndef _dtls1_retransmit_buffered_messages
#  define _dtls1_retransmit_buffered_messages OPENSSL_MANGLER_ASM(dtls1_retransmit_buffered_messages)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_retransmit_message
#  define dtls1_retransmit_message OPENSSL_MANGLER(dtls1_retransmit_message)
# endif
#else
# ifndef _dtls1_retransmit_message
#  define _dtls1_retransmit_message OPENSSL_MANGLER_ASM(dtls1_retransmit_message)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_retrieve_buffered_record
#  define dtls1_retrieve_buffered_record OPENSSL_MANGLER(dtls1_retrieve_buffered_record)
# endif
#else
# ifndef _dtls1_retrieve_buffered_record
#  define _dtls1_retrieve_buffered_record OPENSSL_MANGLER_ASM(dtls1_retrieve_buffered_record)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_set_handshake_header
#  define dtls1_set_handshake_header OPENSSL_MANGLER(dtls1_set_handshake_header)
# endif
#else
# ifndef _dtls1_set_handshake_header
#  define _dtls1_set_handshake_header OPENSSL_MANGLER_ASM(dtls1_set_handshake_header)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_set_message_header
#  define dtls1_set_message_header OPENSSL_MANGLER(dtls1_set_message_header)
# endif
#else
# ifndef _dtls1_set_message_header
#  define _dtls1_set_message_header OPENSSL_MANGLER_ASM(dtls1_set_message_header)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_shutdown
#  define dtls1_shutdown OPENSSL_MANGLER(dtls1_shutdown)
# endif
#else
# ifndef _dtls1_shutdown
#  define _dtls1_shutdown OPENSSL_MANGLER_ASM(dtls1_shutdown)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_start_timer
#  define dtls1_start_timer OPENSSL_MANGLER(dtls1_start_timer)
# endif
#else
# ifndef _dtls1_start_timer
#  define _dtls1_start_timer OPENSSL_MANGLER_ASM(dtls1_start_timer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_stop_timer
#  define dtls1_stop_timer OPENSSL_MANGLER(dtls1_stop_timer)
# endif
#else
# ifndef _dtls1_stop_timer
#  define _dtls1_stop_timer OPENSSL_MANGLER_ASM(dtls1_stop_timer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_write_app_data_bytes
#  define dtls1_write_app_data_bytes OPENSSL_MANGLER(dtls1_write_app_data_bytes)
# endif
#else
# ifndef _dtls1_write_app_data_bytes
#  define _dtls1_write_app_data_bytes OPENSSL_MANGLER_ASM(dtls1_write_app_data_bytes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls1_write_bytes
#  define dtls1_write_bytes OPENSSL_MANGLER(dtls1_write_bytes)
# endif
#else
# ifndef _dtls1_write_bytes
#  define _dtls1_write_bytes OPENSSL_MANGLER_ASM(dtls1_write_bytes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls_bad_ver_client_method
#  define dtls_bad_ver_client_method OPENSSL_MANGLER(dtls_bad_ver_client_method)
# endif
#else
# ifndef _dtls_bad_ver_client_method
#  define _dtls_bad_ver_client_method OPENSSL_MANGLER_ASM(dtls_bad_ver_client_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls_buffer_listen_record
#  define dtls_buffer_listen_record OPENSSL_MANGLER(dtls_buffer_listen_record)
# endif
#else
# ifndef _dtls_buffer_listen_record
#  define _dtls_buffer_listen_record OPENSSL_MANGLER_ASM(dtls_buffer_listen_record)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLS_client_method
#  define DTLS_client_method OPENSSL_MANGLER(DTLS_client_method)
# endif
#else
# ifndef _DTLS_client_method
#  define _DTLS_client_method OPENSSL_MANGLER_ASM(DTLS_client_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls_construct_change_cipher_spec
#  define dtls_construct_change_cipher_spec OPENSSL_MANGLER(dtls_construct_change_cipher_spec)
# endif
#else
# ifndef _dtls_construct_change_cipher_spec
#  define _dtls_construct_change_cipher_spec OPENSSL_MANGLER_ASM(dtls_construct_change_cipher_spec)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls_construct_hello_verify_request
#  define dtls_construct_hello_verify_request OPENSSL_MANGLER(dtls_construct_hello_verify_request)
# endif
#else
# ifndef _dtls_construct_hello_verify_request
#  define _dtls_construct_hello_verify_request OPENSSL_MANGLER_ASM(dtls_construct_hello_verify_request)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLS_get_data_mtu
#  define DTLS_get_data_mtu OPENSSL_MANGLER(DTLS_get_data_mtu)
# endif
#else
# ifndef _DTLS_get_data_mtu
#  define _DTLS_get_data_mtu OPENSSL_MANGLER_ASM(DTLS_get_data_mtu)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls_get_message
#  define dtls_get_message OPENSSL_MANGLER(dtls_get_message)
# endif
#else
# ifndef _dtls_get_message
#  define _dtls_get_message OPENSSL_MANGLER_ASM(dtls_get_message)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLS_method
#  define DTLS_method OPENSSL_MANGLER(DTLS_method)
# endif
#else
# ifndef _DTLS_method
#  define _DTLS_method OPENSSL_MANGLER_ASM(DTLS_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls_process_hello_verify
#  define dtls_process_hello_verify OPENSSL_MANGLER(dtls_process_hello_verify)
# endif
#else
# ifndef _dtls_process_hello_verify
#  define _dtls_process_hello_verify OPENSSL_MANGLER_ASM(dtls_process_hello_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtls_raw_hello_verify_request
#  define dtls_raw_hello_verify_request OPENSSL_MANGLER(dtls_raw_hello_verify_request)
# endif
#else
# ifndef _dtls_raw_hello_verify_request
#  define _dtls_raw_hello_verify_request OPENSSL_MANGLER_ASM(dtls_raw_hello_verify_request)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLS_RECORD_LAYER_clear
#  define DTLS_RECORD_LAYER_clear OPENSSL_MANGLER(DTLS_RECORD_LAYER_clear)
# endif
#else
# ifndef _DTLS_RECORD_LAYER_clear
#  define _DTLS_RECORD_LAYER_clear OPENSSL_MANGLER_ASM(DTLS_RECORD_LAYER_clear)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLS_RECORD_LAYER_free
#  define DTLS_RECORD_LAYER_free OPENSSL_MANGLER(DTLS_RECORD_LAYER_free)
# endif
#else
# ifndef _DTLS_RECORD_LAYER_free
#  define _DTLS_RECORD_LAYER_free OPENSSL_MANGLER_ASM(DTLS_RECORD_LAYER_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLS_RECORD_LAYER_new
#  define DTLS_RECORD_LAYER_new OPENSSL_MANGLER(DTLS_RECORD_LAYER_new)
# endif
#else
# ifndef _DTLS_RECORD_LAYER_new
#  define _DTLS_RECORD_LAYER_new OPENSSL_MANGLER_ASM(DTLS_RECORD_LAYER_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLS_RECORD_LAYER_set_saved_w_epoch
#  define DTLS_RECORD_LAYER_set_saved_w_epoch OPENSSL_MANGLER(DTLS_RECORD_LAYER_set_saved_w_epoch)
# endif
#else
# ifndef _DTLS_RECORD_LAYER_set_saved_w_epoch
#  define _DTLS_RECORD_LAYER_set_saved_w_epoch OPENSSL_MANGLER_ASM(DTLS_RECORD_LAYER_set_saved_w_epoch)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLS_RECORD_LAYER_set_write_sequence
#  define DTLS_RECORD_LAYER_set_write_sequence OPENSSL_MANGLER(DTLS_RECORD_LAYER_set_write_sequence)
# endif
#else
# ifndef _DTLS_RECORD_LAYER_set_write_sequence
#  define _DTLS_RECORD_LAYER_set_write_sequence OPENSSL_MANGLER_ASM(DTLS_RECORD_LAYER_set_write_sequence)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLS_server_method
#  define DTLS_server_method OPENSSL_MANGLER(DTLS_server_method)
# endif
#else
# ifndef _DTLS_server_method
#  define _DTLS_server_method OPENSSL_MANGLER_ASM(DTLS_server_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLS_set_timer_cb
#  define DTLS_set_timer_cb OPENSSL_MANGLER(DTLS_set_timer_cb)
# endif
#else
# ifndef _DTLS_set_timer_cb
#  define _DTLS_set_timer_cb OPENSSL_MANGLER_ASM(DTLS_set_timer_cb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtlsv1_2_client_method
#  define dtlsv1_2_client_method OPENSSL_MANGLER(dtlsv1_2_client_method)
# endif
#else
# ifndef _dtlsv1_2_client_method
#  define _dtlsv1_2_client_method OPENSSL_MANGLER_ASM(dtlsv1_2_client_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLSv1_2_client_method
#  define DTLSv1_2_client_method OPENSSL_MANGLER(DTLSv1_2_client_method)
# endif
#else
# ifndef _DTLSv1_2_client_method
#  define _DTLSv1_2_client_method OPENSSL_MANGLER_ASM(DTLSv1_2_client_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLSv1_2_enc_data
#  define DTLSv1_2_enc_data OPENSSL_MANGLER(DTLSv1_2_enc_data)
# endif
#else
# ifndef _DTLSv1_2_enc_data
#  define _DTLSv1_2_enc_data OPENSSL_MANGLER_ASM(DTLSv1_2_enc_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtlsv1_2_method
#  define dtlsv1_2_method OPENSSL_MANGLER(dtlsv1_2_method)
# endif
#else
# ifndef _dtlsv1_2_method
#  define _dtlsv1_2_method OPENSSL_MANGLER_ASM(dtlsv1_2_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLSv1_2_method
#  define DTLSv1_2_method OPENSSL_MANGLER(DTLSv1_2_method)
# endif
#else
# ifndef _DTLSv1_2_method
#  define _DTLSv1_2_method OPENSSL_MANGLER_ASM(DTLSv1_2_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtlsv1_2_server_method
#  define dtlsv1_2_server_method OPENSSL_MANGLER(dtlsv1_2_server_method)
# endif
#else
# ifndef _dtlsv1_2_server_method
#  define _dtlsv1_2_server_method OPENSSL_MANGLER_ASM(dtlsv1_2_server_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLSv1_2_server_method
#  define DTLSv1_2_server_method OPENSSL_MANGLER(DTLSv1_2_server_method)
# endif
#else
# ifndef _DTLSv1_2_server_method
#  define _DTLSv1_2_server_method OPENSSL_MANGLER_ASM(DTLSv1_2_server_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtlsv1_client_method
#  define dtlsv1_client_method OPENSSL_MANGLER(dtlsv1_client_method)
# endif
#else
# ifndef _dtlsv1_client_method
#  define _dtlsv1_client_method OPENSSL_MANGLER_ASM(dtlsv1_client_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLSv1_client_method
#  define DTLSv1_client_method OPENSSL_MANGLER(DTLSv1_client_method)
# endif
#else
# ifndef _DTLSv1_client_method
#  define _DTLSv1_client_method OPENSSL_MANGLER_ASM(DTLSv1_client_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLSv1_enc_data
#  define DTLSv1_enc_data OPENSSL_MANGLER(DTLSv1_enc_data)
# endif
#else
# ifndef _DTLSv1_enc_data
#  define _DTLSv1_enc_data OPENSSL_MANGLER_ASM(DTLSv1_enc_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLSv1_listen
#  define DTLSv1_listen OPENSSL_MANGLER(DTLSv1_listen)
# endif
#else
# ifndef _DTLSv1_listen
#  define _DTLSv1_listen OPENSSL_MANGLER_ASM(DTLSv1_listen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtlsv1_method
#  define dtlsv1_method OPENSSL_MANGLER(dtlsv1_method)
# endif
#else
# ifndef _dtlsv1_method
#  define _dtlsv1_method OPENSSL_MANGLER_ASM(dtlsv1_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLSv1_method
#  define DTLSv1_method OPENSSL_MANGLER(DTLSv1_method)
# endif
#else
# ifndef _DTLSv1_method
#  define _DTLSv1_method OPENSSL_MANGLER_ASM(DTLSv1_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef dtlsv1_server_method
#  define dtlsv1_server_method OPENSSL_MANGLER(dtlsv1_server_method)
# endif
#else
# ifndef _dtlsv1_server_method
#  define _dtlsv1_server_method OPENSSL_MANGLER_ASM(dtlsv1_server_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef DTLSv1_server_method
#  define DTLSv1_server_method OPENSSL_MANGLER(DTLSv1_server_method)
# endif
#else
# ifndef _DTLSv1_server_method
#  define _DTLSv1_server_method OPENSSL_MANGLER_ASM(DTLSv1_server_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef early_data_count_ok
#  define early_data_count_ok OPENSSL_MANGLER(early_data_count_ok)
# endif
#else
# ifndef _early_data_count_ok
#  define _early_data_count_ok OPENSSL_MANGLER_ASM(early_data_count_ok)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_curve_nid2nist
#  define EC_curve_nid2nist OPENSSL_MANGLER(EC_curve_nid2nist)
# endif
#else
# ifndef _EC_curve_nid2nist
#  define _EC_curve_nid2nist OPENSSL_MANGLER_ASM(EC_curve_nid2nist)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_curve_nist2nid
#  define EC_curve_nist2nid OPENSSL_MANGLER(EC_curve_nist2nid)
# endif
#else
# ifndef _EC_curve_nist2nid
#  define _EC_curve_nist2nid OPENSSL_MANGLER_ASM(EC_curve_nist2nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDH_compute_key
#  define ECDH_compute_key OPENSSL_MANGLER(ECDH_compute_key)
# endif
#else
# ifndef _ECDH_compute_key
#  define _ECDH_compute_key OPENSSL_MANGLER_ASM(ECDH_compute_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDH_KDF_X9_62
#  define ECDH_KDF_X9_62 OPENSSL_MANGLER(ECDH_KDF_X9_62)
# endif
#else
# ifndef _ECDH_KDF_X9_62
#  define _ECDH_KDF_X9_62 OPENSSL_MANGLER_ASM(ECDH_KDF_X9_62)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecdh_KDF_X9_63
#  define ecdh_KDF_X9_63 OPENSSL_MANGLER(ecdh_KDF_X9_63)
# endif
#else
# ifndef _ecdh_KDF_X9_63
#  define _ecdh_KDF_X9_63 OPENSSL_MANGLER_ASM(ecdh_KDF_X9_63)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecdh_simple_compute_key
#  define ecdh_simple_compute_key OPENSSL_MANGLER(ecdh_simple_compute_key)
# endif
#else
# ifndef _ecdh_simple_compute_key
#  define _ecdh_simple_compute_key OPENSSL_MANGLER_ASM(ecdh_simple_compute_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_do_sign
#  define ECDSA_do_sign OPENSSL_MANGLER(ECDSA_do_sign)
# endif
#else
# ifndef _ECDSA_do_sign
#  define _ECDSA_do_sign OPENSSL_MANGLER_ASM(ECDSA_do_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_do_sign_ex
#  define ECDSA_do_sign_ex OPENSSL_MANGLER(ECDSA_do_sign_ex)
# endif
#else
# ifndef _ECDSA_do_sign_ex
#  define _ECDSA_do_sign_ex OPENSSL_MANGLER_ASM(ECDSA_do_sign_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_do_verify
#  define ECDSA_do_verify OPENSSL_MANGLER(ECDSA_do_verify)
# endif
#else
# ifndef _ECDSA_do_verify
#  define _ECDSA_do_verify OPENSSL_MANGLER_ASM(ECDSA_do_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_SIG_free
#  define ECDSA_SIG_free OPENSSL_MANGLER(ECDSA_SIG_free)
# endif
#else
# ifndef _ECDSA_SIG_free
#  define _ECDSA_SIG_free OPENSSL_MANGLER_ASM(ECDSA_SIG_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_SIG_get0
#  define ECDSA_SIG_get0 OPENSSL_MANGLER(ECDSA_SIG_get0)
# endif
#else
# ifndef _ECDSA_SIG_get0
#  define _ECDSA_SIG_get0 OPENSSL_MANGLER_ASM(ECDSA_SIG_get0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_SIG_get0_r
#  define ECDSA_SIG_get0_r OPENSSL_MANGLER(ECDSA_SIG_get0_r)
# endif
#else
# ifndef _ECDSA_SIG_get0_r
#  define _ECDSA_SIG_get0_r OPENSSL_MANGLER_ASM(ECDSA_SIG_get0_r)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_SIG_get0_s
#  define ECDSA_SIG_get0_s OPENSSL_MANGLER(ECDSA_SIG_get0_s)
# endif
#else
# ifndef _ECDSA_SIG_get0_s
#  define _ECDSA_SIG_get0_s OPENSSL_MANGLER_ASM(ECDSA_SIG_get0_s)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_sign
#  define ECDSA_sign OPENSSL_MANGLER(ECDSA_sign)
# endif
#else
# ifndef _ECDSA_sign
#  define _ECDSA_sign OPENSSL_MANGLER_ASM(ECDSA_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_SIG_new
#  define ECDSA_SIG_new OPENSSL_MANGLER(ECDSA_SIG_new)
# endif
#else
# ifndef _ECDSA_SIG_new
#  define _ECDSA_SIG_new OPENSSL_MANGLER_ASM(ECDSA_SIG_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_sign_ex
#  define ECDSA_sign_ex OPENSSL_MANGLER(ECDSA_sign_ex)
# endif
#else
# ifndef _ECDSA_sign_ex
#  define _ECDSA_sign_ex OPENSSL_MANGLER_ASM(ECDSA_sign_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_sign_setup
#  define ECDSA_sign_setup OPENSSL_MANGLER(ECDSA_sign_setup)
# endif
#else
# ifndef _ECDSA_sign_setup
#  define _ECDSA_sign_setup OPENSSL_MANGLER_ASM(ECDSA_sign_setup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_SIG_set0
#  define ECDSA_SIG_set0 OPENSSL_MANGLER(ECDSA_SIG_set0)
# endif
#else
# ifndef _ECDSA_SIG_set0
#  define _ECDSA_SIG_set0 OPENSSL_MANGLER_ASM(ECDSA_SIG_set0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_size
#  define ECDSA_size OPENSSL_MANGLER(ECDSA_size)
# endif
#else
# ifndef _ECDSA_size
#  define _ECDSA_size OPENSSL_MANGLER_ASM(ECDSA_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECDSA_verify
#  define ECDSA_verify OPENSSL_MANGLER(ECDSA_verify)
# endif
#else
# ifndef _ECDSA_verify
#  define _ECDSA_verify OPENSSL_MANGLER_ASM(ECDSA_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_ec_pre_comp_dup
#  define EC_ec_pre_comp_dup OPENSSL_MANGLER(EC_ec_pre_comp_dup)
# endif
#else
# ifndef _EC_ec_pre_comp_dup
#  define _EC_ec_pre_comp_dup OPENSSL_MANGLER_ASM(EC_ec_pre_comp_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_ec_pre_comp_free
#  define EC_ec_pre_comp_free OPENSSL_MANGLER(EC_ec_pre_comp_free)
# endif
#else
# ifndef _EC_ec_pre_comp_free
#  define _EC_ec_pre_comp_free OPENSSL_MANGLER_ASM(EC_ec_pre_comp_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_get_builtin_curves
#  define EC_get_builtin_curves OPENSSL_MANGLER(EC_get_builtin_curves)
# endif
#else
# ifndef _EC_get_builtin_curves
#  define _EC_get_builtin_curves OPENSSL_MANGLER_ASM(EC_get_builtin_curves)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_add
#  define ec_GF2m_simple_add OPENSSL_MANGLER(ec_GF2m_simple_add)
# endif
#else
# ifndef _ec_GF2m_simple_add
#  define _ec_GF2m_simple_add OPENSSL_MANGLER_ASM(ec_GF2m_simple_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_cmp
#  define ec_GF2m_simple_cmp OPENSSL_MANGLER(ec_GF2m_simple_cmp)
# endif
#else
# ifndef _ec_GF2m_simple_cmp
#  define _ec_GF2m_simple_cmp OPENSSL_MANGLER_ASM(ec_GF2m_simple_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_dbl
#  define ec_GF2m_simple_dbl OPENSSL_MANGLER(ec_GF2m_simple_dbl)
# endif
#else
# ifndef _ec_GF2m_simple_dbl
#  define _ec_GF2m_simple_dbl OPENSSL_MANGLER_ASM(ec_GF2m_simple_dbl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_field_div
#  define ec_GF2m_simple_field_div OPENSSL_MANGLER(ec_GF2m_simple_field_div)
# endif
#else
# ifndef _ec_GF2m_simple_field_div
#  define _ec_GF2m_simple_field_div OPENSSL_MANGLER_ASM(ec_GF2m_simple_field_div)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_field_mul
#  define ec_GF2m_simple_field_mul OPENSSL_MANGLER(ec_GF2m_simple_field_mul)
# endif
#else
# ifndef _ec_GF2m_simple_field_mul
#  define _ec_GF2m_simple_field_mul OPENSSL_MANGLER_ASM(ec_GF2m_simple_field_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_field_sqr
#  define ec_GF2m_simple_field_sqr OPENSSL_MANGLER(ec_GF2m_simple_field_sqr)
# endif
#else
# ifndef _ec_GF2m_simple_field_sqr
#  define _ec_GF2m_simple_field_sqr OPENSSL_MANGLER_ASM(ec_GF2m_simple_field_sqr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_group_check_discriminant
#  define ec_GF2m_simple_group_check_discriminant OPENSSL_MANGLER(ec_GF2m_simple_group_check_discriminant)
# endif
#else
# ifndef _ec_GF2m_simple_group_check_discriminant
#  define _ec_GF2m_simple_group_check_discriminant OPENSSL_MANGLER_ASM(ec_GF2m_simple_group_check_discriminant)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_group_clear_finish
#  define ec_GF2m_simple_group_clear_finish OPENSSL_MANGLER(ec_GF2m_simple_group_clear_finish)
# endif
#else
# ifndef _ec_GF2m_simple_group_clear_finish
#  define _ec_GF2m_simple_group_clear_finish OPENSSL_MANGLER_ASM(ec_GF2m_simple_group_clear_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_group_copy
#  define ec_GF2m_simple_group_copy OPENSSL_MANGLER(ec_GF2m_simple_group_copy)
# endif
#else
# ifndef _ec_GF2m_simple_group_copy
#  define _ec_GF2m_simple_group_copy OPENSSL_MANGLER_ASM(ec_GF2m_simple_group_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_group_finish
#  define ec_GF2m_simple_group_finish OPENSSL_MANGLER(ec_GF2m_simple_group_finish)
# endif
#else
# ifndef _ec_GF2m_simple_group_finish
#  define _ec_GF2m_simple_group_finish OPENSSL_MANGLER_ASM(ec_GF2m_simple_group_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_group_get_curve
#  define ec_GF2m_simple_group_get_curve OPENSSL_MANGLER(ec_GF2m_simple_group_get_curve)
# endif
#else
# ifndef _ec_GF2m_simple_group_get_curve
#  define _ec_GF2m_simple_group_get_curve OPENSSL_MANGLER_ASM(ec_GF2m_simple_group_get_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_group_get_degree
#  define ec_GF2m_simple_group_get_degree OPENSSL_MANGLER(ec_GF2m_simple_group_get_degree)
# endif
#else
# ifndef _ec_GF2m_simple_group_get_degree
#  define _ec_GF2m_simple_group_get_degree OPENSSL_MANGLER_ASM(ec_GF2m_simple_group_get_degree)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_group_init
#  define ec_GF2m_simple_group_init OPENSSL_MANGLER(ec_GF2m_simple_group_init)
# endif
#else
# ifndef _ec_GF2m_simple_group_init
#  define _ec_GF2m_simple_group_init OPENSSL_MANGLER_ASM(ec_GF2m_simple_group_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_group_set_curve
#  define ec_GF2m_simple_group_set_curve OPENSSL_MANGLER(ec_GF2m_simple_group_set_curve)
# endif
#else
# ifndef _ec_GF2m_simple_group_set_curve
#  define _ec_GF2m_simple_group_set_curve OPENSSL_MANGLER_ASM(ec_GF2m_simple_group_set_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_invert
#  define ec_GF2m_simple_invert OPENSSL_MANGLER(ec_GF2m_simple_invert)
# endif
#else
# ifndef _ec_GF2m_simple_invert
#  define _ec_GF2m_simple_invert OPENSSL_MANGLER_ASM(ec_GF2m_simple_invert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_is_at_infinity
#  define ec_GF2m_simple_is_at_infinity OPENSSL_MANGLER(ec_GF2m_simple_is_at_infinity)
# endif
#else
# ifndef _ec_GF2m_simple_is_at_infinity
#  define _ec_GF2m_simple_is_at_infinity OPENSSL_MANGLER_ASM(ec_GF2m_simple_is_at_infinity)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_is_on_curve
#  define ec_GF2m_simple_is_on_curve OPENSSL_MANGLER(ec_GF2m_simple_is_on_curve)
# endif
#else
# ifndef _ec_GF2m_simple_is_on_curve
#  define _ec_GF2m_simple_is_on_curve OPENSSL_MANGLER_ASM(ec_GF2m_simple_is_on_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_make_affine
#  define ec_GF2m_simple_make_affine OPENSSL_MANGLER(ec_GF2m_simple_make_affine)
# endif
#else
# ifndef _ec_GF2m_simple_make_affine
#  define _ec_GF2m_simple_make_affine OPENSSL_MANGLER_ASM(ec_GF2m_simple_make_affine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GF2m_simple_method
#  define EC_GF2m_simple_method OPENSSL_MANGLER(EC_GF2m_simple_method)
# endif
#else
# ifndef _EC_GF2m_simple_method
#  define _EC_GF2m_simple_method OPENSSL_MANGLER_ASM(EC_GF2m_simple_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_oct2point
#  define ec_GF2m_simple_oct2point OPENSSL_MANGLER(ec_GF2m_simple_oct2point)
# endif
#else
# ifndef _ec_GF2m_simple_oct2point
#  define _ec_GF2m_simple_oct2point OPENSSL_MANGLER_ASM(ec_GF2m_simple_oct2point)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_point2oct
#  define ec_GF2m_simple_point2oct OPENSSL_MANGLER(ec_GF2m_simple_point2oct)
# endif
#else
# ifndef _ec_GF2m_simple_point2oct
#  define _ec_GF2m_simple_point2oct OPENSSL_MANGLER_ASM(ec_GF2m_simple_point2oct)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_point_clear_finish
#  define ec_GF2m_simple_point_clear_finish OPENSSL_MANGLER(ec_GF2m_simple_point_clear_finish)
# endif
#else
# ifndef _ec_GF2m_simple_point_clear_finish
#  define _ec_GF2m_simple_point_clear_finish OPENSSL_MANGLER_ASM(ec_GF2m_simple_point_clear_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_point_copy
#  define ec_GF2m_simple_point_copy OPENSSL_MANGLER(ec_GF2m_simple_point_copy)
# endif
#else
# ifndef _ec_GF2m_simple_point_copy
#  define _ec_GF2m_simple_point_copy OPENSSL_MANGLER_ASM(ec_GF2m_simple_point_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_point_finish
#  define ec_GF2m_simple_point_finish OPENSSL_MANGLER(ec_GF2m_simple_point_finish)
# endif
#else
# ifndef _ec_GF2m_simple_point_finish
#  define _ec_GF2m_simple_point_finish OPENSSL_MANGLER_ASM(ec_GF2m_simple_point_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_point_get_affine_coordinates
#  define ec_GF2m_simple_point_get_affine_coordinates OPENSSL_MANGLER(ec_GF2m_simple_point_get_affine_coordinates)
# endif
#else
# ifndef _ec_GF2m_simple_point_get_affine_coordinates
#  define _ec_GF2m_simple_point_get_affine_coordinates OPENSSL_MANGLER_ASM(ec_GF2m_simple_point_get_affine_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_point_init
#  define ec_GF2m_simple_point_init OPENSSL_MANGLER(ec_GF2m_simple_point_init)
# endif
#else
# ifndef _ec_GF2m_simple_point_init
#  define _ec_GF2m_simple_point_init OPENSSL_MANGLER_ASM(ec_GF2m_simple_point_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_point_set_affine_coordinates
#  define ec_GF2m_simple_point_set_affine_coordinates OPENSSL_MANGLER(ec_GF2m_simple_point_set_affine_coordinates)
# endif
#else
# ifndef _ec_GF2m_simple_point_set_affine_coordinates
#  define _ec_GF2m_simple_point_set_affine_coordinates OPENSSL_MANGLER_ASM(ec_GF2m_simple_point_set_affine_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_point_set_to_infinity
#  define ec_GF2m_simple_point_set_to_infinity OPENSSL_MANGLER(ec_GF2m_simple_point_set_to_infinity)
# endif
#else
# ifndef _ec_GF2m_simple_point_set_to_infinity
#  define _ec_GF2m_simple_point_set_to_infinity OPENSSL_MANGLER_ASM(ec_GF2m_simple_point_set_to_infinity)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_points_make_affine
#  define ec_GF2m_simple_points_make_affine OPENSSL_MANGLER(ec_GF2m_simple_points_make_affine)
# endif
#else
# ifndef _ec_GF2m_simple_points_make_affine
#  define _ec_GF2m_simple_points_make_affine OPENSSL_MANGLER_ASM(ec_GF2m_simple_points_make_affine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GF2m_simple_set_compressed_coordinates
#  define ec_GF2m_simple_set_compressed_coordinates OPENSSL_MANGLER(ec_GF2m_simple_set_compressed_coordinates)
# endif
#else
# ifndef _ec_GF2m_simple_set_compressed_coordinates
#  define _ec_GF2m_simple_set_compressed_coordinates OPENSSL_MANGLER_ASM(ec_GF2m_simple_set_compressed_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_field_decode
#  define ec_GFp_mont_field_decode OPENSSL_MANGLER(ec_GFp_mont_field_decode)
# endif
#else
# ifndef _ec_GFp_mont_field_decode
#  define _ec_GFp_mont_field_decode OPENSSL_MANGLER_ASM(ec_GFp_mont_field_decode)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_field_encode
#  define ec_GFp_mont_field_encode OPENSSL_MANGLER(ec_GFp_mont_field_encode)
# endif
#else
# ifndef _ec_GFp_mont_field_encode
#  define _ec_GFp_mont_field_encode OPENSSL_MANGLER_ASM(ec_GFp_mont_field_encode)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_field_inv
#  define ec_GFp_mont_field_inv OPENSSL_MANGLER(ec_GFp_mont_field_inv)
# endif
#else
# ifndef _ec_GFp_mont_field_inv
#  define _ec_GFp_mont_field_inv OPENSSL_MANGLER_ASM(ec_GFp_mont_field_inv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_field_mul
#  define ec_GFp_mont_field_mul OPENSSL_MANGLER(ec_GFp_mont_field_mul)
# endif
#else
# ifndef _ec_GFp_mont_field_mul
#  define _ec_GFp_mont_field_mul OPENSSL_MANGLER_ASM(ec_GFp_mont_field_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_field_set_to_one
#  define ec_GFp_mont_field_set_to_one OPENSSL_MANGLER(ec_GFp_mont_field_set_to_one)
# endif
#else
# ifndef _ec_GFp_mont_field_set_to_one
#  define _ec_GFp_mont_field_set_to_one OPENSSL_MANGLER_ASM(ec_GFp_mont_field_set_to_one)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_field_sqr
#  define ec_GFp_mont_field_sqr OPENSSL_MANGLER(ec_GFp_mont_field_sqr)
# endif
#else
# ifndef _ec_GFp_mont_field_sqr
#  define _ec_GFp_mont_field_sqr OPENSSL_MANGLER_ASM(ec_GFp_mont_field_sqr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_group_clear_finish
#  define ec_GFp_mont_group_clear_finish OPENSSL_MANGLER(ec_GFp_mont_group_clear_finish)
# endif
#else
# ifndef _ec_GFp_mont_group_clear_finish
#  define _ec_GFp_mont_group_clear_finish OPENSSL_MANGLER_ASM(ec_GFp_mont_group_clear_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_group_copy
#  define ec_GFp_mont_group_copy OPENSSL_MANGLER(ec_GFp_mont_group_copy)
# endif
#else
# ifndef _ec_GFp_mont_group_copy
#  define _ec_GFp_mont_group_copy OPENSSL_MANGLER_ASM(ec_GFp_mont_group_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_group_finish
#  define ec_GFp_mont_group_finish OPENSSL_MANGLER(ec_GFp_mont_group_finish)
# endif
#else
# ifndef _ec_GFp_mont_group_finish
#  define _ec_GFp_mont_group_finish OPENSSL_MANGLER_ASM(ec_GFp_mont_group_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_group_init
#  define ec_GFp_mont_group_init OPENSSL_MANGLER(ec_GFp_mont_group_init)
# endif
#else
# ifndef _ec_GFp_mont_group_init
#  define _ec_GFp_mont_group_init OPENSSL_MANGLER_ASM(ec_GFp_mont_group_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_mont_group_set_curve
#  define ec_GFp_mont_group_set_curve OPENSSL_MANGLER(ec_GFp_mont_group_set_curve)
# endif
#else
# ifndef _ec_GFp_mont_group_set_curve
#  define _ec_GFp_mont_group_set_curve OPENSSL_MANGLER_ASM(ec_GFp_mont_group_set_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GFp_mont_method
#  define EC_GFp_mont_method OPENSSL_MANGLER(EC_GFp_mont_method)
# endif
#else
# ifndef _EC_GFp_mont_method
#  define _EC_GFp_mont_method OPENSSL_MANGLER_ASM(EC_GFp_mont_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_nist_field_mul
#  define ec_GFp_nist_field_mul OPENSSL_MANGLER(ec_GFp_nist_field_mul)
# endif
#else
# ifndef _ec_GFp_nist_field_mul
#  define _ec_GFp_nist_field_mul OPENSSL_MANGLER_ASM(ec_GFp_nist_field_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_nist_field_sqr
#  define ec_GFp_nist_field_sqr OPENSSL_MANGLER(ec_GFp_nist_field_sqr)
# endif
#else
# ifndef _ec_GFp_nist_field_sqr
#  define _ec_GFp_nist_field_sqr OPENSSL_MANGLER_ASM(ec_GFp_nist_field_sqr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_nist_group_copy
#  define ec_GFp_nist_group_copy OPENSSL_MANGLER(ec_GFp_nist_group_copy)
# endif
#else
# ifndef _ec_GFp_nist_group_copy
#  define _ec_GFp_nist_group_copy OPENSSL_MANGLER_ASM(ec_GFp_nist_group_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_nist_group_set_curve
#  define ec_GFp_nist_group_set_curve OPENSSL_MANGLER(ec_GFp_nist_group_set_curve)
# endif
#else
# ifndef _ec_GFp_nist_group_set_curve
#  define _ec_GFp_nist_group_set_curve OPENSSL_MANGLER_ASM(ec_GFp_nist_group_set_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GFp_nist_method
#  define EC_GFp_nist_method OPENSSL_MANGLER(EC_GFp_nist_method)
# endif
#else
# ifndef _EC_GFp_nist_method
#  define _EC_GFp_nist_method OPENSSL_MANGLER_ASM(EC_GFp_nist_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GFp_nistz256_method
#  define EC_GFp_nistz256_method OPENSSL_MANGLER(EC_GFp_nistz256_method)
# endif
#else
# ifndef _EC_GFp_nistz256_method
#  define _EC_GFp_nistz256_method OPENSSL_MANGLER_ASM(EC_GFp_nistz256_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_add
#  define ec_GFp_simple_add OPENSSL_MANGLER(ec_GFp_simple_add)
# endif
#else
# ifndef _ec_GFp_simple_add
#  define _ec_GFp_simple_add OPENSSL_MANGLER_ASM(ec_GFp_simple_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_blind_coordinates
#  define ec_GFp_simple_blind_coordinates OPENSSL_MANGLER(ec_GFp_simple_blind_coordinates)
# endif
#else
# ifndef _ec_GFp_simple_blind_coordinates
#  define _ec_GFp_simple_blind_coordinates OPENSSL_MANGLER_ASM(ec_GFp_simple_blind_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_cmp
#  define ec_GFp_simple_cmp OPENSSL_MANGLER(ec_GFp_simple_cmp)
# endif
#else
# ifndef _ec_GFp_simple_cmp
#  define _ec_GFp_simple_cmp OPENSSL_MANGLER_ASM(ec_GFp_simple_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_dbl
#  define ec_GFp_simple_dbl OPENSSL_MANGLER(ec_GFp_simple_dbl)
# endif
#else
# ifndef _ec_GFp_simple_dbl
#  define _ec_GFp_simple_dbl OPENSSL_MANGLER_ASM(ec_GFp_simple_dbl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_field_inv
#  define ec_GFp_simple_field_inv OPENSSL_MANGLER(ec_GFp_simple_field_inv)
# endif
#else
# ifndef _ec_GFp_simple_field_inv
#  define _ec_GFp_simple_field_inv OPENSSL_MANGLER_ASM(ec_GFp_simple_field_inv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_field_mul
#  define ec_GFp_simple_field_mul OPENSSL_MANGLER(ec_GFp_simple_field_mul)
# endif
#else
# ifndef _ec_GFp_simple_field_mul
#  define _ec_GFp_simple_field_mul OPENSSL_MANGLER_ASM(ec_GFp_simple_field_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_field_sqr
#  define ec_GFp_simple_field_sqr OPENSSL_MANGLER(ec_GFp_simple_field_sqr)
# endif
#else
# ifndef _ec_GFp_simple_field_sqr
#  define _ec_GFp_simple_field_sqr OPENSSL_MANGLER_ASM(ec_GFp_simple_field_sqr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_get_Jprojective_coordinates_GFp
#  define ec_GFp_simple_get_Jprojective_coordinates_GFp OPENSSL_MANGLER(ec_GFp_simple_get_Jprojective_coordinates_GFp)
# endif
#else
# ifndef _ec_GFp_simple_get_Jprojective_coordinates_GFp
#  define _ec_GFp_simple_get_Jprojective_coordinates_GFp OPENSSL_MANGLER_ASM(ec_GFp_simple_get_Jprojective_coordinates_GFp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_group_check_discriminant
#  define ec_GFp_simple_group_check_discriminant OPENSSL_MANGLER(ec_GFp_simple_group_check_discriminant)
# endif
#else
# ifndef _ec_GFp_simple_group_check_discriminant
#  define _ec_GFp_simple_group_check_discriminant OPENSSL_MANGLER_ASM(ec_GFp_simple_group_check_discriminant)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_group_clear_finish
#  define ec_GFp_simple_group_clear_finish OPENSSL_MANGLER(ec_GFp_simple_group_clear_finish)
# endif
#else
# ifndef _ec_GFp_simple_group_clear_finish
#  define _ec_GFp_simple_group_clear_finish OPENSSL_MANGLER_ASM(ec_GFp_simple_group_clear_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_group_copy
#  define ec_GFp_simple_group_copy OPENSSL_MANGLER(ec_GFp_simple_group_copy)
# endif
#else
# ifndef _ec_GFp_simple_group_copy
#  define _ec_GFp_simple_group_copy OPENSSL_MANGLER_ASM(ec_GFp_simple_group_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_group_finish
#  define ec_GFp_simple_group_finish OPENSSL_MANGLER(ec_GFp_simple_group_finish)
# endif
#else
# ifndef _ec_GFp_simple_group_finish
#  define _ec_GFp_simple_group_finish OPENSSL_MANGLER_ASM(ec_GFp_simple_group_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_group_get_curve
#  define ec_GFp_simple_group_get_curve OPENSSL_MANGLER(ec_GFp_simple_group_get_curve)
# endif
#else
# ifndef _ec_GFp_simple_group_get_curve
#  define _ec_GFp_simple_group_get_curve OPENSSL_MANGLER_ASM(ec_GFp_simple_group_get_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_group_get_degree
#  define ec_GFp_simple_group_get_degree OPENSSL_MANGLER(ec_GFp_simple_group_get_degree)
# endif
#else
# ifndef _ec_GFp_simple_group_get_degree
#  define _ec_GFp_simple_group_get_degree OPENSSL_MANGLER_ASM(ec_GFp_simple_group_get_degree)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_group_init
#  define ec_GFp_simple_group_init OPENSSL_MANGLER(ec_GFp_simple_group_init)
# endif
#else
# ifndef _ec_GFp_simple_group_init
#  define _ec_GFp_simple_group_init OPENSSL_MANGLER_ASM(ec_GFp_simple_group_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_group_set_curve
#  define ec_GFp_simple_group_set_curve OPENSSL_MANGLER(ec_GFp_simple_group_set_curve)
# endif
#else
# ifndef _ec_GFp_simple_group_set_curve
#  define _ec_GFp_simple_group_set_curve OPENSSL_MANGLER_ASM(ec_GFp_simple_group_set_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_invert
#  define ec_GFp_simple_invert OPENSSL_MANGLER(ec_GFp_simple_invert)
# endif
#else
# ifndef _ec_GFp_simple_invert
#  define _ec_GFp_simple_invert OPENSSL_MANGLER_ASM(ec_GFp_simple_invert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_is_at_infinity
#  define ec_GFp_simple_is_at_infinity OPENSSL_MANGLER(ec_GFp_simple_is_at_infinity)
# endif
#else
# ifndef _ec_GFp_simple_is_at_infinity
#  define _ec_GFp_simple_is_at_infinity OPENSSL_MANGLER_ASM(ec_GFp_simple_is_at_infinity)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_is_on_curve
#  define ec_GFp_simple_is_on_curve OPENSSL_MANGLER(ec_GFp_simple_is_on_curve)
# endif
#else
# ifndef _ec_GFp_simple_is_on_curve
#  define _ec_GFp_simple_is_on_curve OPENSSL_MANGLER_ASM(ec_GFp_simple_is_on_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_ladder_post
#  define ec_GFp_simple_ladder_post OPENSSL_MANGLER(ec_GFp_simple_ladder_post)
# endif
#else
# ifndef _ec_GFp_simple_ladder_post
#  define _ec_GFp_simple_ladder_post OPENSSL_MANGLER_ASM(ec_GFp_simple_ladder_post)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_ladder_pre
#  define ec_GFp_simple_ladder_pre OPENSSL_MANGLER(ec_GFp_simple_ladder_pre)
# endif
#else
# ifndef _ec_GFp_simple_ladder_pre
#  define _ec_GFp_simple_ladder_pre OPENSSL_MANGLER_ASM(ec_GFp_simple_ladder_pre)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_ladder_step
#  define ec_GFp_simple_ladder_step OPENSSL_MANGLER(ec_GFp_simple_ladder_step)
# endif
#else
# ifndef _ec_GFp_simple_ladder_step
#  define _ec_GFp_simple_ladder_step OPENSSL_MANGLER_ASM(ec_GFp_simple_ladder_step)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_make_affine
#  define ec_GFp_simple_make_affine OPENSSL_MANGLER(ec_GFp_simple_make_affine)
# endif
#else
# ifndef _ec_GFp_simple_make_affine
#  define _ec_GFp_simple_make_affine OPENSSL_MANGLER_ASM(ec_GFp_simple_make_affine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GFp_simple_method
#  define EC_GFp_simple_method OPENSSL_MANGLER(EC_GFp_simple_method)
# endif
#else
# ifndef _EC_GFp_simple_method
#  define _EC_GFp_simple_method OPENSSL_MANGLER_ASM(EC_GFp_simple_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_oct2point
#  define ec_GFp_simple_oct2point OPENSSL_MANGLER(ec_GFp_simple_oct2point)
# endif
#else
# ifndef _ec_GFp_simple_oct2point
#  define _ec_GFp_simple_oct2point OPENSSL_MANGLER_ASM(ec_GFp_simple_oct2point)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_point2oct
#  define ec_GFp_simple_point2oct OPENSSL_MANGLER(ec_GFp_simple_point2oct)
# endif
#else
# ifndef _ec_GFp_simple_point2oct
#  define _ec_GFp_simple_point2oct OPENSSL_MANGLER_ASM(ec_GFp_simple_point2oct)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_point_clear_finish
#  define ec_GFp_simple_point_clear_finish OPENSSL_MANGLER(ec_GFp_simple_point_clear_finish)
# endif
#else
# ifndef _ec_GFp_simple_point_clear_finish
#  define _ec_GFp_simple_point_clear_finish OPENSSL_MANGLER_ASM(ec_GFp_simple_point_clear_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_point_copy
#  define ec_GFp_simple_point_copy OPENSSL_MANGLER(ec_GFp_simple_point_copy)
# endif
#else
# ifndef _ec_GFp_simple_point_copy
#  define _ec_GFp_simple_point_copy OPENSSL_MANGLER_ASM(ec_GFp_simple_point_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_point_finish
#  define ec_GFp_simple_point_finish OPENSSL_MANGLER(ec_GFp_simple_point_finish)
# endif
#else
# ifndef _ec_GFp_simple_point_finish
#  define _ec_GFp_simple_point_finish OPENSSL_MANGLER_ASM(ec_GFp_simple_point_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_point_get_affine_coordinates
#  define ec_GFp_simple_point_get_affine_coordinates OPENSSL_MANGLER(ec_GFp_simple_point_get_affine_coordinates)
# endif
#else
# ifndef _ec_GFp_simple_point_get_affine_coordinates
#  define _ec_GFp_simple_point_get_affine_coordinates OPENSSL_MANGLER_ASM(ec_GFp_simple_point_get_affine_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_point_init
#  define ec_GFp_simple_point_init OPENSSL_MANGLER(ec_GFp_simple_point_init)
# endif
#else
# ifndef _ec_GFp_simple_point_init
#  define _ec_GFp_simple_point_init OPENSSL_MANGLER_ASM(ec_GFp_simple_point_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_point_set_affine_coordinates
#  define ec_GFp_simple_point_set_affine_coordinates OPENSSL_MANGLER(ec_GFp_simple_point_set_affine_coordinates)
# endif
#else
# ifndef _ec_GFp_simple_point_set_affine_coordinates
#  define _ec_GFp_simple_point_set_affine_coordinates OPENSSL_MANGLER_ASM(ec_GFp_simple_point_set_affine_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_point_set_to_infinity
#  define ec_GFp_simple_point_set_to_infinity OPENSSL_MANGLER(ec_GFp_simple_point_set_to_infinity)
# endif
#else
# ifndef _ec_GFp_simple_point_set_to_infinity
#  define _ec_GFp_simple_point_set_to_infinity OPENSSL_MANGLER_ASM(ec_GFp_simple_point_set_to_infinity)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_points_make_affine
#  define ec_GFp_simple_points_make_affine OPENSSL_MANGLER(ec_GFp_simple_points_make_affine)
# endif
#else
# ifndef _ec_GFp_simple_points_make_affine
#  define _ec_GFp_simple_points_make_affine OPENSSL_MANGLER_ASM(ec_GFp_simple_points_make_affine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_set_compressed_coordinates
#  define ec_GFp_simple_set_compressed_coordinates OPENSSL_MANGLER(ec_GFp_simple_set_compressed_coordinates)
# endif
#else
# ifndef _ec_GFp_simple_set_compressed_coordinates
#  define _ec_GFp_simple_set_compressed_coordinates OPENSSL_MANGLER_ASM(ec_GFp_simple_set_compressed_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_GFp_simple_set_Jprojective_coordinates_GFp
#  define ec_GFp_simple_set_Jprojective_coordinates_GFp OPENSSL_MANGLER(ec_GFp_simple_set_Jprojective_coordinates_GFp)
# endif
#else
# ifndef _ec_GFp_simple_set_Jprojective_coordinates_GFp
#  define _ec_GFp_simple_set_Jprojective_coordinates_GFp OPENSSL_MANGLER_ASM(ec_GFp_simple_set_Jprojective_coordinates_GFp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_check
#  define EC_GROUP_check OPENSSL_MANGLER(EC_GROUP_check)
# endif
#else
# ifndef _EC_GROUP_check
#  define _EC_GROUP_check OPENSSL_MANGLER_ASM(EC_GROUP_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_check_discriminant
#  define EC_GROUP_check_discriminant OPENSSL_MANGLER(EC_GROUP_check_discriminant)
# endif
#else
# ifndef _EC_GROUP_check_discriminant
#  define _EC_GROUP_check_discriminant OPENSSL_MANGLER_ASM(EC_GROUP_check_discriminant)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_clear_free
#  define EC_GROUP_clear_free OPENSSL_MANGLER(EC_GROUP_clear_free)
# endif
#else
# ifndef _EC_GROUP_clear_free
#  define _EC_GROUP_clear_free OPENSSL_MANGLER_ASM(EC_GROUP_clear_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_cmp
#  define EC_GROUP_cmp OPENSSL_MANGLER(EC_GROUP_cmp)
# endif
#else
# ifndef _EC_GROUP_cmp
#  define _EC_GROUP_cmp OPENSSL_MANGLER_ASM(EC_GROUP_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_copy
#  define EC_GROUP_copy OPENSSL_MANGLER(EC_GROUP_copy)
# endif
#else
# ifndef _EC_GROUP_copy
#  define _EC_GROUP_copy OPENSSL_MANGLER_ASM(EC_GROUP_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_group_do_inverse_ord
#  define ec_group_do_inverse_ord OPENSSL_MANGLER(ec_group_do_inverse_ord)
# endif
#else
# ifndef _ec_group_do_inverse_ord
#  define _ec_group_do_inverse_ord OPENSSL_MANGLER_ASM(ec_group_do_inverse_ord)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_dup
#  define EC_GROUP_dup OPENSSL_MANGLER(EC_GROUP_dup)
# endif
#else
# ifndef _EC_GROUP_dup
#  define _EC_GROUP_dup OPENSSL_MANGLER_ASM(EC_GROUP_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_free
#  define EC_GROUP_free OPENSSL_MANGLER(EC_GROUP_free)
# endif
#else
# ifndef _EC_GROUP_free
#  define _EC_GROUP_free OPENSSL_MANGLER_ASM(EC_GROUP_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get0_cofactor
#  define EC_GROUP_get0_cofactor OPENSSL_MANGLER(EC_GROUP_get0_cofactor)
# endif
#else
# ifndef _EC_GROUP_get0_cofactor
#  define _EC_GROUP_get0_cofactor OPENSSL_MANGLER_ASM(EC_GROUP_get0_cofactor)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get0_generator
#  define EC_GROUP_get0_generator OPENSSL_MANGLER(EC_GROUP_get0_generator)
# endif
#else
# ifndef _EC_GROUP_get0_generator
#  define _EC_GROUP_get0_generator OPENSSL_MANGLER_ASM(EC_GROUP_get0_generator)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get0_order
#  define EC_GROUP_get0_order OPENSSL_MANGLER(EC_GROUP_get0_order)
# endif
#else
# ifndef _EC_GROUP_get0_order
#  define _EC_GROUP_get0_order OPENSSL_MANGLER_ASM(EC_GROUP_get0_order)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get0_seed
#  define EC_GROUP_get0_seed OPENSSL_MANGLER(EC_GROUP_get0_seed)
# endif
#else
# ifndef _EC_GROUP_get0_seed
#  define _EC_GROUP_get0_seed OPENSSL_MANGLER_ASM(EC_GROUP_get0_seed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_asn1_flag
#  define EC_GROUP_get_asn1_flag OPENSSL_MANGLER(EC_GROUP_get_asn1_flag)
# endif
#else
# ifndef _EC_GROUP_get_asn1_flag
#  define _EC_GROUP_get_asn1_flag OPENSSL_MANGLER_ASM(EC_GROUP_get_asn1_flag)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_basis_type
#  define EC_GROUP_get_basis_type OPENSSL_MANGLER(EC_GROUP_get_basis_type)
# endif
#else
# ifndef _EC_GROUP_get_basis_type
#  define _EC_GROUP_get_basis_type OPENSSL_MANGLER_ASM(EC_GROUP_get_basis_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_cofactor
#  define EC_GROUP_get_cofactor OPENSSL_MANGLER(EC_GROUP_get_cofactor)
# endif
#else
# ifndef _EC_GROUP_get_cofactor
#  define _EC_GROUP_get_cofactor OPENSSL_MANGLER_ASM(EC_GROUP_get_cofactor)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_curve
#  define EC_GROUP_get_curve OPENSSL_MANGLER(EC_GROUP_get_curve)
# endif
#else
# ifndef _EC_GROUP_get_curve
#  define _EC_GROUP_get_curve OPENSSL_MANGLER_ASM(EC_GROUP_get_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_curve_GF2m
#  define EC_GROUP_get_curve_GF2m OPENSSL_MANGLER(EC_GROUP_get_curve_GF2m)
# endif
#else
# ifndef _EC_GROUP_get_curve_GF2m
#  define _EC_GROUP_get_curve_GF2m OPENSSL_MANGLER_ASM(EC_GROUP_get_curve_GF2m)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_curve_GFp
#  define EC_GROUP_get_curve_GFp OPENSSL_MANGLER(EC_GROUP_get_curve_GFp)
# endif
#else
# ifndef _EC_GROUP_get_curve_GFp
#  define _EC_GROUP_get_curve_GFp OPENSSL_MANGLER_ASM(EC_GROUP_get_curve_GFp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_curve_name
#  define EC_GROUP_get_curve_name OPENSSL_MANGLER(EC_GROUP_get_curve_name)
# endif
#else
# ifndef _EC_GROUP_get_curve_name
#  define _EC_GROUP_get_curve_name OPENSSL_MANGLER_ASM(EC_GROUP_get_curve_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_degree
#  define EC_GROUP_get_degree OPENSSL_MANGLER(EC_GROUP_get_degree)
# endif
#else
# ifndef _EC_GROUP_get_degree
#  define _EC_GROUP_get_degree OPENSSL_MANGLER_ASM(EC_GROUP_get_degree)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_ecparameters
#  define EC_GROUP_get_ecparameters OPENSSL_MANGLER(EC_GROUP_get_ecparameters)
# endif
#else
# ifndef _EC_GROUP_get_ecparameters
#  define _EC_GROUP_get_ecparameters OPENSSL_MANGLER_ASM(EC_GROUP_get_ecparameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_ecpkparameters
#  define EC_GROUP_get_ecpkparameters OPENSSL_MANGLER(EC_GROUP_get_ecpkparameters)
# endif
#else
# ifndef _EC_GROUP_get_ecpkparameters
#  define _EC_GROUP_get_ecpkparameters OPENSSL_MANGLER_ASM(EC_GROUP_get_ecpkparameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_mont_data
#  define EC_GROUP_get_mont_data OPENSSL_MANGLER(EC_GROUP_get_mont_data)
# endif
#else
# ifndef _EC_GROUP_get_mont_data
#  define _EC_GROUP_get_mont_data OPENSSL_MANGLER_ASM(EC_GROUP_get_mont_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_order
#  define EC_GROUP_get_order OPENSSL_MANGLER(EC_GROUP_get_order)
# endif
#else
# ifndef _EC_GROUP_get_order
#  define _EC_GROUP_get_order OPENSSL_MANGLER_ASM(EC_GROUP_get_order)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_pentanomial_basis
#  define EC_GROUP_get_pentanomial_basis OPENSSL_MANGLER(EC_GROUP_get_pentanomial_basis)
# endif
#else
# ifndef _EC_GROUP_get_pentanomial_basis
#  define _EC_GROUP_get_pentanomial_basis OPENSSL_MANGLER_ASM(EC_GROUP_get_pentanomial_basis)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_point_conversion_form
#  define EC_GROUP_get_point_conversion_form OPENSSL_MANGLER(EC_GROUP_get_point_conversion_form)
# endif
#else
# ifndef _EC_GROUP_get_point_conversion_form
#  define _EC_GROUP_get_point_conversion_form OPENSSL_MANGLER_ASM(EC_GROUP_get_point_conversion_form)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_seed_len
#  define EC_GROUP_get_seed_len OPENSSL_MANGLER(EC_GROUP_get_seed_len)
# endif
#else
# ifndef _EC_GROUP_get_seed_len
#  define _EC_GROUP_get_seed_len OPENSSL_MANGLER_ASM(EC_GROUP_get_seed_len)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_get_trinomial_basis
#  define EC_GROUP_get_trinomial_basis OPENSSL_MANGLER(EC_GROUP_get_trinomial_basis)
# endif
#else
# ifndef _EC_GROUP_get_trinomial_basis
#  define _EC_GROUP_get_trinomial_basis OPENSSL_MANGLER_ASM(EC_GROUP_get_trinomial_basis)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_have_precompute_mult
#  define EC_GROUP_have_precompute_mult OPENSSL_MANGLER(EC_GROUP_have_precompute_mult)
# endif
#else
# ifndef _EC_GROUP_have_precompute_mult
#  define _EC_GROUP_have_precompute_mult OPENSSL_MANGLER_ASM(EC_GROUP_have_precompute_mult)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_method_of
#  define EC_GROUP_method_of OPENSSL_MANGLER(EC_GROUP_method_of)
# endif
#else
# ifndef _EC_GROUP_method_of
#  define _EC_GROUP_method_of OPENSSL_MANGLER_ASM(EC_GROUP_method_of)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_new
#  define EC_GROUP_new OPENSSL_MANGLER(EC_GROUP_new)
# endif
#else
# ifndef _EC_GROUP_new
#  define _EC_GROUP_new OPENSSL_MANGLER_ASM(EC_GROUP_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_new_by_curve_name
#  define EC_GROUP_new_by_curve_name OPENSSL_MANGLER(EC_GROUP_new_by_curve_name)
# endif
#else
# ifndef _EC_GROUP_new_by_curve_name
#  define _EC_GROUP_new_by_curve_name OPENSSL_MANGLER_ASM(EC_GROUP_new_by_curve_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_new_curve_GF2m
#  define EC_GROUP_new_curve_GF2m OPENSSL_MANGLER(EC_GROUP_new_curve_GF2m)
# endif
#else
# ifndef _EC_GROUP_new_curve_GF2m
#  define _EC_GROUP_new_curve_GF2m OPENSSL_MANGLER_ASM(EC_GROUP_new_curve_GF2m)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_new_curve_GFp
#  define EC_GROUP_new_curve_GFp OPENSSL_MANGLER(EC_GROUP_new_curve_GFp)
# endif
#else
# ifndef _EC_GROUP_new_curve_GFp
#  define _EC_GROUP_new_curve_GFp OPENSSL_MANGLER_ASM(EC_GROUP_new_curve_GFp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_new_from_ecparameters
#  define EC_GROUP_new_from_ecparameters OPENSSL_MANGLER(EC_GROUP_new_from_ecparameters)
# endif
#else
# ifndef _EC_GROUP_new_from_ecparameters
#  define _EC_GROUP_new_from_ecparameters OPENSSL_MANGLER_ASM(EC_GROUP_new_from_ecparameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_new_from_ecpkparameters
#  define EC_GROUP_new_from_ecpkparameters OPENSSL_MANGLER(EC_GROUP_new_from_ecpkparameters)
# endif
#else
# ifndef _EC_GROUP_new_from_ecpkparameters
#  define _EC_GROUP_new_from_ecpkparameters OPENSSL_MANGLER_ASM(EC_GROUP_new_from_ecpkparameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_order_bits
#  define EC_GROUP_order_bits OPENSSL_MANGLER(EC_GROUP_order_bits)
# endif
#else
# ifndef _EC_GROUP_order_bits
#  define _EC_GROUP_order_bits OPENSSL_MANGLER_ASM(EC_GROUP_order_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_precompute_mult
#  define EC_GROUP_precompute_mult OPENSSL_MANGLER(EC_GROUP_precompute_mult)
# endif
#else
# ifndef _EC_GROUP_precompute_mult
#  define _EC_GROUP_precompute_mult OPENSSL_MANGLER_ASM(EC_GROUP_precompute_mult)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_set_asn1_flag
#  define EC_GROUP_set_asn1_flag OPENSSL_MANGLER(EC_GROUP_set_asn1_flag)
# endif
#else
# ifndef _EC_GROUP_set_asn1_flag
#  define _EC_GROUP_set_asn1_flag OPENSSL_MANGLER_ASM(EC_GROUP_set_asn1_flag)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_set_curve
#  define EC_GROUP_set_curve OPENSSL_MANGLER(EC_GROUP_set_curve)
# endif
#else
# ifndef _EC_GROUP_set_curve
#  define _EC_GROUP_set_curve OPENSSL_MANGLER_ASM(EC_GROUP_set_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_set_curve_GF2m
#  define EC_GROUP_set_curve_GF2m OPENSSL_MANGLER(EC_GROUP_set_curve_GF2m)
# endif
#else
# ifndef _EC_GROUP_set_curve_GF2m
#  define _EC_GROUP_set_curve_GF2m OPENSSL_MANGLER_ASM(EC_GROUP_set_curve_GF2m)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_set_curve_GFp
#  define EC_GROUP_set_curve_GFp OPENSSL_MANGLER(EC_GROUP_set_curve_GFp)
# endif
#else
# ifndef _EC_GROUP_set_curve_GFp
#  define _EC_GROUP_set_curve_GFp OPENSSL_MANGLER_ASM(EC_GROUP_set_curve_GFp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_set_curve_name
#  define EC_GROUP_set_curve_name OPENSSL_MANGLER(EC_GROUP_set_curve_name)
# endif
#else
# ifndef _EC_GROUP_set_curve_name
#  define _EC_GROUP_set_curve_name OPENSSL_MANGLER_ASM(EC_GROUP_set_curve_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_set_generator
#  define EC_GROUP_set_generator OPENSSL_MANGLER(EC_GROUP_set_generator)
# endif
#else
# ifndef _EC_GROUP_set_generator
#  define _EC_GROUP_set_generator OPENSSL_MANGLER_ASM(EC_GROUP_set_generator)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_set_point_conversion_form
#  define EC_GROUP_set_point_conversion_form OPENSSL_MANGLER(EC_GROUP_set_point_conversion_form)
# endif
#else
# ifndef _EC_GROUP_set_point_conversion_form
#  define _EC_GROUP_set_point_conversion_form OPENSSL_MANGLER_ASM(EC_GROUP_set_point_conversion_form)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_GROUP_set_seed
#  define EC_GROUP_set_seed OPENSSL_MANGLER(EC_GROUP_set_seed)
# endif
#else
# ifndef _EC_GROUP_set_seed
#  define _EC_GROUP_set_seed OPENSSL_MANGLER_ASM(EC_GROUP_set_seed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_group_simple_order_bits
#  define ec_group_simple_order_bits OPENSSL_MANGLER(ec_group_simple_order_bits)
# endif
#else
# ifndef _ec_group_simple_order_bits
#  define _ec_group_simple_order_bits OPENSSL_MANGLER_ASM(ec_group_simple_order_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef eckey_asn1_meth
#  define eckey_asn1_meth OPENSSL_MANGLER(eckey_asn1_meth)
# endif
#else
# ifndef _eckey_asn1_meth
#  define _eckey_asn1_meth OPENSSL_MANGLER_ASM(eckey_asn1_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_can_sign
#  define EC_KEY_can_sign OPENSSL_MANGLER(EC_KEY_can_sign)
# endif
#else
# ifndef _EC_KEY_can_sign
#  define _EC_KEY_can_sign OPENSSL_MANGLER_ASM(EC_KEY_can_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_check_key
#  define EC_KEY_check_key OPENSSL_MANGLER(EC_KEY_check_key)
# endif
#else
# ifndef _EC_KEY_check_key
#  define _EC_KEY_check_key OPENSSL_MANGLER_ASM(EC_KEY_check_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_clear_flags
#  define EC_KEY_clear_flags OPENSSL_MANGLER(EC_KEY_clear_flags)
# endif
#else
# ifndef _EC_KEY_clear_flags
#  define _EC_KEY_clear_flags OPENSSL_MANGLER_ASM(EC_KEY_clear_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_copy
#  define EC_KEY_copy OPENSSL_MANGLER(EC_KEY_copy)
# endif
#else
# ifndef _EC_KEY_copy
#  define _EC_KEY_copy OPENSSL_MANGLER_ASM(EC_KEY_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_dup
#  define EC_KEY_dup OPENSSL_MANGLER(EC_KEY_dup)
# endif
#else
# ifndef _EC_KEY_dup
#  define _EC_KEY_dup OPENSSL_MANGLER_ASM(EC_KEY_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_free
#  define EC_KEY_free OPENSSL_MANGLER(EC_KEY_free)
# endif
#else
# ifndef _EC_KEY_free
#  define _EC_KEY_free OPENSSL_MANGLER_ASM(EC_KEY_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_generate_key
#  define EC_KEY_generate_key OPENSSL_MANGLER(EC_KEY_generate_key)
# endif
#else
# ifndef _EC_KEY_generate_key
#  define _EC_KEY_generate_key OPENSSL_MANGLER_ASM(EC_KEY_generate_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_get0_engine
#  define EC_KEY_get0_engine OPENSSL_MANGLER(EC_KEY_get0_engine)
# endif
#else
# ifndef _EC_KEY_get0_engine
#  define _EC_KEY_get0_engine OPENSSL_MANGLER_ASM(EC_KEY_get0_engine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_get0_group
#  define EC_KEY_get0_group OPENSSL_MANGLER(EC_KEY_get0_group)
# endif
#else
# ifndef _EC_KEY_get0_group
#  define _EC_KEY_get0_group OPENSSL_MANGLER_ASM(EC_KEY_get0_group)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_get0_private_key
#  define EC_KEY_get0_private_key OPENSSL_MANGLER(EC_KEY_get0_private_key)
# endif
#else
# ifndef _EC_KEY_get0_private_key
#  define _EC_KEY_get0_private_key OPENSSL_MANGLER_ASM(EC_KEY_get0_private_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_get0_public_key
#  define EC_KEY_get0_public_key OPENSSL_MANGLER(EC_KEY_get0_public_key)
# endif
#else
# ifndef _EC_KEY_get0_public_key
#  define _EC_KEY_get0_public_key OPENSSL_MANGLER_ASM(EC_KEY_get0_public_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_get_conv_form
#  define EC_KEY_get_conv_form OPENSSL_MANGLER(EC_KEY_get_conv_form)
# endif
#else
# ifndef _EC_KEY_get_conv_form
#  define _EC_KEY_get_conv_form OPENSSL_MANGLER_ASM(EC_KEY_get_conv_form)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_get_default_method
#  define EC_KEY_get_default_method OPENSSL_MANGLER(EC_KEY_get_default_method)
# endif
#else
# ifndef _EC_KEY_get_default_method
#  define _EC_KEY_get_default_method OPENSSL_MANGLER_ASM(EC_KEY_get_default_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_get_enc_flags
#  define EC_KEY_get_enc_flags OPENSSL_MANGLER(EC_KEY_get_enc_flags)
# endif
#else
# ifndef _EC_KEY_get_enc_flags
#  define _EC_KEY_get_enc_flags OPENSSL_MANGLER_ASM(EC_KEY_get_enc_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_get_ex_data
#  define EC_KEY_get_ex_data OPENSSL_MANGLER(EC_KEY_get_ex_data)
# endif
#else
# ifndef _EC_KEY_get_ex_data
#  define _EC_KEY_get_ex_data OPENSSL_MANGLER_ASM(EC_KEY_get_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_get_flags
#  define EC_KEY_get_flags OPENSSL_MANGLER(EC_KEY_get_flags)
# endif
#else
# ifndef _EC_KEY_get_flags
#  define _EC_KEY_get_flags OPENSSL_MANGLER_ASM(EC_KEY_get_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_get_method
#  define EC_KEY_get_method OPENSSL_MANGLER(EC_KEY_get_method)
# endif
#else
# ifndef _EC_KEY_get_method
#  define _EC_KEY_get_method OPENSSL_MANGLER_ASM(EC_KEY_get_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_key2buf
#  define EC_KEY_key2buf OPENSSL_MANGLER(EC_KEY_key2buf)
# endif
#else
# ifndef _EC_KEY_key2buf
#  define _EC_KEY_key2buf OPENSSL_MANGLER_ASM(EC_KEY_key2buf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_free
#  define EC_KEY_METHOD_free OPENSSL_MANGLER(EC_KEY_METHOD_free)
# endif
#else
# ifndef _EC_KEY_METHOD_free
#  define _EC_KEY_METHOD_free OPENSSL_MANGLER_ASM(EC_KEY_METHOD_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_get_compute_key
#  define EC_KEY_METHOD_get_compute_key OPENSSL_MANGLER(EC_KEY_METHOD_get_compute_key)
# endif
#else
# ifndef _EC_KEY_METHOD_get_compute_key
#  define _EC_KEY_METHOD_get_compute_key OPENSSL_MANGLER_ASM(EC_KEY_METHOD_get_compute_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_get_init
#  define EC_KEY_METHOD_get_init OPENSSL_MANGLER(EC_KEY_METHOD_get_init)
# endif
#else
# ifndef _EC_KEY_METHOD_get_init
#  define _EC_KEY_METHOD_get_init OPENSSL_MANGLER_ASM(EC_KEY_METHOD_get_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_get_keygen
#  define EC_KEY_METHOD_get_keygen OPENSSL_MANGLER(EC_KEY_METHOD_get_keygen)
# endif
#else
# ifndef _EC_KEY_METHOD_get_keygen
#  define _EC_KEY_METHOD_get_keygen OPENSSL_MANGLER_ASM(EC_KEY_METHOD_get_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_get_sign
#  define EC_KEY_METHOD_get_sign OPENSSL_MANGLER(EC_KEY_METHOD_get_sign)
# endif
#else
# ifndef _EC_KEY_METHOD_get_sign
#  define _EC_KEY_METHOD_get_sign OPENSSL_MANGLER_ASM(EC_KEY_METHOD_get_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_get_verify
#  define EC_KEY_METHOD_get_verify OPENSSL_MANGLER(EC_KEY_METHOD_get_verify)
# endif
#else
# ifndef _EC_KEY_METHOD_get_verify
#  define _EC_KEY_METHOD_get_verify OPENSSL_MANGLER_ASM(EC_KEY_METHOD_get_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_new
#  define EC_KEY_METHOD_new OPENSSL_MANGLER(EC_KEY_METHOD_new)
# endif
#else
# ifndef _EC_KEY_METHOD_new
#  define _EC_KEY_METHOD_new OPENSSL_MANGLER_ASM(EC_KEY_METHOD_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_set_compute_key
#  define EC_KEY_METHOD_set_compute_key OPENSSL_MANGLER(EC_KEY_METHOD_set_compute_key)
# endif
#else
# ifndef _EC_KEY_METHOD_set_compute_key
#  define _EC_KEY_METHOD_set_compute_key OPENSSL_MANGLER_ASM(EC_KEY_METHOD_set_compute_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_set_init
#  define EC_KEY_METHOD_set_init OPENSSL_MANGLER(EC_KEY_METHOD_set_init)
# endif
#else
# ifndef _EC_KEY_METHOD_set_init
#  define _EC_KEY_METHOD_set_init OPENSSL_MANGLER_ASM(EC_KEY_METHOD_set_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_set_keygen
#  define EC_KEY_METHOD_set_keygen OPENSSL_MANGLER(EC_KEY_METHOD_set_keygen)
# endif
#else
# ifndef _EC_KEY_METHOD_set_keygen
#  define _EC_KEY_METHOD_set_keygen OPENSSL_MANGLER_ASM(EC_KEY_METHOD_set_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_set_sign
#  define EC_KEY_METHOD_set_sign OPENSSL_MANGLER(EC_KEY_METHOD_set_sign)
# endif
#else
# ifndef _EC_KEY_METHOD_set_sign
#  define _EC_KEY_METHOD_set_sign OPENSSL_MANGLER_ASM(EC_KEY_METHOD_set_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_METHOD_set_verify
#  define EC_KEY_METHOD_set_verify OPENSSL_MANGLER(EC_KEY_METHOD_set_verify)
# endif
#else
# ifndef _EC_KEY_METHOD_set_verify
#  define _EC_KEY_METHOD_set_verify OPENSSL_MANGLER_ASM(EC_KEY_METHOD_set_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_new
#  define EC_KEY_new OPENSSL_MANGLER(EC_KEY_new)
# endif
#else
# ifndef _EC_KEY_new
#  define _EC_KEY_new OPENSSL_MANGLER_ASM(EC_KEY_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_new_by_curve_name
#  define EC_KEY_new_by_curve_name OPENSSL_MANGLER(EC_KEY_new_by_curve_name)
# endif
#else
# ifndef _EC_KEY_new_by_curve_name
#  define _EC_KEY_new_by_curve_name OPENSSL_MANGLER_ASM(EC_KEY_new_by_curve_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_new_method
#  define EC_KEY_new_method OPENSSL_MANGLER(EC_KEY_new_method)
# endif
#else
# ifndef _EC_KEY_new_method
#  define _EC_KEY_new_method OPENSSL_MANGLER_ASM(EC_KEY_new_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_oct2key
#  define EC_KEY_oct2key OPENSSL_MANGLER(EC_KEY_oct2key)
# endif
#else
# ifndef _EC_KEY_oct2key
#  define _EC_KEY_oct2key OPENSSL_MANGLER_ASM(EC_KEY_oct2key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_oct2priv
#  define EC_KEY_oct2priv OPENSSL_MANGLER(EC_KEY_oct2priv)
# endif
#else
# ifndef _EC_KEY_oct2priv
#  define _EC_KEY_oct2priv OPENSSL_MANGLER_ASM(EC_KEY_oct2priv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_OpenSSL
#  define EC_KEY_OpenSSL OPENSSL_MANGLER(EC_KEY_OpenSSL)
# endif
#else
# ifndef _EC_KEY_OpenSSL
#  define _EC_KEY_OpenSSL OPENSSL_MANGLER_ASM(EC_KEY_OpenSSL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_precompute_mult
#  define EC_KEY_precompute_mult OPENSSL_MANGLER(EC_KEY_precompute_mult)
# endif
#else
# ifndef _EC_KEY_precompute_mult
#  define _EC_KEY_precompute_mult OPENSSL_MANGLER_ASM(EC_KEY_precompute_mult)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_print
#  define EC_KEY_print OPENSSL_MANGLER(EC_KEY_print)
# endif
#else
# ifndef _EC_KEY_print
#  define _EC_KEY_print OPENSSL_MANGLER_ASM(EC_KEY_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_print_fp
#  define EC_KEY_print_fp OPENSSL_MANGLER(EC_KEY_print_fp)
# endif
#else
# ifndef _EC_KEY_print_fp
#  define _EC_KEY_print_fp OPENSSL_MANGLER_ASM(EC_KEY_print_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_priv2buf
#  define EC_KEY_priv2buf OPENSSL_MANGLER(EC_KEY_priv2buf)
# endif
#else
# ifndef _EC_KEY_priv2buf
#  define _EC_KEY_priv2buf OPENSSL_MANGLER_ASM(EC_KEY_priv2buf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_priv2oct
#  define EC_KEY_priv2oct OPENSSL_MANGLER(EC_KEY_priv2oct)
# endif
#else
# ifndef _EC_KEY_priv2oct
#  define _EC_KEY_priv2oct OPENSSL_MANGLER_ASM(EC_KEY_priv2oct)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_asn1_flag
#  define EC_KEY_set_asn1_flag OPENSSL_MANGLER(EC_KEY_set_asn1_flag)
# endif
#else
# ifndef _EC_KEY_set_asn1_flag
#  define _EC_KEY_set_asn1_flag OPENSSL_MANGLER_ASM(EC_KEY_set_asn1_flag)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_conv_form
#  define EC_KEY_set_conv_form OPENSSL_MANGLER(EC_KEY_set_conv_form)
# endif
#else
# ifndef _EC_KEY_set_conv_form
#  define _EC_KEY_set_conv_form OPENSSL_MANGLER_ASM(EC_KEY_set_conv_form)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_default_method
#  define EC_KEY_set_default_method OPENSSL_MANGLER(EC_KEY_set_default_method)
# endif
#else
# ifndef _EC_KEY_set_default_method
#  define _EC_KEY_set_default_method OPENSSL_MANGLER_ASM(EC_KEY_set_default_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_enc_flags
#  define EC_KEY_set_enc_flags OPENSSL_MANGLER(EC_KEY_set_enc_flags)
# endif
#else
# ifndef _EC_KEY_set_enc_flags
#  define _EC_KEY_set_enc_flags OPENSSL_MANGLER_ASM(EC_KEY_set_enc_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_ex_data
#  define EC_KEY_set_ex_data OPENSSL_MANGLER(EC_KEY_set_ex_data)
# endif
#else
# ifndef _EC_KEY_set_ex_data
#  define _EC_KEY_set_ex_data OPENSSL_MANGLER_ASM(EC_KEY_set_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_flags
#  define EC_KEY_set_flags OPENSSL_MANGLER(EC_KEY_set_flags)
# endif
#else
# ifndef _EC_KEY_set_flags
#  define _EC_KEY_set_flags OPENSSL_MANGLER_ASM(EC_KEY_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_group
#  define EC_KEY_set_group OPENSSL_MANGLER(EC_KEY_set_group)
# endif
#else
# ifndef _EC_KEY_set_group
#  define _EC_KEY_set_group OPENSSL_MANGLER_ASM(EC_KEY_set_group)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_method
#  define EC_KEY_set_method OPENSSL_MANGLER(EC_KEY_set_method)
# endif
#else
# ifndef _EC_KEY_set_method
#  define _EC_KEY_set_method OPENSSL_MANGLER_ASM(EC_KEY_set_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_private_key
#  define EC_KEY_set_private_key OPENSSL_MANGLER(EC_KEY_set_private_key)
# endif
#else
# ifndef _EC_KEY_set_private_key
#  define _EC_KEY_set_private_key OPENSSL_MANGLER_ASM(EC_KEY_set_private_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_public_key
#  define EC_KEY_set_public_key OPENSSL_MANGLER(EC_KEY_set_public_key)
# endif
#else
# ifndef _EC_KEY_set_public_key
#  define _EC_KEY_set_public_key OPENSSL_MANGLER_ASM(EC_KEY_set_public_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_set_public_key_affine_coordinates
#  define EC_KEY_set_public_key_affine_coordinates OPENSSL_MANGLER(EC_KEY_set_public_key_affine_coordinates)
# endif
#else
# ifndef _EC_KEY_set_public_key_affine_coordinates
#  define _EC_KEY_set_public_key_affine_coordinates OPENSSL_MANGLER_ASM(EC_KEY_set_public_key_affine_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_key_simple_check_key
#  define ec_key_simple_check_key OPENSSL_MANGLER(ec_key_simple_check_key)
# endif
#else
# ifndef _ec_key_simple_check_key
#  define _ec_key_simple_check_key OPENSSL_MANGLER_ASM(ec_key_simple_check_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_key_simple_generate_key
#  define ec_key_simple_generate_key OPENSSL_MANGLER(ec_key_simple_generate_key)
# endif
#else
# ifndef _ec_key_simple_generate_key
#  define _ec_key_simple_generate_key OPENSSL_MANGLER_ASM(ec_key_simple_generate_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_key_simple_generate_public_key
#  define ec_key_simple_generate_public_key OPENSSL_MANGLER(ec_key_simple_generate_public_key)
# endif
#else
# ifndef _ec_key_simple_generate_public_key
#  define _ec_key_simple_generate_public_key OPENSSL_MANGLER_ASM(ec_key_simple_generate_public_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_key_simple_oct2priv
#  define ec_key_simple_oct2priv OPENSSL_MANGLER(ec_key_simple_oct2priv)
# endif
#else
# ifndef _ec_key_simple_oct2priv
#  define _ec_key_simple_oct2priv OPENSSL_MANGLER_ASM(ec_key_simple_oct2priv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_key_simple_priv2oct
#  define ec_key_simple_priv2oct OPENSSL_MANGLER(ec_key_simple_priv2oct)
# endif
#else
# ifndef _ec_key_simple_priv2oct
#  define _ec_key_simple_priv2oct OPENSSL_MANGLER_ASM(ec_key_simple_priv2oct)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_KEY_up_ref
#  define EC_KEY_up_ref OPENSSL_MANGLER(EC_KEY_up_ref)
# endif
#else
# ifndef _EC_KEY_up_ref
#  define _EC_KEY_up_ref OPENSSL_MANGLER_ASM(EC_KEY_up_ref)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_METHOD_get_field_type
#  define EC_METHOD_get_field_type OPENSSL_MANGLER(EC_METHOD_get_field_type)
# endif
#else
# ifndef _EC_METHOD_get_field_type
#  define _EC_METHOD_get_field_type OPENSSL_MANGLER_ASM(EC_METHOD_get_field_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_nistz256_pre_comp_dup
#  define EC_nistz256_pre_comp_dup OPENSSL_MANGLER(EC_nistz256_pre_comp_dup)
# endif
#else
# ifndef _EC_nistz256_pre_comp_dup
#  define _EC_nistz256_pre_comp_dup OPENSSL_MANGLER_ASM(EC_nistz256_pre_comp_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_nistz256_pre_comp_free
#  define EC_nistz256_pre_comp_free OPENSSL_MANGLER(EC_nistz256_pre_comp_free)
# endif
#else
# ifndef _EC_nistz256_pre_comp_free
#  define _EC_nistz256_pre_comp_free OPENSSL_MANGLER_ASM(EC_nistz256_pre_comp_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECPARAMETERS_free
#  define ECPARAMETERS_free OPENSSL_MANGLER(ECPARAMETERS_free)
# endif
#else
# ifndef _ECPARAMETERS_free
#  define _ECPARAMETERS_free OPENSSL_MANGLER_ASM(ECPARAMETERS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECPARAMETERS_it
#  define ECPARAMETERS_it OPENSSL_MANGLER(ECPARAMETERS_it)
# endif
#else
# ifndef _ECPARAMETERS_it
#  define _ECPARAMETERS_it OPENSSL_MANGLER_ASM(ECPARAMETERS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECPARAMETERS_new
#  define ECPARAMETERS_new OPENSSL_MANGLER(ECPARAMETERS_new)
# endif
#else
# ifndef _ECPARAMETERS_new
#  define _ECPARAMETERS_new OPENSSL_MANGLER_ASM(ECPARAMETERS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECParameters_print
#  define ECParameters_print OPENSSL_MANGLER(ECParameters_print)
# endif
#else
# ifndef _ECParameters_print
#  define _ECParameters_print OPENSSL_MANGLER_ASM(ECParameters_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECParameters_print_fp
#  define ECParameters_print_fp OPENSSL_MANGLER(ECParameters_print_fp)
# endif
#else
# ifndef _ECParameters_print_fp
#  define _ECParameters_print_fp OPENSSL_MANGLER_ASM(ECParameters_print_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_pkey_meth
#  define ec_pkey_meth OPENSSL_MANGLER(ec_pkey_meth)
# endif
#else
# ifndef _ec_pkey_meth
#  define _ec_pkey_meth OPENSSL_MANGLER_ASM(ec_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECPKPARAMETERS_free
#  define ECPKPARAMETERS_free OPENSSL_MANGLER(ECPKPARAMETERS_free)
# endif
#else
# ifndef _ECPKPARAMETERS_free
#  define _ECPKPARAMETERS_free OPENSSL_MANGLER_ASM(ECPKPARAMETERS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECPKPARAMETERS_it
#  define ECPKPARAMETERS_it OPENSSL_MANGLER(ECPKPARAMETERS_it)
# endif
#else
# ifndef _ECPKPARAMETERS_it
#  define _ECPKPARAMETERS_it OPENSSL_MANGLER_ASM(ECPKPARAMETERS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECPKPARAMETERS_new
#  define ECPKPARAMETERS_new OPENSSL_MANGLER(ECPKPARAMETERS_new)
# endif
#else
# ifndef _ECPKPARAMETERS_new
#  define _ECPKPARAMETERS_new OPENSSL_MANGLER_ASM(ECPKPARAMETERS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECPKParameters_print
#  define ECPKParameters_print OPENSSL_MANGLER(ECPKParameters_print)
# endif
#else
# ifndef _ECPKParameters_print
#  define _ECPKParameters_print OPENSSL_MANGLER_ASM(ECPKParameters_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ECPKParameters_print_fp
#  define ECPKParameters_print_fp OPENSSL_MANGLER(ECPKParameters_print_fp)
# endif
#else
# ifndef _ECPKParameters_print_fp
#  define _ECPKParameters_print_fp OPENSSL_MANGLER_ASM(ECPKParameters_print_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_add
#  define ecp_nistz256_add OPENSSL_MANGLER(ecp_nistz256_add)
# endif
#else
# ifndef _ecp_nistz256_add
#  define _ecp_nistz256_add OPENSSL_MANGLER_ASM(ecp_nistz256_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_avx2_gather_w7
#  define ecp_nistz256_avx2_gather_w7 OPENSSL_MANGLER(ecp_nistz256_avx2_gather_w7)
# endif
#else
# ifndef _ecp_nistz256_avx2_gather_w7
#  define _ecp_nistz256_avx2_gather_w7 OPENSSL_MANGLER_ASM(ecp_nistz256_avx2_gather_w7)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_div_by_2
#  define ecp_nistz256_div_by_2 OPENSSL_MANGLER(ecp_nistz256_div_by_2)
# endif
#else
# ifndef _ecp_nistz256_div_by_2
#  define _ecp_nistz256_div_by_2 OPENSSL_MANGLER_ASM(ecp_nistz256_div_by_2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_from_mont
#  define ecp_nistz256_from_mont OPENSSL_MANGLER(ecp_nistz256_from_mont)
# endif
#else
# ifndef _ecp_nistz256_from_mont
#  define _ecp_nistz256_from_mont OPENSSL_MANGLER_ASM(ecp_nistz256_from_mont)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_gather_w5
#  define ecp_nistz256_gather_w5 OPENSSL_MANGLER(ecp_nistz256_gather_w5)
# endif
#else
# ifndef _ecp_nistz256_gather_w5
#  define _ecp_nistz256_gather_w5 OPENSSL_MANGLER_ASM(ecp_nistz256_gather_w5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_gather_w7
#  define ecp_nistz256_gather_w7 OPENSSL_MANGLER(ecp_nistz256_gather_w7)
# endif
#else
# ifndef _ecp_nistz256_gather_w7
#  define _ecp_nistz256_gather_w7 OPENSSL_MANGLER_ASM(ecp_nistz256_gather_w7)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_mul_by_2
#  define ecp_nistz256_mul_by_2 OPENSSL_MANGLER(ecp_nistz256_mul_by_2)
# endif
#else
# ifndef _ecp_nistz256_mul_by_2
#  define _ecp_nistz256_mul_by_2 OPENSSL_MANGLER_ASM(ecp_nistz256_mul_by_2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_mul_by_3
#  define ecp_nistz256_mul_by_3 OPENSSL_MANGLER(ecp_nistz256_mul_by_3)
# endif
#else
# ifndef _ecp_nistz256_mul_by_3
#  define _ecp_nistz256_mul_by_3 OPENSSL_MANGLER_ASM(ecp_nistz256_mul_by_3)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_mul_mont
#  define ecp_nistz256_mul_mont OPENSSL_MANGLER(ecp_nistz256_mul_mont)
# endif
#else
# ifndef _ecp_nistz256_mul_mont
#  define _ecp_nistz256_mul_mont OPENSSL_MANGLER_ASM(ecp_nistz256_mul_mont)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_neg
#  define ecp_nistz256_neg OPENSSL_MANGLER(ecp_nistz256_neg)
# endif
#else
# ifndef _ecp_nistz256_neg
#  define _ecp_nistz256_neg OPENSSL_MANGLER_ASM(ecp_nistz256_neg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_ord_mul_mont
#  define ecp_nistz256_ord_mul_mont OPENSSL_MANGLER(ecp_nistz256_ord_mul_mont)
# endif
#else
# ifndef _ecp_nistz256_ord_mul_mont
#  define _ecp_nistz256_ord_mul_mont OPENSSL_MANGLER_ASM(ecp_nistz256_ord_mul_mont)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_ord_sqr_mont
#  define ecp_nistz256_ord_sqr_mont OPENSSL_MANGLER(ecp_nistz256_ord_sqr_mont)
# endif
#else
# ifndef _ecp_nistz256_ord_sqr_mont
#  define _ecp_nistz256_ord_sqr_mont OPENSSL_MANGLER_ASM(ecp_nistz256_ord_sqr_mont)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_point_add
#  define ecp_nistz256_point_add OPENSSL_MANGLER(ecp_nistz256_point_add)
# endif
#else
# ifndef _ecp_nistz256_point_add
#  define _ecp_nistz256_point_add OPENSSL_MANGLER_ASM(ecp_nistz256_point_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_point_add_affine
#  define ecp_nistz256_point_add_affine OPENSSL_MANGLER(ecp_nistz256_point_add_affine)
# endif
#else
# ifndef _ecp_nistz256_point_add_affine
#  define _ecp_nistz256_point_add_affine OPENSSL_MANGLER_ASM(ecp_nistz256_point_add_affine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_point_double
#  define ecp_nistz256_point_double OPENSSL_MANGLER(ecp_nistz256_point_double)
# endif
#else
# ifndef _ecp_nistz256_point_double
#  define _ecp_nistz256_point_double OPENSSL_MANGLER_ASM(ecp_nistz256_point_double)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_precomputed
#  define ecp_nistz256_precomputed OPENSSL_MANGLER(ecp_nistz256_precomputed)
# endif
#else
# ifndef _ecp_nistz256_precomputed
#  define _ecp_nistz256_precomputed OPENSSL_MANGLER_ASM(ecp_nistz256_precomputed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_scatter_w5
#  define ecp_nistz256_scatter_w5 OPENSSL_MANGLER(ecp_nistz256_scatter_w5)
# endif
#else
# ifndef _ecp_nistz256_scatter_w5
#  define _ecp_nistz256_scatter_w5 OPENSSL_MANGLER_ASM(ecp_nistz256_scatter_w5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_scatter_w7
#  define ecp_nistz256_scatter_w7 OPENSSL_MANGLER(ecp_nistz256_scatter_w7)
# endif
#else
# ifndef _ecp_nistz256_scatter_w7
#  define _ecp_nistz256_scatter_w7 OPENSSL_MANGLER_ASM(ecp_nistz256_scatter_w7)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_sqr_mont
#  define ecp_nistz256_sqr_mont OPENSSL_MANGLER(ecp_nistz256_sqr_mont)
# endif
#else
# ifndef _ecp_nistz256_sqr_mont
#  define _ecp_nistz256_sqr_mont OPENSSL_MANGLER_ASM(ecp_nistz256_sqr_mont)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_sub
#  define ecp_nistz256_sub OPENSSL_MANGLER(ecp_nistz256_sub)
# endif
#else
# ifndef _ecp_nistz256_sub
#  define _ecp_nistz256_sub OPENSSL_MANGLER_ASM(ecp_nistz256_sub)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecp_nistz256_to_mont
#  define ecp_nistz256_to_mont OPENSSL_MANGLER(ecp_nistz256_to_mont)
# endif
#else
# ifndef _ecp_nistz256_to_mont
#  define _ecp_nistz256_to_mont OPENSSL_MANGLER_ASM(ecp_nistz256_to_mont)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_add
#  define EC_POINT_add OPENSSL_MANGLER(EC_POINT_add)
# endif
#else
# ifndef _EC_POINT_add
#  define _EC_POINT_add OPENSSL_MANGLER_ASM(EC_POINT_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_point_blind_coordinates
#  define ec_point_blind_coordinates OPENSSL_MANGLER(ec_point_blind_coordinates)
# endif
#else
# ifndef _ec_point_blind_coordinates
#  define _ec_point_blind_coordinates OPENSSL_MANGLER_ASM(ec_point_blind_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_bn2point
#  define EC_POINT_bn2point OPENSSL_MANGLER(EC_POINT_bn2point)
# endif
#else
# ifndef _EC_POINT_bn2point
#  define _EC_POINT_bn2point OPENSSL_MANGLER_ASM(EC_POINT_bn2point)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_clear_free
#  define EC_POINT_clear_free OPENSSL_MANGLER(EC_POINT_clear_free)
# endif
#else
# ifndef _EC_POINT_clear_free
#  define _EC_POINT_clear_free OPENSSL_MANGLER_ASM(EC_POINT_clear_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_cmp
#  define EC_POINT_cmp OPENSSL_MANGLER(EC_POINT_cmp)
# endif
#else
# ifndef _EC_POINT_cmp
#  define _EC_POINT_cmp OPENSSL_MANGLER_ASM(EC_POINT_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_copy
#  define EC_POINT_copy OPENSSL_MANGLER(EC_POINT_copy)
# endif
#else
# ifndef _EC_POINT_copy
#  define _EC_POINT_copy OPENSSL_MANGLER_ASM(EC_POINT_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_dbl
#  define EC_POINT_dbl OPENSSL_MANGLER(EC_POINT_dbl)
# endif
#else
# ifndef _EC_POINT_dbl
#  define _EC_POINT_dbl OPENSSL_MANGLER_ASM(EC_POINT_dbl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_dup
#  define EC_POINT_dup OPENSSL_MANGLER(EC_POINT_dup)
# endif
#else
# ifndef _EC_POINT_dup
#  define _EC_POINT_dup OPENSSL_MANGLER_ASM(EC_POINT_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_free
#  define EC_POINT_free OPENSSL_MANGLER(EC_POINT_free)
# endif
#else
# ifndef _EC_POINT_free
#  define _EC_POINT_free OPENSSL_MANGLER_ASM(EC_POINT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_get_affine_coordinates
#  define EC_POINT_get_affine_coordinates OPENSSL_MANGLER(EC_POINT_get_affine_coordinates)
# endif
#else
# ifndef _EC_POINT_get_affine_coordinates
#  define _EC_POINT_get_affine_coordinates OPENSSL_MANGLER_ASM(EC_POINT_get_affine_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_get_affine_coordinates_GF2m
#  define EC_POINT_get_affine_coordinates_GF2m OPENSSL_MANGLER(EC_POINT_get_affine_coordinates_GF2m)
# endif
#else
# ifndef _EC_POINT_get_affine_coordinates_GF2m
#  define _EC_POINT_get_affine_coordinates_GF2m OPENSSL_MANGLER_ASM(EC_POINT_get_affine_coordinates_GF2m)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_get_affine_coordinates_GFp
#  define EC_POINT_get_affine_coordinates_GFp OPENSSL_MANGLER(EC_POINT_get_affine_coordinates_GFp)
# endif
#else
# ifndef _EC_POINT_get_affine_coordinates_GFp
#  define _EC_POINT_get_affine_coordinates_GFp OPENSSL_MANGLER_ASM(EC_POINT_get_affine_coordinates_GFp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_get_Jprojective_coordinates_GFp
#  define EC_POINT_get_Jprojective_coordinates_GFp OPENSSL_MANGLER(EC_POINT_get_Jprojective_coordinates_GFp)
# endif
#else
# ifndef _EC_POINT_get_Jprojective_coordinates_GFp
#  define _EC_POINT_get_Jprojective_coordinates_GFp OPENSSL_MANGLER_ASM(EC_POINT_get_Jprojective_coordinates_GFp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_hex2point
#  define EC_POINT_hex2point OPENSSL_MANGLER(EC_POINT_hex2point)
# endif
#else
# ifndef _EC_POINT_hex2point
#  define _EC_POINT_hex2point OPENSSL_MANGLER_ASM(EC_POINT_hex2point)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_invert
#  define EC_POINT_invert OPENSSL_MANGLER(EC_POINT_invert)
# endif
#else
# ifndef _EC_POINT_invert
#  define _EC_POINT_invert OPENSSL_MANGLER_ASM(EC_POINT_invert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_is_at_infinity
#  define EC_POINT_is_at_infinity OPENSSL_MANGLER(EC_POINT_is_at_infinity)
# endif
#else
# ifndef _EC_POINT_is_at_infinity
#  define _EC_POINT_is_at_infinity OPENSSL_MANGLER_ASM(EC_POINT_is_at_infinity)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_is_on_curve
#  define EC_POINT_is_on_curve OPENSSL_MANGLER(EC_POINT_is_on_curve)
# endif
#else
# ifndef _EC_POINT_is_on_curve
#  define _EC_POINT_is_on_curve OPENSSL_MANGLER_ASM(EC_POINT_is_on_curve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_make_affine
#  define EC_POINT_make_affine OPENSSL_MANGLER(EC_POINT_make_affine)
# endif
#else
# ifndef _EC_POINT_make_affine
#  define _EC_POINT_make_affine OPENSSL_MANGLER_ASM(EC_POINT_make_affine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_method_of
#  define EC_POINT_method_of OPENSSL_MANGLER(EC_POINT_method_of)
# endif
#else
# ifndef _EC_POINT_method_of
#  define _EC_POINT_method_of OPENSSL_MANGLER_ASM(EC_POINT_method_of)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_mul
#  define EC_POINT_mul OPENSSL_MANGLER(EC_POINT_mul)
# endif
#else
# ifndef _EC_POINT_mul
#  define _EC_POINT_mul OPENSSL_MANGLER_ASM(EC_POINT_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_new
#  define EC_POINT_new OPENSSL_MANGLER(EC_POINT_new)
# endif
#else
# ifndef _EC_POINT_new
#  define _EC_POINT_new OPENSSL_MANGLER_ASM(EC_POINT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_oct2point
#  define EC_POINT_oct2point OPENSSL_MANGLER(EC_POINT_oct2point)
# endif
#else
# ifndef _EC_POINT_oct2point
#  define _EC_POINT_oct2point OPENSSL_MANGLER_ASM(EC_POINT_oct2point)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_point2bn
#  define EC_POINT_point2bn OPENSSL_MANGLER(EC_POINT_point2bn)
# endif
#else
# ifndef _EC_POINT_point2bn
#  define _EC_POINT_point2bn OPENSSL_MANGLER_ASM(EC_POINT_point2bn)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_point2buf
#  define EC_POINT_point2buf OPENSSL_MANGLER(EC_POINT_point2buf)
# endif
#else
# ifndef _EC_POINT_point2buf
#  define _EC_POINT_point2buf OPENSSL_MANGLER_ASM(EC_POINT_point2buf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_point2hex
#  define EC_POINT_point2hex OPENSSL_MANGLER(EC_POINT_point2hex)
# endif
#else
# ifndef _EC_POINT_point2hex
#  define _EC_POINT_point2hex OPENSSL_MANGLER_ASM(EC_POINT_point2hex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_point2oct
#  define EC_POINT_point2oct OPENSSL_MANGLER(EC_POINT_point2oct)
# endif
#else
# ifndef _EC_POINT_point2oct
#  define _EC_POINT_point2oct OPENSSL_MANGLER_ASM(EC_POINT_point2oct)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_set_affine_coordinates
#  define EC_POINT_set_affine_coordinates OPENSSL_MANGLER(EC_POINT_set_affine_coordinates)
# endif
#else
# ifndef _EC_POINT_set_affine_coordinates
#  define _EC_POINT_set_affine_coordinates OPENSSL_MANGLER_ASM(EC_POINT_set_affine_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_set_affine_coordinates_GF2m
#  define EC_POINT_set_affine_coordinates_GF2m OPENSSL_MANGLER(EC_POINT_set_affine_coordinates_GF2m)
# endif
#else
# ifndef _EC_POINT_set_affine_coordinates_GF2m
#  define _EC_POINT_set_affine_coordinates_GF2m OPENSSL_MANGLER_ASM(EC_POINT_set_affine_coordinates_GF2m)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_set_affine_coordinates_GFp
#  define EC_POINT_set_affine_coordinates_GFp OPENSSL_MANGLER(EC_POINT_set_affine_coordinates_GFp)
# endif
#else
# ifndef _EC_POINT_set_affine_coordinates_GFp
#  define _EC_POINT_set_affine_coordinates_GFp OPENSSL_MANGLER_ASM(EC_POINT_set_affine_coordinates_GFp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_set_compressed_coordinates
#  define EC_POINT_set_compressed_coordinates OPENSSL_MANGLER(EC_POINT_set_compressed_coordinates)
# endif
#else
# ifndef _EC_POINT_set_compressed_coordinates
#  define _EC_POINT_set_compressed_coordinates OPENSSL_MANGLER_ASM(EC_POINT_set_compressed_coordinates)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_set_compressed_coordinates_GF2m
#  define EC_POINT_set_compressed_coordinates_GF2m OPENSSL_MANGLER(EC_POINT_set_compressed_coordinates_GF2m)
# endif
#else
# ifndef _EC_POINT_set_compressed_coordinates_GF2m
#  define _EC_POINT_set_compressed_coordinates_GF2m OPENSSL_MANGLER_ASM(EC_POINT_set_compressed_coordinates_GF2m)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_set_compressed_coordinates_GFp
#  define EC_POINT_set_compressed_coordinates_GFp OPENSSL_MANGLER(EC_POINT_set_compressed_coordinates_GFp)
# endif
#else
# ifndef _EC_POINT_set_compressed_coordinates_GFp
#  define _EC_POINT_set_compressed_coordinates_GFp OPENSSL_MANGLER_ASM(EC_POINT_set_compressed_coordinates_GFp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_set_Jprojective_coordinates_GFp
#  define EC_POINT_set_Jprojective_coordinates_GFp OPENSSL_MANGLER(EC_POINT_set_Jprojective_coordinates_GFp)
# endif
#else
# ifndef _EC_POINT_set_Jprojective_coordinates_GFp
#  define _EC_POINT_set_Jprojective_coordinates_GFp OPENSSL_MANGLER_ASM(EC_POINT_set_Jprojective_coordinates_GFp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINT_set_to_infinity
#  define EC_POINT_set_to_infinity OPENSSL_MANGLER(EC_POINT_set_to_infinity)
# endif
#else
# ifndef _EC_POINT_set_to_infinity
#  define _EC_POINT_set_to_infinity OPENSSL_MANGLER_ASM(EC_POINT_set_to_infinity)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINTs_make_affine
#  define EC_POINTs_make_affine OPENSSL_MANGLER(EC_POINTs_make_affine)
# endif
#else
# ifndef _EC_POINTs_make_affine
#  define _EC_POINTs_make_affine OPENSSL_MANGLER_ASM(EC_POINTs_make_affine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_POINTs_mul
#  define EC_POINTs_mul OPENSSL_MANGLER(EC_POINTs_mul)
# endif
#else
# ifndef _EC_POINTs_mul
#  define _EC_POINTs_mul OPENSSL_MANGLER_ASM(EC_POINTs_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_pre_comp_free
#  define EC_pre_comp_free OPENSSL_MANGLER(EC_pre_comp_free)
# endif
#else
# ifndef _EC_pre_comp_free
#  define _EC_pre_comp_free OPENSSL_MANGLER_ASM(EC_pre_comp_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_PRIVATEKEY_free
#  define EC_PRIVATEKEY_free OPENSSL_MANGLER(EC_PRIVATEKEY_free)
# endif
#else
# ifndef _EC_PRIVATEKEY_free
#  define _EC_PRIVATEKEY_free OPENSSL_MANGLER_ASM(EC_PRIVATEKEY_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EC_PRIVATEKEY_new
#  define EC_PRIVATEKEY_new OPENSSL_MANGLER(EC_PRIVATEKEY_new)
# endif
#else
# ifndef _EC_PRIVATEKEY_new
#  define _EC_PRIVATEKEY_new OPENSSL_MANGLER_ASM(EC_PRIVATEKEY_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_scalar_mul_ladder
#  define ec_scalar_mul_ladder OPENSSL_MANGLER(ec_scalar_mul_ladder)
# endif
#else
# ifndef _ec_scalar_mul_ladder
#  define _ec_scalar_mul_ladder OPENSSL_MANGLER_ASM(ec_scalar_mul_ladder)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_wNAF_have_precompute_mult
#  define ec_wNAF_have_precompute_mult OPENSSL_MANGLER(ec_wNAF_have_precompute_mult)
# endif
#else
# ifndef _ec_wNAF_have_precompute_mult
#  define _ec_wNAF_have_precompute_mult OPENSSL_MANGLER_ASM(ec_wNAF_have_precompute_mult)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_wNAF_mul
#  define ec_wNAF_mul OPENSSL_MANGLER(ec_wNAF_mul)
# endif
#else
# ifndef _ec_wNAF_mul
#  define _ec_wNAF_mul OPENSSL_MANGLER_ASM(ec_wNAF_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ec_wNAF_precompute_mult
#  define ec_wNAF_precompute_mult OPENSSL_MANGLER(ec_wNAF_precompute_mult)
# endif
#else
# ifndef _ec_wNAF_precompute_mult
#  define _ec_wNAF_precompute_mult OPENSSL_MANGLER_ASM(ec_wNAF_precompute_mult)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecx25519_asn1_meth
#  define ecx25519_asn1_meth OPENSSL_MANGLER(ecx25519_asn1_meth)
# endif
#else
# ifndef _ecx25519_asn1_meth
#  define _ecx25519_asn1_meth OPENSSL_MANGLER_ASM(ecx25519_asn1_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecx25519_pkey_meth
#  define ecx25519_pkey_meth OPENSSL_MANGLER(ecx25519_pkey_meth)
# endif
#else
# ifndef _ecx25519_pkey_meth
#  define _ecx25519_pkey_meth OPENSSL_MANGLER_ASM(ecx25519_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecx448_asn1_meth
#  define ecx448_asn1_meth OPENSSL_MANGLER(ecx448_asn1_meth)
# endif
#else
# ifndef _ecx448_asn1_meth
#  define _ecx448_asn1_meth OPENSSL_MANGLER_ASM(ecx448_asn1_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ecx448_pkey_meth
#  define ecx448_pkey_meth OPENSSL_MANGLER(ecx448_pkey_meth)
# endif
#else
# ifndef _ecx448_pkey_meth
#  define _ecx448_pkey_meth OPENSSL_MANGLER_ASM(ecx448_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ed25519_asn1_meth
#  define ed25519_asn1_meth OPENSSL_MANGLER(ed25519_asn1_meth)
# endif
#else
# ifndef _ed25519_asn1_meth
#  define _ed25519_asn1_meth OPENSSL_MANGLER_ASM(ed25519_asn1_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ed25519_pkey_meth
#  define ed25519_pkey_meth OPENSSL_MANGLER(ed25519_pkey_meth)
# endif
#else
# ifndef _ed25519_pkey_meth
#  define _ed25519_pkey_meth OPENSSL_MANGLER_ASM(ed25519_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ED25519_public_from_private
#  define ED25519_public_from_private OPENSSL_MANGLER(ED25519_public_from_private)
# endif
#else
# ifndef _ED25519_public_from_private
#  define _ED25519_public_from_private OPENSSL_MANGLER_ASM(ED25519_public_from_private)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ED25519_sign
#  define ED25519_sign OPENSSL_MANGLER(ED25519_sign)
# endif
#else
# ifndef _ED25519_sign
#  define _ED25519_sign OPENSSL_MANGLER_ASM(ED25519_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ED25519_verify
#  define ED25519_verify OPENSSL_MANGLER(ED25519_verify)
# endif
#else
# ifndef _ED25519_verify
#  define _ED25519_verify OPENSSL_MANGLER_ASM(ED25519_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ed448_asn1_meth
#  define ed448_asn1_meth OPENSSL_MANGLER(ed448_asn1_meth)
# endif
#else
# ifndef _ed448_asn1_meth
#  define _ed448_asn1_meth OPENSSL_MANGLER_ASM(ed448_asn1_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ED448ph_sign
#  define ED448ph_sign OPENSSL_MANGLER(ED448ph_sign)
# endif
#else
# ifndef _ED448ph_sign
#  define _ED448ph_sign OPENSSL_MANGLER_ASM(ED448ph_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ED448ph_verify
#  define ED448ph_verify OPENSSL_MANGLER(ED448ph_verify)
# endif
#else
# ifndef _ED448ph_verify
#  define _ED448ph_verify OPENSSL_MANGLER_ASM(ED448ph_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ed448_pkey_meth
#  define ed448_pkey_meth OPENSSL_MANGLER(ed448_pkey_meth)
# endif
#else
# ifndef _ed448_pkey_meth
#  define _ed448_pkey_meth OPENSSL_MANGLER_ASM(ed448_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ED448_public_from_private
#  define ED448_public_from_private OPENSSL_MANGLER(ED448_public_from_private)
# endif
#else
# ifndef _ED448_public_from_private
#  define _ED448_public_from_private OPENSSL_MANGLER_ASM(ED448_public_from_private)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ED448_sign
#  define ED448_sign OPENSSL_MANGLER(ED448_sign)
# endif
#else
# ifndef _ED448_sign
#  define _ED448_sign OPENSSL_MANGLER_ASM(ED448_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ED448_verify
#  define ED448_verify OPENSSL_MANGLER(ED448_verify)
# endif
#else
# ifndef _ED448_verify
#  define _ED448_verify OPENSSL_MANGLER_ASM(ED448_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EDIPARTYNAME_free
#  define EDIPARTYNAME_free OPENSSL_MANGLER(EDIPARTYNAME_free)
# endif
#else
# ifndef _EDIPARTYNAME_free
#  define _EDIPARTYNAME_free OPENSSL_MANGLER_ASM(EDIPARTYNAME_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EDIPARTYNAME_it
#  define EDIPARTYNAME_it OPENSSL_MANGLER(EDIPARTYNAME_it)
# endif
#else
# ifndef _EDIPARTYNAME_it
#  define _EDIPARTYNAME_it OPENSSL_MANGLER_ASM(EDIPARTYNAME_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EDIPARTYNAME_new
#  define EDIPARTYNAME_new OPENSSL_MANGLER(EDIPARTYNAME_new)
# endif
#else
# ifndef _EDIPARTYNAME_new
#  define _EDIPARTYNAME_new OPENSSL_MANGLER_ASM(EDIPARTYNAME_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_add_error_data
#  define ERR_add_error_data OPENSSL_MANGLER(ERR_add_error_data)
# endif
#else
# ifndef _ERR_add_error_data
#  define _ERR_add_error_data OPENSSL_MANGLER_ASM(ERR_add_error_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_add_error_vdata
#  define ERR_add_error_vdata OPENSSL_MANGLER(ERR_add_error_vdata)
# endif
#else
# ifndef _ERR_add_error_vdata
#  define _ERR_add_error_vdata OPENSSL_MANGLER_ASM(ERR_add_error_vdata)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef err_cleanup
#  define err_cleanup OPENSSL_MANGLER(err_cleanup)
# endif
#else
# ifndef _err_cleanup
#  define _err_cleanup OPENSSL_MANGLER_ASM(err_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_clear_error
#  define ERR_clear_error OPENSSL_MANGLER(ERR_clear_error)
# endif
#else
# ifndef _ERR_clear_error
#  define _ERR_clear_error OPENSSL_MANGLER_ASM(ERR_clear_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef err_clear_last_constant_time
#  define err_clear_last_constant_time OPENSSL_MANGLER(err_clear_last_constant_time)
# endif
#else
# ifndef _err_clear_last_constant_time
#  define _err_clear_last_constant_time OPENSSL_MANGLER_ASM(err_clear_last_constant_time)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_clear_last_mark
#  define ERR_clear_last_mark OPENSSL_MANGLER(ERR_clear_last_mark)
# endif
#else
# ifndef _ERR_clear_last_mark
#  define _ERR_clear_last_mark OPENSSL_MANGLER_ASM(ERR_clear_last_mark)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef err_delete_thread_state
#  define err_delete_thread_state OPENSSL_MANGLER(err_delete_thread_state)
# endif
#else
# ifndef _err_delete_thread_state
#  define _err_delete_thread_state OPENSSL_MANGLER_ASM(err_delete_thread_state)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_error_string
#  define ERR_error_string OPENSSL_MANGLER(ERR_error_string)
# endif
#else
# ifndef _ERR_error_string
#  define _ERR_error_string OPENSSL_MANGLER_ASM(ERR_error_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_error_string_n
#  define ERR_error_string_n OPENSSL_MANGLER(ERR_error_string_n)
# endif
#else
# ifndef _ERR_error_string_n
#  define _ERR_error_string_n OPENSSL_MANGLER_ASM(ERR_error_string_n)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef err_free_strings_int
#  define err_free_strings_int OPENSSL_MANGLER(err_free_strings_int)
# endif
#else
# ifndef _err_free_strings_int
#  define _err_free_strings_int OPENSSL_MANGLER_ASM(err_free_strings_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_func_error_string
#  define ERR_func_error_string OPENSSL_MANGLER(ERR_func_error_string)
# endif
#else
# ifndef _ERR_func_error_string
#  define _ERR_func_error_string OPENSSL_MANGLER_ASM(ERR_func_error_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_get_error
#  define ERR_get_error OPENSSL_MANGLER(ERR_get_error)
# endif
#else
# ifndef _ERR_get_error
#  define _ERR_get_error OPENSSL_MANGLER_ASM(ERR_get_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_get_error_line
#  define ERR_get_error_line OPENSSL_MANGLER(ERR_get_error_line)
# endif
#else
# ifndef _ERR_get_error_line
#  define _ERR_get_error_line OPENSSL_MANGLER_ASM(ERR_get_error_line)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_get_error_line_data
#  define ERR_get_error_line_data OPENSSL_MANGLER(ERR_get_error_line_data)
# endif
#else
# ifndef _ERR_get_error_line_data
#  define _ERR_get_error_line_data OPENSSL_MANGLER_ASM(ERR_get_error_line_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_get_next_error_library
#  define ERR_get_next_error_library OPENSSL_MANGLER(ERR_get_next_error_library)
# endif
#else
# ifndef _ERR_get_next_error_library
#  define _ERR_get_next_error_library OPENSSL_MANGLER_ASM(ERR_get_next_error_library)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_get_state
#  define ERR_get_state OPENSSL_MANGLER(ERR_get_state)
# endif
#else
# ifndef _ERR_get_state
#  define _ERR_get_state OPENSSL_MANGLER_ASM(ERR_get_state)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_lib_error_string
#  define ERR_lib_error_string OPENSSL_MANGLER(ERR_lib_error_string)
# endif
#else
# ifndef _ERR_lib_error_string
#  define _ERR_lib_error_string OPENSSL_MANGLER_ASM(ERR_lib_error_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_ASN1_strings
#  define ERR_load_ASN1_strings OPENSSL_MANGLER(ERR_load_ASN1_strings)
# endif
#else
# ifndef _ERR_load_ASN1_strings
#  define _ERR_load_ASN1_strings OPENSSL_MANGLER_ASM(ERR_load_ASN1_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_ASYNC_strings
#  define ERR_load_ASYNC_strings OPENSSL_MANGLER(ERR_load_ASYNC_strings)
# endif
#else
# ifndef _ERR_load_ASYNC_strings
#  define _ERR_load_ASYNC_strings OPENSSL_MANGLER_ASM(ERR_load_ASYNC_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_BIO_strings
#  define ERR_load_BIO_strings OPENSSL_MANGLER(ERR_load_BIO_strings)
# endif
#else
# ifndef _ERR_load_BIO_strings
#  define _ERR_load_BIO_strings OPENSSL_MANGLER_ASM(ERR_load_BIO_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_BN_strings
#  define ERR_load_BN_strings OPENSSL_MANGLER(ERR_load_BN_strings)
# endif
#else
# ifndef _ERR_load_BN_strings
#  define _ERR_load_BN_strings OPENSSL_MANGLER_ASM(ERR_load_BN_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_BUF_strings
#  define ERR_load_BUF_strings OPENSSL_MANGLER(ERR_load_BUF_strings)
# endif
#else
# ifndef _ERR_load_BUF_strings
#  define _ERR_load_BUF_strings OPENSSL_MANGLER_ASM(ERR_load_BUF_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_CMS_strings
#  define ERR_load_CMS_strings OPENSSL_MANGLER(ERR_load_CMS_strings)
# endif
#else
# ifndef _ERR_load_CMS_strings
#  define _ERR_load_CMS_strings OPENSSL_MANGLER_ASM(ERR_load_CMS_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_CONF_strings
#  define ERR_load_CONF_strings OPENSSL_MANGLER(ERR_load_CONF_strings)
# endif
#else
# ifndef _ERR_load_CONF_strings
#  define _ERR_load_CONF_strings OPENSSL_MANGLER_ASM(ERR_load_CONF_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_CRYPTO_strings
#  define ERR_load_CRYPTO_strings OPENSSL_MANGLER(ERR_load_CRYPTO_strings)
# endif
#else
# ifndef _ERR_load_CRYPTO_strings
#  define _ERR_load_CRYPTO_strings OPENSSL_MANGLER_ASM(ERR_load_CRYPTO_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef err_load_crypto_strings_int
#  define err_load_crypto_strings_int OPENSSL_MANGLER(err_load_crypto_strings_int)
# endif
#else
# ifndef _err_load_crypto_strings_int
#  define _err_load_crypto_strings_int OPENSSL_MANGLER_ASM(err_load_crypto_strings_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_CT_strings
#  define ERR_load_CT_strings OPENSSL_MANGLER(ERR_load_CT_strings)
# endif
#else
# ifndef _ERR_load_CT_strings
#  define _ERR_load_CT_strings OPENSSL_MANGLER_ASM(ERR_load_CT_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_DH_strings
#  define ERR_load_DH_strings OPENSSL_MANGLER(ERR_load_DH_strings)
# endif
#else
# ifndef _ERR_load_DH_strings
#  define _ERR_load_DH_strings OPENSSL_MANGLER_ASM(ERR_load_DH_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_DSA_strings
#  define ERR_load_DSA_strings OPENSSL_MANGLER(ERR_load_DSA_strings)
# endif
#else
# ifndef _ERR_load_DSA_strings
#  define _ERR_load_DSA_strings OPENSSL_MANGLER_ASM(ERR_load_DSA_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_DSO_strings
#  define ERR_load_DSO_strings OPENSSL_MANGLER(ERR_load_DSO_strings)
# endif
#else
# ifndef _ERR_load_DSO_strings
#  define _ERR_load_DSO_strings OPENSSL_MANGLER_ASM(ERR_load_DSO_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_EC_strings
#  define ERR_load_EC_strings OPENSSL_MANGLER(ERR_load_EC_strings)
# endif
#else
# ifndef _ERR_load_EC_strings
#  define _ERR_load_EC_strings OPENSSL_MANGLER_ASM(ERR_load_EC_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_ERR_strings
#  define ERR_load_ERR_strings OPENSSL_MANGLER(ERR_load_ERR_strings)
# endif
#else
# ifndef _ERR_load_ERR_strings
#  define _ERR_load_ERR_strings OPENSSL_MANGLER_ASM(ERR_load_ERR_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_EVP_strings
#  define ERR_load_EVP_strings OPENSSL_MANGLER(ERR_load_EVP_strings)
# endif
#else
# ifndef _ERR_load_EVP_strings
#  define _ERR_load_EVP_strings OPENSSL_MANGLER_ASM(ERR_load_EVP_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_KDF_strings
#  define ERR_load_KDF_strings OPENSSL_MANGLER(ERR_load_KDF_strings)
# endif
#else
# ifndef _ERR_load_KDF_strings
#  define _ERR_load_KDF_strings OPENSSL_MANGLER_ASM(ERR_load_KDF_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_OBJ_strings
#  define ERR_load_OBJ_strings OPENSSL_MANGLER(ERR_load_OBJ_strings)
# endif
#else
# ifndef _ERR_load_OBJ_strings
#  define _ERR_load_OBJ_strings OPENSSL_MANGLER_ASM(ERR_load_OBJ_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_OCSP_strings
#  define ERR_load_OCSP_strings OPENSSL_MANGLER(ERR_load_OCSP_strings)
# endif
#else
# ifndef _ERR_load_OCSP_strings
#  define _ERR_load_OCSP_strings OPENSSL_MANGLER_ASM(ERR_load_OCSP_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_OSSL_STORE_strings
#  define ERR_load_OSSL_STORE_strings OPENSSL_MANGLER(ERR_load_OSSL_STORE_strings)
# endif
#else
# ifndef _ERR_load_OSSL_STORE_strings
#  define _ERR_load_OSSL_STORE_strings OPENSSL_MANGLER_ASM(ERR_load_OSSL_STORE_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_PEM_strings
#  define ERR_load_PEM_strings OPENSSL_MANGLER(ERR_load_PEM_strings)
# endif
#else
# ifndef _ERR_load_PEM_strings
#  define _ERR_load_PEM_strings OPENSSL_MANGLER_ASM(ERR_load_PEM_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_PKCS12_strings
#  define ERR_load_PKCS12_strings OPENSSL_MANGLER(ERR_load_PKCS12_strings)
# endif
#else
# ifndef _ERR_load_PKCS12_strings
#  define _ERR_load_PKCS12_strings OPENSSL_MANGLER_ASM(ERR_load_PKCS12_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_PKCS7_strings
#  define ERR_load_PKCS7_strings OPENSSL_MANGLER(ERR_load_PKCS7_strings)
# endif
#else
# ifndef _ERR_load_PKCS7_strings
#  define _ERR_load_PKCS7_strings OPENSSL_MANGLER_ASM(ERR_load_PKCS7_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_RAND_strings
#  define ERR_load_RAND_strings OPENSSL_MANGLER(ERR_load_RAND_strings)
# endif
#else
# ifndef _ERR_load_RAND_strings
#  define _ERR_load_RAND_strings OPENSSL_MANGLER_ASM(ERR_load_RAND_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_RSA_strings
#  define ERR_load_RSA_strings OPENSSL_MANGLER(ERR_load_RSA_strings)
# endif
#else
# ifndef _ERR_load_RSA_strings
#  define _ERR_load_RSA_strings OPENSSL_MANGLER_ASM(ERR_load_RSA_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_SM2_strings
#  define ERR_load_SM2_strings OPENSSL_MANGLER(ERR_load_SM2_strings)
# endif
#else
# ifndef _ERR_load_SM2_strings
#  define _ERR_load_SM2_strings OPENSSL_MANGLER_ASM(ERR_load_SM2_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_SSL_strings
#  define ERR_load_SSL_strings OPENSSL_MANGLER(ERR_load_SSL_strings)
# endif
#else
# ifndef _ERR_load_SSL_strings
#  define _ERR_load_SSL_strings OPENSSL_MANGLER_ASM(ERR_load_SSL_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_strings
#  define ERR_load_strings OPENSSL_MANGLER(ERR_load_strings)
# endif
#else
# ifndef _ERR_load_strings
#  define _ERR_load_strings OPENSSL_MANGLER_ASM(ERR_load_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_strings_const
#  define ERR_load_strings_const OPENSSL_MANGLER(ERR_load_strings_const)
# endif
#else
# ifndef _ERR_load_strings_const
#  define _ERR_load_strings_const OPENSSL_MANGLER_ASM(ERR_load_strings_const)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_TS_strings
#  define ERR_load_TS_strings OPENSSL_MANGLER(ERR_load_TS_strings)
# endif
#else
# ifndef _ERR_load_TS_strings
#  define _ERR_load_TS_strings OPENSSL_MANGLER_ASM(ERR_load_TS_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_UI_strings
#  define ERR_load_UI_strings OPENSSL_MANGLER(ERR_load_UI_strings)
# endif
#else
# ifndef _ERR_load_UI_strings
#  define _ERR_load_UI_strings OPENSSL_MANGLER_ASM(ERR_load_UI_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_X509_strings
#  define ERR_load_X509_strings OPENSSL_MANGLER(ERR_load_X509_strings)
# endif
#else
# ifndef _ERR_load_X509_strings
#  define _ERR_load_X509_strings OPENSSL_MANGLER_ASM(ERR_load_X509_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_load_X509V3_strings
#  define ERR_load_X509V3_strings OPENSSL_MANGLER(ERR_load_X509V3_strings)
# endif
#else
# ifndef _ERR_load_X509V3_strings
#  define _ERR_load_X509V3_strings OPENSSL_MANGLER_ASM(ERR_load_X509V3_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_peek_error
#  define ERR_peek_error OPENSSL_MANGLER(ERR_peek_error)
# endif
#else
# ifndef _ERR_peek_error
#  define _ERR_peek_error OPENSSL_MANGLER_ASM(ERR_peek_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_peek_error_line
#  define ERR_peek_error_line OPENSSL_MANGLER(ERR_peek_error_line)
# endif
#else
# ifndef _ERR_peek_error_line
#  define _ERR_peek_error_line OPENSSL_MANGLER_ASM(ERR_peek_error_line)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_peek_error_line_data
#  define ERR_peek_error_line_data OPENSSL_MANGLER(ERR_peek_error_line_data)
# endif
#else
# ifndef _ERR_peek_error_line_data
#  define _ERR_peek_error_line_data OPENSSL_MANGLER_ASM(ERR_peek_error_line_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_peek_last_error
#  define ERR_peek_last_error OPENSSL_MANGLER(ERR_peek_last_error)
# endif
#else
# ifndef _ERR_peek_last_error
#  define _ERR_peek_last_error OPENSSL_MANGLER_ASM(ERR_peek_last_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_peek_last_error_line
#  define ERR_peek_last_error_line OPENSSL_MANGLER(ERR_peek_last_error_line)
# endif
#else
# ifndef _ERR_peek_last_error_line
#  define _ERR_peek_last_error_line OPENSSL_MANGLER_ASM(ERR_peek_last_error_line)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_peek_last_error_line_data
#  define ERR_peek_last_error_line_data OPENSSL_MANGLER(ERR_peek_last_error_line_data)
# endif
#else
# ifndef _ERR_peek_last_error_line_data
#  define _ERR_peek_last_error_line_data OPENSSL_MANGLER_ASM(ERR_peek_last_error_line_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_pop_to_mark
#  define ERR_pop_to_mark OPENSSL_MANGLER(ERR_pop_to_mark)
# endif
#else
# ifndef _ERR_pop_to_mark
#  define _ERR_pop_to_mark OPENSSL_MANGLER_ASM(ERR_pop_to_mark)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_print_errors
#  define ERR_print_errors OPENSSL_MANGLER(ERR_print_errors)
# endif
#else
# ifndef _ERR_print_errors
#  define _ERR_print_errors OPENSSL_MANGLER_ASM(ERR_print_errors)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_print_errors_cb
#  define ERR_print_errors_cb OPENSSL_MANGLER(ERR_print_errors_cb)
# endif
#else
# ifndef _ERR_print_errors_cb
#  define _ERR_print_errors_cb OPENSSL_MANGLER_ASM(ERR_print_errors_cb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_print_errors_fp
#  define ERR_print_errors_fp OPENSSL_MANGLER(ERR_print_errors_fp)
# endif
#else
# ifndef _ERR_print_errors_fp
#  define _ERR_print_errors_fp OPENSSL_MANGLER_ASM(ERR_print_errors_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_put_error
#  define ERR_put_error OPENSSL_MANGLER(ERR_put_error)
# endif
#else
# ifndef _ERR_put_error
#  define _ERR_put_error OPENSSL_MANGLER_ASM(ERR_put_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_reason_error_string
#  define ERR_reason_error_string OPENSSL_MANGLER(ERR_reason_error_string)
# endif
#else
# ifndef _ERR_reason_error_string
#  define _ERR_reason_error_string OPENSSL_MANGLER_ASM(ERR_reason_error_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_remove_state
#  define ERR_remove_state OPENSSL_MANGLER(ERR_remove_state)
# endif
#else
# ifndef _ERR_remove_state
#  define _ERR_remove_state OPENSSL_MANGLER_ASM(ERR_remove_state)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_remove_thread_state
#  define ERR_remove_thread_state OPENSSL_MANGLER(ERR_remove_thread_state)
# endif
#else
# ifndef _ERR_remove_thread_state
#  define _ERR_remove_thread_state OPENSSL_MANGLER_ASM(ERR_remove_thread_state)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_set_error_data
#  define ERR_set_error_data OPENSSL_MANGLER(ERR_set_error_data)
# endif
#else
# ifndef _ERR_set_error_data
#  define _ERR_set_error_data OPENSSL_MANGLER_ASM(ERR_set_error_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_set_mark
#  define ERR_set_mark OPENSSL_MANGLER(ERR_set_mark)
# endif
#else
# ifndef _ERR_set_mark
#  define _ERR_set_mark OPENSSL_MANGLER_ASM(ERR_set_mark)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef err_shelve_state
#  define err_shelve_state OPENSSL_MANGLER(err_shelve_state)
# endif
#else
# ifndef _err_shelve_state
#  define _err_shelve_state OPENSSL_MANGLER_ASM(err_shelve_state)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ERR_unload_strings
#  define ERR_unload_strings OPENSSL_MANGLER(ERR_unload_strings)
# endif
#else
# ifndef _ERR_unload_strings
#  define _ERR_unload_strings OPENSSL_MANGLER_ASM(ERR_unload_strings)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef err_unshelve_state
#  define err_unshelve_state OPENSSL_MANGLER(err_unshelve_state)
# endif
#else
# ifndef _err_unshelve_state
#  define _err_unshelve_state OPENSSL_MANGLER_ASM(err_unshelve_state)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_CERT_ID_dup
#  define ESS_CERT_ID_dup OPENSSL_MANGLER(ESS_CERT_ID_dup)
# endif
#else
# ifndef _ESS_CERT_ID_dup
#  define _ESS_CERT_ID_dup OPENSSL_MANGLER_ASM(ESS_CERT_ID_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_CERT_ID_free
#  define ESS_CERT_ID_free OPENSSL_MANGLER(ESS_CERT_ID_free)
# endif
#else
# ifndef _ESS_CERT_ID_free
#  define _ESS_CERT_ID_free OPENSSL_MANGLER_ASM(ESS_CERT_ID_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_CERT_ID_new
#  define ESS_CERT_ID_new OPENSSL_MANGLER(ESS_CERT_ID_new)
# endif
#else
# ifndef _ESS_CERT_ID_new
#  define _ESS_CERT_ID_new OPENSSL_MANGLER_ASM(ESS_CERT_ID_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_CERT_ID_V2_dup
#  define ESS_CERT_ID_V2_dup OPENSSL_MANGLER(ESS_CERT_ID_V2_dup)
# endif
#else
# ifndef _ESS_CERT_ID_V2_dup
#  define _ESS_CERT_ID_V2_dup OPENSSL_MANGLER_ASM(ESS_CERT_ID_V2_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_CERT_ID_V2_free
#  define ESS_CERT_ID_V2_free OPENSSL_MANGLER(ESS_CERT_ID_V2_free)
# endif
#else
# ifndef _ESS_CERT_ID_V2_free
#  define _ESS_CERT_ID_V2_free OPENSSL_MANGLER_ASM(ESS_CERT_ID_V2_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_CERT_ID_V2_new
#  define ESS_CERT_ID_V2_new OPENSSL_MANGLER(ESS_CERT_ID_V2_new)
# endif
#else
# ifndef _ESS_CERT_ID_V2_new
#  define _ESS_CERT_ID_V2_new OPENSSL_MANGLER_ASM(ESS_CERT_ID_V2_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_ISSUER_SERIAL_dup
#  define ESS_ISSUER_SERIAL_dup OPENSSL_MANGLER(ESS_ISSUER_SERIAL_dup)
# endif
#else
# ifndef _ESS_ISSUER_SERIAL_dup
#  define _ESS_ISSUER_SERIAL_dup OPENSSL_MANGLER_ASM(ESS_ISSUER_SERIAL_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_ISSUER_SERIAL_free
#  define ESS_ISSUER_SERIAL_free OPENSSL_MANGLER(ESS_ISSUER_SERIAL_free)
# endif
#else
# ifndef _ESS_ISSUER_SERIAL_free
#  define _ESS_ISSUER_SERIAL_free OPENSSL_MANGLER_ASM(ESS_ISSUER_SERIAL_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_ISSUER_SERIAL_new
#  define ESS_ISSUER_SERIAL_new OPENSSL_MANGLER(ESS_ISSUER_SERIAL_new)
# endif
#else
# ifndef _ESS_ISSUER_SERIAL_new
#  define _ESS_ISSUER_SERIAL_new OPENSSL_MANGLER_ASM(ESS_ISSUER_SERIAL_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_SIGNING_CERT_dup
#  define ESS_SIGNING_CERT_dup OPENSSL_MANGLER(ESS_SIGNING_CERT_dup)
# endif
#else
# ifndef _ESS_SIGNING_CERT_dup
#  define _ESS_SIGNING_CERT_dup OPENSSL_MANGLER_ASM(ESS_SIGNING_CERT_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_SIGNING_CERT_free
#  define ESS_SIGNING_CERT_free OPENSSL_MANGLER(ESS_SIGNING_CERT_free)
# endif
#else
# ifndef _ESS_SIGNING_CERT_free
#  define _ESS_SIGNING_CERT_free OPENSSL_MANGLER_ASM(ESS_SIGNING_CERT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_SIGNING_CERT_new
#  define ESS_SIGNING_CERT_new OPENSSL_MANGLER(ESS_SIGNING_CERT_new)
# endif
#else
# ifndef _ESS_SIGNING_CERT_new
#  define _ESS_SIGNING_CERT_new OPENSSL_MANGLER_ASM(ESS_SIGNING_CERT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_SIGNING_CERT_V2_dup
#  define ESS_SIGNING_CERT_V2_dup OPENSSL_MANGLER(ESS_SIGNING_CERT_V2_dup)
# endif
#else
# ifndef _ESS_SIGNING_CERT_V2_dup
#  define _ESS_SIGNING_CERT_V2_dup OPENSSL_MANGLER_ASM(ESS_SIGNING_CERT_V2_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_SIGNING_CERT_V2_free
#  define ESS_SIGNING_CERT_V2_free OPENSSL_MANGLER(ESS_SIGNING_CERT_V2_free)
# endif
#else
# ifndef _ESS_SIGNING_CERT_V2_free
#  define _ESS_SIGNING_CERT_V2_free OPENSSL_MANGLER_ASM(ESS_SIGNING_CERT_V2_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ESS_SIGNING_CERT_V2_new
#  define ESS_SIGNING_CERT_V2_new OPENSSL_MANGLER(ESS_SIGNING_CERT_V2_new)
# endif
#else
# ifndef _ESS_SIGNING_CERT_V2_new
#  define _ESS_SIGNING_CERT_V2_new OPENSSL_MANGLER_ASM(ESS_SIGNING_CERT_V2_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_add_alg_module
#  define EVP_add_alg_module OPENSSL_MANGLER(EVP_add_alg_module)
# endif
#else
# ifndef _EVP_add_alg_module
#  define _EVP_add_alg_module OPENSSL_MANGLER_ASM(EVP_add_alg_module)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_add_cipher
#  define EVP_add_cipher OPENSSL_MANGLER(EVP_add_cipher)
# endif
#else
# ifndef _EVP_add_cipher
#  define _EVP_add_cipher OPENSSL_MANGLER_ASM(EVP_add_cipher)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_add_digest
#  define EVP_add_digest OPENSSL_MANGLER(EVP_add_digest)
# endif
#else
# ifndef _EVP_add_digest
#  define _EVP_add_digest OPENSSL_MANGLER_ASM(EVP_add_digest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_cbc
#  define EVP_aes_128_cbc OPENSSL_MANGLER(EVP_aes_128_cbc)
# endif
#else
# ifndef _EVP_aes_128_cbc
#  define _EVP_aes_128_cbc OPENSSL_MANGLER_ASM(EVP_aes_128_cbc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_cbc_hmac_sha1
#  define EVP_aes_128_cbc_hmac_sha1 OPENSSL_MANGLER(EVP_aes_128_cbc_hmac_sha1)
# endif
#else
# ifndef _EVP_aes_128_cbc_hmac_sha1
#  define _EVP_aes_128_cbc_hmac_sha1 OPENSSL_MANGLER_ASM(EVP_aes_128_cbc_hmac_sha1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_cbc_hmac_sha256
#  define EVP_aes_128_cbc_hmac_sha256 OPENSSL_MANGLER(EVP_aes_128_cbc_hmac_sha256)
# endif
#else
# ifndef _EVP_aes_128_cbc_hmac_sha256
#  define _EVP_aes_128_cbc_hmac_sha256 OPENSSL_MANGLER_ASM(EVP_aes_128_cbc_hmac_sha256)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_ccm
#  define EVP_aes_128_ccm OPENSSL_MANGLER(EVP_aes_128_ccm)
# endif
#else
# ifndef _EVP_aes_128_ccm
#  define _EVP_aes_128_ccm OPENSSL_MANGLER_ASM(EVP_aes_128_ccm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_cfb
#  define EVP_aes_128_cfb OPENSSL_MANGLER(EVP_aes_128_cfb)
# endif
#else
# ifndef _EVP_aes_128_cfb
#  define _EVP_aes_128_cfb OPENSSL_MANGLER_ASM(EVP_aes_128_cfb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_cfb1
#  define EVP_aes_128_cfb1 OPENSSL_MANGLER(EVP_aes_128_cfb1)
# endif
#else
# ifndef _EVP_aes_128_cfb1
#  define _EVP_aes_128_cfb1 OPENSSL_MANGLER_ASM(EVP_aes_128_cfb1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_cfb128
#  define EVP_aes_128_cfb128 OPENSSL_MANGLER(EVP_aes_128_cfb128)
# endif
#else
# ifndef _EVP_aes_128_cfb128
#  define _EVP_aes_128_cfb128 OPENSSL_MANGLER_ASM(EVP_aes_128_cfb128)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_cfb8
#  define EVP_aes_128_cfb8 OPENSSL_MANGLER(EVP_aes_128_cfb8)
# endif
#else
# ifndef _EVP_aes_128_cfb8
#  define _EVP_aes_128_cfb8 OPENSSL_MANGLER_ASM(EVP_aes_128_cfb8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_ctr
#  define EVP_aes_128_ctr OPENSSL_MANGLER(EVP_aes_128_ctr)
# endif
#else
# ifndef _EVP_aes_128_ctr
#  define _EVP_aes_128_ctr OPENSSL_MANGLER_ASM(EVP_aes_128_ctr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_ecb
#  define EVP_aes_128_ecb OPENSSL_MANGLER(EVP_aes_128_ecb)
# endif
#else
# ifndef _EVP_aes_128_ecb
#  define _EVP_aes_128_ecb OPENSSL_MANGLER_ASM(EVP_aes_128_ecb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_gcm
#  define EVP_aes_128_gcm OPENSSL_MANGLER(EVP_aes_128_gcm)
# endif
#else
# ifndef _EVP_aes_128_gcm
#  define _EVP_aes_128_gcm OPENSSL_MANGLER_ASM(EVP_aes_128_gcm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_ocb
#  define EVP_aes_128_ocb OPENSSL_MANGLER(EVP_aes_128_ocb)
# endif
#else
# ifndef _EVP_aes_128_ocb
#  define _EVP_aes_128_ocb OPENSSL_MANGLER_ASM(EVP_aes_128_ocb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_ofb
#  define EVP_aes_128_ofb OPENSSL_MANGLER(EVP_aes_128_ofb)
# endif
#else
# ifndef _EVP_aes_128_ofb
#  define _EVP_aes_128_ofb OPENSSL_MANGLER_ASM(EVP_aes_128_ofb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_wrap
#  define EVP_aes_128_wrap OPENSSL_MANGLER(EVP_aes_128_wrap)
# endif
#else
# ifndef _EVP_aes_128_wrap
#  define _EVP_aes_128_wrap OPENSSL_MANGLER_ASM(EVP_aes_128_wrap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_wrap_pad
#  define EVP_aes_128_wrap_pad OPENSSL_MANGLER(EVP_aes_128_wrap_pad)
# endif
#else
# ifndef _EVP_aes_128_wrap_pad
#  define _EVP_aes_128_wrap_pad OPENSSL_MANGLER_ASM(EVP_aes_128_wrap_pad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_128_xts
#  define EVP_aes_128_xts OPENSSL_MANGLER(EVP_aes_128_xts)
# endif
#else
# ifndef _EVP_aes_128_xts
#  define _EVP_aes_128_xts OPENSSL_MANGLER_ASM(EVP_aes_128_xts)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_cbc
#  define EVP_aes_192_cbc OPENSSL_MANGLER(EVP_aes_192_cbc)
# endif
#else
# ifndef _EVP_aes_192_cbc
#  define _EVP_aes_192_cbc OPENSSL_MANGLER_ASM(EVP_aes_192_cbc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_ccm
#  define EVP_aes_192_ccm OPENSSL_MANGLER(EVP_aes_192_ccm)
# endif
#else
# ifndef _EVP_aes_192_ccm
#  define _EVP_aes_192_ccm OPENSSL_MANGLER_ASM(EVP_aes_192_ccm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_cfb
#  define EVP_aes_192_cfb OPENSSL_MANGLER(EVP_aes_192_cfb)
# endif
#else
# ifndef _EVP_aes_192_cfb
#  define _EVP_aes_192_cfb OPENSSL_MANGLER_ASM(EVP_aes_192_cfb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_cfb1
#  define EVP_aes_192_cfb1 OPENSSL_MANGLER(EVP_aes_192_cfb1)
# endif
#else
# ifndef _EVP_aes_192_cfb1
#  define _EVP_aes_192_cfb1 OPENSSL_MANGLER_ASM(EVP_aes_192_cfb1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_cfb128
#  define EVP_aes_192_cfb128 OPENSSL_MANGLER(EVP_aes_192_cfb128)
# endif
#else
# ifndef _EVP_aes_192_cfb128
#  define _EVP_aes_192_cfb128 OPENSSL_MANGLER_ASM(EVP_aes_192_cfb128)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_cfb8
#  define EVP_aes_192_cfb8 OPENSSL_MANGLER(EVP_aes_192_cfb8)
# endif
#else
# ifndef _EVP_aes_192_cfb8
#  define _EVP_aes_192_cfb8 OPENSSL_MANGLER_ASM(EVP_aes_192_cfb8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_ctr
#  define EVP_aes_192_ctr OPENSSL_MANGLER(EVP_aes_192_ctr)
# endif
#else
# ifndef _EVP_aes_192_ctr
#  define _EVP_aes_192_ctr OPENSSL_MANGLER_ASM(EVP_aes_192_ctr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_ecb
#  define EVP_aes_192_ecb OPENSSL_MANGLER(EVP_aes_192_ecb)
# endif
#else
# ifndef _EVP_aes_192_ecb
#  define _EVP_aes_192_ecb OPENSSL_MANGLER_ASM(EVP_aes_192_ecb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_gcm
#  define EVP_aes_192_gcm OPENSSL_MANGLER(EVP_aes_192_gcm)
# endif
#else
# ifndef _EVP_aes_192_gcm
#  define _EVP_aes_192_gcm OPENSSL_MANGLER_ASM(EVP_aes_192_gcm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_ocb
#  define EVP_aes_192_ocb OPENSSL_MANGLER(EVP_aes_192_ocb)
# endif
#else
# ifndef _EVP_aes_192_ocb
#  define _EVP_aes_192_ocb OPENSSL_MANGLER_ASM(EVP_aes_192_ocb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_ofb
#  define EVP_aes_192_ofb OPENSSL_MANGLER(EVP_aes_192_ofb)
# endif
#else
# ifndef _EVP_aes_192_ofb
#  define _EVP_aes_192_ofb OPENSSL_MANGLER_ASM(EVP_aes_192_ofb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_wrap
#  define EVP_aes_192_wrap OPENSSL_MANGLER(EVP_aes_192_wrap)
# endif
#else
# ifndef _EVP_aes_192_wrap
#  define _EVP_aes_192_wrap OPENSSL_MANGLER_ASM(EVP_aes_192_wrap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_192_wrap_pad
#  define EVP_aes_192_wrap_pad OPENSSL_MANGLER(EVP_aes_192_wrap_pad)
# endif
#else
# ifndef _EVP_aes_192_wrap_pad
#  define _EVP_aes_192_wrap_pad OPENSSL_MANGLER_ASM(EVP_aes_192_wrap_pad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_cbc
#  define EVP_aes_256_cbc OPENSSL_MANGLER(EVP_aes_256_cbc)
# endif
#else
# ifndef _EVP_aes_256_cbc
#  define _EVP_aes_256_cbc OPENSSL_MANGLER_ASM(EVP_aes_256_cbc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_cbc_hmac_sha1
#  define EVP_aes_256_cbc_hmac_sha1 OPENSSL_MANGLER(EVP_aes_256_cbc_hmac_sha1)
# endif
#else
# ifndef _EVP_aes_256_cbc_hmac_sha1
#  define _EVP_aes_256_cbc_hmac_sha1 OPENSSL_MANGLER_ASM(EVP_aes_256_cbc_hmac_sha1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_cbc_hmac_sha256
#  define EVP_aes_256_cbc_hmac_sha256 OPENSSL_MANGLER(EVP_aes_256_cbc_hmac_sha256)
# endif
#else
# ifndef _EVP_aes_256_cbc_hmac_sha256
#  define _EVP_aes_256_cbc_hmac_sha256 OPENSSL_MANGLER_ASM(EVP_aes_256_cbc_hmac_sha256)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_ccm
#  define EVP_aes_256_ccm OPENSSL_MANGLER(EVP_aes_256_ccm)
# endif
#else
# ifndef _EVP_aes_256_ccm
#  define _EVP_aes_256_ccm OPENSSL_MANGLER_ASM(EVP_aes_256_ccm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_cfb
#  define EVP_aes_256_cfb OPENSSL_MANGLER(EVP_aes_256_cfb)
# endif
#else
# ifndef _EVP_aes_256_cfb
#  define _EVP_aes_256_cfb OPENSSL_MANGLER_ASM(EVP_aes_256_cfb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_cfb1
#  define EVP_aes_256_cfb1 OPENSSL_MANGLER(EVP_aes_256_cfb1)
# endif
#else
# ifndef _EVP_aes_256_cfb1
#  define _EVP_aes_256_cfb1 OPENSSL_MANGLER_ASM(EVP_aes_256_cfb1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_cfb128
#  define EVP_aes_256_cfb128 OPENSSL_MANGLER(EVP_aes_256_cfb128)
# endif
#else
# ifndef _EVP_aes_256_cfb128
#  define _EVP_aes_256_cfb128 OPENSSL_MANGLER_ASM(EVP_aes_256_cfb128)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_cfb8
#  define EVP_aes_256_cfb8 OPENSSL_MANGLER(EVP_aes_256_cfb8)
# endif
#else
# ifndef _EVP_aes_256_cfb8
#  define _EVP_aes_256_cfb8 OPENSSL_MANGLER_ASM(EVP_aes_256_cfb8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_ctr
#  define EVP_aes_256_ctr OPENSSL_MANGLER(EVP_aes_256_ctr)
# endif
#else
# ifndef _EVP_aes_256_ctr
#  define _EVP_aes_256_ctr OPENSSL_MANGLER_ASM(EVP_aes_256_ctr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_ecb
#  define EVP_aes_256_ecb OPENSSL_MANGLER(EVP_aes_256_ecb)
# endif
#else
# ifndef _EVP_aes_256_ecb
#  define _EVP_aes_256_ecb OPENSSL_MANGLER_ASM(EVP_aes_256_ecb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_gcm
#  define EVP_aes_256_gcm OPENSSL_MANGLER(EVP_aes_256_gcm)
# endif
#else
# ifndef _EVP_aes_256_gcm
#  define _EVP_aes_256_gcm OPENSSL_MANGLER_ASM(EVP_aes_256_gcm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_ocb
#  define EVP_aes_256_ocb OPENSSL_MANGLER(EVP_aes_256_ocb)
# endif
#else
# ifndef _EVP_aes_256_ocb
#  define _EVP_aes_256_ocb OPENSSL_MANGLER_ASM(EVP_aes_256_ocb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_ofb
#  define EVP_aes_256_ofb OPENSSL_MANGLER(EVP_aes_256_ofb)
# endif
#else
# ifndef _EVP_aes_256_ofb
#  define _EVP_aes_256_ofb OPENSSL_MANGLER_ASM(EVP_aes_256_ofb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_wrap
#  define EVP_aes_256_wrap OPENSSL_MANGLER(EVP_aes_256_wrap)
# endif
#else
# ifndef _EVP_aes_256_wrap
#  define _EVP_aes_256_wrap OPENSSL_MANGLER_ASM(EVP_aes_256_wrap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_wrap_pad
#  define EVP_aes_256_wrap_pad OPENSSL_MANGLER(EVP_aes_256_wrap_pad)
# endif
#else
# ifndef _EVP_aes_256_wrap_pad
#  define _EVP_aes_256_wrap_pad OPENSSL_MANGLER_ASM(EVP_aes_256_wrap_pad)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aes_256_xts
#  define EVP_aes_256_xts OPENSSL_MANGLER(EVP_aes_256_xts)
# endif
#else
# ifndef _EVP_aes_256_xts
#  define _EVP_aes_256_xts OPENSSL_MANGLER_ASM(EVP_aes_256_xts)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef evp_app_cleanup_int
#  define evp_app_cleanup_int OPENSSL_MANGLER(evp_app_cleanup_int)
# endif
#else
# ifndef _evp_app_cleanup_int
#  define _evp_app_cleanup_int OPENSSL_MANGLER_ASM(evp_app_cleanup_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_128_cbc
#  define EVP_aria_128_cbc OPENSSL_MANGLER(EVP_aria_128_cbc)
# endif
#else
# ifndef _EVP_aria_128_cbc
#  define _EVP_aria_128_cbc OPENSSL_MANGLER_ASM(EVP_aria_128_cbc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_128_ccm
#  define EVP_aria_128_ccm OPENSSL_MANGLER(EVP_aria_128_ccm)
# endif
#else
# ifndef _EVP_aria_128_ccm
#  define _EVP_aria_128_ccm OPENSSL_MANGLER_ASM(EVP_aria_128_ccm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_128_cfb1
#  define EVP_aria_128_cfb1 OPENSSL_MANGLER(EVP_aria_128_cfb1)
# endif
#else
# ifndef _EVP_aria_128_cfb1
#  define _EVP_aria_128_cfb1 OPENSSL_MANGLER_ASM(EVP_aria_128_cfb1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_128_cfb128
#  define EVP_aria_128_cfb128 OPENSSL_MANGLER(EVP_aria_128_cfb128)
# endif
#else
# ifndef _EVP_aria_128_cfb128
#  define _EVP_aria_128_cfb128 OPENSSL_MANGLER_ASM(EVP_aria_128_cfb128)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_128_cfb8
#  define EVP_aria_128_cfb8 OPENSSL_MANGLER(EVP_aria_128_cfb8)
# endif
#else
# ifndef _EVP_aria_128_cfb8
#  define _EVP_aria_128_cfb8 OPENSSL_MANGLER_ASM(EVP_aria_128_cfb8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_128_ctr
#  define EVP_aria_128_ctr OPENSSL_MANGLER(EVP_aria_128_ctr)
# endif
#else
# ifndef _EVP_aria_128_ctr
#  define _EVP_aria_128_ctr OPENSSL_MANGLER_ASM(EVP_aria_128_ctr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_128_ecb
#  define EVP_aria_128_ecb OPENSSL_MANGLER(EVP_aria_128_ecb)
# endif
#else
# ifndef _EVP_aria_128_ecb
#  define _EVP_aria_128_ecb OPENSSL_MANGLER_ASM(EVP_aria_128_ecb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_128_gcm
#  define EVP_aria_128_gcm OPENSSL_MANGLER(EVP_aria_128_gcm)
# endif
#else
# ifndef _EVP_aria_128_gcm
#  define _EVP_aria_128_gcm OPENSSL_MANGLER_ASM(EVP_aria_128_gcm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_128_ofb
#  define EVP_aria_128_ofb OPENSSL_MANGLER(EVP_aria_128_ofb)
# endif
#else
# ifndef _EVP_aria_128_ofb
#  define _EVP_aria_128_ofb OPENSSL_MANGLER_ASM(EVP_aria_128_ofb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_192_cbc
#  define EVP_aria_192_cbc OPENSSL_MANGLER(EVP_aria_192_cbc)
# endif
#else
# ifndef _EVP_aria_192_cbc
#  define _EVP_aria_192_cbc OPENSSL_MANGLER_ASM(EVP_aria_192_cbc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_192_ccm
#  define EVP_aria_192_ccm OPENSSL_MANGLER(EVP_aria_192_ccm)
# endif
#else
# ifndef _EVP_aria_192_ccm
#  define _EVP_aria_192_ccm OPENSSL_MANGLER_ASM(EVP_aria_192_ccm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_192_cfb1
#  define EVP_aria_192_cfb1 OPENSSL_MANGLER(EVP_aria_192_cfb1)
# endif
#else
# ifndef _EVP_aria_192_cfb1
#  define _EVP_aria_192_cfb1 OPENSSL_MANGLER_ASM(EVP_aria_192_cfb1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_192_cfb128
#  define EVP_aria_192_cfb128 OPENSSL_MANGLER(EVP_aria_192_cfb128)
# endif
#else
# ifndef _EVP_aria_192_cfb128
#  define _EVP_aria_192_cfb128 OPENSSL_MANGLER_ASM(EVP_aria_192_cfb128)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_192_cfb8
#  define EVP_aria_192_cfb8 OPENSSL_MANGLER(EVP_aria_192_cfb8)
# endif
#else
# ifndef _EVP_aria_192_cfb8
#  define _EVP_aria_192_cfb8 OPENSSL_MANGLER_ASM(EVP_aria_192_cfb8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_192_ctr
#  define EVP_aria_192_ctr OPENSSL_MANGLER(EVP_aria_192_ctr)
# endif
#else
# ifndef _EVP_aria_192_ctr
#  define _EVP_aria_192_ctr OPENSSL_MANGLER_ASM(EVP_aria_192_ctr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_192_ecb
#  define EVP_aria_192_ecb OPENSSL_MANGLER(EVP_aria_192_ecb)
# endif
#else
# ifndef _EVP_aria_192_ecb
#  define _EVP_aria_192_ecb OPENSSL_MANGLER_ASM(EVP_aria_192_ecb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_192_gcm
#  define EVP_aria_192_gcm OPENSSL_MANGLER(EVP_aria_192_gcm)
# endif
#else
# ifndef _EVP_aria_192_gcm
#  define _EVP_aria_192_gcm OPENSSL_MANGLER_ASM(EVP_aria_192_gcm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_192_ofb
#  define EVP_aria_192_ofb OPENSSL_MANGLER(EVP_aria_192_ofb)
# endif
#else
# ifndef _EVP_aria_192_ofb
#  define _EVP_aria_192_ofb OPENSSL_MANGLER_ASM(EVP_aria_192_ofb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_256_cbc
#  define EVP_aria_256_cbc OPENSSL_MANGLER(EVP_aria_256_cbc)
# endif
#else
# ifndef _EVP_aria_256_cbc
#  define _EVP_aria_256_cbc OPENSSL_MANGLER_ASM(EVP_aria_256_cbc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_256_ccm
#  define EVP_aria_256_ccm OPENSSL_MANGLER(EVP_aria_256_ccm)
# endif
#else
# ifndef _EVP_aria_256_ccm
#  define _EVP_aria_256_ccm OPENSSL_MANGLER_ASM(EVP_aria_256_ccm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_256_cfb1
#  define EVP_aria_256_cfb1 OPENSSL_MANGLER(EVP_aria_256_cfb1)
# endif
#else
# ifndef _EVP_aria_256_cfb1
#  define _EVP_aria_256_cfb1 OPENSSL_MANGLER_ASM(EVP_aria_256_cfb1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_256_cfb128
#  define EVP_aria_256_cfb128 OPENSSL_MANGLER(EVP_aria_256_cfb128)
# endif
#else
# ifndef _EVP_aria_256_cfb128
#  define _EVP_aria_256_cfb128 OPENSSL_MANGLER_ASM(EVP_aria_256_cfb128)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_256_cfb8
#  define EVP_aria_256_cfb8 OPENSSL_MANGLER(EVP_aria_256_cfb8)
# endif
#else
# ifndef _EVP_aria_256_cfb8
#  define _EVP_aria_256_cfb8 OPENSSL_MANGLER_ASM(EVP_aria_256_cfb8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_256_ctr
#  define EVP_aria_256_ctr OPENSSL_MANGLER(EVP_aria_256_ctr)
# endif
#else
# ifndef _EVP_aria_256_ctr
#  define _EVP_aria_256_ctr OPENSSL_MANGLER_ASM(EVP_aria_256_ctr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_256_ecb
#  define EVP_aria_256_ecb OPENSSL_MANGLER(EVP_aria_256_ecb)
# endif
#else
# ifndef _EVP_aria_256_ecb
#  define _EVP_aria_256_ecb OPENSSL_MANGLER_ASM(EVP_aria_256_ecb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_256_gcm
#  define EVP_aria_256_gcm OPENSSL_MANGLER(EVP_aria_256_gcm)
# endif
#else
# ifndef _EVP_aria_256_gcm
#  define _EVP_aria_256_gcm OPENSSL_MANGLER_ASM(EVP_aria_256_gcm)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_aria_256_ofb
#  define EVP_aria_256_ofb OPENSSL_MANGLER(EVP_aria_256_ofb)
# endif
#else
# ifndef _EVP_aria_256_ofb
#  define _EVP_aria_256_ofb OPENSSL_MANGLER_ASM(EVP_aria_256_ofb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_bf_cbc
#  define EVP_bf_cbc OPENSSL_MANGLER(EVP_bf_cbc)
# endif
#else
# ifndef _EVP_bf_cbc
#  define _EVP_bf_cbc OPENSSL_MANGLER_ASM(EVP_bf_cbc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_bf_cfb
#  define EVP_bf_cfb OPENSSL_MANGLER(EVP_bf_cfb)
# endif
#else
# ifndef _EVP_bf_cfb
#  define _EVP_bf_cfb OPENSSL_MANGLER_ASM(EVP_bf_cfb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_bf_cfb64
#  define EVP_bf_cfb64 OPENSSL_MANGLER(EVP_bf_cfb64)
# endif
#else
# ifndef _EVP_bf_cfb64
#  define _EVP_bf_cfb64 OPENSSL_MANGLER_ASM(EVP_bf_cfb64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_bf_ecb
#  define EVP_bf_ecb OPENSSL_MANGLER(EVP_bf_ecb)
# endif
#else
# ifndef _EVP_bf_ecb
#  define _EVP_bf_ecb OPENSSL_MANGLER_ASM(EVP_bf_ecb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_bf_ofb
#  define EVP_bf_ofb OPENSSL_MANGLER(EVP_bf_ofb)
# endif
#else
# ifndef _EVP_bf_ofb
#  define _EVP_bf_ofb OPENSSL_MANGLER_ASM(EVP_bf_ofb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_blake2b512
#  define EVP_blake2b512 OPENSSL_MANGLER(EVP_blake2b512)
# endif
#else
# ifndef _EVP_blake2b512
#  define _EVP_blake2b512 OPENSSL_MANGLER_ASM(EVP_blake2b512)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_blake2s256
#  define EVP_blake2s256 OPENSSL_MANGLER(EVP_blake2s256)
# endif
#else
# ifndef _EVP_blake2s256
#  define _EVP_blake2s256 OPENSSL_MANGLER_ASM(EVP_blake2s256)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_BytesToKey
#  define EVP_BytesToKey OPENSSL_MANGLER(EVP_BytesToKey)
# endif
#else
# ifndef _EVP_BytesToKey
#  define _EVP_BytesToKey OPENSSL_MANGLER_ASM(EVP_BytesToKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_chacha20
#  define EVP_chacha20 OPENSSL_MANGLER(EVP_chacha20)
# endif
#else
# ifndef _EVP_chacha20
#  define _EVP_chacha20 OPENSSL_MANGLER_ASM(EVP_chacha20)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_Cipher
#  define EVP_Cipher OPENSSL_MANGLER(EVP_Cipher)
# endif
#else
# ifndef _EVP_Cipher
#  define _EVP_Cipher OPENSSL_MANGLER_ASM(EVP_Cipher)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_asn1_to_param
#  define EVP_CIPHER_asn1_to_param OPENSSL_MANGLER(EVP_CIPHER_asn1_to_param)
# endif
#else
# ifndef _EVP_CIPHER_asn1_to_param
#  define _EVP_CIPHER_asn1_to_param OPENSSL_MANGLER_ASM(EVP_CIPHER_asn1_to_param)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_block_size
#  define EVP_CIPHER_block_size OPENSSL_MANGLER(EVP_CIPHER_block_size)
# endif
#else
# ifndef _EVP_CIPHER_block_size
#  define _EVP_CIPHER_block_size OPENSSL_MANGLER_ASM(EVP_CIPHER_block_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_block_size
#  define EVP_CIPHER_CTX_block_size OPENSSL_MANGLER(EVP_CIPHER_CTX_block_size)
# endif
#else
# ifndef _EVP_CIPHER_CTX_block_size
#  define _EVP_CIPHER_CTX_block_size OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_block_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_buf_noconst
#  define EVP_CIPHER_CTX_buf_noconst OPENSSL_MANGLER(EVP_CIPHER_CTX_buf_noconst)
# endif
#else
# ifndef _EVP_CIPHER_CTX_buf_noconst
#  define _EVP_CIPHER_CTX_buf_noconst OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_buf_noconst)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_cipher
#  define EVP_CIPHER_CTX_cipher OPENSSL_MANGLER(EVP_CIPHER_CTX_cipher)
# endif
#else
# ifndef _EVP_CIPHER_CTX_cipher
#  define _EVP_CIPHER_CTX_cipher OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_cipher)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_clear_flags
#  define EVP_CIPHER_CTX_clear_flags OPENSSL_MANGLER(EVP_CIPHER_CTX_clear_flags)
# endif
#else
# ifndef _EVP_CIPHER_CTX_clear_flags
#  define _EVP_CIPHER_CTX_clear_flags OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_clear_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_copy
#  define EVP_CIPHER_CTX_copy OPENSSL_MANGLER(EVP_CIPHER_CTX_copy)
# endif
#else
# ifndef _EVP_CIPHER_CTX_copy
#  define _EVP_CIPHER_CTX_copy OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_ctrl
#  define EVP_CIPHER_CTX_ctrl OPENSSL_MANGLER(EVP_CIPHER_CTX_ctrl)
# endif
#else
# ifndef _EVP_CIPHER_CTX_ctrl
#  define _EVP_CIPHER_CTX_ctrl OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_encrypting
#  define EVP_CIPHER_CTX_encrypting OPENSSL_MANGLER(EVP_CIPHER_CTX_encrypting)
# endif
#else
# ifndef _EVP_CIPHER_CTX_encrypting
#  define _EVP_CIPHER_CTX_encrypting OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_encrypting)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_free
#  define EVP_CIPHER_CTX_free OPENSSL_MANGLER(EVP_CIPHER_CTX_free)
# endif
#else
# ifndef _EVP_CIPHER_CTX_free
#  define _EVP_CIPHER_CTX_free OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_get_app_data
#  define EVP_CIPHER_CTX_get_app_data OPENSSL_MANGLER(EVP_CIPHER_CTX_get_app_data)
# endif
#else
# ifndef _EVP_CIPHER_CTX_get_app_data
#  define _EVP_CIPHER_CTX_get_app_data OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_get_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_get_cipher_data
#  define EVP_CIPHER_CTX_get_cipher_data OPENSSL_MANGLER(EVP_CIPHER_CTX_get_cipher_data)
# endif
#else
# ifndef _EVP_CIPHER_CTX_get_cipher_data
#  define _EVP_CIPHER_CTX_get_cipher_data OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_get_cipher_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_iv
#  define EVP_CIPHER_CTX_iv OPENSSL_MANGLER(EVP_CIPHER_CTX_iv)
# endif
#else
# ifndef _EVP_CIPHER_CTX_iv
#  define _EVP_CIPHER_CTX_iv OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_iv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_iv_length
#  define EVP_CIPHER_CTX_iv_length OPENSSL_MANGLER(EVP_CIPHER_CTX_iv_length)
# endif
#else
# ifndef _EVP_CIPHER_CTX_iv_length
#  define _EVP_CIPHER_CTX_iv_length OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_iv_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_iv_noconst
#  define EVP_CIPHER_CTX_iv_noconst OPENSSL_MANGLER(EVP_CIPHER_CTX_iv_noconst)
# endif
#else
# ifndef _EVP_CIPHER_CTX_iv_noconst
#  define _EVP_CIPHER_CTX_iv_noconst OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_iv_noconst)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_key_length
#  define EVP_CIPHER_CTX_key_length OPENSSL_MANGLER(EVP_CIPHER_CTX_key_length)
# endif
#else
# ifndef _EVP_CIPHER_CTX_key_length
#  define _EVP_CIPHER_CTX_key_length OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_key_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_new
#  define EVP_CIPHER_CTX_new OPENSSL_MANGLER(EVP_CIPHER_CTX_new)
# endif
#else
# ifndef _EVP_CIPHER_CTX_new
#  define _EVP_CIPHER_CTX_new OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_nid
#  define EVP_CIPHER_CTX_nid OPENSSL_MANGLER(EVP_CIPHER_CTX_nid)
# endif
#else
# ifndef _EVP_CIPHER_CTX_nid
#  define _EVP_CIPHER_CTX_nid OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_num
#  define EVP_CIPHER_CTX_num OPENSSL_MANGLER(EVP_CIPHER_CTX_num)
# endif
#else
# ifndef _EVP_CIPHER_CTX_num
#  define _EVP_CIPHER_CTX_num OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_num)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_original_iv
#  define EVP_CIPHER_CTX_original_iv OPENSSL_MANGLER(EVP_CIPHER_CTX_original_iv)
# endif
#else
# ifndef _EVP_CIPHER_CTX_original_iv
#  define _EVP_CIPHER_CTX_original_iv OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_original_iv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_rand_key
#  define EVP_CIPHER_CTX_rand_key OPENSSL_MANGLER(EVP_CIPHER_CTX_rand_key)
# endif
#else
# ifndef _EVP_CIPHER_CTX_rand_key
#  define _EVP_CIPHER_CTX_rand_key OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_rand_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_reset
#  define EVP_CIPHER_CTX_reset OPENSSL_MANGLER(EVP_CIPHER_CTX_reset)
# endif
#else
# ifndef _EVP_CIPHER_CTX_reset
#  define _EVP_CIPHER_CTX_reset OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_reset)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_set_app_data
#  define EVP_CIPHER_CTX_set_app_data OPENSSL_MANGLER(EVP_CIPHER_CTX_set_app_data)
# endif
#else
# ifndef _EVP_CIPHER_CTX_set_app_data
#  define _EVP_CIPHER_CTX_set_app_data OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_set_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_set_cipher_data
#  define EVP_CIPHER_CTX_set_cipher_data OPENSSL_MANGLER(EVP_CIPHER_CTX_set_cipher_data)
# endif
#else
# ifndef _EVP_CIPHER_CTX_set_cipher_data
#  define _EVP_CIPHER_CTX_set_cipher_data OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_set_cipher_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_set_flags
#  define EVP_CIPHER_CTX_set_flags OPENSSL_MANGLER(EVP_CIPHER_CTX_set_flags)
# endif
#else
# ifndef _EVP_CIPHER_CTX_set_flags
#  define _EVP_CIPHER_CTX_set_flags OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_set_key_length
#  define EVP_CIPHER_CTX_set_key_length OPENSSL_MANGLER(EVP_CIPHER_CTX_set_key_length)
# endif
#else
# ifndef _EVP_CIPHER_CTX_set_key_length
#  define _EVP_CIPHER_CTX_set_key_length OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_set_key_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_set_num
#  define EVP_CIPHER_CTX_set_num OPENSSL_MANGLER(EVP_CIPHER_CTX_set_num)
# endif
#else
# ifndef _EVP_CIPHER_CTX_set_num
#  define _EVP_CIPHER_CTX_set_num OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_set_num)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_set_padding
#  define EVP_CIPHER_CTX_set_padding OPENSSL_MANGLER(EVP_CIPHER_CTX_set_padding)
# endif
#else
# ifndef _EVP_CIPHER_CTX_set_padding
#  define _EVP_CIPHER_CTX_set_padding OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_set_padding)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_CTX_test_flags
#  define EVP_CIPHER_CTX_test_flags OPENSSL_MANGLER(EVP_CIPHER_CTX_test_flags)
# endif
#else
# ifndef _EVP_CIPHER_CTX_test_flags
#  define _EVP_CIPHER_CTX_test_flags OPENSSL_MANGLER_ASM(EVP_CIPHER_CTX_test_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_do_all
#  define EVP_CIPHER_do_all OPENSSL_MANGLER(EVP_CIPHER_do_all)
# endif
#else
# ifndef _EVP_CIPHER_do_all
#  define _EVP_CIPHER_do_all OPENSSL_MANGLER_ASM(EVP_CIPHER_do_all)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_do_all_sorted
#  define EVP_CIPHER_do_all_sorted OPENSSL_MANGLER(EVP_CIPHER_do_all_sorted)
# endif
#else
# ifndef _EVP_CIPHER_do_all_sorted
#  define _EVP_CIPHER_do_all_sorted OPENSSL_MANGLER_ASM(EVP_CIPHER_do_all_sorted)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CipherFinal
#  define EVP_CipherFinal OPENSSL_MANGLER(EVP_CipherFinal)
# endif
#else
# ifndef _EVP_CipherFinal
#  define _EVP_CipherFinal OPENSSL_MANGLER_ASM(EVP_CipherFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CipherFinal_ex
#  define EVP_CipherFinal_ex OPENSSL_MANGLER(EVP_CipherFinal_ex)
# endif
#else
# ifndef _EVP_CipherFinal_ex
#  define _EVP_CipherFinal_ex OPENSSL_MANGLER_ASM(EVP_CipherFinal_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_flags
#  define EVP_CIPHER_flags OPENSSL_MANGLER(EVP_CIPHER_flags)
# endif
#else
# ifndef _EVP_CIPHER_flags
#  define _EVP_CIPHER_flags OPENSSL_MANGLER_ASM(EVP_CIPHER_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_get_asn1_iv
#  define EVP_CIPHER_get_asn1_iv OPENSSL_MANGLER(EVP_CIPHER_get_asn1_iv)
# endif
#else
# ifndef _EVP_CIPHER_get_asn1_iv
#  define _EVP_CIPHER_get_asn1_iv OPENSSL_MANGLER_ASM(EVP_CIPHER_get_asn1_iv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_impl_ctx_size
#  define EVP_CIPHER_impl_ctx_size OPENSSL_MANGLER(EVP_CIPHER_impl_ctx_size)
# endif
#else
# ifndef _EVP_CIPHER_impl_ctx_size
#  define _EVP_CIPHER_impl_ctx_size OPENSSL_MANGLER_ASM(EVP_CIPHER_impl_ctx_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CipherInit
#  define EVP_CipherInit OPENSSL_MANGLER(EVP_CipherInit)
# endif
#else
# ifndef _EVP_CipherInit
#  define _EVP_CipherInit OPENSSL_MANGLER_ASM(EVP_CipherInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CipherInit_ex
#  define EVP_CipherInit_ex OPENSSL_MANGLER(EVP_CipherInit_ex)
# endif
#else
# ifndef _EVP_CipherInit_ex
#  define _EVP_CipherInit_ex OPENSSL_MANGLER_ASM(EVP_CipherInit_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_iv_length
#  define EVP_CIPHER_iv_length OPENSSL_MANGLER(EVP_CIPHER_iv_length)
# endif
#else
# ifndef _EVP_CIPHER_iv_length
#  define _EVP_CIPHER_iv_length OPENSSL_MANGLER_ASM(EVP_CIPHER_iv_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_key_length
#  define EVP_CIPHER_key_length OPENSSL_MANGLER(EVP_CIPHER_key_length)
# endif
#else
# ifndef _EVP_CIPHER_key_length
#  define _EVP_CIPHER_key_length OPENSSL_MANGLER_ASM(EVP_CIPHER_key_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_dup
#  define EVP_CIPHER_meth_dup OPENSSL_MANGLER(EVP_CIPHER_meth_dup)
# endif
#else
# ifndef _EVP_CIPHER_meth_dup
#  define _EVP_CIPHER_meth_dup OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_free
#  define EVP_CIPHER_meth_free OPENSSL_MANGLER(EVP_CIPHER_meth_free)
# endif
#else
# ifndef _EVP_CIPHER_meth_free
#  define _EVP_CIPHER_meth_free OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_get_cleanup
#  define EVP_CIPHER_meth_get_cleanup OPENSSL_MANGLER(EVP_CIPHER_meth_get_cleanup)
# endif
#else
# ifndef _EVP_CIPHER_meth_get_cleanup
#  define _EVP_CIPHER_meth_get_cleanup OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_get_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_get_ctrl
#  define EVP_CIPHER_meth_get_ctrl OPENSSL_MANGLER(EVP_CIPHER_meth_get_ctrl)
# endif
#else
# ifndef _EVP_CIPHER_meth_get_ctrl
#  define _EVP_CIPHER_meth_get_ctrl OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_get_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_get_do_cipher
#  define EVP_CIPHER_meth_get_do_cipher OPENSSL_MANGLER(EVP_CIPHER_meth_get_do_cipher)
# endif
#else
# ifndef _EVP_CIPHER_meth_get_do_cipher
#  define _EVP_CIPHER_meth_get_do_cipher OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_get_do_cipher)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_get_get_asn1_params
#  define EVP_CIPHER_meth_get_get_asn1_params OPENSSL_MANGLER(EVP_CIPHER_meth_get_get_asn1_params)
# endif
#else
# ifndef _EVP_CIPHER_meth_get_get_asn1_params
#  define _EVP_CIPHER_meth_get_get_asn1_params OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_get_get_asn1_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_get_init
#  define EVP_CIPHER_meth_get_init OPENSSL_MANGLER(EVP_CIPHER_meth_get_init)
# endif
#else
# ifndef _EVP_CIPHER_meth_get_init
#  define _EVP_CIPHER_meth_get_init OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_get_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_get_set_asn1_params
#  define EVP_CIPHER_meth_get_set_asn1_params OPENSSL_MANGLER(EVP_CIPHER_meth_get_set_asn1_params)
# endif
#else
# ifndef _EVP_CIPHER_meth_get_set_asn1_params
#  define _EVP_CIPHER_meth_get_set_asn1_params OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_get_set_asn1_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_new
#  define EVP_CIPHER_meth_new OPENSSL_MANGLER(EVP_CIPHER_meth_new)
# endif
#else
# ifndef _EVP_CIPHER_meth_new
#  define _EVP_CIPHER_meth_new OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_set_cleanup
#  define EVP_CIPHER_meth_set_cleanup OPENSSL_MANGLER(EVP_CIPHER_meth_set_cleanup)
# endif
#else
# ifndef _EVP_CIPHER_meth_set_cleanup
#  define _EVP_CIPHER_meth_set_cleanup OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_set_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_set_ctrl
#  define EVP_CIPHER_meth_set_ctrl OPENSSL_MANGLER(EVP_CIPHER_meth_set_ctrl)
# endif
#else
# ifndef _EVP_CIPHER_meth_set_ctrl
#  define _EVP_CIPHER_meth_set_ctrl OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_set_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_set_do_cipher
#  define EVP_CIPHER_meth_set_do_cipher OPENSSL_MANGLER(EVP_CIPHER_meth_set_do_cipher)
# endif
#else
# ifndef _EVP_CIPHER_meth_set_do_cipher
#  define _EVP_CIPHER_meth_set_do_cipher OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_set_do_cipher)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_set_flags
#  define EVP_CIPHER_meth_set_flags OPENSSL_MANGLER(EVP_CIPHER_meth_set_flags)
# endif
#else
# ifndef _EVP_CIPHER_meth_set_flags
#  define _EVP_CIPHER_meth_set_flags OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_set_get_asn1_params
#  define EVP_CIPHER_meth_set_get_asn1_params OPENSSL_MANGLER(EVP_CIPHER_meth_set_get_asn1_params)
# endif
#else
# ifndef _EVP_CIPHER_meth_set_get_asn1_params
#  define _EVP_CIPHER_meth_set_get_asn1_params OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_set_get_asn1_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_set_impl_ctx_size
#  define EVP_CIPHER_meth_set_impl_ctx_size OPENSSL_MANGLER(EVP_CIPHER_meth_set_impl_ctx_size)
# endif
#else
# ifndef _EVP_CIPHER_meth_set_impl_ctx_size
#  define _EVP_CIPHER_meth_set_impl_ctx_size OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_set_impl_ctx_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_set_init
#  define EVP_CIPHER_meth_set_init OPENSSL_MANGLER(EVP_CIPHER_meth_set_init)
# endif
#else
# ifndef _EVP_CIPHER_meth_set_init
#  define _EVP_CIPHER_meth_set_init OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_set_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_set_iv_length
#  define EVP_CIPHER_meth_set_iv_length OPENSSL_MANGLER(EVP_CIPHER_meth_set_iv_length)
# endif
#else
# ifndef _EVP_CIPHER_meth_set_iv_length
#  define _EVP_CIPHER_meth_set_iv_length OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_set_iv_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_meth_set_set_asn1_params
#  define EVP_CIPHER_meth_set_set_asn1_params OPENSSL_MANGLER(EVP_CIPHER_meth_set_set_asn1_params)
# endif
#else
# ifndef _EVP_CIPHER_meth_set_set_asn1_params
#  define _EVP_CIPHER_meth_set_set_asn1_params OPENSSL_MANGLER_ASM(EVP_CIPHER_meth_set_set_asn1_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_nid
#  define EVP_CIPHER_nid OPENSSL_MANGLER(EVP_CIPHER_nid)
# endif
#else
# ifndef _EVP_CIPHER_nid
#  define _EVP_CIPHER_nid OPENSSL_MANGLER_ASM(EVP_CIPHER_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_param_to_asn1
#  define EVP_CIPHER_param_to_asn1 OPENSSL_MANGLER(EVP_CIPHER_param_to_asn1)
# endif
#else
# ifndef _EVP_CIPHER_param_to_asn1
#  define _EVP_CIPHER_param_to_asn1 OPENSSL_MANGLER_ASM(EVP_CIPHER_param_to_asn1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_set_asn1_iv
#  define EVP_CIPHER_set_asn1_iv OPENSSL_MANGLER(EVP_CIPHER_set_asn1_iv)
# endif
#else
# ifndef _EVP_CIPHER_set_asn1_iv
#  define _EVP_CIPHER_set_asn1_iv OPENSSL_MANGLER_ASM(EVP_CIPHER_set_asn1_iv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CIPHER_type
#  define EVP_CIPHER_type OPENSSL_MANGLER(EVP_CIPHER_type)
# endif
#else
# ifndef _EVP_CIPHER_type
#  define _EVP_CIPHER_type OPENSSL_MANGLER_ASM(EVP_CIPHER_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_CipherUpdate
#  define EVP_CipherUpdate OPENSSL_MANGLER(EVP_CipherUpdate)
# endif
#else
# ifndef _EVP_CipherUpdate
#  define _EVP_CipherUpdate OPENSSL_MANGLER_ASM(EVP_CipherUpdate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef evp_cleanup_int
#  define evp_cleanup_int OPENSSL_MANGLER(evp_cleanup_int)
# endif
#else
# ifndef _evp_cleanup_int
#  define _evp_cleanup_int OPENSSL_MANGLER_ASM(evp_cleanup_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DecodeBlock
#  define EVP_DecodeBlock OPENSSL_MANGLER(EVP_DecodeBlock)
# endif
#else
# ifndef _EVP_DecodeBlock
#  define _EVP_DecodeBlock OPENSSL_MANGLER_ASM(EVP_DecodeBlock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DecodeFinal
#  define EVP_DecodeFinal OPENSSL_MANGLER(EVP_DecodeFinal)
# endif
#else
# ifndef _EVP_DecodeFinal
#  define _EVP_DecodeFinal OPENSSL_MANGLER_ASM(EVP_DecodeFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DecodeInit
#  define EVP_DecodeInit OPENSSL_MANGLER(EVP_DecodeInit)
# endif
#else
# ifndef _EVP_DecodeInit
#  define _EVP_DecodeInit OPENSSL_MANGLER_ASM(EVP_DecodeInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DecodeUpdate
#  define EVP_DecodeUpdate OPENSSL_MANGLER(EVP_DecodeUpdate)
# endif
#else
# ifndef _EVP_DecodeUpdate
#  define _EVP_DecodeUpdate OPENSSL_MANGLER_ASM(EVP_DecodeUpdate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DecryptFinal
#  define EVP_DecryptFinal OPENSSL_MANGLER(EVP_DecryptFinal)
# endif
#else
# ifndef _EVP_DecryptFinal
#  define _EVP_DecryptFinal OPENSSL_MANGLER_ASM(EVP_DecryptFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DecryptFinal_ex
#  define EVP_DecryptFinal_ex OPENSSL_MANGLER(EVP_DecryptFinal_ex)
# endif
#else
# ifndef _EVP_DecryptFinal_ex
#  define _EVP_DecryptFinal_ex OPENSSL_MANGLER_ASM(EVP_DecryptFinal_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DecryptInit
#  define EVP_DecryptInit OPENSSL_MANGLER(EVP_DecryptInit)
# endif
#else
# ifndef _EVP_DecryptInit
#  define _EVP_DecryptInit OPENSSL_MANGLER_ASM(EVP_DecryptInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DecryptInit_ex
#  define EVP_DecryptInit_ex OPENSSL_MANGLER(EVP_DecryptInit_ex)
# endif
#else
# ifndef _EVP_DecryptInit_ex
#  define _EVP_DecryptInit_ex OPENSSL_MANGLER_ASM(EVP_DecryptInit_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DecryptUpdate
#  define EVP_DecryptUpdate OPENSSL_MANGLER(EVP_DecryptUpdate)
# endif
#else
# ifndef _EVP_DecryptUpdate
#  define _EVP_DecryptUpdate OPENSSL_MANGLER_ASM(EVP_DecryptUpdate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_Digest
#  define EVP_Digest OPENSSL_MANGLER(EVP_Digest)
# endif
#else
# ifndef _EVP_Digest
#  define _EVP_Digest OPENSSL_MANGLER_ASM(EVP_Digest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestFinal
#  define EVP_DigestFinal OPENSSL_MANGLER(EVP_DigestFinal)
# endif
#else
# ifndef _EVP_DigestFinal
#  define _EVP_DigestFinal OPENSSL_MANGLER_ASM(EVP_DigestFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestFinal_ex
#  define EVP_DigestFinal_ex OPENSSL_MANGLER(EVP_DigestFinal_ex)
# endif
#else
# ifndef _EVP_DigestFinal_ex
#  define _EVP_DigestFinal_ex OPENSSL_MANGLER_ASM(EVP_DigestFinal_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestFinalXOF
#  define EVP_DigestFinalXOF OPENSSL_MANGLER(EVP_DigestFinalXOF)
# endif
#else
# ifndef _EVP_DigestFinalXOF
#  define _EVP_DigestFinalXOF OPENSSL_MANGLER_ASM(EVP_DigestFinalXOF)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestInit
#  define EVP_DigestInit OPENSSL_MANGLER(EVP_DigestInit)
# endif
#else
# ifndef _EVP_DigestInit
#  define _EVP_DigestInit OPENSSL_MANGLER_ASM(EVP_DigestInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestInit_ex
#  define EVP_DigestInit_ex OPENSSL_MANGLER(EVP_DigestInit_ex)
# endif
#else
# ifndef _EVP_DigestInit_ex
#  define _EVP_DigestInit_ex OPENSSL_MANGLER_ASM(EVP_DigestInit_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestSign
#  define EVP_DigestSign OPENSSL_MANGLER(EVP_DigestSign)
# endif
#else
# ifndef _EVP_DigestSign
#  define _EVP_DigestSign OPENSSL_MANGLER_ASM(EVP_DigestSign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestSignFinal
#  define EVP_DigestSignFinal OPENSSL_MANGLER(EVP_DigestSignFinal)
# endif
#else
# ifndef _EVP_DigestSignFinal
#  define _EVP_DigestSignFinal OPENSSL_MANGLER_ASM(EVP_DigestSignFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestSignInit
#  define EVP_DigestSignInit OPENSSL_MANGLER(EVP_DigestSignInit)
# endif
#else
# ifndef _EVP_DigestSignInit
#  define _EVP_DigestSignInit OPENSSL_MANGLER_ASM(EVP_DigestSignInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestUpdate
#  define EVP_DigestUpdate OPENSSL_MANGLER(EVP_DigestUpdate)
# endif
#else
# ifndef _EVP_DigestUpdate
#  define _EVP_DigestUpdate OPENSSL_MANGLER_ASM(EVP_DigestUpdate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestVerify
#  define EVP_DigestVerify OPENSSL_MANGLER(EVP_DigestVerify)
# endif
#else
# ifndef _EVP_DigestVerify
#  define _EVP_DigestVerify OPENSSL_MANGLER_ASM(EVP_DigestVerify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestVerifyFinal
#  define EVP_DigestVerifyFinal OPENSSL_MANGLER(EVP_DigestVerifyFinal)
# endif
#else
# ifndef _EVP_DigestVerifyFinal
#  define _EVP_DigestVerifyFinal OPENSSL_MANGLER_ASM(EVP_DigestVerifyFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_DigestVerifyInit
#  define EVP_DigestVerifyInit OPENSSL_MANGLER(EVP_DigestVerifyInit)
# endif
#else
# ifndef _EVP_DigestVerifyInit
#  define _EVP_DigestVerifyInit OPENSSL_MANGLER_ASM(EVP_DigestVerifyInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_enc_null
#  define EVP_enc_null OPENSSL_MANGLER(EVP_enc_null)
# endif
#else
# ifndef _EVP_enc_null
#  define _EVP_enc_null OPENSSL_MANGLER_ASM(EVP_enc_null)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_EncodeBlock
#  define EVP_EncodeBlock OPENSSL_MANGLER(EVP_EncodeBlock)
# endif
#else
# ifndef _EVP_EncodeBlock
#  define _EVP_EncodeBlock OPENSSL_MANGLER_ASM(EVP_EncodeBlock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_ENCODE_CTX_copy
#  define EVP_ENCODE_CTX_copy OPENSSL_MANGLER(EVP_ENCODE_CTX_copy)
# endif
#else
# ifndef _EVP_ENCODE_CTX_copy
#  define _EVP_ENCODE_CTX_copy OPENSSL_MANGLER_ASM(EVP_ENCODE_CTX_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_ENCODE_CTX_free
#  define EVP_ENCODE_CTX_free OPENSSL_MANGLER(EVP_ENCODE_CTX_free)
# endif
#else
# ifndef _EVP_ENCODE_CTX_free
#  define _EVP_ENCODE_CTX_free OPENSSL_MANGLER_ASM(EVP_ENCODE_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_ENCODE_CTX_new
#  define EVP_ENCODE_CTX_new OPENSSL_MANGLER(EVP_ENCODE_CTX_new)
# endif
#else
# ifndef _EVP_ENCODE_CTX_new
#  define _EVP_ENCODE_CTX_new OPENSSL_MANGLER_ASM(EVP_ENCODE_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_ENCODE_CTX_num
#  define EVP_ENCODE_CTX_num OPENSSL_MANGLER(EVP_ENCODE_CTX_num)
# endif
#else
# ifndef _EVP_ENCODE_CTX_num
#  define _EVP_ENCODE_CTX_num OPENSSL_MANGLER_ASM(EVP_ENCODE_CTX_num)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef evp_encode_ctx_set_flags
#  define evp_encode_ctx_set_flags OPENSSL_MANGLER(evp_encode_ctx_set_flags)
# endif
#else
# ifndef _evp_encode_ctx_set_flags
#  define _evp_encode_ctx_set_flags OPENSSL_MANGLER_ASM(evp_encode_ctx_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_EncodeFinal
#  define EVP_EncodeFinal OPENSSL_MANGLER(EVP_EncodeFinal)
# endif
#else
# ifndef _EVP_EncodeFinal
#  define _EVP_EncodeFinal OPENSSL_MANGLER_ASM(EVP_EncodeFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_EncodeInit
#  define EVP_EncodeInit OPENSSL_MANGLER(EVP_EncodeInit)
# endif
#else
# ifndef _EVP_EncodeInit
#  define _EVP_EncodeInit OPENSSL_MANGLER_ASM(EVP_EncodeInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_EncodeUpdate
#  define EVP_EncodeUpdate OPENSSL_MANGLER(EVP_EncodeUpdate)
# endif
#else
# ifndef _EVP_EncodeUpdate
#  define _EVP_EncodeUpdate OPENSSL_MANGLER_ASM(EVP_EncodeUpdate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_EncryptFinal
#  define EVP_EncryptFinal OPENSSL_MANGLER(EVP_EncryptFinal)
# endif
#else
# ifndef _EVP_EncryptFinal
#  define _EVP_EncryptFinal OPENSSL_MANGLER_ASM(EVP_EncryptFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_EncryptFinal_ex
#  define EVP_EncryptFinal_ex OPENSSL_MANGLER(EVP_EncryptFinal_ex)
# endif
#else
# ifndef _EVP_EncryptFinal_ex
#  define _EVP_EncryptFinal_ex OPENSSL_MANGLER_ASM(EVP_EncryptFinal_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_EncryptInit
#  define EVP_EncryptInit OPENSSL_MANGLER(EVP_EncryptInit)
# endif
#else
# ifndef _EVP_EncryptInit
#  define _EVP_EncryptInit OPENSSL_MANGLER_ASM(EVP_EncryptInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_EncryptInit_ex
#  define EVP_EncryptInit_ex OPENSSL_MANGLER(EVP_EncryptInit_ex)
# endif
#else
# ifndef _EVP_EncryptInit_ex
#  define _EVP_EncryptInit_ex OPENSSL_MANGLER_ASM(EVP_EncryptInit_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_EncryptUpdate
#  define EVP_EncryptUpdate OPENSSL_MANGLER(EVP_EncryptUpdate)
# endif
#else
# ifndef _EVP_EncryptUpdate
#  define _EVP_EncryptUpdate OPENSSL_MANGLER_ASM(EVP_EncryptUpdate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_get_cipherbyname
#  define EVP_get_cipherbyname OPENSSL_MANGLER(EVP_get_cipherbyname)
# endif
#else
# ifndef _EVP_get_cipherbyname
#  define _EVP_get_cipherbyname OPENSSL_MANGLER_ASM(EVP_get_cipherbyname)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_get_digestbyname
#  define EVP_get_digestbyname OPENSSL_MANGLER(EVP_get_digestbyname)
# endif
#else
# ifndef _EVP_get_digestbyname
#  define _EVP_get_digestbyname OPENSSL_MANGLER_ASM(EVP_get_digestbyname)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_get_pw_prompt
#  define EVP_get_pw_prompt OPENSSL_MANGLER(EVP_get_pw_prompt)
# endif
#else
# ifndef _EVP_get_pw_prompt
#  define _EVP_get_pw_prompt OPENSSL_MANGLER_ASM(EVP_get_pw_prompt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_md2
#  define EVP_md2 OPENSSL_MANGLER(EVP_md2)
# endif
#else
# ifndef _EVP_md2
#  define _EVP_md2 OPENSSL_MANGLER_ASM(EVP_md2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_md5
#  define EVP_md5 OPENSSL_MANGLER(EVP_md5)
# endif
#else
# ifndef _EVP_md5
#  define _EVP_md5 OPENSSL_MANGLER_ASM(EVP_md5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_md5_sha1
#  define EVP_md5_sha1 OPENSSL_MANGLER(EVP_md5_sha1)
# endif
#else
# ifndef _EVP_md5_sha1
#  define _EVP_md5_sha1 OPENSSL_MANGLER_ASM(EVP_md5_sha1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_block_size
#  define EVP_MD_block_size OPENSSL_MANGLER(EVP_MD_block_size)
# endif
#else
# ifndef _EVP_MD_block_size
#  define _EVP_MD_block_size OPENSSL_MANGLER_ASM(EVP_MD_block_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_clear_flags
#  define EVP_MD_CTX_clear_flags OPENSSL_MANGLER(EVP_MD_CTX_clear_flags)
# endif
#else
# ifndef _EVP_MD_CTX_clear_flags
#  define _EVP_MD_CTX_clear_flags OPENSSL_MANGLER_ASM(EVP_MD_CTX_clear_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_copy
#  define EVP_MD_CTX_copy OPENSSL_MANGLER(EVP_MD_CTX_copy)
# endif
#else
# ifndef _EVP_MD_CTX_copy
#  define _EVP_MD_CTX_copy OPENSSL_MANGLER_ASM(EVP_MD_CTX_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_copy_ex
#  define EVP_MD_CTX_copy_ex OPENSSL_MANGLER(EVP_MD_CTX_copy_ex)
# endif
#else
# ifndef _EVP_MD_CTX_copy_ex
#  define _EVP_MD_CTX_copy_ex OPENSSL_MANGLER_ASM(EVP_MD_CTX_copy_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_ctrl
#  define EVP_MD_CTX_ctrl OPENSSL_MANGLER(EVP_MD_CTX_ctrl)
# endif
#else
# ifndef _EVP_MD_CTX_ctrl
#  define _EVP_MD_CTX_ctrl OPENSSL_MANGLER_ASM(EVP_MD_CTX_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_free
#  define EVP_MD_CTX_free OPENSSL_MANGLER(EVP_MD_CTX_free)
# endif
#else
# ifndef _EVP_MD_CTX_free
#  define _EVP_MD_CTX_free OPENSSL_MANGLER_ASM(EVP_MD_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_md
#  define EVP_MD_CTX_md OPENSSL_MANGLER(EVP_MD_CTX_md)
# endif
#else
# ifndef _EVP_MD_CTX_md
#  define _EVP_MD_CTX_md OPENSSL_MANGLER_ASM(EVP_MD_CTX_md)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_md_data
#  define EVP_MD_CTX_md_data OPENSSL_MANGLER(EVP_MD_CTX_md_data)
# endif
#else
# ifndef _EVP_MD_CTX_md_data
#  define _EVP_MD_CTX_md_data OPENSSL_MANGLER_ASM(EVP_MD_CTX_md_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_new
#  define EVP_MD_CTX_new OPENSSL_MANGLER(EVP_MD_CTX_new)
# endif
#else
# ifndef _EVP_MD_CTX_new
#  define _EVP_MD_CTX_new OPENSSL_MANGLER_ASM(EVP_MD_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_pkey_ctx
#  define EVP_MD_CTX_pkey_ctx OPENSSL_MANGLER(EVP_MD_CTX_pkey_ctx)
# endif
#else
# ifndef _EVP_MD_CTX_pkey_ctx
#  define _EVP_MD_CTX_pkey_ctx OPENSSL_MANGLER_ASM(EVP_MD_CTX_pkey_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_reset
#  define EVP_MD_CTX_reset OPENSSL_MANGLER(EVP_MD_CTX_reset)
# endif
#else
# ifndef _EVP_MD_CTX_reset
#  define _EVP_MD_CTX_reset OPENSSL_MANGLER_ASM(EVP_MD_CTX_reset)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_set_flags
#  define EVP_MD_CTX_set_flags OPENSSL_MANGLER(EVP_MD_CTX_set_flags)
# endif
#else
# ifndef _EVP_MD_CTX_set_flags
#  define _EVP_MD_CTX_set_flags OPENSSL_MANGLER_ASM(EVP_MD_CTX_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_set_pkey_ctx
#  define EVP_MD_CTX_set_pkey_ctx OPENSSL_MANGLER(EVP_MD_CTX_set_pkey_ctx)
# endif
#else
# ifndef _EVP_MD_CTX_set_pkey_ctx
#  define _EVP_MD_CTX_set_pkey_ctx OPENSSL_MANGLER_ASM(EVP_MD_CTX_set_pkey_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_set_update_fn
#  define EVP_MD_CTX_set_update_fn OPENSSL_MANGLER(EVP_MD_CTX_set_update_fn)
# endif
#else
# ifndef _EVP_MD_CTX_set_update_fn
#  define _EVP_MD_CTX_set_update_fn OPENSSL_MANGLER_ASM(EVP_MD_CTX_set_update_fn)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_test_flags
#  define EVP_MD_CTX_test_flags OPENSSL_MANGLER(EVP_MD_CTX_test_flags)
# endif
#else
# ifndef _EVP_MD_CTX_test_flags
#  define _EVP_MD_CTX_test_flags OPENSSL_MANGLER_ASM(EVP_MD_CTX_test_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_CTX_update_fn
#  define EVP_MD_CTX_update_fn OPENSSL_MANGLER(EVP_MD_CTX_update_fn)
# endif
#else
# ifndef _EVP_MD_CTX_update_fn
#  define _EVP_MD_CTX_update_fn OPENSSL_MANGLER_ASM(EVP_MD_CTX_update_fn)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_do_all
#  define EVP_MD_do_all OPENSSL_MANGLER(EVP_MD_do_all)
# endif
#else
# ifndef _EVP_MD_do_all
#  define _EVP_MD_do_all OPENSSL_MANGLER_ASM(EVP_MD_do_all)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_do_all_sorted
#  define EVP_MD_do_all_sorted OPENSSL_MANGLER(EVP_MD_do_all_sorted)
# endif
#else
# ifndef _EVP_MD_do_all_sorted
#  define _EVP_MD_do_all_sorted OPENSSL_MANGLER_ASM(EVP_MD_do_all_sorted)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_flags
#  define EVP_MD_flags OPENSSL_MANGLER(EVP_MD_flags)
# endif
#else
# ifndef _EVP_MD_flags
#  define _EVP_MD_flags OPENSSL_MANGLER_ASM(EVP_MD_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_dup
#  define EVP_MD_meth_dup OPENSSL_MANGLER(EVP_MD_meth_dup)
# endif
#else
# ifndef _EVP_MD_meth_dup
#  define _EVP_MD_meth_dup OPENSSL_MANGLER_ASM(EVP_MD_meth_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_free
#  define EVP_MD_meth_free OPENSSL_MANGLER(EVP_MD_meth_free)
# endif
#else
# ifndef _EVP_MD_meth_free
#  define _EVP_MD_meth_free OPENSSL_MANGLER_ASM(EVP_MD_meth_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_get_app_datasize
#  define EVP_MD_meth_get_app_datasize OPENSSL_MANGLER(EVP_MD_meth_get_app_datasize)
# endif
#else
# ifndef _EVP_MD_meth_get_app_datasize
#  define _EVP_MD_meth_get_app_datasize OPENSSL_MANGLER_ASM(EVP_MD_meth_get_app_datasize)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_get_cleanup
#  define EVP_MD_meth_get_cleanup OPENSSL_MANGLER(EVP_MD_meth_get_cleanup)
# endif
#else
# ifndef _EVP_MD_meth_get_cleanup
#  define _EVP_MD_meth_get_cleanup OPENSSL_MANGLER_ASM(EVP_MD_meth_get_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_get_copy
#  define EVP_MD_meth_get_copy OPENSSL_MANGLER(EVP_MD_meth_get_copy)
# endif
#else
# ifndef _EVP_MD_meth_get_copy
#  define _EVP_MD_meth_get_copy OPENSSL_MANGLER_ASM(EVP_MD_meth_get_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_get_ctrl
#  define EVP_MD_meth_get_ctrl OPENSSL_MANGLER(EVP_MD_meth_get_ctrl)
# endif
#else
# ifndef _EVP_MD_meth_get_ctrl
#  define _EVP_MD_meth_get_ctrl OPENSSL_MANGLER_ASM(EVP_MD_meth_get_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_get_final
#  define EVP_MD_meth_get_final OPENSSL_MANGLER(EVP_MD_meth_get_final)
# endif
#else
# ifndef _EVP_MD_meth_get_final
#  define _EVP_MD_meth_get_final OPENSSL_MANGLER_ASM(EVP_MD_meth_get_final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_get_flags
#  define EVP_MD_meth_get_flags OPENSSL_MANGLER(EVP_MD_meth_get_flags)
# endif
#else
# ifndef _EVP_MD_meth_get_flags
#  define _EVP_MD_meth_get_flags OPENSSL_MANGLER_ASM(EVP_MD_meth_get_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_get_init
#  define EVP_MD_meth_get_init OPENSSL_MANGLER(EVP_MD_meth_get_init)
# endif
#else
# ifndef _EVP_MD_meth_get_init
#  define _EVP_MD_meth_get_init OPENSSL_MANGLER_ASM(EVP_MD_meth_get_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_get_input_blocksize
#  define EVP_MD_meth_get_input_blocksize OPENSSL_MANGLER(EVP_MD_meth_get_input_blocksize)
# endif
#else
# ifndef _EVP_MD_meth_get_input_blocksize
#  define _EVP_MD_meth_get_input_blocksize OPENSSL_MANGLER_ASM(EVP_MD_meth_get_input_blocksize)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_get_result_size
#  define EVP_MD_meth_get_result_size OPENSSL_MANGLER(EVP_MD_meth_get_result_size)
# endif
#else
# ifndef _EVP_MD_meth_get_result_size
#  define _EVP_MD_meth_get_result_size OPENSSL_MANGLER_ASM(EVP_MD_meth_get_result_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_get_update
#  define EVP_MD_meth_get_update OPENSSL_MANGLER(EVP_MD_meth_get_update)
# endif
#else
# ifndef _EVP_MD_meth_get_update
#  define _EVP_MD_meth_get_update OPENSSL_MANGLER_ASM(EVP_MD_meth_get_update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_new
#  define EVP_MD_meth_new OPENSSL_MANGLER(EVP_MD_meth_new)
# endif
#else
# ifndef _EVP_MD_meth_new
#  define _EVP_MD_meth_new OPENSSL_MANGLER_ASM(EVP_MD_meth_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_set_app_datasize
#  define EVP_MD_meth_set_app_datasize OPENSSL_MANGLER(EVP_MD_meth_set_app_datasize)
# endif
#else
# ifndef _EVP_MD_meth_set_app_datasize
#  define _EVP_MD_meth_set_app_datasize OPENSSL_MANGLER_ASM(EVP_MD_meth_set_app_datasize)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_set_cleanup
#  define EVP_MD_meth_set_cleanup OPENSSL_MANGLER(EVP_MD_meth_set_cleanup)
# endif
#else
# ifndef _EVP_MD_meth_set_cleanup
#  define _EVP_MD_meth_set_cleanup OPENSSL_MANGLER_ASM(EVP_MD_meth_set_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_set_copy
#  define EVP_MD_meth_set_copy OPENSSL_MANGLER(EVP_MD_meth_set_copy)
# endif
#else
# ifndef _EVP_MD_meth_set_copy
#  define _EVP_MD_meth_set_copy OPENSSL_MANGLER_ASM(EVP_MD_meth_set_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_set_ctrl
#  define EVP_MD_meth_set_ctrl OPENSSL_MANGLER(EVP_MD_meth_set_ctrl)
# endif
#else
# ifndef _EVP_MD_meth_set_ctrl
#  define _EVP_MD_meth_set_ctrl OPENSSL_MANGLER_ASM(EVP_MD_meth_set_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_set_final
#  define EVP_MD_meth_set_final OPENSSL_MANGLER(EVP_MD_meth_set_final)
# endif
#else
# ifndef _EVP_MD_meth_set_final
#  define _EVP_MD_meth_set_final OPENSSL_MANGLER_ASM(EVP_MD_meth_set_final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_set_flags
#  define EVP_MD_meth_set_flags OPENSSL_MANGLER(EVP_MD_meth_set_flags)
# endif
#else
# ifndef _EVP_MD_meth_set_flags
#  define _EVP_MD_meth_set_flags OPENSSL_MANGLER_ASM(EVP_MD_meth_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_set_init
#  define EVP_MD_meth_set_init OPENSSL_MANGLER(EVP_MD_meth_set_init)
# endif
#else
# ifndef _EVP_MD_meth_set_init
#  define _EVP_MD_meth_set_init OPENSSL_MANGLER_ASM(EVP_MD_meth_set_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_set_input_blocksize
#  define EVP_MD_meth_set_input_blocksize OPENSSL_MANGLER(EVP_MD_meth_set_input_blocksize)
# endif
#else
# ifndef _EVP_MD_meth_set_input_blocksize
#  define _EVP_MD_meth_set_input_blocksize OPENSSL_MANGLER_ASM(EVP_MD_meth_set_input_blocksize)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_set_result_size
#  define EVP_MD_meth_set_result_size OPENSSL_MANGLER(EVP_MD_meth_set_result_size)
# endif
#else
# ifndef _EVP_MD_meth_set_result_size
#  define _EVP_MD_meth_set_result_size OPENSSL_MANGLER_ASM(EVP_MD_meth_set_result_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_meth_set_update
#  define EVP_MD_meth_set_update OPENSSL_MANGLER(EVP_MD_meth_set_update)
# endif
#else
# ifndef _EVP_MD_meth_set_update
#  define _EVP_MD_meth_set_update OPENSSL_MANGLER_ASM(EVP_MD_meth_set_update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_md_null
#  define EVP_md_null OPENSSL_MANGLER(EVP_md_null)
# endif
#else
# ifndef _EVP_md_null
#  define _EVP_md_null OPENSSL_MANGLER_ASM(EVP_md_null)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_pkey_type
#  define EVP_MD_pkey_type OPENSSL_MANGLER(EVP_MD_pkey_type)
# endif
#else
# ifndef _EVP_MD_pkey_type
#  define _EVP_MD_pkey_type OPENSSL_MANGLER_ASM(EVP_MD_pkey_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_size
#  define EVP_MD_size OPENSSL_MANGLER(EVP_MD_size)
# endif
#else
# ifndef _EVP_MD_size
#  define _EVP_MD_size OPENSSL_MANGLER_ASM(EVP_MD_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_MD_type
#  define EVP_MD_type OPENSSL_MANGLER(EVP_MD_type)
# endif
#else
# ifndef _EVP_MD_type
#  define _EVP_MD_type OPENSSL_MANGLER_ASM(EVP_MD_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_OpenFinal
#  define EVP_OpenFinal OPENSSL_MANGLER(EVP_OpenFinal)
# endif
#else
# ifndef _EVP_OpenFinal
#  define _EVP_OpenFinal OPENSSL_MANGLER_ASM(EVP_OpenFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_OpenInit
#  define EVP_OpenInit OPENSSL_MANGLER(EVP_OpenInit)
# endif
#else
# ifndef _EVP_OpenInit
#  define _EVP_OpenInit OPENSSL_MANGLER_ASM(EVP_OpenInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PBE_alg_add
#  define EVP_PBE_alg_add OPENSSL_MANGLER(EVP_PBE_alg_add)
# endif
#else
# ifndef _EVP_PBE_alg_add
#  define _EVP_PBE_alg_add OPENSSL_MANGLER_ASM(EVP_PBE_alg_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PBE_alg_add_type
#  define EVP_PBE_alg_add_type OPENSSL_MANGLER(EVP_PBE_alg_add_type)
# endif
#else
# ifndef _EVP_PBE_alg_add_type
#  define _EVP_PBE_alg_add_type OPENSSL_MANGLER_ASM(EVP_PBE_alg_add_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PBE_CipherInit
#  define EVP_PBE_CipherInit OPENSSL_MANGLER(EVP_PBE_CipherInit)
# endif
#else
# ifndef _EVP_PBE_CipherInit
#  define _EVP_PBE_CipherInit OPENSSL_MANGLER_ASM(EVP_PBE_CipherInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PBE_cleanup
#  define EVP_PBE_cleanup OPENSSL_MANGLER(EVP_PBE_cleanup)
# endif
#else
# ifndef _EVP_PBE_cleanup
#  define _EVP_PBE_cleanup OPENSSL_MANGLER_ASM(EVP_PBE_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PBE_find
#  define EVP_PBE_find OPENSSL_MANGLER(EVP_PBE_find)
# endif
#else
# ifndef _EVP_PBE_find
#  define _EVP_PBE_find OPENSSL_MANGLER_ASM(EVP_PBE_find)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PBE_get
#  define EVP_PBE_get OPENSSL_MANGLER(EVP_PBE_get)
# endif
#else
# ifndef _EVP_PBE_get
#  define _EVP_PBE_get OPENSSL_MANGLER_ASM(EVP_PBE_get)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PBE_scrypt
#  define EVP_PBE_scrypt OPENSSL_MANGLER(EVP_PBE_scrypt)
# endif
#else
# ifndef _EVP_PBE_scrypt
#  define _EVP_PBE_scrypt OPENSSL_MANGLER_ASM(EVP_PBE_scrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKCS82PKEY
#  define EVP_PKCS82PKEY OPENSSL_MANGLER(EVP_PKCS82PKEY)
# endif
#else
# ifndef _EVP_PKCS82PKEY
#  define _EVP_PKCS82PKEY OPENSSL_MANGLER_ASM(EVP_PKCS82PKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY2PKCS8
#  define EVP_PKEY2PKCS8 OPENSSL_MANGLER(EVP_PKEY2PKCS8)
# endif
#else
# ifndef _EVP_PKEY2PKCS8
#  define _EVP_PKEY2PKCS8 OPENSSL_MANGLER_ASM(EVP_PKEY2PKCS8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_add1_attr
#  define EVP_PKEY_add1_attr OPENSSL_MANGLER(EVP_PKEY_add1_attr)
# endif
#else
# ifndef _EVP_PKEY_add1_attr
#  define _EVP_PKEY_add1_attr OPENSSL_MANGLER_ASM(EVP_PKEY_add1_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_add1_attr_by_NID
#  define EVP_PKEY_add1_attr_by_NID OPENSSL_MANGLER(EVP_PKEY_add1_attr_by_NID)
# endif
#else
# ifndef _EVP_PKEY_add1_attr_by_NID
#  define _EVP_PKEY_add1_attr_by_NID OPENSSL_MANGLER_ASM(EVP_PKEY_add1_attr_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_add1_attr_by_OBJ
#  define EVP_PKEY_add1_attr_by_OBJ OPENSSL_MANGLER(EVP_PKEY_add1_attr_by_OBJ)
# endif
#else
# ifndef _EVP_PKEY_add1_attr_by_OBJ
#  define _EVP_PKEY_add1_attr_by_OBJ OPENSSL_MANGLER_ASM(EVP_PKEY_add1_attr_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_add1_attr_by_txt
#  define EVP_PKEY_add1_attr_by_txt OPENSSL_MANGLER(EVP_PKEY_add1_attr_by_txt)
# endif
#else
# ifndef _EVP_PKEY_add1_attr_by_txt
#  define _EVP_PKEY_add1_attr_by_txt OPENSSL_MANGLER_ASM(EVP_PKEY_add1_attr_by_txt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_add0
#  define EVP_PKEY_asn1_add0 OPENSSL_MANGLER(EVP_PKEY_asn1_add0)
# endif
#else
# ifndef _EVP_PKEY_asn1_add0
#  define _EVP_PKEY_asn1_add0 OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_add0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_add_alias
#  define EVP_PKEY_asn1_add_alias OPENSSL_MANGLER(EVP_PKEY_asn1_add_alias)
# endif
#else
# ifndef _EVP_PKEY_asn1_add_alias
#  define _EVP_PKEY_asn1_add_alias OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_add_alias)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_copy
#  define EVP_PKEY_asn1_copy OPENSSL_MANGLER(EVP_PKEY_asn1_copy)
# endif
#else
# ifndef _EVP_PKEY_asn1_copy
#  define _EVP_PKEY_asn1_copy OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_find
#  define EVP_PKEY_asn1_find OPENSSL_MANGLER(EVP_PKEY_asn1_find)
# endif
#else
# ifndef _EVP_PKEY_asn1_find
#  define _EVP_PKEY_asn1_find OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_find)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_find_str
#  define EVP_PKEY_asn1_find_str OPENSSL_MANGLER(EVP_PKEY_asn1_find_str)
# endif
#else
# ifndef _EVP_PKEY_asn1_find_str
#  define _EVP_PKEY_asn1_find_str OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_find_str)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_free
#  define EVP_PKEY_asn1_free OPENSSL_MANGLER(EVP_PKEY_asn1_free)
# endif
#else
# ifndef _EVP_PKEY_asn1_free
#  define _EVP_PKEY_asn1_free OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_get0
#  define EVP_PKEY_asn1_get0 OPENSSL_MANGLER(EVP_PKEY_asn1_get0)
# endif
#else
# ifndef _EVP_PKEY_asn1_get0
#  define _EVP_PKEY_asn1_get0 OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_get0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_get0_info
#  define EVP_PKEY_asn1_get0_info OPENSSL_MANGLER(EVP_PKEY_asn1_get0_info)
# endif
#else
# ifndef _EVP_PKEY_asn1_get0_info
#  define _EVP_PKEY_asn1_get0_info OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_get0_info)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_get_count
#  define EVP_PKEY_asn1_get_count OPENSSL_MANGLER(EVP_PKEY_asn1_get_count)
# endif
#else
# ifndef _EVP_PKEY_asn1_get_count
#  define _EVP_PKEY_asn1_get_count OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_get_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_new
#  define EVP_PKEY_asn1_new OPENSSL_MANGLER(EVP_PKEY_asn1_new)
# endif
#else
# ifndef _EVP_PKEY_asn1_new
#  define _EVP_PKEY_asn1_new OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_check
#  define EVP_PKEY_asn1_set_check OPENSSL_MANGLER(EVP_PKEY_asn1_set_check)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_check
#  define _EVP_PKEY_asn1_set_check OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_ctrl
#  define EVP_PKEY_asn1_set_ctrl OPENSSL_MANGLER(EVP_PKEY_asn1_set_ctrl)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_ctrl
#  define _EVP_PKEY_asn1_set_ctrl OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_free
#  define EVP_PKEY_asn1_set_free OPENSSL_MANGLER(EVP_PKEY_asn1_set_free)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_free
#  define _EVP_PKEY_asn1_set_free OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_get_priv_key
#  define EVP_PKEY_asn1_set_get_priv_key OPENSSL_MANGLER(EVP_PKEY_asn1_set_get_priv_key)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_get_priv_key
#  define _EVP_PKEY_asn1_set_get_priv_key OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_get_priv_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_get_pub_key
#  define EVP_PKEY_asn1_set_get_pub_key OPENSSL_MANGLER(EVP_PKEY_asn1_set_get_pub_key)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_get_pub_key
#  define _EVP_PKEY_asn1_set_get_pub_key OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_get_pub_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_item
#  define EVP_PKEY_asn1_set_item OPENSSL_MANGLER(EVP_PKEY_asn1_set_item)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_item
#  define _EVP_PKEY_asn1_set_item OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_item)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_param
#  define EVP_PKEY_asn1_set_param OPENSSL_MANGLER(EVP_PKEY_asn1_set_param)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_param
#  define _EVP_PKEY_asn1_set_param OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_param)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_param_check
#  define EVP_PKEY_asn1_set_param_check OPENSSL_MANGLER(EVP_PKEY_asn1_set_param_check)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_param_check
#  define _EVP_PKEY_asn1_set_param_check OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_param_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_private
#  define EVP_PKEY_asn1_set_private OPENSSL_MANGLER(EVP_PKEY_asn1_set_private)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_private
#  define _EVP_PKEY_asn1_set_private OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_private)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_public
#  define EVP_PKEY_asn1_set_public OPENSSL_MANGLER(EVP_PKEY_asn1_set_public)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_public
#  define _EVP_PKEY_asn1_set_public OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_public)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_public_check
#  define EVP_PKEY_asn1_set_public_check OPENSSL_MANGLER(EVP_PKEY_asn1_set_public_check)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_public_check
#  define _EVP_PKEY_asn1_set_public_check OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_public_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_security_bits
#  define EVP_PKEY_asn1_set_security_bits OPENSSL_MANGLER(EVP_PKEY_asn1_set_security_bits)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_security_bits
#  define _EVP_PKEY_asn1_set_security_bits OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_security_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_set_priv_key
#  define EVP_PKEY_asn1_set_set_priv_key OPENSSL_MANGLER(EVP_PKEY_asn1_set_set_priv_key)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_set_priv_key
#  define _EVP_PKEY_asn1_set_set_priv_key OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_set_priv_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_set_pub_key
#  define EVP_PKEY_asn1_set_set_pub_key OPENSSL_MANGLER(EVP_PKEY_asn1_set_set_pub_key)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_set_pub_key
#  define _EVP_PKEY_asn1_set_set_pub_key OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_set_pub_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_asn1_set_siginf
#  define EVP_PKEY_asn1_set_siginf OPENSSL_MANGLER(EVP_PKEY_asn1_set_siginf)
# endif
#else
# ifndef _EVP_PKEY_asn1_set_siginf
#  define _EVP_PKEY_asn1_set_siginf OPENSSL_MANGLER_ASM(EVP_PKEY_asn1_set_siginf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_assign
#  define EVP_PKEY_assign OPENSSL_MANGLER(EVP_PKEY_assign)
# endif
#else
# ifndef _EVP_PKEY_assign
#  define _EVP_PKEY_assign OPENSSL_MANGLER_ASM(EVP_PKEY_assign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_base_id
#  define EVP_PKEY_base_id OPENSSL_MANGLER(EVP_PKEY_base_id)
# endif
#else
# ifndef _EVP_PKEY_base_id
#  define _EVP_PKEY_base_id OPENSSL_MANGLER_ASM(EVP_PKEY_base_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_bits
#  define EVP_PKEY_bits OPENSSL_MANGLER(EVP_PKEY_bits)
# endif
#else
# ifndef _EVP_PKEY_bits
#  define _EVP_PKEY_bits OPENSSL_MANGLER_ASM(EVP_PKEY_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_check
#  define EVP_PKEY_check OPENSSL_MANGLER(EVP_PKEY_check)
# endif
#else
# ifndef _EVP_PKEY_check
#  define _EVP_PKEY_check OPENSSL_MANGLER_ASM(EVP_PKEY_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_cmp
#  define EVP_PKEY_cmp OPENSSL_MANGLER(EVP_PKEY_cmp)
# endif
#else
# ifndef _EVP_PKEY_cmp
#  define _EVP_PKEY_cmp OPENSSL_MANGLER_ASM(EVP_PKEY_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_cmp_parameters
#  define EVP_PKEY_cmp_parameters OPENSSL_MANGLER(EVP_PKEY_cmp_parameters)
# endif
#else
# ifndef _EVP_PKEY_cmp_parameters
#  define _EVP_PKEY_cmp_parameters OPENSSL_MANGLER_ASM(EVP_PKEY_cmp_parameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_copy_parameters
#  define EVP_PKEY_copy_parameters OPENSSL_MANGLER(EVP_PKEY_copy_parameters)
# endif
#else
# ifndef _EVP_PKEY_copy_parameters
#  define _EVP_PKEY_copy_parameters OPENSSL_MANGLER_ASM(EVP_PKEY_copy_parameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_ctrl
#  define EVP_PKEY_CTX_ctrl OPENSSL_MANGLER(EVP_PKEY_CTX_ctrl)
# endif
#else
# ifndef _EVP_PKEY_CTX_ctrl
#  define _EVP_PKEY_CTX_ctrl OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_ctrl_str
#  define EVP_PKEY_CTX_ctrl_str OPENSSL_MANGLER(EVP_PKEY_CTX_ctrl_str)
# endif
#else
# ifndef _EVP_PKEY_CTX_ctrl_str
#  define _EVP_PKEY_CTX_ctrl_str OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_ctrl_str)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_ctrl_uint64
#  define EVP_PKEY_CTX_ctrl_uint64 OPENSSL_MANGLER(EVP_PKEY_CTX_ctrl_uint64)
# endif
#else
# ifndef _EVP_PKEY_CTX_ctrl_uint64
#  define _EVP_PKEY_CTX_ctrl_uint64 OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_ctrl_uint64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_dup
#  define EVP_PKEY_CTX_dup OPENSSL_MANGLER(EVP_PKEY_CTX_dup)
# endif
#else
# ifndef _EVP_PKEY_CTX_dup
#  define _EVP_PKEY_CTX_dup OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_free
#  define EVP_PKEY_CTX_free OPENSSL_MANGLER(EVP_PKEY_CTX_free)
# endif
#else
# ifndef _EVP_PKEY_CTX_free
#  define _EVP_PKEY_CTX_free OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_get0_peerkey
#  define EVP_PKEY_CTX_get0_peerkey OPENSSL_MANGLER(EVP_PKEY_CTX_get0_peerkey)
# endif
#else
# ifndef _EVP_PKEY_CTX_get0_peerkey
#  define _EVP_PKEY_CTX_get0_peerkey OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_get0_peerkey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_get0_pkey
#  define EVP_PKEY_CTX_get0_pkey OPENSSL_MANGLER(EVP_PKEY_CTX_get0_pkey)
# endif
#else
# ifndef _EVP_PKEY_CTX_get0_pkey
#  define _EVP_PKEY_CTX_get0_pkey OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_get0_pkey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_get_app_data
#  define EVP_PKEY_CTX_get_app_data OPENSSL_MANGLER(EVP_PKEY_CTX_get_app_data)
# endif
#else
# ifndef _EVP_PKEY_CTX_get_app_data
#  define _EVP_PKEY_CTX_get_app_data OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_get_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_get_cb
#  define EVP_PKEY_CTX_get_cb OPENSSL_MANGLER(EVP_PKEY_CTX_get_cb)
# endif
#else
# ifndef _EVP_PKEY_CTX_get_cb
#  define _EVP_PKEY_CTX_get_cb OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_get_cb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_get_data
#  define EVP_PKEY_CTX_get_data OPENSSL_MANGLER(EVP_PKEY_CTX_get_data)
# endif
#else
# ifndef _EVP_PKEY_CTX_get_data
#  define _EVP_PKEY_CTX_get_data OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_get_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_get_keygen_info
#  define EVP_PKEY_CTX_get_keygen_info OPENSSL_MANGLER(EVP_PKEY_CTX_get_keygen_info)
# endif
#else
# ifndef _EVP_PKEY_CTX_get_keygen_info
#  define _EVP_PKEY_CTX_get_keygen_info OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_get_keygen_info)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_get_operation
#  define EVP_PKEY_CTX_get_operation OPENSSL_MANGLER(EVP_PKEY_CTX_get_operation)
# endif
#else
# ifndef _EVP_PKEY_CTX_get_operation
#  define _EVP_PKEY_CTX_get_operation OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_get_operation)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_hex2ctrl
#  define EVP_PKEY_CTX_hex2ctrl OPENSSL_MANGLER(EVP_PKEY_CTX_hex2ctrl)
# endif
#else
# ifndef _EVP_PKEY_CTX_hex2ctrl
#  define _EVP_PKEY_CTX_hex2ctrl OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_hex2ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_md
#  define EVP_PKEY_CTX_md OPENSSL_MANGLER(EVP_PKEY_CTX_md)
# endif
#else
# ifndef _EVP_PKEY_CTX_md
#  define _EVP_PKEY_CTX_md OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_md)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_new
#  define EVP_PKEY_CTX_new OPENSSL_MANGLER(EVP_PKEY_CTX_new)
# endif
#else
# ifndef _EVP_PKEY_CTX_new
#  define _EVP_PKEY_CTX_new OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_new_id
#  define EVP_PKEY_CTX_new_id OPENSSL_MANGLER(EVP_PKEY_CTX_new_id)
# endif
#else
# ifndef _EVP_PKEY_CTX_new_id
#  define _EVP_PKEY_CTX_new_id OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_new_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_set0_keygen_info
#  define EVP_PKEY_CTX_set0_keygen_info OPENSSL_MANGLER(EVP_PKEY_CTX_set0_keygen_info)
# endif
#else
# ifndef _EVP_PKEY_CTX_set0_keygen_info
#  define _EVP_PKEY_CTX_set0_keygen_info OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_set0_keygen_info)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_set_app_data
#  define EVP_PKEY_CTX_set_app_data OPENSSL_MANGLER(EVP_PKEY_CTX_set_app_data)
# endif
#else
# ifndef _EVP_PKEY_CTX_set_app_data
#  define _EVP_PKEY_CTX_set_app_data OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_set_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_set_cb
#  define EVP_PKEY_CTX_set_cb OPENSSL_MANGLER(EVP_PKEY_CTX_set_cb)
# endif
#else
# ifndef _EVP_PKEY_CTX_set_cb
#  define _EVP_PKEY_CTX_set_cb OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_set_cb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_set_data
#  define EVP_PKEY_CTX_set_data OPENSSL_MANGLER(EVP_PKEY_CTX_set_data)
# endif
#else
# ifndef _EVP_PKEY_CTX_set_data
#  define _EVP_PKEY_CTX_set_data OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_set_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_CTX_str2ctrl
#  define EVP_PKEY_CTX_str2ctrl OPENSSL_MANGLER(EVP_PKEY_CTX_str2ctrl)
# endif
#else
# ifndef _EVP_PKEY_CTX_str2ctrl
#  define _EVP_PKEY_CTX_str2ctrl OPENSSL_MANGLER_ASM(EVP_PKEY_CTX_str2ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_decrypt
#  define EVP_PKEY_decrypt OPENSSL_MANGLER(EVP_PKEY_decrypt)
# endif
#else
# ifndef _EVP_PKEY_decrypt
#  define _EVP_PKEY_decrypt OPENSSL_MANGLER_ASM(EVP_PKEY_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_decrypt_init
#  define EVP_PKEY_decrypt_init OPENSSL_MANGLER(EVP_PKEY_decrypt_init)
# endif
#else
# ifndef _EVP_PKEY_decrypt_init
#  define _EVP_PKEY_decrypt_init OPENSSL_MANGLER_ASM(EVP_PKEY_decrypt_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_decrypt_old
#  define EVP_PKEY_decrypt_old OPENSSL_MANGLER(EVP_PKEY_decrypt_old)
# endif
#else
# ifndef _EVP_PKEY_decrypt_old
#  define _EVP_PKEY_decrypt_old OPENSSL_MANGLER_ASM(EVP_PKEY_decrypt_old)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_delete_attr
#  define EVP_PKEY_delete_attr OPENSSL_MANGLER(EVP_PKEY_delete_attr)
# endif
#else
# ifndef _EVP_PKEY_delete_attr
#  define _EVP_PKEY_delete_attr OPENSSL_MANGLER_ASM(EVP_PKEY_delete_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_derive
#  define EVP_PKEY_derive OPENSSL_MANGLER(EVP_PKEY_derive)
# endif
#else
# ifndef _EVP_PKEY_derive
#  define _EVP_PKEY_derive OPENSSL_MANGLER_ASM(EVP_PKEY_derive)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_derive_init
#  define EVP_PKEY_derive_init OPENSSL_MANGLER(EVP_PKEY_derive_init)
# endif
#else
# ifndef _EVP_PKEY_derive_init
#  define _EVP_PKEY_derive_init OPENSSL_MANGLER_ASM(EVP_PKEY_derive_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_derive_set_peer
#  define EVP_PKEY_derive_set_peer OPENSSL_MANGLER(EVP_PKEY_derive_set_peer)
# endif
#else
# ifndef _EVP_PKEY_derive_set_peer
#  define _EVP_PKEY_derive_set_peer OPENSSL_MANGLER_ASM(EVP_PKEY_derive_set_peer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_encrypt
#  define EVP_PKEY_encrypt OPENSSL_MANGLER(EVP_PKEY_encrypt)
# endif
#else
# ifndef _EVP_PKEY_encrypt
#  define _EVP_PKEY_encrypt OPENSSL_MANGLER_ASM(EVP_PKEY_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_encrypt_init
#  define EVP_PKEY_encrypt_init OPENSSL_MANGLER(EVP_PKEY_encrypt_init)
# endif
#else
# ifndef _EVP_PKEY_encrypt_init
#  define _EVP_PKEY_encrypt_init OPENSSL_MANGLER_ASM(EVP_PKEY_encrypt_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_encrypt_old
#  define EVP_PKEY_encrypt_old OPENSSL_MANGLER(EVP_PKEY_encrypt_old)
# endif
#else
# ifndef _EVP_PKEY_encrypt_old
#  define _EVP_PKEY_encrypt_old OPENSSL_MANGLER_ASM(EVP_PKEY_encrypt_old)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_free
#  define EVP_PKEY_free OPENSSL_MANGLER(EVP_PKEY_free)
# endif
#else
# ifndef _EVP_PKEY_free
#  define _EVP_PKEY_free OPENSSL_MANGLER_ASM(EVP_PKEY_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get0
#  define EVP_PKEY_get0 OPENSSL_MANGLER(EVP_PKEY_get0)
# endif
#else
# ifndef _EVP_PKEY_get0
#  define _EVP_PKEY_get0 OPENSSL_MANGLER_ASM(EVP_PKEY_get0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get0_asn1
#  define EVP_PKEY_get0_asn1 OPENSSL_MANGLER(EVP_PKEY_get0_asn1)
# endif
#else
# ifndef _EVP_PKEY_get0_asn1
#  define _EVP_PKEY_get0_asn1 OPENSSL_MANGLER_ASM(EVP_PKEY_get0_asn1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get0_DH
#  define EVP_PKEY_get0_DH OPENSSL_MANGLER(EVP_PKEY_get0_DH)
# endif
#else
# ifndef _EVP_PKEY_get0_DH
#  define _EVP_PKEY_get0_DH OPENSSL_MANGLER_ASM(EVP_PKEY_get0_DH)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get0_DSA
#  define EVP_PKEY_get0_DSA OPENSSL_MANGLER(EVP_PKEY_get0_DSA)
# endif
#else
# ifndef _EVP_PKEY_get0_DSA
#  define _EVP_PKEY_get0_DSA OPENSSL_MANGLER_ASM(EVP_PKEY_get0_DSA)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get0_EC_KEY
#  define EVP_PKEY_get0_EC_KEY OPENSSL_MANGLER(EVP_PKEY_get0_EC_KEY)
# endif
#else
# ifndef _EVP_PKEY_get0_EC_KEY
#  define _EVP_PKEY_get0_EC_KEY OPENSSL_MANGLER_ASM(EVP_PKEY_get0_EC_KEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get0_hmac
#  define EVP_PKEY_get0_hmac OPENSSL_MANGLER(EVP_PKEY_get0_hmac)
# endif
#else
# ifndef _EVP_PKEY_get0_hmac
#  define _EVP_PKEY_get0_hmac OPENSSL_MANGLER_ASM(EVP_PKEY_get0_hmac)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get0_RSA
#  define EVP_PKEY_get0_RSA OPENSSL_MANGLER(EVP_PKEY_get0_RSA)
# endif
#else
# ifndef _EVP_PKEY_get0_RSA
#  define _EVP_PKEY_get0_RSA OPENSSL_MANGLER_ASM(EVP_PKEY_get0_RSA)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get0_siphash
#  define EVP_PKEY_get0_siphash OPENSSL_MANGLER(EVP_PKEY_get0_siphash)
# endif
#else
# ifndef _EVP_PKEY_get0_siphash
#  define _EVP_PKEY_get0_siphash OPENSSL_MANGLER_ASM(EVP_PKEY_get0_siphash)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get1_DH
#  define EVP_PKEY_get1_DH OPENSSL_MANGLER(EVP_PKEY_get1_DH)
# endif
#else
# ifndef _EVP_PKEY_get1_DH
#  define _EVP_PKEY_get1_DH OPENSSL_MANGLER_ASM(EVP_PKEY_get1_DH)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get1_DSA
#  define EVP_PKEY_get1_DSA OPENSSL_MANGLER(EVP_PKEY_get1_DSA)
# endif
#else
# ifndef _EVP_PKEY_get1_DSA
#  define _EVP_PKEY_get1_DSA OPENSSL_MANGLER_ASM(EVP_PKEY_get1_DSA)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get1_EC_KEY
#  define EVP_PKEY_get1_EC_KEY OPENSSL_MANGLER(EVP_PKEY_get1_EC_KEY)
# endif
#else
# ifndef _EVP_PKEY_get1_EC_KEY
#  define _EVP_PKEY_get1_EC_KEY OPENSSL_MANGLER_ASM(EVP_PKEY_get1_EC_KEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get1_RSA
#  define EVP_PKEY_get1_RSA OPENSSL_MANGLER(EVP_PKEY_get1_RSA)
# endif
#else
# ifndef _EVP_PKEY_get1_RSA
#  define _EVP_PKEY_get1_RSA OPENSSL_MANGLER_ASM(EVP_PKEY_get1_RSA)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get1_tls_encodedpoint
#  define EVP_PKEY_get1_tls_encodedpoint OPENSSL_MANGLER(EVP_PKEY_get1_tls_encodedpoint)
# endif
#else
# ifndef _EVP_PKEY_get1_tls_encodedpoint
#  define _EVP_PKEY_get1_tls_encodedpoint OPENSSL_MANGLER_ASM(EVP_PKEY_get1_tls_encodedpoint)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get_attr
#  define EVP_PKEY_get_attr OPENSSL_MANGLER(EVP_PKEY_get_attr)
# endif
#else
# ifndef _EVP_PKEY_get_attr
#  define _EVP_PKEY_get_attr OPENSSL_MANGLER_ASM(EVP_PKEY_get_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get_attr_by_NID
#  define EVP_PKEY_get_attr_by_NID OPENSSL_MANGLER(EVP_PKEY_get_attr_by_NID)
# endif
#else
# ifndef _EVP_PKEY_get_attr_by_NID
#  define _EVP_PKEY_get_attr_by_NID OPENSSL_MANGLER_ASM(EVP_PKEY_get_attr_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get_attr_by_OBJ
#  define EVP_PKEY_get_attr_by_OBJ OPENSSL_MANGLER(EVP_PKEY_get_attr_by_OBJ)
# endif
#else
# ifndef _EVP_PKEY_get_attr_by_OBJ
#  define _EVP_PKEY_get_attr_by_OBJ OPENSSL_MANGLER_ASM(EVP_PKEY_get_attr_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get_attr_count
#  define EVP_PKEY_get_attr_count OPENSSL_MANGLER(EVP_PKEY_get_attr_count)
# endif
#else
# ifndef _EVP_PKEY_get_attr_count
#  define _EVP_PKEY_get_attr_count OPENSSL_MANGLER_ASM(EVP_PKEY_get_attr_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get_default_digest_nid
#  define EVP_PKEY_get_default_digest_nid OPENSSL_MANGLER(EVP_PKEY_get_default_digest_nid)
# endif
#else
# ifndef _EVP_PKEY_get_default_digest_nid
#  define _EVP_PKEY_get_default_digest_nid OPENSSL_MANGLER_ASM(EVP_PKEY_get_default_digest_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get_raw_private_key
#  define EVP_PKEY_get_raw_private_key OPENSSL_MANGLER(EVP_PKEY_get_raw_private_key)
# endif
#else
# ifndef _EVP_PKEY_get_raw_private_key
#  define _EVP_PKEY_get_raw_private_key OPENSSL_MANGLER_ASM(EVP_PKEY_get_raw_private_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_get_raw_public_key
#  define EVP_PKEY_get_raw_public_key OPENSSL_MANGLER(EVP_PKEY_get_raw_public_key)
# endif
#else
# ifndef _EVP_PKEY_get_raw_public_key
#  define _EVP_PKEY_get_raw_public_key OPENSSL_MANGLER_ASM(EVP_PKEY_get_raw_public_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_id
#  define EVP_PKEY_id OPENSSL_MANGLER(EVP_PKEY_id)
# endif
#else
# ifndef _EVP_PKEY_id
#  define _EVP_PKEY_id OPENSSL_MANGLER_ASM(EVP_PKEY_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_keygen
#  define EVP_PKEY_keygen OPENSSL_MANGLER(EVP_PKEY_keygen)
# endif
#else
# ifndef _EVP_PKEY_keygen
#  define _EVP_PKEY_keygen OPENSSL_MANGLER_ASM(EVP_PKEY_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_keygen_init
#  define EVP_PKEY_keygen_init OPENSSL_MANGLER(EVP_PKEY_keygen_init)
# endif
#else
# ifndef _EVP_PKEY_keygen_init
#  define _EVP_PKEY_keygen_init OPENSSL_MANGLER_ASM(EVP_PKEY_keygen_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_add0
#  define EVP_PKEY_meth_add0 OPENSSL_MANGLER(EVP_PKEY_meth_add0)
# endif
#else
# ifndef _EVP_PKEY_meth_add0
#  define _EVP_PKEY_meth_add0 OPENSSL_MANGLER_ASM(EVP_PKEY_meth_add0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_copy
#  define EVP_PKEY_meth_copy OPENSSL_MANGLER(EVP_PKEY_meth_copy)
# endif
#else
# ifndef _EVP_PKEY_meth_copy
#  define _EVP_PKEY_meth_copy OPENSSL_MANGLER_ASM(EVP_PKEY_meth_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_find
#  define EVP_PKEY_meth_find OPENSSL_MANGLER(EVP_PKEY_meth_find)
# endif
#else
# ifndef _EVP_PKEY_meth_find
#  define _EVP_PKEY_meth_find OPENSSL_MANGLER_ASM(EVP_PKEY_meth_find)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_free
#  define EVP_PKEY_meth_free OPENSSL_MANGLER(EVP_PKEY_meth_free)
# endif
#else
# ifndef _EVP_PKEY_meth_free
#  define _EVP_PKEY_meth_free OPENSSL_MANGLER_ASM(EVP_PKEY_meth_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get0
#  define EVP_PKEY_meth_get0 OPENSSL_MANGLER(EVP_PKEY_meth_get0)
# endif
#else
# ifndef _EVP_PKEY_meth_get0
#  define _EVP_PKEY_meth_get0 OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get0_info
#  define EVP_PKEY_meth_get0_info OPENSSL_MANGLER(EVP_PKEY_meth_get0_info)
# endif
#else
# ifndef _EVP_PKEY_meth_get0_info
#  define _EVP_PKEY_meth_get0_info OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get0_info)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_check
#  define EVP_PKEY_meth_get_check OPENSSL_MANGLER(EVP_PKEY_meth_get_check)
# endif
#else
# ifndef _EVP_PKEY_meth_get_check
#  define _EVP_PKEY_meth_get_check OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_cleanup
#  define EVP_PKEY_meth_get_cleanup OPENSSL_MANGLER(EVP_PKEY_meth_get_cleanup)
# endif
#else
# ifndef _EVP_PKEY_meth_get_cleanup
#  define _EVP_PKEY_meth_get_cleanup OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_copy
#  define EVP_PKEY_meth_get_copy OPENSSL_MANGLER(EVP_PKEY_meth_get_copy)
# endif
#else
# ifndef _EVP_PKEY_meth_get_copy
#  define _EVP_PKEY_meth_get_copy OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_count
#  define EVP_PKEY_meth_get_count OPENSSL_MANGLER(EVP_PKEY_meth_get_count)
# endif
#else
# ifndef _EVP_PKEY_meth_get_count
#  define _EVP_PKEY_meth_get_count OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_ctrl
#  define EVP_PKEY_meth_get_ctrl OPENSSL_MANGLER(EVP_PKEY_meth_get_ctrl)
# endif
#else
# ifndef _EVP_PKEY_meth_get_ctrl
#  define _EVP_PKEY_meth_get_ctrl OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_decrypt
#  define EVP_PKEY_meth_get_decrypt OPENSSL_MANGLER(EVP_PKEY_meth_get_decrypt)
# endif
#else
# ifndef _EVP_PKEY_meth_get_decrypt
#  define _EVP_PKEY_meth_get_decrypt OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_derive
#  define EVP_PKEY_meth_get_derive OPENSSL_MANGLER(EVP_PKEY_meth_get_derive)
# endif
#else
# ifndef _EVP_PKEY_meth_get_derive
#  define _EVP_PKEY_meth_get_derive OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_derive)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_digest_custom
#  define EVP_PKEY_meth_get_digest_custom OPENSSL_MANGLER(EVP_PKEY_meth_get_digest_custom)
# endif
#else
# ifndef _EVP_PKEY_meth_get_digest_custom
#  define _EVP_PKEY_meth_get_digest_custom OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_digest_custom)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_encrypt
#  define EVP_PKEY_meth_get_encrypt OPENSSL_MANGLER(EVP_PKEY_meth_get_encrypt)
# endif
#else
# ifndef _EVP_PKEY_meth_get_encrypt
#  define _EVP_PKEY_meth_get_encrypt OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_init
#  define EVP_PKEY_meth_get_init OPENSSL_MANGLER(EVP_PKEY_meth_get_init)
# endif
#else
# ifndef _EVP_PKEY_meth_get_init
#  define _EVP_PKEY_meth_get_init OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_keygen
#  define EVP_PKEY_meth_get_keygen OPENSSL_MANGLER(EVP_PKEY_meth_get_keygen)
# endif
#else
# ifndef _EVP_PKEY_meth_get_keygen
#  define _EVP_PKEY_meth_get_keygen OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_param_check
#  define EVP_PKEY_meth_get_param_check OPENSSL_MANGLER(EVP_PKEY_meth_get_param_check)
# endif
#else
# ifndef _EVP_PKEY_meth_get_param_check
#  define _EVP_PKEY_meth_get_param_check OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_param_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_paramgen
#  define EVP_PKEY_meth_get_paramgen OPENSSL_MANGLER(EVP_PKEY_meth_get_paramgen)
# endif
#else
# ifndef _EVP_PKEY_meth_get_paramgen
#  define _EVP_PKEY_meth_get_paramgen OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_paramgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_public_check
#  define EVP_PKEY_meth_get_public_check OPENSSL_MANGLER(EVP_PKEY_meth_get_public_check)
# endif
#else
# ifndef _EVP_PKEY_meth_get_public_check
#  define _EVP_PKEY_meth_get_public_check OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_public_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_sign
#  define EVP_PKEY_meth_get_sign OPENSSL_MANGLER(EVP_PKEY_meth_get_sign)
# endif
#else
# ifndef _EVP_PKEY_meth_get_sign
#  define _EVP_PKEY_meth_get_sign OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_signctx
#  define EVP_PKEY_meth_get_signctx OPENSSL_MANGLER(EVP_PKEY_meth_get_signctx)
# endif
#else
# ifndef _EVP_PKEY_meth_get_signctx
#  define _EVP_PKEY_meth_get_signctx OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_signctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_verify
#  define EVP_PKEY_meth_get_verify OPENSSL_MANGLER(EVP_PKEY_meth_get_verify)
# endif
#else
# ifndef _EVP_PKEY_meth_get_verify
#  define _EVP_PKEY_meth_get_verify OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_verifyctx
#  define EVP_PKEY_meth_get_verifyctx OPENSSL_MANGLER(EVP_PKEY_meth_get_verifyctx)
# endif
#else
# ifndef _EVP_PKEY_meth_get_verifyctx
#  define _EVP_PKEY_meth_get_verifyctx OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_verifyctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_get_verify_recover
#  define EVP_PKEY_meth_get_verify_recover OPENSSL_MANGLER(EVP_PKEY_meth_get_verify_recover)
# endif
#else
# ifndef _EVP_PKEY_meth_get_verify_recover
#  define _EVP_PKEY_meth_get_verify_recover OPENSSL_MANGLER_ASM(EVP_PKEY_meth_get_verify_recover)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_new
#  define EVP_PKEY_meth_new OPENSSL_MANGLER(EVP_PKEY_meth_new)
# endif
#else
# ifndef _EVP_PKEY_meth_new
#  define _EVP_PKEY_meth_new OPENSSL_MANGLER_ASM(EVP_PKEY_meth_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_remove
#  define EVP_PKEY_meth_remove OPENSSL_MANGLER(EVP_PKEY_meth_remove)
# endif
#else
# ifndef _EVP_PKEY_meth_remove
#  define _EVP_PKEY_meth_remove OPENSSL_MANGLER_ASM(EVP_PKEY_meth_remove)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_check
#  define EVP_PKEY_meth_set_check OPENSSL_MANGLER(EVP_PKEY_meth_set_check)
# endif
#else
# ifndef _EVP_PKEY_meth_set_check
#  define _EVP_PKEY_meth_set_check OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_cleanup
#  define EVP_PKEY_meth_set_cleanup OPENSSL_MANGLER(EVP_PKEY_meth_set_cleanup)
# endif
#else
# ifndef _EVP_PKEY_meth_set_cleanup
#  define _EVP_PKEY_meth_set_cleanup OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_copy
#  define EVP_PKEY_meth_set_copy OPENSSL_MANGLER(EVP_PKEY_meth_set_copy)
# endif
#else
# ifndef _EVP_PKEY_meth_set_copy
#  define _EVP_PKEY_meth_set_copy OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_ctrl
#  define EVP_PKEY_meth_set_ctrl OPENSSL_MANGLER(EVP_PKEY_meth_set_ctrl)
# endif
#else
# ifndef _EVP_PKEY_meth_set_ctrl
#  define _EVP_PKEY_meth_set_ctrl OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_decrypt
#  define EVP_PKEY_meth_set_decrypt OPENSSL_MANGLER(EVP_PKEY_meth_set_decrypt)
# endif
#else
# ifndef _EVP_PKEY_meth_set_decrypt
#  define _EVP_PKEY_meth_set_decrypt OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_derive
#  define EVP_PKEY_meth_set_derive OPENSSL_MANGLER(EVP_PKEY_meth_set_derive)
# endif
#else
# ifndef _EVP_PKEY_meth_set_derive
#  define _EVP_PKEY_meth_set_derive OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_derive)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_digest_custom
#  define EVP_PKEY_meth_set_digest_custom OPENSSL_MANGLER(EVP_PKEY_meth_set_digest_custom)
# endif
#else
# ifndef _EVP_PKEY_meth_set_digest_custom
#  define _EVP_PKEY_meth_set_digest_custom OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_digest_custom)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_encrypt
#  define EVP_PKEY_meth_set_encrypt OPENSSL_MANGLER(EVP_PKEY_meth_set_encrypt)
# endif
#else
# ifndef _EVP_PKEY_meth_set_encrypt
#  define _EVP_PKEY_meth_set_encrypt OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_init
#  define EVP_PKEY_meth_set_init OPENSSL_MANGLER(EVP_PKEY_meth_set_init)
# endif
#else
# ifndef _EVP_PKEY_meth_set_init
#  define _EVP_PKEY_meth_set_init OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_keygen
#  define EVP_PKEY_meth_set_keygen OPENSSL_MANGLER(EVP_PKEY_meth_set_keygen)
# endif
#else
# ifndef _EVP_PKEY_meth_set_keygen
#  define _EVP_PKEY_meth_set_keygen OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_param_check
#  define EVP_PKEY_meth_set_param_check OPENSSL_MANGLER(EVP_PKEY_meth_set_param_check)
# endif
#else
# ifndef _EVP_PKEY_meth_set_param_check
#  define _EVP_PKEY_meth_set_param_check OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_param_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_paramgen
#  define EVP_PKEY_meth_set_paramgen OPENSSL_MANGLER(EVP_PKEY_meth_set_paramgen)
# endif
#else
# ifndef _EVP_PKEY_meth_set_paramgen
#  define _EVP_PKEY_meth_set_paramgen OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_paramgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_public_check
#  define EVP_PKEY_meth_set_public_check OPENSSL_MANGLER(EVP_PKEY_meth_set_public_check)
# endif
#else
# ifndef _EVP_PKEY_meth_set_public_check
#  define _EVP_PKEY_meth_set_public_check OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_public_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_sign
#  define EVP_PKEY_meth_set_sign OPENSSL_MANGLER(EVP_PKEY_meth_set_sign)
# endif
#else
# ifndef _EVP_PKEY_meth_set_sign
#  define _EVP_PKEY_meth_set_sign OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_signctx
#  define EVP_PKEY_meth_set_signctx OPENSSL_MANGLER(EVP_PKEY_meth_set_signctx)
# endif
#else
# ifndef _EVP_PKEY_meth_set_signctx
#  define _EVP_PKEY_meth_set_signctx OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_signctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_verify
#  define EVP_PKEY_meth_set_verify OPENSSL_MANGLER(EVP_PKEY_meth_set_verify)
# endif
#else
# ifndef _EVP_PKEY_meth_set_verify
#  define _EVP_PKEY_meth_set_verify OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_verifyctx
#  define EVP_PKEY_meth_set_verifyctx OPENSSL_MANGLER(EVP_PKEY_meth_set_verifyctx)
# endif
#else
# ifndef _EVP_PKEY_meth_set_verifyctx
#  define _EVP_PKEY_meth_set_verifyctx OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_verifyctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_meth_set_verify_recover
#  define EVP_PKEY_meth_set_verify_recover OPENSSL_MANGLER(EVP_PKEY_meth_set_verify_recover)
# endif
#else
# ifndef _EVP_PKEY_meth_set_verify_recover
#  define _EVP_PKEY_meth_set_verify_recover OPENSSL_MANGLER_ASM(EVP_PKEY_meth_set_verify_recover)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_missing_parameters
#  define EVP_PKEY_missing_parameters OPENSSL_MANGLER(EVP_PKEY_missing_parameters)
# endif
#else
# ifndef _EVP_PKEY_missing_parameters
#  define _EVP_PKEY_missing_parameters OPENSSL_MANGLER_ASM(EVP_PKEY_missing_parameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_new
#  define EVP_PKEY_new OPENSSL_MANGLER(EVP_PKEY_new)
# endif
#else
# ifndef _EVP_PKEY_new
#  define _EVP_PKEY_new OPENSSL_MANGLER_ASM(EVP_PKEY_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_new_CMAC_key
#  define EVP_PKEY_new_CMAC_key OPENSSL_MANGLER(EVP_PKEY_new_CMAC_key)
# endif
#else
# ifndef _EVP_PKEY_new_CMAC_key
#  define _EVP_PKEY_new_CMAC_key OPENSSL_MANGLER_ASM(EVP_PKEY_new_CMAC_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_new_mac_key
#  define EVP_PKEY_new_mac_key OPENSSL_MANGLER(EVP_PKEY_new_mac_key)
# endif
#else
# ifndef _EVP_PKEY_new_mac_key
#  define _EVP_PKEY_new_mac_key OPENSSL_MANGLER_ASM(EVP_PKEY_new_mac_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_new_raw_private_key
#  define EVP_PKEY_new_raw_private_key OPENSSL_MANGLER(EVP_PKEY_new_raw_private_key)
# endif
#else
# ifndef _EVP_PKEY_new_raw_private_key
#  define _EVP_PKEY_new_raw_private_key OPENSSL_MANGLER_ASM(EVP_PKEY_new_raw_private_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_new_raw_public_key
#  define EVP_PKEY_new_raw_public_key OPENSSL_MANGLER(EVP_PKEY_new_raw_public_key)
# endif
#else
# ifndef _EVP_PKEY_new_raw_public_key
#  define _EVP_PKEY_new_raw_public_key OPENSSL_MANGLER_ASM(EVP_PKEY_new_raw_public_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_param_check
#  define EVP_PKEY_param_check OPENSSL_MANGLER(EVP_PKEY_param_check)
# endif
#else
# ifndef _EVP_PKEY_param_check
#  define _EVP_PKEY_param_check OPENSSL_MANGLER_ASM(EVP_PKEY_param_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_paramgen
#  define EVP_PKEY_paramgen OPENSSL_MANGLER(EVP_PKEY_paramgen)
# endif
#else
# ifndef _EVP_PKEY_paramgen
#  define _EVP_PKEY_paramgen OPENSSL_MANGLER_ASM(EVP_PKEY_paramgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_paramgen_init
#  define EVP_PKEY_paramgen_init OPENSSL_MANGLER(EVP_PKEY_paramgen_init)
# endif
#else
# ifndef _EVP_PKEY_paramgen_init
#  define _EVP_PKEY_paramgen_init OPENSSL_MANGLER_ASM(EVP_PKEY_paramgen_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_print_params
#  define EVP_PKEY_print_params OPENSSL_MANGLER(EVP_PKEY_print_params)
# endif
#else
# ifndef _EVP_PKEY_print_params
#  define _EVP_PKEY_print_params OPENSSL_MANGLER_ASM(EVP_PKEY_print_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_print_private
#  define EVP_PKEY_print_private OPENSSL_MANGLER(EVP_PKEY_print_private)
# endif
#else
# ifndef _EVP_PKEY_print_private
#  define _EVP_PKEY_print_private OPENSSL_MANGLER_ASM(EVP_PKEY_print_private)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_print_public
#  define EVP_PKEY_print_public OPENSSL_MANGLER(EVP_PKEY_print_public)
# endif
#else
# ifndef _EVP_PKEY_print_public
#  define _EVP_PKEY_print_public OPENSSL_MANGLER_ASM(EVP_PKEY_print_public)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_public_check
#  define EVP_PKEY_public_check OPENSSL_MANGLER(EVP_PKEY_public_check)
# endif
#else
# ifndef _EVP_PKEY_public_check
#  define _EVP_PKEY_public_check OPENSSL_MANGLER_ASM(EVP_PKEY_public_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_save_parameters
#  define EVP_PKEY_save_parameters OPENSSL_MANGLER(EVP_PKEY_save_parameters)
# endif
#else
# ifndef _EVP_PKEY_save_parameters
#  define _EVP_PKEY_save_parameters OPENSSL_MANGLER_ASM(EVP_PKEY_save_parameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_security_bits
#  define EVP_PKEY_security_bits OPENSSL_MANGLER(EVP_PKEY_security_bits)
# endif
#else
# ifndef _EVP_PKEY_security_bits
#  define _EVP_PKEY_security_bits OPENSSL_MANGLER_ASM(EVP_PKEY_security_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_set1_DH
#  define EVP_PKEY_set1_DH OPENSSL_MANGLER(EVP_PKEY_set1_DH)
# endif
#else
# ifndef _EVP_PKEY_set1_DH
#  define _EVP_PKEY_set1_DH OPENSSL_MANGLER_ASM(EVP_PKEY_set1_DH)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_set1_DSA
#  define EVP_PKEY_set1_DSA OPENSSL_MANGLER(EVP_PKEY_set1_DSA)
# endif
#else
# ifndef _EVP_PKEY_set1_DSA
#  define _EVP_PKEY_set1_DSA OPENSSL_MANGLER_ASM(EVP_PKEY_set1_DSA)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_set1_EC_KEY
#  define EVP_PKEY_set1_EC_KEY OPENSSL_MANGLER(EVP_PKEY_set1_EC_KEY)
# endif
#else
# ifndef _EVP_PKEY_set1_EC_KEY
#  define _EVP_PKEY_set1_EC_KEY OPENSSL_MANGLER_ASM(EVP_PKEY_set1_EC_KEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_set1_RSA
#  define EVP_PKEY_set1_RSA OPENSSL_MANGLER(EVP_PKEY_set1_RSA)
# endif
#else
# ifndef _EVP_PKEY_set1_RSA
#  define _EVP_PKEY_set1_RSA OPENSSL_MANGLER_ASM(EVP_PKEY_set1_RSA)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_set1_tls_encodedpoint
#  define EVP_PKEY_set1_tls_encodedpoint OPENSSL_MANGLER(EVP_PKEY_set1_tls_encodedpoint)
# endif
#else
# ifndef _EVP_PKEY_set1_tls_encodedpoint
#  define _EVP_PKEY_set1_tls_encodedpoint OPENSSL_MANGLER_ASM(EVP_PKEY_set1_tls_encodedpoint)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_set_alias_type
#  define EVP_PKEY_set_alias_type OPENSSL_MANGLER(EVP_PKEY_set_alias_type)
# endif
#else
# ifndef _EVP_PKEY_set_alias_type
#  define _EVP_PKEY_set_alias_type OPENSSL_MANGLER_ASM(EVP_PKEY_set_alias_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef evp_pkey_set_cb_translate
#  define evp_pkey_set_cb_translate OPENSSL_MANGLER(evp_pkey_set_cb_translate)
# endif
#else
# ifndef _evp_pkey_set_cb_translate
#  define _evp_pkey_set_cb_translate OPENSSL_MANGLER_ASM(evp_pkey_set_cb_translate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_set_type
#  define EVP_PKEY_set_type OPENSSL_MANGLER(EVP_PKEY_set_type)
# endif
#else
# ifndef _EVP_PKEY_set_type
#  define _EVP_PKEY_set_type OPENSSL_MANGLER_ASM(EVP_PKEY_set_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_set_type_str
#  define EVP_PKEY_set_type_str OPENSSL_MANGLER(EVP_PKEY_set_type_str)
# endif
#else
# ifndef _EVP_PKEY_set_type_str
#  define _EVP_PKEY_set_type_str OPENSSL_MANGLER_ASM(EVP_PKEY_set_type_str)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_sign
#  define EVP_PKEY_sign OPENSSL_MANGLER(EVP_PKEY_sign)
# endif
#else
# ifndef _EVP_PKEY_sign
#  define _EVP_PKEY_sign OPENSSL_MANGLER_ASM(EVP_PKEY_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_sign_init
#  define EVP_PKEY_sign_init OPENSSL_MANGLER(EVP_PKEY_sign_init)
# endif
#else
# ifndef _EVP_PKEY_sign_init
#  define _EVP_PKEY_sign_init OPENSSL_MANGLER_ASM(EVP_PKEY_sign_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_size
#  define EVP_PKEY_size OPENSSL_MANGLER(EVP_PKEY_size)
# endif
#else
# ifndef _EVP_PKEY_size
#  define _EVP_PKEY_size OPENSSL_MANGLER_ASM(EVP_PKEY_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_type
#  define EVP_PKEY_type OPENSSL_MANGLER(EVP_PKEY_type)
# endif
#else
# ifndef _EVP_PKEY_type
#  define _EVP_PKEY_type OPENSSL_MANGLER_ASM(EVP_PKEY_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_up_ref
#  define EVP_PKEY_up_ref OPENSSL_MANGLER(EVP_PKEY_up_ref)
# endif
#else
# ifndef _EVP_PKEY_up_ref
#  define _EVP_PKEY_up_ref OPENSSL_MANGLER_ASM(EVP_PKEY_up_ref)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_verify
#  define EVP_PKEY_verify OPENSSL_MANGLER(EVP_PKEY_verify)
# endif
#else
# ifndef _EVP_PKEY_verify
#  define _EVP_PKEY_verify OPENSSL_MANGLER_ASM(EVP_PKEY_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_verify_init
#  define EVP_PKEY_verify_init OPENSSL_MANGLER(EVP_PKEY_verify_init)
# endif
#else
# ifndef _EVP_PKEY_verify_init
#  define _EVP_PKEY_verify_init OPENSSL_MANGLER_ASM(EVP_PKEY_verify_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_verify_recover
#  define EVP_PKEY_verify_recover OPENSSL_MANGLER(EVP_PKEY_verify_recover)
# endif
#else
# ifndef _EVP_PKEY_verify_recover
#  define _EVP_PKEY_verify_recover OPENSSL_MANGLER_ASM(EVP_PKEY_verify_recover)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_PKEY_verify_recover_init
#  define EVP_PKEY_verify_recover_init OPENSSL_MANGLER(EVP_PKEY_verify_recover_init)
# endif
#else
# ifndef _EVP_PKEY_verify_recover_init
#  define _EVP_PKEY_verify_recover_init OPENSSL_MANGLER_ASM(EVP_PKEY_verify_recover_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_rc4
#  define EVP_rc4 OPENSSL_MANGLER(EVP_rc4)
# endif
#else
# ifndef _EVP_rc4
#  define _EVP_rc4 OPENSSL_MANGLER_ASM(EVP_rc4)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_rc4_40
#  define EVP_rc4_40 OPENSSL_MANGLER(EVP_rc4_40)
# endif
#else
# ifndef _EVP_rc4_40
#  define _EVP_rc4_40 OPENSSL_MANGLER_ASM(EVP_rc4_40)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_rc4_hmac_md5
#  define EVP_rc4_hmac_md5 OPENSSL_MANGLER(EVP_rc4_hmac_md5)
# endif
#else
# ifndef _EVP_rc4_hmac_md5
#  define _EVP_rc4_hmac_md5 OPENSSL_MANGLER_ASM(EVP_rc4_hmac_md5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_read_pw_string
#  define EVP_read_pw_string OPENSSL_MANGLER(EVP_read_pw_string)
# endif
#else
# ifndef _EVP_read_pw_string
#  define _EVP_read_pw_string OPENSSL_MANGLER_ASM(EVP_read_pw_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_read_pw_string_min
#  define EVP_read_pw_string_min OPENSSL_MANGLER(EVP_read_pw_string_min)
# endif
#else
# ifndef _EVP_read_pw_string_min
#  define _EVP_read_pw_string_min OPENSSL_MANGLER_ASM(EVP_read_pw_string_min)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_SealFinal
#  define EVP_SealFinal OPENSSL_MANGLER(EVP_SealFinal)
# endif
#else
# ifndef _EVP_SealFinal
#  define _EVP_SealFinal OPENSSL_MANGLER_ASM(EVP_SealFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_SealInit
#  define EVP_SealInit OPENSSL_MANGLER(EVP_SealInit)
# endif
#else
# ifndef _EVP_SealInit
#  define _EVP_SealInit OPENSSL_MANGLER_ASM(EVP_SealInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_seed_cbc
#  define EVP_seed_cbc OPENSSL_MANGLER(EVP_seed_cbc)
# endif
#else
# ifndef _EVP_seed_cbc
#  define _EVP_seed_cbc OPENSSL_MANGLER_ASM(EVP_seed_cbc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_seed_cfb128
#  define EVP_seed_cfb128 OPENSSL_MANGLER(EVP_seed_cfb128)
# endif
#else
# ifndef _EVP_seed_cfb128
#  define _EVP_seed_cfb128 OPENSSL_MANGLER_ASM(EVP_seed_cfb128)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_seed_ecb
#  define EVP_seed_ecb OPENSSL_MANGLER(EVP_seed_ecb)
# endif
#else
# ifndef _EVP_seed_ecb
#  define _EVP_seed_ecb OPENSSL_MANGLER_ASM(EVP_seed_ecb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_seed_ofb
#  define EVP_seed_ofb OPENSSL_MANGLER(EVP_seed_ofb)
# endif
#else
# ifndef _EVP_seed_ofb
#  define _EVP_seed_ofb OPENSSL_MANGLER_ASM(EVP_seed_ofb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_set_pw_prompt
#  define EVP_set_pw_prompt OPENSSL_MANGLER(EVP_set_pw_prompt)
# endif
#else
# ifndef _EVP_set_pw_prompt
#  define _EVP_set_pw_prompt OPENSSL_MANGLER_ASM(EVP_set_pw_prompt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha1
#  define EVP_sha1 OPENSSL_MANGLER(EVP_sha1)
# endif
#else
# ifndef _EVP_sha1
#  define _EVP_sha1 OPENSSL_MANGLER_ASM(EVP_sha1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha224
#  define EVP_sha224 OPENSSL_MANGLER(EVP_sha224)
# endif
#else
# ifndef _EVP_sha224
#  define _EVP_sha224 OPENSSL_MANGLER_ASM(EVP_sha224)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha256
#  define EVP_sha256 OPENSSL_MANGLER(EVP_sha256)
# endif
#else
# ifndef _EVP_sha256
#  define _EVP_sha256 OPENSSL_MANGLER_ASM(EVP_sha256)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha3_224
#  define EVP_sha3_224 OPENSSL_MANGLER(EVP_sha3_224)
# endif
#else
# ifndef _EVP_sha3_224
#  define _EVP_sha3_224 OPENSSL_MANGLER_ASM(EVP_sha3_224)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha3_256
#  define EVP_sha3_256 OPENSSL_MANGLER(EVP_sha3_256)
# endif
#else
# ifndef _EVP_sha3_256
#  define _EVP_sha3_256 OPENSSL_MANGLER_ASM(EVP_sha3_256)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha3_384
#  define EVP_sha3_384 OPENSSL_MANGLER(EVP_sha3_384)
# endif
#else
# ifndef _EVP_sha3_384
#  define _EVP_sha3_384 OPENSSL_MANGLER_ASM(EVP_sha3_384)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha3_512
#  define EVP_sha3_512 OPENSSL_MANGLER(EVP_sha3_512)
# endif
#else
# ifndef _EVP_sha3_512
#  define _EVP_sha3_512 OPENSSL_MANGLER_ASM(EVP_sha3_512)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha384
#  define EVP_sha384 OPENSSL_MANGLER(EVP_sha384)
# endif
#else
# ifndef _EVP_sha384
#  define _EVP_sha384 OPENSSL_MANGLER_ASM(EVP_sha384)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha512
#  define EVP_sha512 OPENSSL_MANGLER(EVP_sha512)
# endif
#else
# ifndef _EVP_sha512
#  define _EVP_sha512 OPENSSL_MANGLER_ASM(EVP_sha512)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha512_224
#  define EVP_sha512_224 OPENSSL_MANGLER(EVP_sha512_224)
# endif
#else
# ifndef _EVP_sha512_224
#  define _EVP_sha512_224 OPENSSL_MANGLER_ASM(EVP_sha512_224)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sha512_256
#  define EVP_sha512_256 OPENSSL_MANGLER(EVP_sha512_256)
# endif
#else
# ifndef _EVP_sha512_256
#  define _EVP_sha512_256 OPENSSL_MANGLER_ASM(EVP_sha512_256)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_shake128
#  define EVP_shake128 OPENSSL_MANGLER(EVP_shake128)
# endif
#else
# ifndef _EVP_shake128
#  define _EVP_shake128 OPENSSL_MANGLER_ASM(EVP_shake128)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_shake256
#  define EVP_shake256 OPENSSL_MANGLER(EVP_shake256)
# endif
#else
# ifndef _EVP_shake256
#  define _EVP_shake256 OPENSSL_MANGLER_ASM(EVP_shake256)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_SignFinal
#  define EVP_SignFinal OPENSSL_MANGLER(EVP_SignFinal)
# endif
#else
# ifndef _EVP_SignFinal
#  define _EVP_SignFinal OPENSSL_MANGLER_ASM(EVP_SignFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sm3
#  define EVP_sm3 OPENSSL_MANGLER(EVP_sm3)
# endif
#else
# ifndef _EVP_sm3
#  define _EVP_sm3 OPENSSL_MANGLER_ASM(EVP_sm3)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sm4_cbc
#  define EVP_sm4_cbc OPENSSL_MANGLER(EVP_sm4_cbc)
# endif
#else
# ifndef _EVP_sm4_cbc
#  define _EVP_sm4_cbc OPENSSL_MANGLER_ASM(EVP_sm4_cbc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sm4_cfb128
#  define EVP_sm4_cfb128 OPENSSL_MANGLER(EVP_sm4_cfb128)
# endif
#else
# ifndef _EVP_sm4_cfb128
#  define _EVP_sm4_cfb128 OPENSSL_MANGLER_ASM(EVP_sm4_cfb128)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sm4_ctr
#  define EVP_sm4_ctr OPENSSL_MANGLER(EVP_sm4_ctr)
# endif
#else
# ifndef _EVP_sm4_ctr
#  define _EVP_sm4_ctr OPENSSL_MANGLER_ASM(EVP_sm4_ctr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sm4_ecb
#  define EVP_sm4_ecb OPENSSL_MANGLER(EVP_sm4_ecb)
# endif
#else
# ifndef _EVP_sm4_ecb
#  define _EVP_sm4_ecb OPENSSL_MANGLER_ASM(EVP_sm4_ecb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_sm4_ofb
#  define EVP_sm4_ofb OPENSSL_MANGLER(EVP_sm4_ofb)
# endif
#else
# ifndef _EVP_sm4_ofb
#  define _EVP_sm4_ofb OPENSSL_MANGLER_ASM(EVP_sm4_ofb)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EVP_VerifyFinal
#  define EVP_VerifyFinal OPENSSL_MANGLER(EVP_VerifyFinal)
# endif
#else
# ifndef _EVP_VerifyFinal
#  define _EVP_VerifyFinal OPENSSL_MANGLER_ASM(EVP_VerifyFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EXTENDED_KEY_USAGE_free
#  define EXTENDED_KEY_USAGE_free OPENSSL_MANGLER(EXTENDED_KEY_USAGE_free)
# endif
#else
# ifndef _EXTENDED_KEY_USAGE_free
#  define _EXTENDED_KEY_USAGE_free OPENSSL_MANGLER_ASM(EXTENDED_KEY_USAGE_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EXTENDED_KEY_USAGE_it
#  define EXTENDED_KEY_USAGE_it OPENSSL_MANGLER(EXTENDED_KEY_USAGE_it)
# endif
#else
# ifndef _EXTENDED_KEY_USAGE_it
#  define _EXTENDED_KEY_USAGE_it OPENSSL_MANGLER_ASM(EXTENDED_KEY_USAGE_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef EXTENDED_KEY_USAGE_new
#  define EXTENDED_KEY_USAGE_new OPENSSL_MANGLER(EXTENDED_KEY_USAGE_new)
# endif
#else
# ifndef _EXTENDED_KEY_USAGE_new
#  define _EXTENDED_KEY_USAGE_new OPENSSL_MANGLER_ASM(EXTENDED_KEY_USAGE_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef extension_is_relevant
#  define extension_is_relevant OPENSSL_MANGLER(extension_is_relevant)
# endif
#else
# ifndef _extension_is_relevant
#  define _extension_is_relevant OPENSSL_MANGLER_ASM(extension_is_relevant)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef FIPS_mode
#  define FIPS_mode OPENSSL_MANGLER(FIPS_mode)
# endif
#else
# ifndef _FIPS_mode
#  define _FIPS_mode OPENSSL_MANGLER_ASM(FIPS_mode)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef FIPS_mode_set
#  define FIPS_mode_set OPENSSL_MANGLER(FIPS_mode_set)
# endif
#else
# ifndef _FIPS_mode_set
#  define _FIPS_mode_set OPENSSL_MANGLER_ASM(FIPS_mode_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gcm_ghash_4bit
#  define gcm_ghash_4bit OPENSSL_MANGLER(gcm_ghash_4bit)
# endif
#else
# ifndef _gcm_ghash_4bit
#  define _gcm_ghash_4bit OPENSSL_MANGLER_ASM(gcm_ghash_4bit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gcm_ghash_avx
#  define gcm_ghash_avx OPENSSL_MANGLER(gcm_ghash_avx)
# endif
#else
# ifndef _gcm_ghash_avx
#  define _gcm_ghash_avx OPENSSL_MANGLER_ASM(gcm_ghash_avx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gcm_ghash_clmul
#  define gcm_ghash_clmul OPENSSL_MANGLER(gcm_ghash_clmul)
# endif
#else
# ifndef _gcm_ghash_clmul
#  define _gcm_ghash_clmul OPENSSL_MANGLER_ASM(gcm_ghash_clmul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gcm_gmult_4bit
#  define gcm_gmult_4bit OPENSSL_MANGLER(gcm_gmult_4bit)
# endif
#else
# ifndef _gcm_gmult_4bit
#  define _gcm_gmult_4bit OPENSSL_MANGLER_ASM(gcm_gmult_4bit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gcm_gmult_avx
#  define gcm_gmult_avx OPENSSL_MANGLER(gcm_gmult_avx)
# endif
#else
# ifndef _gcm_gmult_avx
#  define _gcm_gmult_avx OPENSSL_MANGLER_ASM(gcm_gmult_avx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gcm_gmult_clmul
#  define gcm_gmult_clmul OPENSSL_MANGLER(gcm_gmult_clmul)
# endif
#else
# ifndef _gcm_gmult_clmul
#  define _gcm_gmult_clmul OPENSSL_MANGLER_ASM(gcm_gmult_clmul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gcm_init_avx
#  define gcm_init_avx OPENSSL_MANGLER(gcm_init_avx)
# endif
#else
# ifndef _gcm_init_avx
#  define _gcm_init_avx OPENSSL_MANGLER_ASM(gcm_init_avx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gcm_init_clmul
#  define gcm_init_clmul OPENSSL_MANGLER(gcm_init_clmul)
# endif
#else
# ifndef _gcm_init_clmul
#  define _gcm_init_clmul OPENSSL_MANGLER_ASM(gcm_init_clmul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAME_cmp
#  define GENERAL_NAME_cmp OPENSSL_MANGLER(GENERAL_NAME_cmp)
# endif
#else
# ifndef _GENERAL_NAME_cmp
#  define _GENERAL_NAME_cmp OPENSSL_MANGLER_ASM(GENERAL_NAME_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAME_dup
#  define GENERAL_NAME_dup OPENSSL_MANGLER(GENERAL_NAME_dup)
# endif
#else
# ifndef _GENERAL_NAME_dup
#  define _GENERAL_NAME_dup OPENSSL_MANGLER_ASM(GENERAL_NAME_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAME_free
#  define GENERAL_NAME_free OPENSSL_MANGLER(GENERAL_NAME_free)
# endif
#else
# ifndef _GENERAL_NAME_free
#  define _GENERAL_NAME_free OPENSSL_MANGLER_ASM(GENERAL_NAME_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAME_get0_otherName
#  define GENERAL_NAME_get0_otherName OPENSSL_MANGLER(GENERAL_NAME_get0_otherName)
# endif
#else
# ifndef _GENERAL_NAME_get0_otherName
#  define _GENERAL_NAME_get0_otherName OPENSSL_MANGLER_ASM(GENERAL_NAME_get0_otherName)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAME_get0_value
#  define GENERAL_NAME_get0_value OPENSSL_MANGLER(GENERAL_NAME_get0_value)
# endif
#else
# ifndef _GENERAL_NAME_get0_value
#  define _GENERAL_NAME_get0_value OPENSSL_MANGLER_ASM(GENERAL_NAME_get0_value)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAME_it
#  define GENERAL_NAME_it OPENSSL_MANGLER(GENERAL_NAME_it)
# endif
#else
# ifndef _GENERAL_NAME_it
#  define _GENERAL_NAME_it OPENSSL_MANGLER_ASM(GENERAL_NAME_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAME_new
#  define GENERAL_NAME_new OPENSSL_MANGLER(GENERAL_NAME_new)
# endif
#else
# ifndef _GENERAL_NAME_new
#  define _GENERAL_NAME_new OPENSSL_MANGLER_ASM(GENERAL_NAME_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAME_print
#  define GENERAL_NAME_print OPENSSL_MANGLER(GENERAL_NAME_print)
# endif
#else
# ifndef _GENERAL_NAME_print
#  define _GENERAL_NAME_print OPENSSL_MANGLER_ASM(GENERAL_NAME_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAME_set0_othername
#  define GENERAL_NAME_set0_othername OPENSSL_MANGLER(GENERAL_NAME_set0_othername)
# endif
#else
# ifndef _GENERAL_NAME_set0_othername
#  define _GENERAL_NAME_set0_othername OPENSSL_MANGLER_ASM(GENERAL_NAME_set0_othername)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAME_set0_value
#  define GENERAL_NAME_set0_value OPENSSL_MANGLER(GENERAL_NAME_set0_value)
# endif
#else
# ifndef _GENERAL_NAME_set0_value
#  define _GENERAL_NAME_set0_value OPENSSL_MANGLER_ASM(GENERAL_NAME_set0_value)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAMES_free
#  define GENERAL_NAMES_free OPENSSL_MANGLER(GENERAL_NAMES_free)
# endif
#else
# ifndef _GENERAL_NAMES_free
#  define _GENERAL_NAMES_free OPENSSL_MANGLER_ASM(GENERAL_NAMES_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAMES_it
#  define GENERAL_NAMES_it OPENSSL_MANGLER(GENERAL_NAMES_it)
# endif
#else
# ifndef _GENERAL_NAMES_it
#  define _GENERAL_NAMES_it OPENSSL_MANGLER_ASM(GENERAL_NAMES_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_NAMES_new
#  define GENERAL_NAMES_new OPENSSL_MANGLER(GENERAL_NAMES_new)
# endif
#else
# ifndef _GENERAL_NAMES_new
#  define _GENERAL_NAMES_new OPENSSL_MANGLER_ASM(GENERAL_NAMES_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_SUBTREE_free
#  define GENERAL_SUBTREE_free OPENSSL_MANGLER(GENERAL_SUBTREE_free)
# endif
#else
# ifndef _GENERAL_SUBTREE_free
#  define _GENERAL_SUBTREE_free OPENSSL_MANGLER_ASM(GENERAL_SUBTREE_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_SUBTREE_it
#  define GENERAL_SUBTREE_it OPENSSL_MANGLER(GENERAL_SUBTREE_it)
# endif
#else
# ifndef _GENERAL_SUBTREE_it
#  define _GENERAL_SUBTREE_it OPENSSL_MANGLER_ASM(GENERAL_SUBTREE_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef GENERAL_SUBTREE_new
#  define GENERAL_SUBTREE_new OPENSSL_MANGLER(GENERAL_SUBTREE_new)
# endif
#else
# ifndef _GENERAL_SUBTREE_new
#  define _GENERAL_SUBTREE_new OPENSSL_MANGLER_ASM(GENERAL_SUBTREE_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef get_ca_names
#  define get_ca_names OPENSSL_MANGLER(get_ca_names)
# endif
#else
# ifndef _get_ca_names
#  define _get_ca_names OPENSSL_MANGLER_ASM(get_ca_names)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_add
#  define gf_add OPENSSL_MANGLER(gf_add)
# endif
#else
# ifndef _gf_add
#  define _gf_add OPENSSL_MANGLER_ASM(gf_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_deserialize
#  define gf_deserialize OPENSSL_MANGLER(gf_deserialize)
# endif
#else
# ifndef _gf_deserialize
#  define _gf_deserialize OPENSSL_MANGLER_ASM(gf_deserialize)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_eq
#  define gf_eq OPENSSL_MANGLER(gf_eq)
# endif
#else
# ifndef _gf_eq
#  define _gf_eq OPENSSL_MANGLER_ASM(gf_eq)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_hibit
#  define gf_hibit OPENSSL_MANGLER(gf_hibit)
# endif
#else
# ifndef _gf_hibit
#  define _gf_hibit OPENSSL_MANGLER_ASM(gf_hibit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_isr
#  define gf_isr OPENSSL_MANGLER(gf_isr)
# endif
#else
# ifndef _gf_isr
#  define _gf_isr OPENSSL_MANGLER_ASM(gf_isr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_lobit
#  define gf_lobit OPENSSL_MANGLER(gf_lobit)
# endif
#else
# ifndef _gf_lobit
#  define _gf_lobit OPENSSL_MANGLER_ASM(gf_lobit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_mul
#  define gf_mul OPENSSL_MANGLER(gf_mul)
# endif
#else
# ifndef _gf_mul
#  define _gf_mul OPENSSL_MANGLER_ASM(gf_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_mulw_unsigned
#  define gf_mulw_unsigned OPENSSL_MANGLER(gf_mulw_unsigned)
# endif
#else
# ifndef _gf_mulw_unsigned
#  define _gf_mulw_unsigned OPENSSL_MANGLER_ASM(gf_mulw_unsigned)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_serialize
#  define gf_serialize OPENSSL_MANGLER(gf_serialize)
# endif
#else
# ifndef _gf_serialize
#  define _gf_serialize OPENSSL_MANGLER_ASM(gf_serialize)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_sqr
#  define gf_sqr OPENSSL_MANGLER(gf_sqr)
# endif
#else
# ifndef _gf_sqr
#  define _gf_sqr OPENSSL_MANGLER_ASM(gf_sqr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_strong_reduce
#  define gf_strong_reduce OPENSSL_MANGLER(gf_strong_reduce)
# endif
#else
# ifndef _gf_strong_reduce
#  define _gf_strong_reduce OPENSSL_MANGLER_ASM(gf_strong_reduce)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef gf_sub
#  define gf_sub OPENSSL_MANGLER(gf_sub)
# endif
#else
# ifndef _gf_sub
#  define _gf_sub OPENSSL_MANGLER_ASM(gf_sub)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef hkdf_pkey_meth
#  define hkdf_pkey_meth OPENSSL_MANGLER(hkdf_pkey_meth)
# endif
#else
# ifndef _hkdf_pkey_meth
#  define _hkdf_pkey_meth OPENSSL_MANGLER_ASM(hkdf_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC
#  define HMAC OPENSSL_MANGLER(HMAC)
# endif
#else
# ifndef _HMAC
#  define _HMAC OPENSSL_MANGLER_ASM(HMAC)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef hmac_asn1_meth
#  define hmac_asn1_meth OPENSSL_MANGLER(hmac_asn1_meth)
# endif
#else
# ifndef _hmac_asn1_meth
#  define _hmac_asn1_meth OPENSSL_MANGLER_ASM(hmac_asn1_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_CTX_copy
#  define HMAC_CTX_copy OPENSSL_MANGLER(HMAC_CTX_copy)
# endif
#else
# ifndef _HMAC_CTX_copy
#  define _HMAC_CTX_copy OPENSSL_MANGLER_ASM(HMAC_CTX_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_CTX_free
#  define HMAC_CTX_free OPENSSL_MANGLER(HMAC_CTX_free)
# endif
#else
# ifndef _HMAC_CTX_free
#  define _HMAC_CTX_free OPENSSL_MANGLER_ASM(HMAC_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_CTX_get_md
#  define HMAC_CTX_get_md OPENSSL_MANGLER(HMAC_CTX_get_md)
# endif
#else
# ifndef _HMAC_CTX_get_md
#  define _HMAC_CTX_get_md OPENSSL_MANGLER_ASM(HMAC_CTX_get_md)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_CTX_new
#  define HMAC_CTX_new OPENSSL_MANGLER(HMAC_CTX_new)
# endif
#else
# ifndef _HMAC_CTX_new
#  define _HMAC_CTX_new OPENSSL_MANGLER_ASM(HMAC_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_CTX_reset
#  define HMAC_CTX_reset OPENSSL_MANGLER(HMAC_CTX_reset)
# endif
#else
# ifndef _HMAC_CTX_reset
#  define _HMAC_CTX_reset OPENSSL_MANGLER_ASM(HMAC_CTX_reset)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_CTX_set_flags
#  define HMAC_CTX_set_flags OPENSSL_MANGLER(HMAC_CTX_set_flags)
# endif
#else
# ifndef _HMAC_CTX_set_flags
#  define _HMAC_CTX_set_flags OPENSSL_MANGLER_ASM(HMAC_CTX_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_Final
#  define HMAC_Final OPENSSL_MANGLER(HMAC_Final)
# endif
#else
# ifndef _HMAC_Final
#  define _HMAC_Final OPENSSL_MANGLER_ASM(HMAC_Final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_Init
#  define HMAC_Init OPENSSL_MANGLER(HMAC_Init)
# endif
#else
# ifndef _HMAC_Init
#  define _HMAC_Init OPENSSL_MANGLER_ASM(HMAC_Init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_Init_ex
#  define HMAC_Init_ex OPENSSL_MANGLER(HMAC_Init_ex)
# endif
#else
# ifndef _HMAC_Init_ex
#  define _HMAC_Init_ex OPENSSL_MANGLER_ASM(HMAC_Init_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef hmac_pkey_meth
#  define hmac_pkey_meth OPENSSL_MANGLER(hmac_pkey_meth)
# endif
#else
# ifndef _hmac_pkey_meth
#  define _hmac_pkey_meth OPENSSL_MANGLER_ASM(hmac_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_size
#  define HMAC_size OPENSSL_MANGLER(HMAC_size)
# endif
#else
# ifndef _HMAC_size
#  define _HMAC_size OPENSSL_MANGLER_ASM(HMAC_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef HMAC_Update
#  define HMAC_Update OPENSSL_MANGLER(HMAC_Update)
# endif
#else
# ifndef _HMAC_Update
#  define _HMAC_Update OPENSSL_MANGLER_ASM(HMAC_Update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2a_ACCESS_DESCRIPTION
#  define i2a_ACCESS_DESCRIPTION OPENSSL_MANGLER(i2a_ACCESS_DESCRIPTION)
# endif
#else
# ifndef _i2a_ACCESS_DESCRIPTION
#  define _i2a_ACCESS_DESCRIPTION OPENSSL_MANGLER_ASM(i2a_ACCESS_DESCRIPTION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2a_ASN1_ENUMERATED
#  define i2a_ASN1_ENUMERATED OPENSSL_MANGLER(i2a_ASN1_ENUMERATED)
# endif
#else
# ifndef _i2a_ASN1_ENUMERATED
#  define _i2a_ASN1_ENUMERATED OPENSSL_MANGLER_ASM(i2a_ASN1_ENUMERATED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2a_ASN1_INTEGER
#  define i2a_ASN1_INTEGER OPENSSL_MANGLER(i2a_ASN1_INTEGER)
# endif
#else
# ifndef _i2a_ASN1_INTEGER
#  define _i2a_ASN1_INTEGER OPENSSL_MANGLER_ASM(i2a_ASN1_INTEGER)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2a_ASN1_OBJECT
#  define i2a_ASN1_OBJECT OPENSSL_MANGLER(i2a_ASN1_OBJECT)
# endif
#else
# ifndef _i2a_ASN1_OBJECT
#  define _i2a_ASN1_OBJECT OPENSSL_MANGLER_ASM(i2a_ASN1_OBJECT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2a_ASN1_STRING
#  define i2a_ASN1_STRING OPENSSL_MANGLER(i2a_ASN1_STRING)
# endif
#else
# ifndef _i2a_ASN1_STRING
#  define _i2a_ASN1_STRING OPENSSL_MANGLER_ASM(i2a_ASN1_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2b_PrivateKey_bio
#  define i2b_PrivateKey_bio OPENSSL_MANGLER(i2b_PrivateKey_bio)
# endif
#else
# ifndef _i2b_PrivateKey_bio
#  define _i2b_PrivateKey_bio OPENSSL_MANGLER_ASM(i2b_PrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2b_PublicKey_bio
#  define i2b_PublicKey_bio OPENSSL_MANGLER(i2b_PublicKey_bio)
# endif
#else
# ifndef _i2b_PublicKey_bio
#  define _i2b_PublicKey_bio OPENSSL_MANGLER_ASM(i2b_PublicKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2b_PVK_bio
#  define i2b_PVK_bio OPENSSL_MANGLER(i2b_PVK_bio)
# endif
#else
# ifndef _i2b_PVK_bio
#  define _i2b_PVK_bio OPENSSL_MANGLER_ASM(i2b_PVK_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2c_ASN1_BIT_STRING
#  define i2c_ASN1_BIT_STRING OPENSSL_MANGLER(i2c_ASN1_BIT_STRING)
# endif
#else
# ifndef _i2c_ASN1_BIT_STRING
#  define _i2c_ASN1_BIT_STRING OPENSSL_MANGLER_ASM(i2c_ASN1_BIT_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2c_ASN1_INTEGER
#  define i2c_ASN1_INTEGER OPENSSL_MANGLER(i2c_ASN1_INTEGER)
# endif
#else
# ifndef _i2c_ASN1_INTEGER
#  define _i2c_ASN1_INTEGER OPENSSL_MANGLER_ASM(i2c_ASN1_INTEGER)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2c_uint64_int
#  define i2c_uint64_int OPENSSL_MANGLER(i2c_uint64_int)
# endif
#else
# ifndef _i2c_uint64_int
#  define _i2c_uint64_int OPENSSL_MANGLER_ASM(i2c_uint64_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ACCESS_DESCRIPTION
#  define i2d_ACCESS_DESCRIPTION OPENSSL_MANGLER(i2d_ACCESS_DESCRIPTION)
# endif
#else
# ifndef _i2d_ACCESS_DESCRIPTION
#  define _i2d_ACCESS_DESCRIPTION OPENSSL_MANGLER_ASM(i2d_ACCESS_DESCRIPTION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ADMISSIONS
#  define i2d_ADMISSIONS OPENSSL_MANGLER(i2d_ADMISSIONS)
# endif
#else
# ifndef _i2d_ADMISSIONS
#  define _i2d_ADMISSIONS OPENSSL_MANGLER_ASM(i2d_ADMISSIONS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ADMISSION_SYNTAX
#  define i2d_ADMISSION_SYNTAX OPENSSL_MANGLER(i2d_ADMISSION_SYNTAX)
# endif
#else
# ifndef _i2d_ADMISSION_SYNTAX
#  define _i2d_ADMISSION_SYNTAX OPENSSL_MANGLER_ASM(i2d_ADMISSION_SYNTAX)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASIdentifierChoice
#  define i2d_ASIdentifierChoice OPENSSL_MANGLER(i2d_ASIdentifierChoice)
# endif
#else
# ifndef _i2d_ASIdentifierChoice
#  define _i2d_ASIdentifierChoice OPENSSL_MANGLER_ASM(i2d_ASIdentifierChoice)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASIdentifiers
#  define i2d_ASIdentifiers OPENSSL_MANGLER(i2d_ASIdentifiers)
# endif
#else
# ifndef _i2d_ASIdentifiers
#  define _i2d_ASIdentifiers OPENSSL_MANGLER_ASM(i2d_ASIdentifiers)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASIdOrRange
#  define i2d_ASIdOrRange OPENSSL_MANGLER(i2d_ASIdOrRange)
# endif
#else
# ifndef _i2d_ASIdOrRange
#  define _i2d_ASIdOrRange OPENSSL_MANGLER_ASM(i2d_ASIdOrRange)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_bio_stream
#  define i2d_ASN1_bio_stream OPENSSL_MANGLER(i2d_ASN1_bio_stream)
# endif
#else
# ifndef _i2d_ASN1_bio_stream
#  define _i2d_ASN1_bio_stream OPENSSL_MANGLER_ASM(i2d_ASN1_bio_stream)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_BIT_STRING
#  define i2d_ASN1_BIT_STRING OPENSSL_MANGLER(i2d_ASN1_BIT_STRING)
# endif
#else
# ifndef _i2d_ASN1_BIT_STRING
#  define _i2d_ASN1_BIT_STRING OPENSSL_MANGLER_ASM(i2d_ASN1_BIT_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_BMPSTRING
#  define i2d_ASN1_BMPSTRING OPENSSL_MANGLER(i2d_ASN1_BMPSTRING)
# endif
#else
# ifndef _i2d_ASN1_BMPSTRING
#  define _i2d_ASN1_BMPSTRING OPENSSL_MANGLER_ASM(i2d_ASN1_BMPSTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_ENUMERATED
#  define i2d_ASN1_ENUMERATED OPENSSL_MANGLER(i2d_ASN1_ENUMERATED)
# endif
#else
# ifndef _i2d_ASN1_ENUMERATED
#  define _i2d_ASN1_ENUMERATED OPENSSL_MANGLER_ASM(i2d_ASN1_ENUMERATED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_GENERALIZEDTIME
#  define i2d_ASN1_GENERALIZEDTIME OPENSSL_MANGLER(i2d_ASN1_GENERALIZEDTIME)
# endif
#else
# ifndef _i2d_ASN1_GENERALIZEDTIME
#  define _i2d_ASN1_GENERALIZEDTIME OPENSSL_MANGLER_ASM(i2d_ASN1_GENERALIZEDTIME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_GENERALSTRING
#  define i2d_ASN1_GENERALSTRING OPENSSL_MANGLER(i2d_ASN1_GENERALSTRING)
# endif
#else
# ifndef _i2d_ASN1_GENERALSTRING
#  define _i2d_ASN1_GENERALSTRING OPENSSL_MANGLER_ASM(i2d_ASN1_GENERALSTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_IA5STRING
#  define i2d_ASN1_IA5STRING OPENSSL_MANGLER(i2d_ASN1_IA5STRING)
# endif
#else
# ifndef _i2d_ASN1_IA5STRING
#  define _i2d_ASN1_IA5STRING OPENSSL_MANGLER_ASM(i2d_ASN1_IA5STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_INTEGER
#  define i2d_ASN1_INTEGER OPENSSL_MANGLER(i2d_ASN1_INTEGER)
# endif
#else
# ifndef _i2d_ASN1_INTEGER
#  define _i2d_ASN1_INTEGER OPENSSL_MANGLER_ASM(i2d_ASN1_INTEGER)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_NULL
#  define i2d_ASN1_NULL OPENSSL_MANGLER(i2d_ASN1_NULL)
# endif
#else
# ifndef _i2d_ASN1_NULL
#  define _i2d_ASN1_NULL OPENSSL_MANGLER_ASM(i2d_ASN1_NULL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_OBJECT
#  define i2d_ASN1_OBJECT OPENSSL_MANGLER(i2d_ASN1_OBJECT)
# endif
#else
# ifndef _i2d_ASN1_OBJECT
#  define _i2d_ASN1_OBJECT OPENSSL_MANGLER_ASM(i2d_ASN1_OBJECT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_OCTET_STRING
#  define i2d_ASN1_OCTET_STRING OPENSSL_MANGLER(i2d_ASN1_OCTET_STRING)
# endif
#else
# ifndef _i2d_ASN1_OCTET_STRING
#  define _i2d_ASN1_OCTET_STRING OPENSSL_MANGLER_ASM(i2d_ASN1_OCTET_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_PRINTABLE
#  define i2d_ASN1_PRINTABLE OPENSSL_MANGLER(i2d_ASN1_PRINTABLE)
# endif
#else
# ifndef _i2d_ASN1_PRINTABLE
#  define _i2d_ASN1_PRINTABLE OPENSSL_MANGLER_ASM(i2d_ASN1_PRINTABLE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_PRINTABLESTRING
#  define i2d_ASN1_PRINTABLESTRING OPENSSL_MANGLER(i2d_ASN1_PRINTABLESTRING)
# endif
#else
# ifndef _i2d_ASN1_PRINTABLESTRING
#  define _i2d_ASN1_PRINTABLESTRING OPENSSL_MANGLER_ASM(i2d_ASN1_PRINTABLESTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_SEQUENCE_ANY
#  define i2d_ASN1_SEQUENCE_ANY OPENSSL_MANGLER(i2d_ASN1_SEQUENCE_ANY)
# endif
#else
# ifndef _i2d_ASN1_SEQUENCE_ANY
#  define _i2d_ASN1_SEQUENCE_ANY OPENSSL_MANGLER_ASM(i2d_ASN1_SEQUENCE_ANY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_SET_ANY
#  define i2d_ASN1_SET_ANY OPENSSL_MANGLER(i2d_ASN1_SET_ANY)
# endif
#else
# ifndef _i2d_ASN1_SET_ANY
#  define _i2d_ASN1_SET_ANY OPENSSL_MANGLER_ASM(i2d_ASN1_SET_ANY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_T61STRING
#  define i2d_ASN1_T61STRING OPENSSL_MANGLER(i2d_ASN1_T61STRING)
# endif
#else
# ifndef _i2d_ASN1_T61STRING
#  define _i2d_ASN1_T61STRING OPENSSL_MANGLER_ASM(i2d_ASN1_T61STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_TIME
#  define i2d_ASN1_TIME OPENSSL_MANGLER(i2d_ASN1_TIME)
# endif
#else
# ifndef _i2d_ASN1_TIME
#  define _i2d_ASN1_TIME OPENSSL_MANGLER_ASM(i2d_ASN1_TIME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_TYPE
#  define i2d_ASN1_TYPE OPENSSL_MANGLER(i2d_ASN1_TYPE)
# endif
#else
# ifndef _i2d_ASN1_TYPE
#  define _i2d_ASN1_TYPE OPENSSL_MANGLER_ASM(i2d_ASN1_TYPE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_UNIVERSALSTRING
#  define i2d_ASN1_UNIVERSALSTRING OPENSSL_MANGLER(i2d_ASN1_UNIVERSALSTRING)
# endif
#else
# ifndef _i2d_ASN1_UNIVERSALSTRING
#  define _i2d_ASN1_UNIVERSALSTRING OPENSSL_MANGLER_ASM(i2d_ASN1_UNIVERSALSTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_UTCTIME
#  define i2d_ASN1_UTCTIME OPENSSL_MANGLER(i2d_ASN1_UTCTIME)
# endif
#else
# ifndef _i2d_ASN1_UTCTIME
#  define _i2d_ASN1_UTCTIME OPENSSL_MANGLER_ASM(i2d_ASN1_UTCTIME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_UTF8STRING
#  define i2d_ASN1_UTF8STRING OPENSSL_MANGLER(i2d_ASN1_UTF8STRING)
# endif
#else
# ifndef _i2d_ASN1_UTF8STRING
#  define _i2d_ASN1_UTF8STRING OPENSSL_MANGLER_ASM(i2d_ASN1_UTF8STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASN1_VISIBLESTRING
#  define i2d_ASN1_VISIBLESTRING OPENSSL_MANGLER(i2d_ASN1_VISIBLESTRING)
# endif
#else
# ifndef _i2d_ASN1_VISIBLESTRING
#  define _i2d_ASN1_VISIBLESTRING OPENSSL_MANGLER_ASM(i2d_ASN1_VISIBLESTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ASRange
#  define i2d_ASRange OPENSSL_MANGLER(i2d_ASRange)
# endif
#else
# ifndef _i2d_ASRange
#  define _i2d_ASRange OPENSSL_MANGLER_ASM(i2d_ASRange)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_AUTHORITY_INFO_ACCESS
#  define i2d_AUTHORITY_INFO_ACCESS OPENSSL_MANGLER(i2d_AUTHORITY_INFO_ACCESS)
# endif
#else
# ifndef _i2d_AUTHORITY_INFO_ACCESS
#  define _i2d_AUTHORITY_INFO_ACCESS OPENSSL_MANGLER_ASM(i2d_AUTHORITY_INFO_ACCESS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_AUTHORITY_KEYID
#  define i2d_AUTHORITY_KEYID OPENSSL_MANGLER(i2d_AUTHORITY_KEYID)
# endif
#else
# ifndef _i2d_AUTHORITY_KEYID
#  define _i2d_AUTHORITY_KEYID OPENSSL_MANGLER_ASM(i2d_AUTHORITY_KEYID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_BASIC_CONSTRAINTS
#  define i2d_BASIC_CONSTRAINTS OPENSSL_MANGLER(i2d_BASIC_CONSTRAINTS)
# endif
#else
# ifndef _i2d_BASIC_CONSTRAINTS
#  define _i2d_BASIC_CONSTRAINTS OPENSSL_MANGLER_ASM(i2d_BASIC_CONSTRAINTS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_CERTIFICATEPOLICIES
#  define i2d_CERTIFICATEPOLICIES OPENSSL_MANGLER(i2d_CERTIFICATEPOLICIES)
# endif
#else
# ifndef _i2d_CERTIFICATEPOLICIES
#  define _i2d_CERTIFICATEPOLICIES OPENSSL_MANGLER_ASM(i2d_CERTIFICATEPOLICIES)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_CMS_bio
#  define i2d_CMS_bio OPENSSL_MANGLER(i2d_CMS_bio)
# endif
#else
# ifndef _i2d_CMS_bio
#  define _i2d_CMS_bio OPENSSL_MANGLER_ASM(i2d_CMS_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_CMS_bio_stream
#  define i2d_CMS_bio_stream OPENSSL_MANGLER(i2d_CMS_bio_stream)
# endif
#else
# ifndef _i2d_CMS_bio_stream
#  define _i2d_CMS_bio_stream OPENSSL_MANGLER_ASM(i2d_CMS_bio_stream)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_CMS_ContentInfo
#  define i2d_CMS_ContentInfo OPENSSL_MANGLER(i2d_CMS_ContentInfo)
# endif
#else
# ifndef _i2d_CMS_ContentInfo
#  define _i2d_CMS_ContentInfo OPENSSL_MANGLER_ASM(i2d_CMS_ContentInfo)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_CMS_ReceiptRequest
#  define i2d_CMS_ReceiptRequest OPENSSL_MANGLER(i2d_CMS_ReceiptRequest)
# endif
#else
# ifndef _i2d_CMS_ReceiptRequest
#  define _i2d_CMS_ReceiptRequest OPENSSL_MANGLER_ASM(i2d_CMS_ReceiptRequest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_CRL_DIST_POINTS
#  define i2d_CRL_DIST_POINTS OPENSSL_MANGLER(i2d_CRL_DIST_POINTS)
# endif
#else
# ifndef _i2d_CRL_DIST_POINTS
#  define _i2d_CRL_DIST_POINTS OPENSSL_MANGLER_ASM(i2d_CRL_DIST_POINTS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DHparams
#  define i2d_DHparams OPENSSL_MANGLER(i2d_DHparams)
# endif
#else
# ifndef _i2d_DHparams
#  define _i2d_DHparams OPENSSL_MANGLER_ASM(i2d_DHparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DHxparams
#  define i2d_DHxparams OPENSSL_MANGLER(i2d_DHxparams)
# endif
#else
# ifndef _i2d_DHxparams
#  define _i2d_DHxparams OPENSSL_MANGLER_ASM(i2d_DHxparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DIRECTORYSTRING
#  define i2d_DIRECTORYSTRING OPENSSL_MANGLER(i2d_DIRECTORYSTRING)
# endif
#else
# ifndef _i2d_DIRECTORYSTRING
#  define _i2d_DIRECTORYSTRING OPENSSL_MANGLER_ASM(i2d_DIRECTORYSTRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DISPLAYTEXT
#  define i2d_DISPLAYTEXT OPENSSL_MANGLER(i2d_DISPLAYTEXT)
# endif
#else
# ifndef _i2d_DISPLAYTEXT
#  define _i2d_DISPLAYTEXT OPENSSL_MANGLER_ASM(i2d_DISPLAYTEXT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DIST_POINT
#  define i2d_DIST_POINT OPENSSL_MANGLER(i2d_DIST_POINT)
# endif
#else
# ifndef _i2d_DIST_POINT
#  define _i2d_DIST_POINT OPENSSL_MANGLER_ASM(i2d_DIST_POINT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DIST_POINT_NAME
#  define i2d_DIST_POINT_NAME OPENSSL_MANGLER(i2d_DIST_POINT_NAME)
# endif
#else
# ifndef _i2d_DIST_POINT_NAME
#  define _i2d_DIST_POINT_NAME OPENSSL_MANGLER_ASM(i2d_DIST_POINT_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DSAparams
#  define i2d_DSAparams OPENSSL_MANGLER(i2d_DSAparams)
# endif
#else
# ifndef _i2d_DSAparams
#  define _i2d_DSAparams OPENSSL_MANGLER_ASM(i2d_DSAparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DSAPrivateKey
#  define i2d_DSAPrivateKey OPENSSL_MANGLER(i2d_DSAPrivateKey)
# endif
#else
# ifndef _i2d_DSAPrivateKey
#  define _i2d_DSAPrivateKey OPENSSL_MANGLER_ASM(i2d_DSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DSAPrivateKey_bio
#  define i2d_DSAPrivateKey_bio OPENSSL_MANGLER(i2d_DSAPrivateKey_bio)
# endif
#else
# ifndef _i2d_DSAPrivateKey_bio
#  define _i2d_DSAPrivateKey_bio OPENSSL_MANGLER_ASM(i2d_DSAPrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DSAPrivateKey_fp
#  define i2d_DSAPrivateKey_fp OPENSSL_MANGLER(i2d_DSAPrivateKey_fp)
# endif
#else
# ifndef _i2d_DSAPrivateKey_fp
#  define _i2d_DSAPrivateKey_fp OPENSSL_MANGLER_ASM(i2d_DSAPrivateKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DSA_PUBKEY
#  define i2d_DSA_PUBKEY OPENSSL_MANGLER(i2d_DSA_PUBKEY)
# endif
#else
# ifndef _i2d_DSA_PUBKEY
#  define _i2d_DSA_PUBKEY OPENSSL_MANGLER_ASM(i2d_DSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DSA_PUBKEY_bio
#  define i2d_DSA_PUBKEY_bio OPENSSL_MANGLER(i2d_DSA_PUBKEY_bio)
# endif
#else
# ifndef _i2d_DSA_PUBKEY_bio
#  define _i2d_DSA_PUBKEY_bio OPENSSL_MANGLER_ASM(i2d_DSA_PUBKEY_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DSA_PUBKEY_fp
#  define i2d_DSA_PUBKEY_fp OPENSSL_MANGLER(i2d_DSA_PUBKEY_fp)
# endif
#else
# ifndef _i2d_DSA_PUBKEY_fp
#  define _i2d_DSA_PUBKEY_fp OPENSSL_MANGLER_ASM(i2d_DSA_PUBKEY_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DSAPublicKey
#  define i2d_DSAPublicKey OPENSSL_MANGLER(i2d_DSAPublicKey)
# endif
#else
# ifndef _i2d_DSAPublicKey
#  define _i2d_DSAPublicKey OPENSSL_MANGLER_ASM(i2d_DSAPublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_DSA_SIG
#  define i2d_DSA_SIG OPENSSL_MANGLER(i2d_DSA_SIG)
# endif
#else
# ifndef _i2d_DSA_SIG
#  define _i2d_DSA_SIG OPENSSL_MANGLER_ASM(i2d_DSA_SIG)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ECDSA_SIG
#  define i2d_ECDSA_SIG OPENSSL_MANGLER(i2d_ECDSA_SIG)
# endif
#else
# ifndef _i2d_ECDSA_SIG
#  define _i2d_ECDSA_SIG OPENSSL_MANGLER_ASM(i2d_ECDSA_SIG)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ECParameters
#  define i2d_ECParameters OPENSSL_MANGLER(i2d_ECParameters)
# endif
#else
# ifndef _i2d_ECParameters
#  define _i2d_ECParameters OPENSSL_MANGLER_ASM(i2d_ECParameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ECPKParameters
#  define i2d_ECPKParameters OPENSSL_MANGLER(i2d_ECPKParameters)
# endif
#else
# ifndef _i2d_ECPKParameters
#  define _i2d_ECPKParameters OPENSSL_MANGLER_ASM(i2d_ECPKParameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ECPKPARAMETERS
#  define i2d_ECPKPARAMETERS OPENSSL_MANGLER(i2d_ECPKPARAMETERS)
# endif
#else
# ifndef _i2d_ECPKPARAMETERS
#  define _i2d_ECPKPARAMETERS OPENSSL_MANGLER_ASM(i2d_ECPKPARAMETERS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ECPrivateKey
#  define i2d_ECPrivateKey OPENSSL_MANGLER(i2d_ECPrivateKey)
# endif
#else
# ifndef _i2d_ECPrivateKey
#  define _i2d_ECPrivateKey OPENSSL_MANGLER_ASM(i2d_ECPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_EC_PRIVATEKEY
#  define i2d_EC_PRIVATEKEY OPENSSL_MANGLER(i2d_EC_PRIVATEKEY)
# endif
#else
# ifndef _i2d_EC_PRIVATEKEY
#  define _i2d_EC_PRIVATEKEY OPENSSL_MANGLER_ASM(i2d_EC_PRIVATEKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ECPrivateKey_bio
#  define i2d_ECPrivateKey_bio OPENSSL_MANGLER(i2d_ECPrivateKey_bio)
# endif
#else
# ifndef _i2d_ECPrivateKey_bio
#  define _i2d_ECPrivateKey_bio OPENSSL_MANGLER_ASM(i2d_ECPrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ECPrivateKey_fp
#  define i2d_ECPrivateKey_fp OPENSSL_MANGLER(i2d_ECPrivateKey_fp)
# endif
#else
# ifndef _i2d_ECPrivateKey_fp
#  define _i2d_ECPrivateKey_fp OPENSSL_MANGLER_ASM(i2d_ECPrivateKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_EC_PUBKEY
#  define i2d_EC_PUBKEY OPENSSL_MANGLER(i2d_EC_PUBKEY)
# endif
#else
# ifndef _i2d_EC_PUBKEY
#  define _i2d_EC_PUBKEY OPENSSL_MANGLER_ASM(i2d_EC_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_EC_PUBKEY_bio
#  define i2d_EC_PUBKEY_bio OPENSSL_MANGLER(i2d_EC_PUBKEY_bio)
# endif
#else
# ifndef _i2d_EC_PUBKEY_bio
#  define _i2d_EC_PUBKEY_bio OPENSSL_MANGLER_ASM(i2d_EC_PUBKEY_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_EC_PUBKEY_fp
#  define i2d_EC_PUBKEY_fp OPENSSL_MANGLER(i2d_EC_PUBKEY_fp)
# endif
#else
# ifndef _i2d_EC_PUBKEY_fp
#  define _i2d_EC_PUBKEY_fp OPENSSL_MANGLER_ASM(i2d_EC_PUBKEY_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_EDIPARTYNAME
#  define i2d_EDIPARTYNAME OPENSSL_MANGLER(i2d_EDIPARTYNAME)
# endif
#else
# ifndef _i2d_EDIPARTYNAME
#  define _i2d_EDIPARTYNAME OPENSSL_MANGLER_ASM(i2d_EDIPARTYNAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ESS_CERT_ID
#  define i2d_ESS_CERT_ID OPENSSL_MANGLER(i2d_ESS_CERT_ID)
# endif
#else
# ifndef _i2d_ESS_CERT_ID
#  define _i2d_ESS_CERT_ID OPENSSL_MANGLER_ASM(i2d_ESS_CERT_ID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ESS_CERT_ID_V2
#  define i2d_ESS_CERT_ID_V2 OPENSSL_MANGLER(i2d_ESS_CERT_ID_V2)
# endif
#else
# ifndef _i2d_ESS_CERT_ID_V2
#  define _i2d_ESS_CERT_ID_V2 OPENSSL_MANGLER_ASM(i2d_ESS_CERT_ID_V2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ESS_ISSUER_SERIAL
#  define i2d_ESS_ISSUER_SERIAL OPENSSL_MANGLER(i2d_ESS_ISSUER_SERIAL)
# endif
#else
# ifndef _i2d_ESS_ISSUER_SERIAL
#  define _i2d_ESS_ISSUER_SERIAL OPENSSL_MANGLER_ASM(i2d_ESS_ISSUER_SERIAL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ESS_SIGNING_CERT
#  define i2d_ESS_SIGNING_CERT OPENSSL_MANGLER(i2d_ESS_SIGNING_CERT)
# endif
#else
# ifndef _i2d_ESS_SIGNING_CERT
#  define _i2d_ESS_SIGNING_CERT OPENSSL_MANGLER_ASM(i2d_ESS_SIGNING_CERT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ESS_SIGNING_CERT_V2
#  define i2d_ESS_SIGNING_CERT_V2 OPENSSL_MANGLER(i2d_ESS_SIGNING_CERT_V2)
# endif
#else
# ifndef _i2d_ESS_SIGNING_CERT_V2
#  define _i2d_ESS_SIGNING_CERT_V2 OPENSSL_MANGLER_ASM(i2d_ESS_SIGNING_CERT_V2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_EXTENDED_KEY_USAGE
#  define i2d_EXTENDED_KEY_USAGE OPENSSL_MANGLER(i2d_EXTENDED_KEY_USAGE)
# endif
#else
# ifndef _i2d_EXTENDED_KEY_USAGE
#  define _i2d_EXTENDED_KEY_USAGE OPENSSL_MANGLER_ASM(i2d_EXTENDED_KEY_USAGE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_GENERAL_NAME
#  define i2d_GENERAL_NAME OPENSSL_MANGLER(i2d_GENERAL_NAME)
# endif
#else
# ifndef _i2d_GENERAL_NAME
#  define _i2d_GENERAL_NAME OPENSSL_MANGLER_ASM(i2d_GENERAL_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_GENERAL_NAMES
#  define i2d_GENERAL_NAMES OPENSSL_MANGLER(i2d_GENERAL_NAMES)
# endif
#else
# ifndef _i2d_GENERAL_NAMES
#  define _i2d_GENERAL_NAMES OPENSSL_MANGLER_ASM(i2d_GENERAL_NAMES)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_int_dhx
#  define i2d_int_dhx OPENSSL_MANGLER(i2d_int_dhx)
# endif
#else
# ifndef _i2d_int_dhx
#  define _i2d_int_dhx OPENSSL_MANGLER_ASM(i2d_int_dhx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_IPAddressChoice
#  define i2d_IPAddressChoice OPENSSL_MANGLER(i2d_IPAddressChoice)
# endif
#else
# ifndef _i2d_IPAddressChoice
#  define _i2d_IPAddressChoice OPENSSL_MANGLER_ASM(i2d_IPAddressChoice)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_IPAddressFamily
#  define i2d_IPAddressFamily OPENSSL_MANGLER(i2d_IPAddressFamily)
# endif
#else
# ifndef _i2d_IPAddressFamily
#  define _i2d_IPAddressFamily OPENSSL_MANGLER_ASM(i2d_IPAddressFamily)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_IPAddressOrRange
#  define i2d_IPAddressOrRange OPENSSL_MANGLER(i2d_IPAddressOrRange)
# endif
#else
# ifndef _i2d_IPAddressOrRange
#  define _i2d_IPAddressOrRange OPENSSL_MANGLER_ASM(i2d_IPAddressOrRange)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_IPAddressRange
#  define i2d_IPAddressRange OPENSSL_MANGLER(i2d_IPAddressRange)
# endif
#else
# ifndef _i2d_IPAddressRange
#  define _i2d_IPAddressRange OPENSSL_MANGLER_ASM(i2d_IPAddressRange)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_ISSUING_DIST_POINT
#  define i2d_ISSUING_DIST_POINT OPENSSL_MANGLER(i2d_ISSUING_DIST_POINT)
# endif
#else
# ifndef _i2d_ISSUING_DIST_POINT
#  define _i2d_ISSUING_DIST_POINT OPENSSL_MANGLER_ASM(i2d_ISSUING_DIST_POINT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_NAMING_AUTHORITY
#  define i2d_NAMING_AUTHORITY OPENSSL_MANGLER(i2d_NAMING_AUTHORITY)
# endif
#else
# ifndef _i2d_NAMING_AUTHORITY
#  define _i2d_NAMING_AUTHORITY OPENSSL_MANGLER_ASM(i2d_NAMING_AUTHORITY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_NETSCAPE_CERT_SEQUENCE
#  define i2d_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER(i2d_NETSCAPE_CERT_SEQUENCE)
# endif
#else
# ifndef _i2d_NETSCAPE_CERT_SEQUENCE
#  define _i2d_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER_ASM(i2d_NETSCAPE_CERT_SEQUENCE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_NETSCAPE_ENCRYPTED_PKEY
#  define i2d_NETSCAPE_ENCRYPTED_PKEY OPENSSL_MANGLER(i2d_NETSCAPE_ENCRYPTED_PKEY)
# endif
#else
# ifndef _i2d_NETSCAPE_ENCRYPTED_PKEY
#  define _i2d_NETSCAPE_ENCRYPTED_PKEY OPENSSL_MANGLER_ASM(i2d_NETSCAPE_ENCRYPTED_PKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_NETSCAPE_PKEY
#  define i2d_NETSCAPE_PKEY OPENSSL_MANGLER(i2d_NETSCAPE_PKEY)
# endif
#else
# ifndef _i2d_NETSCAPE_PKEY
#  define _i2d_NETSCAPE_PKEY OPENSSL_MANGLER_ASM(i2d_NETSCAPE_PKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_NETSCAPE_SPKAC
#  define i2d_NETSCAPE_SPKAC OPENSSL_MANGLER(i2d_NETSCAPE_SPKAC)
# endif
#else
# ifndef _i2d_NETSCAPE_SPKAC
#  define _i2d_NETSCAPE_SPKAC OPENSSL_MANGLER_ASM(i2d_NETSCAPE_SPKAC)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_NETSCAPE_SPKI
#  define i2d_NETSCAPE_SPKI OPENSSL_MANGLER(i2d_NETSCAPE_SPKI)
# endif
#else
# ifndef _i2d_NETSCAPE_SPKI
#  define _i2d_NETSCAPE_SPKI OPENSSL_MANGLER_ASM(i2d_NETSCAPE_SPKI)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_NOTICEREF
#  define i2d_NOTICEREF OPENSSL_MANGLER(i2d_NOTICEREF)
# endif
#else
# ifndef _i2d_NOTICEREF
#  define _i2d_NOTICEREF OPENSSL_MANGLER_ASM(i2d_NOTICEREF)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_BASICRESP
#  define i2d_OCSP_BASICRESP OPENSSL_MANGLER(i2d_OCSP_BASICRESP)
# endif
#else
# ifndef _i2d_OCSP_BASICRESP
#  define _i2d_OCSP_BASICRESP OPENSSL_MANGLER_ASM(i2d_OCSP_BASICRESP)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_CERTID
#  define i2d_OCSP_CERTID OPENSSL_MANGLER(i2d_OCSP_CERTID)
# endif
#else
# ifndef _i2d_OCSP_CERTID
#  define _i2d_OCSP_CERTID OPENSSL_MANGLER_ASM(i2d_OCSP_CERTID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_CERTSTATUS
#  define i2d_OCSP_CERTSTATUS OPENSSL_MANGLER(i2d_OCSP_CERTSTATUS)
# endif
#else
# ifndef _i2d_OCSP_CERTSTATUS
#  define _i2d_OCSP_CERTSTATUS OPENSSL_MANGLER_ASM(i2d_OCSP_CERTSTATUS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_CRLID
#  define i2d_OCSP_CRLID OPENSSL_MANGLER(i2d_OCSP_CRLID)
# endif
#else
# ifndef _i2d_OCSP_CRLID
#  define _i2d_OCSP_CRLID OPENSSL_MANGLER_ASM(i2d_OCSP_CRLID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_ONEREQ
#  define i2d_OCSP_ONEREQ OPENSSL_MANGLER(i2d_OCSP_ONEREQ)
# endif
#else
# ifndef _i2d_OCSP_ONEREQ
#  define _i2d_OCSP_ONEREQ OPENSSL_MANGLER_ASM(i2d_OCSP_ONEREQ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_REQINFO
#  define i2d_OCSP_REQINFO OPENSSL_MANGLER(i2d_OCSP_REQINFO)
# endif
#else
# ifndef _i2d_OCSP_REQINFO
#  define _i2d_OCSP_REQINFO OPENSSL_MANGLER_ASM(i2d_OCSP_REQINFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_REQUEST
#  define i2d_OCSP_REQUEST OPENSSL_MANGLER(i2d_OCSP_REQUEST)
# endif
#else
# ifndef _i2d_OCSP_REQUEST
#  define _i2d_OCSP_REQUEST OPENSSL_MANGLER_ASM(i2d_OCSP_REQUEST)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_RESPBYTES
#  define i2d_OCSP_RESPBYTES OPENSSL_MANGLER(i2d_OCSP_RESPBYTES)
# endif
#else
# ifndef _i2d_OCSP_RESPBYTES
#  define _i2d_OCSP_RESPBYTES OPENSSL_MANGLER_ASM(i2d_OCSP_RESPBYTES)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_RESPDATA
#  define i2d_OCSP_RESPDATA OPENSSL_MANGLER(i2d_OCSP_RESPDATA)
# endif
#else
# ifndef _i2d_OCSP_RESPDATA
#  define _i2d_OCSP_RESPDATA OPENSSL_MANGLER_ASM(i2d_OCSP_RESPDATA)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_RESPID
#  define i2d_OCSP_RESPID OPENSSL_MANGLER(i2d_OCSP_RESPID)
# endif
#else
# ifndef _i2d_OCSP_RESPID
#  define _i2d_OCSP_RESPID OPENSSL_MANGLER_ASM(i2d_OCSP_RESPID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_RESPONSE
#  define i2d_OCSP_RESPONSE OPENSSL_MANGLER(i2d_OCSP_RESPONSE)
# endif
#else
# ifndef _i2d_OCSP_RESPONSE
#  define _i2d_OCSP_RESPONSE OPENSSL_MANGLER_ASM(i2d_OCSP_RESPONSE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_REVOKEDINFO
#  define i2d_OCSP_REVOKEDINFO OPENSSL_MANGLER(i2d_OCSP_REVOKEDINFO)
# endif
#else
# ifndef _i2d_OCSP_REVOKEDINFO
#  define _i2d_OCSP_REVOKEDINFO OPENSSL_MANGLER_ASM(i2d_OCSP_REVOKEDINFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_SERVICELOC
#  define i2d_OCSP_SERVICELOC OPENSSL_MANGLER(i2d_OCSP_SERVICELOC)
# endif
#else
# ifndef _i2d_OCSP_SERVICELOC
#  define _i2d_OCSP_SERVICELOC OPENSSL_MANGLER_ASM(i2d_OCSP_SERVICELOC)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_SIGNATURE
#  define i2d_OCSP_SIGNATURE OPENSSL_MANGLER(i2d_OCSP_SIGNATURE)
# endif
#else
# ifndef _i2d_OCSP_SIGNATURE
#  define _i2d_OCSP_SIGNATURE OPENSSL_MANGLER_ASM(i2d_OCSP_SIGNATURE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OCSP_SINGLERESP
#  define i2d_OCSP_SINGLERESP OPENSSL_MANGLER(i2d_OCSP_SINGLERESP)
# endif
#else
# ifndef _i2d_OCSP_SINGLERESP
#  define _i2d_OCSP_SINGLERESP OPENSSL_MANGLER_ASM(i2d_OCSP_SINGLERESP)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_OTHERNAME
#  define i2d_OTHERNAME OPENSSL_MANGLER(i2d_OTHERNAME)
# endif
#else
# ifndef _i2d_OTHERNAME
#  define _i2d_OTHERNAME OPENSSL_MANGLER_ASM(i2d_OTHERNAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PBE2PARAM
#  define i2d_PBE2PARAM OPENSSL_MANGLER(i2d_PBE2PARAM)
# endif
#else
# ifndef _i2d_PBE2PARAM
#  define _i2d_PBE2PARAM OPENSSL_MANGLER_ASM(i2d_PBE2PARAM)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PBEPARAM
#  define i2d_PBEPARAM OPENSSL_MANGLER(i2d_PBEPARAM)
# endif
#else
# ifndef _i2d_PBEPARAM
#  define _i2d_PBEPARAM OPENSSL_MANGLER_ASM(i2d_PBEPARAM)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PBKDF2PARAM
#  define i2d_PBKDF2PARAM OPENSSL_MANGLER(i2d_PBKDF2PARAM)
# endif
#else
# ifndef _i2d_PBKDF2PARAM
#  define _i2d_PBKDF2PARAM OPENSSL_MANGLER_ASM(i2d_PBKDF2PARAM)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS12
#  define i2d_PKCS12 OPENSSL_MANGLER(i2d_PKCS12)
# endif
#else
# ifndef _i2d_PKCS12
#  define _i2d_PKCS12 OPENSSL_MANGLER_ASM(i2d_PKCS12)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS12_BAGS
#  define i2d_PKCS12_BAGS OPENSSL_MANGLER(i2d_PKCS12_BAGS)
# endif
#else
# ifndef _i2d_PKCS12_BAGS
#  define _i2d_PKCS12_BAGS OPENSSL_MANGLER_ASM(i2d_PKCS12_BAGS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS12_bio
#  define i2d_PKCS12_bio OPENSSL_MANGLER(i2d_PKCS12_bio)
# endif
#else
# ifndef _i2d_PKCS12_bio
#  define _i2d_PKCS12_bio OPENSSL_MANGLER_ASM(i2d_PKCS12_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS12_fp
#  define i2d_PKCS12_fp OPENSSL_MANGLER(i2d_PKCS12_fp)
# endif
#else
# ifndef _i2d_PKCS12_fp
#  define _i2d_PKCS12_fp OPENSSL_MANGLER_ASM(i2d_PKCS12_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS12_MAC_DATA
#  define i2d_PKCS12_MAC_DATA OPENSSL_MANGLER(i2d_PKCS12_MAC_DATA)
# endif
#else
# ifndef _i2d_PKCS12_MAC_DATA
#  define _i2d_PKCS12_MAC_DATA OPENSSL_MANGLER_ASM(i2d_PKCS12_MAC_DATA)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS12_SAFEBAG
#  define i2d_PKCS12_SAFEBAG OPENSSL_MANGLER(i2d_PKCS12_SAFEBAG)
# endif
#else
# ifndef _i2d_PKCS12_SAFEBAG
#  define _i2d_PKCS12_SAFEBAG OPENSSL_MANGLER_ASM(i2d_PKCS12_SAFEBAG)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7
#  define i2d_PKCS7 OPENSSL_MANGLER(i2d_PKCS7)
# endif
#else
# ifndef _i2d_PKCS7
#  define _i2d_PKCS7 OPENSSL_MANGLER_ASM(i2d_PKCS7)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_bio
#  define i2d_PKCS7_bio OPENSSL_MANGLER(i2d_PKCS7_bio)
# endif
#else
# ifndef _i2d_PKCS7_bio
#  define _i2d_PKCS7_bio OPENSSL_MANGLER_ASM(i2d_PKCS7_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_bio_stream
#  define i2d_PKCS7_bio_stream OPENSSL_MANGLER(i2d_PKCS7_bio_stream)
# endif
#else
# ifndef _i2d_PKCS7_bio_stream
#  define _i2d_PKCS7_bio_stream OPENSSL_MANGLER_ASM(i2d_PKCS7_bio_stream)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_DIGEST
#  define i2d_PKCS7_DIGEST OPENSSL_MANGLER(i2d_PKCS7_DIGEST)
# endif
#else
# ifndef _i2d_PKCS7_DIGEST
#  define _i2d_PKCS7_DIGEST OPENSSL_MANGLER_ASM(i2d_PKCS7_DIGEST)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_ENC_CONTENT
#  define i2d_PKCS7_ENC_CONTENT OPENSSL_MANGLER(i2d_PKCS7_ENC_CONTENT)
# endif
#else
# ifndef _i2d_PKCS7_ENC_CONTENT
#  define _i2d_PKCS7_ENC_CONTENT OPENSSL_MANGLER_ASM(i2d_PKCS7_ENC_CONTENT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_ENCRYPT
#  define i2d_PKCS7_ENCRYPT OPENSSL_MANGLER(i2d_PKCS7_ENCRYPT)
# endif
#else
# ifndef _i2d_PKCS7_ENCRYPT
#  define _i2d_PKCS7_ENCRYPT OPENSSL_MANGLER_ASM(i2d_PKCS7_ENCRYPT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_ENVELOPE
#  define i2d_PKCS7_ENVELOPE OPENSSL_MANGLER(i2d_PKCS7_ENVELOPE)
# endif
#else
# ifndef _i2d_PKCS7_ENVELOPE
#  define _i2d_PKCS7_ENVELOPE OPENSSL_MANGLER_ASM(i2d_PKCS7_ENVELOPE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_fp
#  define i2d_PKCS7_fp OPENSSL_MANGLER(i2d_PKCS7_fp)
# endif
#else
# ifndef _i2d_PKCS7_fp
#  define _i2d_PKCS7_fp OPENSSL_MANGLER_ASM(i2d_PKCS7_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_ISSUER_AND_SERIAL
#  define i2d_PKCS7_ISSUER_AND_SERIAL OPENSSL_MANGLER(i2d_PKCS7_ISSUER_AND_SERIAL)
# endif
#else
# ifndef _i2d_PKCS7_ISSUER_AND_SERIAL
#  define _i2d_PKCS7_ISSUER_AND_SERIAL OPENSSL_MANGLER_ASM(i2d_PKCS7_ISSUER_AND_SERIAL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_NDEF
#  define i2d_PKCS7_NDEF OPENSSL_MANGLER(i2d_PKCS7_NDEF)
# endif
#else
# ifndef _i2d_PKCS7_NDEF
#  define _i2d_PKCS7_NDEF OPENSSL_MANGLER_ASM(i2d_PKCS7_NDEF)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_RECIP_INFO
#  define i2d_PKCS7_RECIP_INFO OPENSSL_MANGLER(i2d_PKCS7_RECIP_INFO)
# endif
#else
# ifndef _i2d_PKCS7_RECIP_INFO
#  define _i2d_PKCS7_RECIP_INFO OPENSSL_MANGLER_ASM(i2d_PKCS7_RECIP_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_SIGNED
#  define i2d_PKCS7_SIGNED OPENSSL_MANGLER(i2d_PKCS7_SIGNED)
# endif
#else
# ifndef _i2d_PKCS7_SIGNED
#  define _i2d_PKCS7_SIGNED OPENSSL_MANGLER_ASM(i2d_PKCS7_SIGNED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_SIGN_ENVELOPE
#  define i2d_PKCS7_SIGN_ENVELOPE OPENSSL_MANGLER(i2d_PKCS7_SIGN_ENVELOPE)
# endif
#else
# ifndef _i2d_PKCS7_SIGN_ENVELOPE
#  define _i2d_PKCS7_SIGN_ENVELOPE OPENSSL_MANGLER_ASM(i2d_PKCS7_SIGN_ENVELOPE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS7_SIGNER_INFO
#  define i2d_PKCS7_SIGNER_INFO OPENSSL_MANGLER(i2d_PKCS7_SIGNER_INFO)
# endif
#else
# ifndef _i2d_PKCS7_SIGNER_INFO
#  define _i2d_PKCS7_SIGNER_INFO OPENSSL_MANGLER_ASM(i2d_PKCS7_SIGNER_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8_bio
#  define i2d_PKCS8_bio OPENSSL_MANGLER(i2d_PKCS8_bio)
# endif
#else
# ifndef _i2d_PKCS8_bio
#  define _i2d_PKCS8_bio OPENSSL_MANGLER_ASM(i2d_PKCS8_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8_fp
#  define i2d_PKCS8_fp OPENSSL_MANGLER(i2d_PKCS8_fp)
# endif
#else
# ifndef _i2d_PKCS8_fp
#  define _i2d_PKCS8_fp OPENSSL_MANGLER_ASM(i2d_PKCS8_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8PrivateKey_bio
#  define i2d_PKCS8PrivateKey_bio OPENSSL_MANGLER(i2d_PKCS8PrivateKey_bio)
# endif
#else
# ifndef _i2d_PKCS8PrivateKey_bio
#  define _i2d_PKCS8PrivateKey_bio OPENSSL_MANGLER_ASM(i2d_PKCS8PrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8PrivateKey_fp
#  define i2d_PKCS8PrivateKey_fp OPENSSL_MANGLER(i2d_PKCS8PrivateKey_fp)
# endif
#else
# ifndef _i2d_PKCS8PrivateKey_fp
#  define _i2d_PKCS8PrivateKey_fp OPENSSL_MANGLER_ASM(i2d_PKCS8PrivateKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8PrivateKeyInfo_bio
#  define i2d_PKCS8PrivateKeyInfo_bio OPENSSL_MANGLER(i2d_PKCS8PrivateKeyInfo_bio)
# endif
#else
# ifndef _i2d_PKCS8PrivateKeyInfo_bio
#  define _i2d_PKCS8PrivateKeyInfo_bio OPENSSL_MANGLER_ASM(i2d_PKCS8PrivateKeyInfo_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8PrivateKeyInfo_fp
#  define i2d_PKCS8PrivateKeyInfo_fp OPENSSL_MANGLER(i2d_PKCS8PrivateKeyInfo_fp)
# endif
#else
# ifndef _i2d_PKCS8PrivateKeyInfo_fp
#  define _i2d_PKCS8PrivateKeyInfo_fp OPENSSL_MANGLER_ASM(i2d_PKCS8PrivateKeyInfo_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8PrivateKey_nid_bio
#  define i2d_PKCS8PrivateKey_nid_bio OPENSSL_MANGLER(i2d_PKCS8PrivateKey_nid_bio)
# endif
#else
# ifndef _i2d_PKCS8PrivateKey_nid_bio
#  define _i2d_PKCS8PrivateKey_nid_bio OPENSSL_MANGLER_ASM(i2d_PKCS8PrivateKey_nid_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8PrivateKey_nid_fp
#  define i2d_PKCS8PrivateKey_nid_fp OPENSSL_MANGLER(i2d_PKCS8PrivateKey_nid_fp)
# endif
#else
# ifndef _i2d_PKCS8PrivateKey_nid_fp
#  define _i2d_PKCS8PrivateKey_nid_fp OPENSSL_MANGLER_ASM(i2d_PKCS8PrivateKey_nid_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8_PRIV_KEY_INFO
#  define i2d_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER(i2d_PKCS8_PRIV_KEY_INFO)
# endif
#else
# ifndef _i2d_PKCS8_PRIV_KEY_INFO
#  define _i2d_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER_ASM(i2d_PKCS8_PRIV_KEY_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8_PRIV_KEY_INFO_bio
#  define i2d_PKCS8_PRIV_KEY_INFO_bio OPENSSL_MANGLER(i2d_PKCS8_PRIV_KEY_INFO_bio)
# endif
#else
# ifndef _i2d_PKCS8_PRIV_KEY_INFO_bio
#  define _i2d_PKCS8_PRIV_KEY_INFO_bio OPENSSL_MANGLER_ASM(i2d_PKCS8_PRIV_KEY_INFO_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKCS8_PRIV_KEY_INFO_fp
#  define i2d_PKCS8_PRIV_KEY_INFO_fp OPENSSL_MANGLER(i2d_PKCS8_PRIV_KEY_INFO_fp)
# endif
#else
# ifndef _i2d_PKCS8_PRIV_KEY_INFO_fp
#  define _i2d_PKCS8_PRIV_KEY_INFO_fp OPENSSL_MANGLER_ASM(i2d_PKCS8_PRIV_KEY_INFO_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PKEY_USAGE_PERIOD
#  define i2d_PKEY_USAGE_PERIOD OPENSSL_MANGLER(i2d_PKEY_USAGE_PERIOD)
# endif
#else
# ifndef _i2d_PKEY_USAGE_PERIOD
#  define _i2d_PKEY_USAGE_PERIOD OPENSSL_MANGLER_ASM(i2d_PKEY_USAGE_PERIOD)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_POLICYINFO
#  define i2d_POLICYINFO OPENSSL_MANGLER(i2d_POLICYINFO)
# endif
#else
# ifndef _i2d_POLICYINFO
#  define _i2d_POLICYINFO OPENSSL_MANGLER_ASM(i2d_POLICYINFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_POLICYQUALINFO
#  define i2d_POLICYQUALINFO OPENSSL_MANGLER(i2d_POLICYQUALINFO)
# endif
#else
# ifndef _i2d_POLICYQUALINFO
#  define _i2d_POLICYQUALINFO OPENSSL_MANGLER_ASM(i2d_POLICYQUALINFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PrivateKey
#  define i2d_PrivateKey OPENSSL_MANGLER(i2d_PrivateKey)
# endif
#else
# ifndef _i2d_PrivateKey
#  define _i2d_PrivateKey OPENSSL_MANGLER_ASM(i2d_PrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PrivateKey_bio
#  define i2d_PrivateKey_bio OPENSSL_MANGLER(i2d_PrivateKey_bio)
# endif
#else
# ifndef _i2d_PrivateKey_bio
#  define _i2d_PrivateKey_bio OPENSSL_MANGLER_ASM(i2d_PrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PrivateKey_fp
#  define i2d_PrivateKey_fp OPENSSL_MANGLER(i2d_PrivateKey_fp)
# endif
#else
# ifndef _i2d_PrivateKey_fp
#  define _i2d_PrivateKey_fp OPENSSL_MANGLER_ASM(i2d_PrivateKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PROFESSION_INFO
#  define i2d_PROFESSION_INFO OPENSSL_MANGLER(i2d_PROFESSION_INFO)
# endif
#else
# ifndef _i2d_PROFESSION_INFO
#  define _i2d_PROFESSION_INFO OPENSSL_MANGLER_ASM(i2d_PROFESSION_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PROXY_CERT_INFO_EXTENSION
#  define i2d_PROXY_CERT_INFO_EXTENSION OPENSSL_MANGLER(i2d_PROXY_CERT_INFO_EXTENSION)
# endif
#else
# ifndef _i2d_PROXY_CERT_INFO_EXTENSION
#  define _i2d_PROXY_CERT_INFO_EXTENSION OPENSSL_MANGLER_ASM(i2d_PROXY_CERT_INFO_EXTENSION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PROXY_POLICY
#  define i2d_PROXY_POLICY OPENSSL_MANGLER(i2d_PROXY_POLICY)
# endif
#else
# ifndef _i2d_PROXY_POLICY
#  define _i2d_PROXY_POLICY OPENSSL_MANGLER_ASM(i2d_PROXY_POLICY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PUBKEY
#  define i2d_PUBKEY OPENSSL_MANGLER(i2d_PUBKEY)
# endif
#else
# ifndef _i2d_PUBKEY
#  define _i2d_PUBKEY OPENSSL_MANGLER_ASM(i2d_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PUBKEY_bio
#  define i2d_PUBKEY_bio OPENSSL_MANGLER(i2d_PUBKEY_bio)
# endif
#else
# ifndef _i2d_PUBKEY_bio
#  define _i2d_PUBKEY_bio OPENSSL_MANGLER_ASM(i2d_PUBKEY_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PUBKEY_fp
#  define i2d_PUBKEY_fp OPENSSL_MANGLER(i2d_PUBKEY_fp)
# endif
#else
# ifndef _i2d_PUBKEY_fp
#  define _i2d_PUBKEY_fp OPENSSL_MANGLER_ASM(i2d_PUBKEY_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_PublicKey
#  define i2d_PublicKey OPENSSL_MANGLER(i2d_PublicKey)
# endif
#else
# ifndef _i2d_PublicKey
#  define _i2d_PublicKey OPENSSL_MANGLER_ASM(i2d_PublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_re_X509_CRL_tbs
#  define i2d_re_X509_CRL_tbs OPENSSL_MANGLER(i2d_re_X509_CRL_tbs)
# endif
#else
# ifndef _i2d_re_X509_CRL_tbs
#  define _i2d_re_X509_CRL_tbs OPENSSL_MANGLER_ASM(i2d_re_X509_CRL_tbs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_re_X509_REQ_tbs
#  define i2d_re_X509_REQ_tbs OPENSSL_MANGLER(i2d_re_X509_REQ_tbs)
# endif
#else
# ifndef _i2d_re_X509_REQ_tbs
#  define _i2d_re_X509_REQ_tbs OPENSSL_MANGLER_ASM(i2d_re_X509_REQ_tbs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_re_X509_tbs
#  define i2d_re_X509_tbs OPENSSL_MANGLER(i2d_re_X509_tbs)
# endif
#else
# ifndef _i2d_re_X509_tbs
#  define _i2d_re_X509_tbs OPENSSL_MANGLER_ASM(i2d_re_X509_tbs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSA_OAEP_PARAMS
#  define i2d_RSA_OAEP_PARAMS OPENSSL_MANGLER(i2d_RSA_OAEP_PARAMS)
# endif
#else
# ifndef _i2d_RSA_OAEP_PARAMS
#  define _i2d_RSA_OAEP_PARAMS OPENSSL_MANGLER_ASM(i2d_RSA_OAEP_PARAMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSAPrivateKey
#  define i2d_RSAPrivateKey OPENSSL_MANGLER(i2d_RSAPrivateKey)
# endif
#else
# ifndef _i2d_RSAPrivateKey
#  define _i2d_RSAPrivateKey OPENSSL_MANGLER_ASM(i2d_RSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSAPrivateKey_bio
#  define i2d_RSAPrivateKey_bio OPENSSL_MANGLER(i2d_RSAPrivateKey_bio)
# endif
#else
# ifndef _i2d_RSAPrivateKey_bio
#  define _i2d_RSAPrivateKey_bio OPENSSL_MANGLER_ASM(i2d_RSAPrivateKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSAPrivateKey_fp
#  define i2d_RSAPrivateKey_fp OPENSSL_MANGLER(i2d_RSAPrivateKey_fp)
# endif
#else
# ifndef _i2d_RSAPrivateKey_fp
#  define _i2d_RSAPrivateKey_fp OPENSSL_MANGLER_ASM(i2d_RSAPrivateKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSA_PSS_PARAMS
#  define i2d_RSA_PSS_PARAMS OPENSSL_MANGLER(i2d_RSA_PSS_PARAMS)
# endif
#else
# ifndef _i2d_RSA_PSS_PARAMS
#  define _i2d_RSA_PSS_PARAMS OPENSSL_MANGLER_ASM(i2d_RSA_PSS_PARAMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSA_PUBKEY
#  define i2d_RSA_PUBKEY OPENSSL_MANGLER(i2d_RSA_PUBKEY)
# endif
#else
# ifndef _i2d_RSA_PUBKEY
#  define _i2d_RSA_PUBKEY OPENSSL_MANGLER_ASM(i2d_RSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSA_PUBKEY_bio
#  define i2d_RSA_PUBKEY_bio OPENSSL_MANGLER(i2d_RSA_PUBKEY_bio)
# endif
#else
# ifndef _i2d_RSA_PUBKEY_bio
#  define _i2d_RSA_PUBKEY_bio OPENSSL_MANGLER_ASM(i2d_RSA_PUBKEY_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSA_PUBKEY_fp
#  define i2d_RSA_PUBKEY_fp OPENSSL_MANGLER(i2d_RSA_PUBKEY_fp)
# endif
#else
# ifndef _i2d_RSA_PUBKEY_fp
#  define _i2d_RSA_PUBKEY_fp OPENSSL_MANGLER_ASM(i2d_RSA_PUBKEY_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSAPublicKey
#  define i2d_RSAPublicKey OPENSSL_MANGLER(i2d_RSAPublicKey)
# endif
#else
# ifndef _i2d_RSAPublicKey
#  define _i2d_RSAPublicKey OPENSSL_MANGLER_ASM(i2d_RSAPublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSAPublicKey_bio
#  define i2d_RSAPublicKey_bio OPENSSL_MANGLER(i2d_RSAPublicKey_bio)
# endif
#else
# ifndef _i2d_RSAPublicKey_bio
#  define _i2d_RSAPublicKey_bio OPENSSL_MANGLER_ASM(i2d_RSAPublicKey_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_RSAPublicKey_fp
#  define i2d_RSAPublicKey_fp OPENSSL_MANGLER(i2d_RSAPublicKey_fp)
# endif
#else
# ifndef _i2d_RSAPublicKey_fp
#  define _i2d_RSAPublicKey_fp OPENSSL_MANGLER_ASM(i2d_RSAPublicKey_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_SCRYPT_PARAMS
#  define i2d_SCRYPT_PARAMS OPENSSL_MANGLER(i2d_SCRYPT_PARAMS)
# endif
#else
# ifndef _i2d_SCRYPT_PARAMS
#  define _i2d_SCRYPT_PARAMS OPENSSL_MANGLER_ASM(i2d_SCRYPT_PARAMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_SCT_LIST
#  define i2d_SCT_LIST OPENSSL_MANGLER(i2d_SCT_LIST)
# endif
#else
# ifndef _i2d_SCT_LIST
#  define _i2d_SCT_LIST OPENSSL_MANGLER_ASM(i2d_SCT_LIST)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_SM2_Ciphertext
#  define i2d_SM2_Ciphertext OPENSSL_MANGLER(i2d_SM2_Ciphertext)
# endif
#else
# ifndef _i2d_SM2_Ciphertext
#  define _i2d_SM2_Ciphertext OPENSSL_MANGLER_ASM(i2d_SM2_Ciphertext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_SSL_SESSION
#  define i2d_SSL_SESSION OPENSSL_MANGLER(i2d_SSL_SESSION)
# endif
#else
# ifndef _i2d_SSL_SESSION
#  define _i2d_SSL_SESSION OPENSSL_MANGLER_ASM(i2d_SSL_SESSION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_SXNET
#  define i2d_SXNET OPENSSL_MANGLER(i2d_SXNET)
# endif
#else
# ifndef _i2d_SXNET
#  define _i2d_SXNET OPENSSL_MANGLER_ASM(i2d_SXNET)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_SXNETID
#  define i2d_SXNETID OPENSSL_MANGLER(i2d_SXNETID)
# endif
#else
# ifndef _i2d_SXNETID
#  define _i2d_SXNETID OPENSSL_MANGLER_ASM(i2d_SXNETID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_ACCURACY
#  define i2d_TS_ACCURACY OPENSSL_MANGLER(i2d_TS_ACCURACY)
# endif
#else
# ifndef _i2d_TS_ACCURACY
#  define _i2d_TS_ACCURACY OPENSSL_MANGLER_ASM(i2d_TS_ACCURACY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_MSG_IMPRINT
#  define i2d_TS_MSG_IMPRINT OPENSSL_MANGLER(i2d_TS_MSG_IMPRINT)
# endif
#else
# ifndef _i2d_TS_MSG_IMPRINT
#  define _i2d_TS_MSG_IMPRINT OPENSSL_MANGLER_ASM(i2d_TS_MSG_IMPRINT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_MSG_IMPRINT_bio
#  define i2d_TS_MSG_IMPRINT_bio OPENSSL_MANGLER(i2d_TS_MSG_IMPRINT_bio)
# endif
#else
# ifndef _i2d_TS_MSG_IMPRINT_bio
#  define _i2d_TS_MSG_IMPRINT_bio OPENSSL_MANGLER_ASM(i2d_TS_MSG_IMPRINT_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_MSG_IMPRINT_fp
#  define i2d_TS_MSG_IMPRINT_fp OPENSSL_MANGLER(i2d_TS_MSG_IMPRINT_fp)
# endif
#else
# ifndef _i2d_TS_MSG_IMPRINT_fp
#  define _i2d_TS_MSG_IMPRINT_fp OPENSSL_MANGLER_ASM(i2d_TS_MSG_IMPRINT_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_REQ
#  define i2d_TS_REQ OPENSSL_MANGLER(i2d_TS_REQ)
# endif
#else
# ifndef _i2d_TS_REQ
#  define _i2d_TS_REQ OPENSSL_MANGLER_ASM(i2d_TS_REQ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_REQ_bio
#  define i2d_TS_REQ_bio OPENSSL_MANGLER(i2d_TS_REQ_bio)
# endif
#else
# ifndef _i2d_TS_REQ_bio
#  define _i2d_TS_REQ_bio OPENSSL_MANGLER_ASM(i2d_TS_REQ_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_REQ_fp
#  define i2d_TS_REQ_fp OPENSSL_MANGLER(i2d_TS_REQ_fp)
# endif
#else
# ifndef _i2d_TS_REQ_fp
#  define _i2d_TS_REQ_fp OPENSSL_MANGLER_ASM(i2d_TS_REQ_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_RESP
#  define i2d_TS_RESP OPENSSL_MANGLER(i2d_TS_RESP)
# endif
#else
# ifndef _i2d_TS_RESP
#  define _i2d_TS_RESP OPENSSL_MANGLER_ASM(i2d_TS_RESP)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_RESP_bio
#  define i2d_TS_RESP_bio OPENSSL_MANGLER(i2d_TS_RESP_bio)
# endif
#else
# ifndef _i2d_TS_RESP_bio
#  define _i2d_TS_RESP_bio OPENSSL_MANGLER_ASM(i2d_TS_RESP_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_RESP_fp
#  define i2d_TS_RESP_fp OPENSSL_MANGLER(i2d_TS_RESP_fp)
# endif
#else
# ifndef _i2d_TS_RESP_fp
#  define _i2d_TS_RESP_fp OPENSSL_MANGLER_ASM(i2d_TS_RESP_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_STATUS_INFO
#  define i2d_TS_STATUS_INFO OPENSSL_MANGLER(i2d_TS_STATUS_INFO)
# endif
#else
# ifndef _i2d_TS_STATUS_INFO
#  define _i2d_TS_STATUS_INFO OPENSSL_MANGLER_ASM(i2d_TS_STATUS_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_TST_INFO
#  define i2d_TS_TST_INFO OPENSSL_MANGLER(i2d_TS_TST_INFO)
# endif
#else
# ifndef _i2d_TS_TST_INFO
#  define _i2d_TS_TST_INFO OPENSSL_MANGLER_ASM(i2d_TS_TST_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_TST_INFO_bio
#  define i2d_TS_TST_INFO_bio OPENSSL_MANGLER(i2d_TS_TST_INFO_bio)
# endif
#else
# ifndef _i2d_TS_TST_INFO_bio
#  define _i2d_TS_TST_INFO_bio OPENSSL_MANGLER_ASM(i2d_TS_TST_INFO_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_TS_TST_INFO_fp
#  define i2d_TS_TST_INFO_fp OPENSSL_MANGLER(i2d_TS_TST_INFO_fp)
# endif
#else
# ifndef _i2d_TS_TST_INFO_fp
#  define _i2d_TS_TST_INFO_fp OPENSSL_MANGLER_ASM(i2d_TS_TST_INFO_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_USERNOTICE
#  define i2d_USERNOTICE OPENSSL_MANGLER(i2d_USERNOTICE)
# endif
#else
# ifndef _i2d_USERNOTICE
#  define _i2d_USERNOTICE OPENSSL_MANGLER_ASM(i2d_USERNOTICE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509
#  define i2d_X509 OPENSSL_MANGLER(i2d_X509)
# endif
#else
# ifndef _i2d_X509
#  define _i2d_X509 OPENSSL_MANGLER_ASM(i2d_X509)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_ALGOR
#  define i2d_X509_ALGOR OPENSSL_MANGLER(i2d_X509_ALGOR)
# endif
#else
# ifndef _i2d_X509_ALGOR
#  define _i2d_X509_ALGOR OPENSSL_MANGLER_ASM(i2d_X509_ALGOR)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_ALGORS
#  define i2d_X509_ALGORS OPENSSL_MANGLER(i2d_X509_ALGORS)
# endif
#else
# ifndef _i2d_X509_ALGORS
#  define _i2d_X509_ALGORS OPENSSL_MANGLER_ASM(i2d_X509_ALGORS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_ATTRIBUTE
#  define i2d_X509_ATTRIBUTE OPENSSL_MANGLER(i2d_X509_ATTRIBUTE)
# endif
#else
# ifndef _i2d_X509_ATTRIBUTE
#  define _i2d_X509_ATTRIBUTE OPENSSL_MANGLER_ASM(i2d_X509_ATTRIBUTE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_AUX
#  define i2d_X509_AUX OPENSSL_MANGLER(i2d_X509_AUX)
# endif
#else
# ifndef _i2d_X509_AUX
#  define _i2d_X509_AUX OPENSSL_MANGLER_ASM(i2d_X509_AUX)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_bio
#  define i2d_X509_bio OPENSSL_MANGLER(i2d_X509_bio)
# endif
#else
# ifndef _i2d_X509_bio
#  define _i2d_X509_bio OPENSSL_MANGLER_ASM(i2d_X509_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_CERT_AUX
#  define i2d_X509_CERT_AUX OPENSSL_MANGLER(i2d_X509_CERT_AUX)
# endif
#else
# ifndef _i2d_X509_CERT_AUX
#  define _i2d_X509_CERT_AUX OPENSSL_MANGLER_ASM(i2d_X509_CERT_AUX)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_CINF
#  define i2d_X509_CINF OPENSSL_MANGLER(i2d_X509_CINF)
# endif
#else
# ifndef _i2d_X509_CINF
#  define _i2d_X509_CINF OPENSSL_MANGLER_ASM(i2d_X509_CINF)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_CRL
#  define i2d_X509_CRL OPENSSL_MANGLER(i2d_X509_CRL)
# endif
#else
# ifndef _i2d_X509_CRL
#  define _i2d_X509_CRL OPENSSL_MANGLER_ASM(i2d_X509_CRL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_CRL_bio
#  define i2d_X509_CRL_bio OPENSSL_MANGLER(i2d_X509_CRL_bio)
# endif
#else
# ifndef _i2d_X509_CRL_bio
#  define _i2d_X509_CRL_bio OPENSSL_MANGLER_ASM(i2d_X509_CRL_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_CRL_fp
#  define i2d_X509_CRL_fp OPENSSL_MANGLER(i2d_X509_CRL_fp)
# endif
#else
# ifndef _i2d_X509_CRL_fp
#  define _i2d_X509_CRL_fp OPENSSL_MANGLER_ASM(i2d_X509_CRL_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_CRL_INFO
#  define i2d_X509_CRL_INFO OPENSSL_MANGLER(i2d_X509_CRL_INFO)
# endif
#else
# ifndef _i2d_X509_CRL_INFO
#  define _i2d_X509_CRL_INFO OPENSSL_MANGLER_ASM(i2d_X509_CRL_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_EXTENSION
#  define i2d_X509_EXTENSION OPENSSL_MANGLER(i2d_X509_EXTENSION)
# endif
#else
# ifndef _i2d_X509_EXTENSION
#  define _i2d_X509_EXTENSION OPENSSL_MANGLER_ASM(i2d_X509_EXTENSION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_EXTENSIONS
#  define i2d_X509_EXTENSIONS OPENSSL_MANGLER(i2d_X509_EXTENSIONS)
# endif
#else
# ifndef _i2d_X509_EXTENSIONS
#  define _i2d_X509_EXTENSIONS OPENSSL_MANGLER_ASM(i2d_X509_EXTENSIONS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_fp
#  define i2d_X509_fp OPENSSL_MANGLER(i2d_X509_fp)
# endif
#else
# ifndef _i2d_X509_fp
#  define _i2d_X509_fp OPENSSL_MANGLER_ASM(i2d_X509_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_NAME
#  define i2d_X509_NAME OPENSSL_MANGLER(i2d_X509_NAME)
# endif
#else
# ifndef _i2d_X509_NAME
#  define _i2d_X509_NAME OPENSSL_MANGLER_ASM(i2d_X509_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_NAME_ENTRY
#  define i2d_X509_NAME_ENTRY OPENSSL_MANGLER(i2d_X509_NAME_ENTRY)
# endif
#else
# ifndef _i2d_X509_NAME_ENTRY
#  define _i2d_X509_NAME_ENTRY OPENSSL_MANGLER_ASM(i2d_X509_NAME_ENTRY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_PUBKEY
#  define i2d_X509_PUBKEY OPENSSL_MANGLER(i2d_X509_PUBKEY)
# endif
#else
# ifndef _i2d_X509_PUBKEY
#  define _i2d_X509_PUBKEY OPENSSL_MANGLER_ASM(i2d_X509_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_REQ
#  define i2d_X509_REQ OPENSSL_MANGLER(i2d_X509_REQ)
# endif
#else
# ifndef _i2d_X509_REQ
#  define _i2d_X509_REQ OPENSSL_MANGLER_ASM(i2d_X509_REQ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_REQ_bio
#  define i2d_X509_REQ_bio OPENSSL_MANGLER(i2d_X509_REQ_bio)
# endif
#else
# ifndef _i2d_X509_REQ_bio
#  define _i2d_X509_REQ_bio OPENSSL_MANGLER_ASM(i2d_X509_REQ_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_REQ_fp
#  define i2d_X509_REQ_fp OPENSSL_MANGLER(i2d_X509_REQ_fp)
# endif
#else
# ifndef _i2d_X509_REQ_fp
#  define _i2d_X509_REQ_fp OPENSSL_MANGLER_ASM(i2d_X509_REQ_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_REQ_INFO
#  define i2d_X509_REQ_INFO OPENSSL_MANGLER(i2d_X509_REQ_INFO)
# endif
#else
# ifndef _i2d_X509_REQ_INFO
#  define _i2d_X509_REQ_INFO OPENSSL_MANGLER_ASM(i2d_X509_REQ_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_REVOKED
#  define i2d_X509_REVOKED OPENSSL_MANGLER(i2d_X509_REVOKED)
# endif
#else
# ifndef _i2d_X509_REVOKED
#  define _i2d_X509_REVOKED OPENSSL_MANGLER_ASM(i2d_X509_REVOKED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_SIG
#  define i2d_X509_SIG OPENSSL_MANGLER(i2d_X509_SIG)
# endif
#else
# ifndef _i2d_X509_SIG
#  define _i2d_X509_SIG OPENSSL_MANGLER_ASM(i2d_X509_SIG)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2d_X509_VAL
#  define i2d_X509_VAL OPENSSL_MANGLER(i2d_X509_VAL)
# endif
#else
# ifndef _i2d_X509_VAL
#  define _i2d_X509_VAL OPENSSL_MANGLER_ASM(i2d_X509_VAL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2o_ECPublicKey
#  define i2o_ECPublicKey OPENSSL_MANGLER(i2o_ECPublicKey)
# endif
#else
# ifndef _i2o_ECPublicKey
#  define _i2o_ECPublicKey OPENSSL_MANGLER_ASM(i2o_ECPublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2o_SCT
#  define i2o_SCT OPENSSL_MANGLER(i2o_SCT)
# endif
#else
# ifndef _i2o_SCT
#  define _i2o_SCT OPENSSL_MANGLER_ASM(i2o_SCT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2o_SCT_LIST
#  define i2o_SCT_LIST OPENSSL_MANGLER(i2o_SCT_LIST)
# endif
#else
# ifndef _i2o_SCT_LIST
#  define _i2o_SCT_LIST OPENSSL_MANGLER_ASM(i2o_SCT_LIST)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2o_SCT_signature
#  define i2o_SCT_signature OPENSSL_MANGLER(i2o_SCT_signature)
# endif
#else
# ifndef _i2o_SCT_signature
#  define _i2o_SCT_signature OPENSSL_MANGLER_ASM(i2o_SCT_signature)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2s_ASN1_ENUMERATED
#  define i2s_ASN1_ENUMERATED OPENSSL_MANGLER(i2s_ASN1_ENUMERATED)
# endif
#else
# ifndef _i2s_ASN1_ENUMERATED
#  define _i2s_ASN1_ENUMERATED OPENSSL_MANGLER_ASM(i2s_ASN1_ENUMERATED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2s_ASN1_ENUMERATED_TABLE
#  define i2s_ASN1_ENUMERATED_TABLE OPENSSL_MANGLER(i2s_ASN1_ENUMERATED_TABLE)
# endif
#else
# ifndef _i2s_ASN1_ENUMERATED_TABLE
#  define _i2s_ASN1_ENUMERATED_TABLE OPENSSL_MANGLER_ASM(i2s_ASN1_ENUMERATED_TABLE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2s_ASN1_IA5STRING
#  define i2s_ASN1_IA5STRING OPENSSL_MANGLER(i2s_ASN1_IA5STRING)
# endif
#else
# ifndef _i2s_ASN1_IA5STRING
#  define _i2s_ASN1_IA5STRING OPENSSL_MANGLER_ASM(i2s_ASN1_IA5STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2s_ASN1_INTEGER
#  define i2s_ASN1_INTEGER OPENSSL_MANGLER(i2s_ASN1_INTEGER)
# endif
#else
# ifndef _i2s_ASN1_INTEGER
#  define _i2s_ASN1_INTEGER OPENSSL_MANGLER_ASM(i2s_ASN1_INTEGER)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2s_ASN1_OCTET_STRING
#  define i2s_ASN1_OCTET_STRING OPENSSL_MANGLER(i2s_ASN1_OCTET_STRING)
# endif
#else
# ifndef _i2s_ASN1_OCTET_STRING
#  define _i2s_ASN1_OCTET_STRING OPENSSL_MANGLER_ASM(i2s_ASN1_OCTET_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2t_ASN1_OBJECT
#  define i2t_ASN1_OBJECT OPENSSL_MANGLER(i2t_ASN1_OBJECT)
# endif
#else
# ifndef _i2t_ASN1_OBJECT
#  define _i2t_ASN1_OBJECT OPENSSL_MANGLER_ASM(i2t_ASN1_OBJECT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2v_ASN1_BIT_STRING
#  define i2v_ASN1_BIT_STRING OPENSSL_MANGLER(i2v_ASN1_BIT_STRING)
# endif
#else
# ifndef _i2v_ASN1_BIT_STRING
#  define _i2v_ASN1_BIT_STRING OPENSSL_MANGLER_ASM(i2v_ASN1_BIT_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2v_GENERAL_NAME
#  define i2v_GENERAL_NAME OPENSSL_MANGLER(i2v_GENERAL_NAME)
# endif
#else
# ifndef _i2v_GENERAL_NAME
#  define _i2v_GENERAL_NAME OPENSSL_MANGLER_ASM(i2v_GENERAL_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef i2v_GENERAL_NAMES
#  define i2v_GENERAL_NAMES OPENSSL_MANGLER(i2v_GENERAL_NAMES)
# endif
#else
# ifndef _i2v_GENERAL_NAMES
#  define _i2v_GENERAL_NAMES OPENSSL_MANGLER_ASM(i2v_GENERAL_NAMES)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef INT32_it
#  define INT32_it OPENSSL_MANGLER(INT32_it)
# endif
#else
# ifndef _INT32_it
#  define _INT32_it OPENSSL_MANGLER_ASM(INT32_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef INT64_it
#  define INT64_it OPENSSL_MANGLER(INT64_it)
# endif
#else
# ifndef _INT64_it
#  define _INT64_it OPENSSL_MANGLER_ASM(INT64_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef int_bn_mod_inverse
#  define int_bn_mod_inverse OPENSSL_MANGLER(int_bn_mod_inverse)
# endif
#else
# ifndef _int_bn_mod_inverse
#  define _int_bn_mod_inverse OPENSSL_MANGLER_ASM(int_bn_mod_inverse)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef int_rsa_verify
#  define int_rsa_verify OPENSSL_MANGLER(int_rsa_verify)
# endif
#else
# ifndef _int_rsa_verify
#  define _int_rsa_verify OPENSSL_MANGLER_ASM(int_rsa_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressChoice_free
#  define IPAddressChoice_free OPENSSL_MANGLER(IPAddressChoice_free)
# endif
#else
# ifndef _IPAddressChoice_free
#  define _IPAddressChoice_free OPENSSL_MANGLER_ASM(IPAddressChoice_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressChoice_it
#  define IPAddressChoice_it OPENSSL_MANGLER(IPAddressChoice_it)
# endif
#else
# ifndef _IPAddressChoice_it
#  define _IPAddressChoice_it OPENSSL_MANGLER_ASM(IPAddressChoice_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressChoice_new
#  define IPAddressChoice_new OPENSSL_MANGLER(IPAddressChoice_new)
# endif
#else
# ifndef _IPAddressChoice_new
#  define _IPAddressChoice_new OPENSSL_MANGLER_ASM(IPAddressChoice_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressFamily_free
#  define IPAddressFamily_free OPENSSL_MANGLER(IPAddressFamily_free)
# endif
#else
# ifndef _IPAddressFamily_free
#  define _IPAddressFamily_free OPENSSL_MANGLER_ASM(IPAddressFamily_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressFamily_it
#  define IPAddressFamily_it OPENSSL_MANGLER(IPAddressFamily_it)
# endif
#else
# ifndef _IPAddressFamily_it
#  define _IPAddressFamily_it OPENSSL_MANGLER_ASM(IPAddressFamily_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressFamily_new
#  define IPAddressFamily_new OPENSSL_MANGLER(IPAddressFamily_new)
# endif
#else
# ifndef _IPAddressFamily_new
#  define _IPAddressFamily_new OPENSSL_MANGLER_ASM(IPAddressFamily_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressOrRange_free
#  define IPAddressOrRange_free OPENSSL_MANGLER(IPAddressOrRange_free)
# endif
#else
# ifndef _IPAddressOrRange_free
#  define _IPAddressOrRange_free OPENSSL_MANGLER_ASM(IPAddressOrRange_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressOrRange_it
#  define IPAddressOrRange_it OPENSSL_MANGLER(IPAddressOrRange_it)
# endif
#else
# ifndef _IPAddressOrRange_it
#  define _IPAddressOrRange_it OPENSSL_MANGLER_ASM(IPAddressOrRange_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressOrRange_new
#  define IPAddressOrRange_new OPENSSL_MANGLER(IPAddressOrRange_new)
# endif
#else
# ifndef _IPAddressOrRange_new
#  define _IPAddressOrRange_new OPENSSL_MANGLER_ASM(IPAddressOrRange_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressRange_free
#  define IPAddressRange_free OPENSSL_MANGLER(IPAddressRange_free)
# endif
#else
# ifndef _IPAddressRange_free
#  define _IPAddressRange_free OPENSSL_MANGLER_ASM(IPAddressRange_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressRange_it
#  define IPAddressRange_it OPENSSL_MANGLER(IPAddressRange_it)
# endif
#else
# ifndef _IPAddressRange_it
#  define _IPAddressRange_it OPENSSL_MANGLER_ASM(IPAddressRange_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef IPAddressRange_new
#  define IPAddressRange_new OPENSSL_MANGLER(IPAddressRange_new)
# endif
#else
# ifndef _IPAddressRange_new
#  define _IPAddressRange_new OPENSSL_MANGLER_ASM(IPAddressRange_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef is_partially_overlapping
#  define is_partially_overlapping OPENSSL_MANGLER(is_partially_overlapping)
# endif
#else
# ifndef _is_partially_overlapping
#  define _is_partially_overlapping OPENSSL_MANGLER_ASM(is_partially_overlapping)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ISSUING_DIST_POINT_free
#  define ISSUING_DIST_POINT_free OPENSSL_MANGLER(ISSUING_DIST_POINT_free)
# endif
#else
# ifndef _ISSUING_DIST_POINT_free
#  define _ISSUING_DIST_POINT_free OPENSSL_MANGLER_ASM(ISSUING_DIST_POINT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ISSUING_DIST_POINT_it
#  define ISSUING_DIST_POINT_it OPENSSL_MANGLER(ISSUING_DIST_POINT_it)
# endif
#else
# ifndef _ISSUING_DIST_POINT_it
#  define _ISSUING_DIST_POINT_it OPENSSL_MANGLER_ASM(ISSUING_DIST_POINT_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ISSUING_DIST_POINT_new
#  define ISSUING_DIST_POINT_new OPENSSL_MANGLER(ISSUING_DIST_POINT_new)
# endif
#else
# ifndef _ISSUING_DIST_POINT_new
#  define _ISSUING_DIST_POINT_new OPENSSL_MANGLER_ASM(ISSUING_DIST_POINT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef level_add_node
#  define level_add_node OPENSSL_MANGLER(level_add_node)
# endif
#else
# ifndef _level_add_node
#  define _level_add_node OPENSSL_MANGLER_ASM(level_add_node)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef level_find_node
#  define level_find_node OPENSSL_MANGLER(level_find_node)
# endif
#else
# ifndef _level_find_node
#  define _level_find_node OPENSSL_MANGLER_ASM(level_find_node)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef LONG_it
#  define LONG_it OPENSSL_MANGLER(LONG_it)
# endif
#else
# ifndef _LONG_it
#  define _LONG_it OPENSSL_MANGLER_ASM(LONG_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef lookup_sess_in_cache
#  define lookup_sess_in_cache OPENSSL_MANGLER(lookup_sess_in_cache)
# endif
#else
# ifndef _lookup_sess_in_cache
#  define _lookup_sess_in_cache OPENSSL_MANGLER_ASM(lookup_sess_in_cache)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef MD2
#  define MD2 OPENSSL_MANGLER(MD2)
# endif
#else
# ifndef _MD2
#  define _MD2 OPENSSL_MANGLER_ASM(MD2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef MD2_Final
#  define MD2_Final OPENSSL_MANGLER(MD2_Final)
# endif
#else
# ifndef _MD2_Final
#  define _MD2_Final OPENSSL_MANGLER_ASM(MD2_Final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef MD2_Init
#  define MD2_Init OPENSSL_MANGLER(MD2_Init)
# endif
#else
# ifndef _MD2_Init
#  define _MD2_Init OPENSSL_MANGLER_ASM(MD2_Init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef MD2_options
#  define MD2_options OPENSSL_MANGLER(MD2_options)
# endif
#else
# ifndef _MD2_options
#  define _MD2_options OPENSSL_MANGLER_ASM(MD2_options)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef MD2_Update
#  define MD2_Update OPENSSL_MANGLER(MD2_Update)
# endif
#else
# ifndef _MD2_Update
#  define _MD2_Update OPENSSL_MANGLER_ASM(MD2_Update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef MD5
#  define MD5 OPENSSL_MANGLER(MD5)
# endif
#else
# ifndef _MD5
#  define _MD5 OPENSSL_MANGLER_ASM(MD5)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef md5_block_asm_data_order
#  define md5_block_asm_data_order OPENSSL_MANGLER(md5_block_asm_data_order)
# endif
#else
# ifndef _md5_block_asm_data_order
#  define _md5_block_asm_data_order OPENSSL_MANGLER_ASM(md5_block_asm_data_order)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef MD5_Final
#  define MD5_Final OPENSSL_MANGLER(MD5_Final)
# endif
#else
# ifndef _MD5_Final
#  define _MD5_Final OPENSSL_MANGLER_ASM(MD5_Final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef MD5_Init
#  define MD5_Init OPENSSL_MANGLER(MD5_Init)
# endif
#else
# ifndef _MD5_Init
#  define _MD5_Init OPENSSL_MANGLER_ASM(MD5_Init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef MD5_Transform
#  define MD5_Transform OPENSSL_MANGLER(MD5_Transform)
# endif
#else
# ifndef _MD5_Transform
#  define _MD5_Transform OPENSSL_MANGLER_ASM(MD5_Transform)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef MD5_Update
#  define MD5_Update OPENSSL_MANGLER(MD5_Update)
# endif
#else
# ifndef _MD5_Update
#  define _MD5_Update OPENSSL_MANGLER_ASM(MD5_Update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef name_cmp
#  define name_cmp OPENSSL_MANGLER(name_cmp)
# endif
#else
# ifndef _name_cmp
#  define _name_cmp OPENSSL_MANGLER_ASM(name_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAME_CONSTRAINTS_check
#  define NAME_CONSTRAINTS_check OPENSSL_MANGLER(NAME_CONSTRAINTS_check)
# endif
#else
# ifndef _NAME_CONSTRAINTS_check
#  define _NAME_CONSTRAINTS_check OPENSSL_MANGLER_ASM(NAME_CONSTRAINTS_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAME_CONSTRAINTS_check_CN
#  define NAME_CONSTRAINTS_check_CN OPENSSL_MANGLER(NAME_CONSTRAINTS_check_CN)
# endif
#else
# ifndef _NAME_CONSTRAINTS_check_CN
#  define _NAME_CONSTRAINTS_check_CN OPENSSL_MANGLER_ASM(NAME_CONSTRAINTS_check_CN)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAME_CONSTRAINTS_free
#  define NAME_CONSTRAINTS_free OPENSSL_MANGLER(NAME_CONSTRAINTS_free)
# endif
#else
# ifndef _NAME_CONSTRAINTS_free
#  define _NAME_CONSTRAINTS_free OPENSSL_MANGLER_ASM(NAME_CONSTRAINTS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAME_CONSTRAINTS_it
#  define NAME_CONSTRAINTS_it OPENSSL_MANGLER(NAME_CONSTRAINTS_it)
# endif
#else
# ifndef _NAME_CONSTRAINTS_it
#  define _NAME_CONSTRAINTS_it OPENSSL_MANGLER_ASM(NAME_CONSTRAINTS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAME_CONSTRAINTS_new
#  define NAME_CONSTRAINTS_new OPENSSL_MANGLER(NAME_CONSTRAINTS_new)
# endif
#else
# ifndef _NAME_CONSTRAINTS_new
#  define _NAME_CONSTRAINTS_new OPENSSL_MANGLER_ASM(NAME_CONSTRAINTS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAMING_AUTHORITY_free
#  define NAMING_AUTHORITY_free OPENSSL_MANGLER(NAMING_AUTHORITY_free)
# endif
#else
# ifndef _NAMING_AUTHORITY_free
#  define _NAMING_AUTHORITY_free OPENSSL_MANGLER_ASM(NAMING_AUTHORITY_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAMING_AUTHORITY_get0_authorityId
#  define NAMING_AUTHORITY_get0_authorityId OPENSSL_MANGLER(NAMING_AUTHORITY_get0_authorityId)
# endif
#else
# ifndef _NAMING_AUTHORITY_get0_authorityId
#  define _NAMING_AUTHORITY_get0_authorityId OPENSSL_MANGLER_ASM(NAMING_AUTHORITY_get0_authorityId)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAMING_AUTHORITY_get0_authorityText
#  define NAMING_AUTHORITY_get0_authorityText OPENSSL_MANGLER(NAMING_AUTHORITY_get0_authorityText)
# endif
#else
# ifndef _NAMING_AUTHORITY_get0_authorityText
#  define _NAMING_AUTHORITY_get0_authorityText OPENSSL_MANGLER_ASM(NAMING_AUTHORITY_get0_authorityText)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAMING_AUTHORITY_get0_authorityURL
#  define NAMING_AUTHORITY_get0_authorityURL OPENSSL_MANGLER(NAMING_AUTHORITY_get0_authorityURL)
# endif
#else
# ifndef _NAMING_AUTHORITY_get0_authorityURL
#  define _NAMING_AUTHORITY_get0_authorityURL OPENSSL_MANGLER_ASM(NAMING_AUTHORITY_get0_authorityURL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAMING_AUTHORITY_it
#  define NAMING_AUTHORITY_it OPENSSL_MANGLER(NAMING_AUTHORITY_it)
# endif
#else
# ifndef _NAMING_AUTHORITY_it
#  define _NAMING_AUTHORITY_it OPENSSL_MANGLER_ASM(NAMING_AUTHORITY_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAMING_AUTHORITY_new
#  define NAMING_AUTHORITY_new OPENSSL_MANGLER(NAMING_AUTHORITY_new)
# endif
#else
# ifndef _NAMING_AUTHORITY_new
#  define _NAMING_AUTHORITY_new OPENSSL_MANGLER_ASM(NAMING_AUTHORITY_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAMING_AUTHORITY_set0_authorityId
#  define NAMING_AUTHORITY_set0_authorityId OPENSSL_MANGLER(NAMING_AUTHORITY_set0_authorityId)
# endif
#else
# ifndef _NAMING_AUTHORITY_set0_authorityId
#  define _NAMING_AUTHORITY_set0_authorityId OPENSSL_MANGLER_ASM(NAMING_AUTHORITY_set0_authorityId)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAMING_AUTHORITY_set0_authorityText
#  define NAMING_AUTHORITY_set0_authorityText OPENSSL_MANGLER(NAMING_AUTHORITY_set0_authorityText)
# endif
#else
# ifndef _NAMING_AUTHORITY_set0_authorityText
#  define _NAMING_AUTHORITY_set0_authorityText OPENSSL_MANGLER_ASM(NAMING_AUTHORITY_set0_authorityText)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NAMING_AUTHORITY_set0_authorityURL
#  define NAMING_AUTHORITY_set0_authorityURL OPENSSL_MANGLER(NAMING_AUTHORITY_set0_authorityURL)
# endif
#else
# ifndef _NAMING_AUTHORITY_set0_authorityURL
#  define _NAMING_AUTHORITY_set0_authorityURL OPENSSL_MANGLER_ASM(NAMING_AUTHORITY_set0_authorityURL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_default
#  define NCONF_default OPENSSL_MANGLER(NCONF_default)
# endif
#else
# ifndef _NCONF_default
#  define _NCONF_default OPENSSL_MANGLER_ASM(NCONF_default)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_dump_bio
#  define NCONF_dump_bio OPENSSL_MANGLER(NCONF_dump_bio)
# endif
#else
# ifndef _NCONF_dump_bio
#  define _NCONF_dump_bio OPENSSL_MANGLER_ASM(NCONF_dump_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_dump_fp
#  define NCONF_dump_fp OPENSSL_MANGLER(NCONF_dump_fp)
# endif
#else
# ifndef _NCONF_dump_fp
#  define _NCONF_dump_fp OPENSSL_MANGLER_ASM(NCONF_dump_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_free
#  define NCONF_free OPENSSL_MANGLER(NCONF_free)
# endif
#else
# ifndef _NCONF_free
#  define _NCONF_free OPENSSL_MANGLER_ASM(NCONF_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_free_data
#  define NCONF_free_data OPENSSL_MANGLER(NCONF_free_data)
# endif
#else
# ifndef _NCONF_free_data
#  define _NCONF_free_data OPENSSL_MANGLER_ASM(NCONF_free_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_get_number_e
#  define NCONF_get_number_e OPENSSL_MANGLER(NCONF_get_number_e)
# endif
#else
# ifndef _NCONF_get_number_e
#  define _NCONF_get_number_e OPENSSL_MANGLER_ASM(NCONF_get_number_e)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_get_section
#  define NCONF_get_section OPENSSL_MANGLER(NCONF_get_section)
# endif
#else
# ifndef _NCONF_get_section
#  define _NCONF_get_section OPENSSL_MANGLER_ASM(NCONF_get_section)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_get_string
#  define NCONF_get_string OPENSSL_MANGLER(NCONF_get_string)
# endif
#else
# ifndef _NCONF_get_string
#  define _NCONF_get_string OPENSSL_MANGLER_ASM(NCONF_get_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_load
#  define NCONF_load OPENSSL_MANGLER(NCONF_load)
# endif
#else
# ifndef _NCONF_load
#  define _NCONF_load OPENSSL_MANGLER_ASM(NCONF_load)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_load_bio
#  define NCONF_load_bio OPENSSL_MANGLER(NCONF_load_bio)
# endif
#else
# ifndef _NCONF_load_bio
#  define _NCONF_load_bio OPENSSL_MANGLER_ASM(NCONF_load_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_load_fp
#  define NCONF_load_fp OPENSSL_MANGLER(NCONF_load_fp)
# endif
#else
# ifndef _NCONF_load_fp
#  define _NCONF_load_fp OPENSSL_MANGLER_ASM(NCONF_load_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_new
#  define NCONF_new OPENSSL_MANGLER(NCONF_new)
# endif
#else
# ifndef _NCONF_new
#  define _NCONF_new OPENSSL_MANGLER_ASM(NCONF_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NCONF_WIN32
#  define NCONF_WIN32 OPENSSL_MANGLER(NCONF_WIN32)
# endif
#else
# ifndef _NCONF_WIN32
#  define _NCONF_WIN32 OPENSSL_MANGLER_ASM(NCONF_WIN32)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_CERT_SEQUENCE_free
#  define NETSCAPE_CERT_SEQUENCE_free OPENSSL_MANGLER(NETSCAPE_CERT_SEQUENCE_free)
# endif
#else
# ifndef _NETSCAPE_CERT_SEQUENCE_free
#  define _NETSCAPE_CERT_SEQUENCE_free OPENSSL_MANGLER_ASM(NETSCAPE_CERT_SEQUENCE_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_CERT_SEQUENCE_it
#  define NETSCAPE_CERT_SEQUENCE_it OPENSSL_MANGLER(NETSCAPE_CERT_SEQUENCE_it)
# endif
#else
# ifndef _NETSCAPE_CERT_SEQUENCE_it
#  define _NETSCAPE_CERT_SEQUENCE_it OPENSSL_MANGLER_ASM(NETSCAPE_CERT_SEQUENCE_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_CERT_SEQUENCE_new
#  define NETSCAPE_CERT_SEQUENCE_new OPENSSL_MANGLER(NETSCAPE_CERT_SEQUENCE_new)
# endif
#else
# ifndef _NETSCAPE_CERT_SEQUENCE_new
#  define _NETSCAPE_CERT_SEQUENCE_new OPENSSL_MANGLER_ASM(NETSCAPE_CERT_SEQUENCE_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_ENCRYPTED_PKEY_free
#  define NETSCAPE_ENCRYPTED_PKEY_free OPENSSL_MANGLER(NETSCAPE_ENCRYPTED_PKEY_free)
# endif
#else
# ifndef _NETSCAPE_ENCRYPTED_PKEY_free
#  define _NETSCAPE_ENCRYPTED_PKEY_free OPENSSL_MANGLER_ASM(NETSCAPE_ENCRYPTED_PKEY_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_ENCRYPTED_PKEY_new
#  define NETSCAPE_ENCRYPTED_PKEY_new OPENSSL_MANGLER(NETSCAPE_ENCRYPTED_PKEY_new)
# endif
#else
# ifndef _NETSCAPE_ENCRYPTED_PKEY_new
#  define _NETSCAPE_ENCRYPTED_PKEY_new OPENSSL_MANGLER_ASM(NETSCAPE_ENCRYPTED_PKEY_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_PKEY_free
#  define NETSCAPE_PKEY_free OPENSSL_MANGLER(NETSCAPE_PKEY_free)
# endif
#else
# ifndef _NETSCAPE_PKEY_free
#  define _NETSCAPE_PKEY_free OPENSSL_MANGLER_ASM(NETSCAPE_PKEY_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_PKEY_new
#  define NETSCAPE_PKEY_new OPENSSL_MANGLER(NETSCAPE_PKEY_new)
# endif
#else
# ifndef _NETSCAPE_PKEY_new
#  define _NETSCAPE_PKEY_new OPENSSL_MANGLER_ASM(NETSCAPE_PKEY_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKAC_free
#  define NETSCAPE_SPKAC_free OPENSSL_MANGLER(NETSCAPE_SPKAC_free)
# endif
#else
# ifndef _NETSCAPE_SPKAC_free
#  define _NETSCAPE_SPKAC_free OPENSSL_MANGLER_ASM(NETSCAPE_SPKAC_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKAC_it
#  define NETSCAPE_SPKAC_it OPENSSL_MANGLER(NETSCAPE_SPKAC_it)
# endif
#else
# ifndef _NETSCAPE_SPKAC_it
#  define _NETSCAPE_SPKAC_it OPENSSL_MANGLER_ASM(NETSCAPE_SPKAC_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKAC_new
#  define NETSCAPE_SPKAC_new OPENSSL_MANGLER(NETSCAPE_SPKAC_new)
# endif
#else
# ifndef _NETSCAPE_SPKAC_new
#  define _NETSCAPE_SPKAC_new OPENSSL_MANGLER_ASM(NETSCAPE_SPKAC_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKI_b64_decode
#  define NETSCAPE_SPKI_b64_decode OPENSSL_MANGLER(NETSCAPE_SPKI_b64_decode)
# endif
#else
# ifndef _NETSCAPE_SPKI_b64_decode
#  define _NETSCAPE_SPKI_b64_decode OPENSSL_MANGLER_ASM(NETSCAPE_SPKI_b64_decode)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKI_b64_encode
#  define NETSCAPE_SPKI_b64_encode OPENSSL_MANGLER(NETSCAPE_SPKI_b64_encode)
# endif
#else
# ifndef _NETSCAPE_SPKI_b64_encode
#  define _NETSCAPE_SPKI_b64_encode OPENSSL_MANGLER_ASM(NETSCAPE_SPKI_b64_encode)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKI_free
#  define NETSCAPE_SPKI_free OPENSSL_MANGLER(NETSCAPE_SPKI_free)
# endif
#else
# ifndef _NETSCAPE_SPKI_free
#  define _NETSCAPE_SPKI_free OPENSSL_MANGLER_ASM(NETSCAPE_SPKI_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKI_get_pubkey
#  define NETSCAPE_SPKI_get_pubkey OPENSSL_MANGLER(NETSCAPE_SPKI_get_pubkey)
# endif
#else
# ifndef _NETSCAPE_SPKI_get_pubkey
#  define _NETSCAPE_SPKI_get_pubkey OPENSSL_MANGLER_ASM(NETSCAPE_SPKI_get_pubkey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKI_it
#  define NETSCAPE_SPKI_it OPENSSL_MANGLER(NETSCAPE_SPKI_it)
# endif
#else
# ifndef _NETSCAPE_SPKI_it
#  define _NETSCAPE_SPKI_it OPENSSL_MANGLER_ASM(NETSCAPE_SPKI_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKI_new
#  define NETSCAPE_SPKI_new OPENSSL_MANGLER(NETSCAPE_SPKI_new)
# endif
#else
# ifndef _NETSCAPE_SPKI_new
#  define _NETSCAPE_SPKI_new OPENSSL_MANGLER_ASM(NETSCAPE_SPKI_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKI_print
#  define NETSCAPE_SPKI_print OPENSSL_MANGLER(NETSCAPE_SPKI_print)
# endif
#else
# ifndef _NETSCAPE_SPKI_print
#  define _NETSCAPE_SPKI_print OPENSSL_MANGLER_ASM(NETSCAPE_SPKI_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKI_set_pubkey
#  define NETSCAPE_SPKI_set_pubkey OPENSSL_MANGLER(NETSCAPE_SPKI_set_pubkey)
# endif
#else
# ifndef _NETSCAPE_SPKI_set_pubkey
#  define _NETSCAPE_SPKI_set_pubkey OPENSSL_MANGLER_ASM(NETSCAPE_SPKI_set_pubkey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKI_sign
#  define NETSCAPE_SPKI_sign OPENSSL_MANGLER(NETSCAPE_SPKI_sign)
# endif
#else
# ifndef _NETSCAPE_SPKI_sign
#  define _NETSCAPE_SPKI_sign OPENSSL_MANGLER_ASM(NETSCAPE_SPKI_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NETSCAPE_SPKI_verify
#  define NETSCAPE_SPKI_verify OPENSSL_MANGLER(NETSCAPE_SPKI_verify)
# endif
#else
# ifndef _NETSCAPE_SPKI_verify
#  define _NETSCAPE_SPKI_verify OPENSSL_MANGLER_ASM(NETSCAPE_SPKI_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NOTICEREF_free
#  define NOTICEREF_free OPENSSL_MANGLER(NOTICEREF_free)
# endif
#else
# ifndef _NOTICEREF_free
#  define _NOTICEREF_free OPENSSL_MANGLER_ASM(NOTICEREF_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NOTICEREF_it
#  define NOTICEREF_it OPENSSL_MANGLER(NOTICEREF_it)
# endif
#else
# ifndef _NOTICEREF_it
#  define _NOTICEREF_it OPENSSL_MANGLER_ASM(NOTICEREF_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef NOTICEREF_new
#  define NOTICEREF_new OPENSSL_MANGLER(NOTICEREF_new)
# endif
#else
# ifndef _NOTICEREF_new
#  define _NOTICEREF_new OPENSSL_MANGLER_ASM(NOTICEREF_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef n_ssl3_mac
#  define n_ssl3_mac OPENSSL_MANGLER(n_ssl3_mac)
# endif
#else
# ifndef _n_ssl3_mac
#  define _n_ssl3_mac OPENSSL_MANGLER_ASM(n_ssl3_mac)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef o2i_ECPublicKey
#  define o2i_ECPublicKey OPENSSL_MANGLER(o2i_ECPublicKey)
# endif
#else
# ifndef _o2i_ECPublicKey
#  define _o2i_ECPublicKey OPENSSL_MANGLER_ASM(o2i_ECPublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef o2i_SCT
#  define o2i_SCT OPENSSL_MANGLER(o2i_SCT)
# endif
#else
# ifndef _o2i_SCT
#  define _o2i_SCT OPENSSL_MANGLER_ASM(o2i_SCT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef o2i_SCT_LIST
#  define o2i_SCT_LIST OPENSSL_MANGLER(o2i_SCT_LIST)
# endif
#else
# ifndef _o2i_SCT_LIST
#  define _o2i_SCT_LIST OPENSSL_MANGLER_ASM(o2i_SCT_LIST)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef o2i_SCT_signature
#  define o2i_SCT_signature OPENSSL_MANGLER(o2i_SCT_signature)
# endif
#else
# ifndef _o2i_SCT_signature
#  define _o2i_SCT_signature OPENSSL_MANGLER_ASM(o2i_SCT_signature)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_add_object
#  define OBJ_add_object OPENSSL_MANGLER(OBJ_add_object)
# endif
#else
# ifndef _OBJ_add_object
#  define _OBJ_add_object OPENSSL_MANGLER_ASM(OBJ_add_object)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_add_sigid
#  define OBJ_add_sigid OPENSSL_MANGLER(OBJ_add_sigid)
# endif
#else
# ifndef _OBJ_add_sigid
#  define _OBJ_add_sigid OPENSSL_MANGLER_ASM(OBJ_add_sigid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_bsearch_
#  define OBJ_bsearch_ OPENSSL_MANGLER(OBJ_bsearch_)
# endif
#else
# ifndef _OBJ_bsearch_
#  define _OBJ_bsearch_ OPENSSL_MANGLER_ASM(OBJ_bsearch_)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_bsearch_ex_
#  define OBJ_bsearch_ex_ OPENSSL_MANGLER(OBJ_bsearch_ex_)
# endif
#else
# ifndef _OBJ_bsearch_ex_
#  define _OBJ_bsearch_ex_ OPENSSL_MANGLER_ASM(OBJ_bsearch_ex_)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_bsearch_ssl_cipher_id
#  define OBJ_bsearch_ssl_cipher_id OPENSSL_MANGLER(OBJ_bsearch_ssl_cipher_id)
# endif
#else
# ifndef _OBJ_bsearch_ssl_cipher_id
#  define _OBJ_bsearch_ssl_cipher_id OPENSSL_MANGLER_ASM(OBJ_bsearch_ssl_cipher_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef obj_cleanup_int
#  define obj_cleanup_int OPENSSL_MANGLER(obj_cleanup_int)
# endif
#else
# ifndef _obj_cleanup_int
#  define _obj_cleanup_int OPENSSL_MANGLER_ASM(obj_cleanup_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_cmp
#  define OBJ_cmp OPENSSL_MANGLER(OBJ_cmp)
# endif
#else
# ifndef _OBJ_cmp
#  define _OBJ_cmp OPENSSL_MANGLER_ASM(OBJ_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_create
#  define OBJ_create OPENSSL_MANGLER(OBJ_create)
# endif
#else
# ifndef _OBJ_create
#  define _OBJ_create OPENSSL_MANGLER_ASM(OBJ_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_create_objects
#  define OBJ_create_objects OPENSSL_MANGLER(OBJ_create_objects)
# endif
#else
# ifndef _OBJ_create_objects
#  define _OBJ_create_objects OPENSSL_MANGLER_ASM(OBJ_create_objects)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_dup
#  define OBJ_dup OPENSSL_MANGLER(OBJ_dup)
# endif
#else
# ifndef _OBJ_dup
#  define _OBJ_dup OPENSSL_MANGLER_ASM(OBJ_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_find_sigid_algs
#  define OBJ_find_sigid_algs OPENSSL_MANGLER(OBJ_find_sigid_algs)
# endif
#else
# ifndef _OBJ_find_sigid_algs
#  define _OBJ_find_sigid_algs OPENSSL_MANGLER_ASM(OBJ_find_sigid_algs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_find_sigid_by_algs
#  define OBJ_find_sigid_by_algs OPENSSL_MANGLER(OBJ_find_sigid_by_algs)
# endif
#else
# ifndef _OBJ_find_sigid_by_algs
#  define _OBJ_find_sigid_by_algs OPENSSL_MANGLER_ASM(OBJ_find_sigid_by_algs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_get0_data
#  define OBJ_get0_data OPENSSL_MANGLER(OBJ_get0_data)
# endif
#else
# ifndef _OBJ_get0_data
#  define _OBJ_get0_data OPENSSL_MANGLER_ASM(OBJ_get0_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_length
#  define OBJ_length OPENSSL_MANGLER(OBJ_length)
# endif
#else
# ifndef _OBJ_length
#  define _OBJ_length OPENSSL_MANGLER_ASM(OBJ_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_ln2nid
#  define OBJ_ln2nid OPENSSL_MANGLER(OBJ_ln2nid)
# endif
#else
# ifndef _OBJ_ln2nid
#  define _OBJ_ln2nid OPENSSL_MANGLER_ASM(OBJ_ln2nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_NAME_add
#  define OBJ_NAME_add OPENSSL_MANGLER(OBJ_NAME_add)
# endif
#else
# ifndef _OBJ_NAME_add
#  define _OBJ_NAME_add OPENSSL_MANGLER_ASM(OBJ_NAME_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_NAME_cleanup
#  define OBJ_NAME_cleanup OPENSSL_MANGLER(OBJ_NAME_cleanup)
# endif
#else
# ifndef _OBJ_NAME_cleanup
#  define _OBJ_NAME_cleanup OPENSSL_MANGLER_ASM(OBJ_NAME_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_NAME_do_all
#  define OBJ_NAME_do_all OPENSSL_MANGLER(OBJ_NAME_do_all)
# endif
#else
# ifndef _OBJ_NAME_do_all
#  define _OBJ_NAME_do_all OPENSSL_MANGLER_ASM(OBJ_NAME_do_all)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_NAME_do_all_sorted
#  define OBJ_NAME_do_all_sorted OPENSSL_MANGLER(OBJ_NAME_do_all_sorted)
# endif
#else
# ifndef _OBJ_NAME_do_all_sorted
#  define _OBJ_NAME_do_all_sorted OPENSSL_MANGLER_ASM(OBJ_NAME_do_all_sorted)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_NAME_get
#  define OBJ_NAME_get OPENSSL_MANGLER(OBJ_NAME_get)
# endif
#else
# ifndef _OBJ_NAME_get
#  define _OBJ_NAME_get OPENSSL_MANGLER_ASM(OBJ_NAME_get)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_NAME_init
#  define OBJ_NAME_init OPENSSL_MANGLER(OBJ_NAME_init)
# endif
#else
# ifndef _OBJ_NAME_init
#  define _OBJ_NAME_init OPENSSL_MANGLER_ASM(OBJ_NAME_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_NAME_new_index
#  define OBJ_NAME_new_index OPENSSL_MANGLER(OBJ_NAME_new_index)
# endif
#else
# ifndef _OBJ_NAME_new_index
#  define _OBJ_NAME_new_index OPENSSL_MANGLER_ASM(OBJ_NAME_new_index)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_NAME_remove
#  define OBJ_NAME_remove OPENSSL_MANGLER(OBJ_NAME_remove)
# endif
#else
# ifndef _OBJ_NAME_remove
#  define _OBJ_NAME_remove OPENSSL_MANGLER_ASM(OBJ_NAME_remove)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_new_nid
#  define OBJ_new_nid OPENSSL_MANGLER(OBJ_new_nid)
# endif
#else
# ifndef _OBJ_new_nid
#  define _OBJ_new_nid OPENSSL_MANGLER_ASM(OBJ_new_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_nid2ln
#  define OBJ_nid2ln OPENSSL_MANGLER(OBJ_nid2ln)
# endif
#else
# ifndef _OBJ_nid2ln
#  define _OBJ_nid2ln OPENSSL_MANGLER_ASM(OBJ_nid2ln)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_nid2obj
#  define OBJ_nid2obj OPENSSL_MANGLER(OBJ_nid2obj)
# endif
#else
# ifndef _OBJ_nid2obj
#  define _OBJ_nid2obj OPENSSL_MANGLER_ASM(OBJ_nid2obj)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_nid2sn
#  define OBJ_nid2sn OPENSSL_MANGLER(OBJ_nid2sn)
# endif
#else
# ifndef _OBJ_nid2sn
#  define _OBJ_nid2sn OPENSSL_MANGLER_ASM(OBJ_nid2sn)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_obj2nid
#  define OBJ_obj2nid OPENSSL_MANGLER(OBJ_obj2nid)
# endif
#else
# ifndef _OBJ_obj2nid
#  define _OBJ_obj2nid OPENSSL_MANGLER_ASM(OBJ_obj2nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_obj2txt
#  define OBJ_obj2txt OPENSSL_MANGLER(OBJ_obj2txt)
# endif
#else
# ifndef _OBJ_obj2txt
#  define _OBJ_obj2txt OPENSSL_MANGLER_ASM(OBJ_obj2txt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_sigid_free
#  define OBJ_sigid_free OPENSSL_MANGLER(OBJ_sigid_free)
# endif
#else
# ifndef _OBJ_sigid_free
#  define _OBJ_sigid_free OPENSSL_MANGLER_ASM(OBJ_sigid_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_sn2nid
#  define OBJ_sn2nid OPENSSL_MANGLER(OBJ_sn2nid)
# endif
#else
# ifndef _OBJ_sn2nid
#  define _OBJ_sn2nid OPENSSL_MANGLER_ASM(OBJ_sn2nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_txt2nid
#  define OBJ_txt2nid OPENSSL_MANGLER(OBJ_txt2nid)
# endif
#else
# ifndef _OBJ_txt2nid
#  define _OBJ_txt2nid OPENSSL_MANGLER_ASM(OBJ_txt2nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OBJ_txt2obj
#  define OBJ_txt2obj OPENSSL_MANGLER(OBJ_txt2obj)
# endif
#else
# ifndef _OBJ_txt2obj
#  define _OBJ_txt2obj OPENSSL_MANGLER_ASM(OBJ_txt2obj)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_accept_responses_new
#  define OCSP_accept_responses_new OPENSSL_MANGLER(OCSP_accept_responses_new)
# endif
#else
# ifndef _OCSP_accept_responses_new
#  define _OCSP_accept_responses_new OPENSSL_MANGLER_ASM(OCSP_accept_responses_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_archive_cutoff_new
#  define OCSP_archive_cutoff_new OPENSSL_MANGLER(OCSP_archive_cutoff_new)
# endif
#else
# ifndef _OCSP_archive_cutoff_new
#  define _OCSP_archive_cutoff_new OPENSSL_MANGLER_ASM(OCSP_archive_cutoff_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_basic_add1_cert
#  define OCSP_basic_add1_cert OPENSSL_MANGLER(OCSP_basic_add1_cert)
# endif
#else
# ifndef _OCSP_basic_add1_cert
#  define _OCSP_basic_add1_cert OPENSSL_MANGLER_ASM(OCSP_basic_add1_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_basic_add1_nonce
#  define OCSP_basic_add1_nonce OPENSSL_MANGLER(OCSP_basic_add1_nonce)
# endif
#else
# ifndef _OCSP_basic_add1_nonce
#  define _OCSP_basic_add1_nonce OPENSSL_MANGLER_ASM(OCSP_basic_add1_nonce)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_basic_add1_status
#  define OCSP_basic_add1_status OPENSSL_MANGLER(OCSP_basic_add1_status)
# endif
#else
# ifndef _OCSP_basic_add1_status
#  define _OCSP_basic_add1_status OPENSSL_MANGLER_ASM(OCSP_basic_add1_status)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_add1_ext_i2d
#  define OCSP_BASICRESP_add1_ext_i2d OPENSSL_MANGLER(OCSP_BASICRESP_add1_ext_i2d)
# endif
#else
# ifndef _OCSP_BASICRESP_add1_ext_i2d
#  define _OCSP_BASICRESP_add1_ext_i2d OPENSSL_MANGLER_ASM(OCSP_BASICRESP_add1_ext_i2d)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_add_ext
#  define OCSP_BASICRESP_add_ext OPENSSL_MANGLER(OCSP_BASICRESP_add_ext)
# endif
#else
# ifndef _OCSP_BASICRESP_add_ext
#  define _OCSP_BASICRESP_add_ext OPENSSL_MANGLER_ASM(OCSP_BASICRESP_add_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_delete_ext
#  define OCSP_BASICRESP_delete_ext OPENSSL_MANGLER(OCSP_BASICRESP_delete_ext)
# endif
#else
# ifndef _OCSP_BASICRESP_delete_ext
#  define _OCSP_BASICRESP_delete_ext OPENSSL_MANGLER_ASM(OCSP_BASICRESP_delete_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_free
#  define OCSP_BASICRESP_free OPENSSL_MANGLER(OCSP_BASICRESP_free)
# endif
#else
# ifndef _OCSP_BASICRESP_free
#  define _OCSP_BASICRESP_free OPENSSL_MANGLER_ASM(OCSP_BASICRESP_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_get1_ext_d2i
#  define OCSP_BASICRESP_get1_ext_d2i OPENSSL_MANGLER(OCSP_BASICRESP_get1_ext_d2i)
# endif
#else
# ifndef _OCSP_BASICRESP_get1_ext_d2i
#  define _OCSP_BASICRESP_get1_ext_d2i OPENSSL_MANGLER_ASM(OCSP_BASICRESP_get1_ext_d2i)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_get_ext
#  define OCSP_BASICRESP_get_ext OPENSSL_MANGLER(OCSP_BASICRESP_get_ext)
# endif
#else
# ifndef _OCSP_BASICRESP_get_ext
#  define _OCSP_BASICRESP_get_ext OPENSSL_MANGLER_ASM(OCSP_BASICRESP_get_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_get_ext_by_critical
#  define OCSP_BASICRESP_get_ext_by_critical OPENSSL_MANGLER(OCSP_BASICRESP_get_ext_by_critical)
# endif
#else
# ifndef _OCSP_BASICRESP_get_ext_by_critical
#  define _OCSP_BASICRESP_get_ext_by_critical OPENSSL_MANGLER_ASM(OCSP_BASICRESP_get_ext_by_critical)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_get_ext_by_NID
#  define OCSP_BASICRESP_get_ext_by_NID OPENSSL_MANGLER(OCSP_BASICRESP_get_ext_by_NID)
# endif
#else
# ifndef _OCSP_BASICRESP_get_ext_by_NID
#  define _OCSP_BASICRESP_get_ext_by_NID OPENSSL_MANGLER_ASM(OCSP_BASICRESP_get_ext_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_get_ext_by_OBJ
#  define OCSP_BASICRESP_get_ext_by_OBJ OPENSSL_MANGLER(OCSP_BASICRESP_get_ext_by_OBJ)
# endif
#else
# ifndef _OCSP_BASICRESP_get_ext_by_OBJ
#  define _OCSP_BASICRESP_get_ext_by_OBJ OPENSSL_MANGLER_ASM(OCSP_BASICRESP_get_ext_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_get_ext_count
#  define OCSP_BASICRESP_get_ext_count OPENSSL_MANGLER(OCSP_BASICRESP_get_ext_count)
# endif
#else
# ifndef _OCSP_BASICRESP_get_ext_count
#  define _OCSP_BASICRESP_get_ext_count OPENSSL_MANGLER_ASM(OCSP_BASICRESP_get_ext_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_it
#  define OCSP_BASICRESP_it OPENSSL_MANGLER(OCSP_BASICRESP_it)
# endif
#else
# ifndef _OCSP_BASICRESP_it
#  define _OCSP_BASICRESP_it OPENSSL_MANGLER_ASM(OCSP_BASICRESP_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_BASICRESP_new
#  define OCSP_BASICRESP_new OPENSSL_MANGLER(OCSP_BASICRESP_new)
# endif
#else
# ifndef _OCSP_BASICRESP_new
#  define _OCSP_BASICRESP_new OPENSSL_MANGLER_ASM(OCSP_BASICRESP_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_basic_sign
#  define OCSP_basic_sign OPENSSL_MANGLER(OCSP_basic_sign)
# endif
#else
# ifndef _OCSP_basic_sign
#  define _OCSP_basic_sign OPENSSL_MANGLER_ASM(OCSP_basic_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_basic_sign_ctx
#  define OCSP_basic_sign_ctx OPENSSL_MANGLER(OCSP_basic_sign_ctx)
# endif
#else
# ifndef _OCSP_basic_sign_ctx
#  define _OCSP_basic_sign_ctx OPENSSL_MANGLER_ASM(OCSP_basic_sign_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_basic_verify
#  define OCSP_basic_verify OPENSSL_MANGLER(OCSP_basic_verify)
# endif
#else
# ifndef _OCSP_basic_verify
#  define _OCSP_basic_verify OPENSSL_MANGLER_ASM(OCSP_basic_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_CERTID_dup
#  define OCSP_CERTID_dup OPENSSL_MANGLER(OCSP_CERTID_dup)
# endif
#else
# ifndef _OCSP_CERTID_dup
#  define _OCSP_CERTID_dup OPENSSL_MANGLER_ASM(OCSP_CERTID_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_CERTID_free
#  define OCSP_CERTID_free OPENSSL_MANGLER(OCSP_CERTID_free)
# endif
#else
# ifndef _OCSP_CERTID_free
#  define _OCSP_CERTID_free OPENSSL_MANGLER_ASM(OCSP_CERTID_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_CERTID_it
#  define OCSP_CERTID_it OPENSSL_MANGLER(OCSP_CERTID_it)
# endif
#else
# ifndef _OCSP_CERTID_it
#  define _OCSP_CERTID_it OPENSSL_MANGLER_ASM(OCSP_CERTID_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_cert_id_new
#  define OCSP_cert_id_new OPENSSL_MANGLER(OCSP_cert_id_new)
# endif
#else
# ifndef _OCSP_cert_id_new
#  define _OCSP_cert_id_new OPENSSL_MANGLER_ASM(OCSP_cert_id_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_CERTID_new
#  define OCSP_CERTID_new OPENSSL_MANGLER(OCSP_CERTID_new)
# endif
#else
# ifndef _OCSP_CERTID_new
#  define _OCSP_CERTID_new OPENSSL_MANGLER_ASM(OCSP_CERTID_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_CERTSTATUS_free
#  define OCSP_CERTSTATUS_free OPENSSL_MANGLER(OCSP_CERTSTATUS_free)
# endif
#else
# ifndef _OCSP_CERTSTATUS_free
#  define _OCSP_CERTSTATUS_free OPENSSL_MANGLER_ASM(OCSP_CERTSTATUS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_CERTSTATUS_it
#  define OCSP_CERTSTATUS_it OPENSSL_MANGLER(OCSP_CERTSTATUS_it)
# endif
#else
# ifndef _OCSP_CERTSTATUS_it
#  define _OCSP_CERTSTATUS_it OPENSSL_MANGLER_ASM(OCSP_CERTSTATUS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_CERTSTATUS_new
#  define OCSP_CERTSTATUS_new OPENSSL_MANGLER(OCSP_CERTSTATUS_new)
# endif
#else
# ifndef _OCSP_CERTSTATUS_new
#  define _OCSP_CERTSTATUS_new OPENSSL_MANGLER_ASM(OCSP_CERTSTATUS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_cert_status_str
#  define OCSP_cert_status_str OPENSSL_MANGLER(OCSP_cert_status_str)
# endif
#else
# ifndef _OCSP_cert_status_str
#  define _OCSP_cert_status_str OPENSSL_MANGLER_ASM(OCSP_cert_status_str)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_cert_to_id
#  define OCSP_cert_to_id OPENSSL_MANGLER(OCSP_cert_to_id)
# endif
#else
# ifndef _OCSP_cert_to_id
#  define _OCSP_cert_to_id OPENSSL_MANGLER_ASM(OCSP_cert_to_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_check_nonce
#  define OCSP_check_nonce OPENSSL_MANGLER(OCSP_check_nonce)
# endif
#else
# ifndef _OCSP_check_nonce
#  define _OCSP_check_nonce OPENSSL_MANGLER_ASM(OCSP_check_nonce)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_check_validity
#  define OCSP_check_validity OPENSSL_MANGLER(OCSP_check_validity)
# endif
#else
# ifndef _OCSP_check_validity
#  define _OCSP_check_validity OPENSSL_MANGLER_ASM(OCSP_check_validity)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_copy_nonce
#  define OCSP_copy_nonce OPENSSL_MANGLER(OCSP_copy_nonce)
# endif
#else
# ifndef _OCSP_copy_nonce
#  define _OCSP_copy_nonce OPENSSL_MANGLER_ASM(OCSP_copy_nonce)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_CRLID_free
#  define OCSP_CRLID_free OPENSSL_MANGLER(OCSP_CRLID_free)
# endif
#else
# ifndef _OCSP_CRLID_free
#  define _OCSP_CRLID_free OPENSSL_MANGLER_ASM(OCSP_CRLID_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_CRLID_it
#  define OCSP_CRLID_it OPENSSL_MANGLER(OCSP_CRLID_it)
# endif
#else
# ifndef _OCSP_CRLID_it
#  define _OCSP_CRLID_it OPENSSL_MANGLER_ASM(OCSP_CRLID_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_crlID_new
#  define OCSP_crlID_new OPENSSL_MANGLER(OCSP_crlID_new)
# endif
#else
# ifndef _OCSP_crlID_new
#  define _OCSP_crlID_new OPENSSL_MANGLER_ASM(OCSP_crlID_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_CRLID_new
#  define OCSP_CRLID_new OPENSSL_MANGLER(OCSP_CRLID_new)
# endif
#else
# ifndef _OCSP_CRLID_new
#  define _OCSP_CRLID_new OPENSSL_MANGLER_ASM(OCSP_CRLID_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_crl_reason_str
#  define OCSP_crl_reason_str OPENSSL_MANGLER(OCSP_crl_reason_str)
# endif
#else
# ifndef _OCSP_crl_reason_str
#  define _OCSP_crl_reason_str OPENSSL_MANGLER_ASM(OCSP_crl_reason_str)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_id_cmp
#  define OCSP_id_cmp OPENSSL_MANGLER(OCSP_id_cmp)
# endif
#else
# ifndef _OCSP_id_cmp
#  define _OCSP_id_cmp OPENSSL_MANGLER_ASM(OCSP_id_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_id_get0_info
#  define OCSP_id_get0_info OPENSSL_MANGLER(OCSP_id_get0_info)
# endif
#else
# ifndef _OCSP_id_get0_info
#  define _OCSP_id_get0_info OPENSSL_MANGLER_ASM(OCSP_id_get0_info)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_id_issuer_cmp
#  define OCSP_id_issuer_cmp OPENSSL_MANGLER(OCSP_id_issuer_cmp)
# endif
#else
# ifndef _OCSP_id_issuer_cmp
#  define _OCSP_id_issuer_cmp OPENSSL_MANGLER_ASM(OCSP_id_issuer_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_add1_ext_i2d
#  define OCSP_ONEREQ_add1_ext_i2d OPENSSL_MANGLER(OCSP_ONEREQ_add1_ext_i2d)
# endif
#else
# ifndef _OCSP_ONEREQ_add1_ext_i2d
#  define _OCSP_ONEREQ_add1_ext_i2d OPENSSL_MANGLER_ASM(OCSP_ONEREQ_add1_ext_i2d)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_add_ext
#  define OCSP_ONEREQ_add_ext OPENSSL_MANGLER(OCSP_ONEREQ_add_ext)
# endif
#else
# ifndef _OCSP_ONEREQ_add_ext
#  define _OCSP_ONEREQ_add_ext OPENSSL_MANGLER_ASM(OCSP_ONEREQ_add_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_delete_ext
#  define OCSP_ONEREQ_delete_ext OPENSSL_MANGLER(OCSP_ONEREQ_delete_ext)
# endif
#else
# ifndef _OCSP_ONEREQ_delete_ext
#  define _OCSP_ONEREQ_delete_ext OPENSSL_MANGLER_ASM(OCSP_ONEREQ_delete_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_free
#  define OCSP_ONEREQ_free OPENSSL_MANGLER(OCSP_ONEREQ_free)
# endif
#else
# ifndef _OCSP_ONEREQ_free
#  define _OCSP_ONEREQ_free OPENSSL_MANGLER_ASM(OCSP_ONEREQ_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_onereq_get0_id
#  define OCSP_onereq_get0_id OPENSSL_MANGLER(OCSP_onereq_get0_id)
# endif
#else
# ifndef _OCSP_onereq_get0_id
#  define _OCSP_onereq_get0_id OPENSSL_MANGLER_ASM(OCSP_onereq_get0_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_get1_ext_d2i
#  define OCSP_ONEREQ_get1_ext_d2i OPENSSL_MANGLER(OCSP_ONEREQ_get1_ext_d2i)
# endif
#else
# ifndef _OCSP_ONEREQ_get1_ext_d2i
#  define _OCSP_ONEREQ_get1_ext_d2i OPENSSL_MANGLER_ASM(OCSP_ONEREQ_get1_ext_d2i)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_get_ext
#  define OCSP_ONEREQ_get_ext OPENSSL_MANGLER(OCSP_ONEREQ_get_ext)
# endif
#else
# ifndef _OCSP_ONEREQ_get_ext
#  define _OCSP_ONEREQ_get_ext OPENSSL_MANGLER_ASM(OCSP_ONEREQ_get_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_get_ext_by_critical
#  define OCSP_ONEREQ_get_ext_by_critical OPENSSL_MANGLER(OCSP_ONEREQ_get_ext_by_critical)
# endif
#else
# ifndef _OCSP_ONEREQ_get_ext_by_critical
#  define _OCSP_ONEREQ_get_ext_by_critical OPENSSL_MANGLER_ASM(OCSP_ONEREQ_get_ext_by_critical)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_get_ext_by_NID
#  define OCSP_ONEREQ_get_ext_by_NID OPENSSL_MANGLER(OCSP_ONEREQ_get_ext_by_NID)
# endif
#else
# ifndef _OCSP_ONEREQ_get_ext_by_NID
#  define _OCSP_ONEREQ_get_ext_by_NID OPENSSL_MANGLER_ASM(OCSP_ONEREQ_get_ext_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_get_ext_by_OBJ
#  define OCSP_ONEREQ_get_ext_by_OBJ OPENSSL_MANGLER(OCSP_ONEREQ_get_ext_by_OBJ)
# endif
#else
# ifndef _OCSP_ONEREQ_get_ext_by_OBJ
#  define _OCSP_ONEREQ_get_ext_by_OBJ OPENSSL_MANGLER_ASM(OCSP_ONEREQ_get_ext_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_get_ext_count
#  define OCSP_ONEREQ_get_ext_count OPENSSL_MANGLER(OCSP_ONEREQ_get_ext_count)
# endif
#else
# ifndef _OCSP_ONEREQ_get_ext_count
#  define _OCSP_ONEREQ_get_ext_count OPENSSL_MANGLER_ASM(OCSP_ONEREQ_get_ext_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_it
#  define OCSP_ONEREQ_it OPENSSL_MANGLER(OCSP_ONEREQ_it)
# endif
#else
# ifndef _OCSP_ONEREQ_it
#  define _OCSP_ONEREQ_it OPENSSL_MANGLER_ASM(OCSP_ONEREQ_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_ONEREQ_new
#  define OCSP_ONEREQ_new OPENSSL_MANGLER(OCSP_ONEREQ_new)
# endif
#else
# ifndef _OCSP_ONEREQ_new
#  define _OCSP_ONEREQ_new OPENSSL_MANGLER_ASM(OCSP_ONEREQ_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_parse_url
#  define OCSP_parse_url OPENSSL_MANGLER(OCSP_parse_url)
# endif
#else
# ifndef _OCSP_parse_url
#  define _OCSP_parse_url OPENSSL_MANGLER_ASM(OCSP_parse_url)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQ_CTX_add1_header
#  define OCSP_REQ_CTX_add1_header OPENSSL_MANGLER(OCSP_REQ_CTX_add1_header)
# endif
#else
# ifndef _OCSP_REQ_CTX_add1_header
#  define _OCSP_REQ_CTX_add1_header OPENSSL_MANGLER_ASM(OCSP_REQ_CTX_add1_header)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQ_CTX_free
#  define OCSP_REQ_CTX_free OPENSSL_MANGLER(OCSP_REQ_CTX_free)
# endif
#else
# ifndef _OCSP_REQ_CTX_free
#  define _OCSP_REQ_CTX_free OPENSSL_MANGLER_ASM(OCSP_REQ_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQ_CTX_get0_mem_bio
#  define OCSP_REQ_CTX_get0_mem_bio OPENSSL_MANGLER(OCSP_REQ_CTX_get0_mem_bio)
# endif
#else
# ifndef _OCSP_REQ_CTX_get0_mem_bio
#  define _OCSP_REQ_CTX_get0_mem_bio OPENSSL_MANGLER_ASM(OCSP_REQ_CTX_get0_mem_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQ_CTX_http
#  define OCSP_REQ_CTX_http OPENSSL_MANGLER(OCSP_REQ_CTX_http)
# endif
#else
# ifndef _OCSP_REQ_CTX_http
#  define _OCSP_REQ_CTX_http OPENSSL_MANGLER_ASM(OCSP_REQ_CTX_http)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQ_CTX_i2d
#  define OCSP_REQ_CTX_i2d OPENSSL_MANGLER(OCSP_REQ_CTX_i2d)
# endif
#else
# ifndef _OCSP_REQ_CTX_i2d
#  define _OCSP_REQ_CTX_i2d OPENSSL_MANGLER_ASM(OCSP_REQ_CTX_i2d)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQ_CTX_nbio
#  define OCSP_REQ_CTX_nbio OPENSSL_MANGLER(OCSP_REQ_CTX_nbio)
# endif
#else
# ifndef _OCSP_REQ_CTX_nbio
#  define _OCSP_REQ_CTX_nbio OPENSSL_MANGLER_ASM(OCSP_REQ_CTX_nbio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQ_CTX_nbio_d2i
#  define OCSP_REQ_CTX_nbio_d2i OPENSSL_MANGLER(OCSP_REQ_CTX_nbio_d2i)
# endif
#else
# ifndef _OCSP_REQ_CTX_nbio_d2i
#  define _OCSP_REQ_CTX_nbio_d2i OPENSSL_MANGLER_ASM(OCSP_REQ_CTX_nbio_d2i)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQ_CTX_new
#  define OCSP_REQ_CTX_new OPENSSL_MANGLER(OCSP_REQ_CTX_new)
# endif
#else
# ifndef _OCSP_REQ_CTX_new
#  define _OCSP_REQ_CTX_new OPENSSL_MANGLER_ASM(OCSP_REQ_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQ_CTX_set1_req
#  define OCSP_REQ_CTX_set1_req OPENSSL_MANGLER(OCSP_REQ_CTX_set1_req)
# endif
#else
# ifndef _OCSP_REQ_CTX_set1_req
#  define _OCSP_REQ_CTX_set1_req OPENSSL_MANGLER_ASM(OCSP_REQ_CTX_set1_req)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQINFO_free
#  define OCSP_REQINFO_free OPENSSL_MANGLER(OCSP_REQINFO_free)
# endif
#else
# ifndef _OCSP_REQINFO_free
#  define _OCSP_REQINFO_free OPENSSL_MANGLER_ASM(OCSP_REQINFO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQINFO_it
#  define OCSP_REQINFO_it OPENSSL_MANGLER(OCSP_REQINFO_it)
# endif
#else
# ifndef _OCSP_REQINFO_it
#  define _OCSP_REQINFO_it OPENSSL_MANGLER_ASM(OCSP_REQINFO_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQINFO_new
#  define OCSP_REQINFO_new OPENSSL_MANGLER(OCSP_REQINFO_new)
# endif
#else
# ifndef _OCSP_REQINFO_new
#  define _OCSP_REQINFO_new OPENSSL_MANGLER_ASM(OCSP_REQINFO_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_request_add0_id
#  define OCSP_request_add0_id OPENSSL_MANGLER(OCSP_request_add0_id)
# endif
#else
# ifndef _OCSP_request_add0_id
#  define _OCSP_request_add0_id OPENSSL_MANGLER_ASM(OCSP_request_add0_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_request_add1_cert
#  define OCSP_request_add1_cert OPENSSL_MANGLER(OCSP_request_add1_cert)
# endif
#else
# ifndef _OCSP_request_add1_cert
#  define _OCSP_request_add1_cert OPENSSL_MANGLER_ASM(OCSP_request_add1_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_add1_ext_i2d
#  define OCSP_REQUEST_add1_ext_i2d OPENSSL_MANGLER(OCSP_REQUEST_add1_ext_i2d)
# endif
#else
# ifndef _OCSP_REQUEST_add1_ext_i2d
#  define _OCSP_REQUEST_add1_ext_i2d OPENSSL_MANGLER_ASM(OCSP_REQUEST_add1_ext_i2d)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_request_add1_nonce
#  define OCSP_request_add1_nonce OPENSSL_MANGLER(OCSP_request_add1_nonce)
# endif
#else
# ifndef _OCSP_request_add1_nonce
#  define _OCSP_request_add1_nonce OPENSSL_MANGLER_ASM(OCSP_request_add1_nonce)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_add_ext
#  define OCSP_REQUEST_add_ext OPENSSL_MANGLER(OCSP_REQUEST_add_ext)
# endif
#else
# ifndef _OCSP_REQUEST_add_ext
#  define _OCSP_REQUEST_add_ext OPENSSL_MANGLER_ASM(OCSP_REQUEST_add_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_delete_ext
#  define OCSP_REQUEST_delete_ext OPENSSL_MANGLER(OCSP_REQUEST_delete_ext)
# endif
#else
# ifndef _OCSP_REQUEST_delete_ext
#  define _OCSP_REQUEST_delete_ext OPENSSL_MANGLER_ASM(OCSP_REQUEST_delete_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_free
#  define OCSP_REQUEST_free OPENSSL_MANGLER(OCSP_REQUEST_free)
# endif
#else
# ifndef _OCSP_REQUEST_free
#  define _OCSP_REQUEST_free OPENSSL_MANGLER_ASM(OCSP_REQUEST_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_get1_ext_d2i
#  define OCSP_REQUEST_get1_ext_d2i OPENSSL_MANGLER(OCSP_REQUEST_get1_ext_d2i)
# endif
#else
# ifndef _OCSP_REQUEST_get1_ext_d2i
#  define _OCSP_REQUEST_get1_ext_d2i OPENSSL_MANGLER_ASM(OCSP_REQUEST_get1_ext_d2i)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_get_ext
#  define OCSP_REQUEST_get_ext OPENSSL_MANGLER(OCSP_REQUEST_get_ext)
# endif
#else
# ifndef _OCSP_REQUEST_get_ext
#  define _OCSP_REQUEST_get_ext OPENSSL_MANGLER_ASM(OCSP_REQUEST_get_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_get_ext_by_critical
#  define OCSP_REQUEST_get_ext_by_critical OPENSSL_MANGLER(OCSP_REQUEST_get_ext_by_critical)
# endif
#else
# ifndef _OCSP_REQUEST_get_ext_by_critical
#  define _OCSP_REQUEST_get_ext_by_critical OPENSSL_MANGLER_ASM(OCSP_REQUEST_get_ext_by_critical)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_get_ext_by_NID
#  define OCSP_REQUEST_get_ext_by_NID OPENSSL_MANGLER(OCSP_REQUEST_get_ext_by_NID)
# endif
#else
# ifndef _OCSP_REQUEST_get_ext_by_NID
#  define _OCSP_REQUEST_get_ext_by_NID OPENSSL_MANGLER_ASM(OCSP_REQUEST_get_ext_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_get_ext_by_OBJ
#  define OCSP_REQUEST_get_ext_by_OBJ OPENSSL_MANGLER(OCSP_REQUEST_get_ext_by_OBJ)
# endif
#else
# ifndef _OCSP_REQUEST_get_ext_by_OBJ
#  define _OCSP_REQUEST_get_ext_by_OBJ OPENSSL_MANGLER_ASM(OCSP_REQUEST_get_ext_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_get_ext_count
#  define OCSP_REQUEST_get_ext_count OPENSSL_MANGLER(OCSP_REQUEST_get_ext_count)
# endif
#else
# ifndef _OCSP_REQUEST_get_ext_count
#  define _OCSP_REQUEST_get_ext_count OPENSSL_MANGLER_ASM(OCSP_REQUEST_get_ext_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_request_is_signed
#  define OCSP_request_is_signed OPENSSL_MANGLER(OCSP_request_is_signed)
# endif
#else
# ifndef _OCSP_request_is_signed
#  define _OCSP_request_is_signed OPENSSL_MANGLER_ASM(OCSP_request_is_signed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_it
#  define OCSP_REQUEST_it OPENSSL_MANGLER(OCSP_REQUEST_it)
# endif
#else
# ifndef _OCSP_REQUEST_it
#  define _OCSP_REQUEST_it OPENSSL_MANGLER_ASM(OCSP_REQUEST_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_new
#  define OCSP_REQUEST_new OPENSSL_MANGLER(OCSP_REQUEST_new)
# endif
#else
# ifndef _OCSP_REQUEST_new
#  define _OCSP_REQUEST_new OPENSSL_MANGLER_ASM(OCSP_REQUEST_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_request_onereq_count
#  define OCSP_request_onereq_count OPENSSL_MANGLER(OCSP_request_onereq_count)
# endif
#else
# ifndef _OCSP_request_onereq_count
#  define _OCSP_request_onereq_count OPENSSL_MANGLER_ASM(OCSP_request_onereq_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_request_onereq_get0
#  define OCSP_request_onereq_get0 OPENSSL_MANGLER(OCSP_request_onereq_get0)
# endif
#else
# ifndef _OCSP_request_onereq_get0
#  define _OCSP_request_onereq_get0 OPENSSL_MANGLER_ASM(OCSP_request_onereq_get0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REQUEST_print
#  define OCSP_REQUEST_print OPENSSL_MANGLER(OCSP_REQUEST_print)
# endif
#else
# ifndef _OCSP_REQUEST_print
#  define _OCSP_REQUEST_print OPENSSL_MANGLER_ASM(OCSP_REQUEST_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_request_set1_name
#  define OCSP_request_set1_name OPENSSL_MANGLER(OCSP_request_set1_name)
# endif
#else
# ifndef _OCSP_request_set1_name
#  define _OCSP_request_set1_name OPENSSL_MANGLER_ASM(OCSP_request_set1_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_request_sign
#  define OCSP_request_sign OPENSSL_MANGLER(OCSP_request_sign)
# endif
#else
# ifndef _OCSP_request_sign
#  define _OCSP_request_sign OPENSSL_MANGLER_ASM(OCSP_request_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_request_verify
#  define OCSP_request_verify OPENSSL_MANGLER(OCSP_request_verify)
# endif
#else
# ifndef _OCSP_request_verify
#  define _OCSP_request_verify OPENSSL_MANGLER_ASM(OCSP_request_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPBYTES_free
#  define OCSP_RESPBYTES_free OPENSSL_MANGLER(OCSP_RESPBYTES_free)
# endif
#else
# ifndef _OCSP_RESPBYTES_free
#  define _OCSP_RESPBYTES_free OPENSSL_MANGLER_ASM(OCSP_RESPBYTES_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPBYTES_it
#  define OCSP_RESPBYTES_it OPENSSL_MANGLER(OCSP_RESPBYTES_it)
# endif
#else
# ifndef _OCSP_RESPBYTES_it
#  define _OCSP_RESPBYTES_it OPENSSL_MANGLER_ASM(OCSP_RESPBYTES_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPBYTES_new
#  define OCSP_RESPBYTES_new OPENSSL_MANGLER(OCSP_RESPBYTES_new)
# endif
#else
# ifndef _OCSP_RESPBYTES_new
#  define _OCSP_RESPBYTES_new OPENSSL_MANGLER_ASM(OCSP_RESPBYTES_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_count
#  define OCSP_resp_count OPENSSL_MANGLER(OCSP_resp_count)
# endif
#else
# ifndef _OCSP_resp_count
#  define _OCSP_resp_count OPENSSL_MANGLER_ASM(OCSP_resp_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPDATA_free
#  define OCSP_RESPDATA_free OPENSSL_MANGLER(OCSP_RESPDATA_free)
# endif
#else
# ifndef _OCSP_RESPDATA_free
#  define _OCSP_RESPDATA_free OPENSSL_MANGLER_ASM(OCSP_RESPDATA_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPDATA_it
#  define OCSP_RESPDATA_it OPENSSL_MANGLER(OCSP_RESPDATA_it)
# endif
#else
# ifndef _OCSP_RESPDATA_it
#  define _OCSP_RESPDATA_it OPENSSL_MANGLER_ASM(OCSP_RESPDATA_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPDATA_new
#  define OCSP_RESPDATA_new OPENSSL_MANGLER(OCSP_RESPDATA_new)
# endif
#else
# ifndef _OCSP_RESPDATA_new
#  define _OCSP_RESPDATA_new OPENSSL_MANGLER_ASM(OCSP_RESPDATA_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_find
#  define OCSP_resp_find OPENSSL_MANGLER(OCSP_resp_find)
# endif
#else
# ifndef _OCSP_resp_find
#  define _OCSP_resp_find OPENSSL_MANGLER_ASM(OCSP_resp_find)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_find_status
#  define OCSP_resp_find_status OPENSSL_MANGLER(OCSP_resp_find_status)
# endif
#else
# ifndef _OCSP_resp_find_status
#  define _OCSP_resp_find_status OPENSSL_MANGLER_ASM(OCSP_resp_find_status)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_get0
#  define OCSP_resp_get0 OPENSSL_MANGLER(OCSP_resp_get0)
# endif
#else
# ifndef _OCSP_resp_get0
#  define _OCSP_resp_get0 OPENSSL_MANGLER_ASM(OCSP_resp_get0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_get0_certs
#  define OCSP_resp_get0_certs OPENSSL_MANGLER(OCSP_resp_get0_certs)
# endif
#else
# ifndef _OCSP_resp_get0_certs
#  define _OCSP_resp_get0_certs OPENSSL_MANGLER_ASM(OCSP_resp_get0_certs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_get0_id
#  define OCSP_resp_get0_id OPENSSL_MANGLER(OCSP_resp_get0_id)
# endif
#else
# ifndef _OCSP_resp_get0_id
#  define _OCSP_resp_get0_id OPENSSL_MANGLER_ASM(OCSP_resp_get0_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_get0_produced_at
#  define OCSP_resp_get0_produced_at OPENSSL_MANGLER(OCSP_resp_get0_produced_at)
# endif
#else
# ifndef _OCSP_resp_get0_produced_at
#  define _OCSP_resp_get0_produced_at OPENSSL_MANGLER_ASM(OCSP_resp_get0_produced_at)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_get0_respdata
#  define OCSP_resp_get0_respdata OPENSSL_MANGLER(OCSP_resp_get0_respdata)
# endif
#else
# ifndef _OCSP_resp_get0_respdata
#  define _OCSP_resp_get0_respdata OPENSSL_MANGLER_ASM(OCSP_resp_get0_respdata)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_get0_signature
#  define OCSP_resp_get0_signature OPENSSL_MANGLER(OCSP_resp_get0_signature)
# endif
#else
# ifndef _OCSP_resp_get0_signature
#  define _OCSP_resp_get0_signature OPENSSL_MANGLER_ASM(OCSP_resp_get0_signature)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_get0_signer
#  define OCSP_resp_get0_signer OPENSSL_MANGLER(OCSP_resp_get0_signer)
# endif
#else
# ifndef _OCSP_resp_get0_signer
#  define _OCSP_resp_get0_signer OPENSSL_MANGLER_ASM(OCSP_resp_get0_signer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_get0_tbs_sigalg
#  define OCSP_resp_get0_tbs_sigalg OPENSSL_MANGLER(OCSP_resp_get0_tbs_sigalg)
# endif
#else
# ifndef _OCSP_resp_get0_tbs_sigalg
#  define _OCSP_resp_get0_tbs_sigalg OPENSSL_MANGLER_ASM(OCSP_resp_get0_tbs_sigalg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_resp_get1_id
#  define OCSP_resp_get1_id OPENSSL_MANGLER(OCSP_resp_get1_id)
# endif
#else
# ifndef _OCSP_resp_get1_id
#  define _OCSP_resp_get1_id OPENSSL_MANGLER_ASM(OCSP_resp_get1_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPID_free
#  define OCSP_RESPID_free OPENSSL_MANGLER(OCSP_RESPID_free)
# endif
#else
# ifndef _OCSP_RESPID_free
#  define _OCSP_RESPID_free OPENSSL_MANGLER_ASM(OCSP_RESPID_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPID_it
#  define OCSP_RESPID_it OPENSSL_MANGLER(OCSP_RESPID_it)
# endif
#else
# ifndef _OCSP_RESPID_it
#  define _OCSP_RESPID_it OPENSSL_MANGLER_ASM(OCSP_RESPID_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPID_match
#  define OCSP_RESPID_match OPENSSL_MANGLER(OCSP_RESPID_match)
# endif
#else
# ifndef _OCSP_RESPID_match
#  define _OCSP_RESPID_match OPENSSL_MANGLER_ASM(OCSP_RESPID_match)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPID_new
#  define OCSP_RESPID_new OPENSSL_MANGLER(OCSP_RESPID_new)
# endif
#else
# ifndef _OCSP_RESPID_new
#  define _OCSP_RESPID_new OPENSSL_MANGLER_ASM(OCSP_RESPID_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPID_set_by_key
#  define OCSP_RESPID_set_by_key OPENSSL_MANGLER(OCSP_RESPID_set_by_key)
# endif
#else
# ifndef _OCSP_RESPID_set_by_key
#  define _OCSP_RESPID_set_by_key OPENSSL_MANGLER_ASM(OCSP_RESPID_set_by_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPID_set_by_name
#  define OCSP_RESPID_set_by_name OPENSSL_MANGLER(OCSP_RESPID_set_by_name)
# endif
#else
# ifndef _OCSP_RESPID_set_by_name
#  define _OCSP_RESPID_set_by_name OPENSSL_MANGLER_ASM(OCSP_RESPID_set_by_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_response_create
#  define OCSP_response_create OPENSSL_MANGLER(OCSP_response_create)
# endif
#else
# ifndef _OCSP_response_create
#  define _OCSP_response_create OPENSSL_MANGLER_ASM(OCSP_response_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPONSE_free
#  define OCSP_RESPONSE_free OPENSSL_MANGLER(OCSP_RESPONSE_free)
# endif
#else
# ifndef _OCSP_RESPONSE_free
#  define _OCSP_RESPONSE_free OPENSSL_MANGLER_ASM(OCSP_RESPONSE_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_response_get1_basic
#  define OCSP_response_get1_basic OPENSSL_MANGLER(OCSP_response_get1_basic)
# endif
#else
# ifndef _OCSP_response_get1_basic
#  define _OCSP_response_get1_basic OPENSSL_MANGLER_ASM(OCSP_response_get1_basic)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPONSE_it
#  define OCSP_RESPONSE_it OPENSSL_MANGLER(OCSP_RESPONSE_it)
# endif
#else
# ifndef _OCSP_RESPONSE_it
#  define _OCSP_RESPONSE_it OPENSSL_MANGLER_ASM(OCSP_RESPONSE_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPONSE_new
#  define OCSP_RESPONSE_new OPENSSL_MANGLER(OCSP_RESPONSE_new)
# endif
#else
# ifndef _OCSP_RESPONSE_new
#  define _OCSP_RESPONSE_new OPENSSL_MANGLER_ASM(OCSP_RESPONSE_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_RESPONSE_print
#  define OCSP_RESPONSE_print OPENSSL_MANGLER(OCSP_RESPONSE_print)
# endif
#else
# ifndef _OCSP_RESPONSE_print
#  define _OCSP_RESPONSE_print OPENSSL_MANGLER_ASM(OCSP_RESPONSE_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_response_status
#  define OCSP_response_status OPENSSL_MANGLER(OCSP_response_status)
# endif
#else
# ifndef _OCSP_response_status
#  define _OCSP_response_status OPENSSL_MANGLER_ASM(OCSP_response_status)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_response_status_str
#  define OCSP_response_status_str OPENSSL_MANGLER(OCSP_response_status_str)
# endif
#else
# ifndef _OCSP_response_status_str
#  define _OCSP_response_status_str OPENSSL_MANGLER_ASM(OCSP_response_status_str)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REVOKEDINFO_free
#  define OCSP_REVOKEDINFO_free OPENSSL_MANGLER(OCSP_REVOKEDINFO_free)
# endif
#else
# ifndef _OCSP_REVOKEDINFO_free
#  define _OCSP_REVOKEDINFO_free OPENSSL_MANGLER_ASM(OCSP_REVOKEDINFO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REVOKEDINFO_it
#  define OCSP_REVOKEDINFO_it OPENSSL_MANGLER(OCSP_REVOKEDINFO_it)
# endif
#else
# ifndef _OCSP_REVOKEDINFO_it
#  define _OCSP_REVOKEDINFO_it OPENSSL_MANGLER_ASM(OCSP_REVOKEDINFO_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_REVOKEDINFO_new
#  define OCSP_REVOKEDINFO_new OPENSSL_MANGLER(OCSP_REVOKEDINFO_new)
# endif
#else
# ifndef _OCSP_REVOKEDINFO_new
#  define _OCSP_REVOKEDINFO_new OPENSSL_MANGLER_ASM(OCSP_REVOKEDINFO_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_sendreq_bio
#  define OCSP_sendreq_bio OPENSSL_MANGLER(OCSP_sendreq_bio)
# endif
#else
# ifndef _OCSP_sendreq_bio
#  define _OCSP_sendreq_bio OPENSSL_MANGLER_ASM(OCSP_sendreq_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_sendreq_nbio
#  define OCSP_sendreq_nbio OPENSSL_MANGLER(OCSP_sendreq_nbio)
# endif
#else
# ifndef _OCSP_sendreq_nbio
#  define _OCSP_sendreq_nbio OPENSSL_MANGLER_ASM(OCSP_sendreq_nbio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_sendreq_new
#  define OCSP_sendreq_new OPENSSL_MANGLER(OCSP_sendreq_new)
# endif
#else
# ifndef _OCSP_sendreq_new
#  define _OCSP_sendreq_new OPENSSL_MANGLER_ASM(OCSP_sendreq_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SERVICELOC_free
#  define OCSP_SERVICELOC_free OPENSSL_MANGLER(OCSP_SERVICELOC_free)
# endif
#else
# ifndef _OCSP_SERVICELOC_free
#  define _OCSP_SERVICELOC_free OPENSSL_MANGLER_ASM(OCSP_SERVICELOC_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SERVICELOC_it
#  define OCSP_SERVICELOC_it OPENSSL_MANGLER(OCSP_SERVICELOC_it)
# endif
#else
# ifndef _OCSP_SERVICELOC_it
#  define _OCSP_SERVICELOC_it OPENSSL_MANGLER_ASM(OCSP_SERVICELOC_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SERVICELOC_new
#  define OCSP_SERVICELOC_new OPENSSL_MANGLER(OCSP_SERVICELOC_new)
# endif
#else
# ifndef _OCSP_SERVICELOC_new
#  define _OCSP_SERVICELOC_new OPENSSL_MANGLER_ASM(OCSP_SERVICELOC_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_set_max_response_length
#  define OCSP_set_max_response_length OPENSSL_MANGLER(OCSP_set_max_response_length)
# endif
#else
# ifndef _OCSP_set_max_response_length
#  define _OCSP_set_max_response_length OPENSSL_MANGLER_ASM(OCSP_set_max_response_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SIGNATURE_free
#  define OCSP_SIGNATURE_free OPENSSL_MANGLER(OCSP_SIGNATURE_free)
# endif
#else
# ifndef _OCSP_SIGNATURE_free
#  define _OCSP_SIGNATURE_free OPENSSL_MANGLER_ASM(OCSP_SIGNATURE_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SIGNATURE_it
#  define OCSP_SIGNATURE_it OPENSSL_MANGLER(OCSP_SIGNATURE_it)
# endif
#else
# ifndef _OCSP_SIGNATURE_it
#  define _OCSP_SIGNATURE_it OPENSSL_MANGLER_ASM(OCSP_SIGNATURE_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SIGNATURE_new
#  define OCSP_SIGNATURE_new OPENSSL_MANGLER(OCSP_SIGNATURE_new)
# endif
#else
# ifndef _OCSP_SIGNATURE_new
#  define _OCSP_SIGNATURE_new OPENSSL_MANGLER_ASM(OCSP_SIGNATURE_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_single_get0_status
#  define OCSP_single_get0_status OPENSSL_MANGLER(OCSP_single_get0_status)
# endif
#else
# ifndef _OCSP_single_get0_status
#  define _OCSP_single_get0_status OPENSSL_MANGLER_ASM(OCSP_single_get0_status)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_add1_ext_i2d
#  define OCSP_SINGLERESP_add1_ext_i2d OPENSSL_MANGLER(OCSP_SINGLERESP_add1_ext_i2d)
# endif
#else
# ifndef _OCSP_SINGLERESP_add1_ext_i2d
#  define _OCSP_SINGLERESP_add1_ext_i2d OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_add1_ext_i2d)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_add_ext
#  define OCSP_SINGLERESP_add_ext OPENSSL_MANGLER(OCSP_SINGLERESP_add_ext)
# endif
#else
# ifndef _OCSP_SINGLERESP_add_ext
#  define _OCSP_SINGLERESP_add_ext OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_add_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_delete_ext
#  define OCSP_SINGLERESP_delete_ext OPENSSL_MANGLER(OCSP_SINGLERESP_delete_ext)
# endif
#else
# ifndef _OCSP_SINGLERESP_delete_ext
#  define _OCSP_SINGLERESP_delete_ext OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_delete_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_free
#  define OCSP_SINGLERESP_free OPENSSL_MANGLER(OCSP_SINGLERESP_free)
# endif
#else
# ifndef _OCSP_SINGLERESP_free
#  define _OCSP_SINGLERESP_free OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_get0_id
#  define OCSP_SINGLERESP_get0_id OPENSSL_MANGLER(OCSP_SINGLERESP_get0_id)
# endif
#else
# ifndef _OCSP_SINGLERESP_get0_id
#  define _OCSP_SINGLERESP_get0_id OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_get0_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_get1_ext_d2i
#  define OCSP_SINGLERESP_get1_ext_d2i OPENSSL_MANGLER(OCSP_SINGLERESP_get1_ext_d2i)
# endif
#else
# ifndef _OCSP_SINGLERESP_get1_ext_d2i
#  define _OCSP_SINGLERESP_get1_ext_d2i OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_get1_ext_d2i)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_get_ext
#  define OCSP_SINGLERESP_get_ext OPENSSL_MANGLER(OCSP_SINGLERESP_get_ext)
# endif
#else
# ifndef _OCSP_SINGLERESP_get_ext
#  define _OCSP_SINGLERESP_get_ext OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_get_ext)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_get_ext_by_critical
#  define OCSP_SINGLERESP_get_ext_by_critical OPENSSL_MANGLER(OCSP_SINGLERESP_get_ext_by_critical)
# endif
#else
# ifndef _OCSP_SINGLERESP_get_ext_by_critical
#  define _OCSP_SINGLERESP_get_ext_by_critical OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_get_ext_by_critical)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_get_ext_by_NID
#  define OCSP_SINGLERESP_get_ext_by_NID OPENSSL_MANGLER(OCSP_SINGLERESP_get_ext_by_NID)
# endif
#else
# ifndef _OCSP_SINGLERESP_get_ext_by_NID
#  define _OCSP_SINGLERESP_get_ext_by_NID OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_get_ext_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_get_ext_by_OBJ
#  define OCSP_SINGLERESP_get_ext_by_OBJ OPENSSL_MANGLER(OCSP_SINGLERESP_get_ext_by_OBJ)
# endif
#else
# ifndef _OCSP_SINGLERESP_get_ext_by_OBJ
#  define _OCSP_SINGLERESP_get_ext_by_OBJ OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_get_ext_by_OBJ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_get_ext_count
#  define OCSP_SINGLERESP_get_ext_count OPENSSL_MANGLER(OCSP_SINGLERESP_get_ext_count)
# endif
#else
# ifndef _OCSP_SINGLERESP_get_ext_count
#  define _OCSP_SINGLERESP_get_ext_count OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_get_ext_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_it
#  define OCSP_SINGLERESP_it OPENSSL_MANGLER(OCSP_SINGLERESP_it)
# endif
#else
# ifndef _OCSP_SINGLERESP_it
#  define _OCSP_SINGLERESP_it OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_SINGLERESP_new
#  define OCSP_SINGLERESP_new OPENSSL_MANGLER(OCSP_SINGLERESP_new)
# endif
#else
# ifndef _OCSP_SINGLERESP_new
#  define _OCSP_SINGLERESP_new OPENSSL_MANGLER_ASM(OCSP_SINGLERESP_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OCSP_url_svcloc_new
#  define OCSP_url_svcloc_new OPENSSL_MANGLER(OCSP_url_svcloc_new)
# endif
#else
# ifndef _OCSP_url_svcloc_new
#  define _OCSP_url_svcloc_new OPENSSL_MANGLER_ASM(OCSP_url_svcloc_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef openssl_add_all_ciphers_int
#  define openssl_add_all_ciphers_int OPENSSL_MANGLER(openssl_add_all_ciphers_int)
# endif
#else
# ifndef _openssl_add_all_ciphers_int
#  define _openssl_add_all_ciphers_int OPENSSL_MANGLER_ASM(openssl_add_all_ciphers_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef openssl_add_all_digests_int
#  define openssl_add_all_digests_int OPENSSL_MANGLER(openssl_add_all_digests_int)
# endif
#else
# ifndef _openssl_add_all_digests_int
#  define _openssl_add_all_digests_int OPENSSL_MANGLER_ASM(openssl_add_all_digests_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_asc2uni
#  define OPENSSL_asc2uni OPENSSL_MANGLER(OPENSSL_asc2uni)
# endif
#else
# ifndef _OPENSSL_asc2uni
#  define _OPENSSL_asc2uni OPENSSL_MANGLER_ASM(OPENSSL_asc2uni)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_atexit
#  define OPENSSL_atexit OPENSSL_MANGLER(OPENSSL_atexit)
# endif
#else
# ifndef _OPENSSL_atexit
#  define _OPENSSL_atexit OPENSSL_MANGLER_ASM(OPENSSL_atexit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_atomic_add
#  define OPENSSL_atomic_add OPENSSL_MANGLER(OPENSSL_atomic_add)
# endif
#else
# ifndef _OPENSSL_atomic_add
#  define _OPENSSL_atomic_add OPENSSL_MANGLER_ASM(OPENSSL_atomic_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_buf2hexstr
#  define OPENSSL_buf2hexstr OPENSSL_MANGLER(OPENSSL_buf2hexstr)
# endif
#else
# ifndef _OPENSSL_buf2hexstr
#  define _OPENSSL_buf2hexstr OPENSSL_MANGLER_ASM(OPENSSL_buf2hexstr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_cipher_name
#  define OPENSSL_cipher_name OPENSSL_MANGLER(OPENSSL_cipher_name)
# endif
#else
# ifndef _OPENSSL_cipher_name
#  define _OPENSSL_cipher_name OPENSSL_MANGLER_ASM(OPENSSL_cipher_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_cleanse
#  define OPENSSL_cleanse OPENSSL_MANGLER(OPENSSL_cleanse)
# endif
#else
# ifndef _OPENSSL_cleanse
#  define _OPENSSL_cleanse OPENSSL_MANGLER_ASM(OPENSSL_cleanse)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_cleanup
#  define OPENSSL_cleanup OPENSSL_MANGLER(OPENSSL_cleanup)
# endif
#else
# ifndef _OPENSSL_cleanup
#  define _OPENSSL_cleanup OPENSSL_MANGLER_ASM(OPENSSL_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_config
#  define OPENSSL_config OPENSSL_MANGLER(OPENSSL_config)
# endif
#else
# ifndef _OPENSSL_config
#  define _OPENSSL_config OPENSSL_MANGLER_ASM(OPENSSL_config)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef openssl_config_int
#  define openssl_config_int OPENSSL_MANGLER(openssl_config_int)
# endif
#else
# ifndef _openssl_config_int
#  define _openssl_config_int OPENSSL_MANGLER_ASM(openssl_config_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_cpuid_setup
#  define OPENSSL_cpuid_setup OPENSSL_MANGLER(OPENSSL_cpuid_setup)
# endif
#else
# ifndef _OPENSSL_cpuid_setup
#  define _OPENSSL_cpuid_setup OPENSSL_MANGLER_ASM(OPENSSL_cpuid_setup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_die
#  define OPENSSL_die OPENSSL_MANGLER(OPENSSL_die)
# endif
#else
# ifndef _OPENSSL_die
#  define _OPENSSL_die OPENSSL_MANGLER_ASM(OPENSSL_die)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_DIR_end
#  define OPENSSL_DIR_end OPENSSL_MANGLER(OPENSSL_DIR_end)
# endif
#else
# ifndef _OPENSSL_DIR_end
#  define _OPENSSL_DIR_end OPENSSL_MANGLER_ASM(OPENSSL_DIR_end)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_DIR_read
#  define OPENSSL_DIR_read OPENSSL_MANGLER(OPENSSL_DIR_read)
# endif
#else
# ifndef _OPENSSL_DIR_read
#  define _OPENSSL_DIR_read OPENSSL_MANGLER_ASM(OPENSSL_DIR_read)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef openssl_fopen
#  define openssl_fopen OPENSSL_MANGLER(openssl_fopen)
# endif
#else
# ifndef _openssl_fopen
#  define _openssl_fopen OPENSSL_MANGLER_ASM(openssl_fopen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_fork_child
#  define OPENSSL_fork_child OPENSSL_MANGLER(OPENSSL_fork_child)
# endif
#else
# ifndef _OPENSSL_fork_child
#  define _OPENSSL_fork_child OPENSSL_MANGLER_ASM(OPENSSL_fork_child)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_fork_parent
#  define OPENSSL_fork_parent OPENSSL_MANGLER(OPENSSL_fork_parent)
# endif
#else
# ifndef _OPENSSL_fork_parent
#  define _OPENSSL_fork_parent OPENSSL_MANGLER_ASM(OPENSSL_fork_parent)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_fork_prepare
#  define OPENSSL_fork_prepare OPENSSL_MANGLER(OPENSSL_fork_prepare)
# endif
#else
# ifndef _OPENSSL_fork_prepare
#  define _OPENSSL_fork_prepare OPENSSL_MANGLER_ASM(OPENSSL_fork_prepare)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_gmtime
#  define OPENSSL_gmtime OPENSSL_MANGLER(OPENSSL_gmtime)
# endif
#else
# ifndef _OPENSSL_gmtime
#  define _OPENSSL_gmtime OPENSSL_MANGLER_ASM(OPENSSL_gmtime)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_gmtime_adj
#  define OPENSSL_gmtime_adj OPENSSL_MANGLER(OPENSSL_gmtime_adj)
# endif
#else
# ifndef _OPENSSL_gmtime_adj
#  define _OPENSSL_gmtime_adj OPENSSL_MANGLER_ASM(OPENSSL_gmtime_adj)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_gmtime_diff
#  define OPENSSL_gmtime_diff OPENSSL_MANGLER(OPENSSL_gmtime_diff)
# endif
#else
# ifndef _OPENSSL_gmtime_diff
#  define _OPENSSL_gmtime_diff OPENSSL_MANGLER_ASM(OPENSSL_gmtime_diff)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_hexchar2int
#  define OPENSSL_hexchar2int OPENSSL_MANGLER(OPENSSL_hexchar2int)
# endif
#else
# ifndef _OPENSSL_hexchar2int
#  define _OPENSSL_hexchar2int OPENSSL_MANGLER_ASM(OPENSSL_hexchar2int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_hexstr2buf
#  define OPENSSL_hexstr2buf OPENSSL_MANGLER(OPENSSL_hexstr2buf)
# endif
#else
# ifndef _OPENSSL_hexstr2buf
#  define _OPENSSL_hexstr2buf OPENSSL_MANGLER_ASM(OPENSSL_hexstr2buf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_ia32cap_P
#  define OPENSSL_ia32cap_P OPENSSL_MANGLER(OPENSSL_ia32cap_P)
# endif
#else
# ifndef _OPENSSL_ia32cap_P
#  define _OPENSSL_ia32cap_P OPENSSL_MANGLER_ASM(OPENSSL_ia32cap_P)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_ia32_cpuid
#  define OPENSSL_ia32_cpuid OPENSSL_MANGLER(OPENSSL_ia32_cpuid)
# endif
#else
# ifndef _OPENSSL_ia32_cpuid
#  define _OPENSSL_ia32_cpuid OPENSSL_MANGLER_ASM(OPENSSL_ia32_cpuid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_ia32_rdrand_bytes
#  define OPENSSL_ia32_rdrand_bytes OPENSSL_MANGLER(OPENSSL_ia32_rdrand_bytes)
# endif
#else
# ifndef _OPENSSL_ia32_rdrand_bytes
#  define _OPENSSL_ia32_rdrand_bytes OPENSSL_MANGLER_ASM(OPENSSL_ia32_rdrand_bytes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_ia32_rdseed_bytes
#  define OPENSSL_ia32_rdseed_bytes OPENSSL_MANGLER(OPENSSL_ia32_rdseed_bytes)
# endif
#else
# ifndef _OPENSSL_ia32_rdseed_bytes
#  define _OPENSSL_ia32_rdseed_bytes OPENSSL_MANGLER_ASM(OPENSSL_ia32_rdseed_bytes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_init
#  define OPENSSL_init OPENSSL_MANGLER(OPENSSL_init)
# endif
#else
# ifndef _OPENSSL_init
#  define _OPENSSL_init OPENSSL_MANGLER_ASM(OPENSSL_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_init_crypto
#  define OPENSSL_init_crypto OPENSSL_MANGLER(OPENSSL_init_crypto)
# endif
#else
# ifndef _OPENSSL_init_crypto
#  define _OPENSSL_init_crypto OPENSSL_MANGLER_ASM(OPENSSL_init_crypto)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef openssl_init_fork_handlers
#  define openssl_init_fork_handlers OPENSSL_MANGLER(openssl_init_fork_handlers)
# endif
#else
# ifndef _openssl_init_fork_handlers
#  define _openssl_init_fork_handlers OPENSSL_MANGLER_ASM(openssl_init_fork_handlers)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_INIT_free
#  define OPENSSL_INIT_free OPENSSL_MANGLER(OPENSSL_INIT_free)
# endif
#else
# ifndef _OPENSSL_INIT_free
#  define _OPENSSL_INIT_free OPENSSL_MANGLER_ASM(OPENSSL_INIT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_INIT_new
#  define OPENSSL_INIT_new OPENSSL_MANGLER(OPENSSL_INIT_new)
# endif
#else
# ifndef _OPENSSL_INIT_new
#  define _OPENSSL_INIT_new OPENSSL_MANGLER_ASM(OPENSSL_INIT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_INIT_set_config_appname
#  define OPENSSL_INIT_set_config_appname OPENSSL_MANGLER(OPENSSL_INIT_set_config_appname)
# endif
#else
# ifndef _OPENSSL_INIT_set_config_appname
#  define _OPENSSL_INIT_set_config_appname OPENSSL_MANGLER_ASM(OPENSSL_INIT_set_config_appname)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_INIT_set_config_file_flags
#  define OPENSSL_INIT_set_config_file_flags OPENSSL_MANGLER(OPENSSL_INIT_set_config_file_flags)
# endif
#else
# ifndef _OPENSSL_INIT_set_config_file_flags
#  define _OPENSSL_INIT_set_config_file_flags OPENSSL_MANGLER_ASM(OPENSSL_INIT_set_config_file_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_INIT_set_config_filename
#  define OPENSSL_INIT_set_config_filename OPENSSL_MANGLER(OPENSSL_INIT_set_config_filename)
# endif
#else
# ifndef _OPENSSL_INIT_set_config_filename
#  define _OPENSSL_INIT_set_config_filename OPENSSL_MANGLER_ASM(OPENSSL_INIT_set_config_filename)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_init_ssl
#  define OPENSSL_init_ssl OPENSSL_MANGLER(OPENSSL_init_ssl)
# endif
#else
# ifndef _OPENSSL_init_ssl
#  define _OPENSSL_init_ssl OPENSSL_MANGLER_ASM(OPENSSL_init_ssl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_instrument_bus
#  define OPENSSL_instrument_bus OPENSSL_MANGLER(OPENSSL_instrument_bus)
# endif
#else
# ifndef _OPENSSL_instrument_bus
#  define _OPENSSL_instrument_bus OPENSSL_MANGLER_ASM(OPENSSL_instrument_bus)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_instrument_bus2
#  define OPENSSL_instrument_bus2 OPENSSL_MANGLER(OPENSSL_instrument_bus2)
# endif
#else
# ifndef _OPENSSL_instrument_bus2
#  define _OPENSSL_instrument_bus2 OPENSSL_MANGLER_ASM(OPENSSL_instrument_bus2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_isservice
#  define OPENSSL_isservice OPENSSL_MANGLER(OPENSSL_isservice)
# endif
#else
# ifndef _OPENSSL_isservice
#  define _OPENSSL_isservice OPENSSL_MANGLER_ASM(OPENSSL_isservice)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_issetugid
#  define OPENSSL_issetugid OPENSSL_MANGLER(OPENSSL_issetugid)
# endif
#else
# ifndef _OPENSSL_issetugid
#  define _OPENSSL_issetugid OPENSSL_MANGLER_ASM(OPENSSL_issetugid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_delete
#  define OPENSSL_LH_delete OPENSSL_MANGLER(OPENSSL_LH_delete)
# endif
#else
# ifndef _OPENSSL_LH_delete
#  define _OPENSSL_LH_delete OPENSSL_MANGLER_ASM(OPENSSL_LH_delete)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_doall
#  define OPENSSL_LH_doall OPENSSL_MANGLER(OPENSSL_LH_doall)
# endif
#else
# ifndef _OPENSSL_LH_doall
#  define _OPENSSL_LH_doall OPENSSL_MANGLER_ASM(OPENSSL_LH_doall)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_doall_arg
#  define OPENSSL_LH_doall_arg OPENSSL_MANGLER(OPENSSL_LH_doall_arg)
# endif
#else
# ifndef _OPENSSL_LH_doall_arg
#  define _OPENSSL_LH_doall_arg OPENSSL_MANGLER_ASM(OPENSSL_LH_doall_arg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_error
#  define OPENSSL_LH_error OPENSSL_MANGLER(OPENSSL_LH_error)
# endif
#else
# ifndef _OPENSSL_LH_error
#  define _OPENSSL_LH_error OPENSSL_MANGLER_ASM(OPENSSL_LH_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_free
#  define OPENSSL_LH_free OPENSSL_MANGLER(OPENSSL_LH_free)
# endif
#else
# ifndef _OPENSSL_LH_free
#  define _OPENSSL_LH_free OPENSSL_MANGLER_ASM(OPENSSL_LH_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_get_down_load
#  define OPENSSL_LH_get_down_load OPENSSL_MANGLER(OPENSSL_LH_get_down_load)
# endif
#else
# ifndef _OPENSSL_LH_get_down_load
#  define _OPENSSL_LH_get_down_load OPENSSL_MANGLER_ASM(OPENSSL_LH_get_down_load)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_insert
#  define OPENSSL_LH_insert OPENSSL_MANGLER(OPENSSL_LH_insert)
# endif
#else
# ifndef _OPENSSL_LH_insert
#  define _OPENSSL_LH_insert OPENSSL_MANGLER_ASM(OPENSSL_LH_insert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_new
#  define OPENSSL_LH_new OPENSSL_MANGLER(OPENSSL_LH_new)
# endif
#else
# ifndef _OPENSSL_LH_new
#  define _OPENSSL_LH_new OPENSSL_MANGLER_ASM(OPENSSL_LH_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_node_stats
#  define OPENSSL_LH_node_stats OPENSSL_MANGLER(OPENSSL_LH_node_stats)
# endif
#else
# ifndef _OPENSSL_LH_node_stats
#  define _OPENSSL_LH_node_stats OPENSSL_MANGLER_ASM(OPENSSL_LH_node_stats)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_node_stats_bio
#  define OPENSSL_LH_node_stats_bio OPENSSL_MANGLER(OPENSSL_LH_node_stats_bio)
# endif
#else
# ifndef _OPENSSL_LH_node_stats_bio
#  define _OPENSSL_LH_node_stats_bio OPENSSL_MANGLER_ASM(OPENSSL_LH_node_stats_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_node_usage_stats
#  define OPENSSL_LH_node_usage_stats OPENSSL_MANGLER(OPENSSL_LH_node_usage_stats)
# endif
#else
# ifndef _OPENSSL_LH_node_usage_stats
#  define _OPENSSL_LH_node_usage_stats OPENSSL_MANGLER_ASM(OPENSSL_LH_node_usage_stats)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_node_usage_stats_bio
#  define OPENSSL_LH_node_usage_stats_bio OPENSSL_MANGLER(OPENSSL_LH_node_usage_stats_bio)
# endif
#else
# ifndef _OPENSSL_LH_node_usage_stats_bio
#  define _OPENSSL_LH_node_usage_stats_bio OPENSSL_MANGLER_ASM(OPENSSL_LH_node_usage_stats_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_num_items
#  define OPENSSL_LH_num_items OPENSSL_MANGLER(OPENSSL_LH_num_items)
# endif
#else
# ifndef _OPENSSL_LH_num_items
#  define _OPENSSL_LH_num_items OPENSSL_MANGLER_ASM(OPENSSL_LH_num_items)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_retrieve
#  define OPENSSL_LH_retrieve OPENSSL_MANGLER(OPENSSL_LH_retrieve)
# endif
#else
# ifndef _OPENSSL_LH_retrieve
#  define _OPENSSL_LH_retrieve OPENSSL_MANGLER_ASM(OPENSSL_LH_retrieve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_set_down_load
#  define OPENSSL_LH_set_down_load OPENSSL_MANGLER(OPENSSL_LH_set_down_load)
# endif
#else
# ifndef _OPENSSL_LH_set_down_load
#  define _OPENSSL_LH_set_down_load OPENSSL_MANGLER_ASM(OPENSSL_LH_set_down_load)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_stats
#  define OPENSSL_LH_stats OPENSSL_MANGLER(OPENSSL_LH_stats)
# endif
#else
# ifndef _OPENSSL_LH_stats
#  define _OPENSSL_LH_stats OPENSSL_MANGLER_ASM(OPENSSL_LH_stats)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_stats_bio
#  define OPENSSL_LH_stats_bio OPENSSL_MANGLER(OPENSSL_LH_stats_bio)
# endif
#else
# ifndef _OPENSSL_LH_stats_bio
#  define _OPENSSL_LH_stats_bio OPENSSL_MANGLER_ASM(OPENSSL_LH_stats_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef openssl_lh_strcasehash
#  define openssl_lh_strcasehash OPENSSL_MANGLER(openssl_lh_strcasehash)
# endif
#else
# ifndef _openssl_lh_strcasehash
#  define _openssl_lh_strcasehash OPENSSL_MANGLER_ASM(openssl_lh_strcasehash)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_LH_strhash
#  define OPENSSL_LH_strhash OPENSSL_MANGLER(OPENSSL_LH_strhash)
# endif
#else
# ifndef _OPENSSL_LH_strhash
#  define _OPENSSL_LH_strhash OPENSSL_MANGLER_ASM(OPENSSL_LH_strhash)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_load_builtin_modules
#  define OPENSSL_load_builtin_modules OPENSSL_MANGLER(OPENSSL_load_builtin_modules)
# endif
#else
# ifndef _OPENSSL_load_builtin_modules
#  define _OPENSSL_load_builtin_modules OPENSSL_MANGLER_ASM(OPENSSL_load_builtin_modules)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_memcmp
#  define OPENSSL_memcmp OPENSSL_MANGLER(OPENSSL_memcmp)
# endif
#else
# ifndef _OPENSSL_memcmp
#  define _OPENSSL_memcmp OPENSSL_MANGLER_ASM(OPENSSL_memcmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef openssl_no_config_int
#  define openssl_no_config_int OPENSSL_MANGLER(openssl_no_config_int)
# endif
#else
# ifndef _openssl_no_config_int
#  define _openssl_no_config_int OPENSSL_MANGLER_ASM(openssl_no_config_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_rdtsc
#  define OPENSSL_rdtsc OPENSSL_MANGLER(OPENSSL_rdtsc)
# endif
#else
# ifndef _OPENSSL_rdtsc
#  define _OPENSSL_rdtsc OPENSSL_MANGLER_ASM(OPENSSL_rdtsc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_showfatal
#  define OPENSSL_showfatal OPENSSL_MANGLER(OPENSSL_showfatal)
# endif
#else
# ifndef _OPENSSL_showfatal
#  define _OPENSSL_showfatal OPENSSL_MANGLER_ASM(OPENSSL_showfatal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_deep_copy
#  define OPENSSL_sk_deep_copy OPENSSL_MANGLER(OPENSSL_sk_deep_copy)
# endif
#else
# ifndef _OPENSSL_sk_deep_copy
#  define _OPENSSL_sk_deep_copy OPENSSL_MANGLER_ASM(OPENSSL_sk_deep_copy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_delete
#  define OPENSSL_sk_delete OPENSSL_MANGLER(OPENSSL_sk_delete)
# endif
#else
# ifndef _OPENSSL_sk_delete
#  define _OPENSSL_sk_delete OPENSSL_MANGLER_ASM(OPENSSL_sk_delete)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_delete_ptr
#  define OPENSSL_sk_delete_ptr OPENSSL_MANGLER(OPENSSL_sk_delete_ptr)
# endif
#else
# ifndef _OPENSSL_sk_delete_ptr
#  define _OPENSSL_sk_delete_ptr OPENSSL_MANGLER_ASM(OPENSSL_sk_delete_ptr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_dup
#  define OPENSSL_sk_dup OPENSSL_MANGLER(OPENSSL_sk_dup)
# endif
#else
# ifndef _OPENSSL_sk_dup
#  define _OPENSSL_sk_dup OPENSSL_MANGLER_ASM(OPENSSL_sk_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_find
#  define OPENSSL_sk_find OPENSSL_MANGLER(OPENSSL_sk_find)
# endif
#else
# ifndef _OPENSSL_sk_find
#  define _OPENSSL_sk_find OPENSSL_MANGLER_ASM(OPENSSL_sk_find)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_find_ex
#  define OPENSSL_sk_find_ex OPENSSL_MANGLER(OPENSSL_sk_find_ex)
# endif
#else
# ifndef _OPENSSL_sk_find_ex
#  define _OPENSSL_sk_find_ex OPENSSL_MANGLER_ASM(OPENSSL_sk_find_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_free
#  define OPENSSL_sk_free OPENSSL_MANGLER(OPENSSL_sk_free)
# endif
#else
# ifndef _OPENSSL_sk_free
#  define _OPENSSL_sk_free OPENSSL_MANGLER_ASM(OPENSSL_sk_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_insert
#  define OPENSSL_sk_insert OPENSSL_MANGLER(OPENSSL_sk_insert)
# endif
#else
# ifndef _OPENSSL_sk_insert
#  define _OPENSSL_sk_insert OPENSSL_MANGLER_ASM(OPENSSL_sk_insert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_is_sorted
#  define OPENSSL_sk_is_sorted OPENSSL_MANGLER(OPENSSL_sk_is_sorted)
# endif
#else
# ifndef _OPENSSL_sk_is_sorted
#  define _OPENSSL_sk_is_sorted OPENSSL_MANGLER_ASM(OPENSSL_sk_is_sorted)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_new
#  define OPENSSL_sk_new OPENSSL_MANGLER(OPENSSL_sk_new)
# endif
#else
# ifndef _OPENSSL_sk_new
#  define _OPENSSL_sk_new OPENSSL_MANGLER_ASM(OPENSSL_sk_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_new_null
#  define OPENSSL_sk_new_null OPENSSL_MANGLER(OPENSSL_sk_new_null)
# endif
#else
# ifndef _OPENSSL_sk_new_null
#  define _OPENSSL_sk_new_null OPENSSL_MANGLER_ASM(OPENSSL_sk_new_null)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_new_reserve
#  define OPENSSL_sk_new_reserve OPENSSL_MANGLER(OPENSSL_sk_new_reserve)
# endif
#else
# ifndef _OPENSSL_sk_new_reserve
#  define _OPENSSL_sk_new_reserve OPENSSL_MANGLER_ASM(OPENSSL_sk_new_reserve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_num
#  define OPENSSL_sk_num OPENSSL_MANGLER(OPENSSL_sk_num)
# endif
#else
# ifndef _OPENSSL_sk_num
#  define _OPENSSL_sk_num OPENSSL_MANGLER_ASM(OPENSSL_sk_num)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_pop
#  define OPENSSL_sk_pop OPENSSL_MANGLER(OPENSSL_sk_pop)
# endif
#else
# ifndef _OPENSSL_sk_pop
#  define _OPENSSL_sk_pop OPENSSL_MANGLER_ASM(OPENSSL_sk_pop)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_pop_free
#  define OPENSSL_sk_pop_free OPENSSL_MANGLER(OPENSSL_sk_pop_free)
# endif
#else
# ifndef _OPENSSL_sk_pop_free
#  define _OPENSSL_sk_pop_free OPENSSL_MANGLER_ASM(OPENSSL_sk_pop_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_push
#  define OPENSSL_sk_push OPENSSL_MANGLER(OPENSSL_sk_push)
# endif
#else
# ifndef _OPENSSL_sk_push
#  define _OPENSSL_sk_push OPENSSL_MANGLER_ASM(OPENSSL_sk_push)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_reserve
#  define OPENSSL_sk_reserve OPENSSL_MANGLER(OPENSSL_sk_reserve)
# endif
#else
# ifndef _OPENSSL_sk_reserve
#  define _OPENSSL_sk_reserve OPENSSL_MANGLER_ASM(OPENSSL_sk_reserve)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_set
#  define OPENSSL_sk_set OPENSSL_MANGLER(OPENSSL_sk_set)
# endif
#else
# ifndef _OPENSSL_sk_set
#  define _OPENSSL_sk_set OPENSSL_MANGLER_ASM(OPENSSL_sk_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_set_cmp_func
#  define OPENSSL_sk_set_cmp_func OPENSSL_MANGLER(OPENSSL_sk_set_cmp_func)
# endif
#else
# ifndef _OPENSSL_sk_set_cmp_func
#  define _OPENSSL_sk_set_cmp_func OPENSSL_MANGLER_ASM(OPENSSL_sk_set_cmp_func)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_shift
#  define OPENSSL_sk_shift OPENSSL_MANGLER(OPENSSL_sk_shift)
# endif
#else
# ifndef _OPENSSL_sk_shift
#  define _OPENSSL_sk_shift OPENSSL_MANGLER_ASM(OPENSSL_sk_shift)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_sort
#  define OPENSSL_sk_sort OPENSSL_MANGLER(OPENSSL_sk_sort)
# endif
#else
# ifndef _OPENSSL_sk_sort
#  define _OPENSSL_sk_sort OPENSSL_MANGLER_ASM(OPENSSL_sk_sort)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_unshift
#  define OPENSSL_sk_unshift OPENSSL_MANGLER(OPENSSL_sk_unshift)
# endif
#else
# ifndef _OPENSSL_sk_unshift
#  define _OPENSSL_sk_unshift OPENSSL_MANGLER_ASM(OPENSSL_sk_unshift)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_value
#  define OPENSSL_sk_value OPENSSL_MANGLER(OPENSSL_sk_value)
# endif
#else
# ifndef _OPENSSL_sk_value
#  define _OPENSSL_sk_value OPENSSL_MANGLER_ASM(OPENSSL_sk_value)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_sk_zero
#  define OPENSSL_sk_zero OPENSSL_MANGLER(OPENSSL_sk_zero)
# endif
#else
# ifndef _OPENSSL_sk_zero
#  define _OPENSSL_sk_zero OPENSSL_MANGLER_ASM(OPENSSL_sk_zero)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef openssl_strerror_r
#  define openssl_strerror_r OPENSSL_MANGLER(openssl_strerror_r)
# endif
#else
# ifndef _openssl_strerror_r
#  define _openssl_strerror_r OPENSSL_MANGLER_ASM(openssl_strerror_r)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_strlcat
#  define OPENSSL_strlcat OPENSSL_MANGLER(OPENSSL_strlcat)
# endif
#else
# ifndef _OPENSSL_strlcat
#  define _OPENSSL_strlcat OPENSSL_MANGLER_ASM(OPENSSL_strlcat)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_strlcpy
#  define OPENSSL_strlcpy OPENSSL_MANGLER(OPENSSL_strlcpy)
# endif
#else
# ifndef _OPENSSL_strlcpy
#  define _OPENSSL_strlcpy OPENSSL_MANGLER_ASM(OPENSSL_strlcpy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_strnlen
#  define OPENSSL_strnlen OPENSSL_MANGLER(OPENSSL_strnlen)
# endif
#else
# ifndef _OPENSSL_strnlen
#  define _OPENSSL_strnlen OPENSSL_MANGLER_ASM(OPENSSL_strnlen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_thread_stop
#  define OPENSSL_thread_stop OPENSSL_MANGLER(OPENSSL_thread_stop)
# endif
#else
# ifndef _OPENSSL_thread_stop
#  define _OPENSSL_thread_stop OPENSSL_MANGLER_ASM(OPENSSL_thread_stop)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_uni2asc
#  define OPENSSL_uni2asc OPENSSL_MANGLER(OPENSSL_uni2asc)
# endif
#else
# ifndef _OPENSSL_uni2asc
#  define _OPENSSL_uni2asc OPENSSL_MANGLER_ASM(OPENSSL_uni2asc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_uni2utf8
#  define OPENSSL_uni2utf8 OPENSSL_MANGLER(OPENSSL_uni2utf8)
# endif
#else
# ifndef _OPENSSL_uni2utf8
#  define _OPENSSL_uni2utf8 OPENSSL_MANGLER_ASM(OPENSSL_uni2utf8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_utf82uni
#  define OPENSSL_utf82uni OPENSSL_MANGLER(OPENSSL_utf82uni)
# endif
#else
# ifndef _OPENSSL_utf82uni
#  define _OPENSSL_utf82uni OPENSSL_MANGLER_ASM(OPENSSL_utf82uni)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OpenSSL_version
#  define OpenSSL_version OPENSSL_MANGLER(OpenSSL_version)
# endif
#else
# ifndef _OpenSSL_version
#  define _OpenSSL_version OPENSSL_MANGLER_ASM(OpenSSL_version)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OpenSSL_version_num
#  define OpenSSL_version_num OPENSSL_MANGLER(OpenSSL_version_num)
# endif
#else
# ifndef _OpenSSL_version_num
#  define _OpenSSL_version_num OPENSSL_MANGLER_ASM(OpenSSL_version_num)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OPENSSL_wipe_cpu
#  define OPENSSL_wipe_cpu OPENSSL_MANGLER(OPENSSL_wipe_cpu)
# endif
#else
# ifndef _OPENSSL_wipe_cpu
#  define _OPENSSL_wipe_cpu OPENSSL_MANGLER_ASM(OPENSSL_wipe_cpu)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_ctype_check
#  define ossl_ctype_check OPENSSL_MANGLER(ossl_ctype_check)
# endif
#else
# ifndef _ossl_ctype_check
#  define _ossl_ctype_check OPENSSL_MANGLER_ASM(ossl_ctype_check)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_ecdh_compute_key
#  define ossl_ecdh_compute_key OPENSSL_MANGLER(ossl_ecdh_compute_key)
# endif
#else
# ifndef _ossl_ecdh_compute_key
#  define _ossl_ecdh_compute_key OPENSSL_MANGLER_ASM(ossl_ecdh_compute_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_ecdsa_sign
#  define ossl_ecdsa_sign OPENSSL_MANGLER(ossl_ecdsa_sign)
# endif
#else
# ifndef _ossl_ecdsa_sign
#  define _ossl_ecdsa_sign OPENSSL_MANGLER_ASM(ossl_ecdsa_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_ecdsa_sign_setup
#  define ossl_ecdsa_sign_setup OPENSSL_MANGLER(ossl_ecdsa_sign_setup)
# endif
#else
# ifndef _ossl_ecdsa_sign_setup
#  define _ossl_ecdsa_sign_setup OPENSSL_MANGLER_ASM(ossl_ecdsa_sign_setup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_ecdsa_sign_sig
#  define ossl_ecdsa_sign_sig OPENSSL_MANGLER(ossl_ecdsa_sign_sig)
# endif
#else
# ifndef _ossl_ecdsa_sign_sig
#  define _ossl_ecdsa_sign_sig OPENSSL_MANGLER_ASM(ossl_ecdsa_sign_sig)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_ecdsa_verify
#  define ossl_ecdsa_verify OPENSSL_MANGLER(ossl_ecdsa_verify)
# endif
#else
# ifndef _ossl_ecdsa_verify
#  define _ossl_ecdsa_verify OPENSSL_MANGLER_ASM(ossl_ecdsa_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_ecdsa_verify_sig
#  define ossl_ecdsa_verify_sig OPENSSL_MANGLER(ossl_ecdsa_verify_sig)
# endif
#else
# ifndef _ossl_ecdsa_verify_sig
#  define _ossl_ecdsa_verify_sig OPENSSL_MANGLER_ASM(ossl_ecdsa_verify_sig)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_ec_key_gen
#  define ossl_ec_key_gen OPENSSL_MANGLER(ossl_ec_key_gen)
# endif
#else
# ifndef _ossl_ec_key_gen
#  define _ossl_ec_key_gen OPENSSL_MANGLER_ASM(ossl_ec_key_gen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_init_thread_start
#  define ossl_init_thread_start OPENSSL_MANGLER(ossl_init_thread_start)
# endif
#else
# ifndef _ossl_init_thread_start
#  define _ossl_init_thread_start OPENSSL_MANGLER_ASM(ossl_init_thread_start)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_safe_getenv
#  define ossl_safe_getenv OPENSSL_MANGLER(ossl_safe_getenv)
# endif
#else
# ifndef _ossl_safe_getenv
#  define _ossl_safe_getenv OPENSSL_MANGLER_ASM(ossl_safe_getenv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_accept
#  define ossl_statem_accept OPENSSL_MANGLER(ossl_statem_accept)
# endif
#else
# ifndef _ossl_statem_accept
#  define _ossl_statem_accept OPENSSL_MANGLER_ASM(ossl_statem_accept)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_app_data_allowed
#  define ossl_statem_app_data_allowed OPENSSL_MANGLER(ossl_statem_app_data_allowed)
# endif
#else
# ifndef _ossl_statem_app_data_allowed
#  define _ossl_statem_app_data_allowed OPENSSL_MANGLER_ASM(ossl_statem_app_data_allowed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_check_finish_init
#  define ossl_statem_check_finish_init OPENSSL_MANGLER(ossl_statem_check_finish_init)
# endif
#else
# ifndef _ossl_statem_check_finish_init
#  define _ossl_statem_check_finish_init OPENSSL_MANGLER_ASM(ossl_statem_check_finish_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_clear
#  define ossl_statem_clear OPENSSL_MANGLER(ossl_statem_clear)
# endif
#else
# ifndef _ossl_statem_clear
#  define _ossl_statem_clear OPENSSL_MANGLER_ASM(ossl_statem_clear)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_client_construct_message
#  define ossl_statem_client_construct_message OPENSSL_MANGLER(ossl_statem_client_construct_message)
# endif
#else
# ifndef _ossl_statem_client_construct_message
#  define _ossl_statem_client_construct_message OPENSSL_MANGLER_ASM(ossl_statem_client_construct_message)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_client_max_message_size
#  define ossl_statem_client_max_message_size OPENSSL_MANGLER(ossl_statem_client_max_message_size)
# endif
#else
# ifndef _ossl_statem_client_max_message_size
#  define _ossl_statem_client_max_message_size OPENSSL_MANGLER_ASM(ossl_statem_client_max_message_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_client_post_process_message
#  define ossl_statem_client_post_process_message OPENSSL_MANGLER(ossl_statem_client_post_process_message)
# endif
#else
# ifndef _ossl_statem_client_post_process_message
#  define _ossl_statem_client_post_process_message OPENSSL_MANGLER_ASM(ossl_statem_client_post_process_message)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_client_post_work
#  define ossl_statem_client_post_work OPENSSL_MANGLER(ossl_statem_client_post_work)
# endif
#else
# ifndef _ossl_statem_client_post_work
#  define _ossl_statem_client_post_work OPENSSL_MANGLER_ASM(ossl_statem_client_post_work)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_client_pre_work
#  define ossl_statem_client_pre_work OPENSSL_MANGLER(ossl_statem_client_pre_work)
# endif
#else
# ifndef _ossl_statem_client_pre_work
#  define _ossl_statem_client_pre_work OPENSSL_MANGLER_ASM(ossl_statem_client_pre_work)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_client_process_message
#  define ossl_statem_client_process_message OPENSSL_MANGLER(ossl_statem_client_process_message)
# endif
#else
# ifndef _ossl_statem_client_process_message
#  define _ossl_statem_client_process_message OPENSSL_MANGLER_ASM(ossl_statem_client_process_message)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_client_read_transition
#  define ossl_statem_client_read_transition OPENSSL_MANGLER(ossl_statem_client_read_transition)
# endif
#else
# ifndef _ossl_statem_client_read_transition
#  define _ossl_statem_client_read_transition OPENSSL_MANGLER_ASM(ossl_statem_client_read_transition)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_client_write_transition
#  define ossl_statem_client_write_transition OPENSSL_MANGLER(ossl_statem_client_write_transition)
# endif
#else
# ifndef _ossl_statem_client_write_transition
#  define _ossl_statem_client_write_transition OPENSSL_MANGLER_ASM(ossl_statem_client_write_transition)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_connect
#  define ossl_statem_connect OPENSSL_MANGLER(ossl_statem_connect)
# endif
#else
# ifndef _ossl_statem_connect
#  define _ossl_statem_connect OPENSSL_MANGLER_ASM(ossl_statem_connect)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_export_allowed
#  define ossl_statem_export_allowed OPENSSL_MANGLER(ossl_statem_export_allowed)
# endif
#else
# ifndef _ossl_statem_export_allowed
#  define _ossl_statem_export_allowed OPENSSL_MANGLER_ASM(ossl_statem_export_allowed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_export_early_allowed
#  define ossl_statem_export_early_allowed OPENSSL_MANGLER(ossl_statem_export_early_allowed)
# endif
#else
# ifndef _ossl_statem_export_early_allowed
#  define _ossl_statem_export_early_allowed OPENSSL_MANGLER_ASM(ossl_statem_export_early_allowed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_fatal
#  define ossl_statem_fatal OPENSSL_MANGLER(ossl_statem_fatal)
# endif
#else
# ifndef _ossl_statem_fatal
#  define _ossl_statem_fatal OPENSSL_MANGLER_ASM(ossl_statem_fatal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_get_in_handshake
#  define ossl_statem_get_in_handshake OPENSSL_MANGLER(ossl_statem_get_in_handshake)
# endif
#else
# ifndef _ossl_statem_get_in_handshake
#  define _ossl_statem_get_in_handshake OPENSSL_MANGLER_ASM(ossl_statem_get_in_handshake)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_in_error
#  define ossl_statem_in_error OPENSSL_MANGLER(ossl_statem_in_error)
# endif
#else
# ifndef _ossl_statem_in_error
#  define _ossl_statem_in_error OPENSSL_MANGLER_ASM(ossl_statem_in_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_server_construct_message
#  define ossl_statem_server_construct_message OPENSSL_MANGLER(ossl_statem_server_construct_message)
# endif
#else
# ifndef _ossl_statem_server_construct_message
#  define _ossl_statem_server_construct_message OPENSSL_MANGLER_ASM(ossl_statem_server_construct_message)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_server_max_message_size
#  define ossl_statem_server_max_message_size OPENSSL_MANGLER(ossl_statem_server_max_message_size)
# endif
#else
# ifndef _ossl_statem_server_max_message_size
#  define _ossl_statem_server_max_message_size OPENSSL_MANGLER_ASM(ossl_statem_server_max_message_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_server_post_process_message
#  define ossl_statem_server_post_process_message OPENSSL_MANGLER(ossl_statem_server_post_process_message)
# endif
#else
# ifndef _ossl_statem_server_post_process_message
#  define _ossl_statem_server_post_process_message OPENSSL_MANGLER_ASM(ossl_statem_server_post_process_message)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_server_post_work
#  define ossl_statem_server_post_work OPENSSL_MANGLER(ossl_statem_server_post_work)
# endif
#else
# ifndef _ossl_statem_server_post_work
#  define _ossl_statem_server_post_work OPENSSL_MANGLER_ASM(ossl_statem_server_post_work)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_server_pre_work
#  define ossl_statem_server_pre_work OPENSSL_MANGLER(ossl_statem_server_pre_work)
# endif
#else
# ifndef _ossl_statem_server_pre_work
#  define _ossl_statem_server_pre_work OPENSSL_MANGLER_ASM(ossl_statem_server_pre_work)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_server_process_message
#  define ossl_statem_server_process_message OPENSSL_MANGLER(ossl_statem_server_process_message)
# endif
#else
# ifndef _ossl_statem_server_process_message
#  define _ossl_statem_server_process_message OPENSSL_MANGLER_ASM(ossl_statem_server_process_message)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_server_read_transition
#  define ossl_statem_server_read_transition OPENSSL_MANGLER(ossl_statem_server_read_transition)
# endif
#else
# ifndef _ossl_statem_server_read_transition
#  define _ossl_statem_server_read_transition OPENSSL_MANGLER_ASM(ossl_statem_server_read_transition)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_server_write_transition
#  define ossl_statem_server_write_transition OPENSSL_MANGLER(ossl_statem_server_write_transition)
# endif
#else
# ifndef _ossl_statem_server_write_transition
#  define _ossl_statem_server_write_transition OPENSSL_MANGLER_ASM(ossl_statem_server_write_transition)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_set_hello_verify_done
#  define ossl_statem_set_hello_verify_done OPENSSL_MANGLER(ossl_statem_set_hello_verify_done)
# endif
#else
# ifndef _ossl_statem_set_hello_verify_done
#  define _ossl_statem_set_hello_verify_done OPENSSL_MANGLER_ASM(ossl_statem_set_hello_verify_done)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_set_in_handshake
#  define ossl_statem_set_in_handshake OPENSSL_MANGLER(ossl_statem_set_in_handshake)
# endif
#else
# ifndef _ossl_statem_set_in_handshake
#  define _ossl_statem_set_in_handshake OPENSSL_MANGLER_ASM(ossl_statem_set_in_handshake)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_set_in_init
#  define ossl_statem_set_in_init OPENSSL_MANGLER(ossl_statem_set_in_init)
# endif
#else
# ifndef _ossl_statem_set_in_init
#  define _ossl_statem_set_in_init OPENSSL_MANGLER_ASM(ossl_statem_set_in_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_set_renegotiate
#  define ossl_statem_set_renegotiate OPENSSL_MANGLER(ossl_statem_set_renegotiate)
# endif
#else
# ifndef _ossl_statem_set_renegotiate
#  define _ossl_statem_set_renegotiate OPENSSL_MANGLER_ASM(ossl_statem_set_renegotiate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_statem_skip_early_data
#  define ossl_statem_skip_early_data OPENSSL_MANGLER(ossl_statem_skip_early_data)
# endif
#else
# ifndef _ossl_statem_skip_early_data
#  define _ossl_statem_skip_early_data OPENSSL_MANGLER_ASM(ossl_statem_skip_early_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_attach_pem_bio
#  define ossl_store_attach_pem_bio OPENSSL_MANGLER(ossl_store_attach_pem_bio)
# endif
#else
# ifndef _ossl_store_attach_pem_bio
#  define _ossl_store_attach_pem_bio OPENSSL_MANGLER_ASM(ossl_store_attach_pem_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_cleanup_int
#  define ossl_store_cleanup_int OPENSSL_MANGLER(ossl_store_cleanup_int)
# endif
#else
# ifndef _ossl_store_cleanup_int
#  define _ossl_store_cleanup_int OPENSSL_MANGLER_ASM(ossl_store_cleanup_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_close
#  define OSSL_STORE_close OPENSSL_MANGLER(OSSL_STORE_close)
# endif
#else
# ifndef _OSSL_STORE_close
#  define _OSSL_STORE_close OPENSSL_MANGLER_ASM(OSSL_STORE_close)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_ctrl
#  define OSSL_STORE_ctrl OPENSSL_MANGLER(OSSL_STORE_ctrl)
# endif
#else
# ifndef _OSSL_STORE_ctrl
#  define _OSSL_STORE_ctrl OPENSSL_MANGLER_ASM(OSSL_STORE_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_destroy_loaders_int
#  define ossl_store_destroy_loaders_int OPENSSL_MANGLER(ossl_store_destroy_loaders_int)
# endif
#else
# ifndef _ossl_store_destroy_loaders_int
#  define _ossl_store_destroy_loaders_int OPENSSL_MANGLER_ASM(ossl_store_destroy_loaders_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_detach_pem_bio
#  define ossl_store_detach_pem_bio OPENSSL_MANGLER(ossl_store_detach_pem_bio)
# endif
#else
# ifndef _ossl_store_detach_pem_bio
#  define _ossl_store_detach_pem_bio OPENSSL_MANGLER_ASM(ossl_store_detach_pem_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_do_all_loaders
#  define OSSL_STORE_do_all_loaders OPENSSL_MANGLER(OSSL_STORE_do_all_loaders)
# endif
#else
# ifndef _OSSL_STORE_do_all_loaders
#  define _OSSL_STORE_do_all_loaders OPENSSL_MANGLER_ASM(OSSL_STORE_do_all_loaders)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_eof
#  define OSSL_STORE_eof OPENSSL_MANGLER(OSSL_STORE_eof)
# endif
#else
# ifndef _OSSL_STORE_eof
#  define _OSSL_STORE_eof OPENSSL_MANGLER_ASM(OSSL_STORE_eof)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_error
#  define OSSL_STORE_error OPENSSL_MANGLER(OSSL_STORE_error)
# endif
#else
# ifndef _OSSL_STORE_error
#  define _OSSL_STORE_error OPENSSL_MANGLER_ASM(OSSL_STORE_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_expect
#  define OSSL_STORE_expect OPENSSL_MANGLER(OSSL_STORE_expect)
# endif
#else
# ifndef _OSSL_STORE_expect
#  define _OSSL_STORE_expect OPENSSL_MANGLER_ASM(OSSL_STORE_expect)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_file_attach_pem_bio_int
#  define ossl_store_file_attach_pem_bio_int OPENSSL_MANGLER(ossl_store_file_attach_pem_bio_int)
# endif
#else
# ifndef _ossl_store_file_attach_pem_bio_int
#  define _ossl_store_file_attach_pem_bio_int OPENSSL_MANGLER_ASM(ossl_store_file_attach_pem_bio_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_file_detach_pem_bio_int
#  define ossl_store_file_detach_pem_bio_int OPENSSL_MANGLER(ossl_store_file_detach_pem_bio_int)
# endif
#else
# ifndef _ossl_store_file_detach_pem_bio_int
#  define _ossl_store_file_detach_pem_bio_int OPENSSL_MANGLER_ASM(ossl_store_file_detach_pem_bio_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_file_loader_init
#  define ossl_store_file_loader_init OPENSSL_MANGLER(ossl_store_file_loader_init)
# endif
#else
# ifndef _ossl_store_file_loader_init
#  define _ossl_store_file_loader_init OPENSSL_MANGLER_ASM(ossl_store_file_loader_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_find
#  define OSSL_STORE_find OPENSSL_MANGLER(OSSL_STORE_find)
# endif
#else
# ifndef _OSSL_STORE_find
#  define _OSSL_STORE_find OPENSSL_MANGLER_ASM(OSSL_STORE_find)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_get0_loader_int
#  define ossl_store_get0_loader_int OPENSSL_MANGLER(ossl_store_get0_loader_int)
# endif
#else
# ifndef _ossl_store_get0_loader_int
#  define _ossl_store_get0_loader_int OPENSSL_MANGLER_ASM(ossl_store_get0_loader_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_free
#  define OSSL_STORE_INFO_free OPENSSL_MANGLER(OSSL_STORE_INFO_free)
# endif
#else
# ifndef _OSSL_STORE_INFO_free
#  define _OSSL_STORE_INFO_free OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get0_CERT
#  define OSSL_STORE_INFO_get0_CERT OPENSSL_MANGLER(OSSL_STORE_INFO_get0_CERT)
# endif
#else
# ifndef _OSSL_STORE_INFO_get0_CERT
#  define _OSSL_STORE_INFO_get0_CERT OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get0_CERT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get0_CRL
#  define OSSL_STORE_INFO_get0_CRL OPENSSL_MANGLER(OSSL_STORE_INFO_get0_CRL)
# endif
#else
# ifndef _OSSL_STORE_INFO_get0_CRL
#  define _OSSL_STORE_INFO_get0_CRL OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get0_CRL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_info_get0_EMBEDDED_buffer
#  define ossl_store_info_get0_EMBEDDED_buffer OPENSSL_MANGLER(ossl_store_info_get0_EMBEDDED_buffer)
# endif
#else
# ifndef _ossl_store_info_get0_EMBEDDED_buffer
#  define _ossl_store_info_get0_EMBEDDED_buffer OPENSSL_MANGLER_ASM(ossl_store_info_get0_EMBEDDED_buffer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_info_get0_EMBEDDED_pem_name
#  define ossl_store_info_get0_EMBEDDED_pem_name OPENSSL_MANGLER(ossl_store_info_get0_EMBEDDED_pem_name)
# endif
#else
# ifndef _ossl_store_info_get0_EMBEDDED_pem_name
#  define _ossl_store_info_get0_EMBEDDED_pem_name OPENSSL_MANGLER_ASM(ossl_store_info_get0_EMBEDDED_pem_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get0_NAME
#  define OSSL_STORE_INFO_get0_NAME OPENSSL_MANGLER(OSSL_STORE_INFO_get0_NAME)
# endif
#else
# ifndef _OSSL_STORE_INFO_get0_NAME
#  define _OSSL_STORE_INFO_get0_NAME OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get0_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get0_NAME_description
#  define OSSL_STORE_INFO_get0_NAME_description OPENSSL_MANGLER(OSSL_STORE_INFO_get0_NAME_description)
# endif
#else
# ifndef _OSSL_STORE_INFO_get0_NAME_description
#  define _OSSL_STORE_INFO_get0_NAME_description OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get0_NAME_description)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get0_PARAMS
#  define OSSL_STORE_INFO_get0_PARAMS OPENSSL_MANGLER(OSSL_STORE_INFO_get0_PARAMS)
# endif
#else
# ifndef _OSSL_STORE_INFO_get0_PARAMS
#  define _OSSL_STORE_INFO_get0_PARAMS OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get0_PARAMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get0_PKEY
#  define OSSL_STORE_INFO_get0_PKEY OPENSSL_MANGLER(OSSL_STORE_INFO_get0_PKEY)
# endif
#else
# ifndef _OSSL_STORE_INFO_get0_PKEY
#  define _OSSL_STORE_INFO_get0_PKEY OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get0_PKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get1_CERT
#  define OSSL_STORE_INFO_get1_CERT OPENSSL_MANGLER(OSSL_STORE_INFO_get1_CERT)
# endif
#else
# ifndef _OSSL_STORE_INFO_get1_CERT
#  define _OSSL_STORE_INFO_get1_CERT OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get1_CERT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get1_CRL
#  define OSSL_STORE_INFO_get1_CRL OPENSSL_MANGLER(OSSL_STORE_INFO_get1_CRL)
# endif
#else
# ifndef _OSSL_STORE_INFO_get1_CRL
#  define _OSSL_STORE_INFO_get1_CRL OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get1_CRL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get1_NAME
#  define OSSL_STORE_INFO_get1_NAME OPENSSL_MANGLER(OSSL_STORE_INFO_get1_NAME)
# endif
#else
# ifndef _OSSL_STORE_INFO_get1_NAME
#  define _OSSL_STORE_INFO_get1_NAME OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get1_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get1_NAME_description
#  define OSSL_STORE_INFO_get1_NAME_description OPENSSL_MANGLER(OSSL_STORE_INFO_get1_NAME_description)
# endif
#else
# ifndef _OSSL_STORE_INFO_get1_NAME_description
#  define _OSSL_STORE_INFO_get1_NAME_description OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get1_NAME_description)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get1_PARAMS
#  define OSSL_STORE_INFO_get1_PARAMS OPENSSL_MANGLER(OSSL_STORE_INFO_get1_PARAMS)
# endif
#else
# ifndef _OSSL_STORE_INFO_get1_PARAMS
#  define _OSSL_STORE_INFO_get1_PARAMS OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get1_PARAMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get1_PKEY
#  define OSSL_STORE_INFO_get1_PKEY OPENSSL_MANGLER(OSSL_STORE_INFO_get1_PKEY)
# endif
#else
# ifndef _OSSL_STORE_INFO_get1_PKEY
#  define _OSSL_STORE_INFO_get1_PKEY OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get1_PKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_get_type
#  define OSSL_STORE_INFO_get_type OPENSSL_MANGLER(OSSL_STORE_INFO_get_type)
# endif
#else
# ifndef _OSSL_STORE_INFO_get_type
#  define _OSSL_STORE_INFO_get_type OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_get_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_new_CERT
#  define OSSL_STORE_INFO_new_CERT OPENSSL_MANGLER(OSSL_STORE_INFO_new_CERT)
# endif
#else
# ifndef _OSSL_STORE_INFO_new_CERT
#  define _OSSL_STORE_INFO_new_CERT OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_new_CERT)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_new_CRL
#  define OSSL_STORE_INFO_new_CRL OPENSSL_MANGLER(OSSL_STORE_INFO_new_CRL)
# endif
#else
# ifndef _OSSL_STORE_INFO_new_CRL
#  define _OSSL_STORE_INFO_new_CRL OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_new_CRL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_info_new_EMBEDDED
#  define ossl_store_info_new_EMBEDDED OPENSSL_MANGLER(ossl_store_info_new_EMBEDDED)
# endif
#else
# ifndef _ossl_store_info_new_EMBEDDED
#  define _ossl_store_info_new_EMBEDDED OPENSSL_MANGLER_ASM(ossl_store_info_new_EMBEDDED)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_new_NAME
#  define OSSL_STORE_INFO_new_NAME OPENSSL_MANGLER(OSSL_STORE_INFO_new_NAME)
# endif
#else
# ifndef _OSSL_STORE_INFO_new_NAME
#  define _OSSL_STORE_INFO_new_NAME OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_new_NAME)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_new_PARAMS
#  define OSSL_STORE_INFO_new_PARAMS OPENSSL_MANGLER(OSSL_STORE_INFO_new_PARAMS)
# endif
#else
# ifndef _OSSL_STORE_INFO_new_PARAMS
#  define _OSSL_STORE_INFO_new_PARAMS OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_new_PARAMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_new_PKEY
#  define OSSL_STORE_INFO_new_PKEY OPENSSL_MANGLER(OSSL_STORE_INFO_new_PKEY)
# endif
#else
# ifndef _OSSL_STORE_INFO_new_PKEY
#  define _OSSL_STORE_INFO_new_PKEY OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_new_PKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_set0_NAME_description
#  define OSSL_STORE_INFO_set0_NAME_description OPENSSL_MANGLER(OSSL_STORE_INFO_set0_NAME_description)
# endif
#else
# ifndef _OSSL_STORE_INFO_set0_NAME_description
#  define _OSSL_STORE_INFO_set0_NAME_description OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_set0_NAME_description)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_INFO_type_string
#  define OSSL_STORE_INFO_type_string OPENSSL_MANGLER(OSSL_STORE_INFO_type_string)
# endif
#else
# ifndef _OSSL_STORE_INFO_type_string
#  define _OSSL_STORE_INFO_type_string OPENSSL_MANGLER_ASM(OSSL_STORE_INFO_type_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_init_once
#  define ossl_store_init_once OPENSSL_MANGLER(ossl_store_init_once)
# endif
#else
# ifndef _ossl_store_init_once
#  define _ossl_store_init_once OPENSSL_MANGLER_ASM(ossl_store_init_once)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_load
#  define OSSL_STORE_load OPENSSL_MANGLER(OSSL_STORE_load)
# endif
#else
# ifndef _OSSL_STORE_load
#  define _OSSL_STORE_load OPENSSL_MANGLER_ASM(OSSL_STORE_load)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_free
#  define OSSL_STORE_LOADER_free OPENSSL_MANGLER(OSSL_STORE_LOADER_free)
# endif
#else
# ifndef _OSSL_STORE_LOADER_free
#  define _OSSL_STORE_LOADER_free OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_get0_engine
#  define OSSL_STORE_LOADER_get0_engine OPENSSL_MANGLER(OSSL_STORE_LOADER_get0_engine)
# endif
#else
# ifndef _OSSL_STORE_LOADER_get0_engine
#  define _OSSL_STORE_LOADER_get0_engine OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_get0_engine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_get0_scheme
#  define OSSL_STORE_LOADER_get0_scheme OPENSSL_MANGLER(OSSL_STORE_LOADER_get0_scheme)
# endif
#else
# ifndef _OSSL_STORE_LOADER_get0_scheme
#  define _OSSL_STORE_LOADER_get0_scheme OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_get0_scheme)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_new
#  define OSSL_STORE_LOADER_new OPENSSL_MANGLER(OSSL_STORE_LOADER_new)
# endif
#else
# ifndef _OSSL_STORE_LOADER_new
#  define _OSSL_STORE_LOADER_new OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_set_close
#  define OSSL_STORE_LOADER_set_close OPENSSL_MANGLER(OSSL_STORE_LOADER_set_close)
# endif
#else
# ifndef _OSSL_STORE_LOADER_set_close
#  define _OSSL_STORE_LOADER_set_close OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_set_close)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_set_ctrl
#  define OSSL_STORE_LOADER_set_ctrl OPENSSL_MANGLER(OSSL_STORE_LOADER_set_ctrl)
# endif
#else
# ifndef _OSSL_STORE_LOADER_set_ctrl
#  define _OSSL_STORE_LOADER_set_ctrl OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_set_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_set_eof
#  define OSSL_STORE_LOADER_set_eof OPENSSL_MANGLER(OSSL_STORE_LOADER_set_eof)
# endif
#else
# ifndef _OSSL_STORE_LOADER_set_eof
#  define _OSSL_STORE_LOADER_set_eof OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_set_eof)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_set_error
#  define OSSL_STORE_LOADER_set_error OPENSSL_MANGLER(OSSL_STORE_LOADER_set_error)
# endif
#else
# ifndef _OSSL_STORE_LOADER_set_error
#  define _OSSL_STORE_LOADER_set_error OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_set_error)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_set_expect
#  define OSSL_STORE_LOADER_set_expect OPENSSL_MANGLER(OSSL_STORE_LOADER_set_expect)
# endif
#else
# ifndef _OSSL_STORE_LOADER_set_expect
#  define _OSSL_STORE_LOADER_set_expect OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_set_expect)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_set_find
#  define OSSL_STORE_LOADER_set_find OPENSSL_MANGLER(OSSL_STORE_LOADER_set_find)
# endif
#else
# ifndef _OSSL_STORE_LOADER_set_find
#  define _OSSL_STORE_LOADER_set_find OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_set_find)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_set_load
#  define OSSL_STORE_LOADER_set_load OPENSSL_MANGLER(OSSL_STORE_LOADER_set_load)
# endif
#else
# ifndef _OSSL_STORE_LOADER_set_load
#  define _OSSL_STORE_LOADER_set_load OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_set_load)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_LOADER_set_open
#  define OSSL_STORE_LOADER_set_open OPENSSL_MANGLER(OSSL_STORE_LOADER_set_open)
# endif
#else
# ifndef _OSSL_STORE_LOADER_set_open
#  define _OSSL_STORE_LOADER_set_open OPENSSL_MANGLER_ASM(OSSL_STORE_LOADER_set_open)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_open
#  define OSSL_STORE_open OPENSSL_MANGLER(OSSL_STORE_open)
# endif
#else
# ifndef _OSSL_STORE_open
#  define _OSSL_STORE_open OPENSSL_MANGLER_ASM(OSSL_STORE_open)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_register_loader
#  define OSSL_STORE_register_loader OPENSSL_MANGLER(OSSL_STORE_register_loader)
# endif
#else
# ifndef _OSSL_STORE_register_loader
#  define _OSSL_STORE_register_loader OPENSSL_MANGLER_ASM(OSSL_STORE_register_loader)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_register_loader_int
#  define ossl_store_register_loader_int OPENSSL_MANGLER(ossl_store_register_loader_int)
# endif
#else
# ifndef _ossl_store_register_loader_int
#  define _ossl_store_register_loader_int OPENSSL_MANGLER_ASM(ossl_store_register_loader_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_by_alias
#  define OSSL_STORE_SEARCH_by_alias OPENSSL_MANGLER(OSSL_STORE_SEARCH_by_alias)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_by_alias
#  define _OSSL_STORE_SEARCH_by_alias OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_by_alias)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_by_issuer_serial
#  define OSSL_STORE_SEARCH_by_issuer_serial OPENSSL_MANGLER(OSSL_STORE_SEARCH_by_issuer_serial)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_by_issuer_serial
#  define _OSSL_STORE_SEARCH_by_issuer_serial OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_by_issuer_serial)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_by_key_fingerprint
#  define OSSL_STORE_SEARCH_by_key_fingerprint OPENSSL_MANGLER(OSSL_STORE_SEARCH_by_key_fingerprint)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_by_key_fingerprint
#  define _OSSL_STORE_SEARCH_by_key_fingerprint OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_by_key_fingerprint)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_by_name
#  define OSSL_STORE_SEARCH_by_name OPENSSL_MANGLER(OSSL_STORE_SEARCH_by_name)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_by_name
#  define _OSSL_STORE_SEARCH_by_name OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_by_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_free
#  define OSSL_STORE_SEARCH_free OPENSSL_MANGLER(OSSL_STORE_SEARCH_free)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_free
#  define _OSSL_STORE_SEARCH_free OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_get0_bytes
#  define OSSL_STORE_SEARCH_get0_bytes OPENSSL_MANGLER(OSSL_STORE_SEARCH_get0_bytes)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_get0_bytes
#  define _OSSL_STORE_SEARCH_get0_bytes OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_get0_bytes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_get0_digest
#  define OSSL_STORE_SEARCH_get0_digest OPENSSL_MANGLER(OSSL_STORE_SEARCH_get0_digest)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_get0_digest
#  define _OSSL_STORE_SEARCH_get0_digest OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_get0_digest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_get0_name
#  define OSSL_STORE_SEARCH_get0_name OPENSSL_MANGLER(OSSL_STORE_SEARCH_get0_name)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_get0_name
#  define _OSSL_STORE_SEARCH_get0_name OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_get0_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_get0_serial
#  define OSSL_STORE_SEARCH_get0_serial OPENSSL_MANGLER(OSSL_STORE_SEARCH_get0_serial)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_get0_serial
#  define _OSSL_STORE_SEARCH_get0_serial OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_get0_serial)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_get0_string
#  define OSSL_STORE_SEARCH_get0_string OPENSSL_MANGLER(OSSL_STORE_SEARCH_get0_string)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_get0_string
#  define _OSSL_STORE_SEARCH_get0_string OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_get0_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_SEARCH_get_type
#  define OSSL_STORE_SEARCH_get_type OPENSSL_MANGLER(OSSL_STORE_SEARCH_get_type)
# endif
#else
# ifndef _OSSL_STORE_SEARCH_get_type
#  define _OSSL_STORE_SEARCH_get_type OPENSSL_MANGLER_ASM(OSSL_STORE_SEARCH_get_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_supports_search
#  define OSSL_STORE_supports_search OPENSSL_MANGLER(OSSL_STORE_supports_search)
# endif
#else
# ifndef _OSSL_STORE_supports_search
#  define _OSSL_STORE_supports_search OPENSSL_MANGLER_ASM(OSSL_STORE_supports_search)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_unregister_loader
#  define OSSL_STORE_unregister_loader OPENSSL_MANGLER(OSSL_STORE_unregister_loader)
# endif
#else
# ifndef _OSSL_STORE_unregister_loader
#  define _OSSL_STORE_unregister_loader OPENSSL_MANGLER_ASM(OSSL_STORE_unregister_loader)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_store_unregister_loader_int
#  define ossl_store_unregister_loader_int OPENSSL_MANGLER(ossl_store_unregister_loader_int)
# endif
#else
# ifndef _ossl_store_unregister_loader_int
#  define _ossl_store_unregister_loader_int OPENSSL_MANGLER_ASM(ossl_store_unregister_loader_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OSSL_STORE_vctrl
#  define OSSL_STORE_vctrl OPENSSL_MANGLER(OSSL_STORE_vctrl)
# endif
#else
# ifndef _OSSL_STORE_vctrl
#  define _OSSL_STORE_vctrl OPENSSL_MANGLER_ASM(OSSL_STORE_vctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_tolower
#  define ossl_tolower OPENSSL_MANGLER(ossl_tolower)
# endif
#else
# ifndef _ossl_tolower
#  define _ossl_tolower OPENSSL_MANGLER_ASM(ossl_tolower)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef ossl_toupper
#  define ossl_toupper OPENSSL_MANGLER(ossl_toupper)
# endif
#else
# ifndef _ossl_toupper
#  define _ossl_toupper OPENSSL_MANGLER_ASM(ossl_toupper)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OTHERNAME_cmp
#  define OTHERNAME_cmp OPENSSL_MANGLER(OTHERNAME_cmp)
# endif
#else
# ifndef _OTHERNAME_cmp
#  define _OTHERNAME_cmp OPENSSL_MANGLER_ASM(OTHERNAME_cmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OTHERNAME_free
#  define OTHERNAME_free OPENSSL_MANGLER(OTHERNAME_free)
# endif
#else
# ifndef _OTHERNAME_free
#  define _OTHERNAME_free OPENSSL_MANGLER_ASM(OTHERNAME_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OTHERNAME_it
#  define OTHERNAME_it OPENSSL_MANGLER(OTHERNAME_it)
# endif
#else
# ifndef _OTHERNAME_it
#  define _OTHERNAME_it OPENSSL_MANGLER_ASM(OTHERNAME_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef OTHERNAME_new
#  define OTHERNAME_new OPENSSL_MANGLER(OTHERNAME_new)
# endif
#else
# ifndef _OTHERNAME_new
#  define _OTHERNAME_new OPENSSL_MANGLER_ASM(OTHERNAME_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef parse_ca_names
#  define parse_ca_names OPENSSL_MANGLER(parse_ca_names)
# endif
#else
# ifndef _parse_ca_names
#  define _parse_ca_names OPENSSL_MANGLER_ASM(parse_ca_names)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PBE2PARAM_free
#  define PBE2PARAM_free OPENSSL_MANGLER(PBE2PARAM_free)
# endif
#else
# ifndef _PBE2PARAM_free
#  define _PBE2PARAM_free OPENSSL_MANGLER_ASM(PBE2PARAM_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PBE2PARAM_it
#  define PBE2PARAM_it OPENSSL_MANGLER(PBE2PARAM_it)
# endif
#else
# ifndef _PBE2PARAM_it
#  define _PBE2PARAM_it OPENSSL_MANGLER_ASM(PBE2PARAM_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PBE2PARAM_new
#  define PBE2PARAM_new OPENSSL_MANGLER(PBE2PARAM_new)
# endif
#else
# ifndef _PBE2PARAM_new
#  define _PBE2PARAM_new OPENSSL_MANGLER_ASM(PBE2PARAM_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PBEPARAM_free
#  define PBEPARAM_free OPENSSL_MANGLER(PBEPARAM_free)
# endif
#else
# ifndef _PBEPARAM_free
#  define _PBEPARAM_free OPENSSL_MANGLER_ASM(PBEPARAM_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PBEPARAM_it
#  define PBEPARAM_it OPENSSL_MANGLER(PBEPARAM_it)
# endif
#else
# ifndef _PBEPARAM_it
#  define _PBEPARAM_it OPENSSL_MANGLER_ASM(PBEPARAM_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PBEPARAM_new
#  define PBEPARAM_new OPENSSL_MANGLER(PBEPARAM_new)
# endif
#else
# ifndef _PBEPARAM_new
#  define _PBEPARAM_new OPENSSL_MANGLER_ASM(PBEPARAM_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PBKDF2PARAM_free
#  define PBKDF2PARAM_free OPENSSL_MANGLER(PBKDF2PARAM_free)
# endif
#else
# ifndef _PBKDF2PARAM_free
#  define _PBKDF2PARAM_free OPENSSL_MANGLER_ASM(PBKDF2PARAM_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PBKDF2PARAM_it
#  define PBKDF2PARAM_it OPENSSL_MANGLER(PBKDF2PARAM_it)
# endif
#else
# ifndef _PBKDF2PARAM_it
#  define _PBKDF2PARAM_it OPENSSL_MANGLER_ASM(PBKDF2PARAM_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PBKDF2PARAM_new
#  define PBKDF2PARAM_new OPENSSL_MANGLER(PBKDF2PARAM_new)
# endif
#else
# ifndef _PBKDF2PARAM_new
#  define _PBKDF2PARAM_new OPENSSL_MANGLER_ASM(PBKDF2PARAM_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_ASN1_read
#  define PEM_ASN1_read OPENSSL_MANGLER(PEM_ASN1_read)
# endif
#else
# ifndef _PEM_ASN1_read
#  define _PEM_ASN1_read OPENSSL_MANGLER_ASM(PEM_ASN1_read)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_ASN1_read_bio
#  define PEM_ASN1_read_bio OPENSSL_MANGLER(PEM_ASN1_read_bio)
# endif
#else
# ifndef _PEM_ASN1_read_bio
#  define _PEM_ASN1_read_bio OPENSSL_MANGLER_ASM(PEM_ASN1_read_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_ASN1_write
#  define PEM_ASN1_write OPENSSL_MANGLER(PEM_ASN1_write)
# endif
#else
# ifndef _PEM_ASN1_write
#  define _PEM_ASN1_write OPENSSL_MANGLER_ASM(PEM_ASN1_write)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_ASN1_write_bio
#  define PEM_ASN1_write_bio OPENSSL_MANGLER(PEM_ASN1_write_bio)
# endif
#else
# ifndef _PEM_ASN1_write_bio
#  define _PEM_ASN1_write_bio OPENSSL_MANGLER_ASM(PEM_ASN1_write_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_bytes_read_bio
#  define PEM_bytes_read_bio OPENSSL_MANGLER(PEM_bytes_read_bio)
# endif
#else
# ifndef _PEM_bytes_read_bio
#  define _PEM_bytes_read_bio OPENSSL_MANGLER_ASM(PEM_bytes_read_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_bytes_read_bio_secmem
#  define PEM_bytes_read_bio_secmem OPENSSL_MANGLER(PEM_bytes_read_bio_secmem)
# endif
#else
# ifndef _PEM_bytes_read_bio_secmem
#  define _PEM_bytes_read_bio_secmem OPENSSL_MANGLER_ASM(PEM_bytes_read_bio_secmem)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pem_check_suffix
#  define pem_check_suffix OPENSSL_MANGLER(pem_check_suffix)
# endif
#else
# ifndef _pem_check_suffix
#  define _pem_check_suffix OPENSSL_MANGLER_ASM(pem_check_suffix)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_def_callback
#  define PEM_def_callback OPENSSL_MANGLER(PEM_def_callback)
# endif
#else
# ifndef _PEM_def_callback
#  define _PEM_def_callback OPENSSL_MANGLER_ASM(PEM_def_callback)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_dek_info
#  define PEM_dek_info OPENSSL_MANGLER(PEM_dek_info)
# endif
#else
# ifndef _PEM_dek_info
#  define _PEM_dek_info OPENSSL_MANGLER_ASM(PEM_dek_info)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_do_header
#  define PEM_do_header OPENSSL_MANGLER(PEM_do_header)
# endif
#else
# ifndef _PEM_do_header
#  define _PEM_do_header OPENSSL_MANGLER_ASM(PEM_do_header)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_get_EVP_CIPHER_INFO
#  define PEM_get_EVP_CIPHER_INFO OPENSSL_MANGLER(PEM_get_EVP_CIPHER_INFO)
# endif
#else
# ifndef _PEM_get_EVP_CIPHER_INFO
#  define _PEM_get_EVP_CIPHER_INFO OPENSSL_MANGLER_ASM(PEM_get_EVP_CIPHER_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_proc_type
#  define PEM_proc_type OPENSSL_MANGLER(PEM_proc_type)
# endif
#else
# ifndef _PEM_proc_type
#  define _PEM_proc_type OPENSSL_MANGLER_ASM(PEM_proc_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read
#  define PEM_read OPENSSL_MANGLER(PEM_read)
# endif
#else
# ifndef _PEM_read
#  define _PEM_read OPENSSL_MANGLER_ASM(PEM_read)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio
#  define PEM_read_bio OPENSSL_MANGLER(PEM_read_bio)
# endif
#else
# ifndef _PEM_read_bio
#  define _PEM_read_bio OPENSSL_MANGLER_ASM(PEM_read_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_CMS
#  define PEM_read_bio_CMS OPENSSL_MANGLER(PEM_read_bio_CMS)
# endif
#else
# ifndef _PEM_read_bio_CMS
#  define _PEM_read_bio_CMS OPENSSL_MANGLER_ASM(PEM_read_bio_CMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_DHparams
#  define PEM_read_bio_DHparams OPENSSL_MANGLER(PEM_read_bio_DHparams)
# endif
#else
# ifndef _PEM_read_bio_DHparams
#  define _PEM_read_bio_DHparams OPENSSL_MANGLER_ASM(PEM_read_bio_DHparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_DSAparams
#  define PEM_read_bio_DSAparams OPENSSL_MANGLER(PEM_read_bio_DSAparams)
# endif
#else
# ifndef _PEM_read_bio_DSAparams
#  define _PEM_read_bio_DSAparams OPENSSL_MANGLER_ASM(PEM_read_bio_DSAparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_DSAPrivateKey
#  define PEM_read_bio_DSAPrivateKey OPENSSL_MANGLER(PEM_read_bio_DSAPrivateKey)
# endif
#else
# ifndef _PEM_read_bio_DSAPrivateKey
#  define _PEM_read_bio_DSAPrivateKey OPENSSL_MANGLER_ASM(PEM_read_bio_DSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_DSA_PUBKEY
#  define PEM_read_bio_DSA_PUBKEY OPENSSL_MANGLER(PEM_read_bio_DSA_PUBKEY)
# endif
#else
# ifndef _PEM_read_bio_DSA_PUBKEY
#  define _PEM_read_bio_DSA_PUBKEY OPENSSL_MANGLER_ASM(PEM_read_bio_DSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_ECPKParameters
#  define PEM_read_bio_ECPKParameters OPENSSL_MANGLER(PEM_read_bio_ECPKParameters)
# endif
#else
# ifndef _PEM_read_bio_ECPKParameters
#  define _PEM_read_bio_ECPKParameters OPENSSL_MANGLER_ASM(PEM_read_bio_ECPKParameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_ECPrivateKey
#  define PEM_read_bio_ECPrivateKey OPENSSL_MANGLER(PEM_read_bio_ECPrivateKey)
# endif
#else
# ifndef _PEM_read_bio_ECPrivateKey
#  define _PEM_read_bio_ECPrivateKey OPENSSL_MANGLER_ASM(PEM_read_bio_ECPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_EC_PUBKEY
#  define PEM_read_bio_EC_PUBKEY OPENSSL_MANGLER(PEM_read_bio_EC_PUBKEY)
# endif
#else
# ifndef _PEM_read_bio_EC_PUBKEY
#  define _PEM_read_bio_EC_PUBKEY OPENSSL_MANGLER_ASM(PEM_read_bio_EC_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_ex
#  define PEM_read_bio_ex OPENSSL_MANGLER(PEM_read_bio_ex)
# endif
#else
# ifndef _PEM_read_bio_ex
#  define _PEM_read_bio_ex OPENSSL_MANGLER_ASM(PEM_read_bio_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_NETSCAPE_CERT_SEQUENCE
#  define PEM_read_bio_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER(PEM_read_bio_NETSCAPE_CERT_SEQUENCE)
# endif
#else
# ifndef _PEM_read_bio_NETSCAPE_CERT_SEQUENCE
#  define _PEM_read_bio_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER_ASM(PEM_read_bio_NETSCAPE_CERT_SEQUENCE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_Parameters
#  define PEM_read_bio_Parameters OPENSSL_MANGLER(PEM_read_bio_Parameters)
# endif
#else
# ifndef _PEM_read_bio_Parameters
#  define _PEM_read_bio_Parameters OPENSSL_MANGLER_ASM(PEM_read_bio_Parameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_PKCS7
#  define PEM_read_bio_PKCS7 OPENSSL_MANGLER(PEM_read_bio_PKCS7)
# endif
#else
# ifndef _PEM_read_bio_PKCS7
#  define _PEM_read_bio_PKCS7 OPENSSL_MANGLER_ASM(PEM_read_bio_PKCS7)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_PKCS8
#  define PEM_read_bio_PKCS8 OPENSSL_MANGLER(PEM_read_bio_PKCS8)
# endif
#else
# ifndef _PEM_read_bio_PKCS8
#  define _PEM_read_bio_PKCS8 OPENSSL_MANGLER_ASM(PEM_read_bio_PKCS8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_PKCS8_PRIV_KEY_INFO
#  define PEM_read_bio_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER(PEM_read_bio_PKCS8_PRIV_KEY_INFO)
# endif
#else
# ifndef _PEM_read_bio_PKCS8_PRIV_KEY_INFO
#  define _PEM_read_bio_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER_ASM(PEM_read_bio_PKCS8_PRIV_KEY_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_PrivateKey
#  define PEM_read_bio_PrivateKey OPENSSL_MANGLER(PEM_read_bio_PrivateKey)
# endif
#else
# ifndef _PEM_read_bio_PrivateKey
#  define _PEM_read_bio_PrivateKey OPENSSL_MANGLER_ASM(PEM_read_bio_PrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_PUBKEY
#  define PEM_read_bio_PUBKEY OPENSSL_MANGLER(PEM_read_bio_PUBKEY)
# endif
#else
# ifndef _PEM_read_bio_PUBKEY
#  define _PEM_read_bio_PUBKEY OPENSSL_MANGLER_ASM(PEM_read_bio_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_RSAPrivateKey
#  define PEM_read_bio_RSAPrivateKey OPENSSL_MANGLER(PEM_read_bio_RSAPrivateKey)
# endif
#else
# ifndef _PEM_read_bio_RSAPrivateKey
#  define _PEM_read_bio_RSAPrivateKey OPENSSL_MANGLER_ASM(PEM_read_bio_RSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_RSA_PUBKEY
#  define PEM_read_bio_RSA_PUBKEY OPENSSL_MANGLER(PEM_read_bio_RSA_PUBKEY)
# endif
#else
# ifndef _PEM_read_bio_RSA_PUBKEY
#  define _PEM_read_bio_RSA_PUBKEY OPENSSL_MANGLER_ASM(PEM_read_bio_RSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_RSAPublicKey
#  define PEM_read_bio_RSAPublicKey OPENSSL_MANGLER(PEM_read_bio_RSAPublicKey)
# endif
#else
# ifndef _PEM_read_bio_RSAPublicKey
#  define _PEM_read_bio_RSAPublicKey OPENSSL_MANGLER_ASM(PEM_read_bio_RSAPublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_SSL_SESSION
#  define PEM_read_bio_SSL_SESSION OPENSSL_MANGLER(PEM_read_bio_SSL_SESSION)
# endif
#else
# ifndef _PEM_read_bio_SSL_SESSION
#  define _PEM_read_bio_SSL_SESSION OPENSSL_MANGLER_ASM(PEM_read_bio_SSL_SESSION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_X509
#  define PEM_read_bio_X509 OPENSSL_MANGLER(PEM_read_bio_X509)
# endif
#else
# ifndef _PEM_read_bio_X509
#  define _PEM_read_bio_X509 OPENSSL_MANGLER_ASM(PEM_read_bio_X509)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_X509_AUX
#  define PEM_read_bio_X509_AUX OPENSSL_MANGLER(PEM_read_bio_X509_AUX)
# endif
#else
# ifndef _PEM_read_bio_X509_AUX
#  define _PEM_read_bio_X509_AUX OPENSSL_MANGLER_ASM(PEM_read_bio_X509_AUX)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_X509_CRL
#  define PEM_read_bio_X509_CRL OPENSSL_MANGLER(PEM_read_bio_X509_CRL)
# endif
#else
# ifndef _PEM_read_bio_X509_CRL
#  define _PEM_read_bio_X509_CRL OPENSSL_MANGLER_ASM(PEM_read_bio_X509_CRL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_bio_X509_REQ
#  define PEM_read_bio_X509_REQ OPENSSL_MANGLER(PEM_read_bio_X509_REQ)
# endif
#else
# ifndef _PEM_read_bio_X509_REQ
#  define _PEM_read_bio_X509_REQ OPENSSL_MANGLER_ASM(PEM_read_bio_X509_REQ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_CMS
#  define PEM_read_CMS OPENSSL_MANGLER(PEM_read_CMS)
# endif
#else
# ifndef _PEM_read_CMS
#  define _PEM_read_CMS OPENSSL_MANGLER_ASM(PEM_read_CMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_DHparams
#  define PEM_read_DHparams OPENSSL_MANGLER(PEM_read_DHparams)
# endif
#else
# ifndef _PEM_read_DHparams
#  define _PEM_read_DHparams OPENSSL_MANGLER_ASM(PEM_read_DHparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_DSAparams
#  define PEM_read_DSAparams OPENSSL_MANGLER(PEM_read_DSAparams)
# endif
#else
# ifndef _PEM_read_DSAparams
#  define _PEM_read_DSAparams OPENSSL_MANGLER_ASM(PEM_read_DSAparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_DSAPrivateKey
#  define PEM_read_DSAPrivateKey OPENSSL_MANGLER(PEM_read_DSAPrivateKey)
# endif
#else
# ifndef _PEM_read_DSAPrivateKey
#  define _PEM_read_DSAPrivateKey OPENSSL_MANGLER_ASM(PEM_read_DSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_DSA_PUBKEY
#  define PEM_read_DSA_PUBKEY OPENSSL_MANGLER(PEM_read_DSA_PUBKEY)
# endif
#else
# ifndef _PEM_read_DSA_PUBKEY
#  define _PEM_read_DSA_PUBKEY OPENSSL_MANGLER_ASM(PEM_read_DSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_ECPKParameters
#  define PEM_read_ECPKParameters OPENSSL_MANGLER(PEM_read_ECPKParameters)
# endif
#else
# ifndef _PEM_read_ECPKParameters
#  define _PEM_read_ECPKParameters OPENSSL_MANGLER_ASM(PEM_read_ECPKParameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_ECPrivateKey
#  define PEM_read_ECPrivateKey OPENSSL_MANGLER(PEM_read_ECPrivateKey)
# endif
#else
# ifndef _PEM_read_ECPrivateKey
#  define _PEM_read_ECPrivateKey OPENSSL_MANGLER_ASM(PEM_read_ECPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_EC_PUBKEY
#  define PEM_read_EC_PUBKEY OPENSSL_MANGLER(PEM_read_EC_PUBKEY)
# endif
#else
# ifndef _PEM_read_EC_PUBKEY
#  define _PEM_read_EC_PUBKEY OPENSSL_MANGLER_ASM(PEM_read_EC_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_NETSCAPE_CERT_SEQUENCE
#  define PEM_read_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER(PEM_read_NETSCAPE_CERT_SEQUENCE)
# endif
#else
# ifndef _PEM_read_NETSCAPE_CERT_SEQUENCE
#  define _PEM_read_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER_ASM(PEM_read_NETSCAPE_CERT_SEQUENCE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_PKCS7
#  define PEM_read_PKCS7 OPENSSL_MANGLER(PEM_read_PKCS7)
# endif
#else
# ifndef _PEM_read_PKCS7
#  define _PEM_read_PKCS7 OPENSSL_MANGLER_ASM(PEM_read_PKCS7)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_PKCS8
#  define PEM_read_PKCS8 OPENSSL_MANGLER(PEM_read_PKCS8)
# endif
#else
# ifndef _PEM_read_PKCS8
#  define _PEM_read_PKCS8 OPENSSL_MANGLER_ASM(PEM_read_PKCS8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_PKCS8_PRIV_KEY_INFO
#  define PEM_read_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER(PEM_read_PKCS8_PRIV_KEY_INFO)
# endif
#else
# ifndef _PEM_read_PKCS8_PRIV_KEY_INFO
#  define _PEM_read_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER_ASM(PEM_read_PKCS8_PRIV_KEY_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_PrivateKey
#  define PEM_read_PrivateKey OPENSSL_MANGLER(PEM_read_PrivateKey)
# endif
#else
# ifndef _PEM_read_PrivateKey
#  define _PEM_read_PrivateKey OPENSSL_MANGLER_ASM(PEM_read_PrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_PUBKEY
#  define PEM_read_PUBKEY OPENSSL_MANGLER(PEM_read_PUBKEY)
# endif
#else
# ifndef _PEM_read_PUBKEY
#  define _PEM_read_PUBKEY OPENSSL_MANGLER_ASM(PEM_read_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_RSAPrivateKey
#  define PEM_read_RSAPrivateKey OPENSSL_MANGLER(PEM_read_RSAPrivateKey)
# endif
#else
# ifndef _PEM_read_RSAPrivateKey
#  define _PEM_read_RSAPrivateKey OPENSSL_MANGLER_ASM(PEM_read_RSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_RSA_PUBKEY
#  define PEM_read_RSA_PUBKEY OPENSSL_MANGLER(PEM_read_RSA_PUBKEY)
# endif
#else
# ifndef _PEM_read_RSA_PUBKEY
#  define _PEM_read_RSA_PUBKEY OPENSSL_MANGLER_ASM(PEM_read_RSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_RSAPublicKey
#  define PEM_read_RSAPublicKey OPENSSL_MANGLER(PEM_read_RSAPublicKey)
# endif
#else
# ifndef _PEM_read_RSAPublicKey
#  define _PEM_read_RSAPublicKey OPENSSL_MANGLER_ASM(PEM_read_RSAPublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_SSL_SESSION
#  define PEM_read_SSL_SESSION OPENSSL_MANGLER(PEM_read_SSL_SESSION)
# endif
#else
# ifndef _PEM_read_SSL_SESSION
#  define _PEM_read_SSL_SESSION OPENSSL_MANGLER_ASM(PEM_read_SSL_SESSION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_X509
#  define PEM_read_X509 OPENSSL_MANGLER(PEM_read_X509)
# endif
#else
# ifndef _PEM_read_X509
#  define _PEM_read_X509 OPENSSL_MANGLER_ASM(PEM_read_X509)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_X509_AUX
#  define PEM_read_X509_AUX OPENSSL_MANGLER(PEM_read_X509_AUX)
# endif
#else
# ifndef _PEM_read_X509_AUX
#  define _PEM_read_X509_AUX OPENSSL_MANGLER_ASM(PEM_read_X509_AUX)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_X509_CRL
#  define PEM_read_X509_CRL OPENSSL_MANGLER(PEM_read_X509_CRL)
# endif
#else
# ifndef _PEM_read_X509_CRL
#  define _PEM_read_X509_CRL OPENSSL_MANGLER_ASM(PEM_read_X509_CRL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_read_X509_REQ
#  define PEM_read_X509_REQ OPENSSL_MANGLER(PEM_read_X509_REQ)
# endif
#else
# ifndef _PEM_read_X509_REQ
#  define _PEM_read_X509_REQ OPENSSL_MANGLER_ASM(PEM_read_X509_REQ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_SignFinal
#  define PEM_SignFinal OPENSSL_MANGLER(PEM_SignFinal)
# endif
#else
# ifndef _PEM_SignFinal
#  define _PEM_SignFinal OPENSSL_MANGLER_ASM(PEM_SignFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_SignInit
#  define PEM_SignInit OPENSSL_MANGLER(PEM_SignInit)
# endif
#else
# ifndef _PEM_SignInit
#  define _PEM_SignInit OPENSSL_MANGLER_ASM(PEM_SignInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_SignUpdate
#  define PEM_SignUpdate OPENSSL_MANGLER(PEM_SignUpdate)
# endif
#else
# ifndef _PEM_SignUpdate
#  define _PEM_SignUpdate OPENSSL_MANGLER_ASM(PEM_SignUpdate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write
#  define PEM_write OPENSSL_MANGLER(PEM_write)
# endif
#else
# ifndef _PEM_write
#  define _PEM_write OPENSSL_MANGLER_ASM(PEM_write)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio
#  define PEM_write_bio OPENSSL_MANGLER(PEM_write_bio)
# endif
#else
# ifndef _PEM_write_bio
#  define _PEM_write_bio OPENSSL_MANGLER_ASM(PEM_write_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_ASN1_stream
#  define PEM_write_bio_ASN1_stream OPENSSL_MANGLER(PEM_write_bio_ASN1_stream)
# endif
#else
# ifndef _PEM_write_bio_ASN1_stream
#  define _PEM_write_bio_ASN1_stream OPENSSL_MANGLER_ASM(PEM_write_bio_ASN1_stream)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_CMS
#  define PEM_write_bio_CMS OPENSSL_MANGLER(PEM_write_bio_CMS)
# endif
#else
# ifndef _PEM_write_bio_CMS
#  define _PEM_write_bio_CMS OPENSSL_MANGLER_ASM(PEM_write_bio_CMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_CMS_stream
#  define PEM_write_bio_CMS_stream OPENSSL_MANGLER(PEM_write_bio_CMS_stream)
# endif
#else
# ifndef _PEM_write_bio_CMS_stream
#  define _PEM_write_bio_CMS_stream OPENSSL_MANGLER_ASM(PEM_write_bio_CMS_stream)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_DHparams
#  define PEM_write_bio_DHparams OPENSSL_MANGLER(PEM_write_bio_DHparams)
# endif
#else
# ifndef _PEM_write_bio_DHparams
#  define _PEM_write_bio_DHparams OPENSSL_MANGLER_ASM(PEM_write_bio_DHparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_DHxparams
#  define PEM_write_bio_DHxparams OPENSSL_MANGLER(PEM_write_bio_DHxparams)
# endif
#else
# ifndef _PEM_write_bio_DHxparams
#  define _PEM_write_bio_DHxparams OPENSSL_MANGLER_ASM(PEM_write_bio_DHxparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_DSAparams
#  define PEM_write_bio_DSAparams OPENSSL_MANGLER(PEM_write_bio_DSAparams)
# endif
#else
# ifndef _PEM_write_bio_DSAparams
#  define _PEM_write_bio_DSAparams OPENSSL_MANGLER_ASM(PEM_write_bio_DSAparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_DSAPrivateKey
#  define PEM_write_bio_DSAPrivateKey OPENSSL_MANGLER(PEM_write_bio_DSAPrivateKey)
# endif
#else
# ifndef _PEM_write_bio_DSAPrivateKey
#  define _PEM_write_bio_DSAPrivateKey OPENSSL_MANGLER_ASM(PEM_write_bio_DSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_DSA_PUBKEY
#  define PEM_write_bio_DSA_PUBKEY OPENSSL_MANGLER(PEM_write_bio_DSA_PUBKEY)
# endif
#else
# ifndef _PEM_write_bio_DSA_PUBKEY
#  define _PEM_write_bio_DSA_PUBKEY OPENSSL_MANGLER_ASM(PEM_write_bio_DSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_ECPKParameters
#  define PEM_write_bio_ECPKParameters OPENSSL_MANGLER(PEM_write_bio_ECPKParameters)
# endif
#else
# ifndef _PEM_write_bio_ECPKParameters
#  define _PEM_write_bio_ECPKParameters OPENSSL_MANGLER_ASM(PEM_write_bio_ECPKParameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_ECPrivateKey
#  define PEM_write_bio_ECPrivateKey OPENSSL_MANGLER(PEM_write_bio_ECPrivateKey)
# endif
#else
# ifndef _PEM_write_bio_ECPrivateKey
#  define _PEM_write_bio_ECPrivateKey OPENSSL_MANGLER_ASM(PEM_write_bio_ECPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_EC_PUBKEY
#  define PEM_write_bio_EC_PUBKEY OPENSSL_MANGLER(PEM_write_bio_EC_PUBKEY)
# endif
#else
# ifndef _PEM_write_bio_EC_PUBKEY
#  define _PEM_write_bio_EC_PUBKEY OPENSSL_MANGLER_ASM(PEM_write_bio_EC_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_NETSCAPE_CERT_SEQUENCE
#  define PEM_write_bio_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER(PEM_write_bio_NETSCAPE_CERT_SEQUENCE)
# endif
#else
# ifndef _PEM_write_bio_NETSCAPE_CERT_SEQUENCE
#  define _PEM_write_bio_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER_ASM(PEM_write_bio_NETSCAPE_CERT_SEQUENCE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_Parameters
#  define PEM_write_bio_Parameters OPENSSL_MANGLER(PEM_write_bio_Parameters)
# endif
#else
# ifndef _PEM_write_bio_Parameters
#  define _PEM_write_bio_Parameters OPENSSL_MANGLER_ASM(PEM_write_bio_Parameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_PKCS7
#  define PEM_write_bio_PKCS7 OPENSSL_MANGLER(PEM_write_bio_PKCS7)
# endif
#else
# ifndef _PEM_write_bio_PKCS7
#  define _PEM_write_bio_PKCS7 OPENSSL_MANGLER_ASM(PEM_write_bio_PKCS7)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_PKCS7_stream
#  define PEM_write_bio_PKCS7_stream OPENSSL_MANGLER(PEM_write_bio_PKCS7_stream)
# endif
#else
# ifndef _PEM_write_bio_PKCS7_stream
#  define _PEM_write_bio_PKCS7_stream OPENSSL_MANGLER_ASM(PEM_write_bio_PKCS7_stream)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_PKCS8
#  define PEM_write_bio_PKCS8 OPENSSL_MANGLER(PEM_write_bio_PKCS8)
# endif
#else
# ifndef _PEM_write_bio_PKCS8
#  define _PEM_write_bio_PKCS8 OPENSSL_MANGLER_ASM(PEM_write_bio_PKCS8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_PKCS8PrivateKey
#  define PEM_write_bio_PKCS8PrivateKey OPENSSL_MANGLER(PEM_write_bio_PKCS8PrivateKey)
# endif
#else
# ifndef _PEM_write_bio_PKCS8PrivateKey
#  define _PEM_write_bio_PKCS8PrivateKey OPENSSL_MANGLER_ASM(PEM_write_bio_PKCS8PrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_PKCS8PrivateKey_nid
#  define PEM_write_bio_PKCS8PrivateKey_nid OPENSSL_MANGLER(PEM_write_bio_PKCS8PrivateKey_nid)
# endif
#else
# ifndef _PEM_write_bio_PKCS8PrivateKey_nid
#  define _PEM_write_bio_PKCS8PrivateKey_nid OPENSSL_MANGLER_ASM(PEM_write_bio_PKCS8PrivateKey_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_PKCS8_PRIV_KEY_INFO
#  define PEM_write_bio_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER(PEM_write_bio_PKCS8_PRIV_KEY_INFO)
# endif
#else
# ifndef _PEM_write_bio_PKCS8_PRIV_KEY_INFO
#  define _PEM_write_bio_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER_ASM(PEM_write_bio_PKCS8_PRIV_KEY_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_PrivateKey
#  define PEM_write_bio_PrivateKey OPENSSL_MANGLER(PEM_write_bio_PrivateKey)
# endif
#else
# ifndef _PEM_write_bio_PrivateKey
#  define _PEM_write_bio_PrivateKey OPENSSL_MANGLER_ASM(PEM_write_bio_PrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_PrivateKey_traditional
#  define PEM_write_bio_PrivateKey_traditional OPENSSL_MANGLER(PEM_write_bio_PrivateKey_traditional)
# endif
#else
# ifndef _PEM_write_bio_PrivateKey_traditional
#  define _PEM_write_bio_PrivateKey_traditional OPENSSL_MANGLER_ASM(PEM_write_bio_PrivateKey_traditional)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_PUBKEY
#  define PEM_write_bio_PUBKEY OPENSSL_MANGLER(PEM_write_bio_PUBKEY)
# endif
#else
# ifndef _PEM_write_bio_PUBKEY
#  define _PEM_write_bio_PUBKEY OPENSSL_MANGLER_ASM(PEM_write_bio_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_RSAPrivateKey
#  define PEM_write_bio_RSAPrivateKey OPENSSL_MANGLER(PEM_write_bio_RSAPrivateKey)
# endif
#else
# ifndef _PEM_write_bio_RSAPrivateKey
#  define _PEM_write_bio_RSAPrivateKey OPENSSL_MANGLER_ASM(PEM_write_bio_RSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_RSA_PUBKEY
#  define PEM_write_bio_RSA_PUBKEY OPENSSL_MANGLER(PEM_write_bio_RSA_PUBKEY)
# endif
#else
# ifndef _PEM_write_bio_RSA_PUBKEY
#  define _PEM_write_bio_RSA_PUBKEY OPENSSL_MANGLER_ASM(PEM_write_bio_RSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_RSAPublicKey
#  define PEM_write_bio_RSAPublicKey OPENSSL_MANGLER(PEM_write_bio_RSAPublicKey)
# endif
#else
# ifndef _PEM_write_bio_RSAPublicKey
#  define _PEM_write_bio_RSAPublicKey OPENSSL_MANGLER_ASM(PEM_write_bio_RSAPublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_SSL_SESSION
#  define PEM_write_bio_SSL_SESSION OPENSSL_MANGLER(PEM_write_bio_SSL_SESSION)
# endif
#else
# ifndef _PEM_write_bio_SSL_SESSION
#  define _PEM_write_bio_SSL_SESSION OPENSSL_MANGLER_ASM(PEM_write_bio_SSL_SESSION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_X509
#  define PEM_write_bio_X509 OPENSSL_MANGLER(PEM_write_bio_X509)
# endif
#else
# ifndef _PEM_write_bio_X509
#  define _PEM_write_bio_X509 OPENSSL_MANGLER_ASM(PEM_write_bio_X509)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_X509_AUX
#  define PEM_write_bio_X509_AUX OPENSSL_MANGLER(PEM_write_bio_X509_AUX)
# endif
#else
# ifndef _PEM_write_bio_X509_AUX
#  define _PEM_write_bio_X509_AUX OPENSSL_MANGLER_ASM(PEM_write_bio_X509_AUX)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_X509_CRL
#  define PEM_write_bio_X509_CRL OPENSSL_MANGLER(PEM_write_bio_X509_CRL)
# endif
#else
# ifndef _PEM_write_bio_X509_CRL
#  define _PEM_write_bio_X509_CRL OPENSSL_MANGLER_ASM(PEM_write_bio_X509_CRL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_X509_REQ
#  define PEM_write_bio_X509_REQ OPENSSL_MANGLER(PEM_write_bio_X509_REQ)
# endif
#else
# ifndef _PEM_write_bio_X509_REQ
#  define _PEM_write_bio_X509_REQ OPENSSL_MANGLER_ASM(PEM_write_bio_X509_REQ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_bio_X509_REQ_NEW
#  define PEM_write_bio_X509_REQ_NEW OPENSSL_MANGLER(PEM_write_bio_X509_REQ_NEW)
# endif
#else
# ifndef _PEM_write_bio_X509_REQ_NEW
#  define _PEM_write_bio_X509_REQ_NEW OPENSSL_MANGLER_ASM(PEM_write_bio_X509_REQ_NEW)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_CMS
#  define PEM_write_CMS OPENSSL_MANGLER(PEM_write_CMS)
# endif
#else
# ifndef _PEM_write_CMS
#  define _PEM_write_CMS OPENSSL_MANGLER_ASM(PEM_write_CMS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_DHparams
#  define PEM_write_DHparams OPENSSL_MANGLER(PEM_write_DHparams)
# endif
#else
# ifndef _PEM_write_DHparams
#  define _PEM_write_DHparams OPENSSL_MANGLER_ASM(PEM_write_DHparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_DHxparams
#  define PEM_write_DHxparams OPENSSL_MANGLER(PEM_write_DHxparams)
# endif
#else
# ifndef _PEM_write_DHxparams
#  define _PEM_write_DHxparams OPENSSL_MANGLER_ASM(PEM_write_DHxparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_DSAparams
#  define PEM_write_DSAparams OPENSSL_MANGLER(PEM_write_DSAparams)
# endif
#else
# ifndef _PEM_write_DSAparams
#  define _PEM_write_DSAparams OPENSSL_MANGLER_ASM(PEM_write_DSAparams)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_DSAPrivateKey
#  define PEM_write_DSAPrivateKey OPENSSL_MANGLER(PEM_write_DSAPrivateKey)
# endif
#else
# ifndef _PEM_write_DSAPrivateKey
#  define _PEM_write_DSAPrivateKey OPENSSL_MANGLER_ASM(PEM_write_DSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_DSA_PUBKEY
#  define PEM_write_DSA_PUBKEY OPENSSL_MANGLER(PEM_write_DSA_PUBKEY)
# endif
#else
# ifndef _PEM_write_DSA_PUBKEY
#  define _PEM_write_DSA_PUBKEY OPENSSL_MANGLER_ASM(PEM_write_DSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_ECPKParameters
#  define PEM_write_ECPKParameters OPENSSL_MANGLER(PEM_write_ECPKParameters)
# endif
#else
# ifndef _PEM_write_ECPKParameters
#  define _PEM_write_ECPKParameters OPENSSL_MANGLER_ASM(PEM_write_ECPKParameters)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_ECPrivateKey
#  define PEM_write_ECPrivateKey OPENSSL_MANGLER(PEM_write_ECPrivateKey)
# endif
#else
# ifndef _PEM_write_ECPrivateKey
#  define _PEM_write_ECPrivateKey OPENSSL_MANGLER_ASM(PEM_write_ECPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_EC_PUBKEY
#  define PEM_write_EC_PUBKEY OPENSSL_MANGLER(PEM_write_EC_PUBKEY)
# endif
#else
# ifndef _PEM_write_EC_PUBKEY
#  define _PEM_write_EC_PUBKEY OPENSSL_MANGLER_ASM(PEM_write_EC_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_NETSCAPE_CERT_SEQUENCE
#  define PEM_write_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER(PEM_write_NETSCAPE_CERT_SEQUENCE)
# endif
#else
# ifndef _PEM_write_NETSCAPE_CERT_SEQUENCE
#  define _PEM_write_NETSCAPE_CERT_SEQUENCE OPENSSL_MANGLER_ASM(PEM_write_NETSCAPE_CERT_SEQUENCE)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_PKCS7
#  define PEM_write_PKCS7 OPENSSL_MANGLER(PEM_write_PKCS7)
# endif
#else
# ifndef _PEM_write_PKCS7
#  define _PEM_write_PKCS7 OPENSSL_MANGLER_ASM(PEM_write_PKCS7)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_PKCS8
#  define PEM_write_PKCS8 OPENSSL_MANGLER(PEM_write_PKCS8)
# endif
#else
# ifndef _PEM_write_PKCS8
#  define _PEM_write_PKCS8 OPENSSL_MANGLER_ASM(PEM_write_PKCS8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_PKCS8PrivateKey
#  define PEM_write_PKCS8PrivateKey OPENSSL_MANGLER(PEM_write_PKCS8PrivateKey)
# endif
#else
# ifndef _PEM_write_PKCS8PrivateKey
#  define _PEM_write_PKCS8PrivateKey OPENSSL_MANGLER_ASM(PEM_write_PKCS8PrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_PKCS8PrivateKey_nid
#  define PEM_write_PKCS8PrivateKey_nid OPENSSL_MANGLER(PEM_write_PKCS8PrivateKey_nid)
# endif
#else
# ifndef _PEM_write_PKCS8PrivateKey_nid
#  define _PEM_write_PKCS8PrivateKey_nid OPENSSL_MANGLER_ASM(PEM_write_PKCS8PrivateKey_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_PKCS8_PRIV_KEY_INFO
#  define PEM_write_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER(PEM_write_PKCS8_PRIV_KEY_INFO)
# endif
#else
# ifndef _PEM_write_PKCS8_PRIV_KEY_INFO
#  define _PEM_write_PKCS8_PRIV_KEY_INFO OPENSSL_MANGLER_ASM(PEM_write_PKCS8_PRIV_KEY_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_PrivateKey
#  define PEM_write_PrivateKey OPENSSL_MANGLER(PEM_write_PrivateKey)
# endif
#else
# ifndef _PEM_write_PrivateKey
#  define _PEM_write_PrivateKey OPENSSL_MANGLER_ASM(PEM_write_PrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_PUBKEY
#  define PEM_write_PUBKEY OPENSSL_MANGLER(PEM_write_PUBKEY)
# endif
#else
# ifndef _PEM_write_PUBKEY
#  define _PEM_write_PUBKEY OPENSSL_MANGLER_ASM(PEM_write_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_RSAPrivateKey
#  define PEM_write_RSAPrivateKey OPENSSL_MANGLER(PEM_write_RSAPrivateKey)
# endif
#else
# ifndef _PEM_write_RSAPrivateKey
#  define _PEM_write_RSAPrivateKey OPENSSL_MANGLER_ASM(PEM_write_RSAPrivateKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_RSA_PUBKEY
#  define PEM_write_RSA_PUBKEY OPENSSL_MANGLER(PEM_write_RSA_PUBKEY)
# endif
#else
# ifndef _PEM_write_RSA_PUBKEY
#  define _PEM_write_RSA_PUBKEY OPENSSL_MANGLER_ASM(PEM_write_RSA_PUBKEY)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_RSAPublicKey
#  define PEM_write_RSAPublicKey OPENSSL_MANGLER(PEM_write_RSAPublicKey)
# endif
#else
# ifndef _PEM_write_RSAPublicKey
#  define _PEM_write_RSAPublicKey OPENSSL_MANGLER_ASM(PEM_write_RSAPublicKey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_SSL_SESSION
#  define PEM_write_SSL_SESSION OPENSSL_MANGLER(PEM_write_SSL_SESSION)
# endif
#else
# ifndef _PEM_write_SSL_SESSION
#  define _PEM_write_SSL_SESSION OPENSSL_MANGLER_ASM(PEM_write_SSL_SESSION)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_X509
#  define PEM_write_X509 OPENSSL_MANGLER(PEM_write_X509)
# endif
#else
# ifndef _PEM_write_X509
#  define _PEM_write_X509 OPENSSL_MANGLER_ASM(PEM_write_X509)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_X509_AUX
#  define PEM_write_X509_AUX OPENSSL_MANGLER(PEM_write_X509_AUX)
# endif
#else
# ifndef _PEM_write_X509_AUX
#  define _PEM_write_X509_AUX OPENSSL_MANGLER_ASM(PEM_write_X509_AUX)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_X509_CRL
#  define PEM_write_X509_CRL OPENSSL_MANGLER(PEM_write_X509_CRL)
# endif
#else
# ifndef _PEM_write_X509_CRL
#  define _PEM_write_X509_CRL OPENSSL_MANGLER_ASM(PEM_write_X509_CRL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_X509_REQ
#  define PEM_write_X509_REQ OPENSSL_MANGLER(PEM_write_X509_REQ)
# endif
#else
# ifndef _PEM_write_X509_REQ
#  define _PEM_write_X509_REQ OPENSSL_MANGLER_ASM(PEM_write_X509_REQ)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_write_X509_REQ_NEW
#  define PEM_write_X509_REQ_NEW OPENSSL_MANGLER(PEM_write_X509_REQ_NEW)
# endif
#else
# ifndef _PEM_write_X509_REQ_NEW
#  define _PEM_write_X509_REQ_NEW OPENSSL_MANGLER_ASM(PEM_write_X509_REQ_NEW)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_X509_INFO_read
#  define PEM_X509_INFO_read OPENSSL_MANGLER(PEM_X509_INFO_read)
# endif
#else
# ifndef _PEM_X509_INFO_read
#  define _PEM_X509_INFO_read OPENSSL_MANGLER_ASM(PEM_X509_INFO_read)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_X509_INFO_read_bio
#  define PEM_X509_INFO_read_bio OPENSSL_MANGLER(PEM_X509_INFO_read_bio)
# endif
#else
# ifndef _PEM_X509_INFO_read_bio
#  define _PEM_X509_INFO_read_bio OPENSSL_MANGLER_ASM(PEM_X509_INFO_read_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PEM_X509_INFO_write_bio
#  define PEM_X509_INFO_write_bio OPENSSL_MANGLER(PEM_X509_INFO_write_bio)
# endif
#else
# ifndef _PEM_X509_INFO_write_bio
#  define _PEM_X509_INFO_write_bio OPENSSL_MANGLER_ASM(PEM_X509_INFO_write_bio)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pitem_free
#  define pitem_free OPENSSL_MANGLER(pitem_free)
# endif
#else
# ifndef _pitem_free
#  define _pitem_free OPENSSL_MANGLER_ASM(pitem_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pitem_new
#  define pitem_new OPENSSL_MANGLER(pitem_new)
# endif
#else
# ifndef _pitem_new
#  define _pitem_new OPENSSL_MANGLER_ASM(pitem_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_add_cert
#  define PKCS12_add_cert OPENSSL_MANGLER(PKCS12_add_cert)
# endif
#else
# ifndef _PKCS12_add_cert
#  define _PKCS12_add_cert OPENSSL_MANGLER_ASM(PKCS12_add_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_add_CSPName_asc
#  define PKCS12_add_CSPName_asc OPENSSL_MANGLER(PKCS12_add_CSPName_asc)
# endif
#else
# ifndef _PKCS12_add_CSPName_asc
#  define _PKCS12_add_CSPName_asc OPENSSL_MANGLER_ASM(PKCS12_add_CSPName_asc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_add_friendlyname_asc
#  define PKCS12_add_friendlyname_asc OPENSSL_MANGLER(PKCS12_add_friendlyname_asc)
# endif
#else
# ifndef _PKCS12_add_friendlyname_asc
#  define _PKCS12_add_friendlyname_asc OPENSSL_MANGLER_ASM(PKCS12_add_friendlyname_asc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_add_friendlyname_uni
#  define PKCS12_add_friendlyname_uni OPENSSL_MANGLER(PKCS12_add_friendlyname_uni)
# endif
#else
# ifndef _PKCS12_add_friendlyname_uni
#  define _PKCS12_add_friendlyname_uni OPENSSL_MANGLER_ASM(PKCS12_add_friendlyname_uni)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_add_friendlyname_utf8
#  define PKCS12_add_friendlyname_utf8 OPENSSL_MANGLER(PKCS12_add_friendlyname_utf8)
# endif
#else
# ifndef _PKCS12_add_friendlyname_utf8
#  define _PKCS12_add_friendlyname_utf8 OPENSSL_MANGLER_ASM(PKCS12_add_friendlyname_utf8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_add_key
#  define PKCS12_add_key OPENSSL_MANGLER(PKCS12_add_key)
# endif
#else
# ifndef _PKCS12_add_key
#  define _PKCS12_add_key OPENSSL_MANGLER_ASM(PKCS12_add_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_add_localkeyid
#  define PKCS12_add_localkeyid OPENSSL_MANGLER(PKCS12_add_localkeyid)
# endif
#else
# ifndef _PKCS12_add_localkeyid
#  define _PKCS12_add_localkeyid OPENSSL_MANGLER_ASM(PKCS12_add_localkeyid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_add_safe
#  define PKCS12_add_safe OPENSSL_MANGLER(PKCS12_add_safe)
# endif
#else
# ifndef _PKCS12_add_safe
#  define _PKCS12_add_safe OPENSSL_MANGLER_ASM(PKCS12_add_safe)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_add_safes
#  define PKCS12_add_safes OPENSSL_MANGLER(PKCS12_add_safes)
# endif
#else
# ifndef _PKCS12_add_safes
#  define _PKCS12_add_safes OPENSSL_MANGLER_ASM(PKCS12_add_safes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_AUTHSAFES_it
#  define PKCS12_AUTHSAFES_it OPENSSL_MANGLER(PKCS12_AUTHSAFES_it)
# endif
#else
# ifndef _PKCS12_AUTHSAFES_it
#  define _PKCS12_AUTHSAFES_it OPENSSL_MANGLER_ASM(PKCS12_AUTHSAFES_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_BAGS_free
#  define PKCS12_BAGS_free OPENSSL_MANGLER(PKCS12_BAGS_free)
# endif
#else
# ifndef _PKCS12_BAGS_free
#  define _PKCS12_BAGS_free OPENSSL_MANGLER_ASM(PKCS12_BAGS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_BAGS_it
#  define PKCS12_BAGS_it OPENSSL_MANGLER(PKCS12_BAGS_it)
# endif
#else
# ifndef _PKCS12_BAGS_it
#  define _PKCS12_BAGS_it OPENSSL_MANGLER_ASM(PKCS12_BAGS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_BAGS_new
#  define PKCS12_BAGS_new OPENSSL_MANGLER(PKCS12_BAGS_new)
# endif
#else
# ifndef _PKCS12_BAGS_new
#  define _PKCS12_BAGS_new OPENSSL_MANGLER_ASM(PKCS12_BAGS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_create
#  define PKCS12_create OPENSSL_MANGLER(PKCS12_create)
# endif
#else
# ifndef _PKCS12_create
#  define _PKCS12_create OPENSSL_MANGLER_ASM(PKCS12_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_decrypt_skey
#  define PKCS12_decrypt_skey OPENSSL_MANGLER(PKCS12_decrypt_skey)
# endif
#else
# ifndef _PKCS12_decrypt_skey
#  define _PKCS12_decrypt_skey OPENSSL_MANGLER_ASM(PKCS12_decrypt_skey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_free
#  define PKCS12_free OPENSSL_MANGLER(PKCS12_free)
# endif
#else
# ifndef _PKCS12_free
#  define _PKCS12_free OPENSSL_MANGLER_ASM(PKCS12_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_gen_mac
#  define PKCS12_gen_mac OPENSSL_MANGLER(PKCS12_gen_mac)
# endif
#else
# ifndef _PKCS12_gen_mac
#  define _PKCS12_gen_mac OPENSSL_MANGLER_ASM(PKCS12_gen_mac)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_get0_mac
#  define PKCS12_get0_mac OPENSSL_MANGLER(PKCS12_get0_mac)
# endif
#else
# ifndef _PKCS12_get0_mac
#  define _PKCS12_get0_mac OPENSSL_MANGLER_ASM(PKCS12_get0_mac)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_get_attr
#  define PKCS12_get_attr OPENSSL_MANGLER(PKCS12_get_attr)
# endif
#else
# ifndef _PKCS12_get_attr
#  define _PKCS12_get_attr OPENSSL_MANGLER_ASM(PKCS12_get_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_get_attr_gen
#  define PKCS12_get_attr_gen OPENSSL_MANGLER(PKCS12_get_attr_gen)
# endif
#else
# ifndef _PKCS12_get_attr_gen
#  define _PKCS12_get_attr_gen OPENSSL_MANGLER_ASM(PKCS12_get_attr_gen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_get_friendlyname
#  define PKCS12_get_friendlyname OPENSSL_MANGLER(PKCS12_get_friendlyname)
# endif
#else
# ifndef _PKCS12_get_friendlyname
#  define _PKCS12_get_friendlyname OPENSSL_MANGLER_ASM(PKCS12_get_friendlyname)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_init
#  define PKCS12_init OPENSSL_MANGLER(PKCS12_init)
# endif
#else
# ifndef _PKCS12_init
#  define _PKCS12_init OPENSSL_MANGLER_ASM(PKCS12_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_it
#  define PKCS12_it OPENSSL_MANGLER(PKCS12_it)
# endif
#else
# ifndef _PKCS12_it
#  define _PKCS12_it OPENSSL_MANGLER_ASM(PKCS12_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_item_decrypt_d2i
#  define PKCS12_item_decrypt_d2i OPENSSL_MANGLER(PKCS12_item_decrypt_d2i)
# endif
#else
# ifndef _PKCS12_item_decrypt_d2i
#  define _PKCS12_item_decrypt_d2i OPENSSL_MANGLER_ASM(PKCS12_item_decrypt_d2i)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_item_i2d_encrypt
#  define PKCS12_item_i2d_encrypt OPENSSL_MANGLER(PKCS12_item_i2d_encrypt)
# endif
#else
# ifndef _PKCS12_item_i2d_encrypt
#  define _PKCS12_item_i2d_encrypt OPENSSL_MANGLER_ASM(PKCS12_item_i2d_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_item_pack_safebag
#  define PKCS12_item_pack_safebag OPENSSL_MANGLER(PKCS12_item_pack_safebag)
# endif
#else
# ifndef _PKCS12_item_pack_safebag
#  define _PKCS12_item_pack_safebag OPENSSL_MANGLER_ASM(PKCS12_item_pack_safebag)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_key_gen_asc
#  define PKCS12_key_gen_asc OPENSSL_MANGLER(PKCS12_key_gen_asc)
# endif
#else
# ifndef _PKCS12_key_gen_asc
#  define _PKCS12_key_gen_asc OPENSSL_MANGLER_ASM(PKCS12_key_gen_asc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_key_gen_uni
#  define PKCS12_key_gen_uni OPENSSL_MANGLER(PKCS12_key_gen_uni)
# endif
#else
# ifndef _PKCS12_key_gen_uni
#  define _PKCS12_key_gen_uni OPENSSL_MANGLER_ASM(PKCS12_key_gen_uni)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_key_gen_utf8
#  define PKCS12_key_gen_utf8 OPENSSL_MANGLER(PKCS12_key_gen_utf8)
# endif
#else
# ifndef _PKCS12_key_gen_utf8
#  define _PKCS12_key_gen_utf8 OPENSSL_MANGLER_ASM(PKCS12_key_gen_utf8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_MAC_DATA_free
#  define PKCS12_MAC_DATA_free OPENSSL_MANGLER(PKCS12_MAC_DATA_free)
# endif
#else
# ifndef _PKCS12_MAC_DATA_free
#  define _PKCS12_MAC_DATA_free OPENSSL_MANGLER_ASM(PKCS12_MAC_DATA_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_MAC_DATA_it
#  define PKCS12_MAC_DATA_it OPENSSL_MANGLER(PKCS12_MAC_DATA_it)
# endif
#else
# ifndef _PKCS12_MAC_DATA_it
#  define _PKCS12_MAC_DATA_it OPENSSL_MANGLER_ASM(PKCS12_MAC_DATA_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_MAC_DATA_new
#  define PKCS12_MAC_DATA_new OPENSSL_MANGLER(PKCS12_MAC_DATA_new)
# endif
#else
# ifndef _PKCS12_MAC_DATA_new
#  define _PKCS12_MAC_DATA_new OPENSSL_MANGLER_ASM(PKCS12_MAC_DATA_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_mac_present
#  define PKCS12_mac_present OPENSSL_MANGLER(PKCS12_mac_present)
# endif
#else
# ifndef _PKCS12_mac_present
#  define _PKCS12_mac_present OPENSSL_MANGLER_ASM(PKCS12_mac_present)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_new
#  define PKCS12_new OPENSSL_MANGLER(PKCS12_new)
# endif
#else
# ifndef _PKCS12_new
#  define _PKCS12_new OPENSSL_MANGLER_ASM(PKCS12_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_newpass
#  define PKCS12_newpass OPENSSL_MANGLER(PKCS12_newpass)
# endif
#else
# ifndef _PKCS12_newpass
#  define _PKCS12_newpass OPENSSL_MANGLER_ASM(PKCS12_newpass)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_pack_authsafes
#  define PKCS12_pack_authsafes OPENSSL_MANGLER(PKCS12_pack_authsafes)
# endif
#else
# ifndef _PKCS12_pack_authsafes
#  define _PKCS12_pack_authsafes OPENSSL_MANGLER_ASM(PKCS12_pack_authsafes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_pack_p7data
#  define PKCS12_pack_p7data OPENSSL_MANGLER(PKCS12_pack_p7data)
# endif
#else
# ifndef _PKCS12_pack_p7data
#  define _PKCS12_pack_p7data OPENSSL_MANGLER_ASM(PKCS12_pack_p7data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_pack_p7encdata
#  define PKCS12_pack_p7encdata OPENSSL_MANGLER(PKCS12_pack_p7encdata)
# endif
#else
# ifndef _PKCS12_pack_p7encdata
#  define _PKCS12_pack_p7encdata OPENSSL_MANGLER_ASM(PKCS12_pack_p7encdata)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_parse
#  define PKCS12_parse OPENSSL_MANGLER(PKCS12_parse)
# endif
#else
# ifndef _PKCS12_parse
#  define _PKCS12_parse OPENSSL_MANGLER_ASM(PKCS12_parse)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_PBE_add
#  define PKCS12_PBE_add OPENSSL_MANGLER(PKCS12_PBE_add)
# endif
#else
# ifndef _PKCS12_PBE_add
#  define _PKCS12_PBE_add OPENSSL_MANGLER_ASM(PKCS12_PBE_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_pbe_crypt
#  define PKCS12_pbe_crypt OPENSSL_MANGLER(PKCS12_pbe_crypt)
# endif
#else
# ifndef _PKCS12_pbe_crypt
#  define _PKCS12_pbe_crypt OPENSSL_MANGLER_ASM(PKCS12_pbe_crypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_PBE_keyivgen
#  define PKCS12_PBE_keyivgen OPENSSL_MANGLER(PKCS12_PBE_keyivgen)
# endif
#else
# ifndef _PKCS12_PBE_keyivgen
#  define _PKCS12_PBE_keyivgen OPENSSL_MANGLER_ASM(PKCS12_PBE_keyivgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_create0_p8inf
#  define PKCS12_SAFEBAG_create0_p8inf OPENSSL_MANGLER(PKCS12_SAFEBAG_create0_p8inf)
# endif
#else
# ifndef _PKCS12_SAFEBAG_create0_p8inf
#  define _PKCS12_SAFEBAG_create0_p8inf OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_create0_p8inf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_create0_pkcs8
#  define PKCS12_SAFEBAG_create0_pkcs8 OPENSSL_MANGLER(PKCS12_SAFEBAG_create0_pkcs8)
# endif
#else
# ifndef _PKCS12_SAFEBAG_create0_pkcs8
#  define _PKCS12_SAFEBAG_create0_pkcs8 OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_create0_pkcs8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_create_cert
#  define PKCS12_SAFEBAG_create_cert OPENSSL_MANGLER(PKCS12_SAFEBAG_create_cert)
# endif
#else
# ifndef _PKCS12_SAFEBAG_create_cert
#  define _PKCS12_SAFEBAG_create_cert OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_create_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_create_crl
#  define PKCS12_SAFEBAG_create_crl OPENSSL_MANGLER(PKCS12_SAFEBAG_create_crl)
# endif
#else
# ifndef _PKCS12_SAFEBAG_create_crl
#  define _PKCS12_SAFEBAG_create_crl OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_create_crl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_create_pkcs8_encrypt
#  define PKCS12_SAFEBAG_create_pkcs8_encrypt OPENSSL_MANGLER(PKCS12_SAFEBAG_create_pkcs8_encrypt)
# endif
#else
# ifndef _PKCS12_SAFEBAG_create_pkcs8_encrypt
#  define _PKCS12_SAFEBAG_create_pkcs8_encrypt OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_create_pkcs8_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_free
#  define PKCS12_SAFEBAG_free OPENSSL_MANGLER(PKCS12_SAFEBAG_free)
# endif
#else
# ifndef _PKCS12_SAFEBAG_free
#  define _PKCS12_SAFEBAG_free OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_get0_attr
#  define PKCS12_SAFEBAG_get0_attr OPENSSL_MANGLER(PKCS12_SAFEBAG_get0_attr)
# endif
#else
# ifndef _PKCS12_SAFEBAG_get0_attr
#  define _PKCS12_SAFEBAG_get0_attr OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_get0_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_get0_attrs
#  define PKCS12_SAFEBAG_get0_attrs OPENSSL_MANGLER(PKCS12_SAFEBAG_get0_attrs)
# endif
#else
# ifndef _PKCS12_SAFEBAG_get0_attrs
#  define _PKCS12_SAFEBAG_get0_attrs OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_get0_attrs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_get0_p8inf
#  define PKCS12_SAFEBAG_get0_p8inf OPENSSL_MANGLER(PKCS12_SAFEBAG_get0_p8inf)
# endif
#else
# ifndef _PKCS12_SAFEBAG_get0_p8inf
#  define _PKCS12_SAFEBAG_get0_p8inf OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_get0_p8inf)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_get0_pkcs8
#  define PKCS12_SAFEBAG_get0_pkcs8 OPENSSL_MANGLER(PKCS12_SAFEBAG_get0_pkcs8)
# endif
#else
# ifndef _PKCS12_SAFEBAG_get0_pkcs8
#  define _PKCS12_SAFEBAG_get0_pkcs8 OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_get0_pkcs8)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_get0_safes
#  define PKCS12_SAFEBAG_get0_safes OPENSSL_MANGLER(PKCS12_SAFEBAG_get0_safes)
# endif
#else
# ifndef _PKCS12_SAFEBAG_get0_safes
#  define _PKCS12_SAFEBAG_get0_safes OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_get0_safes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_get0_type
#  define PKCS12_SAFEBAG_get0_type OPENSSL_MANGLER(PKCS12_SAFEBAG_get0_type)
# endif
#else
# ifndef _PKCS12_SAFEBAG_get0_type
#  define _PKCS12_SAFEBAG_get0_type OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_get0_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_get1_cert
#  define PKCS12_SAFEBAG_get1_cert OPENSSL_MANGLER(PKCS12_SAFEBAG_get1_cert)
# endif
#else
# ifndef _PKCS12_SAFEBAG_get1_cert
#  define _PKCS12_SAFEBAG_get1_cert OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_get1_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_get1_crl
#  define PKCS12_SAFEBAG_get1_crl OPENSSL_MANGLER(PKCS12_SAFEBAG_get1_crl)
# endif
#else
# ifndef _PKCS12_SAFEBAG_get1_crl
#  define _PKCS12_SAFEBAG_get1_crl OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_get1_crl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_get_bag_nid
#  define PKCS12_SAFEBAG_get_bag_nid OPENSSL_MANGLER(PKCS12_SAFEBAG_get_bag_nid)
# endif
#else
# ifndef _PKCS12_SAFEBAG_get_bag_nid
#  define _PKCS12_SAFEBAG_get_bag_nid OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_get_bag_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_get_nid
#  define PKCS12_SAFEBAG_get_nid OPENSSL_MANGLER(PKCS12_SAFEBAG_get_nid)
# endif
#else
# ifndef _PKCS12_SAFEBAG_get_nid
#  define _PKCS12_SAFEBAG_get_nid OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_get_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_it
#  define PKCS12_SAFEBAG_it OPENSSL_MANGLER(PKCS12_SAFEBAG_it)
# endif
#else
# ifndef _PKCS12_SAFEBAG_it
#  define _PKCS12_SAFEBAG_it OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAG_new
#  define PKCS12_SAFEBAG_new OPENSSL_MANGLER(PKCS12_SAFEBAG_new)
# endif
#else
# ifndef _PKCS12_SAFEBAG_new
#  define _PKCS12_SAFEBAG_new OPENSSL_MANGLER_ASM(PKCS12_SAFEBAG_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_SAFEBAGS_it
#  define PKCS12_SAFEBAGS_it OPENSSL_MANGLER(PKCS12_SAFEBAGS_it)
# endif
#else
# ifndef _PKCS12_SAFEBAGS_it
#  define _PKCS12_SAFEBAGS_it OPENSSL_MANGLER_ASM(PKCS12_SAFEBAGS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_set_mac
#  define PKCS12_set_mac OPENSSL_MANGLER(PKCS12_set_mac)
# endif
#else
# ifndef _PKCS12_set_mac
#  define _PKCS12_set_mac OPENSSL_MANGLER_ASM(PKCS12_set_mac)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_setup_mac
#  define PKCS12_setup_mac OPENSSL_MANGLER(PKCS12_setup_mac)
# endif
#else
# ifndef _PKCS12_setup_mac
#  define _PKCS12_setup_mac OPENSSL_MANGLER_ASM(PKCS12_setup_mac)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_unpack_authsafes
#  define PKCS12_unpack_authsafes OPENSSL_MANGLER(PKCS12_unpack_authsafes)
# endif
#else
# ifndef _PKCS12_unpack_authsafes
#  define _PKCS12_unpack_authsafes OPENSSL_MANGLER_ASM(PKCS12_unpack_authsafes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_unpack_p7data
#  define PKCS12_unpack_p7data OPENSSL_MANGLER(PKCS12_unpack_p7data)
# endif
#else
# ifndef _PKCS12_unpack_p7data
#  define _PKCS12_unpack_p7data OPENSSL_MANGLER_ASM(PKCS12_unpack_p7data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_unpack_p7encdata
#  define PKCS12_unpack_p7encdata OPENSSL_MANGLER(PKCS12_unpack_p7encdata)
# endif
#else
# ifndef _PKCS12_unpack_p7encdata
#  define _PKCS12_unpack_p7encdata OPENSSL_MANGLER_ASM(PKCS12_unpack_p7encdata)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS12_verify_mac
#  define PKCS12_verify_mac OPENSSL_MANGLER(PKCS12_verify_mac)
# endif
#else
# ifndef _PKCS12_verify_mac
#  define _PKCS12_verify_mac OPENSSL_MANGLER_ASM(PKCS12_verify_mac)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS1_MGF1
#  define PKCS1_MGF1 OPENSSL_MANGLER(PKCS1_MGF1)
# endif
#else
# ifndef _PKCS1_MGF1
#  define _PKCS1_MGF1 OPENSSL_MANGLER_ASM(PKCS1_MGF1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_pbe2_set
#  define PKCS5_pbe2_set OPENSSL_MANGLER(PKCS5_pbe2_set)
# endif
#else
# ifndef _PKCS5_pbe2_set
#  define _PKCS5_pbe2_set OPENSSL_MANGLER_ASM(PKCS5_pbe2_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_pbe2_set_iv
#  define PKCS5_pbe2_set_iv OPENSSL_MANGLER(PKCS5_pbe2_set_iv)
# endif
#else
# ifndef _PKCS5_pbe2_set_iv
#  define _PKCS5_pbe2_set_iv OPENSSL_MANGLER_ASM(PKCS5_pbe2_set_iv)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_pbe2_set_scrypt
#  define PKCS5_pbe2_set_scrypt OPENSSL_MANGLER(PKCS5_pbe2_set_scrypt)
# endif
#else
# ifndef _PKCS5_pbe2_set_scrypt
#  define _PKCS5_pbe2_set_scrypt OPENSSL_MANGLER_ASM(PKCS5_pbe2_set_scrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_PBE_add
#  define PKCS5_PBE_add OPENSSL_MANGLER(PKCS5_PBE_add)
# endif
#else
# ifndef _PKCS5_PBE_add
#  define _PKCS5_PBE_add OPENSSL_MANGLER_ASM(PKCS5_PBE_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_PBE_keyivgen
#  define PKCS5_PBE_keyivgen OPENSSL_MANGLER(PKCS5_PBE_keyivgen)
# endif
#else
# ifndef _PKCS5_PBE_keyivgen
#  define _PKCS5_PBE_keyivgen OPENSSL_MANGLER_ASM(PKCS5_PBE_keyivgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_pbe_set
#  define PKCS5_pbe_set OPENSSL_MANGLER(PKCS5_pbe_set)
# endif
#else
# ifndef _PKCS5_pbe_set
#  define _PKCS5_pbe_set OPENSSL_MANGLER_ASM(PKCS5_pbe_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_pbe_set0_algor
#  define PKCS5_pbe_set0_algor OPENSSL_MANGLER(PKCS5_pbe_set0_algor)
# endif
#else
# ifndef _PKCS5_pbe_set0_algor
#  define _PKCS5_pbe_set0_algor OPENSSL_MANGLER_ASM(PKCS5_pbe_set0_algor)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_PBKDF2_HMAC
#  define PKCS5_PBKDF2_HMAC OPENSSL_MANGLER(PKCS5_PBKDF2_HMAC)
# endif
#else
# ifndef _PKCS5_PBKDF2_HMAC
#  define _PKCS5_PBKDF2_HMAC OPENSSL_MANGLER_ASM(PKCS5_PBKDF2_HMAC)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_PBKDF2_HMAC_SHA1
#  define PKCS5_PBKDF2_HMAC_SHA1 OPENSSL_MANGLER(PKCS5_PBKDF2_HMAC_SHA1)
# endif
#else
# ifndef _PKCS5_PBKDF2_HMAC_SHA1
#  define _PKCS5_PBKDF2_HMAC_SHA1 OPENSSL_MANGLER_ASM(PKCS5_PBKDF2_HMAC_SHA1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_pbkdf2_set
#  define PKCS5_pbkdf2_set OPENSSL_MANGLER(PKCS5_pbkdf2_set)
# endif
#else
# ifndef _PKCS5_pbkdf2_set
#  define _PKCS5_pbkdf2_set OPENSSL_MANGLER_ASM(PKCS5_pbkdf2_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_v2_PBE_keyivgen
#  define PKCS5_v2_PBE_keyivgen OPENSSL_MANGLER(PKCS5_v2_PBE_keyivgen)
# endif
#else
# ifndef _PKCS5_v2_PBE_keyivgen
#  define _PKCS5_v2_PBE_keyivgen OPENSSL_MANGLER_ASM(PKCS5_v2_PBE_keyivgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_v2_PBKDF2_keyivgen
#  define PKCS5_v2_PBKDF2_keyivgen OPENSSL_MANGLER(PKCS5_v2_PBKDF2_keyivgen)
# endif
#else
# ifndef _PKCS5_v2_PBKDF2_keyivgen
#  define _PKCS5_v2_PBKDF2_keyivgen OPENSSL_MANGLER_ASM(PKCS5_v2_PBKDF2_keyivgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS5_v2_scrypt_keyivgen
#  define PKCS5_v2_scrypt_keyivgen OPENSSL_MANGLER(PKCS5_v2_scrypt_keyivgen)
# endif
#else
# ifndef _PKCS5_v2_scrypt_keyivgen
#  define _PKCS5_v2_scrypt_keyivgen OPENSSL_MANGLER_ASM(PKCS5_v2_scrypt_keyivgen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add0_attrib_signing_time
#  define PKCS7_add0_attrib_signing_time OPENSSL_MANGLER(PKCS7_add0_attrib_signing_time)
# endif
#else
# ifndef _PKCS7_add0_attrib_signing_time
#  define _PKCS7_add0_attrib_signing_time OPENSSL_MANGLER_ASM(PKCS7_add0_attrib_signing_time)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add1_attrib_digest
#  define PKCS7_add1_attrib_digest OPENSSL_MANGLER(PKCS7_add1_attrib_digest)
# endif
#else
# ifndef _PKCS7_add1_attrib_digest
#  define _PKCS7_add1_attrib_digest OPENSSL_MANGLER_ASM(PKCS7_add1_attrib_digest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add_attrib_content_type
#  define PKCS7_add_attrib_content_type OPENSSL_MANGLER(PKCS7_add_attrib_content_type)
# endif
#else
# ifndef _PKCS7_add_attrib_content_type
#  define _PKCS7_add_attrib_content_type OPENSSL_MANGLER_ASM(PKCS7_add_attrib_content_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add_attrib_smimecap
#  define PKCS7_add_attrib_smimecap OPENSSL_MANGLER(PKCS7_add_attrib_smimecap)
# endif
#else
# ifndef _PKCS7_add_attrib_smimecap
#  define _PKCS7_add_attrib_smimecap OPENSSL_MANGLER_ASM(PKCS7_add_attrib_smimecap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add_attribute
#  define PKCS7_add_attribute OPENSSL_MANGLER(PKCS7_add_attribute)
# endif
#else
# ifndef _PKCS7_add_attribute
#  define _PKCS7_add_attribute OPENSSL_MANGLER_ASM(PKCS7_add_attribute)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add_certificate
#  define PKCS7_add_certificate OPENSSL_MANGLER(PKCS7_add_certificate)
# endif
#else
# ifndef _PKCS7_add_certificate
#  define _PKCS7_add_certificate OPENSSL_MANGLER_ASM(PKCS7_add_certificate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add_crl
#  define PKCS7_add_crl OPENSSL_MANGLER(PKCS7_add_crl)
# endif
#else
# ifndef _PKCS7_add_crl
#  define _PKCS7_add_crl OPENSSL_MANGLER_ASM(PKCS7_add_crl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add_recipient
#  define PKCS7_add_recipient OPENSSL_MANGLER(PKCS7_add_recipient)
# endif
#else
# ifndef _PKCS7_add_recipient
#  define _PKCS7_add_recipient OPENSSL_MANGLER_ASM(PKCS7_add_recipient)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add_recipient_info
#  define PKCS7_add_recipient_info OPENSSL_MANGLER(PKCS7_add_recipient_info)
# endif
#else
# ifndef _PKCS7_add_recipient_info
#  define _PKCS7_add_recipient_info OPENSSL_MANGLER_ASM(PKCS7_add_recipient_info)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add_signature
#  define PKCS7_add_signature OPENSSL_MANGLER(PKCS7_add_signature)
# endif
#else
# ifndef _PKCS7_add_signature
#  define _PKCS7_add_signature OPENSSL_MANGLER_ASM(PKCS7_add_signature)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add_signed_attribute
#  define PKCS7_add_signed_attribute OPENSSL_MANGLER(PKCS7_add_signed_attribute)
# endif
#else
# ifndef _PKCS7_add_signed_attribute
#  define _PKCS7_add_signed_attribute OPENSSL_MANGLER_ASM(PKCS7_add_signed_attribute)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_add_signer
#  define PKCS7_add_signer OPENSSL_MANGLER(PKCS7_add_signer)
# endif
#else
# ifndef _PKCS7_add_signer
#  define _PKCS7_add_signer OPENSSL_MANGLER_ASM(PKCS7_add_signer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ATTR_SIGN_it
#  define PKCS7_ATTR_SIGN_it OPENSSL_MANGLER(PKCS7_ATTR_SIGN_it)
# endif
#else
# ifndef _PKCS7_ATTR_SIGN_it
#  define _PKCS7_ATTR_SIGN_it OPENSSL_MANGLER_ASM(PKCS7_ATTR_SIGN_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ATTR_VERIFY_it
#  define PKCS7_ATTR_VERIFY_it OPENSSL_MANGLER(PKCS7_ATTR_VERIFY_it)
# endif
#else
# ifndef _PKCS7_ATTR_VERIFY_it
#  define _PKCS7_ATTR_VERIFY_it OPENSSL_MANGLER_ASM(PKCS7_ATTR_VERIFY_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_cert_from_signer_info
#  define PKCS7_cert_from_signer_info OPENSSL_MANGLER(PKCS7_cert_from_signer_info)
# endif
#else
# ifndef _PKCS7_cert_from_signer_info
#  define _PKCS7_cert_from_signer_info OPENSSL_MANGLER_ASM(PKCS7_cert_from_signer_info)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_content_new
#  define PKCS7_content_new OPENSSL_MANGLER(PKCS7_content_new)
# endif
#else
# ifndef _PKCS7_content_new
#  define _PKCS7_content_new OPENSSL_MANGLER_ASM(PKCS7_content_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ctrl
#  define PKCS7_ctrl OPENSSL_MANGLER(PKCS7_ctrl)
# endif
#else
# ifndef _PKCS7_ctrl
#  define _PKCS7_ctrl OPENSSL_MANGLER_ASM(PKCS7_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_dataDecode
#  define PKCS7_dataDecode OPENSSL_MANGLER(PKCS7_dataDecode)
# endif
#else
# ifndef _PKCS7_dataDecode
#  define _PKCS7_dataDecode OPENSSL_MANGLER_ASM(PKCS7_dataDecode)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_dataFinal
#  define PKCS7_dataFinal OPENSSL_MANGLER(PKCS7_dataFinal)
# endif
#else
# ifndef _PKCS7_dataFinal
#  define _PKCS7_dataFinal OPENSSL_MANGLER_ASM(PKCS7_dataFinal)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_dataInit
#  define PKCS7_dataInit OPENSSL_MANGLER(PKCS7_dataInit)
# endif
#else
# ifndef _PKCS7_dataInit
#  define _PKCS7_dataInit OPENSSL_MANGLER_ASM(PKCS7_dataInit)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_dataVerify
#  define PKCS7_dataVerify OPENSSL_MANGLER(PKCS7_dataVerify)
# endif
#else
# ifndef _PKCS7_dataVerify
#  define _PKCS7_dataVerify OPENSSL_MANGLER_ASM(PKCS7_dataVerify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_decrypt
#  define PKCS7_decrypt OPENSSL_MANGLER(PKCS7_decrypt)
# endif
#else
# ifndef _PKCS7_decrypt
#  define _PKCS7_decrypt OPENSSL_MANGLER_ASM(PKCS7_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_DIGEST_free
#  define PKCS7_DIGEST_free OPENSSL_MANGLER(PKCS7_DIGEST_free)
# endif
#else
# ifndef _PKCS7_DIGEST_free
#  define _PKCS7_DIGEST_free OPENSSL_MANGLER_ASM(PKCS7_DIGEST_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_digest_from_attributes
#  define PKCS7_digest_from_attributes OPENSSL_MANGLER(PKCS7_digest_from_attributes)
# endif
#else
# ifndef _PKCS7_digest_from_attributes
#  define _PKCS7_digest_from_attributes OPENSSL_MANGLER_ASM(PKCS7_digest_from_attributes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_DIGEST_it
#  define PKCS7_DIGEST_it OPENSSL_MANGLER(PKCS7_DIGEST_it)
# endif
#else
# ifndef _PKCS7_DIGEST_it
#  define _PKCS7_DIGEST_it OPENSSL_MANGLER_ASM(PKCS7_DIGEST_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_DIGEST_new
#  define PKCS7_DIGEST_new OPENSSL_MANGLER(PKCS7_DIGEST_new)
# endif
#else
# ifndef _PKCS7_DIGEST_new
#  define _PKCS7_DIGEST_new OPENSSL_MANGLER_ASM(PKCS7_DIGEST_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_dup
#  define PKCS7_dup OPENSSL_MANGLER(PKCS7_dup)
# endif
#else
# ifndef _PKCS7_dup
#  define _PKCS7_dup OPENSSL_MANGLER_ASM(PKCS7_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ENC_CONTENT_free
#  define PKCS7_ENC_CONTENT_free OPENSSL_MANGLER(PKCS7_ENC_CONTENT_free)
# endif
#else
# ifndef _PKCS7_ENC_CONTENT_free
#  define _PKCS7_ENC_CONTENT_free OPENSSL_MANGLER_ASM(PKCS7_ENC_CONTENT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ENC_CONTENT_it
#  define PKCS7_ENC_CONTENT_it OPENSSL_MANGLER(PKCS7_ENC_CONTENT_it)
# endif
#else
# ifndef _PKCS7_ENC_CONTENT_it
#  define _PKCS7_ENC_CONTENT_it OPENSSL_MANGLER_ASM(PKCS7_ENC_CONTENT_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ENC_CONTENT_new
#  define PKCS7_ENC_CONTENT_new OPENSSL_MANGLER(PKCS7_ENC_CONTENT_new)
# endif
#else
# ifndef _PKCS7_ENC_CONTENT_new
#  define _PKCS7_ENC_CONTENT_new OPENSSL_MANGLER_ASM(PKCS7_ENC_CONTENT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_encrypt
#  define PKCS7_encrypt OPENSSL_MANGLER(PKCS7_encrypt)
# endif
#else
# ifndef _PKCS7_encrypt
#  define _PKCS7_encrypt OPENSSL_MANGLER_ASM(PKCS7_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ENCRYPT_free
#  define PKCS7_ENCRYPT_free OPENSSL_MANGLER(PKCS7_ENCRYPT_free)
# endif
#else
# ifndef _PKCS7_ENCRYPT_free
#  define _PKCS7_ENCRYPT_free OPENSSL_MANGLER_ASM(PKCS7_ENCRYPT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ENCRYPT_it
#  define PKCS7_ENCRYPT_it OPENSSL_MANGLER(PKCS7_ENCRYPT_it)
# endif
#else
# ifndef _PKCS7_ENCRYPT_it
#  define _PKCS7_ENCRYPT_it OPENSSL_MANGLER_ASM(PKCS7_ENCRYPT_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ENCRYPT_new
#  define PKCS7_ENCRYPT_new OPENSSL_MANGLER(PKCS7_ENCRYPT_new)
# endif
#else
# ifndef _PKCS7_ENCRYPT_new
#  define _PKCS7_ENCRYPT_new OPENSSL_MANGLER_ASM(PKCS7_ENCRYPT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ENVELOPE_free
#  define PKCS7_ENVELOPE_free OPENSSL_MANGLER(PKCS7_ENVELOPE_free)
# endif
#else
# ifndef _PKCS7_ENVELOPE_free
#  define _PKCS7_ENVELOPE_free OPENSSL_MANGLER_ASM(PKCS7_ENVELOPE_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ENVELOPE_it
#  define PKCS7_ENVELOPE_it OPENSSL_MANGLER(PKCS7_ENVELOPE_it)
# endif
#else
# ifndef _PKCS7_ENVELOPE_it
#  define _PKCS7_ENVELOPE_it OPENSSL_MANGLER_ASM(PKCS7_ENVELOPE_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ENVELOPE_new
#  define PKCS7_ENVELOPE_new OPENSSL_MANGLER(PKCS7_ENVELOPE_new)
# endif
#else
# ifndef _PKCS7_ENVELOPE_new
#  define _PKCS7_ENVELOPE_new OPENSSL_MANGLER_ASM(PKCS7_ENVELOPE_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_final
#  define PKCS7_final OPENSSL_MANGLER(PKCS7_final)
# endif
#else
# ifndef _PKCS7_final
#  define _PKCS7_final OPENSSL_MANGLER_ASM(PKCS7_final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_free
#  define PKCS7_free OPENSSL_MANGLER(PKCS7_free)
# endif
#else
# ifndef _PKCS7_free
#  define _PKCS7_free OPENSSL_MANGLER_ASM(PKCS7_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_get0_signers
#  define PKCS7_get0_signers OPENSSL_MANGLER(PKCS7_get0_signers)
# endif
#else
# ifndef _PKCS7_get0_signers
#  define _PKCS7_get0_signers OPENSSL_MANGLER_ASM(PKCS7_get0_signers)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_get_attribute
#  define PKCS7_get_attribute OPENSSL_MANGLER(PKCS7_get_attribute)
# endif
#else
# ifndef _PKCS7_get_attribute
#  define _PKCS7_get_attribute OPENSSL_MANGLER_ASM(PKCS7_get_attribute)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_get_issuer_and_serial
#  define PKCS7_get_issuer_and_serial OPENSSL_MANGLER(PKCS7_get_issuer_and_serial)
# endif
#else
# ifndef _PKCS7_get_issuer_and_serial
#  define _PKCS7_get_issuer_and_serial OPENSSL_MANGLER_ASM(PKCS7_get_issuer_and_serial)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_get_signed_attribute
#  define PKCS7_get_signed_attribute OPENSSL_MANGLER(PKCS7_get_signed_attribute)
# endif
#else
# ifndef _PKCS7_get_signed_attribute
#  define _PKCS7_get_signed_attribute OPENSSL_MANGLER_ASM(PKCS7_get_signed_attribute)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_get_signer_info
#  define PKCS7_get_signer_info OPENSSL_MANGLER(PKCS7_get_signer_info)
# endif
#else
# ifndef _PKCS7_get_signer_info
#  define _PKCS7_get_signer_info OPENSSL_MANGLER_ASM(PKCS7_get_signer_info)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_get_smimecap
#  define PKCS7_get_smimecap OPENSSL_MANGLER(PKCS7_get_smimecap)
# endif
#else
# ifndef _PKCS7_get_smimecap
#  define _PKCS7_get_smimecap OPENSSL_MANGLER_ASM(PKCS7_get_smimecap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ISSUER_AND_SERIAL_digest
#  define PKCS7_ISSUER_AND_SERIAL_digest OPENSSL_MANGLER(PKCS7_ISSUER_AND_SERIAL_digest)
# endif
#else
# ifndef _PKCS7_ISSUER_AND_SERIAL_digest
#  define _PKCS7_ISSUER_AND_SERIAL_digest OPENSSL_MANGLER_ASM(PKCS7_ISSUER_AND_SERIAL_digest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ISSUER_AND_SERIAL_free
#  define PKCS7_ISSUER_AND_SERIAL_free OPENSSL_MANGLER(PKCS7_ISSUER_AND_SERIAL_free)
# endif
#else
# ifndef _PKCS7_ISSUER_AND_SERIAL_free
#  define _PKCS7_ISSUER_AND_SERIAL_free OPENSSL_MANGLER_ASM(PKCS7_ISSUER_AND_SERIAL_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ISSUER_AND_SERIAL_it
#  define PKCS7_ISSUER_AND_SERIAL_it OPENSSL_MANGLER(PKCS7_ISSUER_AND_SERIAL_it)
# endif
#else
# ifndef _PKCS7_ISSUER_AND_SERIAL_it
#  define _PKCS7_ISSUER_AND_SERIAL_it OPENSSL_MANGLER_ASM(PKCS7_ISSUER_AND_SERIAL_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_ISSUER_AND_SERIAL_new
#  define PKCS7_ISSUER_AND_SERIAL_new OPENSSL_MANGLER(PKCS7_ISSUER_AND_SERIAL_new)
# endif
#else
# ifndef _PKCS7_ISSUER_AND_SERIAL_new
#  define _PKCS7_ISSUER_AND_SERIAL_new OPENSSL_MANGLER_ASM(PKCS7_ISSUER_AND_SERIAL_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_it
#  define PKCS7_it OPENSSL_MANGLER(PKCS7_it)
# endif
#else
# ifndef _PKCS7_it
#  define _PKCS7_it OPENSSL_MANGLER_ASM(PKCS7_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_new
#  define PKCS7_new OPENSSL_MANGLER(PKCS7_new)
# endif
#else
# ifndef _PKCS7_new
#  define _PKCS7_new OPENSSL_MANGLER_ASM(PKCS7_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_print_ctx
#  define PKCS7_print_ctx OPENSSL_MANGLER(PKCS7_print_ctx)
# endif
#else
# ifndef _PKCS7_print_ctx
#  define _PKCS7_print_ctx OPENSSL_MANGLER_ASM(PKCS7_print_ctx)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_RECIP_INFO_free
#  define PKCS7_RECIP_INFO_free OPENSSL_MANGLER(PKCS7_RECIP_INFO_free)
# endif
#else
# ifndef _PKCS7_RECIP_INFO_free
#  define _PKCS7_RECIP_INFO_free OPENSSL_MANGLER_ASM(PKCS7_RECIP_INFO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_RECIP_INFO_get0_alg
#  define PKCS7_RECIP_INFO_get0_alg OPENSSL_MANGLER(PKCS7_RECIP_INFO_get0_alg)
# endif
#else
# ifndef _PKCS7_RECIP_INFO_get0_alg
#  define _PKCS7_RECIP_INFO_get0_alg OPENSSL_MANGLER_ASM(PKCS7_RECIP_INFO_get0_alg)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_RECIP_INFO_it
#  define PKCS7_RECIP_INFO_it OPENSSL_MANGLER(PKCS7_RECIP_INFO_it)
# endif
#else
# ifndef _PKCS7_RECIP_INFO_it
#  define _PKCS7_RECIP_INFO_it OPENSSL_MANGLER_ASM(PKCS7_RECIP_INFO_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_RECIP_INFO_new
#  define PKCS7_RECIP_INFO_new OPENSSL_MANGLER(PKCS7_RECIP_INFO_new)
# endif
#else
# ifndef _PKCS7_RECIP_INFO_new
#  define _PKCS7_RECIP_INFO_new OPENSSL_MANGLER_ASM(PKCS7_RECIP_INFO_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_RECIP_INFO_set
#  define PKCS7_RECIP_INFO_set OPENSSL_MANGLER(PKCS7_RECIP_INFO_set)
# endif
#else
# ifndef _PKCS7_RECIP_INFO_set
#  define _PKCS7_RECIP_INFO_set OPENSSL_MANGLER_ASM(PKCS7_RECIP_INFO_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_set0_type_other
#  define PKCS7_set0_type_other OPENSSL_MANGLER(PKCS7_set0_type_other)
# endif
#else
# ifndef _PKCS7_set0_type_other
#  define _PKCS7_set0_type_other OPENSSL_MANGLER_ASM(PKCS7_set0_type_other)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_set_attributes
#  define PKCS7_set_attributes OPENSSL_MANGLER(PKCS7_set_attributes)
# endif
#else
# ifndef _PKCS7_set_attributes
#  define _PKCS7_set_attributes OPENSSL_MANGLER_ASM(PKCS7_set_attributes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_set_cipher
#  define PKCS7_set_cipher OPENSSL_MANGLER(PKCS7_set_cipher)
# endif
#else
# ifndef _PKCS7_set_cipher
#  define _PKCS7_set_cipher OPENSSL_MANGLER_ASM(PKCS7_set_cipher)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_set_content
#  define PKCS7_set_content OPENSSL_MANGLER(PKCS7_set_content)
# endif
#else
# ifndef _PKCS7_set_content
#  define _PKCS7_set_content OPENSSL_MANGLER_ASM(PKCS7_set_content)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_set_digest
#  define PKCS7_set_digest OPENSSL_MANGLER(PKCS7_set_digest)
# endif
#else
# ifndef _PKCS7_set_digest
#  define _PKCS7_set_digest OPENSSL_MANGLER_ASM(PKCS7_set_digest)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_set_signed_attributes
#  define PKCS7_set_signed_attributes OPENSSL_MANGLER(PKCS7_set_signed_attributes)
# endif
#else
# ifndef _PKCS7_set_signed_attributes
#  define _PKCS7_set_signed_attributes OPENSSL_MANGLER_ASM(PKCS7_set_signed_attributes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_set_type
#  define PKCS7_set_type OPENSSL_MANGLER(PKCS7_set_type)
# endif
#else
# ifndef _PKCS7_set_type
#  define _PKCS7_set_type OPENSSL_MANGLER_ASM(PKCS7_set_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_sign
#  define PKCS7_sign OPENSSL_MANGLER(PKCS7_sign)
# endif
#else
# ifndef _PKCS7_sign
#  define _PKCS7_sign OPENSSL_MANGLER_ASM(PKCS7_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_sign_add_signer
#  define PKCS7_sign_add_signer OPENSSL_MANGLER(PKCS7_sign_add_signer)
# endif
#else
# ifndef _PKCS7_sign_add_signer
#  define _PKCS7_sign_add_signer OPENSSL_MANGLER_ASM(PKCS7_sign_add_signer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_signatureVerify
#  define PKCS7_signatureVerify OPENSSL_MANGLER(PKCS7_signatureVerify)
# endif
#else
# ifndef _PKCS7_signatureVerify
#  define _PKCS7_signatureVerify OPENSSL_MANGLER_ASM(PKCS7_signatureVerify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGNED_free
#  define PKCS7_SIGNED_free OPENSSL_MANGLER(PKCS7_SIGNED_free)
# endif
#else
# ifndef _PKCS7_SIGNED_free
#  define _PKCS7_SIGNED_free OPENSSL_MANGLER_ASM(PKCS7_SIGNED_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGNED_it
#  define PKCS7_SIGNED_it OPENSSL_MANGLER(PKCS7_SIGNED_it)
# endif
#else
# ifndef _PKCS7_SIGNED_it
#  define _PKCS7_SIGNED_it OPENSSL_MANGLER_ASM(PKCS7_SIGNED_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGNED_new
#  define PKCS7_SIGNED_new OPENSSL_MANGLER(PKCS7_SIGNED_new)
# endif
#else
# ifndef _PKCS7_SIGNED_new
#  define _PKCS7_SIGNED_new OPENSSL_MANGLER_ASM(PKCS7_SIGNED_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGN_ENVELOPE_free
#  define PKCS7_SIGN_ENVELOPE_free OPENSSL_MANGLER(PKCS7_SIGN_ENVELOPE_free)
# endif
#else
# ifndef _PKCS7_SIGN_ENVELOPE_free
#  define _PKCS7_SIGN_ENVELOPE_free OPENSSL_MANGLER_ASM(PKCS7_SIGN_ENVELOPE_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGN_ENVELOPE_it
#  define PKCS7_SIGN_ENVELOPE_it OPENSSL_MANGLER(PKCS7_SIGN_ENVELOPE_it)
# endif
#else
# ifndef _PKCS7_SIGN_ENVELOPE_it
#  define _PKCS7_SIGN_ENVELOPE_it OPENSSL_MANGLER_ASM(PKCS7_SIGN_ENVELOPE_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGN_ENVELOPE_new
#  define PKCS7_SIGN_ENVELOPE_new OPENSSL_MANGLER(PKCS7_SIGN_ENVELOPE_new)
# endif
#else
# ifndef _PKCS7_SIGN_ENVELOPE_new
#  define _PKCS7_SIGN_ENVELOPE_new OPENSSL_MANGLER_ASM(PKCS7_SIGN_ENVELOPE_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGNER_INFO_free
#  define PKCS7_SIGNER_INFO_free OPENSSL_MANGLER(PKCS7_SIGNER_INFO_free)
# endif
#else
# ifndef _PKCS7_SIGNER_INFO_free
#  define _PKCS7_SIGNER_INFO_free OPENSSL_MANGLER_ASM(PKCS7_SIGNER_INFO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGNER_INFO_get0_algs
#  define PKCS7_SIGNER_INFO_get0_algs OPENSSL_MANGLER(PKCS7_SIGNER_INFO_get0_algs)
# endif
#else
# ifndef _PKCS7_SIGNER_INFO_get0_algs
#  define _PKCS7_SIGNER_INFO_get0_algs OPENSSL_MANGLER_ASM(PKCS7_SIGNER_INFO_get0_algs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGNER_INFO_it
#  define PKCS7_SIGNER_INFO_it OPENSSL_MANGLER(PKCS7_SIGNER_INFO_it)
# endif
#else
# ifndef _PKCS7_SIGNER_INFO_it
#  define _PKCS7_SIGNER_INFO_it OPENSSL_MANGLER_ASM(PKCS7_SIGNER_INFO_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGNER_INFO_new
#  define PKCS7_SIGNER_INFO_new OPENSSL_MANGLER(PKCS7_SIGNER_INFO_new)
# endif
#else
# ifndef _PKCS7_SIGNER_INFO_new
#  define _PKCS7_SIGNER_INFO_new OPENSSL_MANGLER_ASM(PKCS7_SIGNER_INFO_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGNER_INFO_set
#  define PKCS7_SIGNER_INFO_set OPENSSL_MANGLER(PKCS7_SIGNER_INFO_set)
# endif
#else
# ifndef _PKCS7_SIGNER_INFO_set
#  define _PKCS7_SIGNER_INFO_set OPENSSL_MANGLER_ASM(PKCS7_SIGNER_INFO_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_SIGNER_INFO_sign
#  define PKCS7_SIGNER_INFO_sign OPENSSL_MANGLER(PKCS7_SIGNER_INFO_sign)
# endif
#else
# ifndef _PKCS7_SIGNER_INFO_sign
#  define _PKCS7_SIGNER_INFO_sign OPENSSL_MANGLER_ASM(PKCS7_SIGNER_INFO_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_simple_smimecap
#  define PKCS7_simple_smimecap OPENSSL_MANGLER(PKCS7_simple_smimecap)
# endif
#else
# ifndef _PKCS7_simple_smimecap
#  define _PKCS7_simple_smimecap OPENSSL_MANGLER_ASM(PKCS7_simple_smimecap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_stream
#  define PKCS7_stream OPENSSL_MANGLER(PKCS7_stream)
# endif
#else
# ifndef _PKCS7_stream
#  define _PKCS7_stream OPENSSL_MANGLER_ASM(PKCS7_stream)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_to_TS_TST_INFO
#  define PKCS7_to_TS_TST_INFO OPENSSL_MANGLER(PKCS7_to_TS_TST_INFO)
# endif
#else
# ifndef _PKCS7_to_TS_TST_INFO
#  define _PKCS7_to_TS_TST_INFO OPENSSL_MANGLER_ASM(PKCS7_to_TS_TST_INFO)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS7_verify
#  define PKCS7_verify OPENSSL_MANGLER(PKCS7_verify)
# endif
#else
# ifndef _PKCS7_verify
#  define _PKCS7_verify OPENSSL_MANGLER_ASM(PKCS7_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_add_keyusage
#  define PKCS8_add_keyusage OPENSSL_MANGLER(PKCS8_add_keyusage)
# endif
#else
# ifndef _PKCS8_add_keyusage
#  define _PKCS8_add_keyusage OPENSSL_MANGLER_ASM(PKCS8_add_keyusage)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_decrypt
#  define PKCS8_decrypt OPENSSL_MANGLER(PKCS8_decrypt)
# endif
#else
# ifndef _PKCS8_decrypt
#  define _PKCS8_decrypt OPENSSL_MANGLER_ASM(PKCS8_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_encrypt
#  define PKCS8_encrypt OPENSSL_MANGLER(PKCS8_encrypt)
# endif
#else
# ifndef _PKCS8_encrypt
#  define _PKCS8_encrypt OPENSSL_MANGLER_ASM(PKCS8_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_get_attr
#  define PKCS8_get_attr OPENSSL_MANGLER(PKCS8_get_attr)
# endif
#else
# ifndef _PKCS8_get_attr
#  define _PKCS8_get_attr OPENSSL_MANGLER_ASM(PKCS8_get_attr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_pkey_add1_attr_by_NID
#  define PKCS8_pkey_add1_attr_by_NID OPENSSL_MANGLER(PKCS8_pkey_add1_attr_by_NID)
# endif
#else
# ifndef _PKCS8_pkey_add1_attr_by_NID
#  define _PKCS8_pkey_add1_attr_by_NID OPENSSL_MANGLER_ASM(PKCS8_pkey_add1_attr_by_NID)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_pkey_get0
#  define PKCS8_pkey_get0 OPENSSL_MANGLER(PKCS8_pkey_get0)
# endif
#else
# ifndef _PKCS8_pkey_get0
#  define _PKCS8_pkey_get0 OPENSSL_MANGLER_ASM(PKCS8_pkey_get0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_pkey_get0_attrs
#  define PKCS8_pkey_get0_attrs OPENSSL_MANGLER(PKCS8_pkey_get0_attrs)
# endif
#else
# ifndef _PKCS8_pkey_get0_attrs
#  define _PKCS8_pkey_get0_attrs OPENSSL_MANGLER_ASM(PKCS8_pkey_get0_attrs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_pkey_set0
#  define PKCS8_pkey_set0 OPENSSL_MANGLER(PKCS8_pkey_set0)
# endif
#else
# ifndef _PKCS8_pkey_set0
#  define _PKCS8_pkey_set0 OPENSSL_MANGLER_ASM(PKCS8_pkey_set0)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_PRIV_KEY_INFO_free
#  define PKCS8_PRIV_KEY_INFO_free OPENSSL_MANGLER(PKCS8_PRIV_KEY_INFO_free)
# endif
#else
# ifndef _PKCS8_PRIV_KEY_INFO_free
#  define _PKCS8_PRIV_KEY_INFO_free OPENSSL_MANGLER_ASM(PKCS8_PRIV_KEY_INFO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_PRIV_KEY_INFO_it
#  define PKCS8_PRIV_KEY_INFO_it OPENSSL_MANGLER(PKCS8_PRIV_KEY_INFO_it)
# endif
#else
# ifndef _PKCS8_PRIV_KEY_INFO_it
#  define _PKCS8_PRIV_KEY_INFO_it OPENSSL_MANGLER_ASM(PKCS8_PRIV_KEY_INFO_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_PRIV_KEY_INFO_new
#  define PKCS8_PRIV_KEY_INFO_new OPENSSL_MANGLER(PKCS8_PRIV_KEY_INFO_new)
# endif
#else
# ifndef _PKCS8_PRIV_KEY_INFO_new
#  define _PKCS8_PRIV_KEY_INFO_new OPENSSL_MANGLER_ASM(PKCS8_PRIV_KEY_INFO_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKCS8_set0_pbe
#  define PKCS8_set0_pbe OPENSSL_MANGLER(PKCS8_set0_pbe)
# endif
#else
# ifndef _PKCS8_set0_pbe
#  define _PKCS8_set0_pbe OPENSSL_MANGLER_ASM(PKCS8_set0_pbe)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKEY_USAGE_PERIOD_free
#  define PKEY_USAGE_PERIOD_free OPENSSL_MANGLER(PKEY_USAGE_PERIOD_free)
# endif
#else
# ifndef _PKEY_USAGE_PERIOD_free
#  define _PKEY_USAGE_PERIOD_free OPENSSL_MANGLER_ASM(PKEY_USAGE_PERIOD_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKEY_USAGE_PERIOD_it
#  define PKEY_USAGE_PERIOD_it OPENSSL_MANGLER(PKEY_USAGE_PERIOD_it)
# endif
#else
# ifndef _PKEY_USAGE_PERIOD_it
#  define _PKEY_USAGE_PERIOD_it OPENSSL_MANGLER_ASM(PKEY_USAGE_PERIOD_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PKEY_USAGE_PERIOD_new
#  define PKEY_USAGE_PERIOD_new OPENSSL_MANGLER(PKEY_USAGE_PERIOD_new)
# endif
#else
# ifndef _PKEY_USAGE_PERIOD_new
#  define _PKEY_USAGE_PERIOD_new OPENSSL_MANGLER_ASM(PKEY_USAGE_PERIOD_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef policy_cache_find_data
#  define policy_cache_find_data OPENSSL_MANGLER(policy_cache_find_data)
# endif
#else
# ifndef _policy_cache_find_data
#  define _policy_cache_find_data OPENSSL_MANGLER_ASM(policy_cache_find_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef policy_cache_free
#  define policy_cache_free OPENSSL_MANGLER(policy_cache_free)
# endif
#else
# ifndef _policy_cache_free
#  define _policy_cache_free OPENSSL_MANGLER_ASM(policy_cache_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef policy_cache_set
#  define policy_cache_set OPENSSL_MANGLER(policy_cache_set)
# endif
#else
# ifndef _policy_cache_set
#  define _policy_cache_set OPENSSL_MANGLER_ASM(policy_cache_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef policy_cache_set_mapping
#  define policy_cache_set_mapping OPENSSL_MANGLER(policy_cache_set_mapping)
# endif
#else
# ifndef _policy_cache_set_mapping
#  define _policy_cache_set_mapping OPENSSL_MANGLER_ASM(policy_cache_set_mapping)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICY_CONSTRAINTS_free
#  define POLICY_CONSTRAINTS_free OPENSSL_MANGLER(POLICY_CONSTRAINTS_free)
# endif
#else
# ifndef _POLICY_CONSTRAINTS_free
#  define _POLICY_CONSTRAINTS_free OPENSSL_MANGLER_ASM(POLICY_CONSTRAINTS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICY_CONSTRAINTS_it
#  define POLICY_CONSTRAINTS_it OPENSSL_MANGLER(POLICY_CONSTRAINTS_it)
# endif
#else
# ifndef _POLICY_CONSTRAINTS_it
#  define _POLICY_CONSTRAINTS_it OPENSSL_MANGLER_ASM(POLICY_CONSTRAINTS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICY_CONSTRAINTS_new
#  define POLICY_CONSTRAINTS_new OPENSSL_MANGLER(POLICY_CONSTRAINTS_new)
# endif
#else
# ifndef _POLICY_CONSTRAINTS_new
#  define _POLICY_CONSTRAINTS_new OPENSSL_MANGLER_ASM(POLICY_CONSTRAINTS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef policy_data_free
#  define policy_data_free OPENSSL_MANGLER(policy_data_free)
# endif
#else
# ifndef _policy_data_free
#  define _policy_data_free OPENSSL_MANGLER_ASM(policy_data_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef policy_data_new
#  define policy_data_new OPENSSL_MANGLER(policy_data_new)
# endif
#else
# ifndef _policy_data_new
#  define _policy_data_new OPENSSL_MANGLER_ASM(policy_data_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICYINFO_free
#  define POLICYINFO_free OPENSSL_MANGLER(POLICYINFO_free)
# endif
#else
# ifndef _POLICYINFO_free
#  define _POLICYINFO_free OPENSSL_MANGLER_ASM(POLICYINFO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICYINFO_it
#  define POLICYINFO_it OPENSSL_MANGLER(POLICYINFO_it)
# endif
#else
# ifndef _POLICYINFO_it
#  define _POLICYINFO_it OPENSSL_MANGLER_ASM(POLICYINFO_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICYINFO_new
#  define POLICYINFO_new OPENSSL_MANGLER(POLICYINFO_new)
# endif
#else
# ifndef _POLICYINFO_new
#  define _POLICYINFO_new OPENSSL_MANGLER_ASM(POLICYINFO_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICY_MAPPING_free
#  define POLICY_MAPPING_free OPENSSL_MANGLER(POLICY_MAPPING_free)
# endif
#else
# ifndef _POLICY_MAPPING_free
#  define _POLICY_MAPPING_free OPENSSL_MANGLER_ASM(POLICY_MAPPING_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICY_MAPPING_it
#  define POLICY_MAPPING_it OPENSSL_MANGLER(POLICY_MAPPING_it)
# endif
#else
# ifndef _POLICY_MAPPING_it
#  define _POLICY_MAPPING_it OPENSSL_MANGLER_ASM(POLICY_MAPPING_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICY_MAPPING_new
#  define POLICY_MAPPING_new OPENSSL_MANGLER(POLICY_MAPPING_new)
# endif
#else
# ifndef _POLICY_MAPPING_new
#  define _POLICY_MAPPING_new OPENSSL_MANGLER_ASM(POLICY_MAPPING_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICY_MAPPINGS_it
#  define POLICY_MAPPINGS_it OPENSSL_MANGLER(POLICY_MAPPINGS_it)
# endif
#else
# ifndef _POLICY_MAPPINGS_it
#  define _POLICY_MAPPINGS_it OPENSSL_MANGLER_ASM(POLICY_MAPPINGS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef policy_node_cmp_new
#  define policy_node_cmp_new OPENSSL_MANGLER(policy_node_cmp_new)
# endif
#else
# ifndef _policy_node_cmp_new
#  define _policy_node_cmp_new OPENSSL_MANGLER_ASM(policy_node_cmp_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef policy_node_free
#  define policy_node_free OPENSSL_MANGLER(policy_node_free)
# endif
#else
# ifndef _policy_node_free
#  define _policy_node_free OPENSSL_MANGLER_ASM(policy_node_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef policy_node_match
#  define policy_node_match OPENSSL_MANGLER(policy_node_match)
# endif
#else
# ifndef _policy_node_match
#  define _policy_node_match OPENSSL_MANGLER_ASM(policy_node_match)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICYQUALINFO_free
#  define POLICYQUALINFO_free OPENSSL_MANGLER(POLICYQUALINFO_free)
# endif
#else
# ifndef _POLICYQUALINFO_free
#  define _POLICYQUALINFO_free OPENSSL_MANGLER_ASM(POLICYQUALINFO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICYQUALINFO_it
#  define POLICYQUALINFO_it OPENSSL_MANGLER(POLICYQUALINFO_it)
# endif
#else
# ifndef _POLICYQUALINFO_it
#  define _POLICYQUALINFO_it OPENSSL_MANGLER_ASM(POLICYQUALINFO_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef POLICYQUALINFO_new
#  define POLICYQUALINFO_new OPENSSL_MANGLER(POLICYQUALINFO_new)
# endif
#else
# ifndef _POLICYQUALINFO_new
#  define _POLICYQUALINFO_new OPENSSL_MANGLER_ASM(POLICYQUALINFO_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pqueue_find
#  define pqueue_find OPENSSL_MANGLER(pqueue_find)
# endif
#else
# ifndef _pqueue_find
#  define _pqueue_find OPENSSL_MANGLER_ASM(pqueue_find)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pqueue_free
#  define pqueue_free OPENSSL_MANGLER(pqueue_free)
# endif
#else
# ifndef _pqueue_free
#  define _pqueue_free OPENSSL_MANGLER_ASM(pqueue_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pqueue_insert
#  define pqueue_insert OPENSSL_MANGLER(pqueue_insert)
# endif
#else
# ifndef _pqueue_insert
#  define _pqueue_insert OPENSSL_MANGLER_ASM(pqueue_insert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pqueue_iterator
#  define pqueue_iterator OPENSSL_MANGLER(pqueue_iterator)
# endif
#else
# ifndef _pqueue_iterator
#  define _pqueue_iterator OPENSSL_MANGLER_ASM(pqueue_iterator)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pqueue_new
#  define pqueue_new OPENSSL_MANGLER(pqueue_new)
# endif
#else
# ifndef _pqueue_new
#  define _pqueue_new OPENSSL_MANGLER_ASM(pqueue_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pqueue_next
#  define pqueue_next OPENSSL_MANGLER(pqueue_next)
# endif
#else
# ifndef _pqueue_next
#  define _pqueue_next OPENSSL_MANGLER_ASM(pqueue_next)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pqueue_peek
#  define pqueue_peek OPENSSL_MANGLER(pqueue_peek)
# endif
#else
# ifndef _pqueue_peek
#  define _pqueue_peek OPENSSL_MANGLER_ASM(pqueue_peek)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pqueue_pop
#  define pqueue_pop OPENSSL_MANGLER(pqueue_pop)
# endif
#else
# ifndef _pqueue_pop
#  define _pqueue_pop OPENSSL_MANGLER_ASM(pqueue_pop)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef pqueue_size
#  define pqueue_size OPENSSL_MANGLER(pqueue_size)
# endif
#else
# ifndef _pqueue_size
#  define _pqueue_size OPENSSL_MANGLER_ASM(pqueue_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_free
#  define PROFESSION_INFO_free OPENSSL_MANGLER(PROFESSION_INFO_free)
# endif
#else
# ifndef _PROFESSION_INFO_free
#  define _PROFESSION_INFO_free OPENSSL_MANGLER_ASM(PROFESSION_INFO_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_get0_addProfessionInfo
#  define PROFESSION_INFO_get0_addProfessionInfo OPENSSL_MANGLER(PROFESSION_INFO_get0_addProfessionInfo)
# endif
#else
# ifndef _PROFESSION_INFO_get0_addProfessionInfo
#  define _PROFESSION_INFO_get0_addProfessionInfo OPENSSL_MANGLER_ASM(PROFESSION_INFO_get0_addProfessionInfo)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_get0_namingAuthority
#  define PROFESSION_INFO_get0_namingAuthority OPENSSL_MANGLER(PROFESSION_INFO_get0_namingAuthority)
# endif
#else
# ifndef _PROFESSION_INFO_get0_namingAuthority
#  define _PROFESSION_INFO_get0_namingAuthority OPENSSL_MANGLER_ASM(PROFESSION_INFO_get0_namingAuthority)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_get0_professionItems
#  define PROFESSION_INFO_get0_professionItems OPENSSL_MANGLER(PROFESSION_INFO_get0_professionItems)
# endif
#else
# ifndef _PROFESSION_INFO_get0_professionItems
#  define _PROFESSION_INFO_get0_professionItems OPENSSL_MANGLER_ASM(PROFESSION_INFO_get0_professionItems)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_get0_professionOIDs
#  define PROFESSION_INFO_get0_professionOIDs OPENSSL_MANGLER(PROFESSION_INFO_get0_professionOIDs)
# endif
#else
# ifndef _PROFESSION_INFO_get0_professionOIDs
#  define _PROFESSION_INFO_get0_professionOIDs OPENSSL_MANGLER_ASM(PROFESSION_INFO_get0_professionOIDs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_get0_registrationNumber
#  define PROFESSION_INFO_get0_registrationNumber OPENSSL_MANGLER(PROFESSION_INFO_get0_registrationNumber)
# endif
#else
# ifndef _PROFESSION_INFO_get0_registrationNumber
#  define _PROFESSION_INFO_get0_registrationNumber OPENSSL_MANGLER_ASM(PROFESSION_INFO_get0_registrationNumber)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_it
#  define PROFESSION_INFO_it OPENSSL_MANGLER(PROFESSION_INFO_it)
# endif
#else
# ifndef _PROFESSION_INFO_it
#  define _PROFESSION_INFO_it OPENSSL_MANGLER_ASM(PROFESSION_INFO_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_new
#  define PROFESSION_INFO_new OPENSSL_MANGLER(PROFESSION_INFO_new)
# endif
#else
# ifndef _PROFESSION_INFO_new
#  define _PROFESSION_INFO_new OPENSSL_MANGLER_ASM(PROFESSION_INFO_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_set0_addProfessionInfo
#  define PROFESSION_INFO_set0_addProfessionInfo OPENSSL_MANGLER(PROFESSION_INFO_set0_addProfessionInfo)
# endif
#else
# ifndef _PROFESSION_INFO_set0_addProfessionInfo
#  define _PROFESSION_INFO_set0_addProfessionInfo OPENSSL_MANGLER_ASM(PROFESSION_INFO_set0_addProfessionInfo)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_set0_namingAuthority
#  define PROFESSION_INFO_set0_namingAuthority OPENSSL_MANGLER(PROFESSION_INFO_set0_namingAuthority)
# endif
#else
# ifndef _PROFESSION_INFO_set0_namingAuthority
#  define _PROFESSION_INFO_set0_namingAuthority OPENSSL_MANGLER_ASM(PROFESSION_INFO_set0_namingAuthority)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_set0_professionItems
#  define PROFESSION_INFO_set0_professionItems OPENSSL_MANGLER(PROFESSION_INFO_set0_professionItems)
# endif
#else
# ifndef _PROFESSION_INFO_set0_professionItems
#  define _PROFESSION_INFO_set0_professionItems OPENSSL_MANGLER_ASM(PROFESSION_INFO_set0_professionItems)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_set0_professionOIDs
#  define PROFESSION_INFO_set0_professionOIDs OPENSSL_MANGLER(PROFESSION_INFO_set0_professionOIDs)
# endif
#else
# ifndef _PROFESSION_INFO_set0_professionOIDs
#  define _PROFESSION_INFO_set0_professionOIDs OPENSSL_MANGLER_ASM(PROFESSION_INFO_set0_professionOIDs)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROFESSION_INFO_set0_registrationNumber
#  define PROFESSION_INFO_set0_registrationNumber OPENSSL_MANGLER(PROFESSION_INFO_set0_registrationNumber)
# endif
#else
# ifndef _PROFESSION_INFO_set0_registrationNumber
#  define _PROFESSION_INFO_set0_registrationNumber OPENSSL_MANGLER_ASM(PROFESSION_INFO_set0_registrationNumber)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROXY_CERT_INFO_EXTENSION_free
#  define PROXY_CERT_INFO_EXTENSION_free OPENSSL_MANGLER(PROXY_CERT_INFO_EXTENSION_free)
# endif
#else
# ifndef _PROXY_CERT_INFO_EXTENSION_free
#  define _PROXY_CERT_INFO_EXTENSION_free OPENSSL_MANGLER_ASM(PROXY_CERT_INFO_EXTENSION_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROXY_CERT_INFO_EXTENSION_it
#  define PROXY_CERT_INFO_EXTENSION_it OPENSSL_MANGLER(PROXY_CERT_INFO_EXTENSION_it)
# endif
#else
# ifndef _PROXY_CERT_INFO_EXTENSION_it
#  define _PROXY_CERT_INFO_EXTENSION_it OPENSSL_MANGLER_ASM(PROXY_CERT_INFO_EXTENSION_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROXY_CERT_INFO_EXTENSION_new
#  define PROXY_CERT_INFO_EXTENSION_new OPENSSL_MANGLER(PROXY_CERT_INFO_EXTENSION_new)
# endif
#else
# ifndef _PROXY_CERT_INFO_EXTENSION_new
#  define _PROXY_CERT_INFO_EXTENSION_new OPENSSL_MANGLER_ASM(PROXY_CERT_INFO_EXTENSION_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROXY_POLICY_free
#  define PROXY_POLICY_free OPENSSL_MANGLER(PROXY_POLICY_free)
# endif
#else
# ifndef _PROXY_POLICY_free
#  define _PROXY_POLICY_free OPENSSL_MANGLER_ASM(PROXY_POLICY_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROXY_POLICY_it
#  define PROXY_POLICY_it OPENSSL_MANGLER(PROXY_POLICY_it)
# endif
#else
# ifndef _PROXY_POLICY_it
#  define _PROXY_POLICY_it OPENSSL_MANGLER_ASM(PROXY_POLICY_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef PROXY_POLICY_new
#  define PROXY_POLICY_new OPENSSL_MANGLER(PROXY_POLICY_new)
# endif
#else
# ifndef _PROXY_POLICY_new
#  define _PROXY_POLICY_new OPENSSL_MANGLER_ASM(PROXY_POLICY_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_add
#  define RAND_add OPENSSL_MANGLER(RAND_add)
# endif
#else
# ifndef _RAND_add
#  define _RAND_add OPENSSL_MANGLER_ASM(RAND_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_bytes
#  define RAND_bytes OPENSSL_MANGLER(RAND_bytes)
# endif
#else
# ifndef _RAND_bytes
#  define _RAND_bytes OPENSSL_MANGLER_ASM(RAND_bytes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_cleanup_int
#  define rand_cleanup_int OPENSSL_MANGLER(rand_cleanup_int)
# endif
#else
# ifndef _rand_cleanup_int
#  define _rand_cleanup_int OPENSSL_MANGLER_ASM(rand_cleanup_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_bytes
#  define RAND_DRBG_bytes OPENSSL_MANGLER(RAND_DRBG_bytes)
# endif
#else
# ifndef _RAND_DRBG_bytes
#  define _RAND_DRBG_bytes OPENSSL_MANGLER_ASM(RAND_DRBG_bytes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_cleanup_additional_data
#  define rand_drbg_cleanup_additional_data OPENSSL_MANGLER(rand_drbg_cleanup_additional_data)
# endif
#else
# ifndef _rand_drbg_cleanup_additional_data
#  define _rand_drbg_cleanup_additional_data OPENSSL_MANGLER_ASM(rand_drbg_cleanup_additional_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_cleanup_entropy
#  define rand_drbg_cleanup_entropy OPENSSL_MANGLER(rand_drbg_cleanup_entropy)
# endif
#else
# ifndef _rand_drbg_cleanup_entropy
#  define _rand_drbg_cleanup_entropy OPENSSL_MANGLER_ASM(rand_drbg_cleanup_entropy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_cleanup_int
#  define rand_drbg_cleanup_int OPENSSL_MANGLER(rand_drbg_cleanup_int)
# endif
#else
# ifndef _rand_drbg_cleanup_int
#  define _rand_drbg_cleanup_int OPENSSL_MANGLER_ASM(rand_drbg_cleanup_int)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_cleanup_nonce
#  define rand_drbg_cleanup_nonce OPENSSL_MANGLER(rand_drbg_cleanup_nonce)
# endif
#else
# ifndef _rand_drbg_cleanup_nonce
#  define _rand_drbg_cleanup_nonce OPENSSL_MANGLER_ASM(rand_drbg_cleanup_nonce)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_enable_locking
#  define rand_drbg_enable_locking OPENSSL_MANGLER(rand_drbg_enable_locking)
# endif
#else
# ifndef _rand_drbg_enable_locking
#  define _rand_drbg_enable_locking OPENSSL_MANGLER_ASM(rand_drbg_enable_locking)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_free
#  define RAND_DRBG_free OPENSSL_MANGLER(RAND_DRBG_free)
# endif
#else
# ifndef _RAND_DRBG_free
#  define _RAND_DRBG_free OPENSSL_MANGLER_ASM(RAND_DRBG_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_generate
#  define RAND_DRBG_generate OPENSSL_MANGLER(RAND_DRBG_generate)
# endif
#else
# ifndef _RAND_DRBG_generate
#  define _RAND_DRBG_generate OPENSSL_MANGLER_ASM(RAND_DRBG_generate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_get0_master
#  define RAND_DRBG_get0_master OPENSSL_MANGLER(RAND_DRBG_get0_master)
# endif
#else
# ifndef _RAND_DRBG_get0_master
#  define _RAND_DRBG_get0_master OPENSSL_MANGLER_ASM(RAND_DRBG_get0_master)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_get0_private
#  define RAND_DRBG_get0_private OPENSSL_MANGLER(RAND_DRBG_get0_private)
# endif
#else
# ifndef _RAND_DRBG_get0_private
#  define _RAND_DRBG_get0_private OPENSSL_MANGLER_ASM(RAND_DRBG_get0_private)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_get0_public
#  define RAND_DRBG_get0_public OPENSSL_MANGLER(RAND_DRBG_get0_public)
# endif
#else
# ifndef _RAND_DRBG_get0_public
#  define _RAND_DRBG_get0_public OPENSSL_MANGLER_ASM(RAND_DRBG_get0_public)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_get_additional_data
#  define rand_drbg_get_additional_data OPENSSL_MANGLER(rand_drbg_get_additional_data)
# endif
#else
# ifndef _rand_drbg_get_additional_data
#  define _rand_drbg_get_additional_data OPENSSL_MANGLER_ASM(rand_drbg_get_additional_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_get_entropy
#  define rand_drbg_get_entropy OPENSSL_MANGLER(rand_drbg_get_entropy)
# endif
#else
# ifndef _rand_drbg_get_entropy
#  define _rand_drbg_get_entropy OPENSSL_MANGLER_ASM(rand_drbg_get_entropy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_get_ex_data
#  define RAND_DRBG_get_ex_data OPENSSL_MANGLER(RAND_DRBG_get_ex_data)
# endif
#else
# ifndef _RAND_DRBG_get_ex_data
#  define _RAND_DRBG_get_ex_data OPENSSL_MANGLER_ASM(RAND_DRBG_get_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_get_nonce
#  define rand_drbg_get_nonce OPENSSL_MANGLER(rand_drbg_get_nonce)
# endif
#else
# ifndef _rand_drbg_get_nonce
#  define _rand_drbg_get_nonce OPENSSL_MANGLER_ASM(rand_drbg_get_nonce)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_instantiate
#  define RAND_DRBG_instantiate OPENSSL_MANGLER(RAND_DRBG_instantiate)
# endif
#else
# ifndef _RAND_DRBG_instantiate
#  define _RAND_DRBG_instantiate OPENSSL_MANGLER_ASM(RAND_DRBG_instantiate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_lock
#  define rand_drbg_lock OPENSSL_MANGLER(rand_drbg_lock)
# endif
#else
# ifndef _rand_drbg_lock
#  define _rand_drbg_lock OPENSSL_MANGLER_ASM(rand_drbg_lock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_new
#  define RAND_DRBG_new OPENSSL_MANGLER(RAND_DRBG_new)
# endif
#else
# ifndef _RAND_DRBG_new
#  define _RAND_DRBG_new OPENSSL_MANGLER_ASM(RAND_DRBG_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_reseed
#  define RAND_DRBG_reseed OPENSSL_MANGLER(RAND_DRBG_reseed)
# endif
#else
# ifndef _RAND_DRBG_reseed
#  define _RAND_DRBG_reseed OPENSSL_MANGLER_ASM(RAND_DRBG_reseed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_restart
#  define rand_drbg_restart OPENSSL_MANGLER(rand_drbg_restart)
# endif
#else
# ifndef _rand_drbg_restart
#  define _rand_drbg_restart OPENSSL_MANGLER_ASM(rand_drbg_restart)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_secure_new
#  define RAND_DRBG_secure_new OPENSSL_MANGLER(RAND_DRBG_secure_new)
# endif
#else
# ifndef _RAND_DRBG_secure_new
#  define _RAND_DRBG_secure_new OPENSSL_MANGLER_ASM(RAND_DRBG_secure_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_seedlen
#  define rand_drbg_seedlen OPENSSL_MANGLER(rand_drbg_seedlen)
# endif
#else
# ifndef _rand_drbg_seedlen
#  define _rand_drbg_seedlen OPENSSL_MANGLER_ASM(rand_drbg_seedlen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_set
#  define RAND_DRBG_set OPENSSL_MANGLER(RAND_DRBG_set)
# endif
#else
# ifndef _RAND_DRBG_set
#  define _RAND_DRBG_set OPENSSL_MANGLER_ASM(RAND_DRBG_set)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_set_callbacks
#  define RAND_DRBG_set_callbacks OPENSSL_MANGLER(RAND_DRBG_set_callbacks)
# endif
#else
# ifndef _RAND_DRBG_set_callbacks
#  define _RAND_DRBG_set_callbacks OPENSSL_MANGLER_ASM(RAND_DRBG_set_callbacks)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_set_defaults
#  define RAND_DRBG_set_defaults OPENSSL_MANGLER(RAND_DRBG_set_defaults)
# endif
#else
# ifndef _RAND_DRBG_set_defaults
#  define _RAND_DRBG_set_defaults OPENSSL_MANGLER_ASM(RAND_DRBG_set_defaults)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_set_ex_data
#  define RAND_DRBG_set_ex_data OPENSSL_MANGLER(RAND_DRBG_set_ex_data)
# endif
#else
# ifndef _RAND_DRBG_set_ex_data
#  define _RAND_DRBG_set_ex_data OPENSSL_MANGLER_ASM(RAND_DRBG_set_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_set_reseed_defaults
#  define RAND_DRBG_set_reseed_defaults OPENSSL_MANGLER(RAND_DRBG_set_reseed_defaults)
# endif
#else
# ifndef _RAND_DRBG_set_reseed_defaults
#  define _RAND_DRBG_set_reseed_defaults OPENSSL_MANGLER_ASM(RAND_DRBG_set_reseed_defaults)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_set_reseed_interval
#  define RAND_DRBG_set_reseed_interval OPENSSL_MANGLER(RAND_DRBG_set_reseed_interval)
# endif
#else
# ifndef _RAND_DRBG_set_reseed_interval
#  define _RAND_DRBG_set_reseed_interval OPENSSL_MANGLER_ASM(RAND_DRBG_set_reseed_interval)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_set_reseed_time_interval
#  define RAND_DRBG_set_reseed_time_interval OPENSSL_MANGLER(RAND_DRBG_set_reseed_time_interval)
# endif
#else
# ifndef _RAND_DRBG_set_reseed_time_interval
#  define _RAND_DRBG_set_reseed_time_interval OPENSSL_MANGLER_ASM(RAND_DRBG_set_reseed_time_interval)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_DRBG_uninstantiate
#  define RAND_DRBG_uninstantiate OPENSSL_MANGLER(RAND_DRBG_uninstantiate)
# endif
#else
# ifndef _RAND_DRBG_uninstantiate
#  define _RAND_DRBG_uninstantiate OPENSSL_MANGLER_ASM(RAND_DRBG_uninstantiate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_drbg_unlock
#  define rand_drbg_unlock OPENSSL_MANGLER(rand_drbg_unlock)
# endif
#else
# ifndef _rand_drbg_unlock
#  define _rand_drbg_unlock OPENSSL_MANGLER_ASM(rand_drbg_unlock)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_file_name
#  define RAND_file_name OPENSSL_MANGLER(RAND_file_name)
# endif
#else
# ifndef _RAND_file_name
#  define _RAND_file_name OPENSSL_MANGLER_ASM(RAND_file_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_fork
#  define rand_fork OPENSSL_MANGLER(rand_fork)
# endif
#else
# ifndef _rand_fork
#  define _rand_fork OPENSSL_MANGLER_ASM(rand_fork)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_fork_count
#  define rand_fork_count OPENSSL_MANGLER(rand_fork_count)
# endif
#else
# ifndef _rand_fork_count
#  define _rand_fork_count OPENSSL_MANGLER_ASM(rand_fork_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_get_rand_method
#  define RAND_get_rand_method OPENSSL_MANGLER(RAND_get_rand_method)
# endif
#else
# ifndef _RAND_get_rand_method
#  define _RAND_get_rand_method OPENSSL_MANGLER_ASM(RAND_get_rand_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_keep_random_devices_open
#  define RAND_keep_random_devices_open OPENSSL_MANGLER(RAND_keep_random_devices_open)
# endif
#else
# ifndef _RAND_keep_random_devices_open
#  define _RAND_keep_random_devices_open OPENSSL_MANGLER_ASM(RAND_keep_random_devices_open)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_load_file
#  define RAND_load_file OPENSSL_MANGLER(RAND_load_file)
# endif
#else
# ifndef _RAND_load_file
#  define _RAND_load_file OPENSSL_MANGLER_ASM(RAND_load_file)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_meth
#  define rand_meth OPENSSL_MANGLER(rand_meth)
# endif
#else
# ifndef _rand_meth
#  define _rand_meth OPENSSL_MANGLER_ASM(rand_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_OpenSSL
#  define RAND_OpenSSL OPENSSL_MANGLER(RAND_OpenSSL)
# endif
#else
# ifndef _RAND_OpenSSL
#  define _RAND_OpenSSL OPENSSL_MANGLER_ASM(RAND_OpenSSL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_poll
#  define RAND_poll OPENSSL_MANGLER(RAND_poll)
# endif
#else
# ifndef _RAND_poll
#  define _RAND_poll OPENSSL_MANGLER_ASM(RAND_poll)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_acquire_entropy
#  define rand_pool_acquire_entropy OPENSSL_MANGLER(rand_pool_acquire_entropy)
# endif
#else
# ifndef _rand_pool_acquire_entropy
#  define _rand_pool_acquire_entropy OPENSSL_MANGLER_ASM(rand_pool_acquire_entropy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_add
#  define rand_pool_add OPENSSL_MANGLER(rand_pool_add)
# endif
#else
# ifndef _rand_pool_add
#  define _rand_pool_add OPENSSL_MANGLER_ASM(rand_pool_add)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_add_additional_data
#  define rand_pool_add_additional_data OPENSSL_MANGLER(rand_pool_add_additional_data)
# endif
#else
# ifndef _rand_pool_add_additional_data
#  define _rand_pool_add_additional_data OPENSSL_MANGLER_ASM(rand_pool_add_additional_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_add_begin
#  define rand_pool_add_begin OPENSSL_MANGLER(rand_pool_add_begin)
# endif
#else
# ifndef _rand_pool_add_begin
#  define _rand_pool_add_begin OPENSSL_MANGLER_ASM(rand_pool_add_begin)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_add_end
#  define rand_pool_add_end OPENSSL_MANGLER(rand_pool_add_end)
# endif
#else
# ifndef _rand_pool_add_end
#  define _rand_pool_add_end OPENSSL_MANGLER_ASM(rand_pool_add_end)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_add_nonce_data
#  define rand_pool_add_nonce_data OPENSSL_MANGLER(rand_pool_add_nonce_data)
# endif
#else
# ifndef _rand_pool_add_nonce_data
#  define _rand_pool_add_nonce_data OPENSSL_MANGLER_ASM(rand_pool_add_nonce_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_attach
#  define rand_pool_attach OPENSSL_MANGLER(rand_pool_attach)
# endif
#else
# ifndef _rand_pool_attach
#  define _rand_pool_attach OPENSSL_MANGLER_ASM(rand_pool_attach)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_buffer
#  define rand_pool_buffer OPENSSL_MANGLER(rand_pool_buffer)
# endif
#else
# ifndef _rand_pool_buffer
#  define _rand_pool_buffer OPENSSL_MANGLER_ASM(rand_pool_buffer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_bytes_needed
#  define rand_pool_bytes_needed OPENSSL_MANGLER(rand_pool_bytes_needed)
# endif
#else
# ifndef _rand_pool_bytes_needed
#  define _rand_pool_bytes_needed OPENSSL_MANGLER_ASM(rand_pool_bytes_needed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_bytes_remaining
#  define rand_pool_bytes_remaining OPENSSL_MANGLER(rand_pool_bytes_remaining)
# endif
#else
# ifndef _rand_pool_bytes_remaining
#  define _rand_pool_bytes_remaining OPENSSL_MANGLER_ASM(rand_pool_bytes_remaining)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_cleanup
#  define rand_pool_cleanup OPENSSL_MANGLER(rand_pool_cleanup)
# endif
#else
# ifndef _rand_pool_cleanup
#  define _rand_pool_cleanup OPENSSL_MANGLER_ASM(rand_pool_cleanup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_detach
#  define rand_pool_detach OPENSSL_MANGLER(rand_pool_detach)
# endif
#else
# ifndef _rand_pool_detach
#  define _rand_pool_detach OPENSSL_MANGLER_ASM(rand_pool_detach)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_entropy
#  define rand_pool_entropy OPENSSL_MANGLER(rand_pool_entropy)
# endif
#else
# ifndef _rand_pool_entropy
#  define _rand_pool_entropy OPENSSL_MANGLER_ASM(rand_pool_entropy)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_entropy_available
#  define rand_pool_entropy_available OPENSSL_MANGLER(rand_pool_entropy_available)
# endif
#else
# ifndef _rand_pool_entropy_available
#  define _rand_pool_entropy_available OPENSSL_MANGLER_ASM(rand_pool_entropy_available)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_entropy_needed
#  define rand_pool_entropy_needed OPENSSL_MANGLER(rand_pool_entropy_needed)
# endif
#else
# ifndef _rand_pool_entropy_needed
#  define _rand_pool_entropy_needed OPENSSL_MANGLER_ASM(rand_pool_entropy_needed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_free
#  define rand_pool_free OPENSSL_MANGLER(rand_pool_free)
# endif
#else
# ifndef _rand_pool_free
#  define _rand_pool_free OPENSSL_MANGLER_ASM(rand_pool_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_init
#  define rand_pool_init OPENSSL_MANGLER(rand_pool_init)
# endif
#else
# ifndef _rand_pool_init
#  define _rand_pool_init OPENSSL_MANGLER_ASM(rand_pool_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_keep_random_devices_open
#  define rand_pool_keep_random_devices_open OPENSSL_MANGLER(rand_pool_keep_random_devices_open)
# endif
#else
# ifndef _rand_pool_keep_random_devices_open
#  define _rand_pool_keep_random_devices_open OPENSSL_MANGLER_ASM(rand_pool_keep_random_devices_open)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_length
#  define rand_pool_length OPENSSL_MANGLER(rand_pool_length)
# endif
#else
# ifndef _rand_pool_length
#  define _rand_pool_length OPENSSL_MANGLER_ASM(rand_pool_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_new
#  define rand_pool_new OPENSSL_MANGLER(rand_pool_new)
# endif
#else
# ifndef _rand_pool_new
#  define _rand_pool_new OPENSSL_MANGLER_ASM(rand_pool_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rand_pool_reattach
#  define rand_pool_reattach OPENSSL_MANGLER(rand_pool_reattach)
# endif
#else
# ifndef _rand_pool_reattach
#  define _rand_pool_reattach OPENSSL_MANGLER_ASM(rand_pool_reattach)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_priv_bytes
#  define RAND_priv_bytes OPENSSL_MANGLER(RAND_priv_bytes)
# endif
#else
# ifndef _RAND_priv_bytes
#  define _RAND_priv_bytes OPENSSL_MANGLER_ASM(RAND_priv_bytes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_pseudo_bytes
#  define RAND_pseudo_bytes OPENSSL_MANGLER(RAND_pseudo_bytes)
# endif
#else
# ifndef _RAND_pseudo_bytes
#  define _RAND_pseudo_bytes OPENSSL_MANGLER_ASM(RAND_pseudo_bytes)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_seed
#  define RAND_seed OPENSSL_MANGLER(RAND_seed)
# endif
#else
# ifndef _RAND_seed
#  define _RAND_seed OPENSSL_MANGLER_ASM(RAND_seed)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_set_rand_method
#  define RAND_set_rand_method OPENSSL_MANGLER(RAND_set_rand_method)
# endif
#else
# ifndef _RAND_set_rand_method
#  define _RAND_set_rand_method OPENSSL_MANGLER_ASM(RAND_set_rand_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_status
#  define RAND_status OPENSSL_MANGLER(RAND_status)
# endif
#else
# ifndef _RAND_status
#  define _RAND_status OPENSSL_MANGLER_ASM(RAND_status)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RAND_write_file
#  define RAND_write_file OPENSSL_MANGLER(RAND_write_file)
# endif
#else
# ifndef _RAND_write_file
#  define _RAND_write_file OPENSSL_MANGLER_ASM(RAND_write_file)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RC4
#  define RC4 OPENSSL_MANGLER(RC4)
# endif
#else
# ifndef _RC4
#  define _RC4 OPENSSL_MANGLER_ASM(RC4)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rc4_md5_enc
#  define rc4_md5_enc OPENSSL_MANGLER(rc4_md5_enc)
# endif
#else
# ifndef _rc4_md5_enc
#  define _rc4_md5_enc OPENSSL_MANGLER_ASM(rc4_md5_enc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RC4_options
#  define RC4_options OPENSSL_MANGLER(RC4_options)
# endif
#else
# ifndef _RC4_options
#  define _RC4_options OPENSSL_MANGLER_ASM(RC4_options)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RC4_set_key
#  define RC4_set_key OPENSSL_MANGLER(RC4_set_key)
# endif
#else
# ifndef _RC4_set_key
#  define _RC4_set_key OPENSSL_MANGLER_ASM(RC4_set_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RECORD_LAYER_clear
#  define RECORD_LAYER_clear OPENSSL_MANGLER(RECORD_LAYER_clear)
# endif
#else
# ifndef _RECORD_LAYER_clear
#  define _RECORD_LAYER_clear OPENSSL_MANGLER_ASM(RECORD_LAYER_clear)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RECORD_LAYER_get_rrec_length
#  define RECORD_LAYER_get_rrec_length OPENSSL_MANGLER(RECORD_LAYER_get_rrec_length)
# endif
#else
# ifndef _RECORD_LAYER_get_rrec_length
#  define _RECORD_LAYER_get_rrec_length OPENSSL_MANGLER_ASM(RECORD_LAYER_get_rrec_length)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RECORD_LAYER_init
#  define RECORD_LAYER_init OPENSSL_MANGLER(RECORD_LAYER_init)
# endif
#else
# ifndef _RECORD_LAYER_init
#  define _RECORD_LAYER_init OPENSSL_MANGLER_ASM(RECORD_LAYER_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RECORD_LAYER_is_sslv2_record
#  define RECORD_LAYER_is_sslv2_record OPENSSL_MANGLER(RECORD_LAYER_is_sslv2_record)
# endif
#else
# ifndef _RECORD_LAYER_is_sslv2_record
#  define _RECORD_LAYER_is_sslv2_record OPENSSL_MANGLER_ASM(RECORD_LAYER_is_sslv2_record)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RECORD_LAYER_processed_read_pending
#  define RECORD_LAYER_processed_read_pending OPENSSL_MANGLER(RECORD_LAYER_processed_read_pending)
# endif
#else
# ifndef _RECORD_LAYER_processed_read_pending
#  define _RECORD_LAYER_processed_read_pending OPENSSL_MANGLER_ASM(RECORD_LAYER_processed_read_pending)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RECORD_LAYER_read_pending
#  define RECORD_LAYER_read_pending OPENSSL_MANGLER(RECORD_LAYER_read_pending)
# endif
#else
# ifndef _RECORD_LAYER_read_pending
#  define _RECORD_LAYER_read_pending OPENSSL_MANGLER_ASM(RECORD_LAYER_read_pending)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RECORD_LAYER_release
#  define RECORD_LAYER_release OPENSSL_MANGLER(RECORD_LAYER_release)
# endif
#else
# ifndef _RECORD_LAYER_release
#  define _RECORD_LAYER_release OPENSSL_MANGLER_ASM(RECORD_LAYER_release)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RECORD_LAYER_reset_read_sequence
#  define RECORD_LAYER_reset_read_sequence OPENSSL_MANGLER(RECORD_LAYER_reset_read_sequence)
# endif
#else
# ifndef _RECORD_LAYER_reset_read_sequence
#  define _RECORD_LAYER_reset_read_sequence OPENSSL_MANGLER_ASM(RECORD_LAYER_reset_read_sequence)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RECORD_LAYER_reset_write_sequence
#  define RECORD_LAYER_reset_write_sequence OPENSSL_MANGLER(RECORD_LAYER_reset_write_sequence)
# endif
#else
# ifndef _RECORD_LAYER_reset_write_sequence
#  define _RECORD_LAYER_reset_write_sequence OPENSSL_MANGLER_ASM(RECORD_LAYER_reset_write_sequence)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RECORD_LAYER_write_pending
#  define RECORD_LAYER_write_pending OPENSSL_MANGLER(RECORD_LAYER_write_pending)
# endif
#else
# ifndef _RECORD_LAYER_write_pending
#  define _RECORD_LAYER_write_pending OPENSSL_MANGLER_ASM(RECORD_LAYER_write_pending)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_asn1_meths
#  define rsa_asn1_meths OPENSSL_MANGLER(rsa_asn1_meths)
# endif
#else
# ifndef _rsa_asn1_meths
#  define _rsa_asn1_meths OPENSSL_MANGLER_ASM(rsa_asn1_meths)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_bits
#  define RSA_bits OPENSSL_MANGLER(RSA_bits)
# endif
#else
# ifndef _RSA_bits
#  define _RSA_bits OPENSSL_MANGLER_ASM(RSA_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_blinding_off
#  define RSA_blinding_off OPENSSL_MANGLER(RSA_blinding_off)
# endif
#else
# ifndef _RSA_blinding_off
#  define _RSA_blinding_off OPENSSL_MANGLER_ASM(RSA_blinding_off)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_blinding_on
#  define RSA_blinding_on OPENSSL_MANGLER(RSA_blinding_on)
# endif
#else
# ifndef _RSA_blinding_on
#  define _RSA_blinding_on OPENSSL_MANGLER_ASM(RSA_blinding_on)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_check_key
#  define RSA_check_key OPENSSL_MANGLER(RSA_check_key)
# endif
#else
# ifndef _RSA_check_key
#  define _RSA_check_key OPENSSL_MANGLER_ASM(RSA_check_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_check_key_ex
#  define RSA_check_key_ex OPENSSL_MANGLER(RSA_check_key_ex)
# endif
#else
# ifndef _RSA_check_key_ex
#  define _RSA_check_key_ex OPENSSL_MANGLER_ASM(RSA_check_key_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_clear_flags
#  define RSA_clear_flags OPENSSL_MANGLER(RSA_clear_flags)
# endif
#else
# ifndef _RSA_clear_flags
#  define _RSA_clear_flags OPENSSL_MANGLER_ASM(RSA_clear_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_flags
#  define RSA_flags OPENSSL_MANGLER(RSA_flags)
# endif
#else
# ifndef _RSA_flags
#  define _RSA_flags OPENSSL_MANGLER_ASM(RSA_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_free
#  define RSA_free OPENSSL_MANGLER(RSA_free)
# endif
#else
# ifndef _RSA_free
#  define _RSA_free OPENSSL_MANGLER_ASM(RSA_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_generate_key
#  define RSA_generate_key OPENSSL_MANGLER(RSA_generate_key)
# endif
#else
# ifndef _RSA_generate_key
#  define _RSA_generate_key OPENSSL_MANGLER_ASM(RSA_generate_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_generate_key_ex
#  define RSA_generate_key_ex OPENSSL_MANGLER(RSA_generate_key_ex)
# endif
#else
# ifndef _RSA_generate_key_ex
#  define _RSA_generate_key_ex OPENSSL_MANGLER_ASM(RSA_generate_key_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_generate_multi_prime_key
#  define RSA_generate_multi_prime_key OPENSSL_MANGLER(RSA_generate_multi_prime_key)
# endif
#else
# ifndef _RSA_generate_multi_prime_key
#  define _RSA_generate_multi_prime_key OPENSSL_MANGLER_ASM(RSA_generate_multi_prime_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_crt_params
#  define RSA_get0_crt_params OPENSSL_MANGLER(RSA_get0_crt_params)
# endif
#else
# ifndef _RSA_get0_crt_params
#  define _RSA_get0_crt_params OPENSSL_MANGLER_ASM(RSA_get0_crt_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_d
#  define RSA_get0_d OPENSSL_MANGLER(RSA_get0_d)
# endif
#else
# ifndef _RSA_get0_d
#  define _RSA_get0_d OPENSSL_MANGLER_ASM(RSA_get0_d)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_dmp1
#  define RSA_get0_dmp1 OPENSSL_MANGLER(RSA_get0_dmp1)
# endif
#else
# ifndef _RSA_get0_dmp1
#  define _RSA_get0_dmp1 OPENSSL_MANGLER_ASM(RSA_get0_dmp1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_dmq1
#  define RSA_get0_dmq1 OPENSSL_MANGLER(RSA_get0_dmq1)
# endif
#else
# ifndef _RSA_get0_dmq1
#  define _RSA_get0_dmq1 OPENSSL_MANGLER_ASM(RSA_get0_dmq1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_e
#  define RSA_get0_e OPENSSL_MANGLER(RSA_get0_e)
# endif
#else
# ifndef _RSA_get0_e
#  define _RSA_get0_e OPENSSL_MANGLER_ASM(RSA_get0_e)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_engine
#  define RSA_get0_engine OPENSSL_MANGLER(RSA_get0_engine)
# endif
#else
# ifndef _RSA_get0_engine
#  define _RSA_get0_engine OPENSSL_MANGLER_ASM(RSA_get0_engine)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_factors
#  define RSA_get0_factors OPENSSL_MANGLER(RSA_get0_factors)
# endif
#else
# ifndef _RSA_get0_factors
#  define _RSA_get0_factors OPENSSL_MANGLER_ASM(RSA_get0_factors)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_iqmp
#  define RSA_get0_iqmp OPENSSL_MANGLER(RSA_get0_iqmp)
# endif
#else
# ifndef _RSA_get0_iqmp
#  define _RSA_get0_iqmp OPENSSL_MANGLER_ASM(RSA_get0_iqmp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_key
#  define RSA_get0_key OPENSSL_MANGLER(RSA_get0_key)
# endif
#else
# ifndef _RSA_get0_key
#  define _RSA_get0_key OPENSSL_MANGLER_ASM(RSA_get0_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_multi_prime_crt_params
#  define RSA_get0_multi_prime_crt_params OPENSSL_MANGLER(RSA_get0_multi_prime_crt_params)
# endif
#else
# ifndef _RSA_get0_multi_prime_crt_params
#  define _RSA_get0_multi_prime_crt_params OPENSSL_MANGLER_ASM(RSA_get0_multi_prime_crt_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_multi_prime_factors
#  define RSA_get0_multi_prime_factors OPENSSL_MANGLER(RSA_get0_multi_prime_factors)
# endif
#else
# ifndef _RSA_get0_multi_prime_factors
#  define _RSA_get0_multi_prime_factors OPENSSL_MANGLER_ASM(RSA_get0_multi_prime_factors)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_n
#  define RSA_get0_n OPENSSL_MANGLER(RSA_get0_n)
# endif
#else
# ifndef _RSA_get0_n
#  define _RSA_get0_n OPENSSL_MANGLER_ASM(RSA_get0_n)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_p
#  define RSA_get0_p OPENSSL_MANGLER(RSA_get0_p)
# endif
#else
# ifndef _RSA_get0_p
#  define _RSA_get0_p OPENSSL_MANGLER_ASM(RSA_get0_p)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get0_q
#  define RSA_get0_q OPENSSL_MANGLER(RSA_get0_q)
# endif
#else
# ifndef _RSA_get0_q
#  define _RSA_get0_q OPENSSL_MANGLER_ASM(RSA_get0_q)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get_default_method
#  define RSA_get_default_method OPENSSL_MANGLER(RSA_get_default_method)
# endif
#else
# ifndef _RSA_get_default_method
#  define _RSA_get_default_method OPENSSL_MANGLER_ASM(RSA_get_default_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get_ex_data
#  define RSA_get_ex_data OPENSSL_MANGLER(RSA_get_ex_data)
# endif
#else
# ifndef _RSA_get_ex_data
#  define _RSA_get_ex_data OPENSSL_MANGLER_ASM(RSA_get_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get_method
#  define RSA_get_method OPENSSL_MANGLER(RSA_get_method)
# endif
#else
# ifndef _RSA_get_method
#  define _RSA_get_method OPENSSL_MANGLER_ASM(RSA_get_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get_multi_prime_extra_count
#  define RSA_get_multi_prime_extra_count OPENSSL_MANGLER(RSA_get_multi_prime_extra_count)
# endif
#else
# ifndef _RSA_get_multi_prime_extra_count
#  define _RSA_get_multi_prime_extra_count OPENSSL_MANGLER_ASM(RSA_get_multi_prime_extra_count)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_get_version
#  define RSA_get_version OPENSSL_MANGLER(RSA_get_version)
# endif
#else
# ifndef _RSA_get_version
#  define _RSA_get_version OPENSSL_MANGLER_ASM(RSA_get_version)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_dup
#  define RSA_meth_dup OPENSSL_MANGLER(RSA_meth_dup)
# endif
#else
# ifndef _RSA_meth_dup
#  define _RSA_meth_dup OPENSSL_MANGLER_ASM(RSA_meth_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_free
#  define RSA_meth_free OPENSSL_MANGLER(RSA_meth_free)
# endif
#else
# ifndef _RSA_meth_free
#  define _RSA_meth_free OPENSSL_MANGLER_ASM(RSA_meth_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get0_app_data
#  define RSA_meth_get0_app_data OPENSSL_MANGLER(RSA_meth_get0_app_data)
# endif
#else
# ifndef _RSA_meth_get0_app_data
#  define _RSA_meth_get0_app_data OPENSSL_MANGLER_ASM(RSA_meth_get0_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get0_name
#  define RSA_meth_get0_name OPENSSL_MANGLER(RSA_meth_get0_name)
# endif
#else
# ifndef _RSA_meth_get0_name
#  define _RSA_meth_get0_name OPENSSL_MANGLER_ASM(RSA_meth_get0_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_bn_mod_exp
#  define RSA_meth_get_bn_mod_exp OPENSSL_MANGLER(RSA_meth_get_bn_mod_exp)
# endif
#else
# ifndef _RSA_meth_get_bn_mod_exp
#  define _RSA_meth_get_bn_mod_exp OPENSSL_MANGLER_ASM(RSA_meth_get_bn_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_finish
#  define RSA_meth_get_finish OPENSSL_MANGLER(RSA_meth_get_finish)
# endif
#else
# ifndef _RSA_meth_get_finish
#  define _RSA_meth_get_finish OPENSSL_MANGLER_ASM(RSA_meth_get_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_flags
#  define RSA_meth_get_flags OPENSSL_MANGLER(RSA_meth_get_flags)
# endif
#else
# ifndef _RSA_meth_get_flags
#  define _RSA_meth_get_flags OPENSSL_MANGLER_ASM(RSA_meth_get_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_init
#  define RSA_meth_get_init OPENSSL_MANGLER(RSA_meth_get_init)
# endif
#else
# ifndef _RSA_meth_get_init
#  define _RSA_meth_get_init OPENSSL_MANGLER_ASM(RSA_meth_get_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_keygen
#  define RSA_meth_get_keygen OPENSSL_MANGLER(RSA_meth_get_keygen)
# endif
#else
# ifndef _RSA_meth_get_keygen
#  define _RSA_meth_get_keygen OPENSSL_MANGLER_ASM(RSA_meth_get_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_mod_exp
#  define RSA_meth_get_mod_exp OPENSSL_MANGLER(RSA_meth_get_mod_exp)
# endif
#else
# ifndef _RSA_meth_get_mod_exp
#  define _RSA_meth_get_mod_exp OPENSSL_MANGLER_ASM(RSA_meth_get_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_multi_prime_keygen
#  define RSA_meth_get_multi_prime_keygen OPENSSL_MANGLER(RSA_meth_get_multi_prime_keygen)
# endif
#else
# ifndef _RSA_meth_get_multi_prime_keygen
#  define _RSA_meth_get_multi_prime_keygen OPENSSL_MANGLER_ASM(RSA_meth_get_multi_prime_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_priv_dec
#  define RSA_meth_get_priv_dec OPENSSL_MANGLER(RSA_meth_get_priv_dec)
# endif
#else
# ifndef _RSA_meth_get_priv_dec
#  define _RSA_meth_get_priv_dec OPENSSL_MANGLER_ASM(RSA_meth_get_priv_dec)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_priv_enc
#  define RSA_meth_get_priv_enc OPENSSL_MANGLER(RSA_meth_get_priv_enc)
# endif
#else
# ifndef _RSA_meth_get_priv_enc
#  define _RSA_meth_get_priv_enc OPENSSL_MANGLER_ASM(RSA_meth_get_priv_enc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_pub_dec
#  define RSA_meth_get_pub_dec OPENSSL_MANGLER(RSA_meth_get_pub_dec)
# endif
#else
# ifndef _RSA_meth_get_pub_dec
#  define _RSA_meth_get_pub_dec OPENSSL_MANGLER_ASM(RSA_meth_get_pub_dec)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_pub_enc
#  define RSA_meth_get_pub_enc OPENSSL_MANGLER(RSA_meth_get_pub_enc)
# endif
#else
# ifndef _RSA_meth_get_pub_enc
#  define _RSA_meth_get_pub_enc OPENSSL_MANGLER_ASM(RSA_meth_get_pub_enc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_sign
#  define RSA_meth_get_sign OPENSSL_MANGLER(RSA_meth_get_sign)
# endif
#else
# ifndef _RSA_meth_get_sign
#  define _RSA_meth_get_sign OPENSSL_MANGLER_ASM(RSA_meth_get_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_get_verify
#  define RSA_meth_get_verify OPENSSL_MANGLER(RSA_meth_get_verify)
# endif
#else
# ifndef _RSA_meth_get_verify
#  define _RSA_meth_get_verify OPENSSL_MANGLER_ASM(RSA_meth_get_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_new
#  define RSA_meth_new OPENSSL_MANGLER(RSA_meth_new)
# endif
#else
# ifndef _RSA_meth_new
#  define _RSA_meth_new OPENSSL_MANGLER_ASM(RSA_meth_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set0_app_data
#  define RSA_meth_set0_app_data OPENSSL_MANGLER(RSA_meth_set0_app_data)
# endif
#else
# ifndef _RSA_meth_set0_app_data
#  define _RSA_meth_set0_app_data OPENSSL_MANGLER_ASM(RSA_meth_set0_app_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set1_name
#  define RSA_meth_set1_name OPENSSL_MANGLER(RSA_meth_set1_name)
# endif
#else
# ifndef _RSA_meth_set1_name
#  define _RSA_meth_set1_name OPENSSL_MANGLER_ASM(RSA_meth_set1_name)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_bn_mod_exp
#  define RSA_meth_set_bn_mod_exp OPENSSL_MANGLER(RSA_meth_set_bn_mod_exp)
# endif
#else
# ifndef _RSA_meth_set_bn_mod_exp
#  define _RSA_meth_set_bn_mod_exp OPENSSL_MANGLER_ASM(RSA_meth_set_bn_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_finish
#  define RSA_meth_set_finish OPENSSL_MANGLER(RSA_meth_set_finish)
# endif
#else
# ifndef _RSA_meth_set_finish
#  define _RSA_meth_set_finish OPENSSL_MANGLER_ASM(RSA_meth_set_finish)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_flags
#  define RSA_meth_set_flags OPENSSL_MANGLER(RSA_meth_set_flags)
# endif
#else
# ifndef _RSA_meth_set_flags
#  define _RSA_meth_set_flags OPENSSL_MANGLER_ASM(RSA_meth_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_init
#  define RSA_meth_set_init OPENSSL_MANGLER(RSA_meth_set_init)
# endif
#else
# ifndef _RSA_meth_set_init
#  define _RSA_meth_set_init OPENSSL_MANGLER_ASM(RSA_meth_set_init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_keygen
#  define RSA_meth_set_keygen OPENSSL_MANGLER(RSA_meth_set_keygen)
# endif
#else
# ifndef _RSA_meth_set_keygen
#  define _RSA_meth_set_keygen OPENSSL_MANGLER_ASM(RSA_meth_set_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_mod_exp
#  define RSA_meth_set_mod_exp OPENSSL_MANGLER(RSA_meth_set_mod_exp)
# endif
#else
# ifndef _RSA_meth_set_mod_exp
#  define _RSA_meth_set_mod_exp OPENSSL_MANGLER_ASM(RSA_meth_set_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_multi_prime_keygen
#  define RSA_meth_set_multi_prime_keygen OPENSSL_MANGLER(RSA_meth_set_multi_prime_keygen)
# endif
#else
# ifndef _RSA_meth_set_multi_prime_keygen
#  define _RSA_meth_set_multi_prime_keygen OPENSSL_MANGLER_ASM(RSA_meth_set_multi_prime_keygen)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_priv_dec
#  define RSA_meth_set_priv_dec OPENSSL_MANGLER(RSA_meth_set_priv_dec)
# endif
#else
# ifndef _RSA_meth_set_priv_dec
#  define _RSA_meth_set_priv_dec OPENSSL_MANGLER_ASM(RSA_meth_set_priv_dec)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_priv_enc
#  define RSA_meth_set_priv_enc OPENSSL_MANGLER(RSA_meth_set_priv_enc)
# endif
#else
# ifndef _RSA_meth_set_priv_enc
#  define _RSA_meth_set_priv_enc OPENSSL_MANGLER_ASM(RSA_meth_set_priv_enc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_pub_dec
#  define RSA_meth_set_pub_dec OPENSSL_MANGLER(RSA_meth_set_pub_dec)
# endif
#else
# ifndef _RSA_meth_set_pub_dec
#  define _RSA_meth_set_pub_dec OPENSSL_MANGLER_ASM(RSA_meth_set_pub_dec)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_pub_enc
#  define RSA_meth_set_pub_enc OPENSSL_MANGLER(RSA_meth_set_pub_enc)
# endif
#else
# ifndef _RSA_meth_set_pub_enc
#  define _RSA_meth_set_pub_enc OPENSSL_MANGLER_ASM(RSA_meth_set_pub_enc)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_sign
#  define RSA_meth_set_sign OPENSSL_MANGLER(RSA_meth_set_sign)
# endif
#else
# ifndef _RSA_meth_set_sign
#  define _RSA_meth_set_sign OPENSSL_MANGLER_ASM(RSA_meth_set_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_meth_set_verify
#  define RSA_meth_set_verify OPENSSL_MANGLER(RSA_meth_set_verify)
# endif
#else
# ifndef _RSA_meth_set_verify
#  define _RSA_meth_set_verify OPENSSL_MANGLER_ASM(RSA_meth_set_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_multip_calc_product
#  define rsa_multip_calc_product OPENSSL_MANGLER(rsa_multip_calc_product)
# endif
#else
# ifndef _rsa_multip_calc_product
#  define _rsa_multip_calc_product OPENSSL_MANGLER_ASM(rsa_multip_calc_product)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_multip_cap
#  define rsa_multip_cap OPENSSL_MANGLER(rsa_multip_cap)
# endif
#else
# ifndef _rsa_multip_cap
#  define _rsa_multip_cap OPENSSL_MANGLER_ASM(rsa_multip_cap)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_multip_info_free
#  define rsa_multip_info_free OPENSSL_MANGLER(rsa_multip_info_free)
# endif
#else
# ifndef _rsa_multip_info_free
#  define _rsa_multip_info_free OPENSSL_MANGLER_ASM(rsa_multip_info_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_multip_info_free_ex
#  define rsa_multip_info_free_ex OPENSSL_MANGLER(rsa_multip_info_free_ex)
# endif
#else
# ifndef _rsa_multip_info_free_ex
#  define _rsa_multip_info_free_ex OPENSSL_MANGLER_ASM(rsa_multip_info_free_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_multip_info_new
#  define rsa_multip_info_new OPENSSL_MANGLER(rsa_multip_info_new)
# endif
#else
# ifndef _rsa_multip_info_new
#  define _rsa_multip_info_new OPENSSL_MANGLER_ASM(rsa_multip_info_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_new
#  define RSA_new OPENSSL_MANGLER(RSA_new)
# endif
#else
# ifndef _RSA_new
#  define _RSA_new OPENSSL_MANGLER_ASM(RSA_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_new_method
#  define RSA_new_method OPENSSL_MANGLER(RSA_new_method)
# endif
#else
# ifndef _RSA_new_method
#  define _RSA_new_method OPENSSL_MANGLER_ASM(RSA_new_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_null_method
#  define RSA_null_method OPENSSL_MANGLER(RSA_null_method)
# endif
#else
# ifndef _RSA_null_method
#  define _RSA_null_method OPENSSL_MANGLER_ASM(RSA_null_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_OAEP_PARAMS_free
#  define RSA_OAEP_PARAMS_free OPENSSL_MANGLER(RSA_OAEP_PARAMS_free)
# endif
#else
# ifndef _RSA_OAEP_PARAMS_free
#  define _RSA_OAEP_PARAMS_free OPENSSL_MANGLER_ASM(RSA_OAEP_PARAMS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_OAEP_PARAMS_it
#  define RSA_OAEP_PARAMS_it OPENSSL_MANGLER(RSA_OAEP_PARAMS_it)
# endif
#else
# ifndef _RSA_OAEP_PARAMS_it
#  define _RSA_OAEP_PARAMS_it OPENSSL_MANGLER_ASM(RSA_OAEP_PARAMS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_OAEP_PARAMS_new
#  define RSA_OAEP_PARAMS_new OPENSSL_MANGLER(RSA_OAEP_PARAMS_new)
# endif
#else
# ifndef _RSA_OAEP_PARAMS_new
#  define _RSA_OAEP_PARAMS_new OPENSSL_MANGLER_ASM(RSA_OAEP_PARAMS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_add_none
#  define RSA_padding_add_none OPENSSL_MANGLER(RSA_padding_add_none)
# endif
#else
# ifndef _RSA_padding_add_none
#  define _RSA_padding_add_none OPENSSL_MANGLER_ASM(RSA_padding_add_none)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_add_PKCS1_OAEP
#  define RSA_padding_add_PKCS1_OAEP OPENSSL_MANGLER(RSA_padding_add_PKCS1_OAEP)
# endif
#else
# ifndef _RSA_padding_add_PKCS1_OAEP
#  define _RSA_padding_add_PKCS1_OAEP OPENSSL_MANGLER_ASM(RSA_padding_add_PKCS1_OAEP)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_add_PKCS1_OAEP_mgf1
#  define RSA_padding_add_PKCS1_OAEP_mgf1 OPENSSL_MANGLER(RSA_padding_add_PKCS1_OAEP_mgf1)
# endif
#else
# ifndef _RSA_padding_add_PKCS1_OAEP_mgf1
#  define _RSA_padding_add_PKCS1_OAEP_mgf1 OPENSSL_MANGLER_ASM(RSA_padding_add_PKCS1_OAEP_mgf1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_add_PKCS1_PSS
#  define RSA_padding_add_PKCS1_PSS OPENSSL_MANGLER(RSA_padding_add_PKCS1_PSS)
# endif
#else
# ifndef _RSA_padding_add_PKCS1_PSS
#  define _RSA_padding_add_PKCS1_PSS OPENSSL_MANGLER_ASM(RSA_padding_add_PKCS1_PSS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_add_PKCS1_PSS_mgf1
#  define RSA_padding_add_PKCS1_PSS_mgf1 OPENSSL_MANGLER(RSA_padding_add_PKCS1_PSS_mgf1)
# endif
#else
# ifndef _RSA_padding_add_PKCS1_PSS_mgf1
#  define _RSA_padding_add_PKCS1_PSS_mgf1 OPENSSL_MANGLER_ASM(RSA_padding_add_PKCS1_PSS_mgf1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_add_PKCS1_type_1
#  define RSA_padding_add_PKCS1_type_1 OPENSSL_MANGLER(RSA_padding_add_PKCS1_type_1)
# endif
#else
# ifndef _RSA_padding_add_PKCS1_type_1
#  define _RSA_padding_add_PKCS1_type_1 OPENSSL_MANGLER_ASM(RSA_padding_add_PKCS1_type_1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_add_PKCS1_type_2
#  define RSA_padding_add_PKCS1_type_2 OPENSSL_MANGLER(RSA_padding_add_PKCS1_type_2)
# endif
#else
# ifndef _RSA_padding_add_PKCS1_type_2
#  define _RSA_padding_add_PKCS1_type_2 OPENSSL_MANGLER_ASM(RSA_padding_add_PKCS1_type_2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_add_SSLv23
#  define RSA_padding_add_SSLv23 OPENSSL_MANGLER(RSA_padding_add_SSLv23)
# endif
#else
# ifndef _RSA_padding_add_SSLv23
#  define _RSA_padding_add_SSLv23 OPENSSL_MANGLER_ASM(RSA_padding_add_SSLv23)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_add_X931
#  define RSA_padding_add_X931 OPENSSL_MANGLER(RSA_padding_add_X931)
# endif
#else
# ifndef _RSA_padding_add_X931
#  define _RSA_padding_add_X931 OPENSSL_MANGLER_ASM(RSA_padding_add_X931)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_check_none
#  define RSA_padding_check_none OPENSSL_MANGLER(RSA_padding_check_none)
# endif
#else
# ifndef _RSA_padding_check_none
#  define _RSA_padding_check_none OPENSSL_MANGLER_ASM(RSA_padding_check_none)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_check_PKCS1_OAEP
#  define RSA_padding_check_PKCS1_OAEP OPENSSL_MANGLER(RSA_padding_check_PKCS1_OAEP)
# endif
#else
# ifndef _RSA_padding_check_PKCS1_OAEP
#  define _RSA_padding_check_PKCS1_OAEP OPENSSL_MANGLER_ASM(RSA_padding_check_PKCS1_OAEP)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_check_PKCS1_OAEP_mgf1
#  define RSA_padding_check_PKCS1_OAEP_mgf1 OPENSSL_MANGLER(RSA_padding_check_PKCS1_OAEP_mgf1)
# endif
#else
# ifndef _RSA_padding_check_PKCS1_OAEP_mgf1
#  define _RSA_padding_check_PKCS1_OAEP_mgf1 OPENSSL_MANGLER_ASM(RSA_padding_check_PKCS1_OAEP_mgf1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_check_PKCS1_type_1
#  define RSA_padding_check_PKCS1_type_1 OPENSSL_MANGLER(RSA_padding_check_PKCS1_type_1)
# endif
#else
# ifndef _RSA_padding_check_PKCS1_type_1
#  define _RSA_padding_check_PKCS1_type_1 OPENSSL_MANGLER_ASM(RSA_padding_check_PKCS1_type_1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_check_PKCS1_type_2
#  define RSA_padding_check_PKCS1_type_2 OPENSSL_MANGLER(RSA_padding_check_PKCS1_type_2)
# endif
#else
# ifndef _RSA_padding_check_PKCS1_type_2
#  define _RSA_padding_check_PKCS1_type_2 OPENSSL_MANGLER_ASM(RSA_padding_check_PKCS1_type_2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_check_SSLv23
#  define RSA_padding_check_SSLv23 OPENSSL_MANGLER(RSA_padding_check_SSLv23)
# endif
#else
# ifndef _RSA_padding_check_SSLv23
#  define _RSA_padding_check_SSLv23 OPENSSL_MANGLER_ASM(RSA_padding_check_SSLv23)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_padding_check_X931
#  define RSA_padding_check_X931 OPENSSL_MANGLER(RSA_padding_check_X931)
# endif
#else
# ifndef _RSA_padding_check_X931
#  define _RSA_padding_check_X931 OPENSSL_MANGLER_ASM(RSA_padding_check_X931)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_PKCS1_OpenSSL
#  define RSA_PKCS1_OpenSSL OPENSSL_MANGLER(RSA_PKCS1_OpenSSL)
# endif
#else
# ifndef _RSA_PKCS1_OpenSSL
#  define _RSA_PKCS1_OpenSSL OPENSSL_MANGLER_ASM(RSA_PKCS1_OpenSSL)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_pkey_ctx_ctrl
#  define RSA_pkey_ctx_ctrl OPENSSL_MANGLER(RSA_pkey_ctx_ctrl)
# endif
#else
# ifndef _RSA_pkey_ctx_ctrl
#  define _RSA_pkey_ctx_ctrl OPENSSL_MANGLER_ASM(RSA_pkey_ctx_ctrl)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_pkey_meth
#  define rsa_pkey_meth OPENSSL_MANGLER(rsa_pkey_meth)
# endif
#else
# ifndef _rsa_pkey_meth
#  define _rsa_pkey_meth OPENSSL_MANGLER_ASM(rsa_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_PRIME_INFO_it
#  define RSA_PRIME_INFO_it OPENSSL_MANGLER(RSA_PRIME_INFO_it)
# endif
#else
# ifndef _RSA_PRIME_INFO_it
#  define _RSA_PRIME_INFO_it OPENSSL_MANGLER_ASM(RSA_PRIME_INFO_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_print
#  define RSA_print OPENSSL_MANGLER(RSA_print)
# endif
#else
# ifndef _RSA_print
#  define _RSA_print OPENSSL_MANGLER_ASM(RSA_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_print_fp
#  define RSA_print_fp OPENSSL_MANGLER(RSA_print_fp)
# endif
#else
# ifndef _RSA_print_fp
#  define _RSA_print_fp OPENSSL_MANGLER_ASM(RSA_print_fp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_private_decrypt
#  define RSA_private_decrypt OPENSSL_MANGLER(RSA_private_decrypt)
# endif
#else
# ifndef _RSA_private_decrypt
#  define _RSA_private_decrypt OPENSSL_MANGLER_ASM(RSA_private_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_private_encrypt
#  define RSA_private_encrypt OPENSSL_MANGLER(RSA_private_encrypt)
# endif
#else
# ifndef _RSA_private_encrypt
#  define _RSA_private_encrypt OPENSSL_MANGLER_ASM(RSA_private_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSAPrivateKey_dup
#  define RSAPrivateKey_dup OPENSSL_MANGLER(RSAPrivateKey_dup)
# endif
#else
# ifndef _RSAPrivateKey_dup
#  define _RSAPrivateKey_dup OPENSSL_MANGLER_ASM(RSAPrivateKey_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSAPrivateKey_it
#  define RSAPrivateKey_it OPENSSL_MANGLER(RSAPrivateKey_it)
# endif
#else
# ifndef _RSAPrivateKey_it
#  define _RSAPrivateKey_it OPENSSL_MANGLER_ASM(RSAPrivateKey_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_pss_asn1_meth
#  define rsa_pss_asn1_meth OPENSSL_MANGLER(rsa_pss_asn1_meth)
# endif
#else
# ifndef _rsa_pss_asn1_meth
#  define _rsa_pss_asn1_meth OPENSSL_MANGLER_ASM(rsa_pss_asn1_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_pss_get_param
#  define rsa_pss_get_param OPENSSL_MANGLER(rsa_pss_get_param)
# endif
#else
# ifndef _rsa_pss_get_param
#  define _rsa_pss_get_param OPENSSL_MANGLER_ASM(rsa_pss_get_param)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_pss_params_create
#  define rsa_pss_params_create OPENSSL_MANGLER(rsa_pss_params_create)
# endif
#else
# ifndef _rsa_pss_params_create
#  define _rsa_pss_params_create OPENSSL_MANGLER_ASM(rsa_pss_params_create)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_PSS_PARAMS_free
#  define RSA_PSS_PARAMS_free OPENSSL_MANGLER(RSA_PSS_PARAMS_free)
# endif
#else
# ifndef _RSA_PSS_PARAMS_free
#  define _RSA_PSS_PARAMS_free OPENSSL_MANGLER_ASM(RSA_PSS_PARAMS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_PSS_PARAMS_it
#  define RSA_PSS_PARAMS_it OPENSSL_MANGLER(RSA_PSS_PARAMS_it)
# endif
#else
# ifndef _RSA_PSS_PARAMS_it
#  define _RSA_PSS_PARAMS_it OPENSSL_MANGLER_ASM(RSA_PSS_PARAMS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_PSS_PARAMS_new
#  define RSA_PSS_PARAMS_new OPENSSL_MANGLER(RSA_PSS_PARAMS_new)
# endif
#else
# ifndef _RSA_PSS_PARAMS_new
#  define _RSA_PSS_PARAMS_new OPENSSL_MANGLER_ASM(RSA_PSS_PARAMS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsa_pss_pkey_meth
#  define rsa_pss_pkey_meth OPENSSL_MANGLER(rsa_pss_pkey_meth)
# endif
#else
# ifndef _rsa_pss_pkey_meth
#  define _rsa_pss_pkey_meth OPENSSL_MANGLER_ASM(rsa_pss_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_public_decrypt
#  define RSA_public_decrypt OPENSSL_MANGLER(RSA_public_decrypt)
# endif
#else
# ifndef _RSA_public_decrypt
#  define _RSA_public_decrypt OPENSSL_MANGLER_ASM(RSA_public_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_public_encrypt
#  define RSA_public_encrypt OPENSSL_MANGLER(RSA_public_encrypt)
# endif
#else
# ifndef _RSA_public_encrypt
#  define _RSA_public_encrypt OPENSSL_MANGLER_ASM(RSA_public_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSAPublicKey_dup
#  define RSAPublicKey_dup OPENSSL_MANGLER(RSAPublicKey_dup)
# endif
#else
# ifndef _RSAPublicKey_dup
#  define _RSAPublicKey_dup OPENSSL_MANGLER_ASM(RSAPublicKey_dup)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSAPublicKey_it
#  define RSAPublicKey_it OPENSSL_MANGLER(RSAPublicKey_it)
# endif
#else
# ifndef _RSAPublicKey_it
#  define _RSAPublicKey_it OPENSSL_MANGLER_ASM(RSAPublicKey_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_security_bits
#  define RSA_security_bits OPENSSL_MANGLER(RSA_security_bits)
# endif
#else
# ifndef _RSA_security_bits
#  define _RSA_security_bits OPENSSL_MANGLER_ASM(RSA_security_bits)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_set0_crt_params
#  define RSA_set0_crt_params OPENSSL_MANGLER(RSA_set0_crt_params)
# endif
#else
# ifndef _RSA_set0_crt_params
#  define _RSA_set0_crt_params OPENSSL_MANGLER_ASM(RSA_set0_crt_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_set0_factors
#  define RSA_set0_factors OPENSSL_MANGLER(RSA_set0_factors)
# endif
#else
# ifndef _RSA_set0_factors
#  define _RSA_set0_factors OPENSSL_MANGLER_ASM(RSA_set0_factors)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_set0_key
#  define RSA_set0_key OPENSSL_MANGLER(RSA_set0_key)
# endif
#else
# ifndef _RSA_set0_key
#  define _RSA_set0_key OPENSSL_MANGLER_ASM(RSA_set0_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_set0_multi_prime_params
#  define RSA_set0_multi_prime_params OPENSSL_MANGLER(RSA_set0_multi_prime_params)
# endif
#else
# ifndef _RSA_set0_multi_prime_params
#  define _RSA_set0_multi_prime_params OPENSSL_MANGLER_ASM(RSA_set0_multi_prime_params)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_set_default_method
#  define RSA_set_default_method OPENSSL_MANGLER(RSA_set_default_method)
# endif
#else
# ifndef _RSA_set_default_method
#  define _RSA_set_default_method OPENSSL_MANGLER_ASM(RSA_set_default_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_set_ex_data
#  define RSA_set_ex_data OPENSSL_MANGLER(RSA_set_ex_data)
# endif
#else
# ifndef _RSA_set_ex_data
#  define _RSA_set_ex_data OPENSSL_MANGLER_ASM(RSA_set_ex_data)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_set_flags
#  define RSA_set_flags OPENSSL_MANGLER(RSA_set_flags)
# endif
#else
# ifndef _RSA_set_flags
#  define _RSA_set_flags OPENSSL_MANGLER_ASM(RSA_set_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_set_method
#  define RSA_set_method OPENSSL_MANGLER(RSA_set_method)
# endif
#else
# ifndef _RSA_set_method
#  define _RSA_set_method OPENSSL_MANGLER_ASM(RSA_set_method)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_setup_blinding
#  define RSA_setup_blinding OPENSSL_MANGLER(RSA_setup_blinding)
# endif
#else
# ifndef _RSA_setup_blinding
#  define _RSA_setup_blinding OPENSSL_MANGLER_ASM(RSA_setup_blinding)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_sign
#  define RSA_sign OPENSSL_MANGLER(RSA_sign)
# endif
#else
# ifndef _RSA_sign
#  define _RSA_sign OPENSSL_MANGLER_ASM(RSA_sign)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_sign_ASN1_OCTET_STRING
#  define RSA_sign_ASN1_OCTET_STRING OPENSSL_MANGLER(RSA_sign_ASN1_OCTET_STRING)
# endif
#else
# ifndef _RSA_sign_ASN1_OCTET_STRING
#  define _RSA_sign_ASN1_OCTET_STRING OPENSSL_MANGLER_ASM(RSA_sign_ASN1_OCTET_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_size
#  define RSA_size OPENSSL_MANGLER(RSA_size)
# endif
#else
# ifndef _RSA_size
#  define _RSA_size OPENSSL_MANGLER_ASM(RSA_size)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_test_flags
#  define RSA_test_flags OPENSSL_MANGLER(RSA_test_flags)
# endif
#else
# ifndef _RSA_test_flags
#  define _RSA_test_flags OPENSSL_MANGLER_ASM(RSA_test_flags)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_up_ref
#  define RSA_up_ref OPENSSL_MANGLER(RSA_up_ref)
# endif
#else
# ifndef _RSA_up_ref
#  define _RSA_up_ref OPENSSL_MANGLER_ASM(RSA_up_ref)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_verify
#  define RSA_verify OPENSSL_MANGLER(RSA_verify)
# endif
#else
# ifndef _RSA_verify
#  define _RSA_verify OPENSSL_MANGLER_ASM(RSA_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_verify_ASN1_OCTET_STRING
#  define RSA_verify_ASN1_OCTET_STRING OPENSSL_MANGLER(RSA_verify_ASN1_OCTET_STRING)
# endif
#else
# ifndef _RSA_verify_ASN1_OCTET_STRING
#  define _RSA_verify_ASN1_OCTET_STRING OPENSSL_MANGLER_ASM(RSA_verify_ASN1_OCTET_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_verify_PKCS1_PSS
#  define RSA_verify_PKCS1_PSS OPENSSL_MANGLER(RSA_verify_PKCS1_PSS)
# endif
#else
# ifndef _RSA_verify_PKCS1_PSS
#  define _RSA_verify_PKCS1_PSS OPENSSL_MANGLER_ASM(RSA_verify_PKCS1_PSS)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_verify_PKCS1_PSS_mgf1
#  define RSA_verify_PKCS1_PSS_mgf1 OPENSSL_MANGLER(RSA_verify_PKCS1_PSS_mgf1)
# endif
#else
# ifndef _RSA_verify_PKCS1_PSS_mgf1
#  define _RSA_verify_PKCS1_PSS_mgf1 OPENSSL_MANGLER_ASM(RSA_verify_PKCS1_PSS_mgf1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_X931_derive_ex
#  define RSA_X931_derive_ex OPENSSL_MANGLER(RSA_X931_derive_ex)
# endif
#else
# ifndef _RSA_X931_derive_ex
#  define _RSA_X931_derive_ex OPENSSL_MANGLER_ASM(RSA_X931_derive_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_X931_generate_key_ex
#  define RSA_X931_generate_key_ex OPENSSL_MANGLER(RSA_X931_generate_key_ex)
# endif
#else
# ifndef _RSA_X931_generate_key_ex
#  define _RSA_X931_generate_key_ex OPENSSL_MANGLER_ASM(RSA_X931_generate_key_ex)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSA_X931_hash_id
#  define RSA_X931_hash_id OPENSSL_MANGLER(RSA_X931_hash_id)
# endif
#else
# ifndef _RSA_X931_hash_id
#  define _RSA_X931_hash_id OPENSSL_MANGLER_ASM(RSA_X931_hash_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_1024_gather5_avx2
#  define rsaz_1024_gather5_avx2 OPENSSL_MANGLER(rsaz_1024_gather5_avx2)
# endif
#else
# ifndef _rsaz_1024_gather5_avx2
#  define _rsaz_1024_gather5_avx2 OPENSSL_MANGLER_ASM(rsaz_1024_gather5_avx2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSAZ_1024_mod_exp_avx2
#  define RSAZ_1024_mod_exp_avx2 OPENSSL_MANGLER(RSAZ_1024_mod_exp_avx2)
# endif
#else
# ifndef _RSAZ_1024_mod_exp_avx2
#  define _RSAZ_1024_mod_exp_avx2 OPENSSL_MANGLER_ASM(RSAZ_1024_mod_exp_avx2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_1024_mul_avx2
#  define rsaz_1024_mul_avx2 OPENSSL_MANGLER(rsaz_1024_mul_avx2)
# endif
#else
# ifndef _rsaz_1024_mul_avx2
#  define _rsaz_1024_mul_avx2 OPENSSL_MANGLER_ASM(rsaz_1024_mul_avx2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_1024_norm2red_avx2
#  define rsaz_1024_norm2red_avx2 OPENSSL_MANGLER(rsaz_1024_norm2red_avx2)
# endif
#else
# ifndef _rsaz_1024_norm2red_avx2
#  define _rsaz_1024_norm2red_avx2 OPENSSL_MANGLER_ASM(rsaz_1024_norm2red_avx2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_1024_red2norm_avx2
#  define rsaz_1024_red2norm_avx2 OPENSSL_MANGLER(rsaz_1024_red2norm_avx2)
# endif
#else
# ifndef _rsaz_1024_red2norm_avx2
#  define _rsaz_1024_red2norm_avx2 OPENSSL_MANGLER_ASM(rsaz_1024_red2norm_avx2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_1024_scatter5_avx2
#  define rsaz_1024_scatter5_avx2 OPENSSL_MANGLER(rsaz_1024_scatter5_avx2)
# endif
#else
# ifndef _rsaz_1024_scatter5_avx2
#  define _rsaz_1024_scatter5_avx2 OPENSSL_MANGLER_ASM(rsaz_1024_scatter5_avx2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_1024_sqr_avx2
#  define rsaz_1024_sqr_avx2 OPENSSL_MANGLER(rsaz_1024_sqr_avx2)
# endif
#else
# ifndef _rsaz_1024_sqr_avx2
#  define _rsaz_1024_sqr_avx2 OPENSSL_MANGLER_ASM(rsaz_1024_sqr_avx2)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_512_gather4
#  define rsaz_512_gather4 OPENSSL_MANGLER(rsaz_512_gather4)
# endif
#else
# ifndef _rsaz_512_gather4
#  define _rsaz_512_gather4 OPENSSL_MANGLER_ASM(rsaz_512_gather4)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef RSAZ_512_mod_exp
#  define RSAZ_512_mod_exp OPENSSL_MANGLER(RSAZ_512_mod_exp)
# endif
#else
# ifndef _RSAZ_512_mod_exp
#  define _RSAZ_512_mod_exp OPENSSL_MANGLER_ASM(RSAZ_512_mod_exp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_512_mul
#  define rsaz_512_mul OPENSSL_MANGLER(rsaz_512_mul)
# endif
#else
# ifndef _rsaz_512_mul
#  define _rsaz_512_mul OPENSSL_MANGLER_ASM(rsaz_512_mul)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_512_mul_by_one
#  define rsaz_512_mul_by_one OPENSSL_MANGLER(rsaz_512_mul_by_one)
# endif
#else
# ifndef _rsaz_512_mul_by_one
#  define _rsaz_512_mul_by_one OPENSSL_MANGLER_ASM(rsaz_512_mul_by_one)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_512_mul_gather4
#  define rsaz_512_mul_gather4 OPENSSL_MANGLER(rsaz_512_mul_gather4)
# endif
#else
# ifndef _rsaz_512_mul_gather4
#  define _rsaz_512_mul_gather4 OPENSSL_MANGLER_ASM(rsaz_512_mul_gather4)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_512_mul_scatter4
#  define rsaz_512_mul_scatter4 OPENSSL_MANGLER(rsaz_512_mul_scatter4)
# endif
#else
# ifndef _rsaz_512_mul_scatter4
#  define _rsaz_512_mul_scatter4 OPENSSL_MANGLER_ASM(rsaz_512_mul_scatter4)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_512_scatter4
#  define rsaz_512_scatter4 OPENSSL_MANGLER(rsaz_512_scatter4)
# endif
#else
# ifndef _rsaz_512_scatter4
#  define _rsaz_512_scatter4 OPENSSL_MANGLER_ASM(rsaz_512_scatter4)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_512_sqr
#  define rsaz_512_sqr OPENSSL_MANGLER(rsaz_512_sqr)
# endif
#else
# ifndef _rsaz_512_sqr
#  define _rsaz_512_sqr OPENSSL_MANGLER_ASM(rsaz_512_sqr)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef rsaz_avx2_eligible
#  define rsaz_avx2_eligible OPENSSL_MANGLER(rsaz_avx2_eligible)
# endif
#else
# ifndef _rsaz_avx2_eligible
#  define _rsaz_avx2_eligible OPENSSL_MANGLER_ASM(rsaz_avx2_eligible)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef s2i_ASN1_IA5STRING
#  define s2i_ASN1_IA5STRING OPENSSL_MANGLER(s2i_ASN1_IA5STRING)
# endif
#else
# ifndef _s2i_ASN1_IA5STRING
#  define _s2i_ASN1_IA5STRING OPENSSL_MANGLER_ASM(s2i_ASN1_IA5STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef s2i_ASN1_INTEGER
#  define s2i_ASN1_INTEGER OPENSSL_MANGLER(s2i_ASN1_INTEGER)
# endif
#else
# ifndef _s2i_ASN1_INTEGER
#  define _s2i_ASN1_INTEGER OPENSSL_MANGLER_ASM(s2i_ASN1_INTEGER)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef s2i_ASN1_OCTET_STRING
#  define s2i_ASN1_OCTET_STRING OPENSSL_MANGLER(s2i_ASN1_OCTET_STRING)
# endif
#else
# ifndef _s2i_ASN1_OCTET_STRING
#  define _s2i_ASN1_OCTET_STRING OPENSSL_MANGLER_ASM(s2i_ASN1_OCTET_STRING)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCRYPT_PARAMS_free
#  define SCRYPT_PARAMS_free OPENSSL_MANGLER(SCRYPT_PARAMS_free)
# endif
#else
# ifndef _SCRYPT_PARAMS_free
#  define _SCRYPT_PARAMS_free OPENSSL_MANGLER_ASM(SCRYPT_PARAMS_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCRYPT_PARAMS_it
#  define SCRYPT_PARAMS_it OPENSSL_MANGLER(SCRYPT_PARAMS_it)
# endif
#else
# ifndef _SCRYPT_PARAMS_it
#  define _SCRYPT_PARAMS_it OPENSSL_MANGLER_ASM(SCRYPT_PARAMS_it)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCRYPT_PARAMS_new
#  define SCRYPT_PARAMS_new OPENSSL_MANGLER(SCRYPT_PARAMS_new)
# endif
#else
# ifndef _SCRYPT_PARAMS_new
#  define _SCRYPT_PARAMS_new OPENSSL_MANGLER_ASM(SCRYPT_PARAMS_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef scrypt_pkey_meth
#  define scrypt_pkey_meth OPENSSL_MANGLER(scrypt_pkey_meth)
# endif
#else
# ifndef _scrypt_pkey_meth
#  define _scrypt_pkey_meth OPENSSL_MANGLER_ASM(scrypt_pkey_meth)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_CTX_free
#  define SCT_CTX_free OPENSSL_MANGLER(SCT_CTX_free)
# endif
#else
# ifndef _SCT_CTX_free
#  define _SCT_CTX_free OPENSSL_MANGLER_ASM(SCT_CTX_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_CTX_new
#  define SCT_CTX_new OPENSSL_MANGLER(SCT_CTX_new)
# endif
#else
# ifndef _SCT_CTX_new
#  define _SCT_CTX_new OPENSSL_MANGLER_ASM(SCT_CTX_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_CTX_set1_cert
#  define SCT_CTX_set1_cert OPENSSL_MANGLER(SCT_CTX_set1_cert)
# endif
#else
# ifndef _SCT_CTX_set1_cert
#  define _SCT_CTX_set1_cert OPENSSL_MANGLER_ASM(SCT_CTX_set1_cert)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_CTX_set1_issuer
#  define SCT_CTX_set1_issuer OPENSSL_MANGLER(SCT_CTX_set1_issuer)
# endif
#else
# ifndef _SCT_CTX_set1_issuer
#  define _SCT_CTX_set1_issuer OPENSSL_MANGLER_ASM(SCT_CTX_set1_issuer)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_CTX_set1_issuer_pubkey
#  define SCT_CTX_set1_issuer_pubkey OPENSSL_MANGLER(SCT_CTX_set1_issuer_pubkey)
# endif
#else
# ifndef _SCT_CTX_set1_issuer_pubkey
#  define _SCT_CTX_set1_issuer_pubkey OPENSSL_MANGLER_ASM(SCT_CTX_set1_issuer_pubkey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_CTX_set1_pubkey
#  define SCT_CTX_set1_pubkey OPENSSL_MANGLER(SCT_CTX_set1_pubkey)
# endif
#else
# ifndef _SCT_CTX_set1_pubkey
#  define _SCT_CTX_set1_pubkey OPENSSL_MANGLER_ASM(SCT_CTX_set1_pubkey)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_CTX_set_time
#  define SCT_CTX_set_time OPENSSL_MANGLER(SCT_CTX_set_time)
# endif
#else
# ifndef _SCT_CTX_set_time
#  define _SCT_CTX_set_time OPENSSL_MANGLER_ASM(SCT_CTX_set_time)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_CTX_verify
#  define SCT_CTX_verify OPENSSL_MANGLER(SCT_CTX_verify)
# endif
#else
# ifndef _SCT_CTX_verify
#  define _SCT_CTX_verify OPENSSL_MANGLER_ASM(SCT_CTX_verify)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_free
#  define SCT_free OPENSSL_MANGLER(SCT_free)
# endif
#else
# ifndef _SCT_free
#  define _SCT_free OPENSSL_MANGLER_ASM(SCT_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_get0_extensions
#  define SCT_get0_extensions OPENSSL_MANGLER(SCT_get0_extensions)
# endif
#else
# ifndef _SCT_get0_extensions
#  define _SCT_get0_extensions OPENSSL_MANGLER_ASM(SCT_get0_extensions)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_get0_log_id
#  define SCT_get0_log_id OPENSSL_MANGLER(SCT_get0_log_id)
# endif
#else
# ifndef _SCT_get0_log_id
#  define _SCT_get0_log_id OPENSSL_MANGLER_ASM(SCT_get0_log_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_get0_signature
#  define SCT_get0_signature OPENSSL_MANGLER(SCT_get0_signature)
# endif
#else
# ifndef _SCT_get0_signature
#  define _SCT_get0_signature OPENSSL_MANGLER_ASM(SCT_get0_signature)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_get_log_entry_type
#  define SCT_get_log_entry_type OPENSSL_MANGLER(SCT_get_log_entry_type)
# endif
#else
# ifndef _SCT_get_log_entry_type
#  define _SCT_get_log_entry_type OPENSSL_MANGLER_ASM(SCT_get_log_entry_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_get_signature_nid
#  define SCT_get_signature_nid OPENSSL_MANGLER(SCT_get_signature_nid)
# endif
#else
# ifndef _SCT_get_signature_nid
#  define _SCT_get_signature_nid OPENSSL_MANGLER_ASM(SCT_get_signature_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_get_source
#  define SCT_get_source OPENSSL_MANGLER(SCT_get_source)
# endif
#else
# ifndef _SCT_get_source
#  define _SCT_get_source OPENSSL_MANGLER_ASM(SCT_get_source)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_get_timestamp
#  define SCT_get_timestamp OPENSSL_MANGLER(SCT_get_timestamp)
# endif
#else
# ifndef _SCT_get_timestamp
#  define _SCT_get_timestamp OPENSSL_MANGLER_ASM(SCT_get_timestamp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_get_validation_status
#  define SCT_get_validation_status OPENSSL_MANGLER(SCT_get_validation_status)
# endif
#else
# ifndef _SCT_get_validation_status
#  define _SCT_get_validation_status OPENSSL_MANGLER_ASM(SCT_get_validation_status)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_get_version
#  define SCT_get_version OPENSSL_MANGLER(SCT_get_version)
# endif
#else
# ifndef _SCT_get_version
#  define _SCT_get_version OPENSSL_MANGLER_ASM(SCT_get_version)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_is_complete
#  define SCT_is_complete OPENSSL_MANGLER(SCT_is_complete)
# endif
#else
# ifndef _SCT_is_complete
#  define _SCT_is_complete OPENSSL_MANGLER_ASM(SCT_is_complete)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_LIST_free
#  define SCT_LIST_free OPENSSL_MANGLER(SCT_LIST_free)
# endif
#else
# ifndef _SCT_LIST_free
#  define _SCT_LIST_free OPENSSL_MANGLER_ASM(SCT_LIST_free)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_LIST_print
#  define SCT_LIST_print OPENSSL_MANGLER(SCT_LIST_print)
# endif
#else
# ifndef _SCT_LIST_print
#  define _SCT_LIST_print OPENSSL_MANGLER_ASM(SCT_LIST_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_LIST_validate
#  define SCT_LIST_validate OPENSSL_MANGLER(SCT_LIST_validate)
# endif
#else
# ifndef _SCT_LIST_validate
#  define _SCT_LIST_validate OPENSSL_MANGLER_ASM(SCT_LIST_validate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_new
#  define SCT_new OPENSSL_MANGLER(SCT_new)
# endif
#else
# ifndef _SCT_new
#  define _SCT_new OPENSSL_MANGLER_ASM(SCT_new)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_new_from_base64
#  define SCT_new_from_base64 OPENSSL_MANGLER(SCT_new_from_base64)
# endif
#else
# ifndef _SCT_new_from_base64
#  define _SCT_new_from_base64 OPENSSL_MANGLER_ASM(SCT_new_from_base64)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_print
#  define SCT_print OPENSSL_MANGLER(SCT_print)
# endif
#else
# ifndef _SCT_print
#  define _SCT_print OPENSSL_MANGLER_ASM(SCT_print)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set0_extensions
#  define SCT_set0_extensions OPENSSL_MANGLER(SCT_set0_extensions)
# endif
#else
# ifndef _SCT_set0_extensions
#  define _SCT_set0_extensions OPENSSL_MANGLER_ASM(SCT_set0_extensions)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set0_log_id
#  define SCT_set0_log_id OPENSSL_MANGLER(SCT_set0_log_id)
# endif
#else
# ifndef _SCT_set0_log_id
#  define _SCT_set0_log_id OPENSSL_MANGLER_ASM(SCT_set0_log_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set0_signature
#  define SCT_set0_signature OPENSSL_MANGLER(SCT_set0_signature)
# endif
#else
# ifndef _SCT_set0_signature
#  define _SCT_set0_signature OPENSSL_MANGLER_ASM(SCT_set0_signature)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set1_extensions
#  define SCT_set1_extensions OPENSSL_MANGLER(SCT_set1_extensions)
# endif
#else
# ifndef _SCT_set1_extensions
#  define _SCT_set1_extensions OPENSSL_MANGLER_ASM(SCT_set1_extensions)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set1_log_id
#  define SCT_set1_log_id OPENSSL_MANGLER(SCT_set1_log_id)
# endif
#else
# ifndef _SCT_set1_log_id
#  define _SCT_set1_log_id OPENSSL_MANGLER_ASM(SCT_set1_log_id)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set1_signature
#  define SCT_set1_signature OPENSSL_MANGLER(SCT_set1_signature)
# endif
#else
# ifndef _SCT_set1_signature
#  define _SCT_set1_signature OPENSSL_MANGLER_ASM(SCT_set1_signature)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set_log_entry_type
#  define SCT_set_log_entry_type OPENSSL_MANGLER(SCT_set_log_entry_type)
# endif
#else
# ifndef _SCT_set_log_entry_type
#  define _SCT_set_log_entry_type OPENSSL_MANGLER_ASM(SCT_set_log_entry_type)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set_signature_nid
#  define SCT_set_signature_nid OPENSSL_MANGLER(SCT_set_signature_nid)
# endif
#else
# ifndef _SCT_set_signature_nid
#  define _SCT_set_signature_nid OPENSSL_MANGLER_ASM(SCT_set_signature_nid)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set_source
#  define SCT_set_source OPENSSL_MANGLER(SCT_set_source)
# endif
#else
# ifndef _SCT_set_source
#  define _SCT_set_source OPENSSL_MANGLER_ASM(SCT_set_source)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set_timestamp
#  define SCT_set_timestamp OPENSSL_MANGLER(SCT_set_timestamp)
# endif
#else
# ifndef _SCT_set_timestamp
#  define _SCT_set_timestamp OPENSSL_MANGLER_ASM(SCT_set_timestamp)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_set_version
#  define SCT_set_version OPENSSL_MANGLER(SCT_set_version)
# endif
#else
# ifndef _SCT_set_version
#  define _SCT_set_version OPENSSL_MANGLER_ASM(SCT_set_version)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_signature_is_complete
#  define SCT_signature_is_complete OPENSSL_MANGLER(SCT_signature_is_complete)
# endif
#else
# ifndef _SCT_signature_is_complete
#  define _SCT_signature_is_complete OPENSSL_MANGLER_ASM(SCT_signature_is_complete)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_validate
#  define SCT_validate OPENSSL_MANGLER(SCT_validate)
# endif
#else
# ifndef _SCT_validate
#  define _SCT_validate OPENSSL_MANGLER_ASM(SCT_validate)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SCT_validation_status_string
#  define SCT_validation_status_string OPENSSL_MANGLER(SCT_validation_status_string)
# endif
#else
# ifndef _SCT_validation_status_string
#  define _SCT_validation_status_string OPENSSL_MANGLER_ASM(SCT_validation_status_string)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SEED_cbc_encrypt
#  define SEED_cbc_encrypt OPENSSL_MANGLER(SEED_cbc_encrypt)
# endif
#else
# ifndef _SEED_cbc_encrypt
#  define _SEED_cbc_encrypt OPENSSL_MANGLER_ASM(SEED_cbc_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SEED_cfb128_encrypt
#  define SEED_cfb128_encrypt OPENSSL_MANGLER(SEED_cfb128_encrypt)
# endif
#else
# ifndef _SEED_cfb128_encrypt
#  define _SEED_cfb128_encrypt OPENSSL_MANGLER_ASM(SEED_cfb128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SEED_decrypt
#  define SEED_decrypt OPENSSL_MANGLER(SEED_decrypt)
# endif
#else
# ifndef _SEED_decrypt
#  define _SEED_decrypt OPENSSL_MANGLER_ASM(SEED_decrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SEED_ecb_encrypt
#  define SEED_ecb_encrypt OPENSSL_MANGLER(SEED_ecb_encrypt)
# endif
#else
# ifndef _SEED_ecb_encrypt
#  define _SEED_ecb_encrypt OPENSSL_MANGLER_ASM(SEED_ecb_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SEED_encrypt
#  define SEED_encrypt OPENSSL_MANGLER(SEED_encrypt)
# endif
#else
# ifndef _SEED_encrypt
#  define _SEED_encrypt OPENSSL_MANGLER_ASM(SEED_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SEED_ofb128_encrypt
#  define SEED_ofb128_encrypt OPENSSL_MANGLER(SEED_ofb128_encrypt)
# endif
#else
# ifndef _SEED_ofb128_encrypt
#  define _SEED_ofb128_encrypt OPENSSL_MANGLER_ASM(SEED_ofb128_encrypt)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SEED_set_key
#  define SEED_set_key OPENSSL_MANGLER(SEED_set_key)
# endif
#else
# ifndef _SEED_set_key
#  define _SEED_set_key OPENSSL_MANGLER_ASM(SEED_set_key)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef send_certificate_request
#  define send_certificate_request OPENSSL_MANGLER(send_certificate_request)
# endif
#else
# ifndef _send_certificate_request
#  define _send_certificate_request OPENSSL_MANGLER_ASM(send_certificate_request)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SHA1
#  define SHA1 OPENSSL_MANGLER(SHA1)
# endif
#else
# ifndef _SHA1
#  define _SHA1 OPENSSL_MANGLER_ASM(SHA1)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef sha1_block_data_order
#  define sha1_block_data_order OPENSSL_MANGLER(sha1_block_data_order)
# endif
#else
# ifndef _sha1_block_data_order
#  define _sha1_block_data_order OPENSSL_MANGLER_ASM(sha1_block_data_order)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SHA1_Final
#  define SHA1_Final OPENSSL_MANGLER(SHA1_Final)
# endif
#else
# ifndef _SHA1_Final
#  define _SHA1_Final OPENSSL_MANGLER_ASM(SHA1_Final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SHA1_Init
#  define SHA1_Init OPENSSL_MANGLER(SHA1_Init)
# endif
#else
# ifndef _SHA1_Init
#  define _SHA1_Init OPENSSL_MANGLER_ASM(SHA1_Init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef sha1_multi_block
#  define sha1_multi_block OPENSSL_MANGLER(sha1_multi_block)
# endif
#else
# ifndef _sha1_multi_block
#  define _sha1_multi_block OPENSSL_MANGLER_ASM(sha1_multi_block)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SHA1_Transform
#  define SHA1_Transform OPENSSL_MANGLER(SHA1_Transform)
# endif
#else
# ifndef _SHA1_Transform
#  define _SHA1_Transform OPENSSL_MANGLER_ASM(SHA1_Transform)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SHA1_Update
#  define SHA1_Update OPENSSL_MANGLER(SHA1_Update)
# endif
#else
# ifndef _SHA1_Update
#  define _SHA1_Update OPENSSL_MANGLER_ASM(SHA1_Update)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SHA224
#  define SHA224 OPENSSL_MANGLER(SHA224)
# endif
#else
# ifndef _SHA224
#  define _SHA224 OPENSSL_MANGLER_ASM(SHA224)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SHA224_Final
#  define SHA224_Final OPENSSL_MANGLER(SHA224_Final)
# endif
#else
# ifndef _SHA224_Final
#  define _SHA224_Final OPENSSL_MANGLER_ASM(SHA224_Final)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SHA224_Init
#  define SHA224_Init OPENSSL_MANGLER(SHA224_Init)
# endif
#else
# ifndef _SHA224_Init
#  define _SHA224_Init OPENSSL_MANGLER_ASM(SHA224_Init)
# endif
#endif
#ifndef OPENSSL_MANGLE_ASM
# ifndef SHA224_Update
#  define SHA224_Update OPENSSL_MANGLER(SHA224_Update)
# endif
#else
# ifndef _SHA224_Update
#  define _SHA224_Update OPENSSL_MANGLER_ASM(SHA224_Update)
# endif
#endif
#