.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XErrorEvent __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XErrorEvent \- X error event structure
.SH STRUCTURES
The
.B XErrorEvent
structure contains:
.LP
.EX
typedef struct {
        int type;
        Display *display;       /\&* Display the event was read from */
        XID resourceid;         /\&* resource id */
        unsigned long serial;           /\&* serial number of failed request */
        unsigned char error_code;       /\&* error code of failed request */
        unsigned char request_code;     /\&* Major op-code of failed request */
        unsigned char minor_code;       /\&* Minor op-code of failed request */
} XErrorEvent;
.EE
.LP
When you receive this event,
the structure members are set as follows.
.LP
The serial member is the number of requests, starting from one,
sent over the network connection since it was opened.
It is the number that was the value of
.B NextRequest
immediately before the failing call was made.
The request_code member is a protocol request
of the procedure that failed, as defined in
.hN X11/Xproto.h .
.SH "SEE ALSO"
AllPlanes(__libmansuffix__),
XAnyEvent(__libmansuffix__),
XButtonEvent(__libmansuffix__),
XCreateWindowEvent(__libmansuffix__),
XCirculateEvent(__libmansuffix__),
XCirculateRequestEvent(__libmansuffix__),
XColormapEvent(__libmansuffix__),
XConfigureEvent(__libmansuffix__),
XConfigureRequestEvent(__libmansuffix__),
XCrossingEvent(__libmansuffix__),
XDestroyWindowEvent(__libmansuffix__),
XExposeEvent(__libmansuffix__),
XFocusChangeEvent(__libmansuffix__),
XGraphicsExposeEvent(__libmansuffix__),
XGravityEvent(__libmansuffix__),
XKeymapEvent(__libmansuffix__),
XMapEvent(__libmansuffix__),
XMapRequestEvent(__libmansuffix__),
XPropertyEvent(__libmansuffix__),
XReparentEvent(__libmansuffix__),
XResizeRequestEvent(__libmansuffix__),
XSelectionClearEvent(__libmansuffix__),
XSelectionEvent(__libmansuffix__),
XSelectionRequestEvent(__libmansuffix__),
XUnmapEvent(__libmansuffix__),
XVisibilityEvent(__libmansuffix__)
.br
\fI\*(xL\fP
