// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright 2013 Freescale Semiconductor, Inc.
 */

#include <common.h>
#include <asm/fsl_law.h>
#include <asm/mmu.h>

struct law_entry law_table[] = {
	SET_LAW(CONFIG_SYS_FLASH_BASE_PHYS, LAW_SIZE_128M, LAW_TRGT_IF_IFC),
#ifdef CONFIG_SYS_NAND_BASE_PHYS
	SET_LAW(CONFIG_SYS_NAND_BASE_PHYS, LAW_SIZE_1M, LAW_TRGT_IF_IFC),
#endif
#ifdef CONFIG_SYS_FPGA_BASE_PHYS
	SET_LAW(CONFIG_SYS_FPGA_BASE_PHYS, LAW_SIZE_128K, LAW_TRGT_IF_IFC),
#endif
	SET_LAW(CONFIG_SYS_FSL_DSP_CCSRBAR_PHYS, LAW_SIZE_1M,
		LAW_TRGT_IF_DSP_CCSR),
	SET_LAW(CONFIG_SYS_FSL_DSP_M2_RAM_ADDR, LAW_SIZE_32M,
		LAW_TRGT_IF_OCN_DSP),
	SET_LAW(CONFIG_SYS_FSL_DSP_M3_RAM_ADDR, LAW_SIZE_32K,
		LAW_TRGT_IF_CLASS_DSP),
	SET_LAW(CONFIG_SYS_FSL_DSP_DDR_ADDR, LAW_SIZE_1G,
		LAW_TRGT_IF_CLASS_DSP)
};

int num_law_entries = ARRAY_SIZE(law_table);
