// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 4>, 1940-28> hypergeometric_1f1_log_large = {{
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.9593959799337045441231095099600453103878e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0582258691183834437184100780924111277717e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0582212874515755553724818579796784832664e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.9574149633794303296795697435669509532339e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.5365868980518306877426325650129086036134e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1263597163510461091564343966862565600099e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4899155395354251118264154347628839762201e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.8014924418775372394452266218419172086805e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.3601188072886026892294335398347446361629e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.1442638453195546024831277675559540925800e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.2705063685863930607059424121647261285932e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.4653030834187445289887912010642921687059e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4667942166993414566851048815646988705343e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.6811928208212602610232334793139126086032e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.2535739349225744116204404872743811674123e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.9884411322421406543220299815241863666200e+04) }, 
//      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.2173743826070611351476246204795205014058e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.8812444400980156264194884337206672427368e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4122829105577151955720457330693213991686e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.3350488432729208737617762126187833143447e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.9315059714198800733559247394139943621332e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.2962859950984991277505912653511530358472e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.6451883044251207442979205220622268256681e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-7.8777341079034961012522557950365404618892e-03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.8777812524954860485779724063911403501367e-03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.5811375691008701038212122527126205544763e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4036645107845055757622227533208858328428e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.2684672066548641093865671757183336966327e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8672528027786132575129252827421985309205e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7966582294270006650134203350312433159350e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.3066710140814696310034102523994933251096e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-5.1085699856338638054227888422378369261644e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(5.2576035718103634010077413587813594716910e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3084652240107516168752185930481856725686e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4034608723519740587945535708924247807100e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.2667331163815573631854547169267233190242e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8655545577502157066597016484644555907601e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7818683734210362560969869678355888318128e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.1983650107041942684890512664106782056025e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.6662940172882741467331240653979561393709e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-6.6145209583603108406630622970203632008997e-02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.2040068693012884349997501508349193170101e-02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0735315085887577734528177162853975227487e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.1725930715590605578045566845971888647110e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4034770492284450582297792026919584845838e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.2668948853769030935531372734184975176914e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8657163267729088954734540832831871085132e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7834860653206817377634787979148540325541e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.2145419598916191301311735593249170065821e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.2839994206824479531609491346289350096553e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3428281939731632310734104110655608091449e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3428283575481742446927724187155197985413e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.6912394646183420710295179060464823704913e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.7902830371327252839360765273179516740398e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4035199145907586702392206896333979862975e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.2673235390000392353901568161880851345435e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8661449803960450398885865762594130257924e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7877726015520433396056760184418710240062e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.2574073222052379947310081571561831584053e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.5705356520453228271753500890895355114117e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.6293645726254600398625719679453662080746e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3428281461476157746282434885661721649743e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3428284066897885058699471181707886230203e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.6293644416220753778517718667044905591926e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.9777756959814575816096647861358299969781e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.0768192684941447823726666210885118934530e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4035199145910423054384056374265323842954e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.2673235390028755873820062941194291250461e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8661449803988813918804360541907570175427e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7877726015804068595241707977553110178307e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.2574073224888731939159559502905844741826e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.5705356804088427456701294025301454751955e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.6293646009889799583573513526730608447192e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3428284690894375224686134747442592112317e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3428281404749063318032904709349294762479e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.6293644699855952963465511088581277750102e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.9777757243449775001044440995765564273190e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.0768192968576647008674459345284174647753e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4034770492284450205091151308471253393220e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.2668948853769027598317059016805512091180e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8657163267729085669082486119585173843382e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7834860653206787674931686661976702667003e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.2145419598915951197837970272750443972553e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.2839994206820237464851782402053744398918e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3428284885513659531533631674888464431647e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3428280629695856149440005049842231368575e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.6912394646183991374852375948365969768772e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.7902830371293903261046813042400927905120e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4034608719521006184327426649818276035457e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.2667331128440944173420844622885957636869e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8655545542674476760169505786016862825793e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7818683419387830331352160634743319351440e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.1983647562636002378798444131989070969175e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.6662895425279861986761183179794469896277e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.2040162556117614311870586052020226413155e-02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-6.6145137118803186408649179139925760356511e-02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0735321389564527041440680892607853797567e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.1725577208653375819920340612639444215877e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.4032350477426018292385467078228915938297e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.2647771519401991944060924882687402378687e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8636344351721170008373623530206000584476e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7648593118427750966214815654093901364739e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.0678227699458071016707034918967280594572e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(5.1152440426590660496475270893536160386256e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-5.2492855423064007573310319109590430975421e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0805564394195876009313586645409530492527e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.3946083869918519768081015583092863307072e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.1980578264100887837194248703838859832533e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.7992287843047201679079311350398859211449e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.2618369776382643503159241119565708798346e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.5047235529916621751807001744193892843336e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.8777371423373268811623593841699375878747e-03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-7.8777843602130632332817590426692674655198e-03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.5652207023887323339878432183024771406937e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.3398408351833744051919806933165401658056e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.8429265483413881768193943578559394321796e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.4664489959845195811765650332262828703862e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.2457217586357507203034019486306101695250e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.2076218655028246422770476189419429582453e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-9.8941959393827091954198005329591158802716e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.3164001695252038526756790117605552896855e+06) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.7114228907147978217784745054491448642006e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3465532964390320460932256893151762215297e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.6894701913874227794303974505023554115132e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.2658354378514113555440777111456527771575e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-6.4706034211773560260615095038415487109554e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(4.4888278387748521035587954811383741831108e+05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1162112292700804958994332854791286035774e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(7.4908151188231705631820190372551322249192e+03) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.9534596929235180907807581074152758935507e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0582121243719264742962585647715777541917e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0582350326741118464400760745232890382650e+01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-6.9633647860006720149643557974549286666070e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-7.6074007868155125835105868885216259578003e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-1.8903062533920746861283999531057009271355e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.2609553001658686771094015797409676938057e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.1575733166445825071936223207743601811006e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.7596873730275691850143173375585878663459e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.7596647704073782842737809456598714434501e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1565960264161084997962270178143407841891e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.2494543828895425926785480211508399042921e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.8645778952454604446801030438124818331591e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.0172863108952521067061573566194454438765e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0583612175805900873603497586071772608639e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0580856746901949468323381258222955413699e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.8981648139193646642847839685835289697112e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(6.7812354503964070441656274525071610293073e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1065943737139995640366916421567260393940e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0461093640383330461162304442125547697384e+06) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.6276328411191251563812127884221935344014e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0814328854028562257166910255384988367975e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0408609294124590908754532904077174171736e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0406297098043571068390870623885476448842e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1253474682169395218438259369613133450702e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6881859103433813015786227286847036112804e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0185739194261929981965786654930929600154e+06) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.6976232940358311017299449900303045197094e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.3442870318453547791621746670517156719296e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.3389542354644908841605401369805103353642e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9962758750935854786688366779961780448550e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.8490935976134840786749538028292081747381e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(3.1208224553596172473223146755896186985972e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.7541293815867675976992881485024143056278e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2811899042890053731628366050539210559067e+04) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.5614583192913363758190807218566099668686e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.3477497020036341946094260405020789967123e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.0084541008347548191027199552677120542429e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.1435227705618398123892090475401200228823e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0013260561787848331417507878904465718358e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-8.6116595166007446255517395685390363986316e-03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.6157621823448408592053856579478328806030e-03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.0911565784280736462144468040780361309688e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.4563462545793015147123963600034186977927e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.8077175248365050773213821419987568092213e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.6185363879133932980601718369078377243121e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4674756699732914480964181735648918343295e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.3351907154583999069487881726596507417210e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.9961055745900359049646016686585465736921e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.0369655292585308819370178819653443692420e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.3251564975079028595503024571045682562160e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.4125092595971393626883203153126641757564e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.0648798938170336913675549397368390513091e-03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0637467104863084340784067172307861841772e-03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.2485610403145674706043449357369358826979e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9574181685789914372016309274541230620348e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.3359280785551537871334950002460135328376e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.6765362900083731555100786487189795762283e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.4827221968353536688123576542580986092446e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4653190213477956872601716084177933239422e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.3368084090592131857505754357725903834195e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.9977232683513510737647524994011936643019e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.0531424797754846622118777981713622976195e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.4869262893686437913551722086072848714632e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5589666339672174193391728767096666924301e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.3315622986132955878021079501682541275100e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.3317390551100478342760444624544332880134e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5425542562033408338415838457323994943036e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.5751325854245561435029588930574380273298e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.4977016351336312186985299039339639753112e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.6927132217025799180949177824087399258927e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.4988991303248740401568791091893341426362e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4654807900207498519290118195194404978877e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.3410949452905749479660934634872839621787e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.0020098045827128511111830331498963865779e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.0960078420891036521497111873361220368491e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9155799125048607178264411073095180426344e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.8455028653310637030012563825541402822893e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.2197013192055545374382090573993408544069e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.3315622777159825398579745498817306997393e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.3317390891646913749973064447937659610511e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.2197012796740213302052701781750806024120e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.8290904875655320729007708104624925694138e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.8616688167882806070567590396338410966961e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.9263552582702029761445671147547353874973e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.7355785840161971335535852073139254922519e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.5417644926384914248653947454759484775802e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4659094436438859633733763292247146918226e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.3410949453189384678845882428007240336228e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.0020098046110763710296778124633364653454e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.0960078423727388513346589804705234132891e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9155799153412127096759190386535448879743e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.8455028936945836214960356959952204021230e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.2197013475690744559329926578563352489146e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.3317397131068343879822240554189746625795e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.3315622209839465737498420367793696150920e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.2197013080375412487000452045978167251869e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.8290905159290519913955501239027716582564e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.8616688451518005255515383530748622563773e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.9263552611065549679940450460989339687571e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.7355785842998323327385330004483260098553e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.5417644929221266240503425386103490770994e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4659094436467223153652258071560586676152e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.3368084090592105362269069184307474878432e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.9977232683513484545029089941273680798775e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.0531424797754609025404988487884130360672e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.4869262893684602488272527288693852062933e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5589666339687360319587610727437134918689e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.3317394503903675942330561736703599752363e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.3315619032629450000562501708572310512773e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5425542562015493572553766398462640643374e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.5751325854258311159059616957430509732647e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.4977016351341573381201322831191497106473e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.6927132217025526094652069022493522450980e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.4988991303248470700268646520129243326805e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4654807900207494574222703816528674210724e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.3351906873784821717660821574274152116033e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.9961055468311219397521705459559785384451e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.0369652774769945992662149741327116569522e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.3251545530749265884750516666768132856454e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.4126705974894306604963337038769158890297e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0637473969192326056276266335438364309424e-03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.0648797393376025407443690725015228189317e-03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.2483712588951991598481168390225958236624e+00) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9574317179431314326387688794115552410565e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.3359336618960235047824251206473883950441e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.6765360005810900099738046688950483479402e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.4827219109987223978285057973154810527953e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4653190171655496299468839490654159421025e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.3204101324920599540219239452122155013582e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.9815352621133728171392005292189168709269e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.9081597034095053029965975115432608668507e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.4111474513277911456202155867600186676514e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.6118621625103810182628122138420006003038e-03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-8.6155656967287933750579283433397016104901e-03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.0020937043668339176856893748101120848602e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.0496088844469587096936584224160462644145e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.5215191446306070569418610469740248412330e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.3246472600608458211053891736232676514783e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4629405159202272395915678225516122681401e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.9567791289089990895859340190784082234120e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.6311233790167542724477983148006062881427e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.4343938079097819173295177231642590389730e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6079813250355743637101336562662965283128e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.8798386031347006009776317904365997797302e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-2.1352770581470566419047825175307674285236e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5092209359301647591137150788784586315459e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.0663127740978073902423675205408771970579e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.3688973133492566757820217207352000341097e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.4696906853698710756196246034706706167904e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(7.1870527384983751693330321668954952073930e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.7108817497797272651990324922323580863007e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5809163354333361245025123117554592243621e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.5846089865174225306224931506778184831590e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-1.1363106314951888085744554882140050456615e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-9.2982685702883444565240240486490404888157e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-9.2269048048312161902882978295973344690932e+03) }, 
//      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(8.7446277169203106109796924659555060713845e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(7.4643423619690237380330178300519873127784e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.5251201196605473483488354263995529656178e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.6820965032055220575255852619602393583994e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0575359222514770500137462964863340959533e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0589135051907528630345084631785253913251e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-7.2829794577290606571225769929589533741880e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-9.9535969483556259158101342984793298586539e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.1237767020061769923407514937429180256063e+04) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(8.4692913040072063294366133860496897022010e+05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(8.1963032753979578545375977649038020620337e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.8642973569427972926346946101188329668389e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2493282622067423686933389336596567816438e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1565850905068456397909885025269284840093e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.7596645170576014848524716448385029566330e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.7596876263905091046818491827979784241842e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-1.1575842899783802478189242310645197384822e+01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-1.2610861907896063613977763044638238902876e+02) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.8906027816235478264270947059645453764045e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-1.2638814969710316649840174616683798631037e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-8.4308251908266468324221086902553071353522e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.7394854618574254773521745192989232593127e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.1765175973040774983167797046977764514579e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1765024291712268156581287844762277378574e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.7329270770368054544807320708818763374254e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.3536449566905569125499483228055461167397e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2466157186318269399182602567853821674240e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-5.8276939427334213289314285876569282975823e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.7188038370490528622537384346925413318708e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-7.0767572971367395783535586939567342230079e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.0736939592562238586264119418123176909547e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.5863926029309692593730958909742787957376e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.3213339526565873142158158522696884482121e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3576497813330950012223458394390727768914e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0663364173073525488865048050113635302561e+06) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-4.6738682928393179513504563135798006995078e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.0459581513638073883997020215990661012865e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0584297870471158944061538821995346193268e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0580176545257645918406145763572854813091e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.8678191922748482625709948917758723112048e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.3980421899006645669263620029326309640101e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6149646664917395180458582356635369330235e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0387707861070239395426234331949072187178e+06) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.1339295177631736126177736603365153688590e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8702553979505331342123101532493512643289e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.6390244570913100984074048108295608634389e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.1070344114568050626675875928453912953451e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1994938742388302371001408419122042700613e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.8539107292078155598912839592965527008891e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.4868441914378531732003002649646749947508e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2545257038406916920676683026037191560956e+04) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.7628686898533426371240091663512627579803e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.8250089490507847984689800289225331266998e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5735518552067661231551067831410018050408e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7731022022148143288029540043945687306144e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.2817812185905433463315622420470482642233e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-5.7581644515407733543192831568367354326801e-03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(5.7599965655705774731647007887852470206998e-03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.6928198162705353651412842815908589090756e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.4158991854806403521640629575085742371523e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.8038177047666059260832760991845660962737e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.6145826227916685270735812942311433309859e+03) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.6688298171828874375273861390044247551743e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.8130357202982435508555543955902033061751e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5617604985978238342493495043055199499927e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.6709716058369547607723092910834364060518e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.6332633455924304780399493192833465861844e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.9832998059318078967684299481243183857524e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8738580549256539603908681801823668620739e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.0532997628187529203748061454024054928742e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.3602152593836783589328881487206443302319e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.6760553309863962495764191726227357980340e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.4825968022807509033276019997005777063563e+03) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.6666722997531120601011487507105430010096e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.8146534143454728340648175595151439162166e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5633781927837388262996400955484923247569e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.6871485597242159888613126651267658477535e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.7950331672966654940953047573272468795503e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5160501043367002551467530895945819801243e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.9289410846214999607877225603190059550910e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.9292056558879731054024215312484742801242e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5050795396364521305975080076625270385754e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.6709926372351799873202198980035010014129e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.5219850189355855321598854060406478922352e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.6922322489089245669872666464569232878444e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.4987737405533374081701033685281280563193e+03) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.6668340684254033486118530729317141358950e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.8189399505768346383650830044366877194462e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5676647290151006436741523681461050250157e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7300139220378352965264142364790851510213e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.2236867904328852339869880700747170305190e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.8025863357009627784595013315760446267588e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.1794435887729961707466533290538557511338e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.9289410662866453370231331881284008153238e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.9292056873784257107885052485836011398860e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.1794435497540701553616896412083789602985e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7916157709982268224469000881162177926773e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.9575288685968737079150328038926157749545e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.9506386420717994123183379757940617110765e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.7350976112225404841456538352477011342444e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.5416391028669552437919373011622555717018e+03) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.6672627220485394599937265979219498580831e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.8189399506051981582835777837501278112592e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5676647290434641635926471474595451231565e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7300139223214704957113620296134866812393e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.2236867932692372258364660014187452375365e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.8025863640644826969542806450173262039183e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.1794436171365160892414390544756858810006e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.9292063112931782882630561196455592376727e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.9289410095521182313565929361573299532087e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.1794435781175900738564625426654721846577e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7916157993617467409416794015562952753373e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.9575288969603936264098121173326540680457e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.9506386449081514041678159071380870820206e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.7350976115061756833306016283821010234789e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.5416391031505904429768850942966563894603e+03) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.6672627220513758119855760758532938338455e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.8146534143454702687106438765869947408412e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5633781927837362870939600679724799078147e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.6871485597241928646444700801188399782796e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.7950331672964875784082141056749529302595e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5160501043390513470676626946263239185345e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.9292060460255475497226557987690236467054e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.9289406943805404008732701075175959011922e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5050795396338275595917018465834220539942e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.6709926372323934738052699811814602136321e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.5219850189353958970063331781555740347439e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.6922322489088946617569952922043022324959e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.4987737405533113398667255043810837572272e+03) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.6668340684254029539801296656350641154670e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.8130356931111577961487669936175360054117e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5617604716881094885393601140829521249646e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.6709713607960331547223556428151693514096e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.6332614608464399838034102129821021920023e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.9835494494688857782383791741172627111652e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8735799026122535492229677133529181552607e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.0532702297745956231819997846067831841989e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.3602132503228816822139729580079618337777e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.6760550140155472801286154518958981912894e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.4825965260102892236838169222637406213687e+03) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.6666722955695402505125318558322967174190e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.7988395912191276666146562502760141523523e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5477460404636386331184408080465140908756e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.5465738949613222794078786156813718944154e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.7578993823849587756879549103095932628516e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(5.7582546410907238667559567199825433500169e-03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-5.7599107698245917238918307615895686776180e-03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-6.6774109432553689589987281641245377912099e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.0866478722856343885154097901036164366811e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.5259734408698826747726600604310653358982e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.3283830421851869972852648105178468739155e+03) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.6642929255030913499877606007957533590963e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.4704830053921645780528175979570308328643e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2307356728749403280495514767741148944302e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.3219971466701816909360464304273868929526e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0947259121957699521408882115522835321208e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.2174096898541808004225816340808445617087e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-1.8966754567654375690136501877498420432189e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.7483362526873749265619493848674863465632e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.3049506686095957577244894513893237880195e+03) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.5701934252716927944192865356541742242546e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(6.5980147300684640325716090056660622359850e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.9906391449800141957448904440850986528089e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.5589515601334660666810511048575929945294e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0571954611668971019632005887532108258760e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0592558312571056963267374777199953689487e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-7.4677839603926180962973058873932477412260e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-7.5139629335324152773214431562646789886707e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-7.4437537775129101396720831867884951574880e+03) }, 
//      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(8.9453568573877958811748820220257536989124e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(5.1336934105341230724907088533279308250536e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.7864321053166665209629226648841863592624e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.4899417712697023561311720160444196741632e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.0712374541608634870682009492863262024270e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.0792269376674272643103509651889515557042e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-4.8373355288752205103671375193050084987644e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-7.6330335285715404484016468741912580404894e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-8.9153955295195592811443604148981913127716e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(8.6697077528325031342648056157543989156436e+05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(5.4834171056907655349454029370800137331409e+03) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.2464903173259825953254178996483254954526e+02) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.3530821449169230482398556892204721898901e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.7328781932540296951650090623521690170298e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1765023159232548425836870411363338124813e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.1765177105579334184801723881705054954349e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-7.7395345129287915334762022606979596014764e+00) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-8.4314093065704983879571465843787022197972e+01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.2640140458136842808205832511251401584144e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-1.1651702237957846978437095929522769722046e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-7.7722392305233156163273698171334923537211e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.1346995218029684068631662684697176201840e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0845780119181055754536445632915345337710e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0845639343204117134467163453926892235009e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.1286126616034593433214697360723051938122e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.7006078980028637549862094844300192569217e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1491457425577775831220731169484436663701e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.3978477137514915390051849319048559730337e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.5247719860983706470457212333338623569042e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.5198864325915525062433140247937504195751e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.1863826286054408682067208958200729169975e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5896684852912972631663997202242695188555e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.9552444923747056021540518513273527916381e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1114810410382339280011947176235586934714e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.6568015416459281207649530490615799273231e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.7606351084451453953707156126870867167723e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.7499377840039089957295925794230100348281e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.1932985453385296542110044542859687163822e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.8777731842916992566792545060730925219427e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.9687584826392103934337329108908264193867e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0838611488561233291346172282548249273203e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.1838801159263990760168834991101912383408e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.4174751939524078970323287706748940838898e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0604537975420346328179257066259577918969e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0559799045050335319042839494105073876325e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.7758637244900296574505966434333476658181e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.2285324999613339523330606533959697455196e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.8076150310984230975713153266266832366662e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0212769070587652295698269096028648246092e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.4803993063100406867495449984167590384637e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.1620595803487435526643900337576888954388e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5238763548004441479905694040934257311411e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.7525823909152635816716144920929184289188e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.3499048349313726397793230776898614603274e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.1850852451632062828560146860794913263691e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.5166049099290720258872301595887078103954e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3777489302725929499110265327278209865076e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0118629187685830944653872355334771503798e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.4009443002395871765213576982316968427262e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.0829993707601562738067124388314717317866e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4516118161207362251209781849851301507979e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.3474480643499445761036397123011644642648e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.5487355960314042704620791631075728378398e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.5415088364532706207641180890654874165698e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.7822759799424528842205862997520225112603e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.3595845979703430496195265983601105191316e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.3879747822777777655906903708435261100591e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3640616598891887926656521378373117915344e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0116470109404020991882516641243894622691e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.4171212712912479309872653999691861767461e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.0991763421126761187092405843307900439395e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4677887926364627944339568638603517675477e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.5092180667156829349416836595602375247792e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.2727242956505740448776448550585966352955e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.5436823840427653795997332626706727414570e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.5465562274854733479679308458040874333932e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.2717142091457597680197933839775232348651e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.4000222819998180529187372407793653177318e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.5213542766876986750765382434542624039139e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.4041517159791526990362843528858540837763e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3656793526303675012775259771532263624799e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0116631878075121389299033164879384325853e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.4599866336048688567830069588404442785960e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.1420417044262970728677171336127731172269e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5106541549500842353407762272727173953673e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.9378716898519197062424275428410198834312e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.5592605270271401428084053145927446212513e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.9410482842167131205128095691501631238427e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.5436823703848439786578674329888809610826e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.5465562542475074267655999868311602338152e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.9410482461366133588436361353484229349489e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.5582504404952307805641660460299971249851e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.6865585133665475294861475496534790982763e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.9500078998239049351438195338965606556359e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.4470170782927701037276632127770256979595e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3699658888617291824531543228030314412142e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0117060531698257500568638423390662538208e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.4599866338885040559679547519748465919788e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.1420417047099322720526649267471754443371e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5106541552337194345257240204071199580606e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.9378716926882716980919054741850563335416e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.5592605553906600613031846280399810497499e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.9410483125802330390076584378363306768819e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.5465568773494500662310993036307672944357e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.5436823135761927702973079301215728336000e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.9410482745001332773383458935171939108905e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.5582504688587506990589453594641197056373e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.6865585417300674479809268630959546650160e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.9500079026602569269932974652405823385046e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.4470170785764053029126110059114263071504e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3699658888900927023716491021164714734356e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0117060531701093852560487901322006513916e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.4171212712912280430317027899973067461266e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.0991763421126562874791479551803557221690e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4677887926364439367005498629703899251365e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.5092180667155390820727141489068259723741e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.2727242956775322860327758291298152194081e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.5465566077400029468400219922946962397075e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.5436820026937268140659215084257850674559e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.2717142091185278384021116812190508072938e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.4000222820071030513487935178611567414568e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.5213542766874937997406435291818936175519e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.4041517159791257688719963449560710874383e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3656793526303646896740780956816228245864e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0116631878075120994442773224624819285549e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.4009440895274633566767916007364646438154e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.0829991606497506157028146013327407775857e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4516116163367436639013571511144468156346e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.3474465409269419828830682599802434841052e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.5515954567526480745884730516569532811935e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.5386204446874440392102482395160272221010e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.7823532809542241999500493951257204568454e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.3595824272485761523379426945736733719613e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.3879744968650848667555858506930900460177e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3640616300900019720564109585905064174030e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0116470105218067400179080094675836867651e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.2988680640311671152902311123751332439910e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.9813169944348666065828137128484806383195e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3566685088958668472487211710236165950195e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.7023798986956277580811073457063570540454e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-4.5397951894602846196554273896591941553618e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.3096039067704057611139923487410453957789e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.2371623997167915231062003499971508853735e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3481559612499126012154275664181227168984e+04) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0114089174270285880422578593391287110780e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.0385012633119693924884311962956470094538e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.7446006891628068623369249013500515954339e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.6011692360493044468184003108476595729024e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0472706997418258448789125030388706323737e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0696164044932225481341666409628441410159e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-6.9458986819567355895654652249816591104270e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.4769476590221575069998336426419324412410e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.1825238968056248408613057551352869669930e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0019888534494974850015886264993789175804e+06) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(6.6810780461533682957673926496665503509981e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.0095961460706323414415571960985813968967e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.1672108332460751605328891210535371802736e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.7492398321707210204905925082787226253792e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-9.7613363295109393353810328155445170573053e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-6.6922962858522957704307634210474346658510e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-1.4899802423414240247914277630105611450750e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.4166954195579510120894580931823145948207e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.3940336230568530416052312913930523302166e+05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(5.0264530774267597116522696927112443633679e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.6763345871174751554587674548012443301501e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.1782053474284569816607115201074655402262e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.5196801768098790707256445371361356451170e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-6.5249839101040405687434310207991685158519e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-4.4078955546914151805045659447619631338137e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-7.1189737470524892820947817031820473860682e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.5992848307948454961755884037395645114133e+03) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.1178230698811499534007612530540430488337e+05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(5.0606978483116952040341968163802871639421e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1491350973467299773988025432011470637811e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(7.7005625223699098208504548518340367840865e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.1286085119002805229405266866554908469560e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0845639247068866819947030186262949165854e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0845780215321300902276171667813094357112e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-7.1347036857071350201191350265408451302018e-01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-7.7722863697269246624174413609880024833022e+00) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.1651814757551788321429509771169415570043e+01) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(-1.5034166023763132050649100385374414015408e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-1.7719818335355664138243474147144550572227e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.1819942192165796484680474460455957788611e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0850347127639626503365502133339982893420e-02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0841084089020338116912179574438080979799e-02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1710932972955344627683974621694729159245e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7475956259604468135893122489461505301975e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.6956895080103300485234575577243539018964e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.9229323634832400023605079387721312728457e-03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9151889542877303066577645046609771356367e-03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.3604397093389757955576938035133682334466e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9640978529003092404870082230359303360605e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3432369792569959362229126222040261764301e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1181106838270605489267288142225688844813e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0149982223666849228522163653861371278640e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.4844353166264191956628373368104920019678e-02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.4827035762057490135919753821493491553638e-02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.3990059479491498086259607351635994753859e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.2319638871096856079884444683808948684410e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3399254614095181473403664256065937630215e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0904854362429270418024600077088132765793e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-2.1565956496640453127488558117592995927360e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.6195168025200260888405482669388370028290e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5993105410736343618946240142122667344864e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.9859790648482779341959941153756147409462e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5229600401289351307372207431333966351388e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.1341404238462620281623374478897713279230e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0278912947450121557841844380993350585226e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.8066811889929908468854448320090441986325e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7712760021336105127126944558797025285622e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.8713045274325864698665585510123672881730e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1004947730756507541883359925970855871569e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0717834799576254545184373039256235337251e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1365633686010714910334792867016374508405e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6980418897738927856102415400703780063871e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184763098694996597731650799771776036346e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1045884826203854134050923447544707025712e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.0313436534423249110836514890480377340829e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.2993534514155370419187987169301934483907e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.2599893306287293700588324483592276293950e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.4494076521471275151348133956191619336410e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9706427155465868439422292801947462779637e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.8722311852215661985266612516182317883713e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1235434268918521900568233127087449356371e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6842543531645145964117602349303648924721e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0182603866418847413350302181097623636183e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2663588006661232048087709298957665817943e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.6490468496634158372210480634877415872402e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.9170572631124957762937842378162916092794e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.8536324227458590712066071617513046355551e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(2.2599112372958360371450572348357756990042e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(2.4494724210432741371848385586756515110319e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.8536182263895558711046965686533525429203e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.5883446009256918217694026555535170164418e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0034000858478836519346807127575966552529e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1251611201421325229417342945482210686057e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6858720458291439958523114319094244363833e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0182765635089830316959692004118812627420e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.6950124238023897360408371881118413438650e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3935583081026082635626146625614673675031e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.2035934944752205971290749609260994925718e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.1401686549997387838861949037502439489090e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.5224539304031988296491480957039500537906e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(2.2599112227526664519430902435744382457651e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(2.4494724451009430617314954081752148557425e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.5224538924169838086455386944629221705067e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.1401544568617236361048214462833051799692e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.8748808322882350423336885566828078564761e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0462654481615042264773919376650736751691e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1294476563734942521116394410939987949793e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6901585820605056698114459378253858949296e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183194288712966428218220829098507665984e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.6950124266387417278903151194558921975915e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3935583109389602554120925939055182931552e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.2035935228387405156238542743666368315776e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.1401686833632587023809742176220945478827e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.5224539587667187481485010500951391577202e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(2.4494730152229785250312837535004640148798e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(2.2599111601056387681414483701130892220720e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.5224539207805037271357443652158048917454e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.1401544852252435545996007592928186039667e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.8748808606517549608284678701232573021135e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0462654484451394256623397307994758185477e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1294476564018577720301342204074388504296e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6901585820888691897299407171388259236583e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183194288715802780210070307029851641687e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2663588006660388718024461676686322892118e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.6490468496625754793266724011466930637304e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.9170572631117714632597928953259948972696e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.8536324245274445339260926637932880268175e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(2.4494727681084642961916828107668566520009e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(2.2599108177913593943949896583110682847362e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.8536182246077174384630027433778241276238e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.5883446009246043081934013873943567351161e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0034000858478630614730574348604336713795e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1251611201421298073268400148685621895923e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6858720458291411698158758709701329838336e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0182765635089829922081279196801081239515e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1045875905571996673583213661782192883083e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.0313347643378922674260685205329038067773e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.2993457932625640074809718376642299097054e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.4495376036939832227527963883075557026134e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.2598328085540831962214422529450603380149e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9706312047263275276969225150661127215803e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.8722290035816584183742218400443504738197e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1235433981108685864670886163096484344004e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6842543232122291621136202660906850661674e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0182603862232658834039869331622281462550e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(7.7887038099534183032269182598020135420758e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.7946254793497018378658276744560592485238e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.0545219505710237921716292091232513310276e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.1158569281580729735475742128274042946750e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.8048203460920393307151549914103145994031e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1083049301755794940444695337060413130887e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6682482585270628712315333641737738071071e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0180222777287713432103371748679612589221e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.9242283519976884052231645726513604437548e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.6849257724221925593586038399598954708172e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5991254023144661679522940811318667086258e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.6197128560161325836169504442988015401836e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-2.5074889225748107597520144182499027956283e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.2131729295087229468992254140132382976841e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2315493689619638629467949218275891686238e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0086012159185970655661894610544664827340e+06) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0275705303189436576402310559453624209914e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(7.6960000014040428314638387644286344707537e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.3984494656281543427806423595523041493151e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.4827020873254157415751042397309203135993e-02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.4844368124807859955569848731266194105355e-02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-1.0150739347571823690853737857286312522114e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-2.2893329620200821752380597279298500448151e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.7047121643103776906794831333677901132809e+02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4600567945467350851641108286597070316540e+05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(7.6963733269680416426478711978632673167203e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.6233377746076934324080801792101558569937e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.3602676236586502335635122791449730897404e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9151883113111623895831621776703364437356e-03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-9.9229406470486749171721196500717526633346e-03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-6.6959064533079627208295540550482561778062e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-1.0349532315171132181606724930608515092997e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-2.2845996416791704100181772009625075840166e+01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.1837908702403161228304665075544338441095e+05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(7.6971158370380668747384085904590281547921e+00) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.7475953988753508751677984101599985332293e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1710935970305240801607657537140859731696e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0841084000498303138967465172889795788864e-02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-1.0850347216464598892815478672340259731992e-02) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-1.1819939158273786732596168838270905306429e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.7719820735639009564318537705295306686602e-01) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(-2.2754503295287028449916525041377235112612e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9740600430738959957873018285440094194417e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3534065281162917736076437591511019066448e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1182546426933341160471448215881147831154e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.2416220566907442599807314888248836290945e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3498417123919685992930105162491766820855e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0906293125064100099526531251390381804362e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.0522402803045637385955858111824537470189e+03) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5317493832946370348800540285205430541553e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.1433987483538686974873637420243062737745e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0280350183163842845461959948670838246683e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9742550463137742895078347181241423982551e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1281501362008962165026083092181638907023e+03) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1452213823587793026197741493915416651300e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7072109244533594102100597249820139863731e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0186200180698345191598959279075511852702e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.0985162575575202354740506581030494865366e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0985393633500512859959651235417750436830e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0985803098228143295118225489492787992606e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467902868251690054166669829868007269342e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433553135420701439180188506891059709554e+03) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321993020407464758442921816554669196865e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219584857828395761222653322172007076e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040946047035879884289230128067569888e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5771707314424138941892684449644285450020e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5771684208631730550347379794836849522501e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5771642878992740701074565823520563430545e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.4384515517957141452747231557434842280563e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.4618168312619296273584693011069817157729e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.1644931624692525640424817412237975185597e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0595322806872233880312647749411720285155e+03) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1338169952893937426277187119994287302346e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6950396511493210703237127857851667693795e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184202714718016971306283562795198270295e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.8637069769463737476736537820135010098445e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.8637046663671329085202796532149465693592e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.8637005334032357298327958011134279960335e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.7315558840455364303339359461581999582409e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.1138488489369003670290577788231882970614e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.1138488109521411733704799522286118871035e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.7315570650795744281612418484153383749467e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.4510293938318891408562818101235322488948e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1023976430008439455508356035715732285365e+03) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1381035315207554716436706538645025163252e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6993261873806827441799801040594747524210e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184631368341153082564641548360256961405e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.8637070053098936661684331022983050791822e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.8637046947306528270150589734997506386974e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.8637005617667556483275751213982329395801e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.7315559124090563488292803836899296812600e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.1138488773004262800686109256329136021377e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.1138488393156550973182084181114102146692e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.7315570934430943466554560444393023518793e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.4510294221954090593510611235640268783592e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1023976432844791447357833967059753636761e+03) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1381035315491189915621654331779425717010e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6993261874090462640984748833729147810998e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184631368343989434556491026291600937108e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5771707597241576468108912060617965411115e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5771684491449168076586734139454312512319e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5771643161810214352104762967790538796726e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.4618051572299183401969647486845496691173e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.4384635016651971554943142372905208582087e+00) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.1644931624683517629655090925800487288831e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0595322806872027635233607044898342196594e+03) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1338169952893910267049180229583619518901e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6950396511493182440815428495625683574298e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184202714718016576427529076648194187481e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.1092175454341481188483527079771980615330e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.1089864875112907930669294261441780607577e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.1085739575709466934971522130034710877774e-01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467807565667585023302250777748997632794e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433550950169317985132307009482681008117e+03) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321992732564967401503764943908391839180e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219285313150679585349605082169054797e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040941860843676199177331191641872267e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.3637528733441421223616474064153473480554e+02) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1169586631004695014879965789928101373557e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6774144328763296290939648006994016855609e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0181659854540694671712442689126925418470e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.2982398182467145324711094152204910062418e+03) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2406192650741793318713976833260452889542e+04) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0087449082536592290387211575131942543226e+06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.4139535417336320643025656126470011839591e+02) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4614921685624241173555894525601931388405e+05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.1852253902590954656567159352561485249891e+05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9724423460511980766108582180986798002283e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3517888312517780381059856987517912198494e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1182384657569322856330197396982559816080e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.2400043594361837621933209545632990154402e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3482240153342700171627381177573077432116e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0906131355699451574246246918461755583042e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.0360632846609131026926079140218179747706e+03) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5301316853777613825475955768210486693218e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.1417810507945336832901797370245384950826e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0280188413798029350232249359389600611521e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.5368241306151480522266229560767936298819e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1119731330852400669503614201121751772972e+03) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1436036843418582017370489644249104906939e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7055932268259713821469245913764904694994e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0186038411332414422511746349387125761787e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(4.0016193744057575894371753107185128983625e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0271783102507827553340153737458239088441e+03) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1305816040221964297944712152652462791439e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6918042608573054838045682679650747819572e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183879176681103298660522962201275003852e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.0986129217405395802830922984815796321039e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0986129217427178213142944874441328275713e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0986126662876374069888155540407470045549e+00) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467887323079798097719591508499956311837e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433552773959358642208718573973703254918e+03) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321992972708436953340195634064589262487e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219535208437137205694514595947133989e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040945352084390081134680289237731386e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.2459897522072349657403519403804188656028e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.2459897522070171416372317215931743080333e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.2459897394336901719066249399666851698760e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.1138482623875209229016085890116257615607e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4961411954910427179164861568674517418873e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4961412210937095837734530331050030046780e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.1138494434332987267228753636592123380095e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.8333249445112170459183221287097582839835e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0862206397095564217404299378994960347735e+03) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1364858335022054243499713880080415357705e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6977084897522053875768366913379068091988e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184469598975220501339492665723953906066e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.2459897805707548843077302704411331265730e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.2459897805705370602046100516538885690035e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.2459897677972100904740032793004278030362e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.1138482907510468359763228041111831355297e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4961412874419735947917404745699711189853e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4961411858697943903601631106072253037864e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.1138494717968126507085180902188889892985e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.8333249728747369644131014328772254153734e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0862206399931916209253777310338981699130e+03) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1364858335305689442684661673214815911463e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6977084897805689074953314706513468378777e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184469598978056853331342143655297881768e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.1082575039129226095826819478694582540185e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.1082575038911401992706600800460786947915e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.1082569929346787016450238763744016774789e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467886939882766563609899256466240310433e+01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433552773959152397129422906894815351403e+03) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321992972708409794112186398384097947665e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219535208408874783993584450045269661e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040945352083995202380193881548615711e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-6.7731240508552705373352553704550588256141e-01) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0271780917256441394764548042803002807290e+03) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1305815752379466916127992388446593837733e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6918042309028377105238023398859948966690e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183879172494911094972645834191911689330e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.2019828386424322512727401884540983036380e+02) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1153409650802877643671946669792183699200e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6757967352467617180253890204642482004110e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0181498085174760278316189344897328960323e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.2820628369250896521333825391171273531237e+03) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2390015673712425586211511046389799879766e+04) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0087287313170540476660952210939919226629e+06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.2521836216250405842176994971484335865311e+02) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4613303991951902335092067271199590900873e+05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.1850636208912100222899948730947672103398e+05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9681558098165454415777810010010603667948e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3475022950171254179853297698221551649881e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1181956003945857624714709115763258669815e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.2357178232015311053019746476229443625716e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3439374790996173788300602787461688189050e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0905702702075986342571346103621226714835e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.9931979223143843562682242140409336494049e+03) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5258451491431086632181320364853110547572e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.1374945145598809976669723919397693700233e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0279759760174564118447523894119007691685e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0691077707387106161212095126154805200771e+03) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1393171481072054729760490940839543181565e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7013066905913186901081882824048192934476e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0185609757708949190715965182283948397285e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.8431294790425328794766456545370781976462e+02) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1262950677875437008799065826681573613820e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6875177246226527916631382931706094635232e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183450523057638066864570960422405022124e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0004899150494063968345083009732107643574e+03) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1279127610361909664194548135458419391097e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6891354172861910215791393982691087931443e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183612291728619158285182678380025191972e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.0986128559385885102398663449668945354448e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0986128559385885102398663449674216628585e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0986126004796491047431751997854643398685e+00) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467887290172836637862148465218037367095e+01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433552773630269543540663814741346755047e+03) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321992972675526954354066381474134939068e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219535175526954354066381474134983563e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040945351755269543540663814741354363e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.1082585067415646707748084827810589202087e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.1082579958238683944026557029413833357841e-01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467887190620017911206248134442253093569e+01) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433552776466621535390141746085368106442e+03) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321992972959162153539014174608535492826e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219535459162153539014174608535270352e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040945354591621535390141746085330066e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0004899150493857723265787342629183777370e+03) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1279127610361882504966538899777706981783e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6891354172861881953369693052545038255356e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183612291728618763406428191972336051721e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.8431272937911467209007849972470638718076e+02) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1262950390032939626982343717205214212206e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6875176946681850183823722082994931506073e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183450518871445863176693832152356600279e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.7733292151771374087711620259511485685587e+02) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1110544288456350352988064088536665123102e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6715101990121090257811496519786884377194e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0181069431551295046520066505055202395945e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.2391974745785622558824266383265058960055e+03) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2347150311365898594602443678251058717185e+04) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0086858659547075244853759860933481068396e+06) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.8235299981597565446979214438061314253839e+02) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4609017455717250015905776505350687713396e+05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.1846349672677447903099416399548185324393e+05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9681558097740001707505407495939399196420e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3475022949745801471580895184150347250529e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1181956003941603097631985090622546640533e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.2357178231589858344747343962158239048396e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3439374790570721080028200273390483701552e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0905702702071731815488622078480514685525e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.9931979218889316479958216999697280181831e+03) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5258451491005633923908917850781905668055e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.1374945145173357268397321405326488983852e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0279759760170309591364799868978295662321e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0691077703132579078488069985442745479280e+03) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1393171480646602021488088426768338256400e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7013066905487734192809480309976988187045e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0185609757704694663633241157143236367915e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.8431294747880057967526205138250183960193e+02) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1262950677449984300526663312610368687911e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6875177245801075208358980417634889887303e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183450523053383539781846935281692992755e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0004899146239536885621057869020047841947e+03) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1279127609936456955922145621387214465188e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6891354172436457507518991468619883183514e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183612291724364631202458653239313162603e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.1082556703895728212968771386765231030482e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.1082551594720939162016217760351412390309e-01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467886481531974596806119322315920992713e+01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433552769375742460816638674029286953420e+03) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321992972250074246081663867402930013160e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219534750074246081663867402930235634e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040945347500742460816638674029324994e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.0986125723033893252920732105641499629382e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0986125723033893252920732105636228357488e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0986123168445586054560018641113092586028e+00) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467887148355354721793107914366505449062e+01) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433552772212094452666116605373308304815e+03) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321992972533709445266611660537330566918e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219535033709445266611660537330522423e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040945350337094452666116605373300697e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0004899146239330640541762201917123975743e+03) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1279127609936429796694136385706502055874e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6891354172436429245097290538473833507428e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183612291724364236323704166831624022351e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.8431272895366196381767598565350040701806e+02) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1262950389607486918709941203134009286298e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6875176946256397475551319568923726758145e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183450518867191336093969807011644570910e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.7733292109226103260471368852390886853121e+02) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1110544288030897644715661574465460196450e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6715101989695637549539094005715679628768e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0181069431547040519437342479914490366576e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.2391974741531095476100241242553009182590e+03) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2347150310940445886330041164179853935282e+04) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0086858659542820717771035835792769039021e+06) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.8235299939052294619738963030940767707107e+02) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4609017455674704745078536253943567419111e+05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.1846349672634902632272176148141065029811e+05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9724423460037189825536531776796604264777e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3517888312042989738736161540898830529424e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1182384657564575010700100633240149428935e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.2400043593887046244195881130012979052965e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3482240152867909165063334001972994089574e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0906131355694703728497325115686603061955e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.0360632841861173699344721429751723645938e+03) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5301316853302821198976579147614097123904e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.1417810507470544880527384613719716363735e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0280188413793281504263678307900251395325e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.5934036347247609549806146163690145509083e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1119731326104429253830236930346488899198e+03) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1436036842943789202240431205502562931886e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7055932267784921740784284341126348762725e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0186038411327666576521063899481974416575e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-6.7740389072872224255232578057384461607818e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0271783097759855806522877066145461497722e+03) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1305816039747171479743359197925360331644e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6918042608098262755306848278156937393176e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183879176676355452669498843025852575210e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.1082556044880734715728668655615470955112e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.1082556045098558715423648501748125868015e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.1082550936312240741901589410285902185120e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467886465086704387058224011595175911981e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433552769211386895391186940080585732660e+03) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321992972233644135138840334067482195059e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219534733645054466858545182096903963e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040945347336544090110560853130249259e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.2459897047243319149265940532556432801366e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.2459897047245497389262890329927652248317e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.2459896919519996106171909750412384679577e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.1138482149064344808982118845860501326889e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4961412115973853546282637511532635862682e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4961411100251579225507301939160105963142e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.1138493959522002978382120055034922635144e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.8333248970307227363214970658632497210380e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0862206392347592470586767745077806868494e+03) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1364858334547261425298358580083087195837e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6977084897047261793029530943965070050239e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184469598970472655348468546287846399362e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.2459897330878518333487743156055398878979e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.2459897330880696573484692953426618325930e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.2459897203155195290393712281181023005374e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.1138482432699484048102100036521169973237e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4961411763734641227437600337860625424804e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4961412019761431449753235327295215545968e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.1138494243157262108449741649250880738664e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.8333249253942426548162763885767779997995e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0862206395183944462436245676421828219889e+03) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1364858334830896624483306373217487749596e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6977084897330896992214478737099470337027e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184469598973309007340318024219190375065e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.0986119721365715792428598777870516686550e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0986119721343933392459100815059393238809e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0986117166719083922867288918870053369224e+00) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467886848265974085737828116905561378533e+01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433552769211180650311891272953625915178e+03) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321992972233616975910831098386548691359e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219534733616792045157615035899416188e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040945347336149211356074445441084432e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(4.0013047853328320855511738802713757214653e-01) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0271780912508469647946761446341728143422e+03) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1305815751904674097926634743179624041909e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6918042308553585022499185861526154453282e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183879172490163248981621714495119169818e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.2019828338944601671794034291571206436407e+02) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1153409650328084822394121934867027668234e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6757967351992825095458868417476899477338e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0181498085170012432324823549676509125854e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.2820628364502966197214612895095582623779e+03) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2390015673237633363083174733742411657112e+04) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0087287313165792630647447400646399309959e+06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.2521836168770901060828335836149316394408e+02) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4613303991904423872728285165808974449788e+05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.1850636208864621759307683786104424747907e+05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9740600642342382624644547138206339859263e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3534065495930023780267115149090877141591e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1182546429725878299419859229867240910736e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.2416220773873614129262981927035318954871e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3498417334823095466810399280869088927176e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0906293127855376796314707896425787733329e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.0522404410746483239843258235817518898985e+03) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5317494026666240034210830724443508242388e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.1433987684409368750373900761221669326754e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0280350185952789602569099408674084235947e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9742630037747322445114827391900308026095e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1281502820269712873459881085619903950015e+03) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1452214015306753929984680972346861587867e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7072109444043215728602510050092993615920e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0186200183487057401013020878217328219037e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.1072944234202277646606083828662399511375e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.1075254812604152007719935144968102350895e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.1079369895408554787538451206528340149013e-01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467965556098103381203153849310501974221e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433554590168827743646086171991241830976e+03) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321993212093846761974909075820385913392e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219784345663470149858605125740622547e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040948835744465025582969976962497361e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5771515159877682999320886431715317738094e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5771538265661579083997730441147086458752e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5771579339839822192734661920927945885292e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.4618047859599886120248037270552665525316e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.4384631218602396876924687827878063166041e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.1644994695687652669937205072063593522839e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0595324261620357480251047182073451329727e+03) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1338170144580319404931613092484664768366e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6950396710981045760993978639357197425377e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184202717506725556444812073744266236003e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.8636877332099790910720104619196408994554e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.8636900437883686995385385265795455431292e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.8636941512061912040576691875255921099932e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.7315558464850385076284609924604157342093e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.1138488113881422498783173307080352878715e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.1138487734033710693363146570702461909157e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.7315570275425441261593680167669338013868e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.4510357009314054560176675252964875356977e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1023977884756563055446500505839347174617e+03) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1381035506893936695091130165865801324511e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6993262073294662499556650254180507412291e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184631371129861667703170059048639918621e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.8636877615734990095667897685162595011280e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.8636900721518886180333178331761641448013e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.8636941795697111225524484941222098374012e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.7315558748485584261226751815978477905450e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.1138488397516561738260719328804501031387e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.1138488017668969823803956968230165533246e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.7315570559060640446547124478365234003139e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.4510357292949253745124468387369839134487e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1023977887592915047295978437183368526012e+03) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1381035507177571894276077959000201878270e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6993262073578297698741598047314907699080e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184631371132698019695019536979983894324e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5771514877060139278632826712592148637536e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5771537982844035363286543996358472806965e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5771579057022242344927117306611391828386e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.4384511717532549596279025358988275424575e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.4618164602239170117915897915463808432897e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.1644994695678716903370417893535188520669e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0595324261620151235171496552483840930189e+03) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1338170144580292245703601511534794375400e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6950396710981017498572276141291673618878e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184202717506725161566057587075892136205e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.0987080691087490754449622386982973456672e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0986849633249756496929652521664478551352e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0986435059563258588912032924768708503921e+00) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5467871019847869975941792989726696570194e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0433552404917438880543337439220028767225e+03) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1321992924251349355280631134614070862980e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6934219484800985720710416229525158032763e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0184040944649552261334940613411679517930e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.3637543245145968415020193713996316094944e+02) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1169586822658443200084618771233521073469e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6774144528229320261445299778183228155209e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0181659857329399632509101100274287291710e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.2982400076608479119379883695650894282487e+03) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2406192848740440184089171230080568402351e+04) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0087449085325062410545812159403676769031e+06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.4139552220903020004466254110639819577521e+02) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4614921713485300974949566935766698314313e+05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.1852253930438983268772298387976185562782e+05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.7719815617764868113976844248465979601323e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1819939795361446197810489311145634099972e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0850343964602507528321879036677819064824e-02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-1.0841080736259198720432563076072677343035e-02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-1.1710928343044526815039669279221235974179e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.7475948544846760954877420052225031185269e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.6959201309253735817839082052263796349251e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.9229342319794384984729611243580201891981e-03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-9.9151811415298870520487129646299096961924e-03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-6.3602484069421524739505899065624056719963e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9864506360918496580268729905667898359831e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3660044177184272546587651209684458817028e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1184228790305254567255616540619934350277e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0150801098553229927742462521155296233452e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.4844364945394791762893574788657605172393e-02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.4827015145331130188182222751403915474147e-02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-9.3983990421631608318382496302640915870270e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.2537088784545076414206000760944688550719e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.3621864957241561772477846611229721729877e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0907974662437157116067837861415648268182e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.4965915317313063476760413514639429678037e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6197286163529607238066269986361135284719e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.5991082710879133383094342389896657964240e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.1428807171237545532847945854483854302331e+03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5429688732581089587301572124941473639743e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.1550864953178693382434139153262237185895e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0282030193670353968673916592748516054955e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-7.5746242849451175598729351725926957372216e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.5102383233045459528511710217379106700284e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2171616339194513480721327045076452080833e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.9943023152361403528350707520558867246855e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2090952000654788350630965443071191058679e+03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1563099472182611003087892195742074126699e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7188095705516155912005466171555357653937e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0187880037500039121603364510443873218561e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-8.6964269589809168055306872893488502752595e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.6537694483850569183439326336667076964928e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.8330845952899845513065750917387224371439e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.4493965868420330636694274834607699070519e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.2600020419139546474203068670103117952575e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(4.8866898265869157333157007025203729951266e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1240742266538771834051495783288398303975e+03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1432857354646102947938401912586919736109e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7050191784336198273198047903115779450208e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0185720800473655618076556693030629656217e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-7.0787206077314080897440967780681504870966e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.0360631135425796306736372275333272850014e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.0010090580569135856629472948221484943844e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.8536170153036928986774290566386762055055e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(2.4494724936305532488954500316537343617486e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(2.2599104860565574177402401986122695970944e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.8536335737469193825773482445796488805745e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.5043920517497500630091275100350481454081e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1402511936249528363919523605925879834807e+03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1449034287116299806796187337288703299341e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7066368710960693404797019875030905603908e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0185882569144634897376723231601486855710e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.7921843763684438737261501512410162445791e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.5047311782038303861264685541803372639602e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.2875452894193354858084146967055026371598e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.1401532457758498754747471017404185684581e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.5224539003616469614763149650988157232830e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(2.4494724816119187640665555563076848002620e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(2.2599105151195224230495045403886033306529e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.5224538623783316078460636385573684091331e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.1401698060007888406228539111835531745770e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0790928283112325317407546726387453576300e+02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1831165559385733775007954437596247821497e+03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1491899649429917095421345747274001940242e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7109234073274310142333331899281023278620e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0186311222767771008634910383933139063202e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.7921843480049239552313708378003630398376e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.5047314618390295710742616885868618252926e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.2875453177828554043031940101458933644912e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.1401532741393697939695264147499267710345e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.5224539287251668799665206362150589354500e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(2.2599112042371683889202625110106845733981e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(2.4494724297826682126563551408637605567512e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.5224538907418515263454165960597717550259e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.1401698343643087591176332250553988103735e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0790928311475845235902326039827918526108e+02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1831165562222085766857432368940269093465e+03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1491899649713552294606293540408402493258e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7109234073557945341518279692415423564912e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0186311222770607360626759861864483038904e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-7.0787206077316536124127790950115213451420e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.0360631135428282468056446322259551969964e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.0010090580555834312493079430060744828104e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.8536170135218328896299293367928060394350e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(2.2599109055290244508410403545820914516477e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(2.4494721465918652176171833372857337293611e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.8536335755284843360288522898529624836852e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.5043920517487266171013931695764554498207e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1402511936249321790625927992145003454936e+03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1449034287116272644499458429547156889908e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7066368710960665140322598195818997089601e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0185882569144634502497627078987669805659e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-8.6964295383419650058191488505160379361345e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.6537720605601667035484011460690517588408e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.8329437488433609860215915083140403022992e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.2598194338959843571127854088031743090699e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.4495481198494424556403027022981017241138e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(4.8866789953675412082708677445423939038014e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1240740077805836641370037048158858625760e+03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1432857066771053974030963531303773354038e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7050191484769746205931590397299703261133e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0185720796287459790147901133100459513232e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-8.7401047610423607296920020224418224232293e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.7187329694321448280849464026942091234695e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.0356482684838824255366433171072388640179e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1732541712458772693949536923513994463367e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0168639860638290673418940736299084852330e+03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1280429615058100148693715730702360125241e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6890102250695906769035333208456744303875e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0183339706592193122974754032655410357998e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.9346701194113722215359947736767306756351e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.7115309488647140444202244241241272630560e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.5993264057406165933255430672136940431627e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.6195004251104608518236529588164397890812e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.1426512782142529286742638896929978156965e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.4076178261893733172716310016552939382126e+03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2521190100212070309552378521251292880692e+04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0089128780691305556306638611370353768286e+06) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-1.0279356071764004241081840552673601402394e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-7.6984499244548087990171615877885818865019e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-9.3990506599656778790748774744703308889318e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.4827032579505096690641419113992519827046e-02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.4844347429557749598677561392017978008410e-02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0149914537666432790329506648199559394853e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.2598010538487480045889415943941302926216e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.3689053729191920073937200188584316266486e+02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.4631703174389759682082262169529474073135e+05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-7.6980105538276114443838513516066890299426e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-5.6243520035333677555095730058115778054174e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.3604550898461611879709315485305912092755e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.9151901665356426915645135983401289270309e-03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.9229328173060063582215988751659132533462e-03) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.6956718352864097420656929342666772689434e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0336973998615102256789620451809074098729e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.2648295854384468245698551044210724465088e+01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.1869026851705445007534780585560201493447e+05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(-7.6971407876206173466255424262492213780514e+00) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-1.7475951203919476099118081686321452813643e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.1710933564262793441934064899685794898411e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0841080839914846805290149061833788388605e-02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0850343860592132242179092594933378740460e-02) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1819934453637488363512115304829117201100e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.7719812807132172879578802613249994953378e-01) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.2751197890008024883308088370295843336651e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1651814892563399038431432643317946553023e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(7.7722891235019881093306807198581869787951e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.1347036907031976897115368927842698552409e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0845780215436654561943905113078900735419e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0845639246953519161508309498039404444261e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-7.1286085069212801608883151751339291545074e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-7.7005598202669268885656791206346857326957e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.1491350845745706231089872778056933502013e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.4079064672781958066466791957050812356160e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.5249816619970552872772293364620561391216e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-6.5196774108539517389070934297720697060806e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-4.1781936531166188470812865623978129073293e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.3639496309760693696559206841024269794241e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.7567968497007081728591290950405697026184e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1250546279974912313783281878330733713509e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.6923424489902263368795061825545972227429e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.7613372222238897245329084659002274723764e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-9.7492389441300479896517054114801640260283e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-6.1671781804729900284246225229940612450895e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6120501956728854680127189071420452515361e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.7369840995128485556153440310428266593871e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0974238728038095423938355652290103232629e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.9152857204653218607296362246187444170930e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0696349398513611499855179271432462739750e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0472534550495682620883545549226518614816e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(3.9311584945544338654010519961093130854534e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.8480760277180070009150282610252610289706e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.4891151747412945510162476970145974240295e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0348195506217433828450451772812671667415e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.2507316625974726755582540978276228383955e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.7411373341966372470896212486230507112420e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.9398887974225661459029124036181323361886e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.5881826053238518191417942629245230131650e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.4536888474291549828888982462132728153915e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.0474335179892358456447727061528853389171e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0254035409023423151920887719598631303690e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.0780228131829592815954856516840490142137e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.9493652467498159881784660951513128264870e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.5414970413345344766423876645869791140792e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.5487474220580178606121493169048764249138e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.5061816049233351355821229937391848116510e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.4953725738164690926557621750778370899222e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.4405397578588402018102311356731441536029e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.0335569345324698880084928662301158415543e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0251876018386765046339688066284894578248e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.9162531451873003137899635520324334512300e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.8126870769212925718045981705516915740026e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.2717130279478443011007075787760514072842e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.5465566067880251177522378615231398278152e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.5436820036484444142556770966457095401760e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.2727254765447141983788132085418423102926e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.6679515872234973265733539552213484936962e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.5115495348239642564335052098043088640643e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.4421574510105142021964237542750044778814e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.0351746271291252181272508321313798182782e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0252037787057627124868940832621413842409e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.4875995220510950648561804661034390996730e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.0992233082884225294861475496533821831150e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.5582492592973151544681234258874536116840e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.9410482841213785278364391666087457831792e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.5465565941212811063733883165729413957839e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.5436820295327916424717013875605884122839e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.9410482462319479153072833999331480165550e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.5592617079212801354733450535241575028564e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.0966052103597322062424275428410203412001e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.5544148971375842353407762272727177491665e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.4464439872418759220704645909040133579391e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.0394611633604868856783006958840445307152e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0252466440680763236116079176674372898384e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.4875995192147430730067025347594179061864e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.0992233366519424479809268630960515801498e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.5582492876608350729629027393215761152956e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(4.9410483124848984463311489248039371608126e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.5436826544282449673470277188993903856095e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.5465565374756762482843888338240989470408e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(4.9410482745954678338021322686457359712861e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.5592617362848000539681243669713938535112e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.0966052131960841980919054741850558757729e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.5544148974212194345257240204071196042614e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.4464439872702394419889593702174534088903e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.0394611633888504055967954751974845563424e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0252466440683599588107928654605716874081e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.9162531451875072113928547455603407488891e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.8126870769293785324628958825232566907430e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.2717130279206120531291122027836723775755e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.5436823830880474172834979108124366156144e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.5465562284374508149292277852228603714930e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.2727254765716721178614869968722952079944e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.6679515872233496904410438532682934623410e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.5115495348239424747010015170286825079956e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.4421574510105114679898008547618069422632e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.0351746271291223792746459868654944062899e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0252037787057626729967747063450210489305e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.0780250053560209964385483580787198181731e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.9502232193426790227477858242168077093883e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.5386086157990923475226415452595982366404e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.5516072486576306782537030680436022589359e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.5061800413691839868510525741918936260525e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.4953723430160149315997687438810892309570e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.4405397288806439392070081768815677711528e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.0335569044442363192139882078078310623680e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0251876014200334816876443967553872035703e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.1265032454524508877394450901329545462842e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.0190284815877432888537053292504733172006e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.8369051386980214596334411392507577184613e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.3803186380526867747766657614957209142311e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.4251719276753705817564353164511514994861e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.0174617032360214135618571214341367199302e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0249494770891987899874091571771298830083e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.2465337858593474719041689668830213525990e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.8864420168959226393916516077347435327183e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0559839161709403613865211965962017815656e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0604506712309308865719239789218542674792e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.7393836015525135695680913639665419004993e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0293891190164800469640210840446262720489e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.5747911442078871965249384400656551587084e+04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0155273891577076957606118117702854172166e+06) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-6.8392090927486078642844940991950268248976e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-5.1157106458937805986752326300216084537694e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.1933284009868651851026405834946837502183e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.7499385696620729439792577123832859525532e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.7606343195601582288946195050584108981902e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.6567624438087046795644250310334520214574e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.2153220148689785976021415811386049622371e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.6959895833058419139857978188997352949521e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.5292152287418511722398439260517340790639e+05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-5.0973686766931017171212036773032409699972e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-3.7202729295278715626832318092141002581928e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.1863936787910610734508550590288378235906e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.5198891782821650649257045804293551703325e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.5247742546627801075027295984450723278193e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.3978380007612908603635824813284830277756e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(6.5602320488883354360330312048239937568097e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2733712935634226962227483761897467636903e+03) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.2528923673615979469010873032248386415537e+05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(-5.0618766347056809609478209827269430211717e+02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-1.1491457553134401046922895602139071645415e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-7.7006106000629070763103110977034872097833e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.1286126665756835759977433310753684228518e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0845639343319307282619359840267783776789e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0845780119065859629707473674914893067168e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.1346995168137516722051866283262113204432e-01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.7722364768677246201659150342646609867927e+00) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1651702103141054292403714417315783983639e+01) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.4891435821366382996976476316595433094456e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.2640135154258298525884747012097877232670e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.4314086582283704578987374289270243207451e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.7395311806819909892355549940047011098780e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1765172031944911585923791960869065732724e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.1765018085413063516089406203467584053808e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-7.7328748530054994075795078836404706475240e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-8.3530756113645301125287032547658980623220e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.2464897658582290401678734494384804549576e+02) }, 
//      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.0766743928534209945155627434937476192183e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.8373524196824020988124664042211247156732e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.0792215549593633402765185715330668896747e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.0712312967016101032095683241456420892482e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-4.4899240321625158082017309619126360752651e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.1691042366326482693391767621984867057940e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(5.6831729709700599502452484165486484998247e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1703589390964673197556253653478330688480e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.4678804127293973613548294893114886482847e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0592555267573474037207033389283093940188e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0571948545941927683730932640831242168659e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-6.5589010742016341802319466258468859194028e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.2662135685333641056084776452516514469377e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(5.5351663614955350827601149329328947427376e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1426754401357903938391059644645748169375e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.8964037566295679378891581526236621797066e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2175622186884448953524129946018172256681e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0946570812006407813409888506767549634841e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.2022752386035282488122093201511085728612e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.1452460623217373666594605080868652129191e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.9966413830598457801971590204640694805187e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0799736415151005906137956482646424666328e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.0200798765954967023858333064756685808143e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.0263068357931618117053217390080033190219e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(5.7599996788370502437595621988724127129469e-03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-5.7581563773657613509528487823088617148848e-03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.4486946985215375239559096612180095595931e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.8233175840849667720289856596861562420581e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.7078250610309780707248510498441240567586e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.5209082498046679963302028913488612357880e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0705478206716764098212193808592145400770e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.0773761876859661866703074377788149913292e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.6592616062652490287649505667581276126377e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8738458220601725014095898294934158823229e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.9833111473147866519342243457588842402833e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.7919952359925075433279001163918880579445e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.7147310331010393959542931772558716828502e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6939997222268646657341596965877031105661e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.5064977227410261621737757025909407999959e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0703317300069742829304635107206934203474e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.9156063692233091064606006982433559300104e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.0836188892073207308549912327472704803089e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5050783161967049527798652636501480364578e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.9292056044900019510264169361307875583581e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.9289402734139419727677346386953879271771e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5160512383156186946204427891012674861330e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.9537650516093874448199575323331178409113e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.7309079820779246072671602638005308031713e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6956174148624463425160073776119821100452e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.5081154149302048957724035770898146500862e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0703479068739448230340143698794449255852e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.4869527460870896728984378633928853208403e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.3701551205690007022911415189127959464520e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7916145475584796301847685751123092579246e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.1794435446135921157147693194992444278364e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.9292055965002428481164872082736621117082e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.9289402945697651086603861575057569773860e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.1794435076629873109171278152290568525693e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.8025874696798812029099923294037297478437e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.3824186747456066108415393908715288094205e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.7737733443915434520188984380409080263819e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6999039510938080137367407807015322533173e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.5124019511615665249096208468103987523881e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0703907722362584341478239177608413937689e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.4869527432507376810489599320488572620844e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.3701551489325206207859208323528275850385e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7916145759219995486795478885523867335936e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.1794435729771120342095422209560080455773e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.9289409186498529611257233086955588079804e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.9292055397807462150167453348991743075467e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.1794435360265072294119135406560877429978e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.8025874980434011214047716428450113177321e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.3824186775819586026910173222155567386885e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.7737733446751786512038462311753093325528e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6999039511221715336552355600149722807206e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.5124019511899300448281156261238387594233e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0703907722365420693470088655539757913334e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.9156063692234876348067324448147496492453e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.0836188892045067190227159122738010451933e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5050783161940803528850815642042682185244e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.9289406429689489578847312241766818328257e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.9292052350328998696722814386322698879963e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5160512383179697564949549911326870452637e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.9537650516092083813926639722647802838325e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.7309079820779005572235908845689278148287e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6956174148624435110027696110198652328603e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.5081154149302019800921335437597667124319e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0703479068739447835220864199145257154277e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.0773780789307667193835762185795061244907e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.6589633589263786330469864732637094624801e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8735676666823597892192640514556402451145e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.9835607876646783710264988512866676348213e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.7919933390718074295252240680342640781530e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.7147307782393660830370681097152305909518e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6939996922164837875989420106445676800342e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.5064976918378394253681622494057800680868e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0703317295880999244925346187809607965094e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.3527614711439896619664529660286346327342e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-8.2111888034892449598230885514508515897122e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-5.7599065350413412114880725807708443445443e-03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(5.7582539058239296524021803612798074355209e-03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.9088507660857255774631427760704217963427e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.5839174235320887674884779486248277135981e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6779552855279199463883883844608300257131e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.4898682985053067569305586288295249155154e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0700934536535211223257043255816290458455e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-2.8537051790584166039190646699049281666124e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.1993857595093228011317570893895300712973e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1070878811022415971960828655980993558881e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.0200457997233625369529458759695281372239e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.2375998677957487118084458304045698277447e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.0120714716772425676925109164660158853531e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0606615426341092991160322077188899188001e+06) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-6.3845655688365171682718121057900711726287e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.8678299204241060829946388448173636231082e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0580172284300128865040378108818210875404e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0584293004672959938242360836353136319466e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.0459427617588690677879851102974738110068e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.3958246795903773878121947918335731973567e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2995219492965407016777972386830755147206e+04) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.9795680316583428553549588438196216834210e+05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-4.3213932295514430776619731796786609277422e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.5863987956874575483757413129717711593458e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-7.0736937782122641522539779893352169073158e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.0767568157705649696997396292831535119162e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.7187970644428062936685347386453293906948e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.8276199386912663333005443137306007733673e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.2542242663977414614261419488432081583241e+03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.7027003036381154422151839635472256713367e+05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-1.2466151947476328950156013666264316305544e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-8.3536442849224759617718111237716620909009e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.7329237475408932268966805094092389619594e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.1765019218141886803190756503021708199306e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1765170899157235884002787122344014981408e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.7394821188212055253402527920565504759436e+00) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.4308185686965131018320018694098038155529e+01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2638809374272504046718375812367236137292e+02) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.5536244031101586352339227539371169336200e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.8906022586034884757334867282172644548495e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2610862740951384660242466377810436373556e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1575839570260851063215949172007609126390e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.7596871190333555400409539745896861739438e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.7596640096693646374083736953134793994819e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-1.1565847562105708887541658129022108027889e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-1.2493274635433706851524785668184435677811e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-1.8642967985187984119830683230428386381812e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.1004855109208642299764650665036150784763e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.2830125223620229677503493429194418162526e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0589128603671239093032702572898758993549e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0575351436686567103592055424999377522890e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-6.6820686619787356595819513744010384583134e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.8075438939483149870826304308998708775426e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(6.3808074220535076964848396354870802081757e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1907811783949694865078912081074914949353e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1363311516645736317809169315013672744407e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5846088030670925343026109984069478429229e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.5809156099586120469428889895217022436850e+01) }, 
//      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-4.5982546021529254789360181932356973473932e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.8426720450938252841392199316990767374272e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(6.1791497976386630264342511998449529806923e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1630693875939526845361461302298424245342e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.1358881913026071263115030366866329843687e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.8802869793389600216289448825220566685786e+02) }, 
//      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.4601948495381566172893072659462358596570e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0792306723679245436991261541143917814161e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.5933930225136479574784738413793801194823e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.5306965834385771972553827527309026345021e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1003153164434778256976022582352031401541e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-3.9805924597903556092735837763257477335377e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.4945885083852990303407719041998564125027e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.6157680721939866620519019823631930365818e-03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-8.6116486736673584156644590818719570609794e-03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0178651405655709447670098594384999390143e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.1925664725569532915150179989614231334852e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.1423804976526625006479703718385873610690e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.0432450831271159966805036880319898040681e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0908842353219450825029224771799464413309e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.1014694617706415837565698694703735466320e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.7018034289497186642019833761348255770680e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.2485489414875075711254694244046853162087e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0637468077829101211571912015214327338355e-03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.0648791819060887152676022733256769957318e-03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.4125207357994278713726450940048717358790e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.4838886852435541194857827149982129441913e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.0807251945989492801399076054817122368304e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.1283447993981733550229552619790249599574e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.0286528003074526620691450832448485336493e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0906680633771375946607087200523471568391e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.9396952147214378199775338168677842986580e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.9878951067624737300111103466441502561237e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5425530462225306458537357294731917703462e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.3317391466165436793976382499325235181576e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.3315616303733985408298835151249465339770e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5589677814768531605822467855681714252948e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.6456584721272834797936639271735269496953e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.0969021410945854375308173101566848794013e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.1299624918732530836503521154794030846420e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.0302704923579488223684415340339443138617e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0906842402440461201204545914575488183911e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.5110415915848009989688167749400762797229e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.2744313381262309026165809113247352399770e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.8290892775847218756634924612695930078620e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.2197012888254814419162660158092717009063e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.3317391411892432667687372314994639802623e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.3315616489650302406243961463030618164099e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.2197012523874838289666005404875419349091e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.8455040128406994338193059660575836633027e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0074312095263499937069676147991582488613e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.1397675034082040483690337760659414186355e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.1342490281046147397401675244798359793949e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.0345570285893104384317075652365985994758e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0907271056063597312284178645701844437742e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.5110415887484490071193388435958462081153e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.2744313664897508211113602247657722306297e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.8290893059482417941582717747098720922278e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.2197013171890013604110410422324001484033e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(9.3315622730177155255081467610353989883327e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(9.3317390844672565934412563580784884786569e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.2197012807510037474613841409474008319443e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.8455040412042193523140852794986637780907e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0074312098099851928919154079335609106866e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.1397675036918392475539815692003426115938e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.1342490281329782596586623037932759994749e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.0345570286176739583502023445500386001833e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0907271056066433664276028123633188413358e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.9396952147207815734305772089347879375635e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.9878951067638141205174529355627533560743e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5425530462207391507686680575493263386775e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.3315619947856528251456019147791406976290e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.3317387822688399870913263642693430990793e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5589677814783717523517863310548500743708e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.6456584721270989988752310916686588162653e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.0969021410945609196602045142628676063004e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.1299624918732502218752783607090516425032e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.0302704923579458805402690236680366172064e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0906842402440460805968340919551079226219e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.1014624980997360030698841335523306375393e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.7019458618482142227008208560609850545074e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(9.2483591581058636863642507414274558211031e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.0648798368415573846292979850852525460356e-03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0637466865218906154260925688580256656885e-03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(9.4126820714800401765538142805009262578954e+00) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.4838867308565551689647726376990902327161e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.0807249347747780157307106762000694712145e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.1283447690667885904878436155322169565783e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.0286527691269007872192678725864948536039e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0906680629581392069390002851613110931192e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.3867332652138878360183449765593800419858e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-8.5905881806481698994951371241739970368500e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-8.6155605928920865219765564694266325635658e-03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.6118622928153518122451390075882925546428e-03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.5634890788314806701384064880808814692548e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.9466621112863984534562100009727622246850e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(3.1120899913000316381618499077032283775506e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(4.0118415970516193288678180635400484090278e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0904297057420480314591922182242975421857e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-3.1209652413907779574068187937445415425521e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.8487542632450144255064380670107828790099e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.6252522156997060364292150959536360728614e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.1845393689425335234749414088808476897003e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6580927743284019873553854601876880566764e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.5222268942114119811527359495204365213490e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0809925282236235339835042887103348359796e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.0406294175356926804973800606880444678133e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.5827552314905150313508209038886032579780e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5827605632803868262118472872589949777858e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0408606255955233786394099183528798962513e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1298638244034201791709624260831234685003e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.6902897966766224511867026510180549727704e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.0182347899538303053003499024971738412905e+06) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-6.7813211693266850734344063245886109053601e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.8981715240330693032264735186638593270653e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0580857899229461987633815887965793449743e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0583613057758251853709137425952802176265e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.0172813374399825584244517246959076062665e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.1578793565930206823848399304340920074568e+03) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2557444178158094225446384895750443526031e+04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(9.9051881906767403087320589423213159445145e+05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(-1.8645773780773470724092895730801889555793e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.2494544609583532591655216872217697679275e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.1565956937280751965469630410455374382287e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.7596642630563992240426559239617401208812e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.7596868656331558969055019644614868253762e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1575729820785408826474616884064630055592e+01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.2609544899870128967593117209828539836817e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.8903056867640574310545607455994597016196e+02) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.2832898927511328741796783638230131282820e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1423012794847644048676705723165219238124e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(7.6074011899850325411318286870561228169270e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.9633626568025749886934411691261947481149e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0582347079694122413844693180036525161340e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0582117996395776043390756471979161279916e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-6.9534575517702516816286716494085466732356e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(3.8373543281995458886391711843676497407481e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.4706103214327509136099534583402064105173e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-6.2658222977643479915662272758589468100732e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.3510120359262415468780201770020458714432e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.4999542365928817230528164184671433921064e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.0027566702500760879952466580879358049744e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-2.0321554687500000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.5302531319896842942752012244718268783873e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.8942616085084331262127204228813835782454e+02) }, 
//      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-9.2075804481807222814302973318532642713970e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.1540783906815175610321451293672477728033e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.3839784904714089910235598597429129208429e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.8712764962655009871682877796727336141897e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4998058879020015767119023259062552243461e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.5652843338817866049554931872059965824784e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(7.8777812778195074424104297833395697096039e-03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-7.8777292479922863234990487684871643470312e-03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.6676354008772862845531598451070565005526e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.4052413596822660960540177728567933332859e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.0462146984415007503059178503218585206835e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.5062086090137426183182752157414466000552e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.2525131835937500000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4320240726486253703227417255018308133126e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1492425279471322134637682163852793462497e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(5.2576072431693284219230765382079498763571e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-5.1085636450867271250442384307109171553806e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.3226275657895236461023793416884325261113e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.9011016059583636944343209004826080433143e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9804986245001522736534333994361377239859e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.4378405370916838701275071433327383027623e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4220889323011930479290462670709589590293e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.8501795183581334699520055864238974924947e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0735302995999226380284907096699709813690e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.2040073084016341420556621558759929731118e-02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-6.6145162625773437858420387745891971379487e-02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.6662950202625474088022186558018865490067e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.2142372592513284479935412953766179102211e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.8862435529126065372499105004487764702276e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9787779351941260824764053287688039759859e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.4360790062817303053850320635910079312437e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4218649745104557972855657562368314812170e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.2027078890329395988934517996433334857758e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.6912382556351993723303172863459148690179e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3428283648476729705486914639569985730103e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3428281253030126474401156579639585858430e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.2840004236511330626113310241863768609626e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.2304142083746028560329674737361833618950e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.8878612447602368725987776810728692719861e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9789397041996967115035617538581884794071e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.4362407752561414917238526906454677330072e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4218811513714239527166344951347412647070e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.4892441203943564220565578564134404900474e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.9777744869983148834470762993814398067084e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.6293644489215848550874605073298661363495e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3428284100407522614370063056267421832881e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3428280814260471258448971037629894267858e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.6293645039554105999117026836117062650128e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.5705366550140079360989243277054361899397e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.2732795706882217145851792113774151101482e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.8921477809915984695373776417565672688027e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9793683578228328543045079336225367569213e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.4366694288792776315873206811734540926619e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4219240167337375632645843055428707665282e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.4892441487578763405513371698533447665546e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.9777745153618348019418556128221662373089e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(5.6293644772851047735822397494835085557737e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3428281438258799586002093662636608321662e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3428284043680595291639925271427504967044e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(5.6293645323189305184064820683394498544800e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.5705366833775278545937036411460461534685e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.2732795709718569137701270045118164229984e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.8921477810199619894558724210700072602539e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9793683578256692062963574115538807478903e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.4366694288821139835791701591047980822093e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4219240167340211984637692533360051638188e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.2027078890295992905150884749226382725077e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.6912382556352564398592612410230973884501e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3428280702691058435911300492694976198129e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3428284198814176565869724466106948249282e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.2840004236507088548819448278799979419492e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.2304142083745788335903452213062442467219e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.8878612447602338925212730296690477448855e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9789397041996963797099836561097634979603e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.4362407752561411540553182144243189321233e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4218811513714239120729870702232881212568e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.8498254438590490387472531245672132803475e+00) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0735309299790018469573397242238468903064e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-6.6145142110337000955803835347936803724665e-02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.2040121247758463368760108419204454370947e-02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.6662905454910831855579378148293906695181e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.2142370046824335144014344081843913059747e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.8862435213263230248923152986353386484064e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9787779316771129333208880070692041832001e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.4360790027023982727798684642315209684929e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4218649740795766698734674721145127327631e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.2389490677586051078216379271143451463248e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-5.2492822148912516066078978829267663813108e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(5.1152439583962101450116493340133388389215e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.0836111606293375431549836524486504434682e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.8691663387522724169634944628608500858469e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9768353727665370927896180238281855437842e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.4340956057262404411456377266940387887445e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4216188309653486843214711199888230096735e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.5805157804775040134524224780380793054397e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-7.8777842331911911696241280907669802568567e-03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(7.8777324347662456092639049357836234009771e-03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(4.5159467341243299096318581771879990621841e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.3618245313513366523199761980769416800626e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.9109860682639906812713947671847785110166e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.3656090966812243392088146416074464735201e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.4116773552567049440641435985719082068831e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.8811751129461368970005256035790814172806e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.2174091930600389340238197774438484848463e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(3.3114946327609133192402462675258799606136e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5647571482834212862355908369325758949510e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.9938006054359539007447396225424032965087e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.3438639628318799990444769655838299933824e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.4652927399464182741934385990147819853198e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.2705153122225795004040973788270646056695e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.7421661584672473457101480657595505806946e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.4382339557500690672702642748475059485834e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.8539197774338115999627942143339180821377e+05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.3133777204979669846586326028932174485236e+06) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-7.5365871935846400290867834254114008940452e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-6.9574128294935924522353612024884748851392e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0582209627360964662309549354105883595611e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0582255443968121424917691133528179874483e+01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.9593938434137221900590997104770914834235e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.5598955717465796755840139502780742412634e+03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1315741074738659098199284235122958050748e+04) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(7.5517427064753517663653559720945279814755e+05) }
   }};
//#undef SC_

