set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/foo.vcxproj")
if(NOT EXISTS "${vcProjectFile}")
  set(RunCMake_TEST_FAILED "Project file ${vcProjectFile} does not exist.")
  return()
endif()

set(InsideGlobals FALSE)
set(DefaultLanguageSet FALSE)
set(MinimumVisualStudioVersionSet FALSE)

file(STRINGS "${vcProjectFile}" lines)
foreach(line IN LISTS lines)
  if(line MATCHES "^ *<PropertyGroup Label=\"Globals\"> *$")
    set(InsideGlobals TRUE)
  elseif(line MATCHES "^ *<DefaultLanguage>([a-zA-Z\\-]+)</DefaultLanguage> *$")
    if("${CMAKE_MATCH_1}" STREQUAL "en-US")
      if(InsideGlobals)
        message(STATUS "foo.vcxproj has correct DefaultLanguage global property")
        set(DefaultLanguageSet TRUE)
      else()
        message(STATUS "DefaultLanguage is set but not within \"Globals\" property group")
      endif()
    endif()
  elseif(line MATCHES "^ *<MinimumVisualStudioVersion>([0-9\\.]+)</MinimumVisualStudioVersion> *$")
    if("${CMAKE_MATCH_1}" STREQUAL "14.0")
      if(InsideGlobals)
        message(STATUS "foo.vcxproj has correct MinimumVisualStudioVersion global property")
        set(MinimumVisualStudioVersionSet TRUE)
      else()
        message(STATUS "MinimumVisualStudioVersion is set but not within \"Globals\" property group")
      endif()
    endif()
  endif()
endforeach()

if(NOT DefaultLanguageSet)
  set(RunCMake_TEST_FAILED "DefaultLanguageSet not found or not set correctly.")
  return()
endif()

if(NOT MinimumVisualStudioVersionSet)
  set(RunCMake_TEST_FAILED "MinimumVisualStudioVersionSet not found or not set correctly.")
  return()
endif()
