
IF (CHECK_INCLUDE_DIR)
  # Already in cache, be silent
  SET(CHECK_FIND_QUIETLY TRUE)
ENDIF (CHECK_INCLUDE_DIR)

FIND_PATH(CHECK_INCLUDE_DIR NAMES check.h)

# Look for the library.
FIND_LIBRARY(CHECK_LIBRARY NAMES check)

IF(${CMAKE_MAJOR_VERSION}.${CMAKE_MINOR_VERSION} GREATER 2.4)
  # handle the QUIETLY and REQUIRED arguments and set CHECK_FOUND to TRUE if
  # all listed variables are TRUE
  INCLUDE(FindPackageHandleStandardArgs)

  FIND_PACKAGE_HANDLE_STANDARD_ARGS(Check "Please install 'check' and 'check-devel' packages" CHECK_LIBRARY CHECK_INCLUDE_DIR)
ENDIF(${CMAKE_MAJOR_VERSION}.${CMAKE_MINOR_VERSION} GREATER 2.4)

IF(CHECK_FOUND)
  SET( CHECK_LIBRARIES ${CHECK_LIBRARY} )
ELSE(CHECK_FOUND)
  SET( CHECK_LIBRARIES )
ENDIF(CHECK_FOUND)

MARK_AS_ADVANCED(CHECK_INCLUDE_DIR)
MARK_AS_ADVANCED(CHECK_LIBRARY)
