/* valaccodeconstant.c generated by valac, the Vala compiler
 * generated from valaccodeconstant.vala, do not modify */

/* valaccodeconstant.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valaccode.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaCCodeConstantPrivate {
	gchar* _name;
};

static gint ValaCCodeConstant_private_offset;
static gpointer vala_ccode_constant_parent_class = NULL;

#define VALA_CCODE_CONSTANT_LINE_LENGTH 70
static void vala_ccode_constant_real_write (ValaCCodeNode* base,
                                     ValaCCodeWriter* writer);
static void vala_ccode_constant_finalize (ValaCCodeNode * obj);

static inline gpointer
vala_ccode_constant_get_instance_private (ValaCCodeConstant* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCCodeConstant_private_offset);
}

ValaCCodeConstant*
vala_ccode_constant_construct (GType object_type,
                               const gchar* _name)
{
	ValaCCodeConstant* self = NULL;
	g_return_val_if_fail (_name != NULL, NULL);
	self = (ValaCCodeConstant*) vala_ccode_expression_construct (object_type);
	vala_ccode_constant_set_name (self, _name);
	return self;
}

ValaCCodeConstant*
vala_ccode_constant_new (const gchar* _name)
{
	return vala_ccode_constant_construct (VALA_TYPE_CCODE_CONSTANT, _name);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

ValaCCodeConstant*
vala_ccode_constant_construct_string (GType object_type,
                                      const gchar* _name)
{
	ValaCCodeConstant* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GString* builder = NULL;
	GString* _tmp2_;
	gchar* p = NULL;
	gchar* end = NULL;
	gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint col = 0;
	GString* _tmp50_;
	GString* _tmp51_;
	const gchar* _tmp52_;
	g_return_val_if_fail (_name != NULL, NULL);
	self = (ValaCCodeConstant*) vala_ccode_expression_construct (object_type);
	_vala_assert (string_get (_name, (glong) 0) == '\"', "_name[0] == '\\\"'");
	_tmp0_ = strlen (_name);
	_tmp1_ = _tmp0_;
	if (_tmp1_ <= VALA_CCODE_CONSTANT_LINE_LENGTH) {
		vala_ccode_constant_set_name (self, _name);
		return self;
	}
	_tmp2_ = g_string_new ("\"");
	builder = _tmp2_;
	p = _name;
	_tmp3_ = p;
	_tmp4_ = strlen (_name);
	_tmp5_ = _tmp4_;
	end = _tmp3_ + _tmp5_;
	_tmp6_ = p;
	p = _tmp6_ + 1;
	_tmp7_ = end;
	end = _tmp7_ - 1;
	col = 0;
	while (TRUE) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp11_;
		_tmp8_ = p;
		_tmp9_ = end;
		if (!(_tmp8_ < _tmp9_)) {
			break;
		}
		if (col >= VALA_CCODE_CONSTANT_LINE_LENGTH) {
			GString* _tmp10_;
			_tmp10_ = builder;
			g_string_append (_tmp10_, "\" \\\n\"");
			col = 0;
		}
		_tmp11_ = p;
		if ((*_tmp11_) == '\\') {
			gchar* begin_of_char = NULL;
			gchar* _tmp12_;
			GString* _tmp13_;
			gchar* _tmp14_;
			gchar _tmp15_;
			GString* _tmp16_;
			gchar* _tmp17_;
			gchar _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar _tmp21_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp12_ = p;
			begin_of_char = _tmp12_;
			_tmp13_ = builder;
			_tmp14_ = p;
			_tmp15_ = _tmp14_[0];
			g_string_append_c (_tmp13_, _tmp15_);
			_tmp16_ = builder;
			_tmp17_ = p;
			_tmp18_ = _tmp17_[1];
			g_string_append_c (_tmp16_, _tmp18_);
			_tmp19_ = p;
			p = _tmp19_ + 2;
			_tmp20_ = p;
			_tmp21_ = _tmp20_[-1];
			switch (_tmp21_) {
				case 'x':
				{
					while (TRUE) {
						gboolean _tmp22_ = FALSE;
						gchar* _tmp23_;
						gchar* _tmp24_;
						GString* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp23_ = p;
						_tmp24_ = end;
						if (_tmp23_ < _tmp24_) {
							gchar* _tmp25_;
							_tmp25_ = p;
							_tmp22_ = g_ascii_isxdigit (*_tmp25_);
						} else {
							_tmp22_ = FALSE;
						}
						if (!_tmp22_) {
							break;
						}
						_tmp26_ = builder;
						_tmp27_ = p;
						g_string_append_c (_tmp26_, *_tmp27_);
						_tmp28_ = p;
						p = _tmp28_ + 1;
					}
					break;
				}
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				{
					while (TRUE) {
						gboolean _tmp29_ = FALSE;
						gboolean _tmp30_ = FALSE;
						gboolean _tmp31_ = FALSE;
						gchar* _tmp32_;
						gchar* _tmp33_;
						GString* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp32_ = p;
						_tmp33_ = end;
						if (_tmp32_ < _tmp33_) {
							gchar* _tmp34_;
							gchar* _tmp35_;
							_tmp34_ = p;
							_tmp35_ = begin_of_char;
							_tmp31_ = (_tmp34_ - _tmp35_) <= ((gsize) 3);
						} else {
							_tmp31_ = FALSE;
						}
						if (_tmp31_) {
							gchar* _tmp36_;
							_tmp36_ = p;
							_tmp30_ = (*_tmp36_) >= '0';
						} else {
							_tmp30_ = FALSE;
						}
						if (_tmp30_) {
							gchar* _tmp37_;
							_tmp37_ = p;
							_tmp29_ = (*_tmp37_) <= '7';
						} else {
							_tmp29_ = FALSE;
						}
						if (!_tmp29_) {
							break;
						}
						_tmp38_ = builder;
						_tmp39_ = p;
						g_string_append_c (_tmp38_, *_tmp39_);
						_tmp40_ = p;
						p = _tmp40_ + 1;
					}
					break;
				}
				case 'n':
				{
					col = VALA_CCODE_CONSTANT_LINE_LENGTH;
					break;
				}
				default:
				break;
			}
			_tmp41_ = p;
			_tmp42_ = begin_of_char;
			col += (gint) (_tmp41_ - _tmp42_);
		} else {
			GString* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gint _tmp49_;
			_tmp43_ = builder;
			_tmp44_ = p;
			g_string_append_unichar (_tmp43_, string_get_char ((const gchar*) _tmp44_, (glong) 0));
			_tmp45_ = p;
			_tmp46_ = p;
			_tmp47_ = g_utf8_next_char ((const gchar*) _tmp46_);
			_tmp48_ = p;
			p = _tmp45_ + (((gchar*) _tmp47_) - _tmp48_);
			_tmp49_ = col;
			col = _tmp49_ + 1;
		}
	}
	_tmp50_ = builder;
	g_string_append_c (_tmp50_, '"');
	_tmp51_ = builder;
	_tmp52_ = _tmp51_->str;
	vala_ccode_constant_set_name (self, _tmp52_);
	_g_string_free0 (builder);
	return self;
}

ValaCCodeConstant*
vala_ccode_constant_new_string (const gchar* _name)
{
	return vala_ccode_constant_construct_string (VALA_TYPE_CCODE_CONSTANT, _name);
}

static void
vala_ccode_constant_real_write (ValaCCodeNode* base,
                                ValaCCodeWriter* writer)
{
	ValaCCodeConstant * self;
	const gchar* _tmp0_;
	self = (ValaCCodeConstant*) base;
	g_return_if_fail (writer != NULL);
	_tmp0_ = self->priv->_name;
	vala_ccode_writer_write_string (writer, _tmp0_);
}

const gchar*
vala_ccode_constant_get_name (ValaCCodeConstant* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
vala_ccode_constant_set_name (ValaCCodeConstant* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

static void
vala_ccode_constant_class_init (ValaCCodeConstantClass * klass,
                                gpointer klass_data)
{
	vala_ccode_constant_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeNodeClass *) klass)->finalize = vala_ccode_constant_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCCodeConstant_private_offset);
	((ValaCCodeNodeClass *) klass)->write = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_constant_real_write;
}

static void
vala_ccode_constant_instance_init (ValaCCodeConstant * self,
                                   gpointer klass)
{
	self->priv = vala_ccode_constant_get_instance_private (self);
}

static void
vala_ccode_constant_finalize (ValaCCodeNode * obj)
{
	ValaCCodeConstant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant);
	_g_free0 (self->priv->_name);
	VALA_CCODE_NODE_CLASS (vala_ccode_constant_parent_class)->finalize (obj);
}

/**
 * A constant C expression.
 */
GType
vala_ccode_constant_get_type (void)
{
	static volatile gsize vala_ccode_constant_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_constant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeConstantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_constant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeConstant), 0, (GInstanceInitFunc) vala_ccode_constant_instance_init, NULL };
		GType vala_ccode_constant_type_id;
		vala_ccode_constant_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeConstant", &g_define_type_info, 0);
		ValaCCodeConstant_private_offset = g_type_add_instance_private (vala_ccode_constant_type_id, sizeof (ValaCCodeConstantPrivate));
		g_once_init_leave (&vala_ccode_constant_type_id__volatile, vala_ccode_constant_type_id);
	}
	return vala_ccode_constant_type_id__volatile;
}

