#!/bin/bash
# Copyright (c) Microsoft. All rights reserved.
# Licensed under the MIT license. See LICENSE file in the project root for full license information.

set -e

cat >setup.txt <<EOL
$RASPI_USER
$RASPI_PWD

export IOTHUB_CONNECTION_STRING="$IOTHUB_CONNECTION_STRING"
export IOTHUB_EVENTHUB_CONNECTION_STRING="$IOTHUB_EVENTHUB_CONNECTION_STRING"
export IOTHUB_PARTITION_COUNT=16
export IOTHUB_E2E_X509_CERT_BASE64="$IOTHUB_E2E_X509_CERT_BASE64"
export IOTHUB_E2E_X509_PRIVATE_KEY_BASE64="$IOTHUB_E2E_X509_PRIVATE_KEY_BASE64"
export IOTHUB_E2E_X509_THUMBPRINT=$IOTHUB_E2E_X509_THUMBPRINT
export IOTHUB_POLICY_KEY=$IOTHUB_POLICY_KEY

export IOT_DPS_CONNECTION_STRING="$IOT_DPS_CONNECTION_STRING"
export IOT_DPS_ID_SCOPE=$IOT_DPS_ID_SCOPE
export IOTHUB_CA_ROOT_CERT=$IOTHUB_CA_ROOT_CERT
export IOTHUB_CA_ROOT_CERT_KEY=$IOTHUB_CA_ROOT_CERT_KEY
export IOT_DPS_GLOBAL_ENDPOINT="$IOT_DPS_GLOBAL_ENDPOINT"
export IOTHUB_DEVICE_CONN_STRING_INVALIDCERT="$IOTHUB_DEVICE_CONN_STRING_INVALIDCERT"
export IOTHUB_CONN_STRING_INVALIDCERT="$IOTHUB_CONN_STRING_INVALIDCERT"
export DPS_GLOBALDEVICEENDPOINT_INVALIDCERT="$DPS_GLOBALDEVICEENDPOINT_INVALIDCERT"
export PROVISIONING_CONNECTION_STRING_INVALIDCERT="$PROVISIONING_CONNECTION_STRING_INVALIDCERT"

EOL
