/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};

static gint ValaLocalVariable_private_offset;
static gpointer vala_local_variable_parent_class = NULL;

static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);

static inline gpointer
vala_local_variable_get_instance_private (ValaLocalVariable* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLocalVariable_private_offset);
}

/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}

ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}

static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}

static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp89_;
	ValaDataType* _tmp90_;
	gboolean _tmp91_ = FALSE;
	gboolean _tmp92_ = FALSE;
	gboolean _tmp93_ = FALSE;
	ValaArrayType* _tmp94_;
	gboolean _tmp106_ = FALSE;
	gboolean _tmp107_ = FALSE;
	gboolean _tmp108_ = FALSE;
	ValaArrayType* _tmp109_;
	gboolean _tmp120_ = FALSE;
	ValaExpression* _tmp121_;
	ValaExpression* _tmp122_;
	ValaSemanticAnalyzer* _tmp238_;
	ValaSemanticAnalyzer* _tmp239_;
	ValaSymbol* _tmp240_;
	ValaSymbol* _tmp241_;
	ValaScope* _tmp242_;
	ValaScope* _tmp243_;
	const gchar* _tmp244_;
	const gchar* _tmp245_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp246_;
	ValaSemanticAnalyzer* _tmp247_;
	ValaSymbol* _tmp248_;
	ValaSymbol* _tmp249_;
	ValaBlock* _tmp250_;
	ValaBlock* _tmp251_;
	gboolean _tmp253_;
	gboolean _tmp254_;
	gboolean result = FALSE;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_experimental_non_null (context);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_REFERENCE_TYPE (_tmp7_)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaArrayType* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaArrayType* _tmp12_;
			_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_code_node_ref0 (VALA_IS_ARRAY_TYPE (_tmp9_) ? ((ValaArrayType*) _tmp9_) : NULL);
			array_type = _tmp10_;
			_tmp12_ = array_type;
			if (_tmp12_ != NULL) {
				ValaArrayType* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = array_type;
				_tmp14_ = vala_array_type_get_fixed_length (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp11_ = _tmp15_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
			} else {
				ValaDataType* _tmp16_;
				ValaDataType* _tmp17_;
				_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp17_ = _tmp16_;
				vala_data_type_set_nullable (_tmp17_, TRUE);
			}
			_vala_code_node_unref0 (array_type);
		}
	}
	_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp21_ = _tmp20_;
		if (VALA_IS_VOID_TYPE (_tmp21_)) {
			ValaSourceReference* _tmp22_;
			ValaSourceReference* _tmp23_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			vala_report_error (_tmp23_, "'void' not supported as variable type");
			result = FALSE;
			return result;
		}
		_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp26_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		_tmp28_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp31_ = _tmp30_;
		vala_expression_set_target_type (_tmp29_, _tmp31_);
		_tmp32_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		if (VALA_IS_INITIALIZER_LIST (_tmp33_)) {
			ValaExpression* _tmp34_;
			ValaExpression* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			_tmp34_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp37_ = _tmp36_;
			initializer_size = _tmp37_;
			is_initializer_list = TRUE;
		}
		_tmp38_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp39_ = _tmp38_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp39_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp40_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == NULL) {
		ValaExpression* _tmp42_;
		ValaExpression* _tmp43_;
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		gboolean _tmp52_ = FALSE;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		ValaExpression* _tmp73_;
		ValaExpression* _tmp74_;
		ValaDataType* _tmp75_;
		ValaDataType* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		ValaDataType* _tmp80_;
		ValaDataType* _tmp81_;
		ValaDataType* _tmp82_;
		ValaExpression* _tmp83_;
		ValaExpression* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		ValaDataType* _tmp87_;
		ValaDataType* _tmp88_;
		_tmp42_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp43_ = _tmp42_;
		if (_tmp43_ == NULL) {
			ValaSourceReference* _tmp44_;
			ValaSourceReference* _tmp45_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp45_ = _tmp44_;
			vala_report_error (_tmp45_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp46_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			ValaSourceReference* _tmp50_;
			ValaSourceReference* _tmp51_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp51_ = _tmp50_;
			vala_report_error (_tmp51_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp53_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_expression_get_value_type (_tmp54_);
		_tmp56_ = _tmp55_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp56_)) {
			_tmp52_ = TRUE;
		} else {
			ValaExpression* _tmp57_;
			ValaExpression* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			_tmp57_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_expression_get_value_type (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp52_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp60_);
		}
		if (_tmp52_) {
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaSourceReference* _tmp63_;
			ValaSourceReference* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = vala_symbol_get_full_name (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp70_);
			_tmp72_ = _tmp71_;
			vala_report_error (_tmp64_, _tmp72_);
			_g_free0 (_tmp72_);
			_g_free0 (_tmp70_);
			result = FALSE;
			return result;
		}
		_tmp73_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_expression_get_value_type (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_data_type_copy (_tmp76_);
		_tmp78_ = _tmp77_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp78_);
		_vala_code_node_unref0 (_tmp78_);
		_tmp79_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp80_ = _tmp79_;
		vala_data_type_set_value_owned (_tmp80_, TRUE);
		_tmp81_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp82_ = _tmp81_;
		vala_data_type_set_floating_reference (_tmp82_, FALSE);
		_tmp83_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp86_ = _tmp85_;
		vala_expression_set_target_type (_tmp84_, _tmp86_);
		_tmp87_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp88_ = _tmp87_;
		vala_code_node_check ((ValaCodeNode*) _tmp88_, context);
	}
	_tmp89_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp90_ = _tmp89_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp90_) ? ((ValaArrayType*) _tmp90_) : NULL;
	_tmp94_ = variable_array_type;
	if (_tmp94_ != NULL) {
		ValaArrayType* _tmp95_;
		gboolean _tmp96_;
		gboolean _tmp97_;
		_tmp95_ = variable_array_type;
		_tmp96_ = vala_array_type_get_fixed_length (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp93_ = _tmp97_;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaExpression* _tmp98_;
		ValaExpression* _tmp99_;
		_tmp98_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp99_ = _tmp98_;
		_tmp92_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp99_);
	} else {
		_tmp92_ = FALSE;
	}
	if (_tmp92_) {
		ValaExpression* _tmp100_;
		ValaExpression* _tmp101_;
		ValaInitializerList* _tmp102_;
		ValaInitializerList* _tmp103_;
		_tmp100_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp103_ = _tmp102_;
		_tmp91_ = _tmp103_ == NULL;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaSourceReference* _tmp104_;
		ValaSourceReference* _tmp105_;
		_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp105_ = _tmp104_;
		vala_report_warning (_tmp105_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp109_ = variable_array_type;
	if (_tmp109_ != NULL) {
		ValaArrayType* _tmp110_;
		gboolean _tmp111_;
		gboolean _tmp112_;
		_tmp110_ = variable_array_type;
		_tmp111_ = vala_array_type_get_inline_allocated (_tmp110_);
		_tmp112_ = _tmp111_;
		_tmp108_ = _tmp112_;
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		ValaArrayType* _tmp113_;
		ValaExpression* _tmp114_;
		ValaExpression* _tmp115_;
		_tmp113_ = variable_array_type;
		_tmp114_ = vala_array_type_get_length (_tmp113_);
		_tmp115_ = _tmp114_;
		_tmp107_ = _tmp115_ == NULL;
	} else {
		_tmp107_ = FALSE;
	}
	if (_tmp107_) {
		ValaExpression* _tmp116_;
		ValaExpression* _tmp117_;
		_tmp116_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp117_ = _tmp116_;
		_tmp106_ = !VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp117_);
	} else {
		_tmp106_ = FALSE;
	}
	if (_tmp106_) {
		ValaSourceReference* _tmp118_;
		ValaSourceReference* _tmp119_;
		_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp119_ = _tmp118_;
		vala_report_error (_tmp119_, "Inline allocated array requires either a given length or an initialize" \
"r");
	}
	_tmp121_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp122_ = _tmp121_;
	if (_tmp122_ != NULL) {
		ValaExpression* _tmp123_;
		ValaExpression* _tmp124_;
		gboolean _tmp125_;
		gboolean _tmp126_;
		_tmp123_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_code_node_get_error ((ValaCodeNode*) _tmp124_);
		_tmp126_ = _tmp125_;
		_tmp120_ = !_tmp126_;
	} else {
		_tmp120_ = FALSE;
	}
	if (_tmp120_) {
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaDataType* _tmp129_;
		ValaDataType* _tmp130_;
		ValaExpression* _tmp176_;
		ValaExpression* _tmp177_;
		ValaDataType* _tmp178_;
		ValaDataType* _tmp179_;
		ValaDataType* _tmp180_;
		ValaDataType* _tmp181_;
		gboolean _tmp196_ = FALSE;
		gboolean _tmp197_ = FALSE;
		gboolean _tmp198_ = FALSE;
		ValaArrayType* _tmp199_;
		gboolean _tmp213_ = FALSE;
		gboolean _tmp214_ = FALSE;
		ValaArrayType* _tmp215_;
		ValaExpression* _tmp225_;
		ValaExpression* _tmp226_;
		ValaDataType* _tmp227_;
		ValaDataType* _tmp228_;
		_tmp127_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_expression_get_value_type (_tmp128_);
		_tmp130_ = _tmp129_;
		if (_tmp130_ == NULL) {
			gboolean _tmp131_ = FALSE;
			ValaExpression* _tmp132_;
			ValaExpression* _tmp133_;
			gboolean _tmp138_ = FALSE;
			ValaExpression* _tmp139_;
			ValaExpression* _tmp140_;
			ValaSymbol* _tmp141_;
			ValaSymbol* _tmp142_;
			_tmp132_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp133_ = _tmp132_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp133_)) {
				ValaExpression* _tmp134_;
				ValaExpression* _tmp135_;
				_tmp134_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp135_ = _tmp134_;
				_tmp131_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp135_);
			} else {
				_tmp131_ = FALSE;
			}
			if (_tmp131_) {
				ValaSourceReference* _tmp136_;
				ValaSourceReference* _tmp137_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp137_ = _tmp136_;
				vala_report_error (_tmp137_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp139_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_expression_get_symbol_reference (_tmp140_);
			_tmp142_ = _tmp141_;
			if (VALA_IS_METHOD (_tmp142_)) {
				ValaDataType* _tmp143_;
				ValaDataType* _tmp144_;
				_tmp143_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp144_ = _tmp143_;
				_tmp138_ = VALA_IS_DELEGATE_TYPE (_tmp144_);
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp145_;
				ValaExpression* _tmp146_;
				ValaSymbol* _tmp147_;
				ValaSymbol* _tmp148_;
				ValaMethod* _tmp149_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp150_;
				ValaDataType* _tmp151_;
				ValaDelegateType* _tmp152_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp153_;
				ValaDelegate* _tmp154_;
				ValaDelegate* _tmp155_;
				ValaDelegate* _tmp156_;
				ValaDelegate* _tmp157_;
				ValaMethod* _tmp158_;
				ValaDelegateType* _tmp159_;
				ValaExpression* _tmp170_;
				ValaExpression* _tmp171_;
				ValaDataType* _tmp172_;
				ValaDataType* _tmp173_;
				_tmp145_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp146_ = _tmp145_;
				_tmp147_ = vala_expression_get_symbol_reference (_tmp146_);
				_tmp148_ = _tmp147_;
				_tmp149_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp149_;
				_tmp150_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp151_ = _tmp150_;
				_tmp152_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp152_;
				_tmp153_ = dt;
				_tmp154_ = vala_delegate_type_get_delegate_symbol (_tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = _vala_code_node_ref0 (_tmp155_);
				cb = _tmp156_;
				_tmp157_ = cb;
				_tmp158_ = m;
				_tmp159_ = dt;
				if (!vala_delegate_matches_method (_tmp157_, _tmp158_, (ValaDataType*) _tmp159_)) {
					ValaSourceReference* _tmp160_;
					ValaSourceReference* _tmp161_;
					ValaMethod* _tmp162_;
					gchar* _tmp163_;
					gchar* _tmp164_;
					ValaDelegate* _tmp165_;
					gchar* _tmp166_;
					gchar* _tmp167_;
					gchar* _tmp168_;
					gchar* _tmp169_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp161_ = _tmp160_;
					_tmp162_ = m;
					_tmp163_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp162_);
					_tmp164_ = _tmp163_;
					_tmp165_ = cb;
					_tmp166_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp165_);
					_tmp167_ = _tmp166_;
					_tmp168_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp164_, _tmp167_);
					_tmp169_ = _tmp168_;
					vala_report_error (_tmp161_, _tmp169_);
					_g_free0 (_tmp169_);
					_g_free0 (_tmp167_);
					_g_free0 (_tmp164_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp170_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp173_ = _tmp172_;
				vala_expression_set_value_type (_tmp171_, _tmp173_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp174_;
				ValaSourceReference* _tmp175_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp175_ = _tmp174_;
				vala_report_error (_tmp175_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp176_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_expression_get_value_type (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp181_ = _tmp180_;
		if (!vala_data_type_compatible (_tmp179_, _tmp181_)) {
			ValaSourceReference* _tmp182_;
			ValaSourceReference* _tmp183_;
			ValaExpression* _tmp184_;
			ValaExpression* _tmp185_;
			ValaDataType* _tmp186_;
			ValaDataType* _tmp187_;
			gchar* _tmp188_;
			gchar* _tmp189_;
			ValaDataType* _tmp190_;
			ValaDataType* _tmp191_;
			gchar* _tmp192_;
			gchar* _tmp193_;
			gchar* _tmp194_;
			gchar* _tmp195_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp183_ = _tmp182_;
			_tmp184_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp185_ = _tmp184_;
			_tmp186_ = vala_expression_get_value_type (_tmp185_);
			_tmp187_ = _tmp186_;
			_tmp188_ = vala_code_node_to_string ((ValaCodeNode*) _tmp187_);
			_tmp189_ = _tmp188_;
			_tmp190_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp191_ = _tmp190_;
			_tmp192_ = vala_code_node_to_string ((ValaCodeNode*) _tmp191_);
			_tmp193_ = _tmp192_;
			_tmp194_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp189_, _tmp193_);
			_tmp195_ = _tmp194_;
			vala_report_error (_tmp183_, _tmp195_);
			_g_free0 (_tmp195_);
			_g_free0 (_tmp193_);
			_g_free0 (_tmp189_);
			result = FALSE;
			return result;
		}
		_tmp199_ = variable_array_type;
		if (_tmp199_ != NULL) {
			ValaArrayType* _tmp200_;
			gboolean _tmp201_;
			gboolean _tmp202_;
			_tmp200_ = variable_array_type;
			_tmp201_ = vala_array_type_get_inline_allocated (_tmp200_);
			_tmp202_ = _tmp201_;
			_tmp198_ = _tmp202_;
		} else {
			_tmp198_ = FALSE;
		}
		if (_tmp198_) {
			ValaArrayType* _tmp203_;
			gboolean _tmp204_;
			gboolean _tmp205_;
			_tmp203_ = variable_array_type;
			_tmp204_ = vala_array_type_get_fixed_length (_tmp203_);
			_tmp205_ = _tmp204_;
			_tmp197_ = !_tmp205_;
		} else {
			_tmp197_ = FALSE;
		}
		if (_tmp197_) {
			_tmp196_ = is_initializer_list;
		} else {
			_tmp196_ = FALSE;
		}
		if (_tmp196_) {
			ValaArrayType* _tmp206_;
			gchar* _tmp207_;
			gchar* _tmp208_;
			ValaIntegerLiteral* _tmp209_;
			ValaIntegerLiteral* _tmp210_;
			ValaArrayType* _tmp211_;
			ValaArrayType* _tmp212_;
			_tmp206_ = variable_array_type;
			_tmp207_ = g_strdup_printf ("%i", initializer_size);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_integer_literal_new (_tmp208_, NULL);
			_tmp210_ = _tmp209_;
			vala_array_type_set_length (_tmp206_, (ValaExpression*) _tmp210_);
			_vala_code_node_unref0 (_tmp210_);
			_g_free0 (_tmp208_);
			_tmp211_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp211_, TRUE);
			_tmp212_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp212_, FALSE);
		}
		_tmp215_ = variable_array_type;
		if (_tmp215_ != NULL) {
			ValaArrayType* _tmp216_;
			gboolean _tmp217_;
			gboolean _tmp218_;
			_tmp216_ = variable_array_type;
			_tmp217_ = vala_array_type_get_inline_allocated (_tmp216_);
			_tmp218_ = _tmp217_;
			_tmp214_ = _tmp218_;
		} else {
			_tmp214_ = FALSE;
		}
		if (_tmp214_) {
			ValaExpression* _tmp219_;
			ValaExpression* _tmp220_;
			ValaDataType* _tmp221_;
			ValaDataType* _tmp222_;
			_tmp219_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp220_ = _tmp219_;
			_tmp221_ = vala_expression_get_value_type (_tmp220_);
			_tmp222_ = _tmp221_;
			_tmp213_ = VALA_IS_ARRAY_TYPE (_tmp222_) == FALSE;
		} else {
			_tmp213_ = FALSE;
		}
		if (_tmp213_) {
			ValaSourceReference* _tmp223_;
			ValaSourceReference* _tmp224_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp224_ = _tmp223_;
			vala_report_error (_tmp224_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp225_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp226_ = _tmp225_;
		_tmp227_ = vala_expression_get_value_type (_tmp226_);
		_tmp228_ = _tmp227_;
		if (vala_data_type_is_disposable (_tmp228_)) {
			gboolean _tmp229_ = FALSE;
			ValaDataType* _tmp230_;
			ValaDataType* _tmp231_;
			_tmp230_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp231_ = _tmp230_;
			if (!VALA_IS_POINTER_TYPE (_tmp231_)) {
				ValaDataType* _tmp232_;
				ValaDataType* _tmp233_;
				gboolean _tmp234_;
				gboolean _tmp235_;
				_tmp232_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp233_ = _tmp232_;
				_tmp234_ = vala_data_type_get_value_owned (_tmp233_);
				_tmp235_ = _tmp234_;
				_tmp229_ = !_tmp235_;
			} else {
				_tmp229_ = FALSE;
			}
			if (_tmp229_) {
				ValaSourceReference* _tmp236_;
				ValaSourceReference* _tmp237_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp237_ = _tmp236_;
				vala_report_error (_tmp237_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp238_ = vala_code_context_get_analyzer (context);
	_tmp239_ = _tmp238_;
	_tmp240_ = vala_semantic_analyzer_get_current_symbol (_tmp239_);
	_tmp241_ = _tmp240_;
	_tmp242_ = vala_symbol_get_scope (_tmp241_);
	_tmp243_ = _tmp242_;
	_tmp244_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp245_ = _tmp244_;
	vala_scope_add (_tmp243_, _tmp245_, (ValaSymbol*) self);
	_tmp246_ = vala_code_context_get_analyzer (context);
	_tmp247_ = _tmp246_;
	_tmp248_ = vala_semantic_analyzer_get_current_symbol (_tmp247_);
	_tmp249_ = _tmp248_;
	_tmp250_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp249_) ? ((ValaBlock*) _tmp249_) : NULL);
	block = _tmp250_;
	_tmp251_ = block;
	if (_tmp251_ != NULL) {
		ValaBlock* _tmp252_;
		_tmp252_ = block;
		vala_block_add_local_variable (_tmp252_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp253_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp254_ = _tmp253_;
	result = !_tmp254_;
	_vala_code_node_unref0 (block);
	return result;
}

gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}

void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}

gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_init;
	return result;
}

void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}

static void
vala_local_variable_class_init (ValaLocalVariableClass * klass,
                                gpointer klass_data)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLocalVariable_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}

static void
vala_local_variable_instance_init (ValaLocalVariable * self,
                                   gpointer klass)
{
	self->priv = vala_local_variable_get_instance_private (self);
}

static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}

/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		ValaLocalVariable_private_offset = g_type_add_instance_private (vala_local_variable_type_id, sizeof (ValaLocalVariablePrivate));
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}

