/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.ContentEmitter;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.StylesheetStripper;
import com.icl.saxon.TransformerFactoryImpl;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.style.StyleNodeFactory;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.TreeBuilder;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TemplatesHandler;

public class TemplatesHandlerImpl
extends ContentEmitter
implements TemplatesHandler {
    TransformerFactoryImpl factory;
    TreeBuilder builder;
    Templates templates;
    String systemId;

    protected TemplatesHandlerImpl(TransformerFactoryImpl transformerFactoryImpl) {
        NamePool namePool = NamePool.getDefaultNamePool();
        this.setNamePool(namePool);
        this.factory = transformerFactoryImpl;
        this.builder = new TreeBuilder();
        this.builder.setNamePool(namePool);
        StyleNodeFactory styleNodeFactory = new StyleNodeFactory(namePool);
        StylesheetStripper stylesheetStripper = new StylesheetStripper();
        stylesheetStripper.setStylesheetRules(namePool);
        this.builder = new TreeBuilder();
        this.builder.setNamePool(namePool);
        this.builder.setStripper(stylesheetStripper);
        this.builder.setNodeFactory(styleNodeFactory);
        this.builder.setDiscardCommentsAndPIs(true);
        this.builder.setLineNumbering(true);
        this.setEmitter(stylesheetStripper);
        stylesheetStripper.setUnderlyingEmitter(this.builder);
    }

    public Templates getTemplates() {
        if (this.templates == null) {
            DocumentImpl documentImpl = (DocumentImpl)this.builder.getCurrentDocument();
            if (documentImpl == null) {
                return null;
            }
            PreparedStyleSheet preparedStyleSheet = new PreparedStyleSheet(this.factory);
            try {
                preparedStyleSheet.setStyleSheetDocument(documentImpl);
                this.templates = preparedStyleSheet;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                System.err.println(transformerConfigurationException.getMessage());
                return null;
            }
        }
        return this.templates;
    }

    public void setSystemId(String string) {
        this.systemId = string;
        this.builder.setSystemId(string);
    }

    public String getSystemId() {
        return this.systemId;
    }
}

