/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class JSDocInfoPrinter {
    private final boolean useOriginalName;
    private final boolean printDesc;

    public JSDocInfoPrinter(boolean useOriginalName) {
        this(useOriginalName, false);
    }

    public JSDocInfoPrinter(boolean useOriginalName, boolean printDesc) {
        this.useOriginalName = useOriginalName;
        this.printDesc = printDesc;
    }

    public String print(JSDocInfo info) {
        String cleaned;
        Set<String> suppressions;
        ImmutableMap<String, Node> typeTransformations;
        ImmutableList<String> names;
        Object typeNode;
        Iterator<String> typeNode2;
        String description;
        boolean multiline = false;
        ArrayList<String> parts = new ArrayList<String>();
        parts.add("/**");
        if (info.isExterns()) {
            parts.add("@externs");
        } else if (info.isTypeSummary()) {
            parts.add("@typeSummary");
        }
        if (info.isExport()) {
            parts.add("@export");
        } else if (info.getVisibility() != null && info.getVisibility() != JSDocInfo.Visibility.INHERITED) {
            parts.add("@" + info.getVisibility().toString().toLowerCase());
        }
        if (info.isAbstract()) {
            parts.add("@abstract");
        }
        if (info.hasLendsName()) {
            parts.add(this.buildAnnotationWithType("lends", info.getLendsName().getRoot()));
        }
        if (info.hasConstAnnotation() && !info.isDefine()) {
            parts.add("@const");
        }
        if (info.isFinal()) {
            parts.add("@final");
        }
        if ((description = info.getDescription()) != null) {
            multiline = true;
            parts.add("@desc " + description);
        }
        if (info.isWizaction()) {
            parts.add("@wizaction");
        }
        if (info.isPolymerBehavior()) {
            parts.add("@polymerBehavior");
        }
        if (info.isPolymer()) {
            parts.add("@polymer");
        }
        if (info.isCustomElement()) {
            parts.add("@customElement");
        }
        if (info.isMixinClass()) {
            parts.add("@mixinClass");
        }
        if (info.isMixinFunction()) {
            parts.add("@mixinFunction");
        }
        if (info.isDisposes()) {
            parts.add("@disposes");
        }
        if (info.isExpose()) {
            parts.add("@expose");
        }
        if (info.isNoSideEffects()) {
            parts.add("@nosideeffects");
        }
        if (info.isNoCompile()) {
            parts.add("@nocompile");
        }
        if (info.isNoInline()) {
            parts.add("@noinline");
        }
        if (info.isIdGenerator()) {
            parts.add("@idGenerator {unique}");
        }
        if (info.isConsistentIdGenerator()) {
            parts.add("@idGenerator {consistent}");
        }
        if (info.isStableIdGenerator()) {
            parts.add("@idGenerator {stable}");
        }
        if (info.isXidGenerator()) {
            parts.add("@idGenerator {xid}");
        }
        if (info.isMappedIdGenerator()) {
            parts.add("@idGenerator {mapped}");
        }
        if (info.makesDicts()) {
            parts.add("@dict");
        }
        if (info.makesStructs()) {
            parts.add("@struct");
        }
        if (info.makesUnrestricted()) {
            parts.add("@unrestricted ");
        }
        if (info.isConstructor()) {
            parts.add("@constructor");
        }
        if (info.isInterface() && !info.usesImplicitMatch()) {
            parts.add("@interface");
        }
        if (info.isInterface() && info.usesImplicitMatch()) {
            parts.add("@record");
        }
        if (info.hasBaseType()) {
            multiline = true;
            typeNode2 = this.stripBang(info.getBaseType().getRoot());
            parts.add(this.buildAnnotationWithType("extends", (Node)((Object)typeNode2)));
        }
        for (JSTypeExpression type : info.getExtendedInterfaces()) {
            multiline = true;
            typeNode = this.stripBang(type.getRoot());
            parts.add(this.buildAnnotationWithType("extends", (Node)typeNode));
        }
        for (JSTypeExpression type : info.getImplementedInterfaces()) {
            multiline = true;
            typeNode = this.stripBang(type.getRoot());
            parts.add(this.buildAnnotationWithType("implements", (Node)typeNode));
        }
        if (info.hasThisType()) {
            multiline = true;
            typeNode2 = this.stripBang(info.getThisType().getRoot());
            parts.add(this.buildAnnotationWithType("this", (Node)((Object)typeNode2)));
        }
        if (info.getParameterCount() > 0) {
            multiline = true;
            for (String name : info.getParameterNames()) {
                parts.add("@param " + this.buildParamType(info, name));
            }
        }
        if (info.hasReturnType()) {
            multiline = true;
            parts.add(this.buildAnnotationWithType("return", info.getReturnType(), info.getReturnDescription()));
        }
        if (!info.getThrownTypes().isEmpty()) {
            parts.add(this.buildAnnotationWithType("throws", info.getThrownTypes().get(0)));
        }
        if (!(names = info.getTemplateTypeNames()).isEmpty()) {
            parts.add("@template " + Joiner.on(", ").join(names));
            multiline = true;
        }
        if (!(typeTransformations = info.getTypeTransformations()).isEmpty()) {
            multiline = true;
            for (Map.Entry e : typeTransformations.entrySet()) {
                String name = (String)e.getKey();
                String tranformationDefinition = new CodePrinter.Builder((Node)e.getValue()).build();
                parts.add("@template " + name + " := " + tranformationDefinition + " =:");
            }
        }
        if (info.isOverride()) {
            parts.add("@override");
        }
        if (info.hasType() && !info.isDefine()) {
            if (info.isInlineType()) {
                parts.add(this.typeNode(info.getType().getRoot()));
            } else {
                parts.add(this.buildAnnotationWithType("type", info.getType()));
            }
        }
        if (info.isDefine()) {
            parts.add(this.buildAnnotationWithType("define", info.getType()));
        }
        if (info.hasTypedefType()) {
            parts.add(this.buildAnnotationWithType("typedef", info.getTypedefType()));
        }
        if (info.hasEnumParameterType()) {
            parts.add(this.buildAnnotationWithType("enum", info.getEnumParameterType()));
        }
        if (info.isImplicitCast()) {
            parts.add("@implicitCast");
        }
        if (info.isNoCollapse()) {
            parts.add("@nocollapse");
        }
        if (!(suppressions = info.getSuppressions()).isEmpty()) {
            Object[] arr = suppressions.toArray(new String[0]);
            Arrays.sort(arr, Ordering.natural());
            parts.add("@suppress {" + Joiner.on(',').join(arr) + "}");
            multiline = true;
        }
        if (info.isDeprecated()) {
            parts.add("@deprecated " + info.getDeprecationReason());
            multiline = true;
        }
        if (info.isPolymer()) {
            multiline = true;
            parts.add("@polymer");
        }
        if (info.isPolymerBehavior()) {
            multiline = true;
            parts.add("@polymerBehavior");
        }
        if (info.isMixinFunction()) {
            multiline = true;
            parts.add("@mixinFunction");
        }
        if (info.isMixinClass()) {
            multiline = true;
            parts.add("@mixinClass");
        }
        if (info.isCustomElement()) {
            multiline = true;
            parts.add("@customElement");
        }
        if (info.getClosurePrimitiveId() != null) {
            parts.add("@closurePrimitive {" + info.getClosurePrimitiveId() + "}");
        }
        if (info.isNgInject()) {
            parts.add("@ngInject");
        }
        if (this.printDesc && info.getBlockDescription() != null && !(cleaned = info.getBlockDescription().replaceAll("\n\\s*\\*\\s*", "\n")).isEmpty()) {
            multiline = true;
            cleaned = cleaned.trim();
            if (parts.size() > 1) {
                cleaned = cleaned + '\n';
            }
            parts.add(1, cleaned);
        }
        StringBuilder sb = new StringBuilder();
        if (multiline) {
            Joiner.on("\n").appendTo(sb, (Iterable<?>)parts);
        } else {
            Joiner.on(" ").appendTo(sb, (Iterable<?>)parts);
            sb.append(" */");
        }
        String s = sb.toString().replaceAll("\n", "\n *").replaceAll("\n \\*([^ \n])", "\n * $1");
        s = multiline ? s + "\n */\n" : s + " ";
        return s;
    }

    private Node stripBang(Node typeNode) {
        if (typeNode.getToken() == Token.BANG) {
            typeNode = typeNode.getFirstChild();
        }
        return typeNode;
    }

    private String buildAnnotationWithType(String annotation, JSTypeExpression type) {
        return this.buildAnnotationWithType(annotation, type, null);
    }

    private String buildAnnotationWithType(String annotation, JSTypeExpression type, String description) {
        return this.buildAnnotationWithType(annotation, type.getRoot(), description);
    }

    private String buildAnnotationWithType(String annotation, Node type) {
        return this.buildAnnotationWithType(annotation, type, null);
    }

    private String buildAnnotationWithType(String annotation, Node type, String description) {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(annotation);
        sb.append(" {");
        this.appendTypeNode(sb, type);
        sb.append("}");
        if (description != null) {
            sb.append(" ");
            sb.append(description);
        }
        return sb.toString();
    }

    private String buildParamType(JSDocInfo info, String name) {
        JSTypeExpression type = info.getParameterType(name);
        if (type != null) {
            String p = "{" + this.typeNode(type.getRoot()) + "} " + name + (this.printDesc && info.getDescriptionForParameter(name) != null ? info.getDescriptionForParameter(name) : "");
            return p.trim();
        }
        return name;
    }

    private String typeNode(Node typeNode) {
        StringBuilder sb = new StringBuilder();
        this.appendTypeNode(sb, typeNode);
        return sb.toString();
    }

    private void appendTypeNode(StringBuilder sb, Node typeNode) {
        if (this.useOriginalName && typeNode.getOriginalName() != null) {
            sb.append(typeNode.getOriginalName());
            return;
        }
        if (typeNode.getToken() == Token.BANG) {
            sb.append("!");
            this.appendTypeNode(sb, typeNode.getFirstChild());
        } else if (typeNode.getToken() == Token.EQUALS) {
            this.appendTypeNode(sb, typeNode.getFirstChild());
            sb.append("=");
        } else if (typeNode.getToken() == Token.PIPE) {
            sb.append("(");
            Node lastChild = typeNode.getLastChild();
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.appendTypeNode(sb, child);
                if (child == lastChild) continue;
                sb.append("|");
            }
            sb.append(")");
        } else if (typeNode.getToken() == Token.ITER_REST) {
            sb.append("...");
            if (typeNode.hasChildren() && !typeNode.getFirstChild().isEmpty()) {
                this.appendTypeNode(sb, typeNode.getFirstChild());
            }
        } else if (typeNode.getToken() == Token.STAR) {
            sb.append("*");
        } else if (typeNode.getToken() == Token.QMARK) {
            sb.append("?");
            if (typeNode.hasChildren()) {
                this.appendTypeNode(sb, typeNode.getFirstChild());
            }
        } else if (typeNode.isFunction()) {
            this.appendFunctionNode(sb, typeNode);
        } else if (typeNode.getToken() == Token.LC) {
            sb.append("{");
            Node lb = typeNode.getFirstChild();
            Node lastColon = lb.getLastChild();
            for (Node colon = lb.getFirstChild(); colon != null; colon = colon.getNext()) {
                if (colon.hasChildren()) {
                    sb.append(colon.getFirstChild().getString()).append(":");
                    this.appendTypeNode(sb, colon.getLastChild());
                } else {
                    sb.append(colon.getString());
                }
                if (colon == lastColon) continue;
                sb.append(",");
            }
            sb.append("}");
        } else if (typeNode.isVoid()) {
            sb.append("void");
        } else if (typeNode.isTypeOf()) {
            sb.append("typeof ");
            this.appendTypeNode(sb, typeNode.getFirstChild());
        } else if (typeNode.hasChildren()) {
            sb.append(typeNode.getString()).append("<");
            Node child = typeNode.getFirstChild();
            Node last = child.getLastChild();
            for (Node type = child.getFirstChild(); type != null; type = type.getNext()) {
                this.appendTypeNode(sb, type);
                if (type == last) continue;
                sb.append(",");
            }
            sb.append(">");
        } else {
            sb.append(typeNode.getString());
        }
    }

    private void appendFunctionNode(StringBuilder sb, Node function) {
        boolean hasNewOrThis = false;
        sb.append("function(");
        Node first = function.getFirstChild();
        if (first.isNew()) {
            sb.append("new:");
            this.appendTypeNode(sb, first.getFirstChild());
            hasNewOrThis = true;
        } else if (first.isThis()) {
            sb.append("this:");
            this.appendTypeNode(sb, first.getFirstChild());
            hasNewOrThis = true;
        } else {
            if (first.isEmpty()) {
                sb.append(")");
                return;
            }
            if (!first.isParamList()) {
                sb.append("):");
                this.appendTypeNode(sb, first);
                return;
            }
        }
        Node paramList = null;
        if (first.isParamList()) {
            paramList = first;
        } else if (first.getNext().isParamList()) {
            paramList = first.getNext();
        }
        if (paramList != null) {
            boolean firstParam = true;
            for (Node param : paramList.children()) {
                if (!firstParam || hasNewOrThis) {
                    sb.append(",");
                }
                this.appendTypeNode(sb, param);
                firstParam = false;
            }
        }
        sb.append(")");
        Node returnType = function.getLastChild();
        if (!returnType.isEmpty()) {
            sb.append(":");
            this.appendTypeNode(sb, returnType);
        }
    }
}

