/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Export;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.Node;
import java.util.List;
import javax.annotation.Nullable;

final class ModuleRenaming {
    static final String DEFAULT_EXPORT_VAR_PREFIX = "$jscompDefaultExport";

    private ModuleRenaming() {
    }

    static String getGlobalNameOfEsModuleLocalVariable(ModuleMetadataMap.ModuleMetadata moduleMetadata, String variableName) {
        return variableName + "$$" + ModuleRenaming.getGlobalName(moduleMetadata, null);
    }

    static String getGlobalNameOfAnonymousDefaultExport(ModuleMetadataMap.ModuleMetadata moduleMetadata) {
        return ModuleRenaming.getGlobalNameOfEsModuleLocalVariable(moduleMetadata, DEFAULT_EXPORT_VAR_PREFIX);
    }

    static String getGlobalName(ModuleMetadataMap.ModuleMetadata moduleMetadata, @Nullable String googNamespace) {
        Preconditions.checkState(googNamespace == null || moduleMetadata.googNamespaces().contains(googNamespace));
        switch (moduleMetadata.moduleType()) {
            case GOOG_MODULE: {
                return ClosureRewriteModule.getBinaryModuleNamespace(googNamespace);
            }
            case GOOG_PROVIDE: 
            case LEGACY_GOOG_MODULE: {
                return Preconditions.checkNotNull(googNamespace);
            }
            case ES6_MODULE: 
            case COMMON_JS: {
                return moduleMetadata.path().toModuleName();
            }
        }
        throw new IllegalStateException("Unexpected module type: " + (Object)((Object)moduleMetadata.moduleType()));
    }

    static String getGlobalName(Export export) {
        if (export.moduleMetadata().isEs6Module()) {
            if (export.localName().equals("*default*")) {
                return ModuleRenaming.getGlobalNameOfAnonymousDefaultExport(export.moduleMetadata());
            }
            return ModuleRenaming.getGlobalNameOfEsModuleLocalVariable(export.moduleMetadata(), export.localName());
        }
        return ModuleRenaming.getGlobalName(export.moduleMetadata(), export.closureNamespace()) + "." + export.exportName();
    }

    static String getGlobalName(Binding binding) {
        if (binding.isModuleNamespace()) {
            return ModuleRenaming.getGlobalName(binding.metadata(), binding.closureNamespace());
        }
        return ModuleRenaming.getGlobalName(binding.originatingExport());
    }

    static String getGlobalNameForJsDoc(ModuleMap moduleMap, Binding binding, List<String> propertyChain) {
        int prop;
        for (prop = 0; binding.isModuleNamespace() && binding.metadata().isEs6Module() && prop < propertyChain.size(); ++prop) {
            String propertyName = propertyChain.get(prop);
            Module m = moduleMap.getModule(binding.metadata().path());
            if (!m.namespace().containsKey(propertyName)) break;
            binding = m.namespace().get(propertyName);
        }
        String globalName = ModuleRenaming.getGlobalName(binding);
        if (prop < propertyChain.size()) {
            globalName = globalName + "." + Joiner.on('.').join(propertyChain.subList(prop, propertyChain.size()));
        }
        return globalName;
    }

    static Node replace(AbstractCompiler compiler, ModuleMap moduleMap, Binding binding, Node nameNode) {
        Preconditions.checkState(nameNode.isName());
        Node n = nameNode;
        while (binding.isModuleNamespace() && binding.metadata().isEs6Module() && n.getParent().isGetProp()) {
            String propertyName = n.getParent().getSecondChild().getString();
            Module m = moduleMap.getModule(binding.metadata().path());
            if (!m.namespace().containsKey(propertyName)) break;
            binding = m.namespace().get(propertyName);
            n = n.getParent();
        }
        String globalName = ModuleRenaming.getGlobalName(binding);
        Node newNode = NodeUtil.newQName(compiler, globalName);
        Node forSourceInfo = n.isGetProp() ? n.getSecondChild() : n;
        n.replaceWith(newNode);
        newNode.srcrefTree(forSourceInfo);
        newNode.setOriginalName(forSourceInfo.getString());
        return newNode;
    }
}

