/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class ProcessDefines
implements CompilerPass {
    private static final Logger logger = Logger.getLogger("com.google.javascript.jscomp.ProcessDefines");
    private static final ImmutableSet<String> KNOWN_DEFINES = ImmutableSet.of("COMPILED", "goog.DEBUG");
    private final AbstractCompiler compiler;
    private final Map<String, Node> dominantReplacements;
    private final boolean checksOnly;
    private final Supplier<GlobalNamespace> namespaceSupplier;
    static final DiagnosticType UNKNOWN_DEFINE_WARNING = DiagnosticType.warning("JSC_UNKNOWN_DEFINE_WARNING", "unknown @define variable {0}");
    static final DiagnosticType INVALID_DEFINE_TYPE_ERROR = DiagnosticType.error("JSC_INVALID_DEFINE_TYPE_ERROR", "@define tag only permits literal types");
    static final DiagnosticType INVALID_DEFINE_INIT_ERROR = DiagnosticType.error("JSC_INVALID_DEFINE_INIT_ERROR", "illegal initialization of @define variable {0}");
    static final DiagnosticType NON_GLOBAL_DEFINE_INIT_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_DEFINE_INIT_ERROR", "@define variable {0} assignment must be global");
    static final DiagnosticType DEFINE_NOT_ASSIGNABLE_ERROR = DiagnosticType.error("JSC_DEFINE_NOT_ASSIGNABLE_ERROR", "@define variable {0} cannot be reassigned due to code at {1}.");
    private static final MessageFormat REASON_DEFINE_NOT_ASSIGNABLE = new MessageFormat("line {0} of {1}");

    private ProcessDefines(Builder builder) {
        this.compiler = builder.compiler;
        this.dominantReplacements = ImmutableMap.copyOf(builder.replacements);
        this.checksOnly = builder.checksOnly;
        this.namespaceSupplier = builder.namespaceSupplier;
    }

    @Override
    public void process(Node externs, Node root) {
        this.overrideDefines(this.collectDefines(externs, root));
    }

    private void overrideDefines(Map<String, DefineInfo> allDefines) {
        if (!this.checksOnly) {
            for (Map.Entry<String, DefineInfo> def : allDefines.entrySet()) {
                boolean changed;
                String defineName = def.getKey();
                DefineInfo info = def.getValue();
                Node inputValue = this.dominantReplacements.get(defineName);
                Node finalValue = inputValue != null ? inputValue : info.getLastValue();
                if (finalValue == info.initialValue) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Overriding @define variable " + defineName);
                }
                if (!(changed = finalValue.getToken() != info.initialValue.getToken() || !finalValue.isEquivalentTo(info.initialValue))) continue;
                info.initialValueParent.replaceChild(info.initialValue, finalValue.cloneTree());
                if (!changed) continue;
                this.compiler.reportChangeToEnclosingScope(info.initialValueParent);
            }
        }
        Sets.SetView<String> unusedReplacements = Sets.difference(this.dominantReplacements.keySet(), Sets.union(KNOWN_DEFINES, allDefines.keySet()));
        for (String unknownDefine : unusedReplacements) {
            this.compiler.report(JSError.make(UNKNOWN_DEFINE_WARNING, unknownDefine));
        }
    }

    private static String format(MessageFormat format, Object ... params) {
        return format.format(params);
    }

    private boolean isValidDefineType(JSTypeExpression expression) {
        JSTypeRegistry registry = this.compiler.getTypeRegistry();
        JSType type = registry.evaluateTypeExpressionInGlobalScope(expression);
        return !type.isUnknownType() && type.isSubtypeOf(registry.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN));
    }

    Map<String, DefineInfo> collectDefines(Node externs, Node root) {
        GlobalNamespace namespace = null;
        if (this.namespaceSupplier != null) {
            namespace = this.namespaceSupplier.get();
        }
        if (namespace == null) {
            namespace = new GlobalNamespace(this.compiler, externs, root);
        }
        ArrayList<GlobalNamespace.Name> listOfDefines = new ArrayList<GlobalNamespace.Name>();
        block0: for (GlobalNamespace.Name name : namespace.getNameIndex().values()) {
            GlobalNamespace.Ref decl = name.getDeclaration();
            if (name.getJSDocInfo() != null && name.getJSDocInfo().isDefine()) {
                if (this.isValidDefineType(name.getJSDocInfo().getType())) {
                    listOfDefines.add(name);
                    continue;
                }
                JSError error = JSError.make(decl.getNode(), INVALID_DEFINE_TYPE_ERROR, new String[0]);
                this.compiler.report(error);
                continue;
            }
            for (GlobalNamespace.Ref ref : name.getRefs()) {
                if (ref == decl) continue;
                Node n = ref.getNode();
                Node parent = ref.getNode().getParent();
                JSDocInfo info = n.getJSDocInfo();
                if (info == null && parent.isVar() && parent.hasOneChild()) {
                    info = parent.getJSDocInfo();
                }
                if (info == null || !info.isDefine()) continue;
                listOfDefines.add(name);
                continue block0;
            }
        }
        CollectDefines pass = new CollectDefines(namespace, listOfDefines);
        NodeTraversal.traverseRoots(this.compiler, pass, externs, root);
        return pass.allDefines;
    }

    private static Node getConstantDeclValue(Node name) {
        Node parent = name.getParent();
        if (parent == null) {
            return null;
        }
        if (name.isName()) {
            if (parent.isConst()) {
                return name.getFirstChild();
            }
            if (!parent.isVar()) {
                return null;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(name);
            return jsdoc != null && jsdoc.isConstant() ? name.getFirstChild() : null;
        }
        if (name.isGetProp() && parent.isAssign()) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(name);
            return jsdoc != null && jsdoc.isConstant() ? name.getNext() : null;
        }
        return null;
    }

    private static void setDefineInfoNotAssignable(DefineInfo info, NodeTraversal t) {
        info.setNotAssignable(ProcessDefines.format(REASON_DEFINE_NOT_ASSIGNABLE, t.getLineNumber(), t.getSourceName()));
    }

    private static final class DefineInfo {
        public final Node initialValueParent;
        @Nullable
        public final Node initialValue;
        private Node lastValue;
        private boolean isAssignable;
        private String reasonNotAssignable;

        public DefineInfo(@Nullable Node initialValue, Node initialValueParent) {
            Preconditions.checkState(initialValue != null || initialValueParent.isFromExterns());
            this.initialValueParent = initialValueParent;
            this.initialValue = initialValue;
            this.lastValue = initialValue;
            this.isAssignable = true;
        }

        public void setNotAssignable(String reason) {
            this.isAssignable = false;
            this.reasonNotAssignable = reason;
        }

        public String getReasonWhyNotAssignable() {
            return this.reasonNotAssignable;
        }

        public boolean recordAssignment(Node value) {
            this.lastValue = value;
            return this.isAssignable;
        }

        public Node getLastValue() {
            return this.lastValue;
        }
    }

    private static class RefInfo {
        final GlobalNamespace.Ref ref;
        final GlobalNamespace.Name name;

        RefInfo(GlobalNamespace.Ref ref, GlobalNamespace.Name name) {
            this.ref = ref;
            this.name = name;
        }
    }

    private final class CollectDefines
    implements NodeTraversal.Callback {
        private final Map<String, DefineInfo> assignableDefines = new HashMap<String, DefineInfo>();
        private final Map<String, DefineInfo> allDefines = new HashMap<String, DefineInfo>();
        private final Map<Node, RefInfo> allRefInfo = new HashMap<Node, RefInfo>();
        private final Set<Node> validDefineAliases = new HashSet<Node>();
        private Node lvalueToRemoveLater = null;
        private final Deque<Integer> assignAllowed = new ArrayDeque<Integer>();

        CollectDefines(GlobalNamespace namespace, List<GlobalNamespace.Name> listOfDefines) {
            this.assignAllowed.push(1);
            HashSet symbols = new HashSet();
            Iterables.addAll(symbols, namespace.getAllSymbols());
            for (GlobalNamespace.Name name : listOfDefines) {
                symbols.remove(name);
                GlobalNamespace.Ref decl = name.getDeclaration();
                if (decl != null) {
                    this.allRefInfo.put(decl.getNode(), new RefInfo(decl, name));
                }
                for (GlobalNamespace.Ref ref : name.getRefs()) {
                    if (ref == decl || ref.getTwin() != null && ref.getTwin().isSet()) continue;
                    this.allRefInfo.put(ref.getNode(), new RefInfo(ref, name));
                }
            }
            Iterables.addAll(this.validDefineAliases, this.allRefInfo.keySet());
            boolean repeat = true;
            while (repeat) {
                repeat = false;
                HashSet<GlobalNamespace.Name> indeterminateNames = new HashSet<GlobalNamespace.Name>();
                for (GlobalNamespace.Name name : symbols) {
                    TernaryValue validDefine;
                    if (name.getDeclaration() == null) continue;
                    Node declValue = ProcessDefines.getConstantDeclValue(name.getDeclaration().getNode());
                    TernaryValue ternaryValue = validDefine = declValue != null ? this.isValidDefineValue(declValue) : TernaryValue.FALSE;
                    if (validDefine.toBoolean(false)) {
                        for (GlobalNamespace.Ref ref : name.getRefs()) {
                            this.validDefineAliases.add(ref.getNode());
                        }
                        repeat = true;
                    }
                    if (validDefine != TernaryValue.UNKNOWN) continue;
                    indeterminateNames.add(name);
                }
                symbols = indeterminateNames;
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            this.updateAssignAllowedStack(n, true);
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            RefInfo refInfo = this.allRefInfo.get(n);
            if (refInfo != null) {
                GlobalNamespace.Ref ref = refInfo.ref;
                GlobalNamespace.Name name = refInfo.name;
                String fullName = MoreObjects.firstNonNull(ref.getNode().getDefineName(), name.getFullName());
                switch (ref.type) {
                    case SET_FROM_GLOBAL: 
                    case SET_FROM_LOCAL: {
                        Node nameNode = ref.getNode();
                        Node nameParent = nameNode.getParent();
                        Node assignedValue = null;
                        Node valueParent = null;
                        if (nameParent.isVar() || nameParent.isConst()) {
                            Preconditions.checkState(nameNode.isName(), nameNode);
                            assignedValue = nameNode.getFirstChild();
                            valueParent = nameNode;
                        } else if (nameParent.isAssign() && nameNode.isFirstChildOf(nameParent)) {
                            assignedValue = nameParent.getLastChild();
                            if (!name.isSimpleName() || name.getDeclaration() != ref) {
                                valueParent = nameParent;
                            }
                        } else if (nameNode.isFromExterns()) {
                            valueParent = nameNode;
                        } else {
                            assignedValue = nameParent.getLastChild();
                        }
                        if (valueParent == null) {
                            ProcessDefines.this.compiler.report(JSError.make(assignedValue, INVALID_DEFINE_INIT_ERROR, fullName));
                            break;
                        }
                        if (!this.processDefineAssignment(fullName, assignedValue, valueParent)) break;
                        refInfo.name.removeRef(ref);
                        this.lvalueToRemoveLater = valueParent;
                        break;
                    }
                    default: {
                        DefineInfo info;
                        if (!t.inGlobalHoistScope() || (info = this.assignableDefines.get(fullName)) == null) break;
                        ProcessDefines.setDefineInfoNotAssignable(info, t);
                        this.assignableDefines.remove(fullName);
                    }
                }
            }
            if (!t.inGlobalScope() && n.getJSDocInfo() != null && n.getJSDocInfo().isDefine()) {
                ProcessDefines.this.compiler.report(JSError.make(n, NON_GLOBAL_DEFINE_INIT_ERROR, ""));
            }
            if (this.lvalueToRemoveLater == n) {
                this.lvalueToRemoveLater = null;
                if (n.isAssign()) {
                    Node last = n.getLastChild();
                    n.removeChild(last);
                    parent.replaceChild(n, last);
                } else {
                    Preconditions.checkState(n.isName(), n);
                    n.removeFirstChild();
                }
                t.reportCodeChange();
            }
            if (n.isCall() && t.inGlobalScope()) {
                for (DefineInfo info : this.assignableDefines.values()) {
                    ProcessDefines.setDefineInfoNotAssignable(info, t);
                }
                this.assignableDefines.clear();
            }
            this.updateAssignAllowedStack(n, false);
        }

        private void updateAssignAllowedStack(Node n, boolean entering) {
            switch (n.getToken()) {
                case CASE: 
                case FOR: 
                case FOR_IN: 
                case FUNCTION: 
                case HOOK: 
                case IF: 
                case SWITCH: 
                case WHILE: {
                    if (entering) {
                        this.assignAllowed.push(0);
                        break;
                    }
                    this.assignAllowed.remove();
                    break;
                }
            }
        }

        private boolean isAssignAllowed() {
            return this.assignAllowed.element() == 1;
        }

        private boolean processDefineAssignment(String name, Node value, Node valueParent) {
            boolean fromExterns = valueParent.isFromExterns();
            if (!(fromExterns || value != null && this.isValidDefineValue(value).toBoolean(false))) {
                Node errNode = value == null ? valueParent : value;
                ProcessDefines.this.compiler.report(JSError.make(errNode, INVALID_DEFINE_INIT_ERROR, name));
            } else if (!this.isAssignAllowed()) {
                ProcessDefines.this.compiler.report(JSError.make(valueParent, NON_GLOBAL_DEFINE_INIT_ERROR, name));
            } else {
                DefineInfo info = this.allDefines.get(name);
                if (info == null) {
                    info = new DefineInfo(value, valueParent);
                    this.allDefines.put(name, info);
                    this.assignableDefines.put(name, info);
                } else {
                    if (info.recordAssignment(value)) {
                        return true;
                    }
                    ProcessDefines.this.compiler.report(JSError.make(valueParent, DEFINE_NOT_ASSIGNABLE_ERROR, name, info.getReasonWhyNotAssignable()));
                }
            }
            return false;
        }

        TernaryValue isValidDefineValue(Node val) {
            switch (val.getToken()) {
                case STRING: 
                case NUMBER: 
                case TRUE: 
                case FALSE: {
                    return TernaryValue.TRUE;
                }
                case AND: 
                case OR: 
                case ADD: 
                case BITAND: 
                case BITNOT: 
                case BITOR: 
                case BITXOR: 
                case DIV: 
                case EQ: 
                case EXPONENT: 
                case GE: 
                case GT: 
                case LE: 
                case LSH: 
                case LT: 
                case MOD: 
                case MUL: 
                case NE: 
                case RSH: 
                case SHEQ: 
                case SHNE: 
                case SUB: 
                case URSH: {
                    return this.isValidDefineValue(val.getFirstChild()).and(this.isValidDefineValue(val.getLastChild()));
                }
                case HOOK: {
                    return this.isValidDefineValue(val.getFirstChild()).and(this.isValidDefineValue(val.getSecondChild())).and(this.isValidDefineValue(val.getLastChild()));
                }
                case NOT: 
                case NEG: 
                case POS: {
                    return this.isValidDefineValue(val.getFirstChild());
                }
                case NAME: 
                case GETPROP: {
                    if (!val.isQualifiedName()) break;
                    return this.validDefineAliases.contains(val) ? TernaryValue.TRUE : TernaryValue.UNKNOWN;
                }
            }
            return TernaryValue.FALSE;
        }
    }

    static class Builder {
        private final AbstractCompiler compiler;
        private final Map<String, Node> replacements = new LinkedHashMap<String, Node>();
        private boolean checksOnly;
        private Supplier<GlobalNamespace> namespaceSupplier;

        Builder(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        Builder putReplacements(Map<String, Node> replacements) {
            this.replacements.putAll(replacements);
            return this;
        }

        Builder checksOnly(boolean checksOnly) {
            this.checksOnly = checksOnly;
            return this;
        }

        Builder injectNamespace(Supplier<GlobalNamespace> namespaceSupplier) {
            this.namespaceSupplier = namespaceSupplier;
            return this;
        }

        ProcessDefines build() {
            return new ProcessDefines(this);
        }
    }
}

