/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6ConvertSuper;
import com.google.javascript.jscomp.Es6ConvertSuperConstructorCalls;
import com.google.javascript.jscomp.Es6ExtractClasses;
import com.google.javascript.jscomp.Es6ForOfConverter;
import com.google.javascript.jscomp.Es6InjectRuntimeLibraries;
import com.google.javascript.jscomp.Es6NormalizeShorthandProperties;
import com.google.javascript.jscomp.Es6RelativizeImportPaths;
import com.google.javascript.jscomp.Es6RenameVariablesInParamLists;
import com.google.javascript.jscomp.Es6RewriteArrowFunction;
import com.google.javascript.jscomp.Es6RewriteBlockScopedDeclaration;
import com.google.javascript.jscomp.Es6RewriteBlockScopedFunctionDeclaration;
import com.google.javascript.jscomp.Es6RewriteClass;
import com.google.javascript.jscomp.Es6RewriteClassExtendsExpressions;
import com.google.javascript.jscomp.Es6RewriteDestructuring;
import com.google.javascript.jscomp.Es6RewriteGenerators;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.Es6RewriteModulesToCommonJsModules;
import com.google.javascript.jscomp.Es6RewriteRestAndSpread;
import com.google.javascript.jscomp.Es6SplitVariableDeclarations;
import com.google.javascript.jscomp.Es7RewriteExponentialOperator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.LateEs6ToEs3Converter;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.RewriteAsyncFunctions;
import com.google.javascript.jscomp.RewriteAsyncIteration;
import com.google.javascript.jscomp.RewriteCatchWithNoBinding;
import com.google.javascript.jscomp.RewriteObjectSpread;
import com.google.javascript.jscomp.RewritePolyfills;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.util.List;

public class TranspilationPasses {
    private static final PassFactory es6RewriteModuleToCjs = new PassFactory("es6RewriteModuleToCjs", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteModulesToCommonJsModules(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private static final PassFactory es6RelativizeImportPaths = new PassFactory("es6RelativizeImportPaths", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es6RelativizeImportPaths(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private static final PassFactory rewriteAsyncFunctions = new PassFactory.HotSwapPassFactory("rewriteAsyncFunctions"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new RewriteAsyncFunctions.Builder(compiler).rewriteSuperPropertyReferencesWithoutSuper(!compiler.getOptions().needsTranspilationFrom(FeatureSet.ES6)).build();
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private static final PassFactory rewriteAsyncIteration = new PassFactory.HotSwapPassFactory("rewriteAsyncIteration"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new RewriteAsyncIteration.Builder(compiler).rewriteSuperPropertyReferencesWithoutSuper(!compiler.getOptions().needsTranspilationFrom(FeatureSet.ES6)).build();
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private static final PassFactory rewriteObjectSpread = new PassFactory.HotSwapPassFactory("rewriteObjectSpread"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new RewriteObjectSpread(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private static final PassFactory rewriteCatchWithNoBinding = new PassFactory.HotSwapPassFactory("rewriteCatchWithNoBinding"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new RewriteCatchWithNoBinding(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private static final PassFactory rewriteExponentialOperator = new PassFactory.HotSwapPassFactory("rewriteExponentialOperator"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es7RewriteExponentialOperator(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    private static final PassFactory.HotSwapPassFactory es6NormalizeShorthandProperties = new PassFactory.HotSwapPassFactory("es6NormalizeShorthandProperties"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6NormalizeShorthandProperties(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RewriteClassExtends = new PassFactory.HotSwapPassFactory("Es6ExtractClassExtends"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteClassExtendsExpressions(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    static final PassFactory.HotSwapPassFactory es6ExtractClasses = new PassFactory.HotSwapPassFactory("Es6ExtractClasses"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ExtractClasses(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RewriteClass = new PassFactory.HotSwapPassFactory("Es6RewriteClass"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteClass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RenameVariablesInParamLists = new PassFactory.HotSwapPassFactory("Es6RenameVariablesInParamLists"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RenameVariablesInParamLists(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RewriteArrowFunction = new PassFactory.HotSwapPassFactory("Es6RewriteArrowFunction"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteArrowFunction(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewritePolyfills = new PassFactory.HotSwapPassFactory("RewritePolyfills"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new RewritePolyfills(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    static final PassFactory.HotSwapPassFactory es6SplitVariableDeclarations = new PassFactory.HotSwapPassFactory("Es6SplitVariableDeclarations"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6SplitVariableDeclarations(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    static final PassFactory.HotSwapPassFactory es6ConvertSuperConstructorCalls = new PassFactory.HotSwapPassFactory("es6ConvertSuperConstructorCalls"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ConvertSuperConstructorCalls(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6ConvertSuper = new PassFactory.HotSwapPassFactory("es6ConvertSuper"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ConvertSuper(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    static final PassFactory.HotSwapPassFactory es6InjectRuntimeLibraries = new PassFactory.HotSwapPassFactory("es6InjectRuntimeLibraries"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6InjectRuntimeLibraries(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RewriteRestAndSpread = new PassFactory.HotSwapPassFactory("es6RewriteRestAndSpread"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteRestAndSpread(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    static final PassFactory.HotSwapPassFactory lateConvertEs6ToEs3 = new PassFactory.HotSwapPassFactory("lateConvertEs6"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new LateEs6ToEs3Converter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    static final PassFactory.HotSwapPassFactory es6ForOf = new PassFactory.HotSwapPassFactory("es6ForOf"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ForOfConverter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewriteBlockScopedFunctionDeclaration = new PassFactory.HotSwapPassFactory("Es6RewriteBlockScopedFunctionDeclaration"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteBlockScopedFunctionDeclaration(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewriteBlockScopedDeclaration = new PassFactory.HotSwapPassFactory("Es6RewriteBlockScopedDeclaration"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteBlockScopedDeclaration(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewriteGenerators = new PassFactory.HotSwapPassFactory("rewriteGenerators"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteGenerators(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };

    private TranspilationPasses() {
    }

    public static void addEs6ModulePass(List<PassFactory> passes, final PreprocessorSymbolTable.CachedInstanceFactory preprocessorTableFactory) {
        passes.add(new PassFactory.HotSwapPassFactory("es6RewriteModule"){

            @Override
            protected HotSwapCompilerPass create(AbstractCompiler compiler) {
                preprocessorTableFactory.maybeInitialize(compiler);
                return new Es6RewriteModules(compiler, compiler.getModuleMetadataMap(), compiler.getModuleMap(), preprocessorTableFactory.getInstanceOrNull());
            }

            @Override
            protected FeatureSet featureSet() {
                return FeatureSet.ES_NEXT;
            }
        });
    }

    public static void addPreTypecheckTranspilationPasses(List<PassFactory> passes, CompilerOptions options) {
        passes.add(es6InjectRuntimeLibraries);
    }

    public static void addEs6ModuleToCjsPass(List<PassFactory> passes) {
        passes.add(es6RewriteModuleToCjs);
    }

    public static void addEs6RewriteImportPathPass(List<PassFactory> passes) {
        passes.add(es6RelativizeImportPaths);
    }

    public static void addPostCheckTranspilationPasses(List<PassFactory> passes, CompilerOptions options) {
        if (options.needsTranspilationFrom(FeatureSet.ES_NEXT)) {
            passes.add(rewriteCatchWithNoBinding);
        }
        if (options.needsTranspilationFrom(FeatureSet.ES2018)) {
            passes.add(rewriteAsyncIteration);
            passes.add(rewriteObjectSpread);
        }
        if (options.needsTranspilationFrom(FeatureSet.ES8)) {
            passes.add(TranspilationPasses.createFeatureRemovalPass("markTrailingCommasInParameterListsRemoved", FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST, new FeatureSet.Feature[0]));
            passes.add(rewriteAsyncFunctions);
        }
        if (options.needsTranspilationFrom(FeatureSet.ES7)) {
            passes.add(rewriteExponentialOperator);
        }
        if (options.needsTranspilationFrom(FeatureSet.ES6)) {
            passes.add(TranspilationPasses.createFeatureRemovalPass("markEs6FeaturesNotRequiringTranspilationAsRemoved", FeatureSet.Feature.BINARY_LITERALS, FeatureSet.Feature.OCTAL_LITERALS, FeatureSet.Feature.REGEXP_FLAG_U, FeatureSet.Feature.REGEXP_FLAG_Y));
            passes.add(es6NormalizeShorthandProperties);
            passes.add(es6RewriteClassExtends);
            passes.add(es6ConvertSuper);
            passes.add(es6RenameVariablesInParamLists);
            passes.add(es6SplitVariableDeclarations);
            passes.add(TranspilationPasses.getEs6RewriteDestructuring(Es6RewriteDestructuring.ObjectDestructuringRewriteMode.REWRITE_ALL_OBJECT_PATTERNS));
            passes.add(es6RewriteArrowFunction);
            passes.add(es6ExtractClasses);
            passes.add(es6RewriteClass);
            passes.add(es6RewriteRestAndSpread);
            passes.add(lateConvertEs6ToEs3);
            passes.add(es6ForOf);
            passes.add(rewriteBlockScopedFunctionDeclaration);
            passes.add(rewriteBlockScopedDeclaration);
            passes.add(rewriteGenerators);
            passes.add(es6ConvertSuperConstructorCalls);
        } else if (options.needsTranspilationOf(FeatureSet.Feature.OBJECT_PATTERN_REST)) {
            passes.add(es6RenameVariablesInParamLists);
            passes.add(es6SplitVariableDeclarations);
            passes.add(TranspilationPasses.getEs6RewriteDestructuring(Es6RewriteDestructuring.ObjectDestructuringRewriteMode.REWRITE_OBJECT_REST));
        }
    }

    public static void addRewritePolyfillPass(List<PassFactory> passes) {
        passes.add(rewritePolyfills);
    }

    static final PassFactory.HotSwapPassFactory getEs6RewriteDestructuring(final Es6RewriteDestructuring.ObjectDestructuringRewriteMode rewriteMode) {
        return new PassFactory.HotSwapPassFactory("Es6RewriteDestructuring"){

            @Override
            protected HotSwapCompilerPass create(AbstractCompiler compiler) {
                return new Es6RewriteDestructuring.Builder(compiler).setDestructuringRewriteMode(rewriteMode).build();
            }

            @Override
            protected FeatureSet featureSet() {
                return FeatureSet.ES2018;
            }
        };
    }

    static boolean isScriptEs6OrHigher(Node script) {
        FeatureSet features = NodeUtil.getFeatureSetOfScript(script);
        return features != null && !FeatureSet.ES5.contains(features);
    }

    static boolean doesScriptHaveUnsupportedFeatures(Node script, FeatureSet supportedFeatures) {
        FeatureSet features = NodeUtil.getFeatureSetOfScript(script);
        return features != null && !supportedFeatures.contains(features);
    }

    static void processTranspile(AbstractCompiler compiler, Node combinedRoot, FeatureSet featureSet, NodeTraversal.Callback ... callbacks) {
        if (compiler.getOptions().needsTranspilationFrom(featureSet)) {
            FeatureSet languageOutFeatures = compiler.getOptions().getOutputFeatureSet();
            for (Node singleRoot : combinedRoot.children()) {
                if (!TranspilationPasses.doesScriptHaveUnsupportedFeatures(singleRoot, languageOutFeatures)) continue;
                for (NodeTraversal.Callback callback : callbacks) {
                    singleRoot.putBooleanProp(Node.TRANSPILED, true);
                    NodeTraversal.traverse(compiler, singleRoot, callback);
                }
            }
        }
    }

    static void hotSwapTranspile(AbstractCompiler compiler, Node scriptRoot, FeatureSet featureSet, NodeTraversal.Callback ... callbacks) {
        FeatureSet languageOutFeatures;
        if (compiler.getOptions().needsTranspilationFrom(featureSet) && TranspilationPasses.doesScriptHaveUnsupportedFeatures(scriptRoot, languageOutFeatures = compiler.getOptions().getOutputFeatureSet())) {
            for (NodeTraversal.Callback callback : callbacks) {
                scriptRoot.putBooleanProp(Node.TRANSPILED, true);
                NodeTraversal.traverse(compiler, scriptRoot, callback);
            }
        }
    }

    static void maybeMarkFeaturesAsTranspiledAway(AbstractCompiler compiler, FeatureSet transpiledFeatures) {
        if (!compiler.hasHaltingErrors()) {
            compiler.setFeatureSet(compiler.getFeatureSet().without(transpiledFeatures));
        }
    }

    static void maybeMarkFeaturesAsTranspiledAway(AbstractCompiler compiler, FeatureSet.Feature transpiledFeature, FeatureSet.Feature ... moreTranspiledFeatures) {
        if (!compiler.hasHaltingErrors()) {
            compiler.setFeatureSet(compiler.getFeatureSet().without(transpiledFeature, moreTranspiledFeatures));
        }
    }

    private static PassFactory.HotSwapPassFactory createFeatureRemovalPass(String passName, final FeatureSet.Feature featureToRemove, final FeatureSet.Feature ... moreFeaturesToRemove) {
        return new PassFactory.HotSwapPassFactory(passName){

            @Override
            protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
                return new HotSwapCompilerPass(){

                    @Override
                    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(compiler, featureToRemove, moreFeaturesToRemove);
                    }

                    @Override
                    public void process(Node externs, Node root) {
                        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(compiler, featureToRemove, moreFeaturesToRemove);
                    }
                };
            }

            @Override
            protected FeatureSet featureSet() {
                return FeatureSet.latest();
            }
        };
    }
}

