/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.QualifiedName;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.StaticSlot;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NoResolvedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class NamedType
extends ProxyObjectType {
    private static final long serialVersionUID = 1L;
    private final String reference;
    private final String sourceName;
    private final int lineno;
    private final int charno;
    private final boolean nonNull;
    private transient Predicate<JSType> validator;
    private transient List<PropertyContinuation> propertyContinuations = null;
    @Nullable
    private final ImmutableList<JSType> templateTypes;
    @Nullable
    private StaticTypedScope resolutionScope;

    static int nominalHashCode(ObjectType type) {
        Preconditions.checkState(type.hasReferenceName());
        String name = Preconditions.checkNotNull(type.getReferenceName());
        return name.hashCode();
    }

    NamedType(StaticTypedScope scope, JSTypeRegistry registry, String reference, String sourceName, int lineno, int charno) {
        this(scope, registry, reference, sourceName, lineno, charno, null);
    }

    NamedType(StaticTypedScope scope, JSTypeRegistry registry, String reference, String sourceName, int lineno, int charno, ImmutableList<JSType> templateTypes) {
        super(registry, registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        this.nonNull = reference.startsWith("!");
        this.resolutionScope = scope;
        this.reference = this.nonNull ? reference.substring(1) : reference;
        this.sourceName = sourceName;
        this.lineno = lineno;
        this.charno = charno;
        this.templateTypes = templateTypes;
    }

    JSType getBangType() {
        if (this.nonNull) {
            return this;
        }
        if (this.resolutionScope == null) {
            return this.getReferencedType().restrictByNotNullOrUndefined();
        }
        return new NamedType(this.resolutionScope, this.registry, "!" + this.reference, this.sourceName, this.lineno, this.charno, this.templateTypes);
    }

    @Override
    public ImmutableList<JSType> getTemplateTypes() {
        return this.templateTypes;
    }

    @Override
    boolean defineProperty(String propertyName, JSType type, boolean inferred, Node propertyNode) {
        if (!this.isResolved()) {
            if (this.propertyContinuations == null) {
                this.propertyContinuations = new ArrayList<PropertyContinuation>();
            }
            this.propertyContinuations.add(new PropertyContinuation(propertyName, type, inferred, propertyNode));
            return true;
        }
        return super.defineProperty(propertyName, type, inferred, propertyNode);
    }

    private void finishPropertyContinuations() {
        ObjectType referencedObjType = this.getReferencedObjTypeInternal();
        if (referencedObjType != null && !referencedObjType.isUnknownType() && this.propertyContinuations != null) {
            for (PropertyContinuation c : this.propertyContinuations) {
                c.commit(this);
            }
        }
        this.propertyContinuations = null;
    }

    public JSType getReferencedType() {
        return this.getReferencedTypeInternal();
    }

    @Override
    public String getReferenceName() {
        return this.reference;
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        JSType type = this.getReferencedType();
        if (!this.isResolved() || type.isNoResolvedType()) {
            return sb.append(this.reference);
        }
        return type.appendTo(sb, forAnnotations);
    }

    @Override
    public NamedType toMaybeNamedType() {
        return this;
    }

    @Override
    public boolean isNominalType() {
        return true;
    }

    @Override
    int recursionUnsafeHashCode() {
        return this.isSuccessfullyResolved() ? super.recursionUnsafeHashCode() : NamedType.nominalHashCode(this);
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter) {
        if (!this.getReferencedType().isUnknownType()) {
            return super.resolveInternal(reporter);
        }
        boolean resolved = false;
        if (this.reference.startsWith("typeof ")) {
            this.resolveTypeof(reporter);
            resolved = true;
        }
        boolean bl = resolved = resolved || this.resolveViaClosureNamespace(reporter) || this.resolveViaRegistry(reporter);
        if (!resolved) {
            this.resolveViaProperties(reporter);
        }
        if (this.detectInheritanceCycle()) {
            this.handleTypeCycle(reporter);
        }
        super.resolveInternal(reporter);
        this.finishPropertyContinuations();
        JSType result = this.getReferencedType();
        if (this.isSuccessfullyResolved()) {
            int numKeys = result.getTemplateTypeMap().numUnfilledTemplateKeys();
            if (result.isObjectType() && this.templateTypes != null && !this.templateTypes.isEmpty() && numKeys > 0) {
                List<JSType> typeArgs = this.templateTypes;
                if (numKeys < this.templateTypes.size()) {
                    typeArgs = typeArgs.subList(0, numKeys);
                }
                result = this.registry.createTemplatizedType(result.toMaybeObjectType(), (ImmutableList<JSType>)typeArgs);
                this.setReferencedType(result);
            }
            this.resolutionScope = null;
        }
        return result;
    }

    private boolean resolveViaRegistry(ErrorReporter reporter) {
        JSType type = this.registry.getType(this.resolutionScope, this.reference);
        if (type != null) {
            this.setReferencedAndResolvedType(type, reporter);
            return true;
        }
        return false;
    }

    private void resolveViaProperties(ErrorReporter reporter) {
        List<String> componentNames = Splitter.on('.').splitToList(this.reference);
        if (componentNames.get(0).isEmpty()) {
            this.handleUnresolvedType(reporter, true);
            return;
        }
        StaticTypedSlot slot = Preconditions.checkNotNull(this.resolutionScope, "resolutionScope").getSlot(Preconditions.checkNotNull(componentNames, "componentNames").get(0));
        if (slot == null) {
            this.handleUnresolvedType(reporter, true);
            return;
        }
        Node definitionNode = slot.getDeclaration() != null ? slot.getDeclaration().getNode() : null;
        this.resolveViaPropertyGivenSlot(slot.getType(), definitionNode, componentNames, reporter, 1);
    }

    private void resolveViaPropertyGivenSlot(JSType slotType, Node definitionNode, List<String> componentNames, ErrorReporter reporter, int componentIndex) {
        if (this.resolveTypeFromNodeIfTypedef(definitionNode, reporter)) {
            return;
        }
        if (slotType == null || slotType.isAllType() || slotType.isNoType()) {
            this.handleUnresolvedType(reporter, true);
            return;
        }
        for (int i = componentIndex; i < componentNames.size(); ++i) {
            Node def;
            String component = componentNames.get(i);
            ObjectType parentObj = ObjectType.cast(slotType);
            if (parentObj == null || component.length() == 0) {
                this.handleUnresolvedType(reporter, true);
                return;
            }
            if (i == componentNames.size() - 1 && this.resolveTypeFromNodeIfTypedef(def = parentObj.getPropertyDefSite(component), reporter)) {
                return;
            }
            slotType = parentObj.getPropertyType(component);
        }
        if (slotType == null) {
            this.handleUnresolvedType(reporter, true);
        } else if (slotType.isFunctionType() && (slotType.isConstructor() || slotType.isInterface())) {
            this.setReferencedAndResolvedType(slotType.toMaybeFunctionType().getInstanceType(), reporter);
        } else if (slotType.isNoObjectType()) {
            this.setReferencedAndResolvedType(this.registry.getNativeObjectType(JSTypeNative.NO_OBJECT_TYPE), reporter);
        } else if (slotType instanceof EnumType) {
            this.setReferencedAndResolvedType(((EnumType)slotType).getElementsType(), reporter);
        } else {
            this.handleUnresolvedType(reporter, slotType.isUnknownType());
        }
    }

    private void resolveTypeof(ErrorReporter reporter) {
        String name = this.reference.substring("typeof ".length());
        JSType type = this.resolutionScope.lookupQualifiedName(QualifiedName.of(name));
        if (type == null || type.isUnknownType()) {
            this.warning(reporter, "Missing type for `typeof` value. The value must be declared and const.");
            this.setReferencedAndResolvedType(this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE), reporter);
        } else {
            if (type.isLiteralObject()) {
                JSType objlit = type;
                type = this.registry.createNamedType(this.resolutionScope, this.reference, this.sourceName, this.lineno, this.charno);
                ((NamedType)type).setReferencedType(objlit);
            }
            this.setReferencedAndResolvedType(type, reporter);
        }
    }

    private boolean resolveViaClosureNamespace(ErrorReporter reporter) {
        List<String> componentNames = Splitter.on('.').splitToList(this.reference);
        if (componentNames.get(0).isEmpty()) {
            return false;
        }
        StaticTypedSlot slot = this.resolutionScope.getSlot(componentNames.get(0));
        if (slot != null && slot.getScope() != null && slot.getScope().getParentScope() != null) {
            return false;
        }
        String prefix = this.reference;
        for (int remainingComponentIndex = componentNames.size(); remainingComponentIndex > 0; --remainingComponentIndex) {
            JSTypeRegistry.ModuleSlot module = this.registry.getModuleSlot(prefix);
            if (module == null) {
                int lastDot = prefix.lastIndexOf(".");
                if (lastDot < 0) continue;
                prefix = prefix.substring(0, lastDot);
                continue;
            }
            if (module.isLegacyModule()) {
                return false;
            }
            this.resolveViaPropertyGivenSlot(module.type(), module.definitionNode(), componentNames, reporter, remainingComponentIndex);
            return true;
        }
        return false;
    }

    private boolean resolveTypeFromNodeIfTypedef(Node node, ErrorReporter reporter) {
        if (node == null) {
            return false;
        }
        JSType typedefType = node.getTypedefTypeProp();
        if (typedefType == null) {
            return false;
        }
        this.setReferencedAndResolvedType(typedefType, reporter);
        return true;
    }

    private void setReferencedAndResolvedType(JSType type, ErrorReporter reporter) {
        if (this.nonNull) {
            type = type.restrictByNotNullOrUndefined();
        }
        if (this.validator != null) {
            this.validator.apply(type);
        }
        this.setReferencedType(type);
        this.checkEnumElementCycle(reporter);
        this.checkProtoCycle(reporter);
        this.setResolvedTypeInternal(this.getReferencedType());
    }

    private void handleTypeCycle(ErrorReporter reporter) {
        this.setReferencedType(this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        this.warning(reporter, "Cycle detected in inheritance chain of type " + this.reference);
        this.setResolvedTypeInternal(this.getReferencedType());
    }

    private void checkEnumElementCycle(ErrorReporter reporter) {
        JSType referencedType = this.getReferencedType();
        if (referencedType instanceof EnumElementType && NamedType.areIdentical(this, ((EnumElementType)referencedType).getPrimitiveType())) {
            this.handleTypeCycle(reporter);
        }
    }

    private void checkProtoCycle(ErrorReporter reporter) {
        JSType referencedType = this.getReferencedType();
        if (NamedType.areIdentical(referencedType, this)) {
            this.handleTypeCycle(reporter);
        }
    }

    private void handleUnresolvedType(ErrorReporter reporter, boolean ignoreForwardReferencedTypes) {
        boolean isForwardDeclared;
        boolean bl = isForwardDeclared = ignoreForwardReferencedTypes && this.registry.isForwardDeclaredType(this.reference);
        if (!isForwardDeclared) {
            String root;
            String msg = "Bad type annotation. Unknown type " + this.reference;
            String string = root = this.reference.contains(".") ? this.reference.substring(0, this.reference.indexOf(".")) : this.reference;
            if (this.localVariableShadowsGlobalNamespace(root)) {
                msg = msg + "\nIt's possible that a local variable called '" + root + "' is shadowing the intended global namespace.";
            }
            this.warning(reporter, msg);
        } else {
            this.setReferencedType(new NoResolvedType(this.registry, this.getReferenceName(), this.getTemplateTypes()));
            if (this.validator != null) {
                this.validator.apply(this.getReferencedType());
            }
        }
        this.setResolvedTypeInternal(this.getReferencedType());
    }

    private boolean localVariableShadowsGlobalNamespace(String root) {
        StaticScope parent;
        StaticTypedSlot rootVar = this.resolutionScope.getSlot(root);
        if (rootVar != null && (parent = rootVar.getScope().getParentScope()) != null) {
            StaticSlot globalVar = parent.getSlot(root);
            return globalVar != null;
        }
        return false;
    }

    @Override
    public boolean setValidator(Predicate<JSType> validator) {
        if (this.isResolved()) {
            return super.setValidator(validator);
        }
        this.validator = validator;
        return true;
    }

    void warning(ErrorReporter reporter, String message) {
        reporter.warning(message, this.sourceName, this.lineno, this.charno);
    }

    @Override
    public boolean isObject() {
        if (this.isEnumElementType()) {
            return this.toMaybeEnumElementType().isObject();
        }
        return super.isObject();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseNamedType(this);
    }

    private static final class PropertyContinuation {
        private final String propertyName;
        private final JSType type;
        private final boolean inferred;
        private final Node propertyNode;

        private PropertyContinuation(String propertyName, JSType type, boolean inferred, Node propertyNode) {
            this.propertyName = propertyName;
            this.type = type;
            this.inferred = inferred;
            this.propertyNode = propertyNode;
        }

        void commit(ObjectType target) {
            target.defineProperty(this.propertyName, this.type, this.inferred, this.propertyNode);
        }
    }
}

