/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.NoType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public final class TemplateTypeReplacer
implements Visitor<JSType> {
    private final JSTypeRegistry registry;
    private final TemplateTypeMap bindings;
    private final boolean visitProperties;
    private final boolean useUnknownForMissingKeys;
    private final boolean useUnknownForMissingValues;
    private boolean hasMadeReplacement = false;
    private TemplateType keyType;
    private final Set<JSType> seenTypes = Sets.newIdentityHashSet();

    public static TemplateTypeReplacer forInference(JSTypeRegistry registry, Map<TemplateType, JSType> bindings) {
        ImmutableList<TemplateType> keys = ImmutableList.copyOf(bindings.keySet());
        ImmutableList<JSType> values = keys.stream().map(bindings::get).map(v -> v != null ? v : registry.getNativeType(JSTypeNative.UNKNOWN_TYPE)).collect(ImmutableList.toImmutableList());
        TemplateTypeMap map = new TemplateTypeMap(registry, keys, values);
        return new TemplateTypeReplacer(registry, map, true, true, true);
    }

    public static TemplateTypeReplacer forTotalReplacement(JSTypeRegistry registry, TemplateTypeMap bindings) {
        return new TemplateTypeReplacer(registry, bindings, false, false, true);
    }

    public static TemplateTypeReplacer forPartialReplacement(JSTypeRegistry registry, TemplateTypeMap bindings) {
        return new TemplateTypeReplacer(registry, bindings, false, false, false);
    }

    private TemplateTypeReplacer(JSTypeRegistry registry, TemplateTypeMap bindings, boolean visitProperties, boolean useUnknownForMissingKeys, boolean useUnknownForMissingValues) {
        this.registry = registry;
        this.bindings = bindings;
        this.visitProperties = visitProperties;
        this.useUnknownForMissingKeys = useUnknownForMissingKeys;
        this.useUnknownForMissingValues = useUnknownForMissingValues;
    }

    public boolean hasMadeReplacement() {
        return this.hasMadeReplacement;
    }

    @Override
    public JSType caseNoType(NoType type) {
        return type;
    }

    @Override
    public JSType caseEnumElementType(EnumElementType type) {
        return type;
    }

    @Override
    public JSType caseAllType() {
        return this.getNativeType(JSTypeNative.ALL_TYPE);
    }

    @Override
    public JSType caseBooleanType() {
        return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
    }

    @Override
    public JSType caseNoObjectType() {
        return this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
    }

    @Override
    public JSType caseFunctionType(FunctionType type) {
        JSType afterReturn;
        JSType beforeReturn;
        JSType afterThis;
        if (this.isNativeFunctionType(type)) {
            return type;
        }
        if (!type.isOrdinaryFunction() && !type.isConstructor()) {
            return type;
        }
        boolean changed = false;
        JSType beforeThis = type.getTypeOfThis();
        if (beforeThis != (afterThis = this.coerseToThisType(beforeThis.visit(this)))) {
            changed = true;
        }
        if ((beforeReturn = type.getReturnType()) != (afterReturn = beforeReturn.visit(this))) {
            changed = true;
        }
        FunctionParamBuilder paramBuilder = new FunctionParamBuilder(this.registry);
        for (Node paramNode : type.getParameters()) {
            JSType afterParamType;
            JSType beforeParamType = paramNode.getJSType();
            if (beforeParamType != (afterParamType = beforeParamType.visit(this))) {
                changed = true;
            }
            if (paramNode.isOptionalArg()) {
                paramBuilder.addOptionalParams(afterParamType);
                continue;
            }
            if (paramNode.isVarArgs()) {
                paramBuilder.addVarArgs(afterParamType);
                continue;
            }
            paramBuilder.addRequiredParams(afterParamType);
        }
        if (changed) {
            FunctionType ft = FunctionType.builder(this.registry).withKind(type.getKind()).withParamsNode(paramBuilder.build()).withReturnType(afterReturn).withTypeOfThis(afterThis).withTemplateKeys(type.getTemplateTypeMap().getUnfilledTemplateKeys()).withClosurePrimitiveId(type.getClosurePrimitive()).build();
            return ft;
        }
        return type;
    }

    private JSType coerseToThisType(JSType type) {
        return type != null ? type : this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
    }

    @Override
    public JSType caseObjectType(ObjectType objType) {
        if (!this.visitProperties || objType.isNominalType() || objType instanceof ProxyObjectType || !objType.isRecordType()) {
            return objType;
        }
        if (this.seenTypes.contains(objType)) {
            return objType;
        }
        this.seenTypes.add(objType);
        boolean changed = false;
        RecordTypeBuilder builder = new RecordTypeBuilder(this.registry);
        for (String prop : objType.getOwnPropertyNames()) {
            JSType afterType;
            Node propertyNode = objType.getPropertyNode(prop);
            JSType beforeType = objType.getPropertyType(prop);
            if (beforeType != (afterType = beforeType.visit(this))) {
                changed = true;
            }
            builder.addProperty(prop, afterType, propertyNode);
        }
        this.seenTypes.remove(objType);
        if (changed) {
            return builder.build();
        }
        return objType;
    }

    @Override
    public JSType caseTemplatizedType(TemplatizedType type) {
        ObjectType afterBaseType;
        boolean changed = false;
        ObjectType beforeBaseType = type.getReferencedType();
        if (beforeBaseType != (afterBaseType = ObjectType.cast(beforeBaseType.visit(this)))) {
            changed = true;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSType beforeTemplateType : type.getTemplateTypes()) {
            JSType afterTemplateType;
            if (beforeTemplateType != (afterTemplateType = beforeTemplateType.visit(this))) {
                changed = true;
            }
            builder.add(afterTemplateType);
        }
        if (changed) {
            type = this.registry.createTemplatizedType(afterBaseType, (ImmutableList<JSType>)builder.build());
        }
        return type;
    }

    @Override
    public JSType caseUnknownType() {
        return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
    }

    @Override
    public JSType caseNullType() {
        return this.getNativeType(JSTypeNative.NULL_TYPE);
    }

    @Override
    public JSType caseNumberType() {
        return this.getNativeType(JSTypeNative.NUMBER_TYPE);
    }

    @Override
    public JSType caseStringType() {
        return this.getNativeType(JSTypeNative.STRING_TYPE);
    }

    @Override
    public JSType caseSymbolType() {
        return this.getNativeType(JSTypeNative.SYMBOL_TYPE);
    }

    @Override
    public JSType caseVoidType() {
        return this.getNativeType(JSTypeNative.VOID_TYPE);
    }

    @Override
    public JSType caseUnionType(UnionType type) {
        boolean changed = false;
        ArrayList<JSType> results = new ArrayList<JSType>();
        for (JSType alternative : type.getAlternates()) {
            JSType replacement = alternative.visit(this);
            if (replacement != alternative) {
                changed = true;
            }
            results.add(replacement);
        }
        if (changed) {
            return this.registry.createUnionType(results);
        }
        return type;
    }

    @Override
    public JSType caseTemplateType(TemplateType type) {
        this.hasMadeReplacement = true;
        if (!this.bindings.hasTemplateKey(type)) {
            return this.useUnknownForMissingKeys ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : type;
        }
        if (this.seenTypes.contains(type)) {
            return type;
        }
        if (!this.bindings.hasTemplateType(type)) {
            return this.useUnknownForMissingValues ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : type;
        }
        JSType replacement = this.bindings.getUnresolvedOriginalTemplateType(type);
        if (replacement == this.keyType || this.isRecursive(type, replacement)) {
            return type;
        }
        this.seenTypes.add(type);
        JSType visitedReplacement = replacement.visit(this);
        this.seenTypes.remove(type);
        Preconditions.checkState(visitedReplacement != this.keyType, "Trying to replace key %s with the same value", (Object)this.keyType);
        return visitedReplacement;
    }

    private JSType getNativeType(JSTypeNative nativeType) {
        return this.registry.getNativeType(nativeType);
    }

    private boolean isNativeFunctionType(FunctionType type) {
        return type.isNativeObjectType();
    }

    @Override
    public JSType caseNamedType(NamedType type) {
        return type;
    }

    @Override
    public JSType caseProxyObjectType(ProxyObjectType type) {
        JSType beforeType = type.getReferencedTypeInternal();
        JSType replacement = beforeType.visit(this);
        if (replacement != beforeType) {
            return replacement;
        }
        return type;
    }

    void setKeyType(TemplateType keyType) {
        this.keyType = keyType;
    }

    private boolean isRecursive(TemplateType currentType, JSType replacementType) {
        TemplatizedType replacementTemplatizedType = replacementType.restrictByNotNullOrUndefined().toMaybeTemplatizedType();
        if (replacementTemplatizedType == null) {
            return false;
        }
        ImmutableList<JSType> replacementTemplateTypes = replacementTemplatizedType.getTemplateTypes();
        for (JSType replacementTemplateType : replacementTemplateTypes) {
            if (!replacementTemplateType.isTemplateType() || !this.isSameType(currentType, replacementTemplateType.toMaybeTemplateType())) continue;
            return true;
        }
        return false;
    }

    private boolean isSameType(TemplateType currentType, TemplateType replacementType) {
        return currentType == replacementType || currentType == this.bindings.getUnresolvedOriginalTemplateType(replacementType);
    }
}

