// Copyright (c) 2020 LG Electronics, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

#include "components/local_storage_manager/browser/local_storage_manager_mojo_impl.h"

namespace content {

void RenderFrameHostImpl::GetLocalStorageManagerMojoImpl(
    mojo::PendingReceiver<local_storage::mojom::LocalStorageManager> receiver) {
  lsm_responder_ =
      std::make_unique<LocalStorageManagerMojoImpl>(std::move(receiver));
}
}  // namespace content
