# Chromium coding style

## Main style guides

  * [Chromium C++ style guide](c++/c++.md)
    * See also: [C++ Dos and Don'ts](c++/c++-dos-and-donts.md) for Chromium best-practices.
  * [Chromium Objective-C style guide](objective-c/objective-c.md)
  * [Java style guide for Android](java/java.md)
  * [Chromium Python style guide](python/python.md)
  * [GN style guide](https://gn.googlesource.com/gn/+/master/docs/style_guide.md) for build files.
    * See also: [Writing GN templates](../build/docs/writing_gn_templates.md) for Chromium best-practices.

Chromium also uses these languages to a lesser degree:

  * [Kernel C style](https://www.kernel.org/doc/html/latest/process/coding-style.html) for ChromiumOS firmware.
  * [IDL](https://sites.google.com/a/chromium.org/dev/blink/webidl#TOC-Style)
  * [Jinja style guide](https://sites.google.com/a/chromium.org/dev/developers/jinja#TOC-Style) for [Jinja](https://sites.google.com/a/chromium.org/dev/developers/jinja) templates.

Regardless of the language used, please keep code [inclusive for all contributors](inclusive_code.md).

## Web languages (JavaScript, HTML, CSS)

When working on Web-based UI features, consult the [Web Development Style Guide](web/web.md) for the Chromium conventions used in JS/CSS/HTML files.

Internal uses of web languages, notably "layout" tests, should preferably follow these style guides, but it is not enforced.
