// Copyright (c) 2018 LG Electronics, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

#ifndef WAM_URL_H
#define WAM_URL_H

#include <unordered_map>
#include <memory>
#include <string>

class Url {
public:
    ~Url();
    Url(const std::string &uri = "");
    Url(const Url &u);
    Url &operator=(const Url &u);
    Url(Url &&) noexcept;
    Url &operator=(Url &&u) noexcept;

    static Url fromLocalFile(const std::string &path);

    std::string scheme() const;
    std::string host() const;
    std::string path() const;
    bool empty() const;
    bool isLocalFile() const;

    bool setQuery(const std::unordered_map<std::string, std::string> &q);
    std::string toString() const;
    std::string toLocalFile() const;

private:
    struct Impl;
    std::unique_ptr<Impl> impl_;
};

#endif // WAM_URL_H

