/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonItem;

public class ListIterator
implements UnfailingIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator {
    int index = 0;
    int length;
    Item current = null;
    List list = null;

    public ListIterator(List list) {
        this.list = list;
        this.length = list.size();
    }

    public ListIterator(List list, int length) {
        this.list = list;
        this.length = length;
    }

    public boolean hasNext() {
        return this.index < this.length;
    }

    public Item next() {
        if (this.index >= this.length) {
            this.current = null;
            this.index = -1;
            this.length = -1;
            return null;
        }
        this.current = (Item)this.list.get(this.index++);
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.index;
    }

    public void close() {
    }

    public int getLastPosition() {
        return this.length;
    }

    public SequenceIterator getAnother() {
        return new ListIterator(this.list);
    }

    public int getProperties() {
        return 7;
    }

    public GroundedValue materialize() {
        if (this.length == 0) {
            return EmptySequence.getInstance();
        }
        if (this.length == 1) {
            Item item = (Item)this.list.get(0);
            if (item instanceof NodeInfo) {
                return new SingletonItem((NodeInfo)item);
            }
            return (AtomicValue)item;
        }
        return new SequenceExtent(this.list);
    }
}

