// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_POLICY_CORE_COMMON_CLOUD_MOCK_CLOUD_POLICY_SERVICE_H_
#define COMPONENTS_POLICY_CORE_COMMON_CLOUD_MOCK_CLOUD_POLICY_SERVICE_H_

#include "base/macros.h"
#include "components/policy/core/common/cloud/cloud_policy_service.h"
#include "testing/gmock/include/gmock/gmock.h"

namespace policy {

class CloudPolicyClient;
class CloudPolicyStore;

class MockCloudPolicyService : public CloudPolicyService {
 public:
  MockCloudPolicyService(CloudPolicyClient* client, CloudPolicyStore* store);
  ~MockCloudPolicyService() override;

  MOCK_METHOD1(RefreshPolicy, void(RefreshPolicyCallback));

 private:
  // Invokes real RefreshPolicy() method.
  void InvokeRefreshPolicy(RefreshPolicyCallback callback);

  DISALLOW_COPY_AND_ASSIGN(MockCloudPolicyService);
};

class MockCloudPolicyServiceObserver : public CloudPolicyService::Observer {
 public:
  MockCloudPolicyServiceObserver();
  ~MockCloudPolicyServiceObserver() override;

  MOCK_METHOD0(OnCloudPolicyServiceInitializationCompleted, void());

 private:
  DISALLOW_COPY_AND_ASSIGN(MockCloudPolicyServiceObserver);
};

}  // namespace policy

#endif  // COMPONENTS_POLICY_CORE_COMMON_CLOUD_MOCK_CLOUD_POLICY_SERVICE_H_
