; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel  -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32

define i1 @eq_i32(i32 %a, i32 %b){
; MIPS32-LABEL: eq_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    xor $1, $4, $5
; MIPS32-NEXT:    sltiu $2, $1, 1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp eq i32 %a, %b
  ret i1 %cmp
}

define i1 @ne_i32(i32 %a, i32 %b) {
; MIPS32-LABEL: ne_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    xor $1, $4, $5
; MIPS32-NEXT:    sltu $2, $zero, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ne i32 %a, %b
  ret i1 %cmp
}

define i1 @sgt_i32(i32 %a, i32 %b) {
; MIPS32-LABEL: sgt_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $2, $5, $4
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp sgt i32 %a, %b
  ret i1 %cmp
}

define i1 @sge_i32(i32 %a, i32 %b) {
; MIPS32-LABEL: sge_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $1, $4, $5
; MIPS32-NEXT:    xori $2, $1, 1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp sge i32 %a, %b
  ret i1 %cmp
}

define i1 @slt_i32(i32 %a, i32 %b) {
; MIPS32-LABEL: slt_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $2, $4, $5
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp slt i32 %a, %b
  ret i1 %cmp
}

define i1 @sle_i32(i32 %a, i32 %b) {
; MIPS32-LABEL: sle_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $1, $5, $4
; MIPS32-NEXT:    xori $2, $1, 1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp sle i32 %a, %b
  ret i1 %cmp
}

define i1 @ugt_i32(i32 %a, i32 %b) {
; MIPS32-LABEL: ugt_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $2, $5, $4
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ugt i32 %a, %b
  ret i1 %cmp
}

define i1 @uge_i32(i32 %a, i32 %b) {
; MIPS32-LABEL: uge_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $1, $4, $5
; MIPS32-NEXT:    xori $2, $1, 1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp uge i32 %a, %b
  ret i1 %cmp
}

define i1 @ult_i32(i32 %a, i32 %b) {
; MIPS32-LABEL: ult_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $2, $4, $5
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ult i32 %a, %b
  ret i1 %cmp
}

define i1 @ule_i32(i32 %a, i32 %b) {
; MIPS32-LABEL: ule_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $1, $5, $4
; MIPS32-NEXT:    xori $2, $1, 1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ule i32 %a, %b
  ret i1 %cmp
}

define i1 @eq_ptr(i32* %a, i32* %b){
; MIPS32-LABEL: eq_ptr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    xor $1, $4, $5
; MIPS32-NEXT:    sltiu $2, $1, 1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp eq i32* %a, %b
  ret i1 %cmp
}

define i1 @ult_i8(i8 %a, i8 %b) {
; MIPS32-LABEL: ult_i8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    ori $1, $zero, 255
; MIPS32-NEXT:    and $2, $4, $1
; MIPS32-NEXT:    and $1, $5, $1
; MIPS32-NEXT:    sltu $2, $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ult i8 %a, %b
  ret i1 %cmp
}

define i1 @slt_i16(i16 %a, i16 %b) {
; MIPS32-LABEL: slt_i16:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sll $1, $4, 16
; MIPS32-NEXT:    sra $1, $1, 16
; MIPS32-NEXT:    sll $2, $5, 16
; MIPS32-NEXT:    sra $2, $2, 16
; MIPS32-NEXT:    slt $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp slt i16 %a, %b
  ret i1 %cmp
}

define i1 @eq_i64(i64 %a, i64 %b){
; MIPS32-LABEL: eq_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    xor $1, $4, $6
; MIPS32-NEXT:    xor $2, $5, $7
; MIPS32-NEXT:    or $1, $1, $2
; MIPS32-NEXT:    ori $2, $zero, 0
; MIPS32-NEXT:    xor $1, $1, $2
; MIPS32-NEXT:    sltiu $2, $1, 1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp eq i64 %a, %b
  ret i1 %cmp
}

define i1 @ne_i64(i64 %a, i64 %b) {
; MIPS32-LABEL: ne_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    xor $1, $4, $6
; MIPS32-NEXT:    xor $2, $5, $7
; MIPS32-NEXT:    or $1, $1, $2
; MIPS32-NEXT:    ori $2, $zero, 0
; MIPS32-NEXT:    xor $1, $1, $2
; MIPS32-NEXT:    sltu $2, $zero, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ne i64 %a, %b
  ret i1 %cmp
}

define i1 @sgt_i64(i64 %a, i64 %b) {
; MIPS32-LABEL: sgt_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $1, $7, $5
; MIPS32-NEXT:    xor $2, $5, $7
; MIPS32-NEXT:    sltiu $2, $2, 1
; MIPS32-NEXT:    sltu $3, $6, $4
; MIPS32-NEXT:    ori $4, $zero, 1
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    movn $1, $3, $2
; MIPS32-NEXT:    move $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp sgt i64 %a, %b
  ret i1 %cmp
}

define i1 @sge_i64(i64 %a, i64 %b) {
; MIPS32-LABEL: sge_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $1, $5, $7
; MIPS32-NEXT:    xori $1, $1, 1
; MIPS32-NEXT:    xor $2, $5, $7
; MIPS32-NEXT:    sltiu $2, $2, 1
; MIPS32-NEXT:    sltu $3, $4, $6
; MIPS32-NEXT:    xori $3, $3, 1
; MIPS32-NEXT:    ori $4, $zero, 1
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    movn $1, $3, $2
; MIPS32-NEXT:    move $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp sge i64 %a, %b
  ret i1 %cmp
}

define i1 @slt_i64(i64 %a, i64 %b) {
; MIPS32-LABEL: slt_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $1, $5, $7
; MIPS32-NEXT:    xor $2, $5, $7
; MIPS32-NEXT:    sltiu $2, $2, 1
; MIPS32-NEXT:    sltu $3, $4, $6
; MIPS32-NEXT:    ori $4, $zero, 1
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    movn $1, $3, $2
; MIPS32-NEXT:    move $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp slt i64 %a, %b
  ret i1 %cmp
}

define i1 @sle_i64(i64 %a, i64 %b) {
; MIPS32-LABEL: sle_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $1, $7, $5
; MIPS32-NEXT:    xori $1, $1, 1
; MIPS32-NEXT:    xor $2, $5, $7
; MIPS32-NEXT:    sltiu $2, $2, 1
; MIPS32-NEXT:    sltu $3, $6, $4
; MIPS32-NEXT:    xori $3, $3, 1
; MIPS32-NEXT:    ori $4, $zero, 1
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    movn $1, $3, $2
; MIPS32-NEXT:    move $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp sle i64 %a, %b
  ret i1 %cmp
}

define i1 @ugt_i64(i64 %a, i64 %b) {
; MIPS32-LABEL: ugt_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $1, $7, $5
; MIPS32-NEXT:    xor $2, $5, $7
; MIPS32-NEXT:    sltiu $2, $2, 1
; MIPS32-NEXT:    sltu $3, $6, $4
; MIPS32-NEXT:    ori $4, $zero, 1
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    movn $1, $3, $2
; MIPS32-NEXT:    move $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ugt i64 %a, %b
  ret i1 %cmp
}

define i1 @uge_i64(i64 %a, i64 %b) {
; MIPS32-LABEL: uge_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $1, $5, $7
; MIPS32-NEXT:    xori $1, $1, 1
; MIPS32-NEXT:    xor $2, $5, $7
; MIPS32-NEXT:    sltiu $2, $2, 1
; MIPS32-NEXT:    sltu $3, $4, $6
; MIPS32-NEXT:    xori $3, $3, 1
; MIPS32-NEXT:    ori $4, $zero, 1
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    movn $1, $3, $2
; MIPS32-NEXT:    move $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp uge i64 %a, %b
  ret i1 %cmp
}

define i1 @ult_i64(i64 %a, i64 %b) {
; MIPS32-LABEL: ult_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $1, $5, $7
; MIPS32-NEXT:    xor $2, $5, $7
; MIPS32-NEXT:    sltiu $2, $2, 1
; MIPS32-NEXT:    sltu $3, $4, $6
; MIPS32-NEXT:    ori $4, $zero, 1
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    movn $1, $3, $2
; MIPS32-NEXT:    move $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ult i64 %a, %b
  ret i1 %cmp
}

define i1 @ule_i64(i64 %a, i64 %b) {
; MIPS32-LABEL: ule_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $1, $7, $5
; MIPS32-NEXT:    xori $1, $1, 1
; MIPS32-NEXT:    xor $2, $5, $7
; MIPS32-NEXT:    sltiu $2, $2, 1
; MIPS32-NEXT:    sltu $3, $6, $4
; MIPS32-NEXT:    xori $3, $3, 1
; MIPS32-NEXT:    ori $4, $zero, 1
; MIPS32-NEXT:    and $2, $2, $4
; MIPS32-NEXT:    movn $1, $3, $2
; MIPS32-NEXT:    move $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ule i64 %a, %b
  ret i1 %cmp
}
