#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "si46xx.h"
#include "si46xx_props.h"

#define PROPERTY_NAME(prop)	{.id = prop, .name = #prop}
#define ARRAY_SIZE(arr)		(sizeof(arr) / sizeof((arr)[0]))

struct si46xx_property {
	int id;
	char *name;
};

struct si46xx_property si46xx_common_property_list[] = {
	PROPERTY_NAME(INT_CTL_ENABLE),
	PROPERTY_NAME(INT_CTL_REPEAT),
	PROPERTY_NAME(DIGITAL_IO_OUTPUT_SELECT),
	PROPERTY_NAME(DIGITAL_IO_OUTPUT_SAMPLE_RATE),
	PROPERTY_NAME(DIGITAL_IO_OUTPUT_FORMAT),
	PROPERTY_NAME(DIGITAL_IO_OUTPUT_SAMPLE_RATE),
	PROPERTY_NAME(DIGITAL_IO_OUTPUT_FORMAT),
	PROPERTY_NAME(DIGITAL_IO_OUTPUT_FORMAT_OVERRIDES_1),
	PROPERTY_NAME(DIGITAL_IO_OUTPUT_FORMAT_OVERRIDES_2),
	PROPERTY_NAME(DIGITAL_IO_OUTPUT_FORMAT_OVERRIDES_3),
	PROPERTY_NAME(DIGITAL_IO_OUTPUT_FORMAT_OVERRIDES_4),
	PROPERTY_NAME(AUDIO_ANALOG_VOLUME),
	PROPERTY_NAME(AUDIO_MUTE),
	PROPERTY_NAME(PIN_CONFIG_ENABLE),
};

struct si46xx_property si46xx_fm_property_list[] = {
	PROPERTY_NAME(FM_TUNE_FE_VARM),
        PROPERTY_NAME(FM_TUNE_FE_VARB),
        PROPERTY_NAME(FM_TUNE_FE_CFG),
        PROPERTY_NAME(FM_SEEK_BAND_BOTTOM),
        PROPERTY_NAME(FM_SEEK_BAND_TOP),
        PROPERTY_NAME(FM_SEEK_FREQUENCY_SPACING),
        PROPERTY_NAME(FM_VALID_MAX_TUNE_ERROR),
        PROPERTY_NAME(FM_VALID_RSSI_TIME),
        PROPERTY_NAME(FM_VALID_RSSI_THRESHOLD),
        PROPERTY_NAME(FM_VALID_SNR_TIME),
        PROPERTY_NAME(FM_VALID_SNR_THRESHOLD),
        PROPERTY_NAME(FM_RSQ_INTERRUPT_SOURCE),
        PROPERTY_NAME(FM_RSQ_SNR_HIGH_THRESHOLD),
        PROPERTY_NAME(FM_RSQ_SNR_LOW_THRESHOLD),
        PROPERTY_NAME(FM_RSQ_RSSI_HIGH_THRESHOLD),
        PROPERTY_NAME(FM_RSQ_RSSI_LOW_THRESHOLD),
        PROPERTY_NAME(FM_RSQ_HD_DETECTION),
        PROPERTY_NAME(FM_ACF_INTERRUPT_SOURCE),
        PROPERTY_NAME(FM_ACF_SOFTMUTE_THRESHOLD),
        PROPERTY_NAME(FM_ACF_HIGHCUT_THRESHOLD),
        PROPERTY_NAME(FM_ACF_BLEND_THRESHOLD),
        PROPERTY_NAME(FM_ACF_SOFTMUTE_TOLERANCE),
        PROPERTY_NAME(FM_ACF_HIGHCUT_TOLERANCE),
        PROPERTY_NAME(FM_ACF_BLEND_TOLERANCE),
        PROPERTY_NAME(FM_SOFTMUTE_SNR_LIMITS),
        PROPERTY_NAME(FM_SOFTMUTE_SNR_ATTENUATION),
        PROPERTY_NAME(FM_SOFTMUTE_SNR_ATTACK_TIME),
        PROPERTY_NAME(FM_SOFTMUTE_SNR_RELEASE_TIME),
        PROPERTY_NAME(FM_HIGHCUT_RSSI_LIMITS),
        PROPERTY_NAME(FM_HIGHCUT_RSSI_CUTOFF_FREQ),
        PROPERTY_NAME(FM_HIGHCUT_RSSI_ATTACK_TIME),
        PROPERTY_NAME(FM_HIGHCUT_RSSI_RELEASE_TIME),
        PROPERTY_NAME(FM_HIGHCUT_SNR_LIMITS),
        PROPERTY_NAME(FM_HIGHCUT_SNR_CUTOFF_FREQ),
        PROPERTY_NAME(FM_HIGHCUT_SNR_ATTACK_TIME),
        PROPERTY_NAME(FM_HIGHCUT_SNR_RELEASE_TIME),
        PROPERTY_NAME(FM_HIGHCUT_MULTIPATH_LIMITS),
        PROPERTY_NAME(FM_HIGHCUT_MULTIPATH_CUTOFF_FREQ),
        PROPERTY_NAME(FM_HIGHCUT_MULTIPATH_ATTACK_TIME),
        PROPERTY_NAME(FM_HIGHCUT_MULTIPATH_RELEASE_TIME),
        PROPERTY_NAME(FM_BLEND_RSSI_LIMITS),
        PROPERTY_NAME(FM_BLEND_RSSI_ATTACK_TIME),
        PROPERTY_NAME(FM_BLEND_RSSI_RELEASE_TIME),
        PROPERTY_NAME(FM_BLEND_SNR_LIMITS),
        PROPERTY_NAME(FM_BLEND_SNR_ATTACK_TIME),
        PROPERTY_NAME(FM_BLEND_SNR_RELEASE_TIME),
        PROPERTY_NAME(FM_BLEND_MULTIPATH_LIMITS),
        PROPERTY_NAME(FM_BLEND_MULTIPATH_ATTACK_TIME),
        PROPERTY_NAME(FM_BLEND_MULTIPATH_RELEASE_TIME),
        PROPERTY_NAME(FM_AUDIO_DE_EMPHASIS),
        PROPERTY_NAME(FM_RDS_INTERRUPT_SOURCE),
        PROPERTY_NAME(FM_RDS_INTERRUPT_FIFO_COUNT),
        PROPERTY_NAME(FM_RDS_CONFIG),
        PROPERTY_NAME(FM_RDS_CONFIDENCE),
        PROPERTY_NAME(DIGITAL_SERVICE_INT_SOURCE),
        PROPERTY_NAME(HD_BLEND_OPTIONS),
        PROPERTY_NAME(HD_BLEND_ANALOG_TO_HD_TRANSITION_TIME),
        PROPERTY_NAME(HD_BLEND_HD_TO_ANALOG_TRANSITION_TIME),
        PROPERTY_NAME(HD_BLEND_DYNAMIC_GAIN),
        PROPERTY_NAME(HD_DIGRAD_INTERRUPT_SOURCE),
        PROPERTY_NAME(HD_DIGRAD_CDNR_LOW_THRESHOLD),
        PROPERTY_NAME(HD_DIGRAD_CDNR_HIGH_THRESHOLD),
        PROPERTY_NAME(HD_DIGRAD_AUTO_ACQUIRE),
        PROPERTY_NAME(HD_EVENT_INTERRUPT_SOURCE),
        PROPERTY_NAME(HD_EVENT_SIS_CONFIG),
        PROPERTY_NAME(HD_EVENT_ALERT_CONFIG),
        PROPERTY_NAME(HD_PSD_ENABLE),
        PROPERTY_NAME(HD_PSD_FIELD_MASK),
        PROPERTY_NAME(HD_AUDIO_CTRL_FRAME_DELAY),
        PROPERTY_NAME(HD_AUDIO_CTRL_PROGRAM_LOSS_THRESHOLD),
        PROPERTY_NAME(HD_AUDIO_CTRL_BALL_GAME_ENABLE),
        PROPERTY_NAME(HD_CODEC_MODE_0_SAMPLES_DELAY),
        PROPERTY_NAME(HD_CODEC_MODE_2_SAMPLES_DELAY),
        PROPERTY_NAME(HD_CODEC_MODE_10_SAMPLES_DELAY),
        PROPERTY_NAME(HD_CODEC_MODE_13_SAMPLES_DELAY),
        PROPERTY_NAME(HD_TEST_BER_CONFIG),
        PROPERTY_NAME(HD_TEST_DEBUG_AUDIO),
};

struct si46xx_property si46xx_am_property_list[] = {
	PROPERTY_NAME(SI46XX_AM_SEEK_BAND_BOTTOM),
	PROPERTY_NAME(SI46XX_AM_SEEK_BAND_TOP),
	PROPERTY_NAME(SI46XX_AM_SEEK_FREQUENCY_SPACING),
	PROPERTY_NAME(SI46XX_AM_VALID_RSSI_THRESHOLD),
	PROPERTY_NAME(SI46XX_AM_VALID_SNR_THRESHOLD),
};

struct si46xx_property si46xx_flash_property_list[] = {
	PROPERTY_NAME(BL_SPI_CLOCK_FREQ_KHZ),
	PROPERTY_NAME(BL_SPI_MODE),
	PROPERTY_NAME(BL_READ_CMD),
	PROPERTY_NAME(BL_HIGH_SPEED_READ_CMD),
	PROPERTY_NAME(BL_HIGH_SPEED_READ_MAX_FREQ_MHZ),
	PROPERTY_NAME(BL_WRITE_CMD),
	PROPERTY_NAME(BL_ERASE_SECTOR_CMD),
	PROPERTY_NAME(BL_ERASE_CHIP_CMD),
};

char *si46xx_property_name(int id, int mode)
{
	int i;

	for (i = 0; i < ARRAY_SIZE(si46xx_common_property_list); i++)
		if (si46xx_common_property_list[i].id == id)
			return si46xx_common_property_list[i].name;

	if (mode == SI46XX_MODE_AM) {
		for (i = 0; i < ARRAY_SIZE(si46xx_am_property_list); i++)
			if (si46xx_am_property_list[i].id == id)
				return si46xx_am_property_list[i].name;
	} else if (mode == SI46XX_MODE_FM) {
		for (i = 0; i < ARRAY_SIZE(si46xx_fm_property_list); i++)
			if (si46xx_fm_property_list[i].id == id)
				return si46xx_fm_property_list[i].name;
	} else if (mode == SI46XX_MODE_BOOT) {
		for (i = 0; i < ARRAY_SIZE(si46xx_flash_property_list); i++)
			if (si46xx_flash_property_list[i].id == id)
				return si46xx_flash_property_list[i].name;
	}

	return NULL;
}
