/*
 * Copyright 2018-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *     http://aws.amazon.com/apache2.0/
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
#include "AASBControllerImpl.h"

#include <aasb/AASBControllerFactory.h>

using AASBControllerImpl = aasb::bridge::AASBControllerImpl;

namespace aasb {
namespace bridge {

std::shared_ptr<IAASBController> AASBControllerFactory::createAASBController() {
    return std::shared_ptr<IAASBController>(new AASBControllerImpl());
}

}  // namespace bridge
}  // namespace aasb