SUMMARY = "Network monitoring tools"
DESCRIPTION = "Utilities for the IP protocol, including traceroute6, \
tracepath, tracepath6, ping, ping6 and arping."
HOMEPAGE = "https://github.com/iputils/iputils"
SECTION = "console/network"

LICENSE = "BSD & GPLv2+"

LIC_FILES_CHKSUM = "file://LICENSE;md5=55aa8c9fcad0691cef0ecd420361e390"

DEPENDS = "gnutls"

SRC_URI = "git://github.com/iputils/iputils;branch=master;protocol=https \
           file://0001-ninfod-change-variable-name-to-avoid-colliding-with-.patch \
           file://0001-ninfod-fix-systemd-Documentation-url-error.patch \
           file://0001-rarpd-rdisc-Drop-PrivateUsers.patch \
           file://0001-iputils-Initialize-libgcrypt.patch \
           file://0001-arping-revert-partially-fix-sent-vs-received-package.patch \
           file://0002-arping-fix-f-quit-on-first-reply-regression.patch \
           file://0003-arping-Fix-comparison-of-different-signedness-warnin.patch \
           file://0004-arping-return-success-when-unsolicited-ARP-mode-dest.patch \
           file://0005-arping-use-additional-timerfd-to-control-when-timeou.patch \
           file://0001-arping-make-update-neighbours-work-again.patch \
           "
SRCREV = "13e00847176aa23683d68fce1d17ffb523510946"

S = "${WORKDIR}/git"

UPSTREAM_CHECK_GITTAGREGEX = "(?P<pver>s\d+)"

# Fixed in 2000-10-10, but the versioning of iputils
# breaks the version order.
CVE_CHECK_WHITELIST += "CVE-2000-1213 CVE-2000-1214"

PACKAGECONFIG ??= "libcap libgcrypt rarpd \
                   ${@bb.utils.contains('DISTRO_FEATURES', 'ipv6', 'ninfod traceroute6', '', d)} \
                   ${@bb.utils.filter('DISTRO_FEATURES', 'systemd', d)}"
PACKAGECONFIG[libcap] = "-DUSE_CAP=true, -DUSE_CAP=false, libcap"
PACKAGECONFIG[libgcrypt] = "-DUSE_CRYPTO=gcrypt, -DUSE_CRYPTO=none, libgcrypt"
PACKAGECONFIG[libidn] = "-DUSE_IDN=true, -DUSE_IDN=false, libidn2"
PACKAGECONFIG[gettext] = "-DUSE_GETTEXT=true, -DUSE_GETTEXT=false, gettext"
PACKAGECONFIG[ninfod] = "-DBUILD_NINFOD=true,-DBUILD_NINFOD=false,"
PACKAGECONFIG[rarpd] = "-DBUILD_RARPD=true,-DBUILD_RARPD=false,"
PACKAGECONFIG[systemd] = "-Dsystemdunitdir=${systemd_unitdir}/system,,systemd"
PACKAGECONFIG[traceroute6] = "-DBUILD_TRACEROUTE6=true,-DBUILD_TRACEROUTE6=false,"
PACKAGECONFIG[docs] = "-DBUILD_HTML_MANS=true -DBUILD_MANS=true,-DBUILD_HTML_MANS=false -DBUILD_MANS=false, libxslt"

inherit meson systemd update-alternatives

# Have to disable setcap/suid as its not deterministic
EXTRA_OEMESON += "--prefix=${root_prefix}/ -DNO_SETCAP_OR_SUID=true"

ALTERNATIVE_PRIORITY = "100"

ALTERNATIVE_${PN}-ping = "ping"
ALTERNATIVE_LINK_NAME[ping] = "${base_bindir}/ping"

SPLITPKGS = "${PN}-ping ${PN}-arping ${PN}-tracepath ${PN}-clockdiff ${PN}-tftpd ${PN}-rdisc \
             ${@bb.utils.contains('PACKAGECONFIG', 'rarpd', '${PN}-rarpd', '', d)} \
             ${@bb.utils.contains('DISTRO_FEATURES', 'ipv6', '${PN}-traceroute6 ${PN}-ninfod', '', d)}"
PACKAGES += "${SPLITPKGS}"

ALLOW_EMPTY_${PN} = "1"
RDEPENDS_${PN} += "${SPLITPKGS}"

FILES_${PN} = ""
FILES_${PN}-ping = "${base_bindir}/ping.${BPN}"
FILES_${PN}-arping = "${base_bindir}/arping"
FILES_${PN}-tracepath = "${base_bindir}/tracepath"
FILES_${PN}-traceroute6	= "${base_bindir}/traceroute6"
FILES_${PN}-clockdiff = "${base_bindir}/clockdiff"
FILES_${PN}-tftpd = "${base_bindir}/tftpd"
FILES_${PN}-rarpd = "${base_sbindir}/rarpd  ${systemd_unitdir}/system/rarpd@.service"
FILES_${PN}-rdisc = "${base_sbindir}/rdisc"
FILES_${PN}-ninfod = "${base_sbindir}/ninfod ${sysconfdir}/init.d/ninfod.sh"

SYSTEMD_PACKAGES = "${@bb.utils.contains('DISTRO_FEATURES', 'ipv6', '${PN}-ninfod', '', d)} \
                    ${PN}-rdisc"
SYSTEMD_SERVICE_${PN}-ninfod = "ninfod.service"
SYSTEMD_SERVICE_${PN}-rdisc = "rdisc.service"
