SUMMARY = "PNG image format decoding library"
DESCRIPTION = "An open source project to develop and maintain the reference \
library for use in applications that read, create, and manipulate PNG \
(Portable Network Graphics) raster image files. "
HOMEPAGE = "http://www.libpng.org/"
SECTION = "libs"
LICENSE = "Libpng"
LIC_FILES_CHKSUM = "file://LICENSE;md5=b0085051bf265bac2bfc38bc89f50000"
DEPENDS = "zlib"

LIBV = "16"

SRC_URI = "\
           ${SOURCEFORGE_MIRROR}/${BPN}/${BPN}${LIBV}/${BP}.tar.xz \
           file://run-ptest \
           "
SRC_URI[md5sum] = "015e8e15db1eecde5f2eb9eb5b6e59e9"
SRC_URI[sha256sum] = "505e70834d35383537b6491e7ae8641f1a4bed1876dbfe361201fc80868d88ca"

MIRRORS += "${SOURCEFORGE_MIRROR}/${BPN}/${BPN}${LIBV}/ ${SOURCEFORGE_MIRROR}/${BPN}/${BPN}${LIBV}/older-releases/"

UPSTREAM_CHECK_URI = "http://libpng.org/pub/png/libpng.html"

BINCONFIG = "${bindir}/libpng-config ${bindir}/libpng16-config"

inherit autotools binconfig-disabled pkgconfig ptest

# Work around missing symbols
EXTRA_OECONF_append_class-target = " ${@bb.utils.contains("TUNE_FEATURES", "neon", "--enable-arm-neon=on", "--enable-arm-neon=off" ,d)}"

PACKAGES =+ "${PN}-tools"

FILES_${PN}-tools = "${bindir}/png-fix-itxt ${bindir}/pngfix ${bindir}/pngcp"

BBCLASSEXTEND = "native nativesdk"

# CVE-2019-17371 is actually a memory leak in gif2png 2.x
CVE_CHECK_WHITELIST += "CVE-2019-17371"

do_install_ptest() {
    install -m644 "${S}/pngtest.png" "${D}${PTEST_PATH}"
    install -m755 "${B}/.libs/pngfix" "${D}${PTEST_PATH}"
    install -m755 "${B}/.libs/pngtest" "${D}${PTEST_PATH}"
    install -m755 "${B}/.libs/pngstest" "${D}${PTEST_PATH}"
    install -m755 "${B}/.libs/timepng" "${D}${PTEST_PATH}"
}
