// Modified embenchen to direct to asm-wasm.
// Flags: --validate-asm --allow-natives-syntax --wasm-loop-unrolling

var EXPECTED_OUTPUT =
  'stretch tree of depth 10\t check: -1\n' +
  '1448\t trees of depth 4\t check: -1448\n' +
  '362\t trees of depth 6\t check: -362\n' +
  '90\t trees of depth 8\t check: -90\n' +
  'long lived tree of depth 9\t check: -1\n';
var Module = {
  arguments: [1],
  print: function(x) {Module.printBuffer += x + '\n';},
  preRun: [function() {Module.printBuffer = ''}],
  postRun: [function() {
    assertEquals(EXPECTED_OUTPUT, Module.printBuffer);
  }],
};

var Module;
if (typeof Module === 'undefined') Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');
if (!Module.expectedDataFileDownloads) {
  Module.expectedDataFileDownloads = 0;
  Module.finishedDataFileDownloads = 0;
}
Module.expectedDataFileDownloads++;
(function() {

  function runWithFS() {

function assert(check, msg) {
  if (!check) throw msg + new Error().stack;
}
Module['FS_createDataFile']('/', 'binarytrees.lua', [45, 45, 32, 84, 104, 101, 32, 67, 111, 109, 112, 117, 116, 101, 114, 32, 76, 97, 110, 103, 117, 97, 103, 101, 32, 66, 101, 110, 99, 104, 109, 97, 114, 107, 115, 32, 71, 97, 109, 101, 10, 45, 45, 32, 104, 116, 116, 112, 58, 47, 47, 98, 101, 110, 99, 104, 109, 97, 114, 107, 115, 103, 97, 109, 101, 46, 97, 108, 105, 111, 116, 104, 46, 100, 101, 98, 105, 97, 110, 46, 111, 114, 103, 47, 10, 45, 45, 32, 99, 111, 110, 116, 114, 105, 98, 117, 116, 101, 100, 32, 98, 121, 32, 77, 105, 107, 101, 32, 80, 97, 108, 108, 10, 10, 108, 111, 99, 97, 108, 32, 102, 117, 110, 99, 116, 105, 111, 110, 32, 66, 111, 116, 116, 111, 109, 85, 112, 84, 114, 101, 101, 40, 105, 116, 101, 109, 44, 32, 100, 101, 112, 116, 104, 41, 10, 32, 32, 105, 102, 32, 100, 101, 112, 116, 104, 32, 62, 32, 48, 32, 116, 104, 101, 110, 10, 32, 32, 32, 32, 108, 111, 99, 97, 108, 32, 105, 32, 61, 32, 105, 116, 101, 109, 32, 43, 32, 105, 116, 101, 109, 10, 32, 32, 32, 32, 100, 101, 112, 116, 104, 32, 61, 32, 100, 101, 112, 116, 104, 32, 45, 32, 49, 10, 32, 32, 32, 32, 108, 111, 99, 97, 108, 32, 108, 101, 102, 116, 44, 32, 114, 105, 103, 104, 116, 32, 61, 32, 66, 111, 116, 116, 111, 109, 85, 112, 84, 114, 101, 101, 40, 105, 45, 49, 44, 32, 100, 101, 112, 116, 104, 41, 44, 32, 66, 111, 116, 116, 111, 109, 85, 112, 84, 114, 101, 101, 40, 105, 44, 32, 100, 101, 112, 116, 104, 41, 10, 32, 32, 32, 32, 114, 101, 116, 117, 114, 110, 32, 123, 32, 105, 116, 101, 109, 44, 32, 108, 101, 102, 116, 44, 32, 114, 105, 103, 104, 116, 32, 125, 10, 32, 32, 101, 108, 115, 101, 10, 32, 32, 32, 32, 114, 101, 116, 117, 114, 110, 32, 123, 32, 105, 116, 101, 109, 32, 125, 10, 32, 32, 101, 110, 100, 10, 101, 110, 100, 10, 10, 108, 111, 99, 97, 108, 32, 102, 117, 110, 99, 116, 105, 111, 110, 32, 73, 116, 101, 109, 67, 104, 101, 99, 107, 40, 116, 114, 101, 101, 41, 10, 32, 32, 105, 102, 32, 116, 114, 101, 101, 91, 50, 93, 32, 116, 104, 101, 110, 10, 32, 32, 32, 32, 114, 101, 116, 117, 114, 110, 32, 116, 114, 101, 101, 91, 49, 93, 32, 43, 32, 73, 116, 101, 109, 67, 104, 101, 99, 107, 40, 116, 114, 101, 101, 91, 50, 93, 41, 32, 45, 32, 73, 116, 101, 109, 67, 104, 101, 99, 107, 40, 116, 114, 101, 101, 91, 51, 93, 41, 10, 32, 32, 101, 108, 115, 101, 10, 32, 32, 32, 32, 114, 101, 116, 117, 114, 110, 32, 116, 114, 101, 101, 91, 49, 93, 10, 32, 32, 101, 110, 100, 10, 101, 110, 100, 10, 10, 108, 111, 99, 97, 108, 32, 78, 32, 61, 32, 116, 111, 110, 117, 109, 98, 101, 114, 40, 97, 114, 103, 32, 97, 110, 100, 32, 97, 114, 103, 91, 49, 93, 41, 32, 111, 114, 32, 52, 10, 10, 105, 102, 32, 78, 32, 61, 61, 32, 48, 32, 116, 104, 101, 110, 10, 32, 32, 78, 32, 61, 32, 48, 10, 101, 108, 115, 101, 105, 102, 32, 78, 32, 61, 61, 32, 49, 32, 116, 104, 101, 110, 10, 32, 32, 78, 32, 61, 32, 57, 46, 53, 10, 101, 108, 115, 101, 105, 102, 32, 78, 32, 61, 61, 32, 50, 32, 116, 104, 101, 110, 10, 32, 32, 78, 32, 61, 32, 49, 49, 46, 57, 57, 10, 101, 108, 115, 101, 105, 102, 32, 78, 32, 61, 61, 32, 51, 32, 116, 104, 101, 110, 10, 32, 32, 78, 32, 61, 32, 49, 50, 46, 56, 53, 10, 101, 108, 115, 101, 105, 102, 32, 78, 32, 61, 61, 32, 52, 32, 116, 104, 101, 110, 10, 32, 32, 78, 32, 61, 32, 49, 52, 46, 55, 50, 10, 101, 108, 115, 101, 105, 102, 32, 78, 32, 61, 61, 32, 53, 32, 116, 104, 101, 110, 10, 32, 32, 78, 32, 61, 32, 49, 53, 46, 56, 50, 10, 101, 110, 100, 10, 10, 108, 111, 99, 97, 108, 32, 109, 105, 110, 100, 101, 112, 116, 104, 32, 61, 32, 52, 10, 108, 111, 99, 97, 108, 32, 109, 97, 120, 100, 101, 112, 116, 104, 32, 61, 32, 109, 105, 110, 100, 101, 112, 116, 104, 32, 43, 32, 50, 10, 105, 102, 32, 109, 97, 120, 100, 101, 112, 116, 104, 32, 60, 32, 78, 32, 116, 104, 101, 110, 32, 109, 97, 120, 100, 101, 112, 116, 104, 32, 61, 32, 78, 32, 101, 110, 100, 10, 10, 100, 111, 10, 32, 32, 108, 111, 99, 97, 108, 32, 115, 116, 114, 101, 116, 99, 104, 100, 101, 112, 116, 104, 32, 61, 32, 109, 97, 120, 100, 101, 112, 116, 104, 32, 43, 32, 49, 10, 32, 32, 108, 111, 99, 97, 108, 32, 115, 116, 114, 101, 116, 99, 104, 116, 114, 101, 101, 32, 61, 32, 66, 111, 116, 116, 111, 109, 85, 112, 84, 114, 101, 101, 40, 48, 44, 32, 115, 116, 114, 101, 116, 99, 104, 100, 101, 112, 116, 104, 41, 10, 32, 32, 105, 111, 46, 119, 114, 105, 116, 101, 40, 115, 116, 114, 105, 110, 103, 46, 102, 111, 114, 109, 97, 116, 40, 34, 115, 116, 114, 101, 116, 99, 104, 32, 116, 114, 101, 101, 32, 111, 102, 32, 100, 101, 112, 116, 104, 32, 37, 100, 92, 116, 32, 99, 104, 101, 99, 107, 58, 32, 37, 100, 92, 110, 34, 44, 10, 32, 32, 32, 32, 115, 116, 114, 101, 116, 99, 104, 100, 101, 112, 116, 104, 44, 32, 73, 116, 101, 109, 67, 104, 101, 99, 107, 40, 115, 116, 114, 101, 116, 99, 104, 116, 114, 101, 101, 41, 41, 41, 10, 101, 110, 100, 10, 10, 108, 111, 99, 97, 108, 32, 108, 111, 110, 103, 108, 105, 118, 101, 100, 116, 114, 101, 101, 32, 61, 32, 66, 111, 116, 116, 111, 109, 85, 112, 84, 114, 101, 101, 40, 48, 44, 32, 109, 97, 120, 100, 101, 112, 116, 104, 41, 10, 10, 102, 111, 114, 32, 100, 101, 112, 116, 104, 61, 109, 105, 110, 100, 101, 112, 116, 104, 44, 109, 97, 120, 100, 101, 112, 116, 104, 44, 50, 32, 100, 111, 10, 32, 32, 108, 111, 99, 97, 108, 32, 105, 116, 101, 114, 97, 116, 105, 111, 110, 115, 32, 61, 32, 50, 32, 94, 32, 40, 109, 97, 120, 100, 101, 112, 116, 104, 32, 45, 32, 100, 101, 112, 116, 104, 32, 43, 32, 109, 105, 110, 100, 101, 112, 116, 104, 41, 10, 32, 32, 108, 111, 99, 97, 108, 32, 99, 104, 101, 99, 107, 32, 61, 32, 48, 10, 32, 32, 102, 111, 114, 32, 105, 61, 49, 44, 105, 116, 101, 114, 97, 116, 105, 111, 110, 115, 32, 100, 111, 10, 32, 32, 32, 32, 99, 104, 101, 99, 107, 32, 61, 32, 99, 104, 101, 99, 107, 32, 43, 32, 73, 116, 101, 109, 67, 104, 101, 99, 107, 40, 66, 111, 116, 116, 111, 109, 85, 112, 84, 114, 101, 101, 40, 49, 44, 32, 100, 101, 112, 116, 104, 41, 41, 32, 43, 10, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 73, 116, 101, 109, 67, 104, 101, 99, 107, 40, 66, 111, 116, 116, 111, 109, 85, 112, 84, 114, 101, 101, 40, 45, 49, 44, 32, 100, 101, 112, 116, 104, 41, 41, 10, 32, 32, 101, 110, 100, 10, 32, 32, 105, 111, 46, 119, 114, 105, 116, 101, 40, 115, 116, 114, 105, 110, 103, 46, 102, 111, 114, 109, 97, 116, 40, 34, 37, 100, 92, 116, 32, 116, 114, 101, 101, 115, 32, 111, 102, 32, 100, 101, 112, 116, 104, 32, 37, 100, 92, 116, 32, 99, 104, 101, 99, 107, 58, 32, 37, 100, 92, 110, 34, 44, 10, 32, 32, 32, 32, 105, 116, 101, 114, 97, 116, 105, 111, 110, 115, 42, 50, 44, 32, 100, 101, 112, 116, 104, 44, 32, 99, 104, 101, 99, 107, 41, 41, 10, 101, 110, 100, 10, 10, 105, 111, 46, 119, 114, 105, 116, 101, 40, 115, 116, 114, 105, 110, 103, 46, 102, 111, 114, 109, 97, 116, 40, 34, 108, 111, 110, 103, 32, 108, 105, 118, 101, 100, 32, 116, 114, 101, 101, 32, 111, 102, 32, 100, 101, 112, 116, 104, 32, 37, 100, 92, 116, 32, 99, 104, 101, 99, 107, 58, 32, 37, 100, 92, 110, 34, 44, 10, 32, 32, 109, 97, 120, 100, 101, 112, 116, 104, 44, 32, 73, 116, 101, 109, 67, 104, 101, 99, 107, 40, 108, 111, 110, 103, 108, 105, 118, 101, 100, 116, 114, 101, 101, 41, 41, 41, 10], true, true);

  }
  if (Module['calledRun']) {
    runWithFS();
  } else {
    if (!Module['preRun']) Module['preRun'] = [];
    Module["preRun"].push(runWithFS); // FS is not initialized yet, wait for it
  }

})();

// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = (typeof Module !== 'undefined' ? Module : null) || {};

// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}

// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;

if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  if (!Module['print']) Module['print'] = function print(x) {
    process['stdout'].write(x + '\n');
  };
  if (!Module['printErr']) Module['printErr'] = function printErr(x) {
    process['stderr'].write(x + '\n');
  };

  var nodeFS = require('fs');
  var nodePath = require('path');

  Module['read'] = function read(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };

  Module['readBinary'] = function readBinary(filename) { return Module['read'](filename, true) };

  Module['load'] = function load(f) {
    globalEval(read(f));
  };

  Module['arguments'] = process['argv'].slice(2);

  module['exports'] = Module;
}
else if (ENVIRONMENT_IS_SHELL) {
  if (!Module['print']) Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm

  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function read() { throw 'no read() available (jsc?)' };
  }

  Module['readBinary'] = function readBinary(f) {
    return read(f, 'binary');
  };

  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

  this['Module'] = Module;

  eval("if (typeof gc === 'function' && gc.toString().indexOf('[native code]') > 0) var gc = undefined"); // wipe out the SpiderMonkey shell 'gc' function, which can confuse closure (uses it as a minified name, and it is then initted to a non-falsey value unexpectedly)
}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function read(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };

  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

  if (typeof console !== 'undefined') {
    if (!Module['print']) Module['print'] = function print(x) {
      console.log(x);
    };
    if (!Module['printErr']) Module['printErr'] = function printErr(x) {
      console.log(x);
    };
  } else {
    // Probably a worker, and without console.log. We can do very little here...
    var TRY_USE_DUMP = false;
    if (!Module['print']) Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }

  if (ENVIRONMENT_IS_WEB) {
    window['Module'] = Module;
  } else {
    Module['load'] = importScripts;
  }
}
else {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}

function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
  Module['load'] = function load(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
// *** Environment setup code ***

// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];

// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];

// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}



// === Auto-generated preamble library stuff ===

//========================================
// Runtime code shared with compiler
//========================================

var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      return '(((' +target + ')+' + (quantum-1) + ')&' + -quantum + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (isArrayType(type)) return true;
  if (/<?\{ ?[^}]* ?\}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type) {
    switch (type) {
      case 'i1': case 'i8': return 1;
      case 'i16': return 2;
      case 'i32': return 4;
      case 'i64': return 8;
      case 'float': return 4;
      case 'double': return 8;
      default: {
        if (type[type.length-1] === '*') {
          return Runtime.QUANTUM_SIZE; // A pointer
        } else if (type[0] === 'i') {
          var bits = parseInt(type.substr(1));
          assert(bits % 8 === 0);
          return bits/8;
        } else {
          return 0;
        }
      }
    }
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  STACK_ALIGN: 8,
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (!vararg && (type == 'i64' || type == 'double')) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    var index = 0;
    type.flatIndexes = type.fields.map(function(field) {
      index++;
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = Runtime.getAlignSize(field, size);
      } else if (Runtime.isStructType(field)) {
        if (field[1] === '0') {
          // this is [0 x something]. When inside another structure like here, it must be at the end,
          // and it adds no size
          // XXX this happens in java-nbody for example... assert(index === type.fields.length, 'zero-length in the middle!');
          size = 0;
          if (Types.types[field]) {
            alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
          } else {
            alignSize = type.alignSize || QUANTUM_SIZE;
          }
        } else {
          size = Types.types[field].flatSize;
          alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
        }
      } else if (field[0] == 'b') {
        // bN, large number field, like a [N x i8]
        size = field.substr(1)|0;
        alignSize = 1;
      } else if (field[0] === '<') {
        // vector type
        size = alignSize = Types.types[field].flatSize; // fully aligned
      } else if (field[0] === 'i') {
        // illegal integer field, that could not be legalized because it is an internal structure field
        // it is ok to have such fields, if we just use them as markers of field size and nothing more complex
        size = alignSize = parseInt(field.substr(1))/8;
        assert(size % 1 === 0, 'cannot handle non-byte-size field ' + field);
      } else {
        assert(false, 'invalid type for calculateStructAlignment');
      }
      if (type.packed) alignSize = 1;
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    if (type.name_ && type.name_[0] === '[') {
      // arrays have 2 elements, so we get the proper difference. then we scale here. that way we avoid
      // allocating a potentially huge array for [999999 x i8] etc.
      type.flatSize = parseInt(type.name_.substr(1))*type.flatSize/2;
    }
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2*(1 + i);
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  getAsmConst: function (code, numArgs) {
    // code is a constant string on the heap, so we can cache these
    if (!Runtime.asmConstCache) Runtime.asmConstCache = {};
    var func = Runtime.asmConstCache[code];
    if (func) return func;
    var args = [];
    for (var i = 0; i < numArgs; i++) {
      args.push(String.fromCharCode(36) + i); // $0, $1 etc
    }
    var source = Pointer_stringify(code);
    if (source[0] === '"') {
      // tolerate EM_ASM("..code..") even though EM_ASM(..code..) is correct
      if (source.indexOf('"', 1) === source.length-1) {
        source = source.substr(1, source.length-2);
      } else {
        // something invalid happened, e.g. EM_ASM("..code($0)..", input)
        abort('invalid EM_ASM input |' + source + '|. Please use EM_ASM(..code..) (no quotes) or EM_ASM({ ..code($0).. }, input) (to input values)');
      }
    }
    try {
      var evalled = eval('(function(' + args.join(',') + '){ ' + source + ' })'); // new Function does not allow upvars in node
    } catch(e) {
      Module.printErr('error in executing inline EM_ASM code: ' + e + ' on: \n\n' + source + '\n\nwith args |' + args + '| (make sure to use the right one out of EM_ASM, EM_ASM_ARGS, etc.)');
      throw e;
    }
    return Runtime.asmConstCache[code] = evalled;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function dynCall_wrapper() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xFF;

      if (buffer.length == 0) {
        if ((code & 0x80) == 0x00) {        // 0xxxxxxx
          return String.fromCharCode(code);
        }
        buffer.push(code);
        if ((code & 0xE0) == 0xC0) {        // 110xxxxx
          needed = 1;
        } else if ((code & 0xF0) == 0xE0) { // 1110xxxx
          needed = 2;
        } else {                            // 11110xxx
          needed = 3;
        }
        return '';
      }

      if (needed) {
        buffer.push(code);
        needed--;
        if (needed > 0) return '';
      }

      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var c4 = buffer[3];
      var ret;
      if (buffer.length == 2) {
        ret = String.fromCharCode(((c1 & 0x1F) << 6)  | (c2 & 0x3F));
      } else if (buffer.length == 3) {
        ret = String.fromCharCode(((c1 & 0x0F) << 12) | ((c2 & 0x3F) << 6)  | (c3 & 0x3F));
      } else {
        // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
        var codePoint = ((c1 & 0x07) << 18) | ((c2 & 0x3F) << 12) |
                        ((c3 & 0x3F) << 6)  | (c4 & 0x3F);
        ret = String.fromCharCode(
          Math.floor((codePoint - 0x10000) / 0x400) + 0xD800,
          (codePoint - 0x10000) % 0x400 + 0xDC00);
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function processJSString(string) {
      /* TODO: use TextEncoder when present,
        var encoder = new TextEncoder();
        encoder['encoding'] = "utf-8";
        var utf8Array = encoder['encode'](aMsg.data);
      */
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  getCompilerSetting: function (name) {
    throw 'You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work';
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = (((STACKTOP)+7)&-8); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = (((STATICTOP)+7)&-8); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = (((DYNAMICTOP)+7)&-8); if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 8))*(quantum ? quantum : 8); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+((low>>>0)))+((+((high>>>0)))*(+4294967296))) : ((+((low>>>0)))+((+((high|0)))*(+4294967296)))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}


Module['Runtime'] = Runtime;









//========================================
// Runtime essentials
//========================================

var __THREW__ = 0; // Used in checking for thrown exceptions.

var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;

var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;

function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}

var globalScope = this;

// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays; note that arrays are 8-bit).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = Module['_' + ident]; // closure exported function
    if (!func) func = eval('_' + ident); // explicit lookup
  } catch(e) {
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}

// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      value = intArrayFromString(value);
      type = 'array';
    }
    if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}

// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;

// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;

// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }

  var singleType = typeof types === 'string' ? types : null;

  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }

  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)|0)]=0;
    }
    return ret;
  }

  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }

  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];

    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }

    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }

    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later

    setValue(ret+i, curr, type);

    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }

  return ret;
}
Module['allocate'] = allocate;

function Pointer_stringify(ptr, /* optional */ length) {
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = false;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))|0)];
    if (t >= 128) hasUtf = true;
    else if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;

  var ret = '';

  if (!hasUtf) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }

  var utf8 = new Runtime.UTF8Processor();
  for (i = 0; i < length; i++) {
    t = HEAPU8[(((ptr)+(i))|0)];
    ret += utf8.processCChar(t);
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;

// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF16ToString(ptr) {
  var i = 0;

  var str = '';
  while (1) {
    var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
    if (codeUnit == 0)
      return str;
    ++i;
    // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
    str += String.fromCharCode(codeUnit);
  }
}
Module['UTF16ToString'] = UTF16ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF16LE form. The copy will require at most (str.length*2+1)*2 bytes of space in the HEAP.
function stringToUTF16(str, outPtr) {
  for(var i = 0; i < str.length; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[(((outPtr)+(i*2))>>1)]=codeUnit;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[(((outPtr)+(str.length*2))>>1)]=0;
}
Module['stringToUTF16'] = stringToUTF16;

// Given a pointer 'ptr' to a null-terminated UTF32LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF32ToString(ptr) {
  var i = 0;

  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}
Module['UTF32ToString'] = UTF32ToString;

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF32LE form. The copy will require at most (str.length+1)*4 bytes of space in the HEAP,
// but can use less, since str.length does not return the number of characters in the string, but the number of UTF-16 code units in the string.
function stringToUTF32(str, outPtr) {
  var iChar = 0;
  for(var iCodeUnit = 0; iCodeUnit < str.length; ++iCodeUnit) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    var codeUnit = str.charCodeAt(iCodeUnit); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++iCodeUnit);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[(((outPtr)+(iChar*4))>>2)]=codeUnit;
    ++iChar;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[(((outPtr)+(iChar*4))>>2)]=0;
}
Module['stringToUTF32'] = stringToUTF32;

function demangle(func) {
  var i = 3;
  // params, etc.
  var basicTypes = {
    'v': 'void',
    'b': 'bool',
    'c': 'char',
    's': 'short',
    'i': 'int',
    'l': 'long',
    'f': 'float',
    'd': 'double',
    'w': 'wchar_t',
    'a': 'signed char',
    'h': 'unsigned char',
    't': 'unsigned short',
    'j': 'unsigned int',
    'm': 'unsigned long',
    'x': 'long long',
    'y': 'unsigned long long',
    'z': '...'
  };
  var subs = [];
  var first = true;
  function dump(x) {
    //return;
    if (x) Module.print(x);
    Module.print(func);
    var pre = '';
    for (var a = 0; a < i; a++) pre += ' ';
    Module.print (pre + '^');
  }
  function parseNested() {
    i++;
    if (func[i] === 'K') i++; // ignore const
    var parts = [];
    while (func[i] !== 'E') {
      if (func[i] === 'S') { // substitution
        i++;
        var next = func.indexOf('_', i);
        var num = func.substring(i, next) || 0;
        parts.push(subs[num] || '?');
        i = next+1;
        continue;
      }
      if (func[i] === 'C') { // constructor
        parts.push(parts[parts.length-1]);
        i += 2;
        continue;
      }
      var size = parseInt(func.substr(i));
      var pre = size.toString().length;
      if (!size || !pre) { i--; break; } // counter i++ below us
      var curr = func.substr(i + pre, size);
      parts.push(curr);
      subs.push(curr);
      i += pre + size;
    }
    i++; // skip E
    return parts;
  }
  function parse(rawList, limit, allowVoid) { // main parser
    limit = limit || Infinity;
    var ret = '', list = [];
    function flushList() {
      return '(' + list.join(', ') + ')';
    }
    var name;
    if (func[i] === 'N') {
      // namespaced N-E
      name = parseNested().join('::');
      limit--;
      if (limit === 0) return rawList ? [name] : name;
    } else {
      // not namespaced
      if (func[i] === 'K' || (first && func[i] === 'L')) i++; // ignore const and first 'L'
      var size = parseInt(func.substr(i));
      if (size) {
        var pre = size.toString().length;
        name = func.substr(i + pre, size);
        i += pre + size;
      }
    }
    first = false;
    if (func[i] === 'I') {
      i++;
      var iList = parse(true);
      var iRet = parse(true, 1, true);
      ret += iRet[0] + ' ' + name + '<' + iList.join(', ') + '>';
    } else {
      ret = name;
    }
    paramLoop: while (i < func.length && limit-- > 0) {
      //dump('paramLoop');
      var c = func[i++];
      if (c in basicTypes) {
        list.push(basicTypes[c]);
      } else {
        switch (c) {
          case 'P': list.push(parse(true, 1, true)[0] + '*'); break; // pointer
          case 'R': list.push(parse(true, 1, true)[0] + '&'); break; // reference
          case 'L': { // literal
            i++; // skip basic type
            var end = func.indexOf('E', i);
            var size = end - i;
            list.push(func.substr(i, size));
            i += size + 2; // size + 'EE'
            break;
          }
          case 'A': { // array
            var size = parseInt(func.substr(i));
            i += size.toString().length;
            if (func[i] !== '_') throw '?';
            i++; // skip _
            list.push(parse(true, 1, true)[0] + ' [' + size + ']');
            break;
          }
          case 'E': break paramLoop;
          default: ret += '?' + c; break paramLoop;
        }
      }
    }
    if (!allowVoid && list.length === 1 && list[0] === 'void') list = []; // avoid (void)
    if (rawList) {
      if (ret) {
        list.push(ret + '?');
      }
      return list;
    } else {
      return ret + flushList();
    }
  }
  try {
    // Special-case the entry point, since its name differs from other name mangling.
    if (func == 'Object._main' || func == '_main') {
      return 'main()';
    }
    if (typeof func === 'number') func = Pointer_stringify(func);
    if (func[0] !== '_') return func;
    if (func[1] !== '_') return func; // C function
    if (func[2] !== 'Z') return func;
    switch (func[3]) {
      case 'n': return 'operator new()';
      case 'd': return 'operator delete()';
    }
    return parse();
  } catch(e) {
    return func;
  }
}

function demangleAll(text) {
  return text.replace(/__Z[\w\d_]+/g, function(x) { var y = demangle(x); return x === y ? x : (x + ' [' + y + ']') });
}

function stackTrace() {
  var stack = new Error().stack;
  return stack ? demangleAll(stack) : '(no stack trace available)'; // Stack trace is not available at least on IE10 and Safari 6.
}

// Memory management

var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return (x+4095)&-4096;
}

var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;

var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk

function enlargeMemory() {
  abort('Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value ' + TOTAL_MEMORY + ', (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.');
}

var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 134217728;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;

var totalMemory = 4096;
while (totalMemory < TOTAL_MEMORY || totalMemory < 2*TOTAL_STACK) {
  if (totalMemory < 16*1024*1024) {
    totalMemory *= 2;
  } else {
    totalMemory += 16*1024*1024
  }
}
if (totalMemory !== TOTAL_MEMORY) {
  Module.printErr('increasing TOTAL_MEMORY to ' + totalMemory + ' to be more reasonable');
  TOTAL_MEMORY = totalMemory;
}

// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'JS engine does not provide full typed array support');

var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);

// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');

Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;

function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}

var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited

var runtimeInitialized = false;

function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}

function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}

function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}

function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
}

function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module['addOnPreRun'] = Module.addOnPreRun = addOnPreRun;

function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module['addOnInit'] = Module.addOnInit = addOnInit;

function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module['addOnPreMain'] = Module.addOnPreMain = addOnPreMain;

function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module['addOnExit'] = Module.addOnExit = addOnExit;

function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module['addOnPostRun'] = Module.addOnPostRun = addOnPostRun;

// Tools

// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;

function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;

// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))|0)]=chr;
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;

function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;

function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=str.charCodeAt(i);
  }
  if (!dontAddNull) HEAP8[(((buffer)+(str.length))|0)]=0;
}
Module['writeAsciiToMemory'] = writeAsciiToMemory;

function unSign(value, bits, ignore) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}

// check for imul support, and also for correctness ( https://bugs.webkit.org/show_bug.cgi?id=126345 )
if (!Math['imul'] || Math['imul'](0xffffffff, 5) !== -5) Math['imul'] = function imul(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];


var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;

// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled

function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}
Module['removeRunDependency'] = removeRunDependency;

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data


var memoryInitializer = null;

// === Body ===





STATIC_BASE = 8;

STATICTOP = STATIC_BASE + Runtime.alignMemory(13467);
/* global initializers */ __ATINIT__.push();


/* memory initializer */ allocate([99,97,110,110,111,116,32,99,114,101,97,116,101,32,115,116,97,116,101,58,32,110,111,116,32,101,110,111,117,103,104,32,109,101,109,111,114,121,0,0,40,101,114,114,111,114,32,111,98,106,101,99,116,32,105,115,32,110,111,116,32,97,32,115,116,114,105,110,103,41,0,0,88,0,0,0,0,0,0,0,108,117,97,0,0,0,0,0,76,85,65,95,78,79,69,78,86,0,0,0,0,0,0,0,116,111,111,32,109,97,110,121,32,114,101,115,117,108,116,115,32,116,111,32,112,114,105,110,116,0,0,0,0,0,0,0,112,114,105,110,116,0,0,0,101,114,114,111,114,32,99,97,108,108,105,110,103,32,39,112,114,105,110,116,39,32,40,37,115,41,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,110,116,101,114,114,117,112,116,101,100,33,0,0,0,0,95,95,116,111,115,116,114,105,110,103,0,0,0,0,0,0,40,110,111,32,101,114,114,111,114,32,109,101,115,115,97,103,101,41,0,0,0,0,0,0,61,115,116,100,105,110,0,0,60,101,111,102,62,0,0,0,114,101,116,117,114,110,32,37,115,0,0,0,0,0,0,0,95,80,82,79,77,80,84,0,95,80,82,79,77,80,84,50,0,0,0,0,0,0,0,0,62,32,0,0,0,0,0,0,62,62,32,0,0,0,0,0,97,114,103,0,0,0,0,0,45,0,0,0,0,0,0,0,45,45,0,0,0,0,0,0,116,111,111,32,109,97,110,121,32,97,114,103,117,109,101,110,116,115,32,116,111,32,115,99,114,105,112,116,0,0,0,0,61,40,99,111,109,109,97,110,100,32,108,105,110,101,41,0,114,101,113,117,105,114,101,0,61,76,85,65,95,73,78,73,84,95,53,95,50,0,0,0,61,76,85,65,95,73,78,73,84,0,0,0,0,0,0,0,76,117,97,32,53,46,50,46,50,32,32,67,111,112,121,114,105,103,104,116,32,40,67,41,32,49,57,57,52,45,50,48,49,51,32,76,117,97,46,111,114,103,44,32,80,85,67,45,82,105,111,0,0,0,0,0,37,115,58,32,0,0,0,0,39,37,115,39,32,110,101,101,100,115,32,97,114,103,117,109,101,110,116,10,0,0,0,0,117,110,114,101,99,111,103,110,105,122,101,100,32,111,112,116,105,111,110,32,39,37,115,39,10,0,0,0,0,0,0,0,117,115,97,103,101,58,32,37,115,32,91,111,112,116,105,111,110,115,93,32,91,115,99,114,105,112,116,32,91,97,114,103,115,93,93,10,65,118,97,105,108,97,98,108,101,32,111,112,116,105,111,110,115,32,97,114,101,58,10,32,32,45,101,32,115,116,97,116,32,32,101,120,101,99,117,116,101,32,115,116,114,105,110,103,32,39,115,116,97,116,39,10,32,32,45,105,32,32,32,32,32,32,32,101,110,116,101,114,32,105,110,116,101,114,97,99,116,105,118,101,32,109,111,100,101,32,97,102,116,101,114,32,101,120,101,99,117,116,105,110,103,32,39,115,99,114,105,112,116,39,10,32,32,45,108,32,110,97,109,101,32,32,114,101,113,117,105,114,101,32,108,105,98,114,97,114,121,32,39,110,97,109,101,39,10,32,32,45,118,32,32,32,32,32,32,32,115,104,111,119,32,118,101,114,115,105,111,110,32,105,110,102,111,114,109,97,116,105,111,110,10,32,32,45,69,32,32,32,32,32,32,32,105,103,110,111,114,101,32,101,110,118,105,114,111,110,109,101,110,116,32,118,97,114,105,97,98,108,101,115,10,32,32,45,45,32,32,32,32,32,32,32,115,116,111,112,32,104,97,110,100,108,105,110,103,32,111,112,116,105,111,110,115,10,32,32,45,32,32,32,32,32,32,32,32,115,116,111,112,32,104,97,110,100,108,105,110,103,32,111,112,116,105,111,110,115,32,97,110,100,32,101,120,101,99,117,116,101,32,115,116,100,105,110,10,0,0,0,0,0,0,0,37,115,10,0,0,0,0,0,0,0,0,0,0,96,127,64,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,115,10,0,0,0,0,0,115,116,97,99,107,32,116,114,97,99,101,98,97,99,107,58,0,0,0,0,0,0,0,0,10,9,46,46,46,0,0,0,83,108,110,116,0,0,0,0,10,9,37,115,58,0,0,0,37,100,58,0,0,0,0,0,32,105,110,32,0,0,0,0,10,9,40,46,46,46,116,97,105,108,32,99,97,108,108,115,46,46,46,41,0,0,0,0,98,97,100,32,97,114,103,117,109,101,110,116,32,35,37,100,32,40,37,115,41,0,0,0,110,0,0,0,0,0,0,0,109,101,116,104,111,100,0,0,99,97,108,108,105,110,103,32,39,37,115,39,32,111,110,32,98,97,100,32,115,101,108,102,32,40,37,115,41,0,0,0,63,0,0,0,0,0,0,0,98,97,100,32,97,114,103,117,109,101,110,116,32,35,37,100,32,116,111,32,39,37,115,39,32,40,37,115,41,0,0,0,83,108,0,0,0,0,0,0,37,115,58,37,100,58,32,0,0,0,0,0,0,0,0,0,37,115,58,32,37,115,0,0,101,120,105,116,0,0,0,0,105,110,118,97,108,105,100,32,111,112,116,105,111,110,32,39,37,115,39,0,0,0,0,0,115,116,97,99,107,32,111,118,101,114,102,108,111,119,32,40,37,115,41,0,0,0,0,0,115,116,97,99,107,32,111,118,101,114,102,108,111,119,0,0,118,97,108,117,101,32,101,120,112,101,99,116,101,100,0,0,98,117,102,102,101,114,32,116,111,111,32,108,97,114,103,101,0,0,0,0,0,0,0,0,61,115,116,100,105,110,0,0,64,37,115,0,0,0,0,0,114,0,0,0,0,0,0,0,111,112,101,110,0,0,0,0,114,98,0,0,0,0,0,0,114,101,111,112,101,110,0,0,114,101,97,100,0,0,0,0,111,98,106,101,99,116,32,108,101,110,103,116,104,32,105,115,32,110,111,116,32,97,32,110,117,109,98,101,114,0,0,0,95,95,116,111,115,116,114,105,110,103,0,0,0,0,0,0,116,114,117,101,0,0,0,0,102,97,108,115,101,0,0,0,110,105,108,0,0,0,0,0,37,115,58,32,37,112,0,0,95,76,79,65,68,69,68,0,110,97,109,101,32,99,111,110,102,108,105,99,116,32,102,111,114,32,109,111,100,117,108,101,32,39,37,115,39,0,0,0,116,111,111,32,109,97,110,121,32,117,112,118,97,108,117,101,115,0,0,0,0,0,0,0,109,117,108,116,105,112,108,101,32,76,117,97,32,86,77,115,32,100,101,116,101,99,116,101,100,0,0,0,0,0,0,0,118,101,114,115,105,111,110,32,109,105,115,109,97,116,99,104,58,32,97,112,112,46,32,110,101,101,100,115,32,37,102,44,32,76,117,97,32,99,111,114,101,32,112,114,111,118,105,100,101,115,32,37,102,0,0,0,98,97,100,32,99,111,110,118,101,114,115,105,111,110,32,110,117,109,98,101,114,45,62,105,110,116,59,32,109,117,115,116,32,114,101,99,111,109,112,105,108,101,32,76,117,97,32,119,105,116,104,32,112,114,111,112,101,114,32,115,101,116,116,105,110,103,115,0,0,0,0,0,80,65,78,73,67,58,32,117,110,112,114,111,116,101,99,116,101,100,32,101,114,114,111,114,32,105,110,32,99,97,108,108,32,116,111,32,76,117,97,32,65,80,73,32,40,37,115,41,10,0,0,0,0,0,0,0,239,187,191,0,0,0,0,0,99,97,110,110,111,116,32,37,115,32,37,115,58,32,37,115,0,0,0,0,0,0,0,0,37,115,32,101,120,112,101,99,116,101,100,44,32,103,111,116,32,37,115,0,0,0,0,0,102,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,102,117,110,99,116,105,111,110,32,39,37,115,39,0,0,0,109,97,105,110,32,99,104,117,110,107,0,0,0,0,0,0,102,117,110,99,116,105,111,110,32,60,37,115,58,37,100,62,0,0,0,0,0,0,0,0,97,116,116,101,109,112,116,32,116,111,32,37,115,32,37,115,32,39,37,115,39,32,40,97,32,37,115,32,118,97,108,117,101,41,0,0,0,0,0,0,97,116,116,101,109,112,116,32,116,111,32,37,115,32,97,32,37,115,32,118,97,108,117,101,0,0,0,0,0,0,0,0,99,111,110,99,97,116,101,110,97,116,101,0,0,0,0,0,112,101,114,102,111,114,109,32,97,114,105,116,104,109,101,116,105,99,32,111,110,0,0,0,97,116,116,101,109,112,116,32,116,111,32,99,111,109,112,97,114,101,32,116,119,111,32,37,115,32,118,97,108,117,101,115,0,0,0,0,0,0,0,0,97,116,116,101,109,112,116,32,116,111,32,99,111,109,112,97,114,101,32,37,115,32,119,105,116,104,32,37,115,0,0,0,37,115,58,37,100,58,32,37,115,0,0,0,0,0,0,0,108,111,99,97,108,0,0,0,95,69,78,86,0,0,0,0,103,108,111,98,97,108,0,0,102,105,101,108,100,0,0,0,117,112,118,97,108,117,101,0,99,111,110,115,116,97,110,116,0,0,0,0,0,0,0,0,109,101,116,104,111,100,0,0,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,111,114,32,105,116,101,114,97,116,111,114,0,0,0,0,109,101,116,97,109,101,116,104,111,100,0,0,0,0,0,0,61,91,67,93,0,0,0,0,67,0,0,0,0,0,0,0,61,63,0,0,0,0,0,0,109,97,105,110,0,0,0,0,76,117,97,0,0,0,0,0,40,42,116,101,109,112,111,114,97,114,121,41,0,0,0,0,40,42,118,97,114,97,114,103,41,0,0,0,0,0,0,0,115,116,97,99,107,32,111,118,101,114,102,108,111,119,0,0,67,32,115,116,97,99,107,32,111,118,101,114,102,108,111,119,0,0,0,0,0,0,0,0,97,116,116,101,109,112,116,32,116,111,32,121,105,101,108,100,32,97,99,114,111,115,115,32,97,32,67,45,99,97,108,108,32,98,111,117,110,100,97,114,121,0,0,0,0,0,0,0,97,116,116,101,109,112,116,32,116,111,32,121,105,101,108,100,32,102,114,111,109,32,111,117,116,115,105,100,101,32,97,32,99,111,114,111,117,116,105,110,101,0,0,0,0,0,0,0,98,105,110,97,114,121,0,0,116,101,120,116,0,0,0,0,97,116,116,101,109,112,116,32,116,111,32,108,111,97,100,32,97,32,37,115,32,99,104,117,110,107,32,40,109,111,100,101,32,105,115,32,39,37,115,39,41,0,0,0,0,0,0,0,101,114,114,111,114,32,105,110,32,101,114,114,111,114,32,104,97,110,100,108,105,110,103,0,99,97,110,110,111,116,32,114,101,115,117,109,101,32,110,111,110,45,115,117,115,112,101,110,100,101,100,32,99,111,114,111,117,116,105,110,101,0,0,0,99,97,110,110,111,116,32,114,101,115,117,109,101,32,100,101,97,100,32,99,111,114,111,117,116,105,110,101,0,0,0,0,99,97,108,108,0,0,0,0,110,111,32,109,101,115,115,97,103,101,0,0,0,0,0,0,101,114,114,111,114,32,105,110,32,95,95,103,99,32,109,101,116,97,109,101,116,104,111,100,32,40,37,115,41,0,0,0,95,80,82,69,76,79,65,68,0,0,0,0,0,0,0,0,95,71,0,0,0,0,0,0,112,97,99,107,97,103,101,0,99,111,114,111,117,116,105,110,101,0,0,0,0,0,0,0,116,97,98,108,101,0,0,0,105,111,0,0,0,0,0,0,111,115,0,0,0,0,0,0,115,116,114,105,110,103,0,0,98,105,116,51,50,0,0,0,109,97,116,104,0,0,0,0,100,101,98,117,103,0,0,0,144,11,0,0,1,0,0,0,152,11,0,0,2,0,0,0,48,13,0,0,3,0,0,0,160,11,0,0,4,0,0,0,56,13,0,0,5,0,0,0,64,13,0,0,6,0,0,0,72,13,0,0,7,0,0,0,168,11,0,0,8,0,0,0,80,13,0,0,9,0,0,0,88,13,0,0,10,0,0,0,192,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,95,73,79,95,105,110,112,117,116,0,0,0,0,0,0,0,115,116,100,105,110,0,0,0,95,73,79,95,111,117,116,112,117,116,0,0,0,0,0,0,115,116,100,111,117,116,0,0,115,116,100,101,114,114,0,0,70,73,76,69,42,0,0,0,99,97,110,110,111,116,32,99,108,111,115,101,32,115,116,97,110,100,97,114,100,32,102,105,108,101,0,0,0,0,0,0,95,95,105,110,100,101,120,0,144,11,0,0,1,0,0,0,152,11,0,0,12,0,0,0,160,11,0,0,13,0,0,0,168,11,0,0,14,0,0,0,176,11,0,0,15,0,0,0,184,11,0,0,16,0,0,0,192,11,0,0,17,0,0,0,200,11,0,0,18,0,0,0,208,11,0,0,19,0,0,0,0,0,0,0,0,0,0,0,99,108,111,115,101,0,0,0,102,108,117,115,104,0,0,0,108,105,110,101,115,0,0,0,114,101,97,100,0,0,0,0,115,101,101,107,0,0,0,0,115,101,116,118,98,117,102,0,119,114,105,116,101,0,0,0,95,95,103,99,0,0,0,0,95,95,116,111,115,116,114,105,110,103,0,0,0,0,0,0,102,105,108,101,32,40,99,108,111,115,101,100,41,0,0,0,102,105,108,101,32,40,37,112,41,0,0,0,0,0,0,0,37,46,49,52,103,0,0,0,97,116,116,101,109,112,116,32,116,111,32,117,115,101,32,97,32,99,108,111,115,101,100,32,102,105,108,101,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,72,12,0,0,80,12,0,0,88,12,0,0,0,0,0,0,110,111,0,0,0,0,0,0,102,117,108,108,0,0,0,0,108,105,110,101,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,128,12,0,0,136,12,0,0,144,12,0,0,0,0,0,0,115,101,116,0,0,0,0,0,99,117,114,0,0,0,0,0,101,110,100,0,0,0,0,0,110,111,116,32,97,110,32,105,110,116,101,103,101,114,32,105,110,32,112,114,111,112,101,114,32,114,97,110,103,101,0,0,116,111,111,32,109,97,110,121,32,97,114,103,117,109,101,110,116,115,0,0,0,0,0,0,105,110,118,97,108,105,100,32,111,112,116,105,111,110,0,0,105,110,118,97,108,105,100,32,102,111,114,109,97,116,0,0,37,108,102,0,0,0,0,0,116,111,111,32,109,97,110,121,32,111,112,116,105,111,110,115,0,0,0,0,0,0,0,0,102,105,108,101,32,105,115,32,97,108,114,101,97,100,121,32,99,108,111,115,101,100,0,0,37,115,0,0,0,0,0,0,105,110,112,117,116,0,0,0,111,112,101,110,0,0,0,0,111,117,116,112,117,116,0,0,112,111,112,101,110,0,0,0,116,109,112,102,105,108,101,0,116,121,112,101,0,0,0,0,115,116,97,110,100,97,114,100,32,37,115,32,102,105,108,101,32,105,115,32,99,108,111,115,101,100,0,0,0,0,0,0,99,108,111,115,101,100,32,102,105,108,101,0,0,0,0,0,102,105,108,101,0,0,0,0,114,0,0,0,0,0,0,0,39,112,111,112,101,110,39,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,0,0,119,0,0,0,0,0,0,0,99,97,110,110,111,116,32,111,112,101,110,32,102,105,108,101,32,39,37,115,39,32,40,37,115,41,0,0,0,0,0,0,114,119,97,0,0,0,0,0,105,110,118,97,108,105,100,32,109,111,100,101,0,0,0,0,240,14,0,0,20,0,0,0,248,14,0,0,21,0,0,0,0,15,0,0,22,0,0,0,8,15,0,0,23,0,0,0,16,15,0,0,24,0,0,0,24,15,0,0,25,0,0,0,32,15,0,0,26,0,0,0,40,15,0,0,27,0,0,0,48,15,0,0,28,0,0,0,56,15,0,0,29,0,0,0,64,15,0,0,30,0,0,0,72,15,0,0,31,0,0,0,80,15,0,0,32,0,0,0,88,15,0,0,33,0,0,0,96,15,0,0,34,0,0,0,104,15,0,0,35,0,0,0,112,15,0,0,36,0,0,0,120,15,0,0,37,0,0,0,128,15,0,0,38,0,0,0,136,15,0,0,39,0,0,0,144,15,0,0,40,0,0,0,152,15,0,0,41,0,0,0,160,15,0,0,42,0,0,0,176,15,0,0,43,0,0,0,184,15,0,0,44,0,0,0,192,15,0,0,45,0,0,0,200,15,0,0,46,0,0,0,208,15,0,0,47,0,0,0,0,0,0,0,0,0,0,0,112,105,0,0,0,0,0,0,104,117,103,101,0,0,0,0,97,98,115,0,0,0,0,0,97,99,111,115,0,0,0,0,97,115,105,110,0,0,0,0,97,116,97,110,50,0,0,0,97,116,97,110,0,0,0,0,99,101,105,108,0,0,0,0,99,111,115,104,0,0,0,0,99,111,115,0,0,0,0,0,100,101,103,0,0,0,0,0,101,120,112,0,0,0,0,0,102,108,111,111,114,0,0,0,102,109,111,100,0,0,0,0,102,114,101,120,112,0,0,0,108,100,101,120,112,0,0,0,108,111,103,49,48,0,0,0,108,111,103,0,0,0,0,0,109,97,120,0,0,0,0,0,109,105,110,0,0,0,0,0,109,111,100,102,0,0,0,0,112,111,119,0,0,0,0,0,114,97,100,0,0,0,0,0,114,97,110,100,111,109,0,0,114,97,110,100,111,109,115,101,101,100,0,0,0,0,0,0,115,105,110,104,0,0,0,0,115,105,110,0,0,0,0,0,115,113,114,116,0,0,0,0,116,97,110,104,0,0,0,0,116,97,110,0,0,0,0,0,105,110,116,101,114,118,97,108,32,105,115,32,101,109,112,116,121,0,0,0,0,0,0,0,119,114,111,110,103,32,110,117,109,98,101,114,32,111,102,32,97,114,103,117,109,101,110,116,115,0,0,0,0,0,0,0,116,111,111,32,109,97,110,121,32,37,115,32,40,108,105,109,105,116,32,105,115,32,37,100,41,0,0,0,0,0,0,0,109,101,109,111,114,121,32,97,108,108,111,99,97,116,105,111,110,32,101,114,114,111,114,58,32,98,108,111,99,107,32,116,111,111,32,98,105,103,0,0,95,67,76,73,66,83,0,0,95,95,103,99,0,0,0,0,16,20,0,0,48,0,0,0,24,20,0,0,49,0,0,0,40,20,0,0,50,0,0,0,0,0,0,0,0,0,0,0,108,111,97,100,101,114,115,0,115,101,97,114,99,104,101,114,115,0,0,0,0,0,0,0,112,97,116,104,0,0,0,0,76,85,65,95,80,65,84,72,95,53,95,50,0,0,0,0,76,85,65,95,80,65,84,72,0,0,0,0,0,0,0,0,47,117,115,114,47,108,111,99,97,108,47,115,104,97,114,101,47,108,117,97,47,53,46,50,47,63,46,108,117,97,59,47,117,115,114,47,108,111,99,97,108,47,115,104,97,114,101,47,108,117,97,47,53,46,50,47,63,47,105,110,105,116,46,108,117,97,59,47,117,115,114,47,108,111,99,97,108,47,108,105,98,47,108,117,97,47,53,46,50,47,63,46,108,117,97,59,47,117,115,114,47,108,111,99,97,108,47,108,105,98,47,108,117,97,47,53,46,50,47,63,47,105,110,105,116,46,108,117,97,59,46,47,63,46,108,117,97,0,0,0,0,0,0,0,99,112,97,116,104,0,0,0,76,85,65,95,67,80,65,84,72,95,53,95,50,0,0,0,76,85,65,95,67,80,65,84,72,0,0,0,0,0,0,0,47,117,115,114,47,108,111,99,97,108,47,108,105,98,47,108,117,97,47,53,46,50,47,63,46,115,111,59,47,117,115,114,47,108,111,99,97,108,47,108,105,98,47,108,117,97,47,53,46,50,47,108,111,97,100,97,108,108,46,115,111,59,46,47,63,46,115,111,0,0,0,0,47,10,59,10,63,10,33,10,45,10,0,0,0,0,0,0,99,111,110,102,105,103,0,0,95,76,79,65,68,69,68,0,108,111,97,100,101,100,0,0,95,80,82,69,76,79,65,68,0,0,0,0,0,0,0,0,112,114,101,108,111,97,100,0,32,18,0,0,51,0,0,0,40,18,0,0,52,0,0,0,0,0,0,0,0,0,0,0,109,111,100,117,108,101,0,0,114,101,113,117,105,114,101,0,39,112,97,99,107,97,103,101,46,115,101,97,114,99,104,101,114,115,39,32,109,117,115,116,32,98,101,32,97,32,116,97,98,108,101,0,0,0,0,0,109,111,100,117,108,101,32,39,37,115,39,32,110,111,116,32,102,111,117,110,100,58,37,115,0,0,0,0,0,0,0,0,95,78,65,77,69,0,0,0,102,0,0,0,0,0,0,0,39,109,111,100,117,108,101,39,32,110,111,116,32,99,97,108,108,101,100,32,102,114,111,109,32,97,32,76,117,97,32,102,117,110,99,116,105,111,110,0,95,77,0,0,0,0,0,0,95,80,65,67,75,65,71,69,0,0,0,0,0,0,0,0,59,59,0,0,0,0,0,0,59,1,59,0,0,0,0,0,1,0,0,0,0,0,0,0,76,85,65,95,78,79,69,78,86,0,0,0,0,0,0,0,47,0,0,0,0,0,0,0,10,9,110,111,32,109,111,100,117,108,101,32,39,37,115,39,32,105,110,32,102,105,108,101,32,39,37,115,39,0,0,0,101,114,114,111,114,32,108,111,97,100,105,110,103,32,109,111,100,117,108,101,32,39,37,115,39,32,102,114,111,109,32,102,105,108,101,32,39,37,115,39,58,10,9,37,115,0,0,0,46,0,0,0,0,0,0,0,95,0,0,0,0,0,0,0,108,117,97,111,112,101,110,95,37,115,0,0,0,0,0,0,100,121,110,97,109,105,99,32,108,105,98,114,97,114,105,101,115,32,110,111,116,32,101,110,97,98,108,101,100,59,32,99,104,101,99,107,32,121,111,117,114,32,76,117,97,32,105,110,115,116,97,108,108,97,116,105,111,110,0,0,0,0,0,0,39,112,97,99,107,97,103,101,46,37,115,39,32,109,117,115,116,32,98,101,32,97,32,115,116,114,105,110,103,0,0,0,63,0,0,0,0,0,0,0,10,9,110,111,32,102,105,108,101,32,39,37,115,39,0,0,114,0,0,0,0,0,0,0,10,9,110,111,32,102,105,101,108,100,32,112,97,99,107,97,103,101,46,112,114,101,108,111,97,100,91,39,37,115,39,93,0,0,0,0,0,0,0,0,108,111,97,100,108,105,98,0,115,101,97,114,99,104,112,97,116,104,0,0,0,0,0,0,115,101,101,97,108,108,0,0,95,95,105,110,100,101,120,0,97,98,115,101,110,116,0,0,105,110,105,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,110,78,0,0,0,0,0,0,120,88,0,0,0,0,0,0,40,110,117,108,108,41,0,0,37,112,0,0,0,0,0,0,37,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,111,112,116,105,111,110,32,39,37,37,37,99,39,32,116,111,32,39,108,117,97,95,112,117,115,104,102,115,116,114,105,110,103,39,0,0,0,0,0,0,46,46,46,0,0,0,0,0,91,115,116,114,105,110,103,32,34,0,0,0,0,0,0,0,34,93,0,0,0,0,0,0,96,113,65,84,80,80,92,108,60,16,60,84,108,124,124,124,124,124,124,96,96,96,104,34,188,188,188,132,228,84,84,16,98,98,4,98,20,81,80,23,88,22,0,0,53,0,0,0,96,22,0,0,54,0,0,0,104,22,0,0,55,0,0,0,120,22,0,0,56,0,0,0,128,22,0,0,57,0,0,0,136,22,0,0,58,0,0,0,144,22,0,0,59,0,0,0,152,22,0,0,60,0,0,0,160,22,0,0,61,0,0,0,176,22,0,0,62,0,0,0,184,22,0,0,63,0,0,0,0,0,0,0,0,0,0,0,99,108,111,99,107,0,0,0,100,97,116,101,0,0,0,0,100,105,102,102,116,105,109,101,0,0,0,0,0,0,0,0,101,120,101,99,117,116,101,0,101,120,105,116,0,0,0,0,103,101,116,101,110,118,0,0,114,101,109,111,118,101,0,0,114,101,110,97,109,101,0,0,115,101,116,108,111,99,97,108,101,0,0,0,0,0,0,0,116,105,109,101,0,0,0,0,116,109,112,110,97,109,101,0,117,110,97,98,108,101,32,116,111,32,103,101,110,101,114,97,116,101,32,97,32,117,110,105,113,117,101,32,102,105,108,101,110,97,109,101,0,0,0,0,115,101,99,0,0,0,0,0,109,105,110,0,0,0,0,0,104,111,117,114,0,0,0,0,100,97,121,0,0,0,0,0,109,111,110,116,104,0,0,0,121,101,97,114,0,0,0,0,105,115,100,115,116,0,0,0,102,105,101,108,100,32,39,37,115,39,32,109,105,115,115,105,110,103,32,105,110,32,100,97,116,101,32,116,97,98,108,101,0,0,0,0,0,0,0,0,6,0,0,0,3,0,0,0,0,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,128,23,0,0,136,23,0,0,144,23,0,0,152,23,0,0,168,23,0,0,176,22,0,0,0,0,0,0,0,0,0,0,97,108,108,0,0,0,0,0,99,111,108,108,97,116,101,0,99,116,121,112,101,0,0,0,109,111,110,101,116,97,114,121,0,0,0,0,0,0,0,0,110,117,109,101,114,105,99,0,37,99,0,0,0,0,0,0,42,116,0,0,0,0,0,0,119,100,97,121,0,0,0,0,121,100,97,121,0,0,0,0,97,65,98,66,99,100,72,73,106,109,77,112,83,85,119,87,120,88,121,89,122,37,0,0,105,110,118,97,108,105,100,32,99,111,110,118,101,114,115,105,111,110,32,115,112,101,99,105,102,105,101,114,32,39,37,37,37,115,39,0,0,0,0,0,60,37,115,62,32,97,116,32,108,105,110,101,32,37,100,32,110,111,116,32,105,110,115,105,100,101,32,97,32,108,111,111,112,0,0,0,0,0,0,0,110,111,32,118,105,115,105,98,108,101,32,108,97,98,101,108,32,39,37,115,39,32,102,111,114,32,60,103,111,116,111,62,32,97,116,32,108,105,110,101,32,37,100,0,0,0,0,0,60,103,111,116,111,32,37,115,62,32,97,116,32,108,105,110,101,32,37,100,32,106,117,109,112,115,32,105,110,116,111,32,116,104,101,32,115,99,111,112,101,32,111,102,32,108,111,99,97,108,32,39,37,115,39,0,98,114,101,97,107,0,0,0,108,97,98,101,108,115,47,103,111,116,111,115,0,0,0,0,37,115,32,101,120,112,101,99,116,101,100,0,0,0,0,0,115,121,110,116,97,120,32,101,114,114,111,114,0,0,0,0,67,32,108,101,118,101,108,115,0,0,0,0,0,0,0,0,6,6,6,6,7,7,7,7,7,7,10,9,5,4,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,1,0,0,99,97,110,110,111,116,32,117,115,101,32,39,46,46,46,39,32,111,117,116,115,105,100,101,32,97,32,118,97,114,97,114,103,32,102,117,110,99,116,105,111,110,0,0,0,0,0,0,115,101,108,102,0,0,0,0,60,110,97,109,101,62,32,111,114,32,39,46,46,46,39,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,0,0,108,111,99,97,108,32,118,97,114,105,97,98,108,101,115,0,102,117,110,99,116,105,111,110,115,0,0,0,0,0,0,0,105,116,101,109,115,32,105,110,32,97,32,99,111,110,115,116,114,117,99,116,111,114,0,0,109,97,105,110,32,102,117,110,99,116,105,111,110,0,0,0,102,117,110,99,116,105,111,110,32,97,116,32,108,105,110,101,32,37,100,0,0,0,0,0,116,111,111,32,109,97,110,121,32,37,115,32,40,108,105,109,105,116,32,105,115,32,37,100,41,32,105,110,32,37,115,0,102,117,110,99,116,105,111,110,32,97,114,103,117,109,101,110,116,115,32,101,120,112,101,99,116,101,100,0,0,0,0,0,117,110,101,120,112,101,99,116,101,100,32,115,121,109,98,111,108,0,0,0,0,0,0,0,108,97,98,101,108,32,39,37,115,39,32,97,108,114,101,97,100,121,32,100,101,102,105,110,101,100,32,111,110,32,108,105,110,101,32,37,100,0,0,0,39,61,39,32,111,114,32,39,105,110,39,32,101,120,112,101,99,116,101,100,0,0,0,0,40,102,111,114,32,103,101,110,101,114,97,116,111,114,41,0,40,102,111,114,32,115,116,97,116,101,41,0,0,0,0,0,40,102,111,114,32,99,111,110,116,114,111,108,41,0,0,0,40,102,111,114,32,105,110,100,101,120,41,0,0,0,0,0,40,102,111,114,32,108,105,109,105,116,41,0,0,0,0,0,40,102,111,114,32,115,116,101,112,41,0,0,0,0,0,0,37,115,32,101,120,112,101,99,116,101,100,32,40,116,111,32,99,108,111,115,101,32,37,115,32,97,116,32,108,105,110,101,32,37,100,41,0,0,0,0,117,112,118,97,108,117,101,115,0,0,0,0,0,0,0,0,110,111,116,32,101,110,111,117,103,104,32,109,101,109,111,114,121,0,0,0,0,0,0,0,144,27,0,0,64,0,0,0,152,27,0,0,65,0,0,0,160,27,0,0,66,0,0,0,168,27,0,0,67,0,0,0,176,27,0,0,68,0,0,0,184,27,0,0,69,0,0,0,192,27,0,0,70,0,0,0,200,27,0,0,71,0,0,0,208,27,0,0,72,0,0,0,216,27,0,0,73,0,0,0,224,27,0,0,74,0,0,0,232,27,0,0,75,0,0,0,240,27,0,0,76,0,0,0,248,27,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,95,105,110,100,101,120,0,98,121,116,101,0,0,0,0,99,104,97,114,0,0,0,0,100,117,109,112,0,0,0,0,102,105,110,100,0,0,0,0,102,111,114,109,97,116,0,0,103,109,97,116,99,104,0,0,103,115,117,98,0,0,0,0,108,101,110,0,0,0,0,0,108,111,119,101,114,0,0,0,109,97,116,99,104,0,0,0,114,101,112,0,0,0,0,0,114,101,118,101,114,115,101,0,115,117,98,0,0,0,0,0,117,112,112,101,114,0,0,0,114,101,115,117,108,116,105,110,103,32,115,116,114,105,110,103,32,116,111,111,32,108,97,114,103,101,0,0,0,0,0,0,116,111,111,32,109,97,110,121,32,99,97,112,116,117,114,101,115,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,99,97,112,116,117,114,101,32,105,110,100,101,120,0,0,0,117,110,102,105,110,105,115,104,101,100,32,99,97,112,116,117,114,101,0,0,0,0,0,0,112,97,116,116,101,114,110,32,116,111,111,32,99,111,109,112,108,101,120,0,0,0,0,0,109,105,115,115,105,110,103,32,39,91,39,32,97,102,116,101,114,32,39,37,37,102,39,32,105,110,32,112,97,116,116,101,114,110,0,0,0,0,0,0,105,110,118,97,108,105,100,32,99,97,112,116,117,114,101,32,105,110,100,101,120,32,37,37,37,100,0,0,0,0,0,0,109,97,108,102,111,114,109,101,100,32,112,97,116,116,101,114,110,32,40,101,110,100,115,32,119,105,116,104,32,39,37,37,39,41,0,0,0,0,0,0,109,97,108,102,111,114,109,101,100,32,112,97,116,116,101,114,110,32,40,109,105,115,115,105,110,103,32,39,93,39,41,0,109,97,108,102,111,114,109,101,100,32,112,97,116,116,101,114,110,32,40,109,105,115,115,105,110,103,32,97,114,103,117,109,101,110,116,115,32,116,111,32,39,37,37,98,39,41,0,0,105,110,118,97,108,105,100,32,112,97,116,116,101,114,110,32,99,97,112,116,117,114,101,0,94,36,42,43,63,46,40,91,37,45,0,0,0,0,0,0,115,116,114,105,110,103,47,102,117,110,99,116,105,111,110,47,116,97,98,108,101,32,101,120,112,101,99,116,101,100,0,0,105,110,118,97,108,105,100,32,114,101,112,108,97,99,101,109,101,110,116,32,118,97,108,117,101,32,40,97,32,37,115,41,0,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,117,115,101,32,111,102,32,39,37,99,39,32,105,110,32,114,101,112,108,97,99,101,109,101,110,116,32,115,116,114,105,110,103,0,0,0,0,0,0,0,110,111,32,118,97,108,117,101,0,0,0,0,0,0,0,0,110,111,116,32,97,32,110,117,109,98,101,114,32,105,110,32,112,114,111,112,101,114,32,114,97,110,103,101,0,0,0,0,110,111,116,32,97,32,110,111,110,45,110,101,103,97,116,105,118,101,32,110,117,109,98,101,114,32,105,110,32,112,114,111,112,101,114,32,114,97,110,103,101,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,111,112,116,105,111,110,32,39,37,37,37,99,39,32,116,111,32,39,102,111,114,109,97,116,39,0,0,0,0,0,0,0,92,37,100,0,0,0,0,0,92,37,48,51,100,0,0,0,45,43,32,35,48,0,0,0,105,110,118,97,108,105,100,32,102,111,114,109,97,116,32,40,114,101,112,101,97,116,101,100,32,102,108,97,103,115,41,0,105,110,118,97,108,105,100,32,102,111,114,109,97,116,32,40,119,105,100,116,104,32,111,114,32,112,114,101,99,105,115,105,111,110,32,116,111,111,32,108,111,110,103,41,0,0,0,0,117,110,97,98,108,101,32,116,111,32,100,117,109,112,32,103,105,118,101,110,32,102,117,110,99,116,105,111,110,0,0,0,118,97,108,117,101,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,0,0,0,115,116,114,105,110,103,32,115,108,105,99,101,32,116,111,111,32,108,111,110,103,0,0,0,116,97,98,108,101,32,105,110,100,101,120,32,105,115,32,110,105,108,0,0,0,0,0,0,116,97,98,108,101,32,105,110,100,101,120,32,105,115,32,78,97,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,97,98,108,101,32,111,118,101,114,102,108,111,119,0,0,105,110,118,97,108,105,100,32,107,101,121,32,116,111,32,39,110,101,120,116,39,0,0,0,224,31,0,0,78,0,0,0,232,31,0,0,79,0,0,0,240,31,0,0,80,0,0,0,248,31,0,0,81,0,0,0,216,31,0,0,82,0,0,0,0,32,0,0,83,0,0,0,8,32,0,0,84,0,0,0,0,0,0,0,0,0,0,0,117,110,112,97,99,107,0,0,99,111,110,99,97,116,0,0,109,97,120,110,0,0,0,0,105,110,115,101,114,116,0,0,112,97,99,107,0,0,0,0,114,101,109,111,118,101,0,0,115,111,114,116,0,0,0,0,0,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,111,114,100,101,114,32,102,117,110,99,116,105,111,110,32,102,111,114,32,115,111,114,116,105,110,103,0,0,0,0,0,0,112,111,115,105,116,105,111,110,32,111,117,116,32,111,102,32,98,111,117,110,100,115,0,0,116,111,111,32,109,97,110,121,32,114,101,115,117,108,116,115,32,116,111,32,117,110,112,97,99,107,0,0,0,0,0,0,110,0,0,0,0,0,0,0,119,114,111,110,103,32,110,117,109,98,101,114,32,111,102,32,97,114,103,117,109,101,110,116,115,32,116,111,32,39,105,110,115,101,114,116,39,0,0,0,105,110,118,97,108,105,100,32,118,97,108,117,101,32,40,37,115,41,32,97,116,32,105,110,100,101,120,32,37,100,32,105,110,32,116,97,98,108,101,32,102,111,114,32,39,99,111,110,99,97,116,39,0,0,0,0,110,111,32,118,97,108,117,101,0,0,0,0,0,0,0,0,110,105,108,0,0,0,0,0,98,111,111,108,101,97,110,0,117,115,101,114,100,97,116,97,0,0,0,0,0,0,0,0,110,117,109,98,101,114,0,0,115,116,114,105,110,103,0,0,116,97,98,108,101,0,0,0,102,117,110,99,116,105,111,110,0,0,0,0,0,0,0,0,116,104,114,101,97,100,0,0,112,114,111,116,111,0,0,0,117,112,118,97,108,0,0,0,224,32,0,0,240,32,0,0,248,32,0,0,0,33,0,0,16,33,0,0,24,33,0,0,32,33,0,0,40,33,0,0,0,33,0,0,56,33,0,0,64,33,0,0,72,33,0,0,200,33,0,0,208,33,0,0,224,33,0,0,232,33,0,0,240,33,0,0,248,33,0,0,0,34,0,0,8,34,0,0,16,34,0,0,24,34,0,0,32,34,0,0,40,34,0,0,48,34,0,0,56,34,0,0,64,34,0,0,72,34,0,0,88,34,0,0,0,0,0,0,95,95,105,110,100,101,120,0,95,95,110,101,119,105,110,100,101,120,0,0,0,0,0,0,95,95,103,99,0,0,0,0,95,95,109,111,100,101,0,0,95,95,108,101,110,0,0,0,95,95,101,113,0,0,0,0,95,95,97,100,100,0,0,0,95,95,115,117,98,0,0,0,95,95,109,117,108,0,0,0,95,95,100,105,118,0,0,0,95,95,109,111,100,0,0,0,95,95,112,111,119,0,0,0,95,95,117,110,109,0,0,0,95,95,108,116,0,0,0,0,95,95,108,101,0,0,0,0,95,95,99,111,110,99,97,116,0,0,0,0,0,0,0,0,95,95,99,97,108,108,0,0,98,105,110,97,114,121,32,115,116,114,105,110,103,0,0,0,25,147,13,10,26,10,0,0,116,114,117,110,99,97,116,101,100,0,0,0,0,0,0,0,37,115,58,32,37,115,32,112,114,101,99,111,109,112,105,108,101,100,32,99,104,117,110,107,0,0,0,0,0,0,0,0,99,111,114,114,117,112,116,101,100,0,0,0,0,0,0,0,110,111,116,32,97,0,0,0,118,101,114,115,105,111,110,32,109,105,115,109,97,116,99,104,32,105,110,0,0,0,0,0,105,110,99,111,109,112,97,116,105,98,108,101,0,0,0,0,37,46,49,52,103,0,0,0,105,110,100,101,120,0,0,0,108,111,111,112,32,105,110,32,103,101,116,116,97,98,108,101,0,0,0,0,0,0,0,0,108,111,111,112,32,105,110,32,115,101,116,116,97,98,108,101,0,0,0,0,0,0,0,0,115,116,114,105,110,103,32,108,101,110,103,116,104,32,111,118,101,114,102,108,111,119,0,0,103,101,116,32,108,101,110,103,116,104,32,111,102,0,0,0,39,102,111,114,39,32,105,110,105,116,105,97,108,32,118,97,108,117,101,32,109,117,115,116,32,98,101,32,97,32,110,117,109,98,101,114,0,0,0,0,39,102,111,114,39,32,108,105,109,105,116,32,109,117,115,116,32,98,101,32,97,32,110,117,109,98,101,114,0,0,0,0,39,102,111,114,39,32,115,116,101,112,32,109,117,115,116,32,98,101,32,97,32,110,117,109,98,101,114,0,0,0,0,0,95,71,0,0,0,0,0,0,152,36,0,0,85,0,0,0,160,36,0,0,86,0,0,0,176,36,0,0,87,0,0,0,184,36,0,0,88,0,0,0,192,36,0,0,89,0,0,0,208,36,0,0,90,0,0,0,216,36,0,0,91,0,0,0,232,36,0,0,92,0,0,0,240,36,0,0,92,0,0,0,0,37,0,0,93,0,0,0,8,37,0,0,94,0,0,0,16,37,0,0,95,0,0,0,24,37,0,0,96,0,0,0,32,37,0,0,97,0,0,0,48,37,0,0,98,0,0,0,56,37,0,0,99,0,0,0,64,37,0,0,100,0,0,0,72,37,0,0,101,0,0,0,80,37,0,0,102,0,0,0,96,37,0,0,103,0,0,0,112,37,0,0,104,0,0,0,128,37,0,0,105,0,0,0,136,37,0,0,106,0,0,0,0,0,0,0,0,0,0,0,76,117,97,32,53,46,50,0,95,86,69,82,83,73,79,78,0,0,0,0,0,0,0,0,97,115,115,101,114,116,0,0,99,111,108,108,101,99,116,103,97,114,98,97,103,101,0,0,100,111,102,105,108,101,0,0,101,114,114,111,114,0,0,0,103,101,116,109,101,116,97,116,97,98,108,101,0,0,0,0,105,112,97,105,114,115,0,0,108,111,97,100,102,105,108,101,0,0,0,0,0,0,0,0,108,111,97,100,0,0,0,0,108,111,97,100,115,116,114,105,110,103,0,0,0,0,0,0,110,101,120,116,0,0,0,0,112,97,105,114,115,0,0,0,112,99,97,108,108,0,0,0,112,114,105,110,116,0,0,0,114,97,119,101,113,117,97,108,0,0,0,0,0,0,0,0,114,97,119,108,101,110,0,0,114,97,119,103,101,116,0,0,114,97,119,115,101,116,0,0,115,101,108,101,99,116,0,0,115,101,116,109,101,116,97,116,97,98,108,101,0,0,0,0,116,111,110,117,109,98,101,114,0,0,0,0,0,0,0,0,116,111,115,116,114,105,110,103,0,0,0,0,0,0,0,0,116,121,112,101,0,0,0,0,120,112,99,97,108,108,0,0,118,97,108,117,101,32,101,120,112,101,99,116,101,100,0,0,115,116,97,99,107,32,111,118,101,114,102,108,111,119,0,0,98,97,115,101,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,0,0,0,0,32,12,10,13,9,11,0,0,110,105,108,32,111,114,32,116,97,98,108,101,32,101,120,112,101,99,116,101,100,0,0,0,95,95,109,101,116,97,116,97,98,108,101,0,0,0,0,0,99,97,110,110,111,116,32,99,104,97,110,103,101,32,97,32,112,114,111,116,101,99,116,101,100,32,109,101,116,97,116,97,98,108,101,0,0,0,0,0,105,110,100,101,120,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,0,0,0,116,97,98,108,101,32,111,114,32,115,116,114,105,110,103,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,0,0,39,116,111,115,116,114,105,110,103,39,32,109,117,115,116,32,114,101,116,117,114,110,32,97,32,115,116,114,105,110,103,32,116,111,32,39,112,114,105,110,116,39,0,0,0,0,0,0,95,95,112,97,105,114,115,0,98,116,0,0,0,0,0,0,61,40,108,111,97,100,41,0,116,111,111,32,109,97,110,121,32,110,101,115,116,101,100,32,102,117,110,99,116,105,111,110,115,0,0,0,0,0,0,0,114,101,97,100,101,114,32,102,117,110,99,116,105,111,110,32,109,117,115,116,32,114,101,116,117,114,110,32,97,32,115,116,114,105,110,103,0,0,0,0,95,95,105,112,97,105,114,115,0,0,0,0,0,0,0,0,40,39,0,0,48,39,0,0,56,39,0,0,64,39,0,0,72,39,0,0,80,39,0,0,96,39,0,0,112,39,0,0,128,39,0,0,144,39,0,0,160,39,0,0,0,0,0,0,115,116,111,112,0,0,0,0,114,101,115,116,97,114,116,0,99,111,108,108,101,99,116,0,99,111,117,110,116,0,0,0,115,116,101,112,0,0,0,0,115,101,116,112,97,117,115,101,0,0,0,0,0,0,0,0,115,101,116,115,116,101,112,109,117,108,0,0,0,0,0,0,115,101,116,109,97,106,111,114,105,110,99,0,0,0,0,0,105,115,114,117,110,110,105,110,103,0,0,0,0,0,0,0,103,101,110,101,114,97,116,105,111,110,97,108,0,0,0,0,105,110,99,114,101,109,101,110,116,97,108,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,0,0,0,0,37,115,0,0,0,0,0,0,97,115,115,101,114,116,105,111,110,32,102,97,105,108,101,100,33,0,0,0,0,0,0,0,104,40,0,0,107], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE);
/* memory initializer */ allocate([112,40,0,0,108,0,0,0,120,40,0,0,109,0,0,0,128,40,0,0,110,0,0,0,136,40,0,0,111,0,0,0,144,40,0,0,112,0,0,0,152,40,0,0,113,0,0,0,160,40,0,0,114,0,0,0,168,40,0,0,115,0,0,0,176,40,0,0,116,0,0,0,184,40,0,0,117,0,0,0,192,40,0,0,118,0,0,0,0,0,0,0,0,0,0,0,97,114,115,104,105,102,116,0,98,97,110,100,0,0,0,0,98,110,111,116,0,0,0,0,98,111,114,0,0,0,0,0,98,120,111,114,0,0,0,0,98,116,101,115,116,0,0,0,101,120,116,114,97,99,116,0,108,114,111,116,97,116,101,0,108,115,104,105,102,116,0,0,114,101,112,108,97,99,101,0,114,114,111,116,97,116,101,0,114,115,104,105,102,116,0,0,102,105,101,108,100,32,99,97,110,110,111,116,32,98,101,32,110,101,103,97,116,105,118,101,0,0,0,0,0,0,0,0,119,105,100,116,104,32,109,117,115,116,32,98,101,32,112,111,115,105,116,105,118,101,0,0,116,114,121,105,110,103,32,116,111,32,97,99,99,101,115,115,32,110,111,110,45,101,120,105,115,116,101,110,116,32,98,105,116,115,0,0,0,0,0,0,102,117,110,99,116,105,111,110,32,111,114,32,101,120,112,114,101,115,115,105,111,110,32,116,111,111,32,99,111,109,112,108,101,120,0,0,0,0,0,0,99,111,110,115,116,114,117,99,116,111,114,32,116,111,111,32,108,111,110,103,0,0,0,0,99,111,110,115,116,97,110,116,115,0,0,0,0,0,0,0,111,112,99,111,100,101,115,0,99,111,110,116,114,111,108,32,115,116,114,117,99,116,117,114,101,32,116,111,111,32,108,111,110,103,0,0,0,0,0,0,216,41,0,0,119,0,0,0,224,41,0,0,120,0,0,0,232,41,0,0,121,0,0,0,240,41,0,0,122,0,0,0,248,41,0,0,123,0,0,0,0,42,0,0,124,0,0,0,0,0,0,0,0,0,0,0,99,114,101,97,116,101,0,0,114,101,115,117,109,101,0,0,114,117,110,110,105,110,103,0,115,116,97,116,117,115,0,0,119,114,97,112,0,0,0,0,121,105,101,108,100,0,0,0,116,111,111,32,109,97,110,121,32,97,114,103,117,109,101,110,116,115,32,116,111,32,114,101,115,117,109,101,0,0,0,0,99,97,110,110,111,116,32,114,101,115,117,109,101,32,100,101,97,100,32,99,111,114,111,117,116,105,110,101,0,0,0,0,116,111,111,32,109,97,110,121,32,114,101,115,117,108,116,115,32,116,111,32,114,101,115,117,109,101,0,0,0,0,0,0,99,111,114,111,117,116,105,110,101,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,115,117,115,112,101,110,100,101,100,0,0,0,0,0,0,0,110,111,114,109,97,108,0,0,100,101,97,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,22,22,22,22,22,22,22,22,22,22,4,4,4,4,4,4,4,21,21,21,21,21,21,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,5,4,21,21,21,21,21,21,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,44,0,0,125,0,0,0,56,44,0,0,126,0,0,0,72,44,0,0,127,0,0,0,80,44,0,0,128,0,0,0,88,44,0,0,129,0,0,0,104,44,0,0,130,0,0,0,120,44,0,0,131,0,0,0,136,44,0,0,132,0,0,0,152,44,0,0,133,0,0,0,168,44,0,0,134,0,0,0,184,44,0,0,135,0,0,0,200,44,0,0,136,0,0,0,208,44,0,0,137,0,0,0,224,44,0,0,138,0,0,0,240,44,0,0,139,0,0,0,0,45,0,0,140,0,0,0,0,0,0,0,0,0,0,0,100,101,98,117,103,0,0,0,103,101,116,117,115,101,114,118,97,108,117,101,0,0,0,0,103,101,116,104,111,111,107,0,103,101,116,105,110,102,111,0,103,101,116,108,111,99,97,108,0,0,0,0,0,0,0,0,103,101,116,114,101,103,105,115,116,114,121,0,0,0,0,0,103,101,116,109,101,116,97,116,97,98,108,101,0,0,0,0,103,101,116,117,112,118,97,108,117,101,0,0,0,0,0,0,117,112,118,97,108,117,101,106,111,105,110,0,0,0,0,0,117,112,118,97,108,117,101,105,100,0,0,0,0,0,0,0,115,101,116,117,115,101,114,118,97,108,117,101,0,0,0,0,115,101,116,104,111,111,107,0,115,101,116,108,111,99,97,108,0,0,0,0,0,0,0,0,115,101,116,109,101,116,97,116,97,98,108,101,0,0,0,0,115,101,116,117,112,118,97,108,117,101,0,0,0,0,0,0,116,114,97,99,101,98,97,99,107,0,0,0,0,0,0,0,110,105,108,32,111,114,32,116,97,98,108,101,32,101,120,112,101,99,116,101,100,0,0,0,108,101,118,101,108,32,111,117,116,32,111,102,32,114,97,110,103,101,0,0,0,0,0,0,95,72,75,69,89,0,0,0,107,0,0,0,0,0,0,0,95,95,109,111,100,101,0,0,112,45,0,0,120,45,0,0,128,45,0,0,136,45,0,0,144,45,0,0,0,0,0,0,99,97,108,108,0,0,0,0,114,101,116,117,114,110,0,0,108,105,110,101,0,0,0,0,99,111,117,110,116,0,0,0,116,97,105,108,32,99,97,108,108,0,0,0,0,0,0,0,102,117,108,108,32,117,115,101,114,100,97,116,97,32,101,120,112,101,99,116,101,100,44,32,103,111,116,32,108,105,103,104,116,32,117,115,101,114,100,97,116,97,0,0,0,0,0,0,62,117,0,0,0,0,0,0,105,110,118,97,108,105,100,32,117,112,118,97,108,117,101,32,105,110,100,101,120,0,0,0,76,117,97,32,102,117,110,99,116,105,111,110,32,101,120,112,101,99,116,101,100,0,0,0,102,108,110,83,116,117,0,0,62,37,115,0,0,0,0,0,102,117,110,99,116,105,111,110,32,111,114,32,108,101,118,101,108,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,105,110,118,97,108,105,100,32,111,112,116,105,111,110,0,0,115,111,117,114,99,101,0,0,115,104,111,114,116,95,115,114,99,0,0,0,0,0,0,0,108,105,110,101,100,101,102,105,110,101,100,0,0,0,0,0,108,97,115,116,108,105,110,101,100,101,102,105,110,101,100,0,119,104,97,116,0,0,0,0,99,117,114,114,101,110,116,108,105,110,101,0,0,0,0,0,110,117,112,115,0,0,0,0,110,112,97,114,97,109,115,0,105,115,118,97,114,97,114,103,0,0,0,0,0,0,0,0,110,97,109,101,0,0,0,0,110,97,109,101,119,104,97,116,0,0,0,0,0,0,0,0,105,115,116,97,105,108,99,97,108,108,0,0,0,0,0,0,97,99,116,105,118,101,108,105,110,101,115,0,0,0,0,0,102,117,110,99,0,0,0,0,101,120,116,101,114,110,97,108,32,104,111,111,107,0,0,0,108,117,97,95,100,101,98,117,103,62,32,0,0,0,0,0,99,111,110,116,10,0,0,0,61,40,100,101,98,117,103,32,99,111,109,109,97,110,100,41,0,0,0,0,0,0,0,0,37,115,10,0,0,0,0,0,80,49,0,0,88,49,0,0,96,49,0,0,104,49,0,0,112,49,0,0,120,49,0,0,128,49,0,0,136,49,0,0,144,49,0,0,160,49,0,0,168,49,0,0,176,49,0,0,184,49,0,0,192,49,0,0,200,49,0,0,208,49,0,0,216,49,0,0,224,49,0,0,232,49,0,0,240,49,0,0,248,49,0,0,0,50,0,0,8,50,0,0,16,50,0,0,24,50,0,0,32,50,0,0,40,50,0,0,48,50,0,0,56,50,0,0,64,50,0,0,72,50,0,0,88,50,0,0,96,50,0,0,0,0,0,0,39,37,99,39,0,0,0,0,99,104,97,114,40,37,100,41,0,0,0,0,0,0,0,0,39,37,115,39,0,0,0,0,95,69,78,86,0,0,0,0,105,110,118,97,108,105,100,32,108,111,110,103,32,115,116,114,105,110,103,32,100,101,108,105,109,105,116,101,114,0,0,0,46,0,0,0,0,0,0,0,69,101,0,0,0,0,0,0,88,120,0,0,0,0,0,0,80,112,0,0,0,0,0,0,43,45,0,0,0,0,0,0,109,97,108,102,111,114,109,101,100,32,110,117,109,98,101,114,0,0,0,0,0,0,0,0,108,101,120,105,99,97,108,32,101,108,101,109,101,110,116,32,116,111,111,32,108,111,110,103,0,0,0,0,0,0,0,0,117,110,102,105,110,105,115,104,101,100,32,115,116,114,105,110,103,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,101,115,99,97,112,101,32,115,101,113,117,101,110,99,101,0,100,101,99,105,109,97,108,32,101,115,99,97,112,101,32,116,111,111,32,108,97,114,103,101,0,0,0,0,0,0,0,0,104,101,120,97,100,101,99,105,109,97,108,32,100,105,103,105,116,32,101,120,112,101,99,116,101,100,0,0,0,0,0,0,117,110,102,105,110,105,115,104,101,100,32,108,111,110,103,32,115,116,114,105,110,103,0,0,117,110,102,105,110,105,115,104,101,100,32,108,111,110,103,32,99,111,109,109,101,110,116,0,99,104,117,110,107,32,104,97,115,32,116,111,111,32,109,97,110,121,32,108,105,110,101,115,0,0,0,0,0,0,0,0,37,115,58,37,100,58,32,37,115,0,0,0,0,0,0,0,37,115,32,110,101,97,114,32,37,115,0,0,0,0,0,0,97,110,100,0,0,0,0,0,98,114,101,97,107,0,0,0,100,111,0,0,0,0,0,0,101,108,115,101,0,0,0,0,101,108,115,101,105,102,0,0,101,110,100,0,0,0,0,0,102,97,108,115,101,0,0,0,102,111,114,0,0,0,0,0,102,117,110,99,116,105,111,110,0,0,0,0,0,0,0,0,103,111,116,111,0,0,0,0,105,102,0,0,0,0,0,0,105,110,0,0,0,0,0,0,108,111,99,97,108,0,0,0,110,105,108,0,0,0,0,0,110,111,116,0,0,0,0,0,111,114,0,0,0,0,0,0,114,101,112,101,97,116,0,0,114,101,116,117,114,110,0,0,116,104,101,110,0,0,0,0,116,114,117,101,0,0,0,0,117,110,116,105,108,0,0,0,119,104,105,108,101,0,0,0,46,46,0,0,0,0,0,0,46,46,46,0,0,0,0,0,61,61,0,0,0,0,0,0,62,61,0,0,0,0,0,0,60,61,0,0,0,0,0,0,126,61,0,0,0,0,0,0,58,58,0,0,0,0,0,0,60,101,111,102,62,0,0,0,60,110,117,109,98,101,114,62,0,0,0,0,0,0,0,0,60,110,97,109,101,62,0,0,60,115,116,114,105,110,103,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,110,102,105,110,105,116,121,0,0,0,0,0,0,0,0,110,97,110,0,0,0,0,0,95,112,137,0,255,9,47,15,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE+10240);




var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);

assert(tempDoublePtr % 8 == 0);

function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

}

function copyTempDouble(ptr) {

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];

  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];

  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];

  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];

}




  Module["_rand_r"] = _rand_r;

  var ___rand_seed=allocate([0x0273459b, 0, 0, 0], "i32", ALLOC_STATIC);
  Module["_rand"] = _rand;



  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};

  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};


  var ___errno_state=0;function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      HEAP32[((___errno_state)>>2)]=value;
      return value;
    }

  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up--; up) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash+1);
      },extname:function (path) {
        return PATH.splitPath(path)[3];
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
      },join2:function (l, r) {
        return PATH.normalize(l + '/' + r);
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            continue;
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};

  var TTY={ttys:[],init:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          if (stream.tty.output.length) {
            stream.tty.ops.put_char(stream.tty, 10);
          }
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              result = process['stdin']['read']();
              if (!result) {
                if (process['stdin']['_readableState'] && process['stdin']['_readableState']['ended']) {
                  return null;  // EOF
                }
                return undefined;  // no data available
              }
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }}};

  var MEMFS={ops_table:null,CONTENT_OWNING:1,CONTENT_FLEXIBLE:2,CONTENT_FIXED:3,mount:function (mount) {
        return MEMFS.createNode(null, '/', 16384 | 511 /* 0777 */, 0);
      },createNode:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek
              }
            },
            file: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              },
              stream: {}
            },
            chrdev: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: FS.chrdev_stream_ops
            },
          };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node;
          node.stream_ops = MEMFS.ops_table.dir.stream;
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node;
          node.stream_ops = MEMFS.ops_table.file.stream;
          node.contents = [];
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node;
          node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node;
          node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },ensureFlexible:function (node) {
        if (node.contentMode !== MEMFS.CONTENT_FLEXIBLE) {
          var contents = node.contents;
          node.contents = Array.prototype.slice.call(contents);
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        }
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.contents.length;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.ensureFlexible(node);
            var contents = node.contents;
            if (attr.size < contents.length) contents.length = attr.size;
            else while (attr.size > contents.length) contents.push(0);
          }
        },lookup:function (parent, name) {
          throw FS.genericErrors[ERRNO_CODES.ENOENT];
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          old_node.parent = new_dir;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 511 /* 0777 */ | 40960, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else
          {
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          var node = stream.node;
          node.timestamp = Date.now();
          var contents = node.contents;
          if (length && contents.length === 0 && position === 0 && buffer.subarray) {
            // just replace it with the new data
            if (canOwn && offset === 0) {
              node.contents = buffer; // this could be a subarray of Emscripten HEAP, or allocated from some other source.
              node.contentMode = (buffer.buffer === HEAP8.buffer) ? MEMFS.CONTENT_OWNING : MEMFS.CONTENT_FIXED;
            } else {
              node.contents = new Uint8Array(buffer.subarray(offset, offset+length));
              node.contentMode = MEMFS.CONTENT_FIXED;
            }
            return length;
          }
          MEMFS.ensureFlexible(node);
          var contents = node.contents;
          while (contents.length < position) contents.push(0);
          for (var i = 0; i < length; i++) {
            contents[position + i] = buffer[offset + i];
          }
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.contents.length;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          stream.ungotten = [];
          stream.position = position;
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.ensureFlexible(stream.node);
          var contents = stream.node.contents;
          var limit = offset + length;
          while (limit > contents.length) contents.push(0);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 2) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < contents.length) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        }}};

  var IDBFS={dbs:{},indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:function (mount) {
        // reuse all of the core MEMFS functionality
        return MEMFS.mount.apply(null, arguments);
      },syncfs:function (mount, populate, callback) {
        IDBFS.getLocalSet(mount, function(err, local) {
          if (err) return callback(err);

          IDBFS.getRemoteSet(mount, function(err, remote) {
            if (err) return callback(err);

            var src = populate ? remote : local;
            var dst = populate ? local : remote;

            IDBFS.reconcile(src, dst, callback);
          });
        });
      },getDB:function (name, callback) {
        // check the cache first
        var db = IDBFS.dbs[name];
        if (db) {
          return callback(null, db);
        }

        var req;
        try {
          req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
        } catch (e) {
          return callback(e);
        }
        req.onupgradeneeded = function(e) {
          var db = e.target.result;
          var transaction = e.target.transaction;

          var fileStore;

          if (db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)) {
            fileStore = transaction.objectStore(IDBFS.DB_STORE_NAME);
          } else {
            fileStore = db.createObjectStore(IDBFS.DB_STORE_NAME);
          }

          fileStore.createIndex('timestamp', 'timestamp', { unique: false });
        };
        req.onsuccess = function() {
          db = req.result;

          // add to the cache
          IDBFS.dbs[name] = db;
          callback(null, db);
        };
        req.onerror = function() {
          callback(this.error);
        };
      },getLocalSet:function (mount, callback) {
        var entries = {};

        function isRealDir(p) {
          return p !== '.' && p !== '..';
        };
        function toAbsolute(root) {
          return function(p) {
            return PATH.join2(root, p);
          }
        };

        var check = FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));

        while (check.length) {
          var path = check.pop();
          var stat;

          try {
            stat = FS.stat(path);
          } catch (e) {
            return callback(e);
          }

          if (FS.isDir(stat.mode)) {
            check.push.apply(check, FS.readdir(path).filter(isRealDir).map(toAbsolute(path)));
          }

          entries[path] = { timestamp: stat.mtime };
        }

        return callback(null, { type: 'local', entries: entries });
      },getRemoteSet:function (mount, callback) {
        var entries = {};

        IDBFS.getDB(mount.mountpoint, function(err, db) {
          if (err) return callback(err);

          var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readonly');
          transaction.onerror = function() { callback(this.error); };

          var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
          var index = store.index('timestamp');

          index.openKeyCursor().onsuccess = function(event) {
            var cursor = event.target.result;

            if (!cursor) {
              return callback(null, { type: 'remote', db: db, entries: entries });
            }

            entries[cursor.primaryKey] = { timestamp: cursor.key };

            cursor.continue();
          };
        });
      },loadLocalEntry:function (path, callback) {
        var stat, node;

        try {
          var lookup = FS.lookupPath(path);
          node = lookup.node;
          stat = FS.stat(path);
        } catch (e) {
          return callback(e);
        }

        if (FS.isDir(stat.mode)) {
          return callback(null, { timestamp: stat.mtime, mode: stat.mode });
        } else if (FS.isFile(stat.mode)) {
          return callback(null, { timestamp: stat.mtime, mode: stat.mode, contents: node.contents });
        } else {
          return callback(new Error('node type not supported'));
        }
      },storeLocalEntry:function (path, entry, callback) {
        try {
          if (FS.isDir(entry.mode)) {
            FS.mkdir(path, entry.mode);
          } else if (FS.isFile(entry.mode)) {
            FS.writeFile(path, entry.contents, { encoding: 'binary', canOwn: true });
          } else {
            return callback(new Error('node type not supported'));
          }

          FS.utime(path, entry.timestamp, entry.timestamp);
        } catch (e) {
          return callback(e);
        }

        callback(null);
      },removeLocalEntry:function (path, callback) {
        try {
          var lookup = FS.lookupPath(path);
          var stat = FS.stat(path);

          if (FS.isDir(stat.mode)) {
            FS.rmdir(path);
          } else if (FS.isFile(stat.mode)) {
            FS.unlink(path);
          }
        } catch (e) {
          return callback(e);
        }

        callback(null);
      },loadRemoteEntry:function (store, path, callback) {
        var req = store.get(path);
        req.onsuccess = function(event) { callback(null, event.target.result); };
        req.onerror = function() { callback(this.error); };
      },storeRemoteEntry:function (store, path, entry, callback) {
        var req = store.put(entry, path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function() { callback(this.error); };
      },removeRemoteEntry:function (store, path, callback) {
        var req = store.delete(path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function() { callback(this.error); };
      },reconcile:function (src, dst, callback) {
        var total = 0;

        var create = [];
        Object.keys(src.entries).forEach(function (key) {
          var e = src.entries[key];
          var e2 = dst.entries[key];
          if (!e2 || e.timestamp > e2.timestamp) {
            create.push(key);
            total++;
          }
        });

        var remove = [];
        Object.keys(dst.entries).forEach(function (key) {
          var e = dst.entries[key];
          var e2 = src.entries[key];
          if (!e2) {
            remove.push(key);
            total++;
          }
        });

        if (!total) {
          return callback(null);
        }

        var errored = false;
        var completed = 0;
        var db = src.type === 'remote' ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readwrite');
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);

        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= total) {
            return callback(null);
          }
        };

        transaction.onerror = function() { done(this.error); };

        // sort paths in ascending order so directory entries are created
        // before the files inside them
        create.sort().forEach(function (path) {
          if (dst.type === 'local') {
            IDBFS.loadRemoteEntry(store, path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeLocalEntry(path, entry, done);
            });
          } else {
            IDBFS.loadLocalEntry(path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeRemoteEntry(store, path, entry, done);
            });
          }
        });

        // sort paths in descending order so files are deleted before their
        // parent directories
        remove.sort().reverse().forEach(function(path) {
          if (dst.type === 'local') {
            IDBFS.removeLocalEntry(path, done);
          } else {
            IDBFS.removeRemoteEntry(store, path, done);
          }
        });
      }};

  var NODEFS={isWindows:false,staticInit:function () {
        NODEFS.isWindows = !!process.platform.match(/^win/);
      },mount:function (mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, '/', NODEFS.getMode(mount.opts.root), 0);
      },createNode:function (parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node;
      },getMode:function (path) {
        var stat;
        try {
          stat = fs.lstatSync(path);
          if (NODEFS.isWindows) {
            // On Windows, directories return permission bits 'rw-rw-rw-', even though they have 'rwxrwxrwx', so
            // propagate write bits to execute bits.
            stat.mode = stat.mode | ((stat.mode & 146) >> 1);
          }
        } catch (e) {
          if (!e.code) throw e;
          throw new FS.ErrnoError(ERRNO_CODES[e.code]);
        }
        return stat.mode;
      },realPath:function (node) {
        var parts = [];
        while (node.parent !== node) {
          parts.push(node.name);
          node = node.parent;
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts);
      },flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:function (flags) {
        if (flags in NODEFS.flagsToPermissionStringMap) {
          return NODEFS.flagsToPermissionStringMap[flags];
        } else {
          return flags;
        }
      },node_ops:{getattr:function (node) {
          var path = NODEFS.realPath(node);
          var stat;
          try {
            stat = fs.lstatSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          // node.js v0.10.20 doesn't report blksize and blocks on Windows. Fake them with default blksize of 4096.
          // See http://support.microsoft.com/kb/140365
          if (NODEFS.isWindows && !stat.blksize) {
            stat.blksize = 4096;
          }
          if (NODEFS.isWindows && !stat.blocks) {
            stat.blocks = (stat.size+stat.blksize-1)/stat.blksize|0;
          }
          return {
            dev: stat.dev,
            ino: stat.ino,
            mode: stat.mode,
            nlink: stat.nlink,
            uid: stat.uid,
            gid: stat.gid,
            rdev: stat.rdev,
            size: stat.size,
            atime: stat.atime,
            mtime: stat.mtime,
            ctime: stat.ctime,
            blksize: stat.blksize,
            blocks: stat.blocks
          };
        },setattr:function (node, attr) {
          var path = NODEFS.realPath(node);
          try {
            if (attr.mode !== undefined) {
              fs.chmodSync(path, attr.mode);
              // update the common node structure mode as well
              node.mode = attr.mode;
            }
            if (attr.timestamp !== undefined) {
              var date = new Date(attr.timestamp);
              fs.utimesSync(path, date, date);
            }
            if (attr.size !== undefined) {
              fs.truncateSync(path, attr.size);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },lookup:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          var mode = NODEFS.getMode(path);
          return NODEFS.createNode(parent, name, mode);
        },mknod:function (parent, name, mode, dev) {
          var node = NODEFS.createNode(parent, name, mode, dev);
          // create the backing node for this in the fs root as well
          var path = NODEFS.realPath(node);
          try {
            if (FS.isDir(node.mode)) {
              fs.mkdirSync(path, node.mode);
            } else {
              fs.writeFileSync(path, '', { mode: node.mode });
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return node;
        },rename:function (oldNode, newDir, newName) {
          var oldPath = NODEFS.realPath(oldNode);
          var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
          try {
            fs.renameSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },unlink:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.unlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },rmdir:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.rmdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readdir:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },symlink:function (parent, newName, oldPath) {
          var newPath = PATH.join2(NODEFS.realPath(parent), newName);
          try {
            fs.symlinkSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readlink:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        }},stream_ops:{open:function (stream) {
          var path = NODEFS.realPath(stream.node);
          try {
            if (FS.isFile(stream.node.mode)) {
              stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags));
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },close:function (stream) {
          try {
            if (FS.isFile(stream.node.mode) && stream.nfd) {
              fs.closeSync(stream.nfd);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },read:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(length);
          var res;
          try {
            res = fs.readSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          if (res > 0) {
            for (var i = 0; i < res; i++) {
              buffer[offset + i] = nbuffer[i];
            }
          }
          return res;
        },write:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
          var res;
          try {
            res = fs.writeSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return res;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              try {
                var stat = fs.fstatSync(stream.nfd);
                position += stat.size;
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
              }
            }
          }

          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }

          stream.position = position;
          return position;
        }}};

  var _stdin=allocate(1, "i32*", ALLOC_STATIC);

  var _stdout=allocate(1, "i32*", ALLOC_STATIC);

  var _stderr=allocate(1, "i32*", ALLOC_STATIC);

  function _fflush(stream) {
      // int fflush(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
      // we don't currently perform any user-space buffering of data
    }var FS={root:null,mounts:[],devices:[null],streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,ErrnoError:null,genericErrors:{},handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + stackTrace();
        return ___setErrNo(e.errno);
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || {};

        var defaults = {
          follow_mount: true,
          recurse_count: 0
        };
        for (var key in defaults) {
          if (opts[key] === undefined) {
            opts[key] = defaults[key];
          }
        }

        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }

        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);

        // start at the root
        var current = FS.root;
        var current_path = '/';

        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }

          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join2(current_path, parts[i]);

          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            if (!islast || (islast && opts.follow_mount)) {
              current = current.mounted.root;
            }
          }

          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);

              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;

              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }

        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint;
            if (!path) return mount;
            return mount[mount.length-1] !== '/' ? mount + '/' + path : mount + path;
          }
          path = path ? node.name + '/' + path : node.name;
          node = node.parent;
        }
      },hashName:function (parentid, name) {
        var hash = 0;


        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name;
          if (node.parent.id === parent.id && nodeName === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        if (!FS.FSNode) {
          FS.FSNode = function(parent, name, mode, rdev) {
            if (!parent) {
              parent = this;  // root node sets parent to itself
            }
            this.parent = parent;
            this.mount = parent.mount;
            this.mounted = null;
            this.id = FS.nextInode++;
            this.name = name;
            this.mode = mode;
            this.node_ops = {};
            this.stream_ops = {};
            this.rdev = rdev;
          };

          FS.FSNode.prototype = {};

          // compatibility
          var readMode = 292 | 73;
          var writeMode = 146;

          // NOTE we must use Object.defineProperties instead of individual calls to
          // Object.defineProperty in order to make closure compiler happy
          Object.defineProperties(FS.FSNode.prototype, {
            read: {
              get: function() { return (this.mode & readMode) === readMode; },
              set: function(val) { val ? this.mode |= readMode : this.mode &= ~readMode; }
            },
            write: {
              get: function() { return (this.mode & writeMode) === writeMode; },
              set: function(val) { val ? this.mode |= writeMode : this.mode &= ~writeMode; }
            },
            isFolder: {
              get: function() { return FS.isDir(this.mode); },
            },
            isDevice: {
              get: function() { return FS.isChrdev(this.mode); },
            },
          });
        }

        var node = new FS.FSNode(parent, name, mode, rdev);

        FS.hashAddNode(node);

        return node;
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return !!node.mounted;
      },isFile:function (mode) {
        return (mode & 61440) === 32768;
      },isDir:function (mode) {
        return (mode & 61440) === 16384;
      },isLink:function (mode) {
        return (mode & 61440) === 40960;
      },isChrdev:function (mode) {
        return (mode & 61440) === 8192;
      },isBlkdev:function (mode) {
        return (mode & 61440) === 24576;
      },isFIFO:function (mode) {
        return (mode & 61440) === 4096;
      },isSocket:function (mode) {
        return (mode & 49152) === 49152;
      },flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var accmode = flag & 2097155;
        var perms = ['r', 'w', 'rw'][accmode];
        if ((flag & 512)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        return FS.nodePermissions(dir, 'x');
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if ((flags & 2097155) !== 0 ||  // opening for write
              (flags & 512)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 0;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = function(){};
          FS.FSStream.prototype = {};
          // compatibility
          Object.defineProperties(FS.FSStream.prototype, {
            object: {
              get: function() { return this.node; },
              set: function(val) { this.node = val; }
            },
            isRead: {
              get: function() { return (this.flags & 2097155) !== 1; }
            },
            isWrite: {
              get: function() { return (this.flags & 2097155) !== 0; }
            },
            isAppend: {
              get: function() { return (this.flags & 1024); }
            }
          });
        }
        if (0) {
          // reuse the object
          stream.__proto__ = FS.FSStream.prototype;
        } else {
          var newStream = new FS.FSStream();
          for (var p in stream) {
            newStream[p] = stream[p];
          }
          stream = newStream;
        }
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },getStreamFromPtr:function (ptr) {
        return FS.streams[ptr - 1];
      },getPtrForStream:function (stream) {
        return stream ? stream.fd + 1 : 0;
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },getMounts:function (mount) {
        var mounts = [];
        var check = [mount];

        while (check.length) {
          var m = check.pop();

          mounts.push(m);

          check.push.apply(check, m.mounts);
        }

        return mounts;
      },syncfs:function (populate, callback) {
        if (typeof(populate) === 'function') {
          callback = populate;
          populate = false;
        }

        var mounts = FS.getMounts(FS.root.mount);
        var completed = 0;

        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= mounts.length) {
            callback(null);
          }
        };

        // sync all mounts
        mounts.forEach(function (mount) {
          if (!mount.type.syncfs) {
            return done(null);
          }
          mount.type.syncfs(mount, populate, done);
        });
      },mount:function (type, opts, mountpoint) {
        var root = mountpoint === '/';
        var pseudo = !mountpoint;
        var node;

        if (root && FS.root) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        } else if (!root && !pseudo) {
          var lookup = FS.lookupPath(mountpoint, { follow_mount: false });

          mountpoint = lookup.path;  // use the absolute path
          node = lookup.node;

          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
          }

          if (!FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
          }
        }

        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          mounts: []
        };

        // create a root node for the fs
        var mountRoot = type.mount(mount);
        mountRoot.mount = mount;
        mount.root = mountRoot;

        if (root) {
          FS.root = mountRoot;
        } else if (node) {
          // set as a mountpoint
          node.mounted = mount;

          // add the new mount to the current mount's children
          if (node.mount) {
            node.mount.mounts.push(mount);
          }
        }

        return mountRoot;
      },unmount:function (mountpoint) {
        var lookup = FS.lookupPath(mountpoint, { follow_mount: false });

        if (!FS.isMountpoint(lookup.node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }

        // destroy the nodes for this mount, and all its child mounts
        var node = lookup.node;
        var mount = node.mounted;
        var mounts = FS.getMounts(mount);

        Object.keys(FS.nameTable).forEach(function (hash) {
          var current = FS.nameTable[hash];

          while (current) {
            var next = current.name_next;

            if (mounts.indexOf(current.mount) !== -1) {
              FS.destroyNode(current);
            }

            current = next;
          }
        });

        // no longer a mountpoint
        node.mounted = null;

        // remove this mount from the child mounts
        var idx = node.mount.mounts.indexOf(mount);
        assert(idx !== -1);
        node.mount.mounts.splice(idx, 1);
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode = mode !== undefined ? mode : 438 /* 0666 */;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode = mode !== undefined ? mode : 511 /* 0777 */;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
      },mkdev:function (path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 438 /* 0666 */;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // POSIX says unlink should set EPERM, not EISDIR
          if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
      },readlink:function (path) {
        var lookup = FS.lookupPath(path);
        var link = lookup.node;
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return link.node_ops.readlink(link);
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 438 /* 0666 */ : mode;
        if ((flags & 64)) {
          mode = (mode & 4095) | 32768;
        } else {
          mode = 0;
        }
        var node;
        if (typeof path === 'object') {
          node = path;
        } else {
          path = PATH.normalize(path);
          try {
            var lookup = FS.lookupPath(path, {
              follow: !(flags & 131072)
            });
            node = lookup.node;
          } catch (e) {
            // ignore
          }
        }
        // perhaps we need to create the node
        if ((flags & 64)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 128)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~512;
        }
        // check permissions
        var err = FS.mayOpen(node, flags);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // do truncation if necessary
        if ((flags & 512)) {
          FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512);

        // register the stream with the filesystem
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),  // we want the absolute path to the node
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
          if (!FS.readFiles) FS.readFiles = {};
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1;
            Module['printErr']('read file: ' + path);
          }
        }
        return stream;
      },close:function (stream) {
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
      },llseek:function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        return stream.stream_ops.llseek(stream, offset, whence);
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        if (stream.flags & 1024) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      },ioctl:function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = '';
          var utf8 = new Runtime.UTF8Processor();
          for (var i = 0; i < length; i++) {
            ret += utf8.processCChar(buf[i]);
          }
        } else if (opts.encoding === 'binary') {
          ret = buf;
        }
        FS.close(stream);
        return ret;
      },writeFile:function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        opts.encoding = opts.encoding || 'utf8';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === 'utf8') {
          var utf8 = new Runtime.UTF8Processor();
          var buf = new Uint8Array(utf8.processJSString(data));
          FS.write(stream, buf, 0, buf.length, 0, opts.canOwn);
        } else if (opts.encoding === 'binary') {
          FS.write(stream, data, 0, data.length, 0, opts.canOwn);
        }
        FS.close(stream);
      },cwd:function () {
        return FS.currentPath;
      },chdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        var err = FS.nodePermissions(lookup.node, 'x');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        FS.currentPath = lookup.path;
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp');
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function() { return 0; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops

        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }

        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        HEAP32[((_stdin)>>2)]=FS.getPtrForStream(stdin);
        assert(stdin.fd === 0, 'invalid handle for stdin (' + stdin.fd + ')');

        var stdout = FS.open('/dev/stdout', 'w');
        HEAP32[((_stdout)>>2)]=FS.getPtrForStream(stdout);
        assert(stdout.fd === 1, 'invalid handle for stdout (' + stdout.fd + ')');

        var stderr = FS.open('/dev/stderr', 'w');
        HEAP32[((_stderr)>>2)]=FS.getPtrForStream(stderr);
        assert(stderr.fd === 2, 'invalid handle for stderr (' + stderr.fd + ')');
      },ensureErrnoError:function () {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno) {
          this.errno = errno;
          for (var key in ERRNO_CODES) {
            if (ERRNO_CODES[key] === errno) {
              this.code = key;
              break;
            }
          }
          this.message = ERRNO_MESSAGES[errno];
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [ERRNO_CODES.ENOENT].forEach(function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code);
          FS.genericErrors[code].stack = '<generic error, no stack>';
        });
      },staticInit:function () {
        FS.ensureErrnoError();

        FS.nameTable = new Array(4096);

        FS.mount(MEMFS, {}, '/');

        FS.createDefaultDirectories();
        FS.createDefaultDevices();
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;

        FS.ensureErrnoError();

        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];

        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join2(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(node, mode | 146);
          var stream = FS.open(node, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(node, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
        function LazyUint8Array() {
          this.lengthKnown = false;
          this.chunks = []; // Loaded chunks. Index is the chunk number
        }
        LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
          if (idx > this.length-1 || idx < 0) {
            return undefined;
          }
          var chunkOffset = idx % this.chunkSize;
          var chunkNum = Math.floor(idx / this.chunkSize);
          return this.getter(chunkNum)[chunkOffset];
        }
        LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
          this.getter = getter;
        }
        LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
            // Find length
            var xhr = new XMLHttpRequest();
            xhr.open('HEAD', url, false);
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            var datalength = Number(xhr.getResponseHeader("Content-length"));
            var header;
            var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
            var chunkSize = 1024*1024; // Chunk size in bytes

            if (!hasByteServing) chunkSize = datalength;

            // Function to get a range from the remote URL.
            var doXHR = (function(from, to) {
              if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
              if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");

              // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
              var xhr = new XMLHttpRequest();
              xhr.open('GET', url, false);
              if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);

              // Some hints to the browser that we want binary data.
              if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
              if (xhr.overrideMimeType) {
                xhr.overrideMimeType('text/plain; charset=x-user-defined');
              }

              xhr.send(null);
              if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
              if (xhr.response !== undefined) {
                return new Uint8Array(xhr.response || []);
              } else {
                return intArrayFromString(xhr.responseText || '', true);
              }
            });
            var lazyArray = this;
            lazyArray.setDataGetter(function(chunkNum) {
              var start = chunkNum * chunkSize;
              var end = (chunkNum+1) * chunkSize - 1; // including this byte
              end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
              if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
                lazyArray.chunks[chunkNum] = doXHR(start, end);
              }
              if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
              return lazyArray.chunks[chunkNum];
            });

            this._length = datalength;
            this._chunkSize = chunkSize;
            this.lengthKnown = true;
        }
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });

          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }

        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function forceLoadLazyFile() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;
        function processData(byteArray) {
          function finish(byteArray) {
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency('cp ' + fullname);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency('cp ' + fullname);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function () {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          console.log('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function putRequest_onsuccess() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function putRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function getRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};

  function _lseek(fildes, offset, whence) {
      // off_t lseek(int fildes, off_t offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/lseek.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        return FS.llseek(stream, offset, whence);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }

  function _fileno(stream) {
      // int fileno(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fileno.html
      stream = FS.getStreamFromPtr(stream);
      if (!stream) return -1;
      return stream.fd;
    }function _fseek(stream, offset, whence) {
      // int fseek(FILE *stream, long offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fseek.html
      var fd = _fileno(stream);
      var ret = _lseek(fd, offset, whence);
      if (ret == -1) {
        return -1;
      }
      stream = FS.getStreamFromPtr(stream);
      stream.eof = false;
      return 0;
    }


  Module["_i64Subtract"] = _i64Subtract;


  Module["_i64Add"] = _i64Add;

  function _setlocale(category, locale) {
      if (!_setlocale.ret) _setlocale.ret = allocate([0], 'i8', ALLOC_NORMAL);
      return _setlocale.ret;
    }


  function _close(fildes) {
      // int close(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/close.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        FS.close(stream);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }

  function _fsync(fildes) {
      // int fsync(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fsync.html
      var stream = FS.getStream(fildes);
      if (stream) {
        // We write directly to the file system, so there's nothing to do here.
        return 0;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fclose(stream) {
      // int fclose(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fclose.html
      var fd = _fileno(stream);
      _fsync(fd);
      return _close(fd);
    }





  function _mkport() { throw 'TODO' }var SOCKFS={mount:function (mount) {
        return FS.createNode(null, '/', 16384 | 511 /* 0777 */, 0);
      },createSocket:function (family, type, protocol) {
        var streaming = type == 1;
        if (protocol) {
          assert(streaming == (protocol == 6)); // if SOCK_STREAM, must be tcp
        }

        // create our internal socket structure
        var sock = {
          family: family,
          type: type,
          protocol: protocol,
          server: null,
          peers: {},
          pending: [],
          recv_queue: [],
          sock_ops: SOCKFS.websocket_sock_ops
        };

        // create the filesystem node to store the socket structure
        var name = SOCKFS.nextname();
        var node = FS.createNode(SOCKFS.root, name, 49152, 0);
        node.sock = sock;

        // and the wrapping stream that enables library functions such
        // as read and write to indirectly interact with the socket
        var stream = FS.createStream({
          path: name,
          node: node,
          flags: FS.modeStringToFlags('r+'),
          seekable: false,
          stream_ops: SOCKFS.stream_ops
        });

        // map the new stream to the socket structure (sockets have a 1:1
        // relationship with a stream)
        sock.stream = stream;

        return sock;
      },getSocket:function (fd) {
        var stream = FS.getStream(fd);
        if (!stream || !FS.isSocket(stream.node.mode)) {
          return null;
        }
        return stream.node.sock;
      },stream_ops:{poll:function (stream) {
          var sock = stream.node.sock;
          return sock.sock_ops.poll(sock);
        },ioctl:function (stream, request, varargs) {
          var sock = stream.node.sock;
          return sock.sock_ops.ioctl(sock, request, varargs);
        },read:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          var msg = sock.sock_ops.recvmsg(sock, length);
          if (!msg) {
            // socket is closed
            return 0;
          }
          buffer.set(msg.buffer, offset);
          return msg.buffer.length;
        },write:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          return sock.sock_ops.sendmsg(sock, buffer, offset, length);
        },close:function (stream) {
          var sock = stream.node.sock;
          sock.sock_ops.close(sock);
        }},nextname:function () {
        if (!SOCKFS.nextname.current) {
          SOCKFS.nextname.current = 0;
        }
        return 'socket[' + (SOCKFS.nextname.current++) + ']';
      },websocket_sock_ops:{createPeer:function (sock, addr, port) {
          var ws;

          if (typeof addr === 'object') {
            ws = addr;
            addr = null;
            port = null;
          }

          if (ws) {
            // for sockets that've already connected (e.g. we're the server)
            // we can inspect the _socket property for the address
            if (ws._socket) {
              addr = ws._socket.remoteAddress;
              port = ws._socket.remotePort;
            }
            // if we're just now initializing a connection to the remote,
            // inspect the url property
            else {
              var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
              if (!result) {
                throw new Error('WebSocket URL must be in the format ws(s)://address:port');
              }
              addr = result[1];
              port = parseInt(result[2], 10);
            }
          } else {
            // create the actual websocket object and connect
            try {
              // runtimeConfig gets set to true if WebSocket runtime configuration is available.
              var runtimeConfig = (Module['websocket'] && ('object' === typeof Module['websocket']));

              // The default value is 'ws://' the replace is needed because the compiler replaces "//" comments with '#'
              // comments without checking context, so we'd end up with ws:#, the replace swaps the "#" for "//" again.
              var url = 'ws:#'.replace('#', '//');

              if (runtimeConfig) {
                if ('string' === typeof Module['websocket']['url']) {
                  url = Module['websocket']['url']; // Fetch runtime WebSocket URL config.
                }
              }

              if (url === 'ws://' || url === 'wss://') { // Is the supplied URL config just a prefix, if so complete it.
                url = url + addr + ':' + port;
              }

              // Make the WebSocket subprotocol (Sec-WebSocket-Protocol) default to binary if no configuration is set.
              var subProtocols = 'binary'; // The default value is 'binary'

              if (runtimeConfig) {
                if ('string' === typeof Module['websocket']['subprotocol']) {
                  subProtocols = Module['websocket']['subprotocol']; // Fetch runtime WebSocket subprotocol config.
                }
              }

              // The regex trims the string (removes spaces at the beginning and end, then splits the string by
              // <any space>,<any space> into an Array. Whitespace removal is important for Websockify and ws.
              subProtocols = subProtocols.replace(/^ +| +$/g,"").split(/ *, */);

              // The node ws library API for specifying optional subprotocol is slightly different than the browser's.
              var opts = ENVIRONMENT_IS_NODE ? {'protocol': subProtocols.toString()} : subProtocols;

              // If node we use the ws library.
              var WebSocket = ENVIRONMENT_IS_NODE ? require('ws') : window['WebSocket'];
              ws = new WebSocket(url, opts);
              ws.binaryType = 'arraybuffer';
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH);
            }
          }


          var peer = {
            addr: addr,
            port: port,
            socket: ws,
            dgram_send_queue: []
          };

          SOCKFS.websocket_sock_ops.addPeer(sock, peer);
          SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);

          // if this is a bound dgram socket, send the port number first to allow
          // us to override the ephemeral port reported to us by remotePort on the
          // remote end.
          if (sock.type === 2 && typeof sock.sport !== 'undefined') {
            peer.dgram_send_queue.push(new Uint8Array([
                255, 255, 255, 255,
                'p'.charCodeAt(0), 'o'.charCodeAt(0), 'r'.charCodeAt(0), 't'.charCodeAt(0),
                ((sock.sport & 0xff00) >> 8) , (sock.sport & 0xff)
            ]));
          }

          return peer;
        },getPeer:function (sock, addr, port) {
          return sock.peers[addr + ':' + port];
        },addPeer:function (sock, peer) {
          sock.peers[peer.addr + ':' + peer.port] = peer;
        },removePeer:function (sock, peer) {
          delete sock.peers[peer.addr + ':' + peer.port];
        },handlePeerEvents:function (sock, peer) {
          var first = true;

          var handleOpen = function () {
            try {
              var queued = peer.dgram_send_queue.shift();
              while (queued) {
                peer.socket.send(queued);
                queued = peer.dgram_send_queue.shift();
              }
            } catch (e) {
              // not much we can do here in the way of proper error handling as we've already
              // lied and said this data was sent. shut it down.
              peer.socket.close();
            }
          };

          function handleMessage(data) {
            assert(typeof data !== 'string' && data.byteLength !== undefined);  // must receive an ArrayBuffer
            data = new Uint8Array(data);  // make a typed array view on the array buffer


            // if this is the port message, override the peer's port with it
            var wasfirst = first;
            first = false;
            if (wasfirst &&
                data.length === 10 &&
                data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 &&
                data[4] === 'p'.charCodeAt(0) && data[5] === 'o'.charCodeAt(0) && data[6] === 'r'.charCodeAt(0) && data[7] === 't'.charCodeAt(0)) {
              // update the peer's port and it's key in the peer map
              var newport = ((data[8] << 8) | data[9]);
              SOCKFS.websocket_sock_ops.removePeer(sock, peer);
              peer.port = newport;
              SOCKFS.websocket_sock_ops.addPeer(sock, peer);
              return;
            }

            sock.recv_queue.push({ addr: peer.addr, port: peer.port, data: data });
          };

          if (ENVIRONMENT_IS_NODE) {
            peer.socket.on('open', handleOpen);
            peer.socket.on('message', function(data, flags) {
              if (!flags.binary) {
                return;
              }
              handleMessage((new Uint8Array(data)).buffer);  // copy from node Buffer -> ArrayBuffer
            });
            peer.socket.on('error', function() {
              // don't throw
            });
          } else {
            peer.socket.onopen = handleOpen;
            peer.socket.onmessage = function peer_socket_onmessage(event) {
              handleMessage(event.data);
            };
          }
        },poll:function (sock) {
          if (sock.type === 1 && sock.server) {
            // listen sockets should only say they're available for reading
            // if there are pending clients.
            return sock.pending.length ? (64 | 1) : 0;
          }

          var mask = 0;
          var dest = sock.type === 1 ?  // we only care about the socket state for connection-based sockets
            SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) :
            null;

          if (sock.recv_queue.length ||
              !dest ||  // connection-less sockets are always ready to read
              (dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {  // let recv return 0 once closed
            mask |= (64 | 1);
          }

          if (!dest ||  // connection-less sockets are always ready to write
              (dest && dest.socket.readyState === dest.socket.OPEN)) {
            mask |= 4;
          }

          if ((dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {
            mask |= 16;
          }

          return mask;
        },ioctl:function (sock, request, arg) {
          switch (request) {
            case 21531:
              var bytes = 0;
              if (sock.recv_queue.length) {
                bytes = sock.recv_queue[0].data.length;
              }
              HEAP32[((arg)>>2)]=bytes;
              return 0;
            default:
              return ERRNO_CODES.EINVAL;
          }
        },close:function (sock) {
          // if we've spawned a listen server, close it
          if (sock.server) {
            try {
              sock.server.close();
            } catch (e) {
            }
            sock.server = null;
          }
          // close any peer connections
          var peers = Object.keys(sock.peers);
          for (var i = 0; i < peers.length; i++) {
            var peer = sock.peers[peers[i]];
            try {
              peer.socket.close();
            } catch (e) {
            }
            SOCKFS.websocket_sock_ops.removePeer(sock, peer);
          }
          return 0;
        },bind:function (sock, addr, port) {
          if (typeof sock.saddr !== 'undefined' || typeof sock.sport !== 'undefined') {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already bound
          }
          sock.saddr = addr;
          sock.sport = port || _mkport();
          // in order to emulate dgram sockets, we need to launch a listen server when
          // binding on a connection-less socket
          // note: this is only required on the server side
          if (sock.type === 2) {
            // close the existing server if it exists
            if (sock.server) {
              sock.server.close();
              sock.server = null;
            }
            // swallow error operation not supported error that occurs when binding in the
            // browser where this isn't supported
            try {
              sock.sock_ops.listen(sock, 0);
            } catch (e) {
              if (!(e instanceof FS.ErrnoError)) throw e;
              if (e.errno !== ERRNO_CODES.EOPNOTSUPP) throw e;
            }
          }
        },connect:function (sock, addr, port) {
          if (sock.server) {
            throw new FS.ErrnoError(ERRNO_CODS.EOPNOTSUPP);
          }

          // TODO autobind
          // if (!sock.addr && sock.type == 2) {
          // }

          // early out if we're already connected / in the middle of connecting
          if (typeof sock.daddr !== 'undefined' && typeof sock.dport !== 'undefined') {
            var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
            if (dest) {
              if (dest.socket.readyState === dest.socket.CONNECTING) {
                throw new FS.ErrnoError(ERRNO_CODES.EALREADY);
              } else {
                throw new FS.ErrnoError(ERRNO_CODES.EISCONN);
              }
            }
          }

          // add the socket to our peer list and set our
          // destination address / port to match
          var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
          sock.daddr = peer.addr;
          sock.dport = peer.port;

          // always "fail" in non-blocking mode
          throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS);
        },listen:function (sock, backlog) {
          if (!ENVIRONMENT_IS_NODE) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
          }
          if (sock.server) {
             throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already listening
          }
          var WebSocketServer = require('ws').Server;
          var host = sock.saddr;
          sock.server = new WebSocketServer({
            host: host,
            port: sock.sport
            // TODO support backlog
          });

          sock.server.on('connection', function(ws) {
            if (sock.type === 1) {
              var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);

              // create a peer on the new socket
              var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
              newsock.daddr = peer.addr;
              newsock.dport = peer.port;

              // push to queue for accept to pick up
              sock.pending.push(newsock);
            } else {
              // create a peer on the listen socket so calling sendto
              // with the listen socket and an address will resolve
              // to the correct client
              SOCKFS.websocket_sock_ops.createPeer(sock, ws);
            }
          });
          sock.server.on('closed', function() {
            sock.server = null;
          });
          sock.server.on('error', function() {
            // don't throw
          });
        },accept:function (listensock) {
          if (!listensock.server) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          var newsock = listensock.pending.shift();
          newsock.stream.flags = listensock.stream.flags;
          return newsock;
        },getname:function (sock, peer) {
          var addr, port;
          if (peer) {
            if (sock.daddr === undefined || sock.dport === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            }
            addr = sock.daddr;
            port = sock.dport;
          } else {
            // TODO saddr and sport will be set for bind()'d UDP sockets, but what
            // should we be returning for TCP sockets that've been connect()'d?
            addr = sock.saddr || 0;
            port = sock.sport || 0;
          }
          return { addr: addr, port: port };
        },sendmsg:function (sock, buffer, offset, length, addr, port) {
          if (sock.type === 2) {
            // connection-less sockets will honor the message address,
            // and otherwise fall back to the bound destination address
            if (addr === undefined || port === undefined) {
              addr = sock.daddr;
              port = sock.dport;
            }
            // if there was no address to fall back to, error out
            if (addr === undefined || port === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ);
            }
          } else {
            // connection-based sockets will only use the bound
            addr = sock.daddr;
            port = sock.dport;
          }

          // find the peer for the destination address
          var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);

          // early out if not connected with a connection-based socket
          if (sock.type === 1) {
            if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            } else if (dest.socket.readyState === dest.socket.CONNECTING) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }

          // create a copy of the incoming data to send, as the WebSocket API
          // doesn't work entirely with an ArrayBufferView, it'll just send
          // the entire underlying buffer
          var data;
          if (buffer instanceof Array || buffer instanceof ArrayBuffer) {
            data = buffer.slice(offset, offset + length);
          } else {  // ArrayBufferView
            data = buffer.buffer.slice(buffer.byteOffset + offset, buffer.byteOffset + offset + length);
          }

          // if we're emulating a connection-less dgram socket and don't have
          // a cached connection, queue the buffer to send upon connect and
          // lie, saying the data was sent now.
          if (sock.type === 2) {
            if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
              // if we're not connected, open a new connection
              if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
              }
              dest.dgram_send_queue.push(data);
              return length;
            }
          }

          try {
            // send the actual data
            dest.socket.send(data);
            return length;
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
        },recvmsg:function (sock, length) {
          // http://pubs.opengroup.org/onlinepubs/7908799/xns/recvmsg.html
          if (sock.type === 1 && sock.server) {
            // tcp servers should not be recv()'ing on the listen socket
            throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
          }

          var queued = sock.recv_queue.shift();
          if (!queued) {
            if (sock.type === 1) {
              var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);

              if (!dest) {
                // if we have a destination address but are not connected, error out
                throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
              }
              else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                // return null if the socket has closed
                return null;
              }
              else {
                // else, our socket is in a valid state but truly has nothing available
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
            } else {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }

          // queued.data will be an ArrayBuffer if it's unadulterated, but if it's
          // requeued TCP data it'll be an ArrayBufferView
          var queuedLength = queued.data.byteLength || queued.data.length;
          var queuedOffset = queued.data.byteOffset || 0;
          var queuedBuffer = queued.data.buffer || queued.data;
          var bytesRead = Math.min(length, queuedLength);
          var res = {
            buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
            addr: queued.addr,
            port: queued.port
          };


          // push back any unread data for TCP connections
          if (sock.type === 1 && bytesRead < queuedLength) {
            var bytesRemaining = queuedLength - bytesRead;
            queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
            sock.recv_queue.unshift(queued);
          }

          return res;
        }}};function _recv(fd, buf, len, flags) {
      var sock = SOCKFS.getSocket(fd);
      if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      // TODO honor flags
      return _read(fd, buf, len);
    }

  function _pread(fildes, buf, nbyte, offset) {
      // ssize_t pread(int fildes, void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _read(fildes, buf, nbyte) {
      // ssize_t read(int fildes, void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }


      try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fread(ptr, size, nitems, stream) {
      // size_t fread(void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fread.html
      var bytesToRead = nitems * size;
      if (bytesToRead == 0) {
        return 0;
      }
      var bytesRead = 0;
      var streamObj = FS.getStreamFromPtr(stream);
      if (!streamObj) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return 0;
      }
      while (streamObj.ungotten.length && bytesToRead > 0) {
        HEAP8[((ptr++)|0)]=streamObj.ungotten.pop();
        bytesToRead--;
        bytesRead++;
      }
      var err = _read(streamObj.fd, ptr, bytesToRead);
      if (err == -1) {
        if (streamObj) streamObj.error = true;
        return 0;
      }
      bytesRead += err;
      if (bytesRead < bytesToRead) streamObj.eof = true;
      return Math.floor(bytesRead / size);
    }

  function _toupper(chr) {
      if (chr >= 97 && chr <= 122) {
        return chr - 97 + 65;
      } else {
        return chr;
      }
    }



  function _open(path, oflag, varargs) {
      // int open(const char *path, int oflag, ...);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/open.html
      var mode = HEAP32[((varargs)>>2)];
      path = Pointer_stringify(path);
      try {
        var stream = FS.open(path, oflag, mode);
        return stream.fd;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fopen(filename, mode) {
      // FILE *fopen(const char *restrict filename, const char *restrict mode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fopen.html
      var flags;
      mode = Pointer_stringify(mode);
      if (mode[0] == 'r') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 0;
        }
      } else if (mode[0] == 'w') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 64;
        flags |= 512;
      } else if (mode[0] == 'a') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 64;
        flags |= 1024;
      } else {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return 0;
      }
      var fd = _open(filename, flags, allocate([0x1FF, 0, 0, 0], 'i32', ALLOC_STACK));  // All creation permissions.
      return fd === -1 ? 0 : FS.getPtrForStream(FS.getStream(fd));
    }

  var _emscripten_check_longjmp=true;



  function _send(fd, buf, len, flags) {
      var sock = SOCKFS.getSocket(fd);
      if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      // TODO honor flags
      return _write(fd, buf, len);
    }

  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }


      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fputc(c, stream) {
      // int fputc(int c, FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputc.html
      var chr = unSign(c & 0xFF);
      HEAP8[((_fputc.ret)|0)]=chr;
      var fd = _fileno(stream);
      var ret = _write(fd, _fputc.ret, 1);
      if (ret == -1) {
        var streamObj = FS.getStreamFromPtr(stream);
        if (streamObj) streamObj.error = true;
        return -1;
      } else {
        return chr;
      }
    }

  var _log=Math_log;

  var _emscripten_postinvoke=true;


  function _putchar(c) {
      // int putchar(int c);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/putchar.html
      return _fputc(c, HEAP32[((_stdout)>>2)]);
    }
  Module["_saveSetjmp"] = _saveSetjmp;

  function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var fd = _fileno(stream);
      var bytesWritten = _write(fd, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        var streamObj = FS.getStreamFromPtr(stream);
        if (streamObj) streamObj.error = true;
        return 0;
      } else {
        return Math.floor(bytesWritten / size);
      }
    }

  function _system(command) {
      // int system(const char *command);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/system.html
      // Can't call external programs.
      ___setErrNo(ERRNO_CODES.EAGAIN);
      return -1;
    }

  function _frexp(x, exp_addr) {
      var sig = 0, exp_ = 0;
      if (x !== 0) {
        var sign = 1;
        if (x < 0) {
          x = -x;
          sign = -1;
        }
        var raw_exp = Math.log(x)/Math.log(2);
        exp_ = Math.ceil(raw_exp);
        if (exp_ === raw_exp) exp_ += 1;
        sig = sign*x/Math.pow(2, exp_);
      }
      HEAP32[((exp_addr)>>2)]=exp_;
      return sig;
    }



  var _tzname=allocate(8, "i32*", ALLOC_STATIC);

  var _daylight=allocate(1, "i32*", ALLOC_STATIC);

  var _timezone=allocate(1, "i32*", ALLOC_STATIC);function _tzset() {
      // TODO: Use (malleable) environment variables instead of system settings.
      if (_tzset.called) return;
      _tzset.called = true;

      HEAP32[((_timezone)>>2)]=-(new Date()).getTimezoneOffset() * 60;

      var winter = new Date(2000, 0, 1);
      var summer = new Date(2000, 6, 1);
      HEAP32[((_daylight)>>2)]=Number(winter.getTimezoneOffset() != summer.getTimezoneOffset());

      var winterName = 'GMT'; // XXX do not rely on browser timezone info, it is very unpredictable | winter.toString().match(/\(([A-Z]+)\)/)[1];
      var summerName = 'GMT'; // XXX do not rely on browser timezone info, it is very unpredictable | summer.toString().match(/\(([A-Z]+)\)/)[1];
      var winterNamePtr = allocate(intArrayFromString(winterName), 'i8', ALLOC_NORMAL);
      var summerNamePtr = allocate(intArrayFromString(summerName), 'i8', ALLOC_NORMAL);
      HEAP32[((_tzname)>>2)]=winterNamePtr;
      HEAP32[(((_tzname)+(4))>>2)]=summerNamePtr;
    }function _mktime(tmPtr) {
      _tzset();
      var year = HEAP32[(((tmPtr)+(20))>>2)];
      var timestamp = new Date(year >= 1900 ? year : year + 1900,
                               HEAP32[(((tmPtr)+(16))>>2)],
                               HEAP32[(((tmPtr)+(12))>>2)],
                               HEAP32[(((tmPtr)+(8))>>2)],
                               HEAP32[(((tmPtr)+(4))>>2)],
                               HEAP32[((tmPtr)>>2)],
                               0).getTime() / 1000;
      HEAP32[(((tmPtr)+(24))>>2)]=new Date(timestamp).getDay();
      var yday = Math.round((timestamp - (new Date(year, 0, 1)).getTime()) / (1000 * 60 * 60 * 24));
      HEAP32[(((tmPtr)+(28))>>2)]=yday;
      return timestamp;
    }

  function _isalpha(chr) {
      return (chr >= 97 && chr <= 122) ||
             (chr >= 65 && chr <= 90);
    }


  function _malloc(bytes) {
      /* Over-allocate to make sure it is byte-aligned by 8.
       * This will leak memory, but this is only the dummy
       * implementation (replaced by dlmalloc normally) so
       * not an issue.
       */
      var ptr = Runtime.dynamicAlloc(bytes + 8);
      return (ptr+8) & 0xFFFFFFF8;
    }
  Module["_malloc"] = _malloc;function _tmpnam(s, dir, prefix) {
      // char *tmpnam(char *s);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/tmpnam.html
      // NOTE: The dir and prefix arguments are for internal use only.
      var folder = FS.findObject(dir || '/tmp');
      if (!folder || !folder.isFolder) {
        dir = '/tmp';
        folder = FS.findObject(dir);
        if (!folder || !folder.isFolder) return 0;
      }
      var name = prefix || 'file';
      do {
        name += String.fromCharCode(65 + Math.floor(Math.random() * 25));
      } while (name in folder.contents);
      var result = dir + '/' + name;
      if (!_tmpnam.buffer) _tmpnam.buffer = _malloc(256);
      if (!s) s = _tmpnam.buffer;
      writeAsciiToMemory(result, s);
      return s;
    }

  var Browser={mainLoop:{scheduler:null,method:"",shouldPause:false,paused:false,queue:[],pause:function () {
          Browser.mainLoop.shouldPause = true;
        },resume:function () {
          if (Browser.mainLoop.paused) {
            Browser.mainLoop.paused = false;
            Browser.mainLoop.scheduler();
          }
          Browser.mainLoop.shouldPause = false;
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers

        if (Browser.initted || ENVIRONMENT_IS_WORKER) return;
        Browser.initted = true;

        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
          console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
          Module.noImageDecoding = true;
        }

        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).

        var imagePlugin = {};
        imagePlugin['canHandle'] = function imagePlugin_canHandle(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function imagePlugin_handle(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function img_onload() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function img_onerror(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);

        var audioPlugin = {};
        audioPlugin['canHandle'] = function audioPlugin_canHandle(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function audioPlugin_handle(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function audio_onerror(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);

        // Canvas event setup

        var canvas = Module['canvas'];

        // forced aspect ratio can be enabled by defining 'forcedAspectRatio' on Module
        // Module['forcedAspectRatio'] = 4 / 3;

        canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                    canvas['mozRequestPointerLock'] ||
                                    canvas['webkitRequestPointerLock'] ||
                                    canvas['msRequestPointerLock'] ||
                                    function(){};
        canvas.exitPointerLock = document['exitPointerLock'] ||
                                 document['mozExitPointerLock'] ||
                                 document['webkitExitPointerLock'] ||
                                 document['msExitPointerLock'] ||
                                 function(){}; // no-op if function does not exist
        canvas.exitPointerLock = canvas.exitPointerLock.bind(document);

        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas ||
                                document['msPointerLockElement'] === canvas;
        }

        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
        document.addEventListener('mspointerlockchange', pointerLockChange, false);

        if (Module['elementPointerLock']) {
          canvas.addEventListener("click", function(ev) {
            if (!Browser.pointerLock && canvas.requestPointerLock) {
              canvas.requestPointerLock();
              ev.preventDefault();
            }
          }, false);
        }
      },createContext:function (canvas, useWebGL, setInModule, webGLContextAttributes) {
        var ctx;
        var errorInfo = '?';
        function onContextCreationError(event) {
          errorInfo = event.statusMessage || errorInfo;
        }
        try {
          if (useWebGL) {
            var contextAttributes = {
              antialias: false,
              alpha: false
            };

            if (webGLContextAttributes) {
              for (var attribute in webGLContextAttributes) {
                contextAttributes[attribute] = webGLContextAttributes[attribute];
              }
            }


            canvas.addEventListener('webglcontextcreationerror', onContextCreationError, false);
            try {
              ['experimental-webgl', 'webgl'].some(function(webglId) {
                return ctx = canvas.getContext(webglId, contextAttributes);
              });
            } finally {
              canvas.removeEventListener('webglcontextcreationerror', onContextCreationError, false);
            }
          } else {
            ctx = canvas.getContext('2d');
          }
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas: ' + [errorInfo, e]);
          return null;
        }
        if (useWebGL) {
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";

          // Warn on context loss
          canvas.addEventListener('webglcontextlost', function(event) {
            alert('WebGL context lost. You will need to reload the page.');
          }, false);
        }
        if (setInModule) {
          GLctx = Module.ctx = ctx;
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;

        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          var canvasContainer = canvas.parentNode;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement'] ||
               document['msFullScreenElement'] || document['msFullscreenElement'] ||
               document['webkitCurrentFullScreenElement']) === canvasContainer) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'] ||
                                      document['msExitFullscreen'] ||
                                      document['exitFullscreen'] ||
                                      function() {};
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else {

            // remove the full screen specific parent of the canvas again to restore the HTML structure from before going full screen
            canvasContainer.parentNode.insertBefore(canvas, canvasContainer);
            canvasContainer.parentNode.removeChild(canvasContainer);

            if (Browser.resizeCanvas) Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
          Browser.updateCanvasDimensions(canvas);
        }

        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
          document.addEventListener('MSFullscreenChange', fullScreenChange, false);
        }

        // create a new parent to ensure the canvas has no siblings. this allows browsers to optimize full screen performance when its parent is the full screen root
        var canvasContainer = document.createElement("div");
        canvas.parentNode.insertBefore(canvasContainer, canvas);
        canvasContainer.appendChild(canvas);

        // use parent of canvas as full screen root to allow aspect ratio correction (Firefox stretches the root to screen size)
        canvasContainer.requestFullScreen = canvasContainer['requestFullScreen'] ||
                                            canvasContainer['mozRequestFullScreen'] ||
                                            canvasContainer['msRequestFullscreen'] ||
                                           (canvasContainer['webkitRequestFullScreen'] ? function() { canvasContainer['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
        canvasContainer.requestFullScreen();
      },requestAnimationFrame:function requestAnimationFrame(func) {
        if (typeof window === 'undefined') { // Provide fallback to setTimeout if window is undefined (e.g. in Node.js)
          setTimeout(func, 1000/60);
        } else {
          if (!window.requestAnimationFrame) {
            window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                           window['mozRequestAnimationFrame'] ||
                                           window['webkitRequestAnimationFrame'] ||
                                           window['msRequestAnimationFrame'] ||
                                           window['oRequestAnimationFrame'] ||
                                           window['setTimeout'];
          }
          window.requestAnimationFrame(func);
        }
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (!ABORT) func();
        });
      },safeSetTimeout:function (func, timeout) {
        return setTimeout(function() {
          if (!ABORT) func();
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        return setInterval(function() {
          if (!ABORT) func();
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },getMouseWheelDelta:function (event) {
        return Math.max(-1, Math.min(1, event.type === 'DOMMouseScroll' ? event.detail : -event.wheelDelta));
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }

          // check if SDL is available
          if (typeof SDL != "undefined") {
            Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
            Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
            // just add the mouse delta to the current absolut mouse position
            // FIXME: ideally this should be clamped against the canvas size and zero
            Browser.mouseX += Browser.mouseMovementX;
            Browser.mouseY += Browser.mouseMovementY;
          }
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var x, y;

          // Neither .scrollX or .pageXOffset are defined in a spec, but
          // we prefer .scrollX because it is currently in a spec draft.
          // (see: http://www.w3.org/TR/2013/WD-cssom-view-20131217/)
          var scrollX = ((typeof window.scrollX !== 'undefined') ? window.scrollX : window.pageXOffset);
          var scrollY = ((typeof window.scrollY !== 'undefined') ? window.scrollY : window.pageYOffset);
          if (event.type == 'touchstart' ||
              event.type == 'touchend' ||
              event.type == 'touchmove') {
            var t = event.touches.item(0);
            if (t) {
              x = t.pageX - (scrollX + rect.left);
              y = t.pageY - (scrollY + rect.top);
            } else {
              return;
            }
          } else {
            x = event.pageX - (scrollX + rect.left);
            y = event.pageY - (scrollY + rect.top);
          }

          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);

          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function xhr_onload() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        Browser.updateCanvasDimensions(canvas, width, height);
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        // check if SDL is available
        if (typeof SDL != "undefined") {
          var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
          flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
          HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        // check if SDL is available
        if (typeof SDL != "undefined") {
          var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
          flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
          HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },updateCanvasDimensions:function (canvas, wNative, hNative) {
        if (wNative && hNative) {
          canvas.widthNative = wNative;
          canvas.heightNative = hNative;
        } else {
          wNative = canvas.widthNative;
          hNative = canvas.heightNative;
        }
        var w = wNative;
        var h = hNative;
        if (Module['forcedAspectRatio'] && Module['forcedAspectRatio'] > 0) {
          if (w/h < Module['forcedAspectRatio']) {
            w = Math.round(h * Module['forcedAspectRatio']);
          } else {
            h = Math.round(w / Module['forcedAspectRatio']);
          }
        }
        if (((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
             document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
             document['fullScreenElement'] || document['fullscreenElement'] ||
             document['msFullScreenElement'] || document['msFullscreenElement'] ||
             document['webkitCurrentFullScreenElement']) === canvas.parentNode) && (typeof screen != 'undefined')) {
           var factor = Math.min(screen.width / w, screen.height / h);
           w = Math.round(w * factor);
           h = Math.round(h * factor);
        }
        if (Browser.resizeCanvas) {
          if (canvas.width  != w) canvas.width  = w;
          if (canvas.height != h) canvas.height = h;
          if (typeof canvas.style != 'undefined') {
            canvas.style.removeProperty( "width");
            canvas.style.removeProperty("height");
          }
        } else {
          if (canvas.width  != wNative) canvas.width  = wNative;
          if (canvas.height != hNative) canvas.height = hNative;
          if (typeof canvas.style != 'undefined') {
            if (w != wNative || h != hNative) {
              canvas.style.setProperty( "width", w + "px", "important");
              canvas.style.setProperty("height", h + "px", "important");
            } else {
              canvas.style.removeProperty( "width");
              canvas.style.removeProperty("height");
            }
          }
        }
      }};

  function _log10(x) {
      return Math.log(x) / Math.LN10;
    }

  function _isspace(chr) {
      return (chr == 32) || (chr >= 9 && chr <= 13);
    }


  var ___tm_current=allocate(44, "i8", ALLOC_STATIC);


  var ___tm_timezone=allocate(intArrayFromString("GMT"), "i8", ALLOC_STATIC);function _localtime_r(time, tmPtr) {
      _tzset();
      var date = new Date(HEAP32[((time)>>2)]*1000);
      HEAP32[((tmPtr)>>2)]=date.getSeconds();
      HEAP32[(((tmPtr)+(4))>>2)]=date.getMinutes();
      HEAP32[(((tmPtr)+(8))>>2)]=date.getHours();
      HEAP32[(((tmPtr)+(12))>>2)]=date.getDate();
      HEAP32[(((tmPtr)+(16))>>2)]=date.getMonth();
      HEAP32[(((tmPtr)+(20))>>2)]=date.getFullYear()-1900;
      HEAP32[(((tmPtr)+(24))>>2)]=date.getDay();

      var start = new Date(date.getFullYear(), 0, 1);
      var yday = Math.floor((date.getTime() - start.getTime()) / (1000 * 60 * 60 * 24));
      HEAP32[(((tmPtr)+(28))>>2)]=yday;
      HEAP32[(((tmPtr)+(36))>>2)]=start.getTimezoneOffset() * 60;

      var dst = Number(start.getTimezoneOffset() != date.getTimezoneOffset());
      HEAP32[(((tmPtr)+(32))>>2)]=dst;

      HEAP32[(((tmPtr)+(40))>>2)]=___tm_timezone;

      return tmPtr;
    }function _localtime(time) {
      return _localtime_r(time, ___tm_current);
    }

  function _srand(seed) {
      HEAP32[((___rand_seed)>>2)]=seed
    }

  var _emscripten_prep_setjmp=true;




  Module["_testSetjmp"] = _testSetjmp;function _longjmp(env, value) {
      asm['setThrew'](env, value || 1);
      throw 'longjmp';
    }function _emscripten_longjmp(env, value) {
      _longjmp(env, value);
    }

  var _ceil=Math_ceil;


  function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.set(HEAPU8.subarray(src, src+num), dest);
      return dest;
    }
  Module["_memcpy"] = _memcpy;

  var _llvm_pow_f64=Math_pow;



  Module["_strlen"] = _strlen;function _fputs(s, stream) {
      // int fputs(const char *restrict s, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fputs.html
      var fd = _fileno(stream);
      return _write(fd, s, _strlen(s));
    }

  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) self.alloc(bytes);
      return ret;  // Previous break location.
    }


  function _sinh(x) {
      var p = Math.pow(Math.E, x);
      return (p - (1 / p)) / 2;
    }

  function _cosh(x) {
      var p = Math.pow(Math.E, x);
      return (p + (1 / p)) / 2;
    }function _tanh(x) {
      return _sinh(x) / _cosh(x);
    }

  function _signal(sig, func) {
      // TODO
      return 0;
    }



  function __getFloat(text) {
      return /^[+-]?[0-9]*\.?[0-9]+([eE][+-]?[0-9]+)?/.exec(text);
    }function __scanString(format, get, unget, varargs) {
      if (!__scanString.whiteSpace) {
        __scanString.whiteSpace = {};
        __scanString.whiteSpace[32] = 1;
        __scanString.whiteSpace[9] = 1;
        __scanString.whiteSpace[10] = 1;
        __scanString.whiteSpace[11] = 1;
        __scanString.whiteSpace[12] = 1;
        __scanString.whiteSpace[13] = 1;
      }
      // Supports %x, %4x, %d.%d, %lld, %s, %f, %lf.
      // TODO: Support all format specifiers.
      format = Pointer_stringify(format);
      var soFar = 0;
      if (format.indexOf('%n') >= 0) {
        // need to track soFar
        var _get = get;
        get = function get() {
          soFar++;
          return _get();
        }
        var _unget = unget;
        unget = function unget() {
          soFar--;
          return _unget();
        }
      }
      var formatIndex = 0;
      var argsi = 0;
      var fields = 0;
      var argIndex = 0;
      var next;

      mainLoop:
      for (var formatIndex = 0; formatIndex < format.length;) {
        if (format[formatIndex] === '%' && format[formatIndex+1] == 'n') {
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          HEAP32[((argPtr)>>2)]=soFar;
          formatIndex += 2;
          continue;
        }

        if (format[formatIndex] === '%') {
          var nextC = format.indexOf('c', formatIndex+1);
          if (nextC > 0) {
            var maxx = 1;
            if (nextC > formatIndex+1) {
              var sub = format.substring(formatIndex+1, nextC);
              maxx = parseInt(sub);
              if (maxx != sub) maxx = 0;
            }
            if (maxx) {
              var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
              argIndex += Runtime.getAlignSize('void*', null, true);
              fields++;
              for (var i = 0; i < maxx; i++) {
                next = get();
                HEAP8[((argPtr++)|0)]=next;
                if (next === 0) return i > 0 ? fields : fields-1; // we failed to read the full length of this field
              }
              formatIndex += nextC - formatIndex + 1;
              continue;
            }
          }
        }

        // handle %[...]
        if (format[formatIndex] === '%' && format.indexOf('[', formatIndex+1) > 0) {
          var match = /\%([0-9]*)\[(\^)?(\]?[^\]]*)\]/.exec(format.substring(formatIndex));
          if (match) {
            var maxNumCharacters = parseInt(match[1]) || Infinity;
            var negateScanList = (match[2] === '^');
            var scanList = match[3];

            // expand "middle" dashs into character sets
            var middleDashMatch;
            while ((middleDashMatch = /([^\-])\-([^\-])/.exec(scanList))) {
              var rangeStartCharCode = middleDashMatch[1].charCodeAt(0);
              var rangeEndCharCode = middleDashMatch[2].charCodeAt(0);
              for (var expanded = ''; rangeStartCharCode <= rangeEndCharCode; expanded += String.fromCharCode(rangeStartCharCode++));
              scanList = scanList.replace(middleDashMatch[1] + '-' + middleDashMatch[2], expanded);
            }

            var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
            argIndex += Runtime.getAlignSize('void*', null, true);
            fields++;

            for (var i = 0; i < maxNumCharacters; i++) {
              next = get();
              if (negateScanList) {
                if (scanList.indexOf(String.fromCharCode(next)) < 0) {
                  HEAP8[((argPtr++)|0)]=next;
                } else {
                  unget();
                  break;
                }
              } else {
                if (scanList.indexOf(String.fromCharCode(next)) >= 0) {
                  HEAP8[((argPtr++)|0)]=next;
                } else {
                  unget();
                  break;
                }
              }
            }

            // write out null-terminating character
            HEAP8[((argPtr++)|0)]=0;
            formatIndex += match[0].length;

            continue;
          }
        }
        // remove whitespace
        while (1) {
          next = get();
          if (next == 0) return fields;
          if (!(next in __scanString.whiteSpace)) break;
        }
        unget();

        if (format[formatIndex] === '%') {
          formatIndex++;
          var suppressAssignment = false;
          if (format[formatIndex] == '*') {
            suppressAssignment = true;
            formatIndex++;
          }
          var maxSpecifierStart = formatIndex;
          while (format[formatIndex].charCodeAt(0) >= 48 &&
                 format[formatIndex].charCodeAt(0) <= 57) {
            formatIndex++;
          }
          var max_;
          if (formatIndex != maxSpecifierStart) {
            max_ = parseInt(format.slice(maxSpecifierStart, formatIndex), 10);
          }
          var long_ = false;
          var half = false;
          var longLong = false;
          if (format[formatIndex] == 'l') {
            long_ = true;
            formatIndex++;
            if (format[formatIndex] == 'l') {
              longLong = true;
              formatIndex++;
            }
          } else if (format[formatIndex] == 'h') {
            half = true;
            formatIndex++;
          }
          var type = format[formatIndex];
          formatIndex++;
          var curr = 0;
          var buffer = [];
          // Read characters according to the format. floats are trickier, they may be in an unfloat state in the middle, then be a valid float later
          if (type == 'f' || type == 'e' || type == 'g' ||
              type == 'F' || type == 'E' || type == 'G') {
            next = get();
            while (next > 0 && (!(next in __scanString.whiteSpace)))  {
              buffer.push(String.fromCharCode(next));
              next = get();
            }
            var m = __getFloat(buffer.join(''));
            var last = m ? m[0].length : 0;
            for (var i = 0; i < buffer.length - last + 1; i++) {
              unget();
            }
            buffer.length = last;
          } else {
            next = get();
            var first = true;

            // Strip the optional 0x prefix for %x.
            if ((type == 'x' || type == 'X') && (next == 48)) {
              var peek = get();
              if (peek == 120 || peek == 88) {
                next = get();
              } else {
                unget();
              }
            }

            while ((curr < max_ || isNaN(max_)) && next > 0) {
              if (!(next in __scanString.whiteSpace) && // stop on whitespace
                  (type == 's' ||
                   ((type === 'd' || type == 'u' || type == 'i') && ((next >= 48 && next <= 57) ||
                                                                     (first && next == 45))) ||
                   ((type === 'x' || type === 'X') && (next >= 48 && next <= 57 ||
                                     next >= 97 && next <= 102 ||
                                     next >= 65 && next <= 70))) &&
                  (formatIndex >= format.length || next !== format[formatIndex].charCodeAt(0))) { // Stop when we read something that is coming up
                buffer.push(String.fromCharCode(next));
                next = get();
                curr++;
                first = false;
              } else {
                break;
              }
            }
            unget();
          }
          if (buffer.length === 0) return 0;  // Failure.
          if (suppressAssignment) continue;

          var text = buffer.join('');
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          switch (type) {
            case 'd': case 'u': case 'i':
              if (half) {
                HEAP16[((argPtr)>>1)]=parseInt(text, 10);
              } else if (longLong) {
                (tempI64 = [parseInt(text, 10)>>>0,(tempDouble=parseInt(text, 10),(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)],HEAP32[((argPtr)>>2)]=tempI64[0],HEAP32[(((argPtr)+(4))>>2)]=tempI64[1]);
              } else {
                HEAP32[((argPtr)>>2)]=parseInt(text, 10);
              }
              break;
            case 'X':
            case 'x':
              HEAP32[((argPtr)>>2)]=parseInt(text, 16);
              break;
            case 'F':
            case 'f':
            case 'E':
            case 'e':
            case 'G':
            case 'g':
            case 'E':
              // fallthrough intended
              if (long_) {
                HEAPF64[((argPtr)>>3)]=parseFloat(text);
              } else {
                HEAPF32[((argPtr)>>2)]=parseFloat(text);
              }
              break;
            case 's':
              var array = intArrayFromString(text);
              for (var j = 0; j < array.length; j++) {
                HEAP8[(((argPtr)+(j))|0)]=array[j];
              }
              break;
          }
          fields++;
        } else if (format[formatIndex].charCodeAt(0) in __scanString.whiteSpace) {
          next = get();
          while (next in __scanString.whiteSpace) {
            if (next <= 0) break mainLoop;  // End of input.
            next = get();
          }
          unget(next);
          formatIndex++;
        } else {
          // Not a specifier.
          next = get();
          if (format[formatIndex].charCodeAt(0) !== next) {
            unget(next);
            break mainLoop;
          }
          formatIndex++;
        }
      }
      return fields;
    }

  function _fgetc(stream) {
      // int fgetc(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fgetc.html
      var streamObj = FS.getStreamFromPtr(stream);
      if (!streamObj) return -1;
      if (streamObj.eof || streamObj.error) return -1;
      var ret = _fread(_fgetc.ret, 1, 1, stream);
      if (ret == 0) {
        return -1;
      } else if (ret == -1) {
        streamObj.error = true;
        return -1;
      } else {
        return HEAPU8[((_fgetc.ret)|0)];
      }
    }

  function _ungetc(c, stream) {
      // int ungetc(int c, FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ungetc.html
      stream = FS.getStreamFromPtr(stream);
      if (!stream) {
        return -1;
      }
      if (c === -1) {
        // do nothing for EOF character
        return c;
      }
      c = unSign(c & 0xFF);
      stream.ungotten.push(c);
      stream.eof = false;
      return c;
    }function _fscanf(stream, format, varargs) {
      // int fscanf(FILE *restrict stream, const char *restrict format, ... );
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/scanf.html
      var streamObj = FS.getStreamFromPtr(stream);
      if (!streamObj) {
        return -1;
      }
      var buffer = [];
      function get() {
        var c = _fgetc(stream);
        buffer.push(c);
        return c;
      };
      function unget() {
        _ungetc(buffer.pop(), stream);
      };
      return __scanString(format, get, unget, varargs);
    }

  var _emscripten_preinvoke=true;

  function _localeconv() {
      // %struct.timeval = type { char* decimal point, other stuff... }
      // var indexes = Runtime.calculateStructAlignment({ fields: ['i32', 'i32'] });
      var me = _localeconv;
      if (!me.ret) {
      // These are defaults from the "C" locale
        me.ret = allocate([
          allocate(intArrayFromString('.'), 'i8', ALLOC_NORMAL),0,0,0, // decimal_point
          allocate(intArrayFromString(''), 'i8', ALLOC_NORMAL),0,0,0, // thousands_sep
          allocate(intArrayFromString(''), 'i8', ALLOC_NORMAL),0,0,0, // grouping
          allocate(intArrayFromString(''), 'i8', ALLOC_NORMAL),0,0,0, // int_curr_symbol
          allocate(intArrayFromString(''), 'i8', ALLOC_NORMAL),0,0,0, // currency_symbol
          allocate(intArrayFromString(''), 'i8', ALLOC_NORMAL),0,0,0, // mon_decimal_point
          allocate(intArrayFromString(''), 'i8', ALLOC_NORMAL),0,0,0, // mon_thousands_sep
          allocate(intArrayFromString(''), 'i8', ALLOC_NORMAL),0,0,0, // mon_grouping
          allocate(intArrayFromString(''), 'i8', ALLOC_NORMAL),0,0,0, // positive_sign
          allocate(intArrayFromString(''), 'i8', ALLOC_NORMAL),0,0,0 // negative_sign
        ], 'i8*', ALLOC_NORMAL); // Allocate strings in lconv, still don't allocate chars
      }
      return me.ret;
    }


  function _unlink(path) {
      // int unlink(const char *path);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/unlink.html
      path = Pointer_stringify(path);
      try {
        FS.unlink(path);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }

  function _rmdir(path) {
      // int rmdir(const char *path);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/rmdir.html
      path = Pointer_stringify(path);
      try {
        FS.rmdir(path);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _remove(path) {
      // int remove(const char *path);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/remove.html
      var ret = _unlink(path);
      if (ret == -1) ret = _rmdir(path);
      return ret;
    }

  function _freopen(filename, mode, stream) {
      // FILE *freopen(const char *restrict filename, const char *restrict mode, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/freopen.html
      if (!filename) {
        var streamObj = FS.getStreamFromPtr(stream);
        if (!streamObj) {
          ___setErrNo(ERRNO_CODES.EBADF);
          return 0;
        }
        if (_freopen.buffer) _free(_freopen.buffer);
        filename = intArrayFromString(streamObj.path);
        filename = allocate(filename, 'i8', ALLOC_NORMAL);
      }
      _fclose(stream);
      return _fopen(filename, mode);
    }


  function _rename(old_path, new_path) {
      // int rename(const char *old, const char *new);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/rename.html
      old_path = Pointer_stringify(old_path);
      new_path = Pointer_stringify(new_path);
      try {
        FS.rename(old_path, new_path);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }

  function _tmpfile() {
      // FILE *tmpfile(void);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/tmpfile.html
      // TODO: Delete the created file on closing.
      if (_tmpfile.mode) {
        _tmpfile.mode = allocate(intArrayFromString('w+'), 'i8', ALLOC_NORMAL);
      }
      return _fopen(_tmpnam(0), _tmpfile.mode);
    }

  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 30: return PAGE_SIZE;
        case 132:
        case 133:
        case 12:
        case 137:
        case 138:
        case 15:
        case 235:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 149:
        case 13:
        case 10:
        case 236:
        case 153:
        case 9:
        case 21:
        case 22:
        case 159:
        case 154:
        case 14:
        case 77:
        case 78:
        case 139:
        case 80:
        case 81:
        case 79:
        case 82:
        case 68:
        case 67:
        case 164:
        case 11:
        case 29:
        case 47:
        case 48:
        case 95:
        case 52:
        case 51:
        case 46:
          return 200809;
        case 27:
        case 246:
        case 127:
        case 128:
        case 23:
        case 24:
        case 160:
        case 161:
        case 181:
        case 182:
        case 242:
        case 183:
        case 184:
        case 243:
        case 244:
        case 245:
        case 165:
        case 178:
        case 179:
        case 49:
        case 50:
        case 168:
        case 169:
        case 175:
        case 170:
        case 171:
        case 172:
        case 97:
        case 76:
        case 32:
        case 173:
        case 35:
          return -1;
        case 176:
        case 177:
        case 7:
        case 155:
        case 8:
        case 157:
        case 125:
        case 126:
        case 92:
        case 93:
        case 129:
        case 130:
        case 131:
        case 94:
        case 91:
          return 1;
        case 74:
        case 60:
        case 69:
        case 70:
        case 4:
          return 1024;
        case 31:
        case 42:
        case 72:
          return 32;
        case 87:
        case 26:
        case 33:
          return 2147483647;
        case 34:
        case 1:
          return 47839;
        case 38:
        case 36:
          return 99;
        case 43:
        case 37:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 28: return 32768;
        case 44: return 32767;
        case 75: return 16384;
        case 39: return 1000;
        case 89: return 700;
        case 71: return 256;
        case 40: return 255;
        case 2: return 100;
        case 180: return 64;
        case 25: return 20;
        case 5: return 16;
        case 6: return 6;
        case 73: return 4;
        case 84: return 1;
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }


  function ___errno_location() {
      return ___errno_state;
    }


  Module["_memset"] = _memset;



  Module["_bitshift64Shl"] = _bitshift64Shl;

  function _abort() {
      Module['abort']();
    }



  function __reallyNegative(x) {
      return x < 0 || (x === 0 && (1/x) === -Infinity);
    }function __formatString(format, varargs) {
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
          ret = HEAPF64[(((varargs)+(argIndex))>>3)];
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+4))>>2)]];

        } else {
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
        }
        argIndex += Runtime.getNativeFieldSize(type);
        return ret;
      }

      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[((textIndex+1)|0)];
        if (curr == 37) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          var flagPadSign = false;
          flagsLoop: while (1) {
            switch (next) {
              case 43:
                flagAlwaysSigned = true;
                break;
              case 45:
                flagLeftAlign = true;
                break;
              case 35:
                flagAlternative = true;
                break;
              case 48:
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              case 32:
                flagPadSign = true;
                break;
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          }

          // Handle width.
          var width = 0;
          if (next == 42) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          } else {
            while (next >= 48 && next <= 57) {
              width = width * 10 + (next - 48);
              textIndex++;
              next = HEAP8[((textIndex+1)|0)];
            }
          }

          // Handle precision.
          var precisionSet = false, precision = -1;
          if (next == 46) {
            precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
            if (next == 42) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[((textIndex+1)|0)];
                if (precisionChr < 48 ||
                    precisionChr > 57) break;
                precision = precision * 10 + (precisionChr - 48);
                textIndex++;
              }
            }
            next = HEAP8[((textIndex+1)|0)];
          }
          if (precision < 0) {
            precision = 6; // Standard default.
            precisionSet = false;
          }

          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 104) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 108) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[((textIndex+1)|0)];

          // Handle type specifier.
          switch (String.fromCharCode(next)) {
            case 'd': case 'i': case 'u': case 'o': case 'x': case 'X': case 'p': {
              // Integer.
              var signed = next == 100 || next == 105;
              argSize = argSize || 4;
              var currArg = getNextArg('i' + (argSize * 8));
              var origArg = currArg;
              var argText;
              // Flatten i64-1 [low, high] into a (slightly rounded) double
              if (argSize == 8) {
                currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
              }
              // Truncate to requested size.
              if (argSize <= 4) {
                var limit = Math.pow(256, argSize) - 1;
                currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
              }
              // Format the number.
              var currAbsArg = Math.abs(currArg);
              var prefix = '';
              if (next == 100 || next == 105) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else
                argText = reSign(currArg, 8 * argSize, 1).toString(10);
              } else if (next == 117) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else
                argText = unSign(currArg, 8 * argSize, 1).toString(10);
                currArg = Math.abs(currArg);
              } else if (next == 111) {
                argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
              } else if (next == 120 || next == 88) {
                prefix = (flagAlternative && currArg != 0) ? '0x' : '';
                if (argSize == 8 && i64Math) {
                  if (origArg[1]) {
                    argText = (origArg[1]>>>0).toString(16);
                    var lower = (origArg[0]>>>0).toString(16);
                    while (lower.length < 8) lower = '0' + lower;
                    argText += lower;
                  } else {
                    argText = (origArg[0]>>>0).toString(16);
                  }
                } else
                if (currArg < 0) {
                  // Represent negative numbers in hex as 2's complement.
                  currArg = -currArg;
                  argText = (currAbsArg - 1).toString(16);
                  var buffer = [];
                  for (var i = 0; i < argText.length; i++) {
                    buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                  }
                  argText = buffer.join('');
                  while (argText.length < argSize * 2) argText = 'f' + argText;
                } else {
                  argText = currAbsArg.toString(16);
                }
                if (next == 88) {
                  prefix = prefix.toUpperCase();
                  argText = argText.toUpperCase();
                }
              } else if (next == 112) {
                if (currAbsArg === 0) {
                  argText = '(nil)';
                } else {
                  prefix = '0x';
                  argText = currAbsArg.toString(16);
                }
              }
              if (precisionSet) {
                while (argText.length < precision) {
                  argText = '0' + argText;
                }
              }

              // Add sign if needed
              if (currArg >= 0) {
                if (flagAlwaysSigned) {
                  prefix = '+' + prefix;
                } else if (flagPadSign) {
                  prefix = ' ' + prefix;
                }
              }

              // Move sign to prefix so we zero-pad after the sign
              if (argText.charAt(0) == '-') {
                prefix = '-' + prefix;
                argText = argText.substr(1);
              }

              // Add padding.
              while (prefix.length + argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad) {
                    argText = '0' + argText;
                  } else {
                    prefix = ' ' + prefix;
                  }
                }
              }

              // Insert the result into the buffer.
              argText = prefix + argText;
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 'f': case 'F': case 'e': case 'E': case 'g': case 'G': {
              // Float.
              var currArg = getNextArg('double');
              var argText;
              if (isNaN(currArg)) {
                argText = 'nan';
                flagZeroPad = false;
              } else if (!isFinite(currArg)) {
                argText = (currArg < 0 ? '-' : '') + 'inf';
                flagZeroPad = false;
              } else {
                var isGeneral = false;
                var effectivePrecision = Math.min(precision, 20);

                // Convert g/G to f/F or e/E, as per:
                // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                if (next == 103 || next == 71) {
                  isGeneral = true;
                  precision = precision || 1;
                  var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                  if (precision > exponent && exponent >= -4) {
                    next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                    precision -= exponent + 1;
                  } else {
                    next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                    precision--;
                  }
                  effectivePrecision = Math.min(precision, 20);
                }

                if (next == 101 || next == 69) {
                  argText = currArg.toExponential(effectivePrecision);
                  // Make sure the exponent has at least 2 digits.
                  if (/[eE][-+]\d$/.test(argText)) {
                    argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                  }
                } else if (next == 102 || next == 70) {
                  argText = currArg.toFixed(effectivePrecision);
                  if (currArg === 0 && __reallyNegative(currArg)) {
                    argText = '-' + argText;
                  }
                }

                var parts = argText.split('e');
                if (isGeneral && !flagAlternative) {
                  // Discard trailing zeros and periods.
                  while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                         (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                    parts[0] = parts[0].slice(0, -1);
                  }
                } else {
                  // Make sure we have a period in alternative mode.
                  if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                  // Zero pad until required precision.
                  while (precision > effectivePrecision++) parts[0] += '0';
                }
                argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');

                // Capitalize 'E' if needed.
                if (next == 69) argText = argText.toUpperCase();

                // Add sign.
                if (currArg >= 0) {
                  if (flagAlwaysSigned) {
                    argText = '+' + argText;
                  } else if (flagPadSign) {
                    argText = ' ' + argText;
                  }
                }
              }

              // Add padding.
              while (argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                    argText = argText[0] + '0' + argText.slice(1);
                  } else {
                    argText = (flagZeroPad ? '0' : ' ') + argText;
                  }
                }
              }

              // Adjust case.
              if (next < 97) argText = argText.toUpperCase();

              // Insert the result into the buffer.
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 's': {
              // String.
              var arg = getNextArg('i8*');
              var argLength = arg ? _strlen(arg) : '(null)'.length;
              if (precisionSet) argLength = Math.min(argLength, precision);
              if (!flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              if (arg) {
                for (var i = 0; i < argLength; i++) {
                  ret.push(HEAPU8[((arg++)|0)]);
                }
              } else {
                ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
              }
              if (flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              break;
            }
            case 'c': {
              // Character.
              if (flagLeftAlign) ret.push(getNextArg('i8'));
              while (--width > 0) {
                ret.push(32);
              }
              if (!flagLeftAlign) ret.push(getNextArg('i8'));
              break;
            }
            case 'n': {
              // Write the length written so far to the next parameter.
              var ptr = getNextArg('i32*');
              HEAP32[((ptr)>>2)]=ret.length;
              break;
            }
            case '%': {
              // Literal percent sign.
              ret.push(curr);
              break;
            }
            default: {
              // Unknown specifiers remain untouched.
              for (var i = startTextIndex; i < textIndex + 2; i++) {
                ret.push(HEAP8[(i)]);
              }
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _fprintf(stream, format, varargs) {
      // int fprintf(FILE *restrict stream, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var stack = Runtime.stackSave();
      var ret = _fwrite(allocate(result, 'i8', ALLOC_STACK), 1, result.length, stream);
      Runtime.stackRestore(stack);
      return ret;
    }

  function _fgets(s, n, stream) {
      // char *fgets(char *restrict s, int n, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fgets.html
      var streamObj = FS.getStreamFromPtr(stream);
      if (!streamObj) return 0;
      if (streamObj.error || streamObj.eof) return 0;
      var byte_;
      for (var i = 0; i < n - 1 && byte_ != 10; i++) {
        byte_ = _fgetc(stream);
        if (byte_ == -1) {
          if (streamObj.error || (streamObj.eof && i == 0)) return 0;
          else if (streamObj.eof) break;
        }
        HEAP8[(((s)+(i))|0)]=byte_;
      }
      HEAP8[(((s)+(i))|0)]=0;
      return s;
    }

  var _tan=Math_tan;

  function _ispunct(chr) {
      return (chr >= 33 && chr <= 47) ||
             (chr >= 58 && chr <= 64) ||
             (chr >= 91 && chr <= 96) ||
             (chr >= 123 && chr <= 126);
    }

  function _feof(stream) {
      // int feof(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/feof.html
      stream = FS.getStreamFromPtr(stream);
      return Number(stream && stream.eof);
    }


  Module["_tolower"] = _tolower;

  var _asin=Math_asin;

  function _clearerr(stream) {
      // void clearerr(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/clearerr.html
      stream = FS.getStreamFromPtr(stream);
      if (!stream) {
        return;
      }
      stream.eof = false;
      stream.error = false;
    }

  var _fabs=Math_abs;

  function _clock() {
      if (_clock.start === undefined) _clock.start = Date.now();
      return Math.floor((Date.now() - _clock.start) * (1000000/1000));
    }


  var _getc=_fgetc;

  function _modf(x, intpart) {
      HEAPF64[((intpart)>>3)]=Math.floor(x);
      return x - HEAPF64[((intpart)>>3)];
    }

  var _sqrt=Math_sqrt;

  function _isxdigit(chr) {
      return (chr >= 48 && chr <= 57) ||
             (chr >= 97 && chr <= 102) ||
             (chr >= 65 && chr <= 70);
    }

  function _ftell(stream) {
      // long ftell(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ftell.html
      stream = FS.getStreamFromPtr(stream);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      if (FS.isChrdev(stream.node.mode)) {
        ___setErrNo(ERRNO_CODES.ESPIPE);
        return -1;
      } else {
        return stream.position;
      }
    }


  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      Module['exit'](status);
    }function _exit(status) {
      __exit(status);
    }


  function _snprintf(s, n, format, varargs) {
      // int snprintf(char *restrict s, size_t n, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var limit = (n === undefined) ? result.length
                                    : Math.min(result.length, Math.max(n - 1, 0));
      if (s < 0) {
        s = -s;
        var buf = _malloc(limit+1);
        HEAP32[((s)>>2)]=buf;
        s = buf;
      }
      for (var i = 0; i < limit; i++) {
        HEAP8[(((s)+(i))|0)]=result[i];
      }
      if (limit < n || (n === undefined)) HEAP8[(((s)+(i))|0)]=0;
      return result.length;
    }function _sprintf(s, format, varargs) {
      // int sprintf(char *restrict s, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      return _snprintf(s, undefined, format, varargs);
    }

  var _emscripten_get_longjmp_result=true;

  var _sin=Math_sin;


  function _fmod(x, y) {
      return x % y;
    }var _fmodl=_fmod;



  var _atan=Math_atan;

  function _ferror(stream) {
      // int ferror(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ferror.html
      stream = FS.getStreamFromPtr(stream);
      return Number(stream && stream.error);
    }

  function _time(ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret;
      }
      return ret;
    }

  function _copysign(a, b) {
      return __reallyNegative(a) === __reallyNegative(b) ? a : -a;
    }


  function _gmtime_r(time, tmPtr) {
      var date = new Date(HEAP32[((time)>>2)]*1000);
      HEAP32[((tmPtr)>>2)]=date.getUTCSeconds();
      HEAP32[(((tmPtr)+(4))>>2)]=date.getUTCMinutes();
      HEAP32[(((tmPtr)+(8))>>2)]=date.getUTCHours();
      HEAP32[(((tmPtr)+(12))>>2)]=date.getUTCDate();
      HEAP32[(((tmPtr)+(16))>>2)]=date.getUTCMonth();
      HEAP32[(((tmPtr)+(20))>>2)]=date.getUTCFullYear()-1900;
      HEAP32[(((tmPtr)+(24))>>2)]=date.getUTCDay();
      HEAP32[(((tmPtr)+(36))>>2)]=0;
      HEAP32[(((tmPtr)+(32))>>2)]=0;
      var start = new Date(date); // define date using UTC, start from Jan 01 00:00:00 UTC
      start.setUTCDate(1);
      start.setUTCMonth(0);
      start.setUTCHours(0);
      start.setUTCMinutes(0);
      start.setUTCSeconds(0);
      start.setUTCMilliseconds(0);
      var yday = Math.floor((date.getTime() - start.getTime()) / (1000 * 60 * 60 * 24));
      HEAP32[(((tmPtr)+(28))>>2)]=yday;
      HEAP32[(((tmPtr)+(40))>>2)]=___tm_timezone;

      return tmPtr;
    }function _gmtime(time) {
      return _gmtime_r(time, ___tm_current);
    }

  function _isgraph(chr) {
      return 0x20 < chr && chr < 0x7F;
    }



  function _strerror_r(errnum, strerrbuf, buflen) {
      if (errnum in ERRNO_MESSAGES) {
        if (ERRNO_MESSAGES[errnum].length > buflen - 1) {
          return ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          var msg = ERRNO_MESSAGES[errnum];
          writeAsciiToMemory(msg, strerrbuf);
          return 0;
        }
      } else {
        return ___setErrNo(ERRNO_CODES.EINVAL);
      }
    }function _strerror(errnum) {
      if (!_strerror.buffer) _strerror.buffer = _malloc(256);
      _strerror_r(errnum, _strerror.buffer, 256);
      return _strerror.buffer;
    }





  var _environ=allocate(1, "i32*", ALLOC_STATIC);var ___environ=_environ;function ___buildEnvironment(env) {
      // WARNING: Arbitrary limit!
      var MAX_ENV_VALUES = 64;
      var TOTAL_ENV_SIZE = 1024;

      // Statically allocate memory for the environment.
      var poolPtr;
      var envPtr;
      if (!___buildEnvironment.called) {
        ___buildEnvironment.called = true;
        // Set default values. Use string keys for Closure Compiler compatibility.
        ENV['USER'] = 'root';
        ENV['PATH'] = '/';
        ENV['PWD'] = '/';
        ENV['HOME'] = '/home/emscripten';
        ENV['LANG'] = 'en_US.UTF-8';
        ENV['_'] = './this.program';
        // Allocate memory.
        poolPtr = allocate(TOTAL_ENV_SIZE, 'i8', ALLOC_STATIC);
        envPtr = allocate(MAX_ENV_VALUES * 4,
                          'i8*', ALLOC_STATIC);
        HEAP32[((envPtr)>>2)]=poolPtr;
        HEAP32[((_environ)>>2)]=envPtr;
      } else {
        envPtr = HEAP32[((_environ)>>2)];
        poolPtr = HEAP32[((envPtr)>>2)];
      }

      // Collect key=value lines.
      var strings = [];
      var totalSize = 0;
      for (var key in env) {
        if (typeof env[key] === 'string') {
          var line = key + '=' + env[key];
          strings.push(line);
          totalSize += line.length;
        }
      }
      if (totalSize > TOTAL_ENV_SIZE) {
        throw new Error('Environment size exceeded TOTAL_ENV_SIZE!');
      }

      // Make new.
      var ptrSize = 4;
      for (var i = 0; i < strings.length; i++) {
        var line = strings[i];
        writeAsciiToMemory(line, poolPtr);
        HEAP32[(((envPtr)+(i * ptrSize))>>2)]=poolPtr;
        poolPtr += line.length + 1;
      }
      HEAP32[(((envPtr)+(strings.length * ptrSize))>>2)]=0;
    }var ENV={};function _getenv(name) {
      // char *getenv(const char *name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/getenv.html
      if (name === 0) return 0;
      name = Pointer_stringify(name);
      if (!ENV.hasOwnProperty(name)) return 0;

      if (_getenv.ret) _free(_getenv.ret);
      _getenv.ret = allocate(intArrayFromString(ENV[name]), 'i8', ALLOC_NORMAL);
      return _getenv.ret;
    }

  var _emscripten_setjmp=true;

  var _cos=Math_cos;

  function _isalnum(chr) {
      return (chr >= 48 && chr <= 57) ||
             (chr >= 97 && chr <= 122) ||
             (chr >= 65 && chr <= 90);
    }

  var _BItoD=true;

  function _difftime(time1, time0) {
      return time1 - time0;
    }

  var _floor=Math_floor;

  function _iscntrl(chr) {
      return (0 <= chr && chr <= 0x1F) || chr === 0x7F;
    }

  var _atan2=Math_atan2;

  function _setvbuf(stream, buf, type, size) {
      // int setvbuf(FILE *restrict stream, char *restrict buf, int type, size_t size);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/setvbuf.html
      // TODO: Implement custom buffering.
      return 0;
    }

  var _exp=Math_exp;

  var _copysignl=_copysign;

  function _islower(chr) {
      return chr >= 97 && chr <= 122;
    }

  var _acos=Math_acos;

  function _isupper(chr) {
      return chr >= 65 && chr <= 90;
    }


  function __isLeapYear(year) {
        return year%4 === 0 && (year%100 !== 0 || year%400 === 0);
    }

  function __arraySum(array, index) {
      var sum = 0;
      for (var i = 0; i <= index; sum += array[i++]);
      return sum;
    }


  var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];

  var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date, days) {
      var newDate = new Date(date.getTime());
      while(days > 0) {
        var leap = __isLeapYear(newDate.getFullYear());
        var currentMonth = newDate.getMonth();
        var daysInCurrentMonth = (leap ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR)[currentMonth];

        if (days > daysInCurrentMonth-newDate.getDate()) {
          // we spill over to next month
          days -= (daysInCurrentMonth-newDate.getDate()+1);
          newDate.setDate(1);
          if (currentMonth < 11) {
            newDate.setMonth(currentMonth+1)
          } else {
            newDate.setMonth(0);
            newDate.setFullYear(newDate.getFullYear()+1);
          }
        } else {
          // we stay in current month
          newDate.setDate(newDate.getDate()+days);
          return newDate;
        }
      }

      return newDate;
    }function _strftime(s, maxsize, format, tm) {
      // size_t strftime(char *restrict s, size_t maxsize, const char *restrict format, const struct tm *restrict timeptr);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/strftime.html

      var date = {
        tm_sec: HEAP32[((tm)>>2)],
        tm_min: HEAP32[(((tm)+(4))>>2)],
        tm_hour: HEAP32[(((tm)+(8))>>2)],
        tm_mday: HEAP32[(((tm)+(12))>>2)],
        tm_mon: HEAP32[(((tm)+(16))>>2)],
        tm_year: HEAP32[(((tm)+(20))>>2)],
        tm_wday: HEAP32[(((tm)+(24))>>2)],
        tm_yday: HEAP32[(((tm)+(28))>>2)],
        tm_isdst: HEAP32[(((tm)+(32))>>2)]
      };

      var pattern = Pointer_stringify(format);

      // expand format
      var EXPANSION_RULES_1 = {
        '%c': '%a %b %d %H:%M:%S %Y',     // Replaced by the locale's appropriate date and time representation - e.g., Mon Aug  3 14:02:01 2013
        '%D': '%m/%d/%y',                 // Equivalent to %m / %d / %y
        '%F': '%Y-%m-%d',                 // Equivalent to %Y - %m - %d
        '%h': '%b',                       // Equivalent to %b
        '%r': '%I:%M:%S %p',              // Replaced by the time in a.m. and p.m. notation
        '%R': '%H:%M',                    // Replaced by the time in 24-hour notation
        '%T': '%H:%M:%S',                 // Replaced by the time
        '%x': '%m/%d/%y',                 // Replaced by the locale's appropriate date representation
        '%X': '%H:%M:%S',                 // Replaced by the locale's appropriate date representation
      };
      for (var rule in EXPANSION_RULES_1) {
        pattern = pattern.replace(new RegExp(rule, 'g'), EXPANSION_RULES_1[rule]);
      }

      var WEEKDAYS = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
      var MONTHS = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

      function leadingSomething(value, digits, character) {
        var str = typeof value === 'number' ? value.toString() : (value || '');
        while (str.length < digits) {
          str = character[0]+str;
        }
        return str;
      };

      function leadingNulls(value, digits) {
        return leadingSomething(value, digits, '0');
      };

      function compareByDay(date1, date2) {
        function sgn(value) {
          return value < 0 ? -1 : (value > 0 ? 1 : 0);
        };

        var compare;
        if ((compare = sgn(date1.getFullYear()-date2.getFullYear())) === 0) {
          if ((compare = sgn(date1.getMonth()-date2.getMonth())) === 0) {
            compare = sgn(date1.getDate()-date2.getDate());
          }
        }
        return compare;
      };

      function getFirstWeekStartDate(janFourth) {
          switch (janFourth.getDay()) {
            case 0: // Sunday
              return new Date(janFourth.getFullYear()-1, 11, 29);
            case 1: // Monday
              return janFourth;
            case 2: // Tuesday
              return new Date(janFourth.getFullYear(), 0, 3);
            case 3: // Wednesday
              return new Date(janFourth.getFullYear(), 0, 2);
            case 4: // Thursday
              return new Date(janFourth.getFullYear(), 0, 1);
            case 5: // Friday
              return new Date(janFourth.getFullYear()-1, 11, 31);
            case 6: // Saturday
              return new Date(janFourth.getFullYear()-1, 11, 30);
          }
      };

      function getWeekBasedYear(date) {
          var thisDate = __addDays(new Date(date.tm_year+1900, 0, 1), date.tm_yday);

          var janFourthThisYear = new Date(thisDate.getFullYear(), 0, 4);
          var janFourthNextYear = new Date(thisDate.getFullYear()+1, 0, 4);

          var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
          var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);

          if (compareByDay(firstWeekStartThisYear, thisDate) <= 0) {
            // this date is after the start of the first week of this year
            if (compareByDay(firstWeekStartNextYear, thisDate) <= 0) {
              return thisDate.getFullYear()+1;
            } else {
              return thisDate.getFullYear();
            }
          } else {
            return thisDate.getFullYear()-1;
          }
      };

      var EXPANSION_RULES_2 = {
        '%a': function(date) {
          return WEEKDAYS[date.tm_wday].substring(0,3);
        },
        '%A': function(date) {
          return WEEKDAYS[date.tm_wday];
        },
        '%b': function(date) {
          return MONTHS[date.tm_mon].substring(0,3);
        },
        '%B': function(date) {
          return MONTHS[date.tm_mon];
        },
        '%C': function(date) {
          var year = date.tm_year+1900;
          return leadingNulls(Math.floor(year/100),2);
        },
        '%d': function(date) {
          return leadingNulls(date.tm_mday, 2);
        },
        '%e': function(date) {
          return leadingSomething(date.tm_mday, 2, ' ');
        },
        '%g': function(date) {
          // %g, %G, and %V give values according to the ISO 8601:2000 standard week-based year.
          // In this system, weeks begin on a Monday and week 1 of the year is the week that includes
          // January 4th, which is also the week that includes the first Thursday of the year, and
          // is also the first week that contains at least four days in the year.
          // If the first Monday of January is the 2nd, 3rd, or 4th, the preceding days are part of
          // the last week of the preceding year; thus, for Saturday 2nd January 1999,
          // %G is replaced by 1998 and %V is replaced by 53. If December 29th, 30th,
          // or 31st is a Monday, it and any following days are part of week 1 of the following year.
          // Thus, for Tuesday 30th December 1997, %G is replaced by 1998 and %V is replaced by 01.

          return getWeekBasedYear(date).toString().substring(2);
        },
        '%G': function(date) {
          return getWeekBasedYear(date);
        },
        '%H': function(date) {
          return leadingNulls(date.tm_hour, 2);
        },
        '%I': function(date) {
          return leadingNulls(date.tm_hour < 13 ? date.tm_hour : date.tm_hour-12, 2);
        },
        '%j': function(date) {
          // Day of the year (001-366)
          return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, date.tm_mon-1), 3);
        },
        '%m': function(date) {
          return leadingNulls(date.tm_mon+1, 2);
        },
        '%M': function(date) {
          return leadingNulls(date.tm_min, 2);
        },
        '%n': function() {
          return '\n';
        },
        '%p': function(date) {
          if (date.tm_hour > 0 && date.tm_hour < 13) {
            return 'AM';
          } else {
            return 'PM';
          }
        },
        '%S': function(date) {
          return leadingNulls(date.tm_sec, 2);
        },
        '%t': function() {
          return '\t';
        },
        '%u': function(date) {
          var day = new Date(date.tm_year+1900, date.tm_mon+1, date.tm_mday, 0, 0, 0, 0);
          return day.getDay() || 7;
        },
        '%U': function(date) {
          // Replaced by the week number of the year as a decimal number [00,53].
          // The first Sunday of January is the first day of week 1;
          // days in the new year before this are in week 0. [ tm_year, tm_wday, tm_yday]
          var janFirst = new Date(date.tm_year+1900, 0, 1);
          var firstSunday = janFirst.getDay() === 0 ? janFirst : __addDays(janFirst, 7-janFirst.getDay());
          var endDate = new Date(date.tm_year+1900, date.tm_mon, date.tm_mday);

          // is target date after the first Sunday?
          if (compareByDay(firstSunday, endDate) < 0) {
            // calculate difference in days between first Sunday and endDate
            var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth()-1)-31;
            var firstSundayUntilEndJanuary = 31-firstSunday.getDate();
            var days = firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();
            return leadingNulls(Math.ceil(days/7), 2);
          }

          return compareByDay(firstSunday, janFirst) === 0 ? '01': '00';
        },
        '%V': function(date) {
          // Replaced by the week number of the year (Monday as the first day of the week)
          // as a decimal number [01,53]. If the week containing 1 January has four
          // or more days in the new year, then it is considered week 1.
          // Otherwise, it is the last week of the previous year, and the next week is week 1.
          // Both January 4th and the first Thursday of January are always in week 1. [ tm_year, tm_wday, tm_yday]
          var janFourthThisYear = new Date(date.tm_year+1900, 0, 4);
          var janFourthNextYear = new Date(date.tm_year+1901, 0, 4);

          var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
          var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);

          var endDate = __addDays(new Date(date.tm_year+1900, 0, 1), date.tm_yday);

          if (compareByDay(endDate, firstWeekStartThisYear) < 0) {
            // if given date is before this years first week, then it belongs to the 53rd week of last year
            return '53';
          }

          if (compareByDay(firstWeekStartNextYear, endDate) <= 0) {
            // if given date is after next years first week, then it belongs to the 01th week of next year
            return '01';
          }

          // given date is in between CW 01..53 of this calendar year
          var daysDifference;
          if (firstWeekStartThisYear.getFullYear() < date.tm_year+1900) {
            // first CW of this year starts last year
            daysDifference = date.tm_yday+32-firstWeekStartThisYear.getDate()
          } else {
            // first CW of this year starts this year
            daysDifference = date.tm_yday+1-firstWeekStartThisYear.getDate();
          }
          return leadingNulls(Math.ceil(daysDifference/7), 2);
        },
        '%w': function(date) {
          var day = new Date(date.tm_year+1900, date.tm_mon+1, date.tm_mday, 0, 0, 0, 0);
          return day.getDay();
        },
        '%W': function(date) {
          // Replaced by the week number of the year as a decimal number [00,53].
          // The first Monday of January is the first day of week 1;
          // days in the new year before this are in week 0. [ tm_year, tm_wday, tm_yday]
          var janFirst = new Date(date.tm_year, 0, 1);
          var firstMonday = janFirst.getDay() === 1 ? janFirst : __addDays(janFirst, janFirst.getDay() === 0 ? 1 : 7-janFirst.getDay()+1);
          var endDate = new Date(date.tm_year+1900, date.tm_mon, date.tm_mday);

          // is target date after the first Monday?
          if (compareByDay(firstMonday, endDate) < 0) {
            var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth()-1)-31;
            var firstMondayUntilEndJanuary = 31-firstMonday.getDate();
            var days = firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();
            return leadingNulls(Math.ceil(days/7), 2);
          }
          return compareByDay(firstMonday, janFirst) === 0 ? '01': '00';
        },
        '%y': function(date) {
          // Replaced by the last two digits of the year as a decimal number [00,99]. [ tm_year]
          return (date.tm_year+1900).toString().substring(2);
        },
        '%Y': function(date) {
          // Replaced by the year as a decimal number (for example, 1997). [ tm_year]
          return date.tm_year+1900;
        },
        '%z': function(date) {
          // Replaced by the offset from UTC in the ISO 8601:2000 standard format ( +hhmm or -hhmm ),
          // or by no characters if no timezone is determinable.
          // For example, "-0430" means 4 hours 30 minutes behind UTC (west of Greenwich).
          // If tm_isdst is zero, the standard time offset is used.
          // If tm_isdst is greater than zero, the daylight savings time offset is used.
          // If tm_isdst is negative, no characters are returned.
          // FIXME: we cannot determine time zone (or can we?)
          return '';
        },
        '%Z': function(date) {
          // Replaced by the timezone name or abbreviation, or by no bytes if no timezone information exists. [ tm_isdst]
          // FIXME: we cannot determine time zone (or can we?)
          return '';
        },
        '%%': function() {
          return '%';
        }
      };
      for (var rule in EXPANSION_RULES_2) {
        if (pattern.indexOf(rule) >= 0) {
          pattern = pattern.replace(new RegExp(rule, 'g'), EXPANSION_RULES_2[rule](date));
        }
      }

      var bytes = intArrayFromString(pattern, false);
      if (bytes.length > maxsize) {
        return 0;
      }

      writeArrayToMemory(bytes, s);
      return bytes.length-1;
    }



FS.staticInit();__ATINIT__.unshift({ func: function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() } });__ATMAIN__.push({ func: function() { FS.ignorePermissions = false } });__ATEXIT__.push({ func: function() { FS.quit() } });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
___errno_state = Runtime.staticAlloc(4); HEAP32[((___errno_state)>>2)]=0;
__ATINIT__.unshift({ func: function() { TTY.init() } });__ATEXIT__.push({ func: function() { TTY.shutdown() } });TTY.utf8 = new Runtime.UTF8Processor();
if (ENVIRONMENT_IS_NODE) { var fs = require("fs"); NODEFS.staticInit(); }
__ATINIT__.push({ func: function() { SOCKFS.root = FS.mount(SOCKFS, {}, null); } });
_fputc.ret = allocate([0], "i8", ALLOC_STATIC);
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas) { Browser.requestFullScreen(lockPointer, resizeCanvas) };
  Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) { Browser.requestAnimationFrame(func) };
  Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) { Browser.setCanvasSize(width, height, noUpdates) };
  Module["pauseMainLoop"] = function Module_pauseMainLoop() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function Module_resumeMainLoop() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function Module_getUserMedia() { Browser.getUserMedia() }
_fgetc.ret = allocate([0], "i8", ALLOC_STATIC);
___buildEnvironment(ENV);
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);

staticSealed = true; // seal the static portion of memory

STACK_MAX = STACK_BASE + 5242880;

DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);

assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");

 var ctlz_i8 = allocate([8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_DYNAMIC);
 var cttz_i8 = allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0], "i8", ALLOC_DYNAMIC);

var Math_min = Math.min;
function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}

function asmPrintInt(x, y) {
  Module.print('int ' + x + ',' + y);// + ' ' + new Error().stack);
}
function asmPrintFloat(x, y) {
  Module.print('float ' + x + ',' + y);// + ' ' + new Error().stack);
}
// EMSCRIPTEN_START_ASM
var ModuleFunc;
var asm = (ModuleFunc = function(global, env, buffer) {
  'use asm';
  var HEAP8 = new global.Int8Array(buffer);
  var HEAP16 = new global.Int16Array(buffer);
  var HEAP32 = new global.Int32Array(buffer);
  var HEAPU8 = new global.Uint8Array(buffer);
  var HEAPU16 = new global.Uint16Array(buffer);
  var HEAPU32 = new global.Uint32Array(buffer);
  var HEAPF32 = new global.Float32Array(buffer);
  var HEAPF64 = new global.Float64Array(buffer);

  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  var cttz_i8=env.cttz_i8|0;
  var ctlz_i8=env.ctlz_i8|0;
  var ___rand_seed=env.___rand_seed|0;
  var _stderr=env._stderr|0;
  var _stdin=env._stdin|0;
  var _stdout=env._stdout|0;

  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var nan = +env.NaN, inf = +env.Infinity;
  var tempInt = 0, tempBigInt = 0, tempBigIntP = 0, tempBigIntS = 0, tempBigIntR = 0.0, tempBigIntI = 0, tempBigIntD = 0, tempValue = 0, tempDouble = 0.0;

  var tempRet0 = 0;
  var tempRet1 = 0;
  var tempRet2 = 0;
  var tempRet3 = 0;
  var tempRet4 = 0;
  var tempRet5 = 0;
  var tempRet6 = 0;
  var tempRet7 = 0;
  var tempRet8 = 0;
  var tempRet9 = 0;
  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var abort=env.abort;
  var assert=env.assert;
  var asmPrintInt=env.asmPrintInt;
  var asmPrintFloat=env.asmPrintFloat;
  var Math_min=env.min;
  var invoke_iiii=env.invoke_iiii;
  var invoke_vi=env.invoke_vi;
  var invoke_vii=env.invoke_vii;
  var invoke_ii=env.invoke_ii;
  var invoke_iiiii=env.invoke_iiiii;
  var invoke_iii=env.invoke_iii;
  var _isalnum=env._isalnum;
  var _fabs=env._fabs;
  var _frexp=env._frexp;
  var _exp=env._exp;
  var _fread=env._fread;
  var __reallyNegative=env.__reallyNegative;
  var _longjmp=env._longjmp;
  var __addDays=env.__addDays;
  var _fsync=env._fsync;
  var _signal=env._signal;
  var _rename=env._rename;
  var _sbrk=env._sbrk;
  var _emscripten_memcpy_big=env._emscripten_memcpy_big;
  var _sinh=env._sinh;
  var _sysconf=env._sysconf;
  var _close=env._close;
  var _ferror=env._ferror;
  var _clock=env._clock;
  var _cos=env._cos;
  var _tanh=env._tanh;
  var _unlink=env._unlink;
  var _write=env._write;
  var __isLeapYear=env.__isLeapYear;
  var _ftell=env._ftell;
  var _isupper=env._isupper;
  var _gmtime_r=env._gmtime_r;
  var _islower=env._islower;
  var _tmpnam=env._tmpnam;
  var _tmpfile=env._tmpfile;
  var _send=env._send;
  var _abort=env._abort;
  var _setvbuf=env._setvbuf;
  var _atan2=env._atan2;
  var _setlocale=env._setlocale;
  var _isgraph=env._isgraph;
  var _modf=env._modf;
  var _strerror_r=env._strerror_r;
  var _fscanf=env._fscanf;
  var ___setErrNo=env.___setErrNo;
  var _isalpha=env._isalpha;
  var _srand=env._srand;
  var _mktime=env._mktime;
  var _putchar=env._putchar;
  var _gmtime=env._gmtime;
  var _localeconv=env._localeconv;
  var _sprintf=env._sprintf;
  var _localtime=env._localtime;
  var _read=env._read;
  var _fwrite=env._fwrite;
  var _time=env._time;
  var _fprintf=env._fprintf;
  var _exit=env._exit;
  var _freopen=env._freopen;
  var _llvm_pow_f64=env._llvm_pow_f64;
  var _fgetc=env._fgetc;
  var _fmod=env._fmod;
  var _lseek=env._lseek;
  var _rmdir=env._rmdir;
  var _asin=env._asin;
  var _floor=env._floor;
  var _pwrite=env._pwrite;
  var _localtime_r=env._localtime_r;
  var _tzset=env._tzset;
  var _open=env._open;
  var _remove=env._remove;
  var _snprintf=env._snprintf;
  var __scanString=env.__scanString;
  var _strftime=env._strftime;
  var _fseek=env._fseek;
  var _iscntrl=env._iscntrl;
  var _isxdigit=env._isxdigit;
  var _fclose=env._fclose;
  var _log=env._log;
  var _recv=env._recv;
  var _tan=env._tan;
  var _copysign=env._copysign;
  var __getFloat=env.__getFloat;
  var _fputc=env._fputc;
  var _ispunct=env._ispunct;
  var _ceil=env._ceil;
  var _isspace=env._isspace;
  var _fopen=env._fopen;
  var _sin=env._sin;
  var _acos=env._acos;
  var _cosh=env._cosh;
  var ___buildEnvironment=env.___buildEnvironment;
  var _difftime=env._difftime;
  var _ungetc=env._ungetc;
  var _system=env._system;
  var _fflush=env._fflush;
  var _log10=env._log10;
  var _fileno=env._fileno;
  var __exit=env.__exit;
  var __arraySum=env.__arraySum;
  var _fgets=env._fgets;
  var _atan=env._atan;
  var _pread=env._pread;
  var _mkport=env._mkport;
  var _toupper=env._toupper;
  var _feof=env._feof;
  var ___errno_location=env.___errno_location;
  var _clearerr=env._clearerr;
  var _getenv=env._getenv;
  var _strerror=env._strerror;
  var _emscripten_longjmp=env._emscripten_longjmp;
  var __formatString=env.__formatString;
  var _fputs=env._fputs;
  var _sqrt=env._sqrt;
  var tempFloat = 0.0;

// EMSCRIPTEN_START_FUNCS
function _malloc(i12) {
 i12 = i12 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0;
 i1 = STACKTOP;
 do {
  if (i12 >>> 0 < 245) {
   if (i12 >>> 0 < 11) {
    i12 = 16;
   } else {
    i12 = i12 + 11 & -8;
   }
   i20 = i12 >>> 3;
   i18 = HEAP32[3228] | 0;
   i21 = i18 >>> i20;
   if ((i21 & 3 | 0) != 0) {
    i6 = (i21 & 1 ^ 1) + i20 | 0;
    i5 = i6 << 1;
    i3 = 12952 + (i5 << 2) | 0;
    i5 = 12952 + (i5 + 2 << 2) | 0;
    i7 = HEAP32[i5 >> 2] | 0;
    i2 = i7 + 8 | 0;
    i4 = HEAP32[i2 >> 2] | 0;
    do {
     if ((i3 | 0) != (i4 | 0)) {
      if (i4 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
       _abort();
      }
      i8 = i4 + 12 | 0;
      if ((HEAP32[i8 >> 2] | 0) == (i7 | 0)) {
       HEAP32[i8 >> 2] = i3;
       HEAP32[i5 >> 2] = i4;
       break;
      } else {
       _abort();
      }
     } else {
      HEAP32[3228] = i18 & ~(1 << i6);
     }
    } while (0);
    i32 = i6 << 3;
    HEAP32[i7 + 4 >> 2] = i32 | 3;
    i32 = i7 + (i32 | 4) | 0;
    HEAP32[i32 >> 2] = HEAP32[i32 >> 2] | 1;
    i32 = i2;
    STACKTOP = i1;
    return i32 | 0;
   }
   if (i12 >>> 0 > (HEAP32[12920 >> 2] | 0) >>> 0) {
    if ((i21 | 0) != 0) {
     i7 = 2 << i20;
     i7 = i21 << i20 & (i7 | 0 - i7);
     i7 = (i7 & 0 - i7) + -1 | 0;
     i2 = i7 >>> 12 & 16;
     i7 = i7 >>> i2;
     i6 = i7 >>> 5 & 8;
     i7 = i7 >>> i6;
     i5 = i7 >>> 2 & 4;
     i7 = i7 >>> i5;
     i4 = i7 >>> 1 & 2;
     i7 = i7 >>> i4;
     i3 = i7 >>> 1 & 1;
     i3 = (i6 | i2 | i5 | i4 | i3) + (i7 >>> i3) | 0;
     i7 = i3 << 1;
     i4 = 12952 + (i7 << 2) | 0;
     i7 = 12952 + (i7 + 2 << 2) | 0;
     i5 = HEAP32[i7 >> 2] | 0;
     i2 = i5 + 8 | 0;
     i6 = HEAP32[i2 >> 2] | 0;
     do {
      if ((i4 | 0) != (i6 | 0)) {
       if (i6 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
        _abort();
       }
       i8 = i6 + 12 | 0;
       if ((HEAP32[i8 >> 2] | 0) == (i5 | 0)) {
        HEAP32[i8 >> 2] = i4;
        HEAP32[i7 >> 2] = i6;
        break;
       } else {
        _abort();
       }
      } else {
       HEAP32[3228] = i18 & ~(1 << i3);
      }
     } while (0);
     i6 = i3 << 3;
     i4 = i6 - i12 | 0;
     HEAP32[i5 + 4 >> 2] = i12 | 3;
     i3 = i5 + i12 | 0;
     HEAP32[i5 + (i12 | 4) >> 2] = i4 | 1;
     HEAP32[i5 + i6 >> 2] = i4;
     i6 = HEAP32[12920 >> 2] | 0;
     if ((i6 | 0) != 0) {
      i5 = HEAP32[12932 >> 2] | 0;
      i8 = i6 >>> 3;
      i9 = i8 << 1;
      i6 = 12952 + (i9 << 2) | 0;
      i7 = HEAP32[3228] | 0;
      i8 = 1 << i8;
      if ((i7 & i8 | 0) != 0) {
       i7 = 12952 + (i9 + 2 << 2) | 0;
       i8 = HEAP32[i7 >> 2] | 0;
       if (i8 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
        _abort();
       } else {
        i28 = i7;
        i27 = i8;
       }
      } else {
       HEAP32[3228] = i7 | i8;
       i28 = 12952 + (i9 + 2 << 2) | 0;
       i27 = i6;
      }
      HEAP32[i28 >> 2] = i5;
      HEAP32[i27 + 12 >> 2] = i5;
      HEAP32[i5 + 8 >> 2] = i27;
      HEAP32[i5 + 12 >> 2] = i6;
     }
     HEAP32[12920 >> 2] = i4;
     HEAP32[12932 >> 2] = i3;
     i32 = i2;
     STACKTOP = i1;
     return i32 | 0;
    }
    i18 = HEAP32[12916 >> 2] | 0;
    if ((i18 | 0) != 0) {
     i2 = (i18 & 0 - i18) + -1 | 0;
     i31 = i2 >>> 12 & 16;
     i2 = i2 >>> i31;
     i30 = i2 >>> 5 & 8;
     i2 = i2 >>> i30;
     i32 = i2 >>> 2 & 4;
     i2 = i2 >>> i32;
     i6 = i2 >>> 1 & 2;
     i2 = i2 >>> i6;
     i3 = i2 >>> 1 & 1;
     i3 = HEAP32[13216 + ((i30 | i31 | i32 | i6 | i3) + (i2 >>> i3) << 2) >> 2] | 0;
     i2 = (HEAP32[i3 + 4 >> 2] & -8) - i12 | 0;
     i6 = i3;
     while (1) {
      i5 = HEAP32[i6 + 16 >> 2] | 0;
      if ((i5 | 0) == 0) {
       i5 = HEAP32[i6 + 20 >> 2] | 0;
       if ((i5 | 0) == 0) {
        break;
       }
      }
      i6 = (HEAP32[i5 + 4 >> 2] & -8) - i12 | 0;
      i4 = i6 >>> 0 < i2 >>> 0;
      i2 = i4 ? i6 : i2;
      i6 = i5;
      i3 = i4 ? i5 : i3;
     }
     i6 = HEAP32[12928 >> 2] | 0;
     if (i3 >>> 0 < i6 >>> 0) {
      _abort();
     }
     i4 = i3 + i12 | 0;
     if (!(i3 >>> 0 < i4 >>> 0)) {
      _abort();
     }
     i5 = HEAP32[i3 + 24 >> 2] | 0;
     i7 = HEAP32[i3 + 12 >> 2] | 0;
     do {
      if ((i7 | 0) == (i3 | 0)) {
       i8 = i3 + 20 | 0;
       i7 = HEAP32[i8 >> 2] | 0;
       if ((i7 | 0) == 0) {
        i8 = i3 + 16 | 0;
        i7 = HEAP32[i8 >> 2] | 0;
        if ((i7 | 0) == 0) {
         i26 = 0;
         break;
        }
       }
       while (1) {
        i10 = i7 + 20 | 0;
        i9 = HEAP32[i10 >> 2] | 0;
        if ((i9 | 0) != 0) {
         i7 = i9;
         i8 = i10;
         continue;
        }
        i10 = i7 + 16 | 0;
        i9 = HEAP32[i10 >> 2] | 0;
        if ((i9 | 0) == 0) {
         break;
        } else {
         i7 = i9;
         i8 = i10;
        }
       }
       if (i8 >>> 0 < i6 >>> 0) {
        _abort();
       } else {
        HEAP32[i8 >> 2] = 0;
        i26 = i7;
        break;
       }
      } else {
       i8 = HEAP32[i3 + 8 >> 2] | 0;
       if (i8 >>> 0 < i6 >>> 0) {
        _abort();
       }
       i6 = i8 + 12 | 0;
       if ((HEAP32[i6 >> 2] | 0) != (i3 | 0)) {
        _abort();
       }
       i9 = i7 + 8 | 0;
       if ((HEAP32[i9 >> 2] | 0) == (i3 | 0)) {
        HEAP32[i6 >> 2] = i7;
        HEAP32[i9 >> 2] = i8;
        i26 = i7;
        break;
       } else {
        _abort();
       }
      }
     } while (0);
     do {
      if ((i5 | 0) != 0) {
       i7 = HEAP32[i3 + 28 >> 2] | 0;
       i6 = 13216 + (i7 << 2) | 0;
       if ((i3 | 0) == (HEAP32[i6 >> 2] | 0)) {
        HEAP32[i6 >> 2] = i26;
        if ((i26 | 0) == 0) {
         HEAP32[12916 >> 2] = HEAP32[12916 >> 2] & ~(1 << i7);
         break;
        }
       } else {
        if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
         _abort();
        }
        i6 = i5 + 16 | 0;
        if ((HEAP32[i6 >> 2] | 0) == (i3 | 0)) {
         HEAP32[i6 >> 2] = i26;
        } else {
         HEAP32[i5 + 20 >> 2] = i26;
        }
        if ((i26 | 0) == 0) {
         break;
        }
       }
       if (i26 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
        _abort();
       }
       HEAP32[i26 + 24 >> 2] = i5;
       i5 = HEAP32[i3 + 16 >> 2] | 0;
       do {
        if ((i5 | 0) != 0) {
         if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
          _abort();
         } else {
          HEAP32[i26 + 16 >> 2] = i5;
          HEAP32[i5 + 24 >> 2] = i26;
          break;
         }
        }
       } while (0);
       i5 = HEAP32[i3 + 20 >> 2] | 0;
       if ((i5 | 0) != 0) {
        if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
         _abort();
        } else {
         HEAP32[i26 + 20 >> 2] = i5;
         HEAP32[i5 + 24 >> 2] = i26;
         break;
        }
       }
      }
     } while (0);
     if (i2 >>> 0 < 16) {
      i32 = i2 + i12 | 0;
      HEAP32[i3 + 4 >> 2] = i32 | 3;
      i32 = i3 + (i32 + 4) | 0;
      HEAP32[i32 >> 2] = HEAP32[i32 >> 2] | 1;
     } else {
      HEAP32[i3 + 4 >> 2] = i12 | 3;
      HEAP32[i3 + (i12 | 4) >> 2] = i2 | 1;
      HEAP32[i3 + (i2 + i12) >> 2] = i2;
      i6 = HEAP32[12920 >> 2] | 0;
      if ((i6 | 0) != 0) {
       i5 = HEAP32[12932 >> 2] | 0;
       i8 = i6 >>> 3;
       i9 = i8 << 1;
       i6 = 12952 + (i9 << 2) | 0;
       i7 = HEAP32[3228] | 0;
       i8 = 1 << i8;
       if ((i7 & i8 | 0) != 0) {
        i7 = 12952 + (i9 + 2 << 2) | 0;
        i8 = HEAP32[i7 >> 2] | 0;
        if (i8 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
         _abort();
        } else {
         i25 = i7;
         i24 = i8;
        }
       } else {
        HEAP32[3228] = i7 | i8;
        i25 = 12952 + (i9 + 2 << 2) | 0;
        i24 = i6;
       }
       HEAP32[i25 >> 2] = i5;
       HEAP32[i24 + 12 >> 2] = i5;
       HEAP32[i5 + 8 >> 2] = i24;
       HEAP32[i5 + 12 >> 2] = i6;
      }
      HEAP32[12920 >> 2] = i2;
      HEAP32[12932 >> 2] = i4;
     }
     i32 = i3 + 8 | 0;
     STACKTOP = i1;
     return i32 | 0;
    }
   }
  } else {
   if (!(i12 >>> 0 > 4294967231)) {
    i24 = i12 + 11 | 0;
    i12 = i24 & -8;
    i26 = HEAP32[12916 >> 2] | 0;
    if ((i26 | 0) != 0) {
     i25 = 0 - i12 | 0;
     i24 = i24 >>> 8;
     if ((i24 | 0) != 0) {
      if (i12 >>> 0 > 16777215) {
       i27 = 31;
      } else {
       i31 = (i24 + 1048320 | 0) >>> 16 & 8;
       i32 = i24 << i31;
       i30 = (i32 + 520192 | 0) >>> 16 & 4;
       i32 = i32 << i30;
       i27 = (i32 + 245760 | 0) >>> 16 & 2;
       i27 = 14 - (i30 | i31 | i27) + (i32 << i27 >>> 15) | 0;
       i27 = i12 >>> (i27 + 7 | 0) & 1 | i27 << 1;
      }
     } else {
      i27 = 0;
     }
     i30 = HEAP32[13216 + (i27 << 2) >> 2] | 0;
     L126 : do {
      if ((i30 | 0) == 0) {
       i29 = 0;
       i24 = 0;
      } else {
       if ((i27 | 0) == 31) {
        i24 = 0;
       } else {
        i24 = 25 - (i27 >>> 1) | 0;
       }
       i29 = 0;
       i28 = i12 << i24;
       i24 = 0;
       while (1) {
        i32 = HEAP32[i30 + 4 >> 2] & -8;
        i31 = i32 - i12 | 0;
        if (i31 >>> 0 < i25 >>> 0) {
         if ((i32 | 0) == (i12 | 0)) {
          i25 = i31;
          i29 = i30;
          i24 = i30;
          break L126;
         } else {
          i25 = i31;
          i24 = i30;
         }
        }
        i31 = HEAP32[i30 + 20 >> 2] | 0;
        i30 = HEAP32[i30 + (i28 >>> 31 << 2) + 16 >> 2] | 0;
        i29 = (i31 | 0) == 0 | (i31 | 0) == (i30 | 0) ? i29 : i31;
        if ((i30 | 0) == 0) {
         break;
        } else {
         i28 = i28 << 1;
        }
       }
      }
     } while (0);
     if ((i29 | 0) == 0 & (i24 | 0) == 0) {
      i32 = 2 << i27;
      i26 = i26 & (i32 | 0 - i32);
      if ((i26 | 0) == 0) {
       break;
      }
      i32 = (i26 & 0 - i26) + -1 | 0;
      i28 = i32 >>> 12 & 16;
      i32 = i32 >>> i28;
      i27 = i32 >>> 5 & 8;
      i32 = i32 >>> i27;
      i30 = i32 >>> 2 & 4;
      i32 = i32 >>> i30;
      i31 = i32 >>> 1 & 2;
      i32 = i32 >>> i31;
      i29 = i32 >>> 1 & 1;
      i29 = HEAP32[13216 + ((i27 | i28 | i30 | i31 | i29) + (i32 >>> i29) << 2) >> 2] | 0;
     }
     if ((i29 | 0) != 0) {
      while (1) {
       i27 = (HEAP32[i29 + 4 >> 2] & -8) - i12 | 0;
       i26 = i27 >>> 0 < i25 >>> 0;
       i25 = i26 ? i27 : i25;
       i24 = i26 ? i29 : i24;
       i26 = HEAP32[i29 + 16 >> 2] | 0;
       if ((i26 | 0) != 0) {
        i29 = i26;
        continue;
       }
       i29 = HEAP32[i29 + 20 >> 2] | 0;
       if ((i29 | 0) == 0) {
        break;
       }
      }
     }
     if ((i24 | 0) != 0 ? i25 >>> 0 < ((HEAP32[12920 >> 2] | 0) - i12 | 0) >>> 0 : 0) {
      i4 = HEAP32[12928 >> 2] | 0;
      if (i24 >>> 0 < i4 >>> 0) {
       _abort();
      }
      i2 = i24 + i12 | 0;
      if (!(i24 >>> 0 < i2 >>> 0)) {
       _abort();
      }
      i3 = HEAP32[i24 + 24 >> 2] | 0;
      i6 = HEAP32[i24 + 12 >> 2] | 0;
      do {
       if ((i6 | 0) == (i24 | 0)) {
        i6 = i24 + 20 | 0;
        i5 = HEAP32[i6 >> 2] | 0;
        if ((i5 | 0) == 0) {
         i6 = i24 + 16 | 0;
         i5 = HEAP32[i6 >> 2] | 0;
         if ((i5 | 0) == 0) {
          i22 = 0;
          break;
         }
        }
        while (1) {
         i8 = i5 + 20 | 0;
         i7 = HEAP32[i8 >> 2] | 0;
         if ((i7 | 0) != 0) {
          i5 = i7;
          i6 = i8;
          continue;
         }
         i7 = i5 + 16 | 0;
         i8 = HEAP32[i7 >> 2] | 0;
         if ((i8 | 0) == 0) {
          break;
         } else {
          i5 = i8;
          i6 = i7;
         }
        }
        if (i6 >>> 0 < i4 >>> 0) {
         _abort();
        } else {
         HEAP32[i6 >> 2] = 0;
         i22 = i5;
         break;
        }
       } else {
        i5 = HEAP32[i24 + 8 >> 2] | 0;
        if (i5 >>> 0 < i4 >>> 0) {
         _abort();
        }
        i7 = i5 + 12 | 0;
        if ((HEAP32[i7 >> 2] | 0) != (i24 | 0)) {
         _abort();
        }
        i4 = i6 + 8 | 0;
        if ((HEAP32[i4 >> 2] | 0) == (i24 | 0)) {
         HEAP32[i7 >> 2] = i6;
         HEAP32[i4 >> 2] = i5;
         i22 = i6;
         break;
        } else {
         _abort();
        }
       }
      } while (0);
      do {
       if ((i3 | 0) != 0) {
        i4 = HEAP32[i24 + 28 >> 2] | 0;
        i5 = 13216 + (i4 << 2) | 0;
        if ((i24 | 0) == (HEAP32[i5 >> 2] | 0)) {
         HEAP32[i5 >> 2] = i22;
         if ((i22 | 0) == 0) {
          HEAP32[12916 >> 2] = HEAP32[12916 >> 2] & ~(1 << i4);
          break;
         }
        } else {
         if (i3 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
          _abort();
         }
         i4 = i3 + 16 | 0;
         if ((HEAP32[i4 >> 2] | 0) == (i24 | 0)) {
          HEAP32[i4 >> 2] = i22;
         } else {
          HEAP32[i3 + 20 >> 2] = i22;
         }
         if ((i22 | 0) == 0) {
          break;
         }
        }
        if (i22 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
         _abort();
        }
        HEAP32[i22 + 24 >> 2] = i3;
        i3 = HEAP32[i24 + 16 >> 2] | 0;
        do {
         if ((i3 | 0) != 0) {
          if (i3 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
           _abort();
          } else {
           HEAP32[i22 + 16 >> 2] = i3;
           HEAP32[i3 + 24 >> 2] = i22;
           break;
          }
         }
        } while (0);
        i3 = HEAP32[i24 + 20 >> 2] | 0;
        if ((i3 | 0) != 0) {
         if (i3 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
          _abort();
         } else {
          HEAP32[i22 + 20 >> 2] = i3;
          HEAP32[i3 + 24 >> 2] = i22;
          break;
         }
        }
       }
      } while (0);
      L204 : do {
       if (!(i25 >>> 0 < 16)) {
        HEAP32[i24 + 4 >> 2] = i12 | 3;
        HEAP32[i24 + (i12 | 4) >> 2] = i25 | 1;
        HEAP32[i24 + (i25 + i12) >> 2] = i25;
        i4 = i25 >>> 3;
        if (i25 >>> 0 < 256) {
         i6 = i4 << 1;
         i3 = 12952 + (i6 << 2) | 0;
         i5 = HEAP32[3228] | 0;
         i4 = 1 << i4;
         if ((i5 & i4 | 0) != 0) {
          i5 = 12952 + (i6 + 2 << 2) | 0;
          i4 = HEAP32[i5 >> 2] | 0;
          if (i4 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
           _abort();
          } else {
           i21 = i5;
           i20 = i4;
          }
         } else {
          HEAP32[3228] = i5 | i4;
          i21 = 12952 + (i6 + 2 << 2) | 0;
          i20 = i3;
         }
         HEAP32[i21 >> 2] = i2;
         HEAP32[i20 + 12 >> 2] = i2;
         HEAP32[i24 + (i12 + 8) >> 2] = i20;
         HEAP32[i24 + (i12 + 12) >> 2] = i3;
         break;
        }
        i3 = i25 >>> 8;
        if ((i3 | 0) != 0) {
         if (i25 >>> 0 > 16777215) {
          i3 = 31;
         } else {
          i31 = (i3 + 1048320 | 0) >>> 16 & 8;
          i32 = i3 << i31;
          i30 = (i32 + 520192 | 0) >>> 16 & 4;
          i32 = i32 << i30;
          i3 = (i32 + 245760 | 0) >>> 16 & 2;
          i3 = 14 - (i30 | i31 | i3) + (i32 << i3 >>> 15) | 0;
          i3 = i25 >>> (i3 + 7 | 0) & 1 | i3 << 1;
         }
        } else {
         i3 = 0;
        }
        i6 = 13216 + (i3 << 2) | 0;
        HEAP32[i24 + (i12 + 28) >> 2] = i3;
        HEAP32[i24 + (i12 + 20) >> 2] = 0;
        HEAP32[i24 + (i12 + 16) >> 2] = 0;
        i4 = HEAP32[12916 >> 2] | 0;
        i5 = 1 << i3;
        if ((i4 & i5 | 0) == 0) {
         HEAP32[12916 >> 2] = i4 | i5;
         HEAP32[i6 >> 2] = i2;
         HEAP32[i24 + (i12 + 24) >> 2] = i6;
         HEAP32[i24 + (i12 + 12) >> 2] = i2;
         HEAP32[i24 + (i12 + 8) >> 2] = i2;
         break;
        }
        i4 = HEAP32[i6 >> 2] | 0;
        if ((i3 | 0) == 31) {
         i3 = 0;
        } else {
         i3 = 25 - (i3 >>> 1) | 0;
        }
        L225 : do {
         if ((HEAP32[i4 + 4 >> 2] & -8 | 0) != (i25 | 0)) {
          i3 = i25 << i3;
          while (1) {
           i6 = i4 + (i3 >>> 31 << 2) + 16 | 0;
           i5 = HEAP32[i6 >> 2] | 0;
           if ((i5 | 0) == 0) {
            break;
           }
           if ((HEAP32[i5 + 4 >> 2] & -8 | 0) == (i25 | 0)) {
            i18 = i5;
            break L225;
           } else {
            i3 = i3 << 1;
            i4 = i5;
           }
          }
          if (i6 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
           _abort();
          } else {
           HEAP32[i6 >> 2] = i2;
           HEAP32[i24 + (i12 + 24) >> 2] = i4;
           HEAP32[i24 + (i12 + 12) >> 2] = i2;
           HEAP32[i24 + (i12 + 8) >> 2] = i2;
           break L204;
          }
         } else {
          i18 = i4;
         }
        } while (0);
        i4 = i18 + 8 | 0;
        i3 = HEAP32[i4 >> 2] | 0;
        i5 = HEAP32[12928 >> 2] | 0;
        if (i18 >>> 0 < i5 >>> 0) {
         _abort();
        }
        if (i3 >>> 0 < i5 >>> 0) {
         _abort();
        } else {
         HEAP32[i3 + 12 >> 2] = i2;
         HEAP32[i4 >> 2] = i2;
         HEAP32[i24 + (i12 + 8) >> 2] = i3;
         HEAP32[i24 + (i12 + 12) >> 2] = i18;
         HEAP32[i24 + (i12 + 24) >> 2] = 0;
         break;
        }
       } else {
        i32 = i25 + i12 | 0;
        HEAP32[i24 + 4 >> 2] = i32 | 3;
        i32 = i24 + (i32 + 4) | 0;
        HEAP32[i32 >> 2] = HEAP32[i32 >> 2] | 1;
       }
      } while (0);
      i32 = i24 + 8 | 0;
      STACKTOP = i1;
      return i32 | 0;
     }
    }
   } else {
    i12 = -1;
   }
  }
 } while (0);
 i18 = HEAP32[12920 >> 2] | 0;
 if (!(i12 >>> 0 > i18 >>> 0)) {
  i3 = i18 - i12 | 0;
  i2 = HEAP32[12932 >> 2] | 0;
  if (i3 >>> 0 > 15) {
   HEAP32[12932 >> 2] = i2 + i12;
   HEAP32[12920 >> 2] = i3;
   HEAP32[i2 + (i12 + 4) >> 2] = i3 | 1;
   HEAP32[i2 + i18 >> 2] = i3;
   HEAP32[i2 + 4 >> 2] = i12 | 3;
  } else {
   HEAP32[12920 >> 2] = 0;
   HEAP32[12932 >> 2] = 0;
   HEAP32[i2 + 4 >> 2] = i18 | 3;
   i32 = i2 + (i18 + 4) | 0;
   HEAP32[i32 >> 2] = HEAP32[i32 >> 2] | 1;
  }
  i32 = i2 + 8 | 0;
  STACKTOP = i1;
  return i32 | 0;
 }
 i18 = HEAP32[12924 >> 2] | 0;
 if (i12 >>> 0 < i18 >>> 0) {
  i31 = i18 - i12 | 0;
  HEAP32[12924 >> 2] = i31;
  i32 = HEAP32[12936 >> 2] | 0;
  HEAP32[12936 >> 2] = i32 + i12;
  HEAP32[i32 + (i12 + 4) >> 2] = i31 | 1;
  HEAP32[i32 + 4 >> 2] = i12 | 3;
  i32 = i32 + 8 | 0;
  STACKTOP = i1;
  return i32 | 0;
 }
 do {
  if ((HEAP32[3346] | 0) == 0) {
   i18 = _sysconf(30) | 0;
   if ((i18 + -1 & i18 | 0) == 0) {
    HEAP32[13392 >> 2] = i18;
    HEAP32[13388 >> 2] = i18;
    HEAP32[13396 >> 2] = -1;
    HEAP32[13400 >> 2] = -1;
    HEAP32[13404 >> 2] = 0;
    HEAP32[13356 >> 2] = 0;
    HEAP32[3346] = (_time(0) | 0) & -16 ^ 1431655768;
    break;
   } else {
    _abort();
   }
  }
 } while (0);
 i20 = i12 + 48 | 0;
 i25 = HEAP32[13392 >> 2] | 0;
 i21 = i12 + 47 | 0;
 i22 = i25 + i21 | 0;
 i25 = 0 - i25 | 0;
 i18 = i22 & i25;
 if (!(i18 >>> 0 > i12 >>> 0)) {
  i32 = 0;
  STACKTOP = i1;
  return i32 | 0;
 }
 i24 = HEAP32[13352 >> 2] | 0;
 if ((i24 | 0) != 0 ? (i31 = HEAP32[13344 >> 2] | 0, i32 = i31 + i18 | 0, i32 >>> 0 <= i31 >>> 0 | i32 >>> 0 > i24 >>> 0) : 0) {
  i32 = 0;
  STACKTOP = i1;
  return i32 | 0;
 }
 L269 : do {
  if ((HEAP32[13356 >> 2] & 4 | 0) == 0) {
   i26 = HEAP32[12936 >> 2] | 0;
   L271 : do {
    if ((i26 | 0) != 0) {
     i24 = 13360 | 0;
     while (1) {
      i27 = HEAP32[i24 >> 2] | 0;
      if (!(i27 >>> 0 > i26 >>> 0) ? (i23 = i24 + 4 | 0, (i27 + (HEAP32[i23 >> 2] | 0) | 0) >>> 0 > i26 >>> 0) : 0) {
       break;
      }
      i24 = HEAP32[i24 + 8 >> 2] | 0;
      if ((i24 | 0) == 0) {
       i13 = 182;
       break L271;
      }
     }
     if ((i24 | 0) != 0) {
      i25 = i22 - (HEAP32[12924 >> 2] | 0) & i25;
      if (i25 >>> 0 < 2147483647) {
       i13 = _sbrk(i25 | 0) | 0;
       i26 = (i13 | 0) == ((HEAP32[i24 >> 2] | 0) + (HEAP32[i23 >> 2] | 0) | 0);
       i22 = i13;
       i24 = i25;
       i23 = i26 ? i13 : -1;
       i25 = i26 ? i25 : 0;
       i13 = 191;
      } else {
       i25 = 0;
      }
     } else {
      i13 = 182;
     }
    } else {
     i13 = 182;
    }
   } while (0);
   do {
    if ((i13 | 0) == 182) {
     i23 = _sbrk(0) | 0;
     if ((i23 | 0) != (-1 | 0)) {
      i24 = i23;
      i22 = HEAP32[13388 >> 2] | 0;
      i25 = i22 + -1 | 0;
      if ((i25 & i24 | 0) == 0) {
       i25 = i18;
      } else {
       i25 = i18 - i24 + (i25 + i24 & 0 - i22) | 0;
      }
      i24 = HEAP32[13344 >> 2] | 0;
      i26 = i24 + i25 | 0;
      if (i25 >>> 0 > i12 >>> 0 & i25 >>> 0 < 2147483647) {
       i22 = HEAP32[13352 >> 2] | 0;
       if ((i22 | 0) != 0 ? i26 >>> 0 <= i24 >>> 0 | i26 >>> 0 > i22 >>> 0 : 0) {
        i25 = 0;
        break;
       }
       i22 = _sbrk(i25 | 0) | 0;
       i13 = (i22 | 0) == (i23 | 0);
       i24 = i25;
       i23 = i13 ? i23 : -1;
       i25 = i13 ? i25 : 0;
       i13 = 191;
      } else {
       i25 = 0;
      }
     } else {
      i25 = 0;
     }
    }
   } while (0);
   L291 : do {
    if ((i13 | 0) == 191) {
     i13 = 0 - i24 | 0;
     if ((i23 | 0) != (-1 | 0)) {
      i17 = i23;
      i14 = i25;
      i13 = 202;
      break L269;
     }
     do {
      if ((i22 | 0) != (-1 | 0) & i24 >>> 0 < 2147483647 & i24 >>> 0 < i20 >>> 0 ? (i19 = HEAP32[13392 >> 2] | 0, i19 = i21 - i24 + i19 & 0 - i19, i19 >>> 0 < 2147483647) : 0) {
       if ((_sbrk(i19 | 0) | 0) == (-1 | 0)) {
        _sbrk(i13 | 0) | 0;
        break L291;
       } else {
        i24 = i19 + i24 | 0;
        break;
       }
      }
     } while (0);
     if ((i22 | 0) != (-1 | 0)) {
      i17 = i22;
      i14 = i24;
      i13 = 202;
      break L269;
     }
    }
   } while (0);
   HEAP32[13356 >> 2] = HEAP32[13356 >> 2] | 4;
   i13 = 199;
  } else {
   i25 = 0;
   i13 = 199;
  }
 } while (0);
 if ((((i13 | 0) == 199 ? i18 >>> 0 < 2147483647 : 0) ? (i17 = _sbrk(i18 | 0) | 0, i16 = _sbrk(0) | 0, (i16 | 0) != (-1 | 0) & (i17 | 0) != (-1 | 0) & i17 >>> 0 < i16 >>> 0) : 0) ? (i15 = i16 - i17 | 0, i14 = i15 >>> 0 > (i12 + 40 | 0) >>> 0, i14) : 0) {
  i14 = i14 ? i15 : i25;
  i13 = 202;
 }
 if ((i13 | 0) == 202) {
  i15 = (HEAP32[13344 >> 2] | 0) + i14 | 0;
  HEAP32[13344 >> 2] = i15;
  if (i15 >>> 0 > (HEAP32[13348 >> 2] | 0) >>> 0) {
   HEAP32[13348 >> 2] = i15;
  }
  i15 = HEAP32[12936 >> 2] | 0;
  L311 : do {
   if ((i15 | 0) != 0) {
    i21 = 13360 | 0;
    while (1) {
     i16 = HEAP32[i21 >> 2] | 0;
     i19 = i21 + 4 | 0;
     i20 = HEAP32[i19 >> 2] | 0;
     if ((i17 | 0) == (i16 + i20 | 0)) {
      i13 = 214;
      break;
     }
     i18 = HEAP32[i21 + 8 >> 2] | 0;
     if ((i18 | 0) == 0) {
      break;
     } else {
      i21 = i18;
     }
    }
    if (((i13 | 0) == 214 ? (HEAP32[i21 + 12 >> 2] & 8 | 0) == 0 : 0) ? i15 >>> 0 >= i16 >>> 0 & i15 >>> 0 < i17 >>> 0 : 0) {
     HEAP32[i19 >> 2] = i20 + i14;
     i2 = (HEAP32[12924 >> 2] | 0) + i14 | 0;
     i3 = i15 + 8 | 0;
     if ((i3 & 7 | 0) == 0) {
      i3 = 0;
     } else {
      i3 = 0 - i3 & 7;
     }
     i32 = i2 - i3 | 0;
     HEAP32[12936 >> 2] = i15 + i3;
     HEAP32[12924 >> 2] = i32;
     HEAP32[i15 + (i3 + 4) >> 2] = i32 | 1;
     HEAP32[i15 + (i2 + 4) >> 2] = 40;
     HEAP32[12940 >> 2] = HEAP32[13400 >> 2];
     break;
    }
    if (i17 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
     HEAP32[12928 >> 2] = i17;
    }
    i19 = i17 + i14 | 0;
    i16 = 13360 | 0;
    while (1) {
     if ((HEAP32[i16 >> 2] | 0) == (i19 | 0)) {
      i13 = 224;
      break;
     }
     i18 = HEAP32[i16 + 8 >> 2] | 0;
     if ((i18 | 0) == 0) {
      break;
     } else {
      i16 = i18;
     }
    }
    if ((i13 | 0) == 224 ? (HEAP32[i16 + 12 >> 2] & 8 | 0) == 0 : 0) {
     HEAP32[i16 >> 2] = i17;
     i6 = i16 + 4 | 0;
     HEAP32[i6 >> 2] = (HEAP32[i6 >> 2] | 0) + i14;
     i6 = i17 + 8 | 0;
     if ((i6 & 7 | 0) == 0) {
      i6 = 0;
     } else {
      i6 = 0 - i6 & 7;
     }
     i7 = i17 + (i14 + 8) | 0;
     if ((i7 & 7 | 0) == 0) {
      i13 = 0;
     } else {
      i13 = 0 - i7 & 7;
     }
     i15 = i17 + (i13 + i14) | 0;
     i8 = i6 + i12 | 0;
     i7 = i17 + i8 | 0;
     i10 = i15 - (i17 + i6) - i12 | 0;
     HEAP32[i17 + (i6 + 4) >> 2] = i12 | 3;
     L348 : do {
      if ((i15 | 0) != (HEAP32[12936 >> 2] | 0)) {
       if ((i15 | 0) == (HEAP32[12932 >> 2] | 0)) {
        i32 = (HEAP32[12920 >> 2] | 0) + i10 | 0;
        HEAP32[12920 >> 2] = i32;
        HEAP32[12932 >> 2] = i7;
        HEAP32[i17 + (i8 + 4) >> 2] = i32 | 1;
        HEAP32[i17 + (i32 + i8) >> 2] = i32;
        break;
       }
       i12 = i14 + 4 | 0;
       i18 = HEAP32[i17 + (i12 + i13) >> 2] | 0;
       if ((i18 & 3 | 0) == 1) {
        i11 = i18 & -8;
        i16 = i18 >>> 3;
        do {
         if (!(i18 >>> 0 < 256)) {
          i9 = HEAP32[i17 + ((i13 | 24) + i14) >> 2] | 0;
          i19 = HEAP32[i17 + (i14 + 12 + i13) >> 2] | 0;
          do {
           if ((i19 | 0) == (i15 | 0)) {
            i19 = i13 | 16;
            i18 = i17 + (i12 + i19) | 0;
            i16 = HEAP32[i18 >> 2] | 0;
            if ((i16 | 0) == 0) {
             i18 = i17 + (i19 + i14) | 0;
             i16 = HEAP32[i18 >> 2] | 0;
             if ((i16 | 0) == 0) {
              i5 = 0;
              break;
             }
            }
            while (1) {
             i20 = i16 + 20 | 0;
             i19 = HEAP32[i20 >> 2] | 0;
             if ((i19 | 0) != 0) {
              i16 = i19;
              i18 = i20;
              continue;
             }
             i19 = i16 + 16 | 0;
             i20 = HEAP32[i19 >> 2] | 0;
             if ((i20 | 0) == 0) {
              break;
             } else {
              i16 = i20;
              i18 = i19;
             }
            }
            if (i18 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
             _abort();
            } else {
             HEAP32[i18 >> 2] = 0;
             i5 = i16;
             break;
            }
           } else {
            i18 = HEAP32[i17 + ((i13 | 8) + i14) >> 2] | 0;
            if (i18 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
             _abort();
            }
            i16 = i18 + 12 | 0;
            if ((HEAP32[i16 >> 2] | 0) != (i15 | 0)) {
             _abort();
            }
            i20 = i19 + 8 | 0;
            if ((HEAP32[i20 >> 2] | 0) == (i15 | 0)) {
             HEAP32[i16 >> 2] = i19;
             HEAP32[i20 >> 2] = i18;
             i5 = i19;
             break;
            } else {
             _abort();
            }
           }
          } while (0);
          if ((i9 | 0) != 0) {
           i16 = HEAP32[i17 + (i14 + 28 + i13) >> 2] | 0;
           i18 = 13216 + (i16 << 2) | 0;
           if ((i15 | 0) == (HEAP32[i18 >> 2] | 0)) {
            HEAP32[i18 >> 2] = i5;
            if ((i5 | 0) == 0) {
             HEAP32[12916 >> 2] = HEAP32[12916 >> 2] & ~(1 << i16);
             break;
            }
           } else {
            if (i9 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
             _abort();
            }
            i16 = i9 + 16 | 0;
            if ((HEAP32[i16 >> 2] | 0) == (i15 | 0)) {
             HEAP32[i16 >> 2] = i5;
            } else {
             HEAP32[i9 + 20 >> 2] = i5;
            }
            if ((i5 | 0) == 0) {
             break;
            }
           }
           if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
            _abort();
           }
           HEAP32[i5 + 24 >> 2] = i9;
           i15 = i13 | 16;
           i9 = HEAP32[i17 + (i15 + i14) >> 2] | 0;
           do {
            if ((i9 | 0) != 0) {
             if (i9 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
              _abort();
             } else {
              HEAP32[i5 + 16 >> 2] = i9;
              HEAP32[i9 + 24 >> 2] = i5;
              break;
             }
            }
           } while (0);
           i9 = HEAP32[i17 + (i12 + i15) >> 2] | 0;
           if ((i9 | 0) != 0) {
            if (i9 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
             _abort();
            } else {
             HEAP32[i5 + 20 >> 2] = i9;
             HEAP32[i9 + 24 >> 2] = i5;
             break;
            }
           }
          }
         } else {
          i5 = HEAP32[i17 + ((i13 | 8) + i14) >> 2] | 0;
          i12 = HEAP32[i17 + (i14 + 12 + i13) >> 2] | 0;
          i18 = 12952 + (i16 << 1 << 2) | 0;
          if ((i5 | 0) != (i18 | 0)) {
           if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
            _abort();
           }
           if ((HEAP32[i5 + 12 >> 2] | 0) != (i15 | 0)) {
            _abort();
           }
          }
          if ((i12 | 0) == (i5 | 0)) {
           HEAP32[3228] = HEAP32[3228] & ~(1 << i16);
           break;
          }
          if ((i12 | 0) != (i18 | 0)) {
           if (i12 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
            _abort();
           }
           i16 = i12 + 8 | 0;
           if ((HEAP32[i16 >> 2] | 0) == (i15 | 0)) {
            i9 = i16;
           } else {
            _abort();
           }
          } else {
           i9 = i12 + 8 | 0;
          }
          HEAP32[i5 + 12 >> 2] = i12;
          HEAP32[i9 >> 2] = i5;
         }
        } while (0);
        i15 = i17 + ((i11 | i13) + i14) | 0;
        i10 = i11 + i10 | 0;
       }
       i5 = i15 + 4 | 0;
       HEAP32[i5 >> 2] = HEAP32[i5 >> 2] & -2;
       HEAP32[i17 + (i8 + 4) >> 2] = i10 | 1;
       HEAP32[i17 + (i10 + i8) >> 2] = i10;
       i5 = i10 >>> 3;
       if (i10 >>> 0 < 256) {
        i10 = i5 << 1;
        i2 = 12952 + (i10 << 2) | 0;
        i9 = HEAP32[3228] | 0;
        i5 = 1 << i5;
        if ((i9 & i5 | 0) != 0) {
         i9 = 12952 + (i10 + 2 << 2) | 0;
         i5 = HEAP32[i9 >> 2] | 0;
         if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
          _abort();
         } else {
          i3 = i9;
          i4 = i5;
         }
        } else {
         HEAP32[3228] = i9 | i5;
         i3 = 12952 + (i10 + 2 << 2) | 0;
         i4 = i2;
        }
        HEAP32[i3 >> 2] = i7;
        HEAP32[i4 + 12 >> 2] = i7;
        HEAP32[i17 + (i8 + 8) >> 2] = i4;
        HEAP32[i17 + (i8 + 12) >> 2] = i2;
        break;
       }
       i3 = i10 >>> 8;
       if ((i3 | 0) != 0) {
        if (i10 >>> 0 > 16777215) {
         i3 = 31;
        } else {
         i31 = (i3 + 1048320 | 0) >>> 16 & 8;
         i32 = i3 << i31;
         i30 = (i32 + 520192 | 0) >>> 16 & 4;
         i32 = i32 << i30;
         i3 = (i32 + 245760 | 0) >>> 16 & 2;
         i3 = 14 - (i30 | i31 | i3) + (i32 << i3 >>> 15) | 0;
         i3 = i10 >>> (i3 + 7 | 0) & 1 | i3 << 1;
        }
       } else {
        i3 = 0;
       }
       i4 = 13216 + (i3 << 2) | 0;
       HEAP32[i17 + (i8 + 28) >> 2] = i3;
       HEAP32[i17 + (i8 + 20) >> 2] = 0;
       HEAP32[i17 + (i8 + 16) >> 2] = 0;
       i9 = HEAP32[12916 >> 2] | 0;
       i5 = 1 << i3;
       if ((i9 & i5 | 0) == 0) {
        HEAP32[12916 >> 2] = i9 | i5;
        HEAP32[i4 >> 2] = i7;
        HEAP32[i17 + (i8 + 24) >> 2] = i4;
        HEAP32[i17 + (i8 + 12) >> 2] = i7;
        HEAP32[i17 + (i8 + 8) >> 2] = i7;
        break;
       }
       i4 = HEAP32[i4 >> 2] | 0;
       if ((i3 | 0) == 31) {
        i3 = 0;
       } else {
        i3 = 25 - (i3 >>> 1) | 0;
       }
       L445 : do {
        if ((HEAP32[i4 + 4 >> 2] & -8 | 0) != (i10 | 0)) {
         i3 = i10 << i3;
         while (1) {
          i5 = i4 + (i3 >>> 31 << 2) + 16 | 0;
          i9 = HEAP32[i5 >> 2] | 0;
          if ((i9 | 0) == 0) {
           break;
          }
          if ((HEAP32[i9 + 4 >> 2] & -8 | 0) == (i10 | 0)) {
           i2 = i9;
           break L445;
          } else {
           i3 = i3 << 1;
           i4 = i9;
          }
         }
         if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
          _abort();
         } else {
          HEAP32[i5 >> 2] = i7;
          HEAP32[i17 + (i8 + 24) >> 2] = i4;
          HEAP32[i17 + (i8 + 12) >> 2] = i7;
          HEAP32[i17 + (i8 + 8) >> 2] = i7;
          break L348;
         }
        } else {
         i2 = i4;
        }
       } while (0);
       i4 = i2 + 8 | 0;
       i3 = HEAP32[i4 >> 2] | 0;
       i5 = HEAP32[12928 >> 2] | 0;
       if (i2 >>> 0 < i5 >>> 0) {
        _abort();
       }
       if (i3 >>> 0 < i5 >>> 0) {
        _abort();
       } else {
        HEAP32[i3 + 12 >> 2] = i7;
        HEAP32[i4 >> 2] = i7;
        HEAP32[i17 + (i8 + 8) >> 2] = i3;
        HEAP32[i17 + (i8 + 12) >> 2] = i2;
        HEAP32[i17 + (i8 + 24) >> 2] = 0;
        break;
       }
      } else {
       i32 = (HEAP32[12924 >> 2] | 0) + i10 | 0;
       HEAP32[12924 >> 2] = i32;
       HEAP32[12936 >> 2] = i7;
       HEAP32[i17 + (i8 + 4) >> 2] = i32 | 1;
      }
     } while (0);
     i32 = i17 + (i6 | 8) | 0;
     STACKTOP = i1;
     return i32 | 0;
    }
    i3 = 13360 | 0;
    while (1) {
     i2 = HEAP32[i3 >> 2] | 0;
     if (!(i2 >>> 0 > i15 >>> 0) ? (i11 = HEAP32[i3 + 4 >> 2] | 0, i10 = i2 + i11 | 0, i10 >>> 0 > i15 >>> 0) : 0) {
      break;
     }
     i3 = HEAP32[i3 + 8 >> 2] | 0;
    }
    i3 = i2 + (i11 + -39) | 0;
    if ((i3 & 7 | 0) == 0) {
     i3 = 0;
    } else {
     i3 = 0 - i3 & 7;
    }
    i2 = i2 + (i11 + -47 + i3) | 0;
    i2 = i2 >>> 0 < (i15 + 16 | 0) >>> 0 ? i15 : i2;
    i3 = i2 + 8 | 0;
    i4 = i17 + 8 | 0;
    if ((i4 & 7 | 0) == 0) {
     i4 = 0;
    } else {
     i4 = 0 - i4 & 7;
    }
    i32 = i14 + -40 - i4 | 0;
    HEAP32[12936 >> 2] = i17 + i4;
    HEAP32[12924 >> 2] = i32;
    HEAP32[i17 + (i4 + 4) >> 2] = i32 | 1;
    HEAP32[i17 + (i14 + -36) >> 2] = 40;
    HEAP32[12940 >> 2] = HEAP32[13400 >> 2];
    HEAP32[i2 + 4 >> 2] = 27;
    HEAP32[i3 + 0 >> 2] = HEAP32[13360 >> 2];
    HEAP32[i3 + 4 >> 2] = HEAP32[13364 >> 2];
    HEAP32[i3 + 8 >> 2] = HEAP32[13368 >> 2];
    HEAP32[i3 + 12 >> 2] = HEAP32[13372 >> 2];
    HEAP32[13360 >> 2] = i17;
    HEAP32[13364 >> 2] = i14;
    HEAP32[13372 >> 2] = 0;
    HEAP32[13368 >> 2] = i3;
    i4 = i2 + 28 | 0;
    HEAP32[i4 >> 2] = 7;
    if ((i2 + 32 | 0) >>> 0 < i10 >>> 0) {
     while (1) {
      i3 = i4 + 4 | 0;
      HEAP32[i3 >> 2] = 7;
      if ((i4 + 8 | 0) >>> 0 < i10 >>> 0) {
       i4 = i3;
      } else {
       break;
      }
     }
    }
    if ((i2 | 0) != (i15 | 0)) {
     i2 = i2 - i15 | 0;
     i3 = i15 + (i2 + 4) | 0;
     HEAP32[i3 >> 2] = HEAP32[i3 >> 2] & -2;
     HEAP32[i15 + 4 >> 2] = i2 | 1;
     HEAP32[i15 + i2 >> 2] = i2;
     i3 = i2 >>> 3;
     if (i2 >>> 0 < 256) {
      i4 = i3 << 1;
      i2 = 12952 + (i4 << 2) | 0;
      i5 = HEAP32[3228] | 0;
      i3 = 1 << i3;
      if ((i5 & i3 | 0) != 0) {
       i4 = 12952 + (i4 + 2 << 2) | 0;
       i3 = HEAP32[i4 >> 2] | 0;
       if (i3 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
        _abort();
       } else {
        i7 = i4;
        i8 = i3;
       }
      } else {
       HEAP32[3228] = i5 | i3;
       i7 = 12952 + (i4 + 2 << 2) | 0;
       i8 = i2;
      }
      HEAP32[i7 >> 2] = i15;
      HEAP32[i8 + 12 >> 2] = i15;
      HEAP32[i15 + 8 >> 2] = i8;
      HEAP32[i15 + 12 >> 2] = i2;
      break;
     }
     i3 = i2 >>> 8;
     if ((i3 | 0) != 0) {
      if (i2 >>> 0 > 16777215) {
       i3 = 31;
      } else {
       i31 = (i3 + 1048320 | 0) >>> 16 & 8;
       i32 = i3 << i31;
       i30 = (i32 + 520192 | 0) >>> 16 & 4;
       i32 = i32 << i30;
       i3 = (i32 + 245760 | 0) >>> 16 & 2;
       i3 = 14 - (i30 | i31 | i3) + (i32 << i3 >>> 15) | 0;
       i3 = i2 >>> (i3 + 7 | 0) & 1 | i3 << 1;
      }
     } else {
      i3 = 0;
     }
     i7 = 13216 + (i3 << 2) | 0;
     HEAP32[i15 + 28 >> 2] = i3;
     HEAP32[i15 + 20 >> 2] = 0;
     HEAP32[i15 + 16 >> 2] = 0;
     i4 = HEAP32[12916 >> 2] | 0;
     i5 = 1 << i3;
     if ((i4 & i5 | 0) == 0) {
      HEAP32[12916 >> 2] = i4 | i5;
      HEAP32[i7 >> 2] = i15;
      HEAP32[i15 + 24 >> 2] = i7;
      HEAP32[i15 + 12 >> 2] = i15;
      HEAP32[i15 + 8 >> 2] = i15;
      break;
     }
     i4 = HEAP32[i7 >> 2] | 0;
     if ((i3 | 0) == 31) {
      i3 = 0;
     } else {
      i3 = 25 - (i3 >>> 1) | 0;
     }
     L499 : do {
      if ((HEAP32[i4 + 4 >> 2] & -8 | 0) != (i2 | 0)) {
       i3 = i2 << i3;
       while (1) {
        i7 = i4 + (i3 >>> 31 << 2) + 16 | 0;
        i5 = HEAP32[i7 >> 2] | 0;
        if ((i5 | 0) == 0) {
         break;
        }
        if ((HEAP32[i5 + 4 >> 2] & -8 | 0) == (i2 | 0)) {
         i6 = i5;
         break L499;
        } else {
         i3 = i3 << 1;
         i4 = i5;
        }
       }
       if (i7 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
        _abort();
       } else {
        HEAP32[i7 >> 2] = i15;
        HEAP32[i15 + 24 >> 2] = i4;
        HEAP32[i15 + 12 >> 2] = i15;
        HEAP32[i15 + 8 >> 2] = i15;
        break L311;
       }
      } else {
       i6 = i4;
      }
     } while (0);
     i4 = i6 + 8 | 0;
     i3 = HEAP32[i4 >> 2] | 0;
     i2 = HEAP32[12928 >> 2] | 0;
     if (i6 >>> 0 < i2 >>> 0) {
      _abort();
     }
     if (i3 >>> 0 < i2 >>> 0) {
      _abort();
     } else {
      HEAP32[i3 + 12 >> 2] = i15;
      HEAP32[i4 >> 2] = i15;
      HEAP32[i15 + 8 >> 2] = i3;
      HEAP32[i15 + 12 >> 2] = i6;
      HEAP32[i15 + 24 >> 2] = 0;
      break;
     }
    }
   } else {
    i32 = HEAP32[12928 >> 2] | 0;
    if ((i32 | 0) == 0 | i17 >>> 0 < i32 >>> 0) {
     HEAP32[12928 >> 2] = i17;
    }
    HEAP32[13360 >> 2] = i17;
    HEAP32[13364 >> 2] = i14;
    HEAP32[13372 >> 2] = 0;
    HEAP32[12948 >> 2] = HEAP32[3346];
    HEAP32[12944 >> 2] = -1;
    i2 = 0;
    do {
     i32 = i2 << 1;
     i31 = 12952 + (i32 << 2) | 0;
     HEAP32[12952 + (i32 + 3 << 2) >> 2] = i31;
     HEAP32[12952 + (i32 + 2 << 2) >> 2] = i31;
     i2 = i2 + 1 | 0;
    } while ((i2 | 0) != 32);
    i2 = i17 + 8 | 0;
    if ((i2 & 7 | 0) == 0) {
     i2 = 0;
    } else {
     i2 = 0 - i2 & 7;
    }
    i32 = i14 + -40 - i2 | 0;
    HEAP32[12936 >> 2] = i17 + i2;
    HEAP32[12924 >> 2] = i32;
    HEAP32[i17 + (i2 + 4) >> 2] = i32 | 1;
    HEAP32[i17 + (i14 + -36) >> 2] = 40;
    HEAP32[12940 >> 2] = HEAP32[13400 >> 2];
   }
  } while (0);
  i2 = HEAP32[12924 >> 2] | 0;
  if (i2 >>> 0 > i12 >>> 0) {
   i31 = i2 - i12 | 0;
   HEAP32[12924 >> 2] = i31;
   i32 = HEAP32[12936 >> 2] | 0;
   HEAP32[12936 >> 2] = i32 + i12;
   HEAP32[i32 + (i12 + 4) >> 2] = i31 | 1;
   HEAP32[i32 + 4 >> 2] = i12 | 3;
   i32 = i32 + 8 | 0;
   STACKTOP = i1;
   return i32 | 0;
  }
 }
 HEAP32[(___errno_location() | 0) >> 2] = 12;
 i32 = 0;
 STACKTOP = i1;
 return i32 | 0;
}
function _llex(i2, i3) {
 i2 = i2 | 0;
 i3 = i3 | 0;
 var i1 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i12 = i1;
 i4 = i2 + 60 | 0;
 HEAP32[(HEAP32[i4 >> 2] | 0) + 4 >> 2] = 0;
 i5 = i2 + 56 | 0;
 L1 : while (1) {
  i13 = HEAP32[i2 >> 2] | 0;
  L3 : while (1) {
   switch (i13 | 0) {
   case 11:
   case 9:
   case 12:
   case 32:
    {
     break;
    }
   case 91:
    {
     i9 = 25;
     break L1;
    }
   case 62:
    {
     i9 = 45;
     break L1;
    }
   case 46:
    {
     i9 = 161;
     break L1;
    }
   case 13:
   case 10:
    {
     i9 = 4;
     break L3;
    }
   case 45:
    {
     break L3;
    }
   case 61:
    {
     i9 = 29;
     break L1;
    }
   case 39:
   case 34:
    {
     i9 = 69;
     break L1;
    }
   case 126:
    {
     i9 = 53;
     break L1;
    }
   case 60:
    {
     i9 = 37;
     break L1;
    }
   case 58:
    {
     i9 = 61;
     break L1;
    }
   case 57:
   case 56:
   case 55:
   case 54:
   case 53:
   case 52:
   case 51:
   case 50:
   case 49:
   case 48:
    {
     i20 = i13;
     break L1;
    }
   case -1:
    {
     i2 = 286;
     i9 = 306;
     break L1;
    }
   default:
    {
     i9 = 283;
     break L1;
    }
   }
   i13 = HEAP32[i5 >> 2] | 0;
   i27 = HEAP32[i13 >> 2] | 0;
   HEAP32[i13 >> 2] = i27 + -1;
   if ((i27 | 0) == 0) {
    i13 = _luaZ_fill(i13) | 0;
   } else {
    i27 = i13 + 4 | 0;
    i13 = HEAP32[i27 >> 2] | 0;
    HEAP32[i27 >> 2] = i13 + 1;
    i13 = HEAPU8[i13] | 0;
   }
   HEAP32[i2 >> 2] = i13;
  }
  if ((i9 | 0) == 4) {
   i9 = 0;
   _inclinenumber(i2);
   continue;
  }
  i13 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i13 >> 2] | 0;
  HEAP32[i13 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i13 = _luaZ_fill(i13) | 0;
  } else {
   i27 = i13 + 4 | 0;
   i13 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i13 + 1;
   i13 = HEAPU8[i13] | 0;
  }
  HEAP32[i2 >> 2] = i13;
  if ((i13 | 0) != 45) {
   i2 = 45;
   i9 = 306;
   break;
  }
  i13 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i13 >> 2] | 0;
  HEAP32[i13 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i13 = _luaZ_fill(i13) | 0;
  } else {
   i27 = i13 + 4 | 0;
   i13 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i13 + 1;
   i13 = HEAPU8[i13] | 0;
  }
  HEAP32[i2 >> 2] = i13;
  do {
   if ((i13 | 0) == 91) {
    i13 = _skip_sep(i2) | 0;
    HEAP32[(HEAP32[i4 >> 2] | 0) + 4 >> 2] = 0;
    if ((i13 | 0) > -1) {
     _read_long_string(i2, 0, i13);
     HEAP32[(HEAP32[i4 >> 2] | 0) + 4 >> 2] = 0;
     continue L1;
    } else {
     i13 = HEAP32[i2 >> 2] | 0;
     break;
    }
   }
  } while (0);
  while (1) {
   if ((i13 | 0) == -1 | (i13 | 0) == 13 | (i13 | 0) == 10) {
    continue L1;
   }
   i13 = HEAP32[i5 >> 2] | 0;
   i27 = HEAP32[i13 >> 2] | 0;
   HEAP32[i13 >> 2] = i27 + -1;
   if ((i27 | 0) == 0) {
    i13 = _luaZ_fill(i13) | 0;
   } else {
    i27 = i13 + 4 | 0;
    i13 = HEAP32[i27 >> 2] | 0;
    HEAP32[i27 >> 2] = i13 + 1;
    i13 = HEAPU8[i13] | 0;
   }
   HEAP32[i2 >> 2] = i13;
  }
 }
 if ((i9 | 0) == 25) {
  i9 = _skip_sep(i2) | 0;
  if ((i9 | 0) > -1) {
   _read_long_string(i2, i3, i9);
   i27 = 289;
   STACKTOP = i1;
   return i27 | 0;
  }
  if ((i9 | 0) == -1) {
   i27 = 91;
   STACKTOP = i1;
   return i27 | 0;
  } else {
   _lexerror(i2, 12272, 289);
  }
 } else if ((i9 | 0) == 29) {
  i3 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i27 = i3 + 4 | 0;
   i3 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i2 >> 2] = i3;
  if ((i3 | 0) != 61) {
   i27 = 61;
   STACKTOP = i1;
   return i27 | 0;
  }
  i3 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i27 = i3 + 4 | 0;
   i3 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i2 >> 2] = i3;
  i27 = 281;
  STACKTOP = i1;
  return i27 | 0;
 } else if ((i9 | 0) == 37) {
  i3 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i27 = i3 + 4 | 0;
   i3 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i2 >> 2] = i3;
  if ((i3 | 0) != 61) {
   i27 = 60;
   STACKTOP = i1;
   return i27 | 0;
  }
  i3 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i27 = i3 + 4 | 0;
   i3 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i2 >> 2] = i3;
  i27 = 283;
  STACKTOP = i1;
  return i27 | 0;
 } else if ((i9 | 0) == 45) {
  i3 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i27 = i3 + 4 | 0;
   i3 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i2 >> 2] = i3;
  if ((i3 | 0) != 61) {
   i27 = 62;
   STACKTOP = i1;
   return i27 | 0;
  }
  i3 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i27 = i3 + 4 | 0;
   i3 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i2 >> 2] = i3;
  i27 = 282;
  STACKTOP = i1;
  return i27 | 0;
 } else if ((i9 | 0) == 53) {
  i3 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i27 = i3 + 4 | 0;
   i3 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i2 >> 2] = i3;
  if ((i3 | 0) != 61) {
   i27 = 126;
   STACKTOP = i1;
   return i27 | 0;
  }
  i3 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i27 = i3 + 4 | 0;
   i3 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i2 >> 2] = i3;
  i27 = 284;
  STACKTOP = i1;
  return i27 | 0;
 } else if ((i9 | 0) == 61) {
  i3 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i27 = i3 + 4 | 0;
   i3 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i2 >> 2] = i3;
  if ((i3 | 0) != 58) {
   i27 = 58;
   STACKTOP = i1;
   return i27 | 0;
  }
  i3 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i27 = i3 + 4 | 0;
   i3 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i2 >> 2] = i3;
  i27 = 285;
  STACKTOP = i1;
  return i27 | 0;
 } else if ((i9 | 0) == 69) {
  i14 = HEAP32[i4 >> 2] | 0;
  i7 = i14 + 4 | 0;
  i15 = HEAP32[i7 >> 2] | 0;
  i8 = i14 + 8 | 0;
  i6 = HEAP32[i8 >> 2] | 0;
  do {
   if ((i15 + 1 | 0) >>> 0 > i6 >>> 0) {
    if (i6 >>> 0 > 2147483645) {
     _lexerror(i2, 12368, 0);
    }
    i16 = i6 << 1;
    i15 = HEAP32[i2 + 52 >> 2] | 0;
    if ((i16 | 0) == -2) {
     _luaM_toobig(i15);
    } else {
     i24 = _luaM_realloc_(i15, HEAP32[i14 >> 2] | 0, i6, i16) | 0;
     HEAP32[i14 >> 2] = i24;
     HEAP32[i8 >> 2] = i16;
     i23 = HEAP32[i7 >> 2] | 0;
     break;
    }
   } else {
    i23 = i15;
    i24 = HEAP32[i14 >> 2] | 0;
   }
  } while (0);
  i6 = i13 & 255;
  HEAP32[i7 >> 2] = i23 + 1;
  HEAP8[i24 + i23 | 0] = i6;
  i7 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i7 >> 2] | 0;
  HEAP32[i7 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i14 = _luaZ_fill(i7) | 0;
  } else {
   i27 = i7 + 4 | 0;
   i14 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i14 + 1;
   i14 = HEAPU8[i14] | 0;
  }
  HEAP32[i2 >> 2] = i14;
  L139 : do {
   if ((i14 | 0) != (i13 | 0)) {
    i7 = i2 + 52 | 0;
    L141 : while (1) {
     L143 : do {
      if ((i14 | 0) == 92) {
       i8 = HEAP32[i5 >> 2] | 0;
       i27 = HEAP32[i8 >> 2] | 0;
       HEAP32[i8 >> 2] = i27 + -1;
       if ((i27 | 0) == 0) {
        i8 = _luaZ_fill(i8) | 0;
       } else {
        i27 = i8 + 4 | 0;
        i8 = HEAP32[i27 >> 2] | 0;
        HEAP32[i27 >> 2] = i8 + 1;
        i8 = HEAPU8[i8] | 0;
       }
       HEAP32[i2 >> 2] = i8;
       switch (i8 | 0) {
       case 13:
       case 10:
        {
         _inclinenumber(i2);
         i8 = 10;
         break;
        }
       case 39:
       case 34:
       case 92:
        {
         i9 = 124;
         break;
        }
       case 122:
        {
         i8 = HEAP32[i5 >> 2] | 0;
         i27 = HEAP32[i8 >> 2] | 0;
         HEAP32[i8 >> 2] = i27 + -1;
         if ((i27 | 0) == 0) {
          i14 = _luaZ_fill(i8) | 0;
         } else {
          i27 = i8 + 4 | 0;
          i14 = HEAP32[i27 >> 2] | 0;
          HEAP32[i27 >> 2] = i14 + 1;
          i14 = HEAPU8[i14] | 0;
         }
         HEAP32[i2 >> 2] = i14;
         if ((HEAP8[i14 + 10913 | 0] & 8) == 0) {
          break L143;
         }
         while (1) {
          if ((i14 | 0) == 13 | (i14 | 0) == 10) {
           _inclinenumber(i2);
           i14 = HEAP32[i2 >> 2] | 0;
          } else {
           i8 = HEAP32[i5 >> 2] | 0;
           i27 = HEAP32[i8 >> 2] | 0;
           HEAP32[i8 >> 2] = i27 + -1;
           if ((i27 | 0) == 0) {
            i14 = _luaZ_fill(i8) | 0;
           } else {
            i27 = i8 + 4 | 0;
            i14 = HEAP32[i27 >> 2] | 0;
            HEAP32[i27 >> 2] = i14 + 1;
            i14 = HEAPU8[i14] | 0;
           }
           HEAP32[i2 >> 2] = i14;
          }
          if ((HEAP8[i14 + 10913 | 0] & 8) == 0) {
           break L143;
          }
         }
        }
       case 118:
        {
         i8 = 11;
         i9 = 124;
         break;
        }
       case 120:
        {
         HEAP32[i12 >> 2] = 120;
         i14 = 1;
         i8 = 0;
         while (1) {
          i9 = HEAP32[i5 >> 2] | 0;
          i27 = HEAP32[i9 >> 2] | 0;
          HEAP32[i9 >> 2] = i27 + -1;
          if ((i27 | 0) == 0) {
           i9 = _luaZ_fill(i9) | 0;
          } else {
           i27 = i9 + 4 | 0;
           i9 = HEAP32[i27 >> 2] | 0;
           HEAP32[i27 >> 2] = i9 + 1;
           i9 = HEAPU8[i9] | 0;
          }
          HEAP32[i2 >> 2] = i9;
          HEAP32[i12 + (i14 << 2) >> 2] = i9;
          if ((HEAP8[i9 + 10913 | 0] & 16) == 0) {
           i9 = 100;
           break L141;
          }
          i8 = (_luaO_hexavalue(i9) | 0) + (i8 << 4) | 0;
          i14 = i14 + 1 | 0;
          if ((i14 | 0) >= 3) {
           i9 = 124;
           break;
          }
         }
         break;
        }
       case -1:
        {
         i14 = -1;
         break L143;
        }
       case 98:
        {
         i8 = 8;
         i9 = 124;
         break;
        }
       case 102:
        {
         i8 = 12;
         i9 = 124;
         break;
        }
       case 110:
        {
         i8 = 10;
         i9 = 124;
         break;
        }
       case 114:
        {
         i8 = 13;
         i9 = 124;
         break;
        }
       case 116:
        {
         i8 = 9;
         i9 = 124;
         break;
        }
       case 97:
        {
         i8 = 7;
         i9 = 124;
         break;
        }
       default:
        {
         if ((HEAP8[i8 + 10913 | 0] & 2) == 0) {
          i9 = 116;
          break L141;
         } else {
          i15 = i8;
          i14 = 0;
          i8 = 0;
         }
         do {
          if ((HEAP8[i15 + 10913 | 0] & 2) == 0) {
           break;
          }
          HEAP32[i12 + (i14 << 2) >> 2] = i15;
          i8 = i15 + -48 + (i8 * 10 | 0) | 0;
          i15 = HEAP32[i5 >> 2] | 0;
          i27 = HEAP32[i15 >> 2] | 0;
          HEAP32[i15 >> 2] = i27 + -1;
          if ((i27 | 0) == 0) {
           i15 = _luaZ_fill(i15) | 0;
          } else {
           i27 = i15 + 4 | 0;
           i15 = HEAP32[i27 >> 2] | 0;
           HEAP32[i27 >> 2] = i15 + 1;
           i15 = HEAPU8[i15] | 0;
          }
          HEAP32[i2 >> 2] = i15;
          i14 = i14 + 1 | 0;
         } while ((i14 | 0) < 3);
         if ((i8 | 0) > 255) {
          i9 = 123;
          break L141;
         }
        }
       }
       if ((i9 | 0) == 124) {
        i9 = 0;
        i14 = HEAP32[i5 >> 2] | 0;
        i27 = HEAP32[i14 >> 2] | 0;
        HEAP32[i14 >> 2] = i27 + -1;
        if ((i27 | 0) == 0) {
         i14 = _luaZ_fill(i14) | 0;
        } else {
         i27 = i14 + 4 | 0;
         i14 = HEAP32[i27 >> 2] | 0;
         HEAP32[i27 >> 2] = i14 + 1;
         i14 = HEAPU8[i14] | 0;
        }
        HEAP32[i2 >> 2] = i14;
       }
       i15 = HEAP32[i4 >> 2] | 0;
       i14 = i15 + 4 | 0;
       i18 = HEAP32[i14 >> 2] | 0;
       i16 = i15 + 8 | 0;
       i17 = HEAP32[i16 >> 2] | 0;
       if ((i18 + 1 | 0) >>> 0 > i17 >>> 0) {
        if (i17 >>> 0 > 2147483645) {
         i9 = 131;
         break L141;
        }
        i18 = i17 << 1;
        i19 = HEAP32[i7 >> 2] | 0;
        if ((i18 | 0) == -2) {
         i9 = 133;
         break L141;
        }
        i27 = _luaM_realloc_(i19, HEAP32[i15 >> 2] | 0, i17, i18) | 0;
        HEAP32[i15 >> 2] = i27;
        HEAP32[i16 >> 2] = i18;
        i18 = HEAP32[i14 >> 2] | 0;
        i15 = i27;
       } else {
        i15 = HEAP32[i15 >> 2] | 0;
       }
       HEAP32[i14 >> 2] = i18 + 1;
       HEAP8[i15 + i18 | 0] = i8;
       i14 = HEAP32[i2 >> 2] | 0;
      } else if ((i14 | 0) == -1) {
       i9 = 82;
       break L141;
      } else if ((i14 | 0) == 13 | (i14 | 0) == 10) {
       i9 = 83;
       break L141;
      } else {
       i15 = HEAP32[i4 >> 2] | 0;
       i8 = i15 + 4 | 0;
       i18 = HEAP32[i8 >> 2] | 0;
       i17 = i15 + 8 | 0;
       i16 = HEAP32[i17 >> 2] | 0;
       if ((i18 + 1 | 0) >>> 0 > i16 >>> 0) {
        if (i16 >>> 0 > 2147483645) {
         i9 = 139;
         break L141;
        }
        i19 = i16 << 1;
        i18 = HEAP32[i7 >> 2] | 0;
        if ((i19 | 0) == -2) {
         i9 = 141;
         break L141;
        }
        i27 = _luaM_realloc_(i18, HEAP32[i15 >> 2] | 0, i16, i19) | 0;
        HEAP32[i15 >> 2] = i27;
        HEAP32[i17 >> 2] = i19;
        i18 = HEAP32[i8 >> 2] | 0;
        i15 = i27;
       } else {
        i15 = HEAP32[i15 >> 2] | 0;
       }
       HEAP32[i8 >> 2] = i18 + 1;
       HEAP8[i15 + i18 | 0] = i14;
       i8 = HEAP32[i5 >> 2] | 0;
       i27 = HEAP32[i8 >> 2] | 0;
       HEAP32[i8 >> 2] = i27 + -1;
       if ((i27 | 0) == 0) {
        i14 = _luaZ_fill(i8) | 0;
       } else {
        i27 = i8 + 4 | 0;
        i14 = HEAP32[i27 >> 2] | 0;
        HEAP32[i27 >> 2] = i14 + 1;
        i14 = HEAPU8[i14] | 0;
       }
       HEAP32[i2 >> 2] = i14;
      }
     } while (0);
     if ((i14 | 0) == (i13 | 0)) {
      break L139;
     }
    }
    if ((i9 | 0) == 82) {
     _lexerror(i2, 12400, 286);
    } else if ((i9 | 0) == 83) {
     _lexerror(i2, 12400, 289);
    } else if ((i9 | 0) == 100) {
     _escerror(i2, i12, i14 + 1 | 0, 12480);
    } else if ((i9 | 0) == 116) {
     _escerror(i2, i2, 1, 12424);
    } else if ((i9 | 0) == 123) {
     _escerror(i2, i12, i14, 12448);
    } else if ((i9 | 0) == 131) {
     _lexerror(i2, 12368, 0);
    } else if ((i9 | 0) == 133) {
     _luaM_toobig(i19);
    } else if ((i9 | 0) == 139) {
     _lexerror(i2, 12368, 0);
    } else if ((i9 | 0) == 141) {
     _luaM_toobig(i18);
    }
   }
  } while (0);
  i7 = HEAP32[i4 >> 2] | 0;
  i8 = i7 + 4 | 0;
  i13 = HEAP32[i8 >> 2] | 0;
  i12 = i7 + 8 | 0;
  i9 = HEAP32[i12 >> 2] | 0;
  do {
   if ((i13 + 1 | 0) >>> 0 > i9 >>> 0) {
    if (i9 >>> 0 > 2147483645) {
     _lexerror(i2, 12368, 0);
    }
    i14 = i9 << 1;
    i13 = HEAP32[i2 + 52 >> 2] | 0;
    if ((i14 | 0) == -2) {
     _luaM_toobig(i13);
    } else {
     i11 = _luaM_realloc_(i13, HEAP32[i7 >> 2] | 0, i9, i14) | 0;
     HEAP32[i7 >> 2] = i11;
     HEAP32[i12 >> 2] = i14;
     i10 = HEAP32[i8 >> 2] | 0;
     break;
    }
   } else {
    i10 = i13;
    i11 = HEAP32[i7 >> 2] | 0;
   }
  } while (0);
  HEAP32[i8 >> 2] = i10 + 1;
  HEAP8[i11 + i10 | 0] = i6;
  i5 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i5 >> 2] | 0;
  HEAP32[i5 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i5 = _luaZ_fill(i5) | 0;
  } else {
   i27 = i5 + 4 | 0;
   i5 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i5 + 1;
   i5 = HEAPU8[i5] | 0;
  }
  HEAP32[i2 >> 2] = i5;
  i5 = HEAP32[i4 >> 2] | 0;
  i4 = HEAP32[i2 + 52 >> 2] | 0;
  i5 = _luaS_newlstr(i4, (HEAP32[i5 >> 2] | 0) + 1 | 0, (HEAP32[i5 + 4 >> 2] | 0) + -2 | 0) | 0;
  i6 = i4 + 8 | 0;
  i7 = HEAP32[i6 >> 2] | 0;
  HEAP32[i6 >> 2] = i7 + 16;
  HEAP32[i7 >> 2] = i5;
  HEAP32[i7 + 8 >> 2] = HEAPU8[i5 + 4 | 0] | 64;
  i7 = _luaH_set(i4, HEAP32[(HEAP32[i2 + 48 >> 2] | 0) + 4 >> 2] | 0, (HEAP32[i6 >> 2] | 0) + -16 | 0) | 0;
  i2 = i7 + 8 | 0;
  if ((HEAP32[i2 >> 2] | 0) == 0 ? (HEAP32[i7 >> 2] = 1, HEAP32[i2 >> 2] = 1, (HEAP32[(HEAP32[i4 + 12 >> 2] | 0) + 12 >> 2] | 0) > 0) : 0) {
   _luaC_step(i4);
  }
  HEAP32[i6 >> 2] = (HEAP32[i6 >> 2] | 0) + -16;
  HEAP32[i3 >> 2] = i5;
  i27 = 289;
  STACKTOP = i1;
  return i27 | 0;
 } else if ((i9 | 0) == 161) {
  i10 = HEAP32[i4 >> 2] | 0;
  i9 = i10 + 4 | 0;
  i13 = HEAP32[i9 >> 2] | 0;
  i12 = i10 + 8 | 0;
  i11 = HEAP32[i12 >> 2] | 0;
  do {
   if ((i13 + 1 | 0) >>> 0 > i11 >>> 0) {
    if (i11 >>> 0 > 2147483645) {
     _lexerror(i2, 12368, 0);
    }
    i13 = i11 << 1;
    i20 = HEAP32[i2 + 52 >> 2] | 0;
    if ((i13 | 0) == -2) {
     _luaM_toobig(i20);
    } else {
     i25 = _luaM_realloc_(i20, HEAP32[i10 >> 2] | 0, i11, i13) | 0;
     HEAP32[i10 >> 2] = i25;
     HEAP32[i12 >> 2] = i13;
     i26 = HEAP32[i9 >> 2] | 0;
     break;
    }
   } else {
    i26 = i13;
    i25 = HEAP32[i10 >> 2] | 0;
   }
  } while (0);
  HEAP32[i9 >> 2] = i26 + 1;
  HEAP8[i25 + i26 | 0] = 46;
  i9 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i9 >> 2] | 0;
  HEAP32[i9 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i20 = _luaZ_fill(i9) | 0;
  } else {
   i27 = i9 + 4 | 0;
   i20 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i20 + 1;
   i20 = HEAPU8[i20] | 0;
  }
  HEAP32[i2 >> 2] = i20;
  if ((i20 | 0) != 0 ? (_memchr(12304, i20, 2) | 0) != 0 : 0) {
   i6 = HEAP32[i4 >> 2] | 0;
   i3 = i6 + 4 | 0;
   i9 = HEAP32[i3 >> 2] | 0;
   i8 = i6 + 8 | 0;
   i7 = HEAP32[i8 >> 2] | 0;
   do {
    if ((i9 + 1 | 0) >>> 0 > i7 >>> 0) {
     if (i7 >>> 0 > 2147483645) {
      _lexerror(i2, 12368, 0);
     }
     i9 = i7 << 1;
     i10 = HEAP32[i2 + 52 >> 2] | 0;
     if ((i9 | 0) == -2) {
      _luaM_toobig(i10);
     } else {
      i21 = _luaM_realloc_(i10, HEAP32[i6 >> 2] | 0, i7, i9) | 0;
      HEAP32[i6 >> 2] = i21;
      HEAP32[i8 >> 2] = i9;
      i22 = HEAP32[i3 >> 2] | 0;
      break;
     }
    } else {
     i22 = i9;
     i21 = HEAP32[i6 >> 2] | 0;
    }
   } while (0);
   HEAP32[i3 >> 2] = i22 + 1;
   HEAP8[i21 + i22 | 0] = i20;
   i3 = HEAP32[i5 >> 2] | 0;
   i27 = HEAP32[i3 >> 2] | 0;
   HEAP32[i3 >> 2] = i27 + -1;
   if ((i27 | 0) == 0) {
    i3 = _luaZ_fill(i3) | 0;
   } else {
    i27 = i3 + 4 | 0;
    i3 = HEAP32[i27 >> 2] | 0;
    HEAP32[i27 >> 2] = i3 + 1;
    i3 = HEAPU8[i3] | 0;
   }
   HEAP32[i2 >> 2] = i3;
   if ((i3 | 0) == 0) {
    i27 = 279;
    STACKTOP = i1;
    return i27 | 0;
   }
   if ((_memchr(12304, i3, 2) | 0) == 0) {
    i27 = 279;
    STACKTOP = i1;
    return i27 | 0;
   }
   i6 = HEAP32[i4 >> 2] | 0;
   i7 = i6 + 4 | 0;
   i9 = HEAP32[i7 >> 2] | 0;
   i8 = i6 + 8 | 0;
   i4 = HEAP32[i8 >> 2] | 0;
   do {
    if ((i9 + 1 | 0) >>> 0 > i4 >>> 0) {
     if (i4 >>> 0 > 2147483645) {
      _lexerror(i2, 12368, 0);
     }
     i10 = i4 << 1;
     i9 = HEAP32[i2 + 52 >> 2] | 0;
     if ((i10 | 0) == -2) {
      _luaM_toobig(i9);
     } else {
      i18 = _luaM_realloc_(i9, HEAP32[i6 >> 2] | 0, i4, i10) | 0;
      HEAP32[i6 >> 2] = i18;
      HEAP32[i8 >> 2] = i10;
      i19 = HEAP32[i7 >> 2] | 0;
      break;
     }
    } else {
     i19 = i9;
     i18 = HEAP32[i6 >> 2] | 0;
    }
   } while (0);
   HEAP32[i7 >> 2] = i19 + 1;
   HEAP8[i18 + i19 | 0] = i3;
   i3 = HEAP32[i5 >> 2] | 0;
   i27 = HEAP32[i3 >> 2] | 0;
   HEAP32[i3 >> 2] = i27 + -1;
   if ((i27 | 0) == 0) {
    i3 = _luaZ_fill(i3) | 0;
   } else {
    i27 = i3 + 4 | 0;
    i3 = HEAP32[i27 >> 2] | 0;
    HEAP32[i27 >> 2] = i3 + 1;
    i3 = HEAPU8[i3] | 0;
   }
   HEAP32[i2 >> 2] = i3;
   i27 = 280;
   STACKTOP = i1;
   return i27 | 0;
  }
  if ((HEAP8[i20 + 10913 | 0] & 2) == 0) {
   i27 = 46;
   STACKTOP = i1;
   return i27 | 0;
  }
 } else if ((i9 | 0) == 283) {
  if ((HEAP8[i13 + 10913 | 0] & 1) == 0) {
   i3 = HEAP32[i5 >> 2] | 0;
   i27 = HEAP32[i3 >> 2] | 0;
   HEAP32[i3 >> 2] = i27 + -1;
   if ((i27 | 0) == 0) {
    i3 = _luaZ_fill(i3) | 0;
   } else {
    i27 = i3 + 4 | 0;
    i3 = HEAP32[i27 >> 2] | 0;
    HEAP32[i27 >> 2] = i3 + 1;
    i3 = HEAPU8[i3] | 0;
   }
   HEAP32[i2 >> 2] = i3;
   i27 = i13;
   STACKTOP = i1;
   return i27 | 0;
  }
  i10 = i2 + 52 | 0;
  while (1) {
   i11 = HEAP32[i4 >> 2] | 0;
   i9 = i11 + 4 | 0;
   i12 = HEAP32[i9 >> 2] | 0;
   i19 = i11 + 8 | 0;
   i18 = HEAP32[i19 >> 2] | 0;
   if ((i12 + 1 | 0) >>> 0 > i18 >>> 0) {
    if (i18 >>> 0 > 2147483645) {
     i9 = 288;
     break;
    }
    i21 = i18 << 1;
    i12 = HEAP32[i10 >> 2] | 0;
    if ((i21 | 0) == -2) {
     i9 = 290;
     break;
    }
    i27 = _luaM_realloc_(i12, HEAP32[i11 >> 2] | 0, i18, i21) | 0;
    HEAP32[i11 >> 2] = i27;
    HEAP32[i19 >> 2] = i21;
    i12 = HEAP32[i9 >> 2] | 0;
    i11 = i27;
   } else {
    i11 = HEAP32[i11 >> 2] | 0;
   }
   HEAP32[i9 >> 2] = i12 + 1;
   HEAP8[i11 + i12 | 0] = i13;
   i9 = HEAP32[i5 >> 2] | 0;
   i27 = HEAP32[i9 >> 2] | 0;
   HEAP32[i9 >> 2] = i27 + -1;
   if ((i27 | 0) == 0) {
    i13 = _luaZ_fill(i9) | 0;
   } else {
    i27 = i9 + 4 | 0;
    i13 = HEAP32[i27 >> 2] | 0;
    HEAP32[i27 >> 2] = i13 + 1;
    i13 = HEAPU8[i13] | 0;
   }
   HEAP32[i2 >> 2] = i13;
   if ((HEAP8[i13 + 10913 | 0] & 3) == 0) {
    i9 = 296;
    break;
   }
  }
  if ((i9 | 0) == 288) {
   _lexerror(i2, 12368, 0);
  } else if ((i9 | 0) == 290) {
   _luaM_toobig(i12);
  } else if ((i9 | 0) == 296) {
   i6 = HEAP32[i4 >> 2] | 0;
   i4 = HEAP32[i10 >> 2] | 0;
   i6 = _luaS_newlstr(i4, HEAP32[i6 >> 2] | 0, HEAP32[i6 + 4 >> 2] | 0) | 0;
   i7 = i4 + 8 | 0;
   i8 = HEAP32[i7 >> 2] | 0;
   HEAP32[i7 >> 2] = i8 + 16;
   HEAP32[i8 >> 2] = i6;
   i5 = i6 + 4 | 0;
   HEAP32[i8 + 8 >> 2] = HEAPU8[i5] | 64;
   i8 = _luaH_set(i4, HEAP32[(HEAP32[i2 + 48 >> 2] | 0) + 4 >> 2] | 0, (HEAP32[i7 >> 2] | 0) + -16 | 0) | 0;
   i2 = i8 + 8 | 0;
   if ((HEAP32[i2 >> 2] | 0) == 0 ? (HEAP32[i8 >> 2] = 1, HEAP32[i2 >> 2] = 1, (HEAP32[(HEAP32[i4 + 12 >> 2] | 0) + 12 >> 2] | 0) > 0) : 0) {
    _luaC_step(i4);
   }
   HEAP32[i7 >> 2] = (HEAP32[i7 >> 2] | 0) + -16;
   HEAP32[i3 >> 2] = i6;
   if ((HEAP8[i5] | 0) != 4) {
    i27 = 288;
    STACKTOP = i1;
    return i27 | 0;
   }
   i2 = HEAP8[i6 + 6 | 0] | 0;
   if (i2 << 24 >> 24 == 0) {
    i27 = 288;
    STACKTOP = i1;
    return i27 | 0;
   }
   i27 = i2 & 255 | 256;
   STACKTOP = i1;
   return i27 | 0;
  }
 } else if ((i9 | 0) == 306) {
  STACKTOP = i1;
  return i2 | 0;
 }
 i9 = HEAP32[i4 >> 2] | 0;
 i12 = i9 + 4 | 0;
 i13 = HEAP32[i12 >> 2] | 0;
 i11 = i9 + 8 | 0;
 i10 = HEAP32[i11 >> 2] | 0;
 do {
  if ((i13 + 1 | 0) >>> 0 > i10 >>> 0) {
   if (i10 >>> 0 > 2147483645) {
    _lexerror(i2, 12368, 0);
   }
   i18 = i10 << 1;
   i13 = HEAP32[i2 + 52 >> 2] | 0;
   if ((i18 | 0) == -2) {
    _luaM_toobig(i13);
   } else {
    i16 = _luaM_realloc_(i13, HEAP32[i9 >> 2] | 0, i10, i18) | 0;
    HEAP32[i9 >> 2] = i16;
    HEAP32[i11 >> 2] = i18;
    i17 = HEAP32[i12 >> 2] | 0;
    break;
   }
  } else {
   i17 = i13;
   i16 = HEAP32[i9 >> 2] | 0;
  }
 } while (0);
 HEAP32[i12 >> 2] = i17 + 1;
 HEAP8[i16 + i17 | 0] = i20;
 i9 = HEAP32[i5 >> 2] | 0;
 i27 = HEAP32[i9 >> 2] | 0;
 HEAP32[i9 >> 2] = i27 + -1;
 if ((i27 | 0) == 0) {
  i9 = _luaZ_fill(i9) | 0;
 } else {
  i27 = i9 + 4 | 0;
  i9 = HEAP32[i27 >> 2] | 0;
  HEAP32[i27 >> 2] = i9 + 1;
  i9 = HEAPU8[i9] | 0;
 }
 HEAP32[i2 >> 2] = i9;
 if ((i20 | 0) == 48) {
  if ((i9 | 0) != 0) {
   if ((_memchr(12320, i9, 3) | 0) == 0) {
    i15 = i9;
    i9 = 12312;
   } else {
    i10 = HEAP32[i4 >> 2] | 0;
    i13 = i10 + 4 | 0;
    i16 = HEAP32[i13 >> 2] | 0;
    i11 = i10 + 8 | 0;
    i12 = HEAP32[i11 >> 2] | 0;
    do {
     if ((i16 + 1 | 0) >>> 0 > i12 >>> 0) {
      if (i12 >>> 0 > 2147483645) {
       _lexerror(i2, 12368, 0);
      }
      i17 = i12 << 1;
      i16 = HEAP32[i2 + 52 >> 2] | 0;
      if ((i17 | 0) == -2) {
       _luaM_toobig(i16);
      } else {
       i15 = _luaM_realloc_(i16, HEAP32[i10 >> 2] | 0, i12, i17) | 0;
       HEAP32[i10 >> 2] = i15;
       HEAP32[i11 >> 2] = i17;
       i14 = HEAP32[i13 >> 2] | 0;
       break;
      }
     } else {
      i14 = i16;
      i15 = HEAP32[i10 >> 2] | 0;
     }
    } while (0);
    HEAP32[i13 >> 2] = i14 + 1;
    HEAP8[i15 + i14 | 0] = i9;
    i9 = HEAP32[i5 >> 2] | 0;
    i27 = HEAP32[i9 >> 2] | 0;
    HEAP32[i9 >> 2] = i27 + -1;
    if ((i27 | 0) == 0) {
     i15 = _luaZ_fill(i9) | 0;
    } else {
     i27 = i9 + 4 | 0;
     i15 = HEAP32[i27 >> 2] | 0;
     HEAP32[i27 >> 2] = i15 + 1;
     i15 = HEAPU8[i15] | 0;
    }
    HEAP32[i2 >> 2] = i15;
    i9 = 12328;
   }
  } else {
   i15 = 0;
   i9 = 12312;
  }
 } else {
  i15 = i9;
  i9 = 12312;
 }
 i10 = i2 + 52 | 0;
 while (1) {
  if ((i15 | 0) != 0) {
   if ((_memchr(i9, i15, 3) | 0) != 0) {
    i12 = HEAP32[i4 >> 2] | 0;
    i11 = i12 + 4 | 0;
    i16 = HEAP32[i11 >> 2] | 0;
    i14 = i12 + 8 | 0;
    i13 = HEAP32[i14 >> 2] | 0;
    if ((i16 + 1 | 0) >>> 0 > i13 >>> 0) {
     if (i13 >>> 0 > 2147483645) {
      i9 = 227;
      break;
     }
     i17 = i13 << 1;
     i16 = HEAP32[i10 >> 2] | 0;
     if ((i17 | 0) == -2) {
      i9 = 229;
      break;
     }
     i27 = _luaM_realloc_(i16, HEAP32[i12 >> 2] | 0, i13, i17) | 0;
     HEAP32[i12 >> 2] = i27;
     HEAP32[i14 >> 2] = i17;
     i16 = HEAP32[i11 >> 2] | 0;
     i12 = i27;
    } else {
     i12 = HEAP32[i12 >> 2] | 0;
    }
    HEAP32[i11 >> 2] = i16 + 1;
    HEAP8[i12 + i16 | 0] = i15;
    i11 = HEAP32[i5 >> 2] | 0;
    i27 = HEAP32[i11 >> 2] | 0;
    HEAP32[i11 >> 2] = i27 + -1;
    if ((i27 | 0) == 0) {
     i15 = _luaZ_fill(i11) | 0;
    } else {
     i27 = i11 + 4 | 0;
     i15 = HEAP32[i27 >> 2] | 0;
     HEAP32[i27 >> 2] = i15 + 1;
     i15 = HEAPU8[i15] | 0;
    }
    HEAP32[i2 >> 2] = i15;
    if ((i15 | 0) != 0) {
     if ((_memchr(12336, i15, 3) | 0) != 0) {
      i12 = HEAP32[i4 >> 2] | 0;
      i11 = i12 + 4 | 0;
      i16 = HEAP32[i11 >> 2] | 0;
      i14 = i12 + 8 | 0;
      i13 = HEAP32[i14 >> 2] | 0;
      if ((i16 + 1 | 0) >>> 0 > i13 >>> 0) {
       if (i13 >>> 0 > 2147483645) {
        i9 = 239;
        break;
       }
       i17 = i13 << 1;
       i16 = HEAP32[i10 >> 2] | 0;
       if ((i17 | 0) == -2) {
        i9 = 241;
        break;
       }
       i27 = _luaM_realloc_(i16, HEAP32[i12 >> 2] | 0, i13, i17) | 0;
       HEAP32[i12 >> 2] = i27;
       HEAP32[i14 >> 2] = i17;
       i16 = HEAP32[i11 >> 2] | 0;
       i12 = i27;
      } else {
       i12 = HEAP32[i12 >> 2] | 0;
      }
      HEAP32[i11 >> 2] = i16 + 1;
      HEAP8[i12 + i16 | 0] = i15;
      i11 = HEAP32[i5 >> 2] | 0;
      i27 = HEAP32[i11 >> 2] | 0;
      HEAP32[i11 >> 2] = i27 + -1;
      if ((i27 | 0) == 0) {
       i15 = _luaZ_fill(i11) | 0;
      } else {
       i27 = i11 + 4 | 0;
       i15 = HEAP32[i27 >> 2] | 0;
       HEAP32[i27 >> 2] = i15 + 1;
       i15 = HEAPU8[i15] | 0;
      }
      HEAP32[i2 >> 2] = i15;
     }
    } else {
     i15 = 0;
    }
   }
  } else {
   i15 = 0;
  }
  i12 = HEAP32[i4 >> 2] | 0;
  i11 = i12 + 4 | 0;
  i17 = HEAP32[i11 >> 2] | 0;
  i14 = i12 + 8 | 0;
  i13 = HEAP32[i14 >> 2] | 0;
  i16 = (i17 + 1 | 0) >>> 0 > i13 >>> 0;
  if (!((HEAP8[i15 + 10913 | 0] & 16) != 0 | (i15 | 0) == 46)) {
   i9 = 259;
   break;
  }
  if (i16) {
   if (i13 >>> 0 > 2147483645) {
    i9 = 251;
    break;
   }
   i17 = i13 << 1;
   i16 = HEAP32[i10 >> 2] | 0;
   if ((i17 | 0) == -2) {
    i9 = 253;
    break;
   }
   i27 = _luaM_realloc_(i16, HEAP32[i12 >> 2] | 0, i13, i17) | 0;
   HEAP32[i12 >> 2] = i27;
   HEAP32[i14 >> 2] = i17;
   i17 = HEAP32[i11 >> 2] | 0;
   i12 = i27;
  } else {
   i12 = HEAP32[i12 >> 2] | 0;
  }
  HEAP32[i11 >> 2] = i17 + 1;
  HEAP8[i12 + i17 | 0] = i15;
  i11 = HEAP32[i5 >> 2] | 0;
  i27 = HEAP32[i11 >> 2] | 0;
  HEAP32[i11 >> 2] = i27 + -1;
  if ((i27 | 0) == 0) {
   i15 = _luaZ_fill(i11) | 0;
  } else {
   i27 = i11 + 4 | 0;
   i15 = HEAP32[i27 >> 2] | 0;
   HEAP32[i27 >> 2] = i15 + 1;
   i15 = HEAPU8[i15] | 0;
  }
  HEAP32[i2 >> 2] = i15;
 }
 if ((i9 | 0) == 227) {
  _lexerror(i2, 12368, 0);
 } else if ((i9 | 0) == 229) {
  _luaM_toobig(i16);
 } else if ((i9 | 0) == 239) {
  _lexerror(i2, 12368, 0);
 } else if ((i9 | 0) == 241) {
  _luaM_toobig(i16);
 } else if ((i9 | 0) == 251) {
  _lexerror(i2, 12368, 0);
 } else if ((i9 | 0) == 253) {
  _luaM_toobig(i16);
 } else if ((i9 | 0) == 259) {
  do {
   if (i16) {
    if (i13 >>> 0 > 2147483645) {
     _lexerror(i2, 12368, 0);
    }
    i5 = i13 << 1;
    i9 = HEAP32[i10 >> 2] | 0;
    if ((i5 | 0) == -2) {
     _luaM_toobig(i9);
    } else {
     i7 = _luaM_realloc_(i9, HEAP32[i12 >> 2] | 0, i13, i5) | 0;
     HEAP32[i12 >> 2] = i7;
     HEAP32[i14 >> 2] = i5;
     i8 = HEAP32[i11 >> 2] | 0;
     break;
    }
   } else {
    i8 = i17;
    i7 = HEAP32[i12 >> 2] | 0;
   }
  } while (0);
  HEAP32[i11 >> 2] = i8 + 1;
  HEAP8[i7 + i8 | 0] = 0;
  i5 = i2 + 76 | 0;
  i7 = HEAP8[i5] | 0;
  i10 = HEAP32[i4 >> 2] | 0;
  i8 = HEAP32[i10 >> 2] | 0;
  i10 = HEAP32[i10 + 4 >> 2] | 0;
  if ((i10 | 0) == 0) {
   i7 = -1;
  } else {
   do {
    i10 = i10 + -1 | 0;
    i9 = i8 + i10 | 0;
    if ((HEAP8[i9] | 0) == 46) {
     HEAP8[i9] = i7;
    }
   } while ((i10 | 0) != 0);
   i7 = HEAP32[i4 >> 2] | 0;
   i8 = HEAP32[i7 >> 2] | 0;
   i7 = (HEAP32[i7 + 4 >> 2] | 0) + -1 | 0;
  }
  if ((_luaO_str2d(i8, i7, i3) | 0) != 0) {
   i27 = 287;
   STACKTOP = i1;
   return i27 | 0;
  }
  i9 = HEAP8[i5] | 0;
  i8 = HEAP8[HEAP32[(_localeconv() | 0) >> 2] | 0] | 0;
  HEAP8[i5] = i8;
  i10 = HEAP32[i4 >> 2] | 0;
  i7 = HEAP32[i10 >> 2] | 0;
  i10 = HEAP32[i10 + 4 >> 2] | 0;
  if ((i10 | 0) == 0) {
   i8 = -1;
  } else {
   do {
    i10 = i10 + -1 | 0;
    i11 = i7 + i10 | 0;
    if ((HEAP8[i11] | 0) == i9 << 24 >> 24) {
     HEAP8[i11] = i8;
    }
   } while ((i10 | 0) != 0);
   i8 = HEAP32[i4 >> 2] | 0;
   i7 = HEAP32[i8 >> 2] | 0;
   i8 = (HEAP32[i8 + 4 >> 2] | 0) + -1 | 0;
  }
  if ((_luaO_str2d(i7, i8, i3) | 0) != 0) {
   i27 = 287;
   STACKTOP = i1;
   return i27 | 0;
  }
  i1 = HEAP8[i5] | 0;
  i4 = HEAP32[i4 >> 2] | 0;
  i3 = HEAP32[i4 >> 2] | 0;
  i4 = HEAP32[i4 + 4 >> 2] | 0;
  if ((i4 | 0) == 0) {
   _lexerror(i2, 12344, 287);
  } else {
   i6 = i4;
  }
  do {
   i6 = i6 + -1 | 0;
   i4 = i3 + i6 | 0;
   if ((HEAP8[i4] | 0) == i1 << 24 >> 24) {
    HEAP8[i4] = 46;
   }
  } while ((i6 | 0) != 0);
  _lexerror(i2, 12344, 287);
 }
 return 0;
}
function _luaV_execute(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0, d37 = 0.0, d38 = 0.0, d39 = 0.0;
 i12 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i13 = i12 + 24 | 0;
 i10 = i12 + 16 | 0;
 i9 = i12 + 8 | 0;
 i8 = i12;
 i3 = i1 + 16 | 0;
 i4 = i1 + 40 | 0;
 i6 = i1 + 12 | 0;
 i5 = i1 + 8 | 0;
 i11 = i1 + 24 | 0;
 i17 = i1 + 48 | 0;
 i2 = i1 + 20 | 0;
 i16 = i1 + 6 | 0;
 i7 = i1 + 44 | 0;
 i19 = HEAP32[i3 >> 2] | 0;
 L1 : while (1) {
  i22 = HEAP32[HEAP32[i19 >> 2] >> 2] | 0;
  i18 = i22 + 12 | 0;
  i23 = HEAP32[(HEAP32[i18 >> 2] | 0) + 8 >> 2] | 0;
  i20 = i19 + 24 | 0;
  i21 = i19 + 28 | 0;
  i22 = i22 + 16 | 0;
  i24 = i19 + 4 | 0;
  i25 = HEAP32[i20 >> 2] | 0;
  L3 : while (1) {
   i28 = HEAP32[i21 >> 2] | 0;
   HEAP32[i21 >> 2] = i28 + 4;
   i28 = HEAP32[i28 >> 2] | 0;
   i27 = HEAP8[i4] | 0;
   do {
    if (!((i27 & 12) == 0)) {
     i26 = (HEAP32[i17 >> 2] | 0) + -1 | 0;
     HEAP32[i17 >> 2] = i26;
     i26 = (i26 | 0) == 0;
     if (!i26 ? (i27 & 4) == 0 : 0) {
      break;
     }
     i25 = HEAP32[i3 >> 2] | 0;
     i29 = i27 & 255;
     if ((i29 & 8 | 0) == 0 | i26 ^ 1) {
      i27 = 0;
     } else {
      HEAP32[i17 >> 2] = HEAP32[i7 >> 2];
      i27 = 1;
     }
     i26 = i25 + 18 | 0;
     i30 = HEAPU8[i26] | 0;
     if ((i30 & 128 | 0) == 0) {
      if (i27) {
       _luaD_hook(i1, 3, -1);
      }
      do {
       if ((i29 & 4 | 0) == 0) {
        i29 = i25 + 28 | 0;
       } else {
        i34 = HEAP32[(HEAP32[HEAP32[i25 >> 2] >> 2] | 0) + 12 >> 2] | 0;
        i29 = i25 + 28 | 0;
        i32 = HEAP32[i29 >> 2] | 0;
        i35 = HEAP32[i34 + 12 >> 2] | 0;
        i33 = (i32 - i35 >> 2) + -1 | 0;
        i34 = HEAP32[i34 + 20 >> 2] | 0;
        i31 = (i34 | 0) == 0;
        if (i31) {
         i30 = 0;
        } else {
         i30 = HEAP32[i34 + (i33 << 2) >> 2] | 0;
        }
        if ((i33 | 0) != 0 ? (i14 = HEAP32[i2 >> 2] | 0, i32 >>> 0 > i14 >>> 0) : 0) {
         if (i31) {
          i31 = 0;
         } else {
          i31 = HEAP32[i34 + ((i14 - i35 >> 2) + -1 << 2) >> 2] | 0;
         }
         if ((i30 | 0) == (i31 | 0)) {
          break;
         }
        }
        _luaD_hook(i1, 2, i30);
       }
      } while (0);
      HEAP32[i2 >> 2] = HEAP32[i29 >> 2];
      if ((HEAP8[i16] | 0) == 1) {
       i15 = 23;
       break L1;
      }
     } else {
      HEAP8[i26] = i30 & 127;
     }
     i25 = HEAP32[i20 >> 2] | 0;
    }
   } while (0);
   i26 = i28 >>> 6 & 255;
   i27 = i25 + (i26 << 4) | 0;
   switch (i28 & 63 | 0) {
   case 9:
    {
     i28 = HEAP32[i22 + (i28 >>> 23 << 2) >> 2] | 0;
     i35 = HEAP32[i28 + 8 >> 2] | 0;
     i33 = i27;
     i34 = HEAP32[i33 + 4 >> 2] | 0;
     i36 = i35;
     HEAP32[i36 >> 2] = HEAP32[i33 >> 2];
     HEAP32[i36 + 4 >> 2] = i34;
     i36 = i25 + (i26 << 4) + 8 | 0;
     HEAP32[i35 + 8 >> 2] = HEAP32[i36 >> 2];
     if ((HEAP32[i36 >> 2] & 64 | 0) == 0) {
      continue L3;
     }
     i26 = HEAP32[i27 >> 2] | 0;
     if ((HEAP8[i26 + 5 | 0] & 3) == 0) {
      continue L3;
     }
     if ((HEAP8[i28 + 5 | 0] & 4) == 0) {
      continue L3;
     }
     _luaC_barrier_(i1, i28, i26);
     continue L3;
    }
   case 10:
    {
     i26 = i28 >>> 23;
     if ((i26 & 256 | 0) == 0) {
      i26 = i25 + (i26 << 4) | 0;
     } else {
      i26 = i23 + ((i26 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i25 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i25 = i23 + ((i28 & 255) << 4) | 0;
     }
     _luaV_settable(i1, i27, i26, i25);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 17:
    {
     i29 = i28 >>> 23;
     if ((i29 & 256 | 0) == 0) {
      i29 = i25 + (i29 << 4) | 0;
     } else {
      i29 = i23 + ((i29 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i28 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i28 = i23 + ((i28 & 255) << 4) | 0;
     }
     if ((HEAP32[i29 + 8 >> 2] | 0) == 3 ? (HEAP32[i28 + 8 >> 2] | 0) == 3 : 0) {
      d37 = +HEAPF64[i29 >> 3];
      d38 = +HEAPF64[i28 >> 3];
      HEAPF64[i27 >> 3] = d37 - d38 * +Math_floor(+(d37 / d38));
      HEAP32[i25 + (i26 << 4) + 8 >> 2] = 3;
      continue L3;
     }
     _luaV_arith(i1, i27, i29, i28, 10);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 23:
    {
     if ((i26 | 0) != 0) {
      _luaF_close(i1, (HEAP32[i20 >> 2] | 0) + (i26 + -1 << 4) | 0);
     }
     HEAP32[i21 >> 2] = (HEAP32[i21 >> 2] | 0) + ((i28 >>> 14) + -131071 << 2);
     continue L3;
    }
   case 24:
    {
     i27 = i28 >>> 23;
     if ((i27 & 256 | 0) == 0) {
      i27 = i25 + (i27 << 4) | 0;
     } else {
      i27 = i23 + ((i27 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i25 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i25 = i23 + ((i28 & 255) << 4) | 0;
     }
     if ((HEAP32[i27 + 8 >> 2] | 0) == (HEAP32[i25 + 8 >> 2] | 0)) {
      i27 = (_luaV_equalobj_(i1, i27, i25) | 0) != 0;
     } else {
      i27 = 0;
     }
     i25 = HEAP32[i21 >> 2] | 0;
     if ((i27 & 1 | 0) == (i26 | 0)) {
      i26 = HEAP32[i25 >> 2] | 0;
      i27 = i26 >>> 6 & 255;
      if ((i27 | 0) != 0) {
       _luaF_close(i1, (HEAP32[i20 >> 2] | 0) + (i27 + -1 << 4) | 0);
       i25 = HEAP32[i21 >> 2] | 0;
      }
      i25 = i25 + ((i26 >>> 14) + -131070 << 2) | 0;
     } else {
      i25 = i25 + 4 | 0;
     }
     HEAP32[i21 >> 2] = i25;
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 18:
    {
     i29 = i28 >>> 23;
     if ((i29 & 256 | 0) == 0) {
      i29 = i25 + (i29 << 4) | 0;
     } else {
      i29 = i23 + ((i29 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i28 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i28 = i23 + ((i28 & 255) << 4) | 0;
     }
     if ((HEAP32[i29 + 8 >> 2] | 0) == 3 ? (HEAP32[i28 + 8 >> 2] | 0) == 3 : 0) {
      HEAPF64[i27 >> 3] = +Math_pow(+(+HEAPF64[i29 >> 3]), +(+HEAPF64[i28 >> 3]));
      HEAP32[i25 + (i26 << 4) + 8 >> 2] = 3;
      continue L3;
     }
     _luaV_arith(i1, i27, i29, i28, 11);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 1:
    {
     i36 = i28 >>> 14;
     i33 = i23 + (i36 << 4) | 0;
     i34 = HEAP32[i33 + 4 >> 2] | 0;
     i35 = i27;
     HEAP32[i35 >> 2] = HEAP32[i33 >> 2];
     HEAP32[i35 + 4 >> 2] = i34;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = HEAP32[i23 + (i36 << 4) + 8 >> 2];
     continue L3;
    }
   case 0:
    {
     i36 = i28 >>> 23;
     i33 = i25 + (i36 << 4) | 0;
     i34 = HEAP32[i33 + 4 >> 2] | 0;
     i35 = i27;
     HEAP32[i35 >> 2] = HEAP32[i33 >> 2];
     HEAP32[i35 + 4 >> 2] = i34;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = HEAP32[i25 + (i36 << 4) + 8 >> 2];
     continue L3;
    }
   case 2:
    {
     i36 = HEAP32[i21 >> 2] | 0;
     HEAP32[i21 >> 2] = i36 + 4;
     i36 = (HEAP32[i36 >> 2] | 0) >>> 6;
     i33 = i23 + (i36 << 4) | 0;
     i34 = HEAP32[i33 + 4 >> 2] | 0;
     i35 = i27;
     HEAP32[i35 >> 2] = HEAP32[i33 >> 2];
     HEAP32[i35 + 4 >> 2] = i34;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = HEAP32[i23 + (i36 << 4) + 8 >> 2];
     continue L3;
    }
   case 5:
    {
     i36 = HEAP32[(HEAP32[i22 + (i28 >>> 23 << 2) >> 2] | 0) + 8 >> 2] | 0;
     i33 = i36;
     i34 = HEAP32[i33 + 4 >> 2] | 0;
     i35 = i27;
     HEAP32[i35 >> 2] = HEAP32[i33 >> 2];
     HEAP32[i35 + 4 >> 2] = i34;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = HEAP32[i36 + 8 >> 2];
     continue L3;
    }
   case 3:
    {
     HEAP32[i27 >> 2] = i28 >>> 23;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = 1;
     if ((i28 & 8372224 | 0) == 0) {
      continue L3;
     }
     HEAP32[i21 >> 2] = (HEAP32[i21 >> 2] | 0) + 4;
     continue L3;
    }
   case 7:
    {
     i26 = i28 >>> 14;
     if ((i26 & 256 | 0) == 0) {
      i26 = i25 + ((i26 & 511) << 4) | 0;
     } else {
      i26 = i23 + ((i26 & 255) << 4) | 0;
     }
     _luaV_gettable(i1, i25 + (i28 >>> 23 << 4) | 0, i26, i27);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 12:
    {
     i36 = i28 >>> 23;
     i29 = i25 + (i36 << 4) | 0;
     i26 = i26 + 1 | 0;
     i33 = i29;
     i34 = HEAP32[i33 + 4 >> 2] | 0;
     i35 = i25 + (i26 << 4) | 0;
     HEAP32[i35 >> 2] = HEAP32[i33 >> 2];
     HEAP32[i35 + 4 >> 2] = i34;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = HEAP32[i25 + (i36 << 4) + 8 >> 2];
     i26 = i28 >>> 14;
     if ((i26 & 256 | 0) == 0) {
      i25 = i25 + ((i26 & 511) << 4) | 0;
     } else {
      i25 = i23 + ((i26 & 255) << 4) | 0;
     }
     _luaV_gettable(i1, i29, i25, i27);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 13:
    {
     i29 = i28 >>> 23;
     if ((i29 & 256 | 0) == 0) {
      i29 = i25 + (i29 << 4) | 0;
     } else {
      i29 = i23 + ((i29 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i28 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i28 = i23 + ((i28 & 255) << 4) | 0;
     }
     if ((HEAP32[i29 + 8 >> 2] | 0) == 3 ? (HEAP32[i28 + 8 >> 2] | 0) == 3 : 0) {
      HEAPF64[i27 >> 3] = +HEAPF64[i29 >> 3] + +HEAPF64[i28 >> 3];
      HEAP32[i25 + (i26 << 4) + 8 >> 2] = 3;
      continue L3;
     }
     _luaV_arith(i1, i27, i29, i28, 6);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 14:
    {
     i29 = i28 >>> 23;
     if ((i29 & 256 | 0) == 0) {
      i29 = i25 + (i29 << 4) | 0;
     } else {
      i29 = i23 + ((i29 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i28 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i28 = i23 + ((i28 & 255) << 4) | 0;
     }
     if ((HEAP32[i29 + 8 >> 2] | 0) == 3 ? (HEAP32[i28 + 8 >> 2] | 0) == 3 : 0) {
      HEAPF64[i27 >> 3] = +HEAPF64[i29 >> 3] - +HEAPF64[i28 >> 3];
      HEAP32[i25 + (i26 << 4) + 8 >> 2] = 3;
      continue L3;
     }
     _luaV_arith(i1, i27, i29, i28, 7);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 6:
    {
     i26 = i28 >>> 14;
     if ((i26 & 256 | 0) == 0) {
      i25 = i25 + ((i26 & 511) << 4) | 0;
     } else {
      i25 = i23 + ((i26 & 255) << 4) | 0;
     }
     _luaV_gettable(i1, HEAP32[(HEAP32[i22 + (i28 >>> 23 << 2) >> 2] | 0) + 8 >> 2] | 0, i25, i27);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 4:
    {
     i26 = i28 >>> 23;
     while (1) {
      HEAP32[i27 + 8 >> 2] = 0;
      if ((i26 | 0) == 0) {
       continue L3;
      } else {
       i26 = i26 + -1 | 0;
       i27 = i27 + 16 | 0;
      }
     }
    }
   case 8:
    {
     i27 = i28 >>> 23;
     if ((i27 & 256 | 0) == 0) {
      i27 = i25 + (i27 << 4) | 0;
     } else {
      i27 = i23 + ((i27 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i25 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i25 = i23 + ((i28 & 255) << 4) | 0;
     }
     _luaV_settable(i1, HEAP32[(HEAP32[i22 + (i26 << 2) >> 2] | 0) + 8 >> 2] | 0, i27, i25);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 11:
    {
     i29 = i28 >>> 23;
     i28 = i28 >>> 14 & 511;
     i30 = _luaH_new(i1) | 0;
     HEAP32[i27 >> 2] = i30;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = 69;
     if ((i28 | i29 | 0) != 0) {
      i36 = _luaO_fb2int(i29) | 0;
      _luaH_resize(i1, i30, i36, _luaO_fb2int(i28) | 0);
     }
     if ((HEAP32[(HEAP32[i6 >> 2] | 0) + 12 >> 2] | 0) > 0) {
      HEAP32[i5 >> 2] = i25 + (i26 + 1 << 4);
      _luaC_step(i1);
      HEAP32[i5 >> 2] = HEAP32[i24 >> 2];
     }
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 19:
    {
     i36 = i28 >>> 23;
     i28 = i25 + (i36 << 4) | 0;
     if ((HEAP32[i25 + (i36 << 4) + 8 >> 2] | 0) == 3) {
      HEAPF64[i27 >> 3] = -+HEAPF64[i28 >> 3];
      HEAP32[i25 + (i26 << 4) + 8 >> 2] = 3;
      continue L3;
     } else {
      _luaV_arith(i1, i27, i28, i28, 12);
      i25 = HEAP32[i20 >> 2] | 0;
      continue L3;
     }
    }
   case 15:
    {
     i29 = i28 >>> 23;
     if ((i29 & 256 | 0) == 0) {
      i29 = i25 + (i29 << 4) | 0;
     } else {
      i29 = i23 + ((i29 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i28 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i28 = i23 + ((i28 & 255) << 4) | 0;
     }
     if ((HEAP32[i29 + 8 >> 2] | 0) == 3 ? (HEAP32[i28 + 8 >> 2] | 0) == 3 : 0) {
      HEAPF64[i27 >> 3] = +HEAPF64[i29 >> 3] * +HEAPF64[i28 >> 3];
      HEAP32[i25 + (i26 << 4) + 8 >> 2] = 3;
      continue L3;
     }
     _luaV_arith(i1, i27, i29, i28, 8);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 16:
    {
     i29 = i28 >>> 23;
     if ((i29 & 256 | 0) == 0) {
      i29 = i25 + (i29 << 4) | 0;
     } else {
      i29 = i23 + ((i29 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i28 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i28 = i23 + ((i28 & 255) << 4) | 0;
     }
     if ((HEAP32[i29 + 8 >> 2] | 0) == 3 ? (HEAP32[i28 + 8 >> 2] | 0) == 3 : 0) {
      HEAPF64[i27 >> 3] = +HEAPF64[i29 >> 3] / +HEAPF64[i28 >> 3];
      HEAP32[i25 + (i26 << 4) + 8 >> 2] = 3;
      continue L3;
     }
     _luaV_arith(i1, i27, i29, i28, 9);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 20:
    {
     i29 = i28 >>> 23;
     i28 = HEAP32[i25 + (i29 << 4) + 8 >> 2] | 0;
     if ((i28 | 0) != 0) {
      if ((i28 | 0) == 1) {
       i28 = (HEAP32[i25 + (i29 << 4) >> 2] | 0) == 0;
      } else {
       i28 = 0;
      }
     } else {
      i28 = 1;
     }
     HEAP32[i27 >> 2] = i28 & 1;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = 1;
     continue L3;
    }
   case 21:
    {
     _luaV_objlen(i1, i27, i25 + (i28 >>> 23 << 4) | 0);
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 22:
    {
     i27 = i28 >>> 23;
     i28 = i28 >>> 14 & 511;
     HEAP32[i5 >> 2] = i25 + (i28 + 1 << 4);
     _luaV_concat(i1, 1 - i27 + i28 | 0);
     i25 = HEAP32[i20 >> 2] | 0;
     i28 = i25 + (i27 << 4) | 0;
     i34 = i28;
     i35 = HEAP32[i34 + 4 >> 2] | 0;
     i36 = i25 + (i26 << 4) | 0;
     HEAP32[i36 >> 2] = HEAP32[i34 >> 2];
     HEAP32[i36 + 4 >> 2] = i35;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = HEAP32[i25 + (i27 << 4) + 8 >> 2];
     if ((HEAP32[(HEAP32[i6 >> 2] | 0) + 12 >> 2] | 0) > 0) {
      if (!(i26 >>> 0 < i27 >>> 0)) {
       i28 = i25 + (i26 + 1 << 4) | 0;
      }
      HEAP32[i5 >> 2] = i28;
      _luaC_step(i1);
      HEAP32[i5 >> 2] = HEAP32[i24 >> 2];
     }
     i25 = HEAP32[i20 >> 2] | 0;
     HEAP32[i5 >> 2] = HEAP32[i24 >> 2];
     continue L3;
    }
   case 25:
    {
     i27 = i28 >>> 23;
     if ((i27 & 256 | 0) == 0) {
      i27 = i25 + (i27 << 4) | 0;
     } else {
      i27 = i23 + ((i27 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i25 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i25 = i23 + ((i28 & 255) << 4) | 0;
     }
     i36 = (_luaV_lessthan(i1, i27, i25) | 0) == (i26 | 0);
     i26 = HEAP32[i21 >> 2] | 0;
     if (i36) {
      i25 = HEAP32[i26 >> 2] | 0;
      i27 = i25 >>> 6 & 255;
      if ((i27 | 0) != 0) {
       _luaF_close(i1, (HEAP32[i20 >> 2] | 0) + (i27 + -1 << 4) | 0);
       i26 = HEAP32[i21 >> 2] | 0;
      }
      i25 = i26 + ((i25 >>> 14) + -131070 << 2) | 0;
     } else {
      i25 = i26 + 4 | 0;
     }
     HEAP32[i21 >> 2] = i25;
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 27:
    {
     i29 = HEAP32[i25 + (i26 << 4) + 8 >> 2] | 0;
     i26 = (i29 | 0) == 0;
     if ((i28 & 8372224 | 0) == 0) {
      if (!i26) {
       if (!((i29 | 0) == 1 ? (HEAP32[i27 >> 2] | 0) == 0 : 0)) {
        i15 = 192;
       }
      }
     } else {
      if (!i26) {
       if ((i29 | 0) == 1 ? (HEAP32[i27 >> 2] | 0) == 0 : 0) {
        i15 = 192;
       }
      } else {
       i15 = 192;
      }
     }
     if ((i15 | 0) == 192) {
      i15 = 0;
      HEAP32[i21 >> 2] = (HEAP32[i21 >> 2] | 0) + 4;
      continue L3;
     }
     i27 = HEAP32[i21 >> 2] | 0;
     i26 = HEAP32[i27 >> 2] | 0;
     i28 = i26 >>> 6 & 255;
     if ((i28 | 0) != 0) {
      _luaF_close(i1, (HEAP32[i20 >> 2] | 0) + (i28 + -1 << 4) | 0);
      i27 = HEAP32[i21 >> 2] | 0;
     }
     HEAP32[i21 >> 2] = i27 + ((i26 >>> 14) + -131070 << 2);
     continue L3;
    }
   case 26:
    {
     i27 = i28 >>> 23;
     if ((i27 & 256 | 0) == 0) {
      i27 = i25 + (i27 << 4) | 0;
     } else {
      i27 = i23 + ((i27 & 255) << 4) | 0;
     }
     i28 = i28 >>> 14;
     if ((i28 & 256 | 0) == 0) {
      i25 = i25 + ((i28 & 511) << 4) | 0;
     } else {
      i25 = i23 + ((i28 & 255) << 4) | 0;
     }
     i36 = (_luaV_lessequal(i1, i27, i25) | 0) == (i26 | 0);
     i26 = HEAP32[i21 >> 2] | 0;
     if (i36) {
      i25 = HEAP32[i26 >> 2] | 0;
      i27 = i25 >>> 6 & 255;
      if ((i27 | 0) != 0) {
       _luaF_close(i1, (HEAP32[i20 >> 2] | 0) + (i27 + -1 << 4) | 0);
       i26 = HEAP32[i21 >> 2] | 0;
      }
      i25 = i26 + ((i25 >>> 14) + -131070 << 2) | 0;
     } else {
      i25 = i26 + 4 | 0;
     }
     HEAP32[i21 >> 2] = i25;
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 28:
    {
     i30 = i28 >>> 23;
     i29 = i25 + (i30 << 4) | 0;
     i30 = HEAP32[i25 + (i30 << 4) + 8 >> 2] | 0;
     i31 = (i30 | 0) == 0;
     if ((i28 & 8372224 | 0) == 0) {
      if (!i31) {
       if (!((i30 | 0) == 1 ? (HEAP32[i29 >> 2] | 0) == 0 : 0)) {
        i15 = 203;
       }
      }
     } else {
      if (!i31) {
       if ((i30 | 0) == 1 ? (HEAP32[i29 >> 2] | 0) == 0 : 0) {
        i15 = 203;
       }
      } else {
       i15 = 203;
      }
     }
     if ((i15 | 0) == 203) {
      i15 = 0;
      HEAP32[i21 >> 2] = (HEAP32[i21 >> 2] | 0) + 4;
      continue L3;
     }
     i36 = i29;
     i28 = HEAP32[i36 + 4 >> 2] | 0;
     HEAP32[i27 >> 2] = HEAP32[i36 >> 2];
     HEAP32[i27 + 4 >> 2] = i28;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = i30;
     i27 = HEAP32[i21 >> 2] | 0;
     i26 = HEAP32[i27 >> 2] | 0;
     i28 = i26 >>> 6 & 255;
     if ((i28 | 0) != 0) {
      _luaF_close(i1, (HEAP32[i20 >> 2] | 0) + (i28 + -1 << 4) | 0);
      i27 = HEAP32[i21 >> 2] | 0;
     }
     HEAP32[i21 >> 2] = i27 + ((i26 >>> 14) + -131070 << 2);
     continue L3;
    }
   case 30:
    {
     i28 = i28 >>> 23;
     if ((i28 | 0) != 0) {
      HEAP32[i5 >> 2] = i25 + (i26 + i28 << 4);
     }
     if ((_luaD_precall(i1, i27, -1) | 0) == 0) {
      i15 = 218;
      break L3;
     }
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 29:
    {
     i29 = i28 >>> 23;
     i28 = i28 >>> 14 & 511;
     if ((i29 | 0) != 0) {
      HEAP32[i5 >> 2] = i25 + (i26 + i29 << 4);
     }
     if ((_luaD_precall(i1, i27, i28 + -1 | 0) | 0) == 0) {
      i15 = 213;
      break L3;
     }
     if ((i28 | 0) != 0) {
      HEAP32[i5 >> 2] = HEAP32[i24 >> 2];
     }
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 32:
    {
     d39 = +HEAPF64[i25 + (i26 + 2 << 4) >> 3];
     d38 = d39 + +HEAPF64[i27 >> 3];
     d37 = +HEAPF64[i25 + (i26 + 1 << 4) >> 3];
     if (d39 > 0.0) {
      if (!(d38 <= d37)) {
       continue L3;
      }
     } else {
      if (!(d37 <= d38)) {
       continue L3;
      }
     }
     HEAP32[i21 >> 2] = (HEAP32[i21 >> 2] | 0) + ((i28 >>> 14) + -131071 << 2);
     HEAPF64[i27 >> 3] = d38;
     HEAP32[i25 + (i26 << 4) + 8 >> 2] = 3;
     i36 = i26 + 3 | 0;
     HEAPF64[i25 + (i36 << 4) >> 3] = d38;
     HEAP32[i25 + (i36 << 4) + 8 >> 2] = 3;
     continue L3;
    }
   case 33:
    {
     i32 = i26 + 1 | 0;
     i30 = i25 + (i32 << 4) | 0;
     i31 = i26 + 2 | 0;
     i29 = i25 + (i31 << 4) | 0;
     i26 = i25 + (i26 << 4) + 8 | 0;
     i33 = HEAP32[i26 >> 2] | 0;
     if ((i33 | 0) != 3) {
      if ((i33 & 15 | 0) != 4) {
       i15 = 239;
       break L1;
      }
      i36 = HEAP32[i27 >> 2] | 0;
      if ((_luaO_str2d(i36 + 16 | 0, HEAP32[i36 + 12 >> 2] | 0, i8) | 0) == 0) {
       i15 = 239;
       break L1;
      }
      HEAPF64[i27 >> 3] = +HEAPF64[i8 >> 3];
      HEAP32[i26 >> 2] = 3;
      if ((i27 | 0) == 0) {
       i15 = 239;
       break L1;
      }
     }
     i33 = i25 + (i32 << 4) + 8 | 0;
     i32 = HEAP32[i33 >> 2] | 0;
     if ((i32 | 0) != 3) {
      if ((i32 & 15 | 0) != 4) {
       i15 = 244;
       break L1;
      }
      i36 = HEAP32[i30 >> 2] | 0;
      if ((_luaO_str2d(i36 + 16 | 0, HEAP32[i36 + 12 >> 2] | 0, i9) | 0) == 0) {
       i15 = 244;
       break L1;
      }
      HEAPF64[i30 >> 3] = +HEAPF64[i9 >> 3];
      HEAP32[i33 >> 2] = 3;
     }
     i31 = i25 + (i31 << 4) + 8 | 0;
     i30 = HEAP32[i31 >> 2] | 0;
     if ((i30 | 0) != 3) {
      if ((i30 & 15 | 0) != 4) {
       i15 = 249;
       break L1;
      }
      i36 = HEAP32[i29 >> 2] | 0;
      if ((_luaO_str2d(i36 + 16 | 0, HEAP32[i36 + 12 >> 2] | 0, i10) | 0) == 0) {
       i15 = 249;
       break L1;
      }
      HEAPF64[i29 >> 3] = +HEAPF64[i10 >> 3];
      HEAP32[i31 >> 2] = 3;
     }
     HEAPF64[i27 >> 3] = +HEAPF64[i27 >> 3] - +HEAPF64[i29 >> 3];
     HEAP32[i26 >> 2] = 3;
     HEAP32[i21 >> 2] = (HEAP32[i21 >> 2] | 0) + ((i28 >>> 14) + -131071 << 2);
     continue L3;
    }
   case 31:
    {
     i15 = 223;
     break L3;
    }
   case 34:
    {
     i35 = i26 + 3 | 0;
     i36 = i25 + (i35 << 4) | 0;
     i33 = i26 + 2 | 0;
     i34 = i26 + 5 | 0;
     i32 = i25 + (i33 << 4) | 0;
     i31 = HEAP32[i32 + 4 >> 2] | 0;
     i30 = i25 + (i34 << 4) | 0;
     HEAP32[i30 >> 2] = HEAP32[i32 >> 2];
     HEAP32[i30 + 4 >> 2] = i31;
     HEAP32[i25 + (i34 << 4) + 8 >> 2] = HEAP32[i25 + (i33 << 4) + 8 >> 2];
     i34 = i26 + 1 | 0;
     i33 = i26 + 4 | 0;
     i30 = i25 + (i34 << 4) | 0;
     i31 = HEAP32[i30 + 4 >> 2] | 0;
     i32 = i25 + (i33 << 4) | 0;
     HEAP32[i32 >> 2] = HEAP32[i30 >> 2];
     HEAP32[i32 + 4 >> 2] = i31;
     HEAP32[i25 + (i33 << 4) + 8 >> 2] = HEAP32[i25 + (i34 << 4) + 8 >> 2];
     i33 = i27;
     i34 = HEAP32[i33 + 4 >> 2] | 0;
     i27 = i36;
     HEAP32[i27 >> 2] = HEAP32[i33 >> 2];
     HEAP32[i27 + 4 >> 2] = i34;
     HEAP32[i25 + (i35 << 4) + 8 >> 2] = HEAP32[i25 + (i26 << 4) + 8 >> 2];
     HEAP32[i5 >> 2] = i25 + (i26 + 6 << 4);
     _luaD_call(i1, i36, i28 >>> 14 & 511, 1);
     i36 = HEAP32[i20 >> 2] | 0;
     HEAP32[i5 >> 2] = HEAP32[i24 >> 2];
     i27 = HEAP32[i21 >> 2] | 0;
     HEAP32[i21 >> 2] = i27 + 4;
     i27 = HEAP32[i27 >> 2] | 0;
     i25 = i36;
     i28 = i27;
     i27 = i36 + ((i27 >>> 6 & 255) << 4) | 0;
     break;
    }
   case 35:
    {
     break;
    }
   case 36:
    {
     i29 = i28 >>> 23;
     i28 = i28 >>> 14 & 511;
     if ((i29 | 0) == 0) {
      i29 = ((HEAP32[i5 >> 2] | 0) - i27 >> 4) + -1 | 0;
     }
     if ((i28 | 0) == 0) {
      i28 = HEAP32[i21 >> 2] | 0;
      HEAP32[i21 >> 2] = i28 + 4;
      i28 = (HEAP32[i28 >> 2] | 0) >>> 6;
     }
     i27 = HEAP32[i27 >> 2] | 0;
     i30 = i29 + -50 + (i28 * 50 | 0) | 0;
     if ((i30 | 0) > (HEAP32[i27 + 28 >> 2] | 0)) {
      _luaH_resizearray(i1, i27, i30);
     }
     if ((i29 | 0) > 0) {
      i28 = i27 + 5 | 0;
      while (1) {
       i36 = i29 + i26 | 0;
       i32 = i25 + (i36 << 4) | 0;
       i31 = i30 + -1 | 0;
       _luaH_setint(i1, i27, i30, i32);
       if (((HEAP32[i25 + (i36 << 4) + 8 >> 2] & 64 | 0) != 0 ? !((HEAP8[(HEAP32[i32 >> 2] | 0) + 5 | 0] & 3) == 0) : 0) ? !((HEAP8[i28] & 4) == 0) : 0) {
        _luaC_barrierback_(i1, i27);
       }
       i29 = i29 + -1 | 0;
       if ((i29 | 0) > 0) {
        i30 = i31;
       } else {
        break;
       }
      }
     }
     HEAP32[i5 >> 2] = HEAP32[i24 >> 2];
     continue L3;
    }
   case 37:
    {
     i29 = HEAP32[(HEAP32[(HEAP32[i18 >> 2] | 0) + 16 >> 2] | 0) + (i28 >>> 14 << 2) >> 2] | 0;
     i28 = i29 + 32 | 0;
     i33 = HEAP32[i28 >> 2] | 0;
     i30 = HEAP32[i29 + 40 >> 2] | 0;
     i31 = HEAP32[i29 + 28 >> 2] | 0;
     L323 : do {
      if ((i33 | 0) == 0) {
       i15 = 276;
      } else {
       if ((i30 | 0) > 0) {
        i34 = i33 + 16 | 0;
        i32 = 0;
        while (1) {
         i35 = HEAPU8[i31 + (i32 << 3) + 5 | 0] | 0;
         if ((HEAP8[i31 + (i32 << 3) + 4 | 0] | 0) == 0) {
          i36 = HEAP32[(HEAP32[i22 + (i35 << 2) >> 2] | 0) + 8 >> 2] | 0;
         } else {
          i36 = i25 + (i35 << 4) | 0;
         }
         i35 = i32 + 1 | 0;
         if ((HEAP32[(HEAP32[i34 + (i32 << 2) >> 2] | 0) + 8 >> 2] | 0) != (i36 | 0)) {
          i15 = 276;
          break L323;
         }
         if ((i35 | 0) < (i30 | 0)) {
          i32 = i35;
         } else {
          break;
         }
        }
       }
       HEAP32[i27 >> 2] = i33;
       HEAP32[i25 + (i26 << 4) + 8 >> 2] = 70;
      }
     } while (0);
     if ((i15 | 0) == 276) {
      i15 = 0;
      i32 = _luaF_newLclosure(i1, i30) | 0;
      HEAP32[i32 + 12 >> 2] = i29;
      HEAP32[i27 >> 2] = i32;
      HEAP32[i25 + (i26 << 4) + 8 >> 2] = 70;
      if ((i30 | 0) > 0) {
       i27 = i32 + 16 | 0;
       i34 = 0;
       do {
        i33 = HEAPU8[i31 + (i34 << 3) + 5 | 0] | 0;
        if ((HEAP8[i31 + (i34 << 3) + 4 | 0] | 0) == 0) {
         HEAP32[i27 + (i34 << 2) >> 2] = HEAP32[i22 + (i33 << 2) >> 2];
        } else {
         HEAP32[i27 + (i34 << 2) >> 2] = _luaF_findupval(i1, i25 + (i33 << 4) | 0) | 0;
        }
        i34 = i34 + 1 | 0;
       } while ((i34 | 0) != (i30 | 0));
      }
      if (!((HEAP8[i29 + 5 | 0] & 4) == 0)) {
       _luaC_barrierproto_(i1, i29, i32);
      }
      HEAP32[i28 >> 2] = i32;
     }
     if ((HEAP32[(HEAP32[i6 >> 2] | 0) + 12 >> 2] | 0) > 0) {
      HEAP32[i5 >> 2] = i25 + (i26 + 1 << 4);
      _luaC_step(i1);
      HEAP32[i5 >> 2] = HEAP32[i24 >> 2];
     }
     i25 = HEAP32[i20 >> 2] | 0;
     continue L3;
    }
   case 38:
    {
     i36 = i28 >>> 23;
     i29 = i36 + -1 | 0;
     i30 = (i25 - (HEAP32[i19 >> 2] | 0) >> 4) - (HEAPU8[(HEAP32[i18 >> 2] | 0) + 76 | 0] | 0) | 0;
     i28 = i30 + -1 | 0;
     if ((i36 | 0) == 0) {
      if (((HEAP32[i11 >> 2] | 0) - (HEAP32[i5 >> 2] | 0) >> 4 | 0) <= (i28 | 0)) {
       _luaD_growstack(i1, i28);
      }
      i27 = HEAP32[i20 >> 2] | 0;
      HEAP32[i5 >> 2] = i27 + (i28 + i26 << 4);
      i29 = i28;
      i25 = i27;
      i27 = i27 + (i26 << 4) | 0;
     }
     if ((i29 | 0) <= 0) {
      continue L3;
     }
     i26 = 1 - i30 | 0;
     i30 = 0;
     while (1) {
      if ((i30 | 0) < (i28 | 0)) {
       i36 = i30 + i26 | 0;
       i33 = i25 + (i36 << 4) | 0;
       i34 = HEAP32[i33 + 4 >> 2] | 0;
       i35 = i27 + (i30 << 4) | 0;
       HEAP32[i35 >> 2] = HEAP32[i33 >> 2];
       HEAP32[i35 + 4 >> 2] = i34;
       HEAP32[i27 + (i30 << 4) + 8 >> 2] = HEAP32[i25 + (i36 << 4) + 8 >> 2];
      } else {
       HEAP32[i27 + (i30 << 4) + 8 >> 2] = 0;
      }
      i30 = i30 + 1 | 0;
      if ((i30 | 0) == (i29 | 0)) {
       continue L3;
      }
     }
    }
   default:
    {
     continue L3;
    }
   }
   i26 = HEAP32[i27 + 24 >> 2] | 0;
   if ((i26 | 0) == 0) {
    continue;
   }
   i34 = i27 + 16 | 0;
   i35 = HEAP32[i34 + 4 >> 2] | 0;
   i36 = i27;
   HEAP32[i36 >> 2] = HEAP32[i34 >> 2];
   HEAP32[i36 + 4 >> 2] = i35;
   HEAP32[i27 + 8 >> 2] = i26;
   HEAP32[i21 >> 2] = (HEAP32[i21 >> 2] | 0) + ((i28 >>> 14) + -131071 << 2);
  }
  if ((i15 | 0) == 213) {
   i15 = 0;
   i19 = HEAP32[i3 >> 2] | 0;
   i36 = i19 + 18 | 0;
   HEAP8[i36] = HEAPU8[i36] | 4;
   continue;
  } else if ((i15 | 0) == 218) {
   i15 = 0;
   i22 = HEAP32[i3 >> 2] | 0;
   i19 = HEAP32[i22 + 8 >> 2] | 0;
   i23 = HEAP32[i22 >> 2] | 0;
   i24 = HEAP32[i19 >> 2] | 0;
   i20 = i22 + 24 | 0;
   i21 = (HEAP32[i20 >> 2] | 0) + (HEAPU8[(HEAP32[(HEAP32[i23 >> 2] | 0) + 12 >> 2] | 0) + 76 | 0] << 4) | 0;
   if ((HEAP32[(HEAP32[i18 >> 2] | 0) + 56 >> 2] | 0) > 0) {
    _luaF_close(i1, HEAP32[i19 + 24 >> 2] | 0);
   }
   if (i23 >>> 0 < i21 >>> 0) {
    i25 = i23;
    i18 = 0;
    do {
     i34 = i25;
     i35 = HEAP32[i34 + 4 >> 2] | 0;
     i36 = i24 + (i18 << 4) | 0;
     HEAP32[i36 >> 2] = HEAP32[i34 >> 2];
     HEAP32[i36 + 4 >> 2] = i35;
     HEAP32[i24 + (i18 << 4) + 8 >> 2] = HEAP32[i23 + (i18 << 4) + 8 >> 2];
     i18 = i18 + 1 | 0;
     i25 = i23 + (i18 << 4) | 0;
    } while (i25 >>> 0 < i21 >>> 0);
   }
   i36 = i23;
   HEAP32[i19 + 24 >> 2] = i24 + ((HEAP32[i20 >> 2] | 0) - i36 >> 4 << 4);
   i36 = i24 + ((HEAP32[i5 >> 2] | 0) - i36 >> 4 << 4) | 0;
   HEAP32[i5 >> 2] = i36;
   HEAP32[i19 + 4 >> 2] = i36;
   HEAP32[i19 + 28 >> 2] = HEAP32[i22 + 28 >> 2];
   i36 = i19 + 18 | 0;
   HEAP8[i36] = HEAPU8[i36] | 64;
   HEAP32[i3 >> 2] = i19;
   continue;
  } else if ((i15 | 0) == 223) {
   i15 = 0;
   i20 = i28 >>> 23;
   if ((i20 | 0) != 0) {
    HEAP32[i5 >> 2] = i25 + (i20 + -1 + i26 << 4);
   }
   if ((HEAP32[(HEAP32[i18 >> 2] | 0) + 56 >> 2] | 0) > 0) {
    _luaF_close(i1, i25);
   }
   i18 = _luaD_poscall(i1, i27) | 0;
   if ((HEAP8[i19 + 18 | 0] & 4) == 0) {
    i15 = 228;
    break;
   }
   i19 = HEAP32[i3 >> 2] | 0;
   if ((i18 | 0) == 0) {
    continue;
   }
   HEAP32[i5 >> 2] = HEAP32[i19 + 4 >> 2];
   continue;
  }
 }
 if ((i15 | 0) == 23) {
  if (!i27) {
   i36 = HEAP32[i29 >> 2] | 0;
   i36 = i36 + -4 | 0;
   HEAP32[i29 >> 2] = i36;
   i36 = HEAP8[i26] | 0;
   i36 = i36 & 255;
   i36 = i36 | 128;
   i36 = i36 & 255;
   HEAP8[i26] = i36;
   i36 = HEAP32[i5 >> 2] | 0;
   i36 = i36 + -16 | 0;
   HEAP32[i25 >> 2] = i36;
   _luaD_throw(i1, 1);
  }
  HEAP32[i17 >> 2] = 1;
  i36 = HEAP32[i29 >> 2] | 0;
  i36 = i36 + -4 | 0;
  HEAP32[i29 >> 2] = i36;
  i36 = HEAP8[i26] | 0;
  i36 = i36 & 255;
  i36 = i36 | 128;
  i36 = i36 & 255;
  HEAP8[i26] = i36;
  i36 = HEAP32[i5 >> 2] | 0;
  i36 = i36 + -16 | 0;
  HEAP32[i25 >> 2] = i36;
  _luaD_throw(i1, 1);
 } else if ((i15 | 0) == 228) {
  STACKTOP = i12;
  return;
 } else if ((i15 | 0) == 239) {
  _luaG_runerror(i1, 9040, i13);
 } else if ((i15 | 0) == 244) {
  _luaG_runerror(i1, 9080, i13);
 } else if ((i15 | 0) == 249) {
  _luaG_runerror(i1, 9112, i13);
 }
}
function ___floatscan(i8, i2, i11) {
 i8 = i8 | 0;
 i2 = i2 | 0;
 i11 = i11 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i9 = 0, i10 = 0, i12 = 0, i13 = 0, d14 = 0.0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, d28 = 0.0, i29 = 0, d30 = 0.0, d31 = 0.0, d32 = 0.0, d33 = 0.0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 512 | 0;
 i5 = i1;
 if ((i2 | 0) == 1) {
  i2 = 53;
  i3 = -1074;
 } else if ((i2 | 0) == 2) {
  i2 = 53;
  i3 = -1074;
 } else if ((i2 | 0) == 0) {
  i2 = 24;
  i3 = -149;
 } else {
  d31 = 0.0;
  STACKTOP = i1;
  return +d31;
 }
 i9 = i8 + 4 | 0;
 i10 = i8 + 100 | 0;
 do {
  i4 = HEAP32[i9 >> 2] | 0;
  if (i4 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
   HEAP32[i9 >> 2] = i4 + 1;
   i21 = HEAPU8[i4] | 0;
  } else {
   i21 = ___shgetc(i8) | 0;
  }
 } while ((_isspace(i21 | 0) | 0) != 0);
 do {
  if ((i21 | 0) == 43 | (i21 | 0) == 45) {
   i4 = 1 - (((i21 | 0) == 45) << 1) | 0;
   i7 = HEAP32[i9 >> 2] | 0;
   if (i7 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
    HEAP32[i9 >> 2] = i7 + 1;
    i21 = HEAPU8[i7] | 0;
    break;
   } else {
    i21 = ___shgetc(i8) | 0;
    break;
   }
  } else {
   i4 = 1;
  }
 } while (0);
 i7 = 0;
 do {
  if ((i21 | 32 | 0) != (HEAP8[13408 + i7 | 0] | 0)) {
   break;
  }
  do {
   if (i7 >>> 0 < 7) {
    i12 = HEAP32[i9 >> 2] | 0;
    if (i12 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
     HEAP32[i9 >> 2] = i12 + 1;
     i21 = HEAPU8[i12] | 0;
     break;
    } else {
     i21 = ___shgetc(i8) | 0;
     break;
    }
   }
  } while (0);
  i7 = i7 + 1 | 0;
 } while (i7 >>> 0 < 8);
 do {
  if ((i7 | 0) == 3) {
   i13 = 23;
  } else if ((i7 | 0) != 8) {
   i12 = (i11 | 0) == 0;
   if (!(i7 >>> 0 < 4 | i12)) {
    if ((i7 | 0) == 8) {
     break;
    } else {
     i13 = 23;
     break;
    }
   }
   L34 : do {
    if ((i7 | 0) == 0) {
     i7 = 0;
     do {
      if ((i21 | 32 | 0) != (HEAP8[13424 + i7 | 0] | 0)) {
       break L34;
      }
      do {
       if (i7 >>> 0 < 2) {
        i15 = HEAP32[i9 >> 2] | 0;
        if (i15 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
         HEAP32[i9 >> 2] = i15 + 1;
         i21 = HEAPU8[i15] | 0;
         break;
        } else {
         i21 = ___shgetc(i8) | 0;
         break;
        }
       }
      } while (0);
      i7 = i7 + 1 | 0;
     } while (i7 >>> 0 < 3);
    }
   } while (0);
   if ((i7 | 0) == 0) {
    do {
     if ((i21 | 0) == 48) {
      i7 = HEAP32[i9 >> 2] | 0;
      if (i7 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
       HEAP32[i9 >> 2] = i7 + 1;
       i7 = HEAPU8[i7] | 0;
      } else {
       i7 = ___shgetc(i8) | 0;
      }
      if ((i7 | 32 | 0) != 120) {
       if ((HEAP32[i10 >> 2] | 0) == 0) {
        i21 = 48;
        break;
       }
       HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
       i21 = 48;
       break;
      }
      i5 = HEAP32[i9 >> 2] | 0;
      if (i5 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
       HEAP32[i9 >> 2] = i5 + 1;
       i21 = HEAPU8[i5] | 0;
       i19 = 0;
      } else {
       i21 = ___shgetc(i8) | 0;
       i19 = 0;
      }
      while (1) {
       if ((i21 | 0) == 46) {
        i13 = 70;
        break;
       } else if ((i21 | 0) != 48) {
        i5 = 0;
        i7 = 0;
        i15 = 0;
        i16 = 0;
        i18 = 0;
        i20 = 0;
        d28 = 1.0;
        i17 = 0;
        d14 = 0.0;
        break;
       }
       i5 = HEAP32[i9 >> 2] | 0;
       if (i5 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
        HEAP32[i9 >> 2] = i5 + 1;
        i21 = HEAPU8[i5] | 0;
        i19 = 1;
        continue;
       } else {
        i21 = ___shgetc(i8) | 0;
        i19 = 1;
        continue;
       }
      }
      L66 : do {
       if ((i13 | 0) == 70) {
        i5 = HEAP32[i9 >> 2] | 0;
        if (i5 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
         HEAP32[i9 >> 2] = i5 + 1;
         i21 = HEAPU8[i5] | 0;
        } else {
         i21 = ___shgetc(i8) | 0;
        }
        if ((i21 | 0) == 48) {
         i15 = -1;
         i16 = -1;
         while (1) {
          i5 = HEAP32[i9 >> 2] | 0;
          if (i5 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
           HEAP32[i9 >> 2] = i5 + 1;
           i21 = HEAPU8[i5] | 0;
          } else {
           i21 = ___shgetc(i8) | 0;
          }
          if ((i21 | 0) != 48) {
           i5 = 0;
           i7 = 0;
           i19 = 1;
           i18 = 1;
           i20 = 0;
           d28 = 1.0;
           i17 = 0;
           d14 = 0.0;
           break L66;
          }
          i29 = _i64Add(i15 | 0, i16 | 0, -1, -1) | 0;
          i15 = i29;
          i16 = tempRet0;
         }
        } else {
         i5 = 0;
         i7 = 0;
         i15 = 0;
         i16 = 0;
         i18 = 1;
         i20 = 0;
         d28 = 1.0;
         i17 = 0;
         d14 = 0.0;
        }
       }
      } while (0);
      L79 : while (1) {
       i24 = i21 + -48 | 0;
       do {
        if (!(i24 >>> 0 < 10)) {
         i23 = i21 | 32;
         i22 = (i21 | 0) == 46;
         if (!((i23 + -97 | 0) >>> 0 < 6 | i22)) {
          break L79;
         }
         if (i22) {
          if ((i18 | 0) == 0) {
           i15 = i7;
           i16 = i5;
           i18 = 1;
           break;
          } else {
           i21 = 46;
           break L79;
          }
         } else {
          i24 = (i21 | 0) > 57 ? i23 + -87 | 0 : i24;
          i13 = 84;
          break;
         }
        } else {
         i13 = 84;
        }
       } while (0);
       if ((i13 | 0) == 84) {
        i13 = 0;
        do {
         if (!((i5 | 0) < 0 | (i5 | 0) == 0 & i7 >>> 0 < 8)) {
          if ((i5 | 0) < 0 | (i5 | 0) == 0 & i7 >>> 0 < 14) {
           d31 = d28 * .0625;
           d30 = d31;
           d14 = d14 + d31 * +(i24 | 0);
           break;
          }
          if ((i24 | 0) != 0 & (i20 | 0) == 0) {
           i20 = 1;
           d30 = d28;
           d14 = d14 + d28 * .5;
          } else {
           d30 = d28;
          }
         } else {
          d30 = d28;
          i17 = i24 + (i17 << 4) | 0;
         }
        } while (0);
        i7 = _i64Add(i7 | 0, i5 | 0, 1, 0) | 0;
        i5 = tempRet0;
        i19 = 1;
        d28 = d30;
       }
       i21 = HEAP32[i9 >> 2] | 0;
       if (i21 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
        HEAP32[i9 >> 2] = i21 + 1;
        i21 = HEAPU8[i21] | 0;
        continue;
       } else {
        i21 = ___shgetc(i8) | 0;
        continue;
       }
      }
      if ((i19 | 0) == 0) {
       i2 = (HEAP32[i10 >> 2] | 0) == 0;
       if (!i2) {
        HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
       }
       if (!i12) {
        if (!i2 ? (i6 = HEAP32[i9 >> 2] | 0, HEAP32[i9 >> 2] = i6 + -1, (i18 | 0) != 0) : 0) {
         HEAP32[i9 >> 2] = i6 + -2;
        }
       } else {
        ___shlim(i8, 0);
       }
       d31 = +(i4 | 0) * 0.0;
       STACKTOP = i1;
       return +d31;
      }
      i13 = (i18 | 0) == 0;
      i6 = i13 ? i7 : i15;
      i13 = i13 ? i5 : i16;
      if ((i5 | 0) < 0 | (i5 | 0) == 0 & i7 >>> 0 < 8) {
       do {
        i17 = i17 << 4;
        i7 = _i64Add(i7 | 0, i5 | 0, 1, 0) | 0;
        i5 = tempRet0;
       } while ((i5 | 0) < 0 | (i5 | 0) == 0 & i7 >>> 0 < 8);
      }
      do {
       if ((i21 | 32 | 0) == 112) {
        i7 = _scanexp(i8, i11) | 0;
        i5 = tempRet0;
        if ((i7 | 0) == 0 & (i5 | 0) == -2147483648) {
         if (i12) {
          ___shlim(i8, 0);
          d31 = 0.0;
          STACKTOP = i1;
          return +d31;
         } else {
          if ((HEAP32[i10 >> 2] | 0) == 0) {
           i7 = 0;
           i5 = 0;
           break;
          }
          HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
          i7 = 0;
          i5 = 0;
          break;
         }
        }
       } else {
        if ((HEAP32[i10 >> 2] | 0) == 0) {
         i7 = 0;
         i5 = 0;
        } else {
         HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
         i7 = 0;
         i5 = 0;
        }
       }
      } while (0);
      i6 = _bitshift64Shl(i6 | 0, i13 | 0, 2) | 0;
      i6 = _i64Add(i6 | 0, tempRet0 | 0, -32, -1) | 0;
      i5 = _i64Add(i6 | 0, tempRet0 | 0, i7 | 0, i5 | 0) | 0;
      i6 = tempRet0;
      if ((i17 | 0) == 0) {
       d31 = +(i4 | 0) * 0.0;
       STACKTOP = i1;
       return +d31;
      }
      if ((i6 | 0) > 0 | (i6 | 0) == 0 & i5 >>> 0 > (0 - i3 | 0) >>> 0) {
       HEAP32[(___errno_location() | 0) >> 2] = 34;
       d31 = +(i4 | 0) * 1.7976931348623157e+308 * 1.7976931348623157e+308;
       STACKTOP = i1;
       return +d31;
      }
      i29 = i3 + -106 | 0;
      i27 = ((i29 | 0) < 0) << 31 >> 31;
      if ((i6 | 0) < (i27 | 0) | (i6 | 0) == (i27 | 0) & i5 >>> 0 < i29 >>> 0) {
       HEAP32[(___errno_location() | 0) >> 2] = 34;
       d31 = +(i4 | 0) * 2.2250738585072014e-308 * 2.2250738585072014e-308;
       STACKTOP = i1;
       return +d31;
      }
      if ((i17 | 0) > -1) {
       do {
        i17 = i17 << 1;
        if (!(d14 >= .5)) {
         d28 = d14;
        } else {
         d28 = d14 + -1.0;
         i17 = i17 | 1;
        }
        d14 = d14 + d28;
        i5 = _i64Add(i5 | 0, i6 | 0, -1, -1) | 0;
        i6 = tempRet0;
       } while ((i17 | 0) > -1);
      }
      i3 = _i64Subtract(32, 0, i3 | 0, ((i3 | 0) < 0) << 31 >> 31 | 0) | 0;
      i3 = _i64Add(i5 | 0, i6 | 0, i3 | 0, tempRet0 | 0) | 0;
      i29 = tempRet0;
      if (0 > (i29 | 0) | 0 == (i29 | 0) & i2 >>> 0 > i3 >>> 0) {
       i2 = (i3 | 0) < 0 ? 0 : i3;
      }
      if ((i2 | 0) < 53) {
       d28 = +(i4 | 0);
       d30 = +_copysign(+(+_scalbn(1.0, 84 - i2 | 0)), +d28);
       if ((i2 | 0) < 32 & d14 != 0.0) {
        i29 = i17 & 1;
        i17 = (i29 ^ 1) + i17 | 0;
        d14 = (i29 | 0) == 0 ? 0.0 : d14;
       }
      } else {
       d28 = +(i4 | 0);
       d30 = 0.0;
      }
      d14 = d28 * d14 + (d30 + d28 * +(i17 >>> 0)) - d30;
      if (!(d14 != 0.0)) {
       HEAP32[(___errno_location() | 0) >> 2] = 34;
      }
      d31 = +_scalbnl(d14, i5);
      STACKTOP = i1;
      return +d31;
     }
    } while (0);
    i7 = i3 + i2 | 0;
    i6 = 0 - i7 | 0;
    i20 = 0;
    while (1) {
     if ((i21 | 0) == 46) {
      i13 = 139;
      break;
     } else if ((i21 | 0) != 48) {
      i25 = 0;
      i22 = 0;
      i19 = 0;
      break;
     }
     i15 = HEAP32[i9 >> 2] | 0;
     if (i15 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
      HEAP32[i9 >> 2] = i15 + 1;
      i21 = HEAPU8[i15] | 0;
      i20 = 1;
      continue;
     } else {
      i21 = ___shgetc(i8) | 0;
      i20 = 1;
      continue;
     }
    }
    L168 : do {
     if ((i13 | 0) == 139) {
      i15 = HEAP32[i9 >> 2] | 0;
      if (i15 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
       HEAP32[i9 >> 2] = i15 + 1;
       i21 = HEAPU8[i15] | 0;
      } else {
       i21 = ___shgetc(i8) | 0;
      }
      if ((i21 | 0) == 48) {
       i25 = -1;
       i22 = -1;
       while (1) {
        i15 = HEAP32[i9 >> 2] | 0;
        if (i15 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
         HEAP32[i9 >> 2] = i15 + 1;
         i21 = HEAPU8[i15] | 0;
        } else {
         i21 = ___shgetc(i8) | 0;
        }
        if ((i21 | 0) != 48) {
         i20 = 1;
         i19 = 1;
         break L168;
        }
        i29 = _i64Add(i25 | 0, i22 | 0, -1, -1) | 0;
        i25 = i29;
        i22 = tempRet0;
       }
      } else {
       i25 = 0;
       i22 = 0;
       i19 = 1;
      }
     }
    } while (0);
    HEAP32[i5 >> 2] = 0;
    i26 = i21 + -48 | 0;
    i27 = (i21 | 0) == 46;
    L182 : do {
     if (i26 >>> 0 < 10 | i27) {
      i15 = i5 + 496 | 0;
      i24 = 0;
      i23 = 0;
      i18 = 0;
      i17 = 0;
      i16 = 0;
      while (1) {
       do {
        if (i27) {
         if ((i19 | 0) == 0) {
          i25 = i24;
          i22 = i23;
          i19 = 1;
         } else {
          break L182;
         }
        } else {
         i27 = _i64Add(i24 | 0, i23 | 0, 1, 0) | 0;
         i23 = tempRet0;
         i29 = (i21 | 0) != 48;
         if ((i17 | 0) >= 125) {
          if (!i29) {
           i24 = i27;
           break;
          }
          HEAP32[i15 >> 2] = HEAP32[i15 >> 2] | 1;
          i24 = i27;
          break;
         }
         i20 = i5 + (i17 << 2) | 0;
         if ((i18 | 0) != 0) {
          i26 = i21 + -48 + ((HEAP32[i20 >> 2] | 0) * 10 | 0) | 0;
         }
         HEAP32[i20 >> 2] = i26;
         i18 = i18 + 1 | 0;
         i21 = (i18 | 0) == 9;
         i24 = i27;
         i20 = 1;
         i18 = i21 ? 0 : i18;
         i17 = (i21 & 1) + i17 | 0;
         i16 = i29 ? i27 : i16;
        }
       } while (0);
       i21 = HEAP32[i9 >> 2] | 0;
       if (i21 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
        HEAP32[i9 >> 2] = i21 + 1;
        i21 = HEAPU8[i21] | 0;
       } else {
        i21 = ___shgetc(i8) | 0;
       }
       i26 = i21 + -48 | 0;
       i27 = (i21 | 0) == 46;
       if (!(i26 >>> 0 < 10 | i27)) {
        i13 = 162;
        break;
       }
      }
     } else {
      i24 = 0;
      i23 = 0;
      i18 = 0;
      i17 = 0;
      i16 = 0;
      i13 = 162;
     }
    } while (0);
    if ((i13 | 0) == 162) {
     i13 = (i19 | 0) == 0;
     i25 = i13 ? i24 : i25;
     i22 = i13 ? i23 : i22;
    }
    i13 = (i20 | 0) != 0;
    if (i13 ? (i21 | 32 | 0) == 101 : 0) {
     i15 = _scanexp(i8, i11) | 0;
     i11 = tempRet0;
     do {
      if ((i15 | 0) == 0 & (i11 | 0) == -2147483648) {
       if (i12) {
        ___shlim(i8, 0);
        d31 = 0.0;
        STACKTOP = i1;
        return +d31;
       } else {
        if ((HEAP32[i10 >> 2] | 0) == 0) {
         i15 = 0;
         i11 = 0;
         break;
        }
        HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
        i15 = 0;
        i11 = 0;
        break;
       }
      }
     } while (0);
     i9 = _i64Add(i15 | 0, i11 | 0, i25 | 0, i22 | 0) | 0;
     i22 = tempRet0;
    } else {
     if ((i21 | 0) > -1 ? (HEAP32[i10 >> 2] | 0) != 0 : 0) {
      HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
      i9 = i25;
     } else {
      i9 = i25;
     }
    }
    if (!i13) {
     HEAP32[(___errno_location() | 0) >> 2] = 22;
     ___shlim(i8, 0);
     d31 = 0.0;
     STACKTOP = i1;
     return +d31;
    }
    i8 = HEAP32[i5 >> 2] | 0;
    if ((i8 | 0) == 0) {
     d31 = +(i4 | 0) * 0.0;
     STACKTOP = i1;
     return +d31;
    }
    do {
     if ((i9 | 0) == (i24 | 0) & (i22 | 0) == (i23 | 0) & ((i23 | 0) < 0 | (i23 | 0) == 0 & i24 >>> 0 < 10)) {
      if (!(i2 >>> 0 > 30) ? (i8 >>> i2 | 0) != 0 : 0) {
       break;
      }
      d31 = +(i4 | 0) * +(i8 >>> 0);
      STACKTOP = i1;
      return +d31;
     }
    } while (0);
    i29 = (i3 | 0) / -2 | 0;
    i27 = ((i29 | 0) < 0) << 31 >> 31;
    if ((i22 | 0) > (i27 | 0) | (i22 | 0) == (i27 | 0) & i9 >>> 0 > i29 >>> 0) {
     HEAP32[(___errno_location() | 0) >> 2] = 34;
     d31 = +(i4 | 0) * 1.7976931348623157e+308 * 1.7976931348623157e+308;
     STACKTOP = i1;
     return +d31;
    }
    i29 = i3 + -106 | 0;
    i27 = ((i29 | 0) < 0) << 31 >> 31;
    if ((i22 | 0) < (i27 | 0) | (i22 | 0) == (i27 | 0) & i9 >>> 0 < i29 >>> 0) {
     HEAP32[(___errno_location() | 0) >> 2] = 34;
     d31 = +(i4 | 0) * 2.2250738585072014e-308 * 2.2250738585072014e-308;
     STACKTOP = i1;
     return +d31;
    }
    if ((i18 | 0) != 0) {
     if ((i18 | 0) < 9) {
      i8 = i5 + (i17 << 2) | 0;
      i10 = HEAP32[i8 >> 2] | 0;
      do {
       i10 = i10 * 10 | 0;
       i18 = i18 + 1 | 0;
      } while ((i18 | 0) != 9);
      HEAP32[i8 >> 2] = i10;
     }
     i17 = i17 + 1 | 0;
    }
    do {
     if ((i16 | 0) < 9 ? (i16 | 0) <= (i9 | 0) & (i9 | 0) < 18 : 0) {
      if ((i9 | 0) == 9) {
       d31 = +(i4 | 0) * +((HEAP32[i5 >> 2] | 0) >>> 0);
       STACKTOP = i1;
       return +d31;
      }
      if ((i9 | 0) < 9) {
       d31 = +(i4 | 0) * +((HEAP32[i5 >> 2] | 0) >>> 0) / +(HEAP32[13440 + (8 - i9 << 2) >> 2] | 0);
       STACKTOP = i1;
       return +d31;
      }
      i10 = i2 + 27 + (Math_imul(i9, -3) | 0) | 0;
      i8 = HEAP32[i5 >> 2] | 0;
      if ((i10 | 0) <= 30 ? (i8 >>> i10 | 0) != 0 : 0) {
       break;
      }
      d31 = +(i4 | 0) * +(i8 >>> 0) * +(HEAP32[13440 + (i9 + -10 << 2) >> 2] | 0);
      STACKTOP = i1;
      return +d31;
     }
    } while (0);
    i8 = (i9 | 0) % 9 | 0;
    if ((i8 | 0) == 0) {
     i8 = 0;
     i10 = 0;
    } else {
     i11 = (i9 | 0) > -1 ? i8 : i8 + 9 | 0;
     i12 = HEAP32[13440 + (8 - i11 << 2) >> 2] | 0;
     if ((i17 | 0) != 0) {
      i10 = 1e9 / (i12 | 0) | 0;
      i8 = 0;
      i16 = 0;
      i15 = 0;
      while (1) {
       i27 = i5 + (i15 << 2) | 0;
       i13 = HEAP32[i27 >> 2] | 0;
       i29 = ((i13 >>> 0) / (i12 >>> 0) | 0) + i16 | 0;
       HEAP32[i27 >> 2] = i29;
       i16 = Math_imul((i13 >>> 0) % (i12 >>> 0) | 0, i10) | 0;
       i13 = i15 + 1 | 0;
       if ((i15 | 0) == (i8 | 0) & (i29 | 0) == 0) {
        i8 = i13 & 127;
        i9 = i9 + -9 | 0;
       }
       if ((i13 | 0) == (i17 | 0)) {
        break;
       } else {
        i15 = i13;
       }
      }
      if ((i16 | 0) != 0) {
       HEAP32[i5 + (i17 << 2) >> 2] = i16;
       i17 = i17 + 1 | 0;
      }
     } else {
      i8 = 0;
      i17 = 0;
     }
     i10 = 0;
     i9 = 9 - i11 + i9 | 0;
    }
    L280 : while (1) {
     i11 = i5 + (i8 << 2) | 0;
     if ((i9 | 0) < 18) {
      do {
       i13 = 0;
       i11 = i17 + 127 | 0;
       while (1) {
        i11 = i11 & 127;
        i12 = i5 + (i11 << 2) | 0;
        i15 = _bitshift64Shl(HEAP32[i12 >> 2] | 0, 0, 29) | 0;
        i15 = _i64Add(i15 | 0, tempRet0 | 0, i13 | 0, 0) | 0;
        i13 = tempRet0;
        if (i13 >>> 0 > 0 | (i13 | 0) == 0 & i15 >>> 0 > 1e9) {
         i29 = ___udivdi3(i15 | 0, i13 | 0, 1e9, 0) | 0;
         i15 = ___uremdi3(i15 | 0, i13 | 0, 1e9, 0) | 0;
         i13 = i29;
        } else {
         i13 = 0;
        }
        HEAP32[i12 >> 2] = i15;
        i12 = (i11 | 0) == (i8 | 0);
        if (!((i11 | 0) != (i17 + 127 & 127 | 0) | i12)) {
         i17 = (i15 | 0) == 0 ? i11 : i17;
        }
        if (i12) {
         break;
        } else {
         i11 = i11 + -1 | 0;
        }
       }
       i10 = i10 + -29 | 0;
      } while ((i13 | 0) == 0);
     } else {
      if ((i9 | 0) != 18) {
       break;
      }
      do {
       if (!((HEAP32[i11 >> 2] | 0) >>> 0 < 9007199)) {
        i9 = 18;
        break L280;
       }
       i13 = 0;
       i12 = i17 + 127 | 0;
       while (1) {
        i12 = i12 & 127;
        i15 = i5 + (i12 << 2) | 0;
        i16 = _bitshift64Shl(HEAP32[i15 >> 2] | 0, 0, 29) | 0;
        i16 = _i64Add(i16 | 0, tempRet0 | 0, i13 | 0, 0) | 0;
        i13 = tempRet0;
        if (i13 >>> 0 > 0 | (i13 | 0) == 0 & i16 >>> 0 > 1e9) {
         i29 = ___udivdi3(i16 | 0, i13 | 0, 1e9, 0) | 0;
         i16 = ___uremdi3(i16 | 0, i13 | 0, 1e9, 0) | 0;
         i13 = i29;
        } else {
         i13 = 0;
        }
        HEAP32[i15 >> 2] = i16;
        i15 = (i12 | 0) == (i8 | 0);
        if (!((i12 | 0) != (i17 + 127 & 127 | 0) | i15)) {
         i17 = (i16 | 0) == 0 ? i12 : i17;
        }
        if (i15) {
         break;
        } else {
         i12 = i12 + -1 | 0;
        }
       }
       i10 = i10 + -29 | 0;
      } while ((i13 | 0) == 0);
     }
     i8 = i8 + 127 & 127;
     if ((i8 | 0) == (i17 | 0)) {
      i29 = i17 + 127 & 127;
      i17 = i5 + ((i17 + 126 & 127) << 2) | 0;
      HEAP32[i17 >> 2] = HEAP32[i17 >> 2] | HEAP32[i5 + (i29 << 2) >> 2];
      i17 = i29;
     }
     HEAP32[i5 + (i8 << 2) >> 2] = i13;
     i9 = i9 + 9 | 0;
    }
    L311 : while (1) {
     i11 = i17 + 1 & 127;
     i12 = i5 + ((i17 + 127 & 127) << 2) | 0;
     while (1) {
      i15 = (i9 | 0) == 18;
      i13 = (i9 | 0) > 27 ? 9 : 1;
      while (1) {
       i16 = 0;
       while (1) {
        i18 = i16 + i8 & 127;
        if ((i18 | 0) == (i17 | 0)) {
         i16 = 2;
         break;
        }
        i18 = HEAP32[i5 + (i18 << 2) >> 2] | 0;
        i19 = HEAP32[13432 + (i16 << 2) >> 2] | 0;
        if (i18 >>> 0 < i19 >>> 0) {
         i16 = 2;
         break;
        }
        i20 = i16 + 1 | 0;
        if (i18 >>> 0 > i19 >>> 0) {
         break;
        }
        if ((i20 | 0) < 2) {
         i16 = i20;
        } else {
         i16 = i20;
         break;
        }
       }
       if ((i16 | 0) == 2 & i15) {
        break L311;
       }
       i10 = i13 + i10 | 0;
       if ((i8 | 0) == (i17 | 0)) {
        i8 = i17;
       } else {
        break;
       }
      }
      i15 = (1 << i13) + -1 | 0;
      i19 = 1e9 >>> i13;
      i18 = i8;
      i16 = 0;
      do {
       i27 = i5 + (i8 << 2) | 0;
       i29 = HEAP32[i27 >> 2] | 0;
       i20 = (i29 >>> i13) + i16 | 0;
       HEAP32[i27 >> 2] = i20;
       i16 = Math_imul(i29 & i15, i19) | 0;
       i20 = (i8 | 0) == (i18 | 0) & (i20 | 0) == 0;
       i8 = i8 + 1 & 127;
       i9 = i20 ? i9 + -9 | 0 : i9;
       i18 = i20 ? i8 : i18;
      } while ((i8 | 0) != (i17 | 0));
      if ((i16 | 0) == 0) {
       i8 = i18;
       continue;
      }
      if ((i11 | 0) != (i18 | 0)) {
       break;
      }
      HEAP32[i12 >> 2] = HEAP32[i12 >> 2] | 1;
      i8 = i18;
     }
     HEAP32[i5 + (i17 << 2) >> 2] = i16;
     i8 = i18;
     i17 = i11;
    }
    i9 = i8 & 127;
    if ((i9 | 0) == (i17 | 0)) {
     HEAP32[i5 + (i11 + -1 << 2) >> 2] = 0;
     i17 = i11;
    }
    d28 = +((HEAP32[i5 + (i9 << 2) >> 2] | 0) >>> 0);
    i9 = i8 + 1 & 127;
    if ((i9 | 0) == (i17 | 0)) {
     i17 = i17 + 1 & 127;
     HEAP32[i5 + (i17 + -1 << 2) >> 2] = 0;
    }
    d14 = +(i4 | 0);
    d30 = d14 * (d28 * 1.0e9 + +((HEAP32[i5 + (i9 << 2) >> 2] | 0) >>> 0));
    i4 = i10 + 53 | 0;
    i3 = i4 - i3 | 0;
    if ((i3 | 0) < (i2 | 0)) {
     i2 = (i3 | 0) < 0 ? 0 : i3;
     i9 = 1;
    } else {
     i9 = 0;
    }
    if ((i2 | 0) < 53) {
     d33 = +_copysign(+(+_scalbn(1.0, 105 - i2 | 0)), +d30);
     d32 = +_fmod(+d30, +(+_scalbn(1.0, 53 - i2 | 0)));
     d28 = d33;
     d31 = d32;
     d30 = d33 + (d30 - d32);
    } else {
     d28 = 0.0;
     d31 = 0.0;
    }
    i11 = i8 + 2 & 127;
    if ((i11 | 0) != (i17 | 0)) {
     i5 = HEAP32[i5 + (i11 << 2) >> 2] | 0;
     do {
      if (!(i5 >>> 0 < 5e8)) {
       if (i5 >>> 0 > 5e8) {
        d31 = d14 * .75 + d31;
        break;
       }
       if ((i8 + 3 & 127 | 0) == (i17 | 0)) {
        d31 = d14 * .5 + d31;
        break;
       } else {
        d31 = d14 * .75 + d31;
        break;
       }
      } else {
       if ((i5 | 0) == 0 ? (i8 + 3 & 127 | 0) == (i17 | 0) : 0) {
        break;
       }
       d31 = d14 * .25 + d31;
      }
     } while (0);
     if ((53 - i2 | 0) > 1 ? !(+_fmod(+d31, 1.0) != 0.0) : 0) {
      d31 = d31 + 1.0;
     }
    }
    d14 = d30 + d31 - d28;
    do {
     if ((i4 & 2147483647 | 0) > (-2 - i7 | 0)) {
      if (+Math_abs(+d14) >= 9007199254740992.0) {
       i9 = (i9 | 0) != 0 & (i2 | 0) == (i3 | 0) ? 0 : i9;
       i10 = i10 + 1 | 0;
       d14 = d14 * .5;
      }
      if ((i10 + 50 | 0) <= (i6 | 0) ? !((i9 | 0) != 0 & d31 != 0.0) : 0) {
       break;
      }
      HEAP32[(___errno_location() | 0) >> 2] = 34;
     }
    } while (0);
    d33 = +_scalbnl(d14, i10);
    STACKTOP = i1;
    return +d33;
   } else if ((i7 | 0) == 3) {
    i2 = HEAP32[i9 >> 2] | 0;
    if (i2 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
     HEAP32[i9 >> 2] = i2 + 1;
     i2 = HEAPU8[i2] | 0;
    } else {
     i2 = ___shgetc(i8) | 0;
    }
    if ((i2 | 0) == 40) {
     i2 = 1;
    } else {
     if ((HEAP32[i10 >> 2] | 0) == 0) {
      d33 = nan;
      STACKTOP = i1;
      return +d33;
     }
     HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
     d33 = nan;
     STACKTOP = i1;
     return +d33;
    }
    while (1) {
     i3 = HEAP32[i9 >> 2] | 0;
     if (i3 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0) {
      HEAP32[i9 >> 2] = i3 + 1;
      i3 = HEAPU8[i3] | 0;
     } else {
      i3 = ___shgetc(i8) | 0;
     }
     if (!((i3 + -48 | 0) >>> 0 < 10 | (i3 + -65 | 0) >>> 0 < 26) ? !((i3 + -97 | 0) >>> 0 < 26 | (i3 | 0) == 95) : 0) {
      break;
     }
     i2 = i2 + 1 | 0;
    }
    if ((i3 | 0) == 41) {
     d33 = nan;
     STACKTOP = i1;
     return +d33;
    }
    i3 = (HEAP32[i10 >> 2] | 0) == 0;
    if (!i3) {
     HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
    }
    if (i12) {
     HEAP32[(___errno_location() | 0) >> 2] = 22;
     ___shlim(i8, 0);
     d33 = 0.0;
     STACKTOP = i1;
     return +d33;
    }
    if ((i2 | 0) == 0 | i3) {
     d33 = nan;
     STACKTOP = i1;
     return +d33;
    }
    while (1) {
     i2 = i2 + -1 | 0;
     HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
     if ((i2 | 0) == 0) {
      d14 = nan;
      break;
     }
    }
    STACKTOP = i1;
    return +d14;
   } else {
    if ((HEAP32[i10 >> 2] | 0) != 0) {
     HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
    }
    HEAP32[(___errno_location() | 0) >> 2] = 22;
    ___shlim(i8, 0);
    d33 = 0.0;
    STACKTOP = i1;
    return +d33;
   }
  }
 } while (0);
 if ((i13 | 0) == 23) {
  i2 = (HEAP32[i10 >> 2] | 0) == 0;
  if (!i2) {
   HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
  }
  if (!(i7 >>> 0 < 4 | (i11 | 0) == 0 | i2)) {
   do {
    HEAP32[i9 >> 2] = (HEAP32[i9 >> 2] | 0) + -1;
    i7 = i7 + -1 | 0;
   } while (i7 >>> 0 > 3);
  }
 }
 d33 = +(i4 | 0) * inf;
 STACKTOP = i1;
 return +d33;
}
function _statement(i4) {
 i4 = i4 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 160 | 0;
 i8 = i2 + 120 | 0;
 i24 = i2 + 96 | 0;
 i15 = i2 + 72 | 0;
 i25 = i2 + 48 | 0;
 i20 = i2 + 24 | 0;
 i21 = i2;
 i19 = i4 + 4 | 0;
 i6 = HEAP32[i19 >> 2] | 0;
 i3 = i4 + 48 | 0;
 i9 = HEAP32[i3 >> 2] | 0;
 i1 = i4 + 52 | 0;
 i26 = (HEAP32[i1 >> 2] | 0) + 38 | 0;
 i27 = (HEAP16[i26 >> 1] | 0) + 1 << 16 >> 16;
 HEAP16[i26 >> 1] = i27;
 if ((i27 & 65535) > 200) {
  i27 = i9 + 12 | 0;
  i26 = HEAP32[(HEAP32[i27 >> 2] | 0) + 52 >> 2] | 0;
  i5 = HEAP32[(HEAP32[i9 >> 2] | 0) + 64 >> 2] | 0;
  if ((i5 | 0) == 0) {
   i29 = 6552;
   HEAP32[i8 >> 2] = 6360;
   i28 = i8 + 4 | 0;
   HEAP32[i28 >> 2] = 200;
   i28 = i8 + 8 | 0;
   HEAP32[i28 >> 2] = i29;
   i28 = _luaO_pushfstring(i26, 6592, i8) | 0;
   i29 = HEAP32[i27 >> 2] | 0;
   _luaX_syntaxerror(i29, i28);
  }
  HEAP32[i8 >> 2] = i5;
  i28 = _luaO_pushfstring(i26, 6568, i8) | 0;
  HEAP32[i8 >> 2] = 6360;
  i29 = i8 + 4 | 0;
  HEAP32[i29 >> 2] = 200;
  i29 = i8 + 8 | 0;
  HEAP32[i29 >> 2] = i28;
  i29 = _luaO_pushfstring(i26, 6592, i8) | 0;
  i28 = HEAP32[i27 >> 2] | 0;
  _luaX_syntaxerror(i28, i29);
 }
 i5 = i4 + 16 | 0;
 L8 : do {
  switch (HEAP32[i5 >> 2] | 0) {
  case 59:
   {
    _luaX_next(i4);
    break;
   }
  case 267:
   {
    HEAP32[i21 >> 2] = -1;
    _test_then_block(i4, i21);
    while (1) {
     i8 = HEAP32[i5 >> 2] | 0;
     if ((i8 | 0) == 260) {
      i7 = 10;
      break;
     } else if ((i8 | 0) != 261) {
      break;
     }
     _test_then_block(i4, i21);
    }
    if ((i7 | 0) == 10) {
     _luaX_next(i4);
     i7 = HEAP32[i3 >> 2] | 0;
     HEAP8[i20 + 10 | 0] = 0;
     HEAP8[i20 + 8 | 0] = HEAP8[i7 + 46 | 0] | 0;
     i29 = HEAP32[(HEAP32[i7 + 12 >> 2] | 0) + 64 >> 2] | 0;
     HEAP16[i20 + 4 >> 1] = HEAP32[i29 + 28 >> 2];
     HEAP16[i20 + 6 >> 1] = HEAP32[i29 + 16 >> 2];
     HEAP8[i20 + 9 | 0] = 0;
     i29 = i7 + 16 | 0;
     HEAP32[i20 >> 2] = HEAP32[i29 >> 2];
     HEAP32[i29 >> 2] = i20;
     L16 : do {
      i8 = HEAP32[i5 >> 2] | 0;
      switch (i8 | 0) {
      case 277:
      case 286:
      case 262:
      case 261:
      case 260:
       {
        break L16;
       }
      default:
       {}
      }
      _statement(i4);
     } while ((i8 | 0) != 274);
     _leaveblock(i7);
    }
    _check_match(i4, 262, 267, i6);
    _luaK_patchtohere(i9, HEAP32[i21 >> 2] | 0);
    break;
   }
  case 259:
   {
    _luaX_next(i4);
    i7 = HEAP32[i3 >> 2] | 0;
    HEAP8[i20 + 10 | 0] = 0;
    HEAP8[i20 + 8 | 0] = HEAP8[i7 + 46 | 0] | 0;
    i29 = HEAP32[(HEAP32[i7 + 12 >> 2] | 0) + 64 >> 2] | 0;
    HEAP16[i20 + 4 >> 1] = HEAP32[i29 + 28 >> 2];
    HEAP16[i20 + 6 >> 1] = HEAP32[i29 + 16 >> 2];
    HEAP8[i20 + 9 | 0] = 0;
    i29 = i7 + 16 | 0;
    HEAP32[i20 >> 2] = HEAP32[i29 >> 2];
    HEAP32[i29 >> 2] = i20;
    L22 : do {
     i8 = HEAP32[i5 >> 2] | 0;
     switch (i8 | 0) {
     case 277:
     case 286:
     case 262:
     case 261:
     case 260:
      {
       break L22;
      }
     default:
      {}
     }
     _statement(i4);
    } while ((i8 | 0) != 274);
    _leaveblock(i7);
    _check_match(i4, 262, 259, i6);
    break;
   }
  case 269:
   {
    _luaX_next(i4);
    i6 = HEAP32[i5 >> 2] | 0;
    if ((i6 | 0) == 265) {
     _luaX_next(i4);
     i7 = HEAP32[i3 >> 2] | 0;
     if ((HEAP32[i5 >> 2] | 0) == 288) {
      i29 = HEAP32[i4 + 24 >> 2] | 0;
      _luaX_next(i4);
      _new_localvar(i4, i29);
      i29 = HEAP32[i3 >> 2] | 0;
      i27 = i29 + 46 | 0;
      i28 = (HEAPU8[i27] | 0) + 1 | 0;
      HEAP8[i27] = i28;
      HEAP32[(HEAP32[(HEAP32[i29 >> 2] | 0) + 24 >> 2] | 0) + ((HEAP16[(HEAP32[HEAP32[(HEAP32[i29 + 12 >> 2] | 0) + 64 >> 2] >> 2] | 0) + ((i28 & 255) + -1 + (HEAP32[i29 + 40 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i29 + 20 >> 2];
      _body(i4, i25, 0, HEAP32[i19 >> 2] | 0);
      HEAP32[(HEAP32[(HEAP32[i7 >> 2] | 0) + 24 >> 2] | 0) + ((HEAP16[(HEAP32[HEAP32[(HEAP32[i7 + 12 >> 2] | 0) + 64 >> 2] >> 2] | 0) + ((HEAP32[i7 + 40 >> 2] | 0) + (HEAP32[i25 + 8 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i7 + 20 >> 2];
      break L8;
     } else {
      _error_expected(i4, 288);
     }
    }
    if ((i6 | 0) != 288) {
     _error_expected(i4, 288);
    }
    i7 = i4 + 24 | 0;
    i6 = 1;
    while (1) {
     i8 = HEAP32[i7 >> 2] | 0;
     _luaX_next(i4);
     _new_localvar(i4, i8);
     i8 = HEAP32[i5 >> 2] | 0;
     if ((i8 | 0) == 61) {
      i7 = 81;
      break;
     } else if ((i8 | 0) != 44) {
      i7 = 83;
      break;
     }
     _luaX_next(i4);
     if ((HEAP32[i5 >> 2] | 0) == 288) {
      i6 = i6 + 1 | 0;
     } else {
      i7 = 78;
      break;
     }
    }
    do {
     if ((i7 | 0) == 78) {
      _error_expected(i4, 288);
     } else if ((i7 | 0) == 81) {
      _luaX_next(i4);
      _subexpr(i4, i15, 0) | 0;
      if ((HEAP32[i5 >> 2] | 0) == 44) {
       i8 = 1;
       do {
        _luaX_next(i4);
        _luaK_exp2nextreg(HEAP32[i3 >> 2] | 0, i15);
        _subexpr(i4, i15, 0) | 0;
        i8 = i8 + 1 | 0;
       } while ((HEAP32[i5 >> 2] | 0) == 44);
      } else {
       i8 = 1;
      }
      i5 = HEAP32[i15 >> 2] | 0;
      i4 = HEAP32[i3 >> 2] | 0;
      i8 = i6 - i8 | 0;
      if ((i5 | 0) == 0) {
       i17 = i8;
       i18 = i4;
       i7 = 88;
       break;
      } else if (!((i5 | 0) == 13 | (i5 | 0) == 12)) {
       _luaK_exp2nextreg(i4, i15);
       i17 = i8;
       i18 = i4;
       i7 = 88;
       break;
      }
      i5 = i8 + 1 | 0;
      i5 = (i5 | 0) < 0 ? 0 : i5;
      _luaK_setreturns(i4, i15, i5);
      if ((i5 | 0) > 1) {
       _luaK_reserveregs(i4, i5 + -1 | 0);
      }
     } else if ((i7 | 0) == 83) {
      HEAP32[i15 >> 2] = 0;
      i17 = i6;
      i18 = HEAP32[i3 >> 2] | 0;
      i7 = 88;
     }
    } while (0);
    if ((i7 | 0) == 88 ? (i17 | 0) > 0 : 0) {
     i29 = HEAPU8[i18 + 48 | 0] | 0;
     _luaK_reserveregs(i18, i17);
     _luaK_nil(i18, i29, i17);
    }
    i5 = HEAP32[i3 >> 2] | 0;
    i4 = i5 + 46 | 0;
    i7 = (HEAPU8[i4] | 0) + i6 | 0;
    HEAP8[i4] = i7;
    if ((i6 | 0) != 0 ? (i11 = i5 + 20 | 0, i14 = i5 + 40 | 0, i12 = HEAP32[(HEAP32[i5 >> 2] | 0) + 24 >> 2] | 0, i13 = HEAP32[HEAP32[(HEAP32[i5 + 12 >> 2] | 0) + 64 >> 2] >> 2] | 0, HEAP32[i12 + ((HEAP16[i13 + ((i7 & 255) - i6 + (HEAP32[i14 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i11 >> 2], i16 = i6 + -1 | 0, (i16 | 0) != 0) : 0) {
     do {
      HEAP32[i12 + ((HEAP16[i13 + ((HEAPU8[i4] | 0) - i16 + (HEAP32[i14 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i11 >> 2];
      i16 = i16 + -1 | 0;
     } while ((i16 | 0) != 0);
    }
    break;
   }
  case 264:
   {
    HEAP8[i24 + 10 | 0] = 1;
    HEAP8[i24 + 8 | 0] = HEAP8[i9 + 46 | 0] | 0;
    i29 = HEAP32[(HEAP32[i9 + 12 >> 2] | 0) + 64 >> 2] | 0;
    HEAP16[i24 + 4 >> 1] = HEAP32[i29 + 28 >> 2];
    HEAP16[i24 + 6 >> 1] = HEAP32[i29 + 16 >> 2];
    HEAP8[i24 + 9 | 0] = 0;
    i29 = i9 + 16 | 0;
    HEAP32[i24 >> 2] = HEAP32[i29 >> 2];
    HEAP32[i29 >> 2] = i24;
    _luaX_next(i4);
    if ((HEAP32[i5 >> 2] | 0) != 288) {
     _error_expected(i4, 288);
    }
    i14 = i4 + 24 | 0;
    i13 = HEAP32[i14 >> 2] | 0;
    _luaX_next(i4);
    i11 = HEAP32[i5 >> 2] | 0;
    if ((i11 | 0) == 268 | (i11 | 0) == 44) {
     i12 = HEAP32[i3 >> 2] | 0;
     i11 = HEAPU8[i12 + 48 | 0] | 0;
     _new_localvar(i4, _luaX_newstring(i4, 6744, 15) | 0);
     _new_localvar(i4, _luaX_newstring(i4, 6760, 11) | 0);
     _new_localvar(i4, _luaX_newstring(i4, 6776, 13) | 0);
     _new_localvar(i4, i13);
     i13 = HEAP32[i5 >> 2] | 0;
     do {
      if ((i13 | 0) == 44) {
       i15 = 4;
       while (1) {
        _luaX_next(i4);
        if ((HEAP32[i5 >> 2] | 0) != 288) {
         i7 = 40;
         break;
        }
        i13 = HEAP32[i14 >> 2] | 0;
        _luaX_next(i4);
        _new_localvar(i4, i13);
        i13 = HEAP32[i5 >> 2] | 0;
        if ((i13 | 0) == 44) {
         i15 = i15 + 1 | 0;
        } else {
         i7 = 42;
         break;
        }
       }
       if ((i7 | 0) == 40) {
        _error_expected(i4, 288);
       } else if ((i7 | 0) == 42) {
        i22 = i13;
        i10 = i15 + -2 | 0;
        break;
       }
      } else {
       i22 = i13;
       i10 = 1;
      }
     } while (0);
     if ((i22 | 0) != 268) {
      _error_expected(i4, 268);
     }
     _luaX_next(i4);
     i13 = HEAP32[i19 >> 2] | 0;
     _subexpr(i4, i8, 0) | 0;
     if ((HEAP32[i5 >> 2] | 0) == 44) {
      i14 = 1;
      do {
       _luaX_next(i4);
       _luaK_exp2nextreg(HEAP32[i3 >> 2] | 0, i8);
       _subexpr(i4, i8, 0) | 0;
       i14 = i14 + 1 | 0;
      } while ((HEAP32[i5 >> 2] | 0) == 44);
     } else {
      i14 = 1;
     }
     i5 = HEAP32[i3 >> 2] | 0;
     i14 = 3 - i14 | 0;
     i15 = HEAP32[i8 >> 2] | 0;
     if ((i15 | 0) == 0) {
      i7 = 51;
     } else if ((i15 | 0) == 13 | (i15 | 0) == 12) {
      i15 = i14 + 1 | 0;
      i15 = (i15 | 0) < 0 ? 0 : i15;
      _luaK_setreturns(i5, i8, i15);
      if ((i15 | 0) > 1) {
       _luaK_reserveregs(i5, i15 + -1 | 0);
      }
     } else {
      _luaK_exp2nextreg(i5, i8);
      i7 = 51;
     }
     if ((i7 | 0) == 51 ? (i14 | 0) > 0 : 0) {
      i29 = HEAPU8[i5 + 48 | 0] | 0;
      _luaK_reserveregs(i5, i14);
      _luaK_nil(i5, i29, i14);
     }
     _luaK_checkstack(i12, 3);
     _forbody(i4, i11, i13, i10, 0);
    } else if ((i11 | 0) == 61) {
     i11 = HEAP32[i3 >> 2] | 0;
     i7 = i11 + 48 | 0;
     i10 = HEAPU8[i7] | 0;
     _new_localvar(i4, _luaX_newstring(i4, 6792, 11) | 0);
     _new_localvar(i4, _luaX_newstring(i4, 6808, 11) | 0);
     _new_localvar(i4, _luaX_newstring(i4, 6824, 10) | 0);
     _new_localvar(i4, i13);
     if ((HEAP32[i5 >> 2] | 0) != 61) {
      _error_expected(i4, 61);
     }
     _luaX_next(i4);
     _subexpr(i4, i8, 0) | 0;
     _luaK_exp2nextreg(HEAP32[i3 >> 2] | 0, i8);
     if ((HEAP32[i5 >> 2] | 0) != 44) {
      _error_expected(i4, 44);
     }
     _luaX_next(i4);
     _subexpr(i4, i8, 0) | 0;
     _luaK_exp2nextreg(HEAP32[i3 >> 2] | 0, i8);
     if ((HEAP32[i5 >> 2] | 0) == 44) {
      _luaX_next(i4);
      _subexpr(i4, i8, 0) | 0;
      _luaK_exp2nextreg(HEAP32[i3 >> 2] | 0, i8);
     } else {
      i29 = HEAPU8[i7] | 0;
      _luaK_codek(i11, i29, _luaK_numberK(i11, 1.0) | 0) | 0;
      _luaK_reserveregs(i11, 1);
     }
     _forbody(i4, i10, i6, 1, 1);
    } else {
     _luaX_syntaxerror(i4, 6720);
    }
    _check_match(i4, 262, 264, i6);
    _leaveblock(i9);
    break;
   }
  case 265:
   {
    _luaX_next(i4);
    if ((HEAP32[i5 >> 2] | 0) != 288) {
     _error_expected(i4, 288);
    }
    i8 = HEAP32[i4 + 24 >> 2] | 0;
    _luaX_next(i4);
    i9 = HEAP32[i3 >> 2] | 0;
    if ((_singlevaraux(i9, i8, i20, 1) | 0) == 0) {
     _singlevaraux(i9, HEAP32[i4 + 72 >> 2] | 0, i20, 1) | 0;
     i29 = _luaK_stringK(HEAP32[i3 >> 2] | 0, i8) | 0;
     HEAP32[i25 + 16 >> 2] = -1;
     HEAP32[i25 + 20 >> 2] = -1;
     HEAP32[i25 >> 2] = 4;
     HEAP32[i25 + 8 >> 2] = i29;
     _luaK_indexed(i9, i20, i25);
    }
    while (1) {
     i8 = HEAP32[i5 >> 2] | 0;
     if ((i8 | 0) == 58) {
      i7 = 70;
      break;
     } else if ((i8 | 0) != 46) {
      i5 = 0;
      break;
     }
     _fieldsel(i4, i20);
    }
    if ((i7 | 0) == 70) {
     _fieldsel(i4, i20);
     i5 = 1;
    }
    _body(i4, i21, i5, i6);
    _luaK_storevar(HEAP32[i3 >> 2] | 0, i20, i21);
    _luaK_fixline(HEAP32[i3 >> 2] | 0, i6);
    break;
   }
  case 278:
   {
    _luaX_next(i4);
    i7 = _luaK_getlabel(i9) | 0;
    _subexpr(i4, i20, 0) | 0;
    if ((HEAP32[i20 >> 2] | 0) == 1) {
     HEAP32[i20 >> 2] = 3;
    }
    _luaK_goiftrue(HEAP32[i3 >> 2] | 0, i20);
    i8 = HEAP32[i20 + 20 >> 2] | 0;
    HEAP8[i21 + 10 | 0] = 1;
    HEAP8[i21 + 8 | 0] = HEAP8[i9 + 46 | 0] | 0;
    i29 = HEAP32[(HEAP32[i9 + 12 >> 2] | 0) + 64 >> 2] | 0;
    HEAP16[i21 + 4 >> 1] = HEAP32[i29 + 28 >> 2];
    HEAP16[i21 + 6 >> 1] = HEAP32[i29 + 16 >> 2];
    HEAP8[i21 + 9 | 0] = 0;
    i29 = i9 + 16 | 0;
    HEAP32[i21 >> 2] = HEAP32[i29 >> 2];
    HEAP32[i29 >> 2] = i21;
    if ((HEAP32[i5 >> 2] | 0) != 259) {
     _error_expected(i4, 259);
    }
    _luaX_next(i4);
    i10 = HEAP32[i3 >> 2] | 0;
    HEAP8[i20 + 10 | 0] = 0;
    HEAP8[i20 + 8 | 0] = HEAP8[i10 + 46 | 0] | 0;
    i29 = HEAP32[(HEAP32[i10 + 12 >> 2] | 0) + 64 >> 2] | 0;
    HEAP16[i20 + 4 >> 1] = HEAP32[i29 + 28 >> 2];
    HEAP16[i20 + 6 >> 1] = HEAP32[i29 + 16 >> 2];
    HEAP8[i20 + 9 | 0] = 0;
    i29 = i10 + 16 | 0;
    HEAP32[i20 >> 2] = HEAP32[i29 >> 2];
    HEAP32[i29 >> 2] = i20;
    L119 : do {
     i11 = HEAP32[i5 >> 2] | 0;
     switch (i11 | 0) {
     case 277:
     case 286:
     case 262:
     case 261:
     case 260:
      {
       break L119;
      }
     default:
      {}
     }
     _statement(i4);
    } while ((i11 | 0) != 274);
    _leaveblock(i10);
    _luaK_patchlist(i9, _luaK_jump(i9) | 0, i7);
    _check_match(i4, 262, 278, i6);
    _leaveblock(i9);
    _luaK_patchtohere(i9, i8);
    break;
   }
  case 273:
   {
    i7 = _luaK_getlabel(i9) | 0;
    HEAP8[i24 + 10 | 0] = 1;
    i28 = i9 + 46 | 0;
    HEAP8[i24 + 8 | 0] = HEAP8[i28] | 0;
    i11 = i9 + 12 | 0;
    i29 = HEAP32[(HEAP32[i11 >> 2] | 0) + 64 >> 2] | 0;
    HEAP16[i24 + 4 >> 1] = HEAP32[i29 + 28 >> 2];
    HEAP16[i24 + 6 >> 1] = HEAP32[i29 + 16 >> 2];
    HEAP8[i24 + 9 | 0] = 0;
    i29 = i9 + 16 | 0;
    HEAP32[i24 >> 2] = HEAP32[i29 >> 2];
    HEAP32[i29 >> 2] = i24;
    HEAP8[i15 + 10 | 0] = 0;
    i10 = i15 + 8 | 0;
    HEAP8[i10] = HEAP8[i28] | 0;
    i11 = HEAP32[(HEAP32[i11 >> 2] | 0) + 64 >> 2] | 0;
    HEAP16[i15 + 4 >> 1] = HEAP32[i11 + 28 >> 2];
    HEAP16[i15 + 6 >> 1] = HEAP32[i11 + 16 >> 2];
    i11 = i15 + 9 | 0;
    HEAP8[i11] = 0;
    HEAP32[i15 >> 2] = HEAP32[i29 >> 2];
    HEAP32[i29 >> 2] = i15;
    _luaX_next(i4);
    L124 : do {
     i12 = HEAP32[i5 >> 2] | 0;
     switch (i12 | 0) {
     case 277:
     case 286:
     case 262:
     case 261:
     case 260:
      {
       break L124;
      }
     default:
      {}
     }
     _statement(i4);
    } while ((i12 | 0) != 274);
    _check_match(i4, 277, 273, i6);
    _subexpr(i4, i8, 0) | 0;
    if ((HEAP32[i8 >> 2] | 0) == 1) {
     HEAP32[i8 >> 2] = 3;
    }
    _luaK_goiftrue(HEAP32[i3 >> 2] | 0, i8);
    i4 = HEAP32[i8 + 20 >> 2] | 0;
    if ((HEAP8[i11] | 0) != 0) {
     _luaK_patchclose(i9, i4, HEAPU8[i10] | 0);
    }
    _leaveblock(i9);
    _luaK_patchlist(i9, i4, i7);
    _leaveblock(i9);
    break;
   }
  case 285:
   {
    _luaX_next(i4);
    if ((HEAP32[i5 >> 2] | 0) != 288) {
     _error_expected(i4, 288);
    }
    i10 = HEAP32[i4 + 24 >> 2] | 0;
    _luaX_next(i4);
    i15 = HEAP32[i3 >> 2] | 0;
    i9 = i4 + 64 | 0;
    i14 = HEAP32[i9 >> 2] | 0;
    i12 = i14 + 24 | 0;
    i11 = i15 + 16 | 0;
    i16 = HEAP16[(HEAP32[i11 >> 2] | 0) + 4 >> 1] | 0;
    i13 = i14 + 28 | 0;
    L138 : do {
     if ((i16 | 0) < (HEAP32[i13 >> 2] | 0)) {
      while (1) {
       i17 = i16 + 1 | 0;
       if ((_luaS_eqstr(i10, HEAP32[(HEAP32[i12 >> 2] | 0) + (i16 << 4) >> 2] | 0) | 0) != 0) {
        break;
       }
       if ((i17 | 0) < (HEAP32[i13 >> 2] | 0)) {
        i16 = i17;
       } else {
        break L138;
       }
      }
      i28 = i15 + 12 | 0;
      i29 = HEAP32[(HEAP32[i28 >> 2] | 0) + 52 >> 2] | 0;
      i27 = HEAP32[(HEAP32[i12 >> 2] | 0) + (i16 << 4) + 8 >> 2] | 0;
      HEAP32[i8 >> 2] = i10 + 16;
      HEAP32[i8 + 4 >> 2] = i27;
      i29 = _luaO_pushfstring(i29, 6680, i8) | 0;
      _semerror(HEAP32[i28 >> 2] | 0, i29);
     }
    } while (0);
    if ((HEAP32[i5 >> 2] | 0) != 285) {
     _error_expected(i4, 285);
    }
    _luaX_next(i4);
    i8 = HEAP32[i15 + 20 >> 2] | 0;
    i15 = HEAP32[i13 >> 2] | 0;
    i14 = i14 + 32 | 0;
    if ((i15 | 0) < (HEAP32[i14 >> 2] | 0)) {
     i14 = HEAP32[i12 >> 2] | 0;
    } else {
     i14 = _luaM_growaux_(HEAP32[i1 >> 2] | 0, HEAP32[i12 >> 2] | 0, i14, 16, 32767, 6312) | 0;
     HEAP32[i12 >> 2] = i14;
    }
    HEAP32[i14 + (i15 << 4) >> 2] = i10;
    i29 = HEAP32[i12 >> 2] | 0;
    HEAP32[i29 + (i15 << 4) + 8 >> 2] = i6;
    HEAP8[i29 + (i15 << 4) + 12 | 0] = HEAP8[(HEAP32[i3 >> 2] | 0) + 46 | 0] | 0;
    HEAP32[(HEAP32[i12 >> 2] | 0) + (i15 << 4) + 4 >> 2] = i8;
    HEAP32[i13 >> 2] = (HEAP32[i13 >> 2] | 0) + 1;
    L152 : while (1) {
     switch (HEAP32[i5 >> 2] | 0) {
     case 285:
     case 59:
      {
       break;
      }
     case 286:
     case 262:
     case 261:
     case 260:
      {
       i7 = 108;
       break L152;
      }
     default:
      {
       break L152;
      }
     }
     _statement(i4);
    }
    if ((i7 | 0) == 108) {
     HEAP8[(HEAP32[i12 >> 2] | 0) + (i15 << 4) + 12 | 0] = HEAP8[(HEAP32[i11 >> 2] | 0) + 8 | 0] | 0;
    }
    i5 = (HEAP32[i12 >> 2] | 0) + (i15 << 4) | 0;
    i8 = HEAP32[i9 >> 2] | 0;
    i7 = HEAP16[(HEAP32[(HEAP32[i3 >> 2] | 0) + 16 >> 2] | 0) + 6 >> 1] | 0;
    i6 = i8 + 16 | 0;
    if ((i7 | 0) < (HEAP32[i6 >> 2] | 0)) {
     i8 = i8 + 12 | 0;
     do {
      while (1) {
       if ((_luaS_eqstr(HEAP32[(HEAP32[i8 >> 2] | 0) + (i7 << 4) >> 2] | 0, HEAP32[i5 >> 2] | 0) | 0) == 0) {
        break;
       }
       _closegoto(i4, i7, i5);
       if ((i7 | 0) >= (HEAP32[i6 >> 2] | 0)) {
        break L8;
       }
      }
      i7 = i7 + 1 | 0;
     } while ((i7 | 0) < (HEAP32[i6 >> 2] | 0));
    }
    break;
   }
  case 274:
   {
    _luaX_next(i4);
    i6 = HEAP32[i3 >> 2] | 0;
    L166 : do {
     switch (HEAP32[i5 >> 2] | 0) {
     case 59:
     case 277:
     case 286:
     case 262:
     case 261:
     case 260:
      {
       i8 = 0;
       i7 = 0;
       break;
      }
     default:
      {
       _subexpr(i4, i24, 0) | 0;
       if ((HEAP32[i5 >> 2] | 0) == 44) {
        i7 = 1;
        do {
         _luaX_next(i4);
         _luaK_exp2nextreg(HEAP32[i3 >> 2] | 0, i24);
         _subexpr(i4, i24, 0) | 0;
         i7 = i7 + 1 | 0;
        } while ((HEAP32[i5 >> 2] | 0) == 44);
       } else {
        i7 = 1;
       }
       if (!(((HEAP32[i24 >> 2] | 0) + -12 | 0) >>> 0 < 2)) {
        if ((i7 | 0) == 1) {
         i8 = _luaK_exp2anyreg(i6, i24) | 0;
         i7 = 1;
         break L166;
        } else {
         _luaK_exp2nextreg(i6, i24);
         i8 = HEAPU8[i6 + 46 | 0] | 0;
         break L166;
        }
       } else {
        _luaK_setreturns(i6, i24, -1);
        if ((HEAP32[i24 >> 2] | 0) == 12 & (i7 | 0) == 1) {
         i29 = (HEAP32[(HEAP32[i6 >> 2] | 0) + 12 >> 2] | 0) + (HEAP32[i24 + 8 >> 2] << 2) | 0;
         HEAP32[i29 >> 2] = HEAP32[i29 >> 2] & -64 | 30;
        }
        i8 = HEAPU8[i6 + 46 | 0] | 0;
        i7 = -1;
        break L166;
       }
      }
     }
    } while (0);
    _luaK_ret(i6, i8, i7);
    if ((HEAP32[i5 >> 2] | 0) == 59) {
     _luaX_next(i4);
    }
    break;
   }
  case 266:
  case 258:
   {
    i6 = _luaK_jump(i9) | 0;
    i7 = HEAP32[i19 >> 2] | 0;
    i29 = (HEAP32[i5 >> 2] | 0) == 266;
    _luaX_next(i4);
    do {
     if (i29) {
      if ((HEAP32[i5 >> 2] | 0) == 288) {
       i23 = HEAP32[i4 + 24 >> 2] | 0;
       _luaX_next(i4);
       break;
      } else {
       _error_expected(i4, 288);
      }
     } else {
      i23 = _luaS_new(HEAP32[i1 >> 2] | 0, 6304) | 0;
     }
    } while (0);
    i10 = HEAP32[i4 + 64 >> 2] | 0;
    i9 = i10 + 12 | 0;
    i5 = i10 + 16 | 0;
    i8 = HEAP32[i5 >> 2] | 0;
    i10 = i10 + 20 | 0;
    if ((i8 | 0) < (HEAP32[i10 >> 2] | 0)) {
     i10 = HEAP32[i9 >> 2] | 0;
    } else {
     i10 = _luaM_growaux_(HEAP32[i1 >> 2] | 0, HEAP32[i9 >> 2] | 0, i10, 16, 32767, 6312) | 0;
     HEAP32[i9 >> 2] = i10;
    }
    HEAP32[i10 + (i8 << 4) >> 2] = i23;
    i29 = HEAP32[i9 >> 2] | 0;
    HEAP32[i29 + (i8 << 4) + 8 >> 2] = i7;
    HEAP8[i29 + (i8 << 4) + 12 | 0] = HEAP8[(HEAP32[i3 >> 2] | 0) + 46 | 0] | 0;
    HEAP32[(HEAP32[i9 >> 2] | 0) + (i8 << 4) + 4 >> 2] = i6;
    HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + 1;
    _findlabel(i4, i8) | 0;
    break;
   }
  default:
   {
    i6 = i8 + 8 | 0;
    _suffixedexp(i4, i6);
    i29 = HEAP32[i5 >> 2] | 0;
    if ((i29 | 0) == 44 | (i29 | 0) == 61) {
     HEAP32[i8 >> 2] = 0;
     _assignment(i4, i8, 1);
     break L8;
    }
    if ((HEAP32[i6 >> 2] | 0) == 12) {
     i29 = (HEAP32[(HEAP32[i9 >> 2] | 0) + 12 >> 2] | 0) + (HEAP32[i8 + 16 >> 2] << 2) | 0;
     HEAP32[i29 >> 2] = HEAP32[i29 >> 2] & -8372225 | 16384;
     break L8;
    } else {
     _luaX_syntaxerror(i4, 6344);
    }
   }
  }
 } while (0);
 i29 = HEAP32[i3 >> 2] | 0;
 HEAP8[i29 + 48 | 0] = HEAP8[i29 + 46 | 0] | 0;
 i29 = (HEAP32[i1 >> 2] | 0) + 38 | 0;
 HEAP16[i29 >> 1] = (HEAP16[i29 >> 1] | 0) + -1 << 16 >> 16;
 STACKTOP = i2;
 return;
}
function _match(i1, i12, i11) {
 i1 = i1 | 0;
 i12 = i12 | 0;
 i11 = i11 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0, i31 = 0, i32 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i8 = i2;
 i32 = HEAP32[i1 >> 2] | 0;
 HEAP32[i1 >> 2] = i32 + -1;
 if ((i32 | 0) == 0) {
  _luaL_error(HEAP32[i1 + 16 >> 2] | 0, 7272, i8) | 0;
 }
 i14 = i1 + 12 | 0;
 i22 = HEAP32[i14 >> 2] | 0;
 L4 : do {
  if ((i22 | 0) != (i11 | 0)) {
   i3 = i1 + 8 | 0;
   i9 = i1 + 16 | 0;
   i16 = i1 + 4 | 0;
   i10 = i1 + 20 | 0;
   L6 : while (1) {
    i19 = i12 + 1 | 0;
    i20 = i12 + -1 | 0;
    L8 : while (1) {
     i23 = HEAP8[i11] | 0;
     i21 = i23 << 24 >> 24;
     L10 : do {
      if ((i21 | 0) == 36) {
       i7 = i11 + 1 | 0;
       if ((i7 | 0) == (i22 | 0)) {
        i7 = 23;
        break L6;
       } else {
        i22 = i7;
        i21 = i7;
        i7 = 89;
       }
      } else if ((i21 | 0) == 37) {
       i21 = i11 + 1 | 0;
       i23 = HEAP8[i21] | 0;
       switch (i23 << 24 >> 24 | 0) {
       case 57:
       case 56:
       case 55:
       case 54:
       case 53:
       case 52:
       case 51:
       case 50:
       case 49:
       case 48:
        {
         i7 = 69;
         break L8;
        }
       case 98:
        {
         i7 = 25;
         break L8;
        }
       case 102:
        {
         break;
        }
       default:
        {
         if ((i21 | 0) == (i22 | 0)) {
          _luaL_error(HEAP32[i9 >> 2] | 0, 7368, i8) | 0;
         }
         i22 = i11 + 2 | 0;
         i7 = 89;
         break L10;
        }
       }
       i22 = i11 + 2 | 0;
       if ((HEAP8[i22] | 0) == 91) {
        i21 = 91;
       } else {
        _luaL_error(HEAP32[i9 >> 2] | 0, 7296, i8) | 0;
        i21 = HEAP8[i22] | 0;
       }
       i23 = i11 + 3 | 0;
       i21 = i21 << 24 >> 24;
       if ((i21 | 0) == 91) {
        i21 = (HEAP8[i23] | 0) == 94 ? i11 + 4 | 0 : i23;
        while (1) {
         if ((i21 | 0) == (HEAP32[i14 >> 2] | 0)) {
          _luaL_error(HEAP32[i9 >> 2] | 0, 7408, i8) | 0;
         }
         i11 = i21 + 1 | 0;
         if ((HEAP8[i21] | 0) == 37) {
          i11 = i11 >>> 0 < (HEAP32[i14 >> 2] | 0) >>> 0 ? i21 + 2 | 0 : i11;
         }
         if ((HEAP8[i11] | 0) == 93) {
          break;
         } else {
          i21 = i11;
         }
        }
        i11 = i11 + 1 | 0;
       } else if ((i21 | 0) == 37) {
        if ((i23 | 0) == (HEAP32[i14 >> 2] | 0)) {
         _luaL_error(HEAP32[i9 >> 2] | 0, 7368, i8) | 0;
        }
        i11 = i11 + 4 | 0;
       } else {
        i11 = i23;
       }
       if ((i12 | 0) == (HEAP32[i16 >> 2] | 0)) {
        i25 = 0;
       } else {
        i25 = HEAP8[i20] | 0;
       }
       i24 = i25 & 255;
       i21 = i11 + -1 | 0;
       i26 = (HEAP8[i23] | 0) == 94;
       i28 = i26 ? i23 : i22;
       i27 = i26 & 1;
       i26 = i27 ^ 1;
       i30 = i28 + 1 | 0;
       L41 : do {
        if (i30 >>> 0 < i21 >>> 0) {
         while (1) {
          i32 = HEAP8[i30] | 0;
          i29 = i28 + 2 | 0;
          i31 = HEAP8[i29] | 0;
          do {
           if (i32 << 24 >> 24 == 37) {
            if ((_match_class(i24, i31 & 255) | 0) == 0) {
             i28 = i29;
            } else {
             break L41;
            }
           } else {
            if (i31 << 24 >> 24 == 45 ? (i18 = i28 + 3 | 0, i18 >>> 0 < i21 >>> 0) : 0) {
             if ((i32 & 255) > (i25 & 255)) {
              i28 = i18;
              break;
             }
             if ((HEAPU8[i18] | 0) < (i25 & 255)) {
              i28 = i18;
              break;
             } else {
              break L41;
             }
            }
            if (i32 << 24 >> 24 == i25 << 24 >> 24) {
             break L41;
            } else {
             i28 = i30;
            }
           }
          } while (0);
          i30 = i28 + 1 | 0;
          if (!(i30 >>> 0 < i21 >>> 0)) {
           i26 = i27;
           break;
          }
         }
        } else {
         i26 = i27;
        }
       } while (0);
       if ((i26 | 0) != 0) {
        i12 = 0;
        break L4;
       }
       i24 = HEAP8[i12] | 0;
       i25 = i24 & 255;
       i27 = (HEAP8[i23] | 0) == 94;
       i26 = i27 ? i23 : i22;
       i22 = i27 & 1;
       i23 = i22 ^ 1;
       i30 = i26 + 1 | 0;
       L55 : do {
        if (i30 >>> 0 < i21 >>> 0) {
         do {
          i29 = HEAP8[i30] | 0;
          i28 = i26 + 2 | 0;
          i27 = HEAP8[i28] | 0;
          do {
           if (i29 << 24 >> 24 == 37) {
            if ((_match_class(i25, i27 & 255) | 0) == 0) {
             i26 = i28;
            } else {
             i22 = i23;
             break L55;
            }
           } else {
            if (i27 << 24 >> 24 == 45 ? (i17 = i26 + 3 | 0, i17 >>> 0 < i21 >>> 0) : 0) {
             if ((i29 & 255) > (i24 & 255)) {
              i26 = i17;
              break;
             }
             if ((HEAPU8[i17] | 0) < (i24 & 255)) {
              i26 = i17;
              break;
             } else {
              i22 = i23;
              break L55;
             }
            }
            if (i29 << 24 >> 24 == i24 << 24 >> 24) {
             i22 = i23;
             break L55;
            } else {
             i26 = i30;
            }
           }
          } while (0);
          i30 = i26 + 1 | 0;
         } while (i30 >>> 0 < i21 >>> 0);
        }
       } while (0);
       if ((i22 | 0) == 0) {
        i12 = 0;
        break L4;
       }
      } else if ((i21 | 0) == 40) {
       i7 = 7;
       break L6;
      } else if ((i21 | 0) != 41) {
       i21 = i11 + 1 | 0;
       if (i23 << 24 >> 24 == 91) {
        i7 = (HEAP8[i21] | 0) == 94 ? i11 + 2 | 0 : i21;
        while (1) {
         if ((i7 | 0) == (i22 | 0)) {
          _luaL_error(HEAP32[i9 >> 2] | 0, 7408, i8) | 0;
         }
         i22 = i7 + 1 | 0;
         if ((HEAP8[i7] | 0) == 37) {
          i7 = i22 >>> 0 < (HEAP32[i14 >> 2] | 0) >>> 0 ? i7 + 2 | 0 : i22;
         } else {
          i7 = i22;
         }
         if ((HEAP8[i7] | 0) == 93) {
          break;
         }
         i22 = HEAP32[i14 >> 2] | 0;
        }
        i22 = i7 + 1 | 0;
        i7 = 89;
       } else {
        i22 = i21;
        i7 = 89;
       }
      } else {
       i7 = 16;
       break L6;
      }
     } while (0);
     L80 : do {
      if ((i7 | 0) == 89) {
       i7 = 0;
       do {
        if ((HEAP32[i3 >> 2] | 0) >>> 0 > i12 >>> 0) {
         i23 = HEAP8[i12] | 0;
         i24 = i23 & 255;
         i26 = HEAP8[i11] | 0;
         i25 = i26 << 24 >> 24;
         L85 : do {
          if ((i25 | 0) == 46) {
           i23 = HEAP8[i22] | 0;
          } else if ((i25 | 0) == 37) {
           i25 = _match_class(i24, HEAPU8[i21] | 0) | 0;
           i7 = 104;
          } else if ((i25 | 0) == 91) {
           i7 = i22 + -1 | 0;
           i25 = (HEAP8[i21] | 0) == 94;
           i27 = i25 ? i21 : i11;
           i26 = i25 & 1;
           i25 = i26 ^ 1;
           i30 = i27 + 1 | 0;
           if (i30 >>> 0 < i7 >>> 0) {
            while (1) {
             i31 = HEAP8[i30] | 0;
             i29 = i27 + 2 | 0;
             i28 = HEAP8[i29] | 0;
             do {
              if (i31 << 24 >> 24 == 37) {
               if ((_match_class(i24, i28 & 255) | 0) == 0) {
                i27 = i29;
               } else {
                i7 = 104;
                break L85;
               }
              } else {
               if (i28 << 24 >> 24 == 45 ? (i13 = i27 + 3 | 0, i13 >>> 0 < i7 >>> 0) : 0) {
                if ((i31 & 255) > (i23 & 255)) {
                 i27 = i13;
                 break;
                }
                if ((HEAPU8[i13] | 0) < (i23 & 255)) {
                 i27 = i13;
                 break;
                } else {
                 i7 = 104;
                 break L85;
                }
               }
               if (i31 << 24 >> 24 == i23 << 24 >> 24) {
                i7 = 104;
                break L85;
               } else {
                i27 = i30;
               }
              }
             } while (0);
             i30 = i27 + 1 | 0;
             if (!(i30 >>> 0 < i7 >>> 0)) {
              i25 = i26;
              i7 = 104;
              break;
             }
            }
           } else {
            i25 = i26;
            i7 = 104;
           }
          } else {
           i25 = i26 << 24 >> 24 == i23 << 24 >> 24 | 0;
           i7 = 104;
          }
         } while (0);
         if ((i7 | 0) == 104) {
          i7 = 0;
          i23 = HEAP8[i22] | 0;
          if ((i25 | 0) == 0) {
           break;
          }
         }
         i23 = i23 << 24 >> 24;
         if ((i23 | 0) == 45) {
          i7 = 109;
          break L6;
         } else if ((i23 | 0) == 42) {
          i7 = 112;
          break L6;
         } else if ((i23 | 0) == 43) {
          break L6;
         } else if ((i23 | 0) != 63) {
          i12 = i19;
          i11 = i22;
          break L8;
         }
         i11 = i22 + 1 | 0;
         i21 = _match(i1, i19, i11) | 0;
         if ((i21 | 0) == 0) {
          break L80;
         } else {
          i12 = i21;
          break L4;
         }
        } else {
         i23 = HEAP8[i22] | 0;
        }
       } while (0);
       if (!(i23 << 24 >> 24 == 45 | i23 << 24 >> 24 == 63 | i23 << 24 >> 24 == 42)) {
        i12 = 0;
        break L4;
       }
       i11 = i22 + 1 | 0;
      }
     } while (0);
     i22 = HEAP32[i14 >> 2] | 0;
     if ((i11 | 0) == (i22 | 0)) {
      break L4;
     }
    }
    if ((i7 | 0) == 25) {
     i7 = 0;
     i21 = i11 + 2 | 0;
     if (!((i22 + -1 | 0) >>> 0 > i21 >>> 0)) {
      _luaL_error(HEAP32[i9 >> 2] | 0, 7440, i8) | 0;
     }
     i20 = HEAP8[i12] | 0;
     if (!(i20 << 24 >> 24 == (HEAP8[i21] | 0))) {
      i12 = 0;
      break L4;
     }
     i21 = HEAP8[i11 + 3 | 0] | 0;
     i22 = HEAP32[i3 >> 2] | 0;
     if (i19 >>> 0 < i22 >>> 0) {
      i24 = 1;
     } else {
      i12 = 0;
      break L4;
     }
     while (1) {
      i23 = HEAP8[i19] | 0;
      if (i23 << 24 >> 24 == i21 << 24 >> 24) {
       i24 = i24 + -1 | 0;
       if ((i24 | 0) == 0) {
        break;
       }
      } else {
       i24 = (i23 << 24 >> 24 == i20 << 24 >> 24) + i24 | 0;
      }
      i12 = i19 + 1 | 0;
      if (i12 >>> 0 < i22 >>> 0) {
       i32 = i19;
       i19 = i12;
       i12 = i32;
      } else {
       i12 = 0;
       break L4;
      }
     }
     i12 = i12 + 2 | 0;
     i11 = i11 + 4 | 0;
    } else if ((i7 | 0) == 69) {
     i7 = 0;
     i20 = i23 & 255;
     i19 = i20 + -49 | 0;
     if (((i19 | 0) >= 0 ? (i19 | 0) < (HEAP32[i10 >> 2] | 0) : 0) ? (i15 = HEAP32[i1 + (i19 << 3) + 28 >> 2] | 0, !((i15 | 0) == -1)) : 0) {
      i20 = i15;
     } else {
      i19 = HEAP32[i9 >> 2] | 0;
      HEAP32[i8 >> 2] = i20 + -48;
      i20 = _luaL_error(i19, 7336, i8) | 0;
      i19 = i20;
      i20 = HEAP32[i1 + (i20 << 3) + 28 >> 2] | 0;
     }
     if (((HEAP32[i3 >> 2] | 0) - i12 | 0) >>> 0 < i20 >>> 0) {
      i12 = 0;
      break L4;
     }
     if ((_memcmp(HEAP32[i1 + (i19 << 3) + 24 >> 2] | 0, i12, i20) | 0) != 0) {
      i12 = 0;
      break L4;
     }
     i12 = i12 + i20 | 0;
     if ((i12 | 0) == 0) {
      i12 = 0;
      break L4;
     }
     i11 = i11 + 2 | 0;
    }
    i22 = HEAP32[i14 >> 2] | 0;
    if ((i11 | 0) == (i22 | 0)) {
     break L4;
    }
   }
   if ((i7 | 0) == 7) {
    i3 = i11 + 1 | 0;
    if ((HEAP8[i3] | 0) == 41) {
     i3 = HEAP32[i10 >> 2] | 0;
     if ((i3 | 0) > 31) {
      _luaL_error(HEAP32[i9 >> 2] | 0, 7200, i8) | 0;
     }
     HEAP32[i1 + (i3 << 3) + 24 >> 2] = i12;
     HEAP32[i1 + (i3 << 3) + 28 >> 2] = -2;
     HEAP32[i10 >> 2] = i3 + 1;
     i12 = _match(i1, i12, i11 + 2 | 0) | 0;
     if ((i12 | 0) != 0) {
      break;
     }
     HEAP32[i10 >> 2] = (HEAP32[i10 >> 2] | 0) + -1;
     i12 = 0;
     break;
    } else {
     i4 = HEAP32[i10 >> 2] | 0;
     if ((i4 | 0) > 31) {
      _luaL_error(HEAP32[i9 >> 2] | 0, 7200, i8) | 0;
     }
     HEAP32[i1 + (i4 << 3) + 24 >> 2] = i12;
     HEAP32[i1 + (i4 << 3) + 28 >> 2] = -1;
     HEAP32[i10 >> 2] = i4 + 1;
     i12 = _match(i1, i12, i3) | 0;
     if ((i12 | 0) != 0) {
      break;
     }
     HEAP32[i10 >> 2] = (HEAP32[i10 >> 2] | 0) + -1;
     i12 = 0;
     break;
    }
   } else if ((i7 | 0) == 16) {
    i3 = i11 + 1 | 0;
    i5 = HEAP32[i10 >> 2] | 0;
    while (1) {
     i4 = i5 + -1 | 0;
     if ((i5 | 0) <= 0) {
      i7 = 19;
      break;
     }
     if ((HEAP32[i1 + (i4 << 3) + 28 >> 2] | 0) == -1) {
      break;
     } else {
      i5 = i4;
     }
    }
    if ((i7 | 0) == 19) {
     i4 = _luaL_error(HEAP32[i9 >> 2] | 0, 7488, i8) | 0;
    }
    i5 = i1 + (i4 << 3) + 28 | 0;
    HEAP32[i5 >> 2] = i12 - (HEAP32[i1 + (i4 << 3) + 24 >> 2] | 0);
    i12 = _match(i1, i12, i3) | 0;
    if ((i12 | 0) != 0) {
     break;
    }
    HEAP32[i5 >> 2] = -1;
    i12 = 0;
    break;
   } else if ((i7 | 0) == 23) {
    i12 = (i12 | 0) == (HEAP32[i3 >> 2] | 0) ? i12 : 0;
    break;
   } else if ((i7 | 0) == 109) {
    i4 = i22 + 1 | 0;
    i8 = _match(i1, i12, i4) | 0;
    if ((i8 | 0) != 0) {
     i12 = i8;
     break;
    }
    i8 = i22 + -1 | 0;
    while (1) {
     if (!((HEAP32[i3 >> 2] | 0) >>> 0 > i12 >>> 0)) {
      i12 = 0;
      break L4;
     }
     i9 = HEAP8[i12] | 0;
     i10 = i9 & 255;
     i14 = HEAP8[i11] | 0;
     i13 = i14 << 24 >> 24;
     L139 : do {
      if ((i13 | 0) == 91) {
       i6 = (HEAP8[i21] | 0) == 94;
       i13 = i6 ? i21 : i11;
       i6 = i6 & 1;
       i7 = i6 ^ 1;
       i14 = i13 + 1 | 0;
       if (i14 >>> 0 < i8 >>> 0) {
        while (1) {
         i17 = HEAP8[i14] | 0;
         i15 = i13 + 2 | 0;
         i16 = HEAP8[i15] | 0;
         do {
          if (i17 << 24 >> 24 == 37) {
           if ((_match_class(i10, i16 & 255) | 0) == 0) {
            i13 = i15;
           } else {
            i6 = i7;
            i7 = 147;
            break L139;
           }
          } else {
           if (i16 << 24 >> 24 == 45 ? (i5 = i13 + 3 | 0, i5 >>> 0 < i8 >>> 0) : 0) {
            if ((i17 & 255) > (i9 & 255)) {
             i13 = i5;
             break;
            }
            if ((HEAPU8[i5] | 0) < (i9 & 255)) {
             i13 = i5;
             break;
            } else {
             i6 = i7;
             i7 = 147;
             break L139;
            }
           }
           if (i17 << 24 >> 24 == i9 << 24 >> 24) {
            i6 = i7;
            i7 = 147;
            break L139;
           } else {
            i13 = i14;
           }
          }
         } while (0);
         i14 = i13 + 1 | 0;
         if (!(i14 >>> 0 < i8 >>> 0)) {
          i7 = 147;
          break;
         }
        }
       } else {
        i7 = 147;
       }
      } else if ((i13 | 0) == 37) {
       i6 = _match_class(i10, HEAPU8[i21] | 0) | 0;
       i7 = 147;
      } else if ((i13 | 0) != 46) {
       i6 = i14 << 24 >> 24 == i9 << 24 >> 24 | 0;
       i7 = 147;
      }
     } while (0);
     if ((i7 | 0) == 147 ? (i7 = 0, (i6 | 0) == 0) : 0) {
      i12 = 0;
      break L4;
     }
     i9 = i12 + 1 | 0;
     i12 = _match(i1, i9, i4) | 0;
     if ((i12 | 0) == 0) {
      i12 = i9;
     } else {
      break L4;
     }
    }
   } else if ((i7 | 0) == 112) {
    i19 = i12;
   }
   i10 = HEAP32[i3 >> 2] | 0;
   if (i10 >>> 0 > i19 >>> 0) {
    i5 = i22 + -1 | 0;
    i8 = i19;
    i6 = 0;
    do {
     i8 = HEAP8[i8] | 0;
     i9 = i8 & 255;
     i13 = HEAP8[i11] | 0;
     i12 = i13 << 24 >> 24;
     L183 : do {
      if ((i12 | 0) == 37) {
       i10 = _match_class(i9, HEAPU8[i21] | 0) | 0;
       i7 = 129;
      } else if ((i12 | 0) == 91) {
       i7 = (HEAP8[i21] | 0) == 94;
       i12 = i7 ? i21 : i11;
       i10 = i7 & 1;
       i7 = i10 ^ 1;
       i13 = i12 + 1 | 0;
       if (i13 >>> 0 < i5 >>> 0) {
        while (1) {
         i14 = HEAP8[i13] | 0;
         i16 = i12 + 2 | 0;
         i15 = HEAP8[i16] | 0;
         do {
          if (i14 << 24 >> 24 == 37) {
           if ((_match_class(i9, i15 & 255) | 0) == 0) {
            i12 = i16;
           } else {
            i10 = i7;
            i7 = 129;
            break L183;
           }
          } else {
           if (i15 << 24 >> 24 == 45 ? (i4 = i12 + 3 | 0, i4 >>> 0 < i5 >>> 0) : 0) {
            if ((i14 & 255) > (i8 & 255)) {
             i12 = i4;
             break;
            }
            if ((HEAPU8[i4] | 0) < (i8 & 255)) {
             i12 = i4;
             break;
            } else {
             i10 = i7;
             i7 = 129;
             break L183;
            }
           }
           if (i14 << 24 >> 24 == i8 << 24 >> 24) {
            i10 = i7;
            i7 = 129;
            break L183;
           } else {
            i12 = i13;
           }
          }
         } while (0);
         i13 = i12 + 1 | 0;
         if (!(i13 >>> 0 < i5 >>> 0)) {
          i7 = 129;
          break;
         }
        }
       } else {
        i7 = 129;
       }
      } else if ((i12 | 0) != 46) {
       i10 = i13 << 24 >> 24 == i8 << 24 >> 24 | 0;
       i7 = 129;
      }
     } while (0);
     if ((i7 | 0) == 129) {
      i7 = 0;
      if ((i10 | 0) == 0) {
       break;
      }
      i10 = HEAP32[i3 >> 2] | 0;
     }
     i6 = i6 + 1 | 0;
     i8 = i19 + i6 | 0;
    } while (i10 >>> 0 > i8 >>> 0);
    if (!((i6 | 0) > -1)) {
     i12 = 0;
     break;
    }
   } else {
    i6 = 0;
   }
   i3 = i22 + 1 | 0;
   while (1) {
    i12 = _match(i1, i19 + i6 | 0, i3) | 0;
    if ((i12 | 0) != 0) {
     break L4;
    }
    if ((i6 | 0) > 0) {
     i6 = i6 + -1 | 0;
    } else {
     i12 = 0;
     break;
    }
   }
  }
 } while (0);
 HEAP32[i1 >> 2] = (HEAP32[i1 >> 2] | 0) + 1;
 STACKTOP = i2;
 return i12 | 0;
}
function _free(i7) {
 i7 = i7 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0;
 i1 = STACKTOP;
 if ((i7 | 0) == 0) {
  STACKTOP = i1;
  return;
 }
 i15 = i7 + -8 | 0;
 i16 = HEAP32[12928 >> 2] | 0;
 if (i15 >>> 0 < i16 >>> 0) {
  _abort();
 }
 i13 = HEAP32[i7 + -4 >> 2] | 0;
 i12 = i13 & 3;
 if ((i12 | 0) == 1) {
  _abort();
 }
 i8 = i13 & -8;
 i6 = i7 + (i8 + -8) | 0;
 do {
  if ((i13 & 1 | 0) == 0) {
   i19 = HEAP32[i15 >> 2] | 0;
   if ((i12 | 0) == 0) {
    STACKTOP = i1;
    return;
   }
   i15 = -8 - i19 | 0;
   i13 = i7 + i15 | 0;
   i12 = i19 + i8 | 0;
   if (i13 >>> 0 < i16 >>> 0) {
    _abort();
   }
   if ((i13 | 0) == (HEAP32[12932 >> 2] | 0)) {
    i2 = i7 + (i8 + -4) | 0;
    if ((HEAP32[i2 >> 2] & 3 | 0) != 3) {
     i2 = i13;
     i11 = i12;
     break;
    }
    HEAP32[12920 >> 2] = i12;
    HEAP32[i2 >> 2] = HEAP32[i2 >> 2] & -2;
    HEAP32[i7 + (i15 + 4) >> 2] = i12 | 1;
    HEAP32[i6 >> 2] = i12;
    STACKTOP = i1;
    return;
   }
   i18 = i19 >>> 3;
   if (i19 >>> 0 < 256) {
    i2 = HEAP32[i7 + (i15 + 8) >> 2] | 0;
    i11 = HEAP32[i7 + (i15 + 12) >> 2] | 0;
    i14 = 12952 + (i18 << 1 << 2) | 0;
    if ((i2 | 0) != (i14 | 0)) {
     if (i2 >>> 0 < i16 >>> 0) {
      _abort();
     }
     if ((HEAP32[i2 + 12 >> 2] | 0) != (i13 | 0)) {
      _abort();
     }
    }
    if ((i11 | 0) == (i2 | 0)) {
     HEAP32[3228] = HEAP32[3228] & ~(1 << i18);
     i2 = i13;
     i11 = i12;
     break;
    }
    if ((i11 | 0) != (i14 | 0)) {
     if (i11 >>> 0 < i16 >>> 0) {
      _abort();
     }
     i14 = i11 + 8 | 0;
     if ((HEAP32[i14 >> 2] | 0) == (i13 | 0)) {
      i17 = i14;
     } else {
      _abort();
     }
    } else {
     i17 = i11 + 8 | 0;
    }
    HEAP32[i2 + 12 >> 2] = i11;
    HEAP32[i17 >> 2] = i2;
    i2 = i13;
    i11 = i12;
    break;
   }
   i17 = HEAP32[i7 + (i15 + 24) >> 2] | 0;
   i18 = HEAP32[i7 + (i15 + 12) >> 2] | 0;
   do {
    if ((i18 | 0) == (i13 | 0)) {
     i19 = i7 + (i15 + 20) | 0;
     i18 = HEAP32[i19 >> 2] | 0;
     if ((i18 | 0) == 0) {
      i19 = i7 + (i15 + 16) | 0;
      i18 = HEAP32[i19 >> 2] | 0;
      if ((i18 | 0) == 0) {
       i14 = 0;
       break;
      }
     }
     while (1) {
      i21 = i18 + 20 | 0;
      i20 = HEAP32[i21 >> 2] | 0;
      if ((i20 | 0) != 0) {
       i18 = i20;
       i19 = i21;
       continue;
      }
      i20 = i18 + 16 | 0;
      i21 = HEAP32[i20 >> 2] | 0;
      if ((i21 | 0) == 0) {
       break;
      } else {
       i18 = i21;
       i19 = i20;
      }
     }
     if (i19 >>> 0 < i16 >>> 0) {
      _abort();
     } else {
      HEAP32[i19 >> 2] = 0;
      i14 = i18;
      break;
     }
    } else {
     i19 = HEAP32[i7 + (i15 + 8) >> 2] | 0;
     if (i19 >>> 0 < i16 >>> 0) {
      _abort();
     }
     i16 = i19 + 12 | 0;
     if ((HEAP32[i16 >> 2] | 0) != (i13 | 0)) {
      _abort();
     }
     i20 = i18 + 8 | 0;
     if ((HEAP32[i20 >> 2] | 0) == (i13 | 0)) {
      HEAP32[i16 >> 2] = i18;
      HEAP32[i20 >> 2] = i19;
      i14 = i18;
      break;
     } else {
      _abort();
     }
    }
   } while (0);
   if ((i17 | 0) != 0) {
    i18 = HEAP32[i7 + (i15 + 28) >> 2] | 0;
    i16 = 13216 + (i18 << 2) | 0;
    if ((i13 | 0) == (HEAP32[i16 >> 2] | 0)) {
     HEAP32[i16 >> 2] = i14;
     if ((i14 | 0) == 0) {
      HEAP32[12916 >> 2] = HEAP32[12916 >> 2] & ~(1 << i18);
      i2 = i13;
      i11 = i12;
      break;
     }
    } else {
     if (i17 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     }
     i16 = i17 + 16 | 0;
     if ((HEAP32[i16 >> 2] | 0) == (i13 | 0)) {
      HEAP32[i16 >> 2] = i14;
     } else {
      HEAP32[i17 + 20 >> 2] = i14;
     }
     if ((i14 | 0) == 0) {
      i2 = i13;
      i11 = i12;
      break;
     }
    }
    if (i14 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
     _abort();
    }
    HEAP32[i14 + 24 >> 2] = i17;
    i16 = HEAP32[i7 + (i15 + 16) >> 2] | 0;
    do {
     if ((i16 | 0) != 0) {
      if (i16 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
       _abort();
      } else {
       HEAP32[i14 + 16 >> 2] = i16;
       HEAP32[i16 + 24 >> 2] = i14;
       break;
      }
     }
    } while (0);
    i15 = HEAP32[i7 + (i15 + 20) >> 2] | 0;
    if ((i15 | 0) != 0) {
     if (i15 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     } else {
      HEAP32[i14 + 20 >> 2] = i15;
      HEAP32[i15 + 24 >> 2] = i14;
      i2 = i13;
      i11 = i12;
      break;
     }
    } else {
     i2 = i13;
     i11 = i12;
    }
   } else {
    i2 = i13;
    i11 = i12;
   }
  } else {
   i2 = i15;
   i11 = i8;
  }
 } while (0);
 if (!(i2 >>> 0 < i6 >>> 0)) {
  _abort();
 }
 i12 = i7 + (i8 + -4) | 0;
 i13 = HEAP32[i12 >> 2] | 0;
 if ((i13 & 1 | 0) == 0) {
  _abort();
 }
 if ((i13 & 2 | 0) == 0) {
  if ((i6 | 0) == (HEAP32[12936 >> 2] | 0)) {
   i21 = (HEAP32[12924 >> 2] | 0) + i11 | 0;
   HEAP32[12924 >> 2] = i21;
   HEAP32[12936 >> 2] = i2;
   HEAP32[i2 + 4 >> 2] = i21 | 1;
   if ((i2 | 0) != (HEAP32[12932 >> 2] | 0)) {
    STACKTOP = i1;
    return;
   }
   HEAP32[12932 >> 2] = 0;
   HEAP32[12920 >> 2] = 0;
   STACKTOP = i1;
   return;
  }
  if ((i6 | 0) == (HEAP32[12932 >> 2] | 0)) {
   i21 = (HEAP32[12920 >> 2] | 0) + i11 | 0;
   HEAP32[12920 >> 2] = i21;
   HEAP32[12932 >> 2] = i2;
   HEAP32[i2 + 4 >> 2] = i21 | 1;
   HEAP32[i2 + i21 >> 2] = i21;
   STACKTOP = i1;
   return;
  }
  i11 = (i13 & -8) + i11 | 0;
  i12 = i13 >>> 3;
  do {
   if (!(i13 >>> 0 < 256)) {
    i10 = HEAP32[i7 + (i8 + 16) >> 2] | 0;
    i15 = HEAP32[i7 + (i8 | 4) >> 2] | 0;
    do {
     if ((i15 | 0) == (i6 | 0)) {
      i13 = i7 + (i8 + 12) | 0;
      i12 = HEAP32[i13 >> 2] | 0;
      if ((i12 | 0) == 0) {
       i13 = i7 + (i8 + 8) | 0;
       i12 = HEAP32[i13 >> 2] | 0;
       if ((i12 | 0) == 0) {
        i9 = 0;
        break;
       }
      }
      while (1) {
       i14 = i12 + 20 | 0;
       i15 = HEAP32[i14 >> 2] | 0;
       if ((i15 | 0) != 0) {
        i12 = i15;
        i13 = i14;
        continue;
       }
       i14 = i12 + 16 | 0;
       i15 = HEAP32[i14 >> 2] | 0;
       if ((i15 | 0) == 0) {
        break;
       } else {
        i12 = i15;
        i13 = i14;
       }
      }
      if (i13 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
       _abort();
      } else {
       HEAP32[i13 >> 2] = 0;
       i9 = i12;
       break;
      }
     } else {
      i13 = HEAP32[i7 + i8 >> 2] | 0;
      if (i13 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
       _abort();
      }
      i14 = i13 + 12 | 0;
      if ((HEAP32[i14 >> 2] | 0) != (i6 | 0)) {
       _abort();
      }
      i12 = i15 + 8 | 0;
      if ((HEAP32[i12 >> 2] | 0) == (i6 | 0)) {
       HEAP32[i14 >> 2] = i15;
       HEAP32[i12 >> 2] = i13;
       i9 = i15;
       break;
      } else {
       _abort();
      }
     }
    } while (0);
    if ((i10 | 0) != 0) {
     i12 = HEAP32[i7 + (i8 + 20) >> 2] | 0;
     i13 = 13216 + (i12 << 2) | 0;
     if ((i6 | 0) == (HEAP32[i13 >> 2] | 0)) {
      HEAP32[i13 >> 2] = i9;
      if ((i9 | 0) == 0) {
       HEAP32[12916 >> 2] = HEAP32[12916 >> 2] & ~(1 << i12);
       break;
      }
     } else {
      if (i10 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
       _abort();
      }
      i12 = i10 + 16 | 0;
      if ((HEAP32[i12 >> 2] | 0) == (i6 | 0)) {
       HEAP32[i12 >> 2] = i9;
      } else {
       HEAP32[i10 + 20 >> 2] = i9;
      }
      if ((i9 | 0) == 0) {
       break;
      }
     }
     if (i9 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     }
     HEAP32[i9 + 24 >> 2] = i10;
     i6 = HEAP32[i7 + (i8 + 8) >> 2] | 0;
     do {
      if ((i6 | 0) != 0) {
       if (i6 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
        _abort();
       } else {
        HEAP32[i9 + 16 >> 2] = i6;
        HEAP32[i6 + 24 >> 2] = i9;
        break;
       }
      }
     } while (0);
     i6 = HEAP32[i7 + (i8 + 12) >> 2] | 0;
     if ((i6 | 0) != 0) {
      if (i6 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
       _abort();
      } else {
       HEAP32[i9 + 20 >> 2] = i6;
       HEAP32[i6 + 24 >> 2] = i9;
       break;
      }
     }
    }
   } else {
    i9 = HEAP32[i7 + i8 >> 2] | 0;
    i7 = HEAP32[i7 + (i8 | 4) >> 2] | 0;
    i8 = 12952 + (i12 << 1 << 2) | 0;
    if ((i9 | 0) != (i8 | 0)) {
     if (i9 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     }
     if ((HEAP32[i9 + 12 >> 2] | 0) != (i6 | 0)) {
      _abort();
     }
    }
    if ((i7 | 0) == (i9 | 0)) {
     HEAP32[3228] = HEAP32[3228] & ~(1 << i12);
     break;
    }
    if ((i7 | 0) != (i8 | 0)) {
     if (i7 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     }
     i8 = i7 + 8 | 0;
     if ((HEAP32[i8 >> 2] | 0) == (i6 | 0)) {
      i10 = i8;
     } else {
      _abort();
     }
    } else {
     i10 = i7 + 8 | 0;
    }
    HEAP32[i9 + 12 >> 2] = i7;
    HEAP32[i10 >> 2] = i9;
   }
  } while (0);
  HEAP32[i2 + 4 >> 2] = i11 | 1;
  HEAP32[i2 + i11 >> 2] = i11;
  if ((i2 | 0) == (HEAP32[12932 >> 2] | 0)) {
   HEAP32[12920 >> 2] = i11;
   STACKTOP = i1;
   return;
  }
 } else {
  HEAP32[i12 >> 2] = i13 & -2;
  HEAP32[i2 + 4 >> 2] = i11 | 1;
  HEAP32[i2 + i11 >> 2] = i11;
 }
 i6 = i11 >>> 3;
 if (i11 >>> 0 < 256) {
  i7 = i6 << 1;
  i3 = 12952 + (i7 << 2) | 0;
  i8 = HEAP32[3228] | 0;
  i6 = 1 << i6;
  if ((i8 & i6 | 0) != 0) {
   i6 = 12952 + (i7 + 2 << 2) | 0;
   i7 = HEAP32[i6 >> 2] | 0;
   if (i7 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
    _abort();
   } else {
    i4 = i6;
    i5 = i7;
   }
  } else {
   HEAP32[3228] = i8 | i6;
   i4 = 12952 + (i7 + 2 << 2) | 0;
   i5 = i3;
  }
  HEAP32[i4 >> 2] = i2;
  HEAP32[i5 + 12 >> 2] = i2;
  HEAP32[i2 + 8 >> 2] = i5;
  HEAP32[i2 + 12 >> 2] = i3;
  STACKTOP = i1;
  return;
 }
 i4 = i11 >>> 8;
 if ((i4 | 0) != 0) {
  if (i11 >>> 0 > 16777215) {
   i4 = 31;
  } else {
   i20 = (i4 + 1048320 | 0) >>> 16 & 8;
   i21 = i4 << i20;
   i19 = (i21 + 520192 | 0) >>> 16 & 4;
   i21 = i21 << i19;
   i4 = (i21 + 245760 | 0) >>> 16 & 2;
   i4 = 14 - (i19 | i20 | i4) + (i21 << i4 >>> 15) | 0;
   i4 = i11 >>> (i4 + 7 | 0) & 1 | i4 << 1;
  }
 } else {
  i4 = 0;
 }
 i5 = 13216 + (i4 << 2) | 0;
 HEAP32[i2 + 28 >> 2] = i4;
 HEAP32[i2 + 20 >> 2] = 0;
 HEAP32[i2 + 16 >> 2] = 0;
 i7 = HEAP32[12916 >> 2] | 0;
 i6 = 1 << i4;
 L199 : do {
  if ((i7 & i6 | 0) != 0) {
   i5 = HEAP32[i5 >> 2] | 0;
   if ((i4 | 0) == 31) {
    i4 = 0;
   } else {
    i4 = 25 - (i4 >>> 1) | 0;
   }
   L204 : do {
    if ((HEAP32[i5 + 4 >> 2] & -8 | 0) != (i11 | 0)) {
     i4 = i11 << i4;
     i7 = i5;
     while (1) {
      i6 = i7 + (i4 >>> 31 << 2) + 16 | 0;
      i5 = HEAP32[i6 >> 2] | 0;
      if ((i5 | 0) == 0) {
       break;
      }
      if ((HEAP32[i5 + 4 >> 2] & -8 | 0) == (i11 | 0)) {
       i3 = i5;
       break L204;
      } else {
       i4 = i4 << 1;
       i7 = i5;
      }
     }
     if (i6 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     } else {
      HEAP32[i6 >> 2] = i2;
      HEAP32[i2 + 24 >> 2] = i7;
      HEAP32[i2 + 12 >> 2] = i2;
      HEAP32[i2 + 8 >> 2] = i2;
      break L199;
     }
    } else {
     i3 = i5;
    }
   } while (0);
   i5 = i3 + 8 | 0;
   i4 = HEAP32[i5 >> 2] | 0;
   i6 = HEAP32[12928 >> 2] | 0;
   if (i3 >>> 0 < i6 >>> 0) {
    _abort();
   }
   if (i4 >>> 0 < i6 >>> 0) {
    _abort();
   } else {
    HEAP32[i4 + 12 >> 2] = i2;
    HEAP32[i5 >> 2] = i2;
    HEAP32[i2 + 8 >> 2] = i4;
    HEAP32[i2 + 12 >> 2] = i3;
    HEAP32[i2 + 24 >> 2] = 0;
    break;
   }
  } else {
   HEAP32[12916 >> 2] = i7 | i6;
   HEAP32[i5 >> 2] = i2;
   HEAP32[i2 + 24 >> 2] = i5;
   HEAP32[i2 + 12 >> 2] = i2;
   HEAP32[i2 + 8 >> 2] = i2;
  }
 } while (0);
 i21 = (HEAP32[12944 >> 2] | 0) + -1 | 0;
 HEAP32[12944 >> 2] = i21;
 if ((i21 | 0) == 0) {
  i2 = 13368 | 0;
 } else {
  STACKTOP = i1;
  return;
 }
 while (1) {
  i2 = HEAP32[i2 >> 2] | 0;
  if ((i2 | 0) == 0) {
   break;
  } else {
   i2 = i2 + 8 | 0;
  }
 }
 HEAP32[12944 >> 2] = -1;
 STACKTOP = i1;
 return;
}
function _dispose_chunk(i6, i7) {
 i6 = i6 | 0;
 i7 = i7 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0;
 i1 = STACKTOP;
 i5 = i6 + i7 | 0;
 i10 = HEAP32[i6 + 4 >> 2] | 0;
 do {
  if ((i10 & 1 | 0) == 0) {
   i14 = HEAP32[i6 >> 2] | 0;
   if ((i10 & 3 | 0) == 0) {
    STACKTOP = i1;
    return;
   }
   i10 = i6 + (0 - i14) | 0;
   i11 = i14 + i7 | 0;
   i15 = HEAP32[12928 >> 2] | 0;
   if (i10 >>> 0 < i15 >>> 0) {
    _abort();
   }
   if ((i10 | 0) == (HEAP32[12932 >> 2] | 0)) {
    i2 = i6 + (i7 + 4) | 0;
    if ((HEAP32[i2 >> 2] & 3 | 0) != 3) {
     i2 = i10;
     i12 = i11;
     break;
    }
    HEAP32[12920 >> 2] = i11;
    HEAP32[i2 >> 2] = HEAP32[i2 >> 2] & -2;
    HEAP32[i6 + (4 - i14) >> 2] = i11 | 1;
    HEAP32[i5 >> 2] = i11;
    STACKTOP = i1;
    return;
   }
   i17 = i14 >>> 3;
   if (i14 >>> 0 < 256) {
    i2 = HEAP32[i6 + (8 - i14) >> 2] | 0;
    i12 = HEAP32[i6 + (12 - i14) >> 2] | 0;
    i13 = 12952 + (i17 << 1 << 2) | 0;
    if ((i2 | 0) != (i13 | 0)) {
     if (i2 >>> 0 < i15 >>> 0) {
      _abort();
     }
     if ((HEAP32[i2 + 12 >> 2] | 0) != (i10 | 0)) {
      _abort();
     }
    }
    if ((i12 | 0) == (i2 | 0)) {
     HEAP32[3228] = HEAP32[3228] & ~(1 << i17);
     i2 = i10;
     i12 = i11;
     break;
    }
    if ((i12 | 0) != (i13 | 0)) {
     if (i12 >>> 0 < i15 >>> 0) {
      _abort();
     }
     i13 = i12 + 8 | 0;
     if ((HEAP32[i13 >> 2] | 0) == (i10 | 0)) {
      i16 = i13;
     } else {
      _abort();
     }
    } else {
     i16 = i12 + 8 | 0;
    }
    HEAP32[i2 + 12 >> 2] = i12;
    HEAP32[i16 >> 2] = i2;
    i2 = i10;
    i12 = i11;
    break;
   }
   i16 = HEAP32[i6 + (24 - i14) >> 2] | 0;
   i18 = HEAP32[i6 + (12 - i14) >> 2] | 0;
   do {
    if ((i18 | 0) == (i10 | 0)) {
     i19 = 16 - i14 | 0;
     i18 = i6 + (i19 + 4) | 0;
     i17 = HEAP32[i18 >> 2] | 0;
     if ((i17 | 0) == 0) {
      i18 = i6 + i19 | 0;
      i17 = HEAP32[i18 >> 2] | 0;
      if ((i17 | 0) == 0) {
       i13 = 0;
       break;
      }
     }
     while (1) {
      i19 = i17 + 20 | 0;
      i20 = HEAP32[i19 >> 2] | 0;
      if ((i20 | 0) != 0) {
       i17 = i20;
       i18 = i19;
       continue;
      }
      i20 = i17 + 16 | 0;
      i19 = HEAP32[i20 >> 2] | 0;
      if ((i19 | 0) == 0) {
       break;
      } else {
       i17 = i19;
       i18 = i20;
      }
     }
     if (i18 >>> 0 < i15 >>> 0) {
      _abort();
     } else {
      HEAP32[i18 >> 2] = 0;
      i13 = i17;
      break;
     }
    } else {
     i17 = HEAP32[i6 + (8 - i14) >> 2] | 0;
     if (i17 >>> 0 < i15 >>> 0) {
      _abort();
     }
     i19 = i17 + 12 | 0;
     if ((HEAP32[i19 >> 2] | 0) != (i10 | 0)) {
      _abort();
     }
     i15 = i18 + 8 | 0;
     if ((HEAP32[i15 >> 2] | 0) == (i10 | 0)) {
      HEAP32[i19 >> 2] = i18;
      HEAP32[i15 >> 2] = i17;
      i13 = i18;
      break;
     } else {
      _abort();
     }
    }
   } while (0);
   if ((i16 | 0) != 0) {
    i15 = HEAP32[i6 + (28 - i14) >> 2] | 0;
    i17 = 13216 + (i15 << 2) | 0;
    if ((i10 | 0) == (HEAP32[i17 >> 2] | 0)) {
     HEAP32[i17 >> 2] = i13;
     if ((i13 | 0) == 0) {
      HEAP32[12916 >> 2] = HEAP32[12916 >> 2] & ~(1 << i15);
      i2 = i10;
      i12 = i11;
      break;
     }
    } else {
     if (i16 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     }
     i15 = i16 + 16 | 0;
     if ((HEAP32[i15 >> 2] | 0) == (i10 | 0)) {
      HEAP32[i15 >> 2] = i13;
     } else {
      HEAP32[i16 + 20 >> 2] = i13;
     }
     if ((i13 | 0) == 0) {
      i2 = i10;
      i12 = i11;
      break;
     }
    }
    if (i13 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
     _abort();
    }
    HEAP32[i13 + 24 >> 2] = i16;
    i14 = 16 - i14 | 0;
    i15 = HEAP32[i6 + i14 >> 2] | 0;
    do {
     if ((i15 | 0) != 0) {
      if (i15 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
       _abort();
      } else {
       HEAP32[i13 + 16 >> 2] = i15;
       HEAP32[i15 + 24 >> 2] = i13;
       break;
      }
     }
    } while (0);
    i14 = HEAP32[i6 + (i14 + 4) >> 2] | 0;
    if ((i14 | 0) != 0) {
     if (i14 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     } else {
      HEAP32[i13 + 20 >> 2] = i14;
      HEAP32[i14 + 24 >> 2] = i13;
      i2 = i10;
      i12 = i11;
      break;
     }
    } else {
     i2 = i10;
     i12 = i11;
    }
   } else {
    i2 = i10;
    i12 = i11;
   }
  } else {
   i2 = i6;
   i12 = i7;
  }
 } while (0);
 i10 = HEAP32[12928 >> 2] | 0;
 if (i5 >>> 0 < i10 >>> 0) {
  _abort();
 }
 i11 = i6 + (i7 + 4) | 0;
 i13 = HEAP32[i11 >> 2] | 0;
 if ((i13 & 2 | 0) == 0) {
  if ((i5 | 0) == (HEAP32[12936 >> 2] | 0)) {
   i20 = (HEAP32[12924 >> 2] | 0) + i12 | 0;
   HEAP32[12924 >> 2] = i20;
   HEAP32[12936 >> 2] = i2;
   HEAP32[i2 + 4 >> 2] = i20 | 1;
   if ((i2 | 0) != (HEAP32[12932 >> 2] | 0)) {
    STACKTOP = i1;
    return;
   }
   HEAP32[12932 >> 2] = 0;
   HEAP32[12920 >> 2] = 0;
   STACKTOP = i1;
   return;
  }
  if ((i5 | 0) == (HEAP32[12932 >> 2] | 0)) {
   i20 = (HEAP32[12920 >> 2] | 0) + i12 | 0;
   HEAP32[12920 >> 2] = i20;
   HEAP32[12932 >> 2] = i2;
   HEAP32[i2 + 4 >> 2] = i20 | 1;
   HEAP32[i2 + i20 >> 2] = i20;
   STACKTOP = i1;
   return;
  }
  i12 = (i13 & -8) + i12 | 0;
  i11 = i13 >>> 3;
  do {
   if (!(i13 >>> 0 < 256)) {
    i9 = HEAP32[i6 + (i7 + 24) >> 2] | 0;
    i11 = HEAP32[i6 + (i7 + 12) >> 2] | 0;
    do {
     if ((i11 | 0) == (i5 | 0)) {
      i13 = i6 + (i7 + 20) | 0;
      i11 = HEAP32[i13 >> 2] | 0;
      if ((i11 | 0) == 0) {
       i13 = i6 + (i7 + 16) | 0;
       i11 = HEAP32[i13 >> 2] | 0;
       if ((i11 | 0) == 0) {
        i8 = 0;
        break;
       }
      }
      while (1) {
       i15 = i11 + 20 | 0;
       i14 = HEAP32[i15 >> 2] | 0;
       if ((i14 | 0) != 0) {
        i11 = i14;
        i13 = i15;
        continue;
       }
       i14 = i11 + 16 | 0;
       i15 = HEAP32[i14 >> 2] | 0;
       if ((i15 | 0) == 0) {
        break;
       } else {
        i11 = i15;
        i13 = i14;
       }
      }
      if (i13 >>> 0 < i10 >>> 0) {
       _abort();
      } else {
       HEAP32[i13 >> 2] = 0;
       i8 = i11;
       break;
      }
     } else {
      i13 = HEAP32[i6 + (i7 + 8) >> 2] | 0;
      if (i13 >>> 0 < i10 >>> 0) {
       _abort();
      }
      i10 = i13 + 12 | 0;
      if ((HEAP32[i10 >> 2] | 0) != (i5 | 0)) {
       _abort();
      }
      i14 = i11 + 8 | 0;
      if ((HEAP32[i14 >> 2] | 0) == (i5 | 0)) {
       HEAP32[i10 >> 2] = i11;
       HEAP32[i14 >> 2] = i13;
       i8 = i11;
       break;
      } else {
       _abort();
      }
     }
    } while (0);
    if ((i9 | 0) != 0) {
     i10 = HEAP32[i6 + (i7 + 28) >> 2] | 0;
     i11 = 13216 + (i10 << 2) | 0;
     if ((i5 | 0) == (HEAP32[i11 >> 2] | 0)) {
      HEAP32[i11 >> 2] = i8;
      if ((i8 | 0) == 0) {
       HEAP32[12916 >> 2] = HEAP32[12916 >> 2] & ~(1 << i10);
       break;
      }
     } else {
      if (i9 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
       _abort();
      }
      i10 = i9 + 16 | 0;
      if ((HEAP32[i10 >> 2] | 0) == (i5 | 0)) {
       HEAP32[i10 >> 2] = i8;
      } else {
       HEAP32[i9 + 20 >> 2] = i8;
      }
      if ((i8 | 0) == 0) {
       break;
      }
     }
     if (i8 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     }
     HEAP32[i8 + 24 >> 2] = i9;
     i5 = HEAP32[i6 + (i7 + 16) >> 2] | 0;
     do {
      if ((i5 | 0) != 0) {
       if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
        _abort();
       } else {
        HEAP32[i8 + 16 >> 2] = i5;
        HEAP32[i5 + 24 >> 2] = i8;
        break;
       }
      }
     } while (0);
     i5 = HEAP32[i6 + (i7 + 20) >> 2] | 0;
     if ((i5 | 0) != 0) {
      if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
       _abort();
      } else {
       HEAP32[i8 + 20 >> 2] = i5;
       HEAP32[i5 + 24 >> 2] = i8;
       break;
      }
     }
    }
   } else {
    i8 = HEAP32[i6 + (i7 + 8) >> 2] | 0;
    i6 = HEAP32[i6 + (i7 + 12) >> 2] | 0;
    i7 = 12952 + (i11 << 1 << 2) | 0;
    if ((i8 | 0) != (i7 | 0)) {
     if (i8 >>> 0 < i10 >>> 0) {
      _abort();
     }
     if ((HEAP32[i8 + 12 >> 2] | 0) != (i5 | 0)) {
      _abort();
     }
    }
    if ((i6 | 0) == (i8 | 0)) {
     HEAP32[3228] = HEAP32[3228] & ~(1 << i11);
     break;
    }
    if ((i6 | 0) != (i7 | 0)) {
     if (i6 >>> 0 < i10 >>> 0) {
      _abort();
     }
     i7 = i6 + 8 | 0;
     if ((HEAP32[i7 >> 2] | 0) == (i5 | 0)) {
      i9 = i7;
     } else {
      _abort();
     }
    } else {
     i9 = i6 + 8 | 0;
    }
    HEAP32[i8 + 12 >> 2] = i6;
    HEAP32[i9 >> 2] = i8;
   }
  } while (0);
  HEAP32[i2 + 4 >> 2] = i12 | 1;
  HEAP32[i2 + i12 >> 2] = i12;
  if ((i2 | 0) == (HEAP32[12932 >> 2] | 0)) {
   HEAP32[12920 >> 2] = i12;
   STACKTOP = i1;
   return;
  }
 } else {
  HEAP32[i11 >> 2] = i13 & -2;
  HEAP32[i2 + 4 >> 2] = i12 | 1;
  HEAP32[i2 + i12 >> 2] = i12;
 }
 i6 = i12 >>> 3;
 if (i12 >>> 0 < 256) {
  i7 = i6 << 1;
  i5 = 12952 + (i7 << 2) | 0;
  i8 = HEAP32[3228] | 0;
  i6 = 1 << i6;
  if ((i8 & i6 | 0) != 0) {
   i7 = 12952 + (i7 + 2 << 2) | 0;
   i6 = HEAP32[i7 >> 2] | 0;
   if (i6 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
    _abort();
   } else {
    i4 = i7;
    i3 = i6;
   }
  } else {
   HEAP32[3228] = i8 | i6;
   i4 = 12952 + (i7 + 2 << 2) | 0;
   i3 = i5;
  }
  HEAP32[i4 >> 2] = i2;
  HEAP32[i3 + 12 >> 2] = i2;
  HEAP32[i2 + 8 >> 2] = i3;
  HEAP32[i2 + 12 >> 2] = i5;
  STACKTOP = i1;
  return;
 }
 i3 = i12 >>> 8;
 if ((i3 | 0) != 0) {
  if (i12 >>> 0 > 16777215) {
   i3 = 31;
  } else {
   i19 = (i3 + 1048320 | 0) >>> 16 & 8;
   i20 = i3 << i19;
   i18 = (i20 + 520192 | 0) >>> 16 & 4;
   i20 = i20 << i18;
   i3 = (i20 + 245760 | 0) >>> 16 & 2;
   i3 = 14 - (i18 | i19 | i3) + (i20 << i3 >>> 15) | 0;
   i3 = i12 >>> (i3 + 7 | 0) & 1 | i3 << 1;
  }
 } else {
  i3 = 0;
 }
 i6 = 13216 + (i3 << 2) | 0;
 HEAP32[i2 + 28 >> 2] = i3;
 HEAP32[i2 + 20 >> 2] = 0;
 HEAP32[i2 + 16 >> 2] = 0;
 i5 = HEAP32[12916 >> 2] | 0;
 i4 = 1 << i3;
 if ((i5 & i4 | 0) == 0) {
  HEAP32[12916 >> 2] = i5 | i4;
  HEAP32[i6 >> 2] = i2;
  HEAP32[i2 + 24 >> 2] = i6;
  HEAP32[i2 + 12 >> 2] = i2;
  HEAP32[i2 + 8 >> 2] = i2;
  STACKTOP = i1;
  return;
 }
 i4 = HEAP32[i6 >> 2] | 0;
 if ((i3 | 0) == 31) {
  i3 = 0;
 } else {
  i3 = 25 - (i3 >>> 1) | 0;
 }
 L194 : do {
  if ((HEAP32[i4 + 4 >> 2] & -8 | 0) != (i12 | 0)) {
   i3 = i12 << i3;
   i6 = i4;
   while (1) {
    i5 = i6 + (i3 >>> 31 << 2) + 16 | 0;
    i4 = HEAP32[i5 >> 2] | 0;
    if ((i4 | 0) == 0) {
     break;
    }
    if ((HEAP32[i4 + 4 >> 2] & -8 | 0) == (i12 | 0)) {
     break L194;
    } else {
     i3 = i3 << 1;
     i6 = i4;
    }
   }
   if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
    _abort();
   }
   HEAP32[i5 >> 2] = i2;
   HEAP32[i2 + 24 >> 2] = i6;
   HEAP32[i2 + 12 >> 2] = i2;
   HEAP32[i2 + 8 >> 2] = i2;
   STACKTOP = i1;
   return;
  }
 } while (0);
 i3 = i4 + 8 | 0;
 i6 = HEAP32[i3 >> 2] | 0;
 i5 = HEAP32[12928 >> 2] | 0;
 if (i4 >>> 0 < i5 >>> 0) {
  _abort();
 }
 if (i6 >>> 0 < i5 >>> 0) {
  _abort();
 }
 HEAP32[i6 + 12 >> 2] = i2;
 HEAP32[i3 >> 2] = i2;
 HEAP32[i2 + 8 >> 2] = i6;
 HEAP32[i2 + 12 >> 2] = i4;
 HEAP32[i2 + 24 >> 2] = 0;
 STACKTOP = i1;
 return;
}
function _singlestep(i2) {
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i14 = i1;
 i3 = i2 + 12 | 0;
 i8 = HEAP32[i3 >> 2] | 0;
 i6 = i8 + 61 | 0;
 switch (HEAPU8[i6] | 0) {
 case 0:
  {
   if ((HEAP32[i8 + 84 >> 2] | 0) != 0) {
    i21 = i8 + 16 | 0;
    i22 = HEAP32[i21 >> 2] | 0;
    _propagatemark(i8);
    i22 = (HEAP32[i21 >> 2] | 0) - i22 | 0;
    STACKTOP = i1;
    return i22 | 0;
   }
   HEAP8[i6] = 1;
   i6 = i8 + 20 | 0;
   HEAP32[i6 >> 2] = HEAP32[i8 + 16 >> 2];
   i8 = HEAP32[i3 >> 2] | 0;
   i7 = i8 + 16 | 0;
   i14 = HEAP32[i7 >> 2] | 0;
   if ((i2 | 0) != 0 ? !((HEAP8[i2 + 5 | 0] & 3) == 0) : 0) {
    _reallymarkobject(i8, i2);
   }
   if ((HEAP32[i8 + 48 >> 2] & 64 | 0) != 0 ? (i13 = HEAP32[i8 + 40 >> 2] | 0, !((HEAP8[i13 + 5 | 0] & 3) == 0)) : 0) {
    _reallymarkobject(i8, i13);
   }
   _markmt(i8);
   i13 = i8 + 112 | 0;
   i15 = HEAP32[i8 + 132 >> 2] | 0;
   if ((i15 | 0) != (i13 | 0)) {
    do {
     if (((HEAP8[i15 + 5 | 0] & 7) == 0 ? (i12 = HEAP32[i15 + 8 >> 2] | 0, (HEAP32[i12 + 8 >> 2] & 64 | 0) != 0) : 0) ? (i11 = HEAP32[i12 >> 2] | 0, !((HEAP8[i11 + 5 | 0] & 3) == 0)) : 0) {
      _reallymarkobject(i8, i11);
     }
     i15 = HEAP32[i15 + 20 >> 2] | 0;
    } while ((i15 | 0) != (i13 | 0));
   }
   i16 = i8 + 84 | 0;
   if ((HEAP32[i16 >> 2] | 0) != 0) {
    do {
     _propagatemark(i8);
    } while ((HEAP32[i16 >> 2] | 0) != 0);
   }
   i17 = (HEAP32[i7 >> 2] | 0) - i14 | 0;
   i11 = i8 + 92 | 0;
   i12 = HEAP32[i11 >> 2] | 0;
   i21 = i8 + 88 | 0;
   i22 = HEAP32[i21 >> 2] | 0;
   i15 = i8 + 96 | 0;
   i13 = HEAP32[i15 >> 2] | 0;
   HEAP32[i15 >> 2] = 0;
   HEAP32[i21 >> 2] = 0;
   HEAP32[i11 >> 2] = 0;
   HEAP32[i16 >> 2] = i22;
   if ((i22 | 0) != 0) {
    do {
     _propagatemark(i8);
    } while ((HEAP32[i16 >> 2] | 0) != 0);
   }
   HEAP32[i16 >> 2] = i12;
   if ((i12 | 0) != 0) {
    do {
     _propagatemark(i8);
    } while ((HEAP32[i16 >> 2] | 0) != 0);
   }
   HEAP32[i16 >> 2] = i13;
   if ((i13 | 0) != 0) {
    do {
     _propagatemark(i8);
    } while ((HEAP32[i16 >> 2] | 0) != 0);
   }
   i18 = HEAP32[i7 >> 2] | 0;
   while (1) {
    i13 = HEAP32[i15 >> 2] | 0;
    HEAP32[i15 >> 2] = 0;
    i12 = 0;
    L42 : while (1) {
     i14 = i13;
     while (1) {
      if ((i14 | 0) == 0) {
       break L42;
      }
      i13 = HEAP32[i14 + 24 >> 2] | 0;
      if ((_traverseephemeron(i8, i14) | 0) == 0) {
       i14 = i13;
      } else {
       break;
      }
     }
     if ((HEAP32[i16 >> 2] | 0) == 0) {
      i12 = 1;
      continue;
     }
     while (1) {
      _propagatemark(i8);
      if ((HEAP32[i16 >> 2] | 0) == 0) {
       i12 = 1;
       continue L42;
      }
     }
    }
    if ((i12 | 0) == 0) {
     break;
    }
   }
   _clearvalues(i8, HEAP32[i11 >> 2] | 0, 0);
   i14 = i8 + 100 | 0;
   _clearvalues(i8, HEAP32[i14 >> 2] | 0, 0);
   i13 = HEAP32[i11 >> 2] | 0;
   i12 = HEAP32[i14 >> 2] | 0;
   i21 = HEAP32[i7 >> 2] | 0;
   i20 = HEAP32[i3 >> 2] | 0;
   i19 = i20 + 104 | 0;
   while (1) {
    i22 = HEAP32[i19 >> 2] | 0;
    if ((i22 | 0) == 0) {
     break;
    } else {
     i19 = i22;
    }
   }
   i17 = i17 - i18 + i21 | 0;
   i20 = i20 + 72 | 0;
   i21 = HEAP32[i20 >> 2] | 0;
   L55 : do {
    if ((i21 | 0) != 0) {
     while (1) {
      i18 = i21;
      while (1) {
       i22 = i18 + 5 | 0;
       i21 = HEAP8[i22] | 0;
       if ((i21 & 3) == 0) {
        break;
       }
       HEAP8[i22] = i21 & 255 | 8;
       HEAP32[i20 >> 2] = HEAP32[i18 >> 2];
       HEAP32[i18 >> 2] = HEAP32[i19 >> 2];
       HEAP32[i19 >> 2] = i18;
       i19 = HEAP32[i20 >> 2] | 0;
       if ((i19 | 0) == 0) {
        break L55;
       } else {
        i22 = i18;
        i18 = i19;
        i19 = i22;
       }
      }
      i21 = HEAP32[i18 >> 2] | 0;
      if ((i21 | 0) == 0) {
       break;
      } else {
       i20 = i18;
      }
     }
    }
   } while (0);
   i19 = HEAP32[i8 + 104 >> 2] | 0;
   if ((i19 | 0) != 0) {
    i18 = i8 + 60 | 0;
    do {
     i22 = i19 + 5 | 0;
     HEAP8[i22] = HEAP8[i18] & 3 | HEAP8[i22] & 184;
     _reallymarkobject(i8, i19);
     i19 = HEAP32[i19 >> 2] | 0;
    } while ((i19 | 0) != 0);
   }
   if ((HEAP32[i16 >> 2] | 0) != 0) {
    do {
     _propagatemark(i8);
    } while ((HEAP32[i16 >> 2] | 0) != 0);
   }
   i18 = HEAP32[i7 >> 2] | 0;
   while (1) {
    i20 = HEAP32[i15 >> 2] | 0;
    HEAP32[i15 >> 2] = 0;
    i19 = 0;
    L74 : while (1) {
     i21 = i20;
     while (1) {
      if ((i21 | 0) == 0) {
       break L74;
      }
      i20 = HEAP32[i21 + 24 >> 2] | 0;
      if ((_traverseephemeron(i8, i21) | 0) == 0) {
       i21 = i20;
      } else {
       break;
      }
     }
     if ((HEAP32[i16 >> 2] | 0) == 0) {
      i19 = 1;
      continue;
     }
     while (1) {
      _propagatemark(i8);
      if ((HEAP32[i16 >> 2] | 0) == 0) {
       i19 = 1;
       continue L74;
      }
     }
    }
    if ((i19 | 0) == 0) {
     break;
    }
   }
   i16 = i17 - i18 | 0;
   i15 = HEAP32[i15 >> 2] | 0;
   if ((i15 | 0) != 0) {
    do {
     i22 = 1 << HEAPU8[i15 + 7 | 0];
     i19 = HEAP32[i15 + 16 >> 2] | 0;
     i17 = i19 + (i22 << 5) | 0;
     if ((i22 | 0) > 0) {
      do {
       i18 = i19 + 8 | 0;
       do {
        if ((HEAP32[i18 >> 2] | 0) != 0 ? (i9 = i19 + 24 | 0, i10 = HEAP32[i9 >> 2] | 0, (i10 & 64 | 0) != 0) : 0) {
         i20 = HEAP32[i19 + 16 >> 2] | 0;
         if ((i10 & 15 | 0) == 4) {
          if ((i20 | 0) == 0) {
           break;
          }
          if ((HEAP8[i20 + 5 | 0] & 3) == 0) {
           break;
          }
          _reallymarkobject(i8, i20);
          break;
         } else {
          i20 = i20 + 5 | 0;
          if ((HEAP8[i20] & 3) == 0) {
           break;
          }
          HEAP32[i18 >> 2] = 0;
          if ((HEAP8[i20] & 3) == 0) {
           break;
          }
          HEAP32[i9 >> 2] = 11;
          break;
         }
        }
       } while (0);
       i19 = i19 + 32 | 0;
      } while (i19 >>> 0 < i17 >>> 0);
     }
     i15 = HEAP32[i15 + 24 >> 2] | 0;
    } while ((i15 | 0) != 0);
   }
   i10 = HEAP32[i14 >> 2] | 0;
   if ((i10 | 0) != 0) {
    do {
     i22 = 1 << HEAPU8[i10 + 7 | 0];
     i17 = HEAP32[i10 + 16 >> 2] | 0;
     i9 = i17 + (i22 << 5) | 0;
     if ((i22 | 0) > 0) {
      do {
       i15 = i17 + 8 | 0;
       do {
        if ((HEAP32[i15 >> 2] | 0) != 0 ? (i5 = i17 + 24 | 0, i4 = HEAP32[i5 >> 2] | 0, (i4 & 64 | 0) != 0) : 0) {
         i18 = HEAP32[i17 + 16 >> 2] | 0;
         if ((i4 & 15 | 0) == 4) {
          if ((i18 | 0) == 0) {
           break;
          }
          if ((HEAP8[i18 + 5 | 0] & 3) == 0) {
           break;
          }
          _reallymarkobject(i8, i18);
          break;
         } else {
          i18 = i18 + 5 | 0;
          if ((HEAP8[i18] & 3) == 0) {
           break;
          }
          HEAP32[i15 >> 2] = 0;
          if ((HEAP8[i18] & 3) == 0) {
           break;
          }
          HEAP32[i5 >> 2] = 11;
          break;
         }
        }
       } while (0);
       i17 = i17 + 32 | 0;
      } while (i17 >>> 0 < i9 >>> 0);
     }
     i10 = HEAP32[i10 + 24 >> 2] | 0;
    } while ((i10 | 0) != 0);
   }
   _clearvalues(i8, HEAP32[i11 >> 2] | 0, i13);
   _clearvalues(i8, HEAP32[i14 >> 2] | 0, i12);
   i4 = i8 + 60 | 0;
   HEAP8[i4] = HEAPU8[i4] ^ 3;
   i4 = i16 + (HEAP32[i7 >> 2] | 0) | 0;
   HEAP32[i6 >> 2] = (HEAP32[i6 >> 2] | 0) + i4;
   i3 = HEAP32[i3 >> 2] | 0;
   HEAP8[i3 + 61 | 0] = 2;
   HEAP32[i3 + 64 >> 2] = 0;
   i7 = i3 + 72 | 0;
   i5 = 0;
   do {
    i5 = i5 + 1 | 0;
    i6 = _sweeplist(i2, i7, 1) | 0;
   } while ((i6 | 0) == (i7 | 0));
   HEAP32[i3 + 80 >> 2] = i6;
   i6 = i3 + 68 | 0;
   i7 = 0;
   do {
    i7 = i7 + 1 | 0;
    i8 = _sweeplist(i2, i6, 1) | 0;
   } while ((i8 | 0) == (i6 | 0));
   HEAP32[i3 + 76 >> 2] = i8;
   i22 = ((i7 + i5 | 0) * 5 | 0) + i4 | 0;
   STACKTOP = i1;
   return i22 | 0;
  }
 case 2:
  {
   i3 = i8 + 64 | 0;
   i4 = i8 + 32 | 0;
   i8 = i8 + 24 | 0;
   i5 = 0;
   while (1) {
    i10 = HEAP32[i3 >> 2] | 0;
    i11 = i10 + i5 | 0;
    i9 = HEAP32[i4 >> 2] | 0;
    if ((i11 | 0) >= (i9 | 0)) {
     i2 = i10;
     break;
    }
    _sweeplist(i2, (HEAP32[i8 >> 2] | 0) + (i11 << 2) | 0, -3) | 0;
    i5 = i5 + 1 | 0;
    if ((i5 | 0) >= 80) {
     i7 = 96;
     break;
    }
   }
   if ((i7 | 0) == 96) {
    i2 = HEAP32[i3 >> 2] | 0;
    i9 = HEAP32[i4 >> 2] | 0;
   }
   i22 = i2 + i5 | 0;
   HEAP32[i3 >> 2] = i22;
   if ((i22 | 0) >= (i9 | 0)) {
    HEAP8[i6] = 3;
   }
   i22 = i5 * 5 | 0;
   STACKTOP = i1;
   return i22 | 0;
  }
 case 5:
  {
   i2 = i8 + 16 | 0;
   HEAP32[i2 >> 2] = HEAP32[i8 + 32 >> 2] << 2;
   i22 = i8 + 84 | 0;
   i3 = i8 + 172 | 0;
   HEAP32[i22 + 0 >> 2] = 0;
   HEAP32[i22 + 4 >> 2] = 0;
   HEAP32[i22 + 8 >> 2] = 0;
   HEAP32[i22 + 12 >> 2] = 0;
   HEAP32[i22 + 16 >> 2] = 0;
   i3 = HEAP32[i3 >> 2] | 0;
   if ((i3 | 0) != 0 ? !((HEAP8[i3 + 5 | 0] & 3) == 0) : 0) {
    _reallymarkobject(i8, i3);
   }
   if ((HEAP32[i8 + 48 >> 2] & 64 | 0) != 0 ? (i15 = HEAP32[i8 + 40 >> 2] | 0, !((HEAP8[i15 + 5 | 0] & 3) == 0)) : 0) {
    _reallymarkobject(i8, i15);
   }
   _markmt(i8);
   i4 = HEAP32[i8 + 104 >> 2] | 0;
   if ((i4 | 0) != 0) {
    i3 = i8 + 60 | 0;
    do {
     i22 = i4 + 5 | 0;
     HEAP8[i22] = HEAP8[i3] & 3 | HEAP8[i22] & 184;
     _reallymarkobject(i8, i4);
     i4 = HEAP32[i4 >> 2] | 0;
    } while ((i4 | 0) != 0);
   }
   HEAP8[i6] = 0;
   i22 = HEAP32[i2 >> 2] | 0;
   STACKTOP = i1;
   return i22 | 0;
  }
 case 3:
  {
   i3 = i8 + 80 | 0;
   i4 = HEAP32[i3 >> 2] | 0;
   if ((i4 | 0) == 0) {
    HEAP8[i6] = 4;
    i22 = 0;
    STACKTOP = i1;
    return i22 | 0;
   } else {
    HEAP32[i3 >> 2] = _sweeplist(i2, i4, 80) | 0;
    i22 = 400;
    STACKTOP = i1;
    return i22 | 0;
   }
  }
 case 4:
  {
   i4 = i8 + 76 | 0;
   i5 = HEAP32[i4 >> 2] | 0;
   if ((i5 | 0) != 0) {
    HEAP32[i4 >> 2] = _sweeplist(i2, i5, 80) | 0;
    i22 = 400;
    STACKTOP = i1;
    return i22 | 0;
   }
   HEAP32[i14 >> 2] = HEAP32[i8 + 172 >> 2];
   _sweeplist(i2, i14, 1) | 0;
   i3 = HEAP32[i3 >> 2] | 0;
   if ((HEAP8[i3 + 62 | 0] | 0) != 1) {
    i4 = (HEAP32[i3 + 32 >> 2] | 0) / 2 | 0;
    if ((HEAP32[i3 + 28 >> 2] | 0) >>> 0 < i4 >>> 0) {
     _luaS_resize(i2, i4);
    }
    i21 = i3 + 144 | 0;
    i22 = i3 + 152 | 0;
    HEAP32[i21 >> 2] = _luaM_realloc_(i2, HEAP32[i21 >> 2] | 0, HEAP32[i22 >> 2] | 0, 0) | 0;
    HEAP32[i22 >> 2] = 0;
   }
   HEAP8[i6] = 5;
   i22 = 5;
   STACKTOP = i1;
   return i22 | 0;
  }
 default:
  {
   i22 = 0;
   STACKTOP = i1;
   return i22 | 0;
  }
 }
 return 0;
}
function _pmain(i3) {
 i3 = i3 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i2 = i1;
 i7 = _lua_tointegerx(i3, 1, 0) | 0;
 i4 = _lua_touserdata(i3, 2) | 0;
 i5 = HEAP32[i4 >> 2] | 0;
 if ((i5 | 0) != 0 ? (HEAP8[i5] | 0) != 0 : 0) {
  HEAP32[20] = i5;
 }
 i12 = HEAP32[i4 + 4 >> 2] | 0;
 do {
  if ((i12 | 0) == 0) {
   i5 = 0;
   i6 = 0;
   i8 = 0;
   i9 = 1;
   i10 = 1;
  } else {
   i9 = 0;
   i8 = 0;
   i11 = 0;
   i6 = 0;
   i5 = 1;
   L6 : while (1) {
    if ((HEAP8[i12] | 0) != 45) {
     i10 = 18;
     break;
    }
    switch (HEAP8[i12 + 1 | 0] | 0) {
    case 108:
     {
      i10 = 12;
      break;
     }
    case 69:
     {
      i9 = 1;
      break;
     }
    case 45:
     {
      i10 = 7;
      break L6;
     }
    case 105:
     {
      if ((HEAP8[i12 + 2 | 0] | 0) == 0) {
       i11 = 1;
       i6 = 1;
      } else {
       i5 = -1;
       break L6;
      }
      break;
     }
    case 101:
     {
      i8 = 1;
      i10 = 12;
      break;
     }
    case 118:
     {
      if ((HEAP8[i12 + 2 | 0] | 0) == 0) {
       i11 = 1;
      } else {
       i5 = -1;
       break L6;
      }
      break;
     }
    case 0:
     {
      i10 = 18;
      break L6;
     }
    default:
     {
      i10 = 16;
      break L6;
     }
    }
    if ((i10 | 0) == 12) {
     i10 = 0;
     if ((HEAP8[i12 + 2 | 0] | 0) == 0) {
      i12 = i5 + 1 | 0;
      i13 = HEAP32[i4 + (i12 << 2) >> 2] | 0;
      if ((i13 | 0) == 0) {
       i10 = 15;
       break;
      }
      if ((HEAP8[i13] | 0) == 45) {
       i10 = 15;
       break;
      } else {
       i5 = i12;
      }
     }
    }
    i5 = i5 + 1 | 0;
    i12 = HEAP32[i4 + (i5 << 2) >> 2] | 0;
    if ((i12 | 0) == 0) {
     i5 = 0;
     i12 = i9;
     i10 = 23;
     break;
    }
   }
   if ((i10 | 0) == 7) {
    if ((HEAP8[i12 + 2 | 0] | 0) == 0) {
     i5 = i5 + 1 | 0;
     i5 = (HEAP32[i4 + (i5 << 2) >> 2] | 0) == 0 ? 0 : i5;
     i10 = 18;
    } else {
     i5 = -1;
    }
   } else if ((i10 | 0) == 15) {
    i5 = 0 - i5 | 0;
    i10 = 18;
   } else if ((i10 | 0) == 16) {
    i5 = 0 - i5 | 0;
    i10 = 18;
   }
   if ((i10 | 0) == 18) {
    if ((i5 | 0) >= 0) {
     i12 = i9;
     i10 = 23;
    }
   }
   if ((i10 | 0) == 23) {
    if ((i11 | 0) == 0) {
     i9 = 1;
    } else {
     i9 = HEAP32[_stdout >> 2] | 0;
     _fwrite(440, 1, 51, i9 | 0) | 0;
     _fputc(10, i9 | 0) | 0;
     _fflush(i9 | 0) | 0;
     i9 = 0;
    }
    if ((i12 | 0) == 0) {
     i10 = 1;
     break;
    }
    _lua_pushboolean(i3, 1);
    _lua_setfield(i3, -1001e3, 96);
    i10 = 0;
    break;
   }
   i3 = HEAP32[i4 + (0 - i5 << 2) >> 2] | 0;
   i4 = HEAP32[_stderr >> 2] | 0;
   HEAP32[i2 >> 2] = HEAP32[20];
   _fprintf(i4 | 0, 496, i2 | 0) | 0;
   _fflush(i4 | 0) | 0;
   i13 = HEAP8[i3 + 1 | 0] | 0;
   if (i13 << 24 >> 24 == 108 | i13 << 24 >> 24 == 101) {
    HEAP32[i2 >> 2] = i3;
    _fprintf(i4 | 0, 504, i2 | 0) | 0;
    _fflush(i4 | 0) | 0;
   } else {
    HEAP32[i2 >> 2] = i3;
    _fprintf(i4 | 0, 528, i2 | 0) | 0;
    _fflush(i4 | 0) | 0;
   }
   HEAP32[i2 >> 2] = HEAP32[20];
   _fprintf(i4 | 0, 560, i2 | 0) | 0;
   _fflush(i4 | 0) | 0;
   i13 = 0;
   STACKTOP = i1;
   return i13 | 0;
  }
 } while (0);
 _luaL_checkversion_(i3, 502.0);
 _lua_gc(i3, 0, 0) | 0;
 _luaL_openlibs(i3);
 _lua_gc(i3, 1, 0) | 0;
 do {
  if (i10) {
   i10 = _getenv(409 | 0) | 0;
   if ((i10 | 0) == 0) {
    i10 = _getenv(425 | 0) | 0;
    if ((i10 | 0) == 0) {
     break;
    } else {
     i11 = 424;
    }
   } else {
    i11 = 408;
   }
   if ((HEAP8[i10] | 0) == 64) {
    i13 = _luaL_loadfilex(i3, i10 + 1 | 0, 0) | 0;
    if ((i13 | 0) == 0) {
     i12 = _lua_gettop(i3) | 0;
     _lua_pushcclosure(i3, 142, 0);
     _lua_insert(i3, i12);
     HEAP32[48] = i3;
     _signal(2, 1) | 0;
     i13 = _lua_pcallk(i3, 0, 0, i12, 0, 0) | 0;
     _signal(2, 0) | 0;
     _lua_remove(i3, i12);
     if ((i13 | 0) == 0) {
      break;
     }
    }
    if ((_lua_type(i3, -1) | 0) == 0) {
     i13 = 0;
     STACKTOP = i1;
     return i13 | 0;
    }
    i11 = _lua_tolstring(i3, -1, 0) | 0;
    i12 = HEAP32[20] | 0;
    i10 = HEAP32[_stderr >> 2] | 0;
    if ((i12 | 0) != 0) {
     HEAP32[i2 >> 2] = i12;
     _fprintf(i10 | 0, 496, i2 | 0) | 0;
     _fflush(i10 | 0) | 0;
    }
    HEAP32[i2 >> 2] = (i11 | 0) == 0 ? 48 : i11;
    _fprintf(i10 | 0, 912, i2 | 0) | 0;
    _fflush(i10 | 0) | 0;
    _lua_settop(i3, -2);
    _lua_gc(i3, 2, 0) | 0;
   } else {
    i13 = _luaL_loadbufferx(i3, i10, _strlen(i10 | 0) | 0, i11, 0) | 0;
    if ((i13 | 0) == 0) {
     i12 = _lua_gettop(i3) | 0;
     _lua_pushcclosure(i3, 142, 0);
     _lua_insert(i3, i12);
     HEAP32[48] = i3;
     _signal(2, 1) | 0;
     i13 = _lua_pcallk(i3, 0, 0, i12, 0, 0) | 0;
     _signal(2, 0) | 0;
     _lua_remove(i3, i12);
     if ((i13 | 0) == 0) {
      break;
     }
    }
    if ((_lua_type(i3, -1) | 0) == 0) {
     i13 = 0;
     STACKTOP = i1;
     return i13 | 0;
    }
    i11 = _lua_tolstring(i3, -1, 0) | 0;
    i10 = HEAP32[20] | 0;
    i12 = HEAP32[_stderr >> 2] | 0;
    if ((i10 | 0) != 0) {
     HEAP32[i2 >> 2] = i10;
     _fprintf(i12 | 0, 496, i2 | 0) | 0;
     _fflush(i12 | 0) | 0;
    }
    HEAP32[i2 >> 2] = (i11 | 0) == 0 ? 48 : i11;
    _fprintf(i12 | 0, 912, i2 | 0) | 0;
    _fflush(i12 | 0) | 0;
    _lua_settop(i3, -2);
    _lua_gc(i3, 2, 0) | 0;
   }
   if ((i13 | 0) != 0) {
    i13 = 0;
    STACKTOP = i1;
    return i13 | 0;
   }
  }
 } while (0);
 i7 = (i5 | 0) > 0 ? i5 : i7;
 L67 : do {
  if ((i7 | 0) > 1) {
   i10 = 1;
   while (1) {
    i11 = HEAP32[i4 + (i10 << 2) >> 2] | 0;
    i12 = HEAP8[i11 + 1 | 0] | 0;
    if ((i12 | 0) == 108) {
     i11 = i11 + 2 | 0;
     if ((HEAP8[i11] | 0) == 0) {
      i10 = i10 + 1 | 0;
      i11 = HEAP32[i4 + (i10 << 2) >> 2] | 0;
     }
     _lua_getglobal(i3, 400);
     _lua_pushstring(i3, i11) | 0;
     i12 = (_lua_gettop(i3) | 0) + -1 | 0;
     _lua_pushcclosure(i3, 142, 0);
     _lua_insert(i3, i12);
     HEAP32[48] = i3;
     _signal(2, 1) | 0;
     i13 = _lua_pcallk(i3, 1, 1, i12, 0, 0) | 0;
     _signal(2, 0) | 0;
     _lua_remove(i3, i12);
     if ((i13 | 0) != 0) {
      i10 = 58;
      break;
     }
     _lua_setglobal(i3, i11);
    } else if ((i12 | 0) == 101) {
     i11 = i11 + 2 | 0;
     if ((HEAP8[i11] | 0) == 0) {
      i10 = i10 + 1 | 0;
      i11 = HEAP32[i4 + (i10 << 2) >> 2] | 0;
     }
     if ((_luaL_loadbufferx(i3, i11, _strlen(i11 | 0) | 0, 384, 0) | 0) != 0) {
      i10 = 50;
      break;
     }
     i12 = _lua_gettop(i3) | 0;
     _lua_pushcclosure(i3, 142, 0);
     _lua_insert(i3, i12);
     HEAP32[48] = i3;
     _signal(2, 1) | 0;
     i13 = _lua_pcallk(i3, 0, 0, i12, 0, 0) | 0;
     _signal(2, 0) | 0;
     _lua_remove(i3, i12);
     if ((i13 | 0) != 0) {
      i10 = 50;
      break;
     }
    }
    i10 = i10 + 1 | 0;
    if ((i10 | 0) >= (i7 | 0)) {
     break L67;
    }
   }
   if ((i10 | 0) == 50) {
    if ((_lua_type(i3, -1) | 0) == 0) {
     i13 = 0;
     STACKTOP = i1;
     return i13 | 0;
    }
    i5 = _lua_tolstring(i3, -1, 0) | 0;
    i6 = HEAP32[20] | 0;
    i4 = HEAP32[_stderr >> 2] | 0;
    if ((i6 | 0) != 0) {
     HEAP32[i2 >> 2] = i6;
     _fprintf(i4 | 0, 496, i2 | 0) | 0;
     _fflush(i4 | 0) | 0;
    }
    HEAP32[i2 >> 2] = (i5 | 0) == 0 ? 48 : i5;
    _fprintf(i4 | 0, 912, i2 | 0) | 0;
    _fflush(i4 | 0) | 0;
    _lua_settop(i3, -2);
    _lua_gc(i3, 2, 0) | 0;
    i13 = 0;
    STACKTOP = i1;
    return i13 | 0;
   } else if ((i10 | 0) == 58) {
    if ((_lua_type(i3, -1) | 0) == 0) {
     i13 = 0;
     STACKTOP = i1;
     return i13 | 0;
    }
    i5 = _lua_tolstring(i3, -1, 0) | 0;
    i6 = HEAP32[20] | 0;
    i4 = HEAP32[_stderr >> 2] | 0;
    if ((i6 | 0) != 0) {
     HEAP32[i2 >> 2] = i6;
     _fprintf(i4 | 0, 496, i2 | 0) | 0;
     _fflush(i4 | 0) | 0;
    }
    HEAP32[i2 >> 2] = (i5 | 0) == 0 ? 48 : i5;
    _fprintf(i4 | 0, 912, i2 | 0) | 0;
    _fflush(i4 | 0) | 0;
    _lua_settop(i3, -2);
    _lua_gc(i3, 2, 0) | 0;
    i13 = 0;
    STACKTOP = i1;
    return i13 | 0;
   }
  }
 } while (0);
 do {
  if ((i5 | 0) != 0) {
   i10 = 0;
   while (1) {
    if ((HEAP32[i4 + (i10 << 2) >> 2] | 0) == 0) {
     break;
    } else {
     i10 = i10 + 1 | 0;
    }
   }
   i11 = i5 + 1 | 0;
   i7 = i10 - i11 | 0;
   _luaL_checkstack(i3, i7 + 3 | 0, 352);
   if ((i11 | 0) < (i10 | 0)) {
    i12 = i11;
    do {
     _lua_pushstring(i3, HEAP32[i4 + (i12 << 2) >> 2] | 0) | 0;
     i12 = i12 + 1 | 0;
    } while ((i12 | 0) != (i10 | 0));
   }
   _lua_createtable(i3, i7, i11);
   if ((i10 | 0) > 0) {
    i11 = 0;
    do {
     _lua_pushstring(i3, HEAP32[i4 + (i11 << 2) >> 2] | 0) | 0;
     _lua_rawseti(i3, -2, i11 - i5 | 0);
     i11 = i11 + 1 | 0;
    } while ((i11 | 0) != (i10 | 0));
   }
   _lua_setglobal(i3, 328);
   i10 = HEAP32[i4 + (i5 << 2) >> 2] | 0;
   if ((_strcmp(i10, 336) | 0) == 0) {
    i13 = (_strcmp(HEAP32[i4 + (i5 + -1 << 2) >> 2] | 0, 344) | 0) == 0;
    i10 = i13 ? i10 : 0;
   }
   i10 = _luaL_loadfilex(i3, i10, 0) | 0;
   i4 = ~i7;
   _lua_insert(i3, i4);
   if ((i10 | 0) == 0) {
    i13 = (_lua_gettop(i3) | 0) - i7 | 0;
    _lua_pushcclosure(i3, 142, 0);
    _lua_insert(i3, i13);
    HEAP32[48] = i3;
    _signal(2, 1) | 0;
    i10 = _lua_pcallk(i3, i7, -1, i13, 0, 0) | 0;
    _signal(2, 0) | 0;
    _lua_remove(i3, i13);
    if ((i10 | 0) == 0) {
     break;
    }
   } else {
    _lua_settop(i3, i4);
   }
   if ((_lua_type(i3, -1) | 0) != 0) {
    i7 = _lua_tolstring(i3, -1, 0) | 0;
    i11 = HEAP32[20] | 0;
    i4 = HEAP32[_stderr >> 2] | 0;
    if ((i11 | 0) != 0) {
     HEAP32[i2 >> 2] = i11;
     _fprintf(i4 | 0, 496, i2 | 0) | 0;
     _fflush(i4 | 0) | 0;
    }
    HEAP32[i2 >> 2] = (i7 | 0) == 0 ? 48 : i7;
    _fprintf(i4 | 0, 912, i2 | 0) | 0;
    _fflush(i4 | 0) | 0;
    _lua_settop(i3, -2);
    _lua_gc(i3, 2, 0) | 0;
   }
   if ((i10 | 0) != 0) {
    i13 = 0;
    STACKTOP = i1;
    return i13 | 0;
   }
  }
 } while (0);
 if ((i6 | 0) == 0) {
  if (!((i8 | i5 | 0) != 0 | i9 ^ 1)) {
   i13 = HEAP32[_stdout >> 2] | 0;
   _fwrite(440, 1, 51, i13 | 0) | 0;
   _fputc(10, i13 | 0) | 0;
   _fflush(i13 | 0) | 0;
   _dotty(i3);
  }
 } else {
  _dotty(i3);
 }
 _lua_pushboolean(i3, 1);
 i13 = 1;
 STACKTOP = i1;
 return i13 | 0;
}
function _DumpFunction(i6, i2) {
 i6 = i6 | 0;
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i29 = 0, i30 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i17 = i5 + 56 | 0;
 i19 = i5 + 52 | 0;
 i20 = i5 + 48 | 0;
 i18 = i5;
 i21 = i5 + 60 | 0;
 i22 = i5 + 44 | 0;
 i1 = i5 + 40 | 0;
 i16 = i5 + 36 | 0;
 i23 = i5 + 32 | 0;
 i3 = i5 + 28 | 0;
 i7 = i5 + 24 | 0;
 i8 = i5 + 20 | 0;
 i9 = i5 + 16 | 0;
 i10 = i5 + 12 | 0;
 i12 = i5 + 8 | 0;
 HEAP32[i17 >> 2] = HEAP32[i6 + 64 >> 2];
 i4 = i2 + 16 | 0;
 i28 = HEAP32[i4 >> 2] | 0;
 if ((i28 | 0) == 0) {
  i28 = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i17, 4, HEAP32[i2 + 8 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i28;
 }
 HEAP32[i17 >> 2] = HEAP32[i6 + 68 >> 2];
 if ((i28 | 0) == 0) {
  i28 = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i17, 4, HEAP32[i2 + 8 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i28;
 }
 HEAP8[i17] = HEAP8[i6 + 76 | 0] | 0;
 if ((i28 | 0) == 0) {
  i28 = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i17, 1, HEAP32[i2 + 8 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i28;
 }
 HEAP8[i17] = HEAP8[i6 + 77 | 0] | 0;
 if ((i28 | 0) == 0) {
  i28 = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i17, 1, HEAP32[i2 + 8 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i28;
 }
 HEAP8[i17] = HEAP8[i6 + 78 | 0] | 0;
 if ((i28 | 0) == 0) {
  i28 = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i17, 1, HEAP32[i2 + 8 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i28;
 }
 i25 = HEAP32[i6 + 12 >> 2] | 0;
 i24 = HEAP32[i6 + 48 >> 2] | 0;
 HEAP32[i23 >> 2] = i24;
 if ((i28 | 0) == 0) {
  i26 = i2 + 4 | 0;
  i27 = i2 + 8 | 0;
  i28 = FUNCTION_TABLE_iiiii[HEAP32[i26 >> 2] & 3](HEAP32[i2 >> 2] | 0, i23, 4, HEAP32[i27 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i28;
  if ((i28 | 0) == 0) {
   i28 = FUNCTION_TABLE_iiiii[HEAP32[i26 >> 2] & 3](HEAP32[i2 >> 2] | 0, i25, i24 << 2, HEAP32[i27 >> 2] | 0) | 0;
   HEAP32[i4 >> 2] = i28;
   i25 = HEAP32[i6 + 44 >> 2] | 0;
   HEAP32[i22 >> 2] = i25;
   if ((i28 | 0) == 0) {
    i28 = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i22, 4, HEAP32[i2 + 8 >> 2] | 0) | 0;
    HEAP32[i4 >> 2] = i28;
   }
  } else {
   i11 = 13;
  }
 } else {
  i11 = 13;
 }
 if ((i11 | 0) == 13) {
  i25 = HEAP32[i6 + 44 >> 2] | 0;
  HEAP32[i22 >> 2] = i25;
 }
 if ((i25 | 0) > 0) {
  i24 = i6 + 8 | 0;
  i23 = i2 + 4 | 0;
  i22 = i2 + 8 | 0;
  i26 = 0;
  do {
   i30 = HEAP32[i24 >> 2] | 0;
   i27 = i30 + (i26 << 4) | 0;
   i30 = i30 + (i26 << 4) + 8 | 0;
   i29 = HEAP32[i30 >> 2] | 0;
   HEAP8[i17] = i29 & 15;
   if ((i28 | 0) == 0) {
    i28 = FUNCTION_TABLE_iiiii[HEAP32[i23 >> 2] & 3](HEAP32[i2 >> 2] | 0, i17, 1, HEAP32[i22 >> 2] | 0) | 0;
    HEAP32[i4 >> 2] = i28;
    i29 = HEAP32[i30 >> 2] | 0;
   }
   i29 = i29 & 15;
   do {
    if ((i29 | 0) == 3) {
     HEAPF64[i18 >> 3] = +HEAPF64[i27 >> 3];
     if ((i28 | 0) == 0) {
      i28 = FUNCTION_TABLE_iiiii[HEAP32[i23 >> 2] & 3](HEAP32[i2 >> 2] | 0, i18, 8, HEAP32[i22 >> 2] | 0) | 0;
      HEAP32[i4 >> 2] = i28;
     }
    } else if ((i29 | 0) == 1) {
     HEAP8[i21] = HEAP32[i27 >> 2];
     if ((i28 | 0) == 0) {
      i28 = FUNCTION_TABLE_iiiii[HEAP32[i23 >> 2] & 3](HEAP32[i2 >> 2] | 0, i21, 1, HEAP32[i22 >> 2] | 0) | 0;
      HEAP32[i4 >> 2] = i28;
     }
    } else if ((i29 | 0) == 4) {
     i27 = HEAP32[i27 >> 2] | 0;
     if ((i27 | 0) == 0) {
      HEAP32[i19 >> 2] = 0;
      if ((i28 | 0) != 0) {
       break;
      }
      i28 = FUNCTION_TABLE_iiiii[HEAP32[i23 >> 2] & 3](HEAP32[i2 >> 2] | 0, i19, 4, HEAP32[i22 >> 2] | 0) | 0;
      HEAP32[i4 >> 2] = i28;
      break;
     }
     HEAP32[i20 >> 2] = (HEAP32[i27 + 12 >> 2] | 0) + 1;
     if ((i28 | 0) == 0) {
      i28 = FUNCTION_TABLE_iiiii[HEAP32[i23 >> 2] & 3](HEAP32[i2 >> 2] | 0, i20, 4, HEAP32[i22 >> 2] | 0) | 0;
      HEAP32[i4 >> 2] = i28;
      if ((i28 | 0) == 0) {
       i28 = FUNCTION_TABLE_iiiii[HEAP32[i23 >> 2] & 3](HEAP32[i2 >> 2] | 0, i27 + 16 | 0, HEAP32[i20 >> 2] | 0, HEAP32[i22 >> 2] | 0) | 0;
       HEAP32[i4 >> 2] = i28;
      }
     }
    }
   } while (0);
   i26 = i26 + 1 | 0;
  } while ((i26 | 0) != (i25 | 0));
 }
 i18 = HEAP32[i6 + 56 >> 2] | 0;
 HEAP32[i17 >> 2] = i18;
 if ((i28 | 0) == 0) {
  i28 = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i17, 4, HEAP32[i2 + 8 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i28;
 }
 if ((i18 | 0) > 0) {
  i17 = i6 + 16 | 0;
  i19 = 0;
  do {
   _DumpFunction(HEAP32[(HEAP32[i17 >> 2] | 0) + (i19 << 2) >> 2] | 0, i2);
   i19 = i19 + 1 | 0;
  } while ((i19 | 0) != (i18 | 0));
  i28 = HEAP32[i4 >> 2] | 0;
 }
 i17 = i6 + 40 | 0;
 i18 = HEAP32[i17 >> 2] | 0;
 HEAP32[i16 >> 2] = i18;
 if ((i28 | 0) == 0) {
  i28 = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i16, 4, HEAP32[i2 + 8 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i28;
 }
 if ((i18 | 0) > 0) {
  i19 = i6 + 28 | 0;
  i16 = i2 + 4 | 0;
  i20 = i2 + 8 | 0;
  i21 = 0;
  do {
   i22 = HEAP32[i19 >> 2] | 0;
   HEAP8[i1] = HEAP8[i22 + (i21 << 3) + 4 | 0] | 0;
   if ((i28 | 0) == 0) {
    i28 = FUNCTION_TABLE_iiiii[HEAP32[i16 >> 2] & 3](HEAP32[i2 >> 2] | 0, i1, 1, HEAP32[i20 >> 2] | 0) | 0;
    HEAP32[i4 >> 2] = i28;
    i22 = HEAP32[i19 >> 2] | 0;
   }
   HEAP8[i1] = HEAP8[i22 + (i21 << 3) + 5 | 0] | 0;
   if ((i28 | 0) == 0) {
    i28 = FUNCTION_TABLE_iiiii[HEAP32[i16 >> 2] & 3](HEAP32[i2 >> 2] | 0, i1, 1, HEAP32[i20 >> 2] | 0) | 0;
    HEAP32[i4 >> 2] = i28;
   }
   i21 = i21 + 1 | 0;
  } while ((i21 | 0) != (i18 | 0));
 }
 i16 = i2 + 12 | 0;
 if ((HEAP32[i16 >> 2] | 0) == 0 ? (i13 = HEAP32[i6 + 36 >> 2] | 0, (i13 | 0) != 0) : 0) {
  HEAP32[i12 >> 2] = (HEAP32[i13 + 12 >> 2] | 0) + 1;
  if ((i28 | 0) == 0 ? (i14 = i2 + 4 | 0, i15 = i2 + 8 | 0, i30 = FUNCTION_TABLE_iiiii[HEAP32[i14 >> 2] & 3](HEAP32[i2 >> 2] | 0, i12, 4, HEAP32[i15 >> 2] | 0) | 0, HEAP32[i4 >> 2] = i30, (i30 | 0) == 0) : 0) {
   HEAP32[i4 >> 2] = FUNCTION_TABLE_iiiii[HEAP32[i14 >> 2] & 3](HEAP32[i2 >> 2] | 0, i13 + 16 | 0, HEAP32[i12 >> 2] | 0, HEAP32[i15 >> 2] | 0) | 0;
  }
 } else {
  i12 = i10;
  i11 = 50;
 }
 if ((i11 | 0) == 50) {
  HEAP32[i10 >> 2] = 0;
  if ((i28 | 0) == 0) {
   HEAP32[i4 >> 2] = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i12, 4, HEAP32[i2 + 8 >> 2] | 0) | 0;
  }
 }
 if ((HEAP32[i16 >> 2] | 0) == 0) {
  i11 = HEAP32[i6 + 52 >> 2] | 0;
 } else {
  i11 = 0;
 }
 i10 = HEAP32[i6 + 20 >> 2] | 0;
 HEAP32[i9 >> 2] = i11;
 i14 = HEAP32[i4 >> 2] | 0;
 if ((i14 | 0) == 0) {
  i12 = i2 + 4 | 0;
  i13 = i2 + 8 | 0;
  i14 = FUNCTION_TABLE_iiiii[HEAP32[i12 >> 2] & 3](HEAP32[i2 >> 2] | 0, i9, 4, HEAP32[i13 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i14;
  if ((i14 | 0) == 0) {
   i14 = FUNCTION_TABLE_iiiii[HEAP32[i12 >> 2] & 3](HEAP32[i2 >> 2] | 0, i10, i11 << 2, HEAP32[i13 >> 2] | 0) | 0;
   HEAP32[i4 >> 2] = i14;
  }
 }
 if ((HEAP32[i16 >> 2] | 0) == 0) {
  i9 = HEAP32[i6 + 60 >> 2] | 0;
 } else {
  i9 = 0;
 }
 HEAP32[i8 >> 2] = i9;
 if ((i14 | 0) == 0) {
  i14 = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i8, 4, HEAP32[i2 + 8 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i14;
 }
 if ((i9 | 0) > 0) {
  i10 = i6 + 24 | 0;
  i11 = i2 + 4 | 0;
  i8 = i2 + 8 | 0;
  i12 = 0;
  do {
   i13 = HEAP32[(HEAP32[i10 >> 2] | 0) + (i12 * 12 | 0) >> 2] | 0;
   if ((i13 | 0) == 0) {
    HEAP32[i1 >> 2] = 0;
    if ((i14 | 0) == 0) {
     i14 = FUNCTION_TABLE_iiiii[HEAP32[i11 >> 2] & 3](HEAP32[i2 >> 2] | 0, i1, 4, HEAP32[i8 >> 2] | 0) | 0;
     HEAP32[i4 >> 2] = i14;
    }
   } else {
    HEAP32[i3 >> 2] = (HEAP32[i13 + 12 >> 2] | 0) + 1;
    if ((i14 | 0) == 0) {
     i14 = FUNCTION_TABLE_iiiii[HEAP32[i11 >> 2] & 3](HEAP32[i2 >> 2] | 0, i3, 4, HEAP32[i8 >> 2] | 0) | 0;
     HEAP32[i4 >> 2] = i14;
     if ((i14 | 0) == 0) {
      i14 = FUNCTION_TABLE_iiiii[HEAP32[i11 >> 2] & 3](HEAP32[i2 >> 2] | 0, i13 + 16 | 0, HEAP32[i3 >> 2] | 0, HEAP32[i8 >> 2] | 0) | 0;
      HEAP32[i4 >> 2] = i14;
     }
    }
   }
   i13 = HEAP32[i10 >> 2] | 0;
   HEAP32[i1 >> 2] = HEAP32[i13 + (i12 * 12 | 0) + 4 >> 2];
   if ((i14 | 0) == 0) {
    i14 = FUNCTION_TABLE_iiiii[HEAP32[i11 >> 2] & 3](HEAP32[i2 >> 2] | 0, i1, 4, HEAP32[i8 >> 2] | 0) | 0;
    HEAP32[i4 >> 2] = i14;
    i13 = HEAP32[i10 >> 2] | 0;
   }
   HEAP32[i1 >> 2] = HEAP32[i13 + (i12 * 12 | 0) + 8 >> 2];
   if ((i14 | 0) == 0) {
    i14 = FUNCTION_TABLE_iiiii[HEAP32[i11 >> 2] & 3](HEAP32[i2 >> 2] | 0, i1, 4, HEAP32[i8 >> 2] | 0) | 0;
    HEAP32[i4 >> 2] = i14;
   }
   i12 = i12 + 1 | 0;
  } while ((i12 | 0) != (i9 | 0));
 }
 if ((HEAP32[i16 >> 2] | 0) == 0) {
  i8 = HEAP32[i17 >> 2] | 0;
 } else {
  i8 = 0;
 }
 HEAP32[i7 >> 2] = i8;
 if ((i14 | 0) == 0) {
  i14 = FUNCTION_TABLE_iiiii[HEAP32[i2 + 4 >> 2] & 3](HEAP32[i2 >> 2] | 0, i7, 4, HEAP32[i2 + 8 >> 2] | 0) | 0;
  HEAP32[i4 >> 2] = i14;
 }
 if ((i8 | 0) <= 0) {
  STACKTOP = i5;
  return;
 }
 i7 = i6 + 28 | 0;
 i6 = i2 + 4 | 0;
 i9 = i2 + 8 | 0;
 i10 = 0;
 do {
  i11 = HEAP32[(HEAP32[i7 >> 2] | 0) + (i10 << 3) >> 2] | 0;
  if ((i11 | 0) == 0) {
   HEAP32[i1 >> 2] = 0;
   if ((i14 | 0) == 0) {
    i14 = FUNCTION_TABLE_iiiii[HEAP32[i6 >> 2] & 3](HEAP32[i2 >> 2] | 0, i1, 4, HEAP32[i9 >> 2] | 0) | 0;
    HEAP32[i4 >> 2] = i14;
   }
  } else {
   HEAP32[i3 >> 2] = (HEAP32[i11 + 12 >> 2] | 0) + 1;
   if ((i14 | 0) == 0) {
    i14 = FUNCTION_TABLE_iiiii[HEAP32[i6 >> 2] & 3](HEAP32[i2 >> 2] | 0, i3, 4, HEAP32[i9 >> 2] | 0) | 0;
    HEAP32[i4 >> 2] = i14;
    if ((i14 | 0) == 0) {
     i14 = FUNCTION_TABLE_iiiii[HEAP32[i6 >> 2] & 3](HEAP32[i2 >> 2] | 0, i11 + 16 | 0, HEAP32[i3 >> 2] | 0, HEAP32[i9 >> 2] | 0) | 0;
     HEAP32[i4 >> 2] = i14;
    }
   }
  }
  i10 = i10 + 1 | 0;
 } while ((i10 | 0) != (i8 | 0));
 STACKTOP = i5;
 return;
}
function _LoadFunction(i2, i6) {
 i2 = i2 | 0;
 i6 = i6 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i1;
 i5 = i1 + 8 | 0;
 i4 = i2 + 4 | 0;
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
  _error(i2, 8824);
 }
 i8 = HEAP32[i3 >> 2] | 0;
 if ((i8 | 0) < 0) {
  _error(i2, 8872);
 }
 HEAP32[i6 + 64 >> 2] = i8;
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
  _error(i2, 8824);
 }
 i8 = HEAP32[i3 >> 2] | 0;
 if ((i8 | 0) < 0) {
  _error(i2, 8872);
 }
 HEAP32[i6 + 68 >> 2] = i8;
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 1) | 0) != 0) {
  _error(i2, 8824);
 }
 HEAP8[i6 + 76 | 0] = HEAP8[i3] | 0;
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 1) | 0) != 0) {
  _error(i2, 8824);
 }
 HEAP8[i6 + 77 | 0] = HEAP8[i3] | 0;
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 1) | 0) != 0) {
  _error(i2, 8824);
 }
 HEAP8[i6 + 78 | 0] = HEAP8[i3] | 0;
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
  _error(i2, 8824);
 }
 i9 = HEAP32[i3 >> 2] | 0;
 if ((i9 | 0) < 0) {
  _error(i2, 8872);
 }
 i8 = HEAP32[i2 >> 2] | 0;
 if ((i9 + 1 | 0) >>> 0 > 1073741823) {
  _luaM_toobig(i8);
 }
 i14 = i9 << 2;
 i13 = _luaM_realloc_(i8, 0, 0, i14) | 0;
 HEAP32[i6 + 12 >> 2] = i13;
 HEAP32[i6 + 48 >> 2] = i9;
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i13, i14) | 0) != 0) {
  _error(i2, 8824);
 }
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
  _error(i2, 8824);
 }
 i8 = HEAP32[i3 >> 2] | 0;
 if ((i8 | 0) < 0) {
  _error(i2, 8872);
 }
 i9 = HEAP32[i2 >> 2] | 0;
 if ((i8 + 1 | 0) >>> 0 > 268435455) {
  _luaM_toobig(i9);
 }
 i11 = _luaM_realloc_(i9, 0, 0, i8 << 4) | 0;
 i9 = i6 + 8 | 0;
 HEAP32[i9 >> 2] = i11;
 HEAP32[i6 + 44 >> 2] = i8;
 i12 = (i8 | 0) > 0;
 L43 : do {
  if (i12) {
   i10 = 0;
   do {
    HEAP32[i11 + (i10 << 4) + 8 >> 2] = 0;
    i10 = i10 + 1 | 0;
   } while ((i10 | 0) != (i8 | 0));
   if (i12) {
    i10 = i2 + 8 | 0;
    i13 = 0;
    while (1) {
     i12 = i11 + (i13 << 4) | 0;
     if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 1) | 0) != 0) {
      i9 = 34;
      break;
     }
     i14 = HEAP8[i3] | 0;
     if ((i14 | 0) == 4) {
      if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
       i9 = 44;
       break;
      }
      i14 = HEAP32[i3 >> 2] | 0;
      if ((i14 | 0) == 0) {
       i14 = 0;
      } else {
       i14 = _luaZ_openspace(HEAP32[i2 >> 2] | 0, HEAP32[i10 >> 2] | 0, i14) | 0;
       if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i14, HEAP32[i3 >> 2] | 0) | 0) != 0) {
        i9 = 47;
        break;
       }
       i14 = _luaS_newlstr(HEAP32[i2 >> 2] | 0, i14, (HEAP32[i3 >> 2] | 0) + -1 | 0) | 0;
      }
      HEAP32[i12 >> 2] = i14;
      HEAP32[i11 + (i13 << 4) + 8 >> 2] = HEAPU8[i14 + 4 | 0] | 64;
     } else if ((i14 | 0) == 1) {
      if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 1) | 0) != 0) {
       i9 = 38;
       break;
      }
      HEAP32[i12 >> 2] = HEAP8[i3] | 0;
      HEAP32[i11 + (i13 << 4) + 8 >> 2] = 1;
     } else if ((i14 | 0) == 3) {
      if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 8) | 0) != 0) {
       i9 = 41;
       break;
      }
      HEAPF64[i12 >> 3] = +HEAPF64[i3 >> 3];
      HEAP32[i11 + (i13 << 4) + 8 >> 2] = 3;
     } else if ((i14 | 0) == 0) {
      HEAP32[i11 + (i13 << 4) + 8 >> 2] = 0;
     }
     i13 = i13 + 1 | 0;
     if ((i13 | 0) >= (i8 | 0)) {
      break L43;
     }
     i11 = HEAP32[i9 >> 2] | 0;
    }
    if ((i9 | 0) == 34) {
     _error(i2, 8824);
    } else if ((i9 | 0) == 38) {
     _error(i2, 8824);
    } else if ((i9 | 0) == 41) {
     _error(i2, 8824);
    } else if ((i9 | 0) == 44) {
     _error(i2, 8824);
    } else if ((i9 | 0) == 47) {
     _error(i2, 8824);
    }
   }
  }
 } while (0);
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
  _error(i2, 8824);
 }
 i8 = HEAP32[i3 >> 2] | 0;
 if ((i8 | 0) < 0) {
  _error(i2, 8872);
 }
 i9 = HEAP32[i2 >> 2] | 0;
 if ((i8 + 1 | 0) >>> 0 > 1073741823) {
  _luaM_toobig(i9);
 }
 i11 = _luaM_realloc_(i9, 0, 0, i8 << 2) | 0;
 i9 = i6 + 16 | 0;
 HEAP32[i9 >> 2] = i11;
 HEAP32[i6 + 56 >> 2] = i8;
 i10 = (i8 | 0) > 0;
 if (i10) {
  i12 = 0;
  while (1) {
   HEAP32[i11 + (i12 << 2) >> 2] = 0;
   i12 = i12 + 1 | 0;
   if ((i12 | 0) == (i8 | 0)) {
    break;
   }
   i11 = HEAP32[i9 >> 2] | 0;
  }
  if (i10) {
   i10 = 0;
   do {
    i14 = _luaF_newproto(HEAP32[i2 >> 2] | 0) | 0;
    HEAP32[(HEAP32[i9 >> 2] | 0) + (i10 << 2) >> 2] = i14;
    _LoadFunction(i2, HEAP32[(HEAP32[i9 >> 2] | 0) + (i10 << 2) >> 2] | 0);
    i10 = i10 + 1 | 0;
   } while ((i10 | 0) != (i8 | 0));
  }
 }
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
  _error(i2, 8824);
 }
 i9 = HEAP32[i3 >> 2] | 0;
 if ((i9 | 0) < 0) {
  _error(i2, 8872);
 }
 i8 = HEAP32[i2 >> 2] | 0;
 if ((i9 + 1 | 0) >>> 0 > 536870911) {
  _luaM_toobig(i8);
 }
 i10 = _luaM_realloc_(i8, 0, 0, i9 << 3) | 0;
 i8 = i6 + 28 | 0;
 HEAP32[i8 >> 2] = i10;
 HEAP32[i6 + 40 >> 2] = i9;
 L98 : do {
  if ((i9 | 0) > 0) {
   HEAP32[i10 >> 2] = 0;
   if ((i9 | 0) == 1) {
    i10 = 0;
   } else {
    i10 = 1;
    while (1) {
     HEAP32[(HEAP32[i8 >> 2] | 0) + (i10 << 3) >> 2] = 0;
     i10 = i10 + 1 | 0;
     if ((i10 | 0) == (i9 | 0)) {
      i10 = 0;
      break;
     }
    }
   }
   while (1) {
    if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 1) | 0) != 0) {
     i9 = 73;
     break;
    }
    HEAP8[(HEAP32[i8 >> 2] | 0) + (i10 << 3) + 4 | 0] = HEAP8[i3] | 0;
    if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 1) | 0) != 0) {
     i9 = 75;
     break;
    }
    HEAP8[(HEAP32[i8 >> 2] | 0) + (i10 << 3) + 5 | 0] = HEAP8[i3] | 0;
    i10 = i10 + 1 | 0;
    if ((i10 | 0) >= (i9 | 0)) {
     break L98;
    }
   }
   if ((i9 | 0) == 73) {
    _error(i2, 8824);
   } else if ((i9 | 0) == 75) {
    _error(i2, 8824);
   }
  }
 } while (0);
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
  _error(i2, 8824);
 }
 i9 = HEAP32[i3 >> 2] | 0;
 do {
  if ((i9 | 0) != 0) {
   i9 = _luaZ_openspace(HEAP32[i2 >> 2] | 0, HEAP32[i2 + 8 >> 2] | 0, i9) | 0;
   if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i9, HEAP32[i3 >> 2] | 0) | 0) == 0) {
    i7 = _luaS_newlstr(HEAP32[i2 >> 2] | 0, i9, (HEAP32[i3 >> 2] | 0) + -1 | 0) | 0;
    break;
   } else {
    _error(i2, 8824);
   }
  } else {
   i7 = 0;
  }
 } while (0);
 HEAP32[i6 + 36 >> 2] = i7;
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
  _error(i2, 8824);
 }
 i7 = HEAP32[i3 >> 2] | 0;
 if ((i7 | 0) < 0) {
  _error(i2, 8872);
 }
 i9 = HEAP32[i2 >> 2] | 0;
 if ((i7 + 1 | 0) >>> 0 > 1073741823) {
  _luaM_toobig(i9);
 }
 i14 = i7 << 2;
 i13 = _luaM_realloc_(i9, 0, 0, i14) | 0;
 HEAP32[i6 + 20 >> 2] = i13;
 HEAP32[i6 + 52 >> 2] = i7;
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i13, i14) | 0) != 0) {
  _error(i2, 8824);
 }
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
  _error(i2, 8824);
 }
 i7 = HEAP32[i3 >> 2] | 0;
 if ((i7 | 0) < 0) {
  _error(i2, 8872);
 }
 i9 = HEAP32[i2 >> 2] | 0;
 if ((i7 + 1 | 0) >>> 0 > 357913941) {
  _luaM_toobig(i9);
 }
 i10 = _luaM_realloc_(i9, 0, 0, i7 * 12 | 0) | 0;
 i9 = i6 + 24 | 0;
 HEAP32[i9 >> 2] = i10;
 HEAP32[i6 + 60 >> 2] = i7;
 L141 : do {
  if ((i7 | 0) > 0) {
   HEAP32[i10 >> 2] = 0;
   if ((i7 | 0) != 1) {
    i6 = 1;
    do {
     HEAP32[(HEAP32[i9 >> 2] | 0) + (i6 * 12 | 0) >> 2] = 0;
     i6 = i6 + 1 | 0;
    } while ((i6 | 0) != (i7 | 0));
   }
   i6 = i2 + 8 | 0;
   i10 = 0;
   while (1) {
    if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
     i9 = 102;
     break;
    }
    i11 = HEAP32[i3 >> 2] | 0;
    if ((i11 | 0) == 0) {
     i11 = 0;
    } else {
     i11 = _luaZ_openspace(HEAP32[i2 >> 2] | 0, HEAP32[i6 >> 2] | 0, i11) | 0;
     if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i11, HEAP32[i3 >> 2] | 0) | 0) != 0) {
      i9 = 105;
      break;
     }
     i11 = _luaS_newlstr(HEAP32[i2 >> 2] | 0, i11, (HEAP32[i3 >> 2] | 0) + -1 | 0) | 0;
    }
    HEAP32[(HEAP32[i9 >> 2] | 0) + (i10 * 12 | 0) >> 2] = i11;
    if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
     i9 = 108;
     break;
    }
    i11 = HEAP32[i3 >> 2] | 0;
    if ((i11 | 0) < 0) {
     i9 = 110;
     break;
    }
    HEAP32[(HEAP32[i9 >> 2] | 0) + (i10 * 12 | 0) + 4 >> 2] = i11;
    if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
     i9 = 112;
     break;
    }
    i11 = HEAP32[i3 >> 2] | 0;
    if ((i11 | 0) < 0) {
     i9 = 114;
     break;
    }
    HEAP32[(HEAP32[i9 >> 2] | 0) + (i10 * 12 | 0) + 8 >> 2] = i11;
    i10 = i10 + 1 | 0;
    if ((i10 | 0) >= (i7 | 0)) {
     break L141;
    }
   }
   if ((i9 | 0) == 102) {
    _error(i2, 8824);
   } else if ((i9 | 0) == 105) {
    _error(i2, 8824);
   } else if ((i9 | 0) == 108) {
    _error(i2, 8824);
   } else if ((i9 | 0) == 110) {
    _error(i2, 8872);
   } else if ((i9 | 0) == 112) {
    _error(i2, 8824);
   } else if ((i9 | 0) == 114) {
    _error(i2, 8872);
   }
  }
 } while (0);
 if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i5, 4) | 0) != 0) {
  _error(i2, 8824);
 }
 i6 = HEAP32[i5 >> 2] | 0;
 if ((i6 | 0) < 0) {
  _error(i2, 8872);
 }
 if ((i6 | 0) <= 0) {
  STACKTOP = i1;
  return;
 }
 i5 = i2 + 8 | 0;
 i7 = 0;
 while (1) {
  if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i3, 4) | 0) != 0) {
   i9 = 123;
   break;
  }
  i9 = HEAP32[i3 >> 2] | 0;
  if ((i9 | 0) == 0) {
   i9 = 0;
  } else {
   i9 = _luaZ_openspace(HEAP32[i2 >> 2] | 0, HEAP32[i5 >> 2] | 0, i9) | 0;
   if ((_luaZ_read(HEAP32[i4 >> 2] | 0, i9, HEAP32[i3 >> 2] | 0) | 0) != 0) {
    i9 = 126;
    break;
   }
   i9 = _luaS_newlstr(HEAP32[i2 >> 2] | 0, i9, (HEAP32[i3 >> 2] | 0) + -1 | 0) | 0;
  }
  HEAP32[(HEAP32[i8 >> 2] | 0) + (i7 << 3) >> 2] = i9;
  i7 = i7 + 1 | 0;
  if ((i7 | 0) >= (i6 | 0)) {
   i9 = 129;
   break;
  }
 }
 if ((i9 | 0) == 123) {
  _error(i2, 8824);
 } else if ((i9 | 0) == 126) {
  _error(i2, 8824);
 } else if ((i9 | 0) == 129) {
  STACKTOP = i1;
  return;
 }
}
function _exp2reg(i4, i1, i7) {
 i4 = i4 | 0;
 i1 = i1 | 0;
 i7 = i7 | 0;
 var i2 = 0, i3 = 0, i5 = 0, i6 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0;
 i5 = STACKTOP;
 _discharge2reg(i4, i1, i7);
 i6 = i1 + 16 | 0;
 do {
  if ((HEAP32[i1 >> 2] | 0) == 10 ? (i10 = HEAP32[i1 + 8 >> 2] | 0, !((i10 | 0) == -1)) : 0) {
   i22 = HEAP32[i6 >> 2] | 0;
   if ((i22 | 0) == -1) {
    HEAP32[i6 >> 2] = i10;
    break;
   }
   i20 = HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0;
   while (1) {
    i19 = i20 + (i22 << 2) | 0;
    i21 = HEAP32[i19 >> 2] | 0;
    i23 = (i21 >>> 14) + -131071 | 0;
    if ((i23 | 0) == -1) {
     break;
    }
    i23 = i22 + 1 + i23 | 0;
    if ((i23 | 0) == -1) {
     break;
    } else {
     i22 = i23;
    }
   }
   i10 = i10 + ~i22 | 0;
   if ((((i10 | 0) > -1 ? i10 : 0 - i10 | 0) | 0) > 131071) {
    _luaX_syntaxerror(HEAP32[i4 + 12 >> 2] | 0, 10624);
   } else {
    HEAP32[i19 >> 2] = (i10 << 14) + 2147467264 | i21 & 16383;
    break;
   }
  }
 } while (0);
 i21 = HEAP32[i6 >> 2] | 0;
 i10 = i1 + 20 | 0;
 i19 = HEAP32[i10 >> 2] | 0;
 if ((i21 | 0) == (i19 | 0)) {
  HEAP32[i6 >> 2] = -1;
  HEAP32[i10 >> 2] = -1;
  i25 = i1 + 8 | 0;
  HEAP32[i25 >> 2] = i7;
  HEAP32[i1 >> 2] = 6;
  STACKTOP = i5;
  return;
 }
 L18 : do {
  if ((i21 | 0) == -1) {
   i18 = 20;
  } else {
   i20 = HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0;
   while (1) {
    i23 = i20 + (i21 << 2) | 0;
    if ((i21 | 0) > 0 ? (i18 = HEAP32[i20 + (i21 + -1 << 2) >> 2] | 0, (HEAP8[5584 + (i18 & 63) | 0] | 0) < 0) : 0) {
     i22 = i18;
    } else {
     i22 = HEAP32[i23 >> 2] | 0;
    }
    if ((i22 & 63 | 0) != 28) {
     i18 = 28;
     break L18;
    }
    i22 = ((HEAP32[i23 >> 2] | 0) >>> 14) + -131071 | 0;
    if ((i22 | 0) == -1) {
     i18 = 20;
     break L18;
    }
    i21 = i21 + 1 + i22 | 0;
    if ((i21 | 0) == -1) {
     i18 = 20;
     break;
    }
   }
  }
 } while (0);
 L29 : do {
  if ((i18 | 0) == 20) {
   if ((i19 | 0) == -1) {
    i15 = -1;
    i8 = -1;
   } else {
    i20 = HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0;
    while (1) {
     i21 = i20 + (i19 << 2) | 0;
     if ((i19 | 0) > 0 ? (i17 = HEAP32[i20 + (i19 + -1 << 2) >> 2] | 0, (HEAP8[5584 + (i17 & 63) | 0] | 0) < 0) : 0) {
      i22 = i17;
     } else {
      i22 = HEAP32[i21 >> 2] | 0;
     }
     if ((i22 & 63 | 0) != 28) {
      i18 = 28;
      break L29;
     }
     i21 = ((HEAP32[i21 >> 2] | 0) >>> 14) + -131071 | 0;
     if ((i21 | 0) == -1) {
      i15 = -1;
      i8 = -1;
      break L29;
     }
     i19 = i19 + 1 + i21 | 0;
     if ((i19 | 0) == -1) {
      i15 = -1;
      i8 = -1;
      break;
     }
    }
   }
  }
 } while (0);
 do {
  if ((i18 | 0) == 28) {
   i17 = i4 + 28 | 0;
   do {
    if ((HEAP32[i1 >> 2] | 0) != 10) {
     i21 = HEAP32[i17 >> 2] | 0;
     HEAP32[i17 >> 2] = -1;
     i18 = _luaK_code(i4, 2147450903) | 0;
     if (!((i21 | 0) == -1)) {
      if (!((i18 | 0) == -1)) {
       i23 = HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0;
       i22 = i18;
       while (1) {
        i20 = i23 + (i22 << 2) | 0;
        i19 = HEAP32[i20 >> 2] | 0;
        i24 = (i19 >>> 14) + -131071 | 0;
        if ((i24 | 0) == -1) {
         break;
        }
        i24 = i22 + 1 + i24 | 0;
        if ((i24 | 0) == -1) {
         break;
        } else {
         i22 = i24;
        }
       }
       i21 = i21 + ~i22 | 0;
       if ((((i21 | 0) > -1 ? i21 : 0 - i21 | 0) | 0) > 131071) {
        _luaX_syntaxerror(HEAP32[i4 + 12 >> 2] | 0, 10624);
       } else {
        HEAP32[i20 >> 2] = (i21 << 14) + 2147467264 | i19 & 16383;
        i16 = i18;
        break;
       }
      } else {
       i16 = i21;
      }
     } else {
      i16 = i18;
     }
    } else {
     i16 = -1;
    }
   } while (0);
   i24 = i4 + 20 | 0;
   i25 = i4 + 24 | 0;
   HEAP32[i25 >> 2] = HEAP32[i24 >> 2];
   i19 = i7 << 6;
   i18 = _luaK_code(i4, i19 | 16387) | 0;
   HEAP32[i25 >> 2] = HEAP32[i24 >> 2];
   i19 = _luaK_code(i4, i19 | 8388611) | 0;
   HEAP32[i25 >> 2] = HEAP32[i24 >> 2];
   if (!((i16 | 0) == -1)) {
    i22 = HEAP32[i17 >> 2] | 0;
    if ((i22 | 0) == -1) {
     HEAP32[i17 >> 2] = i16;
     i15 = i18;
     i8 = i19;
     break;
    }
    i17 = HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0;
    while (1) {
     i21 = i17 + (i22 << 2) | 0;
     i20 = HEAP32[i21 >> 2] | 0;
     i23 = (i20 >>> 14) + -131071 | 0;
     if ((i23 | 0) == -1) {
      break;
     }
     i23 = i22 + 1 + i23 | 0;
     if ((i23 | 0) == -1) {
      break;
     } else {
      i22 = i23;
     }
    }
    i16 = i16 + ~i22 | 0;
    if ((((i16 | 0) > -1 ? i16 : 0 - i16 | 0) | 0) > 131071) {
     _luaX_syntaxerror(HEAP32[i4 + 12 >> 2] | 0, 10624);
    } else {
     HEAP32[i21 >> 2] = (i16 << 14) + 2147467264 | i20 & 16383;
     i15 = i18;
     i8 = i19;
     break;
    }
   } else {
    i15 = i18;
    i8 = i19;
   }
  }
 } while (0);
 i16 = HEAP32[i4 + 20 >> 2] | 0;
 HEAP32[i4 + 24 >> 2] = i16;
 i22 = HEAP32[i10 >> 2] | 0;
 L67 : do {
  if (!((i22 | 0) == -1)) {
   i19 = (i7 | 0) == 255;
   i17 = i7 << 6 & 16320;
   i18 = HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0;
   while (1) {
    i20 = i18 + (i22 << 2) | 0;
    i23 = HEAP32[i20 >> 2] | 0;
    i21 = (i23 >>> 14) + -131071 | 0;
    if ((i21 | 0) == -1) {
     i21 = -1;
    } else {
     i21 = i22 + 1 + i21 | 0;
    }
    if ((i22 | 0) > 0 ? (i14 = i18 + (i22 + -1 << 2) | 0, i13 = HEAP32[i14 >> 2] | 0, (HEAP8[5584 + (i13 & 63) | 0] | 0) < 0) : 0) {
     i24 = i14;
     i25 = i13;
    } else {
     i24 = i20;
     i25 = i23;
    }
    if ((i25 & 63 | 0) == 28) {
     i23 = i25 >>> 23;
     if (i19 | (i23 | 0) == (i7 | 0)) {
      i23 = i25 & 8372224 | i23 << 6 | 27;
     } else {
      i23 = i25 & -16321 | i17;
     }
     HEAP32[i24 >> 2] = i23;
     i22 = i16 + ~i22 | 0;
     if ((((i22 | 0) > -1 ? i22 : 0 - i22 | 0) | 0) > 131071) {
      i18 = 58;
      break;
     }
     i22 = HEAP32[i20 >> 2] & 16383 | (i22 << 14) + 2147467264;
    } else {
     i22 = i15 + ~i22 | 0;
     if ((((i22 | 0) > -1 ? i22 : 0 - i22 | 0) | 0) > 131071) {
      i18 = 61;
      break;
     }
     i22 = i23 & 16383 | (i22 << 14) + 2147467264;
    }
    HEAP32[i20 >> 2] = i22;
    if ((i21 | 0) == -1) {
     break L67;
    } else {
     i22 = i21;
    }
   }
   if ((i18 | 0) == 58) {
    _luaX_syntaxerror(HEAP32[i4 + 12 >> 2] | 0, 10624);
   } else if ((i18 | 0) == 61) {
    _luaX_syntaxerror(HEAP32[i4 + 12 >> 2] | 0, 10624);
   }
  }
 } while (0);
 i20 = HEAP32[i6 >> 2] | 0;
 if ((i20 | 0) == -1) {
  HEAP32[i6 >> 2] = -1;
  HEAP32[i10 >> 2] = -1;
  i25 = i1 + 8 | 0;
  HEAP32[i25 >> 2] = i7;
  HEAP32[i1 >> 2] = 6;
  STACKTOP = i5;
  return;
 }
 i13 = i7 << 6;
 i15 = i13 & 16320;
 i14 = HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0;
 if ((i7 | 0) == 255) {
  while (1) {
   i17 = i14 + (i20 << 2) | 0;
   i19 = HEAP32[i17 >> 2] | 0;
   i18 = (i19 >>> 14) + -131071 | 0;
   if ((i18 | 0) == -1) {
    i18 = -1;
   } else {
    i18 = i20 + 1 + i18 | 0;
   }
   if ((i20 | 0) > 0 ? (i12 = i14 + (i20 + -1 << 2) | 0, i11 = HEAP32[i12 >> 2] | 0, (HEAP8[5584 + (i11 & 63) | 0] | 0) < 0) : 0) {
    i22 = i12;
    i21 = i11;
   } else {
    i22 = i17;
    i21 = i19;
   }
   if ((i21 & 63 | 0) == 28) {
    HEAP32[i22 >> 2] = i21 & 8372224 | i21 >>> 23 << 6 | 27;
    i19 = i16 + ~i20 | 0;
    if ((((i19 | 0) > -1 ? i19 : 0 - i19 | 0) | 0) > 131071) {
     i18 = 87;
     break;
    }
    i19 = HEAP32[i17 >> 2] & 16383 | (i19 << 14) + 2147467264;
   } else {
    i20 = i8 + ~i20 | 0;
    if ((((i20 | 0) > -1 ? i20 : 0 - i20 | 0) | 0) > 131071) {
     i18 = 90;
     break;
    }
    i19 = i19 & 16383 | (i20 << 14) + 2147467264;
   }
   HEAP32[i17 >> 2] = i19;
   if ((i18 | 0) == -1) {
    i18 = 93;
    break;
   } else {
    i20 = i18;
   }
  }
  if ((i18 | 0) == 87) {
   i25 = i4 + 12 | 0;
   i25 = HEAP32[i25 >> 2] | 0;
   _luaX_syntaxerror(i25, 10624);
  } else if ((i18 | 0) == 90) {
   i25 = i4 + 12 | 0;
   i25 = HEAP32[i25 >> 2] | 0;
   _luaX_syntaxerror(i25, 10624);
  } else if ((i18 | 0) == 93) {
   HEAP32[i6 >> 2] = -1;
   HEAP32[i10 >> 2] = -1;
   i25 = i1 + 8 | 0;
   HEAP32[i25 >> 2] = i7;
   HEAP32[i1 >> 2] = 6;
   STACKTOP = i5;
   return;
  }
 } else {
  i9 = i20;
 }
 while (1) {
  i11 = i14 + (i9 << 2) | 0;
  i17 = HEAP32[i11 >> 2] | 0;
  i12 = (i17 >>> 14) + -131071 | 0;
  if ((i12 | 0) == -1) {
   i12 = -1;
  } else {
   i12 = i9 + 1 + i12 | 0;
  }
  if ((i9 | 0) > 0 ? (i3 = i14 + (i9 + -1 << 2) | 0, i2 = HEAP32[i3 >> 2] | 0, (HEAP8[5584 + (i2 & 63) | 0] | 0) < 0) : 0) {
   i18 = i3;
   i19 = i2;
  } else {
   i18 = i11;
   i19 = i17;
  }
  if ((i19 & 63 | 0) == 28) {
   if ((i19 >>> 23 | 0) == (i7 | 0)) {
    i17 = i19 & 8372224 | i13 | 27;
   } else {
    i17 = i19 & -16321 | i15;
   }
   HEAP32[i18 >> 2] = i17;
   i9 = i16 + ~i9 | 0;
   if ((((i9 | 0) > -1 ? i9 : 0 - i9 | 0) | 0) > 131071) {
    i18 = 87;
    break;
   }
   i9 = HEAP32[i11 >> 2] & 16383 | (i9 << 14) + 2147467264;
  } else {
   i9 = i8 + ~i9 | 0;
   if ((((i9 | 0) > -1 ? i9 : 0 - i9 | 0) | 0) > 131071) {
    i18 = 90;
    break;
   }
   i9 = i17 & 16383 | (i9 << 14) + 2147467264;
  }
  HEAP32[i11 >> 2] = i9;
  if ((i12 | 0) == -1) {
   i18 = 93;
   break;
  } else {
   i9 = i12;
  }
 }
 if ((i18 | 0) == 87) {
  i25 = i4 + 12 | 0;
  i25 = HEAP32[i25 >> 2] | 0;
  _luaX_syntaxerror(i25, 10624);
 } else if ((i18 | 0) == 90) {
  i25 = i4 + 12 | 0;
  i25 = HEAP32[i25 >> 2] | 0;
  _luaX_syntaxerror(i25, 10624);
 } else if ((i18 | 0) == 93) {
  HEAP32[i6 >> 2] = -1;
  HEAP32[i10 >> 2] = -1;
  i25 = i1 + 8 | 0;
  HEAP32[i25 >> 2] = i7;
  HEAP32[i1 >> 2] = 6;
  STACKTOP = i5;
  return;
 }
}
function _propagatemark(i2) {
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0;
 i1 = STACKTOP;
 i15 = i2 + 84 | 0;
 i3 = HEAP32[i15 >> 2] | 0;
 i10 = i3 + 5 | 0;
 HEAP8[i10] = HEAPU8[i10] | 4;
 switch (HEAPU8[i3 + 4 | 0] | 0) {
 case 5:
  {
   i9 = i3 + 24 | 0;
   HEAP32[i15 >> 2] = HEAP32[i9 >> 2];
   i15 = i3 + 8 | 0;
   i14 = HEAP32[i15 >> 2] | 0;
   do {
    if ((i14 | 0) != 0) {
     if ((HEAP8[i14 + 6 | 0] & 8) == 0) {
      i11 = _luaT_gettm(i14, 3, HEAP32[i2 + 196 >> 2] | 0) | 0;
      i14 = HEAP32[i15 >> 2] | 0;
      if ((i14 | 0) != 0) {
       i6 = 5;
      }
     } else {
      i11 = 0;
      i6 = 5;
     }
     if ((i6 | 0) == 5) {
      if (!((HEAP8[i14 + 5 | 0] & 3) == 0)) {
       _reallymarkobject(i2, i14);
      }
     }
     if (((i11 | 0) != 0 ? (HEAP32[i11 + 8 >> 2] & 15 | 0) == 4 : 0) ? (i13 = (HEAP32[i11 >> 2] | 0) + 16 | 0, i12 = _strchr(i13, 107) | 0, i12 = (i12 | 0) != 0, i13 = (_strchr(i13, 118) | 0) == 0, !(i13 & (i12 ^ 1))) : 0) {
      HEAP8[i10] = HEAP8[i10] & 251;
      if (i12) {
       if (i13) {
        _traverseephemeron(i2, i3) | 0;
        break;
       } else {
        i15 = i2 + 100 | 0;
        HEAP32[i9 >> 2] = HEAP32[i15 >> 2];
        HEAP32[i15 >> 2] = i3;
        break;
       }
      }
      i15 = 1 << HEAPU8[i3 + 7 | 0];
      i5 = HEAP32[i3 + 16 >> 2] | 0;
      i4 = i5 + (i15 << 5) | 0;
      i8 = (HEAP32[i3 + 28 >> 2] | 0) > 0 | 0;
      if ((i15 | 0) > 0) {
       do {
        i12 = i5 + 8 | 0;
        i10 = i5 + 24 | 0;
        i11 = (HEAP32[i10 >> 2] & 64 | 0) == 0;
        do {
         if ((HEAP32[i12 >> 2] | 0) == 0) {
          if (!i11 ? !((HEAP8[(HEAP32[i5 + 16 >> 2] | 0) + 5 | 0] & 3) == 0) : 0) {
           HEAP32[i10 >> 2] = 11;
          }
         } else {
          if (!i11 ? (i7 = HEAP32[i5 + 16 >> 2] | 0, !((HEAP8[i7 + 5 | 0] & 3) == 0)) : 0) {
           _reallymarkobject(i2, i7);
          }
          if ((i8 | 0) == 0) {
           i10 = HEAP32[i12 >> 2] | 0;
           if ((i10 & 64 | 0) != 0) {
            i8 = HEAP32[i5 >> 2] | 0;
            if ((i10 & 15 | 0) != 4) {
             i8 = (HEAP8[i8 + 5 | 0] & 3) != 0 | 0;
             break;
            }
            if ((i8 | 0) != 0 ? !((HEAP8[i8 + 5 | 0] & 3) == 0) : 0) {
             _reallymarkobject(i2, i8);
             i8 = 0;
            } else {
             i8 = 0;
            }
           } else {
            i8 = 0;
           }
          }
         }
        } while (0);
        i5 = i5 + 32 | 0;
       } while (i5 >>> 0 < i4 >>> 0);
      }
      if ((i8 | 0) == 0) {
       i15 = i2 + 88 | 0;
       HEAP32[i9 >> 2] = HEAP32[i15 >> 2];
       HEAP32[i15 >> 2] = i3;
       break;
      } else {
       i15 = i2 + 92 | 0;
       HEAP32[i9 >> 2] = HEAP32[i15 >> 2];
       HEAP32[i15 >> 2] = i3;
       break;
      }
     } else {
      i6 = 33;
     }
    } else {
     i6 = 33;
    }
   } while (0);
   if ((i6 | 0) == 33) {
    i7 = i3 + 16 | 0;
    i10 = HEAP32[i7 >> 2] | 0;
    i6 = i10 + (1 << HEAPU8[i3 + 7 | 0] << 5) | 0;
    i9 = i3 + 28 | 0;
    i13 = HEAP32[i9 >> 2] | 0;
    if ((i13 | 0) > 0) {
     i10 = i3 + 12 | 0;
     i11 = 0;
     do {
      i12 = HEAP32[i10 >> 2] | 0;
      if ((HEAP32[i12 + (i11 << 4) + 8 >> 2] & 64 | 0) != 0 ? (i8 = HEAP32[i12 + (i11 << 4) >> 2] | 0, !((HEAP8[i8 + 5 | 0] & 3) == 0)) : 0) {
       _reallymarkobject(i2, i8);
       i13 = HEAP32[i9 >> 2] | 0;
      }
      i11 = i11 + 1 | 0;
     } while ((i11 | 0) < (i13 | 0));
     i7 = HEAP32[i7 >> 2] | 0;
    } else {
     i7 = i10;
    }
    if (i7 >>> 0 < i6 >>> 0) {
     do {
      i10 = i7 + 8 | 0;
      i11 = HEAP32[i10 >> 2] | 0;
      i9 = i7 + 24 | 0;
      i8 = (HEAP32[i9 >> 2] & 64 | 0) == 0;
      if ((i11 | 0) == 0) {
       if (!i8 ? !((HEAP8[(HEAP32[i7 + 16 >> 2] | 0) + 5 | 0] & 3) == 0) : 0) {
        HEAP32[i9 >> 2] = 11;
       }
      } else {
       if (!i8 ? (i5 = HEAP32[i7 + 16 >> 2] | 0, !((HEAP8[i5 + 5 | 0] & 3) == 0)) : 0) {
        _reallymarkobject(i2, i5);
        i11 = HEAP32[i10 >> 2] | 0;
       }
       if ((i11 & 64 | 0) != 0 ? (i4 = HEAP32[i7 >> 2] | 0, !((HEAP8[i4 + 5 | 0] & 3) == 0)) : 0) {
        _reallymarkobject(i2, i4);
       }
      }
      i7 = i7 + 32 | 0;
     } while (i7 >>> 0 < i6 >>> 0);
    }
   }
   i3 = (HEAP32[i3 + 28 >> 2] << 4) + 32 + (32 << HEAPU8[i3 + 7 | 0]) | 0;
   break;
  }
 case 8:
  {
   i7 = i3 + 60 | 0;
   HEAP32[i15 >> 2] = HEAP32[i7 >> 2];
   i4 = i2 + 88 | 0;
   HEAP32[i7 >> 2] = HEAP32[i4 >> 2];
   HEAP32[i4 >> 2] = i3;
   HEAP8[i10] = HEAP8[i10] & 251;
   i4 = i3 + 28 | 0;
   i7 = HEAP32[i4 >> 2] | 0;
   if ((i7 | 0) == 0) {
    i3 = 1;
   } else {
    i5 = i3 + 8 | 0;
    i6 = HEAP32[i5 >> 2] | 0;
    if (i7 >>> 0 < i6 >>> 0) {
     do {
      if ((HEAP32[i7 + 8 >> 2] & 64 | 0) != 0 ? (i11 = HEAP32[i7 >> 2] | 0, !((HEAP8[i11 + 5 | 0] & 3) == 0)) : 0) {
       _reallymarkobject(i2, i11);
       i6 = HEAP32[i5 >> 2] | 0;
      }
      i7 = i7 + 16 | 0;
     } while (i7 >>> 0 < i6 >>> 0);
    }
    if ((HEAP8[i2 + 61 | 0] | 0) == 1) {
     i3 = i3 + 32 | 0;
     i4 = (HEAP32[i4 >> 2] | 0) + (HEAP32[i3 >> 2] << 4) | 0;
     if (i7 >>> 0 < i4 >>> 0) {
      do {
       HEAP32[i7 + 8 >> 2] = 0;
       i7 = i7 + 16 | 0;
      } while (i7 >>> 0 < i4 >>> 0);
     }
    } else {
     i3 = i3 + 32 | 0;
    }
    i3 = (HEAP32[i3 >> 2] << 4) + 112 | 0;
   }
   break;
  }
 case 9:
  {
   HEAP32[i15 >> 2] = HEAP32[i3 + 72 >> 2];
   i5 = i3 + 32 | 0;
   i4 = HEAP32[i5 >> 2] | 0;
   if ((i4 | 0) != 0 ? !((HEAP8[i4 + 5 | 0] & 3) == 0) : 0) {
    HEAP32[i5 >> 2] = 0;
   }
   i4 = HEAP32[i3 + 36 >> 2] | 0;
   if ((i4 | 0) != 0 ? !((HEAP8[i4 + 5 | 0] & 3) == 0) : 0) {
    _reallymarkobject(i2, i4);
   }
   i4 = i3 + 44 | 0;
   i8 = HEAP32[i4 >> 2] | 0;
   if ((i8 | 0) > 0) {
    i5 = i3 + 8 | 0;
    i6 = 0;
    do {
     i7 = HEAP32[i5 >> 2] | 0;
     if ((HEAP32[i7 + (i6 << 4) + 8 >> 2] & 64 | 0) != 0 ? (i9 = HEAP32[i7 + (i6 << 4) >> 2] | 0, !((HEAP8[i9 + 5 | 0] & 3) == 0)) : 0) {
      _reallymarkobject(i2, i9);
      i8 = HEAP32[i4 >> 2] | 0;
     }
     i6 = i6 + 1 | 0;
    } while ((i6 | 0) < (i8 | 0));
   }
   i5 = i3 + 40 | 0;
   i8 = HEAP32[i5 >> 2] | 0;
   if ((i8 | 0) > 0) {
    i6 = i3 + 28 | 0;
    i7 = 0;
    do {
     i9 = HEAP32[(HEAP32[i6 >> 2] | 0) + (i7 << 3) >> 2] | 0;
     if ((i9 | 0) != 0 ? !((HEAP8[i9 + 5 | 0] & 3) == 0) : 0) {
      _reallymarkobject(i2, i9);
      i8 = HEAP32[i5 >> 2] | 0;
     }
     i7 = i7 + 1 | 0;
    } while ((i7 | 0) < (i8 | 0));
   }
   i6 = i3 + 56 | 0;
   i8 = HEAP32[i6 >> 2] | 0;
   if ((i8 | 0) > 0) {
    i7 = i3 + 16 | 0;
    i9 = 0;
    do {
     i10 = HEAP32[(HEAP32[i7 >> 2] | 0) + (i9 << 2) >> 2] | 0;
     if ((i10 | 0) != 0 ? !((HEAP8[i10 + 5 | 0] & 3) == 0) : 0) {
      _reallymarkobject(i2, i10);
      i8 = HEAP32[i6 >> 2] | 0;
     }
     i9 = i9 + 1 | 0;
    } while ((i9 | 0) < (i8 | 0));
   }
   i7 = i3 + 60 | 0;
   i11 = HEAP32[i7 >> 2] | 0;
   if ((i11 | 0) > 0) {
    i8 = i3 + 24 | 0;
    i9 = 0;
    do {
     i10 = HEAP32[(HEAP32[i8 >> 2] | 0) + (i9 * 12 | 0) >> 2] | 0;
     if ((i10 | 0) != 0 ? !((HEAP8[i10 + 5 | 0] & 3) == 0) : 0) {
      _reallymarkobject(i2, i10);
      i11 = HEAP32[i7 >> 2] | 0;
     }
     i9 = i9 + 1 | 0;
    } while ((i9 | 0) < (i11 | 0));
    i8 = HEAP32[i6 >> 2] | 0;
   }
   i3 = (i11 * 12 | 0) + 80 + (HEAP32[i4 >> 2] << 4) + (HEAP32[i5 >> 2] << 3) + ((HEAP32[i3 + 48 >> 2] | 0) + i8 + (HEAP32[i3 + 52 >> 2] | 0) << 2) | 0;
   break;
  }
 case 38:
  {
   HEAP32[i15 >> 2] = HEAP32[i3 + 8 >> 2];
   i4 = i3 + 6 | 0;
   i5 = HEAP8[i4] | 0;
   if (i5 << 24 >> 24 == 0) {
    i7 = i5 & 255;
   } else {
    i6 = 0;
    do {
     if ((HEAP32[i3 + (i6 << 4) + 24 >> 2] & 64 | 0) != 0 ? (i14 = HEAP32[i3 + (i6 << 4) + 16 >> 2] | 0, !((HEAP8[i14 + 5 | 0] & 3) == 0)) : 0) {
      _reallymarkobject(i2, i14);
      i5 = HEAP8[i4] | 0;
     }
     i6 = i6 + 1 | 0;
     i7 = i5 & 255;
    } while ((i6 | 0) < (i7 | 0));
   }
   i3 = (i7 << 4) + 16 | 0;
   break;
  }
 case 6:
  {
   HEAP32[i15 >> 2] = HEAP32[i3 + 8 >> 2];
   i4 = HEAP32[i3 + 12 >> 2] | 0;
   if ((i4 | 0) != 0 ? !((HEAP8[i4 + 5 | 0] & 3) == 0) : 0) {
    _reallymarkobject(i2, i4);
   }
   i4 = i3 + 6 | 0;
   i6 = HEAP8[i4] | 0;
   if (i6 << 24 >> 24 == 0) {
    i7 = i6 & 255;
   } else {
    i5 = 0;
    do {
     i7 = HEAP32[i3 + (i5 << 2) + 16 >> 2] | 0;
     if ((i7 | 0) != 0 ? !((HEAP8[i7 + 5 | 0] & 3) == 0) : 0) {
      _reallymarkobject(i2, i7);
      i6 = HEAP8[i4] | 0;
     }
     i5 = i5 + 1 | 0;
     i7 = i6 & 255;
    } while ((i5 | 0) < (i7 | 0));
   }
   i3 = (i7 << 2) + 16 | 0;
   break;
  }
 default:
  {
   STACKTOP = i1;
   return;
  }
 }
 i15 = i2 + 16 | 0;
 HEAP32[i15 >> 2] = (HEAP32[i15 >> 2] | 0) + i3;
 STACKTOP = i1;
 return;
}
function _strstr(i8, i4) {
 i8 = i8 | 0;
 i4 = i4 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i5 = 0, i6 = 0, i7 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 1056 | 0;
 i6 = i1 + 1024 | 0;
 i2 = i1;
 i10 = HEAP8[i4] | 0;
 if (i10 << 24 >> 24 == 0) {
  i20 = i8;
  STACKTOP = i1;
  return i20 | 0;
 }
 i8 = _strchr(i8, i10 << 24 >> 24) | 0;
 if ((i8 | 0) == 0) {
  i20 = 0;
  STACKTOP = i1;
  return i20 | 0;
 }
 i13 = HEAP8[i4 + 1 | 0] | 0;
 if (i13 << 24 >> 24 == 0) {
  i20 = i8;
  STACKTOP = i1;
  return i20 | 0;
 }
 i11 = i8 + 1 | 0;
 i9 = HEAP8[i11] | 0;
 if (i9 << 24 >> 24 == 0) {
  i20 = 0;
  STACKTOP = i1;
  return i20 | 0;
 }
 i15 = HEAP8[i4 + 2 | 0] | 0;
 if (i15 << 24 >> 24 == 0) {
  i2 = i13 & 255 | (i10 & 255) << 8;
  i3 = i9;
  i4 = HEAPU8[i8] << 8 | i9 & 255;
  while (1) {
   i5 = i4 & 65535;
   if ((i5 | 0) == (i2 | 0)) {
    break;
   }
   i11 = i11 + 1 | 0;
   i4 = HEAP8[i11] | 0;
   if (i4 << 24 >> 24 == 0) {
    i3 = 0;
    break;
   } else {
    i3 = i4;
    i4 = i4 & 255 | i5 << 8;
   }
  }
  i20 = i3 << 24 >> 24 == 0 ? 0 : i11 + -1 | 0;
  STACKTOP = i1;
  return i20 | 0;
 }
 i16 = i8 + 2 | 0;
 i11 = HEAP8[i16] | 0;
 if (i11 << 24 >> 24 == 0) {
  i20 = 0;
  STACKTOP = i1;
  return i20 | 0;
 }
 i18 = HEAP8[i4 + 3 | 0] | 0;
 if (i18 << 24 >> 24 == 0) {
  i2 = (i13 & 255) << 16 | (i10 & 255) << 24 | (i15 & 255) << 8;
  i4 = (i11 & 255) << 8 | (i9 & 255) << 16 | HEAPU8[i8] << 24;
  if ((i4 | 0) == (i2 | 0)) {
   i3 = 0;
  } else {
   do {
    i16 = i16 + 1 | 0;
    i3 = HEAP8[i16] | 0;
    i4 = (i3 & 255 | i4) << 8;
    i3 = i3 << 24 >> 24 == 0;
   } while (!(i3 | (i4 | 0) == (i2 | 0)));
  }
  i20 = i3 ? 0 : i16 + -2 | 0;
  STACKTOP = i1;
  return i20 | 0;
 }
 i16 = i8 + 3 | 0;
 i17 = HEAP8[i16] | 0;
 if (i17 << 24 >> 24 == 0) {
  i20 = 0;
  STACKTOP = i1;
  return i20 | 0;
 }
 if ((HEAP8[i4 + 4 | 0] | 0) == 0) {
  i2 = (i13 & 255) << 16 | (i10 & 255) << 24 | (i15 & 255) << 8 | i18 & 255;
  i3 = (i11 & 255) << 8 | (i9 & 255) << 16 | i17 & 255 | HEAPU8[i8] << 24;
  if ((i3 | 0) == (i2 | 0)) {
   i4 = 0;
  } else {
   do {
    i16 = i16 + 1 | 0;
    i4 = HEAP8[i16] | 0;
    i3 = i4 & 255 | i3 << 8;
    i4 = i4 << 24 >> 24 == 0;
   } while (!(i4 | (i3 | 0) == (i2 | 0)));
  }
  i20 = i4 ? 0 : i16 + -3 | 0;
  STACKTOP = i1;
  return i20 | 0;
 }
 HEAP32[i6 + 0 >> 2] = 0;
 HEAP32[i6 + 4 >> 2] = 0;
 HEAP32[i6 + 8 >> 2] = 0;
 HEAP32[i6 + 12 >> 2] = 0;
 HEAP32[i6 + 16 >> 2] = 0;
 HEAP32[i6 + 20 >> 2] = 0;
 HEAP32[i6 + 24 >> 2] = 0;
 HEAP32[i6 + 28 >> 2] = 0;
 i9 = 0;
 while (1) {
  if ((HEAP8[i8 + i9 | 0] | 0) == 0) {
   i14 = 0;
   i12 = 80;
   break;
  }
  i20 = i10 & 255;
  i3 = i6 + (i20 >>> 5 << 2) | 0;
  HEAP32[i3 >> 2] = HEAP32[i3 >> 2] | 1 << (i20 & 31);
  i3 = i9 + 1 | 0;
  HEAP32[i2 + (i20 << 2) >> 2] = i3;
  i10 = HEAP8[i4 + i3 | 0] | 0;
  if (i10 << 24 >> 24 == 0) {
   break;
  } else {
   i9 = i3;
  }
 }
 if ((i12 | 0) == 80) {
  STACKTOP = i1;
  return i14 | 0;
 }
 L49 : do {
  if (i3 >>> 0 > 1) {
   i14 = 1;
   i11 = -1;
   i12 = 0;
   L50 : while (1) {
    i10 = 1;
    while (1) {
     i13 = i14;
     L54 : while (1) {
      i14 = 1;
      while (1) {
       i15 = HEAP8[i4 + (i14 + i11) | 0] | 0;
       i16 = HEAP8[i4 + i13 | 0] | 0;
       if (!(i15 << 24 >> 24 == i16 << 24 >> 24)) {
        break L54;
       }
       i15 = i14 + 1 | 0;
       if ((i14 | 0) == (i10 | 0)) {
        break;
       }
       i13 = i15 + i12 | 0;
       if (i13 >>> 0 < i3 >>> 0) {
        i14 = i15;
       } else {
        break L50;
       }
      }
      i12 = i12 + i10 | 0;
      i13 = i12 + 1 | 0;
      if (!(i13 >>> 0 < i3 >>> 0)) {
       break L50;
      }
     }
     i10 = i13 - i11 | 0;
     if (!((i15 & 255) > (i16 & 255))) {
      break;
     }
     i14 = i13 + 1 | 0;
     if (i14 >>> 0 < i3 >>> 0) {
      i12 = i13;
     } else {
      break L50;
     }
    }
    i14 = i12 + 2 | 0;
    if (i14 >>> 0 < i3 >>> 0) {
     i11 = i12;
     i12 = i12 + 1 | 0;
    } else {
     i11 = i12;
     i10 = 1;
     break;
    }
   }
   i16 = 1;
   i12 = -1;
   i14 = 0;
   while (1) {
    i13 = 1;
    while (1) {
     i15 = i16;
     L69 : while (1) {
      i18 = 1;
      while (1) {
       i17 = HEAP8[i4 + (i18 + i12) | 0] | 0;
       i16 = HEAP8[i4 + i15 | 0] | 0;
       if (!(i17 << 24 >> 24 == i16 << 24 >> 24)) {
        break L69;
       }
       i16 = i18 + 1 | 0;
       if ((i18 | 0) == (i13 | 0)) {
        break;
       }
       i15 = i16 + i14 | 0;
       if (i15 >>> 0 < i3 >>> 0) {
        i18 = i16;
       } else {
        i14 = i12;
        break L49;
       }
      }
      i14 = i14 + i13 | 0;
      i15 = i14 + 1 | 0;
      if (!(i15 >>> 0 < i3 >>> 0)) {
       i14 = i12;
       break L49;
      }
     }
     i13 = i15 - i12 | 0;
     if (!((i17 & 255) < (i16 & 255))) {
      break;
     }
     i16 = i15 + 1 | 0;
     if (i16 >>> 0 < i3 >>> 0) {
      i14 = i15;
     } else {
      i14 = i12;
      break L49;
     }
    }
    i16 = i14 + 2 | 0;
    if (i16 >>> 0 < i3 >>> 0) {
     i12 = i14;
     i14 = i14 + 1 | 0;
    } else {
     i13 = 1;
     break;
    }
   }
  } else {
   i11 = -1;
   i14 = -1;
   i10 = 1;
   i13 = 1;
  }
 } while (0);
 i15 = (i14 + 1 | 0) >>> 0 > (i11 + 1 | 0) >>> 0;
 i12 = i15 ? i13 : i10;
 i11 = i15 ? i14 : i11;
 i10 = i11 + 1 | 0;
 if ((_memcmp(i4, i4 + i12 | 0, i10) | 0) == 0) {
  i15 = i3 - i12 | 0;
  i16 = i3 | 63;
  if ((i3 | 0) != (i12 | 0)) {
   i14 = i8;
   i13 = 0;
   i17 = i8;
   L82 : while (1) {
    i18 = i14;
    do {
     if ((i17 - i18 | 0) >>> 0 < i3 >>> 0) {
      i19 = _memchr(i17, 0, i16) | 0;
      if ((i19 | 0) != 0) {
       if ((i19 - i18 | 0) >>> 0 < i3 >>> 0) {
        i14 = 0;
        i12 = 80;
        break L82;
       } else {
        i17 = i19;
        break;
       }
      } else {
       i17 = i17 + i16 | 0;
       break;
      }
     }
    } while (0);
    i18 = HEAPU8[i14 + i9 | 0] | 0;
    if ((1 << (i18 & 31) & HEAP32[i6 + (i18 >>> 5 << 2) >> 2] | 0) == 0) {
     i14 = i14 + i3 | 0;
     i13 = 0;
     continue;
    }
    i20 = HEAP32[i2 + (i18 << 2) >> 2] | 0;
    i18 = i3 - i20 | 0;
    if ((i3 | 0) != (i20 | 0)) {
     i14 = i14 + ((i13 | 0) != 0 & i18 >>> 0 < i12 >>> 0 ? i15 : i18) | 0;
     i13 = 0;
     continue;
    }
    i20 = i10 >>> 0 > i13 >>> 0 ? i10 : i13;
    i18 = HEAP8[i4 + i20 | 0] | 0;
    L96 : do {
     if (i18 << 24 >> 24 == 0) {
      i19 = i10;
     } else {
      while (1) {
       i19 = i20 + 1 | 0;
       if (!(i18 << 24 >> 24 == (HEAP8[i14 + i20 | 0] | 0))) {
        break;
       }
       i18 = HEAP8[i4 + i19 | 0] | 0;
       if (i18 << 24 >> 24 == 0) {
        i19 = i10;
        break L96;
       } else {
        i20 = i19;
       }
      }
      i14 = i14 + (i20 - i11) | 0;
      i13 = 0;
      continue L82;
     }
    } while (0);
    while (1) {
     if (!(i19 >>> 0 > i13 >>> 0)) {
      break;
     }
     i18 = i19 + -1 | 0;
     if ((HEAP8[i4 + i18 | 0] | 0) == (HEAP8[i14 + i18 | 0] | 0)) {
      i19 = i18;
     } else {
      break;
     }
    }
    if ((i19 | 0) == (i13 | 0)) {
     i12 = 80;
     break;
    }
    i14 = i14 + i12 | 0;
    i13 = i15;
   }
   if ((i12 | 0) == 80) {
    STACKTOP = i1;
    return i14 | 0;
   }
  } else {
   i5 = i16;
   i7 = i3;
  }
 } else {
  i7 = i3 - i11 + -1 | 0;
  i5 = i3 | 63;
  i7 = (i11 >>> 0 > i7 >>> 0 ? i11 : i7) + 1 | 0;
 }
 i12 = i4 + i10 | 0;
 i14 = i8;
 L111 : while (1) {
  i13 = i14;
  do {
   if ((i8 - i13 | 0) >>> 0 < i3 >>> 0) {
    i15 = _memchr(i8, 0, i5) | 0;
    if ((i15 | 0) != 0) {
     if ((i15 - i13 | 0) >>> 0 < i3 >>> 0) {
      i14 = 0;
      i12 = 80;
      break L111;
     } else {
      i8 = i15;
      break;
     }
    } else {
     i8 = i8 + i5 | 0;
     break;
    }
   }
  } while (0);
  i13 = HEAPU8[i14 + i9 | 0] | 0;
  if ((1 << (i13 & 31) & HEAP32[i6 + (i13 >>> 5 << 2) >> 2] | 0) == 0) {
   i14 = i14 + i3 | 0;
   continue;
  }
  i13 = HEAP32[i2 + (i13 << 2) >> 2] | 0;
  if ((i3 | 0) != (i13 | 0)) {
   i14 = i14 + (i3 - i13) | 0;
   continue;
  }
  i15 = HEAP8[i12] | 0;
  L125 : do {
   if (i15 << 24 >> 24 == 0) {
    i13 = i10;
   } else {
    i16 = i10;
    while (1) {
     i13 = i16 + 1 | 0;
     if (!(i15 << 24 >> 24 == (HEAP8[i14 + i16 | 0] | 0))) {
      break;
     }
     i15 = HEAP8[i4 + i13 | 0] | 0;
     if (i15 << 24 >> 24 == 0) {
      i13 = i10;
      break L125;
     } else {
      i16 = i13;
     }
    }
    i14 = i14 + (i16 - i11) | 0;
    continue L111;
   }
  } while (0);
  do {
   if ((i13 | 0) == 0) {
    i12 = 80;
    break L111;
   }
   i13 = i13 + -1 | 0;
  } while ((HEAP8[i4 + i13 | 0] | 0) == (HEAP8[i14 + i13 | 0] | 0));
  i14 = i14 + i7 | 0;
 }
 if ((i12 | 0) == 80) {
  STACKTOP = i1;
  return i14 | 0;
 }
 return 0;
}
function _str_format(i2) {
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, d21 = 0.0, i22 = 0;
 i12 = STACKTOP;
 STACKTOP = STACKTOP + 1104 | 0;
 i4 = i12;
 i7 = i12 + 1060 | 0;
 i9 = i12 + 1082 | 0;
 i20 = i12 + 1056 | 0;
 i10 = i12 + 16 | 0;
 i5 = i12 + 1064 | 0;
 i6 = i12 + 8 | 0;
 i8 = _lua_gettop(i2) | 0;
 i16 = _luaL_checklstring(i2, 1, i20) | 0;
 i20 = HEAP32[i20 >> 2] | 0;
 i3 = i16 + i20 | 0;
 _luaL_buffinit(i2, i10);
 L1 : do {
  if ((i20 | 0) > 0) {
   i1 = i10 + 8 | 0;
   i13 = i10 + 4 | 0;
   i14 = i5 + 1 | 0;
   i19 = 1;
   L3 : while (1) {
    while (1) {
     i15 = HEAP8[i16] | 0;
     if (i15 << 24 >> 24 == 37) {
      i18 = i16 + 1 | 0;
      if ((HEAP8[i18] | 0) != 37) {
       break;
      }
      i15 = HEAP32[i1 >> 2] | 0;
      if (i15 >>> 0 < (HEAP32[i13 >> 2] | 0) >>> 0) {
       i17 = 37;
      } else {
       _luaL_prepbuffsize(i10, 1) | 0;
       i15 = HEAP32[i1 >> 2] | 0;
       i17 = HEAP8[i18] | 0;
      }
      HEAP32[i1 >> 2] = i15 + 1;
      HEAP8[(HEAP32[i10 >> 2] | 0) + i15 | 0] = i17;
      i16 = i16 + 2 | 0;
     } else {
      i17 = HEAP32[i1 >> 2] | 0;
      if (!(i17 >>> 0 < (HEAP32[i13 >> 2] | 0) >>> 0)) {
       _luaL_prepbuffsize(i10, 1) | 0;
       i17 = HEAP32[i1 >> 2] | 0;
       i15 = HEAP8[i16] | 0;
      }
      HEAP32[i1 >> 2] = i17 + 1;
      HEAP8[(HEAP32[i10 >> 2] | 0) + i17 | 0] = i15;
      i16 = i16 + 1 | 0;
     }
     if (!(i16 >>> 0 < i3 >>> 0)) {
      break L1;
     }
    }
    i17 = _luaL_prepbuffsize(i10, 512) | 0;
    i15 = i19 + 1 | 0;
    if ((i19 | 0) >= (i8 | 0)) {
     _luaL_argerror(i2, i15, 7648) | 0;
    }
    i19 = HEAP8[i18] | 0;
    L22 : do {
     if (i19 << 24 >> 24 == 0) {
      i19 = 0;
      i20 = i18;
     } else {
      i20 = i18;
      while (1) {
       i16 = i20 + 1 | 0;
       if ((_memchr(7800, i19 << 24 >> 24, 6) | 0) == 0) {
        break L22;
       }
       i19 = HEAP8[i16] | 0;
       if (i19 << 24 >> 24 == 0) {
        i19 = 0;
        i20 = i16;
        break;
       } else {
        i20 = i16;
       }
      }
     }
    } while (0);
    i16 = i18;
    if ((i20 - i16 | 0) >>> 0 > 5) {
     _luaL_error(i2, 7808, i4) | 0;
     i19 = HEAP8[i20] | 0;
    }
    i19 = ((i19 & 255) + -48 | 0) >>> 0 < 10 ? i20 + 1 | 0 : i20;
    i19 = ((HEAPU8[i19] | 0) + -48 | 0) >>> 0 < 10 ? i19 + 1 | 0 : i19;
    i20 = HEAP8[i19] | 0;
    if (i20 << 24 >> 24 == 46) {
     i20 = i19 + 1 | 0;
     i19 = ((HEAPU8[i20] | 0) + -48 | 0) >>> 0 < 10 ? i19 + 2 | 0 : i20;
     i19 = ((HEAPU8[i19] | 0) + -48 | 0) >>> 0 < 10 ? i19 + 1 | 0 : i19;
     i20 = HEAP8[i19] | 0;
    }
    if (((i20 & 255) + -48 | 0) >>> 0 < 10) {
     _luaL_error(i2, 7840, i4) | 0;
    }
    HEAP8[i5] = 37;
    i16 = i19 - i16 | 0;
    _memcpy(i14 | 0, i18 | 0, i16 + 1 | 0) | 0;
    HEAP8[i5 + (i16 + 2) | 0] = 0;
    i16 = i19 + 1 | 0;
    i18 = HEAP8[i19] | 0;
    L36 : do {
     switch (i18 | 0) {
     case 115:
      {
       i18 = _luaL_tolstring(i2, i15, i6) | 0;
       if ((_strchr(i5, 46) | 0) == 0 ? (HEAP32[i6 >> 2] | 0) >>> 0 > 99 : 0) {
        _luaL_addvalue(i10);
        i17 = 0;
        break L36;
       }
       HEAP32[i4 >> 2] = i18;
       i17 = _sprintf(i17 | 0, i5 | 0, i4 | 0) | 0;
       _lua_settop(i2, -2);
       break;
      }
     case 88:
     case 120:
     case 117:
     case 111:
      {
       d21 = +_luaL_checknumber(i2, i15);
       i18 = ~~d21 >>> 0;
       d21 = d21 - +(i18 >>> 0);
       if (!(d21 > -1.0 & d21 < 1.0)) {
        _luaL_argerror(i2, i15, 7696) | 0;
       }
       i20 = _strlen(i5 | 0) | 0;
       i22 = i5 + (i20 + -1) | 0;
       i19 = HEAP8[i22] | 0;
       HEAP8[i22] = 108;
       HEAP8[i22 + 1 | 0] = 0;
       HEAP8[i5 + i20 | 0] = i19;
       HEAP8[i5 + (i20 + 1) | 0] = 0;
       HEAP32[i4 >> 2] = i18;
       i17 = _sprintf(i17 | 0, i5 | 0, i4 | 0) | 0;
       break;
      }
     case 99:
      {
       HEAP32[i4 >> 2] = _luaL_checkinteger(i2, i15) | 0;
       i17 = _sprintf(i17 | 0, i5 | 0, i4 | 0) | 0;
       break;
      }
     case 113:
      {
       i17 = _luaL_checklstring(i2, i15, i7) | 0;
       i18 = HEAP32[i1 >> 2] | 0;
       if (!(i18 >>> 0 < (HEAP32[i13 >> 2] | 0) >>> 0)) {
        _luaL_prepbuffsize(i10, 1) | 0;
        i18 = HEAP32[i1 >> 2] | 0;
       }
       HEAP32[i1 >> 2] = i18 + 1;
       HEAP8[(HEAP32[i10 >> 2] | 0) + i18 | 0] = 34;
       i22 = HEAP32[i7 >> 2] | 0;
       HEAP32[i7 >> 2] = i22 + -1;
       if ((i22 | 0) != 0) {
        while (1) {
         i18 = HEAP8[i17] | 0;
         do {
          if (i18 << 24 >> 24 == 10 | i18 << 24 >> 24 == 92 | i18 << 24 >> 24 == 34) {
           i18 = HEAP32[i1 >> 2] | 0;
           if (!(i18 >>> 0 < (HEAP32[i13 >> 2] | 0) >>> 0)) {
            _luaL_prepbuffsize(i10, 1) | 0;
            i18 = HEAP32[i1 >> 2] | 0;
           }
           HEAP32[i1 >> 2] = i18 + 1;
           HEAP8[(HEAP32[i10 >> 2] | 0) + i18 | 0] = 92;
           i18 = HEAP32[i1 >> 2] | 0;
           if (!(i18 >>> 0 < (HEAP32[i13 >> 2] | 0) >>> 0)) {
            _luaL_prepbuffsize(i10, 1) | 0;
            i18 = HEAP32[i1 >> 2] | 0;
           }
           i22 = HEAP8[i17] | 0;
           HEAP32[i1 >> 2] = i18 + 1;
           HEAP8[(HEAP32[i10 >> 2] | 0) + i18 | 0] = i22;
          } else if (i18 << 24 >> 24 == 0) {
           i18 = 0;
           i11 = 44;
          } else {
           if ((_iscntrl(i18 & 255 | 0) | 0) != 0) {
            i18 = HEAP8[i17] | 0;
            i11 = 44;
            break;
           }
           i18 = HEAP32[i1 >> 2] | 0;
           if (!(i18 >>> 0 < (HEAP32[i13 >> 2] | 0) >>> 0)) {
            _luaL_prepbuffsize(i10, 1) | 0;
            i18 = HEAP32[i1 >> 2] | 0;
           }
           i22 = HEAP8[i17] | 0;
           HEAP32[i1 >> 2] = i18 + 1;
           HEAP8[(HEAP32[i10 >> 2] | 0) + i18 | 0] = i22;
          }
         } while (0);
         if ((i11 | 0) == 44) {
          i11 = 0;
          i18 = i18 & 255;
          if (((HEAPU8[i17 + 1 | 0] | 0) + -48 | 0) >>> 0 < 10) {
           HEAP32[i4 >> 2] = i18;
           _sprintf(i9 | 0, 7792, i4 | 0) | 0;
          } else {
           HEAP32[i4 >> 2] = i18;
           _sprintf(i9 | 0, 7784, i4 | 0) | 0;
          }
          _luaL_addstring(i10, i9);
         }
         i22 = HEAP32[i7 >> 2] | 0;
         HEAP32[i7 >> 2] = i22 + -1;
         if ((i22 | 0) == 0) {
          break;
         } else {
          i17 = i17 + 1 | 0;
         }
        }
       }
       i17 = HEAP32[i1 >> 2] | 0;
       if (!(i17 >>> 0 < (HEAP32[i13 >> 2] | 0) >>> 0)) {
        _luaL_prepbuffsize(i10, 1) | 0;
        i17 = HEAP32[i1 >> 2] | 0;
       }
       HEAP32[i1 >> 2] = i17 + 1;
       HEAP8[(HEAP32[i10 >> 2] | 0) + i17 | 0] = 34;
       i17 = 0;
       break;
      }
     case 71:
     case 103:
     case 102:
     case 69:
     case 101:
      {
       HEAP8[i5 + (_strlen(i5 | 0) | 0) | 0] = 0;
       d21 = +_luaL_checknumber(i2, i15);
       HEAPF64[tempDoublePtr >> 3] = d21;
       HEAP32[i4 >> 2] = HEAP32[tempDoublePtr >> 2];
       HEAP32[i4 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
       i17 = _sprintf(i17 | 0, i5 | 0, i4 | 0) | 0;
       break;
      }
     case 105:
     case 100:
      {
       d21 = +_luaL_checknumber(i2, i15);
       i18 = ~~d21;
       d21 = d21 - +(i18 | 0);
       if (!(d21 > -1.0 & d21 < 1.0)) {
        _luaL_argerror(i2, i15, 7664) | 0;
       }
       i22 = _strlen(i5 | 0) | 0;
       i19 = i5 + (i22 + -1) | 0;
       i20 = HEAP8[i19] | 0;
       HEAP8[i19] = 108;
       HEAP8[i19 + 1 | 0] = 0;
       HEAP8[i5 + i22 | 0] = i20;
       HEAP8[i5 + (i22 + 1) | 0] = 0;
       HEAP32[i4 >> 2] = i18;
       i17 = _sprintf(i17 | 0, i5 | 0, i4 | 0) | 0;
       break;
      }
     default:
      {
       break L3;
      }
     }
    } while (0);
    HEAP32[i1 >> 2] = (HEAP32[i1 >> 2] | 0) + i17;
    if (i16 >>> 0 < i3 >>> 0) {
     i19 = i15;
    } else {
     break L1;
    }
   }
   HEAP32[i4 >> 2] = i18;
   i22 = _luaL_error(i2, 7744, i4) | 0;
   STACKTOP = i12;
   return i22 | 0;
  }
 } while (0);
 _luaL_pushresult(i10);
 i22 = 1;
 STACKTOP = i12;
 return i22 | 0;
}
function _luaD_precall(i3, i17, i4) {
 i3 = i3 | 0;
 i17 = i17 | 0;
 i4 = i4 | 0;
 var i1 = 0, i2 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i8 = i1;
 i6 = i3 + 28 | 0;
 i2 = i3 + 8 | 0;
 i13 = i3 + 24 | 0;
 i14 = i3 + 32 | 0;
 while (1) {
  i15 = HEAP32[i6 >> 2] | 0;
  i16 = i17;
  i12 = i15;
  i5 = i16 - i12 | 0;
  i11 = HEAP32[i17 + 8 >> 2] & 63;
  if ((i11 | 0) == 38) {
   i11 = 4;
   break;
  } else if ((i11 | 0) == 22) {
   i11 = 3;
   break;
  } else if ((i11 | 0) == 6) {
   i11 = 31;
   break;
  }
  i11 = _luaT_gettmbyobj(i3, i17, 16) | 0;
  i15 = i16 - (HEAP32[i6 >> 2] | 0) | 0;
  i16 = i11 + 8 | 0;
  if ((HEAP32[i16 >> 2] & 15 | 0) != 6) {
   i11 = 54;
   break;
  }
  i19 = HEAP32[i2 >> 2] | 0;
  if (i19 >>> 0 > i17 >>> 0) {
   while (1) {
    i18 = i19 + -16 | 0;
    i22 = i18;
    i21 = HEAP32[i22 + 4 >> 2] | 0;
    i20 = i19;
    HEAP32[i20 >> 2] = HEAP32[i22 >> 2];
    HEAP32[i20 + 4 >> 2] = i21;
    HEAP32[i19 + 8 >> 2] = HEAP32[i19 + -8 >> 2];
    if (i18 >>> 0 > i17 >>> 0) {
     i19 = i18;
    } else {
     break;
    }
   }
   i19 = HEAP32[i2 >> 2] | 0;
  }
  i17 = i19 + 16 | 0;
  HEAP32[i2 >> 2] = i17;
  if (((HEAP32[i13 >> 2] | 0) - i17 | 0) < 16) {
   i18 = HEAP32[i14 >> 2] | 0;
   if ((i18 | 0) > 1e6) {
    i11 = 60;
    break;
   }
   i17 = (i17 - (HEAP32[i6 >> 2] | 0) >> 4) + 5 | 0;
   i18 = i18 << 1;
   i18 = (i18 | 0) > 1e6 ? 1e6 : i18;
   i17 = (i18 | 0) < (i17 | 0) ? i17 : i18;
   if ((i17 | 0) > 1e6) {
    i11 = 62;
    break;
   }
   _luaD_reallocstack(i3, i17);
  }
  i22 = HEAP32[i6 >> 2] | 0;
  i17 = i22 + i15 | 0;
  i19 = i11;
  i20 = HEAP32[i19 + 4 >> 2] | 0;
  i21 = i17;
  HEAP32[i21 >> 2] = HEAP32[i19 >> 2];
  HEAP32[i21 + 4 >> 2] = i20;
  HEAP32[i22 + (i15 + 8) >> 2] = HEAP32[i16 >> 2];
 }
 if ((i11 | 0) == 3) {
  i10 = i17;
 } else if ((i11 | 0) == 4) {
  i10 = (HEAP32[i17 >> 2] | 0) + 12 | 0;
 } else if ((i11 | 0) == 31) {
  i10 = HEAP32[(HEAP32[i17 >> 2] | 0) + 12 >> 2] | 0;
  i18 = HEAP32[i2 >> 2] | 0;
  i16 = i18;
  i11 = i10 + 78 | 0;
  i17 = HEAPU8[i11] | 0;
  do {
   if (((HEAP32[i13 >> 2] | 0) - i16 >> 4 | 0) <= (i17 | 0)) {
    i13 = HEAP32[i14 >> 2] | 0;
    if ((i13 | 0) > 1e6) {
     _luaD_throw(i3, 6);
    }
    i12 = i17 + 5 + (i16 - i12 >> 4) | 0;
    i13 = i13 << 1;
    i13 = (i13 | 0) > 1e6 ? 1e6 : i13;
    i12 = (i13 | 0) < (i12 | 0) ? i12 : i13;
    if ((i12 | 0) > 1e6) {
     _luaD_reallocstack(i3, 1000200);
     _luaG_runerror(i3, 2224, i8);
    } else {
     _luaD_reallocstack(i3, i12);
     i7 = HEAP32[i6 >> 2] | 0;
     i9 = HEAP32[i2 >> 2] | 0;
     break;
    }
   } else {
    i7 = i15;
    i9 = i18;
   }
  } while (0);
  i6 = i7 + i5 | 0;
  i22 = i9 - i6 >> 4;
  i12 = i22 + -1 | 0;
  i8 = i10 + 76 | 0;
  i13 = HEAP8[i8] | 0;
  if ((i22 | 0) > (i13 & 255 | 0)) {
   i8 = i13;
  } else {
   i13 = i9;
   while (1) {
    i9 = i13 + 16 | 0;
    HEAP32[i2 >> 2] = i9;
    HEAP32[i13 + 8 >> 2] = 0;
    i12 = i12 + 1 | 0;
    i13 = HEAP8[i8] | 0;
    if ((i12 | 0) < (i13 & 255 | 0)) {
     i13 = i9;
    } else {
     i8 = i13;
     break;
    }
   }
  }
  if ((HEAP8[i10 + 77 | 0] | 0) != 0) {
   i5 = i8 & 255;
   if (!(i8 << 24 >> 24 == 0) ? (i22 = 0 - i12 | 0, HEAP32[i2 >> 2] = i9 + 16, i19 = i9 + (i22 << 4) | 0, i20 = HEAP32[i19 + 4 >> 2] | 0, i21 = i9, HEAP32[i21 >> 2] = HEAP32[i19 >> 2], HEAP32[i21 + 4 >> 2] = i20, i22 = i9 + (i22 << 4) + 8 | 0, HEAP32[i9 + 8 >> 2] = HEAP32[i22 >> 2], HEAP32[i22 >> 2] = 0, (i8 & 255) > 1) : 0) {
    i7 = 1;
    do {
     i21 = HEAP32[i2 >> 2] | 0;
     i22 = i7 - i12 | 0;
     HEAP32[i2 >> 2] = i21 + 16;
     i18 = i9 + (i22 << 4) | 0;
     i19 = HEAP32[i18 + 4 >> 2] | 0;
     i20 = i21;
     HEAP32[i20 >> 2] = HEAP32[i18 >> 2];
     HEAP32[i20 + 4 >> 2] = i19;
     i22 = i9 + (i22 << 4) + 8 | 0;
     HEAP32[i21 + 8 >> 2] = HEAP32[i22 >> 2];
     HEAP32[i22 >> 2] = 0;
     i7 = i7 + 1 | 0;
    } while ((i7 | 0) < (i5 | 0));
   }
  } else {
   i9 = i7 + (i5 + 16) | 0;
  }
  i7 = i3 + 16 | 0;
  i5 = HEAP32[(HEAP32[i7 >> 2] | 0) + 12 >> 2] | 0;
  if ((i5 | 0) == 0) {
   i5 = _luaE_extendCI(i3) | 0;
  }
  HEAP32[i7 >> 2] = i5;
  HEAP16[i5 + 16 >> 1] = i4;
  HEAP32[i5 >> 2] = i6;
  HEAP32[i5 + 24 >> 2] = i9;
  i22 = i9 + (HEAPU8[i11] << 4) | 0;
  HEAP32[i5 + 4 >> 2] = i22;
  i4 = i5 + 28 | 0;
  HEAP32[i4 >> 2] = HEAP32[i10 + 12 >> 2];
  i6 = i5 + 18 | 0;
  HEAP8[i6] = 1;
  HEAP32[i2 >> 2] = i22;
  if ((HEAP32[(HEAP32[i3 + 12 >> 2] | 0) + 12 >> 2] | 0) > 0) {
   _luaC_step(i3);
  }
  if ((HEAP8[i3 + 40 | 0] & 1) == 0) {
   i22 = 0;
   STACKTOP = i1;
   return i22 | 0;
  }
  HEAP32[i4 >> 2] = (HEAP32[i4 >> 2] | 0) + 4;
  i2 = HEAP32[i5 + 8 >> 2] | 0;
  if (!((HEAP8[i2 + 18 | 0] & 1) == 0) ? (HEAP32[(HEAP32[i2 + 28 >> 2] | 0) + -4 >> 2] & 63 | 0) == 30 : 0) {
   HEAP8[i6] = HEAPU8[i6] | 64;
   i2 = 4;
  } else {
   i2 = 0;
  }
  _luaD_hook(i3, i2, -1);
  HEAP32[i4 >> 2] = (HEAP32[i4 >> 2] | 0) + -4;
  i22 = 0;
  STACKTOP = i1;
  return i22 | 0;
 } else if ((i11 | 0) == 54) {
  _luaG_typeerror(i3, i17, 2520);
 } else if ((i11 | 0) == 60) {
  _luaD_throw(i3, 6);
 } else if ((i11 | 0) == 62) {
  _luaD_reallocstack(i3, 1000200);
  _luaG_runerror(i3, 2224, i8);
 }
 i7 = HEAP32[i10 >> 2] | 0;
 i9 = HEAP32[i2 >> 2] | 0;
 do {
  if (((HEAP32[i13 >> 2] | 0) - i9 | 0) < 336) {
   i10 = HEAP32[i14 >> 2] | 0;
   if ((i10 | 0) > 1e6) {
    _luaD_throw(i3, 6);
   }
   i9 = (i9 - i12 >> 4) + 25 | 0;
   i10 = i10 << 1;
   i10 = (i10 | 0) > 1e6 ? 1e6 : i10;
   i9 = (i10 | 0) < (i9 | 0) ? i9 : i10;
   if ((i9 | 0) > 1e6) {
    _luaD_reallocstack(i3, 1000200);
    _luaG_runerror(i3, 2224, i8);
   } else {
    _luaD_reallocstack(i3, i9);
    break;
   }
  }
 } while (0);
 i8 = i3 + 16 | 0;
 i9 = HEAP32[(HEAP32[i8 >> 2] | 0) + 12 >> 2] | 0;
 if ((i9 | 0) == 0) {
  i9 = _luaE_extendCI(i3) | 0;
 }
 HEAP32[i8 >> 2] = i9;
 HEAP16[i9 + 16 >> 1] = i4;
 HEAP32[i9 >> 2] = (HEAP32[i6 >> 2] | 0) + i5;
 HEAP32[i9 + 4 >> 2] = (HEAP32[i2 >> 2] | 0) + 320;
 HEAP8[i9 + 18 | 0] = 0;
 if ((HEAP32[(HEAP32[i3 + 12 >> 2] | 0) + 12 >> 2] | 0) > 0) {
  _luaC_step(i3);
 }
 i5 = i3 + 40 | 0;
 if (!((HEAP8[i5] & 1) == 0)) {
  _luaD_hook(i3, 0, -1);
 }
 i7 = FUNCTION_TABLE_ii[i7 & 255](i3) | 0;
 i7 = (HEAP32[i2 >> 2] | 0) + (0 - i7 << 4) | 0;
 i4 = HEAP32[i8 >> 2] | 0;
 i5 = HEAPU8[i5] | 0;
 if ((i5 & 6 | 0) == 0) {
  i5 = i7;
  i6 = i4 + 8 | 0;
 } else {
  if ((i5 & 2 | 0) == 0) {
   i5 = i7;
  } else {
   i5 = i7 - (HEAP32[i6 >> 2] | 0) | 0;
   _luaD_hook(i3, 1, -1);
   i5 = (HEAP32[i6 >> 2] | 0) + i5 | 0;
  }
  i6 = i4 + 8 | 0;
  HEAP32[i3 + 20 >> 2] = HEAP32[(HEAP32[i6 >> 2] | 0) + 28 >> 2];
 }
 i3 = HEAP32[i4 >> 2] | 0;
 i4 = HEAP16[i4 + 16 >> 1] | 0;
 HEAP32[i8 >> 2] = HEAP32[i6 >> 2];
 L82 : do {
  if (!(i4 << 16 >> 16 == 0)) {
   i4 = i4 << 16 >> 16;
   while (1) {
    if (!(i5 >>> 0 < (HEAP32[i2 >> 2] | 0) >>> 0)) {
     break;
    }
    i6 = i3 + 16 | 0;
    i20 = i5;
    i21 = HEAP32[i20 + 4 >> 2] | 0;
    i22 = i3;
    HEAP32[i22 >> 2] = HEAP32[i20 >> 2];
    HEAP32[i22 + 4 >> 2] = i21;
    HEAP32[i3 + 8 >> 2] = HEAP32[i5 + 8 >> 2];
    i4 = i4 + -1 | 0;
    if ((i4 | 0) == 0) {
     i3 = i6;
     break L82;
    }
    i5 = i5 + 16 | 0;
    i3 = i6;
   }
   if ((i4 | 0) > 0) {
    i5 = i4;
    i6 = i3;
    while (1) {
     i5 = i5 + -1 | 0;
     HEAP32[i6 + 8 >> 2] = 0;
     if ((i5 | 0) <= 0) {
      break;
     } else {
      i6 = i6 + 16 | 0;
     }
    }
    i3 = i3 + (i4 << 4) | 0;
   }
  }
 } while (0);
 HEAP32[i2 >> 2] = i3;
 i22 = 1;
 STACKTOP = i1;
 return i22 | 0;
}
function _lua_getinfo(i1, i6, i29) {
 i1 = i1 | 0;
 i6 = i6 | 0;
 i29 = i29 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0, i30 = 0, i31 = 0, i32 = 0, i33 = 0, i34 = 0, i35 = 0, i36 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i2 = i3;
 if ((HEAP8[i6] | 0) == 62) {
  i10 = i1 + 8 | 0;
  i7 = (HEAP32[i10 >> 2] | 0) + -16 | 0;
  HEAP32[i10 >> 2] = i7;
  i6 = i6 + 1 | 0;
  i10 = 0;
 } else {
  i7 = HEAP32[i29 + 96 >> 2] | 0;
  i10 = i7;
  i7 = HEAP32[i7 >> 2] | 0;
 }
 i8 = i7 + 8 | 0;
 if ((HEAP32[i8 >> 2] & 31 | 0) == 6) {
  i9 = HEAP32[i7 >> 2] | 0;
 } else {
  i9 = 0;
 }
 i34 = HEAP8[i6] | 0;
 L8 : do {
  if (i34 << 24 >> 24 == 0) {
   i33 = 1;
  } else {
   i12 = (i9 | 0) == 0;
   i27 = i29 + 16 | 0;
   i28 = i29 + 24 | 0;
   i21 = i29 + 28 | 0;
   i25 = i29 + 12 | 0;
   i26 = i29 + 36 | 0;
   i19 = i9 + 4 | 0;
   i24 = i9 + 12 | 0;
   i18 = (i10 | 0) == 0;
   i23 = i29 + 20 | 0;
   i17 = i10 + 18 | 0;
   i22 = i10 + 28 | 0;
   i15 = i29 + 32 | 0;
   i14 = i29 + 34 | 0;
   i13 = i29 + 33 | 0;
   i11 = i9 + 6 | 0;
   i16 = i29 + 35 | 0;
   i20 = i29 + 8 | 0;
   i30 = i29 + 4 | 0;
   i29 = i10 + 8 | 0;
   i31 = i1 + 12 | 0;
   i32 = i6;
   i33 = 1;
   while (1) {
    L12 : do {
     switch (i34 << 24 >> 24 | 0) {
     case 116:
      {
       if (i18) {
        i34 = 0;
       } else {
        i34 = HEAPU8[i17] & 64;
       }
       HEAP8[i16] = i34;
       break;
      }
     case 110:
      {
       L18 : do {
        if ((!i18 ? (HEAP8[i17] & 64) == 0 : 0) ? (i5 = HEAP32[i29 >> 2] | 0, !((HEAP8[i5 + 18 | 0] & 1) == 0)) : 0) {
         i36 = HEAP32[(HEAP32[HEAP32[i5 >> 2] >> 2] | 0) + 12 >> 2] | 0;
         i35 = HEAP32[i36 + 12 >> 2] | 0;
         i34 = ((HEAP32[i5 + 28 >> 2] | 0) - i35 >> 2) + -1 | 0;
         i35 = HEAP32[i35 + (i34 << 2) >> 2] | 0;
         switch (i35 & 63 | 0) {
         case 10:
         case 8:
          {
           i34 = 1;
           i4 = 46;
           break;
          }
         case 24:
          {
           i34 = 5;
           i4 = 46;
           break;
          }
         case 13:
          {
           i34 = 6;
           i4 = 46;
           break;
          }
         case 14:
          {
           i34 = 7;
           i4 = 46;
           break;
          }
         case 15:
          {
           i34 = 8;
           i4 = 46;
           break;
          }
         case 16:
          {
           i34 = 9;
           i4 = 46;
           break;
          }
         case 17:
          {
           i34 = 10;
           i4 = 46;
           break;
          }
         case 18:
          {
           i34 = 11;
           i4 = 46;
           break;
          }
         case 19:
          {
           i34 = 12;
           i4 = 46;
           break;
          }
         case 21:
          {
           i34 = 4;
           i4 = 46;
           break;
          }
         case 25:
          {
           i34 = 13;
           i4 = 46;
           break;
          }
         case 26:
          {
           i34 = 14;
           i4 = 46;
           break;
          }
         case 22:
          {
           i34 = 15;
           i4 = 46;
           break;
          }
         case 7:
         case 6:
         case 12:
          {
           i34 = 0;
           i4 = 46;
           break;
          }
         case 34:
          {
           i34 = 2120;
           i35 = 2120;
           break;
          }
         case 30:
         case 29:
          {
           i36 = _getobjname(i36, i34, i35 >>> 6 & 255, i30) | 0;
           HEAP32[i20 >> 2] = i36;
           if ((i36 | 0) == 0) {
            break L18;
           } else {
            break L12;
           }
          }
         default:
          {
           i4 = 47;
           break L18;
          }
         }
         if ((i4 | 0) == 46) {
          i4 = 0;
          i34 = (HEAP32[(HEAP32[i31 >> 2] | 0) + (i34 << 2) + 184 >> 2] | 0) + 16 | 0;
          i35 = 2136;
         }
         HEAP32[i30 >> 2] = i34;
         HEAP32[i20 >> 2] = i35;
         break L12;
        } else {
         i4 = 47;
        }
       } while (0);
       if ((i4 | 0) == 47) {
        i4 = 0;
        HEAP32[i20 >> 2] = 0;
       }
       HEAP32[i20 >> 2] = 2112;
       HEAP32[i30 >> 2] = 0;
       break;
      }
     case 108:
      {
       if (!i18 ? !((HEAP8[i17] & 1) == 0) : 0) {
        i35 = HEAP32[(HEAP32[HEAP32[i10 >> 2] >> 2] | 0) + 12 >> 2] | 0;
        i34 = HEAP32[i35 + 20 >> 2] | 0;
        if ((i34 | 0) == 0) {
         i34 = 0;
        } else {
         i34 = HEAP32[i34 + (((HEAP32[i22 >> 2] | 0) - (HEAP32[i35 + 12 >> 2] | 0) >> 2) + -1 << 2) >> 2] | 0;
        }
       } else {
        i34 = -1;
       }
       HEAP32[i23 >> 2] = i34;
       break;
      }
     case 83:
      {
       if (!i12 ? (HEAP8[i19] | 0) != 38 : 0) {
        i34 = HEAP32[i24 >> 2] | 0;
        i35 = HEAP32[i34 + 36 >> 2] | 0;
        if ((i35 | 0) == 0) {
         i35 = 2168;
        } else {
         i35 = i35 + 16 | 0;
        }
        HEAP32[i27 >> 2] = i35;
        i36 = HEAP32[i34 + 64 >> 2] | 0;
        HEAP32[i28 >> 2] = i36;
        HEAP32[i21 >> 2] = HEAP32[i34 + 68 >> 2];
        i34 = (i36 | 0) == 0 ? 2176 : 2184;
       } else {
        HEAP32[i27 >> 2] = 2152;
        HEAP32[i28 >> 2] = -1;
        HEAP32[i21 >> 2] = -1;
        i35 = 2152;
        i34 = 2160;
       }
       HEAP32[i25 >> 2] = i34;
       _luaO_chunkid(i26, i35, 60);
       break;
      }
     case 117:
      {
       if (!i12) {
        HEAP8[i15] = HEAP8[i11] | 0;
        if ((HEAP8[i19] | 0) != 38) {
         HEAP8[i14] = HEAP8[(HEAP32[i24 >> 2] | 0) + 77 | 0] | 0;
         HEAP8[i13] = HEAP8[(HEAP32[i24 >> 2] | 0) + 76 | 0] | 0;
         break L12;
        }
       } else {
        HEAP8[i15] = 0;
       }
       HEAP8[i14] = 1;
       HEAP8[i13] = 0;
       break;
      }
     case 102:
     case 76:
      {
       break;
      }
     default:
      {
       i33 = 0;
      }
     }
    } while (0);
    i32 = i32 + 1 | 0;
    i34 = HEAP8[i32] | 0;
    if (i34 << 24 >> 24 == 0) {
     break L8;
    }
   }
  }
 } while (0);
 if ((_strchr(i6, 102) | 0) != 0) {
  i36 = i1 + 8 | 0;
  i35 = HEAP32[i36 >> 2] | 0;
  i31 = i7;
  i32 = HEAP32[i31 + 4 >> 2] | 0;
  i34 = i35;
  HEAP32[i34 >> 2] = HEAP32[i31 >> 2];
  HEAP32[i34 + 4 >> 2] = i32;
  HEAP32[i35 + 8 >> 2] = HEAP32[i8 >> 2];
  HEAP32[i36 >> 2] = (HEAP32[i36 >> 2] | 0) + 16;
 }
 if ((_strchr(i6, 76) | 0) == 0) {
  STACKTOP = i3;
  return i33 | 0;
 }
 if ((i9 | 0) != 0 ? (HEAP8[i9 + 4 | 0] | 0) != 38 : 0) {
  i6 = i9 + 12 | 0;
  i5 = HEAP32[(HEAP32[i6 >> 2] | 0) + 20 >> 2] | 0;
  i4 = _luaH_new(i1) | 0;
  i36 = i1 + 8 | 0;
  i35 = HEAP32[i36 >> 2] | 0;
  HEAP32[i35 >> 2] = i4;
  HEAP32[i35 + 8 >> 2] = 69;
  HEAP32[i36 >> 2] = (HEAP32[i36 >> 2] | 0) + 16;
  HEAP32[i2 >> 2] = 1;
  HEAP32[i2 + 8 >> 2] = 1;
  if ((HEAP32[(HEAP32[i6 >> 2] | 0) + 52 >> 2] | 0) > 0) {
   i7 = 0;
  } else {
   STACKTOP = i3;
   return i33 | 0;
  }
  do {
   _luaH_setint(i1, i4, HEAP32[i5 + (i7 << 2) >> 2] | 0, i2);
   i7 = i7 + 1 | 0;
  } while ((i7 | 0) < (HEAP32[(HEAP32[i6 >> 2] | 0) + 52 >> 2] | 0));
  STACKTOP = i3;
  return i33 | 0;
 }
 i36 = i1 + 8 | 0;
 i35 = HEAP32[i36 >> 2] | 0;
 HEAP32[i35 + 8 >> 2] = 0;
 HEAP32[i36 >> 2] = i35 + 16;
 STACKTOP = i3;
 return i33 | 0;
}
function _read_long_string(i3, i1, i5) {
 i3 = i3 | 0;
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0;
 i2 = STACKTOP;
 i14 = HEAP32[i3 >> 2] | 0;
 i4 = i3 + 60 | 0;
 i13 = HEAP32[i4 >> 2] | 0;
 i15 = i13 + 4 | 0;
 i16 = HEAP32[i15 >> 2] | 0;
 i10 = i13 + 8 | 0;
 i12 = HEAP32[i10 >> 2] | 0;
 do {
  if ((i16 + 1 | 0) >>> 0 > i12 >>> 0) {
   if (i12 >>> 0 > 2147483645) {
    _lexerror(i3, 12368, 0);
   }
   i16 = i12 << 1;
   i17 = HEAP32[i3 + 52 >> 2] | 0;
   if ((i16 | 0) == -2) {
    _luaM_toobig(i17);
   } else {
    i8 = _luaM_realloc_(i17, HEAP32[i13 >> 2] | 0, i12, i16) | 0;
    HEAP32[i13 >> 2] = i8;
    HEAP32[i10 >> 2] = i16;
    i9 = HEAP32[i15 >> 2] | 0;
    break;
   }
  } else {
   i9 = i16;
   i8 = HEAP32[i13 >> 2] | 0;
  }
 } while (0);
 HEAP32[i15 >> 2] = i9 + 1;
 HEAP8[i8 + i9 | 0] = i14;
 i9 = i3 + 56 | 0;
 i8 = HEAP32[i9 >> 2] | 0;
 i18 = HEAP32[i8 >> 2] | 0;
 HEAP32[i8 >> 2] = i18 + -1;
 if ((i18 | 0) == 0) {
  i12 = _luaZ_fill(i8) | 0;
 } else {
  i18 = i8 + 4 | 0;
  i12 = HEAP32[i18 >> 2] | 0;
  HEAP32[i18 >> 2] = i12 + 1;
  i12 = HEAPU8[i12] | 0;
 }
 HEAP32[i3 >> 2] = i12;
 if ((i12 | 0) == 13 | (i12 | 0) == 10) {
  _inclinenumber(i3);
  i11 = 13;
 }
 L17 : while (1) {
  if ((i11 | 0) == 13) {
   i11 = 0;
   i12 = HEAP32[i3 >> 2] | 0;
  }
  i8 = (i1 | 0) == 0;
  i10 = i3 + 52 | 0;
  L21 : do {
   if (i8) {
    while (1) {
     if ((i12 | 0) == 13 | (i12 | 0) == 10) {
      break L21;
     } else if ((i12 | 0) == 93) {
      i11 = 22;
      break L21;
     } else if ((i12 | 0) == -1) {
      i11 = 21;
      break L17;
     }
     i12 = HEAP32[i9 >> 2] | 0;
     i18 = HEAP32[i12 >> 2] | 0;
     HEAP32[i12 >> 2] = i18 + -1;
     if ((i18 | 0) == 0) {
      i12 = _luaZ_fill(i12) | 0;
     } else {
      i18 = i12 + 4 | 0;
      i12 = HEAP32[i18 >> 2] | 0;
      HEAP32[i18 >> 2] = i12 + 1;
      i12 = HEAPU8[i12] | 0;
     }
     HEAP32[i3 >> 2] = i12;
    }
   } else {
    while (1) {
     if ((i12 | 0) == 13 | (i12 | 0) == 10) {
      break L21;
     } else if ((i12 | 0) == 93) {
      i11 = 22;
      break L21;
     } else if ((i12 | 0) == -1) {
      i11 = 21;
      break L17;
     }
     i14 = HEAP32[i4 >> 2] | 0;
     i13 = i14 + 4 | 0;
     i17 = HEAP32[i13 >> 2] | 0;
     i16 = i14 + 8 | 0;
     i15 = HEAP32[i16 >> 2] | 0;
     if ((i17 + 1 | 0) >>> 0 > i15 >>> 0) {
      if (i15 >>> 0 > 2147483645) {
       i11 = 46;
       break L17;
      }
      i17 = i15 << 1;
      i18 = HEAP32[i10 >> 2] | 0;
      if ((i17 | 0) == -2) {
       i11 = 48;
       break L17;
      }
      i18 = _luaM_realloc_(i18, HEAP32[i14 >> 2] | 0, i15, i17) | 0;
      HEAP32[i14 >> 2] = i18;
      HEAP32[i16 >> 2] = i17;
      i17 = HEAP32[i13 >> 2] | 0;
      i14 = i18;
     } else {
      i14 = HEAP32[i14 >> 2] | 0;
     }
     HEAP32[i13 >> 2] = i17 + 1;
     HEAP8[i14 + i17 | 0] = i12;
     i12 = HEAP32[i9 >> 2] | 0;
     i18 = HEAP32[i12 >> 2] | 0;
     HEAP32[i12 >> 2] = i18 + -1;
     if ((i18 | 0) == 0) {
      i12 = _luaZ_fill(i12) | 0;
     } else {
      i18 = i12 + 4 | 0;
      i12 = HEAP32[i18 >> 2] | 0;
      HEAP32[i18 >> 2] = i12 + 1;
      i12 = HEAPU8[i12] | 0;
     }
     HEAP32[i3 >> 2] = i12;
    }
   }
  } while (0);
  if ((i11 | 0) == 22) {
   if ((_skip_sep(i3) | 0) == (i5 | 0)) {
    i11 = 23;
    break;
   } else {
    i11 = 13;
    continue;
   }
  }
  i12 = HEAP32[i4 >> 2] | 0;
  i11 = i12 + 4 | 0;
  i15 = HEAP32[i11 >> 2] | 0;
  i14 = i12 + 8 | 0;
  i13 = HEAP32[i14 >> 2] | 0;
  if ((i15 + 1 | 0) >>> 0 > i13 >>> 0) {
   if (i13 >>> 0 > 2147483645) {
    i11 = 37;
    break;
   }
   i15 = i13 << 1;
   i10 = HEAP32[i10 >> 2] | 0;
   if ((i15 | 0) == -2) {
    i11 = 39;
    break;
   }
   i10 = _luaM_realloc_(i10, HEAP32[i12 >> 2] | 0, i13, i15) | 0;
   HEAP32[i12 >> 2] = i10;
   HEAP32[i14 >> 2] = i15;
   i15 = HEAP32[i11 >> 2] | 0;
  } else {
   i10 = HEAP32[i12 >> 2] | 0;
  }
  HEAP32[i11 >> 2] = i15 + 1;
  HEAP8[i10 + i15 | 0] = 10;
  _inclinenumber(i3);
  if (!i8) {
   i11 = 13;
   continue;
  }
  HEAP32[(HEAP32[i4 >> 2] | 0) + 4 >> 2] = 0;
  i11 = 13;
 }
 if ((i11 | 0) == 21) {
  _lexerror(i3, (i1 | 0) != 0 ? 12512 : 12536, 286);
 } else if ((i11 | 0) == 23) {
  i15 = HEAP32[i3 >> 2] | 0;
  i13 = HEAP32[i4 >> 2] | 0;
  i14 = i13 + 4 | 0;
  i16 = HEAP32[i14 >> 2] | 0;
  i11 = i13 + 8 | 0;
  i12 = HEAP32[i11 >> 2] | 0;
  do {
   if ((i16 + 1 | 0) >>> 0 > i12 >>> 0) {
    if (i12 >>> 0 > 2147483645) {
     _lexerror(i3, 12368, 0);
    }
    i17 = i12 << 1;
    i16 = HEAP32[i10 >> 2] | 0;
    if ((i17 | 0) == -2) {
     _luaM_toobig(i16);
    } else {
     i6 = _luaM_realloc_(i16, HEAP32[i13 >> 2] | 0, i12, i17) | 0;
     HEAP32[i13 >> 2] = i6;
     HEAP32[i11 >> 2] = i17;
     i7 = HEAP32[i14 >> 2] | 0;
     break;
    }
   } else {
    i7 = i16;
    i6 = HEAP32[i13 >> 2] | 0;
   }
  } while (0);
  HEAP32[i14 >> 2] = i7 + 1;
  HEAP8[i6 + i7 | 0] = i15;
  i6 = HEAP32[i9 >> 2] | 0;
  i18 = HEAP32[i6 >> 2] | 0;
  HEAP32[i6 >> 2] = i18 + -1;
  if ((i18 | 0) == 0) {
   i6 = _luaZ_fill(i6) | 0;
  } else {
   i18 = i6 + 4 | 0;
   i6 = HEAP32[i18 >> 2] | 0;
   HEAP32[i18 >> 2] = i6 + 1;
   i6 = HEAPU8[i6] | 0;
  }
  HEAP32[i3 >> 2] = i6;
  if (i8) {
   STACKTOP = i2;
   return;
  }
  i4 = HEAP32[i4 >> 2] | 0;
  i5 = i5 + 2 | 0;
  i6 = HEAP32[i10 >> 2] | 0;
  i5 = _luaS_newlstr(i6, (HEAP32[i4 >> 2] | 0) + i5 | 0, (HEAP32[i4 + 4 >> 2] | 0) - (i5 << 1) | 0) | 0;
  i4 = i6 + 8 | 0;
  i7 = HEAP32[i4 >> 2] | 0;
  HEAP32[i4 >> 2] = i7 + 16;
  HEAP32[i7 >> 2] = i5;
  HEAP32[i7 + 8 >> 2] = HEAPU8[i5 + 4 | 0] | 0 | 64;
  i7 = _luaH_set(i6, HEAP32[(HEAP32[i3 + 48 >> 2] | 0) + 4 >> 2] | 0, (HEAP32[i4 >> 2] | 0) + -16 | 0) | 0;
  i3 = i7 + 8 | 0;
  if ((HEAP32[i3 >> 2] | 0) == 0 ? (HEAP32[i7 >> 2] = 1, HEAP32[i3 >> 2] = 1, (HEAP32[(HEAP32[i6 + 12 >> 2] | 0) + 12 >> 2] | 0) > 0) : 0) {
   _luaC_step(i6);
  }
  HEAP32[i4 >> 2] = (HEAP32[i4 >> 2] | 0) + -16;
  HEAP32[i1 >> 2] = i5;
  STACKTOP = i2;
  return;
 } else if ((i11 | 0) == 37) {
  _lexerror(i3, 12368, 0);
 } else if ((i11 | 0) == 39) {
  _luaM_toobig(i10);
 } else if ((i11 | 0) == 46) {
  _lexerror(i3, 12368, 0);
 } else if ((i11 | 0) == 48) {
  _luaM_toobig(i18);
 }
}
function _try_realloc_chunk(i1, i3) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0;
 i2 = STACKTOP;
 i4 = i1 + 4 | 0;
 i6 = HEAP32[i4 >> 2] | 0;
 i8 = i6 & -8;
 i5 = i1 + i8 | 0;
 i10 = HEAP32[12928 >> 2] | 0;
 if (i1 >>> 0 < i10 >>> 0) {
  _abort();
 }
 i12 = i6 & 3;
 if (!((i12 | 0) != 1 & i1 >>> 0 < i5 >>> 0)) {
  _abort();
 }
 i7 = i1 + (i8 | 4) | 0;
 i13 = HEAP32[i7 >> 2] | 0;
 if ((i13 & 1 | 0) == 0) {
  _abort();
 }
 if ((i12 | 0) == 0) {
  if (i3 >>> 0 < 256) {
   i15 = 0;
   STACKTOP = i2;
   return i15 | 0;
  }
  if (!(i8 >>> 0 < (i3 + 4 | 0) >>> 0) ? !((i8 - i3 | 0) >>> 0 > HEAP32[13392 >> 2] << 1 >>> 0) : 0) {
   i15 = i1;
   STACKTOP = i2;
   return i15 | 0;
  }
  i15 = 0;
  STACKTOP = i2;
  return i15 | 0;
 }
 if (!(i8 >>> 0 < i3 >>> 0)) {
  i5 = i8 - i3 | 0;
  if (!(i5 >>> 0 > 15)) {
   i15 = i1;
   STACKTOP = i2;
   return i15 | 0;
  }
  HEAP32[i4 >> 2] = i6 & 1 | i3 | 2;
  HEAP32[i1 + (i3 + 4) >> 2] = i5 | 3;
  HEAP32[i7 >> 2] = HEAP32[i7 >> 2] | 1;
  _dispose_chunk(i1 + i3 | 0, i5);
  i15 = i1;
  STACKTOP = i2;
  return i15 | 0;
 }
 if ((i5 | 0) == (HEAP32[12936 >> 2] | 0)) {
  i5 = (HEAP32[12924 >> 2] | 0) + i8 | 0;
  if (!(i5 >>> 0 > i3 >>> 0)) {
   i15 = 0;
   STACKTOP = i2;
   return i15 | 0;
  }
  i15 = i5 - i3 | 0;
  HEAP32[i4 >> 2] = i6 & 1 | i3 | 2;
  HEAP32[i1 + (i3 + 4) >> 2] = i15 | 1;
  HEAP32[12936 >> 2] = i1 + i3;
  HEAP32[12924 >> 2] = i15;
  i15 = i1;
  STACKTOP = i2;
  return i15 | 0;
 }
 if ((i5 | 0) == (HEAP32[12932 >> 2] | 0)) {
  i7 = (HEAP32[12920 >> 2] | 0) + i8 | 0;
  if (i7 >>> 0 < i3 >>> 0) {
   i15 = 0;
   STACKTOP = i2;
   return i15 | 0;
  }
  i5 = i7 - i3 | 0;
  if (i5 >>> 0 > 15) {
   HEAP32[i4 >> 2] = i6 & 1 | i3 | 2;
   HEAP32[i1 + (i3 + 4) >> 2] = i5 | 1;
   HEAP32[i1 + i7 >> 2] = i5;
   i15 = i1 + (i7 + 4) | 0;
   HEAP32[i15 >> 2] = HEAP32[i15 >> 2] & -2;
   i3 = i1 + i3 | 0;
  } else {
   HEAP32[i4 >> 2] = i6 & 1 | i7 | 2;
   i3 = i1 + (i7 + 4) | 0;
   HEAP32[i3 >> 2] = HEAP32[i3 >> 2] | 1;
   i3 = 0;
   i5 = 0;
  }
  HEAP32[12920 >> 2] = i5;
  HEAP32[12932 >> 2] = i3;
  i15 = i1;
  STACKTOP = i2;
  return i15 | 0;
 }
 if ((i13 & 2 | 0) != 0) {
  i15 = 0;
  STACKTOP = i2;
  return i15 | 0;
 }
 i7 = (i13 & -8) + i8 | 0;
 if (i7 >>> 0 < i3 >>> 0) {
  i15 = 0;
  STACKTOP = i2;
  return i15 | 0;
 }
 i6 = i7 - i3 | 0;
 i12 = i13 >>> 3;
 do {
  if (!(i13 >>> 0 < 256)) {
   i11 = HEAP32[i1 + (i8 + 24) >> 2] | 0;
   i13 = HEAP32[i1 + (i8 + 12) >> 2] | 0;
   do {
    if ((i13 | 0) == (i5 | 0)) {
     i13 = i1 + (i8 + 20) | 0;
     i12 = HEAP32[i13 >> 2] | 0;
     if ((i12 | 0) == 0) {
      i13 = i1 + (i8 + 16) | 0;
      i12 = HEAP32[i13 >> 2] | 0;
      if ((i12 | 0) == 0) {
       i9 = 0;
       break;
      }
     }
     while (1) {
      i15 = i12 + 20 | 0;
      i14 = HEAP32[i15 >> 2] | 0;
      if ((i14 | 0) != 0) {
       i12 = i14;
       i13 = i15;
       continue;
      }
      i15 = i12 + 16 | 0;
      i14 = HEAP32[i15 >> 2] | 0;
      if ((i14 | 0) == 0) {
       break;
      } else {
       i12 = i14;
       i13 = i15;
      }
     }
     if (i13 >>> 0 < i10 >>> 0) {
      _abort();
     } else {
      HEAP32[i13 >> 2] = 0;
      i9 = i12;
      break;
     }
    } else {
     i12 = HEAP32[i1 + (i8 + 8) >> 2] | 0;
     if (i12 >>> 0 < i10 >>> 0) {
      _abort();
     }
     i14 = i12 + 12 | 0;
     if ((HEAP32[i14 >> 2] | 0) != (i5 | 0)) {
      _abort();
     }
     i10 = i13 + 8 | 0;
     if ((HEAP32[i10 >> 2] | 0) == (i5 | 0)) {
      HEAP32[i14 >> 2] = i13;
      HEAP32[i10 >> 2] = i12;
      i9 = i13;
      break;
     } else {
      _abort();
     }
    }
   } while (0);
   if ((i11 | 0) != 0) {
    i10 = HEAP32[i1 + (i8 + 28) >> 2] | 0;
    i12 = 13216 + (i10 << 2) | 0;
    if ((i5 | 0) == (HEAP32[i12 >> 2] | 0)) {
     HEAP32[i12 >> 2] = i9;
     if ((i9 | 0) == 0) {
      HEAP32[12916 >> 2] = HEAP32[12916 >> 2] & ~(1 << i10);
      break;
     }
    } else {
     if (i11 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     }
     i10 = i11 + 16 | 0;
     if ((HEAP32[i10 >> 2] | 0) == (i5 | 0)) {
      HEAP32[i10 >> 2] = i9;
     } else {
      HEAP32[i11 + 20 >> 2] = i9;
     }
     if ((i9 | 0) == 0) {
      break;
     }
    }
    if (i9 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
     _abort();
    }
    HEAP32[i9 + 24 >> 2] = i11;
    i5 = HEAP32[i1 + (i8 + 16) >> 2] | 0;
    do {
     if ((i5 | 0) != 0) {
      if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
       _abort();
      } else {
       HEAP32[i9 + 16 >> 2] = i5;
       HEAP32[i5 + 24 >> 2] = i9;
       break;
      }
     }
    } while (0);
    i5 = HEAP32[i1 + (i8 + 20) >> 2] | 0;
    if ((i5 | 0) != 0) {
     if (i5 >>> 0 < (HEAP32[12928 >> 2] | 0) >>> 0) {
      _abort();
     } else {
      HEAP32[i9 + 20 >> 2] = i5;
      HEAP32[i5 + 24 >> 2] = i9;
      break;
     }
    }
   }
  } else {
   i9 = HEAP32[i1 + (i8 + 8) >> 2] | 0;
   i8 = HEAP32[i1 + (i8 + 12) >> 2] | 0;
   i13 = 12952 + (i12 << 1 << 2) | 0;
   if ((i9 | 0) != (i13 | 0)) {
    if (i9 >>> 0 < i10 >>> 0) {
     _abort();
    }
    if ((HEAP32[i9 + 12 >> 2] | 0) != (i5 | 0)) {
     _abort();
    }
   }
   if ((i8 | 0) == (i9 | 0)) {
    HEAP32[3228] = HEAP32[3228] & ~(1 << i12);
    break;
   }
   if ((i8 | 0) != (i13 | 0)) {
    if (i8 >>> 0 < i10 >>> 0) {
     _abort();
    }
    i10 = i8 + 8 | 0;
    if ((HEAP32[i10 >> 2] | 0) == (i5 | 0)) {
     i11 = i10;
    } else {
     _abort();
    }
   } else {
    i11 = i8 + 8 | 0;
   }
   HEAP32[i9 + 12 >> 2] = i8;
   HEAP32[i11 >> 2] = i9;
  }
 } while (0);
 if (i6 >>> 0 < 16) {
  HEAP32[i4 >> 2] = i7 | HEAP32[i4 >> 2] & 1 | 2;
  i15 = i1 + (i7 | 4) | 0;
  HEAP32[i15 >> 2] = HEAP32[i15 >> 2] | 1;
  i15 = i1;
  STACKTOP = i2;
  return i15 | 0;
 } else {
  HEAP32[i4 >> 2] = HEAP32[i4 >> 2] & 1 | i3 | 2;
  HEAP32[i1 + (i3 + 4) >> 2] = i6 | 3;
  i15 = i1 + (i7 | 4) | 0;
  HEAP32[i15 >> 2] = HEAP32[i15 >> 2] | 1;
  _dispose_chunk(i1 + i3 | 0, i6);
  i15 = i1;
  STACKTOP = i2;
  return i15 | 0;
 }
 return 0;
}
function _luaK_posfix(i3, i16, i1, i4, i14) {
 i3 = i3 | 0;
 i16 = i16 | 0;
 i1 = i1 | 0;
 i4 = i4 | 0;
 i14 = i14 | 0;
 var i2 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i15 = 0;
 i2 = STACKTOP;
 switch (i16 | 0) {
 case 14:
  {
   _luaK_dischargevars(i3, i4);
   i6 = i4 + 16 | 0;
   i5 = HEAP32[i1 + 16 >> 2] | 0;
   do {
    if (!((i5 | 0) == -1)) {
     i9 = HEAP32[i6 >> 2] | 0;
     if ((i9 | 0) == -1) {
      HEAP32[i6 >> 2] = i5;
      break;
     }
     i7 = HEAP32[(HEAP32[i3 >> 2] | 0) + 12 >> 2] | 0;
     while (1) {
      i6 = i7 + (i9 << 2) | 0;
      i8 = HEAP32[i6 >> 2] | 0;
      i10 = (i8 >>> 14) + -131071 | 0;
      if ((i10 | 0) == -1) {
       break;
      }
      i10 = i9 + 1 + i10 | 0;
      if ((i10 | 0) == -1) {
       break;
      } else {
       i9 = i10;
      }
     }
     i5 = i5 + ~i9 | 0;
     if ((((i5 | 0) > -1 ? i5 : 0 - i5 | 0) | 0) > 131071) {
      _luaX_syntaxerror(HEAP32[i3 + 12 >> 2] | 0, 10624);
     } else {
      HEAP32[i6 >> 2] = (i5 << 14) + 2147467264 | i8 & 16383;
      break;
     }
    }
   } while (0);
   HEAP32[i1 + 0 >> 2] = HEAP32[i4 + 0 >> 2];
   HEAP32[i1 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
   HEAP32[i1 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
   HEAP32[i1 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
   HEAP32[i1 + 16 >> 2] = HEAP32[i4 + 16 >> 2];
   HEAP32[i1 + 20 >> 2] = HEAP32[i4 + 20 >> 2];
   STACKTOP = i2;
   return;
  }
 case 13:
  {
   _luaK_dischargevars(i3, i4);
   i6 = i4 + 20 | 0;
   i5 = HEAP32[i1 + 20 >> 2] | 0;
   do {
    if (!((i5 | 0) == -1)) {
     i9 = HEAP32[i6 >> 2] | 0;
     if ((i9 | 0) == -1) {
      HEAP32[i6 >> 2] = i5;
      break;
     }
     i7 = HEAP32[(HEAP32[i3 >> 2] | 0) + 12 >> 2] | 0;
     while (1) {
      i8 = i7 + (i9 << 2) | 0;
      i6 = HEAP32[i8 >> 2] | 0;
      i10 = (i6 >>> 14) + -131071 | 0;
      if ((i10 | 0) == -1) {
       break;
      }
      i10 = i9 + 1 + i10 | 0;
      if ((i10 | 0) == -1) {
       break;
      } else {
       i9 = i10;
      }
     }
     i5 = i5 + ~i9 | 0;
     if ((((i5 | 0) > -1 ? i5 : 0 - i5 | 0) | 0) > 131071) {
      _luaX_syntaxerror(HEAP32[i3 + 12 >> 2] | 0, 10624);
     } else {
      HEAP32[i8 >> 2] = (i5 << 14) + 2147467264 | i6 & 16383;
      break;
     }
    }
   } while (0);
   HEAP32[i1 + 0 >> 2] = HEAP32[i4 + 0 >> 2];
   HEAP32[i1 + 4 >> 2] = HEAP32[i4 + 4 >> 2];
   HEAP32[i1 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
   HEAP32[i1 + 12 >> 2] = HEAP32[i4 + 12 >> 2];
   HEAP32[i1 + 16 >> 2] = HEAP32[i4 + 16 >> 2];
   HEAP32[i1 + 20 >> 2] = HEAP32[i4 + 20 >> 2];
   STACKTOP = i2;
   return;
  }
 case 6:
  {
   i12 = i4 + 16 | 0;
   i13 = i4 + 20 | 0;
   i16 = (HEAP32[i12 >> 2] | 0) == (HEAP32[i13 >> 2] | 0);
   _luaK_dischargevars(i3, i4);
   do {
    if (!i16) {
     if ((HEAP32[i4 >> 2] | 0) == 6) {
      i10 = HEAP32[i4 + 8 >> 2] | 0;
      if ((HEAP32[i12 >> 2] | 0) == (HEAP32[i13 >> 2] | 0)) {
       break;
      }
      if ((i10 | 0) >= (HEAPU8[i3 + 46 | 0] | 0 | 0)) {
       _exp2reg(i3, i4, i10);
       break;
      }
     }
     _luaK_exp2nextreg(i3, i4);
    }
   } while (0);
   if ((HEAP32[i4 >> 2] | 0) == 11 ? (i5 = i4 + 8 | 0, i7 = HEAP32[i5 >> 2] | 0, i8 = (HEAP32[i3 >> 2] | 0) + 12 | 0, i9 = HEAP32[i8 >> 2] | 0, i6 = HEAP32[i9 + (i7 << 2) >> 2] | 0, (i6 & 63 | 0) == 22) : 0) {
    i4 = i1 + 8 | 0;
    if (((HEAP32[i1 >> 2] | 0) == 6 ? (i11 = HEAP32[i4 >> 2] | 0, (i11 & 256 | 0) == 0) : 0) ? (HEAPU8[i3 + 46 | 0] | 0 | 0) <= (i11 | 0) : 0) {
     i6 = i3 + 48 | 0;
     HEAP8[i6] = (HEAP8[i6] | 0) + -1 << 24 >> 24;
     i6 = HEAP32[i5 >> 2] | 0;
     i16 = HEAP32[i8 >> 2] | 0;
     i9 = i16;
     i7 = i6;
     i6 = HEAP32[i16 + (i6 << 2) >> 2] | 0;
    }
    HEAP32[i9 + (i7 << 2) >> 2] = HEAP32[i4 >> 2] << 23 | i6 & 8388607;
    HEAP32[i1 >> 2] = 11;
    HEAP32[i4 >> 2] = HEAP32[i5 >> 2];
    STACKTOP = i2;
    return;
   }
   _luaK_exp2nextreg(i3, i4);
   _codearith(i3, 22, i1, i4, i14);
   STACKTOP = i2;
   return;
  }
 case 9:
 case 8:
 case 7:
  {
   i7 = i16 + 17 | 0;
   i6 = _luaK_exp2RK(i3, i1) | 0;
   i5 = _luaK_exp2RK(i3, i4) | 0;
   if (((HEAP32[i4 >> 2] | 0) == 6 ? (i15 = HEAP32[i4 + 8 >> 2] | 0, (i15 & 256 | 0) == 0) : 0) ? (HEAPU8[i3 + 46 | 0] | 0 | 0) <= (i15 | 0) : 0) {
    i16 = i3 + 48 | 0;
    HEAP8[i16] = (HEAP8[i16] | 0) + -1 << 24 >> 24;
   }
   i4 = i1 + 8 | 0;
   if (((HEAP32[i1 >> 2] | 0) == 6 ? (i10 = HEAP32[i4 >> 2] | 0, (i10 & 256 | 0) == 0) : 0) ? (HEAPU8[i3 + 46 | 0] | 0 | 0) <= (i10 | 0) : 0) {
    i16 = i3 + 48 | 0;
    HEAP8[i16] = (HEAP8[i16] | 0) + -1 << 24 >> 24;
   }
   HEAP32[i4 >> 2] = _condjump(i3, i7, 1, i6, i5) | 0;
   HEAP32[i1 >> 2] = 10;
   STACKTOP = i2;
   return;
  }
 case 12:
 case 11:
 case 10:
  {
   i7 = i16 + 14 | 0;
   i6 = _luaK_exp2RK(i3, i1) | 0;
   i5 = _luaK_exp2RK(i3, i4) | 0;
   if (((HEAP32[i4 >> 2] | 0) == 6 ? (i13 = HEAP32[i4 + 8 >> 2] | 0, (i13 & 256 | 0) == 0) : 0) ? (HEAPU8[i3 + 46 | 0] | 0 | 0) <= (i13 | 0) : 0) {
    i16 = i3 + 48 | 0;
    HEAP8[i16] = (HEAP8[i16] | 0) + -1 << 24 >> 24;
   }
   i4 = i1 + 8 | 0;
   if (((HEAP32[i1 >> 2] | 0) == 6 ? (i12 = HEAP32[i4 >> 2] | 0, (i12 & 256 | 0) == 0) : 0) ? (HEAPU8[i3 + 46 | 0] | 0 | 0) <= (i12 | 0) : 0) {
    i16 = i3 + 48 | 0;
    HEAP8[i16] = (HEAP8[i16] | 0) + -1 << 24 >> 24;
   }
   i8 = (i7 | 0) == 24;
   HEAP32[i4 >> 2] = _condjump(i3, i7, i8 & 1 ^ 1, i8 ? i6 : i5, i8 ? i5 : i6) | 0;
   HEAP32[i1 >> 2] = 10;
   STACKTOP = i2;
   return;
  }
 case 5:
 case 4:
 case 3:
 case 2:
 case 1:
 case 0:
  {
   _codearith(i3, i16 + 13 | 0, i1, i4, i14);
   STACKTOP = i2;
   return;
  }
 default:
  {
   STACKTOP = i2;
   return;
  }
 }
}
function _body(i1, i4, i13, i5) {
 i1 = i1 | 0;
 i4 = i4 | 0;
 i13 = i13 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i3 = i6 + 12 | 0;
 i14 = i6;
 i2 = i1 + 48 | 0;
 i19 = HEAP32[i2 >> 2] | 0;
 i18 = i1 + 52 | 0;
 i17 = HEAP32[i18 >> 2] | 0;
 i16 = HEAP32[i19 >> 2] | 0;
 i19 = i19 + 36 | 0;
 i23 = i16 + 56 | 0;
 i24 = HEAP32[i23 >> 2] | 0;
 i15 = i16 + 16 | 0;
 if (((HEAP32[i19 >> 2] | 0) >= (i24 | 0) ? (i21 = _luaM_growaux_(i17, HEAP32[i15 >> 2] | 0, i23, 4, 262143, 6512) | 0, HEAP32[i15 >> 2] = i21, i20 = HEAP32[i23 >> 2] | 0, (i24 | 0) < (i20 | 0)) : 0) ? (i22 = i24 + 1 | 0, HEAP32[i21 + (i24 << 2) >> 2] = 0, (i22 | 0) < (i20 | 0)) : 0) {
  while (1) {
   i21 = i22 + 1 | 0;
   HEAP32[(HEAP32[i15 >> 2] | 0) + (i22 << 2) >> 2] = 0;
   if ((i21 | 0) == (i20 | 0)) {
    break;
   } else {
    i22 = i21;
   }
  }
 }
 i20 = _luaF_newproto(i17) | 0;
 i24 = HEAP32[i19 >> 2] | 0;
 HEAP32[i19 >> 2] = i24 + 1;
 HEAP32[(HEAP32[i15 >> 2] | 0) + (i24 << 2) >> 2] = i20;
 if (!((HEAP8[i20 + 5 | 0] & 3) == 0) ? !((HEAP8[i16 + 5 | 0] & 4) == 0) : 0) {
  _luaC_barrier_(i17, i16, i20);
 }
 HEAP32[i3 >> 2] = i20;
 HEAP32[i20 + 64 >> 2] = i5;
 i16 = HEAP32[i18 >> 2] | 0;
 HEAP32[i3 + 8 >> 2] = HEAP32[i2 >> 2];
 i17 = i3 + 12 | 0;
 HEAP32[i17 >> 2] = i1;
 HEAP32[i2 >> 2] = i3;
 HEAP32[i3 + 20 >> 2] = 0;
 HEAP32[i3 + 24 >> 2] = 0;
 HEAP32[i3 + 28 >> 2] = -1;
 HEAP32[i3 + 32 >> 2] = 0;
 HEAP32[i3 + 36 >> 2] = 0;
 i22 = i3 + 44 | 0;
 i15 = i1 + 64 | 0;
 HEAP32[i22 + 0 >> 2] = 0;
 HEAP8[i22 + 4 | 0] = 0;
 HEAP32[i3 + 40 >> 2] = HEAP32[(HEAP32[i15 >> 2] | 0) + 4 >> 2];
 i15 = i3 + 16 | 0;
 HEAP32[i15 >> 2] = 0;
 HEAP32[i20 + 36 >> 2] = HEAP32[i1 + 68 >> 2];
 HEAP8[i20 + 78 | 0] = 2;
 i22 = _luaH_new(i16) | 0;
 HEAP32[i3 + 4 >> 2] = i22;
 i23 = i16 + 8 | 0;
 i24 = HEAP32[i23 >> 2] | 0;
 HEAP32[i24 >> 2] = i22;
 HEAP32[i24 + 8 >> 2] = 69;
 i24 = (HEAP32[i23 >> 2] | 0) + 16 | 0;
 HEAP32[i23 >> 2] = i24;
 if (((HEAP32[i16 + 24 >> 2] | 0) - i24 | 0) < 16) {
  _luaD_growstack(i16, 0);
 }
 HEAP8[i14 + 10 | 0] = 0;
 HEAP8[i14 + 8 | 0] = HEAP8[i3 + 46 | 0] | 0;
 i24 = HEAP32[(HEAP32[i17 >> 2] | 0) + 64 >> 2] | 0;
 HEAP16[i14 + 4 >> 1] = HEAP32[i24 + 28 >> 2];
 HEAP16[i14 + 6 >> 1] = HEAP32[i24 + 16 >> 2];
 HEAP8[i14 + 9 | 0] = 0;
 HEAP32[i14 >> 2] = HEAP32[i15 >> 2];
 HEAP32[i15 >> 2] = i14;
 i14 = i1 + 16 | 0;
 if ((HEAP32[i14 >> 2] | 0) != 40) {
  _error_expected(i1, 40);
 }
 _luaX_next(i1);
 if ((i13 | 0) != 0) {
  _new_localvar(i1, _luaX_newstring(i1, 6456, 4) | 0);
  i24 = HEAP32[i2 >> 2] | 0;
  i22 = i24 + 46 | 0;
  i23 = (HEAPU8[i22] | 0) + 1 | 0;
  HEAP8[i22] = i23;
  HEAP32[(HEAP32[(HEAP32[i24 >> 2] | 0) + 24 >> 2] | 0) + ((HEAP16[(HEAP32[HEAP32[(HEAP32[i24 + 12 >> 2] | 0) + 64 >> 2] >> 2] | 0) + ((i23 & 255) + -1 + (HEAP32[i24 + 40 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i24 + 20 >> 2];
 }
 i13 = HEAP32[i2 >> 2] | 0;
 i15 = HEAP32[i13 >> 2] | 0;
 i16 = i15 + 77 | 0;
 HEAP8[i16] = 0;
 i19 = HEAP32[i14 >> 2] | 0;
 L20 : do {
  if ((i19 | 0) != 41) {
   i17 = i1 + 24 | 0;
   i18 = 0;
   while (1) {
    if ((i19 | 0) == 280) {
     i17 = 18;
     break;
    } else if ((i19 | 0) != 288) {
     i17 = 19;
     break;
    }
    i24 = HEAP32[i17 >> 2] | 0;
    _luaX_next(i1);
    _new_localvar(i1, i24);
    i18 = i18 + 1 | 0;
    if ((HEAP8[i16] | 0) != 0) {
     i11 = i18;
     break L20;
    }
    if ((HEAP32[i14 >> 2] | 0) != 44) {
     i11 = i18;
     break L20;
    }
    _luaX_next(i1);
    i19 = HEAP32[i14 >> 2] | 0;
   }
   if ((i17 | 0) == 18) {
    _luaX_next(i1);
    HEAP8[i16] = 1;
    i11 = i18;
    break;
   } else if ((i17 | 0) == 19) {
    _luaX_syntaxerror(i1, 6464);
   }
  } else {
   i11 = 0;
  }
 } while (0);
 i18 = HEAP32[i2 >> 2] | 0;
 i16 = i18 + 46 | 0;
 i17 = (HEAPU8[i16] | 0) + i11 | 0;
 HEAP8[i16] = i17;
 if ((i11 | 0) != 0 ? (i8 = i18 + 20 | 0, i9 = i18 + 40 | 0, i7 = HEAP32[(HEAP32[i18 >> 2] | 0) + 24 >> 2] | 0, i10 = HEAP32[HEAP32[(HEAP32[i18 + 12 >> 2] | 0) + 64 >> 2] >> 2] | 0, HEAP32[i7 + ((HEAP16[i10 + ((i17 & 255) - i11 + (HEAP32[i9 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i8 >> 2], i12 = i11 + -1 | 0, (i12 | 0) != 0) : 0) {
  do {
   HEAP32[i7 + ((HEAP16[i10 + ((HEAPU8[i16] | 0) - i12 + (HEAP32[i9 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i8 >> 2];
   i12 = i12 + -1 | 0;
  } while ((i12 | 0) != 0);
 }
 i24 = i13 + 46 | 0;
 HEAP8[i15 + 76 | 0] = HEAP8[i24] | 0;
 _luaK_reserveregs(i13, HEAPU8[i24] | 0);
 if ((HEAP32[i14 >> 2] | 0) != 41) {
  _error_expected(i1, 41);
 }
 _luaX_next(i1);
 L39 : while (1) {
  i7 = HEAP32[i14 >> 2] | 0;
  switch (i7 | 0) {
  case 277:
  case 286:
  case 262:
  case 261:
  case 260:
   {
    i17 = 30;
    break L39;
   }
  default:
   {}
  }
  _statement(i1);
  if ((i7 | 0) == 274) {
   i17 = 30;
   break;
  }
 }
 if ((i17 | 0) == 30) {
  HEAP32[(HEAP32[i3 >> 2] | 0) + 68 >> 2] = HEAP32[i1 + 4 >> 2];
  _check_match(i1, 262, 265, i5);
  i24 = HEAP32[(HEAP32[i2 >> 2] | 0) + 8 >> 2] | 0;
  i23 = _luaK_codeABx(i24, 37, 0, (HEAP32[i24 + 36 >> 2] | 0) + -1 | 0) | 0;
  HEAP32[i4 + 16 >> 2] = -1;
  HEAP32[i4 + 20 >> 2] = -1;
  HEAP32[i4 >> 2] = 11;
  HEAP32[i4 + 8 >> 2] = i23;
  _luaK_exp2nextreg(i24, i4);
  _close_func(i1);
  STACKTOP = i6;
  return;
 }
}
function _luaH_newkey(i3, i2, i1) {
 i3 = i3 | 0;
 i2 = i2 | 0;
 i1 = i1 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, d21 = 0.0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 144 | 0;
 i8 = i4 + 8 | 0;
 i10 = i4;
 i5 = i4 + 16 | 0;
 i6 = i1 + 8 | 0;
 i11 = HEAP32[i6 >> 2] | 0;
 if ((i11 | 0) == 0) {
  _luaG_runerror(i3, 7968, i8);
 } else if ((i11 | 0) == 3) {
  i15 = 3;
 }
 if ((i15 | 0) == 3 ? (d21 = +HEAPF64[i1 >> 3], !(d21 == d21 & 0.0 == 0.0)) : 0) {
  _luaG_runerror(i3, 7992, i8);
 }
 i13 = _mainposition(i2, i1) | 0;
 i14 = i13 + 8 | 0;
 do {
  if ((HEAP32[i14 >> 2] | 0) != 0 | (i13 | 0) == 8016) {
   i18 = i2 + 20 | 0;
   i11 = i2 + 16 | 0;
   i17 = HEAP32[i11 >> 2] | 0;
   i16 = HEAP32[i18 >> 2] | 0;
   while (1) {
    if (!(i16 >>> 0 > i17 >>> 0)) {
     break;
    }
    i12 = i16 + -32 | 0;
    HEAP32[i18 >> 2] = i12;
    if ((HEAP32[i16 + -8 >> 2] | 0) == 0) {
     i15 = 37;
     break;
    } else {
     i16 = i12;
    }
   }
   if ((i15 | 0) == 37) {
    i5 = _mainposition(i2, i13 + 16 | 0) | 0;
    if ((i5 | 0) == (i13 | 0)) {
     i20 = i13 + 28 | 0;
     HEAP32[i16 + -4 >> 2] = HEAP32[i20 >> 2];
     HEAP32[i20 >> 2] = i12;
     break;
    } else {
     i7 = i5;
    }
    do {
     i5 = i7 + 28 | 0;
     i7 = HEAP32[i5 >> 2] | 0;
    } while ((i7 | 0) != (i13 | 0));
    HEAP32[i5 >> 2] = i12;
    HEAP32[i12 + 0 >> 2] = HEAP32[i13 + 0 >> 2];
    HEAP32[i12 + 4 >> 2] = HEAP32[i13 + 4 >> 2];
    HEAP32[i12 + 8 >> 2] = HEAP32[i13 + 8 >> 2];
    HEAP32[i12 + 12 >> 2] = HEAP32[i13 + 12 >> 2];
    HEAP32[i12 + 16 >> 2] = HEAP32[i13 + 16 >> 2];
    HEAP32[i12 + 20 >> 2] = HEAP32[i13 + 20 >> 2];
    HEAP32[i12 + 24 >> 2] = HEAP32[i13 + 24 >> 2];
    HEAP32[i12 + 28 >> 2] = HEAP32[i13 + 28 >> 2];
    HEAP32[i13 + 28 >> 2] = 0;
    HEAP32[i14 >> 2] = 0;
    i12 = i13;
    break;
   }
   i13 = i5 + 0 | 0;
   i12 = i13 + 124 | 0;
   do {
    HEAP32[i13 >> 2] = 0;
    i13 = i13 + 4 | 0;
   } while ((i13 | 0) < (i12 | 0));
   i15 = i2 + 12 | 0;
   i13 = HEAP32[i2 + 28 >> 2] | 0;
   i12 = 0;
   i20 = 1;
   i16 = 0;
   i14 = 1;
   while (1) {
    if ((i14 | 0) > (i13 | 0)) {
     if ((i20 | 0) > (i13 | 0)) {
      break;
     } else {
      i19 = i13;
     }
    } else {
     i19 = i14;
    }
    if ((i20 | 0) > (i19 | 0)) {
     i18 = i20;
     i17 = 0;
    } else {
     i18 = HEAP32[i15 >> 2] | 0;
     i17 = 0;
     while (1) {
      i17 = ((HEAP32[i18 + (i20 + -1 << 4) + 8 >> 2] | 0) != 0) + i17 | 0;
      if ((i20 | 0) >= (i19 | 0)) {
       break;
      } else {
       i20 = i20 + 1 | 0;
      }
     }
     i18 = i19 + 1 | 0;
    }
    i20 = i5 + (i16 << 2) | 0;
    HEAP32[i20 >> 2] = (HEAP32[i20 >> 2] | 0) + i17;
    i12 = i17 + i12 | 0;
    i16 = i16 + 1 | 0;
    if ((i16 | 0) < 31) {
     i20 = i18;
     i14 = i14 << 1;
    } else {
     break;
    }
   }
   i14 = 0;
   i15 = 1 << (HEAPU8[i2 + 7 | 0] | 0);
   i13 = 0;
   L32 : while (1) {
    i16 = i15;
    while (1) {
     i15 = i16 + -1 | 0;
     if ((i16 | 0) == 0) {
      break L32;
     }
     i16 = HEAP32[i11 >> 2] | 0;
     if ((HEAP32[i16 + (i15 << 5) + 8 >> 2] | 0) == 0) {
      i16 = i15;
     } else {
      break;
     }
    }
    if (((HEAP32[i16 + (i15 << 5) + 24 >> 2] | 0) == 3 ? (d21 = +HEAPF64[i16 + (i15 << 5) + 16 >> 3], HEAPF64[i10 >> 3] = d21 + 6755399441055744.0, i9 = HEAP32[i10 >> 2] | 0, +(i9 | 0) == d21) : 0) ? (i9 + -1 | 0) >>> 0 < 1073741824 : 0) {
     i16 = i5 + ((_luaO_ceillog2(i9) | 0) << 2) | 0;
     HEAP32[i16 >> 2] = (HEAP32[i16 >> 2] | 0) + 1;
     i16 = 1;
    } else {
     i16 = 0;
    }
    i14 = i16 + i14 | 0;
    i13 = i13 + 1 | 0;
   }
   i9 = i14 + i12 | 0;
   if (((HEAP32[i6 >> 2] | 0) == 3 ? (d21 = +HEAPF64[i1 >> 3], HEAPF64[i8 >> 3] = d21 + 6755399441055744.0, i7 = HEAP32[i8 >> 2] | 0, +(i7 | 0) == d21) : 0) ? (i7 + -1 | 0) >>> 0 < 1073741824 : 0) {
    i6 = i5 + ((_luaO_ceillog2(i7) | 0) << 2) | 0;
    HEAP32[i6 >> 2] = (HEAP32[i6 >> 2] | 0) + 1;
    i6 = 1;
   } else {
    i6 = 0;
   }
   i7 = i9 + i6 | 0;
   L49 : do {
    if ((i7 | 0) > 0) {
     i14 = 0;
     i10 = 0;
     i6 = 0;
     i8 = 0;
     i11 = 0;
     i9 = 1;
     while (1) {
      i15 = HEAP32[i5 + (i6 << 2) >> 2] | 0;
      if ((i15 | 0) > 0) {
       i15 = i15 + i10 | 0;
       i14 = (i15 | 0) > (i14 | 0);
       i10 = i15;
       i8 = i14 ? i9 : i8;
       i11 = i14 ? i15 : i11;
      }
      if ((i10 | 0) == (i7 | 0)) {
       break L49;
      }
      i9 = i9 << 1;
      i14 = (i9 | 0) / 2 | 0;
      if ((i14 | 0) < (i7 | 0)) {
       i6 = i6 + 1 | 0;
      } else {
       break;
      }
     }
    } else {
     i8 = 0;
     i11 = 0;
    }
   } while (0);
   _luaH_resize(i3, i2, i8, i12 + 1 + i13 - i11 | 0);
   i5 = _luaH_get(i2, i1) | 0;
   if ((i5 | 0) != 5192) {
    i20 = i5;
    STACKTOP = i4;
    return i20 | 0;
   }
   i20 = _luaH_newkey(i3, i2, i1) | 0;
   STACKTOP = i4;
   return i20 | 0;
  } else {
   i12 = i13;
  }
 } while (0);
 i18 = i1;
 i19 = HEAP32[i18 + 4 >> 2] | 0;
 i20 = i12 + 16 | 0;
 HEAP32[i20 >> 2] = HEAP32[i18 >> 2];
 HEAP32[i20 + 4 >> 2] = i19;
 HEAP32[i12 + 24 >> 2] = HEAP32[i6 >> 2];
 if (((HEAP32[i6 >> 2] & 64 | 0) != 0 ? !((HEAP8[(HEAP32[i1 >> 2] | 0) + 5 | 0] & 3) == 0) : 0) ? !((HEAP8[i2 + 5 | 0] & 4) == 0) : 0) {
  _luaC_barrierback_(i3, i2);
 }
 i20 = i12;
 STACKTOP = i4;
 return i20 | 0;
}
function _luaV_concat(i7, i10) {
 i7 = i7 | 0;
 i10 = i10 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i8 = 0, i9 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 48 | 0;
 i9 = i5;
 i8 = i5 + 8 | 0;
 i6 = i7 + 8 | 0;
 i2 = i7 + 12 | 0;
 i3 = i7 + 28 | 0;
 i4 = i7 + 16 | 0;
 i11 = HEAP32[i6 >> 2] | 0;
 L1 : while (1) {
  i14 = i11 + -32 | 0;
  i12 = i11 + -24 | 0;
  i17 = HEAP32[i12 >> 2] | 0;
  i13 = i11 + -16 | 0;
  do {
   if ((i17 & 15 | 0) == 4 | (i17 | 0) == 3) {
    i15 = i11 + -8 | 0;
    i16 = HEAP32[i15 >> 2] | 0;
    if ((i16 & 15 | 0) == 4) {
     i16 = i13;
    } else {
     if ((i16 | 0) != 3) {
      i1 = 7;
      break;
     }
     HEAPF64[tempDoublePtr >> 3] = +HEAPF64[i13 >> 3];
     HEAP32[i9 >> 2] = HEAP32[tempDoublePtr >> 2];
     HEAP32[i9 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
     i16 = _luaS_newlstr(i7, i8, _sprintf(i8 | 0, 8936, i9 | 0) | 0) | 0;
     HEAP32[i13 >> 2] = i16;
     HEAP32[i15 >> 2] = HEAPU8[i16 + 4 | 0] | 0 | 64;
     i16 = i13;
     i17 = HEAP32[i12 >> 2] | 0;
    }
    i16 = HEAP32[(HEAP32[i16 >> 2] | 0) + 12 >> 2] | 0;
    i18 = (i17 & 15 | 0) == 4;
    if ((i16 | 0) == 0) {
     if (i18) {
      i12 = 2;
      break;
     }
     if ((i17 | 0) != 3) {
      i12 = 2;
      break;
     }
     HEAPF64[tempDoublePtr >> 3] = +HEAPF64[i14 >> 3];
     HEAP32[i9 >> 2] = HEAP32[tempDoublePtr >> 2];
     HEAP32[i9 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
     i18 = _luaS_newlstr(i7, i8, _sprintf(i8 | 0, 8936, i9 | 0) | 0) | 0;
     HEAP32[i14 >> 2] = i18;
     HEAP32[i12 >> 2] = HEAPU8[i18 + 4 | 0] | 0 | 64;
     i12 = 2;
     break;
    }
    if (i18 ? (HEAP32[(HEAP32[i14 >> 2] | 0) + 12 >> 2] | 0) == 0 : 0) {
     i16 = i13;
     i17 = HEAP32[i16 + 4 >> 2] | 0;
     i18 = i14;
     HEAP32[i18 >> 2] = HEAP32[i16 >> 2];
     HEAP32[i18 + 4 >> 2] = i17;
     HEAP32[i12 >> 2] = HEAP32[i15 >> 2];
     i12 = 2;
     break;
    }
    L19 : do {
     if ((i10 | 0) > 1) {
      i12 = 1;
      do {
       i15 = ~i12;
       i14 = i11 + (i15 << 4) | 0;
       i15 = i11 + (i15 << 4) + 8 | 0;
       i13 = HEAP32[i15 >> 2] | 0;
       if ((i13 & 15 | 0) != 4) {
        if ((i13 | 0) != 3) {
         break L19;
        }
        HEAPF64[tempDoublePtr >> 3] = +HEAPF64[i14 >> 3];
        HEAP32[i9 >> 2] = HEAP32[tempDoublePtr >> 2];
        HEAP32[i9 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
        i18 = _luaS_newlstr(i7, i8, _sprintf(i8 | 0, 8936, i9 | 0) | 0) | 0;
        HEAP32[i14 >> 2] = i18;
        HEAP32[i15 >> 2] = HEAPU8[i18 + 4 | 0] | 0 | 64;
       }
       i13 = HEAP32[(HEAP32[i14 >> 2] | 0) + 12 >> 2] | 0;
       if (!(i13 >>> 0 < (-3 - i16 | 0) >>> 0)) {
        i1 = 24;
        break L1;
       }
       i16 = i13 + i16 | 0;
       i12 = i12 + 1 | 0;
      } while ((i12 | 0) < (i10 | 0));
     } else {
      i12 = 1;
     }
    } while (0);
    i14 = _luaZ_openspace(i7, (HEAP32[i2 >> 2] | 0) + 144 | 0, i16) | 0;
    i15 = i12;
    i13 = 0;
    do {
     i17 = HEAP32[i11 + (0 - i15 << 4) >> 2] | 0;
     i18 = HEAP32[i17 + 12 >> 2] | 0;
     _memcpy(i14 + i13 | 0, i17 + 16 | 0, i18 | 0) | 0;
     i13 = i18 + i13 | 0;
     i15 = i15 + -1 | 0;
    } while ((i15 | 0) > 0);
    i18 = 0 - i12 | 0;
    i17 = _luaS_newlstr(i7, i14, i13) | 0;
    HEAP32[i11 + (i18 << 4) >> 2] = i17;
    HEAP32[i11 + (i18 << 4) + 8 >> 2] = HEAPU8[i17 + 4 | 0] | 0 | 64;
   } else {
    i1 = 7;
   }
  } while (0);
  if ((i1 | 0) == 7) {
   i1 = 0;
   i15 = _luaT_gettmbyobj(i7, i14, 15) | 0;
   if ((HEAP32[i15 + 8 >> 2] | 0) == 0) {
    i15 = _luaT_gettmbyobj(i7, i13, 15) | 0;
    if ((HEAP32[i15 + 8 >> 2] | 0) == 0) {
     i1 = 10;
     break;
    }
   }
   i18 = i14 - (HEAP32[i3 >> 2] | 0) | 0;
   i16 = HEAP32[i6 >> 2] | 0;
   HEAP32[i6 >> 2] = i16 + 16;
   i20 = i15;
   i19 = HEAP32[i20 + 4 >> 2] | 0;
   i17 = i16;
   HEAP32[i17 >> 2] = HEAP32[i20 >> 2];
   HEAP32[i17 + 4 >> 2] = i19;
   HEAP32[i16 + 8 >> 2] = HEAP32[i15 + 8 >> 2];
   i15 = HEAP32[i6 >> 2] | 0;
   HEAP32[i6 >> 2] = i15 + 16;
   i16 = i14;
   i17 = HEAP32[i16 + 4 >> 2] | 0;
   i14 = i15;
   HEAP32[i14 >> 2] = HEAP32[i16 >> 2];
   HEAP32[i14 + 4 >> 2] = i17;
   HEAP32[i15 + 8 >> 2] = HEAP32[i12 >> 2];
   i12 = HEAP32[i6 >> 2] | 0;
   HEAP32[i6 >> 2] = i12 + 16;
   i15 = i13;
   i14 = HEAP32[i15 + 4 >> 2] | 0;
   i17 = i12;
   HEAP32[i17 >> 2] = HEAP32[i15 >> 2];
   HEAP32[i17 + 4 >> 2] = i14;
   HEAP32[i12 + 8 >> 2] = HEAP32[i11 + -8 >> 2];
   _luaD_call(i7, (HEAP32[i6 >> 2] | 0) + -48 | 0, 1, HEAP8[(HEAP32[i4 >> 2] | 0) + 18 | 0] & 1);
   i12 = HEAP32[i3 >> 2] | 0;
   i17 = HEAP32[i6 >> 2] | 0;
   i14 = i17 + -16 | 0;
   HEAP32[i6 >> 2] = i14;
   i15 = HEAP32[i14 + 4 >> 2] | 0;
   i16 = i12 + i18 | 0;
   HEAP32[i16 >> 2] = HEAP32[i14 >> 2];
   HEAP32[i16 + 4 >> 2] = i15;
   HEAP32[i12 + (i18 + 8) >> 2] = HEAP32[i17 + -8 >> 2];
   i12 = 2;
  }
  i10 = i10 + 1 - i12 | 0;
  i11 = (HEAP32[i6 >> 2] | 0) + (1 - i12 << 4) | 0;
  HEAP32[i6 >> 2] = i11;
  if ((i10 | 0) <= 1) {
   i1 = 30;
   break;
  }
 }
 if ((i1 | 0) == 10) {
  _luaG_concaterror(i7, i14, i13);
 } else if ((i1 | 0) == 24) {
  _luaG_runerror(i7, 9e3, i9);
 } else if ((i1 | 0) == 30) {
  STACKTOP = i5;
  return;
 }
}
function _str_gsub(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0, i23 = 0, i24 = 0, i25 = 0, i26 = 0, i27 = 0, i28 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 1344 | 0;
 i4 = i3;
 i5 = i3 + 1336 | 0;
 i14 = i3 + 1332 | 0;
 i10 = i3 + 1328 | 0;
 i6 = i3 + 1048 | 0;
 i2 = i3 + 8 | 0;
 i20 = _luaL_checklstring(i1, 1, i14) | 0;
 i13 = _luaL_checklstring(i1, 2, i10) | 0;
 i8 = _lua_type(i1, 3) | 0;
 i9 = _luaL_optinteger(i1, 4, (HEAP32[i14 >> 2] | 0) + 1 | 0) | 0;
 i7 = (HEAP8[i13] | 0) == 94;
 if (!((i8 + -3 | 0) >>> 0 < 2 | (i8 | 0) == 6 | (i8 | 0) == 5)) {
  _luaL_argerror(i1, 3, 7528) | 0;
 }
 _luaL_buffinit(i1, i2);
 if (i7) {
  i15 = (HEAP32[i10 >> 2] | 0) + -1 | 0;
  HEAP32[i10 >> 2] = i15;
  i13 = i13 + 1 | 0;
 } else {
  i15 = HEAP32[i10 >> 2] | 0;
 }
 i11 = i6 + 16 | 0;
 HEAP32[i11 >> 2] = i1;
 HEAP32[i6 >> 2] = 200;
 i12 = i6 + 4 | 0;
 HEAP32[i12 >> 2] = i20;
 i10 = i6 + 8 | 0;
 HEAP32[i10 >> 2] = i20 + (HEAP32[i14 >> 2] | 0);
 HEAP32[i6 + 12 >> 2] = i13 + i15;
 i14 = i6 + 20 | 0;
 i15 = i2 + 8 | 0;
 i18 = i2 + 4 | 0;
 i16 = i6 + 28 | 0;
 i17 = i6 + 24 | 0;
 i22 = 0;
 while (1) {
  if (!(i22 >>> 0 < i9 >>> 0)) {
   i19 = 48;
   break;
  }
  HEAP32[i14 >> 2] = 0;
  i21 = _match(i6, i20, i13) | 0;
  if ((i21 | 0) != 0) {
   i22 = i22 + 1 | 0;
   i23 = HEAP32[i11 >> 2] | 0;
   if ((i8 | 0) == 5) {
    do {
     if ((HEAP32[i14 >> 2] | 0) > 0) {
      i24 = HEAP32[i16 >> 2] | 0;
      if (!((i24 | 0) == -1)) {
       i25 = HEAP32[i17 >> 2] | 0;
       if ((i24 | 0) == -2) {
        _lua_pushinteger(i23, i25 + 1 - (HEAP32[i12 >> 2] | 0) | 0);
        break;
       } else {
        i19 = i23;
       }
      } else {
       _luaL_error(i23, 7248, i4) | 0;
       i19 = HEAP32[i11 >> 2] | 0;
       i25 = HEAP32[i17 >> 2] | 0;
      }
      _lua_pushlstring(i19, i25, i24) | 0;
     } else {
      _lua_pushlstring(i23, i20, i21 - i20 | 0) | 0;
     }
    } while (0);
    _lua_gettable(i23, 3);
    i19 = 37;
   } else if ((i8 | 0) != 6) {
    i24 = _lua_tolstring(i23, 3, i5) | 0;
    if ((HEAP32[i5 >> 2] | 0) != 0) {
     i23 = i21 - i20 | 0;
     i25 = 0;
     do {
      i26 = i24 + i25 | 0;
      i27 = HEAP8[i26] | 0;
      do {
       if (i27 << 24 >> 24 == 37) {
        i25 = i25 + 1 | 0;
        i26 = i24 + i25 | 0;
        i28 = HEAP8[i26] | 0;
        i27 = i28 << 24 >> 24;
        if (((i28 & 255) + -48 | 0) >>> 0 < 10) {
         if (i28 << 24 >> 24 == 48) {
          _luaL_addlstring(i2, i20, i23);
          break;
         } else {
          _push_onecapture(i6, i27 + -49 | 0, i20, i21);
          _luaL_addvalue(i2);
          break;
         }
        }
        if (!(i28 << 24 >> 24 == 37)) {
         i28 = HEAP32[i11 >> 2] | 0;
         HEAP32[i4 >> 2] = 37;
         _luaL_error(i28, 7600, i4) | 0;
        }
        i27 = HEAP32[i15 >> 2] | 0;
        if (!(i27 >>> 0 < (HEAP32[i18 >> 2] | 0) >>> 0)) {
         _luaL_prepbuffsize(i2, 1) | 0;
         i27 = HEAP32[i15 >> 2] | 0;
        }
        i28 = HEAP8[i26] | 0;
        HEAP32[i15 >> 2] = i27 + 1;
        HEAP8[(HEAP32[i2 >> 2] | 0) + i27 | 0] = i28;
       } else {
        i28 = HEAP32[i15 >> 2] | 0;
        if (!(i28 >>> 0 < (HEAP32[i18 >> 2] | 0) >>> 0)) {
         _luaL_prepbuffsize(i2, 1) | 0;
         i28 = HEAP32[i15 >> 2] | 0;
         i27 = HEAP8[i26] | 0;
        }
        HEAP32[i15 >> 2] = i28 + 1;
        HEAP8[(HEAP32[i2 >> 2] | 0) + i28 | 0] = i27;
       }
      } while (0);
      i25 = i25 + 1 | 0;
     } while (i25 >>> 0 < (HEAP32[i5 >> 2] | 0) >>> 0);
    }
   } else {
    _lua_pushvalue(i23, 3);
    i19 = HEAP32[i14 >> 2] | 0;
    i19 = (i19 | 0) != 0 | (i20 | 0) == 0 ? i19 : 1;
    _luaL_checkstack(HEAP32[i11 >> 2] | 0, i19, 7200);
    if ((i19 | 0) > 0) {
     i24 = 0;
     do {
      _push_onecapture(i6, i24, i20, i21);
      i24 = i24 + 1 | 0;
     } while ((i24 | 0) != (i19 | 0));
    }
    _lua_callk(i23, i19, 1, 0, 0);
    i19 = 37;
   }
   if ((i19 | 0) == 37) {
    i19 = 0;
    if ((_lua_toboolean(i23, -1) | 0) != 0) {
     if ((_lua_isstring(i23, -1) | 0) == 0) {
      HEAP32[i4 >> 2] = _lua_typename(i23, _lua_type(i23, -1) | 0) | 0;
      _luaL_error(i23, 7560, i4) | 0;
     }
    } else {
     _lua_settop(i23, -2);
     _lua_pushlstring(i23, i20, i21 - i20 | 0) | 0;
    }
    _luaL_addvalue(i2);
   }
   if (i21 >>> 0 > i20 >>> 0) {
    i20 = i21;
   } else {
    i19 = 43;
   }
  } else {
   i19 = 43;
  }
  if ((i19 | 0) == 43) {
   i19 = 0;
   if (!(i20 >>> 0 < (HEAP32[i10 >> 2] | 0) >>> 0)) {
    i19 = 48;
    break;
   }
   i21 = HEAP32[i15 >> 2] | 0;
   if (!(i21 >>> 0 < (HEAP32[i18 >> 2] | 0) >>> 0)) {
    _luaL_prepbuffsize(i2, 1) | 0;
    i21 = HEAP32[i15 >> 2] | 0;
   }
   i28 = HEAP8[i20] | 0;
   HEAP32[i15 >> 2] = i21 + 1;
   HEAP8[(HEAP32[i2 >> 2] | 0) + i21 | 0] = i28;
   i20 = i20 + 1 | 0;
  }
  if (i7) {
   i19 = 48;
   break;
  }
 }
 if ((i19 | 0) == 48) {
  _luaL_addlstring(i2, i20, (HEAP32[i10 >> 2] | 0) - i20 | 0);
  _luaL_pushresult(i2);
  _lua_pushinteger(i1, i22);
  STACKTOP = i3;
  return 2;
 }
 return 0;
}
function _constructor(i11, i13) {
 i11 = i11 | 0;
 i13 = i13 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i12 = 0, i14 = 0, i15 = 0, i16 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i10 = i5 + 40 | 0;
 i8 = i5;
 i12 = i11 + 48 | 0;
 i6 = HEAP32[i12 >> 2] | 0;
 i9 = HEAP32[i11 + 4 >> 2] | 0;
 i2 = _luaK_codeABC(i6, 11, 0, 0, 0) | 0;
 i7 = i8 + 36 | 0;
 HEAP32[i7 >> 2] = 0;
 i4 = i8 + 28 | 0;
 HEAP32[i4 >> 2] = 0;
 i3 = i8 + 32 | 0;
 HEAP32[i3 >> 2] = 0;
 i1 = i8 + 24 | 0;
 HEAP32[i1 >> 2] = i13;
 HEAP32[i13 + 16 >> 2] = -1;
 HEAP32[i13 + 20 >> 2] = -1;
 HEAP32[i13 >> 2] = 11;
 HEAP32[i13 + 8 >> 2] = i2;
 HEAP32[i8 + 16 >> 2] = -1;
 HEAP32[i8 + 20 >> 2] = -1;
 HEAP32[i8 >> 2] = 0;
 HEAP32[i8 + 8 >> 2] = 0;
 _luaK_exp2nextreg(HEAP32[i12 >> 2] | 0, i13);
 i13 = i11 + 16 | 0;
 if ((HEAP32[i13 >> 2] | 0) != 123) {
  _error_expected(i11, 123);
 }
 _luaX_next(i11);
 L4 : do {
  if ((HEAP32[i13 >> 2] | 0) != 125) {
   L5 : while (1) {
    if ((HEAP32[i8 >> 2] | 0) != 0 ? (_luaK_exp2nextreg(i6, i8), HEAP32[i8 >> 2] = 0, (HEAP32[i7 >> 2] | 0) == 50) : 0) {
     _luaK_setlist(i6, HEAP32[(HEAP32[i1 >> 2] | 0) + 8 >> 2] | 0, HEAP32[i3 >> 2] | 0, 50);
     HEAP32[i7 >> 2] = 0;
    }
    i14 = HEAP32[i13 >> 2] | 0;
    do {
     if ((i14 | 0) == 288) {
      if ((_luaX_lookahead(i11) | 0) == 61) {
       _recfield(i11, i8);
       break;
      }
      _subexpr(i11, i8, 0) | 0;
      i14 = HEAP32[i12 >> 2] | 0;
      i15 = HEAP32[i3 >> 2] | 0;
      if ((i15 | 0) > 2147483645) {
       i12 = 10;
       break L5;
      }
      HEAP32[i3 >> 2] = i15 + 1;
      HEAP32[i7 >> 2] = (HEAP32[i7 >> 2] | 0) + 1;
     } else if ((i14 | 0) == 91) {
      _recfield(i11, i8);
     } else {
      _subexpr(i11, i8, 0) | 0;
      i14 = HEAP32[i12 >> 2] | 0;
      i15 = HEAP32[i3 >> 2] | 0;
      if ((i15 | 0) > 2147483645) {
       i12 = 17;
       break L5;
      }
      HEAP32[i3 >> 2] = i15 + 1;
      HEAP32[i7 >> 2] = (HEAP32[i7 >> 2] | 0) + 1;
     }
    } while (0);
    i14 = HEAP32[i13 >> 2] | 0;
    if ((i14 | 0) == 44) {
     _luaX_next(i11);
    } else if ((i14 | 0) == 59) {
     _luaX_next(i11);
    } else {
     break L4;
    }
    if ((HEAP32[i13 >> 2] | 0) == 125) {
     break L4;
    }
   }
   if ((i12 | 0) == 10) {
    i12 = i14 + 12 | 0;
    i13 = HEAP32[(HEAP32[i12 >> 2] | 0) + 52 >> 2] | 0;
    i14 = HEAP32[(HEAP32[i14 >> 2] | 0) + 64 >> 2] | 0;
    if ((i14 | 0) == 0) {
     i16 = 6552;
     HEAP32[i10 >> 2] = 6528;
     i15 = i10 + 4 | 0;
     HEAP32[i15 >> 2] = 2147483645;
     i15 = i10 + 8 | 0;
     HEAP32[i15 >> 2] = i16;
     i15 = _luaO_pushfstring(i13, 6592, i10) | 0;
     i16 = HEAP32[i12 >> 2] | 0;
     _luaX_syntaxerror(i16, i15);
    }
    HEAP32[i10 >> 2] = i14;
    i15 = _luaO_pushfstring(i13, 6568, i10) | 0;
    HEAP32[i10 >> 2] = 6528;
    i16 = i10 + 4 | 0;
    HEAP32[i16 >> 2] = 2147483645;
    i16 = i10 + 8 | 0;
    HEAP32[i16 >> 2] = i15;
    i16 = _luaO_pushfstring(i13, 6592, i10) | 0;
    i15 = HEAP32[i12 >> 2] | 0;
    _luaX_syntaxerror(i15, i16);
   } else if ((i12 | 0) == 17) {
    i13 = i14 + 12 | 0;
    i12 = HEAP32[(HEAP32[i13 >> 2] | 0) + 52 >> 2] | 0;
    i14 = HEAP32[(HEAP32[i14 >> 2] | 0) + 64 >> 2] | 0;
    if ((i14 | 0) == 0) {
     i15 = 6552;
     HEAP32[i10 >> 2] = 6528;
     i16 = i10 + 4 | 0;
     HEAP32[i16 >> 2] = 2147483645;
     i16 = i10 + 8 | 0;
     HEAP32[i16 >> 2] = i15;
     i16 = _luaO_pushfstring(i12, 6592, i10) | 0;
     i15 = HEAP32[i13 >> 2] | 0;
     _luaX_syntaxerror(i15, i16);
    }
    HEAP32[i10 >> 2] = i14;
    i15 = _luaO_pushfstring(i12, 6568, i10) | 0;
    HEAP32[i10 >> 2] = 6528;
    i16 = i10 + 4 | 0;
    HEAP32[i16 >> 2] = 2147483645;
    i16 = i10 + 8 | 0;
    HEAP32[i16 >> 2] = i15;
    i16 = _luaO_pushfstring(i12, 6592, i10) | 0;
    i15 = HEAP32[i13 >> 2] | 0;
    _luaX_syntaxerror(i15, i16);
   }
  }
 } while (0);
 _check_match(i11, 125, 123, i9);
 i9 = HEAP32[i7 >> 2] | 0;
 do {
  if ((i9 | 0) != 0) {
   i10 = HEAP32[i8 >> 2] | 0;
   if ((i10 | 0) != 0) if ((i10 | 0) == 13 | (i10 | 0) == 12) {
    _luaK_setreturns(i6, i8, -1);
    _luaK_setlist(i6, HEAP32[(HEAP32[i1 >> 2] | 0) + 8 >> 2] | 0, HEAP32[i3 >> 2] | 0, -1);
    HEAP32[i3 >> 2] = (HEAP32[i3 >> 2] | 0) + -1;
    break;
   } else {
    _luaK_exp2nextreg(i6, i8);
    i9 = HEAP32[i7 >> 2] | 0;
   }
   _luaK_setlist(i6, HEAP32[(HEAP32[i1 >> 2] | 0) + 8 >> 2] | 0, HEAP32[i3 >> 2] | 0, i9);
  }
 } while (0);
 i16 = HEAP32[(HEAP32[(HEAP32[i6 >> 2] | 0) + 12 >> 2] | 0) + (i2 << 2) >> 2] & 8388607;
 i16 = (_luaO_int2fb(HEAP32[i3 >> 2] | 0) | 0) << 23 | i16;
 HEAP32[(HEAP32[(HEAP32[i6 >> 2] | 0) + 12 >> 2] | 0) + (i2 << 2) >> 2] = i16;
 i16 = (_luaO_int2fb(HEAP32[i4 >> 2] | 0) | 0) << 14 & 8372224 | i16 & -8372225;
 HEAP32[(HEAP32[(HEAP32[i6 >> 2] | 0) + 12 >> 2] | 0) + (i2 << 2) >> 2] = i16;
 STACKTOP = i5;
 return;
}
function _luaK_prefix(i4, i14, i7, i13) {
 i4 = i4 | 0;
 i14 = i14 | 0;
 i7 = i7 | 0;
 i13 = i13 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i5 = 0, i6 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i12 = i1;
 HEAP32[i12 + 20 >> 2] = -1;
 HEAP32[i12 + 16 >> 2] = -1;
 HEAP32[i12 >> 2] = 5;
 HEAPF64[i12 + 8 >> 3] = 0.0;
 if ((i14 | 0) == 1) {
  _luaK_dischargevars(i4, i7);
  switch (HEAP32[i7 >> 2] | 0) {
  case 2:
  case 5:
  case 4:
   {
    HEAP32[i7 >> 2] = 3;
    break;
   }
  case 10:
   {
    i13 = HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0;
    i12 = HEAP32[i7 + 8 >> 2] | 0;
    i10 = i13 + (i12 << 2) | 0;
    if (!((i12 | 0) > 0 ? (i11 = i13 + (i12 + -1 << 2) | 0, i9 = HEAP32[i11 >> 2] | 0, (HEAP8[5584 + (i9 & 63) | 0] | 0) < 0) : 0)) {
     i11 = i10;
     i9 = HEAP32[i10 >> 2] | 0;
    }
    HEAP32[i11 >> 2] = ((i9 & 16320 | 0) == 0) << 6 | i9 & -16321;
    break;
   }
  case 6:
   {
    i8 = 25;
    break;
   }
  case 3:
  case 1:
   {
    HEAP32[i7 >> 2] = 2;
    break;
   }
  case 11:
   {
    i12 = i4 + 48 | 0;
    i8 = HEAP8[i12] | 0;
    i11 = (i8 & 255) + 1 | 0;
    i9 = (HEAP32[i4 >> 2] | 0) + 78 | 0;
    do {
     if (i11 >>> 0 > (HEAPU8[i9] | 0) >>> 0) {
      if (i11 >>> 0 > 249) {
       _luaX_syntaxerror(HEAP32[i4 + 12 >> 2] | 0, 10536);
      } else {
       HEAP8[i9] = i11;
       i10 = HEAP8[i12] | 0;
       break;
      }
     } else {
      i10 = i8;
     }
    } while (0);
    i14 = (i10 & 255) + 1 | 0;
    HEAP8[i12] = i14;
    _discharge2reg(i4, i7, (i14 & 255) + -1 | 0);
    if ((HEAP32[i7 >> 2] | 0) == 6) {
     i8 = 25;
    } else {
     i9 = i7 + 8 | 0;
     i8 = 28;
    }
    break;
   }
  default:
   {}
  }
  if ((i8 | 0) == 25) {
   i8 = i7 + 8 | 0;
   i9 = HEAP32[i8 >> 2] | 0;
   if ((i9 & 256 | 0) == 0 ? (HEAPU8[i4 + 46 | 0] | 0) <= (i9 | 0) : 0) {
    i9 = i4 + 48 | 0;
    HEAP8[i9] = (HEAP8[i9] | 0) + -1 << 24 >> 24;
    i9 = i8;
    i8 = 28;
   } else {
    i9 = i8;
    i8 = 28;
   }
  }
  if ((i8 | 0) == 28) {
   HEAP32[i9 >> 2] = _luaK_code(i4, HEAP32[i9 >> 2] << 23 | 20) | 0;
   HEAP32[i7 >> 2] = 11;
  }
  i14 = i7 + 20 | 0;
  i8 = HEAP32[i14 >> 2] | 0;
  i7 = i7 + 16 | 0;
  i9 = HEAP32[i7 >> 2] | 0;
  HEAP32[i14 >> 2] = i9;
  HEAP32[i7 >> 2] = i8;
  if (!((i9 | 0) == -1)) {
   i8 = HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0;
   do {
    i12 = i8 + (i9 << 2) | 0;
    if ((i9 | 0) > 0 ? (i5 = i8 + (i9 + -1 << 2) | 0, i6 = HEAP32[i5 >> 2] | 0, (HEAP8[5584 + (i6 & 63) | 0] | 0) < 0) : 0) {
     i10 = i5;
     i11 = i6;
    } else {
     i10 = i12;
     i11 = HEAP32[i12 >> 2] | 0;
    }
    if ((i11 & 63 | 0) == 28) {
     HEAP32[i10 >> 2] = i11 & 8372224 | i11 >>> 23 << 6 | 27;
    }
    i10 = ((HEAP32[i12 >> 2] | 0) >>> 14) + -131071 | 0;
    if ((i10 | 0) == -1) {
     break;
    }
    i9 = i9 + 1 + i10 | 0;
   } while (!((i9 | 0) == -1));
   i8 = HEAP32[i7 >> 2] | 0;
  }
  if ((i8 | 0) == -1) {
   STACKTOP = i1;
   return;
  }
  i4 = HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0;
  while (1) {
   i6 = i4 + (i8 << 2) | 0;
   if ((i8 | 0) > 0 ? (i2 = i4 + (i8 + -1 << 2) | 0, i3 = HEAP32[i2 >> 2] | 0, (HEAP8[5584 + (i3 & 63) | 0] | 0) < 0) : 0) {
    i7 = i2;
    i5 = i3;
   } else {
    i7 = i6;
    i5 = HEAP32[i6 >> 2] | 0;
   }
   if ((i5 & 63 | 0) == 28) {
    HEAP32[i7 >> 2] = i5 & 8372224 | i5 >>> 23 << 6 | 27;
   }
   i5 = ((HEAP32[i6 >> 2] | 0) >>> 14) + -131071 | 0;
   if ((i5 | 0) == -1) {
    i8 = 54;
    break;
   }
   i8 = i8 + 1 + i5 | 0;
   if ((i8 | 0) == -1) {
    i8 = 54;
    break;
   }
  }
  if ((i8 | 0) == 54) {
   STACKTOP = i1;
   return;
  }
 } else if ((i14 | 0) == 0) {
  if (((HEAP32[i7 >> 2] | 0) == 5 ? (HEAP32[i7 + 16 >> 2] | 0) == -1 : 0) ? (HEAP32[i7 + 20 >> 2] | 0) == -1 : 0) {
   i14 = i7 + 8 | 0;
   HEAPF64[i14 >> 3] = -+HEAPF64[i14 >> 3];
   STACKTOP = i1;
   return;
  }
  _luaK_dischargevars(i4, i7);
  if ((HEAP32[i7 >> 2] | 0) == 6) {
   i2 = HEAP32[i7 + 8 >> 2] | 0;
   if ((HEAP32[i7 + 16 >> 2] | 0) != (HEAP32[i7 + 20 >> 2] | 0)) {
    if ((i2 | 0) < (HEAPU8[i4 + 46 | 0] | 0)) {
     i8 = 10;
    } else {
     _exp2reg(i4, i7, i2);
    }
   }
  } else {
   i8 = 10;
  }
  if ((i8 | 0) == 10) {
   _luaK_exp2nextreg(i4, i7);
  }
  _codearith(i4, 19, i7, i12, i13);
  STACKTOP = i1;
  return;
 } else if ((i14 | 0) == 2) {
  _luaK_dischargevars(i4, i7);
  if ((HEAP32[i7 >> 2] | 0) == 6) {
   i2 = HEAP32[i7 + 8 >> 2] | 0;
   if ((HEAP32[i7 + 16 >> 2] | 0) != (HEAP32[i7 + 20 >> 2] | 0)) {
    if ((i2 | 0) < (HEAPU8[i4 + 46 | 0] | 0)) {
     i8 = 52;
    } else {
     _exp2reg(i4, i7, i2);
    }
   }
  } else {
   i8 = 52;
  }
  if ((i8 | 0) == 52) {
   _luaK_exp2nextreg(i4, i7);
  }
  _codearith(i4, 21, i7, i12, i13);
  STACKTOP = i1;
  return;
 } else {
  STACKTOP = i1;
  return;
 }
}
function _subexpr(i6, i3, i7) {
 i6 = i6 | 0;
 i3 = i3 | 0;
 i7 = i7 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 48 | 0;
 i11 = i2 + 24 | 0;
 i5 = i2;
 i4 = i6 + 48 | 0;
 i9 = HEAP32[i4 >> 2] | 0;
 i1 = i6 + 52 | 0;
 i12 = (HEAP32[i1 >> 2] | 0) + 38 | 0;
 i13 = (HEAP16[i12 >> 1] | 0) + 1 << 16 >> 16;
 HEAP16[i12 >> 1] = i13;
 if ((i13 & 65535) > 200) {
  i10 = i9 + 12 | 0;
  i12 = HEAP32[(HEAP32[i10 >> 2] | 0) + 52 >> 2] | 0;
  i13 = HEAP32[(HEAP32[i9 >> 2] | 0) + 64 >> 2] | 0;
  if ((i13 | 0) == 0) {
   i15 = 6552;
   HEAP32[i11 >> 2] = 6360;
   i14 = i11 + 4 | 0;
   HEAP32[i14 >> 2] = 200;
   i14 = i11 + 8 | 0;
   HEAP32[i14 >> 2] = i15;
   i14 = _luaO_pushfstring(i12, 6592, i11) | 0;
   i15 = HEAP32[i10 >> 2] | 0;
   _luaX_syntaxerror(i15, i14);
  }
  HEAP32[i11 >> 2] = i13;
  i14 = _luaO_pushfstring(i12, 6568, i11) | 0;
  HEAP32[i11 >> 2] = 6360;
  i15 = i11 + 4 | 0;
  HEAP32[i15 >> 2] = 200;
  i15 = i11 + 8 | 0;
  HEAP32[i15 >> 2] = i14;
  i15 = _luaO_pushfstring(i12, 6592, i11) | 0;
  i14 = HEAP32[i10 >> 2] | 0;
  _luaX_syntaxerror(i14, i15);
 }
 i10 = i6 + 16 | 0;
 L8 : do {
  switch (HEAP32[i10 >> 2] | 0) {
  case 287:
   {
    HEAP32[i3 + 16 >> 2] = -1;
    HEAP32[i3 + 20 >> 2] = -1;
    HEAP32[i3 >> 2] = 5;
    HEAP32[i3 + 8 >> 2] = 0;
    HEAPF64[i3 + 8 >> 3] = +HEAPF64[i6 + 24 >> 3];
    i8 = 20;
    break;
   }
  case 271:
   {
    i9 = 1;
    i8 = 8;
    break;
   }
  case 289:
   {
    i8 = _luaK_stringK(i9, HEAP32[i6 + 24 >> 2] | 0) | 0;
    HEAP32[i3 + 16 >> 2] = -1;
    HEAP32[i3 + 20 >> 2] = -1;
    HEAP32[i3 >> 2] = 4;
    HEAP32[i3 + 8 >> 2] = i8;
    i8 = 20;
    break;
   }
  case 265:
   {
    _luaX_next(i6);
    _body(i6, i3, 0, HEAP32[i6 + 4 >> 2] | 0);
    break;
   }
  case 276:
   {
    HEAP32[i3 + 16 >> 2] = -1;
    HEAP32[i3 + 20 >> 2] = -1;
    HEAP32[i3 >> 2] = 2;
    HEAP32[i3 + 8 >> 2] = 0;
    i8 = 20;
    break;
   }
  case 45:
   {
    i9 = 0;
    i8 = 8;
    break;
   }
  case 35:
   {
    i9 = 2;
    i8 = 8;
    break;
   }
  case 123:
   {
    _constructor(i6, i3);
    break;
   }
  case 263:
   {
    HEAP32[i3 + 16 >> 2] = -1;
    HEAP32[i3 + 20 >> 2] = -1;
    HEAP32[i3 >> 2] = 3;
    HEAP32[i3 + 8 >> 2] = 0;
    i8 = 20;
    break;
   }
  case 280:
   {
    if ((HEAP8[(HEAP32[i9 >> 2] | 0) + 77 | 0] | 0) == 0) {
     _luaX_syntaxerror(i6, 6408);
    } else {
     i8 = _luaK_codeABC(i9, 38, 0, 1, 0) | 0;
     HEAP32[i3 + 16 >> 2] = -1;
     HEAP32[i3 + 20 >> 2] = -1;
     HEAP32[i3 >> 2] = 13;
     HEAP32[i3 + 8 >> 2] = i8;
     i8 = 20;
     break L8;
    }
    break;
   }
  case 270:
   {
    HEAP32[i3 + 16 >> 2] = -1;
    HEAP32[i3 + 20 >> 2] = -1;
    HEAP32[i3 >> 2] = 1;
    HEAP32[i3 + 8 >> 2] = 0;
    i8 = 20;
    break;
   }
  default:
   {
    _suffixedexp(i6, i3);
   }
  }
 } while (0);
 if ((i8 | 0) == 8) {
  i15 = HEAP32[i6 + 4 >> 2] | 0;
  _luaX_next(i6);
  _subexpr(i6, i3, 8) | 0;
  _luaK_prefix(HEAP32[i4 >> 2] | 0, i9, i3, i15);
 } else if ((i8 | 0) == 20) {
  _luaX_next(i6);
 }
 switch (HEAP32[i10 >> 2] | 0) {
 case 257:
  {
   i9 = 13;
   break;
  }
 case 272:
  {
   i9 = 14;
   break;
  }
 case 47:
  {
   i9 = 3;
   break;
  }
 case 37:
  {
   i9 = 4;
   break;
  }
 case 43:
  {
   i9 = 0;
   break;
  }
 case 284:
  {
   i9 = 10;
   break;
  }
 case 281:
  {
   i9 = 7;
   break;
  }
 case 62:
  {
   i9 = 11;
   break;
  }
 case 282:
  {
   i9 = 12;
   break;
  }
 case 45:
  {
   i9 = 1;
   break;
  }
 case 42:
  {
   i9 = 2;
   break;
  }
 case 60:
  {
   i9 = 8;
   break;
  }
 case 283:
  {
   i9 = 9;
   break;
  }
 case 94:
  {
   i9 = 5;
   break;
  }
 case 279:
  {
   i9 = 6;
   break;
  }
 default:
  {
   i15 = 15;
   i14 = HEAP32[i1 >> 2] | 0;
   i14 = i14 + 38 | 0;
   i13 = HEAP16[i14 >> 1] | 0;
   i13 = i13 + -1 << 16 >> 16;
   HEAP16[i14 >> 1] = i13;
   STACKTOP = i2;
   return i15 | 0;
  }
 }
 i8 = i6 + 4 | 0;
 while (1) {
  if ((HEAPU8[6376 + (i9 << 1) | 0] | 0) <= (i7 | 0)) {
   i8 = 39;
   break;
  }
  i15 = HEAP32[i8 >> 2] | 0;
  _luaX_next(i6);
  _luaK_infix(HEAP32[i4 >> 2] | 0, i9, i3);
  i10 = _subexpr(i6, i5, HEAPU8[6377 + (i9 << 1) | 0] | 0) | 0;
  _luaK_posfix(HEAP32[i4 >> 2] | 0, i9, i3, i5, i15);
  if ((i10 | 0) == 15) {
   i9 = 15;
   i8 = 39;
   break;
  } else {
   i9 = i10;
  }
 }
 if ((i8 | 0) == 39) {
  i15 = HEAP32[i1 >> 2] | 0;
  i15 = i15 + 38 | 0;
  i14 = HEAP16[i15 >> 1] | 0;
  i14 = i14 + -1 << 16 >> 16;
  HEAP16[i15 >> 1] = i14;
  STACKTOP = i2;
  return i9 | 0;
 }
 return 0;
}
function _luaV_lessequal(i5, i3, i2) {
 i5 = i5 | 0;
 i3 = i3 | 0;
 i2 = i2 | 0;
 var i1 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i1 = STACKTOP;
 i4 = i3 + 8 | 0;
 i7 = HEAP32[i4 >> 2] | 0;
 if ((i7 | 0) == 3) {
  if ((HEAP32[i2 + 8 >> 2] | 0) == 3) {
   i9 = +HEAPF64[i3 >> 3] <= +HEAPF64[i2 >> 3] | 0;
   STACKTOP = i1;
   return i9 | 0;
  }
 } else {
  if ((i7 & 15 | 0) == 4 ? (HEAP32[i2 + 8 >> 2] & 15 | 0) == 4 : 0) {
   i3 = HEAP32[i3 >> 2] | 0;
   i6 = HEAP32[i2 >> 2] | 0;
   i4 = i3 + 16 | 0;
   i5 = i6 + 16 | 0;
   i7 = _strcmp(i4, i5) | 0;
   L8 : do {
    if ((i7 | 0) == 0) {
     i2 = HEAP32[i3 + 12 >> 2] | 0;
     i3 = HEAP32[i6 + 12 >> 2] | 0;
     i6 = i5;
     while (1) {
      i5 = _strlen(i4 | 0) | 0;
      i7 = (i5 | 0) == (i2 | 0);
      if ((i5 | 0) == (i3 | 0)) {
       break;
      }
      if (i7) {
       i7 = -1;
       break L8;
      }
      i5 = i5 + 1 | 0;
      i4 = i4 + i5 | 0;
      i6 = i6 + i5 | 0;
      i7 = _strcmp(i4, i6) | 0;
      if ((i7 | 0) == 0) {
       i2 = i2 - i5 | 0;
       i3 = i3 - i5 | 0;
      } else {
       break L8;
      }
     }
     i7 = i7 & 1 ^ 1;
    }
   } while (0);
   i9 = (i7 | 0) < 1 | 0;
   STACKTOP = i1;
   return i9 | 0;
  }
 }
 i7 = i5 + 8 | 0;
 i8 = HEAP32[i7 >> 2] | 0;
 i9 = _luaT_gettmbyobj(i5, i3, 14) | 0;
 if ((HEAP32[i9 + 8 >> 2] | 0) == 0) {
  i9 = _luaT_gettmbyobj(i5, i2, 14) | 0;
  if ((HEAP32[i9 + 8 >> 2] | 0) == 0) {
   i8 = HEAP32[i7 >> 2] | 0;
   i9 = _luaT_gettmbyobj(i5, i2, 13) | 0;
   if ((HEAP32[i9 + 8 >> 2] | 0) == 0) {
    i9 = _luaT_gettmbyobj(i5, i3, 13) | 0;
    if ((HEAP32[i9 + 8 >> 2] | 0) == 0) {
     _luaG_ordererror(i5, i3, i2);
    } else {
     i6 = i9;
    }
   } else {
    i6 = i9;
   }
   i10 = i5 + 28 | 0;
   i9 = i8 - (HEAP32[i10 >> 2] | 0) | 0;
   i8 = HEAP32[i7 >> 2] | 0;
   HEAP32[i7 >> 2] = i8 + 16;
   i13 = i6;
   i11 = HEAP32[i13 + 4 >> 2] | 0;
   i12 = i8;
   HEAP32[i12 >> 2] = HEAP32[i13 >> 2];
   HEAP32[i12 + 4 >> 2] = i11;
   HEAP32[i8 + 8 >> 2] = HEAP32[i6 + 8 >> 2];
   i8 = HEAP32[i7 >> 2] | 0;
   HEAP32[i7 >> 2] = i8 + 16;
   i12 = i2;
   i11 = HEAP32[i12 + 4 >> 2] | 0;
   i6 = i8;
   HEAP32[i6 >> 2] = HEAP32[i12 >> 2];
   HEAP32[i6 + 4 >> 2] = i11;
   HEAP32[i8 + 8 >> 2] = HEAP32[i2 + 8 >> 2];
   i2 = HEAP32[i7 >> 2] | 0;
   HEAP32[i7 >> 2] = i2 + 16;
   i8 = i3;
   i6 = HEAP32[i8 + 4 >> 2] | 0;
   i3 = i2;
   HEAP32[i3 >> 2] = HEAP32[i8 >> 2];
   HEAP32[i3 + 4 >> 2] = i6;
   HEAP32[i2 + 8 >> 2] = HEAP32[i4 >> 2];
   _luaD_call(i5, (HEAP32[i7 >> 2] | 0) + -48 | 0, 1, HEAP8[(HEAP32[i5 + 16 >> 2] | 0) + 18 | 0] & 1);
   i3 = HEAP32[i10 >> 2] | 0;
   i2 = HEAP32[i7 >> 2] | 0;
   i5 = i2 + -16 | 0;
   HEAP32[i7 >> 2] = i5;
   i6 = HEAP32[i5 + 4 >> 2] | 0;
   i8 = i3 + i9 | 0;
   HEAP32[i8 >> 2] = HEAP32[i5 >> 2];
   HEAP32[i8 + 4 >> 2] = i6;
   HEAP32[i3 + (i9 + 8) >> 2] = HEAP32[i2 + -8 >> 2];
   i3 = HEAP32[i7 >> 2] | 0;
   i2 = HEAP32[i3 + 8 >> 2] | 0;
   if ((i2 | 0) != 0) {
    if ((i2 | 0) == 1) {
     i2 = (HEAP32[i3 >> 2] | 0) != 0;
    } else {
     i2 = 1;
    }
   } else {
    i2 = 0;
   }
   i13 = i2 & 1 ^ 1;
   STACKTOP = i1;
   return i13 | 0;
  }
 }
 i10 = i5 + 28 | 0;
 i13 = i8 - (HEAP32[i10 >> 2] | 0) | 0;
 i11 = HEAP32[i7 >> 2] | 0;
 HEAP32[i7 >> 2] = i11 + 16;
 i6 = i9;
 i8 = HEAP32[i6 + 4 >> 2] | 0;
 i12 = i11;
 HEAP32[i12 >> 2] = HEAP32[i6 >> 2];
 HEAP32[i12 + 4 >> 2] = i8;
 HEAP32[i11 + 8 >> 2] = HEAP32[i9 + 8 >> 2];
 i9 = HEAP32[i7 >> 2] | 0;
 HEAP32[i7 >> 2] = i9 + 16;
 i11 = i3;
 i12 = HEAP32[i11 + 4 >> 2] | 0;
 i3 = i9;
 HEAP32[i3 >> 2] = HEAP32[i11 >> 2];
 HEAP32[i3 + 4 >> 2] = i12;
 HEAP32[i9 + 8 >> 2] = HEAP32[i4 >> 2];
 i3 = HEAP32[i7 >> 2] | 0;
 HEAP32[i7 >> 2] = i3 + 16;
 i9 = i2;
 i12 = HEAP32[i9 + 4 >> 2] | 0;
 i11 = i3;
 HEAP32[i11 >> 2] = HEAP32[i9 >> 2];
 HEAP32[i11 + 4 >> 2] = i12;
 HEAP32[i3 + 8 >> 2] = HEAP32[i2 + 8 >> 2];
 _luaD_call(i5, (HEAP32[i7 >> 2] | 0) + -48 | 0, 1, HEAP8[(HEAP32[i5 + 16 >> 2] | 0) + 18 | 0] & 1);
 i2 = HEAP32[i10 >> 2] | 0;
 i3 = HEAP32[i7 >> 2] | 0;
 i10 = i3 + -16 | 0;
 HEAP32[i7 >> 2] = i10;
 i11 = HEAP32[i10 + 4 >> 2] | 0;
 i12 = i2 + i13 | 0;
 HEAP32[i12 >> 2] = HEAP32[i10 >> 2];
 HEAP32[i12 + 4 >> 2] = i11;
 HEAP32[i2 + (i13 + 8) >> 2] = HEAP32[i3 + -8 >> 2];
 i2 = HEAP32[i7 >> 2] | 0;
 i3 = HEAP32[i2 + 8 >> 2] | 0;
 if ((i3 | 0) != 0) {
  if ((i3 | 0) == 1) {
   i2 = (HEAP32[i2 >> 2] | 0) != 0;
  } else {
   i2 = 1;
  }
 } else {
  i2 = 0;
 }
 i13 = i2 & 1;
 STACKTOP = i1;
 return i13 | 0;
}
function ___udivmoddi4(i6, i8, i2, i4, i1) {
 i6 = i6 | 0;
 i8 = i8 | 0;
 i2 = i2 | 0;
 i4 = i4 | 0;
 i1 = i1 | 0;
 var i3 = 0, i5 = 0, i7 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0;
 i5 = i6;
 i9 = i8;
 i7 = i9;
 i10 = i2;
 i3 = i4;
 i11 = i3;
 if ((i7 | 0) == 0) {
  i2 = (i1 | 0) != 0;
  if ((i11 | 0) == 0) {
   if (i2) {
    HEAP32[i1 >> 2] = (i5 >>> 0) % (i10 >>> 0);
    HEAP32[i1 + 4 >> 2] = 0;
   }
   i11 = 0;
   i12 = (i5 >>> 0) / (i10 >>> 0) >>> 0;
   return (tempRet0 = i11, i12) | 0;
  } else {
   if (!i2) {
    i11 = 0;
    i12 = 0;
    return (tempRet0 = i11, i12) | 0;
   }
   HEAP32[i1 >> 2] = i6 | 0;
   HEAP32[i1 + 4 >> 2] = i8 & 0;
   i11 = 0;
   i12 = 0;
   return (tempRet0 = i11, i12) | 0;
  }
 }
 i12 = (i11 | 0) == 0;
 do {
  if ((i10 | 0) != 0) {
   if (!i12) {
    i10 = (_llvm_ctlz_i32(i11 | 0) | 0) - (_llvm_ctlz_i32(i7 | 0) | 0) | 0;
    if (i10 >>> 0 <= 31) {
     i11 = i10 + 1 | 0;
     i12 = 31 - i10 | 0;
     i8 = i10 - 31 >> 31;
     i9 = i11;
     i6 = i5 >>> (i11 >>> 0) & i8 | i7 << i12;
     i8 = i7 >>> (i11 >>> 0) & i8;
     i11 = 0;
     i7 = i5 << i12;
     break;
    }
    if ((i1 | 0) == 0) {
     i11 = 0;
     i12 = 0;
     return (tempRet0 = i11, i12) | 0;
    }
    HEAP32[i1 >> 2] = i6 | 0;
    HEAP32[i1 + 4 >> 2] = i9 | i8 & 0;
    i11 = 0;
    i12 = 0;
    return (tempRet0 = i11, i12) | 0;
   }
   i11 = i10 - 1 | 0;
   if ((i11 & i10 | 0) != 0) {
    i12 = (_llvm_ctlz_i32(i10 | 0) | 0) + 33 - (_llvm_ctlz_i32(i7 | 0) | 0) | 0;
    i15 = 64 - i12 | 0;
    i10 = 32 - i12 | 0;
    i13 = i10 >> 31;
    i14 = i12 - 32 | 0;
    i8 = i14 >> 31;
    i9 = i12;
    i6 = i10 - 1 >> 31 & i7 >>> (i14 >>> 0) | (i7 << i10 | i5 >>> (i12 >>> 0)) & i8;
    i8 = i8 & i7 >>> (i12 >>> 0);
    i11 = i5 << i15 & i13;
    i7 = (i7 << i15 | i5 >>> (i14 >>> 0)) & i13 | i5 << i10 & i12 - 33 >> 31;
    break;
   }
   if ((i1 | 0) != 0) {
    HEAP32[i1 >> 2] = i11 & i5;
    HEAP32[i1 + 4 >> 2] = 0;
   }
   if ((i10 | 0) == 1) {
    i14 = i9 | i8 & 0;
    i15 = i6 | 0 | 0;
    return (tempRet0 = i14, i15) | 0;
   } else {
    i15 = _llvm_cttz_i32(i10 | 0) | 0;
    i14 = i7 >>> (i15 >>> 0) | 0;
    i15 = i7 << 32 - i15 | i5 >>> (i15 >>> 0) | 0;
    return (tempRet0 = i14, i15) | 0;
   }
  } else {
   if (i12) {
    if ((i1 | 0) != 0) {
     HEAP32[i1 >> 2] = (i7 >>> 0) % (i10 >>> 0);
     HEAP32[i1 + 4 >> 2] = 0;
    }
    i14 = 0;
    i15 = (i7 >>> 0) / (i10 >>> 0) >>> 0;
    return (tempRet0 = i14, i15) | 0;
   }
   if ((i5 | 0) == 0) {
    if ((i1 | 0) != 0) {
     HEAP32[i1 >> 2] = 0;
     HEAP32[i1 + 4 >> 2] = (i7 >>> 0) % (i11 >>> 0);
    }
    i14 = 0;
    i15 = (i7 >>> 0) / (i11 >>> 0) >>> 0;
    return (tempRet0 = i14, i15) | 0;
   }
   i10 = i11 - 1 | 0;
   if ((i10 & i11 | 0) == 0) {
    if ((i1 | 0) != 0) {
     HEAP32[i1 >> 2] = i6 | 0;
     HEAP32[i1 + 4 >> 2] = i10 & i7 | i8 & 0;
    }
    i14 = 0;
    i15 = i7 >>> ((_llvm_cttz_i32(i11 | 0) | 0) >>> 0);
    return (tempRet0 = i14, i15) | 0;
   }
   i10 = (_llvm_ctlz_i32(i11 | 0) | 0) - (_llvm_ctlz_i32(i7 | 0) | 0) | 0;
   if (i10 >>> 0 <= 30) {
    i8 = i10 + 1 | 0;
    i15 = 31 - i10 | 0;
    i9 = i8;
    i6 = i7 << i15 | i5 >>> (i8 >>> 0);
    i8 = i7 >>> (i8 >>> 0);
    i11 = 0;
    i7 = i5 << i15;
    break;
   }
   if ((i1 | 0) == 0) {
    i14 = 0;
    i15 = 0;
    return (tempRet0 = i14, i15) | 0;
   }
   HEAP32[i1 >> 2] = i6 | 0;
   HEAP32[i1 + 4 >> 2] = i9 | i8 & 0;
   i14 = 0;
   i15 = 0;
   return (tempRet0 = i14, i15) | 0;
  }
 } while (0);
 if ((i9 | 0) == 0) {
  i12 = i6;
  i2 = 0;
  i6 = 0;
 } else {
  i2 = i2 | 0 | 0;
  i3 = i3 | i4 & 0;
  i4 = _i64Add(i2, i3, -1, -1) | 0;
  i5 = tempRet0;
  i10 = i8;
  i12 = i6;
  i6 = 0;
  while (1) {
   i8 = i11 >>> 31 | i7 << 1;
   i11 = i6 | i11 << 1;
   i7 = i12 << 1 | i7 >>> 31 | 0;
   i10 = i12 >>> 31 | i10 << 1 | 0;
   _i64Subtract(i4, i5, i7, i10) | 0;
   i12 = tempRet0;
   i15 = i12 >> 31 | ((i12 | 0) < 0 ? -1 : 0) << 1;
   i6 = i15 & 1;
   i12 = _i64Subtract(i7, i10, i15 & i2, (((i12 | 0) < 0 ? -1 : 0) >> 31 | ((i12 | 0) < 0 ? -1 : 0) << 1) & i3) | 0;
   i10 = tempRet0;
   i9 = i9 - 1 | 0;
   if ((i9 | 0) == 0) {
    break;
   } else {
    i7 = i8;
   }
  }
  i7 = i8;
  i8 = i10;
  i2 = 0;
 }
 i3 = 0;
 if ((i1 | 0) != 0) {
  HEAP32[i1 >> 2] = i12;
  HEAP32[i1 + 4 >> 2] = i8;
 }
 i14 = (i11 | 0) >>> 31 | (i7 | i3) << 1 | (i3 << 1 | i11 >>> 31) & 0 | i2;
 i15 = (i11 << 1 | 0 >>> 31) & -2 | i6;
 return (tempRet0 = i14, i15) | 0;
}
function _leaveblock(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i5 = i3;
 i7 = i1 + 16 | 0;
 i4 = HEAP32[i7 >> 2] | 0;
 i2 = i1 + 12 | 0;
 i6 = HEAP32[i2 >> 2] | 0;
 if ((HEAP32[i4 >> 2] | 0) != 0 ? (HEAP8[i4 + 9 | 0] | 0) != 0 : 0) {
  i16 = _luaK_jump(i1) | 0;
  _luaK_patchclose(i1, i16, HEAPU8[i4 + 8 | 0] | 0);
  _luaK_patchtohere(i1, i16);
 }
 L5 : do {
  if ((HEAP8[i4 + 10 | 0] | 0) != 0) {
   i15 = i6 + 52 | 0;
   i14 = _luaS_new(HEAP32[i15 >> 2] | 0, 6304) | 0;
   i13 = i6 + 64 | 0;
   i16 = HEAP32[i13 >> 2] | 0;
   i10 = i16 + 24 | 0;
   i8 = i6 + 48 | 0;
   i11 = HEAP32[(HEAP32[i8 >> 2] | 0) + 20 >> 2] | 0;
   i12 = i16 + 28 | 0;
   i9 = HEAP32[i12 >> 2] | 0;
   i16 = i16 + 32 | 0;
   if ((i9 | 0) < (HEAP32[i16 >> 2] | 0)) {
    i15 = HEAP32[i10 >> 2] | 0;
   } else {
    i15 = _luaM_growaux_(HEAP32[i15 >> 2] | 0, HEAP32[i10 >> 2] | 0, i16, 16, 32767, 6312) | 0;
    HEAP32[i10 >> 2] = i15;
   }
   HEAP32[i15 + (i9 << 4) >> 2] = i14;
   i16 = HEAP32[i10 >> 2] | 0;
   HEAP32[i16 + (i9 << 4) + 8 >> 2] = 0;
   HEAP8[i16 + (i9 << 4) + 12 | 0] = HEAP8[(HEAP32[i8 >> 2] | 0) + 46 | 0] | 0;
   HEAP32[(HEAP32[i10 >> 2] | 0) + (i9 << 4) + 4 >> 2] = i11;
   HEAP32[i12 >> 2] = (HEAP32[i12 >> 2] | 0) + 1;
   i10 = HEAP32[i13 >> 2] | 0;
   i9 = (HEAP32[i10 + 24 >> 2] | 0) + (i9 << 4) | 0;
   i11 = HEAP16[(HEAP32[(HEAP32[i8 >> 2] | 0) + 16 >> 2] | 0) + 6 >> 1] | 0;
   i8 = i10 + 16 | 0;
   if ((i11 | 0) < (HEAP32[i8 >> 2] | 0)) {
    i10 = i10 + 12 | 0;
    do {
     while (1) {
      if ((_luaS_eqstr(HEAP32[(HEAP32[i10 >> 2] | 0) + (i11 << 4) >> 2] | 0, HEAP32[i9 >> 2] | 0) | 0) == 0) {
       break;
      }
      _closegoto(i6, i11, i9);
      if ((i11 | 0) >= (HEAP32[i8 >> 2] | 0)) {
       break L5;
      }
     }
     i11 = i11 + 1 | 0;
    } while ((i11 | 0) < (HEAP32[i8 >> 2] | 0));
   }
  }
 } while (0);
 HEAP32[i7 >> 2] = HEAP32[i4 >> 2];
 i7 = i4 + 8 | 0;
 i9 = HEAP8[i7] | 0;
 i10 = i1 + 46 | 0;
 i8 = (HEAP32[i2 >> 2] | 0) + 64 | 0;
 i14 = (HEAP32[i8 >> 2] | 0) + 4 | 0;
 HEAP32[i14 >> 2] = (i9 & 255) - (HEAPU8[i10] | 0) + (HEAP32[i14 >> 2] | 0);
 i14 = HEAP8[i10] | 0;
 if ((i14 & 255) > (i9 & 255)) {
  i13 = i1 + 20 | 0;
  i11 = i1 + 40 | 0;
  i12 = (HEAP32[i1 >> 2] | 0) + 24 | 0;
  do {
   i16 = HEAP32[i13 >> 2] | 0;
   i14 = i14 + -1 << 24 >> 24;
   HEAP8[i10] = i14;
   HEAP32[(HEAP32[i12 >> 2] | 0) + ((HEAP16[(HEAP32[HEAP32[i8 >> 2] >> 2] | 0) + ((HEAP32[i11 >> 2] | 0) + (i14 & 255) << 1) >> 1] | 0) * 12 | 0) + 8 >> 2] = i16;
   i14 = HEAP8[i10] | 0;
  } while ((i14 & 255) > (i9 & 255));
 }
 HEAP8[i1 + 48 | 0] = i14;
 i10 = HEAP32[i6 + 64 >> 2] | 0;
 HEAP32[i10 + 28 >> 2] = HEAP16[i4 + 4 >> 1] | 0;
 i9 = HEAP16[i4 + 6 >> 1] | 0;
 if ((HEAP32[i4 >> 2] | 0) == 0) {
  if ((i9 | 0) >= (HEAP32[i10 + 16 >> 2] | 0)) {
   STACKTOP = i3;
   return;
  }
  i10 = HEAP32[i10 + 12 >> 2] | 0;
  i11 = HEAP32[i10 + (i9 << 4) >> 2] | 0;
  if ((HEAP8[i11 + 4 | 0] | 0) != 4) {
   i16 = 6200;
   i15 = i6 + 52 | 0;
   i15 = HEAP32[i15 >> 2] | 0;
   i14 = i11 + 16 | 0;
   i13 = i10 + (i9 << 4) + 8 | 0;
   i13 = HEAP32[i13 >> 2] | 0;
   HEAP32[i5 >> 2] = i14;
   i14 = i5 + 4 | 0;
   HEAP32[i14 >> 2] = i13;
   i16 = _luaO_pushfstring(i15, i16, i5) | 0;
   _semerror(i6, i16);
  }
  i16 = (HEAP8[i11 + 6 | 0] | 0) != 0 ? 6160 : 6200;
  i15 = i6 + 52 | 0;
  i15 = HEAP32[i15 >> 2] | 0;
  i14 = i11 + 16 | 0;
  i13 = i10 + (i9 << 4) + 8 | 0;
  i13 = HEAP32[i13 >> 2] | 0;
  HEAP32[i5 >> 2] = i14;
  i14 = i5 + 4 | 0;
  HEAP32[i14 >> 2] = i13;
  i16 = _luaO_pushfstring(i15, i16, i5) | 0;
  _semerror(i6, i16);
 }
 i6 = HEAP32[i8 >> 2] | 0;
 i5 = i6 + 16 | 0;
 if ((i9 | 0) >= (HEAP32[i5 >> 2] | 0)) {
  STACKTOP = i3;
  return;
 }
 i6 = i6 + 12 | 0;
 i4 = i4 + 9 | 0;
 do {
  i10 = HEAP32[i6 >> 2] | 0;
  i8 = i10 + (i9 << 4) + 12 | 0;
  i11 = HEAP8[i7] | 0;
  i12 = i11 & 255;
  if ((HEAPU8[i8] | 0) > (i11 & 255)) {
   if ((HEAP8[i4] | 0) != 0) {
    _luaK_patchclose(i1, HEAP32[i10 + (i9 << 4) + 4 >> 2] | 0, i12);
    i11 = HEAP8[i7] | 0;
   }
   HEAP8[i8] = i11;
  }
  i9 = ((_findlabel(HEAP32[i2 >> 2] | 0, i9) | 0) == 0) + i9 | 0;
 } while ((i9 | 0) < (HEAP32[i5 >> 2] | 0));
 STACKTOP = i3;
 return;
}
function _getobjname(i3, i7, i9, i2) {
 i3 = i3 | 0;
 i7 = i7 | 0;
 i9 = i9 | 0;
 i2 = i2 | 0;
 var i1 = 0, i4 = 0, i5 = 0, i6 = 0, i8 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i1 = STACKTOP;
 i4 = i3 + 12 | 0;
 L1 : while (1) {
  i13 = _luaF_getlocalname(i3, i9 + 1 | 0, i7) | 0;
  HEAP32[i2 >> 2] = i13;
  if ((i13 | 0) != 0) {
   i2 = 2040;
   i4 = 42;
   break;
  }
  if ((i7 | 0) <= 0) {
   i2 = 0;
   i4 = 42;
   break;
  }
  i6 = HEAP32[i4 >> 2] | 0;
  i8 = 0;
  i5 = -1;
  do {
   i12 = HEAP32[i6 + (i8 << 2) >> 2] | 0;
   i13 = i12 & 63;
   i11 = i12 >>> 6 & 255;
   switch (i13 | 0) {
   case 27:
    {
     i10 = i8;
     i5 = (i11 | 0) == (i9 | 0) ? i8 : i5;
     break;
    }
   case 30:
   case 29:
    {
     i10 = i8;
     i5 = (i11 | 0) > (i9 | 0) ? i5 : i8;
     break;
    }
   case 23:
    {
     i10 = (i12 >>> 14) + -131071 | 0;
     i13 = i8 + 1 + i10 | 0;
     i10 = ((i8 | 0) >= (i13 | 0) | (i13 | 0) > (i7 | 0) ? 0 : i10) + i8 | 0;
     break;
    }
   case 4:
    {
     if ((i11 | 0) > (i9 | 0)) {
      i10 = i8;
     } else {
      i10 = i8;
      i5 = (i11 + (i12 >>> 23) | 0) < (i9 | 0) ? i5 : i8;
     }
     break;
    }
   case 34:
    {
     i10 = i8;
     i5 = (i11 + 2 | 0) > (i9 | 0) ? i5 : i8;
     break;
    }
   default:
    {
     i10 = i8;
     i5 = (HEAP8[5584 + i13 | 0] & 64) != 0 & (i11 | 0) == (i9 | 0) ? i8 : i5;
    }
   }
   i8 = i10 + 1 | 0;
  } while ((i8 | 0) < (i7 | 0));
  if ((i5 | 0) == -1) {
   i2 = 0;
   i4 = 42;
   break;
  }
  i7 = HEAP32[i6 + (i5 << 2) >> 2] | 0;
  i9 = i7 & 63;
  switch (i9 | 0) {
  case 0:
   {
    break;
   }
  case 7:
  case 6:
   {
    i4 = 17;
    break L1;
   }
  case 5:
   {
    i4 = 29;
    break L1;
   }
  case 1:
   {
    i4 = 32;
    break L1;
   }
  case 2:
   {
    i4 = 33;
    break L1;
   }
  case 12:
   {
    i4 = 36;
    break L1;
   }
  default:
   {
    i2 = 0;
    i4 = 42;
    break L1;
   }
  }
  i9 = i7 >>> 23;
  if (i9 >>> 0 < (i7 >>> 6 & 255) >>> 0) {
   i7 = i5;
  } else {
   i2 = 0;
   i4 = 42;
   break;
  }
 }
 if ((i4 | 0) == 17) {
  i6 = i7 >>> 14;
  i8 = i6 & 511;
  i7 = i7 >>> 23;
  if ((i9 | 0) != 7) {
   i7 = HEAP32[(HEAP32[i3 + 28 >> 2] | 0) + (i7 << 3) >> 2] | 0;
   if ((i7 | 0) == 0) {
    i7 = 2104;
   } else {
    i7 = i7 + 16 | 0;
   }
  } else {
   i7 = _luaF_getlocalname(i3, i7 + 1 | 0, i5) | 0;
  }
  if ((i6 & 256 | 0) == 0) {
   i3 = _getobjname(i3, i5, i8, i2) | 0;
   if (!((i3 | 0) != 0 ? (HEAP8[i3] | 0) == 99 : 0)) {
    i4 = 26;
   }
  } else {
   i5 = i6 & 255;
   i3 = HEAP32[i3 + 8 >> 2] | 0;
   if ((HEAP32[i3 + (i5 << 4) + 8 >> 2] & 15 | 0) == 4) {
    HEAP32[i2 >> 2] = (HEAP32[i3 + (i5 << 4) >> 2] | 0) + 16;
   } else {
    i4 = 26;
   }
  }
  if ((i4 | 0) == 26) {
   HEAP32[i2 >> 2] = 2104;
  }
  if ((i7 | 0) == 0) {
   i13 = 2064;
   STACKTOP = i1;
   return i13 | 0;
  }
  i13 = (_strcmp(i7, 2048) | 0) == 0;
  i13 = i13 ? 2056 : 2064;
  STACKTOP = i1;
  return i13 | 0;
 } else if ((i4 | 0) == 29) {
  i3 = HEAP32[(HEAP32[i3 + 28 >> 2] | 0) + (i7 >>> 23 << 3) >> 2] | 0;
  if ((i3 | 0) == 0) {
   i3 = 2104;
  } else {
   i3 = i3 + 16 | 0;
  }
  HEAP32[i2 >> 2] = i3;
  i13 = 2072;
  STACKTOP = i1;
  return i13 | 0;
 } else if ((i4 | 0) == 32) {
  i5 = i7 >>> 14;
 } else if ((i4 | 0) == 33) {
  i5 = (HEAP32[i6 + (i5 + 1 << 2) >> 2] | 0) >>> 6;
 } else if ((i4 | 0) == 36) {
  i4 = i7 >>> 14;
  if ((i4 & 256 | 0) == 0) {
   i3 = _getobjname(i3, i5, i4 & 511, i2) | 0;
   if ((i3 | 0) != 0 ? (HEAP8[i3] | 0) == 99 : 0) {
    i13 = 2096;
    STACKTOP = i1;
    return i13 | 0;
   }
  } else {
   i4 = i4 & 255;
   i3 = HEAP32[i3 + 8 >> 2] | 0;
   if ((HEAP32[i3 + (i4 << 4) + 8 >> 2] & 15 | 0) == 4) {
    HEAP32[i2 >> 2] = (HEAP32[i3 + (i4 << 4) >> 2] | 0) + 16;
    i13 = 2096;
    STACKTOP = i1;
    return i13 | 0;
   }
  }
  HEAP32[i2 >> 2] = 2104;
  i13 = 2096;
  STACKTOP = i1;
  return i13 | 0;
 } else if ((i4 | 0) == 42) {
  STACKTOP = i1;
  return i2 | 0;
 }
 i3 = HEAP32[i3 + 8 >> 2] | 0;
 if ((HEAP32[i3 + (i5 << 4) + 8 >> 2] & 15 | 0) != 4) {
  i13 = 0;
  STACKTOP = i1;
  return i13 | 0;
 }
 HEAP32[i2 >> 2] = (HEAP32[i3 + (i5 << 4) >> 2] | 0) + 16;
 i13 = 2080;
 STACKTOP = i1;
 return i13 | 0;
}
function _assignment(i2, i16, i5) {
 i2 = i2 | 0;
 i16 = i16 | 0;
 i5 = i5 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 80 | 0;
 i6 = i3 + 56 | 0;
 i1 = i3 + 32 | 0;
 i8 = i3;
 i4 = i16 + 8 | 0;
 if (!(((HEAP32[i4 >> 2] | 0) + -7 | 0) >>> 0 < 3)) {
  _luaX_syntaxerror(i2, 6344);
 }
 i13 = i2 + 16 | 0;
 i14 = HEAP32[i13 >> 2] | 0;
 do {
  if ((i14 | 0) == 44) {
   _luaX_next(i2);
   HEAP32[i8 >> 2] = i16;
   i14 = i8 + 8 | 0;
   _suffixedexp(i2, i14);
   i15 = i2 + 48 | 0;
   if ((HEAP32[i14 >> 2] | 0) != 9 ? (i10 = HEAP32[i15 >> 2] | 0, i11 = HEAP8[i10 + 48 | 0] | 0, i9 = i11 & 255, (i16 | 0) != 0) : 0) {
    i13 = i8 + 16 | 0;
    i12 = i11 & 255;
    i18 = 0;
    do {
     if ((HEAP32[i16 + 8 >> 2] | 0) == 9) {
      i17 = i16 + 16 | 0;
      i19 = i17 + 3 | 0;
      i20 = HEAPU8[i19] | 0;
      i21 = HEAP32[i14 >> 2] | 0;
      if ((i20 | 0) == (i21 | 0)) {
       i21 = i17 + 2 | 0;
       if ((HEAPU8[i21] | 0) == (HEAP32[i13 >> 2] | 0)) {
        HEAP8[i19] = 7;
        HEAP8[i21] = i11;
        i20 = HEAP32[i14 >> 2] | 0;
        i18 = 1;
       }
      } else {
       i20 = i21;
      }
      if ((i20 | 0) == 7 ? (HEAP16[i17 >> 1] | 0) == (HEAP32[i13 >> 2] | 0) : 0) {
       HEAP16[i17 >> 1] = i12;
       i18 = 1;
      }
     }
     i16 = HEAP32[i16 >> 2] | 0;
    } while ((i16 | 0) != 0);
    if ((i18 | 0) != 0) {
     _luaK_codeABC(i10, (HEAP32[i14 >> 2] | 0) == 7 ? 0 : 5, i9, HEAP32[i13 >> 2] | 0, 0) | 0;
     _luaK_reserveregs(i10, 1);
    }
   }
   i9 = HEAP32[i15 >> 2] | 0;
   if (((HEAPU16[(HEAP32[i2 + 52 >> 2] | 0) + 38 >> 1] | 0) + i5 | 0) <= 200) {
    _assignment(i2, i8, i5 + 1 | 0);
    i7 = i1;
    break;
   }
   i8 = i9 + 12 | 0;
   i5 = HEAP32[(HEAP32[i8 >> 2] | 0) + 52 >> 2] | 0;
   i9 = HEAP32[(HEAP32[i9 >> 2] | 0) + 64 >> 2] | 0;
   if ((i9 | 0) == 0) {
    i20 = 6552;
    HEAP32[i6 >> 2] = 6360;
    i21 = i6 + 4 | 0;
    HEAP32[i21 >> 2] = 200;
    i21 = i6 + 8 | 0;
    HEAP32[i21 >> 2] = i20;
    i21 = _luaO_pushfstring(i5, 6592, i6) | 0;
    i20 = HEAP32[i8 >> 2] | 0;
    _luaX_syntaxerror(i20, i21);
   }
   HEAP32[i6 >> 2] = i9;
   i20 = _luaO_pushfstring(i5, 6568, i6) | 0;
   HEAP32[i6 >> 2] = 6360;
   i21 = i6 + 4 | 0;
   HEAP32[i21 >> 2] = 200;
   i21 = i6 + 8 | 0;
   HEAP32[i21 >> 2] = i20;
   i21 = _luaO_pushfstring(i5, 6592, i6) | 0;
   i20 = HEAP32[i8 >> 2] | 0;
   _luaX_syntaxerror(i20, i21);
  } else if ((i14 | 0) == 61) {
   _luaX_next(i2);
   _subexpr(i2, i1, 0) | 0;
   i6 = i2 + 48 | 0;
   if ((HEAP32[i13 >> 2] | 0) == 44) {
    i9 = 1;
    do {
     _luaX_next(i2);
     _luaK_exp2nextreg(HEAP32[i6 >> 2] | 0, i1);
     _subexpr(i2, i1, 0) | 0;
     i9 = i9 + 1 | 0;
    } while ((HEAP32[i13 >> 2] | 0) == 44);
   } else {
    i9 = 1;
   }
   i8 = HEAP32[i6 >> 2] | 0;
   if ((i9 | 0) == (i5 | 0)) {
    _luaK_setoneret(i8, i1);
    _luaK_storevar(HEAP32[i6 >> 2] | 0, i4, i1);
    STACKTOP = i3;
    return;
   }
   i7 = i5 - i9 | 0;
   i10 = HEAP32[i1 >> 2] | 0;
   if ((i10 | 0) == 13 | (i10 | 0) == 12) {
    i10 = i7 + 1 | 0;
    i10 = (i10 | 0) < 0 ? 0 : i10;
    _luaK_setreturns(i8, i1, i10);
    if ((i10 | 0) > 1) {
     _luaK_reserveregs(i8, i10 + -1 | 0);
    }
   } else if ((i10 | 0) == 0) {
    i12 = 30;
   } else {
    _luaK_exp2nextreg(i8, i1);
    i12 = 30;
   }
   if ((i12 | 0) == 30 ? (i7 | 0) > 0 : 0) {
    i21 = HEAPU8[i8 + 48 | 0] | 0;
    _luaK_reserveregs(i8, i7);
    _luaK_nil(i8, i21, i7);
   }
   if ((i9 | 0) > (i5 | 0)) {
    i21 = (HEAP32[i6 >> 2] | 0) + 48 | 0;
    HEAP8[i21] = i7 + (HEAPU8[i21] | 0);
    i7 = i1;
   } else {
    i7 = i1;
   }
  } else {
   _error_expected(i2, 61);
  }
 } while (0);
 i21 = HEAP32[i2 + 48 >> 2] | 0;
 i20 = (HEAPU8[i21 + 48 | 0] | 0) + -1 | 0;
 HEAP32[i1 + 16 >> 2] = -1;
 HEAP32[i1 + 20 >> 2] = -1;
 HEAP32[i7 >> 2] = 6;
 HEAP32[i1 + 8 >> 2] = i20;
 _luaK_storevar(i21, i4, i1);
 STACKTOP = i3;
 return;
}
function _str_find_aux(i3, i7) {
 i3 = i3 | 0;
 i7 = i7 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i6 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 288 | 0;
 i9 = i1 + 284 | 0;
 i5 = i1 + 280 | 0;
 i4 = i1;
 i2 = _luaL_checklstring(i3, 1, i9) | 0;
 i8 = _luaL_checklstring(i3, 2, i5) | 0;
 i12 = _luaL_optinteger(i3, 3, 1) | 0;
 i10 = HEAP32[i9 >> 2] | 0;
 if (!((i12 | 0) > -1)) {
  if (i10 >>> 0 < (0 - i12 | 0) >>> 0) {
   i12 = 1;
  } else {
   i12 = i12 + 1 + i10 | 0;
   i6 = 4;
  }
 } else {
  i6 = 4;
 }
 if ((i6 | 0) == 4) {
  if ((i12 | 0) != 0) {
   if (i12 >>> 0 > (i10 + 1 | 0) >>> 0) {
    _lua_pushnil(i3);
    i13 = 1;
    STACKTOP = i1;
    return i13 | 0;
   }
  } else {
   i12 = 1;
  }
 }
 i7 = (i7 | 0) != 0;
 L10 : do {
  if (i7) {
   i13 = (_lua_toboolean(i3, 4) | 0) == 0;
   i10 = HEAP32[i5 >> 2] | 0;
   if (i13) {
    i11 = 0;
    do {
     i13 = i8 + i11 | 0;
     if ((_strpbrk(i13, 7512) | 0) != 0) {
      i6 = 20;
      break L10;
     }
     i11 = i11 + 1 + (_strlen(i13 | 0) | 0) | 0;
    } while (!(i11 >>> 0 > i10 >>> 0));
   }
   i11 = i2 + (i12 + -1) | 0;
   i9 = (HEAP32[i9 >> 2] | 0) - i12 + 1 | 0;
   L17 : do {
    if ((i10 | 0) == 0) {
     if ((i11 | 0) == 0) {
      break L10;
     }
    } else {
     if (i10 >>> 0 > i9 >>> 0) {
      break L10;
     }
     i4 = i10 + -1 | 0;
     if ((i4 | 0) == (i9 | 0)) {
      break L10;
     }
     i7 = HEAP8[i8] | 0;
     i8 = i8 + 1 | 0;
     i9 = i9 - i4 | 0;
     i12 = i11;
     while (1) {
      i11 = _memchr(i12, i7, i9) | 0;
      if ((i11 | 0) == 0) {
       break L10;
      }
      i10 = i11 + 1 | 0;
      if ((_memcmp(i10, i8, i4) | 0) == 0) {
       break L17;
      }
      i11 = i10;
      i9 = i12 + i9 | 0;
      if ((i9 | 0) == (i11 | 0)) {
       break L10;
      } else {
       i9 = i9 - i11 | 0;
       i12 = i10;
      }
     }
    }
   } while (0);
   i13 = i11 - i2 | 0;
   _lua_pushinteger(i3, i13 + 1 | 0);
   _lua_pushinteger(i3, i13 + (HEAP32[i5 >> 2] | 0) | 0);
   i13 = 2;
   STACKTOP = i1;
   return i13 | 0;
  } else {
   i6 = 20;
  }
 } while (0);
 L28 : do {
  if ((i6 | 0) == 20) {
   i6 = i2 + (i12 + -1) | 0;
   i10 = (HEAP8[i8] | 0) == 94;
   if (i10) {
    i12 = (HEAP32[i5 >> 2] | 0) + -1 | 0;
    HEAP32[i5 >> 2] = i12;
    i8 = i8 + 1 | 0;
   } else {
    i12 = HEAP32[i5 >> 2] | 0;
   }
   i5 = i4 + 16 | 0;
   HEAP32[i5 >> 2] = i3;
   HEAP32[i4 >> 2] = 200;
   HEAP32[i4 + 4 >> 2] = i2;
   i11 = i4 + 8 | 0;
   HEAP32[i11 >> 2] = i2 + (HEAP32[i9 >> 2] | 0);
   HEAP32[i4 + 12 >> 2] = i8 + i12;
   i9 = i4 + 20 | 0;
   L34 : do {
    if (i10) {
     HEAP32[i9 >> 2] = 0;
     i8 = _match(i4, i6, i8) | 0;
     if ((i8 | 0) == 0) {
      break L28;
     }
    } else {
     while (1) {
      HEAP32[i9 >> 2] = 0;
      i10 = _match(i4, i6, i8) | 0;
      if ((i10 | 0) != 0) {
       i8 = i10;
       break L34;
      }
      if (!(i6 >>> 0 < (HEAP32[i11 >> 2] | 0) >>> 0)) {
       break L28;
      }
      i6 = i6 + 1 | 0;
     }
    }
   } while (0);
   if (i7) {
    _lua_pushinteger(i3, 1 - i2 + i6 | 0);
    _lua_pushinteger(i3, i8 - i2 | 0);
    i2 = HEAP32[i9 >> 2] | 0;
    _luaL_checkstack(HEAP32[i5 >> 2] | 0, i2, 7200);
    if ((i2 | 0) > 0) {
     i3 = 0;
     do {
      _push_onecapture(i4, i3, 0, 0);
      i3 = i3 + 1 | 0;
     } while ((i3 | 0) != (i2 | 0));
    }
    i13 = i2 + 2 | 0;
    STACKTOP = i1;
    return i13 | 0;
   } else {
    i3 = HEAP32[i9 >> 2] | 0;
    i2 = (i3 | 0) != 0 | (i6 | 0) == 0 ? i3 : 1;
    _luaL_checkstack(HEAP32[i5 >> 2] | 0, i2, 7200);
    if ((i2 | 0) > 0) {
     i3 = 0;
    } else {
     i13 = i3;
     STACKTOP = i1;
     return i13 | 0;
    }
    do {
     _push_onecapture(i4, i3, i6, i8);
     i3 = i3 + 1 | 0;
    } while ((i3 | 0) != (i2 | 0));
    STACKTOP = i1;
    return i2 | 0;
   }
  }
 } while (0);
 _lua_pushnil(i3);
 i13 = 1;
 STACKTOP = i1;
 return i13 | 0;
}
function _luaO_pushvfstring(i2, i13, i10) {
 i2 = i2 | 0;
 i13 = i13 | 0;
 i10 = i10 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i11 = 0, i12 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, d18 = 0.0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 48 | 0;
 i7 = i3;
 i9 = i3 + 32 | 0;
 i8 = i3 + 8 | 0;
 i14 = _strchr(i13, 37) | 0;
 i6 = i2 + 24 | 0;
 i4 = i2 + 8 | 0;
 i15 = HEAP32[i4 >> 2] | 0;
 i17 = (HEAP32[i6 >> 2] | 0) - i15 | 0;
 L1 : do {
  if ((i14 | 0) == 0) {
   i5 = i13;
   i11 = i17;
   i12 = i15;
   i1 = 0;
  } else {
   i16 = 0;
   L3 : while (1) {
    if ((i17 | 0) < 48) {
     _luaD_growstack(i2, 2);
     i15 = HEAP32[i4 >> 2] | 0;
    }
    HEAP32[i4 >> 2] = i15 + 16;
    i13 = _luaS_newlstr(i2, i13, i14 - i13 | 0) | 0;
    HEAP32[i15 >> 2] = i13;
    HEAP32[i15 + 8 >> 2] = HEAPU8[i13 + 4 | 0] | 64;
    i13 = HEAP8[i14 + 1 | 0] | 0;
    switch (i13 | 0) {
    case 115:
     {
      i17 = HEAP32[i10 >> 2] | 0;
      i13 = HEAP32[i17 >> 2] | 0;
      HEAP32[i10 >> 2] = i17 + 4;
      i13 = (i13 | 0) == 0 ? 5480 : i13;
      i15 = _strlen(i13 | 0) | 0;
      i17 = HEAP32[i4 >> 2] | 0;
      HEAP32[i4 >> 2] = i17 + 16;
      i15 = _luaS_newlstr(i2, i13, i15) | 0;
      HEAP32[i17 >> 2] = i15;
      HEAP32[i17 + 8 >> 2] = HEAPU8[i15 + 4 | 0] | 64;
      break;
     }
    case 100:
     {
      i17 = HEAP32[i4 >> 2] | 0;
      HEAP32[i4 >> 2] = i17 + 16;
      i13 = HEAP32[i10 >> 2] | 0;
      i15 = HEAP32[i13 >> 2] | 0;
      HEAP32[i10 >> 2] = i13 + 4;
      HEAPF64[i17 >> 3] = +(i15 | 0);
      HEAP32[i17 + 8 >> 2] = 3;
      break;
     }
    case 37:
     {
      i17 = HEAP32[i4 >> 2] | 0;
      HEAP32[i4 >> 2] = i17 + 16;
      i15 = _luaS_newlstr(i2, 5496, 1) | 0;
      HEAP32[i17 >> 2] = i15;
      HEAP32[i17 + 8 >> 2] = HEAPU8[i15 + 4 | 0] | 64;
      break;
     }
    case 99:
     {
      i15 = HEAP32[i10 >> 2] | 0;
      i17 = HEAP32[i15 >> 2] | 0;
      HEAP32[i10 >> 2] = i15 + 4;
      HEAP8[i9] = i17;
      i17 = HEAP32[i4 >> 2] | 0;
      HEAP32[i4 >> 2] = i17 + 16;
      i15 = _luaS_newlstr(i2, i9, 1) | 0;
      HEAP32[i17 >> 2] = i15;
      HEAP32[i17 + 8 >> 2] = HEAPU8[i15 + 4 | 0] | 64;
      break;
     }
    case 102:
     {
      i17 = HEAP32[i4 >> 2] | 0;
      HEAP32[i4 >> 2] = i17 + 16;
      i15 = HEAP32[i10 >> 2] | 0;
      d18 = +HEAPF64[i15 >> 3];
      HEAP32[i10 >> 2] = i15 + 8;
      HEAPF64[i17 >> 3] = d18;
      HEAP32[i17 + 8 >> 2] = 3;
      break;
     }
    case 112:
     {
      i17 = HEAP32[i10 >> 2] | 0;
      i15 = HEAP32[i17 >> 2] | 0;
      HEAP32[i10 >> 2] = i17 + 4;
      HEAP32[i7 >> 2] = i15;
      i15 = _sprintf(i8 | 0, 5488, i7 | 0) | 0;
      i17 = HEAP32[i4 >> 2] | 0;
      HEAP32[i4 >> 2] = i17 + 16;
      i15 = _luaS_newlstr(i2, i8, i15) | 0;
      HEAP32[i17 >> 2] = i15;
      HEAP32[i17 + 8 >> 2] = HEAPU8[i15 + 4 | 0] | 64;
      break;
     }
    default:
     {
      break L3;
     }
    }
    i16 = i16 + 2 | 0;
    i13 = i14 + 2 | 0;
    i14 = _strchr(i13, 37) | 0;
    i15 = HEAP32[i4 >> 2] | 0;
    i17 = (HEAP32[i6 >> 2] | 0) - i15 | 0;
    if ((i14 | 0) == 0) {
     i5 = i13;
     i11 = i17;
     i12 = i15;
     i1 = i16;
     break L1;
    }
   }
   HEAP32[i7 >> 2] = i13;
   _luaG_runerror(i2, 5504, i7);
  }
 } while (0);
 if ((i11 | 0) < 32) {
  _luaD_growstack(i2, 1);
  i12 = HEAP32[i4 >> 2] | 0;
 }
 i17 = _strlen(i5 | 0) | 0;
 HEAP32[i4 >> 2] = i12 + 16;
 i17 = _luaS_newlstr(i2, i5, i17) | 0;
 HEAP32[i12 >> 2] = i17;
 HEAP32[i12 + 8 >> 2] = HEAPU8[i17 + 4 | 0] | 64;
 if ((i1 | 0) <= 0) {
  i17 = HEAP32[i4 >> 2] | 0;
  i17 = i17 + -16 | 0;
  i17 = HEAP32[i17 >> 2] | 0;
  i17 = i17 + 16 | 0;
  STACKTOP = i3;
  return i17 | 0;
 }
 _luaV_concat(i2, i1 | 1);
 i17 = HEAP32[i4 >> 2] | 0;
 i17 = i17 + -16 | 0;
 i17 = HEAP32[i17 >> 2] | 0;
 i17 = i17 + 16 | 0;
 STACKTOP = i3;
 return i17 | 0;
}
function _luaH_getn(i6) {
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, d11 = 0.0, i12 = 0, i13 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i2 = i1;
 i3 = i6 + 28 | 0;
 i12 = HEAP32[i3 >> 2] | 0;
 if ((i12 | 0) != 0 ? (i4 = HEAP32[i6 + 12 >> 2] | 0, (HEAP32[i4 + (i12 + -1 << 4) + 8 >> 2] | 0) == 0) : 0) {
  if (i12 >>> 0 > 1) {
   i10 = 0;
  } else {
   i13 = 0;
   STACKTOP = i1;
   return i13 | 0;
  }
  do {
   i2 = (i10 + i12 | 0) >>> 1;
   i3 = (HEAP32[i4 + (i2 + -1 << 4) + 8 >> 2] | 0) == 0;
   i12 = i3 ? i2 : i12;
   i10 = i3 ? i10 : i2;
  } while ((i12 - i10 | 0) >>> 0 > 1);
  STACKTOP = i1;
  return i10 | 0;
 }
 i4 = i6 + 16 | 0;
 if ((HEAP32[i4 >> 2] | 0) == 8016) {
  i13 = i12;
  STACKTOP = i1;
  return i13 | 0;
 }
 i5 = i6 + 12 | 0;
 i6 = i6 + 7 | 0;
 i9 = i2 + 4 | 0;
 i8 = i12 + 1 | 0;
 i13 = i12;
 i10 = i12;
 while (1) {
  i12 = i8 + -1 | 0;
  L15 : do {
   if (i12 >>> 0 < i13 >>> 0) {
    i12 = (HEAP32[i5 >> 2] | 0) + (i12 << 4) | 0;
   } else {
    d11 = +(i8 | 0);
    HEAPF64[i2 >> 3] = d11 + 1.0;
    i13 = (HEAP32[i9 >> 2] | 0) + (HEAP32[i2 >> 2] | 0) | 0;
    if ((i13 | 0) < 0) {
     i12 = 0 - i13 | 0;
     i13 = (i13 | 0) == (i12 | 0) ? 0 : i12;
    }
    i12 = (HEAP32[i4 >> 2] | 0) + (((i13 | 0) % ((1 << (HEAPU8[i6] | 0)) + -1 | 1 | 0) | 0) << 5) | 0;
    while (1) {
     if ((HEAP32[i12 + 24 >> 2] | 0) == 3 ? +HEAPF64[i12 + 16 >> 3] == d11 : 0) {
      break;
     }
     i12 = HEAP32[i12 + 28 >> 2] | 0;
     if ((i12 | 0) == 0) {
      i12 = 5192;
      break L15;
     }
    }
   }
  } while (0);
  if ((HEAP32[i12 + 8 >> 2] | 0) == 0) {
   break;
  }
  i10 = i8 << 1;
  if (i10 >>> 0 > 2147483645) {
   i7 = 21;
   break;
  }
  i12 = i8;
  i8 = i10;
  i13 = HEAP32[i3 >> 2] | 0;
  i10 = i12;
 }
 if ((i7 | 0) == 21) {
  i8 = i2 + 4 | 0;
  i7 = 1;
  while (1) {
   i10 = i7 + -1 | 0;
   L34 : do {
    if (i10 >>> 0 < (HEAP32[i3 >> 2] | 0) >>> 0) {
     i9 = (HEAP32[i5 >> 2] | 0) + (i10 << 4) | 0;
    } else {
     d11 = +(i7 | 0);
     HEAPF64[i2 >> 3] = d11 + 1.0;
     i9 = (HEAP32[i8 >> 2] | 0) + (HEAP32[i2 >> 2] | 0) | 0;
     if ((i9 | 0) < 0) {
      i12 = 0 - i9 | 0;
      i9 = (i9 | 0) == (i12 | 0) ? 0 : i12;
     }
     i9 = (HEAP32[i4 >> 2] | 0) + (((i9 | 0) % ((1 << (HEAPU8[i6] | 0)) + -1 | 1 | 0) | 0) << 5) | 0;
     while (1) {
      if ((HEAP32[i9 + 24 >> 2] | 0) == 3 ? +HEAPF64[i9 + 16 >> 3] == d11 : 0) {
       break;
      }
      i9 = HEAP32[i9 + 28 >> 2] | 0;
      if ((i9 | 0) == 0) {
       i9 = 5192;
       break L34;
      }
     }
    }
   } while (0);
   if ((HEAP32[i9 + 8 >> 2] | 0) == 0) {
    break;
   }
   i7 = i7 + 1 | 0;
  }
  STACKTOP = i1;
  return i10 | 0;
 }
 if (!((i8 - i10 | 0) >>> 0 > 1)) {
  i13 = i10;
  STACKTOP = i1;
  return i13 | 0;
 }
 i7 = i2 + 4 | 0;
 do {
  i9 = (i8 + i10 | 0) >>> 1;
  i12 = i9 + -1 | 0;
  L55 : do {
   if (i12 >>> 0 < (HEAP32[i3 >> 2] | 0) >>> 0) {
    i12 = (HEAP32[i5 >> 2] | 0) + (i12 << 4) | 0;
   } else {
    d11 = +(i9 | 0);
    HEAPF64[i2 >> 3] = d11 + 1.0;
    i13 = (HEAP32[i7 >> 2] | 0) + (HEAP32[i2 >> 2] | 0) | 0;
    if ((i13 | 0) < 0) {
     i12 = 0 - i13 | 0;
     i13 = (i13 | 0) == (i12 | 0) ? 0 : i12;
    }
    i12 = (HEAP32[i4 >> 2] | 0) + (((i13 | 0) % ((1 << (HEAPU8[i6] | 0)) + -1 | 1 | 0) | 0) << 5) | 0;
    while (1) {
     if ((HEAP32[i12 + 24 >> 2] | 0) == 3 ? +HEAPF64[i12 + 16 >> 3] == d11 : 0) {
      break;
     }
     i12 = HEAP32[i12 + 28 >> 2] | 0;
     if ((i12 | 0) == 0) {
      i12 = 5192;
      break L55;
     }
    }
   }
  } while (0);
  i12 = (HEAP32[i12 + 8 >> 2] | 0) == 0;
  i8 = i12 ? i9 : i8;
  i10 = i12 ? i10 : i9;
 } while ((i8 - i10 | 0) >>> 0 > 1);
 STACKTOP = i1;
 return i10 | 0;
}
function _lua_resume(i4, i3, i7) {
 i4 = i4 | 0;
 i3 = i3 | 0;
 i7 = i7 | 0;
 var i1 = 0, i2 = 0, i5 = 0, i6 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0;
 i1 = STACKTOP;
 if ((i3 | 0) == 0) {
  i5 = 1;
 } else {
  i5 = (HEAPU16[i3 + 38 >> 1] | 0) + 1 & 65535;
 }
 i3 = i4 + 38 | 0;
 HEAP16[i3 >> 1] = i5;
 i5 = i4 + 36 | 0;
 HEAP16[i5 >> 1] = 0;
 i6 = i4 + 8 | 0;
 i13 = _luaD_rawrunprotected(i4, 4, (HEAP32[i6 >> 2] | 0) + (0 - i7 << 4) | 0) | 0;
 if ((i13 | 0) == -1) {
  i18 = 2;
  HEAP16[i5 >> 1] = 1;
  i17 = HEAP16[i3 >> 1] | 0;
  i17 = i17 + -1 << 16 >> 16;
  HEAP16[i3 >> 1] = i17;
  STACKTOP = i1;
  return i18 | 0;
 }
 if (!(i13 >>> 0 > 1)) {
  i18 = i13;
  HEAP16[i5 >> 1] = 1;
  i17 = HEAP16[i3 >> 1] | 0;
  i17 = i17 + -1 << 16 >> 16;
  HEAP16[i3 >> 1] = i17;
  STACKTOP = i1;
  return i18 | 0;
 }
 i7 = i4 + 16 | 0;
 i12 = i4 + 28 | 0;
 i11 = i4 + 41 | 0;
 i10 = i4 + 68 | 0;
 i9 = i4 + 32 | 0;
 i8 = i4 + 12 | 0;
 L10 : while (1) {
  i15 = HEAP32[i7 >> 2] | 0;
  if ((i15 | 0) == 0) {
   break;
  }
  while (1) {
   i14 = i15 + 18 | 0;
   if (!((HEAP8[i14] & 16) == 0)) {
    break;
   }
   i15 = HEAP32[i15 + 8 >> 2] | 0;
   if ((i15 | 0) == 0) {
    break L10;
   }
  }
  i16 = HEAP32[i12 >> 2] | 0;
  i17 = HEAP32[i15 + 20 >> 2] | 0;
  i18 = i16 + i17 | 0;
  _luaF_close(i4, i18);
  if ((i13 | 0) == 4) {
   i19 = HEAP32[(HEAP32[i8 >> 2] | 0) + 180 >> 2] | 0;
   HEAP32[i18 >> 2] = i19;
   HEAP32[i16 + (i17 + 8) >> 2] = HEAPU8[i19 + 4 | 0] | 0 | 64;
  } else if ((i13 | 0) == 6) {
   i19 = _luaS_newlstr(i4, 2424, 23) | 0;
   HEAP32[i18 >> 2] = i19;
   HEAP32[i16 + (i17 + 8) >> 2] = HEAPU8[i19 + 4 | 0] | 0 | 64;
  } else {
   i19 = HEAP32[i6 >> 2] | 0;
   i21 = i19 + -16 | 0;
   i20 = HEAP32[i21 + 4 >> 2] | 0;
   HEAP32[i18 >> 2] = HEAP32[i21 >> 2];
   HEAP32[i18 + 4 >> 2] = i20;
   HEAP32[i16 + (i17 + 8) >> 2] = HEAP32[i19 + -8 >> 2];
  }
  i17 = i16 + (i17 + 16) | 0;
  HEAP32[i6 >> 2] = i17;
  HEAP32[i7 >> 2] = i15;
  HEAP8[i11] = HEAP8[i15 + 36 | 0] | 0;
  HEAP16[i5 >> 1] = 0;
  if ((i15 | 0) != 0) {
   i16 = i15;
   do {
    i18 = HEAP32[i16 + 4 >> 2] | 0;
    i17 = i17 >>> 0 < i18 >>> 0 ? i18 : i17;
    i16 = HEAP32[i16 + 8 >> 2] | 0;
   } while ((i16 | 0) != 0);
  }
  i16 = i17 - (HEAP32[i12 >> 2] | 0) | 0;
  i17 = (i16 >> 4) + 1 | 0;
  i17 = ((i17 | 0) / 8 | 0) + 10 + i17 | 0;
  i17 = (i17 | 0) > 1e6 ? 1e6 : i17;
  if ((i16 | 0) <= 15999984 ? (i17 | 0) < (HEAP32[i9 >> 2] | 0) : 0) {
   _luaD_reallocstack(i4, i17);
  }
  HEAP32[i10 >> 2] = HEAP32[i15 + 32 >> 2];
  HEAP8[i14] = HEAPU8[i14] | 0 | 32;
  HEAP8[i15 + 37 | 0] = i13;
  i13 = _luaD_rawrunprotected(i4, 5, 0) | 0;
  if (!(i13 >>> 0 > 1)) {
   i2 = 24;
   break;
  }
 }
 if ((i2 | 0) == 24) {
  HEAP16[i5 >> 1] = 1;
  i21 = HEAP16[i3 >> 1] | 0;
  i21 = i21 + -1 << 16 >> 16;
  HEAP16[i3 >> 1] = i21;
  STACKTOP = i1;
  return i13 | 0;
 }
 HEAP8[i4 + 6 | 0] = i13;
 i2 = HEAP32[i6 >> 2] | 0;
 if ((i13 | 0) == 4) {
  i21 = HEAP32[(HEAP32[i8 >> 2] | 0) + 180 >> 2] | 0;
  HEAP32[i2 >> 2] = i21;
  HEAP32[i2 + 8 >> 2] = HEAPU8[i21 + 4 | 0] | 0 | 64;
 } else if ((i13 | 0) == 6) {
  i21 = _luaS_newlstr(i4, 2424, 23) | 0;
  HEAP32[i2 >> 2] = i21;
  HEAP32[i2 + 8 >> 2] = HEAPU8[i21 + 4 | 0] | 0 | 64;
 } else {
  i19 = i2 + -16 | 0;
  i20 = HEAP32[i19 + 4 >> 2] | 0;
  i21 = i2;
  HEAP32[i21 >> 2] = HEAP32[i19 >> 2];
  HEAP32[i21 + 4 >> 2] = i20;
  HEAP32[i2 + 8 >> 2] = HEAP32[i2 + -8 >> 2];
 }
 i21 = i2 + 16 | 0;
 HEAP32[i6 >> 2] = i21;
 HEAP32[(HEAP32[i7 >> 2] | 0) + 4 >> 2] = i21;
 i21 = i13;
 HEAP16[i5 >> 1] = 1;
 i20 = HEAP16[i3 >> 1] | 0;
 i20 = i20 + -1 << 16 >> 16;
 HEAP16[i3 >> 1] = i20;
 STACKTOP = i1;
 return i21 | 0;
}
function _luaK_goiftrue(i1, i3) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0;
 i2 = STACKTOP;
 _luaK_dischargevars(i1, i3);
 i12 = HEAP32[i3 >> 2] | 0;
 do {
  if ((i12 | 0) == 10) {
   i9 = HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0;
   i5 = i3 + 8 | 0;
   i8 = HEAP32[i5 >> 2] | 0;
   i7 = i9 + (i8 << 2) | 0;
   if (!((i8 | 0) > 0 ? (i10 = i9 + (i8 + -1 << 2) | 0, i6 = HEAP32[i10 >> 2] | 0, (HEAP8[5584 + (i6 & 63) | 0] | 0) < 0) : 0)) {
    i10 = i7;
    i6 = HEAP32[i7 >> 2] | 0;
   }
   HEAP32[i10 >> 2] = ((i6 & 16320 | 0) == 0) << 6 | i6 & -16321;
   i5 = HEAP32[i5 >> 2] | 0;
   i8 = 18;
  } else if (!((i12 | 0) == 2 | (i12 | 0) == 5 | (i12 | 0) == 4)) {
   i5 = i3 + 8 | 0;
   if ((i12 | 0) == 6) {
    i8 = 14;
   } else if ((i12 | 0) == 11 ? (i11 = HEAP32[(HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0) + (HEAP32[i5 >> 2] << 2) >> 2] | 0, (i11 & 63 | 0) == 20) : 0) {
    i5 = i1 + 20 | 0;
    HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + -1;
    i5 = _condjump(i1, 27, i11 >>> 23, 0, 1) | 0;
    i8 = 18;
    break;
   } else {
    i8 = 9;
   }
   if ((i8 | 0) == 9) {
    i12 = i1 + 48 | 0;
    i10 = HEAP8[i12] | 0;
    i11 = (i10 & 255) + 1 | 0;
    i6 = (HEAP32[i1 >> 2] | 0) + 78 | 0;
    do {
     if (i11 >>> 0 > (HEAPU8[i6] | 0) >>> 0) {
      if (i11 >>> 0 > 249) {
       _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10536);
      } else {
       HEAP8[i6] = i11;
       i9 = HEAP8[i12] | 0;
       break;
      }
     } else {
      i9 = i10;
     }
    } while (0);
    i11 = (i9 & 255) + 1 | 0;
    HEAP8[i12] = i11;
    _discharge2reg(i1, i3, (i11 & 255) + -1 | 0);
    if ((HEAP32[i3 >> 2] | 0) == 6) {
     i8 = 14;
    }
   }
   if (((i8 | 0) == 14 ? (i7 = HEAP32[i5 >> 2] | 0, (i7 & 256 | 0) == 0) : 0) ? (HEAPU8[i1 + 46 | 0] | 0) <= (i7 | 0) : 0) {
    i12 = i1 + 48 | 0;
    HEAP8[i12] = (HEAP8[i12] | 0) + -1 << 24 >> 24;
   }
   i5 = _condjump(i1, 28, 255, HEAP32[i5 >> 2] | 0, 0) | 0;
   i8 = 18;
  }
 } while (0);
 do {
  if ((i8 | 0) == 18 ? (i4 = i3 + 20 | 0, !((i5 | 0) == -1)) : 0) {
   i8 = HEAP32[i4 >> 2] | 0;
   if ((i8 | 0) == -1) {
    HEAP32[i4 >> 2] = i5;
    break;
   }
   i4 = HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0;
   while (1) {
    i7 = i4 + (i8 << 2) | 0;
    i6 = HEAP32[i7 >> 2] | 0;
    i9 = (i6 >>> 14) + -131071 | 0;
    if ((i9 | 0) == -1) {
     break;
    }
    i9 = i8 + 1 + i9 | 0;
    if ((i9 | 0) == -1) {
     break;
    } else {
     i8 = i9;
    }
   }
   i4 = i5 + ~i8 | 0;
   if ((((i4 | 0) > -1 ? i4 : 0 - i4 | 0) | 0) > 131071) {
    _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10624);
   } else {
    HEAP32[i7 >> 2] = (i4 << 14) + 2147467264 | i6 & 16383;
    break;
   }
  }
 } while (0);
 i3 = i3 + 16 | 0;
 i4 = HEAP32[i3 >> 2] | 0;
 HEAP32[i1 + 24 >> 2] = HEAP32[i1 + 20 >> 2];
 i5 = i1 + 28 | 0;
 if ((i4 | 0) == -1) {
  HEAP32[i3 >> 2] = -1;
  STACKTOP = i2;
  return;
 }
 i8 = HEAP32[i5 >> 2] | 0;
 if ((i8 | 0) == -1) {
  HEAP32[i5 >> 2] = i4;
  HEAP32[i3 >> 2] = -1;
  STACKTOP = i2;
  return;
 }
 i7 = HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0;
 while (1) {
  i5 = i7 + (i8 << 2) | 0;
  i6 = HEAP32[i5 >> 2] | 0;
  i9 = (i6 >>> 14) + -131071 | 0;
  if ((i9 | 0) == -1) {
   break;
  }
  i9 = i8 + 1 + i9 | 0;
  if ((i9 | 0) == -1) {
   break;
  } else {
   i8 = i9;
  }
 }
 i4 = i4 + ~i8 | 0;
 if ((((i4 | 0) > -1 ? i4 : 0 - i4 | 0) | 0) > 131071) {
  _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10624);
 }
 HEAP32[i5 >> 2] = (i4 << 14) + 2147467264 | i6 & 16383;
 HEAP32[i3 >> 2] = -1;
 STACKTOP = i2;
 return;
}
function _luaO_str2d(i1, i3, i5) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 i5 = i5 | 0;
 var i2 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, d9 = 0.0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = i2;
 if ((_strpbrk(i1, 5464) | 0) != 0) {
  i13 = 0;
  STACKTOP = i2;
  return i13 | 0;
 }
 do {
  if ((_strpbrk(i1, 5472) | 0) == 0) {
   d9 = +_strtod(i1, i4);
   i10 = HEAP32[i4 >> 2] | 0;
  } else {
   HEAP32[i4 >> 2] = i1;
   i8 = i1;
   while (1) {
    i6 = HEAP8[i8] | 0;
    i10 = i8 + 1 | 0;
    if ((HEAP8[(i6 & 255) + 10913 | 0] & 8) == 0) {
     break;
    } else {
     i8 = i10;
    }
   }
   if (i6 << 24 >> 24 == 43) {
    i6 = 0;
    i8 = i10;
   } else if (i6 << 24 >> 24 == 45) {
    i6 = 1;
    i8 = i10;
   } else {
    i6 = 0;
   }
   if ((HEAP8[i8] | 0) == 48 ? (i13 = HEAP8[i8 + 1 | 0] | 0, i13 << 24 >> 24 == 88 | i13 << 24 >> 24 == 120) : 0) {
    i10 = i8 + 2 | 0;
    i8 = HEAP8[i10] | 0;
    i12 = i8 & 255;
    i11 = HEAP8[i12 + 10913 | 0] | 0;
    if ((i11 & 16) == 0) {
     d9 = 0.0;
     i11 = i8;
     i8 = 0;
    } else {
     d9 = 0.0;
     i8 = 0;
     while (1) {
      if ((i11 & 2) == 0) {
       i11 = (i12 | 32) + -87 | 0;
      } else {
       i11 = i12 + -48 | 0;
      }
      d9 = d9 * 16.0 + +(i11 | 0);
      i8 = i8 + 1 | 0;
      i10 = i10 + 1 | 0;
      i13 = HEAP8[i10] | 0;
      i12 = i13 & 255;
      i11 = HEAP8[i12 + 10913 | 0] | 0;
      if ((i11 & 16) == 0) {
       i11 = i13;
       break;
      }
     }
    }
    if (i11 << 24 >> 24 == 46) {
     i10 = i10 + 1 | 0;
     i13 = HEAPU8[i10] | 0;
     i11 = HEAP8[i13 + 10913 | 0] | 0;
     if ((i11 & 16) == 0) {
      i12 = 0;
     } else {
      i12 = 0;
      do {
       if ((i11 & 2) == 0) {
        i11 = (i13 | 32) + -87 | 0;
       } else {
        i11 = i13 + -48 | 0;
       }
       d9 = d9 * 16.0 + +(i11 | 0);
       i12 = i12 + 1 | 0;
       i10 = i10 + 1 | 0;
       i13 = HEAPU8[i10] | 0;
       i11 = HEAP8[i13 + 10913 | 0] | 0;
      } while (!((i11 & 16) == 0));
     }
    } else {
     i12 = 0;
    }
    if ((i12 | i8 | 0) != 0) {
     i8 = Math_imul(i12, -4) | 0;
     HEAP32[i4 >> 2] = i10;
     i13 = HEAP8[i10] | 0;
     if (i13 << 24 >> 24 == 80 | i13 << 24 >> 24 == 112) {
      i13 = i10 + 1 | 0;
      i11 = HEAP8[i13] | 0;
      if (i11 << 24 >> 24 == 45) {
       i11 = 1;
       i13 = i10 + 2 | 0;
      } else if (i11 << 24 >> 24 == 43) {
       i11 = 0;
       i13 = i10 + 2 | 0;
      } else {
       i11 = 0;
      }
      i12 = HEAP8[i13] | 0;
      if (!((HEAP8[(i12 & 255) + 10913 | 0] & 2) == 0)) {
       i10 = i13;
       i7 = 0;
       do {
        i10 = i10 + 1 | 0;
        i7 = (i12 << 24 >> 24) + -48 + (i7 * 10 | 0) | 0;
        i12 = HEAP8[i10] | 0;
       } while (!((HEAP8[(i12 & 255) + 10913 | 0] & 2) == 0));
       i8 = ((i11 | 0) == 0 ? i7 : 0 - i7 | 0) + i8 | 0;
       i7 = 29;
      }
     } else {
      i7 = 29;
     }
     if ((i7 | 0) == 29) {
      HEAP32[i4 >> 2] = i10;
     }
     if ((i6 | 0) != 0) {
      d9 = -d9;
     }
     d9 = +_ldexp(d9, i8);
     break;
    }
   }
   HEAPF64[i5 >> 3] = 0.0;
   i13 = 0;
   STACKTOP = i2;
   return i13 | 0;
  }
 } while (0);
 HEAPF64[i5 >> 3] = d9;
 if ((i10 | 0) == (i1 | 0)) {
  i13 = 0;
  STACKTOP = i2;
  return i13 | 0;
 }
 if (!((HEAP8[(HEAPU8[i10] | 0) + 10913 | 0] & 8) == 0)) {
  do {
   i10 = i10 + 1 | 0;
  } while (!((HEAP8[(HEAPU8[i10] | 0) + 10913 | 0] & 8) == 0));
  HEAP32[i4 >> 2] = i10;
 }
 i13 = (i10 | 0) == (i1 + i3 | 0) | 0;
 STACKTOP = i2;
 return i13 | 0;
}
function _luaV_equalobj_(i2, i4, i5) {
 i2 = i2 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i1 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i1 = STACKTOP;
 i3 = i4 + 8 | 0;
 L1 : do {
  switch (HEAP32[i3 >> 2] & 63 | 0) {
  case 7:
   {
    i6 = HEAP32[i4 >> 2] | 0;
    i7 = HEAP32[i5 >> 2] | 0;
    if ((i6 | 0) == (i7 | 0)) {
     i7 = 1;
     STACKTOP = i1;
     return i7 | 0;
    }
    if ((i2 | 0) == 0) {
     i7 = 0;
     STACKTOP = i1;
     return i7 | 0;
    } else {
     i6 = _get_equalTM(i2, HEAP32[i6 + 8 >> 2] | 0, HEAP32[i7 + 8 >> 2] | 0) | 0;
     break L1;
    }
   }
  case 5:
   {
    i7 = HEAP32[i4 >> 2] | 0;
    i6 = HEAP32[i5 >> 2] | 0;
    if ((i7 | 0) == (i6 | 0)) {
     i7 = 1;
     STACKTOP = i1;
     return i7 | 0;
    }
    if ((i2 | 0) == 0) {
     i7 = 0;
     STACKTOP = i1;
     return i7 | 0;
    } else {
     i6 = _get_equalTM(i2, HEAP32[i7 + 8 >> 2] | 0, HEAP32[i6 + 8 >> 2] | 0) | 0;
     break L1;
    }
   }
  case 4:
   {
    i7 = (HEAP32[i4 >> 2] | 0) == (HEAP32[i5 >> 2] | 0) | 0;
    STACKTOP = i1;
    return i7 | 0;
   }
  case 20:
   {
    i7 = _luaS_eqlngstr(HEAP32[i4 >> 2] | 0, HEAP32[i5 >> 2] | 0) | 0;
    STACKTOP = i1;
    return i7 | 0;
   }
  case 3:
   {
    i7 = +HEAPF64[i4 >> 3] == +HEAPF64[i5 >> 3] | 0;
    STACKTOP = i1;
    return i7 | 0;
   }
  case 1:
   {
    i7 = (HEAP32[i4 >> 2] | 0) == (HEAP32[i5 >> 2] | 0) | 0;
    STACKTOP = i1;
    return i7 | 0;
   }
  case 22:
   {
    i7 = (HEAP32[i4 >> 2] | 0) == (HEAP32[i5 >> 2] | 0) | 0;
    STACKTOP = i1;
    return i7 | 0;
   }
  case 2:
   {
    i7 = (HEAP32[i4 >> 2] | 0) == (HEAP32[i5 >> 2] | 0) | 0;
    STACKTOP = i1;
    return i7 | 0;
   }
  case 0:
   {
    i7 = 1;
    STACKTOP = i1;
    return i7 | 0;
   }
  default:
   {
    i7 = (HEAP32[i4 >> 2] | 0) == (HEAP32[i5 >> 2] | 0) | 0;
    STACKTOP = i1;
    return i7 | 0;
   }
  }
 } while (0);
 if ((i6 | 0) == 0) {
  i7 = 0;
  STACKTOP = i1;
  return i7 | 0;
 }
 i7 = i2 + 8 | 0;
 i10 = HEAP32[i7 >> 2] | 0;
 i9 = i2 + 28 | 0;
 i8 = i10 - (HEAP32[i9 >> 2] | 0) | 0;
 HEAP32[i7 >> 2] = i10 + 16;
 i13 = i6;
 i12 = HEAP32[i13 + 4 >> 2] | 0;
 i11 = i10;
 HEAP32[i11 >> 2] = HEAP32[i13 >> 2];
 HEAP32[i11 + 4 >> 2] = i12;
 HEAP32[i10 + 8 >> 2] = HEAP32[i6 + 8 >> 2];
 i10 = HEAP32[i7 >> 2] | 0;
 HEAP32[i7 >> 2] = i10 + 16;
 i11 = i4;
 i4 = HEAP32[i11 + 4 >> 2] | 0;
 i6 = i10;
 HEAP32[i6 >> 2] = HEAP32[i11 >> 2];
 HEAP32[i6 + 4 >> 2] = i4;
 HEAP32[i10 + 8 >> 2] = HEAP32[i3 >> 2];
 i3 = HEAP32[i7 >> 2] | 0;
 HEAP32[i7 >> 2] = i3 + 16;
 i10 = i5;
 i6 = HEAP32[i10 + 4 >> 2] | 0;
 i4 = i3;
 HEAP32[i4 >> 2] = HEAP32[i10 >> 2];
 HEAP32[i4 + 4 >> 2] = i6;
 HEAP32[i3 + 8 >> 2] = HEAP32[i5 + 8 >> 2];
 _luaD_call(i2, (HEAP32[i7 >> 2] | 0) + -48 | 0, 1, HEAP8[(HEAP32[i2 + 16 >> 2] | 0) + 18 | 0] & 1);
 i2 = HEAP32[i9 >> 2] | 0;
 i3 = HEAP32[i7 >> 2] | 0;
 i4 = i3 + -16 | 0;
 HEAP32[i7 >> 2] = i4;
 i5 = HEAP32[i4 + 4 >> 2] | 0;
 i6 = i2 + i8 | 0;
 HEAP32[i6 >> 2] = HEAP32[i4 >> 2];
 HEAP32[i6 + 4 >> 2] = i5;
 HEAP32[i2 + (i8 + 8) >> 2] = HEAP32[i3 + -8 >> 2];
 i2 = HEAP32[i7 >> 2] | 0;
 i3 = HEAP32[i2 + 8 >> 2] | 0;
 if ((i3 | 0) != 0) {
  if ((i3 | 0) == 1) {
   i2 = (HEAP32[i2 >> 2] | 0) != 0;
  } else {
   i2 = 1;
  }
 } else {
  i2 = 0;
 }
 i13 = i2 & 1;
 STACKTOP = i1;
 return i13 | 0;
}
function _forbody(i1, i5, i6, i4, i9) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i4 = i4 | 0;
 i9 = i9 | 0;
 var i2 = 0, i3 = 0, i7 = 0, i8 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0, i19 = 0, i20 = 0, i21 = 0, i22 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i8 = i3 + 12 | 0;
 i19 = i3;
 i11 = i1 + 48 | 0;
 i7 = HEAP32[i11 >> 2] | 0;
 i18 = i7 + 46 | 0;
 i22 = (HEAPU8[i18] | 0) + 3 | 0;
 HEAP8[i18] = i22;
 i21 = i7 + 20 | 0;
 i17 = i7 + 12 | 0;
 i2 = i7 + 40 | 0;
 i20 = HEAP32[(HEAP32[i7 >> 2] | 0) + 24 >> 2] | 0;
 i10 = HEAP32[HEAP32[(HEAP32[i17 >> 2] | 0) + 64 >> 2] >> 2] | 0;
 HEAP32[i20 + ((HEAP16[i10 + ((i22 & 255) + -3 + (HEAP32[i2 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i21 >> 2];
 HEAP32[i20 + ((HEAP16[i10 + ((HEAPU8[i18] | 0) + -2 + (HEAP32[i2 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i21 >> 2];
 HEAP32[i20 + ((HEAP16[i10 + ((HEAPU8[i18] | 0) + -1 + (HEAP32[i2 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i21 >> 2];
 i2 = i1 + 16 | 0;
 if ((HEAP32[i2 >> 2] | 0) != 259) {
  _error_expected(i1, 259);
 }
 _luaX_next(i1);
 i10 = (i9 | 0) != 0;
 if (i10) {
  i9 = _luaK_codeABx(i7, 33, i5, 131070) | 0;
 } else {
  i9 = _luaK_jump(i7) | 0;
 }
 HEAP8[i19 + 10 | 0] = 0;
 HEAP8[i19 + 8 | 0] = HEAP8[i18] | 0;
 i17 = HEAP32[(HEAP32[i17 >> 2] | 0) + 64 >> 2] | 0;
 HEAP16[i19 + 4 >> 1] = HEAP32[i17 + 28 >> 2];
 HEAP16[i19 + 6 >> 1] = HEAP32[i17 + 16 >> 2];
 HEAP8[i19 + 9 | 0] = 0;
 i17 = i7 + 16 | 0;
 HEAP32[i19 >> 2] = HEAP32[i17 >> 2];
 HEAP32[i17 >> 2] = i19;
 i19 = HEAP32[i11 >> 2] | 0;
 i17 = i19 + 46 | 0;
 i18 = (HEAPU8[i17] | 0) + i4 | 0;
 HEAP8[i17] = i18;
 if ((i4 | 0) != 0 ? (i13 = i19 + 20 | 0, i12 = i19 + 40 | 0, i14 = HEAP32[(HEAP32[i19 >> 2] | 0) + 24 >> 2] | 0, i15 = HEAP32[HEAP32[(HEAP32[i19 + 12 >> 2] | 0) + 64 >> 2] >> 2] | 0, HEAP32[i14 + ((HEAP16[i15 + ((i18 & 255) - i4 + (HEAP32[i12 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i13 >> 2], i16 = i4 + -1 | 0, (i16 | 0) != 0) : 0) {
  do {
   HEAP32[i14 + ((HEAP16[i15 + ((HEAPU8[i17] | 0) - i16 + (HEAP32[i12 >> 2] | 0) << 1) >> 1] | 0) * 12 | 0) + 4 >> 2] = HEAP32[i13 >> 2];
   i16 = i16 + -1 | 0;
  } while ((i16 | 0) != 0);
 }
 _luaK_reserveregs(i7, i4);
 i11 = HEAP32[i11 >> 2] | 0;
 HEAP8[i8 + 10 | 0] = 0;
 HEAP8[i8 + 8 | 0] = HEAP8[i11 + 46 | 0] | 0;
 i22 = HEAP32[(HEAP32[i11 + 12 >> 2] | 0) + 64 >> 2] | 0;
 HEAP16[i8 + 4 >> 1] = HEAP32[i22 + 28 >> 2];
 HEAP16[i8 + 6 >> 1] = HEAP32[i22 + 16 >> 2];
 HEAP8[i8 + 9 | 0] = 0;
 i22 = i11 + 16 | 0;
 HEAP32[i8 >> 2] = HEAP32[i22 >> 2];
 HEAP32[i22 >> 2] = i8;
 L13 : do {
  i8 = HEAP32[i2 >> 2] | 0;
  switch (i8 | 0) {
  case 277:
  case 286:
  case 262:
  case 261:
  case 260:
   {
    break L13;
   }
  default:
   {}
  }
  _statement(i1);
 } while ((i8 | 0) != 274);
 _leaveblock(i11);
 _leaveblock(i7);
 _luaK_patchtohere(i7, i9);
 if (i10) {
  i21 = _luaK_codeABx(i7, 32, i5, 131070) | 0;
  i22 = i9 + 1 | 0;
  _luaK_patchlist(i7, i21, i22);
  _luaK_fixline(i7, i6);
  STACKTOP = i3;
  return;
 } else {
  _luaK_codeABC(i7, 34, i5, 0, i4) | 0;
  _luaK_fixline(i7, i6);
  i21 = _luaK_codeABx(i7, 35, i5 + 2 | 0, 131070) | 0;
  i22 = i9 + 1 | 0;
  _luaK_patchlist(i7, i21, i22);
  _luaK_fixline(i7, i6);
  STACKTOP = i3;
  return;
 }
}
function _dotty(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i6;
 i4 = i6 + 4 | 0;
 i2 = HEAP32[20] | 0;
 HEAP32[20] = 0;
 _lua_settop(i1, 0);
 if ((_pushline(i1, 1) | 0) == 0) {
  _lua_settop(i1, 0);
  i10 = HEAP32[_stdout >> 2] | 0;
  _fputc(10, i10 | 0) | 0;
  _fflush(i10 | 0) | 0;
  HEAP32[20] = i2;
  STACKTOP = i6;
  return;
 }
 i5 = HEAP32[_stderr >> 2] | 0;
 L4 : while (1) {
  i8 = _lua_tolstring(i1, 1, i4) | 0;
  i8 = _luaL_loadbufferx(i1, i8, HEAP32[i4 >> 2] | 0, 256, 0) | 0;
  L6 : do {
   if ((i8 | 0) == 3) {
    while (1) {
     i8 = _lua_tolstring(i1, -1, i3) | 0;
     i7 = HEAP32[i3 >> 2] | 0;
     if (!(i7 >>> 0 > 4)) {
      break;
     }
     if ((_strcmp(i8 + (i7 + -5) | 0, 264) | 0) != 0) {
      break;
     }
     _lua_settop(i1, -2);
     if ((_pushline(i1, 0) | 0) == 0) {
      i7 = 23;
      break L4;
     }
     _lua_pushlstring(i1, 184, 1) | 0;
     _lua_insert(i1, -2);
     _lua_concat(i1, 3);
     i8 = _lua_tolstring(i1, 1, i4) | 0;
     i8 = _luaL_loadbufferx(i1, i8, HEAP32[i4 >> 2] | 0, 256, 0) | 0;
     if ((i8 | 0) != 3) {
      i7 = 9;
      break L6;
     }
    }
    _lua_remove(i1, 1);
    i8 = 3;
    i7 = 10;
   } else {
    i7 = 9;
   }
  } while (0);
  do {
   if ((i7 | 0) == 9) {
    _lua_remove(i1, 1);
    if ((i8 | 0) == -1) {
     i7 = 23;
     break L4;
    } else if ((i8 | 0) != 0) {
     i7 = 10;
     break;
    }
    i9 = _lua_gettop(i1) | 0;
    _lua_pushcclosure(i1, 142, 0);
    _lua_insert(i1, i9);
    HEAP32[48] = i1;
    _signal(2, 1) | 0;
    i10 = _lua_pcallk(i1, 0, -1, i9, 0, 0) | 0;
    _signal(2, 0) | 0;
    _lua_remove(i1, i9);
    if ((i10 | 0) == 0) {
     i7 = 17;
    } else {
     i9 = 0;
     i7 = 12;
    }
   }
  } while (0);
  if ((i7 | 0) == 10) {
   i9 = (i8 | 0) == 0;
   i7 = 12;
  }
  do {
   if ((i7 | 0) == 12) {
    i7 = 0;
    if ((_lua_type(i1, -1) | 0) == 0) {
     if (i9) {
      i7 = 17;
      break;
     } else {
      break;
     }
    }
    i10 = _lua_tolstring(i1, -1, 0) | 0;
    i8 = HEAP32[20] | 0;
    if ((i8 | 0) != 0) {
     HEAP32[i3 >> 2] = i8;
     _fprintf(i5 | 0, 496, i3 | 0) | 0;
     _fflush(i5 | 0) | 0;
    }
    HEAP32[i3 >> 2] = (i10 | 0) == 0 ? 48 : i10;
    _fprintf(i5 | 0, 912, i3 | 0) | 0;
    _fflush(i5 | 0) | 0;
    _lua_settop(i1, -2);
    _lua_gc(i1, 2, 0) | 0;
    if (i9) {
     i7 = 17;
    }
   }
  } while (0);
  if (((i7 | 0) == 17 ? (0, (_lua_gettop(i1) | 0) > 0) : 0) ? (_luaL_checkstack(i1, 20, 112), _lua_getglobal(i1, 144), _lua_insert(i1, 1), (_lua_pcallk(i1, (_lua_gettop(i1) | 0) + -1 | 0, 0, 0, 0, 0) | 0) != 0) : 0) {
   i7 = HEAP32[20] | 0;
   HEAP32[i3 >> 2] = _lua_tolstring(i1, -1, 0) | 0;
   i8 = _lua_pushfstring(i1, 152, i3) | 0;
   if ((i7 | 0) != 0) {
    HEAP32[i3 >> 2] = i7;
    _fprintf(i5 | 0, 496, i3 | 0) | 0;
    _fflush(i5 | 0) | 0;
   }
   HEAP32[i3 >> 2] = i8;
   _fprintf(i5 | 0, 912, i3 | 0) | 0;
   _fflush(i5 | 0) | 0;
  }
  _lua_settop(i1, 0);
  if ((_pushline(i1, 1) | 0) == 0) {
   i7 = 23;
   break;
  }
 }
 if ((i7 | 0) == 23) {
  _lua_settop(i1, 0);
  i10 = HEAP32[_stdout >> 2] | 0;
  _fputc(10, i10 | 0) | 0;
  _fflush(i10 | 0) | 0;
  HEAP32[20] = i2;
  STACKTOP = i6;
  return;
 }
}
function _test_then_block(i5, i1) {
 i5 = i5 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 48 | 0;
 i10 = i2 + 24 | 0;
 i9 = i2;
 i8 = i5 + 48 | 0;
 i4 = HEAP32[i8 >> 2] | 0;
 _luaX_next(i5);
 _subexpr(i5, i9, 0) | 0;
 i3 = i5 + 16 | 0;
 if ((HEAP32[i3 >> 2] | 0) != 275) {
  _error_expected(i5, 275);
 }
 _luaX_next(i5);
 i14 = HEAP32[i3 >> 2] | 0;
 do {
  if ((i14 | 0) == 258 | (i14 | 0) == 266) {
   _luaK_goiffalse(HEAP32[i8 >> 2] | 0, i9);
   HEAP8[i10 + 10 | 0] = 0;
   HEAP8[i10 + 8 | 0] = HEAP8[i4 + 46 | 0] | 0;
   i11 = HEAP32[(HEAP32[i4 + 12 >> 2] | 0) + 64 >> 2] | 0;
   HEAP16[i10 + 4 >> 1] = HEAP32[i11 + 28 >> 2];
   HEAP16[i10 + 6 >> 1] = HEAP32[i11 + 16 >> 2];
   HEAP8[i10 + 9 | 0] = 0;
   i11 = i4 + 16 | 0;
   HEAP32[i10 >> 2] = HEAP32[i11 >> 2];
   HEAP32[i11 >> 2] = i10;
   i11 = HEAP32[i9 + 16 >> 2] | 0;
   i10 = HEAP32[i5 + 4 >> 2] | 0;
   i14 = (HEAP32[i3 >> 2] | 0) == 266;
   _luaX_next(i5);
   do {
    if (i14) {
     if ((HEAP32[i3 >> 2] | 0) == 288) {
      i7 = HEAP32[i5 + 24 >> 2] | 0;
      _luaX_next(i5);
      break;
     } else {
      _error_expected(i5, 288);
     }
    } else {
     i7 = _luaS_new(HEAP32[i5 + 52 >> 2] | 0, 6304) | 0;
    }
   } while (0);
   i14 = HEAP32[i5 + 64 >> 2] | 0;
   i12 = i14 + 12 | 0;
   i13 = i14 + 16 | 0;
   i9 = HEAP32[i13 >> 2] | 0;
   i14 = i14 + 20 | 0;
   if ((i9 | 0) < (HEAP32[i14 >> 2] | 0)) {
    i14 = HEAP32[i12 >> 2] | 0;
   } else {
    i14 = _luaM_growaux_(HEAP32[i5 + 52 >> 2] | 0, HEAP32[i12 >> 2] | 0, i14, 16, 32767, 6312) | 0;
    HEAP32[i12 >> 2] = i14;
   }
   HEAP32[i14 + (i9 << 4) >> 2] = i7;
   i14 = HEAP32[i12 >> 2] | 0;
   HEAP32[i14 + (i9 << 4) + 8 >> 2] = i10;
   HEAP8[i14 + (i9 << 4) + 12 | 0] = HEAP8[(HEAP32[i8 >> 2] | 0) + 46 | 0] | 0;
   HEAP32[(HEAP32[i12 >> 2] | 0) + (i9 << 4) + 4 >> 2] = i11;
   HEAP32[i13 >> 2] = (HEAP32[i13 >> 2] | 0) + 1;
   _findlabel(i5, i9) | 0;
   L18 : while (1) {
    switch (HEAP32[i3 >> 2] | 0) {
    case 286:
    case 262:
    case 261:
    case 260:
     {
      break L18;
     }
    case 285:
    case 59:
     {
      break;
     }
    default:
     {
      i6 = 16;
      break L18;
     }
    }
    _statement(i5);
   }
   if ((i6 | 0) == 16) {
    i6 = _luaK_jump(i4) | 0;
    break;
   }
   _leaveblock(i4);
   STACKTOP = i2;
   return;
  } else {
   _luaK_goiftrue(HEAP32[i8 >> 2] | 0, i9);
   HEAP8[i10 + 10 | 0] = 0;
   HEAP8[i10 + 8 | 0] = HEAP8[i4 + 46 | 0] | 0;
   i6 = HEAP32[(HEAP32[i4 + 12 >> 2] | 0) + 64 >> 2] | 0;
   HEAP16[i10 + 4 >> 1] = HEAP32[i6 + 28 >> 2];
   HEAP16[i10 + 6 >> 1] = HEAP32[i6 + 16 >> 2];
   HEAP8[i10 + 9 | 0] = 0;
   i6 = i4 + 16 | 0;
   HEAP32[i10 >> 2] = HEAP32[i6 >> 2];
   HEAP32[i6 >> 2] = i10;
   i6 = HEAP32[i9 + 20 >> 2] | 0;
  }
 } while (0);
 L26 : do {
  i7 = HEAP32[i3 >> 2] | 0;
  switch (i7 | 0) {
  case 277:
  case 286:
  case 262:
  case 261:
  case 260:
   {
    break L26;
   }
  default:
   {}
  }
  _statement(i5);
 } while ((i7 | 0) != 274);
 _leaveblock(i4);
 if (((HEAP32[i3 >> 2] | 0) + -260 | 0) >>> 0 < 2) {
  _luaK_concat(i4, i1, _luaK_jump(i4) | 0);
 }
 _luaK_patchtohere(i4, i6);
 STACKTOP = i2;
 return;
}
function _luaL_gsub(i2, i13, i11, i10) {
 i2 = i2 | 0;
 i13 = i13 | 0;
 i11 = i11 | 0;
 i10 = i10 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i12 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 1056 | 0;
 i8 = i1;
 i4 = i1 + 8 | 0;
 i9 = _strlen(i11 | 0) | 0;
 i6 = i4 + 12 | 0;
 HEAP32[i6 >> 2] = i2;
 i3 = i4 + 16 | 0;
 HEAP32[i4 >> 2] = i3;
 i5 = i4 + 8 | 0;
 HEAP32[i5 >> 2] = 0;
 i7 = i4 + 4 | 0;
 HEAP32[i7 >> 2] = 1024;
 i12 = _strstr(i13, i11) | 0;
 if ((i12 | 0) == 0) {
  i14 = 0;
  i17 = 1024;
  i16 = i2;
 } else {
  i14 = 0;
  i17 = 1024;
  i16 = i2;
  do {
   i15 = i12 - i13 | 0;
   if ((i17 - i14 | 0) >>> 0 < i15 >>> 0) {
    i17 = i17 << 1;
    i17 = (i17 - i14 | 0) >>> 0 < i15 >>> 0 ? i14 + i15 | 0 : i17;
    if (i17 >>> 0 < i14 >>> 0 | (i17 - i14 | 0) >>> 0 < i15 >>> 0) {
     _luaL_error(i16, 1272, i8) | 0;
    }
    i14 = _lua_newuserdata(i16, i17) | 0;
    _memcpy(i14 | 0, HEAP32[i4 >> 2] | 0, HEAP32[i5 >> 2] | 0) | 0;
    if ((HEAP32[i4 >> 2] | 0) != (i3 | 0)) {
     _lua_remove(i16, -2);
    }
    HEAP32[i4 >> 2] = i14;
    HEAP32[i7 >> 2] = i17;
    i16 = i14;
    i14 = HEAP32[i5 >> 2] | 0;
   } else {
    i16 = HEAP32[i4 >> 2] | 0;
   }
   _memcpy(i16 + i14 | 0, i13 | 0, i15 | 0) | 0;
   i15 = (HEAP32[i5 >> 2] | 0) + i15 | 0;
   HEAP32[i5 >> 2] = i15;
   i13 = _strlen(i10 | 0) | 0;
   i14 = HEAP32[i6 >> 2] | 0;
   i16 = HEAP32[i7 >> 2] | 0;
   if ((i16 - i15 | 0) >>> 0 < i13 >>> 0) {
    i16 = i16 << 1;
    i16 = (i16 - i15 | 0) >>> 0 < i13 >>> 0 ? i15 + i13 | 0 : i16;
    if (i16 >>> 0 < i15 >>> 0 | (i16 - i15 | 0) >>> 0 < i13 >>> 0) {
     _luaL_error(i14, 1272, i8) | 0;
    }
    i15 = _lua_newuserdata(i14, i16) | 0;
    _memcpy(i15 | 0, HEAP32[i4 >> 2] | 0, HEAP32[i5 >> 2] | 0) | 0;
    if ((HEAP32[i4 >> 2] | 0) != (i3 | 0)) {
     _lua_remove(i14, -2);
    }
    HEAP32[i4 >> 2] = i15;
    HEAP32[i7 >> 2] = i16;
    i14 = i15;
    i15 = HEAP32[i5 >> 2] | 0;
   } else {
    i14 = HEAP32[i4 >> 2] | 0;
   }
   _memcpy(i14 + i15 | 0, i10 | 0, i13 | 0) | 0;
   i14 = (HEAP32[i5 >> 2] | 0) + i13 | 0;
   HEAP32[i5 >> 2] = i14;
   i13 = i12 + i9 | 0;
   i12 = _strstr(i13, i11) | 0;
   i16 = HEAP32[i6 >> 2] | 0;
   i17 = HEAP32[i7 >> 2] | 0;
  } while ((i12 | 0) != 0);
 }
 i9 = _strlen(i13 | 0) | 0;
 if ((i17 - i14 | 0) >>> 0 < i9 >>> 0) {
  i10 = i17 << 1;
  i10 = (i10 - i14 | 0) >>> 0 < i9 >>> 0 ? i14 + i9 | 0 : i10;
  if (i10 >>> 0 < i14 >>> 0 | (i10 - i14 | 0) >>> 0 < i9 >>> 0) {
   _luaL_error(i16, 1272, i8) | 0;
  }
  i8 = _lua_newuserdata(i16, i10) | 0;
  _memcpy(i8 | 0, HEAP32[i4 >> 2] | 0, HEAP32[i5 >> 2] | 0) | 0;
  if ((HEAP32[i4 >> 2] | 0) != (i3 | 0)) {
   _lua_remove(i16, -2);
  }
  HEAP32[i4 >> 2] = i8;
  HEAP32[i7 >> 2] = i10;
  i14 = HEAP32[i5 >> 2] | 0;
 } else {
  i8 = HEAP32[i4 >> 2] | 0;
 }
 _memcpy(i8 + i14 | 0, i13 | 0, i9 | 0) | 0;
 i17 = (HEAP32[i5 >> 2] | 0) + i9 | 0;
 HEAP32[i5 >> 2] = i17;
 i5 = HEAP32[i6 >> 2] | 0;
 _lua_pushlstring(i5, HEAP32[i4 >> 2] | 0, i17) | 0;
 if ((HEAP32[i4 >> 2] | 0) == (i3 | 0)) {
  i17 = _lua_tolstring(i2, -1, 0) | 0;
  STACKTOP = i1;
  return i17 | 0;
 }
 _lua_remove(i5, -2);
 i17 = _lua_tolstring(i2, -1, 0) | 0;
 STACKTOP = i1;
 return i17 | 0;
}
function _luaK_goiffalse(i1, i3) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0;
 i2 = STACKTOP;
 _luaK_dischargevars(i1, i3);
 i9 = HEAP32[i3 >> 2] | 0;
 do {
  if ((i9 | 0) == 10) {
   i4 = HEAP32[i3 + 8 >> 2] | 0;
   i8 = 15;
  } else if (!((i9 | 0) == 3 | (i9 | 0) == 1)) {
   i4 = i3 + 8 | 0;
   if ((i9 | 0) == 6) {
    i8 = 11;
   } else if ((i9 | 0) == 11 ? (i10 = HEAP32[(HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0) + (HEAP32[i4 >> 2] << 2) >> 2] | 0, (i10 & 63 | 0) == 20) : 0) {
    i4 = i1 + 20 | 0;
    HEAP32[i4 >> 2] = (HEAP32[i4 >> 2] | 0) + -1;
    i4 = _condjump(i1, 27, i10 >>> 23, 0, 0) | 0;
    i8 = 15;
    break;
   } else {
    i8 = 6;
   }
   if ((i8 | 0) == 6) {
    i9 = i1 + 48 | 0;
    i11 = HEAP8[i9] | 0;
    i10 = (i11 & 255) + 1 | 0;
    i12 = (HEAP32[i1 >> 2] | 0) + 78 | 0;
    do {
     if (i10 >>> 0 > (HEAPU8[i12] | 0) >>> 0) {
      if (i10 >>> 0 > 249) {
       _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10536);
      } else {
       HEAP8[i12] = i10;
       i7 = HEAP8[i9] | 0;
       break;
      }
     } else {
      i7 = i11;
     }
    } while (0);
    i12 = (i7 & 255) + 1 | 0;
    HEAP8[i9] = i12;
    _discharge2reg(i1, i3, (i12 & 255) + -1 | 0);
    if ((HEAP32[i3 >> 2] | 0) == 6) {
     i8 = 11;
    }
   }
   if (((i8 | 0) == 11 ? (i6 = HEAP32[i4 >> 2] | 0, (i6 & 256 | 0) == 0) : 0) ? (HEAPU8[i1 + 46 | 0] | 0 | 0) <= (i6 | 0) : 0) {
    i12 = i1 + 48 | 0;
    HEAP8[i12] = (HEAP8[i12] | 0) + -1 << 24 >> 24;
   }
   i4 = _condjump(i1, 28, 255, HEAP32[i4 >> 2] | 0, 1) | 0;
   i8 = 15;
  }
 } while (0);
 do {
  if ((i8 | 0) == 15 ? (i5 = i3 + 16 | 0, !((i4 | 0) == -1)) : 0) {
   i8 = HEAP32[i5 >> 2] | 0;
   if ((i8 | 0) == -1) {
    HEAP32[i5 >> 2] = i4;
    break;
   }
   i5 = HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0;
   while (1) {
    i7 = i5 + (i8 << 2) | 0;
    i6 = HEAP32[i7 >> 2] | 0;
    i9 = (i6 >>> 14) + -131071 | 0;
    if ((i9 | 0) == -1) {
     break;
    }
    i9 = i8 + 1 + i9 | 0;
    if ((i9 | 0) == -1) {
     break;
    } else {
     i8 = i9;
    }
   }
   i4 = i4 + ~i8 | 0;
   if ((((i4 | 0) > -1 ? i4 : 0 - i4 | 0) | 0) > 131071) {
    _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10624);
   } else {
    HEAP32[i7 >> 2] = (i4 << 14) + 2147467264 | i6 & 16383;
    break;
   }
  }
 } while (0);
 i3 = i3 + 20 | 0;
 i4 = HEAP32[i3 >> 2] | 0;
 HEAP32[i1 + 24 >> 2] = HEAP32[i1 + 20 >> 2];
 i5 = i1 + 28 | 0;
 if ((i4 | 0) == -1) {
  HEAP32[i3 >> 2] = -1;
  STACKTOP = i2;
  return;
 }
 i8 = HEAP32[i5 >> 2] | 0;
 if ((i8 | 0) == -1) {
  HEAP32[i5 >> 2] = i4;
  HEAP32[i3 >> 2] = -1;
  STACKTOP = i2;
  return;
 }
 i7 = HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0;
 while (1) {
  i5 = i7 + (i8 << 2) | 0;
  i6 = HEAP32[i5 >> 2] | 0;
  i9 = (i6 >>> 14) + -131071 | 0;
  if ((i9 | 0) == -1) {
   break;
  }
  i9 = i8 + 1 + i9 | 0;
  if ((i9 | 0) == -1) {
   break;
  } else {
   i8 = i9;
  }
 }
 i4 = i4 + ~i8 | 0;
 if ((((i4 | 0) > -1 ? i4 : 0 - i4 | 0) | 0) > 131071) {
  _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10624);
 }
 HEAP32[i5 >> 2] = (i4 << 14) + 2147467264 | i6 & 16383;
 HEAP32[i3 >> 2] = -1;
 STACKTOP = i2;
 return;
}
function _luaV_settable(i2, i11, i7, i9) {
 i2 = i2 | 0;
 i11 = i11 | 0;
 i7 = i7 | 0;
 i9 = i9 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i8 = 0, i10 = 0, i12 = 0, i13 = 0, i14 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i5 = i6;
 i4 = i2 + 12 | 0;
 i3 = i11;
 i13 = HEAP32[i11 + 8 >> 2] | 0;
 i12 = 0;
 while (1) {
  i11 = i3 + 8 | 0;
  if ((i13 | 0) != 69) {
   i14 = _luaT_gettmbyobj(i2, i3, 1) | 0;
   i13 = HEAP32[i14 + 8 >> 2] | 0;
   if ((i13 | 0) == 0) {
    i1 = 16;
    break;
   }
  } else {
   i8 = HEAP32[i3 >> 2] | 0;
   i13 = _luaH_get(i8, i7) | 0;
   if ((HEAP32[i13 + 8 >> 2] | 0) != 0) {
    i10 = i13;
    break;
   }
   i14 = HEAP32[i8 + 8 >> 2] | 0;
   if ((i14 | 0) == 0) {
    i1 = 9;
    break;
   }
   if (!((HEAP8[i14 + 6 | 0] & 2) == 0)) {
    i1 = 9;
    break;
   }
   i14 = _luaT_gettm(i14, 1, HEAP32[(HEAP32[i4 >> 2] | 0) + 188 >> 2] | 0) | 0;
   if ((i14 | 0) == 0) {
    i1 = 9;
    break;
   }
   i13 = HEAP32[i14 + 8 >> 2] | 0;
  }
  i12 = i12 + 1 | 0;
  if ((i13 & 15 | 0) == 6) {
   i1 = 18;
   break;
  }
  if ((i12 | 0) < 100) {
   i3 = i14;
  } else {
   i1 = 19;
   break;
  }
 }
 if ((i1 | 0) == 9) {
  if ((i13 | 0) == 5192) {
   i10 = _luaH_newkey(i2, i8, i7) | 0;
  } else {
   i10 = i13;
  }
 } else if ((i1 | 0) == 16) {
  _luaG_typeerror(i2, i3, 8944);
 } else if ((i1 | 0) == 18) {
  i13 = i2 + 8 | 0;
  i8 = HEAP32[i13 >> 2] | 0;
  HEAP32[i13 >> 2] = i8 + 16;
  i5 = i14;
  i12 = HEAP32[i5 + 4 >> 2] | 0;
  i10 = i8;
  HEAP32[i10 >> 2] = HEAP32[i5 >> 2];
  HEAP32[i10 + 4 >> 2] = i12;
  HEAP32[i8 + 8 >> 2] = HEAP32[i14 + 8 >> 2];
  i14 = HEAP32[i13 >> 2] | 0;
  HEAP32[i13 >> 2] = i14 + 16;
  i8 = i3;
  i10 = HEAP32[i8 + 4 >> 2] | 0;
  i12 = i14;
  HEAP32[i12 >> 2] = HEAP32[i8 >> 2];
  HEAP32[i12 + 4 >> 2] = i10;
  HEAP32[i14 + 8 >> 2] = HEAP32[i11 >> 2];
  i14 = HEAP32[i13 >> 2] | 0;
  HEAP32[i13 >> 2] = i14 + 16;
  i12 = i7;
  i11 = HEAP32[i12 + 4 >> 2] | 0;
  i10 = i14;
  HEAP32[i10 >> 2] = HEAP32[i12 >> 2];
  HEAP32[i10 + 4 >> 2] = i11;
  HEAP32[i14 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
  i14 = HEAP32[i13 >> 2] | 0;
  HEAP32[i13 >> 2] = i14 + 16;
  i10 = i9;
  i11 = HEAP32[i10 + 4 >> 2] | 0;
  i12 = i14;
  HEAP32[i12 >> 2] = HEAP32[i10 >> 2];
  HEAP32[i12 + 4 >> 2] = i11;
  HEAP32[i14 + 8 >> 2] = HEAP32[i9 + 8 >> 2];
  _luaD_call(i2, (HEAP32[i13 >> 2] | 0) + -64 | 0, 0, HEAP8[(HEAP32[i2 + 16 >> 2] | 0) + 18 | 0] & 1);
  STACKTOP = i6;
  return;
 } else if ((i1 | 0) == 19) {
  _luaG_runerror(i2, 8976, i5);
 }
 i12 = i9;
 i13 = HEAP32[i12 + 4 >> 2] | 0;
 i14 = i10;
 HEAP32[i14 >> 2] = HEAP32[i12 >> 2];
 HEAP32[i14 + 4 >> 2] = i13;
 i14 = i9 + 8 | 0;
 HEAP32[i10 + 8 >> 2] = HEAP32[i14 >> 2];
 HEAP8[i8 + 6 | 0] = 0;
 if ((HEAP32[i14 >> 2] & 64 | 0) == 0) {
  STACKTOP = i6;
  return;
 }
 if ((HEAP8[(HEAP32[i9 >> 2] | 0) + 5 | 0] & 3) == 0) {
  STACKTOP = i6;
  return;
 }
 if ((HEAP8[i8 + 5 | 0] & 4) == 0) {
  STACKTOP = i6;
  return;
 }
 _luaC_barrierback_(i2, i8);
 STACKTOP = i6;
 return;
}
function _luaK_code(i4, i5) {
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0;
 i2 = STACKTOP;
 i1 = HEAP32[i4 >> 2] | 0;
 i7 = i4 + 28 | 0;
 i15 = HEAP32[i7 >> 2] | 0;
 i3 = i4 + 20 | 0;
 i8 = HEAP32[i3 >> 2] | 0;
 do {
  if (!((i15 | 0) == -1)) {
   i11 = HEAP32[i1 + 12 >> 2] | 0;
   while (1) {
    i12 = i11 + (i15 << 2) | 0;
    i14 = HEAP32[i12 >> 2] | 0;
    i13 = (i14 >>> 14) + -131071 | 0;
    if ((i13 | 0) == -1) {
     i13 = -1;
    } else {
     i13 = i15 + 1 + i13 | 0;
    }
    if ((i15 | 0) > 0 ? (i9 = i11 + (i15 + -1 << 2) | 0, i10 = HEAP32[i9 >> 2] | 0, (HEAP8[5584 + (i10 & 63) | 0] | 0) < 0) : 0) {
     i17 = i9;
     i16 = i10;
    } else {
     i17 = i12;
     i16 = i14;
    }
    if ((i16 & 63 | 0) == 28) {
     HEAP32[i17 >> 2] = i16 & 8372224 | i16 >>> 23 << 6 | 27;
     i14 = i8 + ~i15 | 0;
     if ((((i14 | 0) > -1 ? i14 : 0 - i14 | 0) | 0) > 131071) {
      i8 = 10;
      break;
     }
     i14 = HEAP32[i12 >> 2] & 16383 | (i14 << 14) + 2147467264;
    } else {
     i15 = i8 + ~i15 | 0;
     if ((((i15 | 0) > -1 ? i15 : 0 - i15 | 0) | 0) > 131071) {
      i8 = 13;
      break;
     }
     i14 = (i15 << 14) + 2147467264 | i14 & 16383;
    }
    HEAP32[i12 >> 2] = i14;
    if ((i13 | 0) == -1) {
     i8 = 16;
     break;
    } else {
     i15 = i13;
    }
   }
   if ((i8 | 0) == 10) {
    _luaX_syntaxerror(HEAP32[i4 + 12 >> 2] | 0, 10624);
   } else if ((i8 | 0) == 13) {
    _luaX_syntaxerror(HEAP32[i4 + 12 >> 2] | 0, 10624);
   } else if ((i8 | 0) == 16) {
    i6 = HEAP32[i3 >> 2] | 0;
    break;
   }
  } else {
   i6 = i8;
  }
 } while (0);
 HEAP32[i7 >> 2] = -1;
 i7 = i1 + 48 | 0;
 if ((i6 | 0) < (HEAP32[i7 >> 2] | 0)) {
  i7 = i1 + 12 | 0;
 } else {
  i6 = i1 + 12 | 0;
  HEAP32[i6 >> 2] = _luaM_growaux_(HEAP32[(HEAP32[i4 + 12 >> 2] | 0) + 52 >> 2] | 0, HEAP32[i6 >> 2] | 0, i7, 4, 2147483645, 10616) | 0;
  i7 = i6;
  i6 = HEAP32[i3 >> 2] | 0;
 }
 HEAP32[(HEAP32[i7 >> 2] | 0) + (i6 << 2) >> 2] = i5;
 i5 = HEAP32[i3 >> 2] | 0;
 i6 = i1 + 52 | 0;
 i4 = i4 + 12 | 0;
 if ((i5 | 0) < (HEAP32[i6 >> 2] | 0)) {
  i15 = i1 + 20 | 0;
  i17 = i5;
  i16 = HEAP32[i4 >> 2] | 0;
  i16 = i16 + 8 | 0;
  i16 = HEAP32[i16 >> 2] | 0;
  i15 = HEAP32[i15 >> 2] | 0;
  i17 = i15 + (i17 << 2) | 0;
  HEAP32[i17 >> 2] = i16;
  i17 = HEAP32[i3 >> 2] | 0;
  i16 = i17 + 1 | 0;
  HEAP32[i3 >> 2] = i16;
  STACKTOP = i2;
  return i17 | 0;
 } else {
  i15 = i1 + 20 | 0;
  HEAP32[i15 >> 2] = _luaM_growaux_(HEAP32[(HEAP32[i4 >> 2] | 0) + 52 >> 2] | 0, HEAP32[i15 >> 2] | 0, i6, 4, 2147483645, 10616) | 0;
  i17 = HEAP32[i3 >> 2] | 0;
  i16 = HEAP32[i4 >> 2] | 0;
  i16 = i16 + 8 | 0;
  i16 = HEAP32[i16 >> 2] | 0;
  i15 = HEAP32[i15 >> 2] | 0;
  i17 = i15 + (i17 << 2) | 0;
  HEAP32[i17 >> 2] = i16;
  i17 = HEAP32[i3 >> 2] | 0;
  i16 = i17 + 1 | 0;
  HEAP32[i3 >> 2] = i16;
  STACKTOP = i2;
  return i17 | 0;
 }
 return 0;
}
function _luaH_next(i9, i5, i2) {
 i9 = i9 | 0;
 i5 = i5 | 0;
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, d14 = 0.0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i8 = i1 + 8 | 0;
 i11 = i1;
 i3 = i2 + 8 | 0;
 i10 = HEAP32[i3 >> 2] | 0;
 do {
  if ((i10 | 0) != 0) {
   if ((((i10 | 0) == 3 ? (d14 = +HEAPF64[i2 >> 3], HEAPF64[i11 >> 3] = d14 + 6755399441055744.0, i12 = HEAP32[i11 >> 2] | 0, +(i12 | 0) == d14) : 0) ? (i12 | 0) > 0 : 0) ? (i13 = HEAP32[i5 + 28 >> 2] | 0, (i12 | 0) <= (i13 | 0)) : 0) {
    i6 = i13;
    i7 = i12 + -1 | 0;
    break;
   }
   i10 = _mainposition(i5, i2) | 0;
   while (1) {
    i4 = i10 + 16 | 0;
    i11 = i10 + 24 | 0;
    i12 = HEAP32[i11 >> 2] | 0;
    if ((i12 | 0) == (HEAP32[i3 >> 2] | 0)) {
     if ((_luaV_equalobj_(0, i4, i2) | 0) != 0) {
      i4 = 15;
      break;
     }
     i12 = HEAP32[i11 >> 2] | 0;
    }
    if (((i12 | 0) == 11 ? (HEAP32[i3 >> 2] & 64 | 0) != 0 : 0) ? (HEAP32[i4 >> 2] | 0) == (HEAP32[i2 >> 2] | 0) : 0) {
     i4 = 15;
     break;
    }
    i10 = HEAP32[i10 + 28 >> 2] | 0;
    if ((i10 | 0) == 0) {
     i4 = 18;
     break;
    }
   }
   if ((i4 | 0) == 15) {
    i7 = HEAP32[i5 + 28 >> 2] | 0;
    i6 = i7;
    i7 = (i10 - (HEAP32[i5 + 16 >> 2] | 0) >> 5) + i7 | 0;
    break;
   } else if ((i4 | 0) == 18) {
    _luaG_runerror(i9, 8064, i8);
   }
  } else {
   i6 = HEAP32[i5 + 28 >> 2] | 0;
   i7 = -1;
  }
 } while (0);
 i8 = i5 + 12 | 0;
 while (1) {
  i9 = i7 + 1 | 0;
  if ((i9 | 0) >= (i6 | 0)) {
   break;
  }
  i11 = HEAP32[i8 >> 2] | 0;
  i10 = i11 + (i9 << 4) + 8 | 0;
  if ((HEAP32[i10 >> 2] | 0) == 0) {
   i7 = i9;
  } else {
   i4 = 21;
   break;
  }
 }
 if ((i4 | 0) == 21) {
  HEAPF64[i2 >> 3] = +(i7 + 2 | 0);
  HEAP32[i3 >> 2] = 3;
  i11 = i11 + (i9 << 4) | 0;
  i12 = HEAP32[i11 + 4 >> 2] | 0;
  i13 = i2 + 16 | 0;
  HEAP32[i13 >> 2] = HEAP32[i11 >> 2];
  HEAP32[i13 + 4 >> 2] = i12;
  HEAP32[i2 + 24 >> 2] = HEAP32[i10 >> 2];
  i13 = 1;
  STACKTOP = i1;
  return i13 | 0;
 }
 i8 = i9 - i6 | 0;
 i6 = 1 << (HEAPU8[i5 + 7 | 0] | 0);
 if ((i8 | 0) >= (i6 | 0)) {
  i13 = 0;
  STACKTOP = i1;
  return i13 | 0;
 }
 i7 = i5 + 16 | 0;
 i5 = HEAP32[i7 >> 2] | 0;
 while (1) {
  i9 = i8 + 1 | 0;
  if ((HEAP32[i5 + (i8 << 5) + 8 >> 2] | 0) != 0) {
   break;
  }
  if ((i9 | 0) < (i6 | 0)) {
   i8 = i9;
  } else {
   i2 = 0;
   i4 = 27;
   break;
  }
 }
 if ((i4 | 0) == 27) {
  STACKTOP = i1;
  return i2 | 0;
 }
 i11 = i5 + (i8 << 5) + 16 | 0;
 i10 = HEAP32[i11 + 4 >> 2] | 0;
 i13 = i2;
 HEAP32[i13 >> 2] = HEAP32[i11 >> 2];
 HEAP32[i13 + 4 >> 2] = i10;
 HEAP32[i3 >> 2] = HEAP32[i5 + (i8 << 5) + 24 >> 2];
 i13 = HEAP32[i7 >> 2] | 0;
 i10 = i13 + (i8 << 5) | 0;
 i11 = HEAP32[i10 + 4 >> 2] | 0;
 i12 = i2 + 16 | 0;
 HEAP32[i12 >> 2] = HEAP32[i10 >> 2];
 HEAP32[i12 + 4 >> 2] = i11;
 HEAP32[i2 + 24 >> 2] = HEAP32[i13 + (i8 << 5) + 8 >> 2];
 i13 = 1;
 STACKTOP = i1;
 return i13 | 0;
}
function _g_read(i1, i3, i2) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 i2 = i2 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 1056 | 0;
 i7 = i4 + 8 | 0;
 i9 = i4;
 i10 = _lua_gettop(i1) | 0;
 _clearerr(i3 | 0);
 L1 : do {
  if ((i10 | 0) == 1) {
   i11 = i2 + 1 | 0;
   i12 = _read_line(i1, i3, 1) | 0;
  } else {
   _luaL_checkstack(i1, i10 + 19 | 0, 3256);
   i6 = i7 + 8 | 0;
   i5 = i7 + 8 | 0;
   i10 = i10 + -2 | 0;
   i11 = i2;
   L4 : while (1) {
    do {
     if ((_lua_type(i1, i11) | 0) == 3) {
      i12 = _lua_tointegerx(i1, i11, 0) | 0;
      if ((i12 | 0) == 0) {
       i12 = _fgetc(i3 | 0) | 0;
       _ungetc(i12 | 0, i3 | 0) | 0;
       _lua_pushlstring(i1, 0, 0) | 0;
       i12 = (i12 | 0) != -1 | 0;
       break;
      } else {
       _luaL_buffinit(i1, i7);
       i12 = _fread(_luaL_prepbuffsize(i7, i12) | 0, 1, i12 | 0, i3 | 0) | 0;
       HEAP32[i6 >> 2] = (HEAP32[i6 >> 2] | 0) + i12;
       _luaL_pushresult(i7);
       i12 = (i12 | 0) != 0 | 0;
       break;
      }
     } else {
      i12 = _lua_tolstring(i1, i11, 0) | 0;
      if (!((i12 | 0) != 0 ? (HEAP8[i12] | 0) == 42 : 0)) {
       _luaL_argerror(i1, i11, 3280) | 0;
      }
      i12 = HEAP8[i12 + 1 | 0] | 0;
      if ((i12 | 0) == 110) {
       HEAP32[i7 >> 2] = i9;
       if ((_fscanf(i3 | 0, 3312, i7 | 0) | 0) != 1) {
        i8 = 14;
        break L4;
       }
       _lua_pushnumber(i1, +HEAPF64[i9 >> 3]);
       i12 = 1;
       break;
      } else if ((i12 | 0) == 108) {
       i12 = _read_line(i1, i3, 1) | 0;
       break;
      } else if ((i12 | 0) == 76) {
       i12 = _read_line(i1, i3, 0) | 0;
       break;
      } else if ((i12 | 0) == 97) {
       _luaL_buffinit(i1, i7);
       i12 = _fread(_luaL_prepbuffsize(i7, 1024) | 0, 1, 1024, i3 | 0) | 0;
       HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + i12;
       if (!(i12 >>> 0 < 1024)) {
        i12 = 1024;
        do {
         i12 = i12 << (i12 >>> 0 < 1073741824);
         i13 = _fread(_luaL_prepbuffsize(i7, i12) | 0, 1, i12 | 0, i3 | 0) | 0;
         HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + i13;
        } while (!(i13 >>> 0 < i12 >>> 0));
       }
       _luaL_pushresult(i7);
       i12 = 1;
       break;
      } else {
       break L4;
      }
     }
    } while (0);
    i11 = i11 + 1 | 0;
    if ((i10 | 0) == 0 | (i12 | 0) == 0) {
     break L1;
    } else {
     i10 = i10 + -1 | 0;
    }
   }
   if ((i8 | 0) == 14) {
    _lua_pushnil(i1);
    i11 = i11 + 1 | 0;
    i12 = 0;
    break;
   }
   i13 = _luaL_argerror(i1, i11, 3296) | 0;
   STACKTOP = i4;
   return i13 | 0;
  }
 } while (0);
 if ((_ferror(i3 | 0) | 0) != 0) {
  i13 = _luaL_fileresult(i1, 0, 0) | 0;
  STACKTOP = i4;
  return i13 | 0;
 }
 if ((i12 | 0) == 0) {
  _lua_settop(i1, -2);
  _lua_pushnil(i1);
 }
 i13 = i11 - i2 | 0;
 STACKTOP = i4;
 return i13 | 0;
}
function _luaY_parser(i8, i12, i10, i11, i9, i13) {
 i8 = i8 | 0;
 i12 = i12 | 0;
 i10 = i10 | 0;
 i11 = i11 | 0;
 i9 = i9 | 0;
 i13 = i13 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i14 = 0, i15 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 176 | 0;
 i5 = i2 + 156 | 0;
 i7 = i2 + 80 | 0;
 i4 = i2;
 i6 = i2 + 104 | 0;
 i3 = _luaF_newLclosure(i8, 1) | 0;
 i15 = i8 + 8 | 0;
 i14 = HEAP32[i15 >> 2] | 0;
 HEAP32[i14 >> 2] = i3;
 HEAP32[i14 + 8 >> 2] = 70;
 i14 = (HEAP32[i15 >> 2] | 0) + 16 | 0;
 HEAP32[i15 >> 2] = i14;
 if (((HEAP32[i8 + 24 >> 2] | 0) - i14 | 0) < 16) {
  _luaD_growstack(i8, 0);
 }
 i14 = _luaF_newproto(i8) | 0;
 HEAP32[i3 + 12 >> 2] = i14;
 HEAP32[i6 >> 2] = i14;
 i9 = _luaS_new(i8, i9) | 0;
 HEAP32[(HEAP32[i6 >> 2] | 0) + 36 >> 2] = i9;
 HEAP32[i4 + 60 >> 2] = i10;
 i9 = i4 + 64 | 0;
 HEAP32[i9 >> 2] = i11;
 HEAP32[i11 + 28 >> 2] = 0;
 HEAP32[i11 + 16 >> 2] = 0;
 HEAP32[i11 + 4 >> 2] = 0;
 _luaX_setinput(i8, i4, i12, HEAP32[(HEAP32[i6 >> 2] | 0) + 36 >> 2] | 0, i13);
 i10 = HEAP32[i4 + 52 >> 2] | 0;
 i13 = i4 + 48 | 0;
 HEAP32[i6 + 8 >> 2] = HEAP32[i13 >> 2];
 i8 = i6 + 12 | 0;
 HEAP32[i8 >> 2] = i4;
 HEAP32[i13 >> 2] = i6;
 HEAP32[i6 + 20 >> 2] = 0;
 HEAP32[i6 + 24 >> 2] = 0;
 HEAP32[i6 + 28 >> 2] = -1;
 HEAP32[i6 + 32 >> 2] = 0;
 HEAP32[i6 + 36 >> 2] = 0;
 i13 = i6 + 44 | 0;
 HEAP32[i13 + 0 >> 2] = 0;
 HEAP8[i13 + 4 | 0] = 0;
 HEAP32[i6 + 40 >> 2] = HEAP32[(HEAP32[i9 >> 2] | 0) + 4 >> 2];
 i9 = i6 + 16 | 0;
 HEAP32[i9 >> 2] = 0;
 i13 = HEAP32[i6 >> 2] | 0;
 HEAP32[i13 + 36 >> 2] = HEAP32[i4 + 68 >> 2];
 HEAP8[i13 + 78 | 0] = 2;
 i13 = _luaH_new(i10) | 0;
 HEAP32[i6 + 4 >> 2] = i13;
 i14 = i10 + 8 | 0;
 i15 = HEAP32[i14 >> 2] | 0;
 HEAP32[i15 >> 2] = i13;
 HEAP32[i15 + 8 >> 2] = 69;
 i15 = (HEAP32[i14 >> 2] | 0) + 16 | 0;
 HEAP32[i14 >> 2] = i15;
 if (((HEAP32[i10 + 24 >> 2] | 0) - i15 | 0) < 16) {
  _luaD_growstack(i10, 0);
 }
 HEAP8[i5 + 10 | 0] = 0;
 HEAP8[i5 + 8 | 0] = HEAP8[i6 + 46 | 0] | 0;
 i15 = HEAP32[(HEAP32[i8 >> 2] | 0) + 64 >> 2] | 0;
 HEAP16[i5 + 4 >> 1] = HEAP32[i15 + 28 >> 2];
 HEAP16[i5 + 6 >> 1] = HEAP32[i15 + 16 >> 2];
 HEAP8[i5 + 9 | 0] = 0;
 HEAP32[i5 >> 2] = HEAP32[i9 >> 2];
 HEAP32[i9 >> 2] = i5;
 HEAP8[(HEAP32[i6 >> 2] | 0) + 77 | 0] = 1;
 HEAP32[i7 + 16 >> 2] = -1;
 HEAP32[i7 + 20 >> 2] = -1;
 HEAP32[i7 >> 2] = 7;
 HEAP32[i7 + 8 >> 2] = 0;
 _newupvalue(i6, HEAP32[i4 + 72 >> 2] | 0, i7) | 0;
 _luaX_next(i4);
 i5 = i4 + 16 | 0;
 L7 : while (1) {
  i6 = HEAP32[i5 >> 2] | 0;
  switch (i6 | 0) {
  case 277:
  case 286:
  case 262:
  case 261:
  case 260:
   {
    break L7;
   }
  default:
   {}
  }
  _statement(i4);
  if ((i6 | 0) == 274) {
   i1 = 8;
   break;
  }
 }
 if ((i1 | 0) == 8) {
  i6 = HEAP32[i5 >> 2] | 0;
 }
 if ((i6 | 0) == 286) {
  _close_func(i4);
  STACKTOP = i2;
  return i3 | 0;
 } else {
  _error_expected(i4, 286);
 }
 return 0;
}
function _luaV_lessthan(i5, i4, i2) {
 i5 = i5 | 0;
 i4 = i4 | 0;
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i1 = STACKTOP;
 i6 = i4 + 8 | 0;
 i7 = HEAP32[i6 >> 2] | 0;
 if ((i7 | 0) == 3) {
  if ((HEAP32[i2 + 8 >> 2] | 0) == 3) {
   i9 = +HEAPF64[i4 >> 3] < +HEAPF64[i2 >> 3] | 0;
   STACKTOP = i1;
   return i9 | 0;
  }
 } else {
  if ((i7 & 15 | 0) == 4 ? (HEAP32[i2 + 8 >> 2] & 15 | 0) == 4 : 0) {
   i6 = HEAP32[i4 >> 2] | 0;
   i4 = HEAP32[i2 >> 2] | 0;
   i3 = i6 + 16 | 0;
   i5 = i4 + 16 | 0;
   i7 = _strcmp(i3, i5) | 0;
   L8 : do {
    if ((i7 | 0) == 0) {
     i2 = HEAP32[i6 + 12 >> 2] | 0;
     i4 = HEAP32[i4 + 12 >> 2] | 0;
     while (1) {
      i7 = _strlen(i3 | 0) | 0;
      i6 = (i7 | 0) == (i2 | 0);
      if ((i7 | 0) == (i4 | 0)) {
       break;
      }
      if (i6) {
       i7 = -1;
       break L8;
      }
      i6 = i7 + 1 | 0;
      i3 = i3 + i6 | 0;
      i5 = i5 + i6 | 0;
      i7 = _strcmp(i3, i5) | 0;
      if ((i7 | 0) == 0) {
       i2 = i2 - i6 | 0;
       i4 = i4 - i6 | 0;
      } else {
       break L8;
      }
     }
     i7 = i6 & 1 ^ 1;
    }
   } while (0);
   i9 = i7 >>> 31;
   STACKTOP = i1;
   return i9 | 0;
  }
 }
 i8 = i5 + 8 | 0;
 i7 = HEAP32[i8 >> 2] | 0;
 i9 = _luaT_gettmbyobj(i5, i4, 13) | 0;
 if ((HEAP32[i9 + 8 >> 2] | 0) == 0) {
  i9 = _luaT_gettmbyobj(i5, i2, 13) | 0;
  if ((HEAP32[i9 + 8 >> 2] | 0) == 0) {
   _luaG_ordererror(i5, i4, i2);
  } else {
   i3 = i9;
  }
 } else {
  i3 = i9;
 }
 i10 = i5 + 28 | 0;
 i9 = i7 - (HEAP32[i10 >> 2] | 0) | 0;
 i11 = HEAP32[i8 >> 2] | 0;
 HEAP32[i8 >> 2] = i11 + 16;
 i13 = i3;
 i12 = HEAP32[i13 + 4 >> 2] | 0;
 i7 = i11;
 HEAP32[i7 >> 2] = HEAP32[i13 >> 2];
 HEAP32[i7 + 4 >> 2] = i12;
 HEAP32[i11 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 i3 = HEAP32[i8 >> 2] | 0;
 HEAP32[i8 >> 2] = i3 + 16;
 i11 = i4;
 i7 = HEAP32[i11 + 4 >> 2] | 0;
 i4 = i3;
 HEAP32[i4 >> 2] = HEAP32[i11 >> 2];
 HEAP32[i4 + 4 >> 2] = i7;
 HEAP32[i3 + 8 >> 2] = HEAP32[i6 >> 2];
 i3 = HEAP32[i8 >> 2] | 0;
 HEAP32[i8 >> 2] = i3 + 16;
 i4 = i2;
 i7 = HEAP32[i4 + 4 >> 2] | 0;
 i6 = i3;
 HEAP32[i6 >> 2] = HEAP32[i4 >> 2];
 HEAP32[i6 + 4 >> 2] = i7;
 HEAP32[i3 + 8 >> 2] = HEAP32[i2 + 8 >> 2];
 _luaD_call(i5, (HEAP32[i8 >> 2] | 0) + -48 | 0, 1, HEAP8[(HEAP32[i5 + 16 >> 2] | 0) + 18 | 0] & 1);
 i2 = HEAP32[i10 >> 2] | 0;
 i3 = HEAP32[i8 >> 2] | 0;
 i5 = i3 + -16 | 0;
 HEAP32[i8 >> 2] = i5;
 i6 = HEAP32[i5 + 4 >> 2] | 0;
 i7 = i2 + i9 | 0;
 HEAP32[i7 >> 2] = HEAP32[i5 >> 2];
 HEAP32[i7 + 4 >> 2] = i6;
 HEAP32[i2 + (i9 + 8) >> 2] = HEAP32[i3 + -8 >> 2];
 i2 = HEAP32[i8 >> 2] | 0;
 i3 = HEAP32[i2 + 8 >> 2] | 0;
 if ((i3 | 0) != 0) {
  if ((i3 | 0) == 1) {
   i2 = (HEAP32[i2 >> 2] | 0) != 0;
  } else {
   i2 = 1;
  }
 } else {
  i2 = 0;
 }
 i13 = i2 & 1;
 STACKTOP = i1;
 return i13 | 0;
}
function _discharge2reg(i4, i3, i1) {
 i4 = i4 | 0;
 i3 = i3 | 0;
 i1 = i1 | 0;
 var i2 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, d11 = 0.0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i9 = i2 + 16 | 0;
 i8 = i2;
 _luaK_dischargevars(i4, i3);
 i10 = HEAP32[i3 >> 2] | 0;
 L1 : do {
  switch (i10 | 0) {
  case 5:
   {
    d11 = +HEAPF64[i3 + 8 >> 3];
    HEAPF64[i9 >> 3] = d11;
    i5 = HEAP32[(HEAP32[i4 + 12 >> 2] | 0) + 52 >> 2] | 0;
    HEAPF64[i8 >> 3] = d11;
    HEAP32[i8 + 8 >> 2] = 3;
    if (d11 != d11 | 0.0 != 0.0 | d11 == 0.0) {
     i10 = i5 + 8 | 0;
     i7 = HEAP32[i10 >> 2] | 0;
     HEAP32[i10 >> 2] = i7 + 16;
     i5 = _luaS_newlstr(i5, i9, 8) | 0;
     HEAP32[i7 >> 2] = i5;
     HEAP32[i7 + 8 >> 2] = HEAPU8[i5 + 4 | 0] | 0 | 64;
     i5 = _addk(i4, (HEAP32[i10 >> 2] | 0) + -16 | 0, i8) | 0;
     HEAP32[i10 >> 2] = (HEAP32[i10 >> 2] | 0) + -16;
    } else {
     i5 = _addk(i4, i8, i8) | 0;
    }
    i6 = i1 << 6;
    if ((i5 | 0) < 262144) {
     _luaK_code(i4, i6 | i5 << 14 | 1) | 0;
     break L1;
    } else {
     _luaK_code(i4, i6 | 2) | 0;
     _luaK_code(i4, i5 << 6 | 39) | 0;
     break L1;
    }
   }
  case 2:
  case 3:
   {
    _luaK_code(i4, i1 << 6 | ((i10 | 0) == 2) << 23 | 3) | 0;
    break;
   }
  case 4:
   {
    i6 = HEAP32[i3 + 8 >> 2] | 0;
    i5 = i1 << 6;
    if ((i6 | 0) < 262144) {
     _luaK_code(i4, i5 | i6 << 14 | 1) | 0;
     break L1;
    } else {
     _luaK_code(i4, i5 | 2) | 0;
     _luaK_code(i4, i6 << 6 | 39) | 0;
     break L1;
    }
   }
  case 1:
   {
    i9 = i1 + 1 | 0;
    i8 = HEAP32[i4 + 20 >> 2] | 0;
    do {
     if ((i8 | 0) > (HEAP32[i4 + 24 >> 2] | 0) ? (i5 = (HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0) + (i8 + -1 << 2) | 0, i6 = HEAP32[i5 >> 2] | 0, (i6 & 63 | 0) == 4) : 0) {
      i10 = i6 >>> 6 & 255;
      i8 = i10 + (i6 >>> 23) | 0;
      if (!((i10 | 0) <= (i1 | 0) ? (i8 + 1 | 0) >= (i1 | 0) : 0)) {
       i7 = 6;
      }
      if ((i7 | 0) == 6 ? (i10 | 0) < (i1 | 0) | (i10 | 0) > (i9 | 0) : 0) {
       break;
      }
      i4 = (i10 | 0) < (i1 | 0) ? i10 : i1;
      HEAP32[i5 >> 2] = i4 << 6 & 16320 | i6 & 8372287 | ((i8 | 0) > (i1 | 0) ? i8 : i1) - i4 << 23;
      break L1;
     }
    } while (0);
    _luaK_code(i4, i1 << 6 | 4) | 0;
    break;
   }
  case 6:
   {
    i5 = HEAP32[i3 + 8 >> 2] | 0;
    if ((i5 | 0) != (i1 | 0)) {
     _luaK_code(i4, i5 << 23 | i1 << 6) | 0;
    }
    break;
   }
  case 11:
   {
    i10 = (HEAP32[(HEAP32[i4 >> 2] | 0) + 12 >> 2] | 0) + (HEAP32[i3 + 8 >> 2] << 2) | 0;
    HEAP32[i10 >> 2] = HEAP32[i10 >> 2] & -16321 | i1 << 6 & 16320;
    break;
   }
  default:
   {
    STACKTOP = i2;
    return;
   }
  }
 } while (0);
 HEAP32[i3 + 8 >> 2] = i1;
 HEAP32[i3 >> 2] = 6;
 STACKTOP = i2;
 return;
}
function _unroll(i3, i4) {
 i3 = i3 | 0;
 i4 = i4 | 0;
 var i1 = 0, i2 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0;
 i9 = STACKTOP;
 i11 = i3 + 16 | 0;
 i13 = HEAP32[i11 >> 2] | 0;
 i5 = i3 + 72 | 0;
 if ((i13 | 0) == (i5 | 0)) {
  STACKTOP = i9;
  return;
 }
 i6 = i3 + 8 | 0;
 i10 = i3 + 40 | 0;
 i7 = i3 + 20 | 0;
 i8 = i3 + 28 | 0;
 i4 = i3 + 68 | 0;
 do {
  i12 = i13 + 18 | 0;
  i14 = HEAP8[i12] | 0;
  if ((i14 & 1) == 0) {
   i14 = i14 & 255;
   if ((i14 & 16 | 0) != 0) {
    HEAP8[i12] = i14 & 239;
    HEAP32[i4 >> 2] = HEAP32[i13 + 32 >> 2];
   }
   if ((HEAP16[i13 + 16 >> 1] | 0) == -1 ? (i2 = (HEAP32[i11 >> 2] | 0) + 4 | 0, i1 = HEAP32[i6 >> 2] | 0, (HEAP32[i2 >> 2] | 0) >>> 0 < i1 >>> 0) : 0) {
    HEAP32[i2 >> 2] = i1;
   }
   i14 = HEAP8[i12] | 0;
   if ((i14 & 32) == 0) {
    HEAP8[i13 + 37 | 0] = 1;
   }
   HEAP8[i12] = i14 & 199 | 8;
   i14 = FUNCTION_TABLE_ii[HEAP32[i13 + 28 >> 2] & 255](i3) | 0;
   i14 = (HEAP32[i6 >> 2] | 0) + (0 - i14 << 4) | 0;
   i13 = HEAP32[i11 >> 2] | 0;
   i12 = HEAPU8[i10] | 0;
   if ((i12 & 6 | 0) == 0) {
    i15 = i13 + 8 | 0;
   } else {
    if ((i12 & 2 | 0) != 0) {
     i14 = i14 - (HEAP32[i8 >> 2] | 0) | 0;
     _luaD_hook(i3, 1, -1);
     i14 = (HEAP32[i8 >> 2] | 0) + i14 | 0;
    }
    i15 = i13 + 8 | 0;
    HEAP32[i7 >> 2] = HEAP32[(HEAP32[i15 >> 2] | 0) + 28 >> 2];
   }
   i12 = HEAP32[i13 >> 2] | 0;
   i13 = HEAP16[i13 + 16 >> 1] | 0;
   HEAP32[i11 >> 2] = HEAP32[i15 >> 2];
   L25 : do {
    if (!(i13 << 16 >> 16 == 0)) {
     i15 = i13 << 16 >> 16;
     if (i14 >>> 0 < (HEAP32[i6 >> 2] | 0) >>> 0) {
      i13 = i14;
      i14 = i15;
      i15 = i12;
      while (1) {
       i12 = i15 + 16 | 0;
       i18 = i13;
       i17 = HEAP32[i18 + 4 >> 2] | 0;
       i16 = i15;
       HEAP32[i16 >> 2] = HEAP32[i18 >> 2];
       HEAP32[i16 + 4 >> 2] = i17;
       HEAP32[i15 + 8 >> 2] = HEAP32[i13 + 8 >> 2];
       i14 = i14 + -1 | 0;
       i13 = i13 + 16 | 0;
       if ((i14 | 0) == 0) {
        break L25;
       }
       if (i13 >>> 0 < (HEAP32[i6 >> 2] | 0) >>> 0) {
        i15 = i12;
       } else {
        i13 = i14;
        break;
       }
      }
     } else {
      i13 = i15;
     }
     if ((i13 | 0) > 0) {
      i14 = i13;
      i15 = i12;
      while (1) {
       i14 = i14 + -1 | 0;
       HEAP32[i15 + 8 >> 2] = 0;
       if ((i14 | 0) <= 0) {
        break;
       } else {
        i15 = i15 + 16 | 0;
       }
      }
      i12 = i12 + (i13 << 4) | 0;
     }
    }
   } while (0);
   HEAP32[i6 >> 2] = i12;
  } else {
   _luaV_finishOp(i3);
   _luaV_execute(i3);
  }
  i13 = HEAP32[i11 >> 2] | 0;
 } while ((i13 | 0) != (i5 | 0));
 STACKTOP = i9;
 return;
}
function _traverseephemeron(i1, i2) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 var i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0;
 i3 = STACKTOP;
 i11 = i2 + 16 | 0;
 i9 = HEAP32[i11 >> 2] | 0;
 i5 = i9 + (1 << (HEAPU8[i2 + 7 | 0] | 0) << 5) | 0;
 i10 = i2 + 28 | 0;
 i13 = HEAP32[i10 >> 2] | 0;
 if ((i13 | 0) > 0) {
  i9 = i2 + 12 | 0;
  i12 = 0;
  i8 = 0;
  do {
   i14 = HEAP32[i9 >> 2] | 0;
   if ((HEAP32[i14 + (i12 << 4) + 8 >> 2] & 64 | 0) != 0 ? (i7 = HEAP32[i14 + (i12 << 4) >> 2] | 0, !((HEAP8[i7 + 5 | 0] & 3) == 0)) : 0) {
    _reallymarkobject(i1, i7);
    i13 = HEAP32[i10 >> 2] | 0;
    i8 = 1;
   }
   i12 = i12 + 1 | 0;
  } while ((i12 | 0) < (i13 | 0));
  i9 = HEAP32[i11 >> 2] | 0;
 } else {
  i8 = 0;
 }
 if (i9 >>> 0 < i5 >>> 0) {
  i7 = 0;
  i10 = 0;
  do {
   i11 = i9 + 8 | 0;
   i12 = HEAP32[i11 >> 2] | 0;
   i14 = i9 + 24 | 0;
   i13 = HEAP32[i14 >> 2] | 0;
   i15 = (i13 & 64 | 0) == 0;
   L14 : do {
    if ((i12 | 0) == 0) {
     if (!i15 ? !((HEAP8[(HEAP32[i9 + 16 >> 2] | 0) + 5 | 0] & 3) == 0) : 0) {
      HEAP32[i14 >> 2] = 11;
     }
    } else {
     do {
      if (i15) {
       i6 = i12;
       i4 = 18;
      } else {
       i14 = HEAP32[i9 + 16 >> 2] | 0;
       if ((i13 & 15 | 0) == 4) {
        if ((i14 | 0) == 0) {
         i6 = i12;
         i4 = 18;
         break;
        }
        if ((HEAP8[i14 + 5 | 0] & 3) == 0) {
         i6 = i12;
         i4 = 18;
         break;
        }
        _reallymarkobject(i1, i14);
        i6 = HEAP32[i11 >> 2] | 0;
        i4 = 18;
        break;
       }
       i11 = (i12 & 64 | 0) == 0;
       if ((HEAP8[i14 + 5 | 0] & 3) == 0) {
        if (i11) {
         break L14;
        } else {
         break;
        }
       }
       if (i11) {
        i7 = 1;
        break L14;
       }
       i7 = 1;
       i10 = (HEAP8[(HEAP32[i9 >> 2] | 0) + 5 | 0] & 3) == 0 ? i10 : 1;
       break L14;
      }
     } while (0);
     if ((i4 | 0) == 18 ? (i4 = 0, (i6 & 64 | 0) == 0) : 0) {
      break;
     }
     i11 = HEAP32[i9 >> 2] | 0;
     if (!((HEAP8[i11 + 5 | 0] & 3) == 0)) {
      _reallymarkobject(i1, i11);
      i8 = 1;
     }
    }
   } while (0);
   i9 = i9 + 32 | 0;
  } while (i9 >>> 0 < i5 >>> 0);
  if ((i10 | 0) != 0) {
   i15 = i1 + 96 | 0;
   HEAP32[i2 + 24 >> 2] = HEAP32[i15 >> 2];
   HEAP32[i15 >> 2] = i2;
   i15 = i8;
   STACKTOP = i3;
   return i15 | 0;
  }
  if ((i7 | 0) != 0) {
   i15 = i1 + 100 | 0;
   HEAP32[i2 + 24 >> 2] = HEAP32[i15 >> 2];
   HEAP32[i15 >> 2] = i2;
   i15 = i8;
   STACKTOP = i3;
   return i15 | 0;
  }
 }
 i15 = i1 + 88 | 0;
 HEAP32[i2 + 24 >> 2] = HEAP32[i15 >> 2];
 HEAP32[i15 >> 2] = i2;
 i15 = i8;
 STACKTOP = i3;
 return i15 | 0;
}
function _luaV_gettable(i2, i7, i5, i1) {
 i2 = i2 | 0;
 i7 = i7 | 0;
 i5 = i5 | 0;
 i1 = i1 | 0;
 var i3 = 0, i4 = 0, i6 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = i6;
 i8 = i2 + 12 | 0;
 i3 = i7;
 i10 = HEAP32[i7 + 8 >> 2] | 0;
 i9 = 0;
 while (1) {
  i7 = i3 + 8 | 0;
  if ((i10 | 0) != 69) {
   i12 = _luaT_gettmbyobj(i2, i3, 0) | 0;
   i10 = HEAP32[i12 + 8 >> 2] | 0;
   if ((i10 | 0) == 0) {
    i8 = 11;
    break;
   }
  } else {
   i12 = HEAP32[i3 >> 2] | 0;
   i11 = _luaH_get(i12, i5) | 0;
   i10 = i11 + 8 | 0;
   if ((HEAP32[i10 >> 2] | 0) != 0) {
    i8 = 9;
    break;
   }
   i12 = HEAP32[i12 + 8 >> 2] | 0;
   if ((i12 | 0) == 0) {
    i8 = 9;
    break;
   }
   if (!((HEAP8[i12 + 6 | 0] & 1) == 0)) {
    i8 = 9;
    break;
   }
   i12 = _luaT_gettm(i12, 0, HEAP32[(HEAP32[i8 >> 2] | 0) + 184 >> 2] | 0) | 0;
   if ((i12 | 0) == 0) {
    i8 = 9;
    break;
   }
   i10 = HEAP32[i12 + 8 >> 2] | 0;
  }
  i9 = i9 + 1 | 0;
  if ((i10 & 15 | 0) == 6) {
   i8 = 13;
   break;
  }
  if ((i9 | 0) < 100) {
   i3 = i12;
  } else {
   i8 = 14;
   break;
  }
 }
 if ((i8 | 0) == 9) {
  i9 = i11;
  i11 = HEAP32[i9 + 4 >> 2] | 0;
  i12 = i1;
  HEAP32[i12 >> 2] = HEAP32[i9 >> 2];
  HEAP32[i12 + 4 >> 2] = i11;
  HEAP32[i1 + 8 >> 2] = HEAP32[i10 >> 2];
  STACKTOP = i6;
  return;
 } else if ((i8 | 0) == 11) {
  _luaG_typeerror(i2, i3, 8944);
 } else if ((i8 | 0) == 13) {
  i10 = i2 + 28 | 0;
  i11 = i1 - (HEAP32[i10 >> 2] | 0) | 0;
  i8 = i2 + 8 | 0;
  i9 = HEAP32[i8 >> 2] | 0;
  HEAP32[i8 >> 2] = i9 + 16;
  i13 = i12;
  i1 = HEAP32[i13 + 4 >> 2] | 0;
  i4 = i9;
  HEAP32[i4 >> 2] = HEAP32[i13 >> 2];
  HEAP32[i4 + 4 >> 2] = i1;
  HEAP32[i9 + 8 >> 2] = HEAP32[i12 + 8 >> 2];
  i12 = HEAP32[i8 >> 2] | 0;
  HEAP32[i8 >> 2] = i12 + 16;
  i9 = HEAP32[i3 + 4 >> 2] | 0;
  i4 = i12;
  HEAP32[i4 >> 2] = HEAP32[i3 >> 2];
  HEAP32[i4 + 4 >> 2] = i9;
  HEAP32[i12 + 8 >> 2] = HEAP32[i7 >> 2];
  i12 = HEAP32[i8 >> 2] | 0;
  HEAP32[i8 >> 2] = i12 + 16;
  i4 = i5;
  i9 = HEAP32[i4 + 4 >> 2] | 0;
  i7 = i12;
  HEAP32[i7 >> 2] = HEAP32[i4 >> 2];
  HEAP32[i7 + 4 >> 2] = i9;
  HEAP32[i12 + 8 >> 2] = HEAP32[i5 + 8 >> 2];
  _luaD_call(i2, (HEAP32[i8 >> 2] | 0) + -48 | 0, 1, HEAP8[(HEAP32[i2 + 16 >> 2] | 0) + 18 | 0] & 1);
  i12 = HEAP32[i10 >> 2] | 0;
  i10 = HEAP32[i8 >> 2] | 0;
  i7 = i10 + -16 | 0;
  HEAP32[i8 >> 2] = i7;
  i8 = HEAP32[i7 + 4 >> 2] | 0;
  i9 = i12 + i11 | 0;
  HEAP32[i9 >> 2] = HEAP32[i7 >> 2];
  HEAP32[i9 + 4 >> 2] = i8;
  HEAP32[i12 + (i11 + 8) >> 2] = HEAP32[i10 + -8 >> 2];
  STACKTOP = i6;
  return;
 } else if ((i8 | 0) == 14) {
  _luaG_runerror(i2, 8952, i4);
 }
}
function _db_getinfo(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 112 | 0;
 i3 = i2;
 if ((_lua_type(i1, 1) | 0) == 8) {
  i4 = _lua_tothread(i1, 1) | 0;
  i7 = 1;
 } else {
  i4 = i1;
  i7 = 0;
 }
 i5 = i7 | 2;
 i6 = _luaL_optlstring(i1, i5, 11784, 0) | 0;
 i7 = i7 + 1 | 0;
 do {
  if ((_lua_isnumber(i1, i7) | 0) != 0) {
   if ((_lua_getstack(i4, _lua_tointegerx(i1, i7, 0) | 0, i3) | 0) == 0) {
    _lua_pushnil(i1);
    i7 = 1;
    STACKTOP = i2;
    return i7 | 0;
   }
  } else {
   if ((_lua_type(i1, i7) | 0) == 6) {
    HEAP32[i3 >> 2] = i6;
    _lua_pushfstring(i1, 11792, i3) | 0;
    i6 = _lua_tolstring(i1, -1, 0) | 0;
    _lua_pushvalue(i1, i7);
    _lua_xmove(i1, i4, 1);
    break;
   }
   i7 = _luaL_argerror(i1, i7, 11800) | 0;
   STACKTOP = i2;
   return i7 | 0;
  }
 } while (0);
 if ((_lua_getinfo(i4, i6, i3) | 0) == 0) {
  i7 = _luaL_argerror(i1, i5, 11832) | 0;
  STACKTOP = i2;
  return i7 | 0;
 }
 _lua_createtable(i1, 0, 2);
 if ((_strchr(i6, 83) | 0) != 0) {
  _lua_pushstring(i1, HEAP32[i3 + 16 >> 2] | 0) | 0;
  _lua_setfield(i1, -2, 11848);
  _lua_pushstring(i1, i3 + 36 | 0) | 0;
  _lua_setfield(i1, -2, 11856);
  _lua_pushinteger(i1, HEAP32[i3 + 24 >> 2] | 0);
  _lua_setfield(i1, -2, 11872);
  _lua_pushinteger(i1, HEAP32[i3 + 28 >> 2] | 0);
  _lua_setfield(i1, -2, 11888);
  _lua_pushstring(i1, HEAP32[i3 + 12 >> 2] | 0) | 0;
  _lua_setfield(i1, -2, 11904);
 }
 if ((_strchr(i6, 108) | 0) != 0) {
  _lua_pushinteger(i1, HEAP32[i3 + 20 >> 2] | 0);
  _lua_setfield(i1, -2, 11912);
 }
 if ((_strchr(i6, 117) | 0) != 0) {
  _lua_pushinteger(i1, HEAPU8[i3 + 32 | 0] | 0);
  _lua_setfield(i1, -2, 11928);
  _lua_pushinteger(i1, HEAPU8[i3 + 33 | 0] | 0);
  _lua_setfield(i1, -2, 11936);
  _lua_pushboolean(i1, HEAP8[i3 + 34 | 0] | 0);
  _lua_setfield(i1, -2, 11944);
 }
 if ((_strchr(i6, 110) | 0) != 0) {
  _lua_pushstring(i1, HEAP32[i3 + 4 >> 2] | 0) | 0;
  _lua_setfield(i1, -2, 11960);
  _lua_pushstring(i1, HEAP32[i3 + 8 >> 2] | 0) | 0;
  _lua_setfield(i1, -2, 11968);
 }
 if ((_strchr(i6, 116) | 0) != 0) {
  _lua_pushboolean(i1, HEAP8[i3 + 35 | 0] | 0);
  _lua_setfield(i1, -2, 11984);
 }
 if ((_strchr(i6, 76) | 0) != 0) {
  if ((i4 | 0) == (i1 | 0)) {
   _lua_pushvalue(i1, -2);
   _lua_remove(i1, -3);
  } else {
   _lua_xmove(i4, i1, 1);
  }
  _lua_setfield(i1, -2, 12e3);
 }
 if ((_strchr(i6, 102) | 0) == 0) {
  i7 = 1;
  STACKTOP = i2;
  return i7 | 0;
 }
 if ((i4 | 0) == (i1 | 0)) {
  _lua_pushvalue(i1, -2);
  _lua_remove(i1, -3);
 } else {
  _lua_xmove(i4, i1, 1);
 }
 _lua_setfield(i1, -2, 12016);
 i7 = 1;
 STACKTOP = i2;
 return i7 | 0;
}
function _luaL_traceback(i4, i1, i9, i7) {
 i4 = i4 | 0;
 i1 = i1 | 0;
 i9 = i9 | 0;
 i7 = i7 | 0;
 var i2 = 0, i3 = 0, i5 = 0, i6 = 0, i8 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0, i17 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 208 | 0;
 i6 = i3;
 i5 = i3 + 100 | 0;
 i2 = _lua_gettop(i4) | 0;
 i8 = 1;
 i10 = 1;
 while (1) {
  if ((_lua_getstack(i1, i8, i6) | 0) == 0) {
   break;
  } else {
   i10 = i8;
   i8 = i8 << 1;
  }
 }
 if ((i10 | 0) < (i8 | 0)) {
  while (1) {
   i11 = (i8 + i10 | 0) / 2 | 0;
   i12 = (_lua_getstack(i1, i11, i6) | 0) == 0;
   i8 = i12 ? i11 : i8;
   i10 = i12 ? i10 : i11 + 1 | 0;
   if ((i10 | 0) >= (i8 | 0)) {
    i10 = i8;
    break;
   }
  }
 } else {
  i10 = i8;
 }
 i8 = (i10 + -1 | 0) > 22 ? 12 : 0;
 if ((i9 | 0) != 0) {
  HEAP32[i6 >> 2] = i9;
  _lua_pushfstring(i4, 944, i6) | 0;
 }
 _lua_pushlstring(i4, 952, 16) | 0;
 if ((_lua_getstack(i1, i7, i5) | 0) == 0) {
  i17 = _lua_gettop(i4) | 0;
  i17 = i17 - i2 | 0;
  _lua_concat(i4, i17);
  STACKTOP = i3;
  return;
 }
 i10 = i10 + -11 | 0;
 i13 = i5 + 36 | 0;
 i9 = i5 + 20 | 0;
 i16 = i5 + 8 | 0;
 i12 = i5 + 12 | 0;
 i15 = i5 + 24 | 0;
 i14 = i5 + 35 | 0;
 i11 = i5 + 4 | 0;
 do {
  i7 = i7 + 1 | 0;
  if ((i7 | 0) == (i8 | 0)) {
   _lua_pushlstring(i4, 976, 5) | 0;
   i7 = i10;
  } else {
   _lua_getinfo(i1, 984, i5) | 0;
   HEAP32[i6 >> 2] = i13;
   _lua_pushfstring(i4, 992, i6) | 0;
   i17 = HEAP32[i9 >> 2] | 0;
   if ((i17 | 0) > 0) {
    HEAP32[i6 >> 2] = i17;
    _lua_pushfstring(i4, 1e3, i6) | 0;
   }
   _lua_pushlstring(i4, 1008, 4) | 0;
   do {
    if ((HEAP8[HEAP32[i16 >> 2] | 0] | 0) == 0) {
     i17 = HEAP8[HEAP32[i12 >> 2] | 0] | 0;
     if (i17 << 24 >> 24 == 109) {
      _lua_pushlstring(i4, 1800, 10) | 0;
      break;
     } else if (i17 << 24 >> 24 == 67) {
      if ((_pushglobalfuncname(i4, i5) | 0) == 0) {
       _lua_pushlstring(i4, 1112, 1) | 0;
       break;
      } else {
       HEAP32[i6 >> 2] = _lua_tolstring(i4, -1, 0) | 0;
       _lua_pushfstring(i4, 1784, i6) | 0;
       _lua_remove(i4, -2);
       break;
      }
     } else {
      i17 = HEAP32[i15 >> 2] | 0;
      HEAP32[i6 >> 2] = i13;
      HEAP32[i6 + 4 >> 2] = i17;
      _lua_pushfstring(i4, 1816, i6) | 0;
      break;
     }
    } else {
     HEAP32[i6 >> 2] = HEAP32[i11 >> 2];
     _lua_pushfstring(i4, 1784, i6) | 0;
    }
   } while (0);
   if ((HEAP8[i14] | 0) != 0) {
    _lua_pushlstring(i4, 1016, 20) | 0;
   }
   _lua_concat(i4, (_lua_gettop(i4) | 0) - i2 | 0);
  }
 } while ((_lua_getstack(i1, i7, i5) | 0) != 0);
 i17 = _lua_gettop(i4) | 0;
 i17 = i17 - i2 | 0;
 _lua_concat(i4, i17);
 STACKTOP = i3;
 return;
}
function _luaK_exp2RK(i3, i1) {
 i3 = i3 | 0;
 i1 = i1 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, d11 = 0.0, i12 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i7 = i2 + 16 | 0;
 i6 = i2;
 i4 = i1 + 16 | 0;
 i5 = i1 + 20 | 0;
 i10 = (HEAP32[i4 >> 2] | 0) == (HEAP32[i5 >> 2] | 0);
 _luaK_dischargevars(i3, i1);
 do {
  if (!i10) {
   if ((HEAP32[i1 >> 2] | 0) == 6) {
    i10 = HEAP32[i1 + 8 >> 2] | 0;
    if ((HEAP32[i4 >> 2] | 0) == (HEAP32[i5 >> 2] | 0)) {
     break;
    }
    if ((i10 | 0) >= (HEAPU8[i3 + 46 | 0] | 0 | 0)) {
     _exp2reg(i3, i1, i10);
     break;
    }
   }
   _luaK_exp2nextreg(i3, i1);
  }
 } while (0);
 i10 = HEAP32[i1 >> 2] | 0;
 switch (i10 | 0) {
 case 4:
  {
   i8 = HEAP32[i1 + 8 >> 2] | 0;
   i9 = 18;
   break;
  }
 case 1:
 case 3:
 case 2:
  {
   if ((HEAP32[i3 + 32 >> 2] | 0) < 256) {
    if ((i10 | 0) == 1) {
     HEAP32[i6 + 8 >> 2] = 0;
     HEAP32[i7 >> 2] = HEAP32[i3 + 4 >> 2];
     HEAP32[i7 + 8 >> 2] = 69;
     i3 = _addk(i3, i7, i6) | 0;
    } else {
     HEAP32[i7 >> 2] = (i10 | 0) == 2;
     HEAP32[i7 + 8 >> 2] = 1;
     i3 = _addk(i3, i7, i7) | 0;
    }
    HEAP32[i1 + 8 >> 2] = i3;
    HEAP32[i1 >> 2] = 4;
    i10 = i3 | 256;
    STACKTOP = i2;
    return i10 | 0;
   }
   break;
  }
 case 5:
  {
   i9 = i1 + 8 | 0;
   d11 = +HEAPF64[i9 >> 3];
   HEAPF64[i7 >> 3] = d11;
   i8 = HEAP32[(HEAP32[i3 + 12 >> 2] | 0) + 52 >> 2] | 0;
   HEAPF64[i6 >> 3] = d11;
   HEAP32[i6 + 8 >> 2] = 3;
   if (d11 != d11 | 0.0 != 0.0 | d11 == 0.0) {
    i10 = i8 + 8 | 0;
    i12 = HEAP32[i10 >> 2] | 0;
    HEAP32[i10 >> 2] = i12 + 16;
    i8 = _luaS_newlstr(i8, i7, 8) | 0;
    HEAP32[i12 >> 2] = i8;
    HEAP32[i12 + 8 >> 2] = HEAPU8[i8 + 4 | 0] | 0 | 64;
    i8 = _addk(i3, (HEAP32[i10 >> 2] | 0) + -16 | 0, i6) | 0;
    HEAP32[i10 >> 2] = (HEAP32[i10 >> 2] | 0) + -16;
   } else {
    i8 = _addk(i3, i6, i6) | 0;
   }
   HEAP32[i9 >> 2] = i8;
   HEAP32[i1 >> 2] = 4;
   i9 = 18;
   break;
  }
 default:
  {}
 }
 if ((i9 | 0) == 18 ? (i8 | 0) < 256 : 0) {
  i12 = i8 | 256;
  STACKTOP = i2;
  return i12 | 0;
 }
 _luaK_dischargevars(i3, i1);
 if ((HEAP32[i1 >> 2] | 0) == 6) {
  i7 = i1 + 8 | 0;
  i6 = HEAP32[i7 >> 2] | 0;
  if ((HEAP32[i4 >> 2] | 0) == (HEAP32[i5 >> 2] | 0)) {
   i12 = i6;
   STACKTOP = i2;
   return i12 | 0;
  }
  if ((i6 | 0) >= (HEAPU8[i3 + 46 | 0] | 0 | 0)) {
   _exp2reg(i3, i1, i6);
   i12 = HEAP32[i7 >> 2] | 0;
   STACKTOP = i2;
   return i12 | 0;
  }
 } else {
  i7 = i1 + 8 | 0;
 }
 _luaK_exp2nextreg(i3, i1);
 i12 = HEAP32[i7 >> 2] | 0;
 STACKTOP = i2;
 return i12 | 0;
}
function _os_date(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 1264 | 0;
 i4 = i2;
 i7 = i2 + 1048 | 0;
 i6 = i2 + 1256 | 0;
 i3 = i2 + 8 | 0;
 i5 = i2 + 1056 | 0;
 i12 = _luaL_optlstring(i1, 1, 6064, 0) | 0;
 if ((_lua_type(i1, 2) | 0) < 1) {
  i8 = _time(0) | 0;
 } else {
  i8 = ~~+_luaL_checknumber(i1, 2);
 }
 HEAP32[i7 >> 2] = i8;
 if ((HEAP8[i12] | 0) == 33) {
  i12 = i12 + 1 | 0;
  i10 = _gmtime(i7 | 0) | 0;
 } else {
  i10 = _localtime(i7 | 0) | 0;
 }
 if ((i10 | 0) == 0) {
  _lua_pushnil(i1);
  STACKTOP = i2;
  return 1;
 }
 if ((_strcmp(i12, 6072) | 0) == 0) {
  _lua_createtable(i1, 0, 9);
  _lua_pushinteger(i1, HEAP32[i10 >> 2] | 0);
  _lua_setfield(i1, -2, 5864);
  _lua_pushinteger(i1, HEAP32[i10 + 4 >> 2] | 0);
  _lua_setfield(i1, -2, 5872);
  _lua_pushinteger(i1, HEAP32[i10 + 8 >> 2] | 0);
  _lua_setfield(i1, -2, 5880);
  _lua_pushinteger(i1, HEAP32[i10 + 12 >> 2] | 0);
  _lua_setfield(i1, -2, 5888);
  _lua_pushinteger(i1, (HEAP32[i10 + 16 >> 2] | 0) + 1 | 0);
  _lua_setfield(i1, -2, 5896);
  _lua_pushinteger(i1, (HEAP32[i10 + 20 >> 2] | 0) + 1900 | 0);
  _lua_setfield(i1, -2, 5904);
  _lua_pushinteger(i1, (HEAP32[i10 + 24 >> 2] | 0) + 1 | 0);
  _lua_setfield(i1, -2, 6080);
  _lua_pushinteger(i1, (HEAP32[i10 + 28 >> 2] | 0) + 1 | 0);
  _lua_setfield(i1, -2, 6088);
  i3 = HEAP32[i10 + 32 >> 2] | 0;
  if ((i3 | 0) < 0) {
   STACKTOP = i2;
   return 1;
  }
  _lua_pushboolean(i1, i3);
  _lua_setfield(i1, -2, 5912);
  STACKTOP = i2;
  return 1;
 }
 HEAP8[i6] = 37;
 _luaL_buffinit(i1, i3);
 i11 = i3 + 8 | 0;
 i9 = i3 + 4 | 0;
 i8 = i6 + 1 | 0;
 i7 = i6 + 2 | 0;
 while (1) {
  i14 = HEAP8[i12] | 0;
  if (i14 << 24 >> 24 == 0) {
   break;
  } else if (!(i14 << 24 >> 24 == 37)) {
   i13 = HEAP32[i11 >> 2] | 0;
   if (!(i13 >>> 0 < (HEAP32[i9 >> 2] | 0) >>> 0)) {
    _luaL_prepbuffsize(i3, 1) | 0;
    i13 = HEAP32[i11 >> 2] | 0;
    i14 = HEAP8[i12] | 0;
   }
   HEAP32[i11 >> 2] = i13 + 1;
   HEAP8[(HEAP32[i3 >> 2] | 0) + i13 | 0] = i14;
   i12 = i12 + 1 | 0;
   continue;
  }
  i13 = i12 + 1 | 0;
  i12 = i12 + 2 | 0;
  i14 = HEAP8[i13] | 0;
  if (!(i14 << 24 >> 24 == 0) ? (_memchr(6096, i14 << 24 >> 24, 23) | 0) != 0 : 0) {
   HEAP8[i8] = i14;
   HEAP8[i7] = 0;
  } else {
   HEAP32[i4 >> 2] = i13;
   _luaL_argerror(i1, 1, _lua_pushfstring(i1, 6120, i4) | 0) | 0;
   i12 = i13;
  }
  _luaL_addlstring(i3, i5, _strftime(i5 | 0, 200, i6 | 0, i10 | 0) | 0);
 }
 _luaL_pushresult(i3);
 STACKTOP = i2;
 return 1;
}
function _luaV_finishOp(i3) {
 i3 = i3 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0;
 i1 = STACKTOP;
 i8 = HEAP32[i3 + 16 >> 2] | 0;
 i7 = i8 + 24 | 0;
 i4 = HEAP32[i7 >> 2] | 0;
 i5 = i8 + 28 | 0;
 i2 = HEAP32[(HEAP32[i5 >> 2] | 0) + -4 >> 2] | 0;
 i6 = i2 & 63;
 switch (i6 | 0) {
 case 34:
  {
   HEAP32[i3 + 8 >> 2] = HEAP32[i8 + 4 >> 2];
   STACKTOP = i1;
   return;
  }
 case 24:
 case 25:
 case 26:
  {
   i7 = i3 + 8 | 0;
   i8 = HEAP32[i7 >> 2] | 0;
   i9 = HEAP32[i8 + -8 >> 2] | 0;
   if ((i9 | 0) != 0) {
    if ((i9 | 0) == 1) {
     i9 = (HEAP32[i8 + -16 >> 2] | 0) == 0;
    } else {
     i9 = 0;
    }
   } else {
    i9 = 1;
   }
   i9 = i9 & 1;
   i10 = i9 ^ 1;
   HEAP32[i7 >> 2] = i8 + -16;
   if ((i6 | 0) == 26) {
    i8 = (HEAP32[(_luaT_gettmbyobj(i3, i4 + (i2 >>> 23 << 4) | 0, 14) | 0) + 8 >> 2] | 0) == 0;
    i10 = i8 ? i9 : i10;
   }
   if ((i10 | 0) == (i2 >>> 6 & 255 | 0)) {
    STACKTOP = i1;
    return;
   }
   HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + 4;
   STACKTOP = i1;
   return;
  }
 case 22:
  {
   i5 = i3 + 8 | 0;
   i10 = HEAP32[i5 >> 2] | 0;
   i6 = i10 + -32 | 0;
   i4 = i6 - (i4 + (i2 >>> 23 << 4)) | 0;
   i12 = i10 + -16 | 0;
   i11 = HEAP32[i12 + 4 >> 2] | 0;
   i9 = i10 + -48 | 0;
   HEAP32[i9 >> 2] = HEAP32[i12 >> 2];
   HEAP32[i9 + 4 >> 2] = i11;
   HEAP32[i10 + -40 >> 2] = HEAP32[i10 + -8 >> 2];
   if ((i4 | 0) > 16) {
    HEAP32[i5 >> 2] = i6;
    _luaV_concat(i3, i4 >> 4);
   }
   i10 = HEAP32[i5 >> 2] | 0;
   i11 = HEAP32[i7 >> 2] | 0;
   i12 = i2 >>> 6 & 255;
   i6 = i10 + -16 | 0;
   i7 = HEAP32[i6 + 4 >> 2] | 0;
   i9 = i11 + (i12 << 4) | 0;
   HEAP32[i9 >> 2] = HEAP32[i6 >> 2];
   HEAP32[i9 + 4 >> 2] = i7;
   HEAP32[i11 + (i12 << 4) + 8 >> 2] = HEAP32[i10 + -8 >> 2];
   HEAP32[i5 >> 2] = HEAP32[i8 + 4 >> 2];
   STACKTOP = i1;
   return;
  }
 case 12:
 case 7:
 case 6:
 case 21:
 case 19:
 case 18:
 case 17:
 case 16:
 case 15:
 case 14:
 case 13:
  {
   i12 = i3 + 8 | 0;
   i11 = HEAP32[i12 >> 2] | 0;
   i8 = i11 + -16 | 0;
   HEAP32[i12 >> 2] = i8;
   i12 = i2 >>> 6 & 255;
   i9 = HEAP32[i8 + 4 >> 2] | 0;
   i10 = i4 + (i12 << 4) | 0;
   HEAP32[i10 >> 2] = HEAP32[i8 >> 2];
   HEAP32[i10 + 4 >> 2] = i9;
   HEAP32[i4 + (i12 << 4) + 8 >> 2] = HEAP32[i11 + -8 >> 2];
   STACKTOP = i1;
   return;
  }
 case 29:
  {
   if ((i2 & 8372224 | 0) == 0) {
    STACKTOP = i1;
    return;
   }
   HEAP32[i3 + 8 >> 2] = HEAP32[i8 + 4 >> 2];
   STACKTOP = i1;
   return;
  }
 default:
  {
   STACKTOP = i1;
   return;
  }
 }
}
function _auxsort(i2, i4, i5) {
 i2 = i2 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i1 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i1;
 if ((i4 | 0) >= (i5 | 0)) {
  STACKTOP = i1;
  return;
 }
 while (1) {
  _lua_rawgeti(i2, 1, i4);
  _lua_rawgeti(i2, 1, i5);
  if ((_sort_comp(i2, -1, -2) | 0) == 0) {
   _lua_settop(i2, -3);
  } else {
   _lua_rawseti(i2, 1, i4);
   _lua_rawseti(i2, 1, i5);
  }
  i6 = i5 - i4 | 0;
  if ((i6 | 0) == 1) {
   i2 = 24;
   break;
  }
  i7 = (i5 + i4 | 0) / 2 | 0;
  _lua_rawgeti(i2, 1, i7);
  _lua_rawgeti(i2, 1, i4);
  do {
   if ((_sort_comp(i2, -2, -1) | 0) == 0) {
    _lua_settop(i2, -2);
    _lua_rawgeti(i2, 1, i5);
    if ((_sort_comp(i2, -1, -2) | 0) == 0) {
     _lua_settop(i2, -3);
     break;
    } else {
     _lua_rawseti(i2, 1, i7);
     _lua_rawseti(i2, 1, i5);
     break;
    }
   } else {
    _lua_rawseti(i2, 1, i7);
    _lua_rawseti(i2, 1, i4);
   }
  } while (0);
  if ((i6 | 0) == 2) {
   i2 = 24;
   break;
  }
  _lua_rawgeti(i2, 1, i7);
  _lua_pushvalue(i2, -1);
  i6 = i5 + -1 | 0;
  _lua_rawgeti(i2, 1, i6);
  _lua_rawseti(i2, 1, i7);
  _lua_rawseti(i2, 1, i6);
  i7 = i4;
  i9 = i6;
  while (1) {
   i8 = i7 + 1 | 0;
   _lua_rawgeti(i2, 1, i8);
   if ((_sort_comp(i2, -1, -2) | 0) != 0) {
    i7 = i8;
    while (1) {
     if ((i7 | 0) >= (i5 | 0)) {
      _luaL_error(i2, 8216, i3) | 0;
     }
     _lua_settop(i2, -2);
     i8 = i7 + 1 | 0;
     _lua_rawgeti(i2, 1, i8);
     if ((_sort_comp(i2, -1, -2) | 0) == 0) {
      break;
     } else {
      i7 = i8;
     }
    }
   }
   i10 = i9 + -1 | 0;
   _lua_rawgeti(i2, 1, i10);
   if ((_sort_comp(i2, -3, -1) | 0) != 0) {
    i9 = i10;
    while (1) {
     if ((i9 | 0) <= (i4 | 0)) {
      _luaL_error(i2, 8216, i3) | 0;
     }
     _lua_settop(i2, -2);
     i10 = i9 + -1 | 0;
     _lua_rawgeti(i2, 1, i10);
     if ((_sort_comp(i2, -3, -1) | 0) == 0) {
      break;
     } else {
      i9 = i10;
     }
    }
   }
   if ((i9 | 0) <= (i8 | 0)) {
    break;
   }
   _lua_rawseti(i2, 1, i8);
   _lua_rawseti(i2, 1, i10);
   i7 = i8;
   i9 = i10;
  }
  _lua_settop(i2, -4);
  _lua_rawgeti(i2, 1, i6);
  _lua_rawgeti(i2, 1, i8);
  _lua_rawseti(i2, 1, i6);
  _lua_rawseti(i2, 1, i8);
  i8 = (i8 - i4 | 0) < (i5 - i8 | 0);
  i9 = i7 + 2 | 0;
  i10 = i8 ? i9 : i4;
  i6 = i8 ? i5 : i7;
  _auxsort(i2, i8 ? i4 : i9, i8 ? i7 : i5);
  if ((i10 | 0) < (i6 | 0)) {
   i4 = i10;
   i5 = i6;
  } else {
   i2 = 24;
   break;
  }
 }
 if ((i2 | 0) == 24) {
  STACKTOP = i1;
  return;
 }
}
function _skip_sep(i3) {
 i3 = i3 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i1 = STACKTOP;
 i2 = HEAP32[i3 >> 2] | 0;
 i4 = i3 + 60 | 0;
 i10 = HEAP32[i4 >> 2] | 0;
 i8 = i10 + 4 | 0;
 i11 = HEAP32[i8 >> 2] | 0;
 i7 = i10 + 8 | 0;
 i5 = HEAP32[i7 >> 2] | 0;
 do {
  if ((i11 + 1 | 0) >>> 0 > i5 >>> 0) {
   if (i5 >>> 0 > 2147483645) {
    _lexerror(i3, 12368, 0);
   }
   i12 = i5 << 1;
   i11 = HEAP32[i3 + 52 >> 2] | 0;
   if ((i12 | 0) == -2) {
    _luaM_toobig(i11);
   } else {
    i9 = _luaM_realloc_(i11, HEAP32[i10 >> 2] | 0, i5, i12) | 0;
    HEAP32[i10 >> 2] = i9;
    HEAP32[i7 >> 2] = i12;
    i6 = HEAP32[i8 >> 2] | 0;
    break;
   }
  } else {
   i6 = i11;
   i9 = HEAP32[i10 >> 2] | 0;
  }
 } while (0);
 HEAP32[i8 >> 2] = i6 + 1;
 HEAP8[i9 + i6 | 0] = i2;
 i5 = i3 + 56 | 0;
 i6 = HEAP32[i5 >> 2] | 0;
 i13 = HEAP32[i6 >> 2] | 0;
 HEAP32[i6 >> 2] = i13 + -1;
 if ((i13 | 0) == 0) {
  i6 = _luaZ_fill(i6) | 0;
 } else {
  i13 = i6 + 4 | 0;
  i6 = HEAP32[i13 >> 2] | 0;
  HEAP32[i13 >> 2] = i6 + 1;
  i6 = HEAPU8[i6] | 0;
 }
 HEAP32[i3 >> 2] = i6;
 if ((i6 | 0) != 61) {
  i12 = i6;
  i13 = 0;
  i12 = (i12 | 0) != (i2 | 0);
  i12 = i12 << 31 >> 31;
  i13 = i12 ^ i13;
  STACKTOP = i1;
  return i13 | 0;
 }
 i6 = i3 + 52 | 0;
 i7 = 0;
 while (1) {
  i9 = HEAP32[i4 >> 2] | 0;
  i8 = i9 + 4 | 0;
  i10 = HEAP32[i8 >> 2] | 0;
  i11 = i9 + 8 | 0;
  i12 = HEAP32[i11 >> 2] | 0;
  if ((i10 + 1 | 0) >>> 0 > i12 >>> 0) {
   if (i12 >>> 0 > 2147483645) {
    i4 = 16;
    break;
   }
   i13 = i12 << 1;
   i10 = HEAP32[i6 >> 2] | 0;
   if ((i13 | 0) == -2) {
    i4 = 18;
    break;
   }
   i12 = _luaM_realloc_(i10, HEAP32[i9 >> 2] | 0, i12, i13) | 0;
   HEAP32[i9 >> 2] = i12;
   HEAP32[i11 >> 2] = i13;
   i10 = HEAP32[i8 >> 2] | 0;
   i9 = i12;
  } else {
   i9 = HEAP32[i9 >> 2] | 0;
  }
  HEAP32[i8 >> 2] = i10 + 1;
  HEAP8[i9 + i10 | 0] = 61;
  i8 = HEAP32[i5 >> 2] | 0;
  i13 = HEAP32[i8 >> 2] | 0;
  HEAP32[i8 >> 2] = i13 + -1;
  if ((i13 | 0) == 0) {
   i8 = _luaZ_fill(i8) | 0;
  } else {
   i13 = i8 + 4 | 0;
   i8 = HEAP32[i13 >> 2] | 0;
   HEAP32[i13 >> 2] = i8 + 1;
   i8 = HEAPU8[i8] | 0;
  }
  HEAP32[i3 >> 2] = i8;
  i7 = i7 + 1 | 0;
  if ((i8 | 0) != 61) {
   i4 = 24;
   break;
  }
 }
 if ((i4 | 0) == 16) {
  _lexerror(i3, 12368, 0);
 } else if ((i4 | 0) == 18) {
  _luaM_toobig(i10);
 } else if ((i4 | 0) == 24) {
  i13 = (i8 | 0) != (i2 | 0);
  i13 = i13 << 31 >> 31;
  i13 = i13 ^ i7;
  STACKTOP = i1;
  return i13 | 0;
 }
 return 0;
}
function _luaV_arith(i8, i2, i3, i5, i4) {
 i8 = i8 | 0;
 i2 = i2 | 0;
 i3 = i3 | 0;
 i5 = i5 | 0;
 i4 = i4 | 0;
 var i1 = 0, i6 = 0, i7 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, d14 = 0.0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i9 = i1 + 24 | 0;
 i13 = i1 + 16 | 0;
 i12 = i1;
 i6 = i3 + 8 | 0;
 i11 = HEAP32[i6 >> 2] | 0;
 if ((i11 | 0) != 3) {
  if ((i11 & 15 | 0) == 4 ? (i11 = HEAP32[i3 >> 2] | 0, (_luaO_str2d(i11 + 16 | 0, HEAP32[i11 + 12 >> 2] | 0, i13) | 0) != 0) : 0) {
   HEAPF64[i12 >> 3] = +HEAPF64[i13 >> 3];
   HEAP32[i12 + 8 >> 2] = 3;
   i10 = 5;
  }
 } else {
  i12 = i3;
  i10 = 5;
 }
 do {
  if ((i10 | 0) == 5) {
   i10 = HEAP32[i5 + 8 >> 2] | 0;
   if ((i10 | 0) == 3) {
    if ((i5 | 0) == 0) {
     break;
    }
    d14 = +HEAPF64[i5 >> 3];
   } else {
    if ((i10 & 15 | 0) != 4) {
     break;
    }
    i13 = HEAP32[i5 >> 2] | 0;
    if ((_luaO_str2d(i13 + 16 | 0, HEAP32[i13 + 12 >> 2] | 0, i9) | 0) == 0) {
     break;
    }
    d14 = +HEAPF64[i9 >> 3];
   }
   HEAPF64[i2 >> 3] = +_luaO_arith(i4 + -6 | 0, +HEAPF64[i12 >> 3], d14);
   HEAP32[i2 + 8 >> 2] = 3;
   STACKTOP = i1;
   return;
  }
 } while (0);
 i9 = _luaT_gettmbyobj(i8, i3, i4) | 0;
 if ((HEAP32[i9 + 8 >> 2] | 0) == 0) {
  i4 = _luaT_gettmbyobj(i8, i5, i4) | 0;
  if ((HEAP32[i4 + 8 >> 2] | 0) == 0) {
   _luaG_aritherror(i8, i3, i5);
  } else {
   i7 = i4;
  }
 } else {
  i7 = i9;
 }
 i12 = i8 + 28 | 0;
 i13 = i2 - (HEAP32[i12 >> 2] | 0) | 0;
 i9 = i8 + 8 | 0;
 i11 = HEAP32[i9 >> 2] | 0;
 HEAP32[i9 >> 2] = i11 + 16;
 i2 = i7;
 i10 = HEAP32[i2 + 4 >> 2] | 0;
 i4 = i11;
 HEAP32[i4 >> 2] = HEAP32[i2 >> 2];
 HEAP32[i4 + 4 >> 2] = i10;
 HEAP32[i11 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
 i11 = HEAP32[i9 >> 2] | 0;
 HEAP32[i9 >> 2] = i11 + 16;
 i4 = i3;
 i10 = HEAP32[i4 + 4 >> 2] | 0;
 i7 = i11;
 HEAP32[i7 >> 2] = HEAP32[i4 >> 2];
 HEAP32[i7 + 4 >> 2] = i10;
 HEAP32[i11 + 8 >> 2] = HEAP32[i6 >> 2];
 i11 = HEAP32[i9 >> 2] | 0;
 HEAP32[i9 >> 2] = i11 + 16;
 i6 = i5;
 i7 = HEAP32[i6 + 4 >> 2] | 0;
 i10 = i11;
 HEAP32[i10 >> 2] = HEAP32[i6 >> 2];
 HEAP32[i10 + 4 >> 2] = i7;
 HEAP32[i11 + 8 >> 2] = HEAP32[i5 + 8 >> 2];
 _luaD_call(i8, (HEAP32[i9 >> 2] | 0) + -48 | 0, 1, HEAP8[(HEAP32[i8 + 16 >> 2] | 0) + 18 | 0] & 1);
 i12 = HEAP32[i12 >> 2] | 0;
 i11 = HEAP32[i9 >> 2] | 0;
 i8 = i11 + -16 | 0;
 HEAP32[i9 >> 2] = i8;
 i9 = HEAP32[i8 + 4 >> 2] | 0;
 i10 = i12 + i13 | 0;
 HEAP32[i10 >> 2] = HEAP32[i8 >> 2];
 HEAP32[i10 + 4 >> 2] = i9;
 HEAP32[i12 + (i13 + 8) >> 2] = HEAP32[i11 + -8 >> 2];
 STACKTOP = i1;
 return;
}
function _new_localvar(i1, i8) {
 i1 = i1 | 0;
 i8 = i8 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = i3;
 i5 = HEAP32[i1 + 48 >> 2] | 0;
 i2 = HEAP32[i1 + 64 >> 2] | 0;
 i7 = HEAP32[i5 >> 2] | 0;
 i10 = i7 + 60 | 0;
 i11 = HEAP32[i10 >> 2] | 0;
 i6 = i5 + 44 | 0;
 if ((HEAP16[i6 >> 1] | 0) < (i11 | 0)) {
  i9 = i7 + 24 | 0;
  i10 = i11;
 } else {
  i9 = i7 + 24 | 0;
  HEAP32[i9 >> 2] = _luaM_growaux_(HEAP32[i1 + 52 >> 2] | 0, HEAP32[i9 >> 2] | 0, i10, 12, 32767, 6496) | 0;
  i10 = HEAP32[i10 >> 2] | 0;
 }
 if ((i11 | 0) < (i10 | 0)) {
  i12 = i11;
  while (1) {
   i11 = i12 + 1 | 0;
   HEAP32[(HEAP32[i9 >> 2] | 0) + (i12 * 12 | 0) >> 2] = 0;
   if ((i11 | 0) == (i10 | 0)) {
    break;
   } else {
    i12 = i11;
   }
  }
 }
 i10 = HEAP16[i6 >> 1] | 0;
 HEAP32[(HEAP32[i9 >> 2] | 0) + ((i10 << 16 >> 16) * 12 | 0) >> 2] = i8;
 if (!((HEAP8[i8 + 5 | 0] & 3) == 0) ? !((HEAP8[i7 + 5 | 0] & 4) == 0) : 0) {
  _luaC_barrier_(HEAP32[i1 + 52 >> 2] | 0, i7, i8);
  i7 = HEAP16[i6 >> 1] | 0;
 } else {
  i7 = i10;
 }
 HEAP16[i6 >> 1] = i7 + 1 << 16 >> 16;
 i6 = i2 + 4 | 0;
 i8 = HEAP32[i6 >> 2] | 0;
 if ((i8 + 1 - (HEAP32[i5 + 40 >> 2] | 0) | 0) > 200) {
  i10 = i5 + 12 | 0;
  i9 = HEAP32[(HEAP32[i10 >> 2] | 0) + 52 >> 2] | 0;
  i5 = HEAP32[(HEAP32[i5 >> 2] | 0) + 64 >> 2] | 0;
  if ((i5 | 0) == 0) {
   i11 = 6552;
   HEAP32[i4 >> 2] = 6496;
   i12 = i4 + 4 | 0;
   HEAP32[i12 >> 2] = 200;
   i12 = i4 + 8 | 0;
   HEAP32[i12 >> 2] = i11;
   i12 = _luaO_pushfstring(i9, 6592, i4) | 0;
   i11 = HEAP32[i10 >> 2] | 0;
   _luaX_syntaxerror(i11, i12);
  }
  HEAP32[i4 >> 2] = i5;
  i11 = _luaO_pushfstring(i9, 6568, i4) | 0;
  HEAP32[i4 >> 2] = 6496;
  i12 = i4 + 4 | 0;
  HEAP32[i12 >> 2] = 200;
  i12 = i4 + 8 | 0;
  HEAP32[i12 >> 2] = i11;
  i12 = _luaO_pushfstring(i9, 6592, i4) | 0;
  i11 = HEAP32[i10 >> 2] | 0;
  _luaX_syntaxerror(i11, i12);
 }
 i4 = i2 + 8 | 0;
 if ((i8 + 2 | 0) > (HEAP32[i4 >> 2] | 0)) {
  i11 = _luaM_growaux_(HEAP32[i1 + 52 >> 2] | 0, HEAP32[i2 >> 2] | 0, i4, 2, 2147483645, 6496) | 0;
  HEAP32[i2 >> 2] = i11;
  i12 = HEAP32[i6 >> 2] | 0;
  i10 = i12 + 1 | 0;
  HEAP32[i6 >> 2] = i10;
  i12 = i11 + (i12 << 1) | 0;
  HEAP16[i12 >> 1] = i7;
  STACKTOP = i3;
  return;
 } else {
  i12 = i8;
  i11 = HEAP32[i2 >> 2] | 0;
  i10 = i12 + 1 | 0;
  HEAP32[i6 >> 2] = i10;
  i12 = i11 + (i12 << 1) | 0;
  HEAP16[i12 >> 1] = i7;
  STACKTOP = i3;
  return;
 }
}
function _luaC_fullgc(i1, i5) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0;
 i2 = STACKTOP;
 i4 = i1 + 12 | 0;
 i3 = HEAP32[i4 >> 2] | 0;
 i6 = i3 + 62 | 0;
 i8 = HEAP8[i6] | 0;
 i5 = (i5 | 0) != 0;
 if (!i5) {
  HEAP8[i6] = 0;
  i9 = (HEAP32[i4 >> 2] | 0) + 104 | 0;
  i10 = HEAP32[i9 >> 2] | 0;
  if ((i10 | 0) != 0) {
   do {
    i11 = i10 + 5 | 0;
    HEAP8[i11] = HEAP8[i11] & 191;
    _GCTM(i1, 1);
    i10 = HEAP32[i9 >> 2] | 0;
   } while ((i10 | 0) != 0);
   if ((HEAP8[i6] | 0) == 2) {
    i9 = 7;
   } else {
    i9 = 6;
   }
  } else {
   i9 = 6;
  }
 } else {
  HEAP8[i6] = 1;
  i9 = 6;
 }
 if ((i9 | 0) == 6 ? (HEAPU8[i3 + 61 | 0] | 0) < 2 : 0) {
  i9 = 7;
 }
 if ((i9 | 0) == 7) {
  i9 = HEAP32[i4 >> 2] | 0;
  HEAP8[i9 + 61 | 0] = 2;
  HEAP32[i9 + 64 >> 2] = 0;
  i10 = i9 + 72 | 0;
  do {
   i11 = _sweeplist(i1, i10, 1) | 0;
  } while ((i11 | 0) == (i10 | 0));
  HEAP32[i9 + 80 >> 2] = i11;
  i11 = i9 + 68 | 0;
  do {
   i10 = _sweeplist(i1, i11, 1) | 0;
  } while ((i10 | 0) == (i11 | 0));
  HEAP32[i9 + 76 >> 2] = i10;
 }
 i11 = HEAP32[i4 >> 2] | 0;
 i9 = i11 + 61 | 0;
 if ((HEAP8[i9] | 0) == 5) {
  i9 = 5;
 } else {
  do {
   _singlestep(i1) | 0;
  } while ((HEAP8[i9] | 0) != 5);
  i9 = HEAP32[i4 >> 2] | 0;
  i11 = i9;
  i9 = HEAP8[i9 + 61 | 0] | 0;
 }
 i10 = i11 + 61 | 0;
 if ((1 << (i9 & 255) & -33 | 0) == 0) {
  do {
   _singlestep(i1) | 0;
  } while ((1 << HEAPU8[i10] & -33 | 0) == 0);
  i9 = HEAP32[i4 >> 2] | 0;
  i11 = i9;
  i9 = HEAP8[i9 + 61 | 0] | 0;
 }
 i10 = i11 + 61 | 0;
 if (!(i9 << 24 >> 24 == 5)) {
  do {
   _singlestep(i1) | 0;
  } while ((HEAP8[i10] | 0) != 5);
 }
 if (i8 << 24 >> 24 == 2 ? (i7 = (HEAP32[i4 >> 2] | 0) + 61 | 0, (HEAP8[i7] | 0) != 0) : 0) {
  do {
   _singlestep(i1) | 0;
  } while ((HEAP8[i7] | 0) != 0);
 }
 HEAP8[i6] = i8;
 i6 = HEAP32[i3 + 8 >> 2] | 0;
 i7 = HEAP32[i3 + 12 >> 2] | 0;
 i8 = (i7 + i6 | 0) / 100 | 0;
 i9 = HEAP32[i3 + 156 >> 2] | 0;
 if ((i9 | 0) < (2147483644 / (i8 | 0) | 0 | 0)) {
  i8 = Math_imul(i9, i8) | 0;
 } else {
  i8 = 2147483644;
 }
 _luaE_setdebt(i3, i6 - i8 + i7 | 0);
 if (i5) {
  STACKTOP = i2;
  return;
 }
 i3 = (HEAP32[i4 >> 2] | 0) + 104 | 0;
 i4 = HEAP32[i3 >> 2] | 0;
 if ((i4 | 0) == 0) {
  STACKTOP = i2;
  return;
 }
 do {
  i11 = i4 + 5 | 0;
  HEAP8[i11] = HEAP8[i11] & 191;
  _GCTM(i1, 1);
  i4 = HEAP32[i3 >> 2] | 0;
 } while ((i4 | 0) != 0);
 STACKTOP = i2;
 return;
}
function _scanexp(i3, i6) {
 i3 = i3 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0;
 i1 = STACKTOP;
 i2 = i3 + 4 | 0;
 i5 = HEAP32[i2 >> 2] | 0;
 i4 = i3 + 100 | 0;
 if (i5 >>> 0 < (HEAP32[i4 >> 2] | 0) >>> 0) {
  HEAP32[i2 >> 2] = i5 + 1;
  i8 = HEAPU8[i5] | 0;
 } else {
  i8 = ___shgetc(i3) | 0;
 }
 if ((i8 | 0) == 43 | (i8 | 0) == 45) {
  i5 = (i8 | 0) == 45 | 0;
  i7 = HEAP32[i2 >> 2] | 0;
  if (i7 >>> 0 < (HEAP32[i4 >> 2] | 0) >>> 0) {
   HEAP32[i2 >> 2] = i7 + 1;
   i8 = HEAPU8[i7] | 0;
  } else {
   i8 = ___shgetc(i3) | 0;
  }
  if (!((i8 + -48 | 0) >>> 0 < 10 | (i6 | 0) == 0) ? (HEAP32[i4 >> 2] | 0) != 0 : 0) {
   HEAP32[i2 >> 2] = (HEAP32[i2 >> 2] | 0) + -1;
  }
 } else {
  i5 = 0;
 }
 if ((i8 + -48 | 0) >>> 0 > 9) {
  if ((HEAP32[i4 >> 2] | 0) == 0) {
   i7 = -2147483648;
   i8 = 0;
   tempRet0 = i7;
   STACKTOP = i1;
   return i8 | 0;
  }
  HEAP32[i2 >> 2] = (HEAP32[i2 >> 2] | 0) + -1;
  i7 = -2147483648;
  i8 = 0;
  tempRet0 = i7;
  STACKTOP = i1;
  return i8 | 0;
 } else {
  i6 = 0;
 }
 while (1) {
  i6 = i8 + -48 + i6 | 0;
  i7 = HEAP32[i2 >> 2] | 0;
  if (i7 >>> 0 < (HEAP32[i4 >> 2] | 0) >>> 0) {
   HEAP32[i2 >> 2] = i7 + 1;
   i8 = HEAPU8[i7] | 0;
  } else {
   i8 = ___shgetc(i3) | 0;
  }
  if (!((i8 + -48 | 0) >>> 0 < 10 & (i6 | 0) < 214748364)) {
   break;
  }
  i6 = i6 * 10 | 0;
 }
 i7 = ((i6 | 0) < 0) << 31 >> 31;
 if ((i8 + -48 | 0) >>> 0 < 10) {
  do {
   i7 = ___muldi3(i6 | 0, i7 | 0, 10, 0) | 0;
   i6 = tempRet0;
   i8 = _i64Add(i8 | 0, ((i8 | 0) < 0) << 31 >> 31 | 0, -48, -1) | 0;
   i6 = _i64Add(i8 | 0, tempRet0 | 0, i7 | 0, i6 | 0) | 0;
   i7 = tempRet0;
   i8 = HEAP32[i2 >> 2] | 0;
   if (i8 >>> 0 < (HEAP32[i4 >> 2] | 0) >>> 0) {
    HEAP32[i2 >> 2] = i8 + 1;
    i8 = HEAPU8[i8] | 0;
   } else {
    i8 = ___shgetc(i3) | 0;
   }
  } while ((i8 + -48 | 0) >>> 0 < 10 & ((i7 | 0) < 21474836 | (i7 | 0) == 21474836 & i6 >>> 0 < 2061584302));
 }
 if ((i8 + -48 | 0) >>> 0 < 10) {
  do {
   i8 = HEAP32[i2 >> 2] | 0;
   if (i8 >>> 0 < (HEAP32[i4 >> 2] | 0) >>> 0) {
    HEAP32[i2 >> 2] = i8 + 1;
    i8 = HEAPU8[i8] | 0;
   } else {
    i8 = ___shgetc(i3) | 0;
   }
  } while ((i8 + -48 | 0) >>> 0 < 10);
 }
 if ((HEAP32[i4 >> 2] | 0) != 0) {
  HEAP32[i2 >> 2] = (HEAP32[i2 >> 2] | 0) + -1;
 }
 i3 = (i5 | 0) != 0;
 i2 = _i64Subtract(0, 0, i6 | 0, i7 | 0) | 0;
 i4 = i3 ? tempRet0 : i7;
 i8 = i3 ? i2 : i6;
 tempRet0 = i4;
 STACKTOP = i1;
 return i8 | 0;
}
function _sweeplist(i3, i8, i9) {
 i3 = i3 | 0;
 i8 = i8 | 0;
 i9 = i9 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i10 = 0, i11 = 0, i12 = 0;
 i1 = STACKTOP;
 i5 = i3 + 12 | 0;
 i7 = HEAP32[i5 >> 2] | 0;
 i6 = HEAPU8[i7 + 60 | 0] | 0;
 i2 = i6 ^ 3;
 i7 = (HEAP8[i7 + 62 | 0] | 0) == 2;
 i4 = i7 ? 255 : 184;
 i6 = i7 ? 64 : i6 & 3;
 i7 = i7 ? 64 : 0;
 i10 = HEAP32[i8 >> 2] | 0;
 L1 : do {
  if ((i10 | 0) == 0) {
   i10 = 0;
  } else {
   i11 = i9;
   L2 : while (1) {
    i9 = i11 + -1 | 0;
    if ((i11 | 0) == 0) {
     break L1;
    }
    i11 = i10 + 5 | 0;
    i12 = HEAPU8[i11] | 0;
    L5 : do {
     if (((i12 ^ 3) & i2 | 0) == 0) {
      HEAP32[i8 >> 2] = HEAP32[i10 >> 2];
      switch (HEAPU8[i10 + 4 | 0] | 0) {
      case 4:
       {
        i12 = (HEAP32[i5 >> 2] | 0) + 28 | 0;
        HEAP32[i12 >> 2] = (HEAP32[i12 >> 2] | 0) + -1;
        break;
       }
      case 38:
       {
        _luaM_realloc_(i3, i10, (HEAPU8[i10 + 6 | 0] << 4) + 16 | 0, 0) | 0;
        break L5;
       }
      case 6:
       {
        _luaM_realloc_(i3, i10, (HEAPU8[i10 + 6 | 0] << 2) + 16 | 0, 0) | 0;
        break L5;
       }
      case 20:
       {
        break;
       }
      case 5:
       {
        _luaH_free(i3, i10);
        break L5;
       }
      case 10:
       {
        _luaF_freeupval(i3, i10);
        break L5;
       }
      case 8:
       {
        _luaE_freethread(i3, i10);
        break L5;
       }
      case 9:
       {
        _luaF_freeproto(i3, i10);
        break L5;
       }
      case 7:
       {
        _luaM_realloc_(i3, i10, (HEAP32[i10 + 16 >> 2] | 0) + 24 | 0, 0) | 0;
        break L5;
       }
      default:
       {
        break L5;
       }
      }
      _luaM_realloc_(i3, i10, (HEAP32[i10 + 12 >> 2] | 0) + 17 | 0, 0) | 0;
     } else {
      if ((i12 & i7 | 0) != 0) {
       i2 = 0;
       break L2;
      }
      if (((HEAP8[i10 + 4 | 0] | 0) == 8 ? (HEAP32[i10 + 28 >> 2] | 0) != 0 : 0) ? (_sweeplist(i3, i10 + 56 | 0, -3) | 0, _luaE_freeCI(i10), (HEAP8[(HEAP32[i5 >> 2] | 0) + 62 | 0] | 0) != 1) : 0) {
       _luaD_shrinkstack(i10);
      }
      HEAP8[i11] = i12 & i4 | i6;
      i8 = i10;
     }
    } while (0);
    i10 = HEAP32[i8 >> 2] | 0;
    if ((i10 | 0) == 0) {
     i10 = 0;
     break L1;
    } else {
     i11 = i9;
    }
   }
   STACKTOP = i1;
   return i2 | 0;
  }
 } while (0);
 i12 = (i10 | 0) == 0 ? 0 : i8;
 STACKTOP = i1;
 return i12 | 0;
}
function _resume(i1, i6) {
 i1 = i1 | 0;
 i6 = i6 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i2 = STACKTOP;
 i3 = i1 + 16 | 0;
 i5 = HEAP32[i3 >> 2] | 0;
 if ((HEAPU16[i1 + 38 >> 1] | 0) > 199) {
  _resume_error(i1, 2240, i6);
 }
 i4 = i1 + 6 | 0;
 i7 = HEAP8[i4] | 0;
 if (i7 << 24 >> 24 == 0) {
  if ((i5 | 0) != (i1 + 72 | 0)) {
   _resume_error(i1, 2448, i6);
  }
  if ((_luaD_precall(i1, i6 + -16 | 0, -1) | 0) != 0) {
   STACKTOP = i2;
   return;
  }
  _luaV_execute(i1);
  STACKTOP = i2;
  return;
 } else if (i7 << 24 >> 24 == 1) {
  HEAP8[i4] = 0;
  i4 = i1 + 28 | 0;
  HEAP32[i5 >> 2] = (HEAP32[i4 >> 2] | 0) + (HEAP32[i5 + 20 >> 2] | 0);
  i8 = i5 + 18 | 0;
  i7 = HEAP8[i8] | 0;
  if ((i7 & 1) == 0) {
   i9 = HEAP32[i5 + 28 >> 2] | 0;
   if ((i9 | 0) != 0) {
    HEAP8[i5 + 37 | 0] = 1;
    HEAP8[i8] = i7 & 255 | 8;
    i6 = FUNCTION_TABLE_ii[i9 & 255](i1) | 0;
    i6 = (HEAP32[i1 + 8 >> 2] | 0) + (0 - i6 << 4) | 0;
   }
   i5 = HEAP32[i3 >> 2] | 0;
   i7 = HEAPU8[i1 + 40 | 0] | 0;
   if ((i7 & 6 | 0) == 0) {
    i7 = i5 + 8 | 0;
   } else {
    if ((i7 & 2 | 0) != 0) {
     i6 = i6 - (HEAP32[i4 >> 2] | 0) | 0;
     _luaD_hook(i1, 1, -1);
     i6 = (HEAP32[i4 >> 2] | 0) + i6 | 0;
    }
    i7 = i5 + 8 | 0;
    HEAP32[i1 + 20 >> 2] = HEAP32[(HEAP32[i7 >> 2] | 0) + 28 >> 2];
   }
   i4 = HEAP32[i5 >> 2] | 0;
   i5 = HEAP16[i5 + 16 >> 1] | 0;
   HEAP32[i3 >> 2] = HEAP32[i7 >> 2];
   i3 = i1 + 8 | 0;
   L27 : do {
    if (!(i5 << 16 >> 16 == 0)) {
     i5 = i5 << 16 >> 16;
     while (1) {
      if (!(i6 >>> 0 < (HEAP32[i3 >> 2] | 0) >>> 0)) {
       break;
      }
      i7 = i4 + 16 | 0;
      i10 = i6;
      i8 = HEAP32[i10 + 4 >> 2] | 0;
      i9 = i4;
      HEAP32[i9 >> 2] = HEAP32[i10 >> 2];
      HEAP32[i9 + 4 >> 2] = i8;
      HEAP32[i4 + 8 >> 2] = HEAP32[i6 + 8 >> 2];
      i5 = i5 + -1 | 0;
      if ((i5 | 0) == 0) {
       i4 = i7;
       break L27;
      }
      i6 = i6 + 16 | 0;
      i4 = i7;
     }
     if ((i5 | 0) > 0) {
      i7 = i5;
      i6 = i4;
      while (1) {
       i7 = i7 + -1 | 0;
       HEAP32[i6 + 8 >> 2] = 0;
       if ((i7 | 0) <= 0) {
        break;
       } else {
        i6 = i6 + 16 | 0;
       }
      }
      i4 = i4 + (i5 << 4) | 0;
     }
    }
   } while (0);
   HEAP32[i3 >> 2] = i4;
  } else {
   _luaV_execute(i1);
  }
  _unroll(i1, 0);
  STACKTOP = i2;
  return;
 } else {
  _resume_error(i1, 2488, i6);
 }
}
function _lua_setupvalue(i1, i5, i3) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i2 = STACKTOP;
 i6 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i5 = (HEAP32[i1 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i5 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i6 = HEAP32[i6 >> 2] | 0;
   if ((HEAP32[i6 + 8 >> 2] | 0) != 22 ? (i4 = HEAP32[i6 >> 2] | 0, (i5 | 0) <= (HEAPU8[i4 + 6 | 0] | 0 | 0)) : 0) {
    i5 = i4 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i5 = 5192;
   }
  } else {
   i4 = (HEAP32[i6 >> 2] | 0) + (i5 << 4) | 0;
   i5 = i4 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 i4 = HEAP32[i5 + 8 >> 2] & 63;
 do {
  if ((i4 | 0) == 6) {
   i5 = HEAP32[i5 >> 2] | 0;
   i4 = HEAP32[i5 + 12 >> 2] | 0;
   if ((i3 | 0) <= 0) {
    i6 = 0;
    STACKTOP = i2;
    return i6 | 0;
   }
   if ((HEAP32[i4 + 40 >> 2] | 0) < (i3 | 0)) {
    i6 = 0;
    STACKTOP = i2;
    return i6 | 0;
   }
   i6 = i3 + -1 | 0;
   i3 = HEAP32[i5 + 16 + (i6 << 2) >> 2] | 0;
   i5 = HEAP32[i3 + 8 >> 2] | 0;
   i4 = HEAP32[(HEAP32[i4 + 28 >> 2] | 0) + (i6 << 3) >> 2] | 0;
   if ((i4 | 0) == 0) {
    i4 = 936;
   } else {
    i4 = i4 + 16 | 0;
   }
  } else if ((i4 | 0) == 38) {
   i6 = HEAP32[i5 >> 2] | 0;
   if ((i3 | 0) <= 0) {
    i6 = 0;
    STACKTOP = i2;
    return i6 | 0;
   }
   if ((HEAPU8[i6 + 6 | 0] | 0 | 0) >= (i3 | 0)) {
    i4 = 936;
    i5 = i6 + (i3 + -1 << 4) + 16 | 0;
    i3 = i6;
    break;
   } else {
    i6 = 0;
    STACKTOP = i2;
    return i6 | 0;
   }
  } else {
   i6 = 0;
   STACKTOP = i2;
   return i6 | 0;
  }
 } while (0);
 i6 = i1 + 8 | 0;
 i7 = HEAP32[i6 >> 2] | 0;
 i10 = i7 + -16 | 0;
 HEAP32[i6 >> 2] = i10;
 i9 = HEAP32[i10 + 4 >> 2] | 0;
 i8 = i5;
 HEAP32[i8 >> 2] = HEAP32[i10 >> 2];
 HEAP32[i8 + 4 >> 2] = i9;
 HEAP32[i5 + 8 >> 2] = HEAP32[i7 + -8 >> 2];
 i5 = HEAP32[i6 >> 2] | 0;
 if ((HEAP32[i5 + 8 >> 2] & 64 | 0) == 0) {
  i10 = i4;
  STACKTOP = i2;
  return i10 | 0;
 }
 i5 = HEAP32[i5 >> 2] | 0;
 if ((HEAP8[i5 + 5 | 0] & 3) == 0) {
  i10 = i4;
  STACKTOP = i2;
  return i10 | 0;
 }
 if ((HEAP8[i3 + 5 | 0] & 4) == 0) {
  i10 = i4;
  STACKTOP = i2;
  return i10 | 0;
 }
 _luaC_barrier_(i1, i3, i5);
 i10 = i4;
 STACKTOP = i2;
 return i10 | 0;
}
function _luaC_forcestep(i2) {
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0;
 i1 = STACKTOP;
 i3 = HEAP32[i2 + 12 >> 2] | 0;
 do {
  if ((HEAP8[i3 + 62 | 0] | 0) == 2) {
   i4 = i3 + 20 | 0;
   i6 = HEAP32[i4 >> 2] | 0;
   do {
    if ((i6 | 0) != 0) {
     i5 = i3 + 61 | 0;
     if ((HEAP8[i5] | 0) != 5) {
      do {
       _singlestep(i2) | 0;
      } while ((HEAP8[i5] | 0) != 5);
     }
     HEAP8[i5] = 0;
     i5 = HEAP32[i3 + 8 >> 2] | 0;
     i7 = HEAP32[i3 + 12 >> 2] | 0;
     if ((i7 + i5 | 0) >>> 0 > (Math_imul(HEAP32[i3 + 160 >> 2] | 0, (i6 >>> 0) / 100 | 0) | 0) >>> 0) {
      HEAP32[i4 >> 2] = 0;
      break;
     } else {
      HEAP32[i4 >> 2] = i6;
      break;
     }
    } else {
     _luaC_fullgc(i2, 0);
     i5 = HEAP32[i3 + 8 >> 2] | 0;
     i7 = HEAP32[i3 + 12 >> 2] | 0;
     HEAP32[i4 >> 2] = i7 + i5;
    }
   } while (0);
   i4 = i5 + i7 | 0;
   i5 = (i4 | 0) / 100 | 0;
   i6 = HEAP32[i3 + 156 >> 2] | 0;
   if ((i6 | 0) < (2147483644 / (i5 | 0) | 0 | 0)) {
    i5 = Math_imul(i6, i5) | 0;
   } else {
    i5 = 2147483644;
   }
   _luaE_setdebt(i3, i4 - i5 | 0);
   i5 = i3 + 61 | 0;
  } else {
   i4 = i3 + 12 | 0;
   i5 = HEAP32[i3 + 164 >> 2] | 0;
   i7 = (i5 | 0) < 40 ? 40 : i5;
   i5 = ((HEAP32[i4 >> 2] | 0) / 200 | 0) + 1 | 0;
   if ((i5 | 0) < (2147483644 / (i7 | 0) | 0 | 0)) {
    i8 = Math_imul(i5, i7) | 0;
   } else {
    i8 = 2147483644;
   }
   i5 = i3 + 61 | 0;
   do {
    i8 = i8 - (_singlestep(i2) | 0) | 0;
    i9 = (HEAP8[i5] | 0) == 5;
    if (!((i8 | 0) > -1600)) {
     i6 = 17;
     break;
    }
   } while (!i9);
   if ((i6 | 0) == 17 ? !i9 : 0) {
    _luaE_setdebt(i3, ((i8 | 0) / (i7 | 0) | 0) * 200 | 0);
    break;
   }
   i6 = (HEAP32[i3 + 20 >> 2] | 0) / 100 | 0;
   i7 = HEAP32[i3 + 156 >> 2] | 0;
   if ((i7 | 0) < (2147483644 / (i6 | 0) | 0 | 0)) {
    i6 = Math_imul(i7, i6) | 0;
   } else {
    i6 = 2147483644;
   }
   _luaE_setdebt(i3, (HEAP32[i3 + 8 >> 2] | 0) - i6 + (HEAP32[i4 >> 2] | 0) | 0);
  }
 } while (0);
 i3 = i3 + 104 | 0;
 if ((HEAP32[i3 >> 2] | 0) == 0) {
  STACKTOP = i1;
  return;
 } else {
  i4 = 0;
 }
 while (1) {
  if ((i4 | 0) >= 4 ? (HEAP8[i5] | 0) != 5 : 0) {
   i6 = 26;
   break;
  }
  _GCTM(i2, 1);
  if ((HEAP32[i3 >> 2] | 0) == 0) {
   i6 = 26;
   break;
  } else {
   i4 = i4 + 1 | 0;
  }
 }
 if ((i6 | 0) == 26) {
  STACKTOP = i1;
  return;
 }
}
function _luaL_loadfilex(i1, i9, i7) {
 i1 = i1 | 0;
 i9 = i9 | 0;
 i7 = i7 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i8 = 0, i10 = 0, i11 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 1056 | 0;
 i3 = i5;
 i6 = i5 + 16 | 0;
 i8 = i5 + 12 | 0;
 i2 = (_lua_gettop(i1) | 0) + 1 | 0;
 i4 = (i9 | 0) == 0;
 if (!i4) {
  HEAP32[i3 >> 2] = i9;
  _lua_pushfstring(i1, 1304, i3) | 0;
  i10 = _fopen(i9 | 0, 1312) | 0;
  HEAP32[i6 + 4 >> 2] = i10;
  if ((i10 | 0) == 0) {
   i10 = _strerror(HEAP32[(___errno_location() | 0) >> 2] | 0) | 0;
   i9 = (_lua_tolstring(i1, i2, 0) | 0) + 1 | 0;
   HEAP32[i3 >> 2] = 1320;
   HEAP32[i3 + 4 >> 2] = i9;
   HEAP32[i3 + 8 >> 2] = i10;
   _lua_pushfstring(i1, 1720, i3) | 0;
   _lua_remove(i1, i2);
   i10 = 7;
   STACKTOP = i5;
   return i10 | 0;
  }
 } else {
  _lua_pushlstring(i1, 1296, 6) | 0;
  HEAP32[i6 + 4 >> 2] = HEAP32[_stdin >> 2];
 }
 if ((_skipcomment(i6, i8) | 0) != 0) {
  i10 = HEAP32[i6 >> 2] | 0;
  HEAP32[i6 >> 2] = i10 + 1;
  HEAP8[i6 + i10 + 8 | 0] = 10;
 }
 i10 = HEAP32[i8 >> 2] | 0;
 do {
  if (!((i10 | 0) != 27 | i4)) {
   i11 = i6 + 4 | 0;
   i10 = _freopen(i9 | 0, 1328, HEAP32[i11 >> 2] | 0) | 0;
   HEAP32[i11 >> 2] = i10;
   if ((i10 | 0) != 0) {
    _skipcomment(i6, i8) | 0;
    i10 = HEAP32[i8 >> 2] | 0;
    break;
   }
   i11 = _strerror(HEAP32[(___errno_location() | 0) >> 2] | 0) | 0;
   i10 = (_lua_tolstring(i1, i2, 0) | 0) + 1 | 0;
   HEAP32[i3 >> 2] = 1336;
   HEAP32[i3 + 4 >> 2] = i10;
   HEAP32[i3 + 8 >> 2] = i11;
   _lua_pushfstring(i1, 1720, i3) | 0;
   _lua_remove(i1, i2);
   i11 = 7;
   STACKTOP = i5;
   return i11 | 0;
  }
 } while (0);
 if (!((i10 | 0) == -1)) {
  i11 = HEAP32[i6 >> 2] | 0;
  HEAP32[i6 >> 2] = i11 + 1;
  HEAP8[i6 + i11 + 8 | 0] = i10;
 }
 i7 = _lua_load(i1, 1, i6, _lua_tolstring(i1, -1, 0) | 0, i7) | 0;
 i8 = HEAP32[i6 + 4 >> 2] | 0;
 i6 = _ferror(i8 | 0) | 0;
 if (!i4) {
  _fclose(i8 | 0) | 0;
 }
 if ((i6 | 0) == 0) {
  _lua_remove(i1, i2);
  i11 = i7;
  STACKTOP = i5;
  return i11 | 0;
 } else {
  _lua_settop(i1, i2);
  i11 = _strerror(HEAP32[(___errno_location() | 0) >> 2] | 0) | 0;
  i10 = (_lua_tolstring(i1, i2, 0) | 0) + 1 | 0;
  HEAP32[i3 >> 2] = 1344;
  HEAP32[i3 + 4 >> 2] = i10;
  HEAP32[i3 + 8 >> 2] = i11;
  _lua_pushfstring(i1, 1720, i3) | 0;
  _lua_remove(i1, i2);
  i11 = 7;
  STACKTOP = i5;
  return i11 | 0;
 }
 return 0;
}
function _newupvalue(i3, i1, i2) {
 i3 = i3 | 0;
 i1 = i1 | 0;
 i2 = i2 | 0;
 var i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i12 = i4;
 i5 = HEAP32[i3 >> 2] | 0;
 i9 = i5 + 40 | 0;
 i7 = HEAP32[i9 >> 2] | 0;
 i6 = i3 + 47 | 0;
 i10 = HEAPU8[i6] | 0;
 if ((i10 + 1 | 0) >>> 0 > 255) {
  i11 = i3 + 12 | 0;
  i8 = HEAP32[(HEAP32[i11 >> 2] | 0) + 52 >> 2] | 0;
  i13 = HEAP32[i5 + 64 >> 2] | 0;
  if ((i13 | 0) == 0) {
   i15 = 6552;
   HEAP32[i12 >> 2] = 6880;
   i14 = i12 + 4 | 0;
   HEAP32[i14 >> 2] = 255;
   i14 = i12 + 8 | 0;
   HEAP32[i14 >> 2] = i15;
   i14 = _luaO_pushfstring(i8, 6592, i12) | 0;
   i15 = HEAP32[i11 >> 2] | 0;
   _luaX_syntaxerror(i15, i14);
  }
  HEAP32[i12 >> 2] = i13;
  i14 = _luaO_pushfstring(i8, 6568, i12) | 0;
  HEAP32[i12 >> 2] = 6880;
  i15 = i12 + 4 | 0;
  HEAP32[i15 >> 2] = 255;
  i15 = i12 + 8 | 0;
  HEAP32[i15 >> 2] = i14;
  i15 = _luaO_pushfstring(i8, 6592, i12) | 0;
  i14 = HEAP32[i11 >> 2] | 0;
  _luaX_syntaxerror(i14, i15);
 }
 if ((i10 | 0) < (i7 | 0)) {
  i8 = i7;
 } else {
  i8 = i5 + 28 | 0;
  HEAP32[i8 >> 2] = _luaM_growaux_(HEAP32[(HEAP32[i3 + 12 >> 2] | 0) + 52 >> 2] | 0, HEAP32[i8 >> 2] | 0, i9, 8, 255, 6880) | 0;
  i8 = HEAP32[i9 >> 2] | 0;
 }
 i9 = i5 + 28 | 0;
 if ((i7 | 0) < (i8 | 0)) {
  while (1) {
   i10 = i7 + 1 | 0;
   HEAP32[(HEAP32[i9 >> 2] | 0) + (i7 << 3) >> 2] = 0;
   if ((i10 | 0) < (i8 | 0)) {
    i7 = i10;
   } else {
    break;
   }
  }
 }
 HEAP8[(HEAP32[i9 >> 2] | 0) + ((HEAPU8[i6] | 0) << 3) + 4 | 0] = (HEAP32[i2 >> 2] | 0) == 7 | 0;
 HEAP8[(HEAP32[i9 >> 2] | 0) + ((HEAPU8[i6] | 0) << 3) + 5 | 0] = HEAP32[i2 + 8 >> 2];
 HEAP32[(HEAP32[i9 >> 2] | 0) + ((HEAPU8[i6] | 0) << 3) >> 2] = i1;
 if ((HEAP8[i1 + 5 | 0] & 3) == 0) {
  i15 = HEAP8[i6] | 0;
  i14 = i15 + 1 << 24 >> 24;
  HEAP8[i6] = i14;
  i15 = i15 & 255;
  STACKTOP = i4;
  return i15 | 0;
 }
 if ((HEAP8[i5 + 5 | 0] & 4) == 0) {
  i15 = HEAP8[i6] | 0;
  i14 = i15 + 1 << 24 >> 24;
  HEAP8[i6] = i14;
  i15 = i15 & 255;
  STACKTOP = i4;
  return i15 | 0;
 }
 _luaC_barrier_(HEAP32[(HEAP32[i3 + 12 >> 2] | 0) + 52 >> 2] | 0, i5, i1);
 i15 = HEAP8[i6] | 0;
 i14 = i15 + 1 << 24 >> 24;
 HEAP8[i6] = i14;
 i15 = i15 & 255;
 STACKTOP = i4;
 return i15 | 0;
}
function _close_func(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i6 = STACKTOP;
 i2 = HEAP32[i1 + 52 >> 2] | 0;
 i5 = i1 + 48 | 0;
 i4 = HEAP32[i5 >> 2] | 0;
 i3 = HEAP32[i4 >> 2] | 0;
 _luaK_ret(i4, 0, 0);
 _leaveblock(i4);
 i7 = i4 + 20 | 0;
 i8 = HEAP32[i7 >> 2] | 0;
 if ((i8 + 1 | 0) >>> 0 > 1073741823) {
  _luaM_toobig(i2);
 }
 i10 = i3 + 12 | 0;
 i9 = i3 + 48 | 0;
 HEAP32[i10 >> 2] = _luaM_realloc_(i2, HEAP32[i10 >> 2] | 0, HEAP32[i9 >> 2] << 2, i8 << 2) | 0;
 HEAP32[i9 >> 2] = HEAP32[i7 >> 2];
 i8 = HEAP32[i7 >> 2] | 0;
 if ((i8 + 1 | 0) >>> 0 > 1073741823) {
  _luaM_toobig(i2);
 }
 i9 = i3 + 20 | 0;
 i10 = i3 + 52 | 0;
 HEAP32[i9 >> 2] = _luaM_realloc_(i2, HEAP32[i9 >> 2] | 0, HEAP32[i10 >> 2] << 2, i8 << 2) | 0;
 HEAP32[i10 >> 2] = HEAP32[i7 >> 2];
 i8 = i4 + 32 | 0;
 i7 = HEAP32[i8 >> 2] | 0;
 if ((i7 + 1 | 0) >>> 0 > 268435455) {
  _luaM_toobig(i2);
 }
 i9 = i3 + 8 | 0;
 i10 = i3 + 44 | 0;
 HEAP32[i9 >> 2] = _luaM_realloc_(i2, HEAP32[i9 >> 2] | 0, HEAP32[i10 >> 2] << 4, i7 << 4) | 0;
 HEAP32[i10 >> 2] = HEAP32[i8 >> 2];
 i8 = i4 + 36 | 0;
 i7 = HEAP32[i8 >> 2] | 0;
 if ((i7 + 1 | 0) >>> 0 > 1073741823) {
  _luaM_toobig(i2);
 }
 i9 = i3 + 16 | 0;
 i10 = i3 + 56 | 0;
 HEAP32[i9 >> 2] = _luaM_realloc_(i2, HEAP32[i9 >> 2] | 0, HEAP32[i10 >> 2] << 2, i7 << 2) | 0;
 HEAP32[i10 >> 2] = HEAP32[i8 >> 2];
 i7 = i4 + 44 | 0;
 i8 = HEAP16[i7 >> 1] | 0;
 if ((i8 + 1 | 0) >>> 0 > 357913941) {
  _luaM_toobig(i2);
 }
 i10 = i3 + 24 | 0;
 i9 = i3 + 60 | 0;
 HEAP32[i10 >> 2] = _luaM_realloc_(i2, HEAP32[i10 >> 2] | 0, (HEAP32[i9 >> 2] | 0) * 12 | 0, i8 * 12 | 0) | 0;
 HEAP32[i9 >> 2] = HEAP16[i7 >> 1] | 0;
 i9 = i4 + 47 | 0;
 i8 = i3 + 28 | 0;
 i10 = i3 + 40 | 0;
 HEAP32[i8 >> 2] = _luaM_realloc_(i2, HEAP32[i8 >> 2] | 0, HEAP32[i10 >> 2] << 3, HEAPU8[i9] << 3) | 0;
 HEAP32[i10 >> 2] = HEAPU8[i9] | 0;
 HEAP32[i5 >> 2] = HEAP32[i4 + 8 >> 2];
 if (((HEAP32[i1 + 16 >> 2] | 0) + -288 | 0) >>> 0 < 2) {
  i10 = HEAP32[i1 + 24 >> 2] | 0;
  _luaX_newstring(i1, i10 + 16 | 0, HEAP32[i10 + 12 >> 2] | 0) | 0;
 }
 i10 = i2 + 8 | 0;
 HEAP32[i10 >> 2] = (HEAP32[i10 >> 2] | 0) + -16;
 if ((HEAP32[(HEAP32[i2 + 12 >> 2] | 0) + 12 >> 2] | 0) <= 0) {
  STACKTOP = i6;
  return;
 }
 _luaC_step(i2);
 STACKTOP = i6;
 return;
}
function _lua_topointer(i3, i6) {
 i3 = i3 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0;
 i1 = STACKTOP;
 i4 = HEAP32[i3 + 16 >> 2] | 0;
 i5 = (i6 | 0) > 0;
 do {
  if (!i5) {
   if (!((i6 | 0) < -1000999)) {
    i7 = (HEAP32[i3 + 8 >> 2] | 0) + (i6 << 4) | 0;
    break;
   }
   if ((i6 | 0) == -1001e3) {
    i7 = (HEAP32[i3 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i8 = -1001e3 - i6 | 0;
   i9 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i9 + 8 >> 2] | 0) != 22 ? (i7 = HEAP32[i9 >> 2] | 0, (i8 | 0) <= (HEAPU8[i7 + 6 | 0] | 0 | 0)) : 0) {
    i7 = i7 + (i8 + -1 << 4) + 16 | 0;
   } else {
    i7 = 5192;
   }
  } else {
   i7 = (HEAP32[i4 >> 2] | 0) + (i6 << 4) | 0;
   i7 = i7 >>> 0 < (HEAP32[i3 + 8 >> 2] | 0) >>> 0 ? i7 : 5192;
  }
 } while (0);
 switch (HEAP32[i7 + 8 >> 2] & 63 | 0) {
 case 22:
  {
   i9 = HEAP32[i7 >> 2] | 0;
   STACKTOP = i1;
   return i9 | 0;
  }
 case 2:
 case 7:
  {
   do {
    if (!i5) {
     if (!((i6 | 0) < -1000999)) {
      i2 = (HEAP32[i3 + 8 >> 2] | 0) + (i6 << 4) | 0;
      break;
     }
     if ((i6 | 0) == -1001e3) {
      i2 = (HEAP32[i3 + 12 >> 2] | 0) + 40 | 0;
      break;
     }
     i3 = -1001e3 - i6 | 0;
     i4 = HEAP32[i4 >> 2] | 0;
     if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i2 = HEAP32[i4 >> 2] | 0, (i3 | 0) <= (HEAPU8[i2 + 6 | 0] | 0 | 0)) : 0) {
      i2 = i2 + (i3 + -1 << 4) + 16 | 0;
     } else {
      i2 = 5192;
     }
    } else {
     i2 = (HEAP32[i4 >> 2] | 0) + (i6 << 4) | 0;
     i2 = i2 >>> 0 < (HEAP32[i3 + 8 >> 2] | 0) >>> 0 ? i2 : 5192;
    }
   } while (0);
   i3 = HEAP32[i2 + 8 >> 2] & 15;
   if ((i3 | 0) == 7) {
    i9 = (HEAP32[i2 >> 2] | 0) + 24 | 0;
    STACKTOP = i1;
    return i9 | 0;
   } else if ((i3 | 0) == 2) {
    i9 = HEAP32[i2 >> 2] | 0;
    STACKTOP = i1;
    return i9 | 0;
   } else {
    i9 = 0;
    STACKTOP = i1;
    return i9 | 0;
   }
  }
 case 8:
  {
   i9 = HEAP32[i7 >> 2] | 0;
   STACKTOP = i1;
   return i9 | 0;
  }
 case 5:
  {
   i9 = HEAP32[i7 >> 2] | 0;
   STACKTOP = i1;
   return i9 | 0;
  }
 case 38:
  {
   i9 = HEAP32[i7 >> 2] | 0;
   STACKTOP = i1;
   return i9 | 0;
  }
 case 6:
  {
   i9 = HEAP32[i7 >> 2] | 0;
   STACKTOP = i1;
   return i9 | 0;
  }
 default:
  {
   i9 = 0;
   STACKTOP = i1;
   return i9 | 0;
  }
 }
 return 0;
}
function _luaH_get(i4, i6) {
 i4 = i4 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i3 = 0, d5 = 0.0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, d11 = 0.0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i8 = i3 + 8 | 0;
 i9 = i3;
 i7 = i6 + 8 | 0;
 i10 = HEAP32[i7 >> 2] & 63;
 if ((i10 | 0) == 4) {
  i6 = HEAP32[i6 >> 2] | 0;
  i7 = (HEAP32[i4 + 16 >> 2] | 0) + (((1 << (HEAPU8[i4 + 7 | 0] | 0)) + -1 & HEAP32[i6 + 8 >> 2]) << 5) | 0;
  while (1) {
   if ((HEAP32[i7 + 24 >> 2] | 0) == 68 ? (HEAP32[i7 + 16 >> 2] | 0) == (i6 | 0) : 0) {
    break;
   }
   i4 = HEAP32[i7 + 28 >> 2] | 0;
   if ((i4 | 0) == 0) {
    i2 = 5192;
    i1 = 22;
    break;
   } else {
    i7 = i4;
   }
  }
  if ((i1 | 0) == 22) {
   STACKTOP = i3;
   return i2 | 0;
  }
  i10 = i7;
  STACKTOP = i3;
  return i10 | 0;
 } else if ((i10 | 0) == 3) {
  d11 = +HEAPF64[i6 >> 3];
  HEAPF64[i9 >> 3] = d11 + 6755399441055744.0;
  i9 = HEAP32[i9 >> 2] | 0;
  d5 = +(i9 | 0);
  if (d5 == d11) {
   i6 = i9 + -1 | 0;
   if (i6 >>> 0 < (HEAP32[i4 + 28 >> 2] | 0) >>> 0) {
    i10 = (HEAP32[i4 + 12 >> 2] | 0) + (i6 << 4) | 0;
    STACKTOP = i3;
    return i10 | 0;
   }
   HEAPF64[i8 >> 3] = d5 + 1.0;
   i6 = (HEAP32[i8 + 4 >> 2] | 0) + (HEAP32[i8 >> 2] | 0) | 0;
   if ((i6 | 0) < 0) {
    i7 = 0 - i6 | 0;
    i6 = (i6 | 0) == (i7 | 0) ? 0 : i7;
   }
   i4 = (HEAP32[i4 + 16 >> 2] | 0) + (((i6 | 0) % ((1 << (HEAPU8[i4 + 7 | 0] | 0)) + -1 | 1 | 0) | 0) << 5) | 0;
   while (1) {
    if ((HEAP32[i4 + 24 >> 2] | 0) == 3 ? +HEAPF64[i4 + 16 >> 3] == d5 : 0) {
     break;
    }
    i6 = HEAP32[i4 + 28 >> 2] | 0;
    if ((i6 | 0) == 0) {
     i2 = 5192;
     i1 = 22;
     break;
    } else {
     i4 = i6;
    }
   }
   if ((i1 | 0) == 22) {
    STACKTOP = i3;
    return i2 | 0;
   }
   i10 = i4;
   STACKTOP = i3;
   return i10 | 0;
  }
 } else if ((i10 | 0) == 0) {
  i10 = 5192;
  STACKTOP = i3;
  return i10 | 0;
 }
 i8 = _mainposition(i4, i6) | 0;
 while (1) {
  if ((HEAP32[i8 + 24 >> 2] | 0) == (HEAP32[i7 >> 2] | 0) ? (_luaV_equalobj_(0, i8 + 16 | 0, i6) | 0) != 0 : 0) {
   break;
  }
  i4 = HEAP32[i8 + 28 >> 2] | 0;
  if ((i4 | 0) == 0) {
   i2 = 5192;
   i1 = 22;
   break;
  } else {
   i8 = i4;
  }
 }
 if ((i1 | 0) == 22) {
  STACKTOP = i3;
  return i2 | 0;
 }
 i10 = i8;
 STACKTOP = i3;
 return i10 | 0;
}
function _suffixedexp(i1, i8) {
 i1 = i1 | 0;
 i8 = i8 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 80 | 0;
 i10 = i2 + 48 | 0;
 i3 = i2 + 24 | 0;
 i6 = i2;
 i4 = i1 + 48 | 0;
 i9 = HEAP32[i4 >> 2] | 0;
 i5 = HEAP32[i1 + 4 >> 2] | 0;
 i7 = i1 + 16 | 0;
 i12 = HEAP32[i7 >> 2] | 0;
 if ((i12 | 0) == 40) {
  _luaX_next(i1);
  _subexpr(i1, i8, 0) | 0;
  _check_match(i1, 41, 40, i5);
  _luaK_dischargevars(HEAP32[i4 >> 2] | 0, i8);
  i11 = i1 + 24 | 0;
 } else if ((i12 | 0) == 288) {
  i11 = i1 + 24 | 0;
  i13 = HEAP32[i11 >> 2] | 0;
  _luaX_next(i1);
  i12 = HEAP32[i4 >> 2] | 0;
  if ((_singlevaraux(i12, i13, i8, 1) | 0) == 0) {
   _singlevaraux(i12, HEAP32[i1 + 72 >> 2] | 0, i8, 1) | 0;
   i13 = _luaK_stringK(HEAP32[i4 >> 2] | 0, i13) | 0;
   HEAP32[i10 + 16 >> 2] = -1;
   HEAP32[i10 + 20 >> 2] = -1;
   HEAP32[i10 >> 2] = 4;
   HEAP32[i10 + 8 >> 2] = i13;
   _luaK_indexed(i12, i8, i10);
  }
 } else {
  _luaX_syntaxerror(i1, 6656);
 }
 i10 = i6 + 16 | 0;
 i12 = i6 + 20 | 0;
 i13 = i6 + 8 | 0;
 L7 : while (1) {
  switch (HEAP32[i7 >> 2] | 0) {
  case 46:
   {
    _fieldsel(i1, i8);
    continue L7;
   }
  case 91:
   {
    _luaK_exp2anyregup(i9, i8);
    _luaX_next(i1);
    _subexpr(i1, i3, 0) | 0;
    _luaK_exp2val(HEAP32[i4 >> 2] | 0, i3);
    if ((HEAP32[i7 >> 2] | 0) != 93) {
     i3 = 10;
     break L7;
    }
    _luaX_next(i1);
    _luaK_indexed(i9, i8, i3);
    continue L7;
   }
  case 58:
   {
    _luaX_next(i1);
    if ((HEAP32[i7 >> 2] | 0) != 288) {
     i3 = 13;
     break L7;
    }
    i14 = HEAP32[i11 >> 2] | 0;
    _luaX_next(i1);
    i14 = _luaK_stringK(HEAP32[i4 >> 2] | 0, i14) | 0;
    HEAP32[i10 >> 2] = -1;
    HEAP32[i12 >> 2] = -1;
    HEAP32[i6 >> 2] = 4;
    HEAP32[i13 >> 2] = i14;
    _luaK_self(i9, i8, i6);
    _funcargs(i1, i8, i5);
    continue L7;
   }
  case 123:
  case 289:
  case 40:
   {
    _luaK_exp2nextreg(i9, i8);
    _funcargs(i1, i8, i5);
    continue L7;
   }
  default:
   {
    i3 = 16;
    break L7;
   }
  }
 }
 if ((i3 | 0) == 10) {
  _error_expected(i1, 93);
 } else if ((i3 | 0) == 13) {
  _error_expected(i1, 288);
 } else if ((i3 | 0) == 16) {
  STACKTOP = i2;
  return;
 }
}
function _luaK_patchlist(i2, i7, i3) {
 i2 = i2 | 0;
 i7 = i7 | 0;
 i3 = i3 | 0;
 var i1 = 0, i4 = 0, i5 = 0, i6 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0;
 i1 = STACKTOP;
 if ((HEAP32[i2 + 20 >> 2] | 0) == (i3 | 0)) {
  HEAP32[i2 + 24 >> 2] = i3;
  i3 = i2 + 28 | 0;
  if ((i7 | 0) == -1) {
   STACKTOP = i1;
   return;
  }
  i6 = HEAP32[i3 >> 2] | 0;
  if ((i6 | 0) == -1) {
   HEAP32[i3 >> 2] = i7;
   STACKTOP = i1;
   return;
  }
  i5 = HEAP32[(HEAP32[i2 >> 2] | 0) + 12 >> 2] | 0;
  while (1) {
   i3 = i5 + (i6 << 2) | 0;
   i4 = HEAP32[i3 >> 2] | 0;
   i8 = (i4 >>> 14) + -131071 | 0;
   if ((i8 | 0) == -1) {
    break;
   }
   i8 = i6 + 1 + i8 | 0;
   if ((i8 | 0) == -1) {
    break;
   } else {
    i6 = i8;
   }
  }
  i5 = ~i6 + i7 | 0;
  if ((((i5 | 0) > -1 ? i5 : 0 - i5 | 0) | 0) > 131071) {
   _luaX_syntaxerror(HEAP32[i2 + 12 >> 2] | 0, 10624);
  }
  HEAP32[i3 >> 2] = (i5 << 14) + 2147467264 | i4 & 16383;
  STACKTOP = i1;
  return;
 }
 if ((i7 | 0) == -1) {
  STACKTOP = i1;
  return;
 }
 i6 = HEAP32[(HEAP32[i2 >> 2] | 0) + 12 >> 2] | 0;
 i10 = i7;
 while (1) {
  i7 = i6 + (i10 << 2) | 0;
  i9 = HEAP32[i7 >> 2] | 0;
  i8 = (i9 >>> 14) + -131071 | 0;
  if ((i8 | 0) == -1) {
   i8 = -1;
  } else {
   i8 = i10 + 1 + i8 | 0;
  }
  if ((i10 | 0) > 0 ? (i4 = i6 + (i10 + -1 << 2) | 0, i5 = HEAP32[i4 >> 2] | 0, (HEAP8[5584 + (i5 & 63) | 0] | 0) < 0) : 0) {
   i12 = i4;
   i11 = i5;
  } else {
   i12 = i7;
   i11 = i9;
  }
  if ((i11 & 63 | 0) == 28) {
   HEAP32[i12 >> 2] = i11 & 8372224 | i11 >>> 23 << 6 | 27;
   i9 = ~i10 + i3 | 0;
   if ((((i9 | 0) > -1 ? i9 : 0 - i9 | 0) | 0) > 131071) {
    i3 = 20;
    break;
   }
   i9 = HEAP32[i7 >> 2] & 16383 | (i9 << 14) + 2147467264;
  } else {
   i10 = ~i10 + i3 | 0;
   if ((((i10 | 0) > -1 ? i10 : 0 - i10 | 0) | 0) > 131071) {
    i3 = 23;
    break;
   }
   i9 = i9 & 16383 | (i10 << 14) + 2147467264;
  }
  HEAP32[i7 >> 2] = i9;
  if ((i8 | 0) == -1) {
   i3 = 26;
   break;
  } else {
   i10 = i8;
  }
 }
 if ((i3 | 0) == 20) {
  _luaX_syntaxerror(HEAP32[i2 + 12 >> 2] | 0, 10624);
 } else if ((i3 | 0) == 23) {
  _luaX_syntaxerror(HEAP32[i2 + 12 >> 2] | 0, 10624);
 } else if ((i3 | 0) == 26) {
  STACKTOP = i1;
  return;
 }
}
function _luaG_typeerror(i5, i6, i1) {
 i5 = i5 | 0;
 i6 = i6 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i3 = i2;
 i2 = i2 + 16 | 0;
 i8 = HEAP32[i5 + 16 >> 2] | 0;
 HEAP32[i2 >> 2] = 0;
 i4 = HEAP32[8528 + ((HEAP32[i6 + 8 >> 2] & 15) + 1 << 2) >> 2] | 0;
 L1 : do {
  if (!((HEAP8[i8 + 18 | 0] & 1) == 0)) {
   i7 = HEAP32[HEAP32[i8 >> 2] >> 2] | 0;
   i10 = HEAP8[i7 + 6 | 0] | 0;
   L3 : do {
    if (!(i10 << 24 >> 24 == 0)) {
     i9 = i7 + 16 | 0;
     i11 = i10 & 255;
     i10 = 0;
     while (1) {
      i12 = i10 + 1 | 0;
      if ((HEAP32[(HEAP32[i9 + (i10 << 2) >> 2] | 0) + 8 >> 2] | 0) == (i6 | 0)) {
       break;
      }
      if ((i12 | 0) < (i11 | 0)) {
       i10 = i12;
      } else {
       break L3;
      }
     }
     i9 = HEAP32[(HEAP32[(HEAP32[i7 + 12 >> 2] | 0) + 28 >> 2] | 0) + (i10 << 3) >> 2] | 0;
     if ((i9 | 0) == 0) {
      i9 = 2104;
     } else {
      i9 = i9 + 16 | 0;
     }
     HEAP32[i2 >> 2] = i9;
     i11 = i9;
     i10 = 2072;
     HEAP32[i3 >> 2] = i1;
     i12 = i3 + 4 | 0;
     HEAP32[i12 >> 2] = i10;
     i12 = i3 + 8 | 0;
     HEAP32[i12 >> 2] = i11;
     i12 = i3 + 12 | 0;
     HEAP32[i12 >> 2] = i4;
     _luaG_runerror(i5, 1840, i3);
    }
   } while (0);
   i9 = HEAP32[i8 + 24 >> 2] | 0;
   i10 = HEAP32[i8 + 4 >> 2] | 0;
   if (i9 >>> 0 < i10 >>> 0) {
    i12 = i9;
    while (1) {
     i11 = i12 + 16 | 0;
     if ((i12 | 0) == (i6 | 0)) {
      break;
     }
     if (i11 >>> 0 < i10 >>> 0) {
      i12 = i11;
     } else {
      break L1;
     }
    }
    i12 = HEAP32[i7 + 12 >> 2] | 0;
    i6 = _getobjname(i12, ((HEAP32[i8 + 28 >> 2] | 0) - (HEAP32[i12 + 12 >> 2] | 0) >> 2) + -1 | 0, i6 - i9 >> 4, i2) | 0;
    if ((i6 | 0) != 0) {
     i11 = HEAP32[i2 >> 2] | 0;
     i10 = i6;
     HEAP32[i3 >> 2] = i1;
     i12 = i3 + 4 | 0;
     HEAP32[i12 >> 2] = i10;
     i12 = i3 + 8 | 0;
     HEAP32[i12 >> 2] = i11;
     i12 = i3 + 12 | 0;
     HEAP32[i12 >> 2] = i4;
     _luaG_runerror(i5, 1840, i3);
    }
   }
  }
 } while (0);
 HEAP32[i3 >> 2] = i1;
 HEAP32[i3 + 4 >> 2] = i4;
 _luaG_runerror(i5, 1880, i3);
}
function _lua_setmetatable(i1, i7) {
 i1 = i1 | 0;
 i7 = i7 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i8 = 0;
 i4 = STACKTOP;
 i6 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i7 | 0) <= 0) {
   if (!((i7 | 0) < -1000999)) {
    i5 = (HEAP32[i1 + 8 >> 2] | 0) + (i7 << 4) | 0;
    break;
   }
   if ((i7 | 0) == -1001e3) {
    i5 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i7 = -1001e3 - i7 | 0;
   i6 = HEAP32[i6 >> 2] | 0;
   if ((HEAP32[i6 + 8 >> 2] | 0) != 22 ? (i5 = HEAP32[i6 >> 2] | 0, (i7 | 0) <= (HEAPU8[i5 + 6 | 0] | 0 | 0)) : 0) {
    i5 = i5 + (i7 + -1 << 4) + 16 | 0;
   } else {
    i5 = 5192;
   }
  } else {
   i5 = (HEAP32[i6 >> 2] | 0) + (i7 << 4) | 0;
   i5 = i5 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i5 : 5192;
  }
 } while (0);
 i6 = i1 + 8 | 0;
 i7 = HEAP32[i6 >> 2] | 0;
 if ((HEAP32[i7 + -8 >> 2] | 0) == 0) {
  i7 = 0;
 } else {
  i7 = HEAP32[i7 + -16 >> 2] | 0;
 }
 i8 = HEAP32[i5 + 8 >> 2] & 15;
 if ((i8 | 0) == 5) {
  HEAP32[(HEAP32[i5 >> 2] | 0) + 8 >> 2] = i7;
  if ((i7 | 0) == 0) {
   i8 = HEAP32[i6 >> 2] | 0;
   i8 = i8 + -16 | 0;
   HEAP32[i6 >> 2] = i8;
   STACKTOP = i4;
   return 1;
  }
  if (!((HEAP8[i7 + 5 | 0] & 3) == 0) ? (i2 = HEAP32[i5 >> 2] | 0, !((HEAP8[i2 + 5 | 0] & 4) == 0)) : 0) {
   _luaC_barrierback_(i1, i2);
  }
  _luaC_checkfinalizer(i1, HEAP32[i5 >> 2] | 0, i7);
  i8 = HEAP32[i6 >> 2] | 0;
  i8 = i8 + -16 | 0;
  HEAP32[i6 >> 2] = i8;
  STACKTOP = i4;
  return 1;
 } else if ((i8 | 0) == 7) {
  HEAP32[(HEAP32[i5 >> 2] | 0) + 8 >> 2] = i7;
  if ((i7 | 0) == 0) {
   i8 = HEAP32[i6 >> 2] | 0;
   i8 = i8 + -16 | 0;
   HEAP32[i6 >> 2] = i8;
   STACKTOP = i4;
   return 1;
  }
  if (!((HEAP8[i7 + 5 | 0] & 3) == 0) ? (i3 = HEAP32[i5 >> 2] | 0, !((HEAP8[i3 + 5 | 0] & 4) == 0)) : 0) {
   _luaC_barrier_(i1, i3, i7);
  }
  _luaC_checkfinalizer(i1, HEAP32[i5 >> 2] | 0, i7);
  i8 = HEAP32[i6 >> 2] | 0;
  i8 = i8 + -16 | 0;
  HEAP32[i6 >> 2] = i8;
  STACKTOP = i4;
  return 1;
 } else {
  HEAP32[(HEAP32[i1 + 12 >> 2] | 0) + (i8 << 2) + 252 >> 2] = i7;
  i8 = HEAP32[i6 >> 2] | 0;
  i8 = i8 + -16 | 0;
  HEAP32[i6 >> 2] = i8;
  STACKTOP = i4;
  return 1;
 }
 return 0;
}
function _recfield(i2, i10) {
 i2 = i2 | 0;
 i10 = i10 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i9 = i1 + 48 | 0;
 i6 = i1 + 24 | 0;
 i3 = i1;
 i13 = i2 + 48 | 0;
 i8 = HEAP32[i13 >> 2] | 0;
 i5 = i8 + 48 | 0;
 i4 = HEAP8[i5] | 0;
 i7 = i2 + 16 | 0;
 do {
  if ((HEAP32[i7 >> 2] | 0) != 288) {
   _luaX_next(i2);
   _subexpr(i2, i6, 0) | 0;
   _luaK_exp2val(HEAP32[i13 >> 2] | 0, i6);
   if ((HEAP32[i7 >> 2] | 0) == 93) {
    _luaX_next(i2);
    i11 = i10 + 28 | 0;
    break;
   } else {
    _error_expected(i2, 93);
   }
  } else {
   i12 = i10 + 28 | 0;
   if ((HEAP32[i12 >> 2] | 0) <= 2147483645) {
    i11 = HEAP32[i2 + 24 >> 2] | 0;
    _luaX_next(i2);
    i11 = _luaK_stringK(HEAP32[i13 >> 2] | 0, i11) | 0;
    HEAP32[i6 + 16 >> 2] = -1;
    HEAP32[i6 + 20 >> 2] = -1;
    HEAP32[i6 >> 2] = 4;
    HEAP32[i6 + 8 >> 2] = i11;
    i11 = i12;
    break;
   }
   i14 = i8 + 12 | 0;
   i13 = HEAP32[(HEAP32[i14 >> 2] | 0) + 52 >> 2] | 0;
   i12 = HEAP32[(HEAP32[i8 >> 2] | 0) + 64 >> 2] | 0;
   if ((i12 | 0) == 0) {
    i16 = 6552;
    HEAP32[i9 >> 2] = 6528;
    i15 = i9 + 4 | 0;
    HEAP32[i15 >> 2] = 2147483645;
    i15 = i9 + 8 | 0;
    HEAP32[i15 >> 2] = i16;
    i15 = _luaO_pushfstring(i13, 6592, i9) | 0;
    i16 = HEAP32[i14 >> 2] | 0;
    _luaX_syntaxerror(i16, i15);
   }
   HEAP32[i9 >> 2] = i12;
   i15 = _luaO_pushfstring(i13, 6568, i9) | 0;
   HEAP32[i9 >> 2] = 6528;
   i16 = i9 + 4 | 0;
   HEAP32[i16 >> 2] = 2147483645;
   i16 = i9 + 8 | 0;
   HEAP32[i16 >> 2] = i15;
   i16 = _luaO_pushfstring(i13, 6592, i9) | 0;
   i15 = HEAP32[i14 >> 2] | 0;
   _luaX_syntaxerror(i15, i16);
  }
 } while (0);
 HEAP32[i11 >> 2] = (HEAP32[i11 >> 2] | 0) + 1;
 if ((HEAP32[i7 >> 2] | 0) == 61) {
  _luaX_next(i2);
  i16 = _luaK_exp2RK(i8, i6) | 0;
  _subexpr(i2, i3, 0) | 0;
  i15 = HEAP32[(HEAP32[i10 + 24 >> 2] | 0) + 8 >> 2] | 0;
  _luaK_codeABC(i8, 10, i15, i16, _luaK_exp2RK(i8, i3) | 0) | 0;
  HEAP8[i5] = i4;
  STACKTOP = i1;
  return;
 } else {
  _error_expected(i2, 61);
 }
}
function _lua_newstate(i3, i6) {
 i3 = i3 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i7 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i5 = i1 + 8 | 0;
 i4 = i1;
 i2 = FUNCTION_TABLE_iiiii[i3 & 3](i6, 0, 8, 400) | 0;
 if ((i2 | 0) == 0) {
  i6 = 0;
  STACKTOP = i1;
  return i6 | 0;
 }
 i7 = i2 + 112 | 0;
 HEAP32[i2 >> 2] = 0;
 HEAP8[i2 + 4 | 0] = 8;
 HEAP8[i2 + 172 | 0] = 33;
 HEAP8[i2 + 5 | 0] = 1;
 HEAP8[i2 + 174 | 0] = 0;
 HEAP32[i2 + 12 >> 2] = i7;
 HEAP32[i2 + 28 >> 2] = 0;
 HEAP32[i2 + 16 >> 2] = 0;
 HEAP32[i2 + 32 >> 2] = 0;
 HEAP32[i2 + 64 >> 2] = 0;
 HEAP16[i2 + 38 >> 1] = 0;
 HEAP32[i2 + 52 >> 2] = 0;
 HEAP8[i2 + 40 | 0] = 0;
 HEAP32[i2 + 44 >> 2] = 0;
 HEAP8[i2 + 41 | 0] = 1;
 HEAP32[i2 + 48 >> 2] = 0;
 HEAP32[i2 + 56 >> 2] = 0;
 HEAP16[i2 + 36 >> 1] = 1;
 HEAP8[i2 + 6 | 0] = 0;
 HEAP32[i2 + 68 >> 2] = 0;
 HEAP32[i7 >> 2] = i3;
 HEAP32[i2 + 116 >> 2] = i6;
 HEAP32[i2 + 284 >> 2] = i2;
 i3 = _time(0) | 0;
 HEAP32[i4 >> 2] = i3;
 HEAP32[i5 >> 2] = i2;
 HEAP32[i5 + 4 >> 2] = i4;
 HEAP32[i5 + 8 >> 2] = 5192;
 HEAP32[i5 + 12 >> 2] = 1;
 HEAP32[i2 + 168 >> 2] = _luaS_hash(i5, 16, i3) | 0;
 i4 = i2 + 224 | 0;
 HEAP32[i2 + 240 >> 2] = i4;
 HEAP32[i2 + 244 >> 2] = i4;
 HEAP8[i2 + 175 | 0] = 0;
 i4 = i2 + 132 | 0;
 HEAP32[i2 + 160 >> 2] = 0;
 HEAP32[i2 + 256 >> 2] = 0;
 HEAP32[i2 + 264 >> 2] = 0;
 HEAP32[i2 + 280 >> 2] = 0;
 HEAP32[i4 + 0 >> 2] = 0;
 HEAP32[i4 + 4 >> 2] = 0;
 HEAP32[i4 + 8 >> 2] = 0;
 HEAP32[i4 + 12 >> 2] = 0;
 HEAP32[i2 + 288 >> 2] = _lua_version(0) | 0;
 HEAP8[i2 + 173 | 0] = 5;
 i4 = i2 + 120 | 0;
 i5 = i2 + 180 | 0;
 i3 = i5 + 40 | 0;
 do {
  HEAP32[i5 >> 2] = 0;
  i5 = i5 + 4 | 0;
 } while ((i5 | 0) < (i3 | 0));
 HEAP32[i4 >> 2] = 400;
 HEAP32[i2 + 124 >> 2] = 0;
 HEAP32[i2 + 268 >> 2] = 200;
 HEAP32[i2 + 272 >> 2] = 200;
 HEAP32[i2 + 276 >> 2] = 200;
 i5 = i2 + 364 | 0;
 i3 = i5 + 36 | 0;
 do {
  HEAP32[i5 >> 2] = 0;
  i5 = i5 + 4 | 0;
 } while ((i5 | 0) < (i3 | 0));
 if ((_luaD_rawrunprotected(i2, 8, 0) | 0) == 0) {
  i7 = i2;
  STACKTOP = i1;
  return i7 | 0;
 }
 _close_state(i2);
 i7 = 0;
 STACKTOP = i1;
 return i7 | 0;
}
function _luaU_undump(i1, i7, i8, i9) {
 i1 = i1 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 i9 = i9 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i4 = i2 + 16 | 0;
 i5 = i2 + 34 | 0;
 i3 = i2;
 i6 = HEAP8[i9] | 0;
 if (i6 << 24 >> 24 == 27) {
  HEAP32[i3 + 12 >> 2] = 8800;
 } else if (i6 << 24 >> 24 == 61 | i6 << 24 >> 24 == 64) {
  HEAP32[i3 + 12 >> 2] = i9 + 1;
 } else {
  HEAP32[i3 + 12 >> 2] = i9;
 }
 HEAP32[i3 >> 2] = i1;
 HEAP32[i3 + 4 >> 2] = i7;
 HEAP32[i3 + 8 >> 2] = i8;
 HEAP32[i4 >> 2] = 1635077147;
 HEAP8[i4 + 4 | 0] = 82;
 HEAP8[i4 + 5 | 0] = 0;
 HEAP8[i4 + 6 | 0] = 1;
 HEAP8[i4 + 7 | 0] = 4;
 HEAP8[i4 + 8 | 0] = 4;
 HEAP8[i4 + 9 | 0] = 4;
 HEAP8[i4 + 10 | 0] = 8;
 i9 = i4 + 12 | 0;
 HEAP8[i4 + 11 | 0] = 0;
 HEAP8[i9 + 0 | 0] = HEAP8[8816 | 0] | 0;
 HEAP8[i9 + 1 | 0] = HEAP8[8817 | 0] | 0;
 HEAP8[i9 + 2 | 0] = HEAP8[8818 | 0] | 0;
 HEAP8[i9 + 3 | 0] = HEAP8[8819 | 0] | 0;
 HEAP8[i9 + 4 | 0] = HEAP8[8820 | 0] | 0;
 HEAP8[i9 + 5 | 0] = HEAP8[8821 | 0] | 0;
 HEAP8[i5] = 27;
 if ((_luaZ_read(i7, i5 + 1 | 0, 17) | 0) != 0) {
  _error(i3, 8824);
 }
 if ((_memcmp(i4, i5, 18) | 0) == 0) {
  i4 = _luaF_newLclosure(i1, 1) | 0;
  i5 = i1 + 8 | 0;
  i9 = HEAP32[i5 >> 2] | 0;
  HEAP32[i9 >> 2] = i4;
  HEAP32[i9 + 8 >> 2] = 70;
  i9 = (HEAP32[i5 >> 2] | 0) + 16 | 0;
  HEAP32[i5 >> 2] = i9;
  if (((HEAP32[i1 + 24 >> 2] | 0) - i9 | 0) < 16) {
   _luaD_growstack(i1, 0);
  }
  i9 = _luaF_newproto(i1) | 0;
  i6 = i4 + 12 | 0;
  HEAP32[i6 >> 2] = i9;
  _LoadFunction(i3, i9);
  i6 = HEAP32[i6 >> 2] | 0;
  i3 = HEAP32[i6 + 40 >> 2] | 0;
  if ((i3 | 0) == 1) {
   i9 = i4;
   STACKTOP = i2;
   return i9 | 0;
  }
  i9 = _luaF_newLclosure(i1, i3) | 0;
  HEAP32[i9 + 12 >> 2] = i6;
  i8 = HEAP32[i5 >> 2] | 0;
  HEAP32[i8 + -16 >> 2] = i9;
  HEAP32[i8 + -8 >> 2] = 70;
  STACKTOP = i2;
  return i9 | 0;
 }
 if ((_memcmp(i4, i5, 4) | 0) != 0) {
  _error(i3, 8888);
 }
 if ((_memcmp(i4, i5, 6) | 0) != 0) {
  _error(i3, 8896);
 }
 if ((_memcmp(i4, i5, 12) | 0) == 0) {
  _error(i3, 8872);
 } else {
  _error(i3, 8920);
 }
 return 0;
}
function _lua_compare(i2, i7, i5, i3) {
 i2 = i2 | 0;
 i7 = i7 | 0;
 i5 = i5 | 0;
 i3 = i3 | 0;
 var i1 = 0, i4 = 0, i6 = 0, i8 = 0;
 i1 = STACKTOP;
 i4 = HEAP32[i2 + 16 >> 2] | 0;
 do {
  if ((i7 | 0) <= 0) {
   if (!((i7 | 0) < -1000999)) {
    i6 = (HEAP32[i2 + 8 >> 2] | 0) + (i7 << 4) | 0;
    break;
   }
   if ((i7 | 0) == -1001e3) {
    i6 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i7 = -1001e3 - i7 | 0;
   i8 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i8 + 8 >> 2] | 0) != 22 ? (i6 = HEAP32[i8 >> 2] | 0, (i7 | 0) <= (HEAPU8[i6 + 6 | 0] | 0 | 0)) : 0) {
    i6 = i6 + (i7 + -1 << 4) + 16 | 0;
   } else {
    i6 = 5192;
   }
  } else {
   i6 = (HEAP32[i4 >> 2] | 0) + (i7 << 4) | 0;
   i6 = i6 >>> 0 < (HEAP32[i2 + 8 >> 2] | 0) >>> 0 ? i6 : 5192;
  }
 } while (0);
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i4 = (HEAP32[i2 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i4 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) == 22) {
    i8 = 0;
    STACKTOP = i1;
    return i8 | 0;
   }
   i4 = HEAP32[i4 >> 2] | 0;
   if ((i5 | 0) > (HEAPU8[i4 + 6 | 0] | 0 | 0)) {
    i8 = 0;
    STACKTOP = i1;
    return i8 | 0;
   } else {
    i4 = i4 + (i5 + -1 << 4) + 16 | 0;
    break;
   }
  } else {
   i4 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i4 = i4 >>> 0 < (HEAP32[i2 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 if ((i6 | 0) == 5192 | (i4 | 0) == 5192) {
  i8 = 0;
  STACKTOP = i1;
  return i8 | 0;
 }
 if ((i3 | 0) == 1) {
  i8 = _luaV_lessthan(i2, i6, i4) | 0;
  STACKTOP = i1;
  return i8 | 0;
 } else if ((i3 | 0) == 2) {
  i8 = _luaV_lessequal(i2, i6, i4) | 0;
  STACKTOP = i1;
  return i8 | 0;
 } else if ((i3 | 0) == 0) {
  if ((HEAP32[i6 + 8 >> 2] | 0) == (HEAP32[i4 + 8 >> 2] | 0)) {
   i2 = (_luaV_equalobj_(i2, i6, i4) | 0) != 0;
  } else {
   i2 = 0;
  }
  i8 = i2 & 1;
  STACKTOP = i1;
  return i8 | 0;
 } else {
  i8 = 0;
  STACKTOP = i1;
  return i8 | 0;
 }
 return 0;
}
function _lexerror(i7, i3, i8) {
 i7 = i7 | 0;
 i3 = i3 | 0;
 i8 = i8 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i6 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i12 = STACKTOP;
 STACKTOP = STACKTOP + 80 | 0;
 i2 = i12;
 i12 = i12 + 12 | 0;
 _luaO_chunkid(i12, (HEAP32[i7 + 68 >> 2] | 0) + 16 | 0, 60);
 i1 = i7 + 52 | 0;
 i4 = HEAP32[i1 >> 2] | 0;
 i13 = HEAP32[i7 + 4 >> 2] | 0;
 HEAP32[i2 >> 2] = i12;
 HEAP32[i2 + 4 >> 2] = i13;
 HEAP32[i2 + 8 >> 2] = i3;
 i4 = _luaO_pushfstring(i4, 12592, i2) | 0;
 if ((i8 | 0) == 0) {
  i13 = HEAP32[i1 >> 2] | 0;
  _luaD_throw(i13, 3);
 }
 i3 = HEAP32[i1 >> 2] | 0;
 do {
  if (!((i8 + -287 | 0) >>> 0 < 3)) {
   if ((i8 | 0) >= 257) {
    i5 = HEAP32[12096 + (i8 + -257 << 2) >> 2] | 0;
    if ((i8 | 0) >= 286) {
     break;
    }
    HEAP32[i2 >> 2] = i5;
    i5 = _luaO_pushfstring(i3, 12256, i2) | 0;
    break;
   }
   if ((HEAP8[i8 + 10913 | 0] & 4) == 0) {
    HEAP32[i2 >> 2] = i8;
    i5 = _luaO_pushfstring(i3, 12240, i2) | 0;
    break;
   } else {
    HEAP32[i2 >> 2] = i8;
    i5 = _luaO_pushfstring(i3, 12232, i2) | 0;
    break;
   }
  } else {
   i11 = i7 + 60 | 0;
   i12 = HEAP32[i11 >> 2] | 0;
   i10 = i12 + 4 | 0;
   i13 = HEAP32[i10 >> 2] | 0;
   i8 = i12 + 8 | 0;
   i9 = HEAP32[i8 >> 2] | 0;
   do {
    if ((i13 + 1 | 0) >>> 0 > i9 >>> 0) {
     if (i9 >>> 0 > 2147483645) {
      _lexerror(i7, 12368, 0);
     }
     i7 = i9 << 1;
     if ((i7 | 0) == -2) {
      _luaM_toobig(i3);
     } else {
      i6 = _luaM_realloc_(i3, HEAP32[i12 >> 2] | 0, i9, i7) | 0;
      HEAP32[i12 >> 2] = i6;
      HEAP32[i8 >> 2] = i7;
      i5 = HEAP32[i10 >> 2] | 0;
      break;
     }
    } else {
     i5 = i13;
     i6 = HEAP32[i12 >> 2] | 0;
    }
   } while (0);
   HEAP32[i10 >> 2] = i5 + 1;
   HEAP8[i6 + i5 | 0] = 0;
   i5 = HEAP32[i1 >> 2] | 0;
   HEAP32[i2 >> 2] = HEAP32[HEAP32[i11 >> 2] >> 2];
   i5 = _luaO_pushfstring(i5, 12256, i2) | 0;
  }
 } while (0);
 HEAP32[i2 >> 2] = i4;
 HEAP32[i2 + 4 >> 2] = i5;
 _luaO_pushfstring(i3, 12608, i2) | 0;
 i13 = HEAP32[i1 >> 2] | 0;
 _luaD_throw(i13, 3);
}
function _luaV_objlen(i2, i5, i1) {
 i2 = i2 | 0;
 i5 = i5 | 0;
 i1 = i1 | 0;
 var i3 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0;
 i3 = STACKTOP;
 i4 = i1 + 8 | 0;
 i8 = HEAP32[i4 >> 2] & 15;
 do {
  if ((i8 | 0) == 5) {
   i7 = HEAP32[i1 >> 2] | 0;
   i8 = HEAP32[i7 + 8 >> 2] | 0;
   if (((i8 | 0) != 0 ? (HEAP8[i8 + 6 | 0] & 16) == 0 : 0) ? (i6 = _luaT_gettm(i8, 4, HEAP32[(HEAP32[i2 + 12 >> 2] | 0) + 200 >> 2] | 0) | 0, (i6 | 0) != 0) : 0) {
    i7 = i6;
    break;
   }
   HEAPF64[i5 >> 3] = +(_luaH_getn(i7) | 0);
   HEAP32[i5 + 8 >> 2] = 3;
   STACKTOP = i3;
   return;
  } else if ((i8 | 0) != 4) {
   i6 = _luaT_gettmbyobj(i2, i1, 4) | 0;
   if ((HEAP32[i6 + 8 >> 2] | 0) == 0) {
    _luaG_typeerror(i2, i1, 9024);
   } else {
    i7 = i6;
   }
  } else {
   HEAPF64[i5 >> 3] = +((HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0) >>> 0);
   HEAP32[i5 + 8 >> 2] = 3;
   STACKTOP = i3;
   return;
  }
 } while (0);
 i6 = i2 + 28 | 0;
 i8 = i5 - (HEAP32[i6 >> 2] | 0) | 0;
 i5 = i2 + 8 | 0;
 i11 = HEAP32[i5 >> 2] | 0;
 HEAP32[i5 >> 2] = i11 + 16;
 i12 = i7;
 i10 = HEAP32[i12 + 4 >> 2] | 0;
 i9 = i11;
 HEAP32[i9 >> 2] = HEAP32[i12 >> 2];
 HEAP32[i9 + 4 >> 2] = i10;
 HEAP32[i11 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
 i7 = HEAP32[i5 >> 2] | 0;
 HEAP32[i5 >> 2] = i7 + 16;
 i11 = i1;
 i9 = HEAP32[i11 + 4 >> 2] | 0;
 i10 = i7;
 HEAP32[i10 >> 2] = HEAP32[i11 >> 2];
 HEAP32[i10 + 4 >> 2] = i9;
 HEAP32[i7 + 8 >> 2] = HEAP32[i4 >> 2];
 i7 = HEAP32[i5 >> 2] | 0;
 HEAP32[i5 >> 2] = i7 + 16;
 i10 = i1;
 i9 = HEAP32[i10 + 4 >> 2] | 0;
 i1 = i7;
 HEAP32[i1 >> 2] = HEAP32[i10 >> 2];
 HEAP32[i1 + 4 >> 2] = i9;
 HEAP32[i7 + 8 >> 2] = HEAP32[i4 >> 2];
 _luaD_call(i2, (HEAP32[i5 >> 2] | 0) + -48 | 0, 1, HEAP8[(HEAP32[i2 + 16 >> 2] | 0) + 18 | 0] & 1);
 i7 = HEAP32[i6 >> 2] | 0;
 i6 = HEAP32[i5 >> 2] | 0;
 i2 = i6 + -16 | 0;
 HEAP32[i5 >> 2] = i2;
 i4 = HEAP32[i2 + 4 >> 2] | 0;
 i5 = i7 + i8 | 0;
 HEAP32[i5 >> 2] = HEAP32[i2 >> 2];
 HEAP32[i5 + 4 >> 2] = i4;
 HEAP32[i7 + (i8 + 8) >> 2] = HEAP32[i6 + -8 >> 2];
 STACKTOP = i3;
 return;
}
function _get_equalTM(i6, i5, i4) {
 i6 = i6 | 0;
 i5 = i5 | 0;
 i4 = i4 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i7 = 0;
 i1 = STACKTOP;
 L1 : do {
  if (((i5 | 0) != 0 ? (HEAP8[i5 + 6 | 0] & 32) == 0 : 0) ? (i7 = i6 + 12 | 0, i2 = _luaT_gettm(i5, 5, HEAP32[(HEAP32[i7 >> 2] | 0) + 204 >> 2] | 0) | 0, (i2 | 0) != 0) : 0) {
   if ((i5 | 0) != (i4 | 0)) {
    if (((i4 | 0) != 0 ? (HEAP8[i4 + 6 | 0] & 32) == 0 : 0) ? (i3 = _luaT_gettm(i4, 5, HEAP32[(HEAP32[i7 >> 2] | 0) + 204 >> 2] | 0) | 0, (i3 | 0) != 0) : 0) {
     i4 = HEAP32[i2 + 8 >> 2] | 0;
     L9 : do {
      if ((i4 | 0) == (HEAP32[i3 + 8 >> 2] | 0)) {
       switch (i4 & 63 | 0) {
       case 3:
        {
         i3 = +HEAPF64[i2 >> 3] == +HEAPF64[i3 >> 3] | 0;
         break;
        }
       case 22:
        {
         i3 = (HEAP32[i2 >> 2] | 0) == (HEAP32[i3 >> 2] | 0) | 0;
         break;
        }
       case 5:
        {
         if ((HEAP32[i2 >> 2] | 0) == (HEAP32[i3 >> 2] | 0)) {
          break L1;
         } else {
          break L9;
         }
        }
       case 1:
        {
         i3 = (HEAP32[i2 >> 2] | 0) == (HEAP32[i3 >> 2] | 0) | 0;
         break;
        }
       case 4:
        {
         i3 = (HEAP32[i2 >> 2] | 0) == (HEAP32[i3 >> 2] | 0) | 0;
         break;
        }
       case 0:
        {
         break L1;
        }
       case 7:
        {
         if ((HEAP32[i2 >> 2] | 0) == (HEAP32[i3 >> 2] | 0)) {
          break L1;
         } else {
          break L9;
         }
        }
       case 2:
        {
         i3 = (HEAP32[i2 >> 2] | 0) == (HEAP32[i3 >> 2] | 0) | 0;
         break;
        }
       case 20:
        {
         i3 = _luaS_eqlngstr(HEAP32[i2 >> 2] | 0, HEAP32[i3 >> 2] | 0) | 0;
         break;
        }
       default:
        {
         i3 = (HEAP32[i2 >> 2] | 0) == (HEAP32[i3 >> 2] | 0) | 0;
        }
       }
       if ((i3 | 0) != 0) {
        break L1;
       }
      }
     } while (0);
     i2 = 0;
    } else {
     i2 = 0;
    }
   }
  } else {
   i2 = 0;
  }
 } while (0);
 STACKTOP = i1;
 return i2 | 0;
}
function _luaS_newlstr(i2, i4, i3) {
 i2 = i2 | 0;
 i4 = i4 | 0;
 i3 = i3 | 0;
 var i1 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0;
 i1 = STACKTOP;
 if (!(i3 >>> 0 < 41)) {
  if ((i3 + 1 | 0) >>> 0 > 4294967277) {
   _luaM_toobig(i2);
  }
  i10 = HEAP32[(HEAP32[i2 + 12 >> 2] | 0) + 56 >> 2] | 0;
  i11 = _luaC_newobj(i2, 20, i3 + 17 | 0, 0, 0) | 0;
  HEAP32[i11 + 12 >> 2] = i3;
  HEAP32[i11 + 8 >> 2] = i10;
  HEAP8[i11 + 6 | 0] = 0;
  i10 = i11 + 16 | 0;
  _memcpy(i10 | 0, i4 | 0, i3 | 0) | 0;
  HEAP8[i10 + i3 | 0] = 0;
  STACKTOP = i1;
  return i11 | 0;
 }
 i5 = HEAP32[i2 + 12 >> 2] | 0;
 i6 = HEAP32[i5 + 56 >> 2] ^ i3;
 i7 = (i3 >>> 5) + 1 | 0;
 if (!(i7 >>> 0 > i3 >>> 0)) {
  i8 = i3;
  do {
   i6 = (i6 << 5) + (i6 >>> 2) + (HEAPU8[i4 + (i8 + -1) | 0] | 0) ^ i6;
   i8 = i8 - i7 | 0;
  } while (!(i8 >>> 0 < i7 >>> 0));
 }
 i10 = i5 + 32 | 0;
 i9 = HEAP32[i10 >> 2] | 0;
 i7 = i5 + 24 | 0;
 i8 = HEAP32[i7 >> 2] | 0;
 i11 = HEAP32[i8 + ((i9 + -1 & i6) << 2) >> 2] | 0;
 L12 : do {
  if ((i11 | 0) != 0) {
   while (1) {
    if (((i6 | 0) == (HEAP32[i11 + 8 >> 2] | 0) ? (HEAP32[i11 + 12 >> 2] | 0) == (i3 | 0) : 0) ? (_memcmp(i4, i11 + 16 | 0, i3) | 0) == 0 : 0) {
     break;
    }
    i11 = HEAP32[i11 >> 2] | 0;
    if ((i11 | 0) == 0) {
     break L12;
    }
   }
   i2 = i11 + 5 | 0;
   i3 = (HEAPU8[i2] | 0) ^ 3;
   if ((((HEAPU8[i5 + 60 | 0] | 0) ^ 3) & i3 | 0) != 0) {
    STACKTOP = i1;
    return i11 | 0;
   }
   HEAP8[i2] = i3;
   STACKTOP = i1;
   return i11 | 0;
  }
 } while (0);
 i5 = i5 + 28 | 0;
 if ((HEAP32[i5 >> 2] | 0) >>> 0 >= i9 >>> 0 & (i9 | 0) < 1073741823) {
  _luaS_resize(i2, i9 << 1);
  i9 = HEAP32[i10 >> 2] | 0;
  i8 = HEAP32[i7 >> 2] | 0;
 }
 i11 = _luaC_newobj(i2, 4, i3 + 17 | 0, i8 + ((i9 + -1 & i6) << 2) | 0, 0) | 0;
 HEAP32[i11 + 12 >> 2] = i3;
 HEAP32[i11 + 8 >> 2] = i6;
 HEAP8[i11 + 6 | 0] = 0;
 i10 = i11 + 16 | 0;
 _memcpy(i10 | 0, i4 | 0, i3 | 0) | 0;
 HEAP8[i10 + i3 | 0] = 0;
 HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + 1;
 STACKTOP = i1;
 return i11 | 0;
}
function _lua_pcallk(i3, i7, i2, i9, i6, i5) {
 i3 = i3 | 0;
 i7 = i7 | 0;
 i2 = i2 | 0;
 i9 = i9 | 0;
 i6 = i6 | 0;
 i5 = i5 | 0;
 var i1 = 0, i4 = 0, i8 = 0, i10 = 0, i11 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = i1;
 if ((i9 | 0) == 0) {
  i9 = 0;
 } else {
  i10 = HEAP32[i3 + 16 >> 2] | 0;
  do {
   if ((i9 | 0) <= 0) {
    if (!((i9 | 0) < -1000999)) {
     i8 = (HEAP32[i3 + 8 >> 2] | 0) + (i9 << 4) | 0;
     break;
    }
    if ((i9 | 0) == -1001e3) {
     i8 = (HEAP32[i3 + 12 >> 2] | 0) + 40 | 0;
     break;
    }
    i9 = -1001e3 - i9 | 0;
    i10 = HEAP32[i10 >> 2] | 0;
    if ((HEAP32[i10 + 8 >> 2] | 0) != 22 ? (i8 = HEAP32[i10 >> 2] | 0, (i9 | 0) <= (HEAPU8[i8 + 6 | 0] | 0)) : 0) {
     i8 = i8 + (i9 + -1 << 4) + 16 | 0;
    } else {
     i8 = 5192;
    }
   } else {
    i8 = (HEAP32[i10 >> 2] | 0) + (i9 << 4) | 0;
    i8 = i8 >>> 0 < (HEAP32[i3 + 8 >> 2] | 0) >>> 0 ? i8 : 5192;
   }
  } while (0);
  i9 = i8 - (HEAP32[i3 + 28 >> 2] | 0) | 0;
 }
 i8 = i3 + 8 | 0;
 i7 = (HEAP32[i8 >> 2] | 0) + (~i7 << 4) | 0;
 HEAP32[i4 >> 2] = i7;
 if ((i5 | 0) != 0 ? (HEAP16[i3 + 36 >> 1] | 0) == 0 : 0) {
  i11 = HEAP32[i3 + 16 >> 2] | 0;
  HEAP32[i11 + 28 >> 2] = i5;
  HEAP32[i11 + 24 >> 2] = i6;
  HEAP32[i11 + 20 >> 2] = (HEAP32[i4 >> 2] | 0) - (HEAP32[i3 + 28 >> 2] | 0);
  HEAP8[i11 + 36 | 0] = HEAP8[i3 + 41 | 0] | 0;
  i10 = i3 + 68 | 0;
  i7 = i11 + 32 | 0;
  HEAP32[i7 >> 2] = HEAP32[i10 >> 2];
  HEAP32[i10 >> 2] = i9;
  i9 = i11 + 18 | 0;
  HEAP8[i9] = HEAPU8[i9] | 16;
  _luaD_call(i3, HEAP32[i4 >> 2] | 0, i2, 1);
  HEAP8[i9] = HEAP8[i9] & 239;
  HEAP32[i10 >> 2] = HEAP32[i7 >> 2];
  i4 = 0;
 } else {
  HEAP32[i4 + 4 >> 2] = i2;
  i4 = _luaD_pcall(i3, 3, i4, i7 - (HEAP32[i3 + 28 >> 2] | 0) | 0, i9) | 0;
 }
 if (!((i2 | 0) == -1)) {
  STACKTOP = i1;
  return i4 | 0;
 }
 i2 = (HEAP32[i3 + 16 >> 2] | 0) + 4 | 0;
 i3 = HEAP32[i8 >> 2] | 0;
 if (!((HEAP32[i2 >> 2] | 0) >>> 0 < i3 >>> 0)) {
  STACKTOP = i1;
  return i4 | 0;
 }
 HEAP32[i2 >> 2] = i3;
 STACKTOP = i1;
 return i4 | 0;
}
function _lua_getupvalue(i1, i6, i3) {
 i1 = i1 | 0;
 i6 = i6 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 i5 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i6 | 0) <= 0) {
   if (!((i6 | 0) < -1000999)) {
    i4 = (HEAP32[i1 + 8 >> 2] | 0) + (i6 << 4) | 0;
    break;
   }
   if ((i6 | 0) == -1001e3) {
    i4 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i6 = -1001e3 - i6 | 0;
   i5 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i4 = HEAP32[i5 >> 2] | 0, (i6 | 0) <= (HEAPU8[i4 + 6 | 0] | 0 | 0)) : 0) {
    i4 = i4 + (i6 + -1 << 4) + 16 | 0;
   } else {
    i4 = 5192;
   }
  } else {
   i4 = (HEAP32[i5 >> 2] | 0) + (i6 << 4) | 0;
   i4 = i4 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 i5 = HEAP32[i4 + 8 >> 2] & 63;
 do {
  if ((i5 | 0) == 38) {
   i5 = HEAP32[i4 >> 2] | 0;
   if ((i3 | 0) <= 0) {
    i6 = 0;
    STACKTOP = i2;
    return i6 | 0;
   }
   if ((HEAPU8[i5 + 6 | 0] | 0 | 0) < (i3 | 0)) {
    i6 = 0;
    STACKTOP = i2;
    return i6 | 0;
   } else {
    i4 = 936;
    i3 = i5 + (i3 + -1 << 4) + 16 | 0;
    break;
   }
  } else if ((i5 | 0) == 6) {
   i5 = HEAP32[i4 >> 2] | 0;
   i4 = HEAP32[i5 + 12 >> 2] | 0;
   if ((i3 | 0) <= 0) {
    i6 = 0;
    STACKTOP = i2;
    return i6 | 0;
   }
   if ((HEAP32[i4 + 40 >> 2] | 0) < (i3 | 0)) {
    i6 = 0;
    STACKTOP = i2;
    return i6 | 0;
   }
   i6 = i3 + -1 | 0;
   i3 = HEAP32[(HEAP32[i5 + 16 + (i6 << 2) >> 2] | 0) + 8 >> 2] | 0;
   i4 = HEAP32[(HEAP32[i4 + 28 >> 2] | 0) + (i6 << 3) >> 2] | 0;
   if ((i4 | 0) == 0) {
    i4 = 936;
   } else {
    i4 = i4 + 16 | 0;
   }
  } else {
   i6 = 0;
   STACKTOP = i2;
   return i6 | 0;
  }
 } while (0);
 i6 = i1 + 8 | 0;
 i5 = HEAP32[i6 >> 2] | 0;
 i8 = i3;
 i7 = HEAP32[i8 + 4 >> 2] | 0;
 i1 = i5;
 HEAP32[i1 >> 2] = HEAP32[i8 >> 2];
 HEAP32[i1 + 4 >> 2] = i7;
 HEAP32[i5 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 HEAP32[i6 >> 2] = (HEAP32[i6 >> 2] | 0) + 16;
 i6 = i4;
 STACKTOP = i2;
 return i6 | 0;
}
function _lua_copy(i1, i8, i4) {
 i1 = i1 | 0;
 i8 = i8 | 0;
 i4 = i4 | 0;
 var i2 = 0, i3 = 0, i5 = 0, i6 = 0, i7 = 0, i9 = 0;
 i2 = STACKTOP;
 i3 = i1 + 16 | 0;
 i6 = HEAP32[i3 >> 2] | 0;
 do {
  if ((i8 | 0) <= 0) {
   if (!((i8 | 0) < -1000999)) {
    i7 = (HEAP32[i1 + 8 >> 2] | 0) + (i8 << 4) | 0;
    break;
   }
   if ((i8 | 0) == -1001e3) {
    i7 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i8 = -1001e3 - i8 | 0;
   i9 = HEAP32[i6 >> 2] | 0;
   if ((HEAP32[i9 + 8 >> 2] | 0) != 22 ? (i7 = HEAP32[i9 >> 2] | 0, (i8 | 0) <= (HEAPU8[i7 + 6 | 0] | 0 | 0)) : 0) {
    i7 = i7 + (i8 + -1 << 4) + 16 | 0;
   } else {
    i7 = 5192;
   }
  } else {
   i7 = (HEAP32[i6 >> 2] | 0) + (i8 << 4) | 0;
   i7 = i7 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i7 : 5192;
  }
 } while (0);
 do {
  if ((i4 | 0) <= 0) {
   if (!((i4 | 0) < -1000999)) {
    i5 = (HEAP32[i1 + 8 >> 2] | 0) + (i4 << 4) | 0;
    break;
   }
   if ((i4 | 0) == -1001e3) {
    i5 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i8 = -1001e3 - i4 | 0;
   i6 = HEAP32[i6 >> 2] | 0;
   if ((HEAP32[i6 + 8 >> 2] | 0) != 22 ? (i5 = HEAP32[i6 >> 2] | 0, (i8 | 0) <= (HEAPU8[i5 + 6 | 0] | 0 | 0)) : 0) {
    i5 = i5 + (i8 + -1 << 4) + 16 | 0;
   } else {
    i5 = 5192;
   }
  } else {
   i5 = (HEAP32[i6 >> 2] | 0) + (i4 << 4) | 0;
   i5 = i5 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i5 : 5192;
  }
 } while (0);
 i8 = i7;
 i9 = HEAP32[i8 + 4 >> 2] | 0;
 i6 = i5;
 HEAP32[i6 >> 2] = HEAP32[i8 >> 2];
 HEAP32[i6 + 4 >> 2] = i9;
 i6 = i7 + 8 | 0;
 HEAP32[i5 + 8 >> 2] = HEAP32[i6 >> 2];
 if (!((i4 | 0) < -1001e3)) {
  STACKTOP = i2;
  return;
 }
 if ((HEAP32[i6 >> 2] & 64 | 0) == 0) {
  STACKTOP = i2;
  return;
 }
 i4 = HEAP32[i7 >> 2] | 0;
 if ((HEAP8[i4 + 5 | 0] & 3) == 0) {
  STACKTOP = i2;
  return;
 }
 i3 = HEAP32[HEAP32[HEAP32[i3 >> 2] >> 2] >> 2] | 0;
 if ((HEAP8[i3 + 5 | 0] & 4) == 0) {
  STACKTOP = i2;
  return;
 }
 _luaC_barrier_(i1, i3, i4);
 STACKTOP = i2;
 return;
}
function _lua_tolstring(i4, i5, i1) {
 i4 = i4 | 0;
 i5 = i5 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i2 = STACKTOP;
 i7 = i4 + 16 | 0;
 i10 = HEAP32[i7 >> 2] | 0;
 i6 = (i5 | 0) > 0;
 do {
  if (!i6) {
   if (!((i5 | 0) < -1000999)) {
    i8 = (HEAP32[i4 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i8 = (HEAP32[i4 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i9 = -1001e3 - i5 | 0;
   i10 = HEAP32[i10 >> 2] | 0;
   if ((HEAP32[i10 + 8 >> 2] | 0) != 22 ? (i8 = HEAP32[i10 >> 2] | 0, (i9 | 0) <= (HEAPU8[i8 + 6 | 0] | 0 | 0)) : 0) {
    i8 = i8 + (i9 + -1 << 4) + 16 | 0;
   } else {
    i8 = 5192;
   }
  } else {
   i8 = (HEAP32[i10 >> 2] | 0) + (i5 << 4) | 0;
   i8 = i8 >>> 0 < (HEAP32[i4 + 8 >> 2] | 0) >>> 0 ? i8 : 5192;
  }
 } while (0);
 do {
  if ((HEAP32[i8 + 8 >> 2] & 15 | 0) != 4) {
   if ((_luaV_tostring(i4, i8) | 0) == 0) {
    if ((i1 | 0) == 0) {
     i10 = 0;
     STACKTOP = i2;
     return i10 | 0;
    }
    HEAP32[i1 >> 2] = 0;
    i10 = 0;
    STACKTOP = i2;
    return i10 | 0;
   }
   i8 = i4 + 12 | 0;
   if ((HEAP32[(HEAP32[i8 >> 2] | 0) + 12 >> 2] | 0) > 0) {
    _luaC_step(i4);
   }
   i7 = HEAP32[i7 >> 2] | 0;
   if (i6) {
    i3 = (HEAP32[i7 >> 2] | 0) + (i5 << 4) | 0;
    i8 = i3 >>> 0 < (HEAP32[i4 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
    break;
   }
   if (!((i5 | 0) < -1000999)) {
    i8 = (HEAP32[i4 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i8 = (HEAP32[i8 >> 2] | 0) + 40 | 0;
    break;
   }
   i4 = -1001e3 - i5 | 0;
   i5 = HEAP32[i7 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i5 >> 2] | 0, (i4 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i8 = i3 + (i4 + -1 << 4) + 16 | 0;
   } else {
    i8 = 5192;
   }
  }
 } while (0);
 i3 = HEAP32[i8 >> 2] | 0;
 if ((i1 | 0) != 0) {
  HEAP32[i1 >> 2] = HEAP32[i3 + 12 >> 2];
 }
 i10 = i3 + 16 | 0;
 STACKTOP = i2;
 return i10 | 0;
}
function _luaD_pcall(i3, i6, i5, i13, i14) {
 i3 = i3 | 0;
 i6 = i6 | 0;
 i5 = i5 | 0;
 i13 = i13 | 0;
 i14 = i14 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i15 = 0, i16 = 0, i17 = 0, i18 = 0;
 i1 = STACKTOP;
 i10 = i3 + 16 | 0;
 i11 = HEAP32[i10 >> 2] | 0;
 i12 = i3 + 41 | 0;
 i7 = HEAP8[i12] | 0;
 i9 = i3 + 36 | 0;
 i8 = HEAP16[i9 >> 1] | 0;
 i4 = i3 + 68 | 0;
 i2 = HEAP32[i4 >> 2] | 0;
 HEAP32[i4 >> 2] = i14;
 i5 = _luaD_rawrunprotected(i3, i6, i5) | 0;
 if ((i5 | 0) == 0) {
  HEAP32[i4 >> 2] = i2;
  STACKTOP = i1;
  return i5 | 0;
 }
 i6 = i3 + 28 | 0;
 i14 = HEAP32[i6 >> 2] | 0;
 i15 = i14 + i13 | 0;
 _luaF_close(i3, i15);
 if ((i5 | 0) == 6) {
  i16 = _luaS_newlstr(i3, 2424, 23) | 0;
  HEAP32[i15 >> 2] = i16;
  HEAP32[i14 + (i13 + 8) >> 2] = HEAPU8[i16 + 4 | 0] | 0 | 64;
 } else if ((i5 | 0) == 4) {
  i16 = HEAP32[(HEAP32[i3 + 12 >> 2] | 0) + 180 >> 2] | 0;
  HEAP32[i15 >> 2] = i16;
  HEAP32[i14 + (i13 + 8) >> 2] = HEAPU8[i16 + 4 | 0] | 0 | 64;
 } else {
  i16 = HEAP32[i3 + 8 >> 2] | 0;
  i18 = i16 + -16 | 0;
  i17 = HEAP32[i18 + 4 >> 2] | 0;
  HEAP32[i15 >> 2] = HEAP32[i18 >> 2];
  HEAP32[i15 + 4 >> 2] = i17;
  HEAP32[i14 + (i13 + 8) >> 2] = HEAP32[i16 + -8 >> 2];
 }
 i13 = i14 + (i13 + 16) | 0;
 HEAP32[i3 + 8 >> 2] = i13;
 HEAP32[i10 >> 2] = i11;
 HEAP8[i12] = i7;
 HEAP16[i9 >> 1] = i8;
 if ((i11 | 0) != 0) {
  do {
   i7 = HEAP32[i11 + 4 >> 2] | 0;
   i13 = i13 >>> 0 < i7 >>> 0 ? i7 : i13;
   i11 = HEAP32[i11 + 8 >> 2] | 0;
  } while ((i11 | 0) != 0);
 }
 i6 = i13 - (HEAP32[i6 >> 2] | 0) | 0;
 i7 = (i6 >> 4) + 1 | 0;
 i7 = ((i7 | 0) / 8 | 0) + 10 + i7 | 0;
 i7 = (i7 | 0) > 1e6 ? 1e6 : i7;
 if ((i6 | 0) > 15999984) {
  HEAP32[i4 >> 2] = i2;
  STACKTOP = i1;
  return i5 | 0;
 }
 if ((i7 | 0) >= (HEAP32[i3 + 32 >> 2] | 0)) {
  HEAP32[i4 >> 2] = i2;
  STACKTOP = i1;
  return i5 | 0;
 }
 _luaD_reallocstack(i3, i7);
 HEAP32[i4 >> 2] = i2;
 STACKTOP = i1;
 return i5 | 0;
}
function _luaH_resize(i1, i4, i6, i9) {
 i1 = i1 | 0;
 i4 = i4 | 0;
 i6 = i6 | 0;
 i9 = i9 | 0;
 var i2 = 0, i3 = 0, i5 = 0, i7 = 0, i8 = 0, i10 = 0, i11 = 0;
 i3 = STACKTOP;
 i8 = i4 + 28 | 0;
 i5 = HEAP32[i8 >> 2] | 0;
 i7 = HEAPU8[i4 + 7 | 0] | 0;
 i2 = HEAP32[i4 + 16 >> 2] | 0;
 if ((i5 | 0) < (i6 | 0)) {
  if ((i6 + 1 | 0) >>> 0 > 268435455) {
   _luaM_toobig(i1);
  }
  i11 = i4 + 12 | 0;
  i10 = _luaM_realloc_(i1, HEAP32[i11 >> 2] | 0, i5 << 4, i6 << 4) | 0;
  HEAP32[i11 >> 2] = i10;
  i11 = HEAP32[i8 >> 2] | 0;
  if ((i11 | 0) < (i6 | 0)) {
   do {
    HEAP32[i10 + (i11 << 4) + 8 >> 2] = 0;
    i11 = i11 + 1 | 0;
   } while ((i11 | 0) != (i6 | 0));
  }
  HEAP32[i8 >> 2] = i6;
 }
 _setnodevector(i1, i4, i9);
 do {
  if ((i5 | 0) > (i6 | 0)) {
   HEAP32[i8 >> 2] = i6;
   i8 = i4 + 12 | 0;
   i9 = i6;
   do {
    i10 = HEAP32[i8 >> 2] | 0;
    if ((HEAP32[i10 + (i9 << 4) + 8 >> 2] | 0) == 0) {
     i9 = i9 + 1 | 0;
    } else {
     i11 = i9 + 1 | 0;
     _luaH_setint(i1, i4, i11, i10 + (i9 << 4) | 0);
     i9 = i11;
    }
   } while ((i9 | 0) != (i5 | 0));
   if ((i6 + 1 | 0) >>> 0 > 268435455) {
    _luaM_toobig(i1);
   } else {
    i11 = i4 + 12 | 0;
    HEAP32[i11 >> 2] = _luaM_realloc_(i1, HEAP32[i11 >> 2] | 0, i5 << 4, i6 << 4) | 0;
    break;
   }
  }
 } while (0);
 i5 = 1 << i7;
 if ((i5 | 0) > 0) {
  i6 = i5;
  do {
   i6 = i6 + -1 | 0;
   i7 = i2 + (i6 << 5) + 8 | 0;
   if ((HEAP32[i7 >> 2] | 0) != 0) {
    i8 = i2 + (i6 << 5) + 16 | 0;
    i9 = _luaH_get(i4, i8) | 0;
    if ((i9 | 0) == 5192) {
     i9 = _luaH_newkey(i1, i4, i8) | 0;
    }
    i8 = i2 + (i6 << 5) | 0;
    i10 = HEAP32[i8 + 4 >> 2] | 0;
    i11 = i9;
    HEAP32[i11 >> 2] = HEAP32[i8 >> 2];
    HEAP32[i11 + 4 >> 2] = i10;
    HEAP32[i9 + 8 >> 2] = HEAP32[i7 >> 2];
   }
  } while ((i6 | 0) > 0);
 }
 if ((i2 | 0) == 8016) {
  STACKTOP = i3;
  return;
 }
 _luaM_realloc_(i1, i2, i5 << 5, 0) | 0;
 STACKTOP = i3;
 return;
}
function _codearith(i4, i3, i2, i6, i5) {
 i4 = i4 | 0;
 i3 = i3 | 0;
 i2 = i2 | 0;
 i6 = i6 | 0;
 i5 = i5 | 0;
 var i1 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, d13 = 0.0;
 i7 = STACKTOP;
 if (((((((HEAP32[i2 >> 2] | 0) == 5 ? (HEAP32[i2 + 16 >> 2] | 0) == -1 : 0) ? (HEAP32[i2 + 20 >> 2] | 0) == -1 : 0) ? (HEAP32[i6 >> 2] | 0) == 5 : 0) ? (HEAP32[i6 + 16 >> 2] | 0) == -1 : 0) ? (HEAP32[i6 + 20 >> 2] | 0) == -1 : 0) ? (d13 = +HEAPF64[i6 + 8 >> 3], !((i3 & -2 | 0) == 16 & d13 == 0.0)) : 0) {
  i12 = i2 + 8 | 0;
  HEAPF64[i12 >> 3] = +_luaO_arith(i3 + -13 | 0, +HEAPF64[i12 >> 3], d13);
  STACKTOP = i7;
  return;
 }
 if ((i3 | 0) == 19 | (i3 | 0) == 21) {
  i11 = 0;
 } else {
  i11 = _luaK_exp2RK(i4, i6) | 0;
 }
 i12 = _luaK_exp2RK(i4, i2) | 0;
 if ((i12 | 0) > (i11 | 0)) {
  if (((HEAP32[i2 >> 2] | 0) == 6 ? (i8 = HEAP32[i2 + 8 >> 2] | 0, (i8 & 256 | 0) == 0) : 0) ? (HEAPU8[i4 + 46 | 0] | 0 | 0) <= (i8 | 0) : 0) {
   i10 = i4 + 48 | 0;
   HEAP8[i10] = (HEAP8[i10] | 0) + -1 << 24 >> 24;
  }
  if (((HEAP32[i6 >> 2] | 0) == 6 ? (i1 = HEAP32[i6 + 8 >> 2] | 0, (i1 & 256 | 0) == 0) : 0) ? (HEAPU8[i4 + 46 | 0] | 0 | 0) <= (i1 | 0) : 0) {
   i10 = i4 + 48 | 0;
   HEAP8[i10] = (HEAP8[i10] | 0) + -1 << 24 >> 24;
  }
 } else {
  if (((HEAP32[i6 >> 2] | 0) == 6 ? (i10 = HEAP32[i6 + 8 >> 2] | 0, (i10 & 256 | 0) == 0) : 0) ? (HEAPU8[i4 + 46 | 0] | 0 | 0) <= (i10 | 0) : 0) {
   i10 = i4 + 48 | 0;
   HEAP8[i10] = (HEAP8[i10] | 0) + -1 << 24 >> 24;
  }
  if (((HEAP32[i2 >> 2] | 0) == 6 ? (i9 = HEAP32[i2 + 8 >> 2] | 0, (i9 & 256 | 0) == 0) : 0) ? (HEAPU8[i4 + 46 | 0] | 0 | 0) <= (i9 | 0) : 0) {
   i10 = i4 + 48 | 0;
   HEAP8[i10] = (HEAP8[i10] | 0) + -1 << 24 >> 24;
  }
 }
 HEAP32[i2 + 8 >> 2] = _luaK_code(i4, i11 << 14 | i3 | i12 << 23) | 0;
 HEAP32[i2 >> 2] = 11;
 HEAP32[(HEAP32[(HEAP32[i4 >> 2] | 0) + 20 >> 2] | 0) + ((HEAP32[i4 + 20 >> 2] | 0) + -1 << 2) >> 2] = i5;
 STACKTOP = i7;
 return;
}
function _GCTM(i1, i3) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0, i16 = 0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i2 = i4 + 16 | 0;
 i5 = i4;
 i6 = HEAP32[i1 + 12 >> 2] | 0;
 i9 = i6 + 104 | 0;
 i8 = HEAP32[i9 >> 2] | 0;
 HEAP32[i9 >> 2] = HEAP32[i8 >> 2];
 i9 = i6 + 68 | 0;
 HEAP32[i8 >> 2] = HEAP32[i9 >> 2];
 HEAP32[i9 >> 2] = i8;
 i9 = i8 + 5 | 0;
 i7 = HEAPU8[i9] | 0;
 HEAP8[i9] = i7 & 239;
 if ((HEAPU8[i6 + 61 | 0] | 0) >= 2) {
  HEAP8[i9] = HEAP8[i6 + 60 | 0] & 3 | i7 & 168;
 }
 HEAP32[i5 >> 2] = i8;
 i7 = i5 + 8 | 0;
 HEAP32[i7 >> 2] = HEAPU8[i8 + 4 | 0] | 0 | 64;
 i8 = _luaT_gettmbyobj(i1, i5, 2) | 0;
 if ((i8 | 0) == 0) {
  STACKTOP = i4;
  return;
 }
 i9 = i8 + 8 | 0;
 if ((HEAP32[i9 >> 2] & 15 | 0) != 6) {
  STACKTOP = i4;
  return;
 }
 i12 = i1 + 41 | 0;
 i13 = HEAP8[i12] | 0;
 i10 = i6 + 63 | 0;
 i11 = HEAP8[i10] | 0;
 HEAP8[i12] = 0;
 HEAP8[i10] = 0;
 i6 = i1 + 8 | 0;
 i14 = HEAP32[i6 >> 2] | 0;
 i16 = i8;
 i15 = HEAP32[i16 + 4 >> 2] | 0;
 i8 = i14;
 HEAP32[i8 >> 2] = HEAP32[i16 >> 2];
 HEAP32[i8 + 4 >> 2] = i15;
 HEAP32[i14 + 8 >> 2] = HEAP32[i9 >> 2];
 i9 = HEAP32[i6 >> 2] | 0;
 i14 = i5;
 i8 = HEAP32[i14 + 4 >> 2] | 0;
 i5 = i9 + 16 | 0;
 HEAP32[i5 >> 2] = HEAP32[i14 >> 2];
 HEAP32[i5 + 4 >> 2] = i8;
 HEAP32[i9 + 24 >> 2] = HEAP32[i7 >> 2];
 i5 = HEAP32[i6 >> 2] | 0;
 HEAP32[i6 >> 2] = i5 + 32;
 i5 = _luaD_pcall(i1, 7, 0, i5 - (HEAP32[i1 + 28 >> 2] | 0) | 0, 0) | 0;
 HEAP8[i12] = i13;
 HEAP8[i10] = i11;
 if ((i5 | 0) == 0 | (i3 | 0) == 0) {
  STACKTOP = i4;
  return;
 }
 if ((i5 | 0) != 2) {
  i16 = i5;
  _luaD_throw(i1, i16);
 }
 i3 = HEAP32[i6 >> 2] | 0;
 if ((HEAP32[i3 + -8 >> 2] & 15 | 0) == 4) {
  i3 = (HEAP32[i3 + -16 >> 2] | 0) + 16 | 0;
 } else {
  i3 = 2528;
 }
 HEAP32[i2 >> 2] = i3;
 _luaO_pushfstring(i1, 2544, i2) | 0;
 i16 = 5;
 _luaD_throw(i1, i16);
}
function _lua_gc(i3, i5, i4) {
 i3 = i3 | 0;
 i5 = i5 | 0;
 i4 = i4 | 0;
 var i1 = 0, i2 = 0;
 i1 = STACKTOP;
 i2 = HEAP32[i3 + 12 >> 2] | 0;
 L1 : do {
  switch (i5 | 0) {
  case 8:
   {
    i5 = i2 + 160 | 0;
    i2 = HEAP32[i5 >> 2] | 0;
    HEAP32[i5 >> 2] = i4;
    break;
   }
  case 11:
   {
    _luaC_changemode(i3, 0);
    i2 = 0;
    break;
   }
  case 2:
   {
    _luaC_fullgc(i3, 0);
    i2 = 0;
    break;
   }
  case 5:
   {
    if ((HEAP8[i2 + 62 | 0] | 0) == 2) {
     i2 = (HEAP32[i2 + 20 >> 2] | 0) == 0 | 0;
     _luaC_forcestep(i3);
     break L1;
    }
    i4 = (i4 << 10) + -1600 | 0;
    if ((HEAP8[i2 + 63 | 0] | 0) == 0) {
     i5 = i4;
     _luaE_setdebt(i2, i5);
     _luaC_forcestep(i3);
     i5 = i2 + 61 | 0;
     i5 = HEAP8[i5] | 0;
     i5 = i5 << 24 >> 24 == 5;
     i5 = i5 & 1;
     STACKTOP = i1;
     return i5 | 0;
    }
    i5 = (HEAP32[i2 + 12 >> 2] | 0) + i4 | 0;
    _luaE_setdebt(i2, i5);
    _luaC_forcestep(i3);
    i5 = i2 + 61 | 0;
    i5 = HEAP8[i5] | 0;
    i5 = i5 << 24 >> 24 == 5;
    i5 = i5 & 1;
    STACKTOP = i1;
    return i5 | 0;
   }
  case 4:
   {
    i2 = (HEAP32[i2 + 12 >> 2] | 0) + (HEAP32[i2 + 8 >> 2] | 0) & 1023;
    break;
   }
  case 1:
   {
    _luaE_setdebt(i2, 0);
    HEAP8[i2 + 63 | 0] = 1;
    i2 = 0;
    break;
   }
  case 3:
   {
    i2 = ((HEAP32[i2 + 12 >> 2] | 0) + (HEAP32[i2 + 8 >> 2] | 0) | 0) >>> 10;
    break;
   }
  case 7:
   {
    i5 = i2 + 164 | 0;
    i2 = HEAP32[i5 >> 2] | 0;
    HEAP32[i5 >> 2] = i4;
    break;
   }
  case 0:
   {
    HEAP8[i2 + 63 | 0] = 0;
    i2 = 0;
    break;
   }
  case 6:
   {
    i5 = i2 + 156 | 0;
    i2 = HEAP32[i5 >> 2] | 0;
    HEAP32[i5 >> 2] = i4;
    break;
   }
  case 9:
   {
    i2 = HEAPU8[i2 + 63 | 0] | 0;
    break;
   }
  case 10:
   {
    _luaC_changemode(i3, 2);
    i2 = 0;
    break;
   }
  default:
   {
    i2 = -1;
   }
  }
 } while (0);
 STACKTOP = i1;
 return i2 | 0;
}
function _os_time(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i4 = i2;
 i5 = i2 + 48 | 0;
 i3 = i2 + 4 | 0;
 if ((_lua_type(i1, 1) | 0) < 1) {
  i3 = _time(0) | 0;
 } else {
  _luaL_checktype(i1, 1, 5);
  _lua_settop(i1, 1);
  _lua_getfield(i1, -1, 5864);
  i6 = _lua_tointegerx(i1, -1, i4) | 0;
  i6 = (HEAP32[i4 >> 2] | 0) == 0 ? 0 : i6;
  _lua_settop(i1, -2);
  HEAP32[i3 >> 2] = i6;
  _lua_getfield(i1, -1, 5872);
  i6 = _lua_tointegerx(i1, -1, i4) | 0;
  i6 = (HEAP32[i4 >> 2] | 0) == 0 ? 0 : i6;
  _lua_settop(i1, -2);
  HEAP32[i3 + 4 >> 2] = i6;
  _lua_getfield(i1, -1, 5880);
  i6 = _lua_tointegerx(i1, -1, i4) | 0;
  i6 = (HEAP32[i4 >> 2] | 0) == 0 ? 12 : i6;
  _lua_settop(i1, -2);
  HEAP32[i3 + 8 >> 2] = i6;
  _lua_getfield(i1, -1, 5888);
  i6 = _lua_tointegerx(i1, -1, i5) | 0;
  if ((HEAP32[i5 >> 2] | 0) == 0) {
   HEAP32[i4 >> 2] = 5888;
   i6 = _luaL_error(i1, 5920, i4) | 0;
  } else {
   _lua_settop(i1, -2);
  }
  HEAP32[i3 + 12 >> 2] = i6;
  _lua_getfield(i1, -1, 5896);
  i6 = _lua_tointegerx(i1, -1, i5) | 0;
  if ((HEAP32[i5 >> 2] | 0) == 0) {
   HEAP32[i4 >> 2] = 5896;
   i6 = _luaL_error(i1, 5920, i4) | 0;
  } else {
   _lua_settop(i1, -2);
  }
  HEAP32[i3 + 16 >> 2] = i6 + -1;
  _lua_getfield(i1, -1, 5904);
  i6 = _lua_tointegerx(i1, -1, i5) | 0;
  if ((HEAP32[i5 >> 2] | 0) == 0) {
   HEAP32[i4 >> 2] = 5904;
   i6 = _luaL_error(i1, 5920, i4) | 0;
  } else {
   _lua_settop(i1, -2);
  }
  HEAP32[i3 + 20 >> 2] = i6 + -1900;
  _lua_getfield(i1, -1, 5912);
  if ((_lua_type(i1, -1) | 0) == 0) {
   i4 = -1;
  } else {
   i4 = _lua_toboolean(i1, -1) | 0;
  }
  _lua_settop(i1, -2);
  HEAP32[i3 + 32 >> 2] = i4;
  i3 = _mktime(i3 | 0) | 0;
 }
 if ((i3 | 0) == -1) {
  _lua_pushnil(i1);
  STACKTOP = i2;
  return 1;
 } else {
  _lua_pushnumber(i1, +(i3 | 0));
  STACKTOP = i2;
  return 1;
 }
 return 0;
}
function _addk(i6, i4, i3) {
 i6 = i6 | 0;
 i4 = i4 | 0;
 i3 = i3 | 0;
 var i1 = 0, i2 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i10 = i1;
 i2 = HEAP32[(HEAP32[i6 + 12 >> 2] | 0) + 52 >> 2] | 0;
 i8 = _luaH_set(i2, HEAP32[i6 + 4 >> 2] | 0, i4) | 0;
 i4 = HEAP32[i6 >> 2] | 0;
 i9 = i8 + 8 | 0;
 if (((HEAP32[i9 >> 2] | 0) == 3 ? (HEAPF64[i10 >> 3] = +HEAPF64[i8 >> 3] + 6755399441055744.0, i7 = HEAP32[i10 >> 2] | 0, i5 = HEAP32[i4 + 8 >> 2] | 0, (HEAP32[i5 + (i7 << 4) + 8 >> 2] | 0) == (HEAP32[i3 + 8 >> 2] | 0)) : 0) ? (_luaV_equalobj_(0, i5 + (i7 << 4) | 0, i3) | 0) != 0 : 0) {
  i10 = i7;
  STACKTOP = i1;
  return i10 | 0;
 }
 i5 = i4 + 44 | 0;
 i10 = HEAP32[i5 >> 2] | 0;
 i7 = i6 + 32 | 0;
 i6 = HEAP32[i7 >> 2] | 0;
 HEAPF64[i8 >> 3] = +(i6 | 0);
 HEAP32[i9 >> 2] = 3;
 i9 = HEAP32[i5 >> 2] | 0;
 if ((i6 | 0) >= (i9 | 0)) {
  i9 = i4 + 8 | 0;
  HEAP32[i9 >> 2] = _luaM_growaux_(i2, HEAP32[i9 >> 2] | 0, i5, 16, 67108863, 10600) | 0;
  i9 = HEAP32[i5 >> 2] | 0;
 }
 i8 = HEAP32[i4 + 8 >> 2] | 0;
 if ((i10 | 0) < (i9 | 0)) {
  while (1) {
   i9 = i10 + 1 | 0;
   HEAP32[i8 + (i10 << 4) + 8 >> 2] = 0;
   if ((i9 | 0) < (HEAP32[i5 >> 2] | 0)) {
    i10 = i9;
   } else {
    break;
   }
  }
 }
 i5 = i3;
 i9 = HEAP32[i5 + 4 >> 2] | 0;
 i10 = i8 + (i6 << 4) | 0;
 HEAP32[i10 >> 2] = HEAP32[i5 >> 2];
 HEAP32[i10 + 4 >> 2] = i9;
 i10 = i3 + 8 | 0;
 HEAP32[i8 + (i6 << 4) + 8 >> 2] = HEAP32[i10 >> 2];
 HEAP32[i7 >> 2] = (HEAP32[i7 >> 2] | 0) + 1;
 if ((HEAP32[i10 >> 2] & 64 | 0) == 0) {
  i10 = i6;
  STACKTOP = i1;
  return i10 | 0;
 }
 i3 = HEAP32[i3 >> 2] | 0;
 if ((HEAP8[i3 + 5 | 0] & 3) == 0) {
  i10 = i6;
  STACKTOP = i1;
  return i10 | 0;
 }
 if ((HEAP8[i4 + 5 | 0] & 4) == 0) {
  i10 = i6;
  STACKTOP = i1;
  return i10 | 0;
 }
 _luaC_barrier_(i2, i4, i3);
 i10 = i6;
 STACKTOP = i1;
 return i10 | 0;
}
function _singlevaraux(i5, i4, i2, i11) {
 i5 = i5 | 0;
 i4 = i4 | 0;
 i2 = i2 | 0;
 i11 = i11 | 0;
 var i1 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i1 = STACKTOP;
 if ((i5 | 0) == 0) {
  i11 = 0;
  STACKTOP = i1;
  return i11 | 0;
 }
 i7 = i5 + 12 | 0;
 i8 = i5 + 40 | 0;
 i9 = HEAPU8[i5 + 46 | 0] | 0;
 while (1) {
  i6 = i9 + -1 | 0;
  i10 = HEAP32[i5 >> 2] | 0;
  if ((i9 | 0) <= 0) {
   break;
  }
  if ((_luaS_eqstr(i4, HEAP32[(HEAP32[i10 + 24 >> 2] | 0) + ((HEAP16[(HEAP32[HEAP32[(HEAP32[i7 >> 2] | 0) + 64 >> 2] >> 2] | 0) + ((HEAP32[i8 >> 2] | 0) + i6 << 1) >> 1] | 0) * 12 | 0) >> 2] | 0) | 0) == 0) {
   i9 = i6;
  } else {
   i3 = 5;
   break;
  }
 }
 if ((i3 | 0) == 5) {
  HEAP32[i2 + 16 >> 2] = -1;
  HEAP32[i2 + 20 >> 2] = -1;
  HEAP32[i2 >> 2] = 7;
  HEAP32[i2 + 8 >> 2] = i6;
  if ((i11 | 0) != 0) {
   i11 = 7;
   STACKTOP = i1;
   return i11 | 0;
  }
  i2 = i5 + 16 | 0;
  do {
   i2 = HEAP32[i2 >> 2] | 0;
  } while ((HEAPU8[i2 + 8 | 0] | 0) > (i6 | 0));
  HEAP8[i2 + 9 | 0] = 1;
  i11 = 7;
  STACKTOP = i1;
  return i11 | 0;
 }
 i7 = HEAP32[i10 + 28 >> 2] | 0;
 i6 = i5 + 47 | 0;
 L17 : do {
  if ((HEAP8[i6] | 0) != 0) {
   i8 = 0;
   while (1) {
    i9 = i8 + 1 | 0;
    if ((_luaS_eqstr(HEAP32[i7 + (i8 << 3) >> 2] | 0, i4) | 0) != 0) {
     break;
    }
    if ((i9 | 0) < (HEAPU8[i6] | 0)) {
     i8 = i9;
    } else {
     i3 = 13;
     break L17;
    }
   }
   if ((i8 | 0) < 0) {
    i3 = 13;
   }
  } else {
   i3 = 13;
  }
 } while (0);
 do {
  if ((i3 | 0) == 13) {
   if ((_singlevaraux(HEAP32[i5 + 8 >> 2] | 0, i4, i2, 0) | 0) == 0) {
    i11 = 0;
    STACKTOP = i1;
    return i11 | 0;
   } else {
    i8 = _newupvalue(i5, i4, i2) | 0;
    break;
   }
  }
 } while (0);
 HEAP32[i2 + 16 >> 2] = -1;
 HEAP32[i2 + 20 >> 2] = -1;
 HEAP32[i2 >> 2] = 8;
 HEAP32[i2 + 8 >> 2] = i8;
 i11 = 8;
 STACKTOP = i1;
 return i11 | 0;
}
function _mainposition(i1, i3) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = i2;
 switch (HEAP32[i3 + 8 >> 2] & 63 | 0) {
 case 3:
  {
   HEAPF64[i4 >> 3] = +HEAPF64[i3 >> 3] + 1.0;
   i3 = (HEAP32[i4 + 4 >> 2] | 0) + (HEAP32[i4 >> 2] | 0) | 0;
   if ((i3 | 0) < 0) {
    i4 = 0 - i3 | 0;
    i3 = (i3 | 0) == (i4 | 0) ? 0 : i4;
   }
   i5 = (HEAP32[i1 + 16 >> 2] | 0) + (((i3 | 0) % ((1 << HEAPU8[i1 + 7 | 0]) + -1 | 1 | 0) | 0) << 5) | 0;
   STACKTOP = i2;
   return i5 | 0;
  }
 case 2:
  {
   i5 = (HEAP32[i1 + 16 >> 2] | 0) + ((((HEAP32[i3 >> 2] | 0) >>> 0) % (((1 << HEAPU8[i1 + 7 | 0]) + -1 | 1) >>> 0) | 0) << 5) | 0;
   STACKTOP = i2;
   return i5 | 0;
  }
 case 20:
  {
   i5 = HEAP32[i3 >> 2] | 0;
   i4 = i5 + 6 | 0;
   if ((HEAP8[i4] | 0) == 0) {
    i6 = i5 + 8 | 0;
    HEAP32[i6 >> 2] = _luaS_hash(i5 + 16 | 0, HEAP32[i5 + 12 >> 2] | 0, HEAP32[i6 >> 2] | 0) | 0;
    HEAP8[i4] = 1;
    i5 = HEAP32[i3 >> 2] | 0;
   }
   i6 = (HEAP32[i1 + 16 >> 2] | 0) + (((1 << HEAPU8[i1 + 7 | 0]) + -1 & HEAP32[i5 + 8 >> 2]) << 5) | 0;
   STACKTOP = i2;
   return i6 | 0;
  }
 case 22:
  {
   i6 = (HEAP32[i1 + 16 >> 2] | 0) + ((((HEAP32[i3 >> 2] | 0) >>> 0) % (((1 << HEAPU8[i1 + 7 | 0]) + -1 | 1) >>> 0) | 0) << 5) | 0;
   STACKTOP = i2;
   return i6 | 0;
  }
 case 4:
  {
   i6 = (HEAP32[i1 + 16 >> 2] | 0) + (((1 << HEAPU8[i1 + 7 | 0]) + -1 & HEAP32[(HEAP32[i3 >> 2] | 0) + 8 >> 2]) << 5) | 0;
   STACKTOP = i2;
   return i6 | 0;
  }
 case 1:
  {
   i6 = (HEAP32[i1 + 16 >> 2] | 0) + (((1 << HEAPU8[i1 + 7 | 0]) + -1 & HEAP32[i3 >> 2]) << 5) | 0;
   STACKTOP = i2;
   return i6 | 0;
  }
 default:
  {
   i6 = (HEAP32[i1 + 16 >> 2] | 0) + ((((HEAP32[i3 >> 2] | 0) >>> 0) % (((1 << HEAPU8[i1 + 7 | 0]) + -1 | 1) >>> 0) | 0) << 5) | 0;
   STACKTOP = i2;
   return i6 | 0;
  }
 }
 return 0;
}
function _clearvalues(i2, i5, i1) {
 i2 = i2 | 0;
 i5 = i5 | 0;
 i1 = i1 | 0;
 var i3 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i4 = STACKTOP;
 if ((i5 | 0) == (i1 | 0)) {
  STACKTOP = i4;
  return;
 }
 do {
  i7 = i5 + 16 | 0;
  i9 = HEAP32[i7 >> 2] | 0;
  i6 = i9 + (1 << (HEAPU8[i5 + 7 | 0] | 0) << 5) | 0;
  i8 = i5 + 28 | 0;
  if ((HEAP32[i8 >> 2] | 0) > 0) {
   i11 = i5 + 12 | 0;
   i12 = 0;
   do {
    i13 = HEAP32[i11 >> 2] | 0;
    i10 = i13 + (i12 << 4) + 8 | 0;
    i9 = HEAP32[i10 >> 2] | 0;
    do {
     if ((i9 & 64 | 0) != 0) {
      i13 = HEAP32[i13 + (i12 << 4) >> 2] | 0;
      if ((i9 & 15 | 0) != 4) {
       if ((HEAP8[i13 + 5 | 0] & 3) == 0) {
        break;
       }
       HEAP32[i10 >> 2] = 0;
       break;
      }
      if ((i13 | 0) != 0 ? !((HEAP8[i13 + 5 | 0] & 3) == 0) : 0) {
       _reallymarkobject(i2, i13);
      }
     }
    } while (0);
    i12 = i12 + 1 | 0;
   } while ((i12 | 0) < (HEAP32[i8 >> 2] | 0));
   i7 = HEAP32[i7 >> 2] | 0;
  } else {
   i7 = i9;
  }
  if (i7 >>> 0 < i6 >>> 0) {
   do {
    i8 = i7 + 8 | 0;
    i9 = HEAP32[i8 >> 2] | 0;
    do {
     if (!((i9 | 0) == 0 | (i9 & 64 | 0) == 0)) {
      i10 = HEAP32[i7 >> 2] | 0;
      if ((i9 & 15 | 0) == 4) {
       if ((i10 | 0) == 0) {
        break;
       }
       if ((HEAP8[i10 + 5 | 0] & 3) == 0) {
        break;
       }
       _reallymarkobject(i2, i10);
       break;
      }
      if ((!((HEAP8[i10 + 5 | 0] & 3) == 0) ? (HEAP32[i8 >> 2] = 0, i3 = i7 + 24 | 0, (HEAP32[i3 >> 2] & 64 | 0) != 0) : 0) ? !((HEAP8[(HEAP32[i7 + 16 >> 2] | 0) + 5 | 0] & 3) == 0) : 0) {
       HEAP32[i3 >> 2] = 11;
      }
     }
    } while (0);
    i7 = i7 + 32 | 0;
   } while (i7 >>> 0 < i6 >>> 0);
  }
  i5 = HEAP32[i5 + 24 >> 2] | 0;
 } while ((i5 | 0) != (i1 | 0));
 STACKTOP = i4;
 return;
}
function _reallymarkobject(i1, i4) {
 i1 = i1 | 0;
 i4 = i4 | 0;
 var i2 = 0, i3 = 0, i5 = 0, i6 = 0, i7 = 0;
 i3 = STACKTOP;
 i2 = i4 + 5 | 0;
 HEAP8[i2] = HEAP8[i2] & 252;
 switch (HEAPU8[i4 + 4 | 0] | 0 | 0) {
 case 6:
  {
   i7 = i1 + 84 | 0;
   HEAP32[i4 + 8 >> 2] = HEAP32[i7 >> 2];
   HEAP32[i7 >> 2] = i4;
   STACKTOP = i3;
   return;
  }
 case 20:
 case 4:
  {
   i4 = (HEAP32[i4 + 12 >> 2] | 0) + 17 | 0;
   break;
  }
 case 7:
  {
   i5 = HEAP32[i4 + 8 >> 2] | 0;
   if ((i5 | 0) != 0 ? !((HEAP8[i5 + 5 | 0] & 3) == 0) : 0) {
    _reallymarkobject(i1, i5);
   }
   i5 = HEAP32[i4 + 12 >> 2] | 0;
   if ((i5 | 0) != 0 ? !((HEAP8[i5 + 5 | 0] & 3) == 0) : 0) {
    _reallymarkobject(i1, i5);
   }
   i4 = (HEAP32[i4 + 16 >> 2] | 0) + 24 | 0;
   break;
  }
 case 8:
  {
   i7 = i1 + 84 | 0;
   HEAP32[i4 + 60 >> 2] = HEAP32[i7 >> 2];
   HEAP32[i7 >> 2] = i4;
   STACKTOP = i3;
   return;
  }
 case 10:
  {
   i6 = i4 + 8 | 0;
   i7 = HEAP32[i6 >> 2] | 0;
   if ((HEAP32[i7 + 8 >> 2] & 64 | 0) != 0 ? (i5 = HEAP32[i7 >> 2] | 0, !((HEAP8[i5 + 5 | 0] & 3) == 0)) : 0) {
    _reallymarkobject(i1, i5);
    i7 = HEAP32[i6 >> 2] | 0;
   }
   if ((i7 | 0) == (i4 + 16 | 0)) {
    i4 = 32;
   } else {
    STACKTOP = i3;
    return;
   }
   break;
  }
 case 5:
  {
   i7 = i1 + 84 | 0;
   HEAP32[i4 + 24 >> 2] = HEAP32[i7 >> 2];
   HEAP32[i7 >> 2] = i4;
   STACKTOP = i3;
   return;
  }
 case 38:
  {
   i7 = i1 + 84 | 0;
   HEAP32[i4 + 8 >> 2] = HEAP32[i7 >> 2];
   HEAP32[i7 >> 2] = i4;
   STACKTOP = i3;
   return;
  }
 case 9:
  {
   i7 = i1 + 84 | 0;
   HEAP32[i4 + 72 >> 2] = HEAP32[i7 >> 2];
   HEAP32[i7 >> 2] = i4;
   STACKTOP = i3;
   return;
  }
 default:
  {
   STACKTOP = i3;
   return;
  }
 }
 HEAP8[i2] = HEAPU8[i2] | 0 | 4;
 i7 = i1 + 16 | 0;
 HEAP32[i7 >> 2] = (HEAP32[i7 >> 2] | 0) + i4;
 STACKTOP = i3;
 return;
}
function _lua_upvaluejoin(i1, i9, i7, i6, i3) {
 i1 = i1 | 0;
 i9 = i9 | 0;
 i7 = i7 | 0;
 i6 = i6 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i8 = 0, i10 = 0;
 i2 = STACKTOP;
 i5 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i9 | 0) <= 0) {
   if (!((i9 | 0) < -1000999)) {
    i8 = (HEAP32[i1 + 8 >> 2] | 0) + (i9 << 4) | 0;
    break;
   }
   if ((i9 | 0) == -1001e3) {
    i8 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i10 = -1001e3 - i9 | 0;
   i9 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i9 + 8 >> 2] | 0) != 22 ? (i8 = HEAP32[i9 >> 2] | 0, (i10 | 0) <= (HEAPU8[i8 + 6 | 0] | 0 | 0)) : 0) {
    i8 = i8 + (i10 + -1 << 4) + 16 | 0;
   } else {
    i8 = 5192;
   }
  } else {
   i8 = (HEAP32[i5 >> 2] | 0) + (i9 << 4) | 0;
   i8 = i8 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i8 : 5192;
  }
 } while (0);
 i8 = HEAP32[i8 >> 2] | 0;
 i7 = i8 + 16 + (i7 + -1 << 2) | 0;
 do {
  if ((i6 | 0) <= 0) {
   if (!((i6 | 0) < -1000999)) {
    i4 = (HEAP32[i1 + 8 >> 2] | 0) + (i6 << 4) | 0;
    break;
   }
   if ((i6 | 0) == -1001e3) {
    i4 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i6 = -1001e3 - i6 | 0;
   i5 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i4 = HEAP32[i5 >> 2] | 0, (i6 | 0) <= (HEAPU8[i4 + 6 | 0] | 0 | 0)) : 0) {
    i4 = i4 + (i6 + -1 << 4) + 16 | 0;
   } else {
    i4 = 5192;
   }
  } else {
   i4 = (HEAP32[i5 >> 2] | 0) + (i6 << 4) | 0;
   i4 = i4 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 i3 = (HEAP32[i4 >> 2] | 0) + 16 + (i3 + -1 << 2) | 0;
 HEAP32[i7 >> 2] = HEAP32[i3 >> 2];
 i3 = HEAP32[i3 >> 2] | 0;
 if ((HEAP8[i3 + 5 | 0] & 3) == 0) {
  STACKTOP = i2;
  return;
 }
 if ((HEAP8[i8 + 5 | 0] & 4) == 0) {
  STACKTOP = i2;
  return;
 }
 _luaC_barrier_(i1, i8, i3);
 STACKTOP = i2;
 return;
}
function _lua_upvalueid(i5, i7, i1) {
 i5 = i5 | 0;
 i7 = i7 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i6 = 0, i8 = 0, i9 = 0, i10 = 0;
 i2 = STACKTOP;
 i4 = HEAP32[i5 + 16 >> 2] | 0;
 i6 = (i7 | 0) > 0;
 do {
  if (!i6) {
   if (!((i7 | 0) < -1000999)) {
    i8 = (HEAP32[i5 + 8 >> 2] | 0) + (i7 << 4) | 0;
    break;
   }
   if ((i7 | 0) == -1001e3) {
    i8 = (HEAP32[i5 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i10 = -1001e3 - i7 | 0;
   i9 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i9 + 8 >> 2] | 0) != 22 ? (i8 = HEAP32[i9 >> 2] | 0, (i10 | 0) <= (HEAPU8[i8 + 6 | 0] | 0 | 0)) : 0) {
    i8 = i8 + (i10 + -1 << 4) + 16 | 0;
   } else {
    i8 = 5192;
   }
  } else {
   i8 = (HEAP32[i4 >> 2] | 0) + (i7 << 4) | 0;
   i8 = i8 >>> 0 < (HEAP32[i5 + 8 >> 2] | 0) >>> 0 ? i8 : 5192;
  }
 } while (0);
 i9 = HEAP32[i8 + 8 >> 2] & 63;
 if ((i9 | 0) == 38) {
  i10 = (HEAP32[i8 >> 2] | 0) + (i1 + -1 << 4) + 16 | 0;
  STACKTOP = i2;
  return i10 | 0;
 } else if ((i9 | 0) == 6) {
  do {
   if (!i6) {
    if (!((i7 | 0) < -1000999)) {
     i3 = (HEAP32[i5 + 8 >> 2] | 0) + (i7 << 4) | 0;
     break;
    }
    if ((i7 | 0) == -1001e3) {
     i3 = (HEAP32[i5 + 12 >> 2] | 0) + 40 | 0;
     break;
    }
    i5 = -1001e3 - i7 | 0;
    i4 = HEAP32[i4 >> 2] | 0;
    if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i4 >> 2] | 0, (i5 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
     i3 = i3 + (i5 + -1 << 4) + 16 | 0;
    } else {
     i3 = 5192;
    }
   } else {
    i3 = (HEAP32[i4 >> 2] | 0) + (i7 << 4) | 0;
    i3 = i3 >>> 0 < (HEAP32[i5 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
   }
  } while (0);
  i10 = HEAP32[(HEAP32[i3 >> 2] | 0) + 16 + (i1 + -1 << 2) >> 2] | 0;
  STACKTOP = i2;
  return i10 | 0;
 } else {
  i10 = 0;
  STACKTOP = i2;
  return i10 | 0;
 }
 return 0;
}
function _lua_rawequal(i2, i6, i4) {
 i2 = i2 | 0;
 i6 = i6 | 0;
 i4 = i4 | 0;
 var i1 = 0, i3 = 0, i5 = 0, i7 = 0;
 i1 = STACKTOP;
 i3 = HEAP32[i2 + 16 >> 2] | 0;
 do {
  if ((i6 | 0) <= 0) {
   if (!((i6 | 0) < -1000999)) {
    i5 = (HEAP32[i2 + 8 >> 2] | 0) + (i6 << 4) | 0;
    break;
   }
   if ((i6 | 0) == -1001e3) {
    i5 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i7 = -1001e3 - i6 | 0;
   i6 = HEAP32[i3 >> 2] | 0;
   if ((HEAP32[i6 + 8 >> 2] | 0) != 22 ? (i5 = HEAP32[i6 >> 2] | 0, (i7 | 0) <= (HEAPU8[i5 + 6 | 0] | 0 | 0)) : 0) {
    i5 = i5 + (i7 + -1 << 4) + 16 | 0;
   } else {
    i5 = 5192;
   }
  } else {
   i5 = (HEAP32[i3 >> 2] | 0) + (i6 << 4) | 0;
   i5 = i5 >>> 0 < (HEAP32[i2 + 8 >> 2] | 0) >>> 0 ? i5 : 5192;
  }
 } while (0);
 do {
  if ((i4 | 0) <= 0) {
   if (!((i4 | 0) < -1000999)) {
    i2 = (HEAP32[i2 + 8 >> 2] | 0) + (i4 << 4) | 0;
    break;
   }
   if ((i4 | 0) == -1001e3) {
    i2 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i2 = -1001e3 - i4 | 0;
   i3 = HEAP32[i3 >> 2] | 0;
   if ((HEAP32[i3 + 8 >> 2] | 0) == 22) {
    i7 = 0;
    STACKTOP = i1;
    return i7 | 0;
   }
   i3 = HEAP32[i3 >> 2] | 0;
   if ((i2 | 0) > (HEAPU8[i3 + 6 | 0] | 0 | 0)) {
    i7 = 0;
    STACKTOP = i1;
    return i7 | 0;
   } else {
    i2 = i3 + (i2 + -1 << 4) + 16 | 0;
    break;
   }
  } else {
   i3 = (HEAP32[i3 >> 2] | 0) + (i4 << 4) | 0;
   i2 = i3 >>> 0 < (HEAP32[i2 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 if ((i5 | 0) == 5192 | (i2 | 0) == 5192) {
  i7 = 0;
  STACKTOP = i1;
  return i7 | 0;
 }
 if ((HEAP32[i5 + 8 >> 2] | 0) == (HEAP32[i2 + 8 >> 2] | 0)) {
  i2 = (_luaV_equalobj_(0, i5, i2) | 0) != 0;
 } else {
  i2 = 0;
 }
 i7 = i2 & 1;
 STACKTOP = i1;
 return i7 | 0;
}
function _luaO_chunkid(i1, i4, i6) {
 i1 = i1 | 0;
 i4 = i4 | 0;
 i6 = i6 | 0;
 var i2 = 0, i3 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0;
 i2 = STACKTOP;
 i3 = _strlen(i4 | 0) | 0;
 i5 = HEAP8[i4] | 0;
 if (i5 << 24 >> 24 == 64) {
  if (i3 >>> 0 > i6 >>> 0) {
   HEAP8[i1 + 0 | 0] = HEAP8[5552 | 0] | 0;
   HEAP8[i1 + 1 | 0] = HEAP8[5553 | 0] | 0;
   HEAP8[i1 + 2 | 0] = HEAP8[5554 | 0] | 0;
   _memcpy(i1 + 3 | 0, i4 + (4 - i6 + i3) | 0, i6 + -3 | 0) | 0;
   STACKTOP = i2;
   return;
  } else {
   _memcpy(i1 | 0, i4 + 1 | 0, i3 | 0) | 0;
   STACKTOP = i2;
   return;
  }
 } else if (i5 << 24 >> 24 == 61) {
  i4 = i4 + 1 | 0;
  if (i3 >>> 0 > i6 >>> 0) {
   i9 = i6 + -1 | 0;
   _memcpy(i1 | 0, i4 | 0, i9 | 0) | 0;
   HEAP8[i1 + i9 | 0] = 0;
   STACKTOP = i2;
   return;
  } else {
   _memcpy(i1 | 0, i4 | 0, i3 | 0) | 0;
   STACKTOP = i2;
   return;
  }
 } else {
  i5 = _strchr(i4, 10) | 0;
  i9 = i1 + 0 | 0;
  i8 = 5560 | 0;
  i7 = i9 + 9 | 0;
  do {
   HEAP8[i9] = HEAP8[i8] | 0;
   i9 = i9 + 1 | 0;
   i8 = i8 + 1 | 0;
  } while ((i9 | 0) < (i7 | 0));
  i7 = i1 + 9 | 0;
  i6 = i6 + -15 | 0;
  i8 = (i5 | 0) == 0;
  if (i3 >>> 0 < i6 >>> 0 & i8) {
   _memcpy(i7 | 0, i4 | 0, i3 | 0) | 0;
   i3 = i3 + 9 | 0;
  } else {
   if (!i8) {
    i3 = i5 - i4 | 0;
   }
   i3 = i3 >>> 0 > i6 >>> 0 ? i6 : i3;
   _memcpy(i7 | 0, i4 | 0, i3 | 0) | 0;
   i9 = i1 + (i3 + 9) | 0;
   HEAP8[i9 + 0 | 0] = HEAP8[5552 | 0] | 0;
   HEAP8[i9 + 1 | 0] = HEAP8[5553 | 0] | 0;
   HEAP8[i9 + 2 | 0] = HEAP8[5554 | 0] | 0;
   i3 = i3 + 12 | 0;
  }
  i9 = i1 + i3 | 0;
  HEAP8[i9 + 0 | 0] = HEAP8[5576 | 0] | 0;
  HEAP8[i9 + 1 | 0] = HEAP8[5577 | 0] | 0;
  HEAP8[i9 + 2 | 0] = HEAP8[5578 | 0] | 0;
  STACKTOP = i2;
  return;
 }
}
function _luaS_resize(i4, i1) {
 i4 = i4 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i3 = STACKTOP;
 i5 = HEAP32[i4 + 12 >> 2] | 0;
 i2 = i5 + 24 | 0;
 _luaC_runtilstate(i4, -5);
 i5 = i5 + 32 | 0;
 i8 = HEAP32[i5 >> 2] | 0;
 L1 : do {
  if ((i8 | 0) < (i1 | 0)) {
   if ((i1 + 1 | 0) >>> 0 > 1073741823) {
    _luaM_toobig(i4);
   }
   i7 = _luaM_realloc_(i4, HEAP32[i2 >> 2] | 0, i8 << 2, i1 << 2) | 0;
   HEAP32[i2 >> 2] = i7;
   i6 = HEAP32[i5 >> 2] | 0;
   if ((i6 | 0) < (i1 | 0)) {
    i8 = i6;
    while (1) {
     HEAP32[i7 + (i8 << 2) >> 2] = 0;
     i8 = i8 + 1 | 0;
     if ((i8 | 0) == (i1 | 0)) {
      i8 = i6;
      break L1;
     }
     i7 = HEAP32[i2 >> 2] | 0;
    }
   } else {
    i8 = i6;
   }
  }
 } while (0);
 if ((i8 | 0) > 0) {
  i6 = i1 + -1 | 0;
  i7 = 0;
  do {
   i10 = (HEAP32[i2 >> 2] | 0) + (i7 << 2) | 0;
   i9 = HEAP32[i10 >> 2] | 0;
   HEAP32[i10 >> 2] = 0;
   if ((i9 | 0) != 0) {
    while (1) {
     i8 = HEAP32[i9 >> 2] | 0;
     i10 = HEAP32[i9 + 8 >> 2] & i6;
     HEAP32[i9 >> 2] = HEAP32[(HEAP32[i2 >> 2] | 0) + (i10 << 2) >> 2];
     HEAP32[(HEAP32[i2 >> 2] | 0) + (i10 << 2) >> 2] = i9;
     i10 = i9 + 5 | 0;
     HEAP8[i10] = HEAP8[i10] & 191;
     if ((i8 | 0) == 0) {
      break;
     } else {
      i9 = i8;
     }
    }
    i8 = HEAP32[i5 >> 2] | 0;
   }
   i7 = i7 + 1 | 0;
  } while ((i7 | 0) < (i8 | 0));
 }
 if ((i8 | 0) <= (i1 | 0)) {
  HEAP32[i5 >> 2] = i1;
  STACKTOP = i3;
  return;
 }
 if ((i1 + 1 | 0) >>> 0 > 1073741823) {
  _luaM_toobig(i4);
 }
 HEAP32[i2 >> 2] = _luaM_realloc_(i4, HEAP32[i2 >> 2] | 0, i8 << 2, i1 << 2) | 0;
 HEAP32[i5 >> 2] = i1;
 STACKTOP = i3;
 return;
}
function _luaD_poscall(i6, i7) {
 i6 = i6 | 0;
 i7 = i7 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0;
 i1 = STACKTOP;
 i4 = i6 + 16 | 0;
 i3 = HEAP32[i4 >> 2] | 0;
 i5 = HEAPU8[i6 + 40 | 0] | 0;
 if ((i5 & 6 | 0) == 0) {
  i8 = i3 + 8 | 0;
 } else {
  if ((i5 & 2 | 0) != 0) {
   i8 = i6 + 28 | 0;
   i7 = i7 - (HEAP32[i8 >> 2] | 0) | 0;
   _luaD_hook(i6, 1, -1);
   i7 = (HEAP32[i8 >> 2] | 0) + i7 | 0;
  }
  i8 = i3 + 8 | 0;
  HEAP32[i6 + 20 >> 2] = HEAP32[(HEAP32[i8 >> 2] | 0) + 28 >> 2];
 }
 i5 = HEAP32[i3 >> 2] | 0;
 i9 = HEAP16[i3 + 16 >> 1] | 0;
 i3 = i9 << 16 >> 16;
 HEAP32[i4 >> 2] = HEAP32[i8 >> 2];
 i4 = i6 + 8 | 0;
 if (i9 << 16 >> 16 == 0) {
  i9 = i5;
  HEAP32[i4 >> 2] = i9;
  i9 = i3 + 1 | 0;
  STACKTOP = i1;
  return i9 | 0;
 } else {
  i6 = i3;
 }
 while (1) {
  if (!(i7 >>> 0 < (HEAP32[i4 >> 2] | 0) >>> 0)) {
   break;
  }
  i8 = i5 + 16 | 0;
  i11 = i7;
  i10 = HEAP32[i11 + 4 >> 2] | 0;
  i9 = i5;
  HEAP32[i9 >> 2] = HEAP32[i11 >> 2];
  HEAP32[i9 + 4 >> 2] = i10;
  HEAP32[i5 + 8 >> 2] = HEAP32[i7 + 8 >> 2];
  i6 = i6 + -1 | 0;
  if ((i6 | 0) == 0) {
   i2 = 12;
   break;
  } else {
   i7 = i7 + 16 | 0;
   i5 = i8;
  }
 }
 if ((i2 | 0) == 12) {
  HEAP32[i4 >> 2] = i8;
  i11 = i3 + 1 | 0;
  STACKTOP = i1;
  return i11 | 0;
 }
 if ((i6 | 0) > 0) {
  i2 = i6;
  i7 = i5;
 } else {
  i11 = i5;
  HEAP32[i4 >> 2] = i11;
  i11 = i3 + 1 | 0;
  STACKTOP = i1;
  return i11 | 0;
 }
 while (1) {
  i2 = i2 + -1 | 0;
  HEAP32[i7 + 8 >> 2] = 0;
  if ((i2 | 0) <= 0) {
   break;
  } else {
   i7 = i7 + 16 | 0;
  }
 }
 i11 = i5 + (i6 << 4) | 0;
 HEAP32[i4 >> 2] = i11;
 i11 = i3 + 1 | 0;
 STACKTOP = i1;
 return i11 | 0;
}
function _lua_rawset(i1, i4) {
 i1 = i1 | 0;
 i4 = i4 | 0;
 var i2 = 0, i3 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0;
 i2 = STACKTOP;
 i5 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i4 | 0) <= 0) {
   if (!((i4 | 0) < -1000999)) {
    i5 = (HEAP32[i1 + 8 >> 2] | 0) + (i4 << 4) | 0;
    break;
   }
   if ((i4 | 0) == -1001e3) {
    i5 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i4 = -1001e3 - i4 | 0;
   i5 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i5 >> 2] | 0, (i4 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i5 = i3 + (i4 + -1 << 4) + 16 | 0;
   } else {
    i5 = 5192;
   }
  } else {
   i3 = (HEAP32[i5 >> 2] | 0) + (i4 << 4) | 0;
   i5 = i3 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i4 = i1 + 8 | 0;
 i6 = HEAP32[i4 >> 2] | 0;
 i3 = _luaH_set(i1, HEAP32[i5 >> 2] | 0, i6 + -32 | 0) | 0;
 i9 = i6 + -16 | 0;
 i8 = HEAP32[i9 + 4 >> 2] | 0;
 i7 = i3;
 HEAP32[i7 >> 2] = HEAP32[i9 >> 2];
 HEAP32[i7 + 4 >> 2] = i8;
 HEAP32[i3 + 8 >> 2] = HEAP32[i6 + -8 >> 2];
 HEAP8[(HEAP32[i5 >> 2] | 0) + 6 | 0] = 0;
 i3 = HEAP32[i4 >> 2] | 0;
 if ((HEAP32[i3 + -8 >> 2] & 64 | 0) == 0) {
  i9 = i3;
  i9 = i9 + -32 | 0;
  HEAP32[i4 >> 2] = i9;
  STACKTOP = i2;
  return;
 }
 if ((HEAP8[(HEAP32[i3 + -16 >> 2] | 0) + 5 | 0] & 3) == 0) {
  i9 = i3;
  i9 = i9 + -32 | 0;
  HEAP32[i4 >> 2] = i9;
  STACKTOP = i2;
  return;
 }
 i5 = HEAP32[i5 >> 2] | 0;
 if ((HEAP8[i5 + 5 | 0] & 4) == 0) {
  i9 = i3;
  i9 = i9 + -32 | 0;
  HEAP32[i4 >> 2] = i9;
  STACKTOP = i2;
  return;
 }
 _luaC_barrierback_(i1, i5);
 i9 = HEAP32[i4 >> 2] | 0;
 i9 = i9 + -32 | 0;
 HEAP32[i4 >> 2] = i9;
 STACKTOP = i2;
 return;
}
function _saveSetjmp(i4, i3, i1) {
 i4 = i4 | 0;
 i3 = i3 | 0;
 i1 = i1 | 0;
 var i2 = 0;
 setjmpId = setjmpId + 1 | 0;
 HEAP32[i4 >> 2] = setjmpId;
 while ((i2 | 0) < 40) {
  if ((HEAP32[i1 + (i2 << 2) >> 2] | 0) == 0) {
   HEAP32[i1 + (i2 << 2) >> 2] = setjmpId;
   HEAP32[i1 + ((i2 << 2) + 4) >> 2] = i3;
   HEAP32[i1 + ((i2 << 2) + 8) >> 2] = 0;
   return 0;
  }
  i2 = i2 + 2 | 0;
 }
 _putchar(116);
 _putchar(111);
 _putchar(111);
 _putchar(32);
 _putchar(109);
 _putchar(97);
 _putchar(110);
 _putchar(121);
 _putchar(32);
 _putchar(115);
 _putchar(101);
 _putchar(116);
 _putchar(106);
 _putchar(109);
 _putchar(112);
 _putchar(115);
 _putchar(32);
 _putchar(105);
 _putchar(110);
 _putchar(32);
 _putchar(97);
 _putchar(32);
 _putchar(102);
 _putchar(117);
 _putchar(110);
 _putchar(99);
 _putchar(116);
 _putchar(105);
 _putchar(111);
 _putchar(110);
 _putchar(32);
 _putchar(99);
 _putchar(97);
 _putchar(108);
 _putchar(108);
 _putchar(44);
 _putchar(32);
 _putchar(98);
 _putchar(117);
 _putchar(105);
 _putchar(108);
 _putchar(100);
 _putchar(32);
 _putchar(119);
 _putchar(105);
 _putchar(116);
 _putchar(104);
 _putchar(32);
 _putchar(97);
 _putchar(32);
 _putchar(104);
 _putchar(105);
 _putchar(103);
 _putchar(104);
 _putchar(101);
 _putchar(114);
 _putchar(32);
 _putchar(118);
 _putchar(97);
 _putchar(108);
 _putchar(117);
 _putchar(101);
 _putchar(32);
 _putchar(102);
 _putchar(111);
 _putchar(114);
 _putchar(32);
 _putchar(77);
 _putchar(65);
 _putchar(88);
 _putchar(95);
 _putchar(83);
 _putchar(69);
 _putchar(84);
 _putchar(74);
 _putchar(77);
 _putchar(80);
 _putchar(83);
 _putchar(10);
 abort(0);
 return 0;
}
function _lua_newthread(i5) {
 i5 = i5 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i1 = STACKTOP;
 i3 = i5 + 12 | 0;
 if ((HEAP32[(HEAP32[i3 >> 2] | 0) + 12 >> 2] | 0) > 0) {
  _luaC_step(i5);
 }
 i2 = _luaC_newobj(i5, 8, 112, 0, 0) | 0;
 i6 = i5 + 8 | 0;
 i4 = HEAP32[i6 >> 2] | 0;
 HEAP32[i4 >> 2] = i2;
 HEAP32[i4 + 8 >> 2] = 72;
 HEAP32[i6 >> 2] = (HEAP32[i6 >> 2] | 0) + 16;
 HEAP32[i2 + 12 >> 2] = HEAP32[i3 >> 2];
 i6 = i2 + 28 | 0;
 HEAP32[i6 >> 2] = 0;
 i4 = i2 + 16 | 0;
 HEAP32[i4 >> 2] = 0;
 i3 = i2 + 32 | 0;
 HEAP32[i3 >> 2] = 0;
 HEAP32[i2 + 64 >> 2] = 0;
 HEAP16[i2 + 38 >> 1] = 0;
 i9 = i2 + 52 | 0;
 HEAP32[i9 >> 2] = 0;
 i8 = i2 + 40 | 0;
 HEAP8[i8] = 0;
 i10 = i2 + 44 | 0;
 HEAP32[i10 >> 2] = 0;
 HEAP8[i2 + 41 | 0] = 1;
 i7 = i2 + 48 | 0;
 HEAP32[i7 >> 2] = 0;
 HEAP32[i2 + 56 >> 2] = 0;
 HEAP16[i2 + 36 >> 1] = 1;
 HEAP8[i2 + 6 | 0] = 0;
 HEAP32[i2 + 68 >> 2] = 0;
 HEAP8[i8] = HEAP8[i5 + 40 | 0] | 0;
 i8 = HEAP32[i5 + 44 >> 2] | 0;
 HEAP32[i10 >> 2] = i8;
 HEAP32[i9 >> 2] = HEAP32[i5 + 52 >> 2];
 HEAP32[i7 >> 2] = i8;
 i5 = _luaM_realloc_(i5, 0, 0, 640) | 0;
 HEAP32[i6 >> 2] = i5;
 HEAP32[i3 >> 2] = 40;
 i6 = 0;
 do {
  HEAP32[i5 + (i6 << 4) + 8 >> 2] = 0;
  i6 = i6 + 1 | 0;
 } while ((i6 | 0) != 40);
 HEAP32[i2 + 24 >> 2] = i5 + ((HEAP32[i3 >> 2] | 0) + -5 << 4);
 i10 = i2 + 72 | 0;
 HEAP32[i2 + 80 >> 2] = 0;
 HEAP32[i2 + 84 >> 2] = 0;
 HEAP8[i2 + 90 | 0] = 0;
 HEAP32[i10 >> 2] = i5;
 HEAP32[i2 + 8 >> 2] = i5 + 16;
 HEAP32[i5 + 8 >> 2] = 0;
 HEAP32[i2 + 76 >> 2] = i5 + 336;
 HEAP32[i4 >> 2] = i10;
 STACKTOP = i1;
 return i2 | 0;
}
function _luaK_self(i2, i5, i3) {
 i2 = i2 | 0;
 i5 = i5 | 0;
 i3 = i3 | 0;
 var i1 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i1 = STACKTOP;
 _luaK_dischargevars(i2, i5);
 if ((HEAP32[i5 >> 2] | 0) == 6) {
  i6 = i5 + 8 | 0;
  i8 = HEAP32[i6 >> 2] | 0;
  if ((HEAP32[i5 + 16 >> 2] | 0) != (HEAP32[i5 + 20 >> 2] | 0)) {
   if ((i8 | 0) < (HEAPU8[i2 + 46 | 0] | 0 | 0)) {
    i7 = 6;
   } else {
    _exp2reg(i2, i5, i8);
   }
  }
 } else {
  i6 = i5 + 8 | 0;
  i7 = 6;
 }
 if ((i7 | 0) == 6) {
  _luaK_exp2nextreg(i2, i5);
 }
 i8 = HEAP32[i6 >> 2] | 0;
 if (((HEAP32[i5 >> 2] | 0) == 6 ? (i8 & 256 | 0) == 0 : 0) ? (HEAPU8[i2 + 46 | 0] | 0 | 0) <= (i8 | 0) : 0) {
  i10 = i2 + 48 | 0;
  HEAP8[i10] = (HEAP8[i10] | 0) + -1 << 24 >> 24;
 }
 i7 = i2 + 48 | 0;
 HEAP32[i6 >> 2] = HEAPU8[i7] | 0;
 HEAP32[i5 >> 2] = 6;
 i10 = HEAP8[i7] | 0;
 i5 = (i10 & 255) + 2 | 0;
 i9 = (HEAP32[i2 >> 2] | 0) + 78 | 0;
 do {
  if (i5 >>> 0 > (HEAPU8[i9] | 0) >>> 0) {
   if (i5 >>> 0 > 249) {
    _luaX_syntaxerror(HEAP32[i2 + 12 >> 2] | 0, 10536);
   } else {
    HEAP8[i9] = i5;
    i4 = HEAP8[i7] | 0;
    break;
   }
  } else {
   i4 = i10;
  }
 } while (0);
 HEAP8[i7] = (i4 & 255) + 2;
 i10 = HEAP32[i6 >> 2] | 0;
 _luaK_code(i2, i8 << 23 | i10 << 6 | (_luaK_exp2RK(i2, i3) | 0) << 14 | 12) | 0;
 if ((HEAP32[i3 >> 2] | 0) != 6) {
  STACKTOP = i1;
  return;
 }
 i3 = HEAP32[i3 + 8 >> 2] | 0;
 if ((i3 & 256 | 0) != 0) {
  STACKTOP = i1;
  return;
 }
 if ((HEAPU8[i2 + 46 | 0] | 0 | 0) > (i3 | 0)) {
  STACKTOP = i1;
  return;
 }
 HEAP8[i7] = (HEAP8[i7] | 0) + -1 << 24 >> 24;
 STACKTOP = i1;
 return;
}
function _luaD_rawrunprotected(i10, i9, i11) {
 i10 = i10 | 0;
 i9 = i9 | 0;
 i11 = i11 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i12 = 0, i13 = 0;
 i7 = STACKTOP;
 STACKTOP = STACKTOP + 176 | 0;
 i8 = STACKTOP;
 STACKTOP = STACKTOP + 168 | 0;
 HEAP32[i8 >> 2] = 0;
 i6 = i7;
 i5 = i10 + 38 | 0;
 i4 = HEAP16[i5 >> 1] | 0;
 i1 = i6 + 160 | 0;
 HEAP32[i1 >> 2] = 0;
 i3 = i10 + 64 | 0;
 HEAP32[i6 >> 2] = HEAP32[i3 >> 2];
 HEAP32[i3 >> 2] = i6;
 _saveSetjmp(i6 + 4 | 0, 1, i8 | 0) | 0;
 __THREW__ = 0;
 i13 = __THREW__;
 __THREW__ = 0;
 if ((i13 | 0) != 0 & (threwValue | 0) != 0) {
  i12 = _testSetjmp(HEAP32[i13 >> 2] | 0, i8) | 0;
  if ((i12 | 0) == 0) {
   _longjmp(i13 | 0, threwValue | 0);
  }
  tempRet0 = threwValue;
 } else {
  i12 = -1;
 }
 if ((i12 | 0) == 1) {
  i12 = tempRet0;
 } else {
  i12 = 0;
 }
 while (1) {
  if ((i12 | 0) != 0) {
   i2 = 6;
   break;
  }
  __THREW__ = 0;
  invoke_vii(i9 | 0, i10 | 0, i11 | 0);
  i13 = __THREW__;
  __THREW__ = 0;
  if ((i13 | 0) != 0 & (threwValue | 0) != 0) {
   i12 = _testSetjmp(HEAP32[i13 >> 2] | 0, i8) | 0;
   if ((i12 | 0) == 0) {
    _longjmp(i13 | 0, threwValue | 0);
   }
   tempRet0 = threwValue;
  } else {
   i12 = -1;
  }
  if ((i12 | 0) == 1) {
   i12 = tempRet0;
  } else {
   break;
  }
 }
 if ((i2 | 0) == 6) {
  i13 = HEAP32[i6 >> 2] | 0;
  HEAP32[i3 >> 2] = i13;
  HEAP16[i5 >> 1] = i4;
  i13 = HEAP32[i1 >> 2] | 0;
  STACKTOP = i7;
  return i13 | 0;
 }
 i13 = HEAP32[i6 >> 2] | 0;
 HEAP32[i3 >> 2] = i13;
 HEAP16[i5 >> 1] = i4;
 i13 = HEAP32[i1 >> 2] | 0;
 STACKTOP = i7;
 return i13 | 0;
}
function _luaB_tonumber(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, d6 = 0.0, i7 = 0, d8 = 0.0, i9 = 0, i10 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2 + 4 | 0;
 i4 = i2;
 do {
  if ((_lua_type(i1, 2) | 0) >= 1) {
   i9 = _luaL_checklstring(i1, 1, i4) | 0;
   i3 = i9 + (HEAP32[i4 >> 2] | 0) | 0;
   i5 = _luaL_checkinteger(i1, 2) | 0;
   if (!((i5 + -2 | 0) >>> 0 < 35)) {
    _luaL_argerror(i1, 2, 9648) | 0;
   }
   i10 = _strspn(i9, 9672) | 0;
   i7 = i9 + i10 | 0;
   i4 = HEAP8[i7] | 0;
   if (i4 << 24 >> 24 == 43) {
    i4 = 0;
    i7 = i9 + (i10 + 1) | 0;
   } else if (i4 << 24 >> 24 == 45) {
    i4 = 1;
    i7 = i9 + (i10 + 1) | 0;
   } else {
    i4 = 0;
   }
   if ((_isalnum(HEAPU8[i7] | 0 | 0) | 0) != 0) {
    d6 = +(i5 | 0);
    d8 = 0.0;
    do {
     i9 = HEAP8[i7] | 0;
     i10 = i9 & 255;
     if ((i10 + -48 | 0) >>> 0 < 10) {
      i9 = (i9 << 24 >> 24) + -48 | 0;
     } else {
      i9 = (_toupper(i10 | 0) | 0) + -55 | 0;
     }
     if ((i9 | 0) >= (i5 | 0)) {
      break;
     }
     d8 = d6 * d8 + +(i9 | 0);
     i7 = i7 + 1 | 0;
    } while ((_isalnum(HEAPU8[i7] | 0 | 0) | 0) != 0);
    if ((i7 + (_strspn(i7, 9672) | 0) | 0) == (i3 | 0)) {
     if ((i4 | 0) != 0) {
      d8 = -d8;
     }
     _lua_pushnumber(i1, d8);
     STACKTOP = i2;
     return 1;
    }
   }
  } else {
   d6 = +_lua_tonumberx(i1, 1, i3);
   if ((HEAP32[i3 >> 2] | 0) == 0) {
    _luaL_checkany(i1, 1);
    break;
   }
   _lua_pushnumber(i1, d6);
   STACKTOP = i2;
   return 1;
  }
 } while (0);
 _lua_pushnil(i1);
 STACKTOP = i2;
 return 1;
}
function _luaK_storevar(i1, i5, i3) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 i7 = HEAP32[i5 >> 2] | 0;
 if ((i7 | 0) == 7) {
  if (((HEAP32[i3 >> 2] | 0) == 6 ? (i6 = HEAP32[i3 + 8 >> 2] | 0, (i6 & 256 | 0) == 0) : 0) ? (HEAPU8[i1 + 46 | 0] | 0) <= (i6 | 0) : 0) {
   i7 = i1 + 48 | 0;
   HEAP8[i7] = (HEAP8[i7] | 0) + -1 << 24 >> 24;
  }
  _exp2reg(i1, i3, HEAP32[i5 + 8 >> 2] | 0);
  STACKTOP = i2;
  return;
 } else if ((i7 | 0) == 9) {
  i4 = i5 + 8 | 0;
  i7 = (HEAP8[i4 + 3 | 0] | 0) == 7 ? 10 : 8;
  i6 = _luaK_exp2RK(i1, i3) | 0;
  _luaK_code(i1, i6 << 14 | i7 | HEAPU8[i4 + 2 | 0] << 6 | HEAPU16[i4 >> 1] << 23) | 0;
 } else if ((i7 | 0) == 8) {
  _luaK_dischargevars(i1, i3);
  if ((HEAP32[i3 >> 2] | 0) == 6) {
   i6 = i3 + 8 | 0;
   i7 = HEAP32[i6 >> 2] | 0;
   if ((HEAP32[i3 + 16 >> 2] | 0) != (HEAP32[i3 + 20 >> 2] | 0)) {
    if ((i7 | 0) < (HEAPU8[i1 + 46 | 0] | 0)) {
     i4 = 12;
    } else {
     _exp2reg(i1, i3, i7);
     i7 = HEAP32[i6 >> 2] | 0;
    }
   }
  } else {
   i6 = i3 + 8 | 0;
   i4 = 12;
  }
  if ((i4 | 0) == 12) {
   _luaK_exp2nextreg(i1, i3);
   i7 = HEAP32[i6 >> 2] | 0;
  }
  _luaK_code(i1, i7 << 6 | HEAP32[i5 + 8 >> 2] << 23 | 9) | 0;
 }
 if ((HEAP32[i3 >> 2] | 0) != 6) {
  STACKTOP = i2;
  return;
 }
 i3 = HEAP32[i3 + 8 >> 2] | 0;
 if ((i3 & 256 | 0) != 0) {
  STACKTOP = i2;
  return;
 }
 if ((HEAPU8[i1 + 46 | 0] | 0) > (i3 | 0)) {
  STACKTOP = i2;
  return;
 }
 i7 = i1 + 48 | 0;
 HEAP8[i7] = (HEAP8[i7] | 0) + -1 << 24 >> 24;
 STACKTOP = i2;
 return;
}
function _closegoto(i10, i3, i9) {
 i10 = i10 | 0;
 i3 = i3 | 0;
 i9 = i9 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i11 = 0, i12 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i7 = i1;
 i4 = HEAP32[i10 + 48 >> 2] | 0;
 i6 = HEAP32[i10 + 64 >> 2] | 0;
 i2 = i6 + 12 | 0;
 i5 = HEAP32[i2 >> 2] | 0;
 i8 = HEAP8[i5 + (i3 << 4) + 12 | 0] | 0;
 if ((i8 & 255) < (HEAPU8[i9 + 12 | 0] | 0)) {
  i11 = HEAP32[i10 + 52 >> 2] | 0;
  i12 = HEAP32[i5 + (i3 << 4) + 8 >> 2] | 0;
  i8 = (HEAP32[(HEAP32[(HEAP32[i4 >> 2] | 0) + 24 >> 2] | 0) + ((HEAP16[(HEAP32[HEAP32[(HEAP32[i4 + 12 >> 2] | 0) + 64 >> 2] >> 2] | 0) + ((HEAP32[i4 + 40 >> 2] | 0) + (i8 & 255) << 1) >> 1] | 0) * 12 | 0) >> 2] | 0) + 16 | 0;
  HEAP32[i7 >> 2] = (HEAP32[i5 + (i3 << 4) >> 2] | 0) + 16;
  HEAP32[i7 + 4 >> 2] = i12;
  HEAP32[i7 + 8 >> 2] = i8;
  _semerror(i10, _luaO_pushfstring(i11, 6248, i7) | 0);
 }
 _luaK_patchlist(i4, HEAP32[i5 + (i3 << 4) + 4 >> 2] | 0, HEAP32[i9 + 4 >> 2] | 0);
 i4 = i6 + 16 | 0;
 i5 = (HEAP32[i4 >> 2] | 0) + -1 | 0;
 if ((i5 | 0) <= (i3 | 0)) {
  i12 = i5;
  HEAP32[i4 >> 2] = i12;
  STACKTOP = i1;
  return;
 }
 do {
  i12 = HEAP32[i2 >> 2] | 0;
  i5 = i12 + (i3 << 4) | 0;
  i3 = i3 + 1 | 0;
  i12 = i12 + (i3 << 4) | 0;
  HEAP32[i5 + 0 >> 2] = HEAP32[i12 + 0 >> 2];
  HEAP32[i5 + 4 >> 2] = HEAP32[i12 + 4 >> 2];
  HEAP32[i5 + 8 >> 2] = HEAP32[i12 + 8 >> 2];
  HEAP32[i5 + 12 >> 2] = HEAP32[i12 + 12 >> 2];
  i5 = (HEAP32[i4 >> 2] | 0) + -1 | 0;
 } while ((i3 | 0) < (i5 | 0));
 HEAP32[i4 >> 2] = i5;
 STACKTOP = i1;
 return;
}
function _luaM_growaux_(i4, i5, i1, i7, i8, i9) {
 i4 = i4 | 0;
 i5 = i5 | 0;
 i1 = i1 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 i9 = i9 | 0;
 var i2 = 0, i3 = 0, i6 = 0, i10 = 0, i11 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i10 = i2;
 i6 = HEAP32[i1 >> 2] | 0;
 if ((i6 | 0) >= ((i8 | 0) / 2 | 0 | 0)) {
  if ((i6 | 0) < (i8 | 0)) {
   i3 = i8;
  } else {
   HEAP32[i10 >> 2] = i9;
   HEAP32[i10 + 4 >> 2] = i8;
   _luaG_runerror(i4, 4112, i10);
  }
 } else {
  i3 = i6 << 1;
  i3 = (i3 | 0) < 4 ? 4 : i3;
 }
 if ((i3 + 1 | 0) >>> 0 > (4294967293 / (i7 >>> 0) | 0) >>> 0) {
  _luaM_toobig(i4);
 }
 i6 = Math_imul(i6, i7) | 0;
 i8 = Math_imul(i3, i7) | 0;
 i9 = HEAP32[i4 + 12 >> 2] | 0;
 i7 = (i5 | 0) != 0;
 i11 = i9 + 4 | 0;
 i10 = FUNCTION_TABLE_iiiii[HEAP32[i9 >> 2] & 3](HEAP32[i11 >> 2] | 0, i5, i6, i8) | 0;
 if ((i10 | 0) != 0 | (i8 | 0) == 0) {
  i5 = i9 + 12 | 0;
  i4 = HEAP32[i5 >> 2] | 0;
  i6 = 0 - i6 | 0;
  i11 = i7 ? i6 : 0;
  i11 = i11 + i8 | 0;
  i11 = i11 + i4 | 0;
  HEAP32[i5 >> 2] = i11;
  HEAP32[i1 >> 2] = i3;
  STACKTOP = i2;
  return i10 | 0;
 }
 if ((HEAP8[i9 + 63 | 0] | 0) == 0) {
  _luaD_throw(i4, 4);
 }
 _luaC_fullgc(i4, 1);
 i10 = FUNCTION_TABLE_iiiii[HEAP32[i9 >> 2] & 3](HEAP32[i11 >> 2] | 0, i5, i6, i8) | 0;
 if ((i10 | 0) == 0) {
  _luaD_throw(i4, 4);
 } else {
  i5 = i9 + 12 | 0;
  i4 = HEAP32[i5 >> 2] | 0;
  i6 = 0 - i6 | 0;
  i11 = i7 ? i6 : 0;
  i11 = i11 + i8 | 0;
  i11 = i11 + i4 | 0;
  HEAP32[i5 >> 2] = i11;
  HEAP32[i1 >> 2] = i3;
  STACKTOP = i2;
  return i10 | 0;
 }
 return 0;
}
function _luaD_hook(i5, i14, i13) {
 i5 = i5 | 0;
 i14 = i14 | 0;
 i13 = i13 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i15 = 0, i16 = 0;
 i11 = STACKTOP;
 STACKTOP = STACKTOP + 112 | 0;
 i4 = i11;
 i3 = HEAP32[i5 + 52 >> 2] | 0;
 if ((i3 | 0) == 0) {
  STACKTOP = i11;
  return;
 }
 i8 = i5 + 41 | 0;
 if ((HEAP8[i8] | 0) == 0) {
  STACKTOP = i11;
  return;
 }
 i10 = HEAP32[i5 + 16 >> 2] | 0;
 i6 = i5 + 8 | 0;
 i15 = HEAP32[i6 >> 2] | 0;
 i1 = i5 + 28 | 0;
 i16 = i15;
 i12 = HEAP32[i1 >> 2] | 0;
 i7 = i16 - i12 | 0;
 i9 = i10 + 4 | 0;
 i12 = (HEAP32[i9 >> 2] | 0) - i12 | 0;
 HEAP32[i4 >> 2] = i14;
 HEAP32[i4 + 20 >> 2] = i13;
 HEAP32[i4 + 96 >> 2] = i10;
 do {
  if (((HEAP32[i5 + 24 >> 2] | 0) - i16 | 0) < 336) {
   i14 = HEAP32[i5 + 32 >> 2] | 0;
   if ((i14 | 0) > 1e6) {
    _luaD_throw(i5, 6);
   }
   i13 = (i7 >> 4) + 25 | 0;
   i14 = i14 << 1;
   i14 = (i14 | 0) > 1e6 ? 1e6 : i14;
   i13 = (i14 | 0) < (i13 | 0) ? i13 : i14;
   if ((i13 | 0) > 1e6) {
    _luaD_reallocstack(i5, 1000200);
    _luaG_runerror(i5, 2224, i4);
   } else {
    _luaD_reallocstack(i5, i13);
    i2 = HEAP32[i6 >> 2] | 0;
    break;
   }
  } else {
   i2 = i15;
  }
 } while (0);
 HEAP32[i9 >> 2] = i2 + 320;
 HEAP8[i8] = 0;
 i16 = i10 + 18 | 0;
 HEAP8[i16] = HEAPU8[i16] | 2;
 FUNCTION_TABLE_vii[i3 & 15](i5, i4);
 HEAP8[i8] = 1;
 HEAP32[i9 >> 2] = (HEAP32[i1 >> 2] | 0) + i12;
 HEAP32[i6 >> 2] = (HEAP32[i1 >> 2] | 0) + i7;
 HEAP8[i16] = HEAP8[i16] & 253;
 STACKTOP = i11;
 return;
}
function _funcargs(i10, i2, i1) {
 i10 = i10 | 0;
 i2 = i2 | 0;
 i1 = i1 | 0;
 var i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i6 = i3;
 i9 = i10 + 48 | 0;
 i5 = HEAP32[i9 >> 2] | 0;
 i7 = i10 + 16 | 0;
 i8 = HEAP32[i7 >> 2] | 0;
 if ((i8 | 0) == 289) {
  i9 = _luaK_stringK(i5, HEAP32[i10 + 24 >> 2] | 0) | 0;
  HEAP32[i6 + 16 >> 2] = -1;
  HEAP32[i6 + 20 >> 2] = -1;
  HEAP32[i6 >> 2] = 4;
  HEAP32[i6 + 8 >> 2] = i9;
  _luaX_next(i10);
 } else if ((i8 | 0) == 40) {
  _luaX_next(i10);
  if ((HEAP32[i7 >> 2] | 0) == 41) {
   HEAP32[i6 >> 2] = 0;
  } else {
   _subexpr(i10, i6, 0) | 0;
   if ((HEAP32[i7 >> 2] | 0) == 44) {
    do {
     _luaX_next(i10);
     _luaK_exp2nextreg(HEAP32[i9 >> 2] | 0, i6);
     _subexpr(i10, i6, 0) | 0;
    } while ((HEAP32[i7 >> 2] | 0) == 44);
   }
   _luaK_setreturns(i5, i6, -1);
  }
  _check_match(i10, 41, 40, i1);
 } else if ((i8 | 0) == 123) {
  _constructor(i10, i6);
 } else {
  _luaX_syntaxerror(i10, 6624);
 }
 i8 = i2 + 8 | 0;
 i7 = HEAP32[i8 >> 2] | 0;
 i9 = HEAP32[i6 >> 2] | 0;
 if ((i9 | 0) == 0) {
  i4 = 13;
 } else if ((i9 | 0) == 13 | (i9 | 0) == 12) {
  i6 = 0;
 } else {
  _luaK_exp2nextreg(i5, i6);
  i4 = 13;
 }
 if ((i4 | 0) == 13) {
  i6 = (HEAPU8[i5 + 48 | 0] | 0) - i7 | 0;
 }
 i10 = _luaK_codeABC(i5, 29, i7, i6, 2) | 0;
 HEAP32[i2 + 16 >> 2] = -1;
 HEAP32[i2 + 20 >> 2] = -1;
 HEAP32[i2 >> 2] = 12;
 HEAP32[i8 >> 2] = i10;
 _luaK_fixline(i5, i1);
 HEAP8[i5 + 48 | 0] = i7 + 1;
 STACKTOP = i3;
 return;
}
function _luaD_reallocstack(i3, i6) {
 i3 = i3 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0;
 i1 = STACKTOP;
 i2 = i3 + 28 | 0;
 i8 = HEAP32[i2 >> 2] | 0;
 i7 = i3 + 32 | 0;
 i9 = HEAP32[i7 >> 2] | 0;
 if ((i6 + 1 | 0) >>> 0 > 268435455) {
  _luaM_toobig(i3);
 }
 i5 = _luaM_realloc_(i3, i8, i9 << 4, i6 << 4) | 0;
 HEAP32[i2 >> 2] = i5;
 if ((i9 | 0) < (i6 | 0)) {
  do {
   HEAP32[i5 + (i9 << 4) + 8 >> 2] = 0;
   i9 = i9 + 1 | 0;
  } while ((i9 | 0) != (i6 | 0));
 }
 HEAP32[i7 >> 2] = i6;
 HEAP32[i3 + 24 >> 2] = i5 + (i6 + -5 << 4);
 i6 = i3 + 8 | 0;
 HEAP32[i6 >> 2] = i5 + ((HEAP32[i6 >> 2] | 0) - i8 >> 4 << 4);
 i6 = HEAP32[i3 + 56 >> 2] | 0;
 if ((i6 | 0) != 0 ? (i4 = i6 + 8 | 0, HEAP32[i4 >> 2] = i5 + ((HEAP32[i4 >> 2] | 0) - i8 >> 4 << 4), i4 = HEAP32[i6 >> 2] | 0, (i4 | 0) != 0) : 0) {
  do {
   i9 = i4 + 8 | 0;
   HEAP32[i9 >> 2] = (HEAP32[i2 >> 2] | 0) + ((HEAP32[i9 >> 2] | 0) - i8 >> 4 << 4);
   i4 = HEAP32[i4 >> 2] | 0;
  } while ((i4 | 0) != 0);
 }
 i3 = HEAP32[i3 + 16 >> 2] | 0;
 if ((i3 | 0) == 0) {
  STACKTOP = i1;
  return;
 }
 do {
  i9 = i3 + 4 | 0;
  HEAP32[i9 >> 2] = (HEAP32[i2 >> 2] | 0) + ((HEAP32[i9 >> 2] | 0) - i8 >> 4 << 4);
  HEAP32[i3 >> 2] = (HEAP32[i2 >> 2] | 0) + ((HEAP32[i3 >> 2] | 0) - i8 >> 4 << 4);
  if (!((HEAP8[i3 + 18 | 0] & 1) == 0)) {
   i9 = i3 + 24 | 0;
   HEAP32[i9 >> 2] = (HEAP32[i2 >> 2] | 0) + ((HEAP32[i9 >> 2] | 0) - i8 >> 4 << 4);
  }
  i3 = HEAP32[i3 + 8 >> 2] | 0;
 } while ((i3 | 0) != 0);
 STACKTOP = i1;
 return;
}
function _luaF_close(i7, i6) {
 i7 = i7 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0;
 i1 = STACKTOP;
 i4 = HEAP32[i7 + 12 >> 2] | 0;
 i3 = i7 + 56 | 0;
 i8 = HEAP32[i3 >> 2] | 0;
 if ((i8 | 0) == 0) {
  STACKTOP = i1;
  return;
 }
 i5 = i4 + 60 | 0;
 i2 = i4 + 68 | 0;
 while (1) {
  i9 = i8 + 8 | 0;
  if ((HEAP32[i9 >> 2] | 0) >>> 0 < i6 >>> 0) {
   i2 = 10;
   break;
  }
  HEAP32[i3 >> 2] = HEAP32[i8 >> 2];
  if ((((HEAPU8[i5] | 0) ^ 3) & ((HEAPU8[i8 + 5 | 0] | 0) ^ 3) | 0) == 0) {
   if ((HEAP32[i9 >> 2] | 0) != (i8 + 16 | 0)) {
    i9 = i8 + 16 | 0;
    i10 = i9 + 4 | 0;
    HEAP32[(HEAP32[i10 >> 2] | 0) + 16 >> 2] = HEAP32[i9 >> 2];
    HEAP32[(HEAP32[i9 >> 2] | 0) + 20 >> 2] = HEAP32[i10 >> 2];
   }
   _luaM_realloc_(i7, i8, 32, 0) | 0;
  } else {
   i11 = i8 + 16 | 0;
   i10 = i11 + 4 | 0;
   HEAP32[(HEAP32[i10 >> 2] | 0) + 16 >> 2] = HEAP32[i11 >> 2];
   HEAP32[(HEAP32[i11 >> 2] | 0) + 20 >> 2] = HEAP32[i10 >> 2];
   i11 = HEAP32[i9 >> 2] | 0;
   i10 = i8 + 16 | 0;
   i14 = i11;
   i13 = HEAP32[i14 + 4 >> 2] | 0;
   i12 = i10;
   HEAP32[i12 >> 2] = HEAP32[i14 >> 2];
   HEAP32[i12 + 4 >> 2] = i13;
   HEAP32[i8 + 24 >> 2] = HEAP32[i11 + 8 >> 2];
   HEAP32[i9 >> 2] = i10;
   HEAP32[i8 >> 2] = HEAP32[i2 >> 2];
   HEAP32[i2 >> 2] = i8;
   _luaC_checkupvalcolor(i4, i8);
  }
  i8 = HEAP32[i3 >> 2] | 0;
  if ((i8 | 0) == 0) {
   i2 = 10;
   break;
  }
 }
 if ((i2 | 0) == 10) {
  STACKTOP = i1;
  return;
 }
}
function _luaK_dischargevars(i3, i1) {
 i3 = i3 | 0;
 i1 = i1 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 switch (HEAP32[i1 >> 2] | 0) {
 case 12:
  {
   HEAP32[i1 >> 2] = 6;
   i6 = i1 + 8 | 0;
   HEAP32[i6 >> 2] = (HEAP32[(HEAP32[(HEAP32[i3 >> 2] | 0) + 12 >> 2] | 0) + (HEAP32[i6 >> 2] << 2) >> 2] | 0) >>> 6 & 255;
   STACKTOP = i2;
   return;
  }
 case 13:
  {
   i6 = (HEAP32[(HEAP32[i3 >> 2] | 0) + 12 >> 2] | 0) + (HEAP32[i1 + 8 >> 2] << 2) | 0;
   HEAP32[i6 >> 2] = HEAP32[i6 >> 2] & 8388607 | 16777216;
   HEAP32[i1 >> 2] = 11;
   STACKTOP = i2;
   return;
  }
 case 9:
  {
   i4 = i1 + 8 | 0;
   i5 = HEAP16[i4 >> 1] | 0;
   if ((i5 & 256 | 0) == 0 ? (HEAPU8[i3 + 46 | 0] | 0) <= (i5 | 0) : 0) {
    i6 = i3 + 48 | 0;
    HEAP8[i6] = (HEAP8[i6] | 0) + -1 << 24 >> 24;
   }
   i5 = i4 + 2 | 0;
   if ((HEAP8[i4 + 3 | 0] | 0) == 7) {
    if ((HEAPU8[i3 + 46 | 0] | 0) > (HEAPU8[i5] | 0)) {
     i6 = 7;
    } else {
     i6 = i3 + 48 | 0;
     HEAP8[i6] = (HEAP8[i6] | 0) + -1 << 24 >> 24;
     i6 = 7;
    }
   } else {
    i6 = 6;
   }
   HEAP32[i4 >> 2] = _luaK_code(i3, HEAPU8[i5] << 23 | i6 | HEAP16[i4 >> 1] << 14) | 0;
   HEAP32[i1 >> 2] = 11;
   STACKTOP = i2;
   return;
  }
 case 7:
  {
   HEAP32[i1 >> 2] = 6;
   STACKTOP = i2;
   return;
  }
 case 8:
  {
   i6 = i1 + 8 | 0;
   HEAP32[i6 >> 2] = _luaK_code(i3, HEAP32[i6 >> 2] << 23 | 5) | 0;
   HEAP32[i1 >> 2] = 11;
   STACKTOP = i2;
   return;
  }
 default:
  {
   STACKTOP = i2;
   return;
  }
 }
}
function _gmatch_aux(i10) {
 i10 = i10 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i11 = 0, i12 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 288 | 0;
 i2 = i1 + 8 | 0;
 i12 = i1 + 4 | 0;
 i3 = i1;
 i8 = _lua_tolstring(i10, -1001001, i12) | 0;
 i7 = _lua_tolstring(i10, -1001002, i3) | 0;
 i5 = i2 + 16 | 0;
 HEAP32[i5 >> 2] = i10;
 HEAP32[i2 >> 2] = 200;
 HEAP32[i2 + 4 >> 2] = i8;
 i9 = i2 + 8 | 0;
 HEAP32[i9 >> 2] = i8 + (HEAP32[i12 >> 2] | 0);
 HEAP32[i2 + 12 >> 2] = i7 + (HEAP32[i3 >> 2] | 0);
 i3 = i8 + (_lua_tointegerx(i10, -1001003, 0) | 0) | 0;
 if (i3 >>> 0 > (HEAP32[i9 >> 2] | 0) >>> 0) {
  i12 = 0;
  STACKTOP = i1;
  return i12 | 0;
 }
 i11 = i2 + 20 | 0;
 while (1) {
  HEAP32[i11 >> 2] = 0;
  i4 = _match(i2, i3, i7) | 0;
  i12 = i3 + 1 | 0;
  if ((i4 | 0) != 0) {
   break;
  }
  if (i12 >>> 0 > (HEAP32[i9 >> 2] | 0) >>> 0) {
   i2 = 0;
   i6 = 7;
   break;
  } else {
   i3 = i12;
  }
 }
 if ((i6 | 0) == 7) {
  STACKTOP = i1;
  return i2 | 0;
 }
 _lua_pushinteger(i10, i4 - i8 + ((i4 | 0) == (i3 | 0)) | 0);
 _lua_replace(i10, -1001003);
 i7 = HEAP32[i11 >> 2] | 0;
 i6 = (i7 | 0) != 0 | (i3 | 0) == 0 ? i7 : 1;
 _luaL_checkstack(HEAP32[i5 >> 2] | 0, i6, 7200);
 if ((i6 | 0) > 0) {
  i5 = 0;
 } else {
  i12 = i7;
  STACKTOP = i1;
  return i12 | 0;
 }
 while (1) {
  _push_onecapture(i2, i5, i3, i4);
  i5 = i5 + 1 | 0;
  if ((i5 | 0) == (i6 | 0)) {
   i2 = i6;
   break;
  }
 }
 STACKTOP = i1;
 return i2 | 0;
}
function _lua_rawseti(i1, i5, i3) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i6 = 0;
 i2 = STACKTOP;
 i6 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i5 = (HEAP32[i1 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i5 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i6 = HEAP32[i6 >> 2] | 0;
   if ((HEAP32[i6 + 8 >> 2] | 0) != 22 ? (i4 = HEAP32[i6 >> 2] | 0, (i5 | 0) <= (HEAPU8[i4 + 6 | 0] | 0 | 0)) : 0) {
    i5 = i4 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i5 = 5192;
   }
  } else {
   i4 = (HEAP32[i6 >> 2] | 0) + (i5 << 4) | 0;
   i5 = i4 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 i4 = i1 + 8 | 0;
 _luaH_setint(i1, HEAP32[i5 >> 2] | 0, i3, (HEAP32[i4 >> 2] | 0) + -16 | 0);
 i3 = HEAP32[i4 >> 2] | 0;
 if ((HEAP32[i3 + -8 >> 2] & 64 | 0) == 0) {
  i6 = i3;
  i6 = i6 + -16 | 0;
  HEAP32[i4 >> 2] = i6;
  STACKTOP = i2;
  return;
 }
 if ((HEAP8[(HEAP32[i3 + -16 >> 2] | 0) + 5 | 0] & 3) == 0) {
  i6 = i3;
  i6 = i6 + -16 | 0;
  HEAP32[i4 >> 2] = i6;
  STACKTOP = i2;
  return;
 }
 i5 = HEAP32[i5 >> 2] | 0;
 if ((HEAP8[i5 + 5 | 0] & 4) == 0) {
  i6 = i3;
  i6 = i6 + -16 | 0;
  HEAP32[i4 >> 2] = i6;
  STACKTOP = i2;
  return;
 }
 _luaC_barrierback_(i1, i5);
 i6 = HEAP32[i4 >> 2] | 0;
 i6 = i6 + -16 | 0;
 HEAP32[i4 >> 2] = i6;
 STACKTOP = i2;
 return;
}
function _ll_require(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 1056 | 0;
 i5 = i2;
 i4 = i2 + 8 | 0;
 i3 = _luaL_checklstring(i1, 1, 0) | 0;
 _lua_settop(i1, 1);
 _lua_getfield(i1, -1001e3, 4576);
 _lua_getfield(i1, 2, i3);
 if ((_lua_toboolean(i1, -1) | 0) != 0) {
  STACKTOP = i2;
  return 1;
 }
 _lua_settop(i1, -2);
 _luaL_buffinit(i1, i4);
 _lua_getfield(i1, -1001001, 4240);
 if ((_lua_type(i1, 3) | 0) == 5) {
  i6 = 1;
 } else {
  _luaL_error(i1, 4656, i5) | 0;
  i6 = 1;
 }
 while (1) {
  _lua_rawgeti(i1, 3, i6);
  if ((_lua_type(i1, -1) | 0) == 0) {
   _lua_settop(i1, -2);
   _luaL_pushresult(i4);
   i7 = _lua_tolstring(i1, -1, 0) | 0;
   HEAP32[i5 >> 2] = i3;
   HEAP32[i5 + 4 >> 2] = i7;
   _luaL_error(i1, 4696, i5) | 0;
  }
  _lua_pushstring(i1, i3) | 0;
  _lua_callk(i1, 1, 2, 0, 0);
  if ((_lua_type(i1, -2) | 0) == 6) {
   break;
  }
  if ((_lua_isstring(i1, -2) | 0) == 0) {
   _lua_settop(i1, -3);
  } else {
   _lua_settop(i1, -2);
   _luaL_addvalue(i4);
  }
  i6 = i6 + 1 | 0;
 }
 _lua_pushstring(i1, i3) | 0;
 _lua_insert(i1, -2);
 _lua_callk(i1, 2, 1, 0, 0);
 if ((_lua_type(i1, -1) | 0) != 0) {
  _lua_setfield(i1, 2, i3);
 }
 _lua_getfield(i1, 2, i3);
 if ((_lua_type(i1, -1) | 0) != 0) {
  STACKTOP = i2;
  return 1;
 }
 _lua_pushboolean(i1, 1);
 _lua_pushvalue(i1, -1);
 _lua_setfield(i1, 2, i3);
 STACKTOP = i2;
 return 1;
}
function _f_parser(i1, i3) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = i2;
 i5 = HEAP32[i3 >> 2] | 0;
 i8 = HEAP32[i5 >> 2] | 0;
 HEAP32[i5 >> 2] = i8 + -1;
 if ((i8 | 0) == 0) {
  i6 = _luaZ_fill(i5) | 0;
 } else {
  i8 = i5 + 4 | 0;
  i6 = HEAP32[i8 >> 2] | 0;
  HEAP32[i8 >> 2] = i6 + 1;
  i6 = HEAPU8[i6] | 0;
 }
 i5 = HEAP32[i3 + 52 >> 2] | 0;
 i7 = (i5 | 0) == 0;
 if ((i6 | 0) == 27) {
  if (!i7 ? (_strchr(i5, 98) | 0) == 0 : 0) {
   HEAP32[i4 >> 2] = 2360;
   HEAP32[i4 + 4 >> 2] = i5;
   _luaO_pushfstring(i1, 2376, i4) | 0;
   _luaD_throw(i1, 3);
  }
  i8 = _luaU_undump(i1, HEAP32[i3 >> 2] | 0, i3 + 4 | 0, HEAP32[i3 + 56 >> 2] | 0) | 0;
 } else {
  if (!i7 ? (_strchr(i5, 116) | 0) == 0 : 0) {
   HEAP32[i4 >> 2] = 2368;
   HEAP32[i4 + 4 >> 2] = i5;
   _luaO_pushfstring(i1, 2376, i4) | 0;
   _luaD_throw(i1, 3);
  }
  i8 = _luaY_parser(i1, HEAP32[i3 >> 2] | 0, i3 + 4 | 0, i3 + 16 | 0, HEAP32[i3 + 56 >> 2] | 0, i6) | 0;
 }
 i7 = i8 + 6 | 0;
 if ((HEAP8[i7] | 0) == 0) {
  STACKTOP = i2;
  return;
 }
 i5 = i8 + 16 | 0;
 i6 = i8 + 5 | 0;
 i4 = 0;
 do {
  i3 = _luaF_newupval(i1) | 0;
  HEAP32[i5 + (i4 << 2) >> 2] = i3;
  if (!((HEAP8[i3 + 5 | 0] & 3) == 0) ? !((HEAP8[i6] & 4) == 0) : 0) {
   _luaC_barrier_(i1, i8, i3);
  }
  i4 = i4 + 1 | 0;
 } while ((i4 | 0) < (HEAPU8[i7] | 0));
 STACKTOP = i2;
 return;
}
function _str_rep(i9) {
 i9 = i9 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i10 = 0, i11 = 0, i12 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 1056 | 0;
 i4 = i6;
 i2 = i6 + 1044 | 0;
 i3 = i6 + 1040 | 0;
 i1 = _luaL_checklstring(i9, 1, i2) | 0;
 i8 = _luaL_checkinteger(i9, 2) | 0;
 i5 = _luaL_optlstring(i9, 3, 7040, i3) | 0;
 if ((i8 | 0) < 1) {
  _lua_pushlstring(i9, 7040, 0) | 0;
  i12 = 1;
  STACKTOP = i6;
  return i12 | 0;
 }
 i7 = HEAP32[i2 >> 2] | 0;
 i10 = HEAP32[i3 >> 2] | 0;
 i11 = i10 + i7 | 0;
 if (!(i11 >>> 0 < i7 >>> 0) ? i11 >>> 0 < (2147483647 / (i8 >>> 0) | 0) >>> 0 : 0) {
  i7 = (Math_imul(i10, i8 + -1 | 0) | 0) + (Math_imul(i7, i8) | 0) | 0;
  i11 = _luaL_buffinitsize(i9, i4, i7) | 0;
  _memcpy(i11 | 0, i1 | 0, HEAP32[i2 >> 2] | 0) | 0;
  if ((i8 | 0) > 1) {
   while (1) {
    i8 = i8 + -1 | 0;
    i9 = HEAP32[i2 >> 2] | 0;
    i10 = i11 + i9 | 0;
    i12 = HEAP32[i3 >> 2] | 0;
    if ((i12 | 0) == 0) {
     i12 = i9;
    } else {
     _memcpy(i10 | 0, i5 | 0, i12 | 0) | 0;
     i12 = HEAP32[i2 >> 2] | 0;
     i10 = i11 + ((HEAP32[i3 >> 2] | 0) + i9) | 0;
    }
    _memcpy(i10 | 0, i1 | 0, i12 | 0) | 0;
    if ((i8 | 0) <= 1) {
     break;
    } else {
     i11 = i10;
    }
   }
  }
  _luaL_pushresultsize(i4, i7);
  i12 = 1;
  STACKTOP = i6;
  return i12 | 0;
 }
 i12 = _luaL_error(i9, 7168, i4) | 0;
 STACKTOP = i6;
 return i12 | 0;
}
function ___strchrnul(i6, i2) {
 i6 = i6 | 0;
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0;
 i1 = STACKTOP;
 i3 = i2 & 255;
 if ((i3 | 0) == 0) {
  i7 = i6 + (_strlen(i6 | 0) | 0) | 0;
  STACKTOP = i1;
  return i7 | 0;
 }
 L5 : do {
  if ((i6 & 3 | 0) != 0) {
   i4 = i2 & 255;
   while (1) {
    i5 = HEAP8[i6] | 0;
    if (i5 << 24 >> 24 == 0) {
     i4 = i6;
     i5 = 13;
     break;
    }
    i7 = i6 + 1 | 0;
    if (i5 << 24 >> 24 == i4 << 24 >> 24) {
     i4 = i6;
     i5 = 13;
     break;
    }
    if ((i7 & 3 | 0) == 0) {
     i4 = i7;
     break L5;
    } else {
     i6 = i7;
    }
   }
   if ((i5 | 0) == 13) {
    STACKTOP = i1;
    return i4 | 0;
   }
  } else {
   i4 = i6;
  }
 } while (0);
 i3 = Math_imul(i3, 16843009) | 0;
 i6 = HEAP32[i4 >> 2] | 0;
 L15 : do {
  if (((i6 & -2139062144 ^ -2139062144) & i6 + -16843009 | 0) == 0) {
   while (1) {
    i7 = i6 ^ i3;
    i5 = i4 + 4 | 0;
    if (((i7 & -2139062144 ^ -2139062144) & i7 + -16843009 | 0) != 0) {
     break L15;
    }
    i6 = HEAP32[i5 >> 2] | 0;
    if (((i6 & -2139062144 ^ -2139062144) & i6 + -16843009 | 0) == 0) {
     i4 = i5;
    } else {
     i4 = i5;
     break;
    }
   }
  }
 } while (0);
 i2 = i2 & 255;
 while (1) {
  i7 = HEAP8[i4] | 0;
  if (i7 << 24 >> 24 == 0 | i7 << 24 >> 24 == i2 << 24 >> 24) {
   break;
  } else {
   i4 = i4 + 1 | 0;
  }
 }
 STACKTOP = i1;
 return i4 | 0;
}
function _lua_replace(i2, i6) {
 i2 = i2 | 0;
 i6 = i6 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i3 = STACKTOP;
 i7 = i2 + 8 | 0;
 i9 = HEAP32[i7 >> 2] | 0;
 i5 = i9 + -16 | 0;
 i4 = i2 + 16 | 0;
 i12 = HEAP32[i4 >> 2] | 0;
 do {
  if ((i6 | 0) <= 0) {
   if (!((i6 | 0) < -1000999)) {
    i10 = i9 + (i6 << 4) | 0;
    break;
   }
   if ((i6 | 0) == -1001e3) {
    i10 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i11 = -1001e3 - i6 | 0;
   i12 = HEAP32[i12 >> 2] | 0;
   if ((HEAP32[i12 + 8 >> 2] | 0) != 22 ? (i10 = HEAP32[i12 >> 2] | 0, (i11 | 0) <= (HEAPU8[i10 + 6 | 0] | 0 | 0)) : 0) {
    i10 = i10 + (i11 + -1 << 4) + 16 | 0;
   } else {
    i10 = 5192;
   }
  } else {
   i10 = (HEAP32[i12 >> 2] | 0) + (i6 << 4) | 0;
   i10 = i10 >>> 0 < i9 >>> 0 ? i10 : 5192;
  }
 } while (0);
 i13 = i5;
 i11 = HEAP32[i13 + 4 >> 2] | 0;
 i12 = i10;
 HEAP32[i12 >> 2] = HEAP32[i13 >> 2];
 HEAP32[i12 + 4 >> 2] = i11;
 i9 = i9 + -8 | 0;
 HEAP32[i10 + 8 >> 2] = HEAP32[i9 >> 2];
 if ((((i6 | 0) < -1001e3 ? (HEAP32[i9 >> 2] & 64 | 0) != 0 : 0) ? (i1 = HEAP32[i5 >> 2] | 0, !((HEAP8[i1 + 5 | 0] & 3) == 0)) : 0) ? (i8 = HEAP32[HEAP32[HEAP32[i4 >> 2] >> 2] >> 2] | 0, !((HEAP8[i8 + 5 | 0] & 4) == 0)) : 0) {
  _luaC_barrier_(i2, i8, i1);
 }
 HEAP32[i7 >> 2] = (HEAP32[i7 >> 2] | 0) + -16;
 STACKTOP = i3;
 return;
}
function _memchr(i4, i3, i6) {
 i4 = i4 | 0;
 i3 = i3 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i5 = 0, i7 = 0;
 i1 = STACKTOP;
 i2 = i3 & 255;
 i7 = (i6 | 0) == 0;
 L1 : do {
  if ((i4 & 3 | 0) == 0 | i7) {
   i5 = i6;
   i6 = 5;
  } else {
   i5 = i3 & 255;
   while (1) {
    if ((HEAP8[i4] | 0) == i5 << 24 >> 24) {
     i5 = i6;
     i6 = 6;
     break L1;
    }
    i4 = i4 + 1 | 0;
    i6 = i6 + -1 | 0;
    i7 = (i6 | 0) == 0;
    if ((i4 & 3 | 0) == 0 | i7) {
     i5 = i6;
     i6 = 5;
     break;
    }
   }
  }
 } while (0);
 if ((i6 | 0) == 5) {
  if (i7) {
   i5 = 0;
  } else {
   i6 = 6;
  }
 }
 L8 : do {
  if ((i6 | 0) == 6) {
   i3 = i3 & 255;
   if (!((HEAP8[i4] | 0) == i3 << 24 >> 24)) {
    i2 = Math_imul(i2, 16843009) | 0;
    L11 : do {
     if (i5 >>> 0 > 3) {
      do {
       i7 = HEAP32[i4 >> 2] ^ i2;
       if (((i7 & -2139062144 ^ -2139062144) & i7 + -16843009 | 0) != 0) {
        break L11;
       }
       i4 = i4 + 4 | 0;
       i5 = i5 + -4 | 0;
      } while (i5 >>> 0 > 3);
     }
    } while (0);
    if ((i5 | 0) == 0) {
     i5 = 0;
    } else {
     while (1) {
      if ((HEAP8[i4] | 0) == i3 << 24 >> 24) {
       break L8;
      }
      i4 = i4 + 1 | 0;
      i5 = i5 + -1 | 0;
      if ((i5 | 0) == 0) {
       i5 = 0;
       break;
      }
     }
    }
   }
  }
 } while (0);
 STACKTOP = i1;
 return ((i5 | 0) != 0 ? i4 : 0) | 0;
}
function _lua_insert(i2, i5) {
 i2 = i2 | 0;
 i5 = i5 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i6 = 0, i7 = 0, i8 = 0;
 i1 = STACKTOP;
 i4 = HEAP32[i2 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i3 = (HEAP32[i2 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i3 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i4 >> 2] | 0, (i5 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i3 = i3 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i3 = 5192;
   }
  } else {
   i3 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i3 = i3 >>> 0 < (HEAP32[i2 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i2 = i2 + 8 | 0;
 i4 = HEAP32[i2 >> 2] | 0;
 if (i4 >>> 0 > i3 >>> 0) {
  while (1) {
   i5 = i4 + -16 | 0;
   i8 = i5;
   i7 = HEAP32[i8 + 4 >> 2] | 0;
   i6 = i4;
   HEAP32[i6 >> 2] = HEAP32[i8 >> 2];
   HEAP32[i6 + 4 >> 2] = i7;
   HEAP32[i4 + 8 >> 2] = HEAP32[i4 + -8 >> 2];
   if (i5 >>> 0 > i3 >>> 0) {
    i4 = i5;
   } else {
    break;
   }
  }
  i4 = HEAP32[i2 >> 2] | 0;
 }
 i6 = i4;
 i7 = HEAP32[i6 + 4 >> 2] | 0;
 i8 = i3;
 HEAP32[i8 >> 2] = HEAP32[i6 >> 2];
 HEAP32[i8 + 4 >> 2] = i7;
 HEAP32[i3 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
 STACKTOP = i1;
 return;
}
function _findlocal(i6, i4, i1, i2) {
 i6 = i6 | 0;
 i4 = i4 | 0;
 i1 = i1 | 0;
 i2 = i2 | 0;
 var i3 = 0, i5 = 0, i7 = 0, i8 = 0;
 i3 = STACKTOP;
 do {
  if ((HEAP8[i4 + 18 | 0] & 1) == 0) {
   i7 = (HEAP32[i4 >> 2] | 0) + 16 | 0;
   i5 = 7;
  } else {
   if ((i1 | 0) >= 0) {
    i8 = HEAP32[i4 + 24 >> 2] | 0;
    i7 = HEAP32[(HEAP32[HEAP32[i4 >> 2] >> 2] | 0) + 12 >> 2] | 0;
    i7 = _luaF_getlocalname(i7, i1, ((HEAP32[i4 + 28 >> 2] | 0) - (HEAP32[i7 + 12 >> 2] | 0) >> 2) + -1 | 0) | 0;
    if ((i7 | 0) == 0) {
     i7 = i8;
     i5 = 7;
     break;
    } else {
     break;
    }
   }
   i5 = HEAP32[i4 >> 2] | 0;
   i6 = HEAPU8[(HEAP32[(HEAP32[i5 >> 2] | 0) + 12 >> 2] | 0) + 76 | 0] | 0;
   if ((((HEAP32[i4 + 24 >> 2] | 0) - i5 >> 4) - i6 | 0) <= (0 - i1 | 0)) {
    i8 = 0;
    STACKTOP = i3;
    return i8 | 0;
   }
   HEAP32[i2 >> 2] = i5 + (i6 - i1 << 4);
   i8 = 2208;
   STACKTOP = i3;
   return i8 | 0;
  }
 } while (0);
 if ((i5 | 0) == 7) {
  if ((HEAP32[i6 + 16 >> 2] | 0) == (i4 | 0)) {
   i4 = i6 + 8 | 0;
  } else {
   i4 = HEAP32[i4 + 12 >> 2] | 0;
  }
  if (((HEAP32[i4 >> 2] | 0) - i7 >> 4 | 0) >= (i1 | 0) & (i1 | 0) > 0) {
   i8 = i7;
   i7 = 2192;
  } else {
   i8 = 0;
   STACKTOP = i3;
   return i8 | 0;
  }
 }
 HEAP32[i2 >> 2] = i8 + (i1 + -1 << 4);
 i8 = i7;
 STACKTOP = i3;
 return i8 | 0;
}
function _luaH_setint(i4, i5, i6, i1) {
 i4 = i4 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, d7 = 0.0, i8 = 0, i9 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i8 = i2 + 16 | 0;
 i3 = i2;
 i9 = i6 + -1 | 0;
 L1 : do {
  if (i9 >>> 0 < (HEAP32[i5 + 28 >> 2] | 0) >>> 0) {
   i9 = (HEAP32[i5 + 12 >> 2] | 0) + (i9 << 4) | 0;
   i8 = 10;
  } else {
   d7 = +(i6 | 0);
   HEAPF64[i8 >> 3] = d7 + 1.0;
   i8 = (HEAP32[i8 + 4 >> 2] | 0) + (HEAP32[i8 >> 2] | 0) | 0;
   if ((i8 | 0) < 0) {
    i9 = 0 - i8 | 0;
    i8 = (i8 | 0) == (i9 | 0) ? 0 : i9;
   }
   i9 = (HEAP32[i5 + 16 >> 2] | 0) + (((i8 | 0) % ((1 << (HEAPU8[i5 + 7 | 0] | 0)) + -1 | 1 | 0) | 0) << 5) | 0;
   while (1) {
    if ((HEAP32[i9 + 24 >> 2] | 0) == 3 ? +HEAPF64[i9 + 16 >> 3] == d7 : 0) {
     break;
    }
    i9 = HEAP32[i9 + 28 >> 2] | 0;
    if ((i9 | 0) == 0) {
     i8 = 12;
     break L1;
    }
   }
   i8 = 10;
  }
 } while (0);
 if ((i8 | 0) == 10) {
  if ((i9 | 0) == 5192) {
   d7 = +(i6 | 0);
   i8 = 12;
  }
 }
 if ((i8 | 0) == 12) {
  HEAPF64[i3 >> 3] = d7;
  HEAP32[i3 + 8 >> 2] = 3;
  i9 = _luaH_newkey(i4, i5, i3) | 0;
 }
 i5 = i1;
 i6 = HEAP32[i5 + 4 >> 2] | 0;
 i8 = i9;
 HEAP32[i8 >> 2] = HEAP32[i5 >> 2];
 HEAP32[i8 + 4 >> 2] = i6;
 HEAP32[i9 + 8 >> 2] = HEAP32[i1 + 8 >> 2];
 STACKTOP = i2;
 return;
}
function _lua_tounsignedx(i6, i8, i1) {
 i6 = i6 | 0;
 i8 = i8 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i4 = i2 + 8 | 0;
 i3 = i2;
 i7 = HEAP32[i6 + 16 >> 2] | 0;
 do {
  if ((i8 | 0) <= 0) {
   if (!((i8 | 0) < -1000999)) {
    i5 = (HEAP32[i6 + 8 >> 2] | 0) + (i8 << 4) | 0;
    break;
   }
   if ((i8 | 0) == -1001e3) {
    i5 = (HEAP32[i6 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i6 = -1001e3 - i8 | 0;
   i7 = HEAP32[i7 >> 2] | 0;
   if ((HEAP32[i7 + 8 >> 2] | 0) != 22 ? (i5 = HEAP32[i7 >> 2] | 0, (i6 | 0) <= (HEAPU8[i5 + 6 | 0] | 0 | 0)) : 0) {
    i5 = i5 + (i6 + -1 << 4) + 16 | 0;
   } else {
    i5 = 5192;
   }
  } else {
   i5 = (HEAP32[i7 >> 2] | 0) + (i8 << 4) | 0;
   i5 = i5 >>> 0 < (HEAP32[i6 + 8 >> 2] | 0) >>> 0 ? i5 : 5192;
  }
 } while (0);
 if ((HEAP32[i5 + 8 >> 2] | 0) != 3) {
  i5 = _luaV_tonumber(i5, i4) | 0;
  if ((i5 | 0) == 0) {
   if ((i1 | 0) == 0) {
    i8 = 0;
    STACKTOP = i2;
    return i8 | 0;
   }
   HEAP32[i1 >> 2] = 0;
   i8 = 0;
   STACKTOP = i2;
   return i8 | 0;
  }
 }
 HEAPF64[i3 >> 3] = +HEAPF64[i5 >> 3] + 6755399441055744.0;
 i3 = HEAP32[i3 >> 2] | 0;
 if ((i1 | 0) == 0) {
  i8 = i3;
  STACKTOP = i2;
  return i8 | 0;
 }
 HEAP32[i1 >> 2] = 1;
 i8 = i3;
 STACKTOP = i2;
 return i8 | 0;
}
function _luaC_freeallobjects(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 i5 = i1 + 12 | 0;
 i3 = HEAP32[i5 >> 2] | 0;
 i7 = i3 + 104 | 0;
 while (1) {
  i4 = HEAP32[i7 >> 2] | 0;
  if ((i4 | 0) == 0) {
   break;
  } else {
   i7 = i4;
  }
 }
 i4 = i3 + 72 | 0;
 i6 = HEAP32[i4 >> 2] | 0;
 if ((i6 | 0) == 0) {
  i5 = i3;
 } else {
  while (1) {
   i8 = i6 + 5 | 0;
   HEAP8[i8] = HEAPU8[i8] | 0 | 8;
   HEAP32[i4 >> 2] = HEAP32[i6 >> 2];
   HEAP32[i6 >> 2] = HEAP32[i7 >> 2];
   HEAP32[i7 >> 2] = i6;
   i7 = HEAP32[i4 >> 2] | 0;
   if ((i7 | 0) == 0) {
    break;
   } else {
    i8 = i6;
    i6 = i7;
    i7 = i8;
   }
  }
  i5 = HEAP32[i5 >> 2] | 0;
 }
 i5 = i5 + 104 | 0;
 i6 = HEAP32[i5 >> 2] | 0;
 if ((i6 | 0) != 0) {
  do {
   i8 = i6 + 5 | 0;
   HEAP8[i8] = HEAP8[i8] & 191;
   _GCTM(i1, 0);
   i6 = HEAP32[i5 >> 2] | 0;
  } while ((i6 | 0) != 0);
 }
 HEAP8[i3 + 60 | 0] = 3;
 HEAP8[i3 + 62 | 0] = 0;
 _sweeplist(i1, i4, -3) | 0;
 _sweeplist(i1, i3 + 68 | 0, -3) | 0;
 i4 = i3 + 32 | 0;
 if ((HEAP32[i4 >> 2] | 0) <= 0) {
  STACKTOP = i2;
  return;
 }
 i3 = i3 + 24 | 0;
 i5 = 0;
 do {
  _sweeplist(i1, (HEAP32[i3 >> 2] | 0) + (i5 << 2) | 0, -3) | 0;
  i5 = i5 + 1 | 0;
 } while ((i5 | 0) < (HEAP32[i4 >> 2] | 0));
 STACKTOP = i2;
 return;
}
function _strspn(i1, i5) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i3 = i2;
 HEAP32[i3 + 0 >> 2] = 0;
 HEAP32[i3 + 4 >> 2] = 0;
 HEAP32[i3 + 8 >> 2] = 0;
 HEAP32[i3 + 12 >> 2] = 0;
 HEAP32[i3 + 16 >> 2] = 0;
 HEAP32[i3 + 20 >> 2] = 0;
 HEAP32[i3 + 24 >> 2] = 0;
 HEAP32[i3 + 28 >> 2] = 0;
 i4 = HEAP8[i5] | 0;
 if (i4 << 24 >> 24 == 0) {
  i6 = 0;
  STACKTOP = i2;
  return i6 | 0;
 }
 if ((HEAP8[i5 + 1 | 0] | 0) == 0) {
  i3 = i1;
  while (1) {
   if ((HEAP8[i3] | 0) == i4 << 24 >> 24) {
    i3 = i3 + 1 | 0;
   } else {
    break;
   }
  }
  i6 = i3 - i1 | 0;
  STACKTOP = i2;
  return i6 | 0;
 }
 do {
  i7 = i4 & 255;
  i6 = i3 + (i7 >>> 5 << 2) | 0;
  HEAP32[i6 >> 2] = HEAP32[i6 >> 2] | 1 << (i7 & 31);
  i5 = i5 + 1 | 0;
  i4 = HEAP8[i5] | 0;
 } while (!(i4 << 24 >> 24 == 0));
 i5 = HEAP8[i1] | 0;
 L12 : do {
  if (i5 << 24 >> 24 == 0) {
   i4 = i1;
  } else {
   i4 = i1;
   while (1) {
    i7 = i5 & 255;
    i6 = i4 + 1 | 0;
    if ((HEAP32[i3 + (i7 >>> 5 << 2) >> 2] & 1 << (i7 & 31) | 0) == 0) {
     break L12;
    }
    i5 = HEAP8[i6] | 0;
    if (i5 << 24 >> 24 == 0) {
     i4 = i6;
     break;
    } else {
     i4 = i6;
    }
   }
  }
 } while (0);
 i7 = i4 - i1 | 0;
 STACKTOP = i2;
 return i7 | 0;
}
function _lua_remove(i2, i4) {
 i2 = i2 | 0;
 i4 = i4 | 0;
 var i1 = 0, i3 = 0, i5 = 0, i6 = 0, i7 = 0;
 i1 = STACKTOP;
 i5 = HEAP32[i2 + 16 >> 2] | 0;
 do {
  if ((i4 | 0) <= 0) {
   if (!((i4 | 0) < -1000999)) {
    i3 = (HEAP32[i2 + 8 >> 2] | 0) + (i4 << 4) | 0;
    break;
   }
   if ((i4 | 0) == -1001e3) {
    i3 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i4 = -1001e3 - i4 | 0;
   i5 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i5 >> 2] | 0, (i4 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i3 = i3 + (i4 + -1 << 4) + 16 | 0;
   } else {
    i3 = 5192;
   }
  } else {
   i3 = (HEAP32[i5 >> 2] | 0) + (i4 << 4) | 0;
   i3 = i3 >>> 0 < (HEAP32[i2 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i4 = i3 + 16 | 0;
 i2 = i2 + 8 | 0;
 i5 = HEAP32[i2 >> 2] | 0;
 if (!(i4 >>> 0 < i5 >>> 0)) {
  i5 = i5 + -16 | 0;
  HEAP32[i2 >> 2] = i5;
  STACKTOP = i1;
  return;
 }
 while (1) {
  i7 = i4;
  i6 = HEAP32[i7 + 4 >> 2] | 0;
  i5 = i3;
  HEAP32[i5 >> 2] = HEAP32[i7 >> 2];
  HEAP32[i5 + 4 >> 2] = i6;
  HEAP32[i3 + 8 >> 2] = HEAP32[i3 + 24 >> 2];
  i5 = i4 + 16 | 0;
  i3 = HEAP32[i2 >> 2] | 0;
  if (i5 >>> 0 < i3 >>> 0) {
   i3 = i4;
   i4 = i5;
  } else {
   break;
  }
 }
 i7 = i3 + -16 | 0;
 HEAP32[i2 >> 2] = i7;
 STACKTOP = i1;
 return;
}
function _luaD_protectedparser(i1, i4, i3, i2) {
 i1 = i1 | 0;
 i4 = i4 | 0;
 i3 = i3 | 0;
 i2 = i2 | 0;
 var i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 64 | 0;
 i13 = i5;
 i6 = i1 + 36 | 0;
 HEAP16[i6 >> 1] = (HEAP16[i6 >> 1] | 0) + 1 << 16 >> 16;
 HEAP32[i13 >> 2] = i4;
 HEAP32[i13 + 56 >> 2] = i3;
 HEAP32[i13 + 52 >> 2] = i2;
 i10 = i13 + 16 | 0;
 HEAP32[i10 >> 2] = 0;
 i9 = i13 + 24 | 0;
 HEAP32[i9 >> 2] = 0;
 i8 = i13 + 28 | 0;
 HEAP32[i8 >> 2] = 0;
 i7 = i13 + 36 | 0;
 HEAP32[i7 >> 2] = 0;
 i2 = i13 + 40 | 0;
 HEAP32[i2 >> 2] = 0;
 i3 = i13 + 48 | 0;
 HEAP32[i3 >> 2] = 0;
 i12 = i13 + 4 | 0;
 HEAP32[i12 >> 2] = 0;
 i11 = i13 + 12 | 0;
 HEAP32[i11 >> 2] = 0;
 i4 = _luaD_pcall(i1, 6, i13, (HEAP32[i1 + 8 >> 2] | 0) - (HEAP32[i1 + 28 >> 2] | 0) | 0, HEAP32[i1 + 68 >> 2] | 0) | 0;
 HEAP32[i12 >> 2] = _luaM_realloc_(i1, HEAP32[i12 >> 2] | 0, HEAP32[i11 >> 2] | 0, 0) | 0;
 HEAP32[i11 >> 2] = 0;
 _luaM_realloc_(i1, HEAP32[i10 >> 2] | 0, HEAP32[i9 >> 2] << 1, 0) | 0;
 _luaM_realloc_(i1, HEAP32[i8 >> 2] | 0, HEAP32[i7 >> 2] << 4, 0) | 0;
 _luaM_realloc_(i1, HEAP32[i2 >> 2] | 0, HEAP32[i3 >> 2] << 4, 0) | 0;
 HEAP16[i6 >> 1] = (HEAP16[i6 >> 1] | 0) + -1 << 16 >> 16;
 STACKTOP = i5;
 return i4 | 0;
}
function _markmt(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0;
 i2 = STACKTOP;
 i3 = HEAP32[i1 + 252 >> 2] | 0;
 if ((i3 | 0) != 0 ? !((HEAP8[i3 + 5 | 0] & 3) == 0) : 0) {
  _reallymarkobject(i1, i3);
 }
 i3 = HEAP32[i1 + 256 >> 2] | 0;
 if ((i3 | 0) != 0 ? !((HEAP8[i3 + 5 | 0] & 3) == 0) : 0) {
  _reallymarkobject(i1, i3);
 }
 i3 = HEAP32[i1 + 260 >> 2] | 0;
 if ((i3 | 0) != 0 ? !((HEAP8[i3 + 5 | 0] & 3) == 0) : 0) {
  _reallymarkobject(i1, i3);
 }
 i3 = HEAP32[i1 + 264 >> 2] | 0;
 if ((i3 | 0) != 0 ? !((HEAP8[i3 + 5 | 0] & 3) == 0) : 0) {
  _reallymarkobject(i1, i3);
 }
 i3 = HEAP32[i1 + 268 >> 2] | 0;
 if ((i3 | 0) != 0 ? !((HEAP8[i3 + 5 | 0] & 3) == 0) : 0) {
  _reallymarkobject(i1, i3);
 }
 i3 = HEAP32[i1 + 272 >> 2] | 0;
 if ((i3 | 0) != 0 ? !((HEAP8[i3 + 5 | 0] & 3) == 0) : 0) {
  _reallymarkobject(i1, i3);
 }
 i3 = HEAP32[i1 + 276 >> 2] | 0;
 if ((i3 | 0) != 0 ? !((HEAP8[i3 + 5 | 0] & 3) == 0) : 0) {
  _reallymarkobject(i1, i3);
 }
 i3 = HEAP32[i1 + 280 >> 2] | 0;
 if ((i3 | 0) != 0 ? !((HEAP8[i3 + 5 | 0] & 3) == 0) : 0) {
  _reallymarkobject(i1, i3);
 }
 i3 = HEAP32[i1 + 284 >> 2] | 0;
 if ((i3 | 0) == 0) {
  STACKTOP = i2;
  return;
 }
 if ((HEAP8[i3 + 5 | 0] & 3) == 0) {
  STACKTOP = i2;
  return;
 }
 _reallymarkobject(i1, i3);
 STACKTOP = i2;
 return;
}
function _findlabel(i9, i2) {
 i9 = i9 | 0;
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i10 = 0, i11 = 0, i12 = 0, i13 = 0, i14 = 0, i15 = 0;
 i1 = STACKTOP;
 i3 = i9 + 48 | 0;
 i7 = HEAP32[(HEAP32[i3 >> 2] | 0) + 16 >> 2] | 0;
 i10 = HEAP32[i9 + 64 >> 2] | 0;
 i4 = HEAP32[i10 + 12 >> 2] | 0;
 i6 = i7 + 4 | 0;
 i13 = HEAP16[i6 >> 1] | 0;
 i5 = i10 + 28 | 0;
 if ((i13 | 0) >= (HEAP32[i5 >> 2] | 0)) {
  i15 = 0;
  STACKTOP = i1;
  return i15 | 0;
 }
 i10 = i10 + 24 | 0;
 i11 = i4 + (i2 << 4) | 0;
 while (1) {
  i14 = HEAP32[i10 >> 2] | 0;
  i12 = i14 + (i13 << 4) | 0;
  i15 = i13 + 1 | 0;
  if ((_luaS_eqstr(HEAP32[i12 >> 2] | 0, HEAP32[i11 >> 2] | 0) | 0) != 0) {
   break;
  }
  if ((i15 | 0) < (HEAP32[i5 >> 2] | 0)) {
   i13 = i15;
  } else {
   i2 = 0;
   i8 = 10;
   break;
  }
 }
 if ((i8 | 0) == 10) {
  STACKTOP = i1;
  return i2 | 0;
 }
 i8 = HEAP8[i14 + (i13 << 4) + 12 | 0] | 0;
 do {
  if ((HEAPU8[i4 + (i2 << 4) + 12 | 0] | 0) > (i8 & 255)) {
   if ((HEAP8[i7 + 9 | 0] | 0) == 0 ? (HEAP32[i5 >> 2] | 0) <= (HEAP16[i6 >> 1] | 0) : 0) {
    break;
   }
   _luaK_patchclose(HEAP32[i3 >> 2] | 0, HEAP32[i4 + (i2 << 4) + 4 >> 2] | 0, i8 & 255);
  }
 } while (0);
 _closegoto(i9, i2, i12);
 i15 = 1;
 STACKTOP = i1;
 return i15 | 0;
}
function _lua_getmetatable(i1, i5) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i4 = 0;
 i2 = STACKTOP;
 i4 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i4 = (HEAP32[i1 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i4 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i4 >> 2] | 0, (i5 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i4 = i3 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i4 = 5192;
   }
  } else {
   i3 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i4 = i3 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i3 = HEAP32[i4 + 8 >> 2] & 15;
 if ((i3 | 0) == 7) {
  i3 = HEAP32[(HEAP32[i4 >> 2] | 0) + 8 >> 2] | 0;
 } else if ((i3 | 0) == 5) {
  i3 = HEAP32[(HEAP32[i4 >> 2] | 0) + 8 >> 2] | 0;
 } else {
  i3 = HEAP32[(HEAP32[i1 + 12 >> 2] | 0) + (i3 << 2) + 252 >> 2] | 0;
 }
 if ((i3 | 0) == 0) {
  i5 = 0;
  STACKTOP = i2;
  return i5 | 0;
 }
 i5 = i1 + 8 | 0;
 i4 = HEAP32[i5 >> 2] | 0;
 HEAP32[i4 >> 2] = i3;
 HEAP32[i4 + 8 >> 2] = 69;
 HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + 16;
 i5 = 1;
 STACKTOP = i2;
 return i5 | 0;
}
function _str_byte(i2) {
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0, i10 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i6 = i1;
 i4 = i1 + 4 | 0;
 i3 = _luaL_checklstring(i2, 1, i4) | 0;
 i5 = _luaL_optinteger(i2, 2, 1) | 0;
 i7 = HEAP32[i4 >> 2] | 0;
 if (!((i5 | 0) > -1)) {
  if (i7 >>> 0 < (0 - i5 | 0) >>> 0) {
   i5 = 0;
  } else {
   i5 = i5 + 1 + i7 | 0;
  }
 }
 i8 = _luaL_optinteger(i2, 3, i5) | 0;
 i7 = HEAP32[i4 >> 2] | 0;
 if (!((i8 | 0) > -1)) {
  if (i7 >>> 0 < (0 - i8 | 0) >>> 0) {
   i8 = 0;
  } else {
   i8 = i8 + 1 + i7 | 0;
  }
 }
 i9 = (i5 | 0) == 0 ? 1 : i5;
 i10 = i8 >>> 0 > i7 >>> 0 ? i7 : i8;
 if (i9 >>> 0 > i10 >>> 0) {
  i10 = 0;
  STACKTOP = i1;
  return i10 | 0;
 }
 i4 = i10 - i9 + 1 | 0;
 if ((i10 | 0) == -1) {
  i10 = _luaL_error(i2, 7944, i6) | 0;
  STACKTOP = i1;
  return i10 | 0;
 }
 _luaL_checkstack(i2, i4, 7944);
 if ((i4 | 0) <= 0) {
  i10 = i4;
  STACKTOP = i1;
  return i10 | 0;
 }
 i6 = i9 + -1 | 0;
 i8 = ~i8;
 i7 = ~i7;
 i5 = 0 - (i8 >>> 0 > i7 >>> 0 ? i8 : i7) - (i5 >>> 0 > 1 ? i5 : 1) | 0;
 i7 = 0;
 do {
  _lua_pushinteger(i2, HEAPU8[i3 + (i6 + i7) | 0] | 0);
  i7 = i7 + 1 | 0;
 } while ((i7 | 0) != (i5 | 0));
 STACKTOP = i1;
 return i4 | 0;
}
function _lua_setuservalue(i1, i5) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i6 = 0;
 i3 = STACKTOP;
 i6 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i5 = (HEAP32[i1 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i5 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i6 = HEAP32[i6 >> 2] | 0;
   if ((HEAP32[i6 + 8 >> 2] | 0) != 22 ? (i4 = HEAP32[i6 >> 2] | 0, (i5 | 0) <= (HEAPU8[i4 + 6 | 0] | 0 | 0)) : 0) {
    i5 = i4 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i5 = 5192;
   }
  } else {
   i4 = (HEAP32[i6 >> 2] | 0) + (i5 << 4) | 0;
   i5 = i4 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 i4 = i1 + 8 | 0;
 i6 = HEAP32[i4 >> 2] | 0;
 if ((HEAP32[i6 + -8 >> 2] | 0) != 0) {
  HEAP32[(HEAP32[i5 >> 2] | 0) + 12 >> 2] = HEAP32[i6 + -16 >> 2];
  i6 = HEAP32[(HEAP32[i4 >> 2] | 0) + -16 >> 2] | 0;
  if (!((HEAP8[i6 + 5 | 0] & 3) == 0) ? (i2 = HEAP32[i5 >> 2] | 0, !((HEAP8[i2 + 5 | 0] & 4) == 0)) : 0) {
   _luaC_barrier_(i1, i2, i6);
  }
 } else {
  HEAP32[(HEAP32[i5 >> 2] | 0) + 12 >> 2] = 0;
 }
 HEAP32[i4 >> 2] = (HEAP32[i4 >> 2] | 0) + -16;
 STACKTOP = i3;
 return;
}
function _f_luaopen(i1, i2) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 var i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i5 = i6;
 i4 = HEAP32[i1 + 12 >> 2] | 0;
 i2 = _luaM_realloc_(i1, 0, 0, 640) | 0;
 HEAP32[i1 + 28 >> 2] = i2;
 i3 = i1 + 32 | 0;
 HEAP32[i3 >> 2] = 40;
 i7 = 0;
 do {
  HEAP32[i2 + (i7 << 4) + 8 >> 2] = 0;
  i7 = i7 + 1 | 0;
 } while ((i7 | 0) != 40);
 HEAP32[i1 + 24 >> 2] = i2 + ((HEAP32[i3 >> 2] | 0) + -5 << 4);
 i7 = i1 + 72 | 0;
 HEAP32[i1 + 80 >> 2] = 0;
 HEAP32[i1 + 84 >> 2] = 0;
 HEAP8[i1 + 90 | 0] = 0;
 HEAP32[i7 >> 2] = i2;
 HEAP32[i1 + 8 >> 2] = i2 + 16;
 HEAP32[i2 + 8 >> 2] = 0;
 HEAP32[i1 + 76 >> 2] = i2 + 336;
 HEAP32[i1 + 16 >> 2] = i7;
 i7 = _luaH_new(i1) | 0;
 HEAP32[i4 + 40 >> 2] = i7;
 HEAP32[i4 + 48 >> 2] = 69;
 _luaH_resize(i1, i7, 2, 0);
 HEAP32[i5 >> 2] = i1;
 i3 = i5 + 8 | 0;
 HEAP32[i3 >> 2] = 72;
 _luaH_setint(i1, i7, 1, i5);
 HEAP32[i5 >> 2] = _luaH_new(i1) | 0;
 HEAP32[i3 >> 2] = 69;
 _luaH_setint(i1, i7, 2, i5);
 _luaS_resize(i1, 32);
 _luaT_init(i1);
 _luaX_init(i1);
 i7 = _luaS_newlstr(i1, 6896, 17) | 0;
 HEAP32[i4 + 180 >> 2] = i7;
 i7 = i7 + 5 | 0;
 HEAP8[i7] = HEAPU8[i7] | 0 | 32;
 HEAP8[i4 + 63 | 0] = 1;
 STACKTOP = i6;
 return;
}
function _lua_tointegerx(i6, i7, i1) {
 i6 = i6 | 0;
 i7 = i7 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2;
 i5 = HEAP32[i6 + 16 >> 2] | 0;
 do {
  if ((i7 | 0) <= 0) {
   if (!((i7 | 0) < -1000999)) {
    i4 = (HEAP32[i6 + 8 >> 2] | 0) + (i7 << 4) | 0;
    break;
   }
   if ((i7 | 0) == -1001e3) {
    i4 = (HEAP32[i6 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i6 = -1001e3 - i7 | 0;
   i5 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i4 = HEAP32[i5 >> 2] | 0, (i6 | 0) <= (HEAPU8[i4 + 6 | 0] | 0 | 0)) : 0) {
    i4 = i4 + (i6 + -1 << 4) + 16 | 0;
   } else {
    i4 = 5192;
   }
  } else {
   i4 = (HEAP32[i5 >> 2] | 0) + (i7 << 4) | 0;
   i4 = i4 >>> 0 < (HEAP32[i6 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 if ((HEAP32[i4 + 8 >> 2] | 0) != 3) {
  i4 = _luaV_tonumber(i4, i3) | 0;
  if ((i4 | 0) == 0) {
   if ((i1 | 0) == 0) {
    i7 = 0;
    STACKTOP = i2;
    return i7 | 0;
   }
   HEAP32[i1 >> 2] = 0;
   i7 = 0;
   STACKTOP = i2;
   return i7 | 0;
  }
 }
 i3 = ~~+HEAPF64[i4 >> 3];
 if ((i1 | 0) == 0) {
  i7 = i3;
  STACKTOP = i2;
  return i7 | 0;
 }
 HEAP32[i1 >> 2] = 1;
 i7 = i3;
 STACKTOP = i2;
 return i7 | 0;
}
function _close_state(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 i6 = i1 + 12 | 0;
 i3 = HEAP32[i6 >> 2] | 0;
 i4 = i1 + 28 | 0;
 _luaF_close(i1, HEAP32[i4 >> 2] | 0);
 _luaC_freeallobjects(i1);
 i6 = HEAP32[i6 >> 2] | 0;
 _luaM_realloc_(i1, HEAP32[i6 + 24 >> 2] | 0, HEAP32[i6 + 32 >> 2] << 2, 0) | 0;
 i6 = i3 + 144 | 0;
 i5 = i3 + 152 | 0;
 HEAP32[i6 >> 2] = _luaM_realloc_(i1, HEAP32[i6 >> 2] | 0, HEAP32[i5 >> 2] | 0, 0) | 0;
 HEAP32[i5 >> 2] = 0;
 i5 = HEAP32[i4 >> 2] | 0;
 if ((i5 | 0) == 0) {
  i5 = HEAP32[i3 >> 2] | 0;
  i6 = i3 + 4 | 0;
  i6 = HEAP32[i6 >> 2] | 0;
  FUNCTION_TABLE_iiiii[i5 & 3](i6, i1, 400, 0) | 0;
  STACKTOP = i2;
  return;
 }
 HEAP32[i1 + 16 >> 2] = i1 + 72;
 i7 = i1 + 84 | 0;
 i6 = HEAP32[i7 >> 2] | 0;
 HEAP32[i7 >> 2] = 0;
 if ((i6 | 0) != 0) {
  while (1) {
   i5 = HEAP32[i6 + 12 >> 2] | 0;
   _luaM_realloc_(i1, i6, 40, 0) | 0;
   if ((i5 | 0) == 0) {
    break;
   } else {
    i6 = i5;
   }
  }
  i5 = HEAP32[i4 >> 2] | 0;
 }
 _luaM_realloc_(i1, i5, HEAP32[i1 + 32 >> 2] << 4, 0) | 0;
 i6 = HEAP32[i3 >> 2] | 0;
 i7 = i3 + 4 | 0;
 i7 = HEAP32[i7 >> 2] | 0;
 FUNCTION_TABLE_iiiii[i6 & 3](i7, i1, 400, 0) | 0;
 STACKTOP = i2;
 return;
}
function _ll_module(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 112 | 0;
 i4 = i2;
 i5 = i2 + 4 | 0;
 i6 = _luaL_checklstring(i1, 1, 0) | 0;
 i3 = _lua_gettop(i1) | 0;
 _luaL_pushmodule(i1, i6, 1);
 _lua_getfield(i1, -1, 4728);
 i7 = (_lua_type(i1, -1) | 0) == 0;
 _lua_settop(i1, -2);
 if (i7) {
  _lua_pushvalue(i1, -1);
  _lua_setfield(i1, -2, 4784);
  _lua_pushstring(i1, i6) | 0;
  _lua_setfield(i1, -2, 4728);
  i7 = _strrchr(i6, 46) | 0;
  _lua_pushlstring(i1, i6, ((i7 | 0) == 0 ? i6 : i7 + 1 | 0) - i6 | 0) | 0;
  _lua_setfield(i1, -2, 4792);
 }
 _lua_pushvalue(i1, -1);
 if (!(((_lua_getstack(i1, 1, i5) | 0) != 0 ? (_lua_getinfo(i1, 4736, i5) | 0) != 0 : 0) ? (_lua_iscfunction(i1, -1) | 0) == 0 : 0)) {
  _luaL_error(i1, 4744, i4) | 0;
 }
 _lua_pushvalue(i1, -2);
 _lua_setupvalue(i1, -2, 1) | 0;
 _lua_settop(i1, -2);
 if ((i3 | 0) < 2) {
  STACKTOP = i2;
  return 1;
 } else {
  i4 = 2;
 }
 while (1) {
  if ((_lua_type(i1, i4) | 0) == 6) {
   _lua_pushvalue(i1, i4);
   _lua_pushvalue(i1, -2);
   _lua_callk(i1, 1, 0, 0, 0);
  }
  if ((i4 | 0) == (i3 | 0)) {
   break;
  } else {
   i4 = i4 + 1 | 0;
  }
 }
 STACKTOP = i2;
 return 1;
}
function _strcspn(i2, i5) {
 i2 = i2 | 0;
 i5 = i5 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i6 = 0, i7 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i3 = i1;
 i4 = HEAP8[i5] | 0;
 if (!(i4 << 24 >> 24 == 0) ? (HEAP8[i5 + 1 | 0] | 0) != 0 : 0) {
  HEAP32[i3 + 0 >> 2] = 0;
  HEAP32[i3 + 4 >> 2] = 0;
  HEAP32[i3 + 8 >> 2] = 0;
  HEAP32[i3 + 12 >> 2] = 0;
  HEAP32[i3 + 16 >> 2] = 0;
  HEAP32[i3 + 20 >> 2] = 0;
  HEAP32[i3 + 24 >> 2] = 0;
  HEAP32[i3 + 28 >> 2] = 0;
  do {
   i7 = i4 & 255;
   i6 = i3 + (i7 >>> 5 << 2) | 0;
   HEAP32[i6 >> 2] = HEAP32[i6 >> 2] | 1 << (i7 & 31);
   i5 = i5 + 1 | 0;
   i4 = HEAP8[i5] | 0;
  } while (!(i4 << 24 >> 24 == 0));
  i5 = HEAP8[i2] | 0;
  L7 : do {
   if (i5 << 24 >> 24 == 0) {
    i4 = i2;
   } else {
    i4 = i2;
    while (1) {
     i7 = i5 & 255;
     i6 = i4 + 1 | 0;
     if ((HEAP32[i3 + (i7 >>> 5 << 2) >> 2] & 1 << (i7 & 31) | 0) != 0) {
      break L7;
     }
     i5 = HEAP8[i6] | 0;
     if (i5 << 24 >> 24 == 0) {
      i4 = i6;
      break;
     } else {
      i4 = i6;
     }
    }
   }
  } while (0);
  i7 = i4 - i2 | 0;
  STACKTOP = i1;
  return i7 | 0;
 }
 i7 = (___strchrnul(i2, i4 << 24 >> 24) | 0) - i2 | 0;
 STACKTOP = i1;
 return i7 | 0;
}
function _main(i4, i5) {
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i2 = i1;
 i3 = _luaL_newstate() | 0;
 if ((i3 | 0) == 0) {
  i4 = HEAP32[i5 >> 2] | 0;
  i3 = HEAP32[_stderr >> 2] | 0;
  if ((i4 | 0) != 0) {
   HEAP32[i2 >> 2] = i4;
   _fprintf(i3 | 0, 496, i2 | 0) | 0;
   _fflush(i3 | 0) | 0;
  }
  HEAP32[i2 >> 2] = 8;
  _fprintf(i3 | 0, 912, i2 | 0) | 0;
  _fflush(i3 | 0) | 0;
  i8 = 1;
  STACKTOP = i1;
  return i8 | 0;
 }
 _lua_pushcclosure(i3, 141, 0);
 _lua_pushinteger(i3, i4);
 _lua_pushlightuserdata(i3, i5);
 i6 = _lua_pcallk(i3, 2, 1, 0, 0, 0) | 0;
 i7 = _lua_toboolean(i3, -1) | 0;
 i6 = (i6 | 0) == 0;
 if (!i6) {
  if ((_lua_type(i3, -1) | 0) == 4) {
   i8 = _lua_tolstring(i3, -1, 0) | 0;
  } else {
   i8 = 0;
  }
  i4 = HEAP32[20] | 0;
  i5 = HEAP32[_stderr >> 2] | 0;
  if ((i4 | 0) != 0) {
   HEAP32[i2 >> 2] = i4;
   _fprintf(i5 | 0, 496, i2 | 0) | 0;
   _fflush(i5 | 0) | 0;
  }
  HEAP32[i2 >> 2] = (i8 | 0) == 0 ? 48 : i8;
  _fprintf(i5 | 0, 912, i2 | 0) | 0;
  _fflush(i5 | 0) | 0;
  _lua_settop(i3, -2);
 }
 _lua_close(i3);
 i8 = i6 & (i7 | 0) != 0 & 1 ^ 1;
 STACKTOP = i1;
 return i8 | 0;
}
function _db_sethook(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0;
 i4 = STACKTOP;
 if ((_lua_type(i1, 1) | 0) == 8) {
  i2 = _lua_tothread(i1, 1) | 0;
  i5 = 1;
 } else {
  i2 = i1;
  i5 = 0;
 }
 i3 = i5 + 1 | 0;
 if ((_lua_type(i1, i3) | 0) < 1) {
  _lua_settop(i1, i3);
  i6 = 0;
  i7 = 0;
  i5 = 0;
 } else {
  i6 = _luaL_checklstring(i1, i5 | 2, 0) | 0;
  _luaL_checktype(i1, i3, 6);
  i5 = _luaL_optinteger(i1, i5 + 3 | 0, 0) | 0;
  i7 = (_strchr(i6, 99) | 0) != 0 | 0;
  i8 = (_strchr(i6, 114) | 0) == 0;
  i7 = i8 ? i7 : i7 | 2;
  i8 = (_strchr(i6, 108) | 0) == 0;
  i8 = i8 ? i7 : i7 | 4;
  i6 = i5;
  i7 = 9;
  i5 = (i5 | 0) > 0 ? i8 | 8 : i8;
 }
 if ((_luaL_getsubtable(i1, -1001e3, 11584) | 0) != 0) {
  _lua_pushthread(i2) | 0;
  _lua_xmove(i2, i1, 1);
  _lua_pushvalue(i1, i3);
  _lua_rawset(i1, -3);
  _lua_sethook(i2, i7, i5, i6) | 0;
  STACKTOP = i4;
  return 0;
 }
 _lua_pushstring(i1, 11592) | 0;
 _lua_setfield(i1, -2, 11600);
 _lua_pushvalue(i1, -1);
 _lua_setmetatable(i1, -2) | 0;
 _lua_pushthread(i2) | 0;
 _lua_xmove(i2, i1, 1);
 _lua_pushvalue(i1, i3);
 _lua_rawset(i1, -3);
 _lua_sethook(i2, i7, i5, i6) | 0;
 STACKTOP = i4;
 return 0;
}
function _tconcat(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 1056 | 0;
 i6 = i3;
 i2 = i3 + 16 | 0;
 i5 = i3 + 8 | 0;
 i4 = _luaL_optlstring(i1, 2, 8208, i5) | 0;
 _luaL_checktype(i1, 1, 5);
 i8 = _luaL_optinteger(i1, 3, 1) | 0;
 if ((_lua_type(i1, 4) | 0) < 1) {
  i7 = _luaL_len(i1, 1) | 0;
 } else {
  i7 = _luaL_checkinteger(i1, 4) | 0;
 }
 _luaL_buffinit(i1, i2);
 if ((i8 | 0) >= (i7 | 0)) {
  if ((i8 | 0) != (i7 | 0)) {
   _luaL_pushresult(i2);
   STACKTOP = i3;
   return 1;
  }
 } else {
  do {
   _lua_rawgeti(i1, 1, i8);
   if ((_lua_isstring(i1, -1) | 0) == 0) {
    HEAP32[i6 >> 2] = _lua_typename(i1, _lua_type(i1, -1) | 0) | 0;
    HEAP32[i6 + 4 >> 2] = i8;
    _luaL_error(i1, 8360, i6) | 0;
   }
   _luaL_addvalue(i2);
   _luaL_addlstring(i2, i4, HEAP32[i5 >> 2] | 0);
   i8 = i8 + 1 | 0;
  } while ((i8 | 0) != (i7 | 0));
 }
 _lua_rawgeti(i1, 1, i7);
 if ((_lua_isstring(i1, -1) | 0) == 0) {
  HEAP32[i6 >> 2] = _lua_typename(i1, _lua_type(i1, -1) | 0) | 0;
  HEAP32[i6 + 4 >> 2] = i7;
  _luaL_error(i1, 8360, i6) | 0;
 }
 _luaL_addvalue(i2);
 _luaL_pushresult(i2);
 STACKTOP = i3;
 return 1;
}
function _searcher_Croot(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2;
 i4 = _luaL_checklstring(i1, 1, 0) | 0;
 i5 = _strchr(i4, 46) | 0;
 if ((i5 | 0) == 0) {
  i6 = 0;
  STACKTOP = i2;
  return i6 | 0;
 }
 _lua_pushlstring(i1, i4, i5 - i4 | 0) | 0;
 i5 = _lua_tolstring(i1, -1, 0) | 0;
 _lua_getfield(i1, -1001001, 4440);
 i6 = _lua_tolstring(i1, -1, 0) | 0;
 if ((i6 | 0) == 0) {
  HEAP32[i3 >> 2] = 4440;
  _luaL_error(i1, 5032, i3) | 0;
 }
 i5 = _searchpath(i1, i5, i6, 4936, 4848) | 0;
 if ((i5 | 0) == 0) {
  i6 = 1;
  STACKTOP = i2;
  return i6 | 0;
 }
 i6 = _loadfunc(i1, i5, i4) | 0;
 if ((i6 | 0) == 2) {
  HEAP32[i3 >> 2] = i4;
  HEAP32[i3 + 4 >> 2] = i5;
  _lua_pushfstring(i1, 4856, i3) | 0;
  i6 = 1;
  STACKTOP = i2;
  return i6 | 0;
 } else if ((i6 | 0) == 0) {
  _lua_pushstring(i1, i5) | 0;
  i6 = 2;
  STACKTOP = i2;
  return i6 | 0;
 } else {
  i4 = _lua_tolstring(i1, 1, 0) | 0;
  i6 = _lua_tolstring(i1, -1, 0) | 0;
  HEAP32[i3 >> 2] = i4;
  HEAP32[i3 + 4 >> 2] = i5;
  HEAP32[i3 + 8 >> 2] = i6;
  i6 = _luaL_error(i1, 4888, i3) | 0;
  STACKTOP = i2;
  return i6 | 0;
 }
 return 0;
}
function _lua_tonumberx(i5, i7, i1) {
 i5 = i5 | 0;
 i7 = i7 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i6 = 0, d8 = 0.0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2;
 i6 = HEAP32[i5 + 16 >> 2] | 0;
 do {
  if ((i7 | 0) <= 0) {
   if (!((i7 | 0) < -1000999)) {
    i4 = (HEAP32[i5 + 8 >> 2] | 0) + (i7 << 4) | 0;
    break;
   }
   if ((i7 | 0) == -1001e3) {
    i4 = (HEAP32[i5 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i7 | 0;
   i6 = HEAP32[i6 >> 2] | 0;
   if ((HEAP32[i6 + 8 >> 2] | 0) != 22 ? (i4 = HEAP32[i6 >> 2] | 0, (i5 | 0) <= (HEAPU8[i4 + 6 | 0] | 0 | 0)) : 0) {
    i4 = i4 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i4 = 5192;
   }
  } else {
   i4 = (HEAP32[i6 >> 2] | 0) + (i7 << 4) | 0;
   i4 = i4 >>> 0 < (HEAP32[i5 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 if ((HEAP32[i4 + 8 >> 2] | 0) != 3) {
  i4 = _luaV_tonumber(i4, i3) | 0;
  if ((i4 | 0) == 0) {
   if ((i1 | 0) == 0) {
    d8 = 0.0;
    STACKTOP = i2;
    return +d8;
   }
   HEAP32[i1 >> 2] = 0;
   d8 = 0.0;
   STACKTOP = i2;
   return +d8;
  }
 }
 if ((i1 | 0) != 0) {
  HEAP32[i1 >> 2] = 1;
 }
 d8 = +HEAPF64[i4 >> 3];
 STACKTOP = i2;
 return +d8;
}
function _luaopen_package(i1) {
 i1 = i1 | 0;
 var i2 = 0;
 i2 = STACKTOP;
 _luaL_getsubtable(i1, -1001e3, 4184) | 0;
 _lua_createtable(i1, 0, 1);
 _lua_pushcclosure(i1, 158, 0);
 _lua_setfield(i1, -2, 4192);
 _lua_setmetatable(i1, -2) | 0;
 _lua_createtable(i1, 0, 3);
 _luaL_setfuncs(i1, 4200, 0);
 _lua_createtable(i1, 4, 0);
 _lua_pushvalue(i1, -2);
 _lua_pushcclosure(i1, 159, 1);
 _lua_rawseti(i1, -2, 1);
 _lua_pushvalue(i1, -2);
 _lua_pushcclosure(i1, 160, 1);
 _lua_rawseti(i1, -2, 2);
 _lua_pushvalue(i1, -2);
 _lua_pushcclosure(i1, 161, 1);
 _lua_rawseti(i1, -2, 3);
 _lua_pushvalue(i1, -2);
 _lua_pushcclosure(i1, 162, 1);
 _lua_rawseti(i1, -2, 4);
 _lua_pushvalue(i1, -1);
 _lua_setfield(i1, -3, 4232);
 _lua_setfield(i1, -2, 4240);
 _setpath(i1, 4256, 4264, 4280, 4296);
 _setpath(i1, 4440, 4448, 4464, 4480);
 _lua_pushlstring(i1, 4552, 10) | 0;
 _lua_setfield(i1, -2, 4568);
 _luaL_getsubtable(i1, -1001e3, 4576) | 0;
 _lua_setfield(i1, -2, 4584);
 _luaL_getsubtable(i1, -1001e3, 4592) | 0;
 _lua_setfield(i1, -2, 4608);
 _lua_rawgeti(i1, -1001e3, 2);
 _lua_pushvalue(i1, -2);
 _luaL_setfuncs(i1, 4616, 1);
 _lua_settop(i1, -2);
 STACKTOP = i2;
 return 1;
}
function _lua_rawlen(i3, i5) {
 i3 = i3 | 0;
 i5 = i5 | 0;
 var i1 = 0, i2 = 0, i4 = 0;
 i1 = STACKTOP;
 i4 = HEAP32[i3 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i2 = (HEAP32[i3 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i2 = (HEAP32[i3 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i3 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i2 = HEAP32[i4 >> 2] | 0, (i3 | 0) <= (HEAPU8[i2 + 6 | 0] | 0 | 0)) : 0) {
    i2 = i2 + (i3 + -1 << 4) + 16 | 0;
   } else {
    i2 = 5192;
   }
  } else {
   i2 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i2 = i2 >>> 0 < (HEAP32[i3 + 8 >> 2] | 0) >>> 0 ? i2 : 5192;
  }
 } while (0);
 i3 = HEAP32[i2 + 8 >> 2] & 15;
 if ((i3 | 0) == 5) {
  i5 = _luaH_getn(HEAP32[i2 >> 2] | 0) | 0;
  STACKTOP = i1;
  return i5 | 0;
 } else if ((i3 | 0) == 4) {
  i5 = HEAP32[(HEAP32[i2 >> 2] | 0) + 12 >> 2] | 0;
  STACKTOP = i1;
  return i5 | 0;
 } else if ((i3 | 0) == 7) {
  i5 = HEAP32[(HEAP32[i2 >> 2] | 0) + 16 >> 2] | 0;
  STACKTOP = i1;
  return i5 | 0;
 } else {
  i5 = 0;
  STACKTOP = i1;
  return i5 | 0;
 }
 return 0;
}
function _searchpath(i3, i5, i6, i7, i8) {
 i3 = i3 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 i7 = i7 | 0;
 i8 = i8 | 0;
 var i1 = 0, i2 = 0, i4 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 1056 | 0;
 i4 = i2;
 i1 = i2 + 8 | 0;
 _luaL_buffinit(i3, i1);
 if ((HEAP8[i7] | 0) != 0) {
  i5 = _luaL_gsub(i3, i5, i7, i8) | 0;
 }
 while (1) {
  i7 = HEAP8[i6] | 0;
  if (i7 << 24 >> 24 == 59) {
   i6 = i6 + 1 | 0;
   continue;
  } else if (i7 << 24 >> 24 == 0) {
   i3 = 12;
   break;
  }
  i8 = _strchr(i6, 59) | 0;
  if ((i8 | 0) == 0) {
   i8 = i6 + (_strlen(i6 | 0) | 0) | 0;
  }
  _lua_pushlstring(i3, i6, i8 - i6 | 0) | 0;
  if ((i8 | 0) == 0) {
   i3 = 12;
   break;
  }
  i6 = _luaL_gsub(i3, _lua_tolstring(i3, -1, 0) | 0, 5064, i5) | 0;
  _lua_remove(i3, -2);
  i7 = _fopen(i6 | 0, 5088) | 0;
  if ((i7 | 0) != 0) {
   i3 = 10;
   break;
  }
  HEAP32[i4 >> 2] = i6;
  _lua_pushfstring(i3, 5072, i4) | 0;
  _lua_remove(i3, -2);
  _luaL_addvalue(i1);
  i6 = i8;
 }
 if ((i3 | 0) == 10) {
  _fclose(i7 | 0) | 0;
  i8 = i6;
  STACKTOP = i2;
  return i8 | 0;
 } else if ((i3 | 0) == 12) {
  _luaL_pushresult(i1);
  i8 = 0;
  STACKTOP = i2;
  return i8 | 0;
 }
 return 0;
}
function _io_readline(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2;
 i4 = _lua_touserdata(i1, -1001001) | 0;
 i5 = _lua_tointegerx(i1, -1001002, 0) | 0;
 if ((HEAP32[i4 + 4 >> 2] | 0) == 0) {
  i6 = _luaL_error(i1, 3344, i3) | 0;
  STACKTOP = i2;
  return i6 | 0;
 }
 _lua_settop(i1, 1);
 if ((i5 | 0) >= 1) {
  i6 = 1;
  while (1) {
   _lua_pushvalue(i1, -1001003 - i6 | 0);
   if ((i6 | 0) == (i5 | 0)) {
    break;
   } else {
    i6 = i6 + 1 | 0;
   }
  }
 }
 i4 = _g_read(i1, HEAP32[i4 >> 2] | 0, 2) | 0;
 if ((_lua_type(i1, 0 - i4 | 0) | 0) != 0) {
  i6 = i4;
  STACKTOP = i2;
  return i6 | 0;
 }
 if ((i4 | 0) > 1) {
  HEAP32[i3 >> 2] = _lua_tolstring(i1, 1 - i4 | 0, 0) | 0;
  i6 = _luaL_error(i1, 3368, i3) | 0;
  STACKTOP = i2;
  return i6 | 0;
 }
 if ((_lua_toboolean(i1, -1001003) | 0) == 0) {
  i6 = 0;
  STACKTOP = i2;
  return i6 | 0;
 }
 _lua_settop(i1, 0);
 _lua_pushvalue(i1, -1001001);
 i5 = (_luaL_checkudata(i1, 1, 2832) | 0) + 4 | 0;
 i6 = HEAP32[i5 >> 2] | 0;
 HEAP32[i5 >> 2] = 0;
 FUNCTION_TABLE_ii[i6 & 255](i1) | 0;
 i6 = 0;
 STACKTOP = i2;
 return i6 | 0;
}
function _luaK_setreturns(i3, i5, i6) {
 i3 = i3 | 0;
 i5 = i5 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 i4 = HEAP32[i5 >> 2] | 0;
 if ((i4 | 0) == 13) {
  i7 = i5 + 8 | 0;
  i8 = HEAP32[i3 >> 2] | 0;
  i4 = HEAP32[i8 + 12 >> 2] | 0;
  i5 = i4 + (HEAP32[i7 >> 2] << 2) | 0;
  HEAP32[i5 >> 2] = HEAP32[i5 >> 2] & 8388607 | (i6 << 23) + 8388608;
  i7 = i4 + (HEAP32[i7 >> 2] << 2) | 0;
  i4 = i3 + 48 | 0;
  HEAP32[i7 >> 2] = (HEAPU8[i4] | 0) << 6 | HEAP32[i7 >> 2] & -16321;
  i7 = HEAP8[i4] | 0;
  i5 = (i7 & 255) + 1 | 0;
  i6 = i8 + 78 | 0;
  do {
   if (i5 >>> 0 > (HEAPU8[i6] | 0) >>> 0) {
    if (i5 >>> 0 > 249) {
     _luaX_syntaxerror(HEAP32[i3 + 12 >> 2] | 0, 10536);
    } else {
     HEAP8[i6] = i5;
     i1 = HEAP8[i4] | 0;
     break;
    }
   } else {
    i1 = i7;
   }
  } while (0);
  HEAP8[i4] = (i1 & 255) + 1;
  STACKTOP = i2;
  return;
 } else if ((i4 | 0) == 12) {
  i8 = (HEAP32[(HEAP32[i3 >> 2] | 0) + 12 >> 2] | 0) + (HEAP32[i5 + 8 >> 2] << 2) | 0;
  HEAP32[i8 >> 2] = HEAP32[i8 >> 2] & -8372225 | (i6 << 14) + 16384 & 8372224;
  STACKTOP = i2;
  return;
 } else {
  STACKTOP = i2;
  return;
 }
}
function _luaZ_read(i2, i9, i8) {
 i2 = i2 | 0;
 i9 = i9 | 0;
 i8 = i8 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i10 = 0, i11 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i1;
 if ((i8 | 0) == 0) {
  i11 = 0;
  STACKTOP = i1;
  return i11 | 0;
 }
 i7 = i2 + 16 | 0;
 i6 = i2 + 8 | 0;
 i4 = i2 + 12 | 0;
 i5 = i2 + 4 | 0;
 i11 = HEAP32[i2 >> 2] | 0;
 while (1) {
  if ((i11 | 0) == 0) {
   i10 = FUNCTION_TABLE_iiii[HEAP32[i6 >> 2] & 3](HEAP32[i7 >> 2] | 0, HEAP32[i4 >> 2] | 0, i3) | 0;
   if ((i10 | 0) == 0) {
    i2 = 9;
    break;
   }
   i11 = HEAP32[i3 >> 2] | 0;
   if ((i11 | 0) == 0) {
    i2 = 9;
    break;
   }
   HEAP32[i2 >> 2] = i11;
   HEAP32[i5 >> 2] = i10;
  } else {
   i10 = HEAP32[i5 >> 2] | 0;
  }
  i11 = i8 >>> 0 > i11 >>> 0 ? i11 : i8;
  _memcpy(i9 | 0, i10 | 0, i11 | 0) | 0;
  i10 = (HEAP32[i2 >> 2] | 0) - i11 | 0;
  HEAP32[i2 >> 2] = i10;
  HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + i11;
  if ((i8 | 0) == (i11 | 0)) {
   i8 = 0;
   i2 = 9;
   break;
  } else {
   i8 = i8 - i11 | 0;
   i9 = i9 + i11 | 0;
   i11 = i10;
  }
 }
 if ((i2 | 0) == 9) {
  STACKTOP = i1;
  return i8 | 0;
 }
 return 0;
}
function _lua_load(i1, i5, i4, i3, i6) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 i4 = i4 | 0;
 i3 = i3 | 0;
 i6 = i6 | 0;
 var i2 = 0, i7 = 0, i8 = 0, i9 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i7 = i2;
 _luaZ_init(i1, i7, i5, i4);
 i3 = _luaD_protectedparser(i1, i7, (i3 | 0) == 0 ? 928 : i3, i6) | 0;
 if ((i3 | 0) != 0) {
  STACKTOP = i2;
  return i3 | 0;
 }
 i4 = HEAP32[(HEAP32[i1 + 8 >> 2] | 0) + -16 >> 2] | 0;
 if ((HEAP8[i4 + 6 | 0] | 0) != 1) {
  STACKTOP = i2;
  return i3 | 0;
 }
 i5 = _luaH_getint(HEAP32[(HEAP32[i1 + 12 >> 2] | 0) + 40 >> 2] | 0, 2) | 0;
 i4 = i4 + 16 | 0;
 i6 = HEAP32[(HEAP32[i4 >> 2] | 0) + 8 >> 2] | 0;
 i9 = i5;
 i8 = HEAP32[i9 + 4 >> 2] | 0;
 i7 = i6;
 HEAP32[i7 >> 2] = HEAP32[i9 >> 2];
 HEAP32[i7 + 4 >> 2] = i8;
 i7 = i5 + 8 | 0;
 HEAP32[i6 + 8 >> 2] = HEAP32[i7 >> 2];
 if ((HEAP32[i7 >> 2] & 64 | 0) == 0) {
  STACKTOP = i2;
  return i3 | 0;
 }
 i5 = HEAP32[i5 >> 2] | 0;
 if ((HEAP8[i5 + 5 | 0] & 3) == 0) {
  STACKTOP = i2;
  return i3 | 0;
 }
 i4 = HEAP32[i4 >> 2] | 0;
 if ((HEAP8[i4 + 5 | 0] & 4) == 0) {
  STACKTOP = i2;
  return i3 | 0;
 }
 _luaC_barrier_(i1, i4, i5);
 STACKTOP = i2;
 return i3 | 0;
}
function _g_write(i1, i4, i8) {
 i1 = i1 | 0;
 i4 = i4 | 0;
 i8 = i8 | 0;
 var i2 = 0, i3 = 0, i5 = 0, i6 = 0, i7 = 0, i9 = 0, d10 = 0.0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i2 = i5;
 i3 = i5 + 8 | 0;
 i7 = _lua_gettop(i1) | 0;
 if ((i7 | 0) == (i8 | 0)) {
  i9 = 1;
  STACKTOP = i5;
  return i9 | 0;
 }
 i6 = i8;
 i7 = i7 - i8 | 0;
 i9 = 1;
 while (1) {
  i7 = i7 + -1 | 0;
  if ((_lua_type(i1, i6) | 0) == 3) {
   if ((i9 | 0) == 0) {
    i8 = 0;
   } else {
    d10 = +_lua_tonumberx(i1, i6, 0);
    HEAPF64[tempDoublePtr >> 3] = d10;
    HEAP32[i2 >> 2] = HEAP32[tempDoublePtr >> 2];
    HEAP32[i2 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
    i8 = (_fprintf(i4 | 0, 3072, i2 | 0) | 0) > 0;
   }
  } else {
   i8 = _luaL_checklstring(i1, i6, i3) | 0;
   if ((i9 | 0) == 0) {
    i8 = 0;
   } else {
    i8 = _fwrite(i8 | 0, 1, HEAP32[i3 >> 2] | 0, i4 | 0) | 0;
    i8 = (i8 | 0) == (HEAP32[i3 >> 2] | 0);
   }
  }
  if ((i7 | 0) == 0) {
   break;
  } else {
   i6 = i6 + 1 | 0;
   i9 = i8 & 1;
  }
 }
 if (i8) {
  i9 = 1;
  STACKTOP = i5;
  return i9 | 0;
 }
 i9 = _luaL_fileresult(i1, 0, 0) | 0;
 STACKTOP = i5;
 return i9 | 0;
}
function _lua_getuservalue(i2, i5) {
 i2 = i2 | 0;
 i5 = i5 | 0;
 var i1 = 0, i3 = 0, i4 = 0;
 i1 = STACKTOP;
 i4 = HEAP32[i2 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i3 = (HEAP32[i2 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i3 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i4 >> 2] | 0, (i5 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i3 = i3 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i3 = 5192;
   }
  } else {
   i3 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i3 = i3 >>> 0 < (HEAP32[i2 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i3 = HEAP32[(HEAP32[i3 >> 2] | 0) + 12 >> 2] | 0;
 i2 = i2 + 8 | 0;
 i4 = HEAP32[i2 >> 2] | 0;
 if ((i3 | 0) == 0) {
  HEAP32[i4 + 8 >> 2] = 0;
  i5 = i4;
  i5 = i5 + 16 | 0;
  HEAP32[i2 >> 2] = i5;
  STACKTOP = i1;
  return;
 } else {
  HEAP32[i4 >> 2] = i3;
  HEAP32[i4 + 8 >> 2] = 69;
  i5 = HEAP32[i2 >> 2] | 0;
  i5 = i5 + 16 | 0;
  HEAP32[i2 >> 2] = i5;
  STACKTOP = i1;
  return;
 }
}
function _luaL_addlstring(i7, i6, i1) {
 i7 = i7 | 0;
 i6 = i6 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i8 = 0, i9 = 0;
 i5 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = HEAP32[i7 + 12 >> 2] | 0;
 i3 = i7 + 4 | 0;
 i9 = HEAP32[i3 >> 2] | 0;
 i2 = i7 + 8 | 0;
 i8 = HEAP32[i2 >> 2] | 0;
 if (!((i9 - i8 | 0) >>> 0 < i1 >>> 0)) {
  i7 = HEAP32[i7 >> 2] | 0;
  i9 = i8;
  i9 = i7 + i9 | 0;
  _memcpy(i9 | 0, i6 | 0, i1 | 0) | 0;
  i9 = HEAP32[i2 >> 2] | 0;
  i9 = i9 + i1 | 0;
  HEAP32[i2 >> 2] = i9;
  STACKTOP = i5;
  return;
 }
 i9 = i9 << 1;
 i9 = (i9 - i8 | 0) >>> 0 < i1 >>> 0 ? i8 + i1 | 0 : i9;
 if (i9 >>> 0 < i8 >>> 0 | (i9 - i8 | 0) >>> 0 < i1 >>> 0) {
  _luaL_error(i4, 1272, i5) | 0;
 }
 i8 = _lua_newuserdata(i4, i9) | 0;
 _memcpy(i8 | 0, HEAP32[i7 >> 2] | 0, HEAP32[i2 >> 2] | 0) | 0;
 if ((HEAP32[i7 >> 2] | 0) != (i7 + 16 | 0)) {
  _lua_remove(i4, -2);
 }
 HEAP32[i7 >> 2] = i8;
 HEAP32[i3 >> 2] = i9;
 i9 = HEAP32[i2 >> 2] | 0;
 i9 = i8 + i9 | 0;
 _memcpy(i9 | 0, i6 | 0, i1 | 0) | 0;
 i9 = HEAP32[i2 >> 2] | 0;
 i9 = i9 + i1 | 0;
 HEAP32[i2 >> 2] = i9;
 STACKTOP = i5;
 return;
}
function _lua_rawgeti(i3, i6, i1) {
 i3 = i3 | 0;
 i6 = i6 | 0;
 i1 = i1 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i7 = 0;
 i2 = STACKTOP;
 i5 = HEAP32[i3 + 16 >> 2] | 0;
 do {
  if ((i6 | 0) <= 0) {
   if (!((i6 | 0) < -1000999)) {
    i4 = (HEAP32[i3 + 8 >> 2] | 0) + (i6 << 4) | 0;
    break;
   }
   if ((i6 | 0) == -1001e3) {
    i4 = (HEAP32[i3 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i6 = -1001e3 - i6 | 0;
   i5 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i4 = HEAP32[i5 >> 2] | 0, (i6 | 0) <= (HEAPU8[i4 + 6 | 0] | 0 | 0)) : 0) {
    i4 = i4 + (i6 + -1 << 4) + 16 | 0;
   } else {
    i4 = 5192;
   }
  } else {
   i4 = (HEAP32[i5 >> 2] | 0) + (i6 << 4) | 0;
   i4 = i4 >>> 0 < (HEAP32[i3 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 i4 = _luaH_getint(HEAP32[i4 >> 2] | 0, i1) | 0;
 i6 = i3 + 8 | 0;
 i5 = HEAP32[i6 >> 2] | 0;
 i7 = i4;
 i1 = HEAP32[i7 + 4 >> 2] | 0;
 i3 = i5;
 HEAP32[i3 >> 2] = HEAP32[i7 >> 2];
 HEAP32[i3 + 4 >> 2] = i1;
 HEAP32[i5 + 8 >> 2] = HEAP32[i4 + 8 >> 2];
 HEAP32[i6 >> 2] = (HEAP32[i6 >> 2] | 0) + 16;
 STACKTOP = i2;
 return;
}
function _lua_setfield(i1, i6, i3) {
 i1 = i1 | 0;
 i6 = i6 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0;
 i2 = STACKTOP;
 i5 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i6 | 0) <= 0) {
   if (!((i6 | 0) < -1000999)) {
    i4 = (HEAP32[i1 + 8 >> 2] | 0) + (i6 << 4) | 0;
    break;
   }
   if ((i6 | 0) == -1001e3) {
    i4 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i6 = -1001e3 - i6 | 0;
   i5 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i4 = HEAP32[i5 >> 2] | 0, (i6 | 0) <= (HEAPU8[i4 + 6 | 0] | 0 | 0)) : 0) {
    i4 = i4 + (i6 + -1 << 4) + 16 | 0;
   } else {
    i4 = 5192;
   }
  } else {
   i4 = (HEAP32[i5 >> 2] | 0) + (i6 << 4) | 0;
   i4 = i4 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 i6 = i1 + 8 | 0;
 i5 = HEAP32[i6 >> 2] | 0;
 HEAP32[i6 >> 2] = i5 + 16;
 i3 = _luaS_new(i1, i3) | 0;
 HEAP32[i5 >> 2] = i3;
 HEAP32[i5 + 8 >> 2] = HEAPU8[i3 + 4 | 0] | 0 | 64;
 i5 = HEAP32[i6 >> 2] | 0;
 _luaV_settable(i1, i4, i5 + -16 | 0, i5 + -32 | 0);
 HEAP32[i6 >> 2] = (HEAP32[i6 >> 2] | 0) + -32;
 STACKTOP = i2;
 return;
}
function _luaopen_io(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0;
 i2 = STACKTOP;
 _lua_createtable(i1, 0, 11);
 _luaL_setfuncs(i1, 2680, 0);
 _luaL_newmetatable(i1, 2832) | 0;
 _lua_pushvalue(i1, -1);
 _lua_setfield(i1, -2, 2872);
 _luaL_setfuncs(i1, 2880, 0);
 _lua_settop(i1, -2);
 i5 = HEAP32[_stdin >> 2] | 0;
 i4 = _lua_newuserdata(i1, 8) | 0;
 i3 = i4 + 4 | 0;
 HEAP32[i3 >> 2] = 0;
 _luaL_setmetatable(i1, 2832);
 HEAP32[i4 >> 2] = i5;
 HEAP32[i3 >> 2] = 154;
 _lua_pushvalue(i1, -1);
 _lua_setfield(i1, -1001e3, 2776);
 _lua_setfield(i1, -2, 2792);
 i3 = HEAP32[_stdout >> 2] | 0;
 i4 = _lua_newuserdata(i1, 8) | 0;
 i5 = i4 + 4 | 0;
 HEAP32[i5 >> 2] = 0;
 _luaL_setmetatable(i1, 2832);
 HEAP32[i4 >> 2] = i3;
 HEAP32[i5 >> 2] = 154;
 _lua_pushvalue(i1, -1);
 _lua_setfield(i1, -1001e3, 2800);
 _lua_setfield(i1, -2, 2816);
 i5 = HEAP32[_stderr >> 2] | 0;
 i4 = _lua_newuserdata(i1, 8) | 0;
 i3 = i4 + 4 | 0;
 HEAP32[i3 >> 2] = 0;
 _luaL_setmetatable(i1, 2832);
 HEAP32[i4 >> 2] = i5;
 HEAP32[i3 >> 2] = 154;
 _lua_setfield(i1, -2, 2824);
 STACKTOP = i2;
 return 1;
}
function _lua_pushcclosure(i1, i4, i5) {
 i1 = i1 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0;
 i2 = STACKTOP;
 if ((i5 | 0) == 0) {
  i6 = HEAP32[i1 + 8 >> 2] | 0;
  HEAP32[i6 >> 2] = i4;
  HEAP32[i6 + 8 >> 2] = 22;
  i6 = i1 + 8 | 0;
  i5 = HEAP32[i6 >> 2] | 0;
  i5 = i5 + 16 | 0;
  HEAP32[i6 >> 2] = i5;
  STACKTOP = i2;
  return;
 }
 if ((HEAP32[(HEAP32[i1 + 12 >> 2] | 0) + 12 >> 2] | 0) > 0) {
  _luaC_step(i1);
 }
 i3 = _luaF_newCclosure(i1, i5) | 0;
 HEAP32[i3 + 12 >> 2] = i4;
 i4 = i1 + 8 | 0;
 i6 = (HEAP32[i4 >> 2] | 0) + (0 - i5 << 4) | 0;
 HEAP32[i4 >> 2] = i6;
 do {
  i5 = i5 + -1 | 0;
  i9 = i6 + (i5 << 4) | 0;
  i8 = HEAP32[i9 + 4 >> 2] | 0;
  i7 = i3 + (i5 << 4) + 16 | 0;
  HEAP32[i7 >> 2] = HEAP32[i9 >> 2];
  HEAP32[i7 + 4 >> 2] = i8;
  HEAP32[i3 + (i5 << 4) + 24 >> 2] = HEAP32[i6 + (i5 << 4) + 8 >> 2];
  i6 = HEAP32[i4 >> 2] | 0;
 } while ((i5 | 0) != 0);
 HEAP32[i6 >> 2] = i3;
 HEAP32[i6 + 8 >> 2] = 102;
 i9 = i1 + 8 | 0;
 i8 = HEAP32[i9 >> 2] | 0;
 i8 = i8 + 16 | 0;
 HEAP32[i9 >> 2] = i8;
 STACKTOP = i2;
 return;
}
function _luaF_findupval(i3, i4) {
 i3 = i3 | 0;
 i4 = i4 | 0;
 var i1 = 0, i2 = 0, i5 = 0, i6 = 0, i7 = 0;
 i1 = STACKTOP;
 i2 = HEAP32[i3 + 12 >> 2] | 0;
 i6 = i3 + 56 | 0;
 i5 = HEAP32[i6 >> 2] | 0;
 L1 : do {
  if ((i5 | 0) == 0) {
   i5 = i6;
  } else {
   while (1) {
    i7 = HEAP32[i5 + 8 >> 2] | 0;
    if (i7 >>> 0 < i4 >>> 0) {
     i5 = i6;
     break L1;
    }
    if ((i7 | 0) == (i4 | 0)) {
     break;
    }
    i6 = HEAP32[i5 >> 2] | 0;
    if ((i6 | 0) == 0) {
     break L1;
    } else {
     i7 = i5;
     i5 = i6;
     i6 = i7;
    }
   }
   i4 = i5 + 5 | 0;
   i3 = (HEAPU8[i4] | 0) ^ 3;
   if ((((HEAPU8[i2 + 60 | 0] | 0) ^ 3) & i3 | 0) != 0) {
    i7 = i5;
    STACKTOP = i1;
    return i7 | 0;
   }
   HEAP8[i4] = i3;
   i7 = i5;
   STACKTOP = i1;
   return i7 | 0;
  }
 } while (0);
 i7 = _luaC_newobj(i3, 10, 32, i5, 0) | 0;
 HEAP32[i7 + 8 >> 2] = i4;
 i4 = i7 + 16 | 0;
 HEAP32[i4 >> 2] = i2 + 112;
 i6 = i2 + 132 | 0;
 i5 = HEAP32[i6 >> 2] | 0;
 HEAP32[i4 + 4 >> 2] = i5;
 HEAP32[i5 + 16 >> 2] = i7;
 HEAP32[i6 >> 2] = i7;
 STACKTOP = i1;
 return i7 | 0;
}
function _luaC_checkfinalizer(i5, i4, i6) {
 i5 = i5 | 0;
 i4 = i4 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i7 = 0, i8 = 0;
 i3 = STACKTOP;
 i1 = HEAP32[i5 + 12 >> 2] | 0;
 i2 = i4 + 5 | 0;
 if ((HEAP8[i2] & 24) != 0 | (i6 | 0) == 0) {
  STACKTOP = i3;
  return;
 }
 if (!((HEAP8[i6 + 6 | 0] & 4) == 0)) {
  STACKTOP = i3;
  return;
 }
 if ((_luaT_gettm(i6, 2, HEAP32[i1 + 192 >> 2] | 0) | 0) == 0) {
  STACKTOP = i3;
  return;
 }
 i7 = i1 + 76 | 0;
 i8 = HEAP32[i7 >> 2] | 0;
 if ((i8 | 0) == (i4 | 0)) {
  do {
   i6 = _sweeplist(i5, i8, 1) | 0;
  } while ((i6 | 0) == (i8 | 0));
  HEAP32[i7 >> 2] = i6;
 }
 i5 = i1 + 68 | 0;
 while (1) {
  i6 = HEAP32[i5 >> 2] | 0;
  if ((i6 | 0) == (i4 | 0)) {
   break;
  } else {
   i5 = i6;
  }
 }
 HEAP32[i5 >> 2] = HEAP32[i4 >> 2];
 i8 = i1 + 72 | 0;
 HEAP32[i4 >> 2] = HEAP32[i8 >> 2];
 HEAP32[i8 >> 2] = i4;
 i4 = HEAPU8[i2] | 0 | 16;
 HEAP8[i2] = i4;
 if ((HEAPU8[i1 + 61 | 0] | 0) < 2) {
  HEAP8[i2] = i4 & 191;
  STACKTOP = i3;
  return;
 } else {
  HEAP8[i2] = HEAP8[i1 + 60 | 0] & 3 | i4 & 184;
  STACKTOP = i3;
  return;
 }
}
function _io_lines(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2;
 if ((_lua_type(i1, 1) | 0) == -1) {
  _lua_pushnil(i1);
 }
 if ((_lua_type(i1, 1) | 0) == 0) {
  _lua_getfield(i1, -1001e3, 2776);
  _lua_replace(i1, 1);
  if ((HEAP32[(_luaL_checkudata(i1, 1, 2832) | 0) + 4 >> 2] | 0) != 0) {
   i4 = 0;
   _aux_lines(i1, i4);
   STACKTOP = i2;
   return 1;
  }
  _luaL_error(i1, 3080, i3) | 0;
  i4 = 0;
  _aux_lines(i1, i4);
  STACKTOP = i2;
  return 1;
 } else {
  i4 = _luaL_checklstring(i1, 1, 0) | 0;
  i6 = _lua_newuserdata(i1, 8) | 0;
  i5 = i6 + 4 | 0;
  HEAP32[i5 >> 2] = 0;
  _luaL_setmetatable(i1, 2832);
  HEAP32[i6 >> 2] = 0;
  HEAP32[i5 >> 2] = 156;
  i5 = _fopen(i4 | 0, 3480) | 0;
  HEAP32[i6 >> 2] = i5;
  if ((i5 | 0) == 0) {
   i6 = _strerror(HEAP32[(___errno_location() | 0) >> 2] | 0) | 0;
   HEAP32[i3 >> 2] = i4;
   HEAP32[i3 + 4 >> 2] = i6;
   _luaL_error(i1, 3520, i3) | 0;
  }
  _lua_replace(i1, 1);
  i6 = 1;
  _aux_lines(i1, i6);
  STACKTOP = i2;
  return 1;
 }
 return 0;
}
function _luaC_changemode(i2, i6) {
 i2 = i2 | 0;
 i6 = i6 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0;
 i1 = STACKTOP;
 i3 = i2 + 12 | 0;
 i5 = HEAP32[i3 >> 2] | 0;
 i4 = i5 + 62 | 0;
 if ((HEAPU8[i4] | 0) == (i6 | 0)) {
  STACKTOP = i1;
  return;
 }
 if ((i6 | 0) == 2) {
  i3 = i5 + 61 | 0;
  if ((HEAP8[i3] | 0) != 0) {
   do {
    _singlestep(i2) | 0;
   } while ((HEAP8[i3] | 0) != 0);
  }
  HEAP32[i5 + 20 >> 2] = (HEAP32[i5 + 12 >> 2] | 0) + (HEAP32[i5 + 8 >> 2] | 0);
  HEAP8[i4] = 2;
  STACKTOP = i1;
  return;
 }
 HEAP8[i4] = 0;
 i4 = HEAP32[i3 >> 2] | 0;
 HEAP8[i4 + 61 | 0] = 2;
 HEAP32[i4 + 64 >> 2] = 0;
 i5 = i4 + 72 | 0;
 do {
  i6 = _sweeplist(i2, i5, 1) | 0;
 } while ((i6 | 0) == (i5 | 0));
 HEAP32[i4 + 80 >> 2] = i6;
 i5 = i4 + 68 | 0;
 do {
  i6 = _sweeplist(i2, i5, 1) | 0;
 } while ((i6 | 0) == (i5 | 0));
 HEAP32[i4 + 76 >> 2] = i6;
 i3 = (HEAP32[i3 >> 2] | 0) + 61 | 0;
 if ((1 << HEAPU8[i3] & -29 | 0) != 0) {
  STACKTOP = i1;
  return;
 }
 do {
  _singlestep(i2) | 0;
 } while ((1 << HEAPU8[i3] & -29 | 0) == 0);
 STACKTOP = i1;
 return;
}
function _lua_rawget(i1, i5) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i6 = 0;
 i2 = STACKTOP;
 i4 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i3 = (HEAP32[i1 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i3 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i4 >> 2] | 0, (i5 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i3 = i3 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i3 = 5192;
   }
  } else {
   i3 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i3 = i3 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i5 = i1 + 8 | 0;
 i4 = _luaH_get(HEAP32[i3 >> 2] | 0, (HEAP32[i5 >> 2] | 0) + -16 | 0) | 0;
 i5 = HEAP32[i5 >> 2] | 0;
 i6 = i4;
 i1 = HEAP32[i6 + 4 >> 2] | 0;
 i3 = i5 + -16 | 0;
 HEAP32[i3 >> 2] = HEAP32[i6 >> 2];
 HEAP32[i3 + 4 >> 2] = i1;
 HEAP32[i5 + -8 >> 2] = HEAP32[i4 + 8 >> 2];
 STACKTOP = i2;
 return;
}
function _lua_isstring(i2, i4) {
 i2 = i2 | 0;
 i4 = i4 | 0;
 var i1 = 0, i3 = 0;
 i1 = STACKTOP;
 i3 = HEAP32[i2 + 16 >> 2] | 0;
 do {
  if ((i4 | 0) <= 0) {
   if (!((i4 | 0) < -1000999)) {
    i2 = (HEAP32[i2 + 8 >> 2] | 0) + (i4 << 4) | 0;
    break;
   }
   if ((i4 | 0) == -1001e3) {
    i2 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i2 = -1001e3 - i4 | 0;
   i3 = HEAP32[i3 >> 2] | 0;
   if ((HEAP32[i3 + 8 >> 2] | 0) == 22) {
    i4 = 0;
    i4 = i4 & 1;
    STACKTOP = i1;
    return i4 | 0;
   }
   i3 = HEAP32[i3 >> 2] | 0;
   if ((i2 | 0) > (HEAPU8[i3 + 6 | 0] | 0 | 0)) {
    i4 = 0;
    i4 = i4 & 1;
    STACKTOP = i1;
    return i4 | 0;
   } else {
    i2 = i3 + (i2 + -1 << 4) + 16 | 0;
    break;
   }
  } else {
   i3 = (HEAP32[i3 >> 2] | 0) + (i4 << 4) | 0;
   i2 = i3 >>> 0 < (HEAP32[i2 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 if ((i2 | 0) == 5192) {
  i4 = 0;
  i4 = i4 & 1;
  STACKTOP = i1;
  return i4 | 0;
 }
 i4 = ((HEAP32[i2 + 8 >> 2] & 15) + -3 | 0) >>> 0 < 2;
 i4 = i4 & 1;
 STACKTOP = i1;
 return i4 | 0;
}
function _setnodevector(i5, i1, i3) {
 i5 = i5 | 0;
 i1 = i1 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 if ((i3 | 0) == 0) {
  HEAP32[i1 + 16 >> 2] = 8016;
  i6 = 0;
  i7 = 8016;
  i4 = 0;
  i5 = i1 + 7 | 0;
  HEAP8[i5] = i4;
  i6 = i7 + (i6 << 5) | 0;
  i7 = i1 + 20 | 0;
  HEAP32[i7 >> 2] = i6;
  STACKTOP = i2;
  return;
 }
 i4 = _luaO_ceillog2(i3) | 0;
 if ((i4 | 0) > 30) {
  _luaG_runerror(i5, 8048, i2);
 }
 i3 = 1 << i4;
 if ((i3 + 1 | 0) >>> 0 > 134217727) {
  _luaM_toobig(i5);
 }
 i6 = _luaM_realloc_(i5, 0, 0, i3 << 5) | 0;
 i5 = i1 + 16 | 0;
 HEAP32[i5 >> 2] = i6;
 if ((i3 | 0) > 0) {
  i7 = 0;
  do {
   HEAP32[i6 + (i7 << 5) + 28 >> 2] = 0;
   HEAP32[i6 + (i7 << 5) + 24 >> 2] = 0;
   HEAP32[i6 + (i7 << 5) + 8 >> 2] = 0;
   i7 = i7 + 1 | 0;
   i6 = HEAP32[i5 >> 2] | 0;
  } while ((i7 | 0) != (i3 | 0));
 }
 i7 = i3;
 i4 = i4 & 255;
 i5 = i1 + 7 | 0;
 HEAP8[i5] = i4;
 i6 = i6 + (i7 << 5) | 0;
 i7 = i1 + 20 | 0;
 HEAP32[i7 >> 2] = i6;
 STACKTOP = i2;
 return;
}
function _lua_pushvalue(i1, i5) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 i4 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i3 = (HEAP32[i1 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i3 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i4 >> 2] | 0, (i5 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i3 = i3 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i3 = 5192;
   }
  } else {
   i3 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i3 = i3 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i5 = i1 + 8 | 0;
 i4 = HEAP32[i5 >> 2] | 0;
 i7 = i3;
 i6 = HEAP32[i7 + 4 >> 2] | 0;
 i1 = i4;
 HEAP32[i1 >> 2] = HEAP32[i7 >> 2];
 HEAP32[i1 + 4 >> 2] = i6;
 HEAP32[i4 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
 HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + 16;
 STACKTOP = i2;
 return;
}
function _luaL_setfuncs(i3, i6, i1) {
 i3 = i3 | 0;
 i6 = i6 | 0;
 i1 = i1 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i7 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = i2;
 _luaL_checkversion_(i3, 502.0);
 if ((_lua_checkstack(i3, i1 + 20 | 0) | 0) == 0) {
  HEAP32[i4 >> 2] = 1472;
  _luaL_error(i3, 1216, i4) | 0;
 }
 if ((HEAP32[i6 >> 2] | 0) == 0) {
  i7 = ~i1;
  _lua_settop(i3, i7);
  STACKTOP = i2;
  return;
 }
 i4 = -2 - i1 | 0;
 i5 = 0 - i1 | 0;
 if ((i1 | 0) <= 0) {
  do {
   _lua_pushcclosure(i3, HEAP32[i6 + 4 >> 2] | 0, i1);
   _lua_setfield(i3, i4, HEAP32[i6 >> 2] | 0);
   i6 = i6 + 8 | 0;
  } while ((HEAP32[i6 >> 2] | 0) != 0);
  i7 = ~i1;
  _lua_settop(i3, i7);
  STACKTOP = i2;
  return;
 }
 do {
  i7 = 0;
  do {
   _lua_pushvalue(i3, i5);
   i7 = i7 + 1 | 0;
  } while ((i7 | 0) != (i1 | 0));
  _lua_pushcclosure(i3, HEAP32[i6 + 4 >> 2] | 0, i1);
  _lua_setfield(i3, i4, HEAP32[i6 >> 2] | 0);
  i6 = i6 + 8 | 0;
 } while ((HEAP32[i6 >> 2] | 0) != 0);
 i7 = ~i1;
 _lua_settop(i3, i7);
 STACKTOP = i2;
 return;
}
function _lua_touserdata(i3, i5) {
 i3 = i3 | 0;
 i5 = i5 | 0;
 var i1 = 0, i2 = 0, i4 = 0;
 i1 = STACKTOP;
 i4 = HEAP32[i3 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i2 = (HEAP32[i3 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i2 = (HEAP32[i3 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i3 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i2 = HEAP32[i4 >> 2] | 0, (i3 | 0) <= (HEAPU8[i2 + 6 | 0] | 0 | 0)) : 0) {
    i2 = i2 + (i3 + -1 << 4) + 16 | 0;
   } else {
    i2 = 5192;
   }
  } else {
   i2 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i2 = i2 >>> 0 < (HEAP32[i3 + 8 >> 2] | 0) >>> 0 ? i2 : 5192;
  }
 } while (0);
 i3 = HEAP32[i2 + 8 >> 2] & 15;
 if ((i3 | 0) == 2) {
  i5 = HEAP32[i2 >> 2] | 0;
  STACKTOP = i1;
  return i5 | 0;
 } else if ((i3 | 0) == 7) {
  i5 = (HEAP32[i2 >> 2] | 0) + 24 | 0;
  STACKTOP = i1;
  return i5 | 0;
 } else {
  i5 = 0;
  STACKTOP = i1;
  return i5 | 0;
 }
 return 0;
}
function _luaL_checkoption(i2, i3, i6, i4) {
 i2 = i2 | 0;
 i3 = i3 | 0;
 i6 = i6 | 0;
 i4 = i4 | 0;
 var i1 = 0, i5 = 0, i7 = 0, i8 = 0, i9 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i5 = i1;
 if ((i6 | 0) == 0) {
  i6 = _lua_tolstring(i2, i3, 0) | 0;
  if ((i6 | 0) == 0) {
   i9 = _lua_typename(i2, 4) | 0;
   i6 = _lua_typename(i2, _lua_type(i2, i3) | 0) | 0;
   HEAP32[i5 >> 2] = i9;
   HEAP32[i5 + 4 >> 2] = i6;
   _luaL_argerror(i2, i3, _lua_pushfstring(i2, 1744, i5) | 0) | 0;
   i6 = 0;
  }
 } else {
  i6 = _luaL_optlstring(i2, i3, i6, 0) | 0;
 }
 i9 = HEAP32[i4 >> 2] | 0;
 L6 : do {
  if ((i9 | 0) != 0) {
   i8 = 0;
   while (1) {
    i7 = i8 + 1 | 0;
    if ((_strcmp(i9, i6) | 0) == 0) {
     break;
    }
    i9 = HEAP32[i4 + (i7 << 2) >> 2] | 0;
    if ((i9 | 0) == 0) {
     break L6;
    } else {
     i8 = i7;
    }
   }
   STACKTOP = i1;
   return i8 | 0;
  }
 } while (0);
 HEAP32[i5 >> 2] = i6;
 i9 = _luaL_argerror(i2, i3, _lua_pushfstring(i2, 1192, i5) | 0) | 0;
 STACKTOP = i1;
 return i9 | 0;
}
function _lua_toboolean(i3, i5) {
 i3 = i3 | 0;
 i5 = i5 | 0;
 var i1 = 0, i2 = 0, i4 = 0;
 i1 = STACKTOP;
 i4 = HEAP32[i3 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i3 = (HEAP32[i3 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i3 = (HEAP32[i3 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i3 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i2 = HEAP32[i4 >> 2] | 0, (i3 | 0) <= (HEAPU8[i2 + 6 | 0] | 0 | 0)) : 0) {
    i3 = i2 + (i3 + -1 << 4) + 16 | 0;
   } else {
    i3 = 5192;
   }
  } else {
   i2 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i3 = i2 >>> 0 < (HEAP32[i3 + 8 >> 2] | 0) >>> 0 ? i2 : 5192;
  }
 } while (0);
 i2 = HEAP32[i3 + 8 >> 2] | 0;
 if ((i2 | 0) == 0) {
  i5 = 0;
  i5 = i5 & 1;
  STACKTOP = i1;
  return i5 | 0;
 }
 if ((i2 | 0) != 1) {
  i5 = 1;
  i5 = i5 & 1;
  STACKTOP = i1;
  return i5 | 0;
 }
 i5 = (HEAP32[i3 >> 2] | 0) != 0;
 i5 = i5 & 1;
 STACKTOP = i1;
 return i5 | 0;
}
function _lua_getfield(i1, i6, i3) {
 i1 = i1 | 0;
 i6 = i6 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0;
 i2 = STACKTOP;
 i5 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i6 | 0) <= 0) {
   if (!((i6 | 0) < -1000999)) {
    i4 = (HEAP32[i1 + 8 >> 2] | 0) + (i6 << 4) | 0;
    break;
   }
   if ((i6 | 0) == -1001e3) {
    i4 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i6 = -1001e3 - i6 | 0;
   i5 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i4 = HEAP32[i5 >> 2] | 0, (i6 | 0) <= (HEAPU8[i4 + 6 | 0] | 0 | 0)) : 0) {
    i4 = i4 + (i6 + -1 << 4) + 16 | 0;
   } else {
    i4 = 5192;
   }
  } else {
   i4 = (HEAP32[i5 >> 2] | 0) + (i6 << 4) | 0;
   i4 = i4 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i4 : 5192;
  }
 } while (0);
 i5 = i1 + 8 | 0;
 i6 = HEAP32[i5 >> 2] | 0;
 i3 = _luaS_new(i1, i3) | 0;
 HEAP32[i6 >> 2] = i3;
 HEAP32[i6 + 8 >> 2] = HEAPU8[i3 + 4 | 0] | 0 | 64;
 i6 = HEAP32[i5 >> 2] | 0;
 HEAP32[i5 >> 2] = i6 + 16;
 _luaV_gettable(i1, i4, i6, i6);
 STACKTOP = i2;
 return;
}
function _luaL_argerror(i1, i6, i3) {
 i1 = i1 | 0;
 i6 = i6 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 112 | 0;
 i2 = i4;
 i5 = i4 + 12 | 0;
 if ((_lua_getstack(i1, 0, i5) | 0) == 0) {
  HEAP32[i2 >> 2] = i6;
  HEAP32[i2 + 4 >> 2] = i3;
  i8 = _luaL_error(i1, 1040, i2) | 0;
  STACKTOP = i4;
  return i8 | 0;
 }
 _lua_getinfo(i1, 1064, i5) | 0;
 if ((_strcmp(HEAP32[i5 + 8 >> 2] | 0, 1072) | 0) == 0) {
  i6 = i6 + -1 | 0;
  if ((i6 | 0) == 0) {
   HEAP32[i2 >> 2] = HEAP32[i5 + 4 >> 2];
   HEAP32[i2 + 4 >> 2] = i3;
   i8 = _luaL_error(i1, 1080, i2) | 0;
   STACKTOP = i4;
   return i8 | 0;
  }
 }
 i7 = i5 + 4 | 0;
 i8 = HEAP32[i7 >> 2] | 0;
 if ((i8 | 0) == 0) {
  if ((_pushglobalfuncname(i1, i5) | 0) == 0) {
   i8 = 1112;
  } else {
   i8 = _lua_tolstring(i1, -1, 0) | 0;
  }
  HEAP32[i7 >> 2] = i8;
 }
 HEAP32[i2 >> 2] = i6;
 HEAP32[i2 + 4 >> 2] = i8;
 HEAP32[i2 + 8 >> 2] = i3;
 i8 = _luaL_error(i1, 1120, i2) | 0;
 STACKTOP = i4;
 return i8 | 0;
}
function _match_class(i3, i2) {
 i3 = i3 | 0;
 i2 = i2 | 0;
 var i1 = 0;
 i1 = STACKTOP;
 switch (_tolower(i2 | 0) | 0) {
 case 117:
  {
   i3 = _isupper(i3 | 0) | 0;
   break;
  }
 case 97:
  {
   i3 = _isalpha(i3 | 0) | 0;
   break;
  }
 case 99:
  {
   i3 = _iscntrl(i3 | 0) | 0;
   break;
  }
 case 120:
  {
   i3 = _isxdigit(i3 | 0) | 0;
   break;
  }
 case 119:
  {
   i3 = _isalnum(i3 | 0) | 0;
   break;
  }
 case 112:
  {
   i3 = _ispunct(i3 | 0) | 0;
   break;
  }
 case 100:
  {
   i3 = (i3 + -48 | 0) >>> 0 < 10 | 0;
   break;
  }
 case 108:
  {
   i3 = _islower(i3 | 0) | 0;
   break;
  }
 case 122:
  {
   i3 = (i3 | 0) == 0 | 0;
   break;
  }
 case 103:
  {
   i3 = _isgraph(i3 | 0) | 0;
   break;
  }
 case 115:
  {
   i3 = _isspace(i3 | 0) | 0;
   break;
  }
 default:
  {
   i3 = (i2 | 0) == (i3 | 0) | 0;
   STACKTOP = i1;
   return i3 | 0;
  }
 }
 if ((_islower(i2 | 0) | 0) != 0) {
  STACKTOP = i1;
  return i3 | 0;
 }
 i3 = (i3 | 0) == 0 | 0;
 STACKTOP = i1;
 return i3 | 0;
}
function _condjump(i1, i3, i6, i4, i5) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 i6 = i6 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 var i2 = 0, i7 = 0, i8 = 0, i9 = 0;
 i2 = STACKTOP;
 _luaK_code(i1, i6 << 6 | i3 | i4 << 23 | i5 << 14) | 0;
 i3 = i1 + 28 | 0;
 i6 = HEAP32[i3 >> 2] | 0;
 HEAP32[i3 >> 2] = -1;
 i3 = _luaK_code(i1, 2147450903) | 0;
 if ((i6 | 0) == -1) {
  i9 = i3;
  STACKTOP = i2;
  return i9 | 0;
 }
 if ((i3 | 0) == -1) {
  i9 = i6;
  STACKTOP = i2;
  return i9 | 0;
 }
 i8 = HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0;
 i7 = i3;
 while (1) {
  i4 = i8 + (i7 << 2) | 0;
  i5 = HEAP32[i4 >> 2] | 0;
  i9 = (i5 >>> 14) + -131071 | 0;
  if ((i9 | 0) == -1) {
   break;
  }
  i9 = i7 + 1 + i9 | 0;
  if ((i9 | 0) == -1) {
   break;
  } else {
   i7 = i9;
  }
 }
 i6 = i6 + ~i7 | 0;
 if ((((i6 | 0) > -1 ? i6 : 0 - i6 | 0) | 0) > 131071) {
  _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10624);
 }
 HEAP32[i4 >> 2] = (i6 << 14) + 2147467264 | i5 & 16383;
 i9 = i3;
 STACKTOP = i2;
 return i9 | 0;
}
function _skipcomment(i6, i1) {
 i6 = i6 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 HEAP32[i6 >> 2] = 0;
 i3 = i6 + 4 | 0;
 i5 = 1712;
 while (1) {
  i7 = _fgetc(HEAP32[i3 >> 2] | 0) | 0;
  if ((i7 | 0) == -1) {
   i4 = 3;
   break;
  }
  i8 = i5 + 1 | 0;
  if ((i7 | 0) != (HEAPU8[i5] | 0)) {
   break;
  }
  i5 = HEAP32[i6 >> 2] | 0;
  HEAP32[i6 >> 2] = i5 + 1;
  HEAP8[i6 + i5 + 8 | 0] = i7;
  if ((HEAP8[i8] | 0) == 0) {
   i4 = 6;
   break;
  } else {
   i5 = i8;
  }
 }
 if ((i4 | 0) == 3) {
  HEAP32[i1 >> 2] = -1;
  i8 = 0;
  STACKTOP = i2;
  return i8 | 0;
 } else if ((i4 | 0) == 6) {
  HEAP32[i6 >> 2] = 0;
  i7 = _fgetc(HEAP32[i3 >> 2] | 0) | 0;
 }
 HEAP32[i1 >> 2] = i7;
 if ((i7 | 0) != 35) {
  i8 = 0;
  STACKTOP = i2;
  return i8 | 0;
 }
 do {
  i8 = _fgetc(HEAP32[i3 >> 2] | 0) | 0;
 } while (!((i8 | 0) == 10 | (i8 | 0) == -1));
 HEAP32[i1 >> 2] = _fgetc(HEAP32[i3 >> 2] | 0) | 0;
 i8 = 1;
 STACKTOP = i2;
 return i8 | 0;
}
function _lua_isnumber(i4, i6) {
 i4 = i4 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i5 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i2 = i1;
 i5 = HEAP32[i4 + 16 >> 2] | 0;
 do {
  if ((i6 | 0) <= 0) {
   if (!((i6 | 0) < -1000999)) {
    i3 = (HEAP32[i4 + 8 >> 2] | 0) + (i6 << 4) | 0;
    break;
   }
   if ((i6 | 0) == -1001e3) {
    i3 = (HEAP32[i4 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i4 = -1001e3 - i6 | 0;
   i5 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i5 >> 2] | 0, (i4 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i3 = i3 + (i4 + -1 << 4) + 16 | 0;
   } else {
    i3 = 5192;
   }
  } else {
   i3 = (HEAP32[i5 >> 2] | 0) + (i6 << 4) | 0;
   i3 = i3 >>> 0 < (HEAP32[i4 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 if ((HEAP32[i3 + 8 >> 2] | 0) == 3) {
  i6 = 1;
  i6 = i6 & 1;
  STACKTOP = i1;
  return i6 | 0;
 }
 i6 = (_luaV_tonumber(i3, i2) | 0) != 0;
 i6 = i6 & 1;
 STACKTOP = i1;
 return i6 | 0;
}
function ___shgetc(i3) {
 i3 = i3 | 0;
 var i1 = 0, i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 i7 = i3 + 104 | 0;
 i6 = HEAP32[i7 >> 2] | 0;
 if (!((i6 | 0) != 0 ? (HEAP32[i3 + 108 >> 2] | 0) >= (i6 | 0) : 0)) {
  i8 = 3;
 }
 if ((i8 | 0) == 3 ? (i1 = ___uflow(i3) | 0, (i1 | 0) >= 0) : 0) {
  i7 = HEAP32[i7 >> 2] | 0;
  i6 = HEAP32[i3 + 8 >> 2] | 0;
  if ((i7 | 0) != 0 ? (i4 = HEAP32[i3 + 4 >> 2] | 0, i5 = i7 - (HEAP32[i3 + 108 >> 2] | 0) + -1 | 0, (i6 - i4 | 0) > (i5 | 0)) : 0) {
   HEAP32[i3 + 100 >> 2] = i4 + i5;
  } else {
   HEAP32[i3 + 100 >> 2] = i6;
  }
  i4 = HEAP32[i3 + 4 >> 2] | 0;
  if ((i6 | 0) != 0) {
   i8 = i3 + 108 | 0;
   HEAP32[i8 >> 2] = i6 + 1 - i4 + (HEAP32[i8 >> 2] | 0);
  }
  i3 = i4 + -1 | 0;
  if ((HEAPU8[i3] | 0 | 0) == (i1 | 0)) {
   i8 = i1;
   STACKTOP = i2;
   return i8 | 0;
  }
  HEAP8[i3] = i1;
  i8 = i1;
  STACKTOP = i2;
  return i8 | 0;
 }
 HEAP32[i3 + 100 >> 2] = 0;
 i8 = -1;
 STACKTOP = i2;
 return i8 | 0;
}
function _lua_type(i2, i4) {
 i2 = i2 | 0;
 i4 = i4 | 0;
 var i1 = 0, i3 = 0;
 i1 = STACKTOP;
 i3 = HEAP32[i2 + 16 >> 2] | 0;
 do {
  if ((i4 | 0) <= 0) {
   if (!((i4 | 0) < -1000999)) {
    i2 = (HEAP32[i2 + 8 >> 2] | 0) + (i4 << 4) | 0;
    break;
   }
   if ((i4 | 0) == -1001e3) {
    i2 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i2 = -1001e3 - i4 | 0;
   i3 = HEAP32[i3 >> 2] | 0;
   if ((HEAP32[i3 + 8 >> 2] | 0) == 22) {
    i4 = -1;
    STACKTOP = i1;
    return i4 | 0;
   }
   i3 = HEAP32[i3 >> 2] | 0;
   if ((i2 | 0) > (HEAPU8[i3 + 6 | 0] | 0 | 0)) {
    i4 = -1;
    STACKTOP = i1;
    return i4 | 0;
   } else {
    i2 = i3 + (i2 + -1 << 4) + 16 | 0;
    break;
   }
  } else {
   i3 = (HEAP32[i3 >> 2] | 0) + (i4 << 4) | 0;
   i2 = i3 >>> 0 < (HEAP32[i2 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 if ((i2 | 0) == 5192) {
  i4 = -1;
  STACKTOP = i1;
  return i4 | 0;
 }
 i4 = HEAP32[i2 + 8 >> 2] & 15;
 STACKTOP = i1;
 return i4 | 0;
}
function _g_iofile(i4, i1, i5) {
 i4 = i4 | 0;
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2;
 if ((_lua_type(i4, 1) | 0) < 1) {
  _lua_getfield(i4, -1001e3, i1);
  STACKTOP = i2;
  return;
 }
 i6 = _lua_tolstring(i4, 1, 0) | 0;
 if ((i6 | 0) != 0) {
  i7 = _lua_newuserdata(i4, 8) | 0;
  i8 = i7 + 4 | 0;
  HEAP32[i8 >> 2] = 0;
  _luaL_setmetatable(i4, 2832);
  HEAP32[i7 >> 2] = 0;
  HEAP32[i8 >> 2] = 156;
  i5 = _fopen(i6 | 0, i5 | 0) | 0;
  HEAP32[i7 >> 2] = i5;
  if ((i5 | 0) == 0) {
   i8 = _strerror(HEAP32[(___errno_location() | 0) >> 2] | 0) | 0;
   HEAP32[i3 >> 2] = i6;
   HEAP32[i3 + 4 >> 2] = i8;
   _luaL_error(i4, 3520, i3) | 0;
  }
 } else {
  if ((HEAP32[(_luaL_checkudata(i4, 1, 2832) | 0) + 4 >> 2] | 0) == 0) {
   _luaL_error(i4, 3080, i3) | 0;
  }
  _lua_pushvalue(i4, 1);
 }
 _lua_setfield(i4, -1001e3, i1);
 _lua_getfield(i4, -1001e3, i1);
 STACKTOP = i2;
 return;
}
function _lua_getlocal(i4, i5, i2) {
 i4 = i4 | 0;
 i5 = i5 | 0;
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i1;
 if ((i5 | 0) == 0) {
  i3 = HEAP32[i4 + 8 >> 2] | 0;
  if ((HEAP32[i3 + -8 >> 2] | 0) != 70) {
   i5 = 0;
   STACKTOP = i1;
   return i5 | 0;
  }
  i5 = _luaF_getlocalname(HEAP32[(HEAP32[i3 + -16 >> 2] | 0) + 12 >> 2] | 0, i2, 0) | 0;
  STACKTOP = i1;
  return i5 | 0;
 } else {
  HEAP32[i3 >> 2] = 0;
  i2 = _findlocal(i4, HEAP32[i5 + 96 >> 2] | 0, i2, i3) | 0;
  if ((i2 | 0) == 0) {
   i5 = 0;
   STACKTOP = i1;
   return i5 | 0;
  }
  i3 = HEAP32[i3 >> 2] | 0;
  i5 = i4 + 8 | 0;
  i4 = HEAP32[i5 >> 2] | 0;
  i8 = i3;
  i7 = HEAP32[i8 + 4 >> 2] | 0;
  i6 = i4;
  HEAP32[i6 >> 2] = HEAP32[i8 >> 2];
  HEAP32[i6 + 4 >> 2] = i7;
  HEAP32[i4 + 8 >> 2] = HEAP32[i3 + 8 >> 2];
  HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + 16;
  i5 = i2;
  STACKTOP = i1;
  return i5 | 0;
 }
 return 0;
}
function _lua_checkstack(i7, i4) {
 i7 = i7 | 0;
 i4 = i4 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i5 = 0, i6 = 0, i8 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i1;
 HEAP32[i3 >> 2] = i4;
 i2 = HEAP32[i7 + 16 >> 2] | 0;
 i5 = i7 + 8 | 0;
 i6 = HEAP32[i5 >> 2] | 0;
 i8 = i6;
 do {
  if (((HEAP32[i7 + 24 >> 2] | 0) - i8 >> 4 | 0) <= (i4 | 0)) {
   if (((i8 - (HEAP32[i7 + 28 >> 2] | 0) >> 4) + 5 | 0) > (1e6 - i4 | 0)) {
    i8 = 0;
    STACKTOP = i1;
    return i8 | 0;
   }
   i6 = (_luaD_rawrunprotected(i7, 2, i3) | 0) == 0;
   if (i6) {
    i5 = HEAP32[i5 >> 2] | 0;
    i4 = HEAP32[i3 >> 2] | 0;
    i3 = i6 & 1;
    break;
   } else {
    i8 = 0;
    STACKTOP = i1;
    return i8 | 0;
   }
  } else {
   i5 = i6;
   i3 = 1;
  }
 } while (0);
 i2 = i2 + 4 | 0;
 i4 = i5 + (i4 << 4) | 0;
 if (!((HEAP32[i2 >> 2] | 0) >>> 0 < i4 >>> 0)) {
  i8 = i3;
  STACKTOP = i1;
  return i8 | 0;
 }
 HEAP32[i2 >> 2] = i4;
 i8 = i3;
 STACKTOP = i1;
 return i8 | 0;
}
function _luaK_exp2nextreg(i1, i3) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 _luaK_dischargevars(i1, i3);
 if (((HEAP32[i3 >> 2] | 0) == 6 ? (i4 = HEAP32[i3 + 8 >> 2] | 0, (i4 & 256 | 0) == 0) : 0) ? (HEAPU8[i1 + 46 | 0] | 0 | 0) <= (i4 | 0) : 0) {
  i7 = i1 + 48 | 0;
  HEAP8[i7] = (HEAP8[i7] | 0) + -1 << 24 >> 24;
 }
 i4 = i1 + 48 | 0;
 i5 = HEAP8[i4] | 0;
 i6 = (i5 & 255) + 1 | 0;
 i7 = (HEAP32[i1 >> 2] | 0) + 78 | 0;
 if (!(i6 >>> 0 > (HEAPU8[i7] | 0) >>> 0)) {
  i7 = i5;
  i7 = i7 & 255;
  i7 = i7 + 1 | 0;
  i6 = i7 & 255;
  HEAP8[i4] = i6;
  i7 = i7 & 255;
  i7 = i7 + -1 | 0;
  _exp2reg(i1, i3, i7);
  STACKTOP = i2;
  return;
 }
 if (i6 >>> 0 > 249) {
  _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10536);
 }
 HEAP8[i7] = i6;
 i7 = HEAP8[i4] | 0;
 i7 = i7 & 255;
 i7 = i7 + 1 | 0;
 i6 = i7 & 255;
 HEAP8[i4] = i6;
 i7 = i7 & 255;
 i7 = i7 + -1 | 0;
 _exp2reg(i1, i3, i7);
 STACKTOP = i2;
 return;
}
function _lua_next(i2, i4) {
 i2 = i2 | 0;
 i4 = i4 | 0;
 var i1 = 0, i3 = 0, i5 = 0;
 i1 = STACKTOP;
 i5 = HEAP32[i2 + 16 >> 2] | 0;
 do {
  if ((i4 | 0) <= 0) {
   if (!((i4 | 0) < -1000999)) {
    i4 = (HEAP32[i2 + 8 >> 2] | 0) + (i4 << 4) | 0;
    break;
   }
   if ((i4 | 0) == -1001e3) {
    i4 = (HEAP32[i2 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i4 = -1001e3 - i4 | 0;
   i5 = HEAP32[i5 >> 2] | 0;
   if ((HEAP32[i5 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i5 >> 2] | 0, (i4 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i4 = i3 + (i4 + -1 << 4) + 16 | 0;
   } else {
    i4 = 5192;
   }
  } else {
   i3 = (HEAP32[i5 >> 2] | 0) + (i4 << 4) | 0;
   i4 = i3 >>> 0 < (HEAP32[i2 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i3 = i2 + 8 | 0;
 i2 = _luaH_next(i2, HEAP32[i4 >> 2] | 0, (HEAP32[i3 >> 2] | 0) + -16 | 0) | 0;
 i4 = HEAP32[i3 >> 2] | 0;
 HEAP32[i3 >> 2] = (i2 | 0) == 0 ? i4 + -16 | 0 : i4 + 16 | 0;
 STACKTOP = i1;
 return i2 | 0;
}
function _inclinenumber(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 i4 = HEAP32[i1 >> 2] | 0;
 i3 = i1 + 56 | 0;
 i5 = HEAP32[i3 >> 2] | 0;
 i6 = HEAP32[i5 >> 2] | 0;
 HEAP32[i5 >> 2] = i6 + -1;
 if ((i6 | 0) == 0) {
  i5 = _luaZ_fill(i5) | 0;
 } else {
  i6 = i5 + 4 | 0;
  i5 = HEAP32[i6 >> 2] | 0;
  HEAP32[i6 >> 2] = i5 + 1;
  i5 = HEAPU8[i5] | 0;
 }
 HEAP32[i1 >> 2] = i5;
 if ((i5 | 0) == 13 | (i5 | 0) == 10 ? (i5 | 0) != (i4 | 0) : 0) {
  i3 = HEAP32[i3 >> 2] | 0;
  i6 = HEAP32[i3 >> 2] | 0;
  HEAP32[i3 >> 2] = i6 + -1;
  if ((i6 | 0) == 0) {
   i3 = _luaZ_fill(i3) | 0;
  } else {
   i6 = i3 + 4 | 0;
   i3 = HEAP32[i6 >> 2] | 0;
   HEAP32[i6 >> 2] = i3 + 1;
   i3 = HEAPU8[i3] | 0;
  }
  HEAP32[i1 >> 2] = i3;
 }
 i5 = i1 + 4 | 0;
 i6 = HEAP32[i5 >> 2] | 0;
 HEAP32[i5 >> 2] = i6 + 1;
 if ((i6 | 0) > 2147483643) {
  _luaX_syntaxerror(i1, 12560);
 } else {
  STACKTOP = i2;
  return;
 }
}
function _lua_yieldk(i5, i6, i1, i7) {
 i5 = i5 | 0;
 i6 = i6 | 0;
 i1 = i1 | 0;
 i7 = i7 | 0;
 var i2 = 0, i3 = 0, i4 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = i2;
 i3 = HEAP32[i5 + 16 >> 2] | 0;
 if ((HEAP16[i5 + 36 >> 1] | 0) != 0) {
  if ((HEAP32[(HEAP32[i5 + 12 >> 2] | 0) + 172 >> 2] | 0) == (i5 | 0)) {
   _luaG_runerror(i5, 2312, i4);
  } else {
   _luaG_runerror(i5, 2264, i4);
  }
 }
 HEAP8[i5 + 6 | 0] = 1;
 HEAP32[i3 + 20 >> 2] = (HEAP32[i3 >> 2] | 0) - (HEAP32[i5 + 28 >> 2] | 0);
 if (!((HEAP8[i3 + 18 | 0] & 1) == 0)) {
  STACKTOP = i2;
  return 0;
 }
 HEAP32[i3 + 28 >> 2] = i7;
 if ((i7 | 0) == 0) {
  i4 = i5 + 8 | 0;
  i4 = HEAP32[i4 >> 2] | 0;
  i7 = ~i6;
  i7 = i4 + (i7 << 4) | 0;
  HEAP32[i3 >> 2] = i7;
  _luaD_throw(i5, 1);
 }
 HEAP32[i3 + 24 >> 2] = i1;
 i4 = i5 + 8 | 0;
 i4 = HEAP32[i4 >> 2] | 0;
 i7 = ~i6;
 i7 = i4 + (i7 << 4) | 0;
 HEAP32[i3 >> 2] = i7;
 _luaD_throw(i5, 1);
 return 0;
}
function _luaH_getint(i4, i6) {
 i4 = i4 | 0;
 i6 = i6 | 0;
 var i1 = 0, i2 = 0, d3 = 0.0, i5 = 0, i7 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i5 = i1;
 i7 = i6 + -1 | 0;
 if (i7 >>> 0 < (HEAP32[i4 + 28 >> 2] | 0) >>> 0) {
  i7 = (HEAP32[i4 + 12 >> 2] | 0) + (i7 << 4) | 0;
  STACKTOP = i1;
  return i7 | 0;
 }
 d3 = +(i6 | 0);
 HEAPF64[i5 >> 3] = d3 + 1.0;
 i5 = (HEAP32[i5 + 4 >> 2] | 0) + (HEAP32[i5 >> 2] | 0) | 0;
 if ((i5 | 0) < 0) {
  i6 = 0 - i5 | 0;
  i5 = (i5 | 0) == (i6 | 0) ? 0 : i6;
 }
 i4 = (HEAP32[i4 + 16 >> 2] | 0) + (((i5 | 0) % ((1 << (HEAPU8[i4 + 7 | 0] | 0)) + -1 | 1 | 0) | 0) << 5) | 0;
 while (1) {
  if ((HEAP32[i4 + 24 >> 2] | 0) == 3 ? +HEAPF64[i4 + 16 >> 3] == d3 : 0) {
   break;
  }
  i4 = HEAP32[i4 + 28 >> 2] | 0;
  if ((i4 | 0) == 0) {
   i4 = 5192;
   i2 = 10;
   break;
  }
 }
 if ((i2 | 0) == 10) {
  STACKTOP = i1;
  return i4 | 0;
 }
 i7 = i4;
 STACKTOP = i1;
 return i7 | 0;
}
function _luaL_checkversion_(i1, d4) {
 i1 = i1 | 0;
 d4 = +d4;
 var i2 = 0, i3 = 0, i5 = 0, d6 = 0.0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2;
 i5 = _lua_version(i1) | 0;
 if ((i5 | 0) == (_lua_version(0) | 0)) {
  d6 = +HEAPF64[i5 >> 3];
  if (d6 != d4) {
   HEAPF64[tempDoublePtr >> 3] = d4;
   HEAP32[i3 >> 2] = HEAP32[tempDoublePtr >> 2];
   HEAP32[i3 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
   i5 = i3 + 8 | 0;
   HEAPF64[tempDoublePtr >> 3] = d6;
   HEAP32[i5 >> 2] = HEAP32[tempDoublePtr >> 2];
   HEAP32[i5 + 4 >> 2] = HEAP32[tempDoublePtr + 4 >> 2];
   _luaL_error(i1, 1528, i3) | 0;
  }
 } else {
  _luaL_error(i1, 1496, i3) | 0;
 }
 _lua_pushnumber(i1, -4660.0);
 if ((_lua_tointegerx(i1, -1, 0) | 0) == -4660 ? (_lua_tounsignedx(i1, -1, 0) | 0) == -4660 : 0) {
  _lua_settop(i1, -2);
  STACKTOP = i2;
  return;
 }
 _luaL_error(i1, 1584, i3) | 0;
 _lua_settop(i1, -2);
 STACKTOP = i2;
 return;
}
function _math_random(i1) {
 i1 = i1 | 0;
 var i2 = 0, d3 = 0.0, i4 = 0, i5 = 0, d6 = 0.0, d7 = 0.0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = i2;
 d3 = +((_rand() | 0) % 2147483647 | 0 | 0) / 2147483647.0;
 i5 = _lua_gettop(i1) | 0;
 if ((i5 | 0) == 0) {
  _lua_pushnumber(i1, d3);
  i5 = 1;
  STACKTOP = i2;
  return i5 | 0;
 } else if ((i5 | 0) == 1) {
  d6 = +_luaL_checknumber(i1, 1);
  if (!(d6 >= 1.0)) {
   _luaL_argerror(i1, 1, 4056) | 0;
  }
  _lua_pushnumber(i1, +Math_floor(+(d3 * d6)) + 1.0);
  i5 = 1;
  STACKTOP = i2;
  return i5 | 0;
 } else if ((i5 | 0) == 2) {
  d6 = +_luaL_checknumber(i1, 1);
  d7 = +_luaL_checknumber(i1, 2);
  if (!(d6 <= d7)) {
   _luaL_argerror(i1, 2, 4056) | 0;
  }
  _lua_pushnumber(i1, d6 + +Math_floor(+(d3 * (d7 - d6 + 1.0))));
  i5 = 1;
  STACKTOP = i2;
  return i5 | 0;
 } else {
  i5 = _luaL_error(i1, 4080, i4) | 0;
  STACKTOP = i2;
  return i5 | 0;
 }
 return 0;
}
function _push_onecapture(i2, i3, i4, i6) {
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 i6 = i6 | 0;
 var i1 = 0, i5 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i5 = i1;
 if ((HEAP32[i2 + 20 >> 2] | 0) <= (i3 | 0)) {
  i2 = HEAP32[i2 + 16 >> 2] | 0;
  if ((i3 | 0) == 0) {
   _lua_pushlstring(i2, i4, i6 - i4 | 0) | 0;
   STACKTOP = i1;
   return;
  } else {
   _luaL_error(i2, 7224, i5) | 0;
   STACKTOP = i1;
   return;
  }
 }
 i4 = HEAP32[i2 + (i3 << 3) + 28 >> 2] | 0;
 if (!((i4 | 0) == -1)) {
  i5 = HEAP32[i2 + 16 >> 2] | 0;
  i3 = HEAP32[i2 + (i3 << 3) + 24 >> 2] | 0;
  if ((i4 | 0) == -2) {
   _lua_pushinteger(i5, i3 + 1 - (HEAP32[i2 + 4 >> 2] | 0) | 0);
   STACKTOP = i1;
   return;
  }
 } else {
  i6 = i2 + 16 | 0;
  _luaL_error(HEAP32[i6 >> 2] | 0, 7248, i5) | 0;
  i5 = HEAP32[i6 >> 2] | 0;
  i3 = HEAP32[i2 + (i3 << 3) + 24 >> 2] | 0;
 }
 _lua_pushlstring(i5, i3, i4) | 0;
 STACKTOP = i1;
 return;
}
function _luaK_nil(i7, i6, i5) {
 i7 = i7 | 0;
 i6 = i6 | 0;
 i5 = i5 | 0;
 var i1 = 0, i2 = 0, i3 = 0, i4 = 0, i8 = 0, i9 = 0, i10 = 0, i11 = 0;
 i2 = STACKTOP;
 i9 = i5 + i6 | 0;
 i1 = i9 + -1 | 0;
 i10 = HEAP32[i7 + 20 >> 2] | 0;
 do {
  if ((i10 | 0) > (HEAP32[i7 + 24 >> 2] | 0) ? (i4 = (HEAP32[(HEAP32[i7 >> 2] | 0) + 12 >> 2] | 0) + (i10 + -1 << 2) | 0, i3 = HEAP32[i4 >> 2] | 0, (i3 & 63 | 0) == 4) : 0) {
   i11 = i3 >>> 6 & 255;
   i10 = i11 + (i3 >>> 23) | 0;
   if (!((i11 | 0) <= (i6 | 0) ? (i10 + 1 | 0) >= (i6 | 0) : 0)) {
    i8 = 5;
   }
   if ((i8 | 0) == 5 ? (i11 | 0) < (i6 | 0) | (i11 | 0) > (i9 | 0) : 0) {
    break;
   }
   i5 = (i11 | 0) < (i6 | 0) ? i11 : i6;
   HEAP32[i4 >> 2] = ((i10 | 0) > (i1 | 0) ? i10 : i1) - i5 << 23 | i5 << 6 & 16320 | i3 & 8372287;
   STACKTOP = i2;
   return;
  }
 } while (0);
 _luaK_code(i7, i6 << 6 | (i5 << 23) + -8388608 | 4) | 0;
 STACKTOP = i2;
 return;
}
function _lua_settable(i1, i5) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i4 = 0;
 i2 = STACKTOP;
 i4 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i3 = (HEAP32[i1 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i3 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i4 >> 2] | 0, (i5 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i3 = i3 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i3 = 5192;
   }
  } else {
   i3 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i3 = i3 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i5 = i1 + 8 | 0;
 i4 = HEAP32[i5 >> 2] | 0;
 _luaV_settable(i1, i3, i4 + -32 | 0, i4 + -16 | 0);
 HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + -32;
 STACKTOP = i2;
 return;
}
function _luaL_findtable(i3, i6, i5, i4) {
 i3 = i3 | 0;
 i6 = i6 | 0;
 i5 = i5 | 0;
 i4 = i4 | 0;
 var i1 = 0, i2 = 0, i7 = 0;
 i2 = STACKTOP;
 if ((i6 | 0) != 0) {
  _lua_pushvalue(i3, i6);
 }
 while (1) {
  i6 = _strchr(i5, 46) | 0;
  if ((i6 | 0) == 0) {
   i6 = i5 + (_strlen(i5 | 0) | 0) | 0;
  }
  i7 = i6 - i5 | 0;
  _lua_pushlstring(i3, i5, i7) | 0;
  _lua_rawget(i3, -2);
  if ((_lua_type(i3, -1) | 0) != 0) {
   if ((_lua_type(i3, -1) | 0) != 5) {
    break;
   }
  } else {
   _lua_settop(i3, -2);
   _lua_createtable(i3, 0, (HEAP8[i6] | 0) == 46 ? 1 : i4);
   _lua_pushlstring(i3, i5, i7) | 0;
   _lua_pushvalue(i3, -2);
   _lua_settable(i3, -4);
  }
  _lua_remove(i3, -2);
  if ((HEAP8[i6] | 0) == 46) {
   i5 = i6 + 1 | 0;
  } else {
   i3 = 0;
   i1 = 10;
   break;
  }
 }
 if ((i1 | 0) == 10) {
  STACKTOP = i2;
  return i3 | 0;
 }
 _lua_settop(i3, -3);
 i7 = i5;
 STACKTOP = i2;
 return i7 | 0;
}
function _luaD_call(i1, i4, i5, i8) {
 i1 = i1 | 0;
 i4 = i4 | 0;
 i5 = i5 | 0;
 i8 = i8 | 0;
 var i2 = 0, i3 = 0, i6 = 0, i7 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i7 = i3;
 i2 = i1 + 38 | 0;
 i6 = (HEAP16[i2 >> 1] | 0) + 1 << 16 >> 16;
 HEAP16[i2 >> 1] = i6;
 if ((i6 & 65535) > 199) {
  if (i6 << 16 >> 16 == 200) {
   _luaG_runerror(i1, 2240, i7);
  }
  if ((i6 & 65535) > 224) {
   _luaD_throw(i1, 6);
  }
 }
 i6 = (i8 | 0) != 0;
 if (!i6) {
  i8 = i1 + 36 | 0;
  HEAP16[i8 >> 1] = (HEAP16[i8 >> 1] | 0) + 1 << 16 >> 16;
 }
 if ((_luaD_precall(i1, i4, i5) | 0) == 0) {
  _luaV_execute(i1);
 }
 if (i6) {
  i8 = HEAP16[i2 >> 1] | 0;
  i8 = i8 + -1 << 16 >> 16;
  HEAP16[i2 >> 1] = i8;
  STACKTOP = i3;
  return;
 }
 i8 = i1 + 36 | 0;
 HEAP16[i8 >> 1] = (HEAP16[i8 >> 1] | 0) + -1 << 16 >> 16;
 i8 = HEAP16[i2 >> 1] | 0;
 i8 = i8 + -1 << 16 >> 16;
 HEAP16[i2 >> 1] = i8;
 STACKTOP = i3;
 return;
}
function _pushline(i6, i1) {
 i6 = i6 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 528 | 0;
 i4 = i2;
 i3 = i2 + 8 | 0;
 i7 = (i1 | 0) != 0;
 _lua_getglobal(i6, i7 ? 288 : 296);
 i8 = _lua_tolstring(i6, -1, 0) | 0;
 if ((i8 | 0) == 0) {
  i8 = i7 ? 312 : 320;
 }
 i7 = HEAP32[_stdout >> 2] | 0;
 _fputs(i8 | 0, i7 | 0) | 0;
 _fflush(i7 | 0) | 0;
 i8 = (_fgets(i3 | 0, 512, HEAP32[_stdin >> 2] | 0) | 0) == 0;
 _lua_settop(i6, -2);
 if (i8) {
  i8 = 0;
  STACKTOP = i2;
  return i8 | 0;
 }
 i7 = _strlen(i3 | 0) | 0;
 if ((i7 | 0) != 0 ? (i5 = i3 + (i7 + -1) | 0, (HEAP8[i5] | 0) == 10) : 0) {
  HEAP8[i5] = 0;
 }
 if ((i1 | 0) != 0 ? (HEAP8[i3] | 0) == 61 : 0) {
  HEAP32[i4 >> 2] = i3 + 1;
  _lua_pushfstring(i6, 272, i4) | 0;
  i8 = 1;
  STACKTOP = i2;
  return i8 | 0;
 }
 _lua_pushstring(i6, i3) | 0;
 i8 = 1;
 STACKTOP = i2;
 return i8 | 0;
}
function _db_getlocal(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 112 | 0;
 i4 = i2;
 if ((_lua_type(i1, 1) | 0) == 8) {
  i3 = _lua_tothread(i1, 1) | 0;
  i6 = 1;
 } else {
  i3 = i1;
  i6 = 0;
 }
 i5 = _luaL_checkinteger(i1, i6 | 2) | 0;
 i6 = i6 + 1 | 0;
 if ((_lua_type(i1, i6) | 0) == 6) {
  _lua_pushvalue(i1, i6);
  _lua_pushstring(i1, _lua_getlocal(i1, 0, i5) | 0) | 0;
  i6 = 1;
  STACKTOP = i2;
  return i6 | 0;
 }
 if ((_lua_getstack(i3, _luaL_checkinteger(i1, i6) | 0, i4) | 0) == 0) {
  i6 = _luaL_argerror(i1, i6, 11560) | 0;
  STACKTOP = i2;
  return i6 | 0;
 }
 i4 = _lua_getlocal(i3, i4, i5) | 0;
 if ((i4 | 0) == 0) {
  _lua_pushnil(i1);
  i6 = 1;
  STACKTOP = i2;
  return i6 | 0;
 } else {
  _lua_xmove(i3, i1, 1);
  _lua_pushstring(i1, i4) | 0;
  _lua_pushvalue(i1, -2);
  i6 = 2;
  STACKTOP = i2;
  return i6 | 0;
 }
 return 0;
}
function _luaB_print(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i2 = i3;
 i4 = i3 + 4 | 0;
 i6 = _lua_gettop(i1) | 0;
 _lua_getglobal(i1, 9584);
 i5 = HEAP32[_stdout >> 2] | 0;
 L1 : do {
  if ((i6 | 0) >= 1) {
   i7 = 1;
   while (1) {
    _lua_pushvalue(i1, -1);
    _lua_pushvalue(i1, i7);
    _lua_callk(i1, 1, 1, 0, 0);
    i8 = _lua_tolstring(i1, -1, i4) | 0;
    if ((i8 | 0) == 0) {
     break;
    }
    if ((i7 | 0) > 1) {
     _fputc(9, i5 | 0) | 0;
    }
    _fwrite(i8 | 0, 1, HEAP32[i4 >> 2] | 0, i5 | 0) | 0;
    _lua_settop(i1, -2);
    if ((i7 | 0) < (i6 | 0)) {
     i7 = i7 + 1 | 0;
    } else {
     break L1;
    }
   }
   i8 = _luaL_error(i1, 9816, i2) | 0;
   STACKTOP = i3;
   return i8 | 0;
  }
 } while (0);
 _fputc(10, i5 | 0) | 0;
 _fflush(i5 | 0) | 0;
 i8 = 0;
 STACKTOP = i3;
 return i8 | 0;
}
function _luaB_load(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i5 = i2;
 i6 = _lua_tolstring(i1, 1, i5) | 0;
 i4 = _luaL_optlstring(i1, 3, 9872, 0) | 0;
 i3 = (_lua_type(i1, 4) | 0) != -1;
 if ((i6 | 0) == 0) {
  i6 = _luaL_optlstring(i1, 2, 9880, 0) | 0;
  _luaL_checktype(i1, 1, 6);
  _lua_settop(i1, 5);
  i4 = _lua_load(i1, 3, 0, i6, i4) | 0;
 } else {
  i7 = _luaL_optlstring(i1, 2, i6, 0) | 0;
  i4 = _luaL_loadbufferx(i1, i6, HEAP32[i5 >> 2] | 0, i7, i4) | 0;
 }
 if ((i4 | 0) != 0) {
  _lua_pushnil(i1);
  _lua_insert(i1, -2);
  i7 = 2;
  STACKTOP = i2;
  return i7 | 0;
 }
 if (!i3) {
  i7 = 1;
  STACKTOP = i2;
  return i7 | 0;
 }
 _lua_pushvalue(i1, i3 ? 4 : 0);
 if ((_lua_setupvalue(i1, -2, 1) | 0) != 0) {
  i7 = 1;
  STACKTOP = i2;
  return i7 | 0;
 }
 _lua_settop(i1, -2);
 i7 = 1;
 STACKTOP = i2;
 return i7 | 0;
}
function _db_debug(i2) {
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 256 | 0;
 i6 = i1;
 i4 = i1 + 4 | 0;
 i3 = HEAP32[_stderr >> 2] | 0;
 _fwrite(12040, 11, 1, i3 | 0) | 0;
 _fflush(i3 | 0) | 0;
 i5 = HEAP32[_stdin >> 2] | 0;
 if ((_fgets(i4 | 0, 250, i5 | 0) | 0) == 0) {
  STACKTOP = i1;
  return 0;
 }
 while (1) {
  if ((_strcmp(i4, 12056) | 0) == 0) {
   i2 = 7;
   break;
  }
  if (!((_luaL_loadbufferx(i2, i4, _strlen(i4 | 0) | 0, 12064, 0) | 0) == 0 ? (_lua_pcallk(i2, 0, 0, 0, 0, 0) | 0) == 0 : 0)) {
   HEAP32[i6 >> 2] = _lua_tolstring(i2, -1, 0) | 0;
   _fprintf(i3 | 0, 12088, i6 | 0) | 0;
   _fflush(i3 | 0) | 0;
  }
  _lua_settop(i2, 0);
  _fwrite(12040, 11, 1, i3 | 0) | 0;
  _fflush(i3 | 0) | 0;
  if ((_fgets(i4 | 0, 250, i5 | 0) | 0) == 0) {
   i2 = 7;
   break;
  }
 }
 if ((i2 | 0) == 7) {
  STACKTOP = i1;
  return 0;
 }
 return 0;
}
function _luaL_prepbuffsize(i2, i7) {
 i2 = i2 | 0;
 i7 = i7 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i8 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i1 = HEAP32[i2 + 12 >> 2] | 0;
 i4 = i2 + 4 | 0;
 i8 = HEAP32[i4 >> 2] | 0;
 i5 = i2 + 8 | 0;
 i6 = HEAP32[i5 >> 2] | 0;
 if (!((i8 - i6 | 0) >>> 0 < i7 >>> 0)) {
  i7 = HEAP32[i2 >> 2] | 0;
  i8 = i6;
  i8 = i7 + i8 | 0;
  STACKTOP = i3;
  return i8 | 0;
 }
 i8 = i8 << 1;
 i8 = (i8 - i6 | 0) >>> 0 < i7 >>> 0 ? i6 + i7 | 0 : i8;
 if (i8 >>> 0 < i6 >>> 0 | (i8 - i6 | 0) >>> 0 < i7 >>> 0) {
  _luaL_error(i1, 1272, i3) | 0;
 }
 i6 = _lua_newuserdata(i1, i8) | 0;
 _memcpy(i6 | 0, HEAP32[i2 >> 2] | 0, HEAP32[i5 >> 2] | 0) | 0;
 if ((HEAP32[i2 >> 2] | 0) != (i2 + 16 | 0)) {
  _lua_remove(i1, -2);
 }
 HEAP32[i2 >> 2] = i6;
 HEAP32[i4 >> 2] = i8;
 i7 = i6;
 i8 = HEAP32[i5 >> 2] | 0;
 i8 = i7 + i8 | 0;
 STACKTOP = i3;
 return i8 | 0;
}
function _luaG_runerror(i1, i5, i4) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 i4 = i4 | 0;
 var i2 = 0, i3 = 0, i6 = 0, i7 = 0;
 i6 = STACKTOP;
 STACKTOP = STACKTOP + 96 | 0;
 i2 = i6;
 i3 = i6 + 32 | 0;
 i6 = i6 + 16 | 0;
 HEAP32[i6 >> 2] = i4;
 i4 = _luaO_pushvfstring(i1, i5, i6) | 0;
 i6 = HEAP32[i1 + 16 >> 2] | 0;
 if ((HEAP8[i6 + 18 | 0] & 1) == 0) {
  _luaG_errormsg(i1);
 }
 i5 = HEAP32[(HEAP32[HEAP32[i6 >> 2] >> 2] | 0) + 12 >> 2] | 0;
 i7 = HEAP32[i5 + 20 >> 2] | 0;
 if ((i7 | 0) == 0) {
  i6 = 0;
 } else {
  i6 = HEAP32[i7 + (((HEAP32[i6 + 28 >> 2] | 0) - (HEAP32[i5 + 12 >> 2] | 0) >> 2) + -1 << 2) >> 2] | 0;
 }
 i5 = HEAP32[i5 + 36 >> 2] | 0;
 if ((i5 | 0) == 0) {
  HEAP8[i3] = 63;
  HEAP8[i3 + 1 | 0] = 0;
 } else {
  _luaO_chunkid(i3, i5 + 16 | 0, 60);
 }
 HEAP32[i2 >> 2] = i3;
 HEAP32[i2 + 4 >> 2] = i6;
 HEAP32[i2 + 8 >> 2] = i4;
 _luaO_pushfstring(i1, 2024, i2) | 0;
 _luaG_errormsg(i1);
}
function _db_upvaluejoin(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 112 | 0;
 i4 = i3;
 i2 = _luaL_checkinteger(i1, 2) | 0;
 _luaL_checktype(i1, 1, 6);
 _lua_pushvalue(i1, 1);
 _lua_getinfo(i1, 11728, i4) | 0;
 if (!((i2 | 0) > 0 ? (i2 | 0) <= (HEAPU8[i4 + 32 | 0] | 0 | 0) : 0)) {
  _luaL_argerror(i1, 2, 11736) | 0;
 }
 i5 = _luaL_checkinteger(i1, 4) | 0;
 _luaL_checktype(i1, 3, 6);
 _lua_pushvalue(i1, 3);
 _lua_getinfo(i1, 11728, i4) | 0;
 if (!((i5 | 0) > 0 ? (i5 | 0) <= (HEAPU8[i4 + 32 | 0] | 0 | 0) : 0)) {
  _luaL_argerror(i1, 4, 11736) | 0;
 }
 if ((_lua_iscfunction(i1, 1) | 0) != 0) {
  _luaL_argerror(i1, 1, 11760) | 0;
 }
 if ((_lua_iscfunction(i1, 3) | 0) == 0) {
  _lua_upvaluejoin(i1, 1, i2, 3, i5);
  STACKTOP = i3;
  return 0;
 }
 _luaL_argerror(i1, 3, 11760) | 0;
 _lua_upvaluejoin(i1, 1, i2, 3, i5);
 STACKTOP = i3;
 return 0;
}
function _luaK_jump(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0;
 i3 = STACKTOP;
 i2 = i1 + 28 | 0;
 i7 = HEAP32[i2 >> 2] | 0;
 HEAP32[i2 >> 2] = -1;
 i2 = _luaK_code(i1, 2147450903) | 0;
 if ((i7 | 0) == -1) {
  i9 = i2;
  STACKTOP = i3;
  return i9 | 0;
 }
 if ((i2 | 0) == -1) {
  i9 = i7;
  STACKTOP = i3;
  return i9 | 0;
 }
 i6 = HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0;
 i8 = i2;
 while (1) {
  i5 = i6 + (i8 << 2) | 0;
  i4 = HEAP32[i5 >> 2] | 0;
  i9 = (i4 >>> 14) + -131071 | 0;
  if ((i9 | 0) == -1) {
   break;
  }
  i9 = i8 + 1 + i9 | 0;
  if ((i9 | 0) == -1) {
   break;
  } else {
   i8 = i9;
  }
 }
 i6 = i7 + ~i8 | 0;
 if ((((i6 | 0) > -1 ? i6 : 0 - i6 | 0) | 0) > 131071) {
  _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10624);
 }
 HEAP32[i5 >> 2] = (i6 << 14) + 2147467264 | i4 & 16383;
 i9 = i2;
 STACKTOP = i3;
 return i9 | 0;
}
function _findfield(i2, i3, i4) {
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 var i1 = 0;
 i1 = STACKTOP;
 L1 : do {
  if (((i4 | 0) != 0 ? (_lua_type(i2, -1) | 0) == 5 : 0) ? (_lua_pushnil(i2), (_lua_next(i2, -2) | 0) != 0) : 0) {
   i4 = i4 + -1 | 0;
   while (1) {
    if ((_lua_type(i2, -2) | 0) == 4) {
     if ((_lua_rawequal(i2, i3, -1) | 0) != 0) {
      i3 = 7;
      break;
     }
     if ((_findfield(i2, i3, i4) | 0) != 0) {
      i3 = 9;
      break;
     }
    }
    _lua_settop(i2, -2);
    if ((_lua_next(i2, -2) | 0) == 0) {
     i2 = 0;
     break L1;
    }
   }
   if ((i3 | 0) == 7) {
    _lua_settop(i2, -2);
    i2 = 1;
    break;
   } else if ((i3 | 0) == 9) {
    _lua_remove(i2, -2);
    _lua_pushlstring(i2, 1776, 1) | 0;
    _lua_insert(i2, -2);
    _lua_concat(i2, 3);
    i2 = 1;
    break;
   }
  } else {
   i2 = 0;
  }
 } while (0);
 STACKTOP = i1;
 return i2 | 0;
}
function _db_gethook(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i2 = i3;
 if ((_lua_type(i1, 1) | 0) == 8) {
  i4 = _lua_tothread(i1, 1) | 0;
 } else {
  i4 = i1;
 }
 i5 = _lua_gethookmask(i4) | 0;
 i6 = _lua_gethook(i4) | 0;
 if ((i6 | 0) != 0 & (i6 | 0) != 9) {
  _lua_pushlstring(i1, 12024, 13) | 0;
 } else {
  _luaL_getsubtable(i1, -1001e3, 11584) | 0;
  _lua_pushthread(i4) | 0;
  _lua_xmove(i4, i1, 1);
  _lua_rawget(i1, -2);
  _lua_remove(i1, -2);
 }
 if ((i5 & 1 | 0) == 0) {
  i6 = 0;
 } else {
  HEAP8[i2] = 99;
  i6 = 1;
 }
 if ((i5 & 2 | 0) != 0) {
  HEAP8[i2 + i6 | 0] = 114;
  i6 = i6 + 1 | 0;
 }
 if ((i5 & 4 | 0) != 0) {
  HEAP8[i2 + i6 | 0] = 108;
  i6 = i6 + 1 | 0;
 }
 HEAP8[i2 + i6 | 0] = 0;
 _lua_pushstring(i1, i2) | 0;
 _lua_pushinteger(i1, _lua_gethookcount(i4) | 0);
 STACKTOP = i3;
 return 3;
}
function _lua_tothread(i3, i5) {
 i3 = i3 | 0;
 i5 = i5 | 0;
 var i1 = 0, i2 = 0, i4 = 0;
 i1 = STACKTOP;
 i4 = HEAP32[i3 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i2 = (HEAP32[i3 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i2 = (HEAP32[i3 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i3 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i2 = HEAP32[i4 >> 2] | 0, (i3 | 0) <= (HEAPU8[i2 + 6 | 0] | 0 | 0)) : 0) {
    i2 = i2 + (i3 + -1 << 4) + 16 | 0;
   } else {
    i2 = 5192;
   }
  } else {
   i2 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i2 = i2 >>> 0 < (HEAP32[i3 + 8 >> 2] | 0) >>> 0 ? i2 : 5192;
  }
 } while (0);
 if ((HEAP32[i2 + 8 >> 2] | 0) != 72) {
  i5 = 0;
  STACKTOP = i1;
  return i5 | 0;
 }
 i5 = HEAP32[i2 >> 2] | 0;
 STACKTOP = i1;
 return i5 | 0;
}
function _luaD_throw(i1, i2) {
 i1 = i1 | 0;
 i2 = i2 | 0;
 var i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0;
 i3 = i1 + 64 | 0;
 i4 = HEAP32[i3 >> 2] | 0;
 if ((i4 | 0) != 0) {
  HEAP32[i4 + 160 >> 2] = i2;
  _longjmp((HEAP32[i3 >> 2] | 0) + 4 | 0, 1);
 }
 HEAP8[i1 + 6 | 0] = i2;
 i4 = i1 + 12 | 0;
 i3 = HEAP32[i4 >> 2] | 0;
 i5 = HEAP32[i3 + 172 >> 2] | 0;
 if ((HEAP32[i5 + 64 >> 2] | 0) != 0) {
  i6 = HEAP32[i1 + 8 >> 2] | 0;
  i9 = i5 + 8 | 0;
  i5 = HEAP32[i9 >> 2] | 0;
  HEAP32[i9 >> 2] = i5 + 16;
  i9 = i6 + -16 | 0;
  i8 = HEAP32[i9 + 4 >> 2] | 0;
  i7 = i5;
  HEAP32[i7 >> 2] = HEAP32[i9 >> 2];
  HEAP32[i7 + 4 >> 2] = i8;
  HEAP32[i5 + 8 >> 2] = HEAP32[i6 + -8 >> 2];
  _luaD_throw(HEAP32[(HEAP32[i4 >> 2] | 0) + 172 >> 2] | 0, i2);
 }
 i2 = HEAP32[i3 + 168 >> 2] | 0;
 if ((i2 | 0) == 0) {
  _abort();
 }
 FUNCTION_TABLE_ii[i2 & 255](i1) | 0;
 _abort();
}
function _lua_len(i1, i5) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i4 = 0;
 i2 = STACKTOP;
 i4 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i3 = (HEAP32[i1 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i3 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i4 >> 2] | 0, (i5 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i3 = i3 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i3 = 5192;
   }
  } else {
   i3 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i3 = i3 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i5 = i1 + 8 | 0;
 _luaV_objlen(i1, HEAP32[i5 >> 2] | 0, i3);
 HEAP32[i5 >> 2] = (HEAP32[i5 >> 2] | 0) + 16;
 STACKTOP = i2;
 return;
}
function _read_line(i4, i5, i1) {
 i4 = i4 | 0;
 i5 = i5 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i6 = 0, i7 = 0, i8 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 1040 | 0;
 i2 = i3;
 _luaL_buffinit(i4, i2);
 i7 = _luaL_prepbuffsize(i2, 1024) | 0;
 L1 : do {
  if ((_fgets(i7 | 0, 1024, i5 | 0) | 0) != 0) {
   i6 = i2 + 8 | 0;
   while (1) {
    i8 = _strlen(i7 | 0) | 0;
    if ((i8 | 0) != 0 ? (HEAP8[i7 + (i8 + -1) | 0] | 0) == 10 : 0) {
     break;
    }
    HEAP32[i6 >> 2] = (HEAP32[i6 >> 2] | 0) + i8;
    i7 = _luaL_prepbuffsize(i2, 1024) | 0;
    if ((_fgets(i7 | 0, 1024, i5 | 0) | 0) == 0) {
     break L1;
    }
   }
   HEAP32[i6 >> 2] = i8 - i1 + (HEAP32[i6 >> 2] | 0);
   _luaL_pushresult(i2);
   i8 = 1;
   STACKTOP = i3;
   return i8 | 0;
  }
 } while (0);
 _luaL_pushresult(i2);
 i8 = (_lua_rawlen(i4, -1) | 0) != 0 | 0;
 STACKTOP = i3;
 return i8 | 0;
}
function _luaL_tolstring(i1, i5, i4) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 i4 = i4 | 0;
 var i2 = 0, i3 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2;
 do {
  if ((_luaL_callmeta(i1, i5, 1384) | 0) == 0) {
   i6 = _lua_type(i1, i5) | 0;
   if ((i6 | 0) == 0) {
    _lua_pushlstring(i1, 1416, 3) | 0;
    break;
   } else if ((i6 | 0) == 1) {
    i6 = (_lua_toboolean(i1, i5) | 0) != 0;
    _lua_pushstring(i1, i6 ? 1400 : 1408) | 0;
    break;
   } else if ((i6 | 0) == 4 | (i6 | 0) == 3) {
    _lua_pushvalue(i1, i5);
    break;
   } else {
    i7 = _lua_typename(i1, _lua_type(i1, i5) | 0) | 0;
    i6 = _lua_topointer(i1, i5) | 0;
    HEAP32[i3 >> 2] = i7;
    HEAP32[i3 + 4 >> 2] = i6;
    _lua_pushfstring(i1, 1424, i3) | 0;
    break;
   }
  }
 } while (0);
 i7 = _lua_tolstring(i1, -1, i4) | 0;
 STACKTOP = i2;
 return i7 | 0;
}
function _save(i7, i1) {
 i7 = i7 | 0;
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i8 = 0;
 i2 = STACKTOP;
 i4 = HEAP32[i7 + 60 >> 2] | 0;
 i3 = i4 + 4 | 0;
 i8 = HEAP32[i3 >> 2] | 0;
 i6 = i4 + 8 | 0;
 i5 = HEAP32[i6 >> 2] | 0;
 if (!((i8 + 1 | 0) >>> 0 > i5 >>> 0)) {
  i6 = HEAP32[i4 >> 2] | 0;
  i7 = i1 & 255;
  i5 = i8 + 1 | 0;
  HEAP32[i3 >> 2] = i5;
  i8 = i6 + i8 | 0;
  HEAP8[i8] = i7;
  STACKTOP = i2;
  return;
 }
 if (i5 >>> 0 > 2147483645) {
  _lexerror(i7, 12368, 0);
 }
 i8 = i5 << 1;
 i7 = HEAP32[i7 + 52 >> 2] | 0;
 if ((i8 | 0) == -2) {
  _luaM_toobig(i7);
 }
 i7 = _luaM_realloc_(i7, HEAP32[i4 >> 2] | 0, i5, i8) | 0;
 HEAP32[i4 >> 2] = i7;
 HEAP32[i6 >> 2] = i8;
 i8 = HEAP32[i3 >> 2] | 0;
 i6 = i7;
 i7 = i1 & 255;
 i5 = i8 + 1 | 0;
 HEAP32[i3 >> 2] = i5;
 i8 = i6 + i8 | 0;
 HEAP8[i8] = i7;
 STACKTOP = i2;
 return;
}
function _luaK_patchtohere(i1, i3) {
 i1 = i1 | 0;
 i3 = i3 | 0;
 var i2 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 HEAP32[i1 + 24 >> 2] = HEAP32[i1 + 20 >> 2];
 i4 = i1 + 28 | 0;
 if ((i3 | 0) == -1) {
  STACKTOP = i2;
  return;
 }
 i7 = HEAP32[i4 >> 2] | 0;
 if ((i7 | 0) == -1) {
  HEAP32[i4 >> 2] = i3;
  STACKTOP = i2;
  return;
 }
 i4 = HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0;
 while (1) {
  i6 = i4 + (i7 << 2) | 0;
  i5 = HEAP32[i6 >> 2] | 0;
  i8 = (i5 >>> 14) + -131071 | 0;
  if ((i8 | 0) == -1) {
   break;
  }
  i8 = i7 + 1 + i8 | 0;
  if ((i8 | 0) == -1) {
   break;
  } else {
   i7 = i8;
  }
 }
 i3 = ~i7 + i3 | 0;
 if ((((i3 | 0) > -1 ? i3 : 0 - i3 | 0) | 0) > 131071) {
  _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10624);
 }
 HEAP32[i6 >> 2] = (i3 << 14) + 2147467264 | i5 & 16383;
 STACKTOP = i2;
 return;
}
function _tinsert(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i7 = i2;
 _luaL_checktype(i1, 1, 5);
 i4 = _luaL_len(i1, 1) | 0;
 i3 = i4 + 1 | 0;
 i6 = _lua_gettop(i1) | 0;
 if ((i6 | 0) == 3) {
  i5 = 2;
 } else if ((i6 | 0) != 2) {
  i7 = _luaL_error(i1, 8320, i7) | 0;
  STACKTOP = i2;
  return i7 | 0;
 }
 if ((i5 | 0) == 2) {
  i5 = _luaL_checkinteger(i1, 2) | 0;
  if ((i5 | 0) < 1 | (i5 | 0) > (i3 | 0)) {
   _luaL_argerror(i1, 2, 8256) | 0;
  }
  if ((i4 | 0) < (i5 | 0)) {
   i3 = i5;
  } else {
   while (1) {
    i4 = i3 + -1 | 0;
    _lua_rawgeti(i1, 1, i4);
    _lua_rawseti(i1, 1, i3);
    if ((i4 | 0) > (i5 | 0)) {
     i3 = i4;
    } else {
     i3 = i5;
     break;
    }
   }
  }
 }
 _lua_rawseti(i1, 1, i3);
 i7 = 0;
 STACKTOP = i2;
 return i7 | 0;
}
function _lua_iscfunction(i3, i5) {
 i3 = i3 | 0;
 i5 = i5 | 0;
 var i1 = 0, i2 = 0, i4 = 0;
 i1 = STACKTOP;
 i4 = HEAP32[i3 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i2 = (HEAP32[i3 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i2 = (HEAP32[i3 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i3 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i2 = HEAP32[i4 >> 2] | 0, (i3 | 0) <= (HEAPU8[i2 + 6 | 0] | 0 | 0)) : 0) {
    i2 = i2 + (i3 + -1 << 4) + 16 | 0;
   } else {
    i2 = 5192;
   }
  } else {
   i2 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i2 = i2 >>> 0 < (HEAP32[i3 + 8 >> 2] | 0) >>> 0 ? i2 : 5192;
  }
 } while (0);
 i5 = HEAP32[i2 + 8 >> 2] | 0;
 STACKTOP = i1;
 return ((i5 | 0) == 22 | (i5 | 0) == 102) & 1 | 0;
}
function _lua_gettable(i1, i5) {
 i1 = i1 | 0;
 i5 = i5 | 0;
 var i2 = 0, i3 = 0, i4 = 0;
 i2 = STACKTOP;
 i4 = HEAP32[i1 + 16 >> 2] | 0;
 do {
  if ((i5 | 0) <= 0) {
   if (!((i5 | 0) < -1000999)) {
    i3 = (HEAP32[i1 + 8 >> 2] | 0) + (i5 << 4) | 0;
    break;
   }
   if ((i5 | 0) == -1001e3) {
    i3 = (HEAP32[i1 + 12 >> 2] | 0) + 40 | 0;
    break;
   }
   i5 = -1001e3 - i5 | 0;
   i4 = HEAP32[i4 >> 2] | 0;
   if ((HEAP32[i4 + 8 >> 2] | 0) != 22 ? (i3 = HEAP32[i4 >> 2] | 0, (i5 | 0) <= (HEAPU8[i3 + 6 | 0] | 0 | 0)) : 0) {
    i3 = i3 + (i5 + -1 << 4) + 16 | 0;
   } else {
    i3 = 5192;
   }
  } else {
   i3 = (HEAP32[i4 >> 2] | 0) + (i5 << 4) | 0;
   i3 = i3 >>> 0 < (HEAP32[i1 + 8 >> 2] | 0) >>> 0 ? i3 : 5192;
  }
 } while (0);
 i5 = (HEAP32[i1 + 8 >> 2] | 0) + -16 | 0;
 _luaV_gettable(i1, i3, i5, i5);
 STACKTOP = i2;
 return;
}
function _luaG_errormsg(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0, i9 = 0;
 i2 = HEAP32[i1 + 68 >> 2] | 0;
 if ((i2 | 0) == 0) {
  _luaD_throw(i1, 2);
 }
 i4 = HEAP32[i1 + 28 >> 2] | 0;
 i3 = i4 + (i2 + 8) | 0;
 if ((HEAP32[i3 >> 2] & 15 | 0) != 6) {
  _luaD_throw(i1, 6);
 }
 i5 = i1 + 8 | 0;
 i6 = HEAP32[i5 >> 2] | 0;
 i9 = i6 + -16 | 0;
 i8 = HEAP32[i9 + 4 >> 2] | 0;
 i7 = i6;
 HEAP32[i7 >> 2] = HEAP32[i9 >> 2];
 HEAP32[i7 + 4 >> 2] = i8;
 HEAP32[i6 + 8 >> 2] = HEAP32[i6 + -8 >> 2];
 i6 = HEAP32[i5 >> 2] | 0;
 i7 = i4 + i2 | 0;
 i2 = HEAP32[i7 + 4 >> 2] | 0;
 i4 = i6 + -16 | 0;
 HEAP32[i4 >> 2] = HEAP32[i7 >> 2];
 HEAP32[i4 + 4 >> 2] = i2;
 HEAP32[i6 + -8 >> 2] = HEAP32[i3 >> 2];
 i4 = HEAP32[i5 >> 2] | 0;
 HEAP32[i5 >> 2] = i4 + 16;
 _luaD_call(i1, i4 + -16 | 0, 1, 0);
 _luaD_throw(i1, 2);
}
function _luaB_costatus(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0;
 i4 = STACKTOP;
 STACKTOP = STACKTOP + 112 | 0;
 i3 = i4;
 i2 = _lua_tothread(i1, 1) | 0;
 if ((i2 | 0) == 0) {
  _luaL_argerror(i1, 1, 10856) | 0;
 }
 do {
  if ((i2 | 0) != (i1 | 0)) {
   i5 = _lua_status(i2) | 0;
   if ((i5 | 0) == 0) {
    if ((_lua_getstack(i2, 0, i3) | 0) > 0) {
     _lua_pushlstring(i1, 10896, 6) | 0;
     break;
    }
    if ((_lua_gettop(i2) | 0) == 0) {
     _lua_pushlstring(i1, 10904, 4) | 0;
     break;
    } else {
     _lua_pushlstring(i1, 10880, 9) | 0;
     break;
    }
   } else if ((i5 | 0) == 1) {
    _lua_pushlstring(i1, 10880, 9) | 0;
    break;
   } else {
    _lua_pushlstring(i1, 10904, 4) | 0;
    break;
   }
  } else {
   _lua_pushlstring(i1, 10728, 7) | 0;
  }
 } while (0);
 STACKTOP = i4;
 return 1;
}
function _searcher_Lua(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2;
 i4 = _luaL_checklstring(i1, 1, 0) | 0;
 _lua_getfield(i1, -1001001, 4256);
 i5 = _lua_tolstring(i1, -1, 0) | 0;
 if ((i5 | 0) == 0) {
  HEAP32[i3 >> 2] = 4256;
  _luaL_error(i1, 5032, i3) | 0;
 }
 i4 = _searchpath(i1, i4, i5, 4936, 4848) | 0;
 if ((i4 | 0) == 0) {
  i5 = 1;
  STACKTOP = i2;
  return i5 | 0;
 }
 if ((_luaL_loadfilex(i1, i4, 0) | 0) == 0) {
  _lua_pushstring(i1, i4) | 0;
  i5 = 2;
  STACKTOP = i2;
  return i5 | 0;
 } else {
  i6 = _lua_tolstring(i1, 1, 0) | 0;
  i5 = _lua_tolstring(i1, -1, 0) | 0;
  HEAP32[i3 >> 2] = i6;
  HEAP32[i3 + 4 >> 2] = i4;
  HEAP32[i3 + 8 >> 2] = i5;
  i5 = _luaL_error(i1, 4888, i3) | 0;
  STACKTOP = i2;
  return i5 | 0;
 }
 return 0;
}
function _str_sub(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i3 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i4 = i3;
 i2 = _luaL_checklstring(i1, 1, i4) | 0;
 i5 = _luaL_checkinteger(i1, 2) | 0;
 i6 = HEAP32[i4 >> 2] | 0;
 if (!((i5 | 0) > -1)) {
  if (i6 >>> 0 < (0 - i5 | 0) >>> 0) {
   i5 = 0;
  } else {
   i5 = i5 + 1 + i6 | 0;
  }
 }
 i6 = _luaL_optinteger(i1, 3, -1) | 0;
 i4 = HEAP32[i4 >> 2] | 0;
 if (!((i6 | 0) > -1)) {
  if (i4 >>> 0 < (0 - i6 | 0) >>> 0) {
   i6 = 0;
  } else {
   i6 = i6 + 1 + i4 | 0;
  }
 }
 i5 = (i5 | 0) == 0 ? 1 : i5;
 i4 = i6 >>> 0 > i4 >>> 0 ? i4 : i6;
 if (i5 >>> 0 > i4 >>> 0) {
  _lua_pushlstring(i1, 7040, 0) | 0;
  STACKTOP = i3;
  return 1;
 } else {
  _lua_pushlstring(i1, i2 + (i5 + -1) | 0, 1 - i5 + i4 | 0) | 0;
  STACKTOP = i3;
  return 1;
 }
 return 0;
}
function _searcher_C(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i3 = i2;
 i4 = _luaL_checklstring(i1, 1, 0) | 0;
 _lua_getfield(i1, -1001001, 4440);
 i5 = _lua_tolstring(i1, -1, 0) | 0;
 if ((i5 | 0) == 0) {
  HEAP32[i3 >> 2] = 4440;
  _luaL_error(i1, 5032, i3) | 0;
 }
 i5 = _searchpath(i1, i4, i5, 4936, 4848) | 0;
 if ((i5 | 0) == 0) {
  i5 = 1;
  STACKTOP = i2;
  return i5 | 0;
 }
 if ((_loadfunc(i1, i5, i4) | 0) == 0) {
  _lua_pushstring(i1, i5) | 0;
  i5 = 2;
  STACKTOP = i2;
  return i5 | 0;
 } else {
  i6 = _lua_tolstring(i1, 1, 0) | 0;
  i4 = _lua_tolstring(i1, -1, 0) | 0;
  HEAP32[i3 >> 2] = i6;
  HEAP32[i3 + 4 >> 2] = i5;
  HEAP32[i3 + 8 >> 2] = i4;
  i5 = _luaL_error(i1, 4888, i3) | 0;
  STACKTOP = i2;
  return i5 | 0;
 }
 return 0;
}
function _io_open(i1) {
 i1 = i1 | 0;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0;
 i5 = STACKTOP;
 i2 = _luaL_checklstring(i1, 1, 0) | 0;
 i3 = _luaL_optlstring(i1, 2, 3480, 0) | 0;
 i4 = _lua_newuserdata(i1, 8) | 0;
 i6 = i4 + 4 | 0;
 HEAP32[i6 >> 2] = 0;
 _luaL_setmetatable(i1, 2832);
 HEAP32[i4 >> 2] = 0;
 HEAP32[i6 >> 2] = 156;
 i6 = HEAP8[i3] | 0;
 if (!((!(i6 << 24 >> 24 == 0) ? (i7 = i3 + 1 | 0, (_memchr(3552, i6 << 24 >> 24, 4) | 0) != 0) : 0) ? (i6 = (HEAP8[i7] | 0) == 43 ? i3 + 2 | 0 : i7, (HEAP8[(HEAP8[i6] | 0) == 98 ? i6 + 1 | 0 : i6] | 0) == 0) : 0)) {
  _luaL_argerror(i1, 2, 3560) | 0;
 }
 i7 = _fopen(i2 | 0, i3 | 0) | 0;
 HEAP32[i4 >> 2] = i7;
 if ((i7 | 0) != 0) {
  i7 = 1;
  STACKTOP = i5;
  return i7 | 0;
 }
 i7 = _luaL_fileresult(i1, 0, i2) | 0;
 STACKTOP = i5;
 return i7 | 0;
}
function _unpack(i2) {
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i4 = 0, i5 = 0, i6 = 0, i7 = 0;
 i1 = STACKTOP;
 STACKTOP = STACKTOP + 16 | 0;
 i6 = i1;
 _luaL_checktype(i2, 1, 5);
 i5 = _luaL_optinteger(i2, 2, 1) | 0;
 if ((_lua_type(i2, 3) | 0) < 1) {
  i3 = _luaL_len(i2, 1) | 0;
 } else {
  i3 = _luaL_checkinteger(i2, 3) | 0;
 }
 if ((i5 | 0) > (i3 | 0)) {
  i6 = 0;
  STACKTOP = i1;
  return i6 | 0;
 }
 i7 = i3 - i5 | 0;
 i4 = i7 + 1 | 0;
 if ((i7 | 0) >= 0 ? (_lua_checkstack(i2, i4) | 0) != 0 : 0) {
  _lua_rawgeti(i2, 1, i5);
  if ((i5 | 0) >= (i3 | 0)) {
   i7 = i4;
   STACKTOP = i1;
   return i7 | 0;
  }
  do {
   i5 = i5 + 1 | 0;
   _lua_rawgeti(i2, 1, i5);
  } while ((i5 | 0) != (i3 | 0));
  STACKTOP = i1;
  return i4 | 0;
 }
 i7 = _luaL_error(i2, 8280, i6) | 0;
 STACKTOP = i1;
 return i7 | 0;
}
function _luaF_getlocalname(i4, i6, i2) {
 i4 = i4 | 0;
 i6 = i6 | 0;
 i2 = i2 | 0;
 var i1 = 0, i3 = 0, i5 = 0;
 i1 = STACKTOP;
 i3 = HEAP32[i4 + 60 >> 2] | 0;
 if ((i3 | 0) <= 0) {
  i6 = 0;
  STACKTOP = i1;
  return i6 | 0;
 }
 i4 = HEAP32[i4 + 24 >> 2] | 0;
 i5 = 0;
 while (1) {
  if ((HEAP32[i4 + (i5 * 12 | 0) + 4 >> 2] | 0) > (i2 | 0)) {
   i3 = 0;
   i2 = 8;
   break;
  }
  if ((HEAP32[i4 + (i5 * 12 | 0) + 8 >> 2] | 0) > (i2 | 0)) {
   i6 = i6 + -1 | 0;
   if ((i6 | 0) == 0) {
    i2 = 6;
    break;
   }
  }
  i5 = i5 + 1 | 0;
  if ((i5 | 0) >= (i3 | 0)) {
   i3 = 0;
   i2 = 8;
   break;
  }
 }
 if ((i2 | 0) == 6) {
  i6 = (HEAP32[i4 + (i5 * 12 | 0) >> 2] | 0) + 16 | 0;
  STACKTOP = i1;
  return i6 | 0;
 } else if ((i2 | 0) == 8) {
  STACKTOP = i1;
  return i3 | 0;
 }
 return 0;
}
function _luaK_concat(i1, i4, i3) {
 i1 = i1 | 0;
 i4 = i4 | 0;
 i3 = i3 | 0;
 var i2 = 0, i5 = 0, i6 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 if ((i3 | 0) == -1) {
  STACKTOP = i2;
  return;
 }
 i7 = HEAP32[i4 >> 2] | 0;
 if ((i7 | 0) == -1) {
  HEAP32[i4 >> 2] = i3;
  STACKTOP = i2;
  return;
 }
 i4 = HEAP32[(HEAP32[i1 >> 2] | 0) + 12 >> 2] | 0;
 while (1) {
  i6 = i4 + (i7 << 2) | 0;
  i5 = HEAP32[i6 >> 2] | 0;
  i8 = (i5 >>> 14) + -131071 | 0;
  if ((i8 | 0) == -1) {
   break;
  }
  i8 = i7 + 1 + i8 | 0;
  if ((i8 | 0) == -1) {
   break;
  } else {
   i7 = i8;
  }
 }
 i3 = ~i7 + i3 | 0;
 if ((((i3 | 0) > -1 ? i3 : 0 - i3 | 0) | 0) > 131071) {
  _luaX_syntaxerror(HEAP32[i1 + 12 >> 2] | 0, 10624);
 }
 HEAP32[i6 >> 2] = i5 & 16383 | (i3 << 14) + 2147467264;
 STACKTOP = i2;
 return;
}
function _scalbn(d3, i2) {
 d3 = +d3;
 i2 = i2 | 0;
 var i1 = 0, i4 = 0;
 i1 = STACKTOP;
 if ((i2 | 0) > 1023) {
  d3 = d3 * 8.98846567431158e+307;
  i4 = i2 + -1023 | 0;
  if ((i4 | 0) > 1023) {
   i2 = i2 + -2046 | 0;
   i2 = (i2 | 0) > 1023 ? 1023 : i2;
   d3 = d3 * 8.98846567431158e+307;
  } else {
   i2 = i4;
  }
 } else {
  if ((i2 | 0) < -1022) {
   d3 = d3 * 2.2250738585072014e-308;
   i4 = i2 + 1022 | 0;
   if ((i4 | 0) < -1022) {
    i2 = i2 + 2044 | 0;
    i2 = (i2 | 0) < -1022 ? -1022 : i2;
    d3 = d3 * 2.2250738585072014e-308;
   } else {
    i2 = i4;
   }
  }
 }
 i2 = _bitshift64Shl(i2 + 1023 | 0, 0, 52) | 0;
 i4 = tempRet0;
 HEAP32[tempDoublePtr >> 2] = i2;
 HEAP32[tempDoublePtr + 4 >> 2] = i4;
 d3 = d3 * +HEAPF64[tempDoublePtr >> 3];
 STACKTOP = i1;
 return +d3;
}
function _luaK_numberK(i1, d6) {
 i1 = i1 | 0;
 d6 = +d6;
 var i2 = 0, i3 = 0, i4 = 0, i5 = 0, i7 = 0, i8 = 0;
 i2 = STACKTOP;
 STACKTOP = STACKTOP + 32 | 0;
 i4 = i2 + 16 | 0;
 i3 = i2;
 HEAPF64[i4 >> 3] = d6;
 i5 = HEAP32[(HEAP32[i1 + 12 >> 2] | 0) + 52 >> 2] | 0;
 HEAPF64[i3 >> 3] = d6;
 HEAP32[i3 + 8 >> 2] = 3;
 if (d6 != d6 | 0.0 != 0.0 | d6 == 0.0) {
  i7 = i5 + 8 | 0;
  i8 = HEAP32[i7 >> 2] | 0;
  HEAP32[i7 >> 2] = i8 + 16;
  i5 = _luaS_newlstr(i5, i4, 8) | 0;
  HEAP32[i8 >> 2] = i5;
  HEAP32[i8 + 8 >> 2] = HEAPU8[i5 + 4 | 0] | 0 | 64;
  i5 = _addk(i1, (HEAP32[i7 >> 2] | 0) + -16 | 0, i3) | 0;
  HEAP32[i7 >> 2] = (HEAP32[i7 >> 2] | 0) + -16;
  STACKTOP = i2;
  return i5 | 0;
 } else {
  i8 = _addk(i1, i3, i3) | 0;
  STACKTOP = i2;
  return i8 | 0;
 }
 return 0;
}
function _auxresume(i2, i3, i4) {
 i2 = i2 | 0;
 i3 = i3 | 0;
 i4 = i4 | 0;
 var i1 = 0;
 i1 = STACKTOP;
 do {
  if ((_lua_checkstack(i3, i4) | 0) != 0) {
   if ((_lua_status(i3) | 0) == 0 ? (_lua_gettop(i3) | 0) == 0 : 0) {
    _lua_pushlstring(i2, 10792, 28) | 0;
    i4 = -1;
    break;
   }
   _lua_xmove(i2, i3, i4);
   if (!((_lua_resume(i3, i2, i4) | 0) >>> 0 < 2)) {
    _lua_xmove(i3, i2, 1);
    i4 = -1;
    break;
   }
   i4 = _lua_gettop(i3) | 0;
   if ((_lua_checkstack(i2, i4 + 1 | 0) | 0) == 0) {
    _lua_settop(i3, ~i4);
    _lua_pushlstring(i2, 10824, 26) | 0;
    i4 = -1;
    break;
   } else {
    _lua_xmove(i3, i2, i4);
    break;
   }
  } else {
   _lua_pushlstring(i2, 10760, 28) | 0;
   i4 = -1;
  }
 } while (0);
 STACKTOP = i1;
 return i4 | 0;
}
function _luaX_setinput(i2, i1, i4, i3, i5) {
 i2 = i2 | 0;
 i1 = i1 | 0;
 i4 = i4 | 0;
 i3 = i3 | 0;
 i5 = i5 | 0;
 var i6 = 0, i7 = 0;
 i6 = STACKTOP;
 HEAP8[i1 + 76 | 0] = 46;
 i7 = i1 + 52 | 0;
 HEAP32[i7 >> 2] = i2;
 HEAP32[i1 >> 2] = i5;
 HEAP32[i1 + 32 >> 2] = 286;
 HEAP32[i1 + 56 >> 2] = i4;
 HEAP32[i1 + 48 >> 2] = 0;
 HEAP32[i1 + 4 >> 2] = 1;
 HEAP32[i1 + 8 >> 2] = 1;
 HEAP32[i1 + 68 >> 2] = i3;
 i5 = _luaS_new(i2, 12264) | 0;
 HEAP32[i1 + 72 >> 2] = i5;
 i5 = i5 + 5 | 0;
 HEAP8[i5] = HEAPU8[i5] | 0 | 32;
 i5 = i1 + 60 | 0;
 i4 = HEAP32[i5 >> 2] | 0;
 i4 = _luaM_realloc_(HEAP32[i7 >> 2] | 0, HEAP32[i4 >> 2] | 0, HEAP32[i4 + 8 >> 2] | 0, 32) | 0;
 HEAP32[HEAP32[i5 >> 2] >> 2] = i4;
 HEAP32[(HEAP32[i5 >> 2] | 0) + 8 >> 2] = 32;
 STACKTOP = i6;
 return;
}
function _luaL_optlstring(i2, i4